package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD020Index.html" target="_blank">SquawLOD020</a>,  source <a href="../../../Geospatial/SquawLOD020.java">SquawLOD020.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD020.x3d">SquawLOD020.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD020.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD020.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD020
{
	/** Default constructor to create this object. */
	public SquawLOD020 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD020.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD020.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD020.x3d"))
    .addChild(new GeoLOD().setCenter(4342525.411173,741821.999947,1974.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(16133.333).setChild1Url(new String[] {"SquawLOD021.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD021.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw010.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw010.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4341718.744506,741212.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(25).setXSpacing(50.750000).setZDimension(33).setZSpacing(50.416667).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2022.9431,2012.7931,2005.8215,2001.9839,2000.0,1994.8069,1987.4316,1962.3215,1939.9358,1928.7216,1920.5266,1914.1465,1908.3743,1901.125,1897.05,1893.8683,1889.7715,1884.2405,1876.0,1878.0417,1881.477,1886.475,1898.2,1920.125,1947.5,2028.175,2015.9281,2007.7812,1998.7656,1991.175,1987.975,1982.6312,1963.875,1941.0,1931.85,1926.35,1916.0062,1910.4,1904.7656,1900.875,1899.75,1901.85,1901.5094,1881.3438,1876.0,1878.45,1885.475,1896.2,1918.8281,1944.325,2029.3,2017.05,2007.9458,1998.75,1988.4,1975.5563,1968.5209,1955.2812,1938.0416,1932.425,1928.35,1921.6583,1915.75,1917.6562,1915.6708,1914.6438,1911.9083,1907.5667,1895.4166,1876.0,1879.4,1885.475,1895.65,1916.4688,1947.0917,2036.0792,2022.0323,2012.8667,2006.6666,1999.275,1982.8167,1964.5583,1948.7427,1936.5,1928.4667,1925.3771,1923.9812,1929.375,1932.0781,1930.9166,1925.975,1917.8583,1910.475,1895.2604,1876.0,1885.1417,1892.875,1900.5896,1922.6666,1953.1583};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2047.2,2033.05,2022.95,2015.875,2006.4,1992.175,1973.25,1953.3,1938.5,1926.85,1922.35,1922.0,1926.0,1930.0,1928.05,1920.95,1914.9,1904.475,1884.5,1876.325,1890.2,1903.475,1911.1,1930.125,1958.9,2058.325,2045.199,2034.9855,2026.8334,2014.6833,1996.2052,1974.6,1956.7489,1941.5209,1927.275,1918.6583,1918.6833,1923.525,1926.9584,1925.9604,1917.9333,1903.475,1886.099,1876.0,1879.6917,1892.2,1903.9083,1913.65,1932.1823,1964.6417,2071.4666,2058.323,2045.1167,2038.8334,2024.3,1999.7916,1977.7667,1960.8562,1944.5834,1929.275,1916.05,1913.6417,1914.7167,1919.9062,1925.95,1910.8541,1881.0416,1876.0,1876.3541,1884.8167,1896.4166,1902.077,1915.2,1937.6354,1970.1083,2084.55,2070.3032,2061.275,2048.875,2031.125,2007.75,1985.1562,1967.425,1948.125,1931.9031,1919.7438,1911.275,1910.675,1913.6406,1923.1813,1911.3313,1876.0,1879.475,1885.5,1893.3093,1906.05,1913.6656,1918.025,1944.75,1976.025};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2094.6167,2082.221,2073.9084,2056.6458,2033.6666,2009.9,1988.1417,1968.3708,1952.5834,1935.4417,1922.8667,1912.275,1904.2333,1905.7084,1906.6666,1892.8667,1876.0,1884.6917,1898.2916,1907.9833,1915.5667,1920.8083,1924.8833,1942.9584,1971.1666,2098.1,2083.8667,2067.0166,2051.5938,2028.625,2008.6917,1988.6,1970.8448,1955.0,1939.9386,1927.1854,1916.7583,1907.65,1897.276,1889.4646,1881.7667,1875.1,1890.525,1904.3021,1914.3927,1920.925,1928.3667,1937.0604,1938.25,1961.0834,2084.65,2076.5938,2053.5,2036.0,2020.7,2002.2188,1984.5375,1969.9062,1952.5,1941.1687,1929.7,1918.3688,1908.3,1895.0938,1879.8875,1874.7312,1878.725,1892.775,1905.9375,1916.65,1925.75,1937.2,1945.35,1951.875,1958.475,2066.2876,2065.7761,2048.8147,2030.9166,2014.2,1995.625,1974.6583,1963.725,1944.7709,1931.551,1926.7667,1913.0469,1896.925,1883.7188,1875.05,1878.6333,1890.7542,1899.8823,1909.7916,1921.4635,1933.3833,1940.7667,1949.7104,1954.9166,1960.9917};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2055.1,2063.3083,2055.1333,2034.9584,2017.7333,1997.1083,1971.95,1955.0583,1936.3334,1917.9917,1913.4667,1899.825,1882.1333,1873.25,1873.9333,1886.3833,1896.5333,1905.6833,1915.5,1926.65,1938.5333,1943.475,1948.55,1956.25,1965.7667,2042.475,2055.2,2054.525,2039.1719,2018.2,1994.7969,1972.25,1948.875,1923.5,1911.05,1899.325,1886.075,1873.525,1867.75,1875.2438,1891.7906,1899.575,1909.4156,1917.25,1925.5281,1937.425,1941.625,1947.55,1957.625,1970.475,2025.35,2041.6896,2042.7875,2029.8646,2013.3667,1991.4833,1970.1833,1949.2104,1922.5,1908.85,1898.4,1876.2937,1867.7,1874.6354,1891.7333,1901.4417,1904.5167,1910.7583,1915.8334,1921.2333,1927.9667,1938.6438,1950.5167,1963.4479,1976.1167,2011.6833,2026.575,2025.525,2014.375,2004.05,1988.5073,1966.6,1943.6802,1922.5,1909.275,1894.4,1870.3667,1863.0,1886.9584,1899.3354,1905.0115,1906.0,1905.0032,1908.6979,1917.65,1927.2,1941.425,1955.1083,1970.3334,1982.1792};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {1999.75,2011.475,2008.95,2004.9375,1999.1,1990.0875,1968.25,1943.1625,1924.25,1908.5625,1892.725,1867.825,1868.5,1888.125,1899.4,1902.4875,1899.4,1894.675,1904.25,1916.15,1927.2,1941.425,1956.65,1973.875,1987.05,1986.2208,1993.3615,1995.375,1993.8334,1990.2833,1989.4584,1972.525,1945.075,1925.3125,1906.7,1888.5062,1868.2177,1866.225,1883.1406,1890.4584,1889.35,1886.275,1886.8083,1902.5521,1915.65,1928.7417,1943.2073,1956.65,1973.7031,1989.4,1969.675,1977.2104,1981.0625,1978.125,1974.7167,1974.525,1974.6292,1958.6979,1936.6666,1906.9563,1883.7792,1870.2479,1862.1167,1868.9271,1876.2,1877.2396,1875.4166,1880.6271,1898.5834,1916.5583,1929.1833,1945.425,1960.2333,1974.7188,1990.8083,1953.3,1961.475,1964.175,1966.75,1966.375,1964.2031,1959.1813,1950.475,1936.375,1912.4844,1890.025,1875.175,1863.9,1862.0,1864.375,1865.3844,1869.6375,1883.525,1902.1562,1920.3969,1936.975,1950.2,1964.1062,1979.125,1994.6125};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1942.5667,1945.65,1948.0,1949.4584,1954.2,1954.6666,1949.4,1940.2417,1927.1666,1909.8917,1890.7333,1878.55,1868.0667,1862.7084,1862.0,1862.0,1871.0667,1887.1917,1903.5,1920.3083,1938.2,1952.425,1969.2,1983.875,1998.1,1934.5542,1935.5834,1934.8396,1932.9115,1936.3667,1939.1666,1935.2188,1923.7417,1914.875,1902.8583,1887.452,1879.3552,1871.3417,1865.0885,1863.0,1862.0,1867.9542,1885.8677,1902.75,1917.2667,1933.4917,1950.1917,1967.4917,1982.4323,1995.4791,1928.25,1927.5,1924.1625,1917.625,1917.0,1915.7937,1910.2,1904.0,1901.375,1889.1375,1882.95,1877.3438,1872.2,1867.0938,1864.7625,1863.0,1862.25,1875.2,1896.5,1911.475,1926.3,1942.4,1959.9,1976.2188,1987.4,1919.4375,1917.4166,1915.4062,1908.0677,1901.625,1900.35,1891.925,1885.8718,1883.5209,1881.7532,1877.7667,1875.0573,1871.2,1868.099,1865.05,1863.9802,1862.0,1865.2916,1887.125,1895.2552,1918.6833,1939.0094,1958.4083,1974.0834,1989.1};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1903.7667,1905.475,1907.2833,1904.0209,1888.8334,1887.1208,1882.8167,1877.6708,1876.0,1876.0,1875.0583,1872.0458,1869.3334,1867.125,1865.0083,1863.1625,1862.0,1862.3125,1869.75,1887.6875,1912.2667,1933.7084,1952.9833,1969.7291,1990.8,1888.125,1892.2,1898.25,1897.2344,1888.8,1883.8157,1877.0813,1876.0,1875.0,1874.0,1872.4313,1869.3656,1867.025,1865.0,1863.0062,1861.1218,1860.0,1861.0,1864.5,1879.5406,1906.65,1926.9,1946.8063,1969.375,1990.5,1886.0,1887.0,1889.0875,1889.9584,1887.0667,1882.725,1878.9708,1876.0,1874.5,1872.4729,1870.4042,1868.023,1865.0167,1863.0,1861.1292,1859.0813,1857.0,1859.0145,1863.5625,1883.1917,1911.9166,1930.2583,1946.6958,1968.5834,1988.8583,1883.0375,1884.0416,1885.0416,1883.9219,1881.075,1880.0416,1879.0271,1876.575,1874.0,1872.0,1869.35,1867.0115,1865.0,1862.0052,1860.0,1856.9761,1854.9,1856.1823,1862.2604,1884.2615,1913.0,1936.8583,1955.6438,1973.3906,1990.6875};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1881.0,1881.0,1880.0,1878.875,1877.0,1877.0,1876.65,1876.0,1874.0,1871.0,1869.0,1867.0,1865.0,1862.0,1858.05,1855.0,1852.0,1853.35,1861.5,1882.95,1914.4,1941.9,1963.75,1983.5,2004.1,1879.9584,1879.0,1877.9979,1876.8385,1876.0,1875.0,1874.9584,1874.551,1873.0,1871.0,1869.0,1867.0,1865.0,1862.125,1859.0021,1855.0406,1851.9,1854.175,1862.2188,1879.5864,1915.4166,1944.9,1967.75,1988.5,2012.1417,1877.9166,1877.0,1876.0,1875.0,1874.9333,1873.725,1873.0,1872.0,1872.0,1870.425,1869.0,1867.023,1865.2667,1864.1979,1862.0834,1857.0563,1852.075,1852.175,1860.5,1878.8667,1914.7667,1942.7667,1966.6666,1988.4688,2012.775,1876.0125,1876.0,1875.0,1874.8906,1874.0,1873.6344,1872.0,1871.0,1871.0,1870.3718,1869.0,1869.0,1867.2,1866.0,1865.0,1858.975,1853.9,1851.0,1859.75,1875.7094,1909.025,1934.9594,1963.6813,1984.8281,2008.375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1878.1666,1877.1666,1876.1583,1876.0,1874.8334,1872.9542,1869.8334,1869.0,1869.0,1869.0,1869.0,1869.0,1868.0,1866.125,1865.0,1859.975,1853.9,1851.0,1860.75,1877.3,1906.3667,1936.6833,1962.0333,1981.2291,2000.4667};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.04167,0.00391,0.08333,0.00391,0.125,0.00391,0.16667,0.00391,0.20833,0.00391,0.25,0.00391,0.29167,0.00391,0.33333,0.00391,0.375,0.00391,0.41667,0.00391,0.45833,0.00391,0.5,0.00391,0.54167,0.00391,0.58333,0.00391,0.625,0.00391,0.66667,0.00391,0.70833,0.00391,0.75,0.00391,0.79167,0.00391,0.83333,0.00391,0.875,0.00391,0.91667,0.00391,0.95833,0.00391,0.99609,0.00391,0.00391,0.03125,0.04167,0.03125,0.08333,0.03125,0.125,0.03125,0.16667,0.03125,0.20833,0.03125,0.25,0.03125,0.29167,0.03125,0.33333,0.03125,0.375,0.03125,0.41667,0.03125,0.45833,0.03125,0.5,0.03125,0.54167,0.03125,0.58333,0.03125,0.625,0.03125,0.66667,0.03125,0.70833,0.03125,0.75,0.03125,0.79167,0.03125,0.83333,0.03125,0.875,0.03125,0.91667,0.03125,0.95833,0.03125,0.99609,0.03125,0.00391,0.0625,0.04167,0.0625,0.08333,0.0625,0.125,0.0625,0.16667,0.0625,0.20833,0.0625,0.25,0.0625,0.29167,0.0625,0.33333,0.0625,0.375,0.0625,0.41667,0.0625,0.45833,0.0625,0.5,0.0625,0.54167,0.0625,0.58333,0.0625,0.625,0.0625,0.66667,0.0625,0.70833,0.0625,0.75,0.0625,0.79167,0.0625,0.83333,0.0625,0.875,0.0625,0.91667,0.0625,0.95833,0.0625,0.99609,0.0625,0.00391,0.09375,0.04167,0.09375,0.08333,0.09375,0.125,0.09375,0.16667,0.09375,0.20833,0.09375,0.25,0.09375,0.29167,0.09375,0.33333,0.09375,0.375,0.09375,0.41667,0.09375,0.45833,0.09375,0.5,0.09375,0.54167,0.09375,0.58333,0.09375,0.625,0.09375,0.66667,0.09375,0.70833,0.09375,0.75,0.09375,0.79167,0.09375,0.83333,0.09375,0.875,0.09375,0.91667,0.09375,0.95833,0.09375,0.99609,0.09375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.00391,0.125,0.04167,0.125,0.08333,0.125,0.125,0.125,0.16667,0.125,0.20833,0.125,0.25,0.125,0.29167,0.125,0.33333,0.125,0.375,0.125,0.41667,0.125,0.45833,0.125,0.5,0.125,0.54167,0.125,0.58333,0.125,0.625,0.125,0.66667,0.125,0.70833,0.125,0.75,0.125,0.79167,0.125,0.83333,0.125,0.875,0.125,0.91667,0.125,0.95833,0.125,0.99609,0.125,0.00391,0.15625,0.04167,0.15625,0.08333,0.15625,0.125,0.15625,0.16667,0.15625,0.20833,0.15625,0.25,0.15625,0.29167,0.15625,0.33333,0.15625,0.375,0.15625,0.41667,0.15625,0.45833,0.15625,0.5,0.15625,0.54167,0.15625,0.58333,0.15625,0.625,0.15625,0.66667,0.15625,0.70833,0.15625,0.75,0.15625,0.79167,0.15625,0.83333,0.15625,0.875,0.15625,0.91667,0.15625,0.95833,0.15625,0.99609,0.15625,0.00391,0.1875,0.04167,0.1875,0.08333,0.1875,0.125,0.1875,0.16667,0.1875,0.20833,0.1875,0.25,0.1875,0.29167,0.1875,0.33333,0.1875,0.375,0.1875,0.41667,0.1875,0.45833,0.1875,0.5,0.1875,0.54167,0.1875,0.58333,0.1875,0.625,0.1875,0.66667,0.1875,0.70833,0.1875,0.75,0.1875,0.79167,0.1875,0.83333,0.1875,0.875,0.1875,0.91667,0.1875,0.95833,0.1875,0.99609,0.1875,0.00391,0.21875,0.04167,0.21875,0.08333,0.21875,0.125,0.21875,0.16667,0.21875,0.20833,0.21875,0.25,0.21875,0.29167,0.21875,0.33333,0.21875,0.375,0.21875,0.41667,0.21875,0.45833,0.21875,0.5,0.21875,0.54167,0.21875,0.58333,0.21875,0.625,0.21875,0.66667,0.21875,0.70833,0.21875,0.75,0.21875,0.79167,0.21875,0.83333,0.21875,0.875,0.21875,0.91667,0.21875,0.95833,0.21875,0.99609,0.21875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.00391,0.25,0.04167,0.25,0.08333,0.25,0.125,0.25,0.16667,0.25,0.20833,0.25,0.25,0.25,0.29167,0.25,0.33333,0.25,0.375,0.25,0.41667,0.25,0.45833,0.25,0.5,0.25,0.54167,0.25,0.58333,0.25,0.625,0.25,0.66667,0.25,0.70833,0.25,0.75,0.25,0.79167,0.25,0.83333,0.25,0.875,0.25,0.91667,0.25,0.95833,0.25,0.99609,0.25,0.00391,0.28125,0.04167,0.28125,0.08333,0.28125,0.125,0.28125,0.16667,0.28125,0.20833,0.28125,0.25,0.28125,0.29167,0.28125,0.33333,0.28125,0.375,0.28125,0.41667,0.28125,0.45833,0.28125,0.5,0.28125,0.54167,0.28125,0.58333,0.28125,0.625,0.28125,0.66667,0.28125,0.70833,0.28125,0.75,0.28125,0.79167,0.28125,0.83333,0.28125,0.875,0.28125,0.91667,0.28125,0.95833,0.28125,0.99609,0.28125,0.00391,0.3125,0.04167,0.3125,0.08333,0.3125,0.125,0.3125,0.16667,0.3125,0.20833,0.3125,0.25,0.3125,0.29167,0.3125,0.33333,0.3125,0.375,0.3125,0.41667,0.3125,0.45833,0.3125,0.5,0.3125,0.54167,0.3125,0.58333,0.3125,0.625,0.3125,0.66667,0.3125,0.70833,0.3125,0.75,0.3125,0.79167,0.3125,0.83333,0.3125,0.875,0.3125,0.91667,0.3125,0.95833,0.3125,0.99609,0.3125,0.00391,0.34375,0.04167,0.34375,0.08333,0.34375,0.125,0.34375,0.16667,0.34375,0.20833,0.34375,0.25,0.34375,0.29167,0.34375,0.33333,0.34375,0.375,0.34375,0.41667,0.34375,0.45833,0.34375,0.5,0.34375,0.54167,0.34375,0.58333,0.34375,0.625,0.34375,0.66667,0.34375,0.70833,0.34375,0.75,0.34375,0.79167,0.34375,0.83333,0.34375,0.875,0.34375,0.91667,0.34375,0.95833,0.34375,0.99609,0.34375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.00391,0.375,0.04167,0.375,0.08333,0.375,0.125,0.375,0.16667,0.375,0.20833,0.375,0.25,0.375,0.29167,0.375,0.33333,0.375,0.375,0.375,0.41667,0.375,0.45833,0.375,0.5,0.375,0.54167,0.375,0.58333,0.375,0.625,0.375,0.66667,0.375,0.70833,0.375,0.75,0.375,0.79167,0.375,0.83333,0.375,0.875,0.375,0.91667,0.375,0.95833,0.375,0.99609,0.375,0.00391,0.40625,0.04167,0.40625,0.08333,0.40625,0.125,0.40625,0.16667,0.40625,0.20833,0.40625,0.25,0.40625,0.29167,0.40625,0.33333,0.40625,0.375,0.40625,0.41667,0.40625,0.45833,0.40625,0.5,0.40625,0.54167,0.40625,0.58333,0.40625,0.625,0.40625,0.66667,0.40625,0.70833,0.40625,0.75,0.40625,0.79167,0.40625,0.83333,0.40625,0.875,0.40625,0.91667,0.40625,0.95833,0.40625,0.99609,0.40625,0.00391,0.4375,0.04167,0.4375,0.08333,0.4375,0.125,0.4375,0.16667,0.4375,0.20833,0.4375,0.25,0.4375,0.29167,0.4375,0.33333,0.4375,0.375,0.4375,0.41667,0.4375,0.45833,0.4375,0.5,0.4375,0.54167,0.4375,0.58333,0.4375,0.625,0.4375,0.66667,0.4375,0.70833,0.4375,0.75,0.4375,0.79167,0.4375,0.83333,0.4375,0.875,0.4375,0.91667,0.4375,0.95833,0.4375,0.99609,0.4375,0.00391,0.46875,0.04167,0.46875,0.08333,0.46875,0.125,0.46875,0.16667,0.46875,0.20833,0.46875,0.25,0.46875,0.29167,0.46875,0.33333,0.46875,0.375,0.46875,0.41667,0.46875,0.45833,0.46875,0.5,0.46875,0.54167,0.46875,0.58333,0.46875,0.625,0.46875,0.66667,0.46875,0.70833,0.46875,0.75,0.46875,0.79167,0.46875,0.83333,0.46875,0.875,0.46875,0.91667,0.46875,0.95833,0.46875,0.99609,0.46875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.00391,0.5,0.04167,0.5,0.08333,0.5,0.125,0.5,0.16667,0.5,0.20833,0.5,0.25,0.5,0.29167,0.5,0.33333,0.5,0.375,0.5,0.41667,0.5,0.45833,0.5,0.5,0.5,0.54167,0.5,0.58333,0.5,0.625,0.5,0.66667,0.5,0.70833,0.5,0.75,0.5,0.79167,0.5,0.83333,0.5,0.875,0.5,0.91667,0.5,0.95833,0.5,0.99609,0.5,0.00391,0.53125,0.04167,0.53125,0.08333,0.53125,0.125,0.53125,0.16667,0.53125,0.20833,0.53125,0.25,0.53125,0.29167,0.53125,0.33333,0.53125,0.375,0.53125,0.41667,0.53125,0.45833,0.53125,0.5,0.53125,0.54167,0.53125,0.58333,0.53125,0.625,0.53125,0.66667,0.53125,0.70833,0.53125,0.75,0.53125,0.79167,0.53125,0.83333,0.53125,0.875,0.53125,0.91667,0.53125,0.95833,0.53125,0.99609,0.53125,0.00391,0.5625,0.04167,0.5625,0.08333,0.5625,0.125,0.5625,0.16667,0.5625,0.20833,0.5625,0.25,0.5625,0.29167,0.5625,0.33333,0.5625,0.375,0.5625,0.41667,0.5625,0.45833,0.5625,0.5,0.5625,0.54167,0.5625,0.58333,0.5625,0.625,0.5625,0.66667,0.5625,0.70833,0.5625,0.75,0.5625,0.79167,0.5625,0.83333,0.5625,0.875,0.5625,0.91667,0.5625,0.95833,0.5625,0.99609,0.5625,0.00391,0.59375,0.04167,0.59375,0.08333,0.59375,0.125,0.59375,0.16667,0.59375,0.20833,0.59375,0.25,0.59375,0.29167,0.59375,0.33333,0.59375,0.375,0.59375,0.41667,0.59375,0.45833,0.59375,0.5,0.59375,0.54167,0.59375,0.58333,0.59375,0.625,0.59375,0.66667,0.59375,0.70833,0.59375,0.75,0.59375,0.79167,0.59375,0.83333,0.59375,0.875,0.59375,0.91667,0.59375,0.95833,0.59375,0.99609,0.59375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.00391,0.625,0.04167,0.625,0.08333,0.625,0.125,0.625,0.16667,0.625,0.20833,0.625,0.25,0.625,0.29167,0.625,0.33333,0.625,0.375,0.625,0.41667,0.625,0.45833,0.625,0.5,0.625,0.54167,0.625,0.58333,0.625,0.625,0.625,0.66667,0.625,0.70833,0.625,0.75,0.625,0.79167,0.625,0.83333,0.625,0.875,0.625,0.91667,0.625,0.95833,0.625,0.99609,0.625,0.00391,0.65625,0.04167,0.65625,0.08333,0.65625,0.125,0.65625,0.16667,0.65625,0.20833,0.65625,0.25,0.65625,0.29167,0.65625,0.33333,0.65625,0.375,0.65625,0.41667,0.65625,0.45833,0.65625,0.5,0.65625,0.54167,0.65625,0.58333,0.65625,0.625,0.65625,0.66667,0.65625,0.70833,0.65625,0.75,0.65625,0.79167,0.65625,0.83333,0.65625,0.875,0.65625,0.91667,0.65625,0.95833,0.65625,0.99609,0.65625,0.00391,0.6875,0.04167,0.6875,0.08333,0.6875,0.125,0.6875,0.16667,0.6875,0.20833,0.6875,0.25,0.6875,0.29167,0.6875,0.33333,0.6875,0.375,0.6875,0.41667,0.6875,0.45833,0.6875,0.5,0.6875,0.54167,0.6875,0.58333,0.6875,0.625,0.6875,0.66667,0.6875,0.70833,0.6875,0.75,0.6875,0.79167,0.6875,0.83333,0.6875,0.875,0.6875,0.91667,0.6875,0.95833,0.6875,0.99609,0.6875,0.00391,0.71875,0.04167,0.71875,0.08333,0.71875,0.125,0.71875,0.16667,0.71875,0.20833,0.71875,0.25,0.71875,0.29167,0.71875,0.33333,0.71875,0.375,0.71875,0.41667,0.71875,0.45833,0.71875,0.5,0.71875,0.54167,0.71875,0.58333,0.71875,0.625,0.71875,0.66667,0.71875,0.70833,0.71875,0.75,0.71875,0.79167,0.71875,0.83333,0.71875,0.875,0.71875,0.91667,0.71875,0.95833,0.71875,0.99609,0.71875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.00391,0.75,0.04167,0.75,0.08333,0.75,0.125,0.75,0.16667,0.75,0.20833,0.75,0.25,0.75,0.29167,0.75,0.33333,0.75,0.375,0.75,0.41667,0.75,0.45833,0.75,0.5,0.75,0.54167,0.75,0.58333,0.75,0.625,0.75,0.66667,0.75,0.70833,0.75,0.75,0.75,0.79167,0.75,0.83333,0.75,0.875,0.75,0.91667,0.75,0.95833,0.75,0.99609,0.75,0.00391,0.78125,0.04167,0.78125,0.08333,0.78125,0.125,0.78125,0.16667,0.78125,0.20833,0.78125,0.25,0.78125,0.29167,0.78125,0.33333,0.78125,0.375,0.78125,0.41667,0.78125,0.45833,0.78125,0.5,0.78125,0.54167,0.78125,0.58333,0.78125,0.625,0.78125,0.66667,0.78125,0.70833,0.78125,0.75,0.78125,0.79167,0.78125,0.83333,0.78125,0.875,0.78125,0.91667,0.78125,0.95833,0.78125,0.99609,0.78125,0.00391,0.8125,0.04167,0.8125,0.08333,0.8125,0.125,0.8125,0.16667,0.8125,0.20833,0.8125,0.25,0.8125,0.29167,0.8125,0.33333,0.8125,0.375,0.8125,0.41667,0.8125,0.45833,0.8125,0.5,0.8125,0.54167,0.8125,0.58333,0.8125,0.625,0.8125,0.66667,0.8125,0.70833,0.8125,0.75,0.8125,0.79167,0.8125,0.83333,0.8125,0.875,0.8125,0.91667,0.8125,0.95833,0.8125,0.99609,0.8125,0.00391,0.84375,0.04167,0.84375,0.08333,0.84375,0.125,0.84375,0.16667,0.84375,0.20833,0.84375,0.25,0.84375,0.29167,0.84375,0.33333,0.84375,0.375,0.84375,0.41667,0.84375,0.45833,0.84375,0.5,0.84375,0.54167,0.84375,0.58333,0.84375,0.625,0.84375,0.66667,0.84375,0.70833,0.84375,0.75,0.84375,0.79167,0.84375,0.83333,0.84375,0.875,0.84375,0.91667,0.84375,0.95833,0.84375,0.99609,0.84375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.00391,0.875,0.04167,0.875,0.08333,0.875,0.125,0.875,0.16667,0.875,0.20833,0.875,0.25,0.875,0.29167,0.875,0.33333,0.875,0.375,0.875,0.41667,0.875,0.45833,0.875,0.5,0.875,0.54167,0.875,0.58333,0.875,0.625,0.875,0.66667,0.875,0.70833,0.875,0.75,0.875,0.79167,0.875,0.83333,0.875,0.875,0.875,0.91667,0.875,0.95833,0.875,0.99609,0.875,0.00391,0.90625,0.04167,0.90625,0.08333,0.90625,0.125,0.90625,0.16667,0.90625,0.20833,0.90625,0.25,0.90625,0.29167,0.90625,0.33333,0.90625,0.375,0.90625,0.41667,0.90625,0.45833,0.90625,0.5,0.90625,0.54167,0.90625,0.58333,0.90625,0.625,0.90625,0.66667,0.90625,0.70833,0.90625,0.75,0.90625,0.79167,0.90625,0.83333,0.90625,0.875,0.90625,0.91667,0.90625,0.95833,0.90625,0.99609,0.90625,0.00391,0.9375,0.04167,0.9375,0.08333,0.9375,0.125,0.9375,0.16667,0.9375,0.20833,0.9375,0.25,0.9375,0.29167,0.9375,0.33333,0.9375,0.375,0.9375,0.41667,0.9375,0.45833,0.9375,0.5,0.9375,0.54167,0.9375,0.58333,0.9375,0.625,0.9375,0.66667,0.9375,0.70833,0.9375,0.75,0.9375,0.79167,0.9375,0.83333,0.9375,0.875,0.9375,0.91667,0.9375,0.95833,0.9375,0.99609,0.9375,0.00391,0.96875,0.04167,0.96875,0.08333,0.96875,0.125,0.96875,0.16667,0.96875,0.20833,0.96875,0.25,0.96875,0.29167,0.96875,0.33333,0.96875,0.375,0.96875,0.41667,0.96875,0.45833,0.96875,0.5,0.96875,0.54167,0.96875,0.58333,0.96875,0.625,0.96875,0.66667,0.96875,0.70833,0.96875,0.75,0.96875,0.79167,0.96875,0.83333,0.96875,0.875,0.96875,0.91667,0.96875,0.95833,0.96875,0.99609,0.96875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.99609,0.04167,0.99609,0.08333,0.99609,0.125,0.99609,0.16667,0.99609,0.20833,0.99609,0.25,0.99609,0.29167,0.99609,0.33333,0.99609,0.375,0.99609,0.41667,0.99609,0.45833,0.99609,0.5,0.99609,0.54167,0.99609,0.58333,0.99609,0.625,0.99609,0.66667,0.99609,0.70833,0.99609,0.75,0.99609,0.79167,0.99609,0.83333,0.99609,0.875,0.99609,0.91667,0.99609,0.95833,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 825 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 1650 total numbers made up of 825 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD020 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD020().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD020\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD020 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD020_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD020_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD020_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD020_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
