####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD019.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD019.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD019.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD019.x3d'),
    GeoLOD(center=(4340924.904807,741821.999947,2014.5),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw009.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw009.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,741212.999947,0),geoSystem=["UTM","Z10","N"],height=[2080.8928,2077.7625,2073.441,2069.2266,2072.5388,2082.1807,2090.9248,2098.9897,2106.3115,2112.745,2117.9546,2123.0432,2127.6985,2131.5706,2134.1487,2135.8745,2142.4004,2148.4202,2156.3164,2159.1558,2158.5737,2155.7327,2148.8108,2142.431,2135.8184,2129.087,2120.5789,2113.271,2107.0398,2101.0427,2094.347,2087.4548,2079.879,2069.6416,2055.2297,2039.4539,2024.8818,2013.455,2003.3213,1995.4355,1987.8851,1979.8839,1972.4508,1964.2036,1955.9796,1950.7368,1943.1716,1936.1118,1928.9999,1918.8047,1907.6606,2067.0388,2063.8281,2059.5315,2057.3325,2061.7124,2074.8909,2083.646,2090.486,2097.2188,2102.0908,2106.5635,2109.5986,2112.2705,2115.8633,2119.8906,2124.6848,2135.0688,2143.518,2149.1133,2152.7405,2152.0483,2148.6094,2143.7373,2138.8755,2133.6802,2125.6328,2118.1526,2111.8447,2105.5366,2098.8362,2091.938,2084.5547,2075.4526,2063.854,2050.1013,2035.083,2023.533,2012.84,1999.5948,1986.5626,1976.222,1967.9755,1960.6675,1953.3595,1946.0515,1938.0842,1928.4734,1921.5195,1914.9348,1909.2843,1901.6771,2051.1414,2049.271,2047.4005,2046.1725,2051.958,2064.6526,2075.5596,2081.6147,2087.514,2091.92,2094.998,2097.1724,2098.2297,2099.4192,2103.1885,2113.938,2127.0642,2136.6287,2142.0515,2145.3035,2145.5183,2143.757,2139.885,2135.5378,2129.777,2122.1213,2115.161,2108.7104,2103.1106,2097.3464,2090.06,2081.5168,2071.461,2057.266,2044.6584,2032.7944,2022.7915,2012.2426,1998.0945,1985.48,1972.4277,1958.1315,1948.982,1941.2285,1933.3185,1925.178,1917.3293,1910.5195,1905.082,1900.605,1897.169,2039.1332,2037.7,2035.2694,2033.2346,2041.9001,2054.3533,2063.1138,2070.8896,2076.2056,2081.6826,2084.3015,2085.7317,2084.0498,2083.0498,2089.0615,2102.6814,2116.4204,2127.9749,2134.521,2137.2156,2139.025,2138.0244,2136.0283,2132.1523,2125.2856,2118.6084,2111.3086,2105.6643,2100.7922,2095.3726,2088.0684,2080.336,2069.74,2055.5576,2043.3777,2032.2013,2021.0283,2008.8563,1995.6683,1983.4883,1970.2883,1955.1283,1941.7463,1929.7957,1921.8645,1915.4731,1909.1133,1902.2408,1898.3591,1895.7526,1892.3165,2030.3284,2028.4103,2025.6516,2026.5782,2036.533,2044.9529,2051.1448,2055.9507,2062.0127,2067.1406,2069.1704,2070.9104,2071.9104,2072.4785,2078.9282,2091.2944,2104.2183,2116.8708,2125.6777,2130.9302,2133.0054,2133.7136,2131.4666,2127.308,2121.702,2115.1821,2108.11,2102.7664,2097.9934,2092.4941,2087.0518,2080.092,2069.74,2055.978,2044.2194,2032.2,2019.7709,2005.3767,1992.0465,1980.6442,1967.9263,1952.9261,1938.5221,1926.9901,1917.295,1909.6041,1902.2961,1898.1901,1894.4081,1890.7465,1888.582,2021.5392,2019.1074,2016.0074,2021.1438,2030.4446,2036.7035,2038.8599,2039.9279,2046.0994,2053.4072,2057.2993,2059.4753,2060.644,2060.7795,2068.6436,2081.8235,2093.1274,2104.2908,2115.5588,2123.5244,2126.932,2127.459,2125.899,2123.3838,2118.2197,2111.7559,2105.448,2099.8118,2094.94,2090.5981,2086.04,2078.843,2069.74,2056.56,2044.38,2032.2,2019.828,2003.808,1988.3479,1976.7769,1965.4028,1950.4999,1937.0629,1924.9159,1914.82,1906.596,1900.0577,1895.372,1890.6558,1888.1147,1888.0,2009.6484,2007.4032,2008.1697,2013.9648,2021.6766,2024.67,2026.1644,2030.0801,2034.5184,2040.5668,2044.9084,2047.3445,2047.9187,2049.7395,2059.212,2073.2378,2084.3323,2093.3528,2103.4565,2114.2502,2120.436,2122.189,2120.9673,2117.8542,2114.0017,2108.3296,2101.8152,2096.297,2092.2725,2088.1858,2083.7698,2076.8977,2068.4697,2054.8093,2043.1097,2030.9297,2018.6096,2003.808,1988.3185,1975.48,1964.0297,1949.0737,1935.8827,1922.4897,1911.3937,1902.6605,1897.8176,1892.9457,1888.9481,1888.0,1888.0,1997.214,1998.0125,2001.6133,2006.5344,2010.8579,2012.6531,2017.4487,2023.4775,2028.3829,2031.7345,2034.4739,2036.214,2037.346,2043.01,2052.6243,2064.024,2075.8042,2083.6707,2092.2058,2101.557,2110.1892,2114.2139,2114.9104,2113.629,2110.686,2105.207,2098.0632,2092.9595,2089.1204,2085.3806,2079.667,2073.775,2062.7983,2050.6711,2039.7109,2028.5035,2016.3235,2003.1338,1989.192,1975.7544,1962.7231,1948.188,1934.8195,1920.0635,1908.271,1900.2634,1895.3915,1890.7925,1888.0522,1888.0,1888.0,1988.7196,1988.68,1994.8531,1999.7427,2002.9198,2005.6691,2011.1798,2017.4938,2022.0675,2025.4558,2026.8918,2028.3279,2032.0186,2037.9569,2046.6438,2055.3918,2065.1357,2073.445,2080.7532,2088.1223,2098.0652,2106.6455,2108.3088,2108.7546,2106.5132,2101.4773,2095.499,2090.5332,2085.5386,2080.056,2072.569,2063.7734,2053.9785,2044.3925,2034.1007,2023.8318,2011.8477,2001.7173,1988.1267,1973.4532,1960.1772,1946.2488,1931.4193,1917.6373,1904.5413,1897.9011,1892.9653,1889.1414,1888.0,1888.0,1888.0,1980.8043,1982.3898,1986.7944,1991.1265,1994.8018,1997.5132,2003.9012,2010.2572,2015.1293,2018.6295,2020.9021,2022.9802,2028.1661,2033.0382,2038.8185,2046.8717,2056.3083,2064.2893,2072.1216,2080.5552,2092.622,2101.563,2104.943,2105.4512,2103.8872,2099.6511,2094.3984,2088.287,2082.1758,2075.3235,2064.455,2054.461,2044.413,2035.8104,2027.4573,2016.6254,2007.1141,1998.7102,1984.8021,1971.4348,1958.4111,1943.5931,1928.2747,1914.8553,1902.748,1896.6746,1891.1078,1888.0,1888.0,1888.0,1888.0,1973.0746,1975.4106,1979.6187,1983.2826,1985.7346,1990.3126,1996.6227,2002.9786,2008.4626,2011.8943,2016.5632,2020.4169,2024.3104,2028.607,2033.0577,2038.8485,2046.7244,2056.9858,2067.765,2077.9607,2089.7449,2099.137,2103.0122,2103.025,2101.2969,2098.205,2093.2979,2087.0007,2080.6787,2073.3928,2060.126,2050.3608,2039.786,2029.8977,2020.1786,2009.5907,2001.8678,1989.9628,1979.1777,1966.6482,1954.3497,1937.8473,1925.7529,1912.4329,1901.7501,1895.96,1890.0891,1888.0,1888.0,1888.0,1888.0,1965.3947,1968.3331,1972.0302,1975.004,1979.084,1984.3573,1990.7454,1996.1493,2001.3613,2009.0707,2014.1187,2017.9907,2020.7307,2024.5613,2029.6067,2034.4786,2044.7316,2055.9614,2066.992,2076.4084,2087.45,2096.7107,2100.0906,2100.6277,2099.636,2097.2,2091.9854,2086.656,2078.2314,2069.259,2056.6907,2047.7677,2036.3386,2025.0431,2011.7747,2000.4818,1992.7688,1981.6552,1970.7362,1958.3335,1946.7499,1932.7819,1920.0522,1909.6547,1901.1996,1895.96,1890.132,1888.0,1888.0,1888.0,1888.0,1960.0897,1961.4028,1962.6505,1968.761,1974.1659,1980.5712,1988.121,1992.2489,1998.6576,2005.7866,2012.4325,2014.8685,2017.5862,2022.3085,2028.012,2034.2441,2046.1862,2057.506,2066.373,2075.0608,2085.0325,2092.513,2097.6646,2098.345,2097.8083,2094.7104,2089.7004,2084.8284,2074.8943,2063.7188,2053.425,2043.6809,2032.79,2020.617,2007.1516,1996.5476,1987.7188,1974.2434,1963.6177,1950.2493,1938.0988,1928.2925,1917.94,1909.056,1902.59,1896.3572,1891.088,1888.0,1888.0,1888.0,1888.0,1955.1642,1957.5778,1960.2903,1965.1622,1970.944,1976.6526,1982.2708,1986.4324,1993.7908,2000.7555,2006.5051,2010.1616,2012.5363,2019.4503,2027.016,2036.342,2048.38,2058.936,2066.0542,2072.4355,2081.0688,2087.6045,2092.098,2094.2388,2094.9673,2091.7432,2087.3342,2082.4023,2074.2336,2060.142,2048.5977,2038.8285,2028.2325,2018.3794,2008.5637,1996.7332,1988.212,1977.1018,1964.192,1949.9874,1937.8937,1928.1498,1918.4058,1910.2205,1903.748,1896.44,1890.1208,1888.0,1888.0,1888.0,1889.1776,1950.1521,1953.656,1956.937,1961.5946,1966.3763,1970.8002,1975.6721,1981.5442,1987.8041,1993.6082,1997.717,2002.3522,2007.9939,2016.592,2026.3387,2037.2,2049.0996,2058.936,2064.7354,2069.872,2076.0786,2082.0723,2085.4521,2086.9602,2087.9602,2087.6401,2084.9236,2080.199,2073.568,2059.59,2047.7799,2036.733,2026.592,2017.3639,2009.104,1997.6289,1987.8068,1977.872,1965.192,1953.1599,1940.5375,1929.896,1920.152,1911.4966,1904.6909,1896.44,1889.102,1888.0,1888.0,1888.7644,1890.3799,1945.4816,1949.1238,1952.2498,1956.2037,1960.5001,1966.1339,1971.9259,1977.7927,1983.1107,1986.5056,1990.123,1995.8019,2003.1837,2012.0597,2022.8077,2034.9877,2048.15,2056.7236,2061.6152,2065.1558,2069.9216,2074.6313,2077.1736,2079.5034,2081.0457,2082.5876,2082.5767,2079.2566,2073.568,2060.736,2049.098,2035.8138,2025.3798,2015.6357,2005.815,1995.8986,1985.4037,1975.7339,1964.5538,1953.3739,1941.64,1930.9198,1921.1746,1912.408,1904.5668,1895.3848,1888.0834,1888.0,1888.0879,1890.0281,1891.8062,1938.7886,1942.9178,1946.5859,1952.0917,1958.0985,1964.0953,1968.9673,1973.8394,1977.3234,1980.2269,1983.8492,1990.0233,1997.3931,2006.9773,2017.4211,2029.8372,2043.6589,2051.5593,2055.899,2058.587,2061.4907,2063.4204,2066.528,2069.794,2072.9607,2077.5354,2079.2317,2077.1238,2072.985,2059.9905,2047.0353,2033.061,2018.5414,2008.5653,1997.9746,1988.241,1980.1473,1971.8074,1961.5953,1950.8517,1941.2887,1931.5331,1921.364,1912.408,1903.0869,1892.3877,1888.0,1888.2086,1889.4408,1891.7964,1893.8597,1936.9042,1937.419,1942.367,1949.6654,1955.3562,1961.2396,1965.5789,1969.033,1971.5123,1973.9142,1977.6444,1984.1835,1991.6469,2000.3964,2011.0991,2022.3427,2034.5459,2043.7898,2048.6204,2051.3083,2053.1243,2054.2195,2056.1033,2059.0493,2067.1748,2074.4082,2078.0415,2076.328,2071.398,2054.3164,2041.2244,2028.1952,2012.9355,2001.5895,1989.7574,1982.6029,1975.2949,1965.9963,1955.7844,1947.2374,1939.0215,1930.896,1921.1847,1910.7869,1900.5409,1889.0214,1888.0,1889.0,1890.7865,1893.2335,1896.6586,1934.5153,1935.9513,1939.1593,1946.8545,1952.6555,1956.3905,1961.064,1964.1641,1965.2338,1967.6698,1971.7505,1977.9337,1985.2418,1994.1178,2003.8602,2013.4917,2025.2544,2033.8203,2038.209,2041.7582,2043.93,2045.1323,2048.6343,2055.4158,2065.0713,2073.6,2077.0,2075.2712,2066.0234,2048.5605,2035.7152,2024.336,2014.9198,2004.7806,1992.3193,1982.36,1972.616,1961.8597,1950.7433,1942.5554,1936.2106,1927.9886,1918.1705,1906.8551,1894.0216,1888.0,1888.956,1890.1509,1892.2128,1894.6295,1898.5154,1932.0891,1934.3995,1936.961,1942.7941,1948.1439,1951.4581,1953.9917,1955.7472,1957.1442,1960.2152,1965.0872,1970.9017,1977.0952,1986.3785,1995.5831,2004.433,2014.4258,2023.3802,2027.6456,2030.1293,2031.5653,2033.0466,2039.7242,2051.09,2062.645,2072.2756,2076.2336,2074.656,2063.1833,2050.9019,2037.5566,2026.9579,2018.0939,2007.5055,1994.9149,1984.1709,1973.427,1961.866,1949.128,1939.4021,1933.1691,1926.672,1913.1462,1899.0417,1888.1732,1888.0,1889.0,1890.392,1892.828,1896.1249,1899.6433,1928.9525,1932.9414,1936.3069,1939.7831,1943.3224,1946.6057,1948.6481,1949.4891,1949.7628,1951.2155,1956.8314,1963.3766,1970.7158,1979.1272,1988.3005,1995.6085,2003.6794,2010.9874,2016.5474,2019.4725,2021.1985,2022.7365,2031.6104,2045.8016,2057.9172,2067.536,2072.5818,2073.0132,2065.0166,2055.1902,2043.8267,2031.9487,2021.8643,2010.0343,1998.8542,1988.8344,1978.949,1967.2899,1953.2605,1939.8359,1932.4766,1925.672,1910.6777,1894.7325,1888.0,1888.6338,1889.956,1891.392,1893.828,1896.4653,1899.7,1927.203,1929.7858,1933.8806,1936.5447,1939.9806,1942.4436,1945.1893,1946.9681,1947.3367,1948.1606,1949.4242,1953.669,1963.4504,1972.282,1980.3612,1988.33,1994.762,2001.739,2006.8427,2011.194,2012.7579,2018.5046,2027.1333,2038.6499,2051.8298,2062.0732,2067.1453,2069.6733,2066.7112,2060.209,2050.42,2037.91,2024.5016,2013.5114,2002.9504,1992.7406,1981.6833,1969.84,1956.3711,1942.208,1932.2021,1923.2031,1907.526,1892.4486,1888.0,1889.0,1890.0,1892.0,1893.828,1896.264,1898.7,1924.9911,1927.642,1931.544,1935.1184,1937.5544,1940.0729,1942.9858,1944.8667,1945.9104,1945.9104,1946.8442,1948.5441,1954.2594,1964.0033,1973.6542,1981.0514,1988.3594,1993.3553,1998.2273,2002.9153,2006.9713,2013.0449,2021.789,2032.4434,2044.4944,2055.8596,2062.0781,2065.553,2066.9202,2064.091,2057.347,2043.6831,2028.0671,2015.9117,2005.104,1993.3457,1981.2449,1968.6289,1953.9233,1941.3818,1928.341,1914.9858,1900.3698,1888.9614,1888.084,1889.0,1890.0,1892.392,1893.828,1896.1744,1897.0,1924.9,1926.672,1930.6544,1934.3153,1937.1598,1940.0413,1942.516,1943.9752,1943.2842,1942.5751,1941.4528,1942.8447,1947.3645,1955.7247,1965.4667,1974.044,1980.6289,1986.0768,1990.9487,1995.7317,1999.6927,2007.1636,2016.4208,2026.1648,2035.085,2047.0338,2055.645,2061.3125,2064.132,2065.705,2062.0813,2049.6353,2032.1438,2016.9272,2004.3572,1988.6262,1975.1654,1961.745,1946.8713,1932.4845,1917.0302,1902.2424,1890.205,1887.8185,1888.084,1889.0,1890.956,1892.392,1893.828,1895.264,1896.7,1924.0,1926.672,1930.544,1935.3579,1939.2506,1943.022,1944.9138,1945.0323,1942.612,1940.0103,1937.7981,1937.0984,1940.6205,1948.4462,1957.1902,1965.9667,1973.7513,1979.7401,1984.6267,1989.3108,1993.4142,2000.3981,2009.6206,2018.012,2027.2872,2035.4786,2044.9982,2052.2483,2058.2822,2061.116,2061.174,2055.0059,2035.2739,2018.6547,2001.974,1983.7385,1965.4753,1951.0721,1935.9231,1919.8662,1905.1144,1892.2361,1887.0458,1887.0,1888.084,1889.0,1890.956,1892.392,1893.828,1895.0,1896.0,1924.0,1926.5483,1930.544,1936.2845,1940.8811,1945.5282,1949.2523,1950.3682,1944.0812,1938.9839,1936.3718,1935.3279,1936.6804,1941.3265,1949.9115,1958.3776,1966.5236,1972.8315,1977.919,1982.6317,1987.1355,1994.0841,2002.5526,2010.634,2018.2175,2026.2955,2032.6312,2037.6804,2043.2708,2047.6232,2049.1519,2048.2175,2035.6134,2020.252,2002.0336,1984.56,1964.232,1946.84,1932.8878,1917.2079,1902.5918,1890.12,1887.0,1886.7615,1888.084,1889.0,1890.0,1892.2477,1893.0,1893.729,1895.3318,1923.9,1926.336,1930.544,1936.416,1941.7996,1947.9543,1951.4099,1951.048,1941.2473,1935.7633,1932.9991,1932.7585,1934.3376,1936.7737,1943.6329,1952.3817,1959.2449,1965.5529,1971.7072,1976.7793,1981.6512,1987.8293,1996.0929,2003.4009,2010.4198,2016.587,2021.2642,2023.8384,2026.719,2032.1162,2036.7866,2039.5314,2032.8281,2020.2128,2002.7032,1983.0527,1963.7585,1946.8146,1930.5579,1915.7816,1900.5056,1889.1017,1886.1685,1886.1333,1888.0,1889.0,1890.0,1891.0806,1891.2057,1891.4696,1893.7617,1923.7015,1925.336,1929.0955,1935.624,1942.932,1950.3005,1952.8862,1945.5782,1935.7828,1929.7291,1927.8188,1929.5425,1931.9406,1935.0107,1937.7905,1944.7819,1951.9663,1958.426,1964.9993,1970.6035,1976.4188,1983.6832,1990.0349,1996.399,2000.9861,2005.2766,2007.9126,2010.3486,2012.8926,2019.3086,2024.8572,2029.3132,2027.6343,2017.6274,2001.81,1981.4741,1963.143,1945.8009,1929.3593,1914.0171,1901.7411,1890.3406,1886.7794,1886.0,1886.8634,1888.52,1889.0,1889.0,1889.0,1889.7794,1891.4795,1922.3179,1924.336,1927.0447,1934.6975,1942.7018,1951.08,1950.007,1938.9324,1930.5425,1925.2382,1925.5214,1927.295,1929.6172,1932.9213,1935.3572,1938.742,1944.768,1951.8855,1958.3037,1964.6117,1973.6143,1980.4652,1985.6904,1990.5625,1993.0597,1993.413,1994.0022,1996.0288,1999.4053,2006.3982,2012.7262,2018.1821,2018.9142,2011.7214,1995.7994,1977.2898,1960.7772,1945.808,1932.1415,1919.4542,1906.4734,1894.4136,1886.9252,1886.0,1886.0,1886.8733,1887.3533,1887.3533,1887.3533,1888.3533,1889.9473,1920.9927,1923.2631,1925.699,1931.6709,1939.786,1945.7081,1941.6818,1933.0426,1926.1793,1923.9398,1923.946,1925.623,1928.0591,1930.4536,1932.931,1935.3671,1938.6151,1944.79,1953.0797,1960.736,1972.027,1977.987,1981.8751,1985.7091,1986.4171,1984.9811,1982.7081,1982.6842,1985.786,1993.7382,2001.5938,2005.9781,2007.5,2001.3162,1984.62,1970.5999,1956.8446,1944.7694,1934.1621,1924.523,1911.4211,1898.266,1888.6489,1886.0256,1886.0,1886.0,1886.0,1886.0,1886.0,1887.2448,1889.6781,1919.5009,1921.8368,1923.772,1926.1251,1933.7571,1937.9633,1934.4705,1928.1217,1924.1128,1922.5886,1922.6306,1923.8483,1925.6328,1927.0688,1929.5049,1932.6613,1935.3768,1939.0939,1950.2408,1960.736,1969.9808,1975.5569,1977.4937,1979.0017,1980.0017,1977.3019,1972.7673,1971.5042,1971.7201,1979.9526,1987.965,1991.9202,1991.6538,1984.0658,1971.8846,1959.4432,1950.417,1941.4065,1933.8632,1926.288,1914.7992,1901.731,1892.2565,1886.8512,1886.0,1886.0,1886.0,1886.0,1886.0,1887.0,1889.0505,1918.0671,1920.3855,1921.8467,1924.0746,1925.8147,1928.2239,1926.7079,1924.1262,1922.0457,1921.0746,1921.0746,1922.0519,1923.0746,1924.6426,1927.0786,1929.5146,1932.8359,1936.6986,1949.2548,1961.4911,1967.2863,1970.2052,1972.1859,1974.0826,1974.4484,1969.6388,1962.1371,1961.2484,1961.2733,1967.0051,1972.5009,1975.0131,1974.6704,1966.6584,1958.2217,1950.6584,1940.959,1934.1599,1929.2529,1924.3413,1915.64,1904.7802,1895.2736,1889.2773,1886.8477,1886.0,1886.0,1886.0,1886.0,1886.264,1888.7,1916.9648,1918.1025,1919.6484,1921.37,1922.066,1922.2969,1922.2969,1921.2969,1920.0453,1918.6484,1917.817,1918.5415,1920.3433,1921.8481,1924.3022,1926.9337,1929.1729,1934.3425,1948.0588,1962.552,1965.4304,1963.2772,1963.9453,1964.5938,1964.2297,1960.9937,1955.2047,1952.9453,1955.0532,1958.1936,1960.5807,1961.1777,1958.4421,1952.1914,1944.8911,1938.1136,1931.4017,1925.902,1922.0093,1918.1035,1912.7048,1903.5444,1896.364,1890.704,1887.9456,1886.48,1886.0,1886.0,1886.0,1886.0,1888.1539,1916.0,1917.0747,1917.2222,1918.2222,1916.9436,1916.6666,1916.1755,1917.2222,1916.9204,1915.5813,1915.2222,1915.2222,1916.3542,1918.7903,1921.2262,1923.32,1924.4169,1928.3164,1946.7023,1960.8507,1961.0466,1957.6107,1956.6666,1956.6666,1955.3835,1952.0667,1948.2085,1947.4445,1948.7747,1951.2107,1952.6622,1951.7964,1947.4071,1940.4711,1934.5022,1928.4089,1922.4746,1918.6027,1914.7307,1910.0596,1905.9867,1900.5458,1895.7511,1890.704,1888.0,1886.48,1886.0,1886.0,1886.0,1886.0,1887.4667,1915.0,1915.2675,1915.796,1915.796,1915.2833,1913.92,1914.516,1915.0,1913.9209,1913.1401,1913.0,1912.796,1913.928,1915.9043,1918.7969,1920.236,1922.672,1926.56,1943.2229,1953.6295,1952.972,1949.5806,1949.88,1950.3881,1949.0983,1946.588,1943.3079,1940.455,1941.206,1942.821,1942.2041,1938.352,1934.4801,1930.608,1924.7361,1918.8967,1914.6705,1910.3495,1906.92,1902.7644,1900.456,1898.244,1894.4153,1890.704,1888.0,1887.0,1886.0,1886.0,1886.0,1886.0,1886.7,1913.3699,1913.3699,1913.3699,1914.0,1914.0,1913.0,1913.1908,1913.3699,1913.0,1912.4807,1912.0,1912.0,1912.3699,1913.9379,1915.3738,1917.8098,1921.1218,1925.6178,1938.3865,1947.6633,1946.63,1944.0535,1943.1095,1943.1095,1942.7396,1940.9396,1938.3549,1933.7655,1931.8491,1932.2189,1930.8691,1928.6472,1925.0903,1921.1666,1914.3073,1909.2184,1905.2872,1902.0977,1901.1968,1900.3699,1898.7858,1896.5939,1893.0795,1890.352,1888.0,1887.0,1886.0,1886.0,1886.0,1886.0,1887.5891,1912.9492,1912.9436,1912.9436,1912.9436,1912.0,1912.0,1911.971,1911.9463,1912.0,1911.9535,1911.6982,1911.0,1911.1245,1911.9756,1913.9476,1915.3837,1917.7632,1923.1177,1932.5851,1938.9689,1939.2108,1936.7749,1935.8308,1936.7744,1937.4104,1935.0309,1931.4153,1926.5432,1922.7229,1921.1741,1918.7933,1917.3256,1914.8308,1911.2549,1906.342,1900.991,1900.9436,1899.9436,1899.502,1898.0906,1896.9808,1894.4354,1892.7435,1890.352,1888.916,1887.48,1886.044,1886.0,1886.0,1886.0,1888.4395,1913.0,1912.0,1912.0,1912.0,1912.0,1911.0,1910.5175,1910.5175,1910.2008,1911.0,1910.8745,1910.5175,1910.0,1910.7915,1912.0021,1912.5175,1912.9707,1915.6497,1925.3136,1929.2537,1931.0697,1929.5522,1928.3148,1927.1044,1927.2454,1927.5522,1925.2024,1920.5326,1916.3883,1912.9734,1911.5374,1910.6188,1908.1829,1904.4589,1901.1428,1899.9227,1899.0,1898.5175,1897.7742,1897.0497,1895.66,1894.0,1892.0,1890.352,1888.9565,1887.731,1886.044,1886.0,1886.0,1886.0,1890.4379,1913.0908,1912.6034,1912.0,1911.7197,1911.0,1910.92,1909.531,1909.0,1908.4438,1909.0752,1910.0,1909.0912,1909.2112,1909.6074,1910.0912,1910.0912,1910.0912,1911.4032,1914.8379,1920.7161,1922.8937,1923.2686,1921.7354,1919.3456,1918.3649,1917.6378,1916.1288,1913.6017,1912.0912,1911.0416,1909.1112,1906.7665,1904.2393,1901.065,1900.0251,1898.8546,1898.0,1897.0912,1897.0,1896.0088,1894.66,1893.224,1891.8074,1890.352,1889.0,1888.0,1887.0,1886.0,1886.0,1886.2399,1892.4362,1915.0,1913.7766,1913.0,1911.5267,1910.2367,1909.665,1909.0,1908.0,1908.0,1908.0,1908.0,1908.0,1908.0,1908.665,1907.9987,1906.8527,1906.7065,1907.977,1911.6636,1913.9713,1916.9501,1918.33,1917.0082,1913.1199,1912.665,1912.665,1912.0,1911.7749,1910.5931,1909.121,1905.705,1903.833,1901.0984,1900.0,1899.1836,1897.9464,1897.0,1896.665,1896.1782,1895.096,1894.0,1893.0,1891.788,1890.2341,1888.916,1887.8258,1887.0,1886.0,1886.0,1886.863,1895.401,1916.0762,1914.664,1913.1736,1911.6029,1910.271,1909.0,1908.1156,1908.0,1907.0,1907.0,1907.0621,1907.7686,1908.0,1907.5676,1907.0,1906.335,1906.0,1906.8357,1909.7349,1912.044,1913.3868,1914.4777,1913.7468,1912.2936,1911.2388,1911.0477,1910.2388,1910.0784,1909.1309,1906.6948,1904.2588,1901.7235,1900.3514,1899.17,1898.2388,1897.0,1897.0,1896.7612,1896.532,1895.096,1893.66,1892.0535,1890.8386,1889.5067,1888.916,1887.48,1886.044,1886.0,1886.0,1887.729,1898.4895,1917.1,1914.664,1913.0,1912.0,1911.2893,1909.92,1908.5807,1908.0,1908.0,1907.033,1907.0,1907.0,1907.0,1907.0,1907.0,1907.0,1906.124,1906.2535,1908.3558,1910.8126,1910.8126,1911.8126,1911.8126,1910.8126,1909.8126,1909.0,1908.8126,1908.0,1906.9797,1905.3706,1903.2074,1901.1095,1900.148,1899.0,1898.0,1897.2174,1897.3748,1899.1814,1897.532,1894.9266,1892.5364,1890.8546,1889.9603,1889.0,1888.0,1887.0,1886.0,1886.0,1886.0,1890.6948,1902.8748,1918.1,1915.664,1913.8416,1911.792,1910.7511,1910.0,1909.6136,1909.0,1908.3755,1908.0,1908.0,1908.0,1907.0,1907.0,1907.0,1906.73,1906.0,1906.0,1907.2891,1907.5704,1907.6196,1908.4984,1908.3864,1908.3864,1907.7766,1907.3864,1907.2952,1906.3864,1906.0,1905.1761,1904.02,1901.8392,1901.0,1899.5353,1898.0,1900.6136,1901.3657,1900.9877,1898.3512,1894.192,1891.66,1890.0,1889.0,1888.136,1887.3864,1886.6809,1886.0,1886.0,1886.828,1895.2832,1908.0408,1920.1398,1917.7172,1915.2678,1912.8003,1912.0398,1912.0398,1911.5045,1910.0878,1910.0,1909.0398,1909.0294,1908.3317,1908.0,1908.0,1907.0398,1907.0,1906.0049,1906.0,1906.0,1905.0,1904.9602,1905.0162,1905.9602,1905.9602,1905.0,1905.0,1905.0,1905.0,1905.0,1905.0,1904.02,1902.584,1901.0,1899.4354,1899.4988,1904.246,1906.1355,1902.9745,1899.0242,1893.192,1890.6338,1889.0,1887.9916,1887.338,1886.8795,1886.0,1886.0,1886.0,1889.5568,1900.3997,1913.2795,1922.566,1921.2866,1918.7478,1916.1901,1914.932,1914.8948,1913.6915,1912.0223,1911.466,1911.466,1910.466,1910.1417,1909.466,1908.6967,1908.4641,1907.765,1907.466,1906.8334,1905.6006,1904.816,1903.2029,1903.0299,1903.534,1903.534,1903.534,1903.534,1903.534,1903.534,1903.5844,1904.2905,1904.0,1902.584,1901.148,1900.466,1903.2513,1910.878,1911.7805,1903.904,1897.846,1892.192,1889.3524,1888.1196,1887.0,1886.698,1886.0,1886.0,1886.0,1887.25,1894.6299,1905.252,1918.4583,1925.7952,1925.7844,1924.7012,1923.4686,1921.6766,1919.7045,1917.2684,1913.9402,1912.8922,1912.8922,1912.0,1911.2712,1910.7744,1909.9387,1909.0,1908.8922,1908.1106,1907.0,1906.0,1904.088,1903.0,1902.0,1901.1078,1901.1078,1901.4326,1902.1078,1902.0824,1901.1078,1902.1078,1903.1078,1903.1078,1902.584,1901.148,1901.0,1907.0642,1915.0695,1911.6803,1902.0404,1896.1213,1890.2998,1888.0712,1887.0242,1886.1078,1886.0,1886.0,1886.0,1886.0,1890.4835,1899.0964,1909.8689,1923.6844,1933.8552,1934.2737,1934.2737,1931.3177,1927.8723,1925.4768,1922.1208,1918.7001,1916.6368,1915.4944,1914.0583,1912.5256,1912.1864,1911.6129,1910.9973,1910.0,1909.0394,1908.0,1906.4901,1904.8746,1903.5774,1902.3005,1901.1617,1900.3674,1899.7682,1898.1084,1897.5656,1896.4823,1898.5448,1901.5364,1902.0,1902.0,1901.0,1900.0613,1907.068,1915.7382,1907.9791,1899.6176,1893.7456,1889.1614,1887.0,1886.6816,1886.0,1886.0,1886.0,1886.0,1886.0,1892.2784,1902.894,1914.9568,1930.2368,1940.0593,1942.5698,1943.0366,1940.9727,1936.6904,1932.0143,1927.3336,1923.5372,1920.8123,1918.7446,1916.4846,1914.7446,1913.0,1912.3217,1911.7416,1910.8876,1910.0,1908.688,1907.0643,1905.6075,1904.283,1903.0417,1902.7446,1901.0536,1898.908,1892.8086,1890.2748,1889.5107,1891.9546,1895.8541,1899.4907,1901.1492,1899.4034,1899.288,1906.2529,1911.9116,1902.5706,1897.1676,1892.3193,1888.1205,1886.66,1886.0,1886.0,1886.0,1886.0,1886.0,1886.7118,1895.1573,1907.4573,1920.0057,1935.3892,1949.5833,1950.9619,1951.5125,1950.6832,1946.9713,1938.6667,1932.8817,1926.4856,1923.7828,1921.3468,1919.2528,1917.4749,1914.8905,1913.0737,1912.1702,1911.56,1909.8503,1908.0,1907.1708,1906.1394,1905.065,1905.1613,1904.1708,1903.072,1900.272,1894.0441,1889.5778,1888.056,1888.0896,1890.8242,1893.6418,1896.0743,1896.8292,1898.1172,1900.5532,1902.5258,1898.6372,1893.7598,1889.3612,1887.0796,1886.0,1886.0,1886.0,1886.0,1886.0,1886.0889,1889.4169,1899.9766,1913.1975,1924.5359,1939.3708,1958.8104,1959.9917,1960.3881,1960.9851,1958.0531,1947.8418,1938.646,1931.338,1926.806,1924.7731,1922.337,1919.1815,1916.465,1914.7711,1912.996,1911.56,1910.074,1909.285,1908.1504,1907.597,1907.7173,1908.1606,1906.1146,1904.223,1901.597,1901.5164,1901.502,1898.0995,1889.0651,1888.544,1890.3829,1892.6514,1894.255,1895.691,1897.2382,1897.646,1895.4512,1891.326,1887.7206,1886.0387,1886.0,1886.0,1886.0,1886.0,1886.0,1888.1171,1895.0443,1905.154,1916.8397,1927.181,1941.2,1970.2137,1970.1161,1971.0929,1969.88,1965.0912,1952.6251,1942.4865,1935.1204,1931.2562,1928.1992,1924.5032,1921.3273,1918.7593,1915.4188,1912.996,1911.5702,1911.0,1910.0,1909.2694,1911.2073,1912.0464,1911.9453,1908.543,1905.0969,1905.0148,1904.2186,1904.0177,1902.3512,1897.5297,1888.0211,1888.9573,1889.9865,1891.8287,1892.9768,1893.7008,1892.133,1891.3807,1889.9456,1887.532,1886.0,1886.0,1886.0,1886.0,1886.0,1887.1072,1891.6064,1899.9135,1909.5912,1918.5032,1927.6011,1940.5,1976.4495,1976.4495,1976.4495,1975.6775,1966.78,1955.0494,1945.1678,1938.9733,1935.1228,1931.1718,1926.522,1922.9208,1921.2448,1916.7628,1913.4495,1912.4495,1912.0,1911.3092,1910.1133,1913.184,1914.0,1913.3934,1911.016,1907.5214,1907.4495,1906.4495,1905.0,1903.7775,1901.7136,1890.6833,1888.0,1888.7375,1889.4691,1890.5505,1890.5505,1890.3906,1889.2224,1888.533,1886.7897,1886.0,1886.0,1886.0,1886.0,1886.8062,1889.5712,1896.0094,1903.3174,1911.3522,1919.484,1927.8706,1939.1854,1978.9756,1978.8756,1978.1996,1975.6099,1966.8601,1954.7145,1946.4198,1942.8052,1939.0236,1935.1033,1930.2312,1926.1418,1925.6193,1923.1125,1918.7472,1915.3809,1913.1085,1911.9612,1911.0,1913.2855,1914.0,1913.0684,1910.6323,1910.8126,1910.4325,1909.0756,1906.669,1904.9164,1902.0,1896.3629,1888.0175,1888.0,1888.106,1888.3766,1889.0,1889.0,1888.1244,1887.1204,1886.532,1885.1124,1886.0,1886.0,1886.902,1888.5237,1892.0541,1899.0154,1904.9065,1912.176,1918.5054,1926.1804,1937.6244,1982.4019,1979.9658,1978.228,1974.5212,1966.1222,1955.9818,1948.7858,1946.6372,1943.8276,1939.0088,1936.7606,1937.2073,1935.0753,1930.0713,1924.5957,1920.5547,1915.8517,1912.9899,1911.7743,1910.0729,1909.944,1910.3013,1910.6245,1913.3019,1913.3019,1911.2604,1906.1985,1903.3019,1902.2693,1899.6698,1891.3679,1889.1763,1888.4052,1887.712,1887.0,1887.1117,1887.0,1885.9904,1884.8588,1884.6981,1885.6981,1885.9324,1887.212,1889.1956,1893.5284,1899.8951,1904.912,1910.6005,1917.1821,1925.32,1937.5,1984.1,1981.664,1978.228,1974.2246,1965.424,1958.6045,1955.3961,1952.9601,1949.796,1947.0078,1947.8295,1947.9441,1945.28,1940.0481,1931.8972,1924.576,1919.9423,1915.104,1912.252,1910.632,1906.4834,1905.4879,1908.512,1913.9476,1912.0139,1908.216,1904.036,1901.7827,1901.5933,1900.5801,1894.5215,1890.4252,1889.728,1888.9216,1887.2009,1887.0,1887.0,1884.9767,1883.6593,1883.93,1884.272,1885.776,1887.7856,1890.1198,1894.168,1899.04,1903.184,1909.056,1915.3588,1925.056,1938.2,1986.1155,1982.8182,1979.4912,1974.4081,1968.5751,1965.617,1964.9467,1961.7056,1958.0747,1956.4626,1959.137,1960.9209,1955.3751,1948.2783,1939.446,1930.5485,1923.5564,1918.2183,1913.252,1910.6617,1906.0814,1901.9913,1902.2618,1902.5374,1901.8458,1901.0,1900.8458,1900.2775,1899.8291,1899.2314,1895.8689,1892.0901,1890.2794,1889.7565,1889.0,1887.8646,1886.9081,1884.968,1883.45,1883.7645,1884.0,1885.9302,1888.212,1890.648,1894.168,1897.9598,1901.7645,1907.6902,1914.484,1926.0967,1938.5,1988.3029,1985.2444,1982.4845,1977.5333,1975.9479,1974.7078,1973.2253,1970.3698,1965.9653,1963.6675,1967.6908,1969.3218,1965.3453,1956.1396,1945.7253,1935.5854,1927.5328,1920.6444,1913.6503,1910.7092,1906.14,1902.492,1901.0,1900.0417,1900.0,1899.4196,1898.863,1898.0295,1897.4196,1896.6842,1895.02,1893.0,1892.0859,1890.8792,1889.6963,1888.84,1887.2345,1884.3876,1882.7284,1882.9443,1883.617,1886.776,1888.212,1891.0242,1894.084,1897.52,1900.357,1905.8231,1914.312,1926.9004,1939.5,1992.2133,1988.6772,1987.0133,1986.0133,1984.3735,1982.94,1979.5071,1977.0613,1973.2399,1971.1881,1975.2649,1976.0021,1974.4795,1962.1696,1951.9973,1939.817,1930.5027,1921.754,1913.756,1910.816,1907.3826,1903.9507,1902.0034,1901.0005,1900.0066,1899.0066,1898.0051,1897.328,1896.0059,1895.4596,1894.9935,1893.9972,1893.0,1891.712,1890.2742,1888.84,1886.7987,1882.9614,1880.997,1880.9934,1883.3334,1885.776,1888.212,1891.296,1894.084,1896.52,1898.956,1903.9574,1914.312,1927.32,1939.8,1996.5762,1993.5297,1990.6609,1989.4329,1988.5869,1987.4329,1986.1401,1981.9617,1977.3097,1975.4329,1977.1125,1977.1316,1975.868,1965.8379,1954.988,1944.5504,1932.9288,1922.8871,1914.756,1911.2488,1908.5444,1905.4086,1903.9408,1902.4736,1901.2753,1900.5463,1899.3307,1898.142,1896.9387,1895.456,1894.02,1893.3312,1892.084,1890.8754,1889.6866,1887.4071,1884.3751,1880.5491,1879.532,1879.904,1882.34,1885.776,1888.212,1891.296,1894.084,1896.52,1898.956,1902.7903,1914.2375,1925.8872,1938.9373,1999.959,1996.5231,1994.087,1991.859,1990.859,1989.7903,1987.8998,1984.9138,1980.9968,1978.7429,1978.859,1978.0,1975.736,1965.3009,1955.1284,1945.8,1933.7266,1922.893,1913.7915,1911.816,1909.38,1907.803,1905.4364,1904.0619,1902.9487,1901.8872,1900.9667,1899.2817,1897.7662,1895.456,1893.1582,1892.0823,1891.0209,1889.7526,1887.417,1885.8435,1881.949,1879.1365,1878.075,1879.0449,1881.68,1884.776,1888.212,1890.648,1894.0118,1896.52,1898.956,1902.568,1913.312,1924.0933,1937.2,2002.3853,1998.9492,1996.5132,1994.226,1992.6412,1990.92,1988.484,1986.0137,1982.7227,1981.0502,1979.0,1977.0188,1974.1868,1963.566,1953.9857,1943.9547,1933.5846,1922.3492,1913.8279,1911.816,1910.1084,1908.2693,1906.7932,1905.3367,1904.7399,1903.2853,1901.8313,1900.328,1898.892,1895.912,1892.02,1889.8813,1889.7147,1888.7147,1886.276,1883.5548,1880.4075,1877.6827,1876.7147,1877.904,1881.1517,1884.3307,1887.212,1889.648,1893.084,1896.04,1899.2286,1904.4612,1913.5973,1924.6805,1939.7705,2004.8114,2001.3755,1997.9395,1996.5034,1994.2533,1991.6315,1988.8284,1986.048,1983.612,1982.1252,1979.74,1977.1031,1972.604,1964.1321,1954.6943,1943.9098,1934.0835,1927.3969,1917.3943,1912.5806,1911.2704,1909.6716,1908.0,1906.7322,1905.4525,1904.1423,1902.9319,1901.2334,1898.892,1895.912,1892.04,1889.584,1888.0,1886.2886,1885.276,1882.0824,1879.404,1876.968,1876.0,1877.904,1880.4381,1883.6166,1886.4393,1888.835,1892.1083,1896.04,1899.912,1906.4548,1916.0234,1927.4833,1943.496,2008.2377,2003.8931,2000.397,1997.9297,1996.049,1993.862,1990.1056,1986.2336,1984.7496,1983.3136,1981.6177,1977.7039,1973.4901,1965.8062,1957.1256,1948.9982,1938.7712,1931.3392,1924.2487,1915.7233,1912.38,1910.944,1909.07,1908.0099,1906.636,1905.0,1903.0,1901.328,1898.892,1896.3811,1893.02,1890.6412,1888.4133,1886.712,1883.9384,1881.84,1879.404,1876.0,1876.0,1877.0,1880.34,1882.776,1885.212,1887.648,1890.9579,1895.4884,1900.868,1908.568,1918.426,1930.7217,1945.3376,2010.7202,2007.2279,2003.9204,2000.3558,1997.9198,1996.0477,1993.6117,1990.1757,1986.9089,1985.6406,1984.3038,1979.8683,1974.1678,1966.5396,1958.5519,1951.68,1942.0598,1934.2399,1927.3198,1919.9316,1913.5942,1911.944,1910.2864,1908.6359,1907.1998,1905.2,1903.764,1901.328,1898.892,1896.456,1894.02,1891.584,1889.148,1886.712,1883.9602,1881.68,1878.808,1876.0,1876.0,1877.0,1880.0,1882.2122,1884.6482,1886.8015,1889.5675,1894.2668,1900.868,1908.9108,1919.6068,1933.1478,1946.5,2015.18,2010.6508,2007.2103,2003.78,2000.9836,1998.9009,1996.9849,1995.0281,1993.198,1990.1561,1987.7201,1984.5881,1978.5754,1970.7081,1960.978,1951.68,1943.3633,1935.3729,1929.494,1923.4281,1916.1262,1912.9346,1911.5029,1910.0713,1908.6261,1905.398,1903.764,1901.328,1898.892,1896.456,1894.02,1892.1622,1889.148,1886.9972,1884.276,1881.84,1878.808,1876.0,1876.0,1877.0,1879.3466,1881.776,1884.212,1886.648,1888.094,1892.57,1900.8245,1909.568,1920.968,1934.584,1947.5,2019.0908,2014.1605,2009.8722,2007.0868,2003.7722,2001.3829,2000.4163,1999.4363,1999.0282,1997.3514,1993.3125,1988.8977,1985.4915,1977.5448,1966.227,1953.8894,1943.9122,1936.376,1931.0674,1925.5245,1920.1763,1915.7532,1912.9242,1912.03,1910.0522,1906.733,1903.764,1901.328,1898.892,1897.0,1895.02,1893.0002,1890.5642,1888.4247,1886.276,1883.0962,1879.056,1876.0,1876.0,1877.0,1879.34,1880.9067,1883.1238,1885.2317,1887.6677,1891.6637,1900.824,1909.568,1921.14,1934.584,1947.5,2022.8849,2017.1704,2013.1409,2009.4592,2006.5544,2003.7625,2002.0,2001.0404,2000.612,2000.0,1997.3225,1990.608,1988.7104,1984.2554,1971.6576,1956.6425,1946.2145,1937.376,1932.504,1927.6584,1923.9226,1919.7776,1916.3505,1913.9144,1911.4784,1908.3685,1904.7268,1901.328,1899.7345,1897.456,1896.8456,1894.4265,1892.9672,1890.5544,1888.1184,1886.3649,1880.1483,1876.0,1876.0,1876.9191,1878.4976,1880.1223,1882.212,1884.648,1887.084,1890.122,1899.824,1909.568,1921.14,1935.2041,1947.5],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD019.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD019.py load and self-test diagnostics complete.")
