package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD018Index.html" target="_blank">SquawLOD018</a>,  source <a href="../../../Geospatial/SquawLOD018.java">SquawLOD018.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD018.x3d">SquawLOD018.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD018.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD018.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD018
{
	/** Default constructor to create this object. */
	public SquawLOD018 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD018.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD018.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD018.x3d"))
    .addChild(new GeoLOD().setCenter(4340937.286173,741821.999947,2008.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(16133.333).setChild1Url(new String[] {"SquawLOD019.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD019.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw009.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw009.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4340105.411173,741212.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(25).setXSpacing(50.750000).setZDimension(33).setZSpacing(50.416667).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2074.0903,2066.1538,2068.385,2089.427,2103.473,2113.6416,2122.798,2128.5117,2144.5261,2156.6096,2152.7522,2140.855,2127.8174,2112.375,2099.1174,2084.9177,2061.5503,2031.1423,2006.7717,1985.1118,1968.8868,1952.6444,1936.9042,1922.2291,1904.2451,2043.3605,2040.2854,2048.4583,2071.4583,2083.6084,2090.2227,2089.999,2101.8403,2129.6824,2140.7312,2141.1223,2133.64,2119.704,2106.3086,2095.152,2077.9507,2050.552,2028.3,2003.5521,1977.4271,1948.0938,1927.8354,1913.5297,1900.5508,1894.4042,2025.2604,2020.2876,2035.278,2044.4448,2054.1902,2063.371,2065.3472,2079.8604,2104.934,2124.4604,2129.854,2125.3857,2112.7737,2100.3477,2090.2324,2077.0095,2052.5,2027.2848,1996.5435,1971.5204,1942.0521,1918.1868,1901.4368,1892.8368,1888.0,2000.7291,2004.3146,2014.6637,2020.7244,2031.7645,2038.7611,2042.1436,2061.9146,2084.486,2103.5342,2116.7498,2115.518,2106.7214,2093.4778,2086.1716,2074.0247,2048.6338,2024.2466,1996.4696,1968.375,1940.0,1912.2216,1897.0215,1888.4205,1888.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {1983.4688,1989.3977,1997.6672,2007.8438,2018.6687,2022.7008,2031.8562,2045.8102,2064.125,2080.104,2101.2625,2106.1562,2100.2625,2088.4062,2074.5125,2054.5,2035.3093,2014.4648,1993.0234,1964.4805,1934.4187,1905.8633,1892.4359,1888.0,1888.0,1967.5729,1974.523,1981.4819,1993.9241,2005.0966,2016.466,2023.0819,2033.041,2052.0,2074.41,2096.2078,2101.1384,2097.2383,2086.274,2068.6223,2046.0708,2021.901,1999.2389,1978.3706,1954.273,1925.9437,1903.1,1891.264,1888.0,1888.0,1956.3739,1960.9557,1972.5901,1984.8989,1997.8514,2010.165,2016.5013,2032.275,2055.3872,2071.4097,2087.6724,2095.4514,2092.471,2082.4756,2058.4756,2037.3457,2014.6775,1993.3,1970.5243,1942.3016,1921.4,1904.9427,1891.35,1888.0,1888.9323,1946.3469,1953.4708,1961.8812,1973.8633,1985.1813,1993.3313,2007.9208,2030.3854,2054.2605,2065.135,2074.9119,2080.578,2083.3728,2079.1575,2058.3,2033.1539,2012.8865,1991.7753,1970.2604,1946.375,1924.4,1906.575,1889.1604,1888.0,1891.7};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {1936.9296,1943.2275,1956.7255,1966.8033,1973.0854,1980.7104,1996.7435,2018.0104,2042.1805,2051.4604,2055.0771,2059.5293,2074.459,2076.125,2052.2354,2024.4403,1997.6295,1980.0653,1961.8854,1942.9951,1925.118,1903.3951,1888.0,1890.3298,1896.4049,1932.2299,1937.3048,1949.0731,1955.1146,1958.4535,1967.7239,1982.3895,2001.4048,2021.4844,2030.2244,2033.2993,2050.5598,2072.332,2074.25,2048.5903,2024.2485,2003.0702,1979.7952,1956.0026,1935.6798,1918.0618,1889.8994,1889.0,1892.625,1899.6011,1927.2281,1934.3146,1940.4329,1945.8086,1947.3646,1950.2047,1967.7307,1985.3688,1999.776,2010.3987,2017.4421,2037.7188,2062.1292,2069.7292,2059.0427,2034.7654,2010.199,1988.7604,1963.5912,1935.8185,1913.075,1888.0,1890.0,1893.625,1898.7,1924.9,1930.96,1937.7007,1943.0499,1942.8389,1941.1979,1950.9884,1970.2972,1984.1979,1994.3479,2005.5383,2025.0979,2046.6771,2061.5486,2065.4192,2045.6271,2012.5,1983.148,1953.9974,1922.4458,1893.4764,1888.0,1890.55,1893.625,1896.7};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {1924.0,1930.95,1941.666,1950.1862,1942.034,1935.159,1937.6538,1954.577,1969.8021,1981.0181,1992.2521,2009.3577,2025.702,2036.8047,2046.5759,2046.1663,2013.866,1975.6,1940.6085,1908.484,1887.0,1887.475,1890.0,1893.0,1895.134,1923.4219,1929.3938,1944.1765,1952.0859,1933.3375,1928.2297,1933.35,1941.2125,1955.6719,1968.5563,1981.8875,1995.2415,2003.4125,2008.6875,2018.6625,2028.3453,2013.9625,1974.0687,1937.8516,1907.4375,1887.1062,1886.2227,1889.0,1889.0,1891.1687,1920.9503,1925.4785,1940.1069,1938.1354,1924.8,1924.1384,1928.8535,1933.9285,1941.7587,1958.7279,1976.9773,1984.2355,1983.7104,1980.9518,1992.8208,2004.0458,1994.2767,1962.6354,1939.0,1917.7079,1891.8965,1886.0,1886.0,1886.0,1889.551,1917.9539,1921.9635,1925.1263,1925.4132,1921.3381,1920.6862,1922.8882,1927.9631,1934.5382,1958.875,1968.5879,1972.0048,1967.6451,1959.6146,1965.5641,1971.7559,1960.8292,1943.991,1930.1146,1918.5632,1898.5847,1887.525,1886.0,1886.0,1888.5614};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {1915.9573,1916.9894,1915.5729,1915.6979,1915.5729,1914.5729,1916.923,1921.9979,1925.0729,1956.9568,1955.6417,1954.8362,1950.4604,1945.7188,1949.2631,1947.946,1935.6073,1923.3688,1914.4688,1906.0687,1897.2,1888.525,1886.0,1886.0,1887.1011,1913.0,1913.0,1913.5773,1913.0,1912.6077,1912.0,1912.2126,1916.0326,1923.0,1943.3223,1942.173,1941.2153,1939.4153,1930.7296,1928.0382,1924.3958,1916.1698,1904.2556,1900.9019,1898.8724,1893.6,1888.7114,1886.0,1886.0,1887.9746,1913.0,1912.0,1911.6423,1909.9553,1909.7709,1910.0,1910.0,1911.6423,1912.3212,1925.623,1927.5095,1924.202,1924.5695,1918.0521,1911.6924,1908.6084,1901.5781,1898.9374,1897.9106,1895.8838,1892.6,1889.525,1886.6467,1886.0,1891.1576,1915.3229,1913.0,1909.9839,1908.5924,1907.6771,1908.0,1908.0,1906.8628,1906.3385,1912.3893,1916.5641,1913.1862,1911.7417,1910.8021,1907.727,1901.6602,1899.6094,1897.0,1896.25,1894.0,1891.8708,1889.0,1886.8224,1886.0,1896.349};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1917.3882,1913.0072,1910.6763,1908.911,1908.0,1907.2882,1907.0,1907.0,1906.0,1909.1211,1910.1744,1909.7118,1908.7118,1907.7118,1905.0144,1901.0,1898.9,1899.3386,1899.0382,1892.675,1889.8848,1888.0,1886.0,1886.1802,1904.9899,1921.3535,1916.2848,1913.2534,1912.2218,1910.2534,1909.2534,1908.2534,1907.6827,1906.2534,1905.0,1903.7466,1904.7466,1904.7466,1904.7466,1904.9873,1901.9813,1899.3535,1909.2751,1900.5,1890.675,1887.8986,1886.392,1886.0,1891.007,1915.7069,1929.8531,1929.1133,1924.3875,1919.1875,1915.0625,1912.7852,1910.8031,1910.0,1907.6094,1905.0,1902.0765,1900.8414,1900.5625,1899.3711,1902.7422,1901.9945,1901.2562,1914.5735,1898.0312,1888.4563,1886.0,1886.0,1886.0,1899.9375,1927.4906,1945.6361,1947.7361,1940.7701,1929.118,1921.984,1917.909,1913.1196,1911.6532,1908.5,1906.0782,1904.7144,1902.459,1892.784,1888.0,1893.532,1898.632,1899.916,1903.8124,1892.52,1886.675,1886.0,1886.0,1887.284,1909.3021,1938.1393};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1965.7615,1966.7466,1962.8568,1938.9049,1928.7792,1922.1083,1916.65,1912.0,1910.0,1909.2351,1911.1493,1905.275,1903.1792,1902.0187,1888.0,1891.7051,1893.9358,1893.6757,1888.75,1886.0,1886.0,1886.0709,1896.5658,1917.556,1941.0955,1978.2146,1978.0028,1965.6411,1944.8646,1936.7375,1926.6792,1922.8792,1915.7555,1912.0573,1913.0841,1913.9255,1910.0831,1908.3146,1904.2252,1891.6438,1888.0,1889.0,1888.98,1887.0,1886.0,1886.0458,1890.0646,1903.7015,1918.207,1938.3854,1984.1,1978.025,1963.85,1952.1945,1947.0236,1944.7322,1939.9415,1925.3556,1915.6198,1911.425,1906.8403,1913.978,1910.1604,1902.8502,1900.096,1889.977,1887.9799,1887.0,1884.6901,1884.2991,1887.032,1892.95,1903.0201,1914.8451,1938.2,1987.2858,1981.1392,1974.1354,1970.8911,1962.7444,1967.1478,1959.7355,1938.4163,1922.0452,1911.425,1902.7294,1900.0125,1899.9548,1898.9154,1896.9572,1892.9761,1890.0406,1887.8329,1883.7162,1883.3103,1887.4,1893.475,1900.0752,1913.5,1939.5};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1996.1115,1990.0354,1988.0104,1984.7709,1975.8104,1977.0104,1972.9,1949.875,1926.0,1911.431,1905.3605,1902.2826,1900.2084,1898.0013,1895.05,1892.9998,1890.8906,1886.8146,1880.0,1881.318,1887.4,1893.475,1898.55,1913.4961,1939.4865,2002.0757,1996.0007,1991.9269,1987.75,1981.8,1978.725,1969.2902,1948.8854,1925.0243,1912.0,1908.35,1905.2683,1902.9806,1900.125,1895.0988,1890.0243,1888.8025,1882.8451,1877.0243,1879.6664,1886.4243,1892.475,1898.55,1912.5,1939.1514,2007.9878,1999.966,1995.891,1988.8677,1983.9882,1979.666,1969.2793,1952.5819,1933.4115,1917.157,1910.9617,1907.9572,1905.0,1901.125,1895.9939,1889.9985,1885.7528,1880.825,1876.0,1879.325,1884.459,1889.981,1899.644,1917.4779,1945.1823,2015.0125,2006.8398,2000.7625,1996.6875,1991.6125,1986.5375,1974.7625,1955.821,1937.5,1924.7422,1912.9391,1910.2493,1905.3812,1901.125,1896.05,1890.975,1886.7156,1880.825,1876.0,1878.3555,1883.4,1887.5687,1899.2422,1919.75,1947.5};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {2022.9431,2012.7931,2005.8215,2001.9839,2000.0,1994.8069,1987.4316,1962.3215,1939.9358,1928.7216,1920.5266,1914.1465,1908.3743,1901.125,1897.05,1893.8683,1889.7715,1884.2405,1876.0,1878.0417,1881.477,1886.475,1898.2,1920.125,1947.5};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.04167,0.00391,0.08333,0.00391,0.125,0.00391,0.16667,0.00391,0.20833,0.00391,0.25,0.00391,0.29167,0.00391,0.33333,0.00391,0.375,0.00391,0.41667,0.00391,0.45833,0.00391,0.5,0.00391,0.54167,0.00391,0.58333,0.00391,0.625,0.00391,0.66667,0.00391,0.70833,0.00391,0.75,0.00391,0.79167,0.00391,0.83333,0.00391,0.875,0.00391,0.91667,0.00391,0.95833,0.00391,0.99609,0.00391,0.00391,0.03125,0.04167,0.03125,0.08333,0.03125,0.125,0.03125,0.16667,0.03125,0.20833,0.03125,0.25,0.03125,0.29167,0.03125,0.33333,0.03125,0.375,0.03125,0.41667,0.03125,0.45833,0.03125,0.5,0.03125,0.54167,0.03125,0.58333,0.03125,0.625,0.03125,0.66667,0.03125,0.70833,0.03125,0.75,0.03125,0.79167,0.03125,0.83333,0.03125,0.875,0.03125,0.91667,0.03125,0.95833,0.03125,0.99609,0.03125,0.00391,0.0625,0.04167,0.0625,0.08333,0.0625,0.125,0.0625,0.16667,0.0625,0.20833,0.0625,0.25,0.0625,0.29167,0.0625,0.33333,0.0625,0.375,0.0625,0.41667,0.0625,0.45833,0.0625,0.5,0.0625,0.54167,0.0625,0.58333,0.0625,0.625,0.0625,0.66667,0.0625,0.70833,0.0625,0.75,0.0625,0.79167,0.0625,0.83333,0.0625,0.875,0.0625,0.91667,0.0625,0.95833,0.0625,0.99609,0.0625,0.00391,0.09375,0.04167,0.09375,0.08333,0.09375,0.125,0.09375,0.16667,0.09375,0.20833,0.09375,0.25,0.09375,0.29167,0.09375,0.33333,0.09375,0.375,0.09375,0.41667,0.09375,0.45833,0.09375,0.5,0.09375,0.54167,0.09375,0.58333,0.09375,0.625,0.09375,0.66667,0.09375,0.70833,0.09375,0.75,0.09375,0.79167,0.09375,0.83333,0.09375,0.875,0.09375,0.91667,0.09375,0.95833,0.09375,0.99609,0.09375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.00391,0.125,0.04167,0.125,0.08333,0.125,0.125,0.125,0.16667,0.125,0.20833,0.125,0.25,0.125,0.29167,0.125,0.33333,0.125,0.375,0.125,0.41667,0.125,0.45833,0.125,0.5,0.125,0.54167,0.125,0.58333,0.125,0.625,0.125,0.66667,0.125,0.70833,0.125,0.75,0.125,0.79167,0.125,0.83333,0.125,0.875,0.125,0.91667,0.125,0.95833,0.125,0.99609,0.125,0.00391,0.15625,0.04167,0.15625,0.08333,0.15625,0.125,0.15625,0.16667,0.15625,0.20833,0.15625,0.25,0.15625,0.29167,0.15625,0.33333,0.15625,0.375,0.15625,0.41667,0.15625,0.45833,0.15625,0.5,0.15625,0.54167,0.15625,0.58333,0.15625,0.625,0.15625,0.66667,0.15625,0.70833,0.15625,0.75,0.15625,0.79167,0.15625,0.83333,0.15625,0.875,0.15625,0.91667,0.15625,0.95833,0.15625,0.99609,0.15625,0.00391,0.1875,0.04167,0.1875,0.08333,0.1875,0.125,0.1875,0.16667,0.1875,0.20833,0.1875,0.25,0.1875,0.29167,0.1875,0.33333,0.1875,0.375,0.1875,0.41667,0.1875,0.45833,0.1875,0.5,0.1875,0.54167,0.1875,0.58333,0.1875,0.625,0.1875,0.66667,0.1875,0.70833,0.1875,0.75,0.1875,0.79167,0.1875,0.83333,0.1875,0.875,0.1875,0.91667,0.1875,0.95833,0.1875,0.99609,0.1875,0.00391,0.21875,0.04167,0.21875,0.08333,0.21875,0.125,0.21875,0.16667,0.21875,0.20833,0.21875,0.25,0.21875,0.29167,0.21875,0.33333,0.21875,0.375,0.21875,0.41667,0.21875,0.45833,0.21875,0.5,0.21875,0.54167,0.21875,0.58333,0.21875,0.625,0.21875,0.66667,0.21875,0.70833,0.21875,0.75,0.21875,0.79167,0.21875,0.83333,0.21875,0.875,0.21875,0.91667,0.21875,0.95833,0.21875,0.99609,0.21875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.00391,0.25,0.04167,0.25,0.08333,0.25,0.125,0.25,0.16667,0.25,0.20833,0.25,0.25,0.25,0.29167,0.25,0.33333,0.25,0.375,0.25,0.41667,0.25,0.45833,0.25,0.5,0.25,0.54167,0.25,0.58333,0.25,0.625,0.25,0.66667,0.25,0.70833,0.25,0.75,0.25,0.79167,0.25,0.83333,0.25,0.875,0.25,0.91667,0.25,0.95833,0.25,0.99609,0.25,0.00391,0.28125,0.04167,0.28125,0.08333,0.28125,0.125,0.28125,0.16667,0.28125,0.20833,0.28125,0.25,0.28125,0.29167,0.28125,0.33333,0.28125,0.375,0.28125,0.41667,0.28125,0.45833,0.28125,0.5,0.28125,0.54167,0.28125,0.58333,0.28125,0.625,0.28125,0.66667,0.28125,0.70833,0.28125,0.75,0.28125,0.79167,0.28125,0.83333,0.28125,0.875,0.28125,0.91667,0.28125,0.95833,0.28125,0.99609,0.28125,0.00391,0.3125,0.04167,0.3125,0.08333,0.3125,0.125,0.3125,0.16667,0.3125,0.20833,0.3125,0.25,0.3125,0.29167,0.3125,0.33333,0.3125,0.375,0.3125,0.41667,0.3125,0.45833,0.3125,0.5,0.3125,0.54167,0.3125,0.58333,0.3125,0.625,0.3125,0.66667,0.3125,0.70833,0.3125,0.75,0.3125,0.79167,0.3125,0.83333,0.3125,0.875,0.3125,0.91667,0.3125,0.95833,0.3125,0.99609,0.3125,0.00391,0.34375,0.04167,0.34375,0.08333,0.34375,0.125,0.34375,0.16667,0.34375,0.20833,0.34375,0.25,0.34375,0.29167,0.34375,0.33333,0.34375,0.375,0.34375,0.41667,0.34375,0.45833,0.34375,0.5,0.34375,0.54167,0.34375,0.58333,0.34375,0.625,0.34375,0.66667,0.34375,0.70833,0.34375,0.75,0.34375,0.79167,0.34375,0.83333,0.34375,0.875,0.34375,0.91667,0.34375,0.95833,0.34375,0.99609,0.34375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.00391,0.375,0.04167,0.375,0.08333,0.375,0.125,0.375,0.16667,0.375,0.20833,0.375,0.25,0.375,0.29167,0.375,0.33333,0.375,0.375,0.375,0.41667,0.375,0.45833,0.375,0.5,0.375,0.54167,0.375,0.58333,0.375,0.625,0.375,0.66667,0.375,0.70833,0.375,0.75,0.375,0.79167,0.375,0.83333,0.375,0.875,0.375,0.91667,0.375,0.95833,0.375,0.99609,0.375,0.00391,0.40625,0.04167,0.40625,0.08333,0.40625,0.125,0.40625,0.16667,0.40625,0.20833,0.40625,0.25,0.40625,0.29167,0.40625,0.33333,0.40625,0.375,0.40625,0.41667,0.40625,0.45833,0.40625,0.5,0.40625,0.54167,0.40625,0.58333,0.40625,0.625,0.40625,0.66667,0.40625,0.70833,0.40625,0.75,0.40625,0.79167,0.40625,0.83333,0.40625,0.875,0.40625,0.91667,0.40625,0.95833,0.40625,0.99609,0.40625,0.00391,0.4375,0.04167,0.4375,0.08333,0.4375,0.125,0.4375,0.16667,0.4375,0.20833,0.4375,0.25,0.4375,0.29167,0.4375,0.33333,0.4375,0.375,0.4375,0.41667,0.4375,0.45833,0.4375,0.5,0.4375,0.54167,0.4375,0.58333,0.4375,0.625,0.4375,0.66667,0.4375,0.70833,0.4375,0.75,0.4375,0.79167,0.4375,0.83333,0.4375,0.875,0.4375,0.91667,0.4375,0.95833,0.4375,0.99609,0.4375,0.00391,0.46875,0.04167,0.46875,0.08333,0.46875,0.125,0.46875,0.16667,0.46875,0.20833,0.46875,0.25,0.46875,0.29167,0.46875,0.33333,0.46875,0.375,0.46875,0.41667,0.46875,0.45833,0.46875,0.5,0.46875,0.54167,0.46875,0.58333,0.46875,0.625,0.46875,0.66667,0.46875,0.70833,0.46875,0.75,0.46875,0.79167,0.46875,0.83333,0.46875,0.875,0.46875,0.91667,0.46875,0.95833,0.46875,0.99609,0.46875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.00391,0.5,0.04167,0.5,0.08333,0.5,0.125,0.5,0.16667,0.5,0.20833,0.5,0.25,0.5,0.29167,0.5,0.33333,0.5,0.375,0.5,0.41667,0.5,0.45833,0.5,0.5,0.5,0.54167,0.5,0.58333,0.5,0.625,0.5,0.66667,0.5,0.70833,0.5,0.75,0.5,0.79167,0.5,0.83333,0.5,0.875,0.5,0.91667,0.5,0.95833,0.5,0.99609,0.5,0.00391,0.53125,0.04167,0.53125,0.08333,0.53125,0.125,0.53125,0.16667,0.53125,0.20833,0.53125,0.25,0.53125,0.29167,0.53125,0.33333,0.53125,0.375,0.53125,0.41667,0.53125,0.45833,0.53125,0.5,0.53125,0.54167,0.53125,0.58333,0.53125,0.625,0.53125,0.66667,0.53125,0.70833,0.53125,0.75,0.53125,0.79167,0.53125,0.83333,0.53125,0.875,0.53125,0.91667,0.53125,0.95833,0.53125,0.99609,0.53125,0.00391,0.5625,0.04167,0.5625,0.08333,0.5625,0.125,0.5625,0.16667,0.5625,0.20833,0.5625,0.25,0.5625,0.29167,0.5625,0.33333,0.5625,0.375,0.5625,0.41667,0.5625,0.45833,0.5625,0.5,0.5625,0.54167,0.5625,0.58333,0.5625,0.625,0.5625,0.66667,0.5625,0.70833,0.5625,0.75,0.5625,0.79167,0.5625,0.83333,0.5625,0.875,0.5625,0.91667,0.5625,0.95833,0.5625,0.99609,0.5625,0.00391,0.59375,0.04167,0.59375,0.08333,0.59375,0.125,0.59375,0.16667,0.59375,0.20833,0.59375,0.25,0.59375,0.29167,0.59375,0.33333,0.59375,0.375,0.59375,0.41667,0.59375,0.45833,0.59375,0.5,0.59375,0.54167,0.59375,0.58333,0.59375,0.625,0.59375,0.66667,0.59375,0.70833,0.59375,0.75,0.59375,0.79167,0.59375,0.83333,0.59375,0.875,0.59375,0.91667,0.59375,0.95833,0.59375,0.99609,0.59375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.00391,0.625,0.04167,0.625,0.08333,0.625,0.125,0.625,0.16667,0.625,0.20833,0.625,0.25,0.625,0.29167,0.625,0.33333,0.625,0.375,0.625,0.41667,0.625,0.45833,0.625,0.5,0.625,0.54167,0.625,0.58333,0.625,0.625,0.625,0.66667,0.625,0.70833,0.625,0.75,0.625,0.79167,0.625,0.83333,0.625,0.875,0.625,0.91667,0.625,0.95833,0.625,0.99609,0.625,0.00391,0.65625,0.04167,0.65625,0.08333,0.65625,0.125,0.65625,0.16667,0.65625,0.20833,0.65625,0.25,0.65625,0.29167,0.65625,0.33333,0.65625,0.375,0.65625,0.41667,0.65625,0.45833,0.65625,0.5,0.65625,0.54167,0.65625,0.58333,0.65625,0.625,0.65625,0.66667,0.65625,0.70833,0.65625,0.75,0.65625,0.79167,0.65625,0.83333,0.65625,0.875,0.65625,0.91667,0.65625,0.95833,0.65625,0.99609,0.65625,0.00391,0.6875,0.04167,0.6875,0.08333,0.6875,0.125,0.6875,0.16667,0.6875,0.20833,0.6875,0.25,0.6875,0.29167,0.6875,0.33333,0.6875,0.375,0.6875,0.41667,0.6875,0.45833,0.6875,0.5,0.6875,0.54167,0.6875,0.58333,0.6875,0.625,0.6875,0.66667,0.6875,0.70833,0.6875,0.75,0.6875,0.79167,0.6875,0.83333,0.6875,0.875,0.6875,0.91667,0.6875,0.95833,0.6875,0.99609,0.6875,0.00391,0.71875,0.04167,0.71875,0.08333,0.71875,0.125,0.71875,0.16667,0.71875,0.20833,0.71875,0.25,0.71875,0.29167,0.71875,0.33333,0.71875,0.375,0.71875,0.41667,0.71875,0.45833,0.71875,0.5,0.71875,0.54167,0.71875,0.58333,0.71875,0.625,0.71875,0.66667,0.71875,0.70833,0.71875,0.75,0.71875,0.79167,0.71875,0.83333,0.71875,0.875,0.71875,0.91667,0.71875,0.95833,0.71875,0.99609,0.71875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.00391,0.75,0.04167,0.75,0.08333,0.75,0.125,0.75,0.16667,0.75,0.20833,0.75,0.25,0.75,0.29167,0.75,0.33333,0.75,0.375,0.75,0.41667,0.75,0.45833,0.75,0.5,0.75,0.54167,0.75,0.58333,0.75,0.625,0.75,0.66667,0.75,0.70833,0.75,0.75,0.75,0.79167,0.75,0.83333,0.75,0.875,0.75,0.91667,0.75,0.95833,0.75,0.99609,0.75,0.00391,0.78125,0.04167,0.78125,0.08333,0.78125,0.125,0.78125,0.16667,0.78125,0.20833,0.78125,0.25,0.78125,0.29167,0.78125,0.33333,0.78125,0.375,0.78125,0.41667,0.78125,0.45833,0.78125,0.5,0.78125,0.54167,0.78125,0.58333,0.78125,0.625,0.78125,0.66667,0.78125,0.70833,0.78125,0.75,0.78125,0.79167,0.78125,0.83333,0.78125,0.875,0.78125,0.91667,0.78125,0.95833,0.78125,0.99609,0.78125,0.00391,0.8125,0.04167,0.8125,0.08333,0.8125,0.125,0.8125,0.16667,0.8125,0.20833,0.8125,0.25,0.8125,0.29167,0.8125,0.33333,0.8125,0.375,0.8125,0.41667,0.8125,0.45833,0.8125,0.5,0.8125,0.54167,0.8125,0.58333,0.8125,0.625,0.8125,0.66667,0.8125,0.70833,0.8125,0.75,0.8125,0.79167,0.8125,0.83333,0.8125,0.875,0.8125,0.91667,0.8125,0.95833,0.8125,0.99609,0.8125,0.00391,0.84375,0.04167,0.84375,0.08333,0.84375,0.125,0.84375,0.16667,0.84375,0.20833,0.84375,0.25,0.84375,0.29167,0.84375,0.33333,0.84375,0.375,0.84375,0.41667,0.84375,0.45833,0.84375,0.5,0.84375,0.54167,0.84375,0.58333,0.84375,0.625,0.84375,0.66667,0.84375,0.70833,0.84375,0.75,0.84375,0.79167,0.84375,0.83333,0.84375,0.875,0.84375,0.91667,0.84375,0.95833,0.84375,0.99609,0.84375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.00391,0.875,0.04167,0.875,0.08333,0.875,0.125,0.875,0.16667,0.875,0.20833,0.875,0.25,0.875,0.29167,0.875,0.33333,0.875,0.375,0.875,0.41667,0.875,0.45833,0.875,0.5,0.875,0.54167,0.875,0.58333,0.875,0.625,0.875,0.66667,0.875,0.70833,0.875,0.75,0.875,0.79167,0.875,0.83333,0.875,0.875,0.875,0.91667,0.875,0.95833,0.875,0.99609,0.875,0.00391,0.90625,0.04167,0.90625,0.08333,0.90625,0.125,0.90625,0.16667,0.90625,0.20833,0.90625,0.25,0.90625,0.29167,0.90625,0.33333,0.90625,0.375,0.90625,0.41667,0.90625,0.45833,0.90625,0.5,0.90625,0.54167,0.90625,0.58333,0.90625,0.625,0.90625,0.66667,0.90625,0.70833,0.90625,0.75,0.90625,0.79167,0.90625,0.83333,0.90625,0.875,0.90625,0.91667,0.90625,0.95833,0.90625,0.99609,0.90625,0.00391,0.9375,0.04167,0.9375,0.08333,0.9375,0.125,0.9375,0.16667,0.9375,0.20833,0.9375,0.25,0.9375,0.29167,0.9375,0.33333,0.9375,0.375,0.9375,0.41667,0.9375,0.45833,0.9375,0.5,0.9375,0.54167,0.9375,0.58333,0.9375,0.625,0.9375,0.66667,0.9375,0.70833,0.9375,0.75,0.9375,0.79167,0.9375,0.83333,0.9375,0.875,0.9375,0.91667,0.9375,0.95833,0.9375,0.99609,0.9375,0.00391,0.96875,0.04167,0.96875,0.08333,0.96875,0.125,0.96875,0.16667,0.96875,0.20833,0.96875,0.25,0.96875,0.29167,0.96875,0.33333,0.96875,0.375,0.96875,0.41667,0.96875,0.45833,0.96875,0.5,0.96875,0.54167,0.96875,0.58333,0.96875,0.625,0.96875,0.66667,0.96875,0.70833,0.96875,0.75,0.96875,0.79167,0.96875,0.83333,0.96875,0.875,0.96875,0.91667,0.96875,0.95833,0.96875,0.99609,0.96875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.99609,0.04167,0.99609,0.08333,0.99609,0.125,0.99609,0.16667,0.99609,0.20833,0.99609,0.25,0.99609,0.29167,0.99609,0.33333,0.99609,0.375,0.99609,0.41667,0.99609,0.45833,0.99609,0.5,0.99609,0.54167,0.99609,0.58333,0.99609,0.625,0.99609,0.66667,0.99609,0.70833,0.99609,0.75,0.99609,0.79167,0.99609,0.83333,0.99609,0.875,0.99609,0.91667,0.99609,0.95833,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 825 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 1650 total numbers made up of 825 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD018 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD018().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD018\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD018 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD018_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD018_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD018_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD018_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
