####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD017.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD017.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD017.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD017.x3d'),
    GeoLOD(center=(4344125.917539,740603.999947,1992.000000),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw008.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw00.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4343332.077840,739994.999947,0),geoSystem=["UTM","Z10","N"],height=[1987.8167,1985.5946,1981.718,1977.1907,1973.6926,1975.9,1974.784,1971.2107,1964.736,1958.428,1952.4133,1942.1866,1935.5027,1930.6306,1925.796,1923.5266,1922.154,1921.5734,1921.0087,1919.2307,1919.1666,1917.0347,1913.898,1911.244,1906.372,1901.5,1896.4613,1890.8627,1889.0,1888.1666,1888.0,1888.0,1888.0,1888.0,1887.1666,1887.0,1887.0,1886.8066,1886.0553,1886.0,1885.0767,1884.8373,1883.0,1882.2933,1881.7633,1881.1666,1880.1666,1880.068,1879.1666,1879.0,1878.1666,1999.1934,1995.263,1990.391,1985.9353,1984.3999,1985.0549,1982.0353,1977.8635,1971.9873,1964.6892,1957.7875,1950.4795,1939.6996,1934.6315,1928.6404,1924.9437,1923.5837,1922.7869,1922.5837,1921.8402,1922.0624,1921.4952,1919.6553,1917.0396,1914.0396,1908.1675,1902.6248,1896.4982,1891.2634,1889.1494,1889.0,1889.0,1888.5837,1888.2988,1888.0,1887.8501,1887.1191,1887.0,1887.0,1886.0,1885.46,1884.5938,1884.3433,1883.5837,1883.0,1882.5837,1881.935,1881.2382,1880.5837,1880.0,1879.6254,2009.8497,2005.4371,1999.124,1994.6178,1992.0215,1991.0299,1989.3138,1985.5654,1979.2617,1971.9675,1961.6506,1955.3319,1947.0371,1939.7358,1934.6119,1928.7562,1925.9431,1925.01,1924.0619,1924.01,1924.83,1926.01,1926.01,1922.9006,1918.8918,1915.01,1908.1536,1902.4039,1897.4039,1894.2759,1892.8318,1891.0138,1889.958,1889.0,1889.0,1888.0063,1888.0,1887.0,1887.0,1886.01,1886.0045,1886.0,1885.592,1885.01,1884.01,1884.0028,1883.01,1883.0,1882.01,1881.5406,1881.01,2021.9807,2016.1772,2009.4047,2001.3427,1998.3085,1998.0284,1996.5924,1992.3743,1986.0557,1980.2365,1971.6453,1961.2164,1955.0806,1949.4406,1942.5687,1937.8254,1934.5927,1931.0093,1928.3605,1926.2196,1927.6138,1929.4362,1928.6099,1927.3081,1923.7443,1918.8723,1913.7545,1908.1841,1901.4299,1898.1283,1896.6923,1895.2563,1893.3842,1890.9481,1889.0332,1889.0,1888.0,1887.4362,1887.0,1887.0,1887.0,1887.0,1886.7677,1886.4362,1885.8398,1885.4362,1884.4362,1884.0,1883.4362,1883.0,1882.4926,2033.8016,2025.3792,2016.8329,2009.363,2005.7216,2004.587,2003.6261,2000.5309,1994.6854,1987.5358,1980.6727,1971.7421,1963.4991,1958.9135,1953.0133,1947.2576,1943.3079,1939.0543,1934.8215,1932.5342,1931.8551,1931.8623,1931.1704,1929.7344,1927.2983,1924.587,1920.7151,1915.7054,1910.5254,1904.891,1900.8375,1899.1088,1896.8103,1894.3744,1891.9384,1889.5519,1888.8904,1888.0,1888.0,1888.0,1888.8623,1888.0208,1887.9432,1887.8623,1887.0,1886.8623,1885.9785,1885.3518,1884.8623,1884.8623,1884.0,2041.8253,2033.7217,2023.9777,2014.2336,2011.9983,2013.1542,2011.4382,2008.5616,2003.3903,1997.0992,1990.2343,1982.8287,1975.4468,1969.6852,1962.976,1957.1304,1952.0022,1947.1302,1941.3102,1937.644,1936.3405,1935.5033,1934.3774,1934.1975,1933.1759,1930.8657,1927.8309,1923.1217,1917.961,1914.0891,1908.5056,1904.3451,1900.2516,1897.8005,1895.6312,1893.2172,1890.7811,1889.2886,1889.0,1889.2886,1890.2886,1890.2886,1889.4583,1889.0438,1888.2886,1887.4878,1887.2435,1887.0,1886.2886,1886.2886,1886.0288,2049.101,2041.0002,2030.2643,2021.482,2023.3063,2024.7792,2022.8578,2018.1611,2012.2628,2005.794,1999.2242,1993.171,1987.1003,1980.4889,1974.2471,1967.3965,1960.9923,1955.8351,1950.2854,1945.3762,1941.6869,1939.3564,1937.0227,1937.8063,1938.4296,1938.4296,1933.9607,1927.8135,1922.8135,1918.1537,1914.0696,1909.1975,1905.3627,1901.5928,1899.5055,1897.612,1895.6335,1894.1975,1893.239,1893.4296,1893.7147,1893.7147,1893.135,1891.8234,1890.2266,1889.2001,1888.7147,1888.2916,1887.7147,1887.7147,1887.7147,2055.223,2048.2788,2036.9779,2036.1963,2036.5858,2033.6653,2031.747,2027.1189,2020.6589,2013.3508,2006.9668,2001.4899,1995.853,1990.1189,1984.8396,1977.6438,1970.4011,1964.4677,1958.5269,1952.6549,1948.7576,1945.9109,1942.039,1940.5148,1941.141,1940.141,1938.705,1932.6659,1925.6659,1921.653,1918.1019,1914.1367,1911.3708,1908.9349,1905.7051,1902.8947,1900.6556,1899.282,1898.7081,1898.282,1897.6771,1897.282,1896.787,1895.4125,1894.242,1893.1804,1892.126,1890.69,1890.2539,1889.282,1889.282,2061.9343,2056.6606,2049.8918,2049.092,2048.2686,2045.2759,2040.8367,2035.8784,2028.9375,2020.6295,2012.5206,2006.9545,2002.4703,1997.2659,1992.2935,1987.4215,1979.9976,1972.1655,1965.835,1959.3663,1954.4944,1951.6223,1947.8751,1945.0618,1943.5671,1942.5671,1940.1311,1937.3177,1930.9108,1925.6464,1922.3872,1920.0854,1917.6495,1916.2135,1914.7775,1912.9087,1910.4727,1907.7042,1905.6007,1904.1647,1902.7015,1901.1583,1900.3888,1899.6533,1898.4442,1897.2555,1896.1343,1895.1343,1895.1343,1895.1343,1895.1343,2067.7808,2063.4473,2060.9736,2059.5615,2057.1294,2053.4219,2049.2659,2043.373,2035.2189,2027.9081,2019.6001,2011.3047,2007.3228,2002.4507,1997.5787,1992.7068,1987.8337,1980.9288,1973.1361,1965.4467,1959.3522,1954.7357,1950.6094,1946.9991,1945.9934,1944.9934,1944.5508,1941.242,1936.3707,1932.2378,1928.6158,1925.9827,1923.9347,1922.4954,1921.0623,1919.6224,1918.1841,1916.748,1914.9757,1912.8701,1911.4335,1909.0039,1907.5681,1905.1321,1903.698,1901.9867,1900.8307,1899.9867,1899.9867,1899.9867,1900.9801,2073.6812,2069.992,2066.879,2065.1829,2062.995,2059.697,2054.1067,2048.383,2040.8285,2032.3236,2023.2661,2016.1511,2011.1752,2006.3031,2002.0116,1997.5591,1992.6553,1987.0984,1979.445,1971.3031,1962.1395,1958.015,1952.6339,1949.3452,1947.8556,1948.4196,1949.8391,1949.333,1945.8835,1940.5024,1937.0787,1934.0623,1931.2285,1929.7708,1927.3347,1926.2587,1924.9247,1923.2587,1921.5907,1920.1547,1918.2992,1916.2827,1914.0858,1912.4108,1910.2587,1908.5387,1907.1682,1906.2587,1906.2587,1906.2587,1905.8391,2080.3528,2076.548,2072.7432,2069.8472,2066.8477,2063.1748,2057.654,2051.4133,2043.4938,2034.7498,2026.0057,2019.1577,2015.1818,2010.9594,2005.4377,2001.4115,1996.4752,1990.8218,1984.0537,1974.6937,1966.2593,1961.4355,1958.8928,1956.1271,1952.4291,1951.6915,1955.4963,1956.5374,1954.2294,1950.0493,1946.3296,1942.7671,1939.4854,1937.0493,1935.6016,1933.5374,1931.7413,1930.3053,1928.5885,1926.6755,1924.9973,1922.5613,1920.2795,1918.6893,1916.6477,1914.8173,1914.5374,1914.5374,1914.5137,1912.62,1910.7915,2087.9607,2083.744,2079.844,2074.728,2070.584,2064.712,2059.84,2052.544,2044.648,2035.9346,2029.0171,2022.5083,2018.6982,2014.0079,2008.864,2003.5558,1997.848,1992.2479,1986.156,1978.392,1971.9529,1969.6295,1967.5841,1965.2318,1962.2064,1959.544,1962.6879,1964.8159,1963.7799,1960.8022,1957.1798,1953.2954,1950.3079,1947.5999,1945.164,1942.4658,1939.5638,1937.5839,1935.148,1933.7119,1931.2759,1929.8224,1926.8159,1924.6959,1922.7386,1922.0198,1921.4304,1920.8159,1919.8083,1918.08,1915.6439,2097.8643,2092.7207,2086.1785,2080.1724,2073.421,2066.16,2059.6538,2052.544,2045.6465,2038.3484,2033.4763,2028.3339,2023.5308,2018.6285,2011.2902,2006.6719,1999.2673,1995.5269,1989.5366,1984.8965,1980.1527,1978.0945,1977.3096,1975.9279,1973.3629,1970.1891,1970.9243,1973.5753,1974.6997,1972.7468,1969.1852,1965.689,1962.3868,1958.6621,1955.8687,1952.6841,1949.9967,1947.5607,1944.8229,1941.6887,1939.2527,1937.1113,1934.6825,1931.9906,1930.0088,1928.8772,1928.0945,1927.6812,1926.388,1924.3065,1921.2247,2105.173,2100.1768,2093.3572,2083.4924,2073.519,2066.0356,2058.8167,2052.696,2047.3091,2042.0764,2037.6644,2036.1244,2031.8335,2026.9615,2021.7323,2013.8263,2008.1545,2002.4098,1997.4772,1992.6051,1987.0151,1985.4657,1985.3732,1984.2611,1982.8793,1980.4976,1979.4976,1982.133,1983.4976,1982.7535,1980.4419,1978.0059,1974.57,1971.1339,1966.8983,1963.3862,1960.7269,1957.9668,1954.8295,1952.3936,1949.0148,1946.5215,1943.0856,1940.6495,1938.2135,1936.7427,1936.2366,1935.3732,1933.3451,1930.3784,1926.5607,2110.3506,2104.198,2095.6626,2084.368,2072.694,2064.16,2057.568,2052.1455,2047.5972,2043.5026,2039.7932,2038.5505,2038.7692,2036.1157,2031.682,2025.4441,2018.483,2011.447,2005.7557,1999.6724,1995.7327,1994.2023,1993.8213,1993.2023,1992.2023,1989.7529,1987.7664,1989.4662,1992.2023,1992.2023,1991.0223,1988.5863,1986.1503,1983.2649,1980.3202,1977.393,1973.5991,1969.8395,1965.7847,1962.5917,1959.6624,1956.2395,1953.114,1950.3544,1947.9183,1946.2023,1945.1165,1943.6104,1941.1589,1937.9792,1934.3473,2105.1904,2104.4153,2097.084,2083.96,2071.6277,2063.1768,2056.568,2050.7192,2046.4215,2042.9993,2040.54,2040.0,2044.8876,2045.1392,2040.4991,2035.2606,2028.6791,2021.3711,2014.0631,2007.1534,2004.0872,2003.9012,2003.8839,2002.9071,2001.9071,2000.9071,1998.4712,1998.7792,2000.9071,2001.1631,2000.7272,1997.6895,1994.8772,1992.4424,1990.0063,1988.5388,1986.0879,1982.6519,1979.2004,1974.7799,1971.3314,1967.908,1964.4719,1961.0394,1957.6232,1955.9071,1953.9268,1952.3152,1949.8792,1946.4556,1943.0304,2094.8508,2097.3271,2094.8584,2083.149,2070.221,2061.757,2054.852,2048.3542,2044.421,2040.573,2037.734,2037.555,2042.6532,2047.0626,2047.0673,2040.72,2036.6539,2030.3673,2023.344,2017.6147,2015.0149,2014.6119,2014.1989,2012.9634,2011.7876,2011.0149,2011.0149,2011.0149,2011.0149,2011.6119,2010.4319,2007.3799,2003.539,1999.9272,1998.2396,1995.849,1993.7338,1991.9769,1989.541,1987.5079,1984.475,1980.0726,1976.6029,1973.2281,1969.9644,1966.8108,1964.1991,1961.1843,1959.1755,1956.3639,1953.1149,2085.8662,2089.0483,2088.5684,2080.232,2068.768,2060.16,2053.6165,2046.8668,2042.9244,2038.3135,2034.8557,2031.5986,2033.0153,2034.9456,2036.854,2036.4031,2036.1708,2034.4839,2030.5916,2026.2744,2024.4875,2024.4875,2024.3168,2024.1887,2023.2205,2022.146,2022.146,2023.018,2023.146,2021.5728,2019.1367,2015.8716,2011.4355,2007.9995,2004.7974,2003.1276,2001.6915,1999.2556,1997.7628,1996.2305,1993.9475,1992.1741,1988.8344,1986.298,1982.8619,1981.023,1977.8191,1975.282,1971.9471,1968.6027,1965.3289,2077.2039,2082.169,2083.4822,2076.9614,2067.5842,2058.976,2051.852,2045.696,2040.5686,2035.6967,2030.3646,2023.7238,2023.5658,2025.7465,2027.4379,2029.1418,2030.3098,2031.3646,2031.4893,2030.7141,2029.2554,2029.0,2029.0,2029.6388,2031.3302,2033.0216,2034.7661,2033.8942,2031.6349,2029.0222,2026.5862,2023.4362,2019.6754,2015.4089,2011.8422,2010.4061,2008.9702,2007.9623,2006.3535,2004.9176,2002.8837,2001.7661,1999.6096,1998.1348,1995.9929,1993.557,1991.237,1989.4296,1986.2281,1982.4674,1978.7068,2069.2234,2074.7087,2077.6177,2074.184,2066.5176,2058.44,2051.852,2045.544,2038.5544,2033.2704,2027.7665,2021.5973,2017.1842,2016.0416,2018.4777,2021.3499,2024.0071,2026.1488,2027.5848,2028.3184,2027.7595,2026.3184,2025.6368,2029.2361,2036.2456,2039.3632,2040.3632,2039.4039,2037.5835,2035.6191,2033.1259,2030.4288,2026.9928,2023.9058,2020.1207,2018.9302,2017.7914,2016.7263,2015.832,2013.6555,2011.5048,2009.734,2007.9136,2006.7748,2004.7607,2003.0448,2000.8888,1999.1344,1996.6984,1994.2623,1991.5079,2062.8767,2067.691,2072.5378,2071.4966,2065.2356,2058.44,2051.9292,2046.6517,2039.3438,2033.0598,2027.1382,2020.4086,2013.9683,2009.0414,2009.8806,2012.8876,2015.8204,2019.5928,2022.619,2024.7844,2023.7844,2022.4482,2021.6766,2022.6904,2025.683,2032.2455,2037.0519,2039.7706,2040.6506,2039.444,2038.0356,2036.5996,2034.2714,2031.8353,2029.499,2028.4312,2027.4312,2026.2242,2024.8352,2023.3271,2020.8912,2018.4552,2017.0192,2015.3397,2013.0394,2010.6034,2008.3234,2006.7313,2004.4281,2002.8594,2001.3234,2052.6301,2058.1523,2061.302,2061.14,2059.554,2057.0364,2052.568,2049.23,2042.578,2036.4749,2029.154,2022.846,2013.1381,2003.3418,2002.602,2005.8702,2008.474,2010.91,2014.3182,2016.5769,2017.398,2016.2787,2015.398,2016.398,2017.962,2020.398,2025.3752,2032.074,2037.548,2041.7266,2042.4501,2042.068,2041.55,2039.8754,2038.1714,2037.602,2036.697,2036.602,2035.7567,2034.0875,2032.13,2029.694,2026.724,2024.288,2021.318,2018.882,2016.446,2014.01,2011.574,2009.8518,2008.1213,2041.3632,2046.7166,2049.171,2049.5908,2051.0032,2051.1082,2051.0398,2048.7358,2043.236,2036.952,2030.16,2022.3518,2011.3798,1999.2303,1992.607,1999.3739,2002.1556,2004.1,2006.0674,2008.528,2010.1194,2008.8735,2008.1194,2009.2474,2011.6833,2014.0796,2016.9915,2021.8981,2029.4187,2036.8533,2042.4325,2046.2075,2047.9183,2047.3926,2045.9565,2044.8806,2043.8806,2042.8806,2041.9204,2040.8164,2039.3804,2037.9435,2036.4686,2033.1448,2030.284,2026.4294,2023.7246,2021.2886,2019.8525,2017.8622,2015.9766,2031.268,2034.604,2036.6644,2038.8624,2041.2983,2043.8425,2045.4543,2044.6888,2040.5312,2035.5416,2028.2336,2018.7874,2007.1808,1994.2328,1982.8083,1986.6016,1993.1907,1995.4543,1997.4023,1999.4543,2000.7712,1999.7418,1998.4543,1999.1174,2001.3645,2004.4543,2008.0588,2012.5353,2020.4974,2029.8168,2037.7672,2045.3132,2050.4385,2051.087,2050.4158,2049.6338,2048.898,2048.2441,2047.5146,2046.709,2045.2328,2042.7968,2041.2017,2038.9248,2036.6631,2034.611,2031.8472,2028.5673,2026.7448,2025.3088,2024.7728,2021.6809,2023.2856,2024.9089,2027.345,2031.4376,2035.2571,2037.5621,2037.5337,2035.309,2029.6731,2022.7072,2012.1017,2000.9022,1988.5782,1974.7628,1973.442,1979.4637,1984.0525,1986.7073,1988.3209,1989.9032,1989.5415,1987.245,1985.9609,1987.6067,1992.3118,1998.9758,2004.4696,2012.7942,2021.7942,2030.5822,2040.0262,2047.469,2049.8628,2051.2988,2052.0,2051.8125,2050.8125,2050.8125,2049.8125,2049.2727,2047.6492,2045.2133,2042.8057,2040.5286,2039.0402,2036.6566,2035.0332,2032.5972,2030.1613,2028.7252,2012.1687,2014.0448,2014.0448,2016.4528,2020.494,2024.366,2026.8059,2026.6539,2024.4568,2020.7397,2013.6648,2003.5399,1992.3848,1980.4436,1968.4188,1961.892,1964.7191,1969.5912,1974.4756,1976.19,1978.0018,1978.8499,1977.3528,1975.8059,1977.6088,1981.2836,1986.5916,1996.9799,2007.8279,2016.7544,2024.2424,2033.1316,2039.3876,2043.1431,2045.7482,2045.8059,2045.9961,2047.2767,2048.9517,2049.6265,2053.2712,2054.0662,2047.8268,2045.1884,2043.171,2041.5188,2040.0828,2038.3362,2036.2108,2033.9028,2031.4149,1999.7749,2002.2109,2003.647,2005.4767,2009.028,2012.955,2015.1511,2015.34,2013.361,2009.611,2002.4758,1993.756,1983.4562,1972.1649,1960.32,1951.0599,1950.8269,1955.8705,1960.906,1965.3143,1967.34,1967.5048,1965.9829,1964.0951,1967.178,1973.005,1982.3689,1993.695,2004.567,2013.567,2020.21,2026.2369,2030.7789,2034.828,2035.3905,2034.6749,2033.6749,2035.907,2039.676,2043.5132,2047.3909,2049.662,2048.588,2045.4869,2043.716,2041.615,2040.2827,2039.8016,2037.972,2035.8446,2033.1,1994.1642,1992.1415,1992.544,1994.006,1996.388,2000.7328,2002.4528,2003.3008,2000.8647,1997.496,1991.7152,1984.9471,1975.0055,1962.8864,1952.1329,1946.2104,1942.7954,1944.1005,1947.4008,1952.1857,1955.2727,1956.4761,1955.6982,1956.8544,1959.9456,1967.9088,1980.0491,1991.1892,2001.8328,2008.9817,2013.9227,2017.2511,2019.596,2022.032,2024.4679,2023.8568,2021.6351,2023.4224,2030.7303,2035.1201,2040.8064,2044.6805,2045.3519,2042.9696,2039.8829,2038.8431,2037.9088,2037.9088,2037.9088,2036.4448,2032.1909,1999.8662,1991.3896,1985.0289,1982.5082,1982.8148,1984.6581,1986.2411,1986.9689,1987.3075,1984.3889,1981.4929,1975.2423,1965.4305,1953.5729,1947.2786,1943.5626,1937.924,1936.2177,1935.4478,1938.0171,1941.2329,1944.5454,1946.6223,1949.2212,1955.949,1964.9652,1977.2266,1987.3914,1997.5311,2002.7092,2006.1104,2007.7317,2008.4398,2009.9188,2012.3369,2012.744,2011.1344,2014.229,2023.28,2030.1732,2035.0452,2038.9412,2039.5532,2038.1172,2036.6812,2035.1101,2034.9652,2034.9652,2034.9507,2033.5012,2030.117,2008.4365,2000.249,1989.9977,1977.9266,1971.4635,1969.3541,1970.1107,1970.5945,1971.3947,1971.3143,1968.8524,1962.6503,1953.622,1947.3146,1944.0449,1943.9279,1942.7549,1940.3188,1936.9392,1934.5813,1934.1027,1936.3688,1937.8612,1942.674,1952.7238,1961.1128,1971.9132,1980.6571,1989.82,1994.9695,1997.2256,1996.282,1998.2285,1999.7135,2001.2213,2000.678,2002.8291,2007.8087,2016.8224,2026.1663,2029.6832,2033.1451,2035.1128,2034.1128,2032.0968,2031.1128,2029.9656,2029.1357,2028.1692,2027.6749,2026.2128,2010.3302,2001.392,1990.7701,1979.5902,1967.5662,1960.8236,1959.7396,1958.6272,1957.3032,1955.0415,1953.6614,1950.1256,1945.9647,1946.5077,1948.8151,1950.3462,1952.1095,1950.9673,1946.9338,1940.7113,1937.5029,1934.1138,1933.3221,1936.9668,1945.1466,1954.5208,1963.99,1972.056,1980.3308,1985.8949,1985.4541,1983.9048,1986.2222,1989.4967,1991.8624,1993.2505,1996.8524,2002.9564,2010.6853,2017.8328,2022.2604,2024.8666,2027.52,2028.2604,2027.9763,2026.5404,2024.7922,2023.2604,2022.6301,2022.6301,2022.6301,2003.6752,1998.2639,1986.5256,1975.2214,1967.3115,1967.407,1968.0381,1965.7072,1959.624,1952.1361,1949.0219,1949.3053,1951.7804,1956.3121,1960.0217,1961.6935,1961.9196,1960.2645,1955.5334,1949.1104,1942.7848,1937.284,1933.104,1933.358,1937.651,1943.8159,1952.7639,1962.3301,1969.6359,1974.3561,1975.6359,1973.2,1973.9199,1978.9958,1982.7399,1985.2585,1990.9584,1997.872,2003.8802,2009.82,2013.2621,2016.787,2021.5559,2024.256,2024.1239,2022.2611,2021.0798,2020.204,2019.4022,2018.8346,2018.408,1995.211,1989.7253,1979.4734,1971.9618,1972.32,1977.8933,1981.1124,1978.8071,1973.4778,1966.5022,1962.9756,1963.2524,1966.4431,1968.8792,1970.0929,1970.8889,1970.6075,1968.7565,1964.7706,1957.7369,1949.4288,1942.8418,1936.0604,1931.288,1930.5298,1933.4445,1940.6329,1948.727,1956.8129,1962.3768,1963.9312,1961.4098,1965.4374,1968.9786,1973.1644,1978.6355,1986.7213,1992.2,1997.8177,2002.4374,2005.8733,2008.5262,2011.7,2016.9111,2019.3965,2018.9956,2017.9653,2017.1858,2015.5338,2014.0916,2014.4556,1988.5383,1982.0991,1973.797,1972.1128,1981.517,1990.3352,1993.2421,1991.5865,1987.0662,1981.1857,1977.2421,1977.5571,1978.809,1979.5938,1980.3138,1979.7202,1978.8693,1977.4332,1973.716,1967.4417,1958.602,1950.1772,1941.1772,1935.0858,1930.1688,1925.0,1927.6552,1938.9393,1946.222,1950.8943,1951.6946,1951.1897,1954.8618,1959.3712,1965.8,1973.3682,1980.4427,1986.6692,1991.606,1995.2627,1998.9448,2002.0308,2006.5271,2011.3992,2014.6356,2016.17,2015.8988,2014.6161,2012.3236,2010.3516,2010.3516,1976.6014,1973.3147,1971.0259,1978.7465,1992.5186,2002.2131,2006.1104,2003.9945,2000.0479,1993.3252,1989.8385,1989.1277,1989.2239,1989.2985,1989.2833,1988.6316,1987.2928,1984.7483,1981.324,1976.3812,1968.0186,1958.963,1949.1709,1940.8303,1934.4247,1927.1493,1922.6061,1928.1991,1938.3634,1943.3387,1945.8507,1946.8967,1948.0294,1953.3529,1959.6931,1965.8561,1973.1641,1979.4548,1985.0375,1987.6423,1990.2817,1995.7263,2002.1306,2007.61,2012.2094,2013.6454,2013.9254,2012.3334,2009.8994,2008.496,2008.0,1971.5009,1972.2701,1976.42,1988.4513,2002.2233,2012.2816,2014.0017,2012.6976,2008.3265,2002.9553,1998.773,1997.5024,1997.5024,1997.5024,1998.0033,1997.183,1996.9274,1993.9794,1988.1593,1982.7345,1976.4518,1966.4785,1956.7345,1947.5537,1939.5281,1931.0017,1924.6288,1922.0,1929.037,1938.9867,1941.6792,1943.3069,1945.0503,1948.4863,1952.8827,1958.3972,1964.5886,1971.4607,1975.6647,1976.652,1981.5775,1988.4136,1997.6464,2004.119,2008.9249,2011.2191,2011.4991,2009.9072,2008.4712,2007.0352,2006.4991,1981.6549,1985.5613,1989.5321,1998.7482,2010.1458,2016.4141,2019.5178,2018.6292,2015.2231,2010.7571,2007.7476,2006.7081,2006.7081,2006.7081,2006.7081,2005.7811,2004.7051,2002.7571,1997.8641,1990.6292,1982.5011,1972.8301,1963.086,1953.342,1944.5663,1935.854,1928.5049,1923.1737,1922.7114,1930.2678,1938.2529,1939.502,1939.2018,1942.6696,1946.0669,1949.939,1954.8839,1960.5408,1964.0328,1967.4999,1973.3383,1982.0516,1991.867,2000.7689,2004.4299,2006.866,2008.073,2007.1028,2006.0449,2004.112,2003.173,1993.9662,1999.0275,2003.0815,2008.8461,2015.945,2021.3654,2025.6062,2024.6082,2021.7382,2019.0201,2016.2505,2015.413,2015.413,2015.413,2014.9277,2014.0597,2012.3861,2010.5477,2006.5505,1998.9221,1988.7797,1978.6825,1968.9385,1959.1945,1948.8152,1941.413,1936.105,1929.4889,1923.7372,1924.1348,1928.947,1932.2031,1933.3792,1936.4283,1937.9403,1940.307,1945.1791,1948.8191,1952.9231,1959.6422,1968.4535,1977.5508,1985.796,1996.6318,2001.1837,2002.6467,2003.6467,2003.2936,2002.6368,2001.6467,2000.6467,2006.1752,2011.9692,2015.8474,2021.7131,2025.7412,2029.616,2031.3383,2030.4069,2028.4292,2026.3143,2024.3383,2024.3383,2024.3383,2023.5703,2022.3383,2021.3383,2019.2623,2017.0469,2013.6628,2005.503,1994.2789,1983.5349,1973.7909,1964.0469,1954.9861,1950.1178,1945.6853,1937.7223,1928.2422,1922.4556,1923.2603,1924.4412,1926.7543,1930.1497,1931.6449,1933.8011,1936.4127,1938.5271,1946.1864,1955.8342,1964.9597,1973.3691,1981.2189,1990.0201,1997.3884,2000.0023,2000.2206,2000.2206,1999.4349,1998.7566,1997.2427,2015.002,2020.225,2026.533,2031.6385,2036.3049,2038.617,2038.9009,2037.465,2035.0289,2033.3922,2032.617,2032.617,2032.617,2032.0068,2030.6185,2028.9769,2026.5409,2024.1049,2019.721,2009.2856,1997.1056,1987.1816,1977.4376,1968.9257,1962.6049,1958.617,1953.1033,1944.1289,1935.3215,1926.0262,1920.9886,1919.5887,1921.1881,1923.7657,1926.3071,1927.8746,1929.0154,1933.2847,1942.3981,1953.1063,1961.2087,1968.5167,1975.6191,1982.7527,1988.8927,1991.8975,1993.3014,1994.7694,1995.3888,1995.5887,1994.7943,2024.2592,2028.4286,2034.8115,2039.7115,2043.5835,2046.1755,2046.8955,2045.8396,2043.9393,2041.5273,2040.5273,2040.5273,2040.5273,2039.8955,2038.6915,2036.2555,2033.8196,2030.8716,2024.1697,2012.5704,1999.5319,1989.446,1980.301,1973.2166,1971.9634,1967.5273,1958.7952,1950.6477,1940.145,1931.2877,1923.8562,1917.7838,1913.7555,1915.5925,1918.3687,1920.4645,1922.5323,1927.947,1936.9862,1949.4165,1956.0151,1963.0325,1968.0802,1973.7045,1978.8612,1982.0157,1984.203,1986.5463,1989.3961,1991.2003,1993.2682,2033.4741,2039.2461,2043.1761,2047.6058,2051.018,2052.454,2053.174,2053.174,2052.2322,2051.2083,2049.2903,2049.2383,2048.2322,2048.174,2046.9701,2043.9313,2040.9641,2036.0624,2026.214,2014.1381,2002.1276,1993.049,1985.75,1982.0536,1979.6682,1976.1161,1964.9941,1954.6355,1944.8439,1935.884,1928.8617,1923.3619,1914.1222,1911.0297,1911.9375,1913.281,1915.6218,1922.5219,1930.8298,1940.2358,1949.3878,1954.7778,1959.2037,1964.3699,1970.3523,1974.3239,1978.205,1982.5103,1985.97,1988.4329,1990.8478,2041.1886,2047.2854,2052.881,2056.345,2058.2966,2059.5884,2060.937,2060.937,2061.4211,2060.937,2060.2156,2059.5032,2057.7761,2055.6848,2053.15,2050.0186,2046.2562,2038.7003,2026.8231,2015.266,2004.7814,1997.4565,1992.5627,1989.4528,1987.8405,1981.4528,1972.7087,1961.515,1951.4972,1943.829,1936.9127,1930.1205,1922.2716,1914.2405,1910.521,1909.7014,1910.8275,1914.8472,1922.5513,1930.479,1938.4215,1944.5308,1951.286,1958.1382,1964.3678,1969.9558,1974.8278,1979.4131,1983.5437,1986.9797,1988.9515,2050.0225,2056.2913,2061.6753,2065.0498,2067.4858,2068.9219,2070.6418,2071.6418,2071.6418,2070.6199,2068.6902,2066.8354,2064.489,2062.053,2058.4128,2053.5981,2047.696,2038.952,2026.4489,2015.464,2008.2705,2003.4753,1999.4093,1996.8479,1995.5138,1988.7313,1980.9369,1972.1538,1962.4098,1953.4994,1944.1913,1936.3225,1928.5753,1922.6658,1915.9525,1911.1332,1908.0713,1910.6223,1914.6644,1921.5807,1928.397,1934.2207,1945.2917,1954.6335,1961.9415,1967.5295,1972.5436,1977.2736,1981.1431,1984.5536,1986.0896,2057.31,2064.2625,2069.2905,2072.418,2074.854,2076.29,2077.7258,2078.1619,2078.812,2077.6575,2075.855,2073.7773,2070.0093,2065.8005,2060.8599,2054.08,2046.696,2037.6154,2026.26,2018.6506,2012.7065,2009.7539,2006.626,2005.01,2003.0718,1998.01,1988.8918,1980.522,1970.778,1960.1201,1949.4012,1943.1146,1938.2426,1932.3947,1923.2635,1915.1687,1910.0126,1907.1539,1909.9948,1912.8013,1918.1185,1927.2307,1939.7767,1951.0042,1958.5154,1965.009,1970.1313,1975.8473,1978.6914,1981.1273,1982.6296,2064.6648,2072.2505,2076.2393,2078.6965,2081.1326,2082.7393,2084.4583,2085.2886,2085.3862,2084.2646,2081.8286,2077.7336,2073.9404,2068.2268,2061.388,2054.08,2045.8572,2035.5797,2028.6941,2024.9045,2021.274,2017.0326,2013.6696,2012.5258,2011.2582,2006.0514,1996.5446,1988.6726,1978.7485,1967.5497,1957.6487,1951.4406,1946.1449,1940.434,1931.4314,1921.8485,1913.3264,1908.2988,1905.3955,1907.5782,1911.9662,1924.3303,1934.1223,1944.9514,1954.3263,1960.9143,1966.9053,1973.1099,1976.2651,1977.8282,1979.2372,2071.6782,2078.6392,2082.539,2084.975,2087.4111,2088.7942,2090.1477,2089.6904,2089.2668,2088.165,2085.729,2082.397,2076.336,2069.696,2061.388,2053.44,2045.7103,2036.4464,2033.1989,2029.9215,2026.5581,2022.8661,2019.6862,2017.378,2015.8141,2012.378,2004.8231,1995.0792,1985.5242,1976.365,1969.4053,1961.9082,1953.3591,1945.9141,1939.6061,1929.2482,1918.5486,1910.7689,1905.853,1902.7913,1906.5929,1918.5018,1928.8579,1937.1659,1949.6226,1956.8348,1963.1229,1968.8059,1973.4381,1974.7096,1976.7109,2076.7537,2085.3025,2089.1917,2092.0027,2093.7498,2095.8457,2095.8457,2095.0786,2093.0273,2090.5913,2087.54,2083.208,2077.004,2069.696,2061.388,2054.6953,2047.0785,2042.2065,2037.9177,2034.2255,2030.5905,2027.7185,2024.2722,2023.1025,2020.6665,2016.2305,2011.4077,2002.4365,1993.9218,1985.7712,1978.8013,1970.9971,1960.6378,1951.0815,1944.3826,1936.652,1924.7402,1914.4811,1907.6112,1901.896,1900.8802,1913.0103,1923.164,1931.6398,1941.8583,1952.6525,1959.1775,1964.7257,1968.4235,1970.8488,1974.2233,2080.5415,2089.1357,2095.0269,2098.5078,2101.0098,2103.1543,2102.4084,2099.7788,2095.8655,2092.953,2088.1023,2083.2124,2077.0454,2070.5054,2064.6335,2059.148,2051.9277,2047.059,2043.0956,2038.2894,2035.2214,2031.7854,2029.0542,2026.9135,2024.4774,2020.0415,2014.1694,2008.4254,2000.7622,1992.3523,1984.543,1977.1935,1967.8749,1957.1724,1948.3109,1940.9614,1929.3069,1918.1134,1910.0098,1902.792,1898.4376,1905.7981,1916.5651,1925.4548,1935.0116,1947.1542,1954.3851,1961.0841,1964.9451,1967.3811,1971.717,2082.4,2091.361,2098.944,2104.4744,2108.8523,2109.9353,2108.6006,2103.1636,2098.2917,2094.4197,2089.08,2084.627,2078.6484,2072.9316,2066.9644,2061.3794,2055.3157,2050.2153,2045.5717,2041.0836,2037.8276,2035.2117,2032.4072,2028.872,2025.6399,2022.0,2015.692,2009.3241,2002.384,1995.024,1987.46,1979.6196,1971.2596,1961.5156,1951.7361,1942.92,1933.5963,1920.9485,1911.1512,1901.792,1897.2449,1900.9408,1910.7126,1919.5376,1928.733,1938.477,1949.138,1954.9718,1959.6101,1962.278,1967.7646,2083.3,2091.608,2098.919,2106.1807,2110.844,2109.8262,2107.3901,2103.786,2099.412,2094.952,2089.5974,2085.208,2079.336,2074.464,2068.388,2061.72,2055.848,2050.976,2046.9514,2042.616,2039.913,2037.6378,2034.5099,2029.744,2026.436,2022.0,2015.128,2008.384,2002.076,1994.768,1987.2991,1979.2582,1970.8462,1960.2603,1951.2361,1942.9879,1934.02,1921.8646,1911.0629,1899.8982,1896.46,1899.0555,1905.4482,1912.8463,1921.4545,1931.1984,1941.7864,1948.5457,1953.2433,1957.1403,1964.7062,2082.98,2090.4595,2097.916,2104.1758,2106.63,2106.0798,2103.6438,2100.5278,2097.9038,2092.3118,2087.44,2082.888,2078.0159,2073.9119,2067.3228,2060.4,2055.5278,2050.8198,2046.7485,2042.493,2040.1224,2037.424,2034.2959,2028.831,2025.2555,2021.0,2014.5115,2008.384,2000.756,1992.704,1984.6399,1975.3147,1963.8318,1954.924,1947.2678,1939.2799,1929.3146,1917.9541,1907.1115,1900.2161,1897.4673,1896.976,1901.3721,1907.6324,1914.8918,1923.6893,1932.2938,1938.9037,1945.1238,1952.2158,1961.3799,2081.5283,2088.8618,2096.895,2100.7651,2102.5076,2100.5076,2098.7915,2095.4958,2090.8389,2085.9788,2082.5874,2078.638,2074.674,2070.1445,2064.6418,2058.5427,2053.8672,2049.6118,2045.3445,2040.4857,2038.2538,2035.8066,2031.1234,2026.347,2022.6897,2019.2538,2014.128,2008.384,2000.076,1991.2128,1981.2194,1967.9678,1954.8069,1946.5509,1939.2429,1930.8286,1921.2369,1912.2166,1910.9058,1907.7771,1901.8928,1896.7943,1897.7703,1901.5321,1908.1475,1915.1039,1922.4829,1929.6407,1937.6195,1947.8275,1959.7538,2079.2827,2085.4355,2092.576,2098.063,2097.811,2095.75,2090.8782,2086.0322,2081.9656,2079.4346,2076.0227,2072.8452,2068.8757,2064.7546,2060.247,2055.4854,2051.516,2047.3156,2043.095,2038.0596,2032.7322,2026.5415,2023.6182,2021.3546,2019.0159,2016.655,2014.3915,2010.1056,1999.8212,1990.8956,1979.9586,1965.5155,1950.792,1940.8755,1932.0555,1922.982,1915.2631,1915.1139,1918.2427,1916.3955,1909.3574,1900.2487,1894.6184,1895.0323,1900.7546,1906.4701,1912.649,1920.22,1931.7671,1942.4391,1955.9999,2077.6013,2082.4734,2087.1648,2089.769,2089.1626,2086.0454,2081.772,2078.991,2075.616,2072.7644,2069.5593,2066.3079,2062.54,2059.0347,2054.9182,2051.3071,2047.6962,2044.5828,2041.0729,2037.232,2027.9723,2018.5828,2013.499,2013.204,2013.204,2012.8026,2011.3667,2007.6321,2000.5381,1990.28,1979.28,1964.072,1950.74,1938.9469,1929.6748,1923.4955,1922.674,1924.6267,1926.796,1924.38,1915.8528,1905.892,1897.1974,1889.395,1889.716,1895.8777,1903.828,1914.007,1927.8866,1936.8448,1949.704,2075.1726,2078.4863,2080.9495,2081.5173,2080.0813,2077.6453,2075.2095,2071.7734,2068.7493,2065.9014,2063.0168,2060.0542,2056.6182,2053.188,2049.7463,2046.3103,2043.8743,2041.4382,2039.0271,2035.2224,2026.7156,2013.6951,2005.5319,2004.0502,2004.9114,2003.9254,2002.4645,2000.9222,1999.0186,1988.2488,1977.2506,1962.6536,1947.7139,1936.9991,1929.4208,1929.1244,1930.9204,1933.3257,1933.0663,1928.8169,1921.4412,1912.17,1902.4266,1892.6577,1885.7338,1888.3903,1897.7053,1909.4875,1921.0374,1931.2454,1942.5254,2071.2979,2074.098,2075.098,2074.2388,2072.3518,2069.9158,2066.9307,2064.0437,2062.0588,2059.6096,2056.8904,2055.155,2051.7659,2048.4346,2044.6898,2039.9156,2037.6467,2037.0979,2035.1499,2031.3298,2024.6378,2010.9333,1999.4011,1995.589,1995.7446,1995.1957,1993.014,1992.1957,1989.9596,1983.0063,1973.1167,1958.3347,1944.74,1937.6234,1938.8043,1940.002,1940.3533,1940.7975,1938.4164,1933.186,1926.5786,1917.9982,1908.2542,1897.5101,1887.883,1884.9167,1890.286,1902.4227,1912.7742,1923.725,1934.2467,2065.3577,2067.904,2068.3682,2066.0828,2063.647,2061.0881,2058.652,2057.0935,2055.296,2053.3442,2050.9082,2049.3494,2047.9135,2044.6809,2040.7147,2034.2812,2028.5469,2028.0627,2028.3745,2025.8615,2019.0881,2007.8741,1997.6249,1987.0051,1985.9321,1986.4908,1984.0013,1981.7258,1979.2678,1975.6555,1965.5908,1954.0143,1948.8394,1950.3864,1950.3864,1948.5876,1946.8358,1945.3191,1941.5005,1936.6565,1930.2008,1923.8295,1914.056,1902.3918,1894.408,1887.3146,1883.6802,1891.5236,1903.6274,1914.7451,1926.77,2059.1895,2060.7664,2060.1174,2057.6816,2055.2456,2053.308,2051.3735,2050.0896,2049.393,2047.369,2045.933,2045.3931,2044.1617,2041.6954,2038.2886,2031.1365,2021.9769,2020.3857,2019.4984,2017.8312,2013.3949,2002.8397,1992.6295,1984.4406,1981.1326,1977.3931,1973.957,1972.521,1971.1785,1969.1783,1963.3016,1961.4814,1960.5016,1959.4225,1957.9865,1955.4412,1952.2566,1949.143,1944.9675,1939.0955,1933.6835,1928.3514,1920.371,1912.3665,1903.5571,1893.0304,1885.9915,1884.4166,1893.6506,1906.7828,1918.3164,2052.5676,2053.811,2052.8186,2049.4028,2046.9669,2046.531,2044.6174,2043.5406,2043.1116,2041.787,2040.8109,2040.5406,2040.4509,2039.4396,2035.9175,2029.613,2021.848,2017.2463,2011.118,2008.427,2001.8013,1995.2155,1987.8202,1984.366,1981.2836,1976.7297,1974.0233,1973.4594,1973.1514,1972.4594,1971.1404,1970.1891,1969.175,1967.5626,1964.5354,1961.5664,1957.8673,1953.0581,1947.3937,1942.1755,1936.6497,1930.7777,1925.3823,1917.9154,1909.8458,1898.054,1888.3038,1880.9486,1884.923,1897.5267,1908.6813,2046.7726,2047.6882,2046.5603,2043.2167,2039.8444,2037.296,2036.6882,2037.5323,2037.036,2035.668,2035.3041,2036.6005,2036.8441,2036.8441,2034.4362,2028.9241,2021.9921,2016.976,2011.3038,2006.848,2001.36,1995.6439,1990.7719,1986.3118,1985.8357,1984.4677,1983.6235,1983.6235,1983.3635,1982.6635,1981.5995,1980.0076,1978.5195,1974.4917,1970.4637,1966.5918,1962.5638,1956.4598,1949.996,1943.792,1938.38,1932.2241,1927.3319,1920.7402,1913.9083,1901.4,1889.376,1879.5397,1877.8239,1888.8523,1898.9921,2041.3119,2041.8358,2040.8475,2038.0198,2034.0826,2032.418,2031.8358,2031.9243,2032.7661,2032.418,2033.0,2033.418,2034.418,2033.9708,2032.0099,2027.138,2022.2341,2016.976,2012.104,2007.232,2002.36,1997.637,1994.2928,1992.7462,1992.7462,1992.7462,1992.5641,1992.3284,1992.6176,1992.3284,1991.671,1990.7124,1987.2244,1982.5663,1976.3605,1970.862,1965.5267,1958.654,1949.996,1943.7314,1937.7979,1931.466,1926.5939,1919.2919,1913.1166,1901.237,1890.376,1879.8695,1874.0397,1880.7216,1889.4135,2036.9917,2037.4519,2036.0116,2033.5754,2030.3011,2028.7034,2026.9857,2025.9822,2025.9883,2029.0159,2031.0,2031.9917,2031.9917,2030.2238,2028.5854,2025.9948,2021.848,2016.976,2012.0962,2007.2352,2002.3683,1999.0166,1999.0223,2000.0166,2000.0166,2000.0249,2001.0166,2001.0238,2001.0249,2001.0249,2001.0249,2000.0281,1996.8606,1989.5526,1982.2369,1973.9283,1966.6202,1959.5443,1952.0126,1945.4883,1935.9238,1927.0879,1919.3403,1913.1354,1904.5824,1898.5742,1893.4022,1886.6617,1876.9764,1874.9242,1881.6752,2030.3054,2031.262,2029.7245,2027.723,2025.6537,2023.851,2022.415,2021.5656,2023.588,2028.024,2029.7654,2029.6107,2029.2335,2027.7975,2026.4502,2024.9255,2020.848,2015.976,2011.104,2008.4344,2006.9708,2005.3035,2004.869,2005.3035,2005.869,2006.3035,2006.55,2007.2479,2008.3035,2009.3035,2009.6598,2008.6875,2001.6904,1993.4825,1985.6625,1976.1981,1969.8425,1963.405,1956.5747,1948.0186,1938.5092,1927.989,1919.5535,1912.5865,1910.7279,1906.7324,1901.9033,1894.5275,1886.598,1875.9723,1875.422,2022.418,2023.418,2023.2825,2021.9275,2019.5739,2017.138,2015.5573,2018.5614,2024.176,2027.1633,2029.0,2028.2288,2027.093,2026.1393,2024.9353,2022.4993,2020.8374,2015.4166,2012.7358,2012.7214,2012.7214,2011.3617,2010.625,2010.8315,2011.7214,2011.7214,2012.6428,2014.3326,2016.7507,2018.2224,2018.2878,2015.4359,2005.6007,1995.468,1987.96,1980.6414,1974.1294,1968.0254,1960.1425,1950.6735,1941.7759,1932.8207,1923.9792,1920.5947,1918.4374,1915.2814,1909.1141,1900.9454,1893.6375,1883.6588,1873.1467,2018.3262,2017.4261,2017.4261,2016.0182,2012.6935,2010.7131,2010.9186,2017.456,2024.176,2026.737,2027.8451,2027.0742,2025.9048,2024.1654,2022.4506,2020.9698,2018.6589,2019.591,2018.8607,2018.8607,2018.8607,2017.3177,2016.0803,2015.952,2016.5739,2017.5739,2019.2968,2022.6047,2025.4556,2026.8607,2026.3422,2019.9331,2008.74,1997.8229,1991.78,1985.8538,1978.9574,1971.4254,1963.283,1953.584,1944.6669,1936.3589,1931.0367,1927.7694,1925.0057,1920.1338,1914.1505,1906.7979,1898.4897,1891.1818,1879.3894],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD017.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD017.py load and self-test diagnostics complete.")
