####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD016.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD016.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD016.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD016.x3d'),
    GeoLOD(center=(4344113.536173,740603.999947,1993.5),child1Url=["SquawLOD017.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD017.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw008.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw008.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4343332.077840,739994.999947,0),geoSystem=["UTM","Z10","N"],height=[1987.8167,1981.3167,1973.9166,1973.9042,1962.3,1949.1167,1933.0667,1924.4791,1922.0,1919.3917,1917.4584,1911.575,1901.5,1890.4,1888.1666,1888.0,1887.75,1887.0,1886.1666,1885.5625,1883.4,1882.0,1880.375,1879.3125,1878.1666,2010.2688,1999.0085,1992.1875,1988.6312,1977.4437,1959.2375,1943.725,1931.3711,1925.0938,1924.0938,1926.0938,1923.4172,1915.0938,1902.0305,1894.0375,1890.8899,1889.0,1888.0,1887.0,1886.0938,1886.0,1884.3883,1883.3203,1882.0938,1881.0938,2034.783,2016.6417,2005.8828,2003.852,1993.0361,1977.8112,1961.7393,1950.398,1941.4948,1933.343,1932.0679,1930.1886,1925.118,1916.0271,1904.9362,1898.8931,1893.8181,1889.096,1888.0591,1888.553,1888.0591,1887.0591,1886.0591,1885.0591,1884.0591,2049.751,2030.1821,2025.3655,2023.4308,2010.8729,1998.1229,1985.4363,1971.2466,1958.6802,1947.523,1940.2229,1937.9493,1939.0243,1927.8967,1917.895,1908.8424,1901.0826,1897.6736,1894.0729,1894.0486,1894.0243,1891.0486,1889.0243,1888.0243,1888.0219,2062.779,2051.7747,2049.7083,2041.3083,2027.7688,2011.0292,2000.8792,1990.7188,1975.8688,1961.8745,1953.1292,1946.0549,1942.9896,1937.7542,1925.6808,1920.7438,1916.9688,1913.5834,1908.5083,1904.4388,1901.3854,1899.3112,1896.9818,1895.9791,1895.9791,2074.8052,2067.9019,2063.421,2053.305,2038.3549,2020.9834,2009.8097,2000.3016,1989.5548,1974.5847,1959.1049,1950.0299,1948.9548,1950.8612,1942.4811,1935.5945,1930.5646,1927.4896,1924.4146,1920.3633,1916.2645,1912.1896,1908.8759,1907.8646,1906.9097,2090.4885,2081.2495,2070.4202,2058.646,2041.8,2027.4153,2017.7402,2006.6202,1994.5441,1981.3262,1971.9104,1968.6757,1960.8403,1966.8295,1963.4507,1956.0887,1949.3806,1944.2257,1938.3104,1934.2355,1929.5604,1925.0854,1922.8403,1921.7744,1916.9403,2107.4563,2093.9158,2071.3645,2057.0623,2046.0854,2037.4104,2032.4417,2021.4375,2007.1417,1996.1062,1988.5588,1986.7227,1983.5416,1984.7312,1985.5245,1981.0028,1974.0927,1966.6055,1959.5786,1953.9565,1946.9417,1941.8667,1938.8776,1935.8313,1928.7677,2100.8464,2095.976,2069.362,2054.4507,2044.409,2039.1493,2048.2366,2040.2087,2027.3027,2011.4185,2008.1259,2006.4666,2004.4028,2003.2646,2005.1259,2000.1777,1994.2521,1990.1771,1984.8856,1977.2035,1969.6534,1962.0043,1957.6528,1953.5778,1946.5028,2082.6704,2086.018,2067.046,2051.209,2040.384,2030.9338,2030.2861,2033.5521,2034.2393,2028.8569,2026.632,2026.632,2026.2639,2027.2639,2025.1139,2017.9979,2009.9031,2005.4479,2001.8967,1998.7389,1994.4799,1989.2806,1984.8038,1978.2136,1971.0143,2065.9563,2075.4375,2064.414,2050.025,2035.8875,2024.679,2012.4578,2016.2812,2022.3562,2026.4375,2024.5547,2025.5648,2037.6562,2040.7063,2037.4453,2032.2883,2025.9781,2022.2617,2020.2454,2016.6,2012.525,2009.45,2004.5938,2000.5188,1996.225,2046.5674,2055.2673,2055.7605,2051.675,2041.0986,2027.05,2006.6428,2001.0104,2006.4604,2012.5354,2012.8724,2012.6854,2016.7604,2027.2389,2040.7689,2045.2396,2043.1636,2040.8646,2039.379,2037.36,2033.234,2026.3112,2020.4896,2016.0305,2012.0115,2025.3528,2030.2032,2036.5807,2040.9583,2037.0612,2022.8132,1997.8264,1976.2461,1989.0546,1993.216,1994.591,1991.7291,1999.1528,2009.0896,2026.7528,2045.4115,2052.0,2051.1567,2049.712,2048.5605,2043.9966,2039.5173,2035.6736,2030.3104,2026.783,2005.0698,2008.4667,2014.0338,2019.6146,2017.0854,2003.5612,1981.3964,1957.6705,1959.3375,1968.9869,1972.5662,1969.3159,1976.2916,1995.6979,2015.773,2030.4915,2039.0657,2039.0377,2042.0646,2048.171,2049.4,2044.325,2041.0807,2037.852,2032.7771,1997.1489,1986.1355,1988.3959,1992.6198,1991.3882,1983.0055,1963.6805,1946.5092,1938.0729,1941.198,1948.3342,1951.4037,1966.3577,1989.7327,2005.3729,2011.511,2015.0881,2016.0555,2022.0696,2034.7653,2041.4584,2038.4739,2036.3577,2036.3577,2031.4576,2010.6608,1990.3,1966.4905,1959.9796,1960.7188,1956.8988,1945.7455,1947.5951,1948.6128,1939.3214,1934.0912,1938.0432,1957.1771,1975.477,1989.236,1987.1868,1993.7517,1996.1597,2008.1348,2023.702,2029.1694,2029.7847,2026.7847,2024.2834,2023.7847,1997.1813,1980.5813,1971.5391,1977.1125,1966.8104,1958.4375,1964.2224,1968.2916,1967.4198,1956.9667,1942.1687,1931.1179,1936.7084,1952.8304,1966.2213,1964.2643,1973.0083,1983.4609,1996.9464,2006.534,2012.1375,2020.668,2018.9974,2016.8541,2015.3698,1979.6246,1971.4752,1991.8064,2003.0542,1995.491,1986.4353,1987.1528,1987.1528,1984.076,1976.0646,1958.672,1939.8396,1926.5382,1931.1819,1945.4662,1947.5657,1957.1469,1970.5104,1984.2854,1990.8972,2001.1237,2012.1368,2014.4618,2010.6368,2008.4618,1979.0712,1987.5458,2010.3845,2018.1854,2012.7104,2005.539,2005.0139,2004.6992,2002.5104,1991.187,1973.6069,1953.3069,1935.007,1922.4657,1933.5116,1939.993,1944.7896,1953.4258,1964.3827,1972.3004,1989.6909,2004.5067,2008.4966,2006.5834,2003.5966,2004.5906,2014.7758,2024.8438,2030.4062,2027.0062,2023.4062,2023.4062,2020.7812,2017.0781,2007.4258,1984.6172,1964.2375,1948.875,1936.1062,1922.0797,1925.2875,1931.7344,1935.4375,1942.9437,1961.6312,1979.1813,1996.6188,2000.5312,2000.1445,1997.5844,2023.2701,2034.6521,2043.5521,2046.1182,2042.336,2039.7361,2039.4974,2036.6771,2031.602,2015.5591,1991.034,1973.0181,1966.7361,1949.5256,1929.3529,1916.0137,1916.9979,1921.8607,1932.9319,1953.9758,1966.898,1978.6139,1984.5564,1989.49,1993.466,2040.8573,2052.842,2058.448,2060.5972,2060.9966,2059.5972,2056.648,2051.1736,2041.2993,2017.9899,1998.0986,1989.2279,1981.1979,1960.2522,1942.1472,1928.1237,1912.1986,1910.2014,1919.1521,1935.9778,1949.6028,1962.6257,1974.1007,1983.2507,1988.9601,2057.3938,2069.7446,2075.2527,2078.0938,2078.475,2075.2542,2067.9788,2057.125,2040.6448,2020.2401,2010.2985,2005.1211,1998.0938,1979.7937,1958.4938,1942.0083,1929.2583,1912.8424,1908.3713,1915.0984,1936.0521,1956.6604,1969.1354,1978.4604,1982.599,2071.9597,2083.1646,2088.1572,2090.6597,2089.0618,2084.855,2073.35,2057.125,2039.2916,2030.8848,2023.9103,2017.7347,2012.6597,1994.7645,1975.919,1960.4194,1944.0597,1925.3658,1908.6113,1903.217,1925.7402,1946.2782,1962.0876,1972.7181,1976.5702,2080.7952,2095.9402,2102.4307,2102.5603,2094.895,2086.1902,2073.645,2062.0452,2049.1018,2039.5865,2032.4894,2027.3701,2020.2952,2007.9951,1991.1403,1975.4615,1954.5969,1937.5308,1913.9452,1899.95,1912.6917,1931.9105,1952.9097,1964.2347,1971.2097,2083.3,2099.4795,2110.2942,2106.154,2098.2,2087.7896,2076.9,2064.125,2052.6,2043.45,2038.15,2030.15,2022.0,2007.775,1993.2896,1977.006,1956.5396,1939.517,1916.2723,1897.475,1902.3833,1918.4196,1939.1537,1951.8688,1964.1052,2081.0742,2096.938,2101.355,2096.9246,2087.3875,2079.4802,2071.8745,2059.8994,2050.3743,2041.2244,2035.5406,2025.6986,2018.7743,2007.9838,1989.4,1963.5985,1942.1973,1924.9722,1911.553,1906.3278,1896.3292,1905.3479,1919.4037,1935.6229,1959.0486,2077.009,2085.602,2086.034,2079.231,2073.027,2066.5679,2059.068,2051.4873,2044.9181,2038.077,2019.1254,2011.2361,2011.2361,2006.2307,1988.0876,1959.832,1935.609,1923.4536,1928.023,1920.8977,1900.9819,1887.4172,1900.8203,1925.5521,1947.7552,2069.7312,2073.5312,2069.2422,2063.776,2059.1313,2054.2124,2049.2078,2039.8125,2035.4219,2030.9812,2011.7203,1993.3289,1992.5312,1989.375,1980.0813,1952.5977,1941.1907,1942.4688,1940.7922,1930.5813,1913.0687,1891.043,1887.1875,1909.675,1931.9906,2056.7354,2057.4604,2052.2942,2048.3499,2047.2355,2043.8208,2042.2069,2034.0491,2020.1785,2014.5139,2001.2274,1984.0284,1976.0,1971.1216,1968.9431,1964.4587,1961.4497,1955.9896,1948.2883,1937.0715,1924.516,1907.6646,1887.8716,1889.1105,1915.1139,2044.8264,2043.6514,2036.5764,2034.8264,2034.8784,2034.8677,2035.9132,2030.6632,2018.6,2008.45,1997.3868,1988.3354,1987.3472,1987.2604,1986.3472,1983.4146,1975.6604,1966.4236,1953.65,1940.95,1929.3479,1915.9468,1891.3151,1875.6818,1895.3615,2035.7916,2033.6687,2028.6068,2024.5708,2025.3688,2030.9479,2030.3745,2026.3555,2018.548,2008.45,2001.3063,2002.1041,2003.1041,2004.108,2004.2084,2002.9598,1989.1521,1971.9271,1957.7542,1940.0042,1921.2521,1907.1144,1897.6953,1881.9175,1878.5542,2020.9635,2019.9623,2015.6979,2013.621,2025.4,2028.5159,2025.9905,2023.3511,2016.6243,2015.0521,2014.1995,2013.9436,2015.0347,2018.1444,2023.0521,2015.1309,1994.1226,1980.2955,1965.6674,1946.9174,1929.2451,1922.3771,1912.7847,1896.5597,1876.4364],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD016.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD016.py load and self-test diagnostics complete.")
