####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD015.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD015.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD015.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD015.x3d'),
    GeoLOD(center=(4342525.411173,740603.999947,2002.5),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw007.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw007.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4341718.744506,739994.999947,0),geoSystem=["UTM","Z10","N"],height=[2022.3308,2022.4727,2026.2355,2031.5391,2037.8456,2042.4817,2046.8599,2051.934,2056.8062,2060.6543,2064.09,2068.422,2072.857,2075.277,2074.9392,2069.4958,2063.111,2060.4727,2060.6301,2061.5557,2069.6235,2079.339,2088.391,2095.5913,2101.443,2105.4727,2110.1184,2112.892,2112.8425,2112.8425,2111.6624,2110.166,2107.5808,2102.709,2097.9944,2092.9648,2087.4224,2081.7935,2073.8384,2066.5305,2059.835,2054.8904,2051.273,2049.8425,2049.8425,2048.8425,2046.3729,2041.6584,2036.782,2029.8289,2022.8849,2013.8889,2015.0897,2021.0826,2027.2605,2033.0891,2037.7245,2040.6776,2043.3187,2045.5913,2048.954,2054.3267,2058.681,2063.7385,2066.657,2066.6848,2062.8867,2057.036,2053.6548,2053.43,2056.2124,2064.5945,2074.2124,2082.5205,2088.7573,2093.86,2096.611,2101.0403,2107.875,2112.0303,2114.929,2115.5056,2113.9395,2111.489,2107.5796,2102.451,2096.8354,2090.89,2084.5818,2076.6057,2068.0698,2061.6577,2057.3018,2054.9802,2053.32,2052.2778,2050.5579,2049.1218,2045.5018,2039.2218,2033.8857,2025.5778,2003.711,2007.9053,2014.4716,2021.0574,2026.5214,2030.5934,2033.8271,2035.9854,2037.1111,2037.732,2044.3088,2049.227,2054.053,2057.8792,2057.9639,2055.2932,2051.4036,2047.1791,2046.8188,2048.9854,2058.8354,2068.8574,2076.6316,2081.9614,2084.3972,2085.389,2091.734,2101.3213,2108.1716,2113.5098,2118.7222,2118.551,2116.3403,2111.9739,2106.5964,2100.4644,2094.2776,2088.0261,2079.29,2070.4392,2064.1023,2059.7463,2057.3103,2055.8743,2054.4382,2053.0022,2050.5662,2046.816,2040.944,2035.4591,2028.0222,1995.8667,2001.7386,2007.254,2012.1493,2016.8546,2021.7267,2025.0493,2025.1414,2024.0,2024.2386,2032.38,2038.872,2042.942,2045.8066,2047.0,2045.6333,2043.2446,2039.4147,2040.606,2044.9854,2052.9468,2062.6907,2071.3193,2075.7947,2078.064,2080.6667,2084.0686,2095.86,2103.8987,2111.2786,2119.5266,2122.1667,2121.1233,2116.8694,2110.5613,2104.1467,2097.7786,2090.4707,2082.4946,2072.8547,2067.1768,2062.3813,2060.2646,2059.192,2057.8826,2054.4934,2050.844,2046.816,2041.944,2036.072,2029.3,1989.4055,1994.0916,1997.5105,2000.7605,2004.6931,2008.5044,2011.6604,2011.7925,2010.1436,2014.0071,2020.9355,2027.3475,2031.2765,2032.8026,2033.1484,2033.9445,2032.2278,2030.2573,2035.6102,2041.7804,2048.8489,2056.9346,2063.8198,2069.2947,2071.856,2076.7778,2082.0913,2090.0098,2099.89,2108.4644,2117.9988,2123.005,2124.5388,2120.9333,2114.8096,2107.2822,2100.2231,2093.3845,2084.81,2076.8062,2070.071,2067.2556,2064.8103,2062.704,2060.3271,2057.0,2051.3599,2046.816,2041.916,2035.608,2029.3,1981.0278,1984.3137,1985.8318,1990.1302,1993.419,1997.0178,2000.17,2000.6257,1998.8334,2003.8484,2009.6677,2014.6124,2018.9987,2019.7222,2020.678,2020.7222,2019.6504,2020.2627,2027.5206,2036.9854,2044.1233,2050.657,2057.2559,2062.28,2069.6606,2076.0,2081.9275,2089.3743,2097.9412,2106.2734,2115.4844,2121.5947,2125.052,2124.051,2119.3306,2111.031,2103.7117,2096.415,2089.1072,2081.799,2074.5466,2071.1365,2068.6992,2067.2075,2063.5034,2059.6155,2053.643,2046.8942,2042.9716,2036.1573,2030.4055,1971.7,1974.536,1976.972,1979.6119,1982.688,1985.56,1988.716,1990.0,1990.088,1994.048,1998.69,2002.292,2005.832,2007.268,2008.5,2008.5,2008.5,2010.78,2019.792,2028.844,2036.96,2044.768,2052.076,2060.512,2070.756,2077.5,2084.59,2092.116,2099.424,2107.232,2114.45,2120.54,2124.078,2126.012,2122.114,2115.56,2107.612,2100.188,2092.83,2087.24,2082.42,2078.524,2074.676,2071.228,2067.432,2062.7,2057.532,2051.224,2045.944,2040.608,2034.75,1959.3778,1961.8435,1965.2498,1968.6858,1971.9745,1975.5022,1977.9938,1979.1343,1980.3884,1984.2703,1988.1422,1991.1182,1993.5542,1995.0458,1996.2778,1996.2778,1997.3187,2003.7026,2012.0078,2020.3743,2028.5022,2038.3768,2049.768,2060.7124,2073.0796,2079.0,2086.308,2095.4324,2100.924,2108.1765,2114.36,2120.232,2124.104,2126.973,2124.0964,2119.8088,2112.501,2106.1375,2098.8665,2093.631,2089.7534,2085.8586,2082.0093,2077.1843,2071.6448,2067.449,2061.6238,2056.1128,2050.833,2045.497,2040.039,1948.1945,1951.5916,1954.4165,1956.8524,1959.2885,1962.3356,1964.3827,1964.8187,1970.591,1974.4591,1976.3367,1977.9515,1979.9987,1981.4347,1982.0555,1983.4133,1990.4207,1997.3694,2003.7294,2012.1471,2023.711,2034.8911,2046.802,2059.912,2071.6975,2078.611,2086.308,2095.099,2100.6843,2106.843,2113.1511,2119.848,2125.104,2129.0,2126.5408,2123.2778,2118.6992,2111.4707,2105.8306,2100.9587,2096.6267,2093.1907,2088.3428,2083.4707,2078.3147,2072.338,2066.4658,2060.9827,2056.0999,2050.8499,2045.4277,1936.7833,1939.3694,1942.8053,1945.748,1947.8074,1950.1133,1951.786,1952.4307,1958.3527,1960.8573,1962.46,1964.7467,1967.1653,1968.4734,1969.8367,1974.5266,1982.0487,1989.2026,1997.134,2009.0867,2020.5834,2031.5707,2043.6267,2055.9734,2067.5894,2076.1667,2084.4746,2090.9492,2097.7827,2103.5654,2110.7068,2118.6946,2124.2188,2127.6548,2128.846,2126.0066,2122.374,2117.8428,2111.6074,2107.3093,2103.0366,2099.528,2095.676,2090.804,2084.932,2079.1067,2072.3286,2066.8228,2061.6106,2056.572,2050.95,1928.2667,1930.7026,1932.8608,1935.0022,1936.7329,1939.169,1940.406,1943.4707,1947.4769,1949.6178,1951.2211,1952.6111,1953.8508,1956.0826,1959.8524,1965.9867,1973.0262,1982.1227,1992.1844,2005.1934,2016.7245,2027.4684,2038.9044,2051.177,2062.7004,2072.4443,2079.1597,2085.1885,2092.3684,2098.6765,2105.8545,2113.1858,2121.511,2124.9324,2127.3684,2127.8223,2125.4817,2122.046,2117.2195,2112.4517,2109.0156,2104.8748,2101.7314,2097.7075,2092.2654,2086.3933,2079.643,2073.0574,2067.4995,2061.9053,2056.7556,1918.4889,1921.4609,1924.0831,1925.5192,1927.0677,1927.3889,1929.4169,1934.4152,1938.4214,1939.1178,1940.2389,1941.2849,1944.5907,1948.8137,1955.1108,1962.1978,1969.8385,1978.0916,1987.3475,1998.7533,2011.5255,2022.5796,2032.6013,2043.7156,2055.9312,2065.8333,2073.8635,2079.5417,2086.4795,2093.7876,2101.0955,2108.2969,2115.7117,2121.0435,2123.223,2124.8157,2126.1304,2124.2583,2121.1465,2117.2363,2113.0322,2109.7463,2106.918,2103.3608,2098.8765,2093.929,2087.6987,2080.3906,2074.0903,2068.3875,2062.7166,1910.5167,1912.1133,1914.472,1916.7413,1918.2034,1917.6133,1920.932,1924.652,1928.0193,1930.3373,1931.7933,1934.4413,1938.8293,1945.3307,1951.4114,1958.5867,1965.728,1973.548,1981.344,1991.42,2003.4634,2014.4,2026.2167,2036.012,2045.756,2057.3333,2065.714,2074.0947,2080.5906,2088.8987,2097.2068,2104.0012,2110.7708,2115.0693,2118.424,2120.8,2121.6326,2122.6667,2121.9988,2118.896,2115.9333,2113.1907,2110.7546,2108.3186,2104.1687,2099.8933,2094.8914,2088.656,2081.444,2075.4946,2068.8,1904.8167,1905.9862,1907.7498,1909.1666,1910.0713,1911.0577,1913.4938,1916.8004,1919.7546,1922.1907,1923.6267,1928.5293,1935.3849,1941.9249,1947.1858,1953.0577,1959.3947,1966.7026,1974.0106,1983.0916,1993.7256,2004.3809,2017.8958,2028.6787,2038.4226,2047.5555,2056.8635,2065.7043,2075.7017,2084.4644,2092.9988,2100.0098,2105.2708,2108.953,2111.0906,2112.3066,2113.3516,2113.9443,2114.5557,2113.5557,2113.7778,2114.389,2113.1992,2111.0928,2109.2166,2104.7822,2099.9102,2094.808,2088.7493,2082.4414,2075.1333,1898.9889,1900.4249,1900.8889,1901.8889,1902.7329,1906.4333,1909.6049,1911.8973,1912.9215,1913.9128,1917.2433,1924.5214,1930.8849,1937.412,1942.2969,1947.169,1952.9854,1959.3137,1965.6738,1973.0067,1983.1589,1995.3694,2009.2549,2020.2898,2030.0894,2039.7778,2047.1414,2056.2659,2067.5874,2078.8093,2087.429,2094.7026,2099.8362,2102.3213,2103.7573,2104.229,2104.8333,2105.0654,2105.8333,2106.9373,2109.429,2110.943,2113.3564,2113.1992,2111.0398,2108.6,2103.799,2099.4863,2095.0286,2088.7449,2081.4666,1895.0,1895.268,1895.5,1896.408,1898.844,1902.78,1906.216,1908.5,1909.5,1910.524,1912.96,1918.688,1925.83,1931.536,1937.408,1941.96,1946.114,1950.268,1957.292,1967.036,1976.69,1988.28,1999.614,2010.512,2021.038,2031.0,2039.808,2047.116,2057.694,2072.092,2082.13,2088.732,2092.552,2094.988,2096.424,2097.5,2097.5,2097.732,2098.5,2100.604,2103.81,2107.464,2110.206,2112.348,2113.074,2110.64,2107.188,2103.316,2098.958,2094.34,2087.3,1890.1111,1890.1111,1889.1392,1890.9271,1895.7435,1900.3356,1903.7716,1905.2075,1907.0555,1908.0796,1910.5155,1913.8973,1920.107,1925.6898,1931.5304,1936.4111,1940.1913,1944.1351,1951.9003,1961.6813,1970.4467,1980.1907,1989.0287,1999.7413,2010.5095,2022.2222,2031.4989,2039.7827,2049.0146,2064.6165,2075.7068,2082.3987,2086.2188,2087.1938,2088.218,2089.1868,2089.2222,2090.1667,2090.8347,2093.3748,2097.6812,2101.1414,2104.9907,2108.9592,2111.3794,2111.5444,2109.6323,2105.7605,2100.9705,2098.0164,2093.0388,1888.0612,1888.0751,1887.6111,1888.408,1891.971,1896.6111,1900.6542,1902.7631,1904.6111,1904.6111,1905.6823,1909.6254,1914.8862,1920.2275,1925.3207,1930.1133,1934.2982,1937.948,1946.046,1954.6089,1963.2933,1972.8573,1981.7211,1990.2955,2000.0452,2011.0555,2021.7996,2031.8044,2043.4932,2058.1409,2069.3733,2075.2146,2078.4646,2079.6343,2080.398,2080.8333,2081.3198,2081.4443,2081.8333,2084.6523,2088.9844,2093.3965,2098.4055,2102.5293,2106.4014,2110.662,2110.172,2106.408,2103.35,2099.9248,2096.55,1887.0,1886.1666,1886.9767,1887.5067,1889.0106,1892.8467,1896.0493,1899.4854,1901.2646,1901.3293,1900.6267,1904.1254,1909.4407,1914.8694,1919.874,1924.6133,1928.4854,1934.276,1941.1774,1948.4854,1956.78,1965.524,1974.576,1981.0507,1989.9226,2001.5,2012.68,2025.5867,2038.1813,2051.964,2062.86,2067.732,2069.552,2071.5,2072.4368,2072.5,2073.33,2072.6667,2072.6667,2074.0413,2078.8232,2083.6187,2088.0693,2093.5293,2097.9507,2102.2266,2106.7812,2104.248,2102.3286,2100.9827,2097.1833,1884.7222,1885.0,1885.9922,1887.0,1887.9567,1889.2023,1892.1604,1894.5964,1896.4445,1897.4512,1898.0544,1900.3405,1903.9229,1909.5352,1914.8524,1919.7245,1923.6176,1929.9805,1936.2885,1943.0414,1949.9044,1958.2124,1966.2124,1973.6045,1985.3855,1997.7222,2008.0674,2019.4342,2032.7922,2044.1427,2054.5588,2060.676,2063.2188,2064.1667,2062.9648,2061.889,2062.611,2062.657,2061.4065,2063.068,2067.969,2072.8408,2076.713,2081.3071,2086.1792,2090.129,2092.767,2094.7756,2095.9246,2098.2957,2097.8223,1883.2778,1884.1489,1884.9797,1886.1133,1887.0,1888.0778,1889.1989,1890.32,1891.5555,1893.3018,1895.0155,1897.1738,1899.6097,1903.924,1909.3887,1914.8356,1919.7075,1924.7218,1929.9927,1937.9849,1945.7378,1954.3018,1963.0458,1971.0675,1981.3756,1992.5555,2002.9846,2012.2858,2026.1509,2036.8093,2045.3733,2051.343,2055.163,2056.2534,2054.8545,2054.0933,2054.8333,2054.6013,2053.8333,2054.8623,2057.5234,2062.063,2065.935,2069.2368,2073.7517,2076.5867,2080.2131,2083.6863,2086.417,2089.704,2092.2888,1883.0,1883.536,1884.0,1885.408,1886.7034,1887.0,1887.9526,1888.8334,1888.9313,1889.8573,1892.2034,1894.7294,1897.1653,1899.5626,1903.0747,1908.8867,1913.8187,1919.3694,1925.8353,1934.8827,1942.9767,1950.648,1958.6913,1967.0507,1975.9226,1985.6666,1997.774,2007.1547,2017.9886,2028.3093,2035.6934,2041.0786,2044.4287,2046.3334,2045.5634,2046.86,2047.8367,2047.4347,2046.6666,2046.6666,2048.6567,2052.2893,2056.1572,2059.1814,2061.854,2064.8867,2067.3594,2069.024,2071.5793,2077.0947,2080.2166,1882.0,1883.0,1883.9829,1884.6382,1885.3282,1886.56,1887.0,1887.3889,1888.0,1888.4036,1889.1788,1891.2849,1893.721,1896.1569,1899.1064,1903.4489,1909.617,1915.9249,1923.2329,1930.3063,1937.3077,1945.0911,1953.1229,1961.2115,1970.7673,1980.1666,1990.6913,2001.3156,2010.3987,2019.688,2026.9155,2031.0222,2034.6075,2035.5555,2035.1962,2039.2778,2041.6531,2041.7778,2041.7778,2041.1666,2041.7067,2044.1427,2046.6083,2049.4036,2052.0132,2055.2756,2057.7117,2060.5093,2064.1946,2067.6306,2071.0278,1882.0,1882.5062,1882.9984,1883.408,1884.844,1885.2644,1886.0,1886.9445,1886.977,1887.0227,1888.4344,1888.9943,1890.258,1892.6569,1896.3082,1901.2245,1907.1725,1912.9684,1918.6802,1925.0195,1931.3489,1938.6013,1945.9478,1954.4009,1964.0894,1973.8334,1984.5217,1993.3938,2003.0098,2011.0098,2017.0823,2022.8987,2025.7222,2025.7506,2025.7222,2032.7467,2036.6293,2036.876,2036.1653,2035.7294,2034.8334,2034.7778,2036.1898,2039.6173,2043.022,2046.2178,2048.9893,2052.9844,2056.8613,2060.791,2064.639,1882.0,1882.0,1882.0,1883.408,1884.422,1885.0,1885.358,1886.0,1886.294,1887.0,1887.0,1887.5,1888.166,1888.884,1891.714,1899.92,1905.19,1910.524,1913.448,1918.96,1925.55,1932.268,1939.422,1948.512,1957.474,1966.5,1976.026,1984.052,1993.232,2001.232,2005.27,2008.808,2011.526,2012.988,2014.886,2021.08,2026.796,2028.616,2028.5,2028.396,2027.23,2026.012,2025.0,2026.772,2031.926,2035.58,2039.234,2043.98,2048.556,2053.892,2059.3,1882.0,1882.0,1882.0,1883.0227,1884.0,1884.0,1885.0,1885.0,1885.0555,1886.0013,1886.03,1885.2036,1886.3691,1887.0427,1890.816,1900.5244,1905.0802,1908.5404,1911.0035,1913.4822,1919.5712,1926.8792,1934.1871,1942.6302,1951.8345,1960.1111,1968.4746,1975.7827,1983.1462,1989.5098,1994.4022,1998.4542,2000.2742,2002.2494,2004.1462,2010.9623,2016.0625,2019.4413,2021.1666,2021.1609,2020.5712,2019.1893,2018.1438,2018.1666,2019.8458,2024.6777,2029.3782,2033.4062,2040.2242,2046.5587,2053.8167,1882.0,1882.0,1882.0,1883.0,1883.0,1883.6111,1884.0,1884.6111,1884.0,1884.5964,1884.6111,1884.0,1885.332,1887.2987,1894.2048,1902.0289,1905.076,1907.3129,1908.5793,1910.6062,1912.9323,1920.1466,1928.1785,1936.6844,1946.0894,1954.2222,1962.1414,1969.4493,1974.6376,1980.2218,1985.3055,1987.8209,1989.1075,1990.8564,1993.3389,2000.5244,2007.0365,2011.7667,2013.8334,2014.8738,2015.0122,2014.2222,2012.8102,2010.3743,2009.7847,2011.3822,2017.5236,2023.7,2031.5393,2039.6893,2048.4944,1882.0,1882.0,1882.0,1882.068,1883.0,1883.0,1883.0,1883.0254,1883.1666,1884.0,1883.1666,1883.1666,1885.332,1887.768,1896.8193,1903.4734,1905.076,1906.0813,1904.3767,1904.884,1908.9734,1914.144,1923.1013,1930.9907,1940.1194,1949.3334,1956.6414,1962.2227,1967.116,1971.368,1974.8467,1976.7693,1977.8854,1979.728,1984.194,1991.64,1998.922,2003.092,2006.2793,2008.5,2008.5,2008.5,2007.3334,2006.3334,2006.1666,2006.9333,2009.3486,2013.4426,2022.774,2031.4453,2041.1,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.5171,1883.0,1883.0,1883.0,1883.0,1883.0,1884.3862,1888.536,1898.02,1903.64,1904.7222,1903.9325,1901.7742,1900.1062,1904.3123,1911.0276,1918.298,1925.9564,1934.7004,1943.4445,1951.1598,1956.8538,1960.4746,1961.9818,1964.0688,1965.7822,1966.9264,1969.8649,1976.9176,1982.6089,1987.4808,1993.2427,1998.4647,2001.2706,2002.4445,2002.4445,2000.8691,2000.4445,2001.4445,2002.4445,2004.6005,2007.0365,2011.5767,2022.7449,2031.8389,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.0,1883.0,1883.0,1883.9711,1884.664,1888.536,1897.0938,1902.64,1903.2018,1901.2605,1897.6451,1897.6617,1901.1956,1907.2524,1913.6316,1921.0675,1929.4042,1937.5555,1945.2625,1951.3351,1953.8635,1954.8334,1955.1111,1956.1111,1957.1487,1960.0872,1966.8282,1974.0911,1978.482,1982.5106,1986.9647,1992.3942,1996.5555,1997.5555,1997.1633,1997.2356,1997.3567,1998.2778,1999.5555,2001.312,2006.6395,2014.6893,2024.4333,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.02,1884.0767,1885.1493,1887.332,1888.768,1893.1086,1898.2467,1900.2067,1896.0693,1892.5607,1892.948,1897.3066,1903.1787,1908.9994,1916.0507,1924.192,1931.5,1937.7354,1943.0774,1946.3846,1947.3334,1946.5,1946.5,1947.604,1952.476,1957.348,1963.52,1970.058,1974.092,1979.6707,1986.128,1990.8234,1993.6427,1994.2454,1994.8334,1994.8334,1995.8334,1996.8334,1997.4933,2000.746,2008.0587,2017.1,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1884.1788,1885.896,1887.0,1888.2987,1889.6722,1892.4177,1893.7018,1890.4556,1889.0,1888.6235,1891.7367,1898.2898,1903.8538,1910.5009,1917.2034,1925.1666,1930.3833,1934.9106,1938.0858,1940.0671,1938.9867,1938.1666,1940.2706,1945.1427,1950.0146,1956.4667,1964.1658,1969.8529,1975.393,1983.7009,1988.2589,1990.3649,1991.3889,1992.3889,1992.6729,1993.3889,1994.3889,1995.3889,1997.4169,2002.6338,2011.3778,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1884.0,1885.0498,1887.0,1887.987,1888.9558,1889.0,1889.0,1889.0,1888.0491,1888.0,1888.99,1894.4009,1899.982,1906.1449,1911.4843,1917.8334,1923.7053,1927.7538,1930.1969,1931.8334,1931.8334,1932.4493,1933.99,1938.3258,1943.7882,1950.9689,1960.0173,1966.6276,1973.9485,1980.0969,1985.5089,1987.9445,1989.3564,1989.9445,1989.9445,1990.68,1991.0918,1992.5365,1994.9724,1997.8724,2005.4889,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.46,1885.0,1886.332,1887.0,1887.602,1888.0,1887.962,1887.756,1888.0,1888.0,1888.82,1891.012,1896.73,1902.32,1907.628,1912.0,1916.654,1920.808,1923.808,1925.0,1925.18,1926.0,1927.578,1932.964,1938.848,1945.9,1953.684,1962.08,1969.504,1975.156,1978.85,1982.952,1986.412,1987.0,1987.5,1987.5,1988.5,1989.296,1991.042,1994.696,1999.75,1883.0,1882.4382,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.46,1884.896,1885.3691,1886.0555,1887.0,1887.0,1886.9282,1887.0,1887.0,1887.0214,1888.0,1889.2703,1893.478,1899.4396,1904.6195,1908.1111,1911.5157,1914.8551,1917.4746,1919.1525,1920.2811,1921.6929,1923.1105,1927.5751,1933.8873,1940.831,1947.4991,1954.8756,1963.1335,1968.3689,1971.6812,1974.1427,1976.6343,1979.0702,1980.1825,1981.1666,1982.3695,1983.7814,1986.1671,1989.6008,1993.9667,1883.9388,1883.0,1882.0109,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0146,1883.0,1883.896,1884.6111,1884.7013,1885.6111,1885.6111,1885.6111,1885.8102,1886.0,1887.0,1887.82,1888.7107,1889.8458,1895.1392,1901.1807,1904.6111,1907.8278,1910.4832,1912.7993,1914.2222,1915.2222,1916.5986,1919.2742,1923.1982,1928.9943,1935.3022,1941.8142,1947.828,1955.2456,1962.4302,1966.4811,1969.1982,1969.9017,1968.6666,1970.2291,1971.7755,1972.2115,1974.2858,1977.0945,1982.3724,1986.6945,1884.0,1883.9106,1882.838,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.0,1883.1666,1883.8066,1884.034,1884.1666,1884.23,1885.0,1885.948,1886.4867,1887.0,1888.0,1888.7433,1889.5894,1895.192,1901.3334,1904.6027,1907.0387,1908.6414,1910.2906,1911.1666,1912.1666,1914.2273,1918.3093,1923.1813,1929.1133,1935.888,1941.836,1947.7806,1954.8293,1962.03,1965.3053,1965.3427,1961.2933,1960.3334,1960.7333,1961.6666,1963.8507,1967.718,1973.428,1978.45,1885.0,1884.0,1883.0203,1883.0,1882.3905,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.7222,1882.7222,1882.9355,1883.0,1883.0,1884.0,1884.3698,1885.0,1885.8289,1886.5922,1887.0,1887.4998,1888.0924,1889.4073,1895.1666,1900.7238,1903.5942,1905.0303,1906.6511,1907.4944,1908.6156,1910.7742,1913.6982,1918.6251,1923.1644,1928.9797,1935.6951,1941.6882,1947.7275,1954.7866,1962.0947,1964.4247,1961.5396,1957.1542,1953.5244,1952.2793,1953.9084,1959.9526,1966.0947,1970.3167,1884.25,1884.0,1883.73,1883.0,1883.0,1882.9222,1882.2051,1882.0,1882.0,1882.0,1881.6677,1881.3529,1881.2778,1882.0,1882.4252,1883.0,1883.0,1883.6476,1884.2633,1885.0,1885.2778,1886.0712,1887.0,1887.3702,1888.1566,1890.2778,1895.4276,1899.4276,1901.778,1903.0929,1903.6855,1904.4489,1905.9229,1909.5316,1914.4036,1918.2755,1923.1476,1928.5293,1935.6517,1941.8676,1948.1755,1954.7614,1961.2651,1962.8066,1956.148,1950.3578,1948.2778,1948.7053,1950.9174,1957.8903,1963.3833,1884.0,1884.0,1884.0,1884.0,1884.0,1883.0,1883.0,1882.1666,1882.0687,1882.0,1881.45,1881.0,1881.0,1881.0,1882.0,1882.5333,1883.0,1883.0,1883.79,1884.0,1884.6833,1885.0,1886.0,1887.0,1887.9274,1889.0,1891.6327,1895.432,1897.718,1898.6666,1899.6666,1899.8334,1900.8334,1904.0693,1908.578,1913.3867,1918.2587,1923.1306,1929.504,1936.7253,1942.7467,1948.6146,1954.834,1958.3226,1955.9813,1950.28,1946.974,1946.8334,1947.8613,1950.684,1955.1333,1884.961,1884.464,1884.0,1884.0,1884.0,1883.0,1883.0,1883.0,1882.2518,1882.0,1881.8212,1881.0636,1881.0,1881.0,1881.0,1881.78,1882.0,1882.3889,1882.9683,1883.0,1883.3889,1884.256,1885.2692,1886.128,1887.2194,1888.0,1889.1696,1891.6,1893.5087,1894.6782,1895.4589,1896.1542,1897.4409,1899.8768,1904.2665,1908.8889,1912.804,1917.7725,1923.3735,1930.0897,1937.0677,1942.7297,1949.0823,1952.5667,1953.2784,1950.28,1946.2329,1944.3889,1944.8058,1946.5693,1948.3278,1885.05,1885.0,1884.0555,1884.0,1884.0,1883.0,1883.0,1883.0,1882.0555,1882.0,1882.0,1882.0,1881.0371,1881.0,1881.0,1881.0,1881.0,1881.0,1881.9445,1882.3627,1882.99,1883.9586,1884.692,1886.0,1887.0,1888.0,1888.4117,1889.0,1889.9445,1890.9302,1891.1145,1891.8889,1892.9409,1895.8649,1899.8643,1904.6089,1908.6849,1912.3955,1917.8558,1923.2009,1930.4534,1936.7627,1942.6573,1949.4244,1951.9602,1949.56,1944.6324,1941.3524,1939.971,1941.3827,1943.789,1886.0,1885.464,1885.0,1884.296,1884.0,1883.36,1883.0,1883.0,1883.0,1882.488,1882.0,1882.0,1881.5,1881.616,1881.0,1881.0,1881.0,1881.0,1881.0,1881.692,1882.41,1883.128,1884.0,1885.128,1886.564,1887.0,1887.718,1888.0,1888.654,1889.0,1889.0,1889.0,1889.026,1891.232,1895.848,1900.72,1904.592,1908.464,1912.336,1917.76,1923.85,1929.94,1935.324,1941.968,1949.642,1947.56,1942.266,1938.908,1937.0,1937.5,1938.9,1886.85,1886.0,1885.0265,1884.592,1884.0,1883.2644,1883.9445,1883.0,1883.0,1882.976,1882.0,1882.0,1882.0,1882.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1882.0,1883.0,1884.0,1885.0071,1886.0,1887.0,1887.0,1887.0555,1888.0,1888.0,1888.0,1888.0,1888.0555,1889.0271,1891.0309,1895.831,1899.7031,1903.5751,1907.4471,1912.3191,1917.2467,1923.1187,1927.9907,1933.7107,1939.4664,1940.8622,1939.7435,1936.4635,1935.0555,1935.0555,1935.9556,1887.0,1886.464,1885.028,1884.7506,1884.0607,1884.0,1884.0,1883.3298,1883.0,1882.976,1882.0,1882.0,1881.8708,1881.0,1881.3096,1881.0,1881.0,1881.0,1881.0,1881.0,1881.5011,1883.0,1883.4229,1884.0782,1885.0,1885.6111,1886.2665,1886.6111,1887.0,1887.0,1887.0,1887.0,1887.6111,1888.0,1888.9705,1891.1912,1894.8936,1898.6863,1902.2985,1906.3898,1910.9133,1914.8093,1919.2684,1924.5293,1931.4014,1935.5533,1936.0662,1934.0192,1932.9891,1932.6111,1932.6111,1887.0,1886.5533,1885.838,1885.0,1885.0,1884.6,1884.2367,1883.9746,1883.0,1882.976,1882.0,1882.0,1882.0,1881.1934,1881.796,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1882.0427,1883.0,1883.2733,1884.094,1885.0,1885.1666,1885.8933,1886.0,1886.0,1886.0,1886.1027,1887.0,1887.0813,1888.0,1889.0,1890.0953,1893.5653,1896.7246,1899.708,1903.04,1905.6227,1910.324,1917.044,1924.068,1928.0533,1929.63,1930.3334,1930.1666,1930.1666,1929.1666,1887.9277,1887.0,1886.9797,1886.2778,1885.3905,1885.0,1885.0,1884.0,1883.412,1883.0,1882.2778,1882.0289,1882.0,1882.0,1882.0,1881.1,1881.0,1881.0,1881.0,1881.0,1881.0,1881.7933,1882.692,1883.0,1883.0,1883.7222,1884.0,1884.0,1884.0,1884.7222,1885.0,1885.8933,1886.0376,1887.0,1887.0,1888.0,1888.5748,1889.1676,1891.1124,1892.2706,1894.7067,1897.4138,1902.566,1910.3231,1917.0125,1922.6067,1926.8348,1927.7222,1928.4445,1927.7222,1925.8223,1888.65,1887.8511,1887.7222,1887.0,1886.0,1885.8,1885.0,1884.0,1883.412,1883.0,1883.0,1883.0,1883.0,1882.1676,1882.0,1882.0,1881.2567,1881.0,1881.0,1881.0,1881.0,1881.0712,1882.0,1882.2778,1882.2778,1883.0,1883.0,1883.0,1883.0,1884.0,1884.2778,1885.0,1885.2778,1886.0,1886.9451,1887.0,1887.8527,1888.0645,1888.2778,1889.0,1889.15,1890.8026,1896.494,1902.3773,1908.9631,1914.2733,1919.2671,1922.7031,1924.5555,1924.2205,1921.6833,1889.15,1889.0,1888.0,1887.0,1886.1666,1886.0,1885.0,1884.8733,1884.0,1884.0,1883.54,1883.0,1883.0,1883.0,1882.0,1882.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.0,1883.8633,1884.0,1884.842,1885.0,1885.77,1886.3,1886.966,1887.0,1887.0,1887.0867,1887.9233,1888.8134,1889.6866,1894.0293,1899.9014,1904.7733,1909.6454,1913.5173,1916.5046,1916.6666,1916.6666,1892.4111,1889.2836,1888.028,1887.0,1887.0,1886.0,1885.7216,1885.0,1885.0,1884.5964,1883.8212,1883.0,1883.0,1883.0,1882.0,1882.0,1881.5647,1881.0,1881.0,1881.0,1881.0,1881.0,1881.692,1882.0,1881.3889,1881.0,1881.3889,1882.0,1882.1198,1883.0,1883.0,1883.3889,1884.0,1884.0,1884.3889,1885.14,1885.3889,1886.0,1886.2598,1886.3889,1887.0,1887.3795,1888.0,1888.3889,1890.5612,1894.9956,1900.2911,1904.7395,1907.5835,1909.5555,1909.0056,1893.95,1889.4897,1888.028,1887.0328,1887.0,1887.0,1886.0157,1885.848,1885.0,1884.9773,1884.03,1884.0,1883.0555,1883.013,1882.8074,1882.02,1881.9282,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.8236,1882.0,1882.7026,1883.0,1883.0,1883.0,1883.0,1883.0,1884.0,1884.7518,1884.9573,1885.0,1885.0,1885.9445,1885.9987,1886.9445,1887.0,1887.9602,1888.68,1890.2391,1894.9288,1897.8323,1899.7222,1898.8722,1896.25,1890.16,1888.514,1888.0,1887.578,1887.0,1887.0,1886.424,1886.0,1885.5,1885.0,1884.552,1884.334,1884.116,1883.0,1882.68,1882.0,1881.744,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.654,1882.0,1881.91,1882.0,1882.0,1882.488,1883.0,1883.0,1883.5,1883.5,1884.0,1884.0,1884.27,1884.5,1885.5,1886.0,1886.642,1887.36,1887.578,1888.5,1889.5,1889.5,1889.5,1897.8944,1893.8169,1889.9973,1889.0,1888.9445,1888.0,1887.9445,1887.0,1887.0,1886.9445,1886.0,1885.9502,1885.0,1884.9573,1884.0,1883.9445,1883.0,1882.4609,1881.9445,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0342,1882.0,1882.0,1882.0514,1883.0,1883.0,1882.0555,1883.0,1883.0,1883.0,1883.0555,1884.023,1884.8564,1885.0555,1886.04,1886.2029,1887.0328,1888.0,1888.0,1888.0,1901.7389,1900.2418,1897.1947,1893.6,1890.9338,1889.28,1888.5625,1888.0,1887.6406,1887.0,1887.0,1886.4524,1886.0,1885.5306,1884.8754,1884.14,1883.3594,1883.0,1882.4207,1881.7654,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.6111,1881.6111,1881.1246,1881.6111,1881.6111,1881.6516,1882.0,1882.5964,1882.6111,1883.0,1883.7216,1884.44,1885.0,1885.6111,1886.6111,1886.6111,1886.6111,1904.8334,1904.22,1902.6714,1899.752,1895.8226,1892.5533,1889.284,1888.8334,1888.3434,1888.0,1887.8334,1887.0,1886.9447,1886.1934,1885.966,1885.5333,1884.8334,1883.9147,1883.0433,1882.8334,1882.15,1881.8334,1881.2567,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1880.7,1880.83,1881.0,1881.0,1881.0,1881.0,1881.1627,1881.51,1882.1414,1882.4033,1883.12,1883.2966,1884.0986,1885.0046,1885.1666,1885.1666,1908.1777,1906.7418,1905.0078,1902.8698,1899.4338,1894.9978,1891.5618,1889.2356,1889.0,1889.0,1888.2778,1888.0,1887.2778,1887.0,1886.2778,1886.1,1885.9451,1885.1355,1884.3153,1883.7227,1883.05,1882.2778,1882.0856,1881.9076,1881.2778,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1881.0,1880.3698,1880.0,1880.0,1880.0,1880.0,1880.0,1880.6471,1880.0,1880.0,1880.7222,1880.9578,1881.2051,1881.9222,1882.7222,1882.7222,1883.7222,1883.7222,1883.9722,1910.6945,1909.1863,1906.7502,1904.3142,1901.156,1897.4423,1894.7284,1893.2925,1891.8564,1890.4271,1889.39,1889.0,1888.0,1888.0,1887.0,1887.0,1886.7222,1886.7222,1885.7367,1884.8933,1884.13,1883.0,1883.0,1882.7222,1882.7222,1882.0,1882.0,1881.128,1881.2224,1881.1849,1881.13,1881.0,1881.0,1880.8645,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.284,1881.0,1881.0,1881.7053,1882.298,1883.0,1883.0,1914.2333,1911.6306,1909.1947,1905.7587,1902.182,1899.1666,1898.3334,1898.3334,1897.3334,1895.3093,1893.7067,1891.4374,1889.1113,1889.0,1887.3367,1888.0,1887.1666,1887.1666,1887.0,1886.1666,1885.3167,1884.7866,1884.0514,1884.0,1883.53,1883.0,1882.6367,1882.1454,1882.0,1882.0,1881.85,1882.0,1881.0,1881.1666,1881.0127,1880.7,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.0,1880.13,1880.8334,1881.0233,1881.8334,1881.8334,1918.4722,1914.8667,1911.6392,1908.2031,1904.5342,1902.2222,1902.8334,1903.2222,1902.474,1900.1982,1897.9412,1896.3262,1893.7611,1890.596,1889.0,1888.6111,1888.6111,1888.6111,1888.0317,1887.6111,1887.0,1886.4547,1885.6111,1885.5328,1884.7806,1884.0,1883.0,1883.0,1883.0,1882.7107,1882.6111,1882.0,1882.0,1882.0,1882.0,1881.3911,1881.0,1880.4694,1880.0,1880.0,1880.0,1880.0,1880.0,1879.0929,1879.8264,1880.0,1880.0,1880.0,1881.0,1881.0,1880.45,1922.9111,1918.5453,1913.1671,1911.6476,1911.0555,1909.8867,1909.1666,1908.1666,1907.5558,1906.0885,1903.7067,1901.3204,1899.779,1896.3987,1893.9626,1892.5623,1893.3538,1894.2222,1892.2742,1889.1796,1888.2256,1887.7582,1887.0171,1887.0,1886.0242,1885.0555,1885.0,1884.0555,1884.0,1884.0,1883.01,1883.0214,1883.0,1883.0,1883.0,1882.66,1882.0,1881.7809,1881.0184,1880.9017,1880.0,1880.0,1880.0,1879.1991,1879.0,1879.0,1880.0,1879.9445,1880.0,1880.0,1880.0,1926.8,1923.232,1920.528,1917.592,1916.5,1916.5,1915.642,1914.5,1913.5,1912.488,1911.04,1909.552,1906.668,1903.348,1900.5,1901.64,1903.576,1903.744,1902.552,1899.04,1892.95,1889.372,1888.5,1887.436,1887.0,1886.5,1885.782,1885.064,1885.0,1884.5,1884.0,1884.0,1884.0,1884.0,1883.038,1883.0,1882.204,1882.0,1882.0,1881.5,1880.73,1880.0,1880.0,1879.576,1879.358,1879.0,1879.0,1879.0,1879.5,1879.268,1879.5,1932.7278,1930.2418,1928.7793,1925.4253,1923.842,1923.5688,1922.8334,1921.8334,1921.2454,1919.8093,1918.3733,1915.9929,1914.5013,1912.0227,1911.7335,1912.7578,1912.706,1911.2942,1908.8854,1905.5049,1902.1934,1896.3213,1889.8898,1888.0,1887.436,1887.0,1886.5327,1886.0,1885.6536,1885.0,1885.0,1885.0,1884.9445,1884.0,1884.0,1883.0,1883.0,1883.0,1883.0,1882.0,1882.0,1881.0,1880.5553,1880.0,1879.0,1879.0,1878.0,1878.0555,1878.9735,1879.0,1878.15,1940.4556,1939.0195,1936.5835,1933.7587,1931.6509,1931.5555,1931.5555,1930.5555,1930.5555,1928.5222,1925.7067,1923.2706,1920.5748,1918.0098,1916.9818,1919.6644,1920.4796,1918.1427,1914.85,1911.6333,1908.0278,1903.2657,1896.3987,1888.9218,1888.0,1887.0,1887.0,1886.3889,1886.2692,1886.0,1885.82,1885.0,1885.0,1884.3889,1884.0295,1884.0,1883.0,1883.0,1883.0,1883.0,1882.1788,1882.0,1881.0,1880.0591,1879.8264,1879.0,1878.0,1877.7698,1877.6111,1877.6111,1877.6111,1951.0834,1949.244,1947.1947,1942.3507,1940.2034,1942.1666,1943.0,1942.1414,1940.6766,1938.448,1933.49,1928.8573,1926.058,1922.8987,1920.3267,1923.6666,1925.9873,1925.5813,1921.604,1915.4493,1912.8767,1908.1547,1902.706,1890.4534,1888.0,1888.0,1887.47,1887.0,1886.9486,1886.0,1886.0,1885.0,1885.0,1885.0,1884.846,1884.0,1883.8673,1883.8334,1883.0,1883.0,1883.0,1882.02,1881.588,1881.0,1879.7633,1879.0,1878.0,1877.408,1877.0,1877.0,1877.0,1965.289,1961.9818,1958.4169,1953.2782,1952.1111,1954.1111,1954.19,1953.6813,1951.082,1945.7614,1938.5078,1933.4857,1929.6138,1925.7418,1922.9264,1921.74,1925.4656,1926.0,1923.8262,1917.7871,1915.4078,1913.8369,1907.4796,1898.0791,1891.2693,1889.2778,1888.2778,1888.0,1887.1923,1887.0,1886.87,1886.2778,1886.0,1886.0,1885.2778,1885.1777,1885.0566,1884.8324,1884.2778,1884.0,1883.1278,1883.0,1882.0,1881.0422,1880.0,1879.48,1878.8873,1878.1133,1877.27,1876.6649,1876.0278,1976.6111,1975.0751,1971.3893,1966.2227,1962.8889,1964.169,1964.094,1961.8627,1957.9907,1952.3898,1944.3267,1936.6525,1932.298,1928.1863,1924.796,1922.36,1922.0,1921.4133,1919.3298,1918.616,1917.13,1915.5374,1911.7318,1903.1528,1898.1953,1894.1666,1890.5369,1888.7578,1888.0,1887.7222,1887.0,1887.0,1887.0,1886.7222,1886.6674,1886.7222,1886.0,1886.0,1885.2397,1885.0,1884.3323,1883.7289,1883.0,1882.0,1880.716,1880.0,1879.9567,1879.0,1878.0,1877.3871,1877.0,1987.8167,1985.5946,1981.718,1977.1907,1973.6926,1975.9,1974.784,1971.2107,1964.736,1958.428,1952.4133,1942.1866,1935.5027,1930.6306,1925.796,1923.5266,1922.154,1921.5734,1921.0087,1919.2307,1919.1666,1917.0347,1913.898,1911.244,1906.372,1901.5,1896.4613,1890.8627,1889.0,1888.1666,1888.0,1888.0,1888.0,1888.0,1887.1666,1887.0,1887.0,1886.8066,1886.0553,1886.0,1885.0767,1884.8373,1883.0,1882.2933,1881.7633,1881.1666,1880.1666,1880.068,1879.1666,1879.0,1878.1666],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD015.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD015.py load and self-test diagnostics complete.")
