####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD013.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD013.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD013.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD013.x3d'),
    GeoLOD(center=(4340924.904807,740603.999947,2057.000000),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw006.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw006.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,739994.999947,0),geoSystem=["UTM","Z10","N"],height=[1986.4869,1988.42,1985.6298,1981.0447,1978.0167,1978.8538,1981.8004,1985.4825,1988.456,1992.6218,1996.4938,2001.44,2006.3832,2008.1476,2005.8021,2005.5739,2007.3629,2011.4578,2018.9767,2018.8738,2018.372,2010.2635,1998.4008,1987.2207,1975.6047,1968.1476,1963.0225,1963.4825,1965.8818,1968.1044,1969.4669,1971.903,1973.3018,1974.7137,1977.7847,1982.3971,1988.477,1997.8436,2004.6753,2011.6724,2018.4396,2030.0276,2043.4945,2053.8264,2061.2864,2067.5945,2072.3484,2075.6184,2078.7773,2081.8984,2080.8928,1981.6682,1982.4427,1978.6381,1974.8229,1972.8607,1975.1407,1978.4374,1980.8522,1983.8154,1987.6061,1990.0421,1994.9707,1997.2567,1997.2432,1999.4712,1999.582,2001.8734,2006.6028,2009.1194,2007.4497,2004.5977,1999.6748,1990.6748,1979.96,1970.0294,1961.8607,1960.8607,1960.8607,1963.1687,1964.9644,1967.0156,1968.3909,1969.9054,1971.2808,1972.7847,1975.4414,1981.1741,1986.2457,1992.3075,1997.7404,2006.0035,2019.0236,2031.3635,2041.9868,2049.9111,2055.7434,2060.4595,2063.756,2065.3315,2067.164,2067.0388,1975.869,1974.5659,1971.9092,1969.6383,1968.869,1971.149,1973.585,1975.869,1977.1245,1978.7484,1980.6324,1982.5752,1985.402,1987.738,1987.8267,1989.8145,1998.021,2000.869,1997.8488,1995.0863,1992.8105,1988.5492,1982.2275,1973.5574,1966.1785,1961.0,1959.245,1959.3789,1960.6086,1962.1785,1963.9708,1965.0505,1965.921,1967.6465,1969.793,1971.7944,1975.4609,1979.6666,1983.3492,1987.5566,1995.898,2006.6179,2017.667,2029.3674,2038.4293,2043.6124,2047.4845,2050.7644,2052.607,2052.3445,2051.1414,1970.9174,1968.4889,1965.0807,1962.0215,1963.8606,1966.2966,1968.0225,1969.0249,1969.0298,1969.0332,1970.4894,1973.8169,1975.3651,1976.0415,1976.6583,1985.5682,1992.1686,1993.0094,1988.1376,1985.03,1983.2048,1980.5128,1975.6409,1970.7512,1964.3163,1960.0,1957.5676,1956.0166,1958.0083,1958.7606,1960.1951,1961.0166,1962.0681,1964.4963,1966.9323,1969.3683,1971.8043,1974.2485,1976.6929,1981.2255,1987.6411,1996.937,2005.2692,2013.4418,2020.9148,2028.2227,2033.3688,2036.6417,2038.0775,2039.5016,2039.1332,1965.1642,1963.6282,1961.0164,1959.582,1960.9348,1962.1642,1962.582,1962.0757,1961.582,1960.582,1962.5021,1967.9562,1970.1642,1971.1642,1973.1089,1981.5146,1989.1959,1987.8561,1981.872,1976.9443,1975.7462,1974.4902,1971.183,1967.4006,1963.1257,1957.582,1954.1461,1952.7101,1952.4722,1954.326,1956.2394,1957.4216,1958.634,1961.0701,1963.4744,1965.7916,1967.9602,1969.8141,1972.2501,1976.3722,1981.2441,1986.6982,1994.3862,2001.8723,2008.5972,2014.3505,2019.2224,2024.0945,2027.3563,2029.5222,2030.3284,1961.1559,1961.0724,1959.1838,1958.0,1958.2875,1959.1559,1959.2002,1958.3118,1958.1559,1958.1761,1961.0042,1965.0356,1966.3118,1967.0798,1969.7197,1975.6915,1983.6996,1982.0077,1975.4238,1969.9877,1967.7755,1966.2516,1965.3597,1963.3118,1960.1837,1954.3118,1951.2438,1950.1559,1949.1559,1950.8999,1952.4637,1953.8318,1955.3557,1957.6439,1959.2357,1961.9757,1963.9836,1965.5438,1967.9797,1972.2924,1976.78,1980.44,1984.2916,1989.3235,1996.6315,2003.1758,2008.9355,2012.9634,2017.6515,2020.1711,2021.5392,1959.973,1959.0,1958.0,1956.592,1956.0,1956.7297,1956.7297,1955.7297,1955.0,1955.7601,1958.9193,1961.4313,1962.1891,1961.421,1963.1779,1967.296,1972.7244,1974.1365,1969.0227,1964.421,1960.6394,1959.4594,1958.6841,1957.061,1953.7429,1950.7297,1948.8822,1947.8577,1947.7297,1947.7297,1948.9097,1950.1792,1950.7817,1952.9474,1955.3834,1957.2864,1959.2554,1960.6914,1962.9468,1965.7151,1971.269,1975.1476,1977.4896,1979.6559,1984.2932,1990.6138,1997.0742,2001.8324,2005.7045,2009.378,2009.6484,1960.6268,1959.3232,1958.0195,1956.8762,1955.8525,1955.0,1955.0,1955.0,1955.0,1955.0334,1954.147,1952.8789,1952.882,1951.679,1953.622,1957.7974,1961.2369,1962.214,1960.266,1958.4099,1956.0358,1954.5293,1952.9149,1950.5681,1949.4358,1948.3035,1947.1711,1946.3035,1945.3035,1946.0475,1946.4288,1947.3035,1948.3035,1949.3035,1950.531,1951.9669,1954.403,1955.6774,1957.275,1960.4391,1964.687,1968.8792,1971.0189,1972.455,1974.2806,1977.9574,1984.5732,1990.1138,1994.242,1996.5371,1997.214,1961.1105,1960.5298,1959.1473,1957.6421,1957.0,1955.1227,1955.1227,1955.2455,1956.1948,1955.3383,1952.7191,1951.1355,1949.7908,1948.3547,1948.0977,1949.4387,1950.6411,1951.2037,1951.6318,1950.7545,1950.7545,1950.53,1948.8773,1947.8616,1947.3824,1945.8773,1944.8773,1943.8773,1943.1475,1943.8458,1943.8773,1944.8773,1945.761,1946.3652,1946.8773,1948.1931,1949.5756,1950.0808,1951.4226,1954.8527,1959.8346,1963.7306,1965.7545,1966.736,1967.9159,1970.3518,1974.1843,1979.7657,1984.6879,1988.0958,1988.7196,1963.449,1961.7582,1960.5615,1959.325,1957.6193,1957.1537,1957.872,1958.6323,1959.549,1959.6335,1957.6378,1955.7507,1953.7659,1952.2252,1950.9858,1949.7466,1948.4729,1947.549,1947.549,1947.451,1947.451,1947.451,1946.6201,1945.3933,1944.7054,1944.0,1942.2118,1941.451,1940.451,1940.7866,1941.451,1942.2402,1942.503,1943.451,1944.3751,1944.9021,1945.8102,1946.451,1947.451,1950.659,1955.7747,1958.8782,1960.9021,1960.9021,1961.5792,1963.0732,1967.0459,1971.5372,1976.4092,1979.8173,1980.8043,1964.9976,1963.4391,1962.0032,1960.592,1958.979,1958.9751,1960.6912,1961.1271,1962.5485,1963.9254,1962.4902,1960.9529,1958.6183,1957.9312,1957.7015,1955.3103,1952.8743,1950.9502,1949.9751,1949.9656,1948.1552,1946.7255,1945.9828,1944.9751,1944.0,1942.0498,1940.5889,1938.1746,1938.0249,1938.0433,1939.0249,1939.6256,1940.0249,1940.5256,1941.0249,1941.0498,1941.0498,1943.0306,1945.3442,1948.2329,1952.5648,1955.0251,1956.0498,1957.0249,1957.3267,1958.0498,1960.3617,1964.2587,1969.1306,1972.552,1973.0746,1967.7626,1966.5875,1965.4126,1963.231,1961.4014,1962.0826,1964.3486,1966.447,1968.792,1970.204,1968.744,1965.9484,1962.872,1963.6638,1964.0,1961.564,1959.7572,1958.692,1956.256,1954.4187,1951.9827,1949.8026,1949.8026,1949.8026,1948.2386,1945.204,1942.9653,1940.1793,1937.2777,1937.0,1937.0,1937.0,1937.5986,1937.5986,1938.5532,1937.5986,1937.5986,1938.8307,1940.8654,1944.4054,1949.0607,1951.5747,1952.1974,1952.1974,1952.0834,1952.516,1955.4468,1958.7893,1962.2533,1965.4751,1965.3947,1970.8275,1970.655,1969.6599,1968.4122,1968.31,1968.7626,1970.2476,1971.9329,1975.172,1976.655,1975.1157,1971.8451,1969.5978,1970.2506,1971.4825,1970.6702,1968.31,1967.6256,1963.5686,1959.3373,1957.8351,1957.31,1958.0553,1958.1821,1954.7153,1949.655,1946.3163,1942.9556,1938.2646,1936.0,1935.1725,1935.6823,1936.1725,1936.1725,1936.1725,1936.1725,1936.1725,1937.0,1937.1725,1938.553,1943.4249,1947.3209,1948.345,1948.345,1948.1725,1948.2966,1950.3553,1953.9369,1957.3729,1959.345,1960.0897,1973.5074,1974.1613,1974.5074,1974.7612,1975.0149,1976.2239,1977.0149,1978.2804,1981.0955,1982.7612,1982.3011,1977.9956,1974.2596,1975.0806,1976.5074,1976.5074,1976.5074,1976.5074,1975.5463,1968.9603,1965.3143,1964.7134,1966.7069,1969.6156,1965.1082,1957.0149,1949.6355,1948.078,1945.1451,1939.527,1936.3275,1934.0974,1933.0388,1933.9806,1934.7462,1934.4777,1933.9482,1934.8052,1935.7462,1937.104,1940.2863,1943.7162,1945.0537,1945.7076,1945.2806,1945.4926,1946.9022,1949.78,1952.5205,1953.8387,1955.1642,1980.1398,1981.7197,1982.7007,1983.7197,1984.7197,1985.7197,1986.0398,1986.0398,1986.9479,1988.3676,1988.5327,1985.2103,1981.162,1979.3599,1979.6799,1980.3599,1980.4115,1981.0398,1979.4119,1976.9758,1976.3599,1975.3599,1975.3599,1976.6799,1974.7549,1965.0398,1957.4642,1956.1268,1953.2023,1947.5518,1941.5574,1936.8668,1933.6279,1931.6682,1932.3201,1932.5648,1933.0,1933.0742,1934.2137,1936.3907,1939.2272,1941.296,1942.6002,1942.4235,1940.5492,1939.6401,1941.7961,1945.2322,1947.9602,1948.8116,1950.1521,1988.6201,1990.4246,1991.4216,1992.3617,1993.179,1993.3184,1993.3184,1994.3184,1994.3184,1994.1882,1991.7523,1989.2101,1985.7742,1983.3381,1983.1061,1983.8523,1985.2802,1986.2123,1985.2643,1982.8282,1980.3922,1980.4683,1981.9043,1982.1904,1978.6346,1971.2123,1964.9885,1964.332,1962.6289,1955.4485,1947.7784,1941.4297,1937.0021,1933.1301,1930.0841,1930.3218,1931.6898,1931.9185,1932.668,1935.0089,1938.08,1942.0555,1943.4683,1942.3804,1938.7618,1936.8939,1937.8939,1939.423,1940.7877,1942.0963,1945.4816,1999.1294,2000.1294,2001.1162,2001.3466,2001.6617,2001.5127,2001.1294,2001.0647,2000.7897,1999.0406,1995.8572,1992.2173,1988.5559,1985.6409,1985.7363,1988.237,1990.1051,1990.7921,1989.5844,1986.1483,1984.1488,1984.1844,1986.5928,1987.9366,1983.673,1976.1294,1973.597,1972.1892,1969.2891,1964.365,1956.4093,1947.749,1940.9087,1935.5564,1931.6843,1930.3407,1929.4677,1930.1085,1931.1356,1933.6271,1937.2952,1943.4475,1950.2573,1947.0692,1938.432,1935.28,1935.6237,1936.4677,1936.4825,1937.0,1938.7886,2007.9342,2009.3894,2011.7659,2011.8341,2011.8341,2010.864,2010.1182,2008.7236,2006.312,2002.9105,1999.0161,1995.1665,1993.2253,1991.8438,1993.0466,1996.129,1997.8756,1996.405,1992.9712,1989.5586,1988.883,1988.8756,1990.6091,1991.7891,1989.3297,1987.7927,1985.8973,1981.1263,1977.2596,1972.3876,1965.3281,1955.7542,1946.7196,1939.452,1934.1106,1930.6135,1929.0,1928.0415,1929.0277,1931.1869,1935.639,1942.905,1951.0171,1945.6558,1937.716,1934.28,1934.0065,1934.0415,1935.0012,1935.4862,1936.9042,2019.0237,2021.8445,2021.9237,2020.9032,2019.3102,2017.4895,2015.494,2013.2913,2011.4349,2007.322,2001.9247,1998.8735,1997.3848,1997.7695,1999.895,2001.3848,2001.7402,1999.6758,1995.4688,1994.7695,1995.7002,1997.4404,1996.7695,1997.8187,1997.5902,1995.1542,1992.7183,1989.361,1984.8462,1979.7648,1973.4342,1965.3063,1955.2789,1945.6902,1938.3354,1935.4095,1929.565,1926.6152,1926.6152,1928.3745,1932.6953,1939.1677,1945.0992,1941.1648,1936.1565,1933.0029,1931.6152,1931.9795,1932.6152,1933.2855,1934.5153,2033.0657,2037.4016,2036.8937,2032.2388,2026.7449,2023.3419,2020.19,2016.3754,2013.3008,2008.9714,2004.351,2001.8953,2001.0802,2002.4337,2004.7874,2005.622,2004.5459,2000.787,1998.6317,1998.622,2000.2959,2003.8295,2004.2438,2005.2438,2003.9755,2001.622,1998.9968,1995.8536,1991.8751,1987.9448,1980.8928,1972.5848,1964.0358,1954.2917,1947.3958,1941.7129,1934.0984,1925.001,1924.1891,1925.2087,1928.896,1935.3256,1939.6011,1937.6821,1933.6748,1930.522,1929.1891,1929.1891,1930.1891,1930.1891,1932.0891,2049.0486,2050.3025,2047.5089,2040.3906,2032.7052,2026.8243,2022.3308,2016.696,2012.0406,2007.976,2005.649,2004.2372,2005.0596,2008.1873,2010.4412,2011.2372,2010.1212,2006.9623,2004.7634,2005.7114,2007.5315,2011.2979,2012.2372,2011.444,2010.6731,2007.4742,2003.9349,2001.3651,1998.1663,1994.047,1986.9343,1979.6263,1971.2787,1963.7355,1959.3197,1950.6315,1941.7162,1932.7834,1925.7266,1924.0,1925.8429,1930.4777,1934.2263,1933.2034,1929.4789,1926.9764,1926.7628,1927.7628,1927.7628,1927.5258,1928.9525,2059.687,2058.918,2052.4106,2043.8226,2033.468,2025.4967,2020.8091,2015.5952,2010.412,2008.6475,2007.6633,2006.6633,2007.9954,2010.69,2013.3954,2014.4479,2013.5874,2011.1514,2010.3267,2011.4559,2012.2073,2013.9193,2014.8964,2014.5354,2012.8102,2011.0,2008.0806,2004.7914,2002.3553,1999.6688,1991.7867,1984.0701,1975.5073,1968.3636,1962.5391,1955.0376,1947.4794,1938.8893,1928.9913,1924.0,1924.1818,1925.3367,1926.6733,1926.6733,1926.2411,1925.28,1925.0525,1925.3367,1925.3367,1925.3367,1927.203,2066.1597,2061.4336,2053.1094,2043.368,2033.468,2023.6191,2021.3735,2017.6472,2012.9662,2010.9781,2009.0483,2008.0093,2008.664,2012.536,2015.2936,2017.1469,2018.1099,2016.7567,2016.2687,2016.1791,2016.1057,2016.0896,2017.0,2015.0,2013.4865,2012.0896,2010.6536,2007.229,2004.754,2001.3456,1996.3695,1987.6256,1978.8816,1969.6038,1960.2349,1953.8304,1947.3185,1939.304,1930.7797,1925.0896,1924.0896,1924.0,1924.9104,1924.9863,1925.0,1924.9355,1924.0,1924.0,1924.0,1924.0,1924.9911,2071.68,2062.0952,2053.1426,2045.018,2037.0957,2030.8517,2025.2617,2021.2902,2017.4435,2013.9835,2010.54,2009.0536,2009.332,2012.536,2017.7197,2021.1558,2022.5549,2023.0315,2021.5426,2020.1317,2018.5157,2017.3837,2017.0,2015.5157,2014.9518,2014.4843,2012.0797,2009.7057,2006.8998,2002.8958,1998.46,1990.3695,1981.3077,1972.0758,1961.2672,1952.2501,1945.5132,1938.0518,1933.1798,1929.3615,1926.46,1924.024,1922.6968,1923.4843,1924.0,1924.0,1923.4087,1923.0,1923.0,1923.4843,1924.9,2077.52,2069.5615,2063.7078,2057.812,2051.0618,2043.49,2034.6199,2026.3787,2020.7421,2017.8359,2012.9906,2010.942,2010.942,2012.536,2019.554,2023.921,2024.942,2024.9703,2022.052,2019.6741,2017.2856,2016.058,2016.7098,2017.1206,2016.942,2015.0,2013.5312,2011.9493,2008.3439,2004.2128,1999.46,1992.1162,1983.734,1973.502,1961.3756,1953.8619,1947.554,1941.4199,1936.2352,1929.948,1926.0267,1923.9674,1922.0,1922.0,1922.058,1923.0,1922.058,1922.0,1922.0845,1923.0,1924.0,2088.909,2082.4302,2076.8967,2070.8745,2064.7847,2056.7207,2046.8926,2034.9607,2027.2966,2023.0476,2017.9857,2014.4447,2013.3682,2016.1014,2020.5369,2024.64,2026.6039,2024.9314,2019.0187,2013.8796,2012.2637,2012.6318,2014.3239,2016.7599,2017.436,2016.0,2014.7245,2013.128,2009.384,2003.982,1999.1581,1992.152,1984.391,1973.56,1961.38,1955.28,1948.905,1942.536,1937.996,1928.7537,1925.2906,1924.024,1922.588,1921.152,1921.6318,1922.0,1922.0,1922.0,1922.0,1922.464,1924.0,2103.3867,2095.3638,2089.0278,2083.072,2074.7693,2066.2632,2055.5974,2043.8959,2037.3287,2030.292,2022.7633,2019.6927,2017.1194,2015.3159,2020.1014,2024.28,2021.4806,2016.7986,2011.6796,2009.9006,2009.2057,2009.6146,2011.2057,2014.3336,2016.2953,2015.4113,2015.2319,2013.3074,2008.345,2001.7177,1996.7026,1990.8469,1982.9457,1971.3589,1960.5096,1953.4856,1947.8176,1941.7417,1935.671,1926.1017,1924.571,1924.0,1923.0,1922.0312,1921.716,1921.0,1921.1736,1921.0,1922.0,1922.464,1923.9,2115.7808,2107.3767,2099.7239,2091.1272,2081.966,2071.321,2061.5771,2053.172,2044.768,2036.3639,2027.9597,2022.3475,2019.5565,2017.232,2015.955,2013.4994,2011.4829,2009.6665,2008.7794,2007.3954,2006.5986,2005.8148,2007.2509,2011.9075,2012.655,2011.3383,2010.3383,2009.2457,2003.4143,1997.0709,1992.2385,1987.2758,1978.0897,1967.4939,1956.7183,1948.6978,1944.1425,1939.2643,1931.0342,1925.0,1924.46,1923.024,1922.9092,1922.0,1921.716,1921.0,1921.0,1920.8694,1921.0,1922.0,1923.7015,2126.287,2117.907,2106.4336,2095.6616,2085.6194,2076.5403,2067.1455,2059.985,2049.1492,2039.5508,2031.2667,2024.8547,2021.5508,2018.8788,2016.0771,2013.36,2010.8971,2008.0,2006.3868,2005.7516,2004.0636,2002.1876,2001.9509,2004.4581,2005.5669,2004.0597,2002.2589,2000.2329,1997.0905,1992.4813,1988.2301,1979.949,1970.205,1959.9729,1948.3414,1940.693,1938.1317,1933.485,1926.3518,1925.0,1924.1625,1923.024,1922.588,1922.0,1921.2529,1921.0,1920.0,1920.0,1920.3533,1920.8173,1922.3179,2135.7117,2123.4998,2111.357,2102.5437,2093.843,2084.7458,2072.2297,2060.1782,2049.605,2039.904,2032.153,2026.3773,2021.741,2019.2489,2015.8541,2014.36,2011.0,2009.0133,2007.0038,2004.0449,2002.18,2000.671,1997.308,1996.854,1997.4498,1996.854,1995.8223,1993.982,1991.546,1988.0015,1980.0012,1970.2441,1960.5731,1950.3767,1941.1525,1934.1078,1927.2621,1924.6951,1923.854,1924.0,1923.9606,1923.0,1922.0,1921.9381,1921.0,1920.207,1919.0,1919.0,1919.0,1919.9609,1920.9927,2144.3467,2130.3167,2119.1228,2108.6619,2099.201,2087.9595,2073.3467,2058.544,2049.4407,2041.9143,2034.5792,2028.7072,2022.668,2020.232,2017.2952,2013.72,2010.962,2009.2444,2007.5253,2004.616,2002.18,1999.6162,1997.1543,1994.872,1993.2192,1992.0017,1990.5657,1989.0017,1985.887,1977.5282,1968.8743,1960.6545,1952.3464,1944.2941,1936.6909,1930.4208,1925.204,1922.8838,1921.0,1921.6049,1922.5009,1922.5009,1921.7943,1921.0,1920.3586,1919.6406,1919.0,1919.0,1918.9861,1918.7324,1919.5009,2152.0762,2138.1362,2125.9907,2113.8413,2101.7053,2088.6,2072.988,2060.3286,2051.6172,2043.8756,2037.5454,2030.2451,2022.668,2021.1573,2019.5173,2014.6454,2011.8494,2010.4133,2008.9254,2006.5414,2004.272,2001.5947,1998.2334,1996.7878,1992.2755,1987.1493,1985.7133,1980.673,1974.3745,1966.378,1959.7893,1953.3759,1946.9933,1938.6853,1933.2323,1927.9469,1924.9558,1922.0,1921.332,1921.0,1920.6146,1921.0746,1921.0438,1920.152,1919.0746,1919.0209,1918.063,1918.0,1917.9741,1918.0,1918.0671,2159.6516,2143.0232,2130.8433,2115.4084,2101.78,2089.853,2073.3396,2062.0952,2053.7324,2046.288,2039.9716,2033.2445,2027.3907,2023.7847,2021.8677,2019.0631,2016.6272,2014.3712,2012.1067,2010.5681,2008.8832,2005.4471,2002.4541,1999.5752,1995.5752,1988.0547,1984.6328,1979.0421,1972.9789,1964.0787,1958.6316,1950.2546,1943.792,1936.1956,1931.228,1926.2885,1924.204,1922.0,1922.0,1921.0,1920.0,1920.0,1920.0,1920.0,1919.0,1918.1815,1917.844,1917.0,1916.6484,1916.6484,1916.9648,2160.4,2146.0977,2132.168,2115.144,2104.058,2094.4934,2079.719,2066.9475,2057.0137,2049.4888,2043.6355,2038.3422,2034.0013,2031.3431,2027.7031,2024.1956,2022.4796,2020.8213,2018.3854,2016.1715,2013.5533,2010.2996,2007.4702,2004.4276,2000.9916,1996.3334,1990.9,1985.5894,1979.4093,1972.3004,1964.4312,1956.4854,1948.1774,1939.5983,1932.9889,1926.4177,1924.1587,1922.5973,1922.0,1921.0,1920.3578,1920.0,1919.1306,1919.0,1918.779,1918.0,1917.0,1916.0,1915.9783,1915.2222,1916.0,2160.2163,2146.8933,2133.5703,2120.8967,2111.204,2101.492,2088.804,2074.821,2061.552,2055.5688,2051.356,2047.7372,2043.4839,2040.048,2036.408,2032.3319,2029.5359,2027.1,2024.664,2022.2279,2019.588,2016.152,2012.9199,2009.4839,2006.395,2002.6119,1999.1759,1994.3778,1987.892,1980.7877,1973.096,1964.2736,1956.4039,1947.6599,1937.667,1931.328,1926.4496,1923.9719,1923.0,1922.0,1921.0,1920.024,1919.796,1919.0,1918.716,1917.28,1916.0,1915.3248,1914.9943,1915.0,1915.0,2160.8235,2151.2104,2139.6606,2128.6316,2117.5146,2107.594,2096.6804,2082.4172,2068.2788,2064.1357,2060.7708,2056.663,2053.1887,2049.7527,2045.1127,2041.0139,2036.8146,2034.3785,2031.9425,2028.7344,2025.5538,2022.4733,2019.1985,2016.0044,2012.6964,2009.8905,2006.1798,2002.469,1998.1606,1990.919,1982.4974,1973.0568,1963.6825,1955.4265,1945.9008,1935.7771,1930.1667,1925.484,1924.0,1922.5647,1921.0,1920.0,1919.1523,1919.0,1918.2648,1917.1035,1916.0,1915.0,1914.0,1913.7076,1913.3699,2167.7185,2159.561,2149.309,2137.5706,2126.0056,2113.4329,2100.5327,2087.257,2078.7502,2076.3694,2071.3923,2067.3296,2063.95,2059.733,2054.8176,2049.9456,2045.1453,2041.6847,2039.2212,2035.7852,2032.3491,2028.9132,2025.4772,2022.0339,2018.5734,2015.1128,2011.6768,2008.418,2004.8438,2000.5828,1991.6292,1982.7399,1972.9612,1963.2172,1953.4731,1942.7653,1934.5208,1928.7052,1925.4071,1923.9524,1922.0564,1921.0564,1920.0564,1919.1998,1918.732,1917.3206,1916.0564,1915.4414,1914.0548,1913.0,1912.9492,2174.0996,2165.581,2157.0771,2144.619,2133.6646,2119.4204,2105.5222,2095.1384,2091.3423,2088.9062,2084.255,2080.4858,2076.714,2071.5916,2065.801,2060.464,2055.261,2050.1418,2046.9823,2044.1624,2040.2904,2035.9358,2032.0637,2027.7092,2023.565,2018.9652,2016.5292,2014.0931,2011.3491,2005.7332,1998.7278,1990.5997,1981.2397,1971.4904,1960.2665,1950.834,1940.648,1935.2158,1932.4341,1927.726,1924.9426,1923.4825,1922.0706,1921.0734,1919.853,1919.0,1917.9193,1916.408,1914.9855,1913.536,1913.0,2181.3264,2171.6736,2161.0461,2149.7776,2138.5977,2124.2288,2112.1465,2106.3918,2103.9023,2101.407,2097.5747,2096.371,2092.7888,2087.1487,2079.5642,2072.264,2066.3918,2060.611,2056.6873,2052.902,2048.8315,2044.2144,2037.7135,2032.5615,2027.6896,2022.9088,2020.7778,2018.9456,2015.5728,2011.3296,2004.2776,1996.9135,1988.5183,1977.91,1967.1063,1957.2864,1950.0432,1946.2908,1942.876,1938.2415,1930.5244,1925.0219,1923.9088,1922.9088,1921.6248,1919.9343,1918.9857,1917.946,1915.972,1914.487,1913.0908,2189.4714,2176.99,2165.782,2154.63,2142.5537,2129.3638,2121.097,2117.675,2117.284,2115.97,2112.2441,2108.8137,2105.343,2101.139,2094.3296,2086.755,2079.0916,2072.139,2066.4614,2061.4434,2056.365,2051.4072,2045.1608,2036.9982,2033.2949,2030.34,2026.569,2024.1329,2021.054,2015.9327,2009.795,2002.6934,1994.41,1983.0585,1972.639,1964.26,1962.6749,1961.5459,1956.1182,1949.8549,1939.1799,1930.428,1925.532,1924.4869,1923.051,1922.0938,1920.2827,1919.1367,1917.3256,1915.871,1915.0,2195.0225,2182.1956,2169.6624,2159.0317,2146.3396,2133.8955,2130.3965,2128.0447,2128.4924,2128.8003,2127.1072,2123.4573,2118.9824,2114.27,2108.955,2100.007,2091.8745,2084.3865,2077.1885,2070.8928,2064.5847,2057.9492,2052.1384,2045.6608,2040.1556,2037.5223,2033.6504,2029.7478,2025.1451,2018.5292,2012.2212,2005.0603,1997.5012,1985.8092,1977.5298,1973.2836,1976.4467,1975.1031,1970.2312,1963.1263,1950.8672,1938.3921,1932.4596,1928.4355,1925.4772,1923.2131,1921.844,1920.1692,1918.7612,1917.408,1916.0762,2198.706,2186.5073,2174.3274,2163.6663,2150.7832,2143.4695,2140.221,2139.0889,2141.7124,2142.1199,2141.038,2137.3323,2133.273,2127.7769,2120.325,2113.017,2104.6472,2096.401,2088.1028,2080.0981,2072.9558,2064.7942,2058.0486,2050.9907,2045.165,2041.1874,2037.7513,2033.4434,2027.5714,2021.9554,2013.6136,2006.3394,1997.9989,1989.305,1984.4651,1982.6296,1987.325,1990.1244,1986.933,1977.7084,1966.0718,1951.2684,1941.6238,1935.0182,1928.5228,1924.4674,1923.0314,1921.5189,1920.1594,1918.6229,1917.1,2200.5613,2188.9336,2177.7363,2167.5952,2157.5251,2152.5608,2150.7383,2149.6064,2151.7896,2154.0828,2153.8901,2151.7856,2146.404,2139.764,2133.456,2125.148,2116.764,2107.9185,2099.0288,2088.6829,2079.3809,2071.9158,2063.8838,2056.3782,2048.9216,2043.6136,2040.1776,2035.8696,2029.9976,2023.3816,2016.004,2008.7656,2002.7568,1998.362,1992.6531,1993.8698,1999.0928,2000.6136,1998.043,1989.4886,1979.503,1965.8496,1952.1672,1942.4489,1933.3752,1926.2372,1924.5178,1923.0216,1921.6136,1920.1497,1918.1,2200.5642,2191.32,2179.1519,2171.832,2165.621,2160.8792,2159.4033,2157.1653,2160.3516,2164.183,2165.659,2165.2388,2159.2295,2151.895,2143.5789,2136.2136,2126.8184,2118.0918,2107.3794,2097.5437,2086.807,2077.3015,2068.9639,2060.6558,2052.3877,2046.0398,2042.1454,2038.133,2032.1433,2024.7782,2017.4998,2011.7833,2006.9358,2003.0833,2000.1924,2001.4396,2003.0398,2003.0398,2001.3718,1996.6636,1986.9196,1976.1765,1961.6475,1948.8396,1938.2163,1930.9084,1925.9174,1924.4478,1924.0118,1922.5544,1920.1398,2197.3486,2189.6377,2180.0989,2175.116,2171.622,2168.7825,2167.864,2167.945,2170.452,2173.8992,2177.2927,2177.434,2173.002,2163.6682,2154.048,2144.6458,2134.628,2124.884,2113.192,2102.217,2091.832,2081.5613,2072.5334,2064.082,2055.774,2048.466,2043.594,2039.1876,2034.768,2025.8873,2019.106,2013.4391,2008.4418,2007.2054,2005.9674,2006.932,2006.932,2006.7,2003.798,2000.2025,1992.772,1982.052,1968.652,1954.31,1942.796,1935.026,1929.776,1927.6158,1926.438,1924.002,1922.566,2190.2234,2186.0857,2180.9263,2177.9685,2174.1392,2174.6765,2174.6765,2175.8286,2177.897,2181.7246,2186.1367,2186.7805,2183.9768,2173.9358,2162.8386,2152.1167,2140.4043,2128.7363,2118.0444,2105.3562,2095.524,2085.7605,2076.1243,2067.3801,2058.589,2050.892,2045.0203,2039.256,2034.1506,2025.7957,2020.5322,2015.5938,2011.738,2010.8396,2010.7844,2010.8922,2010.8922,2010.3455,2006.5562,2002.6842,1996.7322,1986.9882,1973.7878,1960.6964,1947.6484,1937.7322,1933.7362,1932.1924,1929.8643,1926.9064,1925.7952,2182.2632,2180.9978,2179.6816,2178.1255,2177.2688,2180.6367,2181.3528,2182.3667,2184.2249,2188.0032,2193.097,2194.0662,2187.6543,2182.0144,2169.0742,2157.4368,2144.3086,2133.077,2120.595,2108.9785,2098.0957,2089.2944,2079.7603,2070.8064,2061.242,2053.3184,2046.3076,2040.2968,2033.384,2027.0049,2021.6973,2018.7024,2015.2664,2013.4814,2013.3184,2013.3184,2013.065,2011.8419,2009.8767,2004.0773,1998.6984,1988.4384,1977.2024,1965.0784,1952.5009,1941.846,1937.212,1936.6368,1934.9272,1933.1729,1933.8552,2177.5107,2177.2554,2176.5107,2176.2554,2176.6284,2179.7908,2182.4382,2184.2942,2187.176,2192.7927,2196.547,2194.9526,2188.336,2182.5232,2171.98,2159.8,2147.384,2136.1846,2123.0566,2111.8247,2100.5105,2090.786,2081.9766,2073.2327,2063.9087,2055.7446,2048.4365,2041.3513,2034.8993,2029.2566,2023.5646,2021.1287,2018.6926,2016.2566,2015.7446,2015.0,2014.1519,2012.768,2011.332,2005.4592,2000.3221,1989.8646,1978.7898,1968.3527,1956.5361,1947.3292,1942.2339,1941.793,1940.4612,1938.0253,1940.0593,2171.7583,2172.6584,2172.6584,2172.6584,2172.6584,2172.9385,2175.2036,2178.4688,2181.0757,2187.9202,2195.0537,2192.6777,2186.1084,2179.394,2170.809,2158.6292,2148.4622,2136.3525,2124.26,2113.08,2101.0708,2092.0198,2083.924,2074.7869,2066.5532,2058.171,2050.8628,2043.5548,2037.1287,2031.512,2025.8108,2022.384,2019.9569,2018.0874,2016.076,2015.5306,2014.1692,2011.768,2009.4932,2004.792,2000.5386,1991.144,1980.352,1969.7788,1959.6285,1950.0109,1946.3268,1948.0348,1948.4893,1947.6832,1949.5833,2162.5178,2163.634,2164.418,2165.015,2165.015,2165.612,2166.925,2169.8547,2172.7969,2176.6504,2180.2573,2182.5498,2180.877,2175.054,2166.786,2155.6282,2147.0537,2134.843,2124.229,2113.464,2101.9,2092.6763,2084.924,2077.2131,2069.0808,2060.597,2052.5164,2045.3324,2038.673,2033.109,2027.64,2022.981,2020.948,2019.109,2016.7036,2014.043,2013.0822,2011.171,2007.9332,2003.896,2000.46,1991.1296,1980.598,1971.2662,1961.461,1951.717,1948.9393,1955.6819,1960.582,1959.708,1958.8104,2148.9631,2150.443,2151.9065,2153.9072,2154.9072,2156.9136,2158.623,2161.0557,2163.495,2167.9084,2171.378,2173.8264,2172.5906,2168.371,2160.096,2152.0334,2143.671,2132.9055,2122.1848,2112.4497,2101.8958,2093.232,2085.924,2077.616,2069.757,2062.0,2054.692,2047.384,2040.0831,2034.512,2029.6442,2024.7913,2021.9492,2020.5233,2018.0778,2013.3032,2010.204,2008.9946,2006.664,2003.8936,2000.46,1991.12,1980.7777,1972.456,1962.8706,1955.9133,1955.534,1963.4419,1972.0977,1972.0822,1970.2137,2134.953,2139.5298,2142.187,2144.0598,2146.1165,2147.9316,2149.9182,2152.2708,2154.2397,2156.689,2159.7087,2162.706,2162.0889,2157.6663,2151.682,2146.0842,2138.3818,2129.0532,2118.7585,2110.0146,2100.2705,2092.232,2085.305,2077.616,2070.308,2063.0,2055.692,2047.384,2041.5254,2034.9614,2031.638,2027.4943,2023.8235,2021.9614,2019.5673,2015.3771,2011.6534,2009.2174,2007.1492,2003.792,2000.46,1991.12,1981.352,1972.9891,1965.6239,1962.4741,1962.5743,1971.4916,1976.4774,1977.194,1976.4495,2123.8218,2129.5696,2134.3206,2136.7812,2139.217,2141.2837,2142.9648,2144.5251,2146.9612,2149.3972,2150.9004,2151.4976,2150.5806,2147.634,2142.0896,2138.093,2132.069,2123.3252,2114.4568,2106.049,2097.6868,2090.5806,2084.6543,2077.616,2070.308,2063.8757,2056.256,2047.384,2043.2213,2038.2632,2034.6957,2031.5193,2027.8171,2024.2632,2021.7701,2018.1556,2014.0796,2010.6437,2008.2906,2004.6805,1999.9872,1991.9746,1984.5153,1977.2073,1973.5916,1971.7825,1971.6779,1976.4169,1979.7548,1979.8756,1978.9756,2113.5608,2118.9587,2125.03,2129.9106,2132.9385,2135.6763,2137.3962,2139.1404,2140.9844,2142.0945,2142.7927,2141.8967,2139.927,2136.723,2133.0828,2128.0178,2121.6636,2115.8992,2107.5886,2100.2444,2094.058,2089.0073,2083.4072,2076.3528,2070.006,2063.0,2056.8235,2049.949,2045.9938,2042.8596,2039.4237,2036.1035,2032.5154,2028.6277,2024.7556,2020.9418,2017.5674,2013.9078,2010.6338,2007.0939,2002.2218,1996.6685,1989.3677,1983.4998,1980.6215,1979.1854,1979.0615,1981.9108,1984.6036,1984.1396,1982.4019,2104.816,2107.0337,2115.2683,2122.521,2126.504,2129.62,2131.7388,2133.696,2134.7039,2135.5264,2134.356,2131.2676,2128.7559,2124.7607,2121.045,2117.536,2113.6638,2108.6526,2101.9578,2095.504,2091.632,2086.76,2081.196,2074.888,2068.9905,2063.0,2057.763,2054.7122,2051.0642,2047.8984,2044.873,2041.6725,2037.352,2033.4801,2029.608,2025.0961,2021.0806,2017.433,2013.392,2009.52,2005.523,2000.776,1994.9481,1988.488,1986.3788,1986.1841,1985.612,1987.5061,1988.7205,1986.3903,1984.1,2095.5916,2098.0627,2106.2754,2113.7612,2120.2012,2123.2083,2125.4075,2127.5608,2128.5374,2128.5134,2126.0774,2123.5032,2120.2566,2117.573,2114.456,2110.953,2107.397,2102.0803,2095.9937,2092.4617,2089.0535,2085.3337,2079.4617,2072.6096,2068.8918,2065.3083,2062.0266,2060.4365,2058.1548,2054.7188,2051.255,2047.1715,2043.2045,2039.3324,2034.6147,2030.5885,2025.7164,2021.726,2016.9724,2013.1005,2008.6852,2004.3564,1999.548,1995.7433,1994.0244,1992.3517,1991.5946,1992.3085,1991.2805,1989.2979,1986.1155,2089.4783,2089.481,2096.5942,2105.3103,2111.9468,2116.5388,2118.9746,2121.347,2122.839,2121.8152,2119.3792,2116.943,2114.507,2112.071,2108.969,2106.1992,2101.6873,2097.1123,2093.5017,2090.0356,2086.7795,2082.9075,2078.4373,2072.8184,2070.3438,2069.161,2067.7249,2066.235,2063.8528,2061.4167,2058.3813,2053.929,2048.6892,2044.9701,2040.8933,2036.4409,2032.0309,2026.5995,2021.8248,2017.9529,2013.0808,2009.1848,2005.0902,2002.3129,1999.5764,1998.1609,1997.1609,1997.1609,1996.5406,1992.4275,1988.3029,2083.7927,2082.5198,2087.896,2095.6094,2103.5054,2109.2488,2110.9783,2112.9744,2114.568,2114.98,2113.9836,2112.0908,2109.6548,2107.2253,2104.7893,2101.711,2097.8418,2094.4814,2092.0454,2089.2253,2085.1855,2082.7456,2079.6226,2076.8918,2075.4558,2075.0132,2073.5771,2072.0142,2069.7073,2067.2693,2063.8386,2061.3972,2056.916,2052.044,2047.1719,2043.2999,2038.4279,2033.5559,2028.684,2022.8119,2018.9332,2014.0677,2010.6052,2007.1663,2004.7358,2003.2932,2002.0122,2001.4186,1999.9786,1996.5461,1992.2133,2079.8342,2073.4695,2078.3032,2086.3162,2093.0024,2098.5486,2100.5518,2102.14,2106.623,2108.7014,2108.9353,2107.6262,2105.946,2104.5671,2102.3633,2099.083,2095.924,2093.488,2091.052,2088.5332,2086.535,2085.0317,2083.0403,2083.793,2082.546,2081.2986,2079.8625,2077.4265,2075.5576,2073.1216,2069.6858,2066.9004,2063.7617,2059.8896,2055.3745,2050.5786,2045.7065,2040.8345,2035.9625,2030.4783,2024.4176,2020.336,2016.4536,2012.5367,2010.5817,2008.1456,2006.7097,2004.6094,2002.4048,1999.9689,1996.5762,2075.8818,2068.21,2068.3948,2073.9287,2081.118,2086.265,2090.179,2092.7268,2098.011,2102.306,2103.818,2103.3713,2102.8557,2101.373,2099.937,2097.4106,2094.924,2093.488,2092.8665,2091.475,2089.718,2088.682,2088.5771,2088.718,2087.718,2086.718,2085.6567,2083.705,2081.4102,2078.8691,2075.5127,2072.432,2068.666,2065.67,2061.8594,2057.8572,2052.985,2049.0803,2043.5264,2038.3691,2032.8922,2027.6217,2022.8112,2019.0006,2015.4341,2012.998,2009.703,2007.7756,2004.831,2002.395,1999.959,2069.8442,2061.153,2059.4016,2064.675,2070.2617,2074.339,2078.7205,2084.8855,2092.488,2096.4604,2099.0435,2099.7148,2099.62,2098.4956,2096.942,2095.0747,2093.6604,2092.3489,2093.2705,2094.6267,2093.5706,2093.6436,2093.8557,2093.5706,2093.0066,2091.5706,2090.5706,2088.6985,2087.2625,2084.8264,2082.2617,2079.064,2074.7888,2071.2285,2067.6682,2063.9531,2059.2637,2054.5576,2050.425,2046.3179,2040.2357,2033.9277,2029.0317,2024.8745,2021.0835,2017.8505,2014.6553,2010.8096,2008.2572,2004.9741,2002.3853,2060.2139,2054.7937,2052.1543,2055.8525,2059.8423,2063.714,2069.0137,2080.4453,2088.4646,2092.601,2095.037,2096.2886,2096.2886,2095.3555,2094.1433,2092.6484,2091.2886,2092.3643,2095.6074,2096.7114,2097.0,2097.7114,2098.4229,2098.3318,2097.7114,2096.7114,2095.8242,2093.5508,2092.115,2089.679,2088.0063,2084.807,2081.0454,2077.299,2073.4988,2069.959,2065.5422,2060.7373,2056.087,2051.9563,2047.727,2041.2063,2035.5989,2031.3302,2026.8503,2023.9021,2020.8673,2016.2389,2010.6835,2008.2474,2004.8114,2052.163,2047.1887,2045.7247,2047.7247,2050.547,2056.3232,2064.4424,2077.6013,2085.4746,2088.7488,2090.3223,2092.6206,2092.7705,2092.0942,2090.6584,2089.1729,2088.928,2090.816,2094.7583,2098.2463,2099.82,2100.3584,2101.233,2101.2754,2102.2754,2101.2754,2100.2754,2099.1553,2097.2754,2095.5312,2093.0952,2090.1282,2086.3538,2082.8577,2079.3513,2075.5552,2072.3696,2066.8113,2061.8474,2056.0674,2051.1208,2046.1857,2040.3945,2036.4272,2034.0304,2031.072,2027.9633,2022.5808,2016.353,2010.8212,2008.2377,2043.601,2040.7725,2041.2805,2042.8441,2046.6681,2053.2761,2061.6125,2073.3945,2080.741,2084.8962,2086.8962,2088.3774,2089.436,2089.436,2087.2322,2085.0752,2085.5122,2086.9482,2089.2563,2093.7812,2097.0269,2099.7087,2102.9546,2105.1836,2106.1277,2106.1277,2105.1277,2103.2556,2101.9934,2100.3838,2097.9478,2095.5117,2092.0757,2088.1516,2084.2036,2079.7676,2075.8828,2071.9988,2065.415,2059.861,2053.9438,2047.6223,2043.4083,2040.6495,2038.8438,2037.2499,2034.2916,2028.6855,2023.0437,2016.1997,2010.7202,2034.9298,2034.0245,2035.0199,2038.8318,2044.6964,2050.8499,2058.158,2066.4958,2073.2058,2078.0542,2081.9507,2085.0188,2086.3486,2087.01,2085.796,2080.7363,2079.0398,2079.5618,2081.9878,2083.0437,2084.6997,2092.8052,2099.4038,2105.2646,2109.5483,2109.99,2108.9856,2108.1082,2106.977,2105.236,2103.612,2100.364,2097.9275,2094.0042,2089.132,2084.2637,2080.3882,2074.5261,2068.986,2062.6792,2056.37,2049.062,2045.578,2043.1421,2042.696,2040.27,2037.8341,2034.2001,2027.8961,2021.0521,2015.18,2028.7512,2028.7512,2030.7233,2035.1533,2041.2068,2047.1907,2053.3154,2060.2073,2065.2705,2069.369,2072.9866,2077.127,2081.667,2083.6548,2082.224,2075.2476,2069.1675,2069.05,2070.335,2072.0786,2076.795,2084.3408,2094.5193,2101.4236,2107.2954,2110.5837,2111.4163,2111.0532,2110.4163,2109.982,2108.3113,2105.857,2102.7285,2098.6433,2093.9846,2089.1125,2083.8242,2077.9521,2071.4124,2064.7312,2058.1116,2050.9185,2047.0043,2047.2643,2046.7142,2045.1125,2041.6765,2038.2323,2032.7485,2025.4406,2019.0908,2022.3308,2022.4727,2026.2355,2031.5391,2037.8456,2042.4817,2046.8599,2051.934,2056.8062,2060.6543,2064.09,2068.422,2072.857,2075.277,2074.9392,2069.4958,2063.111,2060.4727,2060.6301,2061.5557,2069.6235,2079.339,2088.391,2095.5913,2101.443,2105.4727,2110.1184,2112.892,2112.8425,2112.8425,2111.6624,2110.166,2107.5808,2102.709,2097.9944,2092.9648,2087.4224,2081.7935,2073.8384,2066.5305,2059.835,2054.8904,2051.273,2049.8425,2049.8425,2048.8425,2046.3729,2041.6584,2036.782,2029.8289,2022.8849],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD013.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD013.py load and self-test diagnostics complete.")
