package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD012Index.html" target="_blank">SquawLOD012</a>,  source <a href="../../../Geospatial/SquawLOD012.java">SquawLOD012.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD012.x3d">SquawLOD012.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD012.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD012.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD012
{
	/** Default constructor to create this object. */
	public SquawLOD012 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD012.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD012.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD012.x3d"))
    .addChild(new GeoLOD().setCenter(4340937.286173,740603.999947,2056.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(16133.333).setChild1Url(new String[] {"SquawLOD013.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD013.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw006.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw006.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4340105.411173,739994.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(25).setXSpacing(50.750000).setZDimension(33).setZSpacing(50.416667).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {1985.1191,1981.702,1974.2977,1980.3597,1986.8451,1996.4597,2001.5386,2003.0347,2007.4347,2013.3079,2006.5221,1984.4271,1965.0347,1962.0936,1967.02,1970.2559,1973.3225,1981.1705,1995.4368,2008.6619,2032.6868,2053.1118,2065.587,2071.9119,2074.0903,1973.1041,1967.8063,1966.3541,1971.1211,1973.1771,1974.7107,1980.8104,1983.7487,1996.8562,1989.4855,1984.3141,1972.281,1960.0521,1958.0521,1961.0599,1963.1041,1966.352,1971.4271,1978.0328,1987.2089,2007.0396,2026.4598,2039.7734,2044.1375,2043.3605,1962.1736,1959.8966,1960.0868,1960.1454,1959.1389,1963.0369,1968.1345,1975.0161,1987.3868,1972.7104,1969.4972,1965.2487,1956.0868,1951.0118,1952.3105,1955.379,1959.4475,1964.4618,1968.6237,1976.6573,1985.5125,1999.459,2011.8689,2021.0125,2025.2604,1959.9878,1957.825,1955.0912,1955.082,1955.0,1955.005,1955.6077,1959.7361,1965.6927,1961.4954,1956.3749,1952.4396,1949.1216,1946.9341,1947.0182,1948.1489,1950.5431,1954.618,1958.2977,1964.3568,1972.3159,1976.1611,1987.1987,1997.4326,2000.7291};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {1962.7438,1959.9727,1957.0,1957.6875,1958.5062,1955.2125,1951.2234,1949.1602,1947.3125,1947.9664,1948.1797,1946.2195,1944.1562,1942.0813,1942.1562,1943.1562,1944.3125,1946.2148,1947.6921,1954.3625,1961.9125,1962.4688,1968.9688,1978.275,1983.4688,1966.8091,1964.634,1960.8091,1963.881,1967.827,1966.1431,1961.254,1960.993,1957.2935,1953.8,1948.959,1948.618,1943.8091,1939.6733,1937.1909,1937.416,1938.382,1938.382,1940.8319,1948.4319,1952.8673,1953.382,1956.132,1963.3645,1967.5729,1972.7743,1973.5486,1973.7422,1975.648,1980.7229,1979.3729,1973.2002,1975.7743,1975.5486,1968.4944,1962.3229,1966.8716,1955.0972,1946.5317,1937.6243,1934.0515,1935.158,1934.2257,1935.5741,1939.1572,1945.4514,1946.2257,1946.9757,1953.2764,1956.3739,1987.2927,1990.0039,1992.0234,1992.4591,1992.9584,1990.2645,1984.1896,1982.7396,1985.4791,1982.7042,1979.4791,1981.2188,1970.4791,1963.1992,1952.7688,1939.0878,1931.7,1931.0977,1932.2604,1936.7854,1943.0354,1939.325,1938.0104,1941.6062,1946.3469};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2006.9194,2010.5759,2010.8195,2008.5903,2004.7278,1997.2299,1991.2474,1993.7396,1996.6212,1989.9298,1988.1146,1991.4097,1986.5243,1979.9646,1970.6646,1951.9858,1937.1049,1929.625,1928.6123,1933.4854,1949.4,1938.8418,1934.0,1934.8767,1936.9296,2032.2208,2035.8458,2025.7604,2018.7975,2012.0021,2003.0385,2001.5217,2005.2166,2002.1711,1998.3403,2003.1903,2004.6805,2001.3403,1995.2405,1986.6609,1970.2612,1950.7805,1938.8854,1924.5112,1926.7097,1938.9298,1934.9799,1929.4124,1930.2126,1932.2299,2059.5781,2051.8096,2032.0912,2019.8026,2009.8541,2007.1604,2009.1854,2014.2604,2011.9354,2011.2709,2013.4855,2014.6354,2011.0,2004.5604,1998.8208,1981.8784,1966.4,1952.2826,1934.1849,1924.0,1926.5834,1926.483,1925.0,1925.4758,1927.2281,2071.8413,2052.5015,2036.0521,2024.2819,2016.5612,2009.8103,2010.55,2019.8507,2023.2014,2020.7358,2017.6606,2015.6306,2014.3993,2009.5256,2002.3606,1988.3912,1968.1007,1949.1002,1935.7007,1927.5707,1922.3993,1923.8048,1923.3993,1923.0,1924.9};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2090.096,2077.305,2064.514,2044.6389,2026.4639,2016.7479,2013.8047,2023.4127,2025.5642,2014.3181,2012.3491,2016.359,2016.0,2012.925,2003.134,1990.325,1969.5,1952.875,1940.55,1925.909,1923.4,1921.293,1922.0,1922.0,1924.0,2117.3032,2099.8938,2080.414,2060.108,2042.65,2025.3586,2018.239,2014.8438,2009.6094,2007.4688,2005.0172,2011.3141,2010.4062,2007.725,1995.7172,1984.5062,1963.5781,1946.1875,1935.1375,1925.0,1923.0,1922.0,1921.0,1921.0,1923.4219,2136.94,2111.7896,2093.4895,2069.5466,2046.102,2030.3107,2020.9465,2015.0,2010.3,2004.7216,2000.578,1996.0442,1996.007,1992.9319,1985.4894,1966.1139,1945.958,1930.1967,1923.28,1924.0,1922.2014,1921.0,1919.1259,1919.0,1920.9503,2154.1472,2126.0486,2099.75,2069.375,2049.2617,2035.0369,2022.2078,2017.6736,2011.6003,2007.6868,2002.681,1997.4618,1986.5382,1978.3895,1963.2339,1950.5225,1935.9382,1925.625,1922.0,1920.2556,1921.2153,1919.1749,1918.1345,1917.5382,1917.9539};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {2160.4,2130.775,2104.2812,2078.4333,2055.654,2043.534,2034.9235,2027.6562,2022.9823,2018.5062,2012.0682,2005.9292,1997.8541,1987.0563,1973.2583,1956.6062,1938.425,1926.0521,1922.2349,1921.2029,1919.6562,1919.0,1917.0,1915.5729,1915.9573,2162.777,2141.6943,2118.177,2094.8347,2069.1694,2062.0117,2054.6853,2045.3195,2037.477,2031.5388,2024.9935,2017.8892,2011.7847,2004.0726,1992.9695,1973.6694,1955.1594,1934.8876,1924.9424,1921.681,1919.157,1918.325,1916.25,1914.0686,1913.0,2176.6729,2157.8403,2133.3047,2104.6804,2094.645,2087.3657,2080.4036,2066.538,2056.0305,2048.1533,2039.6769,2029.8652,2020.7153,2015.6134,2006.7192,1990.8958,1970.8232,1948.5729,1936.9806,1927.8877,1923.1431,1920.6826,1918.5182,1915.4701,1913.0,2192.0781,2166.5044,2141.9036,2123.6416,2122.2917,2116.9875,2108.8374,2095.1836,2079.8374,2066.7417,2055.2688,2041.218,2033.9688,2026.5466,2016.023,2002.648,1980.9198,1967.3125,1964.4099,1947.9896,1929.0917,1924.543,1921.4922,1918.0565,1915.3229};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {2199.8594,2174.826,2152.5425,2144.828,2147.8645,2145.966,2136.4707,2121.674,2104.5544,2086.0527,2069.4214,2053.8013,2042.2882,2034.1382,2021.4432,2005.453,1991.2528,1988.5659,1995.541,1978.1897,1949.5834,1932.645,1924.072,1921.0504,1917.3882,2199.4465,2179.5193,2168.8203,2162.7712,2166.814,2172.1343,2161.7314,2143.9805,2124.9604,2102.6318,2081.107,2062.7878,2047.2534,2038.1594,2023.9154,2010.8035,2004.2069,2004.507,2003.8035,1993.54,1970.1604,1942.8069,1928.8169,1925.2534,1921.3535,2185.3218,2180.4695,2176.7188,2178.9102,2182.3687,2191.1313,2184.1187,2160.0195,2134.9375,2110.3438,2089.0046,2069.7375,2052.2188,2039.0359,2024.7688,2015.9875,2012.2188,2012.2188,2010.2969,2000.95,1980.1312,1953.3875,1935.8281,1932.6125,1929.8531,2174.4663,2174.6318,2174.836,2179.6487,2185.5742,2196.7285,2184.6147,2164.691,2140.5,2115.2676,2092.7563,2075.2388,2057.184,2042.0203,2029.734,2020.959,2016.884,2015.0,2011.4487,2001.95,1983.1105,1960.9332,1945.6381,1944.8789,1945.6361};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {2153.3535,2156.2795,2158.6528,2162.1536,2168.7131,2175.8777,2173.4521,2156.8264,2137.3506,2115.7507,2094.45,2078.225,2061.1494,2045.9243,2032.8494,2022.9243,2019.7,2011.944,2009.0178,2001.95,1983.6,1964.4493,1951.5599,1967.3704,1965.7615,2127.6272,2136.8313,2141.6848,2145.0586,2150.0562,2154.077,2152.4417,2142.3633,2128.5562,2109.671,2092.3354,2078.225,2063.1145,2046.85,2036.0792,2029.0042,2022.1604,2015.3646,2008.6646,2001.95,1985.4292,1971.6687,1968.4297,1978.0542,1978.2146,2106.7605,2119.1396,2129.0105,2134.0854,2136.7925,2135.2854,2129.5806,2121.1355,2112.3604,2097.5771,2088.2202,2076.0762,2063.0,2053.0156,2046.0098,2038.9966,2030.8597,2022.4097,2014.6738,2006.0718,1995.4076,1985.1857,1984.1597,1987.9188,1984.1,2091.6194,2099.5195,2114.3645,2121.1897,2123.8916,2119.4348,2114.3596,2108.2847,2099.5098,2091.4048,2084.1116,2073.15,2068.0903,2065.0154,2059.797,2051.6504,2042.5038,2033.3403,2022.6652,2014.0403,2004.9174,1998.7708,1996.0903,1996.053,1987.2858};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {2080.6792,2081.4644,2096.4402,2103.2695,2109.3625,2109.4988,2105.4397,2100.746,2094.3,2088.466,2085.159,2083.02,2080.0312,2075.9563,2071.7224,2064.804,2057.124,2047.2812,2037.1312,2025.4617,2016.8208,2010.3458,2006.2682,2002.1854,1996.1115,2070.773,2060.618,2072.6033,2081.7637,2094.8486,2100.0244,2099.4744,2096.3901,2093.0073,2094.732,2092.9514,2092.9514,2090.9514,2087.8765,2083.7979,2077.477,2069.3513,2061.2014,2052.038,2041.8771,2030.1417,2021.26,2014.4514,2008.1506,2002.0757,2052.883,2046.2444,2051.9714,2067.9897,2086.8945,2091.593,2093.059,2090.1182,2090.0413,2097.7292,2099.941,2100.941,2100.8818,2098.807,2094.732,2088.657,2081.2407,2073.5068,2063.9229,2052.8909,2041.6819,2034.4729,2028.0729,2016.3966,2007.9878,2035.1813,2035.3625,2045.8438,2060.4243,2075.0813,2084.093,2087.0938,2083.1836,2079.4407,2083.15,2091.789,2104.9438,2109.9062,2107.8125,2104.6626,2099.5874,2092.2124,2082.496,2072.0063,2058.901,2046.3438,2042.843,2038.3828,2028.3375,2015.0125};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {2022.2698,2026.6069,2038.6284,2048.0354,2058.314,2065.4639,2074.064,2072.0552,2060.424,2060.6135,2077.657,2095.0415,2105.3855,2113.0557,2112.8523,2109.6177,2101.1816,2090.9932,2077.5215,2062.364,2052.143,2049.8716,2047.0251,2037.2216,2022.9431};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.04167,0.00391,0.08333,0.00391,0.125,0.00391,0.16667,0.00391,0.20833,0.00391,0.25,0.00391,0.29167,0.00391,0.33333,0.00391,0.375,0.00391,0.41667,0.00391,0.45833,0.00391,0.5,0.00391,0.54167,0.00391,0.58333,0.00391,0.625,0.00391,0.66667,0.00391,0.70833,0.00391,0.75,0.00391,0.79167,0.00391,0.83333,0.00391,0.875,0.00391,0.91667,0.00391,0.95833,0.00391,0.99609,0.00391,0.00391,0.03125,0.04167,0.03125,0.08333,0.03125,0.125,0.03125,0.16667,0.03125,0.20833,0.03125,0.25,0.03125,0.29167,0.03125,0.33333,0.03125,0.375,0.03125,0.41667,0.03125,0.45833,0.03125,0.5,0.03125,0.54167,0.03125,0.58333,0.03125,0.625,0.03125,0.66667,0.03125,0.70833,0.03125,0.75,0.03125,0.79167,0.03125,0.83333,0.03125,0.875,0.03125,0.91667,0.03125,0.95833,0.03125,0.99609,0.03125,0.00391,0.0625,0.04167,0.0625,0.08333,0.0625,0.125,0.0625,0.16667,0.0625,0.20833,0.0625,0.25,0.0625,0.29167,0.0625,0.33333,0.0625,0.375,0.0625,0.41667,0.0625,0.45833,0.0625,0.5,0.0625,0.54167,0.0625,0.58333,0.0625,0.625,0.0625,0.66667,0.0625,0.70833,0.0625,0.75,0.0625,0.79167,0.0625,0.83333,0.0625,0.875,0.0625,0.91667,0.0625,0.95833,0.0625,0.99609,0.0625,0.00391,0.09375,0.04167,0.09375,0.08333,0.09375,0.125,0.09375,0.16667,0.09375,0.20833,0.09375,0.25,0.09375,0.29167,0.09375,0.33333,0.09375,0.375,0.09375,0.41667,0.09375,0.45833,0.09375,0.5,0.09375,0.54167,0.09375,0.58333,0.09375,0.625,0.09375,0.66667,0.09375,0.70833,0.09375,0.75,0.09375,0.79167,0.09375,0.83333,0.09375,0.875,0.09375,0.91667,0.09375,0.95833,0.09375,0.99609,0.09375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.00391,0.125,0.04167,0.125,0.08333,0.125,0.125,0.125,0.16667,0.125,0.20833,0.125,0.25,0.125,0.29167,0.125,0.33333,0.125,0.375,0.125,0.41667,0.125,0.45833,0.125,0.5,0.125,0.54167,0.125,0.58333,0.125,0.625,0.125,0.66667,0.125,0.70833,0.125,0.75,0.125,0.79167,0.125,0.83333,0.125,0.875,0.125,0.91667,0.125,0.95833,0.125,0.99609,0.125,0.00391,0.15625,0.04167,0.15625,0.08333,0.15625,0.125,0.15625,0.16667,0.15625,0.20833,0.15625,0.25,0.15625,0.29167,0.15625,0.33333,0.15625,0.375,0.15625,0.41667,0.15625,0.45833,0.15625,0.5,0.15625,0.54167,0.15625,0.58333,0.15625,0.625,0.15625,0.66667,0.15625,0.70833,0.15625,0.75,0.15625,0.79167,0.15625,0.83333,0.15625,0.875,0.15625,0.91667,0.15625,0.95833,0.15625,0.99609,0.15625,0.00391,0.1875,0.04167,0.1875,0.08333,0.1875,0.125,0.1875,0.16667,0.1875,0.20833,0.1875,0.25,0.1875,0.29167,0.1875,0.33333,0.1875,0.375,0.1875,0.41667,0.1875,0.45833,0.1875,0.5,0.1875,0.54167,0.1875,0.58333,0.1875,0.625,0.1875,0.66667,0.1875,0.70833,0.1875,0.75,0.1875,0.79167,0.1875,0.83333,0.1875,0.875,0.1875,0.91667,0.1875,0.95833,0.1875,0.99609,0.1875,0.00391,0.21875,0.04167,0.21875,0.08333,0.21875,0.125,0.21875,0.16667,0.21875,0.20833,0.21875,0.25,0.21875,0.29167,0.21875,0.33333,0.21875,0.375,0.21875,0.41667,0.21875,0.45833,0.21875,0.5,0.21875,0.54167,0.21875,0.58333,0.21875,0.625,0.21875,0.66667,0.21875,0.70833,0.21875,0.75,0.21875,0.79167,0.21875,0.83333,0.21875,0.875,0.21875,0.91667,0.21875,0.95833,0.21875,0.99609,0.21875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.00391,0.25,0.04167,0.25,0.08333,0.25,0.125,0.25,0.16667,0.25,0.20833,0.25,0.25,0.25,0.29167,0.25,0.33333,0.25,0.375,0.25,0.41667,0.25,0.45833,0.25,0.5,0.25,0.54167,0.25,0.58333,0.25,0.625,0.25,0.66667,0.25,0.70833,0.25,0.75,0.25,0.79167,0.25,0.83333,0.25,0.875,0.25,0.91667,0.25,0.95833,0.25,0.99609,0.25,0.00391,0.28125,0.04167,0.28125,0.08333,0.28125,0.125,0.28125,0.16667,0.28125,0.20833,0.28125,0.25,0.28125,0.29167,0.28125,0.33333,0.28125,0.375,0.28125,0.41667,0.28125,0.45833,0.28125,0.5,0.28125,0.54167,0.28125,0.58333,0.28125,0.625,0.28125,0.66667,0.28125,0.70833,0.28125,0.75,0.28125,0.79167,0.28125,0.83333,0.28125,0.875,0.28125,0.91667,0.28125,0.95833,0.28125,0.99609,0.28125,0.00391,0.3125,0.04167,0.3125,0.08333,0.3125,0.125,0.3125,0.16667,0.3125,0.20833,0.3125,0.25,0.3125,0.29167,0.3125,0.33333,0.3125,0.375,0.3125,0.41667,0.3125,0.45833,0.3125,0.5,0.3125,0.54167,0.3125,0.58333,0.3125,0.625,0.3125,0.66667,0.3125,0.70833,0.3125,0.75,0.3125,0.79167,0.3125,0.83333,0.3125,0.875,0.3125,0.91667,0.3125,0.95833,0.3125,0.99609,0.3125,0.00391,0.34375,0.04167,0.34375,0.08333,0.34375,0.125,0.34375,0.16667,0.34375,0.20833,0.34375,0.25,0.34375,0.29167,0.34375,0.33333,0.34375,0.375,0.34375,0.41667,0.34375,0.45833,0.34375,0.5,0.34375,0.54167,0.34375,0.58333,0.34375,0.625,0.34375,0.66667,0.34375,0.70833,0.34375,0.75,0.34375,0.79167,0.34375,0.83333,0.34375,0.875,0.34375,0.91667,0.34375,0.95833,0.34375,0.99609,0.34375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.00391,0.375,0.04167,0.375,0.08333,0.375,0.125,0.375,0.16667,0.375,0.20833,0.375,0.25,0.375,0.29167,0.375,0.33333,0.375,0.375,0.375,0.41667,0.375,0.45833,0.375,0.5,0.375,0.54167,0.375,0.58333,0.375,0.625,0.375,0.66667,0.375,0.70833,0.375,0.75,0.375,0.79167,0.375,0.83333,0.375,0.875,0.375,0.91667,0.375,0.95833,0.375,0.99609,0.375,0.00391,0.40625,0.04167,0.40625,0.08333,0.40625,0.125,0.40625,0.16667,0.40625,0.20833,0.40625,0.25,0.40625,0.29167,0.40625,0.33333,0.40625,0.375,0.40625,0.41667,0.40625,0.45833,0.40625,0.5,0.40625,0.54167,0.40625,0.58333,0.40625,0.625,0.40625,0.66667,0.40625,0.70833,0.40625,0.75,0.40625,0.79167,0.40625,0.83333,0.40625,0.875,0.40625,0.91667,0.40625,0.95833,0.40625,0.99609,0.40625,0.00391,0.4375,0.04167,0.4375,0.08333,0.4375,0.125,0.4375,0.16667,0.4375,0.20833,0.4375,0.25,0.4375,0.29167,0.4375,0.33333,0.4375,0.375,0.4375,0.41667,0.4375,0.45833,0.4375,0.5,0.4375,0.54167,0.4375,0.58333,0.4375,0.625,0.4375,0.66667,0.4375,0.70833,0.4375,0.75,0.4375,0.79167,0.4375,0.83333,0.4375,0.875,0.4375,0.91667,0.4375,0.95833,0.4375,0.99609,0.4375,0.00391,0.46875,0.04167,0.46875,0.08333,0.46875,0.125,0.46875,0.16667,0.46875,0.20833,0.46875,0.25,0.46875,0.29167,0.46875,0.33333,0.46875,0.375,0.46875,0.41667,0.46875,0.45833,0.46875,0.5,0.46875,0.54167,0.46875,0.58333,0.46875,0.625,0.46875,0.66667,0.46875,0.70833,0.46875,0.75,0.46875,0.79167,0.46875,0.83333,0.46875,0.875,0.46875,0.91667,0.46875,0.95833,0.46875,0.99609,0.46875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.00391,0.5,0.04167,0.5,0.08333,0.5,0.125,0.5,0.16667,0.5,0.20833,0.5,0.25,0.5,0.29167,0.5,0.33333,0.5,0.375,0.5,0.41667,0.5,0.45833,0.5,0.5,0.5,0.54167,0.5,0.58333,0.5,0.625,0.5,0.66667,0.5,0.70833,0.5,0.75,0.5,0.79167,0.5,0.83333,0.5,0.875,0.5,0.91667,0.5,0.95833,0.5,0.99609,0.5,0.00391,0.53125,0.04167,0.53125,0.08333,0.53125,0.125,0.53125,0.16667,0.53125,0.20833,0.53125,0.25,0.53125,0.29167,0.53125,0.33333,0.53125,0.375,0.53125,0.41667,0.53125,0.45833,0.53125,0.5,0.53125,0.54167,0.53125,0.58333,0.53125,0.625,0.53125,0.66667,0.53125,0.70833,0.53125,0.75,0.53125,0.79167,0.53125,0.83333,0.53125,0.875,0.53125,0.91667,0.53125,0.95833,0.53125,0.99609,0.53125,0.00391,0.5625,0.04167,0.5625,0.08333,0.5625,0.125,0.5625,0.16667,0.5625,0.20833,0.5625,0.25,0.5625,0.29167,0.5625,0.33333,0.5625,0.375,0.5625,0.41667,0.5625,0.45833,0.5625,0.5,0.5625,0.54167,0.5625,0.58333,0.5625,0.625,0.5625,0.66667,0.5625,0.70833,0.5625,0.75,0.5625,0.79167,0.5625,0.83333,0.5625,0.875,0.5625,0.91667,0.5625,0.95833,0.5625,0.99609,0.5625,0.00391,0.59375,0.04167,0.59375,0.08333,0.59375,0.125,0.59375,0.16667,0.59375,0.20833,0.59375,0.25,0.59375,0.29167,0.59375,0.33333,0.59375,0.375,0.59375,0.41667,0.59375,0.45833,0.59375,0.5,0.59375,0.54167,0.59375,0.58333,0.59375,0.625,0.59375,0.66667,0.59375,0.70833,0.59375,0.75,0.59375,0.79167,0.59375,0.83333,0.59375,0.875,0.59375,0.91667,0.59375,0.95833,0.59375,0.99609,0.59375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.00391,0.625,0.04167,0.625,0.08333,0.625,0.125,0.625,0.16667,0.625,0.20833,0.625,0.25,0.625,0.29167,0.625,0.33333,0.625,0.375,0.625,0.41667,0.625,0.45833,0.625,0.5,0.625,0.54167,0.625,0.58333,0.625,0.625,0.625,0.66667,0.625,0.70833,0.625,0.75,0.625,0.79167,0.625,0.83333,0.625,0.875,0.625,0.91667,0.625,0.95833,0.625,0.99609,0.625,0.00391,0.65625,0.04167,0.65625,0.08333,0.65625,0.125,0.65625,0.16667,0.65625,0.20833,0.65625,0.25,0.65625,0.29167,0.65625,0.33333,0.65625,0.375,0.65625,0.41667,0.65625,0.45833,0.65625,0.5,0.65625,0.54167,0.65625,0.58333,0.65625,0.625,0.65625,0.66667,0.65625,0.70833,0.65625,0.75,0.65625,0.79167,0.65625,0.83333,0.65625,0.875,0.65625,0.91667,0.65625,0.95833,0.65625,0.99609,0.65625,0.00391,0.6875,0.04167,0.6875,0.08333,0.6875,0.125,0.6875,0.16667,0.6875,0.20833,0.6875,0.25,0.6875,0.29167,0.6875,0.33333,0.6875,0.375,0.6875,0.41667,0.6875,0.45833,0.6875,0.5,0.6875,0.54167,0.6875,0.58333,0.6875,0.625,0.6875,0.66667,0.6875,0.70833,0.6875,0.75,0.6875,0.79167,0.6875,0.83333,0.6875,0.875,0.6875,0.91667,0.6875,0.95833,0.6875,0.99609,0.6875,0.00391,0.71875,0.04167,0.71875,0.08333,0.71875,0.125,0.71875,0.16667,0.71875,0.20833,0.71875,0.25,0.71875,0.29167,0.71875,0.33333,0.71875,0.375,0.71875,0.41667,0.71875,0.45833,0.71875,0.5,0.71875,0.54167,0.71875,0.58333,0.71875,0.625,0.71875,0.66667,0.71875,0.70833,0.71875,0.75,0.71875,0.79167,0.71875,0.83333,0.71875,0.875,0.71875,0.91667,0.71875,0.95833,0.71875,0.99609,0.71875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.00391,0.75,0.04167,0.75,0.08333,0.75,0.125,0.75,0.16667,0.75,0.20833,0.75,0.25,0.75,0.29167,0.75,0.33333,0.75,0.375,0.75,0.41667,0.75,0.45833,0.75,0.5,0.75,0.54167,0.75,0.58333,0.75,0.625,0.75,0.66667,0.75,0.70833,0.75,0.75,0.75,0.79167,0.75,0.83333,0.75,0.875,0.75,0.91667,0.75,0.95833,0.75,0.99609,0.75,0.00391,0.78125,0.04167,0.78125,0.08333,0.78125,0.125,0.78125,0.16667,0.78125,0.20833,0.78125,0.25,0.78125,0.29167,0.78125,0.33333,0.78125,0.375,0.78125,0.41667,0.78125,0.45833,0.78125,0.5,0.78125,0.54167,0.78125,0.58333,0.78125,0.625,0.78125,0.66667,0.78125,0.70833,0.78125,0.75,0.78125,0.79167,0.78125,0.83333,0.78125,0.875,0.78125,0.91667,0.78125,0.95833,0.78125,0.99609,0.78125,0.00391,0.8125,0.04167,0.8125,0.08333,0.8125,0.125,0.8125,0.16667,0.8125,0.20833,0.8125,0.25,0.8125,0.29167,0.8125,0.33333,0.8125,0.375,0.8125,0.41667,0.8125,0.45833,0.8125,0.5,0.8125,0.54167,0.8125,0.58333,0.8125,0.625,0.8125,0.66667,0.8125,0.70833,0.8125,0.75,0.8125,0.79167,0.8125,0.83333,0.8125,0.875,0.8125,0.91667,0.8125,0.95833,0.8125,0.99609,0.8125,0.00391,0.84375,0.04167,0.84375,0.08333,0.84375,0.125,0.84375,0.16667,0.84375,0.20833,0.84375,0.25,0.84375,0.29167,0.84375,0.33333,0.84375,0.375,0.84375,0.41667,0.84375,0.45833,0.84375,0.5,0.84375,0.54167,0.84375,0.58333,0.84375,0.625,0.84375,0.66667,0.84375,0.70833,0.84375,0.75,0.84375,0.79167,0.84375,0.83333,0.84375,0.875,0.84375,0.91667,0.84375,0.95833,0.84375,0.99609,0.84375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.00391,0.875,0.04167,0.875,0.08333,0.875,0.125,0.875,0.16667,0.875,0.20833,0.875,0.25,0.875,0.29167,0.875,0.33333,0.875,0.375,0.875,0.41667,0.875,0.45833,0.875,0.5,0.875,0.54167,0.875,0.58333,0.875,0.625,0.875,0.66667,0.875,0.70833,0.875,0.75,0.875,0.79167,0.875,0.83333,0.875,0.875,0.875,0.91667,0.875,0.95833,0.875,0.99609,0.875,0.00391,0.90625,0.04167,0.90625,0.08333,0.90625,0.125,0.90625,0.16667,0.90625,0.20833,0.90625,0.25,0.90625,0.29167,0.90625,0.33333,0.90625,0.375,0.90625,0.41667,0.90625,0.45833,0.90625,0.5,0.90625,0.54167,0.90625,0.58333,0.90625,0.625,0.90625,0.66667,0.90625,0.70833,0.90625,0.75,0.90625,0.79167,0.90625,0.83333,0.90625,0.875,0.90625,0.91667,0.90625,0.95833,0.90625,0.99609,0.90625,0.00391,0.9375,0.04167,0.9375,0.08333,0.9375,0.125,0.9375,0.16667,0.9375,0.20833,0.9375,0.25,0.9375,0.29167,0.9375,0.33333,0.9375,0.375,0.9375,0.41667,0.9375,0.45833,0.9375,0.5,0.9375,0.54167,0.9375,0.58333,0.9375,0.625,0.9375,0.66667,0.9375,0.70833,0.9375,0.75,0.9375,0.79167,0.9375,0.83333,0.9375,0.875,0.9375,0.91667,0.9375,0.95833,0.9375,0.99609,0.9375,0.00391,0.96875,0.04167,0.96875,0.08333,0.96875,0.125,0.96875,0.16667,0.96875,0.20833,0.96875,0.25,0.96875,0.29167,0.96875,0.33333,0.96875,0.375,0.96875,0.41667,0.96875,0.45833,0.96875,0.5,0.96875,0.54167,0.96875,0.58333,0.96875,0.625,0.96875,0.66667,0.96875,0.70833,0.96875,0.75,0.96875,0.79167,0.96875,0.83333,0.96875,0.875,0.96875,0.91667,0.96875,0.95833,0.96875,0.99609,0.96875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.99609,0.04167,0.99609,0.08333,0.99609,0.125,0.99609,0.16667,0.99609,0.20833,0.99609,0.25,0.99609,0.29167,0.99609,0.33333,0.99609,0.375,0.99609,0.41667,0.99609,0.45833,0.99609,0.5,0.99609,0.54167,0.99609,0.58333,0.99609,0.625,0.99609,0.66667,0.99609,0.70833,0.99609,0.75,0.99609,0.79167,0.99609,0.83333,0.99609,0.875,0.99609,0.91667,0.99609,0.95833,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 825 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 1650 total numbers made up of 825 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD012 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD012().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD012\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD012 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD012_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD012_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD012_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD012_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
