package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD011Index.html" target="_blank">SquawLOD011</a>,  source <a href="../../../Geospatial/SquawLOD011.java">SquawLOD011.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD011.x3d">SquawLOD011.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD011.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD011.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD011
{
	/** Default constructor to create this object. */
	public SquawLOD011 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD011.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD011.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD011.x3d"))
    .addChild(new GeoLOD().setCenter(4344125.917539,739385.999947,2158.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw005.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw005.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4343332.077840,738776.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(51).setXSpacing(24.360000).setZDimension(67).setZSpacing(24.444444).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2276.0427,2270.292,2258.6348,2245.728,2244.088,2248.3132,2250.8193,2252.3733,2251.0454,2248.3853,2243.4033,2237.4587,2231.0706,2225.7253,2223.33,2223.5066,2228.098,2233.3306,2236.8147,2238.5,2236.6467,2233.588,2227.5674,2221.3494,2214.8748,2208.5334,2202.198,2196.1895,2189.8093,2183.3347,2173.2266,2161.9507,2145.6548,2130.0386,2115.4226,2100.2466,2089.6814,2085.568,2083.9653,2079.088,2073.28,2060.2974,2041.7706,2025.8,2014.8973,2005.7533,1996.432,1988.1587,1986.9326,1989.0,1987.8167,2286.295,2278.391,2267.475,2258.6414,2259.1484,2261.2861,2262.3,2262.335,2262.335,2260.0178,2254.5986,2247.5747,2239.739,2234.399,2232.931,2230.7512,2236.6255,2242.759,2245.7512,2246.5781,2245.315,2241.1567,2234.0752,2226.7673,2218.8755,2211.9512,2204.5315,2201.0234,2194.6436,2185.8079,2174.842,2162.104,2147.488,2131.0542,2116.912,2105.5813,2101.5066,2100.0706,2096.1829,2089.7126,2080.0513,2067.1116,2051.1816,2039.123,2026.7999,2015.655,2004.3472,1996.0458,1998.791};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2002.0586,1999.1934,2297.4229,2290.0957,2277.5303,2272.0437,2272.0933,2273.0498,2273.0498,2272.6877,2271.2517,2269.8037,2266.0464,2257.6467,2249.4338,2243.1038,2241.6357,2241.0398,2244.875,2251.4568,2254.0298,2255.0298,2256.0298,2253.2148,2243.4917,2234.4062,2227.5117,2221.6497,2215.1516,2207.8323,2198.9927,2188.29,2175.726,2161.1301,2148.523,2134.9355,2125.8215,2121.5042,2118.0676,2114.1914,2109.3137,2099.5366,2087.3398,2074.3457,2064.6018,2050.7903,2038.6198,2025.4398,2013.6123,2006.2399,2011.7338,2013.3857,2009.8497,2308.933,2299.3645,2289.3958,2283.1306,2284.1807,2284.1807,2283.7446,2282.3926,2279.9565,2276.8604,2271.7007,2265.0205,2257.1487,2252.7947,2251.7446,2252.111,2254.74,2257.1482,2258.6487,2261.8926,2263.7446,2262.7942,2258.0078,2248.1772,2239.4277,2234.3296,2230.0676,2219.7488,2205.1978,2192.1768,2180.4084,2169.4004,2159.8608,2150.989,2142.8052,2136.6887,2130.7544,2125.8806,2121.0085,2112.9648,2099.7266,2087.3716,2077.7327,2066.281,2048.9858,2034.2246,2022.3206};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2017.4089,2025.6359,2025.8911,2021.9807,2320.6575,2308.6318,2300.058,2297.174,2296.4495,2295.8318,2293.5334,2292.1458,2289.011,2281.4143,2275.8823,2269.5327,2263.6606,2259.7566,2258.7246,2258.7246,2259.7246,2259.8623,2260.903,2265.5269,2268.0173,2269.7246,2268.5872,2262.328,2256.541,2248.464,2239.993,2228.3547,2214.4553,2199.737,2187.687,2178.1392,2171.0137,2164.3425,2157.9226,2149.6318,2142.3237,2135.5854,2131.6953,2123.4956,2113.7136,2100.5693,2087.8616,2075.4302,2058.7817,2042.998,2032.6885,2029.4911,2035.2396,2037.358,2033.8016,2337.6624,2321.4988,2313.6382,2308.3708,2306.5332,2305.3,2300.252,2294.719,2288.7703,2280.751,2275.1028,2270.5195,2266.0896,2263.7434,2263.0,2262.8862,2263.5151,2263.0,2263.7114,2264.2954,2266.7314,2268.456,2271.8608,2270.443,2266.5056,2258.9194,2247.1086,2231.9285,2220.2566,2204.6406,2194.9878,2185.6016,2177.821,2172.2012,2166.458,2159.457,2150.8816,2143.9927,2137.5906,2131.361,2120.0906,2105.521,2091.7932,2079.0486,2064.7798};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2054.6829,2045.7302,2040.6713,2047.2559,2047.9131,2041.8253,2343.556,2330.7495,2320.7905,2313.4988,2307.9246,2303.2673,2295.8464,2288.7998,2282.055,2275.3438,2270.2505,2267.4058,2263.8867,2261.3264,2259.8591,2260.2852,2260.2852,2260.2852,2260.5706,2261.8691,2264.3052,2267.0671,2270.1465,2274.2344,2272.1375,2261.5718,2247.9238,2233.568,2220.605,2205.352,2198.1316,2190.4507,2181.9587,2175.5618,2170.4314,2163.0347,2155.4426,2147.4187,2140.3584,2134.088,2124.0146,2109.7847,2097.5217,2083.2239,2073.407,2065.1562,2055.588,2051.7998,2053.2092,2052.7656,2049.101,2341.6113,2331.1418,2321.1711,2312.2861,2305.445,2296.5837,2287.7722,2280.3801,2273.1833,2267.988,2263.1162,2260.3538,2258.12,2256.7456,2256.23,2255.5771,2255.616,2255.718,2256.739,2258.302,2260.741,2264.2383,2268.7358,2274.0461,2270.629,2259.2925,2246.679,2232.499,2219.319,2205.2722,2199.24,2192.6929,2183.992,2177.033,2171.752,2164.76,2156.016,2148.643,2141.3774,2135.088,2125.4043,2114.437,2104.222};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {2092.1829,2081.9026,2073.5332,2064.14,2060.6309,2059.4229,2058.7114,2055.223,2338.618,2327.9216,2318.6704,2307.656,2298.1226,2287.3313,2277.0198,2269.3079,2263.3674,2258.2834,2253.7856,2252.2024,2250.9968,2250.2986,2249.0693,2247.822,2247.7314,2247.7314,2249.8794,2252.6465,2255.8857,2259.2104,2265.5417,2270.4329,2263.943,2252.2656,2243.889,2229.4746,2216.3848,2204.1921,2199.0244,2192.9849,2183.244,2177.234,2171.752,2164.76,2156.016,2146.95,2140.321,2134.5208,2125.473,2115.372,2106.332,2096.8145,2087.1982,2078.409,2070.7012,2067.2244,2066.0356,2064.4702,2061.9343,2333.7654,2324.7986,2317.141,2303.3586,2291.7932,2278.6199,2266.4465,2258.9705,2253.4504,2249.572,2246.3599,2244.026,2243.02,2242.052,2241.02,2240.02,2239.02,2239.0247,2240.316,2243.6077,2247.0667,2251.9348,2258.6958,2262.3794,2253.9722,2245.42,2236.4783,2224.6533,2211.9653,2203.1187,2197.8625,2191.7415,2182.501,2176.626,2171.752,2163.7637,2155.016,2144.7107,2137.4026,2130.7974,2122.0466};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {2113.3027,2105.1665,2097.856,2090.0574,2082.2334,2075.2747,2071.9868,2071.985,2071.3162,2067.7808,2330.7754,2322.6365,2313.3008,2300.5405,2288.3604,2275.9019,2263.0356,2250.9573,2243.1653,2239.0977,2237.045,2236.266,2235.7412,2234.7546,2233.7412,2232.9014,2231.7412,2231.3218,2232.4697,2234.9058,2237.773,2241.3582,2245.312,2245.8267,2240.6948,2235.7217,2227.7778,2217.3813,2206.9224,2200.6924,2195.661,2189.1323,2181.9302,2175.8052,2170.576,2162.085,2151.6003,2141.1033,2133.557,2125.6528,2117.201,2109.6045,2103.3564,2097.904,2091.548,2085.546,2081.6326,2080.346,2079.0308,2076.5947,2073.6812,2329.4822,2319.5876,2309.3208,2297.1748,2285.9343,2273.7542,2261.4329,2249.24,2238.9695,2230.0146,2226.9045,2226.713,2227.617,2227.4675,2226.4626,2225.4873,2224.4626,2223.4626,2223.617,2225.201,2227.7913,2230.227,2232.5256,2232.7205,2230.853,2224.1711,2217.4011,2208.39,2201.3684,2196.4204,2191.227,2185.5505,2179.6501,2173.8264,2168.6582,2158.9143,2147.3252,2137.0125,2128.7043};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {2121.0925,2113.0884,2105.6533,2099.4724,2095.2124,2090.2659,2086.9258,2086.9927,2087.5374,2085.5374,2083.0276,2080.3528,2327.3955,2315.048,2304.768,2293.688,2282.552,2272.4585,2261.148,2249.0637,2237.848,2228.043,2218.748,2218.254,2218.912,2218.912,2218.912,2217.912,2216.912,2215.912,2214.8044,2214.912,2215.912,2216.912,2218.2896,2217.312,2215.8762,2212.5122,2207.0042,2199.768,2193.6602,2189.2961,2184.8042,2180.774,2175.9521,2171.267,2163.722,2153.9763,2142.4722,2132.728,2124.616,2116.816,2109.307,2102.152,2094.62,2088.0532,2084.5876,2086.8982,2092.453,2094.5513,2093.8599,2091.4238,2087.9607,2323.044,2310.844,2300.6138,2290.8699,2281.1125,2270.3818,2258.7805,2247.8938,2237.06,2226.4058,2217.02,2210.8096,2209.2073,2209.2073,2209.2073,2208.9539,2208.124,2206.9924,2205.2073,2205.7913,2206.2073,2206.2073,2205.509,2205.1812,2203.6738,2201.411,2196.6812,2190.7615,2185.8894,2181.3193,2176.7126,2173.145,2170.1758,2164.6235,2158.145,2147.4963,2138.6157};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {2128.8757,2119.9998,2113.39,2106.0818,2098.774,2090.0386,2083.2202,2081.786,2085.7842,2092.2625,2097.7292,2100.3276,2099.894,2097.8643,2318.9185,2305.4268,2297.1875,2287.5193,2278.694,2267.896,2256.2957,2244.4675,2234.599,2224.6592,2215.1113,2205.6836,2201.7432,2199.6548,2199.4521,2198.398,2197.1365,2195.7546,2195.2485,2194.43,2194.3782,2193.9788,2193.5024,2193.3782,2192.7092,2190.1274,2186.8665,2182.3674,2177.6108,2172.6213,2167.1226,2163.6865,2161.3435,2157.1265,2150.255,2142.0713,2134.6394,2125.0232,2117.1396,2110.9636,2102.8833,2095.0474,2085.3794,2078.6553,2076.1108,2084.4312,2090.9878,2097.766,2104.684,2107.6672,2105.173,2315.511,2304.056,2295.312,2286.0173,2275.2734,2264.7632,2253.8694,2241.0415,2230.7468,2221.1262,2212.1729,2204.1614,2196.8535,2191.4155,2188.843,2186.8696,2186.123,2184.927,2184.247,2183.7976,2183.7866,2183.247,2182.3066,2182.0996,2181.377,2180.238,2177.3252,2173.6536,2169.3323,2162.9656,2157.0376,2153.4312,2152.5457,2148.8005,2143.0444};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {2136.4165,2129.4592,2121.4087,2114.8455,2108.37,2099.822,2090.1948,2081.6135,2074.7812,2071.2,2079.543,2088.5173,2095.275,2101.5828,2107.378,2110.3506,2314.7522,2304.056,2295.312,2284.96,2274.824,2263.611,2252.338,2240.2483,2229.848,2219.346,2211.3752,2203.712,2195.8843,2188.128,2180.2478,2178.2065,2176.0864,2175.0928,2173.9482,2172.532,2172.116,2172.0928,2171.116,2171.0928,2171.839,2169.8928,2166.8357,2163.0425,2159.077,2155.1829,2148.9297,2143.2493,2143.8235,2141.3816,2136.8188,2130.9368,2125.0583,2118.7273,2111.4395,2105.1274,2096.8032,2085.5144,2077.2104,2070.975,2069.0344,2074.826,2084.1145,2090.4224,2096.5024,2101.3977,2105.1904,2314.7522,2304.056,2294.312,2284.568,2274.8062,2263.6,2251.823,2240.592,2229.848,2220.731,2212.626,2205.614,2199.613,2190.934,2181.8342,2175.286,2168.7532,2164.2183,2161.0908,2159.2334,2159.985,2160.169,2160.388,2159.985,2158.7722,2156.7852,2154.349,2152.3162,2149.8801,2146.8804,2142.031,2136.756,2135.791};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {2134.9167,2130.996,2126.5625,2121.2021,2112.898,2106.458,2100.586,2092.4941,2081.49,2072.358,2066.647,2063.47,2069.5833,2076.8591,2084.2913,2088.844,2092.584,2094.8508,2314.7522,2305.056,2294.312,2284.568,2274.78,2264.08,2253.4058,2243.2505,2231.853,2223.8005,2216.3384,2211.546,2206.5034,2197.6155,2188.8716,2180.9675,2171.4307,2160.738,2153.336,2144.9539,2147.6868,2149.2322,2149.6833,2147.854,2146.09,2144.4832,2143.0474,2140.854,2140.2593,2138.522,2135.5815,2130.7097,2128.5125,2127.8245,2125.3672,2121.7817,2114.5244,2107.0457,2102.583,2096.4814,2087.426,2076.6377,2067.5056,2060.2456,2057.9082,2063.3389,2069.2244,2073.575,2078.481,2082.4045,2085.8662,2317.0076,2306.508,2295.5674,2285.3706,2276.0906,2266.5908,2256.6128,2248.4548,2239.6143,2230.1514,2223.9548,2218.5742,2212.1702,2204.862,2196.1501,2187.4062,2178.5918,2167.9182,2158.174,2146.3872,2138.4739,2137.4678,2137.7231,2137.4788,2137.234,2136.085,2133.7065,2129.197,2128.5974,2128.7231,2127.3154};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {2123.6018,2118.3538,2120.6433,2118.475,2113.186,2107.2449,2101.3699,2096.7532,2091.5771,2083.3357,2072.7852,2063.7522,2054.3208,2050.0781,2056.4438,2060.9458,2064.7705,2067.69,2071.5618,2077.2039,2318.2832,2307.32,2297.4292,2288.664,2280.2173,2271.443,2261.6992,2253.9888,2246.1438,2238.3728,2231.833,2225.7568,2218.4487,2211.1409,2203.4287,2194.6848,2184.2593,2174.4236,2164.7712,2153.6733,2140.9248,2129.9224,2122.4841,2120.6516,2122.1504,2124.3015,2123.6377,2120.1296,2116.2737,2116.592,2116.5305,2111.337,2105.2737,2105.9104,2106.5525,2103.8352,2099.2817,2095.0913,2090.901,2086.7249,2078.6768,2068.9329,2060.0652,2049.4775,2043.3069,2046.1136,2050.304,2055.176,2059.4111,2064.2832,2069.2234,2317.6445,2307.056,2298.484,2291.2415,2283.9758,2276.2957,2266.5515,2259.1975,2252.0635,2244.5437,2237.3066,2231.83,2224.6196,2217.3115,2209.5354,2200.8555,2191.343,2178.3364,2169.6235,2158.8167,2148.1177,2135.1511,2122.875,2108.161,2105.1682,2107.6455,2110.4219,2109.389,2105.6077};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {2104.461,2104.081,2100.025,2093.705,2091.9333,2096.0432,2094.246,2090.469,2087.1367,2084.8086,2082.1765,2074.984,2067.2073,2057.486,2046.6522,2035.3846,2035.6052,2040.2424,2044.0675,2047.9417,2055.5247,2062.8767,2314.317,2305.381,2298.0417,2291.784,2285.868,2280.094,2271.8308,2264.546,2256.916,2249.396,2242.088,2235.876,2229.756,2222.1812,2213.6401,2205.0994,2196.5774,2182.2815,2173.021,2162.4202,2151.9973,2142.5344,2130.608,2114.1309,2096.4321,2094.225,2097.5,2098.8306,2096.314,2091.8818,2090.796,2086.814,2080.04,2075.262,2078.4521,2080.057,2078.8,2077.33,2077.864,2077.4863,2073.52,2065.856,2056.733,2045.2036,2033.2896,2027.0294,2029.042,2032.9141,2037.548,2044.856,2052.6301,2308.4832,2301.8716,2294.6958,2289.8237,2285.912,2281.501,2275.2122,2269.2024,2261.5564,2253.288,2246.614,2239.7644,2234.3455,2227.0483,2217.3442,2207.6,2199.132,2187.9363,2175.374,2165.601,2154.8801,2146.1362,2132.6438,2116.691,2097.8787,2091.616,2088.1448};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {2087.199,2085.1633,2079.311,2075.859,2072.6067,2067.4033,2061.5781,2064.482,2067.199,2067.1592,2068.1365,2070.8606,2074.0398,2071.5598,2065.472,2056.9246,2044.712,2032.064,2023.2798,2020.0938,2021.9512,2028.8033,2035.1512,2041.3632,2299.8306,2295.369,2289.8833,2286.246,2284.1562,2281.1335,2275.814,2270.296,2264.1526,2256.4146,2249.4065,2243.1943,2236.7903,2229.4824,2220.1743,2210.1245,2200.4517,2190.44,2178.26,2166.9192,2155.92,2145.9998,2132.648,2118.4768,2101.8113,2091.9092,2084.8687,2078.3257,2070.6074,2067.5881,2062.688,2060.025,2054.9255,2049.6458,2051.9297,2056.458,2058.453,2058.2727,2061.577,2066.7583,2067.3867,2064.3296,2057.1765,2045.0798,2031.58,2021.8845,2014.013,2012.3268,2020.1384,2025.7823,2031.268,2291.1257,2286.2776,2282.5454,2280.8806,2280.3308,2277.4148,2273.527,2268.9568,2263.4636,2256.3699,2249.2073,2243.9773,2237.404,2230.096,2221.384,2210.8,2200.3076,2190.44,2178.1396,2166.1895,2155.92,2145.176,2133.54,2122.111,2109.5188};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {2095.0251,2087.9045,2079.5247,2071.2886,2063.9912,2058.4326,2055.3713,2049.244,2045.312,2043.3981,2045.2272,2047.7456,2049.643,2051.7803,2059.4172,2063.1636,2062.0115,2057.2368,2047.4766,2031.9993,2021.24,2012.932,2008.208,2011.8735,2016.8901,2021.6809,2279.1077,2274.0952,2271.3953,2269.5671,2269.8164,2270.2837,2268.3677,2264.0864,2258.9463,2252.91,2244.9636,2238.9956,2232.6875,2225.3796,2218.0715,2209.363,2198.5913,2187.2012,2175.8176,2164.4253,2154.6812,2145.176,2135.432,2124.688,2112.4187,2099.2388,2089.6948,2081.0227,2072.5935,2066.3508,2060.8083,2058.5215,2052.9736,2046.9373,2041.0464,2035.2012,2036.2765,2039.3737,2041.8812,2047.9568,2055.0881,2057.953,2055.4446,2048.9988,2034.942,2022.8168,2013.3246,2006.6548,2003.4027,2007.5592,2012.1687,2268.0872,2260.1357,2257.5605,2256.675,2259.384,2260.675,2259.424,2256.653,2251.311,2241.779,2234.581,2230.0842,2223.744,2217.4253,2211.197,2204.5913,2194.0845,2183.822,2172.6445,2161.999,2152.255,2143.511,2135.36};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {2125.36,2114.18,2102.197,2091.757,2083.4248,2074.806,2070.386,2067.615,2063.514,2058.574,2051.266,2044.834,2036.5026,2032.0067,2030.34,2032.208,2037.3538,2044.8949,2050.181,2050.8,2049.143,2037.9019,2027.0382,2017.241,2009.081,2000.8293,1996.5574,1999.7749,2267.3774,2255.32,2244.458,2243.6353,2246.588,2248.4966,2247.6204,2243.7488,2237.8767,2229.1667,2222.624,2217.443,2212.5227,2206.608,2202.7358,2196.1152,2187.5564,2178.8784,2168.2898,2157.4817,2148.7395,2140.955,2134.0435,2125.6267,2116.2498,2105.3823,2096.3325,2089.0576,2083.7192,2078.3857,2073.3877,2067.5505,2062.3352,2055.1184,2048.923,2041.5426,2034.1035,2024.7559,2021.8296,2026.5194,2034.5039,2040.9872,2044.2472,2043.4999,2036.3656,2028.3127,2020.9645,2013.6174,2006.4736,1998.007,1994.1642,2266.7522,2255.32,2242.312,2233.9172,2234.457,2234.4155,2231.9795,2228.5435,2223.9392,2217.857,2213.1277,2208.1565,2200.2996,2193.4924,2190.605,2184.81,2177.9343,2169.7944,2161.2668,2152.1118,2143.9053};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {2137.3347,2130.7507,2124.6682,2117.3394,2108.9175,2101.6094,2094.3386,2088.5015,2084.118,2077.3774,2071.4917,2064.7615,2058.292,2052.2695,2046.8569,2038.0508,2028.0984,2020.3625,2019.1119,2023.2849,2029.8499,2035.0249,2034.365,2030.4618,2026.0837,2021.9548,2017.8258,2014.1794,2008.5834,1999.8662,2265.791,2254.3765,2241.1963,2229.6243,2218.4927,2220.3113,2216.5579,2212.6907,2206.875,2205.3257,2203.2827,2194.096,2187.6594,2182.346,2178.4175,2172.753,2166.4539,2160.0896,2153.5854,2145.4172,2139.0527,2133.175,2128.2725,2123.4004,2117.708,2110.4,2103.0562,2096.7275,2089.984,2085.112,2078.86,2072.598,2066.1875,2059.5852,2053.752,2049.8237,2043.847,2035.4785,2026.3025,2018.6663,2013.2526,2016.6903,2019.9503,2020.3383,2019.311,2017.3619,2016.2054,2016.1128,2016.2587,2014.2422,2008.4365,2263.0706,2251.8525,2239.2483,2227.568,2216.7034,2205.8633,2200.6104,2194.8552,2190.7327,2192.4333,2189.0154,2181.5286,2175.087,2170.2148,2165.5974,2161.101,2156.3386,2151.4666,2145.5012};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {2139.3545,2133.838,2129.3484,2124.8062,2121.6042,2116.1023,2110.0303,2101.8567,2095.441,2089.984,2085.112,2078.4902,2072.484,2065.244,2059.2542,2054.876,2051.44,2048.3762,2042.0739,2036.0868,2024.4548,2013.2456,2010.0,2010.0,2009.6301,2007.0486,2004.7811,2005.6746,2009.2358,2011.9749,2013.2604,2010.3302,2262.988,2250.852,2238.9712,2227.568,2216.727,2201.12,2186.7263,2180.8718,2178.2239,2178.0457,2173.9731,2168.7515,2162.9558,2157.0903,2153.0903,2150.8486,2148.1162,2143.9587,2138.316,2132.4438,2128.368,2123.5889,2120.5159,2117.615,2113.676,2107.604,2099.7898,2093.8706,2088.984,2083.3606,2077.064,2070.572,2064.244,2058.3757,2054.7773,2051.44,2049.004,2043.704,2038.0869,2030.822,2022.0702,2013.9039,2010.796,2010.448,2004.5253,1998.7521,1996.7639,1998.5656,2002.0905,2004.8159,2003.6752,2263.2874,2253.4836,2242.4004,2230.8774,2217.736,2203.12,2187.0137,2171.1619,2162.9626,2161.2703,2159.6667,2155.6968,2149.7068,2143.422,2141.4849,2140.889,2139.0574};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {2135.687,2131.0374,2126.1653,2121.3132,2117.8774,2114.7476,2112.823,2109.7915,2106.2222,2098.375,2092.856,2087.476,2082.112,2075.6377,2069.368,2064.244,2058.3813,2053.752,2049.2178,2046.3383,2041.4515,2037.7169,2031.6436,2025.2977,2018.648,2014.388,2012.9626,2011.9604,2006.1289,1998.7324,1995.0782,1993.9396,1995.2587,1995.211,2258.6729,2252.6663,2245.4236,2233.8223,2217.7075,2202.7827,2188.504,2173.1843,2156.1975,2147.534,2145.4495,2142.946,2138.8518,2134.13,2130.6506,2130.4062,2130.661,2126.9824,2123.7588,2118.8867,2114.0217,2110.5986,2108.4763,2106.7268,2104.9392,2102.4329,2098.728,2093.8306,2087.8054,2082.7605,2076.1064,2070.0164,2064.496,2059.624,2053.628,2047.6831,2040.0679,2035.8224,2031.7559,2025.6914,2021.5747,2015.755,2012.3428,2010.0547,2012.1871,2011.16,2002.5804,1995.2725,1986.7043,1987.7188,1988.5383,2247.6165,2242.8162,2240.1238,2230.0535,2213.5122,2199.4507,2186.28,2173.0908,2158.1973,2143.1619,2134.5068,2131.5984,2128.1694,2124.7334,2121.15};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {2121.7014,2120.4255,2117.9895,2114.4165,2110.1484,2105.6614,2102.2456,2099.876,2099.398,2098.7761,2098.8508,2097.2893,2093.7815,2088.9473,2084.1824,2077.86,2071.552,2064.4214,2059.498,2052.6775,2047.2454,2037.0197,2029.5547,2022.1246,2017.1681,2013.2214,2008.0857,2001.4485,1998.7458,2002.5925,2006.6215,2002.24,1996.5493,1987.088,1979.4236,1976.6014,2231.7146,2228.1272,2226.565,2217.6506,2203.276,2191.8362,2180.3328,2167.9138,2156.453,2143.88,2131.7,2121.4016,2118.4336,2115.0447,2112.9966,2113.077,2111.3594,2109.2847,2105.7007,2100.8286,2095.4658,2092.5408,2090.9966,2090.9966,2090.9966,2091.097,2090.9966,2088.9263,2086.9912,2085.0278,2077.3591,2069.6426,2061.2424,2054.778,2049.7502,2043.0371,2035.0104,2025.7024,2017.961,2010.3904,2004.2775,1997.6464,1995.5002,1992.2622,1985.979,1992.1678,1996.638,1992.1212,1985.9725,1974.8431,1971.5009,2215.8367,2213.5107,2209.0417,2200.0059,2191.1887,2180.927,2169.634,2160.8108,2151.067,2141.9692,2130.773,2119.712,2111.5889};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {2106.283,2104.292,2103.525,2101.3447,2099.5798,2095.9958,2090.2273,2085.2534,2081.8691,2081.292,2081.292,2082.2747,2082.4773,2082.6294,2082.152,2080.784,2078.279,2073.0059,2062.9683,2054.2292,2047.2051,2039.9418,2031.6848,2025.3768,2020.85,2013.542,2007.1831,2000.539,2002.0645,2007.3596,2006.3488,1995.88,1984.9282,1983.0779,1984.9531,1981.713,1978.7327,1981.6549,2200.2568,2196.7913,2192.1833,2185.9182,2179.0735,2169.667,2160.8687,2151.179,2143.2231,2135.8494,2127.6536,2119.582,2110.404,2100.7747,2094.7976,2092.6904,2091.311,2088.5217,2082.9377,2078.2722,2074.56,2071.5872,2070.5872,2071.915,2073.857,2074.9402,2073.7156,2071.8086,2069.348,2066.5833,2060.7405,2052.9048,2045.3148,2036.28,2026.516,2021.3802,2018.2975,2013.9353,2010.4852,2008.7557,2011.0625,2018.1182,2020.5153,2018.6052,2007.9734,1995.4597,1986.578,1985.9862,1986.1403,1987.3115,1993.9662,2194.2283,2182.3064,2177.5383,2172.8867,2166.4023,2159.9312,2151.2183,2142.3313,2133.3445,2127.3848,2122.196};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {2115.4272,2108.6245,2099.135,2089.2896,2082.1316,2078.2124,2073.8955,2070.1428,2066.5188,2063.0828,2061.1028,2060.8823,2061.1028,2061.2712,2061.1675,2058.272,2054.472,2051.2566,2047.8329,2044.164,2039.7319,2032.5674,2024.1991,2018.3865,2018.7794,2019.336,2018.243,2018.1178,2019.4381,2025.3198,2029.2937,2030.1178,2025.5769,2012.7616,2001.0995,1995.2598,1996.0719,1998.075,1999.5612,2006.1752,2201.0571,2186.3499,2171.5159,2158.6487,2153.233,2147.0117,2140.9514,2134.3271,2127.2246,2120.9167,2114.9973,2110.0051,2103.3645,2096.479,2087.3767,2076.3887,2065.279,2058.8767,2058.2656,2057.5886,2055.5847,2052.4712,2048.491,2048.6436,2049.3345,2048.7363,2042.7274,2037.6517,2034.7739,2033.3947,2029.0375,2022.7133,2020.5424,2019.3472,2021.5353,2023.2921,2025.8186,2028.1171,2029.1018,2031.7793,2035.9982,2037.4113,2036.4678,2026.76,2013.1956,2004.6348,2003.1786,2004.7798,2007.026,2010.4866,2015.002,2207.7039,2195.3127,2180.3232,2165.4873,2154.6316,2142.5205,2131.589,2127.1619,2122.1604};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {2116.0642,2109.3882,2101.8518,2096.213,2089.844,2081.865,2071.2751,2061.172,2057.8955,2057.8955,2057.8955,2056.2363,2051.3516,2046.8081,2043.2174,2042.2535,2039.2627,2034.5317,2035.2637,2035.8955,2035.2637,2031.8676,2027.159,2025.1592,2025.4125,2028.0979,2031.8093,2035.5233,2038.9594,2041.0758,2042.6393,2042.428,2040.7128,2035.7574,2025.1282,2013.064,2009.2637,2011.6196,2012.8955,2014.4712,2019.6431,2024.2592,2209.7522,2199.0713,2187.0361,2174.0762,2161.9402,2149.8042,2135.683,2123.6672,2116.3782,2110.167,2103.8843,2096.596,2089.8472,2083.0361,2074.8928,2072.2322,2073.2322,2072.5203,2070.9448,2066.1223,2063.134,2058.2356,2051.498,2046.4021,2043.1161,2043.1858,2043.2322,2044.3042,2045.2617,2045.2355,2043.9102,2042.4742,2040.0382,2037.3483,2038.4142,2040.7921,2044.1702,2047.5481,2048.9336,2049.058,2046.477,2039.3661,2031.4359,2022.7527,2014.5741,2014.1694,2017.4928,2020.7582,2024.4021,2027.5216,2033.4741,2209.601,2199.1921,2189.2234,2177.6465,2166.7712,2155.8367,2142.432};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {2128.3408,2116.3323,2106.111,2097.5469,2092.1812,2084.9675,2081.986,2082.6484,2083.3438,2083.4211,2082.937,2080.789,2076.769,2070.403,2064.3198,2057.3481,2050.1433,2049.307,2053.1055,2055.2334,2056.4211,2056.1753,2055.937,2055.4211,2054.6052,2053.6536,2051.2175,2050.361,2050.4526,2050.9663,2051.1914,2051.4841,2050.2117,2044.5558,2035.3275,2025.7714,2020.443,2018.2346,2019.8885,2023.4968,2027.144,2031.9087,2035.9435,2041.1886,2206.8418,2197.8816,2188.4016,2177.96,2166.9097,2156.6895,2144.42,2133.2085,2119.9705,2106.656,2094.68,2089.8804,2088.2158,2091.4016,2094.8667,2095.5522,2094.301,2091.9937,2090.494,2086.5632,2079.474,2070.4043,2061.3328,2058.4182,2062.1013,2064.8418,2067.1882,2067.6418,2067.5522,2067.5522,2067.5522,2066.7197,2065.6191,2063.8643,2061.4395,2058.1714,2056.8245,2055.4275,2053.0542,2049.392,2042.0632,2032.7218,2025.0745,2021.7772,2021.3944,2025.5785,2029.4434,2034.3153,2039.1874,2044.0593,2050.0225,2204.4155,2195.2075,2184.9753,2174.8948,2164.4727};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {2153.9268,2142.691,2131.6853,2120.5828,2106.3567,2093.68,2093.8015,2098.0576,2104.5872,2109.0872,2109.8433,2106.744,2104.3079,2100.822,2096.5945,2087.923,2077.0325,2067.961,2067.557,2072.6174,2075.4792,2076.9827,2078.3467,2078.3467,2078.3467,2078.3467,2077.3467,2076.3467,2074.6587,2072.886,2068.8552,2062.3586,2058.5278,2055.6006,2049.1904,2043.1167,2035.8679,2030.0433,2025.6252,2025.8151,2030.823,2035.3853,2040.2573,2045.6172,2051.2249,2057.31,2201.3013,2192.2932,2182.549,2171.1973,2161.061,2150.8372,2138.6572,2127.0664,2116.5342,2104.0771,2095.5034,2100.5537,2108.2903,2116.7183,2121.314,2122.8142,2120.473,2116.559,2112.7554,2105.854,2094.4058,2081.3748,2071.7417,2076.7075,2081.5793,2084.2515,2085.9246,2088.0515,2089.0515,2088.8142,2088.724,2087.8142,2085.7993,2083.6006,2081.0405,2076.3013,2071.0613,2064.095,2058.0269,2051.1548,2045.2828,2039.4109,2035.3018,2031.2886,2032.0098,2036.3657,2040.3904,2045.7139,2051.1555,2057.3604,2064.6648,2196.998,2190.4138,2182.312};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {2170.96,2160.824,2150.5017,2138.42,2124.6025,2111.083,2103.1462,2101.698,2108.8733,2118.7837,2126.4712,2131.5642,2134.4375,2133.0674,2127.62,2120.9622,2111.9316,2096.8838,2084.632,2082.27,2086.2231,2089.4756,2092.767,2095.3235,2097.5945,2099.4534,2100.8892,2100.756,2099.756,2097.0632,2092.1912,2087.319,2082.3413,2076.3862,2068.5427,2060.61,2053.277,2046.52,2041.837,2037.9651,2035.1981,2036.862,2040.283,2044.901,2049.9622,2056.019,2063.0342,2071.6782,2190.8423,2186.8518,2180.6968,2170.1938,2160.824,2149.7847,2138.42,2125.7527,2110.272,2103.0515,2106.8044,2116.882,2126.1538,2133.7498,2140.9023,2144.461,2141.0178,2134.4792,2125.6956,2114.1367,2097.503,2084.9126,2088.5217,2094.3755,2097.519,2100.1687,2103.4817,2106.605,2110.1646,2111.8242,2111.081,2108.959,2104.3418,2099.4697,2093.8584,2087.5505,2080.2424,2072.6687,2064.0925,2055.3992,2047.2354,2043.4392,2041.6185,2040.8643,2041.7145,2045.0706,2048.3271,2053.1992,2059.2993,2067.2712,2076.7537,2181.1047};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {2182.0566,2176.1948,2168.093,2159.7385,2148.0386,2137.2944,2124.1985,2109.2305,2104.531,2111.397,2122.471,2132.2302,2140.0283,2146.4456,2148.0066,2144.202,2135.864,2126.408,2113.2866,2097.9216,2094.5579,2098.9084,2102.8083,2105.8884,2108.3245,2111.7605,2115.2683,2119.1194,2121.0415,2121.0415,2118.4849,2112.6099,2106.0188,2098.6694,2091.3616,2085.008,2075.7454,2065.7375,2057.1006,2050.603,2047.0756,2045.4548,2045.1309,2046.5469,2048.8848,2051.795,2056.6255,2061.9854,2070.0334,2080.5415,2168.9736,2170.6616,2167.7854,2162.0574,2155.377,2144.4214,2133.4846,2121.4692,2108.585,2110.438,2117.7344,2128.3193,2137.78,2145.3867,2148.8716,2149.0747,2144.896,2134.44,2125.408,2111.1335,2101.86,2103.037,2107.6545,2111.4167,2113.2773,2116.1353,2119.039,2121.9736,2123.9353,2124.4678,2123.4678,2122.5657,2117.7117,2109.4036,2102.0957,2094.7876,2086.4817,2077.7397,2068.9956,2059.3274,2055.4553,2051.7593,2049.9353,2049.9834,2050.9353,2052.8552,2054.9902,2059.0518,2065.1516,2072.3025};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {2082.4,2157.4246,2158.2666,2158.2524,2154.2085,2147.1865,2138.8274,2128.6323,2118.119,2116.2798,2118.8232,2125.2515,2134.9797,2143.8594,2148.727,2151.255,2150.2861,2145.172,2135.9702,2125.2756,2111.434,2107.8257,2112.4875,2115.562,2118.3027,2120.6816,2122.8816,2124.4238,2125.8938,2127.348,2126.8938,2125.5542,2124.078,2120.138,2111.8298,2103.628,2097.2139,2087.016,2079.6582,2072.1978,2065.7695,2059.3862,2055.7178,2054.7878,2055.6868,2055.7878,2056.7878,2058.2498,2061.4778,2067.3499,2073.8857,2083.3,2155.5964,2148.473,2146.6028,2144.2373,2138.952,2132.766,2121.837,2119.7847,2122.7483,2126.4082,2132.8313,2141.3442,2148.8745,2153.5864,2155.6401,2152.9602,2145.9844,2138.4119,2130.0723,2118.6052,2117.3203,2121.4163,2123.8523,2125.9602,2127.724,2129.0962,2130.3926,2130.6401,2130.4775,2129.32,2126.8184,2124.184,2120.1633,2111.7158,2103.628,2097.0,2087.02,2081.136,2075.904,2071.8254,2064.917,2059.2004,2059.2522,2059.6729,2060.32,2060.32,2061.434,2064.904};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {2069.456,2074.992,2082.98,2156.694,2145.792,2141.1255,2137.2915,2132.706,2127.9456,2122.514,2125.0322,2129.2268,2132.854,2140.625,2148.455,2154.9536,2158.4604,2159.1912,2156.0662,2148.6646,2142.1416,2135.227,2126.2332,2125.2788,2128.6948,2131.1309,2132.7373,2134.4326,2135.2896,2135.4924,2135.4207,2133.2383,2130.8022,2127.5237,2123.368,2118.4338,2110.1897,2103.504,2095.4622,2088.7593,2084.0605,2079.7566,2075.1382,2070.0786,2064.9314,2062.6477,2062.7463,2062.7463,2062.7463,2063.8367,2066.383,2069.456,2074.0771,2081.5283,2154.526,2144.7466,2140.5132,2135.392,2130.9636,2128.865,2129.1724,2131.7576,2136.0935,2141.151,2147.665,2154.6165,2159.3171,2162.1404,2161.941,2159.4924,2153.5168,2146.921,2140.0735,2133.106,2133.7134,2136.69,2138.6711,2140.5173,2140.5173,2140.483,2140.2354,2139.1006,2135.7493,2132.2844,2128.24,2122.552,2117.115,2108.936,2103.6494,2097.2249,2092.1812,2087.4065,2082.4365,2076.512,2071.52,2067.648,2064.8945,2064.7795,2063.0,2064.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {2065.356,2066.792,2069.228,2073.1555,2079.2827,2152.7522,2145.1267,2140.656,2135.784,2132.5986,2133.1973,2133.796,2137.5,2142.372,2147.334,2153.3809,2158.428,2163.2612,2166.7449,2166.7935,2163.5173,2157.6453,2151.7734,2146.5,2144.3948,2145.0015,2146.252,2147.154,2147.796,2146.8906,2146.1172,2144.5613,2142.4978,2139.1814,2134.7107,2129.8386,2122.552,2116.9438,2110.5347,2105.3506,2100.4788,2095.6067,2089.476,2083.9155,2077.088,2071.077,2065.4507,2061.7893,2061.4014,2061.8853,2063.3213,2064.4014,2066.1099,2068.6294,2072.328,2077.6013,2154.0813,2147.5098,2141.656,2137.432,2137.0498,2138.5298,2140.9658,2144.7786,2149.6453,2154.5227,2159.3782,2164.1482,2168.1138,2170.9937,2171.6309,2169.2097,2163.2466,2156.6506,2154.9304,2154.085,2154.0747,2154.0747,2154.0747,2154.0664,2153.0557,2151.8547,2150.0588,2147.0027,2144.0464,2139.1619,2132.2803,2124.7812,2118.521,2112.649,2106.7769,2101.88,2097.008,2090.704,2084.264,2077.088,2069.2568,2060.5776,2057.935,2056.9983};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {2059.4343,2060.9731,2061.975,2062.97,2066.4062,2071.2783,2075.1726,2155.3013,2145.937,2141.9055,2140.902,2141.902,2143.382,2147.1853,2151.4128,2156.0457,2160.7002,2164.8599,2169.0942,2173.434,2175.3389,2175.2292,2173.0623,2168.7476,2163.7993,2162.3533,2162.3533,2162.3333,2161.3533,2161.3533,2160.3533,2159.3533,2158.1533,2156.266,2153.7905,2149.8862,2144.496,2137.0417,2129.0032,2120.695,2114.387,2108.1472,2102.32,2097.008,2089.9412,2083.8726,2076.088,2065.2517,2055.6665,2052.0347,2051.6467,2053.1309,2055.1519,2057.0027,2059.004,2061.554,2066.4258,2071.2979,2154.1487,2145.7017,2144.7546,2145.7546,2146.6758,2149.1707,2153.474,2157.4585,2162.3306,2166.8833,2170.9937,2176.7012,2180.1638,2180.7546,2180.3506,2177.8115,2173.1687,2170.6318,2170.6318,2169.6318,2169.6318,2168.6318,2167.8494,2167.304,2166.6318,2164.432,2162.1187,2159.6826,2156.6157,2150.7998,2142.2346,2132.5908,2123.8694,2115.2097,2108.628,2101.32,2095.1306,2087.8267,2081.5188,2073.248,2062.4546,2053.4187};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {2047.0476,2046.1287,2047.1821,2047.3682,2049.724,2051.9778,2055.7961,2060.5735,2065.3577,2157.4006,2153.135,2152.0825,2153.5186,2154.9104,2156.2449,2159.4644,2164.0657,2168.4863,2173.5825,2179.2305,2184.7322,2187.4424,2188.8882,2187.5063,2183.2305,2179.6907,2179.4146,2178.8074,2177.9104,2176.9104,2176.0754,2175.0186,2173.9104,2172.9104,2171.407,2168.971,2165.8167,2162.0989,2156.775,2146.4036,2136.0396,2124.74,2115.936,2106.628,2098.1501,2090.7085,2083.6602,2076.829,2069.3616,2059.9612,2053.472,2047.388,2043.9855,2044.3372,2044.3373,2044.9445,2046.4885,2050.849,2055.5195,2059.1895,2164.5234,2158.5244,2159.361,2160.797,2161.4915,2162.8096,2166.021,2170.1633,2175.7651,2181.0708,2187.169,2192.2852,2194.721,2196.4275,2195.35,2192.122,2189.6484,2188.9187,2187.8787,2187.0645,2185.6338,2184.4626,2183.0269,2180.9497,2179.425,2177.989,2174.6514,2171.368,2166.9353,2160.8826,2149.282,2137.6497,2127.1995,2118.0833,2109.8506,2101.27,2091.4753,2082.4512,2075.528,2069.0396};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {2061.2393,2055.154,2047.5057,2043.952,2042.2703,2041.2703,2041.8004,2043.0623,2046.5599,2050.2046,2052.5676,2169.7466,2166.4678,2166.6396,2167.4678,2168.4678,2168.9478,2171.2996,2176.4688,2182.0105,2187.7947,2193.6318,2198.4077,2200.9268,2202.4355,2202.0637,2200.7585,2199.5806,2198.6235,2197.6006,2196.6235,2195.4678,2194.0828,2192.7146,2191.2957,2189.0154,2185.3923,2181.1956,2177.1677,2171.7878,2162.4358,2152.695,2144.991,2136.8674,2128.398,2119.1274,2110.2278,2098.6436,2087.8955,2080.8638,2075.0688,2068.467,2060.6077,2051.3804,2045.0599,2040.521,2038.8441,2038.7438,2039.6882,2041.9163,2045.2487,2046.7726,2175.8105,2173.164,2173.7463,2174.0002,2174.1897,2175.4436,2178.0452,2182.4502,2188.199,2193.7427,2199.342,2203.3562,2206.6963,2208.164,2208.7463,2208.7463,2208.0488,2207.0342,2205.7463,2204.9885,2203.7263,2202.063,2200.7463,2199.027,2197.3015,2194.4626,2189.686,2183.5603,2175.3445,2165.8386,2156.7651,2151.5322,2145.303,2137.6824,2128.1262,2117.5063,2106.764,2096.7668};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {2086.6921,2079.3792,2072.6714,2063.8782,2054.4902,2046.904,2039.7637,2035.4979,2035.2107,2035.2969,2037.0638,2039.4999,2041.3119,2180.0166,2180.0166,2180.018,2180.025,2181.0166,2181.025,2182.941,2188.7207,2194.3823,2199.4666,2205.3367,2209.1125,2211.5486,2213.993,2215.025,2215.025,2215.025,2214.025,2213.025,2212.4375,2211.0051,2209.5688,2208.026,2206.0305,2204.261,2200.8232,2196.7446,2188.8,2179.9763,2169.3044,2162.8848,2157.3845,2150.2605,2142.9526,2134.5205,2123.2166,2113.0325,2102.8567,2091.8074,2081.784,2073.78,2064.472,2056.164,2047.9119,2041.548,2035.0807,2032.6357,2031.7623,2032.2031,2035.3059,2036.9917,2186.6926,2186.3035,2186.3035,2186.869,2187.3035,2188.7834,2190.2195,2194.573,2199.445,2204.4436,2209.189,2213.061,2217.1362,2220.2715,2222.479,2222.738,2222.738,2222.4287,2221.59,2219.9187,2218.7292,2217.5398,2215.846,2213.9756,2210.7754,2207.556,2201.961,2193.581,2183.837,2176.4473,2169.3784,2161.9866,2154.113,2147.3706,2138.373,2128.069};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {2117.4504,2106.5188,2095.0945,2081.784,2072.927,2064.296,2056.164,2048.856,2041.7583,2036.1947,2031.8535,2026.0719,2024.9246,2027.3605,2030.3054,2193.3137,2192.619,2192.582,2192.6667,2194.5881,2195.649,2197.498,2200.9832,2204.48,2208.9766,2213.0889,2217.0393,2223.2432,2228.3833,2230.499,2231.3052,2231.4429,2231.4429,2231.2947,2230.3613,2228.4429,2226.9868,2223.6902,2220.9717,2217.1604,2213.0378,2206.8135,2197.5054,2190.55,2182.75,2173.3936,2164.5967,2157.1047,2148.8926,2140.38,2129.76,2119.02,2105.9792,2093.7993,2080.9233,2070.9192,2062.5867,2055.164,2048.0366,2042.032,2036.24,2031.3777,2026.416,2022.0,2022.0925,2022.418,2199.6633,2199.8606,2200.2703,2201.0352,2201.8606,2202.8606,2204.514,2206.9258,2209.3618,2212.7336,2216.607,2222.8618,2230.304,2234.5417,2237.2646,2239.7007,2240.94,2241.8606,2240.8606,2240.1477,2237.8406,2234.274,2230.7898,2226.9177,2221.978,2218.1738,2210.0298,2202.0708,2196.271,2187.2961,2175.1,2164.2678,2155.8125,2147.3623};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {2138.9658,2128.913,2116.4473,2102.4292,2090.0862,2078.497,2068.7532,2060.185,2052.8772,2046.6171,2041.3999,2036.16,2031.288,2026.6432,2022.772,2020.0491,2018.3262};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.02,0.00391,0.04,0.00391,0.06,0.00391,0.08,0.00391,0.1,0.00391,0.12,0.00391,0.14,0.00391,0.16,0.00391,0.18,0.00391,0.2,0.00391,0.22,0.00391,0.24,0.00391,0.26,0.00391,0.28,0.00391,0.3,0.00391,0.32,0.00391,0.34,0.00391,0.36,0.00391,0.38,0.00391,0.4,0.00391,0.42,0.00391,0.44,0.00391,0.46,0.00391,0.48,0.00391,0.5,0.00391,0.52,0.00391,0.54,0.00391,0.56,0.00391,0.58,0.00391,0.6,0.00391,0.62,0.00391,0.64,0.00391,0.66,0.00391,0.68,0.00391,0.7,0.00391,0.72,0.00391,0.74,0.00391,0.76,0.00391,0.78,0.00391,0.8,0.00391,0.82,0.00391,0.84,0.00391,0.86,0.00391,0.88,0.00391,0.9,0.00391,0.92,0.00391,0.94,0.00391,0.96,0.00391,0.98,0.00391,0.99609,0.00391,0.00391,0.01515,0.02,0.01515,0.04,0.01515,0.06,0.01515,0.08,0.01515,0.1,0.01515,0.12,0.01515,0.14,0.01515,0.16,0.01515,0.18,0.01515,0.2,0.01515,0.22,0.01515,0.24,0.01515,0.26,0.01515,0.28,0.01515,0.3,0.01515,0.32,0.01515,0.34,0.01515,0.36,0.01515,0.38,0.01515,0.4,0.01515,0.42,0.01515,0.44,0.01515,0.46,0.01515,0.48,0.01515,0.5,0.01515,0.52,0.01515,0.54,0.01515,0.56,0.01515,0.58,0.01515,0.6,0.01515,0.62,0.01515,0.64,0.01515,0.66,0.01515,0.68,0.01515,0.7,0.01515,0.72,0.01515,0.74,0.01515,0.76,0.01515,0.78,0.01515,0.8,0.01515,0.82,0.01515,0.84,0.01515,0.86,0.01515,0.88,0.01515,0.9,0.01515,0.92,0.01515,0.94,0.01515,0.96,0.01515};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.98,0.01515,0.99609,0.01515,0.00391,0.0303,0.02,0.0303,0.04,0.0303,0.06,0.0303,0.08,0.0303,0.1,0.0303,0.12,0.0303,0.14,0.0303,0.16,0.0303,0.18,0.0303,0.2,0.0303,0.22,0.0303,0.24,0.0303,0.26,0.0303,0.28,0.0303,0.3,0.0303,0.32,0.0303,0.34,0.0303,0.36,0.0303,0.38,0.0303,0.4,0.0303,0.42,0.0303,0.44,0.0303,0.46,0.0303,0.48,0.0303,0.5,0.0303,0.52,0.0303,0.54,0.0303,0.56,0.0303,0.58,0.0303,0.6,0.0303,0.62,0.0303,0.64,0.0303,0.66,0.0303,0.68,0.0303,0.7,0.0303,0.72,0.0303,0.74,0.0303,0.76,0.0303,0.78,0.0303,0.8,0.0303,0.82,0.0303,0.84,0.0303,0.86,0.0303,0.88,0.0303,0.9,0.0303,0.92,0.0303,0.94,0.0303,0.96,0.0303,0.98,0.0303,0.99609,0.0303,0.00391,0.04545,0.02,0.04545,0.04,0.04545,0.06,0.04545,0.08,0.04545,0.1,0.04545,0.12,0.04545,0.14,0.04545,0.16,0.04545,0.18,0.04545,0.2,0.04545,0.22,0.04545,0.24,0.04545,0.26,0.04545,0.28,0.04545,0.3,0.04545,0.32,0.04545,0.34,0.04545,0.36,0.04545,0.38,0.04545,0.4,0.04545,0.42,0.04545,0.44,0.04545,0.46,0.04545,0.48,0.04545,0.5,0.04545,0.52,0.04545,0.54,0.04545,0.56,0.04545,0.58,0.04545,0.6,0.04545,0.62,0.04545,0.64,0.04545,0.66,0.04545,0.68,0.04545,0.7,0.04545,0.72,0.04545,0.74,0.04545,0.76,0.04545,0.78,0.04545,0.8,0.04545,0.82,0.04545,0.84,0.04545,0.86,0.04545,0.88,0.04545,0.9,0.04545,0.92,0.04545};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.94,0.04545,0.96,0.04545,0.98,0.04545,0.99609,0.04545,0.00391,0.06061,0.02,0.06061,0.04,0.06061,0.06,0.06061,0.08,0.06061,0.1,0.06061,0.12,0.06061,0.14,0.06061,0.16,0.06061,0.18,0.06061,0.2,0.06061,0.22,0.06061,0.24,0.06061,0.26,0.06061,0.28,0.06061,0.3,0.06061,0.32,0.06061,0.34,0.06061,0.36,0.06061,0.38,0.06061,0.4,0.06061,0.42,0.06061,0.44,0.06061,0.46,0.06061,0.48,0.06061,0.5,0.06061,0.52,0.06061,0.54,0.06061,0.56,0.06061,0.58,0.06061,0.6,0.06061,0.62,0.06061,0.64,0.06061,0.66,0.06061,0.68,0.06061,0.7,0.06061,0.72,0.06061,0.74,0.06061,0.76,0.06061,0.78,0.06061,0.8,0.06061,0.82,0.06061,0.84,0.06061,0.86,0.06061,0.88,0.06061,0.9,0.06061,0.92,0.06061,0.94,0.06061,0.96,0.06061,0.98,0.06061,0.99609,0.06061,0.00391,0.07576,0.02,0.07576,0.04,0.07576,0.06,0.07576,0.08,0.07576,0.1,0.07576,0.12,0.07576,0.14,0.07576,0.16,0.07576,0.18,0.07576,0.2,0.07576,0.22,0.07576,0.24,0.07576,0.26,0.07576,0.28,0.07576,0.3,0.07576,0.32,0.07576,0.34,0.07576,0.36,0.07576,0.38,0.07576,0.4,0.07576,0.42,0.07576,0.44,0.07576,0.46,0.07576,0.48,0.07576,0.5,0.07576,0.52,0.07576,0.54,0.07576,0.56,0.07576,0.58,0.07576,0.6,0.07576,0.62,0.07576,0.64,0.07576,0.66,0.07576,0.68,0.07576,0.7,0.07576,0.72,0.07576,0.74,0.07576,0.76,0.07576,0.78,0.07576,0.8,0.07576,0.82,0.07576,0.84,0.07576,0.86,0.07576,0.88,0.07576};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.9,0.07576,0.92,0.07576,0.94,0.07576,0.96,0.07576,0.98,0.07576,0.99609,0.07576,0.00391,0.09091,0.02,0.09091,0.04,0.09091,0.06,0.09091,0.08,0.09091,0.1,0.09091,0.12,0.09091,0.14,0.09091,0.16,0.09091,0.18,0.09091,0.2,0.09091,0.22,0.09091,0.24,0.09091,0.26,0.09091,0.28,0.09091,0.3,0.09091,0.32,0.09091,0.34,0.09091,0.36,0.09091,0.38,0.09091,0.4,0.09091,0.42,0.09091,0.44,0.09091,0.46,0.09091,0.48,0.09091,0.5,0.09091,0.52,0.09091,0.54,0.09091,0.56,0.09091,0.58,0.09091,0.6,0.09091,0.62,0.09091,0.64,0.09091,0.66,0.09091,0.68,0.09091,0.7,0.09091,0.72,0.09091,0.74,0.09091,0.76,0.09091,0.78,0.09091,0.8,0.09091,0.82,0.09091,0.84,0.09091,0.86,0.09091,0.88,0.09091,0.9,0.09091,0.92,0.09091,0.94,0.09091,0.96,0.09091,0.98,0.09091,0.99609,0.09091,0.00391,0.10606,0.02,0.10606,0.04,0.10606,0.06,0.10606,0.08,0.10606,0.1,0.10606,0.12,0.10606,0.14,0.10606,0.16,0.10606,0.18,0.10606,0.2,0.10606,0.22,0.10606,0.24,0.10606,0.26,0.10606,0.28,0.10606,0.3,0.10606,0.32,0.10606,0.34,0.10606,0.36,0.10606,0.38,0.10606,0.4,0.10606,0.42,0.10606,0.44,0.10606,0.46,0.10606,0.48,0.10606,0.5,0.10606,0.52,0.10606,0.54,0.10606,0.56,0.10606,0.58,0.10606,0.6,0.10606,0.62,0.10606,0.64,0.10606,0.66,0.10606,0.68,0.10606,0.7,0.10606,0.72,0.10606,0.74,0.10606,0.76,0.10606,0.78,0.10606,0.8,0.10606,0.82,0.10606,0.84,0.10606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.86,0.10606,0.88,0.10606,0.9,0.10606,0.92,0.10606,0.94,0.10606,0.96,0.10606,0.98,0.10606,0.99609,0.10606,0.00391,0.12121,0.02,0.12121,0.04,0.12121,0.06,0.12121,0.08,0.12121,0.1,0.12121,0.12,0.12121,0.14,0.12121,0.16,0.12121,0.18,0.12121,0.2,0.12121,0.22,0.12121,0.24,0.12121,0.26,0.12121,0.28,0.12121,0.3,0.12121,0.32,0.12121,0.34,0.12121,0.36,0.12121,0.38,0.12121,0.4,0.12121,0.42,0.12121,0.44,0.12121,0.46,0.12121,0.48,0.12121,0.5,0.12121,0.52,0.12121,0.54,0.12121,0.56,0.12121,0.58,0.12121,0.6,0.12121,0.62,0.12121,0.64,0.12121,0.66,0.12121,0.68,0.12121,0.7,0.12121,0.72,0.12121,0.74,0.12121,0.76,0.12121,0.78,0.12121,0.8,0.12121,0.82,0.12121,0.84,0.12121,0.86,0.12121,0.88,0.12121,0.9,0.12121,0.92,0.12121,0.94,0.12121,0.96,0.12121,0.98,0.12121,0.99609,0.12121,0.00391,0.13636,0.02,0.13636,0.04,0.13636,0.06,0.13636,0.08,0.13636,0.1,0.13636,0.12,0.13636,0.14,0.13636,0.16,0.13636,0.18,0.13636,0.2,0.13636,0.22,0.13636,0.24,0.13636,0.26,0.13636,0.28,0.13636,0.3,0.13636,0.32,0.13636,0.34,0.13636,0.36,0.13636,0.38,0.13636,0.4,0.13636,0.42,0.13636,0.44,0.13636,0.46,0.13636,0.48,0.13636,0.5,0.13636,0.52,0.13636,0.54,0.13636,0.56,0.13636,0.58,0.13636,0.6,0.13636,0.62,0.13636,0.64,0.13636,0.66,0.13636,0.68,0.13636,0.7,0.13636,0.72,0.13636,0.74,0.13636,0.76,0.13636,0.78,0.13636,0.8,0.13636};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.82,0.13636,0.84,0.13636,0.86,0.13636,0.88,0.13636,0.9,0.13636,0.92,0.13636,0.94,0.13636,0.96,0.13636,0.98,0.13636,0.99609,0.13636,0.00391,0.15152,0.02,0.15152,0.04,0.15152,0.06,0.15152,0.08,0.15152,0.1,0.15152,0.12,0.15152,0.14,0.15152,0.16,0.15152,0.18,0.15152,0.2,0.15152,0.22,0.15152,0.24,0.15152,0.26,0.15152,0.28,0.15152,0.3,0.15152,0.32,0.15152,0.34,0.15152,0.36,0.15152,0.38,0.15152,0.4,0.15152,0.42,0.15152,0.44,0.15152,0.46,0.15152,0.48,0.15152,0.5,0.15152,0.52,0.15152,0.54,0.15152,0.56,0.15152,0.58,0.15152,0.6,0.15152,0.62,0.15152,0.64,0.15152,0.66,0.15152,0.68,0.15152,0.7,0.15152,0.72,0.15152,0.74,0.15152,0.76,0.15152,0.78,0.15152,0.8,0.15152,0.82,0.15152,0.84,0.15152,0.86,0.15152,0.88,0.15152,0.9,0.15152,0.92,0.15152,0.94,0.15152,0.96,0.15152,0.98,0.15152,0.99609,0.15152,0.00391,0.16667,0.02,0.16667,0.04,0.16667,0.06,0.16667,0.08,0.16667,0.1,0.16667,0.12,0.16667,0.14,0.16667,0.16,0.16667,0.18,0.16667,0.2,0.16667,0.22,0.16667,0.24,0.16667,0.26,0.16667,0.28,0.16667,0.3,0.16667,0.32,0.16667,0.34,0.16667,0.36,0.16667,0.38,0.16667,0.4,0.16667,0.42,0.16667,0.44,0.16667,0.46,0.16667,0.48,0.16667,0.5,0.16667,0.52,0.16667,0.54,0.16667,0.56,0.16667,0.58,0.16667,0.6,0.16667,0.62,0.16667,0.64,0.16667,0.66,0.16667,0.68,0.16667,0.7,0.16667,0.72,0.16667,0.74,0.16667,0.76,0.16667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.78,0.16667,0.8,0.16667,0.82,0.16667,0.84,0.16667,0.86,0.16667,0.88,0.16667,0.9,0.16667,0.92,0.16667,0.94,0.16667,0.96,0.16667,0.98,0.16667,0.99609,0.16667,0.00391,0.18182,0.02,0.18182,0.04,0.18182,0.06,0.18182,0.08,0.18182,0.1,0.18182,0.12,0.18182,0.14,0.18182,0.16,0.18182,0.18,0.18182,0.2,0.18182,0.22,0.18182,0.24,0.18182,0.26,0.18182,0.28,0.18182,0.3,0.18182,0.32,0.18182,0.34,0.18182,0.36,0.18182,0.38,0.18182,0.4,0.18182,0.42,0.18182,0.44,0.18182,0.46,0.18182,0.48,0.18182,0.5,0.18182,0.52,0.18182,0.54,0.18182,0.56,0.18182,0.58,0.18182,0.6,0.18182,0.62,0.18182,0.64,0.18182,0.66,0.18182,0.68,0.18182,0.7,0.18182,0.72,0.18182,0.74,0.18182,0.76,0.18182,0.78,0.18182,0.8,0.18182,0.82,0.18182,0.84,0.18182,0.86,0.18182,0.88,0.18182,0.9,0.18182,0.92,0.18182,0.94,0.18182,0.96,0.18182,0.98,0.18182,0.99609,0.18182,0.00391,0.19697,0.02,0.19697,0.04,0.19697,0.06,0.19697,0.08,0.19697,0.1,0.19697,0.12,0.19697,0.14,0.19697,0.16,0.19697,0.18,0.19697,0.2,0.19697,0.22,0.19697,0.24,0.19697,0.26,0.19697,0.28,0.19697,0.3,0.19697,0.32,0.19697,0.34,0.19697,0.36,0.19697,0.38,0.19697,0.4,0.19697,0.42,0.19697,0.44,0.19697,0.46,0.19697,0.48,0.19697,0.5,0.19697,0.52,0.19697,0.54,0.19697,0.56,0.19697,0.58,0.19697,0.6,0.19697,0.62,0.19697,0.64,0.19697,0.66,0.19697,0.68,0.19697,0.7,0.19697,0.72,0.19697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.74,0.19697,0.76,0.19697,0.78,0.19697,0.8,0.19697,0.82,0.19697,0.84,0.19697,0.86,0.19697,0.88,0.19697,0.9,0.19697,0.92,0.19697,0.94,0.19697,0.96,0.19697,0.98,0.19697,0.99609,0.19697,0.00391,0.21212,0.02,0.21212,0.04,0.21212,0.06,0.21212,0.08,0.21212,0.1,0.21212,0.12,0.21212,0.14,0.21212,0.16,0.21212,0.18,0.21212,0.2,0.21212,0.22,0.21212,0.24,0.21212,0.26,0.21212,0.28,0.21212,0.3,0.21212,0.32,0.21212,0.34,0.21212,0.36,0.21212,0.38,0.21212,0.4,0.21212,0.42,0.21212,0.44,0.21212,0.46,0.21212,0.48,0.21212,0.5,0.21212,0.52,0.21212,0.54,0.21212,0.56,0.21212,0.58,0.21212,0.6,0.21212,0.62,0.21212,0.64,0.21212,0.66,0.21212,0.68,0.21212,0.7,0.21212,0.72,0.21212,0.74,0.21212,0.76,0.21212,0.78,0.21212,0.8,0.21212,0.82,0.21212,0.84,0.21212,0.86,0.21212,0.88,0.21212,0.9,0.21212,0.92,0.21212,0.94,0.21212,0.96,0.21212,0.98,0.21212,0.99609,0.21212,0.00391,0.22727,0.02,0.22727,0.04,0.22727,0.06,0.22727,0.08,0.22727,0.1,0.22727,0.12,0.22727,0.14,0.22727,0.16,0.22727,0.18,0.22727,0.2,0.22727,0.22,0.22727,0.24,0.22727,0.26,0.22727,0.28,0.22727,0.3,0.22727,0.32,0.22727,0.34,0.22727,0.36,0.22727,0.38,0.22727,0.4,0.22727,0.42,0.22727,0.44,0.22727,0.46,0.22727,0.48,0.22727,0.5,0.22727,0.52,0.22727,0.54,0.22727,0.56,0.22727,0.58,0.22727,0.6,0.22727,0.62,0.22727,0.64,0.22727,0.66,0.22727,0.68,0.22727};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.7,0.22727,0.72,0.22727,0.74,0.22727,0.76,0.22727,0.78,0.22727,0.8,0.22727,0.82,0.22727,0.84,0.22727,0.86,0.22727,0.88,0.22727,0.9,0.22727,0.92,0.22727,0.94,0.22727,0.96,0.22727,0.98,0.22727,0.99609,0.22727,0.00391,0.24242,0.02,0.24242,0.04,0.24242,0.06,0.24242,0.08,0.24242,0.1,0.24242,0.12,0.24242,0.14,0.24242,0.16,0.24242,0.18,0.24242,0.2,0.24242,0.22,0.24242,0.24,0.24242,0.26,0.24242,0.28,0.24242,0.3,0.24242,0.32,0.24242,0.34,0.24242,0.36,0.24242,0.38,0.24242,0.4,0.24242,0.42,0.24242,0.44,0.24242,0.46,0.24242,0.48,0.24242,0.5,0.24242,0.52,0.24242,0.54,0.24242,0.56,0.24242,0.58,0.24242,0.6,0.24242,0.62,0.24242,0.64,0.24242,0.66,0.24242,0.68,0.24242,0.7,0.24242,0.72,0.24242,0.74,0.24242,0.76,0.24242,0.78,0.24242,0.8,0.24242,0.82,0.24242,0.84,0.24242,0.86,0.24242,0.88,0.24242,0.9,0.24242,0.92,0.24242,0.94,0.24242,0.96,0.24242,0.98,0.24242,0.99609,0.24242,0.00391,0.25758,0.02,0.25758,0.04,0.25758,0.06,0.25758,0.08,0.25758,0.1,0.25758,0.12,0.25758,0.14,0.25758,0.16,0.25758,0.18,0.25758,0.2,0.25758,0.22,0.25758,0.24,0.25758,0.26,0.25758,0.28,0.25758,0.3,0.25758,0.32,0.25758,0.34,0.25758,0.36,0.25758,0.38,0.25758,0.4,0.25758,0.42,0.25758,0.44,0.25758,0.46,0.25758,0.48,0.25758,0.5,0.25758,0.52,0.25758,0.54,0.25758,0.56,0.25758,0.58,0.25758,0.6,0.25758,0.62,0.25758,0.64,0.25758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.66,0.25758,0.68,0.25758,0.7,0.25758,0.72,0.25758,0.74,0.25758,0.76,0.25758,0.78,0.25758,0.8,0.25758,0.82,0.25758,0.84,0.25758,0.86,0.25758,0.88,0.25758,0.9,0.25758,0.92,0.25758,0.94,0.25758,0.96,0.25758,0.98,0.25758,0.99609,0.25758,0.00391,0.27273,0.02,0.27273,0.04,0.27273,0.06,0.27273,0.08,0.27273,0.1,0.27273,0.12,0.27273,0.14,0.27273,0.16,0.27273,0.18,0.27273,0.2,0.27273,0.22,0.27273,0.24,0.27273,0.26,0.27273,0.28,0.27273,0.3,0.27273,0.32,0.27273,0.34,0.27273,0.36,0.27273,0.38,0.27273,0.4,0.27273,0.42,0.27273,0.44,0.27273,0.46,0.27273,0.48,0.27273,0.5,0.27273,0.52,0.27273,0.54,0.27273,0.56,0.27273,0.58,0.27273,0.6,0.27273,0.62,0.27273,0.64,0.27273,0.66,0.27273,0.68,0.27273,0.7,0.27273,0.72,0.27273,0.74,0.27273,0.76,0.27273,0.78,0.27273,0.8,0.27273,0.82,0.27273,0.84,0.27273,0.86,0.27273,0.88,0.27273,0.9,0.27273,0.92,0.27273,0.94,0.27273,0.96,0.27273,0.98,0.27273,0.99609,0.27273,0.00391,0.28788,0.02,0.28788,0.04,0.28788,0.06,0.28788,0.08,0.28788,0.1,0.28788,0.12,0.28788,0.14,0.28788,0.16,0.28788,0.18,0.28788,0.2,0.28788,0.22,0.28788,0.24,0.28788,0.26,0.28788,0.28,0.28788,0.3,0.28788,0.32,0.28788,0.34,0.28788,0.36,0.28788,0.38,0.28788,0.4,0.28788,0.42,0.28788,0.44,0.28788,0.46,0.28788,0.48,0.28788,0.5,0.28788,0.52,0.28788,0.54,0.28788,0.56,0.28788,0.58,0.28788,0.6,0.28788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.62,0.28788,0.64,0.28788,0.66,0.28788,0.68,0.28788,0.7,0.28788,0.72,0.28788,0.74,0.28788,0.76,0.28788,0.78,0.28788,0.8,0.28788,0.82,0.28788,0.84,0.28788,0.86,0.28788,0.88,0.28788,0.9,0.28788,0.92,0.28788,0.94,0.28788,0.96,0.28788,0.98,0.28788,0.99609,0.28788,0.00391,0.30303,0.02,0.30303,0.04,0.30303,0.06,0.30303,0.08,0.30303,0.1,0.30303,0.12,0.30303,0.14,0.30303,0.16,0.30303,0.18,0.30303,0.2,0.30303,0.22,0.30303,0.24,0.30303,0.26,0.30303,0.28,0.30303,0.3,0.30303,0.32,0.30303,0.34,0.30303,0.36,0.30303,0.38,0.30303,0.4,0.30303,0.42,0.30303,0.44,0.30303,0.46,0.30303,0.48,0.30303,0.5,0.30303,0.52,0.30303,0.54,0.30303,0.56,0.30303,0.58,0.30303,0.6,0.30303,0.62,0.30303,0.64,0.30303,0.66,0.30303,0.68,0.30303,0.7,0.30303,0.72,0.30303,0.74,0.30303,0.76,0.30303,0.78,0.30303,0.8,0.30303,0.82,0.30303,0.84,0.30303,0.86,0.30303,0.88,0.30303,0.9,0.30303,0.92,0.30303,0.94,0.30303,0.96,0.30303,0.98,0.30303,0.99609,0.30303,0.00391,0.31818,0.02,0.31818,0.04,0.31818,0.06,0.31818,0.08,0.31818,0.1,0.31818,0.12,0.31818,0.14,0.31818,0.16,0.31818,0.18,0.31818,0.2,0.31818,0.22,0.31818,0.24,0.31818,0.26,0.31818,0.28,0.31818,0.3,0.31818,0.32,0.31818,0.34,0.31818,0.36,0.31818,0.38,0.31818,0.4,0.31818,0.42,0.31818,0.44,0.31818,0.46,0.31818,0.48,0.31818,0.5,0.31818,0.52,0.31818,0.54,0.31818,0.56,0.31818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.58,0.31818,0.6,0.31818,0.62,0.31818,0.64,0.31818,0.66,0.31818,0.68,0.31818,0.7,0.31818,0.72,0.31818,0.74,0.31818,0.76,0.31818,0.78,0.31818,0.8,0.31818,0.82,0.31818,0.84,0.31818,0.86,0.31818,0.88,0.31818,0.9,0.31818,0.92,0.31818,0.94,0.31818,0.96,0.31818,0.98,0.31818,0.99609,0.31818,0.00391,0.33333,0.02,0.33333,0.04,0.33333,0.06,0.33333,0.08,0.33333,0.1,0.33333,0.12,0.33333,0.14,0.33333,0.16,0.33333,0.18,0.33333,0.2,0.33333,0.22,0.33333,0.24,0.33333,0.26,0.33333,0.28,0.33333,0.3,0.33333,0.32,0.33333,0.34,0.33333,0.36,0.33333,0.38,0.33333,0.4,0.33333,0.42,0.33333,0.44,0.33333,0.46,0.33333,0.48,0.33333,0.5,0.33333,0.52,0.33333,0.54,0.33333,0.56,0.33333,0.58,0.33333,0.6,0.33333,0.62,0.33333,0.64,0.33333,0.66,0.33333,0.68,0.33333,0.7,0.33333,0.72,0.33333,0.74,0.33333,0.76,0.33333,0.78,0.33333,0.8,0.33333,0.82,0.33333,0.84,0.33333,0.86,0.33333,0.88,0.33333,0.9,0.33333,0.92,0.33333,0.94,0.33333,0.96,0.33333,0.98,0.33333,0.99609,0.33333,0.00391,0.34848,0.02,0.34848,0.04,0.34848,0.06,0.34848,0.08,0.34848,0.1,0.34848,0.12,0.34848,0.14,0.34848,0.16,0.34848,0.18,0.34848,0.2,0.34848,0.22,0.34848,0.24,0.34848,0.26,0.34848,0.28,0.34848,0.3,0.34848,0.32,0.34848,0.34,0.34848,0.36,0.34848,0.38,0.34848,0.4,0.34848,0.42,0.34848,0.44,0.34848,0.46,0.34848,0.48,0.34848,0.5,0.34848,0.52,0.34848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.54,0.34848,0.56,0.34848,0.58,0.34848,0.6,0.34848,0.62,0.34848,0.64,0.34848,0.66,0.34848,0.68,0.34848,0.7,0.34848,0.72,0.34848,0.74,0.34848,0.76,0.34848,0.78,0.34848,0.8,0.34848,0.82,0.34848,0.84,0.34848,0.86,0.34848,0.88,0.34848,0.9,0.34848,0.92,0.34848,0.94,0.34848,0.96,0.34848,0.98,0.34848,0.99609,0.34848,0.00391,0.36364,0.02,0.36364,0.04,0.36364,0.06,0.36364,0.08,0.36364,0.1,0.36364,0.12,0.36364,0.14,0.36364,0.16,0.36364,0.18,0.36364,0.2,0.36364,0.22,0.36364,0.24,0.36364,0.26,0.36364,0.28,0.36364,0.3,0.36364,0.32,0.36364,0.34,0.36364,0.36,0.36364,0.38,0.36364,0.4,0.36364,0.42,0.36364,0.44,0.36364,0.46,0.36364,0.48,0.36364,0.5,0.36364,0.52,0.36364,0.54,0.36364,0.56,0.36364,0.58,0.36364,0.6,0.36364,0.62,0.36364,0.64,0.36364,0.66,0.36364,0.68,0.36364,0.7,0.36364,0.72,0.36364,0.74,0.36364,0.76,0.36364,0.78,0.36364,0.8,0.36364,0.82,0.36364,0.84,0.36364,0.86,0.36364,0.88,0.36364,0.9,0.36364,0.92,0.36364,0.94,0.36364,0.96,0.36364,0.98,0.36364,0.99609,0.36364,0.00391,0.37879,0.02,0.37879,0.04,0.37879,0.06,0.37879,0.08,0.37879,0.1,0.37879,0.12,0.37879,0.14,0.37879,0.16,0.37879,0.18,0.37879,0.2,0.37879,0.22,0.37879,0.24,0.37879,0.26,0.37879,0.28,0.37879,0.3,0.37879,0.32,0.37879,0.34,0.37879,0.36,0.37879,0.38,0.37879,0.4,0.37879,0.42,0.37879,0.44,0.37879,0.46,0.37879,0.48,0.37879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.5,0.37879,0.52,0.37879,0.54,0.37879,0.56,0.37879,0.58,0.37879,0.6,0.37879,0.62,0.37879,0.64,0.37879,0.66,0.37879,0.68,0.37879,0.7,0.37879,0.72,0.37879,0.74,0.37879,0.76,0.37879,0.78,0.37879,0.8,0.37879,0.82,0.37879,0.84,0.37879,0.86,0.37879,0.88,0.37879,0.9,0.37879,0.92,0.37879,0.94,0.37879,0.96,0.37879,0.98,0.37879,0.99609,0.37879,0.00391,0.39394,0.02,0.39394,0.04,0.39394,0.06,0.39394,0.08,0.39394,0.1,0.39394,0.12,0.39394,0.14,0.39394,0.16,0.39394,0.18,0.39394,0.2,0.39394,0.22,0.39394,0.24,0.39394,0.26,0.39394,0.28,0.39394,0.3,0.39394,0.32,0.39394,0.34,0.39394,0.36,0.39394,0.38,0.39394,0.4,0.39394,0.42,0.39394,0.44,0.39394,0.46,0.39394,0.48,0.39394,0.5,0.39394,0.52,0.39394,0.54,0.39394,0.56,0.39394,0.58,0.39394,0.6,0.39394,0.62,0.39394,0.64,0.39394,0.66,0.39394,0.68,0.39394,0.7,0.39394,0.72,0.39394,0.74,0.39394,0.76,0.39394,0.78,0.39394,0.8,0.39394,0.82,0.39394,0.84,0.39394,0.86,0.39394,0.88,0.39394,0.9,0.39394,0.92,0.39394,0.94,0.39394,0.96,0.39394,0.98,0.39394,0.99609,0.39394,0.00391,0.40909,0.02,0.40909,0.04,0.40909,0.06,0.40909,0.08,0.40909,0.1,0.40909,0.12,0.40909,0.14,0.40909,0.16,0.40909,0.18,0.40909,0.2,0.40909,0.22,0.40909,0.24,0.40909,0.26,0.40909,0.28,0.40909,0.3,0.40909,0.32,0.40909,0.34,0.40909,0.36,0.40909,0.38,0.40909,0.4,0.40909,0.42,0.40909,0.44,0.40909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.46,0.40909,0.48,0.40909,0.5,0.40909,0.52,0.40909,0.54,0.40909,0.56,0.40909,0.58,0.40909,0.6,0.40909,0.62,0.40909,0.64,0.40909,0.66,0.40909,0.68,0.40909,0.7,0.40909,0.72,0.40909,0.74,0.40909,0.76,0.40909,0.78,0.40909,0.8,0.40909,0.82,0.40909,0.84,0.40909,0.86,0.40909,0.88,0.40909,0.9,0.40909,0.92,0.40909,0.94,0.40909,0.96,0.40909,0.98,0.40909,0.99609,0.40909,0.00391,0.42424,0.02,0.42424,0.04,0.42424,0.06,0.42424,0.08,0.42424,0.1,0.42424,0.12,0.42424,0.14,0.42424,0.16,0.42424,0.18,0.42424,0.2,0.42424,0.22,0.42424,0.24,0.42424,0.26,0.42424,0.28,0.42424,0.3,0.42424,0.32,0.42424,0.34,0.42424,0.36,0.42424,0.38,0.42424,0.4,0.42424,0.42,0.42424,0.44,0.42424,0.46,0.42424,0.48,0.42424,0.5,0.42424,0.52,0.42424,0.54,0.42424,0.56,0.42424,0.58,0.42424,0.6,0.42424,0.62,0.42424,0.64,0.42424,0.66,0.42424,0.68,0.42424,0.7,0.42424,0.72,0.42424,0.74,0.42424,0.76,0.42424,0.78,0.42424,0.8,0.42424,0.82,0.42424,0.84,0.42424,0.86,0.42424,0.88,0.42424,0.9,0.42424,0.92,0.42424,0.94,0.42424,0.96,0.42424,0.98,0.42424,0.99609,0.42424,0.00391,0.43939,0.02,0.43939,0.04,0.43939,0.06,0.43939,0.08,0.43939,0.1,0.43939,0.12,0.43939,0.14,0.43939,0.16,0.43939,0.18,0.43939,0.2,0.43939,0.22,0.43939,0.24,0.43939,0.26,0.43939,0.28,0.43939,0.3,0.43939,0.32,0.43939,0.34,0.43939,0.36,0.43939,0.38,0.43939,0.4,0.43939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.42,0.43939,0.44,0.43939,0.46,0.43939,0.48,0.43939,0.5,0.43939,0.52,0.43939,0.54,0.43939,0.56,0.43939,0.58,0.43939,0.6,0.43939,0.62,0.43939,0.64,0.43939,0.66,0.43939,0.68,0.43939,0.7,0.43939,0.72,0.43939,0.74,0.43939,0.76,0.43939,0.78,0.43939,0.8,0.43939,0.82,0.43939,0.84,0.43939,0.86,0.43939,0.88,0.43939,0.9,0.43939,0.92,0.43939,0.94,0.43939,0.96,0.43939,0.98,0.43939,0.99609,0.43939,0.00391,0.45455,0.02,0.45455,0.04,0.45455,0.06,0.45455,0.08,0.45455,0.1,0.45455,0.12,0.45455,0.14,0.45455,0.16,0.45455,0.18,0.45455,0.2,0.45455,0.22,0.45455,0.24,0.45455,0.26,0.45455,0.28,0.45455,0.3,0.45455,0.32,0.45455,0.34,0.45455,0.36,0.45455,0.38,0.45455,0.4,0.45455,0.42,0.45455,0.44,0.45455,0.46,0.45455,0.48,0.45455,0.5,0.45455,0.52,0.45455,0.54,0.45455,0.56,0.45455,0.58,0.45455,0.6,0.45455,0.62,0.45455,0.64,0.45455,0.66,0.45455,0.68,0.45455,0.7,0.45455,0.72,0.45455,0.74,0.45455,0.76,0.45455,0.78,0.45455,0.8,0.45455,0.82,0.45455,0.84,0.45455,0.86,0.45455,0.88,0.45455,0.9,0.45455,0.92,0.45455,0.94,0.45455,0.96,0.45455,0.98,0.45455,0.99609,0.45455,0.00391,0.4697,0.02,0.4697,0.04,0.4697,0.06,0.4697,0.08,0.4697,0.1,0.4697,0.12,0.4697,0.14,0.4697,0.16,0.4697,0.18,0.4697,0.2,0.4697,0.22,0.4697,0.24,0.4697,0.26,0.4697,0.28,0.4697,0.3,0.4697,0.32,0.4697,0.34,0.4697,0.36,0.4697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.38,0.4697,0.4,0.4697,0.42,0.4697,0.44,0.4697,0.46,0.4697,0.48,0.4697,0.5,0.4697,0.52,0.4697,0.54,0.4697,0.56,0.4697,0.58,0.4697,0.6,0.4697,0.62,0.4697,0.64,0.4697,0.66,0.4697,0.68,0.4697,0.7,0.4697,0.72,0.4697,0.74,0.4697,0.76,0.4697,0.78,0.4697,0.8,0.4697,0.82,0.4697,0.84,0.4697,0.86,0.4697,0.88,0.4697,0.9,0.4697,0.92,0.4697,0.94,0.4697,0.96,0.4697,0.98,0.4697,0.99609,0.4697,0.00391,0.48485,0.02,0.48485,0.04,0.48485,0.06,0.48485,0.08,0.48485,0.1,0.48485,0.12,0.48485,0.14,0.48485,0.16,0.48485,0.18,0.48485,0.2,0.48485,0.22,0.48485,0.24,0.48485,0.26,0.48485,0.28,0.48485,0.3,0.48485,0.32,0.48485,0.34,0.48485,0.36,0.48485,0.38,0.48485,0.4,0.48485,0.42,0.48485,0.44,0.48485,0.46,0.48485,0.48,0.48485,0.5,0.48485,0.52,0.48485,0.54,0.48485,0.56,0.48485,0.58,0.48485,0.6,0.48485,0.62,0.48485,0.64,0.48485,0.66,0.48485,0.68,0.48485,0.7,0.48485,0.72,0.48485,0.74,0.48485,0.76,0.48485,0.78,0.48485,0.8,0.48485,0.82,0.48485,0.84,0.48485,0.86,0.48485,0.88,0.48485,0.9,0.48485,0.92,0.48485,0.94,0.48485,0.96,0.48485,0.98,0.48485,0.99609,0.48485,0.00391,0.5,0.02,0.5,0.04,0.5,0.06,0.5,0.08,0.5,0.1,0.5,0.12,0.5,0.14,0.5,0.16,0.5,0.18,0.5,0.2,0.5,0.22,0.5,0.24,0.5,0.26,0.5,0.28,0.5,0.3,0.5,0.32,0.5};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.34,0.5,0.36,0.5,0.38,0.5,0.4,0.5,0.42,0.5,0.44,0.5,0.46,0.5,0.48,0.5,0.5,0.5,0.52,0.5,0.54,0.5,0.56,0.5,0.58,0.5,0.6,0.5,0.62,0.5,0.64,0.5,0.66,0.5,0.68,0.5,0.7,0.5,0.72,0.5,0.74,0.5,0.76,0.5,0.78,0.5,0.8,0.5,0.82,0.5,0.84,0.5,0.86,0.5,0.88,0.5,0.9,0.5,0.92,0.5,0.94,0.5,0.96,0.5,0.98,0.5,0.99609,0.5,0.00391,0.51515,0.02,0.51515,0.04,0.51515,0.06,0.51515,0.08,0.51515,0.1,0.51515,0.12,0.51515,0.14,0.51515,0.16,0.51515,0.18,0.51515,0.2,0.51515,0.22,0.51515,0.24,0.51515,0.26,0.51515,0.28,0.51515,0.3,0.51515,0.32,0.51515,0.34,0.51515,0.36,0.51515,0.38,0.51515,0.4,0.51515,0.42,0.51515,0.44,0.51515,0.46,0.51515,0.48,0.51515,0.5,0.51515,0.52,0.51515,0.54,0.51515,0.56,0.51515,0.58,0.51515,0.6,0.51515,0.62,0.51515,0.64,0.51515,0.66,0.51515,0.68,0.51515,0.7,0.51515,0.72,0.51515,0.74,0.51515,0.76,0.51515,0.78,0.51515,0.8,0.51515,0.82,0.51515,0.84,0.51515,0.86,0.51515,0.88,0.51515,0.9,0.51515,0.92,0.51515,0.94,0.51515,0.96,0.51515,0.98,0.51515,0.99609,0.51515,0.00391,0.5303,0.02,0.5303,0.04,0.5303,0.06,0.5303,0.08,0.5303,0.1,0.5303,0.12,0.5303,0.14,0.5303,0.16,0.5303,0.18,0.5303,0.2,0.5303,0.22,0.5303,0.24,0.5303,0.26,0.5303,0.28,0.5303};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.3,0.5303,0.32,0.5303,0.34,0.5303,0.36,0.5303,0.38,0.5303,0.4,0.5303,0.42,0.5303,0.44,0.5303,0.46,0.5303,0.48,0.5303,0.5,0.5303,0.52,0.5303,0.54,0.5303,0.56,0.5303,0.58,0.5303,0.6,0.5303,0.62,0.5303,0.64,0.5303,0.66,0.5303,0.68,0.5303,0.7,0.5303,0.72,0.5303,0.74,0.5303,0.76,0.5303,0.78,0.5303,0.8,0.5303,0.82,0.5303,0.84,0.5303,0.86,0.5303,0.88,0.5303,0.9,0.5303,0.92,0.5303,0.94,0.5303,0.96,0.5303,0.98,0.5303,0.99609,0.5303,0.00391,0.54545,0.02,0.54545,0.04,0.54545,0.06,0.54545,0.08,0.54545,0.1,0.54545,0.12,0.54545,0.14,0.54545,0.16,0.54545,0.18,0.54545,0.2,0.54545,0.22,0.54545,0.24,0.54545,0.26,0.54545,0.28,0.54545,0.3,0.54545,0.32,0.54545,0.34,0.54545,0.36,0.54545,0.38,0.54545,0.4,0.54545,0.42,0.54545,0.44,0.54545,0.46,0.54545,0.48,0.54545,0.5,0.54545,0.52,0.54545,0.54,0.54545,0.56,0.54545,0.58,0.54545,0.6,0.54545,0.62,0.54545,0.64,0.54545,0.66,0.54545,0.68,0.54545,0.7,0.54545,0.72,0.54545,0.74,0.54545,0.76,0.54545,0.78,0.54545,0.8,0.54545,0.82,0.54545,0.84,0.54545,0.86,0.54545,0.88,0.54545,0.9,0.54545,0.92,0.54545,0.94,0.54545,0.96,0.54545,0.98,0.54545,0.99609,0.54545,0.00391,0.56061,0.02,0.56061,0.04,0.56061,0.06,0.56061,0.08,0.56061,0.1,0.56061,0.12,0.56061,0.14,0.56061,0.16,0.56061,0.18,0.56061,0.2,0.56061,0.22,0.56061,0.24,0.56061};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.26,0.56061,0.28,0.56061,0.3,0.56061,0.32,0.56061,0.34,0.56061,0.36,0.56061,0.38,0.56061,0.4,0.56061,0.42,0.56061,0.44,0.56061,0.46,0.56061,0.48,0.56061,0.5,0.56061,0.52,0.56061,0.54,0.56061,0.56,0.56061,0.58,0.56061,0.6,0.56061,0.62,0.56061,0.64,0.56061,0.66,0.56061,0.68,0.56061,0.7,0.56061,0.72,0.56061,0.74,0.56061,0.76,0.56061,0.78,0.56061,0.8,0.56061,0.82,0.56061,0.84,0.56061,0.86,0.56061,0.88,0.56061,0.9,0.56061,0.92,0.56061,0.94,0.56061,0.96,0.56061,0.98,0.56061,0.99609,0.56061,0.00391,0.57576,0.02,0.57576,0.04,0.57576,0.06,0.57576,0.08,0.57576,0.1,0.57576,0.12,0.57576,0.14,0.57576,0.16,0.57576,0.18,0.57576,0.2,0.57576,0.22,0.57576,0.24,0.57576,0.26,0.57576,0.28,0.57576,0.3,0.57576,0.32,0.57576,0.34,0.57576,0.36,0.57576,0.38,0.57576,0.4,0.57576,0.42,0.57576,0.44,0.57576,0.46,0.57576,0.48,0.57576,0.5,0.57576,0.52,0.57576,0.54,0.57576,0.56,0.57576,0.58,0.57576,0.6,0.57576,0.62,0.57576,0.64,0.57576,0.66,0.57576,0.68,0.57576,0.7,0.57576,0.72,0.57576,0.74,0.57576,0.76,0.57576,0.78,0.57576,0.8,0.57576,0.82,0.57576,0.84,0.57576,0.86,0.57576,0.88,0.57576,0.9,0.57576,0.92,0.57576,0.94,0.57576,0.96,0.57576,0.98,0.57576,0.99609,0.57576,0.00391,0.59091,0.02,0.59091,0.04,0.59091,0.06,0.59091,0.08,0.59091,0.1,0.59091,0.12,0.59091,0.14,0.59091,0.16,0.59091,0.18,0.59091,0.2,0.59091};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.22,0.59091,0.24,0.59091,0.26,0.59091,0.28,0.59091,0.3,0.59091,0.32,0.59091,0.34,0.59091,0.36,0.59091,0.38,0.59091,0.4,0.59091,0.42,0.59091,0.44,0.59091,0.46,0.59091,0.48,0.59091,0.5,0.59091,0.52,0.59091,0.54,0.59091,0.56,0.59091,0.58,0.59091,0.6,0.59091,0.62,0.59091,0.64,0.59091,0.66,0.59091,0.68,0.59091,0.7,0.59091,0.72,0.59091,0.74,0.59091,0.76,0.59091,0.78,0.59091,0.8,0.59091,0.82,0.59091,0.84,0.59091,0.86,0.59091,0.88,0.59091,0.9,0.59091,0.92,0.59091,0.94,0.59091,0.96,0.59091,0.98,0.59091,0.99609,0.59091,0.00391,0.60606,0.02,0.60606,0.04,0.60606,0.06,0.60606,0.08,0.60606,0.1,0.60606,0.12,0.60606,0.14,0.60606,0.16,0.60606,0.18,0.60606,0.2,0.60606,0.22,0.60606,0.24,0.60606,0.26,0.60606,0.28,0.60606,0.3,0.60606,0.32,0.60606,0.34,0.60606,0.36,0.60606,0.38,0.60606,0.4,0.60606,0.42,0.60606,0.44,0.60606,0.46,0.60606,0.48,0.60606,0.5,0.60606,0.52,0.60606,0.54,0.60606,0.56,0.60606,0.58,0.60606,0.6,0.60606,0.62,0.60606,0.64,0.60606,0.66,0.60606,0.68,0.60606,0.7,0.60606,0.72,0.60606,0.74,0.60606,0.76,0.60606,0.78,0.60606,0.8,0.60606,0.82,0.60606,0.84,0.60606,0.86,0.60606,0.88,0.60606,0.9,0.60606,0.92,0.60606,0.94,0.60606,0.96,0.60606,0.98,0.60606,0.99609,0.60606,0.00391,0.62121,0.02,0.62121,0.04,0.62121,0.06,0.62121,0.08,0.62121,0.1,0.62121,0.12,0.62121,0.14,0.62121,0.16,0.62121};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.18,0.62121,0.2,0.62121,0.22,0.62121,0.24,0.62121,0.26,0.62121,0.28,0.62121,0.3,0.62121,0.32,0.62121,0.34,0.62121,0.36,0.62121,0.38,0.62121,0.4,0.62121,0.42,0.62121,0.44,0.62121,0.46,0.62121,0.48,0.62121,0.5,0.62121,0.52,0.62121,0.54,0.62121,0.56,0.62121,0.58,0.62121,0.6,0.62121,0.62,0.62121,0.64,0.62121,0.66,0.62121,0.68,0.62121,0.7,0.62121,0.72,0.62121,0.74,0.62121,0.76,0.62121,0.78,0.62121,0.8,0.62121,0.82,0.62121,0.84,0.62121,0.86,0.62121,0.88,0.62121,0.9,0.62121,0.92,0.62121,0.94,0.62121,0.96,0.62121,0.98,0.62121,0.99609,0.62121,0.00391,0.63636,0.02,0.63636,0.04,0.63636,0.06,0.63636,0.08,0.63636,0.1,0.63636,0.12,0.63636,0.14,0.63636,0.16,0.63636,0.18,0.63636,0.2,0.63636,0.22,0.63636,0.24,0.63636,0.26,0.63636,0.28,0.63636,0.3,0.63636,0.32,0.63636,0.34,0.63636,0.36,0.63636,0.38,0.63636,0.4,0.63636,0.42,0.63636,0.44,0.63636,0.46,0.63636,0.48,0.63636,0.5,0.63636,0.52,0.63636,0.54,0.63636,0.56,0.63636,0.58,0.63636,0.6,0.63636,0.62,0.63636,0.64,0.63636,0.66,0.63636,0.68,0.63636,0.7,0.63636,0.72,0.63636,0.74,0.63636,0.76,0.63636,0.78,0.63636,0.8,0.63636,0.82,0.63636,0.84,0.63636,0.86,0.63636,0.88,0.63636,0.9,0.63636,0.92,0.63636,0.94,0.63636,0.96,0.63636,0.98,0.63636,0.99609,0.63636,0.00391,0.65152,0.02,0.65152,0.04,0.65152,0.06,0.65152,0.08,0.65152,0.1,0.65152,0.12,0.65152};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.14,0.65152,0.16,0.65152,0.18,0.65152,0.2,0.65152,0.22,0.65152,0.24,0.65152,0.26,0.65152,0.28,0.65152,0.3,0.65152,0.32,0.65152,0.34,0.65152,0.36,0.65152,0.38,0.65152,0.4,0.65152,0.42,0.65152,0.44,0.65152,0.46,0.65152,0.48,0.65152,0.5,0.65152,0.52,0.65152,0.54,0.65152,0.56,0.65152,0.58,0.65152,0.6,0.65152,0.62,0.65152,0.64,0.65152,0.66,0.65152,0.68,0.65152,0.7,0.65152,0.72,0.65152,0.74,0.65152,0.76,0.65152,0.78,0.65152,0.8,0.65152,0.82,0.65152,0.84,0.65152,0.86,0.65152,0.88,0.65152,0.9,0.65152,0.92,0.65152,0.94,0.65152,0.96,0.65152,0.98,0.65152,0.99609,0.65152,0.00391,0.66667,0.02,0.66667,0.04,0.66667,0.06,0.66667,0.08,0.66667,0.1,0.66667,0.12,0.66667,0.14,0.66667,0.16,0.66667,0.18,0.66667,0.2,0.66667,0.22,0.66667,0.24,0.66667,0.26,0.66667,0.28,0.66667,0.3,0.66667,0.32,0.66667,0.34,0.66667,0.36,0.66667,0.38,0.66667,0.4,0.66667,0.42,0.66667,0.44,0.66667,0.46,0.66667,0.48,0.66667,0.5,0.66667,0.52,0.66667,0.54,0.66667,0.56,0.66667,0.58,0.66667,0.6,0.66667,0.62,0.66667,0.64,0.66667,0.66,0.66667,0.68,0.66667,0.7,0.66667,0.72,0.66667,0.74,0.66667,0.76,0.66667,0.78,0.66667,0.8,0.66667,0.82,0.66667,0.84,0.66667,0.86,0.66667,0.88,0.66667,0.9,0.66667,0.92,0.66667,0.94,0.66667,0.96,0.66667,0.98,0.66667,0.99609,0.66667,0.00391,0.68182,0.02,0.68182,0.04,0.68182,0.06,0.68182,0.08,0.68182};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.1,0.68182,0.12,0.68182,0.14,0.68182,0.16,0.68182,0.18,0.68182,0.2,0.68182,0.22,0.68182,0.24,0.68182,0.26,0.68182,0.28,0.68182,0.3,0.68182,0.32,0.68182,0.34,0.68182,0.36,0.68182,0.38,0.68182,0.4,0.68182,0.42,0.68182,0.44,0.68182,0.46,0.68182,0.48,0.68182,0.5,0.68182,0.52,0.68182,0.54,0.68182,0.56,0.68182,0.58,0.68182,0.6,0.68182,0.62,0.68182,0.64,0.68182,0.66,0.68182,0.68,0.68182,0.7,0.68182,0.72,0.68182,0.74,0.68182,0.76,0.68182,0.78,0.68182,0.8,0.68182,0.82,0.68182,0.84,0.68182,0.86,0.68182,0.88,0.68182,0.9,0.68182,0.92,0.68182,0.94,0.68182,0.96,0.68182,0.98,0.68182,0.99609,0.68182,0.00391,0.69697,0.02,0.69697,0.04,0.69697,0.06,0.69697,0.08,0.69697,0.1,0.69697,0.12,0.69697,0.14,0.69697,0.16,0.69697,0.18,0.69697,0.2,0.69697,0.22,0.69697,0.24,0.69697,0.26,0.69697,0.28,0.69697,0.3,0.69697,0.32,0.69697,0.34,0.69697,0.36,0.69697,0.38,0.69697,0.4,0.69697,0.42,0.69697,0.44,0.69697,0.46,0.69697,0.48,0.69697,0.5,0.69697,0.52,0.69697,0.54,0.69697,0.56,0.69697,0.58,0.69697,0.6,0.69697,0.62,0.69697,0.64,0.69697,0.66,0.69697,0.68,0.69697,0.7,0.69697,0.72,0.69697,0.74,0.69697,0.76,0.69697,0.78,0.69697,0.8,0.69697,0.82,0.69697,0.84,0.69697,0.86,0.69697,0.88,0.69697,0.9,0.69697,0.92,0.69697,0.94,0.69697,0.96,0.69697,0.98,0.69697,0.99609,0.69697,0.00391,0.71212,0.02,0.71212,0.04,0.71212};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.06,0.71212,0.08,0.71212,0.1,0.71212,0.12,0.71212,0.14,0.71212,0.16,0.71212,0.18,0.71212,0.2,0.71212,0.22,0.71212,0.24,0.71212,0.26,0.71212,0.28,0.71212,0.3,0.71212,0.32,0.71212,0.34,0.71212,0.36,0.71212,0.38,0.71212,0.4,0.71212,0.42,0.71212,0.44,0.71212,0.46,0.71212,0.48,0.71212,0.5,0.71212,0.52,0.71212,0.54,0.71212,0.56,0.71212,0.58,0.71212,0.6,0.71212,0.62,0.71212,0.64,0.71212,0.66,0.71212,0.68,0.71212,0.7,0.71212,0.72,0.71212,0.74,0.71212,0.76,0.71212,0.78,0.71212,0.8,0.71212,0.82,0.71212,0.84,0.71212,0.86,0.71212,0.88,0.71212,0.9,0.71212,0.92,0.71212,0.94,0.71212,0.96,0.71212,0.98,0.71212,0.99609,0.71212,0.00391,0.72727,0.02,0.72727,0.04,0.72727,0.06,0.72727,0.08,0.72727,0.1,0.72727,0.12,0.72727,0.14,0.72727,0.16,0.72727,0.18,0.72727,0.2,0.72727,0.22,0.72727,0.24,0.72727,0.26,0.72727,0.28,0.72727,0.3,0.72727,0.32,0.72727,0.34,0.72727,0.36,0.72727,0.38,0.72727,0.4,0.72727,0.42,0.72727,0.44,0.72727,0.46,0.72727,0.48,0.72727,0.5,0.72727,0.52,0.72727,0.54,0.72727,0.56,0.72727,0.58,0.72727,0.6,0.72727,0.62,0.72727,0.64,0.72727,0.66,0.72727,0.68,0.72727,0.7,0.72727,0.72,0.72727,0.74,0.72727,0.76,0.72727,0.78,0.72727,0.8,0.72727,0.82,0.72727,0.84,0.72727,0.86,0.72727,0.88,0.72727,0.9,0.72727,0.92,0.72727,0.94,0.72727,0.96,0.72727,0.98,0.72727,0.99609,0.72727,0.00391,0.74242};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.02,0.74242,0.04,0.74242,0.06,0.74242,0.08,0.74242,0.1,0.74242,0.12,0.74242,0.14,0.74242,0.16,0.74242,0.18,0.74242,0.2,0.74242,0.22,0.74242,0.24,0.74242,0.26,0.74242,0.28,0.74242,0.3,0.74242,0.32,0.74242,0.34,0.74242,0.36,0.74242,0.38,0.74242,0.4,0.74242,0.42,0.74242,0.44,0.74242,0.46,0.74242,0.48,0.74242,0.5,0.74242,0.52,0.74242,0.54,0.74242,0.56,0.74242,0.58,0.74242,0.6,0.74242,0.62,0.74242,0.64,0.74242,0.66,0.74242,0.68,0.74242,0.7,0.74242,0.72,0.74242,0.74,0.74242,0.76,0.74242,0.78,0.74242,0.8,0.74242,0.82,0.74242,0.84,0.74242,0.86,0.74242,0.88,0.74242,0.9,0.74242,0.92,0.74242,0.94,0.74242,0.96,0.74242,0.98,0.74242,0.99609,0.74242,0.00391,0.75758,0.02,0.75758,0.04,0.75758,0.06,0.75758,0.08,0.75758,0.1,0.75758,0.12,0.75758,0.14,0.75758,0.16,0.75758,0.18,0.75758,0.2,0.75758,0.22,0.75758,0.24,0.75758,0.26,0.75758,0.28,0.75758,0.3,0.75758,0.32,0.75758,0.34,0.75758,0.36,0.75758,0.38,0.75758,0.4,0.75758,0.42,0.75758,0.44,0.75758,0.46,0.75758,0.48,0.75758,0.5,0.75758,0.52,0.75758,0.54,0.75758,0.56,0.75758,0.58,0.75758,0.6,0.75758,0.62,0.75758,0.64,0.75758,0.66,0.75758,0.68,0.75758,0.7,0.75758,0.72,0.75758,0.74,0.75758,0.76,0.75758,0.78,0.75758,0.8,0.75758,0.82,0.75758,0.84,0.75758,0.86,0.75758,0.88,0.75758,0.9,0.75758,0.92,0.75758,0.94,0.75758,0.96,0.75758,0.98,0.75758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.99609,0.75758,0.00391,0.77273,0.02,0.77273,0.04,0.77273,0.06,0.77273,0.08,0.77273,0.1,0.77273,0.12,0.77273,0.14,0.77273,0.16,0.77273,0.18,0.77273,0.2,0.77273,0.22,0.77273,0.24,0.77273,0.26,0.77273,0.28,0.77273,0.3,0.77273,0.32,0.77273,0.34,0.77273,0.36,0.77273,0.38,0.77273,0.4,0.77273,0.42,0.77273,0.44,0.77273,0.46,0.77273,0.48,0.77273,0.5,0.77273,0.52,0.77273,0.54,0.77273,0.56,0.77273,0.58,0.77273,0.6,0.77273,0.62,0.77273,0.64,0.77273,0.66,0.77273,0.68,0.77273,0.7,0.77273,0.72,0.77273,0.74,0.77273,0.76,0.77273,0.78,0.77273,0.8,0.77273,0.82,0.77273,0.84,0.77273,0.86,0.77273,0.88,0.77273,0.9,0.77273,0.92,0.77273,0.94,0.77273,0.96,0.77273,0.98,0.77273,0.99609,0.77273,0.00391,0.78788,0.02,0.78788,0.04,0.78788,0.06,0.78788,0.08,0.78788,0.1,0.78788,0.12,0.78788,0.14,0.78788,0.16,0.78788,0.18,0.78788,0.2,0.78788,0.22,0.78788,0.24,0.78788,0.26,0.78788,0.28,0.78788,0.3,0.78788,0.32,0.78788,0.34,0.78788,0.36,0.78788,0.38,0.78788,0.4,0.78788,0.42,0.78788,0.44,0.78788,0.46,0.78788,0.48,0.78788,0.5,0.78788,0.52,0.78788,0.54,0.78788,0.56,0.78788,0.58,0.78788,0.6,0.78788,0.62,0.78788,0.64,0.78788,0.66,0.78788,0.68,0.78788,0.7,0.78788,0.72,0.78788,0.74,0.78788,0.76,0.78788,0.78,0.78788,0.8,0.78788,0.82,0.78788,0.84,0.78788,0.86,0.78788,0.88,0.78788,0.9,0.78788,0.92,0.78788,0.94,0.78788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.96,0.78788,0.98,0.78788,0.99609,0.78788,0.00391,0.80303,0.02,0.80303,0.04,0.80303,0.06,0.80303,0.08,0.80303,0.1,0.80303,0.12,0.80303,0.14,0.80303,0.16,0.80303,0.18,0.80303,0.2,0.80303,0.22,0.80303,0.24,0.80303,0.26,0.80303,0.28,0.80303,0.3,0.80303,0.32,0.80303,0.34,0.80303,0.36,0.80303,0.38,0.80303,0.4,0.80303,0.42,0.80303,0.44,0.80303,0.46,0.80303,0.48,0.80303,0.5,0.80303,0.52,0.80303,0.54,0.80303,0.56,0.80303,0.58,0.80303,0.6,0.80303,0.62,0.80303,0.64,0.80303,0.66,0.80303,0.68,0.80303,0.7,0.80303,0.72,0.80303,0.74,0.80303,0.76,0.80303,0.78,0.80303,0.8,0.80303,0.82,0.80303,0.84,0.80303,0.86,0.80303,0.88,0.80303,0.9,0.80303,0.92,0.80303,0.94,0.80303,0.96,0.80303,0.98,0.80303,0.99609,0.80303,0.00391,0.81818,0.02,0.81818,0.04,0.81818,0.06,0.81818,0.08,0.81818,0.1,0.81818,0.12,0.81818,0.14,0.81818,0.16,0.81818,0.18,0.81818,0.2,0.81818,0.22,0.81818,0.24,0.81818,0.26,0.81818,0.28,0.81818,0.3,0.81818,0.32,0.81818,0.34,0.81818,0.36,0.81818,0.38,0.81818,0.4,0.81818,0.42,0.81818,0.44,0.81818,0.46,0.81818,0.48,0.81818,0.5,0.81818,0.52,0.81818,0.54,0.81818,0.56,0.81818,0.58,0.81818,0.6,0.81818,0.62,0.81818,0.64,0.81818,0.66,0.81818,0.68,0.81818,0.7,0.81818,0.72,0.81818,0.74,0.81818,0.76,0.81818,0.78,0.81818,0.8,0.81818,0.82,0.81818,0.84,0.81818,0.86,0.81818,0.88,0.81818,0.9,0.81818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.92,0.81818,0.94,0.81818,0.96,0.81818,0.98,0.81818,0.99609,0.81818,0.00391,0.83333,0.02,0.83333,0.04,0.83333,0.06,0.83333,0.08,0.83333,0.1,0.83333,0.12,0.83333,0.14,0.83333,0.16,0.83333,0.18,0.83333,0.2,0.83333,0.22,0.83333,0.24,0.83333,0.26,0.83333,0.28,0.83333,0.3,0.83333,0.32,0.83333,0.34,0.83333,0.36,0.83333,0.38,0.83333,0.4,0.83333,0.42,0.83333,0.44,0.83333,0.46,0.83333,0.48,0.83333,0.5,0.83333,0.52,0.83333,0.54,0.83333,0.56,0.83333,0.58,0.83333,0.6,0.83333,0.62,0.83333,0.64,0.83333,0.66,0.83333,0.68,0.83333,0.7,0.83333,0.72,0.83333,0.74,0.83333,0.76,0.83333,0.78,0.83333,0.8,0.83333,0.82,0.83333,0.84,0.83333,0.86,0.83333,0.88,0.83333,0.9,0.83333,0.92,0.83333,0.94,0.83333,0.96,0.83333,0.98,0.83333,0.99609,0.83333,0.00391,0.84848,0.02,0.84848,0.04,0.84848,0.06,0.84848,0.08,0.84848,0.1,0.84848,0.12,0.84848,0.14,0.84848,0.16,0.84848,0.18,0.84848,0.2,0.84848,0.22,0.84848,0.24,0.84848,0.26,0.84848,0.28,0.84848,0.3,0.84848,0.32,0.84848,0.34,0.84848,0.36,0.84848,0.38,0.84848,0.4,0.84848,0.42,0.84848,0.44,0.84848,0.46,0.84848,0.48,0.84848,0.5,0.84848,0.52,0.84848,0.54,0.84848,0.56,0.84848,0.58,0.84848,0.6,0.84848,0.62,0.84848,0.64,0.84848,0.66,0.84848,0.68,0.84848,0.7,0.84848,0.72,0.84848,0.74,0.84848,0.76,0.84848,0.78,0.84848,0.8,0.84848,0.82,0.84848,0.84,0.84848,0.86,0.84848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.88,0.84848,0.9,0.84848,0.92,0.84848,0.94,0.84848,0.96,0.84848,0.98,0.84848,0.99609,0.84848,0.00391,0.86364,0.02,0.86364,0.04,0.86364,0.06,0.86364,0.08,0.86364,0.1,0.86364,0.12,0.86364,0.14,0.86364,0.16,0.86364,0.18,0.86364,0.2,0.86364,0.22,0.86364,0.24,0.86364,0.26,0.86364,0.28,0.86364,0.3,0.86364,0.32,0.86364,0.34,0.86364,0.36,0.86364,0.38,0.86364,0.4,0.86364,0.42,0.86364,0.44,0.86364,0.46,0.86364,0.48,0.86364,0.5,0.86364,0.52,0.86364,0.54,0.86364,0.56,0.86364,0.58,0.86364,0.6,0.86364,0.62,0.86364,0.64,0.86364,0.66,0.86364,0.68,0.86364,0.7,0.86364,0.72,0.86364,0.74,0.86364,0.76,0.86364,0.78,0.86364,0.8,0.86364,0.82,0.86364,0.84,0.86364,0.86,0.86364,0.88,0.86364,0.9,0.86364,0.92,0.86364,0.94,0.86364,0.96,0.86364,0.98,0.86364,0.99609,0.86364,0.00391,0.87879,0.02,0.87879,0.04,0.87879,0.06,0.87879,0.08,0.87879,0.1,0.87879,0.12,0.87879,0.14,0.87879,0.16,0.87879,0.18,0.87879,0.2,0.87879,0.22,0.87879,0.24,0.87879,0.26,0.87879,0.28,0.87879,0.3,0.87879,0.32,0.87879,0.34,0.87879,0.36,0.87879,0.38,0.87879,0.4,0.87879,0.42,0.87879,0.44,0.87879,0.46,0.87879,0.48,0.87879,0.5,0.87879,0.52,0.87879,0.54,0.87879,0.56,0.87879,0.58,0.87879,0.6,0.87879,0.62,0.87879,0.64,0.87879,0.66,0.87879,0.68,0.87879,0.7,0.87879,0.72,0.87879,0.74,0.87879,0.76,0.87879,0.78,0.87879,0.8,0.87879,0.82,0.87879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.84,0.87879,0.86,0.87879,0.88,0.87879,0.9,0.87879,0.92,0.87879,0.94,0.87879,0.96,0.87879,0.98,0.87879,0.99609,0.87879,0.00391,0.89394,0.02,0.89394,0.04,0.89394,0.06,0.89394,0.08,0.89394,0.1,0.89394,0.12,0.89394,0.14,0.89394,0.16,0.89394,0.18,0.89394,0.2,0.89394,0.22,0.89394,0.24,0.89394,0.26,0.89394,0.28,0.89394,0.3,0.89394,0.32,0.89394,0.34,0.89394,0.36,0.89394,0.38,0.89394,0.4,0.89394,0.42,0.89394,0.44,0.89394,0.46,0.89394,0.48,0.89394,0.5,0.89394,0.52,0.89394,0.54,0.89394,0.56,0.89394,0.58,0.89394,0.6,0.89394,0.62,0.89394,0.64,0.89394,0.66,0.89394,0.68,0.89394,0.7,0.89394,0.72,0.89394,0.74,0.89394,0.76,0.89394,0.78,0.89394,0.8,0.89394,0.82,0.89394,0.84,0.89394,0.86,0.89394,0.88,0.89394,0.9,0.89394,0.92,0.89394,0.94,0.89394,0.96,0.89394,0.98,0.89394,0.99609,0.89394,0.00391,0.90909,0.02,0.90909,0.04,0.90909,0.06,0.90909,0.08,0.90909,0.1,0.90909,0.12,0.90909,0.14,0.90909,0.16,0.90909,0.18,0.90909,0.2,0.90909,0.22,0.90909,0.24,0.90909,0.26,0.90909,0.28,0.90909,0.3,0.90909,0.32,0.90909,0.34,0.90909,0.36,0.90909,0.38,0.90909,0.4,0.90909,0.42,0.90909,0.44,0.90909,0.46,0.90909,0.48,0.90909,0.5,0.90909,0.52,0.90909,0.54,0.90909,0.56,0.90909,0.58,0.90909,0.6,0.90909,0.62,0.90909,0.64,0.90909,0.66,0.90909,0.68,0.90909,0.7,0.90909,0.72,0.90909,0.74,0.90909,0.76,0.90909,0.78,0.90909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.8,0.90909,0.82,0.90909,0.84,0.90909,0.86,0.90909,0.88,0.90909,0.9,0.90909,0.92,0.90909,0.94,0.90909,0.96,0.90909,0.98,0.90909,0.99609,0.90909,0.00391,0.92424,0.02,0.92424,0.04,0.92424,0.06,0.92424,0.08,0.92424,0.1,0.92424,0.12,0.92424,0.14,0.92424,0.16,0.92424,0.18,0.92424,0.2,0.92424,0.22,0.92424,0.24,0.92424,0.26,0.92424,0.28,0.92424,0.3,0.92424,0.32,0.92424,0.34,0.92424,0.36,0.92424,0.38,0.92424,0.4,0.92424,0.42,0.92424,0.44,0.92424,0.46,0.92424,0.48,0.92424,0.5,0.92424,0.52,0.92424,0.54,0.92424,0.56,0.92424,0.58,0.92424,0.6,0.92424,0.62,0.92424,0.64,0.92424,0.66,0.92424,0.68,0.92424,0.7,0.92424,0.72,0.92424,0.74,0.92424,0.76,0.92424,0.78,0.92424,0.8,0.92424,0.82,0.92424,0.84,0.92424,0.86,0.92424,0.88,0.92424,0.9,0.92424,0.92,0.92424,0.94,0.92424,0.96,0.92424,0.98,0.92424,0.99609,0.92424,0.00391,0.93939,0.02,0.93939,0.04,0.93939,0.06,0.93939,0.08,0.93939,0.1,0.93939,0.12,0.93939,0.14,0.93939,0.16,0.93939,0.18,0.93939,0.2,0.93939,0.22,0.93939,0.24,0.93939,0.26,0.93939,0.28,0.93939,0.3,0.93939,0.32,0.93939,0.34,0.93939,0.36,0.93939,0.38,0.93939,0.4,0.93939,0.42,0.93939,0.44,0.93939,0.46,0.93939,0.48,0.93939,0.5,0.93939,0.52,0.93939,0.54,0.93939,0.56,0.93939,0.58,0.93939,0.6,0.93939,0.62,0.93939,0.64,0.93939,0.66,0.93939,0.68,0.93939,0.7,0.93939,0.72,0.93939,0.74,0.93939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.76,0.93939,0.78,0.93939,0.8,0.93939,0.82,0.93939,0.84,0.93939,0.86,0.93939,0.88,0.93939,0.9,0.93939,0.92,0.93939,0.94,0.93939,0.96,0.93939,0.98,0.93939,0.99609,0.93939,0.00391,0.95455,0.02,0.95455,0.04,0.95455,0.06,0.95455,0.08,0.95455,0.1,0.95455,0.12,0.95455,0.14,0.95455,0.16,0.95455,0.18,0.95455,0.2,0.95455,0.22,0.95455,0.24,0.95455,0.26,0.95455,0.28,0.95455,0.3,0.95455,0.32,0.95455,0.34,0.95455,0.36,0.95455,0.38,0.95455,0.4,0.95455,0.42,0.95455,0.44,0.95455,0.46,0.95455,0.48,0.95455,0.5,0.95455,0.52,0.95455,0.54,0.95455,0.56,0.95455,0.58,0.95455,0.6,0.95455,0.62,0.95455,0.64,0.95455,0.66,0.95455,0.68,0.95455,0.7,0.95455,0.72,0.95455,0.74,0.95455,0.76,0.95455,0.78,0.95455,0.8,0.95455,0.82,0.95455,0.84,0.95455,0.86,0.95455,0.88,0.95455,0.9,0.95455,0.92,0.95455,0.94,0.95455,0.96,0.95455,0.98,0.95455,0.99609,0.95455,0.00391,0.9697,0.02,0.9697,0.04,0.9697,0.06,0.9697,0.08,0.9697,0.1,0.9697,0.12,0.9697,0.14,0.9697,0.16,0.9697,0.18,0.9697,0.2,0.9697,0.22,0.9697,0.24,0.9697,0.26,0.9697,0.28,0.9697,0.3,0.9697,0.32,0.9697,0.34,0.9697,0.36,0.9697,0.38,0.9697,0.4,0.9697,0.42,0.9697,0.44,0.9697,0.46,0.9697,0.48,0.9697,0.5,0.9697,0.52,0.9697,0.54,0.9697,0.56,0.9697,0.58,0.9697,0.6,0.9697,0.62,0.9697,0.64,0.9697,0.66,0.9697,0.68,0.9697,0.7,0.9697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.72,0.9697,0.74,0.9697,0.76,0.9697,0.78,0.9697,0.8,0.9697,0.82,0.9697,0.84,0.9697,0.86,0.9697,0.88,0.9697,0.9,0.9697,0.92,0.9697,0.94,0.9697,0.96,0.9697,0.98,0.9697,0.99609,0.9697,0.00391,0.98485,0.02,0.98485,0.04,0.98485,0.06,0.98485,0.08,0.98485,0.1,0.98485,0.12,0.98485,0.14,0.98485,0.16,0.98485,0.18,0.98485,0.2,0.98485,0.22,0.98485,0.24,0.98485,0.26,0.98485,0.28,0.98485,0.3,0.98485,0.32,0.98485,0.34,0.98485,0.36,0.98485,0.38,0.98485,0.4,0.98485,0.42,0.98485,0.44,0.98485,0.46,0.98485,0.48,0.98485,0.5,0.98485,0.52,0.98485,0.54,0.98485,0.56,0.98485,0.58,0.98485,0.6,0.98485,0.62,0.98485,0.64,0.98485,0.66,0.98485,0.68,0.98485,0.7,0.98485,0.72,0.98485,0.74,0.98485,0.76,0.98485,0.78,0.98485,0.8,0.98485,0.82,0.98485,0.84,0.98485,0.86,0.98485,0.88,0.98485,0.9,0.98485,0.92,0.98485,0.94,0.98485,0.96,0.98485,0.98,0.98485,0.99609,0.98485,0.00391,0.99609,0.02,0.99609,0.04,0.99609,0.06,0.99609,0.08,0.99609,0.1,0.99609,0.12,0.99609,0.14,0.99609,0.16,0.99609,0.18,0.99609,0.2,0.99609,0.22,0.99609,0.24,0.99609,0.26,0.99609,0.28,0.99609,0.3,0.99609,0.32,0.99609,0.34,0.99609,0.36,0.99609,0.38,0.99609,0.4,0.99609,0.42,0.99609,0.44,0.99609,0.46,0.99609,0.48,0.99609,0.5,0.99609,0.52,0.99609,0.54,0.99609,0.56,0.99609,0.58,0.99609,0.6,0.99609,0.62,0.99609,0.64,0.99609,0.66,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.68,0.99609,0.7,0.99609,0.72,0.99609,0.74,0.99609,0.76,0.99609,0.78,0.99609,0.8,0.99609,0.82,0.99609,0.84,0.99609,0.86,0.99609,0.88,0.99609,0.9,0.99609,0.92,0.99609,0.94,0.99609,0.96,0.99609,0.98,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 3417 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 6834 total numbers made up of 3417 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD011 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD011().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD011\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD011 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD011_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD011_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD011_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD011_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
