package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD009Index.html" target="_blank">SquawLOD009</a>,  source <a href="../../../Geospatial/SquawLOD009.java">SquawLOD009.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD009.x3d">SquawLOD009.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD009.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD009.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD009
{
	/** Default constructor to create this object. */
	public SquawLOD009 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD009.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD009.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD009.x3d"))
    .addChild(new GeoLOD().setCenter(4342525.411173,739385.999947,2079.000000).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw004.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw004.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4341718.744506,738776.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(51).setXSpacing(24.360000).setZDimension(67).setZSpacing(24.444444).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {1944.7845,1947.3246,1951.6718,1955.8462,1959.6233,1955.1619,1946.3964,1948.7786,1960.446,1967.0781,1970.2902,1972.6301,1973.6301,1974.6301,1973.8859,1973.4702,1978.9061,1980.4998,1982.7877,1983.3717,1983.7877,1983.9453,1984.7877,1984.9453,1984.9453,1984.5878,1983.6875,1982.5696,1979.8518,1967.4316,1973.4703,1982.0781,1985.8822,1989.4265,1992.9117,1995.3478,1997.7837,2000.1516,1997.6207,2003.5422,2009.1102,2012.8062,2015.2422,2018.6782,2021.6794,2024.5502,2027.6863,2028.6301,2027.2446,2024.987,2022.3308,1936.2533,1940.448,1943.7407,1946.7747,1950.2107,1950.9645,1941.2029,1940.4586,1952.7495,1959.3906,1961.5488,1962.6378,1963.2731,1963.8889,1961.8031,1962.1755,1966.6094,1968.3231,1969.6111,1970.6111,1971.6111,1972.2183,1972.6111,1973.3334,1973.3334,1973.1888,1971.874,1971.2614,1967.9504,1958.2952,1962.789,1971.5209,1976.1409,1978.5769,1981.7351,1984.3267,1986.8849,1988.2991,1985.4078,1993.7164,1998.1633,2001.8359,2004.9429,2007.9716,2011.3729,2014.5311,2017.146,2018.6111,2018.8889};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2017.2249,2013.8889,1928.4694,1932.3191,1936.0054,1938.4413,1941.1111,1941.9778,1938.4691,1937.0796,1947.7733,1951.8334,1952.0167,1952.1111,1952.2589,1952.3889,1949.3031,1951.3088,1955.1877,1956.3088,1957.3889,1958.3889,1959.3889,1959.5155,1960.3889,1960.3889,1960.3889,1960.1111,1959.4751,1959.0391,1955.2318,1948.6831,1953.4589,1962.3324,1966.3632,1968.7991,1971.2351,1973.6711,1975.3878,1976.2689,1974.3889,1983.1902,1987.6633,1991.2871,1994.4429,1997.4716,2001.0791,2004.0311,2006.4672,2007.9031,2009.1111,2007.9675,2003.711,1921.552,1924.8494,1927.534,1930.108,1932.3407,1932.42,1931.014,1933.664,1939.2073,1941.3334,1942.1666,1942.3334,1942.3334,1942.3334,1938.064,1941.2,1943.4426,1944.8787,1946.1666,1946.3334,1947.3334,1947.7893,1948.3334,1949.1666,1949.3334,1950.1666,1949.6367,1948.0946,1945.7433,1944.5,1947.0934,1951.9653,1955.4187,1957.8546,1960.0206,1961.7267,1964.1627,1963.6627,1964.972,1972.1947,1976.8134,1980.372,1983.4553,1986.4214,1989.6506,1993.0867,1995.5227};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {1997.9586,1999.0,1997.5027,1995.8667,1913.899,1916.9027,1919.3386,1922.7747,1924.1838,1924.6866,1923.4215,1927.5187,1929.65,1930.6427,1930.9445,1931.5555,1931.5555,1930.9445,1927.3087,1930.3955,1932.1132,1933.3795,1934.6132,1935.5284,1936.9445,1937.5555,1937.9445,1938.3551,1937.9445,1937.9445,1937.6971,1936.4835,1935.866,1937.1666,1937.9266,1941.484,1943.4873,1944.7538,1946.3334,1947.8933,1949.3334,1948.6084,1954.2844,1961.0089,1965.4244,1969.1205,1971.9304,1974.9924,1978.2278,1980.8645,1983.9115,1984.9445,1985.9445,1985.2974,1989.4055,1910.2181,1911.9445,1913.1165,1914.8889,1916.8358,1916.8622,1916.8049,1919.8334,1919.7778,1919.7778,1920.7589,1920.7778,1920.7778,1919.8098,1915.6107,1918.4578,1920.7222,1921.7062,1922.7222,1923.3063,1923.7411,1924.692,1925.5647,1925.7222,1925.6798,1925.6777,1924.8131,1924.9053,1927.8767,1929.7804,1930.1578,1930.7324,1929.7222,1930.372,1931.7838,1933.1956,1935.607,1935.4916,1942.3262,1948.2747,1953.1466,1957.0742,1960.9462,1964.7728,1967.2887};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {1969.6978,1972.1338,1974.5698,1975.3345,1975.1982,1981.0278,1906.6239,1909.736,1911.5,1912.304,1912.5,1912.5,1913.416,1913.824,1913.106,1912.5,1912.5,1913.0,1912.734,1912.016,1910.596,1910.08,1908.5,1908.856,1909.648,1910.5,1911.5,1912.228,1912.946,1914.0,1913.5,1913.2,1916.136,1919.072,1921.508,1922.5,1922.5,1921.184,1919.0,1919.0,1920.0,1920.78,1921.0,1923.512,1928.736,1933.26,1938.48,1943.764,1947.918,1951.596,1955.968,1959.38,1961.856,1963.896,1964.772,1965.824,1971.7,1906.3292,1908.7915,1910.0095,1910.6298,1911.0555,1911.0555,1912.0,1912.0,1911.2557,1911.0555,1911.0555,1910.9596,1909.5531,1908.1414,1905.7072,1902.4312,1901.0,1900.0555,1900.1194,1901.1436,1901.2222,1901.2222,1901.2222,1904.5502,1907.6653,1909.0667,1910.7471,1913.1831,1915.1393,1916.1636,1914.7866,1913.3507,1912.0555,1912.0555,1912.1111,1912.1422,1910.2262,1912.1102,1915.194,1919.5986,1923.8134,1928.6951,1933.5574};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {1938.4266,1942.7617,1946.1978,1949.6338,1952.8618,1950.8773,1954.2698,1959.3778,1905.3119,1907.3472,1908.6111,1908.8475,1909.6111,1909.6111,1909.6111,1909.6111,1909.6111,1909.6111,1908.6111,1907.6111,1906.0791,1903.6431,1901.3643,1900.6733,1898.8927,1897.7231,1897.4631,1897.2222,1896.2023,1895.8334,1896.1802,1898.8782,1902.842,1904.8112,1906.8583,1908.6552,1910.2222,1910.7991,1910.0745,1908.7235,1907.5131,1907.2222,1906.2222,1905.2222,1902.2286,1900.6111,1903.2318,1907.4778,1911.0834,1915.3391,1919.5167,1924.7627,1930.0236,1933.9445,1936.8004,1938.8475,1939.4445,1944.2529,1948.1945,1905.0,1906.1227,1907.0287,1907.6733,1908.0073,1908.1666,1908.1666,1908.108,1908.0353,1907.8134,1907.1666,1905.92,1903.6346,1901.2253,1900.6633,1899.1666,1897.8906,1896.4066,1895.0187,1893.5826,1890.33,1889.3334,1891.2253,1894.5493,1897.2246,1900.5333,1902.9694,1904.3933,1905.3334,1905.3334,1905.27,1903.5173,1903.3334,1902.6454,1901.3126,1900.24,1898.3373,1897.1666,1898.2013,1898.7533,1900.4066};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1904.156,1908.2787,1911.7307,1915.968,1920.84,1926.0227,1928.4586,1930.0847,1934.164,1936.7833,1904.0,1904.9266,1905.77,1906.4391,1906.7222,1906.7222,1906.7222,1906.7222,1906.7222,1905.9377,1905.2456,1904.6528,1903.1902,1901.0231,1899.596,1898.1156,1896.9233,1895.288,1893.852,1891.7164,1889.2722,1888.1511,1887.7222,1889.0502,1892.2085,1894.789,1897.8026,1899.2386,1900.3077,1901.1262,1900.3389,1898.6284,1897.9846,1897.4445,1896.4445,1895.7622,1894.7251,1894.1324,1893.4811,1891.8364,1889.9789,1892.9631,1898.1129,1901.9369,1904.7224,1907.7866,1911.066,1913.5369,1921.1305,1926.2169,1928.2667,1903.0867,1904.0,1905.0,1905.0,1905.2778,1905.2778,1905.2778,1905.2778,1905.0,1905.0,1904.0945,1903.2511,1902.13,1901.0,1899.0,1897.3933,1896.2012,1894.5658,1892.8931,1891.416,1889.98,1888.544,1887.0,1887.2778,1888.0417,1889.7556,1891.2927,1892.8854,1894.2002,1894.8177,1894.2811,1893.5555,1891.8334,1891.5555,1891.5555,1891.5555,1891.2789,1890.4355,1889.4098};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1887.9738,1885.5555,1886.4537,1889.0598,1891.8947,1894.2456,1896.3088,1900.5453,1906.4174,1911.8469,1914.9596,1918.4889,1901.8854,1902.956,1903.8334,1903.9347,1904.0,1904.0,1903.8473,1903.8334,1903.8334,1902.9626,1902.8334,1901.7533,1900.9114,1899.8386,1898.4967,1897.0,1894.954,1894.0,1892.71,1891.0,1889.98,1888.544,1887.0,1885.0,1885.8334,1886.8334,1887.4694,1887.8933,1888.8334,1888.8334,1888.8334,1888.8334,1887.8334,1888.0,1888.8334,1888.8334,1888.8334,1887.928,1887.8334,1885.276,1883.0,1883.8334,1885.7687,1886.8733,1887.8334,1888.7533,1894.7346,1901.0427,1905.1227,1908.3307,1910.5167,1901.1213,1901.8386,1902.3889,1902.3889,1902.3889,1902.3889,1902.3889,1902.3889,1902.0,1901.3889,1901.0,1900.3889,1899.6749,1898.4084,1897.2318,1896.16,1894.724,1893.288,1891.9095,1890.416,1889.0,1888.8226,1886.7191,1884.672,1883.5331,1883.5889,1884.3889,1885.3889,1886.0883,1886.3889,1886.3889,1886.3889,1886.3889,1886.3889,1887.0,1887.0,1886.3914};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1886.3889,1885.5209,1883.2706,1882.3889,1882.0685,1883.238,1884.3889,1885.6847,1887.3578,1890.2394,1896.3618,1900.0945,1902.8307,1904.8167,1900.9618,1901.0,1901.0,1901.0,1901.0,1901.0,1901.0,1901.0,1901.0,1900.9445,1899.9634,1898.9946,1898.4125,1897.0,1896.5298,1895.1045,1893.724,1892.9604,1891.852,1890.393,1889.0,1888.9746,1888.0,1885.7275,1884.0131,1883.0,1883.0,1883.0,1883.4797,1883.9445,1883.3589,1883.7706,1884.0,1884.6498,1884.9445,1884.9756,1885.0,1884.9684,1884.0,1883.0,1882.26,1882.0,1882.578,1882.9471,1884.4285,1886.8645,1888.356,1891.7249,1895.3878,1897.6084,1898.9889,1900.0,1900.368,1900.5,1901.0,1901.0,1901.0,1900.5,1900.5,1900.106,1899.888,1899.0,1897.952,1897.0,1895.532,1894.5,1894.08,1893.0,1892.288,1891.0,1890.0,1889.0,1888.544,1888.0,1887.0,1886.0,1884.3,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.5};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1883.5,1883.5,1884.0,1883.5,1883.0,1882.26,1882.0,1882.0,1882.0,1883.242,1885.42,1887.356,1889.292,1891.342,1893.832,1895.0,1899.0173,1899.0555,1900.0,1900.0,1900.0,1900.0,1900.0,1899.0555,1899.0117,1898.7885,1898.34,1897.0502,1896.468,1895.0303,1894.0,1893.16,1893.0,1892.0,1891.0,1890.0,1889.0,1888.544,1888.0,1887.0,1886.236,1885.9445,1884.9445,1883.9445,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1882.26,1882.0,1882.0,1882.0,1882.484,1883.9756,1886.3917,1887.8036,1889.0127,1890.0924,1890.1111,1897.7324,1898.0,1898.6111,1898.6111,1898.6111,1898.6111,1898.0514,1897.8632,1897.6111,1897.4742,1897.0,1896.5525,1895.7931,1895.0,1894.0,1893.0623,1892.4425,1892.0,1890.9425,1890.0,1889.0,1888.544,1888.0,1887.0,1887.0,1886.0,1885.3889,1884.3889,1884.3889,1883.4231,1883.2411,1883.0,1883.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1882.26,1882.0,1882.0,1882.0,1882.0,1883.5623,1885.356,1886.9191,1887.6111,1887.8694,1888.0612,1897.0,1897.0,1897.1666,1897.1666,1897.1666,1897.1666,1897.1666,1897.0,1896.3434,1896.1293,1896.0,1896.0,1896.0,1895.0,1894.0,1893.16,1892.954,1891.288,1890.142,1889.5133,1889.0,1888.0,1888.0,1887.0,1887.0,1886.0,1886.0,1885.7733,1885.0,1885.0,1884.8334,1883.864,1883.8334,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1882.26,1882.0,1882.0,1882.0,1882.0,1882.92,1884.4634,1885.1666,1886.1666,1886.1666,1887.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1896.2778,1896.2778,1896.9307,1896.13,1895.3009,1894.8738,1894.2778,1894.0018,1892.288,1890.2367,1889.2778,1889.0,1888.6707,1888.03,1887.7631,1887.0,1887.0,1886.2778,1886.0,1886.0,1886.0,1885.5522};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {1885.2778,1884.818,1884.0867,1883.0,1883.0,1883.0,1883.0,1883.0,1883.0,1882.4656,1882.0,1882.0,1882.0,1882.0,1882.0,1883.0,1883.7222,1884.1647,1884.7222,1884.7222,1897.0,1897.0,1897.0,1897.7222,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.7222,1897.0,1897.0,1896.9911,1896.7222,1896.7222,1895.4462,1893.8022,1891.9589,1891.1382,1890.0,1889.7222,1889.078,1888.0,1887.7877,1887.0,1887.0,1887.0,1887.0,1887.0,1886.7222,1886.0,1885.93,1885.0,1884.6327,1883.8445,1883.0029,1883.0,1883.0,1883.0,1883.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.2778,1883.0,1883.1844,1883.2778,1897.4266,1898.1227,1898.1666,1898.1666,1898.1593,1898.0,1897.2367,1897.0587,1897.1666,1898.1666,1898.1666,1898.1666,1898.078,1898.0,1897.7307,1898.0,1896.77,1895.4547,1894.142,1893.1666,1892.1666,1891.1666,1890.2567,1889.0,1888.0393,1888.0,1888.0,1888.0,1888.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {1888.0,1887.1034,1887.0,1886.1246,1885.4266,1885.0,1884.5333,1884.0,1883.0947,1883.0,1883.0,1883.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.8334,1883.0,1899.6111,1899.8973,1900.1051,1900.2395,1899.6111,1899.6111,1899.6111,1900.2222,1900.5287,1900.6111,1900.6111,1900.6111,1899.8971,1899.6111,1899.6111,1899.0978,1898.6111,1897.176,1896.4631,1895.0271,1893.9922,1893.1552,1891.6531,1890.2831,1889.0,1888.6111,1888.6111,1889.0,1889.0,1888.6111,1888.0,1887.1124,1886.902,1886.0,1885.9518,1885.0,1884.004,1884.0,1884.0,1883.6111,1883.0,1882.9315,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1901.0,1901.0555,1902.1111,1902.1449,1903.1135,1904.1378,1905.1666,1906.1666,1906.9664,1906.9551,1906.1855,1905.1666,1904.6346,1903.1986,1901.7627,1901.12,1900.7394,1899.3435,1898.0555,1897.0555,1896.0544,1894.5996,1893.1636,1891.7275,1890.2784,1890.0,1890.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {1890.0555,1890.0273,1889.1084,1888.6411,1888.0,1887.0,1887.0,1886.0487,1886.0,1885.0002,1885.0,1885.0,1884.0387,1884.0,1883.0,1882.0216,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1903.156,1904.368,1905.586,1907.304,1909.022,1910.98,1913.416,1913.852,1914.5,1914.5,1914.5,1913.452,1911.968,1910.532,1909.798,1907.66,1905.086,1902.288,1900.5,1899.208,1897.99,1896.772,1895.054,1893.836,1892.5,1891.5,1891.5,1891.5,1891.246,1890.056,1889.31,1888.184,1887.5,1887.0,1887.0,1886.22,1886.0,1885.284,1885.0,1885.0,1884.13,1883.912,1883.0,1882.5,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1882.0,1906.239,1907.9298,1910.0609,1911.9226,1914.8773,1917.3422,1919.7494,1921.8334,1921.8334,1922.7903,1922.7778,1922.6871,1921.7482,1919.8098,1917.4293,1915.9933,1913.818,1910.3538,1905.5374,1900.9675,1899.9244,1898.4884,1897.0525,1895.9445,1894.9445};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {1893.9445,1893.9445,1892.996,1892.4647,1891.0529,1889.9789,1889.0,1888.0,1887.9618,1887.0,1887.0,1886.9447,1886.0,1886.0,1885.6573,1885.0,1884.0,1883.966,1883.0,1883.0,1882.0756,1882.0,1882.0,1882.0,1882.0,1882.0,1908.9684,1911.1249,1913.6278,1917.1462,1921.8389,1924.6466,1926.6937,1927.7778,1928.6953,1929.3036,1929.7778,1930.1666,1929.9598,1928.1986,1925.6056,1922.84,1919.8906,1917.0658,1913.5393,1908.3876,1902.1433,1900.2115,1899.042,1897.3889,1896.5331,1895.8778,1895.1416,1894.3608,1893.6896,1892.4231,1891.2411,1890.0715,1889.0,1888.5796,1888.0,1887.6578,1887.0016,1887.0,1887.0,1886.3889,1886.0,1885.0,1884.626,1884.0,1883.0,1883.0,1882.0,1882.0,1882.0,1882.0,1882.0,1911.8854,1914.1826,1918.0106,1923.3893,1926.8773,1928.7467,1929.8334,1932.0187,1934.288,1935.5,1936.5,1936.7467,1936.968,1935.532,1933.096,1929.7933,1926.224,1922.9547,1919.494,1915.4987,1909.4434,1903.664,1900.8513};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {1899.5054,1898.0693,1897.0,1896.8334,1895.8334,1894.9153,1893.8427,1892.8334,1891.8334,1890.5813,1889.8334,1889.0,1888.8334,1888.0,1887.8334,1887.11,1887.0,1886.8767,1886.0,1885.3234,1884.7933,1883.9193,1883.0,1882.8334,1882.0,1882.0,1882.0,1882.0,1913.5897,1917.2183,1922.746,1926.8857,1929.3218,1931.4111,1934.1937,1936.7275,1939.1246,1940.6178,1942.2156,1942.9027,1943.6855,1942.8334,1940.9989,1938.1533,1934.358,1930.4093,1925.2595,1920.3876,1915.2234,1909.1875,1903.1273,1900.7631,1899.4482,1898.2778,1897.5406,1897.0,1897.0,1896.2778,1895.0033,1894.2778,1893.0958,1892.2778,1891.1538,1889.7178,1889.2778,1889.0,1888.2778,1888.0,1887.2778,1887.0,1886.0,1885.2644,1884.6504,1883.3356,1883.0,1882.208,1882.0,1882.0,1882.0,1916.2594,1919.4583,1923.516,1928.216,1930.7784,1933.3467,1936.5775,1940.0742,1943.0793,1945.6685,1948.1045,1950.1666,1950.1666,1949.8978,1948.7627,1945.9778,1942.4136,1938.2568,1932.445,1924.6925,1919.4044};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {1914.0764,1908.6604,1902.8795,1900.7877,1899.9445,1899.263,1898.7222,1898.3553,1897.7378,1897.4478,1896.7222,1895.6522,1894.7222,1893.6877,1892.5667,1891.4456,1890.4103,1889.7222,1888.9155,1888.1877,1887.5951,1886.83,1885.9867,1885.0,1884.0577,1883.4651,1883.0,1882.0,1882.0,1882.0,1919.9053,1922.9027,1925.3673,1928.876,1933.174,1934.6466,1938.0687,1942.8707,1946.778,1950.3906,1952.8833,1954.4293,1956.422,1957.5,1956.096,1953.66,1950.5514,1946.076,1940.204,1933.428,1924.2933,1918.512,1913.5493,1908.1173,1903.8053,1901.3,1901.0,1900.1666,1900.1666,1900.1666,1900.1666,1899.1666,1898.1666,1897.2186,1896.1666,1895.24,1894.1666,1893.1666,1891.2987,1890.116,1889.0,1888.0,1887.0647,1886.952,1885.5967,1885.0,1883.644,1883.0,1882.0,1882.0,1882.0,1923.1136,1926.7969,1930.4994,1934.6777,1936.6111,1937.0911,1940.4431,1945.3151,1950.1871,1953.8351,1956.8822,1959.3182,1962.1431,1963.5986,1962.454,1960.9933,1957.2814,1952.5103,1946.9263};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1941.3085,1933.3323,1923.0316,1917.4802,1912.6937,1908.6942,1906.0222,1904.3638,1903.2222,1903.2222,1903.2222,1902.8422,1901.7235,1900.902,1900.3435,1899.487,1897.88,1896.6151,1895.1791,1893.7432,1891.696,1889.26,1888.5035,1887.762,1886.9813,1885.8118,1885.0,1883.8616,1883.0,1882.772,1882.0,1882.0,1925.3676,1929.5831,1934.4456,1939.6974,1941.2107,1942.7023,1945.0317,1948.8151,1953.6871,1957.5466,1960.7522,1963.2018,1965.0295,1965.0555,1965.0555,1964.2067,1962.5189,1956.9751,1951.7595,1945.3591,1938.8811,1927.2316,1921.114,1916.3995,1912.2915,1910.1111,1909.1111,1908.1666,1908.1111,1908.1111,1906.6967,1905.2849,1904.8036,1903.4058,1901.9385,1901.0244,1899.1149,1897.6476,1896.1875,1893.696,1890.3156,1889.0,1888.0,1887.952,1887.0,1885.1355,1884.644,1883.252,1883.0,1882.336,1882.0,1931.844,1933.736,1937.844,1943.52,1948.566,1950.5,1950.5,1953.88,1958.682,1962.336,1965.66,1967.048,1967.766,1968.484,1967.298,1965.66,1964.086};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {1959.72,1953.704,1947.956,1938.92,1929.176,1923.162,1920.008,1916.354,1914.4,1914.0,1914.0,1913.246,1912.528,1910.81,1909.092,1908.248,1906.656,1905.376,1903.72,1902.002,1900.784,1898.632,1895.196,1891.89,1889.412,1888.694,1888.0,1887.0,1886.54,1885.822,1884.604,1883.5,1883.0,1882.0,1937.239,1937.9298,1942.3589,1949.1049,1954.9629,1958.8044,1958.8334,1961.1853,1965.4093,1969.0574,1971.5122,1971.8942,1971.9149,1970.8906,1968.596,1966.16,1962.7795,1958.6316,1953.704,1948.248,1939.8844,1934.9214,1929.1514,1925.5054,1922.1249,1920.6444,1919.2529,1918.8889,1917.8889,1916.8889,1913.5645,1912.9445,1911.9304,1910.2391,1907.9375,1906.3844,1904.9447,1903.5125,1901.0764,1897.3364,1893.26,1890.7684,1889.0,1888.0,1887.516,1887.0,1886.6083,1885.956,1884.9445,1883.3174,1883.0,1944.1666,1945.9027,1950.5775,1957.3795,1963.8218,1965.9645,1967.1154,1969.1227,1973.2611,1976.3036,1976.7778,1976.7405,1975.0637,1972.4209,1969.8278};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {1964.32,1960.5553,1957.1232,1952.3151,1947.8973,1944.7456,1941.3218,1937.3407,1933.5106,1928.6387,1926.0889,1924.7778,1923.7338,1922.5802,1920.8337,1918.7778,1917.7778,1915.6798,1913.0897,1911.2649,1908.8289,1907.3914,1904.9569,1902.1833,1898.392,1894.26,1890.435,1889.0,1888.0,1888.0,1887.0,1887.0,1886.0,1885.3889,1884.5942,1883.9388,1950.24,1952.6294,1958.016,1964.8174,1970.544,1972.98,1974.416,1976.4973,1980.9447,1982.724,1982.95,1981.42,1978.3014,1974.8973,1971.0927,1966.1533,1962.2814,1958.4093,1952.6606,1951.6666,1950.4634,1946.7546,1943.608,1940.3386,1936.972,1934.1333,1932.394,1930.428,1928.0767,1924.732,1923.6666,1922.6666,1920.4147,1917.2906,1913.7094,1911.2733,1908.8373,1906.4014,1903.132,1898.392,1892.6866,1889.0,1889.0,1888.0,1888.0,1887.0667,1887.0,1886.1733,1886.0,1885.0,1884.0,1960.2319,1964.5831,1967.4551,1972.2183,1978.1991,1982.0712,1984.0504,1985.5374,1988.6213,1989.8334,1988.8955,1986.0858,1981.8757};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {1977.3418,1972.7616,1968.5978,1964.8025,1960.8538,1958.4076,1956.9716,1954.5355,1951.9729,1948.6636,1945.2275,1942.7915,1940.4111,1939.5555,1939.1538,1934.8174,1930.8893,1929.7278,1927.7395,1925.3036,1922.9542,1919.3075,1914.4355,1912.0022,1907.5715,1903.264,1898.392,1892.9856,1889.0,1888.388,1888.0,1888.0,1887.0,1887.0,1887.0,1886.0,1885.5204,1885.0,1970.3217,1976.0831,1978.0609,1981.996,1987.2546,1990.9933,1992.8889,1994.3386,1996.9547,1997.0049,1994.7844,1990.2524,1985.0425,1980.5173,1974.9142,1971.6489,1967.9691,1964.7324,1963.4445,1961.8605,1959.41,1955.9884,1953.3047,1949.8795,1946.9583,1945.4445,1944.4445,1942.6302,1939.7953,1937.4849,1935.7866,1933.6284,1930.8026,1927.7565,1925.286,1921.0466,1915.4553,1910.4263,1904.1182,1899.6116,1895.2422,1890.4191,1889.0,1888.0,1887.516,1887.0,1887.0,1887.0,1886.0,1885.0934,1884.25,1980.7692,1987.1387,1989.0054,1991.376,1995.7546,2000.6267,2002.7633,2003.5867,2007.2427,2007.2933,2002.68};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {1997.4586,1991.0707,1985.564,1980.288,1974.6533,1971.77,1970.3334,1968.3334,1966.7494,1964.2966,1960.8773,1958.59,1956.8987,1953.9027,1950.6333,1948.864,1947.2733,1945.8253,1943.3893,1940.9534,1938.5173,1935.7047,1932.5306,1929.2094,1926.7733,1921.5114,1912.924,1907.5973,1902.508,1897.3033,1892.8147,1889.0647,1888.0,1887.5967,1887.0,1886.7034,1886.0,1885.6433,1885.0,1884.0,1991.6794,1997.3662,2000.2275,2002.1395,2006.1606,2012.0155,2015.0043,2015.4076,2019.9363,2019.7444,2015.7356,2009.6715,2000.8484,1992.9293,1986.0103,1978.7023,1975.2222,1975.2222,1974.0742,1971.6382,1969.2023,1966.9884,1966.0975,1965.8551,1964.2915,1961.2444,1958.0309,1954.3724,1951.8236,1948.3125,1945.8422,1943.4062,1939.9702,1936.2351,1932.487,1929.7089,1926.6151,1918.7582,1912.4862,1905.4285,1899.1311,1894.2592,1889.9991,1888.9813,1888.0,1887.6422,1886.7825,1886.0,1885.6111,1885.0,1884.961,2002.919,2008.7498,2012.5149,2015.5712,2019.4629,2025.211,2026.2222,2026.5742,2028.9664};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {2028.9551,2025.4889,2016.6663,2006.314,1997.096,1987.866,1984.3177,1982.8906,1980.4547,1978.9076,1976.5271,1974.1111,1974.5671,1976.0092,1976.1111,1975.1111,1972.0222,1968.5862,1964.1298,1960.2062,1956.2787,1951.4623,1948.3053,1944.5931,1938.7351,1934.9315,1931.9111,1928.0634,1922.7595,1915.4033,1907.8009,1900.5756,1896.7036,1892.8656,1890.0076,1888.5428,1888.0,1887.0198,1887.0,1886.0428,1886.0,1885.05,2014.5918,2021.708,2027.258,2031.216,2034.088,2037.74,2037.042,2036.676,2037.0,2036.776,2029.88,2016.972,2005.606,1997.064,1992.192,1989.58,1988.224,1985.932,1982.426,1980.416,1980.0,1980.5,1981.5,1981.5,1980.618,1978.8,1977.182,1974.392,1969.984,1965.112,1960.43,1954.96,1949.496,1943.78,1937.376,1934.16,1929.508,1923.988,1916.396,1909.24,1902.65,1898.324,1895.888,1892.928,1890.016,1888.54,1888.0,1887.208,1887.0,1886.668,1886.0,2026.3634,2031.9857,2038.1218,2042.9938,2047.7662,2049.7778,2049.7778};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {2047.4453,2043.3011,2037.6075,2027.7744,2015.52,2005.8424,1998.9529,1996.1034,1993.1045,1991.6282,1989.1929,1985.7964,1983.9445,1984.8889,1985.8889,1987.7809,1987.5236,1986.1118,1984.8778,1983.1974,1979.8169,1976.8729,1973.8369,1969.039,1963.2013,1956.0774,1948.8248,1942.634,1937.3534,1931.9562,1925.112,1918.3405,1911.3364,1906.4233,1901.7587,1898.6989,1895.8965,1892.4604,1889.0756,1888.6083,1887.956,1887.0,1887.0,1886.85,2036.1794,2041.8662,2048.0334,2055.1572,2058.5825,2059.1667,2055.9458,2050.296,2043.3296,2034.0168,2023.36,2015.5271,2010.1027,2003.8738,1998.2167,1996.3889,1994.6704,1992.9537,1990.0762,1989.9125,1991.5677,1993.6227,1995.0587,1994.5774,1993.3109,1991.0889,1988.5306,1984.7058,1981.2698,1978.445,1974.7766,1969.1458,1963.1198,1956.1027,1948.5298,1942.6578,1936.7874,1929.7026,1923.0417,1915.8657,1910.2977,1906.4258,1902.1658,1898.7297,1895.4209,1890.9377,1889.0,1888.3889,1888.0,1887.1306,1887.0,2046.9573,2052.5413,2059.568,2063.2747,2064.6667};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {2063.3533,2058.238,2050.484,2042.636,2034.2906,2025.2933,2021.308,2015.9927,2008.736,2003.128,2000.66,1998.4366,1996.7147,1996.6666,1998.084,2000.3534,2002.3334,2002.5,2002.06,2000.5,1998.1333,1994.334,1989.5227,1984.7354,1981.732,1977.97,1973.3546,1967.9526,1961.6027,1954.2947,1947.9867,1941.6787,1935.3707,1928.786,1921.7546,1915.1866,1910.344,1906.1194,1902.5786,1898.7793,1894.8267,1891.3107,1889.1733,1888.8334,1888.0,1887.0,2056.238,2061.6565,2066.1296,2069.4414,2070.8333,2068.8733,2061.5532,2052.8699,2044.3447,2038.003,2035.7289,2030.448,2023.3673,2013.9613,2010.1111,2008.9933,2005.5574,2003.8334,2005.2592,2007.6951,2011.1311,2012.1111,2011.2191,2010.02,2008.0693,2004.4333,1999.8242,1994.6693,1989.1726,1984.3898,1980.6233,1976.6458,1971.5918,1965.2137,1958.9402,1952.5978,1946.2858,1939.6915,1933.9149,1926.6436,1920.2633,1913.3307,1909.2238,1905.4943,1901.9371,1899.6133,1896.1996,1892.9716,1890.0498,1889.0,1887.9277,2067.859,2073.3472,2075.0608};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {2077.4968,2078.1667,2075.7266,2065.8645,2056.1746,2051.0352,2049.8267,2047.2911,2040.8787,2030.9746,2022.1844,2021.3193,2018.8156,2013.4136,2011.1666,2014.9071,2018.3573,2020.9089,2022.7378,2022.6111,2020.0463,2016.5731,2011.7667,2006.1725,2000.3004,1994.4285,1988.5564,1983.79,1979.0902,1974.9662,1968.3462,1961.4742,1955.0422,1948.7302,1942.8583,1937.9862,1930.617,1924.2966,1917.9165,1912.1102,1908.6609,1905.9604,1903.5244,1901.0885,1897.8026,1893.4309,1890.0582,1888.65,2074.4663,2082.972,2085.6953,2086.6667,2086.7034,2085.46,2073.004,2064.352,2065.3787,2061.1614,2055.2366,2048.7188,2037.5067,2030.5533,2030.1633,2027.96,2024.1146,2022.6666,2025.8394,2029.2506,2031.8534,2033.6666,2032.7747,2029.3386,2025.0114,2019.0667,2012.592,2006.1293,1999.8093,1993.5013,1987.51,1982.5347,1976.6627,1970.7906,1963.7947,1957.0466,1950.012,1944.3026,1939.264,1933.1387,1927.52,1920.8147,1915.1094,1912.1267,1909.8494,1907.26,1904.8107,1901.3746,1896.7487,1892.9493,1889.15,2078.0938};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {2089.88,2095.6165,2096.684,2096.4175,2092.5488,2080.118,2077.5515,2076.963,2072.2112,2062.4011,2052.8381,2041.9664,2038.4125,2039.2874,2038.1178,2034.8925,2033.8795,2037.2036,2040.4778,2043.6823,2045.0555,2044.7086,2039.7885,2033.4496,2027.1555,2019.9253,2012.6173,2005.5068,1998.3903,1991.4711,1985.0916,1979.5642,1973.2351,1966.8502,1959.76,1952.2367,1946.7471,1939.0878,1934.392,1929.1311,1924.0463,1920.6102,1916.1929,1913.7383,1910.7711,1907.1167,1903.8191,1900.1552,1896.1525,1892.4111,2086.491,2095.8467,2104.7288,2109.111,2105.0762,2099.1245,2090.4695,2089.2583,2086.3904,2080.2708,2070.8845,2057.7324,2049.2434,2050.3013,2050.2778,2049.429,2046.3334,2048.085,2051.6848,2055.5244,2058.2778,2057.8218,2054.4878,2049.5662,2042.9302,2035.6222,2028.3142,2020.0022,2011.67,2003.3876,1995.9578,1988.8196,1984.6487,1978.7524,1972.7947,1966.0155,1958.1787,1950.8151,1943.5071,1936.8458,1933.33,1928.9253,1925.4651,1920.9623,1917.0875,1913.211,1909.3435,1905.4716,1902.815,1898.7275};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {1893.95,2098.468,2105.076,2112.672,2114.5,2110.89,2104.56,2099.584,2099.148,2093.924,2087.216,2077.53,2064.616,2061.032,2063.468,2063.298,2062.58,2061.776,2064.712,2067.148,2070.084,2071.49,2070.044,2066.662,2059.68,2052.826,2045.4,2038.092,2029.712,2019.968,2010.196,2003.43,1999.276,1992.244,1985.436,1979.19,1972.82,1964.514,1956.272,1947.83,1942.392,1937.15,1932.648,1928.276,1923.904,1918.774,1915.08,1910.966,1907.708,1904.658,1901.836,1896.25,2113.2905,2118.1387,2121.9497,2123.2036,2120.5928,2111.4312,2108.754,2110.0378,2103.37,2094.8943,2085.1567,2073.495,2072.8123,2075.7458,2077.1038,2078.46,2078.9272,2081.2676,2083.759,2085.2507,2084.6477,2082.266,2078.9382,2072.6826,2064.4302,2056.1223,2047.8698,2039.4897,2028.2933,2018.7356,2011.6589,2006.2013,2001.3153,1993.7137,1985.4683,1978.7689,1970.9047,1960.6244,1954.1738,1948.264,1941.669,1935.4263,1929.776,1924.9014,1920.032,1916.1045,1911.644,1909.1525};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {1906.5011,1902.6533,1897.8944,2128.8042,2131.7832,2133.6606,2133.5557,2130.4236,2122.6355,2117.8105,2120.9517,2115.6628,2104.4355,2092.5266,2082.682,2083.6196,2087.5234,2089.5056,2093.111,2096.167,2097.3333,2097.3333,2097.1062,2096.3254,2095.156,2091.2024,2085.088,2078.0413,2068.5334,2058.542,2048.2676,2037.2131,2032.4236,2023.6655,2014.6089,2008.4106,2001.1027,1992.6707,1983.5377,1973.7938,1969.4707,1962.614,1955.1365,1946.8177,1937.8608,1931.5529,1925.2928,1921.516,1917.5488,1913.2833,1910.5969,1908.0216,1904.3191,1901.7389,2141.4785,2143.0693,2143.3333,2142.3987,2138.412,2132.4133,2127.084,2130.1667,2125.9692,2115.8228,2101.3733,2092.2373,2092.8652,2098.076,2103.978,2107.8132,2110.276,2112.712,2113.1667,2112.416,2110.1633,2108.544,2104.234,2098.1826,2090.678,2082.3333,2071.6226,2058.056,2048.6587,2043.492,2035.75,2025.2227,2016.744,2009.696,2000.004,1988.3267,1983.172,1978.5414,1971.8613,1961.588,1952.7067,1942.6493,1933.9973,1926.7373,1923.3494,1920.76};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {1917.3107,1913.2147,1910.6053,1907.7227,1904.8334,2154.701,2155.389,2155.2168,2152.781,2146.9668,2139.3933,2133.5334,2138.4866,2135.375,2124.9912,2110.9678,2100.389,2103.3691,2110.316,2116.1968,2120.4622,2124.7742,2128.6565,2129.8376,2127.6382,2125.9045,2121.3618,2116.8826,2111.3547,2102.1206,2093.311,2082.6533,2069.1409,2062.6506,2055.5725,2046.8689,2037.8472,2026.3109,2017.0813,2005.7427,1995.7467,1993.3958,1986.6951,1979.2294,1969.5911,1958.5956,1948.6755,1937.1615,1930.7373,1927.5555,1925.6355,1922.3784,1917.7516,1912.9865,1910.5204,1908.1777,2167.42,2167.0796,2166.315,2162.8418,2156.713,2147.1023,2143.4443,2147.4443,2144.4307,2134.0466,2121.4055,2109.8196,2113.4849,2121.492,2129.2537,2135.969,2141.8853,2145.7676,2147.0967,2146.4714,2143.7234,2138.1436,2132.5493,2125.536,2114.5134,2102.9443,2090.7239,2082.447,2076.8093,2069.5012,2059.5388,2049.625,2036.6289,2024.7267,2010.0035,2006.4889,2004.618,1997.1609,1985.79,1976.9507,1965.4667,1953.6915,1941.6647,1935.3965};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {1933.3331,1930.5244,1926.8313,1922.0106,1915.2662,1912.0582,1910.6945,2180.312,2179.1414,2175.4946,2171.4507,2164.4907,2154.8933,2150.7366,2154.5,2151.0906,2143.4172,2131.2,2122.6572,2122.5073,2132.512,2142.0454,2149.46,2155.6614,2160.5454,2162.1667,2161.5828,2158.1233,2153.632,2146.1753,2137.7947,2127.5732,2113.6333,2101.7134,2099.392,2093.0527,2082.28,2072.83,2061.5867,2045.5693,2030.4347,2022.0427,2021.8,2017.182,2006.0106,1995.3267,1983.284,1972.6333,1960.3066,1948.8854,1943.5707,1939.532,1935.48,1930.6213,1926.5826,1920.5587,1915.836,1914.2333,2195.3674,2194.0334,2187.2175,2181.468,2173.6843,2162.3867,2156.2222,2162.0483,2159.8684,2151.5483,2141.9512,2136.219,2135.1987,2142.6929,2151.8882,2158.9644,2167.8835,2173.0444,2178.9465,2177.921,2173.9956,2166.6875,2157.8765,2147.7217,2138.3884,2127.3,2121.3945,2115.4067,2105.9045,2095.6902,2082.9333,2071.7534,2052.6633,2040.8324,2041.4242,2039.5466,2032.6802,2018.4635,2004.4933,1991.3134,1979.1333,1966.8458};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {1957.1333,1953.3671,1947.9924,1940.4623,1934.6487,1929.1542,1924.2944,1921.5582,1918.4722,2207.4958,2207.2368,2200.6357,2190.8457,2182.9932,2172.3423,2166.246,2172.5383,2170.69,2163.6182,2157.9578,2153.1414,2149.7717,2152.16,2159.3787,2166.6868,2174.9543,2182.975,2188.5183,2189.6707,2185.162,2176.3982,2166.6047,2155.8728,2147.2935,2144.1333,2139.4607,2129.7737,2115.7378,2103.3938,2090.8867,2076.9858,2060.5913,2057.701,2057.2024,2053.1821,2044.2422,2028.6302,2012.1462,1998.304,1985.4255,1973.6942,1968.0878,1964.0782,1956.2863,1947.4867,1939.0431,1933.5271,1929.883,1926.4471,1922.9111,2216.9358,2218.896,2211.898,2201.96,2190.346,2180.84,2176.958,2182.528,2182.318,2176.828,2170.52,2165.808,2162.202,2161.484,2166.01,2173.02,2180.966,2189.636,2196.222,2197.916,2195.43,2185.72,2175.432,2165.852,2161.236,2157.8,2153.91,2141.46,2126.214,2111.448,2098.1,2084.736,2078.496,2075.312,2071.752,2065.54,2054.024,2037.908,2020.424,2004.676};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {1991.8,1985.236,1981.082,1974.38,1966.322,1954.48,1944.932,1939.02,1935.658,1931.672,1926.8,2226.632,2231.0417,2219.983,2209.4568,2197.6133,2187.82,2187.6892,2192.0938,2193.7222,2190.007,2183.7234,2177.5303,2172.6877,2168.9192,2172.6638,2178.56,2188.198,2196.9692,2203.1294,2206.2263,2202.7734,2194.44,2185.2097,2177.1035,2174.0007,2172.5112,2167.158,2156.039,2135.1802,2122.0608,2105.6511,2099.8054,2097.3591,2092.568,2085.3503,2074.9778,2061.8574,2044.8334,2027.8893,2011.7053,1997.4233,1996.5463,1993.4982,1986.5328,1976.8418,1965.2289,1955.0103,1949.1937,1942.162,1936.5609,1932.7278,2232.4016,2234.9392,2228.2017,2215.4983,2204.548,2196.52,2200.5542,2204.2964,2206.426,2204.4468,2198.3533,2192.024,2184.308,2179.2112,2180.7278,2188.5334,2196.9946,2203.3027,2209.6106,2212.5557,2210.1267,2203.6973,2196.2686,2190.4768,2185.5693,2182.7444,2178.2837,2166.8013,2148.3884,2129.935,2119.9622,2116.0903,2111.5774,2104.6128,2095.5466,2082.6355,2069.578,2052.1426};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {2033.753,2018.3427,2009.8434,2011.7684,2005.0214,1994.9746,1984.7467,1972.5667,1965.7051,1958.1796,1949.0938,1943.0969,1940.4556,2241.0718,2240.764,2233.9788,2222.46,2212.238,2210.16,2213.2354,2216.5186,2217.1667,2214.9226,2211.0134,2205.8787,2200.1028,2194.096,2190.8047,2198.02,2204.9314,2211.4692,2217.796,2219.6667,2217.46,2212.132,2206.806,2201.6772,2197.6086,2193.8,2188.228,2180.2092,2159.7773,2146.1133,2135.7566,2130.368,2124.5774,2115.8413,2103.61,2089.2334,2075.69,2059.116,2039.578,2028.508,2026.8334,2025.648,2016.2086,2003.22,1990.6766,1980.7533,1973.9686,1966.124,1956.4214,1952.5027,1951.0834,2251.3022,2248.6392,2240.1453,2229.5156,2220.4329,2222.28,2226.7764,2230.111,2229.389,2225.941,2221.0688,2216.1968,2211.325,2206.175,2203.111,2206.3977,2213.1384,2219.9795,2223.7036,2224.8333,2222.8132,2220.2507,2216.297,2210.8494,2206.2397,2201.3777,2195.844,2187.4534,2171.6963,2160.875,2153.8044,2146.2698,2135.0332,2123.8901,2109.777,2094.1956};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {2080.5784,2065.5315,2049.29,2043.556,2041.6489,2038.988,2026.2151,2011.2329,1996.8973,1989.3511,1982.4093,1973.2373,1965.6033,1966.1111,1965.289,2265.0215,2259.5938,2248.9048,2236.5657,2230.9646,2235.9177,2240.2493,2240.889,2239.67,2236.441,2232.4744,2227.6702,2221.825,2216.953,2213.7766,2214.9622,2220.7954,2225.8684,2229.5925,2231.1667,2230.1467,2226.8618,2222.6604,2217.4604,2211.3647,2207.1223,2199.8142,2193.1365,2182.8684,2176.5012,2167.369,2158.7698,2142.4727,2127.5076,2112.9783,2097.3623,2084.4656,2072.6306,2065.8374,2062.667,2059.8323,2050.604,2034.7126,2017.1565,2005.4369,1997.4066,1989.8416,1980.9987,1975.8256,1976.3684,1976.6111,2276.0427,2270.292,2258.6348,2245.728,2244.088,2248.3132,2250.8193,2252.3733,2251.0454,2248.3853,2243.4033,2237.4587,2231.0706,2225.7253,2223.33,2223.5066,2228.098,2233.3306,2236.8147,2238.5,2236.6467,2233.588,2227.5674,2221.3494,2214.8748,2208.5334,2202.198,2196.1895,2189.8093,2183.3347,2173.2266,2161.9507,2145.6548,2130.0386};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {2115.4226,2100.2466,2089.6814,2085.568,2083.9653,2079.088,2073.28,2060.2974,2041.7706,2025.8,2014.8973,2005.7533,1996.432,1988.1587,1986.9326,1989.0,1987.8167};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.02,0.00391,0.04,0.00391,0.06,0.00391,0.08,0.00391,0.1,0.00391,0.12,0.00391,0.14,0.00391,0.16,0.00391,0.18,0.00391,0.2,0.00391,0.22,0.00391,0.24,0.00391,0.26,0.00391,0.28,0.00391,0.3,0.00391,0.32,0.00391,0.34,0.00391,0.36,0.00391,0.38,0.00391,0.4,0.00391,0.42,0.00391,0.44,0.00391,0.46,0.00391,0.48,0.00391,0.5,0.00391,0.52,0.00391,0.54,0.00391,0.56,0.00391,0.58,0.00391,0.6,0.00391,0.62,0.00391,0.64,0.00391,0.66,0.00391,0.68,0.00391,0.7,0.00391,0.72,0.00391,0.74,0.00391,0.76,0.00391,0.78,0.00391,0.8,0.00391,0.82,0.00391,0.84,0.00391,0.86,0.00391,0.88,0.00391,0.9,0.00391,0.92,0.00391,0.94,0.00391,0.96,0.00391,0.98,0.00391,0.99609,0.00391,0.00391,0.01515,0.02,0.01515,0.04,0.01515,0.06,0.01515,0.08,0.01515,0.1,0.01515,0.12,0.01515,0.14,0.01515,0.16,0.01515,0.18,0.01515,0.2,0.01515,0.22,0.01515,0.24,0.01515,0.26,0.01515,0.28,0.01515,0.3,0.01515,0.32,0.01515,0.34,0.01515,0.36,0.01515,0.38,0.01515,0.4,0.01515,0.42,0.01515,0.44,0.01515,0.46,0.01515,0.48,0.01515,0.5,0.01515,0.52,0.01515,0.54,0.01515,0.56,0.01515,0.58,0.01515,0.6,0.01515,0.62,0.01515,0.64,0.01515,0.66,0.01515,0.68,0.01515,0.7,0.01515,0.72,0.01515,0.74,0.01515,0.76,0.01515,0.78,0.01515,0.8,0.01515,0.82,0.01515,0.84,0.01515,0.86,0.01515,0.88,0.01515,0.9,0.01515,0.92,0.01515,0.94,0.01515,0.96,0.01515};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.98,0.01515,0.99609,0.01515,0.00391,0.0303,0.02,0.0303,0.04,0.0303,0.06,0.0303,0.08,0.0303,0.1,0.0303,0.12,0.0303,0.14,0.0303,0.16,0.0303,0.18,0.0303,0.2,0.0303,0.22,0.0303,0.24,0.0303,0.26,0.0303,0.28,0.0303,0.3,0.0303,0.32,0.0303,0.34,0.0303,0.36,0.0303,0.38,0.0303,0.4,0.0303,0.42,0.0303,0.44,0.0303,0.46,0.0303,0.48,0.0303,0.5,0.0303,0.52,0.0303,0.54,0.0303,0.56,0.0303,0.58,0.0303,0.6,0.0303,0.62,0.0303,0.64,0.0303,0.66,0.0303,0.68,0.0303,0.7,0.0303,0.72,0.0303,0.74,0.0303,0.76,0.0303,0.78,0.0303,0.8,0.0303,0.82,0.0303,0.84,0.0303,0.86,0.0303,0.88,0.0303,0.9,0.0303,0.92,0.0303,0.94,0.0303,0.96,0.0303,0.98,0.0303,0.99609,0.0303,0.00391,0.04545,0.02,0.04545,0.04,0.04545,0.06,0.04545,0.08,0.04545,0.1,0.04545,0.12,0.04545,0.14,0.04545,0.16,0.04545,0.18,0.04545,0.2,0.04545,0.22,0.04545,0.24,0.04545,0.26,0.04545,0.28,0.04545,0.3,0.04545,0.32,0.04545,0.34,0.04545,0.36,0.04545,0.38,0.04545,0.4,0.04545,0.42,0.04545,0.44,0.04545,0.46,0.04545,0.48,0.04545,0.5,0.04545,0.52,0.04545,0.54,0.04545,0.56,0.04545,0.58,0.04545,0.6,0.04545,0.62,0.04545,0.64,0.04545,0.66,0.04545,0.68,0.04545,0.7,0.04545,0.72,0.04545,0.74,0.04545,0.76,0.04545,0.78,0.04545,0.8,0.04545,0.82,0.04545,0.84,0.04545,0.86,0.04545,0.88,0.04545,0.9,0.04545,0.92,0.04545};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.94,0.04545,0.96,0.04545,0.98,0.04545,0.99609,0.04545,0.00391,0.06061,0.02,0.06061,0.04,0.06061,0.06,0.06061,0.08,0.06061,0.1,0.06061,0.12,0.06061,0.14,0.06061,0.16,0.06061,0.18,0.06061,0.2,0.06061,0.22,0.06061,0.24,0.06061,0.26,0.06061,0.28,0.06061,0.3,0.06061,0.32,0.06061,0.34,0.06061,0.36,0.06061,0.38,0.06061,0.4,0.06061,0.42,0.06061,0.44,0.06061,0.46,0.06061,0.48,0.06061,0.5,0.06061,0.52,0.06061,0.54,0.06061,0.56,0.06061,0.58,0.06061,0.6,0.06061,0.62,0.06061,0.64,0.06061,0.66,0.06061,0.68,0.06061,0.7,0.06061,0.72,0.06061,0.74,0.06061,0.76,0.06061,0.78,0.06061,0.8,0.06061,0.82,0.06061,0.84,0.06061,0.86,0.06061,0.88,0.06061,0.9,0.06061,0.92,0.06061,0.94,0.06061,0.96,0.06061,0.98,0.06061,0.99609,0.06061,0.00391,0.07576,0.02,0.07576,0.04,0.07576,0.06,0.07576,0.08,0.07576,0.1,0.07576,0.12,0.07576,0.14,0.07576,0.16,0.07576,0.18,0.07576,0.2,0.07576,0.22,0.07576,0.24,0.07576,0.26,0.07576,0.28,0.07576,0.3,0.07576,0.32,0.07576,0.34,0.07576,0.36,0.07576,0.38,0.07576,0.4,0.07576,0.42,0.07576,0.44,0.07576,0.46,0.07576,0.48,0.07576,0.5,0.07576,0.52,0.07576,0.54,0.07576,0.56,0.07576,0.58,0.07576,0.6,0.07576,0.62,0.07576,0.64,0.07576,0.66,0.07576,0.68,0.07576,0.7,0.07576,0.72,0.07576,0.74,0.07576,0.76,0.07576,0.78,0.07576,0.8,0.07576,0.82,0.07576,0.84,0.07576,0.86,0.07576,0.88,0.07576};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.9,0.07576,0.92,0.07576,0.94,0.07576,0.96,0.07576,0.98,0.07576,0.99609,0.07576,0.00391,0.09091,0.02,0.09091,0.04,0.09091,0.06,0.09091,0.08,0.09091,0.1,0.09091,0.12,0.09091,0.14,0.09091,0.16,0.09091,0.18,0.09091,0.2,0.09091,0.22,0.09091,0.24,0.09091,0.26,0.09091,0.28,0.09091,0.3,0.09091,0.32,0.09091,0.34,0.09091,0.36,0.09091,0.38,0.09091,0.4,0.09091,0.42,0.09091,0.44,0.09091,0.46,0.09091,0.48,0.09091,0.5,0.09091,0.52,0.09091,0.54,0.09091,0.56,0.09091,0.58,0.09091,0.6,0.09091,0.62,0.09091,0.64,0.09091,0.66,0.09091,0.68,0.09091,0.7,0.09091,0.72,0.09091,0.74,0.09091,0.76,0.09091,0.78,0.09091,0.8,0.09091,0.82,0.09091,0.84,0.09091,0.86,0.09091,0.88,0.09091,0.9,0.09091,0.92,0.09091,0.94,0.09091,0.96,0.09091,0.98,0.09091,0.99609,0.09091,0.00391,0.10606,0.02,0.10606,0.04,0.10606,0.06,0.10606,0.08,0.10606,0.1,0.10606,0.12,0.10606,0.14,0.10606,0.16,0.10606,0.18,0.10606,0.2,0.10606,0.22,0.10606,0.24,0.10606,0.26,0.10606,0.28,0.10606,0.3,0.10606,0.32,0.10606,0.34,0.10606,0.36,0.10606,0.38,0.10606,0.4,0.10606,0.42,0.10606,0.44,0.10606,0.46,0.10606,0.48,0.10606,0.5,0.10606,0.52,0.10606,0.54,0.10606,0.56,0.10606,0.58,0.10606,0.6,0.10606,0.62,0.10606,0.64,0.10606,0.66,0.10606,0.68,0.10606,0.7,0.10606,0.72,0.10606,0.74,0.10606,0.76,0.10606,0.78,0.10606,0.8,0.10606,0.82,0.10606,0.84,0.10606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.86,0.10606,0.88,0.10606,0.9,0.10606,0.92,0.10606,0.94,0.10606,0.96,0.10606,0.98,0.10606,0.99609,0.10606,0.00391,0.12121,0.02,0.12121,0.04,0.12121,0.06,0.12121,0.08,0.12121,0.1,0.12121,0.12,0.12121,0.14,0.12121,0.16,0.12121,0.18,0.12121,0.2,0.12121,0.22,0.12121,0.24,0.12121,0.26,0.12121,0.28,0.12121,0.3,0.12121,0.32,0.12121,0.34,0.12121,0.36,0.12121,0.38,0.12121,0.4,0.12121,0.42,0.12121,0.44,0.12121,0.46,0.12121,0.48,0.12121,0.5,0.12121,0.52,0.12121,0.54,0.12121,0.56,0.12121,0.58,0.12121,0.6,0.12121,0.62,0.12121,0.64,0.12121,0.66,0.12121,0.68,0.12121,0.7,0.12121,0.72,0.12121,0.74,0.12121,0.76,0.12121,0.78,0.12121,0.8,0.12121,0.82,0.12121,0.84,0.12121,0.86,0.12121,0.88,0.12121,0.9,0.12121,0.92,0.12121,0.94,0.12121,0.96,0.12121,0.98,0.12121,0.99609,0.12121,0.00391,0.13636,0.02,0.13636,0.04,0.13636,0.06,0.13636,0.08,0.13636,0.1,0.13636,0.12,0.13636,0.14,0.13636,0.16,0.13636,0.18,0.13636,0.2,0.13636,0.22,0.13636,0.24,0.13636,0.26,0.13636,0.28,0.13636,0.3,0.13636,0.32,0.13636,0.34,0.13636,0.36,0.13636,0.38,0.13636,0.4,0.13636,0.42,0.13636,0.44,0.13636,0.46,0.13636,0.48,0.13636,0.5,0.13636,0.52,0.13636,0.54,0.13636,0.56,0.13636,0.58,0.13636,0.6,0.13636,0.62,0.13636,0.64,0.13636,0.66,0.13636,0.68,0.13636,0.7,0.13636,0.72,0.13636,0.74,0.13636,0.76,0.13636,0.78,0.13636,0.8,0.13636};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.82,0.13636,0.84,0.13636,0.86,0.13636,0.88,0.13636,0.9,0.13636,0.92,0.13636,0.94,0.13636,0.96,0.13636,0.98,0.13636,0.99609,0.13636,0.00391,0.15152,0.02,0.15152,0.04,0.15152,0.06,0.15152,0.08,0.15152,0.1,0.15152,0.12,0.15152,0.14,0.15152,0.16,0.15152,0.18,0.15152,0.2,0.15152,0.22,0.15152,0.24,0.15152,0.26,0.15152,0.28,0.15152,0.3,0.15152,0.32,0.15152,0.34,0.15152,0.36,0.15152,0.38,0.15152,0.4,0.15152,0.42,0.15152,0.44,0.15152,0.46,0.15152,0.48,0.15152,0.5,0.15152,0.52,0.15152,0.54,0.15152,0.56,0.15152,0.58,0.15152,0.6,0.15152,0.62,0.15152,0.64,0.15152,0.66,0.15152,0.68,0.15152,0.7,0.15152,0.72,0.15152,0.74,0.15152,0.76,0.15152,0.78,0.15152,0.8,0.15152,0.82,0.15152,0.84,0.15152,0.86,0.15152,0.88,0.15152,0.9,0.15152,0.92,0.15152,0.94,0.15152,0.96,0.15152,0.98,0.15152,0.99609,0.15152,0.00391,0.16667,0.02,0.16667,0.04,0.16667,0.06,0.16667,0.08,0.16667,0.1,0.16667,0.12,0.16667,0.14,0.16667,0.16,0.16667,0.18,0.16667,0.2,0.16667,0.22,0.16667,0.24,0.16667,0.26,0.16667,0.28,0.16667,0.3,0.16667,0.32,0.16667,0.34,0.16667,0.36,0.16667,0.38,0.16667,0.4,0.16667,0.42,0.16667,0.44,0.16667,0.46,0.16667,0.48,0.16667,0.5,0.16667,0.52,0.16667,0.54,0.16667,0.56,0.16667,0.58,0.16667,0.6,0.16667,0.62,0.16667,0.64,0.16667,0.66,0.16667,0.68,0.16667,0.7,0.16667,0.72,0.16667,0.74,0.16667,0.76,0.16667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.78,0.16667,0.8,0.16667,0.82,0.16667,0.84,0.16667,0.86,0.16667,0.88,0.16667,0.9,0.16667,0.92,0.16667,0.94,0.16667,0.96,0.16667,0.98,0.16667,0.99609,0.16667,0.00391,0.18182,0.02,0.18182,0.04,0.18182,0.06,0.18182,0.08,0.18182,0.1,0.18182,0.12,0.18182,0.14,0.18182,0.16,0.18182,0.18,0.18182,0.2,0.18182,0.22,0.18182,0.24,0.18182,0.26,0.18182,0.28,0.18182,0.3,0.18182,0.32,0.18182,0.34,0.18182,0.36,0.18182,0.38,0.18182,0.4,0.18182,0.42,0.18182,0.44,0.18182,0.46,0.18182,0.48,0.18182,0.5,0.18182,0.52,0.18182,0.54,0.18182,0.56,0.18182,0.58,0.18182,0.6,0.18182,0.62,0.18182,0.64,0.18182,0.66,0.18182,0.68,0.18182,0.7,0.18182,0.72,0.18182,0.74,0.18182,0.76,0.18182,0.78,0.18182,0.8,0.18182,0.82,0.18182,0.84,0.18182,0.86,0.18182,0.88,0.18182,0.9,0.18182,0.92,0.18182,0.94,0.18182,0.96,0.18182,0.98,0.18182,0.99609,0.18182,0.00391,0.19697,0.02,0.19697,0.04,0.19697,0.06,0.19697,0.08,0.19697,0.1,0.19697,0.12,0.19697,0.14,0.19697,0.16,0.19697,0.18,0.19697,0.2,0.19697,0.22,0.19697,0.24,0.19697,0.26,0.19697,0.28,0.19697,0.3,0.19697,0.32,0.19697,0.34,0.19697,0.36,0.19697,0.38,0.19697,0.4,0.19697,0.42,0.19697,0.44,0.19697,0.46,0.19697,0.48,0.19697,0.5,0.19697,0.52,0.19697,0.54,0.19697,0.56,0.19697,0.58,0.19697,0.6,0.19697,0.62,0.19697,0.64,0.19697,0.66,0.19697,0.68,0.19697,0.7,0.19697,0.72,0.19697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.74,0.19697,0.76,0.19697,0.78,0.19697,0.8,0.19697,0.82,0.19697,0.84,0.19697,0.86,0.19697,0.88,0.19697,0.9,0.19697,0.92,0.19697,0.94,0.19697,0.96,0.19697,0.98,0.19697,0.99609,0.19697,0.00391,0.21212,0.02,0.21212,0.04,0.21212,0.06,0.21212,0.08,0.21212,0.1,0.21212,0.12,0.21212,0.14,0.21212,0.16,0.21212,0.18,0.21212,0.2,0.21212,0.22,0.21212,0.24,0.21212,0.26,0.21212,0.28,0.21212,0.3,0.21212,0.32,0.21212,0.34,0.21212,0.36,0.21212,0.38,0.21212,0.4,0.21212,0.42,0.21212,0.44,0.21212,0.46,0.21212,0.48,0.21212,0.5,0.21212,0.52,0.21212,0.54,0.21212,0.56,0.21212,0.58,0.21212,0.6,0.21212,0.62,0.21212,0.64,0.21212,0.66,0.21212,0.68,0.21212,0.7,0.21212,0.72,0.21212,0.74,0.21212,0.76,0.21212,0.78,0.21212,0.8,0.21212,0.82,0.21212,0.84,0.21212,0.86,0.21212,0.88,0.21212,0.9,0.21212,0.92,0.21212,0.94,0.21212,0.96,0.21212,0.98,0.21212,0.99609,0.21212,0.00391,0.22727,0.02,0.22727,0.04,0.22727,0.06,0.22727,0.08,0.22727,0.1,0.22727,0.12,0.22727,0.14,0.22727,0.16,0.22727,0.18,0.22727,0.2,0.22727,0.22,0.22727,0.24,0.22727,0.26,0.22727,0.28,0.22727,0.3,0.22727,0.32,0.22727,0.34,0.22727,0.36,0.22727,0.38,0.22727,0.4,0.22727,0.42,0.22727,0.44,0.22727,0.46,0.22727,0.48,0.22727,0.5,0.22727,0.52,0.22727,0.54,0.22727,0.56,0.22727,0.58,0.22727,0.6,0.22727,0.62,0.22727,0.64,0.22727,0.66,0.22727,0.68,0.22727};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.7,0.22727,0.72,0.22727,0.74,0.22727,0.76,0.22727,0.78,0.22727,0.8,0.22727,0.82,0.22727,0.84,0.22727,0.86,0.22727,0.88,0.22727,0.9,0.22727,0.92,0.22727,0.94,0.22727,0.96,0.22727,0.98,0.22727,0.99609,0.22727,0.00391,0.24242,0.02,0.24242,0.04,0.24242,0.06,0.24242,0.08,0.24242,0.1,0.24242,0.12,0.24242,0.14,0.24242,0.16,0.24242,0.18,0.24242,0.2,0.24242,0.22,0.24242,0.24,0.24242,0.26,0.24242,0.28,0.24242,0.3,0.24242,0.32,0.24242,0.34,0.24242,0.36,0.24242,0.38,0.24242,0.4,0.24242,0.42,0.24242,0.44,0.24242,0.46,0.24242,0.48,0.24242,0.5,0.24242,0.52,0.24242,0.54,0.24242,0.56,0.24242,0.58,0.24242,0.6,0.24242,0.62,0.24242,0.64,0.24242,0.66,0.24242,0.68,0.24242,0.7,0.24242,0.72,0.24242,0.74,0.24242,0.76,0.24242,0.78,0.24242,0.8,0.24242,0.82,0.24242,0.84,0.24242,0.86,0.24242,0.88,0.24242,0.9,0.24242,0.92,0.24242,0.94,0.24242,0.96,0.24242,0.98,0.24242,0.99609,0.24242,0.00391,0.25758,0.02,0.25758,0.04,0.25758,0.06,0.25758,0.08,0.25758,0.1,0.25758,0.12,0.25758,0.14,0.25758,0.16,0.25758,0.18,0.25758,0.2,0.25758,0.22,0.25758,0.24,0.25758,0.26,0.25758,0.28,0.25758,0.3,0.25758,0.32,0.25758,0.34,0.25758,0.36,0.25758,0.38,0.25758,0.4,0.25758,0.42,0.25758,0.44,0.25758,0.46,0.25758,0.48,0.25758,0.5,0.25758,0.52,0.25758,0.54,0.25758,0.56,0.25758,0.58,0.25758,0.6,0.25758,0.62,0.25758,0.64,0.25758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.66,0.25758,0.68,0.25758,0.7,0.25758,0.72,0.25758,0.74,0.25758,0.76,0.25758,0.78,0.25758,0.8,0.25758,0.82,0.25758,0.84,0.25758,0.86,0.25758,0.88,0.25758,0.9,0.25758,0.92,0.25758,0.94,0.25758,0.96,0.25758,0.98,0.25758,0.99609,0.25758,0.00391,0.27273,0.02,0.27273,0.04,0.27273,0.06,0.27273,0.08,0.27273,0.1,0.27273,0.12,0.27273,0.14,0.27273,0.16,0.27273,0.18,0.27273,0.2,0.27273,0.22,0.27273,0.24,0.27273,0.26,0.27273,0.28,0.27273,0.3,0.27273,0.32,0.27273,0.34,0.27273,0.36,0.27273,0.38,0.27273,0.4,0.27273,0.42,0.27273,0.44,0.27273,0.46,0.27273,0.48,0.27273,0.5,0.27273,0.52,0.27273,0.54,0.27273,0.56,0.27273,0.58,0.27273,0.6,0.27273,0.62,0.27273,0.64,0.27273,0.66,0.27273,0.68,0.27273,0.7,0.27273,0.72,0.27273,0.74,0.27273,0.76,0.27273,0.78,0.27273,0.8,0.27273,0.82,0.27273,0.84,0.27273,0.86,0.27273,0.88,0.27273,0.9,0.27273,0.92,0.27273,0.94,0.27273,0.96,0.27273,0.98,0.27273,0.99609,0.27273,0.00391,0.28788,0.02,0.28788,0.04,0.28788,0.06,0.28788,0.08,0.28788,0.1,0.28788,0.12,0.28788,0.14,0.28788,0.16,0.28788,0.18,0.28788,0.2,0.28788,0.22,0.28788,0.24,0.28788,0.26,0.28788,0.28,0.28788,0.3,0.28788,0.32,0.28788,0.34,0.28788,0.36,0.28788,0.38,0.28788,0.4,0.28788,0.42,0.28788,0.44,0.28788,0.46,0.28788,0.48,0.28788,0.5,0.28788,0.52,0.28788,0.54,0.28788,0.56,0.28788,0.58,0.28788,0.6,0.28788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.62,0.28788,0.64,0.28788,0.66,0.28788,0.68,0.28788,0.7,0.28788,0.72,0.28788,0.74,0.28788,0.76,0.28788,0.78,0.28788,0.8,0.28788,0.82,0.28788,0.84,0.28788,0.86,0.28788,0.88,0.28788,0.9,0.28788,0.92,0.28788,0.94,0.28788,0.96,0.28788,0.98,0.28788,0.99609,0.28788,0.00391,0.30303,0.02,0.30303,0.04,0.30303,0.06,0.30303,0.08,0.30303,0.1,0.30303,0.12,0.30303,0.14,0.30303,0.16,0.30303,0.18,0.30303,0.2,0.30303,0.22,0.30303,0.24,0.30303,0.26,0.30303,0.28,0.30303,0.3,0.30303,0.32,0.30303,0.34,0.30303,0.36,0.30303,0.38,0.30303,0.4,0.30303,0.42,0.30303,0.44,0.30303,0.46,0.30303,0.48,0.30303,0.5,0.30303,0.52,0.30303,0.54,0.30303,0.56,0.30303,0.58,0.30303,0.6,0.30303,0.62,0.30303,0.64,0.30303,0.66,0.30303,0.68,0.30303,0.7,0.30303,0.72,0.30303,0.74,0.30303,0.76,0.30303,0.78,0.30303,0.8,0.30303,0.82,0.30303,0.84,0.30303,0.86,0.30303,0.88,0.30303,0.9,0.30303,0.92,0.30303,0.94,0.30303,0.96,0.30303,0.98,0.30303,0.99609,0.30303,0.00391,0.31818,0.02,0.31818,0.04,0.31818,0.06,0.31818,0.08,0.31818,0.1,0.31818,0.12,0.31818,0.14,0.31818,0.16,0.31818,0.18,0.31818,0.2,0.31818,0.22,0.31818,0.24,0.31818,0.26,0.31818,0.28,0.31818,0.3,0.31818,0.32,0.31818,0.34,0.31818,0.36,0.31818,0.38,0.31818,0.4,0.31818,0.42,0.31818,0.44,0.31818,0.46,0.31818,0.48,0.31818,0.5,0.31818,0.52,0.31818,0.54,0.31818,0.56,0.31818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.58,0.31818,0.6,0.31818,0.62,0.31818,0.64,0.31818,0.66,0.31818,0.68,0.31818,0.7,0.31818,0.72,0.31818,0.74,0.31818,0.76,0.31818,0.78,0.31818,0.8,0.31818,0.82,0.31818,0.84,0.31818,0.86,0.31818,0.88,0.31818,0.9,0.31818,0.92,0.31818,0.94,0.31818,0.96,0.31818,0.98,0.31818,0.99609,0.31818,0.00391,0.33333,0.02,0.33333,0.04,0.33333,0.06,0.33333,0.08,0.33333,0.1,0.33333,0.12,0.33333,0.14,0.33333,0.16,0.33333,0.18,0.33333,0.2,0.33333,0.22,0.33333,0.24,0.33333,0.26,0.33333,0.28,0.33333,0.3,0.33333,0.32,0.33333,0.34,0.33333,0.36,0.33333,0.38,0.33333,0.4,0.33333,0.42,0.33333,0.44,0.33333,0.46,0.33333,0.48,0.33333,0.5,0.33333,0.52,0.33333,0.54,0.33333,0.56,0.33333,0.58,0.33333,0.6,0.33333,0.62,0.33333,0.64,0.33333,0.66,0.33333,0.68,0.33333,0.7,0.33333,0.72,0.33333,0.74,0.33333,0.76,0.33333,0.78,0.33333,0.8,0.33333,0.82,0.33333,0.84,0.33333,0.86,0.33333,0.88,0.33333,0.9,0.33333,0.92,0.33333,0.94,0.33333,0.96,0.33333,0.98,0.33333,0.99609,0.33333,0.00391,0.34848,0.02,0.34848,0.04,0.34848,0.06,0.34848,0.08,0.34848,0.1,0.34848,0.12,0.34848,0.14,0.34848,0.16,0.34848,0.18,0.34848,0.2,0.34848,0.22,0.34848,0.24,0.34848,0.26,0.34848,0.28,0.34848,0.3,0.34848,0.32,0.34848,0.34,0.34848,0.36,0.34848,0.38,0.34848,0.4,0.34848,0.42,0.34848,0.44,0.34848,0.46,0.34848,0.48,0.34848,0.5,0.34848,0.52,0.34848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.54,0.34848,0.56,0.34848,0.58,0.34848,0.6,0.34848,0.62,0.34848,0.64,0.34848,0.66,0.34848,0.68,0.34848,0.7,0.34848,0.72,0.34848,0.74,0.34848,0.76,0.34848,0.78,0.34848,0.8,0.34848,0.82,0.34848,0.84,0.34848,0.86,0.34848,0.88,0.34848,0.9,0.34848,0.92,0.34848,0.94,0.34848,0.96,0.34848,0.98,0.34848,0.99609,0.34848,0.00391,0.36364,0.02,0.36364,0.04,0.36364,0.06,0.36364,0.08,0.36364,0.1,0.36364,0.12,0.36364,0.14,0.36364,0.16,0.36364,0.18,0.36364,0.2,0.36364,0.22,0.36364,0.24,0.36364,0.26,0.36364,0.28,0.36364,0.3,0.36364,0.32,0.36364,0.34,0.36364,0.36,0.36364,0.38,0.36364,0.4,0.36364,0.42,0.36364,0.44,0.36364,0.46,0.36364,0.48,0.36364,0.5,0.36364,0.52,0.36364,0.54,0.36364,0.56,0.36364,0.58,0.36364,0.6,0.36364,0.62,0.36364,0.64,0.36364,0.66,0.36364,0.68,0.36364,0.7,0.36364,0.72,0.36364,0.74,0.36364,0.76,0.36364,0.78,0.36364,0.8,0.36364,0.82,0.36364,0.84,0.36364,0.86,0.36364,0.88,0.36364,0.9,0.36364,0.92,0.36364,0.94,0.36364,0.96,0.36364,0.98,0.36364,0.99609,0.36364,0.00391,0.37879,0.02,0.37879,0.04,0.37879,0.06,0.37879,0.08,0.37879,0.1,0.37879,0.12,0.37879,0.14,0.37879,0.16,0.37879,0.18,0.37879,0.2,0.37879,0.22,0.37879,0.24,0.37879,0.26,0.37879,0.28,0.37879,0.3,0.37879,0.32,0.37879,0.34,0.37879,0.36,0.37879,0.38,0.37879,0.4,0.37879,0.42,0.37879,0.44,0.37879,0.46,0.37879,0.48,0.37879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.5,0.37879,0.52,0.37879,0.54,0.37879,0.56,0.37879,0.58,0.37879,0.6,0.37879,0.62,0.37879,0.64,0.37879,0.66,0.37879,0.68,0.37879,0.7,0.37879,0.72,0.37879,0.74,0.37879,0.76,0.37879,0.78,0.37879,0.8,0.37879,0.82,0.37879,0.84,0.37879,0.86,0.37879,0.88,0.37879,0.9,0.37879,0.92,0.37879,0.94,0.37879,0.96,0.37879,0.98,0.37879,0.99609,0.37879,0.00391,0.39394,0.02,0.39394,0.04,0.39394,0.06,0.39394,0.08,0.39394,0.1,0.39394,0.12,0.39394,0.14,0.39394,0.16,0.39394,0.18,0.39394,0.2,0.39394,0.22,0.39394,0.24,0.39394,0.26,0.39394,0.28,0.39394,0.3,0.39394,0.32,0.39394,0.34,0.39394,0.36,0.39394,0.38,0.39394,0.4,0.39394,0.42,0.39394,0.44,0.39394,0.46,0.39394,0.48,0.39394,0.5,0.39394,0.52,0.39394,0.54,0.39394,0.56,0.39394,0.58,0.39394,0.6,0.39394,0.62,0.39394,0.64,0.39394,0.66,0.39394,0.68,0.39394,0.7,0.39394,0.72,0.39394,0.74,0.39394,0.76,0.39394,0.78,0.39394,0.8,0.39394,0.82,0.39394,0.84,0.39394,0.86,0.39394,0.88,0.39394,0.9,0.39394,0.92,0.39394,0.94,0.39394,0.96,0.39394,0.98,0.39394,0.99609,0.39394,0.00391,0.40909,0.02,0.40909,0.04,0.40909,0.06,0.40909,0.08,0.40909,0.1,0.40909,0.12,0.40909,0.14,0.40909,0.16,0.40909,0.18,0.40909,0.2,0.40909,0.22,0.40909,0.24,0.40909,0.26,0.40909,0.28,0.40909,0.3,0.40909,0.32,0.40909,0.34,0.40909,0.36,0.40909,0.38,0.40909,0.4,0.40909,0.42,0.40909,0.44,0.40909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.46,0.40909,0.48,0.40909,0.5,0.40909,0.52,0.40909,0.54,0.40909,0.56,0.40909,0.58,0.40909,0.6,0.40909,0.62,0.40909,0.64,0.40909,0.66,0.40909,0.68,0.40909,0.7,0.40909,0.72,0.40909,0.74,0.40909,0.76,0.40909,0.78,0.40909,0.8,0.40909,0.82,0.40909,0.84,0.40909,0.86,0.40909,0.88,0.40909,0.9,0.40909,0.92,0.40909,0.94,0.40909,0.96,0.40909,0.98,0.40909,0.99609,0.40909,0.00391,0.42424,0.02,0.42424,0.04,0.42424,0.06,0.42424,0.08,0.42424,0.1,0.42424,0.12,0.42424,0.14,0.42424,0.16,0.42424,0.18,0.42424,0.2,0.42424,0.22,0.42424,0.24,0.42424,0.26,0.42424,0.28,0.42424,0.3,0.42424,0.32,0.42424,0.34,0.42424,0.36,0.42424,0.38,0.42424,0.4,0.42424,0.42,0.42424,0.44,0.42424,0.46,0.42424,0.48,0.42424,0.5,0.42424,0.52,0.42424,0.54,0.42424,0.56,0.42424,0.58,0.42424,0.6,0.42424,0.62,0.42424,0.64,0.42424,0.66,0.42424,0.68,0.42424,0.7,0.42424,0.72,0.42424,0.74,0.42424,0.76,0.42424,0.78,0.42424,0.8,0.42424,0.82,0.42424,0.84,0.42424,0.86,0.42424,0.88,0.42424,0.9,0.42424,0.92,0.42424,0.94,0.42424,0.96,0.42424,0.98,0.42424,0.99609,0.42424,0.00391,0.43939,0.02,0.43939,0.04,0.43939,0.06,0.43939,0.08,0.43939,0.1,0.43939,0.12,0.43939,0.14,0.43939,0.16,0.43939,0.18,0.43939,0.2,0.43939,0.22,0.43939,0.24,0.43939,0.26,0.43939,0.28,0.43939,0.3,0.43939,0.32,0.43939,0.34,0.43939,0.36,0.43939,0.38,0.43939,0.4,0.43939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.42,0.43939,0.44,0.43939,0.46,0.43939,0.48,0.43939,0.5,0.43939,0.52,0.43939,0.54,0.43939,0.56,0.43939,0.58,0.43939,0.6,0.43939,0.62,0.43939,0.64,0.43939,0.66,0.43939,0.68,0.43939,0.7,0.43939,0.72,0.43939,0.74,0.43939,0.76,0.43939,0.78,0.43939,0.8,0.43939,0.82,0.43939,0.84,0.43939,0.86,0.43939,0.88,0.43939,0.9,0.43939,0.92,0.43939,0.94,0.43939,0.96,0.43939,0.98,0.43939,0.99609,0.43939,0.00391,0.45455,0.02,0.45455,0.04,0.45455,0.06,0.45455,0.08,0.45455,0.1,0.45455,0.12,0.45455,0.14,0.45455,0.16,0.45455,0.18,0.45455,0.2,0.45455,0.22,0.45455,0.24,0.45455,0.26,0.45455,0.28,0.45455,0.3,0.45455,0.32,0.45455,0.34,0.45455,0.36,0.45455,0.38,0.45455,0.4,0.45455,0.42,0.45455,0.44,0.45455,0.46,0.45455,0.48,0.45455,0.5,0.45455,0.52,0.45455,0.54,0.45455,0.56,0.45455,0.58,0.45455,0.6,0.45455,0.62,0.45455,0.64,0.45455,0.66,0.45455,0.68,0.45455,0.7,0.45455,0.72,0.45455,0.74,0.45455,0.76,0.45455,0.78,0.45455,0.8,0.45455,0.82,0.45455,0.84,0.45455,0.86,0.45455,0.88,0.45455,0.9,0.45455,0.92,0.45455,0.94,0.45455,0.96,0.45455,0.98,0.45455,0.99609,0.45455,0.00391,0.4697,0.02,0.4697,0.04,0.4697,0.06,0.4697,0.08,0.4697,0.1,0.4697,0.12,0.4697,0.14,0.4697,0.16,0.4697,0.18,0.4697,0.2,0.4697,0.22,0.4697,0.24,0.4697,0.26,0.4697,0.28,0.4697,0.3,0.4697,0.32,0.4697,0.34,0.4697,0.36,0.4697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.38,0.4697,0.4,0.4697,0.42,0.4697,0.44,0.4697,0.46,0.4697,0.48,0.4697,0.5,0.4697,0.52,0.4697,0.54,0.4697,0.56,0.4697,0.58,0.4697,0.6,0.4697,0.62,0.4697,0.64,0.4697,0.66,0.4697,0.68,0.4697,0.7,0.4697,0.72,0.4697,0.74,0.4697,0.76,0.4697,0.78,0.4697,0.8,0.4697,0.82,0.4697,0.84,0.4697,0.86,0.4697,0.88,0.4697,0.9,0.4697,0.92,0.4697,0.94,0.4697,0.96,0.4697,0.98,0.4697,0.99609,0.4697,0.00391,0.48485,0.02,0.48485,0.04,0.48485,0.06,0.48485,0.08,0.48485,0.1,0.48485,0.12,0.48485,0.14,0.48485,0.16,0.48485,0.18,0.48485,0.2,0.48485,0.22,0.48485,0.24,0.48485,0.26,0.48485,0.28,0.48485,0.3,0.48485,0.32,0.48485,0.34,0.48485,0.36,0.48485,0.38,0.48485,0.4,0.48485,0.42,0.48485,0.44,0.48485,0.46,0.48485,0.48,0.48485,0.5,0.48485,0.52,0.48485,0.54,0.48485,0.56,0.48485,0.58,0.48485,0.6,0.48485,0.62,0.48485,0.64,0.48485,0.66,0.48485,0.68,0.48485,0.7,0.48485,0.72,0.48485,0.74,0.48485,0.76,0.48485,0.78,0.48485,0.8,0.48485,0.82,0.48485,0.84,0.48485,0.86,0.48485,0.88,0.48485,0.9,0.48485,0.92,0.48485,0.94,0.48485,0.96,0.48485,0.98,0.48485,0.99609,0.48485,0.00391,0.5,0.02,0.5,0.04,0.5,0.06,0.5,0.08,0.5,0.1,0.5,0.12,0.5,0.14,0.5,0.16,0.5,0.18,0.5,0.2,0.5,0.22,0.5,0.24,0.5,0.26,0.5,0.28,0.5,0.3,0.5,0.32,0.5};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.34,0.5,0.36,0.5,0.38,0.5,0.4,0.5,0.42,0.5,0.44,0.5,0.46,0.5,0.48,0.5,0.5,0.5,0.52,0.5,0.54,0.5,0.56,0.5,0.58,0.5,0.6,0.5,0.62,0.5,0.64,0.5,0.66,0.5,0.68,0.5,0.7,0.5,0.72,0.5,0.74,0.5,0.76,0.5,0.78,0.5,0.8,0.5,0.82,0.5,0.84,0.5,0.86,0.5,0.88,0.5,0.9,0.5,0.92,0.5,0.94,0.5,0.96,0.5,0.98,0.5,0.99609,0.5,0.00391,0.51515,0.02,0.51515,0.04,0.51515,0.06,0.51515,0.08,0.51515,0.1,0.51515,0.12,0.51515,0.14,0.51515,0.16,0.51515,0.18,0.51515,0.2,0.51515,0.22,0.51515,0.24,0.51515,0.26,0.51515,0.28,0.51515,0.3,0.51515,0.32,0.51515,0.34,0.51515,0.36,0.51515,0.38,0.51515,0.4,0.51515,0.42,0.51515,0.44,0.51515,0.46,0.51515,0.48,0.51515,0.5,0.51515,0.52,0.51515,0.54,0.51515,0.56,0.51515,0.58,0.51515,0.6,0.51515,0.62,0.51515,0.64,0.51515,0.66,0.51515,0.68,0.51515,0.7,0.51515,0.72,0.51515,0.74,0.51515,0.76,0.51515,0.78,0.51515,0.8,0.51515,0.82,0.51515,0.84,0.51515,0.86,0.51515,0.88,0.51515,0.9,0.51515,0.92,0.51515,0.94,0.51515,0.96,0.51515,0.98,0.51515,0.99609,0.51515,0.00391,0.5303,0.02,0.5303,0.04,0.5303,0.06,0.5303,0.08,0.5303,0.1,0.5303,0.12,0.5303,0.14,0.5303,0.16,0.5303,0.18,0.5303,0.2,0.5303,0.22,0.5303,0.24,0.5303,0.26,0.5303,0.28,0.5303};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.3,0.5303,0.32,0.5303,0.34,0.5303,0.36,0.5303,0.38,0.5303,0.4,0.5303,0.42,0.5303,0.44,0.5303,0.46,0.5303,0.48,0.5303,0.5,0.5303,0.52,0.5303,0.54,0.5303,0.56,0.5303,0.58,0.5303,0.6,0.5303,0.62,0.5303,0.64,0.5303,0.66,0.5303,0.68,0.5303,0.7,0.5303,0.72,0.5303,0.74,0.5303,0.76,0.5303,0.78,0.5303,0.8,0.5303,0.82,0.5303,0.84,0.5303,0.86,0.5303,0.88,0.5303,0.9,0.5303,0.92,0.5303,0.94,0.5303,0.96,0.5303,0.98,0.5303,0.99609,0.5303,0.00391,0.54545,0.02,0.54545,0.04,0.54545,0.06,0.54545,0.08,0.54545,0.1,0.54545,0.12,0.54545,0.14,0.54545,0.16,0.54545,0.18,0.54545,0.2,0.54545,0.22,0.54545,0.24,0.54545,0.26,0.54545,0.28,0.54545,0.3,0.54545,0.32,0.54545,0.34,0.54545,0.36,0.54545,0.38,0.54545,0.4,0.54545,0.42,0.54545,0.44,0.54545,0.46,0.54545,0.48,0.54545,0.5,0.54545,0.52,0.54545,0.54,0.54545,0.56,0.54545,0.58,0.54545,0.6,0.54545,0.62,0.54545,0.64,0.54545,0.66,0.54545,0.68,0.54545,0.7,0.54545,0.72,0.54545,0.74,0.54545,0.76,0.54545,0.78,0.54545,0.8,0.54545,0.82,0.54545,0.84,0.54545,0.86,0.54545,0.88,0.54545,0.9,0.54545,0.92,0.54545,0.94,0.54545,0.96,0.54545,0.98,0.54545,0.99609,0.54545,0.00391,0.56061,0.02,0.56061,0.04,0.56061,0.06,0.56061,0.08,0.56061,0.1,0.56061,0.12,0.56061,0.14,0.56061,0.16,0.56061,0.18,0.56061,0.2,0.56061,0.22,0.56061,0.24,0.56061};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.26,0.56061,0.28,0.56061,0.3,0.56061,0.32,0.56061,0.34,0.56061,0.36,0.56061,0.38,0.56061,0.4,0.56061,0.42,0.56061,0.44,0.56061,0.46,0.56061,0.48,0.56061,0.5,0.56061,0.52,0.56061,0.54,0.56061,0.56,0.56061,0.58,0.56061,0.6,0.56061,0.62,0.56061,0.64,0.56061,0.66,0.56061,0.68,0.56061,0.7,0.56061,0.72,0.56061,0.74,0.56061,0.76,0.56061,0.78,0.56061,0.8,0.56061,0.82,0.56061,0.84,0.56061,0.86,0.56061,0.88,0.56061,0.9,0.56061,0.92,0.56061,0.94,0.56061,0.96,0.56061,0.98,0.56061,0.99609,0.56061,0.00391,0.57576,0.02,0.57576,0.04,0.57576,0.06,0.57576,0.08,0.57576,0.1,0.57576,0.12,0.57576,0.14,0.57576,0.16,0.57576,0.18,0.57576,0.2,0.57576,0.22,0.57576,0.24,0.57576,0.26,0.57576,0.28,0.57576,0.3,0.57576,0.32,0.57576,0.34,0.57576,0.36,0.57576,0.38,0.57576,0.4,0.57576,0.42,0.57576,0.44,0.57576,0.46,0.57576,0.48,0.57576,0.5,0.57576,0.52,0.57576,0.54,0.57576,0.56,0.57576,0.58,0.57576,0.6,0.57576,0.62,0.57576,0.64,0.57576,0.66,0.57576,0.68,0.57576,0.7,0.57576,0.72,0.57576,0.74,0.57576,0.76,0.57576,0.78,0.57576,0.8,0.57576,0.82,0.57576,0.84,0.57576,0.86,0.57576,0.88,0.57576,0.9,0.57576,0.92,0.57576,0.94,0.57576,0.96,0.57576,0.98,0.57576,0.99609,0.57576,0.00391,0.59091,0.02,0.59091,0.04,0.59091,0.06,0.59091,0.08,0.59091,0.1,0.59091,0.12,0.59091,0.14,0.59091,0.16,0.59091,0.18,0.59091,0.2,0.59091};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.22,0.59091,0.24,0.59091,0.26,0.59091,0.28,0.59091,0.3,0.59091,0.32,0.59091,0.34,0.59091,0.36,0.59091,0.38,0.59091,0.4,0.59091,0.42,0.59091,0.44,0.59091,0.46,0.59091,0.48,0.59091,0.5,0.59091,0.52,0.59091,0.54,0.59091,0.56,0.59091,0.58,0.59091,0.6,0.59091,0.62,0.59091,0.64,0.59091,0.66,0.59091,0.68,0.59091,0.7,0.59091,0.72,0.59091,0.74,0.59091,0.76,0.59091,0.78,0.59091,0.8,0.59091,0.82,0.59091,0.84,0.59091,0.86,0.59091,0.88,0.59091,0.9,0.59091,0.92,0.59091,0.94,0.59091,0.96,0.59091,0.98,0.59091,0.99609,0.59091,0.00391,0.60606,0.02,0.60606,0.04,0.60606,0.06,0.60606,0.08,0.60606,0.1,0.60606,0.12,0.60606,0.14,0.60606,0.16,0.60606,0.18,0.60606,0.2,0.60606,0.22,0.60606,0.24,0.60606,0.26,0.60606,0.28,0.60606,0.3,0.60606,0.32,0.60606,0.34,0.60606,0.36,0.60606,0.38,0.60606,0.4,0.60606,0.42,0.60606,0.44,0.60606,0.46,0.60606,0.48,0.60606,0.5,0.60606,0.52,0.60606,0.54,0.60606,0.56,0.60606,0.58,0.60606,0.6,0.60606,0.62,0.60606,0.64,0.60606,0.66,0.60606,0.68,0.60606,0.7,0.60606,0.72,0.60606,0.74,0.60606,0.76,0.60606,0.78,0.60606,0.8,0.60606,0.82,0.60606,0.84,0.60606,0.86,0.60606,0.88,0.60606,0.9,0.60606,0.92,0.60606,0.94,0.60606,0.96,0.60606,0.98,0.60606,0.99609,0.60606,0.00391,0.62121,0.02,0.62121,0.04,0.62121,0.06,0.62121,0.08,0.62121,0.1,0.62121,0.12,0.62121,0.14,0.62121,0.16,0.62121};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.18,0.62121,0.2,0.62121,0.22,0.62121,0.24,0.62121,0.26,0.62121,0.28,0.62121,0.3,0.62121,0.32,0.62121,0.34,0.62121,0.36,0.62121,0.38,0.62121,0.4,0.62121,0.42,0.62121,0.44,0.62121,0.46,0.62121,0.48,0.62121,0.5,0.62121,0.52,0.62121,0.54,0.62121,0.56,0.62121,0.58,0.62121,0.6,0.62121,0.62,0.62121,0.64,0.62121,0.66,0.62121,0.68,0.62121,0.7,0.62121,0.72,0.62121,0.74,0.62121,0.76,0.62121,0.78,0.62121,0.8,0.62121,0.82,0.62121,0.84,0.62121,0.86,0.62121,0.88,0.62121,0.9,0.62121,0.92,0.62121,0.94,0.62121,0.96,0.62121,0.98,0.62121,0.99609,0.62121,0.00391,0.63636,0.02,0.63636,0.04,0.63636,0.06,0.63636,0.08,0.63636,0.1,0.63636,0.12,0.63636,0.14,0.63636,0.16,0.63636,0.18,0.63636,0.2,0.63636,0.22,0.63636,0.24,0.63636,0.26,0.63636,0.28,0.63636,0.3,0.63636,0.32,0.63636,0.34,0.63636,0.36,0.63636,0.38,0.63636,0.4,0.63636,0.42,0.63636,0.44,0.63636,0.46,0.63636,0.48,0.63636,0.5,0.63636,0.52,0.63636,0.54,0.63636,0.56,0.63636,0.58,0.63636,0.6,0.63636,0.62,0.63636,0.64,0.63636,0.66,0.63636,0.68,0.63636,0.7,0.63636,0.72,0.63636,0.74,0.63636,0.76,0.63636,0.78,0.63636,0.8,0.63636,0.82,0.63636,0.84,0.63636,0.86,0.63636,0.88,0.63636,0.9,0.63636,0.92,0.63636,0.94,0.63636,0.96,0.63636,0.98,0.63636,0.99609,0.63636,0.00391,0.65152,0.02,0.65152,0.04,0.65152,0.06,0.65152,0.08,0.65152,0.1,0.65152,0.12,0.65152};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.14,0.65152,0.16,0.65152,0.18,0.65152,0.2,0.65152,0.22,0.65152,0.24,0.65152,0.26,0.65152,0.28,0.65152,0.3,0.65152,0.32,0.65152,0.34,0.65152,0.36,0.65152,0.38,0.65152,0.4,0.65152,0.42,0.65152,0.44,0.65152,0.46,0.65152,0.48,0.65152,0.5,0.65152,0.52,0.65152,0.54,0.65152,0.56,0.65152,0.58,0.65152,0.6,0.65152,0.62,0.65152,0.64,0.65152,0.66,0.65152,0.68,0.65152,0.7,0.65152,0.72,0.65152,0.74,0.65152,0.76,0.65152,0.78,0.65152,0.8,0.65152,0.82,0.65152,0.84,0.65152,0.86,0.65152,0.88,0.65152,0.9,0.65152,0.92,0.65152,0.94,0.65152,0.96,0.65152,0.98,0.65152,0.99609,0.65152,0.00391,0.66667,0.02,0.66667,0.04,0.66667,0.06,0.66667,0.08,0.66667,0.1,0.66667,0.12,0.66667,0.14,0.66667,0.16,0.66667,0.18,0.66667,0.2,0.66667,0.22,0.66667,0.24,0.66667,0.26,0.66667,0.28,0.66667,0.3,0.66667,0.32,0.66667,0.34,0.66667,0.36,0.66667,0.38,0.66667,0.4,0.66667,0.42,0.66667,0.44,0.66667,0.46,0.66667,0.48,0.66667,0.5,0.66667,0.52,0.66667,0.54,0.66667,0.56,0.66667,0.58,0.66667,0.6,0.66667,0.62,0.66667,0.64,0.66667,0.66,0.66667,0.68,0.66667,0.7,0.66667,0.72,0.66667,0.74,0.66667,0.76,0.66667,0.78,0.66667,0.8,0.66667,0.82,0.66667,0.84,0.66667,0.86,0.66667,0.88,0.66667,0.9,0.66667,0.92,0.66667,0.94,0.66667,0.96,0.66667,0.98,0.66667,0.99609,0.66667,0.00391,0.68182,0.02,0.68182,0.04,0.68182,0.06,0.68182,0.08,0.68182};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.1,0.68182,0.12,0.68182,0.14,0.68182,0.16,0.68182,0.18,0.68182,0.2,0.68182,0.22,0.68182,0.24,0.68182,0.26,0.68182,0.28,0.68182,0.3,0.68182,0.32,0.68182,0.34,0.68182,0.36,0.68182,0.38,0.68182,0.4,0.68182,0.42,0.68182,0.44,0.68182,0.46,0.68182,0.48,0.68182,0.5,0.68182,0.52,0.68182,0.54,0.68182,0.56,0.68182,0.58,0.68182,0.6,0.68182,0.62,0.68182,0.64,0.68182,0.66,0.68182,0.68,0.68182,0.7,0.68182,0.72,0.68182,0.74,0.68182,0.76,0.68182,0.78,0.68182,0.8,0.68182,0.82,0.68182,0.84,0.68182,0.86,0.68182,0.88,0.68182,0.9,0.68182,0.92,0.68182,0.94,0.68182,0.96,0.68182,0.98,0.68182,0.99609,0.68182,0.00391,0.69697,0.02,0.69697,0.04,0.69697,0.06,0.69697,0.08,0.69697,0.1,0.69697,0.12,0.69697,0.14,0.69697,0.16,0.69697,0.18,0.69697,0.2,0.69697,0.22,0.69697,0.24,0.69697,0.26,0.69697,0.28,0.69697,0.3,0.69697,0.32,0.69697,0.34,0.69697,0.36,0.69697,0.38,0.69697,0.4,0.69697,0.42,0.69697,0.44,0.69697,0.46,0.69697,0.48,0.69697,0.5,0.69697,0.52,0.69697,0.54,0.69697,0.56,0.69697,0.58,0.69697,0.6,0.69697,0.62,0.69697,0.64,0.69697,0.66,0.69697,0.68,0.69697,0.7,0.69697,0.72,0.69697,0.74,0.69697,0.76,0.69697,0.78,0.69697,0.8,0.69697,0.82,0.69697,0.84,0.69697,0.86,0.69697,0.88,0.69697,0.9,0.69697,0.92,0.69697,0.94,0.69697,0.96,0.69697,0.98,0.69697,0.99609,0.69697,0.00391,0.71212,0.02,0.71212,0.04,0.71212};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.06,0.71212,0.08,0.71212,0.1,0.71212,0.12,0.71212,0.14,0.71212,0.16,0.71212,0.18,0.71212,0.2,0.71212,0.22,0.71212,0.24,0.71212,0.26,0.71212,0.28,0.71212,0.3,0.71212,0.32,0.71212,0.34,0.71212,0.36,0.71212,0.38,0.71212,0.4,0.71212,0.42,0.71212,0.44,0.71212,0.46,0.71212,0.48,0.71212,0.5,0.71212,0.52,0.71212,0.54,0.71212,0.56,0.71212,0.58,0.71212,0.6,0.71212,0.62,0.71212,0.64,0.71212,0.66,0.71212,0.68,0.71212,0.7,0.71212,0.72,0.71212,0.74,0.71212,0.76,0.71212,0.78,0.71212,0.8,0.71212,0.82,0.71212,0.84,0.71212,0.86,0.71212,0.88,0.71212,0.9,0.71212,0.92,0.71212,0.94,0.71212,0.96,0.71212,0.98,0.71212,0.99609,0.71212,0.00391,0.72727,0.02,0.72727,0.04,0.72727,0.06,0.72727,0.08,0.72727,0.1,0.72727,0.12,0.72727,0.14,0.72727,0.16,0.72727,0.18,0.72727,0.2,0.72727,0.22,0.72727,0.24,0.72727,0.26,0.72727,0.28,0.72727,0.3,0.72727,0.32,0.72727,0.34,0.72727,0.36,0.72727,0.38,0.72727,0.4,0.72727,0.42,0.72727,0.44,0.72727,0.46,0.72727,0.48,0.72727,0.5,0.72727,0.52,0.72727,0.54,0.72727,0.56,0.72727,0.58,0.72727,0.6,0.72727,0.62,0.72727,0.64,0.72727,0.66,0.72727,0.68,0.72727,0.7,0.72727,0.72,0.72727,0.74,0.72727,0.76,0.72727,0.78,0.72727,0.8,0.72727,0.82,0.72727,0.84,0.72727,0.86,0.72727,0.88,0.72727,0.9,0.72727,0.92,0.72727,0.94,0.72727,0.96,0.72727,0.98,0.72727,0.99609,0.72727,0.00391,0.74242};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.02,0.74242,0.04,0.74242,0.06,0.74242,0.08,0.74242,0.1,0.74242,0.12,0.74242,0.14,0.74242,0.16,0.74242,0.18,0.74242,0.2,0.74242,0.22,0.74242,0.24,0.74242,0.26,0.74242,0.28,0.74242,0.3,0.74242,0.32,0.74242,0.34,0.74242,0.36,0.74242,0.38,0.74242,0.4,0.74242,0.42,0.74242,0.44,0.74242,0.46,0.74242,0.48,0.74242,0.5,0.74242,0.52,0.74242,0.54,0.74242,0.56,0.74242,0.58,0.74242,0.6,0.74242,0.62,0.74242,0.64,0.74242,0.66,0.74242,0.68,0.74242,0.7,0.74242,0.72,0.74242,0.74,0.74242,0.76,0.74242,0.78,0.74242,0.8,0.74242,0.82,0.74242,0.84,0.74242,0.86,0.74242,0.88,0.74242,0.9,0.74242,0.92,0.74242,0.94,0.74242,0.96,0.74242,0.98,0.74242,0.99609,0.74242,0.00391,0.75758,0.02,0.75758,0.04,0.75758,0.06,0.75758,0.08,0.75758,0.1,0.75758,0.12,0.75758,0.14,0.75758,0.16,0.75758,0.18,0.75758,0.2,0.75758,0.22,0.75758,0.24,0.75758,0.26,0.75758,0.28,0.75758,0.3,0.75758,0.32,0.75758,0.34,0.75758,0.36,0.75758,0.38,0.75758,0.4,0.75758,0.42,0.75758,0.44,0.75758,0.46,0.75758,0.48,0.75758,0.5,0.75758,0.52,0.75758,0.54,0.75758,0.56,0.75758,0.58,0.75758,0.6,0.75758,0.62,0.75758,0.64,0.75758,0.66,0.75758,0.68,0.75758,0.7,0.75758,0.72,0.75758,0.74,0.75758,0.76,0.75758,0.78,0.75758,0.8,0.75758,0.82,0.75758,0.84,0.75758,0.86,0.75758,0.88,0.75758,0.9,0.75758,0.92,0.75758,0.94,0.75758,0.96,0.75758,0.98,0.75758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.99609,0.75758,0.00391,0.77273,0.02,0.77273,0.04,0.77273,0.06,0.77273,0.08,0.77273,0.1,0.77273,0.12,0.77273,0.14,0.77273,0.16,0.77273,0.18,0.77273,0.2,0.77273,0.22,0.77273,0.24,0.77273,0.26,0.77273,0.28,0.77273,0.3,0.77273,0.32,0.77273,0.34,0.77273,0.36,0.77273,0.38,0.77273,0.4,0.77273,0.42,0.77273,0.44,0.77273,0.46,0.77273,0.48,0.77273,0.5,0.77273,0.52,0.77273,0.54,0.77273,0.56,0.77273,0.58,0.77273,0.6,0.77273,0.62,0.77273,0.64,0.77273,0.66,0.77273,0.68,0.77273,0.7,0.77273,0.72,0.77273,0.74,0.77273,0.76,0.77273,0.78,0.77273,0.8,0.77273,0.82,0.77273,0.84,0.77273,0.86,0.77273,0.88,0.77273,0.9,0.77273,0.92,0.77273,0.94,0.77273,0.96,0.77273,0.98,0.77273,0.99609,0.77273,0.00391,0.78788,0.02,0.78788,0.04,0.78788,0.06,0.78788,0.08,0.78788,0.1,0.78788,0.12,0.78788,0.14,0.78788,0.16,0.78788,0.18,0.78788,0.2,0.78788,0.22,0.78788,0.24,0.78788,0.26,0.78788,0.28,0.78788,0.3,0.78788,0.32,0.78788,0.34,0.78788,0.36,0.78788,0.38,0.78788,0.4,0.78788,0.42,0.78788,0.44,0.78788,0.46,0.78788,0.48,0.78788,0.5,0.78788,0.52,0.78788,0.54,0.78788,0.56,0.78788,0.58,0.78788,0.6,0.78788,0.62,0.78788,0.64,0.78788,0.66,0.78788,0.68,0.78788,0.7,0.78788,0.72,0.78788,0.74,0.78788,0.76,0.78788,0.78,0.78788,0.8,0.78788,0.82,0.78788,0.84,0.78788,0.86,0.78788,0.88,0.78788,0.9,0.78788,0.92,0.78788,0.94,0.78788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.96,0.78788,0.98,0.78788,0.99609,0.78788,0.00391,0.80303,0.02,0.80303,0.04,0.80303,0.06,0.80303,0.08,0.80303,0.1,0.80303,0.12,0.80303,0.14,0.80303,0.16,0.80303,0.18,0.80303,0.2,0.80303,0.22,0.80303,0.24,0.80303,0.26,0.80303,0.28,0.80303,0.3,0.80303,0.32,0.80303,0.34,0.80303,0.36,0.80303,0.38,0.80303,0.4,0.80303,0.42,0.80303,0.44,0.80303,0.46,0.80303,0.48,0.80303,0.5,0.80303,0.52,0.80303,0.54,0.80303,0.56,0.80303,0.58,0.80303,0.6,0.80303,0.62,0.80303,0.64,0.80303,0.66,0.80303,0.68,0.80303,0.7,0.80303,0.72,0.80303,0.74,0.80303,0.76,0.80303,0.78,0.80303,0.8,0.80303,0.82,0.80303,0.84,0.80303,0.86,0.80303,0.88,0.80303,0.9,0.80303,0.92,0.80303,0.94,0.80303,0.96,0.80303,0.98,0.80303,0.99609,0.80303,0.00391,0.81818,0.02,0.81818,0.04,0.81818,0.06,0.81818,0.08,0.81818,0.1,0.81818,0.12,0.81818,0.14,0.81818,0.16,0.81818,0.18,0.81818,0.2,0.81818,0.22,0.81818,0.24,0.81818,0.26,0.81818,0.28,0.81818,0.3,0.81818,0.32,0.81818,0.34,0.81818,0.36,0.81818,0.38,0.81818,0.4,0.81818,0.42,0.81818,0.44,0.81818,0.46,0.81818,0.48,0.81818,0.5,0.81818,0.52,0.81818,0.54,0.81818,0.56,0.81818,0.58,0.81818,0.6,0.81818,0.62,0.81818,0.64,0.81818,0.66,0.81818,0.68,0.81818,0.7,0.81818,0.72,0.81818,0.74,0.81818,0.76,0.81818,0.78,0.81818,0.8,0.81818,0.82,0.81818,0.84,0.81818,0.86,0.81818,0.88,0.81818,0.9,0.81818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.92,0.81818,0.94,0.81818,0.96,0.81818,0.98,0.81818,0.99609,0.81818,0.00391,0.83333,0.02,0.83333,0.04,0.83333,0.06,0.83333,0.08,0.83333,0.1,0.83333,0.12,0.83333,0.14,0.83333,0.16,0.83333,0.18,0.83333,0.2,0.83333,0.22,0.83333,0.24,0.83333,0.26,0.83333,0.28,0.83333,0.3,0.83333,0.32,0.83333,0.34,0.83333,0.36,0.83333,0.38,0.83333,0.4,0.83333,0.42,0.83333,0.44,0.83333,0.46,0.83333,0.48,0.83333,0.5,0.83333,0.52,0.83333,0.54,0.83333,0.56,0.83333,0.58,0.83333,0.6,0.83333,0.62,0.83333,0.64,0.83333,0.66,0.83333,0.68,0.83333,0.7,0.83333,0.72,0.83333,0.74,0.83333,0.76,0.83333,0.78,0.83333,0.8,0.83333,0.82,0.83333,0.84,0.83333,0.86,0.83333,0.88,0.83333,0.9,0.83333,0.92,0.83333,0.94,0.83333,0.96,0.83333,0.98,0.83333,0.99609,0.83333,0.00391,0.84848,0.02,0.84848,0.04,0.84848,0.06,0.84848,0.08,0.84848,0.1,0.84848,0.12,0.84848,0.14,0.84848,0.16,0.84848,0.18,0.84848,0.2,0.84848,0.22,0.84848,0.24,0.84848,0.26,0.84848,0.28,0.84848,0.3,0.84848,0.32,0.84848,0.34,0.84848,0.36,0.84848,0.38,0.84848,0.4,0.84848,0.42,0.84848,0.44,0.84848,0.46,0.84848,0.48,0.84848,0.5,0.84848,0.52,0.84848,0.54,0.84848,0.56,0.84848,0.58,0.84848,0.6,0.84848,0.62,0.84848,0.64,0.84848,0.66,0.84848,0.68,0.84848,0.7,0.84848,0.72,0.84848,0.74,0.84848,0.76,0.84848,0.78,0.84848,0.8,0.84848,0.82,0.84848,0.84,0.84848,0.86,0.84848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.88,0.84848,0.9,0.84848,0.92,0.84848,0.94,0.84848,0.96,0.84848,0.98,0.84848,0.99609,0.84848,0.00391,0.86364,0.02,0.86364,0.04,0.86364,0.06,0.86364,0.08,0.86364,0.1,0.86364,0.12,0.86364,0.14,0.86364,0.16,0.86364,0.18,0.86364,0.2,0.86364,0.22,0.86364,0.24,0.86364,0.26,0.86364,0.28,0.86364,0.3,0.86364,0.32,0.86364,0.34,0.86364,0.36,0.86364,0.38,0.86364,0.4,0.86364,0.42,0.86364,0.44,0.86364,0.46,0.86364,0.48,0.86364,0.5,0.86364,0.52,0.86364,0.54,0.86364,0.56,0.86364,0.58,0.86364,0.6,0.86364,0.62,0.86364,0.64,0.86364,0.66,0.86364,0.68,0.86364,0.7,0.86364,0.72,0.86364,0.74,0.86364,0.76,0.86364,0.78,0.86364,0.8,0.86364,0.82,0.86364,0.84,0.86364,0.86,0.86364,0.88,0.86364,0.9,0.86364,0.92,0.86364,0.94,0.86364,0.96,0.86364,0.98,0.86364,0.99609,0.86364,0.00391,0.87879,0.02,0.87879,0.04,0.87879,0.06,0.87879,0.08,0.87879,0.1,0.87879,0.12,0.87879,0.14,0.87879,0.16,0.87879,0.18,0.87879,0.2,0.87879,0.22,0.87879,0.24,0.87879,0.26,0.87879,0.28,0.87879,0.3,0.87879,0.32,0.87879,0.34,0.87879,0.36,0.87879,0.38,0.87879,0.4,0.87879,0.42,0.87879,0.44,0.87879,0.46,0.87879,0.48,0.87879,0.5,0.87879,0.52,0.87879,0.54,0.87879,0.56,0.87879,0.58,0.87879,0.6,0.87879,0.62,0.87879,0.64,0.87879,0.66,0.87879,0.68,0.87879,0.7,0.87879,0.72,0.87879,0.74,0.87879,0.76,0.87879,0.78,0.87879,0.8,0.87879,0.82,0.87879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.84,0.87879,0.86,0.87879,0.88,0.87879,0.9,0.87879,0.92,0.87879,0.94,0.87879,0.96,0.87879,0.98,0.87879,0.99609,0.87879,0.00391,0.89394,0.02,0.89394,0.04,0.89394,0.06,0.89394,0.08,0.89394,0.1,0.89394,0.12,0.89394,0.14,0.89394,0.16,0.89394,0.18,0.89394,0.2,0.89394,0.22,0.89394,0.24,0.89394,0.26,0.89394,0.28,0.89394,0.3,0.89394,0.32,0.89394,0.34,0.89394,0.36,0.89394,0.38,0.89394,0.4,0.89394,0.42,0.89394,0.44,0.89394,0.46,0.89394,0.48,0.89394,0.5,0.89394,0.52,0.89394,0.54,0.89394,0.56,0.89394,0.58,0.89394,0.6,0.89394,0.62,0.89394,0.64,0.89394,0.66,0.89394,0.68,0.89394,0.7,0.89394,0.72,0.89394,0.74,0.89394,0.76,0.89394,0.78,0.89394,0.8,0.89394,0.82,0.89394,0.84,0.89394,0.86,0.89394,0.88,0.89394,0.9,0.89394,0.92,0.89394,0.94,0.89394,0.96,0.89394,0.98,0.89394,0.99609,0.89394,0.00391,0.90909,0.02,0.90909,0.04,0.90909,0.06,0.90909,0.08,0.90909,0.1,0.90909,0.12,0.90909,0.14,0.90909,0.16,0.90909,0.18,0.90909,0.2,0.90909,0.22,0.90909,0.24,0.90909,0.26,0.90909,0.28,0.90909,0.3,0.90909,0.32,0.90909,0.34,0.90909,0.36,0.90909,0.38,0.90909,0.4,0.90909,0.42,0.90909,0.44,0.90909,0.46,0.90909,0.48,0.90909,0.5,0.90909,0.52,0.90909,0.54,0.90909,0.56,0.90909,0.58,0.90909,0.6,0.90909,0.62,0.90909,0.64,0.90909,0.66,0.90909,0.68,0.90909,0.7,0.90909,0.72,0.90909,0.74,0.90909,0.76,0.90909,0.78,0.90909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.8,0.90909,0.82,0.90909,0.84,0.90909,0.86,0.90909,0.88,0.90909,0.9,0.90909,0.92,0.90909,0.94,0.90909,0.96,0.90909,0.98,0.90909,0.99609,0.90909,0.00391,0.92424,0.02,0.92424,0.04,0.92424,0.06,0.92424,0.08,0.92424,0.1,0.92424,0.12,0.92424,0.14,0.92424,0.16,0.92424,0.18,0.92424,0.2,0.92424,0.22,0.92424,0.24,0.92424,0.26,0.92424,0.28,0.92424,0.3,0.92424,0.32,0.92424,0.34,0.92424,0.36,0.92424,0.38,0.92424,0.4,0.92424,0.42,0.92424,0.44,0.92424,0.46,0.92424,0.48,0.92424,0.5,0.92424,0.52,0.92424,0.54,0.92424,0.56,0.92424,0.58,0.92424,0.6,0.92424,0.62,0.92424,0.64,0.92424,0.66,0.92424,0.68,0.92424,0.7,0.92424,0.72,0.92424,0.74,0.92424,0.76,0.92424,0.78,0.92424,0.8,0.92424,0.82,0.92424,0.84,0.92424,0.86,0.92424,0.88,0.92424,0.9,0.92424,0.92,0.92424,0.94,0.92424,0.96,0.92424,0.98,0.92424,0.99609,0.92424,0.00391,0.93939,0.02,0.93939,0.04,0.93939,0.06,0.93939,0.08,0.93939,0.1,0.93939,0.12,0.93939,0.14,0.93939,0.16,0.93939,0.18,0.93939,0.2,0.93939,0.22,0.93939,0.24,0.93939,0.26,0.93939,0.28,0.93939,0.3,0.93939,0.32,0.93939,0.34,0.93939,0.36,0.93939,0.38,0.93939,0.4,0.93939,0.42,0.93939,0.44,0.93939,0.46,0.93939,0.48,0.93939,0.5,0.93939,0.52,0.93939,0.54,0.93939,0.56,0.93939,0.58,0.93939,0.6,0.93939,0.62,0.93939,0.64,0.93939,0.66,0.93939,0.68,0.93939,0.7,0.93939,0.72,0.93939,0.74,0.93939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.76,0.93939,0.78,0.93939,0.8,0.93939,0.82,0.93939,0.84,0.93939,0.86,0.93939,0.88,0.93939,0.9,0.93939,0.92,0.93939,0.94,0.93939,0.96,0.93939,0.98,0.93939,0.99609,0.93939,0.00391,0.95455,0.02,0.95455,0.04,0.95455,0.06,0.95455,0.08,0.95455,0.1,0.95455,0.12,0.95455,0.14,0.95455,0.16,0.95455,0.18,0.95455,0.2,0.95455,0.22,0.95455,0.24,0.95455,0.26,0.95455,0.28,0.95455,0.3,0.95455,0.32,0.95455,0.34,0.95455,0.36,0.95455,0.38,0.95455,0.4,0.95455,0.42,0.95455,0.44,0.95455,0.46,0.95455,0.48,0.95455,0.5,0.95455,0.52,0.95455,0.54,0.95455,0.56,0.95455,0.58,0.95455,0.6,0.95455,0.62,0.95455,0.64,0.95455,0.66,0.95455,0.68,0.95455,0.7,0.95455,0.72,0.95455,0.74,0.95455,0.76,0.95455,0.78,0.95455,0.8,0.95455,0.82,0.95455,0.84,0.95455,0.86,0.95455,0.88,0.95455,0.9,0.95455,0.92,0.95455,0.94,0.95455,0.96,0.95455,0.98,0.95455,0.99609,0.95455,0.00391,0.9697,0.02,0.9697,0.04,0.9697,0.06,0.9697,0.08,0.9697,0.1,0.9697,0.12,0.9697,0.14,0.9697,0.16,0.9697,0.18,0.9697,0.2,0.9697,0.22,0.9697,0.24,0.9697,0.26,0.9697,0.28,0.9697,0.3,0.9697,0.32,0.9697,0.34,0.9697,0.36,0.9697,0.38,0.9697,0.4,0.9697,0.42,0.9697,0.44,0.9697,0.46,0.9697,0.48,0.9697,0.5,0.9697,0.52,0.9697,0.54,0.9697,0.56,0.9697,0.58,0.9697,0.6,0.9697,0.62,0.9697,0.64,0.9697,0.66,0.9697,0.68,0.9697,0.7,0.9697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.72,0.9697,0.74,0.9697,0.76,0.9697,0.78,0.9697,0.8,0.9697,0.82,0.9697,0.84,0.9697,0.86,0.9697,0.88,0.9697,0.9,0.9697,0.92,0.9697,0.94,0.9697,0.96,0.9697,0.98,0.9697,0.99609,0.9697,0.00391,0.98485,0.02,0.98485,0.04,0.98485,0.06,0.98485,0.08,0.98485,0.1,0.98485,0.12,0.98485,0.14,0.98485,0.16,0.98485,0.18,0.98485,0.2,0.98485,0.22,0.98485,0.24,0.98485,0.26,0.98485,0.28,0.98485,0.3,0.98485,0.32,0.98485,0.34,0.98485,0.36,0.98485,0.38,0.98485,0.4,0.98485,0.42,0.98485,0.44,0.98485,0.46,0.98485,0.48,0.98485,0.5,0.98485,0.52,0.98485,0.54,0.98485,0.56,0.98485,0.58,0.98485,0.6,0.98485,0.62,0.98485,0.64,0.98485,0.66,0.98485,0.68,0.98485,0.7,0.98485,0.72,0.98485,0.74,0.98485,0.76,0.98485,0.78,0.98485,0.8,0.98485,0.82,0.98485,0.84,0.98485,0.86,0.98485,0.88,0.98485,0.9,0.98485,0.92,0.98485,0.94,0.98485,0.96,0.98485,0.98,0.98485,0.99609,0.98485,0.00391,0.99609,0.02,0.99609,0.04,0.99609,0.06,0.99609,0.08,0.99609,0.1,0.99609,0.12,0.99609,0.14,0.99609,0.16,0.99609,0.18,0.99609,0.2,0.99609,0.22,0.99609,0.24,0.99609,0.26,0.99609,0.28,0.99609,0.3,0.99609,0.32,0.99609,0.34,0.99609,0.36,0.99609,0.38,0.99609,0.4,0.99609,0.42,0.99609,0.44,0.99609,0.46,0.99609,0.48,0.99609,0.5,0.99609,0.52,0.99609,0.54,0.99609,0.56,0.99609,0.58,0.99609,0.6,0.99609,0.62,0.99609,0.64,0.99609,0.66,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.68,0.99609,0.7,0.99609,0.72,0.99609,0.74,0.99609,0.76,0.99609,0.78,0.99609,0.8,0.99609,0.82,0.99609,0.84,0.99609,0.86,0.99609,0.88,0.99609,0.9,0.99609,0.92,0.99609,0.94,0.99609,0.96,0.99609,0.98,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 3417 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 6834 total numbers made up of 3417 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD009 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD009().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD009\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD009 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD009_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD009_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD009_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD009_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
