####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD007.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD007.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD007.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD007.x3d'),
    GeoLOD(center=(4340924.904807,739385.999947,2141.5),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw003.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw003.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,738776.999947,0),geoSystem=["UTM","Z10","N"],height=[2170.7441,2167.8523,2173.1309,2181.1099,2189.7102,2196.4702,2198.4263,2192.852,2179.9243,2166.3691,2148.486,2131.657,2121.6775,2111.9805,2105.6404,2099.3325,2088.1855,2077.0044,2067.2605,2056.2192,2044.005,2029.4033,2018.7502,2011.7701,2004.3702,1997.8,1995.4412,1992.3029,1988.5559,1985.769,1983.3331,1981.663,1978.2814,1974.5345,1972.6246,1971.8394,1970.7131,1969.0,1968.381,1969.0,1969.2869,1969.4629,1970.2869,1971.3348,1972.7709,1974.5509,1976.389,1977.5142,1978.8018,1982.4244,1986.4869,2184.0728,2180.6965,2185.663,2194.5205,2200.8225,2206.037,2205.5137,2196.8215,2182.441,2166.6873,2151.244,2136.173,2128.354,2123.4863,2116.9976,2109.037,2099.1387,2086.858,2074.9446,2063.4165,2049.1614,2035.6697,2026.757,2019.106,2010.2227,2003.018,1998.6047,1995.1965,1991.6998,1988.2031,1986.1393,1984.3234,1980.7747,1976.8591,1975.0153,1973.5793,1972.1427,1970.7073,1969.0184,1968.0,1967.897,1968.0,1968.3875,1968.9087,1970.2772,1971.7806,1973.1671,1973.7214,1974.9812,1978.4779,1981.6682,2197.1582,2194.1472,2200.3435,2207.3875,2213.481,2216.262,2212.912,2199.8054,2185.0496,2169.011,2156.012,2144.9197,2137.7634,2132.9097,2127.05,2118.902,2107.882,2094.8271,2082.8728,2069.3733,2055.5964,2045.6959,2035.7551,2026.7125,2016.874,2010.4097,2005.6304,1999.0183,1995.623,1992.2113,1989.9161,1987.7495,1984.7365,1980.755,1978.4415,1976.0055,1973.5695,1971.8123,1970.0747,1968.8679,1967.6785,1967.0,1966.4344,1965.8961,1966.9185,1967.8342,1969.0703,1969.869,1971.6625,1974.533,1975.869,2214.0005,2206.7544,2212.8171,2221.7793,2226.9507,2226.0066,2218.3276,2201.8826,2188.257,2175.0771,2166.324,2156.6772,2151.4182,2147.0225,2139.3425,2128.5999,2116.3132,2102.7031,2089.0884,2074.4795,2063.8787,2055.1467,2046.3998,2034.6631,2023.9254,2019.5668,2014.7001,2007.7509,2000.4513,1996.0477,1993.6117,1991.1757,1987.4877,1983.6157,1981.8594,1979.4271,1975.9957,1973.5597,1972.1237,1970.9917,1970.2495,1968.8157,1965.7728,1964.9445,1964.0083,1965.0076,1965.3696,1966.0166,1968.2363,1969.6805,1970.9174,2230.9895,2223.1787,2224.8777,2234.5596,2237.6277,2233.133,2220.3398,2205.6,2194.3962,2184.29,2175.4495,2169.5198,2164.4937,2156.781,2147.2197,2136.4758,2122.2952,2107.2664,2093.0957,2081.744,2073.7524,2062.8477,2053.9573,2043.8247,2037.2155,2030.4895,2025.0294,2018.8735,2010.8519,2001.3136,1997.677,1995.9429,1991.7498,1987.5657,1985.3457,1982.8579,1979.8398,1976.2233,1973.5499,1973.1139,1971.6779,1969.242,1966.8059,1964.952,1962.7183,1962.0,1962.582,1962.1211,1963.3922,1964.9686,1965.1642,2247.0803,2238.742,2238.7957,2246.9844,2248.1462,2240.2134,2226.0364,2214.2656,2205.2244,2196.4456,2185.7366,2181.0286,2175.2585,2166.5044,2152.6682,2137.96,2125.464,2109.86,2098.8076,2090.0405,2081.4692,2073.8525,2067.2976,2060.3064,2052.091,2044.2646,2036.3126,2029.2324,2022.2677,2014.3885,2010.1488,2003.7439,1999.9117,1995.1564,1991.2843,1987.4996,1983.8514,1980.2562,1977.8202,1975.7968,1973.8846,1971.6681,1969.232,1966.7961,1964.8441,1963.8441,1962.8441,1962.0,1961.0355,1961.1559,1961.1559,2261.792,2251.1436,2252.2634,2259.124,2259.2195,2248.4717,2233.8328,2225.8228,2218.1995,2205.3345,2194.9229,2188.593,2181.9446,2172.6687,2158.7126,2140.5007,2128.5056,2117.4258,2107.8677,2100.3293,2091.317,2086.8333,2081.187,2072.8196,2065.1233,2056.7515,2048.2717,2039.8127,2031.5573,2025.4636,2021.5916,2015.9036,2009.7794,2004.2032,1998.5294,1993.6909,1988.5497,1984.5231,1981.4023,1978.4741,1974.7903,1972.2228,1970.388,1968.917,1966.6469,1965.3287,1964.7402,1963.208,1961.772,1960.5155,1959.973,2274.714,2264.2747,2266.0508,2271.394,2270.6848,2261.6025,2246.683,2240.8196,2230.6902,2219.4622,2205.5166,2195.8015,2185.8945,2175.8245,2163.15,2146.746,2138.4624,2130.1306,2121.4841,2111.1465,2103.4827,2104.2954,2096.35,2088.0955,2079.6553,2070.3792,2060.635,2050.8628,2041.6158,2037.5386,2034.9873,2030.2994,2022.4996,2015.4186,2008.1106,2000.9725,1995.0975,1988.529,1984.8285,1981.3003,1977.2166,1973.5205,1971.8142,1969.6631,1968.2125,1967.0557,1965.644,1964.1449,1962.0,1961.234,1960.6268,2291.3376,2279.278,2280.031,2285.1497,2284.7656,2275.8562,2263.0825,2256.8232,2245.5508,2228.3435,2215.4082,2201.777,2190.6506,2180.587,2167.948,2158.971,2149.8745,2141.4775,2133.917,2123.2058,2115.3906,2119.0696,2117.0618,2106.382,2095.9548,2085.7363,2074.5564,2063.2625,2055.7986,2054.0378,2051.099,2046.1044,2037.7283,2027.9844,2018.9949,2010.1969,2001.3842,1995.3815,1989.5256,1984.6375,1979.6747,1974.9252,1972.388,1970.9579,1969.5754,1968.1929,1967.079,1965.3307,1963.8948,1962.4587,1961.1105,2301.5703,2296.5576,2296.388,2299.6863,2299.2056,2290.579,2277.1646,2267.1433,2252.5818,2236.057,2220.5002,2208.3079,2198.0676,2190.2917,2179.1758,2168.3025,2161.3677,2153.3477,2143.7517,2134.2756,2125.4385,2130.6565,2130.8525,2123.8015,2114.108,2103.2695,2089.1135,2076.038,2070.7856,2069.3188,2065.4358,2059.2966,2051.326,2040.615,2028.5757,2018.4067,2009.6588,2002.0946,1995.3618,1989.1858,1983.2117,1977.0209,1973.388,1971.9784,1971.2832,1970.549,1969.3535,1967.757,1966.3209,1964.7004,1963.449,2315.291,2309.8325,2309.027,2314.2622,2314.6938,2302.5276,2288.3206,2274.8381,2257.6409,2242.5647,2230.2356,2218.4204,2206.7725,2199.9653,2189.4617,2179.3596,2171.0725,2163.0525,2154.2874,2143.9805,2138.9106,2145.3677,2141.1138,2135.9084,2127.5837,2120.0508,2107.9783,2092.562,2088.293,2085.8025,2080.2905,2072.4028,2061.6404,2049.7896,2038.2805,2026.6714,2018.9125,2009.6294,2001.4501,1994.0382,1986.7487,1979.4471,1974.3632,1972.9751,1972.9751,1972.078,1971.6191,1970.1831,1968.7471,1966.9751,1964.9976,2328.0813,2321.9753,2319.6743,2324.7932,2327.984,2311.2354,2291.9893,2278.8186,2264.9814,2255.9324,2241.116,2227.6611,2218.812,2210.1345,2198.7449,2190.0852,2179.6987,2170.7822,2162.76,2153.7527,2152.8813,2157.2776,2153.0898,2149.1533,2143.4226,2135.408,2124.4626,2111.4102,2105.188,2101.0852,2093.714,2083.8528,2070.2441,2057.764,2046.159,2036.5032,2029.2136,2020.6187,2011.0803,1999.1699,1991.2856,1983.944,1978.98,1976.8026,1976.1116,1974.8506,1974.0453,1972.6094,1971.1733,1969.4014,1967.7626,2333.6543,2328.9646,2327.4827,2330.442,2329.824,2315.4744,2298.675,2288.2659,2277.8499,2268.0564,2255.1226,2242.581,2232.929,2221.3242,2208.7969,2199.9502,2185.8743,2177.1082,2170.8662,2164.5247,2167.0051,2169.965,2169.8113,2165.8652,2158.673,2149.3032,2135.7327,2127.8213,2122.8616,2114.1094,2103.8557,2093.2302,2079.05,2067.579,2056.9167,2048.8977,2039.1537,2030.1501,2019.0106,2007.6062,1995.4799,1989.1306,1985.0431,1982.4346,1979.744,1978.6688,1977.3605,1975.0355,1972.6388,1971.1636,1970.8275,2335.3552,2333.1301,2332.1284,2332.2925,2329.1328,2319.7368,2308.9211,2299.6963,2291.0627,2281.6265,2269.8162,2258.114,2246.3303,2231.239,2217.399,2208.655,2196.2346,2188.8208,2179.935,2176.015,2179.3286,2183.7246,2184.2686,2181.368,2171.8962,2163.4688,2153.5037,2143.5237,2134.983,2126.1829,2114.8015,2104.2117,2092.0742,2080.342,2071.4578,2059.1099,2049.7742,2039.0332,2027.1675,2014.1641,2002.2489,1996.1555,1990.5372,1986.2057,1983.7698,1981.3337,1979.8977,1977.4618,1974.2216,1973.2538,1973.5074,2328.4443,2325.0999,2324.0374,2327.3018,2329.6858,2328.5725,2322.6516,2313.3516,2302.644,2293.976,2284.7598,2272.5996,2259.8894,2244.0156,2231.7395,2217.7373,2207.1677,2201.9756,2192.707,2186.9465,2191.4534,2195.8557,2196.1143,2192.7437,2186.268,2177.2795,2167.5356,2157.1116,2147.205,2136.6619,2127.8796,2118.1357,2107.739,2093.9517,2081.3477,2071.8813,2057.0586,2045.8798,2032.1519,2019.3666,2009.6431,2002.5681,1996.1359,1990.2639,1986.1959,1983.7599,1983.6799,1982.5679,1980.4917,1979.0398,1980.1398,2315.5977,2307.8633,2308.6707,2315.689,2322.7075,2329.6926,2331.2695,2327.2998,2318.4849,2305.8232,2296.4807,2286.1467,2272.9692,2258.7227,2245.8088,2228.7937,2216.6733,2212.0005,2206.7002,2200.2207,2206.5708,2209.9382,2210.3298,2206.3345,2198.1326,2189.7307,2179.8806,2169.0645,2159.3403,2148.7546,2138.9045,2130.1606,2119.1646,2106.3696,2092.6807,2079.459,2064.346,2050.946,2037.0964,2025.1346,2017.2046,2010.7904,2000.8054,1995.0101,1990.2957,1987.4961,1988.3562,1989.3184,1988.1965,1986.831,1988.6201,2304.999,2295.7258,2294.5103,2299.7703,2311.4966,2321.7905,2331.171,2336.541,2331.021,2321.074,2308.7131,2298.2776,2287.4697,2272.9333,2259.959,2243.314,2232.366,2224.9233,2218.2178,2214.467,2220.2246,2221.419,2219.122,2211.906,2204.3506,2196.9324,2187.5208,2177.309,2167.565,2158.7913,2148.077,2138.431,2126.9387,2115.157,2100.853,2085.4065,2070.0886,2054.3723,2042.2485,2033.5428,2024.983,2016.0044,2006.6788,1997.4619,1996.0647,1996.5544,1997.1294,1997.1294,1997.7184,1998.1294,1999.1294,2295.0107,2283.2415,2279.4622,2284.7222,2295.4688,2309.6104,2322.868,2328.5715,2330.9124,2332.409,2323.1172,2309.3167,2297.1963,2284.9941,2271.4102,2254.954,2245.006,2236.0156,2228.532,2224.2744,2231.8987,2225.3848,2216.4485,2209.0989,2201.0684,2193.4912,2186.1636,2178.7534,2169.989,2161.224,2152.48,2143.7021,2131.6675,2119.8176,2106.173,2088.9004,2072.9824,2057.2305,2047.4451,2039.0465,2029.217,2017.1273,2007.5681,2001.8756,2002.8542,2003.8756,2003.9171,2004.8756,2005.8756,2006.8617,2007.9342,2289.0942,2275.8145,2265.7795,2268.2817,2280.5876,2295.7717,2308.182,2316.2817,2323.7434,2331.3167,2325.106,2312.52,2299.6033,2286.795,2274.3467,2261.0583,2248.896,2240.152,2231.59,2223.838,2218.021,2210.3235,2203.4004,2197.0923,2190.6392,2183.861,2177.413,2170.245,2164.1326,2156.2874,2146.555,2139.0837,2130.2224,2120.5986,2106.919,2092.2954,2077.7935,2063.1775,2051.0447,2040.3993,2028.1753,2013.4182,2008.0,2010.2207,2012.539,2011.265,2010.4282,2013.3252,2016.4487,2017.1792,2019.0237,2282.5723,2270.9622,2256.9116,2254.2021,2264.2341,2281.625,2290.9873,2299.5422,2310.9023,2324.1272,2321.0781,2308.8982,2296.186,2282.564,2269.4707,2256.4968,2245.2742,2235.9526,2226.7483,2213.868,2204.6963,2197.947,2191.9927,2185.8342,2179.6086,2172.6965,2166.9685,2160.5403,2151.3875,2142.1345,2135.688,2130.159,2122.859,2114.8743,2104.7346,2093.2,2081.02,2066.219,2051.0881,2038.6691,2023.7273,2010.2319,2014.6593,2023.7246,2023.9891,2021.2438,2024.289,2028.0358,2030.2396,2031.4042,2033.0657,2272.5664,2262.8704,2248.0193,2240.886,2249.7532,2260.5122,2270.9841,2283.9263,2297.5422,2310.6572,2313.651,2304.0684,2293.6348,2279.2163,2265.384,2252.8772,2242.6462,2233.9143,2224.5674,2213.7915,2202.1372,2191.524,2182.1948,2176.4639,2170.1218,2162.641,2154.8418,2145.5264,2137.1736,2130.9395,2124.7644,2118.5598,2113.6072,2107.9126,2100.059,2089.6213,2077.5457,2065.4683,2047.7137,2032.0782,2018.7705,2023.6943,2030.6469,2039.9224,2038.8658,2033.1086,2034.9822,2040.0068,2042.4137,2044.77,2049.0486,2260.685,2250.7393,2237.1426,2228.618,2235.1667,2244.6033,2256.2068,2270.8984,2285.4827,2297.8406,2303.5588,2300.0486,2291.5615,2281.4656,2268.97,2258.0728,2249.162,2241.6143,2230.398,2219.9907,2204.5632,2192.8394,2183.0955,2174.4617,2166.472,2160.2,2149.606,2139.6636,2130.984,2122.5605,2115.029,2108.2559,2104.925,2100.634,2094.4316,2082.1067,2072.026,2059.4224,2039.9144,2023.1942,2023.9609,2036.3135,2045.4102,2051.3105,2047.5381,2043.6803,2048.812,2052.4453,2053.8047,2056.8677,2059.687,2252.3687,2239.7168,2227.446,2217.9443,2222.5508,2230.9587,2247.2012,2258.5503,2270.7341,2285.224,2291.9314,2293.7314,2290.894,2285.1536,2276.1953,2264.8335,2255.351,2246.9792,2235.4258,2223.1172,2206.9,2195.176,2184.5215,2177.2244,2172.5046,2166.2866,2155.7246,2146.9807,2137.1926,2127.4927,2116.3132,2107.4905,2099.992,2092.3496,2082.9434,2072.3015,2059.665,2047.042,2036.0487,2038.1453,2041.951,2052.4016,2060.9702,2060.2578,2055.344,2056.2878,2061.714,2063.2397,2065.7654,2067.3882,2066.1597,2240.4316,2225.0977,2213.8735,2204.6233,2208.5305,2219.553,2231.0012,2244.3628,2257.3613,2270.8015,2279.4011,2285.129,2288.243,2286.5632,2281.5122,2270.5073,2260.0613,2249.9558,2237.964,2223.496,2206.9304,2198.222,2191.387,2184.7537,2179.905,2172.4314,2164.0032,2154.1501,2142.5076,2134.1995,2121.3154,2111.0679,2100.3777,2087.517,2072.8967,2063.186,2055.0415,2047.356,2046.9584,2054.397,2058.2244,2067.2234,2072.7065,2070.4827,2064.8604,2066.39,2070.9587,2076.1628,2079.4402,2078.0815,2071.68,2228.1067,2211.181,2196.8145,2191.255,2195.3809,2204.688,2222.5022,2234.9717,2245.43,2254.2573,2266.2515,2275.663,2283.1802,2287.9377,2283.7534,2275.693,2262.578,2249.7693,2237.1614,2223.496,2212.7646,2206.8557,2201.0854,2194.784,2186.7698,2177.849,2167.398,2157.7078,2145.4314,2135.224,2122.1,2111.5627,2100.0354,2086.872,2075.4617,2070.5898,2066.6558,2064.6848,2064.5938,2070.9153,2074.0889,2082.1797,2086.7097,2082.5657,2075.286,2077.4165,2083.3638,2087.3518,2089.781,2084.9114,2077.52,2215.6155,2198.3823,2184.4016,2180.8716,2185.6873,2197.4075,2212.0234,2224.3286,2233.445,2242.9136,2251.382,2263.6392,2276.211,2285.536,2283.192,2275.8,2261.9663,2245.4658,2234.6826,2228.1514,2223.7935,2218.1047,2209.4683,2200.9998,2192.5935,2180.4946,2169.456,2158.64,2146.0918,2132.5642,2118.5037,2108.3,2097.902,2093.235,2091.6384,2088.0889,2082.952,2081.2495,2081.4937,2085.489,2090.4165,2095.48,2099.4727,2095.6968,2089.7249,2091.342,2094.9597,2098.6328,2100.7568,2096.9695,2088.909,2198.9219,2185.8179,2177.1025,2175.4114,2178.4993,2189.9768,2202.4692,2212.8787,2221.1802,2229.7463,2239.8738,2252.3984,2266.124,2281.239,2282.3977,2275.0056,2261.643,2248.6536,2242.147,2238.9238,2234.3389,2226.9912,2216.1064,2205.222,2194.8955,2181.641,2166.8672,2155.9792,2141.8552,2126.953,2113.702,2106.222,2104.1775,2107.0007,2107.3125,2103.5557,2100.3596,2102.0398,2099.382,2101.276,2103.5596,2108.3237,2110.1775,2106.0334,2101.8723,2103.8752,2107.6106,2111.3928,2111.9248,2109.2405,2103.3867,2183.4976,2174.9097,2168.8118,2167.5916,2169.2498,2180.9978,2194.6978,2201.9531,2209.2612,2217.4475,2227.1238,2241.7148,2257.1655,2272.901,2280.1125,2274.6047,2263.7727,2254.7463,2249.9646,2245.1956,2237.6995,2227.6218,2213.6816,2202.0264,2192.93,2176.9382,2163.015,2148.7175,2134.7349,2125.861,2120.3428,2112.8347,2114.9143,2121.6995,2120.882,2117.7634,2118.3193,2118.8914,2116.676,2115.5603,2117.6401,2121.24,2120.9678,2116.0173,2114.0278,2118.181,2122.5374,2124.9407,2124.7046,2122.2183,2115.7808,2170.3853,2164.0342,2158.241,2157.4128,2158.6614,2173.4456,2184.8076,2190.9927,2195.7576,2206.7568,2220.3596,2233.085,2250.481,2264.8677,2274.129,2274.2166,2268.644,2260.2366,2250.6133,2240.5767,2231.9539,2217.5173,2204.953,2193.2168,2183.593,2168.3423,2156.869,2142.8772,2138.0488,2136.5833,2132.3396,2124.4326,2129.6243,2136.6099,2135.713,2133.5273,2132.8833,2132.601,2131.319,2131.0771,2132.5288,2133.8806,2133.0176,2129.7847,2129.3645,2132.7207,2136.2366,2138.3928,2137.38,2133.123,2126.287,2157.3735,2153.2168,2147.708,2147.3892,2153.9893,2167.141,2176.5352,2181.412,2188.1296,2198.3328,2213.353,2226.261,2241.398,2256.4456,2268.488,2273.5342,2269.375,2259.922,2246.1033,2233.4329,2220.6812,2208.501,2196.321,2184.445,2172.18,2160.1167,2155.6558,2152.443,2153.4736,2151.5498,2145.3918,2136.7195,2142.6248,2150.864,2151.4597,2150.47,2150.4377,2148.0789,2146.633,2145.8877,2148.1428,2147.352,2144.1855,2142.4858,2144.9949,2147.3638,2151.15,2155.964,2154.9255,2148.021,2135.7117,2145.6926,2142.3994,2138.418,2141.022,2149.1558,2159.1628,2167.837,2170.0593,2179.6545,2190.6226,2204.3032,2217.984,2230.1963,2244.8274,2257.629,2269.5217,2263.8994,2254.4446,2239.6145,2225.9985,2213.4026,2201.4941,2190.4336,2179.3525,2170.705,2168.0964,2166.5425,2165.6038,2167.995,2165.107,2156.596,2145.8638,2155.8816,2166.747,2169.995,2168.434,2165.4983,2163.2795,2162.4944,2163.3425,2161.7559,2158.9084,2157.4949,2160.0413,2161.7366,2161.995,2165.2068,2168.2878,2166.926,2157.3457,2144.3467,2133.0613,2131.5625,2130.1492,2134.0479,2143.3252,2152.1082,2157.202,2162.0322,2173.3013,2183.1367,2194.5984,2207.7856,2221.4158,2237.9358,2252.5432,2262.744,2254.844,2242.0796,2231.6318,2219.2603,2206.1624,2197.72,2191.0002,2184.3735,2181.0989,2178.627,2176.4294,2176.6323,2177.7014,2174.884,2166.153,2160.5522,2172.2153,2179.9795,2183.6177,2181.9922,2179.6306,2178.078,2177.5425,2176.3455,2173.147,2168.5254,2169.5664,2174.8206,2176.5522,2176.4836,2177.387,2179.627,2176.96,2165.7427,2152.0762,2121.5938,2121.2092,2122.8127,2130.1208,2140.22,2148.6084,2153.1584,2156.3525,2167.3962,2176.114,2185.5852,2198.065,2215.8337,2232.0728,2250.409,2258.353,2250.8135,2234.0537,2224.609,2216.0103,2209.731,2206.1416,2202.2876,2195.879,2193.7954,2191.6282,2186.2014,2186.4783,2188.439,2186.8533,2176.5051,2174.1577,2182.3147,2192.0242,2198.893,2198.5496,2195.762,2193.6775,2192.2415,2190.8054,2187.538,2183.4058,2181.585,2186.1885,2189.4233,2189.7578,2190.47,2193.92,2187.9148,2172.4067,2159.6516,2116.425,2113.7253,2119.0942,2127.6543,2139.22,2147.5867,2149.4258,2153.6523,2159.5964,2169.3386,2178.3066,2191.36,2208.8586,2224.4426,2241.4924,2252.48,2248.333,2235.6355,2228.1196,2224.305,2221.0867,2217.9768,2212.6094,2205.6772,2202.5693,2201.7112,2195.92,2197.033,2200.397,2199.167,2191.0645,2188.848,2192.371,2204.176,2214.5684,2213.76,2211.004,2209.0125,2206.7986,2204.3625,2200.409,2195.4,2193.4214,2198.1592,2200.9714,2202.6045,2203.7458,2201.7031,2193.2383,2178.391,2160.4,2110.408,2106.592,2111.385,2124.632,2137.042,2146.1782,2144.575,2148.944,2154.1248,2161.3298,2172.892,2184.8682,2199.6465,2214.9922,2230.404,2242.34,2246.6326,2243.696,2240.698,2237.5208,2232.7717,2226.244,2219.14,2214.421,2211.816,2210.012,2204.612,2208.4253,2212.732,2212.2798,2205.88,2202.408,2204.1804,2216.0076,2227.472,2229.6638,2227.432,2225.792,2223.356,2220.0618,2215.004,2207.836,2205.02,2207.864,2210.2998,2211.5483,2209.7754,2204.628,2191.5854,2175.944,2160.2163,2104.6248,2100.6458,2105.4277,2117.3743,2130.683,2137.4792,2135.2717,2142.1655,2149.734,2156.8376,2168.0396,2179.1235,2189.2375,2202.9949,2217.798,2231.049,2244.1978,2249.1853,2248.1123,2245.8303,2240.863,2235.6143,2228.7368,2223.1133,2221.2847,2218.4165,2215.2913,2220.997,2226.289,2225.207,2218.4011,2218.4114,2220.6633,2226.354,2242.153,2245.927,2246.2993,2243.7573,2240.6265,2236.173,2230.2874,2221.8374,2216.5208,2217.5688,2219.3745,2217.3909,2209.932,2201.2788,2188.546,2173.3857,2160.8235,2098.2634,2094.8872,2100.347,2108.2285,2117.992,2125.198,2125.6904,2134.0557,2147.0957,2154.5593,2163.5273,2173.2148,2182.4568,2191.7046,2206.2212,2221.7673,2240.2827,2249.0796,2252.0564,2252.1128,2249.2043,2245.6875,2238.697,2231.5881,2230.9465,2229.9692,2227.882,2232.4375,2236.7336,2236.391,2234.0012,2236.0935,2238.3384,2240.381,2254.81,2261.923,2264.3342,2262.9062,2259.5535,2253.083,2244.775,2237.578,2230.0234,2227.223,2225.685,2219.3008,2208.22,2198.04,2186.714,2176.4568,2167.7185,2095.5815,2090.2988,2093.0684,2100.0828,2106.2017,2112.0671,2116.777,2130.8342,2142.9749,2150.1973,2158.015,2166.404,2175.4236,2185.4243,2199.6538,2216.3975,2235.691,2246.6533,2253.3674,2256.7644,2255.945,2252.0532,2245.7158,2242.6023,2239.2886,2237.2478,2236.7546,2240.629,2245.4639,2249.3298,2252.1033,2253.8606,2252.8955,2255.2715,2265.9822,2277.2278,2278.8955,2276.7573,2271.8088,2263.3784,2254.845,2247.3174,2240.2239,2235.3997,2231.997,2221.484,2210.185,2199.9048,2190.7637,2182.618,2174.0996,2092.2466,2086.6191,2083.7087,2090.189,2096.4128,2100.3723,2108.014,2122.4768,2135.233,2144.9253,2150.6538,2158.5703,2166.9182,2178.9934,2196.9192,2212.9858,2231.1145,2244.8743,2253.444,2259.077,2259.7976,2256.453,2252.9521,2249.1003,2245.0752,2242.6177,2241.8176,2246.027,2251.8335,2258.5583,2267.6838,2273.2854,2269.6284,2269.8289,2278.2778,2287.7551,2291.4456,2289.6282,2283.0312,2273.0518,2262.7664,2255.1985,2247.2988,2240.7217,2234.9407,2228.061,2216.361,2207.278,2200.1584,2193.552,2181.3264,2091.4402,2082.2815,2079.7793,2081.938,2085.704,2092.221,2102.0498,2112.42,2123.812,2130.624,2136.744,2150.0762,2161.3652,2175.8293,2193.897,2210.705,2226.262,2240.8901,2250.922,2258.168,2261.9868,2259.423,2256.4429,2253.014,2249.827,2246.67,2247.306,2250.814,2257.029,2266.446,2277.57,2287.792,2287.5903,2285.368,2289.7114,2294.9375,2296.67,2295.3262,2288.528,2278.352,2267.71,2258.807,2250.757,2242.904,2237.2048,2232.1067,2223.937,2217.8943,2210.5796,2201.3489,2189.4714,2093.2014,2082.5532,2077.108,2077.0857,2079.5886,2086.2734,2096.2256,2104.8564,2112.7195,2119.642,2127.0977,2139.82,2156.6067,2174.7837,2191.3743,2208.4006,2220.5825,2235.2078,2247.0696,2256.09,2260.2388,2259.7827,2258.7869,2255.5938,2252.236,2249.5613,2250.549,2253.089,2259.032,2267.776,2278.9,2292.5027,2297.2705,2296.0461,2297.4075,2299.216,2300.003,2295.136,2288.528,2278.9502,2269.78,2260.296,2250.6982,2242.1428,2238.032,2233.9211,2230.9963,2225.6995,2219.3716,2207.2024,2195.0225,2095.7566,2084.293,2074.6392,2072.4207,2075.5615,2084.0576,2090.4573,2096.1418,2101.4668,2108.9326,2122.3,2132.768,2153.256,2173.5886,2190.0447,2207.04,2217.3284,2230.3186,2241.1895,2249.6643,2255.2542,2255.5232,2256.35,2253.7817,2249.6738,2247.4253,2245.506,2248.5952,2255.1492,2264.2139,2275.5305,2286.702,2295.0254,2302.3176,2302.6653,2299.9602,2297.6284,2293.6802,2284.9658,2276.222,2267.6165,2258.954,2248.25,2238.285,2232.4377,2232.6252,2232.8125,2230.416,2221.6887,2211.8674,2198.706,2099.054,2086.9336,2075.312,2069.254,2069.817,2077.0637,2085.5532,2089.7273,2094.8323,2106.1677,2121.555,2132.768,2151.9297,2171.7244,2188.0225,2205.942,2215.4905,2226.5095,2235.126,2241.9111,2247.167,2248.6152,2248.267,2244.4287,2241.7815,2240.223,2237.6863,2240.7617,2247.8794,2256.3215,2264.2188,2276.7861,2289.7083,2297.113,2297.0352,2294.213,2289.9385,2282.9768,2274.233,2266.593,2259.3257,2253.052,2240.4856,2230.0447,2225.6753,2226.11,2226.5457,2225.7537,2221.8423,2213.016,2200.5613,2100.4402,2087.584,2076.312,2068.7598,2066.0083,2071.3604,2077.7126,2083.5986,2091.041,2102.5193,2119.5667,2132.7642,2151.152,2168.704,2185.2,2202.8337,2214.0532,2222.3445,2229.3584,2235.0884,2239.9006,2241.8806,2241.9844,2235.8965,2229.1565,2228.6487,2228.5166,2232.0938,2237.3245,2242.6094,2249.2112,2259.834,2273.6575,2285.152,2288.8408,2286.183,2275.7378,2266.4082,2259.9854,2254.8093,2246.7908,2239.8882,2230.353,2221.6987,2216.8806,2216.8408,2217.8408,2217.8093,2215.3938,2209.915,2200.5642,2100.295,2087.32,2076.312,2067.102,2061.537,2065.2844,2070.434,2075.658,2084.3333,2098.9976,2115.5063,2131.1614,2148.726,2165.812,2181.492,2198.0225,2210.896,2217.8723,2223.046,2229.354,2233.622,2235.068,2234.6523,2229.618,2222.184,2219.602,2220.772,2223.1743,2224.4407,2226.148,2233.19,2244.2715,2257.5813,2271.332,2279.546,2275.823,2262.164,2250.4373,2243.6,2238.8997,2232.8452,2225.758,2218.3,2213.506,2208.634,2207.136,2207.136,2207.136,2205.908,2202.9873,2197.3486,2098.2698,2086.3994,2076.312,2065.6758,2058.0686,2059.6396,2063.1553,2070.2017,2081.0706,2095.5596,2110.8357,2127.7915,2145.8318,2160.9917,2177.1714,2192.3462,2205.1514,2210.7473,2214.7273,2220.183,2225.4712,2228.8381,2228.4314,2224.2317,2216.9236,2211.145,2209.6074,2211.539,2211.1404,2211.6985,2220.8857,2232.7832,2244.799,2257.161,2263.6467,2261.027,2250.4485,2238.811,2230.911,2224.8425,2218.1948,2213.011,2207.515,2205.378,2201.3555,2196.7617,2194.9644,2196.4312,2195.2031,2192.767,2190.2234,2095.2212,2084.2358,2074.4292,2064.2495,2056.5796,2054.0176,2057.4868,2067.0896,2079.1587,2092.4832,2106.3232,2122.9392,2138.6199,2155.8208,2171.4688,2184.4048,2192.5544,2199.832,2204.603,2208.576,2214.1296,2218.6907,2220.0105,2216.9658,2210.4343,2203.6448,2200.2063,2197.0667,2196.0896,2196.733,2206.826,2221.496,2231.5876,2241.616,2245.2583,2244.6895,2237.424,2225.1104,2215.2092,2210.5784,2206.928,2201.936,2195.3076,2192.7864,2193.408,2190.1792,2185.5754,2183.7263,2184.2524,2183.7263,2182.2632,2093.0076,2082.508,2072.5674,2062.6682,2054.1233,2048.0308,2052.4302,2064.0154,2076.1846,2089.5735,2101.4707,2117.0867,2131.3066,2147.5503,2162.5488,2175.3816,2183.5735,2188.701,2194.3176,2198.1895,2201.0466,2203.9883,2206.4243,2204.6208,2200.6887,2196.5662,2192.183,2184.0425,2180.4067,2181.221,2193.177,2204.9578,2214.0544,2220.4421,2224.4226,2229.5986,2227.0376,2212.5398,2201.5496,2196.973,2194.5369,2190.0044,2181.0842,2176.5803,2179.8928,2181.0215,2178.9631,2174.2295,2174.4468,2176.4302,2177.5107,2091.5815,2080.8853,2070.9692,2059.8262,2051.49,2045.3492,2046.6469,2060.4785,2072.6345,2086.725,2097.0164,2112.3303,2126.4893,2140.4343,2154.9182,2167.0183,2174.4863,2179.5413,2185.396,2189.972,2190.3167,2190.3167,2191.146,2191.5322,2189.3416,2185.946,2181.9827,2175.2715,2169.3008,2170.0898,2180.56,2189.4546,2192.607,2197.0627,2206.1506,2216.1465,2216.4707,2205.5308,2191.851,2184.79,2181.495,2176.4773,2168.4807,2164.3564,2165.63,2171.1294,2172.3025,2166.1116,2165.4312,2170.0369,2171.7583,2088.8433,2078.459,2068.543,2057.216,2048.271,2042.0394,2043.1848,2055.918,2069.343,2082.926,2094.043,2107.478,2123.2515,2135.633,2153.4722,2163.8584,2171.9392,2180.733,2184.8828,2182.4573,2181.197,2179.9368,2178.4824,2175.297,2174.68,2174.015,2172.1934,2165.77,2157.6956,2155.7983,2164.1238,2174.866,2179.2668,2181.8545,2188.243,2193.784,2194.6292,2190.525,2180.8433,2172.238,2166.938,2162.9949,2156.791,2153.418,2153.499,2158.7427,2163.2275,2159.9866,2154.9897,2159.343,2162.5178,2085.729,2076.0327,2065.0935,2054.5447,2044.7998,2036.5015,2038.5983,2051.0657,2064.9167,2079.2795,2091.2769,2103.4568,2119.6775,2131.7935,2150.1763,2161.4968,2170.3503,2182.0962,2180.6575,2176.776,2173.933,2170.9507,2164.2644,2156.8762,2157.607,2158.0562,2157.5422,2150.5981,2142.8096,2139.8362,2143.6296,2157.5264,2167.3706,2171.572,2170.982,2175.4104,2177.8567,2177.462,2174.0623,2166.0833,2152.9531,2145.88,2143.6277,2139.8596,2140.3447,2144.7434,2154.975,2157.1152,2144.7383,2145.2122,2148.9631,2082.3027,2072.6067,2061.3184,2050.8452,2040.8811,2032.5906,2034.2986,2046.6626,2061.0413,2074.0178,2088.0378,2100.0305,2113.5862,2127.474,2144.4797,2157.4773,2165.7559,2173.4678,2173.5703,2170.8052,2165.2524,2157.3784,2150.0173,2143.8743,2142.4097,2142.2046,2139.4185,2133.1199,2127.2876,2125.7278,2130.513,2139.0168,2152.9377,2158.9219,2155.4492,2156.6353,2162.3948,2164.854,2163.508,2155.233,2143.5024,2132.8503,2129.1409,2128.1543,2128.4543,2134.3318,2146.0742,2149.0076,2142.5361,2133.3237,2134.953,2078.9155,2069.536,2057.5393,2046.2087,2035.1167,2027.8334,2031.7988,2043.317,2057.1624,2069.5928,2084.251,2095.7288,2107.9749,2122.0566,2135.3254,2149.102,2155.45,2160.6355,2161.847,2158.5056,2152.5793,2146.653,2141.589,2135.3892,2128.3662,2124.8457,2123.429,2117.6636,2110.5483,2112.6902,2117.1262,2120.7056,2134.2236,2144.4514,2145.0947,2138.0962,2141.1074,2144.5515,2144.3833,2138.2075,2131.2065,2123.9475,2118.789,2118.4915,2119.7327,2128.7788,2138.4412,2142.191,2137.4329,2126.7998,2123.8218,2075.9802,2065.7583,2052.5364,2040.9644,2028.5859,2021.3964,2027.0017,2040.704,2053.4004,2064.7402,2080.0164,2091.7803,2102.383,2113.9346,2125.4087,2136.7393,2143.741,2146.203,2147.0857,2145.2087,2142.0544,2138.0183,2134.2778,2128.4124,2119.044,2107.6719,2106.443,2102.275,2096.983,2099.703,2103.6055,2107.2407,2118.3992,2128.9512,2132.491,2128.98,2124.1902,2125.621,2126.189,2123.6729,2119.8293,2115.4407,2112.3655,2111.128,2114.2085,2122.7188,2132.256,2134.0945,2129.9495,2119.7744,2113.5608,2072.381,2059.0076,2046.684,2034.7759,2021.3799,2015.8159,2022.208,2036.5602,2049.2695,2059.664,2073.776,2085.2,2094.9438,2104.96,2114.8137,2123.1519,2129.1838,2134.0718,2135.3599,2135.088,2133.0679,2130.3599,2127.76,2122.56,2110.504,2096.4878,2091.1687,2086.0647,2082.868,2087.2478,2091.012,2096.536,2104.1843,2111.155,2118.8462,2118.9678,2112.3708,2110.7493,2111.6318,2110.549,2108.6199,2106.864,2104.816,2104.557,2107.6436,2115.7678,2123.2688,2125.088,2121.1318,2111.6765,2104.816,2063.0293,2052.9707,2041.5054,2027.983,2014.3241,2009.2517,2017.3425,2031.1012,2045.298,2054.7417,2066.5498,2077.8252,2084.979,2092.1328,2100.6284,2108.4404,2114.584,2117.7866,2120.0747,2121.0747,2122.252,2124.0771,2123.7996,2116.8972,2102.9534,2088.3682,2078.475,2073.1567,2070.383,2074.117,2077.9888,2084.6484,2092.1,2098.447,2103.4768,2106.7024,2102.2402,2096.383,2097.2288,2098.2288,2098.2288,2097.356,2096.383,2096.5374,2099.553,2107.2974,2113.8933,2115.383,2111.7341,2103.8813,2095.5916,2052.2556,2045.8875,2033.9791,2021.4463,2008.1012,2002.9401,2011.4543,2025.9512,2039.5671,2050.735,2059.5156,2068.3857,2074.4336,2080.002,2086.0754,2091.457,2098.0688,2102.528,2105.6655,2107.1013,2110.138,2116.0098,2116.2058,2108.0383,2094.0942,2080.6782,2070.0837,2061.4739,2059.9797,2063.6223,2066.2178,2071.5754,2080.5872,2085.8933,2089.7454,2092.6816,2089.5254,2085.6782,2086.0425,2086.4019,2087.098,2086.098,2085.841,2087.8022,2094.291,2101.0652,2106.3445,2107.2588,2105.383,2097.7637,2089.4783,2038.2676,2036.762,2027.1201,2014.3322,2000.8108,1996.4667,2006.4767,2020.0988,2032.9268,2044.8761,2052.3,2058.1655,2063.0374,2067.9094,2071.7788,2076.6467,2080.5188,2083.6855,2090.1091,2093.5508,2097.0266,2104.3215,2106.0674,2096.3223,2084.1467,2072.3801,2064.0786,2055.6921,2049.9734,2049.9734,2056.116,2063.428,2068.2322,2071.666,2078.0984,2080.984,2080.9802,2078.548,2077.9734,2077.9734,2076.98,2076.9734,2077.5896,2083.1306,2089.4421,2095.7473,2100.3403,2100.9868,2100.7603,2095.997,2083.7927,2023.538,2024.4183,2018.5807,2007.6615,1995.4624,1988.6615,2000.2339,2014.2463,2027.2864,2037.3735,2043.5886,2047.4607,2051.9,2056.7717,2061.4148,2065.5159,2069.2312,2073.3845,2077.5005,2082.004,2085.8557,2088.6616,2089.5374,2081.986,2071.6772,2064.7551,2057.7935,2049.4136,2040.0328,2040.7239,2047.057,2055.7166,2059.5208,2062.6448,2071.0032,2075.1272,2075.5693,2072.2703,2069.7585,2069.7014,2068.9614,2069.1343,2071.3584,2078.299,2085.8096,2090.9744,2094.6921,2095.7014,2096.0356,2090.236,2079.8342,2012.8757,2014.196,2010.9069,2001.9052,1986.4194,1982.3152,1993.778,2007.5349,2021.3629,2029.9025,2034.2239,2037.7559,2041.0958,2044.6683,2048.597,2053.526,2058.2568,2062.9878,2066.0007,2069.2888,2070.8657,2072.8457,2071.0947,2067.908,2062.069,2056.1638,2050.2021,2043.0629,2031.8989,2031.4519,2039.5629,2046.8969,2050.6748,2053.94,2062.9363,2070.4639,2072.282,2066.2678,2062.4414,2062.4229,2061.6829,2060.775,2067.5574,2075.285,2081.25,2086.1907,2088.638,2089.4229,2087.999,2083.431,2075.8818,2002.171,2004.5951,2003.8003,1995.9309,1979.8928,1973.2526,1987.5323,2001.2562,2014.1448,2021.5923,2025.8043,2028.9551,2031.391,2034.827,2038.093,2041.4138,2044.8499,2048.0005,2052.1514,2054.8726,2056.5881,2058.2886,2057.651,2056.0542,2053.095,2048.6013,2043.1575,2037.4268,2025.5264,2021.7631,2031.5422,2037.7238,2041.1111,2044.9231,2054.3904,2062.39,2064.1414,2059.4424,2055.0288,2054.9458,2055.1443,2056.4207,2063.703,2072.5256,2076.2595,2080.699,2083.6753,2083.293,2080.9163,2076.8162,2069.8442,1991.5562,1995.1027,1995.9326,1987.8257,1974.094,1966.9757,1980.2534,1995.4387,2007.245,2013.3137,2016.8142,2019.2502,2022.3533,2024.4108,2026.8468,2029.2828,2031.9277,2035.0717,2040.3022,2042.0267,2043.457,2044.4427,2044.4427,2044.1542,2043.2223,2040.8965,2037.9412,2032.8455,2019.9482,2010.2102,2019.5217,2027.0748,2030.874,2035.9297,2045.6503,2053.1228,2057.1484,2052.7336,2046.1296,2046.4583,2046.9407,2049.3936,2057.3137,2064.2502,2068.2712,2071.0742,2072.9685,2074.1543,2073.6377,2068.6423,2060.2139,1982.4923,1984.1854,1986.4495,1982.5768,1969.5604,1960.414,1972.5789,1988.2095,1997.705,2002.5667,2006.6318,2009.5454,2011.9814,2014.4175,2016.8534,2018.3114,2019.4501,2024.5854,2028.8423,2031.3118,2032.3146,2032.8427,2033.3118,2033.3118,2032.4495,2032.2494,2029.951,2025.3612,2012.101,2001.5614,2007.1764,2014.8975,2022.5154,2029.694,2035.942,2041.5695,2046.1666,2044.0752,2035.9648,2035.587,2038.8429,2043.0767,2048.3923,2053.5454,2058.4175,2061.3694,2062.3608,2062.3118,2060.0837,2056.7854,2052.163,1973.9205,1975.1595,1976.6696,1976.0433,1968.197,1959.2494,1963.0198,1976.9408,1988.0897,1993.5325,1996.2563,1999.8406,2002.2766,2004.7126,2006.9208,2008.6544,2008.5845,2012.7672,2016.201,2018.6371,2019.6256,2020.617,2021.556,2021.617,2021.617,2021.1808,2020.617,2016.4567,2005.8334,1994.508,1997.3693,2008.0326,2016.9224,2022.2567,2026.3746,2030.7407,2034.1768,2033.5603,2029.0087,2028.22,2033.5284,2038.0483,2040.9204,2044.8406,2049.2764,2052.2285,2052.7446,2050.9526,2048.5166,2046.5167,2043.601,1963.3586,1965.7758,1969.0299,1970.0199,1965.8776,1956.6047,1953.7969,1964.8063,1976.2075,1985.2638,1988.3533,1990.1357,1992.5718,1995.0078,1997.0398,1997.2081,1998.8651,2002.7518,2004.1877,2005.6238,2007.0398,2008.0299,2008.0398,2008.0498,2008.0498,2008.0498,2008.0498,2005.905,1999.0029,1987.356,1989.3098,2000.6681,2006.5513,2010.4258,2014.2977,2018.6154,2022.0359,2023.0398,2020.2938,2020.631,2025.7747,2030.2076,2033.0359,2036.1357,2040.5187,2043.9598,2044.6774,2043.2378,2039.5762,2035.3759,2034.9298,1952.829,1956.961,1961.5786,1964.0043,1964.5398,1956.4236,1948.6187,1956.2415,1967.9032,1975.8762,1979.4113,1981.431,1983.0618,1984.335,1985.1669,1984.8715,1988.887,1992.2151,1994.0668,1995.6759,1996.9304,1998.1849,1998.8738,1998.7822,1997.9187,1996.9187,1996.1312,1994.8888,1991.2339,1979.5155,1982.3932,1991.8596,1995.839,1999.8931,2003.5314,2006.895,2010.3293,2012.335,2008.676,2012.953,2017.9232,2021.5842,2024.947,2027.8273,2031.819,2034.6847,2036.8994,2037.1675,2033.7115,2030.5035,2028.7512,1944.7845,1947.3246,1951.6718,1955.8462,1959.6233,1955.1619,1946.3964,1948.7786,1960.446,1967.0781,1970.2902,1972.6301,1973.6301,1974.6301,1973.8859,1973.4702,1978.9061,1980.4998,1982.7877,1983.3717,1983.7877,1983.9453,1984.7877,1984.9453,1984.9453,1984.5878,1983.6875,1982.5696,1979.8518,1967.4316,1973.4703,1982.0781,1985.8822,1989.4265,1992.9117,1995.3478,1997.7837,2000.1516,1997.6207,2003.5422,2009.1102,2012.8062,2015.2422,2018.6782,2021.6794,2024.5502,2027.6863,2028.6301,2027.2446,2024.987,2022.3308],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD007.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD007.py load and self-test diagnostics complete.")
