####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD005.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD005.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD005.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD005.x3d'),
    GeoLOD(center=(4344125.917539,738180.782603,2311.000000),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw002.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw002.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4343332.077840,737558.999947,0),geoSystem=["UTM","Z10","N"],height=[2124.5784,2123.215,2121.106,2116.439,2112.6243,2108.5667,2104.1724,2099.3865,2094.3298,2089.9905,2084.679,2082.1667,2080.6238,2078.2168,2074.3818,2070.5576,2067.0334,2064.6213,2063.3127,2061.1833,2061.4397,2065.9944,2069.106,2072.7156,2075.5,2073.8499,2080.8599,2085.4722,2095.4814,2107.6206,2120.5261,2132.9084,2146.863,2160.863,2172.0903,2184.1292,2194.7595,2205.3176,2212.2942,2219.1692,2223.2227,2224.7695,2229.7417,2240.731,2251.0237,2259.7542,2266.327,2271.9216,2275.321,2277.7332,2276.0427,2128.7554,2126.9802,2123.8328,2120.249,2117.2886,2114.9846,2111.81,2106.2246,2100.1602,2095.5796,2091.5796,2087.5396,2085.0999,2083.141,2080.7998,2076.5593,2072.2761,2070.0393,2068.0432,2066.7512,2068.0945,2071.262,2075.8804,2081.5198,2084.5835,2082.1711,2086.431,2092.834,2100.7085,2111.5974,2124.0012,2138.7551,2152.5747,2164.1135,2176.892,2189.8184,2201.1462,2211.985,2221.801,2231.2546,2237.9954,2241.6892,2244.5325,2250.6272,2262.4644,2274.4033,2282.2168,2286.5781,2287.9187,2288.335,2286.295,2133.3237,2130.9016,2129.02,2126.097,2123.6853,2122.2632,2117.6724,2112.2632,2107.0398,2104.6248,2101.2224,2097.808,2094.7434,2091.9763,2089.093,2085.263,2080.43,2075.6057,2072.8945,2070.02,2072.9263,2079.1213,2085.5828,2090.2166,2093.0398,2091.0496,2092.872,2098.6863,2103.7534,2112.2874,2125.4878,2140.8901,2153.4692,2165.2268,2177.5903,2193.651,2205.716,2216.782,2229.8462,2241.9153,2249.604,2255.6448,2258.0896,2263.327,2274.2375,2288.0503,2298.717,2305.0505,2304.0598,2302.259,2297.4229,2140.6023,2137.5598,2134.9495,2134.7446,2133.3901,2129.6436,2125.387,2121.1538,2117.7417,2114.3296,2111.9175,2108.6096,2105.4417,2101.681,2098.8328,2094.4695,2087.5396,2081.6106,2077.1843,2075.8447,2080.1538,2087.0295,2094.0625,2098.0571,2099.2087,2098.8672,2099.1506,2104.902,2108.99,2114.801,2124.7148,2139.5361,2152.033,2165.227,2177.5903,2193.2148,2206.5117,2219.1882,2234.4287,2246.8904,2256.4446,2264.1172,2270.7876,2277.712,2284.6985,2299.5042,2312.498,2318.2563,2318.617,2316.717,2308.933,2149.7434,2147.21,2145.8545,2145.3198,2143.095,2139.7786,2134.8,2130.8586,2127.4465,2124.0344,2120.909,2118.21,2114.236,2110.5146,2106.6357,2101.8115,2095.3872,2085.223,2080.9695,2083.1873,2086.484,2094.6687,2099.6038,2102.884,2104.3215,2104.7246,2106.1458,2111.1096,2117.3232,2123.6738,2128.4292,2134.6125,2149.5005,2163.5718,2176.6892,2190.9187,2205.3914,2220.7266,2235.8328,2250.2058,2260.599,2269.191,2277.7998,2289.099,2297.5532,2310.8306,2322.1497,2331.466,2336.1357,2332.0854,2320.6575,2160.7368,2158.6133,2157.4429,2156.4595,2155.0884,2152.1306,2146.3223,2140.9724,2137.1511,2134.4504,2130.4998,2126.8457,2122.7507,2118.7385,2114.0654,2108.2021,2101.5908,2090.5103,2085.4385,2092.3816,2096.1025,2101.298,2105.6384,2108.919,2110.7512,2112.1516,2109.4446,2115.9102,2125.918,2135.3164,2140.801,2143.2131,2147.7908,2161.618,2175.227,2189.651,2204.1216,2221.3923,2235.8328,2250.4504,2261.818,2271.7002,2282.3787,2295.424,2306.6455,2318.439,2330.183,2342.168,2349.6418,2347.195,2337.6624,2172.5737,2172.204,2170.9094,2170.2886,2168.934,2166.522,2161.467,2153.3474,2145.854,2142.1472,2139.081,2134.905,2132.2075,2127.732,2122.9077,2116.561,2107.93,2094.8665,2095.4814,2103.0298,2105.8442,2106.1506,2111.9749,2116.329,2118.7412,2121.1416,2120.137,2120.3337,2133.371,2144.7742,2153.0977,2159.0554,2161.2126,2165.4475,2175.8215,2189.744,2203.2537,2220.681,2234.4844,2249.5137,2261.9539,2273.0144,2284.794,2297.1355,2308.357,2320.508,2336.1184,2347.017,2355.324,2352.0154,2343.556,2185.8457,2186.7214,2186.3154,2185.713,2184.4001,2182.9382,2180.04,2171.6233,2160.2593,2153.6003,2146.958,2142.944,2138.979,2136.0137,2129.7139,2122.4617,2111.6414,2100.6882,2108.2014,2115.3167,2116.7048,2114.9636,2118.6318,2124.6338,2127.6736,2129.5715,2130.2021,2128.47,2136.8237,2149.7708,2160.3694,2167.9412,2174.2454,2178.4578,2182.665,2191.9253,2203.776,2220.5464,2232.7434,2248.0881,2261.9539,2274.0144,2286.075,2297.6277,2308.3342,2319.4727,2334.2688,2343.9448,2351.0403,2350.9043,2341.6113,2199.2363,2199.836,2199.836,2198.8684,2197.4812,2195.069,2191.4783,2186.831,2177.822,2166.94,2156.885,2149.4163,2143.462,2137.44,2130.8704,2121.7693,2111.6704,2110.3662,2119.819,2126.805,2127.836,2125.8865,2126.2827,2132.6382,2136.637,2139.2737,2139.8477,2136.714,2139.756,2151.093,2163.915,2174.5586,2183.89,2190.7537,2198.112,2203.6458,2208.588,2218.2566,2230.4734,2245.8833,2261.3867,2274.0144,2286.075,2296.8933,2306.7898,2317.6897,2328.8066,2338.0496,2343.274,2344.909,2338.618,2213.2522,2212.8428,2211.9668,2211.0244,2209.9646,2208.2002,2205.6028,2201.1848,2189.9458,2175.9045,2164.6711,2154.031,2145.3918,2135.7527,2126.162,2120.0015,2118.978,2120.3977,2130.4636,2138.0425,2140.9153,2139.2415,2135.9734,2140.5332,2145.5703,2148.9824,2149.9707,2148.968,2147.7249,2152.623,2165.411,2178.4019,2189.562,2199.2039,2208.1323,2214.234,2219.0544,2224.8237,2231.4553,2243.677,2259.1511,2273.6199,2286.06,2295.715,2305.3635,2315.012,2324.6672,2332.246,2337.9888,2341.0066,2333.7654,2230.5173,2228.4487,2226.4067,2224.1462,2222.4724,2220.7761,2218.3208,2212.9055,2202.491,2183.2544,2171.183,2157.883,2142.5254,2131.48,2129.2383,2131.311,2132.5173,2133.6428,2140.5425,2148.9758,2152.0762,2150.645,2145.133,2148.6282,2154.2185,2158.6912,2161.098,2161.098,2159.8525,2158.6782,2166.8079,2180.8281,2194.2637,2205.1912,2215.1309,2225.543,2232.602,2238.8267,2244.2505,2249.3982,2259.7734,2273.0144,2283.6555,2294.2888,2303.9373,2313.44,2322.2344,2329.7317,2334.3513,2337.203,2330.7754,2243.4775,2242.9565,2240.5444,2237.141,2233.0286,2229.968,2224.1829,2217.6365,2206.9756,2187.0303,2173.8372,2159.931,2140.7427,2132.8088,2137.7368,2143.0044,2146.1208,2146.2288,2152.4663,2159.8376,2163.3752,2162.5078,2157.1492,2155.7222,2162.7705,2170.2378,2172.65,2173.2288,2172.8672,2171.5186,2171.672,2183.1743,2196.4692,2209.786,2225.9495,2237.7495,2245.8557,2252.9448,2258.8076,2264.598,2270.4856,2276.6206,2284.7388,2293.1355,2303.357,2313.0054,2320.9905,2327.3054,2330.721,2334.1543,2329.4822,2257.1677,2253.8516,2249.8997,2246.6172,2241.4805,2233.7634,2224.2363,2214.2039,2202.8896,2184.5503,2173.1472,2157.8784,2142.969,2143.6885,2148.8967,2153.8635,2158.7415,2161.344,2166.0044,2172.5784,2176.5803,2174.911,2167.456,2167.5076,2174.1506,2180.378,2184.781,2185.9666,2186.3599,2185.881,2185.3093,2187.271,2197.4692,2215.2974,2233.8423,2247.4668,2258.5903,2266.918,2272.9207,2278.129,2283.7415,2289.2766,2294.6768,2301.641,2308.6057,2315.5017,2322.354,2327.4026,2331.2473,2332.8281,2327.3955,2268.0867,2264.2546,2258.3618,2252.227,2244.28,2234.0964,2223.1602,2211.3474,2196.5828,2180.516,2169.1655,2156.731,2147.5483,2151.939,2158.552,2167.4724,2173.489,2176.8142,2181.2598,2186.9597,2188.777,2187.1804,2180.5376,2179.0452,2186.6982,2193.2007,2196.912,2198.189,2198.491,2198.491,2198.4214,2196.1545,2199.9075,2218.9363,2238.029,2253.1775,2265.9697,2275.912,2284.6553,2291.2026,2295.8723,2301.2996,2307.5254,2313.3452,2318.4712,2323.894,2327.758,2331.1174,2333.884,2331.472,2323.044,2277.4976,2274.2466,2267.252,2257.4863,2247.8306,2236.4583,2222.9817,2210.3303,2192.982,2179.9243,2168.6912,2158.282,2155.0623,2161.8762,2171.2493,2181.5203,2189.9958,2196.1704,2199.746,2201.2825,2201.6284,2197.9355,2190.1797,2191.3235,2200.1838,2205.7563,2209.2197,2211.7256,2212.7769,2212.9133,2211.801,2209.7507,2208.635,2221.96,2239.7444,2256.9055,2270.9033,2284.1394,2294.4727,2300.709,2307.3186,2314.9026,2319.7744,2324.476,2329.3367,2332.6245,2335.1191,2338.2488,2337.6396,2329.2764,2318.9185,2285.9458,2282.3503,2273.7083,2262.3633,2250.7778,2237.6335,2221.2783,2206.6191,2191.436,2180.6958,2168.6912,2160.2278,2164.359,2174.685,2186.6558,2196.366,2203.6528,2210.1196,2215.4604,2215.5588,2213.8044,2210.1208,2201.8604,2206.024,2214.0942,2221.4268,2226.507,2229.4045,2229.3035,2228.646,2226.2651,2223.8218,2221.4097,2224.4565,2240.8997,2258.3901,2273.5522,2288.277,2300.5674,2310.195,2320.621,2328.7803,2332.7678,2335.9226,2338.0415,2340.903,2343.3152,2344.5762,2339.5999,2328.501,2315.511,2293.2476,2286.6223,2277.3362,2265.2646,2249.896,2235.4287,2217.7952,2201.4873,2189.0083,2177.971,2167.5454,2166.4268,2176.1262,2187.1614,2197.2856,2208.4353,2217.0767,2225.9736,2230.8606,2229.8716,2226.9639,2220.8171,2214.3027,2218.623,2229.8313,2238.8875,2245.67,2246.8142,2245.592,2243.8455,2241.7896,2239.3557,2235.9668,2233.5923,2242.2952,2260.6306,2274.7834,2290.6587,2304.7861,2317.8235,2330.8796,2340.6926,2344.899,2346.8938,2347.9033,2349.1816,2351.5938,2352.7036,2341.5496,2328.5986,2314.7522,2294.588,2288.0537,2278.1348,2264.3455,2247.5183,2232.858,2216.4023,2201.908,2188.385,2177.8413,2173.924,2177.1152,2186.9553,2197.3584,2210.5852,2221.857,2231.6177,2240.841,2247.945,2248.1807,2243.9448,2234.8518,2227.2756,2230.754,2241.24,2252.051,2260.2603,2264.2512,2263.5754,2261.1633,2258.5293,2255.0664,2249.7363,2247.8208,2251.4038,2262.885,2276.6567,2292.1294,2306.1992,2321.8535,2334.3567,2348.4631,2356.236,2358.418,2356.7727,2357.4602,2362.932,2359.7227,2343.2703,2329.9636,2314.7522,2295.588,2287.5273,2277.4287,2264.2979,2248.8828,2233.865,2221.5857,2207.603,2193.6404,2183.4875,2185.3147,2187.7954,2196.463,2210.5166,2223.5244,2235.585,2246.4236,2257.7742,2264.2021,2264.4387,2260.13,2251.0632,2240.96,2242.056,2253.1304,2265.8403,2273.8894,2277.8083,2277.975,2277.8628,2275.848,2270.701,2264.0994,2265.058,2266.645,2272.7073,2281.3618,2295.4304,2306.5657,2321.6719,2334.092,2345.959,2359.2458,2366.2812,2363.8467,2360.829,2364.1133,2357.0332,2343.157,2330.501,2314.7522,2296.4312,2288.9312,2280.5251,2268.1118,2254.6746,2237.618,2226.617,2213.1165,2198.495,2190.2017,2191.5935,2195.7395,2206.19,2221.3396,2234.1448,2246.4607,2259.2979,2268.9434,2275.1775,2277.4138,2274.1716,2263.998,2254.3838,2255.224,2266.7188,2280.8237,2289.3745,2294.323,2295.725,2294.707,2287.3198,2281.201,2280.937,2283.271,2284.0432,2286.5942,2294.8508,2300.6294,2310.2322,2322.2393,2333.1604,2343.6172,2356.7935,2364.708,2365.202,2361.3062,2357.9116,2353.3474,2341.1753,2329.4753,2317.0076,2300.0447,2294.089,2286.242,2275.351,2259.7686,2241.0073,2231.731,2218.1362,2205.0288,2196.7263,2200.9446,2205.9658,2214.5242,2228.4263,2242.066,2256.089,2269.449,2279.348,2287.4622,2291.0896,2289.1763,2281.261,2266.8733,2268.0364,2284.264,2296.1165,2302.537,2307.809,2309.2407,2306.6448,2295.02,2296.7346,2300.2742,2303.5376,2302.9634,2302.0422,2302.9568,2308.6206,2318.559,2329.3103,2335.9355,2344.5696,2355.3635,2363.1726,2363.9072,2358.3054,2354.2026,2346.9473,2337.3677,2327.719,2318.2832,2306.019,2300.9817,2292.145,2280.5034,2263.6643,2244.3157,2234.3928,2221.0793,2209.2036,2203.6306,2208.9592,2214.828,2221.834,2234.6414,2248.602,2263.746,2278.931,2289.3562,2302.3857,2308.028,2303.9766,2295.1658,2285.1848,2287.1042,2296.7605,2307.4592,2315.8022,2321.2234,2321.6467,2319.9893,2312.4072,2312.2363,2315.5405,2318.6467,2318.5693,2317.4087,2317.0227,2320.34,2326.3547,2335.438,2343.024,2350.702,2357.3384,2360.5505,2358.106,2354.2546,2347.7578,2341.3823,2332.8862,2325.1926,2317.6445,2314.484,2308.3025,2298.4202,2284.9167,2267.5862,2249.9348,2236.8188,2224.932,2213.0576,2209.9663,2216.6177,2224.6274,2234.276,2242.3904,2254.932,2272.2908,2286.5676,2300.2546,2316.097,2323.995,2320.3184,2307.8674,2301.7224,2304.6416,2310.3682,2318.783,2328.9333,2333.0583,2335.204,2333.6614,2327.6375,2328.6858,2330.5637,2331.8333,2332.204,2330.5398,2328.67,2330.5789,2336.4744,2344.7847,2355.7764,2362.6907,2365.06,2360.9565,2353.4143,2347.1099,2341.762,2334.2117,2327.9348,2321.2324,2314.317,2322.4287,2315.5261,2306.2292,2291.226,2273.69,2254.787,2240.0337,2228.9822,2217.8748,2216.7507,2226.1497,2236.7583,2246.7415,2252.872,2262.7139,2277.2827,2291.708,2306.1929,2320.5015,2329.9746,2328.9858,2319.6938,2319.2756,2324.2683,2329.8752,2334.7488,2341.62,2345.5945,2347.801,2346.1436,2338.9446,2341.2634,2344.5132,2346.6938,2345.7612,2344.6362,2342.219,2343.666,2348.5486,2358.442,2370.3657,2373.2063,2366.9556,2357.9211,2347.7227,2337.405,2329.5715,2325.008,2320.1643,2315.3198,2308.4832,2330.747,2323.759,2314.0842,2296.176,2279.719,2260.4062,2244.375,2233.8184,2224.1543,2224.4321,2235.615,2248.2212,2258.9243,2268.5337,2276.9294,2285.913,2296.543,2308.77,2322.2078,2333.7961,2336.1592,2333.0972,2334.9517,2341.259,2348.4954,2353.723,2359.0962,2364.0493,2364.6868,2360.6,2355.7476,2358.4138,2360.826,2360.9321,2359.6003,2357.4155,2354.6707,2353.9143,2358.8923,2367.0642,2377.3079,2373.213,2363.173,2353.905,2342.0933,2332.2217,2323.1104,2314.2449,2308.1938,2304.2683,2299.8306,2338.8384,2330.965,2319.9736,2302.0752,2285.1436,2266.2588,2250.698,2239.2617,2230.6223,2233.0205,2244.246,2258.5898,2269.9783,2282.245,2293.2046,2300.539,2305.6628,2312.6536,2325.3704,2340.3066,2347.5625,2348.5684,2350.421,2357.2798,2363.1812,2369.7153,2376.1094,2378.0317,2377.8176,2374.5608,2370.8757,2373.17,2373.8757,2372.193,2370.5325,2367.2832,2364.1658,2363.2505,2365.9917,2369.9612,2372.4072,2366.6406,2360.1396,2352.2915,2340.8037,2329.182,2318.721,2307.2456,2298.6067,2294.8499,2291.1257,2347.131,2338.3643,2324.7656,2307.9382,2290.6414,2271.2888,2256.9587,2245.762,2238.714,2239.3079,2249.441,2263.9138,2276.8906,2293.6836,2303.0183,2310.5918,2316.561,2325.281,2334.3574,2344.045,2356.4978,2363.7625,2367.2056,2371.7583,2376.2915,2383.221,2389.898,2393.0273,2391.9487,2387.2217,2385.5024,2387.3179,2385.0867,2381.5762,2378.9983,2376.5862,2373.2834,2370.0117,2370.1514,2368.9827,2366.525,2361.619,2356.4924,2350.4797,2340.643,2329.7432,2316.5242,2302.4587,2291.8103,2285.293,2279.1077,2354.877,2345.4438,2329.9304,2312.7332,2295.7295,2277.1187,2262.615,2253.3594,2247.323,2246.464,2252.366,2267.5952,2283.2388,2296.983,2309.025,2319.5464,2328.6604,2336.6047,2344.4502,2352.8052,2363.737,2374.6208,2380.8704,2385.1748,2388.9158,2396.017,2402.6912,2407.9866,2406.503,2400.01,2400.0596,2400.3347,2394.943,2388.718,2384.7063,2380.7397,2376.7363,2371.7612,2368.3035,2365.2993,2361.4326,2355.3982,2350.9849,2346.6726,2341.3755,2329.5762,2315.684,2301.622,2291.049,2280.4343,2268.0872,2361.091,2350.5916,2335.4097,2316.5854,2299.6418,2283.5825,2267.5422,2260.1458,2257.3647,2257.3647,2258.1921,2267.8362,2284.501,2297.3757,2311.8064,2324.429,2333.227,2342.9395,2350.759,2360.955,2373.9172,2384.3882,2391.6829,2397.936,2405.3923,2412.3828,2416.7476,2418.0754,2413.3958,2407.0564,2410.8313,2414.175,2397.2625,2387.6895,2379.481,2374.074,2367.9666,2364.5896,2361.8442,2358.149,2354.3447,2348.4656,2342.725,2341.7263,2338.2998,2328.7432,2316.0796,2301.629,2291.049,2280.4006,2267.3774,2367.5393,2355.5051,2339.7925,2320.4082,2303.5532,2287.9175,2274.8372,2268.4788,2267.5872,2267.3723,2267.4976,2275.027,2285.2922,2296.3179,2308.0906,2319.887,2332.32,2343.8481,2355.0142,2365.4763,2379.7502,2392.303,2400.27,2408.8086,2417.3428,2422.074,2421.7568,2414.2986,2407.5847,2402.1328,2398.79,2394.1821,2384.8027,2374.9778,2366.7415,2360.1526,2355.0916,2352.4585,2349.7058,2348.5198,2346.0662,2340.242,2334.9153,2334.6687,2333.2866,2327.9946,2317.026,2302.622,2290.7969,2278.9834,2266.7522,2375.3171,2360.2346,2342.7012,2323.289,2307.4055,2292.2874,2280.3047,2278.3884,2279.718,2279.718,2277.994,2283.5488,2291.7852,2301.138,2311.2551,2319.4385,2329.7996,2342.6167,2354.553,2366.1875,2381.5854,2396.447,2406.205,2414.6724,2423.6216,2427.9265,2418.0398,2407.8362,2398.4756,2390.3096,2384.1992,2376.9495,2367.8193,2360.4204,2354.1277,2348.8423,2344.1409,2340.3706,2334.936,2335.282,2336.0803,2331.9858,2325.155,2326.483,2329.1692,2326.051,2317.3462,2302.622,2290.5615,2277.5574,2265.791,2378.1758,2362.1729,2343.893,2325.7153,2310.8882,2297.9565,2291.063,2291.6978,2291.849,2290.6956,2289.5432,2292.1973,2299.4744,2310.491,2322.558,2331.5125,2338.638,2346.434,2352.6208,2365.848,2381.3533,2394.5662,2406.3762,2416.109,2424.8572,2420.8455,2410.206,2400.7747,2388.4485,2378.521,2370.5723,2362.0325,2355.4695,2348.539,2342.7148,2337.2605,2331.8938,2324.6287,2322.151,2322.9294,2323.0803,2319.9724,2312.5112,2314.014,2320.1992,2320.4807,2314.361,2302.2046,2289.5615,2276.601,2263.0706,2375.1116,2360.6748,2344.2756,2327.1992,2313.9512,2303.0881,2299.5303,2300.8584,2303.1865,2303.565,2301.949,2302.6628,2308.0056,2319.3745,2332.2908,2341.8247,2350.88,2357.4043,2361.951,2367.5332,2381.4866,2394.5237,2408.6592,2417.2031,2420.3257,2414.3647,2402.5063,2389.6497,2378.589,2366.3901,2356.9456,2348.5674,2342.5425,2336.408,2330.808,2325.7595,2320.0286,2314.111,2308.136,2308.2517,2308.593,2305.099,2301.816,2304.6702,2310.5376,2311.9211,2306.8254,2298.2942,2287.7654,2276.5212,2262.988,2371.2476,2359.095,2345.0405,2331.7324,2320.2485,2311.5889,2310.2898,2312.9243,2315.5557,2316.7861,2315.188,2313.1282,2317.4326,2328.2068,2340.2673,2351.4402,2361.0886,2369.2473,2375.3594,2379.6475,2385.4832,2396.9448,2407.8684,2415.1062,2416.181,2409.5037,2395.251,2383.4448,2369.8381,2356.2683,2345.055,2337.263,2330.4297,2324.9595,2320.675,2314.044,2307.906,2302.4246,2298.9668,2298.1604,2296.9204,2293.683,2289.919,2294.411,2296.728,2297.4153,2294.3398,2288.662,2281.5342,2272.934,2263.2874,2369.4697,2359.0576,2347.5273,2337.1958,2326.8787,2322.8213,2326.545,2330.3376,2331.8916,2332.0962,2329.236,2325.8196,2331.848,2341.0813,2350.3123,2362.0327,2373.1958,2381.3784,2387.4905,2391.7783,2395.1724,2401.2078,2407.238,2412.5364,2413.3677,2405.3098,2392.0283,2380.0771,2364.231,2351.647,2340.4248,2330.7764,2322.4421,2316.7944,2311.6187,2305.1,2299.9702,2295.146,2291.6882,2289.6277,2286.2527,2279.8706,2278.4214,2281.058,2282.9487,2282.3726,2280.2126,2275.6824,2271.431,2266.2903,2258.6729,2371.303,2361.7947,2353.028,2343.4543,2334.2131,2334.981,2341.552,2344.4172,2345.373,2345.373,2344.386,2343.1694,2348.7312,2356.575,2361.8394,2371.6338,2383.4983,2392.36,2397.7363,2403.4858,2407.3215,2408.2715,2410.0916,2410.7407,2408.687,2402.7974,2388.8198,2376.697,2360.7732,2348.0552,2336.7166,2327.4443,2316.523,2309.1414,2303.6755,2299.5806,2294.1897,2288.8706,2284.4097,2280.9976,2276.32,2269.5703,2269.791,2271.7334,2271.7761,2270.4314,2267.8394,2263.4011,2258.577,2253.7527,2247.6165,2376.3843,2368.0298,2358.8804,2349.232,2343.6816,2348.5383,2353.8616,2357.596,2359.5088,2360.7988,2358.6785,2356.5059,2361.4585,2369.1624,2374.9563,2381.1116,2392.4023,2400.1394,2408.438,2414.8074,2416.9758,2415.641,2412.7283,2409.6304,2405.3054,2397.9534,2385.6826,2372.9158,2360.15,2347.7126,2335.7217,2325.5723,2315.9238,2304.5813,2299.781,2293.738,2289.1853,2281.6587,2277.6318,2273.051,2268.0208,2262.7925,2259.4958,2259.4941,2259.074,2256.6182,2252.668,2248.343,2243.263,2237.6946,2231.7146,2383.6628,2374.3728,2363.733,2353.1575,2354.7717,2361.1685,2366.9197,2371.1963,2372.6382,2373.6353,2373.5747,2371.5447,2372.9602,2380.826,2387.5867,2393.411,2400.63,2408.8962,2418.0806,2423.7134,2423.781,2420.7258,2414.6655,2409.4592,2402.8792,2392.1738,2380.5037,2367.2195,2356.1467,2345.7856,2334.6572,2324.1462,2314.4976,2305.0093,2297.8982,2291.7397,2286.9487,2281.0215,2275.8809,2269.5156,2264.6914,2258.6326,2253.985,2252.573,2251.073,2245.5378,2239.3499,2230.5027,2226.5354,2221.6382,2215.8367,2389.5884,2380.1572,2369.055,2361.8013,2366.6018,2375.0662,2381.6548,2384.7102,2387.1204,2388.1194,2388.1194,2385.8801,2386.4177,2392.9346,2399.1934,2405.783,2413.2131,2421.716,2428.2642,2430.4065,2428.758,2424.8582,2417.7625,2409.4458,2400.9985,2388.605,2376.12,2361.3728,2350.5574,2342.6636,2331.3684,2321.72,2312.3872,2304.729,2297.8457,2292.6094,2286.9155,2281.7085,2276.2668,2270.0173,2266.5156,2264.067,2261.3926,2257.9858,2254.3813,2248.9524,2240.6235,2228.4817,2214.2388,2205.7874,2200.2568,2394.4407,2385.968,2375.217,2370.9548,2376.536,2385.4177,2391.654,2396.6184,2399.9026,2402.2207,2404.3213,2404.4033,2403.7278,2406.5833,2413.5125,2420.3647,2426.731,2432.5417,2436.3384,2436.0225,2433.6104,2426.8389,2417.9094,2409.3018,2400.0156,2387.1826,2375.4734,2360.8337,2349.0186,2338.3237,2327.8066,2320.1794,2312.3186,2303.3882,2297.8457,2291.7397,2286.9155,2281.1267,2277.4128,2274.436,2272.5168,2270.7354,2269.3232,2266.817,2261.7852,2254.7493,2246.5684,2236.8848,2222.084,2206.873,2194.2283,2399.4988,2391.963,2383.2317,2381.9707,2386.1677,2395.0745,2402.359,2408.1257,2412.8262,2416.323,2417.9927,2419.424,2421.0193,2423.5032,2428.1853,2433.9863,2439.6282,2443.7402,2444.797,2442.434,2436.5662,2427.5579,2417.9094,2409.0554,2398.81,2386.964,2375.8945,2362.0396,2351.0293,2339.7815,2329.1882,2321.7605,2314.5242,2305.2249,2298.9934,2292.9722,2289.7576,2285.6987,2281.3806,2279.8384,2278.5776,2277.493,2275.5989,2272.0142,2268.3665,2259.3542,2250.2153,2240.8276,2229.3796,2216.1973,2201.0571,2405.1455,2398.541,2391.6396,2393.412,2395.6443,2402.3303,2411.5447,2418.4507,2422.5334,2426.9424,2429.9863,2433.0305,2436.3142,2439.9182,2444.3743,2448.6375,2452.2695,2453.7896,2452.8171,2448.316,2438.8381,2427.33,2416.505,2407.6292,2397.761,2386.964,2376.5264,2363.3604,2354.2822,2344.002,2333.9158,2324.1868,2316.9504,2306.2148,2300.4602,2296.4539,2293.7214,2291.9124,2288.7622,2286.485,2284.7048,2282.661,2280.6113,2275.7776,2269.9534,2261.7432,2251.3462,2241.6978,2231.681,2220.7012,2207.7039,2409.663,2404.8865,2402.2048,2404.1746,2406.703,2410.779,2418.126,2427.7412,2432.1802,2436.1204,2441.7239,2445.4854,2449.5554,2453.4138,2457.2417,2460.178,2462.2148,2461.4453,2457.612,2448.8547,2438.255,2426.1973,2415.1235,2406.261,2397.2095,2387.9556,2376.919,2364.9402,2356.322,2347.4282,2338.7102,2327.643,2318.431,2307.9102,2302.4143,2300.1086,2298.547,2296.1616,2293.7495,2292.2793,2288.9143,2285.8523,2281.97,2276.121,2269.4243,2260.6997,2250.9712,2241.6978,2232.049,2221.4006,2209.7522,2414.0405,2410.8503,2410.2253,2413.8218,2419.2915,2421.7036,2426.989,2433.9392,2441.9458,2448.5347,2453.0757,2456.784,2460.724,2465.0327,2469.6265,2472.309,2470.1528,2466.9116,2460.255,2448.094,2438.2063,2425.0737,2414.9094,2406.3503,2397.9016,2388.9595,2378.3787,2367.7478,2358.6294,2349.8542,2340.6858,2330.0732,2320.448,2314.1987,2309.0166,2305.3225,2302.7058,2301.0142,2298.4246,2295.5984,2292.2935,2287.1914,2280.9626,2274.0276,2266.514,2258.632,2249.025,2240.2134,2230.565,2219.968,2209.601,2422.587,2419.434,2420.0405,2425.437,2430.319,2434.0168,2436.9993,2441.4146,2450.7402,2457.9395,2464.2222,2469.031,2473.8552,2477.6475,2478.774,2478.0127,2475.3105,2468.8,2460.255,2447.8547,2437.211,2425.4683,2415.8198,2407.4292,2399.156,2390.8745,2379.8425,2369.5774,2359.951,2351.3394,2341.6384,2332.8508,2326.0332,2321.1194,2317.0132,2312.471,2308.2786,2304.9976,2301.1775,2295.5125,2292.6355,2285.3164,2278.1328,2270.2866,2262.8079,2255.1067,2245.5251,2236.9456,2227.6946,2216.671,2206.8418,2432.466,2430.1382,2434.2385,2438.568,2441.8206,2444.9585,2448.9807,2453.5283,2460.3567,2468.5405,2475.8865,2481.1619,2485.4302,2486.9463,2485.1975,2481.561,2476.6357,2468.8638,2459.3792,2447.547,2437.2063,2426.5579,2417.246,2408.7825,2400.345,2391.967,2381.8945,2371.0037,2361.3552,2351.3643,2345.488,2339.0466,2333.2224,2328.0615,2322.519,2317.4128,2312.252,2307.091,2301.5637,2294.106,2287.6902,2279.518,2272.2817,2265.7087,2258.809,2249.9846,2240.6729,2233.0745,2223.376,2213.7273,2204.4155,2441.415,2441.2878,2445.2234,2448.9363,2452.406,2454.9998,2458.409,2463.6838,2471.8262,2480.1982,2486.5332,2489.9478,2492.443,2493.24,2489.687,2483.9873,2477.1,2469.1519,2459.4739,2448.7275,2437.9814,2427.3208,2419.4448,2411.1648,2402.3752,2393.7358,2383.6572,2372.4695,2363.7896,2356.3975,2351.37,2344.5623,2338.0562,2332.151,2326.3936,2319.7397,2315.136,2306.374,2299.1375,2291.07,2282.3738,2273.6655,2266.4292,2259.4302,2252.5154,2241.943,2233.2148,2224.664,2217.2483,2209.775,2201.3013,2449.7007,2450.8967,2454.817,2458.641,2461.4653,2465.4346,2470.3367,2476.907,2484.7646,2490.0608,2493.3943,2496.8518,2499.5671,2499.5432,2494.951,2486.5469,2478.857,2470.3408,2459.6924,2450.42,2440.3955,2430.7468,2421.871,2413.7888,2404.8015,2396.1548,2387.163,2376.0452,2368.642,2362.4058,2355.9934,2348.842,2341.5076,2332.893,2325.6567,2319.3616,2313.2637,2302.8042,2296.0085,2289.4656,2280.0117,2269.2854,2259.3728,2251.0708,2241.8867,2231.191,2220.8628,2214.017,2208.2683,2203.6956,2196.998,2457.7327,2460.6248,2463.9062,2466.788,2470.555,2475.8508,2482.6125,2489.2336,2494.465,2498.5164,2502.7307,2507.555,2508.0603,2505.1033,2499.8035,2489.133,2480.7153,2471.767,2462.1187,2452.47,2442.8215,2433.173,2424.4373,2417.061,2407.998,2398.5884,2390.931,2381.4744,2373.4944,2367.0474,2359.4065,2351.3696,2342.3186,2329.9727,2320.282,2311.7878,2303.2969,2295.6934,2288.5986,2281.067,2274.5085,2265.6023,2254.0884,2244.061,2232.958,2221.4368,2211.7556,2204.3123,2197.9482,2193.6777,2190.8423,2462.4414,2466.1646,2470.1436,2474.0645,2479.2295,2485.4658,2491.7021,2498.3477,2504.2134,2509.0376,2514.8545,2517.9265,2514.8215,2510.892,2503.1802,2492.6438,2483.1416,2475.1814,2465.5447,2455.3823,2445.2478,2435.96,2427.7236,2419.487,2411.6538,2401.0557,2393.778,2385.7085,2378.3367,2370.4387,2361.7603,2351.5916,2339.4524,2325.7222,2313.6086,2300.266,2289.6614,2281.0522,2276.1274,2271.309,2267.179,2256.7783,2246.789,2237.1672,2224.7988,2211.5464,2201.1943,2191.449,2183.3499,2180.7595,2181.1047,2463.1182,2467.7668,2473.5283,2479.7932,2486.4666,2493.703,2500.9392,2507.6433,2514.8767,2519.895,2525.5251,2526.3918,2520.6323,2515.7446,2507.3115,2496.9688,2486.2678,2477.6194,2468.4387,2458.79,2448.1692,2439.0256,2430.7385,2422.815,2414.3594,2404.9082,2397.2043,2389.4355,2382.1992,2374.3054,2364.0872,2350.8845,2336.0632,2323.4702,2309.356,2296.2798,2283.9998,2276.5588,2269.4329,2262.3645,2253.4678,2243.7046,2237.0845,2229.5154,2217.6536,2205.3635,2196.8137,2184.13,2175.1008,2168.7974,2168.9736,2460.9617,2467.4482,2474.1147,2481.821,2490.312,2499.8542,2508.3967,2516.9824,2523.5815,2529.4058,2534.3176,2537.3108,2531.1057,2520.597,2511.885,2500.4429,2489.6624,2480.0457,2471.3972,2462.6917,2451.1519,2441.4517,2433.494,2425.3396,2417.1033,2408.866,2401.148,2393.394,2386.0518,2378.7456,2366.3777,2351.4668,2337.2236,2326.9521,2311.7612,2299.267,2289.0276,2279.9653,2270.7554,2261.6965,2251.1965,2242.582,2234.7292,2228.4214,2223.0203,2213.5435,2202.665,2189.236,2175.4553,2164.496,2157.4246,2452.638,2463.0317,2472.3308,2481.4495,2492.7727,2504.312,2514.4697,2525.3237,2533.2864,2538.5256,2543.9348,2546.041,2540.1174,2529.6423,2516.6335,2503.8809,2492.8203,2482.472,2473.9077,2465.5396,2454.8816,2444.878,2436.0022,2427.7659,2419.6584,2412.293,2405.3767,2398.1404,2389.4172,2381.4573,2370.2227,2356.2317,2341.6313,2332.4163,2318.9338,2305.3093,2294.471,2284.8225,2275.174,2265.5256,2256.0679,2248.4216,2241.9153,2235.0388,2227.8538,2218.8237,2207.4539,2193.791,2178.8816,2167.177,2155.5964,2445.5854,2456.0684,2467.159,2479.9082,2493.037,2505.6387,2518.7734,2532.0378,2541.2449,2547.1743,2552.0662,2552.9995,2545.975,2536.111,2520.4163,2506.3071,2494.724,2484.1519,2475.5032,2466.737,2457.2449,2448.3042,2438.6558,2430.192,2422.6548,2415.726,2409.336,2402.8684,2393.5112,2384.607,2375.363,2362.084,2350.543,2339.0151,2326.9304,2312.4907,2300.1858,2289.6748,2280.0264,2269.7969,2260.9202,2252.837,2245.705,2237.2915,2228.643,2218.5557,2205.9363,2194.49,2179.1792,2168.4006,2156.694,2443.1145,2453.5706,2464.479,2477.5396,2491.9546,2505.0264,2518.048,2532.271,2545.1846,2553.6619,2560.4275,2560.023,2547.9187,2534.8123,2519.2766,2506.3884,2494.328,2483.9297,2475.3308,2465.775,2457.1975,2448.5579,2439.5488,2431.4775,2425.9788,2419.1455,2412.9092,2405.6729,2398.9458,2387.5425,2377.894,2366.847,2355.7034,2344.7761,2333.225,2318.3914,2305.0823,2294.3628,2283.7063,2274.0579,2264.4424,2255.761,2246.125,2237.2915,2227.643,2217.2761,2203.0593,2191.374,2177.9014,2165.311,2154.526,2441.4016,2451.874,2462.0527,2474.5146,2488.5435,2502.636,2514.6965,2528.348,2543.8193,2556.7253,2563.992,2555.5706,2541.348,2526.2363,2513.615,2502.765,2490.4043,2479.782,2471.7815,2462.8728,2454.9575,2446.3606,2437.0835,2431.0317,2426.8062,2419.3796,2414.1577,2406.0684,2399.4775,2387.909,2378.1646,2368.1643,2356.51,2344.1775,2331.7825,2318.0996,2306.557,2295.228,2284.788,2275.8855,2266.8357,2257.4292,2247.5298,2237.2915,2227.1406,2215.492,2201.2854,2188.577,2175.2793,2161.9622,2152.7522,2436.7495,2447.4011,2458.0598,2469.639,2482.423,2497.5251,2511.023,2524.5205,2538.9653,2550.6003,2553.246,2543.4456,2530.627,2517.6074,2506.5469,2495.374,2483.4258,2473.0771,2464.5498,2456.7554,2448.082,2438.4673,2431.6018,2426.7112,2421.085,2413.8823,2407.6123,2399.5427,2390.655,2380.9116,2370.622,2360.492,2348.5127,2336.04,2322.5674,2309.2031,2298.26,2291.0361,2281.8257,2273.6143,2266.4028,2258.1914,2248.9646,2238.875,2227.8247,2216.5168,2203.044,2188.5732,2176.5735,2163.6484,2154.0813,2429.02,2440.6355,2452.51,2463.8098,2475.4197,2491.2466,2505.8174,2520.4585,2535.5596,2544.7048,2544.0872,2533.342,2520.747,2509.3923,2499.2683,2486.7566,2474.8313,2465.1895,2455.699,2446.5994,2436.951,2427.663,2420.9756,2415.2917,2409.2231,2403.7136,2395.4812,2387.2449,2379.2144,2370.566,2360.886,2349.5698,2337.2754,2323.909,2309.591,2297.675,2287.7751,2280.3325,2273.0962,2267.287,2260.9001,2255.892,2248.4956,2239.2915,2229.192,2217.7432,2205.3184,2191.4902,2178.5112,2166.952,2155.3013,2419.6768,2432.1855,2445.0195,2457.0803,2469.0974,2483.062,2497.5635,2512.627,2528.3806,2536.7114,2535.7136,2525.142,2513.988,2503.1138,2490.2192,2477.1501,2465.9053,2454.678,2445.0095,2434.998,2422.9941,2412.7773,2406.219,2402.2441,2396.5425,2389.7092,2383.2986,2375.9912,2368.5396,2359.9417,2350.1514,2338.5686,2327.115,2312.0464,2299.5305,2288.84,2277.8535,2269.6277,2261.514,2254.2776,2249.3547,2246.0107,2243.3232,2235.1047,2226.1523,2216.1172,2204.8054,2192.5464,2178.5615,2165.7239,2154.1487,2412.1282,2425.984,2438.741,2449.819,2462.4126,2475.6895,2488.3408,2503.3313,2520.1055,2530.3494,2531.817,2524.1152,2511.8484,2499.6377,2485.2563,2474.4487,2463.0127,2450.4397,2439.3792,2426.3186,2414.258,2402.8613,2395.7512,2389.3604,2383.4111,2377.7654,2371.347,2364.8667,2357.7466,2349.1562,2339.5078,2329.8591,2316.497,2303.6526,2293.303,2280.8328,2269.9204,2259.9685,2249.5752,2242.383,2236.4045,2232.2769,2227.7666,2224.6284,2219.729,2211.3877,2201.3792,2190.1904,2177.8403,2168.0076,2157.4006,2405.6353,2417.7903,2430.7327,2443.481,2456.3132,2469.1406,2484.343,2498.8157,2514.289,2527.9517,2532.935,2527.502,2515.5505,2503.871,2489.4988,2477.0203,2465.23,2452.9768,2441.0752,2429.4395,2416.7688,2406.6567,2395.6575,2384.721,2374.641,2366.331,2360.9688,2355.3113,2347.3452,2339.4514,2329.803,2319.6729,2307.3706,2297.317,2286.9504,2275.02,2263.829,2251.0388,2240.9788,2232.6963,2227.2107,2222.768,2218.792,2216.4253,2214.089,2208.4294,2202.044,2191.942,2183.0999,2173.933,2164.5234,2396.751,2410.1416,2423.8699,2437.547,2452.7727,2465.5999,2480.9167,2496.4814,2511.862,2526.1003,2537.7834,2535.475,2523.5044,2508.994,2495.9001,2481.8726,2469.5122,2456.5957,2445.535,2433.7139,2422.5618,2410.8696,2400.569,2388.6997,2377.4204,2364.129,2355.3154,2346.537,2336.8374,2329.1458,2318.797,2308.8872,2299.7114,2291.1526,2280.816,2270.3032,2258.519,2246.072,2237.9004,2229.7854,2223.237,2217.3972,2215.985,2214.0667,2213.7341,2215.4678,2211.0898,2203.234,2191.8733,2180.8127,2169.7466,2385.0308,2401.7053,2421.13,2436.0723,2451.1907,2464.0178,2478.4905,2494.316,2508.8525,2522.667,2532.7441,2531.1929,2524.8813,2512.6555,2499.7278,2485.6262,2473.49,2460.604,2449.0334,2439.331,2427.026,2415.7222,2405.0735,2394.2402,2382.1797,2369.114,2357.8977,2345.931,2332.404,2319.2737,2306.8113,2297.279,2289.5142,2281.754,2274.0996,2265.6787,2254.7065,2244.6003,2237.0535,2231.1172,2223.4277,2218.3972,2215.9937,2216.5913,2218.4885,2219.4358,2215.7324,2207.2798,2196.7256,2185.083,2175.8105,2375.1074,2397.1663,2418.7039,2434.654,2449.7673,2461.8313,2475.0642,2489.123,2505.9985,2517.6404,2522.7954,2521.2341,2514.3499,2506.7678,2498.5398,2486.5518,2475.5002,2463.4539,2452.5188,2443.863,2433.3257,2419.5745,2409.1514,2398.0928,2386.024,2374.9453,2360.9026,2346.341,2330.2847,2315.0635,2301.495,2286.575,2277.1892,2270.349,2264.7983,2256.7065,2249.8022,2242.0747,2235.2556,2230.4326,2223.4277,2218.3972,2218.0,2218.4353,2220.8406,2220.006,2217.6785,2209.781,2199.5657,2187.5166,2180.0166,2371.968,2393.8655,2416.8079,2434.1624,2447.9731,2460.3987,2472.6382,2485.0854,2500.1506,2512.9612,2512.6077,2507.3445,2500.4387,2494.7004,2488.835,2482.4187,2474.9307,2465.4612,2455.9377,2446.8257,2438.5894,2424.2703,2413.4426,2402.4062,2389.4502,2376.946,2362.3289,2349.073,2332.717,2318.1472,2299.434,2284.8167,2273.9192,2264.6897,2255.0054,2249.553,2242.7397,2238.611,2232.1077,2228.2214,2223.945,2220.0935,2219.441,2220.676,2221.9092,2220.7485,2218.3364,2210.7305,2200.7842,2190.735,2186.6926,2369.0818,2390.562,2414.3816,2431.736,2446.2666,2458.8657,2470.8542,2481.1506,2493.4358,2504.1694,2501.2148,2493.2178,2487.3936,2481.7087,2475.8845,2472.8086,2470.2156,2465.7554,2458.364,2449.2517,2441.0154,2428.6084,2417.6309,2405.6384,2392.2793,2377.946,2364.334,2349.024,2332.633,2317.1946,2302.414,2290.6553,2281.8674,2271.219,2260.8525,2252.3127,2243.6277,2238.952,2233.1277,2229.082,2226.6433,2224.1184,2222.7214,2222.8606,2222.8606,2220.965,2218.673,2211.5688,2202.91,2194.9358,2193.3137,2369.6484,2388.8608,2410.9556,2429.351,2443.8403,2457.38,2467.8425,2477.9592,2487.7263,2494.8523,2490.0837,2481.8474,2475.2625,2469.393,2463.614,2459.503,2457.2917,2458.9917,2455.8381,2449.9275,2442.4785,2433.227,2420.7104,2408.1782,2394.4187,2377.946,2364.173,2349.2397,2333.284,2321.7063,2311.8892,2302.2207,2292.5723,2280.53,2269.4763,2260.4968,2249.6914,2241.678,2236.8408,2231.0166,2228.864,2227.57,2226.2869,2225.2869,2224.0461,2221.2148,2218.673,2211.7732,2204.6768,2200.674,2199.6633],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD005.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD005.py load and self-test diagnostics complete.")
