####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD004.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD004.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD004.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD004.x3d'),
    GeoLOD(center=(4344113.536173,738193.374947,2307.5),child1Url=["SquawLOD005.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD005.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw002.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw002.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4343332.077840,737558.999947,0),geoSystem=["UTM","Z10","N"],height=[2124.169,2118.246,2109.4658,2100.852,2091.4053,2082.3125,2078.5056,2070.7307,2064.5586,2060.795,2066.6565,2073.311,2075.0593,2088.7708,2112.412,2139.0354,2166.6782,2190.5676,2210.0293,2222.3972,2228.1274,2249.3877,2265.8076,2275.2107,2275.965,2132.2944,2127.357,2123.2874,2114.4668,2105.6023,2098.7466,2092.5474,2085.754,2075.7317,2070.1875,2080.5403,2091.0417,2091.3433,2100.5322,2117.1365,2146.9463,2171.4175,2200.7314,2225.1982,2247.731,2258.0193,2272.5796,2298.2334,2304.5625,2297.7344,2149.3083,2146.2952,2142.3613,2132.3342,2125.5266,2119.3818,2111.5706,2102.5273,2085.2576,2083.9695,2096.2998,2103.8132,2105.177,2114.045,2126.5857,2141.1384,2170.3174,2199.1584,2231.0874,2258.4783,2276.4563,2297.016,2321.816,2337.9993,2321.5798,2174.1455,2172.1702,2169.2363,2157.5654,2144.2195,2136.3853,2129.4417,2117.8826,2094.9253,2105.3723,2107.4988,2117.7852,2122.089,2124.2754,2149.536,2161.7007,2169.7854,2197.6812,2229.5369,2258.933,2282.295,2306.721,2334.23,2355.0833,2343.5813,2201.9478,2201.938,2198.0142,2190.1428,2171.4263,2151.4148,2138.336,2121.6067,2112.062,2128.7065,2128.2083,2135.3489,2141.62,2138.302,2156.0789,2180.3257,2196.642,2208.0308,2226.0442,2256.9153,2283.2837,2304.7314,2326.6401,2341.7856,2337.618,2232.7424,2228.7239,2223.8406,2217.005,2188.7734,2160.8228,2131.4053,2134.151,2136.5388,2152.0305,2152.5964,2151.2551,2162.1267,2163.132,2162.6667,2187.4905,2212.1155,2233.338,2245.7488,2258.7524,2280.872,2301.766,2320.6602,2333.4395,2330.328,2258.615,2249.8367,2237.18,2216.451,2187.1138,2160.1118,2144.4958,2156.283,2165.2957,2176.7856,2178.0774,2171.7107,2184.9382,2189.2715,2189.5208,2191.7021,2227.2974,2256.4417,2273.2097,2285.5671,2296.9346,2309.9712,2322.68,2331.6746,2326.354,2279.555,2263.8152,2243.036,2213.5784,2182.5962,2159.7122,2164.738,2186.4258,2200.862,2206.0608,2200.5908,2198.014,2211.5735,2216.9548,2217.5823,2213.3596,2230.8892,2266.103,2293.7515,2309.3047,2323.226,2331.972,2337.4175,2338.7256,2317.4353,2291.8772,2270.2327,2238.696,2204.7986,2179.6262,2168.428,2189.7139,2212.4585,2231.4285,2236.169,2224.325,2225.626,2245.8286,2254.014,2249.339,2242.9258,2239.003,2269.068,2300.9092,2329.5571,2349.0989,2351.4028,2355.15,2342.9644,2314.597,2291.2346,2270.0544,2240.0295,2213.9287,2187.6436,2190.2754,2214.0464,2240.0862,2263.179,2269.3315,2255.649,2248.8608,2274.3005,2285.2358,2283.5935,2271.8684,2273.171,2282.9026,2302.855,2330.5112,2354.6519,2365.3857,2362.0386,2343.2283,2315.413,2299.589,2282.7524,2248.1733,2224.119,2200.7014,2209.7197,2230.348,2259.1514,2284.224,2297.6875,2286.0789,2279.8972,2303.9126,2314.408,2308.1277,2305.737,2310.7832,2308.4688,2318.7659,2336.7935,2353.3704,2362.577,2352.3145,2335.442,2317.6738,2314.5295,2293.5078,2258.9075,2231.1174,2213.2395,2229.1497,2246.598,2275.0515,2304.0845,2327.9912,2312.2473,2316.1091,2329.3237,2340.017,2337.788,2335.426,2338.7327,2336.289,2340.994,2360.6418,2367.6953,2351.895,2337.1584,2324.6287,2311.4546,2331.175,2306.4932,2269.7317,2239.7947,2228.016,2252.5808,2274.87,2293.6746,2310.5854,2338.8767,2341.0728,2352.0684,2364.0845,2372.2708,2366.7659,2366.86,2366.8472,2361.311,2361.8667,2374.6128,2362.918,2343.013,2321.845,2302.2188,2295.163,2347.0842,2317.9424,2280.5828,2253.4023,2242.1504,2264.381,2294.9324,2315.9133,2332.96,2349.9429,2371.062,2380.0806,2392.3916,2401.0625,2393.8638,2393.3972,2384.4685,2378.1409,2370.6548,2365.1626,2354.3645,2342.5703,2316.9004,2291.491,2270.6477,2359.3376,2325.9858,2291.7058,2266.172,2263.5693,2269.945,2295.4963,2322.008,2344.099,2365.3835,2390.993,2406.993,2419.4773,2414.4307,2404.2104,2395.9358,2375.7385,2362.0732,2355.2786,2350.464,2338.965,2336.0586,2317.9812,2291.491,2266.597,2369.7056,2330.9412,2299.9792,2287.5894,2287.503,2288.474,2306.4646,2327.364,2344.3142,2367.4895,2397.2842,2417.6614,2420.488,2399.4353,2379.5068,2362.7134,2348.881,2337.8894,2326.4521,2326.962,2317.6255,2322.4846,2316.7773,2290.3582,2263.6387,2364.928,2335.8115,2311.9836,2308.7322,2312.7961,2310.3752,2324.784,2348.4966,2366.2852,2376.825,2398.49,2416.8176,2406.8416,2380.9172,2353.6296,2337.1921,2325.5828,2313.5266,2301.5537,2299.7083,2293.6787,2299.809,2298.5825,2283.9883,2263.2463,2365.1355,2346.2354,2330.224,2341.0864,2342.2842,2339.8347,2352.6328,2368.9602,2390.477,2401.3037,2406.8193,2411.4087,2399.6052,2372.1313,2343.0518,2323.7876,2308.26,2297.851,2287.1394,2279.8806,2271.304,2273.8472,2270.7188,2262.0164,2250.4187,2378.0535,2356.6824,2357.3516,2367.8354,2371.5173,2369.1665,2378.0007,2391.1199,2407.723,2422.2605,2418.7036,2408.2595,2390.1458,2364.6018,2341.4177,2320.1396,2301.0947,2289.1938,2277.484,2266.2734,2254.5432,2251.4966,2241.9753,2229.7212,2218.452,2389.9773,2370.4258,2381.61,2394.2075,2400.2805,2402.2812,2403.9368,2418.3218,2431.4246,2435.1892,2425.4514,2407.5884,2384.501,2356.1465,2334.4524,2316.4504,2300.8745,2288.9275,2277.959,2272.1797,2268.9495,2261.8127,2246.7263,2221.4111,2193.376,2401.3362,2390.6963,2398.6606,2416.0642,2425.4976,2431.4585,2438.2598,2447.293,2453.1746,2447.2986,2425.7998,2405.785,2384.325,2359.865,2339.6226,2320.6663,2302.1187,2294.3318,2289.571,2284.5945,2280.9773,2270.5735,2252.385,2231.925,2207.1143,2411.8171,2411.5415,2420.531,2431.9197,2447.038,2455.7925,2464.1548,2471.7979,2466.7146,2447.1582,2423.7136,2404.4966,2385.9233,2364.6875,2345.9363,2325.8782,2311.0725,2303.4475,2299.2888,2292.916,2282.0864,2267.9106,2250.2239,2231.0918,2209.457,2430.8362,2436.7578,2443.7566,2452.273,2466.7864,2480.4783,2487.0938,2481.762,2468.6758,2446.847,2425.113,2407.2788,2389.5688,2367.5615,2349.133,2336.326,2325.6038,2314.4612,2303.616,2289.821,2273.9006,2259.98,2241.6558,2223.7617,2204.2324,2450.3193,2457.2798,2464.2532,2475.701,2489.751,2496.8438,2500.105,2486.9917,2470.231,2449.5056,2429.4429,2412.3447,2393.8755,2373.733,2359.8125,2345.562,2328.982,2316.0908,2297.9792,2282.5667,2261.3625,2242.9595,2221.465,2207.926,2196.6387,2464.282,2473.5107,2484.048,2497.9023,2509.2373,2519.1208,2511.9348,2493.584,2475.1296,2454.7747,2435.13,2418.2095,2399.3867,2383.3684,2367.5613,2345.88,2319.596,2293.1064,2276.7495,2267.4153,2247.832,2226.238,2201.3804,2182.504,2179.875,2463.7063,2478.8704,2497.2559,2515.4788,2529.6838,2538.6355,2522.56,2501.463,2480.3633,2462.4622,2440.6338,2424.1746,2407.2542,2391.594,2374.7263,2343.9602,2320.2583,2294.3757,2274.482,2254.588,2237.8127,2224.8086,2205.2034,2176.6345,2156.557,2449.7212,2473.5754,2501.6687,2528.5361,2547.3193,2554.677,2537.689,2507.0386,2483.901,2466.007,2447.113,2429.14,2414.963,2400.9465,2381.7627,2358.0945,2334.7363,2305.9958,2284.4124,2264.4019,2247.7524,2230.0532,2206.7556,2179.4058,2156.0996,2446.5518,2468.4192,2497.0295,2523.0793,2552.8308,2554.774,2525.5999,2501.421,2478.1458,2460.625,2443.54,2429.4185,2417.2805,2403.3335,2382.964,2362.0042,2336.8596,2309.7458,2288.2603,2269.5503,2250.364,2228.931,2202.6545,2175.8086,2152.664,2432.3088,2457.3325,2483.9111,2513.9749,2540.9353,2533.1265,2508.3765,2484.3687,2462.155,2442.382,2422.8972,2410.0854,2397.492,2381.3923,2363.8157,2340.3645,2312.8423,2289.23,2272.6895,2259.7637,2249.2324,2230.279,2206.9812,2179.6392,2154.597,2416.569,2443.4368,2468.3042,2496.4036,2527.28,2525.8083,2501.2556,2474.9407,2450.2751,2425.5017,2402.2683,2384.5867,2372.3862,2359.1514,2342.0508,2320.9285,2296.3845,2272.0757,2249.4749,2234.4888,2225.5344,2217.8262,2201.9087,2179.1113,2160.0042,2399.572,2430.7615,2460.582,2491.264,2521.3066,2536.898,2512.2222,2484.1675,2457.2998,2435.1807,2411.2866,2388.6973,2363.1382,2342.431,2319.5408,2300.885,2283.0024,2262.145,2239.9363,2225.5503,2216.047,2216.5664,2214.5586,2194.2874,2171.801,2382.8418,2427.7217,2456.7314,2483.4841,2513.4646,2516.031,2502.2473,2485.6804,2464.901,2444.0981,2420.2173,2397.5918,2372.0396,2341.575,2309.762,2279.643,2263.149,2249.211,2236.3667,2225.5503,2218.052,2221.0225,2218.5962,2200.756,2182.1902,2379.8809,2423.7205,2453.6514,2476.6116,2498.59,2488.511,2476.2578,2466.1155,2464.9307,2449.0156,2429.4133,2404.529,2373.9875,2343.5042,2312.6064,2291.7297,2270.248,2249.907,2236.9978,2228.5251,2225.0173,2223.5771,2219.1924,2203.8855,2196.052],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD004.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD004.py load and self-test diagnostics complete.")
