package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD003Index.html" target="_blank">SquawLOD003</a>,  source <a href="../../../Geospatial/SquawLOD003.java">SquawLOD003.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD003.x3d">SquawLOD003.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD003.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD003.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD003
{
	/** Default constructor to create this object. */
	public SquawLOD003 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD003.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD003.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD003.x3d"))
    .addChild(new GeoLOD().setCenter(4342525.411173,738180.782603,2108.000000).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw001.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw001.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4341718.744506,737558.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(51).setXSpacing(24.360000).setZDimension(67).setZSpacing(24.444444).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2202.4375,2188.6848,2176.9758,2163.297,2152.723,2146.0308,2147.391,2149.8032,2150.2092,2147.797,2147.0396,2148.2122,2145.8066,2140.2122,2139.7366,2136.279,2130.1548,2122.0762,2117.0881,2113.1282,2116.982,2103.9236,2082.083,2067.763,2052.073,2036.6205,2021.0006,2008.2299,1995.7422,1987.2125,1978.6227,1972.3607,1967.161,1961.0822,1955.4508,1950.4724,1943.83,1937.9408,1926.0159,1925.2513,1924.6935,1932.0417,1938.3278,1939.1576,1936.6113,1935.1971,1937.7996,1940.5482,1943.041,1944.3882,1944.7845,2195.646,2186.5203,2177.1987,2167.0637,2158.402,2157.3684,2161.0242,2164.2576,2163.385,2159.7893,2159.1743,2159.6,2156.3376,2152.1465,2153.191,2149.891,2144.067,2136.5718,2130.7512,2125.9814,2123.358,2107.1157,2087.2607,2071.5635,2053.4187,2039.2238,2025.7511,2013.1116,1998.7513,1990.5831,1983.6245,1976.5922,1970.6259,1961.5809,1955.8458,1949.7396,1944.9154,1940.0582,1930.8989,1923.5607,1919.8889,1923.865,1930.4703,1933.1666,1930.7213,1925.9038,1929.3093,1931.9645,1934.3766};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {1936.1388,1936.2533,2205.9211,2198.0203,2186.2373,2175.397,2168.5344,2172.4204,2177.5422,2181.3687,2178.7637,2173.4707,2176.1606,2173.1323,2166.9346,2165.1826,2168.5798,2163.6387,2156.7947,2153.4133,2148.9263,2137.8772,2125.9658,2110.1047,2092.3162,2076.6777,2060.209,2045.5507,2029.64,2016.3987,2003.0405,1994.2246,1987.5637,1980.2771,1973.7925,1964.3057,1956.0494,1948.9813,1944.1932,1940.0582,1933.7098,1925.6641,1914.4807,1914.374,1924.87,1928.2778,1926.8324,1921.9147,1921.4968,1923.1656,1925.4565,1928.4832,1928.4694,2217.5974,2208.9287,2194.4749,2181.7305,2182.838,2188.3667,2193.3752,2195.9697,2189.6646,2190.415,2191.0,2186.4956,2177.5457,2177.868,2181.8333,2177.3364,2171.6667,2170.5,2165.8367,2152.6687,2138.1943,2125.1372,2107.175,2089.558,2076.0854,2056.6038,2038.3942,2023.6394,2008.1066,1997.2513,1988.9463,1981.5549,1976.0457,1965.8273,1956.4097,1948.573,1942.8251,1937.9246,1932.7948,1926.6094,1914.6975,1909.9657,1913.7217,1921.4271,1920.6013,1915.0802,1911.9968};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {1915.5756,1917.9877,1920.3998,1921.552,2228.62,2216.2883,2201.4495,2190.8782,2194.37,2201.9666,2210.2427,2210.3032,2202.0557,2204.2432,2205.2283,2197.1187,2188.5488,2188.271,2194.9202,2192.9346,2188.2388,2191.1482,2185.8738,2174.7551,2163.861,2138.9226,2121.647,2102.5327,2083.6553,2066.3726,2048.979,2031.769,2016.1337,2002.8016,1991.8743,1981.3899,1972.9901,1966.0822,1956.4097,1947.66,1941.584,1936.4623,1932.267,1927.9186,1919.1519,1911.4054,1905.1542,1905.9653,1908.9503,1905.1904,1901.3723,1905.1418,1910.0432,1912.7166,1913.899,2239.7312,2224.4575,2208.4807,2202.3826,2208.3772,2214.6333,2223.691,2221.495,2215.3396,2218.8953,2213.9133,2203.7012,2200.6262,2199.465,2205.1736,2205.3838,2204.9888,2213.2766,2210.6309,2198.2437,2183.7976,2155.1536,2133.8137,2113.5142,2091.4473,2074.1038,2057.6956,2040.5564,2025.7081,2009.9174,1998.753,1983.7313,1972.4307,1965.0096,1955.3541,1946.7396,1940.3732,1935.0912,1931.2114,1926.3872,1920.4384,1914.8497,1907.0653,1901.0636,1900.0089};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {1899.707,1899.0,1900.0159,1901.8927,1905.6329,1910.2181,2248.8228,2232.6729,2219.144,2219.4136,2223.5317,2230.95,2238.8213,2232.1365,2233.003,2232.7546,2221.5366,2214.1196,2214.1743,2212.0317,2215.4756,2216.4438,2220.8499,2232.9163,2231.1309,2214.0503,2196.4126,2171.7144,2144.2283,2122.3372,2102.2249,2081.446,2066.7627,2050.2507,2033.2732,2019.2264,2005.6173,1989.8872,1974.084,1963.1233,1954.1278,1946.7396,1940.6443,1935.5912,1930.267,1925.4427,1919.1185,1914.8971,1909.9475,1904.0729,1901.0803,1899.3743,1899.0,1899.0,1899.4877,1902.3497,1906.6239,2255.9302,2241.1667,2234.2231,2236.6091,2240.7104,2250.3887,2253.0947,2246.6895,2247.7776,2243.7346,2229.6511,2227.6245,2227.0513,2225.7188,2227.6736,2232.4424,2238.5664,2254.4685,2242.654,2220.0623,2200.3083,2178.228,2154.261,2131.345,2112.036,2095.5862,2075.8298,2057.2136,2040.4032,2023.9996,2007.6998,1993.083,1976.6876,1964.7207,1955.0723,1946.7396,1941.3732,1936.0912,1930.267,1924.6641,1915.4939,1911.4526,1908.0255};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {1904.5729,1901.1608,1899.0,1899.0,1899.0,1899.9484,1902.7496,1906.3292,2259.7405,2248.7222,2250.2524,2252.6646,2257.4504,2268.3628,2264.4119,2261.904,2263.1016,2252.6414,2244.895,2241.6292,2241.3333,2240.0327,2244.2847,2248.9116,2251.0054,2253.7434,2240.3916,2213.1282,2193.9045,2175.699,2151.5464,2132.2458,2115.5896,2099.1538,2080.8884,2061.501,2040.4093,2020.3535,2005.4429,1992.5193,1978.5958,1967.0461,1957.407,1948.9984,1941.3732,1934.72,1928.878,1922.1077,1913.2296,1909.0082,1905.5961,1902.184,1901.0,1899.0,1899.0,1899.0,1900.6869,1902.8998,1905.3119,2267.196,2267.6667,2269.197,2271.561,2277.7893,2281.2944,2276.4758,2276.5908,2275.991,2266.9622,2262.0122,2257.7607,2256.8333,2256.8333,2258.7847,2260.5747,2252.7834,2239.733,2227.6296,2203.3662,2176.973,2157.0227,2140.1143,2123.54,2108.7495,2092.2644,2072.5347,2050.557,2028.2101,2010.998,1997.2491,1985.1412,1976.5206,1965.688,1957.8458,1951.4427,1941.3789,1932.3414,1925.2948,1917.0343,1911.6262};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1906.5638,1903.1367,1901.0,1900.1608,1899.0,1899.0,1899.0756,1901.0,1902.8998,1905.0,2284.291,2285.4673,2284.797,2287.5771,2293.4656,2292.3,2288.161,2289.9797,2288.3845,2284.7212,2277.032,2272.389,2272.5698,2274.794,2280.3538,2269.874,2251.5562,2219.059,2202.2993,2191.8425,2159.815,2133.7158,2119.4854,2103.854,2093.668,2080.9976,2062.701,2036.788,2012.2396,1998.8489,1986.9076,1978.2399,1969.5619,1960.5266,1954.2119,1947.3682,1938.1481,1928.3617,1918.334,1911.7273,1907.3407,1903.2386,1901.0,1900.8813,1900.0,1899.0,1899.0,1899.3324,1901.0,1902.6221,1904.0,2297.2393,2301.248,2299.8467,2304.9243,2306.0005,2299.802,2299.919,2301.1843,2299.609,2294.199,2286.3303,2282.1667,2282.3477,2281.9717,2279.8684,2270.21,2246.0396,2207.8184,2179.7473,2165.248,2139.2478,2119.044,2098.7002,2082.6274,2072.3901,2063.1553,2042.2625,2019.6953,2001.8486,1988.8237,1979.6245,1970.9065,1961.258,1953.4142,1946.1564,1937.7206,1930.4843,1923.0157,1913.4429};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1908.5607,1903.7584,1901.0,1900.267,1900.0,1899.2778,1899.0,1899.0,1900.0,1901.0,1901.8998,1903.0867,2306.2656,2315.785,2318.197,2319.295,2316.7,2307.2668,2306.1191,2306.568,2304.1602,2295.9526,2288.179,2285.0613,2280.6313,2273.8093,2267.327,2257.6357,2240.6506,2204.2258,2165.9707,2136.2627,2122.933,2106.288,2084.8567,2065.1323,2046.8218,2029.937,2014.947,2002.806,1990.94,1980.6464,1970.8187,1960.4065,1951.5914,1943.4155,1936.1792,1928.0878,1921.7064,1914.6292,1909.9948,1905.276,1900.9683,1899.3971,1898.8208,1897.8334,1897.8334,1898.2095,1899.0,1900.0,1900.4877,1901.0,1901.8854,2311.7817,2317.285,2319.1667,2317.2817,2311.5264,2302.787,2298.1545,2294.3105,2289.9385,2285.8867,2281.9011,2275.0042,2267.5144,2258.4043,2247.7136,2238.4478,2228.4229,2192.246,2150.6707,2125.593,2103.683,2087.7224,2070.3464,2054.3945,2035.6095,2014.7147,1998.8037,1986.4912,1975.8907,1967.7035,1958.3468,1949.5217,1940.3043,1933.6377,1926.4014,1919.165,1913.2026};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1909.8512,1906.2687,1902.1344,1900.3147,1898.3971,1897.0,1897.0,1897.0,1897.5425,1898.258,1899.0756,1900.0,1901.0,1901.1213,2300.3728,2302.785,2304.197,2304.6667,2299.6587,2291.6426,2284.309,2281.043,2276.4883,2268.389,2262.9565,2259.1323,2252.894,2241.122,2227.1506,2218.5073,2208.1619,2166.6992,2134.5005,2110.0515,2083.2285,2066.2046,2053.7908,2039.2339,2020.1965,2003.6041,1988.0844,1974.5468,1961.0836,1954.7498,1945.3226,1935.8699,1931.0457,1924.9155,1917.6792,1911.8142,1909.3466,1906.0331,1902.5779,1900.9568,1899.7643,1898.375,1897.0,1897.0,1897.0,1897.0,1897.6266,1898.9486,1899.4606,1900.0,1900.9618,2283.412,2287.6772,2290.2651,2291.0,2286.259,2278.2,2272.553,2266.0227,2259.4924,2252.047,2245.3455,2239.782,2233.0457,2221.1184,2204.6943,2189.505,2170.151,2139.3794,2116.572,2088.637,2068.887,2050.837,2038.1367,2024.9838,2012.7172,1993.4325,1974.2627,1963.1671,1951.8959,1943.6989,1934.2913,1928.5366,1923.7654,1918.7351,1912.9229};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1908.8047,1905.9578,1902.5684,1900.8168,1899.6107,1898.4047,1897.6986,1897.0,1897.0,1897.0,1897.0,1897.0,1898.0,1899.0,1899.5,1900.0,2269.69,2274.347,2276.8342,2277.2778,2272.5686,2267.702,2261.7415,2254.8916,2247.2659,2237.5847,2226.4062,2219.9524,2211.2788,2197.2852,2181.796,2153.8574,2133.1335,2115.5217,2087.5083,2068.7332,2053.6985,2037.734,2021.0406,2013.898,2003.0664,1985.1412,1967.5844,1954.9912,1944.9535,1934.9159,1926.0237,1921.6582,1918.2231,1913.4993,1909.6194,1905.8025,1902.5387,1901.0026,1899.6538,1898.2646,1897.0449,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0042,1897.5161,1898.0555,1899.0173,2259.8564,2263.5625,2264.8494,2262.7244,2259.0955,2254.1333,2248.6284,2242.1238,2235.0447,2226.1414,2211.0488,2200.8555,2189.7268,2174.9912,2153.928,2133.1316,2111.8618,2081.5024,2063.2405,2051.5962,2038.9246,2023.0028,2007.6317,1998.2253,1990.7719,1974.7828,1961.5317,1947.4451,1935.463,1925.3259,1920.056,1915.0573,1912.7822};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {1909.9993,1906.0653,1902.0631,1900.2797,1899.0278,1897.8574,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.5499,1897.7324,2247.942,2252.8333,2251.4697,2248.8909,2245.1833,2240.3,2235.327,2229.6516,2222.8242,2215.1038,2201.7095,2184.3645,2170.619,2155.9307,2135.68,2114.952,2093.084,2069.1394,2049.8389,2033.5914,2020.5999,2007.2439,1995.614,1985.5889,1974.04,1966.6292,1952.2365,1938.3616,1928.3519,1921.0184,1915.1942,1911.6849,1909.4218,1906.8607,1902.7306,1900.145,1899.0763,1898.0076,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,2235.5132,2238.3662,2238.4639,2234.4485,2230.6243,2226.5667,2222.2537,2217.5935,2212.88,2204.5354,2191.6477,2175.2134,2154.3152,2136.8867,2118.9062,2099.034,2077.7283,2057.9146,2038.9851,2020.4126,2006.6056,1995.4468,1986.7983,1976.2428,1963.4734,1953.5776,1942.4791,1931.8337,1923.1633,1917.2246,1912.6526};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {1910.2405,1907.8284,1905.4163,1902.282,1900.2416,1899.0,1898.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,2223.291,2226.144,2225.728,2223.1687,2217.146,2212.0686,2207.4878,2205.6843,2203.377,2192.0134,2178.6553,2164.0977,2140.7192,2117.1296,2096.1177,2078.3975,2062.0837,2046.2067,2030.1177,2012.0792,1995.1572,1985.669,1977.0205,1968.136,1955.8489,1941.3529,1933.3097,1924.9354,1918.8195,1913.7155,1911.2081,1908.6622,1906.3839,1903.9718,1901.3602,1900.2416,1899.4578,1898.7349,1898.0,1897.1599,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,2211.9216,2215.1182,2215.558,2212.2244,2205.732,2200.9277,2197.363,2198.0757,2191.982,2178.091,2166.8926,2149.5195,2128.3035,2103.2476,2077.052,2060.933,2047.4503,2032.8463,2019.3181,2003.1929,1987.8096,1975.9978,1966.8866,1957.6251,1947.2494,1934.6306,1926.0524,1919.0281,1913.588};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {1911.8334,1909.7638,1907.3517,1904.9395,1902.5273,1901.0,1900.1666,1900.0,1900.0,1899.0,1898.0369,1898.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.1106,1897.1666,1897.5731,1898.0,1897.4266,2200.6504,2202.0166,2202.6204,2200.002,2195.8464,2191.4111,2190.852,2195.889,2180.1467,2165.6414,2151.6694,2132.9536,2114.4702,2090.9197,2068.361,2051.9082,2033.5726,2020.3842,2008.2753,1994.3378,1981.4246,1967.0319,1955.7654,1947.0925,1937.0543,1929.7507,1922.1255,1914.7872,1911.7546,1909.5983,1907.9304,1905.9072,1904.1062,1901.6941,1901.0,1901.0,1901.0,1900.6288,1899.8574,1899.1353,1898.6111,1898.0,1897.6111,1897.0,1897.5128,1897.7089,1898.0,1898.6111,1898.8008,1899.0,1899.6111,2188.7058,2190.785,2190.192,2188.7778,2186.0686,2182.287,2183.579,2191.8335,2171.8123,2153.4893,2133.8855,2116.244,2100.4912,2078.2207,2061.5034,2046.4015,2022.0337,2007.8665,1996.1013,1984.6326,1973.0913,1960.7057,1947.0812,1937.3799,1931.0758,1924.8619,1918.0789};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {1913.1112,1911.0,1909.3425,1907.9304,1905.545,1904.1559,1903.0555,1903.0555,1903.0,1902.0555,1901.0986,1901.0,1900.0123,1899.0449,1899.0,1898.0555,1898.5966,1898.8481,1899.0,1899.0555,1900.0,1900.0555,1900.9054,1901.0,2176.5,2177.5,2177.7349,2177.5,2175.4683,2173.8833,2182.3574,2182.7273,2164.4805,2144.8489,2122.882,2103.3245,2086.4624,2067.6501,2051.9321,2035.3413,2014.7003,1999.0156,1985.9412,1975.3549,1965.7063,1953.3368,1942.9094,1933.261,1925.8063,1919.973,1913.8683,1911.5834,1910.7546,1909.3425,1907.9652,1906.5183,1905.0531,1905.0,1904.5,1904.4349,1903.7289,1902.5228,1901.3168,1901.0,1900.0,1900.0,1899.9926,1899.5,1899.9197,1900.0,1900.3318,1901.0,1901.2439,1901.95,1903.156,2164.984,2166.3894,2166.7214,2165.3323,2162.9788,2167.9148,2178.5242,2174.2578,2154.251,2133.1497,2112.4968,2095.026,2073.4338,2056.7727,2040.368,2022.1814,2006.3837,1992.9103,1980.4902,1967.9529,1956.4286,1946.0651,1937.7932,1929.3721,1922.8618};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {1917.0371,1912.9766,1912.0,1910.9863,1909.9635,1908.8787,1907.9445,1906.9503,1906.9445,1905.9445,1905.8215,1904.9698,1903.947,1902.5983,1901.2091,1901.0,1900.9666,1900.9445,1900.9445,1900.9445,1901.0,1901.0,1902.8931,1903.916,1904.9388,1906.239,2155.33,2157.0557,2157.0557,2153.7466,2151.046,2160.135,2172.1526,2165.3083,2144.8022,2120.8699,2104.1917,2086.3467,2065.273,2049.7136,2030.2316,2013.0074,1998.7225,1987.662,1975.6013,1963.213,1950.4802,1939.9203,1932.9043,1926.2416,1922.2463,1917.982,1914.1577,1912.1667,1911.2935,1910.1332,1909.3889,1908.7056,1908.3889,1908.3889,1908.1096,1907.2587,1906.178,1905.3889,1904.2463,1903.3889,1902.3889,1902.3889,1902.3889,1902.3889,1902.3889,1902.6403,1904.0524,1905.0294,1905.8766,1907.2887,1908.9684,2143.8333,2144.932,2144.2146,2141.5193,2144.2893,2154.1665,2162.9824,2156.9546,2135.6367,2113.525,2098.3699,2077.2332,2057.6492,2043.0549,2024.6151,2008.1185,1993.8837,1982.1797,1969.7124,1957.6519,1946.373,1936.9785,1929.8488};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {1924.6305,1921.4031,1917.9895,1914.5087,1913.0,1912.0,1911.0,1910.7754,1910.8334,1910.8334,1910.8334,1910.1152,1908.8334,1907.9097,1906.841,1905.8334,1904.8702,1904.8334,1904.0,1903.8358,1904.356,1904.8334,1905.2095,1905.8334,1906.9089,1907.9147,1909.7332,1911.8854,2133.105,2134.856,2133.0808,2131.2083,2138.294,2149.7888,2157.3455,2149.4573,2126.8606,2108.2607,2089.5967,2071.363,2053.9102,2035.9358,2016.2601,2000.4763,1989.3058,1977.6477,1966.5033,1955.1696,1944.2063,1936.0186,1929.682,1923.8152,1921.4031,1918.991,1916.5789,1914.3982,1912.7546,1912.0,1912.0193,1912.2778,1913.2483,1912.9718,1912.0784,1910.2778,1909.2778,1908.3107,1907.2778,1907.2778,1906.2778,1906.2778,1906.2778,1906.2778,1906.5109,1907.4594,1908.2778,1909.2778,1910.2778,1911.9276,1913.5897,2122.8171,2123.026,2121.389,2121.0696,2130.3499,2143.1777,2148.5254,2136.9397,2116.8123,2102.065,2084.583,2071.363,2051.9954,2032.0469,2013.0935,1998.592,1988.078,1976.5095,1966.6274,1954.7822,1945.1548};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {1938.463,1930.4674,1924.8152,1922.4031,1919.991,1917.5789,1915.1667,1912.9319,1912.9049,1913.7725,1914.7222,1914.9705,1914.6941,1912.282,1911.7222,1911.1799,1910.033,1909.4575,1908.7837,1908.7222,1908.0,1908.0109,1908.7222,1908.7222,1909.7222,1910.7222,1911.7222,1912.3522,1913.6221,1916.2594,2106.3823,2107.4514,2109.2551,2113.1606,2124.2727,2135.8,2134.7673,2122.9321,2107.9824,2093.5093,2078.1973,2064.7847,2045.2301,2026.002,2008.3367,1994.2275,1982.117,1972.5305,1964.6068,1955.3185,1947.1118,1940.4456,1933.9775,1927.7971,1924.4031,1921.991,1919.5789,1915.639,1915.3334,1915.8812,1916.3914,1917.1666,1917.1666,1914.8607,1913.8848,1914.1666,1913.0763,1912.0,1911.1666,1910.3511,1910.1666,1910.1666,1910.0024,1910.1666,1911.1399,1912.0419,1912.8301,1914.346,1915.821,1917.2332,1919.9053,2098.0383,2098.2126,2098.2314,2104.866,2116.3281,2125.387,2122.0803,2104.6897,2091.7073,2079.895,2068.9248,2055.0862,2036.8597,2019.658,2002.1274,1989.3386,1976.0336,1969.0768,1962.4811};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1955.3911,1948.7344,1942.89,1938.0658,1931.7397,1925.6494,1922.6111,1921.6725,1920.2871,1919.3176,1920.2222,1920.8604,1920.2222,1919.2635,1917.4922,1916.6111,1915.8699,1913.4578,1912.6111,1912.6111,1912.6111,1912.0,1911.6111,1911.6111,1911.6111,1912.5128,1913.9183,1917.4968,1920.8795,1922.023,1922.2222,1923.1136,2095.6755,2087.5903,2086.3115,2097.5977,2108.2515,2114.5574,2106.7856,2088.2551,2077.7686,2069.0618,2057.5557,2041.5677,2025.5273,2011.3326,1995.9861,1984.5063,1972.0447,1965.8082,1960.696,1955.3654,1951.0544,1945.994,1941.4673,1935.3165,1926.9174,1925.1106,1923.6344,1923.0555,1923.3564,1925.0555,1925.0555,1923.6027,1922.0059,1920.7666,1919.0712,1916.8025,1914.1111,1915.0125,1915.1111,1915.1111,1913.9203,1913.0555,1913.0555,1913.0555,1914.0525,1920.9208,1926.867,1929.2222,1928.7345,1927.2168,1925.3676,2087.7349,2077.9092,2074.8862,2089.6545,2100.741,2106.65,2098.0168,2083.3638,2067.4866,2056.0093,2042.7775,2028.7048,2013.2427,2001.6503,1990.3594,1977.6731,1970.2501};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {1963.3638,1959.7516,1955.6593,1952.5516,1948.7789,1943.182,1937.3152,1934.3063,1929.982,1926.0789,1925.5,1926.7454,1928.1575,1927.4652,1925.0366,1923.5,1923.847,1922.141,1920.8699,1919.7289,1919.9545,1920.0,1920.1107,1919.0,1918.8014,1920.015,1921.2135,1923.2589,1929.754,1936.3269,1939.5,1937.7684,1933.7003,1931.844,2072.9768,2065.9233,2066.8704,2080.8767,2092.975,2099.8777,2095.9373,2081.8638,2063.09,2046.6434,2034.1936,2016.7306,2002.3302,1991.1436,1984.2374,1974.349,1969.1002,1963.5759,1959.8689,1956.434,1953.0516,1950.6194,1947.1289,1943.6486,1940.3145,1934.8708,1931.0145,1928.8889,1929.1898,1929.9445,1928.8091,1925.9733,1925.9445,1927.6,1924.2421,1923.9373,1923.8889,1923.8889,1925.2351,1925.8889,1924.6981,1925.0946,1928.8484,1931.2367,1933.5614,1939.5319,1946.1047,1950.7778,1948.3147,1940.1838,1937.239,2059.1272,2056.7612,2058.5261,2070.1565,2080.1191,2088.824,2090.297,2078.9473,2058.197,2041.9852,2027.5371,2009.9324,1995.662,1981.2537,1975.863};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {1971.7919,1967.4001,1963.5759,1960.7999,1957.4637,1954.0516,1951.2487,1950.8611,1950.276,1945.7407,1938.7688,1936.3567,1934.8796,1933.3889,1932.3889,1931.6927,1930.85,1931.1666,1930.4718,1927.6208,1928.6351,1929.3446,1929.51,1931.5332,1934.0314,1932.976,1932.7695,1937.1967,1940.9438,1942.2965,1948.3096,1954.8824,1956.0616,1951.835,1945.3893,1944.1666,2051.0388,2047.6182,2052.9243,2061.3176,2069.0847,2078.5388,2082.8445,2069.682,2050.6453,2034.5219,2020.6805,2005.9698,1991.0635,1974.2592,1971.2946,1968.2975,1965.8168,1963.3359,1960.7723,1957.9106,1954.8849,1952.8334,1952.8334,1951.9692,1950.2041,1945.482,1941.2456,1938.139,1936.4622,1934.8334,1935.8914,1937.1483,1937.6666,1935.3607,1935.265,1937.6301,1938.3391,1936.6666,1940.9442,1943.9453,1940.9836,1938.9976,1944.3783,1950.2378,1950.3392,1957.0874,1962.3846,1959.8362,1952.862,1951.5,1950.24,2045.7384,2043.8076,2046.505,2052.994,2060.4863,2069.9556,2072.2532,2061.033,2041.5879,2026.9286,2014.433,2001.2477,1985.8842};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {1972.5951,1968.7708,1964.8344,1962.4222,1961.0101,1958.8759,1956.4637,1955.2778,1954.7396,1954.2778,1953.2778,1951.6809,1949.5465,1946.7134,1942.889,1938.2421,1936.5251,1938.7141,1943.5928,1943.8628,1940.2214,1940.5472,1946.3715,1947.5688,1947.7877,1952.7423,1954.8948,1951.3359,1949.1733,1950.8783,1955.728,1958.6279,1962.9884,1962.5796,1960.6311,1962.4634,1961.0337,1960.2319,2039.1273,2038.6737,2042.0858,2045.4979,2049.1965,2057.798,2058.0808,2047.1213,2030.094,2018.1729,2007.6971,1996.1859,1980.5955,1971.1506,1966.3264,1962.1433,1960.7833,1959.4857,1957.9103,1957.0,1957.7222,1957.6221,1956.8865,1955.6709,1954.1254,1953.4354,1951.3011,1948.7317,1942.9537,1939.9193,1947.0977,1953.2368,1952.0718,1947.9457,1949.4033,1953.5746,1955.1666,1957.5326,1962.3572,1963.3881,1961.8359,1959.4054,1960.9231,1963.1666,1964.239,1966.5406,1964.2601,1968.6866,1970.3944,1968.9167,1970.3217,2032.6273,2032.7363,2037.197,2039.452,2040.7954,2045.211,2043.7793,2034.6213,2020.4875,2009.8395,2000.8804};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {1990.43,1976.1569,1968.476,1962.7946,1960.9456,1959.5334,1958.24,1958.0,1958.2561,1960.1666,1960.1666,1960.1666,1958.3025,1958.1666,1956.3243,1954.7456,1952.1946,1947.9213,1948.7578,1957.1697,1966.3953,1963.258,1956.1941,1957.0984,1960.6301,1961.5,1964.4088,1968.8666,1970.6298,1970.1185,1966.9976,1967.6816,1969.4288,1969.3334,1971.6266,1974.8269,1978.5126,1978.0936,1976.8334,1980.7692,2022.575,2025.4031,2029.9032,2031.4979,2030.8065,2031.711,2031.0155,2023.2123,2012.1547,2001.2526,1992.1794,1982.6545,1971.5608,1963.0536,1960.3889,1958.5011,1958.0,1958.0,1958.1241,1960.5363,1961.98,1963.2222,1962.75,1960.9281,1961.208,1961.2133,1958.5437,1952.9446,1951.2286,1957.0743,1967.7924,1976.0928,1972.2758,1962.8334,1963.5514,1967.0431,1969.3756,1971.7877,1975.3424,1977.6981,1975.2296,1974.1935,1976.8334,1974.8842,1973.124,1977.8785,1983.5657,1986.9089,1986.8334,1987.3442,1991.6794,2014.4049,2017.9025,2021.3081,2021.7778,2019.758,2019.6666,2019.3746,2013.4243,2004.8213};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {1995.1729,1984.58,1973.2264,1964.3386,1959.8809,1958.0,1958.0,1958.0,1958.0,1958.297,1961.566,1964.9524,1966.1111,1966.1111,1965.1666,1965.1111,1965.1016,1962.2134,1958.2686,1960.0828,1966.5652,1978.5044,1983.6582,1976.4802,1970.8221,1970.8292,1975.2485,1977.1968,1979.1766,1983.187,1983.3325,1983.1772,1985.3945,1988.081,1981.8853,1979.0704,1984.9067,1989.8114,1993.1909,1995.6544,1997.172,2002.919,2008.794,2010.1182,2012.0303,2012.0288,2009.3228,2007.1167,2007.5,2004.5228,1998.4895,1989.7546,1980.691,1971.282,1963.0455,1959.4364,1958.0,1958.0,1958.15,1959.212,1960.5621,1963.3407,1967.4226,1969.6803,1971.0,1972.0,1971.2015,1968.491,1964.4473,1961.4166,1967.7361,1977.2874,1986.6044,1987.0366,1979.8716,1976.847,1976.859,1982.8254,1986.2289,1987.4316,1990.0,1990.0,1991.5953,1993.9043,1993.9625,1987.4323,1985.8392,1991.0027,1995.3269,1999.6134,2003.9755,2008.2997,2014.5918,2006.3887,2004.9995,2004.2222,2004.1699,2001.8121,1998.413,1997.1666};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {1996.5758,1992.1051,1985.8657,1978.5739,1970.3242,1963.0455,1958.9364,1958.9445,1959.8323,1960.9055,1961.6725,1964.0062,1966.9614,1971.7858,1973.8889,1975.6615,1975.9445,1975.3475,1971.8713,1969.3655,1971.3239,1978.7036,1987.1467,1989.014,1987.0366,1983.0565,1982.872,1985.2852,1991.0936,1993.8079,1993.8334,1995.2554,1998.403,1999.8439,2000.8889,1999.8986,1993.438,1993.6171,1997.336,2002.7869,2008.929,2013.7532,2019.4272,2026.3634,2007.6635,2007.7399,1999.4462,1998.2446,1996.2566,1993.5463,1991.2222,1989.6313,1986.8274,1981.6194,1976.3839,1968.6537,1961.5615,1960.3889,1960.8646,1962.6656,1965.1943,1967.8788,1970.2426,1972.1338,1975.3373,1977.529,1979.1615,1979.2078,1978.0242,1975.3708,1974.1376,1980.9904,1989.0463,1991.9574,1991.3889,1989.0945,1987.8427,1986.6268,1993.4277,2000.8159,2003.0133,2000.2021,2001.1666,2002.5564,2003.8944,2003.5433,2000.3589,1997.3889,1999.9434,2005.2119,2011.288,2017.7068,2023.7206,2030.6439,2036.1794,2013.206,2013.3818,2006.8207,2000.7722,1996.5864};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {1989.8279,1986.1545,1984.1819,1981.3274,1976.9182,1973.3683,1966.6082,1963.6666,1962.6772,1965.1423,1968.2943,1971.7999,1975.212,1976.6666,1976.6666,1978.5721,1980.1938,1982.7954,1984.8207,1983.4058,1979.6711,1982.7281,1990.3884,2000.3743,1998.3517,1994.7638,1993.1849,1992.6666,1994.9962,2001.4192,2010.6519,2011.6666,2008.7502,2007.6666,2008.4453,2008.5077,2007.6666,2006.1241,2003.4045,2006.3451,2012.3788,2018.8269,2025.7268,2033.7965,2041.0494,2046.9573,2023.1111,2019.4459,2011.8174,2004.4506,2000.1334,1993.0426,1986.099,1983.409,1976.994,1973.5848,1971.4026,1969.3162,1967.8073,1968.5555,1970.0312,1973.3312,1978.4332,1981.5454,1982.7988,1982.4066,1982.2405,1983.4607,1986.0504,1988.0417,1984.972,1985.2893,1990.0734,2001.3236,2009.1111,2001.6411,1996.9497,1996.4116,1997.2778,1998.1675,2005.6315,2012.502,2014.2778,2013.2904,2013.5555,2013.5555,2013.4177,2012.2786,2013.8184,2010.4236,2012.4672,2019.5874,2026.0668,2032.7823,2041.7842,2049.8828,2056.238,2031.2645,2024.9717,2014.0708};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {2006.8534,2002.1117,1996.4222,1989.1859,1984.5404,1980.4385,1976.7516,1974.6172,1973.2716,1972.4445,1973.4445,1975.986,1981.2745,1986.4666,1988.9587,1988.3203,1986.1859,1983.7738,1985.1829,1988.4949,1989.2192,1987.1533,1991.9159,2000.1553,2010.9719,2014.2672,2008.2522,1998.7222,1999.9261,2001.6927,2003.5576,2009.0801,2013.8885,2016.2645,2018.3988,2018.7091,2019.4445,2020.1666,2022.3724,2023.4103,2016.9293,2020.4066,2026.851,2032.4937,2038.4144,2047.5308,2058.6936,2067.859,2037.3818,2028.9788,2017.6212,2008.1152,2003.4576,1998.6334,1992.9758,1988.8107,1986.3303,1982.503,1979.5061,1978.1339,1978.4419,1980.7938,1985.618,1991.2756,1994.7999,1996.5,1994.2516,1989.2607,1986.3334,1986.5737,1989.9393,1992.5181,1995.0969,1999.7026,2010.281,2017.3053,2017.8427,2012.3038,2007.3724,2004.5864,2005.3157,2007.6393,2010.7694,2015.5936,2019.8756,2022.2877,2023.8666,2025.4631,2026.3334,2027.0024,2024.1392,2022.9983,2030.0504,2036.336,2041.0497,2045.6638,2052.5361,2061.7659,2074.4663,2044.0092};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {2034.2885,2022.2231,2010.3726,2007.1187,2001.689,1997.3628,1993.7904,1991.2162,1986.7809,1984.395,1983.2222,1984.0093,1988.6353,1995.3959,1999.6775,2001.2222,2001.6111,1999.3628,1994.4774,1992.4645,1991.8334,1992.9949,1995.7959,2000.4017,2008.2582,2017.2605,2024.3147,2022.7316,2017.9072,2013.6787,2009.1294,2009.1573,2012.104,2015.6583,2019.4825,2024.3068,2028.7599,2031.1998,2031.8334,2032.2222,2031.2222,2031.4445,2034.2987,2041.5107,2048.5583,2052.719,2056.2068,2061.4048,2068.205,2078.0938,2048.9375,2038.5829,2027.0455,2018.395,2012.5491,2008.6334,2003.6403,1998.543,1995.1635,1992.696,1990.3395,1987.5171,1992.196,1999.3494,2003.7244,2007.0607,2007.1111,2005.399,2000.8558,1998.6176,1999.1598,1996.6951,1996.0555,1998.2609,2005.5542,2015.1385,2023.3978,2028.8331,2028.7588,2025.6759,2021.0096,2012.232,2013.8491,2016.723,2020.5472,2023.427,2030.738,2036.0656,2038.1111,2039.1111,2037.976,2036.2557,2040.3236,2048.6147,2055.003,2059.9055,2066.361,2070.3533,2074.2532,2080.0718};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {2086.491,2050.6758,2041.5273,2033.909,2027.6727,2022.9364,2017.0834,2011.6425,2006.0228,2000.9955,1998.5,1997.6727,1997.7394,2002.6287,2008.0953,2011.9757,2012.5,2011.85,2009.4319,2006.3759,2004.1956,2002.5258,1998.4592,1998.2727,2003.239,2011.8876,2020.536,2030.6844,2037.1665,2041.1227,2038.8563,2030.1173,2020.5366,2018.4469,2021.4589,2026.6542,2032.0651,2035.3557,2040.9088,2043.3666,2045.2787,2046.0,2046.1029,2053.075,2062.5679,2069.0178,2076.0027,2080.1636,2082.5757,2085.7192,2093.1494,2098.468,2053.081,2044.8197,2041.2163,2036.0029,2031.1243,2026.2574,2019.4758,2012.1162,2006.8303,2004.8889,2004.8334,2008.2009,2012.4655,2013.8925,2014.9153,2014.9445,2014.6445,2012.2324,2011.8889,2009.8461,2005.0476,2001.8689,2004.3787,2010.3876,2018.2433,2027.8783,2039.9155,2050.0645,2056.6707,2046.5825,2033.4612,2021.0654,2021.8383,2027.0402,2035.2538,2039.0118,2041.918,2047.7422,2050.1794,2052.612,2054.0134,2056.9836,2065.7822,2075.407,2083.1843,2088.2249,2091.4226,2094.8691};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {2100.13,2107.3662,2113.2905,2058.6597,2053.319,2050.0251,2047.6132,2042.4865,2037.0222,2029.0193,2020.192,2012.5537,2012.5555,2011.6227,2015.2736,2020.9537,2019.7142,2018.3889,2017.5011,2017.2056,2015.9537,2014.3145,2009.9557,2008.8093,2008.3889,2010.851,2017.721,2025.9431,2036.2117,2047.4623,2057.6199,2059.7732,2047.7126,2033.4974,2023.6483,2027.5654,2035.8153,2044.9291,2044.3889,2046.8623,2054.0298,2058.922,2061.3342,2064.2095,2068.9075,2078.4026,2088.4868,2095.4622,2100.836,2104.6602,2109.4382,2114.1853,2121.094,2128.8042,2066.6763,2063.1956,2060.6365,2057.3909,2054.162,2047.0334,2039.4814,2030.5607,2026.1661,2025.1666,2021.6439,2023.0186,2025.8334,2021.9364,2021.6666,2020.9268,2020.4167,2020.4268,2018.8976,2015.7197,2014.5,2012.9672,2016.8558,2025.0851,2034.2235,2042.7117,2051.0967,2058.6387,2056.5564,2047.4272,2033.8376,2030.9817,2034.2876,2043.965,2050.5515,2048.0503,2053.9602,2061.5222,2067.1719,2071.112,2078.3738,2084.1396,2089.3809,2098.5645,2108.6575,2114.879};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {2120.2163,2124.1511,2128.9753,2135.8494,2141.4785,2075.8462,2074.0784,2073.111,2072.8333,2069.0562,2063.1982,2055.279,2046.745,2042.2184,2038.1362,2034.4567,2030.0447,2029.266,2027.054,2028.3889,2027.2233,2024.1111,2025.021,2027.3889,2024.8895,2019.9595,2018.3779,2021.6084,2029.2433,2038.6653,2047.2958,2051.4944,2053.6018,2053.4412,2047.5671,2034.2971,2036.7968,2041.621,2049.1675,2053.9917,2057.852,2064.738,2070.2976,2075.946,2083.2256,2090.5457,2094.8813,2099.6968,2108.701,2118.1902,2127.3943,2134.9001,2140.0747,2144.1543,2149.6438,2154.701,2088.493,2083.7708,2082.0193,2081.2083,2078.7136,2074.8464,2069.303,2063.5935,2060.3257,2052.2107,2042.8097,2035.9274,2036.6884,2041.397,2041.8577,2037.8354,2034.8889,2035.0867,2038.077,2032.6342,2024.562,2021.5446,2024.0529,2033.05,2042.1097,2049.009,2050.4211,2051.3982,2048.7651,2044.8306,2038.6339,2043.2639,2048.8777,2055.0845,2059.6812,2066.2793,2074.5159,2080.7976,2086.785,2093.2249,2101.546,2107.817,2112.641,2117.2756};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {2124.0344,2137.3801,2146.0635,2152.019,2157.2166,2163.3384,2167.42,2101.009,2093.5288,2090.1365,2088.548,2085.791,2081.9668,2077.309,2073.2424,2072.6636,2063.4402,2050.5305,2045.4274,2047.2877,2053.974,2058.5405,2049.4673,2045.6666,2045.6666,2044.1493,2034.3911,2027.2699,2024.6938,2029.6512,2036.8568,2044.4547,2049.174,2051.4211,2050.3057,2047.7546,2043.9042,2045.4725,2050.377,2056.0325,2062.4177,2068.6543,2076.354,2085.384,2094.0146,2101.8997,2105.7786,2111.239,2119.4092,2125.8657,2129.427,2132.5386,2141.7996,2153.098,2160.8933,2168.2964,2175.5496,2180.312,2109.9243,2104.162,2098.3838,2094.8909,2093.4788,2090.3796,2085.6545,2084.4722,2082.4385,2074.9539,2060.241,2055.205,2055.096,2059.374,2063.426,2060.378,2055.5334,2055.8796,2049.1309,2033.5997,2029.6426,2030.9735,2033.2953,2040.1654,2046.6481,2050.0056,2052.2573,2050.3335,2047.7546,2046.6111,2047.8624,2055.6672,2062.515,2069.632,2078.3667,2087.9146,2097.8875,2108.4844,2115.7886,2119.4453,2120.7095,2129.0903};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {2139.1096,2144.871,2146.993,2149.656,2158.5396,2169.7468,2180.4941,2189.916,2195.3674,2113.6436,2110.9375,2108.0244,2102.2295,2099.6653,2097.2463,2092.5193,2087.4873,2086.0554,2083.4087,2072.0764,2064.7434,2062.5151,2063.2903,2068.5383,2069.3848,2062.6057,2060.9763,2049.089,2036.4764,2033.0585,2035.4717,2036.2096,2042.6099,2048.6301,2051.064,2052.4534,2051.38,2048.7966,2047.7495,2054.3755,2062.0667,2069.8481,2079.7905,2090.0945,2100.211,2113.3914,2122.0955,2129.7,2133.1553,2136.569,2141.6223,2152.3933,2158.816,2160.3333,2160.5847,2166.9504,2177.5405,2189.089,2199.816,2207.4958,2116.088,2112.3818,2110.4697,2105.644,2100.6455,2097.2334,2093.6426,2089.9092,2087.497,2085.585,2078.7773,2072.5212,2068.8486,2067.5,2071.2136,2073.388,2065.1501,2055.4397,2045.1274,2039.4637,2037.5,2042.5408,2044.1136,2045.2771,2049.3953,2052.0044,2053.7104,2053.5835,2052.5,2055.315,2061.7087,2069.4268,2079.969,2090.2239,2103.1675,2115.4556,2123.6692,2133.8176,2141.0996,2147.9465};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {2152.6907,2154.6028,2165.5825,2173.6406,2175.4197,2176.1257,2180.9905,2189.189,2196.451,2207.0493,2216.9358,2116.588,2111.931,2108.0244,2103.1738,2097.7566,2095.2888,2092.8213,2090.4092,2087.997,2085.585,2082.2996,2075.692,2072.293,2068.8843,2067.6396,2070.1604,2060.9114,2048.7832,2044.8958,2044.3525,2044.7817,2048.305,2048.9016,2049.8992,2051.5413,2053.9534,2055.9443,2057.7314,2058.1897,2061.2039,2069.108,2079.6758,2090.353,2104.7527,2119.257,2127.9897,2135.349,2141.7395,2149.9329,2157.1692,2164.3394,2168.8945,2176.798,2186.5527,2189.5525,2189.9736,2193.7126,2202.8933,2209.1582,2215.466,2226.632,2115.199,2109.7637,2106.4697,2100.9858,2096.0344,2094.5315,2092.8213,2090.4092,2087.9988,2085.8386,2082.3455,2077.9102,2074.6018,2071.3005,2067.5432,2062.8354,2058.1392,2049.5295,2048.8538,2048.033,2047.3373,2050.5007,2052.5505,2053.4607,2055.1426,2056.398,2058.1638,2059.713,2063.6575,2069.4817,2079.2654,2090.6697,2104.979,2119.931,2130.8167,2140.9841,2150.029,2154.8533};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {2158.4536,2164.8916,2173.128,2179.9958,2187.0078,2199.0234,2207.2966,2207.1797,2208.9968,2214.7822,2221.531,2226.3552,2232.4016,2115.1763,2111.6956,2109.7449,2105.8298,2100.253,2096.0667,2093.8213,2091.3105,2087.9944,2084.7515,2082.2017,2078.7207,2075.639,2072.9258,2067.1765,2060.391,2056.4668,2052.9546,2051.8333,2051.2197,2050.6667,2054.0874,2056.606,2057.8333,2058.4973,2059.6682,2061.158,2065.3333,2070.1575,2079.454,2089.6812,2104.3718,2118.6357,2130.5571,2142.1587,2154.5425,2163.627,2169.7422,2172.3665,2175.038,2181.2312,2190.7449,2201.0576,2209.9463,2218.7112,2221.1667,2222.6636,2227.1638,2232.3088,2237.133,2241.0718,2117.5718,2115.4375,2113.0251,2110.3354,2104.8464,2099.7444,2095.099,2092.687,2088.2717,2083.7473,2081.4504,2079.0383,2076.6262,2074.1965,2068.8992,2059.5332,2057.2778,2056.3577,2055.2778,2055.2778,2056.2405,2058.6384,2061.0505,2062.5557,2062.7214,2064.5645,2066.5586,2070.222,2078.338,2089.4631,2101.1848,2116.1453,2128.5803,2141.2246,2155.4978,2165.668};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {2176.3782,2183.5627,2186.7686,2187.883,2191.0989,2201.4033,2212.4448,2221.0974,2228.9512,2233.0576,2237.3647,2241.7422,2245.012,2249.4663,2251.3022,2120.5261,2119.3591,2116.914,2112.8374,2108.9148,2103.9111,2098.1365,2094.5405,2090.7163,2085.892,2082.895,2080.483,2078.3486,2074.9365,2070.4407,2064.422,2061.1445,2059.0103,2058.7222,2058.206,2058.6707,2061.4434,2065.217,2067.3513,2068.4443,2069.451,2070.8655,2077.268,2087.1482,2098.1763,2112.565,2125.4414,2138.2517,2152.5317,2164.5576,2175.8755,2186.6665,2195.0173,2201.2424,2205.5564,2207.1086,2211.865,2222.2266,2232.011,2241.0127,2247.1138,2251.7537,2255.4636,2260.3833,2264.2053,2265.0215,2124.5784,2123.215,2121.106,2116.439,2112.6243,2108.5667,2104.1724,2099.3865,2094.3298,2089.9905,2084.679,2082.1667,2080.6238,2078.2168,2074.3818,2070.5576,2067.0334,2064.6213,2063.3127,2061.1833,2061.4397,2065.9944,2069.106,2072.7156,2075.5,2073.8499,2080.8599,2085.4722,2095.4814,2107.6206,2120.5261,2132.9084,2146.863,2160.863};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {2172.0903,2184.1292,2194.7595,2205.3176,2212.2942,2219.1692,2223.2227,2224.7695,2229.7417,2240.731,2251.0237,2259.7542,2266.327,2271.9216,2275.321,2277.7332,2276.0427};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.02,0.00391,0.04,0.00391,0.06,0.00391,0.08,0.00391,0.1,0.00391,0.12,0.00391,0.14,0.00391,0.16,0.00391,0.18,0.00391,0.2,0.00391,0.22,0.00391,0.24,0.00391,0.26,0.00391,0.28,0.00391,0.3,0.00391,0.32,0.00391,0.34,0.00391,0.36,0.00391,0.38,0.00391,0.4,0.00391,0.42,0.00391,0.44,0.00391,0.46,0.00391,0.48,0.00391,0.5,0.00391,0.52,0.00391,0.54,0.00391,0.56,0.00391,0.58,0.00391,0.6,0.00391,0.62,0.00391,0.64,0.00391,0.66,0.00391,0.68,0.00391,0.7,0.00391,0.72,0.00391,0.74,0.00391,0.76,0.00391,0.78,0.00391,0.8,0.00391,0.82,0.00391,0.84,0.00391,0.86,0.00391,0.88,0.00391,0.9,0.00391,0.92,0.00391,0.94,0.00391,0.96,0.00391,0.98,0.00391,0.99609,0.00391,0.00391,0.01515,0.02,0.01515,0.04,0.01515,0.06,0.01515,0.08,0.01515,0.1,0.01515,0.12,0.01515,0.14,0.01515,0.16,0.01515,0.18,0.01515,0.2,0.01515,0.22,0.01515,0.24,0.01515,0.26,0.01515,0.28,0.01515,0.3,0.01515,0.32,0.01515,0.34,0.01515,0.36,0.01515,0.38,0.01515,0.4,0.01515,0.42,0.01515,0.44,0.01515,0.46,0.01515,0.48,0.01515,0.5,0.01515,0.52,0.01515,0.54,0.01515,0.56,0.01515,0.58,0.01515,0.6,0.01515,0.62,0.01515,0.64,0.01515,0.66,0.01515,0.68,0.01515,0.7,0.01515,0.72,0.01515,0.74,0.01515,0.76,0.01515,0.78,0.01515,0.8,0.01515,0.82,0.01515,0.84,0.01515,0.86,0.01515,0.88,0.01515,0.9,0.01515,0.92,0.01515,0.94,0.01515,0.96,0.01515};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.98,0.01515,0.99609,0.01515,0.00391,0.0303,0.02,0.0303,0.04,0.0303,0.06,0.0303,0.08,0.0303,0.1,0.0303,0.12,0.0303,0.14,0.0303,0.16,0.0303,0.18,0.0303,0.2,0.0303,0.22,0.0303,0.24,0.0303,0.26,0.0303,0.28,0.0303,0.3,0.0303,0.32,0.0303,0.34,0.0303,0.36,0.0303,0.38,0.0303,0.4,0.0303,0.42,0.0303,0.44,0.0303,0.46,0.0303,0.48,0.0303,0.5,0.0303,0.52,0.0303,0.54,0.0303,0.56,0.0303,0.58,0.0303,0.6,0.0303,0.62,0.0303,0.64,0.0303,0.66,0.0303,0.68,0.0303,0.7,0.0303,0.72,0.0303,0.74,0.0303,0.76,0.0303,0.78,0.0303,0.8,0.0303,0.82,0.0303,0.84,0.0303,0.86,0.0303,0.88,0.0303,0.9,0.0303,0.92,0.0303,0.94,0.0303,0.96,0.0303,0.98,0.0303,0.99609,0.0303,0.00391,0.04545,0.02,0.04545,0.04,0.04545,0.06,0.04545,0.08,0.04545,0.1,0.04545,0.12,0.04545,0.14,0.04545,0.16,0.04545,0.18,0.04545,0.2,0.04545,0.22,0.04545,0.24,0.04545,0.26,0.04545,0.28,0.04545,0.3,0.04545,0.32,0.04545,0.34,0.04545,0.36,0.04545,0.38,0.04545,0.4,0.04545,0.42,0.04545,0.44,0.04545,0.46,0.04545,0.48,0.04545,0.5,0.04545,0.52,0.04545,0.54,0.04545,0.56,0.04545,0.58,0.04545,0.6,0.04545,0.62,0.04545,0.64,0.04545,0.66,0.04545,0.68,0.04545,0.7,0.04545,0.72,0.04545,0.74,0.04545,0.76,0.04545,0.78,0.04545,0.8,0.04545,0.82,0.04545,0.84,0.04545,0.86,0.04545,0.88,0.04545,0.9,0.04545,0.92,0.04545};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.94,0.04545,0.96,0.04545,0.98,0.04545,0.99609,0.04545,0.00391,0.06061,0.02,0.06061,0.04,0.06061,0.06,0.06061,0.08,0.06061,0.1,0.06061,0.12,0.06061,0.14,0.06061,0.16,0.06061,0.18,0.06061,0.2,0.06061,0.22,0.06061,0.24,0.06061,0.26,0.06061,0.28,0.06061,0.3,0.06061,0.32,0.06061,0.34,0.06061,0.36,0.06061,0.38,0.06061,0.4,0.06061,0.42,0.06061,0.44,0.06061,0.46,0.06061,0.48,0.06061,0.5,0.06061,0.52,0.06061,0.54,0.06061,0.56,0.06061,0.58,0.06061,0.6,0.06061,0.62,0.06061,0.64,0.06061,0.66,0.06061,0.68,0.06061,0.7,0.06061,0.72,0.06061,0.74,0.06061,0.76,0.06061,0.78,0.06061,0.8,0.06061,0.82,0.06061,0.84,0.06061,0.86,0.06061,0.88,0.06061,0.9,0.06061,0.92,0.06061,0.94,0.06061,0.96,0.06061,0.98,0.06061,0.99609,0.06061,0.00391,0.07576,0.02,0.07576,0.04,0.07576,0.06,0.07576,0.08,0.07576,0.1,0.07576,0.12,0.07576,0.14,0.07576,0.16,0.07576,0.18,0.07576,0.2,0.07576,0.22,0.07576,0.24,0.07576,0.26,0.07576,0.28,0.07576,0.3,0.07576,0.32,0.07576,0.34,0.07576,0.36,0.07576,0.38,0.07576,0.4,0.07576,0.42,0.07576,0.44,0.07576,0.46,0.07576,0.48,0.07576,0.5,0.07576,0.52,0.07576,0.54,0.07576,0.56,0.07576,0.58,0.07576,0.6,0.07576,0.62,0.07576,0.64,0.07576,0.66,0.07576,0.68,0.07576,0.7,0.07576,0.72,0.07576,0.74,0.07576,0.76,0.07576,0.78,0.07576,0.8,0.07576,0.82,0.07576,0.84,0.07576,0.86,0.07576,0.88,0.07576};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.9,0.07576,0.92,0.07576,0.94,0.07576,0.96,0.07576,0.98,0.07576,0.99609,0.07576,0.00391,0.09091,0.02,0.09091,0.04,0.09091,0.06,0.09091,0.08,0.09091,0.1,0.09091,0.12,0.09091,0.14,0.09091,0.16,0.09091,0.18,0.09091,0.2,0.09091,0.22,0.09091,0.24,0.09091,0.26,0.09091,0.28,0.09091,0.3,0.09091,0.32,0.09091,0.34,0.09091,0.36,0.09091,0.38,0.09091,0.4,0.09091,0.42,0.09091,0.44,0.09091,0.46,0.09091,0.48,0.09091,0.5,0.09091,0.52,0.09091,0.54,0.09091,0.56,0.09091,0.58,0.09091,0.6,0.09091,0.62,0.09091,0.64,0.09091,0.66,0.09091,0.68,0.09091,0.7,0.09091,0.72,0.09091,0.74,0.09091,0.76,0.09091,0.78,0.09091,0.8,0.09091,0.82,0.09091,0.84,0.09091,0.86,0.09091,0.88,0.09091,0.9,0.09091,0.92,0.09091,0.94,0.09091,0.96,0.09091,0.98,0.09091,0.99609,0.09091,0.00391,0.10606,0.02,0.10606,0.04,0.10606,0.06,0.10606,0.08,0.10606,0.1,0.10606,0.12,0.10606,0.14,0.10606,0.16,0.10606,0.18,0.10606,0.2,0.10606,0.22,0.10606,0.24,0.10606,0.26,0.10606,0.28,0.10606,0.3,0.10606,0.32,0.10606,0.34,0.10606,0.36,0.10606,0.38,0.10606,0.4,0.10606,0.42,0.10606,0.44,0.10606,0.46,0.10606,0.48,0.10606,0.5,0.10606,0.52,0.10606,0.54,0.10606,0.56,0.10606,0.58,0.10606,0.6,0.10606,0.62,0.10606,0.64,0.10606,0.66,0.10606,0.68,0.10606,0.7,0.10606,0.72,0.10606,0.74,0.10606,0.76,0.10606,0.78,0.10606,0.8,0.10606,0.82,0.10606,0.84,0.10606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.86,0.10606,0.88,0.10606,0.9,0.10606,0.92,0.10606,0.94,0.10606,0.96,0.10606,0.98,0.10606,0.99609,0.10606,0.00391,0.12121,0.02,0.12121,0.04,0.12121,0.06,0.12121,0.08,0.12121,0.1,0.12121,0.12,0.12121,0.14,0.12121,0.16,0.12121,0.18,0.12121,0.2,0.12121,0.22,0.12121,0.24,0.12121,0.26,0.12121,0.28,0.12121,0.3,0.12121,0.32,0.12121,0.34,0.12121,0.36,0.12121,0.38,0.12121,0.4,0.12121,0.42,0.12121,0.44,0.12121,0.46,0.12121,0.48,0.12121,0.5,0.12121,0.52,0.12121,0.54,0.12121,0.56,0.12121,0.58,0.12121,0.6,0.12121,0.62,0.12121,0.64,0.12121,0.66,0.12121,0.68,0.12121,0.7,0.12121,0.72,0.12121,0.74,0.12121,0.76,0.12121,0.78,0.12121,0.8,0.12121,0.82,0.12121,0.84,0.12121,0.86,0.12121,0.88,0.12121,0.9,0.12121,0.92,0.12121,0.94,0.12121,0.96,0.12121,0.98,0.12121,0.99609,0.12121,0.00391,0.13636,0.02,0.13636,0.04,0.13636,0.06,0.13636,0.08,0.13636,0.1,0.13636,0.12,0.13636,0.14,0.13636,0.16,0.13636,0.18,0.13636,0.2,0.13636,0.22,0.13636,0.24,0.13636,0.26,0.13636,0.28,0.13636,0.3,0.13636,0.32,0.13636,0.34,0.13636,0.36,0.13636,0.38,0.13636,0.4,0.13636,0.42,0.13636,0.44,0.13636,0.46,0.13636,0.48,0.13636,0.5,0.13636,0.52,0.13636,0.54,0.13636,0.56,0.13636,0.58,0.13636,0.6,0.13636,0.62,0.13636,0.64,0.13636,0.66,0.13636,0.68,0.13636,0.7,0.13636,0.72,0.13636,0.74,0.13636,0.76,0.13636,0.78,0.13636,0.8,0.13636};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.82,0.13636,0.84,0.13636,0.86,0.13636,0.88,0.13636,0.9,0.13636,0.92,0.13636,0.94,0.13636,0.96,0.13636,0.98,0.13636,0.99609,0.13636,0.00391,0.15152,0.02,0.15152,0.04,0.15152,0.06,0.15152,0.08,0.15152,0.1,0.15152,0.12,0.15152,0.14,0.15152,0.16,0.15152,0.18,0.15152,0.2,0.15152,0.22,0.15152,0.24,0.15152,0.26,0.15152,0.28,0.15152,0.3,0.15152,0.32,0.15152,0.34,0.15152,0.36,0.15152,0.38,0.15152,0.4,0.15152,0.42,0.15152,0.44,0.15152,0.46,0.15152,0.48,0.15152,0.5,0.15152,0.52,0.15152,0.54,0.15152,0.56,0.15152,0.58,0.15152,0.6,0.15152,0.62,0.15152,0.64,0.15152,0.66,0.15152,0.68,0.15152,0.7,0.15152,0.72,0.15152,0.74,0.15152,0.76,0.15152,0.78,0.15152,0.8,0.15152,0.82,0.15152,0.84,0.15152,0.86,0.15152,0.88,0.15152,0.9,0.15152,0.92,0.15152,0.94,0.15152,0.96,0.15152,0.98,0.15152,0.99609,0.15152,0.00391,0.16667,0.02,0.16667,0.04,0.16667,0.06,0.16667,0.08,0.16667,0.1,0.16667,0.12,0.16667,0.14,0.16667,0.16,0.16667,0.18,0.16667,0.2,0.16667,0.22,0.16667,0.24,0.16667,0.26,0.16667,0.28,0.16667,0.3,0.16667,0.32,0.16667,0.34,0.16667,0.36,0.16667,0.38,0.16667,0.4,0.16667,0.42,0.16667,0.44,0.16667,0.46,0.16667,0.48,0.16667,0.5,0.16667,0.52,0.16667,0.54,0.16667,0.56,0.16667,0.58,0.16667,0.6,0.16667,0.62,0.16667,0.64,0.16667,0.66,0.16667,0.68,0.16667,0.7,0.16667,0.72,0.16667,0.74,0.16667,0.76,0.16667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.78,0.16667,0.8,0.16667,0.82,0.16667,0.84,0.16667,0.86,0.16667,0.88,0.16667,0.9,0.16667,0.92,0.16667,0.94,0.16667,0.96,0.16667,0.98,0.16667,0.99609,0.16667,0.00391,0.18182,0.02,0.18182,0.04,0.18182,0.06,0.18182,0.08,0.18182,0.1,0.18182,0.12,0.18182,0.14,0.18182,0.16,0.18182,0.18,0.18182,0.2,0.18182,0.22,0.18182,0.24,0.18182,0.26,0.18182,0.28,0.18182,0.3,0.18182,0.32,0.18182,0.34,0.18182,0.36,0.18182,0.38,0.18182,0.4,0.18182,0.42,0.18182,0.44,0.18182,0.46,0.18182,0.48,0.18182,0.5,0.18182,0.52,0.18182,0.54,0.18182,0.56,0.18182,0.58,0.18182,0.6,0.18182,0.62,0.18182,0.64,0.18182,0.66,0.18182,0.68,0.18182,0.7,0.18182,0.72,0.18182,0.74,0.18182,0.76,0.18182,0.78,0.18182,0.8,0.18182,0.82,0.18182,0.84,0.18182,0.86,0.18182,0.88,0.18182,0.9,0.18182,0.92,0.18182,0.94,0.18182,0.96,0.18182,0.98,0.18182,0.99609,0.18182,0.00391,0.19697,0.02,0.19697,0.04,0.19697,0.06,0.19697,0.08,0.19697,0.1,0.19697,0.12,0.19697,0.14,0.19697,0.16,0.19697,0.18,0.19697,0.2,0.19697,0.22,0.19697,0.24,0.19697,0.26,0.19697,0.28,0.19697,0.3,0.19697,0.32,0.19697,0.34,0.19697,0.36,0.19697,0.38,0.19697,0.4,0.19697,0.42,0.19697,0.44,0.19697,0.46,0.19697,0.48,0.19697,0.5,0.19697,0.52,0.19697,0.54,0.19697,0.56,0.19697,0.58,0.19697,0.6,0.19697,0.62,0.19697,0.64,0.19697,0.66,0.19697,0.68,0.19697,0.7,0.19697,0.72,0.19697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.74,0.19697,0.76,0.19697,0.78,0.19697,0.8,0.19697,0.82,0.19697,0.84,0.19697,0.86,0.19697,0.88,0.19697,0.9,0.19697,0.92,0.19697,0.94,0.19697,0.96,0.19697,0.98,0.19697,0.99609,0.19697,0.00391,0.21212,0.02,0.21212,0.04,0.21212,0.06,0.21212,0.08,0.21212,0.1,0.21212,0.12,0.21212,0.14,0.21212,0.16,0.21212,0.18,0.21212,0.2,0.21212,0.22,0.21212,0.24,0.21212,0.26,0.21212,0.28,0.21212,0.3,0.21212,0.32,0.21212,0.34,0.21212,0.36,0.21212,0.38,0.21212,0.4,0.21212,0.42,0.21212,0.44,0.21212,0.46,0.21212,0.48,0.21212,0.5,0.21212,0.52,0.21212,0.54,0.21212,0.56,0.21212,0.58,0.21212,0.6,0.21212,0.62,0.21212,0.64,0.21212,0.66,0.21212,0.68,0.21212,0.7,0.21212,0.72,0.21212,0.74,0.21212,0.76,0.21212,0.78,0.21212,0.8,0.21212,0.82,0.21212,0.84,0.21212,0.86,0.21212,0.88,0.21212,0.9,0.21212,0.92,0.21212,0.94,0.21212,0.96,0.21212,0.98,0.21212,0.99609,0.21212,0.00391,0.22727,0.02,0.22727,0.04,0.22727,0.06,0.22727,0.08,0.22727,0.1,0.22727,0.12,0.22727,0.14,0.22727,0.16,0.22727,0.18,0.22727,0.2,0.22727,0.22,0.22727,0.24,0.22727,0.26,0.22727,0.28,0.22727,0.3,0.22727,0.32,0.22727,0.34,0.22727,0.36,0.22727,0.38,0.22727,0.4,0.22727,0.42,0.22727,0.44,0.22727,0.46,0.22727,0.48,0.22727,0.5,0.22727,0.52,0.22727,0.54,0.22727,0.56,0.22727,0.58,0.22727,0.6,0.22727,0.62,0.22727,0.64,0.22727,0.66,0.22727,0.68,0.22727};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.7,0.22727,0.72,0.22727,0.74,0.22727,0.76,0.22727,0.78,0.22727,0.8,0.22727,0.82,0.22727,0.84,0.22727,0.86,0.22727,0.88,0.22727,0.9,0.22727,0.92,0.22727,0.94,0.22727,0.96,0.22727,0.98,0.22727,0.99609,0.22727,0.00391,0.24242,0.02,0.24242,0.04,0.24242,0.06,0.24242,0.08,0.24242,0.1,0.24242,0.12,0.24242,0.14,0.24242,0.16,0.24242,0.18,0.24242,0.2,0.24242,0.22,0.24242,0.24,0.24242,0.26,0.24242,0.28,0.24242,0.3,0.24242,0.32,0.24242,0.34,0.24242,0.36,0.24242,0.38,0.24242,0.4,0.24242,0.42,0.24242,0.44,0.24242,0.46,0.24242,0.48,0.24242,0.5,0.24242,0.52,0.24242,0.54,0.24242,0.56,0.24242,0.58,0.24242,0.6,0.24242,0.62,0.24242,0.64,0.24242,0.66,0.24242,0.68,0.24242,0.7,0.24242,0.72,0.24242,0.74,0.24242,0.76,0.24242,0.78,0.24242,0.8,0.24242,0.82,0.24242,0.84,0.24242,0.86,0.24242,0.88,0.24242,0.9,0.24242,0.92,0.24242,0.94,0.24242,0.96,0.24242,0.98,0.24242,0.99609,0.24242,0.00391,0.25758,0.02,0.25758,0.04,0.25758,0.06,0.25758,0.08,0.25758,0.1,0.25758,0.12,0.25758,0.14,0.25758,0.16,0.25758,0.18,0.25758,0.2,0.25758,0.22,0.25758,0.24,0.25758,0.26,0.25758,0.28,0.25758,0.3,0.25758,0.32,0.25758,0.34,0.25758,0.36,0.25758,0.38,0.25758,0.4,0.25758,0.42,0.25758,0.44,0.25758,0.46,0.25758,0.48,0.25758,0.5,0.25758,0.52,0.25758,0.54,0.25758,0.56,0.25758,0.58,0.25758,0.6,0.25758,0.62,0.25758,0.64,0.25758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.66,0.25758,0.68,0.25758,0.7,0.25758,0.72,0.25758,0.74,0.25758,0.76,0.25758,0.78,0.25758,0.8,0.25758,0.82,0.25758,0.84,0.25758,0.86,0.25758,0.88,0.25758,0.9,0.25758,0.92,0.25758,0.94,0.25758,0.96,0.25758,0.98,0.25758,0.99609,0.25758,0.00391,0.27273,0.02,0.27273,0.04,0.27273,0.06,0.27273,0.08,0.27273,0.1,0.27273,0.12,0.27273,0.14,0.27273,0.16,0.27273,0.18,0.27273,0.2,0.27273,0.22,0.27273,0.24,0.27273,0.26,0.27273,0.28,0.27273,0.3,0.27273,0.32,0.27273,0.34,0.27273,0.36,0.27273,0.38,0.27273,0.4,0.27273,0.42,0.27273,0.44,0.27273,0.46,0.27273,0.48,0.27273,0.5,0.27273,0.52,0.27273,0.54,0.27273,0.56,0.27273,0.58,0.27273,0.6,0.27273,0.62,0.27273,0.64,0.27273,0.66,0.27273,0.68,0.27273,0.7,0.27273,0.72,0.27273,0.74,0.27273,0.76,0.27273,0.78,0.27273,0.8,0.27273,0.82,0.27273,0.84,0.27273,0.86,0.27273,0.88,0.27273,0.9,0.27273,0.92,0.27273,0.94,0.27273,0.96,0.27273,0.98,0.27273,0.99609,0.27273,0.00391,0.28788,0.02,0.28788,0.04,0.28788,0.06,0.28788,0.08,0.28788,0.1,0.28788,0.12,0.28788,0.14,0.28788,0.16,0.28788,0.18,0.28788,0.2,0.28788,0.22,0.28788,0.24,0.28788,0.26,0.28788,0.28,0.28788,0.3,0.28788,0.32,0.28788,0.34,0.28788,0.36,0.28788,0.38,0.28788,0.4,0.28788,0.42,0.28788,0.44,0.28788,0.46,0.28788,0.48,0.28788,0.5,0.28788,0.52,0.28788,0.54,0.28788,0.56,0.28788,0.58,0.28788,0.6,0.28788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.62,0.28788,0.64,0.28788,0.66,0.28788,0.68,0.28788,0.7,0.28788,0.72,0.28788,0.74,0.28788,0.76,0.28788,0.78,0.28788,0.8,0.28788,0.82,0.28788,0.84,0.28788,0.86,0.28788,0.88,0.28788,0.9,0.28788,0.92,0.28788,0.94,0.28788,0.96,0.28788,0.98,0.28788,0.99609,0.28788,0.00391,0.30303,0.02,0.30303,0.04,0.30303,0.06,0.30303,0.08,0.30303,0.1,0.30303,0.12,0.30303,0.14,0.30303,0.16,0.30303,0.18,0.30303,0.2,0.30303,0.22,0.30303,0.24,0.30303,0.26,0.30303,0.28,0.30303,0.3,0.30303,0.32,0.30303,0.34,0.30303,0.36,0.30303,0.38,0.30303,0.4,0.30303,0.42,0.30303,0.44,0.30303,0.46,0.30303,0.48,0.30303,0.5,0.30303,0.52,0.30303,0.54,0.30303,0.56,0.30303,0.58,0.30303,0.6,0.30303,0.62,0.30303,0.64,0.30303,0.66,0.30303,0.68,0.30303,0.7,0.30303,0.72,0.30303,0.74,0.30303,0.76,0.30303,0.78,0.30303,0.8,0.30303,0.82,0.30303,0.84,0.30303,0.86,0.30303,0.88,0.30303,0.9,0.30303,0.92,0.30303,0.94,0.30303,0.96,0.30303,0.98,0.30303,0.99609,0.30303,0.00391,0.31818,0.02,0.31818,0.04,0.31818,0.06,0.31818,0.08,0.31818,0.1,0.31818,0.12,0.31818,0.14,0.31818,0.16,0.31818,0.18,0.31818,0.2,0.31818,0.22,0.31818,0.24,0.31818,0.26,0.31818,0.28,0.31818,0.3,0.31818,0.32,0.31818,0.34,0.31818,0.36,0.31818,0.38,0.31818,0.4,0.31818,0.42,0.31818,0.44,0.31818,0.46,0.31818,0.48,0.31818,0.5,0.31818,0.52,0.31818,0.54,0.31818,0.56,0.31818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.58,0.31818,0.6,0.31818,0.62,0.31818,0.64,0.31818,0.66,0.31818,0.68,0.31818,0.7,0.31818,0.72,0.31818,0.74,0.31818,0.76,0.31818,0.78,0.31818,0.8,0.31818,0.82,0.31818,0.84,0.31818,0.86,0.31818,0.88,0.31818,0.9,0.31818,0.92,0.31818,0.94,0.31818,0.96,0.31818,0.98,0.31818,0.99609,0.31818,0.00391,0.33333,0.02,0.33333,0.04,0.33333,0.06,0.33333,0.08,0.33333,0.1,0.33333,0.12,0.33333,0.14,0.33333,0.16,0.33333,0.18,0.33333,0.2,0.33333,0.22,0.33333,0.24,0.33333,0.26,0.33333,0.28,0.33333,0.3,0.33333,0.32,0.33333,0.34,0.33333,0.36,0.33333,0.38,0.33333,0.4,0.33333,0.42,0.33333,0.44,0.33333,0.46,0.33333,0.48,0.33333,0.5,0.33333,0.52,0.33333,0.54,0.33333,0.56,0.33333,0.58,0.33333,0.6,0.33333,0.62,0.33333,0.64,0.33333,0.66,0.33333,0.68,0.33333,0.7,0.33333,0.72,0.33333,0.74,0.33333,0.76,0.33333,0.78,0.33333,0.8,0.33333,0.82,0.33333,0.84,0.33333,0.86,0.33333,0.88,0.33333,0.9,0.33333,0.92,0.33333,0.94,0.33333,0.96,0.33333,0.98,0.33333,0.99609,0.33333,0.00391,0.34848,0.02,0.34848,0.04,0.34848,0.06,0.34848,0.08,0.34848,0.1,0.34848,0.12,0.34848,0.14,0.34848,0.16,0.34848,0.18,0.34848,0.2,0.34848,0.22,0.34848,0.24,0.34848,0.26,0.34848,0.28,0.34848,0.3,0.34848,0.32,0.34848,0.34,0.34848,0.36,0.34848,0.38,0.34848,0.4,0.34848,0.42,0.34848,0.44,0.34848,0.46,0.34848,0.48,0.34848,0.5,0.34848,0.52,0.34848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.54,0.34848,0.56,0.34848,0.58,0.34848,0.6,0.34848,0.62,0.34848,0.64,0.34848,0.66,0.34848,0.68,0.34848,0.7,0.34848,0.72,0.34848,0.74,0.34848,0.76,0.34848,0.78,0.34848,0.8,0.34848,0.82,0.34848,0.84,0.34848,0.86,0.34848,0.88,0.34848,0.9,0.34848,0.92,0.34848,0.94,0.34848,0.96,0.34848,0.98,0.34848,0.99609,0.34848,0.00391,0.36364,0.02,0.36364,0.04,0.36364,0.06,0.36364,0.08,0.36364,0.1,0.36364,0.12,0.36364,0.14,0.36364,0.16,0.36364,0.18,0.36364,0.2,0.36364,0.22,0.36364,0.24,0.36364,0.26,0.36364,0.28,0.36364,0.3,0.36364,0.32,0.36364,0.34,0.36364,0.36,0.36364,0.38,0.36364,0.4,0.36364,0.42,0.36364,0.44,0.36364,0.46,0.36364,0.48,0.36364,0.5,0.36364,0.52,0.36364,0.54,0.36364,0.56,0.36364,0.58,0.36364,0.6,0.36364,0.62,0.36364,0.64,0.36364,0.66,0.36364,0.68,0.36364,0.7,0.36364,0.72,0.36364,0.74,0.36364,0.76,0.36364,0.78,0.36364,0.8,0.36364,0.82,0.36364,0.84,0.36364,0.86,0.36364,0.88,0.36364,0.9,0.36364,0.92,0.36364,0.94,0.36364,0.96,0.36364,0.98,0.36364,0.99609,0.36364,0.00391,0.37879,0.02,0.37879,0.04,0.37879,0.06,0.37879,0.08,0.37879,0.1,0.37879,0.12,0.37879,0.14,0.37879,0.16,0.37879,0.18,0.37879,0.2,0.37879,0.22,0.37879,0.24,0.37879,0.26,0.37879,0.28,0.37879,0.3,0.37879,0.32,0.37879,0.34,0.37879,0.36,0.37879,0.38,0.37879,0.4,0.37879,0.42,0.37879,0.44,0.37879,0.46,0.37879,0.48,0.37879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.5,0.37879,0.52,0.37879,0.54,0.37879,0.56,0.37879,0.58,0.37879,0.6,0.37879,0.62,0.37879,0.64,0.37879,0.66,0.37879,0.68,0.37879,0.7,0.37879,0.72,0.37879,0.74,0.37879,0.76,0.37879,0.78,0.37879,0.8,0.37879,0.82,0.37879,0.84,0.37879,0.86,0.37879,0.88,0.37879,0.9,0.37879,0.92,0.37879,0.94,0.37879,0.96,0.37879,0.98,0.37879,0.99609,0.37879,0.00391,0.39394,0.02,0.39394,0.04,0.39394,0.06,0.39394,0.08,0.39394,0.1,0.39394,0.12,0.39394,0.14,0.39394,0.16,0.39394,0.18,0.39394,0.2,0.39394,0.22,0.39394,0.24,0.39394,0.26,0.39394,0.28,0.39394,0.3,0.39394,0.32,0.39394,0.34,0.39394,0.36,0.39394,0.38,0.39394,0.4,0.39394,0.42,0.39394,0.44,0.39394,0.46,0.39394,0.48,0.39394,0.5,0.39394,0.52,0.39394,0.54,0.39394,0.56,0.39394,0.58,0.39394,0.6,0.39394,0.62,0.39394,0.64,0.39394,0.66,0.39394,0.68,0.39394,0.7,0.39394,0.72,0.39394,0.74,0.39394,0.76,0.39394,0.78,0.39394,0.8,0.39394,0.82,0.39394,0.84,0.39394,0.86,0.39394,0.88,0.39394,0.9,0.39394,0.92,0.39394,0.94,0.39394,0.96,0.39394,0.98,0.39394,0.99609,0.39394,0.00391,0.40909,0.02,0.40909,0.04,0.40909,0.06,0.40909,0.08,0.40909,0.1,0.40909,0.12,0.40909,0.14,0.40909,0.16,0.40909,0.18,0.40909,0.2,0.40909,0.22,0.40909,0.24,0.40909,0.26,0.40909,0.28,0.40909,0.3,0.40909,0.32,0.40909,0.34,0.40909,0.36,0.40909,0.38,0.40909,0.4,0.40909,0.42,0.40909,0.44,0.40909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.46,0.40909,0.48,0.40909,0.5,0.40909,0.52,0.40909,0.54,0.40909,0.56,0.40909,0.58,0.40909,0.6,0.40909,0.62,0.40909,0.64,0.40909,0.66,0.40909,0.68,0.40909,0.7,0.40909,0.72,0.40909,0.74,0.40909,0.76,0.40909,0.78,0.40909,0.8,0.40909,0.82,0.40909,0.84,0.40909,0.86,0.40909,0.88,0.40909,0.9,0.40909,0.92,0.40909,0.94,0.40909,0.96,0.40909,0.98,0.40909,0.99609,0.40909,0.00391,0.42424,0.02,0.42424,0.04,0.42424,0.06,0.42424,0.08,0.42424,0.1,0.42424,0.12,0.42424,0.14,0.42424,0.16,0.42424,0.18,0.42424,0.2,0.42424,0.22,0.42424,0.24,0.42424,0.26,0.42424,0.28,0.42424,0.3,0.42424,0.32,0.42424,0.34,0.42424,0.36,0.42424,0.38,0.42424,0.4,0.42424,0.42,0.42424,0.44,0.42424,0.46,0.42424,0.48,0.42424,0.5,0.42424,0.52,0.42424,0.54,0.42424,0.56,0.42424,0.58,0.42424,0.6,0.42424,0.62,0.42424,0.64,0.42424,0.66,0.42424,0.68,0.42424,0.7,0.42424,0.72,0.42424,0.74,0.42424,0.76,0.42424,0.78,0.42424,0.8,0.42424,0.82,0.42424,0.84,0.42424,0.86,0.42424,0.88,0.42424,0.9,0.42424,0.92,0.42424,0.94,0.42424,0.96,0.42424,0.98,0.42424,0.99609,0.42424,0.00391,0.43939,0.02,0.43939,0.04,0.43939,0.06,0.43939,0.08,0.43939,0.1,0.43939,0.12,0.43939,0.14,0.43939,0.16,0.43939,0.18,0.43939,0.2,0.43939,0.22,0.43939,0.24,0.43939,0.26,0.43939,0.28,0.43939,0.3,0.43939,0.32,0.43939,0.34,0.43939,0.36,0.43939,0.38,0.43939,0.4,0.43939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.42,0.43939,0.44,0.43939,0.46,0.43939,0.48,0.43939,0.5,0.43939,0.52,0.43939,0.54,0.43939,0.56,0.43939,0.58,0.43939,0.6,0.43939,0.62,0.43939,0.64,0.43939,0.66,0.43939,0.68,0.43939,0.7,0.43939,0.72,0.43939,0.74,0.43939,0.76,0.43939,0.78,0.43939,0.8,0.43939,0.82,0.43939,0.84,0.43939,0.86,0.43939,0.88,0.43939,0.9,0.43939,0.92,0.43939,0.94,0.43939,0.96,0.43939,0.98,0.43939,0.99609,0.43939,0.00391,0.45455,0.02,0.45455,0.04,0.45455,0.06,0.45455,0.08,0.45455,0.1,0.45455,0.12,0.45455,0.14,0.45455,0.16,0.45455,0.18,0.45455,0.2,0.45455,0.22,0.45455,0.24,0.45455,0.26,0.45455,0.28,0.45455,0.3,0.45455,0.32,0.45455,0.34,0.45455,0.36,0.45455,0.38,0.45455,0.4,0.45455,0.42,0.45455,0.44,0.45455,0.46,0.45455,0.48,0.45455,0.5,0.45455,0.52,0.45455,0.54,0.45455,0.56,0.45455,0.58,0.45455,0.6,0.45455,0.62,0.45455,0.64,0.45455,0.66,0.45455,0.68,0.45455,0.7,0.45455,0.72,0.45455,0.74,0.45455,0.76,0.45455,0.78,0.45455,0.8,0.45455,0.82,0.45455,0.84,0.45455,0.86,0.45455,0.88,0.45455,0.9,0.45455,0.92,0.45455,0.94,0.45455,0.96,0.45455,0.98,0.45455,0.99609,0.45455,0.00391,0.4697,0.02,0.4697,0.04,0.4697,0.06,0.4697,0.08,0.4697,0.1,0.4697,0.12,0.4697,0.14,0.4697,0.16,0.4697,0.18,0.4697,0.2,0.4697,0.22,0.4697,0.24,0.4697,0.26,0.4697,0.28,0.4697,0.3,0.4697,0.32,0.4697,0.34,0.4697,0.36,0.4697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.38,0.4697,0.4,0.4697,0.42,0.4697,0.44,0.4697,0.46,0.4697,0.48,0.4697,0.5,0.4697,0.52,0.4697,0.54,0.4697,0.56,0.4697,0.58,0.4697,0.6,0.4697,0.62,0.4697,0.64,0.4697,0.66,0.4697,0.68,0.4697,0.7,0.4697,0.72,0.4697,0.74,0.4697,0.76,0.4697,0.78,0.4697,0.8,0.4697,0.82,0.4697,0.84,0.4697,0.86,0.4697,0.88,0.4697,0.9,0.4697,0.92,0.4697,0.94,0.4697,0.96,0.4697,0.98,0.4697,0.99609,0.4697,0.00391,0.48485,0.02,0.48485,0.04,0.48485,0.06,0.48485,0.08,0.48485,0.1,0.48485,0.12,0.48485,0.14,0.48485,0.16,0.48485,0.18,0.48485,0.2,0.48485,0.22,0.48485,0.24,0.48485,0.26,0.48485,0.28,0.48485,0.3,0.48485,0.32,0.48485,0.34,0.48485,0.36,0.48485,0.38,0.48485,0.4,0.48485,0.42,0.48485,0.44,0.48485,0.46,0.48485,0.48,0.48485,0.5,0.48485,0.52,0.48485,0.54,0.48485,0.56,0.48485,0.58,0.48485,0.6,0.48485,0.62,0.48485,0.64,0.48485,0.66,0.48485,0.68,0.48485,0.7,0.48485,0.72,0.48485,0.74,0.48485,0.76,0.48485,0.78,0.48485,0.8,0.48485,0.82,0.48485,0.84,0.48485,0.86,0.48485,0.88,0.48485,0.9,0.48485,0.92,0.48485,0.94,0.48485,0.96,0.48485,0.98,0.48485,0.99609,0.48485,0.00391,0.5,0.02,0.5,0.04,0.5,0.06,0.5,0.08,0.5,0.1,0.5,0.12,0.5,0.14,0.5,0.16,0.5,0.18,0.5,0.2,0.5,0.22,0.5,0.24,0.5,0.26,0.5,0.28,0.5,0.3,0.5,0.32,0.5};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.34,0.5,0.36,0.5,0.38,0.5,0.4,0.5,0.42,0.5,0.44,0.5,0.46,0.5,0.48,0.5,0.5,0.5,0.52,0.5,0.54,0.5,0.56,0.5,0.58,0.5,0.6,0.5,0.62,0.5,0.64,0.5,0.66,0.5,0.68,0.5,0.7,0.5,0.72,0.5,0.74,0.5,0.76,0.5,0.78,0.5,0.8,0.5,0.82,0.5,0.84,0.5,0.86,0.5,0.88,0.5,0.9,0.5,0.92,0.5,0.94,0.5,0.96,0.5,0.98,0.5,0.99609,0.5,0.00391,0.51515,0.02,0.51515,0.04,0.51515,0.06,0.51515,0.08,0.51515,0.1,0.51515,0.12,0.51515,0.14,0.51515,0.16,0.51515,0.18,0.51515,0.2,0.51515,0.22,0.51515,0.24,0.51515,0.26,0.51515,0.28,0.51515,0.3,0.51515,0.32,0.51515,0.34,0.51515,0.36,0.51515,0.38,0.51515,0.4,0.51515,0.42,0.51515,0.44,0.51515,0.46,0.51515,0.48,0.51515,0.5,0.51515,0.52,0.51515,0.54,0.51515,0.56,0.51515,0.58,0.51515,0.6,0.51515,0.62,0.51515,0.64,0.51515,0.66,0.51515,0.68,0.51515,0.7,0.51515,0.72,0.51515,0.74,0.51515,0.76,0.51515,0.78,0.51515,0.8,0.51515,0.82,0.51515,0.84,0.51515,0.86,0.51515,0.88,0.51515,0.9,0.51515,0.92,0.51515,0.94,0.51515,0.96,0.51515,0.98,0.51515,0.99609,0.51515,0.00391,0.5303,0.02,0.5303,0.04,0.5303,0.06,0.5303,0.08,0.5303,0.1,0.5303,0.12,0.5303,0.14,0.5303,0.16,0.5303,0.18,0.5303,0.2,0.5303,0.22,0.5303,0.24,0.5303,0.26,0.5303,0.28,0.5303};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.3,0.5303,0.32,0.5303,0.34,0.5303,0.36,0.5303,0.38,0.5303,0.4,0.5303,0.42,0.5303,0.44,0.5303,0.46,0.5303,0.48,0.5303,0.5,0.5303,0.52,0.5303,0.54,0.5303,0.56,0.5303,0.58,0.5303,0.6,0.5303,0.62,0.5303,0.64,0.5303,0.66,0.5303,0.68,0.5303,0.7,0.5303,0.72,0.5303,0.74,0.5303,0.76,0.5303,0.78,0.5303,0.8,0.5303,0.82,0.5303,0.84,0.5303,0.86,0.5303,0.88,0.5303,0.9,0.5303,0.92,0.5303,0.94,0.5303,0.96,0.5303,0.98,0.5303,0.99609,0.5303,0.00391,0.54545,0.02,0.54545,0.04,0.54545,0.06,0.54545,0.08,0.54545,0.1,0.54545,0.12,0.54545,0.14,0.54545,0.16,0.54545,0.18,0.54545,0.2,0.54545,0.22,0.54545,0.24,0.54545,0.26,0.54545,0.28,0.54545,0.3,0.54545,0.32,0.54545,0.34,0.54545,0.36,0.54545,0.38,0.54545,0.4,0.54545,0.42,0.54545,0.44,0.54545,0.46,0.54545,0.48,0.54545,0.5,0.54545,0.52,0.54545,0.54,0.54545,0.56,0.54545,0.58,0.54545,0.6,0.54545,0.62,0.54545,0.64,0.54545,0.66,0.54545,0.68,0.54545,0.7,0.54545,0.72,0.54545,0.74,0.54545,0.76,0.54545,0.78,0.54545,0.8,0.54545,0.82,0.54545,0.84,0.54545,0.86,0.54545,0.88,0.54545,0.9,0.54545,0.92,0.54545,0.94,0.54545,0.96,0.54545,0.98,0.54545,0.99609,0.54545,0.00391,0.56061,0.02,0.56061,0.04,0.56061,0.06,0.56061,0.08,0.56061,0.1,0.56061,0.12,0.56061,0.14,0.56061,0.16,0.56061,0.18,0.56061,0.2,0.56061,0.22,0.56061,0.24,0.56061};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.26,0.56061,0.28,0.56061,0.3,0.56061,0.32,0.56061,0.34,0.56061,0.36,0.56061,0.38,0.56061,0.4,0.56061,0.42,0.56061,0.44,0.56061,0.46,0.56061,0.48,0.56061,0.5,0.56061,0.52,0.56061,0.54,0.56061,0.56,0.56061,0.58,0.56061,0.6,0.56061,0.62,0.56061,0.64,0.56061,0.66,0.56061,0.68,0.56061,0.7,0.56061,0.72,0.56061,0.74,0.56061,0.76,0.56061,0.78,0.56061,0.8,0.56061,0.82,0.56061,0.84,0.56061,0.86,0.56061,0.88,0.56061,0.9,0.56061,0.92,0.56061,0.94,0.56061,0.96,0.56061,0.98,0.56061,0.99609,0.56061,0.00391,0.57576,0.02,0.57576,0.04,0.57576,0.06,0.57576,0.08,0.57576,0.1,0.57576,0.12,0.57576,0.14,0.57576,0.16,0.57576,0.18,0.57576,0.2,0.57576,0.22,0.57576,0.24,0.57576,0.26,0.57576,0.28,0.57576,0.3,0.57576,0.32,0.57576,0.34,0.57576,0.36,0.57576,0.38,0.57576,0.4,0.57576,0.42,0.57576,0.44,0.57576,0.46,0.57576,0.48,0.57576,0.5,0.57576,0.52,0.57576,0.54,0.57576,0.56,0.57576,0.58,0.57576,0.6,0.57576,0.62,0.57576,0.64,0.57576,0.66,0.57576,0.68,0.57576,0.7,0.57576,0.72,0.57576,0.74,0.57576,0.76,0.57576,0.78,0.57576,0.8,0.57576,0.82,0.57576,0.84,0.57576,0.86,0.57576,0.88,0.57576,0.9,0.57576,0.92,0.57576,0.94,0.57576,0.96,0.57576,0.98,0.57576,0.99609,0.57576,0.00391,0.59091,0.02,0.59091,0.04,0.59091,0.06,0.59091,0.08,0.59091,0.1,0.59091,0.12,0.59091,0.14,0.59091,0.16,0.59091,0.18,0.59091,0.2,0.59091};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.22,0.59091,0.24,0.59091,0.26,0.59091,0.28,0.59091,0.3,0.59091,0.32,0.59091,0.34,0.59091,0.36,0.59091,0.38,0.59091,0.4,0.59091,0.42,0.59091,0.44,0.59091,0.46,0.59091,0.48,0.59091,0.5,0.59091,0.52,0.59091,0.54,0.59091,0.56,0.59091,0.58,0.59091,0.6,0.59091,0.62,0.59091,0.64,0.59091,0.66,0.59091,0.68,0.59091,0.7,0.59091,0.72,0.59091,0.74,0.59091,0.76,0.59091,0.78,0.59091,0.8,0.59091,0.82,0.59091,0.84,0.59091,0.86,0.59091,0.88,0.59091,0.9,0.59091,0.92,0.59091,0.94,0.59091,0.96,0.59091,0.98,0.59091,0.99609,0.59091,0.00391,0.60606,0.02,0.60606,0.04,0.60606,0.06,0.60606,0.08,0.60606,0.1,0.60606,0.12,0.60606,0.14,0.60606,0.16,0.60606,0.18,0.60606,0.2,0.60606,0.22,0.60606,0.24,0.60606,0.26,0.60606,0.28,0.60606,0.3,0.60606,0.32,0.60606,0.34,0.60606,0.36,0.60606,0.38,0.60606,0.4,0.60606,0.42,0.60606,0.44,0.60606,0.46,0.60606,0.48,0.60606,0.5,0.60606,0.52,0.60606,0.54,0.60606,0.56,0.60606,0.58,0.60606,0.6,0.60606,0.62,0.60606,0.64,0.60606,0.66,0.60606,0.68,0.60606,0.7,0.60606,0.72,0.60606,0.74,0.60606,0.76,0.60606,0.78,0.60606,0.8,0.60606,0.82,0.60606,0.84,0.60606,0.86,0.60606,0.88,0.60606,0.9,0.60606,0.92,0.60606,0.94,0.60606,0.96,0.60606,0.98,0.60606,0.99609,0.60606,0.00391,0.62121,0.02,0.62121,0.04,0.62121,0.06,0.62121,0.08,0.62121,0.1,0.62121,0.12,0.62121,0.14,0.62121,0.16,0.62121};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.18,0.62121,0.2,0.62121,0.22,0.62121,0.24,0.62121,0.26,0.62121,0.28,0.62121,0.3,0.62121,0.32,0.62121,0.34,0.62121,0.36,0.62121,0.38,0.62121,0.4,0.62121,0.42,0.62121,0.44,0.62121,0.46,0.62121,0.48,0.62121,0.5,0.62121,0.52,0.62121,0.54,0.62121,0.56,0.62121,0.58,0.62121,0.6,0.62121,0.62,0.62121,0.64,0.62121,0.66,0.62121,0.68,0.62121,0.7,0.62121,0.72,0.62121,0.74,0.62121,0.76,0.62121,0.78,0.62121,0.8,0.62121,0.82,0.62121,0.84,0.62121,0.86,0.62121,0.88,0.62121,0.9,0.62121,0.92,0.62121,0.94,0.62121,0.96,0.62121,0.98,0.62121,0.99609,0.62121,0.00391,0.63636,0.02,0.63636,0.04,0.63636,0.06,0.63636,0.08,0.63636,0.1,0.63636,0.12,0.63636,0.14,0.63636,0.16,0.63636,0.18,0.63636,0.2,0.63636,0.22,0.63636,0.24,0.63636,0.26,0.63636,0.28,0.63636,0.3,0.63636,0.32,0.63636,0.34,0.63636,0.36,0.63636,0.38,0.63636,0.4,0.63636,0.42,0.63636,0.44,0.63636,0.46,0.63636,0.48,0.63636,0.5,0.63636,0.52,0.63636,0.54,0.63636,0.56,0.63636,0.58,0.63636,0.6,0.63636,0.62,0.63636,0.64,0.63636,0.66,0.63636,0.68,0.63636,0.7,0.63636,0.72,0.63636,0.74,0.63636,0.76,0.63636,0.78,0.63636,0.8,0.63636,0.82,0.63636,0.84,0.63636,0.86,0.63636,0.88,0.63636,0.9,0.63636,0.92,0.63636,0.94,0.63636,0.96,0.63636,0.98,0.63636,0.99609,0.63636,0.00391,0.65152,0.02,0.65152,0.04,0.65152,0.06,0.65152,0.08,0.65152,0.1,0.65152,0.12,0.65152};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.14,0.65152,0.16,0.65152,0.18,0.65152,0.2,0.65152,0.22,0.65152,0.24,0.65152,0.26,0.65152,0.28,0.65152,0.3,0.65152,0.32,0.65152,0.34,0.65152,0.36,0.65152,0.38,0.65152,0.4,0.65152,0.42,0.65152,0.44,0.65152,0.46,0.65152,0.48,0.65152,0.5,0.65152,0.52,0.65152,0.54,0.65152,0.56,0.65152,0.58,0.65152,0.6,0.65152,0.62,0.65152,0.64,0.65152,0.66,0.65152,0.68,0.65152,0.7,0.65152,0.72,0.65152,0.74,0.65152,0.76,0.65152,0.78,0.65152,0.8,0.65152,0.82,0.65152,0.84,0.65152,0.86,0.65152,0.88,0.65152,0.9,0.65152,0.92,0.65152,0.94,0.65152,0.96,0.65152,0.98,0.65152,0.99609,0.65152,0.00391,0.66667,0.02,0.66667,0.04,0.66667,0.06,0.66667,0.08,0.66667,0.1,0.66667,0.12,0.66667,0.14,0.66667,0.16,0.66667,0.18,0.66667,0.2,0.66667,0.22,0.66667,0.24,0.66667,0.26,0.66667,0.28,0.66667,0.3,0.66667,0.32,0.66667,0.34,0.66667,0.36,0.66667,0.38,0.66667,0.4,0.66667,0.42,0.66667,0.44,0.66667,0.46,0.66667,0.48,0.66667,0.5,0.66667,0.52,0.66667,0.54,0.66667,0.56,0.66667,0.58,0.66667,0.6,0.66667,0.62,0.66667,0.64,0.66667,0.66,0.66667,0.68,0.66667,0.7,0.66667,0.72,0.66667,0.74,0.66667,0.76,0.66667,0.78,0.66667,0.8,0.66667,0.82,0.66667,0.84,0.66667,0.86,0.66667,0.88,0.66667,0.9,0.66667,0.92,0.66667,0.94,0.66667,0.96,0.66667,0.98,0.66667,0.99609,0.66667,0.00391,0.68182,0.02,0.68182,0.04,0.68182,0.06,0.68182,0.08,0.68182};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.1,0.68182,0.12,0.68182,0.14,0.68182,0.16,0.68182,0.18,0.68182,0.2,0.68182,0.22,0.68182,0.24,0.68182,0.26,0.68182,0.28,0.68182,0.3,0.68182,0.32,0.68182,0.34,0.68182,0.36,0.68182,0.38,0.68182,0.4,0.68182,0.42,0.68182,0.44,0.68182,0.46,0.68182,0.48,0.68182,0.5,0.68182,0.52,0.68182,0.54,0.68182,0.56,0.68182,0.58,0.68182,0.6,0.68182,0.62,0.68182,0.64,0.68182,0.66,0.68182,0.68,0.68182,0.7,0.68182,0.72,0.68182,0.74,0.68182,0.76,0.68182,0.78,0.68182,0.8,0.68182,0.82,0.68182,0.84,0.68182,0.86,0.68182,0.88,0.68182,0.9,0.68182,0.92,0.68182,0.94,0.68182,0.96,0.68182,0.98,0.68182,0.99609,0.68182,0.00391,0.69697,0.02,0.69697,0.04,0.69697,0.06,0.69697,0.08,0.69697,0.1,0.69697,0.12,0.69697,0.14,0.69697,0.16,0.69697,0.18,0.69697,0.2,0.69697,0.22,0.69697,0.24,0.69697,0.26,0.69697,0.28,0.69697,0.3,0.69697,0.32,0.69697,0.34,0.69697,0.36,0.69697,0.38,0.69697,0.4,0.69697,0.42,0.69697,0.44,0.69697,0.46,0.69697,0.48,0.69697,0.5,0.69697,0.52,0.69697,0.54,0.69697,0.56,0.69697,0.58,0.69697,0.6,0.69697,0.62,0.69697,0.64,0.69697,0.66,0.69697,0.68,0.69697,0.7,0.69697,0.72,0.69697,0.74,0.69697,0.76,0.69697,0.78,0.69697,0.8,0.69697,0.82,0.69697,0.84,0.69697,0.86,0.69697,0.88,0.69697,0.9,0.69697,0.92,0.69697,0.94,0.69697,0.96,0.69697,0.98,0.69697,0.99609,0.69697,0.00391,0.71212,0.02,0.71212,0.04,0.71212};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.06,0.71212,0.08,0.71212,0.1,0.71212,0.12,0.71212,0.14,0.71212,0.16,0.71212,0.18,0.71212,0.2,0.71212,0.22,0.71212,0.24,0.71212,0.26,0.71212,0.28,0.71212,0.3,0.71212,0.32,0.71212,0.34,0.71212,0.36,0.71212,0.38,0.71212,0.4,0.71212,0.42,0.71212,0.44,0.71212,0.46,0.71212,0.48,0.71212,0.5,0.71212,0.52,0.71212,0.54,0.71212,0.56,0.71212,0.58,0.71212,0.6,0.71212,0.62,0.71212,0.64,0.71212,0.66,0.71212,0.68,0.71212,0.7,0.71212,0.72,0.71212,0.74,0.71212,0.76,0.71212,0.78,0.71212,0.8,0.71212,0.82,0.71212,0.84,0.71212,0.86,0.71212,0.88,0.71212,0.9,0.71212,0.92,0.71212,0.94,0.71212,0.96,0.71212,0.98,0.71212,0.99609,0.71212,0.00391,0.72727,0.02,0.72727,0.04,0.72727,0.06,0.72727,0.08,0.72727,0.1,0.72727,0.12,0.72727,0.14,0.72727,0.16,0.72727,0.18,0.72727,0.2,0.72727,0.22,0.72727,0.24,0.72727,0.26,0.72727,0.28,0.72727,0.3,0.72727,0.32,0.72727,0.34,0.72727,0.36,0.72727,0.38,0.72727,0.4,0.72727,0.42,0.72727,0.44,0.72727,0.46,0.72727,0.48,0.72727,0.5,0.72727,0.52,0.72727,0.54,0.72727,0.56,0.72727,0.58,0.72727,0.6,0.72727,0.62,0.72727,0.64,0.72727,0.66,0.72727,0.68,0.72727,0.7,0.72727,0.72,0.72727,0.74,0.72727,0.76,0.72727,0.78,0.72727,0.8,0.72727,0.82,0.72727,0.84,0.72727,0.86,0.72727,0.88,0.72727,0.9,0.72727,0.92,0.72727,0.94,0.72727,0.96,0.72727,0.98,0.72727,0.99609,0.72727,0.00391,0.74242};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.02,0.74242,0.04,0.74242,0.06,0.74242,0.08,0.74242,0.1,0.74242,0.12,0.74242,0.14,0.74242,0.16,0.74242,0.18,0.74242,0.2,0.74242,0.22,0.74242,0.24,0.74242,0.26,0.74242,0.28,0.74242,0.3,0.74242,0.32,0.74242,0.34,0.74242,0.36,0.74242,0.38,0.74242,0.4,0.74242,0.42,0.74242,0.44,0.74242,0.46,0.74242,0.48,0.74242,0.5,0.74242,0.52,0.74242,0.54,0.74242,0.56,0.74242,0.58,0.74242,0.6,0.74242,0.62,0.74242,0.64,0.74242,0.66,0.74242,0.68,0.74242,0.7,0.74242,0.72,0.74242,0.74,0.74242,0.76,0.74242,0.78,0.74242,0.8,0.74242,0.82,0.74242,0.84,0.74242,0.86,0.74242,0.88,0.74242,0.9,0.74242,0.92,0.74242,0.94,0.74242,0.96,0.74242,0.98,0.74242,0.99609,0.74242,0.00391,0.75758,0.02,0.75758,0.04,0.75758,0.06,0.75758,0.08,0.75758,0.1,0.75758,0.12,0.75758,0.14,0.75758,0.16,0.75758,0.18,0.75758,0.2,0.75758,0.22,0.75758,0.24,0.75758,0.26,0.75758,0.28,0.75758,0.3,0.75758,0.32,0.75758,0.34,0.75758,0.36,0.75758,0.38,0.75758,0.4,0.75758,0.42,0.75758,0.44,0.75758,0.46,0.75758,0.48,0.75758,0.5,0.75758,0.52,0.75758,0.54,0.75758,0.56,0.75758,0.58,0.75758,0.6,0.75758,0.62,0.75758,0.64,0.75758,0.66,0.75758,0.68,0.75758,0.7,0.75758,0.72,0.75758,0.74,0.75758,0.76,0.75758,0.78,0.75758,0.8,0.75758,0.82,0.75758,0.84,0.75758,0.86,0.75758,0.88,0.75758,0.9,0.75758,0.92,0.75758,0.94,0.75758,0.96,0.75758,0.98,0.75758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.99609,0.75758,0.00391,0.77273,0.02,0.77273,0.04,0.77273,0.06,0.77273,0.08,0.77273,0.1,0.77273,0.12,0.77273,0.14,0.77273,0.16,0.77273,0.18,0.77273,0.2,0.77273,0.22,0.77273,0.24,0.77273,0.26,0.77273,0.28,0.77273,0.3,0.77273,0.32,0.77273,0.34,0.77273,0.36,0.77273,0.38,0.77273,0.4,0.77273,0.42,0.77273,0.44,0.77273,0.46,0.77273,0.48,0.77273,0.5,0.77273,0.52,0.77273,0.54,0.77273,0.56,0.77273,0.58,0.77273,0.6,0.77273,0.62,0.77273,0.64,0.77273,0.66,0.77273,0.68,0.77273,0.7,0.77273,0.72,0.77273,0.74,0.77273,0.76,0.77273,0.78,0.77273,0.8,0.77273,0.82,0.77273,0.84,0.77273,0.86,0.77273,0.88,0.77273,0.9,0.77273,0.92,0.77273,0.94,0.77273,0.96,0.77273,0.98,0.77273,0.99609,0.77273,0.00391,0.78788,0.02,0.78788,0.04,0.78788,0.06,0.78788,0.08,0.78788,0.1,0.78788,0.12,0.78788,0.14,0.78788,0.16,0.78788,0.18,0.78788,0.2,0.78788,0.22,0.78788,0.24,0.78788,0.26,0.78788,0.28,0.78788,0.3,0.78788,0.32,0.78788,0.34,0.78788,0.36,0.78788,0.38,0.78788,0.4,0.78788,0.42,0.78788,0.44,0.78788,0.46,0.78788,0.48,0.78788,0.5,0.78788,0.52,0.78788,0.54,0.78788,0.56,0.78788,0.58,0.78788,0.6,0.78788,0.62,0.78788,0.64,0.78788,0.66,0.78788,0.68,0.78788,0.7,0.78788,0.72,0.78788,0.74,0.78788,0.76,0.78788,0.78,0.78788,0.8,0.78788,0.82,0.78788,0.84,0.78788,0.86,0.78788,0.88,0.78788,0.9,0.78788,0.92,0.78788,0.94,0.78788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.96,0.78788,0.98,0.78788,0.99609,0.78788,0.00391,0.80303,0.02,0.80303,0.04,0.80303,0.06,0.80303,0.08,0.80303,0.1,0.80303,0.12,0.80303,0.14,0.80303,0.16,0.80303,0.18,0.80303,0.2,0.80303,0.22,0.80303,0.24,0.80303,0.26,0.80303,0.28,0.80303,0.3,0.80303,0.32,0.80303,0.34,0.80303,0.36,0.80303,0.38,0.80303,0.4,0.80303,0.42,0.80303,0.44,0.80303,0.46,0.80303,0.48,0.80303,0.5,0.80303,0.52,0.80303,0.54,0.80303,0.56,0.80303,0.58,0.80303,0.6,0.80303,0.62,0.80303,0.64,0.80303,0.66,0.80303,0.68,0.80303,0.7,0.80303,0.72,0.80303,0.74,0.80303,0.76,0.80303,0.78,0.80303,0.8,0.80303,0.82,0.80303,0.84,0.80303,0.86,0.80303,0.88,0.80303,0.9,0.80303,0.92,0.80303,0.94,0.80303,0.96,0.80303,0.98,0.80303,0.99609,0.80303,0.00391,0.81818,0.02,0.81818,0.04,0.81818,0.06,0.81818,0.08,0.81818,0.1,0.81818,0.12,0.81818,0.14,0.81818,0.16,0.81818,0.18,0.81818,0.2,0.81818,0.22,0.81818,0.24,0.81818,0.26,0.81818,0.28,0.81818,0.3,0.81818,0.32,0.81818,0.34,0.81818,0.36,0.81818,0.38,0.81818,0.4,0.81818,0.42,0.81818,0.44,0.81818,0.46,0.81818,0.48,0.81818,0.5,0.81818,0.52,0.81818,0.54,0.81818,0.56,0.81818,0.58,0.81818,0.6,0.81818,0.62,0.81818,0.64,0.81818,0.66,0.81818,0.68,0.81818,0.7,0.81818,0.72,0.81818,0.74,0.81818,0.76,0.81818,0.78,0.81818,0.8,0.81818,0.82,0.81818,0.84,0.81818,0.86,0.81818,0.88,0.81818,0.9,0.81818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.92,0.81818,0.94,0.81818,0.96,0.81818,0.98,0.81818,0.99609,0.81818,0.00391,0.83333,0.02,0.83333,0.04,0.83333,0.06,0.83333,0.08,0.83333,0.1,0.83333,0.12,0.83333,0.14,0.83333,0.16,0.83333,0.18,0.83333,0.2,0.83333,0.22,0.83333,0.24,0.83333,0.26,0.83333,0.28,0.83333,0.3,0.83333,0.32,0.83333,0.34,0.83333,0.36,0.83333,0.38,0.83333,0.4,0.83333,0.42,0.83333,0.44,0.83333,0.46,0.83333,0.48,0.83333,0.5,0.83333,0.52,0.83333,0.54,0.83333,0.56,0.83333,0.58,0.83333,0.6,0.83333,0.62,0.83333,0.64,0.83333,0.66,0.83333,0.68,0.83333,0.7,0.83333,0.72,0.83333,0.74,0.83333,0.76,0.83333,0.78,0.83333,0.8,0.83333,0.82,0.83333,0.84,0.83333,0.86,0.83333,0.88,0.83333,0.9,0.83333,0.92,0.83333,0.94,0.83333,0.96,0.83333,0.98,0.83333,0.99609,0.83333,0.00391,0.84848,0.02,0.84848,0.04,0.84848,0.06,0.84848,0.08,0.84848,0.1,0.84848,0.12,0.84848,0.14,0.84848,0.16,0.84848,0.18,0.84848,0.2,0.84848,0.22,0.84848,0.24,0.84848,0.26,0.84848,0.28,0.84848,0.3,0.84848,0.32,0.84848,0.34,0.84848,0.36,0.84848,0.38,0.84848,0.4,0.84848,0.42,0.84848,0.44,0.84848,0.46,0.84848,0.48,0.84848,0.5,0.84848,0.52,0.84848,0.54,0.84848,0.56,0.84848,0.58,0.84848,0.6,0.84848,0.62,0.84848,0.64,0.84848,0.66,0.84848,0.68,0.84848,0.7,0.84848,0.72,0.84848,0.74,0.84848,0.76,0.84848,0.78,0.84848,0.8,0.84848,0.82,0.84848,0.84,0.84848,0.86,0.84848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.88,0.84848,0.9,0.84848,0.92,0.84848,0.94,0.84848,0.96,0.84848,0.98,0.84848,0.99609,0.84848,0.00391,0.86364,0.02,0.86364,0.04,0.86364,0.06,0.86364,0.08,0.86364,0.1,0.86364,0.12,0.86364,0.14,0.86364,0.16,0.86364,0.18,0.86364,0.2,0.86364,0.22,0.86364,0.24,0.86364,0.26,0.86364,0.28,0.86364,0.3,0.86364,0.32,0.86364,0.34,0.86364,0.36,0.86364,0.38,0.86364,0.4,0.86364,0.42,0.86364,0.44,0.86364,0.46,0.86364,0.48,0.86364,0.5,0.86364,0.52,0.86364,0.54,0.86364,0.56,0.86364,0.58,0.86364,0.6,0.86364,0.62,0.86364,0.64,0.86364,0.66,0.86364,0.68,0.86364,0.7,0.86364,0.72,0.86364,0.74,0.86364,0.76,0.86364,0.78,0.86364,0.8,0.86364,0.82,0.86364,0.84,0.86364,0.86,0.86364,0.88,0.86364,0.9,0.86364,0.92,0.86364,0.94,0.86364,0.96,0.86364,0.98,0.86364,0.99609,0.86364,0.00391,0.87879,0.02,0.87879,0.04,0.87879,0.06,0.87879,0.08,0.87879,0.1,0.87879,0.12,0.87879,0.14,0.87879,0.16,0.87879,0.18,0.87879,0.2,0.87879,0.22,0.87879,0.24,0.87879,0.26,0.87879,0.28,0.87879,0.3,0.87879,0.32,0.87879,0.34,0.87879,0.36,0.87879,0.38,0.87879,0.4,0.87879,0.42,0.87879,0.44,0.87879,0.46,0.87879,0.48,0.87879,0.5,0.87879,0.52,0.87879,0.54,0.87879,0.56,0.87879,0.58,0.87879,0.6,0.87879,0.62,0.87879,0.64,0.87879,0.66,0.87879,0.68,0.87879,0.7,0.87879,0.72,0.87879,0.74,0.87879,0.76,0.87879,0.78,0.87879,0.8,0.87879,0.82,0.87879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.84,0.87879,0.86,0.87879,0.88,0.87879,0.9,0.87879,0.92,0.87879,0.94,0.87879,0.96,0.87879,0.98,0.87879,0.99609,0.87879,0.00391,0.89394,0.02,0.89394,0.04,0.89394,0.06,0.89394,0.08,0.89394,0.1,0.89394,0.12,0.89394,0.14,0.89394,0.16,0.89394,0.18,0.89394,0.2,0.89394,0.22,0.89394,0.24,0.89394,0.26,0.89394,0.28,0.89394,0.3,0.89394,0.32,0.89394,0.34,0.89394,0.36,0.89394,0.38,0.89394,0.4,0.89394,0.42,0.89394,0.44,0.89394,0.46,0.89394,0.48,0.89394,0.5,0.89394,0.52,0.89394,0.54,0.89394,0.56,0.89394,0.58,0.89394,0.6,0.89394,0.62,0.89394,0.64,0.89394,0.66,0.89394,0.68,0.89394,0.7,0.89394,0.72,0.89394,0.74,0.89394,0.76,0.89394,0.78,0.89394,0.8,0.89394,0.82,0.89394,0.84,0.89394,0.86,0.89394,0.88,0.89394,0.9,0.89394,0.92,0.89394,0.94,0.89394,0.96,0.89394,0.98,0.89394,0.99609,0.89394,0.00391,0.90909,0.02,0.90909,0.04,0.90909,0.06,0.90909,0.08,0.90909,0.1,0.90909,0.12,0.90909,0.14,0.90909,0.16,0.90909,0.18,0.90909,0.2,0.90909,0.22,0.90909,0.24,0.90909,0.26,0.90909,0.28,0.90909,0.3,0.90909,0.32,0.90909,0.34,0.90909,0.36,0.90909,0.38,0.90909,0.4,0.90909,0.42,0.90909,0.44,0.90909,0.46,0.90909,0.48,0.90909,0.5,0.90909,0.52,0.90909,0.54,0.90909,0.56,0.90909,0.58,0.90909,0.6,0.90909,0.62,0.90909,0.64,0.90909,0.66,0.90909,0.68,0.90909,0.7,0.90909,0.72,0.90909,0.74,0.90909,0.76,0.90909,0.78,0.90909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.8,0.90909,0.82,0.90909,0.84,0.90909,0.86,0.90909,0.88,0.90909,0.9,0.90909,0.92,0.90909,0.94,0.90909,0.96,0.90909,0.98,0.90909,0.99609,0.90909,0.00391,0.92424,0.02,0.92424,0.04,0.92424,0.06,0.92424,0.08,0.92424,0.1,0.92424,0.12,0.92424,0.14,0.92424,0.16,0.92424,0.18,0.92424,0.2,0.92424,0.22,0.92424,0.24,0.92424,0.26,0.92424,0.28,0.92424,0.3,0.92424,0.32,0.92424,0.34,0.92424,0.36,0.92424,0.38,0.92424,0.4,0.92424,0.42,0.92424,0.44,0.92424,0.46,0.92424,0.48,0.92424,0.5,0.92424,0.52,0.92424,0.54,0.92424,0.56,0.92424,0.58,0.92424,0.6,0.92424,0.62,0.92424,0.64,0.92424,0.66,0.92424,0.68,0.92424,0.7,0.92424,0.72,0.92424,0.74,0.92424,0.76,0.92424,0.78,0.92424,0.8,0.92424,0.82,0.92424,0.84,0.92424,0.86,0.92424,0.88,0.92424,0.9,0.92424,0.92,0.92424,0.94,0.92424,0.96,0.92424,0.98,0.92424,0.99609,0.92424,0.00391,0.93939,0.02,0.93939,0.04,0.93939,0.06,0.93939,0.08,0.93939,0.1,0.93939,0.12,0.93939,0.14,0.93939,0.16,0.93939,0.18,0.93939,0.2,0.93939,0.22,0.93939,0.24,0.93939,0.26,0.93939,0.28,0.93939,0.3,0.93939,0.32,0.93939,0.34,0.93939,0.36,0.93939,0.38,0.93939,0.4,0.93939,0.42,0.93939,0.44,0.93939,0.46,0.93939,0.48,0.93939,0.5,0.93939,0.52,0.93939,0.54,0.93939,0.56,0.93939,0.58,0.93939,0.6,0.93939,0.62,0.93939,0.64,0.93939,0.66,0.93939,0.68,0.93939,0.7,0.93939,0.72,0.93939,0.74,0.93939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.76,0.93939,0.78,0.93939,0.8,0.93939,0.82,0.93939,0.84,0.93939,0.86,0.93939,0.88,0.93939,0.9,0.93939,0.92,0.93939,0.94,0.93939,0.96,0.93939,0.98,0.93939,0.99609,0.93939,0.00391,0.95455,0.02,0.95455,0.04,0.95455,0.06,0.95455,0.08,0.95455,0.1,0.95455,0.12,0.95455,0.14,0.95455,0.16,0.95455,0.18,0.95455,0.2,0.95455,0.22,0.95455,0.24,0.95455,0.26,0.95455,0.28,0.95455,0.3,0.95455,0.32,0.95455,0.34,0.95455,0.36,0.95455,0.38,0.95455,0.4,0.95455,0.42,0.95455,0.44,0.95455,0.46,0.95455,0.48,0.95455,0.5,0.95455,0.52,0.95455,0.54,0.95455,0.56,0.95455,0.58,0.95455,0.6,0.95455,0.62,0.95455,0.64,0.95455,0.66,0.95455,0.68,0.95455,0.7,0.95455,0.72,0.95455,0.74,0.95455,0.76,0.95455,0.78,0.95455,0.8,0.95455,0.82,0.95455,0.84,0.95455,0.86,0.95455,0.88,0.95455,0.9,0.95455,0.92,0.95455,0.94,0.95455,0.96,0.95455,0.98,0.95455,0.99609,0.95455,0.00391,0.9697,0.02,0.9697,0.04,0.9697,0.06,0.9697,0.08,0.9697,0.1,0.9697,0.12,0.9697,0.14,0.9697,0.16,0.9697,0.18,0.9697,0.2,0.9697,0.22,0.9697,0.24,0.9697,0.26,0.9697,0.28,0.9697,0.3,0.9697,0.32,0.9697,0.34,0.9697,0.36,0.9697,0.38,0.9697,0.4,0.9697,0.42,0.9697,0.44,0.9697,0.46,0.9697,0.48,0.9697,0.5,0.9697,0.52,0.9697,0.54,0.9697,0.56,0.9697,0.58,0.9697,0.6,0.9697,0.62,0.9697,0.64,0.9697,0.66,0.9697,0.68,0.9697,0.7,0.9697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.72,0.9697,0.74,0.9697,0.76,0.9697,0.78,0.9697,0.8,0.9697,0.82,0.9697,0.84,0.9697,0.86,0.9697,0.88,0.9697,0.9,0.9697,0.92,0.9697,0.94,0.9697,0.96,0.9697,0.98,0.9697,0.99609,0.9697,0.00391,0.98485,0.02,0.98485,0.04,0.98485,0.06,0.98485,0.08,0.98485,0.1,0.98485,0.12,0.98485,0.14,0.98485,0.16,0.98485,0.18,0.98485,0.2,0.98485,0.22,0.98485,0.24,0.98485,0.26,0.98485,0.28,0.98485,0.3,0.98485,0.32,0.98485,0.34,0.98485,0.36,0.98485,0.38,0.98485,0.4,0.98485,0.42,0.98485,0.44,0.98485,0.46,0.98485,0.48,0.98485,0.5,0.98485,0.52,0.98485,0.54,0.98485,0.56,0.98485,0.58,0.98485,0.6,0.98485,0.62,0.98485,0.64,0.98485,0.66,0.98485,0.68,0.98485,0.7,0.98485,0.72,0.98485,0.74,0.98485,0.76,0.98485,0.78,0.98485,0.8,0.98485,0.82,0.98485,0.84,0.98485,0.86,0.98485,0.88,0.98485,0.9,0.98485,0.92,0.98485,0.94,0.98485,0.96,0.98485,0.98,0.98485,0.99609,0.98485,0.00391,0.99609,0.02,0.99609,0.04,0.99609,0.06,0.99609,0.08,0.99609,0.1,0.99609,0.12,0.99609,0.14,0.99609,0.16,0.99609,0.18,0.99609,0.2,0.99609,0.22,0.99609,0.24,0.99609,0.26,0.99609,0.28,0.99609,0.3,0.99609,0.32,0.99609,0.34,0.99609,0.36,0.99609,0.38,0.99609,0.4,0.99609,0.42,0.99609,0.44,0.99609,0.46,0.99609,0.48,0.99609,0.5,0.99609,0.52,0.99609,0.54,0.99609,0.56,0.99609,0.58,0.99609,0.6,0.99609,0.62,0.99609,0.64,0.99609,0.66,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.68,0.99609,0.7,0.99609,0.72,0.99609,0.74,0.99609,0.76,0.99609,0.78,0.99609,0.8,0.99609,0.82,0.99609,0.84,0.99609,0.86,0.99609,0.88,0.99609,0.9,0.99609,0.92,0.99609,0.94,0.99609,0.96,0.99609,0.98,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 3417 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 6834 total numbers made up of 3417 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD003 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD003().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD003\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD003 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD003_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD003_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD003_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD003_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
