####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD002.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD002.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD002.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD002.x3d'),
    GeoLOD(center=(4342525.411173,738193.374947,2109.5),child1Url=["SquawLOD003.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD003.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw001.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw001.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4341718.744506,737558.999947,0),geoSystem=["UTM","Z10","N"],height=[2193.4783,2168.367,2147.942,2149.265,2148.4768,2148.3577,2140.68,2136.6267,2122.0334,2112.7974,2100.919,2064.7893,2031.9758,2003.0729,1983.9452,1970.693,1957.8745,1946.3912,1930.3688,1924.9022,1937.2402,1937.3232,1937.1929,1942.8427,1944.7362,2204.2766,2179.8188,2171.0679,2181.9072,2174.2441,2174.6665,2165.9958,2164.8213,2154.278,2137.1992,2107.8162,2074.1548,2041.7773,2012.5387,1991.9797,1977.6965,1960.1868,1945.9945,1936.5957,1917.5837,1921.7946,1927.3182,1920.7788,1924.7994,1927.805,2222.8284,2192.1519,2201.2405,2214.5774,2205.2715,2199.392,2189.569,2194.914,2193.8372,2177.4395,2137.7861,2099.0007,2062.3167,2027.8965,1999.3704,1976.152,1961.749,1943.9662,1933.5311,1923.4602,1906.2872,1906.0969,1900.7965,1908.7106,1913.1959,2244.8457,2221.592,2230.5095,2237.1587,2235.9426,2216.1309,2214.915,2218.6013,2237.283,2214.6057,2169.6274,2119.5762,2078.8625,2045.722,2015.1646,1982.7919,1958.3118,1943.3912,1931.9805,1920.5704,1911.1091,1901.546,1899.0,1899.3772,1906.7015,2254.053,2255.9602,2269.735,2264.9072,2257.7156,2246.1458,2243.1724,2253.4038,2250.6758,2207.2727,2169.0608,2127.438,2093.3188,2052.9353,2013.3055,1985.4645,1961.749,1944.855,1929.9805,1915.067,1905.5432,1901.0,1899.0,1901.0,1905.3507,2292.1274,2289.33,2296.1968,2293.1155,2290.4053,2276.4583,2278.7876,2272.971,2211.8972,2184.0107,2124.691,2095.1777,2072.3367,2024.3828,1991.3704,1971.518,1955.1868,1939.2662,1919.8564,1907.455,1901.0,1900.0,1899.0,1901.0,1903.9729,2317.018,2321.9167,2311.9316,2304.591,2293.9312,2283.0415,2269.189,2252.0283,2200.8975,2129.6807,2096.944,2056.4094,2014.9855,1993.8477,1972.4213,1952.3097,1935.9784,1920.6328,1909.8563,1901.4736,1897.9619,1897.0,1898.9503,1900.3458,1901.3507,2295.1118,2298.37,2288.515,2275.366,2262.5034,2252.2915,2233.0334,2207.0225,2153.4104,2098.896,2057.551,2029.0415,1993.5289,1965.2887,1945.912,1930.4465,1918.0618,1908.7445,1902.3652,1899.4521,1897.4753,1897.0,1897.0,1899.0,1900.3069,2267.307,2270.1733,2263.1326,2250.4448,2234.6238,2210.222,2187.39,2143.4224,2097.1655,2059.092,2028.1796,2005.4429,1975.0396,1947.824,1926.5887,1917.0089,1909.635,1901.773,1898.915,1897.0,1897.0,1897.0,1897.0,1897.0,1898.2922,2242.932,2242.798,2233.8826,2224.2173,2211.5244,2181.5107,2147.367,2107.0156,2061.9688,2023.1282,1998.5,1977.14,1956.8079,1931.0143,1916.8644,1910.2024,1904.3201,1899.4637,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,1897.0,2218.7234,2217.7998,2206.1326,2201.2964,2186.2156,2158.411,2111.4377,2067.4922,2038.0204,2004.9493,1978.113,1959.4475,1934.3265,1919.0549,1911.3843,1906.7189,1902.1873,1900.0,1899.0,1898.0,1897.0,1897.0,1897.0,1897.0944,1897.0876,2194.2368,2192.5813,2186.2383,2196.1113,2160.703,2124.0818,2084.3862,2049.1768,2010.8939,1986.4886,1960.0862,1937.5468,1924.4104,1912.3578,1909.2722,1905.2909,1902.2916,1902.1353,1901.0,1899.1508,1898.0,1898.1255,1899.0,1900.0,1900.2916,2168.6624,2168.693,2166.0,2180.488,2141.367,2100.0203,2061.3093,2026.0558,1994.5017,1968.8416,1946.3536,1928.5524,1915.8833,1911.3578,1909.128,1907.137,1905.7706,1905.0,1902.6602,1901.0,1900.3334,1900.3334,1901.0,1902.9182,1905.4502,2147.1118,2144.1797,2150.985,2162.2112,2119.0227,2082.8118,2045.9084,2009.6412,1983.0857,1957.5088,1936.2859,1923.6095,1916.9133,1912.5986,1910.6151,1910.375,1910.375,1908.174,1905.8652,1904.375,1903.375,1904.375,1905.375,1907.6108,1911.5942,2124.3333,2121.9563,2140.8696,2143.9482,2105.8325,2074.312,2034.7169,1999.1097,1976.6157,1953.5105,1937.0891,1924.3048,1919.3313,1914.3578,1913.2566,1914.4166,1913.4373,1911.4166,1909.4166,1908.4166,1908.0,1908.4166,1910.4166,1912.1572,1915.9136,2096.0894,2100.629,2123.9016,2112.5667,2082.8374,2059.0334,2021.8308,1990.077,1969.1141,1954.7552,1942.0149,1930.2075,1922.4584,1919.2744,1920.5325,1919.6466,1916.6587,1914.4637,1912.4584,1912.0,1911.4584,1912.1971,1916.7788,1921.5793,1922.9698,2083.5464,2083.7217,2105.3345,2088.0564,2059.0366,2031.4474,2002.8612,1978.1925,1963.1758,1955.1294,1948.0565,1936.8048,1928.6625,1925.5,1928.5,1923.7053,1922.9373,1920.0,1920.0,1919.5167,1919.7284,1922.6454,1935.8075,1937.9341,1931.8246,2057.3882,2064.638,2085.0266,2083.2546,2044.5676,2012.0037,1981.709,1971.7482,1963.4504,1957.2517,1951.1508,1950.223,1938.4146,1934.441,1932.2594,1931.625,1929.5206,1929.9155,1931.1348,1933.9049,1936.2443,1942.3358,1954.9741,1952.0411,1944.625,2043.8466,2049.154,2065.4016,2063.115,2028.263,2002.5621,1972.7611,1964.6154,1960.642,1956.2517,1954.6992,1953.5834,1949.4979,1941.8822,1937.1991,1945.3334,1940.0782,1949.3334,1951.8625,1953.6487,1950.3466,1958.8479,1962.8447,1963.4905,1961.3053,2029.5133,2037.7102,2040.7839,2036.188,2010.6467,1991.3877,1968.2021,1960.5737,1958.0845,1959.0927,1960.625,1958.8154,1956.5813,1950.7155,1953.107,1969.3817,1957.4377,1962.875,1968.8945,1972.198,1969.5,1970.25,1975.6825,1979.7335,1983.1772,2013.3157,2019.3334,2016.0442,2012.914,1995.477,1973.965,1959.6204,1958.0,1958.0,1962.2471,1967.3334,1967.0,1965.2188,1959.3334,1974.0016,1982.1727,1971.6249,1978.5363,1984.3463,1984.6555,1989.1522,1981.4768,1991.0062,1997.3772,2006.2687,2005.301,2001.875,1997.669,1994.875,1985.941,1971.4797,1959.2225,1960.5096,1963.1914,1969.0914,1975.2196,1976.7084,1971.8445,1976.7601,1989.1445,1985.6562,1984.9794,1996.7494,1996.2737,2001.0507,2000.5432,1995.5553,2005.0446,2016.5879,2029.075,2017.0,2004.6193,1993.7153,1983.6392,1975.7385,1968.1144,1964.5,1970.1025,1977.2748,1978.5,1982.2218,1986.6738,1982.9187,1998.6401,1997.2303,1994.5,1999.2976,2012.75,2010.25,2010.5,2009.25,2008.1105,2021.0575,2036.6647,2050.7014,2030.623,2009.9109,1999.8717,1986.9579,1980.4943,1974.9071,1976.2028,1985.7278,1991.5364,1986.6504,1986.5134,1989.5654,1997.3812,2014.3594,2005.9921,2002.3809,2007.3806,2016.7524,2020.9869,2022.4757,2024.8601,2023.4574,2035.1825,2048.5994,2072.292,2041.7307,2017.5056,2006.6436,1996.8522,1989.9052,1984.9548,1993.5063,2002.4679,2003.6666,1996.7086,1994.8986,1997.5286,2014.175,2026.7737,2019.8843,2010.3243,2016.2294,2024.3527,2034.8431,2035.0973,2034.1234,2047.2908,2058.41,2068.028,2081.8533,2046.053,2034.7045,2024.6324,2011.9032,2002.6399,2002.2267,2011.5563,2013.875,2011.1002,2007.9082,1999.1532,2008.7976,2027.8851,2047.1768,2040.239,2019.9264,2027.8057,2037.1613,2046.1348,2050.5603,2058.202,2075.5408,2086.257,2093.3818,2106.9514,2060.7754,2054.7063,2045.7821,2029.0377,2020.5,2019.5922,2022.2468,2019.8499,2018.8334,2011.8334,2010.8334,2024.473,2044.0938,2060.2844,2042.3055,2029.3392,2047.4487,2047.9059,2062.7695,2070.5498,2083.403,2102.2686,2113.854,2123.286,2137.0173,2081.8594,2078.835,2073.905,2060.9016,2049.1077,2034.3834,2036.6338,2034.2225,2032.5988,2029.8715,2020.68,2033.7103,2049.655,2051.4797,2040.7155,2044.0535,2056.0005,2067.9783,2081.3413,2096.2415,2107.6826,2121.05,2142.4314,2153.5305,2163.1423,2105.0398,2094.0398,2089.1326,2083.0,2075.3577,2053.2915,2057.4832,2059.3975,2053.0,2033.5035,2029.7218,2041.0857,2050.0,2048.7156,2046.0,2057.1785,2070.6882,2090.145,2110.5293,2117.4832,2134.3704,2143.4302,2156.0188,2176.8862,2192.3508,2113.068,2108.0796,2098.1326,2090.2234,2086.005,2072.3748,2067.0417,2073.0251,2056.9595,2038.5658,2040.9185,2045.4448,2052.0278,2052.4263,2055.9883,2071.942,2093.488,2117.8171,2137.1658,2148.7534,2160.4468,2172.2678,2177.4612,2194.0632,2215.219,2111.9563,2104.1594,2095.0056,2091.0928,2086.2285,2078.3628,2071.2556,2063.3142,2048.8237,2047.3561,2050.782,2053.1414,2056.7522,2059.8625,2071.7644,2094.4612,2124.6313,2145.6003,2155.9265,2169.74,2183.7869,2205.2412,2206.9038,2220.088,2231.8682,2116.2615,2111.1697,2101.2659,2093.2178,2084.3635,2079.2708,2074.2974,2059.5474,2056.153,2055.125,2058.8467,2062.25,2064.9187,2071.695,2092.915,2121.4463,2148.0015,2170.837,2185.2598,2188.656,2209.384,2226.987,2235.757,2244.0493,2250.581,2124.169,2118.246,2109.4658,2100.852,2091.4053,2082.3125,2078.5056,2070.7307,2064.5586,2060.795,2066.6565,2073.311,2075.0593,2088.7708,2112.412,2139.0354,2166.6782,2190.5676,2210.0293,2222.3972,2228.1274,2249.3877,2265.8076,2275.2107,2275.965],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD002.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD002.py load and self-test diagnostics complete.")
