####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD001.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD001.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD001.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD001.x3d'),
    GeoLOD(center=(4340924.904807,738180.782603,2188.5),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw000.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw000.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,737558.999947,0),geoSystem=["UTM","Z10","N"],height=[2322.7202,2321.308,2318.896,2317.1558,2313.7847,2310.4397,2307.2476,2303.5835,2300.997,2299.1697,2295.9355,2291.692,2289.0615,2284.8728,2280.3354,2275.5112,2270.4001,2266.2878,2262.8757,2259.7505,2257.3384,2255.3823,2247.9746,2241.1885,2241.875,2249.312,2256.834,2261.825,2263.524,2268.5378,2273.5854,2271.3142,2265.1074,2257.0034,2248.779,2241.526,2231.257,2223.0022,2213.0198,2199.4038,2188.854,2181.6177,2173.377,2167.7122,2166.8523,2166.7803,2167.229,2170.4297,2172.9917,2172.35,2170.7441,2327.3196,2326.4014,2324.7483,2321.5251,2318.924,2315.713,2310.9211,2305.5059,2302.1394,2300.8057,2298.6,2295.0393,2291.5364,2285.876,2278.5244,2275.112,2270.1,2265.576,2262.7517,2258.389,2255.9124,2253.5002,2249.582,2248.9011,2254.5703,2265.0112,2274.6597,2280.0913,2278.941,2280.8083,2285.836,2279.3235,2271.7512,2263.4575,2255.0244,2245.8699,2238.3333,2232.5547,2221.5852,2205.9673,2194.0098,2188.8613,2185.0994,2184.975,2186.8145,2185.2188,2183.5903,2186.0508,2188.5342,2187.0752,2184.0728,2333.8242,2332.6296,2330.0703,2327.1887,2323.4219,2319.4658,2315.6724,2311.2834,2308.6936,2306.101,2303.4014,2299.7876,2295.8281,2288.3472,2280.207,2275.7898,2270.8352,2265.9785,2262.8218,2257.1897,2254.0225,2253.5654,2253.9036,2259.132,2268.1182,2280.8687,2291.1667,2295.7332,2293.9102,2293.4282,2297.153,2290.5603,2279.1812,2269.4727,2259.4182,2251.5835,2248.3083,2239.365,2226.5735,2212.217,2202.9883,2202.1685,2202.9585,2201.717,2203.7068,2203.9585,2202.9585,2202.5115,2205.7466,2203.159,2197.1582,2340.9775,2338.7397,2334.9229,2331.1064,2327.2773,2323.2188,2319.626,2315.9834,2316.975,2315.5566,2311.3123,2306.49,2301.672,2295.7683,2288.064,2279.319,2274.3835,2267.8591,2264.9917,2264.4216,2263.8909,2262.9585,2263.9648,2272.6975,2281.351,2292.0117,2302.6477,2306.9653,2306.47,2303.6272,2305.905,2300.04,2288.4978,2276.7515,2266.815,2260.7087,2257.899,2244.3477,2227.8975,2218.641,2214.7678,2215.5615,2218.942,2217.9468,2222.4526,2223.676,2221.2756,2222.0854,2224.4626,2221.1348,2214.0005,2346.13,2342.7175,2339.084,2334.951,2330.857,2326.6514,2324.657,2323.2537,2322.2537,2321.8386,2319.4265,2316.7751,2311.3687,2305.063,2297.8267,2289.1204,2282.451,2280.2134,2277.3833,2275.5532,2274.693,2273.6716,2275.217,2282.9927,2291.7117,2302.14,2312.935,2317.2239,2316.4478,2312.979,2313.602,2308.7236,2299.2026,2287.1418,2277.5176,2267.7544,2258.5645,2245.6914,2236.143,2232.2756,2230.1162,2233.297,2236.9465,2237.334,2241.7002,2243.615,2240.4343,2238.463,2240.4377,2237.1257,2230.9895,2349.6418,2346.7075,2342.7102,2339.7458,2335.9792,2331.999,2329.6604,2328.6882,2328.6882,2328.6235,2327.5322,2324.2556,2319.8809,2313.3416,2305.5479,2299.6008,2296.9673,2295.6643,2293.8164,2289.9922,2286.3157,2283.0159,2282.2695,2290.3003,2299.92,2310.5774,2319.5305,2323.3655,2322.2869,2319.9773,2319.6187,2316.6497,2306.9736,2295.0503,2283.21,2271.0833,2260.5903,2253.4363,2250.641,2247.473,2247.1294,2251.4497,2255.7805,2258.6636,2262.984,2266.1335,2259.411,2254.4238,2257.3413,2254.1091,2247.0803,2349.5151,2348.9458,2346.5967,2342.5981,2340.9158,2338.774,2336.632,2335.5405,2335.5405,2335.6528,2335.2073,2333.1123,2327.8726,2321.954,2315.7827,2310.5457,2308.6218,2307.832,2304.768,2301.9407,2298.403,2293.8936,2291.3086,2296.095,2305.5251,2317.57,2325.9604,2329.6443,2328.0498,2326.0608,2324.4014,2319.307,2312.0427,2301.2942,2288.1328,2278.6318,2273.4736,2269.9377,2267.2554,2264.0647,2263.516,2271.4045,2277.892,2277.892,2282.41,2283.3894,2275.059,2274.3513,2278.2222,2270.1926,2261.792,2349.0,2347.9177,2347.0,2345.714,2343.5889,2342.6965,2341.6423,2340.517,2340.396,2341.393,2342.2727,2342.9229,2340.0427,2333.9883,2327.5312,2325.8757,2324.3633,2323.0762,2322.055,2318.7834,2313.691,2305.207,2300.317,2301.6338,2311.2551,2323.1282,2332.5286,2336.039,2334.6152,2332.6316,2328.5361,2322.7332,2316.6377,2306.0764,2299.132,2295.0095,2291.1687,2286.6633,2281.8872,2277.7039,2280.9421,2289.6843,2293.8906,2295.173,2298.5054,2304.1162,2296.78,2300.8586,2299.942,2285.7803,2274.714,2346.9258,2344.528,2342.2893,2342.704,2343.7546,2344.7546,2344.0,2344.0,2343.877,2343.7546,2342.8772,2343.7546,2344.5288,2345.019,2342.491,2341.7227,2341.8958,2341.4797,2339.4866,2332.0615,2324.5293,2316.8032,2307.1729,2307.7378,2316.1072,2329.2905,2340.457,2342.3682,2342.1228,2339.7107,2333.0898,2326.282,2320.893,2315.1245,2312.7363,2310.6147,2305.8972,2301.9502,2298.0032,2295.0532,2297.622,2306.8157,2313.874,2315.432,2317.3965,2320.7056,2315.7861,2318.642,2310.5647,2299.002,2291.3376,2339.6472,2337.2883,2335.8042,2335.8042,2337.159,2339.571,2340.3533,2340.3533,2339.3516,2338.3533,2338.3533,2338.5925,2340.196,2344.093,2350.5222,2354.022,2357.0444,2359.2935,2354.767,2345.0107,2332.4536,2322.2046,2313.655,2314.9329,2321.631,2333.5989,2344.361,2349.48,2349.4014,2346.3318,2340.4763,2334.564,2331.8904,2330.4387,2327.5754,2324.6145,2322.2024,2319.9087,2314.6582,2310.9639,2314.0566,2323.1023,2329.8792,2332.077,2334.1582,2334.6528,2331.5059,2332.4763,2321.3062,2311.6943,2301.5703,2330.3936,2328.0996,2326.569,2326.0435,2327.47,2329.1187,2331.0996,2331.0996,2330.0996,2330.089,2330.0747,2330.0996,2332.726,2338.2654,2347.4414,2357.5542,2366.8103,2371.5876,2363.4287,2353.244,2341.1584,2328.1316,2319.3665,2321.4797,2327.716,2337.9866,2348.6348,2356.4292,2356.9192,2355.5771,2352.7117,2348.8745,2345.9792,2344.545,2342.1326,2339.5688,2337.826,2338.8206,2333.7014,2329.0225,2331.3982,2340.2224,2346.856,2350.6694,2354.4585,2350.0657,2349.1196,2345.5483,2333.9126,2325.1763,2315.291,2319.8645,2316.828,2314.3792,2313.1907,2311.9316,2313.847,2314.8965,2315.388,2315.7893,2316.1907,2316.924,2320.634,2323.0461,2326.9993,2337.7537,2353.078,2369.2969,2380.0227,2372.2104,2359.38,2349.4412,2336.1855,2326.6587,2329.5735,2335.9946,2344.24,2353.6562,2363.038,2366.9976,2368.0066,2365.8674,2362.525,2360.408,2360.238,2364.048,2363.8574,2363.409,2362.1501,2353.7666,2348.5208,2348.3816,2357.7856,2365.2346,2369.2363,2369.071,2365.504,2362.3433,2356.2727,2343.971,2334.5044,2328.0813,2306.6228,2301.971,2296.4917,2292.7822,2290.1978,2288.7246,2290.076,2293.8044,2297.2097,2299.7935,2303.5466,2308.539,2313.993,2318.7083,2327.494,2343.9045,2363.5652,2376.0703,2375.6116,2364.5098,2354.8613,2342.8523,2335.5767,2337.852,2343.2732,2349.6912,2360.167,2370.643,2377.7585,2380.6816,2379.7231,2378.1914,2378.4478,2381.1404,2386.415,2387.845,2386.999,2382.094,2376.4575,2370.063,2370.0164,2375.774,2381.9802,2383.965,2381.4314,2377.635,2372.9832,2363.277,2351.1323,2339.294,2333.6543,2290.961,2284.0176,2279.1558,2275.5498,2271.515,2268.4573,2267.149,2272.3337,2280.2307,2285.8713,2289.7686,2294.5674,2302.8574,2311.2395,2321.0085,2333.2283,2353.431,2368.9062,2374.4,2367.6448,2359.7139,2350.1567,2342.6658,2345.0837,2349.4004,2357.051,2367.9736,2379.0942,2387.751,2394.7505,2399.0476,2399.2837,2398.2837,2403.725,2411.7761,2408.6128,2404.4377,2398.9014,2391.2715,2386.5786,2386.1091,2391.2207,2394.2837,2396.1233,2394.2573,2389.8171,2380.5168,2366.895,2355.1792,2341.0188,2335.3552,2276.9622,2271.364,2267.0288,2262.0356,2257.8914,2253.3125,2250.722,2255.0293,2264.9314,2272.8457,2279.8174,2285.439,2291.123,2300.5347,2310.9788,2323.7195,2340.192,2357.0286,2366.7373,2369.2427,2364.4795,2355.9583,2351.5144,2352.35,2357.3813,2366.7495,2376.1455,2387.206,2396.0212,2407.454,2416.564,2421.281,2423.0132,2426.6653,2425.9636,2421.4595,2416.6353,2412.46,2406.3,2400.692,2399.4607,2401.3225,2403.37,2404.3599,2398.9116,2391.224,2377.7505,2365.5823,2352.6777,2336.4612,2328.4443,2265.4573,2259.0093,2251.4585,2246.63,2241.7603,2238.5151,2238.933,2243.7573,2251.4783,2260.0237,2268.9326,2276.213,2283.636,2290.8723,2299.5288,2310.9204,2323.0566,2339.4233,2351.2324,2366.7852,2366.2092,2362.5295,2361.4246,2362.7942,2367.6184,2374.4595,2383.4854,2393.563,2401.7644,2416.2268,2427.7178,2436.5452,2438.8267,2442.7104,2438.7598,2430.5034,2424.161,2417.6714,2411.1028,2408.068,2407.1062,2407.1062,2406.9834,2402.8428,2390.54,2378.9084,2367.7808,2353.0994,2342.5728,2330.1765,2315.5977,2255.3767,2246.984,2240.0298,2234.4841,2229.4634,2225.9797,2228.7605,2234.0525,2240.8796,2248.116,2256.7393,2265.8281,2274.6394,2282.0615,2289.7734,2299.8298,2310.0703,2322.6106,2336.8655,2358.6973,2368.4773,2369.9375,2370.4907,2372.3142,2376.323,2383.629,2392.0845,2400.0967,2408.5784,2421.0095,2433.3108,2444.6143,2451.9517,2449.464,2434.2156,2423.2852,2414.134,2402.945,2396.0786,2394.7297,2394.649,2398.9604,2402.3164,2395.735,2380.996,2369.1462,2356.047,2342.0005,2331.6602,2317.4006,2304.999,2242.3953,2234.8528,2229.1248,2223.3225,2217.8235,2216.0925,2220.482,2226.289,2232.1748,2238.972,2246.482,2255.1233,2263.1472,2271.398,2278.6345,2286.8708,2296.7485,2309.797,2326.0918,2348.0146,2367.6868,2377.2627,2378.6482,2381.196,2387.5833,2393.8699,2401.67,2408.3408,2415.8157,2425.9026,2434.034,2438.5679,2439.498,2428.8435,2418.418,2406.556,2395.1174,2386.3875,2378.5571,2375.2578,2375.481,2380.1238,2385.3047,2383.9497,2372.9348,2362.6162,2348.1436,2332.674,2317.282,2307.429,2295.0107,2231.6367,2224.2246,2218.4004,2212.249,2207.461,2209.6123,2213.5881,2218.0276,2223.8547,2230.9314,2237.4338,2245.3264,2253.4155,2260.267,2268.0713,2276.0813,2283.576,2297.3347,2319.839,2339.466,2358.6516,2374.9346,2381.4578,2388.7542,2394.9275,2402.4062,2408.033,2415.2693,2423.6565,2430.1042,2431.3486,2427.6086,2420.7314,2410.7722,2397.8843,2388.8662,2380.3462,2372.2131,2366.3433,2361.998,2360.9558,2364.5264,2367.316,2366.0679,2360.789,2350.05,2338.119,2323.4214,2310.792,2299.285,2289.0942,2221.121,2214.5198,2209.0764,2202.693,2199.6343,2202.4788,2206.9248,2211.6372,2216.3848,2223.8125,2230.189,2237.2852,2243.6448,2250.6943,2257.5598,2266.9507,2276.878,2291.3625,2311.7495,2330.6116,2348.395,2363.469,2377.5164,2386.9324,2394.9036,2403.2234,2412.4158,2420.1216,2426.96,2428.2761,2420.6235,2410.4875,2400.9573,2390.5457,2379.6401,2371.7683,2365.5076,2359.2625,2353.915,2347.7566,2344.0847,2350.851,2352.1194,2347.6582,2341.1838,2331.6487,2323.8293,2315.4539,2305.6165,2294.79,2282.5723,2210.9333,2205.4597,2198.349,2192.4478,2191.2886,2193.8772,2199.4937,2205.8477,2212.772,2220.593,2226.3765,2232.481,2239.4802,2245.9385,2253.3157,2261.8398,2272.7883,2286.036,2304.6182,2322.1526,2339.6387,2353.5374,2368.9343,2382.3086,2392.292,2402.28,2413.126,2421.9685,2427.0083,2427.9463,2413.4963,2396.8025,2385.395,2372.8276,2364.6602,2358.4238,2352.601,2345.9402,2339.5645,2334.0723,2328.9146,2331.4028,2333.325,2329.397,2323.8987,2318.1924,2310.8435,2303.6055,2297.5884,2287.8884,2272.5664,2200.5652,2194.4072,2189.1074,2184.4617,2183.5818,2187.5432,2193.933,2201.446,2208.6833,2217.194,2223.2695,2229.3108,2234.9763,2241.1372,2246.1216,2253.01,2264.3818,2276.5703,2292.759,2314.685,2332.295,2348.8364,2364.8218,2379.2605,2391.9844,2403.6995,2412.9268,2419.7803,2423.6646,2426.3367,2412.3972,2392.9646,2380.5308,2365.9407,2352.7563,2345.3364,2338.393,2332.7898,2326.707,2319.684,2314.4924,2315.889,2318.6682,2315.1658,2308.2822,2301.5178,2295.6929,2290.8687,2285.069,2274.8147,2260.685,2189.1665,2183.316,2179.022,2176.6943,2178.1177,2182.3542,2188.341,2194.504,2202.654,2211.014,2218.2285,2223.4495,2229.6274,2233.8584,2238.6829,2244.4744,2255.804,2271.978,2288.1064,2310.2734,2327.6008,2345.434,2361.4568,2375.6553,2390.3662,2403.9546,2414.6113,2416.7314,2417.0442,2417.6418,2410.1113,2390.977,2378.3518,2359.7068,2344.5125,2333.991,2324.8767,2318.554,2311.94,2304.2861,2301.0063,2305.155,2306.5374,2302.271,2294.0488,2287.0496,2282.2253,2277.4011,2272.1328,2264.0425,2252.3687,2177.645,2171.6729,2167.6802,2168.3953,2172.4946,2176.986,2181.8103,2186.6345,2193.4663,2204.8247,2212.0234,2216.9314,2221.7556,2226.5798,2231.404,2238.0583,2247.9524,2261.4055,2283.1187,2307.3315,2328.1013,2344.3376,2357.3232,2366.855,2381.3728,2395.8916,2399.6846,2404.137,2408.1824,2408.7952,2401.9993,2386.0442,2372.0898,2355.9846,2339.9421,2325.8018,2313.2256,2304.0422,2298.2039,2292.978,2289.8027,2294.0432,2294.9219,2290.14,2281.4707,2274.9185,2270.4365,2266.27,2261.9617,2254.3376,2240.4316,2165.779,2161.9446,2157.702,2160.117,2165.2751,2170.9272,2174.3633,2178.3796,2186.186,2195.3079,2206.2822,2210.3694,2213.8257,2218.3013,2223.6316,2229.8376,2240.7144,2251.693,2272.4812,2300.6096,2322.755,2340.3745,2353.22,2353.3804,2360.359,2372.607,2376.968,2391.0842,2398.954,2403.116,2394.7524,2379.7375,2365.8113,2351.3208,2334.4133,2319.4006,2304.889,2291.5156,2284.3066,2278.8037,2275.445,2281.496,2283.2751,2277.6064,2268.8306,2262.802,2257.9634,2254.2146,2250.8555,2242.6968,2228.1067,2157.2234,2152.291,2149.5273,2152.4333,2156.6045,2161.0605,2165.706,2169.9268,2178.5374,2186.988,2194.009,2201.509,2206.8303,2210.6545,2216.3228,2223.9272,2233.953,2247.9043,2266.0588,2291.3018,2316.832,2331.5654,2335.363,2335.9758,2341.3708,2348.836,2363.8386,2377.1587,2385.6357,2392.3008,2387.9158,2373.5642,2358.5325,2344.734,2327.5935,2314.4827,2298.8103,2284.4917,2271.9263,2265.3152,2260.8413,2266.5996,2270.5178,2266.246,2259.0098,2250.405,2243.588,2240.395,2236.9597,2228.523,2215.6155,2148.4988,2143.2932,2142.038,2144.5593,2148.326,2152.1982,2155.9744,2162.3896,2169.6265,2178.0679,2184.477,2189.9055,2193.742,2201.0637,2209.5198,2218.9626,2228.911,2244.2493,2260.5288,2282.9797,2308.3582,2320.0215,2316.7385,2318.868,2322.2732,2336.6729,2351.0146,2362.5667,2369.869,2377.8582,2383.1882,2372.2454,2354.0332,2338.0266,2321.2505,2307.836,2293.2517,2279.6755,2265.5786,2254.281,2251.2598,2253.2622,2258.0432,2257.3076,2248.799,2237.823,2228.7705,2225.9526,2223.0527,2213.549,2198.9219,2140.485,2137.4146,2134.442,2136.0154,2140.0474,2143.7024,2147.5146,2153.9807,2160.1292,2168.2341,2175.417,2181.6492,2187.4365,2194.8132,2203.4617,2213.11,2224.0586,2239.2554,2256.2349,2276.7012,2298.7163,2303.013,2297.2925,2298.7273,2310.296,2327.9512,2341.1304,2349.397,2359.178,2370.1887,2377.408,2371.7336,2353.3254,2330.9583,2315.2505,2301.5571,2287.967,2276.9973,2264.5276,2252.8367,2246.326,2245.2507,2247.35,2246.2634,2236.4207,2224.8918,2214.8765,2208.8638,2201.993,2193.0552,2183.4976,2131.2498,2130.9414,2129.1763,2129.649,2132.5396,2135.6755,2139.4172,2144.5947,2150.4219,2157.0366,2165.9646,2174.8186,2184.1846,2190.8972,2198.7944,2207.6836,2219.206,2233.9424,2250.5757,2270.2332,2286.65,2282.3308,2276.7803,2284.7063,2300.9443,2316.4702,2329.0762,2338.099,2348.6396,2363.329,2371.2183,2365.1328,2347.331,2323.8708,2309.7515,2296.6562,2285.8308,2275.5356,2266.1672,2254.0286,2242.6575,2236.9265,2235.4575,2231.0405,2222.3052,2212.6113,2198.2576,2189.6416,2184.8286,2177.4553,2170.3853,2126.8818,2123.8455,2122.3237,2122.7278,2125.1357,2128.2585,2130.96,2134.9197,2141.7202,2150.8994,2161.2234,2171.9224,2180.8086,2186.9812,2193.7222,2202.3323,2213.2808,2228.4045,2244.6504,2262.0322,2269.4792,2261.361,2257.464,2275.061,2290.2458,2302.5981,2314.6677,2328.4678,2340.6165,2352.58,2367.7217,2355.6997,2339.7432,2321.8584,2307.4097,2296.4888,2286.322,2275.228,2265.6548,2252.0337,2240.9001,2230.1184,2222.736,2216.4268,2209.1174,2199.3237,2188.3662,2177.1172,2167.6243,2162.7625,2157.3735,2126.1758,2119.8228,2117.236,2117.0017,2118.3562,2120.269,2123.6812,2126.8892,2132.0137,2143.9932,2156.6387,2166.8408,2174.6309,2180.6614,2186.9297,2194.6106,2206.0022,2218.7761,2236.7483,2249.8816,2249.6348,2244.7847,2248.3662,2267.1118,2277.9968,2288.0679,2303.109,2314.171,2327.4873,2338.6216,2356.852,2356.351,2342.1892,2322.746,2306.9106,2295.1755,2285.2478,2272.2751,2260.4863,2247.2192,2235.1433,2226.6921,2219.441,2209.0793,2198.2258,2187.7466,2177.6816,2167.1245,2154.3223,2148.1052,2145.6926,2126.8818,2119.7637,2114.0537,2111.277,2112.552,2113.9905,2116.4026,2119.3616,2126.1584,2136.2869,2147.5945,2158.238,2167.8557,2174.351,2180.1006,2187.709,2198.4236,2209.8374,2225.2424,2232.1008,2226.9011,2226.55,2240.6494,2253.2637,2264.1938,2275.2632,2289.4504,2299.8552,2309.0508,2324.901,2348.6414,2356.0752,2343.8416,2325.56,2304.048,2288.768,2277.553,2266.452,2253.052,2239.3472,2228.577,2221.9731,2216.0146,2206.3662,2193.8784,2182.5852,2167.956,2157.9905,2145.7126,2134.826,2133.0613,2127.8818,2120.6455,2112.879,2107.095,2106.8784,2108.1455,2110.124,2113.127,2119.9563,2129.5234,2138.3662,2147.7905,2159.2026,2169.0947,2175.2483,2180.6482,2189.988,2199.552,2208.7437,2211.0283,2209.9421,2215.1716,2230.379,2243.7314,2249.7493,2261.9233,2270.996,2285.5344,2299.769,2321.2979,2341.408,2350.8906,2341.5076,2325.2466,2302.6365,2281.5159,2269.5854,2256.5156,2242.5234,2230.3257,2220.373,2216.1304,2210.613,2203.3115,2191.9963,2179.449,2161.6526,2147.993,2139.166,2128.6326,2121.5938,2127.8818,2120.6455,2112.879,2107.1023,2104.2222,2104.2112,2104.8057,2107.1667,2112.6758,2120.0042,2129.1978,2139.8635,2151.924,2161.921,2169.988,2173.5544,2178.7776,2184.9158,2190.6797,2192.9727,2193.3333,2203.7717,2218.5752,2228.5217,2235.54,2245.5945,2258.8367,2276.7214,2292.6064,2312.5398,2332.3508,2336.4485,2329.7817,2317.2754,2298.2668,2276.47,2262.2925,2246.9302,2233.5488,2223.552,2215.052,2208.461,2204.8555,2198.2903,2187.4348,2173.8513,2156.8,2141.1,2132.8052,2124.5674,2116.425,2127.8818,2120.6455,2112.879,2107.1035,2102.6455,2099.8435,2099.7708,2102.6533,2105.5981,2112.0486,2120.697,2130.5847,2144.3704,2154.3748,2160.6597,2163.1611,2166.58,2171.4043,2176.1042,2178.8855,2184.1816,2194.83,2204.117,2214.9417,2218.721,2231.4673,2248.625,2262.9795,2278.689,2297.5593,2312.965,2318.6384,2318.3748,2305.592,2288.5862,2270.737,2257.449,2241.9111,2227.9634,2216.6814,2207.8547,2202.4673,2195.559,2187.8445,2178.452,2165.272,2151.0708,2137.1538,2126.5417,2118.6885,2110.408,2126.8818,2120.571,2112.4092,2106.4636,2102.291,2098.4668,2096.0662,2097.3306,2100.7456,2105.985,2113.591,2123.3062,2135.6077,2144.7102,2150.955,2151.849,2155.079,2160.1667,2164.6035,2167.1553,2176.2021,2184.694,2191.6802,2198.9583,2203.5078,2221.2852,2235.9546,2249.5264,2263.2573,2279.2183,2292.1416,2298.034,2303.152,2296.5798,2279.7349,2263.4585,2251.0562,2237.383,2224.7715,2214.1157,2205.4983,2199.9412,2193.3042,2181.8645,2169.1736,2156.7598,2145.2102,2133.0674,2122.742,2110.0063,2104.6248,2125.8818,2119.6455,2111.8523,2106.1152,2101.291,2098.177,2094.811,2093.9436,2094.9495,2100.1326,2106.369,2115.506,2124.3435,2133.909,2140.1938,2140.718,2143.6575,2149.9106,2154.8494,2158.4094,2165.6196,2171.8357,2179.0361,2184.0876,2193.322,2207.7073,2221.1646,2234.8655,2246.8184,2260.0771,2273.9438,2283.1904,2289.5056,2286.5154,2269.0547,2254.3591,2243.1758,2231.1152,2220.4775,2211.6077,2203.6184,2198.169,2191.8271,2181.235,2169.012,2153.8418,2142.365,2131.618,2119.961,2106.439,2098.2634,2124.541,2118.22,2111.4092,2106.0874,2101.1199,2096.2334,2093.8213,2091.7148,2092.5205,2095.45,2100.2068,2107.3857,2115.5066,2122.7778,2128.5386,2130.0696,2132.525,2137.3796,2143.0793,2150.6248,2156.424,2161.7908,2166.615,2171.9934,2182.766,2193.6367,2206.5095,2217.386,2229.84,2243.6719,2259.9375,2270.2815,2276.8408,2273.5642,2260.244,2248.5142,2238.1025,2227.2393,2217.0513,2208.8057,2202.5264,2196.9998,2188.9329,2179.0151,2170.5654,2157.5872,2144.3276,2130.51,2115.8435,2103.9182,2095.5815,2125.7905,2119.4739,2111.836,2106.1099,2101.291,2096.4668,2092.9124,2090.5002,2089.9976,2089.6887,2093.8525,2100.231,2108.228,2114.4065,2119.273,2121.3545,2122.392,2124.9065,2132.8616,2141.065,2147.3086,2151.5046,2156.0015,2163.1208,2173.21,2180.5833,2189.323,2200.4255,2215.0417,2230.2407,2243.9167,2251.6897,2259.3962,2263.7883,2253.618,2243.6616,2233.4292,2223.3647,2214.0493,2206.7554,2200.7097,2196.4333,2188.9387,2179.76,2168.6577,2158.7432,2147.2856,2131.3796,2115.9827,2102.501,2092.2466,2129.4534,2123.3154,2115.7441,2108.8428,2103.2715,2096.545,2092.8213,2090.4092,2087.997,2085.4458,2086.9844,2094.048,2100.9495,2106.1858,2110.9465,2113.8828,2114.1946,2116.6106,2122.0325,2128.5774,2134.1875,2139.7112,2145.9019,2152.6946,2157.9158,2164.676,2173.4668,2187.8262,2199.1345,2210.167,2222.2866,2232.7285,2237.016,2246.8755,2248.1743,2238.3442,2228.161,2218.832,2212.5654,2204.664,2197.8215,2193.1243,2187.29,2180.1484,2168.643,2158.8274,2147.4587,2132.957,2120.4087,2104.9697,2091.4402,2135.1655,2128.168,2120.8193,2113.695,2106.4587,2097.6946,2093.5825,2091.1704,2088.7559,2085.4858,2084.0,2089.7747,2094.7805,2099.7952,2103.3057,2105.843,2106.6448,2108.3596,2113.298,2118.789,2123.1301,2126.5544,2132.642,2140.8022,2144.9333,2150.9912,2162.4197,2172.4026,2184.169,2190.644,2202.2583,2212.0762,2218.4846,2226.2744,2235.5854,2231.295,2223.8508,2216.3755,2210.4182,2203.1243,2193.9053,2187.2717,2182.4363,2176.231,2168.5208,2159.7559,2148.4438,2135.3257,2122.0737,2106.6772,2093.2014,2141.444,2135.0425,2127.9712,2120.5476,2113.4985,2105.306,2096.1626,2092.5964,2089.9946,2086.2476,2083.1729,2085.2913,2089.9282,2093.6887,2096.0117,2097.3467,2096.925,2100.8618,2105.4756,2109.6997,2112.1987,2115.8516,2122.5684,2128.095,2130.2866,2137.9297,2149.3264,2156.4065,2163.2249,2171.4832,2184.7227,2191.043,2198.3499,2208.9692,2217.2173,2222.2993,2219.439,2212.5376,2206.8235,2200.2478,2189.9475,2179.232,2175.4229,2170.771,2166.134,2160.2458,2150.0193,2135.622,2122.7488,2108.7886,2095.7566,2147.1091,2140.8726,2134.1665,2127.0137,2119.5596,2111.1606,2102.016,2094.432,2090.6086,2086.9438,2083.1729,2082.6257,2085.824,2088.8364,2089.9565,2090.7727,2091.1592,2092.8713,2095.6697,2097.4683,2099.2986,2104.0137,2111.3894,2115.2302,2120.3362,2126.5815,2135.7793,2142.9849,2147.742,2158.1584,2164.9136,2171.2407,2180.6013,2190.7786,2201.0725,2210.045,2211.638,2204.6648,2198.0574,2192.5105,2181.4011,2169.7263,2166.9229,2165.029,2162.9336,2159.4973,2149.8127,2135.622,2123.5615,2111.1145,2099.054,2151.9497,2145.725,2138.4888,2132.2126,2123.9763,2114.9731,2106.1133,2096.267,2090.994,2086.5684,2083.3057,2075.702,2079.13,2083.944,2085.3772,2083.9927,2084.1406,2085.5527,2085.836,2085.801,2085.8386,2091.522,2096.377,2104.3625,2111.0583,2116.8677,2123.6433,2128.4675,2135.0977,2144.7473,2150.9375,2155.7246,2162.4426,2170.2666,2181.7734,2190.2075,2198.9072,2194.9033,2184.6365,2177.3855,2168.3613,2156.2139,2154.7468,2155.1619,2159.7532,2157.4475,2148.6692,2135.622,2124.049,2112.501,2100.4402,2155.8137,2149.1665,2142.341,2135.6387,2126.8826,2116.9333,2107.285,2097.9119,2090.991,2084.7039,2079.8796,2073.9275,2071.837,2077.1316,2078.1262,2074.8345,2074.7622,2075.136,2074.546,2072.67,2074.5908,2079.2231,2084.2153,2093.409,2100.6484,2106.6921,2112.2874,2117.3364,2123.4226,2130.7104,2135.8772,2140.7014,2146.8855,2155.6558,2162.0234,2170.871,2183.5117,2179.8767,2170.3962,2160.0542,2152.1528,2143.8613,2140.226,2146.4172,2151.8145,2153.8167,2148.0095,2135.587,2124.049,2112.501,2100.295,2159.7424,2152.5376,2144.8281,2137.0713,2128.1577,2117.6174,2108.1772,2098.5923,2090.991,2084.1697,2078.3455,2073.5212,2067.6343,2073.1714,2073.6887,2068.54,2066.0557,2065.4312,2063.5256,2061.9526,2063.4873,2067.2212,2072.8325,2080.1133,2087.797,2093.6729,2100.0054,2104.3132,2110.0298,2113.9617,2119.7935,2124.718,2130.4229,2137.9783,2143.6577,2148.8225,2158.1133,2161.9702,2151.9902,2141.64,2134.3105,2127.0964,2126.6902,2134.2632,2141.949,2148.6912,2147.673,2134.7217,2123.1045,2111.6086,2098.2698,2162.5186,2154.9639,2146.8772,2139.4912,2130.3403,2119.7292,2109.6033,2099.9548,2092.3093,2085.073,2076.746,2069.645,2060.2832,2061.004,2067.5984,2061.7761,2057.7449,2056.3328,2054.9207,2053.1902,2052.106,2056.4895,2063.0442,2067.096,2072.0085,2078.7952,2083.7976,2088.1724,2092.9434,2098.2954,2104.3206,2111.6997,2115.911,2119.2856,2124.3782,2131.436,2137.486,2140.075,2135.64,2122.4624,2110.3713,2105.1074,2114.1497,2121.6892,2129.8745,2141.9832,2145.3813,2134.2522,2121.2432,2110.1824,2095.2212,2166.446,2158.0466,2150.0183,2141.9175,2133.071,2122.678,2112.641,2102.821,2094.481,2087.4993,2078.4358,2069.0266,2060.7903,2054.5432,2057.4612,2056.1028,2050.243,2048.236,2047.642,2044.8306,2042.0731,2044.8347,2050.8223,2055.8547,2059.8738,2064.295,2068.3745,2071.3655,2075.6438,2083.5046,2089.6892,2095.3926,2098.937,2101.1213,2103.7346,2109.5588,2116.1807,2119.5422,2111.0273,2097.5525,2089.0103,2089.2883,2097.1143,2107.705,2118.4731,2131.214,2137.5156,2132.0574,2118.817,2107.7563,2093.0076,2171.5173,2161.987,2153.6602,2145.3535,2135.8132,2127.0417,2117.6265,2107.569,2098.503,2090.5813,2081.0327,2072.3843,2063.565,2052.7893,2046.8292,2048.3945,2044.939,2042.6583,2041.5554,2038.6774,2033.9324,2034.8481,2039.6913,2043.3307,2046.4417,2052.3333,2056.159,2059.15,2063.84,2069.3486,2073.9436,2078.7678,2081.6982,2081.9395,2084.5225,2087.8716,2092.1912,2092.0415,2079.9631,2076.3801,2070.9878,2074.6252,2083.191,2091.4023,2106.7063,2119.8098,2127.4153,2127.0273,2115.2197,2103.313,2091.5815,2176.3699,2167.7214,2158.0728,2148.8042,2139.776,2131.5852,2122.479,2113.1833,2104.1821,2095.5334,2085.885,2076.333,2066.9912,2056.8125,2046.0486,2040.0973,2037.4911,2037.209,2036.806,2034.5465,2029.527,2025.0149,2027.6959,2030.3844,2035.6433,2041.6389,2046.4542,2050.2783,2053.5532,2057.5344,2060.1125,2063.6907,2066.3118,2066.7354,2068.3042,2069.9512,2072.1448,2071.8938,2063.088,2060.9531,2058.129,2063.3037,2070.463,2078.3813,2090.614,2102.0776,2112.4749,2116.2815,2109.0615,2099.8037,2088.8433,2181.9119,2172.5737,2162.9253,2154.2205,2143.6284,2135.7466,2127.5103,2119.2737,2110.0344,2100.386,2090.7375,2079.8496,2069.4172,2059.7053,2048.6082,2040.3597,2033.7001,2031.2018,2029.7859,2027.9412,2025.0051,2020.6162,2019.9589,2021.3188,2026.7072,2032.9017,2036.7396,2040.5542,2043.3921,2046.5414,2049.955,2052.3777,2053.9048,2055.891,2055.8904,2054.8809,2054.825,2053.8599,2048.7695,2045.1001,2045.3075,2050.725,2057.967,2066.629,2076.0837,2085.8662,2094.851,2102.0137,2101.9663,2095.3542,2085.729,2186.4634,2176.9768,2168.3079,2159.5527,2148.5757,2140.021,2132.7317,2124.31,2115.8867,2106.2383,2095.5898,2084.7021,2072.0002,2061.195,2051.5466,2042.8981,2034.7147,2026.1517,2022.1012,2021.6517,2019.7034,2016.9027,2015.3285,2015.0212,2018.8455,2021.6656,2025.5951,2029.4194,2031.9983,2034.8597,2037.4043,2040.0017,2042.6467,2044.6094,2044.9081,2042.6227,2039.7612,2037.7985,2034.0376,2033.5522,2037.0333,2042.4081,2048.2556,2057.2263,2064.72,2071.6453,2080.9573,2088.9797,2093.69,2090.3567,2082.3027,2186.6245,2179.521,2173.1604,2164.9312,2156.2449,2145.6267,2138.0906,2129.905,2120.7393,2111.0908,2100.4424,2088.8884,2075.8425,2064.4333,2053.5562,2044.2261,2035.1002,2027.116,2020.7671,2015.2429,2013.2551,2012.8882,2010.4761,2009.4105,2011.9199,2015.2499,2017.7223,2019.2272,2021.7429,2024.155,2025.6915,2028.1036,2030.5157,2031.622,2031.622,2030.4917,2027.0796,2023.713,2022.4976,2024.2761,2029.5876,2034.5789,2039.5406,2045.7788,2053.1396,2060.376,2068.276,2077.8394,2083.9214,2085.2612,2078.9155,2179.3806,2176.8938,2173.1255,2167.4573,2160.2383,2151.6074,2143.0674,2135.1328,2125.8936,2115.943,2104.4153,2093.574,2081.5896,2068.2856,2056.0815,2044.7505,2035.8003,2027.8638,2021.6274,2013.693,2010.0156,2008.6981,2006.6924,2004.9098,2005.5112,2007.1099,2009.9198,2011.9277,2013.2659,2014.0945,2013.4908,2014.8271,2017.6545,2019.4908,2019.4908,2017.3607,2014.9486,2012.5365,2013.1592,2016.6519,2021.4761,2026.3003,2031.1245,2036.647,2042.4712,2048.471,2055.4812,2067.3335,2077.217,2079.668,2075.9802,2169.1677,2168.3276,2167.9436,2165.6016,2161.291,2155.428,2147.9197,2140.6833,2132.172,2121.0784,2108.3198,2097.3245,2084.9963,2073.0918,2059.3496,2046.289,2036.0186,2028.8638,2021.7179,2016.265,2011.8171,2008.6395,2004.4547,1999.9526,1998.544,1998.825,2002.237,2004.6492,2005.8159,2005.8159,2004.7146,2003.7106,2005.5741,2007.6658,2008.1646,2005.9578,2004.5457,2003.0879,2002.9933,2007.6451,2013.2494,2018.2937,2023.1138,2027.4753,2032.7664,2038.5906,2043.5953,2051.3574,2068.529,2076.9087,2072.381,2156.5828,2156.1106,2157.0022,2158.0657,2157.5745,2153.968,2149.6426,2144.3816,2136.1453,2125.8179,2112.3184,2100.9575,2087.85,2074.8362,2061.3,2048.852,2038.9545,2030.306,2022.9059,2018.0817,2014.2058,2010.7937,2005.682,2000.6305,1995.2094,1989.5436,1992.65,1996.0621,1998.383,1998.5374,1997.3982,1994.3088,1994.139,1995.4877,1996.2289,1995.363,1994.383,1993.4287,1994.9603,1998.1288,2003.6398,2009.0988,2013.565,2017.8102,2022.0615,2026.9441,2032.6581,2039.6854,2051.0046,2066.165,2063.0293,2152.178,2145.721,2143.5312,2143.2253,2143.4524,2144.6782,2146.3625,2144.4094,2138.5728,2130.9111,2116.5444,2103.3835,2090.6716,2077.2256,2064.5828,2053.6096,2042.3806,2033.4442,2024.26,2018.9274,2013.9506,2011.0591,2005.682,2000.1036,1994.9753,1988.1414,1985.7556,1986.022,1988.9236,1990.2587,1990.1599,1985.8757,1984.2587,1984.3871,1984.6782,1985.2587,1984.6782,1984.8318,1987.838,1991.816,1995.11,1999.1145,2003.1191,2007.1924,2011.7764,2016.181,2022.6687,2030.3685,2039.6292,2049.0747,2052.2556,2153.8884,2146.652,2139.9426,2135.109,2131.9868,2133.7417,2135.968,2136.5645,2136.9868,2133.7612,2120.0432,2106.815,2093.1045,2079.6953,2068.1104,2059.462,2045.8069,2036.1584,2024.7708,2020.4734,2013.1617,2008.6437,2005.2289,2000.6317,1995.8063,1989.9886,1986.1605,1982.1678,1981.2172,1981.9735,1981.9735,1980.5016,1978.9808,1975.6761,1975.7001,1976.1094,1976.4348,1975.9801,1979.7065,1984.5308,1988.3616,1991.583,1993.9735,1996.4034,2001.4978,2006.4828,2011.9661,2019.2687,2027.4233,2034.7532,2038.2676,2156.1758,2147.6455,2140.4092,2134.148,2129.126,2125.8025,2125.4475,2127.0916,2129.2717,2131.2686,2123.3198,2111.1003,2098.0413,2085.9446,2073.1897,2063.8179,2049.5361,2039.6135,2032.305,2024.0247,2016.5876,2010.0723,2005.8876,2000.7352,1995.8063,1991.4199,1987.1577,1981.861,1975.5093,1973.5671,1974.1343,1973.9258,1973.1946,1970.8284,1969.4163,1968.2687,1968.5034,1969.6559,1971.4346,1975.3843,1980.0005,1983.6464,1985.7015,1987.5558,1992.9471,1998.2042,2003.5956,2007.8955,2014.299,2020.0818,2023.538,2157.0762,2146.7864,2139.9536,2132.3137,2127.9863,2122.4995,2118.9873,2118.3652,2119.4233,2120.4814,2121.3064,2114.0088,2104.0203,2092.268,2079.79,2066.5164,2055.5928,2048.4004,2039.328,2029.8956,2020.8285,2013.9971,2008.3137,2000.3308,1996.319,1992.8411,1988.5195,1983.3594,1977.3683,1973.2499,1969.1526,1967.355,1966.4229,1965.976,1963.5638,1961.282,1961.3584,1962.3773,1963.8411,1967.9802,1971.8044,1975.6287,1978.284,1979.991,1984.3804,1989.9255,1995.4607,1999.7043,2004.0515,2009.3635,2012.8757,2159.7031,2148.383,2141.3586,2133.0286,2129.1147,2123.2039,2119.8213,2117.4092,2115.2844,2114.8816,2113.8875,2112.3044,2108.9822,2099.031,2084.091,2071.4775,2064.9558,2056.2107,2046.359,2036.1742,2026.3473,2020.7742,2014.3104,2006.3492,1998.2064,1994.2672,1989.2778,1984.3335,1978.9698,1974.2151,1967.0764,1961.8625,1961.4296,1960.3423,1958.7114,1957.4296,1957.4296,1957.4296,1958.5109,1960.923,1964.5258,1968.3501,1971.1486,1972.8567,1976.8228,1981.647,1986.4712,1991.2739,1994.9806,1998.6587,2002.171,2169.9033,2155.7456,2147.5435,2140.3071,2132.4617,2126.4116,2121.4055,2118.4092,2116.7092,2115.2964,2114.1228,2112.4722,2109.4492,2100.4387,2090.8057,2082.926,2071.9346,2063.4915,2054.349,2046.0822,2036.074,2029.0527,2021.8164,2013.8153,2003.4368,1996.687,1990.5696,1984.3335,1980.2915,1975.685,1968.7711,1962.748,1959.1818,1954.3595,1953.5771,1952.5771,1952.5771,1952.5771,1951.2322,1954.1982,1958.0564,1961.8975,1965.5922,1968.0043,1970.4164,1974.1896,1978.384,1983.2299,1985.9889,1988.9539,1991.5562,2179.6082,2164.8416,2153.749,2146.448,2136.4539,2128.8057,2123.4883,2119.5469,2118.275,2118.1377,2116.3103,2114.8982,2111.6238,2108.0933,2100.438,2091.096,2081.0508,2070.454,2063.178,2055.9417,2047.7499,2039.469,2031.2639,2021.8115,2012.4285,1999.3925,1992.9323,1986.7527,1981.4016,1974.7322,1969.8008,1964.0366,1958.3185,1951.5258,1949.0388,1947.9746,1947.587,1946.6263,1946.6376,1948.3125,1951.08,1954.9304,1959.602,1962.5082,1963.4263,1966.0897,1970.2042,1973.7278,1977.0043,1979.4869,1982.4923,2190.7112,2174.4797,2160.8352,2150.7942,2140.6365,2131.0305,2125.949,2123.8699,2122.69,2120.8936,2118.7366,2118.4595,2116.8435,2113.0005,2107.5327,2100.7686,2092.7886,2083.6604,2074.9404,2066.7742,2058.9514,2051.3015,2042.3916,2031.5164,2020.5312,2008.2014,1996.538,1990.5339,1984.8278,1977.1553,1971.3551,1964.1188,1959.7163,1954.6493,1950.8458,1946.6663,1940.3516,1938.3085,1941.2389,1943.651,1946.0631,1949.2512,1952.3235,1954.5493,1954.2714,1956.6835,1961.2184,1965.417,1968.7961,1972.1519,1973.9205,2200.44,2186.24,2168.7837,2155.2676,2143.5684,2133.6877,2129.9883,2129.9702,2128.9702,2127.555,2124.962,2124.9678,2123.3186,2119.9065,2117.4797,2112.2966,2105.0505,2096.807,2089.692,2083.7751,2073.1462,2069.8325,2059.0571,2045.6307,2030.9718,2017.9062,2002.4419,1994.4886,1989.244,1981.0176,1973.7812,1967.5398,1963.1925,1957.7662,1949.571,1946.6095,1940.9055,1937.0356,1937.3765,1939.7964,1941.2107,1943.6288,1947.02,1948.0242,1947.1807,1948.2738,1952.3568,1957.1062,1961.0104,1964.0288,1963.3586,2205.298,2191.291,2176.59,2161.178,2149.0598,2140.085,2136.7395,2137.911,2138.0784,2135.251,2134.0813,2134.398,2132.1587,2129.2117,2127.6055,2122.936,2116.1814,2108.945,2104.3733,2097.8162,2091.7634,2084.97,2074.2527,2061.6023,2042.6677,2027.611,2013.1383,1999.0547,1992.2396,1984.7864,1975.2482,1970.4529,1965.6287,1960.4984,1953.3964,1948.518,1942.5989,1937.0912,1931.335,1933.1136,1934.6051,1939.0214,1942.1737,1942.406,1941.3282,1940.6909,1944.4147,1948.8268,1951.8228,1952.335,1952.829,2202.4375,2188.6848,2176.9758,2163.297,2152.723,2146.0308,2147.391,2149.8032,2150.2092,2147.797,2147.0396,2148.2122,2145.8066,2140.2122,2139.7366,2136.279,2130.1548,2122.0762,2117.0881,2113.1282,2116.982,2103.9236,2082.083,2067.763,2052.073,2036.6205,2021.0006,2008.2299,1995.7422,1987.2125,1978.6227,1972.3607,1967.161,1961.0822,1955.4508,1950.4724,1943.83,1937.9408,1926.0159,1925.2513,1924.6935,1932.0417,1938.3278,1939.1576,1936.6113,1935.1971,1937.7996,1940.5482,1943.041,1944.3882,1944.7845],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD001.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD001.py load and self-test diagnostics complete.")
