####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD000.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD000.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD000.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD000.x3d'),
    GeoLOD(center=(4340937.286173,738193.374947,2183.000000),child1Url=["SquawLOD001.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD001.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw000.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw000.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,737558.999947,0),geoSystem=["UTM","Z10","N"],height=[2324.9653,2320.9875,2315.0154,2306.1682,2300.0,2293.2742,2285.5137,2275.2021,2265.4639,2259.2517,2253.574,2244.6365,2259.8962,2271.5208,2277.7498,2272.1904,2256.2598,2238.803,2221.9001,2194.0322,2179.4846,2176.8438,2174.8855,2180.284,2177.2117,2336.857,2330.9355,2323.0283,2314.1287,2312.859,2303.3254,2291.5847,2277.3455,2267.173,2258.6511,2257.7917,2269.4685,2291.0833,2302.7395,2301.0232,2290.8455,2268.0593,2256.7637,2232.4062,2210.7732,2211.6875,2213.4438,2213.5833,2218.1216,2205.9678,2347.8396,2338.9893,2330.878,2326.8264,2326.7395,2322.0183,2311.1694,2295.998,2291.5308,2283.9607,2278.9937,2290.1555,2311.0833,2320.7954,2317.7598,2310.347,2286.888,2263.7683,2246.012,2240.3923,2247.266,2253.0671,2254.5872,2250.4465,2241.0198,2349.0,2345.9182,2341.8784,2339.6467,2339.6355,2340.5315,2329.9092,2320.1733,2317.2708,2313.4097,2300.0703,2301.1104,2324.0195,2333.679,2330.0945,2319.0608,2298.8635,2287.077,2277.761,2274.0571,2288.2048,2291.5615,2289.2422,2294.3215,2269.9468,2340.482,2338.4688,2341.2463,2342.3125,2340.413,2340.3125,2344.8386,2351.02,2355.0625,2341.0696,2318.8005,2313.3352,2336.0312,2347.5312,2342.3599,2328.8499,2324.7124,2319.5986,2311.3003,2307.9536,2323.976,2327.923,2326.4963,2318.4297,2298.8706,2320.968,2316.987,2318.026,2320.337,2320.1458,2322.646,2328.5774,2354.2273,2379.8286,2357.2305,2332.0435,2328.8176,2345.293,2362.7117,2364.2385,2357.788,2356.9275,2355.363,2351.3396,2342.7283,2359.5767,2365.8542,2359.6047,2342.4219,2325.4512,2289.63,2279.6287,2272.6611,2274.0505,2287.3413,2296.2554,2312.2139,2334.6924,2370.6013,2366.5295,2347.436,2344.7134,2357.9978,2380.747,2393.7383,2394.6052,2405.6555,2403.243,2390.496,2382.4202,2391.4314,2392.4412,2380.799,2355.1802,2335.57,2264.3286,2251.3523,2241.646,2243.8562,2260.0854,2276.8647,2291.48,2312.5688,2342.4714,2368.4502,2360.7751,2362.0884,2375.7195,2395.3127,2420.1372,2436.0269,2439.5725,2426.4067,2413.6035,2406.2188,2406.7395,2394.5723,2370.4268,2344.6948,2317.0286,2239.5154,2226.5833,2216.9517,2225.3394,2238.5276,2254.6406,2271.9082,2287.8794,2311.5781,2351.1357,2376.9185,2381.0046,2395.297,2409.746,2428.552,2442.1177,2425.073,2401.353,2382.5366,2377.066,2386.14,2375.9023,2350.463,2319.2847,2295.917,2217.689,2205.4387,2201.879,2210.8042,2222.5127,2236.5522,2250.5295,2266.9302,2292.083,2332.804,2366.7017,2388.7454,2405.7842,2422.267,2426.0156,2407.4763,2385.388,2369.0596,2356.63,2345.3315,2352.9792,2343.678,2325.305,2306.4805,2282.8215,2197.4897,2186.5234,2185.9612,2199.451,2215.2957,2228.292,2240.6865,2252.862,2276.9675,2316.7598,2351.0596,2381.8408,2406.3103,2421.241,2422.6702,2386.7927,2358.9224,2341.5789,2328.9822,2315.7166,2318.2798,2309.988,2296.38,2285.6785,2260.6096,2174.0283,2167.198,2175.0654,2185.0125,2202.001,2215.9065,2225.75,2237.4822,2261.4197,2309.281,2346.6187,2368.9333,2396.3972,2405.0796,2407.2124,2379.6624,2347.6848,2318.1946,2299.7734,2288.9966,2294.5972,2282.4473,2270.4316,2261.8428,2239.7207,2153.7627,2150.2397,2158.641,2167.5505,2184.8252,2199.167,2209.489,2223.2717,2248.0825,2293.0398,2332.5024,2335.2993,2350.948,2379.933,2391.4192,2365.999,2336.2917,2305.1143,2275.252,2260.4133,2269.4287,2259.4453,2243.134,2235.9065,2213.8813,2137.4187,2133.4062,2141.34,2151.128,2164.986,2179.4377,2193.4207,2212.1426,2239.1355,2277.8887,2299.437,2298.2485,2330.3562,2350.9128,2373.0735,2362.344,2321.561,2292.4736,2268.993,2247.4878,2246.1177,2236.6997,2213.983,2200.1494,2181.596,2124.0334,2121.0068,2125.444,2132.325,2147.5308,2170.2722,2185.6624,2200.7153,2227.212,2262.125,2257.221,2277.032,2302.6958,2331.0476,2357.4478,2348.2578,2313.6235,2291.3516,2268.7212,2243.074,2223.9531,2208.2266,2187.699,2165.5754,2155.489,2123.0398,2111.1345,2112.046,2116.9836,2132.0735,2154.5024,2172.732,2185.9114,2208.0266,2226.6338,2224.9326,2253.7698,2275.366,2299.2874,2334.2046,2352.643,2312.9353,2280.4714,2256.0942,2229.1648,2216.706,2195.387,2167.871,2145.0159,2130.802,2124.0398,2109.0796,2102.6108,2105.053,2116.31,2135.7087,2159.5554,2171.093,2181.3179,2189.1858,2203.0193,2225.828,2245.494,2278.5652,2317.9792,2330.9976,2305.603,2266.9282,2236.3794,2215.7856,2203.067,2187.5674,2157.065,2130.9644,2114.6665,2123.0398,2108.1038,2100.0662,2095.6077,2102.93,2119.24,2140.9138,2148.4307,2156.98,2165.2207,2182.2034,2195.0364,2221.0647,2249.4973,2279.5557,2295.79,2285.7078,2253.7493,2227.6665,2207.158,2194.6296,2171.0723,2144.6003,2122.7214,2102.3762,2120.3975,2107.1191,2097.4902,2092.0928,2093.1655,2103.4897,2118.5825,2126.856,2132.8418,2148.3335,2159.013,2171.4033,2192.3164,2214.525,2245.9062,2267.528,2264.1133,2240.6035,2219.428,2203.6758,2191.173,2171.4016,2147.0796,2115.7366,2094.59,2128.3538,2113.7383,2099.5217,2091.0928,2086.1191,2090.917,2103.0098,2110.8325,2113.2578,2124.7114,2134.596,2149.0989,2160.2847,2186.8389,2205.9124,2228.2722,2243.7644,2229.7454,2213.6575,2198.5771,2186.4407,2170.279,2148.9812,2122.0593,2091.569,2140.9006,2126.0237,2111.7751,2094.4736,2087.2385,2083.5662,2091.1287,2094.1355,2097.4617,2104.8398,2111.7244,2122.7493,2135.4744,2151.8435,2169.7212,2185.632,2207.1077,2218.7957,2205.8276,2190.9478,2173.0654,2165.687,2151.5774,2124.1138,2097.2847,2150.5435,2136.6162,2119.5186,2099.6245,2086.896,2075.5461,2079.895,2080.1848,2080.5645,2079.4792,2086.176,2100.767,2113.8228,2124.9128,2140.4238,2151.0977,2166.2783,2188.443,2179.8228,2162.4153,2147.4792,2155.8467,2149.234,2124.491,2100.2463,2157.2585,2141.338,2122.4836,2101.5898,2086.3577,2072.1865,2066.6829,2065.7646,2060.1743,2057.1802,2062.2903,2073.8398,2087.9526,2097.7532,2107.835,2119.9558,2131.1567,2142.6584,2145.9395,2122.7207,2117.6145,2134.197,2147.8433,2122.895,2096.0276,2164.4211,2147.3105,2128.449,2107.756,2090.7258,2071.9512,2053.1858,2050.7576,2044.8158,2040.3408,2039.5746,2048.7751,2057.8716,2065.3643,2076.7004,2087.301,2090.7336,2099.8538,2096.5105,2079.262,2086.8228,2109.5564,2132.3738,2117.7456,2092.1267,2175.3516,2155.4575,2136.5537,2119.6697,2100.7756,2079.8816,2060.5425,2039.064,2033.5857,2030.1298,2021.7429,2024.6833,2037.4585,2045.045,2051.9612,2056.992,2059.7747,2060.5603,2055.6511,2049.2534,2059.773,2079.2554,2100.0024,2105.3274,2087.0,2183.0398,2167.2383,2145.7896,2130.518,2111.706,2089.7144,2064.0708,2043.8868,2026.7015,2016.9369,2014.0491,2010.8505,2017.3629,2022.2985,2028.1575,2033.0164,2035.4271,2032.3546,2025.9757,2030.5636,2040.9741,2055.7178,2071.042,2086.3674,2079.793,2171.6807,2167.9165,2157.2734,2141.438,2122.6462,2097.877,2073.021,2046.0736,2028.6758,2015.5236,2008.2782,2000.1693,2001.4292,2007.3513,2007.7113,2007.2698,2011.6007,2007.6805,2005.1497,2013.7269,2024.5941,2034.541,2045.8596,2071.971,2073.76,2148.9946,2144.8213,2146.8164,2147.0024,2132.5564,2104.7805,2077.9065,2052.8853,2032.721,2018.5035,2011.2332,1998.6233,1986.3612,1989.1201,1991.8646,1985.8832,1986.8195,1986.8403,1988.3744,1995.3696,2004.7123,2013.6348,2024.0306,2041.3285,2055.0593,2151.0632,2137.0696,2127.1123,2128.8562,2132.839,2112.7407,2085.8926,2063.6086,2038.1552,2022.7683,2009.2887,2000.2975,1990.3347,1979.0836,1974.5989,1974.9688,1970.9791,1969.9584,1971.4836,1979.9353,1986.4255,1993.8188,2004.7659,2016.0797,2025.9412,2153.0288,2135.1968,2125.1746,2118.0684,2115.07,2113.1772,2099.6404,2070.5574,2054.8281,2034.204,2018.7618,2003.1704,1992.6544,1982.6998,1971.7834,1962.0486,1960.4858,1958.0243,1958.5583,1964.5562,1971.5297,1976.9335,1986.9047,1995.8517,2003.4637,2170.8435,2149.0012,2131.0735,2120.0928,2117.941,2114.941,2108.1287,2090.805,2069.4988,2054.519,2037.5396,2019.0239,1997.6035,1984.6565,1972.7686,1961.8215,1949.4705,1948.6134,1947.118,1950.6299,1959.0636,1963.6073,1970.6046,1977.5767,1983.1978,2193.6,2159.9573,2136.1438,2129.7275,2127.838,2124.705,2119.891,2112.2212,2096.1343,2082.257,2068.0586,2041.5135,2013.6125,1992.5615,1978.0012,1965.2617,1952.708,1942.8772,1936.6035,1940.7192,1946.6443,1947.7572,1952.0887,1961.0941,1963.7866,2193.4783,2168.367,2147.942,2149.265,2148.4768,2148.3577,2140.68,2136.6267,2122.0334,2112.7974,2100.919,2064.7893,2031.9758,2003.0729,1983.9452,1970.693,1957.8745,1946.3912,1930.3688,1924.9022,1937.2402,1937.3232,1937.1929,1942.8427,1944.7362],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD000.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD000.py load and self-test diagnostics complete.")
