####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python OpenStreetMapX3dEarthDemo.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='OpenStreetMapX3dEarthDemo.x3d',name='title'),
    meta(content='Byounghyun Yoo',name='creator'),
    meta(content='20 October 2019',name='modified'),
    meta(content='http://x3d-earth.nps.edu',name='reference'),
    meta(content='https://www.web3d.org/x3d-earth',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/GeoSpatial/OpenStreetMapToX3D.php',name='reference'),
    meta(content='http://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/content/examples/Basic/GeoSpatial/OpenStreetMapToX3D.php',name='reference'),
    meta(content='X3D-Earth tile',name='subject'),
    meta(content='under development',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/OpenStreetMapX3dEarthDemo.x3d',name='identifier'),
    meta(content='OpenStreetMapToX3D.php, https://www.web3d.org/x3d/content/examples/Basic/GeoSpatial/OpenStreetMapToX3D.php',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/license.html',name='license'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='OpenStreetMapX3dEarthDemo.x3d'),
    Group(
      #  28.424806942669583 -81.46898746490478 Orange County Convention Center, Orlando, FL, 21 level 34.53258110649095 69.13782119750976 Kabul, Afghanistan, 13 level 36.596454966540136 -121.87352389097214 Naval Postgraduate School, Monterey, CA, 19 level 37.78588957889747 -122.40087300539018 San Francisco Museum of Modern Art, San Francisco, CA, 21 level 41.48692107976417 -71.32715016603471 Narragansett Bay, Newport, RI, 19 level 51.5305712322625 -0.12352377176285152 King's Cross, London, United Kingdom, 21 level 42.36027219744271 -71.05916529893875 Scollay Square, Boston, MA, 21 level 32.70688495899665 -117.16055274009707 San Diego Convention Center, San Diego, CA, 21 level 28.41747302782284 -81.46303564310074 International Plaza Resort and Spa, Orlando, FL, 21 level -7.137685657416106 -34.845199584960945 Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil, 18 level 1.26299 103.837398 Port of Singapore, Singapore, 17 level 28.225 0.7 Algeria, Africa 13 level 
      children=[
      Inline(url=["/osmb0m","https://www.web3d.org/x3d/content/examples/Basic/Geospatial//osmb0m"]),
      GeoViewpoint(description='Default Viewpoint',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(0,0,10000000),
        geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(0,0,-6378137),geoSystem=["GD"])),
      GeoViewpoint(DEF='ZOOM',description='Zoom and Spin',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.500152,-0.126236,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM1',description='Orange County Convention Center, Orlando, FL',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM2',description='Kabul, Afghanistan',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(34.53258110649095,69.13782119750976,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM3',description='Naval Postgraduate School, Monterey, CA',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM4',description='San Francisco Museum of Modern Art, San Francisco, CA',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM5',description='Narragansett Bay, Newport, RI',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM6',description="King's Cross, London, United Kingdom",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM7',description='Scollay Square, Boston, MA',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM8',description='San Diego Convention Center, San Diego, CA',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM9',description='International Plaza Resort and Spa, Orlando, FL',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM10',description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(DEF='ZOOM11',description='Port of Singapore, Singapore',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,500000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='0E 0N',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(0,0,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='90E 0N',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(0,89.9,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='90W 0N',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(0,-89.9,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='180E 0N',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(0,180,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='North Pole',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(90,0,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='South Pole',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-89.9,0,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Orange County Convention Center, Orlando, FL: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Orange County Convention Center, Orlando, FL: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Orange County Convention Center, Orlando, FL: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Orange County Convention Center, Orlando, FL: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Orange County Convention Center, Orlando, FL: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Orange County Convention Center, Orlando, FL: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.424806942669583,-81.46898746490478,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Kabul, Afghanistan: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(34.53258110649095,69.13782119750976,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Kabul, Afghanistan: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(34.53258110649095,69.13782119750976,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Kabul, Afghanistan: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(34.53258110649095,69.13782119750976,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Kabul, Afghanistan: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(34.53258110649095,69.13782119750976,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Naval Postgraduate School, Monterey, CA: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Naval Postgraduate School, Monterey, CA: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Naval Postgraduate School, Monterey, CA: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Naval Postgraduate School, Monterey, CA: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Naval Postgraduate School, Monterey, CA: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Naval Postgraduate School, Monterey, CA: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(36.596454966540136,-121.87352389097214,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Francisco Museum of Modern Art, San Francisco, CA: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Francisco Museum of Modern Art, San Francisco, CA: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Francisco Museum of Modern Art, San Francisco, CA: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Francisco Museum of Modern Art, San Francisco, CA: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Francisco Museum of Modern Art, San Francisco, CA: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Francisco Museum of Modern Art, San Francisco, CA: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(37.78588957889747,-122.40087300539018,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Narragansett Bay, Newport, RI: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Narragansett Bay, Newport, RI: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Narragansett Bay, Newport, RI: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Narragansett Bay, Newport, RI: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Narragansett Bay, Newport, RI: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Narragansett Bay, Newport, RI: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(41.48692107976417,-71.32715016603471,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description="King's Cross, London, United Kingdom: 10000Km",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description="King's Cross, London, United Kingdom: 1000Km",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description="King's Cross, London, United Kingdom: 100Km",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description="King's Cross, London, United Kingdom: 10Km",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description="King's Cross, London, United Kingdom: 1Km",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description="King's Cross, London, United Kingdom: 200m",fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(51.5305712322625,-0.12352377176285152,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Scollay Square, Boston, MA: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Scollay Square, Boston, MA: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Scollay Square, Boston, MA: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Scollay Square, Boston, MA: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Scollay Square, Boston, MA: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Scollay Square, Boston, MA: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(42.36027219744271,-71.05916529893875,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Diego Convention Center, San Diego, CA: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Diego Convention Center, San Diego, CA: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Diego Convention Center, San Diego, CA: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Diego Convention Center, San Diego, CA: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Diego Convention Center, San Diego, CA: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='San Diego Convention Center, San Diego, CA: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(32.70688495899665,-117.16055274009707,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='International Plaza Resort and Spa, Orlando, FL: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='International Plaza Resort and Spa, Orlando, FL: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='International Plaza Resort and Spa, Orlando, FL: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='International Plaza Resort and Spa, Orlando, FL: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='International Plaza Resort and Spa, Orlando, FL: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='International Plaza Resort and Spa, Orlando, FL: 200m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(28.41747302782284,-81.46303564310074,200),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil: 300m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(-7.137685657416106,-34.845199584960945,300),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Port of Singapore, Singapore: 10000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,10000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Port of Singapore, Singapore: 1000Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,1000000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Port of Singapore, Singapore: 100Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,100000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Port of Singapore, Singapore: 10Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,10000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Port of Singapore, Singapore: 1Km',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,1000),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      GeoViewpoint(description='Port of Singapore, Singapore: 500m',fieldOfView=1.05,geoSystem=["GD"],orientation=(1.0,0.0,0.0,-1.57),position=(1.26299,103.837398,500),
        geoOrigin=GeoOrigin(USE='ORIGIN')),
      TimeSensor(DEF='TIMER',cycleInterval=800,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(28.424806942669583,-81.46898746490478,5000000),(34.53258110649095,69.13782119750976,5000000),(36.596454966540136,-121.87352389097214,5000000),(37.78588957889747,-122.40087300539018,5000000),(41.48692107976417,-71.32715016603471,5000000),(51.5305712322625,-0.12352377176285152,5000000),(0,-187,5000000),(0,0,5000000),(0,180,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM',toField='enabled',toNode='TIMER'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER',toField='set_fraction',toNode='GeoPositionINTERP'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP',toField='position',toNode='ZOOM'),
      #  28.424806942669583 -81.46898746490478 Orange County Convention Center, Orlando, FL 
      TimeSensor(DEF='TIMER1',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP1',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(28.424806942669583,-81.46898746490478,1000000),(28.424806942669583,-81.46898746490478,100000),(28.424806942669583,-81.46898746490478,10000),(28.424806942669583,-81.46898746490478,1000),(28.424806942669583,-81.46898746490478,200),(28.424806942669583,-81.46898746490478,1000),(28.424806942669583,-81.46898746490478,10000),(28.424806942669583,-81.46898746490478,100000),(28.424806942669583,-81.46898746490478,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM1',toField='enabled',toNode='TIMER1'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER1',toField='set_fraction',toNode='GeoPositionINTERP1'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP1',toField='position',toNode='ZOOM1'),
      #  34.53258110649095 69.13782119750976 Kabul, Afghanistan 
      TimeSensor(DEF='TIMER2',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP2',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(34.53258110649095,69.13782119750976,1000000),(34.53258110649095,69.13782119750976,100000),(34.53258110649095,69.13782119750976,10000),(34.53258110649095,69.13782119750976,100000),(34.53258110649095,69.13782119750976,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM2',toField='enabled',toNode='TIMER2'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER2',toField='set_fraction',toNode='GeoPositionINTERP2'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP2',toField='position',toNode='ZOOM2'),
      #  36.596454966540136 -121.87352389097214 Naval Postgraduate School, Monterey, CA 
      TimeSensor(DEF='TIMER3',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP3',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(36.596454966540136,-121.87352389097214,1000000),(36.596454966540136,-121.87352389097214,100000),(36.596454966540136,-121.87352389097214,10000),(36.596454966540136,-121.87352389097214,1000),(36.596454966540136,-121.87352389097214,200),(36.596454966540136,-121.87352389097214,1000),(36.596454966540136,-121.87352389097214,10000),(36.596454966540136,-121.87352389097214,100000),(36.596454966540136,-121.87352389097214,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM3',toField='enabled',toNode='TIMER3'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER3',toField='set_fraction',toNode='GeoPositionINTERP3'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP3',toField='position',toNode='ZOOM3'),
      #  37.78588957889747 -122.40087300539018 San Francisco Museum of Modern Art, San Francisco, CA 
      TimeSensor(DEF='TIMER4',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP4',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(37.78588957889747,-122.40087300539018,1000000),(37.78588957889747,-122.40087300539018,100000),(37.78588957889747,-122.40087300539018,10000),(37.78588957889747,-122.40087300539018,1000),(37.78588957889747,-122.40087300539018,200),(37.78588957889747,-122.40087300539018,1000),(37.78588957889747,-122.40087300539018,10000),(37.78588957889747,-122.40087300539018,100000),(37.78588957889747,-122.40087300539018,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM4',toField='enabled',toNode='TIMER4'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER4',toField='set_fraction',toNode='GeoPositionINTERP4'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP4',toField='position',toNode='ZOOM4'),
      #  41.48692107976417 -71.32715016603471 Narragansett Bay, Newport, RI 
      TimeSensor(DEF='TIMER5',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP5',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(41.48692107976417,-71.32715016603471,1000000),(41.48692107976417,-71.32715016603471,100000),(41.48692107976417,-71.32715016603471,10000),(41.48692107976417,-71.32715016603471,1000),(41.48692107976417,-71.32715016603471,200),(41.48692107976417,-71.32715016603471,1000),(41.48692107976417,-71.32715016603471,10000),(41.48692107976417,-71.32715016603471,100000),(41.48692107976417,-71.32715016603471,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM5',toField='enabled',toNode='TIMER5'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER5',toField='set_fraction',toNode='GeoPositionINTERP5'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP5',toField='position',toNode='ZOOM5'),
      #  51.5305712322625 -0.12352377176285152 King's Cross, London, United Kingdom 
      TimeSensor(DEF='TIMER6',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP6',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(51.5305712322625,-0.12352377176285152,1000000),(51.5305712322625,-0.12352377176285152,100000),(51.5305712322625,-0.12352377176285152,10000),(51.5305712322625,-0.12352377176285152,1000),(51.5305712322625,-0.12352377176285152,200),(51.5305712322625,-0.12352377176285152,1000),(51.5305712322625,-0.12352377176285152,10000),(51.5305712322625,-0.12352377176285152,100000),(51.5305712322625,-0.12352377176285152,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM6',toField='enabled',toNode='TIMER6'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER6',toField='set_fraction',toNode='GeoPositionINTERP6'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP6',toField='position',toNode='ZOOM6'),
      #  42.36027219744271 -71.05916529893875 Scollay Square, Boston, MA 
      TimeSensor(DEF='TIMER7',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP7',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(42.36027219744271,-71.05916529893875,1000000),(42.36027219744271,-71.05916529893875,100000),(42.36027219744271,-71.05916529893875,10000),(42.36027219744271,-71.05916529893875,1000),(42.36027219744271,-71.05916529893875,200),(42.36027219744271,-71.05916529893875,1000),(42.36027219744271,-71.05916529893875,10000),(42.36027219744271,-71.05916529893875,100000),(42.36027219744271,-71.05916529893875,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM7',toField='enabled',toNode='TIMER7'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER7',toField='set_fraction',toNode='GeoPositionINTERP7'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP7',toField='position',toNode='ZOOM7'),
      #  32.70688495899665 -117.16055274009707 San Diego Convention Center, San Diego, CA 
      TimeSensor(DEF='TIMER8',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP8',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(32.70688495899665,-117.16055274009707,1000000),(32.70688495899665,-117.16055274009707,100000),(32.70688495899665,-117.16055274009707,10000),(32.70688495899665,-117.16055274009707,1000),(32.70688495899665,-117.16055274009707,200),(32.70688495899665,-117.16055274009707,1000),(32.70688495899665,-117.16055274009707,10000),(32.70688495899665,-117.16055274009707,100000),(32.70688495899665,-117.16055274009707,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM8',toField='enabled',toNode='TIMER8'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER8',toField='set_fraction',toNode='GeoPositionINTERP8'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP8',toField='position',toNode='ZOOM8'),
      #  28.41747302782284 -81.46303564310074 International Plaza Resort and Spa, Orlando, FL 
      TimeSensor(DEF='TIMER9',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP9',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(28.41747302782284,-81.46303564310074,1000000),(28.41747302782284,-81.46303564310074,100000),(28.41747302782284,-81.46303564310074,10000),(28.41747302782284,-81.46303564310074,1000),(28.41747302782284,-81.46303564310074,200),(28.41747302782284,-81.46303564310074,1000),(28.41747302782284,-81.46303564310074,10000),(28.41747302782284,-81.46303564310074,100000),(28.41747302782284,-81.46303564310074,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM9',toField='enabled',toNode='TIMER9'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER9',toField='set_fraction',toNode='GeoPositionINTERP9'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP9',toField='position',toNode='ZOOM9'),
      #  -7.137685657416106 -34.845199584960945 Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil 
      TimeSensor(DEF='TIMER10',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP10',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,-100,10000000),(-7.137685657416106,-34.845199584960945,1000000),(-7.137685657416106,-34.845199584960945,100000),(-7.137685657416106,-34.845199584960945,10000),(-7.137685657416106,-34.845199584960945,1000),(-7.137685657416106,-34.845199584960945,300),(-7.137685657416106,-34.845199584960945,1000),(-7.137685657416106,-34.845199584960945,10000),(-7.137685657416106,-34.845199584960945,100000),(-7.137685657416106,-34.845199584960945,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM10',toField='enabled',toNode='TIMER10'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER10',toField='set_fraction',toNode='GeoPositionINTERP10'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP10',toField='position',toNode='ZOOM10'),
      #  1.26299 103.837398 Port of Singapore, Singapore 
      TimeSensor(DEF='TIMER11',cycleInterval=400,enabled=False,loop=True),
      GeoPositionInterpolator(DEF='GeoPositionINTERP11',key=[0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],keyValue=[(0,0,10000000),(1.26299,103.837398,1000000),(1.26299,103.837398,100000),(1.26299,103.837398,10000),(1.26299,103.837398,1000),(1.26299,103.837398,500),(1.26299,103.837398,1000),(1.26299,103.837398,10000),(1.26299,103.837398,100000),(1.26299,103.837398,1000000),(0,0,10000000)]),
      ROUTE(fromField='isBound',fromNode='ZOOM11',toField='enabled',toNode='TIMER11'),
      ROUTE(fromField='fraction_changed',fromNode='TIMER11',toField='set_fraction',toNode='GeoPositionINTERP11'),
      ROUTE(fromField='geovalue_changed',fromNode='GeoPositionINTERP11',toField='position',toNode='ZOOM11')])]
    #  28.424806942669583 -81.46898746490478 Orange County Convention Center, Orlando, FL, 21 level 34.53258110649095 69.13782119750976 Kabul, Afghanistan, 13 level 36.596454966540136 -121.87352389097214 Naval Postgraduate School, Monterey, CA, 19 level 37.78588957889747 -122.40087300539018 San Francisco Museum of Modern Art, San Francisco, CA, 21 level 41.48692107976417 -71.32715016603471 Narragansett Bay, Newport, RI, 19 level 51.5305712322625 -0.12352377176285152 King's Cross, London, United Kingdom, 21 level 42.36027219744271 -71.05916529893875 Scollay Square, Boston, MA, 21 level 32.70688495899665 -117.16055274009707 San Diego Convention Center, San Diego, CA, 21 level 28.41747302782284 -81.46303564310074 International Plaza Resort and Spa, Orlando, FL, 21 level -7.137685657416106 -34.845199584960945 Federal University of Paraiba, Joao Pessoa, Paraiba, Brazil, 18 level 1.26299 103.837398 Port of Singapore, Singapore, 17 level 
    )
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for OpenStreetMapX3dEarthDemo.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python OpenStreetMapX3dEarthDemo.py load and self-test diagnostics complete.")
