package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD023Index.html" target="_blank">MarsLOD023</a>,  source <a href="../../../Geospatial/MarsLOD023.java">MarsLOD023.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD023.x3d">MarsLOD023.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD023.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD023.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD023
{
	/** Default constructor to create this object. */
	public MarsLOD023 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD023.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD023.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD023.x3d"))
    .addChild(new GeoLOD().setCenter(44.911417,134.911417,164800.000000).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars007.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars07.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,90.000000,0.000000).setSolid(false).setXDimension(128).setXSpacing(0.708661).setYScale(50.0).setZDimension(128).setZSpacing(0.708661).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {226.70465,519.46967,88.6868,147.50858,523.2383,-301.35913,479.39206,631.4546,736.597,663.2331,954.8452,1628.3776,977.3597,545.638,380.5857,89.03425,-166.95737,89.4513,320.80032,310.06937,-4.250752,-598.2955,-646.6845,-721.2366,-694.1121,-679.2827,-708.9603,-714.44727,-503.3219,-480.31863,-261.5431,143.52464,-85.16308,97.53106,219.08847,415.4721,-540.496,445.2497,603.34766,361.37802,471.17038,555.94464,995.6842,1248.5894,925.38824,736.658,893.3624,542.9867,178.91185,153.15009,13.297698,-398.42868,-588.6916,-670.23737,-1202.6072,-1307.9625,-1086.3483,-1329.5413,-1833.5475,-1980.8837,-2071.7031,-2326.2742,-2275.9753,-2470.5288,-2618.5286,-2634.5752,-2580.1682,-2534.1743,-2442.9631,-2469.2227,-2435.9297,-2604.43,-2625.6045,-2620.3164,-2656.7598,-2585.2349,-2404.1338,-2143.827,-2099.0823,-2235.8286,-2159.8225,-2142.283,-2551.7393,-2604.5205,-2535.4966,-2511.8455,-2287.8608,-2026.5583,-2050.7737,-2082.8274,-2108.0261,-2185.905,-2323.5352,-2601.089,-2650.5374,-2677.6604,-2731.1294,-2795.084,-2804.385,-2811.4385};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {-2800.979,-2836.7012,-2880.3071,-2894.0696,-2898.5715,-2902.917,-2909.2217,-2926.4224,-2951.6292,-2969.9507,-2982.506,-3000.9778,-3007.7683,-3002.5234,-3005.196,-3011.0864,-2996.6619,-2964.3113,-2947.9907,-2953.8848,-2957.9036,-2905.8794,-2884.634,-2784.384,-2644.0872,-2559.8867,-2520.5337,-2450.4172,527.9296,-5.449537,-35.02762,514.59973,625.5609,402.53156,222.02231,196.69402,702.6558,248.27809,206.63539,491.76767,-87.39838,316.84827,286.8224,-65.87451,-375.69446,-599.8529,-497.18607,-99.75421,-18.142233,-669.45154,-815.7267,-810.3176,-788.4502,-790.8562,-758.1833,-750.8645,-682.2237,-705.4123,-244.40167,-59.20269,126.29807,357.1367,44.06073,394.12827,242.53677,886.9435,630.55695,416.76483,582.72845,795.48926,908.81805,902.1335,862.77313,473.61887,353.54193,346.10007,99.41818,-341.15503,-1300.8568,-1679.5183,-1251.2917,-1525.5076,-1718.9778,-1556.5565,-1739.43,-1675.288,-1867.0304,-2269.4497,-2365.925,-2366.1575,-2346.9312,-2510.5317,-2585.094,-2552.9392,-2330.7485,-2561.7734,-2580.3555,-2654.4785,-2684.3145,-2708.441};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {-2634.1252,-2518.011,-2550.8142,-2514.665,-2279.7288,-2190.6792,-2201.1304,-2329.2576,-2447.9429,-2536.0557,-2640.8928,-2578.6406,-2534.744,-2484.504,-2346.659,-2163.4133,-1975.5087,-1989.8729,-2108.0,-2203.9866,-2431.5825,-2637.7107,-2659.9204,-2714.6113,-2758.9863,-2790.5417,-2803.699,-2805.9014,-2881.6545,-2865.5752,-2891.9443,-2909.2827,-2919.3855,-2919.8606,-2920.9631,-2930.3794,-2946.8855,-2959.614,-2973.0562,-2983.2925,-2994.1152,-2991.868,-2994.173,-3001.1018,-3010.1172,-3016.6,-3022.3123,-3023.785,-2998.8672,-2906.6133,-2881.6338,-2863.6042,-2766.9758,-2713.4128,-2616.3674,-2692.458,-699.94275,-773.91235,-390.2265,-39.92167,-90.19388,84.86159,264.3332,265.88016,48.17654,-87.738914,-97.53611,168.92494,361.82755,659.1177,491.7343,363.7935,-206.0002,-589.0194,-922.20593,-696.84955,-623.2808,-819.0735,-885.2532,-861.3317,-827.4202,-817.49426,-763.51337,-1087.0155,-737.29663,-462.47876,-78.93983,-73.60172,25.17231,-1.119736,-19.512602,397.50583,494.0291,517.3055,391.9492,492.606,-118.93233,574.3404,825.0096,584.1343};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {181.3725,-131.12155,-166.95465,-561.88763,-1201.536,-1782.681,-2082.1287,-1884.2325,-1798.7097,-1699.412,-2004.8582,-1821.4335,-1497.7222,-1557.4839,-1799.8116,-2171.0254,-2304.6594,-2328.832,-2559.867,-2651.982,-2415.749,-2425.0652,-2480.7234,-2571.866,-2655.429,-2690.6765,-2697.6921,-2721.1494,-2496.9382,-2426.5874,-2452.7961,-2521.9634,-2444.607,-2414.2542,-2525.4004,-2660.4265,-2722.5247,-2714.1294,-2639.4285,-2591.9233,-2586.697,-2480.0571,-2397.223,-2437.115,-2347.8462,-2151.4856,-2136.932,-2314.4878,-2572.9497,-2670.2744,-2705.6853,-2737.37,-2790.8506,-2797.0,-2797.2954,-2808.898,-2834.2168,-2856.482,-2877.4028,-2910.293,-2910.6355,-2929.2683,-2928.8254,-2931.5247,-2941.3691,-2954.7622,-2971.1482,-2976.6555,-2978.427,-2982.0273,-2984.153,-2993.5896,-3003.9014,-3012.824,-3022.0112,-3027.835,-3035.369,-3023.9268,-2958.5552,-2899.729,-2903.7065,-2924.596,-2871.2373,-2840.277,-1752.8146,-1024.2267,-1026.2362,-771.95026,-391.0678,-155.75052,-27.507586,-45.27168,-231.4219,-231.06879,-91.47059,-170.51556,-290.98492,152.24158,443.26117,-13.738393};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-406.13452,-567.8926,-760.7928,-686.15405,-688.4559,-863.3835,-957.52264,-947.07135,-896.17426,-864.5936,-850.1503,-833.9826,-689.5665,-151.1762,20.540384,-368.02844,-235.52028,-92.6259,329.3458,436.86145,304.82227,292.67578,349.64328,476.16135,544.10126,798.4799,672.48236,482.95886,-108.77087,-1399.0278,-1731.901,-1899.6985,-1515.3027,-1906.5493,-1765.3334,-1497.0288,-1623.6622,-1845.4951,-1839.7108,-1563.1722,-1696.8463,-1585.1755,-2010.4254,-2223.0427,-2328.3655,-2475.9053,-2528.0542,-2412.9438,-2470.1917,-2584.5654,-2596.806,-2620.2776,-2678.842,-2688.4536,-2723.596,-2505.1506,-2313.3186,-2429.0183,-2489.1255,-2566.2366,-2542.924,-2625.837,-2695.0205,-2677.4746,-2700.955,-2722.7402,-2671.7786,-2655.9414,-2668.3127,-2547.5835,-2354.9683,-2199.021,-2228.6853,-2253.158,-2366.2878,-2592.6904,-2673.6292,-2699.631,-2734.8806,-2757.8152,-2784.022,-2797.0852,-2797.9907,-2805.7678,-2807.5427,-2827.1155,-2838.1504,-2839.9592,-2877.3313,-2771.2917,-2903.1462,-2937.6475,-2946.2314,-2953.4114,-2958.1829,-2962.662,-2962.183,-2963.4473,-2971.4575,-2982.9548};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {-2993.986,-3003.3403,-3011.574,-3019.1272,-3030.9238,-3038.945,-3041.0115,-3020.9062,-2981.2073,-3003.1255,-3014.934,-3034.1416,-1883.9241,-1991.1401,-1493.1852,-1669.0623,-789.9393,-566.4612,-432.7114,-172.689,-76.493744,-3.646485,-0.19682,-251.88545,-676.1442,-523.25195,-489.26447,-457.4296,-517.85626,-649.3572,-718.1968,-1013.801,-1533.1405,-962.63226,-963.069,-949.232,-888.71924,-911.26953,-920.013,-916.3125,-452.44797,-618.7713,-158.74889,-246.86949,-254.03809,38.084904,-104.561874,219.239,288.7391,363.63535,387.839,533.8673,747.06165,876.64166,950.52246,745.8249,-158.01234,-1606.3701,-1988.0526,-1913.5253,-2074.2925,-1841.3896,-1733.9808,-1480.4786,-1403.6945,-1587.3506,-1715.9233,-1598.0901,-1692.4023,-1893.458,-2177.7144,-2298.9617,-2316.1267,-2407.9216,-2525.6362,-2566.0889,-2597.2666,-2639.4556,-2669.708,-2678.863,-2680.125,-2698.58,-2673.5488,-2302.0928,-2429.9622,-2460.304,-2577.3496,-2652.794,-2722.8167,-2712.4807,-2632.4375,-2668.0464,-2708.315,-2722.0515,-2702.9685,-2706.5588,-2677.1057,-2617.5261,-2508.9165,-2305.79};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {-2110.5344,-2286.8254,-2525.603,-2697.3894,-2711.0322,-2707.22,-2748.5027,-2773.762,-2788.1614,-2797.3403,-2788.928,-2789.6177,-2785.9736,-2804.8083,-2839.9077,-2877.558,-2878.47,-2872.3132,-2923.2861,-2932.806,-2941.4854,-2943.0752,-2947.244,-2947.2056,-2940.9927,-2947.8792,-2962.1643,-2979.8496,-2915.0134,-2933.3718,-3013.226,-3018.7292,-3032.1233,-3041.3687,-3049.0269,-3062.3281,-3073.9163,-3089.9836,-3098.5864,-3126.9707,-3044.236,-2782.5374,-2504.7268,-2395.8018,-1522.074,-783.8413,-572.74274,-516.6713,-278.73343,-271.8418,-301.9262,-241.68889,-573.2229,-620.79034,-616.2866,-374.7223,-225.9499,-441.93625,-860.20703,-1591.9792,-1376.8575,-1054.6893,-1010.0539,-1056.5223,-1279.2572,-932.4727,-704.3161,-471.5213,-392.60736,-147.73468,-290.0188,-361.3738,-50.73378,15.700346,14.604756,223.90004,338.0962,452.89352,525.847,657.3565,786.73706,865.4904,932.305,407.5064,-349.5462,-1472.037,-1738.874,-1662.1345,-1787.3108,-1698.5919,-1579.82,-1492.9385,-1640.2301,-1552.2704,-1630.1248,-1768.8114,-1893.0121,-2035.0732,-2156.0588,-2284.4153};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {-2345.4531,-2492.098,-2564.381,-2578.706,-2625.2778,-2626.1218,-2639.701,-2675.2136,-2688.9417,-2684.2795,-2613.8438,-2417.5913,-2520.5803,-2609.8762,-2679.4246,-2683.2788,-2656.475,-2658.0715,-2649.5461,-2684.2346,-2719.7747,-2722.7126,-2705.4592,-2623.3127,-2627.6462,-2646.3196,-2638.781,-2672.5972,-2655.8296,-2620.758,-2681.005,-2701.6963,-2710.1702,-2690.8792,-2733.5486,-2764.163,-2781.6255,-2794.2026,-2780.765,-2766.6895,-2753.0674,-2789.9968,-3461.657,-2978.51,-2868.347,-2870.47,-2905.0928,-2916.6643,-2923.643,-2932.4343,-2936.652,-2937.1057,-2939.5632,-2949.966,-2959.86,-2977.0305,-2784.6067,-2857.8677,-3017.0679,-3018.3555,-3026.461,-3039.9133,-3047.8672,-3056.5503,-3066.8806,-3085.7627,-3098.9126,-3122.9336,-3601.5037,-3347.203,-3097.098,-2287.6604,-2211.4697,-821.0728,-1108.0234,-828.3892,-1181.9948,-982.5298,-1166.8256,5.965397,919.3002,-264.5299,-749.99274,-894.1052,-540.8717,-847.19507,-1267.4246,-1347.2496,-1160.7161,-1120.175,-1076.7728,-1033.26,-1033.2834,-880.9692,-683.22327,-685.43146,-626.38464,-368.60782,-383.48767,-421.21964};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-161.062,-23.76698,-64.89409,159.87589,174.2746,479.5468,546.9593,711.59875,899.3002,833.0247,749.34357,194.58943,-572.17993,-1191.3942,-1306.5745,-1568.5564,-1591.9344,-1700.351,-1591.315,-1563.7054,-2067.821,-1805.947,-1894.5623,-1928.7634,-2027.9292,-2017.3315,-2151.5608,-2285.267,-2377.3855,-2450.3865,-2581.708,-2641.752,-2613.7405,-2629.2856,-2665.0076,-2703.0564,-2716.4614,-2712.719,-2709.6738,-2648.8508,-2696.0679,-2667.4517,-2611.4053,-2614.4382,-2594.2395,-2674.0188,-2714.7048,-2714.2908,-2719.3164,-2724.9653,-2716.9565,-3085.4968,-2727.7688,-2702.7332,-2686.569,-2698.7947,-2689.6707,-2700.736,-2696.7397,-2682.7632,-2694.4814,-2710.5173,-2723.9863,-2760.372,-2776.2407,-2785.848,-2767.2854,-2727.7717,-2676.8696,-2736.722,-2832.0242,-2809.045,-2852.6035,-2875.8435,-2891.401,-2903.2522,-2915.657,-2926.5098,-2932.6187,-2936.096,-2934.1143,-2936.5142,-2858.138,-2105.7202,-2998.576,-3002.8752,-3020.613,-3023.4824,-3023.868,-3037.016,-3044.917,-3050.7654,-3062.032,-3079.4333,-3090.7383,-3101.0793,-3726.714,-3636.1191,-3511.957,-3351.1208};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-2921.171,-3329.6692,-2524.0083,-1518.4293,-1579.5342,-1494.3226,-1290.1149,-858.3005,-939.28784,-844.3581,-978.8184,-1053.0652,-1054.4381,-1324.1859,-1438.4419,-1368.4592,-1290.5692,-1199.7865,-1131.5486,-1065.6078,-904.1951,-901.725,-825.3583,-665.06104,-605.5006,-334.91083,-321.58194,-287.30664,-120.28333,0.168939,19.147022,101.90552,13.03155,421.92444,629.3679,836.03406,951.7816,744.5134,328.24774,-440.9446,-1764.2942,-1757.9786,-1566.2988,-1589.761,-1593.0769,-1843.9214,-1906.8634,-1795.982,-1914.9878,-1953.6328,-1917.8562,-2070.3987,-2136.3562,-2184.6743,-2232.8762,-2281.6792,-2387.5718,-2447.9873,-2626.86,-2693.3386,-2659.1326,-2660.7483,-2708.1921,-2724.093,-2717.9968,-2727.9458,-2742.2463,-2730.7288,-2721.2517,-2649.9204,-2624.2446,-2633.421,-2635.353,-2690.9392,-2712.6807,-2712.8271,-2708.528,-2715.1265,-2716.1946,-2717.647,-2718.49,-2717.1824,-2709.174,-2712.8064,-2712.1467,-2707.6182,-2698.1482,-2691.3513,-2672.6274,-2701.3774,-2735.0825,-2745.8975,-2757.9775,-2761.1445,-2748.2793,-2701.8987,-2567.5564,-2742.2886,-2752.7996,-2809.7136};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {-2845.1316,-2871.5789,-2875.9785,-2875.7866,-2888.2222,-2899.5178,-2914.5918,-2931.7532,-2921.392,-2905.511,-2926.8713,-2920.7397,-2984.6182,-2992.8071,-3017.896,-3025.747,-3026.9937,-3033.7986,-3045.2183,-3052.3489,-3063.0278,-3074.4749,-3087.8186,-3100.4895,-3792.0334,-3740.9185,-3698.3274,-3625.994,-3616.2898,-4499.178,-3583.7861,-2045.4264,-2187.7263,-1587.3132,-1311.6904,-1219.2479,-1408.986,-1069.4875,-1022.8065,-1195.9678,-1403.8512,-1441.9451,-1467.8242,-1429.8033,-1342.4993,-1286.8894,-1213.8275,-984.23035,-1016.3308,-1521.8319,-782.93463,-439.8905,-345.8297,-207.0421,-125.63091,68.169365,108.642845,97.98652,-31.751461,1.309433,84.38683,260.9636,540.7634,922.68994,979.7316,554.011,55.404266,-676.6871,-1643.9769,-1720.3536,-1770.9448,-1800.706,-1795.7188,-1919.5891,-1903.298,-1924.3944,-2118.1448,-2106.6035,-2238.1326,-2242.005,-2284.3508,-2227.6865,-2355.4873,-2473.624,-2449.3125,-2504.1377,-2638.473,-2682.04,-2681.3127,-2675.2612,-2738.9617,-2738.162,-2699.6375,-2736.7615,-2745.5208,-2737.5325,-2708.184,-2706.6387,-2653.5122,-2648.3071};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {-2663.83,-2702.3425,-2716.7214,-2700.786,-2708.2,-2713.265,-2720.1667,-2723.2466,-2721.2996,-2722.5208,-2718.3894,-2714.966,-2712.302,-2704.1702,-2687.8826,-2689.258,-2673.2566,-2694.944,-2716.2498,-2730.5435,-2741.0679,-2730.3103,-2739.579,-2697.1467,-2689.3792,-2741.8232,-2779.2002,-2808.0,-2831.0908,-2853.2454,-2843.1626,-2857.4866,-2870.5208,-2876.7827,-2897.4817,-2921.145,-2921.8113,-2902.5532,-2919.3386,-2965.239,-2986.1384,-2996.4941,-3014.102,-3029.9304,-3033.9456,-3040.0183,-3050.707,-3061.1729,-3066.3645,-3077.0872,-3092.8667,-3103.7969,-3789.6726,-3802.8582,-3761.0767,-3743.471,-3549.6006,-3357.424,-3191.356,-2386.0916,-2512.139,-2174.1235,-1363.4305,-1227.8026,-1373.1326,-1418.2925,-1043.9851,-1319.9388,-1535.9395,-1481.9976,-1494.531,-1409.7351,-1375.1888,-1217.1472,-1206.3932,-962.29144,-711.86615,-618.7785,-338.9899,-232.5536,99.89112,281.8637,255.037,268.5316,259.59012,-4.569592,-177.93446,-241.47641,-195.38936,-16.394964,-9.959964,249.71349,503.47058,344.57944,-277.80988,-875.7018,-1461.3973,-1653.194,-1855.7709,-1935.2047};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {-1918.2986,-1966.3037,-1939.1907,-2149.7703,-2223.3918,-2315.0706,-2358.3687,-2325.584,-2309.1055,-2425.4434,-2384.4976,-2352.3464,-2502.9668,-2622.9873,-2695.6626,-2708.7542,-2684.4878,-2682.1655,-2683.014,-2740.757,-2751.4875,-2748.581,-2742.9634,-2726.0427,-2678.3845,-2706.174,-2726.3796,-2687.6318,-2670.269,-2669.4248,-2708.6829,-2710.1638,-2703.0627,-2707.405,-2717.9983,-2727.5435,-2732.3752,-2731.033,-2718.6167,-2717.6782,-2713.2285,-2695.8188,-2684.1416,-2684.0715,-2675.113,-2696.7358,-2706.043,-2717.2632,-2722.3032,-2707.4272,-2708.0435,-2669.647,-2571.7969,-2647.3416,-2746.9382,-2773.8486,-2780.4363,-2801.8447,-2809.0613,-2834.8438,-2845.2551,-2858.2505,-2879.64,-2891.008,-2874.6313,-2881.7896,-2909.8147,-2952.5017,-2984.044,-3008.0984,-3027.3403,-3041.1436,-3049.2332,-3055.3894,-3060.4602,-3065.206,-3073.9453,-3083.8308,-3094.0942,-3107.2358,-3782.0732,-3784.095,-3777.0886,-3773.5706,-3748.8093,-3625.694,-3499.3022,-3339.5417,-2989.6487,-2482.219,-1817.0568,-1655.8439,-1727.678,-1708.8042,-1421.7184,-1746.5557,-1676.5634,-1548.0754,-1502.1296,-1451.3254};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {-1134.7289,-886.5469,-988.5506,-575.9034,-1062.571,-236.7515,-476.61398,-42.87527,429.0527,326.44977,302.11914,335.40045,257.80643,-30.268127,-403.6466,-519.7627,-400.0654,-260.632,-174.95433,61.37035,263.66632,303.23746,-650.78723,-850.452,-1495.0361,-1749.4467,-1941.4756,-2014.8661,-2056.9878,-2093.6152,-2161.9246,-2170.942,-2226.274,-2441.9858,-2522.498,-2511.36,-2482.5403,-2498.4465,-2528.913,-2526.3674,-2605.6775,-2663.857,-2712.445,-2744.8484,-2741.8594,-2688.0515,-2660.222,-2693.0461,-2749.5364,-2757.258,-2759.2795,-2739.5771,-2675.6924,-2702.344,-2732.507,-2727.1917,-2653.7485,-2631.7305,-2682.7896,-2687.8457,-2636.8193,-2664.836,-2709.252,-2719.852,-2724.5598,-2728.1472,-2718.0286,-2550.4675,-2537.8489,-2693.0254,-2668.3347,-2664.7742,-2674.059,-2668.343,-2659.9084,-2656.518,-2681.6558,-2684.3555,-2680.4026,-2645.3616,-2639.8816,-2659.2554,-2702.1785,-2695.671,-2585.312,-2764.5134,-2793.9365,-2811.4338,-2821.4,-2855.2275,-2881.1228,-2871.6611,-2843.1165,-2866.2622,-2907.5222,-2951.8057,-2979.0422,-2997.4856,-3014.2668,-3028.5283};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {-3038.1873,-3055.5862,-3058.2217,-3065.2898,-3074.5908,-3083.3347,-3097.686,-3107.442,-3786.7625,-3812.4597,-3809.7847,-3780.4128,-3752.406,-3692.8413,-3603.098,-3475.5886,-3287.6187,-2631.3123,-2731.8672,-2560.8374,-2151.8706,-2054.0942,-2272.4817,-2082.3667,-1707.54,-1571.2954,-1572.2123,-1482.7657,-1046.7863,-1057.5116,-922.58765,-303.38962,328.0108,264.91705,-527.49194,-383.49832,-440.84808,-229.87,308.10776,185.50066,-42.215534,-409.7645,-826.79974,-769.78235,-555.2636,-468.90234,-341.50443,-200.13702,42.87633,-172.39421,-651.02673,-1283.0891,-1659.5193,-1839.8276,-1988.8889,-2135.1506,-2273.3389,-2221.779,-2169.92,-2267.9592,-2123.394,-2393.103,-2605.733,-2614.4888,-2593.7202,-2642.0508,-2661.7908,-2655.1997,-2668.1968,-2693.0698,-2718.707,-2744.776,-2738.8706,-2683.84,-2655.5955,-2699.382,-2733.7524,-2740.0168,-2729.3743,-2718.2595,-2664.858,-2670.0825,-2696.067,-2700.9124,-2694.8604,-2644.246,-2621.146,-2623.0408,-2554.519,-2571.2625,-2666.5486,-2726.5132,-2722.0154,-2721.354,-2713.942,-2528.3628,-2406.6472,-2674.8586,-2664.5059,-2644.428};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {-2642.5881,-2660.0444,-2637.6958,-2591.9832,-2585.9333,-2638.767,-2627.561,-2651.7195,-2671.5813,-2684.999,-2695.2454,-2705.2144,-2680.0884,-2767.9314,-2771.1401,-2787.0986,-2814.4177,-2865.2231,-2895.9426,-2898.6055,-2876.0894,-2890.6187,-2916.9316,-2951.031,-2966.0144,-2970.2236,-3000.0112,-3010.543,-3034.9646,-3049.907,-3063.071,-3067.714,-3075.3416,-3085.6658,-3100.2104,-3113.2449,-3784.9326,-3805.09,-3777.7803,-3737.0818,-3723.1086,-3697.283,-3686.6733,-3601.5144,-3464.1318,-3223.04,-3045.1245,-2751.992,-2424.3076,-2325.1973,-2303.922,-2131.7878,-1934.1161,-1583.6505,-2444.6206,-1597.715,-1431.9337,-1159.7017,-935.5689,-654.6279,-414.97696,-518.30066,-677.12085,-652.6968,-440.48975,-160.92708,-141.02068,-313.20694,-620.5266,-984.26166,-1146.7427,-1114.3625,-1000.06274,-667.4375,-584.32336,-634.8108,-401.7199,-1143.2118,-1351.9658,-1569.8564,-1843.7927,-2098.824,-2173.2712,-2315.1357,-2369.2776,-2400.384,-2409.7483,-2847.413,-2206.6377,-2382.8716,-2592.08,-2651.6199,-2715.3074,-2816.3604,-2794.563,-2738.5588,-2682.6477,-2686.0737,-2695.5876,-2690.3684};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {-2704.1152,-2658.599,-2614.9697,-2658.4226,-2710.544,-2682.5781,-2630.2024,-2647.8213,-2572.3328,-2730.7488,-2514.6687,-2585.8135,-2576.3923,-2601.853,-2510.9136,-2477.8608,-2475.3596,-2538.7373,-2634.092,-2680.503,-2711.2285,-2713.5825,-2697.3674,-2704.405,-2683.5623,-2627.8923,-2585.2578,-2583.7915,-2600.9958,-2607.6584,-2601.805,-2571.0134,-2504.2983,-2512.4592,-2573.0962,-2553.7437,-2650.9595,-2632.0627,-2626.79,-2676.5637,-2736.7334,-2761.8606,-2746.6646,-2793.5908,-2839.5037,-2857.5845,-2877.6006,-2893.0479,-2930.57,-3057.266,-2912.069,-2951.7253,-2957.218,-2915.8262,-2982.4185,-3014.8994,-3033.8816,-3051.1897,-3065.551,-3075.3428,-3085.7922,-3096.0154,-3107.6018,-3114.238,-3797.4673,-3766.6182,-3726.8367,-3725.1665,-3754.209,-3743.0269,-3679.2754,-3617.6143,-3460.878,-3289.396,-3077.7798,-2862.744,-2624.3347,-2525.388,-2360.5,-2155.7227,-2086.08,-1829.8214,-1858.7117,-1602.7303,-1640.5265,-1185.0809,-852.4034,-594.731,-414.62274,-504.94626,-493.9727,-474.56552,-460.88593,-427.90137,-409.8824,-839.30804,-1047.3184,-1070.6096,-1317.8098,-1463.5173};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {-1299.8081,-975.0775,-1218.0454,-1314.3148,-1229.8547,-1266.0518,-1476.8654,-1862.1311,-2059.5413,-2150.3176,-2256.5757,-2375.9292,-2463.9744,-2495.9116,-2749.5386,-2538.9253,-2480.6252,-2333.4429,-2480.0977,-2580.3628,-2626.842,-2799.6077,-2813.7034,-2782.2754,-2714.1167,-2697.7695,-2705.214,-2682.056,-2661.627,-2610.3508,-2546.6333,-2544.9614,-2597.0483,-2632.2927,-2580.7378,-2503.5935,-2495.994,-2865.4258,-2419.5947,-2478.5383,-2534.66,-2445.744,-2398.6318,-2418.5808,-2403.196,-2456.5774,-2555.4514,-2546.9768,-2593.9026,-2940.6772,-3052.409,-2654.37,-2619.2312,-2565.9207,-2494.4995,-2501.913,-2556.5125,-2564.4136,-2560.658,-2504.2275,-2466.5015,-2388.683,-2316.3945,-2476.4465,-2631.8677,-2479.9219,-2669.3499,-2718.552,-2719.5137,-2756.4353,-2758.4446,-2759.3496,-2792.467,-2840.9092,-2865.0461,-2876.6545,-2828.2266,-2840.7297,-2810.1025,-2872.011,-2917.7842,-2955.0457,-3000.0037,-3016.655,-3036.9214,-3054.4573,-3064.7725,-3078.44,-3086.2913,-3106.5767,-3118.26,-3101.1865,-3758.2559,-3723.7017,-3730.9272,-3737.7383,-3742.1887,-3690.2332,-3659.4688,-3570.1357};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {-3558.8047,-3379.1653,-3145.6333,-2975.7632,-2770.8518,-2549.0867,-2422.5352,-1548.1014,-1461.156,-1543.5574,-1294.0195,-1156.0002,-944.4821,-902.4354,-1153.9995,-779.073,-444.24658,-287.65524,-515.65955,-559.5861,-557.34656,-689.6024,-643.9767,-927.7231,-1031.5557,-1267.7859,-1542.28,-1776.4575,-1742.1938,-1548.1888,-1752.408,-1754.3944,-1799.4652,-1906.2783,-2042.3993,-2100.7903,-2202.058,-2326.7522,-2425.1555,-2507.4795,-2560.2717,-2678.9941,-2719.9507,-2762.465,-2640.7432,-2410.439,-2370.9883,-2419.4705,-2376.317,-2323.2432,-2460.2703,-2550.1873,-2646.6252,-2726.364,-2743.1873,-2753.697,-2722.5745,-2681.552,-2560.6907,-2469.1472,-2480.0308,-2578.9348,-2569.878,-2452.323,-2432.301,-2432.7778,-2455.3699,-2387.2224,-2333.3242,-2283.7253,-2276.227,-2367.3538,-2368.5232,-2387.851,-2412.9885,-2410.2349,-2466.255,-2851.9094,-2921.0088,-2488.6238,-2492.9248,-2472.7236,-2435.8347,-2412.878,-2453.9016,-2498.5667,-2493.369,-2510.4614,-2455.9128,-2377.183,-2324.1206,-2362.731,-2396.3147,-2389.1287,-2703.956,-2724.3296,-2722.6294,-2715.1165,-2696.7935,-2694.9563};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {-2740.5376,-2798.1191,-2828.541,-2832.896,-2793.8945,-2697.1323,-2801.58,-2976.2659,-2888.554,-2940.8772,-3011.1038,-3028.8506,-3044.2659,-3057.8992,-3050.0437,-3034.8345,-3067.4712,-3099.3694,-3108.893,-3141.992,-3734.654,-3748.5454,-3758.7537,-3730.7773,-3703.1562,-3657.4016,-3785.3267,-3629.8674,-3592.9358,-3453.9204,-3252.016,-3060.355,-2831.116,-2586.3538,-2066.4136,-1816.9733,-1743.3485,-1211.6848,-917.1569,-1037.5559,-853.81287,-995.45374,-941.5948,-918.67346,-724.2777,-622.328,-589.9725,-657.7909,-691.9655,-1085.2078,-1254.9706,-1593.1715,-1732.4705,-1812.732,-1916.8724,-2088.3015,-2089.1719,-2041.5289,-2129.869,-2093.7485,-2105.299,-2127.5466,-2261.1016,-2198.8975,-2333.2375,-2473.827,-2576.8716,-2670.3833,-2698.01,-2799.789,-2895.6572,-2905.6006,-2825.875,-2758.0027,-2589.1035,-2618.8945,-2652.703,-2634.0735,-2740.9253,-2685.629,-2565.0085,-2753.5173,-2819.3447,-3047.4944,-2770.565,-2708.8516,-2637.6052,-2512.556,-2420.2463,-2460.146,-2492.5393,-2384.0767,-2303.4026,-2299.7278,-2245.4658,-2182.22,-2160.489,-2167.1692,-2150.976,-2196.0427};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {-2251.548,-2228.4995,-2225.6719,-2265.6494,-2304.5537,-2338.843,-2351.8987,-2352.0664,-2332.3196,-2363.775,-2385.1987,-2367.7712,-2361.5808,-2408.0361,-2393.279,-2427.225,-2408.4724,-2356.534,-2318.0503,-2307.3042,-1697.7634,-2129.4182,-2417.8662,-2573.786,-2661.501,-2699.4692,-2620.34,-2681.0083,-2698.307,-2731.5483,-2702.3828,-2812.4114,-2713.7969,-2600.6084,-2876.0627,-2985.8938,-2967.0845,-2965.2795,-3001.0957,-3038.8196,-3052.2644,-3022.7383,-2859.9392,-2821.6096,-2863.3474,-2917.4575,-3131.8928,-3195.386,-3732.8018,-3741.7793,-3758.3547,-3745.349,-3740.3677,-3675.2573,-3653.003,-3657.0254,-3632.346,-3531.1655,-3377.49,-3176.1604,-2988.1013,-2681.9658,-2281.4773,-2457.3384,-2296.0967,-1356.326,-1411.8634,-1142.3595,-1557.4669,-1586.4637,-1436.1499,-1286.0173,-1368.9065,-1501.8771,-1420.3217,-1328.7076,-1379.2992,-1725.6354,-1923.3542,-1969.8297,-1941.9004,-2092.4966,-2131.8384,-2201.4314,-2203.1985,-2204.0537,-2235.096,-2261.671,-2352.0134,-2370.0957,-2328.4626,-2414.2224,-2510.0674,-2572.5156,-2680.9426,-2705.555,-2797.7393,-2873.5613,-3014.8096,-3155.1597};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {-3101.077,-3117.156,-3111.6921,-3015.7776,-2835.292,-2921.1592,-2979.9111,-2927.5095,-2832.681,-2822.7417,-2846.4158,-2849.7124,-2763.729,-2705.6726,-2614.0278,-2474.9976,-2400.5557,-2306.0754,-2353.9229,-2280.7256,-2112.0132,-2028.3269,-1722.054,-1680.0636,-2005.0137,-1972.3387,-1989.3296,-2049.4858,-2033.104,-2008.9417,-2075.5354,-2097.014,-2115.532,-2214.717,-2235.2812,-2260.2478,-2254.4922,-2260.173,-2313.0625,-2313.17,-2274.6084,-2306.7559,-2292.8525,-2304.4348,-2326.8518,-2323.2544,-2339.6318,-2621.1968,-1147.1592,-1574.1234,-2072.809,-2376.3616,-2524.6223,-2701.613,-2652.679,-2708.098,-2595.7896,-2711.0164,-2637.2925,-2784.5864,-2746.6528,-2703.9717,-2586.4707,-2749.2483,-2809.5789,-2990.2507,-3027.4087,-3039.4531,-3051.6494,-2902.0068,-2795.6697,-2840.113,-2810.1697,-3190.727,-2816.2583,-3099.1458,-3759.457,-3753.2827,-3751.5205,-3745.6035,-3736.0056,-3726.4854,-3716.45,-3682.5903,-3636.0308,-3560.1726,-3411.8657,-3248.2676,-3032.025,-2779.427,-2584.4539,-2521.4158,-2477.2349,-2354.568,-2112.5525,-1923.3137,-1838.9246,-1982.9034,-1628.2301,-1539.9485};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {-1850.5554,-1921.9188,-1909.8396,-1882.3324,-1816.114,-1973.8281,-2040.6792,-2027.8898,-2059.9248,-2182.4133,-2166.7214,-2287.4749,-2290.041,-2231.8223,-2348.8652,-2410.1448,-2472.5452,-2519.3042,-2592.2292,-2628.7854,-2661.0542,-2712.0515,-2792.6829,-2812.8784,-2925.4165,-3025.7097,-3092.2144,-3140.4978,-3187.8508,-3252.06,-3227.4988,-3213.2104,-3185.582,-3005.3994,-2987.1685,-3018.433,-2991.9556,-2978.703,-2926.3088,-2831.3286,-2771.347,-2704.233,-2560.7358,-2388.2646,-2284.6328,-2148.8093,-2065.8518,-1994.4673,-1837.069,-1640.3604,-2594.8071,-1763.952,-1527.3492,-1698.697,-1753.7477,-1769.3898,-1753.7372,-1752.5575,-1849.7145,-1921.1874,-1934.0317,-2012.0056,-2048.8384,-2083.2832,-2160.4158,-2175.7903,-2200.441,-2218.3135,-2195.5574,-2230.1743,-2210.2578,-2197.4165,-2220.3975,-2271.9421,-2274.9631,-2219.8293,-2009.2764,-1598.1467,-1177.0908,-2121.072,-2342.427,-2502.3735,-2586.599,-2604.9458,-2588.0525,-2689.2654,-2664.9802,-2738.6125,-2745.8171,-2812.0342,-2694.0657,-2774.3035,-2827.0002,-3001.5889,-3025.8606,-3027.4321,-3032.5881,-2843.592,-2619.4438,-2387.9133};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {-2606.4375,-3600.7275,-2599.839,-2818.7517,-3762.7683,-3772.773,-3745.0386,-3728.8867,-3723.8171,-3720.5244,-3709.683,-3671.7776,-3628.2588,-3557.5352,-3416.8079,-3274.9915,-3064.5762,-2951.5376,-2980.0806,-2576.1262,-2559.2988,-2500.593,-1832.7333,-1879.2043,-2081.0427,-2007.3612,-1867.9529,-1899.2655,-2073.1003,-1918.3212,-2038.2045,-2075.1616,-2138.5847,-2191.3457,-2187.1052,-2156.678,-2115.5645,-2195.7676,-2260.8413,-2700.9043,-2562.706,-2359.4375,-2442.4028,-2557.1006,-2667.1116,-2713.6882,-2770.9834,-2823.2756,-2848.5,-2802.2722,-2923.799,-2973.386,-3018.5647,-3081.8992,-3173.9844,-3236.0208,-3263.1377,-3290.8804,-3325.7517,-3315.1392,-3299.5942,-3207.243,-3046.1614,-3026.6067,-3011.7915,-2997.6807,-2950.8486,-2883.0078,-2764.272,-2668.8433,-2525.9333,-2319.5269,-2148.9966,-2025.4637,-1900.7651,-1728.8594,-1487.1892,-1249.6816,-2145.0684,-1431.582,-1102.3774,-1191.5643,-1423.9349,-1475.8301,-1486.7074,-1500.5276,-1619.8455,-1688.2135,-1779.1891,-1809.0204,-1833.9196,-1969.9692,-2080.6975,-2034.1802,-2045.945,-2086.3066,-2122.1719,-2132.8975,-2126.9785,-2137.8171};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {-2160.044,-2197.1084,-2202.2705,-2221.2322,-2183.011,-2101.9548,-1509.6674,-1785.6755,-2064.747,-2192.1838,-2493.668,-2554.0464,-2594.048,-2662.949,-2659.2957,-2716.9104,-2736.5354,-2854.6375,-2857.3745,-2766.878,-2810.7466,-2948.0713,-2995.4465,-3018.2632,-3013.2214,-2885.9912,-2620.525,-2495.7617,-2343.351,-3634.4734,-3093.583,-2229.8972,-3737.1865,-3737.0432,-3684.355,-3688.1462,-3706.2693,-3693.5396,-3663.028,-3636.2544,-3622.7097,-3530.965,-3441.7766,-3269.3286,-3055.531,-2811.6746,-2684.6099,-2650.6116,-2608.8218,-2612.189,-2307.6892,-2306.4626,-2300.3857,-2151.619,-1972.6709,-2021.8397,-2096.8865,-2251.9626,-2288.008,-2126.3618,-2222.3562,-2449.3042,-2351.8833,-2255.8794,-2265.41,-2289.0984,-2350.845,-2556.7627,-2554.9297,-2520.2751,-2558.6655,-2745.591,-2798.1946,-2823.691,-2917.2031,-3012.007,-2988.8398,-3047.7253,-3081.1455,-3146.5833,-3159.0374,-3154.5796,-3250.488,-3277.7534,-3320.0542,-3347.1167,-3348.24,-3371.0112,-3347.664,-3286.6353,-3191.6382,-3071.3018,-3075.5227,-3052.8804,-2971.7112,-2878.2153,-2679.5015,-2516.3262,-2398.787,-2219.443};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {-1982.7083,-1775.1986,-1632.2218,-1491.1375,-1248.2216,-1060.0182,-909.47614,-884.89355,-921.1509,-893.7494,-1115.19,-1213.8276,-1216.3247,-1230.9629,-1322.6775,-1447.7786,-1517.0463,-1534.6744,-1657.1289,-1830.7555,-1939.0616,-1959.4993,-1925.3868,-1976.9126,-2038.9231,-2060.6519,-2067.6543,-2091.0586,-2104.4126,-2135.5466,-2147.8208,-2186.2434,-2168.7122,-2187.8337,-2048.034,-2160.7202,-2064.2646,-1741.2764,-2169.5986,-2498.0718,-2540.539,-2615.0466,-2741.0706,-2719.686,-2731.473,-2771.2268,-2711.8867,-2656.6858,-2888.3274,-2767.0327,-2881.443,-2981.7773,-3023.1348,-2920.1873,-2796.5342,-2553.0413,-2223.1978,-3627.995,-3594.4363,-2646.8174,-3697.4895,-3689.6062,-3667.4895,-3654.6992,-3656.4285,-3667.8281,-3654.198,-3617.0596,-3602.7856,-3544.7754,-3441.005,-3310.359,-3120.5537,-2931.32,-2790.4011,-2699.9548,-2620.689,-2594.461,-2511.004,-2437.9983,-2395.3635,-2329.4568,-2225.015,-2157.3652,-2214.8127,-2312.457,-2356.5728,-2253.3555,-2247.1855,-2360.961,-2315.094,-2301.2812,-2350.5251,-2385.1921,-2434.9258,-2540.1257,-2577.6182,-2670.3457,-2693.576,-2940.9526};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-2887.9417,-2936.775,-3116.3228,-3099.6719,-3110.8528,-3149.4104,-3196.4756,-3221.1135,-3229.6145,-3221.28,-3273.79,-3311.1848,-3347.5996,-3364.2812,-3344.1318,-3385.0613,-3381.179,-3347.8333,-3308.383,-3161.1072,-3090.8918,-3064.0015,-3019.466,-2909.7654,-2719.213,-2425.4126,-2207.023,-2099.1394,-1952.0878,-1711.376,-1527.5516,-1366.0746,-1122.3232,-935.6789,-813.5865,-752.8289,-719.298,-654.7967,-629.9247,-749.2899,-817.953,-902.78436,-985.72406,-1101.2877,-1217.8274,-1321.4535,-1492.5056,-1703.8304,-1799.9358,-1829.7748,-1836.2893,-1897.0131,-1947.594,-1981.3167,-2012.2428,-2021.0646,-2036.0255,-2074.5085,-2060.3215,-2120.759,-2147.692,-2164.1733,-2165.5425,-2186.9087,-2178.0476,-2071.1182,-1510.0339,-2320.828,-2554.0864,-2621.556,-2690.4753,-2753.7693,-2748.2869,-2775.167,-2700.3696,-2485.9338,-2571.358,-2725.5513,-2789.6604,-2905.0261,-3027.3608,-3003.4219,-2907.331,-2670.4043,-2350.868,-3669.4163,-3676.4578,-3418.6707,-3697.1196,-3681.274,-3672.5103,-3670.2297,-3629.0159,-3629.6208,-3623.8132,-3613.044,-3604.9668,-3524.6475,-3419.4053,-3312.8787};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {-3197.0518,-3003.3203,-2852.066,-2771.8474,-2729.2407,-2659.5154,-2669.2773,-2538.4377,-2501.3003,-2451.552,-2384.7515,-2354.1555,-2345.9731,-2397.5884,-2420.9858,-2320.7568,-2291.6223,-2387.043,-2390.8486,-2377.5098,-2457.135,-2523.4495,-2603.03,-2725.069,-2698.7563,-2821.2214,-2942.3525,-3058.1167,-2920.857,-3044.9668,-3128.4287,-3174.8027,-3107.3699,-3170.4377,-3238.1206,-3269.7478,-3247.2395,-3281.4949,-3292.4612,-3327.484,-3363.5024,-3378.6877,-3369.621,-3374.5708,-3419.556,-3402.0408,-3376.5713,-3331.6418,-3159.6487,-3082.3655,-3019.9016,-2938.028,-2635.8674,-2356.7527,-2153.3555,-1986.7117,-1817.541,-1503.6431,-1307.8508,-1163.8658,-936.2993,-760.47766,-638.18195,-540.84973,-449.485,-391.72064,-218.4201,-211.12007,-404.38116,-558.6578,-668.31964,-761.97986,-842.11926,-1103.2731,-1347.8196,-1549.8431,-1696.2123,-1738.8693,-1721.7429,-1814.8809,-1875.9735,-1970.8666,-1935.814,-1947.8274,-1935.6814,-1990.0778,-2035.4034,-2082.8105,-2120.154,-2142.7666,-2182.4768,-2225.196,-2242.6946,-2246.7966,-2172.8984,-2370.783,-2551.4353,-2597.2292,-2673.815,-2826.6587};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {-2679.0938,-2740.795,-2746.98,-2524.353,-2643.6865,-2798.7544,-2843.481,-2934.1758,-3031.6985,-3047.0618,-3029.032,-2812.3933,-2267.5237,-3592.7234,-3677.2334,-3634.5444,-3694.6719,-3696.0342,-3696.0403,-3692.673,-3660.0518,-3647.6082,-3626.5403,-3620.8303,-3586.1245,-3525.6401,-3446.3337,-3326.8123,-3189.7302,-3020.371,-2913.3237,-2787.3774,-2750.759,-2811.3923,-2737.694,-2674.2144,-2596.9097,-2560.292,-2496.6968,-2479.623,-2459.0723,-2495.3318,-2517.8086,-2515.814,-2457.0576,-2452.5437,-2490.1895,-2577.5005,-2649.4312,-2708.0823,-2804.8472,-2847.7307,-2874.918,-2930.501,-3074.3528,-3237.0212,-3088.3894,-3160.1213,-3167.3418,-3243.5037,-3247.101,-3235.9011,-3309.499,-3338.1606,-3290.8982,-3292.9812,-3348.9043,-3384.4392,-3434.6133,-3454.4905,-3452.5698,-3409.3381,-3461.3604,-3458.2668,-3430.8352,-3431.185,-3297.8977,-3140.6777,-3004.4692,-2848.5876,-2662.4458,-2319.1558,-2102.0774,-1898.4169,-1606.5781,-1536.331,-1155.1855,-962.338,-777.42413,-589.1666,-452.1103,-315.67642,-208.08775,-139.86456,10.08708,58.545048,-25.671215,-177.1681,-303.71228,-333.6391};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {-505.8249,-825.35895,-1145.1155,-1359.0413,-1584.7743,-1653.6101,-1649.5385,-1774.9006,-1822.0496,-1833.8083,-1821.24,-1835.3335,-1843.8999,-1894.8978,-1966.1648,-2009.9283,-2070.5579,-2064.9211,-2179.8125,-2275.2961,-2297.5486,-2396.8103,-2444.5063,-2399.9968,-2557.2498,-2587.6157,-2583.9934,-2498.409,-2414.0405,-2745.6067,-2710.9646,-2718.4934,-2860.6272,-2901.825,-2929.0432,-2978.1301,-3007.133,-3025.1565,-2952.2825,-2759.5747,-2414.872,-3102.5647,-3702.6858,-3707.1921,-3706.3328,-3702.8103,-3687.4194,-3674.88,-3645.6887,-3628.0088,-3607.2212,-3588.8445,-3551.1733,-3484.3047,-3413.8962,-3346.8628,-3241.713,-3112.1997,-2996.8838,-2869.2998,-3066.6719,-2906.389,-2847.1929,-2850.9407,-2723.578,-2732.4456,-2662.855,-2669.0671,-2667.1592,-2692.8113,-2675.6763,-2678.6704,-2664.7268,-2623.302,-2768.54,-2808.3499,-2903.0713,-2934.934,-3028.488,-3057.7588,-3027.9282,-3103.325,-3182.6487,-3239.257,-3206.5703,-3291.2783,-3256.6975,-3316.512,-3295.7385,-3292.038,-3356.3726,-3413.9773,-3393.8625,-3380.9023,-3449.8542,-3460.1138,-3488.2107,-3493.2725,-3504.8499,-3464.4355};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {-3461.2246,-3501.8704,-3477.5852,-3462.679,-3431.0254,-3201.5632,-2984.5527,-2805.19,-2572.8254,-2354.8342,-2125.296,-1887.6238,-1520.3563,-1380.9421,-1011.57324,-796.1964,-623.4477,-443.637,-267.16946,-90.40994,47.220154,120.59141,250.07318,335.58374,322.1185,237.10036,125.181725,-2.165306,-233.39381,-539.3072,-890.53485,-1214.4691,-1478.7455,-1577.9275,-1604.7749,-1682.77,-1740.6864,-1726.7163,-1713.7104,-1710.1041,-1744.1548,-1787.9642,-1882.7786,-1931.9958,-2164.9744,-1990.2544,-2120.4648,-2247.8643,-2273.0344,-2364.4756,-2410.0547,-2448.2002,-2535.0107,-2567.3733,-2572.4326,-2544.7036,-2260.4353,-2061.6587,-2667.0725,-2723.476,-2882.6106,-2927.2158,-2987.7139,-3056.0059,-3046.5327,-2954.5647,-2918.8254,-2858.8064,-2742.7866,-2448.592,-3721.372,-3755.2368,-3647.7786,-3671.0945,-3679.6494,-3652.5469,-3652.7366,-3616.5103,-3583.2505,-3561.181,-3519.574,-3454.537,-3419.442,-3336.3965,-3284.302,-3209.337,-3102.518,-2978.999,-2955.6423,-3010.2048,-3000.1628,-3078.5178,-3013.8108,-2954.4004,-2902.4255,-2897.2578,-2890.3567,-2948.6658,-2908.7761,-2868.585};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {-2949.9497,-2923.948,-3094.114,-3085.2302,-3047.2993,-3097.4583,-3157.26,-3219.332,-3178.4778,-3193.6963,-3256.627,-3293.1638,-3330.6914,-3377.565,-3357.8345,-3392.9656,-3422.3062,-3407.0898,-3387.9863,-3443.511,-3491.9836,-3475.4285,-3490.8494,-3535.6973,-3543.984,-3536.2644,-3543.464,-3528.7927,-3461.0925,-3508.4993,-3528.1736,-3495.4644,-3486.1143,-3375.992,-3084.1062,-2847.6099,-2611.5596,-2362.987,-2121.9922,-1936.2761,-1545.4269,-1173.4064,-889.8007,-645.70514,-412.28687,-252.2324,-75.4609,159.87949,302.45895,382.25104,516.3914,623.91223,634.0909,596.97034,478.8368,335.20886,64.58308,-268.81174,-700.9666,-1116.0302,-1459.512,-1526.4891,-1538.444,-1578.6741,-1619.4331,-1624.5132,-1615.5446,-1599.7112,-1662.1971,-1742.9119,-1790.6075,-1838.6611,-2019.6455,-1953.5237,-2004.5466,-2155.23,-2214.2202,-2302.2622,-2364.9246,-2449.392,-2512.513,-2544.5664,-2584.4238,-2627.8123,-2605.5332,-2184.656,-2275.735,-2695.5273,-2827.2932,-2974.7441,-3079.8215,-3304.2805,-3085.132,-3042.905,-2991.331,-2991.3394,-2912.7556,-2602.5125,-3390.3394,-3509.9963};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {-3610.9336,-3626.914,-3638.8684,-3626.9683,-3617.0835,-3584.8743,-3560.5457,-3582.7441,-3517.519,-3461.7507,-3408.775,-3372.1826,-3361.4683,-3276.5415,-3245.8303,-3215.5034,-3192.6626,-3199.3235,-3171.3904,-3194.5627,-3229.5989,-3194.855,-3154.4014,-3157.5684,-3120.5293,-3169.0312,-3153.112,-3126.3457,-3199.3862,-3164.9988,-3317.1414,-3178.0425,-3233.129,-3217.88,-3264.949,-3329.3232,-3336.572,-3328.4907,-3345.4214,-3354.3037,-3429.998,-3425.003,-3438.1074,-3467.3367,-3528.1868,-3500.06,-3476.119,-3478.6677,-3521.9321,-3532.4363,-3507.0208,-3580.6438,-3597.6318,-3587.6296,-3598.6538,-3578.6472,-3527.7036,-3482.2,-3555.0593,-3529.7212,-3493.1565,-3390.8682,-3166.6196,-2923.2712,-2657.5403,-2381.009,-2094.8247,-1781.4939,-1483.0544,-1144.2277,-734.39764,-459.69714,-188.63455,45.343246,279.39774,420.1626,580.0689,673.8997,786.4315,796.0708,805.31024,776.5873,691.54315,568.6108,370.60992,305.60782,-50.037018,-869.117,-1392.2435,-1415.7026,-1393.631,-1442.339,-1491.2638,-1487.2843,-1513.8322,-1540.587,-1628.9509,-1701.4362,-1706.8397,-1776.2885};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {-1831.7732,-1902.7316,-1972.6534,-2105.2456,-2160.284,-2266.7583,-2359.8674,-2432.0886,-2474.6477,-2533.8035,-2574.531,-2625.339,-2643.087,-2573.4014,-2636.927,-2635.4321,-2449.3396,-2921.9097,-2986.9575,-3156.666,-3183.8535,-3090.1257,-3097.5383,-3062.5889,-3008.7869,-2988.6055,-3057.4624,-3110.5178,-3595.0007,-3567.9854,-3575.5806,-3586.8528,-3588.9995,-3575.8657,-3544.6677,-3562.6047,-3511.9956,-3419.5645,-3410.632,-3392.063,-3381.08,-3343.4998,-3310.3477,-3350.454,-3294.91,-3316.5012,-3277.4778,-3301.7808,-3366.0815,-3375.9807,-3334.8062,-3310.069,-3283.9033,-3322.7915,-3368.63,-3365.8696,-3360.3123,-3340.2039,-3290.4734,-3273.6536,-3345.0354,-3425.155,-3415.041,-3405.6226,-3412.5483,-3398.9014,-3452.7957,-3495.9563,-3535.9194,-3535.1003,-3535.1067,-3575.9102,-3580.6519,-3533.8638,-3548.11,-3566.8098,-3555.5923,-3576.6807,-3574.9192,-3602.3794,-3620.9648,-3626.816,-3620.8237,-3621.1602,-3626.1187,-3531.7834,-3546.0366,-3590.4778,-3515.8748,-3383.7942,-3197.7148,-2942.3818,-2636.3806,-2336.7468,-2009.5183,-1635.0858,-1248.682,-949.50104,-615.70935,-240.39328};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {96.20139,346.74487,587.0864,711.3302,867.6519,980.8134,1019.0973,957.5727,904.5641,791.786,631.0148,506.61996,670.15857,2163.3757,2385.412,359.1728,-1200.1565,-1267.3799,-1258.2512,-1289.5894,-1369.3291,-1394.5128,-1476.1559,-1519.1697,-1567.7767,-1635.0967,-1676.2672,-1738.7827,-1794.4878,-1889.5417,-1990.3475,-2086.1448,-2151.67,-2267.0278,-2343.0083,-2389.4187,-2471.004,-2526.0908,-2555.0764,-2599.004,-2638.208,-2644.3413,-2629.2476,-2665.9065,-2746.4336,-2756.6145,-2663.757,-3064.492,-3218.3523,-3114.065,-3106.024,-3095.0784,-3031.9475,-3064.9136,-3170.9429,-3225.4893,-3614.7146,-3562.3105,-3559.109,-3557.4697,-3568.1272,-3539.3828,-3528.2183,-3534.5154,-3532.1177,-3475.602,-3432.7556,-3438.5125,-3411.6426,-3404.7876,-3386.3076,-3382.8577,-3352.0784,-3358.5984,-3388.9558,-3389.1782,-3423.3054,-3458.2434,-3452.9802,-3427.5884,-3410.5183,-3419.1304,-3438.2,-3424.431,-3436.3684,-3427.115,-3397.2935,-3378.2212,-3434.3604,-3498.8567,-3508.103,-3511.778,-3507.1023,-3489.815,-3553.1694,-3586.7244,-3623.428,-3608.7227,-3589.8188,-3607.5576};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {-3640.2175,-3609.528,-3570.1997,-3599.574,-3627.58,-3631.6877,-3619.029,-3604.7673,-3633.6765,-3675.5034,-3668.8433,-3669.5818,-3687.5525,-3657.8135,-3566.1821,-3585.276,-3560.1875,-3418.7808,-3199.9065,-2928.2073,-2612.1885,-2255.7876,-1914.6135,-1536.1357,-1194.0552,-764.83374,-439.34552,32.91162,320.79834,601.5903,846.22986,967.0795,1072.866,1134.5957,1110.7732,1083.1101,981.7034,824.55707,631.39215,451.34286,837.1677,2739.172,2687.2896,1207.5969,-812.2979,-1037.7427,-1075.6697,-1178.8212,-1257.7344,-1342.1223,-1416.5212,-1429.6495,-1491.4067,-1571.0481,-1618.8344,-1729.4185,-1801.0663,-1867.0756,-1991.9153,-2123.2817,-2163.5269,-2252.4868,-2337.024,-2410.285,-2460.904,-2525.51,-2562.7974,-2613.6094,-2634.0557,-2631.2236,-2794.2869,-2736.4043,-2867.4238,-2792.4607,-2659.4546,-2957.2468,-3153.5015,-3145.453,-3146.3618,-3091.3418,-3033.6826,-3017.483,-3120.009,-3262.7744,-3586.4622,-3557.3638,-3523.828,-3537.9102,-3533.586,-3541.6768,-3539.055,-3519.1338,-3527.1143,-3497.7778,-3479.2034,-3453.7686,-3436.6277,-3469.1318,-3490.7905,-3422.8247};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-3428.8547,-3461.625,-3466.8171,-3447.9465,-3482.4705,-3534.441,-3546.1643,-3524.7131,-3502.6196,-3496.8013,-3516.5447,-3516.4233,-3509.5906,-3529.8164,-3510.8804,-3479.2856,-3565.5007,-3607.7559,-3628.5764,-3622.3428,-3613.6106,-3575.4556,-3627.6138,-3666.9026,-3667.094,-3622.1946,-3592.2378,-3627.5452,-3657.96,-3654.7258,-3617.3098,-3614.1296,-3661.2231,-3677.0808,-3641.859,-3628.9395,-3636.0256,-3685.3604,-3697.2354,-3713.2678,-3733.0183,-3709.2834,-3668.6497,-3592.9146,-3582.7063,-3464.2217,-3255.4792,-2954.9067,-2618.769,-2255.0483,-1870.2041,-1416.2642,-1015.65375,-538.13574,-201.4761,215.65321,640.8222,882.6101,1081.8419,1185.9948,1253.8386,1318.1406,1291.35,1287.2904,1196.0829,1048.8938,823.223,524.0756,429.5269,1141.1652,1187.5004,117.329025,-669.1133,-818.04144,-921.8796,-1032.9668,-1140.9767,-1233.7014,-1291.9026,-1305.6752,-1416.8331,-1527.3584,-1569.8247,-1708.6212,-1831.8082,-1905.2902,-2011.9021,-2312.208,-2169.8584,-2244.223,-2320.2395,-2424.9534,-2476.3533,-2546.5818,-2568.1794,-2622.0264,-2637.7312,-2661.4812,-2754.219,-2777.2097};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {-2924.0562,-2869.4978,-2698.1797,-2969.799,-3159.6157,-3162.226,-3165.4104,-3104.9268,-3121.789,-3156.2234,-3191.1145,-3282.3264,-3554.4202,-3533.9102,-3500.416,-3480.626,-3497.5193,-3525.4143,-3544.0664,-3515.1404,-3491.5059,-3464.5884,-3471.1235,-3470.1052,-3487.1501,-3506.973,-3501.4434,-3471.785,-3518.4055,-3545.563,-3575.6604,-3541.97,-3558.035,-3613.4353,-3622.731,-3590.295,-3558.4365,-3566.8098,-3591.0286,-3594.801,-3580.4585,-3625.1445,-3614.9292,-3612.4993,-3644.1782,-3675.2798,-3688.379,-3680.7043,-3670.0486,-3620.3064,-3670.1755,-3696.387,-3700.0051,-3653.2097,-3640.7607,-3673.8245,-3708.4678,-3713.986,-3694.2974,-3674.6663,-3716.5842,-3702.1267,-3696.4558,-3709.3896,-3638.3916,-3694.1074,-3733.9165,-3743.8423,-3736.5576,-3739.4175,-3742.2615,-3705.3984,-3637.3845,-3567.9202,-3316.7083,-3000.5632,-2692.902,-2421.8057,-1800.8494,-1304.3281,-845.3368,-356.63376,76.676544,439.5791,843.7989,1164.8927,1305.3057,1318.7229,1318.7051,1385.4807,1377.2455,1442.6715,1394.2231,1318.1697,1075.973,824.216,508.5971,243.54819,14.208901,-257.6804};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {-477.53876,-647.4281,-792.9074,-917.9016,-1030.5669,-1132.248,-1191.8385,-1236.1058,-1365.7012,-1475.4592,-1567.5753,-1684.3356,-1829.0106,-1917.87,-1977.6808,-2082.5466,-2145.8591,-2203.2185,-2285.4358,-2389.7705,-2463.0012,-2525.3564,-2527.521,-2665.5886,-2668.8032,-2697.997,-2788.605,-2827.7744,-2947.1765,-2960.867,-2492.1064,-2755.8757,-3144.8098,-3191.841,-3187.65,-3144.3516,-3200.142,-3238.9802,-3213.0605,-3300.0251,-3465.7566,-3460.8835,-3504.3057,-3467.1738,-3472.0837,-3486.3843,-3538.5378,-3510.513,-3513.9277,-3454.428,-3515.0847,-3525.231,-3513.163,-3485.6775,-3481.617,-3522.8213,-3557.535,-3587.68,-3615.9194,-3624.3242,-3584.2969,-3623.7593,-3645.732,-3642.9766,-3634.1694,-3654.647,-3671.471,-3667.9883,-3651.7437,-3686.0093,-3665.0457,-3655.0154,-3675.6348,-3712.304,-3731.86,-3741.9304,-3739.5786,-3715.236,-3741.8145,-3765.1423,-3762.3254,-3729.1794,-3725.6729,-3744.5527,-3772.5542,-3772.395,-3752.607,-3746.4355,-3765.2002,-3787.4185,-3777.0615,-3767.4592,-3726.277,-3722.2893,-3783.4465,-3791.7598,-3790.4976,-3777.041,-3788.571,-3765.9666};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {-3719.085,-3661.8364,-3454.2932,-3287.9265,-2981.4282,-2390.1992,-1820.5426,-1339.4697,-853.48,-328.94287,137.11493,585.5127,961.93005,1254.2035,1330.2756,1337.4817,1360.8022,1395.4563,1395.2013,1473.7845,1522.737,1522.6984,1376.0897,1224.3197,956.3335,650.3534,382.23602,78.5839,-274.5259,-491.5099,-682.2066,-807.9112,-908.7858,-1011.86566,-1128.372,-1199.045,-1314.9788,-1425.8168,-1553.7719,-1686.6263,-1805.0052,-1958.9944,-2086.2388,-2081.537,-2164.695,-2248.296,-2296.8647,-2406.8105,-2478.7852,-2489.3328,-2505.3157,-2649.3672,-2734.68,-2785.6738,-2857.695,-2867.0757,-2970.7874,-3019.741,-2373.7126,-2707.5852,-3201.6191,-3204.246,-3211.4924,-3164.5051,-3184.919,-3260.5076,-3289.0613,-3317.0598,-3310.753,-3381.6145,-3408.7058,-3438.7842,-3469.9185,-3514.1277,-3525.2783,-3544.3647,-3520.0293,-3455.3025,-3500.9536,-3488.666,-3500.819,-3499.5056,-3507.253,-3573.1406,-3632.6968,-3661.6797,-3698.866,-3706.7021,-3651.7646,-3667.9458,-3691.299,-3705.201,-3705.751,-3729.5732,-3718.1362,-3722.7185,-3708.8447,-3741.073,-3740.4685,-3732.5881};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {-3742.905,-3785.0117,-3812.2505,-3808.8835,-3821.5698,-3823.2095,-3817.204,-3839.8005,-3867.106,-3798.9666,-3804.3247,-3803.5728,-3818.0784,-3833.7744,-3826.633,-3819.0735,-3818.1626,-3830.7478,-3832.7903,-3838.3796,-3828.948,-3789.3198,-3852.3145,-3870.655,-3871.4846,-3837.947,-3833.347,-3804.2026,-3795.9526,-3775.4258,-3700.9778,-3471.7458,-2934.2117,-2398.3525,-1772.8843,-1285.1122,-765.0552,-213.9347,292.94052,791.8309,1077.4836,1115.1066,789.0507,1192.3527,1400.9652,1383.2847,1338.8951,1423.2579,1607.4285,1790.4071,1790.8593,1698.3899,1429.0779,1068.5145,729.0856,361.23083,20.18597,-276.49295,-487.90543,-665.8991,-783.78503,-951.66425,-1113.4218,-1205.1862,-1305.3652,-1422.153,-1536.8114,-1711.5858,-1840.6636,-1965.7814,-2026.1293,-2109.5337,-2181.7307,-2275.1702,-2333.4468,-2435.302,-2484.9377,-2483.8782,-2367.7727,-2697.3667,-2784.0754,-2837.5217,-2893.0347,-2919.6711,-3005.7883,-3030.3567,-2889.2957,-3087.4082,-3208.3208,-3192.9976,-3219.0283,-3186.817,-3137.4336,-3088.3564,-3310.4668,-3353.2488,-3270.0183,-3307.1619,-3366.9236,-3434.8079};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_42()
		{
			double[] value = {-3446.9763,-3486.334,-3518.9792,-3540.5806,-3487.1033,-3500.482,-3558.1382,-3545.787,-3559.5244,-3575.612,-3585.561,-3686.4897,-3640.5674,-3713.0815,-3734.329,-3752.6602,-3732.5312,-3691.1536,-3733.5674,-3766.2402,-3741.5574,-3776.2468,-3793.6636,-3788.5725,-3795.6882,-3817.8806,-3842.0447,-3838.315,-3842.5752,-3856.154,-3897.6335,-3884.211,-3906.3037,-3925.908,-3914.759,-3942.7524,-3943.5042,-3910.1484,-3910.7546,-3915.3374,-3910.5251,-3914.6565,-3911.7385,-3899.2053,-3898.2139,-3897.8477,-3889.9224,-3897.2441,-3906.0977,-3866.1145,-3904.5854,-3944.4744,-3964.1208,-3906.133,-3879.9436,-3878.6704,-3878.9788,-3828.541,-3701.3743,-3348.5051,-2867.863,-2334.7026,-1732.3358,-1142.1558,-634.2315,-147.59366,337.0355,817.62854,1149.2139,918.81415,907.76483,1343.9347,1385.6605,1355.105,1349.5162,1527.5393,2010.669,2340.2393,2393.096,2278.948,1999.1807,1562.1443,1142.6652,615.513,211.87572,-81.20748,-364.68582,-586.9322,-759.7186,-957.3049,-1093.2653,-1223.5605,-1356.0806,-1461.7019,-1565.757,-1692.3201,-1810.7001,-1935.9037,-2050.2888,-2130.5503};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_43()
		{
			double[] value = {-2193.7078,-2303.6106,-2366.5903,-2472.7886,-2542.5247,-2553.925,-2459.6526,-2661.6775,-2853.8572,-2872.8691,-2916.1768,-2892.598,-2944.7642,-3073.6003,-3069.6533,-3159.7664,-3186.6147,-3161.8293,-3296.088,-3198.145,-3044.9038,-3319.068,-3607.428,-3369.3162,-3269.3872,-3315.6987,-3390.9602,-3395.247,-3440.1785,-3532.901,-3517.1445,-3515.0984,-3490.296,-3559.5264,-3601.9587,-3609.2708,-3627.704,-3643.1074,-3628.236,-3694.1328,-3691.3423,-3717.2876,-3769.2017,-3795.1604,-3781.7607,-3729.8398,-3780.983,-3818.1865,-3806.8079,-3839.4233,-3861.4336,-3855.7998,-3880.274,-3890.5962,-3924.0852,-3949.1973,-3926.764,-3969.6086,-3977.7656,-3989.4688,-4037.165,-4021.834,-4015.1187,-4027.302,-4006.4211,-3982.612,-4012.4297,-4014.2454,-4004.6477,-3981.5664,-3974.059,-3969.4146,-3969.13,-3982.928,-3959.0437,-3958.929,-3966.2207,-3954.6504,-3954.0781,-3991.8667,-3998.5588,-3979.393,-3951.8743,-3957.4158,-3927.896,-3872.0942,-3728.3887,-3390.9565,-3006.0454,-2563.703,-1925.482,-1314.2672,-675.31177,-89.25097,355.99326,814.3473,974.692,979.57465,1294.6198,1342.3546};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_44()
		{
			double[] value = {1365.1018,1384.2644,1470.6888,2084.5417,3476.1409,4180.465,3641.6401,3067.533,2633.7031,2085.009,1402.5042,773.74176,365.81586,11.747856,-284.02814,-529.73157,-738.93475,-898.3558,-1082.8131,-1266.3905,-1397.1779,-1485.1332,-1568.3711,-1691.5903,-1870.5446,-1931.7793,-2040.9225,-2125.1377,-2187.2559,-2262.585,-2362.7627,-2511.5247,-2589.6975,-2623.6897,-2635.3994,-2747.0364,-2937.0105,-2931.4326,-2968.7131,-2934.3235,-2653.184,-3044.0989,-3075.9585,-3178.6614,-3172.4414,-3204.9683,-3194.9626,-3133.6467,-2981.1648,-3368.484,-3382.139,-3406.1335,-3249.0283,-3338.126,-3403.6538,-3447.6685,-3507.5466,-3518.7212,-3508.3042,-3509.6147,-3551.7869,-3601.2676,-3630.7068,-3662.552,-3690.835,-3716.8794,-3689.8665,-3707.0024,-3732.8904,-3791.1125,-3793.0935,-3810.0813,-3807.686,-3804.0571,-3859.4836,-3874.7463,-3870.3137,-3885.1892,-3906.3784,-3930.0745,-3970.634,-3983.168,-4009.7546,-4049.5833,-4052.4604,-4065.2715,-4068.085,-4107.948,-4120.6494,-4101.1978,-4098.272,-4085.7842,-4090.2378,-4098.237,-4100.977,-4058.4038,-4040.4175,-4046.901,-4076.7336,-4057.894};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_45()
		{
			double[] value = {-4074.006,-4060.0508,-4052.971,-4049.9604,-4034.4521,-4021.78,-4019.4983,-4032.0205,-4043.3835,-4027.653,-4015.0918,-3983.4243,-3930.5251,-3882.6465,-3786.1067,-3623.5479,-3353.3992,-2858.1382,-2191.9446,-1538.2623,-866.8737,-220.19893,350.96622,726.90155,873.6213,1168.5735,1315.7036,1340.6357,1364.8201,1480.5155,1920.7148,3728.0947,7010.3516,8389.082,6313.9263,4160.225,3195.395,2339.0903,1536.5309,930.0168,379.15778,-12.761273,-341.62634,-615.8227,-785.33075,-924.1401,-1078.9312,-1253.2245,-1388.2112,-1520.4974,-1615.3569,-1672.8954,-1845.3029,-1945.4126,-2060.2007,-2153.709,-2158.6465,-2256.457,-2357.3489,-2504.9204,-2589.3828,-2663.483,-2706.0952,-2765.4954,-2908.4902,-2963.298,-2945.4248,-3004.9739,-2909.7346,-3114.6204,-3162.2551,-3182.962,-3171.9922,-3257.1736,-3017.1528,-2694.086,-3178.2988,-3424.0066,-3424.1245,-3437.1138,-3327.1155,-3373.7954,-3408.221,-3469.843,-3523.579,-3519.2573,-3544.7253,-3604.189,-3625.5679,-3644.4377,-3684.03,-3697.0386,-3720.3096,-3742.075,-3759.1953,-3750.0386,-3800.725,-3835.2874,-3848.861,-3845.7266};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_46()
		{
			double[] value = {-3866.6086,-3882.2297,-3905.9548,-3920.2988,-3936.2122,-3955.398,-3973.496,-4002.4165,-4051.6274,-4058.524,-4100.453,-4129.1772,-4142.426,-4160.3145,-4156.212,-4198.0566,-4184.137,-4188.0684,-4170.5527,-4181.1113,-4155.0166,-4168.143,-4165.7524,-4133.75,-4120.9844,-4111.545,-4116.808,-4125.445,-4127.895,-4136.4634,-4121.854,-4112.8813,-4089.0625,-4084.4736,-4067.5486,-4071.8276,-4053.9724,-4021.3784,-4020.5942,-3995.9001,-3932.1042,-3891.2053,-3856.4087,-3850.5596,-3677.374,-3157.9797,-2443.3958,-1815.5685,-1153.0665,-439.0617,131.71991,637.06885,834.81256,1136.8735,1283.5594,1359.2576,1403.7217,1741.9911,2545.5994,5156.633,9937.767,11888.32,8058.2505,4947.7783,3552.4087,2557.4539,1641.7726,912.91656,348.2079,-82.60907,-411.85107,-596.63995,-829.12897,-988.8569,-1105.5917,-1238.3611,-1378.5446,-1521.7263,-1628.7548,-1686.6754,-1846.0569,-1940.2875,-2074.3704,-2168.3372,-2155.5142,-2274.9934,-2391.2354,-2526.1453,-2634.756,-2698.4548,-2819.7698,-2822.8203,-2973.5857,-2920.9812,-2765.287,-3066.3176,-3060.2932,-3087.1143,-3184.9966,-3236.3396};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_47()
		{
			double[] value = {-3221.669,-3201.2393,-2757.5352,-3020.846,-3374.3906,-3428.289,-3415.606,-3421.1807,-3350.4504,-3393.6099,-3434.5938,-3476.0498,-3497.9744,-3545.806,-3650.421,-3692.076,-3703.356,-3702.546,-3699.4514,-3737.6755,-3758.1365,-3743.035,-3737.1113,-3808.1387,-3862.7126,-3881.312,-3896.0308,-3891.9136,-3931.4482,-3946.6533,-3966.93,-3987.3833,-4015.376,-4034.2202,-4078.853,-4109.365,-4170.6177,-4168.0454,-4188.614,-4225.142,-4226.885,-4235.651,-4244.3013,-4260.1333,-4242.962,-4236.699,-4207.9697,-4244.6323,-4226.557,-4218.3867,-4223.1167,-4197.6445,-4195.7354,-4187.8203,-4196.4536,-4178.8403,-4179.1465,-4183.202,-4188.7993,-4173.081,-4160.563,-4136.526,-4116.225,-4092.2104,-4058.765,-4025.4678,-4012.5195,-3986.917,-3976.65,-3941.8386,-3927.0337,-3921.9414,-3844.531,-3463.4194,-2846.6685,-2191.5632,-1377.4833,-475.04935,176.94687,599.15027,856.1364,1052.3959,1275.3679,1378.9247,1393.7491,1878.6034,2687.8345,4667.035,8040.5234,9224.128,6834.5815,4422.1206,3351.8962,2596.7017,1625.6931,723.9006,208.08252,-170.14256,-455.80173,-664.36914};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_48()
		{
			double[] value = {-901.2215,-1091.6239,-1206.2924,-1286.2186,-1428.9805,-1531.9058,-1653.7045,-1775.5775,-1908.9014,-2009.1051,-2111.8542,-2196.3313,-2236.067,-2306.813,-2436.421,-2629.6694,-2723.7815,-2739.0786,-2862.8586,-2890.685,-2983.9614,-2973.5608,-2903.6892,-3148.917,-3119.3845,-3131.0554,-3219.5688,-3212.8455,-3154.451,-3164.424,-2829.027,-3246.5486,-3433.2505,-3451.036,-3451.616,-3445.7278,-3400.6238,-3465.794,-3486.2388,-3586.5974,-3626.144,-3693.9192,-3703.4187,-3722.339,-3720.4106,-3715.3208,-3730.9902,-3777.802,-3794.888,-3786.515,-3834.8276,-3834.989,-3919.914,-3939.6887,-3943.09,-3938.3037,-3989.7302,-4030.0898,-4030.6926,-4066.625,-4092.2795,-4114.844,-4160.1807,-4212.615,-4259.734,-4236.1626,-4246.6235,-4293.434,-4315.6455,-4319.8364,-4316.6323,-4306.2256,-4313.3535,-4300.27,-4298.321,-4272.807,-4281.228,-4274.1304,-4281.4834,-4276.2065,-4258.503,-4266.9487,-4258.6064,-4253.8027,-4235.626,-4229.3535,-4218.686,-4204.392,-4180.0425,-4150.055,-4131.5073,-4107.5874,-4074.1562,-4045.8296,-4019.9092,-3996.2063,-3974.1887,-3951.7378,-3921.7537,-3890.677};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_49()
		{
			double[] value = {-3829.3345,-3656.6995,-3255.758,-2704.5298,-1975.091,-877.5492,1.514191,414.37067,688.8779,976.7076,1198.6072,1344.3059,1435.886,1826.8794,2391.1958,3427.931,4813.1978,5256.636,4447.0156,3542.2773,2931.9248,2286.9097,1368.2878,533.2625,-57.766167,-394.1274,-631.1865,-826.9524,-987.77313,-1134.9688,-1277.3971,-1385.7795,-1476.981,-1580.8761,-1701.7947,-1836.9501,-1942.5013,-2037.9081,-2121.9114,-2232.3826,-2352.7039,-2426.5947,-2503.4534,-2636.0042,-2681.0586,-2802.6118,-2929.1912,-2994.13,-3023.725,-3070.1409,-3117.8618,-3209.352,-3160.6821,-3203.253,-3240.629,-3250.3186,-3273.1826,-3292.4263,-3250.7917,-3294.4534,-3451.3645,-3476.3003,-3439.4968,-3441.52,-3456.2717,-3522.9233,-3547.9683,-3669.7673,-3686.9177,-3707.1582,-3713.9111,-3726.2764,-3711.1816,-3727.257,-3755.7227,-3769.8735,-3788.4329,-3858.3667,-3887.5396,-3894.8445,-3938.5093,-3985.9197,-4013.4258,-4030.2998,-4025.1738,-4078.6604,-4104.1206,-4140.1763,-4182.5522,-4238.2715,-4282.1606,-4303.3345,-4322.088,-4296.9307,-4318.0835,-4361.088,-4371.1978,-4382.335,-4372.7095,-4353.5767};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_50()
		{
			double[] value = {-4361.637,-4362.5493,-4374.2837,-4300.647,-4311.074,-4330.495,-4330.9023,-4333.507,-4382.8525,-4297.714,-4311.0205,-4315.021,-4292.5083,-4277.409,-4252.6187,-4235.038,-4208.186,-4170.318,-4128.5107,-4098.0435,-4063.1252,-4028.568,-4023.6594,-4009.9092,-3975.8027,-3930.5518,-3917.3274,-3885.8784,-3810.4653,-3713.812,-3533.858,-3009.672,-2260.217,-1423.237,-312.26785,167.36455,477.83838,853.2379,1050.4669,1149.8632,1440.7235,1714.7124,2121.5283,2604.5571,3151.7021,3322.0479,3076.6147,2760.9841,2328.8176,1862.552,1048.7913,144.56755,-423.04272,-615.63745,-795.51013,-983.5899,-1137.1917,-1227.8649,-1315.5062,-1436.628,-1528.5427,-1616.4132,-1750.6869,-1817.1885,-1797.7073,-2057.4214,-2208.2678,-2337.4058,-2476.3408,-2501.91,-2584.7815,-2639.9185,-2689.658,-2821.8552,-2912.5308,-3045.3965,-3094.2014,-3113.0776,-3154.858,-3241.1787,-3260.2793,-3257.2327,-3246.6648,-3258.7717,-3302.722,-3317.9487,-3367.6873,-3402.1045,-3458.8953,-3489.9492,-3476.2666,-3538.0132,-3519.0205,-3576.8914,-3619.9983,-3677.6086,-3718.4114,-3715.6963,-3712.7668,-3745.7666};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_51()
		{
			double[] value = {-3773.5454,-3774.723,-3831.2715,-3840.0771,-3871.3914,-3915.4185,-3981.5515,-3978.0356,-3990.815,-4038.0813,-4079.7314,-4079.875,-4096.8936,-4125.446,-4169.974,-4215.985,-4260.858,-4327.906,-4350.1606,-4370.298,-4372.546,-4395.1494,-4411.786,-4423.001,-4422.787,-4439.918,-4437.2065,-4407.13,-4406.0547,-4420.502,-4419.024,-4393.905,-4364.606,-4368.286,-4378.1245,-4390.241,-4388.703,-4384.52,-4368.4106,-4349.2266,-4318.0347,-4295.0015,-4264.205,-4232.7686,-4193.24,-4160.584,-4138.2686,-4131.3174,-4106.4478,-4070.697,-4046.2737,-4016.0542,-3979.144,-3953.7966,-3933.2737,-3897.6375,-3855.7092,-3806.2188,-3733.0696,-3473.4634,-2848.675,-1744.9233,-911.0794,-525.41046,13.642169,529.30945,640.0958,711.04266,1115.5203,1440.8542,1760.5851,2079.8252,2362.2285,2448.5881,2333.895,2055.459,1783.1008,1301.9111,527.59436,-254.77887,-754.39813,-849.56177,-988.57336,-1141.85,-1231.4199,-1348.7904,-1386.4954,-1450.8486,-1568.9592,-1686.6202,-1820.8702,-1768.1486,-2327.9187,-2290.9814,-2265.8982,-2468.2026,-2568.664,-2581.6694,-2664.1106,-2734.706};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_52()
		{
			double[] value = {-2771.498,-2889.9019,-2968.7498,-3107.759,-3177.8665,-3205.46,-3219.3474,-3328.215,-3323.33,-3295.9512,-3273.637,-3313.9414,-3356.0034,-3360.4473,-3427.8777,-3434.6206,-3483.015,-3489.2188,-3530.9324,-3588.417,-3543.8247,-3600.7578,-3668.8037,-3712.8237,-3729.9407,-3778.4514,-3787.9102,-3825.2183,-3838.8342,-3844.8677,-3865.7969,-3885.1262,-3948.2515,-3972.5566,-4040.59,-4080.9211,-4080.1,-4155.408,-4190.045,-4176.129,-4180.8613,-4241.2783,-4287.917,-4327.34,-4363.6914,-4387.749,-4417.786,-4433.9067,-4431.9966,-4461.3975,-4497.549,-4487.8877,-4480.6074,-4496.951,-4489.286,-4450.0938,-4440.572,-4448.216,-4455.292,-4465.218,-4416.1196,-4397.261,-4413.9556,-4432.78,-4432.506,-4417.9883,-4373.236,-4352.045,-4329.084,-4297.5166,-4260.7227,-4230.315,-4201.515,-4176.7974,-4152.6523,-4141.0444,-4124.602,-4093.1726,-4058.1765,-4020.1978,-3998.94,-3964.8723,-3939.7224,-3924.837,-3940.667,-3888.8838,-3813.3806,-3614.6,-2920.173,-2206.3296,-1743.171,-1058.762,-403.717,60.41599,343.5631,569.77155,815.6823,1119.1252,1404.8068,1657.8091};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_53()
		{
			double[] value = {1766.2786,1826.7529,1695.7183,1456.2299,1204.2427,655.8874,-31.631443,-566.8848,-965.29895,-1082.8473,-1132.8564,-1265.953,-1331.9445,-1390.9062,-1458.5182,-1526.7284,-1622.4062,-1726.7344,-1820.208,-1822.2821,-2698.456,-2439.3843,-2287.8748,-2503.146,-2609.6536,-2651.0977,-2731.0186,-2861.5767,-2907.9468,-2963.016,-3034.932,-3192.165,-3223.7515,-3237.8235,-3267.6326,-3374.688,-3357.6548,-3357.4292,-3382.3838,-3395.586,-3438.491,-3417.2563,-3467.643,-3479.9875,-3536.8296,-3525.4954,-3572.5437,-3650.5774,-3595.1814,-3695.4136,-3733.8855,-3737.5483,-3761.5303,-3772.755,-3824.179,-3854.3298,-3866.7324,-3903.3955,-3936.201,-3995.2346,-4018.5466,-4039.351,-4119.1445,-4182.476,-4167.3193,-4231.838,-4212.642,-4238.001,-4314.082,-4329.441,-4366.865,-4380.005,-4427.7573,-4441.941,-4471.6196,-4497.495,-4501.224,-4534.4316,-4575.632,-4555.7163,-4538.6904,-4556.459,-4535.526,-4478.5786,-4486.0674,-4510.4907,-4530.4478,-4524.9004,-4506.653,-4472.352,-4440.7305,-4483.171,-4456.9175,-4423.123,-4412.124,-4385.566,-4355.777,-4333.27,-4305.238,-4275.697};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_54()
		{
			double[] value = {-4236.8,-4179.031,-4169.3105,-4137.2515,-4144.19,-4144.86,-4105.273,-4044.583,-4044.8943,-3994.9658,-3962.8618,-3963.711,-3941.7969,-3893.0989,-3784.737,-3567.984,-3129.3125,-2474.23,-1778.3102,-1141.6847,-808.73553,-356.82648,-94.84048,213.53435,514.8422,779.649,1008.1538,1060.4757,1202.9801,1179.5632,1043.6193,905.1108,524.49567,-12.403014,-494.78894,-855.4303,-1160.2903,-1277.8004,-1303.1371,-1370.3342,-1434.6433,-1483.241,-1523.2072,-1627.9658,-1692.0908,-1754.3011,-1862.2013,-1863.93,-1922.8622,-2140.544,-2362.339,-2472.4126,-2633.022,-2700.9912,-2820.9285,-2953.853,-3043.8818,-3084.277,-3138.971,-3270.8347,-3301.0425,-3315.2107,-3368.727,-3442.843,-3403.9895,-3446.1633,-3483.3608,-3437.8438,-3464.1213,-3500.1313,-3551.8044,-3580.7317,-3627.2249,-3623.201,-3633.1365,-3697.9968,-3645.0742,-3697.1282,-3742.8098,-3767.7927,-3790.27,-3807.507,-3861.843,-3901.1118,-3921.0195,-3963.0415,-4011.6753,-4074.71,-4128.5586,-4135.8647,-4182.206,-4213.9077,-4213.7246,-4271.01,-4316.157,-4345.366,-4361.792,-4415.0005,-4439.6914,-4444.274};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_55()
		{
			double[] value = {-4460.929,-4476.329,-4519.2886,-4547.098,-4565.7295,-4598.0615,-4610.579,-4601.4727,-4592.3325,-4620.0425,-4591.847,-4527.029,-4535.119,-4573.3975,-4587.084,-4586.035,-4572.9546,-4538.3516,-4444.121,-4460.093,-4459.4263,-4439.916,-4421.924,-4408.7476,-4385.9976,-4354.573,-4331.9736,-4303.704,-4264.0957,-4214.7046,-4197.118,-4203.0933,-4220.2163,-4199.18,-4170.083,-4092.3728,-4092.54,-4069.182,-4041.046,-4015.0405,-3963.6924,-3881.6033,-3770.772,-3642.9954,-3369.4966,-2821.623,-2214.337,-1720.5859,-1314.3119,-851.1645,-467.25415,-228.67119,5.72283,178.96754,390.7739,534.6995,520.2339,453.29364,347.08127,39.05387,-410.45544,-802.96466,-1046.3943,-1229.0571,-1368.7119,-1423.3353,-1422.8473,-1440.8129,-1503.4302,-1535.8265,-1588.1534,-1665.4337,-1763.9343,-1813.9167,-1886.0565,-1879.3931,-1943.9209,-2284.6355,-2412.9238,-2477.667,-2629.0952,-2841.522,-2908.7651,-3033.4556,-3152.193,-3176.2842,-3234.6628,-3340.129,-3380.8906,-3421.705,-3432.044,-3490.9634,-3428.0247,-3514.9792,-3460.8005,-3474.0432,-3506.289,-3527.461,-3619.6055,-3643.2747};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_56()
		{
			double[] value = {-3668.8945,-3680.7712,-3672.188,-3715.6624,-3661.3362,-3667.4026,-3728.2395,-3769.7075,-3818.3198,-3817.8167,-3883.6602,-3953.3218,-4000.4946,-4041.8706,-4097.523,-4120.679,-4190.017,-4213.186,-4264.5645,-4280.406,-4302.724,-4341.623,-4382.599,-4379.6606,-4394.2793,-4446.7627,-4476.192,-4460.01,-4513.995,-4544.067,-4547.875,-4589.159,-4617.371,-4645.626,-4639.6304,-4635.336,-4662.7524,-4669.721,-4635.2188,-4594.3687,-4574.0444,-4605.606,-4610.037,-4606.6475,-4601.391,-4578.194,-4487.673,-4477.943,-4472.6904,-4452.4385,-4426.383,-4401.917,-4395.481,-4383.4907,-4345.166,-4307.3037,-4282.157,-4250.3545,-4239.676,-4260.296,-4258.121,-4235.1763,-4189.4497,-4145.6836,-4131.521,-4094.4448,-4065.222,-4037.3242,-3996.1877,-3930.1704,-3854.5144,-3777.9788,-3646.0461,-3328.249,-2734.0098,-2166.554,-1745.5908,-1336.8691,-990.65607,-791.62396,-600.04285,-508.28076,-340.3264,-233.01108,-237.77034,-318.26944,-452.75055,-828.96277,-1261.406,-1398.3185,-1365.3059,-1438.6418,-1503.3467,-1569.89,-1627.4348,-1591.16,-1600.8169,-1637.3777,-1681.9326,-1718.4929};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_57()
		{
			double[] value = {-1819.391,-1887.5374,-1937.1263,-1928.2946,-1876.2871,-2145.157,-2396.8826,-2614.1829,-3168.8042,-3026.778,-3063.6404,-3133.787,-3235.767,-3170.1199,-3153.9019,-3433.4424,-3466.5127,-3502.2368,-3486.9739,-3448.6982,-3378.0623,-3614.61,-3564.023,-3478.3716,-3606.4211,-3567.1943,-3666.6023,-3702.5637,-3698.4233,-3761.9565,-3751.7078,-3789.4758,-3717.585,-3730.2422,-3755.408,-3815.23,-3847.2085,-3868.0173,-3920.7434,-3974.9956,-4050.615,-4113.685,-4152.709,-4207.4756,-4253.998,-4272.7207,-4311.408,-4334.7656,-4347.844,-4386.52,-4436.863,-4456.8574,-4485.677,-4494.049,-4502.9785,-4536.9414,-4568.464,-4623.6787,-4641.009,-4646.3037,-4650.096,-4697.2153,-4713.3066,-4696.2217,-4704.3325,-4696.455,-4687.8994,-4675.8813,-4631.716,-4619.892,-4627.1875,-4620.7646,-4607.1055,-4584.947,-4502.4023,-4483.869,-4462.8257,-4457.167,-4427.732,-4421.1143,-4437.613,-4404.94,-4345.0903,-4324.0474,-4295.5527,-4278.009,-4290.5527,-4289.6655,-4272.732,-4219.2856,-4202.1094,-4230.951,-4163.8687,-4133.329,-4124.004,-4094.7427,-4057.6748,-3992.3606,-3880.6343,-3844.404};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_58()
		{
			double[] value = {-3846.4197,-3753.8933,-3204.4033,-2707.0876,-2345.372,-1891.0178,-1633.0975,-1491.5394,-1537.284,-1173.673,-1088.1874,-1015.7739,-941.4046,-1074.1791,-1161.3319,-1387.437,-833.35254,602.6707,604.7774,-780.6906,-1603.9674,-1726.4081,-1756.413,-1751.0143,-1744.9272,-1761.2528,-1804.5746,-1837.8373,-1937.8413,-1996.31,-2054.2778,-2029.7572,-1813.5614,-1552.9807,-1962.3157,-3172.6248,-3763.5747,-3362.6414,-3201.652,-3262.4607,-3332.4783,-2890.1863,-2424.2842,-3451.0186,-3546.1763,-3544.5757,-3534.2761,-3237.9282,-3444.632,-3666.1526,-3643.0522,-3603.482,-3663.0342,-3662.3748,-3724.951,-3762.659,-3781.7078,-3779.139,-3819.1135,-3827.191,-3730.6624,-3772.0073,-3821.9363,-3863.462,-3895.0676,-3943.0059,-4017.372,-4060.2703,-4097.8325,-4163.95,-4211.289,-4239.188,-4264.7725,-4324.898,-4339.524,-4358.904,-4421.102,-4447.3975,-4457.634,-4509.943,-4542.8003,-4576.486,-4575.092,-4589.053,-4592.7183,-4637.1577,-4715.532,-4720.062,-4698.8413,-4732.234,-4730.244,-4710.114,-4707.9443,-4700.608,-4683.5244,-4687.676,-4671.9146,-4653.856,-4639.8438,-4615.636};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_59()
		{
			double[] value = {-4599.431,-4557.921,-4474.7188,-4478.973,-4479.7637,-4477.626,-4456.7725,-4474.1035,-4480.4023,-4439.3745,-4397.891,-4356.6406,-4334.48,-4318.8237,-4294.0806,-4261.834,-4223.602,-4235.721,-4276.597,-4259.6006,-4226.778,-4203.173,-4175.697,-4152.8706,-4106.6094,-4053.7925,-3973.9216,-3963.0657,-4006.2058,-3930.6108,-3660.5635,-3326.5505,-3014.7559,-2599.856,-2415.4421,-2279.3696,-2075.957,-1945.4391,-1839.9543,-1851.5577,-1727.331,-1639.3992,-1659.6145,-1574.4324,879.95734,3411.6934,3325.753,721.23645,-1485.9178,-1955.3019,-1955.7086,-1895.6349,-1900.3401,-1889.5394,-1977.6427,-2050.2856,-2053.0344,-2094.3186,-2159.4617,-2161.8586,-2118.608,-1704.5472,-1711.9497,-2710.1301,-3330.708,-3295.8281,-3308.9946,-3372.3496,-3458.87,-3233.9316,-2533.61,-3370.7122,-3551.6533,-3576.9783,-3594.784,-3324.696,-3283.4849,-3504.4763,-3483.8743,-3687.7732,-3721.3413,-3753.2974,-3801.9194,-3817.4995,-3806.2246,-3824.418,-3855.4229,-3869.9395,-3739.0222,-3780.6602,-3834.8906,-3861.4673,-3906.3945,-3993.348,-4043.3179,-4113.909,-4162.2827,-4211.9917,-4260.759,-4280.347};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_60()
		{
			double[] value = {-4296.5405,-4333.6104,-4391.421,-4447.096,-4493.196,-4513.5405,-4540.034,-4561.174,-4579.1504,-4613.021,-4621.4277,-4653.669,-4670.765,-4662.5767,-4754.4995,-4779.504,-4773.713,-4743.447,-4722.0464,-4708.484,-4708.487,-4704.3184,-4694.398,-4688.795,-4672.872,-4664.7217,-4644.418,-4617.9595,-4581.7256,-4525.2866,-4485.5786,-4508.1753,-4517.691,-4521.374,-4511.4487,-4500.526,-4493.9683,-4464.1978,-4432.029,-4411.248,-4368.999,-4329.547,-4313.2607,-4284.963,-4233.0337,-4289.5205,-4323.9653,-4306.5996,-4304.492,-4260.947,-4234.0073,-4195.291,-4170.6177,-4134.4463,-4087.0496,-4090.326,-4028.2576,-3938.151,-3903.6997,-3780.1157,-3536.9448,-3314.4636,-3169.0903,-3023.713,-2896.899,-2746.5393,-2688.8147,-2681.9055,-2479.1223,-2289.284,-2237.83,-2182.4617,-221.21379,2641.025,2588.5007,290.76956,-1888.7118,-2394.4966,-2259.3977,-2123.9905,-2074.0415,-2048.7705,-2101.884,-2148.1702,-2181.0288,-2196.581,-2244.2104,-2297.6252,-2291.065,-2213.4253,-1710.4434,-2441.1863,-3198.9502,-3301.9238,-3395.4368,-3447.9785,-3527.4482,-3525.9148,-3478.1472,-3571.4077};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_61()
		{
			double[] value = {-3630.3489,-3664.651,-3650.952,-3650.2139,-3383.0403,-3116.2153,-3419.388,-3700.6064,-3778.9048,-3804.9968,-3823.0916,-3858.63,-3864.9146,-3861.2505,-3898.4329,-3893.7356,-3778.0242,-3830.8726,-3877.4287,-3927.4902,-3986.4114,-4018.9934,-4097.531,-4176.4077,-4225.7744,-4275.3516,-4308.122,-4336.6567,-4377.7485,-4388.5806,-4443.163,-4492.0327,-4513.877,-4543.3228,-4534.244,-4583.1143,-4613.414,-4636.776,-4659.8457,-4697.3354,-4725.988,-4734.7295,-4786.2075,-4845.845,-4812.185,-4769.338,-4728.602,-4714.154,-4703.0254,-4703.0767,-4700.7324,-4691.9536,-4685.1724,-4677.379,-4663.2075,-4644.145,-4614.3486,-4544.59,-4514.3696,-4537.8164,-4559.335,-4553.6514,-4528.2427,-4509.8325,-4495.182,-4461.9995,-4447.2354,-4420.2817,-4381.1445,-4356.1934,-4335.363,-4270.937,-4271.1216,-4355.689,-4346.3965,-4364.695,-4359.8105,-4313.772,-4279.638,-4247.6133,-4215.369,-4163.18,-4147.4966,-4126.2373,-4111.4897,-4058.8696,-3989.979,-3921.0164,-3854.5652,-3742.0645,-3620.5063,-3588.0623,-3546.064,-3479.1477,-3424.616,-3318.8547,-3165.4448,-3057.8271,-3044.369,-3163.443};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_62()
		{
			double[] value = {-2569.806,-979.13806,-786.0223,-1940.7284,-2836.7397,-2718.4697,-2562.396,-2397.4402,-2291.03,-2241.7434,-2264.7673,-2270.7256,-2372.2263,-2333.1143,-2361.8425,-2461.696,-2489.1687,-2425.8125,-2020.0746,-2159.9895,-3161.5073,-3253.093,-3443.085,-3484.7847,-3556.0518,-3561.1873,-3603.7236,-3651.9697,-3664.6497,-3681.0505,-3693.8079,-3738.7559,-3650.0608,-3563.1492,-3738.6865,-3764.1377,-3804.9817,-3837.3594,-3866.0618,-3880.1255,-3916.3618,-3954.6892,-3935.1343,-3923.4392,-3842.4607,-3895.0684,-3945.6472,-3999.843,-4047.9736,-4088.9731,-4124.5527,-4177.82,-4225.845,-4266.3076,-4317.464,-4387.826,-4437.0015,-4452.778,-4484.041,-4519.222,-4570.9375,-4571.535,-4569.2466,-4617.824,-4648.1924,-4678.587,-4698.867,-4732.8564,-4794.2676,-4786.1455,-4799.3193,-4866.2285,-4845.4253,-4807.2886,-4757.3643,-4731.816,-4721.246,-4699.93,-4706.8237,-4704.728,-4697.9985,-4688.4077,-4683.2246,-4671.564,-4649.253,-4616.357,-4529.1597,-4552.2705,-4595.6143,-4554.095,-4525.427,-4489.1714,-4487.316,-4487.6772,-4469.338,-4437.57,-4415.846,-4391.0547,-4329.7173,-4291.601};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_63()
		{
			double[] value = {-4331.3286,-4375.669,-4378.945,-4366.8267,-4357.7793,-4321.673,-4287.2183,-4263.9033,-4248.6963,-4189.806,-4171.251,-4196.681,-4180.051,-4125.369,-4113.019,-4088.474,-4004.9316,-3811.565,-3844.3464,-3786.2844,-3775.1516,-3829.1365,-3712.5322,-3727.6343,-3743.3008,-3702.65,-3686.2659,-3764.0881,-3736.4297,-3559.341,-3421.4727,-3399.5173,-3268.993,-3011.9263,-2837.2979,-2696.5154,-2502.3267,-2456.8845,-2499.5603,-2422.8472,-2394.1604,-2453.3064,-2494.0657,-2561.464,-2565.7961,-2583.4595,-2242.4912,-2268.9282,-3250.9785,-3097.425,-3299.5242,-3512.6433,-3596.1978,-3593.22,-3655.4517,-3672.2603,-3682.795,-3727.5564,-3725.8965,-3772.3853,-3730.5898,-3728.8508,-3796.871,-3805.6545,-3825.9324,-3892.1277,-3936.8896,-3937.4404,-3936.1216,-3990.697,-4004.4028,-3954.1333,-3832.7183,-3892.8828,-3960.1135,-4016.1135,-4089.3481,-4135.793,-4208.417,-4252.107,-4304.34,-4341.1113,-4369.1587,-4410.9844,-4440.051,-4505.7725,-4535.773,-4539.6978,-4561.4507,-4598.465,-4590.269,-4641.725,-4708.4062,-4730.9546,-4754.3755,-4755.464,-4803.484,-4848.841,-4842.5815,-4863.9556};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_64()
		{
			double[] value = {-4877.2373,-4875.792,-4828.9243,-4770.064,-4775.9194,-4753.85,-4741.0137,-4743.7007,-4734.1333,-4717.019,-4689.208,-4647.4893,-4659.0723,-4646.564,-4560.558,-4574.9424,-4592.0264,-4584.3223,-4544.334,-4635.635,-4459.337,-4513.5425,-4489.6323,-4436.1445,-4430.836,-4389.5312,-4338.6816,-4307.403,-4377.0454,-4402.853,-4381.9126,-4368.0166,-4370.589,-4290.281,-4270.432,-4271.977,-4250.1226,-4215.613,-4218.705,-4242.583,-4217.7026,-4177.1694,-4155.281,-4130.0693,-4010.4438,-3991.638,-3913.5374,-3935.407,-3912.6162,-3880.6963,-3817.1802,-3819.1558,-3869.405,-3908.6677,-3837.9978,-3811.8298,-3751.3206,-3712.8638,-3659.6406,-3576.161,-3417.3328,-3270.9495,-3078.8708,-2944.7432,-2778.8752,-2702.0671,-2648.519,-2573.9272,-2518.0842,-2598.91,-2566.0012,-2660.792,-2679.8723,-2511.9707,-2449.3086,-2706.4636,-3169.861,-3220.4163,-2551.0547,-3455.5002,-3640.6882,-3628.8179,-3691.7258,-3683.8828,-3694.3574,-3705.1355,-3752.451,-3768.5203,-3743.7495,-3734.6611,-3815.171,-3846.8357,-3879.0176,-3932.8918,-3955.631,-3985.9187,-3981.3762,-3999.3474,-4054.9758,-4023.9368};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_65()
		{
			double[] value = {-3896.832,-3959.72,-4010.4326,-4061.4104,-4108.882,-4184.037,-4254.3564,-4309.2617,-4357.723,-4395.259,-4451.028,-4478.51,-4519.075,-4547.2065,-4555.585,-4546.08,-4583.3525,-4633.448,-4644.664,-4690.0347,-4740.1436,-4752.149,-4783.659,-4803.3926,-4834.7617,-4880.5107,-4892.9536,-4893.473,-4909.15,-4920.072,-4884.7314,-4812.844,-4819.442,-4803.5864,-4790.5596,-4803.9644,-4807.86,-4799.7827,-4759.229,-4680.818,-4709.072,-4705.666,-4646.684,-4632.309,-4622.2964,-4623.903,-4578.324,-4594.6934,-4536.039,-4537.527,-4506.475,-4462.553,-4444.8506,-4411.134,-4369.2686,-4371.2866,-4486.6113,-4480.0605,-4431.8545,-4380.6924,-4404.171,-4352.882,-4300.5117,-4274.5073,-4253.1094,-4240.434,-4262.691,-4265.3193,-4232.6504,-4203.7393,-4169.413,-4107.927,-4059.3237,-4051.1497,-4009.451,-3987.7808,-3946.6738,-3939.1992,-3959.6787,-3921.7275,-3897.4043,-3904.7039,-3820.6292,-3785.4888,-3734.004,-3693.4338,-3667.2205,-3624.467,-3482.851,-3392.5337,-3269.469,-3099.2764,-2948.716,-2838.9265,-2774.461,-2675.8486,-2645.746,-2746.3486,-2663.82,-2723.2607};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_66()
		{
			double[] value = {-2763.421,-2720.7932,-2714.423,-2974.3425,-3103.7366,-3105.3542,-2040.518,-3449.2725,-3670.3647,-3671.9126,-3674.7046,-3691.7598,-3704.5942,-3721.7268,-3728.2153,-3766.073,-3794.0225,-3808.0808,-3862.938,-3910.5173,-3947.3948,-3963.3052,-3960.1516,-3990.7712,-4038.985,-4022.96,-4061.4336,-4036.0938,-3947.0,-4006.7866,-4029.0925,-4074.9055,-4156.8237,-4223.647,-4280.5586,-4334.1455,-4369.196,-4404.0967,-4478.56,-4530.234,-4556.561,-4588.678,-4599.6943,-4570.575,-4650.8906,-4690.151,-4732.5825,-4738.46,-4775.5806,-4806.7603,-4851.254,-4858.021,-4872.433,-4901.8735,-4916.079,-4920.0576,-4922.9595,-4939.2153,-4928.686,-4869.982,-4853.975,-4860.732,-4851.956,-4873.6294,-4879.5205,-4875.267,-4821.744,-4811.4873,-4793.5635,-4747.6265,-4715.983,-4712.443,-4707.7896,-4659.75,-4627.605,-4590.088,-4609.209,-4562.1694,-4526.8228,-4497.7295,-4492.098,-4464.7466,-4448.1665,-4494.4854,-4561.5317,-4530.487,-4510.54,-4458.2646,-4438.505,-4414.2007,-4342.669,-4278.601,-4265.8433,-4292.9194,-4319.1035,-4305.0728,-4267.687,-4214.3154,-4159.002,-4099.556};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_67()
		{
			double[] value = {-4114.484,-4073.8953,-4051.607,-3989.5503,-3990.2112,-3968.9363,-3983.8176,-3931.7883,-3867.1543,-3847.586,-3790.2612,-3759.1973,-3709.742,-3663.0808,-3651.5903,-3606.8474,-3508.179,-3377.0415,-3310.434,-3167.3794,-3023.5735,-2948.9749,-2892.663,-2775.4983,-2773.116,-2802.8313,-2790.6035,-2846.8872,-2887.9639,-2878.8774,-2602.459,-2901.4365,-3132.8516,-2724.125,-2059.885,-3538.3774,-3645.417,-3705.3118,-3667.8694,-3709.594,-3711.1584,-3751.3005,-3767.4956,-3823.9336,-3838.2573,-3886.3682,-3948.0767,-3952.5657,-3960.1587,-3954.6394,-3958.4526,-4007.1074,-4051.2842,-4061.7776,-4060.9414,-4035.1226,-3980.1511,-4047.583,-4124.8896,-4169.2505,-4181.49,-4231.771,-4301.158,-4342.406,-4373.5356,-4408.904,-4463.21,-4535.563,-4590.6123,-4606.6187,-4633.3906,-4665.7007,-4676.7993,-4736.949,-4762.4185,-4781.751,-4795.4263,-4843.998,-4884.029,-4901.229,-4896.1587,-4905.9526,-4934.9146,-4934.5156,-4939.438,-4958.146,-4957.5767,-4917.5073,-4903.879,-4917.2344,-4889.8687,-4858.9683,-4856.8315,-4849.0845,-4847.8193,-4839.2085,-4817.1323,-4797.649,-4729.2837,-4716.12};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_68()
		{
			double[] value = {-4690.9585,-4673.6475,-4673.869,-4642.5254,-4624.905,-4584.961,-4657.765,-4564.373,-4534.9683,-4505.069,-4489.0854,-4596.7007,-4589.953,-4575.2207,-4574.4194,-4514.151,-4524.7524,-4440.694,-4366.205,-4326.2163,-4319.1997,-4320.5083,-4332.652,-4341.991,-4287.855,-4213.9766,-4174.973,-4168.5483,-4121.858,-4066.213,-4041.3186,-4009.259,-4017.532,-3990.397,-3940.6138,-3903.3452,-3875.8113,-3842.3496,-3799.7764,-3755.1875,-3680.8918,-3653.6655,-3632.7158,-3592.4224,-3524.0894,-3403.7708,-3375.011,-3277.8901,-3141.3425,-3031.9058,-2998.7764,-2919.1428,-2913.1643,-2906.3262,-2895.6914,-2940.6172,-3008.759,-2853.338,-2608.4553,-2706.9746,-3015.6304,-2152.6707,-2207.892,-3421.1023,-3661.4314,-3722.5642,-3748.685,-3744.8699,-3744.6865,-3771.7163,-3785.7544,-3847.8965,-3853.678,-3934.711,-3975.017,-3958.651,-3985.0867,-3981.8838,-3954.2205,-4041.0608,-4063.1597,-4066.9346,-4059.8154,-4036.6443,-4055.593,-4088.0447,-4139.21,-4183.579,-4198.5527,-4200.141,-4334.832,-4394.128,-4424.4253,-4452.303,-4480.0117,-4549.279,-4618.1597,-4625.6626,-4677.012,-4710.2993};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_69()
		{
			double[] value = {-4706.45,-4745.1504,-4791.4277,-4839.2373,-4815.361,-4878.112,-4918.164,-4926.3975,-4928.846,-4932.38,-4952.017,-4953.41,-4947.352,-4954.9077,-4976.2666,-4961.812,-4939.397,-4916.416,-4906.08,-4890.822,-4875.6025,-4867.3193,-4857.674,-4849.985,-4836.631,-4789.287,-4762.4463,-4758.528,-4728.387,-4698.0933,-4695.973,-4666.6084,-4653.2563,-4611.9883,-4626.7124,-4614.0117,-4573.8643,-4508.3633,-4516.655,-4633.4736,-4608.033,-4628.422,-4616.814,-4584.878,-4554.834,-4498.9033,-4458.5625,-4406.015,-4352.828,-4334.164,-4347.768,-4323.998,-4270.0283,-4244.809,-4222.442,-4178.383,-4157.249,-4121.558,-4100.465,-4103.4897,-4034.992,-3975.2915,-3917.1326,-3866.7505,-3852.848,-3831.7876,-3804.1191,-3759.4414,-3652.2927,-3633.17,-3604.8984,-3592.56,-3558.998,-3439.0454,-3385.5908,-3370.3713,-3259.7231,-3149.472,-3115.6848,-3027.7266,-3062.8591,-3017.3118,-3028.2986,-3022.163,-3090.812,-3047.38,-3035.6946,-3116.5964,-3093.27,-1688.2948,-2412.243,-3427.5293,-3708.3267,-3734.4873,-3757.0056,-3762.6775,-3780.9675,-3795.5312,-3800.915,-3820.5686};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_70()
		{
			double[] value = {-3882.7505,-3949.2822,-3980.8506,-3957.7092,-4001.2043,-3990.3035,-3978.9924,-4055.8782,-4073.502,-4067.711,-4065.1287,-4059.5674,-4078.0647,-4113.3853,-4147.613,-4193.6094,-4229.0625,-4239.9536,-4269.1724,-4391.763,-4452.832,-4486.973,-4549.8857,-4565.057,-4627.1553,-4650.4194,-4700.5684,-4742.8657,-4769.564,-4812.4077,-4841.6104,-4870.1313,-4909.4487,-4925.672,-4941.8613,-4948.9834,-4955.36,-4968.642,-4985.5415,-4984.319,-4981.476,-4981.295,-4997.12,-4999.2188,-4962.595,-4915.0625,-4922.682,-4937.32,-4937.9487,-4923.065,-4927.303,-4911.4824,-4866.9863,-4884.1377,-4895.8594,-4829.085,-4779.052,-4735.7324,-4745.613,-4714.354,-4676.2295,-4650.8413,-4645.997,-4631.422,-4594.162,-4565.2964,-4598.2793,-4634.891,-4638.814,-4635.1787,-4599.3145,-4570.885,-4527.869,-4486.7593,-4443.7534,-4408.653,-4376.7793,-4348.206,-4325.026,-4274.0425,-4253.1846,-4249.382,-4211.0713,-4153.451,-4138.751,-4115.314,-4089.5713,-4057.3994,-4038.2937,-3977.4922,-3931.7966,-3878.861,-3837.3167,-3815.8062,-3783.8547,-3744.461,-3682.4856,-3670.6335,-3598.4478,-3593.195};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_71()
		{
			double[] value = {-3577.8972,-3494.3718,-3398.1848,-3390.933,-3348.3503,-3240.9077,-3216.7788,-3145.6975,-3171.668,-3134.792,-3088.4978,-3145.2366,-3183.114,-3142.4783,-3148.0715,-3178.6924,-3098.4177,-1779.653,-1734.4116,-3132.7844,-3729.298,-3754.6611,-3767.902,-3776.449,-3810.4575,-3805.383,-3820.9287,-3797.621,-3888.309,-3933.9558,-3958.6277,-3952.8206,-3992.5151,-4012.8005,-4011.5642,-4057.0266,-4075.9673,-4060.809,-4062.9746,-4064.565,-4103.8555,-4151.3145,-4191.686,-4240.33,-4274.2534,-4287.325,-4306.1846,-4370.3794,-4455.155,-4497.2837,-4550.683,-4589.8,-4593.286,-4618.0347,-4697.3994,-4808.5986,-4845.6963,-4867.0483,-4889.8535,-4923.11,-4973.0024,-4984.6045,-4960.0166,-4974.731,-4973.764,-4986.4907,-4998.4033,-5003.932,-4995.8306,-4990.697,-4997.1797,-5015.805,-5007.257,-4936.484,-4923.1514,-4942.6675,-4954.427,-4943.6055,-4949.5464,-4943.4683,-4965.4883,-4970.893,-4932.1772,-4835.168,-4805.1553,-4780.178,-4751.649,-4765.2686,-4727.777,-4694.0137,-4682.5757,-4660.909,-4650.505,-4655.994,-4677.01,-4657.1943,-4652.2065,-4604.035,-4603.1816,-4593.1636};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_72()
		{
			double[] value = {-4551.662,-4531.6978,-4474.41,-4421.142,-4388.169,-4354.3677,-4270.436,-4270.2085,-4235.2876,-4289.109,-4220.6343,-4165.8955,-4144.6323,-4150.054,-4132.402,-4067.1687,-4033.5203,-3997.9695,-3960.6587,-3897.8892,-3851.651,-3831.841,-3782.9038,-3705.3965,-3656.684,-3647.359,-3645.6675,-3608.8552,-3584.0217,-3532.5364,-3434.7012,-3391.619,-3375.55,-3305.036,-3321.2458,-3267.4546,-3293.048,-3248.1055,-3173.9434,-3241.2373,-3187.191,-3083.4055,-3163.1084,-3066.3552,-2727.464,-2150.3262,-1258.5488,-1917.8871,-3589.1006,-3767.8428,-3780.6301,-3787.6204,-3818.764,-3788.4106,-3778.1978,-3820.617,-3917.2573,-3946.3394,-3960.2744,-3948.7485,-4002.2095,-4022.3372,-4027.5315,-4051.54,-4074.593,-4067.8535,-4075.0935,-4067.6343,-4138.896,-4182.689,-4215.1714,-4263.278,-4306.16,-4338.7827,-4343.9746,-4347.428,-4475.4146,-4537.6167,-4580.991,-4632.489,-4648.165,-4649.1406,-4752.2725,-4823.616,-4870.6636,-4887.465,-4901.44,-4955.347,-5045.3594,-5015.4844,-4996.198,-4970.249,-4986.7188,-4994.409,-4995.3584,-4982.4937,-5002.0283,-5029.5977,-5017.286,-4998.3477};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_73()
		{
			double[] value = {-5000.6123,-4966.4385,-4941.061,-4953.1636,-4969.659,-4966.3667,-4984.1562,-4955.599,-4965.021,-4914.563,-4865.117,-4822.2812,-4836.454,-4818.192,-4806.6133,-4789.981,-4737.9985,-4719.4473,-4698.075,-4678.517,-4696.0,-4715.6514,-4676.5747,-4676.972,-4650.8774,-4653.2207,-4649.383,-4634.324,-4614.972,-4576.2964,-4527.1387,-4500.497,-4434.8804,-4413.6035,-4368.6807,-4313.278,-4301.4575,-4279.8467,-4223.0186,-4183.873,-4179.031,-4149.515,-4127.202,-4071.6235,-4035.7175,-4012.4102,-3985.0063,-3898.4849,-3880.7688,-3805.4448,-3741.2212,-3703.547,-3678.2,-3705.2131,-3683.7158,-3615.763,-3602.4614,-3553.9524,-3509.9634,-3477.4844,-3435.0352,-3417.5537,-3386.3442,-3346.5051,-3385.5955,-3345.1516,-3290.317,-3272.2642,-3112.7048,-3048.3875,-3002.9548,-2954.592,-2829.6226,-2751.8186,-2406.2998,-1963.0841,-3110.8047,-3781.5125,-3795.3408,-3812.1514,-3808.9707,-3792.0864,-3884.1938,-3770.8938,-3917.1055,-3963.1829,-3948.9055,-3935.9695,-4007.0693,-4031.1475,-4019.684,-4039.062,-4066.121,-4076.3794,-4049.143,-3972.5916,-4177.396,-4212.1885,-4247.09,-4286.852};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_74()
		{
			double[] value = {-4335.2803,-4378.6616,-4387.935,-4398.571,-4471.7407,-4567.1055,-4607.0435,-4669.9165,-4675.3486,-4704.659,-4764.3022,-4827.7334,-4859.8,-4922.217,-4941.101,-4978.0723,-5025.0435,-5018.184,-5020.865,-4996.424,-4996.374,-4994.9106,-4999.766,-4985.941,-4995.5024,-5002.372,-4996.422,-4969.79,-4979.8647,-4976.449,-4965.5684,-4979.2783,-4997.4224,-4998.9663,-5003.301,-4986.6445,-4942.6943,-4939.7217,-4901.79,-5051.4365,-4738.797,-4814.165,-4801.631,-4786.332,-4777.02,-4798.9033,-4772.3887,-4750.956,-4753.814,-4739.1675,-4716.925,-4681.4795,-4676.626,-4658.009,-4675.5674,-4661.084,-4622.775,-4584.5093,-4548.736,-4528.4727,-4489.3335,-4447.1387,-4424.821,-4369.309,-4334.0957,-4297.03,-4223.745,-4173.81,-4179.7383,-4164.9775,-4130.0415,-4072.0493,-4016.9949,-3982.5847,-3959.1565,-3913.6265,-3890.0566,-3838.5647,-3685.267,-3667.0767,-3708.8528,-3728.5227,-3696.366,-3641.8,-3623.8484,-3594.805,-3570.53,-3496.0864,-3474.5684,-3474.7139,-3436.021,-3404.4116,-3434.0925,-3425.1313,-3399.0938,-3206.521,-2837.5396,-2657.8562,-2820.528,-2950.172};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_75()
		{
			double[] value = {-2886.0686,-2833.3328,-2617.9172,-2184.0022,-3020.18,-3672.7842,-3782.5417,-3808.126,-3770.1873,-3776.3484,-3848.6526,-3762.0706,-3913.0518,-3936.8452,-3927.931,-3955.4177,-4007.3015,-4027.8083,-4011.102,-4021.1113,-4024.5374,-4036.5044,-4062.273,-4055.053,-4209.149,-4235.472,-4288.123,-4316.28,-4368.3354,-4420.1035,-4408.51,-4436.2915,-4500.793,-4609.314,-4645.1865,-4704.055,-4736.162,-4754.099,-4795.6763,-4821.7437,-4874.861,-4925.038,-4960.9585,-4971.0127,-4978.528,-4995.186,-5011.54,-5000.844,-4992.886,-4994.251,-5000.152,-4992.0845,-4995.699,-4994.7354,-4971.9087,-4969.866,-4994.801,-5001.5884,-5005.994,-4989.1216,-5001.8223,-5011.2363,-5001.556,-4982.032,-4939.7397,-4908.5894,-4863.964,-4832.089,-4787.914,-4878.2886,-4804.784,-4842.76,-4856.9336,-4833.34,-4850.8735,-4853.6406,-4833.1,-4780.8413,-4744.775,-4710.6763,-4688.9043,-4653.27,-4650.3745,-4639.612,-4602.0845,-4565.5767,-4543.415,-4524.648,-4508.2593,-4480.1943,-4423.683,-4394.396,-4358.0103,-4330.998,-4265.7046,-4230.355,-4183.497,-4131.7285,-4109.0806,-4068.505};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_76()
		{
			double[] value = {-3975.5352,-3984.7961,-3949.0647,-3900.776,-3896.7595,-3847.234,-3735.9436,-3619.5762,-3698.1033,-3739.4512,-3707.799,-3666.329,-3660.3997,-3641.7683,-3609.452,-3578.141,-3529.734,-3526.5437,-3511.712,-3496.8955,-3507.328,-3456.7107,-3309.8892,-3203.2378,-2910.5037,-2491.6858,-2738.242,-2927.2412,-2851.5283,-2917.9407,-2804.9104,-2422.7488,-2738.2603,-3348.6309,-3751.3826,-3800.3386,-3765.9702,-3751.5352,-3730.4514,-3856.0781,-3915.1887,-3922.0435,-3902.546,-3970.3667,-4002.7822,-4019.9023,-4022.3928,-4019.726,-4017.6562,-3993.117,-4070.0156,-4053.5273,-4224.938,-4246.363,-4302.8403,-4328.98,-4365.328,-4423.895,-4448.787,-4492.6245,-4571.5454,-4648.634,-4686.1216,-4697.9985,-4726.5264,-4767.731,-4817.7017,-4817.03,-4834.206,-4896.712,-4951.529,-4967.3867,-4978.487,-4972.55,-4975.285,-4987.3115,-4992.379,-4990.6206,-4984.5835,-4990.292,-4990.385,-4975.6987,-4962.592,-4967.922,-4980.2686,-4981.533,-4986.109,-4980.0566,-4965.369,-4955.0137,-4960.5767,-4956.1523,-4930.4365,-4897.769,-4881.4834,-4861.8647,-4859.069,-4863.3228,-4865.475,-4873.057};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_77()
		{
			double[] value = {-5068.9033,-4967.0747,-4854.716,-4874.5874,-4826.534,-4737.411,-4737.861,-4730.304,-4690.4917,-4650.4844,-4641.5215,-4663.8276,-4624.122,-4565.057,-4544.5376,-4532.036,-4516.6763,-4469.0,-4430.523,-4387.3916,-4340.694,-4325.325,-4278.1943,-4228.595,-4181.023,-4135.7153,-4097.4497,-4064.0042,-4006.8418,-3962.1787,-3943.5117,-3912.173,-3850.1252,-3857.7783,-3779.1235,-3700.4365,-3691.9036,-3757.8496,-3736.181,-3700.6748,-3689.3052,-3671.6948,-3649.1602,-3632.464,-3586.6887,-3594.8599,-3557.6057,-3560.9834,-3561.2266,-3517.5754,-3417.9033,-3345.2285,-2962.0352,-2569.327,-2653.9343,-2851.2056,-2868.6912,-2924.0662,-2729.9023,-2563.762,-2715.665,-3289.3894,-3712.3542,-3802.48,-3782.6108,-3772.275,-3802.4,-3826.6577,-3880.2683,-3913.8872,-3948.1445,-3951.9263,-3998.6545,-4019.404,-4036.5352,-4007.4077,-4032.9812,-4011.7478,-4073.722,-4064.787,-4237.734,-4270.6147,-4317.765,-4357.4604,-4403.264,-4449.795,-4500.0107,-4573.5444,-4609.614,-4583.5103,-4619.2773,-4680.137,-4743.0503,-4799.2773,-4853.044,-4884.5894,-4878.1514,-4901.633,-4939.492,-4976.6084};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_78()
		{
			double[] value = {-4974.8037,-4965.59,-4887.176,-4850.123,-4892.2676,-4961.885,-4974.5283,-4982.197,-4979.539,-4964.6826,-4963.746,-4960.3965,-4946.691,-4944.9243,-4925.502,-4931.017,-4898.8384,-4893.0366,-4892.3506,-4880.349,-4857.138,-4840.454,-4852.4287,-4850.852,-4855.0127,-4850.2466,-4859.9927,-4851.8677,-4862.9736,-4828.885,-4836.0913,-4840.234,-4775.0547,-4727.6187,-4755.748,-4737.8936,-4699.8857,-4680.5737,-4665.633,-4634.753,-4620.2593,-4585.6655,-4567.3076,-4534.1885,-4525.226,-4494.909,-4434.746,-4364.2417,-4334.7993,-4318.1157,-4274.542,-4231.627,-4171.6587,-4134.8354,-4090.1672,-4050.9507,-4005.747,-3947.8035,-3894.9636,-3850.2896,-3842.656,-3820.6946,-3778.0015,-3748.5232,-3720.342,-3699.6375,-3714.266,-3746.0125,-3717.4834,-3640.9675,-3633.1738,-3646.8245,-3608.3367,-3637.057,-3622.2454,-3599.1455,-3581.328,-3550.2803,-3467.5427,-3316.6978,-3045.2817,-2929.6807,-2703.4995,-2837.5454,-2882.9558,-2908.2612,-2438.7576,-2386.9338,-2670.5017,-3315.9985,-3685.814,-3802.3428,-3790.5232,-3816.3435,-3855.787,-3867.1648,-3817.227,-3919.0125,-3999.5168,-3968.279};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_79()
		{
			double[] value = {-4001.789,-4014.1785,-4037.1113,-4010.349,-4041.0977,-4006.7349,-4080.822,-4082.4136,-4231.405,-4293.953,-4358.5957,-4408.2217,-4445.0674,-4460.132,-4469.006,-4464.962,-4540.3687,-4617.833,-4666.051,-4715.1675,-4771.683,-4802.586,-4823.6865,-4866.0283,-4901.809,-4918.119,-4918.9575,-4958.1543,-4978.7876,-4958.301,-4707.5596,-5545.3857,-4907.872,-4952.149,-4977.968,-4984.4077,-4969.4185,-4960.848,-4953.6895,-4925.7407,-4913.297,-4934.104,-4915.0015,-4896.2314,-5017.5176,-5040.0767,-4805.442,-4819.784,-4776.9536,-4792.1836,-4808.5103,-4839.5083,-4852.6626,-4858.568,-4856.551,-4845.6567,-4826.5005,-4812.4653,-4814.95,-4787.628,-4759.2383,-4757.303,-4770.932,-4745.022,-4759.6143,-4725.101,-4690.2334,-4610.4307,-4579.7695,-4579.2397,-4573.5713,-4555.5664,-4542.447,-4485.963,-4417.5923,-4348.1626,-4317.0493,-4299.7407,-4265.1675,-4226.1025,-4178.7744,-4134.2793,-4081.2688,-4048.058,-4000.7803,-3949.9905,-3869.1052,-3824.1333,-3817.0386,-3795.66,-3779.5393,-3756.74,-3735.935,-3726.899,-3678.583,-3699.9075,-3698.9038,-3670.9927,-3631.1519,-3687.644};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_80()
		{
			double[] value = {-3662.6255,-3627.135,-3652.1042,-3631.6184,-3615.5374,-3636.0608,-3494.3054,-3338.3674,-3228.0198,-3130.1238,-2916.343,-2803.0728,-2875.8325,-2853.3728,-2498.1855,-2548.5742,-3140.5764,-3326.2583,-3708.232,-3835.3884,-3853.3987,-3868.9753,-3872.8943,-3868.9111,-3865.5122,-3879.3577,-3996.9988,-4003.7544,-4027.6147,-4014.3289,-4039.2937,-4039.4568,-4044.65,-4020.9238,-4078.3555,-4083.655,-4265.0396,-4293.751,-4320.6484,-4360.3535,-4390.095,-4396.033,-4435.0503,-4505.3003,-4607.968,-4671.231,-4714.9683,-4756.0864,-4771.972,-4794.473,-4799.9204,-4838.513,-4872.322,-4889.1924,-4949.677,-4973.791,-4992.524,-4986.351,-4916.117,-4855.683,-4927.401,-4967.593,-4983.1504,-4989.552,-4968.5767,-4949.7803,-4941.465,-4926.747,-4948.4805,-4939.4478,-4933.8633,-4929.969,-4910.369,-4877.768,-4811.597,-5152.4526,-4707.046,-4817.544,-4800.509,-4823.517,-4838.1836,-4841.464,-4836.5654,-4847.9634,-4858.188,-4844.9863,-4833.5166,-4822.8525,-4802.4604,-4788.5796,-4809.0,-4770.5664,-4737.37,-4703.955,-4663.3877,-4616.174,-4583.22,-4580.789,-4582.338,-4566.8237};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_81()
		{
			double[] value = {-4546.1475,-4471.747,-4415.9,-4367.6265,-4337.911,-4306.4194,-4270.813,-4223.527,-4174.1484,-4078.241,-4022.1665,-3997.04,-3970.9138,-3941.6152,-3892.144,-3830.8977,-3804.2412,-3784.7437,-3792.4365,-3776.2815,-3752.722,-3732.3264,-3721.014,-3709.6733,-3692.7083,-3676.6562,-3607.8406,-3686.6658,-3702.0789,-3653.2812,-3669.0103,-3654.3823,-3616.957,-3594.7766,-3474.0933,-3467.519,-3335.8188,-3202.7117,-2974.6594,-2814.319,-2845.626,-2798.6365,-2402.4653,-2531.1248,-3527.5781,-3505.8105,-3700.1943,-3818.4092,-3846.5461,-3872.0544,-3883.9324,-3883.434,-3891.6306,-3876.253,-3915.4,-4006.7458,-4039.8691,-4030.484,-4035.0994,-4058.6216,-4054.751,-4043.3152,-4084.4065,-4084.2466,-4251.837,-4279.4956,-4322.1587,-4385.2246,-4433.9287,-4479.5215,-4533.413,-4573.8877,-4621.8237,-4679.341,-4726.974,-4771.3447,-4791.119,-4803.529,-4829.273,-4865.8823,-4890.254,-4878.3633,-4949.2227,-4983.083,-4994.6074,-4983.815,-4973.6655,-4959.404,-4964.607,-4980.2183,-4986.309,-4987.879,-4980.503,-4920.7437,-4921.621,-4922.55,-4929.5684,-4936.136,-4947.602,-4946.2524};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_82()
		{
			double[] value = {-4940.3047,-4929.898,-4916.205,-4888.2563,-4878.5913,-4845.643,-4825.9995,-4848.8135,-4839.966,-4844.8013,-4889.569,-4924.6226,-4925.6104,-4915.49,-4888.2363,-4881.925,-4861.811,-4775.0483,-4755.822,-4722.999,-4699.341,-4688.3374,-4682.078,-4664.9883,-4647.0283,-4599.344,-4593.939,-4574.579,-4525.777,-4487.985,-4455.8457,-4380.255,-4332.791,-4262.9536,-4220.73,-4157.0073,-4139.6772,-4077.3357,-4031.9531,-3939.4778,-3888.747,-3852.6106,-3851.2297,-3803.346,-3777.3916,-3753.6868,-3781.8691,-3755.6943,-3739.9695,-3740.281,-3755.3584,-3755.7444,-3717.781,-3698.9604,-3634.779,-3678.2966,-3718.4983,-3714.1165,-3707.6306,-3685.9587,-3674.9482,-3639.508,-3633.741,-3584.9087,-3493.8398,-3373.741,-3220.0073,-3176.55,-2992.5393,-2865.4006,-2608.094,-2801.632,-3624.276,-3626.8206,-3697.76,-3815.212,-3835.3748,-3856.2793,-3876.264,-3901.2554,-3893.9106,-3844.6765,-3911.1812,-3974.1272,-4024.8499,-4040.1382,-4047.0945,-4070.1025,-4078.097,-4077.133,-4093.3215,-4086.3406,-4336.676,-4375.3335,-4424.262,-4469.7456,-4511.8945,-4552.131,-4595.459,-4634.0273};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_83()
		{
			double[] value = {-4661.989,-4676.554,-4692.5796,-4740.2397,-4777.3887,-4803.185,-4807.3965,-4874.82,-4901.792,-4929.9033,-4955.212,-4974.7515,-4979.919,-4967.7544,-4960.971,-4964.98,-4975.0986,-4990.551,-4982.8877,-4971.7505,-4957.4487,-4924.963,-4904.139,-4917.6,-4934.2764,-4943.3867,-4931.713,-4944.596,-4944.0796,-4928.951,-4929.4653,-4931.485,-4919.4995,-4910.8105,-4897.9736,-4866.8545,-4861.1562,-4895.48,-4923.9707,-4901.7695,-4908.05,-4915.281,-4872.5137,-4833.379,-4791.7944,-4740.3984,-4759.418,-4752.5884,-4758.5425,-4738.868,-4730.963,-4715.356,-4689.715,-4652.333,-4590.726,-4548.993,-4509.3037,-4446.921,-4349.5522,-4293.919,-4235.657,-4207.3745,-4194.5347,-4180.664,-4134.9087,-4100.4224,-4012.6897,-3954.413,-3931.4226,-3909.554,-3861.6907,-3845.806,-3810.675,-3797.709,-3764.8772,-3753.4663,-3765.2317,-3791.7468,-3772.9753,-3758.797,-3758.2476,-3760.9246,-3745.4941,-3740.29,-3740.704,-3697.872,-3716.0515,-3723.1245,-3707.7637,-3687.644,-3658.5913,-3622.229,-3625.763,-3546.0955,-3428.799,-3314.7368,-3155.0715,-2965.155,-2775.1143,-2931.175};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_84()
		{
			double[] value = {-3598.2185,-3685.9202,-3729.5696,-3782.5835,-3753.5984,-3843.7502,-3851.7144,-3813.334,-3905.8672,-3888.4856,-3889.5156,-3981.609,-4043.2441,-4069.615,-4067.9353,-4073.0198,-4076.0554,-4088.228,-4101.5933,-4090.8296,-4386.0425,-4418.1094,-4470.698,-4507.208,-4550.5312,-4609.562,-4644.003,-4666.248,-4697.2207,-4696.0386,-4701.336,-4728.809,-4716.6113,-4780.0273,-4837.116,-4867.031,-4896.0605,-4933.8545,-4954.5586,-4962.697,-4955.506,-4948.464,-4947.021,-4958.502,-4959.6895,-4956.8594,-4957.0693,-4954.895,-4942.8174,-4931.163,-4921.008,-4914.699,-4924.2466,-4936.561,-4947.3833,-4945.6494,-4930.464,-4902.852,-4912.772,-4922.5996,-4918.5884,-4934.258,-4931.62,-4925.257,-4917.483,-4923.4277,-4941.585,-4943.4453,-4924.1787,-4895.3936,-4836.4365,-4802.6978,-4768.8413,-4774.8467,-4833.228,-4830.0776,-4778.6147,-4758.088,-4752.435,-4725.421,-4691.5044,-4641.776,-4589.8613,-4543.8438,-4478.088,-4391.8853,-4308.951,-4289.414,-4270.507,-4271.31,-4248.8027,-4216.1978,-4177.549,-4143.02,-4069.3958,-4014.7852,-3977.2847,-3947.4802,-3899.4998,-3882.1345};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_85()
		{
			double[] value = {-3862.1348,-3827.6216,-3803.2346,-3799.109,-3814.6438,-3811.2979,-3799.6113,-3778.5618,-3783.9036,-3786.7878,-3785.9175,-3786.3655,-3768.4526,-3708.3179,-3744.5762,-3731.737,-3737.542,-3739.1729,-3723.6646,-3714.9614,-3723.7988,-3664.9756,-3625.4714,-3530.4402,-3445.85,-3321.2969,-2921.2615,-2857.1707,-3599.4543,-3635.711,-3768.19,-3790.577,-3843.944,-3995.3442,-4003.7283,-3854.3403,-3894.43,-3920.7458,-3910.5146,-3993.4702,-4034.3423,-4074.6316,-4084.9246,-4077.318,-4082.0515,-4109.233,-4103.473,-4108.198,-4455.947,-4487.1255,-4504.0205,-4552.446,-4579.772,-4608.7534,-4619.8936,-4631.331,-4634.449,-4640.4014,-4678.522,-4710.497,-4749.3447,-4778.884,-4832.932,-4873.8203,-4899.829,-4946.824,-4969.9497,-4974.1704,-4976.7466,-4984.9077,-4978.0796,-4958.837,-4954.5083,-4954.5225,-4960.214,-4958.1133,-4957.566,-4953.662,-4939.28,-4935.097,-4930.431,-4937.6025,-4948.3716,-4934.8467,-4924.1963,-4904.446,-4904.3257,-4951.1743,-4965.9697,-4963.9307,-4936.905,-4932.7095,-4925.735,-4912.211,-4921.8125,-4914.7847,-4904.721,-4863.1323,-4826.0933,-4808.105};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_86()
		{
			double[] value = {-4803.296,-4847.4795,-4859.0503,-4829.014,-4802.7476,-4754.6025,-4745.6704,-4712.2715,-4672.5527,-4618.67,-4563.3604,-4518.884,-4472.834,-4376.6855,-4356.1504,-4329.249,-4309.4404,-4257.7407,-4162.562,-4100.923,-4118.2314,-4129.5615,-4079.9338,-4037.4236,-4012.0735,-3956.3198,-3935.1406,-3903.8872,-3892.4028,-3871.7344,-3854.6184,-3851.4556,-3854.714,-3817.244,-3787.2305,-3813.1536,-3822.6938,-3805.6514,-3801.8345,-3803.1035,-3777.9973,-3742.4517,-3762.9749,-3754.2434,-3745.0344,-3761.1245,-3763.02,-3774.4185,-3762.1577,-3716.8281,-3583.6377,-3605.9885,-3478.8174,-3524.6252,-3370.9707,-3276.6963,-3570.034,-3630.0435,-3791.727,-3815.7234,-3814.4282,-3873.1643,-3909.473,-3838.0022,-3929.171,-3938.4688,-3925.2336,-3924.4338,-3937.3867,-4034.2117,-4045.6401,-4022.379,-4076.5867,-4131.1406,-4081.643,-4099.2373,-4569.123,-4592.808,-4581.731,-4511.581,-4518.5054,-4555.9517,-4587.752,-4616.119,-4635.726,-4662.885,-4706.185,-4737.4834,-4760.2144,-4788.1646,-4822.34,-4855.7627,-4890.168,-4939.274,-4962.6597,-4974.074,-4978.486,-4972.8022,-4964.0977,-4944.8794};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_87()
		{
			double[] value = {-4942.638,-4942.21,-4945.7935,-4953.8184,-4944.135,-4938.9746,-4938.3228,-4940.7476,-4939.1167,-4940.873,-4942.3965,-4916.992,-4921.428,-4895.701,-4855.025,-4896.552,-4952.9473,-4952.765,-4948.064,-4944.734,-4934.9624,-4924.217,-4902.381,-4913.6587,-4909.5815,-4878.9634,-4854.479,-4844.717,-4825.463,-4840.7983,-4846.9453,-4851.317,-4811.4414,-4773.018,-4724.338,-4643.095,-4595.865,-4583.617,-4560.798,-4503.2188,-4453.9897,-4410.6836,-4368.6816,-4332.4204,-4254.236,-4035.0913,-3819.712,-3770.848,-3801.5688,-3941.1755,-4031.8625,-4058.1519,-4038.1587,-3995.3264,-3963.6526,-3939.3171,-3910.3267,-3919.1414,-3898.1853,-3879.955,-3869.1917,-3840.605,-3832.2493,-3841.8008,-3867.0952,-3843.6821,-3822.2695,-3811.2266,-3791.5337,-3792.5913,-3804.9514,-3798.0315,-3775.6665,-3771.1558,-3796.9192,-3810.8115,-3795.0479,-3738.439,-3712.0925,-3685.8113,-3597.5374,-3590.8015,-3639.7712,-3601.3396,-3569.5217,-3604.5996,-3808.5405,-3880.8533,-3832.6003,-3831.6365,-3843.7341,-3905.2917,-3942.3608,-3940.302,-3924.8928,-3960.1626,-4028.1013,-4060.6216,-4078.1208,-4052.2842};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_88()
		{
			double[] value = {-4053.9055,-4128.061,-4121.1006,-4092.629,-4573.8613,-4603.0884,-4636.369,-4588.863,-4566.8105,-4602.3877,-4609.828,-4637.484,-4665.3003,-4695.7427,-4716.025,-4741.694,-4747.4707,-4755.3755,-4792.7227,-4842.755,-4884.118,-4910.938,-4920.08,-4941.7246,-4957.8247,-4947.543,-4941.323,-4930.9507,-4940.95,-4947.3296,-4945.717,-4941.106,-4933.756,-4936.36,-4941.801,-4932.0566,-4936.9297,-4944.4062,-4933.2876,-4894.4863,-4896.7036,-4926.2437,-4908.63,-4912.2163,-4921.4307,-4929.333,-4939.401,-4948.674,-4939.122,-4903.082,-4895.4663,-4916.5093,-4916.5566,-4856.1353,-4886.817,-4874.798,-4822.889,-4811.0684,-4835.501,-4809.1626,-4790.3223,-4746.352,-4703.31,-4633.1196,-4562.71,-4527.405,-4526.188,-4507.0283,-4463.11,-4418.5215,-4372.015,-4317.979,-4130.073,-4090.2144,-5322.4297,-5452.045,-4294.962,-3774.046,-3972.9016,-4061.906,-4066.324,-4022.5017,-3998.4626,-3984.781,-3951.4163,-3915.035,-3909.76,-3898.7173,-3895.4158,-3891.1135,-3903.1226,-3877.3662,-3869.4573,-3878.7644,-3869.454,-3850.9458,-3824.2307,-3850.351,-3843.6208,-3828.4521};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_89()
		{
			double[] value = {-3799.8804,-3776.7024,-3833.2393,-3846.0225,-3821.3494,-3772.7117,-3766.0154,-3807.5432,-3711.9395,-3620.5247,-3667.9646,-3407.1963,-3472.8918,-3629.5925,-3823.9226,-3940.1802,-3948.1638,-3896.7441,-3926.4138,-3916.4146,-3933.5583,-3984.3264,-4024.384,-3945.8062,-3998.4292,-4041.0117,-4115.1675,-4153.0703,-4063.3154,-4085.298,-4125.4395,-4103.388,-4567.244,-4597.957,-4604.605,-4548.2803,-4540.071,-4546.229,-4568.955,-4602.6924,-4609.973,-4653.883,-4648.8604,-4685.844,-4731.468,-4767.7886,-4824.9697,-4843.481,-4856.1,-4882.0796,-4910.9976,-4937.3315,-4942.0483,-4942.7534,-4943.9297,-4949.6006,-4948.5195,-4950.2246,-4941.022,-4928.3374,-4925.667,-4925.1753,-4928.7686,-4902.347,-4919.288,-4910.547,-4937.145,-4938.058,-4914.9155,-4916.775,-4898.767,-4890.292,-4905.3784,-4968.69,-4882.5703,-4938.0215,-4937.8135,-4926.5767,-4905.461,-4902.0044,-4897.336,-4859.236,-4829.442,-4856.0796,-4812.6187,-4777.8584,-4777.9453,-4764.5884,-4750.615,-4714.463,-4666.152,-4582.5127,-4568.976,-4545.1396,-4503.7656,-4462.012,-4428.3584,-4401.0854,-4361.223,-4303.9424};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_90()
		{
			double[] value = {-4046.852,-4051.1763,-4998.431,-5121.162,-4177.9854,-3753.698,-3953.1802,-4063.9543,-4072.0132,-4034.6934,-4002.176,-3955.5823,-3937.1191,-3948.348,-3948.2617,-3955.4495,-3941.2988,-3929.6265,-3912.0544,-3890.7014,-3903.5122,-3908.8557,-3903.0283,-3860.6963,-3863.606,-3878.8809,-3877.4175,-3853.7856,-3819.7153,-3813.5435,-3845.5896,-3860.1897,-3811.8235,-3801.2246,-3797.1812,-3813.0054,-3763.421,-3694.2297,-3590.2656,-3539.8228,-3512.8389,-3589.274,-3878.743,-3958.5425,-3972.3162,-3966.444,-3983.3113,-3961.4426,-3916.7905,-3929.8862,-3945.6826,-3996.2751,-4035.524,-4077.0623,-4142.8877,-4174.8257,-4166.969,-4118.589,-4114.5083,-4070.6946,-4488.272,-4516.248,-4503.6113,-4489.2495,-4507.629,-4526.9688,-4555.0054,-4640.787,-4581.18,-4622.0234,-4624.208,-4677.256,-4730.9697,-4764.312,-4778.0635,-4819.809,-4852.139,-4872.4775,-4870.187,-4904.088,-4928.0815,-4936.2495,-4935.5293,-4937.0464,-4932.8506,-4929.0483,-4928.247,-4913.909,-4916.488,-4923.3384,-4923.867,-4924.9595,-4926.8794,-4934.3335,-4948.8906,-4940.955,-4908.5083,-4866.1333,-4881.9487,-4868.709};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_91()
		{
			double[] value = {-4874.852,-4916.798,-4821.522,-4906.1675,-4895.7764,-4905.8213,-4873.4614,-4802.628,-4820.992,-4805.2886,-4732.939,-4732.3867,-4760.4233,-4721.6294,-4696.1772,-4692.694,-4724.791,-4645.878,-4602.6245,-4564.3276,-4535.5205,-4509.796,-4482.1055,-4411.5063,-4370.719,-4353.9775,-4347.632,-4307.2256,-4217.1978,-3991.8123,-3800.746,-3834.089,-3725.7112,-3906.6624,-4004.604,-4073.4355,-4082.474,-4049.9888,-3998.7595,-3932.256,-3949.2036,-3982.2908,-4004.7107,-3993.1338,-3963.8865,-3957.6113,-3928.4768,-3934.4421,-3938.4578,-3936.9082,-3940.1187,-3890.8933,-3895.4841,-3906.656,-3907.499,-3863.108,-3863.9092,-3852.1086,-3870.7017,-3870.3062,-3861.947,-3842.8247,-3814.8992,-3827.8352,-3834.857,-3796.699,-3553.689,-3254.3235,-3285.4868,-3535.5227,-3918.7407,-3949.1577,-3973.357,-3984.021,-3989.9185,-3917.966,-3912.8298,-3907.3806,-3921.1094,-3942.2295,-4049.0083,-4104.5537,-4142.7427,-4169.8633,-4179.823,-4140.7866,-4140.016,-4102.858,-4375.0254,-4441.8193,-4474.063,-4493.736,-4533.2764,-4555.647,-4565.4014,-4507.81,-4595.9395,-4591.5586,-4632.98,-4688.7354};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_92()
		{
			double[] value = {-4731.021,-4764.5396,-4750.027,-4801.725,-4826.609,-4830.7686,-4851.1387,-4878.008,-4906.364,-4922.187,-4924.9507,-4922.8223,-4920.5864,-4911.1816,-4915.9336,-4927.182,-4925.6074,-4924.3145,-4915.6694,-4917.1255,-4929.3096,-4933.4536,-4928.1895,-4932.791,-4921.6577,-4902.523,-4888.0835,-4845.1646,-4843.282,-4853.14,-4869.347,-4885.2266,-4891.075,-4886.7207,-4875.269,-4822.5884,-4776.781,-4719.174,-4713.8555,-4750.8823,-4731.771,-4729.8813,-4654.418,-4585.5605,-4635.716,-4605.3193,-4563.9644,-4538.4126,-4519.8066,-4485.313,-4430.2993,-4367.541,-4305.962,-4315.745,-4304.2573,-4309.9395,-4288.936,-4252.228,-4175.648,-4100.5938,-4086.4258,-4165.5796,-4123.172,-4092.622,-4111.9585,-4069.4058,-4005.4214,-4005.2273,-4037.2227,-3984.727,-3982.656,-4003.9463,-3986.352,-3976.4053,-3958.789,-3968.5461,-3963.2302,-3963.9744,-3949.9058,-3913.65,-3926.5066,-3926.2563,-3914.5132,-3889.8462,-3884.3176,-3888.527,-3896.6367,-3881.3623,-3886.6436,-3865.2056,-3794.8533,-3873.781,-3888.6604,-3861.6726,-3743.4019,-3313.8381,-3214.642,-3657.5464,-3954.9834,-3954.447};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_93()
		{
			double[] value = {-3949.028,-3961.8123,-3967.4194,-3895.0344,-3882.899,-3674.9558,-3817.9648,-4002.2256,-4053.2178,-4115.722,-4144.8975,-4183.0063,-4180.029,-4139.0312,-4144.959,-4117.004,-4319.9844,-4385.6914,-4435.688,-4491.1235,-4548.354,-4565.165,-4580.802,-4593.0312,-4601.5103,-4628.74,-4678.802,-4699.384,-4714.6406,-4745.5493,-4758.952,-4775.9204,-4801.3804,-4822.16,-4845.34,-4865.899,-4884.6953,-4912.5356,-4918.813,-4912.8174,-4893.511,-4908.1953,-4915.362,-4917.216,-4912.3267,-4915.2656,-4906.0386,-4896.598,-4908.1113,-4915.0596,-4922.917,-4923.791,-4924.682,-4919.1084,-4903.0225,-4874.787,-4817.062,-4860.3154,-4861.7397,-4858.6587,-4867.5527,-4849.14,-4859.6455,-4786.3315,-4672.669,-4729.4897,-4762.732,-4763.141,-4710.5654,-4658.9585,-4621.2197,-4552.249,-4515.342,-4579.1426,-4561.1255,-4533.754,-4500.1055,-4472.231,-4434.04,-4407.772,-4314.66,-4328.592,-4311.115,-4308.495,-4274.5,-4244.7417,-4228.6987,-4172.3203,-4142.7773,-4174.5054,-4171.3,-4139.105,-4101.0645,-4087.525,-4069.8867,-4076.048,-4058.9714,-4033.9092,-4015.3428,-4014.5115};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_94()
		{
			double[] value = {-3998.7576,-4012.2803,-3999.1602,-4002.7983,-4013.0278,-3970.328,-3910.5361,-3938.0474,-3966.659,-3954.1628,-3924.1763,-3915.6252,-3894.3835,-3908.752,-3900.6443,-3880.6782,-3899.0554,-3883.3096,-3829.354,-3880.237,-3883.3816,-3873.8765,-3837.7168,-3615.6519,-3506.157,-3816.5688,-3955.5618,-3912.3835,-3932.1838,-3948.7876,-3912.3352,-3822.0698,-3867.3726,-3976.2761,-3967.0771,-4009.8335,-4068.2603,-4110.935,-4140.7344,-4170.781,-4169.7974,-4180.7627,-4174.9043,-4138.9644,-4306.015,-4354.8525,-4412.3125,-4460.653,-4455.6025,-4533.3003,-4604.1865,-4570.5034,-4570.615,-4621.2803,-4648.7583,-4674.307,-4709.387,-4740.676,-4750.5806,-4771.1816,-4784.175,-4777.878,-4803.2637,-4818.0293,-4842.287,-4875.8496,-4875.8164,-4855.4263,-4882.8096,-4896.4146,-4898.836,-4905.1533,-4904.4707,-4914.0615,-4902.0796,-4889.7876,-4816.624,-4824.33,-4913.0024,-4918.3457,-4917.7197,-4923.946,-4905.481,-4877.397,-4826.602,-4822.4463,-4858.4487,-4819.794,-4825.387,-4842.6025,-4813.6978,-4764.385,-4684.0996,-4664.9243,-4737.997,-4687.639,-4659.914,-4611.288,-4570.6143,-4543.248};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_95()
		{
			double[] value = {-4465.4155,-4523.2856,-4553.6694,-4539.3604,-4500.32,-4472.3813,-4467.8174,-4456.28,-4363.373,-4358.4077,-4323.1475,-4284.818,-4259.865,-4256.2896,-4228.899,-4156.362,-4155.62,-4181.1816,-4166.981,-4138.268,-4116.868,-4102.775,-4083.1301,-4075.3174,-4053.68,-4040.6846,-4054.3318,-4046.8713,-4032.1208,-4036.7815,-4002.7297,-4025.6726,-4040.2107,-4011.5464,-3942.6257,-3876.7776,-3964.4634,-3976.311,-3948.6702,-3940.457,-3930.7354,-3927.6775,-3914.045,-3901.779,-3880.1128,-3863.3704,-3889.2705,-3877.2024,-3903.3533,-3895.4631,-3873.3406,-3809.6335,-3743.038,-3827.7205,-3943.4324,-3896.1313,-3906.5833,-3926.541,-3845.0164,-3861.8335,-3862.6506,-3900.699,-3939.2378,-4057.5764,-4100.474,-4115.564,-4156.4424,-4163.6006,-4205.9624,-4202.8306,-4172.5547,-4133.455,-4296.496,-4347.2983,-4401.3525,-4425.5654,-4440.9663,-4497.594,-4518.9976,-4540.64,-4564.8936,-4581.729,-4625.848,-4688.452,-4690.955,-4711.766,-4686.752,-4658.153,-4710.863,-4729.571,-4745.816,-4766.6445,-4792.322,-4802.0503,-4792.932,-4846.3584,-4870.505,-4863.875,-4864.188,-4863.3857};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_96()
		{
			double[] value = {-4879.2646,-4882.732,-4870.061,-4844.5845,-4781.023,-4793.0166,-4880.182,-4891.806,-4900.7666,-4899.608,-4854.1494,-4841.9907,-4802.7065,-4783.8115,-4844.3975,-4812.7573,-4771.345,-4804.139,-4811.748,-4771.7275,-4715.341,-4693.61,-4689.3477,-4668.328,-4639.1753,-4599.6763,-4546.278,-4536.8735,-4495.5654,-4457.3057,-4506.364,-4539.179,-4505.8574,-4488.199,-4467.328,-4438.2656,-4396.623,-4366.8887,-4336.8623,-4302.741,-4258.8823,-4260.296,-4223.888,-4168.904,-4153.96,-4166.9126,-4157.278,-4144.012,-4128.147,-4133.0356,-4113.0522,-4083.9634,-4062.1807,-4060.0576,-4105.5957,-4066.4211,-4059.4404,-4045.4011,-4039.0967,-4032.2637,-4030.8215,-4002.553,-3990.5227,-3994.3618,-4003.1538,-3996.298,-3966.861,-3968.4893,-3942.0452,-3912.409,-3898.5574,-3885.0188,-3833.5564,-3835.6387,-3886.948,-3904.904,-3902.2625,-3890.3862,-3887.345,-3874.7812,-3884.899,-3888.1006,-3918.1892,-3894.3105,-3919.901,-3910.4988,-3927.5625,-3956.255,-3926.874,-3945.9531,-4074.071,-4134.481,-4116.226,-4140.7656,-4189.468,-4188.675,-4222.5674,-4213.661,-4157.3574,-4165.241};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_97()
		{
			double[] value = {-4276.828,-4328.0522,-4375.0107,-4407.195,-4434.693,-4465.457,-4508.4175,-4542.5186,-4551.197,-4554.115,-4590.42,-4629.8184,-4649.335,-4661.453,-4662.258,-4663.964,-4661.6997,-4687.6455,-4712.5303,-4739.123,-4725.5645,-4719.43,-4755.0356,-4801.87,-4814.312,-4811.3525,-4806.8403,-4820.422,-4850.2563,-4860.054,-4831.5776,-4823.4097,-4835.9233,-4807.4927,-4805.7764,-4850.635,-4846.8135,-4825.4463,-4781.5527,-4782.1445,-4784.9917,-4759.028,-4811.7075,-4804.338,-4771.914,-4753.6562,-4788.1396,-4760.362,-4723.578,-4656.5693,-4607.6396,-4617.094,-4597.946,-4569.07,-4545.53,-4507.485,-4500.6455,-4486.185,-4446.3237,-4456.614,-4481.7217,-4476.616,-4463.476,-4434.34,-4385.394,-4378.5283,-4353.1177,-4312.0317,-4261.24,-4270.6626,-4257.1387,-4188.143,-4180.699,-4185.6,-4171.2896,-4158.378,-4136.908,-4127.3887,-4132.6616,-4116.2026,-4057.248,-4078.635,-4100.8003,-4076.4773,-4070.9258,-4054.4287,-4058.5278,-4051.383,-4035.4436,-4046.3933,-4033.8872,-4021.6494,-4028.7356,-4013.312,-3973.999,-3937.3997,-4208.9717,-3892.8574,-3896.8398,-3882.343};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_98()
		{
			double[] value = {-3838.9348,-3844.2026,-3892.363,-3919.9521,-3963.3894,-3965.0574,-3954.496,-3933.75,-3929.682,-3937.3472,-3922.917,-3894.7083,-3928.9233,-3960.683,-3967.5244,-4019.843,-4004.2812,-4034.2263,-4130.9966,-4160.536,-4117.427,-4078.7078,-4113.2036,-4161.8613,-4198.6226,-4201.283,-4182.5205,-4176.369,-4276.803,-4301.9385,-4340.0737,-4390.2017,-4431.9224,-4434.2886,-4475.645,-4509.634,-4519.898,-4522.8955,-4526.014,-4600.507,-4612.2583,-4609.5073,-4627.1865,-4650.0713,-4613.459,-4663.1313,-4714.4497,-4699.641,-4686.4634,-4703.462,-4720.782,-4748.667,-4768.7935,-4779.564,-4779.867,-4780.712,-4793.6704,-4805.5156,-4811.5767,-4805.013,-4792.3,-4805.818,-4801.321,-4802.222,-4797.3115,-4781.21,-4747.382,-4732.093,-4759.69,-4730.6597,-4767.2627,-4779.5034,-4762.9243,-4716.9985,-4716.9927,-4726.342,-4704.678,-4654.604,-4623.369,-4538.288,-4466.8433,-4493.91,-4526.334,-4535.7095,-4524.244,-4497.9062,-4467.5776,-4405.2207,-4452.7637,-4486.764,-4446.8657,-4423.7046,-4364.9185,-4372.3433,-4377.03,-4325.157,-4301.898,-4269.881,-4237.917,-4211.945};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_99()
		{
			double[] value = {-4203.6226,-4199.3076,-4182.48,-4170.4023,-4156.446,-4114.844,-4122.6743,-4126.547,-4103.6987,-4124.668,-4107.921,-4100.7705,-4087.637,-4069.0356,-4075.832,-4027.25,-4021.191,-4058.4055,-4055.7612,-4030.492,-4039.6997,-4036.6255,-3992.086,-3962.6033,-3955.255,-3912.1943,-3964.4277,-3955.4583,-3922.6128,-3947.9294,-3936.337,-3904.4307,-3925.5796,-3951.603,-3928.1956,-3905.6123,-3920.679,-3919.9985,-3926.3098,-3911.4033,-3950.5688,-4011.555,-4014.625,-4045.0881,-4037.1345,-4073.0261,-4108.0947,-4141.5376,-4133.785,-4153.227,-4215.2515,-4172.821,-4173.3726,-4190.669,-4227.3364,-4221.3633,-4270.5923,-4295.559,-4331.0137,-4368.5137,-4406.4736,-4418.7515,-4440.597,-4457.5103,-4482.472,-4500.7637,-4497.4683,-4553.929,-4578.6216,-4581.0347,-4589.91,-4605.482,-4617.843,-4628.71,-4649.854,-4683.739,-4639.4785,-4658.619,-4659.783,-4633.573,-4688.8237,-4743.2817,-4756.3823,-4750.973,-4751.9893,-4758.4204,-4771.5005,-4736.5796,-4741.879,-4755.986,-4771.6704,-4779.8667,-4754.0933,-4734.0264,-4675.172,-4655.316,-4700.111,-4678.6196,-4712.9907,-4743.405};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_100()
		{
			double[] value = {-4712.9946,-4673.9653,-4633.7456,-4667.7188,-4638.9326,-4631.204,-4626.3105,-4575.8984,-4498.3135,-4411.776,-4387.594,-4532.8335,-4524.6143,-4509.4106,-4487.3247,-4424.9272,-4411.744,-4464.402,-4453.1294,-4419.4116,-4369.743,-4389.809,-4364.8345,-4318.36,-4295.7656,-4245.517,-4309.912,-4170.8433,-4186.0337,-4216.0107,-4202.7,-4189.837,-4166.9307,-4169.2485,-4174.3193,-4106.369,-4124.3657,-4131.407,-4124.9136,-4123.47,-4095.6094,-4084.1296,-4089.865,-4066.3762,-4062.3193,-4062.0276,-4045.9622,-4020.9133,-4023.123,-4016.3818,-3985.8467,-3976.6687,-3969.4246,-3992.481,-3984.1914,-3981.8774,-3999.5625,-3990.691,-3929.9976,-3875.384,-3877.8801,-3901.0083,-3874.0005,-3917.7976,-3947.6384,-3917.0042,-3927.8877,-3935.5684,-3964.1777,-4022.0972,-4025.2012,-3960.6729,-4013.2988,-4073.2375,-4112.9473,-4153.933,-4163.742,-4162.953,-4169.5938,-4205.347,-4186.7217,-4209.4766,-4226.0356,-4243.2886,-4254.9565,-4282.8594,-4316.2334,-4339.8643,-4367.782,-4407.6187,-4432.7466,-4452.4805,-4466.6377,-4476.584,-4458.749,-4493.943,-4518.44,-4530.7417,-4537.818,-4554.915};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_101()
		{
			double[] value = {-4569.655,-4563.5283,-4590.7476,-4589.916,-4498.1,-4564.535,-4645.7485,-4625.1494,-4675.9717,-4698.579,-4713.083,-4701.869,-4706.5767,-4720.9487,-4663.7227,-4689.788,-4698.438,-4716.9653,-4725.228,-4711.625,-4703.3193,-4667.59,-4594.472,-4555.3716,-4625.0483,-4631.585,-4653.786,-4680.8496,-4671.95,-4646.808,-4583.2676,-4557.933,-4576.9326,-4580.005,-4578.4595,-4556.5137,-4522.2383,-4468.801,-4411.355,-4397.4277,-4486.793,-4475.455,-4478.943,-4465.997,-4413.017,-4357.4126,-4379.4375,-4405.6406,-4399.938,-4412.1426,-4398.6055,-4362.868,-4340.4243,-4300.1924,-4176.2324,-4143.056,-4187.5493,-4207.823,-4212.4014,-4185.633,-4167.2026,-4200.1,-4147.6597,-4133.417,-4146.687,-4141.9395,-4136.6025,-4108.957,-4072.1892,-4082.2705,-4080.9321,-4078.173,-4078.599,-4045.4004,-4029.2698,-4015.013,-3989.877,-4010.9119,-3980.9976,-3953.2349,-3987.0356,-3993.9136,-4007.3145,-4027.3953,-4036.1482,-4008.0444,-3969.9329,-3949.713,-3902.0977,-3915.8582,-3949.252,-3930.6006,-3974.1477,-3902.071,-3959.151,-4001.984,-4016.4836,-4023.381,-3985.346,-3904.0908};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_102()
		{
			double[] value = {-3905.8252,-4017.5332,-4165.8926,-4182.8545,-4185.7065,-4183.047,-4199.581,-4225.491,-4223.874,-4234.5522,-4252.5425,-4242.2676,-4240.686,-4264.5396,-4291.315,-4313.0635,-4342.859,-4368.146,-4395.2485,-4413.232,-4434.557,-4440.298,-4444.9766,-4459.571,-4430.1665,-4462.118,-4484.4497,-4498.7217,-4497.184,-4578.455,-4573.214,-4510.0195,-4500.541,-4561.4683,-4616.3584,-4650.4434,-4664.8716,-4668.4585,-4673.977,-4667.4873,-4655.1636,-4672.6484,-4659.069,-4676.101,-4692.0806,-4676.989,-4663.2114,-4670.502,-4651.4497,-4642.9917,-4572.655,-4571.332,-4573.2227,-4576.5454,-4573.8555,-4641.143,-4631.954,-4594.073,-4565.524,-4554.083,-4568.3735,-4550.3306,-4542.887,-4536.279,-4517.493,-4484.996,-4481.3755,-4427.466,-4446.8022,-4480.767,-4482.2007,-4466.149,-4435.6396,-4403.103,-4369.283,-4399.445,-4421.498,-4425.501,-4400.6855,-4375.7944,-4367.445,-4318.545,-4230.1934,-4246.9272,-4218.47,-4227.031,-4219.6123,-4203.842,-4212.133,-4177.2197,-4167.1396,-4178.5605,-4141.5664,-4146.405,-4141.969,-4120.6157,-4100.862,-4081.4229,-4076.014,-4090.2278};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_103()
		{
			double[] value = {-4085.6267,-4074.1865,-4060.7412,-4043.6877,-4028.9438,-4028.2637,-3987.2812,-3979.4548,-3987.506,-3993.7417,-4002.9502,-4028.2703,-4036.411,-4017.9302,-3991.0444,-3968.8938,-3910.9739,-3925.3481,-4011.3108,-3952.9648,-3970.4978,-3921.916,-3979.9136,-4022.3691,-4023.223,-3996.913,-3820.0972,-4510.0947,-4710.93,-4075.9268,-4163.796,-4201.117,-4202.696,-4197.3413,-4220.525,-4224.406,-4229.561,-4214.7925,-4248.9897,-4242.664,-4196.4287,-4223.3384,-4249.9385,-4281.8584,-4290.873,-4340.0913,-4363.509,-4383.129,-4388.94,-4384.0356,-4393.266,-4416.8354,-4409.909,-4407.067,-4408.5586,-4405.989,-4473.9824,-4549.0625,-4509.6113,-4444.5015,-4506.661,-4548.3306,-4569.0435,-4573.0635,-4633.0015,-4648.7637,-4641.8555,-4631.4253,-4618.7007,-4602.5527,-4581.328,-4656.2925,-4650.52,-4615.0024,-4592.899,-4604.2495,-4613.1094,-4606.8945,-4595.022,-4608.09,-4549.6064,-4532.6655,-4527.5376,-4570.341,-4601.1675,-4585.534,-4558.892,-4491.6445,-4539.6816,-4560.8037,-4558.627,-4542.5996,-4535.513,-4502.8193,-4505.598,-4462.562,-4421.65,-4444.4185,-4480.702,-4481.4985};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_104()
		{
			double[] value = {-4462.8145,-4429.6567,-4417.163,-4425.752,-4433.063,-4424.472,-4391.5615,-4388.721,-4357.6035,-4313.0757,-4257.3755,-4266.4966,-4267.817,-4245.638,-4218.7563,-4241.1284,-4205.474,-4175.0776,-4185.5957,-4156.428,-4150.332,-4167.6284,-4136.0967,-4091.6204,-4080.6943,-4098.9644,-4100.2397,-4095.2214,-4069.506,-4063.4768,-4060.19,-4057.3977,-4047.0686,-4036.905,-3994.6177,-3990.3787,-3978.7883,-3991.9304,-4003.4688,-4025.1477,-4027.9736,-3996.7288,-3978.2983,-3995.312,-3968.2585,-3943.7168,-4014.7092,-4017.321,-4011.4292,-4002.8154,-3966.18,-4042.8296,-4079.8748,-4087.1096,-3944.769,-4038.6326,-4127.2847,-4102.579,-4201.0845,-4218.4243,-4219.849,-4255.1055,-4280.2485,-4229.213,-4232.133,-4215.2085,-4229.27,-4223.9917,-4122.317,-4158.0703,-4200.3086,-4242.7593,-4275.1484,-4306.548,-4321.9873,-4332.121,-4340.1016,-4340.8926,-4354.732,-4345.319,-4349.3647,-4338.3184,-4319.601,-4398.097,-4475.3423,-4498.0347,-4479.228,-4398.9414,-4447.8755,-4497.9175,-4532.6235,-4545.056,-4562.4023,-4589.4434,-4585.049,-4600.124,-4588.6226,-4584.2466,-4570.6323,-4542.403};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_105()
		{
			double[] value = {-4522.034,-4548.538,-4525.231,-4550.221,-4563.2285,-4560.226,-4561.826,-4546.695,-4530.2495,-4511.521,-4505.249,-4514.4966,-4564.7056,-4558.4233,-4548.287,-4536.3164,-4521.041,-4529.2524,-4546.9956,-4533.259,-4522.314,-4522.397,-4507.5483,-4466.1143,-4416.31,-4426.235,-4451.3115,-4454.0415,-4449.767,-4420.7646,-4427.989,-4449.9204,-4421.608,-4401.491,-4394.8936,-4382.7876,-4356.4014,-4319.843,-4310.159,-4315.524,-4278.327,-4226.3657,-4261.2515,-4250.5977,-4224.0938,-4195.688,-4175.9907,-4144.6304,-4165.6426,-4153.741,-4133.7124,-4118.498,-4117.194,-4116.9385,-4107.3516,-4086.573,-4064.3416,-4072.3076,-4077.5562,-4055.268,-4045.2334,-4050.78,-4024.642,-3993.4897,-3956.8186,-3996.8254,-4030.3843,-4035.7522,-4032.056,-4004.7156,-4010.393,-4019.7861,-3992.7031,-4018.3516,-4085.4387,-4079.9893,-4029.561,-4046.655,-4039.9595,-4074.3484,-4106.9023,-4112.9023,-4068.5583,-4090.986,-4165.049,-4182.8804,-4203.335,-4212.228,-4212.675,-4155.8994,-4106.067,-4167.293,-4229.5713,-4209.0747,-4223.0005,-4224.22,-4094.106,-4139.049,-4175.6914,-4195.065};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_106()
		{
			double[] value = {-4220.2524,-4240.5493,-4275.31,-4292.5737,-4292.846,-4315.729,-4310.4624,-4295.7183,-4281.325,-4256.6914,-4322.4336,-4409.877,-4430.162,-4440.6323,-4422.343,-4343.4277,-4399.0127,-4449.793,-4484.6416,-4507.8965,-4523.1045,-4532.496,-4533.0283,-4539.109,-4533.07,-4516.7573,-4491.8276,-4456.543,-4490.5347,-4503.8794,-4468.8745,-4477.647,-4487.1,-4512.342,-4517.966,-4514.0835,-4523.7617,-4512.858,-4475.002,-4494.2075,-4528.394,-4532.719,-4531.4946,-4529.3564,-4517.0713,-4534.308,-4550.939,-4534.6313,-4514.2075,-4497.1685,-4475.034,-4428.629,-4441.246,-4432.8037,-4449.3823,-4450.0435,-4429.7495,-4436.9775,-4421.8174,-4423.1226,-4391.358,-4373.122,-4379.1924,-4364.947,-4342.4927,-4339.0283,-4344.104,-4300.041,-4269.934,-4270.2266,-4272.9795,-4264.147,-4210.15,-4211.573,-4184.3545,-4184.3237,-4183.7095,-4165.8877,-4152.157,-4127.366,-4127.438,-4125.4985,-4114.8315,-4093.335,-4077.61,-4060.4646,-4065.799,-4039.6401,-4034.2139,-4035.7837,-4024.2295,-3976.795,-3952.2722,-4013.8687,-4034.0388,-4035.05,-4033.4805,-4045.91,-4036.036,-4015.3306};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_107()
		{
			double[] value = {-4008.1948,-4066.1948,-4097.643,-4103.764,-4056.01,-4080.4487,-4080.726,-4081.686,-4096.544,-4121.565,-4105.3936,-4127.046,-4167.8755,-4152.857,-4171.909,-4198.4634,-4194.888,-4163.7876,-4165.029,-4155.8726,-4197.6133,-4212.0166,-4226.0615,-4235.1104,-4016.8472,-4082.3115,-4125.3438,-4155.938,-4175.6963,-4207.46,-4223.2627,-4230.434,-4223.575,-4235.989,-4248.7124,-4219.1167,-4188.359,-4237.617,-4340.405,-4371.3833,-4391.3867,-4399.9736,-4329.853,-4279.115,-4352.9263,-4397.771,-4423.244,-4442.3105,-4476.635,-4483.167,-4488.77,-4484.0347,-4472.3096,-4457.475,-4426.6694,-4378.1953,-4440.9087,-4474.458,-4465.5117,-4443.874,-4444.8657,-4445.519,-4451.707,-4463.336,-4491.7314,-4485.472,-4413.7886,-4449.0913,-4476.1284,-4495.203,-4508.618,-4516.0156,-4504.009,-4542.4556,-4572.1436,-4513.255,-4492.4995,-4474.7524,-4426.9487,-4407.667,-4430.118,-4418.8267,-4450.725,-4437.7705,-4441.565,-4444.0605,-4418.804,-4393.688,-4364.4556,-4373.924,-4360.043,-4356.8906,-4352.233,-4345.9536,-4322.585,-4270.4453,-4304.6343,-4306.901,-4290.2314,-4259.3643};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_108()
		{
			double[] value = {-4237.5635,-4218.1157,-4211.5796,-4204.7637,-4179.602,-4180.057,-4152.461,-4147.118,-4141.1406,-4128.3755,-4129.316,-4108.6807,-4069.0063,-4046.8203,-4032.9187,-4034.0718,-4037.4902,-4012.2734,-3998.3762,-3962.1016,-4005.6526,-4035.5837,-4017.169,-4039.4128,-4045.2917,-4061.7617,-4020.6704,-4033.4937,-4043.2122,-4070.8105,-4093.228,-4093.8706,-4064.2273,-4029.9226,-4067.3604,-4100.4795,-4128.22,-4141.6206,-4150.421,-4146.5337,-4164.4937,-4134.913,-4146.3853,-4160.0186,-4121.269,-4102.572,-4159.819,-4156.287,-4152.46,-4194.2095,-4335.761,-4316.125,-4018.132,-4031.5996,-4053.2456,-4080.4001,-4121.4243,-4149.721,-4171.4,-4188.462,-4183.9634,-4187.2075,-4170.4717,-4145.4683,-4202.9956,-4285.1763,-4292.1475,-4309.0547,-4344.332,-4365.302,-4312.0386,-4242.8135,-4300.0728,-4351.1963,-4391.277,-4412.069,-4430.5454,-4435.7075,-4437.414,-4435.9536,-4425.91,-4406.8594,-4380.6343,-4352.023,-4394.956,-4440.426,-4438.571,-4419.118,-4422.855,-4421.9395,-4428.939,-4441.3643,-4450.0645,-4453.583,-4419.6562,-4401.0547,-4433.1133,-4458.0664,-4468.8267,-4472.717};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_109()
		{
			double[] value = {-4471.732,-4466.089,-4462.508,-4466.244,-4452.861,-4423.5713,-4415.667,-4411.853,-4389.1123,-4412.9707,-4440.7373,-4434.505,-4417.9473,-4409.0337,-4385.4,-4355.3613,-4346.881,-4340.8867,-4332.0806,-4350.514,-4329.748,-4317.2764,-4310.107,-4308.031,-4345.0215,-4307.0894,-4268.8525,-4253.7593,-4258.971,-4222.483,-4224.6846,-4216.686,-4198.2505,-4171.956,-4167.9766,-4160.8267,-4153.5977,-4145.6255,-4133.935,-4082.5593,-4040.5488,-4019.8062,-4035.6174,-4055.1436,-4036.0771,-4016.7532,-4002.589,-4008.5867,-4018.2705,-4035.375,-4048.2422,-4056.11,-4062.9487,-4066.7434,-4043.6997,-4060.7961,-4074.0398,-4080.8271,-4091.3542,-4091.5898,-4083.1125,-4081.5908,-4105.6904,-4114.9204,-4127.9497,-4144.9673,-4145.706,-4143.277,-4148.635,-4159.6953,-4185.8784,-4172.839,-4176.633,-4172.6353,-4170.2363,-4177.362,-4180.718,-4213.2954,-4202.376,-4199.1245,-4072.6758,-4087.352,-4098.3457,-4094.4905,-4092.996,-4096.078,-4113.34,-4117.207,-4127.5547,-4106.7305,-4090.2622,-4155.882,-4256.5894,-4260.8354,-4246.3486,-4250.1064,-4308.8447,-4329.691,-4266.599,-4188.7886};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_110()
		{
			double[] value = {-4261.258,-4309.6973,-4350.392,-4378.3994,-4373.866,-4375.4287,-4411.6445,-4404.954,-4393.5073,-4372.3496,-4348.9097,-4399.338,-4406.624,-4412.3286,-4401.7456,-4392.022,-4393.7246,-4399.686,-4413.0127,-4415.6943,-4426.3057,-4429.3955,-4435.4478,-4392.0103,-4401.685,-4431.6743,-4437.4087,-4432.6665,-4430.9844,-4451.976,-4463.9697,-4457.609,-4434.5576,-4418.4155,-4405.393,-4354.3667,-4360.0386,-4404.2974,-4407.8154,-4405.9673,-4379.384,-4361.8804,-4365.179,-4361.715,-4296.112,-4561.093,-4448.4956,-4304.1387,-4309.128,-4309.3774,-4331.947,-4318.1465,-4324.4844,-4315.2886,-4286.623,-4264.542,-4276.448,-4230.714,-4234.6333,-4216.715,-4195.7285,-4175.917,-4157.65,-4176.3184,-4173.4277,-4175.94,-4141.7104,-4061.7483,-4009.1294,-3985.5034,-4031.029,-4062.0146,-4049.509,-4033.512,-4045.9187,-4056.4878,-4041.7317,-4060.7798,-4072.7625,-4069.282,-4071.0444,-4073.9912,-4054.585,-4096.846,-4102.959,-4098.7236,-4090.1462,-4107.965,-4091.8027,-4105.9336,-4123.7256,-4131.9253,-4136.3257,-4165.0117,-4170.778,-4150.432,-4166.392,-4169.489,-4166.3438,-4206.6494};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_111()
		{
			double[] value = {-4199.273,-4195.3013,-4183.973,-4191.3896,-4221.076,-4236.313,-4213.7656,-4210.227,-4011.691,-4052.6743,-4085.4153,-4099.8457,-4101.431,-4099.2534,-4105.4126,-4087.8992,-4076.945,-4060.846,-4121.4287,-4160.8604,-4203.7163,-4222.214,-4219.424,-4244.1494,-4284.3286,-4301.1807,-4222.5522,-4164.654,-4221.097,-4286.036,-4323.8926,-4352.65,-4355.351,-4375.5527,-4377.273,-4374.645,-4355.3223,-4330.4946,-4305.0596,-4324.3594,-4372.309,-4373.7803,-4357.443,-4341.795,-4310.14,-4357.278,-4354.846,-4387.4897,-4401.2095,-4413.588,-4410.8423,-4390.8486,-4397.1006,-4405.2334,-4409.2295,-4411.0547,-4422.5596,-4432.5645,-4426.4067,-4426.8276,-4415.499,-4388.0586,-4348.725,-4314.2607,-4367.522,-4353.84,-4399.1187,-4395.026,-4375.3066,-4371.5986,-4356.4565,-4340.6694,-4334.4067,-4293.332,-4297.801,-4343.5,-4334.349,-4339.506,-4329.654,-4325.7544,-4293.5947,-4302.057,-4294.9814,-4284.455,-4275.6333,-4237.6167,-4239.083,-4230.3286,-4207.1606,-4163.2646,-4167.293,-4159.7114,-4184.0986,-4178.6606,-4150.9995,-4067.2131,-4038.814,-4048.0898,-4091.9072,-4101.8154};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_112()
		{
			double[] value = {-4091.1724,-4075.1016,-4076.6428,-4073.3967,-4080.294,-4093.8774,-4101.293,-4093.7886,-4104.387,-4095.0132,-4083.479,-4122.197,-4109.756,-4091.5886,-4118.398,-4146.276,-4115.062,-4124.716,-4130.7676,-4162.168,-4172.596,-4184.503,-4200.3594,-4177.898,-4194.671,-4192.76,-4164.402,-4183.246,-4231.214,-4231.5938,-4211.31,-4204.7183,-4245.487,-4254.3745,-4227.001,-4209.705,-4020.209,-4041.9756,-4060.7126,-4070.8818,-4077.0847,-4090.9175,-4088.9365,-4069.4575,-4067.3386,-4085.6846,-4136.176,-4171.9043,-4185.5557,-4180.709,-4174.1147,-4174.3213,-4237.6294,-4262.928,-4212.397,-4160.577,-4222.285,-4270.8657,-4307.012,-4320.752,-4319.9624,-4340.951,-4347.9976,-4332.5884,-4320.779,-4286.677,-4262.8594,-4308.7676,-4333.4487,-4318.9863,-4285.1523,-4282.6274,-4309.2256,-4333.9585,-4348.479,-4359.423,-4383.347,-4389.4043,-4390.487,-4381.6846,-4379.3677,-4389.224,-4384.665,-4400.101,-4401.2295,-4384.085,-4385.513,-4405.212,-4381.632,-4352.837,-4363.333,-4403.2266,-4393.596,-4401.236,-4388.98,-4352.936,-4349.3594,-4359.15,-4341.8716,-4320.1094};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_113()
		{
			double[] value = {-4354.777,-4364.246,-4358.714,-4356.1753,-4348.5366,-4335.454,-4322.215,-4326.225,-4293.8003,-4318.457,-4306.9346,-4302.481,-4269.9014,-4244.6616,-4243.9775,-4248.6484,-4244.349,-4226.1025,-4209.927,-4205.523,-4207.0845,-4171.8726,-4149.664,-4099.1094,-4145.3594,-4157.3486,-4150.478,-4149.87,-4148.045,-4135.251,-4115.7104,-4084.0574,-4085.793,-4088.6096,-4116.5303,-4118.463,-4120.9644,-4084.3909,-4127.5317,-4142.2944,-4122.918,-4123.1533,-4146.878,-4150.081,-4118.518,-4128.538,-4148.2266,-4180.0474,-4192.439,-4204.3584,-4199.5967,-4173.835,-4190.1953,-4199.2437,-4176.2783,-4199.76,-4240.0723,-4236.614,-4206.797,-4209.7397,-4236.444,-4272.2754,-4230.3286,-4222.775,-4064.0708,-4064.6274,-4043.22,-4066.315,-4076.9033,-4088.1074,-4076.7937,-4065.8762,-4084.9473,-4125.538,-4137.1816,-4144.9624,-4146.545,-4133.4307,-4107.103,-4140.7056,-4211.855,-4232.7896,-4143.91,-4157.2007,-4214.5615,-4253.258,-4272.0547,-4285.977,-4301.6377,-4313.5806,-4319.399,-4298.1284,-4274.0435,-4266.426,-4284.8945,-4309.6753,-4314.896,-4296.9126,-4290.938,-4300.006};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_114()
		{
			double[] value = {-4313.177,-4313.369,-4325.1943,-4331.298,-4356.607,-4379.123,-4371.49,-4366.052,-4366.3525,-4356.4253,-4346.4595,-4346.8467,-4348.6123,-4371.0796,-4379.5005,-4366.8867,-4348.273,-4401.527,-4402.7266,-4405.8843,-4405.9663,-4396.5557,-4358.382,-4343.8496,-4354.871,-4348.6567,-4326.016,-4347.873,-4368.0303,-4365.539,-4372.31,-4362.2485,-4351.7256,-4325.2466,-4333.203,-4343.233,-4328.089,-4352.7295,-4381.172,-4339.755,-4280.601,-4279.232,-4283.712,-4275.029,-4274.76,-4265.2393,-4237.3477,-4227.325,-4220.8286,-4181.6504,-4135.4604,-4179.9727,-4191.7544,-4192.071,-4192.734,-4194.4624,-4181.36,-4157.0825,-4147.37,-4125.0186,-4111.437,-4091.069,-4133.575,-4147.3926,-4138.7935,-4107.9233,-4146.438,-4149.9785,-4136.3447,-4159.882,-4173.84,-4161.2134,-4215.8223,-4225.2485,-4184.383,-4197.776,-4213.551,-4208.18,-4159.5293,-4135.6284,-4131.128,-4203.2095,-4228.849,-4228.1436,-4254.52,-4263.1074,-4249.6865,-4216.0312,-4247.129,-4253.285,-4255.2505,-4263.832,-4032.7952,-4046.6213,-4056.025,-4055.196,-4070.4211,-4072.3809,-4059.336,-4041.5784};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_115()
		{
			double[] value = {-4079.3682,-4106.157,-4131.9517,-4116.9014,-4108.937,-4075.134,-4053.8162,-4148.779,-4192.8174,-4199.6255,-4111.895,-4122.532,-4177.229,-4224.895,-4248.8423,-4260.2505,-4266.3184,-4265.8794,-4263.5835,-4239.661,-4217.2393,-4250.657,-4285.5947,-4300.286,-4303.119,-4297.8223,-4303.5933,-4299.7695,-4295.613,-4312.587,-4319.171,-4328.354,-4332.0312,-4347.448,-4362.2817,-4348.664,-4350.7876,-4332.816,-4307.818,-4315.956,-4337.788,-4366.6963,-4374.7188,-4364.3643,-4384.5034,-4392.9673,-4393.0415,-4380.621,-4373.946,-4364.664,-4362.852,-4359.614,-4338.127,-4325.8037,-4352.0684,-4363.0054,-4343.4766,-4353.708,-4366.268,-4364.806,-4356.5664,-4330.604,-4357.2646,-4357.3086,-4349.3906,-4357.605,-4369.5234,-4329.8066,-4331.919,-4310.197,-4297.3394,-4284.8325,-4272.6455,-4279.106,-4259.947,-4248.7803,-4272.097,-4258.471,-4219.514,-4212.6006,-4216.1216,-4217.0215,-4220.811,-4225.061,-4220.2266,-4181.8765,-4140.5166,-4119.5005,-4126.534,-4124.9385,-4163.0273,-4156.8823,-4138.831,-4132.3896,-4165.787,-4162.669,-4156.445,-4197.958,-4184.8994,-4174.754};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_116()
		{
			double[] value = {-4218.107,-4231.035,-4207.1357,-4221.0225,-4235.977,-4253.8823,-4265.0728,-4248.297,-4255.166,-4264.0654,-4254.5347,-4238.718,-4246.206,-4276.769,-4261.087,-4234.3887,-4266.0703,-4276.5127,-4266.4814,-4283.017,-3996.8445,-4008.175,-4019.7634,-4030.8062,-4045.7893,-4054.9885,-4044.7534,-4055.2866,-4082.3154,-4095.3777,-4106.9053,-4090.8018,-4070.3264,-4027.181,-4063.489,-4143.8813,-4168.4927,-4183.604,-4137.9697,-4116.3096,-4162.6675,-4198.9375,-4223.794,-4223.0576,-4234.795,-4237.341,-4223.684,-4169.86,-4203.627,-4244.4497,-4271.8647,-4285.5938,-4293.1406,-4281.47,-4287.635,-4280.0166,-4279.793,-4295.302,-4297.421,-4290.876,-4281.994,-4302.6855,-4310.084,-4305.8086,-4302.446,-4275.096,-4302.9463,-4340.912,-4351.6895,-4352.554,-4377.8296,-4377.5547,-4372.3306,-4375.2925,-4381.1147,-4358.915,-4349.0693,-4351.662,-4337.4297,-4281.6772,-4314.04,-4333.032,-4346.32,-4335.565,-4337.013,-4358.605,-4352.325,-4347.887,-4335.934,-4348.5786,-4368.762,-4370.3115,-4353.64,-4336.8594,-4328.8457,-4300.92,-4343.6797,-4329.422,-4315.9116,-4285.679};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_117()
		{
			double[] value = {-4296.892,-4305.5747,-4298.424,-4261.7705,-4201.301,-4204.013,-4276.4116,-4232.681,-4217.603,-4227.767,-4236.2266,-4247.866,-4252.7803,-4224.1836,-4157.289,-4129.872,-4158.4126,-4185.0864,-4184.315,-4160.7153,-4191.401,-4191.4717,-4186.641,-4178.854,-4224.5796,-4234.7275,-4188.95,-4102.6187,-4162.085,-4201.9023,-4255.9614,-4267.4683,-4264.396,-4267.7754,-4254.829,-4263.0366,-4281.0723,-4275.216,-4256.0757,-4257.0757,-4229.7275,-4282.9966,-4286.5103,-4275.947,-4318.0415,-4311.665,-4286.6714,-4313.1904,-3934.6711,-3976.1719,-3998.6333,-4013.3352,-4026.94,-4046.6362,-4050.0718,-4060.6785,-4055.389,-4061.7488,-4074.066,-4054.6455,-4017.5164,-3999.4028,-4101.5347,-4142.77,-4150.4683,-4159.804,-4093.7898,-4092.9023,-4138.072,-4178.021,-4190.2656,-4195.825,-4207.521,-4205.4883,-4190.511,-4156.491,-4200.006,-4214.468,-4240.269,-4256.352,-4255.096,-4261.467,-4264.174,-4266.46,-4233.2974,-4180.016,-4207.7134,-4229.883,-4240.03,-4235.224,-4247.2173,-4252.892,-4245.523,-4278.11,-4318.6055,-4332.598,-4325.677,-4331.7085,-4348.8647,-4355.9424};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_118()
		{
			double[] value = {-4361.052,-4359.7827,-4354.8516,-4312.5044,-4331.9863,-4346.1196,-4333.621,-4306.1064,-4310.598,-4323.512,-4344.5947,-4347.185,-4358.1836,-4343.351,-4326.499,-4343.542,-4326.673,-4349.8555,-4366.344,-4356.5054,-4342.443,-4346.707,-4329.3574,-4322.816,-4338.977,-4329.9805,-4314.5093,-4318.3228,-4334.013,-4335.52,-4305.2114,-4273.1787,-4214.802,-4252.839,-4288.9043,-4264.337,-4253.7593,-4252.674,-4260.8896,-4266.271,-4269.2236,-4267.916,-4218.8647,-4209.9336,-4197.69,-4193.5244,-4204.59,-4208.4556,-4249.0483,-4245.0806,-4243.477,-4252.2144,-4273.8086,-4273.497,-4275.612,-4231.669,-4221.1143,-4251.0186,-4278.6265,-4285.6313,-4296.5283,-4272.8203,-4229.0425,-4257.8267,-4283.3857,-4293.2993,-4264.7314,-4275.17,-4270.9673,-4256.6895,-4344.665,-4361.554,-4355.5576,-4353.175,-4326.0605,-4277.4116,-3957.3408,-3948.5588,-3947.6118,-3976.9358,-4015.6794,-4035.4683,-4050.1333,-4035.8357,-3994.8281,-3969.2832,-3972.9724,-3987.869,-4001.8452,-4035.692,-4081.2537,-4104.762,-4122.799,-4115.2095,-4103.6978,-4094.9197,-4116.609,-4157.273,-4168.0586,-4186.2734};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_119()
		{
			double[] value = {-4190.377,-4193.9214,-4189.934,-4140.2886,-4183.1133,-4220.7915,-4234.951,-4237.317,-4235.4233,-4245.2188,-4253.703,-4254.206,-4244.2173,-4221.2207,-4213.1655,-4220.21,-4221.239,-4234.7964,-4248.2417,-4258.1455,-4277.5137,-4297.1265,-4310.708,-4312.5146,-4313.853,-4289.2407,-4309.603,-4321.5586,-4333.1294,-4336.242,-4318.6904,-4289.019,-4328.513,-4342.1836,-4349.238,-4335.159,-4307.073,-4311.019,-4322.8506,-4357.708,-4371.7188,-4347.1616,-4355.0786,-4357.362,-4339.5195,-4352.0415,-4365.82,-4347.6167,-4346.575,-4344.244,-4335.0317,-4337.703,-4344.5903,-4350.125,-4333.6743,-4344.141,-4355.407,-4346.4775,-4325.753,-4284.386,-4260.058,-4300.4487,-4325.7896,-4318.058,-4308.9917,-4309.712,-4295.8237,-4290.0815,-4258.7314,-4266.619,-4248.5054,-4287.0806,-4249.7344,-4209.516,-4237.469,-4263.805,-4288.787,-4303.948,-4304.992,-4302.871,-4301.0806,-4305.645,-4298.2915,-4256.783,-4254.9746,-4285.151,-4310.15,-4314.395,-4313.564,-4317.344,-4319.0884,-4327.836,-4315.9946,-4299.963,-4271.3267,-4270.114,-4251.2744,-4268.924,-4339.573,-4367.1475};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_120()
		{
			double[] value = {-4370.3994,-4620.31,-4360.37,-4282.0254,-3964.1045,-3970.0613,-3968.233,-3941.1624,-3952.833,-3980.7024,-4003.0088,-4005.992,-3974.2913,-4001.7546,-4051.1072,-4054.932,-4038.1238,-4064.001,-4065.9678,-4086.804,-4088.8108,-4108.0513,-4110.493,-4093.4702,-4116.0347,-4134.8535,-4158.0107,-4173.4785,-4170.0522,-4179.997,-4168.8984,-4135.0854,-4177.164,-4192.723,-4206.469,-4212.0024,-4220.426,-4228.0293,-4239.0015,-4232.8496,-4205.6167,-4199.061,-4220.128,-4193.681,-4217.088,-4263.7607,-4270.4595,-4269.421,-4260.6016,-4280.8037,-4289.537,-4269.58,-4255.898,-4284.7534,-4294.938,-4307.5283,-4311.9263,-4261.7495,-4194.5347,-4265.297,-4247.5024,-4317.6763,-4324.316,-4307.4487,-4320.329,-4316.2334,-4336.616,-4361.4087,-4371.841,-4368.9453,-4375.2734,-4366.1377,-4348.615,-4343.932,-4369.6035,-4346.3184,-4339.2393,-4316.9834,-4334.4624,-4310.884,-4314.36,-4353.224,-4351.513,-4347.5454,-4359.1343,-4349.026,-4347.8164,-4309.5327,-4319.084,-4343.951,-4343.8325,-4348.235,-4358.232,-4393.142,-4359.5273,-4330.6006,-4307.303,-4297.2993,-4305.481,-4310.48};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_121()
		{
			double[] value = {-4281.707,-4257.1904,-4266.04,-4311.396,-4337.0,-4335.491,-4332.711,-4328.593,-4320.7617,-4319.4463,-4324.771,-4295.9062,-4284.7256,-4288.988,-4298.89,-4316.9155,-4300.3496,-4298.2217,-4334.513,-4333.768,-4304.5015,-4268.277,-4285.535,-4306.418,-4298.0864,-4311.748,-4318.9395,-4257.1987,-4491.2397,-5035.564,-4562.581,-4271.2427,-3949.1284,-3942.2097,-3948.613,-3963.7495,-3990.1934,-4003.5251,-3996.037,-3994.17,-4007.76,-4019.1792,-4023.2568,-4032.4668,-4020.6216,-4026.6106,-4032.5308,-4062.7185,-4092.6777,-4109.2646,-4100.734,-4105.3467,-4099.4688,-4103.7886,-4126.984,-4137.239,-4141.1064,-4139.5864,-4143.3013,-4159.0728,-4160.311,-4163.9175,-4176.187,-4186.946,-4191.262,-4185.1406,-4174.251,-4160.7764,-4160.3784,-4175.963,-4185.6846,-4201.85,-4239.0933,-4236.5146,-4241.4033,-4238.718,-4250.5327,-4250.855,-4247.506,-4247.7446,-4274.6704,-4290.7188,-4299.5615,-4298.288,-4268.1187,-4259.0527,-4228.098,-4253.493,-4287.8213,-4309.8994,-4302.846,-4292.7793,-4301.4795,-4322.067,-4338.967,-4354.7847,-4355.7905,-4354.4126,-4346.0693,-4332.3184};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_122()
		{
			double[] value = {-4333.132,-4366.005,-4380.5474,-4346.486,-4324.687,-4322.6133,-4304.1587,-4265.78,-4283.9062,-4510.1016,-4298.391,-4334.6196,-4344.43,-4336.7446,-4346.7197,-4319.152,-4329.358,-4317.138,-4291.8467,-4331.1816,-4394.549,-4408.0356,-4384.9385,-4364.19,-4370.6777,-4378.198,-4367.936,-4355.6143,-4321.841,-4311.629,-4336.0425,-4359.4194,-4370.292,-4356.9688,-4344.1353,-4331.6855,-4341.7007,-4311.1304,-4342.9185,-4348.85,-4340.8506,-4340.5947,-4334.788,-4327.0083,-4321.591,-4327.137,-4343.1626,-4340.1733,-4306.1797,-4293.258,-4358.65,-4360.391,-4395.3955,-4377.5693,-4345.1475,-4343.2266,-4331.469,-4335.9365,-4348.1895,-4347.04,-3945.2563,-3960.0312,-3961.4468,-3968.8506,-3978.2207,-3981.5935,-4000.666,-3994.9631,-4003.7876,-3994.9434,-3930.932,-3918.324,-3987.7402,-4003.4666,-3997.3616,-4028.7253,-4073.956,-4087.6738,-4104.4067,-4111.2285,-4098.746,-4120.027,-4128.369,-4122.1064,-4112.8496,-4111.5244,-4120.5356,-4136.287,-4146.3604,-4150.256,-4145.8003,-4146.828,-4133.912,-4103.5117,-4110.432,-4156.6934,-4191.025,-4207.6284,-4212.818,-4178.5747};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_123()
		{
			double[] value = {-4197.2114,-4218.3364,-4228.707,-4232.1484,-4238.21,-4240.2866,-4259.0728,-4264.5493,-4279.712,-4270.5806,-4275.707,-4279.465,-4291.248,-4302.354,-4309.176,-4327.7925,-4339.535,-4294.8784,-4254.0547,-4258.1733,-4305.4297,-4328.0747,-4331.996,-4340.3457,-4338.6343,-4334.088,-4316.509,-4340.0405,-4368.3745,-4370.5586,-4365.6685,-4344.3857,-4314.426,-4306.1074,-4297.058,-4283.1777,-4249.6597,-4292.7476,-4267.3203,-4330.8594,-4327.788,-4338.724,-4347.0654,-4337.1807,-4333.1426,-4314.1846,-4303.5737,-4333.4873,-4377.3115,-4381.3037,-4394.1333,-4395.583,-4391.1216,-4388.8228,-4396.5674,-4390.0024,-4366.8,-4356.696,-4362.7856,-4391.6587,-4391.9185,-4372.0986,-4363.602,-4354.5283,-4349.091,-4356.515,-4372.142,-4386.814,-4379.6675,-4381.764,-4366.304,-4327.7466,-4331.9653,-4351.162,-4347.8774,-4341.09,-4337.8164,-4344.825,-4361.929,-4391.7134,-4431.886,-4426.0464,-4396.4395,-4396.4673,-4399.3647,-4395.4746,-4407.069,-4410.7944,-3936.4822,-3943.3882,-3932.6802,-3931.157,-4036.5325,-3939.9895,-3954.2227,-3961.9597,-3994.2437,-3998.1682,-3937.6218,-3935.899};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_124()
		{
			double[] value = {-3989.491,-4043.2693,-4054.83,-4064.9048,-4062.273,-4050.4866,-4074.2917,-4094.6106,-4103.931,-4113.244,-4112.826,-4103.924,-4100.7524,-4105.2847,-4109.831,-4116.4414,-4124.6626,-4131.114,-4147.2676,-4158.526,-4147.289,-4139.057,-4127.5073,-4156.745,-4180.255,-4181.8477,-4172.1035,-4177.6147,-4182.2583,-4185.882,-4195.274,-4194.749,-4206.027,-4233.0894,-4258.7393,-4269.562,-4246.8745,-4240.387,-4260.142,-4281.832,-4298.3877,-4307.0464,-4306.623,-4302.037,-4304.7764,-4320.2266,-4329.232,-4336.3066,-4332.8433,-4334.01,-4333.023,-4346.325,-4351.322,-4336.7534,-4330.628,-4324.766,-4331.569,-4357.24,-4360.424,-4338.659,-4312.3447,-4305.1914,-4302.0996,-4328.1665,-4358.0664,-4348.1924,-4335.506,-4332.749,-4343.884,-4363.3276,-4367.7725,-4356.4956,-4352.335,-4352.657,-4355.2856,-4371.0513,-4383.7314,-4384.6597,-4399.3296,-4392.852,-4399.2275,-4423.034,-4432.0093,-4430.7397,-4393.54,-4378.3896,-4375.3486,-4400.0894,-4399.9688,-4403.816,-4413.3066,-4413.17,-4380.0396,-4384.54,-4425.5063,-4439.393,-4440.9497,-4433.201,-4426.9365,-4383.2124};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_125()
		{
			double[] value = {-4373.802,-4391.0244,-4388.8413,-4399.5,-4382.485,-4340.543,-4375.388,-4418.6753,-4413.792,-4429.1924,-4425.423,-4441.214,-4453.413,-4462.733,-4440.9565,-4443.658,-3930.765,-3934.4265,-3927.3647,-3934.0376,-4034.6692,-3901.1553,-3944.6482,-3972.65,-4011.9058,-4019.4087,-4025.0144,-4038.1772,-4040.0964,-4034.714,-4058.276,-4061.3203,-4071.445,-4049.7446,-4048.3198,-4045.3445,-4067.2722,-4076.1077,-4079.5027,-4096.241,-4108.8447,-4106.6064,-4110.2285,-4110.6665,-4122.6914,-4129.1504,-4137.8325,-4145.522,-4135.2783,-4105.7183,-4098.0674,-4114.035,-4130.7163,-4145.1914,-4155.104,-4165.411,-4169.9536,-4179.1895,-4195.138,-4205.151,-4212.295,-4230.687,-4238.9717,-4244.4854,-4242.7725,-4254.439,-4264.768,-4274.966,-4274.301,-4268.7764,-4275.252,-4295.233,-4316.3804,-4331.2446,-4343.41,-4349.859,-4344.345,-4341.197,-4338.7017,-4341.59,-4344.8125,-4326.5146,-4353.517,-4393.5107,-4423.66,-4420.636,-4371.7983,-4341.4673,-4322.6245,-4329.914,-4353.3203,-4361.7334,-4371.009,-4355.7124,-4346.9,-4372.0093,-4396.3145,-4399.2827,-4387.4644,-4373.2046};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_126()
		{
			double[] value = {-4384.848,-4385.2017,-4405.505,-4392.715,-4384.239,-4397.943,-4423.572,-4431.358,-4432.528,-4460.573,-4469.732,-4461.0596,-4439.2925,-4415.145,-4400.5664,-4408.354,-4390.7944,-4390.8516,-4447.107,-4462.4277,-4457.4644,-4460.9604,-4457.6743,-4462.8677,-4479.5884,-4485.8022,-4461.3423,-4453.4707,-4455.299,-4458.3364,-4437.1177,-4439.5938,-4425.627,-4413.9604,-4434.9346,-4456.5635,-4445.5303,-4446.624,-4448.739,-4467.9126,-4480.6763,-4496.4214,-4449.335,-4441.033,-3917.5815,-3902.2634,-3905.2617,-3924.1362,-3949.8018,-3980.2666,-3981.544,-3999.522,-4019.517,-4033.399,-4042.0999,-4036.8801,-4021.4224,-4018.4695,-4043.973,-4063.6562,-4068.708,-4042.7178,-4044.8386,-4064.0684,-4065.3477,-4080.39,-4087.854,-4077.6677,-4078.9512,-4089.685,-4099.978,-4102.64,-4092.364,-4095.8809,-4101.1245,-4101.507,-4106.1426,-4109.075,-4135.286,-4147.51,-4157.481,-4165.3545,-4167.49,-4173.197,-4161.771,-4161.958,-4155.4175,-4184.9814,-4212.1084,-4226.8936,-4233.9897,-4216.7075,-4236.6978,-4262.1196,-4246.2466,-4254.8647,-4267.2534,-4278.329,-4292.347,-4311.3027};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_127()
		{
			double[] value = {-4325.0566,-4338.0454,-4347.205,-4355.724,-4342.427,-4322.4863,-4321.366,-4330.776,-4339.831,-4354.048,-4386.385,-4460.4146,-4478.9746,-4454.7344,-4379.051,-4365.2373,-4372.1436,-4371.873,-4381.639,-4371.931,-4392.6304,-4388.9307,-4375.3193,-4401.3926,-4417.067,-4420.0664,-4425.093,-4422.503,-4416.6533,-4424.9976,-4439.0566,-4447.327,-4441.274,-4434.559,-4464.0366,-4467.482,-4474.4766,-4483.4136,-4496.8545,-4481.929,-4461.19,-4448.026,-4439.5747,-4442.817,-4432.911,-4421.994,-4481.1064,-4500.259,-4502.1665,-4502.796,-4495.9663,-4496.691,-4510.262,-4520.7144,-4508.0005,-4511.93,-4533.926,-4536.3647,-4509.093,-4504.3755,-4497.0757,-4502.1196,-4518.1167,-4521.8975,-4502.6,-4511.663,-4515.251,-4508.0273,-4526.7427,-4532.6636,-4485.3984,-4472.2866,-3948.5962,-3912.5706,-3894.7559,-3910.0203,-3931.4023,-3960.1025,-3962.4387,-3970.53,-3992.5378,-4021.3206,-4035.4949,-4040.678,-4041.6663,-4038.3442,-4036.1633,-4028.4731,-4033.4534,-4005.4895,-3984.1787,-4026.2776,-3970.8354,-4014.5225,-4052.4268,-4053.0508,-4059.3928,-4074.1958,-4094.589,-4094.778};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_128()
		{
			double[] value = {-4113.064,-4124.3647,-4128.8784,-4131.404,-4135.951,-4146.6953,-4150.8296,-4151.994,-4158.313,-4198.267,-4178.4624,-4187.9233,-4191.545,-4197.725,-4211.2573,-4216.635,-4244.743,-4237.0347,-4240.372,-4233.484,-4228.8164,-4231.3584,-4261.876,-4268.485,-4281.765,-4287.6294,-4295.045,-4301.927,-4313.194,-4329.573,-4335.4243,-4335.5596,-4322.831,-4329.972,-4347.1914,-4343.7993,-4351.548,-4367.071,-4384.1533,-4396.749,-4405.6597,-4406.259,-4404.079,-4405.0356,-4401.4727,-4403.975,-4400.4155,-4395.2773,-4403.877,-4398.1533,-4398.4214,-4431.708,-4447.282,-4446.1143,-4450.4507,-4454.329,-4454.629,-4461.707,-4475.9814,-4481.4453,-4479.048,-4477.473,-4486.0273,-4501.006,-4509.304,-4513.7812,-4506.9023,-4481.1787,-4479.3096,-4484.295,-4476.5903,-4506.605,-4526.4795,-4542.2744,-4531.3877,-4512.4414,-4501.8613,-4507.913,-4510.804,-4510.5435,-4523.7803,-4542.376,-4561.2246,-4587.2314,-4622.311,-4628.3867,-4624.209,-4604.0312,-4577.6113,-4578.2925,-4583.88,-4593.575,-4571.398,-4584.834,-4568.591,-4563.7505,-4584.3857,-4576.6562,-4514.847,-4492.7734};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_129()
		{
			double[] value = {-4001.1565,-3989.5881,-3963.1887,-3966.8716,-3980.0615,-3968.3772,-3965.9277,-3959.4402,-3981.2622,-3992.4927,-3988.7488,-3997.6858,-3997.5308,-3972.704,-3979.06,-3999.8142,-3950.5154,-3871.0386,-4012.8022,-4418.082,-3920.5115,-3897.1614,-4034.6216,-4049.176,-4042.355,-4049.4863,-4068.0833,-4084.549,-4088.276,-4097.3564,-4108.6606,-4117.552,-4131.5093,-4140.467,-4148.9927,-4161.6274,-4175.8784,-4186.355,-4193.521,-4196.4194,-4202.8716,-4206.842,-4207.7295,-4202.7856,-4201.944,-4231.646,-4240.0176,-4246.742,-4242.9873,-4254.466,-4255.546,-4262.271,-4265.5977,-4284.8535,-4296.138,-4299.814,-4323.1357,-4332.981,-4338.666,-4333.547,-4344.1426,-4349.65,-4352.4287,-4329.5615,-4348.9233,-4386.571,-4407.395,-4426.79,-4439.2705,-4451.9243,-4503.7144,-4533.4736,-4496.5073,-4436.8403,-4426.282,-4422.282,-4427.496,-4430.6606,-4450.1294,-4468.4126,-4474.3657,-4481.8228,-4485.3096,-4481.2407,-4486.575,-4494.1343,-4497.016,-4507.1543,-4515.2983,-4488.9355,-4483.1113,-4540.82,-4545.273,-4535.1475,-4519.108,-4492.742,-4478.812,-4500.23,-4520.7295,-4613.957};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_130()
		{
			double[] value = {-4636.0312,-4632.451,-4591.6,-4535.819,-4518.3125,-4524.3936,-4513.372,-4514.1353,-4535.205,-4542.226,-4545.344,-4584.7153,-4583.47,-4564.0093,-4563.0986,-4573.1636,-4608.1436,-4637.5396,-4640.39,-4603.0317,-4585.533,-4588.331,-4570.4043,-4579.62,-4584.975,-4558.1543,-4544.989,-4540.7153,-4049.4775,-4054.297,-4051.4287,-4047.0435,-4022.3584,-3992.6165,-4001.301,-3996.8638,-3997.3525,-4005.934,-4004.4087,-4001.8892,-3986.0107,-3965.2927,-3971.7236,-3975.6665,-3959.393,-3956.3423,-3939.7249,-3935.505,-3956.1042,-3980.8577,-4004.459,-3988.3147,-4001.7844,-4025.951,-4049.7197,-4054.3162,-4068.902,-4074.815,-4075.3062,-4084.0037,-4094.112,-4108.7856,-4118.465,-4129.088,-4129.957,-4142.0093,-4158.769,-4176.7705,-4176.165,-4185.9937,-4195.4277,-4212.622,-4231.153,-4235.699,-4228.4717,-4235.224,-4263.649,-4278.7847,-4258.7744,-4256.5757,-4266.3003,-4265.573,-4293.636,-4307.802,-4309.3667,-4316.2905,-4318.314,-4329.3384,-4347.8726,-4364.168,-4361.3257,-4382.91,-4406.1523,-4409.9834,-4416.998,-4427.719,-4446.081,-4448.632,-4442.2617,-4461.0156};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_131()
		{
			double[] value = {-4454.704,-4442.9746,-4444.9185,-4439.388,-4440.5537,-4446.808,-4478.3613,-4484.1543,-4484.8306,-4493.752,-4503.994,-4507.043,-4510.238,-4518.505,-4520.1387,-4543.3887,-4537.746,-4532.388,-4529.0903,-4555.111,-4554.338,-4540.0903,-4523.3286,-4493.6963,-4537.6016,-4526.34,-4555.736,-4567.539,-4581.934,-4572.7476,-4568.3057,-4554.285,-4526.508,-4522.6743,-4507.789,-4523.3604,-4559.6177,-4571.4434,-4576.553,-4610.033,-4593.693,-4565.3813,-4576.369,-4604.745,-4637.9717,-4639.756,-4648.7236,-4641.444,-4617.6113,-4600.2266,-4579.268,-4585.2056,-4625.497,-4622.593,-4611.9194,-4597.622,-4090.7703,-4088.408,-4088.0215,-4087.215,-4092.4973,-4080.0537,-4076.972,-4081.9036,-4081.951,-4086.4043,-4076.8926,-4073.09,-4059.2756,-4033.6392,-4004.71,-4050.5222,-4055.1414,-4057.1553,-4048.188,-4036.7703,-4050.305,-4053.3774,-4048.1082,-4058.546,-4069.9692,-4073.3757,-4078.04,-4081.551,-4092.7188,-4094.6628,-4095.8057,-4099.2695,-4102.0596,-4118.5083,-4114.591,-4138.617,-4148.762,-4164.968,-4190.164,-4197.9985,-4197.625,-4211.983,-4213.2627,-4213.3306};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_132()
		{
			double[] value = {-4232.88,-4244.114,-4248.326,-4265.002,-4275.775,-4266.4785,-4239.784,-4242.6543,-4259.24,-4265.629,-4281.5044,-4292.198,-4316.622,-4328.9604,-4342.0835,-4357.787,-4369.3765,-4377.4536,-4379.0176,-4394.923,-4404.5234,-4405.52,-4427.4253,-4439.893,-4444.473,-4430.0586,-4430.6665,-4446.4517,-4459.6294,-4454.2744,-4456.8994,-4449.576,-4439.913,-4463.544,-4459.803,-4472.261,-4468.876,-4466.404,-4492.4214,-4525.205,-4530.5312,-4533.5645,-4532.293,-4560.1396,-4552.9917,-4540.7295,-4564.652,-4572.4995,-4576.6787,-4566.1616,-4556.988,-4552.847,-4619.2334,-4586.8555,-4589.944,-4591.3516,-4593.791,-4571.627,-4530.733,-4460.3774,-4386.267,-4383.664,-4349.9775,-4387.6616,-4382.071,-4459.199,-4582.703,-4590.237,-4580.1187,-4587.388,-4629.231,-4652.0737,-4673.6694,-4687.9043,-4699.7183,-4698.832,-4696.0312,-4668.46,-4642.3286,-4626.5264,-4671.146,-4689.004,-4667.5566,-4655.412,-4151.9644,-4137.436,-4127.4624,-4114.804,-4111.6797,-4122.612,-4119.3887,-4122.9673,-4120.377,-4116.6187,-4116.898,-4121.058,-4119.316,-4125.232,-4121.358,-4134.5293};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_133()
		{
			double[] value = {-4124.9336,-4120.3716,-4127.1396,-4129.7734,-4136.578,-4136.569,-4132.9346,-4138.673,-4141.0254,-4124.551,-4093.049,-4122.213,-4136.4644,-4139.651,-4146.922,-4155.007,-4171.8257,-4188.9927,-4185.807,-4178.386,-4153.2983,-4163.405,-4191.377,-4204.3096,-4219.538,-4307.366,-4323.8125,-4259.1816,-4220.151,-4230.1553,-4243.249,-4253.273,-4243.078,-4240.9043,-4256.9194,-4262.646,-4267.984,-4296.8027,-4323.5015,-4337.7905,-4348.503,-4354.01,-4363.0093,-4362.491,-4368.187,-4374.3184,-4381.7817,-4397.4146,-4410.5845,-4418.9614,-4437.556,-4446.8384,-4444.977,-4433.825,-4453.7256,-4473.187,-4473.9023,-4453.843,-4465.4087,-4470.5923,-4418.792,-4598.2207,-4424.6255,-4465.094,-4491.231,-4486.345,-4515.5186,-4549.7886,-4538.0015,-4539.712,-4571.988,-4581.911,-4558.3047,-4567.8804,-4572.468,-4579.477,-4583.329,-4588.27,-4608.7114,-4628.5703,-4633.0117,-4628.407,-4624.585,-4611.931,-4582.6855,-4541.373,-4409.9404,-4347.891,-5073.508,-5228.1597,-5128.644,-4969.889,-4628.0938,-4252.2144,-4372.491,-4462.7905,-4559.846,-4586.7715,-4617.1064,-4646.081};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_134()
		{
			double[] value = {-4685.847,-4722.495,-4733.5854,-4731.689,-4736.509,-4727.9746,-4712.31,-4701.1987,-4703.88,-4720.212,-4717.2144,-4694.212,-4161.8975,-4152.0156,-4154.4004,-4147.743,-4136.9233,-4125.672,-4114.5776,-4107.399,-4113.2554,-4111.634,-4116.426,-4108.187,-4106.4985,-4109.4844,-4109.8125,-4113.8457,-4121.5146,-4124.404,-4136.0713,-4143.718,-4148.685,-4154.088,-4150.2183,-4155.3955,-4160.5024,-4154.518,-4160.7783,-4182.7505,-4182.3726,-4178.64,-4188.5967,-4201.744,-4207.034,-4217.472,-4222.795,-4219.0728,-4224.4404,-4230.3755,-4250.1304,-4257.735,-4259.424,-4270.603,-4281.249,-4275.0503,-4266.562,-4263.8857,-4271.3213,-4289.4263,-4297.569,-4298.473,-4297.6616,-4303.5215,-4320.101,-4331.1006,-4337.737,-4341.2236,-4332.6816,-4328.979,-4336.281,-4344.931,-4359.3,-4387.0864,-4395.651,-4412.6577,-4423.1626,-4430.3945,-4439.4756,-4450.1724,-4450.3223,-4432.3794,-4445.7876,-4473.8853,-4496.773,-4483.2803,-4481.2466,-4504.0825,-4508.871,-4500.545,-4505.0312,-4526.3506,-4545.0776,-4549.225,-4550.6943,-4562.6885,-4581.374,-4591.7803,-4597.9985,-4599.2144};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_135()
		{
			double[] value = {-4572.825,-4565.933,-4564.7544,-4578.272,-4600.128,-4617.786,-4630.985,-4643.8516,-4652.2544,-4654.409,-4658.064,-4619.6,-4523.23,-4430.7856,-4281.1313,-4539.941,-4969.7476,-4633.9014,-4448.8916,-4399.4736,-4522.8984,-4236.769,-4271.525,-4408.2554,-4592.9976,-4645.513,-4675.913,-4688.0854,-4706.7236,-4724.3794,-4736.8335,-4740.245,-4738.294,-4718.995,-4706.643,-4691.7686,-4668.36,-4820.237,-4811.295,-4677.5425,-4193.274,-4175.221,-4194.963,-4193.724,-4192.057,-4200.3535,-4171.555,-4143.664,-4158.387,-4152.2363,-4099.636,-4153.724,-4185.7573,-4186.4717,-4191.855,-4174.9004,-4150.519,-4137.6343,-4149.5386,-4163.8774,-4175.5073,-4154.7153,-4158.5557,-4188.398,-4196.405,-4207.3154,-4213.385,-4210.9717,-4225.6855,-4227.7256,-4228.4717,-4239.1924,-4248.489,-4244.832,-4241.65,-4243.757,-4263.393,-4269.4497,-4275.0913,-4283.762,-4282.4297,-4283.549,-4294.499,-4298.019,-4282.83,-4274.179,-4303.517,-4287.3467,-4294.544,-4286.1577,-4309.842,-4332.0693,-4343.474,-4340.226,-4337.2666,-4325.0884,-4320.2803,-4334.998,-4366.1177,-4380.6353};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_136()
		{
			double[] value = {-4385.249,-4406.912,-4415.013,-4428.303,-4430.9614,-4444.4155,-4455.527,-4462.765,-4473.7793,-4480.9385,-4490.8354,-4494.647,-4499.9507,-4484.241,-4498.0957,-4526.467,-4539.35,-4541.711,-4559.0464,-4572.024,-4580.6245,-4575.8525,-4590.07,-4598.544,-4594.662,-4606.0444,-4611.624,-4591.2466,-4569.484,-4544.9263,-4521.6064,-4553.0815,-4594.713,-4614.776,-4640.543,-4645.2744,-4658.755,-4665.383,-4673.306,-4653.5083,-4628.964,-4580.7896,-4422.126,-4508.4272,-4554.7275,-4433.0293,-4380.852,-4355.2656,-4462.802,-4561.5376,-4596.9697,-4608.1777,-4698.072,-4718.498,-4726.782,-4747.357,-4762.0186,-4760.2603,-4755.8555,-4763.7183,-4743.091,-4735.4316,-4739.5933,-4730.53,-4694.5815,-4711.688,-4724.3657,-4715.6436,-4229.359,-4220.1426,-4228.7085,-4229.2495,-4229.566,-4224.105,-4224.559,-4202.578,-4173.6763,-4205.0303,-4159.9814,-4126.4116,-4164.711,-4197.181,-4215.3403,-4215.4966,-4199.3633,-4214.045,-4207.6753,-4217.855,-4216.1685,-4212.012,-4214.2476,-4212.5874,-4214.667,-4216.6865,-4226.5547,-4233.1973,-4242.7417,-4247.181,-4248.6685,-4257.9614};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_137()
		{
			double[] value = {-4269.1475,-4258.1133,-4261.639,-4275.274,-4289.424,-4291.897,-4286.7134,-4285.4536,-4290.7153,-4296.9204,-4296.491,-4286.234,-4269.0215,-4303.024,-4323.3677,-4327.5513,-4326.6963,-4317.6973,-4340.466,-4350.6445,-4350.6304,-4334.0317,-4350.8726,-4361.619,-4376.8887,-4374.446,-4387.7935,-4393.1035,-4398.538,-4411.1875,-4424.4033,-4430.1445,-4437.3936,-4448.0693,-4467.0327,-4478.865,-4490.2563,-4500.8125,-4508.8477,-4505.7476,-4503.311,-4515.113,-4535.07,-4543.741,-4545.5244,-4555.3325,-4563.6855,-4580.3145,-4595.306,-4604.627,-4602.51,-4602.335,-4614.1543,-4616.578,-4615.213,-4616.879,-4600.5454,-4579.381,-4564.8403,-4586.7734,-4613.734,-4629.371,-4642.877,-4654.45,-4665.788,-4674.0986,-4669.584,-4668.337,-4697.6997,-4694.638,-4614.679,-4621.5366,-4608.4307,-4585.7974,-4615.4526,-4704.538,-4704.7456,-4757.2295,-4766.2676,-4769.6304,-4770.7324,-4788.545,-4805.271,-4800.194,-4798.694,-4789.748,-4793.194,-4808.5405,-4807.887,-4791.593,-4785.85,-4794.7285,-4785.8354,-4781.9277,-4755.6685,-4763.402,-4246.7534,-4247.378,-4234.1016,-4251.544};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_138()
		{
			double[] value = {-4250.2725,-4238.15,-4242.293,-4232.6875,-4215.8833,-4227.3745,-4235.7417,-4231.9,-4236.458,-4230.8457,-4238.9536,-4237.243,-4217.0024,-4227.1226,-4247.4893,-4265.7563,-4256.653,-4261.016,-4260.8257,-4259.5713,-4252.6416,-4251.4136,-4255.292,-4255.669,-4263.643,-4265.3677,-4279.6157,-4289.297,-4300.2407,-4302.9653,-4306.4346,-4304.1724,-4302.5454,-4297.8154,-4288.976,-4292.554,-4288.8784,-4296.2046,-4297.202,-4298.137,-4321.119,-4342.3857,-4359.3813,-4356.993,-4352.6265,-4354.796,-4358.603,-4369.5186,-4378.908,-4367.85,-4372.037,-4390.3125,-4381.2754,-4371.8105,-4386.0522,-4390.747,-4396.7456,-4421.979,-4441.5146,-4450.1206,-4464.4546,-4475.199,-4487.3467,-4491.1807,-4503.4883,-4504.294,-4510.4497,-4500.0117,-4501.7563,-4527.196,-4539.3853,-4557.177,-4561.066,-4565.7163,-4567.2383,-4579.904,-4604.227,-4606.8423,-4610.383,-4626.0586,-4624.4546,-4631.2563,-4637.5083,-4635.3877,-4637.3174,-4632.579,-4629.641,-4637.8887,-4646.5103,-4639.4404,-4629.9775,-4647.9604,-4668.367,-4690.498,-4708.568,-4696.623,-4698.4023,-4694.2134,-4713.8613,-4746.0234};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_139()
		{
			double[] value = {-4742.265,-4716.1826,-4688.1533,-4707.2085,-4729.08,-4791.931,-4850.927,-4852.112,-4836.1157,-4838.0796,-4845.0557,-4845.8486,-4845.4883,-4853.911,-4854.419,-4854.1797,-4856.2554,-4837.437,-4806.3223,-4812.4688,-4812.637,-4815.3647,-4790.655,-4779.165,-4260.246,-4256.5293,-4266.6826,-4271.5137,-4271.0303,-4283.121,-4280.5923,-4277.0303,-4273.301,-4284.321,-4280.6865,-4282.101,-4272.7764,-4284.914,-4279.8096,-4266.615,-4276.786,-4286.2183,-4293.0454,-4289.155,-4291.531,-4294.4585,-4296.014,-4297.2036,-4296.3394,-4301.478,-4295.7676,-4282.667,-4294.5884,-4296.4287,-4305.5044,-4306.702,-4305.9595,-4312.561,-4311.9,-4300.7407,-4291.809,-4295.881,-4307.6494,-4318.748,-4335.512,-4353.409,-4362.1523,-4368.9985,-4378.8613,-4380.5947,-4385.3433,-4388.1475,-4391.8916,-4397.1504,-4392.465,-4389.7524,-4385.6963,-4366.8677,-4378.4795,-4379.3325,-4376.0977,-4392.8706,-4421.469,-4433.1904,-4451.3335,-4470.9995,-4468.4824,-4472.235,-4485.047,-4480.9673,-4484.629,-4487.924,-4492.468,-4491.655,-4505.2734,-4524.7974,-4533.7485,-4552.545,-4565.321,-4565.45};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_140()
		{
			double[] value = {-4567.7417,-4572.4707,-4573.7266,-4577.5176,-4610.858,-4625.9736,-4635.988,-4647.2715,-4651.1714,-4652.0757,-4648.7324,-4649.224,-4653.175,-4651.6914,-4654.9683,-4667.3394,-4673.4966,-4676.623,-4681.113,-4686.489,-4685.7896,-4654.017,-4650.3696,-4677.417,-4663.7275,-4653.252,-4702.5327,-4744.229,-4734.478,-4723.166,-4741.947,-4753.693,-4758.322,-4764.563,-4813.2876,-4841.0205,-4847.7915,-4858.5283,-4873.4565,-4883.761,-4876.4487,-4869.042,-4871.922,-4875.183,-4898.689,-4843.959,-4808.546,-4807.6587,-4829.159,-4841.3423,-4868.811,-4853.945,-4219.3086,-4273.981,-4287.752,-4315.299,-4324.569,-4326.758,-4323.84,-4326.786,-4325.2583,-4327.83,-4333.6504,-4336.607,-4331.917,-4333.736,-4321.5186,-4304.575,-4311.345,-4313.695,-4318.8604,-4326.276,-4325.325,-4324.996,-4319.561,-4323.7227,-4326.122,-4327.7363,-4325.714,-4327.0845,-4321.7944,-4322.765,-4331.263,-4339.5635,-4345.7754,-4336.6323,-4342.153,-4333.6357,-4337.7666,-4296.7075,-4337.4077,-4346.0747,-4331.81,-4355.359,-4374.832,-4376.1836,-4399.472,-4401.6597,-4406.8564,-4411.2163};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_141()
		{
			double[] value = {-4411.8857,-4410.7754,-4403.007,-4394.3022,-4402.244,-4403.4717,-4410.2227,-4421.322,-4439.7954,-4446.3877,-4453.172,-4471.2124,-4478.322,-4484.8604,-4488.9185,-4483.5107,-4492.507,-4491.1377,-4489.5864,-4487.998,-4493.337,-4512.2515,-4530.3438,-4538.1523,-4545.73,-4551.5215,-4555.3174,-4562.434,-4578.0566,-4590.392,-4601.569,-4618.58,-4630.971,-4646.6357,-4656.3257,-4662.8887,-4661.4185,-4664.48,-4668.569,-4667.0366,-4666.501,-4666.6064,-4671.357,-4681.677,-4701.7993,-4716.5093,-4717.6895,-4729.433,-4712.897,-4692.2915,-4677.426,-4687.925,-4694.89,-4732.452,-4760.4175,-4750.7583,-4753.8823,-4728.993,-4719.012,-4734.2607,-4701.9434,-4718.5703,-4727.3296,-4776.8525,-4797.599,-4836.8945,-4866.2617,-4869.6113,-4873.902,-4889.304,-4895.574,-4905.7007,-4911.9688,-4892.197,-4880.1504,-4864.316,-4860.443,-4867.596,-4880.5024,-4896.3887,-4161.449,-4232.712,-4267.7417,-4292.96,-4334.1514,-4339.5977,-4345.417,-4356.735,-4357.587,-4357.6426,-4368.5337,-4362.4326,-4360.879,-4348.4316,-4343.625,-4333.4194,-4309.8604,-4312.7954,-4334.5913,-4339.8354};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_142()
		{
			double[] value = {-4347.6914,-4344.377,-4341.5454,-4340.6865,-4341.4023,-4342.5977,-4350.631,-4348.2656,-4350.4385,-4337.3174,-4328.9097,-4333.0796,-4354.9043,-4350.4473,-4355.3,-4368.248,-4340.5635,-4351.57,-4386.324,-4361.1587,-4274.9106,-4310.2295,-4361.744,-4367.028,-4364.336,-4359.5435,-4390.843,-4427.257,-4397.5083,-4376.8604,-4409.5293,-4424.4688,-4439.4453,-4458.3335,-4458.6973,-4459.7285,-4475.239,-4477.992,-4483.6655,-4496.6816,-4498.721,-4499.8164,-4513.3105,-4521.9937,-4524.0747,-4522.9707,-4534.8535,-4522.1753,-4500.784,-4509.3066,-4508.9946,-4507.265,-4530.386,-4570.535,-4581.3516,-4599.5864,-4615.9473,-4622.5103,-4627.046,-4639.439,-4648.556,-4651.5464,-4665.6323,-4674.7153,-4670.5996,-4672.691,-4664.945,-4676.244,-4699.6484,-4696.156,-4696.03,-4707.081,-4732.698,-4741.8447,-4750.212,-4757.257,-4757.5054,-4746.543,-4726.827,-4709.8877,-4713.39,-4729.0703,-4718.4624,-4703.158,-4760.6294,-4770.1426,-4764.57,-4822.7173,-4841.5933,-4884.9443,-4884.484,-4868.787,-4854.9146,-4855.426,-4860.641,-4885.8423,-4913.537,-4926.048,-4933.8306,-4956.914};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_143()
		{
			double[] value = {-4959.861,-4941.968,-4910.936,-4889.598,-4879.0,-4877.7017,-4905.5625,-4909.2754,-4409.7036,-4407.8457,-4406.248,-4403.6475,-4400.018,-4422.4116,-4456.1963,-4466.418,-4467.8013,-4464.919,-4458.49,-4430.652,-4394.4224,-4381.203,-4384.485,-4386.2686,-4380.657,-4377.4956,-4386.043,-4385.605,-4386.5015,-4382.2886,-4375.807,-4371.2935,-4362.279,-4361.212,-4354.672,-4358.4727,-4376.0513,-4398.98,-4373.327,-4306.2866,-4329.3994,-4349.6196,-4358.7075,-4342.2393,-4356.993,-4374.5024,-4396.7817,-4400.339,-4389.23,-4320.811,-4324.915,-4362.343,-4330.526,-4302.3403,-4324.0464,-4336.311,-4351.0195,-4368.0947,-4372.3984,-4370.9546,-4377.1914,-4383.72,-4402.278,-4419.0317,-4432.0874,-4438.379,-4444.835,-4464.7725,-4482.9185,-4493.4688,-4502.539,-4502.2783,-4504.805,-4502.269,-4503.0967,-4517.2183,-4529.9897,-4550.6533,-4562.717,-4573.6787,-4586.8325,-4599.2793,-4602.082,-4615.2266,-4627.955,-4628.8145,-4624.4595,-4648.575,-4665.1226,-4666.3403,-4676.8228,-4678.594,-4684.7456,-4681.5938,-4682.1636,-4693.4746,-4707.9688,-4694.373,-4694.857,-4719.6064};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_144()
		{
			double[] value = {-4726.826,-4731.701,-4746.752,-4743.3296,-4737.441,-4731.911,-4721.3354,-4722.584,-4732.7524,-4747.1772,-4747.5615,-4760.736,-4770.445,-4775.0254,-4774.7173,-4779.1724,-4806.512,-4825.406,-4844.118,-4847.2886,-4852.787,-4856.4854,-4846.2266,-4837.6914,-4840.834,-4878.3735,-4903.276,-4908.6274,-4885.476,-4891.9917,-4893.0977,-4899.94,-4907.9536,-4910.8003,-4909.217,-4886.1055,-4440.5166,-4445.0264,-4449.949,-4452.962,-4452.311,-4456.782,-4460.952,-4464.3613,-4463.286,-4447.963,-4448.37,-4445.162,-4437.4316,-4437.1753,-4437.8784,-4434.7954,-4433.8364,-4431.3022,-4416.03,-4404.2056,-4393.2915,-4385.646,-4389.9277,-4403.55,-4399.7065,-4391.496,-4388.7764,-4398.979,-4402.595,-4408.9263,-4396.6885,-4334.583,-4321.1484,-4320.367,-4333.5347,-4342.336,-4353.913,-4369.587,-4369.587,-4365.533,-4391.182,-4400.632,-4390.476,-4394.2656,-4398.123,-4382.6934,-4361.516,-4361.8022,-4379.0576,-4395.1387,-4411.078,-4421.055,-4433.4956,-4440.249,-4448.056,-4453.371,-4449.966,-4446.8643,-4456.994,-4474.904,-4476.441,-4473.6016,-4472.8213,-4470.996};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_145()
		{
			double[] value = {-4508.7217,-4521.5435,-4521.998,-4526.7964,-4539.228,-4549.7954,-4556.0796,-4564.001,-4565.909,-4581.2656,-4592.4683,-4607.7666,-4622.6895,-4621.9927,-4624.15,-4642.666,-4661.071,-4667.901,-4671.0815,-4677.6733,-4687.005,-4695.4976,-4703.9956,-4710.06,-4715.044,-4699.4644,-4685.41,-4704.573,-4698.6646,-4672.9136,-4691.2744,-4715.4565,-4727.001,-4749.4624,-4762.6504,-4770.8867,-4771.036,-4779.9663,-4779.751,-4774.104,-4778.9062,-4761.373,-4762.526,-4778.301,-4794.3813,-4805.5967,-4820.26,-4825.8394,-4824.5615,-4828.767,-4827.889,-4814.4365,-4804.244,-4811.0923,-4812.7495,-4831.807,-4845.5254,-4860.619,-4879.899,-4854.8125,-4857.615,-4865.0117,-4872.8594,-4865.924,-4477.5713,-4481.8335,-4488.816,-4494.2466,-4481.4883,-4482.1777,-4484.3184,-4478.5864,-4471.596,-4458.9863,-4461.5605,-4462.327,-4466.9795,-4461.5317,-4452.477,-4448.0166,-4444.1094,-4441.3003,-4443.8037,-4430.662,-4423.1885,-4427.7754,-4427.8823,-4424.1035,-4419.1914,-4416.537,-4415.147,-4421.1216,-4420.013,-4409.283,-4365.6587,-4355.5273,-4353.095,-4358.741,-4355.086,-4355.788};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_146()
		{
			double[] value = {-4362.5825,-4362.896,-4374.22,-4388.3525,-4401.5986,-4412.3965,-4424.882,-4428.6865,-4434.0,-4442.317,-4449.729,-4462.238,-4478.616,-4499.169,-4505.363,-4510.03,-4522.899,-4526.4683,-4529.4565,-4514.6216,-4510.022,-4509.27,-4539.6753,-4546.3936,-4545.8564,-4542.974,-4554.785,-4566.518,-4568.758,-4571.155,-4571.333,-4559.3037,-4564.356,-4554.384,-4549.5176,-4575.4517,-4590.9727,-4599.8276,-4610.668,-4623.206,-4636.3833,-4642.721,-4643.7324,-4653.478,-4674.3926,-4691.507,-4692.2617,-4684.357,-4683.046,-4687.9,-4697.461,-4700.5405,-4710.1626,-4702.7637,-4673.314,-4677.2695,-4677.2163,-4681.6626,-4687.787,-4701.048,-4720.7056,-4747.3735,-4764.2925,-4752.086,-4742.2437,-4743.505,-4745.4565,-4747.097,-4762.718,-4761.087,-4755.804,-4771.984,-4781.105,-4798.8184,-4801.581,-4797.6504,-4786.543,-4779.3413,-4779.2437,-4770.5615,-4763.992,-4748.2563,-4744.06,-4768.8564,-4782.3564,-4790.4033,-4787.364,-4776.755,-4767.118,-4755.173,-4749.722,-4742.5957,-4475.532,-4482.952,-4484.384,-4476.9053,-4476.4175,-4474.3867,-4473.079,-4468.0044};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_147()
		{
			double[] value = {-4473.476,-4477.582,-4476.953,-4474.9395,-4481.622,-4477.774,-4471.255,-4468.3667,-4466.5264,-4461.422,-4454.832,-4447.767,-4448.431,-4452.586,-4447.3794,-4448.408,-4449.6704,-4459.137,-4459.803,-4455.816,-4451.7676,-4456.816,-4458.8994,-4458.207,-4462.2925,-4460.849,-4458.438,-4462.88,-4464.276,-4467.914,-4472.323,-4471.0063,-4470.809,-4481.691,-4497.4043,-4503.0503,-4516.0923,-4522.8003,-4525.9497,-4536.3354,-4539.412,-4544.527,-4554.6494,-4553.221,-4556.933,-4558.4976,-4563.49,-4562.243,-4558.8267,-4558.003,-4562.196,-4550.8843,-4567.097,-4572.598,-4579.2847,-4584.0913,-4583.023,-4588.464,-4595.1753,-4596.459,-4596.353,-4589.0557,-4600.8857,-4612.0356,-4615.39,-4625.46,-4633.502,-4632.0977,-4657.9736,-4671.3477,-4673.941,-4680.2197,-4685.4155,-4688.0107,-4688.9263,-4687.01,-4677.461,-4672.955,-4676.342,-4683.394,-4690.3203,-4687.726,-4679.6143,-4687.2886,-4700.199,-4705.8115,-4710.5054,-4714.917,-4721.3623,-4725.7295,-4729.639,-4726.497,-4720.575,-4712.1055,-4708.9653,-4708.1895,-4709.3306,-4711.3604,-4709.314,-4704.9585};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_148()
		{
			double[] value = {-4701.903,-4697.7793,-4689.5903,-4680.5537,-4670.0566,-4663.701,-4656.011,-4648.8267,-4644.151,-4630.7896,-4623.81,-4616.2144,-4609.39,-4603.73,-4597.284,-4590.5684,-4583.3315,-4575.506,-4567.3,-4559.314,-4405.401,-4411.1343,-4421.202,-4434.018,-4449.0425,-4457.191,-4469.028,-4476.1226,-4487.177,-4500.691,-4500.4634,-4491.7925,-4494.6846,-4500.245,-4503.153,-4505.565,-4499.425,-4498.9473,-4492.8374,-4487.9185,-4487.931,-4482.344,-4488.0293,-4480.8306,-4470.25,-4492.9673,-4497.1143,-4488.184,-4480.719,-4480.656,-4469.655,-4465.449,-4465.223,-4458.5444,-4476.3887,-4493.363,-4498.623,-4507.5317,-4509.4634,-4509.976,-4508.9697,-4512.005,-4524.113,-4532.2563,-4537.6187,-4542.5596,-4548.6875,-4551.629,-4559.6353,-4559.559,-4558.8125,-4566.844,-4572.0396,-4572.2153,-4570.105,-4568.176,-4568.862,-4567.7656,-4565.6973,-4559.593,-4560.4023,-4561.351,-4578.0576,-4584.9985,-4589.9775,-4591.299,-4591.6284,-4591.7783,-4595.2036,-4596.922,-4597.215,-4595.606,-4597.7705,-4599.588,-4604.493,-4608.046,-4613.3447,-4618.6064,-4622.239,-4627.3726};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_149()
		{
			double[] value = {-4630.8774,-4634.584,-4636.2515,-4633.099,-4634.343,-4630.2754,-4624.7534,-4629.1836,-4635.423,-4634.3457,-4632.0947,-4628.8794,-4624.014,-4618.57,-4615.968,-4614.8306,-4599.634,-4587.028,-4572.0757,-4571.732,-4554.701,-4544.0327,-4537.6133,-4534.349,-4534.5513,-4532.9062,-4530.071,-4527.7236,-4524.97,-4520.5186,-4518.7905,-4516.098,-4515.736,-4515.437,-4506.544,-4493.3267,-4475.565,-4455.2847,-4442.9844,-4435.9883,-4428.949,-4423.1772,-4418.2227,-4414.8403,-4411.525,-4410.7236,-4406.3286,-4403.4194,-4200.418,-4207.9453,-4214.9146,-4221.5166,-4230.5234,-4242.088,-4251.3477,-4261.6904,-4274.4663,-4282.056,-4285.81,-4301.4746,-4330.524,-4357.301,-4375.3594,-4398.002,-4410.0063,-4427.1147,-4445.3364,-4455.9663,-4467.3896,-4477.9707,-4485.618,-4496.4565,-4511.305,-4522.6963,-4527.2173,-4526.9473,-4524.2314,-4515.04,-4500.0566,-4497.4077,-4498.091,-4493.0635,-4492.0127,-4496.6626,-4507.159,-4500.6377,-4488.778,-4498.5366,-4500.537,-4512.7856,-4524.335,-4530.398,-4534.9634,-4542.5723,-4547.4893,-4549.3145,-4553.516,-4559.2075,-4561.0493,-4562.7725};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_150()
		{
			double[] value = {-4564.1143,-4563.858,-4561.6577,-4557.9883,-4561.714,-4564.397,-4564.616,-4565.4556,-4564.3037,-4563.803,-4565.5537,-4569.651,-4572.9097,-4576.1113,-4579.356,-4579.1157,-4562.8687,-4545.5864,-4532.7285,-4526.9185,-4529.301,-4532.3906,-4535.26,-4537.7773,-4540.293,-4540.0747,-4539.0615,-4536.8213,-4533.961,-4529.656,-4525.1665,-4520.5645,-4515.7554,-4510.9336,-4504.5845,-4501.0513,-4495.0093,-4487.975,-4482.5923,-4476.4287,-4469.704,-4462.994,-4456.5273,-4448.5986,-4439.931,-4432.706,-4426.9185,-4421.154,-4420.0806,-4399.7964,-4388.291,-4388.819,-4387.567,-4384.0444,-4380.506,-4375.951,-4371.163,-4366.675,-4360.7837,-4354.727,-4349.062,-4342.5273,-4335.7163,-4330.405,-4320.337,-4313.16,-4308.0835,-4303.8066,-4299.35,-4295.648,-4291.3564,-4289.6475,-4287.1646,-4284.724,-4283.441,-4282.764,-3842.4216,-3874.1467,-3892.3696,-3898.8098,-3922.9734,-3941.1953,-3960.1736,-3975.3079,-3998.7395,-4014.769,-4028.5076,-4045.0427,-4060.7642,-4070.248,-4078.7568,-4090.342,-4098.906,-4117.9756,-4146.5713,-4177.251,-4207.794,-4238.5996,-4275.7017,-4315.2476};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_151()
		{
			double[] value = {-4359.218,-4400.775,-4440.8774,-4487.7524,-4530.349,-4560.5376,-4560.4644,-4552.3975,-4545.2676,-4534.8374,-4532.9346,-4532.3784,-4531.85,-4530.8906,-4526.103,-4519.9307,-4516.342,-4515.2563,-4519.278,-4522.6143,-4525.51,-4527.2173,-4529.6133,-4531.6333,-4535.828,-4545.71,-4554.318,-4558.9053,-4560.07,-4559.255,-4556.232,-4554.587,-4555.433,-4553.7544,-4552.5044,-4551.6895,-4545.3784,-4543.409,-4539.809,-4535.582,-4530.2544,-4526.542,-4523.984,-4521.2188,-4514.257,-4505.7773,-4495.8745,-4487.613,-4482.349,-4477.3164,-4473.252,-4468.216,-4463.364,-4459.2485,-4455.8047,-4451.3975,-4444.068,-4436.674,-4429.1353,-4421.8613,-4415.0845,-4408.89,-4403.462,-4397.7163,-4392.9385,-4387.4917,-4383.097,-4377.377,-4372.015,-4368.04,-4362.779,-4357.209,-4350.85,-4345.0967,-4339.76,-4334.347,-4328.255,-4323.407,-4317.321,-4312.627,-4306.9956,-4302.187,-4297.5654,-4292.6167,-4287.034,-4283.534,-4278.2397,-4272.263,-4268.214,-4262.071,-4256.814,-4251.1,-4245.183,-4239.745,-4233.4824,-4227.427,-4222.6343,-4217.261,-4212.329,-4211.043};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_152()
		{
			double[] value = {-4209.3394,-4208.4536,-4207.155,-4207.102,-3563.2444,-3592.3315,-3629.8716,-3655.636,-3668.1206,-3672.0747,-3676.7468,-3685.2695,-3694.374,-3713.0852,-3735.0935,-3753.2097,-3761.9224,-3785.6865,-3806.8179,-3821.1267,-3845.1367,-3870.195,-3894.7,-3912.7183,-3941.5872,-3970.11,-4016.5618,-4056.2683,-4073.2534,-4088.0237,-4124.593,-4162.959,-4170.245,-4171.1846,-4217.46,-4312.624,-4390.425,-4411.1807,-4449.5264,-4483.2427,-4507.2803,-4507.8643,-4502.707,-4499.009,-4500.6533,-4510.5454,-4510.494,-4508.5073,-4515.129,-4518.499,-4520.5796,-4518.414,-4520.6543,-4521.284,-4520.2163,-4519.99,-4519.5317,-4522.0645,-4527.028,-4533.505,-4542.3354,-4551.06,-4548.297,-4543.543,-4538.991,-4534.902,-4533.759,-4532.601,-4524.761,-4519.5015,-4515.2686,-4514.208,-4500.902,-4486.812,-4481.571,-4477.746,-4473.816,-4471.9316,-4468.647,-4461.73,-4456.1836,-4449.77,-4444.4917,-4440.8965,-4434.6733,-4427.458,-4419.3545,-4411.44,-4404.0947,-4397.297,-4390.9673,-4384.8374,-4378.256,-4372.453,-4365.7734,-4359.1304,-4353.791,-4348.561,-4343.43,-4338.001};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_153()
		{
			double[] value = {-4333.2075,-4328.237,-4324.5127,-4320.2964,-4315.989,-4311.9634,-4307.282,-4302.5986,-4297.7827,-4292.712,-4287.927,-4283.059,-4279.167,-4275.7505,-4271.757,-4266.9917,-4262.1333,-4258.5083,-4253.434,-4245.8125,-4239.2275,-4229.3,-4221.8945,-4214.5713,-4209.2607,-4203.646,-4199.3164,-4194.282,-4190.2876,-4186.954,-4184.7856,-4183.0195,-3364.4265,-3356.0127,-3352.7375,-3355.3564,-3361.8179,-3358.6926,-3366.6047,-3374.4915,-3383.386,-3392.502,-3400.1736,-3409.0288,-3420.4575,-3432.5845,-3446.5823,-3459.0862,-3474.357,-3492.3352,-3508.3953,-3524.7559,-3540.248,-3561.5635,-3589.9211,-3636.7542,-3698.271,-3763.7493,-3827.8154,-3874.194,-3888.864,-3920.5076,-3951.1152,-3968.9133,-4005.7034,-4046.0337,-4077.2012,-4103.418,-4129.286,-4143.192,-4143.298,-4142.681,-4161.108,-4213.984,-4257.48,-4310.767,-4361.202,-4402.997,-4453.8604,-4463.1694,-4444.6934,-4406.9185,-4385.0396,-4390.864,-4399.8267,-4405.6875,-4418.103,-4426.678,-4436.3105,-4442.944,-4440.2983,-4439.071,-4442.714,-4446.7603,-4453.7256,-4470.968,-4470.0776,-4472.843,-4475.396,-4466.444};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_154()
		{
			double[] value = {-4476.006,-4510.799,-4522.1406,-4523.265,-4498.551,-4475.5317,-4459.714,-4443.5137,-4434.371,-4426.874,-4421.171,-4416.064,-4411.2104,-4405.996,-4400.622,-4398.5513,-4395.931,-4390.7534,-4386.3633,-4383.1133,-4381.282,-4375.187,-4365.1436,-4355.0664,-4351.2354,-4349.846,-4352.6343,-4354.1626,-4363.77,-4378.752,-4385.0977,-4387.9795,-4388.0405,-4367.539,-4343.839,-4332.516,-4329.5977,-4325.2417,-4325.6865,-4323.2056,-4310.3257,-4288.9917,-4264.166,-4251.369,-4239.6445,-4231.688,-4222.5737,-4207.694,-4194.793,-4184.4126,-4178.392,-4174.087,-4171.443,-4168.135,-4166.0215,-4163.602,-4161.908,-4159.152,-4158.5474,-4156.184,-3171.963,-3174.0781,-3172.181,-3168.047,-3166.447,-3165.9473,-3169.573,-3182.5496,-3205.0276,-3234.7935,-3258.7395,-3276.968,-3294.1428,-3316.282,-3327.8318,-3338.4878,-3345.9038,-3360.8423,-3384.547,-3448.513,-3525.585,-3582.5273,-3584.309,-3553.5474,-3541.621,-3480.7656,-3434.6072,-3433.4126,-3484.9033,-3552.2334,-3619.283,-3671.6057,-3694.4092,-3682.593,-3663.3757,-3660.4187,-3676.8413,-3704.0469,-3753.898,-3814.986};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_155()
		{
			double[] value = {-3860.4602,-3890.7358,-3910.443,-3925.2751,-3932.4011,-3923.159,-3916.0789,-3951.652,-3987.4941,-3996.3274,-3983.372,-3977.262,-4018.0732,-4092.6768,-4155.206,-4149.612,-4117.5986,-4087.4683,-4083.3064,-4119.5605,-4159.8584,-4193.7554,-4218.7563,-4259.4834,-4293.7935,-4330.9663,-4355.6094,-4391.3604,-4423.717,-4447.2,-4444.0234,-4471.179,-4530.0103,-4563.6826,-4524.601,-4498.0083,-4509.0835,-4471.1724,-4385.516,-4363.4243,-4355.952,-4355.058,-4354.893,-4355.126,-4350.7314,-4342.4634,-4330.7188,-4321.0537,-4320.2637,-4320.404,-4319.393,-4331.1313,-4357.4873,-4396.2036,-4478.0234,-4516.215,-4496.1807,-4443.579,-4384.482,-4307.3726,-4250.42,-4228.0913,-4221.7246,-4222.8516,-4224.579,-4227.2695,-4228.957,-4230.2896,-4228.996,-4225.5586,-4220.191,-4215.2314,-4209.2656,-4204.576,-4200.988,-4197.3325,-4195.6187,-4194.108,-4192.5996,-4190.876,-4190.876,-4191.8467,-4192.581,-4191.4927,-4188.7354,-4184.9937,-4183.2,-4181.198,-3049.1736,-3054.73,-3063.3572,-3054.8352,-3056.2483,-3053.981,-3054.8188,-3062.037,-3066.1597,-3079.5557,-3098.3364,-3108.2827};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_156()
		{
			double[] value = {-3110.8918,-3116.179,-3126.7603,-3125.0054,-3138.035,-3149.2854,-3153.8647,-3150.3013,-3150.212,-3112.9243,-3150.507,-3205.3872,-3235.7969,-3279.0286,-3324.325,-3365.0315,-3397.01,-3421.9834,-3449.665,-3471.5037,-3497.8718,-3545.6567,-3580.3635,-3615.265,-3650.6528,-3676.5193,-3609.5212,-3515.2693,-3461.0464,-3449.1765,-3465.813,-3484.3838,-3491.6855,-3495.555,-3485.7156,-3490.3186,-3561.036,-3640.1682,-3676.5737,-3698.4167,-3708.639,-3697.7805,-3664.073,-3734.0024,-3802.789,-3835.7603,-3850.4392,-3842.141,-3810.9626,-3774.0105,-3754.3054,-3744.087,-3764.0864,-3777.548,-3798.9873,-3802.5598,-3808.048,-3820.4294,-3842.0396,-3856.608,-3864.6501,-3896.7554,-3922.4365,-3930.7485,-3944.0962,-3984.3096,-4021.5151,-4057.4255,-4085.5527,-4117.6543,-4130.0015,-4137.8755,-4157.026,-4198.101,-4203.9736,-4189.5635,-4213.0254,-4258.6836,-4294.0986,-4312.087,-4284.447,-4230.419,-4190.1035,-4183.743,-4166.3687,-4133.684,-4103.645,-4097.9136,-4095.7908,-4085.752,-4069.466,-4053.181,-4056.1367,-4061.7812,-4065.0513,-4066.0266,-4066.1719,-4069.8176,-4111.0996,-4124.9595};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_157()
		{
			double[] value = {-4173.425,-4189.756,-4227.2207,-4270.228,-4266.7,-4239.4146,-4197.4995,-4146.849,-4096.243,-4097.1826,-4145.4253,-4177.6016,-4175.0483,-4169.067,-4190.512,-4210.3823,-2953.523,-2934.2627,-2921.451,-2920.2998,-2927.4973,-2939.6567,-2954.6511,-2979.634,-3007.7273,-3033.0776,-3051.7192,-3066.909,-3067.0176,-3064.5645,-3063.9214,-3061.7158,-3053.3535,-3044.2576,-3030.7021,-3015.5088,-2993.8254,-2972.5076,-2937.2646,-2919.8843,-2928.1711,-2950.524,-2988.1897,-3033.8513,-3066.3984,-3097.3838,-3120.1123,-3141.0352,-3160.8162,-3187.7305,-3200.363,-3200.43,-3185.5896,-3171.4875,-3148.5344,-3129.2512,-3125.8296,-3150.4397,-3176.5037,-3177.201,-3169.892,-3158.7104,-3146.528,-3138.0933,-3167.9521,-3186.7878,-3160.8728,-3157.8665,-3186.1655,-3235.1262,-3279.2117,-3329.435,-3375.6733,-3405.8289,-3424.6392,-3418.1328,-3412.814,-3405.4473,-3408.6724,-3412.0344,-3415.8171,-3418.6812,-3423.1155,-3423.797,-3426.3408,-3425.624,-3427.7366,-3427.281,-3411.9995,-3386.6636,-3364.1384,-3352.9834,-3361.7295,-3397.2178,-3427.846,-3448.006,-3464.8662,-3480.0898,-3488.0464,-3513.5671};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_158()
		{
			double[] value = {-3593.5527,-3700.339,-3761.77,-3725.4812,-3658.1372,-3615.7832,-3606.738,-3591.894,-3552.4717,-3517.7627,-3509.664,-3526.77,-3526.7112,-3518.952,-3512.4597,-3516.6582,-3520.8064,-3519.0967,-3513.8635,-3514.6943,-3533.5703,-3560.5332,-3592.7114,-3645.184,-3663.557,-3667.8684,-3702.7424,-3719.2573,-3762.3533,-3791.8206,-3826.7341,-3844.6638,-3755.659,-3602.3474,-3522.2424,-3540.9485,-3586.1885,-3626.287,-3725.1772,-3834.7666,-3929.568,-4080.2673,-4194.46,-4281.954,-2833.9326,-2858.101,-2884.6736,-2905.3142,-2920.121,-2938.1516,-2950.0623,-2957.094,-2938.8413,-2882.8083,-2812.4514,-2761.7607,-2738.7039,-2731.3896,-2726.6558,-2724.1396,-2723.1204,-2723.148,-2725.109,-2728.6755,-2732.3364,-2735.8618,-2741.4026,-2748.032,-2756.75,-2768.7915,-2783.1936,-2797.8616,-2823.0186,-2840.0776,-2849.3794,-2848.4578,-2846.78,-2853.971,-2860.323,-2867.9197,-2886.0479,-2896.14,-2905.3271,-2920.2004,-2940.4846,-2940.1877,-2912.893,-2887.5693,-2875.6067,-2868.771,-2872.2856,-2880.7935,-2888.1135,-2889.231,-2882.8613,-2868.649,-2845.466,-2802.1238,-2785.6614,-2815.8054};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_159()
		{
			double[] value = {-2860.6729,-2893.764,-2921.5657,-2947.077,-2963.4556,-2978.8984,-2988.0222,-2991.9502,-2996.45,-3006.8552,-3008.1218,-3012.3005,-3013.2104,-3014.9185,-3015.9133,-3020.4973,-3032.8337,-3041.0046,-3051.391,-3043.5244,-3036.0876,-3022.3628,-3006.779,-2992.7192,-2984.1462,-2984.4368,-2988.6184,-2994.893,-3006.1824,-3018.9158,-3040.7537,-3075.1846,-3099.1504,-3105.708,-3086.5852,-3061.6917,-3028.468,-2992.8137,-2988.2075,-3010.1746,-3063.7617,-3103.6362,-3135.3235,-3155.2908,-3167.7693,-3176.8618,-3181.9985,-3204.2979,-3229.821,-3244.1562,-3238.8596,-3231.5854,-3218.5159,-3211.2388,-3212.0127,-3230.2627,-3240.8696,-3252.4666,-3266.543,-3283.5647,-3296.9873,-3321.5024,-3348.602,-3369.0657,-3397.2625,-3397.2676,-3375.878,-3325.476,-3265.6626,-3197.241,-3147.0742,-3105.311,-2504.0027,-2501.9995,-2504.1296,-2490.082,-2475.372,-2471.83,-2477.5862,-2487.472,-2507.3691,-2536.812,-2553.4705,-2551.6152,-2548.037,-2546.6204,-2562.4587,-2583.9194,-2585.9868,-2572.3757,-2564.005,-2586.421,-2609.3726,-2593.1877,-2538.915,-2519.6616,-2511.1204,-2513.3894,-2514.9954,-2520.6086};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_160()
		{
			double[] value = {-2546.3052,-2529.4597,-2543.404,-2553.1672,-2560.0786,-2565.3833,-2571.2754,-2582.0085,-2598.235,-2607.045,-2599.3564,-2588.0637,-2580.7334,-2571.657,-2563.3958,-2560.457,-2559.5256,-2556.3235,-2553.277,-2552.8235,-2577.337,-2552.132,-2533.9995,-2572.2952,-2598.5193,-2575.7375,-2517.7583,-2504.4858,-2511.291,-2527.6301,-2543.6816,-2573.6584,-2589.8428,-2590.6245,-2615.517,-2633.6384,-2606.108,-2652.5945,-2736.065,-2699.1663,-2774.9954,-2803.6719,-2867.5898,-2958.3643,-2932.4612,-2885.449,-2872.3193,-2881.7288,-2885.6814,-2834.46,-2800.6455,-2890.3665,-2904.3022,-2918.276,-2931.1152,-2938.1072,-2912.0195,-2819.6309,-2915.4663,-2927.7292,-2930.934,-2937.714,-2945.971,-2952.0474,-2839.0916,-2811.2734,-2817.489,-2794.5378,-2781.972,-2770.476,-2765.1633,-2754.8052,-2740.4397,-2736.0876,-2742.0657,-2783.9536,-2814.1309,-2807.8662,-2810.276,-2812.8755,-2827.8892,-2854.8857,-2856.2332,-2848.5,-2844.4026,-2859.6167,-2890.4739,-2919.5364,-2937.7922,-2951.6174,-2948.784,-2870.8713,-2780.1824,-2780.3748,-2819.6646,-2832.425,-2820.6555,-2819.1125,-2816.1558,-2812.6538};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_161()
		{
			double[] value = {-2276.8281,-2267.831,-2254.6912,-2241.6538,-2225.523,-2209.3699,-2203.4875,-2221.8276,-2293.0972,-2384.6606,-2409.1267,-2367.5923,-2319.3606,-2323.2244,-2380.6692,-2398.5735,-2366.5361,-2305.4346,-2349.383,-2464.402,-2492.707,-2310.7961,-2198.0042,-2190.351,-2188.034,-2202.5388,-2196.4084,-2198.1565,-2218.2974,-2240.9802,-2273.4045,-2296.526,-2314.2202,-2334.2437,-2348.6074,-2365.2917,-2420.0789,-2449.4849,-2371.857,-2304.8547,-2284.4531,-2284.512,-2290.0461,-2300.0195,-2314.4797,-2323.0134,-2319.179,-2324.8982,-2372.0295,-2413.6902,-2353.9001,-2352.472,-2379.6316,-2378.7385,-2348.1423,-2346.297,-2351.8293,-2359.8245,-2368.5547,-2372.2637,-2370.1443,-2370.261,-2373.1335,-2368.62,-2345.2852,-2367.188,-2419.1404,-2450.6316,-2498.7332,-2551.6262,-2663.4465,-2750.2485,-2652.8887,-2544.935,-2504.356,-2503.5298,-2508.1353,-2441.2034,-2380.5708,-2533.867,-2501.022,-2549.691,-2523.7725,-2468.111,-2526.9207,-2408.6213,-2476.3276,-2508.0632,-2501.3552,-2501.3735,-2518.8687,-2551.6929,-2605.302,-2547.1929,-2592.8723,-2559.368,-2549.2957,-2558.4546,-2547.7268,-2547.0913};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_162()
		{
			double[] value = {-2555.6624,-2557.587,-2571.4275,-2586.0212,-2620.9146,-2630.9407,-2604.7625,-2591.8667,-2666.4138,-2733.583,-2703.3596,-2593.8386,-2538.681,-2530.191,-2547.1023,-2563.0127,-2565.691,-2564.9658,-2548.11,-2481.4949,-2406.9841,-2415.0178,-2578.0925,-2561.0764,-2512.7456,-2515.3787,-2526.2278,-2537.6472,-2087.5962,-2084.188,-2082.9998,-2084.3853,-2086.8892,-2087.2344,-2090.413,-2088.4019,-2071.0647,-2055.8674,-2072.8042,-2050.697,-2045.7853,-2065.189,-2084.0796,-2086.8284,-2081.0364,-2073.9092,-2085.8406,-2108.7693,-2112.298,-2075.1904,-2058.176,-2049.2822,-2034.5159,-2051.8438,-2053.302,-2052.6401,-2057.8208,-2084.7893,-2058.52,-2065.06,-2064.0728,-2071.6187,-2074.4094,-2074.0881,-2092.2615,-2103.6113,-2075.4585,-2055.8604,-2052.4478,-2056.1401,-2060.3813,-2067.223,-2077.1113,-2083.458,-2088.7722,-2098.1462,-2107.27,-2111.5989,-2116.6106,-2126.0603,-2136.0718,-2154.0037,-2159.1714,-2162.2788,-2169.8196,-2178.0193,-2185.4,-2187.9373,-2193.4282,-2198.9717,-2205.8975,-2209.7532,-2211.0493,-2216.1924,-2231.6797,-2222.4314,-2225.003,-2247.3582,-2276.8813,-2300.535};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_163()
		{
			double[] value = {-2259.9895,-2214.4634,-2193.7793,-2182.9402,-2179.8928,-2176.1575,-2177.5845,-2199.7754,-2185.4,-2188.353,-2188.1975,-2192.477,-2194.7336,-2192.5913,-2198.5022,-2202.5217,-2208.116,-2212.4697,-2217.3345,-2242.9392,-2228.7617,-2258.872,-2311.9749,-2261.7627,-2298.5981,-2311.6672,-2309.2659,-2309.0347,-2312.1658,-2313.5022,-2320.8848,-2329.733,-2364.8462,-2397.1826,-2374.6226,-2300.5713,-2276.3962,-2268.9392,-2265.5457,-2275.381,-2275.9238,-2280.1626,-2283.2195,-2289.2415,-2297.1455,-2304.7185,-2311.7756,-2314.6965,-2312.9517,-2320.953,-2358.7754,-2354.637,-2348.8503,-2352.759,-2360.3843,-2369.1477,-2000.7144,-1997.6488,-1994.4727,-1990.9253,-1990.3201,-1988.3297,-1990.3422,-1987.3076,-1974.7212,-1970.554,-1968.8462,-1968.4729,-1967.4012,-1965.2104,-1963.9401,-1963.9305,-1962.4496,-1962.069,-1960.7986,-1960.8668,-1960.2397,-1959.8418,-1958.8907,-1959.3867,-1959.4199,-1959.9044,-1958.0636,-1956.2924,-1957.234,-1956.2281,-1957.1517,-1955.9178,-1956.3563,-1953.1873,-1954.306,-1956.0433,-1959.1648,-1962.579,-1965.2634,-1968.8674,-1970.7186,-1973.9893,-1977.0143,-1979.282};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_164()
		{
			double[] value = {-1982.198,-1983.7185,-1989.5096,-1993.172,-1994.5876,-1993.8004,-1988.6047,-1989.1443,-1989.123,-2005.9503,-2010.5164,-2000.365,-1993.0,-1997.8901,-2001.633,-1999.2081,-2005.788,-2009.3496,-2004.7355,-2008.6022,-2006.2964,-2006.2726,-2005.7129,-2007.3763,-2014.358,-2015.0801,-2023.1721,-2032.957,-2030.2589,-2028.4165,-2024.9924,-2017.6388,-2013.2467,-2006.0575,-2002.4114,-2007.6337,-2005.6969,-2002.6212,-2005.6451,-2013.3635,-2022.5258,-2040.9937,-2052.2415,-2051.723,-2048.0024,-2051.6138,-2052.7302,-2059.5706,-2045.6909,-2034.5189,-2046.1313,-2039.743,-2036.468,-2034.9026,-2035.3158,-2036.2706,-2039.5522,-2043.6196,-2047.6984,-2053.325,-2053.7793,-2060.4702,-2065.0454,-2069.2551,-2067.5222,-2070.055,-2067.721,-2066.9734,-2066.72,-2066.7441,-2068.7107,-2072.6465,-2097.2722,-2121.9026,-2131.9219,-2145.1663,-2148.6345,-2151.476,-2153.5583,-2156.286,-2156.2214,-2160.3018,-2164.2979,-2168.4785};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.00787,0.00391,0.01575,0.00391,0.02362,0.00391,0.0315,0.00391,0.03937,0.00391,0.04724,0.00391,0.05512,0.00391,0.06299,0.00391,0.07087,0.00391,0.07874,0.00391,0.08661,0.00391,0.09449,0.00391,0.10236,0.00391,0.11024,0.00391,0.11811,0.00391,0.12598,0.00391,0.13386,0.00391,0.14173,0.00391,0.14961,0.00391,0.15748,0.00391,0.16535,0.00391,0.17323,0.00391,0.1811,0.00391,0.18898,0.00391,0.19685,0.00391,0.20472,0.00391,0.2126,0.00391,0.22047,0.00391,0.22835,0.00391,0.23622,0.00391,0.24409,0.00391,0.25197,0.00391,0.25984,0.00391,0.26772,0.00391,0.27559,0.00391,0.28346,0.00391,0.29134,0.00391,0.29921,0.00391,0.30709,0.00391,0.31496,0.00391,0.32283,0.00391,0.33071,0.00391,0.33858,0.00391,0.34646,0.00391,0.35433,0.00391,0.3622,0.00391,0.37008,0.00391,0.37795,0.00391,0.38583,0.00391,0.3937,0.00391,0.40157,0.00391,0.40945,0.00391,0.41732,0.00391,0.4252,0.00391,0.43307,0.00391,0.44094,0.00391,0.44882,0.00391,0.45669,0.00391,0.46457,0.00391,0.47244,0.00391,0.48031,0.00391,0.48819,0.00391,0.49606,0.00391,0.50394,0.00391,0.51181,0.00391,0.51969,0.00391,0.52756,0.00391,0.53543,0.00391,0.54331,0.00391,0.55118,0.00391,0.55906,0.00391,0.56693,0.00391,0.5748,0.00391,0.58268,0.00391,0.59055,0.00391,0.59843,0.00391,0.6063,0.00391,0.61417,0.00391,0.62205,0.00391,0.62992,0.00391,0.6378,0.00391,0.64567,0.00391,0.65354,0.00391,0.66142,0.00391,0.66929,0.00391,0.67717,0.00391,0.68504,0.00391,0.69291,0.00391,0.70079,0.00391,0.70866,0.00391,0.71654,0.00391,0.72441,0.00391,0.73228,0.00391,0.74016,0.00391,0.74803,0.00391,0.75591,0.00391,0.76378,0.00391,0.77165,0.00391,0.77953,0.00391};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.7874,0.00391,0.79528,0.00391,0.80315,0.00391,0.81102,0.00391,0.8189,0.00391,0.82677,0.00391,0.83465,0.00391,0.84252,0.00391,0.85039,0.00391,0.85827,0.00391,0.86614,0.00391,0.87402,0.00391,0.88189,0.00391,0.88976,0.00391,0.89764,0.00391,0.90551,0.00391,0.91339,0.00391,0.92126,0.00391,0.92913,0.00391,0.93701,0.00391,0.94488,0.00391,0.95276,0.00391,0.96063,0.00391,0.9685,0.00391,0.97638,0.00391,0.98425,0.00391,0.99213,0.00391,0.99609,0.00391,0.00391,0.00787,0.00787,0.00787,0.01575,0.00787,0.02362,0.00787,0.0315,0.00787,0.03937,0.00787,0.04724,0.00787,0.05512,0.00787,0.06299,0.00787,0.07087,0.00787,0.07874,0.00787,0.08661,0.00787,0.09449,0.00787,0.10236,0.00787,0.11024,0.00787,0.11811,0.00787,0.12598,0.00787,0.13386,0.00787,0.14173,0.00787,0.14961,0.00787,0.15748,0.00787,0.16535,0.00787,0.17323,0.00787,0.1811,0.00787,0.18898,0.00787,0.19685,0.00787,0.20472,0.00787,0.2126,0.00787,0.22047,0.00787,0.22835,0.00787,0.23622,0.00787,0.24409,0.00787,0.25197,0.00787,0.25984,0.00787,0.26772,0.00787,0.27559,0.00787,0.28346,0.00787,0.29134,0.00787,0.29921,0.00787,0.30709,0.00787,0.31496,0.00787,0.32283,0.00787,0.33071,0.00787,0.33858,0.00787,0.34646,0.00787,0.35433,0.00787,0.3622,0.00787,0.37008,0.00787,0.37795,0.00787,0.38583,0.00787,0.3937,0.00787,0.40157,0.00787,0.40945,0.00787,0.41732,0.00787,0.4252,0.00787,0.43307,0.00787,0.44094,0.00787,0.44882,0.00787,0.45669,0.00787,0.46457,0.00787,0.47244,0.00787,0.48031,0.00787,0.48819,0.00787,0.49606,0.00787,0.50394,0.00787,0.51181,0.00787,0.51969,0.00787,0.52756,0.00787,0.53543,0.00787,0.54331,0.00787,0.55118,0.00787,0.55906,0.00787};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.56693,0.00787,0.5748,0.00787,0.58268,0.00787,0.59055,0.00787,0.59843,0.00787,0.6063,0.00787,0.61417,0.00787,0.62205,0.00787,0.62992,0.00787,0.6378,0.00787,0.64567,0.00787,0.65354,0.00787,0.66142,0.00787,0.66929,0.00787,0.67717,0.00787,0.68504,0.00787,0.69291,0.00787,0.70079,0.00787,0.70866,0.00787,0.71654,0.00787,0.72441,0.00787,0.73228,0.00787,0.74016,0.00787,0.74803,0.00787,0.75591,0.00787,0.76378,0.00787,0.77165,0.00787,0.77953,0.00787,0.7874,0.00787,0.79528,0.00787,0.80315,0.00787,0.81102,0.00787,0.8189,0.00787,0.82677,0.00787,0.83465,0.00787,0.84252,0.00787,0.85039,0.00787,0.85827,0.00787,0.86614,0.00787,0.87402,0.00787,0.88189,0.00787,0.88976,0.00787,0.89764,0.00787,0.90551,0.00787,0.91339,0.00787,0.92126,0.00787,0.92913,0.00787,0.93701,0.00787,0.94488,0.00787,0.95276,0.00787,0.96063,0.00787,0.9685,0.00787,0.97638,0.00787,0.98425,0.00787,0.99213,0.00787,0.99609,0.00787,0.00391,0.01575,0.00787,0.01575,0.01575,0.01575,0.02362,0.01575,0.0315,0.01575,0.03937,0.01575,0.04724,0.01575,0.05512,0.01575,0.06299,0.01575,0.07087,0.01575,0.07874,0.01575,0.08661,0.01575,0.09449,0.01575,0.10236,0.01575,0.11024,0.01575,0.11811,0.01575,0.12598,0.01575,0.13386,0.01575,0.14173,0.01575,0.14961,0.01575,0.15748,0.01575,0.16535,0.01575,0.17323,0.01575,0.1811,0.01575,0.18898,0.01575,0.19685,0.01575,0.20472,0.01575,0.2126,0.01575,0.22047,0.01575,0.22835,0.01575,0.23622,0.01575,0.24409,0.01575,0.25197,0.01575,0.25984,0.01575,0.26772,0.01575,0.27559,0.01575,0.28346,0.01575,0.29134,0.01575,0.29921,0.01575,0.30709,0.01575,0.31496,0.01575,0.32283,0.01575,0.33071,0.01575,0.33858,0.01575};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.34646,0.01575,0.35433,0.01575,0.3622,0.01575,0.37008,0.01575,0.37795,0.01575,0.38583,0.01575,0.3937,0.01575,0.40157,0.01575,0.40945,0.01575,0.41732,0.01575,0.4252,0.01575,0.43307,0.01575,0.44094,0.01575,0.44882,0.01575,0.45669,0.01575,0.46457,0.01575,0.47244,0.01575,0.48031,0.01575,0.48819,0.01575,0.49606,0.01575,0.50394,0.01575,0.51181,0.01575,0.51969,0.01575,0.52756,0.01575,0.53543,0.01575,0.54331,0.01575,0.55118,0.01575,0.55906,0.01575,0.56693,0.01575,0.5748,0.01575,0.58268,0.01575,0.59055,0.01575,0.59843,0.01575,0.6063,0.01575,0.61417,0.01575,0.62205,0.01575,0.62992,0.01575,0.6378,0.01575,0.64567,0.01575,0.65354,0.01575,0.66142,0.01575,0.66929,0.01575,0.67717,0.01575,0.68504,0.01575,0.69291,0.01575,0.70079,0.01575,0.70866,0.01575,0.71654,0.01575,0.72441,0.01575,0.73228,0.01575,0.74016,0.01575,0.74803,0.01575,0.75591,0.01575,0.76378,0.01575,0.77165,0.01575,0.77953,0.01575,0.7874,0.01575,0.79528,0.01575,0.80315,0.01575,0.81102,0.01575,0.8189,0.01575,0.82677,0.01575,0.83465,0.01575,0.84252,0.01575,0.85039,0.01575,0.85827,0.01575,0.86614,0.01575,0.87402,0.01575,0.88189,0.01575,0.88976,0.01575,0.89764,0.01575,0.90551,0.01575,0.91339,0.01575,0.92126,0.01575,0.92913,0.01575,0.93701,0.01575,0.94488,0.01575,0.95276,0.01575,0.96063,0.01575,0.9685,0.01575,0.97638,0.01575,0.98425,0.01575,0.99213,0.01575,0.99609,0.01575,0.00391,0.02362,0.00787,0.02362,0.01575,0.02362,0.02362,0.02362,0.0315,0.02362,0.03937,0.02362,0.04724,0.02362,0.05512,0.02362,0.06299,0.02362,0.07087,0.02362,0.07874,0.02362,0.08661,0.02362,0.09449,0.02362,0.10236,0.02362,0.11024,0.02362,0.11811,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.12598,0.02362,0.13386,0.02362,0.14173,0.02362,0.14961,0.02362,0.15748,0.02362,0.16535,0.02362,0.17323,0.02362,0.1811,0.02362,0.18898,0.02362,0.19685,0.02362,0.20472,0.02362,0.2126,0.02362,0.22047,0.02362,0.22835,0.02362,0.23622,0.02362,0.24409,0.02362,0.25197,0.02362,0.25984,0.02362,0.26772,0.02362,0.27559,0.02362,0.28346,0.02362,0.29134,0.02362,0.29921,0.02362,0.30709,0.02362,0.31496,0.02362,0.32283,0.02362,0.33071,0.02362,0.33858,0.02362,0.34646,0.02362,0.35433,0.02362,0.3622,0.02362,0.37008,0.02362,0.37795,0.02362,0.38583,0.02362,0.3937,0.02362,0.40157,0.02362,0.40945,0.02362,0.41732,0.02362,0.4252,0.02362,0.43307,0.02362,0.44094,0.02362,0.44882,0.02362,0.45669,0.02362,0.46457,0.02362,0.47244,0.02362,0.48031,0.02362,0.48819,0.02362,0.49606,0.02362,0.50394,0.02362,0.51181,0.02362,0.51969,0.02362,0.52756,0.02362,0.53543,0.02362,0.54331,0.02362,0.55118,0.02362,0.55906,0.02362,0.56693,0.02362,0.5748,0.02362,0.58268,0.02362,0.59055,0.02362,0.59843,0.02362,0.6063,0.02362,0.61417,0.02362,0.62205,0.02362,0.62992,0.02362,0.6378,0.02362,0.64567,0.02362,0.65354,0.02362,0.66142,0.02362,0.66929,0.02362,0.67717,0.02362,0.68504,0.02362,0.69291,0.02362,0.70079,0.02362,0.70866,0.02362,0.71654,0.02362,0.72441,0.02362,0.73228,0.02362,0.74016,0.02362,0.74803,0.02362,0.75591,0.02362,0.76378,0.02362,0.77165,0.02362,0.77953,0.02362,0.7874,0.02362,0.79528,0.02362,0.80315,0.02362,0.81102,0.02362,0.8189,0.02362,0.82677,0.02362,0.83465,0.02362,0.84252,0.02362,0.85039,0.02362,0.85827,0.02362,0.86614,0.02362,0.87402,0.02362,0.88189,0.02362,0.88976,0.02362,0.89764,0.02362,0.90551,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.91339,0.02362,0.92126,0.02362,0.92913,0.02362,0.93701,0.02362,0.94488,0.02362,0.95276,0.02362,0.96063,0.02362,0.9685,0.02362,0.97638,0.02362,0.98425,0.02362,0.99213,0.02362,0.99609,0.02362,0.00391,0.0315,0.00787,0.0315,0.01575,0.0315,0.02362,0.0315,0.0315,0.0315,0.03937,0.0315,0.04724,0.0315,0.05512,0.0315,0.06299,0.0315,0.07087,0.0315,0.07874,0.0315,0.08661,0.0315,0.09449,0.0315,0.10236,0.0315,0.11024,0.0315,0.11811,0.0315,0.12598,0.0315,0.13386,0.0315,0.14173,0.0315,0.14961,0.0315,0.15748,0.0315,0.16535,0.0315,0.17323,0.0315,0.1811,0.0315,0.18898,0.0315,0.19685,0.0315,0.20472,0.0315,0.2126,0.0315,0.22047,0.0315,0.22835,0.0315,0.23622,0.0315,0.24409,0.0315,0.25197,0.0315,0.25984,0.0315,0.26772,0.0315,0.27559,0.0315,0.28346,0.0315,0.29134,0.0315,0.29921,0.0315,0.30709,0.0315,0.31496,0.0315,0.32283,0.0315,0.33071,0.0315,0.33858,0.0315,0.34646,0.0315,0.35433,0.0315,0.3622,0.0315,0.37008,0.0315,0.37795,0.0315,0.38583,0.0315,0.3937,0.0315,0.40157,0.0315,0.40945,0.0315,0.41732,0.0315,0.4252,0.0315,0.43307,0.0315,0.44094,0.0315,0.44882,0.0315,0.45669,0.0315,0.46457,0.0315,0.47244,0.0315,0.48031,0.0315,0.48819,0.0315,0.49606,0.0315,0.50394,0.0315,0.51181,0.0315,0.51969,0.0315,0.52756,0.0315,0.53543,0.0315,0.54331,0.0315,0.55118,0.0315,0.55906,0.0315,0.56693,0.0315,0.5748,0.0315,0.58268,0.0315,0.59055,0.0315,0.59843,0.0315,0.6063,0.0315,0.61417,0.0315,0.62205,0.0315,0.62992,0.0315,0.6378,0.0315,0.64567,0.0315,0.65354,0.0315,0.66142,0.0315,0.66929,0.0315,0.67717,0.0315,0.68504,0.0315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.69291,0.0315,0.70079,0.0315,0.70866,0.0315,0.71654,0.0315,0.72441,0.0315,0.73228,0.0315,0.74016,0.0315,0.74803,0.0315,0.75591,0.0315,0.76378,0.0315,0.77165,0.0315,0.77953,0.0315,0.7874,0.0315,0.79528,0.0315,0.80315,0.0315,0.81102,0.0315,0.8189,0.0315,0.82677,0.0315,0.83465,0.0315,0.84252,0.0315,0.85039,0.0315,0.85827,0.0315,0.86614,0.0315,0.87402,0.0315,0.88189,0.0315,0.88976,0.0315,0.89764,0.0315,0.90551,0.0315,0.91339,0.0315,0.92126,0.0315,0.92913,0.0315,0.93701,0.0315,0.94488,0.0315,0.95276,0.0315,0.96063,0.0315,0.9685,0.0315,0.97638,0.0315,0.98425,0.0315,0.99213,0.0315,0.99609,0.0315,0.00391,0.03937,0.00787,0.03937,0.01575,0.03937,0.02362,0.03937,0.0315,0.03937,0.03937,0.03937,0.04724,0.03937,0.05512,0.03937,0.06299,0.03937,0.07087,0.03937,0.07874,0.03937,0.08661,0.03937,0.09449,0.03937,0.10236,0.03937,0.11024,0.03937,0.11811,0.03937,0.12598,0.03937,0.13386,0.03937,0.14173,0.03937,0.14961,0.03937,0.15748,0.03937,0.16535,0.03937,0.17323,0.03937,0.1811,0.03937,0.18898,0.03937,0.19685,0.03937,0.20472,0.03937,0.2126,0.03937,0.22047,0.03937,0.22835,0.03937,0.23622,0.03937,0.24409,0.03937,0.25197,0.03937,0.25984,0.03937,0.26772,0.03937,0.27559,0.03937,0.28346,0.03937,0.29134,0.03937,0.29921,0.03937,0.30709,0.03937,0.31496,0.03937,0.32283,0.03937,0.33071,0.03937,0.33858,0.03937,0.34646,0.03937,0.35433,0.03937,0.3622,0.03937,0.37008,0.03937,0.37795,0.03937,0.38583,0.03937,0.3937,0.03937,0.40157,0.03937,0.40945,0.03937,0.41732,0.03937,0.4252,0.03937,0.43307,0.03937,0.44094,0.03937,0.44882,0.03937,0.45669,0.03937,0.46457,0.03937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.47244,0.03937,0.48031,0.03937,0.48819,0.03937,0.49606,0.03937,0.50394,0.03937,0.51181,0.03937,0.51969,0.03937,0.52756,0.03937,0.53543,0.03937,0.54331,0.03937,0.55118,0.03937,0.55906,0.03937,0.56693,0.03937,0.5748,0.03937,0.58268,0.03937,0.59055,0.03937,0.59843,0.03937,0.6063,0.03937,0.61417,0.03937,0.62205,0.03937,0.62992,0.03937,0.6378,0.03937,0.64567,0.03937,0.65354,0.03937,0.66142,0.03937,0.66929,0.03937,0.67717,0.03937,0.68504,0.03937,0.69291,0.03937,0.70079,0.03937,0.70866,0.03937,0.71654,0.03937,0.72441,0.03937,0.73228,0.03937,0.74016,0.03937,0.74803,0.03937,0.75591,0.03937,0.76378,0.03937,0.77165,0.03937,0.77953,0.03937,0.7874,0.03937,0.79528,0.03937,0.80315,0.03937,0.81102,0.03937,0.8189,0.03937,0.82677,0.03937,0.83465,0.03937,0.84252,0.03937,0.85039,0.03937,0.85827,0.03937,0.86614,0.03937,0.87402,0.03937,0.88189,0.03937,0.88976,0.03937,0.89764,0.03937,0.90551,0.03937,0.91339,0.03937,0.92126,0.03937,0.92913,0.03937,0.93701,0.03937,0.94488,0.03937,0.95276,0.03937,0.96063,0.03937,0.9685,0.03937,0.97638,0.03937,0.98425,0.03937,0.99213,0.03937,0.99609,0.03937,0.00391,0.04724,0.00787,0.04724,0.01575,0.04724,0.02362,0.04724,0.0315,0.04724,0.03937,0.04724,0.04724,0.04724,0.05512,0.04724,0.06299,0.04724,0.07087,0.04724,0.07874,0.04724,0.08661,0.04724,0.09449,0.04724,0.10236,0.04724,0.11024,0.04724,0.11811,0.04724,0.12598,0.04724,0.13386,0.04724,0.14173,0.04724,0.14961,0.04724,0.15748,0.04724,0.16535,0.04724,0.17323,0.04724,0.1811,0.04724,0.18898,0.04724,0.19685,0.04724,0.20472,0.04724,0.2126,0.04724,0.22047,0.04724,0.22835,0.04724,0.23622,0.04724,0.24409,0.04724};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.25197,0.04724,0.25984,0.04724,0.26772,0.04724,0.27559,0.04724,0.28346,0.04724,0.29134,0.04724,0.29921,0.04724,0.30709,0.04724,0.31496,0.04724,0.32283,0.04724,0.33071,0.04724,0.33858,0.04724,0.34646,0.04724,0.35433,0.04724,0.3622,0.04724,0.37008,0.04724,0.37795,0.04724,0.38583,0.04724,0.3937,0.04724,0.40157,0.04724,0.40945,0.04724,0.41732,0.04724,0.4252,0.04724,0.43307,0.04724,0.44094,0.04724,0.44882,0.04724,0.45669,0.04724,0.46457,0.04724,0.47244,0.04724,0.48031,0.04724,0.48819,0.04724,0.49606,0.04724,0.50394,0.04724,0.51181,0.04724,0.51969,0.04724,0.52756,0.04724,0.53543,0.04724,0.54331,0.04724,0.55118,0.04724,0.55906,0.04724,0.56693,0.04724,0.5748,0.04724,0.58268,0.04724,0.59055,0.04724,0.59843,0.04724,0.6063,0.04724,0.61417,0.04724,0.62205,0.04724,0.62992,0.04724,0.6378,0.04724,0.64567,0.04724,0.65354,0.04724,0.66142,0.04724,0.66929,0.04724,0.67717,0.04724,0.68504,0.04724,0.69291,0.04724,0.70079,0.04724,0.70866,0.04724,0.71654,0.04724,0.72441,0.04724,0.73228,0.04724,0.74016,0.04724,0.74803,0.04724,0.75591,0.04724,0.76378,0.04724,0.77165,0.04724,0.77953,0.04724,0.7874,0.04724,0.79528,0.04724,0.80315,0.04724,0.81102,0.04724,0.8189,0.04724,0.82677,0.04724,0.83465,0.04724,0.84252,0.04724,0.85039,0.04724,0.85827,0.04724,0.86614,0.04724,0.87402,0.04724,0.88189,0.04724,0.88976,0.04724,0.89764,0.04724,0.90551,0.04724,0.91339,0.04724,0.92126,0.04724,0.92913,0.04724,0.93701,0.04724,0.94488,0.04724,0.95276,0.04724,0.96063,0.04724,0.9685,0.04724,0.97638,0.04724,0.98425,0.04724,0.99213,0.04724,0.99609,0.04724,0.00391,0.05512,0.00787,0.05512,0.01575,0.05512,0.02362,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.0315,0.05512,0.03937,0.05512,0.04724,0.05512,0.05512,0.05512,0.06299,0.05512,0.07087,0.05512,0.07874,0.05512,0.08661,0.05512,0.09449,0.05512,0.10236,0.05512,0.11024,0.05512,0.11811,0.05512,0.12598,0.05512,0.13386,0.05512,0.14173,0.05512,0.14961,0.05512,0.15748,0.05512,0.16535,0.05512,0.17323,0.05512,0.1811,0.05512,0.18898,0.05512,0.19685,0.05512,0.20472,0.05512,0.2126,0.05512,0.22047,0.05512,0.22835,0.05512,0.23622,0.05512,0.24409,0.05512,0.25197,0.05512,0.25984,0.05512,0.26772,0.05512,0.27559,0.05512,0.28346,0.05512,0.29134,0.05512,0.29921,0.05512,0.30709,0.05512,0.31496,0.05512,0.32283,0.05512,0.33071,0.05512,0.33858,0.05512,0.34646,0.05512,0.35433,0.05512,0.3622,0.05512,0.37008,0.05512,0.37795,0.05512,0.38583,0.05512,0.3937,0.05512,0.40157,0.05512,0.40945,0.05512,0.41732,0.05512,0.4252,0.05512,0.43307,0.05512,0.44094,0.05512,0.44882,0.05512,0.45669,0.05512,0.46457,0.05512,0.47244,0.05512,0.48031,0.05512,0.48819,0.05512,0.49606,0.05512,0.50394,0.05512,0.51181,0.05512,0.51969,0.05512,0.52756,0.05512,0.53543,0.05512,0.54331,0.05512,0.55118,0.05512,0.55906,0.05512,0.56693,0.05512,0.5748,0.05512,0.58268,0.05512,0.59055,0.05512,0.59843,0.05512,0.6063,0.05512,0.61417,0.05512,0.62205,0.05512,0.62992,0.05512,0.6378,0.05512,0.64567,0.05512,0.65354,0.05512,0.66142,0.05512,0.66929,0.05512,0.67717,0.05512,0.68504,0.05512,0.69291,0.05512,0.70079,0.05512,0.70866,0.05512,0.71654,0.05512,0.72441,0.05512,0.73228,0.05512,0.74016,0.05512,0.74803,0.05512,0.75591,0.05512,0.76378,0.05512,0.77165,0.05512,0.77953,0.05512,0.7874,0.05512,0.79528,0.05512,0.80315,0.05512,0.81102,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.8189,0.05512,0.82677,0.05512,0.83465,0.05512,0.84252,0.05512,0.85039,0.05512,0.85827,0.05512,0.86614,0.05512,0.87402,0.05512,0.88189,0.05512,0.88976,0.05512,0.89764,0.05512,0.90551,0.05512,0.91339,0.05512,0.92126,0.05512,0.92913,0.05512,0.93701,0.05512,0.94488,0.05512,0.95276,0.05512,0.96063,0.05512,0.9685,0.05512,0.97638,0.05512,0.98425,0.05512,0.99213,0.05512,0.99609,0.05512,0.00391,0.06299,0.00787,0.06299,0.01575,0.06299,0.02362,0.06299,0.0315,0.06299,0.03937,0.06299,0.04724,0.06299,0.05512,0.06299,0.06299,0.06299,0.07087,0.06299,0.07874,0.06299,0.08661,0.06299,0.09449,0.06299,0.10236,0.06299,0.11024,0.06299,0.11811,0.06299,0.12598,0.06299,0.13386,0.06299,0.14173,0.06299,0.14961,0.06299,0.15748,0.06299,0.16535,0.06299,0.17323,0.06299,0.1811,0.06299,0.18898,0.06299,0.19685,0.06299,0.20472,0.06299,0.2126,0.06299,0.22047,0.06299,0.22835,0.06299,0.23622,0.06299,0.24409,0.06299,0.25197,0.06299,0.25984,0.06299,0.26772,0.06299,0.27559,0.06299,0.28346,0.06299,0.29134,0.06299,0.29921,0.06299,0.30709,0.06299,0.31496,0.06299,0.32283,0.06299,0.33071,0.06299,0.33858,0.06299,0.34646,0.06299,0.35433,0.06299,0.3622,0.06299,0.37008,0.06299,0.37795,0.06299,0.38583,0.06299,0.3937,0.06299,0.40157,0.06299,0.40945,0.06299,0.41732,0.06299,0.4252,0.06299,0.43307,0.06299,0.44094,0.06299,0.44882,0.06299,0.45669,0.06299,0.46457,0.06299,0.47244,0.06299,0.48031,0.06299,0.48819,0.06299,0.49606,0.06299,0.50394,0.06299,0.51181,0.06299,0.51969,0.06299,0.52756,0.06299,0.53543,0.06299,0.54331,0.06299,0.55118,0.06299,0.55906,0.06299,0.56693,0.06299,0.5748,0.06299,0.58268,0.06299,0.59055,0.06299};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.59843,0.06299,0.6063,0.06299,0.61417,0.06299,0.62205,0.06299,0.62992,0.06299,0.6378,0.06299,0.64567,0.06299,0.65354,0.06299,0.66142,0.06299,0.66929,0.06299,0.67717,0.06299,0.68504,0.06299,0.69291,0.06299,0.70079,0.06299,0.70866,0.06299,0.71654,0.06299,0.72441,0.06299,0.73228,0.06299,0.74016,0.06299,0.74803,0.06299,0.75591,0.06299,0.76378,0.06299,0.77165,0.06299,0.77953,0.06299,0.7874,0.06299,0.79528,0.06299,0.80315,0.06299,0.81102,0.06299,0.8189,0.06299,0.82677,0.06299,0.83465,0.06299,0.84252,0.06299,0.85039,0.06299,0.85827,0.06299,0.86614,0.06299,0.87402,0.06299,0.88189,0.06299,0.88976,0.06299,0.89764,0.06299,0.90551,0.06299,0.91339,0.06299,0.92126,0.06299,0.92913,0.06299,0.93701,0.06299,0.94488,0.06299,0.95276,0.06299,0.96063,0.06299,0.9685,0.06299,0.97638,0.06299,0.98425,0.06299,0.99213,0.06299,0.99609,0.06299,0.00391,0.07087,0.00787,0.07087,0.01575,0.07087,0.02362,0.07087,0.0315,0.07087,0.03937,0.07087,0.04724,0.07087,0.05512,0.07087,0.06299,0.07087,0.07087,0.07087,0.07874,0.07087,0.08661,0.07087,0.09449,0.07087,0.10236,0.07087,0.11024,0.07087,0.11811,0.07087,0.12598,0.07087,0.13386,0.07087,0.14173,0.07087,0.14961,0.07087,0.15748,0.07087,0.16535,0.07087,0.17323,0.07087,0.1811,0.07087,0.18898,0.07087,0.19685,0.07087,0.20472,0.07087,0.2126,0.07087,0.22047,0.07087,0.22835,0.07087,0.23622,0.07087,0.24409,0.07087,0.25197,0.07087,0.25984,0.07087,0.26772,0.07087,0.27559,0.07087,0.28346,0.07087,0.29134,0.07087,0.29921,0.07087,0.30709,0.07087,0.31496,0.07087,0.32283,0.07087,0.33071,0.07087,0.33858,0.07087,0.34646,0.07087,0.35433,0.07087,0.3622,0.07087,0.37008,0.07087};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.37795,0.07087,0.38583,0.07087,0.3937,0.07087,0.40157,0.07087,0.40945,0.07087,0.41732,0.07087,0.4252,0.07087,0.43307,0.07087,0.44094,0.07087,0.44882,0.07087,0.45669,0.07087,0.46457,0.07087,0.47244,0.07087,0.48031,0.07087,0.48819,0.07087,0.49606,0.07087,0.50394,0.07087,0.51181,0.07087,0.51969,0.07087,0.52756,0.07087,0.53543,0.07087,0.54331,0.07087,0.55118,0.07087,0.55906,0.07087,0.56693,0.07087,0.5748,0.07087,0.58268,0.07087,0.59055,0.07087,0.59843,0.07087,0.6063,0.07087,0.61417,0.07087,0.62205,0.07087,0.62992,0.07087,0.6378,0.07087,0.64567,0.07087,0.65354,0.07087,0.66142,0.07087,0.66929,0.07087,0.67717,0.07087,0.68504,0.07087,0.69291,0.07087,0.70079,0.07087,0.70866,0.07087,0.71654,0.07087,0.72441,0.07087,0.73228,0.07087,0.74016,0.07087,0.74803,0.07087,0.75591,0.07087,0.76378,0.07087,0.77165,0.07087,0.77953,0.07087,0.7874,0.07087,0.79528,0.07087,0.80315,0.07087,0.81102,0.07087,0.8189,0.07087,0.82677,0.07087,0.83465,0.07087,0.84252,0.07087,0.85039,0.07087,0.85827,0.07087,0.86614,0.07087,0.87402,0.07087,0.88189,0.07087,0.88976,0.07087,0.89764,0.07087,0.90551,0.07087,0.91339,0.07087,0.92126,0.07087,0.92913,0.07087,0.93701,0.07087,0.94488,0.07087,0.95276,0.07087,0.96063,0.07087,0.9685,0.07087,0.97638,0.07087,0.98425,0.07087,0.99213,0.07087,0.99609,0.07087,0.00391,0.07874,0.00787,0.07874,0.01575,0.07874,0.02362,0.07874,0.0315,0.07874,0.03937,0.07874,0.04724,0.07874,0.05512,0.07874,0.06299,0.07874,0.07087,0.07874,0.07874,0.07874,0.08661,0.07874,0.09449,0.07874,0.10236,0.07874,0.11024,0.07874,0.11811,0.07874,0.12598,0.07874,0.13386,0.07874,0.14173,0.07874,0.14961,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.15748,0.07874,0.16535,0.07874,0.17323,0.07874,0.1811,0.07874,0.18898,0.07874,0.19685,0.07874,0.20472,0.07874,0.2126,0.07874,0.22047,0.07874,0.22835,0.07874,0.23622,0.07874,0.24409,0.07874,0.25197,0.07874,0.25984,0.07874,0.26772,0.07874,0.27559,0.07874,0.28346,0.07874,0.29134,0.07874,0.29921,0.07874,0.30709,0.07874,0.31496,0.07874,0.32283,0.07874,0.33071,0.07874,0.33858,0.07874,0.34646,0.07874,0.35433,0.07874,0.3622,0.07874,0.37008,0.07874,0.37795,0.07874,0.38583,0.07874,0.3937,0.07874,0.40157,0.07874,0.40945,0.07874,0.41732,0.07874,0.4252,0.07874,0.43307,0.07874,0.44094,0.07874,0.44882,0.07874,0.45669,0.07874,0.46457,0.07874,0.47244,0.07874,0.48031,0.07874,0.48819,0.07874,0.49606,0.07874,0.50394,0.07874,0.51181,0.07874,0.51969,0.07874,0.52756,0.07874,0.53543,0.07874,0.54331,0.07874,0.55118,0.07874,0.55906,0.07874,0.56693,0.07874,0.5748,0.07874,0.58268,0.07874,0.59055,0.07874,0.59843,0.07874,0.6063,0.07874,0.61417,0.07874,0.62205,0.07874,0.62992,0.07874,0.6378,0.07874,0.64567,0.07874,0.65354,0.07874,0.66142,0.07874,0.66929,0.07874,0.67717,0.07874,0.68504,0.07874,0.69291,0.07874,0.70079,0.07874,0.70866,0.07874,0.71654,0.07874,0.72441,0.07874,0.73228,0.07874,0.74016,0.07874,0.74803,0.07874,0.75591,0.07874,0.76378,0.07874,0.77165,0.07874,0.77953,0.07874,0.7874,0.07874,0.79528,0.07874,0.80315,0.07874,0.81102,0.07874,0.8189,0.07874,0.82677,0.07874,0.83465,0.07874,0.84252,0.07874,0.85039,0.07874,0.85827,0.07874,0.86614,0.07874,0.87402,0.07874,0.88189,0.07874,0.88976,0.07874,0.89764,0.07874,0.90551,0.07874,0.91339,0.07874,0.92126,0.07874,0.92913,0.07874,0.93701,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.94488,0.07874,0.95276,0.07874,0.96063,0.07874,0.9685,0.07874,0.97638,0.07874,0.98425,0.07874,0.99213,0.07874,0.99609,0.07874,0.00391,0.08661,0.00787,0.08661,0.01575,0.08661,0.02362,0.08661,0.0315,0.08661,0.03937,0.08661,0.04724,0.08661,0.05512,0.08661,0.06299,0.08661,0.07087,0.08661,0.07874,0.08661,0.08661,0.08661,0.09449,0.08661,0.10236,0.08661,0.11024,0.08661,0.11811,0.08661,0.12598,0.08661,0.13386,0.08661,0.14173,0.08661,0.14961,0.08661,0.15748,0.08661,0.16535,0.08661,0.17323,0.08661,0.1811,0.08661,0.18898,0.08661,0.19685,0.08661,0.20472,0.08661,0.2126,0.08661,0.22047,0.08661,0.22835,0.08661,0.23622,0.08661,0.24409,0.08661,0.25197,0.08661,0.25984,0.08661,0.26772,0.08661,0.27559,0.08661,0.28346,0.08661,0.29134,0.08661,0.29921,0.08661,0.30709,0.08661,0.31496,0.08661,0.32283,0.08661,0.33071,0.08661,0.33858,0.08661,0.34646,0.08661,0.35433,0.08661,0.3622,0.08661,0.37008,0.08661,0.37795,0.08661,0.38583,0.08661,0.3937,0.08661,0.40157,0.08661,0.40945,0.08661,0.41732,0.08661,0.4252,0.08661,0.43307,0.08661,0.44094,0.08661,0.44882,0.08661,0.45669,0.08661,0.46457,0.08661,0.47244,0.08661,0.48031,0.08661,0.48819,0.08661,0.49606,0.08661,0.50394,0.08661,0.51181,0.08661,0.51969,0.08661,0.52756,0.08661,0.53543,0.08661,0.54331,0.08661,0.55118,0.08661,0.55906,0.08661,0.56693,0.08661,0.5748,0.08661,0.58268,0.08661,0.59055,0.08661,0.59843,0.08661,0.6063,0.08661,0.61417,0.08661,0.62205,0.08661,0.62992,0.08661,0.6378,0.08661,0.64567,0.08661,0.65354,0.08661,0.66142,0.08661,0.66929,0.08661,0.67717,0.08661,0.68504,0.08661,0.69291,0.08661,0.70079,0.08661,0.70866,0.08661,0.71654,0.08661};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.72441,0.08661,0.73228,0.08661,0.74016,0.08661,0.74803,0.08661,0.75591,0.08661,0.76378,0.08661,0.77165,0.08661,0.77953,0.08661,0.7874,0.08661,0.79528,0.08661,0.80315,0.08661,0.81102,0.08661,0.8189,0.08661,0.82677,0.08661,0.83465,0.08661,0.84252,0.08661,0.85039,0.08661,0.85827,0.08661,0.86614,0.08661,0.87402,0.08661,0.88189,0.08661,0.88976,0.08661,0.89764,0.08661,0.90551,0.08661,0.91339,0.08661,0.92126,0.08661,0.92913,0.08661,0.93701,0.08661,0.94488,0.08661,0.95276,0.08661,0.96063,0.08661,0.9685,0.08661,0.97638,0.08661,0.98425,0.08661,0.99213,0.08661,0.99609,0.08661,0.00391,0.09449,0.00787,0.09449,0.01575,0.09449,0.02362,0.09449,0.0315,0.09449,0.03937,0.09449,0.04724,0.09449,0.05512,0.09449,0.06299,0.09449,0.07087,0.09449,0.07874,0.09449,0.08661,0.09449,0.09449,0.09449,0.10236,0.09449,0.11024,0.09449,0.11811,0.09449,0.12598,0.09449,0.13386,0.09449,0.14173,0.09449,0.14961,0.09449,0.15748,0.09449,0.16535,0.09449,0.17323,0.09449,0.1811,0.09449,0.18898,0.09449,0.19685,0.09449,0.20472,0.09449,0.2126,0.09449,0.22047,0.09449,0.22835,0.09449,0.23622,0.09449,0.24409,0.09449,0.25197,0.09449,0.25984,0.09449,0.26772,0.09449,0.27559,0.09449,0.28346,0.09449,0.29134,0.09449,0.29921,0.09449,0.30709,0.09449,0.31496,0.09449,0.32283,0.09449,0.33071,0.09449,0.33858,0.09449,0.34646,0.09449,0.35433,0.09449,0.3622,0.09449,0.37008,0.09449,0.37795,0.09449,0.38583,0.09449,0.3937,0.09449,0.40157,0.09449,0.40945,0.09449,0.41732,0.09449,0.4252,0.09449,0.43307,0.09449,0.44094,0.09449,0.44882,0.09449,0.45669,0.09449,0.46457,0.09449,0.47244,0.09449,0.48031,0.09449,0.48819,0.09449,0.49606,0.09449};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.50394,0.09449,0.51181,0.09449,0.51969,0.09449,0.52756,0.09449,0.53543,0.09449,0.54331,0.09449,0.55118,0.09449,0.55906,0.09449,0.56693,0.09449,0.5748,0.09449,0.58268,0.09449,0.59055,0.09449,0.59843,0.09449,0.6063,0.09449,0.61417,0.09449,0.62205,0.09449,0.62992,0.09449,0.6378,0.09449,0.64567,0.09449,0.65354,0.09449,0.66142,0.09449,0.66929,0.09449,0.67717,0.09449,0.68504,0.09449,0.69291,0.09449,0.70079,0.09449,0.70866,0.09449,0.71654,0.09449,0.72441,0.09449,0.73228,0.09449,0.74016,0.09449,0.74803,0.09449,0.75591,0.09449,0.76378,0.09449,0.77165,0.09449,0.77953,0.09449,0.7874,0.09449,0.79528,0.09449,0.80315,0.09449,0.81102,0.09449,0.8189,0.09449,0.82677,0.09449,0.83465,0.09449,0.84252,0.09449,0.85039,0.09449,0.85827,0.09449,0.86614,0.09449,0.87402,0.09449,0.88189,0.09449,0.88976,0.09449,0.89764,0.09449,0.90551,0.09449,0.91339,0.09449,0.92126,0.09449,0.92913,0.09449,0.93701,0.09449,0.94488,0.09449,0.95276,0.09449,0.96063,0.09449,0.9685,0.09449,0.97638,0.09449,0.98425,0.09449,0.99213,0.09449,0.99609,0.09449,0.00391,0.10236,0.00787,0.10236,0.01575,0.10236,0.02362,0.10236,0.0315,0.10236,0.03937,0.10236,0.04724,0.10236,0.05512,0.10236,0.06299,0.10236,0.07087,0.10236,0.07874,0.10236,0.08661,0.10236,0.09449,0.10236,0.10236,0.10236,0.11024,0.10236,0.11811,0.10236,0.12598,0.10236,0.13386,0.10236,0.14173,0.10236,0.14961,0.10236,0.15748,0.10236,0.16535,0.10236,0.17323,0.10236,0.1811,0.10236,0.18898,0.10236,0.19685,0.10236,0.20472,0.10236,0.2126,0.10236,0.22047,0.10236,0.22835,0.10236,0.23622,0.10236,0.24409,0.10236,0.25197,0.10236,0.25984,0.10236,0.26772,0.10236,0.27559,0.10236};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.28346,0.10236,0.29134,0.10236,0.29921,0.10236,0.30709,0.10236,0.31496,0.10236,0.32283,0.10236,0.33071,0.10236,0.33858,0.10236,0.34646,0.10236,0.35433,0.10236,0.3622,0.10236,0.37008,0.10236,0.37795,0.10236,0.38583,0.10236,0.3937,0.10236,0.40157,0.10236,0.40945,0.10236,0.41732,0.10236,0.4252,0.10236,0.43307,0.10236,0.44094,0.10236,0.44882,0.10236,0.45669,0.10236,0.46457,0.10236,0.47244,0.10236,0.48031,0.10236,0.48819,0.10236,0.49606,0.10236,0.50394,0.10236,0.51181,0.10236,0.51969,0.10236,0.52756,0.10236,0.53543,0.10236,0.54331,0.10236,0.55118,0.10236,0.55906,0.10236,0.56693,0.10236,0.5748,0.10236,0.58268,0.10236,0.59055,0.10236,0.59843,0.10236,0.6063,0.10236,0.61417,0.10236,0.62205,0.10236,0.62992,0.10236,0.6378,0.10236,0.64567,0.10236,0.65354,0.10236,0.66142,0.10236,0.66929,0.10236,0.67717,0.10236,0.68504,0.10236,0.69291,0.10236,0.70079,0.10236,0.70866,0.10236,0.71654,0.10236,0.72441,0.10236,0.73228,0.10236,0.74016,0.10236,0.74803,0.10236,0.75591,0.10236,0.76378,0.10236,0.77165,0.10236,0.77953,0.10236,0.7874,0.10236,0.79528,0.10236,0.80315,0.10236,0.81102,0.10236,0.8189,0.10236,0.82677,0.10236,0.83465,0.10236,0.84252,0.10236,0.85039,0.10236,0.85827,0.10236,0.86614,0.10236,0.87402,0.10236,0.88189,0.10236,0.88976,0.10236,0.89764,0.10236,0.90551,0.10236,0.91339,0.10236,0.92126,0.10236,0.92913,0.10236,0.93701,0.10236,0.94488,0.10236,0.95276,0.10236,0.96063,0.10236,0.9685,0.10236,0.97638,0.10236,0.98425,0.10236,0.99213,0.10236,0.99609,0.10236,0.00391,0.11024,0.00787,0.11024,0.01575,0.11024,0.02362,0.11024,0.0315,0.11024,0.03937,0.11024,0.04724,0.11024,0.05512,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.06299,0.11024,0.07087,0.11024,0.07874,0.11024,0.08661,0.11024,0.09449,0.11024,0.10236,0.11024,0.11024,0.11024,0.11811,0.11024,0.12598,0.11024,0.13386,0.11024,0.14173,0.11024,0.14961,0.11024,0.15748,0.11024,0.16535,0.11024,0.17323,0.11024,0.1811,0.11024,0.18898,0.11024,0.19685,0.11024,0.20472,0.11024,0.2126,0.11024,0.22047,0.11024,0.22835,0.11024,0.23622,0.11024,0.24409,0.11024,0.25197,0.11024,0.25984,0.11024,0.26772,0.11024,0.27559,0.11024,0.28346,0.11024,0.29134,0.11024,0.29921,0.11024,0.30709,0.11024,0.31496,0.11024,0.32283,0.11024,0.33071,0.11024,0.33858,0.11024,0.34646,0.11024,0.35433,0.11024,0.3622,0.11024,0.37008,0.11024,0.37795,0.11024,0.38583,0.11024,0.3937,0.11024,0.40157,0.11024,0.40945,0.11024,0.41732,0.11024,0.4252,0.11024,0.43307,0.11024,0.44094,0.11024,0.44882,0.11024,0.45669,0.11024,0.46457,0.11024,0.47244,0.11024,0.48031,0.11024,0.48819,0.11024,0.49606,0.11024,0.50394,0.11024,0.51181,0.11024,0.51969,0.11024,0.52756,0.11024,0.53543,0.11024,0.54331,0.11024,0.55118,0.11024,0.55906,0.11024,0.56693,0.11024,0.5748,0.11024,0.58268,0.11024,0.59055,0.11024,0.59843,0.11024,0.6063,0.11024,0.61417,0.11024,0.62205,0.11024,0.62992,0.11024,0.6378,0.11024,0.64567,0.11024,0.65354,0.11024,0.66142,0.11024,0.66929,0.11024,0.67717,0.11024,0.68504,0.11024,0.69291,0.11024,0.70079,0.11024,0.70866,0.11024,0.71654,0.11024,0.72441,0.11024,0.73228,0.11024,0.74016,0.11024,0.74803,0.11024,0.75591,0.11024,0.76378,0.11024,0.77165,0.11024,0.77953,0.11024,0.7874,0.11024,0.79528,0.11024,0.80315,0.11024,0.81102,0.11024,0.8189,0.11024,0.82677,0.11024,0.83465,0.11024,0.84252,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.85039,0.11024,0.85827,0.11024,0.86614,0.11024,0.87402,0.11024,0.88189,0.11024,0.88976,0.11024,0.89764,0.11024,0.90551,0.11024,0.91339,0.11024,0.92126,0.11024,0.92913,0.11024,0.93701,0.11024,0.94488,0.11024,0.95276,0.11024,0.96063,0.11024,0.9685,0.11024,0.97638,0.11024,0.98425,0.11024,0.99213,0.11024,0.99609,0.11024,0.00391,0.11811,0.00787,0.11811,0.01575,0.11811,0.02362,0.11811,0.0315,0.11811,0.03937,0.11811,0.04724,0.11811,0.05512,0.11811,0.06299,0.11811,0.07087,0.11811,0.07874,0.11811,0.08661,0.11811,0.09449,0.11811,0.10236,0.11811,0.11024,0.11811,0.11811,0.11811,0.12598,0.11811,0.13386,0.11811,0.14173,0.11811,0.14961,0.11811,0.15748,0.11811,0.16535,0.11811,0.17323,0.11811,0.1811,0.11811,0.18898,0.11811,0.19685,0.11811,0.20472,0.11811,0.2126,0.11811,0.22047,0.11811,0.22835,0.11811,0.23622,0.11811,0.24409,0.11811,0.25197,0.11811,0.25984,0.11811,0.26772,0.11811,0.27559,0.11811,0.28346,0.11811,0.29134,0.11811,0.29921,0.11811,0.30709,0.11811,0.31496,0.11811,0.32283,0.11811,0.33071,0.11811,0.33858,0.11811,0.34646,0.11811,0.35433,0.11811,0.3622,0.11811,0.37008,0.11811,0.37795,0.11811,0.38583,0.11811,0.3937,0.11811,0.40157,0.11811,0.40945,0.11811,0.41732,0.11811,0.4252,0.11811,0.43307,0.11811,0.44094,0.11811,0.44882,0.11811,0.45669,0.11811,0.46457,0.11811,0.47244,0.11811,0.48031,0.11811,0.48819,0.11811,0.49606,0.11811,0.50394,0.11811,0.51181,0.11811,0.51969,0.11811,0.52756,0.11811,0.53543,0.11811,0.54331,0.11811,0.55118,0.11811,0.55906,0.11811,0.56693,0.11811,0.5748,0.11811,0.58268,0.11811,0.59055,0.11811,0.59843,0.11811,0.6063,0.11811,0.61417,0.11811,0.62205,0.11811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.62992,0.11811,0.6378,0.11811,0.64567,0.11811,0.65354,0.11811,0.66142,0.11811,0.66929,0.11811,0.67717,0.11811,0.68504,0.11811,0.69291,0.11811,0.70079,0.11811,0.70866,0.11811,0.71654,0.11811,0.72441,0.11811,0.73228,0.11811,0.74016,0.11811,0.74803,0.11811,0.75591,0.11811,0.76378,0.11811,0.77165,0.11811,0.77953,0.11811,0.7874,0.11811,0.79528,0.11811,0.80315,0.11811,0.81102,0.11811,0.8189,0.11811,0.82677,0.11811,0.83465,0.11811,0.84252,0.11811,0.85039,0.11811,0.85827,0.11811,0.86614,0.11811,0.87402,0.11811,0.88189,0.11811,0.88976,0.11811,0.89764,0.11811,0.90551,0.11811,0.91339,0.11811,0.92126,0.11811,0.92913,0.11811,0.93701,0.11811,0.94488,0.11811,0.95276,0.11811,0.96063,0.11811,0.9685,0.11811,0.97638,0.11811,0.98425,0.11811,0.99213,0.11811,0.99609,0.11811,0.00391,0.12598,0.00787,0.12598,0.01575,0.12598,0.02362,0.12598,0.0315,0.12598,0.03937,0.12598,0.04724,0.12598,0.05512,0.12598,0.06299,0.12598,0.07087,0.12598,0.07874,0.12598,0.08661,0.12598,0.09449,0.12598,0.10236,0.12598,0.11024,0.12598,0.11811,0.12598,0.12598,0.12598,0.13386,0.12598,0.14173,0.12598,0.14961,0.12598,0.15748,0.12598,0.16535,0.12598,0.17323,0.12598,0.1811,0.12598,0.18898,0.12598,0.19685,0.12598,0.20472,0.12598,0.2126,0.12598,0.22047,0.12598,0.22835,0.12598,0.23622,0.12598,0.24409,0.12598,0.25197,0.12598,0.25984,0.12598,0.26772,0.12598,0.27559,0.12598,0.28346,0.12598,0.29134,0.12598,0.29921,0.12598,0.30709,0.12598,0.31496,0.12598,0.32283,0.12598,0.33071,0.12598,0.33858,0.12598,0.34646,0.12598,0.35433,0.12598,0.3622,0.12598,0.37008,0.12598,0.37795,0.12598,0.38583,0.12598,0.3937,0.12598,0.40157,0.12598};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.40945,0.12598,0.41732,0.12598,0.4252,0.12598,0.43307,0.12598,0.44094,0.12598,0.44882,0.12598,0.45669,0.12598,0.46457,0.12598,0.47244,0.12598,0.48031,0.12598,0.48819,0.12598,0.49606,0.12598,0.50394,0.12598,0.51181,0.12598,0.51969,0.12598,0.52756,0.12598,0.53543,0.12598,0.54331,0.12598,0.55118,0.12598,0.55906,0.12598,0.56693,0.12598,0.5748,0.12598,0.58268,0.12598,0.59055,0.12598,0.59843,0.12598,0.6063,0.12598,0.61417,0.12598,0.62205,0.12598,0.62992,0.12598,0.6378,0.12598,0.64567,0.12598,0.65354,0.12598,0.66142,0.12598,0.66929,0.12598,0.67717,0.12598,0.68504,0.12598,0.69291,0.12598,0.70079,0.12598,0.70866,0.12598,0.71654,0.12598,0.72441,0.12598,0.73228,0.12598,0.74016,0.12598,0.74803,0.12598,0.75591,0.12598,0.76378,0.12598,0.77165,0.12598,0.77953,0.12598,0.7874,0.12598,0.79528,0.12598,0.80315,0.12598,0.81102,0.12598,0.8189,0.12598,0.82677,0.12598,0.83465,0.12598,0.84252,0.12598,0.85039,0.12598,0.85827,0.12598,0.86614,0.12598,0.87402,0.12598,0.88189,0.12598,0.88976,0.12598,0.89764,0.12598,0.90551,0.12598,0.91339,0.12598,0.92126,0.12598,0.92913,0.12598,0.93701,0.12598,0.94488,0.12598,0.95276,0.12598,0.96063,0.12598,0.9685,0.12598,0.97638,0.12598,0.98425,0.12598,0.99213,0.12598,0.99609,0.12598,0.00391,0.13386,0.00787,0.13386,0.01575,0.13386,0.02362,0.13386,0.0315,0.13386,0.03937,0.13386,0.04724,0.13386,0.05512,0.13386,0.06299,0.13386,0.07087,0.13386,0.07874,0.13386,0.08661,0.13386,0.09449,0.13386,0.10236,0.13386,0.11024,0.13386,0.11811,0.13386,0.12598,0.13386,0.13386,0.13386,0.14173,0.13386,0.14961,0.13386,0.15748,0.13386,0.16535,0.13386,0.17323,0.13386,0.1811,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.18898,0.13386,0.19685,0.13386,0.20472,0.13386,0.2126,0.13386,0.22047,0.13386,0.22835,0.13386,0.23622,0.13386,0.24409,0.13386,0.25197,0.13386,0.25984,0.13386,0.26772,0.13386,0.27559,0.13386,0.28346,0.13386,0.29134,0.13386,0.29921,0.13386,0.30709,0.13386,0.31496,0.13386,0.32283,0.13386,0.33071,0.13386,0.33858,0.13386,0.34646,0.13386,0.35433,0.13386,0.3622,0.13386,0.37008,0.13386,0.37795,0.13386,0.38583,0.13386,0.3937,0.13386,0.40157,0.13386,0.40945,0.13386,0.41732,0.13386,0.4252,0.13386,0.43307,0.13386,0.44094,0.13386,0.44882,0.13386,0.45669,0.13386,0.46457,0.13386,0.47244,0.13386,0.48031,0.13386,0.48819,0.13386,0.49606,0.13386,0.50394,0.13386,0.51181,0.13386,0.51969,0.13386,0.52756,0.13386,0.53543,0.13386,0.54331,0.13386,0.55118,0.13386,0.55906,0.13386,0.56693,0.13386,0.5748,0.13386,0.58268,0.13386,0.59055,0.13386,0.59843,0.13386,0.6063,0.13386,0.61417,0.13386,0.62205,0.13386,0.62992,0.13386,0.6378,0.13386,0.64567,0.13386,0.65354,0.13386,0.66142,0.13386,0.66929,0.13386,0.67717,0.13386,0.68504,0.13386,0.69291,0.13386,0.70079,0.13386,0.70866,0.13386,0.71654,0.13386,0.72441,0.13386,0.73228,0.13386,0.74016,0.13386,0.74803,0.13386,0.75591,0.13386,0.76378,0.13386,0.77165,0.13386,0.77953,0.13386,0.7874,0.13386,0.79528,0.13386,0.80315,0.13386,0.81102,0.13386,0.8189,0.13386,0.82677,0.13386,0.83465,0.13386,0.84252,0.13386,0.85039,0.13386,0.85827,0.13386,0.86614,0.13386,0.87402,0.13386,0.88189,0.13386,0.88976,0.13386,0.89764,0.13386,0.90551,0.13386,0.91339,0.13386,0.92126,0.13386,0.92913,0.13386,0.93701,0.13386,0.94488,0.13386,0.95276,0.13386,0.96063,0.13386,0.9685,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.97638,0.13386,0.98425,0.13386,0.99213,0.13386,0.99609,0.13386,0.00391,0.14173,0.00787,0.14173,0.01575,0.14173,0.02362,0.14173,0.0315,0.14173,0.03937,0.14173,0.04724,0.14173,0.05512,0.14173,0.06299,0.14173,0.07087,0.14173,0.07874,0.14173,0.08661,0.14173,0.09449,0.14173,0.10236,0.14173,0.11024,0.14173,0.11811,0.14173,0.12598,0.14173,0.13386,0.14173,0.14173,0.14173,0.14961,0.14173,0.15748,0.14173,0.16535,0.14173,0.17323,0.14173,0.1811,0.14173,0.18898,0.14173,0.19685,0.14173,0.20472,0.14173,0.2126,0.14173,0.22047,0.14173,0.22835,0.14173,0.23622,0.14173,0.24409,0.14173,0.25197,0.14173,0.25984,0.14173,0.26772,0.14173,0.27559,0.14173,0.28346,0.14173,0.29134,0.14173,0.29921,0.14173,0.30709,0.14173,0.31496,0.14173,0.32283,0.14173,0.33071,0.14173,0.33858,0.14173,0.34646,0.14173,0.35433,0.14173,0.3622,0.14173,0.37008,0.14173,0.37795,0.14173,0.38583,0.14173,0.3937,0.14173,0.40157,0.14173,0.40945,0.14173,0.41732,0.14173,0.4252,0.14173,0.43307,0.14173,0.44094,0.14173,0.44882,0.14173,0.45669,0.14173,0.46457,0.14173,0.47244,0.14173,0.48031,0.14173,0.48819,0.14173,0.49606,0.14173,0.50394,0.14173,0.51181,0.14173,0.51969,0.14173,0.52756,0.14173,0.53543,0.14173,0.54331,0.14173,0.55118,0.14173,0.55906,0.14173,0.56693,0.14173,0.5748,0.14173,0.58268,0.14173,0.59055,0.14173,0.59843,0.14173,0.6063,0.14173,0.61417,0.14173,0.62205,0.14173,0.62992,0.14173,0.6378,0.14173,0.64567,0.14173,0.65354,0.14173,0.66142,0.14173,0.66929,0.14173,0.67717,0.14173,0.68504,0.14173,0.69291,0.14173,0.70079,0.14173,0.70866,0.14173,0.71654,0.14173,0.72441,0.14173,0.73228,0.14173,0.74016,0.14173,0.74803,0.14173};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.75591,0.14173,0.76378,0.14173,0.77165,0.14173,0.77953,0.14173,0.7874,0.14173,0.79528,0.14173,0.80315,0.14173,0.81102,0.14173,0.8189,0.14173,0.82677,0.14173,0.83465,0.14173,0.84252,0.14173,0.85039,0.14173,0.85827,0.14173,0.86614,0.14173,0.87402,0.14173,0.88189,0.14173,0.88976,0.14173,0.89764,0.14173,0.90551,0.14173,0.91339,0.14173,0.92126,0.14173,0.92913,0.14173,0.93701,0.14173,0.94488,0.14173,0.95276,0.14173,0.96063,0.14173,0.9685,0.14173,0.97638,0.14173,0.98425,0.14173,0.99213,0.14173,0.99609,0.14173,0.00391,0.14961,0.00787,0.14961,0.01575,0.14961,0.02362,0.14961,0.0315,0.14961,0.03937,0.14961,0.04724,0.14961,0.05512,0.14961,0.06299,0.14961,0.07087,0.14961,0.07874,0.14961,0.08661,0.14961,0.09449,0.14961,0.10236,0.14961,0.11024,0.14961,0.11811,0.14961,0.12598,0.14961,0.13386,0.14961,0.14173,0.14961,0.14961,0.14961,0.15748,0.14961,0.16535,0.14961,0.17323,0.14961,0.1811,0.14961,0.18898,0.14961,0.19685,0.14961,0.20472,0.14961,0.2126,0.14961,0.22047,0.14961,0.22835,0.14961,0.23622,0.14961,0.24409,0.14961,0.25197,0.14961,0.25984,0.14961,0.26772,0.14961,0.27559,0.14961,0.28346,0.14961,0.29134,0.14961,0.29921,0.14961,0.30709,0.14961,0.31496,0.14961,0.32283,0.14961,0.33071,0.14961,0.33858,0.14961,0.34646,0.14961,0.35433,0.14961,0.3622,0.14961,0.37008,0.14961,0.37795,0.14961,0.38583,0.14961,0.3937,0.14961,0.40157,0.14961,0.40945,0.14961,0.41732,0.14961,0.4252,0.14961,0.43307,0.14961,0.44094,0.14961,0.44882,0.14961,0.45669,0.14961,0.46457,0.14961,0.47244,0.14961,0.48031,0.14961,0.48819,0.14961,0.49606,0.14961,0.50394,0.14961,0.51181,0.14961,0.51969,0.14961,0.52756,0.14961};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.53543,0.14961,0.54331,0.14961,0.55118,0.14961,0.55906,0.14961,0.56693,0.14961,0.5748,0.14961,0.58268,0.14961,0.59055,0.14961,0.59843,0.14961,0.6063,0.14961,0.61417,0.14961,0.62205,0.14961,0.62992,0.14961,0.6378,0.14961,0.64567,0.14961,0.65354,0.14961,0.66142,0.14961,0.66929,0.14961,0.67717,0.14961,0.68504,0.14961,0.69291,0.14961,0.70079,0.14961,0.70866,0.14961,0.71654,0.14961,0.72441,0.14961,0.73228,0.14961,0.74016,0.14961,0.74803,0.14961,0.75591,0.14961,0.76378,0.14961,0.77165,0.14961,0.77953,0.14961,0.7874,0.14961,0.79528,0.14961,0.80315,0.14961,0.81102,0.14961,0.8189,0.14961,0.82677,0.14961,0.83465,0.14961,0.84252,0.14961,0.85039,0.14961,0.85827,0.14961,0.86614,0.14961,0.87402,0.14961,0.88189,0.14961,0.88976,0.14961,0.89764,0.14961,0.90551,0.14961,0.91339,0.14961,0.92126,0.14961,0.92913,0.14961,0.93701,0.14961,0.94488,0.14961,0.95276,0.14961,0.96063,0.14961,0.9685,0.14961,0.97638,0.14961,0.98425,0.14961,0.99213,0.14961,0.99609,0.14961,0.00391,0.15748,0.00787,0.15748,0.01575,0.15748,0.02362,0.15748,0.0315,0.15748,0.03937,0.15748,0.04724,0.15748,0.05512,0.15748,0.06299,0.15748,0.07087,0.15748,0.07874,0.15748,0.08661,0.15748,0.09449,0.15748,0.10236,0.15748,0.11024,0.15748,0.11811,0.15748,0.12598,0.15748,0.13386,0.15748,0.14173,0.15748,0.14961,0.15748,0.15748,0.15748,0.16535,0.15748,0.17323,0.15748,0.1811,0.15748,0.18898,0.15748,0.19685,0.15748,0.20472,0.15748,0.2126,0.15748,0.22047,0.15748,0.22835,0.15748,0.23622,0.15748,0.24409,0.15748,0.25197,0.15748,0.25984,0.15748,0.26772,0.15748,0.27559,0.15748,0.28346,0.15748,0.29134,0.15748,0.29921,0.15748,0.30709,0.15748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.31496,0.15748,0.32283,0.15748,0.33071,0.15748,0.33858,0.15748,0.34646,0.15748,0.35433,0.15748,0.3622,0.15748,0.37008,0.15748,0.37795,0.15748,0.38583,0.15748,0.3937,0.15748,0.40157,0.15748,0.40945,0.15748,0.41732,0.15748,0.4252,0.15748,0.43307,0.15748,0.44094,0.15748,0.44882,0.15748,0.45669,0.15748,0.46457,0.15748,0.47244,0.15748,0.48031,0.15748,0.48819,0.15748,0.49606,0.15748,0.50394,0.15748,0.51181,0.15748,0.51969,0.15748,0.52756,0.15748,0.53543,0.15748,0.54331,0.15748,0.55118,0.15748,0.55906,0.15748,0.56693,0.15748,0.5748,0.15748,0.58268,0.15748,0.59055,0.15748,0.59843,0.15748,0.6063,0.15748,0.61417,0.15748,0.62205,0.15748,0.62992,0.15748,0.6378,0.15748,0.64567,0.15748,0.65354,0.15748,0.66142,0.15748,0.66929,0.15748,0.67717,0.15748,0.68504,0.15748,0.69291,0.15748,0.70079,0.15748,0.70866,0.15748,0.71654,0.15748,0.72441,0.15748,0.73228,0.15748,0.74016,0.15748,0.74803,0.15748,0.75591,0.15748,0.76378,0.15748,0.77165,0.15748,0.77953,0.15748,0.7874,0.15748,0.79528,0.15748,0.80315,0.15748,0.81102,0.15748,0.8189,0.15748,0.82677,0.15748,0.83465,0.15748,0.84252,0.15748,0.85039,0.15748,0.85827,0.15748,0.86614,0.15748,0.87402,0.15748,0.88189,0.15748,0.88976,0.15748,0.89764,0.15748,0.90551,0.15748,0.91339,0.15748,0.92126,0.15748,0.92913,0.15748,0.93701,0.15748,0.94488,0.15748,0.95276,0.15748,0.96063,0.15748,0.9685,0.15748,0.97638,0.15748,0.98425,0.15748,0.99213,0.15748,0.99609,0.15748,0.00391,0.16535,0.00787,0.16535,0.01575,0.16535,0.02362,0.16535,0.0315,0.16535,0.03937,0.16535,0.04724,0.16535,0.05512,0.16535,0.06299,0.16535,0.07087,0.16535,0.07874,0.16535,0.08661,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.09449,0.16535,0.10236,0.16535,0.11024,0.16535,0.11811,0.16535,0.12598,0.16535,0.13386,0.16535,0.14173,0.16535,0.14961,0.16535,0.15748,0.16535,0.16535,0.16535,0.17323,0.16535,0.1811,0.16535,0.18898,0.16535,0.19685,0.16535,0.20472,0.16535,0.2126,0.16535,0.22047,0.16535,0.22835,0.16535,0.23622,0.16535,0.24409,0.16535,0.25197,0.16535,0.25984,0.16535,0.26772,0.16535,0.27559,0.16535,0.28346,0.16535,0.29134,0.16535,0.29921,0.16535,0.30709,0.16535,0.31496,0.16535,0.32283,0.16535,0.33071,0.16535,0.33858,0.16535,0.34646,0.16535,0.35433,0.16535,0.3622,0.16535,0.37008,0.16535,0.37795,0.16535,0.38583,0.16535,0.3937,0.16535,0.40157,0.16535,0.40945,0.16535,0.41732,0.16535,0.4252,0.16535,0.43307,0.16535,0.44094,0.16535,0.44882,0.16535,0.45669,0.16535,0.46457,0.16535,0.47244,0.16535,0.48031,0.16535,0.48819,0.16535,0.49606,0.16535,0.50394,0.16535,0.51181,0.16535,0.51969,0.16535,0.52756,0.16535,0.53543,0.16535,0.54331,0.16535,0.55118,0.16535,0.55906,0.16535,0.56693,0.16535,0.5748,0.16535,0.58268,0.16535,0.59055,0.16535,0.59843,0.16535,0.6063,0.16535,0.61417,0.16535,0.62205,0.16535,0.62992,0.16535,0.6378,0.16535,0.64567,0.16535,0.65354,0.16535,0.66142,0.16535,0.66929,0.16535,0.67717,0.16535,0.68504,0.16535,0.69291,0.16535,0.70079,0.16535,0.70866,0.16535,0.71654,0.16535,0.72441,0.16535,0.73228,0.16535,0.74016,0.16535,0.74803,0.16535,0.75591,0.16535,0.76378,0.16535,0.77165,0.16535,0.77953,0.16535,0.7874,0.16535,0.79528,0.16535,0.80315,0.16535,0.81102,0.16535,0.8189,0.16535,0.82677,0.16535,0.83465,0.16535,0.84252,0.16535,0.85039,0.16535,0.85827,0.16535,0.86614,0.16535,0.87402,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.88189,0.16535,0.88976,0.16535,0.89764,0.16535,0.90551,0.16535,0.91339,0.16535,0.92126,0.16535,0.92913,0.16535,0.93701,0.16535,0.94488,0.16535,0.95276,0.16535,0.96063,0.16535,0.9685,0.16535,0.97638,0.16535,0.98425,0.16535,0.99213,0.16535,0.99609,0.16535,0.00391,0.17323,0.00787,0.17323,0.01575,0.17323,0.02362,0.17323,0.0315,0.17323,0.03937,0.17323,0.04724,0.17323,0.05512,0.17323,0.06299,0.17323,0.07087,0.17323,0.07874,0.17323,0.08661,0.17323,0.09449,0.17323,0.10236,0.17323,0.11024,0.17323,0.11811,0.17323,0.12598,0.17323,0.13386,0.17323,0.14173,0.17323,0.14961,0.17323,0.15748,0.17323,0.16535,0.17323,0.17323,0.17323,0.1811,0.17323,0.18898,0.17323,0.19685,0.17323,0.20472,0.17323,0.2126,0.17323,0.22047,0.17323,0.22835,0.17323,0.23622,0.17323,0.24409,0.17323,0.25197,0.17323,0.25984,0.17323,0.26772,0.17323,0.27559,0.17323,0.28346,0.17323,0.29134,0.17323,0.29921,0.17323,0.30709,0.17323,0.31496,0.17323,0.32283,0.17323,0.33071,0.17323,0.33858,0.17323,0.34646,0.17323,0.35433,0.17323,0.3622,0.17323,0.37008,0.17323,0.37795,0.17323,0.38583,0.17323,0.3937,0.17323,0.40157,0.17323,0.40945,0.17323,0.41732,0.17323,0.4252,0.17323,0.43307,0.17323,0.44094,0.17323,0.44882,0.17323,0.45669,0.17323,0.46457,0.17323,0.47244,0.17323,0.48031,0.17323,0.48819,0.17323,0.49606,0.17323,0.50394,0.17323,0.51181,0.17323,0.51969,0.17323,0.52756,0.17323,0.53543,0.17323,0.54331,0.17323,0.55118,0.17323,0.55906,0.17323,0.56693,0.17323,0.5748,0.17323,0.58268,0.17323,0.59055,0.17323,0.59843,0.17323,0.6063,0.17323,0.61417,0.17323,0.62205,0.17323,0.62992,0.17323,0.6378,0.17323,0.64567,0.17323,0.65354,0.17323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.66142,0.17323,0.66929,0.17323,0.67717,0.17323,0.68504,0.17323,0.69291,0.17323,0.70079,0.17323,0.70866,0.17323,0.71654,0.17323,0.72441,0.17323,0.73228,0.17323,0.74016,0.17323,0.74803,0.17323,0.75591,0.17323,0.76378,0.17323,0.77165,0.17323,0.77953,0.17323,0.7874,0.17323,0.79528,0.17323,0.80315,0.17323,0.81102,0.17323,0.8189,0.17323,0.82677,0.17323,0.83465,0.17323,0.84252,0.17323,0.85039,0.17323,0.85827,0.17323,0.86614,0.17323,0.87402,0.17323,0.88189,0.17323,0.88976,0.17323,0.89764,0.17323,0.90551,0.17323,0.91339,0.17323,0.92126,0.17323,0.92913,0.17323,0.93701,0.17323,0.94488,0.17323,0.95276,0.17323,0.96063,0.17323,0.9685,0.17323,0.97638,0.17323,0.98425,0.17323,0.99213,0.17323,0.99609,0.17323,0.00391,0.1811,0.00787,0.1811,0.01575,0.1811,0.02362,0.1811,0.0315,0.1811,0.03937,0.1811,0.04724,0.1811,0.05512,0.1811,0.06299,0.1811,0.07087,0.1811,0.07874,0.1811,0.08661,0.1811,0.09449,0.1811,0.10236,0.1811,0.11024,0.1811,0.11811,0.1811,0.12598,0.1811,0.13386,0.1811,0.14173,0.1811,0.14961,0.1811,0.15748,0.1811,0.16535,0.1811,0.17323,0.1811,0.1811,0.1811,0.18898,0.1811,0.19685,0.1811,0.20472,0.1811,0.2126,0.1811,0.22047,0.1811,0.22835,0.1811,0.23622,0.1811,0.24409,0.1811,0.25197,0.1811,0.25984,0.1811,0.26772,0.1811,0.27559,0.1811,0.28346,0.1811,0.29134,0.1811,0.29921,0.1811,0.30709,0.1811,0.31496,0.1811,0.32283,0.1811,0.33071,0.1811,0.33858,0.1811,0.34646,0.1811,0.35433,0.1811,0.3622,0.1811,0.37008,0.1811,0.37795,0.1811,0.38583,0.1811,0.3937,0.1811,0.40157,0.1811,0.40945,0.1811,0.41732,0.1811,0.4252,0.1811,0.43307,0.1811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.44094,0.1811,0.44882,0.1811,0.45669,0.1811,0.46457,0.1811,0.47244,0.1811,0.48031,0.1811,0.48819,0.1811,0.49606,0.1811,0.50394,0.1811,0.51181,0.1811,0.51969,0.1811,0.52756,0.1811,0.53543,0.1811,0.54331,0.1811,0.55118,0.1811,0.55906,0.1811,0.56693,0.1811,0.5748,0.1811,0.58268,0.1811,0.59055,0.1811,0.59843,0.1811,0.6063,0.1811,0.61417,0.1811,0.62205,0.1811,0.62992,0.1811,0.6378,0.1811,0.64567,0.1811,0.65354,0.1811,0.66142,0.1811,0.66929,0.1811,0.67717,0.1811,0.68504,0.1811,0.69291,0.1811,0.70079,0.1811,0.70866,0.1811,0.71654,0.1811,0.72441,0.1811,0.73228,0.1811,0.74016,0.1811,0.74803,0.1811,0.75591,0.1811,0.76378,0.1811,0.77165,0.1811,0.77953,0.1811,0.7874,0.1811,0.79528,0.1811,0.80315,0.1811,0.81102,0.1811,0.8189,0.1811,0.82677,0.1811,0.83465,0.1811,0.84252,0.1811,0.85039,0.1811,0.85827,0.1811,0.86614,0.1811,0.87402,0.1811,0.88189,0.1811,0.88976,0.1811,0.89764,0.1811,0.90551,0.1811,0.91339,0.1811,0.92126,0.1811,0.92913,0.1811,0.93701,0.1811,0.94488,0.1811,0.95276,0.1811,0.96063,0.1811,0.9685,0.1811,0.97638,0.1811,0.98425,0.1811,0.99213,0.1811,0.99609,0.1811,0.00391,0.18898,0.00787,0.18898,0.01575,0.18898,0.02362,0.18898,0.0315,0.18898,0.03937,0.18898,0.04724,0.18898,0.05512,0.18898,0.06299,0.18898,0.07087,0.18898,0.07874,0.18898,0.08661,0.18898,0.09449,0.18898,0.10236,0.18898,0.11024,0.18898,0.11811,0.18898,0.12598,0.18898,0.13386,0.18898,0.14173,0.18898,0.14961,0.18898,0.15748,0.18898,0.16535,0.18898,0.17323,0.18898,0.1811,0.18898,0.18898,0.18898,0.19685,0.18898,0.20472,0.18898,0.2126,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.22047,0.18898,0.22835,0.18898,0.23622,0.18898,0.24409,0.18898,0.25197,0.18898,0.25984,0.18898,0.26772,0.18898,0.27559,0.18898,0.28346,0.18898,0.29134,0.18898,0.29921,0.18898,0.30709,0.18898,0.31496,0.18898,0.32283,0.18898,0.33071,0.18898,0.33858,0.18898,0.34646,0.18898,0.35433,0.18898,0.3622,0.18898,0.37008,0.18898,0.37795,0.18898,0.38583,0.18898,0.3937,0.18898,0.40157,0.18898,0.40945,0.18898,0.41732,0.18898,0.4252,0.18898,0.43307,0.18898,0.44094,0.18898,0.44882,0.18898,0.45669,0.18898,0.46457,0.18898,0.47244,0.18898,0.48031,0.18898,0.48819,0.18898,0.49606,0.18898,0.50394,0.18898,0.51181,0.18898,0.51969,0.18898,0.52756,0.18898,0.53543,0.18898,0.54331,0.18898,0.55118,0.18898,0.55906,0.18898,0.56693,0.18898,0.5748,0.18898,0.58268,0.18898,0.59055,0.18898,0.59843,0.18898,0.6063,0.18898,0.61417,0.18898,0.62205,0.18898,0.62992,0.18898,0.6378,0.18898,0.64567,0.18898,0.65354,0.18898,0.66142,0.18898,0.66929,0.18898,0.67717,0.18898,0.68504,0.18898,0.69291,0.18898,0.70079,0.18898,0.70866,0.18898,0.71654,0.18898,0.72441,0.18898,0.73228,0.18898,0.74016,0.18898,0.74803,0.18898,0.75591,0.18898,0.76378,0.18898,0.77165,0.18898,0.77953,0.18898,0.7874,0.18898,0.79528,0.18898,0.80315,0.18898,0.81102,0.18898,0.8189,0.18898,0.82677,0.18898,0.83465,0.18898,0.84252,0.18898,0.85039,0.18898,0.85827,0.18898,0.86614,0.18898,0.87402,0.18898,0.88189,0.18898,0.88976,0.18898,0.89764,0.18898,0.90551,0.18898,0.91339,0.18898,0.92126,0.18898,0.92913,0.18898,0.93701,0.18898,0.94488,0.18898,0.95276,0.18898,0.96063,0.18898,0.9685,0.18898,0.97638,0.18898,0.98425,0.18898,0.99213,0.18898,0.99609,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.19685,0.00787,0.19685,0.01575,0.19685,0.02362,0.19685,0.0315,0.19685,0.03937,0.19685,0.04724,0.19685,0.05512,0.19685,0.06299,0.19685,0.07087,0.19685,0.07874,0.19685,0.08661,0.19685,0.09449,0.19685,0.10236,0.19685,0.11024,0.19685,0.11811,0.19685,0.12598,0.19685,0.13386,0.19685,0.14173,0.19685,0.14961,0.19685,0.15748,0.19685,0.16535,0.19685,0.17323,0.19685,0.1811,0.19685,0.18898,0.19685,0.19685,0.19685,0.20472,0.19685,0.2126,0.19685,0.22047,0.19685,0.22835,0.19685,0.23622,0.19685,0.24409,0.19685,0.25197,0.19685,0.25984,0.19685,0.26772,0.19685,0.27559,0.19685,0.28346,0.19685,0.29134,0.19685,0.29921,0.19685,0.30709,0.19685,0.31496,0.19685,0.32283,0.19685,0.33071,0.19685,0.33858,0.19685,0.34646,0.19685,0.35433,0.19685,0.3622,0.19685,0.37008,0.19685,0.37795,0.19685,0.38583,0.19685,0.3937,0.19685,0.40157,0.19685,0.40945,0.19685,0.41732,0.19685,0.4252,0.19685,0.43307,0.19685,0.44094,0.19685,0.44882,0.19685,0.45669,0.19685,0.46457,0.19685,0.47244,0.19685,0.48031,0.19685,0.48819,0.19685,0.49606,0.19685,0.50394,0.19685,0.51181,0.19685,0.51969,0.19685,0.52756,0.19685,0.53543,0.19685,0.54331,0.19685,0.55118,0.19685,0.55906,0.19685,0.56693,0.19685,0.5748,0.19685,0.58268,0.19685,0.59055,0.19685,0.59843,0.19685,0.6063,0.19685,0.61417,0.19685,0.62205,0.19685,0.62992,0.19685,0.6378,0.19685,0.64567,0.19685,0.65354,0.19685,0.66142,0.19685,0.66929,0.19685,0.67717,0.19685,0.68504,0.19685,0.69291,0.19685,0.70079,0.19685,0.70866,0.19685,0.71654,0.19685,0.72441,0.19685,0.73228,0.19685,0.74016,0.19685,0.74803,0.19685,0.75591,0.19685,0.76378,0.19685,0.77165,0.19685,0.77953,0.19685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.7874,0.19685,0.79528,0.19685,0.80315,0.19685,0.81102,0.19685,0.8189,0.19685,0.82677,0.19685,0.83465,0.19685,0.84252,0.19685,0.85039,0.19685,0.85827,0.19685,0.86614,0.19685,0.87402,0.19685,0.88189,0.19685,0.88976,0.19685,0.89764,0.19685,0.90551,0.19685,0.91339,0.19685,0.92126,0.19685,0.92913,0.19685,0.93701,0.19685,0.94488,0.19685,0.95276,0.19685,0.96063,0.19685,0.9685,0.19685,0.97638,0.19685,0.98425,0.19685,0.99213,0.19685,0.99609,0.19685,0.00391,0.20472,0.00787,0.20472,0.01575,0.20472,0.02362,0.20472,0.0315,0.20472,0.03937,0.20472,0.04724,0.20472,0.05512,0.20472,0.06299,0.20472,0.07087,0.20472,0.07874,0.20472,0.08661,0.20472,0.09449,0.20472,0.10236,0.20472,0.11024,0.20472,0.11811,0.20472,0.12598,0.20472,0.13386,0.20472,0.14173,0.20472,0.14961,0.20472,0.15748,0.20472,0.16535,0.20472,0.17323,0.20472,0.1811,0.20472,0.18898,0.20472,0.19685,0.20472,0.20472,0.20472,0.2126,0.20472,0.22047,0.20472,0.22835,0.20472,0.23622,0.20472,0.24409,0.20472,0.25197,0.20472,0.25984,0.20472,0.26772,0.20472,0.27559,0.20472,0.28346,0.20472,0.29134,0.20472,0.29921,0.20472,0.30709,0.20472,0.31496,0.20472,0.32283,0.20472,0.33071,0.20472,0.33858,0.20472,0.34646,0.20472,0.35433,0.20472,0.3622,0.20472,0.37008,0.20472,0.37795,0.20472,0.38583,0.20472,0.3937,0.20472,0.40157,0.20472,0.40945,0.20472,0.41732,0.20472,0.4252,0.20472,0.43307,0.20472,0.44094,0.20472,0.44882,0.20472,0.45669,0.20472,0.46457,0.20472,0.47244,0.20472,0.48031,0.20472,0.48819,0.20472,0.49606,0.20472,0.50394,0.20472,0.51181,0.20472,0.51969,0.20472,0.52756,0.20472,0.53543,0.20472,0.54331,0.20472,0.55118,0.20472,0.55906,0.20472};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.56693,0.20472,0.5748,0.20472,0.58268,0.20472,0.59055,0.20472,0.59843,0.20472,0.6063,0.20472,0.61417,0.20472,0.62205,0.20472,0.62992,0.20472,0.6378,0.20472,0.64567,0.20472,0.65354,0.20472,0.66142,0.20472,0.66929,0.20472,0.67717,0.20472,0.68504,0.20472,0.69291,0.20472,0.70079,0.20472,0.70866,0.20472,0.71654,0.20472,0.72441,0.20472,0.73228,0.20472,0.74016,0.20472,0.74803,0.20472,0.75591,0.20472,0.76378,0.20472,0.77165,0.20472,0.77953,0.20472,0.7874,0.20472,0.79528,0.20472,0.80315,0.20472,0.81102,0.20472,0.8189,0.20472,0.82677,0.20472,0.83465,0.20472,0.84252,0.20472,0.85039,0.20472,0.85827,0.20472,0.86614,0.20472,0.87402,0.20472,0.88189,0.20472,0.88976,0.20472,0.89764,0.20472,0.90551,0.20472,0.91339,0.20472,0.92126,0.20472,0.92913,0.20472,0.93701,0.20472,0.94488,0.20472,0.95276,0.20472,0.96063,0.20472,0.9685,0.20472,0.97638,0.20472,0.98425,0.20472,0.99213,0.20472,0.99609,0.20472,0.00391,0.2126,0.00787,0.2126,0.01575,0.2126,0.02362,0.2126,0.0315,0.2126,0.03937,0.2126,0.04724,0.2126,0.05512,0.2126,0.06299,0.2126,0.07087,0.2126,0.07874,0.2126,0.08661,0.2126,0.09449,0.2126,0.10236,0.2126,0.11024,0.2126,0.11811,0.2126,0.12598,0.2126,0.13386,0.2126,0.14173,0.2126,0.14961,0.2126,0.15748,0.2126,0.16535,0.2126,0.17323,0.2126,0.1811,0.2126,0.18898,0.2126,0.19685,0.2126,0.20472,0.2126,0.2126,0.2126,0.22047,0.2126,0.22835,0.2126,0.23622,0.2126,0.24409,0.2126,0.25197,0.2126,0.25984,0.2126,0.26772,0.2126,0.27559,0.2126,0.28346,0.2126,0.29134,0.2126,0.29921,0.2126,0.30709,0.2126,0.31496,0.2126,0.32283,0.2126,0.33071,0.2126,0.33858,0.2126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.34646,0.2126,0.35433,0.2126,0.3622,0.2126,0.37008,0.2126,0.37795,0.2126,0.38583,0.2126,0.3937,0.2126,0.40157,0.2126,0.40945,0.2126,0.41732,0.2126,0.4252,0.2126,0.43307,0.2126,0.44094,0.2126,0.44882,0.2126,0.45669,0.2126,0.46457,0.2126,0.47244,0.2126,0.48031,0.2126,0.48819,0.2126,0.49606,0.2126,0.50394,0.2126,0.51181,0.2126,0.51969,0.2126,0.52756,0.2126,0.53543,0.2126,0.54331,0.2126,0.55118,0.2126,0.55906,0.2126,0.56693,0.2126,0.5748,0.2126,0.58268,0.2126,0.59055,0.2126,0.59843,0.2126,0.6063,0.2126,0.61417,0.2126,0.62205,0.2126,0.62992,0.2126,0.6378,0.2126,0.64567,0.2126,0.65354,0.2126,0.66142,0.2126,0.66929,0.2126,0.67717,0.2126,0.68504,0.2126,0.69291,0.2126,0.70079,0.2126,0.70866,0.2126,0.71654,0.2126,0.72441,0.2126,0.73228,0.2126,0.74016,0.2126,0.74803,0.2126,0.75591,0.2126,0.76378,0.2126,0.77165,0.2126,0.77953,0.2126,0.7874,0.2126,0.79528,0.2126,0.80315,0.2126,0.81102,0.2126,0.8189,0.2126,0.82677,0.2126,0.83465,0.2126,0.84252,0.2126,0.85039,0.2126,0.85827,0.2126,0.86614,0.2126,0.87402,0.2126,0.88189,0.2126,0.88976,0.2126,0.89764,0.2126,0.90551,0.2126,0.91339,0.2126,0.92126,0.2126,0.92913,0.2126,0.93701,0.2126,0.94488,0.2126,0.95276,0.2126,0.96063,0.2126,0.9685,0.2126,0.97638,0.2126,0.98425,0.2126,0.99213,0.2126,0.99609,0.2126,0.00391,0.22047,0.00787,0.22047,0.01575,0.22047,0.02362,0.22047,0.0315,0.22047,0.03937,0.22047,0.04724,0.22047,0.05512,0.22047,0.06299,0.22047,0.07087,0.22047,0.07874,0.22047,0.08661,0.22047,0.09449,0.22047,0.10236,0.22047,0.11024,0.22047,0.11811,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.12598,0.22047,0.13386,0.22047,0.14173,0.22047,0.14961,0.22047,0.15748,0.22047,0.16535,0.22047,0.17323,0.22047,0.1811,0.22047,0.18898,0.22047,0.19685,0.22047,0.20472,0.22047,0.2126,0.22047,0.22047,0.22047,0.22835,0.22047,0.23622,0.22047,0.24409,0.22047,0.25197,0.22047,0.25984,0.22047,0.26772,0.22047,0.27559,0.22047,0.28346,0.22047,0.29134,0.22047,0.29921,0.22047,0.30709,0.22047,0.31496,0.22047,0.32283,0.22047,0.33071,0.22047,0.33858,0.22047,0.34646,0.22047,0.35433,0.22047,0.3622,0.22047,0.37008,0.22047,0.37795,0.22047,0.38583,0.22047,0.3937,0.22047,0.40157,0.22047,0.40945,0.22047,0.41732,0.22047,0.4252,0.22047,0.43307,0.22047,0.44094,0.22047,0.44882,0.22047,0.45669,0.22047,0.46457,0.22047,0.47244,0.22047,0.48031,0.22047,0.48819,0.22047,0.49606,0.22047,0.50394,0.22047,0.51181,0.22047,0.51969,0.22047,0.52756,0.22047,0.53543,0.22047,0.54331,0.22047,0.55118,0.22047,0.55906,0.22047,0.56693,0.22047,0.5748,0.22047,0.58268,0.22047,0.59055,0.22047,0.59843,0.22047,0.6063,0.22047,0.61417,0.22047,0.62205,0.22047,0.62992,0.22047,0.6378,0.22047,0.64567,0.22047,0.65354,0.22047,0.66142,0.22047,0.66929,0.22047,0.67717,0.22047,0.68504,0.22047,0.69291,0.22047,0.70079,0.22047,0.70866,0.22047,0.71654,0.22047,0.72441,0.22047,0.73228,0.22047,0.74016,0.22047,0.74803,0.22047,0.75591,0.22047,0.76378,0.22047,0.77165,0.22047,0.77953,0.22047,0.7874,0.22047,0.79528,0.22047,0.80315,0.22047,0.81102,0.22047,0.8189,0.22047,0.82677,0.22047,0.83465,0.22047,0.84252,0.22047,0.85039,0.22047,0.85827,0.22047,0.86614,0.22047,0.87402,0.22047,0.88189,0.22047,0.88976,0.22047,0.89764,0.22047,0.90551,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.91339,0.22047,0.92126,0.22047,0.92913,0.22047,0.93701,0.22047,0.94488,0.22047,0.95276,0.22047,0.96063,0.22047,0.9685,0.22047,0.97638,0.22047,0.98425,0.22047,0.99213,0.22047,0.99609,0.22047,0.00391,0.22835,0.00787,0.22835,0.01575,0.22835,0.02362,0.22835,0.0315,0.22835,0.03937,0.22835,0.04724,0.22835,0.05512,0.22835,0.06299,0.22835,0.07087,0.22835,0.07874,0.22835,0.08661,0.22835,0.09449,0.22835,0.10236,0.22835,0.11024,0.22835,0.11811,0.22835,0.12598,0.22835,0.13386,0.22835,0.14173,0.22835,0.14961,0.22835,0.15748,0.22835,0.16535,0.22835,0.17323,0.22835,0.1811,0.22835,0.18898,0.22835,0.19685,0.22835,0.20472,0.22835,0.2126,0.22835,0.22047,0.22835,0.22835,0.22835,0.23622,0.22835,0.24409,0.22835,0.25197,0.22835,0.25984,0.22835,0.26772,0.22835,0.27559,0.22835,0.28346,0.22835,0.29134,0.22835,0.29921,0.22835,0.30709,0.22835,0.31496,0.22835,0.32283,0.22835,0.33071,0.22835,0.33858,0.22835,0.34646,0.22835,0.35433,0.22835,0.3622,0.22835,0.37008,0.22835,0.37795,0.22835,0.38583,0.22835,0.3937,0.22835,0.40157,0.22835,0.40945,0.22835,0.41732,0.22835,0.4252,0.22835,0.43307,0.22835,0.44094,0.22835,0.44882,0.22835,0.45669,0.22835,0.46457,0.22835,0.47244,0.22835,0.48031,0.22835,0.48819,0.22835,0.49606,0.22835,0.50394,0.22835,0.51181,0.22835,0.51969,0.22835,0.52756,0.22835,0.53543,0.22835,0.54331,0.22835,0.55118,0.22835,0.55906,0.22835,0.56693,0.22835,0.5748,0.22835,0.58268,0.22835,0.59055,0.22835,0.59843,0.22835,0.6063,0.22835,0.61417,0.22835,0.62205,0.22835,0.62992,0.22835,0.6378,0.22835,0.64567,0.22835,0.65354,0.22835,0.66142,0.22835,0.66929,0.22835,0.67717,0.22835,0.68504,0.22835};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.69291,0.22835,0.70079,0.22835,0.70866,0.22835,0.71654,0.22835,0.72441,0.22835,0.73228,0.22835,0.74016,0.22835,0.74803,0.22835,0.75591,0.22835,0.76378,0.22835,0.77165,0.22835,0.77953,0.22835,0.7874,0.22835,0.79528,0.22835,0.80315,0.22835,0.81102,0.22835,0.8189,0.22835,0.82677,0.22835,0.83465,0.22835,0.84252,0.22835,0.85039,0.22835,0.85827,0.22835,0.86614,0.22835,0.87402,0.22835,0.88189,0.22835,0.88976,0.22835,0.89764,0.22835,0.90551,0.22835,0.91339,0.22835,0.92126,0.22835,0.92913,0.22835,0.93701,0.22835,0.94488,0.22835,0.95276,0.22835,0.96063,0.22835,0.9685,0.22835,0.97638,0.22835,0.98425,0.22835,0.99213,0.22835,0.99609,0.22835,0.00391,0.23622,0.00787,0.23622,0.01575,0.23622,0.02362,0.23622,0.0315,0.23622,0.03937,0.23622,0.04724,0.23622,0.05512,0.23622,0.06299,0.23622,0.07087,0.23622,0.07874,0.23622,0.08661,0.23622,0.09449,0.23622,0.10236,0.23622,0.11024,0.23622,0.11811,0.23622,0.12598,0.23622,0.13386,0.23622,0.14173,0.23622,0.14961,0.23622,0.15748,0.23622,0.16535,0.23622,0.17323,0.23622,0.1811,0.23622,0.18898,0.23622,0.19685,0.23622,0.20472,0.23622,0.2126,0.23622,0.22047,0.23622,0.22835,0.23622,0.23622,0.23622,0.24409,0.23622,0.25197,0.23622,0.25984,0.23622,0.26772,0.23622,0.27559,0.23622,0.28346,0.23622,0.29134,0.23622,0.29921,0.23622,0.30709,0.23622,0.31496,0.23622,0.32283,0.23622,0.33071,0.23622,0.33858,0.23622,0.34646,0.23622,0.35433,0.23622,0.3622,0.23622,0.37008,0.23622,0.37795,0.23622,0.38583,0.23622,0.3937,0.23622,0.40157,0.23622,0.40945,0.23622,0.41732,0.23622,0.4252,0.23622,0.43307,0.23622,0.44094,0.23622,0.44882,0.23622,0.45669,0.23622,0.46457,0.23622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.47244,0.23622,0.48031,0.23622,0.48819,0.23622,0.49606,0.23622,0.50394,0.23622,0.51181,0.23622,0.51969,0.23622,0.52756,0.23622,0.53543,0.23622,0.54331,0.23622,0.55118,0.23622,0.55906,0.23622,0.56693,0.23622,0.5748,0.23622,0.58268,0.23622,0.59055,0.23622,0.59843,0.23622,0.6063,0.23622,0.61417,0.23622,0.62205,0.23622,0.62992,0.23622,0.6378,0.23622,0.64567,0.23622,0.65354,0.23622,0.66142,0.23622,0.66929,0.23622,0.67717,0.23622,0.68504,0.23622,0.69291,0.23622,0.70079,0.23622,0.70866,0.23622,0.71654,0.23622,0.72441,0.23622,0.73228,0.23622,0.74016,0.23622,0.74803,0.23622,0.75591,0.23622,0.76378,0.23622,0.77165,0.23622,0.77953,0.23622,0.7874,0.23622,0.79528,0.23622,0.80315,0.23622,0.81102,0.23622,0.8189,0.23622,0.82677,0.23622,0.83465,0.23622,0.84252,0.23622,0.85039,0.23622,0.85827,0.23622,0.86614,0.23622,0.87402,0.23622,0.88189,0.23622,0.88976,0.23622,0.89764,0.23622,0.90551,0.23622,0.91339,0.23622,0.92126,0.23622,0.92913,0.23622,0.93701,0.23622,0.94488,0.23622,0.95276,0.23622,0.96063,0.23622,0.9685,0.23622,0.97638,0.23622,0.98425,0.23622,0.99213,0.23622,0.99609,0.23622,0.00391,0.24409,0.00787,0.24409,0.01575,0.24409,0.02362,0.24409,0.0315,0.24409,0.03937,0.24409,0.04724,0.24409,0.05512,0.24409,0.06299,0.24409,0.07087,0.24409,0.07874,0.24409,0.08661,0.24409,0.09449,0.24409,0.10236,0.24409,0.11024,0.24409,0.11811,0.24409,0.12598,0.24409,0.13386,0.24409,0.14173,0.24409,0.14961,0.24409,0.15748,0.24409,0.16535,0.24409,0.17323,0.24409,0.1811,0.24409,0.18898,0.24409,0.19685,0.24409,0.20472,0.24409,0.2126,0.24409,0.22047,0.24409,0.22835,0.24409,0.23622,0.24409,0.24409,0.24409};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.25197,0.24409,0.25984,0.24409,0.26772,0.24409,0.27559,0.24409,0.28346,0.24409,0.29134,0.24409,0.29921,0.24409,0.30709,0.24409,0.31496,0.24409,0.32283,0.24409,0.33071,0.24409,0.33858,0.24409,0.34646,0.24409,0.35433,0.24409,0.3622,0.24409,0.37008,0.24409,0.37795,0.24409,0.38583,0.24409,0.3937,0.24409,0.40157,0.24409,0.40945,0.24409,0.41732,0.24409,0.4252,0.24409,0.43307,0.24409,0.44094,0.24409,0.44882,0.24409,0.45669,0.24409,0.46457,0.24409,0.47244,0.24409,0.48031,0.24409,0.48819,0.24409,0.49606,0.24409,0.50394,0.24409,0.51181,0.24409,0.51969,0.24409,0.52756,0.24409,0.53543,0.24409,0.54331,0.24409,0.55118,0.24409,0.55906,0.24409,0.56693,0.24409,0.5748,0.24409,0.58268,0.24409,0.59055,0.24409,0.59843,0.24409,0.6063,0.24409,0.61417,0.24409,0.62205,0.24409,0.62992,0.24409,0.6378,0.24409,0.64567,0.24409,0.65354,0.24409,0.66142,0.24409,0.66929,0.24409,0.67717,0.24409,0.68504,0.24409,0.69291,0.24409,0.70079,0.24409,0.70866,0.24409,0.71654,0.24409,0.72441,0.24409,0.73228,0.24409,0.74016,0.24409,0.74803,0.24409,0.75591,0.24409,0.76378,0.24409,0.77165,0.24409,0.77953,0.24409,0.7874,0.24409,0.79528,0.24409,0.80315,0.24409,0.81102,0.24409,0.8189,0.24409,0.82677,0.24409,0.83465,0.24409,0.84252,0.24409,0.85039,0.24409,0.85827,0.24409,0.86614,0.24409,0.87402,0.24409,0.88189,0.24409,0.88976,0.24409,0.89764,0.24409,0.90551,0.24409,0.91339,0.24409,0.92126,0.24409,0.92913,0.24409,0.93701,0.24409,0.94488,0.24409,0.95276,0.24409,0.96063,0.24409,0.9685,0.24409,0.97638,0.24409,0.98425,0.24409,0.99213,0.24409,0.99609,0.24409,0.00391,0.25197,0.00787,0.25197,0.01575,0.25197,0.02362,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_42()
		{
			double[] value = {0.0315,0.25197,0.03937,0.25197,0.04724,0.25197,0.05512,0.25197,0.06299,0.25197,0.07087,0.25197,0.07874,0.25197,0.08661,0.25197,0.09449,0.25197,0.10236,0.25197,0.11024,0.25197,0.11811,0.25197,0.12598,0.25197,0.13386,0.25197,0.14173,0.25197,0.14961,0.25197,0.15748,0.25197,0.16535,0.25197,0.17323,0.25197,0.1811,0.25197,0.18898,0.25197,0.19685,0.25197,0.20472,0.25197,0.2126,0.25197,0.22047,0.25197,0.22835,0.25197,0.23622,0.25197,0.24409,0.25197,0.25197,0.25197,0.25984,0.25197,0.26772,0.25197,0.27559,0.25197,0.28346,0.25197,0.29134,0.25197,0.29921,0.25197,0.30709,0.25197,0.31496,0.25197,0.32283,0.25197,0.33071,0.25197,0.33858,0.25197,0.34646,0.25197,0.35433,0.25197,0.3622,0.25197,0.37008,0.25197,0.37795,0.25197,0.38583,0.25197,0.3937,0.25197,0.40157,0.25197,0.40945,0.25197,0.41732,0.25197,0.4252,0.25197,0.43307,0.25197,0.44094,0.25197,0.44882,0.25197,0.45669,0.25197,0.46457,0.25197,0.47244,0.25197,0.48031,0.25197,0.48819,0.25197,0.49606,0.25197,0.50394,0.25197,0.51181,0.25197,0.51969,0.25197,0.52756,0.25197,0.53543,0.25197,0.54331,0.25197,0.55118,0.25197,0.55906,0.25197,0.56693,0.25197,0.5748,0.25197,0.58268,0.25197,0.59055,0.25197,0.59843,0.25197,0.6063,0.25197,0.61417,0.25197,0.62205,0.25197,0.62992,0.25197,0.6378,0.25197,0.64567,0.25197,0.65354,0.25197,0.66142,0.25197,0.66929,0.25197,0.67717,0.25197,0.68504,0.25197,0.69291,0.25197,0.70079,0.25197,0.70866,0.25197,0.71654,0.25197,0.72441,0.25197,0.73228,0.25197,0.74016,0.25197,0.74803,0.25197,0.75591,0.25197,0.76378,0.25197,0.77165,0.25197,0.77953,0.25197,0.7874,0.25197,0.79528,0.25197,0.80315,0.25197,0.81102,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_43()
		{
			double[] value = {0.8189,0.25197,0.82677,0.25197,0.83465,0.25197,0.84252,0.25197,0.85039,0.25197,0.85827,0.25197,0.86614,0.25197,0.87402,0.25197,0.88189,0.25197,0.88976,0.25197,0.89764,0.25197,0.90551,0.25197,0.91339,0.25197,0.92126,0.25197,0.92913,0.25197,0.93701,0.25197,0.94488,0.25197,0.95276,0.25197,0.96063,0.25197,0.9685,0.25197,0.97638,0.25197,0.98425,0.25197,0.99213,0.25197,0.99609,0.25197,0.00391,0.25984,0.00787,0.25984,0.01575,0.25984,0.02362,0.25984,0.0315,0.25984,0.03937,0.25984,0.04724,0.25984,0.05512,0.25984,0.06299,0.25984,0.07087,0.25984,0.07874,0.25984,0.08661,0.25984,0.09449,0.25984,0.10236,0.25984,0.11024,0.25984,0.11811,0.25984,0.12598,0.25984,0.13386,0.25984,0.14173,0.25984,0.14961,0.25984,0.15748,0.25984,0.16535,0.25984,0.17323,0.25984,0.1811,0.25984,0.18898,0.25984,0.19685,0.25984,0.20472,0.25984,0.2126,0.25984,0.22047,0.25984,0.22835,0.25984,0.23622,0.25984,0.24409,0.25984,0.25197,0.25984,0.25984,0.25984,0.26772,0.25984,0.27559,0.25984,0.28346,0.25984,0.29134,0.25984,0.29921,0.25984,0.30709,0.25984,0.31496,0.25984,0.32283,0.25984,0.33071,0.25984,0.33858,0.25984,0.34646,0.25984,0.35433,0.25984,0.3622,0.25984,0.37008,0.25984,0.37795,0.25984,0.38583,0.25984,0.3937,0.25984,0.40157,0.25984,0.40945,0.25984,0.41732,0.25984,0.4252,0.25984,0.43307,0.25984,0.44094,0.25984,0.44882,0.25984,0.45669,0.25984,0.46457,0.25984,0.47244,0.25984,0.48031,0.25984,0.48819,0.25984,0.49606,0.25984,0.50394,0.25984,0.51181,0.25984,0.51969,0.25984,0.52756,0.25984,0.53543,0.25984,0.54331,0.25984,0.55118,0.25984,0.55906,0.25984,0.56693,0.25984,0.5748,0.25984,0.58268,0.25984,0.59055,0.25984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_44()
		{
			double[] value = {0.59843,0.25984,0.6063,0.25984,0.61417,0.25984,0.62205,0.25984,0.62992,0.25984,0.6378,0.25984,0.64567,0.25984,0.65354,0.25984,0.66142,0.25984,0.66929,0.25984,0.67717,0.25984,0.68504,0.25984,0.69291,0.25984,0.70079,0.25984,0.70866,0.25984,0.71654,0.25984,0.72441,0.25984,0.73228,0.25984,0.74016,0.25984,0.74803,0.25984,0.75591,0.25984,0.76378,0.25984,0.77165,0.25984,0.77953,0.25984,0.7874,0.25984,0.79528,0.25984,0.80315,0.25984,0.81102,0.25984,0.8189,0.25984,0.82677,0.25984,0.83465,0.25984,0.84252,0.25984,0.85039,0.25984,0.85827,0.25984,0.86614,0.25984,0.87402,0.25984,0.88189,0.25984,0.88976,0.25984,0.89764,0.25984,0.90551,0.25984,0.91339,0.25984,0.92126,0.25984,0.92913,0.25984,0.93701,0.25984,0.94488,0.25984,0.95276,0.25984,0.96063,0.25984,0.9685,0.25984,0.97638,0.25984,0.98425,0.25984,0.99213,0.25984,0.99609,0.25984,0.00391,0.26772,0.00787,0.26772,0.01575,0.26772,0.02362,0.26772,0.0315,0.26772,0.03937,0.26772,0.04724,0.26772,0.05512,0.26772,0.06299,0.26772,0.07087,0.26772,0.07874,0.26772,0.08661,0.26772,0.09449,0.26772,0.10236,0.26772,0.11024,0.26772,0.11811,0.26772,0.12598,0.26772,0.13386,0.26772,0.14173,0.26772,0.14961,0.26772,0.15748,0.26772,0.16535,0.26772,0.17323,0.26772,0.1811,0.26772,0.18898,0.26772,0.19685,0.26772,0.20472,0.26772,0.2126,0.26772,0.22047,0.26772,0.22835,0.26772,0.23622,0.26772,0.24409,0.26772,0.25197,0.26772,0.25984,0.26772,0.26772,0.26772,0.27559,0.26772,0.28346,0.26772,0.29134,0.26772,0.29921,0.26772,0.30709,0.26772,0.31496,0.26772,0.32283,0.26772,0.33071,0.26772,0.33858,0.26772,0.34646,0.26772,0.35433,0.26772,0.3622,0.26772,0.37008,0.26772};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_45()
		{
			double[] value = {0.37795,0.26772,0.38583,0.26772,0.3937,0.26772,0.40157,0.26772,0.40945,0.26772,0.41732,0.26772,0.4252,0.26772,0.43307,0.26772,0.44094,0.26772,0.44882,0.26772,0.45669,0.26772,0.46457,0.26772,0.47244,0.26772,0.48031,0.26772,0.48819,0.26772,0.49606,0.26772,0.50394,0.26772,0.51181,0.26772,0.51969,0.26772,0.52756,0.26772,0.53543,0.26772,0.54331,0.26772,0.55118,0.26772,0.55906,0.26772,0.56693,0.26772,0.5748,0.26772,0.58268,0.26772,0.59055,0.26772,0.59843,0.26772,0.6063,0.26772,0.61417,0.26772,0.62205,0.26772,0.62992,0.26772,0.6378,0.26772,0.64567,0.26772,0.65354,0.26772,0.66142,0.26772,0.66929,0.26772,0.67717,0.26772,0.68504,0.26772,0.69291,0.26772,0.70079,0.26772,0.70866,0.26772,0.71654,0.26772,0.72441,0.26772,0.73228,0.26772,0.74016,0.26772,0.74803,0.26772,0.75591,0.26772,0.76378,0.26772,0.77165,0.26772,0.77953,0.26772,0.7874,0.26772,0.79528,0.26772,0.80315,0.26772,0.81102,0.26772,0.8189,0.26772,0.82677,0.26772,0.83465,0.26772,0.84252,0.26772,0.85039,0.26772,0.85827,0.26772,0.86614,0.26772,0.87402,0.26772,0.88189,0.26772,0.88976,0.26772,0.89764,0.26772,0.90551,0.26772,0.91339,0.26772,0.92126,0.26772,0.92913,0.26772,0.93701,0.26772,0.94488,0.26772,0.95276,0.26772,0.96063,0.26772,0.9685,0.26772,0.97638,0.26772,0.98425,0.26772,0.99213,0.26772,0.99609,0.26772,0.00391,0.27559,0.00787,0.27559,0.01575,0.27559,0.02362,0.27559,0.0315,0.27559,0.03937,0.27559,0.04724,0.27559,0.05512,0.27559,0.06299,0.27559,0.07087,0.27559,0.07874,0.27559,0.08661,0.27559,0.09449,0.27559,0.10236,0.27559,0.11024,0.27559,0.11811,0.27559,0.12598,0.27559,0.13386,0.27559,0.14173,0.27559,0.14961,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_46()
		{
			double[] value = {0.15748,0.27559,0.16535,0.27559,0.17323,0.27559,0.1811,0.27559,0.18898,0.27559,0.19685,0.27559,0.20472,0.27559,0.2126,0.27559,0.22047,0.27559,0.22835,0.27559,0.23622,0.27559,0.24409,0.27559,0.25197,0.27559,0.25984,0.27559,0.26772,0.27559,0.27559,0.27559,0.28346,0.27559,0.29134,0.27559,0.29921,0.27559,0.30709,0.27559,0.31496,0.27559,0.32283,0.27559,0.33071,0.27559,0.33858,0.27559,0.34646,0.27559,0.35433,0.27559,0.3622,0.27559,0.37008,0.27559,0.37795,0.27559,0.38583,0.27559,0.3937,0.27559,0.40157,0.27559,0.40945,0.27559,0.41732,0.27559,0.4252,0.27559,0.43307,0.27559,0.44094,0.27559,0.44882,0.27559,0.45669,0.27559,0.46457,0.27559,0.47244,0.27559,0.48031,0.27559,0.48819,0.27559,0.49606,0.27559,0.50394,0.27559,0.51181,0.27559,0.51969,0.27559,0.52756,0.27559,0.53543,0.27559,0.54331,0.27559,0.55118,0.27559,0.55906,0.27559,0.56693,0.27559,0.5748,0.27559,0.58268,0.27559,0.59055,0.27559,0.59843,0.27559,0.6063,0.27559,0.61417,0.27559,0.62205,0.27559,0.62992,0.27559,0.6378,0.27559,0.64567,0.27559,0.65354,0.27559,0.66142,0.27559,0.66929,0.27559,0.67717,0.27559,0.68504,0.27559,0.69291,0.27559,0.70079,0.27559,0.70866,0.27559,0.71654,0.27559,0.72441,0.27559,0.73228,0.27559,0.74016,0.27559,0.74803,0.27559,0.75591,0.27559,0.76378,0.27559,0.77165,0.27559,0.77953,0.27559,0.7874,0.27559,0.79528,0.27559,0.80315,0.27559,0.81102,0.27559,0.8189,0.27559,0.82677,0.27559,0.83465,0.27559,0.84252,0.27559,0.85039,0.27559,0.85827,0.27559,0.86614,0.27559,0.87402,0.27559,0.88189,0.27559,0.88976,0.27559,0.89764,0.27559,0.90551,0.27559,0.91339,0.27559,0.92126,0.27559,0.92913,0.27559,0.93701,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_47()
		{
			double[] value = {0.94488,0.27559,0.95276,0.27559,0.96063,0.27559,0.9685,0.27559,0.97638,0.27559,0.98425,0.27559,0.99213,0.27559,0.99609,0.27559,0.00391,0.28346,0.00787,0.28346,0.01575,0.28346,0.02362,0.28346,0.0315,0.28346,0.03937,0.28346,0.04724,0.28346,0.05512,0.28346,0.06299,0.28346,0.07087,0.28346,0.07874,0.28346,0.08661,0.28346,0.09449,0.28346,0.10236,0.28346,0.11024,0.28346,0.11811,0.28346,0.12598,0.28346,0.13386,0.28346,0.14173,0.28346,0.14961,0.28346,0.15748,0.28346,0.16535,0.28346,0.17323,0.28346,0.1811,0.28346,0.18898,0.28346,0.19685,0.28346,0.20472,0.28346,0.2126,0.28346,0.22047,0.28346,0.22835,0.28346,0.23622,0.28346,0.24409,0.28346,0.25197,0.28346,0.25984,0.28346,0.26772,0.28346,0.27559,0.28346,0.28346,0.28346,0.29134,0.28346,0.29921,0.28346,0.30709,0.28346,0.31496,0.28346,0.32283,0.28346,0.33071,0.28346,0.33858,0.28346,0.34646,0.28346,0.35433,0.28346,0.3622,0.28346,0.37008,0.28346,0.37795,0.28346,0.38583,0.28346,0.3937,0.28346,0.40157,0.28346,0.40945,0.28346,0.41732,0.28346,0.4252,0.28346,0.43307,0.28346,0.44094,0.28346,0.44882,0.28346,0.45669,0.28346,0.46457,0.28346,0.47244,0.28346,0.48031,0.28346,0.48819,0.28346,0.49606,0.28346,0.50394,0.28346,0.51181,0.28346,0.51969,0.28346,0.52756,0.28346,0.53543,0.28346,0.54331,0.28346,0.55118,0.28346,0.55906,0.28346,0.56693,0.28346,0.5748,0.28346,0.58268,0.28346,0.59055,0.28346,0.59843,0.28346,0.6063,0.28346,0.61417,0.28346,0.62205,0.28346,0.62992,0.28346,0.6378,0.28346,0.64567,0.28346,0.65354,0.28346,0.66142,0.28346,0.66929,0.28346,0.67717,0.28346,0.68504,0.28346,0.69291,0.28346,0.70079,0.28346,0.70866,0.28346,0.71654,0.28346};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_48()
		{
			double[] value = {0.72441,0.28346,0.73228,0.28346,0.74016,0.28346,0.74803,0.28346,0.75591,0.28346,0.76378,0.28346,0.77165,0.28346,0.77953,0.28346,0.7874,0.28346,0.79528,0.28346,0.80315,0.28346,0.81102,0.28346,0.8189,0.28346,0.82677,0.28346,0.83465,0.28346,0.84252,0.28346,0.85039,0.28346,0.85827,0.28346,0.86614,0.28346,0.87402,0.28346,0.88189,0.28346,0.88976,0.28346,0.89764,0.28346,0.90551,0.28346,0.91339,0.28346,0.92126,0.28346,0.92913,0.28346,0.93701,0.28346,0.94488,0.28346,0.95276,0.28346,0.96063,0.28346,0.9685,0.28346,0.97638,0.28346,0.98425,0.28346,0.99213,0.28346,0.99609,0.28346,0.00391,0.29134,0.00787,0.29134,0.01575,0.29134,0.02362,0.29134,0.0315,0.29134,0.03937,0.29134,0.04724,0.29134,0.05512,0.29134,0.06299,0.29134,0.07087,0.29134,0.07874,0.29134,0.08661,0.29134,0.09449,0.29134,0.10236,0.29134,0.11024,0.29134,0.11811,0.29134,0.12598,0.29134,0.13386,0.29134,0.14173,0.29134,0.14961,0.29134,0.15748,0.29134,0.16535,0.29134,0.17323,0.29134,0.1811,0.29134,0.18898,0.29134,0.19685,0.29134,0.20472,0.29134,0.2126,0.29134,0.22047,0.29134,0.22835,0.29134,0.23622,0.29134,0.24409,0.29134,0.25197,0.29134,0.25984,0.29134,0.26772,0.29134,0.27559,0.29134,0.28346,0.29134,0.29134,0.29134,0.29921,0.29134,0.30709,0.29134,0.31496,0.29134,0.32283,0.29134,0.33071,0.29134,0.33858,0.29134,0.34646,0.29134,0.35433,0.29134,0.3622,0.29134,0.37008,0.29134,0.37795,0.29134,0.38583,0.29134,0.3937,0.29134,0.40157,0.29134,0.40945,0.29134,0.41732,0.29134,0.4252,0.29134,0.43307,0.29134,0.44094,0.29134,0.44882,0.29134,0.45669,0.29134,0.46457,0.29134,0.47244,0.29134,0.48031,0.29134,0.48819,0.29134,0.49606,0.29134};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_49()
		{
			double[] value = {0.50394,0.29134,0.51181,0.29134,0.51969,0.29134,0.52756,0.29134,0.53543,0.29134,0.54331,0.29134,0.55118,0.29134,0.55906,0.29134,0.56693,0.29134,0.5748,0.29134,0.58268,0.29134,0.59055,0.29134,0.59843,0.29134,0.6063,0.29134,0.61417,0.29134,0.62205,0.29134,0.62992,0.29134,0.6378,0.29134,0.64567,0.29134,0.65354,0.29134,0.66142,0.29134,0.66929,0.29134,0.67717,0.29134,0.68504,0.29134,0.69291,0.29134,0.70079,0.29134,0.70866,0.29134,0.71654,0.29134,0.72441,0.29134,0.73228,0.29134,0.74016,0.29134,0.74803,0.29134,0.75591,0.29134,0.76378,0.29134,0.77165,0.29134,0.77953,0.29134,0.7874,0.29134,0.79528,0.29134,0.80315,0.29134,0.81102,0.29134,0.8189,0.29134,0.82677,0.29134,0.83465,0.29134,0.84252,0.29134,0.85039,0.29134,0.85827,0.29134,0.86614,0.29134,0.87402,0.29134,0.88189,0.29134,0.88976,0.29134,0.89764,0.29134,0.90551,0.29134,0.91339,0.29134,0.92126,0.29134,0.92913,0.29134,0.93701,0.29134,0.94488,0.29134,0.95276,0.29134,0.96063,0.29134,0.9685,0.29134,0.97638,0.29134,0.98425,0.29134,0.99213,0.29134,0.99609,0.29134,0.00391,0.29921,0.00787,0.29921,0.01575,0.29921,0.02362,0.29921,0.0315,0.29921,0.03937,0.29921,0.04724,0.29921,0.05512,0.29921,0.06299,0.29921,0.07087,0.29921,0.07874,0.29921,0.08661,0.29921,0.09449,0.29921,0.10236,0.29921,0.11024,0.29921,0.11811,0.29921,0.12598,0.29921,0.13386,0.29921,0.14173,0.29921,0.14961,0.29921,0.15748,0.29921,0.16535,0.29921,0.17323,0.29921,0.1811,0.29921,0.18898,0.29921,0.19685,0.29921,0.20472,0.29921,0.2126,0.29921,0.22047,0.29921,0.22835,0.29921,0.23622,0.29921,0.24409,0.29921,0.25197,0.29921,0.25984,0.29921,0.26772,0.29921,0.27559,0.29921};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_50()
		{
			double[] value = {0.28346,0.29921,0.29134,0.29921,0.29921,0.29921,0.30709,0.29921,0.31496,0.29921,0.32283,0.29921,0.33071,0.29921,0.33858,0.29921,0.34646,0.29921,0.35433,0.29921,0.3622,0.29921,0.37008,0.29921,0.37795,0.29921,0.38583,0.29921,0.3937,0.29921,0.40157,0.29921,0.40945,0.29921,0.41732,0.29921,0.4252,0.29921,0.43307,0.29921,0.44094,0.29921,0.44882,0.29921,0.45669,0.29921,0.46457,0.29921,0.47244,0.29921,0.48031,0.29921,0.48819,0.29921,0.49606,0.29921,0.50394,0.29921,0.51181,0.29921,0.51969,0.29921,0.52756,0.29921,0.53543,0.29921,0.54331,0.29921,0.55118,0.29921,0.55906,0.29921,0.56693,0.29921,0.5748,0.29921,0.58268,0.29921,0.59055,0.29921,0.59843,0.29921,0.6063,0.29921,0.61417,0.29921,0.62205,0.29921,0.62992,0.29921,0.6378,0.29921,0.64567,0.29921,0.65354,0.29921,0.66142,0.29921,0.66929,0.29921,0.67717,0.29921,0.68504,0.29921,0.69291,0.29921,0.70079,0.29921,0.70866,0.29921,0.71654,0.29921,0.72441,0.29921,0.73228,0.29921,0.74016,0.29921,0.74803,0.29921,0.75591,0.29921,0.76378,0.29921,0.77165,0.29921,0.77953,0.29921,0.7874,0.29921,0.79528,0.29921,0.80315,0.29921,0.81102,0.29921,0.8189,0.29921,0.82677,0.29921,0.83465,0.29921,0.84252,0.29921,0.85039,0.29921,0.85827,0.29921,0.86614,0.29921,0.87402,0.29921,0.88189,0.29921,0.88976,0.29921,0.89764,0.29921,0.90551,0.29921,0.91339,0.29921,0.92126,0.29921,0.92913,0.29921,0.93701,0.29921,0.94488,0.29921,0.95276,0.29921,0.96063,0.29921,0.9685,0.29921,0.97638,0.29921,0.98425,0.29921,0.99213,0.29921,0.99609,0.29921,0.00391,0.30709,0.00787,0.30709,0.01575,0.30709,0.02362,0.30709,0.0315,0.30709,0.03937,0.30709,0.04724,0.30709,0.05512,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_51()
		{
			double[] value = {0.06299,0.30709,0.07087,0.30709,0.07874,0.30709,0.08661,0.30709,0.09449,0.30709,0.10236,0.30709,0.11024,0.30709,0.11811,0.30709,0.12598,0.30709,0.13386,0.30709,0.14173,0.30709,0.14961,0.30709,0.15748,0.30709,0.16535,0.30709,0.17323,0.30709,0.1811,0.30709,0.18898,0.30709,0.19685,0.30709,0.20472,0.30709,0.2126,0.30709,0.22047,0.30709,0.22835,0.30709,0.23622,0.30709,0.24409,0.30709,0.25197,0.30709,0.25984,0.30709,0.26772,0.30709,0.27559,0.30709,0.28346,0.30709,0.29134,0.30709,0.29921,0.30709,0.30709,0.30709,0.31496,0.30709,0.32283,0.30709,0.33071,0.30709,0.33858,0.30709,0.34646,0.30709,0.35433,0.30709,0.3622,0.30709,0.37008,0.30709,0.37795,0.30709,0.38583,0.30709,0.3937,0.30709,0.40157,0.30709,0.40945,0.30709,0.41732,0.30709,0.4252,0.30709,0.43307,0.30709,0.44094,0.30709,0.44882,0.30709,0.45669,0.30709,0.46457,0.30709,0.47244,0.30709,0.48031,0.30709,0.48819,0.30709,0.49606,0.30709,0.50394,0.30709,0.51181,0.30709,0.51969,0.30709,0.52756,0.30709,0.53543,0.30709,0.54331,0.30709,0.55118,0.30709,0.55906,0.30709,0.56693,0.30709,0.5748,0.30709,0.58268,0.30709,0.59055,0.30709,0.59843,0.30709,0.6063,0.30709,0.61417,0.30709,0.62205,0.30709,0.62992,0.30709,0.6378,0.30709,0.64567,0.30709,0.65354,0.30709,0.66142,0.30709,0.66929,0.30709,0.67717,0.30709,0.68504,0.30709,0.69291,0.30709,0.70079,0.30709,0.70866,0.30709,0.71654,0.30709,0.72441,0.30709,0.73228,0.30709,0.74016,0.30709,0.74803,0.30709,0.75591,0.30709,0.76378,0.30709,0.77165,0.30709,0.77953,0.30709,0.7874,0.30709,0.79528,0.30709,0.80315,0.30709,0.81102,0.30709,0.8189,0.30709,0.82677,0.30709,0.83465,0.30709,0.84252,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_52()
		{
			double[] value = {0.85039,0.30709,0.85827,0.30709,0.86614,0.30709,0.87402,0.30709,0.88189,0.30709,0.88976,0.30709,0.89764,0.30709,0.90551,0.30709,0.91339,0.30709,0.92126,0.30709,0.92913,0.30709,0.93701,0.30709,0.94488,0.30709,0.95276,0.30709,0.96063,0.30709,0.9685,0.30709,0.97638,0.30709,0.98425,0.30709,0.99213,0.30709,0.99609,0.30709,0.00391,0.31496,0.00787,0.31496,0.01575,0.31496,0.02362,0.31496,0.0315,0.31496,0.03937,0.31496,0.04724,0.31496,0.05512,0.31496,0.06299,0.31496,0.07087,0.31496,0.07874,0.31496,0.08661,0.31496,0.09449,0.31496,0.10236,0.31496,0.11024,0.31496,0.11811,0.31496,0.12598,0.31496,0.13386,0.31496,0.14173,0.31496,0.14961,0.31496,0.15748,0.31496,0.16535,0.31496,0.17323,0.31496,0.1811,0.31496,0.18898,0.31496,0.19685,0.31496,0.20472,0.31496,0.2126,0.31496,0.22047,0.31496,0.22835,0.31496,0.23622,0.31496,0.24409,0.31496,0.25197,0.31496,0.25984,0.31496,0.26772,0.31496,0.27559,0.31496,0.28346,0.31496,0.29134,0.31496,0.29921,0.31496,0.30709,0.31496,0.31496,0.31496,0.32283,0.31496,0.33071,0.31496,0.33858,0.31496,0.34646,0.31496,0.35433,0.31496,0.3622,0.31496,0.37008,0.31496,0.37795,0.31496,0.38583,0.31496,0.3937,0.31496,0.40157,0.31496,0.40945,0.31496,0.41732,0.31496,0.4252,0.31496,0.43307,0.31496,0.44094,0.31496,0.44882,0.31496,0.45669,0.31496,0.46457,0.31496,0.47244,0.31496,0.48031,0.31496,0.48819,0.31496,0.49606,0.31496,0.50394,0.31496,0.51181,0.31496,0.51969,0.31496,0.52756,0.31496,0.53543,0.31496,0.54331,0.31496,0.55118,0.31496,0.55906,0.31496,0.56693,0.31496,0.5748,0.31496,0.58268,0.31496,0.59055,0.31496,0.59843,0.31496,0.6063,0.31496,0.61417,0.31496,0.62205,0.31496};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_53()
		{
			double[] value = {0.62992,0.31496,0.6378,0.31496,0.64567,0.31496,0.65354,0.31496,0.66142,0.31496,0.66929,0.31496,0.67717,0.31496,0.68504,0.31496,0.69291,0.31496,0.70079,0.31496,0.70866,0.31496,0.71654,0.31496,0.72441,0.31496,0.73228,0.31496,0.74016,0.31496,0.74803,0.31496,0.75591,0.31496,0.76378,0.31496,0.77165,0.31496,0.77953,0.31496,0.7874,0.31496,0.79528,0.31496,0.80315,0.31496,0.81102,0.31496,0.8189,0.31496,0.82677,0.31496,0.83465,0.31496,0.84252,0.31496,0.85039,0.31496,0.85827,0.31496,0.86614,0.31496,0.87402,0.31496,0.88189,0.31496,0.88976,0.31496,0.89764,0.31496,0.90551,0.31496,0.91339,0.31496,0.92126,0.31496,0.92913,0.31496,0.93701,0.31496,0.94488,0.31496,0.95276,0.31496,0.96063,0.31496,0.9685,0.31496,0.97638,0.31496,0.98425,0.31496,0.99213,0.31496,0.99609,0.31496,0.00391,0.32283,0.00787,0.32283,0.01575,0.32283,0.02362,0.32283,0.0315,0.32283,0.03937,0.32283,0.04724,0.32283,0.05512,0.32283,0.06299,0.32283,0.07087,0.32283,0.07874,0.32283,0.08661,0.32283,0.09449,0.32283,0.10236,0.32283,0.11024,0.32283,0.11811,0.32283,0.12598,0.32283,0.13386,0.32283,0.14173,0.32283,0.14961,0.32283,0.15748,0.32283,0.16535,0.32283,0.17323,0.32283,0.1811,0.32283,0.18898,0.32283,0.19685,0.32283,0.20472,0.32283,0.2126,0.32283,0.22047,0.32283,0.22835,0.32283,0.23622,0.32283,0.24409,0.32283,0.25197,0.32283,0.25984,0.32283,0.26772,0.32283,0.27559,0.32283,0.28346,0.32283,0.29134,0.32283,0.29921,0.32283,0.30709,0.32283,0.31496,0.32283,0.32283,0.32283,0.33071,0.32283,0.33858,0.32283,0.34646,0.32283,0.35433,0.32283,0.3622,0.32283,0.37008,0.32283,0.37795,0.32283,0.38583,0.32283,0.3937,0.32283,0.40157,0.32283};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_54()
		{
			double[] value = {0.40945,0.32283,0.41732,0.32283,0.4252,0.32283,0.43307,0.32283,0.44094,0.32283,0.44882,0.32283,0.45669,0.32283,0.46457,0.32283,0.47244,0.32283,0.48031,0.32283,0.48819,0.32283,0.49606,0.32283,0.50394,0.32283,0.51181,0.32283,0.51969,0.32283,0.52756,0.32283,0.53543,0.32283,0.54331,0.32283,0.55118,0.32283,0.55906,0.32283,0.56693,0.32283,0.5748,0.32283,0.58268,0.32283,0.59055,0.32283,0.59843,0.32283,0.6063,0.32283,0.61417,0.32283,0.62205,0.32283,0.62992,0.32283,0.6378,0.32283,0.64567,0.32283,0.65354,0.32283,0.66142,0.32283,0.66929,0.32283,0.67717,0.32283,0.68504,0.32283,0.69291,0.32283,0.70079,0.32283,0.70866,0.32283,0.71654,0.32283,0.72441,0.32283,0.73228,0.32283,0.74016,0.32283,0.74803,0.32283,0.75591,0.32283,0.76378,0.32283,0.77165,0.32283,0.77953,0.32283,0.7874,0.32283,0.79528,0.32283,0.80315,0.32283,0.81102,0.32283,0.8189,0.32283,0.82677,0.32283,0.83465,0.32283,0.84252,0.32283,0.85039,0.32283,0.85827,0.32283,0.86614,0.32283,0.87402,0.32283,0.88189,0.32283,0.88976,0.32283,0.89764,0.32283,0.90551,0.32283,0.91339,0.32283,0.92126,0.32283,0.92913,0.32283,0.93701,0.32283,0.94488,0.32283,0.95276,0.32283,0.96063,0.32283,0.9685,0.32283,0.97638,0.32283,0.98425,0.32283,0.99213,0.32283,0.99609,0.32283,0.00391,0.33071,0.00787,0.33071,0.01575,0.33071,0.02362,0.33071,0.0315,0.33071,0.03937,0.33071,0.04724,0.33071,0.05512,0.33071,0.06299,0.33071,0.07087,0.33071,0.07874,0.33071,0.08661,0.33071,0.09449,0.33071,0.10236,0.33071,0.11024,0.33071,0.11811,0.33071,0.12598,0.33071,0.13386,0.33071,0.14173,0.33071,0.14961,0.33071,0.15748,0.33071,0.16535,0.33071,0.17323,0.33071,0.1811,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_55()
		{
			double[] value = {0.18898,0.33071,0.19685,0.33071,0.20472,0.33071,0.2126,0.33071,0.22047,0.33071,0.22835,0.33071,0.23622,0.33071,0.24409,0.33071,0.25197,0.33071,0.25984,0.33071,0.26772,0.33071,0.27559,0.33071,0.28346,0.33071,0.29134,0.33071,0.29921,0.33071,0.30709,0.33071,0.31496,0.33071,0.32283,0.33071,0.33071,0.33071,0.33858,0.33071,0.34646,0.33071,0.35433,0.33071,0.3622,0.33071,0.37008,0.33071,0.37795,0.33071,0.38583,0.33071,0.3937,0.33071,0.40157,0.33071,0.40945,0.33071,0.41732,0.33071,0.4252,0.33071,0.43307,0.33071,0.44094,0.33071,0.44882,0.33071,0.45669,0.33071,0.46457,0.33071,0.47244,0.33071,0.48031,0.33071,0.48819,0.33071,0.49606,0.33071,0.50394,0.33071,0.51181,0.33071,0.51969,0.33071,0.52756,0.33071,0.53543,0.33071,0.54331,0.33071,0.55118,0.33071,0.55906,0.33071,0.56693,0.33071,0.5748,0.33071,0.58268,0.33071,0.59055,0.33071,0.59843,0.33071,0.6063,0.33071,0.61417,0.33071,0.62205,0.33071,0.62992,0.33071,0.6378,0.33071,0.64567,0.33071,0.65354,0.33071,0.66142,0.33071,0.66929,0.33071,0.67717,0.33071,0.68504,0.33071,0.69291,0.33071,0.70079,0.33071,0.70866,0.33071,0.71654,0.33071,0.72441,0.33071,0.73228,0.33071,0.74016,0.33071,0.74803,0.33071,0.75591,0.33071,0.76378,0.33071,0.77165,0.33071,0.77953,0.33071,0.7874,0.33071,0.79528,0.33071,0.80315,0.33071,0.81102,0.33071,0.8189,0.33071,0.82677,0.33071,0.83465,0.33071,0.84252,0.33071,0.85039,0.33071,0.85827,0.33071,0.86614,0.33071,0.87402,0.33071,0.88189,0.33071,0.88976,0.33071,0.89764,0.33071,0.90551,0.33071,0.91339,0.33071,0.92126,0.33071,0.92913,0.33071,0.93701,0.33071,0.94488,0.33071,0.95276,0.33071,0.96063,0.33071,0.9685,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_56()
		{
			double[] value = {0.97638,0.33071,0.98425,0.33071,0.99213,0.33071,0.99609,0.33071,0.00391,0.33858,0.00787,0.33858,0.01575,0.33858,0.02362,0.33858,0.0315,0.33858,0.03937,0.33858,0.04724,0.33858,0.05512,0.33858,0.06299,0.33858,0.07087,0.33858,0.07874,0.33858,0.08661,0.33858,0.09449,0.33858,0.10236,0.33858,0.11024,0.33858,0.11811,0.33858,0.12598,0.33858,0.13386,0.33858,0.14173,0.33858,0.14961,0.33858,0.15748,0.33858,0.16535,0.33858,0.17323,0.33858,0.1811,0.33858,0.18898,0.33858,0.19685,0.33858,0.20472,0.33858,0.2126,0.33858,0.22047,0.33858,0.22835,0.33858,0.23622,0.33858,0.24409,0.33858,0.25197,0.33858,0.25984,0.33858,0.26772,0.33858,0.27559,0.33858,0.28346,0.33858,0.29134,0.33858,0.29921,0.33858,0.30709,0.33858,0.31496,0.33858,0.32283,0.33858,0.33071,0.33858,0.33858,0.33858,0.34646,0.33858,0.35433,0.33858,0.3622,0.33858,0.37008,0.33858,0.37795,0.33858,0.38583,0.33858,0.3937,0.33858,0.40157,0.33858,0.40945,0.33858,0.41732,0.33858,0.4252,0.33858,0.43307,0.33858,0.44094,0.33858,0.44882,0.33858,0.45669,0.33858,0.46457,0.33858,0.47244,0.33858,0.48031,0.33858,0.48819,0.33858,0.49606,0.33858,0.50394,0.33858,0.51181,0.33858,0.51969,0.33858,0.52756,0.33858,0.53543,0.33858,0.54331,0.33858,0.55118,0.33858,0.55906,0.33858,0.56693,0.33858,0.5748,0.33858,0.58268,0.33858,0.59055,0.33858,0.59843,0.33858,0.6063,0.33858,0.61417,0.33858,0.62205,0.33858,0.62992,0.33858,0.6378,0.33858,0.64567,0.33858,0.65354,0.33858,0.66142,0.33858,0.66929,0.33858,0.67717,0.33858,0.68504,0.33858,0.69291,0.33858,0.70079,0.33858,0.70866,0.33858,0.71654,0.33858,0.72441,0.33858,0.73228,0.33858,0.74016,0.33858,0.74803,0.33858};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_57()
		{
			double[] value = {0.75591,0.33858,0.76378,0.33858,0.77165,0.33858,0.77953,0.33858,0.7874,0.33858,0.79528,0.33858,0.80315,0.33858,0.81102,0.33858,0.8189,0.33858,0.82677,0.33858,0.83465,0.33858,0.84252,0.33858,0.85039,0.33858,0.85827,0.33858,0.86614,0.33858,0.87402,0.33858,0.88189,0.33858,0.88976,0.33858,0.89764,0.33858,0.90551,0.33858,0.91339,0.33858,0.92126,0.33858,0.92913,0.33858,0.93701,0.33858,0.94488,0.33858,0.95276,0.33858,0.96063,0.33858,0.9685,0.33858,0.97638,0.33858,0.98425,0.33858,0.99213,0.33858,0.99609,0.33858,0.00391,0.34646,0.00787,0.34646,0.01575,0.34646,0.02362,0.34646,0.0315,0.34646,0.03937,0.34646,0.04724,0.34646,0.05512,0.34646,0.06299,0.34646,0.07087,0.34646,0.07874,0.34646,0.08661,0.34646,0.09449,0.34646,0.10236,0.34646,0.11024,0.34646,0.11811,0.34646,0.12598,0.34646,0.13386,0.34646,0.14173,0.34646,0.14961,0.34646,0.15748,0.34646,0.16535,0.34646,0.17323,0.34646,0.1811,0.34646,0.18898,0.34646,0.19685,0.34646,0.20472,0.34646,0.2126,0.34646,0.22047,0.34646,0.22835,0.34646,0.23622,0.34646,0.24409,0.34646,0.25197,0.34646,0.25984,0.34646,0.26772,0.34646,0.27559,0.34646,0.28346,0.34646,0.29134,0.34646,0.29921,0.34646,0.30709,0.34646,0.31496,0.34646,0.32283,0.34646,0.33071,0.34646,0.33858,0.34646,0.34646,0.34646,0.35433,0.34646,0.3622,0.34646,0.37008,0.34646,0.37795,0.34646,0.38583,0.34646,0.3937,0.34646,0.40157,0.34646,0.40945,0.34646,0.41732,0.34646,0.4252,0.34646,0.43307,0.34646,0.44094,0.34646,0.44882,0.34646,0.45669,0.34646,0.46457,0.34646,0.47244,0.34646,0.48031,0.34646,0.48819,0.34646,0.49606,0.34646,0.50394,0.34646,0.51181,0.34646,0.51969,0.34646,0.52756,0.34646};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_58()
		{
			double[] value = {0.53543,0.34646,0.54331,0.34646,0.55118,0.34646,0.55906,0.34646,0.56693,0.34646,0.5748,0.34646,0.58268,0.34646,0.59055,0.34646,0.59843,0.34646,0.6063,0.34646,0.61417,0.34646,0.62205,0.34646,0.62992,0.34646,0.6378,0.34646,0.64567,0.34646,0.65354,0.34646,0.66142,0.34646,0.66929,0.34646,0.67717,0.34646,0.68504,0.34646,0.69291,0.34646,0.70079,0.34646,0.70866,0.34646,0.71654,0.34646,0.72441,0.34646,0.73228,0.34646,0.74016,0.34646,0.74803,0.34646,0.75591,0.34646,0.76378,0.34646,0.77165,0.34646,0.77953,0.34646,0.7874,0.34646,0.79528,0.34646,0.80315,0.34646,0.81102,0.34646,0.8189,0.34646,0.82677,0.34646,0.83465,0.34646,0.84252,0.34646,0.85039,0.34646,0.85827,0.34646,0.86614,0.34646,0.87402,0.34646,0.88189,0.34646,0.88976,0.34646,0.89764,0.34646,0.90551,0.34646,0.91339,0.34646,0.92126,0.34646,0.92913,0.34646,0.93701,0.34646,0.94488,0.34646,0.95276,0.34646,0.96063,0.34646,0.9685,0.34646,0.97638,0.34646,0.98425,0.34646,0.99213,0.34646,0.99609,0.34646,0.00391,0.35433,0.00787,0.35433,0.01575,0.35433,0.02362,0.35433,0.0315,0.35433,0.03937,0.35433,0.04724,0.35433,0.05512,0.35433,0.06299,0.35433,0.07087,0.35433,0.07874,0.35433,0.08661,0.35433,0.09449,0.35433,0.10236,0.35433,0.11024,0.35433,0.11811,0.35433,0.12598,0.35433,0.13386,0.35433,0.14173,0.35433,0.14961,0.35433,0.15748,0.35433,0.16535,0.35433,0.17323,0.35433,0.1811,0.35433,0.18898,0.35433,0.19685,0.35433,0.20472,0.35433,0.2126,0.35433,0.22047,0.35433,0.22835,0.35433,0.23622,0.35433,0.24409,0.35433,0.25197,0.35433,0.25984,0.35433,0.26772,0.35433,0.27559,0.35433,0.28346,0.35433,0.29134,0.35433,0.29921,0.35433,0.30709,0.35433};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_59()
		{
			double[] value = {0.31496,0.35433,0.32283,0.35433,0.33071,0.35433,0.33858,0.35433,0.34646,0.35433,0.35433,0.35433,0.3622,0.35433,0.37008,0.35433,0.37795,0.35433,0.38583,0.35433,0.3937,0.35433,0.40157,0.35433,0.40945,0.35433,0.41732,0.35433,0.4252,0.35433,0.43307,0.35433,0.44094,0.35433,0.44882,0.35433,0.45669,0.35433,0.46457,0.35433,0.47244,0.35433,0.48031,0.35433,0.48819,0.35433,0.49606,0.35433,0.50394,0.35433,0.51181,0.35433,0.51969,0.35433,0.52756,0.35433,0.53543,0.35433,0.54331,0.35433,0.55118,0.35433,0.55906,0.35433,0.56693,0.35433,0.5748,0.35433,0.58268,0.35433,0.59055,0.35433,0.59843,0.35433,0.6063,0.35433,0.61417,0.35433,0.62205,0.35433,0.62992,0.35433,0.6378,0.35433,0.64567,0.35433,0.65354,0.35433,0.66142,0.35433,0.66929,0.35433,0.67717,0.35433,0.68504,0.35433,0.69291,0.35433,0.70079,0.35433,0.70866,0.35433,0.71654,0.35433,0.72441,0.35433,0.73228,0.35433,0.74016,0.35433,0.74803,0.35433,0.75591,0.35433,0.76378,0.35433,0.77165,0.35433,0.77953,0.35433,0.7874,0.35433,0.79528,0.35433,0.80315,0.35433,0.81102,0.35433,0.8189,0.35433,0.82677,0.35433,0.83465,0.35433,0.84252,0.35433,0.85039,0.35433,0.85827,0.35433,0.86614,0.35433,0.87402,0.35433,0.88189,0.35433,0.88976,0.35433,0.89764,0.35433,0.90551,0.35433,0.91339,0.35433,0.92126,0.35433,0.92913,0.35433,0.93701,0.35433,0.94488,0.35433,0.95276,0.35433,0.96063,0.35433,0.9685,0.35433,0.97638,0.35433,0.98425,0.35433,0.99213,0.35433,0.99609,0.35433,0.00391,0.3622,0.00787,0.3622,0.01575,0.3622,0.02362,0.3622,0.0315,0.3622,0.03937,0.3622,0.04724,0.3622,0.05512,0.3622,0.06299,0.3622,0.07087,0.3622,0.07874,0.3622,0.08661,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_60()
		{
			double[] value = {0.09449,0.3622,0.10236,0.3622,0.11024,0.3622,0.11811,0.3622,0.12598,0.3622,0.13386,0.3622,0.14173,0.3622,0.14961,0.3622,0.15748,0.3622,0.16535,0.3622,0.17323,0.3622,0.1811,0.3622,0.18898,0.3622,0.19685,0.3622,0.20472,0.3622,0.2126,0.3622,0.22047,0.3622,0.22835,0.3622,0.23622,0.3622,0.24409,0.3622,0.25197,0.3622,0.25984,0.3622,0.26772,0.3622,0.27559,0.3622,0.28346,0.3622,0.29134,0.3622,0.29921,0.3622,0.30709,0.3622,0.31496,0.3622,0.32283,0.3622,0.33071,0.3622,0.33858,0.3622,0.34646,0.3622,0.35433,0.3622,0.3622,0.3622,0.37008,0.3622,0.37795,0.3622,0.38583,0.3622,0.3937,0.3622,0.40157,0.3622,0.40945,0.3622,0.41732,0.3622,0.4252,0.3622,0.43307,0.3622,0.44094,0.3622,0.44882,0.3622,0.45669,0.3622,0.46457,0.3622,0.47244,0.3622,0.48031,0.3622,0.48819,0.3622,0.49606,0.3622,0.50394,0.3622,0.51181,0.3622,0.51969,0.3622,0.52756,0.3622,0.53543,0.3622,0.54331,0.3622,0.55118,0.3622,0.55906,0.3622,0.56693,0.3622,0.5748,0.3622,0.58268,0.3622,0.59055,0.3622,0.59843,0.3622,0.6063,0.3622,0.61417,0.3622,0.62205,0.3622,0.62992,0.3622,0.6378,0.3622,0.64567,0.3622,0.65354,0.3622,0.66142,0.3622,0.66929,0.3622,0.67717,0.3622,0.68504,0.3622,0.69291,0.3622,0.70079,0.3622,0.70866,0.3622,0.71654,0.3622,0.72441,0.3622,0.73228,0.3622,0.74016,0.3622,0.74803,0.3622,0.75591,0.3622,0.76378,0.3622,0.77165,0.3622,0.77953,0.3622,0.7874,0.3622,0.79528,0.3622,0.80315,0.3622,0.81102,0.3622,0.8189,0.3622,0.82677,0.3622,0.83465,0.3622,0.84252,0.3622,0.85039,0.3622,0.85827,0.3622,0.86614,0.3622,0.87402,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_61()
		{
			double[] value = {0.88189,0.3622,0.88976,0.3622,0.89764,0.3622,0.90551,0.3622,0.91339,0.3622,0.92126,0.3622,0.92913,0.3622,0.93701,0.3622,0.94488,0.3622,0.95276,0.3622,0.96063,0.3622,0.9685,0.3622,0.97638,0.3622,0.98425,0.3622,0.99213,0.3622,0.99609,0.3622,0.00391,0.37008,0.00787,0.37008,0.01575,0.37008,0.02362,0.37008,0.0315,0.37008,0.03937,0.37008,0.04724,0.37008,0.05512,0.37008,0.06299,0.37008,0.07087,0.37008,0.07874,0.37008,0.08661,0.37008,0.09449,0.37008,0.10236,0.37008,0.11024,0.37008,0.11811,0.37008,0.12598,0.37008,0.13386,0.37008,0.14173,0.37008,0.14961,0.37008,0.15748,0.37008,0.16535,0.37008,0.17323,0.37008,0.1811,0.37008,0.18898,0.37008,0.19685,0.37008,0.20472,0.37008,0.2126,0.37008,0.22047,0.37008,0.22835,0.37008,0.23622,0.37008,0.24409,0.37008,0.25197,0.37008,0.25984,0.37008,0.26772,0.37008,0.27559,0.37008,0.28346,0.37008,0.29134,0.37008,0.29921,0.37008,0.30709,0.37008,0.31496,0.37008,0.32283,0.37008,0.33071,0.37008,0.33858,0.37008,0.34646,0.37008,0.35433,0.37008,0.3622,0.37008,0.37008,0.37008,0.37795,0.37008,0.38583,0.37008,0.3937,0.37008,0.40157,0.37008,0.40945,0.37008,0.41732,0.37008,0.4252,0.37008,0.43307,0.37008,0.44094,0.37008,0.44882,0.37008,0.45669,0.37008,0.46457,0.37008,0.47244,0.37008,0.48031,0.37008,0.48819,0.37008,0.49606,0.37008,0.50394,0.37008,0.51181,0.37008,0.51969,0.37008,0.52756,0.37008,0.53543,0.37008,0.54331,0.37008,0.55118,0.37008,0.55906,0.37008,0.56693,0.37008,0.5748,0.37008,0.58268,0.37008,0.59055,0.37008,0.59843,0.37008,0.6063,0.37008,0.61417,0.37008,0.62205,0.37008,0.62992,0.37008,0.6378,0.37008,0.64567,0.37008,0.65354,0.37008};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_62()
		{
			double[] value = {0.66142,0.37008,0.66929,0.37008,0.67717,0.37008,0.68504,0.37008,0.69291,0.37008,0.70079,0.37008,0.70866,0.37008,0.71654,0.37008,0.72441,0.37008,0.73228,0.37008,0.74016,0.37008,0.74803,0.37008,0.75591,0.37008,0.76378,0.37008,0.77165,0.37008,0.77953,0.37008,0.7874,0.37008,0.79528,0.37008,0.80315,0.37008,0.81102,0.37008,0.8189,0.37008,0.82677,0.37008,0.83465,0.37008,0.84252,0.37008,0.85039,0.37008,0.85827,0.37008,0.86614,0.37008,0.87402,0.37008,0.88189,0.37008,0.88976,0.37008,0.89764,0.37008,0.90551,0.37008,0.91339,0.37008,0.92126,0.37008,0.92913,0.37008,0.93701,0.37008,0.94488,0.37008,0.95276,0.37008,0.96063,0.37008,0.9685,0.37008,0.97638,0.37008,0.98425,0.37008,0.99213,0.37008,0.99609,0.37008,0.00391,0.37795,0.00787,0.37795,0.01575,0.37795,0.02362,0.37795,0.0315,0.37795,0.03937,0.37795,0.04724,0.37795,0.05512,0.37795,0.06299,0.37795,0.07087,0.37795,0.07874,0.37795,0.08661,0.37795,0.09449,0.37795,0.10236,0.37795,0.11024,0.37795,0.11811,0.37795,0.12598,0.37795,0.13386,0.37795,0.14173,0.37795,0.14961,0.37795,0.15748,0.37795,0.16535,0.37795,0.17323,0.37795,0.1811,0.37795,0.18898,0.37795,0.19685,0.37795,0.20472,0.37795,0.2126,0.37795,0.22047,0.37795,0.22835,0.37795,0.23622,0.37795,0.24409,0.37795,0.25197,0.37795,0.25984,0.37795,0.26772,0.37795,0.27559,0.37795,0.28346,0.37795,0.29134,0.37795,0.29921,0.37795,0.30709,0.37795,0.31496,0.37795,0.32283,0.37795,0.33071,0.37795,0.33858,0.37795,0.34646,0.37795,0.35433,0.37795,0.3622,0.37795,0.37008,0.37795,0.37795,0.37795,0.38583,0.37795,0.3937,0.37795,0.40157,0.37795,0.40945,0.37795,0.41732,0.37795,0.4252,0.37795,0.43307,0.37795};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_63()
		{
			double[] value = {0.44094,0.37795,0.44882,0.37795,0.45669,0.37795,0.46457,0.37795,0.47244,0.37795,0.48031,0.37795,0.48819,0.37795,0.49606,0.37795,0.50394,0.37795,0.51181,0.37795,0.51969,0.37795,0.52756,0.37795,0.53543,0.37795,0.54331,0.37795,0.55118,0.37795,0.55906,0.37795,0.56693,0.37795,0.5748,0.37795,0.58268,0.37795,0.59055,0.37795,0.59843,0.37795,0.6063,0.37795,0.61417,0.37795,0.62205,0.37795,0.62992,0.37795,0.6378,0.37795,0.64567,0.37795,0.65354,0.37795,0.66142,0.37795,0.66929,0.37795,0.67717,0.37795,0.68504,0.37795,0.69291,0.37795,0.70079,0.37795,0.70866,0.37795,0.71654,0.37795,0.72441,0.37795,0.73228,0.37795,0.74016,0.37795,0.74803,0.37795,0.75591,0.37795,0.76378,0.37795,0.77165,0.37795,0.77953,0.37795,0.7874,0.37795,0.79528,0.37795,0.80315,0.37795,0.81102,0.37795,0.8189,0.37795,0.82677,0.37795,0.83465,0.37795,0.84252,0.37795,0.85039,0.37795,0.85827,0.37795,0.86614,0.37795,0.87402,0.37795,0.88189,0.37795,0.88976,0.37795,0.89764,0.37795,0.90551,0.37795,0.91339,0.37795,0.92126,0.37795,0.92913,0.37795,0.93701,0.37795,0.94488,0.37795,0.95276,0.37795,0.96063,0.37795,0.9685,0.37795,0.97638,0.37795,0.98425,0.37795,0.99213,0.37795,0.99609,0.37795,0.00391,0.38583,0.00787,0.38583,0.01575,0.38583,0.02362,0.38583,0.0315,0.38583,0.03937,0.38583,0.04724,0.38583,0.05512,0.38583,0.06299,0.38583,0.07087,0.38583,0.07874,0.38583,0.08661,0.38583,0.09449,0.38583,0.10236,0.38583,0.11024,0.38583,0.11811,0.38583,0.12598,0.38583,0.13386,0.38583,0.14173,0.38583,0.14961,0.38583,0.15748,0.38583,0.16535,0.38583,0.17323,0.38583,0.1811,0.38583,0.18898,0.38583,0.19685,0.38583,0.20472,0.38583,0.2126,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_64()
		{
			double[] value = {0.22047,0.38583,0.22835,0.38583,0.23622,0.38583,0.24409,0.38583,0.25197,0.38583,0.25984,0.38583,0.26772,0.38583,0.27559,0.38583,0.28346,0.38583,0.29134,0.38583,0.29921,0.38583,0.30709,0.38583,0.31496,0.38583,0.32283,0.38583,0.33071,0.38583,0.33858,0.38583,0.34646,0.38583,0.35433,0.38583,0.3622,0.38583,0.37008,0.38583,0.37795,0.38583,0.38583,0.38583,0.3937,0.38583,0.40157,0.38583,0.40945,0.38583,0.41732,0.38583,0.4252,0.38583,0.43307,0.38583,0.44094,0.38583,0.44882,0.38583,0.45669,0.38583,0.46457,0.38583,0.47244,0.38583,0.48031,0.38583,0.48819,0.38583,0.49606,0.38583,0.50394,0.38583,0.51181,0.38583,0.51969,0.38583,0.52756,0.38583,0.53543,0.38583,0.54331,0.38583,0.55118,0.38583,0.55906,0.38583,0.56693,0.38583,0.5748,0.38583,0.58268,0.38583,0.59055,0.38583,0.59843,0.38583,0.6063,0.38583,0.61417,0.38583,0.62205,0.38583,0.62992,0.38583,0.6378,0.38583,0.64567,0.38583,0.65354,0.38583,0.66142,0.38583,0.66929,0.38583,0.67717,0.38583,0.68504,0.38583,0.69291,0.38583,0.70079,0.38583,0.70866,0.38583,0.71654,0.38583,0.72441,0.38583,0.73228,0.38583,0.74016,0.38583,0.74803,0.38583,0.75591,0.38583,0.76378,0.38583,0.77165,0.38583,0.77953,0.38583,0.7874,0.38583,0.79528,0.38583,0.80315,0.38583,0.81102,0.38583,0.8189,0.38583,0.82677,0.38583,0.83465,0.38583,0.84252,0.38583,0.85039,0.38583,0.85827,0.38583,0.86614,0.38583,0.87402,0.38583,0.88189,0.38583,0.88976,0.38583,0.89764,0.38583,0.90551,0.38583,0.91339,0.38583,0.92126,0.38583,0.92913,0.38583,0.93701,0.38583,0.94488,0.38583,0.95276,0.38583,0.96063,0.38583,0.9685,0.38583,0.97638,0.38583,0.98425,0.38583,0.99213,0.38583,0.99609,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_65()
		{
			double[] value = {0.00391,0.3937,0.00787,0.3937,0.01575,0.3937,0.02362,0.3937,0.0315,0.3937,0.03937,0.3937,0.04724,0.3937,0.05512,0.3937,0.06299,0.3937,0.07087,0.3937,0.07874,0.3937,0.08661,0.3937,0.09449,0.3937,0.10236,0.3937,0.11024,0.3937,0.11811,0.3937,0.12598,0.3937,0.13386,0.3937,0.14173,0.3937,0.14961,0.3937,0.15748,0.3937,0.16535,0.3937,0.17323,0.3937,0.1811,0.3937,0.18898,0.3937,0.19685,0.3937,0.20472,0.3937,0.2126,0.3937,0.22047,0.3937,0.22835,0.3937,0.23622,0.3937,0.24409,0.3937,0.25197,0.3937,0.25984,0.3937,0.26772,0.3937,0.27559,0.3937,0.28346,0.3937,0.29134,0.3937,0.29921,0.3937,0.30709,0.3937,0.31496,0.3937,0.32283,0.3937,0.33071,0.3937,0.33858,0.3937,0.34646,0.3937,0.35433,0.3937,0.3622,0.3937,0.37008,0.3937,0.37795,0.3937,0.38583,0.3937,0.3937,0.3937,0.40157,0.3937,0.40945,0.3937,0.41732,0.3937,0.4252,0.3937,0.43307,0.3937,0.44094,0.3937,0.44882,0.3937,0.45669,0.3937,0.46457,0.3937,0.47244,0.3937,0.48031,0.3937,0.48819,0.3937,0.49606,0.3937,0.50394,0.3937,0.51181,0.3937,0.51969,0.3937,0.52756,0.3937,0.53543,0.3937,0.54331,0.3937,0.55118,0.3937,0.55906,0.3937,0.56693,0.3937,0.5748,0.3937,0.58268,0.3937,0.59055,0.3937,0.59843,0.3937,0.6063,0.3937,0.61417,0.3937,0.62205,0.3937,0.62992,0.3937,0.6378,0.3937,0.64567,0.3937,0.65354,0.3937,0.66142,0.3937,0.66929,0.3937,0.67717,0.3937,0.68504,0.3937,0.69291,0.3937,0.70079,0.3937,0.70866,0.3937,0.71654,0.3937,0.72441,0.3937,0.73228,0.3937,0.74016,0.3937,0.74803,0.3937,0.75591,0.3937,0.76378,0.3937,0.77165,0.3937,0.77953,0.3937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_66()
		{
			double[] value = {0.7874,0.3937,0.79528,0.3937,0.80315,0.3937,0.81102,0.3937,0.8189,0.3937,0.82677,0.3937,0.83465,0.3937,0.84252,0.3937,0.85039,0.3937,0.85827,0.3937,0.86614,0.3937,0.87402,0.3937,0.88189,0.3937,0.88976,0.3937,0.89764,0.3937,0.90551,0.3937,0.91339,0.3937,0.92126,0.3937,0.92913,0.3937,0.93701,0.3937,0.94488,0.3937,0.95276,0.3937,0.96063,0.3937,0.9685,0.3937,0.97638,0.3937,0.98425,0.3937,0.99213,0.3937,0.99609,0.3937,0.00391,0.40157,0.00787,0.40157,0.01575,0.40157,0.02362,0.40157,0.0315,0.40157,0.03937,0.40157,0.04724,0.40157,0.05512,0.40157,0.06299,0.40157,0.07087,0.40157,0.07874,0.40157,0.08661,0.40157,0.09449,0.40157,0.10236,0.40157,0.11024,0.40157,0.11811,0.40157,0.12598,0.40157,0.13386,0.40157,0.14173,0.40157,0.14961,0.40157,0.15748,0.40157,0.16535,0.40157,0.17323,0.40157,0.1811,0.40157,0.18898,0.40157,0.19685,0.40157,0.20472,0.40157,0.2126,0.40157,0.22047,0.40157,0.22835,0.40157,0.23622,0.40157,0.24409,0.40157,0.25197,0.40157,0.25984,0.40157,0.26772,0.40157,0.27559,0.40157,0.28346,0.40157,0.29134,0.40157,0.29921,0.40157,0.30709,0.40157,0.31496,0.40157,0.32283,0.40157,0.33071,0.40157,0.33858,0.40157,0.34646,0.40157,0.35433,0.40157,0.3622,0.40157,0.37008,0.40157,0.37795,0.40157,0.38583,0.40157,0.3937,0.40157,0.40157,0.40157,0.40945,0.40157,0.41732,0.40157,0.4252,0.40157,0.43307,0.40157,0.44094,0.40157,0.44882,0.40157,0.45669,0.40157,0.46457,0.40157,0.47244,0.40157,0.48031,0.40157,0.48819,0.40157,0.49606,0.40157,0.50394,0.40157,0.51181,0.40157,0.51969,0.40157,0.52756,0.40157,0.53543,0.40157,0.54331,0.40157,0.55118,0.40157,0.55906,0.40157};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_67()
		{
			double[] value = {0.56693,0.40157,0.5748,0.40157,0.58268,0.40157,0.59055,0.40157,0.59843,0.40157,0.6063,0.40157,0.61417,0.40157,0.62205,0.40157,0.62992,0.40157,0.6378,0.40157,0.64567,0.40157,0.65354,0.40157,0.66142,0.40157,0.66929,0.40157,0.67717,0.40157,0.68504,0.40157,0.69291,0.40157,0.70079,0.40157,0.70866,0.40157,0.71654,0.40157,0.72441,0.40157,0.73228,0.40157,0.74016,0.40157,0.74803,0.40157,0.75591,0.40157,0.76378,0.40157,0.77165,0.40157,0.77953,0.40157,0.7874,0.40157,0.79528,0.40157,0.80315,0.40157,0.81102,0.40157,0.8189,0.40157,0.82677,0.40157,0.83465,0.40157,0.84252,0.40157,0.85039,0.40157,0.85827,0.40157,0.86614,0.40157,0.87402,0.40157,0.88189,0.40157,0.88976,0.40157,0.89764,0.40157,0.90551,0.40157,0.91339,0.40157,0.92126,0.40157,0.92913,0.40157,0.93701,0.40157,0.94488,0.40157,0.95276,0.40157,0.96063,0.40157,0.9685,0.40157,0.97638,0.40157,0.98425,0.40157,0.99213,0.40157,0.99609,0.40157,0.00391,0.40945,0.00787,0.40945,0.01575,0.40945,0.02362,0.40945,0.0315,0.40945,0.03937,0.40945,0.04724,0.40945,0.05512,0.40945,0.06299,0.40945,0.07087,0.40945,0.07874,0.40945,0.08661,0.40945,0.09449,0.40945,0.10236,0.40945,0.11024,0.40945,0.11811,0.40945,0.12598,0.40945,0.13386,0.40945,0.14173,0.40945,0.14961,0.40945,0.15748,0.40945,0.16535,0.40945,0.17323,0.40945,0.1811,0.40945,0.18898,0.40945,0.19685,0.40945,0.20472,0.40945,0.2126,0.40945,0.22047,0.40945,0.22835,0.40945,0.23622,0.40945,0.24409,0.40945,0.25197,0.40945,0.25984,0.40945,0.26772,0.40945,0.27559,0.40945,0.28346,0.40945,0.29134,0.40945,0.29921,0.40945,0.30709,0.40945,0.31496,0.40945,0.32283,0.40945,0.33071,0.40945,0.33858,0.40945};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_68()
		{
			double[] value = {0.34646,0.40945,0.35433,0.40945,0.3622,0.40945,0.37008,0.40945,0.37795,0.40945,0.38583,0.40945,0.3937,0.40945,0.40157,0.40945,0.40945,0.40945,0.41732,0.40945,0.4252,0.40945,0.43307,0.40945,0.44094,0.40945,0.44882,0.40945,0.45669,0.40945,0.46457,0.40945,0.47244,0.40945,0.48031,0.40945,0.48819,0.40945,0.49606,0.40945,0.50394,0.40945,0.51181,0.40945,0.51969,0.40945,0.52756,0.40945,0.53543,0.40945,0.54331,0.40945,0.55118,0.40945,0.55906,0.40945,0.56693,0.40945,0.5748,0.40945,0.58268,0.40945,0.59055,0.40945,0.59843,0.40945,0.6063,0.40945,0.61417,0.40945,0.62205,0.40945,0.62992,0.40945,0.6378,0.40945,0.64567,0.40945,0.65354,0.40945,0.66142,0.40945,0.66929,0.40945,0.67717,0.40945,0.68504,0.40945,0.69291,0.40945,0.70079,0.40945,0.70866,0.40945,0.71654,0.40945,0.72441,0.40945,0.73228,0.40945,0.74016,0.40945,0.74803,0.40945,0.75591,0.40945,0.76378,0.40945,0.77165,0.40945,0.77953,0.40945,0.7874,0.40945,0.79528,0.40945,0.80315,0.40945,0.81102,0.40945,0.8189,0.40945,0.82677,0.40945,0.83465,0.40945,0.84252,0.40945,0.85039,0.40945,0.85827,0.40945,0.86614,0.40945,0.87402,0.40945,0.88189,0.40945,0.88976,0.40945,0.89764,0.40945,0.90551,0.40945,0.91339,0.40945,0.92126,0.40945,0.92913,0.40945,0.93701,0.40945,0.94488,0.40945,0.95276,0.40945,0.96063,0.40945,0.9685,0.40945,0.97638,0.40945,0.98425,0.40945,0.99213,0.40945,0.99609,0.40945,0.00391,0.41732,0.00787,0.41732,0.01575,0.41732,0.02362,0.41732,0.0315,0.41732,0.03937,0.41732,0.04724,0.41732,0.05512,0.41732,0.06299,0.41732,0.07087,0.41732,0.07874,0.41732,0.08661,0.41732,0.09449,0.41732,0.10236,0.41732,0.11024,0.41732,0.11811,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_69()
		{
			double[] value = {0.12598,0.41732,0.13386,0.41732,0.14173,0.41732,0.14961,0.41732,0.15748,0.41732,0.16535,0.41732,0.17323,0.41732,0.1811,0.41732,0.18898,0.41732,0.19685,0.41732,0.20472,0.41732,0.2126,0.41732,0.22047,0.41732,0.22835,0.41732,0.23622,0.41732,0.24409,0.41732,0.25197,0.41732,0.25984,0.41732,0.26772,0.41732,0.27559,0.41732,0.28346,0.41732,0.29134,0.41732,0.29921,0.41732,0.30709,0.41732,0.31496,0.41732,0.32283,0.41732,0.33071,0.41732,0.33858,0.41732,0.34646,0.41732,0.35433,0.41732,0.3622,0.41732,0.37008,0.41732,0.37795,0.41732,0.38583,0.41732,0.3937,0.41732,0.40157,0.41732,0.40945,0.41732,0.41732,0.41732,0.4252,0.41732,0.43307,0.41732,0.44094,0.41732,0.44882,0.41732,0.45669,0.41732,0.46457,0.41732,0.47244,0.41732,0.48031,0.41732,0.48819,0.41732,0.49606,0.41732,0.50394,0.41732,0.51181,0.41732,0.51969,0.41732,0.52756,0.41732,0.53543,0.41732,0.54331,0.41732,0.55118,0.41732,0.55906,0.41732,0.56693,0.41732,0.5748,0.41732,0.58268,0.41732,0.59055,0.41732,0.59843,0.41732,0.6063,0.41732,0.61417,0.41732,0.62205,0.41732,0.62992,0.41732,0.6378,0.41732,0.64567,0.41732,0.65354,0.41732,0.66142,0.41732,0.66929,0.41732,0.67717,0.41732,0.68504,0.41732,0.69291,0.41732,0.70079,0.41732,0.70866,0.41732,0.71654,0.41732,0.72441,0.41732,0.73228,0.41732,0.74016,0.41732,0.74803,0.41732,0.75591,0.41732,0.76378,0.41732,0.77165,0.41732,0.77953,0.41732,0.7874,0.41732,0.79528,0.41732,0.80315,0.41732,0.81102,0.41732,0.8189,0.41732,0.82677,0.41732,0.83465,0.41732,0.84252,0.41732,0.85039,0.41732,0.85827,0.41732,0.86614,0.41732,0.87402,0.41732,0.88189,0.41732,0.88976,0.41732,0.89764,0.41732,0.90551,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_70()
		{
			double[] value = {0.91339,0.41732,0.92126,0.41732,0.92913,0.41732,0.93701,0.41732,0.94488,0.41732,0.95276,0.41732,0.96063,0.41732,0.9685,0.41732,0.97638,0.41732,0.98425,0.41732,0.99213,0.41732,0.99609,0.41732,0.00391,0.4252,0.00787,0.4252,0.01575,0.4252,0.02362,0.4252,0.0315,0.4252,0.03937,0.4252,0.04724,0.4252,0.05512,0.4252,0.06299,0.4252,0.07087,0.4252,0.07874,0.4252,0.08661,0.4252,0.09449,0.4252,0.10236,0.4252,0.11024,0.4252,0.11811,0.4252,0.12598,0.4252,0.13386,0.4252,0.14173,0.4252,0.14961,0.4252,0.15748,0.4252,0.16535,0.4252,0.17323,0.4252,0.1811,0.4252,0.18898,0.4252,0.19685,0.4252,0.20472,0.4252,0.2126,0.4252,0.22047,0.4252,0.22835,0.4252,0.23622,0.4252,0.24409,0.4252,0.25197,0.4252,0.25984,0.4252,0.26772,0.4252,0.27559,0.4252,0.28346,0.4252,0.29134,0.4252,0.29921,0.4252,0.30709,0.4252,0.31496,0.4252,0.32283,0.4252,0.33071,0.4252,0.33858,0.4252,0.34646,0.4252,0.35433,0.4252,0.3622,0.4252,0.37008,0.4252,0.37795,0.4252,0.38583,0.4252,0.3937,0.4252,0.40157,0.4252,0.40945,0.4252,0.41732,0.4252,0.4252,0.4252,0.43307,0.4252,0.44094,0.4252,0.44882,0.4252,0.45669,0.4252,0.46457,0.4252,0.47244,0.4252,0.48031,0.4252,0.48819,0.4252,0.49606,0.4252,0.50394,0.4252,0.51181,0.4252,0.51969,0.4252,0.52756,0.4252,0.53543,0.4252,0.54331,0.4252,0.55118,0.4252,0.55906,0.4252,0.56693,0.4252,0.5748,0.4252,0.58268,0.4252,0.59055,0.4252,0.59843,0.4252,0.6063,0.4252,0.61417,0.4252,0.62205,0.4252,0.62992,0.4252,0.6378,0.4252,0.64567,0.4252,0.65354,0.4252,0.66142,0.4252,0.66929,0.4252,0.67717,0.4252,0.68504,0.4252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_71()
		{
			double[] value = {0.69291,0.4252,0.70079,0.4252,0.70866,0.4252,0.71654,0.4252,0.72441,0.4252,0.73228,0.4252,0.74016,0.4252,0.74803,0.4252,0.75591,0.4252,0.76378,0.4252,0.77165,0.4252,0.77953,0.4252,0.7874,0.4252,0.79528,0.4252,0.80315,0.4252,0.81102,0.4252,0.8189,0.4252,0.82677,0.4252,0.83465,0.4252,0.84252,0.4252,0.85039,0.4252,0.85827,0.4252,0.86614,0.4252,0.87402,0.4252,0.88189,0.4252,0.88976,0.4252,0.89764,0.4252,0.90551,0.4252,0.91339,0.4252,0.92126,0.4252,0.92913,0.4252,0.93701,0.4252,0.94488,0.4252,0.95276,0.4252,0.96063,0.4252,0.9685,0.4252,0.97638,0.4252,0.98425,0.4252,0.99213,0.4252,0.99609,0.4252,0.00391,0.43307,0.00787,0.43307,0.01575,0.43307,0.02362,0.43307,0.0315,0.43307,0.03937,0.43307,0.04724,0.43307,0.05512,0.43307,0.06299,0.43307,0.07087,0.43307,0.07874,0.43307,0.08661,0.43307,0.09449,0.43307,0.10236,0.43307,0.11024,0.43307,0.11811,0.43307,0.12598,0.43307,0.13386,0.43307,0.14173,0.43307,0.14961,0.43307,0.15748,0.43307,0.16535,0.43307,0.17323,0.43307,0.1811,0.43307,0.18898,0.43307,0.19685,0.43307,0.20472,0.43307,0.2126,0.43307,0.22047,0.43307,0.22835,0.43307,0.23622,0.43307,0.24409,0.43307,0.25197,0.43307,0.25984,0.43307,0.26772,0.43307,0.27559,0.43307,0.28346,0.43307,0.29134,0.43307,0.29921,0.43307,0.30709,0.43307,0.31496,0.43307,0.32283,0.43307,0.33071,0.43307,0.33858,0.43307,0.34646,0.43307,0.35433,0.43307,0.3622,0.43307,0.37008,0.43307,0.37795,0.43307,0.38583,0.43307,0.3937,0.43307,0.40157,0.43307,0.40945,0.43307,0.41732,0.43307,0.4252,0.43307,0.43307,0.43307,0.44094,0.43307,0.44882,0.43307,0.45669,0.43307,0.46457,0.43307};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_72()
		{
			double[] value = {0.47244,0.43307,0.48031,0.43307,0.48819,0.43307,0.49606,0.43307,0.50394,0.43307,0.51181,0.43307,0.51969,0.43307,0.52756,0.43307,0.53543,0.43307,0.54331,0.43307,0.55118,0.43307,0.55906,0.43307,0.56693,0.43307,0.5748,0.43307,0.58268,0.43307,0.59055,0.43307,0.59843,0.43307,0.6063,0.43307,0.61417,0.43307,0.62205,0.43307,0.62992,0.43307,0.6378,0.43307,0.64567,0.43307,0.65354,0.43307,0.66142,0.43307,0.66929,0.43307,0.67717,0.43307,0.68504,0.43307,0.69291,0.43307,0.70079,0.43307,0.70866,0.43307,0.71654,0.43307,0.72441,0.43307,0.73228,0.43307,0.74016,0.43307,0.74803,0.43307,0.75591,0.43307,0.76378,0.43307,0.77165,0.43307,0.77953,0.43307,0.7874,0.43307,0.79528,0.43307,0.80315,0.43307,0.81102,0.43307,0.8189,0.43307,0.82677,0.43307,0.83465,0.43307,0.84252,0.43307,0.85039,0.43307,0.85827,0.43307,0.86614,0.43307,0.87402,0.43307,0.88189,0.43307,0.88976,0.43307,0.89764,0.43307,0.90551,0.43307,0.91339,0.43307,0.92126,0.43307,0.92913,0.43307,0.93701,0.43307,0.94488,0.43307,0.95276,0.43307,0.96063,0.43307,0.9685,0.43307,0.97638,0.43307,0.98425,0.43307,0.99213,0.43307,0.99609,0.43307,0.00391,0.44094,0.00787,0.44094,0.01575,0.44094,0.02362,0.44094,0.0315,0.44094,0.03937,0.44094,0.04724,0.44094,0.05512,0.44094,0.06299,0.44094,0.07087,0.44094,0.07874,0.44094,0.08661,0.44094,0.09449,0.44094,0.10236,0.44094,0.11024,0.44094,0.11811,0.44094,0.12598,0.44094,0.13386,0.44094,0.14173,0.44094,0.14961,0.44094,0.15748,0.44094,0.16535,0.44094,0.17323,0.44094,0.1811,0.44094,0.18898,0.44094,0.19685,0.44094,0.20472,0.44094,0.2126,0.44094,0.22047,0.44094,0.22835,0.44094,0.23622,0.44094,0.24409,0.44094};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_73()
		{
			double[] value = {0.25197,0.44094,0.25984,0.44094,0.26772,0.44094,0.27559,0.44094,0.28346,0.44094,0.29134,0.44094,0.29921,0.44094,0.30709,0.44094,0.31496,0.44094,0.32283,0.44094,0.33071,0.44094,0.33858,0.44094,0.34646,0.44094,0.35433,0.44094,0.3622,0.44094,0.37008,0.44094,0.37795,0.44094,0.38583,0.44094,0.3937,0.44094,0.40157,0.44094,0.40945,0.44094,0.41732,0.44094,0.4252,0.44094,0.43307,0.44094,0.44094,0.44094,0.44882,0.44094,0.45669,0.44094,0.46457,0.44094,0.47244,0.44094,0.48031,0.44094,0.48819,0.44094,0.49606,0.44094,0.50394,0.44094,0.51181,0.44094,0.51969,0.44094,0.52756,0.44094,0.53543,0.44094,0.54331,0.44094,0.55118,0.44094,0.55906,0.44094,0.56693,0.44094,0.5748,0.44094,0.58268,0.44094,0.59055,0.44094,0.59843,0.44094,0.6063,0.44094,0.61417,0.44094,0.62205,0.44094,0.62992,0.44094,0.6378,0.44094,0.64567,0.44094,0.65354,0.44094,0.66142,0.44094,0.66929,0.44094,0.67717,0.44094,0.68504,0.44094,0.69291,0.44094,0.70079,0.44094,0.70866,0.44094,0.71654,0.44094,0.72441,0.44094,0.73228,0.44094,0.74016,0.44094,0.74803,0.44094,0.75591,0.44094,0.76378,0.44094,0.77165,0.44094,0.77953,0.44094,0.7874,0.44094,0.79528,0.44094,0.80315,0.44094,0.81102,0.44094,0.8189,0.44094,0.82677,0.44094,0.83465,0.44094,0.84252,0.44094,0.85039,0.44094,0.85827,0.44094,0.86614,0.44094,0.87402,0.44094,0.88189,0.44094,0.88976,0.44094,0.89764,0.44094,0.90551,0.44094,0.91339,0.44094,0.92126,0.44094,0.92913,0.44094,0.93701,0.44094,0.94488,0.44094,0.95276,0.44094,0.96063,0.44094,0.9685,0.44094,0.97638,0.44094,0.98425,0.44094,0.99213,0.44094,0.99609,0.44094,0.00391,0.44882,0.00787,0.44882,0.01575,0.44882,0.02362,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_74()
		{
			double[] value = {0.0315,0.44882,0.03937,0.44882,0.04724,0.44882,0.05512,0.44882,0.06299,0.44882,0.07087,0.44882,0.07874,0.44882,0.08661,0.44882,0.09449,0.44882,0.10236,0.44882,0.11024,0.44882,0.11811,0.44882,0.12598,0.44882,0.13386,0.44882,0.14173,0.44882,0.14961,0.44882,0.15748,0.44882,0.16535,0.44882,0.17323,0.44882,0.1811,0.44882,0.18898,0.44882,0.19685,0.44882,0.20472,0.44882,0.2126,0.44882,0.22047,0.44882,0.22835,0.44882,0.23622,0.44882,0.24409,0.44882,0.25197,0.44882,0.25984,0.44882,0.26772,0.44882,0.27559,0.44882,0.28346,0.44882,0.29134,0.44882,0.29921,0.44882,0.30709,0.44882,0.31496,0.44882,0.32283,0.44882,0.33071,0.44882,0.33858,0.44882,0.34646,0.44882,0.35433,0.44882,0.3622,0.44882,0.37008,0.44882,0.37795,0.44882,0.38583,0.44882,0.3937,0.44882,0.40157,0.44882,0.40945,0.44882,0.41732,0.44882,0.4252,0.44882,0.43307,0.44882,0.44094,0.44882,0.44882,0.44882,0.45669,0.44882,0.46457,0.44882,0.47244,0.44882,0.48031,0.44882,0.48819,0.44882,0.49606,0.44882,0.50394,0.44882,0.51181,0.44882,0.51969,0.44882,0.52756,0.44882,0.53543,0.44882,0.54331,0.44882,0.55118,0.44882,0.55906,0.44882,0.56693,0.44882,0.5748,0.44882,0.58268,0.44882,0.59055,0.44882,0.59843,0.44882,0.6063,0.44882,0.61417,0.44882,0.62205,0.44882,0.62992,0.44882,0.6378,0.44882,0.64567,0.44882,0.65354,0.44882,0.66142,0.44882,0.66929,0.44882,0.67717,0.44882,0.68504,0.44882,0.69291,0.44882,0.70079,0.44882,0.70866,0.44882,0.71654,0.44882,0.72441,0.44882,0.73228,0.44882,0.74016,0.44882,0.74803,0.44882,0.75591,0.44882,0.76378,0.44882,0.77165,0.44882,0.77953,0.44882,0.7874,0.44882,0.79528,0.44882,0.80315,0.44882,0.81102,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_75()
		{
			double[] value = {0.8189,0.44882,0.82677,0.44882,0.83465,0.44882,0.84252,0.44882,0.85039,0.44882,0.85827,0.44882,0.86614,0.44882,0.87402,0.44882,0.88189,0.44882,0.88976,0.44882,0.89764,0.44882,0.90551,0.44882,0.91339,0.44882,0.92126,0.44882,0.92913,0.44882,0.93701,0.44882,0.94488,0.44882,0.95276,0.44882,0.96063,0.44882,0.9685,0.44882,0.97638,0.44882,0.98425,0.44882,0.99213,0.44882,0.99609,0.44882,0.00391,0.45669,0.00787,0.45669,0.01575,0.45669,0.02362,0.45669,0.0315,0.45669,0.03937,0.45669,0.04724,0.45669,0.05512,0.45669,0.06299,0.45669,0.07087,0.45669,0.07874,0.45669,0.08661,0.45669,0.09449,0.45669,0.10236,0.45669,0.11024,0.45669,0.11811,0.45669,0.12598,0.45669,0.13386,0.45669,0.14173,0.45669,0.14961,0.45669,0.15748,0.45669,0.16535,0.45669,0.17323,0.45669,0.1811,0.45669,0.18898,0.45669,0.19685,0.45669,0.20472,0.45669,0.2126,0.45669,0.22047,0.45669,0.22835,0.45669,0.23622,0.45669,0.24409,0.45669,0.25197,0.45669,0.25984,0.45669,0.26772,0.45669,0.27559,0.45669,0.28346,0.45669,0.29134,0.45669,0.29921,0.45669,0.30709,0.45669,0.31496,0.45669,0.32283,0.45669,0.33071,0.45669,0.33858,0.45669,0.34646,0.45669,0.35433,0.45669,0.3622,0.45669,0.37008,0.45669,0.37795,0.45669,0.38583,0.45669,0.3937,0.45669,0.40157,0.45669,0.40945,0.45669,0.41732,0.45669,0.4252,0.45669,0.43307,0.45669,0.44094,0.45669,0.44882,0.45669,0.45669,0.45669,0.46457,0.45669,0.47244,0.45669,0.48031,0.45669,0.48819,0.45669,0.49606,0.45669,0.50394,0.45669,0.51181,0.45669,0.51969,0.45669,0.52756,0.45669,0.53543,0.45669,0.54331,0.45669,0.55118,0.45669,0.55906,0.45669,0.56693,0.45669,0.5748,0.45669,0.58268,0.45669,0.59055,0.45669};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_76()
		{
			double[] value = {0.59843,0.45669,0.6063,0.45669,0.61417,0.45669,0.62205,0.45669,0.62992,0.45669,0.6378,0.45669,0.64567,0.45669,0.65354,0.45669,0.66142,0.45669,0.66929,0.45669,0.67717,0.45669,0.68504,0.45669,0.69291,0.45669,0.70079,0.45669,0.70866,0.45669,0.71654,0.45669,0.72441,0.45669,0.73228,0.45669,0.74016,0.45669,0.74803,0.45669,0.75591,0.45669,0.76378,0.45669,0.77165,0.45669,0.77953,0.45669,0.7874,0.45669,0.79528,0.45669,0.80315,0.45669,0.81102,0.45669,0.8189,0.45669,0.82677,0.45669,0.83465,0.45669,0.84252,0.45669,0.85039,0.45669,0.85827,0.45669,0.86614,0.45669,0.87402,0.45669,0.88189,0.45669,0.88976,0.45669,0.89764,0.45669,0.90551,0.45669,0.91339,0.45669,0.92126,0.45669,0.92913,0.45669,0.93701,0.45669,0.94488,0.45669,0.95276,0.45669,0.96063,0.45669,0.9685,0.45669,0.97638,0.45669,0.98425,0.45669,0.99213,0.45669,0.99609,0.45669,0.00391,0.46457,0.00787,0.46457,0.01575,0.46457,0.02362,0.46457,0.0315,0.46457,0.03937,0.46457,0.04724,0.46457,0.05512,0.46457,0.06299,0.46457,0.07087,0.46457,0.07874,0.46457,0.08661,0.46457,0.09449,0.46457,0.10236,0.46457,0.11024,0.46457,0.11811,0.46457,0.12598,0.46457,0.13386,0.46457,0.14173,0.46457,0.14961,0.46457,0.15748,0.46457,0.16535,0.46457,0.17323,0.46457,0.1811,0.46457,0.18898,0.46457,0.19685,0.46457,0.20472,0.46457,0.2126,0.46457,0.22047,0.46457,0.22835,0.46457,0.23622,0.46457,0.24409,0.46457,0.25197,0.46457,0.25984,0.46457,0.26772,0.46457,0.27559,0.46457,0.28346,0.46457,0.29134,0.46457,0.29921,0.46457,0.30709,0.46457,0.31496,0.46457,0.32283,0.46457,0.33071,0.46457,0.33858,0.46457,0.34646,0.46457,0.35433,0.46457,0.3622,0.46457,0.37008,0.46457};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_77()
		{
			double[] value = {0.37795,0.46457,0.38583,0.46457,0.3937,0.46457,0.40157,0.46457,0.40945,0.46457,0.41732,0.46457,0.4252,0.46457,0.43307,0.46457,0.44094,0.46457,0.44882,0.46457,0.45669,0.46457,0.46457,0.46457,0.47244,0.46457,0.48031,0.46457,0.48819,0.46457,0.49606,0.46457,0.50394,0.46457,0.51181,0.46457,0.51969,0.46457,0.52756,0.46457,0.53543,0.46457,0.54331,0.46457,0.55118,0.46457,0.55906,0.46457,0.56693,0.46457,0.5748,0.46457,0.58268,0.46457,0.59055,0.46457,0.59843,0.46457,0.6063,0.46457,0.61417,0.46457,0.62205,0.46457,0.62992,0.46457,0.6378,0.46457,0.64567,0.46457,0.65354,0.46457,0.66142,0.46457,0.66929,0.46457,0.67717,0.46457,0.68504,0.46457,0.69291,0.46457,0.70079,0.46457,0.70866,0.46457,0.71654,0.46457,0.72441,0.46457,0.73228,0.46457,0.74016,0.46457,0.74803,0.46457,0.75591,0.46457,0.76378,0.46457,0.77165,0.46457,0.77953,0.46457,0.7874,0.46457,0.79528,0.46457,0.80315,0.46457,0.81102,0.46457,0.8189,0.46457,0.82677,0.46457,0.83465,0.46457,0.84252,0.46457,0.85039,0.46457,0.85827,0.46457,0.86614,0.46457,0.87402,0.46457,0.88189,0.46457,0.88976,0.46457,0.89764,0.46457,0.90551,0.46457,0.91339,0.46457,0.92126,0.46457,0.92913,0.46457,0.93701,0.46457,0.94488,0.46457,0.95276,0.46457,0.96063,0.46457,0.9685,0.46457,0.97638,0.46457,0.98425,0.46457,0.99213,0.46457,0.99609,0.46457,0.00391,0.47244,0.00787,0.47244,0.01575,0.47244,0.02362,0.47244,0.0315,0.47244,0.03937,0.47244,0.04724,0.47244,0.05512,0.47244,0.06299,0.47244,0.07087,0.47244,0.07874,0.47244,0.08661,0.47244,0.09449,0.47244,0.10236,0.47244,0.11024,0.47244,0.11811,0.47244,0.12598,0.47244,0.13386,0.47244,0.14173,0.47244,0.14961,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_78()
		{
			double[] value = {0.15748,0.47244,0.16535,0.47244,0.17323,0.47244,0.1811,0.47244,0.18898,0.47244,0.19685,0.47244,0.20472,0.47244,0.2126,0.47244,0.22047,0.47244,0.22835,0.47244,0.23622,0.47244,0.24409,0.47244,0.25197,0.47244,0.25984,0.47244,0.26772,0.47244,0.27559,0.47244,0.28346,0.47244,0.29134,0.47244,0.29921,0.47244,0.30709,0.47244,0.31496,0.47244,0.32283,0.47244,0.33071,0.47244,0.33858,0.47244,0.34646,0.47244,0.35433,0.47244,0.3622,0.47244,0.37008,0.47244,0.37795,0.47244,0.38583,0.47244,0.3937,0.47244,0.40157,0.47244,0.40945,0.47244,0.41732,0.47244,0.4252,0.47244,0.43307,0.47244,0.44094,0.47244,0.44882,0.47244,0.45669,0.47244,0.46457,0.47244,0.47244,0.47244,0.48031,0.47244,0.48819,0.47244,0.49606,0.47244,0.50394,0.47244,0.51181,0.47244,0.51969,0.47244,0.52756,0.47244,0.53543,0.47244,0.54331,0.47244,0.55118,0.47244,0.55906,0.47244,0.56693,0.47244,0.5748,0.47244,0.58268,0.47244,0.59055,0.47244,0.59843,0.47244,0.6063,0.47244,0.61417,0.47244,0.62205,0.47244,0.62992,0.47244,0.6378,0.47244,0.64567,0.47244,0.65354,0.47244,0.66142,0.47244,0.66929,0.47244,0.67717,0.47244,0.68504,0.47244,0.69291,0.47244,0.70079,0.47244,0.70866,0.47244,0.71654,0.47244,0.72441,0.47244,0.73228,0.47244,0.74016,0.47244,0.74803,0.47244,0.75591,0.47244,0.76378,0.47244,0.77165,0.47244,0.77953,0.47244,0.7874,0.47244,0.79528,0.47244,0.80315,0.47244,0.81102,0.47244,0.8189,0.47244,0.82677,0.47244,0.83465,0.47244,0.84252,0.47244,0.85039,0.47244,0.85827,0.47244,0.86614,0.47244,0.87402,0.47244,0.88189,0.47244,0.88976,0.47244,0.89764,0.47244,0.90551,0.47244,0.91339,0.47244,0.92126,0.47244,0.92913,0.47244,0.93701,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_79()
		{
			double[] value = {0.94488,0.47244,0.95276,0.47244,0.96063,0.47244,0.9685,0.47244,0.97638,0.47244,0.98425,0.47244,0.99213,0.47244,0.99609,0.47244,0.00391,0.48031,0.00787,0.48031,0.01575,0.48031,0.02362,0.48031,0.0315,0.48031,0.03937,0.48031,0.04724,0.48031,0.05512,0.48031,0.06299,0.48031,0.07087,0.48031,0.07874,0.48031,0.08661,0.48031,0.09449,0.48031,0.10236,0.48031,0.11024,0.48031,0.11811,0.48031,0.12598,0.48031,0.13386,0.48031,0.14173,0.48031,0.14961,0.48031,0.15748,0.48031,0.16535,0.48031,0.17323,0.48031,0.1811,0.48031,0.18898,0.48031,0.19685,0.48031,0.20472,0.48031,0.2126,0.48031,0.22047,0.48031,0.22835,0.48031,0.23622,0.48031,0.24409,0.48031,0.25197,0.48031,0.25984,0.48031,0.26772,0.48031,0.27559,0.48031,0.28346,0.48031,0.29134,0.48031,0.29921,0.48031,0.30709,0.48031,0.31496,0.48031,0.32283,0.48031,0.33071,0.48031,0.33858,0.48031,0.34646,0.48031,0.35433,0.48031,0.3622,0.48031,0.37008,0.48031,0.37795,0.48031,0.38583,0.48031,0.3937,0.48031,0.40157,0.48031,0.40945,0.48031,0.41732,0.48031,0.4252,0.48031,0.43307,0.48031,0.44094,0.48031,0.44882,0.48031,0.45669,0.48031,0.46457,0.48031,0.47244,0.48031,0.48031,0.48031,0.48819,0.48031,0.49606,0.48031,0.50394,0.48031,0.51181,0.48031,0.51969,0.48031,0.52756,0.48031,0.53543,0.48031,0.54331,0.48031,0.55118,0.48031,0.55906,0.48031,0.56693,0.48031,0.5748,0.48031,0.58268,0.48031,0.59055,0.48031,0.59843,0.48031,0.6063,0.48031,0.61417,0.48031,0.62205,0.48031,0.62992,0.48031,0.6378,0.48031,0.64567,0.48031,0.65354,0.48031,0.66142,0.48031,0.66929,0.48031,0.67717,0.48031,0.68504,0.48031,0.69291,0.48031,0.70079,0.48031,0.70866,0.48031,0.71654,0.48031};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_80()
		{
			double[] value = {0.72441,0.48031,0.73228,0.48031,0.74016,0.48031,0.74803,0.48031,0.75591,0.48031,0.76378,0.48031,0.77165,0.48031,0.77953,0.48031,0.7874,0.48031,0.79528,0.48031,0.80315,0.48031,0.81102,0.48031,0.8189,0.48031,0.82677,0.48031,0.83465,0.48031,0.84252,0.48031,0.85039,0.48031,0.85827,0.48031,0.86614,0.48031,0.87402,0.48031,0.88189,0.48031,0.88976,0.48031,0.89764,0.48031,0.90551,0.48031,0.91339,0.48031,0.92126,0.48031,0.92913,0.48031,0.93701,0.48031,0.94488,0.48031,0.95276,0.48031,0.96063,0.48031,0.9685,0.48031,0.97638,0.48031,0.98425,0.48031,0.99213,0.48031,0.99609,0.48031,0.00391,0.48819,0.00787,0.48819,0.01575,0.48819,0.02362,0.48819,0.0315,0.48819,0.03937,0.48819,0.04724,0.48819,0.05512,0.48819,0.06299,0.48819,0.07087,0.48819,0.07874,0.48819,0.08661,0.48819,0.09449,0.48819,0.10236,0.48819,0.11024,0.48819,0.11811,0.48819,0.12598,0.48819,0.13386,0.48819,0.14173,0.48819,0.14961,0.48819,0.15748,0.48819,0.16535,0.48819,0.17323,0.48819,0.1811,0.48819,0.18898,0.48819,0.19685,0.48819,0.20472,0.48819,0.2126,0.48819,0.22047,0.48819,0.22835,0.48819,0.23622,0.48819,0.24409,0.48819,0.25197,0.48819,0.25984,0.48819,0.26772,0.48819,0.27559,0.48819,0.28346,0.48819,0.29134,0.48819,0.29921,0.48819,0.30709,0.48819,0.31496,0.48819,0.32283,0.48819,0.33071,0.48819,0.33858,0.48819,0.34646,0.48819,0.35433,0.48819,0.3622,0.48819,0.37008,0.48819,0.37795,0.48819,0.38583,0.48819,0.3937,0.48819,0.40157,0.48819,0.40945,0.48819,0.41732,0.48819,0.4252,0.48819,0.43307,0.48819,0.44094,0.48819,0.44882,0.48819,0.45669,0.48819,0.46457,0.48819,0.47244,0.48819,0.48031,0.48819,0.48819,0.48819,0.49606,0.48819};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_81()
		{
			double[] value = {0.50394,0.48819,0.51181,0.48819,0.51969,0.48819,0.52756,0.48819,0.53543,0.48819,0.54331,0.48819,0.55118,0.48819,0.55906,0.48819,0.56693,0.48819,0.5748,0.48819,0.58268,0.48819,0.59055,0.48819,0.59843,0.48819,0.6063,0.48819,0.61417,0.48819,0.62205,0.48819,0.62992,0.48819,0.6378,0.48819,0.64567,0.48819,0.65354,0.48819,0.66142,0.48819,0.66929,0.48819,0.67717,0.48819,0.68504,0.48819,0.69291,0.48819,0.70079,0.48819,0.70866,0.48819,0.71654,0.48819,0.72441,0.48819,0.73228,0.48819,0.74016,0.48819,0.74803,0.48819,0.75591,0.48819,0.76378,0.48819,0.77165,0.48819,0.77953,0.48819,0.7874,0.48819,0.79528,0.48819,0.80315,0.48819,0.81102,0.48819,0.8189,0.48819,0.82677,0.48819,0.83465,0.48819,0.84252,0.48819,0.85039,0.48819,0.85827,0.48819,0.86614,0.48819,0.87402,0.48819,0.88189,0.48819,0.88976,0.48819,0.89764,0.48819,0.90551,0.48819,0.91339,0.48819,0.92126,0.48819,0.92913,0.48819,0.93701,0.48819,0.94488,0.48819,0.95276,0.48819,0.96063,0.48819,0.9685,0.48819,0.97638,0.48819,0.98425,0.48819,0.99213,0.48819,0.99609,0.48819,0.00391,0.49606,0.00787,0.49606,0.01575,0.49606,0.02362,0.49606,0.0315,0.49606,0.03937,0.49606,0.04724,0.49606,0.05512,0.49606,0.06299,0.49606,0.07087,0.49606,0.07874,0.49606,0.08661,0.49606,0.09449,0.49606,0.10236,0.49606,0.11024,0.49606,0.11811,0.49606,0.12598,0.49606,0.13386,0.49606,0.14173,0.49606,0.14961,0.49606,0.15748,0.49606,0.16535,0.49606,0.17323,0.49606,0.1811,0.49606,0.18898,0.49606,0.19685,0.49606,0.20472,0.49606,0.2126,0.49606,0.22047,0.49606,0.22835,0.49606,0.23622,0.49606,0.24409,0.49606,0.25197,0.49606,0.25984,0.49606,0.26772,0.49606,0.27559,0.49606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_82()
		{
			double[] value = {0.28346,0.49606,0.29134,0.49606,0.29921,0.49606,0.30709,0.49606,0.31496,0.49606,0.32283,0.49606,0.33071,0.49606,0.33858,0.49606,0.34646,0.49606,0.35433,0.49606,0.3622,0.49606,0.37008,0.49606,0.37795,0.49606,0.38583,0.49606,0.3937,0.49606,0.40157,0.49606,0.40945,0.49606,0.41732,0.49606,0.4252,0.49606,0.43307,0.49606,0.44094,0.49606,0.44882,0.49606,0.45669,0.49606,0.46457,0.49606,0.47244,0.49606,0.48031,0.49606,0.48819,0.49606,0.49606,0.49606,0.50394,0.49606,0.51181,0.49606,0.51969,0.49606,0.52756,0.49606,0.53543,0.49606,0.54331,0.49606,0.55118,0.49606,0.55906,0.49606,0.56693,0.49606,0.5748,0.49606,0.58268,0.49606,0.59055,0.49606,0.59843,0.49606,0.6063,0.49606,0.61417,0.49606,0.62205,0.49606,0.62992,0.49606,0.6378,0.49606,0.64567,0.49606,0.65354,0.49606,0.66142,0.49606,0.66929,0.49606,0.67717,0.49606,0.68504,0.49606,0.69291,0.49606,0.70079,0.49606,0.70866,0.49606,0.71654,0.49606,0.72441,0.49606,0.73228,0.49606,0.74016,0.49606,0.74803,0.49606,0.75591,0.49606,0.76378,0.49606,0.77165,0.49606,0.77953,0.49606,0.7874,0.49606,0.79528,0.49606,0.80315,0.49606,0.81102,0.49606,0.8189,0.49606,0.82677,0.49606,0.83465,0.49606,0.84252,0.49606,0.85039,0.49606,0.85827,0.49606,0.86614,0.49606,0.87402,0.49606,0.88189,0.49606,0.88976,0.49606,0.89764,0.49606,0.90551,0.49606,0.91339,0.49606,0.92126,0.49606,0.92913,0.49606,0.93701,0.49606,0.94488,0.49606,0.95276,0.49606,0.96063,0.49606,0.9685,0.49606,0.97638,0.49606,0.98425,0.49606,0.99213,0.49606,0.99609,0.49606,0.00391,0.50394,0.00787,0.50394,0.01575,0.50394,0.02362,0.50394,0.0315,0.50394,0.03937,0.50394,0.04724,0.50394,0.05512,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_83()
		{
			double[] value = {0.06299,0.50394,0.07087,0.50394,0.07874,0.50394,0.08661,0.50394,0.09449,0.50394,0.10236,0.50394,0.11024,0.50394,0.11811,0.50394,0.12598,0.50394,0.13386,0.50394,0.14173,0.50394,0.14961,0.50394,0.15748,0.50394,0.16535,0.50394,0.17323,0.50394,0.1811,0.50394,0.18898,0.50394,0.19685,0.50394,0.20472,0.50394,0.2126,0.50394,0.22047,0.50394,0.22835,0.50394,0.23622,0.50394,0.24409,0.50394,0.25197,0.50394,0.25984,0.50394,0.26772,0.50394,0.27559,0.50394,0.28346,0.50394,0.29134,0.50394,0.29921,0.50394,0.30709,0.50394,0.31496,0.50394,0.32283,0.50394,0.33071,0.50394,0.33858,0.50394,0.34646,0.50394,0.35433,0.50394,0.3622,0.50394,0.37008,0.50394,0.37795,0.50394,0.38583,0.50394,0.3937,0.50394,0.40157,0.50394,0.40945,0.50394,0.41732,0.50394,0.4252,0.50394,0.43307,0.50394,0.44094,0.50394,0.44882,0.50394,0.45669,0.50394,0.46457,0.50394,0.47244,0.50394,0.48031,0.50394,0.48819,0.50394,0.49606,0.50394,0.50394,0.50394,0.51181,0.50394,0.51969,0.50394,0.52756,0.50394,0.53543,0.50394,0.54331,0.50394,0.55118,0.50394,0.55906,0.50394,0.56693,0.50394,0.5748,0.50394,0.58268,0.50394,0.59055,0.50394,0.59843,0.50394,0.6063,0.50394,0.61417,0.50394,0.62205,0.50394,0.62992,0.50394,0.6378,0.50394,0.64567,0.50394,0.65354,0.50394,0.66142,0.50394,0.66929,0.50394,0.67717,0.50394,0.68504,0.50394,0.69291,0.50394,0.70079,0.50394,0.70866,0.50394,0.71654,0.50394,0.72441,0.50394,0.73228,0.50394,0.74016,0.50394,0.74803,0.50394,0.75591,0.50394,0.76378,0.50394,0.77165,0.50394,0.77953,0.50394,0.7874,0.50394,0.79528,0.50394,0.80315,0.50394,0.81102,0.50394,0.8189,0.50394,0.82677,0.50394,0.83465,0.50394,0.84252,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_84()
		{
			double[] value = {0.85039,0.50394,0.85827,0.50394,0.86614,0.50394,0.87402,0.50394,0.88189,0.50394,0.88976,0.50394,0.89764,0.50394,0.90551,0.50394,0.91339,0.50394,0.92126,0.50394,0.92913,0.50394,0.93701,0.50394,0.94488,0.50394,0.95276,0.50394,0.96063,0.50394,0.9685,0.50394,0.97638,0.50394,0.98425,0.50394,0.99213,0.50394,0.99609,0.50394,0.00391,0.51181,0.00787,0.51181,0.01575,0.51181,0.02362,0.51181,0.0315,0.51181,0.03937,0.51181,0.04724,0.51181,0.05512,0.51181,0.06299,0.51181,0.07087,0.51181,0.07874,0.51181,0.08661,0.51181,0.09449,0.51181,0.10236,0.51181,0.11024,0.51181,0.11811,0.51181,0.12598,0.51181,0.13386,0.51181,0.14173,0.51181,0.14961,0.51181,0.15748,0.51181,0.16535,0.51181,0.17323,0.51181,0.1811,0.51181,0.18898,0.51181,0.19685,0.51181,0.20472,0.51181,0.2126,0.51181,0.22047,0.51181,0.22835,0.51181,0.23622,0.51181,0.24409,0.51181,0.25197,0.51181,0.25984,0.51181,0.26772,0.51181,0.27559,0.51181,0.28346,0.51181,0.29134,0.51181,0.29921,0.51181,0.30709,0.51181,0.31496,0.51181,0.32283,0.51181,0.33071,0.51181,0.33858,0.51181,0.34646,0.51181,0.35433,0.51181,0.3622,0.51181,0.37008,0.51181,0.37795,0.51181,0.38583,0.51181,0.3937,0.51181,0.40157,0.51181,0.40945,0.51181,0.41732,0.51181,0.4252,0.51181,0.43307,0.51181,0.44094,0.51181,0.44882,0.51181,0.45669,0.51181,0.46457,0.51181,0.47244,0.51181,0.48031,0.51181,0.48819,0.51181,0.49606,0.51181,0.50394,0.51181,0.51181,0.51181,0.51969,0.51181,0.52756,0.51181,0.53543,0.51181,0.54331,0.51181,0.55118,0.51181,0.55906,0.51181,0.56693,0.51181,0.5748,0.51181,0.58268,0.51181,0.59055,0.51181,0.59843,0.51181,0.6063,0.51181,0.61417,0.51181,0.62205,0.51181};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_85()
		{
			double[] value = {0.62992,0.51181,0.6378,0.51181,0.64567,0.51181,0.65354,0.51181,0.66142,0.51181,0.66929,0.51181,0.67717,0.51181,0.68504,0.51181,0.69291,0.51181,0.70079,0.51181,0.70866,0.51181,0.71654,0.51181,0.72441,0.51181,0.73228,0.51181,0.74016,0.51181,0.74803,0.51181,0.75591,0.51181,0.76378,0.51181,0.77165,0.51181,0.77953,0.51181,0.7874,0.51181,0.79528,0.51181,0.80315,0.51181,0.81102,0.51181,0.8189,0.51181,0.82677,0.51181,0.83465,0.51181,0.84252,0.51181,0.85039,0.51181,0.85827,0.51181,0.86614,0.51181,0.87402,0.51181,0.88189,0.51181,0.88976,0.51181,0.89764,0.51181,0.90551,0.51181,0.91339,0.51181,0.92126,0.51181,0.92913,0.51181,0.93701,0.51181,0.94488,0.51181,0.95276,0.51181,0.96063,0.51181,0.9685,0.51181,0.97638,0.51181,0.98425,0.51181,0.99213,0.51181,0.99609,0.51181,0.00391,0.51969,0.00787,0.51969,0.01575,0.51969,0.02362,0.51969,0.0315,0.51969,0.03937,0.51969,0.04724,0.51969,0.05512,0.51969,0.06299,0.51969,0.07087,0.51969,0.07874,0.51969,0.08661,0.51969,0.09449,0.51969,0.10236,0.51969,0.11024,0.51969,0.11811,0.51969,0.12598,0.51969,0.13386,0.51969,0.14173,0.51969,0.14961,0.51969,0.15748,0.51969,0.16535,0.51969,0.17323,0.51969,0.1811,0.51969,0.18898,0.51969,0.19685,0.51969,0.20472,0.51969,0.2126,0.51969,0.22047,0.51969,0.22835,0.51969,0.23622,0.51969,0.24409,0.51969,0.25197,0.51969,0.25984,0.51969,0.26772,0.51969,0.27559,0.51969,0.28346,0.51969,0.29134,0.51969,0.29921,0.51969,0.30709,0.51969,0.31496,0.51969,0.32283,0.51969,0.33071,0.51969,0.33858,0.51969,0.34646,0.51969,0.35433,0.51969,0.3622,0.51969,0.37008,0.51969,0.37795,0.51969,0.38583,0.51969,0.3937,0.51969,0.40157,0.51969};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_86()
		{
			double[] value = {0.40945,0.51969,0.41732,0.51969,0.4252,0.51969,0.43307,0.51969,0.44094,0.51969,0.44882,0.51969,0.45669,0.51969,0.46457,0.51969,0.47244,0.51969,0.48031,0.51969,0.48819,0.51969,0.49606,0.51969,0.50394,0.51969,0.51181,0.51969,0.51969,0.51969,0.52756,0.51969,0.53543,0.51969,0.54331,0.51969,0.55118,0.51969,0.55906,0.51969,0.56693,0.51969,0.5748,0.51969,0.58268,0.51969,0.59055,0.51969,0.59843,0.51969,0.6063,0.51969,0.61417,0.51969,0.62205,0.51969,0.62992,0.51969,0.6378,0.51969,0.64567,0.51969,0.65354,0.51969,0.66142,0.51969,0.66929,0.51969,0.67717,0.51969,0.68504,0.51969,0.69291,0.51969,0.70079,0.51969,0.70866,0.51969,0.71654,0.51969,0.72441,0.51969,0.73228,0.51969,0.74016,0.51969,0.74803,0.51969,0.75591,0.51969,0.76378,0.51969,0.77165,0.51969,0.77953,0.51969,0.7874,0.51969,0.79528,0.51969,0.80315,0.51969,0.81102,0.51969,0.8189,0.51969,0.82677,0.51969,0.83465,0.51969,0.84252,0.51969,0.85039,0.51969,0.85827,0.51969,0.86614,0.51969,0.87402,0.51969,0.88189,0.51969,0.88976,0.51969,0.89764,0.51969,0.90551,0.51969,0.91339,0.51969,0.92126,0.51969,0.92913,0.51969,0.93701,0.51969,0.94488,0.51969,0.95276,0.51969,0.96063,0.51969,0.9685,0.51969,0.97638,0.51969,0.98425,0.51969,0.99213,0.51969,0.99609,0.51969,0.00391,0.52756,0.00787,0.52756,0.01575,0.52756,0.02362,0.52756,0.0315,0.52756,0.03937,0.52756,0.04724,0.52756,0.05512,0.52756,0.06299,0.52756,0.07087,0.52756,0.07874,0.52756,0.08661,0.52756,0.09449,0.52756,0.10236,0.52756,0.11024,0.52756,0.11811,0.52756,0.12598,0.52756,0.13386,0.52756,0.14173,0.52756,0.14961,0.52756,0.15748,0.52756,0.16535,0.52756,0.17323,0.52756,0.1811,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_87()
		{
			double[] value = {0.18898,0.52756,0.19685,0.52756,0.20472,0.52756,0.2126,0.52756,0.22047,0.52756,0.22835,0.52756,0.23622,0.52756,0.24409,0.52756,0.25197,0.52756,0.25984,0.52756,0.26772,0.52756,0.27559,0.52756,0.28346,0.52756,0.29134,0.52756,0.29921,0.52756,0.30709,0.52756,0.31496,0.52756,0.32283,0.52756,0.33071,0.52756,0.33858,0.52756,0.34646,0.52756,0.35433,0.52756,0.3622,0.52756,0.37008,0.52756,0.37795,0.52756,0.38583,0.52756,0.3937,0.52756,0.40157,0.52756,0.40945,0.52756,0.41732,0.52756,0.4252,0.52756,0.43307,0.52756,0.44094,0.52756,0.44882,0.52756,0.45669,0.52756,0.46457,0.52756,0.47244,0.52756,0.48031,0.52756,0.48819,0.52756,0.49606,0.52756,0.50394,0.52756,0.51181,0.52756,0.51969,0.52756,0.52756,0.52756,0.53543,0.52756,0.54331,0.52756,0.55118,0.52756,0.55906,0.52756,0.56693,0.52756,0.5748,0.52756,0.58268,0.52756,0.59055,0.52756,0.59843,0.52756,0.6063,0.52756,0.61417,0.52756,0.62205,0.52756,0.62992,0.52756,0.6378,0.52756,0.64567,0.52756,0.65354,0.52756,0.66142,0.52756,0.66929,0.52756,0.67717,0.52756,0.68504,0.52756,0.69291,0.52756,0.70079,0.52756,0.70866,0.52756,0.71654,0.52756,0.72441,0.52756,0.73228,0.52756,0.74016,0.52756,0.74803,0.52756,0.75591,0.52756,0.76378,0.52756,0.77165,0.52756,0.77953,0.52756,0.7874,0.52756,0.79528,0.52756,0.80315,0.52756,0.81102,0.52756,0.8189,0.52756,0.82677,0.52756,0.83465,0.52756,0.84252,0.52756,0.85039,0.52756,0.85827,0.52756,0.86614,0.52756,0.87402,0.52756,0.88189,0.52756,0.88976,0.52756,0.89764,0.52756,0.90551,0.52756,0.91339,0.52756,0.92126,0.52756,0.92913,0.52756,0.93701,0.52756,0.94488,0.52756,0.95276,0.52756,0.96063,0.52756,0.9685,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_88()
		{
			double[] value = {0.97638,0.52756,0.98425,0.52756,0.99213,0.52756,0.99609,0.52756,0.00391,0.53543,0.00787,0.53543,0.01575,0.53543,0.02362,0.53543,0.0315,0.53543,0.03937,0.53543,0.04724,0.53543,0.05512,0.53543,0.06299,0.53543,0.07087,0.53543,0.07874,0.53543,0.08661,0.53543,0.09449,0.53543,0.10236,0.53543,0.11024,0.53543,0.11811,0.53543,0.12598,0.53543,0.13386,0.53543,0.14173,0.53543,0.14961,0.53543,0.15748,0.53543,0.16535,0.53543,0.17323,0.53543,0.1811,0.53543,0.18898,0.53543,0.19685,0.53543,0.20472,0.53543,0.2126,0.53543,0.22047,0.53543,0.22835,0.53543,0.23622,0.53543,0.24409,0.53543,0.25197,0.53543,0.25984,0.53543,0.26772,0.53543,0.27559,0.53543,0.28346,0.53543,0.29134,0.53543,0.29921,0.53543,0.30709,0.53543,0.31496,0.53543,0.32283,0.53543,0.33071,0.53543,0.33858,0.53543,0.34646,0.53543,0.35433,0.53543,0.3622,0.53543,0.37008,0.53543,0.37795,0.53543,0.38583,0.53543,0.3937,0.53543,0.40157,0.53543,0.40945,0.53543,0.41732,0.53543,0.4252,0.53543,0.43307,0.53543,0.44094,0.53543,0.44882,0.53543,0.45669,0.53543,0.46457,0.53543,0.47244,0.53543,0.48031,0.53543,0.48819,0.53543,0.49606,0.53543,0.50394,0.53543,0.51181,0.53543,0.51969,0.53543,0.52756,0.53543,0.53543,0.53543,0.54331,0.53543,0.55118,0.53543,0.55906,0.53543,0.56693,0.53543,0.5748,0.53543,0.58268,0.53543,0.59055,0.53543,0.59843,0.53543,0.6063,0.53543,0.61417,0.53543,0.62205,0.53543,0.62992,0.53543,0.6378,0.53543,0.64567,0.53543,0.65354,0.53543,0.66142,0.53543,0.66929,0.53543,0.67717,0.53543,0.68504,0.53543,0.69291,0.53543,0.70079,0.53543,0.70866,0.53543,0.71654,0.53543,0.72441,0.53543,0.73228,0.53543,0.74016,0.53543,0.74803,0.53543};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_89()
		{
			double[] value = {0.75591,0.53543,0.76378,0.53543,0.77165,0.53543,0.77953,0.53543,0.7874,0.53543,0.79528,0.53543,0.80315,0.53543,0.81102,0.53543,0.8189,0.53543,0.82677,0.53543,0.83465,0.53543,0.84252,0.53543,0.85039,0.53543,0.85827,0.53543,0.86614,0.53543,0.87402,0.53543,0.88189,0.53543,0.88976,0.53543,0.89764,0.53543,0.90551,0.53543,0.91339,0.53543,0.92126,0.53543,0.92913,0.53543,0.93701,0.53543,0.94488,0.53543,0.95276,0.53543,0.96063,0.53543,0.9685,0.53543,0.97638,0.53543,0.98425,0.53543,0.99213,0.53543,0.99609,0.53543,0.00391,0.54331,0.00787,0.54331,0.01575,0.54331,0.02362,0.54331,0.0315,0.54331,0.03937,0.54331,0.04724,0.54331,0.05512,0.54331,0.06299,0.54331,0.07087,0.54331,0.07874,0.54331,0.08661,0.54331,0.09449,0.54331,0.10236,0.54331,0.11024,0.54331,0.11811,0.54331,0.12598,0.54331,0.13386,0.54331,0.14173,0.54331,0.14961,0.54331,0.15748,0.54331,0.16535,0.54331,0.17323,0.54331,0.1811,0.54331,0.18898,0.54331,0.19685,0.54331,0.20472,0.54331,0.2126,0.54331,0.22047,0.54331,0.22835,0.54331,0.23622,0.54331,0.24409,0.54331,0.25197,0.54331,0.25984,0.54331,0.26772,0.54331,0.27559,0.54331,0.28346,0.54331,0.29134,0.54331,0.29921,0.54331,0.30709,0.54331,0.31496,0.54331,0.32283,0.54331,0.33071,0.54331,0.33858,0.54331,0.34646,0.54331,0.35433,0.54331,0.3622,0.54331,0.37008,0.54331,0.37795,0.54331,0.38583,0.54331,0.3937,0.54331,0.40157,0.54331,0.40945,0.54331,0.41732,0.54331,0.4252,0.54331,0.43307,0.54331,0.44094,0.54331,0.44882,0.54331,0.45669,0.54331,0.46457,0.54331,0.47244,0.54331,0.48031,0.54331,0.48819,0.54331,0.49606,0.54331,0.50394,0.54331,0.51181,0.54331,0.51969,0.54331,0.52756,0.54331};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_90()
		{
			double[] value = {0.53543,0.54331,0.54331,0.54331,0.55118,0.54331,0.55906,0.54331,0.56693,0.54331,0.5748,0.54331,0.58268,0.54331,0.59055,0.54331,0.59843,0.54331,0.6063,0.54331,0.61417,0.54331,0.62205,0.54331,0.62992,0.54331,0.6378,0.54331,0.64567,0.54331,0.65354,0.54331,0.66142,0.54331,0.66929,0.54331,0.67717,0.54331,0.68504,0.54331,0.69291,0.54331,0.70079,0.54331,0.70866,0.54331,0.71654,0.54331,0.72441,0.54331,0.73228,0.54331,0.74016,0.54331,0.74803,0.54331,0.75591,0.54331,0.76378,0.54331,0.77165,0.54331,0.77953,0.54331,0.7874,0.54331,0.79528,0.54331,0.80315,0.54331,0.81102,0.54331,0.8189,0.54331,0.82677,0.54331,0.83465,0.54331,0.84252,0.54331,0.85039,0.54331,0.85827,0.54331,0.86614,0.54331,0.87402,0.54331,0.88189,0.54331,0.88976,0.54331,0.89764,0.54331,0.90551,0.54331,0.91339,0.54331,0.92126,0.54331,0.92913,0.54331,0.93701,0.54331,0.94488,0.54331,0.95276,0.54331,0.96063,0.54331,0.9685,0.54331,0.97638,0.54331,0.98425,0.54331,0.99213,0.54331,0.99609,0.54331,0.00391,0.55118,0.00787,0.55118,0.01575,0.55118,0.02362,0.55118,0.0315,0.55118,0.03937,0.55118,0.04724,0.55118,0.05512,0.55118,0.06299,0.55118,0.07087,0.55118,0.07874,0.55118,0.08661,0.55118,0.09449,0.55118,0.10236,0.55118,0.11024,0.55118,0.11811,0.55118,0.12598,0.55118,0.13386,0.55118,0.14173,0.55118,0.14961,0.55118,0.15748,0.55118,0.16535,0.55118,0.17323,0.55118,0.1811,0.55118,0.18898,0.55118,0.19685,0.55118,0.20472,0.55118,0.2126,0.55118,0.22047,0.55118,0.22835,0.55118,0.23622,0.55118,0.24409,0.55118,0.25197,0.55118,0.25984,0.55118,0.26772,0.55118,0.27559,0.55118,0.28346,0.55118,0.29134,0.55118,0.29921,0.55118,0.30709,0.55118};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_91()
		{
			double[] value = {0.31496,0.55118,0.32283,0.55118,0.33071,0.55118,0.33858,0.55118,0.34646,0.55118,0.35433,0.55118,0.3622,0.55118,0.37008,0.55118,0.37795,0.55118,0.38583,0.55118,0.3937,0.55118,0.40157,0.55118,0.40945,0.55118,0.41732,0.55118,0.4252,0.55118,0.43307,0.55118,0.44094,0.55118,0.44882,0.55118,0.45669,0.55118,0.46457,0.55118,0.47244,0.55118,0.48031,0.55118,0.48819,0.55118,0.49606,0.55118,0.50394,0.55118,0.51181,0.55118,0.51969,0.55118,0.52756,0.55118,0.53543,0.55118,0.54331,0.55118,0.55118,0.55118,0.55906,0.55118,0.56693,0.55118,0.5748,0.55118,0.58268,0.55118,0.59055,0.55118,0.59843,0.55118,0.6063,0.55118,0.61417,0.55118,0.62205,0.55118,0.62992,0.55118,0.6378,0.55118,0.64567,0.55118,0.65354,0.55118,0.66142,0.55118,0.66929,0.55118,0.67717,0.55118,0.68504,0.55118,0.69291,0.55118,0.70079,0.55118,0.70866,0.55118,0.71654,0.55118,0.72441,0.55118,0.73228,0.55118,0.74016,0.55118,0.74803,0.55118,0.75591,0.55118,0.76378,0.55118,0.77165,0.55118,0.77953,0.55118,0.7874,0.55118,0.79528,0.55118,0.80315,0.55118,0.81102,0.55118,0.8189,0.55118,0.82677,0.55118,0.83465,0.55118,0.84252,0.55118,0.85039,0.55118,0.85827,0.55118,0.86614,0.55118,0.87402,0.55118,0.88189,0.55118,0.88976,0.55118,0.89764,0.55118,0.90551,0.55118,0.91339,0.55118,0.92126,0.55118,0.92913,0.55118,0.93701,0.55118,0.94488,0.55118,0.95276,0.55118,0.96063,0.55118,0.9685,0.55118,0.97638,0.55118,0.98425,0.55118,0.99213,0.55118,0.99609,0.55118,0.00391,0.55906,0.00787,0.55906,0.01575,0.55906,0.02362,0.55906,0.0315,0.55906,0.03937,0.55906,0.04724,0.55906,0.05512,0.55906,0.06299,0.55906,0.07087,0.55906,0.07874,0.55906,0.08661,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_92()
		{
			double[] value = {0.09449,0.55906,0.10236,0.55906,0.11024,0.55906,0.11811,0.55906,0.12598,0.55906,0.13386,0.55906,0.14173,0.55906,0.14961,0.55906,0.15748,0.55906,0.16535,0.55906,0.17323,0.55906,0.1811,0.55906,0.18898,0.55906,0.19685,0.55906,0.20472,0.55906,0.2126,0.55906,0.22047,0.55906,0.22835,0.55906,0.23622,0.55906,0.24409,0.55906,0.25197,0.55906,0.25984,0.55906,0.26772,0.55906,0.27559,0.55906,0.28346,0.55906,0.29134,0.55906,0.29921,0.55906,0.30709,0.55906,0.31496,0.55906,0.32283,0.55906,0.33071,0.55906,0.33858,0.55906,0.34646,0.55906,0.35433,0.55906,0.3622,0.55906,0.37008,0.55906,0.37795,0.55906,0.38583,0.55906,0.3937,0.55906,0.40157,0.55906,0.40945,0.55906,0.41732,0.55906,0.4252,0.55906,0.43307,0.55906,0.44094,0.55906,0.44882,0.55906,0.45669,0.55906,0.46457,0.55906,0.47244,0.55906,0.48031,0.55906,0.48819,0.55906,0.49606,0.55906,0.50394,0.55906,0.51181,0.55906,0.51969,0.55906,0.52756,0.55906,0.53543,0.55906,0.54331,0.55906,0.55118,0.55906,0.55906,0.55906,0.56693,0.55906,0.5748,0.55906,0.58268,0.55906,0.59055,0.55906,0.59843,0.55906,0.6063,0.55906,0.61417,0.55906,0.62205,0.55906,0.62992,0.55906,0.6378,0.55906,0.64567,0.55906,0.65354,0.55906,0.66142,0.55906,0.66929,0.55906,0.67717,0.55906,0.68504,0.55906,0.69291,0.55906,0.70079,0.55906,0.70866,0.55906,0.71654,0.55906,0.72441,0.55906,0.73228,0.55906,0.74016,0.55906,0.74803,0.55906,0.75591,0.55906,0.76378,0.55906,0.77165,0.55906,0.77953,0.55906,0.7874,0.55906,0.79528,0.55906,0.80315,0.55906,0.81102,0.55906,0.8189,0.55906,0.82677,0.55906,0.83465,0.55906,0.84252,0.55906,0.85039,0.55906,0.85827,0.55906,0.86614,0.55906,0.87402,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_93()
		{
			double[] value = {0.88189,0.55906,0.88976,0.55906,0.89764,0.55906,0.90551,0.55906,0.91339,0.55906,0.92126,0.55906,0.92913,0.55906,0.93701,0.55906,0.94488,0.55906,0.95276,0.55906,0.96063,0.55906,0.9685,0.55906,0.97638,0.55906,0.98425,0.55906,0.99213,0.55906,0.99609,0.55906,0.00391,0.56693,0.00787,0.56693,0.01575,0.56693,0.02362,0.56693,0.0315,0.56693,0.03937,0.56693,0.04724,0.56693,0.05512,0.56693,0.06299,0.56693,0.07087,0.56693,0.07874,0.56693,0.08661,0.56693,0.09449,0.56693,0.10236,0.56693,0.11024,0.56693,0.11811,0.56693,0.12598,0.56693,0.13386,0.56693,0.14173,0.56693,0.14961,0.56693,0.15748,0.56693,0.16535,0.56693,0.17323,0.56693,0.1811,0.56693,0.18898,0.56693,0.19685,0.56693,0.20472,0.56693,0.2126,0.56693,0.22047,0.56693,0.22835,0.56693,0.23622,0.56693,0.24409,0.56693,0.25197,0.56693,0.25984,0.56693,0.26772,0.56693,0.27559,0.56693,0.28346,0.56693,0.29134,0.56693,0.29921,0.56693,0.30709,0.56693,0.31496,0.56693,0.32283,0.56693,0.33071,0.56693,0.33858,0.56693,0.34646,0.56693,0.35433,0.56693,0.3622,0.56693,0.37008,0.56693,0.37795,0.56693,0.38583,0.56693,0.3937,0.56693,0.40157,0.56693,0.40945,0.56693,0.41732,0.56693,0.4252,0.56693,0.43307,0.56693,0.44094,0.56693,0.44882,0.56693,0.45669,0.56693,0.46457,0.56693,0.47244,0.56693,0.48031,0.56693,0.48819,0.56693,0.49606,0.56693,0.50394,0.56693,0.51181,0.56693,0.51969,0.56693,0.52756,0.56693,0.53543,0.56693,0.54331,0.56693,0.55118,0.56693,0.55906,0.56693,0.56693,0.56693,0.5748,0.56693,0.58268,0.56693,0.59055,0.56693,0.59843,0.56693,0.6063,0.56693,0.61417,0.56693,0.62205,0.56693,0.62992,0.56693,0.6378,0.56693,0.64567,0.56693,0.65354,0.56693};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_94()
		{
			double[] value = {0.66142,0.56693,0.66929,0.56693,0.67717,0.56693,0.68504,0.56693,0.69291,0.56693,0.70079,0.56693,0.70866,0.56693,0.71654,0.56693,0.72441,0.56693,0.73228,0.56693,0.74016,0.56693,0.74803,0.56693,0.75591,0.56693,0.76378,0.56693,0.77165,0.56693,0.77953,0.56693,0.7874,0.56693,0.79528,0.56693,0.80315,0.56693,0.81102,0.56693,0.8189,0.56693,0.82677,0.56693,0.83465,0.56693,0.84252,0.56693,0.85039,0.56693,0.85827,0.56693,0.86614,0.56693,0.87402,0.56693,0.88189,0.56693,0.88976,0.56693,0.89764,0.56693,0.90551,0.56693,0.91339,0.56693,0.92126,0.56693,0.92913,0.56693,0.93701,0.56693,0.94488,0.56693,0.95276,0.56693,0.96063,0.56693,0.9685,0.56693,0.97638,0.56693,0.98425,0.56693,0.99213,0.56693,0.99609,0.56693,0.00391,0.5748,0.00787,0.5748,0.01575,0.5748,0.02362,0.5748,0.0315,0.5748,0.03937,0.5748,0.04724,0.5748,0.05512,0.5748,0.06299,0.5748,0.07087,0.5748,0.07874,0.5748,0.08661,0.5748,0.09449,0.5748,0.10236,0.5748,0.11024,0.5748,0.11811,0.5748,0.12598,0.5748,0.13386,0.5748,0.14173,0.5748,0.14961,0.5748,0.15748,0.5748,0.16535,0.5748,0.17323,0.5748,0.1811,0.5748,0.18898,0.5748,0.19685,0.5748,0.20472,0.5748,0.2126,0.5748,0.22047,0.5748,0.22835,0.5748,0.23622,0.5748,0.24409,0.5748,0.25197,0.5748,0.25984,0.5748,0.26772,0.5748,0.27559,0.5748,0.28346,0.5748,0.29134,0.5748,0.29921,0.5748,0.30709,0.5748,0.31496,0.5748,0.32283,0.5748,0.33071,0.5748,0.33858,0.5748,0.34646,0.5748,0.35433,0.5748,0.3622,0.5748,0.37008,0.5748,0.37795,0.5748,0.38583,0.5748,0.3937,0.5748,0.40157,0.5748,0.40945,0.5748,0.41732,0.5748,0.4252,0.5748,0.43307,0.5748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_95()
		{
			double[] value = {0.44094,0.5748,0.44882,0.5748,0.45669,0.5748,0.46457,0.5748,0.47244,0.5748,0.48031,0.5748,0.48819,0.5748,0.49606,0.5748,0.50394,0.5748,0.51181,0.5748,0.51969,0.5748,0.52756,0.5748,0.53543,0.5748,0.54331,0.5748,0.55118,0.5748,0.55906,0.5748,0.56693,0.5748,0.5748,0.5748,0.58268,0.5748,0.59055,0.5748,0.59843,0.5748,0.6063,0.5748,0.61417,0.5748,0.62205,0.5748,0.62992,0.5748,0.6378,0.5748,0.64567,0.5748,0.65354,0.5748,0.66142,0.5748,0.66929,0.5748,0.67717,0.5748,0.68504,0.5748,0.69291,0.5748,0.70079,0.5748,0.70866,0.5748,0.71654,0.5748,0.72441,0.5748,0.73228,0.5748,0.74016,0.5748,0.74803,0.5748,0.75591,0.5748,0.76378,0.5748,0.77165,0.5748,0.77953,0.5748,0.7874,0.5748,0.79528,0.5748,0.80315,0.5748,0.81102,0.5748,0.8189,0.5748,0.82677,0.5748,0.83465,0.5748,0.84252,0.5748,0.85039,0.5748,0.85827,0.5748,0.86614,0.5748,0.87402,0.5748,0.88189,0.5748,0.88976,0.5748,0.89764,0.5748,0.90551,0.5748,0.91339,0.5748,0.92126,0.5748,0.92913,0.5748,0.93701,0.5748,0.94488,0.5748,0.95276,0.5748,0.96063,0.5748,0.9685,0.5748,0.97638,0.5748,0.98425,0.5748,0.99213,0.5748,0.99609,0.5748,0.00391,0.58268,0.00787,0.58268,0.01575,0.58268,0.02362,0.58268,0.0315,0.58268,0.03937,0.58268,0.04724,0.58268,0.05512,0.58268,0.06299,0.58268,0.07087,0.58268,0.07874,0.58268,0.08661,0.58268,0.09449,0.58268,0.10236,0.58268,0.11024,0.58268,0.11811,0.58268,0.12598,0.58268,0.13386,0.58268,0.14173,0.58268,0.14961,0.58268,0.15748,0.58268,0.16535,0.58268,0.17323,0.58268,0.1811,0.58268,0.18898,0.58268,0.19685,0.58268,0.20472,0.58268,0.2126,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_96()
		{
			double[] value = {0.22047,0.58268,0.22835,0.58268,0.23622,0.58268,0.24409,0.58268,0.25197,0.58268,0.25984,0.58268,0.26772,0.58268,0.27559,0.58268,0.28346,0.58268,0.29134,0.58268,0.29921,0.58268,0.30709,0.58268,0.31496,0.58268,0.32283,0.58268,0.33071,0.58268,0.33858,0.58268,0.34646,0.58268,0.35433,0.58268,0.3622,0.58268,0.37008,0.58268,0.37795,0.58268,0.38583,0.58268,0.3937,0.58268,0.40157,0.58268,0.40945,0.58268,0.41732,0.58268,0.4252,0.58268,0.43307,0.58268,0.44094,0.58268,0.44882,0.58268,0.45669,0.58268,0.46457,0.58268,0.47244,0.58268,0.48031,0.58268,0.48819,0.58268,0.49606,0.58268,0.50394,0.58268,0.51181,0.58268,0.51969,0.58268,0.52756,0.58268,0.53543,0.58268,0.54331,0.58268,0.55118,0.58268,0.55906,0.58268,0.56693,0.58268,0.5748,0.58268,0.58268,0.58268,0.59055,0.58268,0.59843,0.58268,0.6063,0.58268,0.61417,0.58268,0.62205,0.58268,0.62992,0.58268,0.6378,0.58268,0.64567,0.58268,0.65354,0.58268,0.66142,0.58268,0.66929,0.58268,0.67717,0.58268,0.68504,0.58268,0.69291,0.58268,0.70079,0.58268,0.70866,0.58268,0.71654,0.58268,0.72441,0.58268,0.73228,0.58268,0.74016,0.58268,0.74803,0.58268,0.75591,0.58268,0.76378,0.58268,0.77165,0.58268,0.77953,0.58268,0.7874,0.58268,0.79528,0.58268,0.80315,0.58268,0.81102,0.58268,0.8189,0.58268,0.82677,0.58268,0.83465,0.58268,0.84252,0.58268,0.85039,0.58268,0.85827,0.58268,0.86614,0.58268,0.87402,0.58268,0.88189,0.58268,0.88976,0.58268,0.89764,0.58268,0.90551,0.58268,0.91339,0.58268,0.92126,0.58268,0.92913,0.58268,0.93701,0.58268,0.94488,0.58268,0.95276,0.58268,0.96063,0.58268,0.9685,0.58268,0.97638,0.58268,0.98425,0.58268,0.99213,0.58268,0.99609,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_97()
		{
			double[] value = {0.00391,0.59055,0.00787,0.59055,0.01575,0.59055,0.02362,0.59055,0.0315,0.59055,0.03937,0.59055,0.04724,0.59055,0.05512,0.59055,0.06299,0.59055,0.07087,0.59055,0.07874,0.59055,0.08661,0.59055,0.09449,0.59055,0.10236,0.59055,0.11024,0.59055,0.11811,0.59055,0.12598,0.59055,0.13386,0.59055,0.14173,0.59055,0.14961,0.59055,0.15748,0.59055,0.16535,0.59055,0.17323,0.59055,0.1811,0.59055,0.18898,0.59055,0.19685,0.59055,0.20472,0.59055,0.2126,0.59055,0.22047,0.59055,0.22835,0.59055,0.23622,0.59055,0.24409,0.59055,0.25197,0.59055,0.25984,0.59055,0.26772,0.59055,0.27559,0.59055,0.28346,0.59055,0.29134,0.59055,0.29921,0.59055,0.30709,0.59055,0.31496,0.59055,0.32283,0.59055,0.33071,0.59055,0.33858,0.59055,0.34646,0.59055,0.35433,0.59055,0.3622,0.59055,0.37008,0.59055,0.37795,0.59055,0.38583,0.59055,0.3937,0.59055,0.40157,0.59055,0.40945,0.59055,0.41732,0.59055,0.4252,0.59055,0.43307,0.59055,0.44094,0.59055,0.44882,0.59055,0.45669,0.59055,0.46457,0.59055,0.47244,0.59055,0.48031,0.59055,0.48819,0.59055,0.49606,0.59055,0.50394,0.59055,0.51181,0.59055,0.51969,0.59055,0.52756,0.59055,0.53543,0.59055,0.54331,0.59055,0.55118,0.59055,0.55906,0.59055,0.56693,0.59055,0.5748,0.59055,0.58268,0.59055,0.59055,0.59055,0.59843,0.59055,0.6063,0.59055,0.61417,0.59055,0.62205,0.59055,0.62992,0.59055,0.6378,0.59055,0.64567,0.59055,0.65354,0.59055,0.66142,0.59055,0.66929,0.59055,0.67717,0.59055,0.68504,0.59055,0.69291,0.59055,0.70079,0.59055,0.70866,0.59055,0.71654,0.59055,0.72441,0.59055,0.73228,0.59055,0.74016,0.59055,0.74803,0.59055,0.75591,0.59055,0.76378,0.59055,0.77165,0.59055,0.77953,0.59055};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_98()
		{
			double[] value = {0.7874,0.59055,0.79528,0.59055,0.80315,0.59055,0.81102,0.59055,0.8189,0.59055,0.82677,0.59055,0.83465,0.59055,0.84252,0.59055,0.85039,0.59055,0.85827,0.59055,0.86614,0.59055,0.87402,0.59055,0.88189,0.59055,0.88976,0.59055,0.89764,0.59055,0.90551,0.59055,0.91339,0.59055,0.92126,0.59055,0.92913,0.59055,0.93701,0.59055,0.94488,0.59055,0.95276,0.59055,0.96063,0.59055,0.9685,0.59055,0.97638,0.59055,0.98425,0.59055,0.99213,0.59055,0.99609,0.59055,0.00391,0.59843,0.00787,0.59843,0.01575,0.59843,0.02362,0.59843,0.0315,0.59843,0.03937,0.59843,0.04724,0.59843,0.05512,0.59843,0.06299,0.59843,0.07087,0.59843,0.07874,0.59843,0.08661,0.59843,0.09449,0.59843,0.10236,0.59843,0.11024,0.59843,0.11811,0.59843,0.12598,0.59843,0.13386,0.59843,0.14173,0.59843,0.14961,0.59843,0.15748,0.59843,0.16535,0.59843,0.17323,0.59843,0.1811,0.59843,0.18898,0.59843,0.19685,0.59843,0.20472,0.59843,0.2126,0.59843,0.22047,0.59843,0.22835,0.59843,0.23622,0.59843,0.24409,0.59843,0.25197,0.59843,0.25984,0.59843,0.26772,0.59843,0.27559,0.59843,0.28346,0.59843,0.29134,0.59843,0.29921,0.59843,0.30709,0.59843,0.31496,0.59843,0.32283,0.59843,0.33071,0.59843,0.33858,0.59843,0.34646,0.59843,0.35433,0.59843,0.3622,0.59843,0.37008,0.59843,0.37795,0.59843,0.38583,0.59843,0.3937,0.59843,0.40157,0.59843,0.40945,0.59843,0.41732,0.59843,0.4252,0.59843,0.43307,0.59843,0.44094,0.59843,0.44882,0.59843,0.45669,0.59843,0.46457,0.59843,0.47244,0.59843,0.48031,0.59843,0.48819,0.59843,0.49606,0.59843,0.50394,0.59843,0.51181,0.59843,0.51969,0.59843,0.52756,0.59843,0.53543,0.59843,0.54331,0.59843,0.55118,0.59843,0.55906,0.59843};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_99()
		{
			double[] value = {0.56693,0.59843,0.5748,0.59843,0.58268,0.59843,0.59055,0.59843,0.59843,0.59843,0.6063,0.59843,0.61417,0.59843,0.62205,0.59843,0.62992,0.59843,0.6378,0.59843,0.64567,0.59843,0.65354,0.59843,0.66142,0.59843,0.66929,0.59843,0.67717,0.59843,0.68504,0.59843,0.69291,0.59843,0.70079,0.59843,0.70866,0.59843,0.71654,0.59843,0.72441,0.59843,0.73228,0.59843,0.74016,0.59843,0.74803,0.59843,0.75591,0.59843,0.76378,0.59843,0.77165,0.59843,0.77953,0.59843,0.7874,0.59843,0.79528,0.59843,0.80315,0.59843,0.81102,0.59843,0.8189,0.59843,0.82677,0.59843,0.83465,0.59843,0.84252,0.59843,0.85039,0.59843,0.85827,0.59843,0.86614,0.59843,0.87402,0.59843,0.88189,0.59843,0.88976,0.59843,0.89764,0.59843,0.90551,0.59843,0.91339,0.59843,0.92126,0.59843,0.92913,0.59843,0.93701,0.59843,0.94488,0.59843,0.95276,0.59843,0.96063,0.59843,0.9685,0.59843,0.97638,0.59843,0.98425,0.59843,0.99213,0.59843,0.99609,0.59843,0.00391,0.6063,0.00787,0.6063,0.01575,0.6063,0.02362,0.6063,0.0315,0.6063,0.03937,0.6063,0.04724,0.6063,0.05512,0.6063,0.06299,0.6063,0.07087,0.6063,0.07874,0.6063,0.08661,0.6063,0.09449,0.6063,0.10236,0.6063,0.11024,0.6063,0.11811,0.6063,0.12598,0.6063,0.13386,0.6063,0.14173,0.6063,0.14961,0.6063,0.15748,0.6063,0.16535,0.6063,0.17323,0.6063,0.1811,0.6063,0.18898,0.6063,0.19685,0.6063,0.20472,0.6063,0.2126,0.6063,0.22047,0.6063,0.22835,0.6063,0.23622,0.6063,0.24409,0.6063,0.25197,0.6063,0.25984,0.6063,0.26772,0.6063,0.27559,0.6063,0.28346,0.6063,0.29134,0.6063,0.29921,0.6063,0.30709,0.6063,0.31496,0.6063,0.32283,0.6063,0.33071,0.6063,0.33858,0.6063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_100()
		{
			double[] value = {0.34646,0.6063,0.35433,0.6063,0.3622,0.6063,0.37008,0.6063,0.37795,0.6063,0.38583,0.6063,0.3937,0.6063,0.40157,0.6063,0.40945,0.6063,0.41732,0.6063,0.4252,0.6063,0.43307,0.6063,0.44094,0.6063,0.44882,0.6063,0.45669,0.6063,0.46457,0.6063,0.47244,0.6063,0.48031,0.6063,0.48819,0.6063,0.49606,0.6063,0.50394,0.6063,0.51181,0.6063,0.51969,0.6063,0.52756,0.6063,0.53543,0.6063,0.54331,0.6063,0.55118,0.6063,0.55906,0.6063,0.56693,0.6063,0.5748,0.6063,0.58268,0.6063,0.59055,0.6063,0.59843,0.6063,0.6063,0.6063,0.61417,0.6063,0.62205,0.6063,0.62992,0.6063,0.6378,0.6063,0.64567,0.6063,0.65354,0.6063,0.66142,0.6063,0.66929,0.6063,0.67717,0.6063,0.68504,0.6063,0.69291,0.6063,0.70079,0.6063,0.70866,0.6063,0.71654,0.6063,0.72441,0.6063,0.73228,0.6063,0.74016,0.6063,0.74803,0.6063,0.75591,0.6063,0.76378,0.6063,0.77165,0.6063,0.77953,0.6063,0.7874,0.6063,0.79528,0.6063,0.80315,0.6063,0.81102,0.6063,0.8189,0.6063,0.82677,0.6063,0.83465,0.6063,0.84252,0.6063,0.85039,0.6063,0.85827,0.6063,0.86614,0.6063,0.87402,0.6063,0.88189,0.6063,0.88976,0.6063,0.89764,0.6063,0.90551,0.6063,0.91339,0.6063,0.92126,0.6063,0.92913,0.6063,0.93701,0.6063,0.94488,0.6063,0.95276,0.6063,0.96063,0.6063,0.9685,0.6063,0.97638,0.6063,0.98425,0.6063,0.99213,0.6063,0.99609,0.6063,0.00391,0.61417,0.00787,0.61417,0.01575,0.61417,0.02362,0.61417,0.0315,0.61417,0.03937,0.61417,0.04724,0.61417,0.05512,0.61417,0.06299,0.61417,0.07087,0.61417,0.07874,0.61417,0.08661,0.61417,0.09449,0.61417,0.10236,0.61417,0.11024,0.61417,0.11811,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_101()
		{
			double[] value = {0.12598,0.61417,0.13386,0.61417,0.14173,0.61417,0.14961,0.61417,0.15748,0.61417,0.16535,0.61417,0.17323,0.61417,0.1811,0.61417,0.18898,0.61417,0.19685,0.61417,0.20472,0.61417,0.2126,0.61417,0.22047,0.61417,0.22835,0.61417,0.23622,0.61417,0.24409,0.61417,0.25197,0.61417,0.25984,0.61417,0.26772,0.61417,0.27559,0.61417,0.28346,0.61417,0.29134,0.61417,0.29921,0.61417,0.30709,0.61417,0.31496,0.61417,0.32283,0.61417,0.33071,0.61417,0.33858,0.61417,0.34646,0.61417,0.35433,0.61417,0.3622,0.61417,0.37008,0.61417,0.37795,0.61417,0.38583,0.61417,0.3937,0.61417,0.40157,0.61417,0.40945,0.61417,0.41732,0.61417,0.4252,0.61417,0.43307,0.61417,0.44094,0.61417,0.44882,0.61417,0.45669,0.61417,0.46457,0.61417,0.47244,0.61417,0.48031,0.61417,0.48819,0.61417,0.49606,0.61417,0.50394,0.61417,0.51181,0.61417,0.51969,0.61417,0.52756,0.61417,0.53543,0.61417,0.54331,0.61417,0.55118,0.61417,0.55906,0.61417,0.56693,0.61417,0.5748,0.61417,0.58268,0.61417,0.59055,0.61417,0.59843,0.61417,0.6063,0.61417,0.61417,0.61417,0.62205,0.61417,0.62992,0.61417,0.6378,0.61417,0.64567,0.61417,0.65354,0.61417,0.66142,0.61417,0.66929,0.61417,0.67717,0.61417,0.68504,0.61417,0.69291,0.61417,0.70079,0.61417,0.70866,0.61417,0.71654,0.61417,0.72441,0.61417,0.73228,0.61417,0.74016,0.61417,0.74803,0.61417,0.75591,0.61417,0.76378,0.61417,0.77165,0.61417,0.77953,0.61417,0.7874,0.61417,0.79528,0.61417,0.80315,0.61417,0.81102,0.61417,0.8189,0.61417,0.82677,0.61417,0.83465,0.61417,0.84252,0.61417,0.85039,0.61417,0.85827,0.61417,0.86614,0.61417,0.87402,0.61417,0.88189,0.61417,0.88976,0.61417,0.89764,0.61417,0.90551,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_102()
		{
			double[] value = {0.91339,0.61417,0.92126,0.61417,0.92913,0.61417,0.93701,0.61417,0.94488,0.61417,0.95276,0.61417,0.96063,0.61417,0.9685,0.61417,0.97638,0.61417,0.98425,0.61417,0.99213,0.61417,0.99609,0.61417,0.00391,0.62205,0.00787,0.62205,0.01575,0.62205,0.02362,0.62205,0.0315,0.62205,0.03937,0.62205,0.04724,0.62205,0.05512,0.62205,0.06299,0.62205,0.07087,0.62205,0.07874,0.62205,0.08661,0.62205,0.09449,0.62205,0.10236,0.62205,0.11024,0.62205,0.11811,0.62205,0.12598,0.62205,0.13386,0.62205,0.14173,0.62205,0.14961,0.62205,0.15748,0.62205,0.16535,0.62205,0.17323,0.62205,0.1811,0.62205,0.18898,0.62205,0.19685,0.62205,0.20472,0.62205,0.2126,0.62205,0.22047,0.62205,0.22835,0.62205,0.23622,0.62205,0.24409,0.62205,0.25197,0.62205,0.25984,0.62205,0.26772,0.62205,0.27559,0.62205,0.28346,0.62205,0.29134,0.62205,0.29921,0.62205,0.30709,0.62205,0.31496,0.62205,0.32283,0.62205,0.33071,0.62205,0.33858,0.62205,0.34646,0.62205,0.35433,0.62205,0.3622,0.62205,0.37008,0.62205,0.37795,0.62205,0.38583,0.62205,0.3937,0.62205,0.40157,0.62205,0.40945,0.62205,0.41732,0.62205,0.4252,0.62205,0.43307,0.62205,0.44094,0.62205,0.44882,0.62205,0.45669,0.62205,0.46457,0.62205,0.47244,0.62205,0.48031,0.62205,0.48819,0.62205,0.49606,0.62205,0.50394,0.62205,0.51181,0.62205,0.51969,0.62205,0.52756,0.62205,0.53543,0.62205,0.54331,0.62205,0.55118,0.62205,0.55906,0.62205,0.56693,0.62205,0.5748,0.62205,0.58268,0.62205,0.59055,0.62205,0.59843,0.62205,0.6063,0.62205,0.61417,0.62205,0.62205,0.62205,0.62992,0.62205,0.6378,0.62205,0.64567,0.62205,0.65354,0.62205,0.66142,0.62205,0.66929,0.62205,0.67717,0.62205,0.68504,0.62205};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_103()
		{
			double[] value = {0.69291,0.62205,0.70079,0.62205,0.70866,0.62205,0.71654,0.62205,0.72441,0.62205,0.73228,0.62205,0.74016,0.62205,0.74803,0.62205,0.75591,0.62205,0.76378,0.62205,0.77165,0.62205,0.77953,0.62205,0.7874,0.62205,0.79528,0.62205,0.80315,0.62205,0.81102,0.62205,0.8189,0.62205,0.82677,0.62205,0.83465,0.62205,0.84252,0.62205,0.85039,0.62205,0.85827,0.62205,0.86614,0.62205,0.87402,0.62205,0.88189,0.62205,0.88976,0.62205,0.89764,0.62205,0.90551,0.62205,0.91339,0.62205,0.92126,0.62205,0.92913,0.62205,0.93701,0.62205,0.94488,0.62205,0.95276,0.62205,0.96063,0.62205,0.9685,0.62205,0.97638,0.62205,0.98425,0.62205,0.99213,0.62205,0.99609,0.62205,0.00391,0.62992,0.00787,0.62992,0.01575,0.62992,0.02362,0.62992,0.0315,0.62992,0.03937,0.62992,0.04724,0.62992,0.05512,0.62992,0.06299,0.62992,0.07087,0.62992,0.07874,0.62992,0.08661,0.62992,0.09449,0.62992,0.10236,0.62992,0.11024,0.62992,0.11811,0.62992,0.12598,0.62992,0.13386,0.62992,0.14173,0.62992,0.14961,0.62992,0.15748,0.62992,0.16535,0.62992,0.17323,0.62992,0.1811,0.62992,0.18898,0.62992,0.19685,0.62992,0.20472,0.62992,0.2126,0.62992,0.22047,0.62992,0.22835,0.62992,0.23622,0.62992,0.24409,0.62992,0.25197,0.62992,0.25984,0.62992,0.26772,0.62992,0.27559,0.62992,0.28346,0.62992,0.29134,0.62992,0.29921,0.62992,0.30709,0.62992,0.31496,0.62992,0.32283,0.62992,0.33071,0.62992,0.33858,0.62992,0.34646,0.62992,0.35433,0.62992,0.3622,0.62992,0.37008,0.62992,0.37795,0.62992,0.38583,0.62992,0.3937,0.62992,0.40157,0.62992,0.40945,0.62992,0.41732,0.62992,0.4252,0.62992,0.43307,0.62992,0.44094,0.62992,0.44882,0.62992,0.45669,0.62992,0.46457,0.62992};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_104()
		{
			double[] value = {0.47244,0.62992,0.48031,0.62992,0.48819,0.62992,0.49606,0.62992,0.50394,0.62992,0.51181,0.62992,0.51969,0.62992,0.52756,0.62992,0.53543,0.62992,0.54331,0.62992,0.55118,0.62992,0.55906,0.62992,0.56693,0.62992,0.5748,0.62992,0.58268,0.62992,0.59055,0.62992,0.59843,0.62992,0.6063,0.62992,0.61417,0.62992,0.62205,0.62992,0.62992,0.62992,0.6378,0.62992,0.64567,0.62992,0.65354,0.62992,0.66142,0.62992,0.66929,0.62992,0.67717,0.62992,0.68504,0.62992,0.69291,0.62992,0.70079,0.62992,0.70866,0.62992,0.71654,0.62992,0.72441,0.62992,0.73228,0.62992,0.74016,0.62992,0.74803,0.62992,0.75591,0.62992,0.76378,0.62992,0.77165,0.62992,0.77953,0.62992,0.7874,0.62992,0.79528,0.62992,0.80315,0.62992,0.81102,0.62992,0.8189,0.62992,0.82677,0.62992,0.83465,0.62992,0.84252,0.62992,0.85039,0.62992,0.85827,0.62992,0.86614,0.62992,0.87402,0.62992,0.88189,0.62992,0.88976,0.62992,0.89764,0.62992,0.90551,0.62992,0.91339,0.62992,0.92126,0.62992,0.92913,0.62992,0.93701,0.62992,0.94488,0.62992,0.95276,0.62992,0.96063,0.62992,0.9685,0.62992,0.97638,0.62992,0.98425,0.62992,0.99213,0.62992,0.99609,0.62992,0.00391,0.6378,0.00787,0.6378,0.01575,0.6378,0.02362,0.6378,0.0315,0.6378,0.03937,0.6378,0.04724,0.6378,0.05512,0.6378,0.06299,0.6378,0.07087,0.6378,0.07874,0.6378,0.08661,0.6378,0.09449,0.6378,0.10236,0.6378,0.11024,0.6378,0.11811,0.6378,0.12598,0.6378,0.13386,0.6378,0.14173,0.6378,0.14961,0.6378,0.15748,0.6378,0.16535,0.6378,0.17323,0.6378,0.1811,0.6378,0.18898,0.6378,0.19685,0.6378,0.20472,0.6378,0.2126,0.6378,0.22047,0.6378,0.22835,0.6378,0.23622,0.6378,0.24409,0.6378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_105()
		{
			double[] value = {0.25197,0.6378,0.25984,0.6378,0.26772,0.6378,0.27559,0.6378,0.28346,0.6378,0.29134,0.6378,0.29921,0.6378,0.30709,0.6378,0.31496,0.6378,0.32283,0.6378,0.33071,0.6378,0.33858,0.6378,0.34646,0.6378,0.35433,0.6378,0.3622,0.6378,0.37008,0.6378,0.37795,0.6378,0.38583,0.6378,0.3937,0.6378,0.40157,0.6378,0.40945,0.6378,0.41732,0.6378,0.4252,0.6378,0.43307,0.6378,0.44094,0.6378,0.44882,0.6378,0.45669,0.6378,0.46457,0.6378,0.47244,0.6378,0.48031,0.6378,0.48819,0.6378,0.49606,0.6378,0.50394,0.6378,0.51181,0.6378,0.51969,0.6378,0.52756,0.6378,0.53543,0.6378,0.54331,0.6378,0.55118,0.6378,0.55906,0.6378,0.56693,0.6378,0.5748,0.6378,0.58268,0.6378,0.59055,0.6378,0.59843,0.6378,0.6063,0.6378,0.61417,0.6378,0.62205,0.6378,0.62992,0.6378,0.6378,0.6378,0.64567,0.6378,0.65354,0.6378,0.66142,0.6378,0.66929,0.6378,0.67717,0.6378,0.68504,0.6378,0.69291,0.6378,0.70079,0.6378,0.70866,0.6378,0.71654,0.6378,0.72441,0.6378,0.73228,0.6378,0.74016,0.6378,0.74803,0.6378,0.75591,0.6378,0.76378,0.6378,0.77165,0.6378,0.77953,0.6378,0.7874,0.6378,0.79528,0.6378,0.80315,0.6378,0.81102,0.6378,0.8189,0.6378,0.82677,0.6378,0.83465,0.6378,0.84252,0.6378,0.85039,0.6378,0.85827,0.6378,0.86614,0.6378,0.87402,0.6378,0.88189,0.6378,0.88976,0.6378,0.89764,0.6378,0.90551,0.6378,0.91339,0.6378,0.92126,0.6378,0.92913,0.6378,0.93701,0.6378,0.94488,0.6378,0.95276,0.6378,0.96063,0.6378,0.9685,0.6378,0.97638,0.6378,0.98425,0.6378,0.99213,0.6378,0.99609,0.6378,0.00391,0.64567,0.00787,0.64567,0.01575,0.64567,0.02362,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_106()
		{
			double[] value = {0.0315,0.64567,0.03937,0.64567,0.04724,0.64567,0.05512,0.64567,0.06299,0.64567,0.07087,0.64567,0.07874,0.64567,0.08661,0.64567,0.09449,0.64567,0.10236,0.64567,0.11024,0.64567,0.11811,0.64567,0.12598,0.64567,0.13386,0.64567,0.14173,0.64567,0.14961,0.64567,0.15748,0.64567,0.16535,0.64567,0.17323,0.64567,0.1811,0.64567,0.18898,0.64567,0.19685,0.64567,0.20472,0.64567,0.2126,0.64567,0.22047,0.64567,0.22835,0.64567,0.23622,0.64567,0.24409,0.64567,0.25197,0.64567,0.25984,0.64567,0.26772,0.64567,0.27559,0.64567,0.28346,0.64567,0.29134,0.64567,0.29921,0.64567,0.30709,0.64567,0.31496,0.64567,0.32283,0.64567,0.33071,0.64567,0.33858,0.64567,0.34646,0.64567,0.35433,0.64567,0.3622,0.64567,0.37008,0.64567,0.37795,0.64567,0.38583,0.64567,0.3937,0.64567,0.40157,0.64567,0.40945,0.64567,0.41732,0.64567,0.4252,0.64567,0.43307,0.64567,0.44094,0.64567,0.44882,0.64567,0.45669,0.64567,0.46457,0.64567,0.47244,0.64567,0.48031,0.64567,0.48819,0.64567,0.49606,0.64567,0.50394,0.64567,0.51181,0.64567,0.51969,0.64567,0.52756,0.64567,0.53543,0.64567,0.54331,0.64567,0.55118,0.64567,0.55906,0.64567,0.56693,0.64567,0.5748,0.64567,0.58268,0.64567,0.59055,0.64567,0.59843,0.64567,0.6063,0.64567,0.61417,0.64567,0.62205,0.64567,0.62992,0.64567,0.6378,0.64567,0.64567,0.64567,0.65354,0.64567,0.66142,0.64567,0.66929,0.64567,0.67717,0.64567,0.68504,0.64567,0.69291,0.64567,0.70079,0.64567,0.70866,0.64567,0.71654,0.64567,0.72441,0.64567,0.73228,0.64567,0.74016,0.64567,0.74803,0.64567,0.75591,0.64567,0.76378,0.64567,0.77165,0.64567,0.77953,0.64567,0.7874,0.64567,0.79528,0.64567,0.80315,0.64567,0.81102,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_107()
		{
			double[] value = {0.8189,0.64567,0.82677,0.64567,0.83465,0.64567,0.84252,0.64567,0.85039,0.64567,0.85827,0.64567,0.86614,0.64567,0.87402,0.64567,0.88189,0.64567,0.88976,0.64567,0.89764,0.64567,0.90551,0.64567,0.91339,0.64567,0.92126,0.64567,0.92913,0.64567,0.93701,0.64567,0.94488,0.64567,0.95276,0.64567,0.96063,0.64567,0.9685,0.64567,0.97638,0.64567,0.98425,0.64567,0.99213,0.64567,0.99609,0.64567,0.00391,0.65354,0.00787,0.65354,0.01575,0.65354,0.02362,0.65354,0.0315,0.65354,0.03937,0.65354,0.04724,0.65354,0.05512,0.65354,0.06299,0.65354,0.07087,0.65354,0.07874,0.65354,0.08661,0.65354,0.09449,0.65354,0.10236,0.65354,0.11024,0.65354,0.11811,0.65354,0.12598,0.65354,0.13386,0.65354,0.14173,0.65354,0.14961,0.65354,0.15748,0.65354,0.16535,0.65354,0.17323,0.65354,0.1811,0.65354,0.18898,0.65354,0.19685,0.65354,0.20472,0.65354,0.2126,0.65354,0.22047,0.65354,0.22835,0.65354,0.23622,0.65354,0.24409,0.65354,0.25197,0.65354,0.25984,0.65354,0.26772,0.65354,0.27559,0.65354,0.28346,0.65354,0.29134,0.65354,0.29921,0.65354,0.30709,0.65354,0.31496,0.65354,0.32283,0.65354,0.33071,0.65354,0.33858,0.65354,0.34646,0.65354,0.35433,0.65354,0.3622,0.65354,0.37008,0.65354,0.37795,0.65354,0.38583,0.65354,0.3937,0.65354,0.40157,0.65354,0.40945,0.65354,0.41732,0.65354,0.4252,0.65354,0.43307,0.65354,0.44094,0.65354,0.44882,0.65354,0.45669,0.65354,0.46457,0.65354,0.47244,0.65354,0.48031,0.65354,0.48819,0.65354,0.49606,0.65354,0.50394,0.65354,0.51181,0.65354,0.51969,0.65354,0.52756,0.65354,0.53543,0.65354,0.54331,0.65354,0.55118,0.65354,0.55906,0.65354,0.56693,0.65354,0.5748,0.65354,0.58268,0.65354,0.59055,0.65354};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_108()
		{
			double[] value = {0.59843,0.65354,0.6063,0.65354,0.61417,0.65354,0.62205,0.65354,0.62992,0.65354,0.6378,0.65354,0.64567,0.65354,0.65354,0.65354,0.66142,0.65354,0.66929,0.65354,0.67717,0.65354,0.68504,0.65354,0.69291,0.65354,0.70079,0.65354,0.70866,0.65354,0.71654,0.65354,0.72441,0.65354,0.73228,0.65354,0.74016,0.65354,0.74803,0.65354,0.75591,0.65354,0.76378,0.65354,0.77165,0.65354,0.77953,0.65354,0.7874,0.65354,0.79528,0.65354,0.80315,0.65354,0.81102,0.65354,0.8189,0.65354,0.82677,0.65354,0.83465,0.65354,0.84252,0.65354,0.85039,0.65354,0.85827,0.65354,0.86614,0.65354,0.87402,0.65354,0.88189,0.65354,0.88976,0.65354,0.89764,0.65354,0.90551,0.65354,0.91339,0.65354,0.92126,0.65354,0.92913,0.65354,0.93701,0.65354,0.94488,0.65354,0.95276,0.65354,0.96063,0.65354,0.9685,0.65354,0.97638,0.65354,0.98425,0.65354,0.99213,0.65354,0.99609,0.65354,0.00391,0.66142,0.00787,0.66142,0.01575,0.66142,0.02362,0.66142,0.0315,0.66142,0.03937,0.66142,0.04724,0.66142,0.05512,0.66142,0.06299,0.66142,0.07087,0.66142,0.07874,0.66142,0.08661,0.66142,0.09449,0.66142,0.10236,0.66142,0.11024,0.66142,0.11811,0.66142,0.12598,0.66142,0.13386,0.66142,0.14173,0.66142,0.14961,0.66142,0.15748,0.66142,0.16535,0.66142,0.17323,0.66142,0.1811,0.66142,0.18898,0.66142,0.19685,0.66142,0.20472,0.66142,0.2126,0.66142,0.22047,0.66142,0.22835,0.66142,0.23622,0.66142,0.24409,0.66142,0.25197,0.66142,0.25984,0.66142,0.26772,0.66142,0.27559,0.66142,0.28346,0.66142,0.29134,0.66142,0.29921,0.66142,0.30709,0.66142,0.31496,0.66142,0.32283,0.66142,0.33071,0.66142,0.33858,0.66142,0.34646,0.66142,0.35433,0.66142,0.3622,0.66142,0.37008,0.66142};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_109()
		{
			double[] value = {0.37795,0.66142,0.38583,0.66142,0.3937,0.66142,0.40157,0.66142,0.40945,0.66142,0.41732,0.66142,0.4252,0.66142,0.43307,0.66142,0.44094,0.66142,0.44882,0.66142,0.45669,0.66142,0.46457,0.66142,0.47244,0.66142,0.48031,0.66142,0.48819,0.66142,0.49606,0.66142,0.50394,0.66142,0.51181,0.66142,0.51969,0.66142,0.52756,0.66142,0.53543,0.66142,0.54331,0.66142,0.55118,0.66142,0.55906,0.66142,0.56693,0.66142,0.5748,0.66142,0.58268,0.66142,0.59055,0.66142,0.59843,0.66142,0.6063,0.66142,0.61417,0.66142,0.62205,0.66142,0.62992,0.66142,0.6378,0.66142,0.64567,0.66142,0.65354,0.66142,0.66142,0.66142,0.66929,0.66142,0.67717,0.66142,0.68504,0.66142,0.69291,0.66142,0.70079,0.66142,0.70866,0.66142,0.71654,0.66142,0.72441,0.66142,0.73228,0.66142,0.74016,0.66142,0.74803,0.66142,0.75591,0.66142,0.76378,0.66142,0.77165,0.66142,0.77953,0.66142,0.7874,0.66142,0.79528,0.66142,0.80315,0.66142,0.81102,0.66142,0.8189,0.66142,0.82677,0.66142,0.83465,0.66142,0.84252,0.66142,0.85039,0.66142,0.85827,0.66142,0.86614,0.66142,0.87402,0.66142,0.88189,0.66142,0.88976,0.66142,0.89764,0.66142,0.90551,0.66142,0.91339,0.66142,0.92126,0.66142,0.92913,0.66142,0.93701,0.66142,0.94488,0.66142,0.95276,0.66142,0.96063,0.66142,0.9685,0.66142,0.97638,0.66142,0.98425,0.66142,0.99213,0.66142,0.99609,0.66142,0.00391,0.66929,0.00787,0.66929,0.01575,0.66929,0.02362,0.66929,0.0315,0.66929,0.03937,0.66929,0.04724,0.66929,0.05512,0.66929,0.06299,0.66929,0.07087,0.66929,0.07874,0.66929,0.08661,0.66929,0.09449,0.66929,0.10236,0.66929,0.11024,0.66929,0.11811,0.66929,0.12598,0.66929,0.13386,0.66929,0.14173,0.66929,0.14961,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_110()
		{
			double[] value = {0.15748,0.66929,0.16535,0.66929,0.17323,0.66929,0.1811,0.66929,0.18898,0.66929,0.19685,0.66929,0.20472,0.66929,0.2126,0.66929,0.22047,0.66929,0.22835,0.66929,0.23622,0.66929,0.24409,0.66929,0.25197,0.66929,0.25984,0.66929,0.26772,0.66929,0.27559,0.66929,0.28346,0.66929,0.29134,0.66929,0.29921,0.66929,0.30709,0.66929,0.31496,0.66929,0.32283,0.66929,0.33071,0.66929,0.33858,0.66929,0.34646,0.66929,0.35433,0.66929,0.3622,0.66929,0.37008,0.66929,0.37795,0.66929,0.38583,0.66929,0.3937,0.66929,0.40157,0.66929,0.40945,0.66929,0.41732,0.66929,0.4252,0.66929,0.43307,0.66929,0.44094,0.66929,0.44882,0.66929,0.45669,0.66929,0.46457,0.66929,0.47244,0.66929,0.48031,0.66929,0.48819,0.66929,0.49606,0.66929,0.50394,0.66929,0.51181,0.66929,0.51969,0.66929,0.52756,0.66929,0.53543,0.66929,0.54331,0.66929,0.55118,0.66929,0.55906,0.66929,0.56693,0.66929,0.5748,0.66929,0.58268,0.66929,0.59055,0.66929,0.59843,0.66929,0.6063,0.66929,0.61417,0.66929,0.62205,0.66929,0.62992,0.66929,0.6378,0.66929,0.64567,0.66929,0.65354,0.66929,0.66142,0.66929,0.66929,0.66929,0.67717,0.66929,0.68504,0.66929,0.69291,0.66929,0.70079,0.66929,0.70866,0.66929,0.71654,0.66929,0.72441,0.66929,0.73228,0.66929,0.74016,0.66929,0.74803,0.66929,0.75591,0.66929,0.76378,0.66929,0.77165,0.66929,0.77953,0.66929,0.7874,0.66929,0.79528,0.66929,0.80315,0.66929,0.81102,0.66929,0.8189,0.66929,0.82677,0.66929,0.83465,0.66929,0.84252,0.66929,0.85039,0.66929,0.85827,0.66929,0.86614,0.66929,0.87402,0.66929,0.88189,0.66929,0.88976,0.66929,0.89764,0.66929,0.90551,0.66929,0.91339,0.66929,0.92126,0.66929,0.92913,0.66929,0.93701,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_111()
		{
			double[] value = {0.94488,0.66929,0.95276,0.66929,0.96063,0.66929,0.9685,0.66929,0.97638,0.66929,0.98425,0.66929,0.99213,0.66929,0.99609,0.66929,0.00391,0.67717,0.00787,0.67717,0.01575,0.67717,0.02362,0.67717,0.0315,0.67717,0.03937,0.67717,0.04724,0.67717,0.05512,0.67717,0.06299,0.67717,0.07087,0.67717,0.07874,0.67717,0.08661,0.67717,0.09449,0.67717,0.10236,0.67717,0.11024,0.67717,0.11811,0.67717,0.12598,0.67717,0.13386,0.67717,0.14173,0.67717,0.14961,0.67717,0.15748,0.67717,0.16535,0.67717,0.17323,0.67717,0.1811,0.67717,0.18898,0.67717,0.19685,0.67717,0.20472,0.67717,0.2126,0.67717,0.22047,0.67717,0.22835,0.67717,0.23622,0.67717,0.24409,0.67717,0.25197,0.67717,0.25984,0.67717,0.26772,0.67717,0.27559,0.67717,0.28346,0.67717,0.29134,0.67717,0.29921,0.67717,0.30709,0.67717,0.31496,0.67717,0.32283,0.67717,0.33071,0.67717,0.33858,0.67717,0.34646,0.67717,0.35433,0.67717,0.3622,0.67717,0.37008,0.67717,0.37795,0.67717,0.38583,0.67717,0.3937,0.67717,0.40157,0.67717,0.40945,0.67717,0.41732,0.67717,0.4252,0.67717,0.43307,0.67717,0.44094,0.67717,0.44882,0.67717,0.45669,0.67717,0.46457,0.67717,0.47244,0.67717,0.48031,0.67717,0.48819,0.67717,0.49606,0.67717,0.50394,0.67717,0.51181,0.67717,0.51969,0.67717,0.52756,0.67717,0.53543,0.67717,0.54331,0.67717,0.55118,0.67717,0.55906,0.67717,0.56693,0.67717,0.5748,0.67717,0.58268,0.67717,0.59055,0.67717,0.59843,0.67717,0.6063,0.67717,0.61417,0.67717,0.62205,0.67717,0.62992,0.67717,0.6378,0.67717,0.64567,0.67717,0.65354,0.67717,0.66142,0.67717,0.66929,0.67717,0.67717,0.67717,0.68504,0.67717,0.69291,0.67717,0.70079,0.67717,0.70866,0.67717,0.71654,0.67717};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_112()
		{
			double[] value = {0.72441,0.67717,0.73228,0.67717,0.74016,0.67717,0.74803,0.67717,0.75591,0.67717,0.76378,0.67717,0.77165,0.67717,0.77953,0.67717,0.7874,0.67717,0.79528,0.67717,0.80315,0.67717,0.81102,0.67717,0.8189,0.67717,0.82677,0.67717,0.83465,0.67717,0.84252,0.67717,0.85039,0.67717,0.85827,0.67717,0.86614,0.67717,0.87402,0.67717,0.88189,0.67717,0.88976,0.67717,0.89764,0.67717,0.90551,0.67717,0.91339,0.67717,0.92126,0.67717,0.92913,0.67717,0.93701,0.67717,0.94488,0.67717,0.95276,0.67717,0.96063,0.67717,0.9685,0.67717,0.97638,0.67717,0.98425,0.67717,0.99213,0.67717,0.99609,0.67717,0.00391,0.68504,0.00787,0.68504,0.01575,0.68504,0.02362,0.68504,0.0315,0.68504,0.03937,0.68504,0.04724,0.68504,0.05512,0.68504,0.06299,0.68504,0.07087,0.68504,0.07874,0.68504,0.08661,0.68504,0.09449,0.68504,0.10236,0.68504,0.11024,0.68504,0.11811,0.68504,0.12598,0.68504,0.13386,0.68504,0.14173,0.68504,0.14961,0.68504,0.15748,0.68504,0.16535,0.68504,0.17323,0.68504,0.1811,0.68504,0.18898,0.68504,0.19685,0.68504,0.20472,0.68504,0.2126,0.68504,0.22047,0.68504,0.22835,0.68504,0.23622,0.68504,0.24409,0.68504,0.25197,0.68504,0.25984,0.68504,0.26772,0.68504,0.27559,0.68504,0.28346,0.68504,0.29134,0.68504,0.29921,0.68504,0.30709,0.68504,0.31496,0.68504,0.32283,0.68504,0.33071,0.68504,0.33858,0.68504,0.34646,0.68504,0.35433,0.68504,0.3622,0.68504,0.37008,0.68504,0.37795,0.68504,0.38583,0.68504,0.3937,0.68504,0.40157,0.68504,0.40945,0.68504,0.41732,0.68504,0.4252,0.68504,0.43307,0.68504,0.44094,0.68504,0.44882,0.68504,0.45669,0.68504,0.46457,0.68504,0.47244,0.68504,0.48031,0.68504,0.48819,0.68504,0.49606,0.68504};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_113()
		{
			double[] value = {0.50394,0.68504,0.51181,0.68504,0.51969,0.68504,0.52756,0.68504,0.53543,0.68504,0.54331,0.68504,0.55118,0.68504,0.55906,0.68504,0.56693,0.68504,0.5748,0.68504,0.58268,0.68504,0.59055,0.68504,0.59843,0.68504,0.6063,0.68504,0.61417,0.68504,0.62205,0.68504,0.62992,0.68504,0.6378,0.68504,0.64567,0.68504,0.65354,0.68504,0.66142,0.68504,0.66929,0.68504,0.67717,0.68504,0.68504,0.68504,0.69291,0.68504,0.70079,0.68504,0.70866,0.68504,0.71654,0.68504,0.72441,0.68504,0.73228,0.68504,0.74016,0.68504,0.74803,0.68504,0.75591,0.68504,0.76378,0.68504,0.77165,0.68504,0.77953,0.68504,0.7874,0.68504,0.79528,0.68504,0.80315,0.68504,0.81102,0.68504,0.8189,0.68504,0.82677,0.68504,0.83465,0.68504,0.84252,0.68504,0.85039,0.68504,0.85827,0.68504,0.86614,0.68504,0.87402,0.68504,0.88189,0.68504,0.88976,0.68504,0.89764,0.68504,0.90551,0.68504,0.91339,0.68504,0.92126,0.68504,0.92913,0.68504,0.93701,0.68504,0.94488,0.68504,0.95276,0.68504,0.96063,0.68504,0.9685,0.68504,0.97638,0.68504,0.98425,0.68504,0.99213,0.68504,0.99609,0.68504,0.00391,0.69291,0.00787,0.69291,0.01575,0.69291,0.02362,0.69291,0.0315,0.69291,0.03937,0.69291,0.04724,0.69291,0.05512,0.69291,0.06299,0.69291,0.07087,0.69291,0.07874,0.69291,0.08661,0.69291,0.09449,0.69291,0.10236,0.69291,0.11024,0.69291,0.11811,0.69291,0.12598,0.69291,0.13386,0.69291,0.14173,0.69291,0.14961,0.69291,0.15748,0.69291,0.16535,0.69291,0.17323,0.69291,0.1811,0.69291,0.18898,0.69291,0.19685,0.69291,0.20472,0.69291,0.2126,0.69291,0.22047,0.69291,0.22835,0.69291,0.23622,0.69291,0.24409,0.69291,0.25197,0.69291,0.25984,0.69291,0.26772,0.69291,0.27559,0.69291};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_114()
		{
			double[] value = {0.28346,0.69291,0.29134,0.69291,0.29921,0.69291,0.30709,0.69291,0.31496,0.69291,0.32283,0.69291,0.33071,0.69291,0.33858,0.69291,0.34646,0.69291,0.35433,0.69291,0.3622,0.69291,0.37008,0.69291,0.37795,0.69291,0.38583,0.69291,0.3937,0.69291,0.40157,0.69291,0.40945,0.69291,0.41732,0.69291,0.4252,0.69291,0.43307,0.69291,0.44094,0.69291,0.44882,0.69291,0.45669,0.69291,0.46457,0.69291,0.47244,0.69291,0.48031,0.69291,0.48819,0.69291,0.49606,0.69291,0.50394,0.69291,0.51181,0.69291,0.51969,0.69291,0.52756,0.69291,0.53543,0.69291,0.54331,0.69291,0.55118,0.69291,0.55906,0.69291,0.56693,0.69291,0.5748,0.69291,0.58268,0.69291,0.59055,0.69291,0.59843,0.69291,0.6063,0.69291,0.61417,0.69291,0.62205,0.69291,0.62992,0.69291,0.6378,0.69291,0.64567,0.69291,0.65354,0.69291,0.66142,0.69291,0.66929,0.69291,0.67717,0.69291,0.68504,0.69291,0.69291,0.69291,0.70079,0.69291,0.70866,0.69291,0.71654,0.69291,0.72441,0.69291,0.73228,0.69291,0.74016,0.69291,0.74803,0.69291,0.75591,0.69291,0.76378,0.69291,0.77165,0.69291,0.77953,0.69291,0.7874,0.69291,0.79528,0.69291,0.80315,0.69291,0.81102,0.69291,0.8189,0.69291,0.82677,0.69291,0.83465,0.69291,0.84252,0.69291,0.85039,0.69291,0.85827,0.69291,0.86614,0.69291,0.87402,0.69291,0.88189,0.69291,0.88976,0.69291,0.89764,0.69291,0.90551,0.69291,0.91339,0.69291,0.92126,0.69291,0.92913,0.69291,0.93701,0.69291,0.94488,0.69291,0.95276,0.69291,0.96063,0.69291,0.9685,0.69291,0.97638,0.69291,0.98425,0.69291,0.99213,0.69291,0.99609,0.69291,0.00391,0.70079,0.00787,0.70079,0.01575,0.70079,0.02362,0.70079,0.0315,0.70079,0.03937,0.70079,0.04724,0.70079,0.05512,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_115()
		{
			double[] value = {0.06299,0.70079,0.07087,0.70079,0.07874,0.70079,0.08661,0.70079,0.09449,0.70079,0.10236,0.70079,0.11024,0.70079,0.11811,0.70079,0.12598,0.70079,0.13386,0.70079,0.14173,0.70079,0.14961,0.70079,0.15748,0.70079,0.16535,0.70079,0.17323,0.70079,0.1811,0.70079,0.18898,0.70079,0.19685,0.70079,0.20472,0.70079,0.2126,0.70079,0.22047,0.70079,0.22835,0.70079,0.23622,0.70079,0.24409,0.70079,0.25197,0.70079,0.25984,0.70079,0.26772,0.70079,0.27559,0.70079,0.28346,0.70079,0.29134,0.70079,0.29921,0.70079,0.30709,0.70079,0.31496,0.70079,0.32283,0.70079,0.33071,0.70079,0.33858,0.70079,0.34646,0.70079,0.35433,0.70079,0.3622,0.70079,0.37008,0.70079,0.37795,0.70079,0.38583,0.70079,0.3937,0.70079,0.40157,0.70079,0.40945,0.70079,0.41732,0.70079,0.4252,0.70079,0.43307,0.70079,0.44094,0.70079,0.44882,0.70079,0.45669,0.70079,0.46457,0.70079,0.47244,0.70079,0.48031,0.70079,0.48819,0.70079,0.49606,0.70079,0.50394,0.70079,0.51181,0.70079,0.51969,0.70079,0.52756,0.70079,0.53543,0.70079,0.54331,0.70079,0.55118,0.70079,0.55906,0.70079,0.56693,0.70079,0.5748,0.70079,0.58268,0.70079,0.59055,0.70079,0.59843,0.70079,0.6063,0.70079,0.61417,0.70079,0.62205,0.70079,0.62992,0.70079,0.6378,0.70079,0.64567,0.70079,0.65354,0.70079,0.66142,0.70079,0.66929,0.70079,0.67717,0.70079,0.68504,0.70079,0.69291,0.70079,0.70079,0.70079,0.70866,0.70079,0.71654,0.70079,0.72441,0.70079,0.73228,0.70079,0.74016,0.70079,0.74803,0.70079,0.75591,0.70079,0.76378,0.70079,0.77165,0.70079,0.77953,0.70079,0.7874,0.70079,0.79528,0.70079,0.80315,0.70079,0.81102,0.70079,0.8189,0.70079,0.82677,0.70079,0.83465,0.70079,0.84252,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_116()
		{
			double[] value = {0.85039,0.70079,0.85827,0.70079,0.86614,0.70079,0.87402,0.70079,0.88189,0.70079,0.88976,0.70079,0.89764,0.70079,0.90551,0.70079,0.91339,0.70079,0.92126,0.70079,0.92913,0.70079,0.93701,0.70079,0.94488,0.70079,0.95276,0.70079,0.96063,0.70079,0.9685,0.70079,0.97638,0.70079,0.98425,0.70079,0.99213,0.70079,0.99609,0.70079,0.00391,0.70866,0.00787,0.70866,0.01575,0.70866,0.02362,0.70866,0.0315,0.70866,0.03937,0.70866,0.04724,0.70866,0.05512,0.70866,0.06299,0.70866,0.07087,0.70866,0.07874,0.70866,0.08661,0.70866,0.09449,0.70866,0.10236,0.70866,0.11024,0.70866,0.11811,0.70866,0.12598,0.70866,0.13386,0.70866,0.14173,0.70866,0.14961,0.70866,0.15748,0.70866,0.16535,0.70866,0.17323,0.70866,0.1811,0.70866,0.18898,0.70866,0.19685,0.70866,0.20472,0.70866,0.2126,0.70866,0.22047,0.70866,0.22835,0.70866,0.23622,0.70866,0.24409,0.70866,0.25197,0.70866,0.25984,0.70866,0.26772,0.70866,0.27559,0.70866,0.28346,0.70866,0.29134,0.70866,0.29921,0.70866,0.30709,0.70866,0.31496,0.70866,0.32283,0.70866,0.33071,0.70866,0.33858,0.70866,0.34646,0.70866,0.35433,0.70866,0.3622,0.70866,0.37008,0.70866,0.37795,0.70866,0.38583,0.70866,0.3937,0.70866,0.40157,0.70866,0.40945,0.70866,0.41732,0.70866,0.4252,0.70866,0.43307,0.70866,0.44094,0.70866,0.44882,0.70866,0.45669,0.70866,0.46457,0.70866,0.47244,0.70866,0.48031,0.70866,0.48819,0.70866,0.49606,0.70866,0.50394,0.70866,0.51181,0.70866,0.51969,0.70866,0.52756,0.70866,0.53543,0.70866,0.54331,0.70866,0.55118,0.70866,0.55906,0.70866,0.56693,0.70866,0.5748,0.70866,0.58268,0.70866,0.59055,0.70866,0.59843,0.70866,0.6063,0.70866,0.61417,0.70866,0.62205,0.70866};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_117()
		{
			double[] value = {0.62992,0.70866,0.6378,0.70866,0.64567,0.70866,0.65354,0.70866,0.66142,0.70866,0.66929,0.70866,0.67717,0.70866,0.68504,0.70866,0.69291,0.70866,0.70079,0.70866,0.70866,0.70866,0.71654,0.70866,0.72441,0.70866,0.73228,0.70866,0.74016,0.70866,0.74803,0.70866,0.75591,0.70866,0.76378,0.70866,0.77165,0.70866,0.77953,0.70866,0.7874,0.70866,0.79528,0.70866,0.80315,0.70866,0.81102,0.70866,0.8189,0.70866,0.82677,0.70866,0.83465,0.70866,0.84252,0.70866,0.85039,0.70866,0.85827,0.70866,0.86614,0.70866,0.87402,0.70866,0.88189,0.70866,0.88976,0.70866,0.89764,0.70866,0.90551,0.70866,0.91339,0.70866,0.92126,0.70866,0.92913,0.70866,0.93701,0.70866,0.94488,0.70866,0.95276,0.70866,0.96063,0.70866,0.9685,0.70866,0.97638,0.70866,0.98425,0.70866,0.99213,0.70866,0.99609,0.70866,0.00391,0.71654,0.00787,0.71654,0.01575,0.71654,0.02362,0.71654,0.0315,0.71654,0.03937,0.71654,0.04724,0.71654,0.05512,0.71654,0.06299,0.71654,0.07087,0.71654,0.07874,0.71654,0.08661,0.71654,0.09449,0.71654,0.10236,0.71654,0.11024,0.71654,0.11811,0.71654,0.12598,0.71654,0.13386,0.71654,0.14173,0.71654,0.14961,0.71654,0.15748,0.71654,0.16535,0.71654,0.17323,0.71654,0.1811,0.71654,0.18898,0.71654,0.19685,0.71654,0.20472,0.71654,0.2126,0.71654,0.22047,0.71654,0.22835,0.71654,0.23622,0.71654,0.24409,0.71654,0.25197,0.71654,0.25984,0.71654,0.26772,0.71654,0.27559,0.71654,0.28346,0.71654,0.29134,0.71654,0.29921,0.71654,0.30709,0.71654,0.31496,0.71654,0.32283,0.71654,0.33071,0.71654,0.33858,0.71654,0.34646,0.71654,0.35433,0.71654,0.3622,0.71654,0.37008,0.71654,0.37795,0.71654,0.38583,0.71654,0.3937,0.71654,0.40157,0.71654};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_118()
		{
			double[] value = {0.40945,0.71654,0.41732,0.71654,0.4252,0.71654,0.43307,0.71654,0.44094,0.71654,0.44882,0.71654,0.45669,0.71654,0.46457,0.71654,0.47244,0.71654,0.48031,0.71654,0.48819,0.71654,0.49606,0.71654,0.50394,0.71654,0.51181,0.71654,0.51969,0.71654,0.52756,0.71654,0.53543,0.71654,0.54331,0.71654,0.55118,0.71654,0.55906,0.71654,0.56693,0.71654,0.5748,0.71654,0.58268,0.71654,0.59055,0.71654,0.59843,0.71654,0.6063,0.71654,0.61417,0.71654,0.62205,0.71654,0.62992,0.71654,0.6378,0.71654,0.64567,0.71654,0.65354,0.71654,0.66142,0.71654,0.66929,0.71654,0.67717,0.71654,0.68504,0.71654,0.69291,0.71654,0.70079,0.71654,0.70866,0.71654,0.71654,0.71654,0.72441,0.71654,0.73228,0.71654,0.74016,0.71654,0.74803,0.71654,0.75591,0.71654,0.76378,0.71654,0.77165,0.71654,0.77953,0.71654,0.7874,0.71654,0.79528,0.71654,0.80315,0.71654,0.81102,0.71654,0.8189,0.71654,0.82677,0.71654,0.83465,0.71654,0.84252,0.71654,0.85039,0.71654,0.85827,0.71654,0.86614,0.71654,0.87402,0.71654,0.88189,0.71654,0.88976,0.71654,0.89764,0.71654,0.90551,0.71654,0.91339,0.71654,0.92126,0.71654,0.92913,0.71654,0.93701,0.71654,0.94488,0.71654,0.95276,0.71654,0.96063,0.71654,0.9685,0.71654,0.97638,0.71654,0.98425,0.71654,0.99213,0.71654,0.99609,0.71654,0.00391,0.72441,0.00787,0.72441,0.01575,0.72441,0.02362,0.72441,0.0315,0.72441,0.03937,0.72441,0.04724,0.72441,0.05512,0.72441,0.06299,0.72441,0.07087,0.72441,0.07874,0.72441,0.08661,0.72441,0.09449,0.72441,0.10236,0.72441,0.11024,0.72441,0.11811,0.72441,0.12598,0.72441,0.13386,0.72441,0.14173,0.72441,0.14961,0.72441,0.15748,0.72441,0.16535,0.72441,0.17323,0.72441,0.1811,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_119()
		{
			double[] value = {0.18898,0.72441,0.19685,0.72441,0.20472,0.72441,0.2126,0.72441,0.22047,0.72441,0.22835,0.72441,0.23622,0.72441,0.24409,0.72441,0.25197,0.72441,0.25984,0.72441,0.26772,0.72441,0.27559,0.72441,0.28346,0.72441,0.29134,0.72441,0.29921,0.72441,0.30709,0.72441,0.31496,0.72441,0.32283,0.72441,0.33071,0.72441,0.33858,0.72441,0.34646,0.72441,0.35433,0.72441,0.3622,0.72441,0.37008,0.72441,0.37795,0.72441,0.38583,0.72441,0.3937,0.72441,0.40157,0.72441,0.40945,0.72441,0.41732,0.72441,0.4252,0.72441,0.43307,0.72441,0.44094,0.72441,0.44882,0.72441,0.45669,0.72441,0.46457,0.72441,0.47244,0.72441,0.48031,0.72441,0.48819,0.72441,0.49606,0.72441,0.50394,0.72441,0.51181,0.72441,0.51969,0.72441,0.52756,0.72441,0.53543,0.72441,0.54331,0.72441,0.55118,0.72441,0.55906,0.72441,0.56693,0.72441,0.5748,0.72441,0.58268,0.72441,0.59055,0.72441,0.59843,0.72441,0.6063,0.72441,0.61417,0.72441,0.62205,0.72441,0.62992,0.72441,0.6378,0.72441,0.64567,0.72441,0.65354,0.72441,0.66142,0.72441,0.66929,0.72441,0.67717,0.72441,0.68504,0.72441,0.69291,0.72441,0.70079,0.72441,0.70866,0.72441,0.71654,0.72441,0.72441,0.72441,0.73228,0.72441,0.74016,0.72441,0.74803,0.72441,0.75591,0.72441,0.76378,0.72441,0.77165,0.72441,0.77953,0.72441,0.7874,0.72441,0.79528,0.72441,0.80315,0.72441,0.81102,0.72441,0.8189,0.72441,0.82677,0.72441,0.83465,0.72441,0.84252,0.72441,0.85039,0.72441,0.85827,0.72441,0.86614,0.72441,0.87402,0.72441,0.88189,0.72441,0.88976,0.72441,0.89764,0.72441,0.90551,0.72441,0.91339,0.72441,0.92126,0.72441,0.92913,0.72441,0.93701,0.72441,0.94488,0.72441,0.95276,0.72441,0.96063,0.72441,0.9685,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_120()
		{
			double[] value = {0.97638,0.72441,0.98425,0.72441,0.99213,0.72441,0.99609,0.72441,0.00391,0.73228,0.00787,0.73228,0.01575,0.73228,0.02362,0.73228,0.0315,0.73228,0.03937,0.73228,0.04724,0.73228,0.05512,0.73228,0.06299,0.73228,0.07087,0.73228,0.07874,0.73228,0.08661,0.73228,0.09449,0.73228,0.10236,0.73228,0.11024,0.73228,0.11811,0.73228,0.12598,0.73228,0.13386,0.73228,0.14173,0.73228,0.14961,0.73228,0.15748,0.73228,0.16535,0.73228,0.17323,0.73228,0.1811,0.73228,0.18898,0.73228,0.19685,0.73228,0.20472,0.73228,0.2126,0.73228,0.22047,0.73228,0.22835,0.73228,0.23622,0.73228,0.24409,0.73228,0.25197,0.73228,0.25984,0.73228,0.26772,0.73228,0.27559,0.73228,0.28346,0.73228,0.29134,0.73228,0.29921,0.73228,0.30709,0.73228,0.31496,0.73228,0.32283,0.73228,0.33071,0.73228,0.33858,0.73228,0.34646,0.73228,0.35433,0.73228,0.3622,0.73228,0.37008,0.73228,0.37795,0.73228,0.38583,0.73228,0.3937,0.73228,0.40157,0.73228,0.40945,0.73228,0.41732,0.73228,0.4252,0.73228,0.43307,0.73228,0.44094,0.73228,0.44882,0.73228,0.45669,0.73228,0.46457,0.73228,0.47244,0.73228,0.48031,0.73228,0.48819,0.73228,0.49606,0.73228,0.50394,0.73228,0.51181,0.73228,0.51969,0.73228,0.52756,0.73228,0.53543,0.73228,0.54331,0.73228,0.55118,0.73228,0.55906,0.73228,0.56693,0.73228,0.5748,0.73228,0.58268,0.73228,0.59055,0.73228,0.59843,0.73228,0.6063,0.73228,0.61417,0.73228,0.62205,0.73228,0.62992,0.73228,0.6378,0.73228,0.64567,0.73228,0.65354,0.73228,0.66142,0.73228,0.66929,0.73228,0.67717,0.73228,0.68504,0.73228,0.69291,0.73228,0.70079,0.73228,0.70866,0.73228,0.71654,0.73228,0.72441,0.73228,0.73228,0.73228,0.74016,0.73228,0.74803,0.73228};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_121()
		{
			double[] value = {0.75591,0.73228,0.76378,0.73228,0.77165,0.73228,0.77953,0.73228,0.7874,0.73228,0.79528,0.73228,0.80315,0.73228,0.81102,0.73228,0.8189,0.73228,0.82677,0.73228,0.83465,0.73228,0.84252,0.73228,0.85039,0.73228,0.85827,0.73228,0.86614,0.73228,0.87402,0.73228,0.88189,0.73228,0.88976,0.73228,0.89764,0.73228,0.90551,0.73228,0.91339,0.73228,0.92126,0.73228,0.92913,0.73228,0.93701,0.73228,0.94488,0.73228,0.95276,0.73228,0.96063,0.73228,0.9685,0.73228,0.97638,0.73228,0.98425,0.73228,0.99213,0.73228,0.99609,0.73228,0.00391,0.74016,0.00787,0.74016,0.01575,0.74016,0.02362,0.74016,0.0315,0.74016,0.03937,0.74016,0.04724,0.74016,0.05512,0.74016,0.06299,0.74016,0.07087,0.74016,0.07874,0.74016,0.08661,0.74016,0.09449,0.74016,0.10236,0.74016,0.11024,0.74016,0.11811,0.74016,0.12598,0.74016,0.13386,0.74016,0.14173,0.74016,0.14961,0.74016,0.15748,0.74016,0.16535,0.74016,0.17323,0.74016,0.1811,0.74016,0.18898,0.74016,0.19685,0.74016,0.20472,0.74016,0.2126,0.74016,0.22047,0.74016,0.22835,0.74016,0.23622,0.74016,0.24409,0.74016,0.25197,0.74016,0.25984,0.74016,0.26772,0.74016,0.27559,0.74016,0.28346,0.74016,0.29134,0.74016,0.29921,0.74016,0.30709,0.74016,0.31496,0.74016,0.32283,0.74016,0.33071,0.74016,0.33858,0.74016,0.34646,0.74016,0.35433,0.74016,0.3622,0.74016,0.37008,0.74016,0.37795,0.74016,0.38583,0.74016,0.3937,0.74016,0.40157,0.74016,0.40945,0.74016,0.41732,0.74016,0.4252,0.74016,0.43307,0.74016,0.44094,0.74016,0.44882,0.74016,0.45669,0.74016,0.46457,0.74016,0.47244,0.74016,0.48031,0.74016,0.48819,0.74016,0.49606,0.74016,0.50394,0.74016,0.51181,0.74016,0.51969,0.74016,0.52756,0.74016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_122()
		{
			double[] value = {0.53543,0.74016,0.54331,0.74016,0.55118,0.74016,0.55906,0.74016,0.56693,0.74016,0.5748,0.74016,0.58268,0.74016,0.59055,0.74016,0.59843,0.74016,0.6063,0.74016,0.61417,0.74016,0.62205,0.74016,0.62992,0.74016,0.6378,0.74016,0.64567,0.74016,0.65354,0.74016,0.66142,0.74016,0.66929,0.74016,0.67717,0.74016,0.68504,0.74016,0.69291,0.74016,0.70079,0.74016,0.70866,0.74016,0.71654,0.74016,0.72441,0.74016,0.73228,0.74016,0.74016,0.74016,0.74803,0.74016,0.75591,0.74016,0.76378,0.74016,0.77165,0.74016,0.77953,0.74016,0.7874,0.74016,0.79528,0.74016,0.80315,0.74016,0.81102,0.74016,0.8189,0.74016,0.82677,0.74016,0.83465,0.74016,0.84252,0.74016,0.85039,0.74016,0.85827,0.74016,0.86614,0.74016,0.87402,0.74016,0.88189,0.74016,0.88976,0.74016,0.89764,0.74016,0.90551,0.74016,0.91339,0.74016,0.92126,0.74016,0.92913,0.74016,0.93701,0.74016,0.94488,0.74016,0.95276,0.74016,0.96063,0.74016,0.9685,0.74016,0.97638,0.74016,0.98425,0.74016,0.99213,0.74016,0.99609,0.74016,0.00391,0.74803,0.00787,0.74803,0.01575,0.74803,0.02362,0.74803,0.0315,0.74803,0.03937,0.74803,0.04724,0.74803,0.05512,0.74803,0.06299,0.74803,0.07087,0.74803,0.07874,0.74803,0.08661,0.74803,0.09449,0.74803,0.10236,0.74803,0.11024,0.74803,0.11811,0.74803,0.12598,0.74803,0.13386,0.74803,0.14173,0.74803,0.14961,0.74803,0.15748,0.74803,0.16535,0.74803,0.17323,0.74803,0.1811,0.74803,0.18898,0.74803,0.19685,0.74803,0.20472,0.74803,0.2126,0.74803,0.22047,0.74803,0.22835,0.74803,0.23622,0.74803,0.24409,0.74803,0.25197,0.74803,0.25984,0.74803,0.26772,0.74803,0.27559,0.74803,0.28346,0.74803,0.29134,0.74803,0.29921,0.74803,0.30709,0.74803};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_123()
		{
			double[] value = {0.31496,0.74803,0.32283,0.74803,0.33071,0.74803,0.33858,0.74803,0.34646,0.74803,0.35433,0.74803,0.3622,0.74803,0.37008,0.74803,0.37795,0.74803,0.38583,0.74803,0.3937,0.74803,0.40157,0.74803,0.40945,0.74803,0.41732,0.74803,0.4252,0.74803,0.43307,0.74803,0.44094,0.74803,0.44882,0.74803,0.45669,0.74803,0.46457,0.74803,0.47244,0.74803,0.48031,0.74803,0.48819,0.74803,0.49606,0.74803,0.50394,0.74803,0.51181,0.74803,0.51969,0.74803,0.52756,0.74803,0.53543,0.74803,0.54331,0.74803,0.55118,0.74803,0.55906,0.74803,0.56693,0.74803,0.5748,0.74803,0.58268,0.74803,0.59055,0.74803,0.59843,0.74803,0.6063,0.74803,0.61417,0.74803,0.62205,0.74803,0.62992,0.74803,0.6378,0.74803,0.64567,0.74803,0.65354,0.74803,0.66142,0.74803,0.66929,0.74803,0.67717,0.74803,0.68504,0.74803,0.69291,0.74803,0.70079,0.74803,0.70866,0.74803,0.71654,0.74803,0.72441,0.74803,0.73228,0.74803,0.74016,0.74803,0.74803,0.74803,0.75591,0.74803,0.76378,0.74803,0.77165,0.74803,0.77953,0.74803,0.7874,0.74803,0.79528,0.74803,0.80315,0.74803,0.81102,0.74803,0.8189,0.74803,0.82677,0.74803,0.83465,0.74803,0.84252,0.74803,0.85039,0.74803,0.85827,0.74803,0.86614,0.74803,0.87402,0.74803,0.88189,0.74803,0.88976,0.74803,0.89764,0.74803,0.90551,0.74803,0.91339,0.74803,0.92126,0.74803,0.92913,0.74803,0.93701,0.74803,0.94488,0.74803,0.95276,0.74803,0.96063,0.74803,0.9685,0.74803,0.97638,0.74803,0.98425,0.74803,0.99213,0.74803,0.99609,0.74803,0.00391,0.75591,0.00787,0.75591,0.01575,0.75591,0.02362,0.75591,0.0315,0.75591,0.03937,0.75591,0.04724,0.75591,0.05512,0.75591,0.06299,0.75591,0.07087,0.75591,0.07874,0.75591,0.08661,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_124()
		{
			double[] value = {0.09449,0.75591,0.10236,0.75591,0.11024,0.75591,0.11811,0.75591,0.12598,0.75591,0.13386,0.75591,0.14173,0.75591,0.14961,0.75591,0.15748,0.75591,0.16535,0.75591,0.17323,0.75591,0.1811,0.75591,0.18898,0.75591,0.19685,0.75591,0.20472,0.75591,0.2126,0.75591,0.22047,0.75591,0.22835,0.75591,0.23622,0.75591,0.24409,0.75591,0.25197,0.75591,0.25984,0.75591,0.26772,0.75591,0.27559,0.75591,0.28346,0.75591,0.29134,0.75591,0.29921,0.75591,0.30709,0.75591,0.31496,0.75591,0.32283,0.75591,0.33071,0.75591,0.33858,0.75591,0.34646,0.75591,0.35433,0.75591,0.3622,0.75591,0.37008,0.75591,0.37795,0.75591,0.38583,0.75591,0.3937,0.75591,0.40157,0.75591,0.40945,0.75591,0.41732,0.75591,0.4252,0.75591,0.43307,0.75591,0.44094,0.75591,0.44882,0.75591,0.45669,0.75591,0.46457,0.75591,0.47244,0.75591,0.48031,0.75591,0.48819,0.75591,0.49606,0.75591,0.50394,0.75591,0.51181,0.75591,0.51969,0.75591,0.52756,0.75591,0.53543,0.75591,0.54331,0.75591,0.55118,0.75591,0.55906,0.75591,0.56693,0.75591,0.5748,0.75591,0.58268,0.75591,0.59055,0.75591,0.59843,0.75591,0.6063,0.75591,0.61417,0.75591,0.62205,0.75591,0.62992,0.75591,0.6378,0.75591,0.64567,0.75591,0.65354,0.75591,0.66142,0.75591,0.66929,0.75591,0.67717,0.75591,0.68504,0.75591,0.69291,0.75591,0.70079,0.75591,0.70866,0.75591,0.71654,0.75591,0.72441,0.75591,0.73228,0.75591,0.74016,0.75591,0.74803,0.75591,0.75591,0.75591,0.76378,0.75591,0.77165,0.75591,0.77953,0.75591,0.7874,0.75591,0.79528,0.75591,0.80315,0.75591,0.81102,0.75591,0.8189,0.75591,0.82677,0.75591,0.83465,0.75591,0.84252,0.75591,0.85039,0.75591,0.85827,0.75591,0.86614,0.75591,0.87402,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_125()
		{
			double[] value = {0.88189,0.75591,0.88976,0.75591,0.89764,0.75591,0.90551,0.75591,0.91339,0.75591,0.92126,0.75591,0.92913,0.75591,0.93701,0.75591,0.94488,0.75591,0.95276,0.75591,0.96063,0.75591,0.9685,0.75591,0.97638,0.75591,0.98425,0.75591,0.99213,0.75591,0.99609,0.75591,0.00391,0.76378,0.00787,0.76378,0.01575,0.76378,0.02362,0.76378,0.0315,0.76378,0.03937,0.76378,0.04724,0.76378,0.05512,0.76378,0.06299,0.76378,0.07087,0.76378,0.07874,0.76378,0.08661,0.76378,0.09449,0.76378,0.10236,0.76378,0.11024,0.76378,0.11811,0.76378,0.12598,0.76378,0.13386,0.76378,0.14173,0.76378,0.14961,0.76378,0.15748,0.76378,0.16535,0.76378,0.17323,0.76378,0.1811,0.76378,0.18898,0.76378,0.19685,0.76378,0.20472,0.76378,0.2126,0.76378,0.22047,0.76378,0.22835,0.76378,0.23622,0.76378,0.24409,0.76378,0.25197,0.76378,0.25984,0.76378,0.26772,0.76378,0.27559,0.76378,0.28346,0.76378,0.29134,0.76378,0.29921,0.76378,0.30709,0.76378,0.31496,0.76378,0.32283,0.76378,0.33071,0.76378,0.33858,0.76378,0.34646,0.76378,0.35433,0.76378,0.3622,0.76378,0.37008,0.76378,0.37795,0.76378,0.38583,0.76378,0.3937,0.76378,0.40157,0.76378,0.40945,0.76378,0.41732,0.76378,0.4252,0.76378,0.43307,0.76378,0.44094,0.76378,0.44882,0.76378,0.45669,0.76378,0.46457,0.76378,0.47244,0.76378,0.48031,0.76378,0.48819,0.76378,0.49606,0.76378,0.50394,0.76378,0.51181,0.76378,0.51969,0.76378,0.52756,0.76378,0.53543,0.76378,0.54331,0.76378,0.55118,0.76378,0.55906,0.76378,0.56693,0.76378,0.5748,0.76378,0.58268,0.76378,0.59055,0.76378,0.59843,0.76378,0.6063,0.76378,0.61417,0.76378,0.62205,0.76378,0.62992,0.76378,0.6378,0.76378,0.64567,0.76378,0.65354,0.76378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_126()
		{
			double[] value = {0.66142,0.76378,0.66929,0.76378,0.67717,0.76378,0.68504,0.76378,0.69291,0.76378,0.70079,0.76378,0.70866,0.76378,0.71654,0.76378,0.72441,0.76378,0.73228,0.76378,0.74016,0.76378,0.74803,0.76378,0.75591,0.76378,0.76378,0.76378,0.77165,0.76378,0.77953,0.76378,0.7874,0.76378,0.79528,0.76378,0.80315,0.76378,0.81102,0.76378,0.8189,0.76378,0.82677,0.76378,0.83465,0.76378,0.84252,0.76378,0.85039,0.76378,0.85827,0.76378,0.86614,0.76378,0.87402,0.76378,0.88189,0.76378,0.88976,0.76378,0.89764,0.76378,0.90551,0.76378,0.91339,0.76378,0.92126,0.76378,0.92913,0.76378,0.93701,0.76378,0.94488,0.76378,0.95276,0.76378,0.96063,0.76378,0.9685,0.76378,0.97638,0.76378,0.98425,0.76378,0.99213,0.76378,0.99609,0.76378,0.00391,0.77165,0.00787,0.77165,0.01575,0.77165,0.02362,0.77165,0.0315,0.77165,0.03937,0.77165,0.04724,0.77165,0.05512,0.77165,0.06299,0.77165,0.07087,0.77165,0.07874,0.77165,0.08661,0.77165,0.09449,0.77165,0.10236,0.77165,0.11024,0.77165,0.11811,0.77165,0.12598,0.77165,0.13386,0.77165,0.14173,0.77165,0.14961,0.77165,0.15748,0.77165,0.16535,0.77165,0.17323,0.77165,0.1811,0.77165,0.18898,0.77165,0.19685,0.77165,0.20472,0.77165,0.2126,0.77165,0.22047,0.77165,0.22835,0.77165,0.23622,0.77165,0.24409,0.77165,0.25197,0.77165,0.25984,0.77165,0.26772,0.77165,0.27559,0.77165,0.28346,0.77165,0.29134,0.77165,0.29921,0.77165,0.30709,0.77165,0.31496,0.77165,0.32283,0.77165,0.33071,0.77165,0.33858,0.77165,0.34646,0.77165,0.35433,0.77165,0.3622,0.77165,0.37008,0.77165,0.37795,0.77165,0.38583,0.77165,0.3937,0.77165,0.40157,0.77165,0.40945,0.77165,0.41732,0.77165,0.4252,0.77165,0.43307,0.77165};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_127()
		{
			double[] value = {0.44094,0.77165,0.44882,0.77165,0.45669,0.77165,0.46457,0.77165,0.47244,0.77165,0.48031,0.77165,0.48819,0.77165,0.49606,0.77165,0.50394,0.77165,0.51181,0.77165,0.51969,0.77165,0.52756,0.77165,0.53543,0.77165,0.54331,0.77165,0.55118,0.77165,0.55906,0.77165,0.56693,0.77165,0.5748,0.77165,0.58268,0.77165,0.59055,0.77165,0.59843,0.77165,0.6063,0.77165,0.61417,0.77165,0.62205,0.77165,0.62992,0.77165,0.6378,0.77165,0.64567,0.77165,0.65354,0.77165,0.66142,0.77165,0.66929,0.77165,0.67717,0.77165,0.68504,0.77165,0.69291,0.77165,0.70079,0.77165,0.70866,0.77165,0.71654,0.77165,0.72441,0.77165,0.73228,0.77165,0.74016,0.77165,0.74803,0.77165,0.75591,0.77165,0.76378,0.77165,0.77165,0.77165,0.77953,0.77165,0.7874,0.77165,0.79528,0.77165,0.80315,0.77165,0.81102,0.77165,0.8189,0.77165,0.82677,0.77165,0.83465,0.77165,0.84252,0.77165,0.85039,0.77165,0.85827,0.77165,0.86614,0.77165,0.87402,0.77165,0.88189,0.77165,0.88976,0.77165,0.89764,0.77165,0.90551,0.77165,0.91339,0.77165,0.92126,0.77165,0.92913,0.77165,0.93701,0.77165,0.94488,0.77165,0.95276,0.77165,0.96063,0.77165,0.9685,0.77165,0.97638,0.77165,0.98425,0.77165,0.99213,0.77165,0.99609,0.77165,0.00391,0.77953,0.00787,0.77953,0.01575,0.77953,0.02362,0.77953,0.0315,0.77953,0.03937,0.77953,0.04724,0.77953,0.05512,0.77953,0.06299,0.77953,0.07087,0.77953,0.07874,0.77953,0.08661,0.77953,0.09449,0.77953,0.10236,0.77953,0.11024,0.77953,0.11811,0.77953,0.12598,0.77953,0.13386,0.77953,0.14173,0.77953,0.14961,0.77953,0.15748,0.77953,0.16535,0.77953,0.17323,0.77953,0.1811,0.77953,0.18898,0.77953,0.19685,0.77953,0.20472,0.77953,0.2126,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_128()
		{
			double[] value = {0.22047,0.77953,0.22835,0.77953,0.23622,0.77953,0.24409,0.77953,0.25197,0.77953,0.25984,0.77953,0.26772,0.77953,0.27559,0.77953,0.28346,0.77953,0.29134,0.77953,0.29921,0.77953,0.30709,0.77953,0.31496,0.77953,0.32283,0.77953,0.33071,0.77953,0.33858,0.77953,0.34646,0.77953,0.35433,0.77953,0.3622,0.77953,0.37008,0.77953,0.37795,0.77953,0.38583,0.77953,0.3937,0.77953,0.40157,0.77953,0.40945,0.77953,0.41732,0.77953,0.4252,0.77953,0.43307,0.77953,0.44094,0.77953,0.44882,0.77953,0.45669,0.77953,0.46457,0.77953,0.47244,0.77953,0.48031,0.77953,0.48819,0.77953,0.49606,0.77953,0.50394,0.77953,0.51181,0.77953,0.51969,0.77953,0.52756,0.77953,0.53543,0.77953,0.54331,0.77953,0.55118,0.77953,0.55906,0.77953,0.56693,0.77953,0.5748,0.77953,0.58268,0.77953,0.59055,0.77953,0.59843,0.77953,0.6063,0.77953,0.61417,0.77953,0.62205,0.77953,0.62992,0.77953,0.6378,0.77953,0.64567,0.77953,0.65354,0.77953,0.66142,0.77953,0.66929,0.77953,0.67717,0.77953,0.68504,0.77953,0.69291,0.77953,0.70079,0.77953,0.70866,0.77953,0.71654,0.77953,0.72441,0.77953,0.73228,0.77953,0.74016,0.77953,0.74803,0.77953,0.75591,0.77953,0.76378,0.77953,0.77165,0.77953,0.77953,0.77953,0.7874,0.77953,0.79528,0.77953,0.80315,0.77953,0.81102,0.77953,0.8189,0.77953,0.82677,0.77953,0.83465,0.77953,0.84252,0.77953,0.85039,0.77953,0.85827,0.77953,0.86614,0.77953,0.87402,0.77953,0.88189,0.77953,0.88976,0.77953,0.89764,0.77953,0.90551,0.77953,0.91339,0.77953,0.92126,0.77953,0.92913,0.77953,0.93701,0.77953,0.94488,0.77953,0.95276,0.77953,0.96063,0.77953,0.9685,0.77953,0.97638,0.77953,0.98425,0.77953,0.99213,0.77953,0.99609,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_129()
		{
			double[] value = {0.00391,0.7874,0.00787,0.7874,0.01575,0.7874,0.02362,0.7874,0.0315,0.7874,0.03937,0.7874,0.04724,0.7874,0.05512,0.7874,0.06299,0.7874,0.07087,0.7874,0.07874,0.7874,0.08661,0.7874,0.09449,0.7874,0.10236,0.7874,0.11024,0.7874,0.11811,0.7874,0.12598,0.7874,0.13386,0.7874,0.14173,0.7874,0.14961,0.7874,0.15748,0.7874,0.16535,0.7874,0.17323,0.7874,0.1811,0.7874,0.18898,0.7874,0.19685,0.7874,0.20472,0.7874,0.2126,0.7874,0.22047,0.7874,0.22835,0.7874,0.23622,0.7874,0.24409,0.7874,0.25197,0.7874,0.25984,0.7874,0.26772,0.7874,0.27559,0.7874,0.28346,0.7874,0.29134,0.7874,0.29921,0.7874,0.30709,0.7874,0.31496,0.7874,0.32283,0.7874,0.33071,0.7874,0.33858,0.7874,0.34646,0.7874,0.35433,0.7874,0.3622,0.7874,0.37008,0.7874,0.37795,0.7874,0.38583,0.7874,0.3937,0.7874,0.40157,0.7874,0.40945,0.7874,0.41732,0.7874,0.4252,0.7874,0.43307,0.7874,0.44094,0.7874,0.44882,0.7874,0.45669,0.7874,0.46457,0.7874,0.47244,0.7874,0.48031,0.7874,0.48819,0.7874,0.49606,0.7874,0.50394,0.7874,0.51181,0.7874,0.51969,0.7874,0.52756,0.7874,0.53543,0.7874,0.54331,0.7874,0.55118,0.7874,0.55906,0.7874,0.56693,0.7874,0.5748,0.7874,0.58268,0.7874,0.59055,0.7874,0.59843,0.7874,0.6063,0.7874,0.61417,0.7874,0.62205,0.7874,0.62992,0.7874,0.6378,0.7874,0.64567,0.7874,0.65354,0.7874,0.66142,0.7874,0.66929,0.7874,0.67717,0.7874,0.68504,0.7874,0.69291,0.7874,0.70079,0.7874,0.70866,0.7874,0.71654,0.7874,0.72441,0.7874,0.73228,0.7874,0.74016,0.7874,0.74803,0.7874,0.75591,0.7874,0.76378,0.7874,0.77165,0.7874,0.77953,0.7874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_130()
		{
			double[] value = {0.7874,0.7874,0.79528,0.7874,0.80315,0.7874,0.81102,0.7874,0.8189,0.7874,0.82677,0.7874,0.83465,0.7874,0.84252,0.7874,0.85039,0.7874,0.85827,0.7874,0.86614,0.7874,0.87402,0.7874,0.88189,0.7874,0.88976,0.7874,0.89764,0.7874,0.90551,0.7874,0.91339,0.7874,0.92126,0.7874,0.92913,0.7874,0.93701,0.7874,0.94488,0.7874,0.95276,0.7874,0.96063,0.7874,0.9685,0.7874,0.97638,0.7874,0.98425,0.7874,0.99213,0.7874,0.99609,0.7874,0.00391,0.79528,0.00787,0.79528,0.01575,0.79528,0.02362,0.79528,0.0315,0.79528,0.03937,0.79528,0.04724,0.79528,0.05512,0.79528,0.06299,0.79528,0.07087,0.79528,0.07874,0.79528,0.08661,0.79528,0.09449,0.79528,0.10236,0.79528,0.11024,0.79528,0.11811,0.79528,0.12598,0.79528,0.13386,0.79528,0.14173,0.79528,0.14961,0.79528,0.15748,0.79528,0.16535,0.79528,0.17323,0.79528,0.1811,0.79528,0.18898,0.79528,0.19685,0.79528,0.20472,0.79528,0.2126,0.79528,0.22047,0.79528,0.22835,0.79528,0.23622,0.79528,0.24409,0.79528,0.25197,0.79528,0.25984,0.79528,0.26772,0.79528,0.27559,0.79528,0.28346,0.79528,0.29134,0.79528,0.29921,0.79528,0.30709,0.79528,0.31496,0.79528,0.32283,0.79528,0.33071,0.79528,0.33858,0.79528,0.34646,0.79528,0.35433,0.79528,0.3622,0.79528,0.37008,0.79528,0.37795,0.79528,0.38583,0.79528,0.3937,0.79528,0.40157,0.79528,0.40945,0.79528,0.41732,0.79528,0.4252,0.79528,0.43307,0.79528,0.44094,0.79528,0.44882,0.79528,0.45669,0.79528,0.46457,0.79528,0.47244,0.79528,0.48031,0.79528,0.48819,0.79528,0.49606,0.79528,0.50394,0.79528,0.51181,0.79528,0.51969,0.79528,0.52756,0.79528,0.53543,0.79528,0.54331,0.79528,0.55118,0.79528,0.55906,0.79528};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_131()
		{
			double[] value = {0.56693,0.79528,0.5748,0.79528,0.58268,0.79528,0.59055,0.79528,0.59843,0.79528,0.6063,0.79528,0.61417,0.79528,0.62205,0.79528,0.62992,0.79528,0.6378,0.79528,0.64567,0.79528,0.65354,0.79528,0.66142,0.79528,0.66929,0.79528,0.67717,0.79528,0.68504,0.79528,0.69291,0.79528,0.70079,0.79528,0.70866,0.79528,0.71654,0.79528,0.72441,0.79528,0.73228,0.79528,0.74016,0.79528,0.74803,0.79528,0.75591,0.79528,0.76378,0.79528,0.77165,0.79528,0.77953,0.79528,0.7874,0.79528,0.79528,0.79528,0.80315,0.79528,0.81102,0.79528,0.8189,0.79528,0.82677,0.79528,0.83465,0.79528,0.84252,0.79528,0.85039,0.79528,0.85827,0.79528,0.86614,0.79528,0.87402,0.79528,0.88189,0.79528,0.88976,0.79528,0.89764,0.79528,0.90551,0.79528,0.91339,0.79528,0.92126,0.79528,0.92913,0.79528,0.93701,0.79528,0.94488,0.79528,0.95276,0.79528,0.96063,0.79528,0.9685,0.79528,0.97638,0.79528,0.98425,0.79528,0.99213,0.79528,0.99609,0.79528,0.00391,0.80315,0.00787,0.80315,0.01575,0.80315,0.02362,0.80315,0.0315,0.80315,0.03937,0.80315,0.04724,0.80315,0.05512,0.80315,0.06299,0.80315,0.07087,0.80315,0.07874,0.80315,0.08661,0.80315,0.09449,0.80315,0.10236,0.80315,0.11024,0.80315,0.11811,0.80315,0.12598,0.80315,0.13386,0.80315,0.14173,0.80315,0.14961,0.80315,0.15748,0.80315,0.16535,0.80315,0.17323,0.80315,0.1811,0.80315,0.18898,0.80315,0.19685,0.80315,0.20472,0.80315,0.2126,0.80315,0.22047,0.80315,0.22835,0.80315,0.23622,0.80315,0.24409,0.80315,0.25197,0.80315,0.25984,0.80315,0.26772,0.80315,0.27559,0.80315,0.28346,0.80315,0.29134,0.80315,0.29921,0.80315,0.30709,0.80315,0.31496,0.80315,0.32283,0.80315,0.33071,0.80315,0.33858,0.80315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_132()
		{
			double[] value = {0.34646,0.80315,0.35433,0.80315,0.3622,0.80315,0.37008,0.80315,0.37795,0.80315,0.38583,0.80315,0.3937,0.80315,0.40157,0.80315,0.40945,0.80315,0.41732,0.80315,0.4252,0.80315,0.43307,0.80315,0.44094,0.80315,0.44882,0.80315,0.45669,0.80315,0.46457,0.80315,0.47244,0.80315,0.48031,0.80315,0.48819,0.80315,0.49606,0.80315,0.50394,0.80315,0.51181,0.80315,0.51969,0.80315,0.52756,0.80315,0.53543,0.80315,0.54331,0.80315,0.55118,0.80315,0.55906,0.80315,0.56693,0.80315,0.5748,0.80315,0.58268,0.80315,0.59055,0.80315,0.59843,0.80315,0.6063,0.80315,0.61417,0.80315,0.62205,0.80315,0.62992,0.80315,0.6378,0.80315,0.64567,0.80315,0.65354,0.80315,0.66142,0.80315,0.66929,0.80315,0.67717,0.80315,0.68504,0.80315,0.69291,0.80315,0.70079,0.80315,0.70866,0.80315,0.71654,0.80315,0.72441,0.80315,0.73228,0.80315,0.74016,0.80315,0.74803,0.80315,0.75591,0.80315,0.76378,0.80315,0.77165,0.80315,0.77953,0.80315,0.7874,0.80315,0.79528,0.80315,0.80315,0.80315,0.81102,0.80315,0.8189,0.80315,0.82677,0.80315,0.83465,0.80315,0.84252,0.80315,0.85039,0.80315,0.85827,0.80315,0.86614,0.80315,0.87402,0.80315,0.88189,0.80315,0.88976,0.80315,0.89764,0.80315,0.90551,0.80315,0.91339,0.80315,0.92126,0.80315,0.92913,0.80315,0.93701,0.80315,0.94488,0.80315,0.95276,0.80315,0.96063,0.80315,0.9685,0.80315,0.97638,0.80315,0.98425,0.80315,0.99213,0.80315,0.99609,0.80315,0.00391,0.81102,0.00787,0.81102,0.01575,0.81102,0.02362,0.81102,0.0315,0.81102,0.03937,0.81102,0.04724,0.81102,0.05512,0.81102,0.06299,0.81102,0.07087,0.81102,0.07874,0.81102,0.08661,0.81102,0.09449,0.81102,0.10236,0.81102,0.11024,0.81102,0.11811,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_133()
		{
			double[] value = {0.12598,0.81102,0.13386,0.81102,0.14173,0.81102,0.14961,0.81102,0.15748,0.81102,0.16535,0.81102,0.17323,0.81102,0.1811,0.81102,0.18898,0.81102,0.19685,0.81102,0.20472,0.81102,0.2126,0.81102,0.22047,0.81102,0.22835,0.81102,0.23622,0.81102,0.24409,0.81102,0.25197,0.81102,0.25984,0.81102,0.26772,0.81102,0.27559,0.81102,0.28346,0.81102,0.29134,0.81102,0.29921,0.81102,0.30709,0.81102,0.31496,0.81102,0.32283,0.81102,0.33071,0.81102,0.33858,0.81102,0.34646,0.81102,0.35433,0.81102,0.3622,0.81102,0.37008,0.81102,0.37795,0.81102,0.38583,0.81102,0.3937,0.81102,0.40157,0.81102,0.40945,0.81102,0.41732,0.81102,0.4252,0.81102,0.43307,0.81102,0.44094,0.81102,0.44882,0.81102,0.45669,0.81102,0.46457,0.81102,0.47244,0.81102,0.48031,0.81102,0.48819,0.81102,0.49606,0.81102,0.50394,0.81102,0.51181,0.81102,0.51969,0.81102,0.52756,0.81102,0.53543,0.81102,0.54331,0.81102,0.55118,0.81102,0.55906,0.81102,0.56693,0.81102,0.5748,0.81102,0.58268,0.81102,0.59055,0.81102,0.59843,0.81102,0.6063,0.81102,0.61417,0.81102,0.62205,0.81102,0.62992,0.81102,0.6378,0.81102,0.64567,0.81102,0.65354,0.81102,0.66142,0.81102,0.66929,0.81102,0.67717,0.81102,0.68504,0.81102,0.69291,0.81102,0.70079,0.81102,0.70866,0.81102,0.71654,0.81102,0.72441,0.81102,0.73228,0.81102,0.74016,0.81102,0.74803,0.81102,0.75591,0.81102,0.76378,0.81102,0.77165,0.81102,0.77953,0.81102,0.7874,0.81102,0.79528,0.81102,0.80315,0.81102,0.81102,0.81102,0.8189,0.81102,0.82677,0.81102,0.83465,0.81102,0.84252,0.81102,0.85039,0.81102,0.85827,0.81102,0.86614,0.81102,0.87402,0.81102,0.88189,0.81102,0.88976,0.81102,0.89764,0.81102,0.90551,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_134()
		{
			double[] value = {0.91339,0.81102,0.92126,0.81102,0.92913,0.81102,0.93701,0.81102,0.94488,0.81102,0.95276,0.81102,0.96063,0.81102,0.9685,0.81102,0.97638,0.81102,0.98425,0.81102,0.99213,0.81102,0.99609,0.81102,0.00391,0.8189,0.00787,0.8189,0.01575,0.8189,0.02362,0.8189,0.0315,0.8189,0.03937,0.8189,0.04724,0.8189,0.05512,0.8189,0.06299,0.8189,0.07087,0.8189,0.07874,0.8189,0.08661,0.8189,0.09449,0.8189,0.10236,0.8189,0.11024,0.8189,0.11811,0.8189,0.12598,0.8189,0.13386,0.8189,0.14173,0.8189,0.14961,0.8189,0.15748,0.8189,0.16535,0.8189,0.17323,0.8189,0.1811,0.8189,0.18898,0.8189,0.19685,0.8189,0.20472,0.8189,0.2126,0.8189,0.22047,0.8189,0.22835,0.8189,0.23622,0.8189,0.24409,0.8189,0.25197,0.8189,0.25984,0.8189,0.26772,0.8189,0.27559,0.8189,0.28346,0.8189,0.29134,0.8189,0.29921,0.8189,0.30709,0.8189,0.31496,0.8189,0.32283,0.8189,0.33071,0.8189,0.33858,0.8189,0.34646,0.8189,0.35433,0.8189,0.3622,0.8189,0.37008,0.8189,0.37795,0.8189,0.38583,0.8189,0.3937,0.8189,0.40157,0.8189,0.40945,0.8189,0.41732,0.8189,0.4252,0.8189,0.43307,0.8189,0.44094,0.8189,0.44882,0.8189,0.45669,0.8189,0.46457,0.8189,0.47244,0.8189,0.48031,0.8189,0.48819,0.8189,0.49606,0.8189,0.50394,0.8189,0.51181,0.8189,0.51969,0.8189,0.52756,0.8189,0.53543,0.8189,0.54331,0.8189,0.55118,0.8189,0.55906,0.8189,0.56693,0.8189,0.5748,0.8189,0.58268,0.8189,0.59055,0.8189,0.59843,0.8189,0.6063,0.8189,0.61417,0.8189,0.62205,0.8189,0.62992,0.8189,0.6378,0.8189,0.64567,0.8189,0.65354,0.8189,0.66142,0.8189,0.66929,0.8189,0.67717,0.8189,0.68504,0.8189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_135()
		{
			double[] value = {0.69291,0.8189,0.70079,0.8189,0.70866,0.8189,0.71654,0.8189,0.72441,0.8189,0.73228,0.8189,0.74016,0.8189,0.74803,0.8189,0.75591,0.8189,0.76378,0.8189,0.77165,0.8189,0.77953,0.8189,0.7874,0.8189,0.79528,0.8189,0.80315,0.8189,0.81102,0.8189,0.8189,0.8189,0.82677,0.8189,0.83465,0.8189,0.84252,0.8189,0.85039,0.8189,0.85827,0.8189,0.86614,0.8189,0.87402,0.8189,0.88189,0.8189,0.88976,0.8189,0.89764,0.8189,0.90551,0.8189,0.91339,0.8189,0.92126,0.8189,0.92913,0.8189,0.93701,0.8189,0.94488,0.8189,0.95276,0.8189,0.96063,0.8189,0.9685,0.8189,0.97638,0.8189,0.98425,0.8189,0.99213,0.8189,0.99609,0.8189,0.00391,0.82677,0.00787,0.82677,0.01575,0.82677,0.02362,0.82677,0.0315,0.82677,0.03937,0.82677,0.04724,0.82677,0.05512,0.82677,0.06299,0.82677,0.07087,0.82677,0.07874,0.82677,0.08661,0.82677,0.09449,0.82677,0.10236,0.82677,0.11024,0.82677,0.11811,0.82677,0.12598,0.82677,0.13386,0.82677,0.14173,0.82677,0.14961,0.82677,0.15748,0.82677,0.16535,0.82677,0.17323,0.82677,0.1811,0.82677,0.18898,0.82677,0.19685,0.82677,0.20472,0.82677,0.2126,0.82677,0.22047,0.82677,0.22835,0.82677,0.23622,0.82677,0.24409,0.82677,0.25197,0.82677,0.25984,0.82677,0.26772,0.82677,0.27559,0.82677,0.28346,0.82677,0.29134,0.82677,0.29921,0.82677,0.30709,0.82677,0.31496,0.82677,0.32283,0.82677,0.33071,0.82677,0.33858,0.82677,0.34646,0.82677,0.35433,0.82677,0.3622,0.82677,0.37008,0.82677,0.37795,0.82677,0.38583,0.82677,0.3937,0.82677,0.40157,0.82677,0.40945,0.82677,0.41732,0.82677,0.4252,0.82677,0.43307,0.82677,0.44094,0.82677,0.44882,0.82677,0.45669,0.82677,0.46457,0.82677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_136()
		{
			double[] value = {0.47244,0.82677,0.48031,0.82677,0.48819,0.82677,0.49606,0.82677,0.50394,0.82677,0.51181,0.82677,0.51969,0.82677,0.52756,0.82677,0.53543,0.82677,0.54331,0.82677,0.55118,0.82677,0.55906,0.82677,0.56693,0.82677,0.5748,0.82677,0.58268,0.82677,0.59055,0.82677,0.59843,0.82677,0.6063,0.82677,0.61417,0.82677,0.62205,0.82677,0.62992,0.82677,0.6378,0.82677,0.64567,0.82677,0.65354,0.82677,0.66142,0.82677,0.66929,0.82677,0.67717,0.82677,0.68504,0.82677,0.69291,0.82677,0.70079,0.82677,0.70866,0.82677,0.71654,0.82677,0.72441,0.82677,0.73228,0.82677,0.74016,0.82677,0.74803,0.82677,0.75591,0.82677,0.76378,0.82677,0.77165,0.82677,0.77953,0.82677,0.7874,0.82677,0.79528,0.82677,0.80315,0.82677,0.81102,0.82677,0.8189,0.82677,0.82677,0.82677,0.83465,0.82677,0.84252,0.82677,0.85039,0.82677,0.85827,0.82677,0.86614,0.82677,0.87402,0.82677,0.88189,0.82677,0.88976,0.82677,0.89764,0.82677,0.90551,0.82677,0.91339,0.82677,0.92126,0.82677,0.92913,0.82677,0.93701,0.82677,0.94488,0.82677,0.95276,0.82677,0.96063,0.82677,0.9685,0.82677,0.97638,0.82677,0.98425,0.82677,0.99213,0.82677,0.99609,0.82677,0.00391,0.83465,0.00787,0.83465,0.01575,0.83465,0.02362,0.83465,0.0315,0.83465,0.03937,0.83465,0.04724,0.83465,0.05512,0.83465,0.06299,0.83465,0.07087,0.83465,0.07874,0.83465,0.08661,0.83465,0.09449,0.83465,0.10236,0.83465,0.11024,0.83465,0.11811,0.83465,0.12598,0.83465,0.13386,0.83465,0.14173,0.83465,0.14961,0.83465,0.15748,0.83465,0.16535,0.83465,0.17323,0.83465,0.1811,0.83465,0.18898,0.83465,0.19685,0.83465,0.20472,0.83465,0.2126,0.83465,0.22047,0.83465,0.22835,0.83465,0.23622,0.83465,0.24409,0.83465};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_137()
		{
			double[] value = {0.25197,0.83465,0.25984,0.83465,0.26772,0.83465,0.27559,0.83465,0.28346,0.83465,0.29134,0.83465,0.29921,0.83465,0.30709,0.83465,0.31496,0.83465,0.32283,0.83465,0.33071,0.83465,0.33858,0.83465,0.34646,0.83465,0.35433,0.83465,0.3622,0.83465,0.37008,0.83465,0.37795,0.83465,0.38583,0.83465,0.3937,0.83465,0.40157,0.83465,0.40945,0.83465,0.41732,0.83465,0.4252,0.83465,0.43307,0.83465,0.44094,0.83465,0.44882,0.83465,0.45669,0.83465,0.46457,0.83465,0.47244,0.83465,0.48031,0.83465,0.48819,0.83465,0.49606,0.83465,0.50394,0.83465,0.51181,0.83465,0.51969,0.83465,0.52756,0.83465,0.53543,0.83465,0.54331,0.83465,0.55118,0.83465,0.55906,0.83465,0.56693,0.83465,0.5748,0.83465,0.58268,0.83465,0.59055,0.83465,0.59843,0.83465,0.6063,0.83465,0.61417,0.83465,0.62205,0.83465,0.62992,0.83465,0.6378,0.83465,0.64567,0.83465,0.65354,0.83465,0.66142,0.83465,0.66929,0.83465,0.67717,0.83465,0.68504,0.83465,0.69291,0.83465,0.70079,0.83465,0.70866,0.83465,0.71654,0.83465,0.72441,0.83465,0.73228,0.83465,0.74016,0.83465,0.74803,0.83465,0.75591,0.83465,0.76378,0.83465,0.77165,0.83465,0.77953,0.83465,0.7874,0.83465,0.79528,0.83465,0.80315,0.83465,0.81102,0.83465,0.8189,0.83465,0.82677,0.83465,0.83465,0.83465,0.84252,0.83465,0.85039,0.83465,0.85827,0.83465,0.86614,0.83465,0.87402,0.83465,0.88189,0.83465,0.88976,0.83465,0.89764,0.83465,0.90551,0.83465,0.91339,0.83465,0.92126,0.83465,0.92913,0.83465,0.93701,0.83465,0.94488,0.83465,0.95276,0.83465,0.96063,0.83465,0.9685,0.83465,0.97638,0.83465,0.98425,0.83465,0.99213,0.83465,0.99609,0.83465,0.00391,0.84252,0.00787,0.84252,0.01575,0.84252,0.02362,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_138()
		{
			double[] value = {0.0315,0.84252,0.03937,0.84252,0.04724,0.84252,0.05512,0.84252,0.06299,0.84252,0.07087,0.84252,0.07874,0.84252,0.08661,0.84252,0.09449,0.84252,0.10236,0.84252,0.11024,0.84252,0.11811,0.84252,0.12598,0.84252,0.13386,0.84252,0.14173,0.84252,0.14961,0.84252,0.15748,0.84252,0.16535,0.84252,0.17323,0.84252,0.1811,0.84252,0.18898,0.84252,0.19685,0.84252,0.20472,0.84252,0.2126,0.84252,0.22047,0.84252,0.22835,0.84252,0.23622,0.84252,0.24409,0.84252,0.25197,0.84252,0.25984,0.84252,0.26772,0.84252,0.27559,0.84252,0.28346,0.84252,0.29134,0.84252,0.29921,0.84252,0.30709,0.84252,0.31496,0.84252,0.32283,0.84252,0.33071,0.84252,0.33858,0.84252,0.34646,0.84252,0.35433,0.84252,0.3622,0.84252,0.37008,0.84252,0.37795,0.84252,0.38583,0.84252,0.3937,0.84252,0.40157,0.84252,0.40945,0.84252,0.41732,0.84252,0.4252,0.84252,0.43307,0.84252,0.44094,0.84252,0.44882,0.84252,0.45669,0.84252,0.46457,0.84252,0.47244,0.84252,0.48031,0.84252,0.48819,0.84252,0.49606,0.84252,0.50394,0.84252,0.51181,0.84252,0.51969,0.84252,0.52756,0.84252,0.53543,0.84252,0.54331,0.84252,0.55118,0.84252,0.55906,0.84252,0.56693,0.84252,0.5748,0.84252,0.58268,0.84252,0.59055,0.84252,0.59843,0.84252,0.6063,0.84252,0.61417,0.84252,0.62205,0.84252,0.62992,0.84252,0.6378,0.84252,0.64567,0.84252,0.65354,0.84252,0.66142,0.84252,0.66929,0.84252,0.67717,0.84252,0.68504,0.84252,0.69291,0.84252,0.70079,0.84252,0.70866,0.84252,0.71654,0.84252,0.72441,0.84252,0.73228,0.84252,0.74016,0.84252,0.74803,0.84252,0.75591,0.84252,0.76378,0.84252,0.77165,0.84252,0.77953,0.84252,0.7874,0.84252,0.79528,0.84252,0.80315,0.84252,0.81102,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_139()
		{
			double[] value = {0.8189,0.84252,0.82677,0.84252,0.83465,0.84252,0.84252,0.84252,0.85039,0.84252,0.85827,0.84252,0.86614,0.84252,0.87402,0.84252,0.88189,0.84252,0.88976,0.84252,0.89764,0.84252,0.90551,0.84252,0.91339,0.84252,0.92126,0.84252,0.92913,0.84252,0.93701,0.84252,0.94488,0.84252,0.95276,0.84252,0.96063,0.84252,0.9685,0.84252,0.97638,0.84252,0.98425,0.84252,0.99213,0.84252,0.99609,0.84252,0.00391,0.85039,0.00787,0.85039,0.01575,0.85039,0.02362,0.85039,0.0315,0.85039,0.03937,0.85039,0.04724,0.85039,0.05512,0.85039,0.06299,0.85039,0.07087,0.85039,0.07874,0.85039,0.08661,0.85039,0.09449,0.85039,0.10236,0.85039,0.11024,0.85039,0.11811,0.85039,0.12598,0.85039,0.13386,0.85039,0.14173,0.85039,0.14961,0.85039,0.15748,0.85039,0.16535,0.85039,0.17323,0.85039,0.1811,0.85039,0.18898,0.85039,0.19685,0.85039,0.20472,0.85039,0.2126,0.85039,0.22047,0.85039,0.22835,0.85039,0.23622,0.85039,0.24409,0.85039,0.25197,0.85039,0.25984,0.85039,0.26772,0.85039,0.27559,0.85039,0.28346,0.85039,0.29134,0.85039,0.29921,0.85039,0.30709,0.85039,0.31496,0.85039,0.32283,0.85039,0.33071,0.85039,0.33858,0.85039,0.34646,0.85039,0.35433,0.85039,0.3622,0.85039,0.37008,0.85039,0.37795,0.85039,0.38583,0.85039,0.3937,0.85039,0.40157,0.85039,0.40945,0.85039,0.41732,0.85039,0.4252,0.85039,0.43307,0.85039,0.44094,0.85039,0.44882,0.85039,0.45669,0.85039,0.46457,0.85039,0.47244,0.85039,0.48031,0.85039,0.48819,0.85039,0.49606,0.85039,0.50394,0.85039,0.51181,0.85039,0.51969,0.85039,0.52756,0.85039,0.53543,0.85039,0.54331,0.85039,0.55118,0.85039,0.55906,0.85039,0.56693,0.85039,0.5748,0.85039,0.58268,0.85039,0.59055,0.85039};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_140()
		{
			double[] value = {0.59843,0.85039,0.6063,0.85039,0.61417,0.85039,0.62205,0.85039,0.62992,0.85039,0.6378,0.85039,0.64567,0.85039,0.65354,0.85039,0.66142,0.85039,0.66929,0.85039,0.67717,0.85039,0.68504,0.85039,0.69291,0.85039,0.70079,0.85039,0.70866,0.85039,0.71654,0.85039,0.72441,0.85039,0.73228,0.85039,0.74016,0.85039,0.74803,0.85039,0.75591,0.85039,0.76378,0.85039,0.77165,0.85039,0.77953,0.85039,0.7874,0.85039,0.79528,0.85039,0.80315,0.85039,0.81102,0.85039,0.8189,0.85039,0.82677,0.85039,0.83465,0.85039,0.84252,0.85039,0.85039,0.85039,0.85827,0.85039,0.86614,0.85039,0.87402,0.85039,0.88189,0.85039,0.88976,0.85039,0.89764,0.85039,0.90551,0.85039,0.91339,0.85039,0.92126,0.85039,0.92913,0.85039,0.93701,0.85039,0.94488,0.85039,0.95276,0.85039,0.96063,0.85039,0.9685,0.85039,0.97638,0.85039,0.98425,0.85039,0.99213,0.85039,0.99609,0.85039,0.00391,0.85827,0.00787,0.85827,0.01575,0.85827,0.02362,0.85827,0.0315,0.85827,0.03937,0.85827,0.04724,0.85827,0.05512,0.85827,0.06299,0.85827,0.07087,0.85827,0.07874,0.85827,0.08661,0.85827,0.09449,0.85827,0.10236,0.85827,0.11024,0.85827,0.11811,0.85827,0.12598,0.85827,0.13386,0.85827,0.14173,0.85827,0.14961,0.85827,0.15748,0.85827,0.16535,0.85827,0.17323,0.85827,0.1811,0.85827,0.18898,0.85827,0.19685,0.85827,0.20472,0.85827,0.2126,0.85827,0.22047,0.85827,0.22835,0.85827,0.23622,0.85827,0.24409,0.85827,0.25197,0.85827,0.25984,0.85827,0.26772,0.85827,0.27559,0.85827,0.28346,0.85827,0.29134,0.85827,0.29921,0.85827,0.30709,0.85827,0.31496,0.85827,0.32283,0.85827,0.33071,0.85827,0.33858,0.85827,0.34646,0.85827,0.35433,0.85827,0.3622,0.85827,0.37008,0.85827};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_141()
		{
			double[] value = {0.37795,0.85827,0.38583,0.85827,0.3937,0.85827,0.40157,0.85827,0.40945,0.85827,0.41732,0.85827,0.4252,0.85827,0.43307,0.85827,0.44094,0.85827,0.44882,0.85827,0.45669,0.85827,0.46457,0.85827,0.47244,0.85827,0.48031,0.85827,0.48819,0.85827,0.49606,0.85827,0.50394,0.85827,0.51181,0.85827,0.51969,0.85827,0.52756,0.85827,0.53543,0.85827,0.54331,0.85827,0.55118,0.85827,0.55906,0.85827,0.56693,0.85827,0.5748,0.85827,0.58268,0.85827,0.59055,0.85827,0.59843,0.85827,0.6063,0.85827,0.61417,0.85827,0.62205,0.85827,0.62992,0.85827,0.6378,0.85827,0.64567,0.85827,0.65354,0.85827,0.66142,0.85827,0.66929,0.85827,0.67717,0.85827,0.68504,0.85827,0.69291,0.85827,0.70079,0.85827,0.70866,0.85827,0.71654,0.85827,0.72441,0.85827,0.73228,0.85827,0.74016,0.85827,0.74803,0.85827,0.75591,0.85827,0.76378,0.85827,0.77165,0.85827,0.77953,0.85827,0.7874,0.85827,0.79528,0.85827,0.80315,0.85827,0.81102,0.85827,0.8189,0.85827,0.82677,0.85827,0.83465,0.85827,0.84252,0.85827,0.85039,0.85827,0.85827,0.85827,0.86614,0.85827,0.87402,0.85827,0.88189,0.85827,0.88976,0.85827,0.89764,0.85827,0.90551,0.85827,0.91339,0.85827,0.92126,0.85827,0.92913,0.85827,0.93701,0.85827,0.94488,0.85827,0.95276,0.85827,0.96063,0.85827,0.9685,0.85827,0.97638,0.85827,0.98425,0.85827,0.99213,0.85827,0.99609,0.85827,0.00391,0.86614,0.00787,0.86614,0.01575,0.86614,0.02362,0.86614,0.0315,0.86614,0.03937,0.86614,0.04724,0.86614,0.05512,0.86614,0.06299,0.86614,0.07087,0.86614,0.07874,0.86614,0.08661,0.86614,0.09449,0.86614,0.10236,0.86614,0.11024,0.86614,0.11811,0.86614,0.12598,0.86614,0.13386,0.86614,0.14173,0.86614,0.14961,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_142()
		{
			double[] value = {0.15748,0.86614,0.16535,0.86614,0.17323,0.86614,0.1811,0.86614,0.18898,0.86614,0.19685,0.86614,0.20472,0.86614,0.2126,0.86614,0.22047,0.86614,0.22835,0.86614,0.23622,0.86614,0.24409,0.86614,0.25197,0.86614,0.25984,0.86614,0.26772,0.86614,0.27559,0.86614,0.28346,0.86614,0.29134,0.86614,0.29921,0.86614,0.30709,0.86614,0.31496,0.86614,0.32283,0.86614,0.33071,0.86614,0.33858,0.86614,0.34646,0.86614,0.35433,0.86614,0.3622,0.86614,0.37008,0.86614,0.37795,0.86614,0.38583,0.86614,0.3937,0.86614,0.40157,0.86614,0.40945,0.86614,0.41732,0.86614,0.4252,0.86614,0.43307,0.86614,0.44094,0.86614,0.44882,0.86614,0.45669,0.86614,0.46457,0.86614,0.47244,0.86614,0.48031,0.86614,0.48819,0.86614,0.49606,0.86614,0.50394,0.86614,0.51181,0.86614,0.51969,0.86614,0.52756,0.86614,0.53543,0.86614,0.54331,0.86614,0.55118,0.86614,0.55906,0.86614,0.56693,0.86614,0.5748,0.86614,0.58268,0.86614,0.59055,0.86614,0.59843,0.86614,0.6063,0.86614,0.61417,0.86614,0.62205,0.86614,0.62992,0.86614,0.6378,0.86614,0.64567,0.86614,0.65354,0.86614,0.66142,0.86614,0.66929,0.86614,0.67717,0.86614,0.68504,0.86614,0.69291,0.86614,0.70079,0.86614,0.70866,0.86614,0.71654,0.86614,0.72441,0.86614,0.73228,0.86614,0.74016,0.86614,0.74803,0.86614,0.75591,0.86614,0.76378,0.86614,0.77165,0.86614,0.77953,0.86614,0.7874,0.86614,0.79528,0.86614,0.80315,0.86614,0.81102,0.86614,0.8189,0.86614,0.82677,0.86614,0.83465,0.86614,0.84252,0.86614,0.85039,0.86614,0.85827,0.86614,0.86614,0.86614,0.87402,0.86614,0.88189,0.86614,0.88976,0.86614,0.89764,0.86614,0.90551,0.86614,0.91339,0.86614,0.92126,0.86614,0.92913,0.86614,0.93701,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_143()
		{
			double[] value = {0.94488,0.86614,0.95276,0.86614,0.96063,0.86614,0.9685,0.86614,0.97638,0.86614,0.98425,0.86614,0.99213,0.86614,0.99609,0.86614,0.00391,0.87402,0.00787,0.87402,0.01575,0.87402,0.02362,0.87402,0.0315,0.87402,0.03937,0.87402,0.04724,0.87402,0.05512,0.87402,0.06299,0.87402,0.07087,0.87402,0.07874,0.87402,0.08661,0.87402,0.09449,0.87402,0.10236,0.87402,0.11024,0.87402,0.11811,0.87402,0.12598,0.87402,0.13386,0.87402,0.14173,0.87402,0.14961,0.87402,0.15748,0.87402,0.16535,0.87402,0.17323,0.87402,0.1811,0.87402,0.18898,0.87402,0.19685,0.87402,0.20472,0.87402,0.2126,0.87402,0.22047,0.87402,0.22835,0.87402,0.23622,0.87402,0.24409,0.87402,0.25197,0.87402,0.25984,0.87402,0.26772,0.87402,0.27559,0.87402,0.28346,0.87402,0.29134,0.87402,0.29921,0.87402,0.30709,0.87402,0.31496,0.87402,0.32283,0.87402,0.33071,0.87402,0.33858,0.87402,0.34646,0.87402,0.35433,0.87402,0.3622,0.87402,0.37008,0.87402,0.37795,0.87402,0.38583,0.87402,0.3937,0.87402,0.40157,0.87402,0.40945,0.87402,0.41732,0.87402,0.4252,0.87402,0.43307,0.87402,0.44094,0.87402,0.44882,0.87402,0.45669,0.87402,0.46457,0.87402,0.47244,0.87402,0.48031,0.87402,0.48819,0.87402,0.49606,0.87402,0.50394,0.87402,0.51181,0.87402,0.51969,0.87402,0.52756,0.87402,0.53543,0.87402,0.54331,0.87402,0.55118,0.87402,0.55906,0.87402,0.56693,0.87402,0.5748,0.87402,0.58268,0.87402,0.59055,0.87402,0.59843,0.87402,0.6063,0.87402,0.61417,0.87402,0.62205,0.87402,0.62992,0.87402,0.6378,0.87402,0.64567,0.87402,0.65354,0.87402,0.66142,0.87402,0.66929,0.87402,0.67717,0.87402,0.68504,0.87402,0.69291,0.87402,0.70079,0.87402,0.70866,0.87402,0.71654,0.87402};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_144()
		{
			double[] value = {0.72441,0.87402,0.73228,0.87402,0.74016,0.87402,0.74803,0.87402,0.75591,0.87402,0.76378,0.87402,0.77165,0.87402,0.77953,0.87402,0.7874,0.87402,0.79528,0.87402,0.80315,0.87402,0.81102,0.87402,0.8189,0.87402,0.82677,0.87402,0.83465,0.87402,0.84252,0.87402,0.85039,0.87402,0.85827,0.87402,0.86614,0.87402,0.87402,0.87402,0.88189,0.87402,0.88976,0.87402,0.89764,0.87402,0.90551,0.87402,0.91339,0.87402,0.92126,0.87402,0.92913,0.87402,0.93701,0.87402,0.94488,0.87402,0.95276,0.87402,0.96063,0.87402,0.9685,0.87402,0.97638,0.87402,0.98425,0.87402,0.99213,0.87402,0.99609,0.87402,0.00391,0.88189,0.00787,0.88189,0.01575,0.88189,0.02362,0.88189,0.0315,0.88189,0.03937,0.88189,0.04724,0.88189,0.05512,0.88189,0.06299,0.88189,0.07087,0.88189,0.07874,0.88189,0.08661,0.88189,0.09449,0.88189,0.10236,0.88189,0.11024,0.88189,0.11811,0.88189,0.12598,0.88189,0.13386,0.88189,0.14173,0.88189,0.14961,0.88189,0.15748,0.88189,0.16535,0.88189,0.17323,0.88189,0.1811,0.88189,0.18898,0.88189,0.19685,0.88189,0.20472,0.88189,0.2126,0.88189,0.22047,0.88189,0.22835,0.88189,0.23622,0.88189,0.24409,0.88189,0.25197,0.88189,0.25984,0.88189,0.26772,0.88189,0.27559,0.88189,0.28346,0.88189,0.29134,0.88189,0.29921,0.88189,0.30709,0.88189,0.31496,0.88189,0.32283,0.88189,0.33071,0.88189,0.33858,0.88189,0.34646,0.88189,0.35433,0.88189,0.3622,0.88189,0.37008,0.88189,0.37795,0.88189,0.38583,0.88189,0.3937,0.88189,0.40157,0.88189,0.40945,0.88189,0.41732,0.88189,0.4252,0.88189,0.43307,0.88189,0.44094,0.88189,0.44882,0.88189,0.45669,0.88189,0.46457,0.88189,0.47244,0.88189,0.48031,0.88189,0.48819,0.88189,0.49606,0.88189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_145()
		{
			double[] value = {0.50394,0.88189,0.51181,0.88189,0.51969,0.88189,0.52756,0.88189,0.53543,0.88189,0.54331,0.88189,0.55118,0.88189,0.55906,0.88189,0.56693,0.88189,0.5748,0.88189,0.58268,0.88189,0.59055,0.88189,0.59843,0.88189,0.6063,0.88189,0.61417,0.88189,0.62205,0.88189,0.62992,0.88189,0.6378,0.88189,0.64567,0.88189,0.65354,0.88189,0.66142,0.88189,0.66929,0.88189,0.67717,0.88189,0.68504,0.88189,0.69291,0.88189,0.70079,0.88189,0.70866,0.88189,0.71654,0.88189,0.72441,0.88189,0.73228,0.88189,0.74016,0.88189,0.74803,0.88189,0.75591,0.88189,0.76378,0.88189,0.77165,0.88189,0.77953,0.88189,0.7874,0.88189,0.79528,0.88189,0.80315,0.88189,0.81102,0.88189,0.8189,0.88189,0.82677,0.88189,0.83465,0.88189,0.84252,0.88189,0.85039,0.88189,0.85827,0.88189,0.86614,0.88189,0.87402,0.88189,0.88189,0.88189,0.88976,0.88189,0.89764,0.88189,0.90551,0.88189,0.91339,0.88189,0.92126,0.88189,0.92913,0.88189,0.93701,0.88189,0.94488,0.88189,0.95276,0.88189,0.96063,0.88189,0.9685,0.88189,0.97638,0.88189,0.98425,0.88189,0.99213,0.88189,0.99609,0.88189,0.00391,0.88976,0.00787,0.88976,0.01575,0.88976,0.02362,0.88976,0.0315,0.88976,0.03937,0.88976,0.04724,0.88976,0.05512,0.88976,0.06299,0.88976,0.07087,0.88976,0.07874,0.88976,0.08661,0.88976,0.09449,0.88976,0.10236,0.88976,0.11024,0.88976,0.11811,0.88976,0.12598,0.88976,0.13386,0.88976,0.14173,0.88976,0.14961,0.88976,0.15748,0.88976,0.16535,0.88976,0.17323,0.88976,0.1811,0.88976,0.18898,0.88976,0.19685,0.88976,0.20472,0.88976,0.2126,0.88976,0.22047,0.88976,0.22835,0.88976,0.23622,0.88976,0.24409,0.88976,0.25197,0.88976,0.25984,0.88976,0.26772,0.88976,0.27559,0.88976};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_146()
		{
			double[] value = {0.28346,0.88976,0.29134,0.88976,0.29921,0.88976,0.30709,0.88976,0.31496,0.88976,0.32283,0.88976,0.33071,0.88976,0.33858,0.88976,0.34646,0.88976,0.35433,0.88976,0.3622,0.88976,0.37008,0.88976,0.37795,0.88976,0.38583,0.88976,0.3937,0.88976,0.40157,0.88976,0.40945,0.88976,0.41732,0.88976,0.4252,0.88976,0.43307,0.88976,0.44094,0.88976,0.44882,0.88976,0.45669,0.88976,0.46457,0.88976,0.47244,0.88976,0.48031,0.88976,0.48819,0.88976,0.49606,0.88976,0.50394,0.88976,0.51181,0.88976,0.51969,0.88976,0.52756,0.88976,0.53543,0.88976,0.54331,0.88976,0.55118,0.88976,0.55906,0.88976,0.56693,0.88976,0.5748,0.88976,0.58268,0.88976,0.59055,0.88976,0.59843,0.88976,0.6063,0.88976,0.61417,0.88976,0.62205,0.88976,0.62992,0.88976,0.6378,0.88976,0.64567,0.88976,0.65354,0.88976,0.66142,0.88976,0.66929,0.88976,0.67717,0.88976,0.68504,0.88976,0.69291,0.88976,0.70079,0.88976,0.70866,0.88976,0.71654,0.88976,0.72441,0.88976,0.73228,0.88976,0.74016,0.88976,0.74803,0.88976,0.75591,0.88976,0.76378,0.88976,0.77165,0.88976,0.77953,0.88976,0.7874,0.88976,0.79528,0.88976,0.80315,0.88976,0.81102,0.88976,0.8189,0.88976,0.82677,0.88976,0.83465,0.88976,0.84252,0.88976,0.85039,0.88976,0.85827,0.88976,0.86614,0.88976,0.87402,0.88976,0.88189,0.88976,0.88976,0.88976,0.89764,0.88976,0.90551,0.88976,0.91339,0.88976,0.92126,0.88976,0.92913,0.88976,0.93701,0.88976,0.94488,0.88976,0.95276,0.88976,0.96063,0.88976,0.9685,0.88976,0.97638,0.88976,0.98425,0.88976,0.99213,0.88976,0.99609,0.88976,0.00391,0.89764,0.00787,0.89764,0.01575,0.89764,0.02362,0.89764,0.0315,0.89764,0.03937,0.89764,0.04724,0.89764,0.05512,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_147()
		{
			double[] value = {0.06299,0.89764,0.07087,0.89764,0.07874,0.89764,0.08661,0.89764,0.09449,0.89764,0.10236,0.89764,0.11024,0.89764,0.11811,0.89764,0.12598,0.89764,0.13386,0.89764,0.14173,0.89764,0.14961,0.89764,0.15748,0.89764,0.16535,0.89764,0.17323,0.89764,0.1811,0.89764,0.18898,0.89764,0.19685,0.89764,0.20472,0.89764,0.2126,0.89764,0.22047,0.89764,0.22835,0.89764,0.23622,0.89764,0.24409,0.89764,0.25197,0.89764,0.25984,0.89764,0.26772,0.89764,0.27559,0.89764,0.28346,0.89764,0.29134,0.89764,0.29921,0.89764,0.30709,0.89764,0.31496,0.89764,0.32283,0.89764,0.33071,0.89764,0.33858,0.89764,0.34646,0.89764,0.35433,0.89764,0.3622,0.89764,0.37008,0.89764,0.37795,0.89764,0.38583,0.89764,0.3937,0.89764,0.40157,0.89764,0.40945,0.89764,0.41732,0.89764,0.4252,0.89764,0.43307,0.89764,0.44094,0.89764,0.44882,0.89764,0.45669,0.89764,0.46457,0.89764,0.47244,0.89764,0.48031,0.89764,0.48819,0.89764,0.49606,0.89764,0.50394,0.89764,0.51181,0.89764,0.51969,0.89764,0.52756,0.89764,0.53543,0.89764,0.54331,0.89764,0.55118,0.89764,0.55906,0.89764,0.56693,0.89764,0.5748,0.89764,0.58268,0.89764,0.59055,0.89764,0.59843,0.89764,0.6063,0.89764,0.61417,0.89764,0.62205,0.89764,0.62992,0.89764,0.6378,0.89764,0.64567,0.89764,0.65354,0.89764,0.66142,0.89764,0.66929,0.89764,0.67717,0.89764,0.68504,0.89764,0.69291,0.89764,0.70079,0.89764,0.70866,0.89764,0.71654,0.89764,0.72441,0.89764,0.73228,0.89764,0.74016,0.89764,0.74803,0.89764,0.75591,0.89764,0.76378,0.89764,0.77165,0.89764,0.77953,0.89764,0.7874,0.89764,0.79528,0.89764,0.80315,0.89764,0.81102,0.89764,0.8189,0.89764,0.82677,0.89764,0.83465,0.89764,0.84252,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_148()
		{
			double[] value = {0.85039,0.89764,0.85827,0.89764,0.86614,0.89764,0.87402,0.89764,0.88189,0.89764,0.88976,0.89764,0.89764,0.89764,0.90551,0.89764,0.91339,0.89764,0.92126,0.89764,0.92913,0.89764,0.93701,0.89764,0.94488,0.89764,0.95276,0.89764,0.96063,0.89764,0.9685,0.89764,0.97638,0.89764,0.98425,0.89764,0.99213,0.89764,0.99609,0.89764,0.00391,0.90551,0.00787,0.90551,0.01575,0.90551,0.02362,0.90551,0.0315,0.90551,0.03937,0.90551,0.04724,0.90551,0.05512,0.90551,0.06299,0.90551,0.07087,0.90551,0.07874,0.90551,0.08661,0.90551,0.09449,0.90551,0.10236,0.90551,0.11024,0.90551,0.11811,0.90551,0.12598,0.90551,0.13386,0.90551,0.14173,0.90551,0.14961,0.90551,0.15748,0.90551,0.16535,0.90551,0.17323,0.90551,0.1811,0.90551,0.18898,0.90551,0.19685,0.90551,0.20472,0.90551,0.2126,0.90551,0.22047,0.90551,0.22835,0.90551,0.23622,0.90551,0.24409,0.90551,0.25197,0.90551,0.25984,0.90551,0.26772,0.90551,0.27559,0.90551,0.28346,0.90551,0.29134,0.90551,0.29921,0.90551,0.30709,0.90551,0.31496,0.90551,0.32283,0.90551,0.33071,0.90551,0.33858,0.90551,0.34646,0.90551,0.35433,0.90551,0.3622,0.90551,0.37008,0.90551,0.37795,0.90551,0.38583,0.90551,0.3937,0.90551,0.40157,0.90551,0.40945,0.90551,0.41732,0.90551,0.4252,0.90551,0.43307,0.90551,0.44094,0.90551,0.44882,0.90551,0.45669,0.90551,0.46457,0.90551,0.47244,0.90551,0.48031,0.90551,0.48819,0.90551,0.49606,0.90551,0.50394,0.90551,0.51181,0.90551,0.51969,0.90551,0.52756,0.90551,0.53543,0.90551,0.54331,0.90551,0.55118,0.90551,0.55906,0.90551,0.56693,0.90551,0.5748,0.90551,0.58268,0.90551,0.59055,0.90551,0.59843,0.90551,0.6063,0.90551,0.61417,0.90551,0.62205,0.90551};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_149()
		{
			double[] value = {0.62992,0.90551,0.6378,0.90551,0.64567,0.90551,0.65354,0.90551,0.66142,0.90551,0.66929,0.90551,0.67717,0.90551,0.68504,0.90551,0.69291,0.90551,0.70079,0.90551,0.70866,0.90551,0.71654,0.90551,0.72441,0.90551,0.73228,0.90551,0.74016,0.90551,0.74803,0.90551,0.75591,0.90551,0.76378,0.90551,0.77165,0.90551,0.77953,0.90551,0.7874,0.90551,0.79528,0.90551,0.80315,0.90551,0.81102,0.90551,0.8189,0.90551,0.82677,0.90551,0.83465,0.90551,0.84252,0.90551,0.85039,0.90551,0.85827,0.90551,0.86614,0.90551,0.87402,0.90551,0.88189,0.90551,0.88976,0.90551,0.89764,0.90551,0.90551,0.90551,0.91339,0.90551,0.92126,0.90551,0.92913,0.90551,0.93701,0.90551,0.94488,0.90551,0.95276,0.90551,0.96063,0.90551,0.9685,0.90551,0.97638,0.90551,0.98425,0.90551,0.99213,0.90551,0.99609,0.90551,0.00391,0.91339,0.00787,0.91339,0.01575,0.91339,0.02362,0.91339,0.0315,0.91339,0.03937,0.91339,0.04724,0.91339,0.05512,0.91339,0.06299,0.91339,0.07087,0.91339,0.07874,0.91339,0.08661,0.91339,0.09449,0.91339,0.10236,0.91339,0.11024,0.91339,0.11811,0.91339,0.12598,0.91339,0.13386,0.91339,0.14173,0.91339,0.14961,0.91339,0.15748,0.91339,0.16535,0.91339,0.17323,0.91339,0.1811,0.91339,0.18898,0.91339,0.19685,0.91339,0.20472,0.91339,0.2126,0.91339,0.22047,0.91339,0.22835,0.91339,0.23622,0.91339,0.24409,0.91339,0.25197,0.91339,0.25984,0.91339,0.26772,0.91339,0.27559,0.91339,0.28346,0.91339,0.29134,0.91339,0.29921,0.91339,0.30709,0.91339,0.31496,0.91339,0.32283,0.91339,0.33071,0.91339,0.33858,0.91339,0.34646,0.91339,0.35433,0.91339,0.3622,0.91339,0.37008,0.91339,0.37795,0.91339,0.38583,0.91339,0.3937,0.91339,0.40157,0.91339};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_150()
		{
			double[] value = {0.40945,0.91339,0.41732,0.91339,0.4252,0.91339,0.43307,0.91339,0.44094,0.91339,0.44882,0.91339,0.45669,0.91339,0.46457,0.91339,0.47244,0.91339,0.48031,0.91339,0.48819,0.91339,0.49606,0.91339,0.50394,0.91339,0.51181,0.91339,0.51969,0.91339,0.52756,0.91339,0.53543,0.91339,0.54331,0.91339,0.55118,0.91339,0.55906,0.91339,0.56693,0.91339,0.5748,0.91339,0.58268,0.91339,0.59055,0.91339,0.59843,0.91339,0.6063,0.91339,0.61417,0.91339,0.62205,0.91339,0.62992,0.91339,0.6378,0.91339,0.64567,0.91339,0.65354,0.91339,0.66142,0.91339,0.66929,0.91339,0.67717,0.91339,0.68504,0.91339,0.69291,0.91339,0.70079,0.91339,0.70866,0.91339,0.71654,0.91339,0.72441,0.91339,0.73228,0.91339,0.74016,0.91339,0.74803,0.91339,0.75591,0.91339,0.76378,0.91339,0.77165,0.91339,0.77953,0.91339,0.7874,0.91339,0.79528,0.91339,0.80315,0.91339,0.81102,0.91339,0.8189,0.91339,0.82677,0.91339,0.83465,0.91339,0.84252,0.91339,0.85039,0.91339,0.85827,0.91339,0.86614,0.91339,0.87402,0.91339,0.88189,0.91339,0.88976,0.91339,0.89764,0.91339,0.90551,0.91339,0.91339,0.91339,0.92126,0.91339,0.92913,0.91339,0.93701,0.91339,0.94488,0.91339,0.95276,0.91339,0.96063,0.91339,0.9685,0.91339,0.97638,0.91339,0.98425,0.91339,0.99213,0.91339,0.99609,0.91339,0.00391,0.92126,0.00787,0.92126,0.01575,0.92126,0.02362,0.92126,0.0315,0.92126,0.03937,0.92126,0.04724,0.92126,0.05512,0.92126,0.06299,0.92126,0.07087,0.92126,0.07874,0.92126,0.08661,0.92126,0.09449,0.92126,0.10236,0.92126,0.11024,0.92126,0.11811,0.92126,0.12598,0.92126,0.13386,0.92126,0.14173,0.92126,0.14961,0.92126,0.15748,0.92126,0.16535,0.92126,0.17323,0.92126,0.1811,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_151()
		{
			double[] value = {0.18898,0.92126,0.19685,0.92126,0.20472,0.92126,0.2126,0.92126,0.22047,0.92126,0.22835,0.92126,0.23622,0.92126,0.24409,0.92126,0.25197,0.92126,0.25984,0.92126,0.26772,0.92126,0.27559,0.92126,0.28346,0.92126,0.29134,0.92126,0.29921,0.92126,0.30709,0.92126,0.31496,0.92126,0.32283,0.92126,0.33071,0.92126,0.33858,0.92126,0.34646,0.92126,0.35433,0.92126,0.3622,0.92126,0.37008,0.92126,0.37795,0.92126,0.38583,0.92126,0.3937,0.92126,0.40157,0.92126,0.40945,0.92126,0.41732,0.92126,0.4252,0.92126,0.43307,0.92126,0.44094,0.92126,0.44882,0.92126,0.45669,0.92126,0.46457,0.92126,0.47244,0.92126,0.48031,0.92126,0.48819,0.92126,0.49606,0.92126,0.50394,0.92126,0.51181,0.92126,0.51969,0.92126,0.52756,0.92126,0.53543,0.92126,0.54331,0.92126,0.55118,0.92126,0.55906,0.92126,0.56693,0.92126,0.5748,0.92126,0.58268,0.92126,0.59055,0.92126,0.59843,0.92126,0.6063,0.92126,0.61417,0.92126,0.62205,0.92126,0.62992,0.92126,0.6378,0.92126,0.64567,0.92126,0.65354,0.92126,0.66142,0.92126,0.66929,0.92126,0.67717,0.92126,0.68504,0.92126,0.69291,0.92126,0.70079,0.92126,0.70866,0.92126,0.71654,0.92126,0.72441,0.92126,0.73228,0.92126,0.74016,0.92126,0.74803,0.92126,0.75591,0.92126,0.76378,0.92126,0.77165,0.92126,0.77953,0.92126,0.7874,0.92126,0.79528,0.92126,0.80315,0.92126,0.81102,0.92126,0.8189,0.92126,0.82677,0.92126,0.83465,0.92126,0.84252,0.92126,0.85039,0.92126,0.85827,0.92126,0.86614,0.92126,0.87402,0.92126,0.88189,0.92126,0.88976,0.92126,0.89764,0.92126,0.90551,0.92126,0.91339,0.92126,0.92126,0.92126,0.92913,0.92126,0.93701,0.92126,0.94488,0.92126,0.95276,0.92126,0.96063,0.92126,0.9685,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_152()
		{
			double[] value = {0.97638,0.92126,0.98425,0.92126,0.99213,0.92126,0.99609,0.92126,0.00391,0.92913,0.00787,0.92913,0.01575,0.92913,0.02362,0.92913,0.0315,0.92913,0.03937,0.92913,0.04724,0.92913,0.05512,0.92913,0.06299,0.92913,0.07087,0.92913,0.07874,0.92913,0.08661,0.92913,0.09449,0.92913,0.10236,0.92913,0.11024,0.92913,0.11811,0.92913,0.12598,0.92913,0.13386,0.92913,0.14173,0.92913,0.14961,0.92913,0.15748,0.92913,0.16535,0.92913,0.17323,0.92913,0.1811,0.92913,0.18898,0.92913,0.19685,0.92913,0.20472,0.92913,0.2126,0.92913,0.22047,0.92913,0.22835,0.92913,0.23622,0.92913,0.24409,0.92913,0.25197,0.92913,0.25984,0.92913,0.26772,0.92913,0.27559,0.92913,0.28346,0.92913,0.29134,0.92913,0.29921,0.92913,0.30709,0.92913,0.31496,0.92913,0.32283,0.92913,0.33071,0.92913,0.33858,0.92913,0.34646,0.92913,0.35433,0.92913,0.3622,0.92913,0.37008,0.92913,0.37795,0.92913,0.38583,0.92913,0.3937,0.92913,0.40157,0.92913,0.40945,0.92913,0.41732,0.92913,0.4252,0.92913,0.43307,0.92913,0.44094,0.92913,0.44882,0.92913,0.45669,0.92913,0.46457,0.92913,0.47244,0.92913,0.48031,0.92913,0.48819,0.92913,0.49606,0.92913,0.50394,0.92913,0.51181,0.92913,0.51969,0.92913,0.52756,0.92913,0.53543,0.92913,0.54331,0.92913,0.55118,0.92913,0.55906,0.92913,0.56693,0.92913,0.5748,0.92913,0.58268,0.92913,0.59055,0.92913,0.59843,0.92913,0.6063,0.92913,0.61417,0.92913,0.62205,0.92913,0.62992,0.92913,0.6378,0.92913,0.64567,0.92913,0.65354,0.92913,0.66142,0.92913,0.66929,0.92913,0.67717,0.92913,0.68504,0.92913,0.69291,0.92913,0.70079,0.92913,0.70866,0.92913,0.71654,0.92913,0.72441,0.92913,0.73228,0.92913,0.74016,0.92913,0.74803,0.92913};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_153()
		{
			double[] value = {0.75591,0.92913,0.76378,0.92913,0.77165,0.92913,0.77953,0.92913,0.7874,0.92913,0.79528,0.92913,0.80315,0.92913,0.81102,0.92913,0.8189,0.92913,0.82677,0.92913,0.83465,0.92913,0.84252,0.92913,0.85039,0.92913,0.85827,0.92913,0.86614,0.92913,0.87402,0.92913,0.88189,0.92913,0.88976,0.92913,0.89764,0.92913,0.90551,0.92913,0.91339,0.92913,0.92126,0.92913,0.92913,0.92913,0.93701,0.92913,0.94488,0.92913,0.95276,0.92913,0.96063,0.92913,0.9685,0.92913,0.97638,0.92913,0.98425,0.92913,0.99213,0.92913,0.99609,0.92913,0.00391,0.93701,0.00787,0.93701,0.01575,0.93701,0.02362,0.93701,0.0315,0.93701,0.03937,0.93701,0.04724,0.93701,0.05512,0.93701,0.06299,0.93701,0.07087,0.93701,0.07874,0.93701,0.08661,0.93701,0.09449,0.93701,0.10236,0.93701,0.11024,0.93701,0.11811,0.93701,0.12598,0.93701,0.13386,0.93701,0.14173,0.93701,0.14961,0.93701,0.15748,0.93701,0.16535,0.93701,0.17323,0.93701,0.1811,0.93701,0.18898,0.93701,0.19685,0.93701,0.20472,0.93701,0.2126,0.93701,0.22047,0.93701,0.22835,0.93701,0.23622,0.93701,0.24409,0.93701,0.25197,0.93701,0.25984,0.93701,0.26772,0.93701,0.27559,0.93701,0.28346,0.93701,0.29134,0.93701,0.29921,0.93701,0.30709,0.93701,0.31496,0.93701,0.32283,0.93701,0.33071,0.93701,0.33858,0.93701,0.34646,0.93701,0.35433,0.93701,0.3622,0.93701,0.37008,0.93701,0.37795,0.93701,0.38583,0.93701,0.3937,0.93701,0.40157,0.93701,0.40945,0.93701,0.41732,0.93701,0.4252,0.93701,0.43307,0.93701,0.44094,0.93701,0.44882,0.93701,0.45669,0.93701,0.46457,0.93701,0.47244,0.93701,0.48031,0.93701,0.48819,0.93701,0.49606,0.93701,0.50394,0.93701,0.51181,0.93701,0.51969,0.93701,0.52756,0.93701};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_154()
		{
			double[] value = {0.53543,0.93701,0.54331,0.93701,0.55118,0.93701,0.55906,0.93701,0.56693,0.93701,0.5748,0.93701,0.58268,0.93701,0.59055,0.93701,0.59843,0.93701,0.6063,0.93701,0.61417,0.93701,0.62205,0.93701,0.62992,0.93701,0.6378,0.93701,0.64567,0.93701,0.65354,0.93701,0.66142,0.93701,0.66929,0.93701,0.67717,0.93701,0.68504,0.93701,0.69291,0.93701,0.70079,0.93701,0.70866,0.93701,0.71654,0.93701,0.72441,0.93701,0.73228,0.93701,0.74016,0.93701,0.74803,0.93701,0.75591,0.93701,0.76378,0.93701,0.77165,0.93701,0.77953,0.93701,0.7874,0.93701,0.79528,0.93701,0.80315,0.93701,0.81102,0.93701,0.8189,0.93701,0.82677,0.93701,0.83465,0.93701,0.84252,0.93701,0.85039,0.93701,0.85827,0.93701,0.86614,0.93701,0.87402,0.93701,0.88189,0.93701,0.88976,0.93701,0.89764,0.93701,0.90551,0.93701,0.91339,0.93701,0.92126,0.93701,0.92913,0.93701,0.93701,0.93701,0.94488,0.93701,0.95276,0.93701,0.96063,0.93701,0.9685,0.93701,0.97638,0.93701,0.98425,0.93701,0.99213,0.93701,0.99609,0.93701,0.00391,0.94488,0.00787,0.94488,0.01575,0.94488,0.02362,0.94488,0.0315,0.94488,0.03937,0.94488,0.04724,0.94488,0.05512,0.94488,0.06299,0.94488,0.07087,0.94488,0.07874,0.94488,0.08661,0.94488,0.09449,0.94488,0.10236,0.94488,0.11024,0.94488,0.11811,0.94488,0.12598,0.94488,0.13386,0.94488,0.14173,0.94488,0.14961,0.94488,0.15748,0.94488,0.16535,0.94488,0.17323,0.94488,0.1811,0.94488,0.18898,0.94488,0.19685,0.94488,0.20472,0.94488,0.2126,0.94488,0.22047,0.94488,0.22835,0.94488,0.23622,0.94488,0.24409,0.94488,0.25197,0.94488,0.25984,0.94488,0.26772,0.94488,0.27559,0.94488,0.28346,0.94488,0.29134,0.94488,0.29921,0.94488,0.30709,0.94488};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_155()
		{
			double[] value = {0.31496,0.94488,0.32283,0.94488,0.33071,0.94488,0.33858,0.94488,0.34646,0.94488,0.35433,0.94488,0.3622,0.94488,0.37008,0.94488,0.37795,0.94488,0.38583,0.94488,0.3937,0.94488,0.40157,0.94488,0.40945,0.94488,0.41732,0.94488,0.4252,0.94488,0.43307,0.94488,0.44094,0.94488,0.44882,0.94488,0.45669,0.94488,0.46457,0.94488,0.47244,0.94488,0.48031,0.94488,0.48819,0.94488,0.49606,0.94488,0.50394,0.94488,0.51181,0.94488,0.51969,0.94488,0.52756,0.94488,0.53543,0.94488,0.54331,0.94488,0.55118,0.94488,0.55906,0.94488,0.56693,0.94488,0.5748,0.94488,0.58268,0.94488,0.59055,0.94488,0.59843,0.94488,0.6063,0.94488,0.61417,0.94488,0.62205,0.94488,0.62992,0.94488,0.6378,0.94488,0.64567,0.94488,0.65354,0.94488,0.66142,0.94488,0.66929,0.94488,0.67717,0.94488,0.68504,0.94488,0.69291,0.94488,0.70079,0.94488,0.70866,0.94488,0.71654,0.94488,0.72441,0.94488,0.73228,0.94488,0.74016,0.94488,0.74803,0.94488,0.75591,0.94488,0.76378,0.94488,0.77165,0.94488,0.77953,0.94488,0.7874,0.94488,0.79528,0.94488,0.80315,0.94488,0.81102,0.94488,0.8189,0.94488,0.82677,0.94488,0.83465,0.94488,0.84252,0.94488,0.85039,0.94488,0.85827,0.94488,0.86614,0.94488,0.87402,0.94488,0.88189,0.94488,0.88976,0.94488,0.89764,0.94488,0.90551,0.94488,0.91339,0.94488,0.92126,0.94488,0.92913,0.94488,0.93701,0.94488,0.94488,0.94488,0.95276,0.94488,0.96063,0.94488,0.9685,0.94488,0.97638,0.94488,0.98425,0.94488,0.99213,0.94488,0.99609,0.94488,0.00391,0.95276,0.00787,0.95276,0.01575,0.95276,0.02362,0.95276,0.0315,0.95276,0.03937,0.95276,0.04724,0.95276,0.05512,0.95276,0.06299,0.95276,0.07087,0.95276,0.07874,0.95276,0.08661,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_156()
		{
			double[] value = {0.09449,0.95276,0.10236,0.95276,0.11024,0.95276,0.11811,0.95276,0.12598,0.95276,0.13386,0.95276,0.14173,0.95276,0.14961,0.95276,0.15748,0.95276,0.16535,0.95276,0.17323,0.95276,0.1811,0.95276,0.18898,0.95276,0.19685,0.95276,0.20472,0.95276,0.2126,0.95276,0.22047,0.95276,0.22835,0.95276,0.23622,0.95276,0.24409,0.95276,0.25197,0.95276,0.25984,0.95276,0.26772,0.95276,0.27559,0.95276,0.28346,0.95276,0.29134,0.95276,0.29921,0.95276,0.30709,0.95276,0.31496,0.95276,0.32283,0.95276,0.33071,0.95276,0.33858,0.95276,0.34646,0.95276,0.35433,0.95276,0.3622,0.95276,0.37008,0.95276,0.37795,0.95276,0.38583,0.95276,0.3937,0.95276,0.40157,0.95276,0.40945,0.95276,0.41732,0.95276,0.4252,0.95276,0.43307,0.95276,0.44094,0.95276,0.44882,0.95276,0.45669,0.95276,0.46457,0.95276,0.47244,0.95276,0.48031,0.95276,0.48819,0.95276,0.49606,0.95276,0.50394,0.95276,0.51181,0.95276,0.51969,0.95276,0.52756,0.95276,0.53543,0.95276,0.54331,0.95276,0.55118,0.95276,0.55906,0.95276,0.56693,0.95276,0.5748,0.95276,0.58268,0.95276,0.59055,0.95276,0.59843,0.95276,0.6063,0.95276,0.61417,0.95276,0.62205,0.95276,0.62992,0.95276,0.6378,0.95276,0.64567,0.95276,0.65354,0.95276,0.66142,0.95276,0.66929,0.95276,0.67717,0.95276,0.68504,0.95276,0.69291,0.95276,0.70079,0.95276,0.70866,0.95276,0.71654,0.95276,0.72441,0.95276,0.73228,0.95276,0.74016,0.95276,0.74803,0.95276,0.75591,0.95276,0.76378,0.95276,0.77165,0.95276,0.77953,0.95276,0.7874,0.95276,0.79528,0.95276,0.80315,0.95276,0.81102,0.95276,0.8189,0.95276,0.82677,0.95276,0.83465,0.95276,0.84252,0.95276,0.85039,0.95276,0.85827,0.95276,0.86614,0.95276,0.87402,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_157()
		{
			double[] value = {0.88189,0.95276,0.88976,0.95276,0.89764,0.95276,0.90551,0.95276,0.91339,0.95276,0.92126,0.95276,0.92913,0.95276,0.93701,0.95276,0.94488,0.95276,0.95276,0.95276,0.96063,0.95276,0.9685,0.95276,0.97638,0.95276,0.98425,0.95276,0.99213,0.95276,0.99609,0.95276,0.00391,0.96063,0.00787,0.96063,0.01575,0.96063,0.02362,0.96063,0.0315,0.96063,0.03937,0.96063,0.04724,0.96063,0.05512,0.96063,0.06299,0.96063,0.07087,0.96063,0.07874,0.96063,0.08661,0.96063,0.09449,0.96063,0.10236,0.96063,0.11024,0.96063,0.11811,0.96063,0.12598,0.96063,0.13386,0.96063,0.14173,0.96063,0.14961,0.96063,0.15748,0.96063,0.16535,0.96063,0.17323,0.96063,0.1811,0.96063,0.18898,0.96063,0.19685,0.96063,0.20472,0.96063,0.2126,0.96063,0.22047,0.96063,0.22835,0.96063,0.23622,0.96063,0.24409,0.96063,0.25197,0.96063,0.25984,0.96063,0.26772,0.96063,0.27559,0.96063,0.28346,0.96063,0.29134,0.96063,0.29921,0.96063,0.30709,0.96063,0.31496,0.96063,0.32283,0.96063,0.33071,0.96063,0.33858,0.96063,0.34646,0.96063,0.35433,0.96063,0.3622,0.96063,0.37008,0.96063,0.37795,0.96063,0.38583,0.96063,0.3937,0.96063,0.40157,0.96063,0.40945,0.96063,0.41732,0.96063,0.4252,0.96063,0.43307,0.96063,0.44094,0.96063,0.44882,0.96063,0.45669,0.96063,0.46457,0.96063,0.47244,0.96063,0.48031,0.96063,0.48819,0.96063,0.49606,0.96063,0.50394,0.96063,0.51181,0.96063,0.51969,0.96063,0.52756,0.96063,0.53543,0.96063,0.54331,0.96063,0.55118,0.96063,0.55906,0.96063,0.56693,0.96063,0.5748,0.96063,0.58268,0.96063,0.59055,0.96063,0.59843,0.96063,0.6063,0.96063,0.61417,0.96063,0.62205,0.96063,0.62992,0.96063,0.6378,0.96063,0.64567,0.96063,0.65354,0.96063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_158()
		{
			double[] value = {0.66142,0.96063,0.66929,0.96063,0.67717,0.96063,0.68504,0.96063,0.69291,0.96063,0.70079,0.96063,0.70866,0.96063,0.71654,0.96063,0.72441,0.96063,0.73228,0.96063,0.74016,0.96063,0.74803,0.96063,0.75591,0.96063,0.76378,0.96063,0.77165,0.96063,0.77953,0.96063,0.7874,0.96063,0.79528,0.96063,0.80315,0.96063,0.81102,0.96063,0.8189,0.96063,0.82677,0.96063,0.83465,0.96063,0.84252,0.96063,0.85039,0.96063,0.85827,0.96063,0.86614,0.96063,0.87402,0.96063,0.88189,0.96063,0.88976,0.96063,0.89764,0.96063,0.90551,0.96063,0.91339,0.96063,0.92126,0.96063,0.92913,0.96063,0.93701,0.96063,0.94488,0.96063,0.95276,0.96063,0.96063,0.96063,0.9685,0.96063,0.97638,0.96063,0.98425,0.96063,0.99213,0.96063,0.99609,0.96063,0.00391,0.9685,0.00787,0.9685,0.01575,0.9685,0.02362,0.9685,0.0315,0.9685,0.03937,0.9685,0.04724,0.9685,0.05512,0.9685,0.06299,0.9685,0.07087,0.9685,0.07874,0.9685,0.08661,0.9685,0.09449,0.9685,0.10236,0.9685,0.11024,0.9685,0.11811,0.9685,0.12598,0.9685,0.13386,0.9685,0.14173,0.9685,0.14961,0.9685,0.15748,0.9685,0.16535,0.9685,0.17323,0.9685,0.1811,0.9685,0.18898,0.9685,0.19685,0.9685,0.20472,0.9685,0.2126,0.9685,0.22047,0.9685,0.22835,0.9685,0.23622,0.9685,0.24409,0.9685,0.25197,0.9685,0.25984,0.9685,0.26772,0.9685,0.27559,0.9685,0.28346,0.9685,0.29134,0.9685,0.29921,0.9685,0.30709,0.9685,0.31496,0.9685,0.32283,0.9685,0.33071,0.9685,0.33858,0.9685,0.34646,0.9685,0.35433,0.9685,0.3622,0.9685,0.37008,0.9685,0.37795,0.9685,0.38583,0.9685,0.3937,0.9685,0.40157,0.9685,0.40945,0.9685,0.41732,0.9685,0.4252,0.9685,0.43307,0.9685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_159()
		{
			double[] value = {0.44094,0.9685,0.44882,0.9685,0.45669,0.9685,0.46457,0.9685,0.47244,0.9685,0.48031,0.9685,0.48819,0.9685,0.49606,0.9685,0.50394,0.9685,0.51181,0.9685,0.51969,0.9685,0.52756,0.9685,0.53543,0.9685,0.54331,0.9685,0.55118,0.9685,0.55906,0.9685,0.56693,0.9685,0.5748,0.9685,0.58268,0.9685,0.59055,0.9685,0.59843,0.9685,0.6063,0.9685,0.61417,0.9685,0.62205,0.9685,0.62992,0.9685,0.6378,0.9685,0.64567,0.9685,0.65354,0.9685,0.66142,0.9685,0.66929,0.9685,0.67717,0.9685,0.68504,0.9685,0.69291,0.9685,0.70079,0.9685,0.70866,0.9685,0.71654,0.9685,0.72441,0.9685,0.73228,0.9685,0.74016,0.9685,0.74803,0.9685,0.75591,0.9685,0.76378,0.9685,0.77165,0.9685,0.77953,0.9685,0.7874,0.9685,0.79528,0.9685,0.80315,0.9685,0.81102,0.9685,0.8189,0.9685,0.82677,0.9685,0.83465,0.9685,0.84252,0.9685,0.85039,0.9685,0.85827,0.9685,0.86614,0.9685,0.87402,0.9685,0.88189,0.9685,0.88976,0.9685,0.89764,0.9685,0.90551,0.9685,0.91339,0.9685,0.92126,0.9685,0.92913,0.9685,0.93701,0.9685,0.94488,0.9685,0.95276,0.9685,0.96063,0.9685,0.9685,0.9685,0.97638,0.9685,0.98425,0.9685,0.99213,0.9685,0.99609,0.9685,0.00391,0.97638,0.00787,0.97638,0.01575,0.97638,0.02362,0.97638,0.0315,0.97638,0.03937,0.97638,0.04724,0.97638,0.05512,0.97638,0.06299,0.97638,0.07087,0.97638,0.07874,0.97638,0.08661,0.97638,0.09449,0.97638,0.10236,0.97638,0.11024,0.97638,0.11811,0.97638,0.12598,0.97638,0.13386,0.97638,0.14173,0.97638,0.14961,0.97638,0.15748,0.97638,0.16535,0.97638,0.17323,0.97638,0.1811,0.97638,0.18898,0.97638,0.19685,0.97638,0.20472,0.97638,0.2126,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_160()
		{
			double[] value = {0.22047,0.97638,0.22835,0.97638,0.23622,0.97638,0.24409,0.97638,0.25197,0.97638,0.25984,0.97638,0.26772,0.97638,0.27559,0.97638,0.28346,0.97638,0.29134,0.97638,0.29921,0.97638,0.30709,0.97638,0.31496,0.97638,0.32283,0.97638,0.33071,0.97638,0.33858,0.97638,0.34646,0.97638,0.35433,0.97638,0.3622,0.97638,0.37008,0.97638,0.37795,0.97638,0.38583,0.97638,0.3937,0.97638,0.40157,0.97638,0.40945,0.97638,0.41732,0.97638,0.4252,0.97638,0.43307,0.97638,0.44094,0.97638,0.44882,0.97638,0.45669,0.97638,0.46457,0.97638,0.47244,0.97638,0.48031,0.97638,0.48819,0.97638,0.49606,0.97638,0.50394,0.97638,0.51181,0.97638,0.51969,0.97638,0.52756,0.97638,0.53543,0.97638,0.54331,0.97638,0.55118,0.97638,0.55906,0.97638,0.56693,0.97638,0.5748,0.97638,0.58268,0.97638,0.59055,0.97638,0.59843,0.97638,0.6063,0.97638,0.61417,0.97638,0.62205,0.97638,0.62992,0.97638,0.6378,0.97638,0.64567,0.97638,0.65354,0.97638,0.66142,0.97638,0.66929,0.97638,0.67717,0.97638,0.68504,0.97638,0.69291,0.97638,0.70079,0.97638,0.70866,0.97638,0.71654,0.97638,0.72441,0.97638,0.73228,0.97638,0.74016,0.97638,0.74803,0.97638,0.75591,0.97638,0.76378,0.97638,0.77165,0.97638,0.77953,0.97638,0.7874,0.97638,0.79528,0.97638,0.80315,0.97638,0.81102,0.97638,0.8189,0.97638,0.82677,0.97638,0.83465,0.97638,0.84252,0.97638,0.85039,0.97638,0.85827,0.97638,0.86614,0.97638,0.87402,0.97638,0.88189,0.97638,0.88976,0.97638,0.89764,0.97638,0.90551,0.97638,0.91339,0.97638,0.92126,0.97638,0.92913,0.97638,0.93701,0.97638,0.94488,0.97638,0.95276,0.97638,0.96063,0.97638,0.9685,0.97638,0.97638,0.97638,0.98425,0.97638,0.99213,0.97638,0.99609,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_161()
		{
			double[] value = {0.00391,0.98425,0.00787,0.98425,0.01575,0.98425,0.02362,0.98425,0.0315,0.98425,0.03937,0.98425,0.04724,0.98425,0.05512,0.98425,0.06299,0.98425,0.07087,0.98425,0.07874,0.98425,0.08661,0.98425,0.09449,0.98425,0.10236,0.98425,0.11024,0.98425,0.11811,0.98425,0.12598,0.98425,0.13386,0.98425,0.14173,0.98425,0.14961,0.98425,0.15748,0.98425,0.16535,0.98425,0.17323,0.98425,0.1811,0.98425,0.18898,0.98425,0.19685,0.98425,0.20472,0.98425,0.2126,0.98425,0.22047,0.98425,0.22835,0.98425,0.23622,0.98425,0.24409,0.98425,0.25197,0.98425,0.25984,0.98425,0.26772,0.98425,0.27559,0.98425,0.28346,0.98425,0.29134,0.98425,0.29921,0.98425,0.30709,0.98425,0.31496,0.98425,0.32283,0.98425,0.33071,0.98425,0.33858,0.98425,0.34646,0.98425,0.35433,0.98425,0.3622,0.98425,0.37008,0.98425,0.37795,0.98425,0.38583,0.98425,0.3937,0.98425,0.40157,0.98425,0.40945,0.98425,0.41732,0.98425,0.4252,0.98425,0.43307,0.98425,0.44094,0.98425,0.44882,0.98425,0.45669,0.98425,0.46457,0.98425,0.47244,0.98425,0.48031,0.98425,0.48819,0.98425,0.49606,0.98425,0.50394,0.98425,0.51181,0.98425,0.51969,0.98425,0.52756,0.98425,0.53543,0.98425,0.54331,0.98425,0.55118,0.98425,0.55906,0.98425,0.56693,0.98425,0.5748,0.98425,0.58268,0.98425,0.59055,0.98425,0.59843,0.98425,0.6063,0.98425,0.61417,0.98425,0.62205,0.98425,0.62992,0.98425,0.6378,0.98425,0.64567,0.98425,0.65354,0.98425,0.66142,0.98425,0.66929,0.98425,0.67717,0.98425,0.68504,0.98425,0.69291,0.98425,0.70079,0.98425,0.70866,0.98425,0.71654,0.98425,0.72441,0.98425,0.73228,0.98425,0.74016,0.98425,0.74803,0.98425,0.75591,0.98425,0.76378,0.98425,0.77165,0.98425,0.77953,0.98425};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_162()
		{
			double[] value = {0.7874,0.98425,0.79528,0.98425,0.80315,0.98425,0.81102,0.98425,0.8189,0.98425,0.82677,0.98425,0.83465,0.98425,0.84252,0.98425,0.85039,0.98425,0.85827,0.98425,0.86614,0.98425,0.87402,0.98425,0.88189,0.98425,0.88976,0.98425,0.89764,0.98425,0.90551,0.98425,0.91339,0.98425,0.92126,0.98425,0.92913,0.98425,0.93701,0.98425,0.94488,0.98425,0.95276,0.98425,0.96063,0.98425,0.9685,0.98425,0.97638,0.98425,0.98425,0.98425,0.99213,0.98425,0.99609,0.98425,0.00391,0.99213,0.00787,0.99213,0.01575,0.99213,0.02362,0.99213,0.0315,0.99213,0.03937,0.99213,0.04724,0.99213,0.05512,0.99213,0.06299,0.99213,0.07087,0.99213,0.07874,0.99213,0.08661,0.99213,0.09449,0.99213,0.10236,0.99213,0.11024,0.99213,0.11811,0.99213,0.12598,0.99213,0.13386,0.99213,0.14173,0.99213,0.14961,0.99213,0.15748,0.99213,0.16535,0.99213,0.17323,0.99213,0.1811,0.99213,0.18898,0.99213,0.19685,0.99213,0.20472,0.99213,0.2126,0.99213,0.22047,0.99213,0.22835,0.99213,0.23622,0.99213,0.24409,0.99213,0.25197,0.99213,0.25984,0.99213,0.26772,0.99213,0.27559,0.99213,0.28346,0.99213,0.29134,0.99213,0.29921,0.99213,0.30709,0.99213,0.31496,0.99213,0.32283,0.99213,0.33071,0.99213,0.33858,0.99213,0.34646,0.99213,0.35433,0.99213,0.3622,0.99213,0.37008,0.99213,0.37795,0.99213,0.38583,0.99213,0.3937,0.99213,0.40157,0.99213,0.40945,0.99213,0.41732,0.99213,0.4252,0.99213,0.43307,0.99213,0.44094,0.99213,0.44882,0.99213,0.45669,0.99213,0.46457,0.99213,0.47244,0.99213,0.48031,0.99213,0.48819,0.99213,0.49606,0.99213,0.50394,0.99213,0.51181,0.99213,0.51969,0.99213,0.52756,0.99213,0.53543,0.99213,0.54331,0.99213,0.55118,0.99213,0.55906,0.99213};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_163()
		{
			double[] value = {0.56693,0.99213,0.5748,0.99213,0.58268,0.99213,0.59055,0.99213,0.59843,0.99213,0.6063,0.99213,0.61417,0.99213,0.62205,0.99213,0.62992,0.99213,0.6378,0.99213,0.64567,0.99213,0.65354,0.99213,0.66142,0.99213,0.66929,0.99213,0.67717,0.99213,0.68504,0.99213,0.69291,0.99213,0.70079,0.99213,0.70866,0.99213,0.71654,0.99213,0.72441,0.99213,0.73228,0.99213,0.74016,0.99213,0.74803,0.99213,0.75591,0.99213,0.76378,0.99213,0.77165,0.99213,0.77953,0.99213,0.7874,0.99213,0.79528,0.99213,0.80315,0.99213,0.81102,0.99213,0.8189,0.99213,0.82677,0.99213,0.83465,0.99213,0.84252,0.99213,0.85039,0.99213,0.85827,0.99213,0.86614,0.99213,0.87402,0.99213,0.88189,0.99213,0.88976,0.99213,0.89764,0.99213,0.90551,0.99213,0.91339,0.99213,0.92126,0.99213,0.92913,0.99213,0.93701,0.99213,0.94488,0.99213,0.95276,0.99213,0.96063,0.99213,0.9685,0.99213,0.97638,0.99213,0.98425,0.99213,0.99213,0.99213,0.99609,0.99213,0.00391,0.99609,0.00787,0.99609,0.01575,0.99609,0.02362,0.99609,0.0315,0.99609,0.03937,0.99609,0.04724,0.99609,0.05512,0.99609,0.06299,0.99609,0.07087,0.99609,0.07874,0.99609,0.08661,0.99609,0.09449,0.99609,0.10236,0.99609,0.11024,0.99609,0.11811,0.99609,0.12598,0.99609,0.13386,0.99609,0.14173,0.99609,0.14961,0.99609,0.15748,0.99609,0.16535,0.99609,0.17323,0.99609,0.1811,0.99609,0.18898,0.99609,0.19685,0.99609,0.20472,0.99609,0.2126,0.99609,0.22047,0.99609,0.22835,0.99609,0.23622,0.99609,0.24409,0.99609,0.25197,0.99609,0.25984,0.99609,0.26772,0.99609,0.27559,0.99609,0.28346,0.99609,0.29134,0.99609,0.29921,0.99609,0.30709,0.99609,0.31496,0.99609,0.32283,0.99609,0.33071,0.99609,0.33858,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_164()
		{
			double[] value = {0.34646,0.99609,0.35433,0.99609,0.3622,0.99609,0.37008,0.99609,0.37795,0.99609,0.38583,0.99609,0.3937,0.99609,0.40157,0.99609,0.40945,0.99609,0.41732,0.99609,0.4252,0.99609,0.43307,0.99609,0.44094,0.99609,0.44882,0.99609,0.45669,0.99609,0.46457,0.99609,0.47244,0.99609,0.48031,0.99609,0.48819,0.99609,0.49606,0.99609,0.50394,0.99609,0.51181,0.99609,0.51969,0.99609,0.52756,0.99609,0.53543,0.99609,0.54331,0.99609,0.55118,0.99609,0.55906,0.99609,0.56693,0.99609,0.5748,0.99609,0.58268,0.99609,0.59055,0.99609,0.59843,0.99609,0.6063,0.99609,0.61417,0.99609,0.62205,0.99609,0.62992,0.99609,0.6378,0.99609,0.64567,0.99609,0.65354,0.99609,0.66142,0.99609,0.66929,0.99609,0.67717,0.99609,0.68504,0.99609,0.69291,0.99609,0.70079,0.99609,0.70866,0.99609,0.71654,0.99609,0.72441,0.99609,0.73228,0.99609,0.74016,0.99609,0.74803,0.99609,0.75591,0.99609,0.76378,0.99609,0.77165,0.99609,0.77953,0.99609,0.7874,0.99609,0.79528,0.99609,0.80315,0.99609,0.81102,0.99609,0.8189,0.99609,0.82677,0.99609,0.83465,0.99609,0.84252,0.99609,0.85039,0.99609,0.85827,0.99609,0.86614,0.99609,0.87402,0.99609,0.88189,0.99609,0.88976,0.99609,0.89764,0.99609,0.90551,0.99609,0.91339,0.99609,0.92126,0.99609,0.92913,0.99609,0.93701,0.99609,0.94488,0.99609,0.95276,0.99609,0.96063,0.99609,0.9685,0.99609,0.97638,0.99609,0.98425,0.99609,0.99213,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 16384 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_42()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_43()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_44()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_45()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_46()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_47()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_48()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_49()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_50()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_51()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_52()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_53()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_54()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_55()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_56()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_57()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_58()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_59()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_60()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_61()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_62()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_63()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_64()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_65()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_66()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_67()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_68()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_69()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_70()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_71()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_72()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_73()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_74()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_75()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_76()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_77()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_78()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_79()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_80()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_81()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_82()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_83()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_84()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_85()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_86()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_87()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_88()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_89()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_90()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_91()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_92()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_93()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_94()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_95()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_96()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_97()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_98()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_99()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_100()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_101()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_102()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_103()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_104()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_105()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_106()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_107()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_108()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_109()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_110()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_111()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_112()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_113()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_114()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_115()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_116()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_117()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_118()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_119()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_120()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_121()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_122()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_123()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_124()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_125()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_126()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_127()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_128()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_129()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_130()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_131()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_132()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_133()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_134()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_135()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_136()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_137()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_138()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_139()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_140()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_141()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_142()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_143()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_144()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_145()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_146()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_147()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_148()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_149()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_150()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_151()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_152()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_153()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_154()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_155()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_156()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_157()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_158()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_159()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_160()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_161()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_162()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_163()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_164()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 32768 total numbers made up of 16384 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_42()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_43()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_44()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_45()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_46()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_47()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_48()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_49()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_50()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_51()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_52()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_53()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_54()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_55()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_56()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_57()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_58()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_59()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_60()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_61()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_62()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_63()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_64()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_65()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_66()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_67()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_68()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_69()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_70()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_71()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_72()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_73()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_74()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_75()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_76()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_77()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_78()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_79()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_80()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_81()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_82()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_83()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_84()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_85()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_86()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_87()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_88()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_89()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_90()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_91()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_92()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_93()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_94()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_95()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_96()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_97()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_98()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_99()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_100()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_101()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_102()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_103()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_104()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_105()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_106()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_107()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_108()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_109()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_110()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_111()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_112()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_113()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_114()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_115()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_116()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_117()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_118()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_119()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_120()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_121()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_122()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_123()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_124()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_125()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_126()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_127()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_128()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_129()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_130()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_131()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_132()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_133()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_134()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_135()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_136()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_137()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_138()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_139()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_140()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_141()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_142()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_143()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_144()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_145()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_146()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_147()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_148()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_149()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_150()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_151()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_152()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_153()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_154()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_155()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_156()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_157()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_158()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_159()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_160()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_161()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_162()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_163()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_164()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD023 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD023().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD023\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD023 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD023_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD023_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD023_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD023_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
