package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD022Index.html" target="_blank">MarsLOD022</a>,  source <a href="../../../Geospatial/MarsLOD022.java">MarsLOD022.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD022.x3d">MarsLOD022.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD022.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD022.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD022
{
	/** Default constructor to create this object. */
	public MarsLOD022 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD022.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD022.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD022.x3d"))
    .addChild(new GeoLOD().setCenter(44.940476,134.940476,21025.000000).setRange(1.8E7).setChild1Url(new String[] {"MarsLOD023.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD023.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars007.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars007.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,90.000000,0.000000).setSolid(false).setXDimension(64).setXSpacing(1.428571).setYScale(50.0).setZDimension(64).setZSpacing(1.428571).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {138.16336,327.78622,531.3893,285.44058,595.7413,655.81433,823.8323,413.4699,55.197727,234.05153,100.6901,-592.1725,-690.6465,-694.74194,-623.71747,-442.74185,-2.899528,126.97329,333.21686,453.13956,482.59622,915.5916,1122.8446,771.5239,405.4048,-153.73602,-642.964,-924.1827,-1173.0372,-1697.054,-2147.798,-2287.9958,-2568.0227,-2477.617,-2446.0208,-2468.2551,-2621.1575,-2611.2644,-2405.4465,-2108.4915,-2217.1208,-2457.7478,-2551.1692,-2356.4392,-2002.0121,-2038.209,-2286.4478,-2631.7605,-2728.481,-2802.9468,-2824.184,-2876.1746,-2900.5015,-2909.994,-2942.307,-2979.8193,-3005.235,-3002.4363,-2975.351,-2942.8364,-2932.7097,-2871.911,-2685.2139,-2539.6975,-932.4225,-555.863,-107.00338,335.32645,145.82643,-81.82308,294.47855,549.7826,-40.44179,-699.97534,-638.1719,-842.0213,-837.75995,-791.84973,-762.00476,-202.1271,-35.429806,-30.703066,442.85175,424.07776,313.5766,631.387,352.3374,-207.00331,-909.9643,-1796.0049,-1745.0933,-1788.708,-1588.5087,-1765.3761,-2256.1719,-2519.0723,-2422.3132,-2505.8997,-2632.7673,-2688.7922};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {-2532.3213,-2459.866,-2471.8433,-2477.792,-2662.0955,-2644.998,-2583.557,-2412.8376,-2342.9062,-2204.4104,-2516.8237,-2699.6985,-2769.4104,-2798.2964,-2826.7869,-2869.9104,-2907.4756,-2926.6538,-2940.3435,-2965.2178,-2978.0552,-2985.123,-3001.253,-3018.2935,-3026.0012,-2980.7341,-2896.8728,-2863.4685,-2114.6106,-1750.9097,-1067.6068,-483.36465,-229.56725,-180.40215,-334.93063,-302.5021,-397.24435,-680.7084,-1138.1357,-965.59454,-1005.4039,-881.44763,-561.61676,-233.88583,-217.06686,79.5846,288.7703,390.5903,664.91315,833.15875,51.7624,-1837.7599,-1894.9388,-1736.2479,-1543.6251,-1715.3381,-1722.2812,-2046.2319,-2328.067,-2513.0276,-2549.3555,-2633.3472,-2680.0015,-2643.4136,-2429.5352,-2555.2913,-2649.6814,-2672.5696,-2692.6262,-2702.0293,-2660.129,-2521.399,-2273.0308,-2478.453,-2687.8525,-2727.2178,-2780.8933,-2793.4653,-2790.7397,-2941.1602,-2867.9077,-2890.1484,-2936.9402,-2946.6753,-2947.5344,-2961.9895,-2908.7578,-3007.2932,-3027.1265,-3046.6926,-3056.0967,-3077.9067,-3509.5657,-3093.4844,-2354.8916,-1360.3159,-963.4307,-991.3011,-280.40366,-676.69385};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {-761.0371,-1077.9285,-1351.3926,-1091.7953,-1048.297,-782.2466,-579.22723,-310.09445,-182.96043,-72.59847,215.78003,504.73575,818.6818,673.463,-611.5644,-1485.0955,-1615.8418,-1713.7339,-1778.2091,-1791.3555,-1971.4171,-2138.8125,-2323.455,-2552.7942,-2640.5918,-2660.1477,-2706.8125,-2692.3154,-2650.0457,-2633.3738,-2641.7244,-2690.6765,-2712.753,-2713.9404,-2760.041,-2689.2322,-2690.5698,-2687.8477,-2692.8452,-2724.1084,-2769.9377,-2769.8147,-2710.1414,-2905.816,-2856.988,-2887.594,-2907.575,-2927.1777,-2932.0625,-2868.1653,-2861.2407,-3010.9026,-3026.1663,-3044.5273,-3062.2913,-3088.9302,-3797.7979,-3699.2588,-3590.8274,-3866.4678,-2122.5483,-1426.6172,-1213.0583,-1183.1959,-1259.3976,-1455.5562,-1358.5591,-1188.0156,-960.13684,-973.40576,-361.08063,-166.50455,57.891674,4.07339,55.105965,425.6037,871.0099,210.32779,-1368.5729,-1773.9956,-1773.2681,-1932.5459,-2040.2915,-2121.5474,-2263.5977,-2323.4941,-2471.1667,-2595.9578,-2689.7617,-2708.2197,-2716.756,-2740.993,-2717.323,-2671.6184,-2663.215,-2720.1167,-2705.1055,-2718.0383,-2722.1052,-2718.8552};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {-2712.9915,-2693.8267,-2674.2395,-2709.239,-2734.2014,-2733.5999,-2697.55,-2761.9348,-2820.0718,-2845.0256,-2867.2554,-2894.3977,-2917.851,-2915.0007,-2978.4973,-3009.952,-3033.2456,-3047.817,-3065.4373,-3089.1067,-3800.5251,-3787.37,-3718.094,-3472.0063,-2970.9058,-2113.5583,-1754.054,-1604.8435,-1667.3301,-1529.4385,-1301.0605,-924.40094,-613.13806,-312.88422,-16.840157,245.90639,172.4802,-344.884,-418.16357,-202.1052,167.61374,-275.95258,-1363.5153,-1858.1719,-2055.1511,-2105.419,-2214.5938,-2471.2437,-2486.6274,-2516.5845,-2568.6882,-2688.9585,-2730.635,-2680.6555,-2741.639,-2745.8816,-2684.0864,-2715.3745,-2680.202,-2666.8774,-2656.5437,-2689.1514,-2725.67,-2720.44,-2516.8105,-2678.2766,-2666.0261,-2669.2014,-2669.0508,-2673.931,-2646.0046,-2702.2808,-2695.4092,-2784.6511,-2826.4724,-2874.311,-2866.201,-2903.6216,-2970.3708,-3007.965,-3038.0059,-3059.1978,-3073.131,-3094.426,-3801.382,-3783.654,-3734.0728,-3686.9485,-3483.7268,-3037.923,-2555.593,-2299.057,-1995.5953,-2140.4294,-1428.2405,-958.5748,-489.59943,-578.6886,-449.2858,-163.73604};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-497.1989,-1099.6636,-987.83,-656.1446,-599.27106,-1088.6143,-1770.3616,-2146.9185,-2332.956,-2414.077,-2366.4153,-2537.9841,-2697.6016,-2784.509,-2704.0164,-2688.142,-2698.2173,-2639.3962,-2693.828,-2654.7463,-2602.5918,-2681.2678,-2591.666,-2543.468,-2491.7336,-2609.9895,-2696.5076,-2705.2747,-2652.837,-2601.1455,-2598.9988,-2602.231,-2525.177,-2534.241,-2592.4683,-2647.0725,-2713.5852,-2758.5745,-2826.216,-2871.6875,-2912.8735,-2956.91,-2951.9983,-2955.8274,-3029.9067,-3063.1958,-3083.5127,-3105.1755,-3755.3677,-3736.815,-3737.4648,-3665.761,-3560.8618,-3232.9688,-2823.761,-2401.3926,-1786.7699,-1407.627,-1204.5597,-979.6217,-570.0989,-485.79178,-552.5841,-761.9382,-1153.7325,-1497.484,-1691.8408,-1670.7852,-1733.7081,-1919.5605,-2137.6543,-2378.5405,-2548.6008,-2754.832,-2666.6177,-2433.5066,-2525.2417,-2632.469,-2669.225,-2734.0398,-2762.8784,-2598.0479,-2493.4878,-2545.6497,-2426.5632,-2446.329,-2350.0269,-2272.2605,-2347.5474,-2395.7534,-2488.7754,-2700.5461,-2498.334,-2451.9001,-2455.7317,-2490.9875,-2449.8206,-2328.11,-2338.391,-2575.216};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {-2697.46,-2706.6572,-2735.8037,-2816.6755,-2782.7642,-2779.27,-2912.1477,-3002.2473,-3040.3696,-3014.3777,-3016.9224,-3113.768,-3745.2788,-3747.2622,-3732.4636,-3690.237,-3645.6565,-3416.1592,-3026.8738,-2459.0876,-2166.127,-1638.3401,-1435.5851,-1386.7772,-1273.3398,-1345.7196,-1323.7649,-1726.6526,-1920.039,-2057.1511,-2175.7317,-2228.4736,-2295.8748,-2369.3032,-2464.3396,-2641.915,-2773.515,-2963.4812,-3048.98,-3014.7441,-2905.5134,-2902.7349,-2848.973,-2849.2236,-2821.8176,-2620.7676,-2407.829,-2289.5037,-2135.2542,-2008.148,-1905.9412,-1975.4642,-2019.2056,-2051.9292,-2117.759,-2210.3303,-2249.5935,-2295.1675,-2284.8162,-2311.8313,-2313.535,-2318.1616,-1966.202,-1776.7169,-2484.667,-2630.6606,-2645.412,-2716.8809,-2737.512,-2712.4058,-2850.1719,-3010.9866,-3027.0159,-2777.541,-2785.6023,-2905.2559,-3782.981,-3752.2356,-3728.9482,-3707.5476,-3643.316,-3468.85,-3110.3325,-2889.009,-2566.567,-2055.29,-2035.028,-1963.6501,-2006.163,-2025.8448,-2092.6548,-2178.9358,-2156.5525,-2228.517,-2520.4578,-2421.8564,-2604.248,-2739.637,-2819.2231,-2870.4326};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {-3024.504,-3144.66,-3242.0657,-3322.105,-3287.0762,-3085.8494,-3021.1094,-2963.402,-2799.4795,-2544.2312,-2196.192,-1936.193,-1586.6066,-1774.8401,-1366.866,-1390.428,-1491.9055,-1601.8513,-1750.4484,-1845.5493,-2061.6536,-2057.422,-2115.9216,-2138.6301,-2158.68,-2214.277,-2196.8943,-1575.6555,-2045.9913,-2396.0469,-2601.7502,-2679.3699,-2741.2507,-2819.3882,-2847.3145,-2977.0786,-3011.92,-2638.0994,-2645.4111,-2963.6907,-3717.1338,-3687.4463,-3666.315,-3654.0276,-3610.7827,-3469.9058,-3173.011,-2830.2856,-2668.1514,-2524.857,-2402.7976,-2240.3357,-2205.4434,-2316.7092,-2269.8557,-2375.3906,-2336.097,-2435.4382,-2609.8213,-2698.4226,-2898.0996,-3010.4563,-3089.5444,-3158.2073,-3208.1567,-3252.9998,-3330.9167,-3360.615,-3373.1562,-3307.1367,-3128.5776,-3019.937,-2757.266,-2309.6077,-1982.0547,-1553.6361,-1169.7212,-839.01904,-711.9193,-658.65594,-808.68024,-980.79236,-1190.6178,-1464.002,-1797.3306,-1851.8145,-1940.1735,-2008.2924,-2036.5292,-2082.7346,-2143.6682,-2144.486,-2142.9922,-2027.5862,-2521.5603,-2679.206,-2733.5483,-2708.517,-2673.337,-2815.9949};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {-2978.6685,-2936.1836,-2707.2837,-3506.1802,-3684.5703,-3694.674,-3667.4639,-3633.9702,-3595.0789,-3471.4934,-3228.7107,-2956.281,-2806.3252,-2731.9126,-2618.8157,-2521.694,-2465.0347,-2506.012,-2475.3484,-2478.0537,-2610.1519,-2779.5361,-2868.3862,-3027.6133,-3159.8003,-3175.1958,-3242.9834,-3273.7317,-3303.9634,-3329.4548,-3412.8804,-3454.5884,-3434.4468,-3436.2734,-3333.0564,-3040.0684,-2709.6687,-2172.798,-1700.9827,-1318.4192,-840.54285,-496.207,-256.38782,-54.087784,-30.474686,-277.43304,-485.48224,-1047.0249,-1535.0469,-1680.2932,-1802.9142,-1830.2461,-1851.1533,-1945.9989,-2044.1182,-2158.019,-2293.4922,-2392.1438,-2465.7332,-2564.8152,-2451.3386,-2713.865,-2799.7478,-2919.208,-3000.4885,-2979.3298,-2735.014,-3483.4473,-3664.1655,-3667.972,-3646.073,-3593.8635,-3540.61,-3427.73,-3306.803,-3134.6716,-3059.5173,-2999.5974,-3007.195,-2922.8406,-2885.513,-2908.8945,-2916.049,-2975.5498,-3047.8855,-3130.0146,-3191.6274,-3241.9116,-3303.054,-3360.108,-3403.2654,-3409.3706,-3460.3645,-3480.6252,-3533.3174,-3537.7698,-3503.2483,-3516.0684,-3461.4844,-3141.6655};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-2677.7368,-2199.154,-1619.4923,-976.60345,-481.9485,-96.90266,241.53844,468.1097,577.971,454.8979,115.18193,-514.6215,-1359.1746,-1528.6426,-1612.43,-1618.518,-1667.2231,-1786.493,-1929.6786,-2017.4072,-2214.494,-2358.9412,-2500.5676,-2573.0554,-2535.8477,-2398.6367,-2753.6555,-3024.2554,-3122.3425,-2987.5461,-2864.1218,-3302.0369,-3624.691,-3584.908,-3592.4104,-3557.053,-3526.857,-3421.004,-3381.1008,-3316.6921,-3294.6443,-3268.2412,-3323.6685,-3318.4036,-3272.656,-3304.956,-3327.95,-3309.4656,-3311.7017,-3397.7874,-3406.0776,-3435.5847,-3507.0562,-3530.8713,-3571.3208,-3539.0012,-3561.8843,-3574.9617,-3607.8044,-3626.5945,-3604.266,-3547.4202,-3527.5332,-3237.339,-2715.8164,-2084.1,-1391.5122,-705.8324,-29.47779,486.48074,783.25073,950.6637,895.26984,674.8353,720.547,1617.8873,-826.3917,-1262.5226,-1361.3,-1457.6447,-1561.113,-1667.626,-1794.9137,-1953.2311,-2150.5376,-2320.5203,-2455.8955,-2557.018,-2631.4287,-2628.0798,-2693.584,-2857.0518,-3110.1223,-3114.514,-3046.48,-3113.3264,-3587.6401,-3546.3877,-3539.118,-3533.6794};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-3519.357,-3476.296,-3456.4023,-3469.982,-3431.4326,-3462.662,-3467.9812,-3533.3945,-3506.104,-3503.8726,-3512.8416,-3509.744,-3522.9856,-3611.1082,-3602.0015,-3615.729,-3660.5393,-3623.2217,-3648.8486,-3637.0657,-3652.7861,-3660.6633,-3645.4395,-3699.4277,-3716.4148,-3674.1206,-3578.6235,-3300.0728,-2728.221,-1984.8087,-1155.3927,-296.8103,482.61646,1005.9912,1220.4067,1279.1183,1182.2959,855.05945,629.7516,1231.3585,-462.71478,-910.9366,-1122.9414,-1284.9471,-1406.9036,-1570.5237,-1791.1796,-1987.9774,-2199.3909,-2306.5447,-2461.6975,-2565.0925,-2645.3843,-2795.9365,-2874.3047,-2747.7522,-3040.5405,-3170.5686,-3112.5967,-3155.6636,-3433.065,-3468.2317,-3475.7961,-3521.4312,-3511.552,-3471.9587,-3499.6667,-3493.0593,-3548.1614,-3614.9177,-3603.6868,-3641.2158,-3629.4824,-3652.8389,-3651.467,-3676.2078,-3679.69,-3733.973,-3734.8706,-3735.775,-3763.398,-3727.9092,-3755.054,-3759.279,-3759.105,-3770.266,-3735.0967,-3766.8503,-3792.3145,-3786.745,-3724.866,-3511.829,-2990.86,-1992.9222,-966.2743,22.720688,849.17615,1211.604,1333.2053,1378.7577};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {1484.5039,1412.8779,1014.3188,423.026,-183.57141,-613.2212,-885.97406,-1111.5111,-1302.0002,-1528.0881,-1788.2783,-2021.5901,-2145.126,-2294.8486,-2458.4905,-2531.2104,-2712.1714,-2821.808,-2951.5132,-2784.6914,-3018.4907,-3205.858,-3178.1147,-3257.0088,-3255.893,-3357.3245,-3435.244,-3503.992,-3502.5059,-3536.2922,-3552.4316,-3577.041,-3661.0144,-3720.0757,-3738.298,-3716.583,-3752.1526,-3782.7449,-3790.265,-3829.405,-3833.427,-3885.272,-3894.8188,-3911.3901,-3934.633,-3912.7563,-3907.1465,-3906.305,-3895.1672,-3891.0647,-3894.472,-3876.6926,-3937.2512,-3888.4265,-3867.9065,-3719.6516,-3020.0867,-1918.2428,-792.22943,193.56659,1015.4905,938.1537,1354.8291,1353.6637,1858.6028,2347.1938,2034.1877,1205.8582,288.39322,-297.4649,-720.3826,-1059.1492,-1317.0286,-1540.3972,-1784.6069,-2024.691,-2183.0732,-2351.9233,-2520.5703,-2536.761,-2826.5425,-2893.5037,-2953.1938,-3066.929,-3161.5532,-3253.4287,-3143.906,-3433.77,-3232.7183,-3373.599,-3471.3071,-3522.9465,-3548.911,-3624.1348,-3673.2844,-3690.8052,-3729.3296,-3788.6228,-3817.3035,-3826.7676};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {-3869.1318,-3902.2625,-3951.126,-3993.3772,-4040.2744,-4064.336,-4104.0366,-4093.2693,-4083.023,-4081.783,-4053.0046,-4046.3723,-4053.3372,-4046.7695,-4028.955,-4014.6658,-4026.4287,-4003.021,-3945.5452,-3801.729,-3389.277,-2364.694,-1059.8008,143.80377,809.74335,1253.5642,1382.419,1782.5488,5454.1934,6171.9277,3323.7537,1753.9338,494.59647,-239.17812,-726.04083,-1048.3676,-1352.3489,-1583.9095,-1794.9204,-2029.0675,-2172.7373,-2350.9587,-2581.9731,-2695.4558,-2917.687,-2929.94,-2927.7036,-3121.2205,-3209.974,-3067.4514,-3109.792,-3401.886,-3327.0537,-3430.8962,-3524.3413,-3618.0042,-3679.1453,-3698.1418,-3743.8352,-3763.63,-3831.1692,-3887.1099,-3905.5173,-3960.5786,-4000.0898,-4047.778,-4139.458,-4164.022,-4218.5264,-4235.606,-4249.7544,-4219.693,-4224.986,-4214.0527,-4190.0537,-4187.5757,-4175.3784,-4174.4497,-4149.722,-4110.1997,-4070.709,-4023.293,-3972.0952,-3914.476,-3807.4004,-2992.1511,-1702.4755,-93.63694,722.7589,1203.5392,1455.2092,2338.9758,6467.9927,6897.7773,3567.4841,1826.1122,325.91205,-401.3232,-841.25684,-1161.6249};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {-1391.4075,-1635.7789,-1861.3378,-2078.7495,-2239.9526,-2418.0972,-2668.8232,-2821.6133,-2970.5037,-2971.4312,-3121.1797,-3181.156,-3229.6306,-3024.9446,-3329.7832,-3440.8325,-3425.706,-3556.5813,-3664.8267,-3711.8904,-3722.988,-3750.766,-3803.837,-3881.31,-3925.3467,-4002.6116,-4025.8499,-4096.5156,-4164.103,-4254.436,-4311.4263,-4308.08,-4364.149,-4375.5786,-4351.558,-4369.4023,-4310.6455,-4328.9717,-4337.071,-4306.5933,-4292.3,-4254.3066,-4206.6924,-4142.0654,-4081.8525,-4031.599,-3984.0027,-3924.2917,-3837.3118,-3521.0474,-2503.7354,-683.8707,382.05246,976.61115,1345.8285,2018.649,3059.589,3251.012,2496.7964,1216.5421,-267.2743,-740.00385,-1081.2943,-1298.7576,-1497.696,-1710.1387,-1936.6812,-2163.953,-2415.727,-2578.0554,-2689.9846,-2905.9126,-3080.554,-3144.4648,-3256.6265,-3250.7449,-3290.2715,-3336.3271,-3436.5464,-3484.5776,-3518.3303,-3649.9294,-3724.3718,-3767.7104,-3815.9836,-3858.0737,-3921.8188,-4020.7356,-4081.7974,-4143.006,-4177.8926,-4253.5786,-4332.8345,-4398.49,-4429.9375,-4477.384,-4483.4053,-4490.248,-4444.085,-4459.888};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {-4434.398,-4416.712,-4427.8193,-4390.847,-4340.182,-4283.616,-4217.8027,-4156.1504,-4124.648,-4076.539,-4008.5828,-3953.1707,-3912.9863,-3781.402,-3145.2322,-1662.4661,-523.92834,281.88617,755.44183,1343.2756,1750.7786,1757.0306,1274.2163,211.55745,-848.8225,-1121.1517,-1304.2183,-1441.0044,-1603.9901,-1791.9337,-2117.0679,-2299.0208,-2563.0571,-2719.3706,-2893.036,-3043.0735,-3219.1443,-3276.3137,-3361.3738,-3367.4146,-3402.8145,-3458.2495,-3518.279,-3579.2249,-3614.421,-3719.3672,-3781.0862,-3838.6335,-3912.6035,-3989.508,-4091.7285,-4163.5454,-4214.4214,-4292.9575,-4351.3257,-4420.7847,-4452.647,-4498.662,-4555.4453,-4601.8403,-4595.076,-4608.0776,-4531.442,-4576.644,-4570.003,-4484.8276,-4462.1143,-4427.489,-4390.3735,-4335.4487,-4270.7295,-4199.3247,-4204.3037,-4174.392,-4085.598,-4044.6653,-3976.9604,-3804.2744,-3442.3208,-2383.7695,-1393.0547,-544.55347,-42.492626,370.3619,553.9474,417.86484,-222.05548,-925.9685,-1317.8984,-1416.1692,-1485.2363,-1571.8014,-1730.8689,-1852.8787,-1988.3696,-2366.4753,-2596.7654,-2887.639,-3108.2244,-3224.2068};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {-3368.9097,-3433.1907,-3426.2844,-3503.3892,-3497.7974,-3579.4163,-3652.3975,-3677.0085,-3689.9656,-3745.9448,-3834.042,-3908.1746,-4028.1226,-4133.809,-4215.3306,-4292.3003,-4343.393,-4411.8813,-4459.552,-4502.9307,-4548.7954,-4616.2056,-4650.7734,-4692.844,-4687.0073,-4677.9624,-4637.926,-4623.213,-4606.4375,-4525.884,-4477.9165,-4445.3027,-4432.349,-4373.214,-4309.2227,-4274.6665,-4260.855,-4219.894,-4183.0967,-4121.3345,-4061.6448,-3929.5647,-3833.3481,-3305.707,-2416.4314,-1683.1826,-1366.0739,-1052.668,-941.8695,-1039.2239,-790.17285,271.56302,-1370.0681,-1744.2433,-1738.3892,-1793.0094,-1902.4849,-2027.4043,-1925.4911,-2003.0869,-3229.5938,-3238.0352,-3273.2754,-3039.5884,-3486.7288,-3504.3044,-3428.097,-3601.5354,-3619.072,-3704.1597,-3762.8438,-3806.8718,-3724.9119,-3811.8416,-3905.302,-4023.3716,-4144.075,-4246.706,-4297.906,-4375.582,-4460.0845,-4511.7744,-4565.8755,-4615.745,-4658.605,-4713.132,-4764.847,-4733.526,-4708.5967,-4696.491,-4680.193,-4651.4375,-4598.9653,-4528.3003,-4512.4507,-4507.8613,-4492.5566,-4434.3926,-4369.251,-4316.675};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {-4267.8066,-4307.9644,-4295.957,-4237.3555,-4170.6636,-4088.058,-4041.7048,-3867.2957,-3505.4756,-3107.974,-2846.311,-2620.504,-2451.7856,-2254.902,-997.77246,1589.4584,-1576.6942,-2255.6616,-2090.8767,-2078.1782,-2156.5598,-2234.8574,-2254.0115,-1856.1138,-2988.8098,-3364.6763,-3468.6838,-3396.321,-3597.7297,-3633.1301,-3449.125,-3475.532,-3753.409,-3816.8035,-3856.6267,-3888.7844,-3805.4185,-3920.8296,-4020.4258,-4110.705,-4220.939,-4313.1743,-4405.7,-4469.0024,-4534.615,-4566.161,-4641.91,-4688.4434,-4761.9707,-4805.378,-4841.2324,-4778.2637,-4723.134,-4710.825,-4702.5312,-4684.1353,-4639.93,-4557.5103,-4579.512,-4543.044,-4493.024,-4470.363,-4416.925,-4353.747,-4316.6294,-4368.879,-4361.0063,-4300.5127,-4247.3057,-4185.733,-4178.876,-4099.76,-3997.4265,-3805.7253,-3786.088,-3740.2153,-3651.8538,-3587.527,-3589.0603,-3106.3752,-3257.629,-2860.2483,-2532.4016,-2445.6128,-2438.6921,-2477.2297,-2569.3774,-2312.3394,-2840.7878,-3281.885,-3551.3528,-3635.1829,-3681.7893,-3725.779,-3727.9631,-3772.0208,-3829.715,-3909.394,-3944.3696,-3988.3735};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {-3863.8818,-3979.4663,-4092.801,-4221.6704,-4325.091,-4411.7466,-4491.6836,-4557.14,-4574.649,-4645.4214,-4720.387,-4775.1377,-4822.932,-4880.813,-4897.386,-4890.891,-4812.3022,-4792.386,-4801.6953,-4762.132,-4706.189,-4660.3853,-4637.0747,-4608.715,-4539.8237,-4510.9463,-4453.384,-4394.2725,-4426.7524,-4444.8916,-4392.0215,-4317.5107,-4262.141,-4255.9033,-4247.3477,-4168.9653,-4077.449,-4005.6113,-3955.6682,-3915.5469,-3886.812,-3832.0107,-3749.7542,-3669.4028,-3508.5774,-3248.0366,-2948.1548,-2771.5474,-2685.5095,-2676.0056,-2739.1177,-2625.5166,-3015.0212,-2747.0737,-3625.3894,-3676.0151,-3700.2163,-3742.5808,-3784.162,-3846.8926,-3922.7322,-3956.1738,-4013.0125,-4051.1958,-3959.1365,-4087.5442,-4171.6045,-4274.328,-4359.648,-4444.231,-4562.166,-4621.7666,-4675.066,-4743.121,-4789.006,-4864.8535,-4892.9175,-4921.0684,-4938.184,-4952.834,-4912.8325,-4895.815,-4856.346,-4846.981,-4820.9688,-4752.0796,-4700.384,-4664.339,-4629.405,-4621.934,-4540.1035,-4492.05,-4582.381,-4573.176,-4501.154,-4391.932,-4317.3857,-4327.132,-4302.505,-4193.7505};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {-4127.0146,-4044.9983,-4007.5754,-3959.1084,-3883.5972,-3811.4573,-3706.8215,-3638.9346,-3543.3054,-3364.0986,-3166.318,-2989.0833,-2907.9297,-2895.844,-2937.163,-2677.534,-2776.7278,-2486.4885,-3669.465,-3732.7427,-3742.6904,-3789.3582,-3854.8108,-3955.8225,-3971.0972,-3966.242,-4054.013,-4058.5571,-4058.1804,-4140.878,-4217.9004,-4277.825,-4420.4766,-4509.3765,-4590.74,-4674.992,-4759.898,-4824.467,-4889.0283,-4931.3574,-4950.8604,-4970.5635,-4974.8257,-4983.2314,-4967.933,-4915.852,-4921.2466,-4910.56,-4885.558,-4855.9287,-4777.7544,-4728.422,-4690.073,-4646.4033,-4608.5776,-4576.0215,-4635.002,-4613.5244,-4554.127,-4471.334,-4383.7764,-4326.6855,-4264.486,-4227.305,-4153.857,-4111.6406,-4043.616,-3946.58,-3856.0044,-3798.4336,-3689.851,-3629.7275,-3581.7058,-3435.0962,-3338.988,-3203.391,-3158.9927,-3094.2832,-3130.8257,-3115.748,-2861.6658,-2182.3767,-3457.3398,-3761.1143,-3795.809,-3802.6636,-3878.9404,-3958.8567,-3980.36,-4007.4536,-4065.7585,-4068.3809,-4116.5327,-4204.94,-4286.6157,-4339.657,-4435.108,-4563.137,-4633.587,-4717.145};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {-4842.811,-4897.898,-4997.4644,-4994.9937,-4986.912,-4992.855,-4997.848,-5012.467,-4987.3975,-4945.416,-4964.035,-4972.218,-4961.8384,-4896.019,-4795.694,-4797.7344,-4751.23,-4709.336,-4690.4805,-4688.4033,-4663.7144,-4641.566,-4606.4263,-4533.458,-4455.0864,-4372.1655,-4301.178,-4240.1587,-4173.7935,-4129.971,-4043.0405,-3981.3037,-3875.946,-3755.0398,-3690.7178,-3668.96,-3597.9014,-3518.3394,-3435.778,-3379.2354,-3353.7942,-3296.5784,-3115.9614,-3010.5684,-2855.551,-2271.1697,-2758.7034,-3786.7207,-3804.7234,-3844.6926,-3896.2302,-3951.173,-3983.581,-4025.917,-4052.6116,-4059.173,-4187.852,-4257.625,-4343.118,-4413.5044,-4489.265,-4631.565,-4709.862,-4770.0366,-4852.4824,-4945.174,-4978.3687,-5002.142,-4998.368,-4996.949,-4994.002,-4981.754,-4981.5435,-4987.884,-4991.862,-5000.071,-4951.82,-4899.8633,-4946.742,-4833.925,-4840.6685,-4839.6333,-4817.5347,-4743.2744,-4685.4604,-4663.395,-4623.962,-4556.2646,-4510.0723,-4439.778,-4357.1387,-4274.895,-4188.5474,-4123.9136,-4024.7515,-3960.3833,-3890.3826,-3750.9607,-3676.5955,-3711.1477};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {-3663.218,-3608.234,-3532.1404,-3507.196,-3483.667,-3393.436,-2941.1497,-2712.6013,-2893.8723,-2766.021,-2622.4941,-3626.0806,-3774.6824,-3754.4404,-3875.967,-3928.0732,-3991.7573,-4021.8984,-4014.2932,-4056.9043,-4219.7095,-4299.5615,-4389.2812,-4466.3286,-4555.5156,-4639.336,-4727.2593,-4817.697,-4867.585,-4926.835,-4972.852,-4989.301,-4981.275,-4975.314,-4981.2227,-4961.8394,-4951.007,-4952.0376,-4947.9575,-4909.357,-4860.503,-4853.1294,-4852.025,-4858.8804,-4905.95,-4848.9688,-4796.686,-4743.6875,-4718.4106,-4670.7417,-4617.994,-4566.1313,-4527.089,-4442.563,-4340.7246,-4284.002,-4192.4146,-4105.6387,-4016.5837,-3920.0903,-3847.561,-3788.553,-3720.6724,-3719.5815,-3709.7014,-3650.722,-3621.1477,-3611.8638,-3592.4878,-3487.8472,-3139.495,-2763.2446,-2865.6682,-2600.6062,-2769.3054,-3554.881,-3807.0283,-3834.2087,-3851.5542,-3959.1536,-3991.8948,-4035.4102,-4024.4204,-4067.9958,-4251.5957,-4316.5356,-4384.076,-4427.179,-4568.801,-4693.008,-4765.5474,-4799.9756,-4862.2056,-4931.1504,-4984.478,-4934.9546,-4901.98,-4976.172,-4973.0493,-4946.592};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {-4936.233,-4935.0728,-4913.8506,-4834.0215,-4912.0527,-4810.086,-4835.001,-4841.7656,-4852.028,-4834.2173,-4803.4595,-4795.059,-4746.8315,-4676.881,-4595.1626,-4581.985,-4547.0728,-4432.37,-4347.114,-4279.2134,-4185.482,-4042.0405,-3980.5312,-3908.2805,-3812.326,-3791.22,-3759.0208,-3719.5103,-3701.1943,-3652.2607,-3689.3875,-3658.8884,-3618.8875,-3526.1533,-3360.5256,-3009.221,-2822.8232,-2473.6904,-3140.3384,-3636.8281,-3837.4607,-3878.16,-3886.2856,-3911.3975,-4022.996,-4030.545,-4052.6145,-4077.1814,-4310.8984,-4384.765,-4478.9634,-4568.3354,-4644.53,-4696.9,-4762.4185,-4811.8867,-4888.661,-4940.9546,-4979.598,-4967.291,-4963.837,-4979.272,-4964.737,-4916.0913,-4927.2236,-4939.5566,-4940.6216,-4926.688,-4911.6577,-4885.65,-4868.377,-4901.6265,-4919.322,-4886.424,-4814.991,-4763.3394,-4746.3745,-4722.101,-4682.086,-4605.2793,-4521.8633,-4400.2007,-4290.025,-4218.655,-4152.592,-4053.2827,-3936.417,-3875.4207,-3818.8855,-3781.6643,-3767.4514,-3771.789,-3754.9675,-3732.411,-3736.4373,-3711.67,-3702.938,-3669.464,-3598.022,-3433.033};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {-3193.9062,-2819.7576,-3340.3818,-3710.9788,-3802.8423,-3875.379,-3894.6707,-3894.9785,-4019.776,-4061.7727,-4078.289,-4098.4346,-4462.9126,-4504.8823,-4545.5366,-4604.2383,-4640.872,-4677.2573,-4740.5713,-4814.396,-4890.8794,-4952.7686,-4972.7783,-4971.3613,-4958.601,-4957.1084,-4954.535,-4936.0903,-4932.545,-4943.8164,-4922.281,-4890.96,-4945.044,-4943.34,-4928.454,-4919.3984,-4908.736,-4846.245,-4809.3315,-4842.426,-4807.5864,-4744.7236,-4676.4517,-4587.179,-4485.1787,-4363.694,-4299.556,-4160.551,-4074.1519,-4083.78,-4007.997,-3939.6125,-3889.0166,-3853.104,-3841.1255,-3805.6194,-3830.858,-3799.9536,-3779.9075,-3754.0435,-3751.9102,-3758.5374,-3746.6,-3639.8545,-3508.9878,-3372.7478,-3433.713,-3724.238,-3816.2417,-3888.3948,-3914.7405,-3929.0925,-3989.3127,-4059.296,-4065.6616,-4101.1367,-4562.5273,-4597.8584,-4544.78,-4588.2017,-4641.997,-4694.79,-4745.5527,-4798.6226,-4867.698,-4926.1626,-4959.5664,-4945.5566,-4938.757,-4942.6294,-4936.3237,-4936.705,-4932.382,-4943.685,-4915.333,-4896.141,-4920.776,-4941.0737,-4938.582,-4910.08};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {-4913.5317,-4867.5317,-4834.67,-4822.3384,-4798.0938,-4722.3438,-4584.1587,-4536.4517,-4461.68,-4383.7783,-4210.103,-4351.9033,-4129.0703,-3936.633,-4052.8916,-3994.6853,-3949.334,-3919.301,-3896.2825,-3881.5725,-3859.0488,-3864.6172,-3825.1003,-3838.1338,-3803.2559,-3807.5383,-3816.487,-3756.2695,-3719.401,-3648.814,-3487.1199,-3759.7197,-3917.434,-3899.6738,-3934.768,-3968.4421,-4004.034,-4093.7463,-4100.7134,-4114.001,-4476.683,-4526.145,-4523.784,-4556.676,-4590.4287,-4634.568,-4711.6846,-4781.6416,-4838.3486,-4876.5234,-4921.5312,-4935.8145,-4936.3276,-4929.527,-4923.596,-4923.51,-4921.5576,-4935.1377,-4922.2925,-4891.4917,-4885.126,-4886.1665,-4913.216,-4889.702,-4844.247,-4776.8833,-4768.33,-4728.325,-4692.448,-4628.402,-4548.1055,-4484.5474,-4385.384,-4345.2017,-4217.345,-4228.3506,-4053.8381,-3998.8892,-4074.0613,-4009.6943,-3964.1267,-3977.027,-3968.8674,-3937.5063,-3929.0771,-3924.5005,-3893.7104,-3895.6628,-3858.2312,-3860.2588,-3856.8992,-3805.9224,-3820.6387,-3627.4941,-3350.823,-3778.2432,-3963.1392,-3970.076,-3916.3376,-3869.9746};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {-4027.6064,-4132.2783,-4167.5166,-4130.456,-4344.747,-4423.3228,-4527.377,-4575.1426,-4596.79,-4656.977,-4713.9893,-4753.6484,-4793.1963,-4840.257,-4881.382,-4916.158,-4902.857,-4913.8374,-4914.4375,-4912.3604,-4903.155,-4923.272,-4923.0513,-4906.1196,-4839.8086,-4857.057,-4869.1196,-4845.953,-4713.452,-4750.2124,-4721.364,-4639.167,-4555.384,-4566.231,-4514.0474,-4439.7593,-4359.719,-4320.039,-4284.298,-4218.507,-4146.976,-4166.279,-4114.5674,-4069.1716,-4057.608,-4015.945,-4004.2349,-4000.5876,-4005.584,-3939.1626,-3954.9873,-3933.6765,-3900.061,-3903.392,-3887.864,-3837.0603,-3880.2122,-3815.3474,-3530.7104,-3878.3875,-3928.0898,-3914.7354,-3873.7832,-3973.7178,-4054.2498,-4136.774,-4173.6626,-4172.178,-4291.422,-4377.914,-4437.2993,-4527.2275,-4560.3364,-4613.5864,-4686.289,-4705.4634,-4716.032,-4751.005,-4790.593,-4814.4126,-4857.7124,-4864.328,-4877.929,-4878.183,-4822.823,-4848.736,-4894.506,-4865.649,-4821.5054,-4816.419,-4796.647,-4801.591,-4724.0444,-4680.431,-4645.2466,-4566.3013,-4507.3687,-4505.574,-4506.2847,-4471.769};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {-4406.195,-4344.137,-4268.3037,-4235.198,-4169.4497,-4169.084,-4134.529,-4111.184,-4070.8699,-4077.8838,-4054.0059,-4037.841,-4033.5522,-3992.7922,-3990.8198,-3971.6782,-3963.3225,-3905.186,-3865.5537,-3883.197,-3910.2144,-3894.1162,-3860.301,-3898.841,-3908.7383,-3920.312,-3924.2163,-4014.122,-4111.955,-4158.1694,-4196.7373,-4174.3975,-4255.242,-4334.0654,-4422.819,-4464.315,-4515.6064,-4537.4863,-4610.677,-4627.1953,-4644.345,-4688.483,-4708.8022,-4724.377,-4768.1763,-4786.9854,-4797.7505,-4812.567,-4801.2637,-4801.5454,-4806.3643,-4759.5156,-4749.2812,-4759.985,-4765.8594,-4722.4897,-4704.8794,-4633.3394,-4526.746,-4495.905,-4523.0283,-4477.9053,-4440.8755,-4460.6855,-4388.161,-4362.551,-4304.03,-4238.2676,-4197.1006,-4192.2183,-4156.4263,-4129.7754,-4109.2173,-4113.088,-4092.057,-4065.3474,-4027.2402,-4044.8252,-4031.4004,-3998.2275,-3963.8274,-3947.2964,-3929.3389,-3918.6829,-3908.1514,-3921.2686,-3917.5347,-3920.4216,-3928.3247,-4001.2234,-4017.6008,-4097.2485,-4129.919,-4174.4595,-4182.9023,-4204.997,-4244.4956,-4304.119,-4362.9746,-4419.2847};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {-4456.3027,-4471.907,-4516.766,-4542.734,-4571.289,-4599.7363,-4572.088,-4601.8057,-4648.7456,-4712.9805,-4716.2505,-4710.5317,-4707.899,-4726.956,-4717.2446,-4633.7065,-4616.281,-4660.7456,-4684.2173,-4619.644,-4591.399,-4590.4023,-4525.811,-4423.044,-4474.4087,-4486.7725,-4430.659,-4408.8984,-4404.6323,-4384.0684,-4329.746,-4246.498,-4207.8135,-4210.762,-4188.2036,-4172.988,-4132.2896,-4134.8423,-4097.6094,-4084.458,-4077.8992,-4044.7002,-4013.7788,-3992.772,-3984.3716,-3994.84,-4017.9258,-3972.9128,-3909.018,-3915.711,-3948.4185,-3942.631,-3995.181,-4003.835,-4057.0764,-4109.594,-4184.548,-4183.941,-4219.6177,-4242.049,-4176.636,-4241.8857,-4300.138,-4356.3403,-4390.9805,-4396.898,-4410.7217,-4412.7446,-4471.6,-4518.931,-4474.787,-4559.876,-4619.082,-4641.048,-4631.0024,-4617.2104,-4634.26,-4605.5176,-4616.3306,-4586.735,-4563.7344,-4544.856,-4604.6797,-4563.8755,-4543.4116,-4549.4673,-4528.016,-4495.9336,-4444.77,-4467.8223,-4455.032,-4412.835,-4428.186,-4404.6025,-4367.891,-4285.401,-4254.935,-4229.1504,-4213.6577,-4174.9375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-4153.9263,-4139.7495,-4101.807,-4094.701,-4080.3179,-4065.455,-4043.9102,-4011.1765,-3987.1208,-4004.422,-4025.3635,-3994.5671,-3967.2793,-4004.8477,-4001.6606,-4001.2493,-4063.7322,-4035.7947,-4261.8413,-4144.2812,-4208.131,-4208.216,-4220.3545,-4233.937,-4089.8694,-4163.6685,-4217.936,-4269.601,-4298.2446,-4322.6396,-4292.2896,-4303.0933,-4426.1294,-4424.9,-4377.768,-4478.1406,-4525.0107,-4540.0093,-4540.246,-4510.4927,-4490.06,-4491.385,-4497.34,-4520.9165,-4521.4355,-4495.853,-4521.27,-4534.5166,-4521.53,-4537.221,-4523.8535,-4484.94,-4434.1284,-4442.748,-4439.3135,-4422.7866,-4408.442,-4377.5464,-4352.7314,-4333.9683,-4281.019,-4267.884,-4234.3667,-4192.371,-4178.7915,-4154.337,-4125.3506,-4111.621,-4081.4036,-4060.2478,-4038.9282,-4024.404,-3974.7356,-4032.2373,-4035.8943,-4034.678,-4016.7917,-4082.6929,-4075.308,-4072.722,-4086.3938,-4106.3506,-4151.4316,-4167.8315,-4189.161,-4165.8315,-4184.4683,-4224.256,-4022.3274,-4077.6501,-4125.6445,-4170.008,-4185.6973,-4185.648,-4198.225,-4289.7637,-4341.427,-4310.4644,-4287.1533,-4378.755};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {-4431.133,-4444.6226,-4438.5083,-4399.745,-4401.8184,-4443.795,-4423.5815,-4430.972,-4452.586,-4433.6465,-4432.025,-4472.203,-4475.8594,-4493.7583,-4467.4155,-4424.059,-4399.5513,-4432.8247,-4422.088,-4393.707,-4360.5117,-4374.771,-4342.2217,-4319.4795,-4317.5664,-4289.3945,-4250.5244,-4218.9414,-4198.071,-4164.808,-4154.4424,-4131.837,-4054.8862,-4031.7805,-4039.9185,-4011.9114,-4016.907,-4046.1501,-4058.5745,-4044.4014,-4067.0215,-4090.577,-4083.8586,-4086.5894,-4126.3945,-4149.606,-4156.3384,-4161.117,-4164.127,-4165.186,-4181.6094,-4240.2036,-4017.257,-4064.8826,-4089.2063,-4097.6226,-4090.3313,-4108.988,-4191.595,-4222.914,-4266.817,-4242.9917,-4212.476,-4316.275,-4354.5728,-4377.2993,-4364.7104,-4322.6313,-4355.0386,-4365.9907,-4341.6357,-4365.114,-4401.0835,-4409.682,-4390.496,-4413.49,-4424.5415,-4427.259,-4418.5767,-4369.8657,-4358.3066,-4402.318,-4380.3804,-4359.3633,-4337.1274,-4341.8506,-4334.6274,-4328.881,-4306.4863,-4301.068,-4265.289,-4239.8325,-4212.153,-4173.001,-4178.4717,-4143.546,-4044.2607,-4078.5154,-4091.2666,-4071.2764};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {-4072.4514,-4094.0703,-4097.137,-4085.5854,-4108.3955,-4115.9917,-4123.2583,-4130.325,-4165.0815,-4187.243,-4188.1904,-4180.5044,-4213.2285,-4204.4443,-4224.7334,-4224.9907,-4037.8157,-4055.1265,-4073.279,-4085.2368,-4080.402,-4117.8774,-4148.745,-4126.8647,-4187.702,-4178.181,-4190.4536,-4269.194,-4299.7114,-4314.496,-4287.6694,-4272.254,-4308.2603,-4288.7227,-4302.77,-4329.289,-4353.327,-4376.3345,-4364.3037,-4359.5483,-4362.6016,-4375.351,-4368.0474,-4392.159,-4401.368,-4375.3613,-4349.3237,-4336.951,-4354.1094,-4365.4062,-4353.384,-4330.3403,-4323.458,-4347.8706,-4298.138,-4270.7446,-4265.823,-4243.3896,-4219.2065,-4170.101,-4179.9883,-4186.5117,-4180.4653,-4141.4463,-4103.862,-4115.653,-4124.088,-4136.1226,-4145.851,-4158.3745,-4168.5347,-4185.9453,-4206.8926,-4196.416,-4174.8604,-4215.4497,-4236.138,-4242.242,-4236.3467,-4253.608,-3983.2905,-4024.042,-4044.764,-4055.5015,-4072.3928,-4105.427,-4077.704,-4058.845,-4162.876,-4129.5337,-4149.36,-4214.9297,-4237.051,-4229.1763,-4210.1304,-4256.873,-4284.426,-4286.156,-4277.23,-4278.722};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {-4290.716,-4305.75,-4306.562,-4307.4487,-4335.5195,-4364.418,-4373.558,-4378.45,-4354.8237,-4347.7534,-4321.613,-4341.4023,-4346.561,-4351.7046,-4345.676,-4354.0845,-4351.1836,-4345.3657,-4326.34,-4311.274,-4296.4067,-4288.339,-4241.896,-4242.9106,-4224.317,-4234.4404,-4245.533,-4184.954,-4150.635,-4175.0557,-4177.6606,-4189.563,-4205.368,-4207.0938,-4183.476,-4237.7046,-4259.1826,-4252.836,-4265.913,-4264.5234,-4255.904,-4290.0737,-4295.9316,-4295.143,-3960.7964,-3956.9143,-4008.4778,-4042.1282,-4013.2378,-3981.0942,-4000.054,-4067.7231,-4120.8857,-4106.5684,-4106.1294,-4168.359,-4191.5386,-4186.7354,-4182.1978,-4231.071,-4241.389,-4253.0903,-4245.2505,-4214.16,-4224.0376,-4244.0024,-4265.377,-4305.554,-4316.3086,-4307.903,-4332.8013,-4332.0293,-4315.4883,-4344.841,-4322.798,-4323.2256,-4364.931,-4349.971,-4342.9067,-4357.066,-4350.4014,-4337.0522,-4340.883,-4336.752,-4344.9424,-4327.5493,-4268.4927,-4305.803,-4299.939,-4292.2085,-4264.1187,-4257.2812,-4245.559,-4222.3853,-4272.3584,-4296.7046,-4297.5728,-4293.966,-4245.985,-4295.2036};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {-4310.972,-4313.0767,-4313.9575,-4280.4775,-4257.1543,-4329.347,-4401.1987,-4365.294,-3947.058,-3955.174,-3970.3052,-3994.124,-3999.6343,-4013.4307,-4022.7202,-4037.4546,-4080.2698,-4102.4893,-4105.4805,-4129.463,-4147.1367,-4148.614,-4160.232,-4177.2163,-4186.8384,-4186.4214,-4186.105,-4197.1826,-4213.0176,-4245.254,-4250.827,-4261.033,-4266.223,-4290.3535,-4290.0547,-4243.2383,-4280.1245,-4303.1304,-4302.6597,-4334.231,-4357.622,-4352.405,-4344.919,-4365.5674,-4334.252,-4314.2183,-4329.5127,-4320.8296,-4343.6274,-4345.805,-4323.0103,-4322.2793,-4370.3184,-4384.6187,-4354.5566,-4350.84,-4321.1274,-4314.2354,-4354.7266,-4346.521,-4330.052,-4342.1333,-4329.552,-4328.645,-4317.32,-4333.1753,-4314.4565,-4317.802,-4360.159,-4347.762,-4395.143,-4431.59,-3932.7742,-3939.4045,-4042.6963,-3951.4731,-3984.269,-3982.3618,-3989.963,-4034.0159,-4058.4841,-4072.1785,-4092.9492,-4107.274,-4106.829,-4113.2544,-4124.178,-4144.6357,-4148.52,-4144.456,-4165.801,-4176.3125,-4186.201,-4200.041,-4215.7847,-4250.4663,-4254.68,-4258.28,-4290.8,-4301.5015};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {-4309.415,-4318.145,-4326.366,-4334.299,-4351.59,-4330.5225,-4333.9307,-4356.6406,-4317.6626,-4310.048,-4346.931,-4324.8467,-4347.519,-4360.6685,-4350.523,-4351.1846,-4374.772,-4390.8994,-4400.7793,-4424.4727,-4398.1685,-4376.894,-4393.5864,-4402.724,-4390.4204,-4407.741,-4429.779,-4412.496,-4374.902,-4388.518,-4377.1978,-4367.2944,-4420.4272,-4419.864,-4437.321,-4435.9688,-3926.388,-3919.5454,-3924.422,-3961.1433,-4006.8274,-4030.3594,-4033.6094,-4044.0657,-4061.3696,-4042.388,-4048.8972,-4072.783,-4085.3286,-4098.9717,-4108.2417,-4116.837,-4117.0957,-4102.903,-4137.2437,-4162.066,-4169.7363,-4178.7075,-4207.3643,-4228.9277,-4238.245,-4260.486,-4263.7505,-4280.3994,-4315.3496,-4341.75,-4345.0303,-4333.323,-4337.5435,-4373.6333,-4461.1577,-4409.5195,-4361.2363,-4372.1387,-4379.2866,-4373.7974,-4407.8237,-4417.49,-4412.3184,-4426.3984,-4427.5356,-4445.0684,-4464.4497,-4486.3486,-4463.4155,-4436.647,-4434.2812,-4471.006,-4490.6323,-4488.8667,-4497.227,-4505.899,-4517.2866,-4507.4854,-4485.1714,-4497.614,-4500.6187,-4497.9146,-4514.7373,-4483.776};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {-3996.809,-3968.8591,-3966.353,-3968.6123,-3981.415,-4007.7922,-4010.384,-4001.821,-3991.0317,-3991.1035,-4031.802,-3999.0317,-4032.9565,-4064.937,-4089.946,-4104.844,-4118.236,-4139.3477,-4156.119,-4171.824,-4186.3213,-4201.6465,-4221.085,-4235.6724,-4240.244,-4257.924,-4271.109,-4289.724,-4312.1626,-4332.317,-4336.468,-4348.3013,-4359.2114,-4396.0845,-4424.551,-4445.065,-4448.9697,-4420.337,-4418.8022,-4432.061,-4464.8535,-4475.818,-4479.063,-4493.152,-4507.953,-4501.903,-4529.591,-4516.1035,-4488.5674,-4510.0176,-4568.881,-4564.4956,-4523.375,-4523.2275,-4526.0977,-4561.5664,-4600.3984,-4590.7114,-4600.7637,-4614.6045,-4595.589,-4576.7188,-4583.6694,-4555.384,-4076.8577,-4082.5488,-4084.593,-4068.7368,-4068.7075,-4066.8066,-4040.7888,-3993.7673,-4028.0823,-4030.961,-4028.4888,-4033.755,-4052.2195,-4064.868,-4082.0574,-4091.175,-4103.9517,-4118.785,-4144.0176,-4182.3535,-4200.646,-4208.585,-4223.84,-4243.539,-4270.72,-4255.0474,-4250.5557,-4278.1733,-4305.8394,-4330.0967,-4357.9736,-4378.3887,-4405.1836,-4418.53,-4443.763,-4432.815};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {-4453.165,-4454.083,-4446.8296,-4468.989,-4477.938,-4488.329,-4527.5005,-4537.246,-4556.198,-4552.765,-4571.622,-4552.476,-4581.4966,-4583.086,-4585.478,-4550.2734,-4443.3174,-4392.7363,-4446.2866,-4551.2593,-4587.0923,-4605.432,-4662.0933,-4686.578,-4678.074,-4629.905,-4646.6963,-4656.4233,-4167.7603,-4151.965,-4138.61,-4130.715,-4123.534,-4117.4536,-4125.521,-4131.8135,-4132.003,-4134.8447,-4147.378,-4149.0464,-4158.0254,-4151.0435,-4169.2437,-4178.535,-4198.975,-4213.843,-4208.422,-4228.3677,-4249.3687,-4286.7656,-4256.4116,-4260.884,-4277.0693,-4282.7695,-4302.908,-4329.495,-4337.624,-4349.1484,-4364.226,-4390.7314,-4417.5986,-4437.4434,-4452.338,-4451.96,-4485.95,-4477.1567,-4503.9316,-4505.134,-4525.577,-4541.5483,-4568.1577,-4585.547,-4575.095,-4563.377,-4587.748,-4618.8887,-4644.0303,-4645.6943,-4581.687,-4384.865,-4786.637,-4718.6533,-4556.5303,-4363.781,-4569.971,-4654.852,-4703.0073,-4736.6655,-4737.422,-4716.017,-4707.898,-4737.175,-4219.5625,-4216.447,-4221.702,-4212.6387,-4189.1113,-4180.744,-4164.6562,-4195.132};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {-4193.3843,-4194.193,-4210.3594,-4208.6255,-4211.3257,-4217.0054,-4232.607,-4241.239,-4258.231,-4260.2896,-4278.8203,-4284.356,-4287.8237,-4292.5273,-4282.629,-4314.137,-4322.459,-4327.5825,-4348.203,-4340.819,-4363.067,-4378.201,-4393.9976,-4418.2314,-4436.8076,-4460.2256,-4484.2773,-4499.8696,-4500.7944,-4520.5576,-4544.4634,-4558.6743,-4586.115,-4597.24,-4607.773,-4615.7373,-4603.678,-4576.9014,-4607.4106,-4637.6006,-4659.909,-4669.7866,-4665.9277,-4584.4585,-4600.8745,-4583.985,-4636.9995,-4705.3765,-4750.6196,-4785.74,-4793.617,-4791.2104,-4798.717,-4775.9194,-4775.4717,-4765.4854,-4252.368,-4257.8584,-4269.9346,-4271.6978,-4260.154,-4269.8203,-4270.4087,-4273.4707,-4262.7905,-4278.2085,-4286.8823,-4287.329,-4289.1147,-4289.7256,-4288.647,-4298.2817,-4311.7124,-4315.8994,-4305.3228,-4302.562,-4314.604,-4332.114,-4357.7925,-4375.215,-4381.751,-4384.1646,-4384.9316,-4378.184,-4388.2314,-4404.892,-4429.9365,-4457.944,-4475.734,-4485.4683,-4496.921,-4507.696,-4520.3525,-4551.8203,-4567.241,-4575.7983,-4602.147,-4628.3276,-4644.555,-4648.016};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {-4649.3096,-4652.413,-4667.1904,-4667.555,-4675.991,-4686.651,-4686.4873,-4715.4004,-4745.437,-4723.1514,-4739.5723,-4803.9277,-4839.4355,-4859.8784,-4867.3047,-4872.669,-4873.2246,-4823.2075,-4826.733,-4842.3496,-4251.122,-4310.1177,-4340.4746,-4361.9863,-4373.568,-4376.9272,-4361.3677,-4343.365,-4328.681,-4337.1987,-4349.2554,-4343.682,-4337.3857,-4339.812,-4343.1323,-4344.128,-4337.4893,-4346.1216,-4340.601,-4362.4727,-4345.4204,-4337.988,-4372.019,-4370.5815,-4391.52,-4393.56,-4403.303,-4419.5464,-4441.4277,-4463.3506,-4490.072,-4505.6074,-4508.865,-4508.8706,-4506.45,-4528.2026,-4549.38,-4577.805,-4599.858,-4611.911,-4641.9785,-4663.113,-4671.917,-4670.824,-4682.768,-4689.3906,-4718.798,-4736.2505,-4735.4146,-4710.2104,-4710.8057,-4739.3813,-4751.9937,-4758.847,-4784.018,-4812.0073,-4831.948,-4857.2124,-4876.962,-4913.928,-4922.1655,-4901.3916,-4883.5557,-4896.4717,-4432.956,-4438.0137,-4442.7085,-4460.54,-4469.226,-4455.043,-4437.6934,-4429.6714,-4426.4185,-4414.316,-4392.8506,-4389.6074,-4397.9775,-4384.8696,-4394.9966,-4397.647};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-4325.2246,-4341.435,-4357.678,-4377.7275,-4384.3677,-4394.9487,-4380.636,-4356.256,-4362.8257,-4392.108,-4414.8813,-4429.815,-4443.223,-4438.808,-4462.0356,-4465.0566,-4486.1597,-4511.665,-4531.1934,-4559.5776,-4573.65,-4592.229,-4615.0645,-4630.6235,-4656.3325,-4669.3716,-4683.4683,-4701.509,-4710.522,-4691.416,-4696.806,-4699.423,-4727.4717,-4749.493,-4764.207,-4772.8584,-4770.1885,-4764.182,-4790.1436,-4822.9604,-4833.308,-4831.629,-4817.7915,-4827.721,-4851.7236,-4873.0796,-4868.314,-4876.1943,-4463.8213,-4471.7676,-4474.2217,-4475.458,-4474.0283,-4475.109,-4474.545,-4471.356,-4465.618,-4459.213,-4448.0083,-4448.734,-4444.051,-4448.926,-4446.1294,-4432.908,-4422.345,-4423.2974,-4432.003,-4441.064,-4452.003,-4469.685,-4485.4097,-4501.664,-4517.725,-4534.4585,-4544.204,-4550.538,-4542.9067,-4551.879,-4555.2954,-4568.2886,-4579.331,-4582.2656,-4583.038,-4579.643,-4599.041,-4615.852,-4635.605,-4652.0347,-4667.95,-4678.728,-4673.1655,-4672.541,-4683.986,-4674.908,-4674.704,-4683.486,-4697.047,-4711.4546,-4700.61,-4690.2583};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {-4695.292,-4697.6294,-4700.802,-4702.102,-4689.2144,-4676.9214,-4660.4517,-4637.7314,-4640.145,-4636.6753,-4621.5693,-4607.6143,-4227.2583,-4238.759,-4253.341,-4272.114,-4289.831,-4302.753,-4328.475,-4364.238,-4396.823,-4423.728,-4447.3477,-4469.4907,-4492.7954,-4518.573,-4517.554,-4502.9683,-4492.198,-4487.796,-4498.1885,-4494.8135,-4500.703,-4518.66,-4533.829,-4544.506,-4551.805,-4559.786,-4563.151,-4563.666,-4560.986,-4562.9707,-4561.783,-4565.9487,-4572.356,-4577.4443,-4569.616,-4546.68,-4541.6704,-4546.7993,-4551.4756,-4553.1133,-4549.51,-4543.3794,-4534.852,-4525.613,-4519.7056,-4509.378,-4500.096,-4489.317,-4475.5938,-4461.5684,-4450.31,-4429.0776,-4423.1255,-4415.783,-4406.7266,-4396.968,-4385.446,-4373.9062,-4358.6167,-4342.7085,-4332.5815,-4321.8096,-4316.174,-4311.191,-3608.746,-3664.0442,-3702.9446,-3725.8425,-3752.6611,-3788.2747,-3819.5542,-3848.156,-3875.8538,-3918.4565,-3968.353,-4034.9587,-4111.423,-4184.1025,-4263.515,-4315.6377,-4386.714,-4428.117,-4457.4146,-4461.273,-4453.84,-4465.2544,-4487.954,-4506.968};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {-4513.848,-4511.9434,-4514.9707,-4518.5205,-4527.0347,-4531.263,-4524.6885,-4521.257,-4517.58,-4510.303,-4503.3364,-4494.737,-4480.0103,-4465.478,-4452.234,-4442.178,-4432.6064,-4418.156,-4403.66,-4391.1387,-4379.85,-4368.345,-4356.7573,-4348.8643,-4341.938,-4336.76,-4329.365,-4315.1235,-4303.607,-4295.25,-4284.4893,-4270.257,-4257.108,-4245.4375,-4231.287,-4217.531,-4206.4673,-4197.227,-4191.793,-4187.2217,-3225.4832,-3224.3052,-3226.7922,-3234.12,-3257.3577,-3292.4421,-3318.63,-3340.6135,-3359.3386,-3388.7524,-3434.691,-3473.0408,-3540.3237,-3599.311,-3665.6624,-3742.3408,-3801.1672,-3838.2031,-3883.7732,-3914.6807,-3907.0051,-3952.6528,-4011.8076,-4045.4795,-4072.216,-4074.939,-4103.218,-4130.4243,-4172.3926,-4185.406,-4190.065,-4183.6855,-4200.91,-4237.7573,-4272.61,-4313.26,-4340.865,-4369.526,-4380.158,-4359.9277,-4352.069,-4362.058,-4379.0146,-4394.8315,-4379.8286,-4378.1543,-4378.2983,-4386.2773,-4388.21,-4335.8276,-4293.5923,-4271.151,-4265.233,-4264.902,-4261.9136,-4244.5044,-4229.374,-4219.7803,-4207.6235,-4207.5605};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {-4217.6333,-4220.874,-4217.0396,-4208.431,-2975.6106,-2954.098,-2948.7595,-2955.661,-2980.9492,-3013.5823,-3033.1272,-3039.3762,-3037.915,-3029.0327,-3011.1123,-2983.7192,-2971.7642,-3013.1472,-3076.5505,-3135.5972,-3190.6545,-3275.7144,-3292.514,-3254.1133,-3198.3228,-3211.069,-3217.2087,-3185.8748,-3229.53,-3317.1191,-3323.2275,-3392.1406,-3468.6838,-3526.4604,-3528.0398,-3529.1392,-3545.248,-3545.6685,-3534.322,-3532.003,-3528.2922,-3482.3206,-3440.2046,-3509.076,-3575.3457,-3606.1008,-3648.422,-3737.981,-3727.8906,-3753.76,-3735.0942,-3665.801,-3671.719,-3668.5366,-3661.213,-3629.0422,-3620.0632,-3663.5405,-3710.1487,-3755.8374,-3867.5227,-3957.811,-3965.9353,-3756.1846,-3659.3193,-3744.7048,-3927.4858,-4107.5044,-2597.134,-2610.1345,-2613.6387,-2621.8274,-2643.9167,-2646.0488,-2600.5,-2598.9248,-2608.9673,-2599.617,-2636.6182,-2582.3674,-2555.235,-2567.1785,-2589.6907,-2610.3257,-2627.1467,-2641.821,-2668.4946,-2678.0647,-2660.9846,-2647.661,-2631.6785,-2629.4575,-2647.6067,-2641.1213,-2639.6216,-2599.2244,-2612.5999,-2653.2903,-2688.1455,-2709.3606};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {-2714.5303,-2748.2368,-2798.4692,-2862.1797,-2901.805,-2860.822,-2857.7024,-2795.477,-2855.5037,-2867.7153,-2867.1843,-2867.3726,-2914.283,-2923.4912,-2891.9756,-2857.16,-2865.2112,-2882.4446,-2882.787,-2885.4263,-2935.507,-2947.5427,-2949.7026,-2969.5803,-2945.9868,-2965.957,-3001.6973,-3024.9604,-2981.3237,-2995.4631,-2956.6836,-2903.3633,-2130.4001,-2121.7751,-2115.129,-2111.2495,-2112.5244,-2122.7769,-2109.0906,-2130.0996,-2138.343,-2134.6152,-2170.2166,-2114.973,-2076.8691,-2090.87,-2099.9067,-2116.005,-2119.486,-2130.4888,-2147.1006,-2145.6458,-2117.9744,-2121.505,-2135.5315,-2147.6973,-2167.174,-2174.8389,-2197.2964,-2204.1448,-2203.227,-2218.3306,-2230.7852,-2244.3853,-2248.3154,-2269.7007,-2288.0684,-2348.251,-2363.3628,-2293.5415,-2277.0188,-2243.6028,-2286.3398,-2283.3726,-2280.182,-2271.3005,-2289.4744,-2302.0835,-2300.9329,-2328.7817,-2329.455,-2341.655,-2344.1082,-2355.076,-2391.3992,-2403.0715,-2344.868,-2352.1484,-2342.027,-2354.335,-2373.2231,-2379.2288,-2349.8562,-2381.553,-2392.4646,-2400.6714};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.01587,0.00391,0.03175,0.00391,0.04762,0.00391,0.06349,0.00391,0.07937,0.00391,0.09524,0.00391,0.11111,0.00391,0.12698,0.00391,0.14286,0.00391,0.15873,0.00391,0.1746,0.00391,0.19048,0.00391,0.20635,0.00391,0.22222,0.00391,0.2381,0.00391,0.25397,0.00391,0.26984,0.00391,0.28571,0.00391,0.30159,0.00391,0.31746,0.00391,0.33333,0.00391,0.34921,0.00391,0.36508,0.00391,0.38095,0.00391,0.39683,0.00391,0.4127,0.00391,0.42857,0.00391,0.44444,0.00391,0.46032,0.00391,0.47619,0.00391,0.49206,0.00391,0.50794,0.00391,0.52381,0.00391,0.53968,0.00391,0.55556,0.00391,0.57143,0.00391,0.5873,0.00391,0.60317,0.00391,0.61905,0.00391,0.63492,0.00391,0.65079,0.00391,0.66667,0.00391,0.68254,0.00391,0.69841,0.00391,0.71429,0.00391,0.73016,0.00391,0.74603,0.00391,0.7619,0.00391,0.77778,0.00391,0.79365,0.00391,0.80952,0.00391,0.8254,0.00391,0.84127,0.00391,0.85714,0.00391,0.87302,0.00391,0.88889,0.00391,0.90476,0.00391,0.92063,0.00391,0.93651,0.00391,0.95238,0.00391,0.96825,0.00391,0.98413,0.00391,0.99609,0.00391,0.00391,0.01587,0.01587,0.01587,0.03175,0.01587,0.04762,0.01587,0.06349,0.01587,0.07937,0.01587,0.09524,0.01587,0.11111,0.01587,0.12698,0.01587,0.14286,0.01587,0.15873,0.01587,0.1746,0.01587,0.19048,0.01587,0.20635,0.01587,0.22222,0.01587,0.2381,0.01587,0.25397,0.01587,0.26984,0.01587,0.28571,0.01587,0.30159,0.01587,0.31746,0.01587,0.33333,0.01587,0.34921,0.01587,0.36508,0.01587,0.38095,0.01587,0.39683,0.01587,0.4127,0.01587,0.42857,0.01587,0.44444,0.01587,0.46032,0.01587,0.47619,0.01587,0.49206,0.01587,0.50794,0.01587,0.52381,0.01587,0.53968,0.01587,0.55556,0.01587};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.57143,0.01587,0.5873,0.01587,0.60317,0.01587,0.61905,0.01587,0.63492,0.01587,0.65079,0.01587,0.66667,0.01587,0.68254,0.01587,0.69841,0.01587,0.71429,0.01587,0.73016,0.01587,0.74603,0.01587,0.7619,0.01587,0.77778,0.01587,0.79365,0.01587,0.80952,0.01587,0.8254,0.01587,0.84127,0.01587,0.85714,0.01587,0.87302,0.01587,0.88889,0.01587,0.90476,0.01587,0.92063,0.01587,0.93651,0.01587,0.95238,0.01587,0.96825,0.01587,0.98413,0.01587,0.99609,0.01587,0.00391,0.03175,0.01587,0.03175,0.03175,0.03175,0.04762,0.03175,0.06349,0.03175,0.07937,0.03175,0.09524,0.03175,0.11111,0.03175,0.12698,0.03175,0.14286,0.03175,0.15873,0.03175,0.1746,0.03175,0.19048,0.03175,0.20635,0.03175,0.22222,0.03175,0.2381,0.03175,0.25397,0.03175,0.26984,0.03175,0.28571,0.03175,0.30159,0.03175,0.31746,0.03175,0.33333,0.03175,0.34921,0.03175,0.36508,0.03175,0.38095,0.03175,0.39683,0.03175,0.4127,0.03175,0.42857,0.03175,0.44444,0.03175,0.46032,0.03175,0.47619,0.03175,0.49206,0.03175,0.50794,0.03175,0.52381,0.03175,0.53968,0.03175,0.55556,0.03175,0.57143,0.03175,0.5873,0.03175,0.60317,0.03175,0.61905,0.03175,0.63492,0.03175,0.65079,0.03175,0.66667,0.03175,0.68254,0.03175,0.69841,0.03175,0.71429,0.03175,0.73016,0.03175,0.74603,0.03175,0.7619,0.03175,0.77778,0.03175,0.79365,0.03175,0.80952,0.03175,0.8254,0.03175,0.84127,0.03175,0.85714,0.03175,0.87302,0.03175,0.88889,0.03175,0.90476,0.03175,0.92063,0.03175,0.93651,0.03175,0.95238,0.03175,0.96825,0.03175,0.98413,0.03175,0.99609,0.03175,0.00391,0.04762,0.01587,0.04762,0.03175,0.04762,0.04762,0.04762,0.06349,0.04762,0.07937,0.04762,0.09524,0.04762,0.11111,0.04762};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.12698,0.04762,0.14286,0.04762,0.15873,0.04762,0.1746,0.04762,0.19048,0.04762,0.20635,0.04762,0.22222,0.04762,0.2381,0.04762,0.25397,0.04762,0.26984,0.04762,0.28571,0.04762,0.30159,0.04762,0.31746,0.04762,0.33333,0.04762,0.34921,0.04762,0.36508,0.04762,0.38095,0.04762,0.39683,0.04762,0.4127,0.04762,0.42857,0.04762,0.44444,0.04762,0.46032,0.04762,0.47619,0.04762,0.49206,0.04762,0.50794,0.04762,0.52381,0.04762,0.53968,0.04762,0.55556,0.04762,0.57143,0.04762,0.5873,0.04762,0.60317,0.04762,0.61905,0.04762,0.63492,0.04762,0.65079,0.04762,0.66667,0.04762,0.68254,0.04762,0.69841,0.04762,0.71429,0.04762,0.73016,0.04762,0.74603,0.04762,0.7619,0.04762,0.77778,0.04762,0.79365,0.04762,0.80952,0.04762,0.8254,0.04762,0.84127,0.04762,0.85714,0.04762,0.87302,0.04762,0.88889,0.04762,0.90476,0.04762,0.92063,0.04762,0.93651,0.04762,0.95238,0.04762,0.96825,0.04762,0.98413,0.04762,0.99609,0.04762,0.00391,0.06349,0.01587,0.06349,0.03175,0.06349,0.04762,0.06349,0.06349,0.06349,0.07937,0.06349,0.09524,0.06349,0.11111,0.06349,0.12698,0.06349,0.14286,0.06349,0.15873,0.06349,0.1746,0.06349,0.19048,0.06349,0.20635,0.06349,0.22222,0.06349,0.2381,0.06349,0.25397,0.06349,0.26984,0.06349,0.28571,0.06349,0.30159,0.06349,0.31746,0.06349,0.33333,0.06349,0.34921,0.06349,0.36508,0.06349,0.38095,0.06349,0.39683,0.06349,0.4127,0.06349,0.42857,0.06349,0.44444,0.06349,0.46032,0.06349,0.47619,0.06349,0.49206,0.06349,0.50794,0.06349,0.52381,0.06349,0.53968,0.06349,0.55556,0.06349,0.57143,0.06349,0.5873,0.06349,0.60317,0.06349,0.61905,0.06349,0.63492,0.06349,0.65079,0.06349,0.66667,0.06349,0.68254,0.06349};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.69841,0.06349,0.71429,0.06349,0.73016,0.06349,0.74603,0.06349,0.7619,0.06349,0.77778,0.06349,0.79365,0.06349,0.80952,0.06349,0.8254,0.06349,0.84127,0.06349,0.85714,0.06349,0.87302,0.06349,0.88889,0.06349,0.90476,0.06349,0.92063,0.06349,0.93651,0.06349,0.95238,0.06349,0.96825,0.06349,0.98413,0.06349,0.99609,0.06349,0.00391,0.07937,0.01587,0.07937,0.03175,0.07937,0.04762,0.07937,0.06349,0.07937,0.07937,0.07937,0.09524,0.07937,0.11111,0.07937,0.12698,0.07937,0.14286,0.07937,0.15873,0.07937,0.1746,0.07937,0.19048,0.07937,0.20635,0.07937,0.22222,0.07937,0.2381,0.07937,0.25397,0.07937,0.26984,0.07937,0.28571,0.07937,0.30159,0.07937,0.31746,0.07937,0.33333,0.07937,0.34921,0.07937,0.36508,0.07937,0.38095,0.07937,0.39683,0.07937,0.4127,0.07937,0.42857,0.07937,0.44444,0.07937,0.46032,0.07937,0.47619,0.07937,0.49206,0.07937,0.50794,0.07937,0.52381,0.07937,0.53968,0.07937,0.55556,0.07937,0.57143,0.07937,0.5873,0.07937,0.60317,0.07937,0.61905,0.07937,0.63492,0.07937,0.65079,0.07937,0.66667,0.07937,0.68254,0.07937,0.69841,0.07937,0.71429,0.07937,0.73016,0.07937,0.74603,0.07937,0.7619,0.07937,0.77778,0.07937,0.79365,0.07937,0.80952,0.07937,0.8254,0.07937,0.84127,0.07937,0.85714,0.07937,0.87302,0.07937,0.88889,0.07937,0.90476,0.07937,0.92063,0.07937,0.93651,0.07937,0.95238,0.07937,0.96825,0.07937,0.98413,0.07937,0.99609,0.07937,0.00391,0.09524,0.01587,0.09524,0.03175,0.09524,0.04762,0.09524,0.06349,0.09524,0.07937,0.09524,0.09524,0.09524,0.11111,0.09524,0.12698,0.09524,0.14286,0.09524,0.15873,0.09524,0.1746,0.09524,0.19048,0.09524,0.20635,0.09524,0.22222,0.09524,0.2381,0.09524};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.25397,0.09524,0.26984,0.09524,0.28571,0.09524,0.30159,0.09524,0.31746,0.09524,0.33333,0.09524,0.34921,0.09524,0.36508,0.09524,0.38095,0.09524,0.39683,0.09524,0.4127,0.09524,0.42857,0.09524,0.44444,0.09524,0.46032,0.09524,0.47619,0.09524,0.49206,0.09524,0.50794,0.09524,0.52381,0.09524,0.53968,0.09524,0.55556,0.09524,0.57143,0.09524,0.5873,0.09524,0.60317,0.09524,0.61905,0.09524,0.63492,0.09524,0.65079,0.09524,0.66667,0.09524,0.68254,0.09524,0.69841,0.09524,0.71429,0.09524,0.73016,0.09524,0.74603,0.09524,0.7619,0.09524,0.77778,0.09524,0.79365,0.09524,0.80952,0.09524,0.8254,0.09524,0.84127,0.09524,0.85714,0.09524,0.87302,0.09524,0.88889,0.09524,0.90476,0.09524,0.92063,0.09524,0.93651,0.09524,0.95238,0.09524,0.96825,0.09524,0.98413,0.09524,0.99609,0.09524,0.00391,0.11111,0.01587,0.11111,0.03175,0.11111,0.04762,0.11111,0.06349,0.11111,0.07937,0.11111,0.09524,0.11111,0.11111,0.11111,0.12698,0.11111,0.14286,0.11111,0.15873,0.11111,0.1746,0.11111,0.19048,0.11111,0.20635,0.11111,0.22222,0.11111,0.2381,0.11111,0.25397,0.11111,0.26984,0.11111,0.28571,0.11111,0.30159,0.11111,0.31746,0.11111,0.33333,0.11111,0.34921,0.11111,0.36508,0.11111,0.38095,0.11111,0.39683,0.11111,0.4127,0.11111,0.42857,0.11111,0.44444,0.11111,0.46032,0.11111,0.47619,0.11111,0.49206,0.11111,0.50794,0.11111,0.52381,0.11111,0.53968,0.11111,0.55556,0.11111,0.57143,0.11111,0.5873,0.11111,0.60317,0.11111,0.61905,0.11111,0.63492,0.11111,0.65079,0.11111,0.66667,0.11111,0.68254,0.11111,0.69841,0.11111,0.71429,0.11111,0.73016,0.11111,0.74603,0.11111,0.7619,0.11111,0.77778,0.11111,0.79365,0.11111,0.80952,0.11111};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.8254,0.11111,0.84127,0.11111,0.85714,0.11111,0.87302,0.11111,0.88889,0.11111,0.90476,0.11111,0.92063,0.11111,0.93651,0.11111,0.95238,0.11111,0.96825,0.11111,0.98413,0.11111,0.99609,0.11111,0.00391,0.12698,0.01587,0.12698,0.03175,0.12698,0.04762,0.12698,0.06349,0.12698,0.07937,0.12698,0.09524,0.12698,0.11111,0.12698,0.12698,0.12698,0.14286,0.12698,0.15873,0.12698,0.1746,0.12698,0.19048,0.12698,0.20635,0.12698,0.22222,0.12698,0.2381,0.12698,0.25397,0.12698,0.26984,0.12698,0.28571,0.12698,0.30159,0.12698,0.31746,0.12698,0.33333,0.12698,0.34921,0.12698,0.36508,0.12698,0.38095,0.12698,0.39683,0.12698,0.4127,0.12698,0.42857,0.12698,0.44444,0.12698,0.46032,0.12698,0.47619,0.12698,0.49206,0.12698,0.50794,0.12698,0.52381,0.12698,0.53968,0.12698,0.55556,0.12698,0.57143,0.12698,0.5873,0.12698,0.60317,0.12698,0.61905,0.12698,0.63492,0.12698,0.65079,0.12698,0.66667,0.12698,0.68254,0.12698,0.69841,0.12698,0.71429,0.12698,0.73016,0.12698,0.74603,0.12698,0.7619,0.12698,0.77778,0.12698,0.79365,0.12698,0.80952,0.12698,0.8254,0.12698,0.84127,0.12698,0.85714,0.12698,0.87302,0.12698,0.88889,0.12698,0.90476,0.12698,0.92063,0.12698,0.93651,0.12698,0.95238,0.12698,0.96825,0.12698,0.98413,0.12698,0.99609,0.12698,0.00391,0.14286,0.01587,0.14286,0.03175,0.14286,0.04762,0.14286,0.06349,0.14286,0.07937,0.14286,0.09524,0.14286,0.11111,0.14286,0.12698,0.14286,0.14286,0.14286,0.15873,0.14286,0.1746,0.14286,0.19048,0.14286,0.20635,0.14286,0.22222,0.14286,0.2381,0.14286,0.25397,0.14286,0.26984,0.14286,0.28571,0.14286,0.30159,0.14286,0.31746,0.14286,0.33333,0.14286,0.34921,0.14286,0.36508,0.14286};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.38095,0.14286,0.39683,0.14286,0.4127,0.14286,0.42857,0.14286,0.44444,0.14286,0.46032,0.14286,0.47619,0.14286,0.49206,0.14286,0.50794,0.14286,0.52381,0.14286,0.53968,0.14286,0.55556,0.14286,0.57143,0.14286,0.5873,0.14286,0.60317,0.14286,0.61905,0.14286,0.63492,0.14286,0.65079,0.14286,0.66667,0.14286,0.68254,0.14286,0.69841,0.14286,0.71429,0.14286,0.73016,0.14286,0.74603,0.14286,0.7619,0.14286,0.77778,0.14286,0.79365,0.14286,0.80952,0.14286,0.8254,0.14286,0.84127,0.14286,0.85714,0.14286,0.87302,0.14286,0.88889,0.14286,0.90476,0.14286,0.92063,0.14286,0.93651,0.14286,0.95238,0.14286,0.96825,0.14286,0.98413,0.14286,0.99609,0.14286,0.00391,0.15873,0.01587,0.15873,0.03175,0.15873,0.04762,0.15873,0.06349,0.15873,0.07937,0.15873,0.09524,0.15873,0.11111,0.15873,0.12698,0.15873,0.14286,0.15873,0.15873,0.15873,0.1746,0.15873,0.19048,0.15873,0.20635,0.15873,0.22222,0.15873,0.2381,0.15873,0.25397,0.15873,0.26984,0.15873,0.28571,0.15873,0.30159,0.15873,0.31746,0.15873,0.33333,0.15873,0.34921,0.15873,0.36508,0.15873,0.38095,0.15873,0.39683,0.15873,0.4127,0.15873,0.42857,0.15873,0.44444,0.15873,0.46032,0.15873,0.47619,0.15873,0.49206,0.15873,0.50794,0.15873,0.52381,0.15873,0.53968,0.15873,0.55556,0.15873,0.57143,0.15873,0.5873,0.15873,0.60317,0.15873,0.61905,0.15873,0.63492,0.15873,0.65079,0.15873,0.66667,0.15873,0.68254,0.15873,0.69841,0.15873,0.71429,0.15873,0.73016,0.15873,0.74603,0.15873,0.7619,0.15873,0.77778,0.15873,0.79365,0.15873,0.80952,0.15873,0.8254,0.15873,0.84127,0.15873,0.85714,0.15873,0.87302,0.15873,0.88889,0.15873,0.90476,0.15873,0.92063,0.15873,0.93651,0.15873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.95238,0.15873,0.96825,0.15873,0.98413,0.15873,0.99609,0.15873,0.00391,0.1746,0.01587,0.1746,0.03175,0.1746,0.04762,0.1746,0.06349,0.1746,0.07937,0.1746,0.09524,0.1746,0.11111,0.1746,0.12698,0.1746,0.14286,0.1746,0.15873,0.1746,0.1746,0.1746,0.19048,0.1746,0.20635,0.1746,0.22222,0.1746,0.2381,0.1746,0.25397,0.1746,0.26984,0.1746,0.28571,0.1746,0.30159,0.1746,0.31746,0.1746,0.33333,0.1746,0.34921,0.1746,0.36508,0.1746,0.38095,0.1746,0.39683,0.1746,0.4127,0.1746,0.42857,0.1746,0.44444,0.1746,0.46032,0.1746,0.47619,0.1746,0.49206,0.1746,0.50794,0.1746,0.52381,0.1746,0.53968,0.1746,0.55556,0.1746,0.57143,0.1746,0.5873,0.1746,0.60317,0.1746,0.61905,0.1746,0.63492,0.1746,0.65079,0.1746,0.66667,0.1746,0.68254,0.1746,0.69841,0.1746,0.71429,0.1746,0.73016,0.1746,0.74603,0.1746,0.7619,0.1746,0.77778,0.1746,0.79365,0.1746,0.80952,0.1746,0.8254,0.1746,0.84127,0.1746,0.85714,0.1746,0.87302,0.1746,0.88889,0.1746,0.90476,0.1746,0.92063,0.1746,0.93651,0.1746,0.95238,0.1746,0.96825,0.1746,0.98413,0.1746,0.99609,0.1746,0.00391,0.19048,0.01587,0.19048,0.03175,0.19048,0.04762,0.19048,0.06349,0.19048,0.07937,0.19048,0.09524,0.19048,0.11111,0.19048,0.12698,0.19048,0.14286,0.19048,0.15873,0.19048,0.1746,0.19048,0.19048,0.19048,0.20635,0.19048,0.22222,0.19048,0.2381,0.19048,0.25397,0.19048,0.26984,0.19048,0.28571,0.19048,0.30159,0.19048,0.31746,0.19048,0.33333,0.19048,0.34921,0.19048,0.36508,0.19048,0.38095,0.19048,0.39683,0.19048,0.4127,0.19048,0.42857,0.19048,0.44444,0.19048,0.46032,0.19048,0.47619,0.19048,0.49206,0.19048};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.50794,0.19048,0.52381,0.19048,0.53968,0.19048,0.55556,0.19048,0.57143,0.19048,0.5873,0.19048,0.60317,0.19048,0.61905,0.19048,0.63492,0.19048,0.65079,0.19048,0.66667,0.19048,0.68254,0.19048,0.69841,0.19048,0.71429,0.19048,0.73016,0.19048,0.74603,0.19048,0.7619,0.19048,0.77778,0.19048,0.79365,0.19048,0.80952,0.19048,0.8254,0.19048,0.84127,0.19048,0.85714,0.19048,0.87302,0.19048,0.88889,0.19048,0.90476,0.19048,0.92063,0.19048,0.93651,0.19048,0.95238,0.19048,0.96825,0.19048,0.98413,0.19048,0.99609,0.19048,0.00391,0.20635,0.01587,0.20635,0.03175,0.20635,0.04762,0.20635,0.06349,0.20635,0.07937,0.20635,0.09524,0.20635,0.11111,0.20635,0.12698,0.20635,0.14286,0.20635,0.15873,0.20635,0.1746,0.20635,0.19048,0.20635,0.20635,0.20635,0.22222,0.20635,0.2381,0.20635,0.25397,0.20635,0.26984,0.20635,0.28571,0.20635,0.30159,0.20635,0.31746,0.20635,0.33333,0.20635,0.34921,0.20635,0.36508,0.20635,0.38095,0.20635,0.39683,0.20635,0.4127,0.20635,0.42857,0.20635,0.44444,0.20635,0.46032,0.20635,0.47619,0.20635,0.49206,0.20635,0.50794,0.20635,0.52381,0.20635,0.53968,0.20635,0.55556,0.20635,0.57143,0.20635,0.5873,0.20635,0.60317,0.20635,0.61905,0.20635,0.63492,0.20635,0.65079,0.20635,0.66667,0.20635,0.68254,0.20635,0.69841,0.20635,0.71429,0.20635,0.73016,0.20635,0.74603,0.20635,0.7619,0.20635,0.77778,0.20635,0.79365,0.20635,0.80952,0.20635,0.8254,0.20635,0.84127,0.20635,0.85714,0.20635,0.87302,0.20635,0.88889,0.20635,0.90476,0.20635,0.92063,0.20635,0.93651,0.20635,0.95238,0.20635,0.96825,0.20635,0.98413,0.20635,0.99609,0.20635,0.00391,0.22222,0.01587,0.22222,0.03175,0.22222,0.04762,0.22222};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.06349,0.22222,0.07937,0.22222,0.09524,0.22222,0.11111,0.22222,0.12698,0.22222,0.14286,0.22222,0.15873,0.22222,0.1746,0.22222,0.19048,0.22222,0.20635,0.22222,0.22222,0.22222,0.2381,0.22222,0.25397,0.22222,0.26984,0.22222,0.28571,0.22222,0.30159,0.22222,0.31746,0.22222,0.33333,0.22222,0.34921,0.22222,0.36508,0.22222,0.38095,0.22222,0.39683,0.22222,0.4127,0.22222,0.42857,0.22222,0.44444,0.22222,0.46032,0.22222,0.47619,0.22222,0.49206,0.22222,0.50794,0.22222,0.52381,0.22222,0.53968,0.22222,0.55556,0.22222,0.57143,0.22222,0.5873,0.22222,0.60317,0.22222,0.61905,0.22222,0.63492,0.22222,0.65079,0.22222,0.66667,0.22222,0.68254,0.22222,0.69841,0.22222,0.71429,0.22222,0.73016,0.22222,0.74603,0.22222,0.7619,0.22222,0.77778,0.22222,0.79365,0.22222,0.80952,0.22222,0.8254,0.22222,0.84127,0.22222,0.85714,0.22222,0.87302,0.22222,0.88889,0.22222,0.90476,0.22222,0.92063,0.22222,0.93651,0.22222,0.95238,0.22222,0.96825,0.22222,0.98413,0.22222,0.99609,0.22222,0.00391,0.2381,0.01587,0.2381,0.03175,0.2381,0.04762,0.2381,0.06349,0.2381,0.07937,0.2381,0.09524,0.2381,0.11111,0.2381,0.12698,0.2381,0.14286,0.2381,0.15873,0.2381,0.1746,0.2381,0.19048,0.2381,0.20635,0.2381,0.22222,0.2381,0.2381,0.2381,0.25397,0.2381,0.26984,0.2381,0.28571,0.2381,0.30159,0.2381,0.31746,0.2381,0.33333,0.2381,0.34921,0.2381,0.36508,0.2381,0.38095,0.2381,0.39683,0.2381,0.4127,0.2381,0.42857,0.2381,0.44444,0.2381,0.46032,0.2381,0.47619,0.2381,0.49206,0.2381,0.50794,0.2381,0.52381,0.2381,0.53968,0.2381,0.55556,0.2381,0.57143,0.2381,0.5873,0.2381,0.60317,0.2381,0.61905,0.2381};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.63492,0.2381,0.65079,0.2381,0.66667,0.2381,0.68254,0.2381,0.69841,0.2381,0.71429,0.2381,0.73016,0.2381,0.74603,0.2381,0.7619,0.2381,0.77778,0.2381,0.79365,0.2381,0.80952,0.2381,0.8254,0.2381,0.84127,0.2381,0.85714,0.2381,0.87302,0.2381,0.88889,0.2381,0.90476,0.2381,0.92063,0.2381,0.93651,0.2381,0.95238,0.2381,0.96825,0.2381,0.98413,0.2381,0.99609,0.2381,0.00391,0.25397,0.01587,0.25397,0.03175,0.25397,0.04762,0.25397,0.06349,0.25397,0.07937,0.25397,0.09524,0.25397,0.11111,0.25397,0.12698,0.25397,0.14286,0.25397,0.15873,0.25397,0.1746,0.25397,0.19048,0.25397,0.20635,0.25397,0.22222,0.25397,0.2381,0.25397,0.25397,0.25397,0.26984,0.25397,0.28571,0.25397,0.30159,0.25397,0.31746,0.25397,0.33333,0.25397,0.34921,0.25397,0.36508,0.25397,0.38095,0.25397,0.39683,0.25397,0.4127,0.25397,0.42857,0.25397,0.44444,0.25397,0.46032,0.25397,0.47619,0.25397,0.49206,0.25397,0.50794,0.25397,0.52381,0.25397,0.53968,0.25397,0.55556,0.25397,0.57143,0.25397,0.5873,0.25397,0.60317,0.25397,0.61905,0.25397,0.63492,0.25397,0.65079,0.25397,0.66667,0.25397,0.68254,0.25397,0.69841,0.25397,0.71429,0.25397,0.73016,0.25397,0.74603,0.25397,0.7619,0.25397,0.77778,0.25397,0.79365,0.25397,0.80952,0.25397,0.8254,0.25397,0.84127,0.25397,0.85714,0.25397,0.87302,0.25397,0.88889,0.25397,0.90476,0.25397,0.92063,0.25397,0.93651,0.25397,0.95238,0.25397,0.96825,0.25397,0.98413,0.25397,0.99609,0.25397,0.00391,0.26984,0.01587,0.26984,0.03175,0.26984,0.04762,0.26984,0.06349,0.26984,0.07937,0.26984,0.09524,0.26984,0.11111,0.26984,0.12698,0.26984,0.14286,0.26984,0.15873,0.26984,0.1746,0.26984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.19048,0.26984,0.20635,0.26984,0.22222,0.26984,0.2381,0.26984,0.25397,0.26984,0.26984,0.26984,0.28571,0.26984,0.30159,0.26984,0.31746,0.26984,0.33333,0.26984,0.34921,0.26984,0.36508,0.26984,0.38095,0.26984,0.39683,0.26984,0.4127,0.26984,0.42857,0.26984,0.44444,0.26984,0.46032,0.26984,0.47619,0.26984,0.49206,0.26984,0.50794,0.26984,0.52381,0.26984,0.53968,0.26984,0.55556,0.26984,0.57143,0.26984,0.5873,0.26984,0.60317,0.26984,0.61905,0.26984,0.63492,0.26984,0.65079,0.26984,0.66667,0.26984,0.68254,0.26984,0.69841,0.26984,0.71429,0.26984,0.73016,0.26984,0.74603,0.26984,0.7619,0.26984,0.77778,0.26984,0.79365,0.26984,0.80952,0.26984,0.8254,0.26984,0.84127,0.26984,0.85714,0.26984,0.87302,0.26984,0.88889,0.26984,0.90476,0.26984,0.92063,0.26984,0.93651,0.26984,0.95238,0.26984,0.96825,0.26984,0.98413,0.26984,0.99609,0.26984,0.00391,0.28571,0.01587,0.28571,0.03175,0.28571,0.04762,0.28571,0.06349,0.28571,0.07937,0.28571,0.09524,0.28571,0.11111,0.28571,0.12698,0.28571,0.14286,0.28571,0.15873,0.28571,0.1746,0.28571,0.19048,0.28571,0.20635,0.28571,0.22222,0.28571,0.2381,0.28571,0.25397,0.28571,0.26984,0.28571,0.28571,0.28571,0.30159,0.28571,0.31746,0.28571,0.33333,0.28571,0.34921,0.28571,0.36508,0.28571,0.38095,0.28571,0.39683,0.28571,0.4127,0.28571,0.42857,0.28571,0.44444,0.28571,0.46032,0.28571,0.47619,0.28571,0.49206,0.28571,0.50794,0.28571,0.52381,0.28571,0.53968,0.28571,0.55556,0.28571,0.57143,0.28571,0.5873,0.28571,0.60317,0.28571,0.61905,0.28571,0.63492,0.28571,0.65079,0.28571,0.66667,0.28571,0.68254,0.28571,0.69841,0.28571,0.71429,0.28571,0.73016,0.28571,0.74603,0.28571};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.7619,0.28571,0.77778,0.28571,0.79365,0.28571,0.80952,0.28571,0.8254,0.28571,0.84127,0.28571,0.85714,0.28571,0.87302,0.28571,0.88889,0.28571,0.90476,0.28571,0.92063,0.28571,0.93651,0.28571,0.95238,0.28571,0.96825,0.28571,0.98413,0.28571,0.99609,0.28571,0.00391,0.30159,0.01587,0.30159,0.03175,0.30159,0.04762,0.30159,0.06349,0.30159,0.07937,0.30159,0.09524,0.30159,0.11111,0.30159,0.12698,0.30159,0.14286,0.30159,0.15873,0.30159,0.1746,0.30159,0.19048,0.30159,0.20635,0.30159,0.22222,0.30159,0.2381,0.30159,0.25397,0.30159,0.26984,0.30159,0.28571,0.30159,0.30159,0.30159,0.31746,0.30159,0.33333,0.30159,0.34921,0.30159,0.36508,0.30159,0.38095,0.30159,0.39683,0.30159,0.4127,0.30159,0.42857,0.30159,0.44444,0.30159,0.46032,0.30159,0.47619,0.30159,0.49206,0.30159,0.50794,0.30159,0.52381,0.30159,0.53968,0.30159,0.55556,0.30159,0.57143,0.30159,0.5873,0.30159,0.60317,0.30159,0.61905,0.30159,0.63492,0.30159,0.65079,0.30159,0.66667,0.30159,0.68254,0.30159,0.69841,0.30159,0.71429,0.30159,0.73016,0.30159,0.74603,0.30159,0.7619,0.30159,0.77778,0.30159,0.79365,0.30159,0.80952,0.30159,0.8254,0.30159,0.84127,0.30159,0.85714,0.30159,0.87302,0.30159,0.88889,0.30159,0.90476,0.30159,0.92063,0.30159,0.93651,0.30159,0.95238,0.30159,0.96825,0.30159,0.98413,0.30159,0.99609,0.30159,0.00391,0.31746,0.01587,0.31746,0.03175,0.31746,0.04762,0.31746,0.06349,0.31746,0.07937,0.31746,0.09524,0.31746,0.11111,0.31746,0.12698,0.31746,0.14286,0.31746,0.15873,0.31746,0.1746,0.31746,0.19048,0.31746,0.20635,0.31746,0.22222,0.31746,0.2381,0.31746,0.25397,0.31746,0.26984,0.31746,0.28571,0.31746,0.30159,0.31746};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.31746,0.31746,0.33333,0.31746,0.34921,0.31746,0.36508,0.31746,0.38095,0.31746,0.39683,0.31746,0.4127,0.31746,0.42857,0.31746,0.44444,0.31746,0.46032,0.31746,0.47619,0.31746,0.49206,0.31746,0.50794,0.31746,0.52381,0.31746,0.53968,0.31746,0.55556,0.31746,0.57143,0.31746,0.5873,0.31746,0.60317,0.31746,0.61905,0.31746,0.63492,0.31746,0.65079,0.31746,0.66667,0.31746,0.68254,0.31746,0.69841,0.31746,0.71429,0.31746,0.73016,0.31746,0.74603,0.31746,0.7619,0.31746,0.77778,0.31746,0.79365,0.31746,0.80952,0.31746,0.8254,0.31746,0.84127,0.31746,0.85714,0.31746,0.87302,0.31746,0.88889,0.31746,0.90476,0.31746,0.92063,0.31746,0.93651,0.31746,0.95238,0.31746,0.96825,0.31746,0.98413,0.31746,0.99609,0.31746,0.00391,0.33333,0.01587,0.33333,0.03175,0.33333,0.04762,0.33333,0.06349,0.33333,0.07937,0.33333,0.09524,0.33333,0.11111,0.33333,0.12698,0.33333,0.14286,0.33333,0.15873,0.33333,0.1746,0.33333,0.19048,0.33333,0.20635,0.33333,0.22222,0.33333,0.2381,0.33333,0.25397,0.33333,0.26984,0.33333,0.28571,0.33333,0.30159,0.33333,0.31746,0.33333,0.33333,0.33333,0.34921,0.33333,0.36508,0.33333,0.38095,0.33333,0.39683,0.33333,0.4127,0.33333,0.42857,0.33333,0.44444,0.33333,0.46032,0.33333,0.47619,0.33333,0.49206,0.33333,0.50794,0.33333,0.52381,0.33333,0.53968,0.33333,0.55556,0.33333,0.57143,0.33333,0.5873,0.33333,0.60317,0.33333,0.61905,0.33333,0.63492,0.33333,0.65079,0.33333,0.66667,0.33333,0.68254,0.33333,0.69841,0.33333,0.71429,0.33333,0.73016,0.33333,0.74603,0.33333,0.7619,0.33333,0.77778,0.33333,0.79365,0.33333,0.80952,0.33333,0.8254,0.33333,0.84127,0.33333,0.85714,0.33333,0.87302,0.33333};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.88889,0.33333,0.90476,0.33333,0.92063,0.33333,0.93651,0.33333,0.95238,0.33333,0.96825,0.33333,0.98413,0.33333,0.99609,0.33333,0.00391,0.34921,0.01587,0.34921,0.03175,0.34921,0.04762,0.34921,0.06349,0.34921,0.07937,0.34921,0.09524,0.34921,0.11111,0.34921,0.12698,0.34921,0.14286,0.34921,0.15873,0.34921,0.1746,0.34921,0.19048,0.34921,0.20635,0.34921,0.22222,0.34921,0.2381,0.34921,0.25397,0.34921,0.26984,0.34921,0.28571,0.34921,0.30159,0.34921,0.31746,0.34921,0.33333,0.34921,0.34921,0.34921,0.36508,0.34921,0.38095,0.34921,0.39683,0.34921,0.4127,0.34921,0.42857,0.34921,0.44444,0.34921,0.46032,0.34921,0.47619,0.34921,0.49206,0.34921,0.50794,0.34921,0.52381,0.34921,0.53968,0.34921,0.55556,0.34921,0.57143,0.34921,0.5873,0.34921,0.60317,0.34921,0.61905,0.34921,0.63492,0.34921,0.65079,0.34921,0.66667,0.34921,0.68254,0.34921,0.69841,0.34921,0.71429,0.34921,0.73016,0.34921,0.74603,0.34921,0.7619,0.34921,0.77778,0.34921,0.79365,0.34921,0.80952,0.34921,0.8254,0.34921,0.84127,0.34921,0.85714,0.34921,0.87302,0.34921,0.88889,0.34921,0.90476,0.34921,0.92063,0.34921,0.93651,0.34921,0.95238,0.34921,0.96825,0.34921,0.98413,0.34921,0.99609,0.34921,0.00391,0.36508,0.01587,0.36508,0.03175,0.36508,0.04762,0.36508,0.06349,0.36508,0.07937,0.36508,0.09524,0.36508,0.11111,0.36508,0.12698,0.36508,0.14286,0.36508,0.15873,0.36508,0.1746,0.36508,0.19048,0.36508,0.20635,0.36508,0.22222,0.36508,0.2381,0.36508,0.25397,0.36508,0.26984,0.36508,0.28571,0.36508,0.30159,0.36508,0.31746,0.36508,0.33333,0.36508,0.34921,0.36508,0.36508,0.36508,0.38095,0.36508,0.39683,0.36508,0.4127,0.36508,0.42857,0.36508};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.44444,0.36508,0.46032,0.36508,0.47619,0.36508,0.49206,0.36508,0.50794,0.36508,0.52381,0.36508,0.53968,0.36508,0.55556,0.36508,0.57143,0.36508,0.5873,0.36508,0.60317,0.36508,0.61905,0.36508,0.63492,0.36508,0.65079,0.36508,0.66667,0.36508,0.68254,0.36508,0.69841,0.36508,0.71429,0.36508,0.73016,0.36508,0.74603,0.36508,0.7619,0.36508,0.77778,0.36508,0.79365,0.36508,0.80952,0.36508,0.8254,0.36508,0.84127,0.36508,0.85714,0.36508,0.87302,0.36508,0.88889,0.36508,0.90476,0.36508,0.92063,0.36508,0.93651,0.36508,0.95238,0.36508,0.96825,0.36508,0.98413,0.36508,0.99609,0.36508,0.00391,0.38095,0.01587,0.38095,0.03175,0.38095,0.04762,0.38095,0.06349,0.38095,0.07937,0.38095,0.09524,0.38095,0.11111,0.38095,0.12698,0.38095,0.14286,0.38095,0.15873,0.38095,0.1746,0.38095,0.19048,0.38095,0.20635,0.38095,0.22222,0.38095,0.2381,0.38095,0.25397,0.38095,0.26984,0.38095,0.28571,0.38095,0.30159,0.38095,0.31746,0.38095,0.33333,0.38095,0.34921,0.38095,0.36508,0.38095,0.38095,0.38095,0.39683,0.38095,0.4127,0.38095,0.42857,0.38095,0.44444,0.38095,0.46032,0.38095,0.47619,0.38095,0.49206,0.38095,0.50794,0.38095,0.52381,0.38095,0.53968,0.38095,0.55556,0.38095,0.57143,0.38095,0.5873,0.38095,0.60317,0.38095,0.61905,0.38095,0.63492,0.38095,0.65079,0.38095,0.66667,0.38095,0.68254,0.38095,0.69841,0.38095,0.71429,0.38095,0.73016,0.38095,0.74603,0.38095,0.7619,0.38095,0.77778,0.38095,0.79365,0.38095,0.80952,0.38095,0.8254,0.38095,0.84127,0.38095,0.85714,0.38095,0.87302,0.38095,0.88889,0.38095,0.90476,0.38095,0.92063,0.38095,0.93651,0.38095,0.95238,0.38095,0.96825,0.38095,0.98413,0.38095,0.99609,0.38095};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.00391,0.39683,0.01587,0.39683,0.03175,0.39683,0.04762,0.39683,0.06349,0.39683,0.07937,0.39683,0.09524,0.39683,0.11111,0.39683,0.12698,0.39683,0.14286,0.39683,0.15873,0.39683,0.1746,0.39683,0.19048,0.39683,0.20635,0.39683,0.22222,0.39683,0.2381,0.39683,0.25397,0.39683,0.26984,0.39683,0.28571,0.39683,0.30159,0.39683,0.31746,0.39683,0.33333,0.39683,0.34921,0.39683,0.36508,0.39683,0.38095,0.39683,0.39683,0.39683,0.4127,0.39683,0.42857,0.39683,0.44444,0.39683,0.46032,0.39683,0.47619,0.39683,0.49206,0.39683,0.50794,0.39683,0.52381,0.39683,0.53968,0.39683,0.55556,0.39683,0.57143,0.39683,0.5873,0.39683,0.60317,0.39683,0.61905,0.39683,0.63492,0.39683,0.65079,0.39683,0.66667,0.39683,0.68254,0.39683,0.69841,0.39683,0.71429,0.39683,0.73016,0.39683,0.74603,0.39683,0.7619,0.39683,0.77778,0.39683,0.79365,0.39683,0.80952,0.39683,0.8254,0.39683,0.84127,0.39683,0.85714,0.39683,0.87302,0.39683,0.88889,0.39683,0.90476,0.39683,0.92063,0.39683,0.93651,0.39683,0.95238,0.39683,0.96825,0.39683,0.98413,0.39683,0.99609,0.39683,0.00391,0.4127,0.01587,0.4127,0.03175,0.4127,0.04762,0.4127,0.06349,0.4127,0.07937,0.4127,0.09524,0.4127,0.11111,0.4127,0.12698,0.4127,0.14286,0.4127,0.15873,0.4127,0.1746,0.4127,0.19048,0.4127,0.20635,0.4127,0.22222,0.4127,0.2381,0.4127,0.25397,0.4127,0.26984,0.4127,0.28571,0.4127,0.30159,0.4127,0.31746,0.4127,0.33333,0.4127,0.34921,0.4127,0.36508,0.4127,0.38095,0.4127,0.39683,0.4127,0.4127,0.4127,0.42857,0.4127,0.44444,0.4127,0.46032,0.4127,0.47619,0.4127,0.49206,0.4127,0.50794,0.4127,0.52381,0.4127,0.53968,0.4127,0.55556,0.4127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.57143,0.4127,0.5873,0.4127,0.60317,0.4127,0.61905,0.4127,0.63492,0.4127,0.65079,0.4127,0.66667,0.4127,0.68254,0.4127,0.69841,0.4127,0.71429,0.4127,0.73016,0.4127,0.74603,0.4127,0.7619,0.4127,0.77778,0.4127,0.79365,0.4127,0.80952,0.4127,0.8254,0.4127,0.84127,0.4127,0.85714,0.4127,0.87302,0.4127,0.88889,0.4127,0.90476,0.4127,0.92063,0.4127,0.93651,0.4127,0.95238,0.4127,0.96825,0.4127,0.98413,0.4127,0.99609,0.4127,0.00391,0.42857,0.01587,0.42857,0.03175,0.42857,0.04762,0.42857,0.06349,0.42857,0.07937,0.42857,0.09524,0.42857,0.11111,0.42857,0.12698,0.42857,0.14286,0.42857,0.15873,0.42857,0.1746,0.42857,0.19048,0.42857,0.20635,0.42857,0.22222,0.42857,0.2381,0.42857,0.25397,0.42857,0.26984,0.42857,0.28571,0.42857,0.30159,0.42857,0.31746,0.42857,0.33333,0.42857,0.34921,0.42857,0.36508,0.42857,0.38095,0.42857,0.39683,0.42857,0.4127,0.42857,0.42857,0.42857,0.44444,0.42857,0.46032,0.42857,0.47619,0.42857,0.49206,0.42857,0.50794,0.42857,0.52381,0.42857,0.53968,0.42857,0.55556,0.42857,0.57143,0.42857,0.5873,0.42857,0.60317,0.42857,0.61905,0.42857,0.63492,0.42857,0.65079,0.42857,0.66667,0.42857,0.68254,0.42857,0.69841,0.42857,0.71429,0.42857,0.73016,0.42857,0.74603,0.42857,0.7619,0.42857,0.77778,0.42857,0.79365,0.42857,0.80952,0.42857,0.8254,0.42857,0.84127,0.42857,0.85714,0.42857,0.87302,0.42857,0.88889,0.42857,0.90476,0.42857,0.92063,0.42857,0.93651,0.42857,0.95238,0.42857,0.96825,0.42857,0.98413,0.42857,0.99609,0.42857,0.00391,0.44444,0.01587,0.44444,0.03175,0.44444,0.04762,0.44444,0.06349,0.44444,0.07937,0.44444,0.09524,0.44444,0.11111,0.44444};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.12698,0.44444,0.14286,0.44444,0.15873,0.44444,0.1746,0.44444,0.19048,0.44444,0.20635,0.44444,0.22222,0.44444,0.2381,0.44444,0.25397,0.44444,0.26984,0.44444,0.28571,0.44444,0.30159,0.44444,0.31746,0.44444,0.33333,0.44444,0.34921,0.44444,0.36508,0.44444,0.38095,0.44444,0.39683,0.44444,0.4127,0.44444,0.42857,0.44444,0.44444,0.44444,0.46032,0.44444,0.47619,0.44444,0.49206,0.44444,0.50794,0.44444,0.52381,0.44444,0.53968,0.44444,0.55556,0.44444,0.57143,0.44444,0.5873,0.44444,0.60317,0.44444,0.61905,0.44444,0.63492,0.44444,0.65079,0.44444,0.66667,0.44444,0.68254,0.44444,0.69841,0.44444,0.71429,0.44444,0.73016,0.44444,0.74603,0.44444,0.7619,0.44444,0.77778,0.44444,0.79365,0.44444,0.80952,0.44444,0.8254,0.44444,0.84127,0.44444,0.85714,0.44444,0.87302,0.44444,0.88889,0.44444,0.90476,0.44444,0.92063,0.44444,0.93651,0.44444,0.95238,0.44444,0.96825,0.44444,0.98413,0.44444,0.99609,0.44444,0.00391,0.46032,0.01587,0.46032,0.03175,0.46032,0.04762,0.46032,0.06349,0.46032,0.07937,0.46032,0.09524,0.46032,0.11111,0.46032,0.12698,0.46032,0.14286,0.46032,0.15873,0.46032,0.1746,0.46032,0.19048,0.46032,0.20635,0.46032,0.22222,0.46032,0.2381,0.46032,0.25397,0.46032,0.26984,0.46032,0.28571,0.46032,0.30159,0.46032,0.31746,0.46032,0.33333,0.46032,0.34921,0.46032,0.36508,0.46032,0.38095,0.46032,0.39683,0.46032,0.4127,0.46032,0.42857,0.46032,0.44444,0.46032,0.46032,0.46032,0.47619,0.46032,0.49206,0.46032,0.50794,0.46032,0.52381,0.46032,0.53968,0.46032,0.55556,0.46032,0.57143,0.46032,0.5873,0.46032,0.60317,0.46032,0.61905,0.46032,0.63492,0.46032,0.65079,0.46032,0.66667,0.46032,0.68254,0.46032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.69841,0.46032,0.71429,0.46032,0.73016,0.46032,0.74603,0.46032,0.7619,0.46032,0.77778,0.46032,0.79365,0.46032,0.80952,0.46032,0.8254,0.46032,0.84127,0.46032,0.85714,0.46032,0.87302,0.46032,0.88889,0.46032,0.90476,0.46032,0.92063,0.46032,0.93651,0.46032,0.95238,0.46032,0.96825,0.46032,0.98413,0.46032,0.99609,0.46032,0.00391,0.47619,0.01587,0.47619,0.03175,0.47619,0.04762,0.47619,0.06349,0.47619,0.07937,0.47619,0.09524,0.47619,0.11111,0.47619,0.12698,0.47619,0.14286,0.47619,0.15873,0.47619,0.1746,0.47619,0.19048,0.47619,0.20635,0.47619,0.22222,0.47619,0.2381,0.47619,0.25397,0.47619,0.26984,0.47619,0.28571,0.47619,0.30159,0.47619,0.31746,0.47619,0.33333,0.47619,0.34921,0.47619,0.36508,0.47619,0.38095,0.47619,0.39683,0.47619,0.4127,0.47619,0.42857,0.47619,0.44444,0.47619,0.46032,0.47619,0.47619,0.47619,0.49206,0.47619,0.50794,0.47619,0.52381,0.47619,0.53968,0.47619,0.55556,0.47619,0.57143,0.47619,0.5873,0.47619,0.60317,0.47619,0.61905,0.47619,0.63492,0.47619,0.65079,0.47619,0.66667,0.47619,0.68254,0.47619,0.69841,0.47619,0.71429,0.47619,0.73016,0.47619,0.74603,0.47619,0.7619,0.47619,0.77778,0.47619,0.79365,0.47619,0.80952,0.47619,0.8254,0.47619,0.84127,0.47619,0.85714,0.47619,0.87302,0.47619,0.88889,0.47619,0.90476,0.47619,0.92063,0.47619,0.93651,0.47619,0.95238,0.47619,0.96825,0.47619,0.98413,0.47619,0.99609,0.47619,0.00391,0.49206,0.01587,0.49206,0.03175,0.49206,0.04762,0.49206,0.06349,0.49206,0.07937,0.49206,0.09524,0.49206,0.11111,0.49206,0.12698,0.49206,0.14286,0.49206,0.15873,0.49206,0.1746,0.49206,0.19048,0.49206,0.20635,0.49206,0.22222,0.49206,0.2381,0.49206};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.25397,0.49206,0.26984,0.49206,0.28571,0.49206,0.30159,0.49206,0.31746,0.49206,0.33333,0.49206,0.34921,0.49206,0.36508,0.49206,0.38095,0.49206,0.39683,0.49206,0.4127,0.49206,0.42857,0.49206,0.44444,0.49206,0.46032,0.49206,0.47619,0.49206,0.49206,0.49206,0.50794,0.49206,0.52381,0.49206,0.53968,0.49206,0.55556,0.49206,0.57143,0.49206,0.5873,0.49206,0.60317,0.49206,0.61905,0.49206,0.63492,0.49206,0.65079,0.49206,0.66667,0.49206,0.68254,0.49206,0.69841,0.49206,0.71429,0.49206,0.73016,0.49206,0.74603,0.49206,0.7619,0.49206,0.77778,0.49206,0.79365,0.49206,0.80952,0.49206,0.8254,0.49206,0.84127,0.49206,0.85714,0.49206,0.87302,0.49206,0.88889,0.49206,0.90476,0.49206,0.92063,0.49206,0.93651,0.49206,0.95238,0.49206,0.96825,0.49206,0.98413,0.49206,0.99609,0.49206,0.00391,0.50794,0.01587,0.50794,0.03175,0.50794,0.04762,0.50794,0.06349,0.50794,0.07937,0.50794,0.09524,0.50794,0.11111,0.50794,0.12698,0.50794,0.14286,0.50794,0.15873,0.50794,0.1746,0.50794,0.19048,0.50794,0.20635,0.50794,0.22222,0.50794,0.2381,0.50794,0.25397,0.50794,0.26984,0.50794,0.28571,0.50794,0.30159,0.50794,0.31746,0.50794,0.33333,0.50794,0.34921,0.50794,0.36508,0.50794,0.38095,0.50794,0.39683,0.50794,0.4127,0.50794,0.42857,0.50794,0.44444,0.50794,0.46032,0.50794,0.47619,0.50794,0.49206,0.50794,0.50794,0.50794,0.52381,0.50794,0.53968,0.50794,0.55556,0.50794,0.57143,0.50794,0.5873,0.50794,0.60317,0.50794,0.61905,0.50794,0.63492,0.50794,0.65079,0.50794,0.66667,0.50794,0.68254,0.50794,0.69841,0.50794,0.71429,0.50794,0.73016,0.50794,0.74603,0.50794,0.7619,0.50794,0.77778,0.50794,0.79365,0.50794,0.80952,0.50794};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.8254,0.50794,0.84127,0.50794,0.85714,0.50794,0.87302,0.50794,0.88889,0.50794,0.90476,0.50794,0.92063,0.50794,0.93651,0.50794,0.95238,0.50794,0.96825,0.50794,0.98413,0.50794,0.99609,0.50794,0.00391,0.52381,0.01587,0.52381,0.03175,0.52381,0.04762,0.52381,0.06349,0.52381,0.07937,0.52381,0.09524,0.52381,0.11111,0.52381,0.12698,0.52381,0.14286,0.52381,0.15873,0.52381,0.1746,0.52381,0.19048,0.52381,0.20635,0.52381,0.22222,0.52381,0.2381,0.52381,0.25397,0.52381,0.26984,0.52381,0.28571,0.52381,0.30159,0.52381,0.31746,0.52381,0.33333,0.52381,0.34921,0.52381,0.36508,0.52381,0.38095,0.52381,0.39683,0.52381,0.4127,0.52381,0.42857,0.52381,0.44444,0.52381,0.46032,0.52381,0.47619,0.52381,0.49206,0.52381,0.50794,0.52381,0.52381,0.52381,0.53968,0.52381,0.55556,0.52381,0.57143,0.52381,0.5873,0.52381,0.60317,0.52381,0.61905,0.52381,0.63492,0.52381,0.65079,0.52381,0.66667,0.52381,0.68254,0.52381,0.69841,0.52381,0.71429,0.52381,0.73016,0.52381,0.74603,0.52381,0.7619,0.52381,0.77778,0.52381,0.79365,0.52381,0.80952,0.52381,0.8254,0.52381,0.84127,0.52381,0.85714,0.52381,0.87302,0.52381,0.88889,0.52381,0.90476,0.52381,0.92063,0.52381,0.93651,0.52381,0.95238,0.52381,0.96825,0.52381,0.98413,0.52381,0.99609,0.52381,0.00391,0.53968,0.01587,0.53968,0.03175,0.53968,0.04762,0.53968,0.06349,0.53968,0.07937,0.53968,0.09524,0.53968,0.11111,0.53968,0.12698,0.53968,0.14286,0.53968,0.15873,0.53968,0.1746,0.53968,0.19048,0.53968,0.20635,0.53968,0.22222,0.53968,0.2381,0.53968,0.25397,0.53968,0.26984,0.53968,0.28571,0.53968,0.30159,0.53968,0.31746,0.53968,0.33333,0.53968,0.34921,0.53968,0.36508,0.53968};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.38095,0.53968,0.39683,0.53968,0.4127,0.53968,0.42857,0.53968,0.44444,0.53968,0.46032,0.53968,0.47619,0.53968,0.49206,0.53968,0.50794,0.53968,0.52381,0.53968,0.53968,0.53968,0.55556,0.53968,0.57143,0.53968,0.5873,0.53968,0.60317,0.53968,0.61905,0.53968,0.63492,0.53968,0.65079,0.53968,0.66667,0.53968,0.68254,0.53968,0.69841,0.53968,0.71429,0.53968,0.73016,0.53968,0.74603,0.53968,0.7619,0.53968,0.77778,0.53968,0.79365,0.53968,0.80952,0.53968,0.8254,0.53968,0.84127,0.53968,0.85714,0.53968,0.87302,0.53968,0.88889,0.53968,0.90476,0.53968,0.92063,0.53968,0.93651,0.53968,0.95238,0.53968,0.96825,0.53968,0.98413,0.53968,0.99609,0.53968,0.00391,0.55556,0.01587,0.55556,0.03175,0.55556,0.04762,0.55556,0.06349,0.55556,0.07937,0.55556,0.09524,0.55556,0.11111,0.55556,0.12698,0.55556,0.14286,0.55556,0.15873,0.55556,0.1746,0.55556,0.19048,0.55556,0.20635,0.55556,0.22222,0.55556,0.2381,0.55556,0.25397,0.55556,0.26984,0.55556,0.28571,0.55556,0.30159,0.55556,0.31746,0.55556,0.33333,0.55556,0.34921,0.55556,0.36508,0.55556,0.38095,0.55556,0.39683,0.55556,0.4127,0.55556,0.42857,0.55556,0.44444,0.55556,0.46032,0.55556,0.47619,0.55556,0.49206,0.55556,0.50794,0.55556,0.52381,0.55556,0.53968,0.55556,0.55556,0.55556,0.57143,0.55556,0.5873,0.55556,0.60317,0.55556,0.61905,0.55556,0.63492,0.55556,0.65079,0.55556,0.66667,0.55556,0.68254,0.55556,0.69841,0.55556,0.71429,0.55556,0.73016,0.55556,0.74603,0.55556,0.7619,0.55556,0.77778,0.55556,0.79365,0.55556,0.80952,0.55556,0.8254,0.55556,0.84127,0.55556,0.85714,0.55556,0.87302,0.55556,0.88889,0.55556,0.90476,0.55556,0.92063,0.55556,0.93651,0.55556};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.95238,0.55556,0.96825,0.55556,0.98413,0.55556,0.99609,0.55556,0.00391,0.57143,0.01587,0.57143,0.03175,0.57143,0.04762,0.57143,0.06349,0.57143,0.07937,0.57143,0.09524,0.57143,0.11111,0.57143,0.12698,0.57143,0.14286,0.57143,0.15873,0.57143,0.1746,0.57143,0.19048,0.57143,0.20635,0.57143,0.22222,0.57143,0.2381,0.57143,0.25397,0.57143,0.26984,0.57143,0.28571,0.57143,0.30159,0.57143,0.31746,0.57143,0.33333,0.57143,0.34921,0.57143,0.36508,0.57143,0.38095,0.57143,0.39683,0.57143,0.4127,0.57143,0.42857,0.57143,0.44444,0.57143,0.46032,0.57143,0.47619,0.57143,0.49206,0.57143,0.50794,0.57143,0.52381,0.57143,0.53968,0.57143,0.55556,0.57143,0.57143,0.57143,0.5873,0.57143,0.60317,0.57143,0.61905,0.57143,0.63492,0.57143,0.65079,0.57143,0.66667,0.57143,0.68254,0.57143,0.69841,0.57143,0.71429,0.57143,0.73016,0.57143,0.74603,0.57143,0.7619,0.57143,0.77778,0.57143,0.79365,0.57143,0.80952,0.57143,0.8254,0.57143,0.84127,0.57143,0.85714,0.57143,0.87302,0.57143,0.88889,0.57143,0.90476,0.57143,0.92063,0.57143,0.93651,0.57143,0.95238,0.57143,0.96825,0.57143,0.98413,0.57143,0.99609,0.57143,0.00391,0.5873,0.01587,0.5873,0.03175,0.5873,0.04762,0.5873,0.06349,0.5873,0.07937,0.5873,0.09524,0.5873,0.11111,0.5873,0.12698,0.5873,0.14286,0.5873,0.15873,0.5873,0.1746,0.5873,0.19048,0.5873,0.20635,0.5873,0.22222,0.5873,0.2381,0.5873,0.25397,0.5873,0.26984,0.5873,0.28571,0.5873,0.30159,0.5873,0.31746,0.5873,0.33333,0.5873,0.34921,0.5873,0.36508,0.5873,0.38095,0.5873,0.39683,0.5873,0.4127,0.5873,0.42857,0.5873,0.44444,0.5873,0.46032,0.5873,0.47619,0.5873,0.49206,0.5873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.50794,0.5873,0.52381,0.5873,0.53968,0.5873,0.55556,0.5873,0.57143,0.5873,0.5873,0.5873,0.60317,0.5873,0.61905,0.5873,0.63492,0.5873,0.65079,0.5873,0.66667,0.5873,0.68254,0.5873,0.69841,0.5873,0.71429,0.5873,0.73016,0.5873,0.74603,0.5873,0.7619,0.5873,0.77778,0.5873,0.79365,0.5873,0.80952,0.5873,0.8254,0.5873,0.84127,0.5873,0.85714,0.5873,0.87302,0.5873,0.88889,0.5873,0.90476,0.5873,0.92063,0.5873,0.93651,0.5873,0.95238,0.5873,0.96825,0.5873,0.98413,0.5873,0.99609,0.5873,0.00391,0.60317,0.01587,0.60317,0.03175,0.60317,0.04762,0.60317,0.06349,0.60317,0.07937,0.60317,0.09524,0.60317,0.11111,0.60317,0.12698,0.60317,0.14286,0.60317,0.15873,0.60317,0.1746,0.60317,0.19048,0.60317,0.20635,0.60317,0.22222,0.60317,0.2381,0.60317,0.25397,0.60317,0.26984,0.60317,0.28571,0.60317,0.30159,0.60317,0.31746,0.60317,0.33333,0.60317,0.34921,0.60317,0.36508,0.60317,0.38095,0.60317,0.39683,0.60317,0.4127,0.60317,0.42857,0.60317,0.44444,0.60317,0.46032,0.60317,0.47619,0.60317,0.49206,0.60317,0.50794,0.60317,0.52381,0.60317,0.53968,0.60317,0.55556,0.60317,0.57143,0.60317,0.5873,0.60317,0.60317,0.60317,0.61905,0.60317,0.63492,0.60317,0.65079,0.60317,0.66667,0.60317,0.68254,0.60317,0.69841,0.60317,0.71429,0.60317,0.73016,0.60317,0.74603,0.60317,0.7619,0.60317,0.77778,0.60317,0.79365,0.60317,0.80952,0.60317,0.8254,0.60317,0.84127,0.60317,0.85714,0.60317,0.87302,0.60317,0.88889,0.60317,0.90476,0.60317,0.92063,0.60317,0.93651,0.60317,0.95238,0.60317,0.96825,0.60317,0.98413,0.60317,0.99609,0.60317,0.00391,0.61905,0.01587,0.61905,0.03175,0.61905,0.04762,0.61905};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.06349,0.61905,0.07937,0.61905,0.09524,0.61905,0.11111,0.61905,0.12698,0.61905,0.14286,0.61905,0.15873,0.61905,0.1746,0.61905,0.19048,0.61905,0.20635,0.61905,0.22222,0.61905,0.2381,0.61905,0.25397,0.61905,0.26984,0.61905,0.28571,0.61905,0.30159,0.61905,0.31746,0.61905,0.33333,0.61905,0.34921,0.61905,0.36508,0.61905,0.38095,0.61905,0.39683,0.61905,0.4127,0.61905,0.42857,0.61905,0.44444,0.61905,0.46032,0.61905,0.47619,0.61905,0.49206,0.61905,0.50794,0.61905,0.52381,0.61905,0.53968,0.61905,0.55556,0.61905,0.57143,0.61905,0.5873,0.61905,0.60317,0.61905,0.61905,0.61905,0.63492,0.61905,0.65079,0.61905,0.66667,0.61905,0.68254,0.61905,0.69841,0.61905,0.71429,0.61905,0.73016,0.61905,0.74603,0.61905,0.7619,0.61905,0.77778,0.61905,0.79365,0.61905,0.80952,0.61905,0.8254,0.61905,0.84127,0.61905,0.85714,0.61905,0.87302,0.61905,0.88889,0.61905,0.90476,0.61905,0.92063,0.61905,0.93651,0.61905,0.95238,0.61905,0.96825,0.61905,0.98413,0.61905,0.99609,0.61905,0.00391,0.63492,0.01587,0.63492,0.03175,0.63492,0.04762,0.63492,0.06349,0.63492,0.07937,0.63492,0.09524,0.63492,0.11111,0.63492,0.12698,0.63492,0.14286,0.63492,0.15873,0.63492,0.1746,0.63492,0.19048,0.63492,0.20635,0.63492,0.22222,0.63492,0.2381,0.63492,0.25397,0.63492,0.26984,0.63492,0.28571,0.63492,0.30159,0.63492,0.31746,0.63492,0.33333,0.63492,0.34921,0.63492,0.36508,0.63492,0.38095,0.63492,0.39683,0.63492,0.4127,0.63492,0.42857,0.63492,0.44444,0.63492,0.46032,0.63492,0.47619,0.63492,0.49206,0.63492,0.50794,0.63492,0.52381,0.63492,0.53968,0.63492,0.55556,0.63492,0.57143,0.63492,0.5873,0.63492,0.60317,0.63492,0.61905,0.63492};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.63492,0.63492,0.65079,0.63492,0.66667,0.63492,0.68254,0.63492,0.69841,0.63492,0.71429,0.63492,0.73016,0.63492,0.74603,0.63492,0.7619,0.63492,0.77778,0.63492,0.79365,0.63492,0.80952,0.63492,0.8254,0.63492,0.84127,0.63492,0.85714,0.63492,0.87302,0.63492,0.88889,0.63492,0.90476,0.63492,0.92063,0.63492,0.93651,0.63492,0.95238,0.63492,0.96825,0.63492,0.98413,0.63492,0.99609,0.63492,0.00391,0.65079,0.01587,0.65079,0.03175,0.65079,0.04762,0.65079,0.06349,0.65079,0.07937,0.65079,0.09524,0.65079,0.11111,0.65079,0.12698,0.65079,0.14286,0.65079,0.15873,0.65079,0.1746,0.65079,0.19048,0.65079,0.20635,0.65079,0.22222,0.65079,0.2381,0.65079,0.25397,0.65079,0.26984,0.65079,0.28571,0.65079,0.30159,0.65079,0.31746,0.65079,0.33333,0.65079,0.34921,0.65079,0.36508,0.65079,0.38095,0.65079,0.39683,0.65079,0.4127,0.65079,0.42857,0.65079,0.44444,0.65079,0.46032,0.65079,0.47619,0.65079,0.49206,0.65079,0.50794,0.65079,0.52381,0.65079,0.53968,0.65079,0.55556,0.65079,0.57143,0.65079,0.5873,0.65079,0.60317,0.65079,0.61905,0.65079,0.63492,0.65079,0.65079,0.65079,0.66667,0.65079,0.68254,0.65079,0.69841,0.65079,0.71429,0.65079,0.73016,0.65079,0.74603,0.65079,0.7619,0.65079,0.77778,0.65079,0.79365,0.65079,0.80952,0.65079,0.8254,0.65079,0.84127,0.65079,0.85714,0.65079,0.87302,0.65079,0.88889,0.65079,0.90476,0.65079,0.92063,0.65079,0.93651,0.65079,0.95238,0.65079,0.96825,0.65079,0.98413,0.65079,0.99609,0.65079,0.00391,0.66667,0.01587,0.66667,0.03175,0.66667,0.04762,0.66667,0.06349,0.66667,0.07937,0.66667,0.09524,0.66667,0.11111,0.66667,0.12698,0.66667,0.14286,0.66667,0.15873,0.66667,0.1746,0.66667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.19048,0.66667,0.20635,0.66667,0.22222,0.66667,0.2381,0.66667,0.25397,0.66667,0.26984,0.66667,0.28571,0.66667,0.30159,0.66667,0.31746,0.66667,0.33333,0.66667,0.34921,0.66667,0.36508,0.66667,0.38095,0.66667,0.39683,0.66667,0.4127,0.66667,0.42857,0.66667,0.44444,0.66667,0.46032,0.66667,0.47619,0.66667,0.49206,0.66667,0.50794,0.66667,0.52381,0.66667,0.53968,0.66667,0.55556,0.66667,0.57143,0.66667,0.5873,0.66667,0.60317,0.66667,0.61905,0.66667,0.63492,0.66667,0.65079,0.66667,0.66667,0.66667,0.68254,0.66667,0.69841,0.66667,0.71429,0.66667,0.73016,0.66667,0.74603,0.66667,0.7619,0.66667,0.77778,0.66667,0.79365,0.66667,0.80952,0.66667,0.8254,0.66667,0.84127,0.66667,0.85714,0.66667,0.87302,0.66667,0.88889,0.66667,0.90476,0.66667,0.92063,0.66667,0.93651,0.66667,0.95238,0.66667,0.96825,0.66667,0.98413,0.66667,0.99609,0.66667,0.00391,0.68254,0.01587,0.68254,0.03175,0.68254,0.04762,0.68254,0.06349,0.68254,0.07937,0.68254,0.09524,0.68254,0.11111,0.68254,0.12698,0.68254,0.14286,0.68254,0.15873,0.68254,0.1746,0.68254,0.19048,0.68254,0.20635,0.68254,0.22222,0.68254,0.2381,0.68254,0.25397,0.68254,0.26984,0.68254,0.28571,0.68254,0.30159,0.68254,0.31746,0.68254,0.33333,0.68254,0.34921,0.68254,0.36508,0.68254,0.38095,0.68254,0.39683,0.68254,0.4127,0.68254,0.42857,0.68254,0.44444,0.68254,0.46032,0.68254,0.47619,0.68254,0.49206,0.68254,0.50794,0.68254,0.52381,0.68254,0.53968,0.68254,0.55556,0.68254,0.57143,0.68254,0.5873,0.68254,0.60317,0.68254,0.61905,0.68254,0.63492,0.68254,0.65079,0.68254,0.66667,0.68254,0.68254,0.68254,0.69841,0.68254,0.71429,0.68254,0.73016,0.68254,0.74603,0.68254};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.7619,0.68254,0.77778,0.68254,0.79365,0.68254,0.80952,0.68254,0.8254,0.68254,0.84127,0.68254,0.85714,0.68254,0.87302,0.68254,0.88889,0.68254,0.90476,0.68254,0.92063,0.68254,0.93651,0.68254,0.95238,0.68254,0.96825,0.68254,0.98413,0.68254,0.99609,0.68254,0.00391,0.69841,0.01587,0.69841,0.03175,0.69841,0.04762,0.69841,0.06349,0.69841,0.07937,0.69841,0.09524,0.69841,0.11111,0.69841,0.12698,0.69841,0.14286,0.69841,0.15873,0.69841,0.1746,0.69841,0.19048,0.69841,0.20635,0.69841,0.22222,0.69841,0.2381,0.69841,0.25397,0.69841,0.26984,0.69841,0.28571,0.69841,0.30159,0.69841,0.31746,0.69841,0.33333,0.69841,0.34921,0.69841,0.36508,0.69841,0.38095,0.69841,0.39683,0.69841,0.4127,0.69841,0.42857,0.69841,0.44444,0.69841,0.46032,0.69841,0.47619,0.69841,0.49206,0.69841,0.50794,0.69841,0.52381,0.69841,0.53968,0.69841,0.55556,0.69841,0.57143,0.69841,0.5873,0.69841,0.60317,0.69841,0.61905,0.69841,0.63492,0.69841,0.65079,0.69841,0.66667,0.69841,0.68254,0.69841,0.69841,0.69841,0.71429,0.69841,0.73016,0.69841,0.74603,0.69841,0.7619,0.69841,0.77778,0.69841,0.79365,0.69841,0.80952,0.69841,0.8254,0.69841,0.84127,0.69841,0.85714,0.69841,0.87302,0.69841,0.88889,0.69841,0.90476,0.69841,0.92063,0.69841,0.93651,0.69841,0.95238,0.69841,0.96825,0.69841,0.98413,0.69841,0.99609,0.69841,0.00391,0.71429,0.01587,0.71429,0.03175,0.71429,0.04762,0.71429,0.06349,0.71429,0.07937,0.71429,0.09524,0.71429,0.11111,0.71429,0.12698,0.71429,0.14286,0.71429,0.15873,0.71429,0.1746,0.71429,0.19048,0.71429,0.20635,0.71429,0.22222,0.71429,0.2381,0.71429,0.25397,0.71429,0.26984,0.71429,0.28571,0.71429,0.30159,0.71429};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.31746,0.71429,0.33333,0.71429,0.34921,0.71429,0.36508,0.71429,0.38095,0.71429,0.39683,0.71429,0.4127,0.71429,0.42857,0.71429,0.44444,0.71429,0.46032,0.71429,0.47619,0.71429,0.49206,0.71429,0.50794,0.71429,0.52381,0.71429,0.53968,0.71429,0.55556,0.71429,0.57143,0.71429,0.5873,0.71429,0.60317,0.71429,0.61905,0.71429,0.63492,0.71429,0.65079,0.71429,0.66667,0.71429,0.68254,0.71429,0.69841,0.71429,0.71429,0.71429,0.73016,0.71429,0.74603,0.71429,0.7619,0.71429,0.77778,0.71429,0.79365,0.71429,0.80952,0.71429,0.8254,0.71429,0.84127,0.71429,0.85714,0.71429,0.87302,0.71429,0.88889,0.71429,0.90476,0.71429,0.92063,0.71429,0.93651,0.71429,0.95238,0.71429,0.96825,0.71429,0.98413,0.71429,0.99609,0.71429,0.00391,0.73016,0.01587,0.73016,0.03175,0.73016,0.04762,0.73016,0.06349,0.73016,0.07937,0.73016,0.09524,0.73016,0.11111,0.73016,0.12698,0.73016,0.14286,0.73016,0.15873,0.73016,0.1746,0.73016,0.19048,0.73016,0.20635,0.73016,0.22222,0.73016,0.2381,0.73016,0.25397,0.73016,0.26984,0.73016,0.28571,0.73016,0.30159,0.73016,0.31746,0.73016,0.33333,0.73016,0.34921,0.73016,0.36508,0.73016,0.38095,0.73016,0.39683,0.73016,0.4127,0.73016,0.42857,0.73016,0.44444,0.73016,0.46032,0.73016,0.47619,0.73016,0.49206,0.73016,0.50794,0.73016,0.52381,0.73016,0.53968,0.73016,0.55556,0.73016,0.57143,0.73016,0.5873,0.73016,0.60317,0.73016,0.61905,0.73016,0.63492,0.73016,0.65079,0.73016,0.66667,0.73016,0.68254,0.73016,0.69841,0.73016,0.71429,0.73016,0.73016,0.73016,0.74603,0.73016,0.7619,0.73016,0.77778,0.73016,0.79365,0.73016,0.80952,0.73016,0.8254,0.73016,0.84127,0.73016,0.85714,0.73016,0.87302,0.73016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.88889,0.73016,0.90476,0.73016,0.92063,0.73016,0.93651,0.73016,0.95238,0.73016,0.96825,0.73016,0.98413,0.73016,0.99609,0.73016,0.00391,0.74603,0.01587,0.74603,0.03175,0.74603,0.04762,0.74603,0.06349,0.74603,0.07937,0.74603,0.09524,0.74603,0.11111,0.74603,0.12698,0.74603,0.14286,0.74603,0.15873,0.74603,0.1746,0.74603,0.19048,0.74603,0.20635,0.74603,0.22222,0.74603,0.2381,0.74603,0.25397,0.74603,0.26984,0.74603,0.28571,0.74603,0.30159,0.74603,0.31746,0.74603,0.33333,0.74603,0.34921,0.74603,0.36508,0.74603,0.38095,0.74603,0.39683,0.74603,0.4127,0.74603,0.42857,0.74603,0.44444,0.74603,0.46032,0.74603,0.47619,0.74603,0.49206,0.74603,0.50794,0.74603,0.52381,0.74603,0.53968,0.74603,0.55556,0.74603,0.57143,0.74603,0.5873,0.74603,0.60317,0.74603,0.61905,0.74603,0.63492,0.74603,0.65079,0.74603,0.66667,0.74603,0.68254,0.74603,0.69841,0.74603,0.71429,0.74603,0.73016,0.74603,0.74603,0.74603,0.7619,0.74603,0.77778,0.74603,0.79365,0.74603,0.80952,0.74603,0.8254,0.74603,0.84127,0.74603,0.85714,0.74603,0.87302,0.74603,0.88889,0.74603,0.90476,0.74603,0.92063,0.74603,0.93651,0.74603,0.95238,0.74603,0.96825,0.74603,0.98413,0.74603,0.99609,0.74603,0.00391,0.7619,0.01587,0.7619,0.03175,0.7619,0.04762,0.7619,0.06349,0.7619,0.07937,0.7619,0.09524,0.7619,0.11111,0.7619,0.12698,0.7619,0.14286,0.7619,0.15873,0.7619,0.1746,0.7619,0.19048,0.7619,0.20635,0.7619,0.22222,0.7619,0.2381,0.7619,0.25397,0.7619,0.26984,0.7619,0.28571,0.7619,0.30159,0.7619,0.31746,0.7619,0.33333,0.7619,0.34921,0.7619,0.36508,0.7619,0.38095,0.7619,0.39683,0.7619,0.4127,0.7619,0.42857,0.7619};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.44444,0.7619,0.46032,0.7619,0.47619,0.7619,0.49206,0.7619,0.50794,0.7619,0.52381,0.7619,0.53968,0.7619,0.55556,0.7619,0.57143,0.7619,0.5873,0.7619,0.60317,0.7619,0.61905,0.7619,0.63492,0.7619,0.65079,0.7619,0.66667,0.7619,0.68254,0.7619,0.69841,0.7619,0.71429,0.7619,0.73016,0.7619,0.74603,0.7619,0.7619,0.7619,0.77778,0.7619,0.79365,0.7619,0.80952,0.7619,0.8254,0.7619,0.84127,0.7619,0.85714,0.7619,0.87302,0.7619,0.88889,0.7619,0.90476,0.7619,0.92063,0.7619,0.93651,0.7619,0.95238,0.7619,0.96825,0.7619,0.98413,0.7619,0.99609,0.7619,0.00391,0.77778,0.01587,0.77778,0.03175,0.77778,0.04762,0.77778,0.06349,0.77778,0.07937,0.77778,0.09524,0.77778,0.11111,0.77778,0.12698,0.77778,0.14286,0.77778,0.15873,0.77778,0.1746,0.77778,0.19048,0.77778,0.20635,0.77778,0.22222,0.77778,0.2381,0.77778,0.25397,0.77778,0.26984,0.77778,0.28571,0.77778,0.30159,0.77778,0.31746,0.77778,0.33333,0.77778,0.34921,0.77778,0.36508,0.77778,0.38095,0.77778,0.39683,0.77778,0.4127,0.77778,0.42857,0.77778,0.44444,0.77778,0.46032,0.77778,0.47619,0.77778,0.49206,0.77778,0.50794,0.77778,0.52381,0.77778,0.53968,0.77778,0.55556,0.77778,0.57143,0.77778,0.5873,0.77778,0.60317,0.77778,0.61905,0.77778,0.63492,0.77778,0.65079,0.77778,0.66667,0.77778,0.68254,0.77778,0.69841,0.77778,0.71429,0.77778,0.73016,0.77778,0.74603,0.77778,0.7619,0.77778,0.77778,0.77778,0.79365,0.77778,0.80952,0.77778,0.8254,0.77778,0.84127,0.77778,0.85714,0.77778,0.87302,0.77778,0.88889,0.77778,0.90476,0.77778,0.92063,0.77778,0.93651,0.77778,0.95238,0.77778,0.96825,0.77778,0.98413,0.77778,0.99609,0.77778};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.79365,0.01587,0.79365,0.03175,0.79365,0.04762,0.79365,0.06349,0.79365,0.07937,0.79365,0.09524,0.79365,0.11111,0.79365,0.12698,0.79365,0.14286,0.79365,0.15873,0.79365,0.1746,0.79365,0.19048,0.79365,0.20635,0.79365,0.22222,0.79365,0.2381,0.79365,0.25397,0.79365,0.26984,0.79365,0.28571,0.79365,0.30159,0.79365,0.31746,0.79365,0.33333,0.79365,0.34921,0.79365,0.36508,0.79365,0.38095,0.79365,0.39683,0.79365,0.4127,0.79365,0.42857,0.79365,0.44444,0.79365,0.46032,0.79365,0.47619,0.79365,0.49206,0.79365,0.50794,0.79365,0.52381,0.79365,0.53968,0.79365,0.55556,0.79365,0.57143,0.79365,0.5873,0.79365,0.60317,0.79365,0.61905,0.79365,0.63492,0.79365,0.65079,0.79365,0.66667,0.79365,0.68254,0.79365,0.69841,0.79365,0.71429,0.79365,0.73016,0.79365,0.74603,0.79365,0.7619,0.79365,0.77778,0.79365,0.79365,0.79365,0.80952,0.79365,0.8254,0.79365,0.84127,0.79365,0.85714,0.79365,0.87302,0.79365,0.88889,0.79365,0.90476,0.79365,0.92063,0.79365,0.93651,0.79365,0.95238,0.79365,0.96825,0.79365,0.98413,0.79365,0.99609,0.79365,0.00391,0.80952,0.01587,0.80952,0.03175,0.80952,0.04762,0.80952,0.06349,0.80952,0.07937,0.80952,0.09524,0.80952,0.11111,0.80952,0.12698,0.80952,0.14286,0.80952,0.15873,0.80952,0.1746,0.80952,0.19048,0.80952,0.20635,0.80952,0.22222,0.80952,0.2381,0.80952,0.25397,0.80952,0.26984,0.80952,0.28571,0.80952,0.30159,0.80952,0.31746,0.80952,0.33333,0.80952,0.34921,0.80952,0.36508,0.80952,0.38095,0.80952,0.39683,0.80952,0.4127,0.80952,0.42857,0.80952,0.44444,0.80952,0.46032,0.80952,0.47619,0.80952,0.49206,0.80952,0.50794,0.80952,0.52381,0.80952,0.53968,0.80952,0.55556,0.80952};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.57143,0.80952,0.5873,0.80952,0.60317,0.80952,0.61905,0.80952,0.63492,0.80952,0.65079,0.80952,0.66667,0.80952,0.68254,0.80952,0.69841,0.80952,0.71429,0.80952,0.73016,0.80952,0.74603,0.80952,0.7619,0.80952,0.77778,0.80952,0.79365,0.80952,0.80952,0.80952,0.8254,0.80952,0.84127,0.80952,0.85714,0.80952,0.87302,0.80952,0.88889,0.80952,0.90476,0.80952,0.92063,0.80952,0.93651,0.80952,0.95238,0.80952,0.96825,0.80952,0.98413,0.80952,0.99609,0.80952,0.00391,0.8254,0.01587,0.8254,0.03175,0.8254,0.04762,0.8254,0.06349,0.8254,0.07937,0.8254,0.09524,0.8254,0.11111,0.8254,0.12698,0.8254,0.14286,0.8254,0.15873,0.8254,0.1746,0.8254,0.19048,0.8254,0.20635,0.8254,0.22222,0.8254,0.2381,0.8254,0.25397,0.8254,0.26984,0.8254,0.28571,0.8254,0.30159,0.8254,0.31746,0.8254,0.33333,0.8254,0.34921,0.8254,0.36508,0.8254,0.38095,0.8254,0.39683,0.8254,0.4127,0.8254,0.42857,0.8254,0.44444,0.8254,0.46032,0.8254,0.47619,0.8254,0.49206,0.8254,0.50794,0.8254,0.52381,0.8254,0.53968,0.8254,0.55556,0.8254,0.57143,0.8254,0.5873,0.8254,0.60317,0.8254,0.61905,0.8254,0.63492,0.8254,0.65079,0.8254,0.66667,0.8254,0.68254,0.8254,0.69841,0.8254,0.71429,0.8254,0.73016,0.8254,0.74603,0.8254,0.7619,0.8254,0.77778,0.8254,0.79365,0.8254,0.80952,0.8254,0.8254,0.8254,0.84127,0.8254,0.85714,0.8254,0.87302,0.8254,0.88889,0.8254,0.90476,0.8254,0.92063,0.8254,0.93651,0.8254,0.95238,0.8254,0.96825,0.8254,0.98413,0.8254,0.99609,0.8254,0.00391,0.84127,0.01587,0.84127,0.03175,0.84127,0.04762,0.84127,0.06349,0.84127,0.07937,0.84127,0.09524,0.84127,0.11111,0.84127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.12698,0.84127,0.14286,0.84127,0.15873,0.84127,0.1746,0.84127,0.19048,0.84127,0.20635,0.84127,0.22222,0.84127,0.2381,0.84127,0.25397,0.84127,0.26984,0.84127,0.28571,0.84127,0.30159,0.84127,0.31746,0.84127,0.33333,0.84127,0.34921,0.84127,0.36508,0.84127,0.38095,0.84127,0.39683,0.84127,0.4127,0.84127,0.42857,0.84127,0.44444,0.84127,0.46032,0.84127,0.47619,0.84127,0.49206,0.84127,0.50794,0.84127,0.52381,0.84127,0.53968,0.84127,0.55556,0.84127,0.57143,0.84127,0.5873,0.84127,0.60317,0.84127,0.61905,0.84127,0.63492,0.84127,0.65079,0.84127,0.66667,0.84127,0.68254,0.84127,0.69841,0.84127,0.71429,0.84127,0.73016,0.84127,0.74603,0.84127,0.7619,0.84127,0.77778,0.84127,0.79365,0.84127,0.80952,0.84127,0.8254,0.84127,0.84127,0.84127,0.85714,0.84127,0.87302,0.84127,0.88889,0.84127,0.90476,0.84127,0.92063,0.84127,0.93651,0.84127,0.95238,0.84127,0.96825,0.84127,0.98413,0.84127,0.99609,0.84127,0.00391,0.85714,0.01587,0.85714,0.03175,0.85714,0.04762,0.85714,0.06349,0.85714,0.07937,0.85714,0.09524,0.85714,0.11111,0.85714,0.12698,0.85714,0.14286,0.85714,0.15873,0.85714,0.1746,0.85714,0.19048,0.85714,0.20635,0.85714,0.22222,0.85714,0.2381,0.85714,0.25397,0.85714,0.26984,0.85714,0.28571,0.85714,0.30159,0.85714,0.31746,0.85714,0.33333,0.85714,0.34921,0.85714,0.36508,0.85714,0.38095,0.85714,0.39683,0.85714,0.4127,0.85714,0.42857,0.85714,0.44444,0.85714,0.46032,0.85714,0.47619,0.85714,0.49206,0.85714,0.50794,0.85714,0.52381,0.85714,0.53968,0.85714,0.55556,0.85714,0.57143,0.85714,0.5873,0.85714,0.60317,0.85714,0.61905,0.85714,0.63492,0.85714,0.65079,0.85714,0.66667,0.85714,0.68254,0.85714};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.69841,0.85714,0.71429,0.85714,0.73016,0.85714,0.74603,0.85714,0.7619,0.85714,0.77778,0.85714,0.79365,0.85714,0.80952,0.85714,0.8254,0.85714,0.84127,0.85714,0.85714,0.85714,0.87302,0.85714,0.88889,0.85714,0.90476,0.85714,0.92063,0.85714,0.93651,0.85714,0.95238,0.85714,0.96825,0.85714,0.98413,0.85714,0.99609,0.85714,0.00391,0.87302,0.01587,0.87302,0.03175,0.87302,0.04762,0.87302,0.06349,0.87302,0.07937,0.87302,0.09524,0.87302,0.11111,0.87302,0.12698,0.87302,0.14286,0.87302,0.15873,0.87302,0.1746,0.87302,0.19048,0.87302,0.20635,0.87302,0.22222,0.87302,0.2381,0.87302,0.25397,0.87302,0.26984,0.87302,0.28571,0.87302,0.30159,0.87302,0.31746,0.87302,0.33333,0.87302,0.34921,0.87302,0.36508,0.87302,0.38095,0.87302,0.39683,0.87302,0.4127,0.87302,0.42857,0.87302,0.44444,0.87302,0.46032,0.87302,0.47619,0.87302,0.49206,0.87302,0.50794,0.87302,0.52381,0.87302,0.53968,0.87302,0.55556,0.87302,0.57143,0.87302,0.5873,0.87302,0.60317,0.87302,0.61905,0.87302,0.63492,0.87302,0.65079,0.87302,0.66667,0.87302,0.68254,0.87302,0.69841,0.87302,0.71429,0.87302,0.73016,0.87302,0.74603,0.87302,0.7619,0.87302,0.77778,0.87302,0.79365,0.87302,0.80952,0.87302,0.8254,0.87302,0.84127,0.87302,0.85714,0.87302,0.87302,0.87302,0.88889,0.87302,0.90476,0.87302,0.92063,0.87302,0.93651,0.87302,0.95238,0.87302,0.96825,0.87302,0.98413,0.87302,0.99609,0.87302,0.00391,0.88889,0.01587,0.88889,0.03175,0.88889,0.04762,0.88889,0.06349,0.88889,0.07937,0.88889,0.09524,0.88889,0.11111,0.88889,0.12698,0.88889,0.14286,0.88889,0.15873,0.88889,0.1746,0.88889,0.19048,0.88889,0.20635,0.88889,0.22222,0.88889,0.2381,0.88889};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.25397,0.88889,0.26984,0.88889,0.28571,0.88889,0.30159,0.88889,0.31746,0.88889,0.33333,0.88889,0.34921,0.88889,0.36508,0.88889,0.38095,0.88889,0.39683,0.88889,0.4127,0.88889,0.42857,0.88889,0.44444,0.88889,0.46032,0.88889,0.47619,0.88889,0.49206,0.88889,0.50794,0.88889,0.52381,0.88889,0.53968,0.88889,0.55556,0.88889,0.57143,0.88889,0.5873,0.88889,0.60317,0.88889,0.61905,0.88889,0.63492,0.88889,0.65079,0.88889,0.66667,0.88889,0.68254,0.88889,0.69841,0.88889,0.71429,0.88889,0.73016,0.88889,0.74603,0.88889,0.7619,0.88889,0.77778,0.88889,0.79365,0.88889,0.80952,0.88889,0.8254,0.88889,0.84127,0.88889,0.85714,0.88889,0.87302,0.88889,0.88889,0.88889,0.90476,0.88889,0.92063,0.88889,0.93651,0.88889,0.95238,0.88889,0.96825,0.88889,0.98413,0.88889,0.99609,0.88889,0.00391,0.90476,0.01587,0.90476,0.03175,0.90476,0.04762,0.90476,0.06349,0.90476,0.07937,0.90476,0.09524,0.90476,0.11111,0.90476,0.12698,0.90476,0.14286,0.90476,0.15873,0.90476,0.1746,0.90476,0.19048,0.90476,0.20635,0.90476,0.22222,0.90476,0.2381,0.90476,0.25397,0.90476,0.26984,0.90476,0.28571,0.90476,0.30159,0.90476,0.31746,0.90476,0.33333,0.90476,0.34921,0.90476,0.36508,0.90476,0.38095,0.90476,0.39683,0.90476,0.4127,0.90476,0.42857,0.90476,0.44444,0.90476,0.46032,0.90476,0.47619,0.90476,0.49206,0.90476,0.50794,0.90476,0.52381,0.90476,0.53968,0.90476,0.55556,0.90476,0.57143,0.90476,0.5873,0.90476,0.60317,0.90476,0.61905,0.90476,0.63492,0.90476,0.65079,0.90476,0.66667,0.90476,0.68254,0.90476,0.69841,0.90476,0.71429,0.90476,0.73016,0.90476,0.74603,0.90476,0.7619,0.90476,0.77778,0.90476,0.79365,0.90476,0.80952,0.90476};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.8254,0.90476,0.84127,0.90476,0.85714,0.90476,0.87302,0.90476,0.88889,0.90476,0.90476,0.90476,0.92063,0.90476,0.93651,0.90476,0.95238,0.90476,0.96825,0.90476,0.98413,0.90476,0.99609,0.90476,0.00391,0.92063,0.01587,0.92063,0.03175,0.92063,0.04762,0.92063,0.06349,0.92063,0.07937,0.92063,0.09524,0.92063,0.11111,0.92063,0.12698,0.92063,0.14286,0.92063,0.15873,0.92063,0.1746,0.92063,0.19048,0.92063,0.20635,0.92063,0.22222,0.92063,0.2381,0.92063,0.25397,0.92063,0.26984,0.92063,0.28571,0.92063,0.30159,0.92063,0.31746,0.92063,0.33333,0.92063,0.34921,0.92063,0.36508,0.92063,0.38095,0.92063,0.39683,0.92063,0.4127,0.92063,0.42857,0.92063,0.44444,0.92063,0.46032,0.92063,0.47619,0.92063,0.49206,0.92063,0.50794,0.92063,0.52381,0.92063,0.53968,0.92063,0.55556,0.92063,0.57143,0.92063,0.5873,0.92063,0.60317,0.92063,0.61905,0.92063,0.63492,0.92063,0.65079,0.92063,0.66667,0.92063,0.68254,0.92063,0.69841,0.92063,0.71429,0.92063,0.73016,0.92063,0.74603,0.92063,0.7619,0.92063,0.77778,0.92063,0.79365,0.92063,0.80952,0.92063,0.8254,0.92063,0.84127,0.92063,0.85714,0.92063,0.87302,0.92063,0.88889,0.92063,0.90476,0.92063,0.92063,0.92063,0.93651,0.92063,0.95238,0.92063,0.96825,0.92063,0.98413,0.92063,0.99609,0.92063,0.00391,0.93651,0.01587,0.93651,0.03175,0.93651,0.04762,0.93651,0.06349,0.93651,0.07937,0.93651,0.09524,0.93651,0.11111,0.93651,0.12698,0.93651,0.14286,0.93651,0.15873,0.93651,0.1746,0.93651,0.19048,0.93651,0.20635,0.93651,0.22222,0.93651,0.2381,0.93651,0.25397,0.93651,0.26984,0.93651,0.28571,0.93651,0.30159,0.93651,0.31746,0.93651,0.33333,0.93651,0.34921,0.93651,0.36508,0.93651};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.38095,0.93651,0.39683,0.93651,0.4127,0.93651,0.42857,0.93651,0.44444,0.93651,0.46032,0.93651,0.47619,0.93651,0.49206,0.93651,0.50794,0.93651,0.52381,0.93651,0.53968,0.93651,0.55556,0.93651,0.57143,0.93651,0.5873,0.93651,0.60317,0.93651,0.61905,0.93651,0.63492,0.93651,0.65079,0.93651,0.66667,0.93651,0.68254,0.93651,0.69841,0.93651,0.71429,0.93651,0.73016,0.93651,0.74603,0.93651,0.7619,0.93651,0.77778,0.93651,0.79365,0.93651,0.80952,0.93651,0.8254,0.93651,0.84127,0.93651,0.85714,0.93651,0.87302,0.93651,0.88889,0.93651,0.90476,0.93651,0.92063,0.93651,0.93651,0.93651,0.95238,0.93651,0.96825,0.93651,0.98413,0.93651,0.99609,0.93651,0.00391,0.95238,0.01587,0.95238,0.03175,0.95238,0.04762,0.95238,0.06349,0.95238,0.07937,0.95238,0.09524,0.95238,0.11111,0.95238,0.12698,0.95238,0.14286,0.95238,0.15873,0.95238,0.1746,0.95238,0.19048,0.95238,0.20635,0.95238,0.22222,0.95238,0.2381,0.95238,0.25397,0.95238,0.26984,0.95238,0.28571,0.95238,0.30159,0.95238,0.31746,0.95238,0.33333,0.95238,0.34921,0.95238,0.36508,0.95238,0.38095,0.95238,0.39683,0.95238,0.4127,0.95238,0.42857,0.95238,0.44444,0.95238,0.46032,0.95238,0.47619,0.95238,0.49206,0.95238,0.50794,0.95238,0.52381,0.95238,0.53968,0.95238,0.55556,0.95238,0.57143,0.95238,0.5873,0.95238,0.60317,0.95238,0.61905,0.95238,0.63492,0.95238,0.65079,0.95238,0.66667,0.95238,0.68254,0.95238,0.69841,0.95238,0.71429,0.95238,0.73016,0.95238,0.74603,0.95238,0.7619,0.95238,0.77778,0.95238,0.79365,0.95238,0.80952,0.95238,0.8254,0.95238,0.84127,0.95238,0.85714,0.95238,0.87302,0.95238,0.88889,0.95238,0.90476,0.95238,0.92063,0.95238,0.93651,0.95238};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.95238,0.95238,0.96825,0.95238,0.98413,0.95238,0.99609,0.95238,0.00391,0.96825,0.01587,0.96825,0.03175,0.96825,0.04762,0.96825,0.06349,0.96825,0.07937,0.96825,0.09524,0.96825,0.11111,0.96825,0.12698,0.96825,0.14286,0.96825,0.15873,0.96825,0.1746,0.96825,0.19048,0.96825,0.20635,0.96825,0.22222,0.96825,0.2381,0.96825,0.25397,0.96825,0.26984,0.96825,0.28571,0.96825,0.30159,0.96825,0.31746,0.96825,0.33333,0.96825,0.34921,0.96825,0.36508,0.96825,0.38095,0.96825,0.39683,0.96825,0.4127,0.96825,0.42857,0.96825,0.44444,0.96825,0.46032,0.96825,0.47619,0.96825,0.49206,0.96825,0.50794,0.96825,0.52381,0.96825,0.53968,0.96825,0.55556,0.96825,0.57143,0.96825,0.5873,0.96825,0.60317,0.96825,0.61905,0.96825,0.63492,0.96825,0.65079,0.96825,0.66667,0.96825,0.68254,0.96825,0.69841,0.96825,0.71429,0.96825,0.73016,0.96825,0.74603,0.96825,0.7619,0.96825,0.77778,0.96825,0.79365,0.96825,0.80952,0.96825,0.8254,0.96825,0.84127,0.96825,0.85714,0.96825,0.87302,0.96825,0.88889,0.96825,0.90476,0.96825,0.92063,0.96825,0.93651,0.96825,0.95238,0.96825,0.96825,0.96825,0.98413,0.96825,0.99609,0.96825,0.00391,0.98413,0.01587,0.98413,0.03175,0.98413,0.04762,0.98413,0.06349,0.98413,0.07937,0.98413,0.09524,0.98413,0.11111,0.98413,0.12698,0.98413,0.14286,0.98413,0.15873,0.98413,0.1746,0.98413,0.19048,0.98413,0.20635,0.98413,0.22222,0.98413,0.2381,0.98413,0.25397,0.98413,0.26984,0.98413,0.28571,0.98413,0.30159,0.98413,0.31746,0.98413,0.33333,0.98413,0.34921,0.98413,0.36508,0.98413,0.38095,0.98413,0.39683,0.98413,0.4127,0.98413,0.42857,0.98413,0.44444,0.98413,0.46032,0.98413,0.47619,0.98413,0.49206,0.98413};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.50794,0.98413,0.52381,0.98413,0.53968,0.98413,0.55556,0.98413,0.57143,0.98413,0.5873,0.98413,0.60317,0.98413,0.61905,0.98413,0.63492,0.98413,0.65079,0.98413,0.66667,0.98413,0.68254,0.98413,0.69841,0.98413,0.71429,0.98413,0.73016,0.98413,0.74603,0.98413,0.7619,0.98413,0.77778,0.98413,0.79365,0.98413,0.80952,0.98413,0.8254,0.98413,0.84127,0.98413,0.85714,0.98413,0.87302,0.98413,0.88889,0.98413,0.90476,0.98413,0.92063,0.98413,0.93651,0.98413,0.95238,0.98413,0.96825,0.98413,0.98413,0.98413,0.99609,0.98413,0.00391,0.99609,0.01587,0.99609,0.03175,0.99609,0.04762,0.99609,0.06349,0.99609,0.07937,0.99609,0.09524,0.99609,0.11111,0.99609,0.12698,0.99609,0.14286,0.99609,0.15873,0.99609,0.1746,0.99609,0.19048,0.99609,0.20635,0.99609,0.22222,0.99609,0.2381,0.99609,0.25397,0.99609,0.26984,0.99609,0.28571,0.99609,0.30159,0.99609,0.31746,0.99609,0.33333,0.99609,0.34921,0.99609,0.36508,0.99609,0.38095,0.99609,0.39683,0.99609,0.4127,0.99609,0.42857,0.99609,0.44444,0.99609,0.46032,0.99609,0.47619,0.99609,0.49206,0.99609,0.50794,0.99609,0.52381,0.99609,0.53968,0.99609,0.55556,0.99609,0.57143,0.99609,0.5873,0.99609,0.60317,0.99609,0.61905,0.99609,0.63492,0.99609,0.65079,0.99609,0.66667,0.99609,0.68254,0.99609,0.69841,0.99609,0.71429,0.99609,0.73016,0.99609,0.74603,0.99609,0.7619,0.99609,0.77778,0.99609,0.79365,0.99609,0.80952,0.99609,0.8254,0.99609,0.84127,0.99609,0.85714,0.99609,0.87302,0.99609,0.88889,0.99609,0.90476,0.99609,0.92063,0.99609,0.93651,0.99609,0.95238,0.99609,0.96825,0.99609,0.98413,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 4096 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 8192 total numbers made up of 4096 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD022 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD022().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD022\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD022 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD022_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD022_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD022_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD022_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
