package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD021Index.html" target="_blank">MarsLOD021</a>,  source <a href="../../../Geospatial/MarsLOD021.java">MarsLOD021.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD021.x3d">MarsLOD021.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD021.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD021.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD021
{
	/** Default constructor to create this object. */
	public MarsLOD021 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD021.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD021.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD021.x3d"))
    .addChild(new GeoLOD().setCenter(45.000000,135.000000,-28175.000000).setRange(3.6E7).setChild1Url(new String[] {"MarsLOD022.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD022.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars007.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars007.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,90.000000,0.000000).setSolid(false).setXDimension(32).setXSpacing(2.903226).setYScale(50.0).setZDimension(32).setZSpacing(2.903226).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {39.084858,282.788,387.9909,674.91724,372.6384,20.41758,-547.06384,-619.8989,-250.39296,239.92792,534.36127,876.9392,352.05145,-625.56104,-911.2202,-1950.1691,-2427.954,-2426.8936,-2548.037,-2445.3342,-2282.4807,-2458.5657,-2205.5034,-2245.136,-2705.8904,-2822.843,-2891.253,-2934.0051,-2990.9263,-2967.4321,-2924.6506,-2733.158,-2151.8743,-1362.5822,-299.6246,-210.87648,-367.67435,-977.0241,-965.1117,-645.6234,-187.92233,216.3642,569.16437,20.064873,-1640.1727,-1609.5747,-1720.0065,-2232.1133,-2540.722,-2654.9043,-2566.1887,-2610.9011,-2656.389,-2652.088,-2430.3494,-2595.5132,-2765.7786,-2831.9993,-2886.8313,-2926.4446,-2950.5488,-2915.5842,-3019.9119,-3033.5442,-3783.3306,-3422.9868,-2273.5745,-1249.2485,-1187.2643,-1368.1145,-976.1667,-485.61557,-88.829094,-15.130377,505.38638,-612.1862,-1735.8993,-1976.6296,-2204.3384,-2407.9058,-2638.8857,-2715.7805,-2712.1135,-2659.7478,-2701.1816,-2729.9778,-2683.3157,-2689.5254,-2722.0383,-2711.196,-2779.2415,-2863.6797,-2903.7754,-2912.0894,-3026.4297,-3061.9802,-3804.5151,-3733.4016,-3429.485,-2557.0522};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {-1933.6799,-1561.5945,-736.49945,-394.761,-391.09045,-914.78455,-775.8884,-1501.5239,-2251.3867,-2431.6506,-2526.061,-2657.1382,-2687.226,-2626.4683,-2629.508,-2568.533,-2518.3655,-2653.3704,-2667.4167,-2588.1262,-2559.3337,-2556.7393,-2700.4639,-2789.7646,-2860.4727,-2931.9788,-3021.481,-3077.076,-3759.863,-3727.7114,-3669.325,-3122.6252,-2199.1487,-1388.1838,-1261.2715,-1211.6024,-1782.2146,-2113.4941,-2261.375,-2439.2402,-2732.8716,-2974.7734,-2881.6338,-2839.2754,-2800.2222,-2460.2366,-2200.2146,-1945.4448,-2007.5168,-2114.331,-2245.2207,-2300.3643,-2320.6006,-2154.2646,-2334.489,-2643.0735,-2718.3594,-2854.612,-2975.909,-2866.0151,-3745.9153,-3694.8813,-3632.5776,-3283.3865,-2756.6602,-2346.1267,-2237.7664,-2271.2585,-2361.0159,-2579.165,-2815.7866,-3011.7449,-3163.4666,-3295.2268,-3362.1257,-3183.252,-2792.0955,-2078.982,-1362.5536,-848.6408,-800.88135,-1137.6266,-1701.5251,-1927.8776,-2018.3986,-2088.467,-2131.835,-2422.099,-2687.1218,-2733.558,-2927.027,-2776.981,-3674.609,-3644.0078,-3566.8413,-3346.0476,-3089.9883,-2994.6519,-2907.423,-2900.8804};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {-3002.4556,-3138.9158,-3271.5483,-3374.261,-3433.3804,-3500.836,-3506.398,-3440.6404,-2815.0686,-1801.12,-653.43805,131.60252,479.236,136.88733,-1088.6006,-1577.671,-1669.706,-1884.4132,-2168.0933,-2442.9854,-2522.6077,-2678.942,-3058.2195,-2904.7444,-3555.016,-3536.2764,-3525.4346,-3447.707,-3426.9294,-3456.2808,-3490.4426,-3498.8018,-3500.2048,-3567.9702,-3625.7493,-3640.8474,-3643.4753,-3665.1167,-3697.9087,-3591.8445,-2900.6992,-1409.2897,157.67123,1052.5005,1150.066,1058.4099,356.77762,-1085.2867,-1394.8005,-1740.2968,-2116.7612,-2417.5974,-2636.0127,-2810.6965,-2958.6536,-3116.0093,-3222.4243,-3434.7158,-3509.1519,-3556.5166,-3625.3982,-3717.6687,-3735.7449,-3781.9656,-3838.8677,-3890.9116,-3911.3276,-3899.5889,-3892.9778,-3885.2246,-3907.2354,-3844.1987,-3174.6294,-1209.772,596.81396,1299.9589,2088.09,2254.9194,455.55002,-649.84955,-1262.4962,-1727.7406,-2127.8984,-2461.2278,-2734.0237,-2918.2869,-3084.0667,-3154.5232,-3205.638,-3488.354,-3642.0837,-3722.638,-3811.816,-3893.4697,-3978.4116,-4093.9631,-4182.6978,-4231.499,-4212.6797,-4190.4893};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {-4171.1196,-4144.476,-4077.0833,-3985.2078,-3721.0317,-2022.271,423.43277,1349.686,4790.7803,4764.178,715.0341,-707.3764,-1324.009,-1799.436,-2192.8308,-2588.6562,-2872.1921,-3107.6104,-3168.8147,-3289.2087,-3453.2712,-3683.6016,-3795.3606,-3903.4429,-4043.5452,-4162.73,-4287.3784,-4408.755,-4466.132,-4450.157,-4442.544,-4400.4917,-4349.418,-4244.4517,-4142.9004,-4040.6755,-3909.8843,-3259.5981,-794.6519,606.89386,1654.0863,1390.0906,-480.98077,-1213.6783,-1558.1265,-1951.8818,-2478.7424,-2842.0198,-3143.3142,-3342.054,-3388.6472,-3510.595,-3629.6592,-3802.4275,-3982.9255,-4170.801,-4311.453,-4433.863,-4531.3457,-4633.851,-4676.376,-4637.4297,-4598.217,-4492.961,-4433.091,-4330.578,-4251.709,-4186.6143,-4065.97,-3820.195,-2616.6323,-1404.8503,-888.70374,-257.5371,-475.9175,-1734.451,-1873.8938,-1996.6832,-2830.4956,-3204.9019,-3309.8364,-3414.2356,-3614.1067,-3736.7932,-3760.4636,-3960.8904,-4183.5024,-4364.4253,-4502.3813,-4608.2554,-4721.5083,-4826.08,-4755.9844,-4718.849,-4655.5493,-4571.502,-4519.9805,-4428.92,-4339.177,-4355.854};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-4246.0723,-4158.0854,-3929.1394,-3614.398,-3392.361,-2641.3376,-2233.5173,-2588.9521,-2400.5786,-2441.2153,-2817.7495,-3411.2637,-3651.4575,-3672.2058,-3776.3599,-3923.5857,-3917.7017,-4121.2476,-4329.6196,-4509.2056,-4645.3467,-4768.1646,-4873.091,-4927.735,-4909.8257,-4858.2104,-4803.305,-4711.3413,-4632.0083,-4545.036,-4532.8003,-4498.0815,-4349.316,-4289.395,-4140.6675,-4016.3748,-3888.2815,-3747.2578,-3564.8718,-3195.9802,-2912.1194,-2879.9214,-2822.6755,-3180.2397,-3740.1042,-3822.4062,-3944.0125,-4030.6396,-4055.8408,-4245.665,-4397.3843,-4607.519,-4787.8516,-4942.11,-4988.191,-4994.903,-4989.7856,-4959.8306,-4957.7764,-4853.0566,-4764.018,-4694.1255,-4663.926,-4599.334,-4463.3364,-4302.199,-4194.6357,-4061.2842,-3898.3074,-3720.4595,-3614.299,-3448.918,-3339.4624,-3180.9011,-2837.806,-2525.4192,-3799.032,-3865.3962,-3976.0027,-4048.9275,-4163.737,-4339.4937,-4502.69,-4701.56,-4838.1777,-4965.6772,-4977.217,-4983.9893,-4960.7964,-4958.247,-4906.7603,-4862.951,-4863.045,-4817.516,-4726.3247,-4632.5977,-4531.198,-4371.7427,-4213.886,-4035.2664};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {-3873.2737,-3747.7288,-3695.3906,-3618.052,-3567.1365,-3218.5068,-2864.0127,-2766.005,-3710.4846,-3855.1008,-3979.83,-4026.8396,-4264.6875,-4442.914,-4610.5103,-4734.2324,-4859.7285,-4964.3345,-4965.537,-4966.976,-4926.1313,-4936.0713,-4905.5073,-4882.347,-4909.607,-4830.433,-4759.0977,-4685.91,-4537.568,-4316.6123,-4178.11,-3983.0105,-3845.1494,-3778.9653,-3755.478,-3723.0215,-3701.7427,-3573.4153,-3231.8674,-3065.0347,-3781.8757,-3887.4243,-3983.4204,-4070.7034,-4495.122,-4557.188,-4612.0884,-4715.85,-4846.6855,-4949.174,-4950.433,-4943.3247,-4935.451,-4922.075,-4907.376,-4928.311,-4898.402,-4828.4155,-4788.7505,-4643.0596,-4476.8384,-4296.0254,-4147.358,-4035.5623,-3949.0645,-3895.6191,-3863.598,-3837.2468,-3802.1223,-3793.7244,-3684.6992,-3534.9575,-3826.6,-3917.479,-3985.9336,-4090.964,-4386.1514,-4484.677,-4573.344,-4684.3203,-4780.9917,-4859.1504,-4904.7607,-4911.345,-4899.491,-4910.8867,-4873.522,-4862.185,-4795.5664,-4723.213,-4610.723,-4544.214,-4413.317,-4282.2197,-4179.9727,-4103.1387,-4037.545,-4006.715,-3979.5718,-3940.3638};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {-3904.703,-3873.7117,-3856.76,-3670.3933,-3895.606,-3899.474,-4030.5862,-4166.6445,-4232.8003,-4387.489,-4507.388,-4591.452,-4644.255,-4712.743,-4759.5015,-4804.973,-4813.4404,-4814.067,-4760.398,-4756.684,-4722.4316,-4586.251,-4516.036,-4458.28,-4417.881,-4319.403,-4214.5693,-4161.084,-4115.807,-4086.9263,-4046.6333,-4026.4285,-3979.1228,-3919.3267,-3916.09,-3919.4976,-3937.9382,-4010.6714,-4123.2837,-4178.4077,-4153.2944,-4284.654,-4380.9707,-4419.094,-4479.401,-4508.1562,-4590.921,-4641.7627,-4627.602,-4626.802,-4575.7417,-4590.435,-4558.5547,-4533.2246,-4461.604,-4452.652,-4413.01,-4362.1553,-4259.6353,-4214.373,-4159.9355,-4117.2783,-4084.1597,-4039.0999,-3987.7683,-4013.8318,-3970.666,-4001.2239,-4016.686,-4145.4136,-4172.33,-4209.1436,-4048.859,-4123.8677,-4194.7876,-4216.0117,-4328.185,-4305.919,-4421.319,-4457.5312,-4422.4673,-4442.408,-4455.688,-4455.0986,-4478.7114,-4478.464,-4413.278,-4426.9907,-4392.3086,-4346.602,-4309.879,-4257.101,-4198.5903,-4155.618,-4082.3186,-4034.2202,-4014.6445,-4048.7178,-4059.5073,-4087.497};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {-4111.6777,-4142.58,-4173.015,-4188.5747,-3963.3608,-4065.1826,-4077.3484,-4133.8716,-4197.1704,-4179.1978,-4294.266,-4306.326,-4299.8745,-4310.9995,-4346.639,-4369.6455,-4377.0166,-4387.0513,-4375.4453,-4363.4014,-4345.488,-4348.0947,-4329.6543,-4298.036,-4253.8755,-4211.645,-4148.5527,-4153.5728,-4108.936,-4125.5503,-4139.115,-4158.428,-4194.1724,-4194.787,-4223.2075,-4248.779,-3959.8882,-3999.2617,-4029.6326,-4048.325,-4103.2646,-4114.225,-4189.309,-4188.802,-4240.7,-4245.038,-4243.7383,-4279.9326,-4302.4883,-4327.0923,-4315.8667,-4329.9517,-4345.335,-4350.343,-4351.394,-4329.996,-4326.454,-4294.438,-4295.112,-4281.767,-4232.7573,-4245.4507,-4270.8667,-4257.308,-4285.754,-4294.8457,-4285.5703,-4361.7915,-3923.381,-3967.408,-3989.0457,-3984.3674,-4047.3804,-4090.6577,-4110.5615,-4126.477,-4148.7515,-4159.532,-4190.937,-4221.0103,-4260.7925,-4280.0137,-4310.0405,-4310.635,-4340.3926,-4334.1313,-4337.278,-4337.661,-4331.871,-4345.2227,-4356.922,-4399.0156,-4394.134,-4384.7124,-4381.413,-4404.6074,-4381.553,-4369.512,-4397.622,-4422.675};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-3989.9465,-3974.2612,-4001.5713,-4029.1316,-4020.9797,-4029.2021,-4049.6597,-4090.6846,-4113.516,-4141.5703,-4180.472,-4210.991,-4241.6104,-4264.2563,-4304.4556,-4341.7373,-4358.7935,-4426.4214,-4419.5615,-4409.6953,-4436.0723,-4461.3843,-4486.166,-4504.982,-4500.847,-4513.6787,-4500.422,-4495.2266,-4555.406,-4571.483,-4579.1616,-4572.979,-4152.6006,-4130.1426,-4109.3584,-4104.7886,-4106.066,-4124.2505,-4131.6177,-4153.323,-4180.0127,-4202.297,-4238.318,-4262.2896,-4273.151,-4295.023,-4326.5933,-4358.3877,-4406.375,-4448.8057,-4467.893,-4492.6104,-4519.7207,-4553.748,-4575.0566,-4575.4697,-4620.937,-4578.1357,-4633.599,-4531.7017,-4525.6865,-4687.627,-4718.847,-4697.6025,-4254.638,-4260.379,-4259.267,-4249.695,-4252.581,-4268.1104,-4269.378,-4274.4233,-4291.362,-4302.64,-4309.2334,-4326.855,-4360.368,-4369.442,-4385.8984,-4420.3125,-4460.677,-4492.0327,-4519.962,-4559.7324,-4593.9395,-4631.49,-4639.2007,-4646.065,-4676.3936,-4687.273,-4697.694,-4729.203,-4813.477,-4844.05,-4848.3037,-4825.833,-4378.9756,-4410.745,-4427.789,-4418.1753};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-4398.36,-4390.4727,-4383.3276,-4381.671,-4363.255,-4360.941,-4381.965,-4393.9043,-4411.0093,-4441.2515,-4464.553,-4492.7676,-4517.27,-4531.8154,-4563.72,-4608.6846,-4647.365,-4676.6094,-4691.564,-4696.741,-4725.7446,-4739.1562,-4756.44,-4773.5283,-4809.789,-4817.432,-4836.8345,-4830.433,-4298.447,-4318.0815,-4349.4707,-4377.983,-4418.6797,-4447.3716,-4477.7427,-4500.958,-4484.6606,-4490.305,-4498.1353,-4525.9995,-4549.8184,-4562.531,-4564.1875,-4563.4766,-4574.6387,-4583.1885,-4568.715,-4577.6426,-4586.623,-4578.473,-4569.1504,-4558.6807,-4542.002,-4515.187,-4489.8506,-4471.7734,-4451.8667,-4426.221,-4392.5244,-4373.1245,-3328.223,-3352.9036,-3387.8784,-3446.4119,-3489.6956,-3543.776,-3630.9817,-3765.3923,-3890.2722,-3986.5632,-3998.258,-4042.6362,-4090.903,-4122.643,-4175.7104,-4203.55,-4207.3916,-4224.357,-4239.439,-4224.0127,-4227.398,-4242.651,-4254.2515,-4238.217,-4224.9272,-4190.069,-4158.651,-4161.5127,-4165.1367,-4172.223,-4107.543,-4137.523,-2650.8972,-2653.1895,-2672.9133,-2690.935,-2684.202,-2706.2024,-2662.4995,-2680.4773};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {-2743.0771,-2796.577,-2793.6013,-2774.8218,-2784.0059,-2800.5454,-2803.788,-2860.5688,-2892.161,-2966.668,-3060.827,-3046.0066,-3028.1528,-3059.1633,-3104.2178,-3095.9478,-3058.2195,-3054.3687,-3083.104,-3111.4507,-3133.0583,-3173.6768,-3139.9226,-3126.1904};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.03226,0.00391,0.06452,0.00391,0.09677,0.00391,0.12903,0.00391,0.16129,0.00391,0.19355,0.00391,0.22581,0.00391,0.25806,0.00391,0.29032,0.00391,0.32258,0.00391,0.35484,0.00391,0.3871,0.00391,0.41935,0.00391,0.45161,0.00391,0.48387,0.00391,0.51613,0.00391,0.54839,0.00391,0.58065,0.00391,0.6129,0.00391,0.64516,0.00391,0.67742,0.00391,0.70968,0.00391,0.74194,0.00391,0.77419,0.00391,0.80645,0.00391,0.83871,0.00391,0.87097,0.00391,0.90323,0.00391,0.93548,0.00391,0.96774,0.00391,0.99609,0.00391,0.00391,0.03226,0.03226,0.03226,0.06452,0.03226,0.09677,0.03226,0.12903,0.03226,0.16129,0.03226,0.19355,0.03226,0.22581,0.03226,0.25806,0.03226,0.29032,0.03226,0.32258,0.03226,0.35484,0.03226,0.3871,0.03226,0.41935,0.03226,0.45161,0.03226,0.48387,0.03226,0.51613,0.03226,0.54839,0.03226,0.58065,0.03226,0.6129,0.03226,0.64516,0.03226,0.67742,0.03226,0.70968,0.03226,0.74194,0.03226,0.77419,0.03226,0.80645,0.03226,0.83871,0.03226,0.87097,0.03226,0.90323,0.03226,0.93548,0.03226,0.96774,0.03226,0.99609,0.03226,0.00391,0.06452,0.03226,0.06452,0.06452,0.06452,0.09677,0.06452,0.12903,0.06452,0.16129,0.06452,0.19355,0.06452,0.22581,0.06452,0.25806,0.06452,0.29032,0.06452,0.32258,0.06452,0.35484,0.06452,0.3871,0.06452,0.41935,0.06452,0.45161,0.06452,0.48387,0.06452,0.51613,0.06452,0.54839,0.06452,0.58065,0.06452,0.6129,0.06452,0.64516,0.06452,0.67742,0.06452,0.70968,0.06452,0.74194,0.06452,0.77419,0.06452,0.80645,0.06452,0.83871,0.06452,0.87097,0.06452,0.90323,0.06452,0.93548,0.06452,0.96774,0.06452,0.99609,0.06452,0.00391,0.09677,0.03226,0.09677,0.06452,0.09677,0.09677,0.09677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.12903,0.09677,0.16129,0.09677,0.19355,0.09677,0.22581,0.09677,0.25806,0.09677,0.29032,0.09677,0.32258,0.09677,0.35484,0.09677,0.3871,0.09677,0.41935,0.09677,0.45161,0.09677,0.48387,0.09677,0.51613,0.09677,0.54839,0.09677,0.58065,0.09677,0.6129,0.09677,0.64516,0.09677,0.67742,0.09677,0.70968,0.09677,0.74194,0.09677,0.77419,0.09677,0.80645,0.09677,0.83871,0.09677,0.87097,0.09677,0.90323,0.09677,0.93548,0.09677,0.96774,0.09677,0.99609,0.09677,0.00391,0.12903,0.03226,0.12903,0.06452,0.12903,0.09677,0.12903,0.12903,0.12903,0.16129,0.12903,0.19355,0.12903,0.22581,0.12903,0.25806,0.12903,0.29032,0.12903,0.32258,0.12903,0.35484,0.12903,0.3871,0.12903,0.41935,0.12903,0.45161,0.12903,0.48387,0.12903,0.51613,0.12903,0.54839,0.12903,0.58065,0.12903,0.6129,0.12903,0.64516,0.12903,0.67742,0.12903,0.70968,0.12903,0.74194,0.12903,0.77419,0.12903,0.80645,0.12903,0.83871,0.12903,0.87097,0.12903,0.90323,0.12903,0.93548,0.12903,0.96774,0.12903,0.99609,0.12903,0.00391,0.16129,0.03226,0.16129,0.06452,0.16129,0.09677,0.16129,0.12903,0.16129,0.16129,0.16129,0.19355,0.16129,0.22581,0.16129,0.25806,0.16129,0.29032,0.16129,0.32258,0.16129,0.35484,0.16129,0.3871,0.16129,0.41935,0.16129,0.45161,0.16129,0.48387,0.16129,0.51613,0.16129,0.54839,0.16129,0.58065,0.16129,0.6129,0.16129,0.64516,0.16129,0.67742,0.16129,0.70968,0.16129,0.74194,0.16129,0.77419,0.16129,0.80645,0.16129,0.83871,0.16129,0.87097,0.16129,0.90323,0.16129,0.93548,0.16129,0.96774,0.16129,0.99609,0.16129,0.00391,0.19355,0.03226,0.19355,0.06452,0.19355,0.09677,0.19355,0.12903,0.19355,0.16129,0.19355,0.19355,0.19355,0.22581,0.19355};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.25806,0.19355,0.29032,0.19355,0.32258,0.19355,0.35484,0.19355,0.3871,0.19355,0.41935,0.19355,0.45161,0.19355,0.48387,0.19355,0.51613,0.19355,0.54839,0.19355,0.58065,0.19355,0.6129,0.19355,0.64516,0.19355,0.67742,0.19355,0.70968,0.19355,0.74194,0.19355,0.77419,0.19355,0.80645,0.19355,0.83871,0.19355,0.87097,0.19355,0.90323,0.19355,0.93548,0.19355,0.96774,0.19355,0.99609,0.19355,0.00391,0.22581,0.03226,0.22581,0.06452,0.22581,0.09677,0.22581,0.12903,0.22581,0.16129,0.22581,0.19355,0.22581,0.22581,0.22581,0.25806,0.22581,0.29032,0.22581,0.32258,0.22581,0.35484,0.22581,0.3871,0.22581,0.41935,0.22581,0.45161,0.22581,0.48387,0.22581,0.51613,0.22581,0.54839,0.22581,0.58065,0.22581,0.6129,0.22581,0.64516,0.22581,0.67742,0.22581,0.70968,0.22581,0.74194,0.22581,0.77419,0.22581,0.80645,0.22581,0.83871,0.22581,0.87097,0.22581,0.90323,0.22581,0.93548,0.22581,0.96774,0.22581,0.99609,0.22581,0.00391,0.25806,0.03226,0.25806,0.06452,0.25806,0.09677,0.25806,0.12903,0.25806,0.16129,0.25806,0.19355,0.25806,0.22581,0.25806,0.25806,0.25806,0.29032,0.25806,0.32258,0.25806,0.35484,0.25806,0.3871,0.25806,0.41935,0.25806,0.45161,0.25806,0.48387,0.25806,0.51613,0.25806,0.54839,0.25806,0.58065,0.25806,0.6129,0.25806,0.64516,0.25806,0.67742,0.25806,0.70968,0.25806,0.74194,0.25806,0.77419,0.25806,0.80645,0.25806,0.83871,0.25806,0.87097,0.25806,0.90323,0.25806,0.93548,0.25806,0.96774,0.25806,0.99609,0.25806,0.00391,0.29032,0.03226,0.29032,0.06452,0.29032,0.09677,0.29032,0.12903,0.29032,0.16129,0.29032,0.19355,0.29032,0.22581,0.29032,0.25806,0.29032,0.29032,0.29032,0.32258,0.29032,0.35484,0.29032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.3871,0.29032,0.41935,0.29032,0.45161,0.29032,0.48387,0.29032,0.51613,0.29032,0.54839,0.29032,0.58065,0.29032,0.6129,0.29032,0.64516,0.29032,0.67742,0.29032,0.70968,0.29032,0.74194,0.29032,0.77419,0.29032,0.80645,0.29032,0.83871,0.29032,0.87097,0.29032,0.90323,0.29032,0.93548,0.29032,0.96774,0.29032,0.99609,0.29032,0.00391,0.32258,0.03226,0.32258,0.06452,0.32258,0.09677,0.32258,0.12903,0.32258,0.16129,0.32258,0.19355,0.32258,0.22581,0.32258,0.25806,0.32258,0.29032,0.32258,0.32258,0.32258,0.35484,0.32258,0.3871,0.32258,0.41935,0.32258,0.45161,0.32258,0.48387,0.32258,0.51613,0.32258,0.54839,0.32258,0.58065,0.32258,0.6129,0.32258,0.64516,0.32258,0.67742,0.32258,0.70968,0.32258,0.74194,0.32258,0.77419,0.32258,0.80645,0.32258,0.83871,0.32258,0.87097,0.32258,0.90323,0.32258,0.93548,0.32258,0.96774,0.32258,0.99609,0.32258,0.00391,0.35484,0.03226,0.35484,0.06452,0.35484,0.09677,0.35484,0.12903,0.35484,0.16129,0.35484,0.19355,0.35484,0.22581,0.35484,0.25806,0.35484,0.29032,0.35484,0.32258,0.35484,0.35484,0.35484,0.3871,0.35484,0.41935,0.35484,0.45161,0.35484,0.48387,0.35484,0.51613,0.35484,0.54839,0.35484,0.58065,0.35484,0.6129,0.35484,0.64516,0.35484,0.67742,0.35484,0.70968,0.35484,0.74194,0.35484,0.77419,0.35484,0.80645,0.35484,0.83871,0.35484,0.87097,0.35484,0.90323,0.35484,0.93548,0.35484,0.96774,0.35484,0.99609,0.35484,0.00391,0.3871,0.03226,0.3871,0.06452,0.3871,0.09677,0.3871,0.12903,0.3871,0.16129,0.3871,0.19355,0.3871,0.22581,0.3871,0.25806,0.3871,0.29032,0.3871,0.32258,0.3871,0.35484,0.3871,0.3871,0.3871,0.41935,0.3871,0.45161,0.3871,0.48387,0.3871};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.51613,0.3871,0.54839,0.3871,0.58065,0.3871,0.6129,0.3871,0.64516,0.3871,0.67742,0.3871,0.70968,0.3871,0.74194,0.3871,0.77419,0.3871,0.80645,0.3871,0.83871,0.3871,0.87097,0.3871,0.90323,0.3871,0.93548,0.3871,0.96774,0.3871,0.99609,0.3871,0.00391,0.41935,0.03226,0.41935,0.06452,0.41935,0.09677,0.41935,0.12903,0.41935,0.16129,0.41935,0.19355,0.41935,0.22581,0.41935,0.25806,0.41935,0.29032,0.41935,0.32258,0.41935,0.35484,0.41935,0.3871,0.41935,0.41935,0.41935,0.45161,0.41935,0.48387,0.41935,0.51613,0.41935,0.54839,0.41935,0.58065,0.41935,0.6129,0.41935,0.64516,0.41935,0.67742,0.41935,0.70968,0.41935,0.74194,0.41935,0.77419,0.41935,0.80645,0.41935,0.83871,0.41935,0.87097,0.41935,0.90323,0.41935,0.93548,0.41935,0.96774,0.41935,0.99609,0.41935,0.00391,0.45161,0.03226,0.45161,0.06452,0.45161,0.09677,0.45161,0.12903,0.45161,0.16129,0.45161,0.19355,0.45161,0.22581,0.45161,0.25806,0.45161,0.29032,0.45161,0.32258,0.45161,0.35484,0.45161,0.3871,0.45161,0.41935,0.45161,0.45161,0.45161,0.48387,0.45161,0.51613,0.45161,0.54839,0.45161,0.58065,0.45161,0.6129,0.45161,0.64516,0.45161,0.67742,0.45161,0.70968,0.45161,0.74194,0.45161,0.77419,0.45161,0.80645,0.45161,0.83871,0.45161,0.87097,0.45161,0.90323,0.45161,0.93548,0.45161,0.96774,0.45161,0.99609,0.45161,0.00391,0.48387,0.03226,0.48387,0.06452,0.48387,0.09677,0.48387,0.12903,0.48387,0.16129,0.48387,0.19355,0.48387,0.22581,0.48387,0.25806,0.48387,0.29032,0.48387,0.32258,0.48387,0.35484,0.48387,0.3871,0.48387,0.41935,0.48387,0.45161,0.48387,0.48387,0.48387,0.51613,0.48387,0.54839,0.48387,0.58065,0.48387,0.6129,0.48387};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.64516,0.48387,0.67742,0.48387,0.70968,0.48387,0.74194,0.48387,0.77419,0.48387,0.80645,0.48387,0.83871,0.48387,0.87097,0.48387,0.90323,0.48387,0.93548,0.48387,0.96774,0.48387,0.99609,0.48387,0.00391,0.51613,0.03226,0.51613,0.06452,0.51613,0.09677,0.51613,0.12903,0.51613,0.16129,0.51613,0.19355,0.51613,0.22581,0.51613,0.25806,0.51613,0.29032,0.51613,0.32258,0.51613,0.35484,0.51613,0.3871,0.51613,0.41935,0.51613,0.45161,0.51613,0.48387,0.51613,0.51613,0.51613,0.54839,0.51613,0.58065,0.51613,0.6129,0.51613,0.64516,0.51613,0.67742,0.51613,0.70968,0.51613,0.74194,0.51613,0.77419,0.51613,0.80645,0.51613,0.83871,0.51613,0.87097,0.51613,0.90323,0.51613,0.93548,0.51613,0.96774,0.51613,0.99609,0.51613,0.00391,0.54839,0.03226,0.54839,0.06452,0.54839,0.09677,0.54839,0.12903,0.54839,0.16129,0.54839,0.19355,0.54839,0.22581,0.54839,0.25806,0.54839,0.29032,0.54839,0.32258,0.54839,0.35484,0.54839,0.3871,0.54839,0.41935,0.54839,0.45161,0.54839,0.48387,0.54839,0.51613,0.54839,0.54839,0.54839,0.58065,0.54839,0.6129,0.54839,0.64516,0.54839,0.67742,0.54839,0.70968,0.54839,0.74194,0.54839,0.77419,0.54839,0.80645,0.54839,0.83871,0.54839,0.87097,0.54839,0.90323,0.54839,0.93548,0.54839,0.96774,0.54839,0.99609,0.54839,0.00391,0.58065,0.03226,0.58065,0.06452,0.58065,0.09677,0.58065,0.12903,0.58065,0.16129,0.58065,0.19355,0.58065,0.22581,0.58065,0.25806,0.58065,0.29032,0.58065,0.32258,0.58065,0.35484,0.58065,0.3871,0.58065,0.41935,0.58065,0.45161,0.58065,0.48387,0.58065,0.51613,0.58065,0.54839,0.58065,0.58065,0.58065,0.6129,0.58065,0.64516,0.58065,0.67742,0.58065,0.70968,0.58065,0.74194,0.58065};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.77419,0.58065,0.80645,0.58065,0.83871,0.58065,0.87097,0.58065,0.90323,0.58065,0.93548,0.58065,0.96774,0.58065,0.99609,0.58065,0.00391,0.6129,0.03226,0.6129,0.06452,0.6129,0.09677,0.6129,0.12903,0.6129,0.16129,0.6129,0.19355,0.6129,0.22581,0.6129,0.25806,0.6129,0.29032,0.6129,0.32258,0.6129,0.35484,0.6129,0.3871,0.6129,0.41935,0.6129,0.45161,0.6129,0.48387,0.6129,0.51613,0.6129,0.54839,0.6129,0.58065,0.6129,0.6129,0.6129,0.64516,0.6129,0.67742,0.6129,0.70968,0.6129,0.74194,0.6129,0.77419,0.6129,0.80645,0.6129,0.83871,0.6129,0.87097,0.6129,0.90323,0.6129,0.93548,0.6129,0.96774,0.6129,0.99609,0.6129,0.00391,0.64516,0.03226,0.64516,0.06452,0.64516,0.09677,0.64516,0.12903,0.64516,0.16129,0.64516,0.19355,0.64516,0.22581,0.64516,0.25806,0.64516,0.29032,0.64516,0.32258,0.64516,0.35484,0.64516,0.3871,0.64516,0.41935,0.64516,0.45161,0.64516,0.48387,0.64516,0.51613,0.64516,0.54839,0.64516,0.58065,0.64516,0.6129,0.64516,0.64516,0.64516,0.67742,0.64516,0.70968,0.64516,0.74194,0.64516,0.77419,0.64516,0.80645,0.64516,0.83871,0.64516,0.87097,0.64516,0.90323,0.64516,0.93548,0.64516,0.96774,0.64516,0.99609,0.64516,0.00391,0.67742,0.03226,0.67742,0.06452,0.67742,0.09677,0.67742,0.12903,0.67742,0.16129,0.67742,0.19355,0.67742,0.22581,0.67742,0.25806,0.67742,0.29032,0.67742,0.32258,0.67742,0.35484,0.67742,0.3871,0.67742,0.41935,0.67742,0.45161,0.67742,0.48387,0.67742,0.51613,0.67742,0.54839,0.67742,0.58065,0.67742,0.6129,0.67742,0.64516,0.67742,0.67742,0.67742,0.70968,0.67742,0.74194,0.67742,0.77419,0.67742,0.80645,0.67742,0.83871,0.67742,0.87097,0.67742};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.90323,0.67742,0.93548,0.67742,0.96774,0.67742,0.99609,0.67742,0.00391,0.70968,0.03226,0.70968,0.06452,0.70968,0.09677,0.70968,0.12903,0.70968,0.16129,0.70968,0.19355,0.70968,0.22581,0.70968,0.25806,0.70968,0.29032,0.70968,0.32258,0.70968,0.35484,0.70968,0.3871,0.70968,0.41935,0.70968,0.45161,0.70968,0.48387,0.70968,0.51613,0.70968,0.54839,0.70968,0.58065,0.70968,0.6129,0.70968,0.64516,0.70968,0.67742,0.70968,0.70968,0.70968,0.74194,0.70968,0.77419,0.70968,0.80645,0.70968,0.83871,0.70968,0.87097,0.70968,0.90323,0.70968,0.93548,0.70968,0.96774,0.70968,0.99609,0.70968,0.00391,0.74194,0.03226,0.74194,0.06452,0.74194,0.09677,0.74194,0.12903,0.74194,0.16129,0.74194,0.19355,0.74194,0.22581,0.74194,0.25806,0.74194,0.29032,0.74194,0.32258,0.74194,0.35484,0.74194,0.3871,0.74194,0.41935,0.74194,0.45161,0.74194,0.48387,0.74194,0.51613,0.74194,0.54839,0.74194,0.58065,0.74194,0.6129,0.74194,0.64516,0.74194,0.67742,0.74194,0.70968,0.74194,0.74194,0.74194,0.77419,0.74194,0.80645,0.74194,0.83871,0.74194,0.87097,0.74194,0.90323,0.74194,0.93548,0.74194,0.96774,0.74194,0.99609,0.74194,0.00391,0.77419,0.03226,0.77419,0.06452,0.77419,0.09677,0.77419,0.12903,0.77419,0.16129,0.77419,0.19355,0.77419,0.22581,0.77419,0.25806,0.77419,0.29032,0.77419,0.32258,0.77419,0.35484,0.77419,0.3871,0.77419,0.41935,0.77419,0.45161,0.77419,0.48387,0.77419,0.51613,0.77419,0.54839,0.77419,0.58065,0.77419,0.6129,0.77419,0.64516,0.77419,0.67742,0.77419,0.70968,0.77419,0.74194,0.77419,0.77419,0.77419,0.80645,0.77419,0.83871,0.77419,0.87097,0.77419,0.90323,0.77419,0.93548,0.77419,0.96774,0.77419,0.99609,0.77419};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.80645,0.03226,0.80645,0.06452,0.80645,0.09677,0.80645,0.12903,0.80645,0.16129,0.80645,0.19355,0.80645,0.22581,0.80645,0.25806,0.80645,0.29032,0.80645,0.32258,0.80645,0.35484,0.80645,0.3871,0.80645,0.41935,0.80645,0.45161,0.80645,0.48387,0.80645,0.51613,0.80645,0.54839,0.80645,0.58065,0.80645,0.6129,0.80645,0.64516,0.80645,0.67742,0.80645,0.70968,0.80645,0.74194,0.80645,0.77419,0.80645,0.80645,0.80645,0.83871,0.80645,0.87097,0.80645,0.90323,0.80645,0.93548,0.80645,0.96774,0.80645,0.99609,0.80645,0.00391,0.83871,0.03226,0.83871,0.06452,0.83871,0.09677,0.83871,0.12903,0.83871,0.16129,0.83871,0.19355,0.83871,0.22581,0.83871,0.25806,0.83871,0.29032,0.83871,0.32258,0.83871,0.35484,0.83871,0.3871,0.83871,0.41935,0.83871,0.45161,0.83871,0.48387,0.83871,0.51613,0.83871,0.54839,0.83871,0.58065,0.83871,0.6129,0.83871,0.64516,0.83871,0.67742,0.83871,0.70968,0.83871,0.74194,0.83871,0.77419,0.83871,0.80645,0.83871,0.83871,0.83871,0.87097,0.83871,0.90323,0.83871,0.93548,0.83871,0.96774,0.83871,0.99609,0.83871,0.00391,0.87097,0.03226,0.87097,0.06452,0.87097,0.09677,0.87097,0.12903,0.87097,0.16129,0.87097,0.19355,0.87097,0.22581,0.87097,0.25806,0.87097,0.29032,0.87097,0.32258,0.87097,0.35484,0.87097,0.3871,0.87097,0.41935,0.87097,0.45161,0.87097,0.48387,0.87097,0.51613,0.87097,0.54839,0.87097,0.58065,0.87097,0.6129,0.87097,0.64516,0.87097,0.67742,0.87097,0.70968,0.87097,0.74194,0.87097,0.77419,0.87097,0.80645,0.87097,0.83871,0.87097,0.87097,0.87097,0.90323,0.87097,0.93548,0.87097,0.96774,0.87097,0.99609,0.87097,0.00391,0.90323,0.03226,0.90323,0.06452,0.90323,0.09677,0.90323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.12903,0.90323,0.16129,0.90323,0.19355,0.90323,0.22581,0.90323,0.25806,0.90323,0.29032,0.90323,0.32258,0.90323,0.35484,0.90323,0.3871,0.90323,0.41935,0.90323,0.45161,0.90323,0.48387,0.90323,0.51613,0.90323,0.54839,0.90323,0.58065,0.90323,0.6129,0.90323,0.64516,0.90323,0.67742,0.90323,0.70968,0.90323,0.74194,0.90323,0.77419,0.90323,0.80645,0.90323,0.83871,0.90323,0.87097,0.90323,0.90323,0.90323,0.93548,0.90323,0.96774,0.90323,0.99609,0.90323,0.00391,0.93548,0.03226,0.93548,0.06452,0.93548,0.09677,0.93548,0.12903,0.93548,0.16129,0.93548,0.19355,0.93548,0.22581,0.93548,0.25806,0.93548,0.29032,0.93548,0.32258,0.93548,0.35484,0.93548,0.3871,0.93548,0.41935,0.93548,0.45161,0.93548,0.48387,0.93548,0.51613,0.93548,0.54839,0.93548,0.58065,0.93548,0.6129,0.93548,0.64516,0.93548,0.67742,0.93548,0.70968,0.93548,0.74194,0.93548,0.77419,0.93548,0.80645,0.93548,0.83871,0.93548,0.87097,0.93548,0.90323,0.93548,0.93548,0.93548,0.96774,0.93548,0.99609,0.93548,0.00391,0.96774,0.03226,0.96774,0.06452,0.96774,0.09677,0.96774,0.12903,0.96774,0.16129,0.96774,0.19355,0.96774,0.22581,0.96774,0.25806,0.96774,0.29032,0.96774,0.32258,0.96774,0.35484,0.96774,0.3871,0.96774,0.41935,0.96774,0.45161,0.96774,0.48387,0.96774,0.51613,0.96774,0.54839,0.96774,0.58065,0.96774,0.6129,0.96774,0.64516,0.96774,0.67742,0.96774,0.70968,0.96774,0.74194,0.96774,0.77419,0.96774,0.80645,0.96774,0.83871,0.96774,0.87097,0.96774,0.90323,0.96774,0.93548,0.96774,0.96774,0.96774,0.99609,0.96774,0.00391,0.99609,0.03226,0.99609,0.06452,0.99609,0.09677,0.99609,0.12903,0.99609,0.16129,0.99609,0.19355,0.99609,0.22581,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.25806,0.99609,0.29032,0.99609,0.32258,0.99609,0.35484,0.99609,0.3871,0.99609,0.41935,0.99609,0.45161,0.99609,0.48387,0.99609,0.51613,0.99609,0.54839,0.99609,0.58065,0.99609,0.6129,0.99609,0.64516,0.99609,0.67742,0.99609,0.70968,0.99609,0.74194,0.99609,0.77419,0.99609,0.80645,0.99609,0.83871,0.99609,0.87097,0.99609,0.90323,0.99609,0.93548,0.99609,0.96774,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 1024 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 2048 total numbers made up of 1024 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD021 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD021().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD021\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD021 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD021_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD021_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD021_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD021_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
