####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD020.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD020.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD020.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD020.x3d'),
    GeoLOD(center=(-44.911417,134.911417,-38525.000000),range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars006.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars006.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,90.000000,0.000000),height=[3810.4187,3788.2607,3767.5105,3762.5642,3764.3801,3766.9075,3769.6084,3779.8225,3791.3389,3795.0818,3796.5244,3798.3894,3800.239,3800.2532,3798.6677,3799.614,3803.3506,3804.6714,3808.0398,3812.2288,3813.4546,3815.1877,3819.069,3823.7231,3825.197,3826.167,3823.0784,3822.1316,3819.2844,3816.3787,3815.925,3820.7148,3827.127,3830.5535,3831.136,3839.4902,3856.2852,3853.0344,3871.3586,3882.2695,3884.3218,3887.1619,3889.3425,3889.1958,3889.746,3891.867,3887.7114,3891.38,3898.1875,3900.3093,3900.6394,3902.764,3908.6606,3916.6963,3924.894,3932.4373,3936.83,3941.8904,3945.644,3949.7668,3949.4062,3949.1277,3952.228,3951.4382,3947.6318,3948.098,3948.3823,3949.2627,3948.083,3944.0955,3947.1274,3956.298,3956.6658,3972.487,3982.9214,3985.8396,3990.0945,3990.5417,3989.9731,3992.7278,3995.6638,3993.8728,3994.01,3996.5383,3993.9128,3994.1223,3993.524,3988.2034,3986.1387,3987.3608,3988.175,3986.6243,3976.8884,3978.082,3982.1904,3973.7,3966.8167,3968.4316,3967.0283,3965.7473,3962.071,3960.6143,3959.9841,3957.7488,3956.1858,3951.0107,3952.5356,3959.5298,3953.6436,3948.269,3957.0989,3959.5984,3968.5813,3957.0613,3952.223,3954.754,3951.058,3936.6042,3925.0261,3927.927,3935.9666,3930.9226,3920.7961,3918.2322,3923.077,3918.1125,3908.1187,3901.0361,3602.4868,3585.0835,3562.5679,3538.2378,3504.925,3479.17,3478.5532,3496.043,3494.3826,3503.8416,3534.9578,3585.3425,3617.9834,3626.7231,3627.1628,3625.6597,3626.6794,3624.4507,3620.0264,3612.8997,3601.8508,3575.871,3576.3298,3604.6484,3617.6248,3642.6157,3676.5378,3722.5298,3735.0671,3734.773,3743.5015,3757.4868,3774.669,3791.5942,3804.9648,3818.1624,3830.6833,3832.0469,3835.7327,3834.1123,3826.4758,3816.227,3805.2432,3802.3887,3817.9492,3859.3364,3907.7893,3959.831,3991.315,3998.3982,3994.9885,3993.701,3992.8594,3992.0708,3993.0803,3994.798,3997.6458,3999.1118,4000.181,4000.497,3999.3044,3995.8274,3992.659,3988.9397,3985.451,3983.5642,3982.9683,3981.0808,3978.5334,3976.582,3980.1902,3985.0547,3982.0134,3977.6191,3977.0757,3969.319,3965.5479,3961.0496,3950.1685,3943.4734,3940.6182,3939.256,3933.7612,3928.4155,3923.674,3919.047,3913.215,3909.2634,3911.9224,3900.458,3863.3064,3846.1667,3846.6946,3848.6396,3838.3594,3827.7446,3810.1199,3783.1584,3770.3755,3764.28,3753.2756,3752.6035,3761.2815,3773.4722,3781.259,3769.8826,3756.484,3758.5417,3753.3186,3738.143,3744.8457,3756.517,3751.3423,3729.4524,3715.6792,3692.284,3648.7822,3620.2737,3580.409,3543.4143,3530.9497,3511.21,3501.5327,3472.4824,3427.5415,3383.4644,3353.1047,3349.8162,3291.7537,3253.9802,3200.4915,3166.5942,3168.6855,3138.2893,3136.1533,3179.3582,3241.3572,3271.9304,3308.8884,3364.0164,3413.0352,3446.103,3465.987,3477.7673,3478.8152,3476.1843,3468.0474,3461.917,3461.7192,3450.1345,3434.9316,3437.0195,3425.0981,3389.9226,3463.6152,3606.2893,3661.635,3695.027,3722.3044,3732.2578,3747.6138,3765.7087,3778.0295,3780.657,3780.1343,3770.227,3755.373,3745.145,3739.9692,3726.8562,3755.3574,3851.8323,3919.6526,3929.3054,3922.2935,3912.5056,3910.528,3910.613,3911.6965,3899.984,3885.7656,3867.8013,3863.7932,3858.7258,3866.487,3873.1975,3874.0159,3870.3513,3862.3228,3851.53,3835.4785,3816.3293,3799.8677,3782.5784,3767.088,3752.9675,3740.1672,3731.9172,3733.4062,3722.9397,3704.163,3706.2024,3721.8035,3709.4746,3702.7327,3682.3545,3652.9697,3642.7148,3630.4893,3631.173,3641.1963,3627.9524,3598.133,3600.739,3612.0803,3597.8206,3531.5894,3535.5095,3470.4429,3445.8281,3456.6003,3482.2546,3472.264,3470.1482,3433.8904,3335.0486,3313.8923,3326.9722,3296.3977,3260.7012,3257.8982,3306.3499,3313.8542,3258.4963,3195.8386,3207.0056,3204.5876,3184.8367,3165.6726,3146.4119,3121.1567,3097.7725,3036.158,2998.42,3039.887,3085.8057,3121.1982,3121.8408,3076.4932,2983.4512,2864.214,2739.409,2650.146,2589.3862,2520.8318,2433.6973,3232.6545,3201.559,3160.751,3115.2158,3069.6086,3033.6262,3020.65,3017.8176,3027.429,3052.7903,3098.5564,3141.8948,3179.8394,3203.4922,3242.8052,3275.8389,3303.8923,3328.5994,3342.1772,3350.023,3363.425,3372.5767,3373.2815,3374.5168,3371.0747,3367.9355,3388.2166,3395.187,3421.2808,3441.6147,3434.3086,3427.9797,3457.7607,3513.4966,3560.0413,3595.5232,3619.7122,3632.3235,3643.774,3657.7297,3668.5527,3676.8982,3684.8013,3696.548,3703.5518,3701.9343,3697.8242,3691.0957,3688.144,3682.858,3683.3086,3683.3086,3680.1208,3672.671,3668.1494,3660.4355,3658.3645,3656.0603,3649.7737,3641.0618,3626.1746,3608.3347,3586.6252,3560.3567,3534.8257,3519.6902,3506.3125,3477.4324,3461.171,3447.6711,3429.617,3418.8057,3409.2573,3399.5034,3397.0752,3373.1973,3366.2478,3354.936,3339.6655,3326.0078,3305.8806,3282.6438,3270.1763,3256.1765,3221.869,3200.6147,3185.5986,3169.4133,3142.6812,3131.637,3112.2412,3074.472,3036.6768,3017.7944,3008.9028,2965.401,2956.0042,2914.1826,2894.7126,2904.3613,2877.6658,2854.5493,2859.0825,2867.1472,2848.289,2837.3035,2848.5247,2863.4421,2871.9194,2872.7632,2846.0452,2796.1309,2767.376,2724.6782,2690.2432,2765.1243,2873.5068,2915.7522,2936.344,2931.1287,2892.9324,2835.13,2770.9702,2729.9646,2695.2346,2662.3599,2644.1665,2621.215,3139.0242,3109.0918,3064.6501,3005.4849,2934.188,2809.2485,2678.0776,2540.914,2470.0662,2482.0918,2658.8894,2787.6294,2853.0122,2896.144,2920.127,2938.2644,2956.4849,2971.921,2985.8594,3003.3516,3041.6567,3109.8652,3166.1155,3198.3337,3203.8384,3158.3892,3118.9119,3153.0437,3258.402,3341.9353,3384.8975,3401.0696,3401.9082,3398.148,3396.5408,3391.9878,3383.8577,3375.447,3372.3926,3372.6157,3374.1245,3378.0298,3385.422,3394.6406,3405.1272,3416.6135,3425.2378,3432.3599,3432.0723,3427.4905,3430.7168,3443.2266,3447.0098,3443.5496,3435.9102,3426.1301,3415.41,3402.52,3388.457,3373.7722,3350.6526,3323.4146,3295.5278,3276.6753,3262.5583,3240.9155,3213.749,3189.7153,3163.7925,3131.1128,3101.981,3093.434,3084.7024,3073.125,3055.8083,3036.5896,3018.8037,2988.6885,2950.6816,2915.782,2886.5488,2867.6873,2840.7332,2819.3357,2793.1555,2760.0952,2722.9453,2703.044,2687.1484,2681.3362,2692.9778,2708.8484,2730.326,2760.8035,2793.9402,2833.2236,2876.7903,2912.6765,2948.8962,2984.0815,3015.01,3039.6824,3063.3584,3078.499,3098.0635,3113.9731,3121.658,3124.639,3129.2969,3132.0393,3133.599,3133.9836,3136.194,3130.8003,3113.254,3080.516,3024.294,2920.5366,2748.36,2563.7854,2398.1084,2288.2266,2222.611,2200.658,2205.4797,2231.209,2272.9956,2328.9675,3091.265,3034.341,2950.3638,2832.4001,2733.4922,2620.8616,2432.7427,2077.7708,1800.6329,1701.5886,1768.7859,1894.5284,2087.7988,2235.3413,2324.5225,2373.1724,2454.7861,2546.2883,2600.9072,2606.927,2601.2407,2652.8555,2738.2476,2812.9792,2892.8992,2947.5532,2977.562,2996.5217,2999.7068,3008.3452,3041.43,3073.824,3090.358,3110.1523,3122.185,3129.9446,3143.7166,3159.6812,3171.5369,3187.9238,3207.497,3215.5913,3216.3582,3214.544,3208.9966,3204.7678,3198.3152,3183.81,3161.0005,3132.3027,3099.3896,3081.733,3085.2266,3091.9043,3099.2754,3100.0635,3092.2024,3075.6675,3055.5156,3043.6619,3029.0657,3011.5454,2994.9004,2972.4387,2946.5361,2914.7236,2870.594,2819.6062,2783.3442,2769.6978,2756.0261,2748.743,2735.8628,2726.2378,2721.7097,2709.2654,2703.5068,2701.6577,2702.0857,2717.6099,2735.8108,2759.824,2795.3508,2842.5515,2880.18,2924.957,2965.3618,2992.176,3016.4868,3036.4663,3047.8162,3052.2349,3039.5598,3014.841,2994.8804,2982.8806,2973.1987,2970.5884,2970.842,2974.756,2982.1777,2991.7117,3000.7725,3006.0537,3006.1736,3000.9558,2993.2537,2984.2327,2973.7678,2952.4226,2944.7861,2933.7075,2904.6458,2864.769,2808.948,2762.3813,2737.6511,2709.1724,2684.3018,2672.6924,2654.0027,2660.5981,2698.028,2751.998,2810.6392,2856.7905,2881.8284,2889.6602,2966.437,2932.0562,2856.0352,2739.1665,2568.1072,2354.7063,2058.2805,1719.5564,1476.9464,1407.7548,1388.4636,1369.2357,1391.1932,1499.8925,1696.6891,1864.6173,1952.9182,2103.1948,2210.7544,2266.479,2321.4592,2339.5027,2315.8396,2324.5098,2370.8926,2445.0894,2552.9443,2663.6082,2738.483,2785.0566,2839.2222,2845.276,2836.951,2876.603,2916.8943,2956.5437,2981.868,2977.2842,2974.9229,2971.463,2957.249,2944.5215,2943.1653,2956.4597,2966.9304,2970.8289,2968.508,2963.2117,2963.4666,2948.1323,2910.8762,2867.1692,2833.4685,2793.3323,2761.3574,2732.8486,2715.2808,2710.3948,2705.7007,2698.8079,2685.8503,2669.0732,2664.351,2670.3242,2690.684,2697.025,2695.3123,2691.3044,2696.1458,2705.6794,2711.942,2726.016,2742.3494,2765.8547,2801.1714,2842.5186,2885.321,2917.5806,2939.3179,2955.2869,2968.294,2974.3271,2970.6326,2959.732,2944.5598,2923.8008,2890.3376,2854.1064,2821.8137,2792.8457,2766.4338,2736.9426,2697.1682,2650.4524,2617.729,2630.3057,2679.016,2676.1345,2638.2864,2617.0408,2639.0786,2695.4873,2731.8699,2752.9116,2761.1975,2765.0403,2778.3203,2806.943,2837.1917,2855.7102,2872.9883,2891.2083,2909.5435,2925.685,2940.5798,2951.2668,2959.9285,2965.958,2972.404,2981.3354,2986.1929,2988.25,2992.7598,3002.5237,3015.4524,3024.9297,3028.7913,3031.0667,2743.139,2699.521,2620.9219,2471.7878,2260.2522,1979.055,1613.6956,1432.5121,1392.327,1377.7502,1364.8634,1355.4103,1335.3622,1324.7793,1317.434,1319.5157,1341.8878,1628.8229,2014.6772,2165.1155,2240.8682,2261.2703,2229.897,2157.6372,2111.9514,2151.4678,2272.3257,2448.5483,2603.883,2695.4373,2734.608,2747.374,2745.7625,2738.3765,2729.2874,2722.7104,2720.1824,2719.961,2719.5215,2732.83,2756.0295,2765.672,2758.301,2737.849,2706.8977,2663.4111,2622.4146,2582.2585,2544.5505,2508.9646,2476.0435,2452.3481,2465.4478,2496.0593,2517.3665,2547.5132,2582.0713,2612.0178,2653.745,2683.6902,2676.0945,2656.4526,2669.451,2713.793,2749.2712,2760.5942,2769.8862,2785.5366,2806.0708,2822.323,2835.204,2850.5,2864.3298,2878.218,2878.7625,2855.1536,2822.4785,2823.356,2795.6487,2690.9756,2557.5776,2425.054,2310.762,2200.8022,2084.4768,1940.6774,1819.3888,1748.5154,1714.5934,1765.5234,1870.342,1976.1761,2055.348,2115.3123,2239.868,2409.7114,2546.4465,2582.5603,2598.3882,2607.3118,2617.0835,2622.8008,2627.016,2647.2317,2746.2559,2856.6753,2904.625,2923.6477,2944.308,2965.9744,2986.7473,3003.9475,3013.9548,3016.4136,3030.281,3037.3303,3038.256,3042.3972,3043.997,3041.2905,3043.1797,3046.391,3049.861,3051.3599,3051.3674,3051.2969,3049.8435,3047.5383,2419.5918,2321.263,2164.777,1914.2299,1599.2798,1368.5406,1314.9794,1302.8605,1307.109,1278.3152,1287.6615,1294.1393,1301.259,1298.7286,1285.4996,1278.1362,1291.6592,1395.9906,1819.8656,2107.0771,2166.6895,2234.8608,2294.4465,2302.0247,2278.7842,2245.2576,2220.1504,2212.438,2247.942,2304.472,2356.738,2386.7168,2406.7302,2438.8784,2455.4883,2461.778,2467.7358,2463.7996,2442.9656,2416.881,2397.9248,2376.9666,2350.761,2345.2297,2359.925,2372.6062,2398.1638,2429.5293,2462.6985,2486.5637,2494.0046,2495.7175,2507.9973,2530.7708,2550.2175,2563.6143,2579.3987,2599.8154,2641.8474,2680.822,2709.367,2738.3442,2762.362,2781.983,2795.5977,2801.1702,2796.4558,2767.3042,2726.6,2669.717,2602.0415,2540.74,2481.0173,2410.5513,2306.0671,2172.4006,2028.7064,1888.5083,1769.8973,1725.5854,1743.7557,1801.3269,1881.5208,1991.4579,2125.4187,2275.0657,2422.97,2577.0747,2720.8997,2815.738,2862.549,2911.8145,2984.5754,3045.0918,3091.608,3132.869,3162.458,3175.3623,3185.3557,3192.7683,3195.251,3185.4065,3170.401,3157.545,3139.0388,3114.965,3089.5244,3058.0261,3028.7756,3000.0708,2998.6816,3005.1982,2995.5107,2987.7874,2999.4565,3025.9023,3042.0327,3046.2317,3052.073,3061.8716,3065.363,3066.499,3068.1948,3067.648,3064.9731,3059.348,3054.5808,3048.8696,1896.5564,1687.8068,1447.9836,1278.8611,1220.762,1205.4508,1243.1173,1267.6732,1238.7656,1239.3127,1242.998,1244.7148,1253.9634,1255.9728,1252.2288,1251.2736,1508.9266,2023.6003,2121.3567,2149.7078,2165.3281,2183.9265,2190.1306,2158.689,2140.9785,2166.9963,2176.6226,2170.9443,2162.336,2147.2095,2143.942,2149.7036,2181.534,2183.2668,2179.3445,2217.3416,2236.4744,2255.6138,2269.529,2281.379,2284.9187,2279.9495,2264.6567,2272.2485,2307.8118,2333.6375,2358.2153,2373.167,2388.8765,2407.7383,2433.4468,2462.8198,2492.4355,2522.477,2547.5156,2557.3606,2550.2979,2556.9739,2582.0945,2606.3477,2616.5503,2612.6685,2592.687,2555.1094,2501.1162,2421.9436,2320.1875,2215.0488,2107.9153,1977.1218,1841.3967,1740.7477,1769.5847,1871.2526,1940.8718,1861.7141,1906.2761,2143.1294,2382.0994,2568.0276,2683.3628,2781.1807,2875.9973,2947.3943,2979.873,2971.1384,2938.9373,2942.363,3034.5325,3109.2317,3152.1665,3170.3154,3175.3057,3177.869,3181.5037,3181.9568,3165.6309,3132.6887,3098.5862,3061.5874,3013.8853,2950.7463,2859.5464,2754.7446,2665.2368,2589.4639,2507.1008,2470.6511,2487.2236,2495.378,2540.8967,2694.752,2863.3008,2909.583,2915.2783,2989.9443,3053.2273,3060.9475,3069.0647,3075.1968,3076.4973,3074.066,3070.3174,3064.4424,3053.9514,3043.7383,3036.786,3029.2788,1343.5804,1252.0845,1213.31,1201.4319,1207.3069,1208.8247,1232.7848,1239.5776,1235.9276,1235.838,1297.9275,1371.6951,1419.7976,1505.8977,1685.1862,1903.7766,2137.6836,2191.8665,2196.767,2205.764,2210.7715,2180.2434,2121.3564,2110.8655,2173.2876,2264.2231,2292.8792,2283.012,2273.8381,2284.4094,2280.5842,2240.9836,2224.3936,2245.6597,2270.3184,2281.4602,2284.9482,2291.7793,2296.7288,2289.7341,2264.3083,2237.2913,2209.4514,2177.146,2167.1853,2203.1384,2251.4844,2289.1348,2310.558,2323.9514,2341.795,2368.582,2392.3994,2395.6924,2390.2954,2381.2585,2354.2253,2307.0994,2257.7874,2214.546,2167.682,2123.3306,2067.6895,1994.424,1893.4614,1759.8655,1628.73,1561.4935,1550.4169,1561.2247,1614.3062,1723.3817,1790.9255,2044.6974,2448.4734,2731.333,2870.2742,2904.9832,2911.7104,2908.0012,2903.251,2902.2183,2918.21,2937.1624,2922.7292,2899.8086,2893.3394,2878.6821,2835.5457,2827.4373,2840.5967,2849.3271,2823.5425,2759.597,2657.1768,2560.112,2458.8625,2332.9216,2199.1184,2084.2036,1970.132,1890.9102,1906.5835,2016.2494,2335.6868,2671.188,2827.7136,2838.6377,2811.0203,2804.331,2879.8625,2987.539,3009.4854,3019.6013,3039.254,3055.1357,3069.4187,3062.2664,3051.0085,3037.9604,3033.1055,3029.7935,3029.073,3030.009,3022.895,3015.6155,3009.9646,3001.7893,1114.8258,1128.4062,1147.7322,1148.0212,1154.4772,1154.431,1215.3505,1373.5596,1515.7966,1719.7712,1966.677,2125.5293,2223.1714,2292.814,2355.2996,2392.2646,2402.5793,2409.3933,2425.398,2448.9988,2464.7163,2452.083,2392.414,2339.9587,2313.5657,2304.9797,2384.5784,2457.5796,2441.7424,2402.2268,2370.9746,2364.1511,2361.0698,2346.1982,2326.7102,2300.9917,2234.3406,2171.9963,2228.7952,2252.3972,2222.9785,2192.8213,2159.2795,2102.3633,2059.0234,2072.384,2121.4097,2137.2197,2084.0254,2067.7986,2085.6692,2156.0122,2188.1816,2177.9446,2154.0771,2118.8513,2099.4087,2075.0679,2036.7843,1992.8369,1931.5231,1855.3989,1785.0735,1737.772,1747.415,1820.5828,1903.1462,1984.3671,2050.297,2078.3564,2101.382,2128.6619,2151.036,2286.4683,2400.929,2463.8594,2460.0874,2400.3958,2333.2598,2253.6672,2211.929,2214.9485,2239.7065,2222.8347,2177.3374,2095.5745,2018.586,1973.0477,1903.0387,1924.8922,2041.1671,2119.8064,2132.9763,2110.7322,2198.1646,2320.024,2404.388,2493.8137,2570.5642,2632.8992,2701.861,2771.0906,2857.5955,2939.635,2941.395,2934.5242,2938.1394,2932.4875,2923.3408,2913.3525,2896.9138,2863.6167,2803.0562,2738.0645,2817.6152,2956.7964,2928.0498,2915.145,2904.5466,2897.6108,2895.0278,2883.0662,2884.6956,2966.3167,2978.086,2965.0364,2954.151,2940.3647,1057.1838,1068.0559,1065.7881,1074.9723,1204.3462,1560.5449,1809.5511,1886.9595,1972.9703,2105.438,2209.473,2199.0427,2240.6013,2238.7957,2193.678,2357.3596,2436.7834,2448.718,2483.328,2515.7632,2524.0847,2524.7327,2537.1245,2492.3865,2491.947,2497.5627,2370.6592,2258.7183,2400.7393,2391.6426,2274.3035,2370.1348,2408.66,2360.326,2347.3655,2327.5967,2183.7664,1869.7986,1929.2004,2229.8772,2199.3225,2125.9668,2076.0623,2057.5947,2038.2467,2002.8259,1958.5447,1920.8162,1870.2042,1770.0424,1790.7402,1922.946,2009.2231,2012.0604,1997.6357,1959.7848,1844.7574,1701.2781,1593.2773,1499.7512,1497.381,1605.9666,1754.2375,1871.2074,1903.0618,1797.5552,1716.5958,1648.2181,1609.2312,1580.2335,1549.4757,1516.5334,1433.7032,1356.8778,1310.4176,1329.8811,1393.3257,1490.4819,1718.116,1835.3162,2113.342,2252.1982,2322.028,2344.4502,2377.6274,2419.1362,2431.829,2458.4985,2446.2312,2345.8928,2162.6821,2207.2874,2447.179,2730.4727,2933.1743,2973.8298,2974.4507,2968.3904,2958.5364,2951.5579,2947.7688,2907.7852,2852.3826,2817.9067,2793.445,2756.7742,2709.7534,2654.8528,2593.5298,2536.3352,2473.562,2436.7668,2473.7688,2627.4922,2797.536,2860.597,2827.9917,2797.8713,2779.3372,2766.3418,2756.8914,2761.12,2770.789,2826.3008,2869.9285,2853.344,2837.3484,2815.0508,964.489,1018.722,1041.3301,1057.2466,1153.8917,1279.1016,1393.436,1490.7965,1407.7566,1316.2817,1247.3025,1166.3002,1153.9971,1310.3411,1244.7928,1626.4723,2010.2045,2160.3547,2273.4558,2309.4512,2328.882,2378.2317,2413.927,2401.6746,2383.827,2421.0198,2333.0615,2154.6536,2015.3375,1908.8435,1939.2035,2089.3904,2106.256,1957.2336,1946.1317,1996.8523,2038.7983,2095.039,2042.1245,2006.4615,2075.885,2143.7676,2157.2556,2162.4802,2141.0322,2112.7102,2091.18,2060.867,2020.3611,1983.4806,1984.4312,1999.3375,1963.167,1908.2535,1832.8232,1695.8899,1589.2644,1443.9713,1416.1803,1389.4833,1436.4946,1511.2307,1604.619,1629.9955,1590.0631,1897.2882,2281.3428,2150.7795,2101.8372,2167.6697,2086.7297,1983.8629,1781.1221,1778.5712,2157.2595,2327.127,2369.8528,2402.9165,2413.9192,2425.022,2467.7485,2546.8416,2702.1326,2728.1143,2748.4902,2770.8452,2796.7776,2830.4197,2855.0483,2864.0173,2868.6572,2875.3345,2874.2373,2868.7686,2857.7947,2869.5698,2876.386,2846.0642,2818.277,2780.7358,2751.418,2742.7,2696.0674,2669.5867,2702.1025,2734.1145,2794.407,2855.251,2888.6711,2894.867,2898.3274,2933.9724,2932.8647,2913.8086,2898.7576,2885.53,2877.8108,2865.2004,2848.8357,2830.8186,2811.728,2788.7478,2762.9104,2749.7458,2759.072,2750.9744,2736.7205,2721.681,980.2854,992.0005,997.7769,1003.6031,991.5356,989.9713,1016.0885,1072.4027,1070.4753,1087.9656,1080.3608,1103.1376,1113.8989,1093.6407,1056.9132,1084.1276,1108.4749,1154.1946,1235.6842,1347.0165,1402.389,1483.4785,1608.667,1653.6473,1687.7471,1703.6775,1484.704,1492.4596,1546.6664,1663.167,2012.9622,2265.4607,2305.3438,2262.8032,2252.7202,2262.245,2274.741,2232.351,2179.74,2138.266,2170.9768,2284.9695,2335.55,2310.8955,2268.8564,2238.3335,2202.9495,2177.0513,2191.0205,2210.734,2069.6804,1872.3273,1511.7894,1126.1584,981.5683,1023.1356,1293.2479,1592.8967,1780.1511,1987.0254,2067.9468,2071.874,1938.3688,1738.0768,1685.043,2141.3176,2426.7954,2443.5566,2473.2214,2467.9958,2453.7913,2385.3745,2155.332,1960.1875,2265.0002,2483.8179,2539.2869,2593.8857,2618.2375,2634.0444,2655.7163,2684.0828,2748.1719,2769.757,2782.0078,2782.8132,2770.54,2774.2725,2815.8562,2843.1904,2803.3535,2739.1348,2740.2996,2830.8416,2798.8484,2753.7441,2739.2192,2737.3132,2749.042,2757.9197,2766.5571,2764.6755,2756.348,2740.12,2713.3132,2674.906,2636.3882,2790.4443,2840.137,2819.5806,2851.3542,2899.9185,2887.4265,2873.8184,2863.6362,2841.282,2820.8997,2801.9512,2772.1902,2757.7417,2752.378,2726.816,2703.3052,2686.781,2673.58,2658.2224,2618.8064,2584.1106,1038.2668,1014.5208,1016.2142,1010.1739,980.8987,965.561,946.91064,953.292,963.4823,956.9319,952.1681,978.94403,1014.8666,1013.4079,998.8668,979.42145,981.71423,981.7862,976.79,966.7138,946.5673,960.747,986.5499,1042.047,1088.0386,1179.3612,1234.767,1291.3431,1330.7542,1431.6355,1591.0878,1687.8062,1777.0552,1884.3876,1943.8617,1978.6436,2017.7899,2067.1292,2106.597,2003.6321,1987.0677,2151.102,2180.0723,2164.6313,2110.398,2055.9224,2003.8363,1911.1222,1827.8655,1800.1549,1624.0801,1377.4491,1241.126,1246.9624,1348.9539,1455.161,1561.4529,1780.6945,1846.0673,1879.278,1997.7828,2193.3765,2243.3188,1871.5936,1526.4034,1531.8348,2364.8777,2510.7236,2503.13,2473.6191,2400.4587,2293.6711,2192.009,2098.6353,2070.4875,2071.2424,2197.6802,2323.4116,2344.7866,2303.4736,2413.9434,2475.5032,2547.5972,2574.2783,2505.348,2433.706,2375.1438,2383.9658,2250.3235,2310.9998,2562.5588,2594.3313,2534.0315,2545.8372,2651.562,2662.9553,2670.6306,2675.5183,2676.8022,2682.2683,2682.0432,2686.7808,2687.85,2679.6445,2659.7354,2631.7842,2554.7937,2471.646,2457.7227,2602.5295,2757.782,2724.7441,2766.818,2805.9746,2773.714,2740.4087,2708.5332,2654.7441,2629.4944,2626.7634,2633.8762,2573.878,2480.3867,2433.0913,2416.4473,2437.6743,2478.2976,2515.1917,1022.7469,1027.1393,1035.539,1011.6254,1002.2008,995.4803,985.8857,996.69116,1011.111,1008.7235,1014.41754,1007.7836,1004.9133,990.97534,976.26764,1013.4154,1017.88153,1014.06506,996.6704,989.22205,978.9929,962.3394,938.11786,965.6677,968.2615,975.83954,1024.5687,1052.5231,1124.1447,1180.021,1231.3213,1243.6826,1311.9974,1340.9591,1344.7101,1357.8835,1390.4918,1426.2216,1457.534,1438.3582,1464.363,1536.3586,1524.0922,1483.8912,1470.9183,1480.2916,1491.039,1459.797,1407.3226,1432.486,1496.1254,1477.2839,1457.2828,1603.1538,2096.2537,2303.1523,2196.1846,2270.288,2442.2502,2481.859,2423.5835,2399.055,2363.0718,2065.005,1804.7234,2159.7244,2503.9785,2524.2507,2511.0398,2487.76,2465.975,2447.2078,2411.1646,2354.5833,2308.6453,2239.091,2145.7786,2083.937,2045.0735,2084.461,2108.9463,2007.3395,1994.6193,1936.375,1910.4932,1930.77,2157.8342,2402.655,2408.5798,2407.6587,2483.7432,2535.5376,2570.9275,2544.7444,2496.608,2518.0276,2529.2595,2565.689,2601.817,2625.6504,2628.0132,2631.8716,2630.791,2619.734,2602.5752,2572.5706,2515.6697,2414.9907,2302.8047,2424.0254,2586.1228,2511.0488,2465.2632,2586.026,2577.5293,2553.8318,2552.8606,2499.7063,2445.2126,2442.7065,2465.7527,2410.6353,2345.899,2304.0852,2307.4194,2365.761,2391.3818,2395.2903,1087.7051,1091.555,1053.4707,1039.5609,1018.4556,989.6036,992.2847,1003.51166,1022.92065,1014.6812,1085.8792,1240.011,1224.1395,1151.0745,1211.0892,1379.3365,1516.2437,1636.4716,1520.1482,1431.2235,1391.8793,1313.2511,1236.151,1132.6792,1010.0925,1069.2834,1022.9416,948.50183,932.2603,941.76465,1001.32983,1084.9757,1096.4591,1113.3105,1153.3285,1208.7869,1259.4956,1265.1667,1310.4142,1323.8551,1318.6277,1337.3739,1340.0183,1360.6409,1442.7485,1520.7155,1847.5271,2198.424,1982.5516,1947.556,1999.7332,1957.4233,1635.9564,1536.6104,1277.7219,1454.1755,1816.7228,2241.158,2411.1863,2432.7043,2421.9783,2359.4636,2281.3184,2195.2476,2332.262,2480.6191,2525.8,2528.012,2517.467,2497.1414,2470.8489,2421.3845,2369.2412,2356.161,2391.379,2442.0623,2489.6006,2508.0571,2507.5923,2483.5195,2429.7954,2334.366,2137.5117,2099.3665,2367.6392,2458.8281,2473.7761,2471.119,2480.538,2475.1257,2463.4622,2462.8953,2428.9065,2368.4832,2378.6506,2367.3452,2343.794,2356.0974,2422.3855,2503.5898,2496.9316,2499.7815,2494.5254,2478.012,2447.0903,2403.3357,2319.836,2262.5623,2320.6956,2424.1604,2510.2314,2510.0103,2482.3752,2479.34,2475.7524,2458.1587,2423.6123,2371.9165,2366.1643,2312.5227,2159.6008,2123.6323,2114.666,2126.441,2124.7378,2186.817,2241.2446,2221.5935,1431.4468,1486.3981,1413.9923,1257.7416,1263.8794,1384.8684,1496.3402,1478.2017,1386.4889,1418.3999,1605.7825,1747.0314,1731.2102,1714.5524,1711.6897,1713.2612,1783.5204,1858.9397,1790.3597,1845.4374,1926.453,1856.4297,1821.7078,1739.1786,1761.3792,1808.6892,1793.4672,1267.921,956.77594,960.14996,992.2703,1077.7059,1356.2976,1652.6859,1707.5482,1632.2493,1554.3096,1429.6296,1518.8451,1476.5793,1334.9124,1353.8708,1350.3273,1355.6401,1458.3041,1576.0792,1769.9103,1798.8264,1685.1935,1538.9176,1384.3734,1415.0162,1369.4569,1347.8876,1406.8221,1430.1548,1684.6676,1961.6246,1923.2051,1799.9172,1842.1608,1939.5421,2179.762,2458.6958,2616.2322,2633.9465,2612.0273,2645.037,2598.2087,2548.8066,2539.8293,2654.2036,2781.0203,2795.4802,2812.681,2831.5435,2841.9043,2839.3293,2830.4783,2819.9463,2813.1548,2792.5715,2743.5417,2689.9048,2672.3281,2713.8062,2735.5674,2697.2578,2639.0088,2605.7085,2590.9233,2556.2515,2507.1838,2467.84,2404.0654,2354.9915,2318.0679,2306.4297,2299.4204,2309.0098,2317.5586,2340.8003,2327.9644,2340.0166,2306.9282,2237.9695,2101.4626,2308.4463,2434.44,2469.4365,2491.7434,2446.32,2427.4758,2402.779,2375.8027,2352.0144,2306.4634,2270.692,2254.17,2218.1658,2158.1365,2118.7917,2050.0938,2020.7788,2072.287,2093.0525,2112.1667,2131.626,1444.5681,1579.9099,1563.8442,1571.3638,1424.6975,1471.5256,1688.8555,1682.0785,1347.0546,1471.6554,2013.4633,1395.0028,1112.6101,1231.8761,1789.3374,2003.5612,2202.089,2677.1536,2557.951,1975.9595,969.91113,766.50037,775.395,815.46515,880.9851,885.8244,979.56464,1118.7467,1183.044,1456.4531,1826.741,1702.4454,1712.5425,1176.9471,967.60876,932.33,921.4768,902.68024,825.0634,806.4671,809.156,834.5705,868.99036,918.5313,917.9083,884.696,914.60284,1176.7357,1511.1334,1442.2803,1320.9349,1279.8911,1247.5631,1259.0853,1308.5906,1392.2356,1464.4276,1684.0602,1612.3295,2016.8647,2422.4343,2565.6653,2646.006,2691.549,2700.7373,2749.2795,2692.2014,2636.4172,2441.6865,2077.5234,2074.6218,2679.7976,2892.8665,2887.7544,2877.8762,2901.5947,2877.2278,2847.1409,2879.817,2896.1497,2911.919,2908.5918,2793.323,2482.2808,2311.8828,2337.044,2806.842,2739.6038,2677.136,2629.8384,2631.035,2593.2576,2552.6587,2466.1506,2399.5295,2352.3997,2327.0315,2293.5298,2285.3655,2375.4695,2383.1475,2398.704,2409.659,2398.572,2396.9502,2389.7727,2392.6814,2430.1667,2415.517,2389.3716,2381.018,2374.918,2337.7673,2299.578,2270.3464,2231.7517,2188.8613,2146.3232,2016.0919,1990.4956,2125.7065,2046.4436,2028.5361,2074.0503,2030.1737,1973.6711,1940.1532,1902.9558,1878.1443,1940.2859,1948.9999,1768.7026,1598.862,1911.5427,2114.565,2270.637,2294.2756,2353.9832,2594.3826,2366.714,2148.5146,2488.152,2764.052,2784.239,2893.445,2844.9526,2653.469,2067.6716,1167.206,879.873,787.41785,762.77783,826.5322,834.24963,807.1069,926.3729,1153.6112,1518.8429,1920.2928,1707.2485,1571.6576,1291.3052,1315.8296,1630.36,1892.5659,1690.7351,1295.889,1074.7881,955.03,901.97705,901.7236,958.4914,1052.8591,1057.2244,986.721,1130.5176,1088.9097,1137.5768,1177.4678,1162.4551,1155.2977,1193.7944,1063.2618,1089.85,1261.1272,1293.4039,1708.0652,2268.104,2531.3308,2713.6978,2751.72,2778.5034,2789.3164,2769.9026,2741.3994,2752.4966,2680.5164,2679.7957,2726.5486,2614.5737,2601.0537,2768.3826,2766.9531,2726.1685,2688.2842,2640.644,2408.7883,2434.9502,2700.8918,2424.9568,2378.4849,2303.2405,2321.858,2097.8022,2050.805,2644.8306,2624.6677,2564.7932,2557.4055,2500.741,2459.8276,2412.7402,2375.5405,2349.4258,2341.7993,2374.589,2388.1584,2364.6653,2349.187,2348.753,2296.3674,2291.472,2265.463,2299.886,2348.1458,2321.84,2273.0498,2231.5752,2198.7087,2150.8093,2117.4875,2118.6306,2077.0522,2064.1567,2059.1118,2044.1691,2030.3376,1935.567,2014.9501,2031.8833,2014.7024,2013.8202,2018.171,1983.3268,1962.8585,1956.5038,1389.8922,1442.6552,1572.5948,1627.5619,1587.6769,1657.4951,1648.1017,1685.7911,1797.8025,1841.6334,1860.3673,1899.9161,1987.0719,2201.2854,2379.285,2432.9612,2363.4385,2366.6692,2472.204,2338.9473,2128.8855,1954.5574,1864.5759,1692.1589,1753.3683,1690.6283,1727.8516,1677.5896,1767.0443,1980.1168,1838.9816,1556.3801,1367.0114,1357.8174,1478.5189,1783.1146,1890.8015,1920.436,1768.3081,1629.6993,1568.09,1390.6033,1372.1996,1359.9946,1359.4681,1253.7147,1216.4651,1196.0344,1158.7706,1054.7206,948.3548,1002.8802,1032.6764,1096.3876,1056.0518,1083.5078,1136.4113,1154.0536,1398.1432,1967.0815,2071.168,2555.824,2703.5625,2776.0615,2782.8118,2780.437,2822.2776,2827.502,2808.4138,2808.9353,2775.5413,2730.554,2721.3606,2741.1616,2732.3655,2728.6375,2746.3945,2706.9631,2604.093,2664.7449,2701.3877,2736.6594,2599.9053,2430.5957,2521.9016,2456.3176,2463.7876,2431.7883,2389.5994,2564.2263,2538.2783,2518.786,2443.9626,2338.412,2380.312,2450.971,2332.162,2174.0913,2174.6926,2230.848,2236.537,2247.7874,2215.4185,2199.8894,2087.4927,2041.0586,2001.3828,2001.8828,1968.16,1892.4967,1887.9993,1901.0109,1923.9062,1983.4867,1945.8425,1962.1105,2029.7242,1994.6947,1962.5703,1895.3628,1913.427,1961.4747,1932.4152,1823.6476,1812.8367,2012.8994,1977.4373,1965.8627,1307.8632,1323.9285,1338.3329,1374.1547,1419.0404,1517.3818,1510.5797,1481.9625,1571.5385,1562.8983,1557.5742,1628.9567,1727.4641,1792.8167,1981.1235,1993.8345,1896.397,1903.0928,2215.8308,2088.7725,2011.6764,1950.9866,2011.1176,2345.9375,2235.305,2169.2437,2024.3605,1951.9843,2053.9424,1974.4333,2013.4645,1883.1981,1805.0243,1799.0891,1760.0132,1532.4098,1476.0936,1431.2677,1540.1322,1516.832,1460.7267,1389.418,1282.4358,1262.4196,1263.0148,1226.9489,1235.618,1281.5973,1340.6971,1269.5565,957.7061,973.2023,1281.3699,1278.0769,1045.6283,931.1238,1024.9961,1068.319,1102.7478,1192.3385,1576.5872,2160.476,2487.6274,2626.5354,2691.0442,2765.6804,2820.8848,2836.7795,2808.3655,2743.969,2689.4644,2635.2068,2646.513,2678.741,2656.7832,2631.0542,2722.055,2658.6128,2543.1655,2339.3528,1777.3959,2083.1184,2659.3933,2608.7705,2538.557,2535.9734,2537.821,2598.3093,2516.6162,2390.3306,2351.756,2264.3147,2212.7754,2245.1191,2261.0208,2250.6094,2189.4885,1992.736,1985.9135,1853.6008,1943.5989,1991.4485,1941.6382,1810.3083,1736.3086,1615.5929,1582.483,1632.0536,1620.1625,1686.1965,1760.4763,1874.2524,1918.5142,1958.7404,1919.4183,1868.9637,1780.0981,1814.4595,1943.759,1859.7826,1881.3499,1899.8044,1919.8608,1967.0808,1889.1002,1883.151,2009.4473,2056.1191,1323.5514,1306.8966,1312.3231,1315.655,1338.3359,1382.086,1402.184,1337.9121,1325.2019,1493.9183,1458.294,1554.2313,1677.5319,1778.3267,1884.3365,1974.2401,1480.244,1201.5624,2084.671,2519.1455,2511.19,2399.6448,2232.325,2068.039,1949.4426,1868.732,1850.4498,1807.7765,1835.9216,1825.317,1734.775,1627.2429,1641.0803,1743.042,1986.3485,1799.3699,1313.5377,973.0731,742.92377,720.9367,803.9066,1135.5171,1478.9083,1582.7942,1505.6772,1543.531,1888.0968,2175.3997,2041.529,1787.527,1547.3481,1280.1425,1145.6333,1082.2639,1044.5128,902.2671,854.7758,871.5259,819.92145,815.07355,927.4144,1100.0496,1256.7762,1439.9702,1967.3195,2353.7322,2524.3982,2661.739,2660.813,2576.061,2279.7126,2027.6434,2411.091,2559.0928,2483.478,2455.916,2377.703,2372.8347,2096.0952,1491.9847,1295.1576,1833.9106,2335.2288,2411.6877,2389.3757,2415.674,2282.6477,2183.2412,2005.7072,1939.8744,1915.0049,1834.442,1822.7428,1958.1425,1887.7454,1887.8918,1896.1313,1814.1226,1654.1891,1625.2832,1433.8838,1197.4148,1260.0034,1294.5365,1358.4885,1480.7177,1544.6897,1553.862,1566.1339,1628.7925,1750.6633,1771.2307,1719.3464,1714.5182,1755.043,1724.5142,1668.4362,1652.0931,1649.3342,1701.5822,1761.5474,1828.6998,1937.0667,1919.8401,1849.3384,1600.8535,1176.5621,1228.7273,940.7351,1305.6294,1434.2537,1359.0553,1345.6906,1364.1967,1377.0961,1398.7155,1400.5623,1426.8102,1456.4829,1553.0507,922.25543,1010.60925,1838.9882,2038.3492,2104.2097,2159.7537,2171.809,1630.6312,1316.9685,1216.3915,1306.8131,1563.1729,1916.7207,1858.3939,1739.3368,1667.7103,1293.9808,941.10425,996.318,1361.6044,1488.5938,1579.6503,1879.5497,958.77423,271.88867,151.75333,119.670876,110.041885,-3.399064,20.65231,914.73505,1688.8745,1870.7974,2670.044,2958.5327,3010.2969,2130.9082,1684.4087,1664.2819,1439.6196,980.5039,792.2083,817.3215,918.49133,889.5113,946.9675,1080.9327,1179.0404,1156.6221,777.42365,639.50885,458.467,630.0427,1160.2584,1308.4498,1529.0986,1678.5452,1691.8333,1515.3468,1887.82,2362.8438,2281.2876,1842.3804,2235.4014,2211.1987,1890.5925,1260.4058,554.9132,859.1457,1147.888,1896.4875,1949.1237,1811.6593,1536.0865,1306.4364,1295.6737,1367.5642,1511.3914,1655.6215,1693.754,1695.8579,1605.1061,1588.728,1578.019,1623.8604,1595.4227,1402.1157,1272.5063,1139.4219,1079.5234,1093.547,1264.9048,1393.186,1303.5559,1234.0712,1384.0977,1490.9883,1448.9746,1393.7981,1405.4835,1464.9957,1533.7349,1535.4308,1560.1136,1664.6257,1652.5968,1575.0847,1563.0538,1628.6469,1760.8771,1875.0178,1850.9849,1938.2866,1662.611,1538.5383,1518.4829,-57.713993,253.55978,1228.1024,1322.0491,1357.5901,1461.9186,1489.212,1364.9657,1383.5029,1603.4415,1756.171,1522.2509,1376.8285,1562.1743,1766.1476,1600.2084,1688.9109,2257.8184,1487.9003,884.53516,862.54254,799.9341,795.70575,893.6492,1535.5797,1698.1627,1562.7487,1462.1254,1226.8596,954.731,955.1899,1091.3882,1209.0002,1251.231,1345.4274,1418.9752,1197.9293,903.9551,740.0176,653.27264,694.6498,962.64294,1516.0109,1456.0234,1356.7783,1278.4269,1316.8804,1257.3024,1113.343,883.7212,795.7958,1057.513,1233.4451,991.3224,714.55566,419.19067,282.19373,229.96812,189.5629,228.02202,374.23752,449.6477,530.1468,763.4503,1311.5564,1373.3411,1141.1866,945.51276,900.38196,1146.9965,1261.0593,1253.567,1360.0496,1207.3022,872.006,961.7977,764.1627,556.0441,467.36005,625.1796,1178.7877,1171.5258,1165.7797,1188.7618,1244.8904,1201.458,1047.4966,911.8281,879.22565,913.8266,975.7756,1079.8047,1146.3021,1184.208,1239.5582,1369.402,1314.2834,1203.519,1189.0562,1186.034,1224.4105,1248.7937,1128.5665,1173.9011,1066.8145,1006.7538,1072.1174,1024.6913,996.39325,1058.2139,1190.0603,1394.8778,1431.3835,1526.7175,1507.0126,1508.4316,1476.8403,1444.4305,1465.6676,1452.1134,1555.001,1585.4329,1716.4772,1742.5392,1763.1726,1808.7542,1826.7112,1736.4952,1600.0839,1652.2448,1614.9534,1549.6033,1638.7885,1923.9785,2225.509,2039.3304,1876.8932,2065.1145,2135.1492,2073.909,2011.8373,1979.0961,1978.4868,1881.5353,2059.9314,2514.5984,2449.426,1980.774,1899.3677,1668.8314,1588.98,1446.8715,1368.9324,1211.2858,1112.3695,1110.374,1089.1835,1087.4541,1072.0013,1071.8684,1112.6888,1095.7943,1076.6857,1137.7092,1229.8026,1201.1752,1221.4713,1224.2183,1171.9353,1125.8685,919.59106,962.21893,968.8928,970.0544,997.77246,1000.0024,960.0316,911.3332,813.9527,708.53613,834.91833,1175.3672,1458.1908,749.19116,253.62119,190.07529,83.746994,45.266464,83.957275,228.5161,432.4311,401.53494,413.62613,389.43497,449.0012,611.86926,515.8435,587.082,886.40936,900.1697,768.392,732.30396,886.08484,960.54535,955.1366,997.97815,1005.80304,1034.136,1003.04376,948.5995,841.8684,870.74475,858.1512,870.8532,892.62384,875.1871,883.9089,910.7862,943.1626,1003.74475,1087.3185,1181.3234,1278.1488,1307.6661,1229.2941,937.349,708.59937,937.6183,1157.0687,1146.7545,997.0298,935.6566,919.26904,971.9199,978.9962,993.7695,989.78925,1000.19446,1005.33563,1200.6782,1392.1855,1461.4539,1497.8765,1462.4038,1359.5171,1376.6804,1430.7097,1433.5098,1464.2539,1458.0837,1592.237,1582.4467,1626.4434,1407.8275,1122.6918,1140.5166,2136.1316,2165.2002,2223.6108,2231.704,1939.7134,1915.98,2272.1094,2076.453,1860.8035,1833.2349,1809.754,1775.2704,1764.7015,1813.3276,1822.353,1882.4753,1901.8866,1981.5698,2098.678,2067.6848,1594.2684,1531.8643,1899.4677,1808.8877,1681.1687,1695.7297,1445.6831,1276.4213,1247.0192,1218.5834,1204.937,968.6419,1339.2074,1470.8694,1434.7736,1428.3022,1336.3774,1206.0107,1115.1362,1061.2493,986.798,956.0142,1060.8953,1044.9246,966.8624,917.03156,858.0205,811.98553,802.8346,775.45294,727.4423,742.40576,819.48444,1075.0253,1178.6798,1202.29,715.4186,351.68353,265.41537,156.97891,104.39719,113.703064,199.58632,213.15598,97.209206,104.84789,160.43733,165.00368,304.58295,269.35678,220.49028,379.11728,430.52457,468.62476,504.6318,575.14575,712.05554,759.4779,784.2994,790.4466,801.4267,792.71295,838.59705,928.3811,929.5244,938.69293,1001.2662,984.5295,995.4537,1104.8834,1110.9261,1012.64557,1004.08936,1211.9424,1558.5366,1672.532,1761.1272,1539.5695,1237.4513,1166.1569,1142.2184,1089.3236,1065.2434,1006.8067,996.25433,968.17224,949.60583,999.08246,998.97394,1035.9823,1093.5577,1215.9143,1334.6234,1407.1985,1473.9844,1526.1431,1498.4856,1483.6255,1528.4937,1503.9102,1461.3165,1457.1473,1482.3384,1427.2866,1409.6603,1447.9198,1318.8528,1387.6362,1401.5759,2100.4658,2115.5269,2091.3286,1919.0188,1933.7568,2124.3848,2091.8118,2059.881,1810.369,1850.3413,2005.2618,1932.2517,1859.9099,1840.8328,1839.0485,1806.1846,1822.9677,1868.1074,1860.7212,1518.4066,1589.3322,1882.2668,2046.5793,2001.3851,1964.7382,1776.7434,1622.0079,1529.0533,1344.5269,1374.3705,1085.7858,1327.9794,1549.4384,1602.8773,1670.2582,1497.1202,850.13055,853.87024,1021.7882,974.5775,914.89124,863.25684,845.60913,838.1964,835.5508,848.36017,871.73486,830.57947,878.5888,1106.8088,1388.9098,1615.4333,1452.068,1312.3152,978.55646,793.32605,623.90186,267.00076,221.29794,222.16782,295.69058,465.90298,521.373,865.125,522.9962,255.62416,191.79015,257.46625,303.2026,269.23877,340.74246,370.10828,421.5485,504.17578,591.0084,667.41113,761.0507,787.01965,859.2863,863.0008,837.94165,925.87,1074.9066,1126.6056,1160.0336,1188.9829,1182.3385,1255.693,1312.1641,1008.2133,870.9808,995.8391,948.1307,1418.6675,1930.6244,2226.796,2242.6152,2086.0889,1779.6534,1529.6849,1379.4967,1358.7308,1341.9025,1286.1846,1183.9637,1111.652,1081.6191,1091.9496,1150.5918,1270.3785,1382.7004,1460.3085,1429.6107,1449.6136,1522.5111,1600.8713,1632.4962,1691.1537,1633.0728,1711.2908,1646.8406,1609.0798,1606.9543,1493.7985,1440.2096,1522.2806,1550.5852,1879.8335,838.59656,738.4906,1546.1681,2434.6194,2491.1624,2322.5637,2276.1907,2385.0654,2437.9656,2306.0212,2315.4941,2106.4592,2065.296,1963.6127,1885.2191,1826.5624,1881.2833,1889.7983,1916.1053,1979.5253,2220.9482,2165.8545,2155.887,2122.7798,2106.37,1965.7737,1828.6686,1466.1228,1306.7909,1321.7709,1213.7334,1187.4062,1208.5758,1201.86,1306.195,1312.0948,1098.7064,1095.8928,1254.4231,1199.9312,1148.3478,1040.2054,1080.4352,1208.4071,1189.9552,1096.8767,1023.9083,992.57324,1128.0007,1475.1931,1923.7828,2312.9307,2267.6196,1558.0947,1155.2504,1032.166,773.6985,477.84885,326.42233,406.68964,443.48874,738.29956,1309.949,2384.7166,1889.2322,648.722,335.3021,284.37643,358.90964,415.59128,441.8372,532.37933,561.2797,591.2486,651.85645,733.802,753.01624,807.57294,863.2837,898.73486,886.15125,966.1293,1241.0104,1204.8091,1412.7651,1454.3374,1484.0997,1515.3682,1642.3856,1661.4126,1740.5997,1778.242,1466.1377,1343.7809,1742.607,2048.3464,2144.6084,2195.2366,1670.2534,1493.144,1473.4567,1250.8197,803.9016,900.582,1166.5327,1134.4984,1184.8613,1263.2117,1362.8263,1358.954,1430.3599,1440.6317,1410.4965,1436.0687,1571.0894,1708.3293,1719.9253,1664.3723,1676.4606,1712.645,1728.6763,1759.1338,1697.7261,1543.8622,1484.2666,1461.1722,1598.5061,2085.071,1838.6808,1712.7433,2176.4148,2324.5142,2383.6074,2332.1208,2487.5437,2595.3628,2513.1165,2062.9883,1975.4032,1986.8907,2140.427,2154.5916,1965.2428,2048.4382,2020.4584,2014.0891,2025.1779,2021.7615,2123.824,2315.1746,2061.1333,2026.3496,2189.9705,2118.9136,2029.6042,1660.3201,1544.4348,1505.1322,1454.1664,1431.8059,1487.1807,1538.0682,1617.5253,1597.6273,1507.8081,1291.136,1295.434,1272.7229,1337.2871,1590.4791,1804.8187,1991.9365,1886.5598,1666.8959,1478.823,1312.0356,959.9675,1205.1483,1267.842,1184.8926,989.4837,862.9294,843.13403,1059.3015,878.06964,730.5188,850.4338,724.70325,612.4527,676.8674,912.6885,1245.5168,1117.9224,625.6269,523.1738,485.63348,470.7931,473.73782,506.56735,574.62585,678.1202,735.4785,748.89307,768.13684,805.4306,839.85474,911.45654,982.1042,947.10657,1043.8658,1243.7014,1439.1117,1442.8832,1408.4366,975.71875,1085.6132,1481.219,1381.8838,1425.947,1474.2593,1419.1406,1449.0398,1501.6398,1492.6624,1650.9268,1697.725,1580.8474,1862.1038,1477.3462,1213.4227,1242.4229,1084.3047,1180.6907,1190.3413,1263.945,1285.4185,1350.3921,1376.8798,1468.0061,1498.5591,1510.3774,1243.9556,1196.5873,1762.4713,1820.8188,1800.5408,1786.2195,1772.4926,1687.7468,1715.5347,1744.3256,1619.0225,1593.4879,1495.1666,1449.4169,1875.2675,2005.9418,1969.4084,2057.949,2123.9578,2238.0603,2294.1123,2472.286,2595.528,2442.509,1865.7863,1585.1222,1716.8691,2465.1946,2393.956,2316.7222,2284.4224,2270.6592,1994.8344,2147.2407,2138.774,2073.7913,1892.4708,1135.8876,1050.4923,1526.9651,1835.0189,1695.1855,1656.1694,1635.1371,1607.8541,1755.4095,1913.269,1939.0863,1913.3688,1921.1305,1705.8806,1504.576,1413.7557,1335.4497,1195.7201,1234.4357,1240.9673,1281.8563,1185.9058,1233.3397,1193.9707,1027.2173,856.6722,835.85065,1111.8119,1051.7944,1005.41925,917.737,804.3405,764.3026,688.5339,679.64496,654.41974,619.06396,633.1274,728.2172,860.4796,965.3146,672.9231,1152.7045,1004.5628,825.34784,731.95044,729.8685,575.45496,569.3318,657.7769,807.871,838.1854,850.6602,906.7134,918.39795,962.1644,1066.7622,1108.6862,1189.2922,1131.1326,1180.1912,1148.3566,914.4386,951.3049,1138.9807,1171.6515,1124.6367,1083.521,1167.9106,1229.6705,1248.8107,1221.1167,1329.0256,1387.9006,1489.9022,1554.5964,1748.7557,1963.4875,1254.7004,1166.9448,1237.253,1271.0364,1223.7462,1244.981,1337.4536,1521.1617,1479.631,1429.9653,1531.2365,1716.3314,1863.5795,1742.728,1130.1691,1401.33,1986.9167,1883.3646,1576.9159,1489.6382,1795.6757,1934.133,1877.0947,1777.4563,1672.1063,1549.2563,1503.4183,1565.5631,1635.5784,1819.5603,1741.9542,1682.9492,2020.5402,2123.8362,2248.7114,2351.3596,2312.528,2241.4722,2270.315,2339.8735,2531.0876,2463.8447,2438.6328,2437.4006,2389.8079,2351.7454,2240.3298,2081.1885,2073.264,2119.5188,2050.5056,1906.9559,1695.3661,1654.5112,1642.4468,1646.3362,1667.1963,1717.2936,1849.9001,2064.5054,2171.2217,2238.5818,2038.5975,1807.104,1698.9192,1526.0752,1179.4468,868.7281,1107.9799,1087.8274,1052.2383,970.48126,960.5443,980.4494,1017.9322,1057.8627,1005.66113,1016.6076,1017.79266,995.26416,888.2962,842.1113,1012.0359,1041.9302,1042.2621,1042.5345,1002.44116,894.6109,770.2318,821.2475,910.10474,1304.7686,1871.5051,2268.28,1324.4728,1185.268,1391.2496,1172.6154,1084.5497,1048.6405,1061.0082,988.0456,973.6091,1019.74677,1070.995,1104.9285,1136.4307,1149.9387,1164.7136,1109.2715,1171.7131,1149.7837,1087.5186,1125.0259,1096.5881,1065.9502,1082.1866,1054.0509,1061.5267,1055.3612,1105.3909,997.81793,981.75055,1043.6101,1305.7833,1516.6672,1828.7706,1747.9647,1067.3553,1270.3937,1398.2155,1420.206,1553.1708,1571.0159,1556.3575,1701.2228,1678.7472,1655.6246,1678.5673,1881.3596,2024.518,1991.6045,1975.5508,2110.3958,1984.5856,2052.5022,1981.0297,1900.2732,1892.7455,1945.1295,2051.104,2032.1869,1955.8435,1794.2771,1550.9926,1601.0912,1697.3877,1586.2797,1542.946,1725.8174,1859.8292,2004.7562,2131.6663,2283.1348,2226.6392,2000.2795,2224.8628,2377.9683,2401.2888,2403.0728,2420.7285,2436.5498,2380.7808,2341.2402,1996.5829,1260.0123,1458.8843,1930.6777,1821.0592,1712.2743,1665.9841,1670.9409,1655.6678,1712.8353,1821.1898,1893.0598,1670.2275,2287.2756,2129.7332,1536.2281,1408.2478,1485.8267,1966.7045,2011.7688,1772.549,1555.8993,1307.8308,1184.2568,1002.3666,736.9975,930.7611,1048.2006,1092.4565,1195.8474,1233.0763,1312.3221,1229.5383,1067.0927,1042.2786,1034.8528,1084.1207,1355.4203,1969.1243,2246.924,1967.5099,1566.4056,1284.5918,1228.8699,1058.7534,1013.932,1180.3027,1794.1456,2097.6,2094.9836,2113.903,2000.9218,1768.216,1205.8339,1185.4329,1431.4253,1268.0264,1168.7311,1148.9817,1083.5502,1146.6162,1143.1322,1138.2175,1192.5514,1027.67,925.15704,1172.4688,1152.4989,955.16455,942.74365,1118.0853,1057.0527,1033.708,1040.2233,1098.5282,1034.5592,986.10486,1022.1865,1102.5894,1270.7618,1716.1489,1847.2913,1580.4042,1475.8291,1593.818,1512.8564,1534.2557,1695.7466,1669.5057,2029.5135,1867.7765,1644.236,1689.7671,1788.638,1606.6895,1319.896,1600.6646,1898.7709,1827.5574,1787.8851,1786.3467,1884.5856,1922.1869,1953.7849,2003.9904,1940.5613,2002.6088,2145.9014,1662.525,-25.74839,1182.0012,1527.8644,1337.8595,1823.0836,1702.9241,1701.3715,1940.5056,2167.6985,1755.7072,836.04626,1193.7957,2280.802,2331.7822,2343.0938,2367.3599,2411.521,2389.1138,2318.5466,2256.7615,2120.9902,2016.7954,1950.6119,1843.1964,1831.4777,1821.0613,1801.5421,1797.4471,1842.2554,1977.8029,2203.7778,2280.1848,2593.136,2133.2136,1237.4316,1127.5198,1341.3683,1990.1127,2111.364,1955.2991,2171.0342,1852.4147,1501.0924,514.41376,695.3885,1234.4791,1168.305,1188.881,1359.3802,1485.9332,1493.8489,1143.2516,943.42255,940.514,917.3997,943.9459,1054.1206,1580.9445,2399.7278,2169.4055,1889.0675,1745.8252,1652.7048,1595.693,1312.8733,1258.9465,1044.3555,1066.1155,1318.8016,1390.5856,1432.4875,1858.4526,1758.6812,2021.8232,2029.2379,1608.4215,1370.9651,637.45734,714.15485,1108.954,1182.9229,1294.3722,1436.1844,1336.6235,1110.9357,1130.3551,1024.578,1024.6775,1154.2437,1103.6168,1008.505,939.08844,991.5683,1032.2029,1035.9357,1031.4988,1051.2136,1124.7266,1164.9932,1262.4917,1521.1423,1646.6058,1776.3474,1710.3546,1513.1383,1463.6486,1560.9834,1902.9233,2191.7832,2166.0964,1560.6605,1624.9999,1698.6208,1641.4279,1622.132,1465.3956,1488.8094,1622.6418,1638.3335,1679.5933,1725.84,1788.2018,1853.6931,1886.4279,2087.4702,2135.9448,2220.3582,1760.6263,897.5588,1554.8545,1906.2823,1905.4932,1576.0627,1516.6405,1439.7998,1437.9032,1856.2491,1891.342,1916.8226,2050.7024,2157.5916,2203.2412,2401.9756,2331.0454,2249.3318,2201.4192,2122.089,2064.5388,2190.9011,2108.0688,2104.8928,1937.1707,2003.6227,2114.0227,2049.9785,1765.8481,1897.8094,2102.4568,2145.8394,2191.5806,2220.0369,2298.2676,2425.6245,2356.9414,1404.998,973.6758,1034.2963,1627.2441,2545.141,2189.8508,2088.306,2009.9696,1718.5558,1462.401,1364.1875,1360.6941,1383.6807,1319.708,1366.2557,1339.2299,1147.9507,1070.0302,1049.5958,1104.217,1221.8169,1575.5559,1753.0762,1737.6072,1682.0643,1649.7042,1602.2095,1580.3633,1524.9454,1581.2611,1531.6311,1345.8892,1280.3423,1300.4772,1282.9359,1162.7599,1243.0077,1666.2965,1951.4794,1931.6368,1737.3862,1450.1744,1292.2894,1313.1273,1279.348,1431.7228,1792.3656,2060.0642,1500.4253,1233.8263,1280.4166,1438.7872,1310.6907,1283.8132,1211.0626,1179.0859,1136.1177,1125.4391,1073.8683,1125.1653,1188.031,930.03577,771.21533,1313.2365,1293.647,1226.0386,1532.2572,1683.597,1517.9075,1370.7351,1413.8348,1674.2683,1814.6075,1897.5747,1677.2727,1485.8228,1229.2488,1248.3595,1640.669,1490.3947,1238.2809,1445.011,1542.091,1557.7347,1651.0337,1693.0782,1793.144,1604.6653,1675.4215,2162.1816,2057.033,1858.9814,1553.0448,1712.462,1815.8662,1742.0758,998.47076,1688.711,1828.427,1759.7738,1772.3536,1816.8251,1927.6979,1956.2224,1213.7754,1218.6267,2327.1365,2440.2322,2305.5945,2179.6,2059.865,1569.7823,1429.378,1907.9281,1951.6924,1757.5308,1839.6844,1940.9185,1878.9984,1661.6444,1859.3517,1927.3544,1943.4203,1976.2382,2010.6544,2075.172,2246.012,2463.0046,2249.2683,2218.642,2336.7366,2624.3308,2712.8838,1740.9254,1374.7433,1420.8531,1663.5936,1020.57056,1033.5422,1498.7365,1592.811,1483.6816,1489.0828,1490.2251,1476.7478,1424.7914,1293.5759,1325.7919,1181.3905,1109.0635,1156.632,1354.9269,1417.317,1421.7345,1108.2694,1356.6517,1389.413,1462.2677,1568.8119,1733.3152,1751.5254,1645.3269,1386.2476,1213.4337,1609.2916,1457.8346,1339.0754,1393.0787,1520.7805,1451.9664,1281.5482,1376.5559,1401.1044,1561.9601,1648.014,1857.7205,2032.6366,1838.656,1950.5331,2003.535,1962.147,1858.0674,1681.8224,1648.3881,1568.3654,1490.2756,1338.7402,1301.0454,1271.1163,1182.8071,1097.5159,1223.8362,1146.2936,1113.0685,1165.4304,1359.5609,1213.3828,1246.4297,1369.0757,1354.8176,1235.4247,1130.4836,1124.5209,1158.6792,1092.5503,1145.4122,1341.6925,1756.6586,1677.5443,1605.2935,1446.067,1561.3346,1593.0356,1640.5476,1736.6016,1439.5166,1419.2222,2022.0356,2011.987,1921.1338,1415.6141,1558.2156,1736.3878,1887.6483,1983.9332,1931.7827,1845.4219,1806.3247,1791.9366,1826.73,1895.3119,2120.4832,2444.684,2338.0396,1623.4209,1189.825,1182.8387,1337.9442,1945.4274,2049.1997,1934.1824,1820.5687,1891.9795,1919.7147,1800.3357,1780.4955,1836.0702,1823.9663,1874.1113,1920.9705,1972.7001,2034.4791,2074.442,2168.945,2233.6858,2322.5657,2363.2095,2470.2788,2537.8774,2559.6172,2593.6711,2347.3877,1667.6145,1490.1962,1831.3435,1852.066,1772.3385,1307.3087,1807.4788,1744.6125,1740.6482,1724.7976,1634.759,1543.1558,1441.0643,1429.1066,1280.651,1088.1545,1043.8685,1003.95044,593.1853,607.34106,1074.3541,947.3777,803.05945,602.77277,893.0732,1137.4503,1241.0271,1279.7662,1280.2252,1310.7672,1544.0735,1618.229,1572.4768,1436.0885,1307.2623,1335.364,1334.4115,1307.8662,1300.0735,1373.1322,1508.6835,1661.1067,1304.7737,1690.0935,2003.28,2222.101,2274.0815,2303.6682,2144.0203,2076.2568,1989.7101,1878.7751,1711.3107,1560.6722,1448.1901,1317.4133,1247.2468,1159.2212,1114.1937,1149.9124,1231.9076,1194.4822,1101.5493,1080.8595,1295.9543,1318.127,1115.1743,1111.6527,1106.915,1120.6848,1137.1523,1166.9181,1260.0397,1800.1687,1832.8612,1743.2754,1634.1136,1537.3683,1519.2413,1533.7202,1598.035,1577.5403,1608.7212,1750.2941,1759.0736,1781.9479,1323.5131,1491.3966,1676.9403,1858.3938,1769.3242,1342.2377,1348.4896,1735.0653,1821.077,1523.7701,1945.834,1936.7014,2179.136,2152.2183,1226.7745,1059.9761,1076.2628,1229.2708,1840.7313,1920.4517,1884.5865,1886.9094,1851.0548,1766.8134,1203.3882,1509.602,2103.7993,2067.762,2090.3777,2286.327,2372.1555,2433.6304,2440.3916,2313.0923,2169.496,2216.8953,2248.9714,2311.5168,2470.9297,2369.295,2138.9126,2243.5352,1835.6633,1614.2219,1651.386,2014.4232,2005.0376,1994.2256,1927.7422,1865.3357,1811.6371,1845.0533,1773.6075,1689.1624,1586.1571,1430.5083,1260.7311,1033.3544,775.0466,703.7001,598.0783,602.5117,643.06195,420.0774,377.44272,403.2806,498.2774,535.2041,579.30225,618.8476,728.10077,914.5659,1141.9054,1294.883,1504.6238,1490.2805,1240.7158,1435.5903,1463.9696,1534.2224,1497.8438,1397.3003,1465.2059,1681.0962,1829.9932,1919.0128,2022.4459,2237.141,2354.291,2444.3694,2379.383,2371.6252,2230.4773,2082.4011,1928.4819,1803.6566,1692.0979,1642.1416,1717.1552,975.0714,729.8856,1390.5605,1284.8425,1254.1708,1123.6969,1079.181,1125.0435,1132.9261,1152.1802,1194.9296,1196.1406,1224.6205,1249.684,1371.9606,1759.9519,1618.9952,1463.3655,1764.2174,1815.0563,1546.1987,1445.8955,1369.6384,1357.3617,1410.0463,1505.4266,1672.5164,1488.4391,1362.4623,1112.7605,1352.7096,1499.1514,1700.482,1299.4911,489.0946,570.4779,1178.5837,1689.0851,1677.9933,1816.3209,1841.8572,2006.1788,2126.9033,2060.7915,1930.7306,1855.5321,1874.7263,1926.8794,1970.3973,2058.2708,1282.8926,515.0334,1042.8206,1434.2562,2230.1182,2214.0315,2149.6943,2131.58,2282.7239,2439.4714,2468.2786,2322.9153,2124.4812,2065.0354,2159.9246,2271.6401,2395.737,2576.5527,1297.0001,829.74207,1034.1255,2383.0054,2151.433,2012.2412,1915.6006,1906.3516,1367.9974,1746.4294,1995.1461,1943.7388,1841.4288,1850.2161,1816.8728,1747.7837,1587.9958,1311.3275,1080.2721,768.6156,645.6086,514.5252,469.28345,390.25784,302.13553,307.0815,305.63815,380.9949,394.633,455.03625,489.66043,511.5835,585.715,786.1951,926.54144,1076.0408,1320.6417,1380.4814,1218.2028,1623.9448,1844.184,1672.9011,1558.4281,1577.6134,1676.263,1783.6434,1898.1176,1972.7427,2084.485,2249.1487,2342.2673,2336.996,2255.4622,2325.5715,2186.7493,1999.217,1898.2511,1865.7063,2013.0957,2415.9055,2169.6467,1293.2828,1423.6813,1406.9564,1266.8099,1223.6976,1171.7462,1149.7039,1164.0299,1185.5529,1459.8809,1808.2809,2053.139,1923.3134,2002.6167,1516.744,1714.2402,2119.746,2069.16,1872.3335,1596.0415,1391.5983,1259.0887,1198.5319,1312.8674,1900.1254,2615.486,2311.7031,1629.4248,511.4897,594.8494,818.33264,1339.5725,1746.6045,1726.1714,1905.3954,1713.3833,1513.2944,1539.2645,1599.8524,1453.1873,1392.6979,1363.4003,1967.8418,2023.1348,2012.6005,2021.7393,2067.0408,2037.7267,2179.4495,2166.272,2123.33,2156.4182,2053.861,2087.6584,2055.6475,2084.436,2044.197,2065.2456,2126.207,2111.9124,2035.8019,2100.1997,2192.9434,2282.1326,2253.5286,1868.7169,2033.9309,2143.6946,1959.0769,2059.639,2125.139,2033.1707,1918.7665,1837.9714,1716.2124,1730.2961,1938.2346,1950.0562,1926.39,1842.6183,1841.4318,1848.8704,1892.3346,1833.7605,1590.902,1315.4058,959.64667,721.52466,479.15295,180.8656,425.18112,249.61603,286.8524,259.2121,326.4222,343.33517,417.95065,509.66986,516.4962,577.65045,686.4967,758.5476,839.8487,966.6875,1047.0892,1267.7722,1247.5857,1405.0776,1438.606,1446.8998,1511.2386,1582.477,1598.468,1753.247,1842.2559,1816.0295,2085.6746,2152.1858,2191.8408,1970.6178,1959.7004,1588.243,1913.0524,1938.6941,1942.6475,2152.605,2667.8179,2715.3855,2306.3035,2046.5603,1736.0222,1529.7096,1426.6926,1401.3055,1362.3414,1359.1497,1407.62,1490.0984,1826.9357,2337.2588,2464.6282,1990.2161,1687.244,1966.4393,2426.0852,2265.9114,1993.2283,1607.5275,1364.8137,1189.1373,1123.1224,1113.8479,1301.3984,1722.5403,1476.2905,1086.6252,518.4911,611.14294,890.73926,1391.4191,925.11066,1434.7793,1994.7855,1695.8809,1639.7948,1618.9845,1626.2263,1616.2006,1631.7166,1730.8936,2067.387,2283.4233,2307.481,2355.1362,2444.1155,2471.0493,2475.7278,2364.3743,2221.9714,2156.1814,2128.0452,2048.62,1711.974,1214.6614,1695.7708,2059.3167,2006.0381,1994.9407,2002.8308,2074.7144,1809.193,2391.833,2301.21,2263.1667,2175.6511,2002.1002,1998.3329,1916.6461,1899.549,1961.2308,1715.2537,756.33856,596.63116,695.578,1518.8582,1958.2522,1874.1918,1606.4039,1639.9904,1644.3458,1594.582,1713.5032,1652.6519,1351.9113,983.1459,754.63513,549.3602,490.87872,383.5588,309.08435,308.0549,253.49065,256.5714,361.5572,397.9113,376.83054,498.7531,572.7353,646.3328,702.5591,736.376,781.8444,790.94904,956.5424,1055.1328,1107.835,1098.6156,1199.9763,1249.3405,1381.3258,1572.5977,1677.7736,1737.0966,1817.7451,1910.9937,1939.4532,1925.1848,1988.409,1984.6737,1959.6556,1929.5983,1901.4948,1911.2471,2012.4265,2352.7156,2483.7788,2321.3828,2140.154,1963.864,1939.9896,1874.717,1836.979,1766.4204,1726.5216,1722.8203,1760.4922,1851.5115,2118.3179,2258.8892,1990.1826,1897.042,2006.2261,2059.7473,2035.6268,1705.9965,1456.3103,1205.3118,1116.9867,1142.7092,1120.6757,1051.5328,984.5365,932.4618,923.8894,412.02618,784.9068,1173.4546,1759.5016,1237.2513,1891.7397,1960.0444,1939.2557,1971.9913,1960.872,1945.8451,1967.8578,2150.933,2207.792,2082.2075,2014.9615,1843.4272,1798.6434,1949.0892,2381.4375,2552.8022,2576.4426,2478.4592,2382.4448,2250.6638,2056.6084,958.1491,686.70184,765.8987,1668.746,2230.2095,2088.0579,2237.9072,2185.9824,1789.7112,2240.1052,2516.6055,2334.8318,2132.856,1926.807,1910.1173,1918.3672,1936.0574,2044.612,1762.6187,682.85406,571.32996,668.9142,1647.4658,2013.0916,1736.2732,1566.1018,1522.3082,1428.5103,1312.4563,1343.2123,1316.5332,1211.0403,1077.5049,740.9095,553.50824,471.41925,222.53526,280.378,366.96997,296.91653,306.93774,367.8576,428.74814,476.60635,511.42694,541.75244,620.25024,624.35034,666.11084,715.87384,728.4568,844.15765,863.90186,900.3154,958.6428,1040.5376,1121.3046,1298.0869,1420.9435,1377.184,1547.6776,1771.0468,1823.5767,1860.1073,1922.9995,2043.6863,2029.4541,1991.9178,1972.8213,1972.7908,1947.6472,1947.6453,2109.6033,2215.4292,2074.9902,2049.0396,2266.0872,2330.1697,2292.1003,2197.4275,2033.8945,2036.4141,1998.7307,1889.8019,1857.2549,1917.134,1858.2494,1831.4541,1767.6157,1585.4459,1545.9495,1564.2487,1318.2795,1293.9578,1264.6014,1306.563,1169.4386,1145.8014,1067.8643,1056.0602,954.85364,948.06726,-39.83476,517.3862,434.58755,382.1176,573.6116,2030.7139,2037.4641,2321.1558,2231.6882,2388.3618,2467.2092,2338.588,2448.537,1999.6985,1186.133,650.0756,451.94574,403.6111,471.31635,860.29663,1409.6299,2139.2083,2781.5017,2877.4348,2654.79,2275.3313,1707.0282,1413.3406,1487.1382,1915.4069,2035.1189,1660.6501,2250.562,2309.0857,2211.7505,2378.4612,2696.9778,2560.5752,2341.9246,2197.9739,2015.6271,1958.3608,1945.225,2096.0078,2292.8103,2225.9685,2125.3333,2199.4214,2206.9712,2053.0706,1778.2616,1536.0159,1353.2454,1175.9463,1046.8912,924.3042,899.18964,818.45746,753.94025,793.13245,661.32465,580.6551,578.81854,740.3097,670.73724,555.8352,530.3453,492.4706,484.17398,578.9799,553.2984,532.89923,568.11237,585.67847,630.3712,626.07916,699.6628,780.113,787.14233,843.75543,918.2982,965.08636,1093.6189,1220.5703,1441.8956,1614.3903,1672.4124,1750.6023,1803.4485,1880.3041,2037.5051,2139.0022,2135.327,2092.7822,2022.7317,2039.3805,1871.0817,1988.9617,2072.8845,2103.7742,1561.0634,1156.7474,1448.223,2658.4136,2597.4329,2513.0654,2091.7021,2161.789,2111.1086,1961.6057,1859.7297,2105.0586,1912.4318,1753.8613,1734.1088,1560.4474,1526.7947,1399.0442,1378.4426,1458.5012,1465.3853,1499.9225,1299.5275,1317.4615,1208.3342,1068.1469,1059.353,1035.5754,164.30176,303.67484,409.08997,378.80276,436.07837,1241.118,2639.925,2649.5598,2418.6553,2342.0056,2549.7605,2814.8936,2463.374,1225.831,642.68567,387.75134,357.41464,384.10706,444.6693,468.17422,-568.07605,648.5492,2448.5278,2694.173,2394.945,2019.1058,1758.623,1659.2235,1680.7538,1717.0295,1721.4622,1783.8542,2071.5269,2096.3198,2431.1165,2522.8906,2627.2239,2721.1118,2655.127,2439.7278,1744.9009,1930.238,2048.5122,1977.6979,2179.3447,1851.363,2309.0278,2257.416,2093.393,1885.3079,1732.1375,1601.422,1421.56,1074.5627,926.08026,729.33527,802.3057,713.08734,659.91174,797.81396,704.3498,719.1318,667.73254,360.78934,893.4297,877.9009,1011.24884,1076.8018,993.5975,960.9401,881.79346,753.1434,625.2726,550.7716,596.0454,617.84326,663.03973,737.75476,759.939,840.76215,905.0604,971.8355,1080.0002,1139.4425,1387.9857,1562.896,1647.0782,1731.1633,1764.9319,1785.9482,1992.1273,2168.8042,2187.9382,2147.7163,2038.7808,2063.4802,2059.389,2033.1321,2040.7653,2152.8545,2197.895,1978.4644,2409.18,2891.6982,2577.0303,2609.9363,2523.3765,2394.741,2325.6072,2120.5437,2013.9099,1203.1399,317.30292,535.4682,1673.4613,1667.7845,1580.7325,1556.3873,1587.7264,1546.6493,1564.4832,1709.16,1692.9128,1575.6775,1367.8829,1202.7831,1117.3384,1093.766,113.05257,-76.18729,-535.69556,71.306915,349.69952,918.3735,1383.482,1840.2825,1802.2467,2146.9724,2307.069,2437.2039,2460.125,1051.7249,460.9443,311.05307,302.2452,312.75122,330.67746,325.2827,173.90839,1199.0192,2356.3252,2336.5977,2087.344,1871.5436,1676.0758,1634.0665,1690.3812,1705.4504,1342.7805,1693.0637,1975.967,2263.012,2308.5842,2277.0642,2205.7627,2229.2551,2421.5432,1993.46,1041.7346,1287.2524,2150.5925,1853.4077,1677.8551,1758.1543,1804.2109,1854.8182,1635.9518,1506.3646,1433.8097,1491.4097,1570.7766,1379.7909,1045.5492,1104.3604,722.49664,536.6246,845.3786,967.6299,884.0783,730.0852,788.42163,935.14764,1061.1451,1205.3278,1304.5424,1777.095,1993.9443,1968.0374,1506.3663,1058.262,798.35956,595.2971,582.25037,601.9318,634.34454,692.64386,718.4832,837.71136,906.2409,993.15735,1133.5181,1291.6052,1426.7284,1565.0223,1678.5328,1740.1658,1745.5676,1976.4506,2096.456,2115.3752,2116.0627,2113.1296,2007.603,2023.4462,1993.9093,1869.329,1753.9905,2115.6665,2168.9094,2460.8774,2631.2412,2650.5574,2542.9124,2411.8828,2338.867,2181.3193,2091.0056,2044.0989,2013.8241,1317.5872,684.8052,845.7095,1685.6055,1873.0878,1864.1007,1817.7278,1704.4762,1865.4745,2054.1455,1861.062,1673.7289,1616.0596,1583.42,1415.6378,1097.9431,1217.4503,-277.9755,-189.44041,-132.96152,-639.15247,-535.102,220.11182,331.62018,522.9503,718.41626,1506.5228,2192.454,1679.2587,1939.5984,1372.1476,666.5333,496.79117,483.0806,493.82523,369.2808,490.89926,1015.87305,2004.6357,2533.9233,2294.6824,2060.822,1883.6302,1740.0739,1482.3885,1477.9227,1461.1597,1514.517,1898.1399,1991.5692,2129.1174,2424.8342,2276.573,2171.7546,1456.9143,1913.3785,2161.107,1965.8099,1770.8353,1721.9568,1628.9169,1505.7494,1525.9436,1396.239,1437.4768,1393.3441,1319.1292,1269.765,1289.9723,1449.9615,1431.6105,1288.9935,1328.0024,1094.2523,1097.9188,1431.7542,1339.0405,1137.1796,909.1881,700.5857,964.67163,1508.7843,1676.3109,1791.3505,2067.7942,2190.6743,2040.4415,1595.8853,1150.2054,956.36914,788.3077,662.57465,675.8487,516.93823,579.5999,787.5542,901.09534,1004.624,1123.8185,1295.4552,1547.2506,1609.0167,1730.3312,1803.3071,1832.2434,1867.1948,1972.4935,2016.1664,1903.5581,1930.6113,1890.5262,1793.5061,1751.0999,1565.7179,1829.2164,1766.7031,1807.7062,2160.2493,2299.9165,2389.9038,2441.6638,2343.2668,2178.4875,2089.41,1981.9495,2009.7396,1980.112,1949.8007,1702.0563,1466.7174,1654.378,2007.8728,2107.5886,1773.791,1952.6135,2079.3381,2081.7424,2113.7854,1917.552,1731.4314,1684.1509,1636.3007,1512.7838,1262.5403,1347.343,-572.7839,-528.3304,-353.36673,112.6616,366.7278,214.99202,167.24854,-227.41263,-149.34915,666.1897,830.5809,884.0499,848.27246,927.72363,885.8438,1232.0608,1265.2576,1521.7284,1761.3365,2089.3972,2346.863,2617.2888,2386.4058,2079.9717,2049.0332,1876.218,1488.6959,1337.3589,1345.6401,1391.0953,1454.6947,1582.58,1785.6355,1950.2048,2060.079,2157.1016,1767.2708,1653.8518,1977.5034,2191.887,1808.5643,1571.5045,1580.3374,1390.3713,1240.6523,1180.1598,569.3868,1085.4572,1203.2203,1003.38477,1060.1481,1143.0077,1106.7582,1069.3574,1131.8307,1313.0002,1593.5194,1537.8177,1351.1482,1390.0514,1153.8505,842.68634,691.0919,743.46014,1440.9633,1621.3668,1651.8242,1755.6952,1581.2499,1332.4642,1046.3815,950.26514,942.2409,947.0095,693.29785,723.46906,66.374504,185.87024,938.9804,1117.9758,1254.0323,1435.3429,1745.6569,1967.1931,2045.6251,2065.06,2072.0107,2048.015,1960.5331,1894.3947,1809.1412,1728.8229,1637.2855,1556.3899,1491.5477,1349.8357,1121.2971,1518.4231,1529.544,1531.5729,1822.3672,1729.4879,2221.789,2284.2078,2126.6626,1971.2472,1949.7494,1968.5325,1980.1062,1944.6039,1900.1818,1990.0349,2063.6008,2147.3674,2198.124,2177.1023,1977.1434,2132.8115,2232.9216,2230.6033,2125.8694,2006.4861,1890.3691,1642.2676,1510.3518,1429.9896,1311.1174,1224.0608,-673.6277,-558.15344,-341.79453,433.69833,870.1918,762.7932,21.250687,82.515205,50.9725,484.1394,669.05237,607.1691,602.96967,748.42456,763.9567,1023.9004,1394.1434,2039.4791,2246.1511,1811.2075,1801.4639,1756.19,1393.114,1430.056,1403.7394,1376.5975,1357.891,1514.7473,1668.6958,1690.7206,1702.306,1843.6897,1773.2323,2016.1914,1970.4863,2028.0931,1763.9078,1678.1791,2018.9528,1553.1283,1240.4031,1283.3839,1190.7719,995.6596,953.2941,950.3009,904.0288,937.4571,403.68045,-732.4371,-156.21649,718.6169,687.498,757.06226,1271.2747,1489.2303,1256.4772,1535.532,1143.5045,1046.8192,857.5882,762.9971,985.48627,1596.1742,1927.6333,1626.0109,1472.9917,1573.938,1449.4939,1068.1727,758.1429,772.1402,940.7857,1065.8091,1208.4645,1290.6501,1220.2744,1177.3071,1355.296,1321.9778,1385.8053,1256.7242,1568.9543,1766.8458,1900.3875,2041.619,2067.374,2069.6199,2069.8894,1913.5421,1736.2312,1577.5099,1544.6108,1452.8801,1402.6819,1368.9082,1397.4491,1459.8265,1599.9902,1569.449,1603.0039,1712.1262,1966.2224,2176.0847,2125.7441,2113.0642,1996.6208,1699.543,1646.1318,1916.6083,1947.8695,1986.1322,2023.1818,2083.5144,2127.549,2103.6304,2112.7573,2056.0627,1903.5519,2133.6052,1426.1107,1425.9525,1762.8079,1518.7205,1422.7094,1178.8026,1140.6635,1086.7965,-580.39954,-378.97455,-488.16318,-365.5619,396.14166,350.10226,-76.55415,6.959877,522.5358,123.99717,655.5911,1022.89166,1011.0004,1229.8385,1462.09,1200.2134,948.89606,1140.47,1224.5284,1300.5184,1616.4695,1439.2098,1490.9597,1530.1158,1334.3114,1652.8889,2185.9155,3122.868,2973.851,2719.6575,2679.2563,2310.7827,1945.837,2168.2666,2389.325,2298.9678,1441.2211,1657.2933,1558.0725,1439.7288,1373.029,1350.727,832.09814,809.851,813.64374,831.87115,781.9664,818.4214,826.14307,637.2491,457.4596,482.16507,413.7973,396.17557,781.14856,1387.4238,1517.9314,1366.5197,1181.8701,943.9304,938.84326,1103.1362,1490.6385,2096.9307,1940.2095,1517.326,1883.1425,2614.3506,2417.1614,1171.7405,487.56488,435.9992,539.6453,918.6202,1374.3861,1326.752,1234.7573,1367.5695,1236.0269,1280.2456,1338.0094,1486.7959,1611.5206,1710.2566,1721.1995,1770.2653,1744.0802,1779.8451,1963.9248,2011.3911,1553.4048,1484.37,1416.0537,1444.3148,1365.733,1300.5211,1359.5924,1358.8601,1544.2377,1462.9392,1491.4226,1498.0173,1658.9397,2059.4414,2160.1526,1967.9187,1073.4641,904.8035,905.7342,1198.7926,2223.754,2137.1453,2067.0454,2102.4487,2082.746,1954.3333,2039.566,1924.0319,1564.9819,1685.7024,1695.5952,1626.228,1490.6298,1303.6986,1193.6727,1127.2755,1075.2639,953.1974,-464.58197,-2.749199,-524.0329,-720.7717,-820.22473,-358.1706,-525.03577,-16.019659,492.6682,768.66003,759.67633,934.6926,1198.0625,1320.2673,1035.5044,998.5241,818.80884,1095.6184,1723.802,1866.2411,1909.1744,1820.7375,1481.6542,1455.636,1372.1562,1687.6063,2122.8257,2735.0178,2544.4766,2419.4004,2391.387,2038.9354,1888.9688,1790.5984,1616.1688,1419.5297,1464.6642,1795.5162,1956.5995,1841.0815,1558.3689,1303.681,1292.3501,1178.2594,1038.3649,1288.6027,1438.9847,1661.4176,1619.8911,1054.0538,642.22327,399.90326,323.0804,243.09277,275.92218,374.56088,586.8792,766.4259,732.15295,1742.794,1519.7445,1425.463,1429.6876,1682.5988,1459.4703,1185.5803,1311.3044,1437.0879,1831.9172,1799.9153,942.7091,650.7746,467.53143,483.20068,604.9138,901.59344,914.5928,871.7557,874.6184,967.93713,1144.2352,1342.8157,1526.3792,1631.7847,1684.8774,1557.5985,1620.0435,1379.8873,1166.9333,1825.3927,1657.1832,1542.1611,1458.7993,1549.2834,1502.7762,1437.4102,1510.9387,1440.3063,1533.1691,1439.2937,1395.5962,1417.1261,1487.6627,1792.3813,2235.0764,2206.226,1195.3026,937.7291,971.0404,1354.2087,2096.122,2121.9768,2153.822,2021.6912,1903.7686,1824.0181,1698.8704,1553.6874,1470.0597,1439.667,1485.8013,1430.6863,1233.5176,941.1836,940.7254,957.5039,853.1673,815.1323,-1479.363,-940.8885,-1173.4841,-1080.7999,-1014.1625,-1003.3027,-858.775,-381.85938,285.60468,1416.8486,988.3274,1119.6208,1278.0574,1021.64575,744.74414,797.25995,830.93896,1099.2377,1431.8127,1662.8284,1778.8087,1544.808,1197.5254,1824.5333,1735.7499,1687.0355,1821.9526,1839.0759,1116.694,1079.6057,960.773,825.5312,1135.3064,1721.147,1466.773,1576.8715,1451.1289,1472.3878,1382.3353,1970.6771,1460.8844,1535.4789,2041.9895,1722.841,1368.5712,1434.0012,1418.1326,1503.5734,1408.0074,989.83545,698.312,465.25168,393.24265,330.86792,282.58502,107.87865,-68.159004,537.0198,874.3976,1091.0712,1160.7657,1177.4215,1205.7977,1661.3414,2071.853,1724.5293,1229.6135,782.8427,754.0709,1349.4313,1347.2539,1268.2599,929.3163,687.0363,618.0675,623.3013,686.23315,726.1524,781.0757,912.2088,1139.2941,1269.0107,1419.8859,1546.5072,1506.4834,1073.8359,1660.2137,1573.6493,1496.9508,1678.6075,1748.31,1516.0676,1480.263,1636.7852,1832.971,1893.0831,1963.6816,1744.2112,1553.7919,1409.3381,1347.4763,1340.8484,1128.3302,1462.2283,2073.6274,2359.2644,2333.357,2221.337,2175.0059,2505.0476,2588.542,2348.5803,2027.4077,1803.1372,1683.704,1578.5378,1354.8634,1322.1824,1351.5747,1303.0421,1277.832,1250.1699,1127.2634,877.6495,923.55707,971.02057,1037.6187,1024.8137,-1105.0627,-1016.7669,-1317.786,-1160.352,-1107.786,-933.3653,-682.19867,-729.0334,-332.26273,236.61345,506.15488,758.40173,849.60284,700.96204,448.62662,301.87546,904.6262,1105.7767,1340.55,1584.8868,1685.3322,1412.6266,1621.0984,1722.5686,1851.0354,2028.7059,2286.301,1400.5142,16.028032,-120.26952,387.96777,777.18005,747.4469,1501.5768,1458.879,1748.6016,1255.9789,1217.4181,1256.632,1330.1942,1198.1229,1646.2095,1864.7275,1598.4628,1615.9707,1465.4534,1078.0293,918.9772,980.58203,850.5375,773.5349,669.08466,726.1415,765.00476,741.9163,-41.99691,-208.0391,322.08078,859.1078,804.6117,897.27563,645.6991,1013.4269,1667.9696,2414.9238,1731.4755,350.62024,298.31155,473.8951,497.14737,556.47107,685.3028,966.97644,1131.1293,1322.5637,1167.931,1110.4037,835.9164,820.1486,891.0487,1037.9532,1076.3961,1236.7092,1223.1514,1556.7372,1683.2068,1612.4304,1489.6685,1479.8578,1564.9554,2046.8429,1645.6095,1628.792,1728.6001,2010.2964,1874.0234,1158.0156,1007.1111,1617.4271,1470.242,1378.1621,1372.7604,1765.7365,1936.9226,2013.808,2102.1335,2175.27,2341.4978,2430.122,2464.7559,2412.8167,2322.83,2054.592,1359.6865,1508.5718,1401.6522,1414.8314,1329.5056,1310.6926,1272.1874,1224.9022,1201.5054,1131.1033,1005.8322,1076.1946,1047.389,1094.4469,967.36804,-1322.937,-1254.8759,-1158.3754,-1093.4739,-610.36755,169.63762,407.1688,-118.84838,-109.824165,-45.621532,85.95423,455.40683,647.41693,654.5291,782.69916,1211.07,1226.2872,1477.0215,1583.4281,1073.7852,1580.3789,1860.4393,1541.7676,1620.4674,2355.22,2637.232,2706.2937,1977.7805,357.66,117.34582,420.77573,766.75916,1090.74,1565.9725,1430.6553,1255.2439,1112.7567,572.18085,1170.2822,1540.6863,1401.0383,1462.2799,1378.8047,1347.5947,1416.4371,1202.7288,941.6616,921.6882,704.3035,918.3592,1265.4905,1430.4973,1459.3658,1565.6133,1770.3137,1307.3793,911.2588,902.61163,882.61957,879.2119,1019.7184,1262.4398,1086.2062,1225.3473,1382.8992,1231.2483,773.1753,592.504,555.9755,611.47986,640.33704,697.6974,784.2847,1044.7699,1640.5251,1946.5707,1482.5194,1178.74,904.9519,866.3411,927.7452,937.02655,1031.006,1050.8226,1289.1953,1438.4696,1397.6189,1406.2205,1458.1636,1530.6461,2109.6692,1731.1605,1409.3574,1797.7239,2058.2854,1833.9823,1152.4764,1343.2108,1334.5117,1361.4789,1459.9359,1590.9794,1828.7781,1951.4427,1985.5156,1991.2245,2172.4517,2376.6814,2270.5417,2325.6208,2290.5151,2207.3613,2054.461,1668.3246,1634.6876,1510.1277,1446.2965,1386.3177,1406.5769,1409.6438,1286.9827,1224.4082,1151.5055,1156.6947,1118.5593,1180.3014,1109.7607,930.9487,-1123.2245,-1299.7114,-1540.2156,-1181.6012,-67.82743,1257.705,1069.8351,1255.8834,1381.341,937.72217,1593.0739,816.93506,526.0822,443.71396,550.772,954.406,1259.7335,1577.3213,1638.0056,1776.7319,2050.8855,1370.565,98.86019,125.795944,1346.5312,2288.2678,2224.7817,2558.2832,2248.0034,1917.4464,1690.1105,1915.6278,2012.4493,1437.108,1034.9087,983.96515,1079.0042,1255.539,1350.119,1409.6986,1087.072,1203.3751,1207.1461,1202.5375,883.37634,917.81934,879.0796,725.4266,728.93976,940.3809,973.5505,915.2753,990.7877,1240.0391,1935.9264,1858.1777,1331.6938,1047.6869,864.5702,1052.0836,1103.1683,1140.8713,683.7018,1051.3469,1202.1764,1165.5845,1028.8171,903.144,463.60962,812.7234,844.61725,942.78876,897.1654,880.07,936.0182,1507.2339,1789.156,1841.9202,1292.944,912.16656,754.344,932.2748,965.6165,948.3856,1116.7515,1255.0881,1063.3354,1381.347,1611.5729,1886.7345,1732.3528,1172.7522,839.347,1381.9772,1405.225,1630.111,1557.954,1406.4932,1223.106,1107.8392,1286.2478,1550.2936,1780.0144,1652.154,2015.8351,1931.7681,1947.947,2007.7845,2258.155,2176.8542,2160.0833,2128.368,2035.2573,1903.6005,1760.6714,1645.7368,1581.288,1552.1106,1541.2847,1502.0935,1433.4088,1323.1886,1295.1873,1218.9302,1197.9596,1265.1997,1115.623,987.18915,-2427.4456,-1663.115,-1456.4344,-1345.3844,-1197.5897,-657.49725,-251.94795,449.7272,602.4354,364.9801,921.66956,1444.6849,444.91116,39.948956,86.36164,243.78662,456.36218,958.69275,1192.1394,1189.5939,1392.8014,719.2691,-11.951458,5.802025,769.5342,1867.9623,1533.8118,1577.0931,2022.0764,2416.0955,2490.3962,2546.3398,2250.054,1570.8633,1085.062,964.8112,971.3934,1036.4113,1094.4948,1184.8914,1641.89,1521.1097,986.13885,894.78546,776.8856,767.8089,756.51807,806.7816,1043.842,1015.5338,880.8301,841.0235,881.363,1195.0769,1825.2252,1591.2623,1392.8064,1366.3529,1204.8486,1005.6034,952.989,982.76746,993.1868,1035.913,700.90015,1227.1696,1029.6947,1159.7345,1124.3389,1088.591,1195.5847,1293.7091,1360.42,1205.5312,884.50586,1107.9604,1213.909,1663.808,1881.1083,1364.3342,948.08386,801.9723,827.6293,815.7799,867.2638,1073.1497,1029.2963,1285.7809,1180.7715,1329.1559,1153.1277,908.4815,894.98456,921.1627,958.0705,1087.0547,1143.8445,969.1223,815.7519,782.3377,891.124,1167.1996,774.315,1154.8489,1759.5573,1615.7103,1146.4037,1573.9879,1838.8259,1843.3895,1870.7935,2006.4346,1961.0175,1998.2731,1931.8322,1928.66,1908.6504,1902.5651,1880.0354,1807.3573,1604.1615,1423.4359,1388.6729,1363.7688,1350.3551,1269.8135,1213.1758,1105.6891,-3088.214,-2638.422,-1353.8229,-826.4423,-1038.4585,-1232.5184,-1311.967,-1225.7356,-984.9819,-893.89526,-714.44574,477.77295,-520.88086,-969.1622,-479.31134,565.6046,494.44742,722.211,1250.738,1211.2467,1635.8121,1936.1576,1374.2631,1325.0593,1545.7799,1525.4685,1271.9404,1322.0002,1824.2356,2221.269,2287.9934,2141.4836,1976.2555,1604.0989,1392.1404,1289.0426,1271.8489,1033.4038,1026.7246,1171.068,1291.58,1038.1764,870.35077,849.51013,836.172,842.02295,962.6122,1031.9551,1288.6094,1046.9806,983.9944,1135.5167,1048.033,1404.8937,2012.9457,1773.323,1555.0522,1447.6768,1174.0798,1007.59424,993.04266,1020.02747,1071.7701,1136.6826,1221.7692,1419.8472,1170.372,1648.4413,1630.598,1512.2659,1098.4153,324.95508,1358.2269,2222.5737,1682.6038,1463.8916,1287.8151,1472.595,1694.6149,1112.8204,934.9571,836.46783,1052.9308,963.1648,1080.0737,1557.959,1958.3928,1441.8307,957.8818,859.1599,937.96704,655.4121,921.2408,730.0449,778.1191,1196.4291,1510.049,1168.8832,608.09985,600.30817,680.8413,758.3425,841.2203,1120.7864,1169.6578,1248.0677,1264.0159,1391.4058,1478.7292,1613.3357,1778.4257,1903.9384,1556.9608,2191.451,2182.1035,2266.6404,2325.9438,2307.5085,2037.5251,1916.1415,1871.3846,1729.9014,1729.9634,1497.2643,1446.196,1394.1741,1338.9502,1209.3011,-3992.5903,-3777.656,-2728.316,-1497.6643,-1358.3479,-1099.0931,-838.67065,-446.26334,-436.50873,-182.0162,-301.80963,-163.24281,285.0108,21.967,-84.76932,-76.17186,-43.780403,105.52132,577.863,1008.9623,1556.3794,1917.9071,1708.9216,1475.7999,1312.3497,1195.2938,1088.78,1114.2584,1516.0883,1851.7925,2159.328,2017.477,1705.4152,1467.4407,1485.2449,1719.2803,1682.8243,1439.1288,1184.3214,1432.5886,891.35486,996.2811,965.2984,1361.4824,1465.9902,1391.9006,1331.8502,1219.8424,1120.645,1151.6952,1202.0577,1612.3536,1502.9043,1268.8304,1468.9001,1642.1489,1309.4364,1550.0042,1266.6758,1197.6704,1150.8,1136.5562,1162.8202,1229.651,1371.3635,1444.639,1595.2892,1767.6798,1652.5726,1427.7885,1855.1215,2316.3523,2685.3755,2765.6287,2693.0012,2166.8442,1594.1737,1474.2181,1368.5432,1088.926,1225.1455,1143.9012,1766.3053,1676.9512,1806.706,1712.5388,1492.2698,1342.703,894.7781,762.3296,789.1867,234.02951,623.80273,-47.9056,-48.935368,889.32477,1768.8927,1608.2411,566.5884,541.9447,603.36383,668.99316,743.97394,830.1317,801.8355,903.301,1015.77637,1178.8995,1388.315,1593.2913,1778.0836,2001.9283,2088.5393,2206.5132,2323.5137,2467.4907,2498.467,2335.521,2346.3628,2244.9026,2087.1755,2075.8726,2032.3445,1782.5077,1636.7794,1583.6519,1532.059,1431.806,-4816.9854,-4149.471,-3578.6028,-2374.857,-1622.5896,-1331.7709,-1028.2056,-39.63753,96.12297,-223.46432,-632.4005,-668.5711,-267.69116,85.23219,-112.917046,395.7239,-59.40308,-189.56293,-45.571445,133.84735,613.52594,1262.2246,2180.5898,1818.847,1574.6818,1469.6847,1112.4683,828.2194,1051.3685,1430.2317,2107.7253,1660.1268,1212.9032,965.58606,1319.4159,1806.1488,1904.6868,1535.3795,1473.1006,1173.0427,1083.1123,1498.0911,1601.9135,1611.2239,1420.6401,1480.4774,1446.9666,1362.8196,1402.8713,1437.0864,1744.3419,1876.8835,1508.0945,1228.2373,1163.8644,1296.3956,1293.311,1224.3499,1316.281,1247.9766,1323.5737,1350.5956,1425.9686,1488.4865,1461.6902,1542.0542,1683.6722,1928.934,1938.1097,1923.9938,2196.6458,2201.2788,1592.3303,1532.2909,1775.1705,2184.649,2353.5295,2294.3223,1820.9362,1660.6187,1881.5011,1853.8301,2079.6074,2015.3811,1927.1167,1638.5211,1023.91394,862.4773,797.24335,678.70953,750.60834,908.04675,1013.17847,604.3573,494.9377,732.8299,892.4599,717.73865,504.0306,574.3278,618.4986,671.48175,723.19385,813.50214,858.6488,923.2902,1069.4341,1272.3918,1609.8083,1831.3826,2015.7482,2070.554,2219.2896,2184.184,2290.9622,2375.6982,1922.1146,2146.8704,2109.7393,2131.83,2166.3389,2237.924,2190.8816,1983.894,1564.0798,1862.9658,1757.9379,1866.5316,-5356.185,-4648.178,-4232.635,-3299.954,-2779.8635,-2330.8826,-1850.0543,-1442.2281,-1181.43,-778.60815,-716.2752,-656.1859,-295.36795,-160.2587,-317.42636,-338.38446,-387.8349,-387.23663,-161.68333,-37.11001,783.20154,1896.3143,2666.6113,2211.6072,1944.5618,1613.7659,570.3052,353.0332,405.22192,497.64383,582.3308,698.71466,683.8326,761.9295,834.0117,1094.6544,1086.2682,1543.6956,1464.5381,1090.2993,991.88916,1442.2273,1578.8064,1126.8687,1173.3604,1810.27,1632.3466,1474.365,1742.2224,1806.3351,1398.2255,1476.5858,2025.4244,1390.2384,1263.1517,1442.9299,1661.1709,1793.0865,1549.4332,1468.521,1492.7295,1599.3309,1742.6538,1767.479,1778.1937,1824.6511,1934.1459,2092.388,2448.5415,2553.707,1809.5012,1392.5632,1168.179,1223.428,850.7927,784.50244,1590.7863,2553.3486,2150.0625,1914.8428,1806.0472,1613.344,1868.2207,2154.3894,1701.0272,1297.1965,835.24786,741.3929,769.4888,762.54266,727.4309,794.6659,478.53497,733.7867,615.5818,525.5669,511.76254,538.07385,557.81525,559.139,632.08685,681.991,779.64716,881.33606,877.2717,1049.2599,1344.3978,1332.7527,1870.9934,2371.0684,1447.4208,1131.9005,1751.9501,2062.55,2149.625,2000.7827,2030.3357,1928.7115,1901.4375,1928.1681,1962.6586,2130.85,2128.2356,2010.5902,1897.6779,1845.1223,1503.5015,1821.9065,-5412.985,-5150.5396,-4762.718,-4216.5923,-3936.3347,-3203.9185,-2730.942,-2139.3574,-1430.5502,-1270.4375,-1009.8289,-552.92035,-355.01816,-462.25906,-370.50433,-334.90195,-213.2118,-315.09543,-260.2129,289.53006,27.54627,436.93686,1071.2521,1410.8181,1364.4225,922.6893,500.77045,681.1358,818.76465,765.17255,667.4435,1148.4666,918.2471,1308.2466,1305.2407,937.84045,831.10236,917.2805,923.894,905.3525,932.471,1003.26013,978.00415,998.10864,910.365,1697.6011,1860.4434,1560.1482,1450.4103,1988.2782,1780.5616,1815.033,1636.0222,1339.452,1435.8167,1830.7117,1923.8918,1488.1158,1566.5273,1567.9283,1492.4783,1346.3063,1719.7793,1938.2659,2123.574,2208.622,2334.8813,2499.043,2772.0117,2566.2727,1495.7094,989.0699,928.0018,894.23694,927.0867,794.0961,838.67255,2237.0269,1915.8495,1626.0774,1835.5321,2022.1554,1321.5264,1118.1941,1339.3715,1026.816,887.44073,811.1364,920.44965,985.8774,913.6537,986.3325,857.2871,672.99176,562.4421,504.09674,668.2194,739.2678,650.90753,639.4748,719.5273,750.07623,947.6645,1074.5624,958.6624,1370.3276,1595.622,1972.8821,1858.739,1750.5514,1832.8241,1706.8005,2001.598,2033.0537,1965.7499,1659.6764,1934.5587,1891.4482,1894.4468,1904.5879,1925.701,2043.5846,1917.3662,1846.3752,1792.3585,1744.3276,1766.407,1897.9043,-5351.78,-5074.9473,-4859.0376,-4672.139,-4362.5415,-4094.3396,-3485.8757,-2549.9468,-1462.727,-1095.9705,-1260.7006,-1134.2775,-821.19226,-532.67346,-638.0667,-582.9761,-361.89587,-254.40051,-381.26624,-333.24338,-341.99866,-246.82181,15.738096,622.5915,514.03156,277.12372,689.6522,1474.5939,1213.1909,863.3689,1124.9702,1896.7336,1204.8903,1646.7239,1624.2152,995.88385,795.42883,856.281,855.9868,882.87274,970.6097,1091.0958,937.7007,994.93756,959.104,756.33923,1415.3802,1756.0095,956.39044,2148.9226,2510.571,2129.2512,1421.1592,1393.7769,1703.0217,1928.8523,1862.3593,1712.584,1623.5006,1599.529,854.2089,346.6779,929.4564,2105.4236,2190.1545,2260.7004,2501.146,2816.59,3046.0825,2994.7632,1711.1715,1047.9384,911.17834,894.34106,959.40265,900.6057,1460.0188,2271.7866,1793.1787,1412.1886,1364.9379,1624.2473,1161.7795,1030.9086,1379.2584,1053.8345,891.1202,938.3472,1149.277,1386.1339,1497.6705,822.4867,723.17554,474.39722,537.98883,619.3656,820.4382,858.806,782.66223,889.22577,1040.8628,801.89746,945.408,995.5005,953.14325,712.5797,1712.0829,1934.3289,1501.7594,1246.61,1770.2485,2084.477,2082.0347,2088.1216,1981.7687,1896.1013,1933.7654,1969.8269,2010.7532,2046.801,1998.2499,1893.4321,1815.7183,1766.9689,1742.8037,1743.1641,1791.1321,1906.3171,-5401.0664,-5263.2993,-4996.2534,-4586.9,-4420.9453,-4251.0366,-3887.3218,-3093.7412,-2105.3562,-1483.7961,-1356.8512,-1224.1294,-1122.9493,-900.6272,-637.5197,-510.70477,-262.7725,-285.70093,-481.38757,-535.9352,-498.5924,-250.2398,97.04261,469.38214,162.9648,531.02264,898.9569,1058.1295,897.79114,1035.1451,1245.039,1118.9985,735.3822,779.0836,791.72217,829.5931,861.6184,928.9132,1047.9536,950.34235,900.356,896.238,916.5254,1005.06024,1059.9082,1352.7185,1403.8372,1403.0438,1481.6771,2071.3608,1928.701,1638.277,1591.6473,1512.0466,1887.5751,1913.4867,1738.0321,1832.5383,1803.1937,1714.9822,1588.8193,1184.2041,1815.5398,2168.123,2060.6047,2191.956,2469.4856,2906.5576,2864.3628,3000.3767,2799.3313,1492.1588,1064.0502,976.8864,1271.3503,1520.3036,2553.902,2291.6057,1712.4742,1341.1407,1054.6719,943.33636,628.09406,767.7167,936.9628,1312.4254,1027.0771,978.22296,1628.8192,2281.3022,1740.5046,975.58295,642.13776,601.5578,871.1796,631.95355,765.77936,1019.54,1262.3469,1172.3055,967.67065,789.2581,808.0773,908.54456,1064.2365,1291.6503,1543.8298,1720.8347,1942.642,1904.6328,2008.2275,2159.0857,1275.8663,696.22546,1830.2007,2072.1516,2190.2976,2306.1348,2339.5251,2242.4614,1938.2164,1867.5642,1795.0267,1795.1401,1820.3418,1800.0656,1863.3124,1924.2805,-5542.4297,-5330.6255,-4998.393,-4651.436,-4412.528,-4210.043,-3842.664,-3039.8489,-2185.2483,-1728.9086,-1412.3439,-1237.8884,-949.597,-663.3761,-741.14014,-569.1597,-263.8753,-234.30281,-507.2915,-534.3768,-425.4963,629.21405,1359.5735,692.10956,683.7045,1270.8838,868.2644,519.5987,521.7062,609.2709,799.1236,759.85925,676.2115,775.27094,972.0681,1310.4,1162.2509,1120.8368,1209.3822,1016.1786,1221.1442,1046.2789,1111.783,1095.1991,1286.0498,1394.9664,1832.8872,1633.3524,1494.9336,1697.5735,1197.2297,1331.9569,1919.4789,1506.5184,1571.7612,1641.1703,1556.0055,1750.5173,1888.8912,1805.0104,1979.0256,2183.977,2057.3215,2031.5829,2033.3903,2026.0111,2262.747,2423.7988,2264.7952,2943.0955,3023.7888,2564.4075,2173.311,2089.156,2353.9685,2381.1514,2382.784,2091.9216,1758.2974,1324.8188,996.2133,759.212,511.08923,482.487,597.86316,875.1903,820.79065,794.5402,1025.1031,1196.3491,963.3104,703.813,529.94946,571.41223,1001.0277,1316.977,1071.1035,852.49243,1141.929,1064.957,862.38586,766.46204,814.9937,917.2866,1017.207,1282.676,1696.425,1847.2206,1822.7904,1813.8414,1848.6821,1988.5522,1868.4464,1634.1278,2101.4148,2509.523,2825.153,2792.2861,2620.9126,2315.7622,1764.3684,1877.8794,1842.4238,1818.3135,1791.3928,1753.568,1760.2618,1832.7867,-5461.2524,-5296.1,-5116.7656,-4899.329,-4540.549,-4223.924,-3870.9697,-3368.4749,-2520.4922,-2109.362,-1871.0138,-1606.5786,-1317.2463,-1014.5196,-847.678,-686.16864,-432.08475,-372.43292,-435.61163,-479.14203,-530.2865,-445.45963,-321.82425,-291.73315,-22.208788,374.73398,976.1804,871.53125,937.1945,597.06476,713.69037,650.82404,694.3989,759.45013,963.0832,1078.5126,1600.1877,1692.2777,1595.1254,1403.6943,1358.3308,1345.3176,1209.1514,755.24945,1081.2621,1139.1943,948.8776,880.7836,1483.4364,1403.7372,1395.5281,1234.0161,1726.6222,1566.0676,1497.76,1505.7592,1547.2017,1562.6699,1948.1816,1607.7615,1564.496,1868.6174,1990.681,1942.7479,1972.1104,1992.1948,2061.2217,1984.7311,2224.1377,2647.4722,2534.5725,2443.4946,2685.5984,2794.6758,2553.4482,2084.0815,1648.7487,1877.6245,1569.6455,1316.5558,995.77893,699.02734,538.97217,421.5726,302.28394,397.26233,648.0916,767.67126,736.8475,605.23474,560.92645,590.5969,537.30994,579.60754,855.9995,1044.4438,873.80707,924.9987,1124.7305,1113.2552,888.96606,892.59033,926.1295,1027.049,1257.9374,1636.8727,2042.6835,2073.7075,1928.3319,1764.1412,1659.822,1591.3395,1680.8821,2002.0608,2126.2246,2370.0532,2728.617,2849.2727,2601.5828,2348.7732,1568.2351,1717.6439,1678.6458,1615.0833,1565.302,1408.4829,1416.9698,1710.2803,-5252.632,-5079.25,-5010.7617,-4862.469,-4539.872,-4186.9165,-3832.2234,-3358.1309,-2789.126,-2235.9275,-1600.0483,-1427.1497,-1339.4745,-1158.8417,-1021.3631,-862.50867,-1226.8253,-1310.3687,-1190.7925,-688.2473,-640.69543,-395.2906,-313.6512,-273.70914,-219.51965,-84.69968,266.75278,552.72034,1465.6761,762.47705,476.86014,632.6982,716.03656,763.0049,705.1526,1071.957,1721.702,1665.451,1593.6256,1241.6531,914.4407,556.944,896.9953,904.9143,856.44995,811.8618,666.79535,675.30035,1197.6664,1199.7296,1332.9525,1062.6632,1519.7363,1492.4006,1431.6516,1460.6793,1536.3839,1671.1772,1681.7642,2035.7893,2021.8975,2270.6892,2136.9038,2028.2932,2072.9043,1980.6683,1972.9922,2073.8396,2145.9612,2193.4553,2299.0017,2434.2646,2558.132,2585.1975,2456.4707,2206.2048,1895.0295,1820.8864,1553.635,1317.8,854.90106,587.2907,234.98048,46.892178,284.53223,268.30713,339.65613,424.47113,694.07904,534.01904,532.82446,517.4002,607.028,792.7377,1009.1285,1146.3684,1019.1561,977.29224,1034.3386,985.9569,798.1795,1048.5804,1163.6141,1368.0837,1261.0704,2028.5044,2528.815,2212.9082,1866.8954,1688.0226,1556.0574,1488.1093,1563.0679,1656.9979,1765.3551,1323.8953,1172.0505,1951.6339,2233.8772,2040.7748,1757.5314,1440.9453,1577.4834,1412.1613,1216.2579,1271.637,1279.166,1362.947,-5057.5293,-4887.797,-5013.8984,-4833.733,-4517.553,-4166.4365,-3731.779,-3296.7034,-2902.6877,-2456.8044,-1991.9629,-1639.6439,-1429.515,-1337.649,-1178.0975,-967.6873,-849.55835,-1394.748,-1387.127,-930.02106,-576.0588,-397.15903,-296.51758,-229.61247,-205.9074,160.98447,1241.2084,6.997094,1149.8319,841.5644,579.8529,612.27997,857.5225,821.32184,684.8416,807.6541,1033.7618,1416.0529,1050.1346,737.5365,650.8009,370.57642,1121.2617,801.04626,724.2976,725.99664,765.79004,858.259,1102.228,815.2832,947.0206,1263.6332,1507.8353,1451.7207,1442.8727,1521.5505,1548.8777,1608.7765,1775.2498,2160.5474,2098.3528,2129.734,2196.507,1963.7137,2149.7463,2127.2278,2036.7429,2094.2688,2244.2957,2188.3337,2178.1533,2169.433,2238.9602,2294.4216,2329.7402,2283.5125,2142.4126,1842.4647,1484.3594,1187.6406,788.853,511.397,383.95642,279.9762,225.63202,204.55443,329.40976,498.5348,689.1829,655.8445,880.88916,780.6907,702.4818,997.28864,1244.4484,1313.0239,1209.1172,1098.1569,1013.0029,1001.0365,987.8305,1035.2809,1333.208,1120.5085,920.82587,2348.3428,2905.355,2199.8733,1827.7854,1567.4418,1514.4092,1457.7516,1518.0142,1569.5809,1565.1509,796.99585,637.61066,1293.276,1815.6727,1809.2721,1734.3518,1596.9478,1445.6105,1264.1378,1259.0558,948.38007,1032.8076,1238.092,-5028.3115,-4968.1045,-4764.9814,-4623.1797,-4350.5977,-4052.533,-3719.2869,-3287.1006,-2831.6638,-2518.714,-2180.6553,-1737.5022,-1463.0951,-1267.2467,-1029.075,-882.0645,-741.6643,-1614.5493,-1386.7472,-876.6401,-307.20013,-197.92033,-483.13583,-257.3792,-214.82344,-98.94635,154.84912,783.60486,1965.894,1571.4108,800.17865,836.2742,213.0568,607.9347,803.8145,936.0947,1107.4437,942.4334,719.6936,829.20386,642.65247,654.2998,693.8577,704.1218,710.1708,728.4736,716.1289,779.4734,872.3486,816.86865,1012.4904,1316.3906,1364.5845,1256.19,1428.155,1525.3147,1528.4728,1576.8323,1605.4197,1239.7548,2043.7394,1988.7563,1959.2172,1660.5939,1862.3917,1897.3906,1862.2681,1734.9226,1966.9149,2226.7393,2296.464,2357.32,1946.8484,2189.5088,2100.0938,2076.0518,2044.9121,1806.4279,1465.0398,1097.9111,747.61115,526.14417,439.34866,275.93567,229.14276,224.67896,325.44736,467.89886,860.6586,967.47943,908.44006,683.15137,712.5793,1131.1907,1613.2363,1636.9689,1407.3751,1271.7848,1194.5559,1059.9749,817.6848,995.7871,1302.1465,2060.566,2562.5317,2724.6812,2755.2988,2140.1787,1723.9972,1505.384,1345.5869,1435.9688,1521.5875,1545.5786,1686.2462,1602.4025,1566.462,1634.4187,1678.5359,1718.2878,1750.45,1481.5891,1254.4701,1040.7638,1228.3123,603.4502,665.3288,1463.024,-5046.0933,-4876.7,-4727.6377,-4501.1963,-4225.643,-4040.3696,-3740.7688,-3223.6174,-2777.2976,-2582.064,-2308.0654,-1923.0376,-1534.9255,-1227.192,-1213.4309,-1773.903,-1567.9915,-1805.8619,-676.283,-565.273,-23.18897,518.9913,208.25597,150.78645,-90.7771,-59.30583,675.9219,1579.0619,1303.9838,1159.8745,1064.1799,911.1012,607.3767,699.52716,727.0852,709.851,749.5918,712.4472,571.2194,569.8819,605.19696,613.59656,601.58203,609.6611,648.45105,618.65704,664.7808,1094.1947,1017.1818,1011.1567,950.75354,1306.0511,1346.418,1375.9255,1612.2937,1602.4426,1551.1757,1539.652,1523.6542,1863.2963,1936.1901,1973.9532,1945.3022,1460.8027,1808.0205,1821.1744,1645.1615,1661.1815,1776.3265,1951.2264,2038.9581,2164.1443,2180.572,2385.6213,2264.4158,1999.6984,1897.8218,1731.1871,1397.1255,1075.0856,894.97455,675.3249,585.85565,528.45636,466.51373,477.03052,536.34766,696.0387,1128.5199,945.3511,557.0809,398.63342,615.0654,1211.9258,1796.53,1928.238,1610.9838,1424.272,1331.0786,813.94305,871.168,1142.9095,1314.5928,1830.9347,2251.355,2216.015,2332.843,2171.3691,1892.2354,1542.2122,1297.8878,1366.9753,1363.8917,1788.9012,1838.3035,1389.9037,1385.9341,1532.3356,1510.6903,1519.9852,1579.2039,1222.5511,1001.3434,915.92004,944.9364,762.5757,1162.6743,1529.6245,-4839.412,-4818.3223,-4568.9604,-4261.885,-4133.179,-4017.627,-3786.4736,-3312.7915,-2732.984,-2558.0378,-2294.8682,-1927.3849,-1750.0452,-1675.0378,-2067.761,-1764.177,-1092.3655,-700.7194,100.01604,72.43766,-506.10574,-224.14708,783.5089,566.9783,57.241676,114.950485,99.28921,237.57549,303.37845,956.6551,1065.2399,850.29626,820.88934,669.50037,857.7285,686.3734,563.7788,553.8388,524.18964,628.43146,593.08685,600.16504,725.69196,621.7454,754.31726,1027.1207,497.60815,211.59163,765.7951,1047.682,1094.1726,1434.5464,1535.1384,1608.2174,1516.7396,1867.5978,1774.8047,1670.7715,1700.3823,1865.6008,1695.1906,1934.108,1945.7535,990.43713,1405.6055,1860.8418,1316.4415,1577.6411,1529.8604,1630.1434,1722.8821,1945.5402,1856.486,1089.6951,1755.1322,2243.4841,1901.6306,1776.5378,1540.523,1348.8275,1210.2152,1047.6877,936.05206,956.40186,930.56024,945.24457,993.66223,1174.3792,1146.1787,792.1816,481.2179,367.8406,490.86823,901.5155,1391.7936,1455.5248,1546.2401,1552.0118,1360.1699,1324.4185,1148.8289,1249.2163,1434.549,1848.3796,2068.339,2065.888,1982.3385,1854.9524,1877.307,1433.813,1306.9037,1296.3977,1468.9734,1778.1863,1977.284,1866.1161,1678.233,1521.7277,1417.6061,1279.5397,1039.4943,975.27435,885.0177,840.25354,801.205,798.0054,947.47675,1019.42334,-4587.691,-4600.1665,-4704.4927,-4135.3467,-3919.3254,-3733.6685,-3715.754,-3452.5146,-2821.6733,-2580.1873,-2448.343,-2106.9292,-2030.3368,-1821.8663,-914.37885,-619.28973,-708.09064,-592.3566,-475.33438,-231.97751,-275.75464,-212.05289,-104.50924,97.6678,426.42642,346.73917,541.7198,549.09973,318.81223,415.37296,561.3776,897.55255,1334.0935,951.265,791.6732,657.9027,622.6376,562.32104,793.40704,903.286,733.3424,657.2955,591.19653,687.63367,933.11615,843.0292,111.82862,56.343437,458.30438,1110.9644,1023.544,1238.8464,1620.4503,1867.1674,1900.8738,1931.6326,1801.2516,1576.3069,1624.1194,1767.8413,1669.0939,1913.8461,2098.0254,1723.1271,1522.4092,1398.7849,708.00085,1426.4766,1420.0101,1418.2892,1460.0209,1590.3368,1445.4004,1006.04266,1365.219,2120.7336,1975.4185,1763.6467,1650.5607,1586.5844,1492.7496,1464.6254,1295.3826,1308.5381,1383.5219,1196.0095,1259.6372,1044.2397,774.8538,563.93243,445.5512,410.8017,494.44327,730.1017,1221.7899,1466.3123,1644.1077,1491.5712,1403.1079,1297.4276,1231.6234,1319.5634,1562.0469,1673.0142,1950.731,1994.5712,1726.5231,1431.5569,1237.9121,1103.8813,1095.2118,1016.8355,1106.3674,1280.095,1438.6393,1512.8223,1507.2913,1286.7515,1194.6058,1157.4541,910.03436,901.62317,818.14087,769.0371,705.06415,682.946,721.7905,827.0432,-4426.452,-4355.186,-4287.4146,-4269.3203,-3970.0933,-3638.7947,-3623.9329,-3393.1155,-2754.8733,-2026.4133,-2319.0452,-1976.1936,-1607.0391,-1090.4368,-352.9941,-501.98856,-295.5884,-272.00156,-247.39665,1383.3508,481.74118,318.40598,612.5469,461.63043,439.48053,398.93176,1374.2024,819.8463,576.72076,718.1561,342.31107,646.10864,850.3171,649.04175,654.64966,510.67163,487.97845,643.5352,1182.8113,971.90326,835.7022,716.7421,723.666,1006.078,794.3029,904.5458,472.45624,314.97775,696.1309,932.2171,938.2661,1004.5184,1163.6276,1310.0936,1526.577,1673.9867,1585.996,1298.6245,1271.5117,1379.2263,1486.1606,1647.0686,1859.2501,1894.308,1837.8754,1786.336,1475.7435,1343.322,1347.8883,1357.0669,1358.564,1444.8491,1661.0503,1784.4835,1830.5889,1919.5294,1891.8777,1806.5424,1734.6053,1652.8983,1709.8284,1603.915,1607.6384,1379.6588,1284.1185,1159.2192,1227.3059,1000.3941,704.78424,435.08755,463.4501,510.0731,644.01294,909.3262,755.4803,1174.2498,1600.7596,1635.3484,1404.1495,668.418,913.0392,1082.1846,1262.7482,1357.2383,1450.1414,1439.7067,1051.0892,909.8639,886.5651,924.75354,941.1969,932.1042,1003.57526,1066.783,1253.2921,1389.8192,1405.2617,1212.4407,1170.8448,1221.6772,1090.5823,824.7373,734.4244,683.8348,627.49304,607.3047,582.65454,633.862,-4381.7026,-4157.157,-4018.5276,-3874.4087,-3965.4783,-4050.6748,-4003.4941,-4148.004,-3383.1106,-2589.1638,-1927.3604,-636.38885,-952.5355,-250.41399,-480.82184,-607.9057,-241.27673,-213.63472,-310.79285,246.7633,681.5699,774.7371,1119.4922,1276.4436,1163.3965,863.8838,686.2482,310.11407,557.28613,803.54816,598.9994,593.991,-11.88961,-403.47516,531.11646,493.27884,467.24692,795.5564,1336.2118,1588.6674,866.02057,563.23816,527.4409,550.58966,587.03766,792.365,767.0577,717.99805,713.9958,775.97595,860.92126,858.43506,902.3624,993.92993,861.51904,1302.6691,1147.5879,982.16986,975.3955,933.13824,1076.7095,1208.975,1325.2454,1472.5603,1574.4155,1611.4287,1338.6016,1325.7456,1377.9847,1570.5657,1540.0807,1418.87,1643.5798,1665.4456,1751.5603,1783.9751,1824.4021,1689.8838,1803.7042,1801.0186,1895.399,1861.0244,1322.954,1464.461,1123.2277,1079.2048,1235.0266,1050.0859,794.5322,536.56995,646.8651,549.59845,819.73224,1051.5553,484.30005,902.81744,1325.354,1366.3081,1203.9502,606.9567,686.1767,879.9557,897.9562,1004.20233,1013.58246,925.65015,825.3339,837.6276,868.87305,866.1672,913.3069,906.78705,944.8219,986.8887,1149.9596,1272.2024,1238.3779,1151.8601,1065.7565,923.2496,993.50635,861.63544,650.3517,683.52936,852.05865,561.81006,391.80194,331.13815,-4235.1147,-4050.9949,-3899.7273,-3635.1057,-3538.2593,-3517.188,-3281.2354,-3443.5437,-3703.6619,-2776.6655,-1273.5457,462.1979,-681.104,-888.13794,-906.6576,-371.53708,411.59717,17.46906,188.91074,1189.7433,1476.1506,1148.9287,1456.5475,1176.0773,1196.8555,1311.0625,894.8443,74.123276,1229.8271,1014.0073,693.57025,532.1826,604.4817,438.1004,492.362,451.6346,467.5817,833.54016,776.21497,619.1464,518.86554,499.4523,481.60394,526.19666,595.66815,676.9506,623.8258,667.62146,720.59607,764.0654,834.5634,815.0299,862.55237,879.6855,875.54016,1005.0565,936.97986,915.9683,1008.80597,917.4923,968.94684,1015.4487,979.8152,1134.3833,1197.0435,1159.9752,539.4325,733.923,966.8558,2470.7632,2164.0352,1247.3805,1688.8441,1662.0109,1684.8636,1780.3729,1928.7715,1489.9717,1828.472,1958.6495,2067.323,2227.5247,1453.2966,1371.3278,1156.7227,1148.8804,1490.6672,1283.1211,915.6577,754.99786,860.72754,828.9167,968.48846,1062.2834,1062.8009,1193.8011,1342.1266,1364.1111,1154.8322,846.04456,717.62494,753.1656,815.1878,839.89777,800.3344,802.9383,768.8756,813.7903,816.3595,834.5235,897.36584,887.8101,934.3326,955.15,1125.3434,1360.0704,1226.376,1064.7313,775.3899,629.6848,694.4315,598.8521,503.12225,846.2636,848.0243,333.2227,74.42454,28.457853,-4177.3765,-3886.367,-3691.6323,-3462.201,-3272.1167,-3244.146,-2894.867,-2431.095,-2327.323,-2076.7725,-1320.4608,-784.8152,-556.26056,-744.5194,-477.60403,-103.76248,745.1445,127.58948,93.571495,501.0614,2281.3381,1434.0543,1089.632,803.3415,906.75494,903.7585,974.3133,1244.6158,1238.0271,924.10315,707.44495,496.27496,502.4259,450.86343,431.2018,445.78705,437.07974,471.31305,481.4189,474.83847,469.66006,569.2208,601.5673,611.2858,574.83203,571.67413,609.77454,631.40674,603.51276,759.56573,791.56165,790.14545,866.24115,856.6541,851.62665,941.4684,583.77637,601.8291,972.8173,977.7289,969.60315,576.7338,1092.6134,1072.5642,1018.0769,1094.1554,1275.2063,1014.22687,1335.5701,1984.1407,1972.4135,1764.514,1611.1078,1559.7994,1575.9062,1737.9221,1157.0677,2165.594,2100.9744,2101.776,1913.3173,2217.4375,1761.6896,1345.3317,1302.4482,1570.9441,1835.3795,1213.237,824.8185,737.56537,864.5317,1061.8489,1098.988,1074.5656,1033.3109,1074.2262,1221.4326,1248.6049,923.60144,728.1784,649.33777,672.068,687.9807,737.98956,722.179,764.1255,711.7603,779.7567,797.30963,773.03076,748.7486,888.61176,956.44275,1097.7937,1434.9236,1285.3577,995.89404,810.84283,504.9939,404.7092,338.35593,277.38992,262.8419,430.39044,345.08188,32.889507,-154.9788,-129.58676,-4107.24,-3872.396,-3565.0728,-3267.2659,-2978.966,-2924.6633,-2673.4658,-2069.1418,-1994.5358,-2060.3284,-2076.625,-2075.7224,-1823.3708,-1528.251,-1689.2847,-443.7786,66.54325,74.28935,159.14952,285.89246,688.4404,692.91797,688.16614,761.5719,946.6842,938.6089,915.3531,1216.419,947.81433,1039.2227,957.36066,679.0334,607.8787,650.2334,608.38403,549.66315,543.4992,521.4327,500.62225,466.13684,516.8752,536.45337,760.4478,687.1934,674.24,624.3036,612.6354,659.85187,658.7845,728.89655,786.8657,900.57513,1073.3022,1042.2031,1000.5332,934.0445,979.30334,1003.21423,999.493,980.622,982.18463,1058.0829,1216.6394,1174.4926,1177.1437,1195.9307,1300.5107,1348.2887,1289.0945,1330.9827,1101.2065,1483.9915,1356.765,1244.4543,1449.8945,1351.078,1506.2632,1881.7687,2059.8223,1779.686,1551.9896,2059.0757,1390.2272,1393.2303,966.1124,1412.4302,1777.5543,1071.4241,798.691,701.3917,803.79767,1059.5767,839.6824,1166.9043,1017.7516,936.9816,928.00543,687.31433,770.02527,748.80505,660.0193,639.0113,601.5941,634.01044,699.2215,736.1879,966.85175,994.40656,977.5376,993.6436,905.0055,1006.58514,1027.4058,1007.3927,1156.1953,1931.923,1026.7722,570.6253,276.67804,176.21228,121.73538,107.073784,130.72234,165.96567,184.59804,-29.580103,-73.29275,21.216635,-3743.9316,-4062.6763,-3311.528,-3329.807,-2876.8604,-2743.6965,-2546.656,-2217.0637,-2174.69,-2238.9639,-2152.5908,-2176.4697,-2150.2324,-2065.6963,-927.83527,480.08878,639.91846,234.78525,206.25945,281.59998,472.81784,602.0818,330.74442,748.3379,877.90314,918.2258,981.5923,1333.3395,1007.38763,1255.7676,913.3611,361.31686,570.32544,709.4856,639.9576,634.6964,305.07706,608.91833,495.69836,449.91818,517.96497,542.3879,528.34656,535.6842,603.54285,651.10443,694.96954,913.25195,1112.7495,977.81824,1068.3542,1305.0323,1562.9504,1619.8827,1585.3583,1241.4663,900.97375,1002.5204,959.29407,987.83,1076.2816,1233.1245,1332.3517,1332.7407,1471.7749,1538.9421,1417.035,1247.4331,1181.7527,1150.1595,314.638,1177.1624,1352.6973,1286.1868,1337.2931,871.42584,1131.58,1660.6459,1897.1616,1969.997,1887.9639,1727.149,1336.7733,1250.4207,1232.4291,1767.7692,1853.7808,1283.05,1004.25684,979.6357,1154.0769,1216.4817,1235.1863,1070.5914,862.06683,869.74133,804.4462,830.37006,1049.7288,1317.7776,1178.8801,739.91394,573.0254,561.0579,606.69415,701.246,1160.6417,1545.7157,872.13153,1065.0442,992.74884,909.52747,879.31635,817.50543,779.1624,779.8564,595.56805,237.05847,-32.000134,-71.46883,4.13625,151.73767,219.44804,240.80698,271.99826,326.67096,533.9727,364.97522,-3202.3545,-3209.74,-3479.4392,-3645.4434,-3253.5688,-3004.3953,-2511.5256,-2232.8757,-2160.4883,-2099.0054,-2142.961,-2117.9116,-2056.5723,-1993.3387,-928.7915,232.37823,247.19568,1046.97,589.851,606.5714,589.5462,1000.80444,790.26294,825.9079,883.3741,1054.9095,1016.4449,1132.0739,1327.2814,1123.6738,962.4088,1021.71954,968.01764,804.4167,690.4256,700.5597,654.025,654.1796,561.38837,482.82657,517.24475,502.2859,516.7816,562.9327,595.75586,659.3606,741.41907,1068.4766,1182.0347,1239.8083,1588.1016,1667.275,1777.489,1407.3346,2040.8594,1701.3739,1281.6177,1064.4363,1092.1606,1116.3655,1277.1056,1452.7919,1549.0645,1552.1575,1649.0017,1599.0669,1477.504,1307.9299,1260.405,1212.423,1196.7323,1187.9305,1255.5502,1303.2573,1224.4778,1569.6677,1477.6637,651.26276,1041.027,1798.6492,1445.1602,751.4796,1233.8235,1131.1003,1335.7821,1653.601,1536.5542,1270.9557,1255.4641,1399.6865,1463.7819,1335.7567,1276.1716,1190.2086,1110.3939,1105.7843,1119.86,1245.3997,1647.6536,2077.7053,1774.4152,672.1745,467.78476,428.35812,519.91565,592.8047,708.1984,1001.7661,617.78143,791.49335,862.67957,813.5539,790.4007,853.19495,1438.6859,731.0482,327.65265,-8.222676,-176.11732,-128.9871,19.874586,171.31638,202.20895,597.0644,728.62445,913.87024,1329.7888,1585.2239,-2924.6445,-2818.5122,-2819.9282,-3940.5583,-3395.0718,-3132.7227,-2905.632,-2372.0925,-2173.926,-2050.1462,-2008.4191,-2015.2098,-1976.9252,-1955.6635,-1555.8881,-1536.7817,-1387.7549,107.62728,-38.631397,483.77185,588.86676,761.89813,864.22266,822.96564,900.0921,1000.8774,1029.2656,1051.9213,1095.4963,1090.4536,1039.8114,1019.6068,997.52704,877.3206,939.33624,845.4674,821.3003,924.0719,677.35724,586.2071,501.481,510.8119,530.9475,604.4082,651.1039,748.12616,1196.4335,1765.9717,1396.1848,1202.3896,1368.3353,1559.525,1692.421,1975.1079,2296.5632,1996.111,1764.093,1552.8969,1541.3431,1544.4519,1462.9032,1582.9271,1714.3701,1822.7748,1946.6515,1978.2922,1842.1356,1589.0865,1293.2318,783.24744,1268.2874,1266.8984,1472.1237,1362.6937,1152.3297,1415.8928,1799.1528,1427.7538,1691.8546,1715.2881,1400.3907,1241.8301,1180.3741,1150.803,1488.3624,1434.5099,1461.038,1278.3462,1274.4419,1312.7257,1393.2755,1360.5342,1239.8566,1179.7325,1368.1606,1701.4696,1836.6832,1802.1246,1739.5115,1697.3313,1409.8455,690.223,485.10315,445.43008,548.49396,620.16956,661.87085,999.4087,1119.5431,1092.4712,886.33545,791.11224,996.13715,1379.17,1734.5751,840.18005,265.86002,27.241926,-92.24647,29.640524,235.20529,299.7169,563.7768,847.86523,931.6206,933.619,1356.7881,2010.6772,-2653.8423,-2554.2236,-2546.6033,-2832.4597,-4167.0283,-2679.9927,-2652.0706,-2896.136,-2594.8704,-1976.8843,-1783.8562,-1755.9617,-1742.3969,-1735.7098,-1654.8416,-1495.0725,-1122.1163,-99.67627,240.20036,555.4386,720.30725,697.4251,739.54083,933.93036,1000.06555,1067.981,1099.8422,1096.4974,1110.2058,1124.9603,1135.3817,1104.2714,1032.3961,1007.42773,848.08826,969.23663,966.9414,946.70996,821.85547,792.5105,699.63666,593.34705,565.56116,618.9784,720.36096,910.52466,1467.0978,1787.763,1645.1948,1324.42,1208.3995,1317.8363,1603.0845,2204.637,2296.612,2117.9644,1827.6559,2011.9188,1979.9894,1917.9901,1869.8706,1851.1061,1903.2035,1817.8618,2096.7695,2113.4858,2125.097,1324.2552,1412.3964,1627.6338,1325.5306,1486.545,1497.7352,1437.0507,1286.4635,1234.3274,1533.8856,1675.8656,1727.4235,1607.0242,1415.8689,1352.0171,1307.6608,1369.5867,1546.4845,961.2991,1679.4453,1362.8036,1346.5321,1274.6603,1263.3257,1105.1427,1139.0264,1042.9972,1086.7316,1116.4154,1366.9402,1336.9945,1409.3461,1441.9608,1303.035,1032.4404,622.2017,676.78076,-61.851944,592.2514,743.3422,859.5887,1139.7327,1227.3853,934.8158,910.0892,1116.1422,1369.0145,1155.4481,665.6642,259.08374,250.73622,260.27502,365.96747,376.13065,428.6866,861.71747,1294.4462,1082.752,1076.2715,1369.5746,1948.9667,-2288.6895,-2300.3108,-2250.2449,-2198.5278,-2712.7292,-3633.4023,-2640.156,-2437.4941,-2320.3289,-2020.373,-1720.6821,-1651.1531,-1583.2461,-1511.9718,-1451.9335,-1166.3708,-564.3842,483.01862,325.8409,456.64368,596.64276,780.21075,905.14014,1052.5387,1036.8677,1134.9735,1265.9058,1252.7582,1186.0614,1238.0776,1295.0396,1214.0377,1132.3376,1020.80255,981.12994,1083.1886,1104.4644,1038.217,996.9738,1026.7279,965.6395,811.25055,722.45703,720.64905,787.7833,938.31604,1122.8838,1360.5646,1662.1337,1654.7264,1313.3348,1348.6272,1249.0774,1770.4144,2170.7322,2298.6995,2103.221,2251.374,2263.013,2089.6804,1730.8583,1987.5824,2039.4637,1248.4106,2141.9106,2178.2915,2208.5356,1463.4286,1591.581,2072.986,1869.132,1873.7687,1656.3885,1441.3098,1218.2814,1124.3921,1329.0527,1512.4447,1662.2842,1509.7324,1496.9586,1306.8187,1484.3246,1528.0178,1527.9961,1587.3578,1627.1478,1548.3685,1553.0275,1352.3472,1208.2844,1112.2067,1082.1982,876.5943,814.77826,836.76056,923.7858,1132.2218,1208.5979,1406.0533,1513.7449,1268.7194,915.55646,878.8821,577.51733,1080.5608,1384.7502,1414.7787,1305.8529,1009.36194,850.246,848.00305,838.6668,955.0257,946.7385,665.2911,438.43558,492.3425,458.23547,507.3759,590.1813,787.5285,962.305,1025.9194,955.89856,1164.7814,1175.0782,977.66876,-1939.9385,-1924.6042,-1898.0875,-1815.6581,-1842.5394,-2068.4192,-2129.124,-2391.1238,-2060.146,-2231.9663,-1732.169,-1467.4769,-1372.9645,-1342.15,-1275.4418,-1149.189,-263.93198,939.59796,-2.315594,467.32925,614.0166,763.99634,1043.283,1072.5065,1140.6521,1248.3062,1309.8188,1425.8964,1416.4276,1476.7983,1417.5022,1319.7557,1282.5411,1091.8397,1091.258,1287.7743,1253.9536,1214.3624,1137.4529,1116.2653,1135.2985,1072.0166,906.98254,918.0064,933.33514,998.842,1048.3256,1414.1559,1871.3041,2076.0676,1288.0786,1069.9696,1522.0837,1699.4645,1894.4062,2199.0388,2382.6838,2436.173,2336.7314,2407.885,2198.7048,2428.6528,2325.6995,2202.9043,2128.6663,2220.8145,2312.9011,2386.961,2345.828,2321.182,2307.2058,2046.832,247.25119,919.8361,1149.1849,1069.0153,1081.9652,1423.0023,1605.8475,1116.1088,1401.0443,1355.8109,1377.4735,1359.36,1322.0101,1381.2534,1346.2544,1365.8085,1526.1342,1540.3232,1046.6284,1064.1882,1110.654,715.98517,700.6445,746.71216,811.3972,1036.468,1136.3397,1215.6033,818.0256,1227.0233,1119.2311,1077.0588,1117.1675,1535.3591,1919.3357,1598.5386,1105.402,951.8438,916.0489,902.4948,871.30206,998.7791,1086.4059,1008.53815,776.7012,651.95044,595.04895,242.79816,767.3608,905.35004,923.20966,966.31445,1006.7008,943.06915,590.1342,213.50247,-1485.6118,-1471.8738,-1486.2311,-1383.8394,-1424.3276,-1475.8124,-1812.0913,-1911.7295,-2041.6503,-2033.3188,-1808.128,-1446.3817,-1222.3792,-1168.9427,-1059.5469,-1052.9508,-1008.1798,707.11444,1066.5573,630.8482,666.4541,775.80334,897.67267,1040.4865,1230.5894,1336.7574,915.9506,487.60565,1484.9354,1153.4786,1453.4302,1341.7043,1365.8496,1206.5177,1125.1143,1276.2207,1317.85,1322.3611,1258.8652,1159.634,1209.9309,1232.7153,1063.6123,896.15204,981.2362,1049.0244,1229.9941,1685.6749,1975.3204,2038.799,1067.7794,1293.1327,1450.6465,1564.7059,1399.0275,1997.683,2183.6538,2159.9668,2216.378,2336.1177,2476.743,1320.258,1618.4674,2210.9314,2197.147,2172.9492,2324.339,2189.0437,2361.771,2514.6016,2460.148,1992.0077,931.2681,1153.7438,1132.3607,1013.37915,945.9945,1306.583,1522.354,1232.7203,1299.4015,1280.533,1222.0837,1176.7139,1137.9867,1145.2201,910.2193,1167.0731,1527.2363,724.5299,1134.2329,1360.3442,1311.7125,690.5834,691.6855,705.57007,834.1954,947.0393,1081.3011,1207.9067,953.44525,1128.0327,1171.1462,698.921,967.28375,1447.8512,1512.653,1174.9775,976.52106,960.2463,946.5298,920.1711,948.7525,1190.8167,1305.0039,1170.5704,823.67566,902.3349,812.54443,877.9588,839.5096,845.5628,918.1127,881.5566,847.6041,847.988,733.9157,421.6905,-881.97174,-1079.8458,-1148.8883,-1088.8042,-1058.1368,-1081.9156,-1430.5945,-1650.9493,-1875.7352,-1711.6997,-1553.6841,-1313.2853,-961.94214,-835.8607,-746.57715,-648.45276,-673.25757,-344.17404,1000.8596,750.5408,718.49603,770.1198,839.0119,955.86597,1231.2404,1325.159,1253.2865,1010.54974,1508.4385,1556.0487,1486.6067,1437.8639,1413.2375,1262.5586,1212.1609,1282.2007,1318.4675,1311.1582,1331.9395,1327.7189,1226.7286,1196.0748,1016.4542,856.73157,1055.5496,1134.5737,1194.2789,1272.7588,1450.2252,1541.0706,1379.4542,1369.4944,1370.507,1399.0895,1467.0275,1779.0516,1853.3026,1909.0709,1896.5625,1981.0848,2241.2969,1731.4691,1955.344,2242.2483,2176.7896,2176.4993,2270.7732,2483.843,2622.663,2723.905,2578.549,2244.8171,1722.1674,1294.1407,1094.3876,977.57446,923.01154,978.2373,517.93677,301.44678,1247.8137,1285.2511,1189.9385,1096.1315,990.1316,853.07733,876.1238,927.6635,1295.204,906.09985,809.995,1033.9353,942.57385,605.37,653.8378,772.2377,894.3494,624.4638,575.725,1160.0405,1121.5431,1120.0602,1133.8995,712.971,1041.5813,1267.8857,1283.5387,1142.2399,983.6961,959.68384,945.3114,949.2503,981.44495,1076.5189,1163.167,1052.9342,1002.5387,1010.0744,823.8369,932.65466,850.705,788.79095,850.32404,776.6402,832.8173,857.00714,816.26526,706.2998,-761.64154,-778.1762,-838.0112,-837.2055,-1131.371,-1071.3505,-1268.0056,-1540.999,-1476.7671,-1284.189,-656.76135,560.7957,503.87555,-346.8082,-244.90663,-233.7424,-87.40044,167.66182,507.16177,588.7719,663.73517,768.4204,849.0616,937.6705,1017.57556,1193.5305,1286.1348,1287.9454,1339.4562,1441.3121,1439.0886,1479.4042,1394.4712,1241.689,1286.4874,1334.5244,1293.0471,1267.1675,1265.3934,1395.032,1392.5188,975.93915,1080.5714,1071.1498,1081.207,1085.5972,1138.0886,1196.9559,1280.6877,1232.7584,1281.3949,1323.9764,1294.7689,1301.5806,1394.2311,1566.1,1710.9797,1776.9314,1834.2006,1951.6,2005.4943,2323.3022,2358.182,2329.9307,2249.8792,2195.087,2320.3313,2497.4136,2453.9473,1770.0042,2492.6006,2395.5974,1836.1108,1249.9111,1030.7906,952.237,924.43964,876.7305,941.08044,978.48,1224.7795,1223.67,1190.632,931.45557,906.5993,836.27155,871.0158,1116.1282,1233.6688,1019.81714,980.95197,912.08344,728.7821,544.56305,637.53564,872.5515,992.30054,1169.9883,1233.7057,1200.6029,1109.6599,1092.8232,1070.4578,1133.2412,1098.1973,1195.9187,1197.9443,1111.6436,1000.2834,944.9828,958.02826,1063.7524,1085.1759,1020.78766,1126.0654,1053.4441,1003.0732,1055.5621,1094.2516,906.1025,722.0339,796.7427,797.1315,773.32556,753.8968,897.183,802.12036,681.6975,-947.7828,-780.5191,-656.5209,-696.8364,-932.8216,-984.60406,-1108.3364,-1331.6971,-1478.4458,-1033.3416,-664.40735,-162.4388,-74.045685,-13.115561,-15.139064,9.350159,98.90318,320.1857,460.41843,642.7963,733.1453,841.06525,929.24036,992.6327,1042.4813,1032.5894,1057.8342,1192.2252,1322.8336,1351.7141,1364.1667,1427.1411,1362.179,1275.2756,1316.8553,1342.0977,1271.0372,1278.403,1265.7211,1306.1152,1409.3905,1265.3544,1128.758,1101.4733,1134.724,1128.0934,1167.2156,1257.5875,1281.7817,1263.9166,1368.9297,1516.4126,1664.4615,1599.0917,1596.8696,1608.4851,1736.8884,1803.9027,2021.0782,1948.647,2290.6072,2488.9255,2549.5652,2383.0283,2295.2766,2284.4158,2322.4565,2364.2637,2256.343,2367.0952,2547.5293,2246.115,1766.1993,1213.0029,1062.6914,985.768,957.84607,896.2955,888.7174,963.1388,1224.8433,1308.0272,1178.0901,991.1389,920.3824,1015.05035,1353.5042,1329.0879,1254.3583,917.6052,874.4826,928.81964,790.80237,546.65967,649.3255,996.2151,1048.5731,1185.2582,1226.0651,1153.526,1047.0774,1031.6487,1049.566,1108.8645,1123.1594,1229.4244,1338.9524,1175.1881,1124.1863,1089.1117,1193.2341,1504.0098,917.7739,769.8311,1139.8649,1077.8938,1084.7064,1088.6641,1142.298,866.4992,896.2177,876.9753,930.0589,769.4194,554.55096,930.0997,784.9691,715.8703,-843.89484,-766.48486,-423.66608,-422.43265,-808.9274,-834.3929,-913.69635,-637.25195,-934.0375,-979.32837,-733.88983,-341.22095,54.1353,393.91537,288.57706,234.17462,300.82965,475.8121,596.64044,692.3196,835.4694,909.04944,1004.8828,1081.2528,1087.9039,1090.499,1050.0594,1049.6095,1255.669,1258.9392,1282.7019,1388.0488,1414.6979,1350.6444,1317.8599,1327.0012,1267.3453,1268.0647,1279.2681,1285.0708,1360.7186,1310.3789,1173.519,1148.4911,1152.4596,1166.2797,1271.2097,1501.4874,1781.3853,1747.9899,1614.7231,1841.2382,2044.118,2007.122,1861.6465,1762.4554,1778.1676,1782.5114,2024.7455,2099.921,2198.9114,2562.5298,2697.7388,2491.3074,2533.8074,2386.6343,2330.1494,1306.7188,1689.1766,2022.2587,2335.847,2327.5166,2048.135,1489.4502,1131.3004,1048.4296,919.12695,932.74164,914.4156,1044.1345,1458.1155,1711.5934,1465.229,1214.0405,729.2256,1061.7573,2266.7236,1920.5975,1291.5901,1048.0074,982.6446,1051.297,665.6796,600.95984,655.5517,989.25854,1021.6373,1123.8865,1199.1858,1042.702,968.56683,948.969,1013.7205,1109.5571,1142.9362,1230.831,1405.8945,1380.508,1344.7255,1251.6858,1339.6864,1565.3069,1477.8816,1258.2906,1180.5975,1132.952,1149.8638,1205.4957,1238.1283,1182.9141,1137.2169,1100.4979,1257.104,928.1614,894.98834,889.045,533.9486,770.46,-588.4974,-744.1704,-761.17126,-685.8872,-557.6949,-576.47424,-421.53192,-746.6529,-946.8495,-963.4691,-906.50244,-681.6519,973.40283,1104.2241,472.11646,521.3455,542.86304,670.37537,737.6361,847.83075,949.72516,1031.5615,1101.7606,1098.6553,1153.012,1155.6528,1137.9539,1100.3699,1128.9415,1218.6989,1241.5471,1316.8281,1348.2063,1281.219,1251.5187,1264.7091,1212.4855,1238.8589,1319.1282,1328.0707,1315.2443,1277.2864,1266.0637,1232.3123,1210.9211,1321.9518,1447.9114,1638.1863,1622.4733,1830.562,2074.7183,2191.058,2237.8262,2163.638,2055.045,2112.141,1849.7676,1677.6184,2019.0547,1891.0747,1987.3246,2392.87,2613.4795,2594.5327,2465.8684,2464.395,2415.5608,1961.6627,1671.3176,1656.9204,1885.8639,2081.4497,2028.5747,1599.9658,1409.0256,1268.4788,1159.6499,1034.8203,958.57184,1035.8793,1201.2744,1325.1069,1253.6177,682.31506,724.25885,735.6079,1084.9266,1685.4628,970.1959,1028.0675,846.5739,920.126,853.2612,475.33398,664.301,802.5187,936.03375,1097.7435,1062.5984,1028.8885,881.6613,880.0035,954.7862,1011.3632,1154.5502,1278.5319,1459.0308,1570.8707,1486.2092,1457.903,1449.7803,1687.8634,1565.857,1337.5587,1241.4138,1149.8098,1158.9587,844.65125,1159.5248,1253.7917,1209.8324,1261.8185,1117.2018,1138.2526,1387.1764,915.9535,761.1945,1274.7865,-418.89322,-631.6424,-646.38196,-369.52655,1135.4662,1115.5776,179.07683,-613.3559,-815.4383,-810.7805,-776.38135,-448.76035,857.2936,1509.1952,789.7489,716.13965,759.2988,930.92773,1023.13153,1088.9965,1100.4066,1177.406,1207.4385,1234.6349,1234.7886,1244.6407,1243.2806,1248.9895,1236.1327,1206.1694,1194.0332,1278.7073,1280.0519,1229.3351,1236.3135,1233.692,1241.4941,1276.5607,1368.488,1321.4491,1334.2623,1358.0422,1313.5463,1282.8451,1364.4355,1484.2466,1551.3711,1759.1117,1819.2335,1798.6251,2187.6763,2428.8423,2324.9465,2313.6438,2312.9797,2427.6882,1866.2069,1462.6333,2136.5112,1900.0809,2055.8115,1537.5331,2412.754,2652.5342,2464.0356,2597.044,2369.7732,2224.7996,1777.2515,1650.2083,1741.1561,1878.0382,2075.4644,1935.5896,1856.1117,1592.0796,1530.0625,1225.1404,1026.1993,946.77167,987.2188,1180.0852,943.571,588.94025,567.2815,516.0208,898.7256,1504.8875,1002.9267,964.9462,838.6267,900.26544,852.3212,1209.3553,847.2921,897.32935,881.4646,873.5593,876.04596,880.0548,756.68915,828.65674,898.3861,957.35065,1147.3291,1281.037,1491.3416,1726.2372,1672.458,1756.3727,1826.5762,1920.1959,1884.7102,1544.5929,1373.7013,1341.2789,1373.0627,1338.4769,1301.2979,1404.4364,1386.7482,1230.6229,998.96246,870.7222,1082.9917,919.2535,655.2671,812.12396,-465.62616,-524.50757,-459.92462,223.66687,1927.6698,1719.4241,732.52344,-96.028,-580.9242,-628.4029,-471.59814,-12.005203,625.4725,1768.6327,1805.0854,898.6598,923.186,1031.8914,1218.5789,1245.2645,1235.5951,1347.9641,1406.9197,1353.0509,1352.857,1358.4779,1334.6187,1356.0656,1185.7073,1310.3536,1254.0073,1261.9099,1251.0731,1260.9807,1259.4006,1210.1882,1254.5231,1328.2854,1370.286,1344.6018,1405.437,1392.2124,1408.2747,1394.3467,1490.3937,1591.7833,1700.3615,1823.1362,2098.4382,2030.2395,2442.0854,2720.7551,2618.942,2622.818,2624.5151,2610.0986,2415.439,2273.796,2222.8955,1998.1874,2452.289,2152.247,2696.1978,2563.3955,2554.2024,2685.7607,2826.9373,2558.0474,2051.1643,1757.854,1756.6711,1947.3463,2241.872,1994.5438,2241.8977,1872.8062,2060.537,1582.7815,1224.1688,1074.147,1063.2502,1012.30493,1010.8365,710.31415,606.28625,660.04565,1325.816,1648.7986,1012.57947,866.14124,866.9716,913.2683,1194.5084,1696.6118,1410.9647,1000.31,762.23944,758.28503,690.77057,678.63257,722.0243,771.0253,885.3524,1003.867,1113.168,1281.1594,1535.9949,1729.6036,1889.6643,2101.457,2158.481,1898.5212,1768.8203,1530.5396,1544.3472,1604.4429,762.496,1567.4553,1478.0706,1498.4496,1424.9352,1040.3058,640.2499,421.3316,414.49738,444.24158,688.02734,691.48,-378.20398,-365.70117,234.77914,1075.4965,1371.2919,1250.4579,754.4795,698.53436,143.28432,311.35803,1181.6815,685.88385,791.49115,1017.8565,1173.6685,1076.5037,1132.5729,1211.7595,1282.6685,1355.0045,1444.1029,1497.5475,1552.6143,1491.6754,1493.0273,1495.6716,1501.8517,1391.3564,1361.1879,1424.5494,1509.0747,1372.5914,1325.9558,1327.5667,1297.9254,1307.0536,1311.4513,1369.1113,1392.0846,1418.8816,1425.1511,1443.3057,1540.8724,1541.4833,1529.2902,1419.2063,1022.26483,1879.3701,2152.4282,2318.1885,2542.3545,2702.5103,2985.469,2257.405,2032.5117,2188.1333,2377.5776,2245.6965,2172.054,1808.7723,2189.293,2362.3804,2282.1177,2293.319,2471.5747,2698.0486,2714.5627,2848.5496,2414.5168,2091.2073,1963.1575,2203.9824,2396.6165,2405.6409,2276.4197,2447.5166,1877.4248,1816.8295,1654.4314,1320.704,1130.6819,1016.85034,972.69183,956.4021,1134.3358,1458.428,1852.6028,1598.7488,936.5766,870.17584,900.18274,982.7905,1505.4946,1730.6273,1370.5164,986.93604,792.74945,795.7726,743.085,680.3438,720.0198,822.88135,850.0488,930.8271,1192.556,1416.8901,1582.2924,1696.564,1898.2451,2007.8351,1891.0736,1608.2545,1513.9204,1426.1656,1511.184,1615.3832,1318.7303,1736.541,1592.9451,1463.4258,1138.7971,927.06964,527.6543,202.55614,532.25854,762.31006,628.1903,666.86005,-235.56653,266.351,1212.9844,1461.2941,1315.3804,1051.3099,691.717,570.8544,529.9363,1068.2357,2015.4166,2022.4622,1637.529,1171.6356,1207.8273,1179.9451,1300.4991,1370.2338,1467.2385,1463.0745,1585.6058,1644.3223,1589.1226,1583.9244,1602.279,1610.3721,1572.2064,1517.1655,1500.134,1581.4122,1666.0264,1562.7865,1455.4851,1232.407,1388.555,1328.9637,1350.92,1374.3024,1399.827,1463.9814,1509.0344,1523.329,1605.7653,1631.06,1635.5142,1643.7413,1729.3398,1931.9833,2093.1133,2336.616,2273.6465,2490.0034,2864.709,2424.2305,1999.8467,2199.0864,2450.6458,2296.3384,2223.4607,1908.4585,2077.4678,2300.4106,2224.585,2126.3416,2285.217,2703.2346,2594.9675,2887.1667,2514.132,2387.0044,2270.196,2282.1375,2243.713,2130.339,1044.6384,1850.5426,1930.9927,1955.9591,1722.9314,1578.2021,1318.5917,1004.1975,1038.3918,1140.7122,1542.8123,1650.9918,1701.2769,1433.7743,1027.1896,936.9837,906.08795,938.231,1369.1185,1770.4021,1254.5511,1030.8568,995.06366,869.7376,858.1342,871.5936,736.96075,770.8099,902.8967,1281.8997,1519.2179,1724.6486,1820.7213,1917.2316,1591.7107,884.4581,1611.8513,1361.0753,1211.733,1240.545,1264.703,1267.5898,1621.5679,1675.5305,1359.4252,1188.7141,986.351,753.06506,429.77863,41.228455,659.3475,862.5551,785.0018,734.6241,351.70837,962.8068,1405.4008,1714.3907,1527.7198,1183.3839,649.74365,652.2072,744.6968,859.17645,1664.1077,2634.8918,1366.5441,1178.61,1271.6997,1412.532,1734.4613,1932.0653,1703.7845,1757.076,1820.5261,1905.8843,1800.3096,1723.5662,1704.4233,1676.1608,1652.0707,1583.6836,1579.9495,1555.9285,1451.6886,1564.8947,1557.2002,1363.93,1396.3027,1374.8696,1406.4073,1395.0583,1435.756,1543.879,1637.3806,1651.1342,1641.947,1638.9904,1679.7264,1533.6747,1477.3517,1688.667,1748.9537,1903.036,1851.0913,1826.1217,2096.9668,2472.0493,2457.5986,2609.2268,2529.6792,2499.2324,2262.8408,2171.1035,2050.2405,1003.22754,1369.5823,2060.0908,2180.289,2367.4126,2718.224,2703.2239,2542.269,2502.8274,2310.681,2456.5977,2352.076,2350.392,1300.7963,1976.4915,2261.1497,1891.755,1451.1531,1467.9016,1346.6923,1147.7374,1141.6656,1257.071,1459.948,1677.635,1657.1428,1461.2671,1217.8276,1081.7085,924.1604,979.96014,1203.3696,1247.1897,1138.5487,1194.0255,1054.7113,492.00552,285.00214,1098.3501,1144.0914,1026.2338,1214.3159,1537.3013,1437.7874,1921.2019,2038.2289,2239.1492,706.3622,295.59415,1548.3573,1306.0731,1081.6044,1105.6658,1214.8004,1657.4491,1997.3824,2056.9053,1306.3826,960.5565,639.341,482.37823,219.29198,179.6719,480.2176,837.9698,753.289,758.42017,1031.6951,1158.9545,1452.4744,1951.903,2081.4658,1860.9546,1516.6062,1253.0864,1113.5165,1417.4178,1264.0338,1515.2034,1314.6221,1208.417,1377.5051,1618.775,1826.2256,1721.3673,1789.1726,1950.7739,2097.1824,2188.033,2089.8875,1931.9869,1822.4276,1743.4529,1676.8008,1533.4586,1640.3264,1550.2007,1497.5001,1584.7023,1471.2493,1494.9666,1407.6619,1358.346,1379.8442,1444.1708,1479.2686,1594.9719,1679.305,1685.7482,1641.9843,1689.1217,1718.6271,1797.5656,1543.9333,962.9433,1629.8221,1632.2457,1658.8777,1681.8093,1432.329,1664.1776,2062.1528,2156.7812,2407.2334,2373.974,2390.7595,2291.9402,2213.3643,1488.524,1598.1238,1936.2113,1965.8951,1776.4503,2633.6086,2646.5767,2469.3699,2436.0376,2411.4585,2507.4692,1858.1896,2237.1116,2341.0652,2323.6135,2041.5769,1779.3851,1503.8104,1379.2278,1362.6066,1346.1469,1299.6099,1459.412,1599.8021,1667.8398,1569.4202,1358.521,1217.7677,1198.9248,1055.2448,1117.8132,994.2281,134.67929,252.21487,1052.6459,1042.968,952.0291,833.77563,1102.8961,1499.5366,513.84326,944.8921,1675.1818,1548.9954,1327.0688,1841.3186,2601.5945,1928.9797,1636.66,1549.5482,1290.5953,1059.6636,1082.8838,1121.8999,1434.1276,1608.198,1672.3025,1297.1456,981.034,640.07544,405.45224,149.76137,145.60548,358.00232,627.8087,744.3223,834.5559,1332.5723,1617.9152,1845.5352,2154.1104,2290.4133,2438.3057,2358.6729,2202.9778,2143.9866,2290.5674,1509.0424,1376.9402,1417.3,1372.8729,1527.6115,1564.6697,1677.1805,1632.2145,1746.9238,1886.0127,1980.4644,2156.9707,2298.9429,2228.5151,2024.1183,1878.159,1757.599,1437.5549,1573.2635,1518.2223,1547.7747,1584.0931,1537.034,1449.1061,1381.5222,1323.9392,1376.1769,1468.6134,1526.6793,1658.7191,1702.7157,1695.0576,1708.8885,1732.0725,1752.1641,1984.5339,1139.3705,1757.7249,1674.2965,1602.8514,1643.4591,1575.8795,1778.9602,1817.7461,1704.6726,1709.1259,1977.1313,2319.5535,2318.1775,2317.9258,2209.2183,1774.6836,1818.2068,1781.5103,2159.9324,2080.741,2559.393,2653.077,2689.5898,2534.4294,2324.8123,2296.99,2442.9285,2568.878,2416.7861,2027.4539,1798.1613,1854.322,1575.9529,1415.6547,1387.5471,1294.8601,1355.4714,1376.2424,1310.6152,1110.9032,1087.663,1170.1288,1368.6571,1270.5652,1216.5215,1238.2122,1205.2335,544.76294,557.2115,1103.8658,1049.6881,456.71796,392.54947,852.8961,1226.0857,1053.1223,1245.9692,145.88013,352.79526,1123.6041,1172.4183,1502.187,1681.4332,1311.2246,1224.6967,1198.1554,1056.3514,1108.5426,1143.0131,1137.6653,1188.6685,1341.5363,1324.5964,1188.93,793.22034,470.2945,333.01898,-6.150272,336.96347,298.76816,822.76404,835.8953,1538.2692,1959.4283,2134.1501,2397.7732,2502.4465,2684.1707,2660.8762,2618.6606,2490.6306,2555.4104,2315.408,1666.7052,1399.5642,1396.4633,1444.3062,1412.0099,1541.8586,1677.8367,1815.842,1933.9681,2055.7517,2198.3555,2370.5986,2484.9907,2127.0747,1771.0323,1722.0634,1570.6649,1482.6692,1439.4276,1487.0513,1525.4972,1478.8168,1444.6719,1391.135,1359.6567,1405.75,1493.43,1569.7736,1664.1498,1662.1362,1657.1432,1680.329,1718.3123,1746.368,2102.1685,2007.3627,2011.1486,1739.7673,1764.7449,1685.9459,1827.175,2196.974,1866.2866,1497.3063,1427.8555,1515.2666,1886.1118,2387.002,2516.0981,2291.0227,1700.7189,1752.5491,1988.4498,2302.117,2286.636,2439.376,2607.8335,1951.4862,2427.4673,2264.7073,1898.5701,2186.6604,2457.6653,2492.6777,2259.0186,2017.7034,2005.1138,1924.4747,1520.8439,1517.7369,1384.1147,1208.9789,1072.2029,1086.9634,1108.3115,946.38165,1213.8253,1239.2428,1252.2922,1229.6384,1172.7135,1328.913,1256.3163,1059.3978,1087.6222,1070.0712,584.6817,454.7583,667.664,841.9872,1084.0137,1224.8616,658.985,708.39276,941.4137,912.7968,923.6419,1038.2455,1184.7557,1560.4797,1239.0164,1120.7207,1099.2045,1309.7013,1212.455,1208.5493,1222.6451,1436.358,1210.4326,1044.1888,771.5486,605.235,531.83417,103.54092,748.80457,927.2656,964.07715,1759.4474,2092.762,1992.3046,2393.9797,2667.8413,2696.9683,2841.5774,2713.893,2591.19,2390.9558,1288.4884,1339.4629,1654.5996,1504.2426,1518.7286,1530.7076,1609.9039,1788.2253,1884.1716,1929.0123,2007.7749,2207.1995,2418.5254,2725.6475,2559.0417,2150.782,1739.4982,1587.2522,1461.3483,1373.0135,1427.2684,1458.4426,1536.4867,1391.0463,1372.615,1362.0007,1445.5253,1505.9321,1622.2745,1640.0609,1655.757,1650.0338,1661.9834,1708.5646,1796.5221,2090.8137,2158.5374,2098.768,2077.3496,2007.437,1605.7965,1469.4816,2683.8464,1991.1012,1437.3052,1360.9012,1406.6993,1647.1067,2389.671,2253.7407,2177.59,1977.5354,1769.1237,1665.3882,2212.6028,2187.4165,2324.9644,2780.9634,2553.2017,2299.1577,1855.903,1635.3049,2122.9927,2235.0066,2312.1152,1622.4735,2093.7725,2066.1658,1989.2926,1951.5442,1915.6062,1794.239,1501.7991,1208.7198,1120.4243,1103.3234,1083.7489,1120.9266,1318.9524,1239.0853,740.23126,739.10095,942.78235,1353.913,1228.9138,1205.8363,1118.1246,832.7469,525.22955,458.87076,710.5791,600.0818,626.0082,646.7815,791.65027,985.2285,744.64386,593.82983,791.3575,801.1659,968.7093,910.2397,929.5343,128.16888,1220.4032,1322.3666,942.46436,1080.0386,1288.9812,1248.4408,998.5191,850.6092,863.3476,1069.6409,477.6992,999.2118,955.3195,1075.5522,1799.7668,1926.91,2258.0981,2584.5647,2825.4646,2711.045,2913.961,2797.284,2565.3032,2412.534,1980.1927,1892.1843,2000.5186,1952.3114,1729.2886,1677.3368,1789.05,1735.1876,1754.638,1849.0502,1940.6829,2092.624,2242.7913,2592.6436,2653.974,2227.3672,1764.4781,1576.427,1520.7307,1458.2169,1467.3307,1493.9266,1442.3268,1436.205,1471.8591,1399.885,1448.0974,1530.7808,1503.117,1592.5598,1561.0645,1637.7866,1685.1156,1722.2456,1939.0619,2161.1729,2204.331,2211.9446,2328.2185,2570.0664,2423.5933,2328.8044,2642.6719,1889.056,1450.2651,1371.5886,1394.741,1739.1895,2242.2527,1797.4011,1956.4211,2016.5792,1724.2122,1667.1278,2111.9792,2176.7422,2378.814,2497.157,2272.8948,1884.7175,1836.5289,1895.484,1935.4071,2012.0957,1993.8636,1810.2039,1921.2611,1800.8945,1859.6449,2201.9558,2190.6174,1960.2172,1649.8357,1336.4009,1236.8832,1178.2811,1152.9513,1164.2788,1372.0684,1205.18,773.94147,825.20215,905.2093,1539.1263,1413.9872,1407.2102,1366.0112,985.84863,540.0085,328.38718,356.93704,232.29745,165.4505,262.64914,709.7413,739.40985,761.5995,634.08624,458.99197,300.94638,477.08508,636.4184,440.5663,654.1074,754.54175,1084.9181,1050.901,1104.5732,1420.861,1202.5558,969.08563,985.92566,925.17993,1067.113,463.42026,1026.4597,1272.6512,1434.1863,1801.116,1967.0907,2198.674,2361.8015,2645.8713,2634.2258,2885.2485,2883.582,2719.211,2609.3586,2223.0122,1995.7264,1783.1194,1750.8241,1309.1454,1542.9103,1764.1973,1652.4058,1744.4647,1816.9382,1803.2218,1713.9901,1852.0142,2060.1338,1997.4028,1819.4553,1679.3973,1577.979,1578.9739,1552.9431,1569.9943,1500.3754,1494.9808,1526.7996,1529.8859,1489.8984,1488.6956,1516.9941,1546.0469,1577.7548,1627.6151,1660.0591,1696.6779,1776.449,2023.808,2297.949,2401.8303,2362.2815,2536.0813,2738.4524,2811.2942,2792.9893,2417.7017,1863.7612,1429.2733,1411.9923,1485.961,1584.6702,1831.21,1896.4501,1864.8735,1913.522,1667.503,1643.3119,2014.7396,2144.4822,2416.8728,2280.365,2104.3628,1770.1614,1771.8273,1817.8656,1984.7948,1877.644,1713.2548,1666.6991,1737.5992,1954.5627,1917.3071,2006.9594,2053.399,2127.2117,1950.0579,1625.1847,1523.6661,1417.9019,1243.7045,1287.1398,1357.2689,1338.8779,1054.1323,918.9703,1398.5999,1701.8256,1690.7252,1555.3323,1395.9059,305.3427,509.66608,75.67175,-32.043224,-25.89512,-28.785252,-3.987378,51.57965,168.38686,226.17291,252.54225,365.50894,-77.87082,-121.87952,212.5495,217.04948,-37.34883,-106.3006,357.82098,802.3089,674.6832,1233.4689,1367.578,687.55695,1038.4976,1018.8098,1015.06616,355.90662,1028.4365,1452.5522,1468.6849,1779.1187,1808.8573,2068.9875,2168.228,2591.5215,2673.314,2684.8237,2747.1921,2758.3884,2687.0845,2332.428,1890.0042,1697.7362,1706.8973,1735.318,1735.4478,1686.6562,1717.1312,1655.9548,1677.553,1593.5101,1491.3231,1338.09,1524.7224,1566.2375,1544.9591,1518.0507,1621.9662,1559.7014,1558.6311,1531.0221,1484.1759,1447.4053,1493.779,1457.1104,1505.4994,1473.5818,1557.8344,1548.7137,1620.1252,1676.7234,1692.2751,1761.6299,1787.2202,1940.3539,2401.2942,2614.4785,1419.7567,1734.575,2762.1724,2720.2007,2559.6624,2460.8645,1830.9622,1472.812,1559.4987,1692.2152,1251.6466,1444.4231,1756.8579,1750.9274,1961.1101,1885.6742,1829.4586,1965.7926,2276.2375,2567.7148,2336.4902,2083.7715,1947.9601,1823.4976,1770.8059,1975.6842,1670.8828,1625.4808,1715.6621,1985.4202,2566.631,2013.8268,1846.0647,1869.9893,2047.5211,1847.5017,1866.2042,1424.2466,1425.2136,1436.4423,1457.0671,1444.5763,1517.5618,1587.7632,1825.4725,1837.8368,1835.2511,1521.5256,491.15802,919.9998,413.73013,377.11783,189.54462,96.51586,-74.818,-172.91212,7.149831,-8.48175,-191.93248,-208.34866,-404.53668,-224.18997,-491.55893,-646.50305,-217.62349,-6.197842,-157.9317,-163.08206,102.345795,780.92017,521.1765,1141.7092,804.07184,938.2344,773.61127,945.47925,897.206,237.22043,1233.1038,1456.6624,727.5844,1827.7448,1955.3164,2007.4731,2153.4702,2397.571,2504.977,2413.144,2659.222,2799.4265,2664.5928,2191.1685,1646.6637,1661.1503,1637.1497,1736.4937,1721.8676,1641.0562,1672.2122,1574.9031,1543.2747,1470.6582,1385.3689,1323.985,1359.6337,1364.3458,1394.1205,1467.1531,1547.6587,1512.5305,1518.633,1499.0267,1478.729,1497.4445,1453.4272,1444.7848,1472.264,1497.7046,1541.8092,1593.5366,1661.4196,1654.5262,1711.5696,1783.9967,1674.6512,1538.4257,2168.9934,2209.5317,2179.4905,2248.1348,2201.5737,2343.261,2359.0012,2489.3308,2027.4624,1688.1067,1810.8998,1983.5211,1352.7479,1555.0804,1800.1025,1818.4503,1901.5833,1792.2659,1640.0388,1562.3069,2203.1106,2347.1348,2169.689,2009.8955,1862.1409,1753.5588,1733.2059,1758.0881,1593.4127,1808.6732,1878.0836,1795.4989,2037.6139,1897.6797,1863.0583,1884.7064,2121.3733,1809.3192,1689.5642,1782.6179,1790.948,1807.4445,1423.8544,1544.9219,1623.3853,1614.1942,1654.4176,1691.613,1730.0947,1499.8589,916.55096,1008.46356,900.91547,484.83273,192.21399,131.01543,31.203037,-258.7214,-57.33547,-231.35046,-385.17456,-366.4139,-489.1768,-598.1282,-681.4763,-785.1877,-484.06326,-213.78209,-194.68907,-239.34189,-424.66293,121.60784,386.74734,213.9053,413.7283,432.9206,510.08456,731.6372,792.0317,226.36166,1155.5099,1526.0619,1711.1497,1851.0133,1948.9357,1999.3203,2192.0166,2404.432,2458.496,2463.1033,2574.5098,2682.6763,2533.2117,2183.649,1901.0797,1850.1077,1754.4636,1784.7732,1739.6763,1620.0508,1613.7743,1563.3226,1469.9812,1406.6652,1359.3795,1359.4487,1351.3646,1323.7888,1378.2952,1430.6936,1432.6968,1505.6698,1527.8103,1489.9784,1530.6372,1534.3995,1522.083,1440.7661,1467.7312,1575.5631,1593.485,1654.727,1650.3162,1642.6117,1901.3448,1815.8792,1966.4752,1852.6788,1875.774,2032.9362,2065.4575,2057.941,2232.1052,2166.1948,2245.775,2436.3499,2672.9167,2401.7334,2046.4565,2121.696,1322.7699,1986.3871,2198.34,1880.1555,1839.3945,1664.1677,1714.7435,1841.2894,2016.3138,2112.0442,2025.6215,1867.446,1899.4556,1860.882,1809.4419,1789.6323,1682.673,1996.9324,1857.7129,1462.5513,1688.9132,1867.7637,2019.0192,2158.298,2219.74,1870.9745,2063.4858,2162.1462,2116.4177,1999.566,1704.3918,1751.9152,1731.1244,1717.8146,1678.1215,1628.9968,1530.9329,1637.2576,1467.3964,1199.4545,799.4344,602.95905,202.82,-58.153355,-310.7961,-639.37616,-904.1678,-827.35126,-624.83673,-552.10126,-522.7892,-631.5848,-759.5676,-873.30756,-725.00183,-201.00406,-270.06628,-443.7117,-438.24976,-275.59113,-130.13239,121.32687,137.15941,40.38225,382.9454,584.83746,795.7505,117.43556,1282.1672,1606.3876,1913.4755,1698.8297,1854.4868,2133.1194,2300.0083,2509.788,2528.608,2498.6458,2627.2852,2590.8708,2472.509,2231.837,1975.9966,1935.6345,1881.0188,1740.9811,1567.5768,1565.2186,1513.515,1530.4922,1441.2845,1362.1427,1360.6875,1390.0198,1315.5175,1281.8573,1371.0854,1476.4852,1476.7454,1498.8229,1544.599,1539.0339,1530.742,1555.3229,1555.8694,1473.8904,1589.1124,1619.2584,1656.3553,1682.4718,1645.6671,1529.9402,1922.1488,1867.6829,1853.0212,1806.4829,1793.6329,1819.8958,1897.3175,2011.7177,2161.9702,2210.1511,2145.9602,2304.807,2253.5889,2185.8567,2145.0146,2247.555,2252.8887,2290.104,2163.3108,2040.4084,1779.8687,1701.8165,1727.1808,1757.9933,1869.8102,1991.0159,1710.7422,1487.2493,1603.7648,1311.4938,1276.6989,1760.4783,1889.5382,1903.5565,1728.0046,1689.5027,1802.1555,1976.2484,1989.5226,2040.091,2056.1404,2143.525,1417.2974,1274.0642,2106.5566,2216.8464,2108.2876,1912.0205,1796.0339,1770.7109,1722.1284,1686.3237,1202.5186,1432.6466,1212.7765,734.30457,751.1694,353.07278,224.76526,60.75585,-252.85126,-340.42886,-376.06717,-765.0859,-1141.9061,-639.00323,-518.5849,-551.4814,-874.69385,-918.83105,-815.983,-440.86487,-561.9089,-691.2456,-455.02765,-747.1053,-521.0601,-308.39847,-240.83191,-14.282485,253.11261,829.82715,398.8555,-246.18016,50.11863,840.5387,1148.1715,1883.5675,2049.3933,2246.2776,2225.392,2161.334,2649.6719,2654.9492,2671.7834,2539.9082,2253.4019,2237.5037,2071.3408,2034.8235,1773.203,1665.5487,1578.0692,1519.1577,1501.9138,1546.4043,1424.9668,1356.2725,1381.2051,1382.8944,1264.4426,1246.0527,1365.4657,1518.2904,1507.5476,1494.9022,1494.2335,1530.0328,1575.5709,1571.1628,1568.249,1544.7021,1659.1572,1632.1846,1660.1439,1671.1599,1686.7349,1797.4662,1954.8785,1890.7595,1821.5382,1784.2417,1830.2062,1818.507,1870.9397,1882.0231,2050.7227,2276.1414,2324.3054,2256.1755,2214.1843,2043.8408,1634.6807,1728.1824,1852.3135,1907.9436,2362.5076,2112.8103,1982.2473,2090.754,1708.8264,1654.1075,1701.8081,1764.5729,1761.9512,1734.3176,1707.1659,1451.7034,1522.1299,1616.4907,1700.1198,1746.6497,1764.4498,1683.5554,1984.6335,2063.038,2045.228,1604.4044,1948.9482,2036.0575,1513.8387,1269.5797,2001.3334,2035.1003,2055.6733,1889.6558,1791.9481,1788.0685,1781.0842,1827.5172,1085.0604,1280.5558,1151.305,689.5435,766.5395,-520.4677,12.114799,-8.288012,-249.13118,-370.26886,-480.66516,-492.82596,-909.3257,-854.3419,-425.62912,-1147.461,-1187.3468,-870.33765,-885.049,-1106.1687,-1291.0281,-789.30664,-343.0389,-647.161,-610.3564,-444.3007,-389.4079,-127.28045,29.97537,284.6247,-262.25357,-160.168,652.428,755.2166,629.6341,2130.5466,2334.6953,2383.627,2492.563,2213.3853,2737.3054,2696.8125,2705.3845,2424.8945,2483.6829,2176.2644,2095.724,1993.3905,1727.8202,1660.6013,1577.9781,1435.3092,1408.8704,1418.9368,1402.5992,1335.3479,1386.8516,1437.0118,1286.0562,1301.8687,1424.7802,1495.9211,1397.916,1390.1157,1412.7938,1489.9414,1497.4808,1492.446,1539.4554,1556.4814,1647.4475,1694.2755,1703.2698,1707.7479,1787.2551,1968.6898,2067.268,1968.2642,1972.3646,1780.6267,1855.7449,1889.6943,1826.3186,1804.8943,2060.6858,2235.742,2347.8137,2459.5513,2513.8164,1955.7444,991.0575,1465.2135,1361.1602,1356.438,1419.2177,2246.1885,2379.9197,1928.8608,1735.5605,1595.8905,1629.5038,1640.436,1606.9098,1584.9471,1651.7977,1420.5443,1418.7388,1508.9272,1664.993,1622.6439,1706.3735,1549.2385,1591.1707,2011.9336,1900.1904,1745.7656,1945.1222,2032.9308,2136.0073,2148.506,2030.9362,1782.1681,1455.8496,1666.2529,1651.8054,1651.9568,1672.9222,1665.643,1355.0198,1046.4323,1260.6344,879.0335,476.59665,541.9314,167.66542,-203.51506,-409.6089,-457.22903,-572.5216,-523.26105,-534.6207,-1012.1574,-1201.224,-1055.3406,-1149.4579,-906.4993,-881.78033,-803.64215,-847.6616,-384.89084,-626.2808,-811.56604,-565.2745,-367.32434,-360.78796,-315.21182,-312.1651,-540.15356,148.78401,498.2597,678.11566,687.25745,768.86334,2123.856,2459.3179,2334.9795,2556.1157,2789.9565,2800.8943,2756.6135,2716.0583,2476.2112,2484.7014,2102.9133,1779.8407,1887.5245,1796.5094,1685.3002,1597.7623,1566.0494,1463.1129,1359.4656,1393.7288,1421.9235,1459.304,1479.0463,1340.0646,1407.7047,1484.6073,1446.6846,1330.976,1366.3184,1412.1465,1474.4738,1462.4484,1505.3447,1580.0602,1633.1932,1189.6759,1660.5918,1699.3848,1792.2714,1927.8422,1943.0371,1397.5109,1277.5171,2021.831,1767.1896,1868.6727,1866.6285,1851.3732,1900.5074,1995.2134,2360.4397,2510.6091,2633.0244,2514.9497,1621.1093,1595.7399,1575.5779,1390.591,1272.306,1323.1749,1894.7794,2275.9736,1620.3636,1636.1819,1615.7744,1665.5938,1712.0282,1553.0127,1739.1007,1794.7499,1542.8328,1486.6154,1526.5775,1548.6965,1557.2263,1833.4629,1472.423,1372.3802,2015.3478,1976.7252,1948.0916,1913.7345,1792.5051,1630.4697,1553.384,1510.079,1396.8068,1409.8793,1479.4641,1500.2411,1513.9454,1527.0001,1556.2906,1481.965,1002.4435,1271.5433,917.08264,197.34085,-11.805168,5.477598,-263.17508,-567.0392,-1052.2477,-1986.2966,-1189.1655,-651.1115,-1106.7634,-903.8496,-893.6733,-956.5034,-878.0788,-1045.4183,-135.8434,-272.44617,-960.8437,-1259.6008,-1420.0295,-1147.7827,-374.55988,-493.9104,-1131.7975,-1500.1805,-1576.9292,-187.88757,744.70654,434.84036,386.15112,666.7061,2474.9456,2421.707,2531.4148,2571.7354,2762.5935,2728.0574,2772.8176,2632.3044,2488.1475,2412.6003,2289.8242,1158.839,766.4019,1979.5261,1692.1282,1704.8909,1855.5817,1603.538,1476.8179,1467.4583,1500.2582,1541.3099,1382.8805,1395.3275,1474.2926,1525.6523,1408.147,1365.5773,1412.1881,1457.8932,1440.1489,1503.153,1624.1177,1690.1787,1665.1956,1613.8354,1663.6196,1759.472,1914.2603,1994.7031,2160.1255,2310.8242,2089.4133,1899.1172,1903.0969,1897.5426,1646.0171,1342.2107,2014.3859,2081.272,2272.0632,2336.6306,2373.0918,1955.5306,1269.1501,1488.6019,1332.1648,1294.8966,1289.704,1595.9166,1696.7017,2187.645,1956.1865,1957.0433,1849.8463,1936.8668,2001.3164,1513.4811,1738.1702,1756.3511,1736.5719,1594.9418,1630.2186,1766.7449,1768.4252,1743.1705,1985.7543,2034.9668,2057.5127,2016.1257,1988.8469,1863.0225,1846.773,1669.9962,1403.4983,1242.8165,1049.2247,1143.5062,1382.596,1401.0068,1387.307,1298.123,1236.1516,1490.5714,1110.0326,996.82623,1031.3749,364.83356,-377.2914,-121.66943,-367.54565,-631.44086,-1693.6681,-2301.8374,-1816.3591,-1005.6412,-1392.2737,-1406.653,-1356.7657,-1214.2133,-1243.9691,-624.70374,-702.36096,-1589.4738,-1725.7493,-1328.9904,-1549.9227,-1677.9863,-1143.2832,-744.63794,-1767.3177,-1893.4531,-1867.437,-1228.7899,508.02332,343.39148,-31.478624,391.18488,2379.9343,2414.4993,2497.998,2402.291,2826.4429,2770.3423,2676.4524,2589.958,2196.0474,2127.035,2096.9014,1627.6832,1449.8674,1888.4502,1752.3755,1535.4055,1542.7552,1415.4918,1502.1113,1536.9076,1481.552,1402.5734,1379.015,1342.8131,1467.3488,1445.5994,1426.4786,1400.7394,1355.5814,1435.4408,1386.0144,1496.6459,1661.6329,1281.3807,1418.1049,1720.4528,1659.5752,1850.0979,1815.4945,1940.5505,2133.9128,2241.0034,1956.473,1947.3639,1886.5745,1891.3383,1966.643,1984.3347,2050.0308,2050.6343,1967.2257,2233.615,2276.782,2186.9956,1270.0168,1226.1364,1249.7437,1260.9352,1327.0852,1706.2523,2216.4973,2297.975,1831.7133,1673.1361,1954.3473,2181.8608,1825.4094,1543.2574,1558.8246,1461.3127,1721.6636,1718.2256,1714.2601,1747.5425,1300.7106,972.5979,1962.8397,1471.6417,1728.8649,2156.9958,2077.8616,2120.7803,2207.992,2174.2153,1788.8927,1293.5317,1042.7466,1010.36456,1151.3867,1130.6238,1015.5788,819.8032,799.2401,1048.8445,881.3585,658.19916,537.0389,188.24008,-506.6837,-427.89127,-435.1607,-794.89087,-990.9242,-1643.5059,-1381.8145,-1373.7139,-1434.0773,-1445.6882,-1502.4154,-1462.583,-1314.664,-897.73975,-1228.7571,-1518.1918,-1751.7,-1529.9884,-1710.8324,-1726.6592,-1677.3761,-1263.5197,-1790.9974,-1888.0518,-1875.3162,-1311.0745,-552.5983,-752.7791,-753.98004,-433.91025,2315.1506,2365.857,2452.426,2613.9507,2759.8833,2769.2551,2626.7944,2422.549,2344.5403,2033.9673,2028.4276,1949.4539,1685.5535,1763.609,1670.5325,1398.683,1335.0299,1473.781,1549.5758,1426.0728,1317.5145,1381.3525,1362.4132,1472.2996,1463.6793,1392.5648,1382.5526,1323.6527,1360.3221,1419.4641,1410.1979,1487.443,1633.9376,1610.1672,1722.7145,1795.807,1941.449,1875.4075,1942.474,2025.5004,2102.0432,1854.711,1983.1951,1933.079,1952.3165,1925.2122,1882.1339,2114.9192,2321.8784,1980.6707,1556.9471,2191.8113,2219.1484,2300.2668,1400.3472,1301.9114,1340.2059,1343.5856,1342.7137,1430.6932,2148.6135,2149.0122,1739.6726,1681.2479,1944.9178,1991.5074,1963.1351,1547.9152,1496.3085,1400.1489,1548.106,1621.9153,1737.0991,1791.4749,1509.9948,1560.0946,1983.2089,1964.8486,2080.8647,2173.1018,2076.3838,2276.4658,2440.0845,2361.2478,1895.463,1373.6812,1065.6301,848.6704,976.7953,940.04535,768.6028,591.729,498.6246,972.2711,377.3375,170.55579,-68.48528,-261.69324,-714.5724,-936.6473,-979.8133,-1114.9847,-1186.3889,-1328.5376,-1571.3359,-1637.0709,-1618.1514,-1545.7952,-1581.1144,-1564.0144,-1582.439,-1015.1251,-1294.1388,-1540.6464,-1562.5411,-1640.0153,-1786.7185,-1693.8191,-1783.3615,-1562.4183,-1799.837,-1581.191,-1141.4846,-1232.5977,-1456.5387,-1623.7015,-1428.3446,-1213.7834,2294.4636,2286.2004,2358.8691,2517.7747,2681.7817,2866.902,2605.868,2450.2852,2168.035,2049.7815,1987.208,1886.2771,1895.669,2034.5475,1780.3258,1370.5862,1372.9993,1528.4073,1484.2546,1333.3562,1360.5011,1453.0765,1504.3837,1369.183,1390.3611,1341.5676,1352.1931,1366.1323,1340.3907,1407.2881,1434.9594,1533.5563,1535.2449,1614.6921,1616.7646,1885.6445,2000.0835,1982.5239,2060.496,2011.5287,1848.0115,1931.3997,2060.378,2105.6758,1938.461,1665.5985,2015.7245,2169.189,1854.7083,2606.9292,2374.0142,2352.6194,2322.3552,2551.9563,2565.3657,1866.2539,1542.139,1526.5065,1770.7253,2103.3079,1972.2761,1893.808,1755.2186,1793.8416,1592.8859,1329.7639,2252.8135,1629.7931,1509.1824,1480.1,1495.0527,1716.9984,1774.2218,1802.078,1778.3828,1737.9027,1487.7413,1731.7916,1853.5338,2020.0159,2152.5457,2193.2036,2287.0432,2154.5085,1805.4679,1218.2637,953.7386,695.07324,657.1501,812.3267,664.2015,509.50714,319.7924,224.17392,82.26164,-35.36331,-355.29214,-679.5104,-936.89215,-1153.8684,-1312.1354,-1405.9147,-1319.742,-1372.6107,-1575.6213,-1702.2683,-1752.9326,-1661.538,-1597.9354,-1537.5875,-1344.9911,-1325.9211,-1462.924,-1512.4464,-1731.5197,-1785.6442,-1991.3519,-2063.765,-2176.463,-2152.8408,-1750.0304,-1585.3041,-1500.2393,-1737.1355,-1939.9219,-1827.168,-1781.4799,-1348.3486,2345.5862,2343.2075,2376.3428,2514.6462,2652.481,2621.1567,2406.7654,2183.52,2069.508,1979.257,1940.2644,1800.1616,1763.5939,1831.7822,1438.3792,1312.7179,1300.4956,1270.9812,1328.3286,1270.7837,1337.4083,1438.2856,1396.0197,1380.406,1318.5538,1318.15,1312.2913,1402.3844,1244.3427,1339.5378,1403.3318,1522.179,1477.2736,1498.065,1568.0135,1719.2961,1820.3397,1981.944,2129.7888,1939.0853,1681.7494,1622.7561,1963.3213,1466.4445,1653.7466,1848.3527,2102.8447,1996.2482,1507.6447,2461.651,2157.063,2514.9272,2611.1887,2516.9795,2713.8845,2591.7017,2463.1484,2356.9993,2306.5881,1947.7423,2085.9822,1855.6206,1388.721,1399.8236,1452.7386,1800.6458,2238.5764,1669.8955,1530.8584,1528.2134,1583.3673,1737.8871,1823.7031,1691.6401,1485.5651,1372.8737,1457.7133,1129.7021,1494.829,1755.1371,1731.6384,2030.9283,1949.6804,1798.2625,1298.6593,878.9815,919.8629,673.6915,534.05945,501.9645,604.07794,541.9726,415.38992,293.42117,164.22417,-4.785175,-395.4988,-770.51044,-1011.6983,-1163.035,-1237.0508,-1388.9281,-1529.0903,-1408.7252,-1603.7292,-1758.6554,-1789.9265,-1639.468,-1502.1746,-1491.9554,-1562.9763,-1754.7355,-1488.2659,-1693.9268,-1782.1594,-1837.5321,-2094.208,-2178.879,-2261.6577,-2246.8213,-2074.8113,-1825.0037,-1894.0812,-1805.595,-1546.0354,-1584.1328,-1743.0277,-1342.0057,2591.065,2472.0303,2170.4753,2677.1794,2574.5293,2433.7678,2187.4236,1982.852,1860.473,1886.6259,1689.1833,1713.3236,1684.529,1664.5938,1411.1211,1156.2224,1188.8842,1225.6769,1254.1289,1209.2078,1388.6287,1591.1752,1369.3672,1393.5603,1378.5671,1329.7556,1297.2678,1281.7415,1324.4658,1327.7855,1362.0245,1478.7345,1509.5579,1478.7855,1440.2759,1442.1907,1588.3282,1914.6813,1933.8894,1678.1696,1548.5492,1661.2535,1788.6466,1168.799,1427.6084,2225.3276,2073.5298,2139.2874,2386.557,2385.7104,2727.6406,2880.3428,2518.4207,2229.9497,2377.0515,2346.779,2449.557,2327.3489,1951.2711,1817.5057,2017.4695,1673.2804,1291.0133,1162.2854,1376.3752,2062.1467,1568.2227,1720.907,1536.6549,1691.038,1006.1368,555.0494,1351.3993,1457.159,1181.6366,1101.822,1111.5027,784.53534,694.5147,1229.6051,792.19403,1379.214,1510.9507,1357.0632,871.5664,627.8026,4.129269,-205.74469,697.58527,495.1456,409.85004,481.77875,178.48508,82.936066,123.85039,-112.44483,-433.07068,-713.8643,-1111.4713,-1215.0785,-1259.6421,-1399.7998,-1515.1602,-1585.106,-1435.2881,-1635.3483,-1851.637,-1907.6151,-1749.1797,-1722.708,-1838.6395,-2003.2367,-1898.7758,-1734.1915,-2151.6716,-2128.2588,-2203.399,-2264.835,-2249.791,-1968.4755,-1673.2101,-1456.8911,-1657.2612,-1742.2487,-1579.2589,-1564.5654,-1314.243,-863.2655,1989.0044,2610.0881,2203.7722,2679.8174,2388.8552,2117.457,1923.8733,1867.157,1845.04,1753.1309,1703.229,1682.0607,1625.38,1565.9696,1383.4255,1201.8457,1189.3007,1215.2366,1237.4016,1303.5566,1310.2902,1661.6438,1570.6821,1503.0208,1370.4397,1197.3394,1189.3998,1295.1176,1265.11,1259.7047,1348.1353,1539.3467,1582.5354,1469.4567,1307.5433,1194.1655,1294.9387,1619.2131,1558.7019,1413.9471,1473.1514,1474.963,1626.2998,1954.2461,2151.586,2277.831,2332.6255,2323.7932,2355.6138,2430.0942,2512.6282,2536.6445,2227.2686,1991.7904,1969.304,2199.6917,2084.847,1991.9948,2019.766,2065.5347,1923.0945,1557.3168,1200.3402,1093.2471,1309.3186,1558.1409,1233.6671,1635.8293,1834.1553,1735.6426,890.19037,486.2316,1024.5221,1161.3269,868.8338,682.82825,423.54208,88.40618,-56.87001,350.2364,226.53871,979.6358,826.7074,762.55634,555.38403,246.52365,-112.385124,-303.82068,494.99777,370.53088,294.9245,93.32977,-81.9,-572.7704,-252.74417,-413.30524,-305.87994,-633.24615,-828.42926,-1023.7329,-1270.1627,-1462.199,-1657.4298,-1761.1729,-1737.1719,-1792.2588,-1917.5808,-1925.6458,-1891.0094,-1912.9591,-1952.5468,-2133.6204,-2305.0144,-2254.0295,-2296.293,-2257.8167,-2347.069,-2265.4038,-2227.7761,-1725.1208,-936.55164,-678.78326,-1103.3546,-1586.0204,-1510.5813,-1336.7343,-1103.3213,-891.8508,1386.5662,2755.2734,2746.1274,2338.29,2193.3452,2068.0308,1944.7195,1610.4537,1764.7493,1763.6018,1849.7799,1620.1675,1193.1586,1703.8252,1464.2345,1221.1578,1082.1233,1195.3044,1266.9083,1173.4335,1100.802,1422.847,1218.4686,1389.4077,1308.7743,1123.6161,1115.0613,1228.9425,1237.004,1230.6731,1399.2866,1164.0808,1399.9639,1601.2966,1268.2648,1080.845,1073.6139,1330.4774,1351.9529,1280.8335,1314.7627,1358.1549,1673.6017,1923.1649,2172.5876,2457.0518,2563.2026,2448.6772,2429.326,2503.0159,2394.843,2219.5042,1973.5397,1783.7535,1589.5273,1474.3228,1129.7644,1718.3275,1640.5568,1615.4202,1555.1804,1316.291,1238.1963,1017.78644,790.31744,1229.138,1298.0718,1505.6628,854.90063,635.7103,1099.817,1238.5204,1070.0258,493.61218,87.505684,68.91336,-208.73389,-631.28796,-706.55725,-322.5593,-484.37192,136.07133,190.83238,308.44174,59.421032,-143.42935,-928.6315,-265.47678,-2.020266,-6.735021,187.75146,-53.854244,-557.09503,-879.0544,-802.5954,-769.0186,-762.9695,-755.07654,-899.23895,-1012.91254,-1258.0061,-1471.3383,-1694.667,-1765.4009,-1842.5376,-1965.3203,-2000.8809,-1949.754,-2009.4963,-2689.5803,-2684.3354,-2121.1328,-2421.339,-2536.9155,-2556.3428,-2348.964,-2412.0283,-2398.221,-2081.7036,-397.39935,484.9571,368.50287,-750.9946,-1432.436,-1436.2576,-1373.719,-1166.8212,-1115.465,2610.827,2634.5798,2559.2854,2109.4492,2060.5767,1372.552,1423.8322,1419.0846,1613.8861,1785.705,2057.2285,1821.2421,1393.0522,1584.8092,1263.8344,1221.8561,1163.7289,1157.1692,1120.9741,1058.8025,1030.5508,1003.6912,938.85834,1051.2863,969.8313,1093.7738,1124.2638,1187.1436,1253.1293,1179.8773,1378.3138,1065.1245,1193.9097,1532.1158,1220.739,1057.9078,1134.7134,1411.3993,1201.3948,1217.3627,1228.2062,1479.3945,1922.3651,2093.728,2333.2612,2527.4668,2664.29,2121.8027,2535.1018,2582.8152,2631.8906,2534.3987,1981.8717,1645.8704,1516.8086,1444.2955,1475.7556,1557.5558,1573.7936,1517.9216,1385.632,1393.217,1255.312,1115.9314,786.57086,960.93665,1188.7963,1343.7899,550.3192,287.7756,1165.58,1383.5292,822.0129,416.7405,-9.498089,-736.5798,-841.7859,-880.9793,-1174.8046,-1297.6628,-863.1543,-436.53976,-168.11337,-55.861492,-312.4164,-1029.8163,-1604.4424,-1125.9155,-537.0029,-681.08484,-1186.4763,-500.42245,-860.34216,-1230.1644,-1374.6498,-1344.6915,-1442.7605,-1381.6349,-1299.5035,-1220.9039,-1423.476,-1649.4489,-1818.5671,-1905.0111,-1920.1458,-2039.3464,-2063.667,-2075.687,-2114.8586,-2524.5427,-2319.725,-2318.993,-2501.2258,-2694.136,-2615.7188,-2550.7642,-2589.0388,-2654.706,-1517.0717,1878.4386,2138.7742,1030.2058,-954.1995,-1753.2548,-1481.7084,-1470.2971,-1320.2681,-1156.7924,2461.0781,2250.0688,2442.2012,1976.9209,1966.5295,1535.1594,1327.044,1411.6115,1595.0697,2105.3853,2153.32,2016.7867,1678.6478,1269.3866,1270.3081,1172.7672,1235.2524,1087.726,985.7775,999.8053,1001.23224,964.7462,915.04047,967.9244,1076.0028,1142.0226,1099.2922,1061.1389,932.57135,1103.2494,1150.4148,1198.35,1250.9451,1125.8462,977.76263,1006.9413,1211.6205,1530.1663,1066.5453,1041.4502,1232.0693,1780.3433,2120.1929,2323.6897,2530.616,2468.1233,2742.942,2731.2195,2278.6685,2974.6528,2868.8547,2617.681,2287.1453,1888.2402,1678.205,1155.418,1414.4115,1661.0928,1626.1449,1615.5391,1232.6473,1404.2197,1301.8965,1138.9065,927.93335,703.6878,886.7957,951.8201,1012.531,925.704,1094.7318,751.363,353.61313,-10.431211,-324.51993,-794.6332,-1438.6154,-1534.199,-1485.965,-1274.7306,-1005.96387,-704.1184,-464.29254,-375.25064,-479.21286,-896.2603,-1313.2908,-1300.1819,-1136.9316,-1118.1908,-1233.5825,-969.37695,-1171.1973,-1393.7195,-1645.7145,-1716.4775,-1647.2382,-1684.3245,-1665.5514,-1651.3469,-1855.353,-1882.4149,-1914.344,-1916.4348,-1988.758,-2085.904,-2103.6995,-2180.8303,-2232.7166,-2206.18,-2261.0671,-2510.88,-2657.8735,-2664.9219,-2762.0576,-2784.8596,-2779.1755,-2728.191,-1325.1761,1656.691,1614.8151,1023.096,-1226.23,-2071.5852,-1648.6527,-1559.7096,-1346.3187,-1089.8394,2448.7437,2412.8486,2505.9102,1908.0792,1897.705,1467.0913,1464.2756,1437.3442,2130.3604,2263.3064,2072.8381,1655.4803,1382.078,1336.5238,1362.9109,1362.1051,1230.904,1144.9485,1010.18085,971.2459,1015.4904,947.87195,969.1233,1024.2356,1053.4227,979.28925,1006.3659,1005.07294,835.81775,958.70807,930.66895,886.0716,875.42303,906.1963,1090.8092,1010.8709,1211.1051,1233.2025,942.7261,842.8488,1105.7764,757.51733,882.0557,2311.7268,2585.3655,2889.2322,2992.8875,3110.1917,2941.6792,3004.009,2704.6897,2620.1274,2439.157,1980.6957,2291.613,1777.8705,1923.266,1642.6393,1374.9393,1261.305,900.1513,1228.7828,1130.9855,1169.3693,773.2526,296.32404,417.71008,296.82556,-30.71606,448.4079,360.10852,195.12022,-114.95369,-469.81573,-681.1174,-989.24243,-1367.6646,-1476.0873,-1105.789,-904.25604,-852.4355,-762.2316,-955.5473,-1023.4098,-756.5041,-1417.5802,-1641.6427,-2166.3604,-1997.8392,-1768.2917,-1776.5383,-1603.1788,-1625.8955,-1808.9666,-1945.3365,-2058.4133,-1978.7332,-1841.1255,-1851.0343,-2084.0654,-2128.3708,-2064.336,-1943.8838,-1905.2794,-2032.3326,-2145.3079,-2153.3516,-2290.0056,-2398.3787,-2432.1733,-2517.6233,-2637.8645,-2752.0142,-2769.4255,-2906.2673,-2986.6318,-2969.2893,-2935.4382,-2173.6086,-103.52014,515.22437,-386.6176,-1844.7212,-2096.0232,-1684.4375,-1487.2572,-1248.7089,-1214.2383,2369.4478,2022.4357,1730.7067,1756.9558,1859.1044,1442.1428,1163.8245,1569.7633,1727.751,1300.4902,2012.6707,1479.0996,1434.0425,1458.3422,1221.144,1151.5009,1025.1093,1360.4752,1319.1848,1222.3203,919.5121,847.8111,843.7025,856.0269,844.2546,915.60004,963.1158,960.121,903.15344,872.5538,872.81146,739.015,770.5803,625.726,871.16583,720.70404,948.219,1222.119,855.63074,747.6348,996.2204,602.14777,747.67645,2098.9485,2318.8333,2586.0398,2599.886,2961.8315,2757.8203,2456.897,2468.2236,2434.3208,2197.398,2034.5001,2150.2031,2298.613,2298.7239,1817.2753,944.22565,1033.7585,582.26135,-593.6421,-692.732,388.92786,324.73685,-263.21484,-234.52084,-81.305244,-11.144392,-76.65123,102.18823,-239.10535,-698.4325,-1025.6932,-1017.75604,-1116.4879,-1474.1348,-1419.6051,-1306.7806,-984.3514,-982.9316,-946.24164,-1298.143,-1703.8876,-1773.6984,-2242.8374,-2195.1377,-2108.6348,-1926.8516,-1707.6177,-1779.7053,-1917.044,-2095.189,-2102.4087,-2117.9387,-2150.0876,-2139.2332,-2181.1558,-1963.5984,-2163.8005,-2163.406,-2150.8882,-2104.3564,-1971.2041,-2100.3909,-2170.2354,-2254.748,-2358.9814,-2513.2944,-2589.9897,-2540.8713,-2494.5686,-2626.6626,-2814.223,-2806.69,-2890.7715,-2945.3928,-2745.581,-2288.2358,-1925.7794,-1613.3701,-2057.4863,-2403.929,-1943.9176,-1695.2511,-1578.2241,-1483.0474,-1481.8853,2407.461,1652.7692,1727.8315,1782.3457,1824.903,1369.651,1262.1288,934.91534,792.0505,1684.8608,2042.8663,1480.2753,1643.102,1758.5527,1240.0573,1056.8141,1140.8209,1407.2124,1609.1848,1522.7689,949.2128,719.5608,629.784,675.34924,735.42773,977.05963,983.4314,885.89594,784.3787,728.7225,747.1968,641.12964,687.46576,445.05936,538.1714,341.18964,738.4389,1094.2615,576.6613,588.2064,746.9398,1094.8795,1211.2252,1965.4236,2123.665,1741.5232,1495.0283,2833.1338,2514.8647,2228.1885,1895.3195,1830.1731,1679.6008,1666.3422,1809.0679,1881.4535,1772.2081,1439.2096,1299.2686,931.25885,134.31349,-835.7712,-939.68805,-82.3653,-109.97988,-426.4904,-417.95697,-1479.201,-1975.4934,-1207.6416,-76.4622,-490.4544,-982.8511,-1933.1964,-1823.8708,-1427.2815,-1650.621,-1302.5481,-1347.1404,-1548.4697,-1636.0173,-1769.9712,-1997.9253,-1896.1173,-2060.301,-1924.7548,-1923.3064,-1902.2308,-1895.1124,-1973.1031,-2132.5432,-2153.8816,-2227.6877,-2207.9011,-2303.1177,-2176.5144,-2235.9631,-2318.8884,-2172.1348,-2208.6575,-2185.614,-2066.971,-2102.9443,-2151.5986,-2152.8406,-2239.6392,-2346.624,-2487.9395,-2625.9456,-2642.7593,-2451.8484,-2438.1685,-2574.8062,-2689.4128,-2649.7124,-2728.5662,-2778.5999,-2571.5493,-2201.9314,-2172.4949,-2477.4424,-2600.419,-2146.5464,-1861.2681,-1807.4639,-1751.2219,-1735.1763,-1721.5853,1880.4105,1421.4508,1933.4543,1797.7086,1770.7635,1283.8396,1626.161,1266.2295,615.90216,979.5421,1491.8844,1467.0618,1810.2153,1452.9016,1172.5521,1103.7125,1294.9615,1368.1519,1340.1663,1101.6375,891.00366,722.26,283.7662,381.3332,555.4811,855.2477,993.4685,937.7789,767.82745,676.99567,636.1033,539.4309,529.67004,267.77222,244.35612,-169.24716,102.73166,719.89703,548.13855,637.982,700.0633,833.6682,953.5574,1560.6837,1826.8036,1687.9916,1249.991,2425.6367,2117.0845,1822.7921,1769.9639,1476.8651,1366.2524,1429.9233,1465.6057,1524.8552,1546.6669,1615.4818,1180.5125,962.66364,489.26367,-594.79346,-755.72833,-400.47543,-672.1908,-877.10315,-1236.0098,-3137.1892,-2665.4077,-2552.6123,-874.25336,-943.31537,-1575.4808,-2237.1858,-2234.941,-1851.9263,-1559.6053,-1071.7151,-1294.8229,-1231.207,-1295.8314,-1867.4202,-1745.6234,-1776.7338,-1834.2593,-1961.9211,-2199.3,-2286.8506,-2372.1536,-2274.325,-2337.5132,-2336.9429,-2332.1685,-2342.639,-2302.0237,-2193.5103,-2207.8076,-2194.675,-2286.3054,-2460.8,-2275.84,-2153.2153,-2250.649,-2250.7517,-2313.3872,-2397.4373,-2540.1018,-2652.9712,-2781.9148,-2675.8643,-2638.053,-2707.7974,-2573.8933,-2618.1792,-2562.1572,-2621.5647,-2704.831,-2672.4146,-2496.1135,-2624.8472,-2587.8474,-2495.5093,-2097.6604,-1941.3403,-1954.6088,-1884.5983,-1889.6409,-1557.736,1143.838,1205.4717,2073.1458,2154.6665,1863.6366,610.6782,1403.7876,1579.0557,900.50055,740.56116,1244.6393,1456.6528,1378.9281,1099.0261,1050.9338,1254.9552,1392.0967,1524.2975,1192.4196,936.6213,521.79004,478.53268,148.84535,141.10863,248.51834,464.37744,291.9046,331.8258,105.5008,564.98553,508.3323,444.1167,417.01797,-227.01453,-278.58694,-261.76242,476.93436,880.87006,607.1473,792.56573,738.9652,861.14716,1168.7228,1392.3014,1547.6733,1708.3091,1954.3503,1983.041,1899.9067,1810.7365,1149.1885,1373.5813,1250.6346,1307.4036,1399.948,1500.4608,1551.5579,1067.2838,706.5657,822.97015,442.61615,-1832.1226,-1795.3146,-1267.2142,-950.1595,-1128.5844,-1724.7838,-3628.0105,-2543.2664,-3278.0073,-1812.5857,-2033.2247,-1801.2418,-2383.8892,-1951.7695,-1321.366,-1108.6958,-1200.7666,-732.4928,-2076.2266,-2060.115,-1786.7262,-1572.2854,-1648.8064,-1861.4877,-2008.1521,-2299.2036,-2453.4067,-2505.0867,-2471.4517,-2410.5852,-2290.0225,-2309.803,-2186.6157,-2117.7527,-2264.6985,-2206.8022,-2290.8347,-2368.8462,-2389.6455,-2403.8953,-2295.16,-2349.01,-2363.7007,-2466.2112,-2595.086,-2702.6025,-2822.1462,-2930.064,-2837.1936,-2696.973,-2676.072,-2693.3552,-2780.2263,-2780.1216,-2845.8884,-2852.2393,-2904.2698,-2941.0269,-2873.3574,-2720.7432,-2508.0903,-2351.832,-2198.954,-2139.585,-2005.9888,-1992.1237,-1669.0804,934.5759,1289.707,1894.8387,1738.4727,1668.1279,1778.6571,2010.4261,989.2117,917.4886,897.583,1342.5001,1475.4437,1265.8535,1209.3876,1181.3386,1337.2444,1311.4174,1353.3405,1128.4528,857.8941,600.6427,264.37222,71.20654,97.22075,157.12202,444.9363,627.83093,-233.0608,-40.22808,584.3669,327.58005,330.39987,275.13626,70.966675,-383.19827,-188.52501,982.82623,1191.5988,894.07214,800.0429,809.91394,860.17426,1048.9761,1262.0419,1595.9177,1848.398,1869.3401,1734.0486,1695.5758,1961.9421,1404.6975,1414.5311,1293.9349,1408.7157,1519.9553,1368.8069,1261.1418,790.57916,529.0962,648.22644,-50.298565,-2157.3313,-1810.0581,-1477.5865,-1271.2424,-1368.7435,-1884.1354,-2749.4312,-3164.5276,-2400.9255,-1569.0284,-1148.46,-1471.5896,-1504.9534,-1074.6511,-1362.1469,-1418.794,-1655.08,-1588.0072,-2173.553,-1961.5717,-1753.6112,-1612.9746,-1630.3555,-1776.1545,-2085.886,-2394.8457,-2501.0862,-2532.8462,-2414.046,-2254.9683,-2112.1333,-2029.2445,-1829.8756,-2073.5842,-2219.8623,-2265.8928,-2225.2844,-2430.5642,-2532.9907,-2529.0146,-2500.1304,-2587.9348,-2630.6597,-2631.5732,-2761.8335,-2846.747,-2921.857,-2956.7708,-2941.1516,-2830.1797,-2808.2332,-2839.9658,-2931.6135,-2955.0325,-2956.2466,-2942.8962,-2943.0303,-2893.8894,-2983.78,-2784.5112,-2567.4517,-2510.9136,-2393.0981,-2303.7031,-2237.603,-2009.3397,-1914.3118,1118.1938,843.81537,1367.1237,1396.8951,1101.7823,1061.0365,1125.7437,860.4719,970.02,794.9615,1028.8973,979.08936,1091.9668,1343.0376,1433.4166,1114.2686,1091.8564,1064.8134,1045.8383,766.9065,302.89224,78.547874,32.13752,23.642492,-52.649303,15.657109,439.08383,248.86694,237.32468,142.89023,173.19182,176.05133,50.825302,-204.43178,-353.03687,69.22047,553.7041,465.9126,801.73926,817.5915,900.18164,1028.5499,1239.2565,1314.3317,1069.4784,1824.6298,1692.9531,1568.1895,1527.7363,1911.2944,1678.9406,1404.8411,1250.539,1479.6262,1703.315,1288.2649,850.3556,1102.9194,562.4558,340.41885,-121.19702,-1880.028,-2358.2793,-2097.3105,-1753.4983,-1999.8125,-2559.156,-2090.559,-2577.4805,-2123.3096,-1138.6112,-1546.0962,-1463.923,-1449.5208,-1695.0737,-1702.4224,-1963.2902,-2039.0581,-2052.6675,-2100.452,-1828.0768,-1590.2357,-1612.0103,-1674.1008,-1899.3209,-2253.6492,-2423.966,-2495.0684,-2456.2256,-2339.242,-2260.4504,-2084.935,-1793.0485,-1857.8154,-2135.4292,-2270.637,-2556.455,-2542.1494,-2728.7236,-2662.3652,-2582.0293,-2627.0713,-2689.8086,-2770.966,-2778.5132,-2869.4634,-2912.2522,-2935.3906,-2956.9185,-2957.3367,-2929.7441,-2917.198,-2947.0632,-2961.8376,-2993.0317,-2994.5625,-2957.7104,-2928.269,-2960.0293,-2982.8254,-2864.1753,-2714.4844,-2651.339,-2485.128,-2285.0063,-2257.9539,-2204.2705,-2005.2523,1119.8599,52.699963,937.8789,827.8338,1794.0874,1356.0227,893.10187,803.03754,1195.3256,990.70386,1036.3822,1263.9928,1445.3037,1440.8743,1273.3577,935.27466,1010.07166,1184.1178,1122.8562,666.8188,155.65367,10.447961,-69.08279,-107.90744,-153.10283,-92.3779,283.00354,590.8029,378.94495,-38.207077,-539.9493,-255.0271,-456.02835,-389.15262,-378.07938,-172.58801,112.67993,-49.872936,652.4864,998.7881,1086.0156,1175.8837,1418.6047,1595.5879,1687.72,1608.9573,1592.5929,1507.8118,1519.4604,1855.8044,1444.5785,1089.7189,1294.272,1396.4899,1540.6982,1459.2435,1344.864,834.70715,239.22397,-329.18286,-597.54175,-1432.5377,-2425.9736,-2315.3533,-1921.1986,-2346.211,-2653.2195,-2320.0874,-2387.3086,-2137.1826,-1403.0085,-1855.561,-1982.1028,-2331.361,-2389.5105,-2093.9038,-2220.306,-1734.1082,-1863.2849,-2040.2965,-1722.5546,-1589.4893,-1697.9855,-1916.067,-2185.927,-2505.8555,-2508.1775,-2495.688,-2450.1265,-2287.0999,-2118.5908,-2041.9974,-1856.0098,-2084.1118,-2359.7766,-2555.8438,-2742.8901,-2692.1907,-2762.4946,-2769.94,-2705.0222,-2724.442,-2818.5085,-2881.1084,-2890.7834,-2910.815,-2914.2334,-2929.908,-2959.1526,-2980.096,-2969.4104,-2961.2031,-2972.0085,-2997.5442,-3011.0752,-3008.6577,-2899.9045,-2853.88,-2862.5781,-2896.4854,-2885.0322,-2741.728,-2580.6365,-2496.315,-2347.774,-2331.8489,-2352.8665,-2180.41,766.2847,990.4673,587.884,799.66486,1626.5828,1080.1042,783.0535,746.7685,1342.7562,1130.0853,977.8611,1105.6465,1172.4427,1914.8773,1401.823,1671.5212,1290.1665,997.7265,985.43396,441.3778,201.5553,125.42874,37.493954,-163.79709,-214.50203,245.35461,177.56969,308.19797,26.688143,-208.1163,-424.08817,-278.56152,-576.65753,-451.43283,-481.19946,-258.97952,660.072,967.6423,686.1212,873.6053,1056.9558,1342.033,1511.4923,1476.691,1434.1974,1581.759,1434.8972,1162.0748,1187.9628,760.63715,855.00507,782.14624,819.93524,757.89166,925.2897,893.6858,992.0357,570.4473,-130.4763,-927.4147,-1969.7998,-2529.1936,-2358.0273,-2246.7227,-2047.6921,-2419.3455,-2513.324,-2588.9905,-2319.683,-2488.763,-2476.3918,-2528.5474,-2349.8591,-2380.8733,-2639.0776,-2608.316,-2108.8245,-1884.6055,-2022.9778,-1875.8428,-1792.7823,-1769.139,-1834.8049,-2081.5366,-2367.0747,-2409.7598,-2496.8362,-2454.6272,-2304.1052,-2034.0505,-1908.8667,-1976.8076,-2095.4895,-2231.2615,-2472.8032,-2701.607,-2735.305,-2717.6252,-2739.9783,-2800.281,-2850.5515,-2868.1729,-2871.3018,-2884.255,-2895.4648,-2906.608,-2907.3855,-2922.4753,-2958.227,-2984.7996,-2989.772,-2997.758,-3009.3794,-3015.4038,-3004.7524,-2958.943,-2847.282,-2834.144,-2850.4019,-2867.8218,-2912.0444,-2710.7173,-2593.227,-2500.9185,-2407.9302,-2350.4219,-2362.8025,-2432.2017,384.12366,720.20135,384.92752,797.4329,1085.0581,707.11084,386.5734,-574.5049,433.7855,1064.3922,1054.1686,1157.122,1225.7231,1302.7883,988.97784,1188.2168,824.5823,349.44983,1020.8533,379.00797,128.05327,67.1773,-333.02774,-400.4531,-232.42197,5.770957,-236.16055,-226.8885,-537.9356,-692.8334,-600.4389,-566.01526,-598.9533,-584.4419,-363.66348,171.01279,819.0229,408.00327,535.8821,749.10675,675.16705,1198.5156,1330.4753,1457.8357,1462.6722,1528.4918,1323.5323,1102.7308,905.2464,704.0621,335.85315,213.50705,153.81491,303.3452,394.09143,253.74043,111.639305,-705.89996,-1552.1796,-1905.5321,-2211.0596,-2445.2559,-2062.1013,-2254.5237,-2444.5415,-2403.9404,-1925.3378,-2260.2825,-2495.22,-2329.092,-2280.5247,-2620.0134,-2621.6406,-2681.437,-2699.1086,-2639.6658,-2128.091,-2032.7784,-2152.6033,-2032.1382,-1945.3031,-1966.0409,-2079.1604,-2341.8794,-2540.8594,-2421.812,-2376.9368,-2272.9373,-1979.4486,-1783.6858,-1796.7975,-1889.1755,-2109.9111,-2351.9307,-2586.5972,-2717.1255,-2723.5647,-2790.343,-2806.691,-2802.894,-2843.3438,-2859.1807,-2870.3184,-2887.816,-2895.0735,-2898.4866,-2900.9111,-2913.191,-2948.7493,-2981.9426,-2998.0317,-3011.4707,-3017.102,-3017.6445,-2999.024,-2958.7344,-2841.938,-2804.245,-2858.2842,-2836.8093,-2871.5398,-2835.632,-2714.4497,-2621.6907,-2484.6243,-2402.0618,-2379.0503,-2448.6238,359.3452,837.2977,301.57242,611.5852,686.408,358.6822,545.7978,-89.64516,969.4399,844.53784,983.7571,581.11224,618.69556,962.986,305.12335,278.68817,638.20496,1179.4681,1116.6273,429.9463,73.51226,-216.51785,-498.83206,-575.88446,-576.35986,-603.47534,-630.20544,-619.43134,-663.60156,-626.7205,-620.43835,-294.14792,-57.123642,-136.47638,139.77528,761.48486,275.72437,625.0121,319.01675,452.94043,528.17413,868.44116,1164.8777,1467.1525,1266.6854,1073.8888,1307.3353,870.87915,822.7621,590.86395,210.10104,-78.47781,-101.49962,32.208683,-253.40576,-369.26233,-702.19556,-1153.7814,-1707.045,-1827.6716,-2293.8823,-2312.0308,-2181.2126,-2341.0498,-2638.6616,-2627.2378,-2374.8948,-1909.1364,-2091.4343,-2072.004,-2428.4229,-2496.4368,-2651.068,-2668.0515,-2650.1792,-2655.5178,-2318.9255,-2041.5951,-2085.234,-2158.013,-1987.9448,-1993.5154,-2355.2788,-2588.575,-2523.7148,-2503.526,-2396.0974,-2151.7922,-1870.2667,-1815.9243,-1885.6033,-2059.5154,-2220.173,-2492.9194,-2617.8022,-2679.231,-2727.8857,-2787.7234,-2808.3645,-2804.6165,-2832.2083,-2854.9612,-2875.1318,-2883.36,-2892.7893,-2894.9683,-2900.0571,-2914.2124,-2947.4458,-2973.0845,-2993.3562,-3008.7473,-3014.954,-3015.0205,-3010.508,-2976.7153,-2891.0361,-2837.839,-2848.7305,-2865.218,-2864.5593,-2873.5632,-2792.3882,-2614.111,-2569.5706,-2473.1768,-2453.1304,-2456.9485,226.70465,519.46967,88.6868,147.50858,523.2383,-301.35913,479.39206,631.4546,736.597,663.2331,954.8452,1628.3776,977.3597,545.638,380.5857,89.03425,-166.95737,89.4513,320.80032,310.06937,-4.250752,-598.2955,-646.6845,-721.2366,-694.1121,-679.2827,-708.9603,-714.44727,-503.3219,-480.31863,-261.5431,143.52464,-85.16308,97.53106,219.08847,415.4721,-540.496,445.2497,603.34766,361.37802,471.17038,555.94464,995.6842,1248.5894,925.38824,736.658,893.3624,542.9867,178.91185,153.15009,13.297698,-398.42868,-588.6916,-670.23737,-1202.6072,-1307.9625,-1086.3483,-1329.5413,-1833.5475,-1980.8837,-2071.7031,-2326.2742,-2275.9753,-2470.5288,-2618.5286,-2634.5752,-2580.1682,-2534.1743,-2442.9631,-2469.2227,-2435.9297,-2604.43,-2625.6045,-2620.3164,-2656.7598,-2585.2349,-2404.1338,-2143.827,-2099.0823,-2235.8286,-2159.8225,-2142.283,-2551.7393,-2604.5205,-2535.4966,-2511.8455,-2287.8608,-2026.5583,-2050.7737,-2082.8274,-2108.0261,-2185.905,-2323.5352,-2601.089,-2650.5374,-2677.6604,-2731.1294,-2795.084,-2804.385,-2811.4385,-2800.979,-2836.7012,-2880.3071,-2894.0696,-2898.5715,-2902.917,-2909.2217,-2926.4224,-2951.6292,-2969.9507,-2982.506,-3000.9778,-3007.7683,-3002.5234,-3005.196,-3011.0864,-2996.6619,-2964.3113,-2947.9907,-2953.8848,-2957.9036,-2905.8794,-2884.634,-2784.384,-2644.0872,-2559.8867,-2520.5337,-2450.4172],solid=False,xDimension=128,xSpacing=0.708661,yScale=50.0,zDimension=128,zSpacing=0.708661,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.00787,0.00391),(0.01575,0.00391),(0.02362,0.00391),(0.0315,0.00391),(0.03937,0.00391),(0.04724,0.00391),(0.05512,0.00391),(0.06299,0.00391),(0.07087,0.00391),(0.07874,0.00391),(0.08661,0.00391),(0.09449,0.00391),(0.10236,0.00391),(0.11024,0.00391),(0.11811,0.00391),(0.12598,0.00391),(0.13386,0.00391),(0.14173,0.00391),(0.14961,0.00391),(0.15748,0.00391),(0.16535,0.00391),(0.17323,0.00391),(0.1811,0.00391),(0.18898,0.00391),(0.19685,0.00391),(0.20472,0.00391),(0.2126,0.00391),(0.22047,0.00391),(0.22835,0.00391),(0.23622,0.00391),(0.24409,0.00391),(0.25197,0.00391),(0.25984,0.00391),(0.26772,0.00391),(0.27559,0.00391),(0.28346,0.00391),(0.29134,0.00391),(0.29921,0.00391),(0.30709,0.00391),(0.31496,0.00391),(0.32283,0.00391),(0.33071,0.00391),(0.33858,0.00391),(0.34646,0.00391),(0.35433,0.00391),(0.3622,0.00391),(0.37008,0.00391),(0.37795,0.00391),(0.38583,0.00391),(0.3937,0.00391),(0.40157,0.00391),(0.40945,0.00391),(0.41732,0.00391),(0.4252,0.00391),(0.43307,0.00391),(0.44094,0.00391),(0.44882,0.00391),(0.45669,0.00391),(0.46457,0.00391),(0.47244,0.00391),(0.48031,0.00391),(0.48819,0.00391),(0.49606,0.00391),(0.50394,0.00391),(0.51181,0.00391),(0.51969,0.00391),(0.52756,0.00391),(0.53543,0.00391),(0.54331,0.00391),(0.55118,0.00391),(0.55906,0.00391),(0.56693,0.00391),(0.5748,0.00391),(0.58268,0.00391),(0.59055,0.00391),(0.59843,0.00391),(0.6063,0.00391),(0.61417,0.00391),(0.62205,0.00391),(0.62992,0.00391),(0.6378,0.00391),(0.64567,0.00391),(0.65354,0.00391),(0.66142,0.00391),(0.66929,0.00391),(0.67717,0.00391),(0.68504,0.00391),(0.69291,0.00391),(0.70079,0.00391),(0.70866,0.00391),(0.71654,0.00391),(0.72441,0.00391),(0.73228,0.00391),(0.74016,0.00391),(0.74803,0.00391),(0.75591,0.00391),(0.76378,0.00391),(0.77165,0.00391),(0.77953,0.00391),(0.7874,0.00391),(0.79528,0.00391),(0.80315,0.00391),(0.81102,0.00391),(0.8189,0.00391),(0.82677,0.00391),(0.83465,0.00391),(0.84252,0.00391),(0.85039,0.00391),(0.85827,0.00391),(0.86614,0.00391),(0.87402,0.00391),(0.88189,0.00391),(0.88976,0.00391),(0.89764,0.00391),(0.90551,0.00391),(0.91339,0.00391),(0.92126,0.00391),(0.92913,0.00391),(0.93701,0.00391),(0.94488,0.00391),(0.95276,0.00391),(0.96063,0.00391),(0.9685,0.00391),(0.97638,0.00391),(0.98425,0.00391),(0.99213,0.00391),(0.99609,0.00391),(0.00391,0.00787),(0.00787,0.00787),(0.01575,0.00787),(0.02362,0.00787),(0.0315,0.00787),(0.03937,0.00787),(0.04724,0.00787),(0.05512,0.00787),(0.06299,0.00787),(0.07087,0.00787),(0.07874,0.00787),(0.08661,0.00787),(0.09449,0.00787),(0.10236,0.00787),(0.11024,0.00787),(0.11811,0.00787),(0.12598,0.00787),(0.13386,0.00787),(0.14173,0.00787),(0.14961,0.00787),(0.15748,0.00787),(0.16535,0.00787),(0.17323,0.00787),(0.1811,0.00787),(0.18898,0.00787),(0.19685,0.00787),(0.20472,0.00787),(0.2126,0.00787),(0.22047,0.00787),(0.22835,0.00787),(0.23622,0.00787),(0.24409,0.00787),(0.25197,0.00787),(0.25984,0.00787),(0.26772,0.00787),(0.27559,0.00787),(0.28346,0.00787),(0.29134,0.00787),(0.29921,0.00787),(0.30709,0.00787),(0.31496,0.00787),(0.32283,0.00787),(0.33071,0.00787),(0.33858,0.00787),(0.34646,0.00787),(0.35433,0.00787),(0.3622,0.00787),(0.37008,0.00787),(0.37795,0.00787),(0.38583,0.00787),(0.3937,0.00787),(0.40157,0.00787),(0.40945,0.00787),(0.41732,0.00787),(0.4252,0.00787),(0.43307,0.00787),(0.44094,0.00787),(0.44882,0.00787),(0.45669,0.00787),(0.46457,0.00787),(0.47244,0.00787),(0.48031,0.00787),(0.48819,0.00787),(0.49606,0.00787),(0.50394,0.00787),(0.51181,0.00787),(0.51969,0.00787),(0.52756,0.00787),(0.53543,0.00787),(0.54331,0.00787),(0.55118,0.00787),(0.55906,0.00787),(0.56693,0.00787),(0.5748,0.00787),(0.58268,0.00787),(0.59055,0.00787),(0.59843,0.00787),(0.6063,0.00787),(0.61417,0.00787),(0.62205,0.00787),(0.62992,0.00787),(0.6378,0.00787),(0.64567,0.00787),(0.65354,0.00787),(0.66142,0.00787),(0.66929,0.00787),(0.67717,0.00787),(0.68504,0.00787),(0.69291,0.00787),(0.70079,0.00787),(0.70866,0.00787),(0.71654,0.00787),(0.72441,0.00787),(0.73228,0.00787),(0.74016,0.00787),(0.74803,0.00787),(0.75591,0.00787),(0.76378,0.00787),(0.77165,0.00787),(0.77953,0.00787),(0.7874,0.00787),(0.79528,0.00787),(0.80315,0.00787),(0.81102,0.00787),(0.8189,0.00787),(0.82677,0.00787),(0.83465,0.00787),(0.84252,0.00787),(0.85039,0.00787),(0.85827,0.00787),(0.86614,0.00787),(0.87402,0.00787),(0.88189,0.00787),(0.88976,0.00787),(0.89764,0.00787),(0.90551,0.00787),(0.91339,0.00787),(0.92126,0.00787),(0.92913,0.00787),(0.93701,0.00787),(0.94488,0.00787),(0.95276,0.00787),(0.96063,0.00787),(0.9685,0.00787),(0.97638,0.00787),(0.98425,0.00787),(0.99213,0.00787),(0.99609,0.00787),(0.00391,0.01575),(0.00787,0.01575),(0.01575,0.01575),(0.02362,0.01575),(0.0315,0.01575),(0.03937,0.01575),(0.04724,0.01575),(0.05512,0.01575),(0.06299,0.01575),(0.07087,0.01575),(0.07874,0.01575),(0.08661,0.01575),(0.09449,0.01575),(0.10236,0.01575),(0.11024,0.01575),(0.11811,0.01575),(0.12598,0.01575),(0.13386,0.01575),(0.14173,0.01575),(0.14961,0.01575),(0.15748,0.01575),(0.16535,0.01575),(0.17323,0.01575),(0.1811,0.01575),(0.18898,0.01575),(0.19685,0.01575),(0.20472,0.01575),(0.2126,0.01575),(0.22047,0.01575),(0.22835,0.01575),(0.23622,0.01575),(0.24409,0.01575),(0.25197,0.01575),(0.25984,0.01575),(0.26772,0.01575),(0.27559,0.01575),(0.28346,0.01575),(0.29134,0.01575),(0.29921,0.01575),(0.30709,0.01575),(0.31496,0.01575),(0.32283,0.01575),(0.33071,0.01575),(0.33858,0.01575),(0.34646,0.01575),(0.35433,0.01575),(0.3622,0.01575),(0.37008,0.01575),(0.37795,0.01575),(0.38583,0.01575),(0.3937,0.01575),(0.40157,0.01575),(0.40945,0.01575),(0.41732,0.01575),(0.4252,0.01575),(0.43307,0.01575),(0.44094,0.01575),(0.44882,0.01575),(0.45669,0.01575),(0.46457,0.01575),(0.47244,0.01575),(0.48031,0.01575),(0.48819,0.01575),(0.49606,0.01575),(0.50394,0.01575),(0.51181,0.01575),(0.51969,0.01575),(0.52756,0.01575),(0.53543,0.01575),(0.54331,0.01575),(0.55118,0.01575),(0.55906,0.01575),(0.56693,0.01575),(0.5748,0.01575),(0.58268,0.01575),(0.59055,0.01575),(0.59843,0.01575),(0.6063,0.01575),(0.61417,0.01575),(0.62205,0.01575),(0.62992,0.01575),(0.6378,0.01575),(0.64567,0.01575),(0.65354,0.01575),(0.66142,0.01575),(0.66929,0.01575),(0.67717,0.01575),(0.68504,0.01575),(0.69291,0.01575),(0.70079,0.01575),(0.70866,0.01575),(0.71654,0.01575),(0.72441,0.01575),(0.73228,0.01575),(0.74016,0.01575),(0.74803,0.01575),(0.75591,0.01575),(0.76378,0.01575),(0.77165,0.01575),(0.77953,0.01575),(0.7874,0.01575),(0.79528,0.01575),(0.80315,0.01575),(0.81102,0.01575),(0.8189,0.01575),(0.82677,0.01575),(0.83465,0.01575),(0.84252,0.01575),(0.85039,0.01575),(0.85827,0.01575),(0.86614,0.01575),(0.87402,0.01575),(0.88189,0.01575),(0.88976,0.01575),(0.89764,0.01575),(0.90551,0.01575),(0.91339,0.01575),(0.92126,0.01575),(0.92913,0.01575),(0.93701,0.01575),(0.94488,0.01575),(0.95276,0.01575),(0.96063,0.01575),(0.9685,0.01575),(0.97638,0.01575),(0.98425,0.01575),(0.99213,0.01575),(0.99609,0.01575),(0.00391,0.02362),(0.00787,0.02362),(0.01575,0.02362),(0.02362,0.02362),(0.0315,0.02362),(0.03937,0.02362),(0.04724,0.02362),(0.05512,0.02362),(0.06299,0.02362),(0.07087,0.02362),(0.07874,0.02362),(0.08661,0.02362),(0.09449,0.02362),(0.10236,0.02362),(0.11024,0.02362),(0.11811,0.02362),(0.12598,0.02362),(0.13386,0.02362),(0.14173,0.02362),(0.14961,0.02362),(0.15748,0.02362),(0.16535,0.02362),(0.17323,0.02362),(0.1811,0.02362),(0.18898,0.02362),(0.19685,0.02362),(0.20472,0.02362),(0.2126,0.02362),(0.22047,0.02362),(0.22835,0.02362),(0.23622,0.02362),(0.24409,0.02362),(0.25197,0.02362),(0.25984,0.02362),(0.26772,0.02362),(0.27559,0.02362),(0.28346,0.02362),(0.29134,0.02362),(0.29921,0.02362),(0.30709,0.02362),(0.31496,0.02362),(0.32283,0.02362),(0.33071,0.02362),(0.33858,0.02362),(0.34646,0.02362),(0.35433,0.02362),(0.3622,0.02362),(0.37008,0.02362),(0.37795,0.02362),(0.38583,0.02362),(0.3937,0.02362),(0.40157,0.02362),(0.40945,0.02362),(0.41732,0.02362),(0.4252,0.02362),(0.43307,0.02362),(0.44094,0.02362),(0.44882,0.02362),(0.45669,0.02362),(0.46457,0.02362),(0.47244,0.02362),(0.48031,0.02362),(0.48819,0.02362),(0.49606,0.02362),(0.50394,0.02362),(0.51181,0.02362),(0.51969,0.02362),(0.52756,0.02362),(0.53543,0.02362),(0.54331,0.02362),(0.55118,0.02362),(0.55906,0.02362),(0.56693,0.02362),(0.5748,0.02362),(0.58268,0.02362),(0.59055,0.02362),(0.59843,0.02362),(0.6063,0.02362),(0.61417,0.02362),(0.62205,0.02362),(0.62992,0.02362),(0.6378,0.02362),(0.64567,0.02362),(0.65354,0.02362),(0.66142,0.02362),(0.66929,0.02362),(0.67717,0.02362),(0.68504,0.02362),(0.69291,0.02362),(0.70079,0.02362),(0.70866,0.02362),(0.71654,0.02362),(0.72441,0.02362),(0.73228,0.02362),(0.74016,0.02362),(0.74803,0.02362),(0.75591,0.02362),(0.76378,0.02362),(0.77165,0.02362),(0.77953,0.02362),(0.7874,0.02362),(0.79528,0.02362),(0.80315,0.02362),(0.81102,0.02362),(0.8189,0.02362),(0.82677,0.02362),(0.83465,0.02362),(0.84252,0.02362),(0.85039,0.02362),(0.85827,0.02362),(0.86614,0.02362),(0.87402,0.02362),(0.88189,0.02362),(0.88976,0.02362),(0.89764,0.02362),(0.90551,0.02362),(0.91339,0.02362),(0.92126,0.02362),(0.92913,0.02362),(0.93701,0.02362),(0.94488,0.02362),(0.95276,0.02362),(0.96063,0.02362),(0.9685,0.02362),(0.97638,0.02362),(0.98425,0.02362),(0.99213,0.02362),(0.99609,0.02362),(0.00391,0.0315),(0.00787,0.0315),(0.01575,0.0315),(0.02362,0.0315),(0.0315,0.0315),(0.03937,0.0315),(0.04724,0.0315),(0.05512,0.0315),(0.06299,0.0315),(0.07087,0.0315),(0.07874,0.0315),(0.08661,0.0315),(0.09449,0.0315),(0.10236,0.0315),(0.11024,0.0315),(0.11811,0.0315),(0.12598,0.0315),(0.13386,0.0315),(0.14173,0.0315),(0.14961,0.0315),(0.15748,0.0315),(0.16535,0.0315),(0.17323,0.0315),(0.1811,0.0315),(0.18898,0.0315),(0.19685,0.0315),(0.20472,0.0315),(0.2126,0.0315),(0.22047,0.0315),(0.22835,0.0315),(0.23622,0.0315),(0.24409,0.0315),(0.25197,0.0315),(0.25984,0.0315),(0.26772,0.0315),(0.27559,0.0315),(0.28346,0.0315),(0.29134,0.0315),(0.29921,0.0315),(0.30709,0.0315),(0.31496,0.0315),(0.32283,0.0315),(0.33071,0.0315),(0.33858,0.0315),(0.34646,0.0315),(0.35433,0.0315),(0.3622,0.0315),(0.37008,0.0315),(0.37795,0.0315),(0.38583,0.0315),(0.3937,0.0315),(0.40157,0.0315),(0.40945,0.0315),(0.41732,0.0315),(0.4252,0.0315),(0.43307,0.0315),(0.44094,0.0315),(0.44882,0.0315),(0.45669,0.0315),(0.46457,0.0315),(0.47244,0.0315),(0.48031,0.0315),(0.48819,0.0315),(0.49606,0.0315),(0.50394,0.0315),(0.51181,0.0315),(0.51969,0.0315),(0.52756,0.0315),(0.53543,0.0315),(0.54331,0.0315),(0.55118,0.0315),(0.55906,0.0315),(0.56693,0.0315),(0.5748,0.0315),(0.58268,0.0315),(0.59055,0.0315),(0.59843,0.0315),(0.6063,0.0315),(0.61417,0.0315),(0.62205,0.0315),(0.62992,0.0315),(0.6378,0.0315),(0.64567,0.0315),(0.65354,0.0315),(0.66142,0.0315),(0.66929,0.0315),(0.67717,0.0315),(0.68504,0.0315),(0.69291,0.0315),(0.70079,0.0315),(0.70866,0.0315),(0.71654,0.0315),(0.72441,0.0315),(0.73228,0.0315),(0.74016,0.0315),(0.74803,0.0315),(0.75591,0.0315),(0.76378,0.0315),(0.77165,0.0315),(0.77953,0.0315),(0.7874,0.0315),(0.79528,0.0315),(0.80315,0.0315),(0.81102,0.0315),(0.8189,0.0315),(0.82677,0.0315),(0.83465,0.0315),(0.84252,0.0315),(0.85039,0.0315),(0.85827,0.0315),(0.86614,0.0315),(0.87402,0.0315),(0.88189,0.0315),(0.88976,0.0315),(0.89764,0.0315),(0.90551,0.0315),(0.91339,0.0315),(0.92126,0.0315),(0.92913,0.0315),(0.93701,0.0315),(0.94488,0.0315),(0.95276,0.0315),(0.96063,0.0315),(0.9685,0.0315),(0.97638,0.0315),(0.98425,0.0315),(0.99213,0.0315),(0.99609,0.0315),(0.00391,0.03937),(0.00787,0.03937),(0.01575,0.03937),(0.02362,0.03937),(0.0315,0.03937),(0.03937,0.03937),(0.04724,0.03937),(0.05512,0.03937),(0.06299,0.03937),(0.07087,0.03937),(0.07874,0.03937),(0.08661,0.03937),(0.09449,0.03937),(0.10236,0.03937),(0.11024,0.03937),(0.11811,0.03937),(0.12598,0.03937),(0.13386,0.03937),(0.14173,0.03937),(0.14961,0.03937),(0.15748,0.03937),(0.16535,0.03937),(0.17323,0.03937),(0.1811,0.03937),(0.18898,0.03937),(0.19685,0.03937),(0.20472,0.03937),(0.2126,0.03937),(0.22047,0.03937),(0.22835,0.03937),(0.23622,0.03937),(0.24409,0.03937),(0.25197,0.03937),(0.25984,0.03937),(0.26772,0.03937),(0.27559,0.03937),(0.28346,0.03937),(0.29134,0.03937),(0.29921,0.03937),(0.30709,0.03937),(0.31496,0.03937),(0.32283,0.03937),(0.33071,0.03937),(0.33858,0.03937),(0.34646,0.03937),(0.35433,0.03937),(0.3622,0.03937),(0.37008,0.03937),(0.37795,0.03937),(0.38583,0.03937),(0.3937,0.03937),(0.40157,0.03937),(0.40945,0.03937),(0.41732,0.03937),(0.4252,0.03937),(0.43307,0.03937),(0.44094,0.03937),(0.44882,0.03937),(0.45669,0.03937),(0.46457,0.03937),(0.47244,0.03937),(0.48031,0.03937),(0.48819,0.03937),(0.49606,0.03937),(0.50394,0.03937),(0.51181,0.03937),(0.51969,0.03937),(0.52756,0.03937),(0.53543,0.03937),(0.54331,0.03937),(0.55118,0.03937),(0.55906,0.03937),(0.56693,0.03937),(0.5748,0.03937),(0.58268,0.03937),(0.59055,0.03937),(0.59843,0.03937),(0.6063,0.03937),(0.61417,0.03937),(0.62205,0.03937),(0.62992,0.03937),(0.6378,0.03937),(0.64567,0.03937),(0.65354,0.03937),(0.66142,0.03937),(0.66929,0.03937),(0.67717,0.03937),(0.68504,0.03937),(0.69291,0.03937),(0.70079,0.03937),(0.70866,0.03937),(0.71654,0.03937),(0.72441,0.03937),(0.73228,0.03937),(0.74016,0.03937),(0.74803,0.03937),(0.75591,0.03937),(0.76378,0.03937),(0.77165,0.03937),(0.77953,0.03937),(0.7874,0.03937),(0.79528,0.03937),(0.80315,0.03937),(0.81102,0.03937),(0.8189,0.03937),(0.82677,0.03937),(0.83465,0.03937),(0.84252,0.03937),(0.85039,0.03937),(0.85827,0.03937),(0.86614,0.03937),(0.87402,0.03937),(0.88189,0.03937),(0.88976,0.03937),(0.89764,0.03937),(0.90551,0.03937),(0.91339,0.03937),(0.92126,0.03937),(0.92913,0.03937),(0.93701,0.03937),(0.94488,0.03937),(0.95276,0.03937),(0.96063,0.03937),(0.9685,0.03937),(0.97638,0.03937),(0.98425,0.03937),(0.99213,0.03937),(0.99609,0.03937),(0.00391,0.04724),(0.00787,0.04724),(0.01575,0.04724),(0.02362,0.04724),(0.0315,0.04724),(0.03937,0.04724),(0.04724,0.04724),(0.05512,0.04724),(0.06299,0.04724),(0.07087,0.04724),(0.07874,0.04724),(0.08661,0.04724),(0.09449,0.04724),(0.10236,0.04724),(0.11024,0.04724),(0.11811,0.04724),(0.12598,0.04724),(0.13386,0.04724),(0.14173,0.04724),(0.14961,0.04724),(0.15748,0.04724),(0.16535,0.04724),(0.17323,0.04724),(0.1811,0.04724),(0.18898,0.04724),(0.19685,0.04724),(0.20472,0.04724),(0.2126,0.04724),(0.22047,0.04724),(0.22835,0.04724),(0.23622,0.04724),(0.24409,0.04724),(0.25197,0.04724),(0.25984,0.04724),(0.26772,0.04724),(0.27559,0.04724),(0.28346,0.04724),(0.29134,0.04724),(0.29921,0.04724),(0.30709,0.04724),(0.31496,0.04724),(0.32283,0.04724),(0.33071,0.04724),(0.33858,0.04724),(0.34646,0.04724),(0.35433,0.04724),(0.3622,0.04724),(0.37008,0.04724),(0.37795,0.04724),(0.38583,0.04724),(0.3937,0.04724),(0.40157,0.04724),(0.40945,0.04724),(0.41732,0.04724),(0.4252,0.04724),(0.43307,0.04724),(0.44094,0.04724),(0.44882,0.04724),(0.45669,0.04724),(0.46457,0.04724),(0.47244,0.04724),(0.48031,0.04724),(0.48819,0.04724),(0.49606,0.04724),(0.50394,0.04724),(0.51181,0.04724),(0.51969,0.04724),(0.52756,0.04724),(0.53543,0.04724),(0.54331,0.04724),(0.55118,0.04724),(0.55906,0.04724),(0.56693,0.04724),(0.5748,0.04724),(0.58268,0.04724),(0.59055,0.04724),(0.59843,0.04724),(0.6063,0.04724),(0.61417,0.04724),(0.62205,0.04724),(0.62992,0.04724),(0.6378,0.04724),(0.64567,0.04724),(0.65354,0.04724),(0.66142,0.04724),(0.66929,0.04724),(0.67717,0.04724),(0.68504,0.04724),(0.69291,0.04724),(0.70079,0.04724),(0.70866,0.04724),(0.71654,0.04724),(0.72441,0.04724),(0.73228,0.04724),(0.74016,0.04724),(0.74803,0.04724),(0.75591,0.04724),(0.76378,0.04724),(0.77165,0.04724),(0.77953,0.04724),(0.7874,0.04724),(0.79528,0.04724),(0.80315,0.04724),(0.81102,0.04724),(0.8189,0.04724),(0.82677,0.04724),(0.83465,0.04724),(0.84252,0.04724),(0.85039,0.04724),(0.85827,0.04724),(0.86614,0.04724),(0.87402,0.04724),(0.88189,0.04724),(0.88976,0.04724),(0.89764,0.04724),(0.90551,0.04724),(0.91339,0.04724),(0.92126,0.04724),(0.92913,0.04724),(0.93701,0.04724),(0.94488,0.04724),(0.95276,0.04724),(0.96063,0.04724),(0.9685,0.04724),(0.97638,0.04724),(0.98425,0.04724),(0.99213,0.04724),(0.99609,0.04724),(0.00391,0.05512),(0.00787,0.05512),(0.01575,0.05512),(0.02362,0.05512),(0.0315,0.05512),(0.03937,0.05512),(0.04724,0.05512),(0.05512,0.05512),(0.06299,0.05512),(0.07087,0.05512),(0.07874,0.05512),(0.08661,0.05512),(0.09449,0.05512),(0.10236,0.05512),(0.11024,0.05512),(0.11811,0.05512),(0.12598,0.05512),(0.13386,0.05512),(0.14173,0.05512),(0.14961,0.05512),(0.15748,0.05512),(0.16535,0.05512),(0.17323,0.05512),(0.1811,0.05512),(0.18898,0.05512),(0.19685,0.05512),(0.20472,0.05512),(0.2126,0.05512),(0.22047,0.05512),(0.22835,0.05512),(0.23622,0.05512),(0.24409,0.05512),(0.25197,0.05512),(0.25984,0.05512),(0.26772,0.05512),(0.27559,0.05512),(0.28346,0.05512),(0.29134,0.05512),(0.29921,0.05512),(0.30709,0.05512),(0.31496,0.05512),(0.32283,0.05512),(0.33071,0.05512),(0.33858,0.05512),(0.34646,0.05512),(0.35433,0.05512),(0.3622,0.05512),(0.37008,0.05512),(0.37795,0.05512),(0.38583,0.05512),(0.3937,0.05512),(0.40157,0.05512),(0.40945,0.05512),(0.41732,0.05512),(0.4252,0.05512),(0.43307,0.05512),(0.44094,0.05512),(0.44882,0.05512),(0.45669,0.05512),(0.46457,0.05512),(0.47244,0.05512),(0.48031,0.05512),(0.48819,0.05512),(0.49606,0.05512),(0.50394,0.05512),(0.51181,0.05512),(0.51969,0.05512),(0.52756,0.05512),(0.53543,0.05512),(0.54331,0.05512),(0.55118,0.05512),(0.55906,0.05512),(0.56693,0.05512),(0.5748,0.05512),(0.58268,0.05512),(0.59055,0.05512),(0.59843,0.05512),(0.6063,0.05512),(0.61417,0.05512),(0.62205,0.05512),(0.62992,0.05512),(0.6378,0.05512),(0.64567,0.05512),(0.65354,0.05512),(0.66142,0.05512),(0.66929,0.05512),(0.67717,0.05512),(0.68504,0.05512),(0.69291,0.05512),(0.70079,0.05512),(0.70866,0.05512),(0.71654,0.05512),(0.72441,0.05512),(0.73228,0.05512),(0.74016,0.05512),(0.74803,0.05512),(0.75591,0.05512),(0.76378,0.05512),(0.77165,0.05512),(0.77953,0.05512),(0.7874,0.05512),(0.79528,0.05512),(0.80315,0.05512),(0.81102,0.05512),(0.8189,0.05512),(0.82677,0.05512),(0.83465,0.05512),(0.84252,0.05512),(0.85039,0.05512),(0.85827,0.05512),(0.86614,0.05512),(0.87402,0.05512),(0.88189,0.05512),(0.88976,0.05512),(0.89764,0.05512),(0.90551,0.05512),(0.91339,0.05512),(0.92126,0.05512),(0.92913,0.05512),(0.93701,0.05512),(0.94488,0.05512),(0.95276,0.05512),(0.96063,0.05512),(0.9685,0.05512),(0.97638,0.05512),(0.98425,0.05512),(0.99213,0.05512),(0.99609,0.05512),(0.00391,0.06299),(0.00787,0.06299),(0.01575,0.06299),(0.02362,0.06299),(0.0315,0.06299),(0.03937,0.06299),(0.04724,0.06299),(0.05512,0.06299),(0.06299,0.06299),(0.07087,0.06299),(0.07874,0.06299),(0.08661,0.06299),(0.09449,0.06299),(0.10236,0.06299),(0.11024,0.06299),(0.11811,0.06299),(0.12598,0.06299),(0.13386,0.06299),(0.14173,0.06299),(0.14961,0.06299),(0.15748,0.06299),(0.16535,0.06299),(0.17323,0.06299),(0.1811,0.06299),(0.18898,0.06299),(0.19685,0.06299),(0.20472,0.06299),(0.2126,0.06299),(0.22047,0.06299),(0.22835,0.06299),(0.23622,0.06299),(0.24409,0.06299),(0.25197,0.06299),(0.25984,0.06299),(0.26772,0.06299),(0.27559,0.06299),(0.28346,0.06299),(0.29134,0.06299),(0.29921,0.06299),(0.30709,0.06299),(0.31496,0.06299),(0.32283,0.06299),(0.33071,0.06299),(0.33858,0.06299),(0.34646,0.06299),(0.35433,0.06299),(0.3622,0.06299),(0.37008,0.06299),(0.37795,0.06299),(0.38583,0.06299),(0.3937,0.06299),(0.40157,0.06299),(0.40945,0.06299),(0.41732,0.06299),(0.4252,0.06299),(0.43307,0.06299),(0.44094,0.06299),(0.44882,0.06299),(0.45669,0.06299),(0.46457,0.06299),(0.47244,0.06299),(0.48031,0.06299),(0.48819,0.06299),(0.49606,0.06299),(0.50394,0.06299),(0.51181,0.06299),(0.51969,0.06299),(0.52756,0.06299),(0.53543,0.06299),(0.54331,0.06299),(0.55118,0.06299),(0.55906,0.06299),(0.56693,0.06299),(0.5748,0.06299),(0.58268,0.06299),(0.59055,0.06299),(0.59843,0.06299),(0.6063,0.06299),(0.61417,0.06299),(0.62205,0.06299),(0.62992,0.06299),(0.6378,0.06299),(0.64567,0.06299),(0.65354,0.06299),(0.66142,0.06299),(0.66929,0.06299),(0.67717,0.06299),(0.68504,0.06299),(0.69291,0.06299),(0.70079,0.06299),(0.70866,0.06299),(0.71654,0.06299),(0.72441,0.06299),(0.73228,0.06299),(0.74016,0.06299),(0.74803,0.06299),(0.75591,0.06299),(0.76378,0.06299),(0.77165,0.06299),(0.77953,0.06299),(0.7874,0.06299),(0.79528,0.06299),(0.80315,0.06299),(0.81102,0.06299),(0.8189,0.06299),(0.82677,0.06299),(0.83465,0.06299),(0.84252,0.06299),(0.85039,0.06299),(0.85827,0.06299),(0.86614,0.06299),(0.87402,0.06299),(0.88189,0.06299),(0.88976,0.06299),(0.89764,0.06299),(0.90551,0.06299),(0.91339,0.06299),(0.92126,0.06299),(0.92913,0.06299),(0.93701,0.06299),(0.94488,0.06299),(0.95276,0.06299),(0.96063,0.06299),(0.9685,0.06299),(0.97638,0.06299),(0.98425,0.06299),(0.99213,0.06299),(0.99609,0.06299),(0.00391,0.07087),(0.00787,0.07087),(0.01575,0.07087),(0.02362,0.07087),(0.0315,0.07087),(0.03937,0.07087),(0.04724,0.07087),(0.05512,0.07087),(0.06299,0.07087),(0.07087,0.07087),(0.07874,0.07087),(0.08661,0.07087),(0.09449,0.07087),(0.10236,0.07087),(0.11024,0.07087),(0.11811,0.07087),(0.12598,0.07087),(0.13386,0.07087),(0.14173,0.07087),(0.14961,0.07087),(0.15748,0.07087),(0.16535,0.07087),(0.17323,0.07087),(0.1811,0.07087),(0.18898,0.07087),(0.19685,0.07087),(0.20472,0.07087),(0.2126,0.07087),(0.22047,0.07087),(0.22835,0.07087),(0.23622,0.07087),(0.24409,0.07087),(0.25197,0.07087),(0.25984,0.07087),(0.26772,0.07087),(0.27559,0.07087),(0.28346,0.07087),(0.29134,0.07087),(0.29921,0.07087),(0.30709,0.07087),(0.31496,0.07087),(0.32283,0.07087),(0.33071,0.07087),(0.33858,0.07087),(0.34646,0.07087),(0.35433,0.07087),(0.3622,0.07087),(0.37008,0.07087),(0.37795,0.07087),(0.38583,0.07087),(0.3937,0.07087),(0.40157,0.07087),(0.40945,0.07087),(0.41732,0.07087),(0.4252,0.07087),(0.43307,0.07087),(0.44094,0.07087),(0.44882,0.07087),(0.45669,0.07087),(0.46457,0.07087),(0.47244,0.07087),(0.48031,0.07087),(0.48819,0.07087),(0.49606,0.07087),(0.50394,0.07087),(0.51181,0.07087),(0.51969,0.07087),(0.52756,0.07087),(0.53543,0.07087),(0.54331,0.07087),(0.55118,0.07087),(0.55906,0.07087),(0.56693,0.07087),(0.5748,0.07087),(0.58268,0.07087),(0.59055,0.07087),(0.59843,0.07087),(0.6063,0.07087),(0.61417,0.07087),(0.62205,0.07087),(0.62992,0.07087),(0.6378,0.07087),(0.64567,0.07087),(0.65354,0.07087),(0.66142,0.07087),(0.66929,0.07087),(0.67717,0.07087),(0.68504,0.07087),(0.69291,0.07087),(0.70079,0.07087),(0.70866,0.07087),(0.71654,0.07087),(0.72441,0.07087),(0.73228,0.07087),(0.74016,0.07087),(0.74803,0.07087),(0.75591,0.07087),(0.76378,0.07087),(0.77165,0.07087),(0.77953,0.07087),(0.7874,0.07087),(0.79528,0.07087),(0.80315,0.07087),(0.81102,0.07087),(0.8189,0.07087),(0.82677,0.07087),(0.83465,0.07087),(0.84252,0.07087),(0.85039,0.07087),(0.85827,0.07087),(0.86614,0.07087),(0.87402,0.07087),(0.88189,0.07087),(0.88976,0.07087),(0.89764,0.07087),(0.90551,0.07087),(0.91339,0.07087),(0.92126,0.07087),(0.92913,0.07087),(0.93701,0.07087),(0.94488,0.07087),(0.95276,0.07087),(0.96063,0.07087),(0.9685,0.07087),(0.97638,0.07087),(0.98425,0.07087),(0.99213,0.07087),(0.99609,0.07087),(0.00391,0.07874),(0.00787,0.07874),(0.01575,0.07874),(0.02362,0.07874),(0.0315,0.07874),(0.03937,0.07874),(0.04724,0.07874),(0.05512,0.07874),(0.06299,0.07874),(0.07087,0.07874),(0.07874,0.07874),(0.08661,0.07874),(0.09449,0.07874),(0.10236,0.07874),(0.11024,0.07874),(0.11811,0.07874),(0.12598,0.07874),(0.13386,0.07874),(0.14173,0.07874),(0.14961,0.07874),(0.15748,0.07874),(0.16535,0.07874),(0.17323,0.07874),(0.1811,0.07874),(0.18898,0.07874),(0.19685,0.07874),(0.20472,0.07874),(0.2126,0.07874),(0.22047,0.07874),(0.22835,0.07874),(0.23622,0.07874),(0.24409,0.07874),(0.25197,0.07874),(0.25984,0.07874),(0.26772,0.07874),(0.27559,0.07874),(0.28346,0.07874),(0.29134,0.07874),(0.29921,0.07874),(0.30709,0.07874),(0.31496,0.07874),(0.32283,0.07874),(0.33071,0.07874),(0.33858,0.07874),(0.34646,0.07874),(0.35433,0.07874),(0.3622,0.07874),(0.37008,0.07874),(0.37795,0.07874),(0.38583,0.07874),(0.3937,0.07874),(0.40157,0.07874),(0.40945,0.07874),(0.41732,0.07874),(0.4252,0.07874),(0.43307,0.07874),(0.44094,0.07874),(0.44882,0.07874),(0.45669,0.07874),(0.46457,0.07874),(0.47244,0.07874),(0.48031,0.07874),(0.48819,0.07874),(0.49606,0.07874),(0.50394,0.07874),(0.51181,0.07874),(0.51969,0.07874),(0.52756,0.07874),(0.53543,0.07874),(0.54331,0.07874),(0.55118,0.07874),(0.55906,0.07874),(0.56693,0.07874),(0.5748,0.07874),(0.58268,0.07874),(0.59055,0.07874),(0.59843,0.07874),(0.6063,0.07874),(0.61417,0.07874),(0.62205,0.07874),(0.62992,0.07874),(0.6378,0.07874),(0.64567,0.07874),(0.65354,0.07874),(0.66142,0.07874),(0.66929,0.07874),(0.67717,0.07874),(0.68504,0.07874),(0.69291,0.07874),(0.70079,0.07874),(0.70866,0.07874),(0.71654,0.07874),(0.72441,0.07874),(0.73228,0.07874),(0.74016,0.07874),(0.74803,0.07874),(0.75591,0.07874),(0.76378,0.07874),(0.77165,0.07874),(0.77953,0.07874),(0.7874,0.07874),(0.79528,0.07874),(0.80315,0.07874),(0.81102,0.07874),(0.8189,0.07874),(0.82677,0.07874),(0.83465,0.07874),(0.84252,0.07874),(0.85039,0.07874),(0.85827,0.07874),(0.86614,0.07874),(0.87402,0.07874),(0.88189,0.07874),(0.88976,0.07874),(0.89764,0.07874),(0.90551,0.07874),(0.91339,0.07874),(0.92126,0.07874),(0.92913,0.07874),(0.93701,0.07874),(0.94488,0.07874),(0.95276,0.07874),(0.96063,0.07874),(0.9685,0.07874),(0.97638,0.07874),(0.98425,0.07874),(0.99213,0.07874),(0.99609,0.07874),(0.00391,0.08661),(0.00787,0.08661),(0.01575,0.08661),(0.02362,0.08661),(0.0315,0.08661),(0.03937,0.08661),(0.04724,0.08661),(0.05512,0.08661),(0.06299,0.08661),(0.07087,0.08661),(0.07874,0.08661),(0.08661,0.08661),(0.09449,0.08661),(0.10236,0.08661),(0.11024,0.08661),(0.11811,0.08661),(0.12598,0.08661),(0.13386,0.08661),(0.14173,0.08661),(0.14961,0.08661),(0.15748,0.08661),(0.16535,0.08661),(0.17323,0.08661),(0.1811,0.08661),(0.18898,0.08661),(0.19685,0.08661),(0.20472,0.08661),(0.2126,0.08661),(0.22047,0.08661),(0.22835,0.08661),(0.23622,0.08661),(0.24409,0.08661),(0.25197,0.08661),(0.25984,0.08661),(0.26772,0.08661),(0.27559,0.08661),(0.28346,0.08661),(0.29134,0.08661),(0.29921,0.08661),(0.30709,0.08661),(0.31496,0.08661),(0.32283,0.08661),(0.33071,0.08661),(0.33858,0.08661),(0.34646,0.08661),(0.35433,0.08661),(0.3622,0.08661),(0.37008,0.08661),(0.37795,0.08661),(0.38583,0.08661),(0.3937,0.08661),(0.40157,0.08661),(0.40945,0.08661),(0.41732,0.08661),(0.4252,0.08661),(0.43307,0.08661),(0.44094,0.08661),(0.44882,0.08661),(0.45669,0.08661),(0.46457,0.08661),(0.47244,0.08661),(0.48031,0.08661),(0.48819,0.08661),(0.49606,0.08661),(0.50394,0.08661),(0.51181,0.08661),(0.51969,0.08661),(0.52756,0.08661),(0.53543,0.08661),(0.54331,0.08661),(0.55118,0.08661),(0.55906,0.08661),(0.56693,0.08661),(0.5748,0.08661),(0.58268,0.08661),(0.59055,0.08661),(0.59843,0.08661),(0.6063,0.08661),(0.61417,0.08661),(0.62205,0.08661),(0.62992,0.08661),(0.6378,0.08661),(0.64567,0.08661),(0.65354,0.08661),(0.66142,0.08661),(0.66929,0.08661),(0.67717,0.08661),(0.68504,0.08661),(0.69291,0.08661),(0.70079,0.08661),(0.70866,0.08661),(0.71654,0.08661),(0.72441,0.08661),(0.73228,0.08661),(0.74016,0.08661),(0.74803,0.08661),(0.75591,0.08661),(0.76378,0.08661),(0.77165,0.08661),(0.77953,0.08661),(0.7874,0.08661),(0.79528,0.08661),(0.80315,0.08661),(0.81102,0.08661),(0.8189,0.08661),(0.82677,0.08661),(0.83465,0.08661),(0.84252,0.08661),(0.85039,0.08661),(0.85827,0.08661),(0.86614,0.08661),(0.87402,0.08661),(0.88189,0.08661),(0.88976,0.08661),(0.89764,0.08661),(0.90551,0.08661),(0.91339,0.08661),(0.92126,0.08661),(0.92913,0.08661),(0.93701,0.08661),(0.94488,0.08661),(0.95276,0.08661),(0.96063,0.08661),(0.9685,0.08661),(0.97638,0.08661),(0.98425,0.08661),(0.99213,0.08661),(0.99609,0.08661),(0.00391,0.09449),(0.00787,0.09449),(0.01575,0.09449),(0.02362,0.09449),(0.0315,0.09449),(0.03937,0.09449),(0.04724,0.09449),(0.05512,0.09449),(0.06299,0.09449),(0.07087,0.09449),(0.07874,0.09449),(0.08661,0.09449),(0.09449,0.09449),(0.10236,0.09449),(0.11024,0.09449),(0.11811,0.09449),(0.12598,0.09449),(0.13386,0.09449),(0.14173,0.09449),(0.14961,0.09449),(0.15748,0.09449),(0.16535,0.09449),(0.17323,0.09449),(0.1811,0.09449),(0.18898,0.09449),(0.19685,0.09449),(0.20472,0.09449),(0.2126,0.09449),(0.22047,0.09449),(0.22835,0.09449),(0.23622,0.09449),(0.24409,0.09449),(0.25197,0.09449),(0.25984,0.09449),(0.26772,0.09449),(0.27559,0.09449),(0.28346,0.09449),(0.29134,0.09449),(0.29921,0.09449),(0.30709,0.09449),(0.31496,0.09449),(0.32283,0.09449),(0.33071,0.09449),(0.33858,0.09449),(0.34646,0.09449),(0.35433,0.09449),(0.3622,0.09449),(0.37008,0.09449),(0.37795,0.09449),(0.38583,0.09449),(0.3937,0.09449),(0.40157,0.09449),(0.40945,0.09449),(0.41732,0.09449),(0.4252,0.09449),(0.43307,0.09449),(0.44094,0.09449),(0.44882,0.09449),(0.45669,0.09449),(0.46457,0.09449),(0.47244,0.09449),(0.48031,0.09449),(0.48819,0.09449),(0.49606,0.09449),(0.50394,0.09449),(0.51181,0.09449),(0.51969,0.09449),(0.52756,0.09449),(0.53543,0.09449),(0.54331,0.09449),(0.55118,0.09449),(0.55906,0.09449),(0.56693,0.09449),(0.5748,0.09449),(0.58268,0.09449),(0.59055,0.09449),(0.59843,0.09449),(0.6063,0.09449),(0.61417,0.09449),(0.62205,0.09449),(0.62992,0.09449),(0.6378,0.09449),(0.64567,0.09449),(0.65354,0.09449),(0.66142,0.09449),(0.66929,0.09449),(0.67717,0.09449),(0.68504,0.09449),(0.69291,0.09449),(0.70079,0.09449),(0.70866,0.09449),(0.71654,0.09449),(0.72441,0.09449),(0.73228,0.09449),(0.74016,0.09449),(0.74803,0.09449),(0.75591,0.09449),(0.76378,0.09449),(0.77165,0.09449),(0.77953,0.09449),(0.7874,0.09449),(0.79528,0.09449),(0.80315,0.09449),(0.81102,0.09449),(0.8189,0.09449),(0.82677,0.09449),(0.83465,0.09449),(0.84252,0.09449),(0.85039,0.09449),(0.85827,0.09449),(0.86614,0.09449),(0.87402,0.09449),(0.88189,0.09449),(0.88976,0.09449),(0.89764,0.09449),(0.90551,0.09449),(0.91339,0.09449),(0.92126,0.09449),(0.92913,0.09449),(0.93701,0.09449),(0.94488,0.09449),(0.95276,0.09449),(0.96063,0.09449),(0.9685,0.09449),(0.97638,0.09449),(0.98425,0.09449),(0.99213,0.09449),(0.99609,0.09449),(0.00391,0.10236),(0.00787,0.10236),(0.01575,0.10236),(0.02362,0.10236),(0.0315,0.10236),(0.03937,0.10236),(0.04724,0.10236),(0.05512,0.10236),(0.06299,0.10236),(0.07087,0.10236),(0.07874,0.10236),(0.08661,0.10236),(0.09449,0.10236),(0.10236,0.10236),(0.11024,0.10236),(0.11811,0.10236),(0.12598,0.10236),(0.13386,0.10236),(0.14173,0.10236),(0.14961,0.10236),(0.15748,0.10236),(0.16535,0.10236),(0.17323,0.10236),(0.1811,0.10236),(0.18898,0.10236),(0.19685,0.10236),(0.20472,0.10236),(0.2126,0.10236),(0.22047,0.10236),(0.22835,0.10236),(0.23622,0.10236),(0.24409,0.10236),(0.25197,0.10236),(0.25984,0.10236),(0.26772,0.10236),(0.27559,0.10236),(0.28346,0.10236),(0.29134,0.10236),(0.29921,0.10236),(0.30709,0.10236),(0.31496,0.10236),(0.32283,0.10236),(0.33071,0.10236),(0.33858,0.10236),(0.34646,0.10236),(0.35433,0.10236),(0.3622,0.10236),(0.37008,0.10236),(0.37795,0.10236),(0.38583,0.10236),(0.3937,0.10236),(0.40157,0.10236),(0.40945,0.10236),(0.41732,0.10236),(0.4252,0.10236),(0.43307,0.10236),(0.44094,0.10236),(0.44882,0.10236),(0.45669,0.10236),(0.46457,0.10236),(0.47244,0.10236),(0.48031,0.10236),(0.48819,0.10236),(0.49606,0.10236),(0.50394,0.10236),(0.51181,0.10236),(0.51969,0.10236),(0.52756,0.10236),(0.53543,0.10236),(0.54331,0.10236),(0.55118,0.10236),(0.55906,0.10236),(0.56693,0.10236),(0.5748,0.10236),(0.58268,0.10236),(0.59055,0.10236),(0.59843,0.10236),(0.6063,0.10236),(0.61417,0.10236),(0.62205,0.10236),(0.62992,0.10236),(0.6378,0.10236),(0.64567,0.10236),(0.65354,0.10236),(0.66142,0.10236),(0.66929,0.10236),(0.67717,0.10236),(0.68504,0.10236),(0.69291,0.10236),(0.70079,0.10236),(0.70866,0.10236),(0.71654,0.10236),(0.72441,0.10236),(0.73228,0.10236),(0.74016,0.10236),(0.74803,0.10236),(0.75591,0.10236),(0.76378,0.10236),(0.77165,0.10236),(0.77953,0.10236),(0.7874,0.10236),(0.79528,0.10236),(0.80315,0.10236),(0.81102,0.10236),(0.8189,0.10236),(0.82677,0.10236),(0.83465,0.10236),(0.84252,0.10236),(0.85039,0.10236),(0.85827,0.10236),(0.86614,0.10236),(0.87402,0.10236),(0.88189,0.10236),(0.88976,0.10236),(0.89764,0.10236),(0.90551,0.10236),(0.91339,0.10236),(0.92126,0.10236),(0.92913,0.10236),(0.93701,0.10236),(0.94488,0.10236),(0.95276,0.10236),(0.96063,0.10236),(0.9685,0.10236),(0.97638,0.10236),(0.98425,0.10236),(0.99213,0.10236),(0.99609,0.10236),(0.00391,0.11024),(0.00787,0.11024),(0.01575,0.11024),(0.02362,0.11024),(0.0315,0.11024),(0.03937,0.11024),(0.04724,0.11024),(0.05512,0.11024),(0.06299,0.11024),(0.07087,0.11024),(0.07874,0.11024),(0.08661,0.11024),(0.09449,0.11024),(0.10236,0.11024),(0.11024,0.11024),(0.11811,0.11024),(0.12598,0.11024),(0.13386,0.11024),(0.14173,0.11024),(0.14961,0.11024),(0.15748,0.11024),(0.16535,0.11024),(0.17323,0.11024),(0.1811,0.11024),(0.18898,0.11024),(0.19685,0.11024),(0.20472,0.11024),(0.2126,0.11024),(0.22047,0.11024),(0.22835,0.11024),(0.23622,0.11024),(0.24409,0.11024),(0.25197,0.11024),(0.25984,0.11024),(0.26772,0.11024),(0.27559,0.11024),(0.28346,0.11024),(0.29134,0.11024),(0.29921,0.11024),(0.30709,0.11024),(0.31496,0.11024),(0.32283,0.11024),(0.33071,0.11024),(0.33858,0.11024),(0.34646,0.11024),(0.35433,0.11024),(0.3622,0.11024),(0.37008,0.11024),(0.37795,0.11024),(0.38583,0.11024),(0.3937,0.11024),(0.40157,0.11024),(0.40945,0.11024),(0.41732,0.11024),(0.4252,0.11024),(0.43307,0.11024),(0.44094,0.11024),(0.44882,0.11024),(0.45669,0.11024),(0.46457,0.11024),(0.47244,0.11024),(0.48031,0.11024),(0.48819,0.11024),(0.49606,0.11024),(0.50394,0.11024),(0.51181,0.11024),(0.51969,0.11024),(0.52756,0.11024),(0.53543,0.11024),(0.54331,0.11024),(0.55118,0.11024),(0.55906,0.11024),(0.56693,0.11024),(0.5748,0.11024),(0.58268,0.11024),(0.59055,0.11024),(0.59843,0.11024),(0.6063,0.11024),(0.61417,0.11024),(0.62205,0.11024),(0.62992,0.11024),(0.6378,0.11024),(0.64567,0.11024),(0.65354,0.11024),(0.66142,0.11024),(0.66929,0.11024),(0.67717,0.11024),(0.68504,0.11024),(0.69291,0.11024),(0.70079,0.11024),(0.70866,0.11024),(0.71654,0.11024),(0.72441,0.11024),(0.73228,0.11024),(0.74016,0.11024),(0.74803,0.11024),(0.75591,0.11024),(0.76378,0.11024),(0.77165,0.11024),(0.77953,0.11024),(0.7874,0.11024),(0.79528,0.11024),(0.80315,0.11024),(0.81102,0.11024),(0.8189,0.11024),(0.82677,0.11024),(0.83465,0.11024),(0.84252,0.11024),(0.85039,0.11024),(0.85827,0.11024),(0.86614,0.11024),(0.87402,0.11024),(0.88189,0.11024),(0.88976,0.11024),(0.89764,0.11024),(0.90551,0.11024),(0.91339,0.11024),(0.92126,0.11024),(0.92913,0.11024),(0.93701,0.11024),(0.94488,0.11024),(0.95276,0.11024),(0.96063,0.11024),(0.9685,0.11024),(0.97638,0.11024),(0.98425,0.11024),(0.99213,0.11024),(0.99609,0.11024),(0.00391,0.11811),(0.00787,0.11811),(0.01575,0.11811),(0.02362,0.11811),(0.0315,0.11811),(0.03937,0.11811),(0.04724,0.11811),(0.05512,0.11811),(0.06299,0.11811),(0.07087,0.11811),(0.07874,0.11811),(0.08661,0.11811),(0.09449,0.11811),(0.10236,0.11811),(0.11024,0.11811),(0.11811,0.11811),(0.12598,0.11811),(0.13386,0.11811),(0.14173,0.11811),(0.14961,0.11811),(0.15748,0.11811),(0.16535,0.11811),(0.17323,0.11811),(0.1811,0.11811),(0.18898,0.11811),(0.19685,0.11811),(0.20472,0.11811),(0.2126,0.11811),(0.22047,0.11811),(0.22835,0.11811),(0.23622,0.11811),(0.24409,0.11811),(0.25197,0.11811),(0.25984,0.11811),(0.26772,0.11811),(0.27559,0.11811),(0.28346,0.11811),(0.29134,0.11811),(0.29921,0.11811),(0.30709,0.11811),(0.31496,0.11811),(0.32283,0.11811),(0.33071,0.11811),(0.33858,0.11811),(0.34646,0.11811),(0.35433,0.11811),(0.3622,0.11811),(0.37008,0.11811),(0.37795,0.11811),(0.38583,0.11811),(0.3937,0.11811),(0.40157,0.11811),(0.40945,0.11811),(0.41732,0.11811),(0.4252,0.11811),(0.43307,0.11811),(0.44094,0.11811),(0.44882,0.11811),(0.45669,0.11811),(0.46457,0.11811),(0.47244,0.11811),(0.48031,0.11811),(0.48819,0.11811),(0.49606,0.11811),(0.50394,0.11811),(0.51181,0.11811),(0.51969,0.11811),(0.52756,0.11811),(0.53543,0.11811),(0.54331,0.11811),(0.55118,0.11811),(0.55906,0.11811),(0.56693,0.11811),(0.5748,0.11811),(0.58268,0.11811),(0.59055,0.11811),(0.59843,0.11811),(0.6063,0.11811),(0.61417,0.11811),(0.62205,0.11811),(0.62992,0.11811),(0.6378,0.11811),(0.64567,0.11811),(0.65354,0.11811),(0.66142,0.11811),(0.66929,0.11811),(0.67717,0.11811),(0.68504,0.11811),(0.69291,0.11811),(0.70079,0.11811),(0.70866,0.11811),(0.71654,0.11811),(0.72441,0.11811),(0.73228,0.11811),(0.74016,0.11811),(0.74803,0.11811),(0.75591,0.11811),(0.76378,0.11811),(0.77165,0.11811),(0.77953,0.11811),(0.7874,0.11811),(0.79528,0.11811),(0.80315,0.11811),(0.81102,0.11811),(0.8189,0.11811),(0.82677,0.11811),(0.83465,0.11811),(0.84252,0.11811),(0.85039,0.11811),(0.85827,0.11811),(0.86614,0.11811),(0.87402,0.11811),(0.88189,0.11811),(0.88976,0.11811),(0.89764,0.11811),(0.90551,0.11811),(0.91339,0.11811),(0.92126,0.11811),(0.92913,0.11811),(0.93701,0.11811),(0.94488,0.11811),(0.95276,0.11811),(0.96063,0.11811),(0.9685,0.11811),(0.97638,0.11811),(0.98425,0.11811),(0.99213,0.11811),(0.99609,0.11811),(0.00391,0.12598),(0.00787,0.12598),(0.01575,0.12598),(0.02362,0.12598),(0.0315,0.12598),(0.03937,0.12598),(0.04724,0.12598),(0.05512,0.12598),(0.06299,0.12598),(0.07087,0.12598),(0.07874,0.12598),(0.08661,0.12598),(0.09449,0.12598),(0.10236,0.12598),(0.11024,0.12598),(0.11811,0.12598),(0.12598,0.12598),(0.13386,0.12598),(0.14173,0.12598),(0.14961,0.12598),(0.15748,0.12598),(0.16535,0.12598),(0.17323,0.12598),(0.1811,0.12598),(0.18898,0.12598),(0.19685,0.12598),(0.20472,0.12598),(0.2126,0.12598),(0.22047,0.12598),(0.22835,0.12598),(0.23622,0.12598),(0.24409,0.12598),(0.25197,0.12598),(0.25984,0.12598),(0.26772,0.12598),(0.27559,0.12598),(0.28346,0.12598),(0.29134,0.12598),(0.29921,0.12598),(0.30709,0.12598),(0.31496,0.12598),(0.32283,0.12598),(0.33071,0.12598),(0.33858,0.12598),(0.34646,0.12598),(0.35433,0.12598),(0.3622,0.12598),(0.37008,0.12598),(0.37795,0.12598),(0.38583,0.12598),(0.3937,0.12598),(0.40157,0.12598),(0.40945,0.12598),(0.41732,0.12598),(0.4252,0.12598),(0.43307,0.12598),(0.44094,0.12598),(0.44882,0.12598),(0.45669,0.12598),(0.46457,0.12598),(0.47244,0.12598),(0.48031,0.12598),(0.48819,0.12598),(0.49606,0.12598),(0.50394,0.12598),(0.51181,0.12598),(0.51969,0.12598),(0.52756,0.12598),(0.53543,0.12598),(0.54331,0.12598),(0.55118,0.12598),(0.55906,0.12598),(0.56693,0.12598),(0.5748,0.12598),(0.58268,0.12598),(0.59055,0.12598),(0.59843,0.12598),(0.6063,0.12598),(0.61417,0.12598),(0.62205,0.12598),(0.62992,0.12598),(0.6378,0.12598),(0.64567,0.12598),(0.65354,0.12598),(0.66142,0.12598),(0.66929,0.12598),(0.67717,0.12598),(0.68504,0.12598),(0.69291,0.12598),(0.70079,0.12598),(0.70866,0.12598),(0.71654,0.12598),(0.72441,0.12598),(0.73228,0.12598),(0.74016,0.12598),(0.74803,0.12598),(0.75591,0.12598),(0.76378,0.12598),(0.77165,0.12598),(0.77953,0.12598),(0.7874,0.12598),(0.79528,0.12598),(0.80315,0.12598),(0.81102,0.12598),(0.8189,0.12598),(0.82677,0.12598),(0.83465,0.12598),(0.84252,0.12598),(0.85039,0.12598),(0.85827,0.12598),(0.86614,0.12598),(0.87402,0.12598),(0.88189,0.12598),(0.88976,0.12598),(0.89764,0.12598),(0.90551,0.12598),(0.91339,0.12598),(0.92126,0.12598),(0.92913,0.12598),(0.93701,0.12598),(0.94488,0.12598),(0.95276,0.12598),(0.96063,0.12598),(0.9685,0.12598),(0.97638,0.12598),(0.98425,0.12598),(0.99213,0.12598),(0.99609,0.12598),(0.00391,0.13386),(0.00787,0.13386),(0.01575,0.13386),(0.02362,0.13386),(0.0315,0.13386),(0.03937,0.13386),(0.04724,0.13386),(0.05512,0.13386),(0.06299,0.13386),(0.07087,0.13386),(0.07874,0.13386),(0.08661,0.13386),(0.09449,0.13386),(0.10236,0.13386),(0.11024,0.13386),(0.11811,0.13386),(0.12598,0.13386),(0.13386,0.13386),(0.14173,0.13386),(0.14961,0.13386),(0.15748,0.13386),(0.16535,0.13386),(0.17323,0.13386),(0.1811,0.13386),(0.18898,0.13386),(0.19685,0.13386),(0.20472,0.13386),(0.2126,0.13386),(0.22047,0.13386),(0.22835,0.13386),(0.23622,0.13386),(0.24409,0.13386),(0.25197,0.13386),(0.25984,0.13386),(0.26772,0.13386),(0.27559,0.13386),(0.28346,0.13386),(0.29134,0.13386),(0.29921,0.13386),(0.30709,0.13386),(0.31496,0.13386),(0.32283,0.13386),(0.33071,0.13386),(0.33858,0.13386),(0.34646,0.13386),(0.35433,0.13386),(0.3622,0.13386),(0.37008,0.13386),(0.37795,0.13386),(0.38583,0.13386),(0.3937,0.13386),(0.40157,0.13386),(0.40945,0.13386),(0.41732,0.13386),(0.4252,0.13386),(0.43307,0.13386),(0.44094,0.13386),(0.44882,0.13386),(0.45669,0.13386),(0.46457,0.13386),(0.47244,0.13386),(0.48031,0.13386),(0.48819,0.13386),(0.49606,0.13386),(0.50394,0.13386),(0.51181,0.13386),(0.51969,0.13386),(0.52756,0.13386),(0.53543,0.13386),(0.54331,0.13386),(0.55118,0.13386),(0.55906,0.13386),(0.56693,0.13386),(0.5748,0.13386),(0.58268,0.13386),(0.59055,0.13386),(0.59843,0.13386),(0.6063,0.13386),(0.61417,0.13386),(0.62205,0.13386),(0.62992,0.13386),(0.6378,0.13386),(0.64567,0.13386),(0.65354,0.13386),(0.66142,0.13386),(0.66929,0.13386),(0.67717,0.13386),(0.68504,0.13386),(0.69291,0.13386),(0.70079,0.13386),(0.70866,0.13386),(0.71654,0.13386),(0.72441,0.13386),(0.73228,0.13386),(0.74016,0.13386),(0.74803,0.13386),(0.75591,0.13386),(0.76378,0.13386),(0.77165,0.13386),(0.77953,0.13386),(0.7874,0.13386),(0.79528,0.13386),(0.80315,0.13386),(0.81102,0.13386),(0.8189,0.13386),(0.82677,0.13386),(0.83465,0.13386),(0.84252,0.13386),(0.85039,0.13386),(0.85827,0.13386),(0.86614,0.13386),(0.87402,0.13386),(0.88189,0.13386),(0.88976,0.13386),(0.89764,0.13386),(0.90551,0.13386),(0.91339,0.13386),(0.92126,0.13386),(0.92913,0.13386),(0.93701,0.13386),(0.94488,0.13386),(0.95276,0.13386),(0.96063,0.13386),(0.9685,0.13386),(0.97638,0.13386),(0.98425,0.13386),(0.99213,0.13386),(0.99609,0.13386),(0.00391,0.14173),(0.00787,0.14173),(0.01575,0.14173),(0.02362,0.14173),(0.0315,0.14173),(0.03937,0.14173),(0.04724,0.14173),(0.05512,0.14173),(0.06299,0.14173),(0.07087,0.14173),(0.07874,0.14173),(0.08661,0.14173),(0.09449,0.14173),(0.10236,0.14173),(0.11024,0.14173),(0.11811,0.14173),(0.12598,0.14173),(0.13386,0.14173),(0.14173,0.14173),(0.14961,0.14173),(0.15748,0.14173),(0.16535,0.14173),(0.17323,0.14173),(0.1811,0.14173),(0.18898,0.14173),(0.19685,0.14173),(0.20472,0.14173),(0.2126,0.14173),(0.22047,0.14173),(0.22835,0.14173),(0.23622,0.14173),(0.24409,0.14173),(0.25197,0.14173),(0.25984,0.14173),(0.26772,0.14173),(0.27559,0.14173),(0.28346,0.14173),(0.29134,0.14173),(0.29921,0.14173),(0.30709,0.14173),(0.31496,0.14173),(0.32283,0.14173),(0.33071,0.14173),(0.33858,0.14173),(0.34646,0.14173),(0.35433,0.14173),(0.3622,0.14173),(0.37008,0.14173),(0.37795,0.14173),(0.38583,0.14173),(0.3937,0.14173),(0.40157,0.14173),(0.40945,0.14173),(0.41732,0.14173),(0.4252,0.14173),(0.43307,0.14173),(0.44094,0.14173),(0.44882,0.14173),(0.45669,0.14173),(0.46457,0.14173),(0.47244,0.14173),(0.48031,0.14173),(0.48819,0.14173),(0.49606,0.14173),(0.50394,0.14173),(0.51181,0.14173),(0.51969,0.14173),(0.52756,0.14173),(0.53543,0.14173),(0.54331,0.14173),(0.55118,0.14173),(0.55906,0.14173),(0.56693,0.14173),(0.5748,0.14173),(0.58268,0.14173),(0.59055,0.14173),(0.59843,0.14173),(0.6063,0.14173),(0.61417,0.14173),(0.62205,0.14173),(0.62992,0.14173),(0.6378,0.14173),(0.64567,0.14173),(0.65354,0.14173),(0.66142,0.14173),(0.66929,0.14173),(0.67717,0.14173),(0.68504,0.14173),(0.69291,0.14173),(0.70079,0.14173),(0.70866,0.14173),(0.71654,0.14173),(0.72441,0.14173),(0.73228,0.14173),(0.74016,0.14173),(0.74803,0.14173),(0.75591,0.14173),(0.76378,0.14173),(0.77165,0.14173),(0.77953,0.14173),(0.7874,0.14173),(0.79528,0.14173),(0.80315,0.14173),(0.81102,0.14173),(0.8189,0.14173),(0.82677,0.14173),(0.83465,0.14173),(0.84252,0.14173),(0.85039,0.14173),(0.85827,0.14173),(0.86614,0.14173),(0.87402,0.14173),(0.88189,0.14173),(0.88976,0.14173),(0.89764,0.14173),(0.90551,0.14173),(0.91339,0.14173),(0.92126,0.14173),(0.92913,0.14173),(0.93701,0.14173),(0.94488,0.14173),(0.95276,0.14173),(0.96063,0.14173),(0.9685,0.14173),(0.97638,0.14173),(0.98425,0.14173),(0.99213,0.14173),(0.99609,0.14173),(0.00391,0.14961),(0.00787,0.14961),(0.01575,0.14961),(0.02362,0.14961),(0.0315,0.14961),(0.03937,0.14961),(0.04724,0.14961),(0.05512,0.14961),(0.06299,0.14961),(0.07087,0.14961),(0.07874,0.14961),(0.08661,0.14961),(0.09449,0.14961),(0.10236,0.14961),(0.11024,0.14961),(0.11811,0.14961),(0.12598,0.14961),(0.13386,0.14961),(0.14173,0.14961),(0.14961,0.14961),(0.15748,0.14961),(0.16535,0.14961),(0.17323,0.14961),(0.1811,0.14961),(0.18898,0.14961),(0.19685,0.14961),(0.20472,0.14961),(0.2126,0.14961),(0.22047,0.14961),(0.22835,0.14961),(0.23622,0.14961),(0.24409,0.14961),(0.25197,0.14961),(0.25984,0.14961),(0.26772,0.14961),(0.27559,0.14961),(0.28346,0.14961),(0.29134,0.14961),(0.29921,0.14961),(0.30709,0.14961),(0.31496,0.14961),(0.32283,0.14961),(0.33071,0.14961),(0.33858,0.14961),(0.34646,0.14961),(0.35433,0.14961),(0.3622,0.14961),(0.37008,0.14961),(0.37795,0.14961),(0.38583,0.14961),(0.3937,0.14961),(0.40157,0.14961),(0.40945,0.14961),(0.41732,0.14961),(0.4252,0.14961),(0.43307,0.14961),(0.44094,0.14961),(0.44882,0.14961),(0.45669,0.14961),(0.46457,0.14961),(0.47244,0.14961),(0.48031,0.14961),(0.48819,0.14961),(0.49606,0.14961),(0.50394,0.14961),(0.51181,0.14961),(0.51969,0.14961),(0.52756,0.14961),(0.53543,0.14961),(0.54331,0.14961),(0.55118,0.14961),(0.55906,0.14961),(0.56693,0.14961),(0.5748,0.14961),(0.58268,0.14961),(0.59055,0.14961),(0.59843,0.14961),(0.6063,0.14961),(0.61417,0.14961),(0.62205,0.14961),(0.62992,0.14961),(0.6378,0.14961),(0.64567,0.14961),(0.65354,0.14961),(0.66142,0.14961),(0.66929,0.14961),(0.67717,0.14961),(0.68504,0.14961),(0.69291,0.14961),(0.70079,0.14961),(0.70866,0.14961),(0.71654,0.14961),(0.72441,0.14961),(0.73228,0.14961),(0.74016,0.14961),(0.74803,0.14961),(0.75591,0.14961),(0.76378,0.14961),(0.77165,0.14961),(0.77953,0.14961),(0.7874,0.14961),(0.79528,0.14961),(0.80315,0.14961),(0.81102,0.14961),(0.8189,0.14961),(0.82677,0.14961),(0.83465,0.14961),(0.84252,0.14961),(0.85039,0.14961),(0.85827,0.14961),(0.86614,0.14961),(0.87402,0.14961),(0.88189,0.14961),(0.88976,0.14961),(0.89764,0.14961),(0.90551,0.14961),(0.91339,0.14961),(0.92126,0.14961),(0.92913,0.14961),(0.93701,0.14961),(0.94488,0.14961),(0.95276,0.14961),(0.96063,0.14961),(0.9685,0.14961),(0.97638,0.14961),(0.98425,0.14961),(0.99213,0.14961),(0.99609,0.14961),(0.00391,0.15748),(0.00787,0.15748),(0.01575,0.15748),(0.02362,0.15748),(0.0315,0.15748),(0.03937,0.15748),(0.04724,0.15748),(0.05512,0.15748),(0.06299,0.15748),(0.07087,0.15748),(0.07874,0.15748),(0.08661,0.15748),(0.09449,0.15748),(0.10236,0.15748),(0.11024,0.15748),(0.11811,0.15748),(0.12598,0.15748),(0.13386,0.15748),(0.14173,0.15748),(0.14961,0.15748),(0.15748,0.15748),(0.16535,0.15748),(0.17323,0.15748),(0.1811,0.15748),(0.18898,0.15748),(0.19685,0.15748),(0.20472,0.15748),(0.2126,0.15748),(0.22047,0.15748),(0.22835,0.15748),(0.23622,0.15748),(0.24409,0.15748),(0.25197,0.15748),(0.25984,0.15748),(0.26772,0.15748),(0.27559,0.15748),(0.28346,0.15748),(0.29134,0.15748),(0.29921,0.15748),(0.30709,0.15748),(0.31496,0.15748),(0.32283,0.15748),(0.33071,0.15748),(0.33858,0.15748),(0.34646,0.15748),(0.35433,0.15748),(0.3622,0.15748),(0.37008,0.15748),(0.37795,0.15748),(0.38583,0.15748),(0.3937,0.15748),(0.40157,0.15748),(0.40945,0.15748),(0.41732,0.15748),(0.4252,0.15748),(0.43307,0.15748),(0.44094,0.15748),(0.44882,0.15748),(0.45669,0.15748),(0.46457,0.15748),(0.47244,0.15748),(0.48031,0.15748),(0.48819,0.15748),(0.49606,0.15748),(0.50394,0.15748),(0.51181,0.15748),(0.51969,0.15748),(0.52756,0.15748),(0.53543,0.15748),(0.54331,0.15748),(0.55118,0.15748),(0.55906,0.15748),(0.56693,0.15748),(0.5748,0.15748),(0.58268,0.15748),(0.59055,0.15748),(0.59843,0.15748),(0.6063,0.15748),(0.61417,0.15748),(0.62205,0.15748),(0.62992,0.15748),(0.6378,0.15748),(0.64567,0.15748),(0.65354,0.15748),(0.66142,0.15748),(0.66929,0.15748),(0.67717,0.15748),(0.68504,0.15748),(0.69291,0.15748),(0.70079,0.15748),(0.70866,0.15748),(0.71654,0.15748),(0.72441,0.15748),(0.73228,0.15748),(0.74016,0.15748),(0.74803,0.15748),(0.75591,0.15748),(0.76378,0.15748),(0.77165,0.15748),(0.77953,0.15748),(0.7874,0.15748),(0.79528,0.15748),(0.80315,0.15748),(0.81102,0.15748),(0.8189,0.15748),(0.82677,0.15748),(0.83465,0.15748),(0.84252,0.15748),(0.85039,0.15748),(0.85827,0.15748),(0.86614,0.15748),(0.87402,0.15748),(0.88189,0.15748),(0.88976,0.15748),(0.89764,0.15748),(0.90551,0.15748),(0.91339,0.15748),(0.92126,0.15748),(0.92913,0.15748),(0.93701,0.15748),(0.94488,0.15748),(0.95276,0.15748),(0.96063,0.15748),(0.9685,0.15748),(0.97638,0.15748),(0.98425,0.15748),(0.99213,0.15748),(0.99609,0.15748),(0.00391,0.16535),(0.00787,0.16535),(0.01575,0.16535),(0.02362,0.16535),(0.0315,0.16535),(0.03937,0.16535),(0.04724,0.16535),(0.05512,0.16535),(0.06299,0.16535),(0.07087,0.16535),(0.07874,0.16535),(0.08661,0.16535),(0.09449,0.16535),(0.10236,0.16535),(0.11024,0.16535),(0.11811,0.16535),(0.12598,0.16535),(0.13386,0.16535),(0.14173,0.16535),(0.14961,0.16535),(0.15748,0.16535),(0.16535,0.16535),(0.17323,0.16535),(0.1811,0.16535),(0.18898,0.16535),(0.19685,0.16535),(0.20472,0.16535),(0.2126,0.16535),(0.22047,0.16535),(0.22835,0.16535),(0.23622,0.16535),(0.24409,0.16535),(0.25197,0.16535),(0.25984,0.16535),(0.26772,0.16535),(0.27559,0.16535),(0.28346,0.16535),(0.29134,0.16535),(0.29921,0.16535),(0.30709,0.16535),(0.31496,0.16535),(0.32283,0.16535),(0.33071,0.16535),(0.33858,0.16535),(0.34646,0.16535),(0.35433,0.16535),(0.3622,0.16535),(0.37008,0.16535),(0.37795,0.16535),(0.38583,0.16535),(0.3937,0.16535),(0.40157,0.16535),(0.40945,0.16535),(0.41732,0.16535),(0.4252,0.16535),(0.43307,0.16535),(0.44094,0.16535),(0.44882,0.16535),(0.45669,0.16535),(0.46457,0.16535),(0.47244,0.16535),(0.48031,0.16535),(0.48819,0.16535),(0.49606,0.16535),(0.50394,0.16535),(0.51181,0.16535),(0.51969,0.16535),(0.52756,0.16535),(0.53543,0.16535),(0.54331,0.16535),(0.55118,0.16535),(0.55906,0.16535),(0.56693,0.16535),(0.5748,0.16535),(0.58268,0.16535),(0.59055,0.16535),(0.59843,0.16535),(0.6063,0.16535),(0.61417,0.16535),(0.62205,0.16535),(0.62992,0.16535),(0.6378,0.16535),(0.64567,0.16535),(0.65354,0.16535),(0.66142,0.16535),(0.66929,0.16535),(0.67717,0.16535),(0.68504,0.16535),(0.69291,0.16535),(0.70079,0.16535),(0.70866,0.16535),(0.71654,0.16535),(0.72441,0.16535),(0.73228,0.16535),(0.74016,0.16535),(0.74803,0.16535),(0.75591,0.16535),(0.76378,0.16535),(0.77165,0.16535),(0.77953,0.16535),(0.7874,0.16535),(0.79528,0.16535),(0.80315,0.16535),(0.81102,0.16535),(0.8189,0.16535),(0.82677,0.16535),(0.83465,0.16535),(0.84252,0.16535),(0.85039,0.16535),(0.85827,0.16535),(0.86614,0.16535),(0.87402,0.16535),(0.88189,0.16535),(0.88976,0.16535),(0.89764,0.16535),(0.90551,0.16535),(0.91339,0.16535),(0.92126,0.16535),(0.92913,0.16535),(0.93701,0.16535),(0.94488,0.16535),(0.95276,0.16535),(0.96063,0.16535),(0.9685,0.16535),(0.97638,0.16535),(0.98425,0.16535),(0.99213,0.16535),(0.99609,0.16535),(0.00391,0.17323),(0.00787,0.17323),(0.01575,0.17323),(0.02362,0.17323),(0.0315,0.17323),(0.03937,0.17323),(0.04724,0.17323),(0.05512,0.17323),(0.06299,0.17323),(0.07087,0.17323),(0.07874,0.17323),(0.08661,0.17323),(0.09449,0.17323),(0.10236,0.17323),(0.11024,0.17323),(0.11811,0.17323),(0.12598,0.17323),(0.13386,0.17323),(0.14173,0.17323),(0.14961,0.17323),(0.15748,0.17323),(0.16535,0.17323),(0.17323,0.17323),(0.1811,0.17323),(0.18898,0.17323),(0.19685,0.17323),(0.20472,0.17323),(0.2126,0.17323),(0.22047,0.17323),(0.22835,0.17323),(0.23622,0.17323),(0.24409,0.17323),(0.25197,0.17323),(0.25984,0.17323),(0.26772,0.17323),(0.27559,0.17323),(0.28346,0.17323),(0.29134,0.17323),(0.29921,0.17323),(0.30709,0.17323),(0.31496,0.17323),(0.32283,0.17323),(0.33071,0.17323),(0.33858,0.17323),(0.34646,0.17323),(0.35433,0.17323),(0.3622,0.17323),(0.37008,0.17323),(0.37795,0.17323),(0.38583,0.17323),(0.3937,0.17323),(0.40157,0.17323),(0.40945,0.17323),(0.41732,0.17323),(0.4252,0.17323),(0.43307,0.17323),(0.44094,0.17323),(0.44882,0.17323),(0.45669,0.17323),(0.46457,0.17323),(0.47244,0.17323),(0.48031,0.17323),(0.48819,0.17323),(0.49606,0.17323),(0.50394,0.17323),(0.51181,0.17323),(0.51969,0.17323),(0.52756,0.17323),(0.53543,0.17323),(0.54331,0.17323),(0.55118,0.17323),(0.55906,0.17323),(0.56693,0.17323),(0.5748,0.17323),(0.58268,0.17323),(0.59055,0.17323),(0.59843,0.17323),(0.6063,0.17323),(0.61417,0.17323),(0.62205,0.17323),(0.62992,0.17323),(0.6378,0.17323),(0.64567,0.17323),(0.65354,0.17323),(0.66142,0.17323),(0.66929,0.17323),(0.67717,0.17323),(0.68504,0.17323),(0.69291,0.17323),(0.70079,0.17323),(0.70866,0.17323),(0.71654,0.17323),(0.72441,0.17323),(0.73228,0.17323),(0.74016,0.17323),(0.74803,0.17323),(0.75591,0.17323),(0.76378,0.17323),(0.77165,0.17323),(0.77953,0.17323),(0.7874,0.17323),(0.79528,0.17323),(0.80315,0.17323),(0.81102,0.17323),(0.8189,0.17323),(0.82677,0.17323),(0.83465,0.17323),(0.84252,0.17323),(0.85039,0.17323),(0.85827,0.17323),(0.86614,0.17323),(0.87402,0.17323),(0.88189,0.17323),(0.88976,0.17323),(0.89764,0.17323),(0.90551,0.17323),(0.91339,0.17323),(0.92126,0.17323),(0.92913,0.17323),(0.93701,0.17323),(0.94488,0.17323),(0.95276,0.17323),(0.96063,0.17323),(0.9685,0.17323),(0.97638,0.17323),(0.98425,0.17323),(0.99213,0.17323),(0.99609,0.17323),(0.00391,0.1811),(0.00787,0.1811),(0.01575,0.1811),(0.02362,0.1811),(0.0315,0.1811),(0.03937,0.1811),(0.04724,0.1811),(0.05512,0.1811),(0.06299,0.1811),(0.07087,0.1811),(0.07874,0.1811),(0.08661,0.1811),(0.09449,0.1811),(0.10236,0.1811),(0.11024,0.1811),(0.11811,0.1811),(0.12598,0.1811),(0.13386,0.1811),(0.14173,0.1811),(0.14961,0.1811),(0.15748,0.1811),(0.16535,0.1811),(0.17323,0.1811),(0.1811,0.1811),(0.18898,0.1811),(0.19685,0.1811),(0.20472,0.1811),(0.2126,0.1811),(0.22047,0.1811),(0.22835,0.1811),(0.23622,0.1811),(0.24409,0.1811),(0.25197,0.1811),(0.25984,0.1811),(0.26772,0.1811),(0.27559,0.1811),(0.28346,0.1811),(0.29134,0.1811),(0.29921,0.1811),(0.30709,0.1811),(0.31496,0.1811),(0.32283,0.1811),(0.33071,0.1811),(0.33858,0.1811),(0.34646,0.1811),(0.35433,0.1811),(0.3622,0.1811),(0.37008,0.1811),(0.37795,0.1811),(0.38583,0.1811),(0.3937,0.1811),(0.40157,0.1811),(0.40945,0.1811),(0.41732,0.1811),(0.4252,0.1811),(0.43307,0.1811),(0.44094,0.1811),(0.44882,0.1811),(0.45669,0.1811),(0.46457,0.1811),(0.47244,0.1811),(0.48031,0.1811),(0.48819,0.1811),(0.49606,0.1811),(0.50394,0.1811),(0.51181,0.1811),(0.51969,0.1811),(0.52756,0.1811),(0.53543,0.1811),(0.54331,0.1811),(0.55118,0.1811),(0.55906,0.1811),(0.56693,0.1811),(0.5748,0.1811),(0.58268,0.1811),(0.59055,0.1811),(0.59843,0.1811),(0.6063,0.1811),(0.61417,0.1811),(0.62205,0.1811),(0.62992,0.1811),(0.6378,0.1811),(0.64567,0.1811),(0.65354,0.1811),(0.66142,0.1811),(0.66929,0.1811),(0.67717,0.1811),(0.68504,0.1811),(0.69291,0.1811),(0.70079,0.1811),(0.70866,0.1811),(0.71654,0.1811),(0.72441,0.1811),(0.73228,0.1811),(0.74016,0.1811),(0.74803,0.1811),(0.75591,0.1811),(0.76378,0.1811),(0.77165,0.1811),(0.77953,0.1811),(0.7874,0.1811),(0.79528,0.1811),(0.80315,0.1811),(0.81102,0.1811),(0.8189,0.1811),(0.82677,0.1811),(0.83465,0.1811),(0.84252,0.1811),(0.85039,0.1811),(0.85827,0.1811),(0.86614,0.1811),(0.87402,0.1811),(0.88189,0.1811),(0.88976,0.1811),(0.89764,0.1811),(0.90551,0.1811),(0.91339,0.1811),(0.92126,0.1811),(0.92913,0.1811),(0.93701,0.1811),(0.94488,0.1811),(0.95276,0.1811),(0.96063,0.1811),(0.9685,0.1811),(0.97638,0.1811),(0.98425,0.1811),(0.99213,0.1811),(0.99609,0.1811),(0.00391,0.18898),(0.00787,0.18898),(0.01575,0.18898),(0.02362,0.18898),(0.0315,0.18898),(0.03937,0.18898),(0.04724,0.18898),(0.05512,0.18898),(0.06299,0.18898),(0.07087,0.18898),(0.07874,0.18898),(0.08661,0.18898),(0.09449,0.18898),(0.10236,0.18898),(0.11024,0.18898),(0.11811,0.18898),(0.12598,0.18898),(0.13386,0.18898),(0.14173,0.18898),(0.14961,0.18898),(0.15748,0.18898),(0.16535,0.18898),(0.17323,0.18898),(0.1811,0.18898),(0.18898,0.18898),(0.19685,0.18898),(0.20472,0.18898),(0.2126,0.18898),(0.22047,0.18898),(0.22835,0.18898),(0.23622,0.18898),(0.24409,0.18898),(0.25197,0.18898),(0.25984,0.18898),(0.26772,0.18898),(0.27559,0.18898),(0.28346,0.18898),(0.29134,0.18898),(0.29921,0.18898),(0.30709,0.18898),(0.31496,0.18898),(0.32283,0.18898),(0.33071,0.18898),(0.33858,0.18898),(0.34646,0.18898),(0.35433,0.18898),(0.3622,0.18898),(0.37008,0.18898),(0.37795,0.18898),(0.38583,0.18898),(0.3937,0.18898),(0.40157,0.18898),(0.40945,0.18898),(0.41732,0.18898),(0.4252,0.18898),(0.43307,0.18898),(0.44094,0.18898),(0.44882,0.18898),(0.45669,0.18898),(0.46457,0.18898),(0.47244,0.18898),(0.48031,0.18898),(0.48819,0.18898),(0.49606,0.18898),(0.50394,0.18898),(0.51181,0.18898),(0.51969,0.18898),(0.52756,0.18898),(0.53543,0.18898),(0.54331,0.18898),(0.55118,0.18898),(0.55906,0.18898),(0.56693,0.18898),(0.5748,0.18898),(0.58268,0.18898),(0.59055,0.18898),(0.59843,0.18898),(0.6063,0.18898),(0.61417,0.18898),(0.62205,0.18898),(0.62992,0.18898),(0.6378,0.18898),(0.64567,0.18898),(0.65354,0.18898),(0.66142,0.18898),(0.66929,0.18898),(0.67717,0.18898),(0.68504,0.18898),(0.69291,0.18898),(0.70079,0.18898),(0.70866,0.18898),(0.71654,0.18898),(0.72441,0.18898),(0.73228,0.18898),(0.74016,0.18898),(0.74803,0.18898),(0.75591,0.18898),(0.76378,0.18898),(0.77165,0.18898),(0.77953,0.18898),(0.7874,0.18898),(0.79528,0.18898),(0.80315,0.18898),(0.81102,0.18898),(0.8189,0.18898),(0.82677,0.18898),(0.83465,0.18898),(0.84252,0.18898),(0.85039,0.18898),(0.85827,0.18898),(0.86614,0.18898),(0.87402,0.18898),(0.88189,0.18898),(0.88976,0.18898),(0.89764,0.18898),(0.90551,0.18898),(0.91339,0.18898),(0.92126,0.18898),(0.92913,0.18898),(0.93701,0.18898),(0.94488,0.18898),(0.95276,0.18898),(0.96063,0.18898),(0.9685,0.18898),(0.97638,0.18898),(0.98425,0.18898),(0.99213,0.18898),(0.99609,0.18898),(0.00391,0.19685),(0.00787,0.19685),(0.01575,0.19685),(0.02362,0.19685),(0.0315,0.19685),(0.03937,0.19685),(0.04724,0.19685),(0.05512,0.19685),(0.06299,0.19685),(0.07087,0.19685),(0.07874,0.19685),(0.08661,0.19685),(0.09449,0.19685),(0.10236,0.19685),(0.11024,0.19685),(0.11811,0.19685),(0.12598,0.19685),(0.13386,0.19685),(0.14173,0.19685),(0.14961,0.19685),(0.15748,0.19685),(0.16535,0.19685),(0.17323,0.19685),(0.1811,0.19685),(0.18898,0.19685),(0.19685,0.19685),(0.20472,0.19685),(0.2126,0.19685),(0.22047,0.19685),(0.22835,0.19685),(0.23622,0.19685),(0.24409,0.19685),(0.25197,0.19685),(0.25984,0.19685),(0.26772,0.19685),(0.27559,0.19685),(0.28346,0.19685),(0.29134,0.19685),(0.29921,0.19685),(0.30709,0.19685),(0.31496,0.19685),(0.32283,0.19685),(0.33071,0.19685),(0.33858,0.19685),(0.34646,0.19685),(0.35433,0.19685),(0.3622,0.19685),(0.37008,0.19685),(0.37795,0.19685),(0.38583,0.19685),(0.3937,0.19685),(0.40157,0.19685),(0.40945,0.19685),(0.41732,0.19685),(0.4252,0.19685),(0.43307,0.19685),(0.44094,0.19685),(0.44882,0.19685),(0.45669,0.19685),(0.46457,0.19685),(0.47244,0.19685),(0.48031,0.19685),(0.48819,0.19685),(0.49606,0.19685),(0.50394,0.19685),(0.51181,0.19685),(0.51969,0.19685),(0.52756,0.19685),(0.53543,0.19685),(0.54331,0.19685),(0.55118,0.19685),(0.55906,0.19685),(0.56693,0.19685),(0.5748,0.19685),(0.58268,0.19685),(0.59055,0.19685),(0.59843,0.19685),(0.6063,0.19685),(0.61417,0.19685),(0.62205,0.19685),(0.62992,0.19685),(0.6378,0.19685),(0.64567,0.19685),(0.65354,0.19685),(0.66142,0.19685),(0.66929,0.19685),(0.67717,0.19685),(0.68504,0.19685),(0.69291,0.19685),(0.70079,0.19685),(0.70866,0.19685),(0.71654,0.19685),(0.72441,0.19685),(0.73228,0.19685),(0.74016,0.19685),(0.74803,0.19685),(0.75591,0.19685),(0.76378,0.19685),(0.77165,0.19685),(0.77953,0.19685),(0.7874,0.19685),(0.79528,0.19685),(0.80315,0.19685),(0.81102,0.19685),(0.8189,0.19685),(0.82677,0.19685),(0.83465,0.19685),(0.84252,0.19685),(0.85039,0.19685),(0.85827,0.19685),(0.86614,0.19685),(0.87402,0.19685),(0.88189,0.19685),(0.88976,0.19685),(0.89764,0.19685),(0.90551,0.19685),(0.91339,0.19685),(0.92126,0.19685),(0.92913,0.19685),(0.93701,0.19685),(0.94488,0.19685),(0.95276,0.19685),(0.96063,0.19685),(0.9685,0.19685),(0.97638,0.19685),(0.98425,0.19685),(0.99213,0.19685),(0.99609,0.19685),(0.00391,0.20472),(0.00787,0.20472),(0.01575,0.20472),(0.02362,0.20472),(0.0315,0.20472),(0.03937,0.20472),(0.04724,0.20472),(0.05512,0.20472),(0.06299,0.20472),(0.07087,0.20472),(0.07874,0.20472),(0.08661,0.20472),(0.09449,0.20472),(0.10236,0.20472),(0.11024,0.20472),(0.11811,0.20472),(0.12598,0.20472),(0.13386,0.20472),(0.14173,0.20472),(0.14961,0.20472),(0.15748,0.20472),(0.16535,0.20472),(0.17323,0.20472),(0.1811,0.20472),(0.18898,0.20472),(0.19685,0.20472),(0.20472,0.20472),(0.2126,0.20472),(0.22047,0.20472),(0.22835,0.20472),(0.23622,0.20472),(0.24409,0.20472),(0.25197,0.20472),(0.25984,0.20472),(0.26772,0.20472),(0.27559,0.20472),(0.28346,0.20472),(0.29134,0.20472),(0.29921,0.20472),(0.30709,0.20472),(0.31496,0.20472),(0.32283,0.20472),(0.33071,0.20472),(0.33858,0.20472),(0.34646,0.20472),(0.35433,0.20472),(0.3622,0.20472),(0.37008,0.20472),(0.37795,0.20472),(0.38583,0.20472),(0.3937,0.20472),(0.40157,0.20472),(0.40945,0.20472),(0.41732,0.20472),(0.4252,0.20472),(0.43307,0.20472),(0.44094,0.20472),(0.44882,0.20472),(0.45669,0.20472),(0.46457,0.20472),(0.47244,0.20472),(0.48031,0.20472),(0.48819,0.20472),(0.49606,0.20472),(0.50394,0.20472),(0.51181,0.20472),(0.51969,0.20472),(0.52756,0.20472),(0.53543,0.20472),(0.54331,0.20472),(0.55118,0.20472),(0.55906,0.20472),(0.56693,0.20472),(0.5748,0.20472),(0.58268,0.20472),(0.59055,0.20472),(0.59843,0.20472),(0.6063,0.20472),(0.61417,0.20472),(0.62205,0.20472),(0.62992,0.20472),(0.6378,0.20472),(0.64567,0.20472),(0.65354,0.20472),(0.66142,0.20472),(0.66929,0.20472),(0.67717,0.20472),(0.68504,0.20472),(0.69291,0.20472),(0.70079,0.20472),(0.70866,0.20472),(0.71654,0.20472),(0.72441,0.20472),(0.73228,0.20472),(0.74016,0.20472),(0.74803,0.20472),(0.75591,0.20472),(0.76378,0.20472),(0.77165,0.20472),(0.77953,0.20472),(0.7874,0.20472),(0.79528,0.20472),(0.80315,0.20472),(0.81102,0.20472),(0.8189,0.20472),(0.82677,0.20472),(0.83465,0.20472),(0.84252,0.20472),(0.85039,0.20472),(0.85827,0.20472),(0.86614,0.20472),(0.87402,0.20472),(0.88189,0.20472),(0.88976,0.20472),(0.89764,0.20472),(0.90551,0.20472),(0.91339,0.20472),(0.92126,0.20472),(0.92913,0.20472),(0.93701,0.20472),(0.94488,0.20472),(0.95276,0.20472),(0.96063,0.20472),(0.9685,0.20472),(0.97638,0.20472),(0.98425,0.20472),(0.99213,0.20472),(0.99609,0.20472),(0.00391,0.2126),(0.00787,0.2126),(0.01575,0.2126),(0.02362,0.2126),(0.0315,0.2126),(0.03937,0.2126),(0.04724,0.2126),(0.05512,0.2126),(0.06299,0.2126),(0.07087,0.2126),(0.07874,0.2126),(0.08661,0.2126),(0.09449,0.2126),(0.10236,0.2126),(0.11024,0.2126),(0.11811,0.2126),(0.12598,0.2126),(0.13386,0.2126),(0.14173,0.2126),(0.14961,0.2126),(0.15748,0.2126),(0.16535,0.2126),(0.17323,0.2126),(0.1811,0.2126),(0.18898,0.2126),(0.19685,0.2126),(0.20472,0.2126),(0.2126,0.2126),(0.22047,0.2126),(0.22835,0.2126),(0.23622,0.2126),(0.24409,0.2126),(0.25197,0.2126),(0.25984,0.2126),(0.26772,0.2126),(0.27559,0.2126),(0.28346,0.2126),(0.29134,0.2126),(0.29921,0.2126),(0.30709,0.2126),(0.31496,0.2126),(0.32283,0.2126),(0.33071,0.2126),(0.33858,0.2126),(0.34646,0.2126),(0.35433,0.2126),(0.3622,0.2126),(0.37008,0.2126),(0.37795,0.2126),(0.38583,0.2126),(0.3937,0.2126),(0.40157,0.2126),(0.40945,0.2126),(0.41732,0.2126),(0.4252,0.2126),(0.43307,0.2126),(0.44094,0.2126),(0.44882,0.2126),(0.45669,0.2126),(0.46457,0.2126),(0.47244,0.2126),(0.48031,0.2126),(0.48819,0.2126),(0.49606,0.2126),(0.50394,0.2126),(0.51181,0.2126),(0.51969,0.2126),(0.52756,0.2126),(0.53543,0.2126),(0.54331,0.2126),(0.55118,0.2126),(0.55906,0.2126),(0.56693,0.2126),(0.5748,0.2126),(0.58268,0.2126),(0.59055,0.2126),(0.59843,0.2126),(0.6063,0.2126),(0.61417,0.2126),(0.62205,0.2126),(0.62992,0.2126),(0.6378,0.2126),(0.64567,0.2126),(0.65354,0.2126),(0.66142,0.2126),(0.66929,0.2126),(0.67717,0.2126),(0.68504,0.2126),(0.69291,0.2126),(0.70079,0.2126),(0.70866,0.2126),(0.71654,0.2126),(0.72441,0.2126),(0.73228,0.2126),(0.74016,0.2126),(0.74803,0.2126),(0.75591,0.2126),(0.76378,0.2126),(0.77165,0.2126),(0.77953,0.2126),(0.7874,0.2126),(0.79528,0.2126),(0.80315,0.2126),(0.81102,0.2126),(0.8189,0.2126),(0.82677,0.2126),(0.83465,0.2126),(0.84252,0.2126),(0.85039,0.2126),(0.85827,0.2126),(0.86614,0.2126),(0.87402,0.2126),(0.88189,0.2126),(0.88976,0.2126),(0.89764,0.2126),(0.90551,0.2126),(0.91339,0.2126),(0.92126,0.2126),(0.92913,0.2126),(0.93701,0.2126),(0.94488,0.2126),(0.95276,0.2126),(0.96063,0.2126),(0.9685,0.2126),(0.97638,0.2126),(0.98425,0.2126),(0.99213,0.2126),(0.99609,0.2126),(0.00391,0.22047),(0.00787,0.22047),(0.01575,0.22047),(0.02362,0.22047),(0.0315,0.22047),(0.03937,0.22047),(0.04724,0.22047),(0.05512,0.22047),(0.06299,0.22047),(0.07087,0.22047),(0.07874,0.22047),(0.08661,0.22047),(0.09449,0.22047),(0.10236,0.22047),(0.11024,0.22047),(0.11811,0.22047),(0.12598,0.22047),(0.13386,0.22047),(0.14173,0.22047),(0.14961,0.22047),(0.15748,0.22047),(0.16535,0.22047),(0.17323,0.22047),(0.1811,0.22047),(0.18898,0.22047),(0.19685,0.22047),(0.20472,0.22047),(0.2126,0.22047),(0.22047,0.22047),(0.22835,0.22047),(0.23622,0.22047),(0.24409,0.22047),(0.25197,0.22047),(0.25984,0.22047),(0.26772,0.22047),(0.27559,0.22047),(0.28346,0.22047),(0.29134,0.22047),(0.29921,0.22047),(0.30709,0.22047),(0.31496,0.22047),(0.32283,0.22047),(0.33071,0.22047),(0.33858,0.22047),(0.34646,0.22047),(0.35433,0.22047),(0.3622,0.22047),(0.37008,0.22047),(0.37795,0.22047),(0.38583,0.22047),(0.3937,0.22047),(0.40157,0.22047),(0.40945,0.22047),(0.41732,0.22047),(0.4252,0.22047),(0.43307,0.22047),(0.44094,0.22047),(0.44882,0.22047),(0.45669,0.22047),(0.46457,0.22047),(0.47244,0.22047),(0.48031,0.22047),(0.48819,0.22047),(0.49606,0.22047),(0.50394,0.22047),(0.51181,0.22047),(0.51969,0.22047),(0.52756,0.22047),(0.53543,0.22047),(0.54331,0.22047),(0.55118,0.22047),(0.55906,0.22047),(0.56693,0.22047),(0.5748,0.22047),(0.58268,0.22047),(0.59055,0.22047),(0.59843,0.22047),(0.6063,0.22047),(0.61417,0.22047),(0.62205,0.22047),(0.62992,0.22047),(0.6378,0.22047),(0.64567,0.22047),(0.65354,0.22047),(0.66142,0.22047),(0.66929,0.22047),(0.67717,0.22047),(0.68504,0.22047),(0.69291,0.22047),(0.70079,0.22047),(0.70866,0.22047),(0.71654,0.22047),(0.72441,0.22047),(0.73228,0.22047),(0.74016,0.22047),(0.74803,0.22047),(0.75591,0.22047),(0.76378,0.22047),(0.77165,0.22047),(0.77953,0.22047),(0.7874,0.22047),(0.79528,0.22047),(0.80315,0.22047),(0.81102,0.22047),(0.8189,0.22047),(0.82677,0.22047),(0.83465,0.22047),(0.84252,0.22047),(0.85039,0.22047),(0.85827,0.22047),(0.86614,0.22047),(0.87402,0.22047),(0.88189,0.22047),(0.88976,0.22047),(0.89764,0.22047),(0.90551,0.22047),(0.91339,0.22047),(0.92126,0.22047),(0.92913,0.22047),(0.93701,0.22047),(0.94488,0.22047),(0.95276,0.22047),(0.96063,0.22047),(0.9685,0.22047),(0.97638,0.22047),(0.98425,0.22047),(0.99213,0.22047),(0.99609,0.22047),(0.00391,0.22835),(0.00787,0.22835),(0.01575,0.22835),(0.02362,0.22835),(0.0315,0.22835),(0.03937,0.22835),(0.04724,0.22835),(0.05512,0.22835),(0.06299,0.22835),(0.07087,0.22835),(0.07874,0.22835),(0.08661,0.22835),(0.09449,0.22835),(0.10236,0.22835),(0.11024,0.22835),(0.11811,0.22835),(0.12598,0.22835),(0.13386,0.22835),(0.14173,0.22835),(0.14961,0.22835),(0.15748,0.22835),(0.16535,0.22835),(0.17323,0.22835),(0.1811,0.22835),(0.18898,0.22835),(0.19685,0.22835),(0.20472,0.22835),(0.2126,0.22835),(0.22047,0.22835),(0.22835,0.22835),(0.23622,0.22835),(0.24409,0.22835),(0.25197,0.22835),(0.25984,0.22835),(0.26772,0.22835),(0.27559,0.22835),(0.28346,0.22835),(0.29134,0.22835),(0.29921,0.22835),(0.30709,0.22835),(0.31496,0.22835),(0.32283,0.22835),(0.33071,0.22835),(0.33858,0.22835),(0.34646,0.22835),(0.35433,0.22835),(0.3622,0.22835),(0.37008,0.22835),(0.37795,0.22835),(0.38583,0.22835),(0.3937,0.22835),(0.40157,0.22835),(0.40945,0.22835),(0.41732,0.22835),(0.4252,0.22835),(0.43307,0.22835),(0.44094,0.22835),(0.44882,0.22835),(0.45669,0.22835),(0.46457,0.22835),(0.47244,0.22835),(0.48031,0.22835),(0.48819,0.22835),(0.49606,0.22835),(0.50394,0.22835),(0.51181,0.22835),(0.51969,0.22835),(0.52756,0.22835),(0.53543,0.22835),(0.54331,0.22835),(0.55118,0.22835),(0.55906,0.22835),(0.56693,0.22835),(0.5748,0.22835),(0.58268,0.22835),(0.59055,0.22835),(0.59843,0.22835),(0.6063,0.22835),(0.61417,0.22835),(0.62205,0.22835),(0.62992,0.22835),(0.6378,0.22835),(0.64567,0.22835),(0.65354,0.22835),(0.66142,0.22835),(0.66929,0.22835),(0.67717,0.22835),(0.68504,0.22835),(0.69291,0.22835),(0.70079,0.22835),(0.70866,0.22835),(0.71654,0.22835),(0.72441,0.22835),(0.73228,0.22835),(0.74016,0.22835),(0.74803,0.22835),(0.75591,0.22835),(0.76378,0.22835),(0.77165,0.22835),(0.77953,0.22835),(0.7874,0.22835),(0.79528,0.22835),(0.80315,0.22835),(0.81102,0.22835),(0.8189,0.22835),(0.82677,0.22835),(0.83465,0.22835),(0.84252,0.22835),(0.85039,0.22835),(0.85827,0.22835),(0.86614,0.22835),(0.87402,0.22835),(0.88189,0.22835),(0.88976,0.22835),(0.89764,0.22835),(0.90551,0.22835),(0.91339,0.22835),(0.92126,0.22835),(0.92913,0.22835),(0.93701,0.22835),(0.94488,0.22835),(0.95276,0.22835),(0.96063,0.22835),(0.9685,0.22835),(0.97638,0.22835),(0.98425,0.22835),(0.99213,0.22835),(0.99609,0.22835),(0.00391,0.23622),(0.00787,0.23622),(0.01575,0.23622),(0.02362,0.23622),(0.0315,0.23622),(0.03937,0.23622),(0.04724,0.23622),(0.05512,0.23622),(0.06299,0.23622),(0.07087,0.23622),(0.07874,0.23622),(0.08661,0.23622),(0.09449,0.23622),(0.10236,0.23622),(0.11024,0.23622),(0.11811,0.23622),(0.12598,0.23622),(0.13386,0.23622),(0.14173,0.23622),(0.14961,0.23622),(0.15748,0.23622),(0.16535,0.23622),(0.17323,0.23622),(0.1811,0.23622),(0.18898,0.23622),(0.19685,0.23622),(0.20472,0.23622),(0.2126,0.23622),(0.22047,0.23622),(0.22835,0.23622),(0.23622,0.23622),(0.24409,0.23622),(0.25197,0.23622),(0.25984,0.23622),(0.26772,0.23622),(0.27559,0.23622),(0.28346,0.23622),(0.29134,0.23622),(0.29921,0.23622),(0.30709,0.23622),(0.31496,0.23622),(0.32283,0.23622),(0.33071,0.23622),(0.33858,0.23622),(0.34646,0.23622),(0.35433,0.23622),(0.3622,0.23622),(0.37008,0.23622),(0.37795,0.23622),(0.38583,0.23622),(0.3937,0.23622),(0.40157,0.23622),(0.40945,0.23622),(0.41732,0.23622),(0.4252,0.23622),(0.43307,0.23622),(0.44094,0.23622),(0.44882,0.23622),(0.45669,0.23622),(0.46457,0.23622),(0.47244,0.23622),(0.48031,0.23622),(0.48819,0.23622),(0.49606,0.23622),(0.50394,0.23622),(0.51181,0.23622),(0.51969,0.23622),(0.52756,0.23622),(0.53543,0.23622),(0.54331,0.23622),(0.55118,0.23622),(0.55906,0.23622),(0.56693,0.23622),(0.5748,0.23622),(0.58268,0.23622),(0.59055,0.23622),(0.59843,0.23622),(0.6063,0.23622),(0.61417,0.23622),(0.62205,0.23622),(0.62992,0.23622),(0.6378,0.23622),(0.64567,0.23622),(0.65354,0.23622),(0.66142,0.23622),(0.66929,0.23622),(0.67717,0.23622),(0.68504,0.23622),(0.69291,0.23622),(0.70079,0.23622),(0.70866,0.23622),(0.71654,0.23622),(0.72441,0.23622),(0.73228,0.23622),(0.74016,0.23622),(0.74803,0.23622),(0.75591,0.23622),(0.76378,0.23622),(0.77165,0.23622),(0.77953,0.23622),(0.7874,0.23622),(0.79528,0.23622),(0.80315,0.23622),(0.81102,0.23622),(0.8189,0.23622),(0.82677,0.23622),(0.83465,0.23622),(0.84252,0.23622),(0.85039,0.23622),(0.85827,0.23622),(0.86614,0.23622),(0.87402,0.23622),(0.88189,0.23622),(0.88976,0.23622),(0.89764,0.23622),(0.90551,0.23622),(0.91339,0.23622),(0.92126,0.23622),(0.92913,0.23622),(0.93701,0.23622),(0.94488,0.23622),(0.95276,0.23622),(0.96063,0.23622),(0.9685,0.23622),(0.97638,0.23622),(0.98425,0.23622),(0.99213,0.23622),(0.99609,0.23622),(0.00391,0.24409),(0.00787,0.24409),(0.01575,0.24409),(0.02362,0.24409),(0.0315,0.24409),(0.03937,0.24409),(0.04724,0.24409),(0.05512,0.24409),(0.06299,0.24409),(0.07087,0.24409),(0.07874,0.24409),(0.08661,0.24409),(0.09449,0.24409),(0.10236,0.24409),(0.11024,0.24409),(0.11811,0.24409),(0.12598,0.24409),(0.13386,0.24409),(0.14173,0.24409),(0.14961,0.24409),(0.15748,0.24409),(0.16535,0.24409),(0.17323,0.24409),(0.1811,0.24409),(0.18898,0.24409),(0.19685,0.24409),(0.20472,0.24409),(0.2126,0.24409),(0.22047,0.24409),(0.22835,0.24409),(0.23622,0.24409),(0.24409,0.24409),(0.25197,0.24409),(0.25984,0.24409),(0.26772,0.24409),(0.27559,0.24409),(0.28346,0.24409),(0.29134,0.24409),(0.29921,0.24409),(0.30709,0.24409),(0.31496,0.24409),(0.32283,0.24409),(0.33071,0.24409),(0.33858,0.24409),(0.34646,0.24409),(0.35433,0.24409),(0.3622,0.24409),(0.37008,0.24409),(0.37795,0.24409),(0.38583,0.24409),(0.3937,0.24409),(0.40157,0.24409),(0.40945,0.24409),(0.41732,0.24409),(0.4252,0.24409),(0.43307,0.24409),(0.44094,0.24409),(0.44882,0.24409),(0.45669,0.24409),(0.46457,0.24409),(0.47244,0.24409),(0.48031,0.24409),(0.48819,0.24409),(0.49606,0.24409),(0.50394,0.24409),(0.51181,0.24409),(0.51969,0.24409),(0.52756,0.24409),(0.53543,0.24409),(0.54331,0.24409),(0.55118,0.24409),(0.55906,0.24409),(0.56693,0.24409),(0.5748,0.24409),(0.58268,0.24409),(0.59055,0.24409),(0.59843,0.24409),(0.6063,0.24409),(0.61417,0.24409),(0.62205,0.24409),(0.62992,0.24409),(0.6378,0.24409),(0.64567,0.24409),(0.65354,0.24409),(0.66142,0.24409),(0.66929,0.24409),(0.67717,0.24409),(0.68504,0.24409),(0.69291,0.24409),(0.70079,0.24409),(0.70866,0.24409),(0.71654,0.24409),(0.72441,0.24409),(0.73228,0.24409),(0.74016,0.24409),(0.74803,0.24409),(0.75591,0.24409),(0.76378,0.24409),(0.77165,0.24409),(0.77953,0.24409),(0.7874,0.24409),(0.79528,0.24409),(0.80315,0.24409),(0.81102,0.24409),(0.8189,0.24409),(0.82677,0.24409),(0.83465,0.24409),(0.84252,0.24409),(0.85039,0.24409),(0.85827,0.24409),(0.86614,0.24409),(0.87402,0.24409),(0.88189,0.24409),(0.88976,0.24409),(0.89764,0.24409),(0.90551,0.24409),(0.91339,0.24409),(0.92126,0.24409),(0.92913,0.24409),(0.93701,0.24409),(0.94488,0.24409),(0.95276,0.24409),(0.96063,0.24409),(0.9685,0.24409),(0.97638,0.24409),(0.98425,0.24409),(0.99213,0.24409),(0.99609,0.24409),(0.00391,0.25197),(0.00787,0.25197),(0.01575,0.25197),(0.02362,0.25197),(0.0315,0.25197),(0.03937,0.25197),(0.04724,0.25197),(0.05512,0.25197),(0.06299,0.25197),(0.07087,0.25197),(0.07874,0.25197),(0.08661,0.25197),(0.09449,0.25197),(0.10236,0.25197),(0.11024,0.25197),(0.11811,0.25197),(0.12598,0.25197),(0.13386,0.25197),(0.14173,0.25197),(0.14961,0.25197),(0.15748,0.25197),(0.16535,0.25197),(0.17323,0.25197),(0.1811,0.25197),(0.18898,0.25197),(0.19685,0.25197),(0.20472,0.25197),(0.2126,0.25197),(0.22047,0.25197),(0.22835,0.25197),(0.23622,0.25197),(0.24409,0.25197),(0.25197,0.25197),(0.25984,0.25197),(0.26772,0.25197),(0.27559,0.25197),(0.28346,0.25197),(0.29134,0.25197),(0.29921,0.25197),(0.30709,0.25197),(0.31496,0.25197),(0.32283,0.25197),(0.33071,0.25197),(0.33858,0.25197),(0.34646,0.25197),(0.35433,0.25197),(0.3622,0.25197),(0.37008,0.25197),(0.37795,0.25197),(0.38583,0.25197),(0.3937,0.25197),(0.40157,0.25197),(0.40945,0.25197),(0.41732,0.25197),(0.4252,0.25197),(0.43307,0.25197),(0.44094,0.25197),(0.44882,0.25197),(0.45669,0.25197),(0.46457,0.25197),(0.47244,0.25197),(0.48031,0.25197),(0.48819,0.25197),(0.49606,0.25197),(0.50394,0.25197),(0.51181,0.25197),(0.51969,0.25197),(0.52756,0.25197),(0.53543,0.25197),(0.54331,0.25197),(0.55118,0.25197),(0.55906,0.25197),(0.56693,0.25197),(0.5748,0.25197),(0.58268,0.25197),(0.59055,0.25197),(0.59843,0.25197),(0.6063,0.25197),(0.61417,0.25197),(0.62205,0.25197),(0.62992,0.25197),(0.6378,0.25197),(0.64567,0.25197),(0.65354,0.25197),(0.66142,0.25197),(0.66929,0.25197),(0.67717,0.25197),(0.68504,0.25197),(0.69291,0.25197),(0.70079,0.25197),(0.70866,0.25197),(0.71654,0.25197),(0.72441,0.25197),(0.73228,0.25197),(0.74016,0.25197),(0.74803,0.25197),(0.75591,0.25197),(0.76378,0.25197),(0.77165,0.25197),(0.77953,0.25197),(0.7874,0.25197),(0.79528,0.25197),(0.80315,0.25197),(0.81102,0.25197),(0.8189,0.25197),(0.82677,0.25197),(0.83465,0.25197),(0.84252,0.25197),(0.85039,0.25197),(0.85827,0.25197),(0.86614,0.25197),(0.87402,0.25197),(0.88189,0.25197),(0.88976,0.25197),(0.89764,0.25197),(0.90551,0.25197),(0.91339,0.25197),(0.92126,0.25197),(0.92913,0.25197),(0.93701,0.25197),(0.94488,0.25197),(0.95276,0.25197),(0.96063,0.25197),(0.9685,0.25197),(0.97638,0.25197),(0.98425,0.25197),(0.99213,0.25197),(0.99609,0.25197),(0.00391,0.25984),(0.00787,0.25984),(0.01575,0.25984),(0.02362,0.25984),(0.0315,0.25984),(0.03937,0.25984),(0.04724,0.25984),(0.05512,0.25984),(0.06299,0.25984),(0.07087,0.25984),(0.07874,0.25984),(0.08661,0.25984),(0.09449,0.25984),(0.10236,0.25984),(0.11024,0.25984),(0.11811,0.25984),(0.12598,0.25984),(0.13386,0.25984),(0.14173,0.25984),(0.14961,0.25984),(0.15748,0.25984),(0.16535,0.25984),(0.17323,0.25984),(0.1811,0.25984),(0.18898,0.25984),(0.19685,0.25984),(0.20472,0.25984),(0.2126,0.25984),(0.22047,0.25984),(0.22835,0.25984),(0.23622,0.25984),(0.24409,0.25984),(0.25197,0.25984),(0.25984,0.25984),(0.26772,0.25984),(0.27559,0.25984),(0.28346,0.25984),(0.29134,0.25984),(0.29921,0.25984),(0.30709,0.25984),(0.31496,0.25984),(0.32283,0.25984),(0.33071,0.25984),(0.33858,0.25984),(0.34646,0.25984),(0.35433,0.25984),(0.3622,0.25984),(0.37008,0.25984),(0.37795,0.25984),(0.38583,0.25984),(0.3937,0.25984),(0.40157,0.25984),(0.40945,0.25984),(0.41732,0.25984),(0.4252,0.25984),(0.43307,0.25984),(0.44094,0.25984),(0.44882,0.25984),(0.45669,0.25984),(0.46457,0.25984),(0.47244,0.25984),(0.48031,0.25984),(0.48819,0.25984),(0.49606,0.25984),(0.50394,0.25984),(0.51181,0.25984),(0.51969,0.25984),(0.52756,0.25984),(0.53543,0.25984),(0.54331,0.25984),(0.55118,0.25984),(0.55906,0.25984),(0.56693,0.25984),(0.5748,0.25984),(0.58268,0.25984),(0.59055,0.25984),(0.59843,0.25984),(0.6063,0.25984),(0.61417,0.25984),(0.62205,0.25984),(0.62992,0.25984),(0.6378,0.25984),(0.64567,0.25984),(0.65354,0.25984),(0.66142,0.25984),(0.66929,0.25984),(0.67717,0.25984),(0.68504,0.25984),(0.69291,0.25984),(0.70079,0.25984),(0.70866,0.25984),(0.71654,0.25984),(0.72441,0.25984),(0.73228,0.25984),(0.74016,0.25984),(0.74803,0.25984),(0.75591,0.25984),(0.76378,0.25984),(0.77165,0.25984),(0.77953,0.25984),(0.7874,0.25984),(0.79528,0.25984),(0.80315,0.25984),(0.81102,0.25984),(0.8189,0.25984),(0.82677,0.25984),(0.83465,0.25984),(0.84252,0.25984),(0.85039,0.25984),(0.85827,0.25984),(0.86614,0.25984),(0.87402,0.25984),(0.88189,0.25984),(0.88976,0.25984),(0.89764,0.25984),(0.90551,0.25984),(0.91339,0.25984),(0.92126,0.25984),(0.92913,0.25984),(0.93701,0.25984),(0.94488,0.25984),(0.95276,0.25984),(0.96063,0.25984),(0.9685,0.25984),(0.97638,0.25984),(0.98425,0.25984),(0.99213,0.25984),(0.99609,0.25984),(0.00391,0.26772),(0.00787,0.26772),(0.01575,0.26772),(0.02362,0.26772),(0.0315,0.26772),(0.03937,0.26772),(0.04724,0.26772),(0.05512,0.26772),(0.06299,0.26772),(0.07087,0.26772),(0.07874,0.26772),(0.08661,0.26772),(0.09449,0.26772),(0.10236,0.26772),(0.11024,0.26772),(0.11811,0.26772),(0.12598,0.26772),(0.13386,0.26772),(0.14173,0.26772),(0.14961,0.26772),(0.15748,0.26772),(0.16535,0.26772),(0.17323,0.26772),(0.1811,0.26772),(0.18898,0.26772),(0.19685,0.26772),(0.20472,0.26772),(0.2126,0.26772),(0.22047,0.26772),(0.22835,0.26772),(0.23622,0.26772),(0.24409,0.26772),(0.25197,0.26772),(0.25984,0.26772),(0.26772,0.26772),(0.27559,0.26772),(0.28346,0.26772),(0.29134,0.26772),(0.29921,0.26772),(0.30709,0.26772),(0.31496,0.26772),(0.32283,0.26772),(0.33071,0.26772),(0.33858,0.26772),(0.34646,0.26772),(0.35433,0.26772),(0.3622,0.26772),(0.37008,0.26772),(0.37795,0.26772),(0.38583,0.26772),(0.3937,0.26772),(0.40157,0.26772),(0.40945,0.26772),(0.41732,0.26772),(0.4252,0.26772),(0.43307,0.26772),(0.44094,0.26772),(0.44882,0.26772),(0.45669,0.26772),(0.46457,0.26772),(0.47244,0.26772),(0.48031,0.26772),(0.48819,0.26772),(0.49606,0.26772),(0.50394,0.26772),(0.51181,0.26772),(0.51969,0.26772),(0.52756,0.26772),(0.53543,0.26772),(0.54331,0.26772),(0.55118,0.26772),(0.55906,0.26772),(0.56693,0.26772),(0.5748,0.26772),(0.58268,0.26772),(0.59055,0.26772),(0.59843,0.26772),(0.6063,0.26772),(0.61417,0.26772),(0.62205,0.26772),(0.62992,0.26772),(0.6378,0.26772),(0.64567,0.26772),(0.65354,0.26772),(0.66142,0.26772),(0.66929,0.26772),(0.67717,0.26772),(0.68504,0.26772),(0.69291,0.26772),(0.70079,0.26772),(0.70866,0.26772),(0.71654,0.26772),(0.72441,0.26772),(0.73228,0.26772),(0.74016,0.26772),(0.74803,0.26772),(0.75591,0.26772),(0.76378,0.26772),(0.77165,0.26772),(0.77953,0.26772),(0.7874,0.26772),(0.79528,0.26772),(0.80315,0.26772),(0.81102,0.26772),(0.8189,0.26772),(0.82677,0.26772),(0.83465,0.26772),(0.84252,0.26772),(0.85039,0.26772),(0.85827,0.26772),(0.86614,0.26772),(0.87402,0.26772),(0.88189,0.26772),(0.88976,0.26772),(0.89764,0.26772),(0.90551,0.26772),(0.91339,0.26772),(0.92126,0.26772),(0.92913,0.26772),(0.93701,0.26772),(0.94488,0.26772),(0.95276,0.26772),(0.96063,0.26772),(0.9685,0.26772),(0.97638,0.26772),(0.98425,0.26772),(0.99213,0.26772),(0.99609,0.26772),(0.00391,0.27559),(0.00787,0.27559),(0.01575,0.27559),(0.02362,0.27559),(0.0315,0.27559),(0.03937,0.27559),(0.04724,0.27559),(0.05512,0.27559),(0.06299,0.27559),(0.07087,0.27559),(0.07874,0.27559),(0.08661,0.27559),(0.09449,0.27559),(0.10236,0.27559),(0.11024,0.27559),(0.11811,0.27559),(0.12598,0.27559),(0.13386,0.27559),(0.14173,0.27559),(0.14961,0.27559),(0.15748,0.27559),(0.16535,0.27559),(0.17323,0.27559),(0.1811,0.27559),(0.18898,0.27559),(0.19685,0.27559),(0.20472,0.27559),(0.2126,0.27559),(0.22047,0.27559),(0.22835,0.27559),(0.23622,0.27559),(0.24409,0.27559),(0.25197,0.27559),(0.25984,0.27559),(0.26772,0.27559),(0.27559,0.27559),(0.28346,0.27559),(0.29134,0.27559),(0.29921,0.27559),(0.30709,0.27559),(0.31496,0.27559),(0.32283,0.27559),(0.33071,0.27559),(0.33858,0.27559),(0.34646,0.27559),(0.35433,0.27559),(0.3622,0.27559),(0.37008,0.27559),(0.37795,0.27559),(0.38583,0.27559),(0.3937,0.27559),(0.40157,0.27559),(0.40945,0.27559),(0.41732,0.27559),(0.4252,0.27559),(0.43307,0.27559),(0.44094,0.27559),(0.44882,0.27559),(0.45669,0.27559),(0.46457,0.27559),(0.47244,0.27559),(0.48031,0.27559),(0.48819,0.27559),(0.49606,0.27559),(0.50394,0.27559),(0.51181,0.27559),(0.51969,0.27559),(0.52756,0.27559),(0.53543,0.27559),(0.54331,0.27559),(0.55118,0.27559),(0.55906,0.27559),(0.56693,0.27559),(0.5748,0.27559),(0.58268,0.27559),(0.59055,0.27559),(0.59843,0.27559),(0.6063,0.27559),(0.61417,0.27559),(0.62205,0.27559),(0.62992,0.27559),(0.6378,0.27559),(0.64567,0.27559),(0.65354,0.27559),(0.66142,0.27559),(0.66929,0.27559),(0.67717,0.27559),(0.68504,0.27559),(0.69291,0.27559),(0.70079,0.27559),(0.70866,0.27559),(0.71654,0.27559),(0.72441,0.27559),(0.73228,0.27559),(0.74016,0.27559),(0.74803,0.27559),(0.75591,0.27559),(0.76378,0.27559),(0.77165,0.27559),(0.77953,0.27559),(0.7874,0.27559),(0.79528,0.27559),(0.80315,0.27559),(0.81102,0.27559),(0.8189,0.27559),(0.82677,0.27559),(0.83465,0.27559),(0.84252,0.27559),(0.85039,0.27559),(0.85827,0.27559),(0.86614,0.27559),(0.87402,0.27559),(0.88189,0.27559),(0.88976,0.27559),(0.89764,0.27559),(0.90551,0.27559),(0.91339,0.27559),(0.92126,0.27559),(0.92913,0.27559),(0.93701,0.27559),(0.94488,0.27559),(0.95276,0.27559),(0.96063,0.27559),(0.9685,0.27559),(0.97638,0.27559),(0.98425,0.27559),(0.99213,0.27559),(0.99609,0.27559),(0.00391,0.28346),(0.00787,0.28346),(0.01575,0.28346),(0.02362,0.28346),(0.0315,0.28346),(0.03937,0.28346),(0.04724,0.28346),(0.05512,0.28346),(0.06299,0.28346),(0.07087,0.28346),(0.07874,0.28346),(0.08661,0.28346),(0.09449,0.28346),(0.10236,0.28346),(0.11024,0.28346),(0.11811,0.28346),(0.12598,0.28346),(0.13386,0.28346),(0.14173,0.28346),(0.14961,0.28346),(0.15748,0.28346),(0.16535,0.28346),(0.17323,0.28346),(0.1811,0.28346),(0.18898,0.28346),(0.19685,0.28346),(0.20472,0.28346),(0.2126,0.28346),(0.22047,0.28346),(0.22835,0.28346),(0.23622,0.28346),(0.24409,0.28346),(0.25197,0.28346),(0.25984,0.28346),(0.26772,0.28346),(0.27559,0.28346),(0.28346,0.28346),(0.29134,0.28346),(0.29921,0.28346),(0.30709,0.28346),(0.31496,0.28346),(0.32283,0.28346),(0.33071,0.28346),(0.33858,0.28346),(0.34646,0.28346),(0.35433,0.28346),(0.3622,0.28346),(0.37008,0.28346),(0.37795,0.28346),(0.38583,0.28346),(0.3937,0.28346),(0.40157,0.28346),(0.40945,0.28346),(0.41732,0.28346),(0.4252,0.28346),(0.43307,0.28346),(0.44094,0.28346),(0.44882,0.28346),(0.45669,0.28346),(0.46457,0.28346),(0.47244,0.28346),(0.48031,0.28346),(0.48819,0.28346),(0.49606,0.28346),(0.50394,0.28346),(0.51181,0.28346),(0.51969,0.28346),(0.52756,0.28346),(0.53543,0.28346),(0.54331,0.28346),(0.55118,0.28346),(0.55906,0.28346),(0.56693,0.28346),(0.5748,0.28346),(0.58268,0.28346),(0.59055,0.28346),(0.59843,0.28346),(0.6063,0.28346),(0.61417,0.28346),(0.62205,0.28346),(0.62992,0.28346),(0.6378,0.28346),(0.64567,0.28346),(0.65354,0.28346),(0.66142,0.28346),(0.66929,0.28346),(0.67717,0.28346),(0.68504,0.28346),(0.69291,0.28346),(0.70079,0.28346),(0.70866,0.28346),(0.71654,0.28346),(0.72441,0.28346),(0.73228,0.28346),(0.74016,0.28346),(0.74803,0.28346),(0.75591,0.28346),(0.76378,0.28346),(0.77165,0.28346),(0.77953,0.28346),(0.7874,0.28346),(0.79528,0.28346),(0.80315,0.28346),(0.81102,0.28346),(0.8189,0.28346),(0.82677,0.28346),(0.83465,0.28346),(0.84252,0.28346),(0.85039,0.28346),(0.85827,0.28346),(0.86614,0.28346),(0.87402,0.28346),(0.88189,0.28346),(0.88976,0.28346),(0.89764,0.28346),(0.90551,0.28346),(0.91339,0.28346),(0.92126,0.28346),(0.92913,0.28346),(0.93701,0.28346),(0.94488,0.28346),(0.95276,0.28346),(0.96063,0.28346),(0.9685,0.28346),(0.97638,0.28346),(0.98425,0.28346),(0.99213,0.28346),(0.99609,0.28346),(0.00391,0.29134),(0.00787,0.29134),(0.01575,0.29134),(0.02362,0.29134),(0.0315,0.29134),(0.03937,0.29134),(0.04724,0.29134),(0.05512,0.29134),(0.06299,0.29134),(0.07087,0.29134),(0.07874,0.29134),(0.08661,0.29134),(0.09449,0.29134),(0.10236,0.29134),(0.11024,0.29134),(0.11811,0.29134),(0.12598,0.29134),(0.13386,0.29134),(0.14173,0.29134),(0.14961,0.29134),(0.15748,0.29134),(0.16535,0.29134),(0.17323,0.29134),(0.1811,0.29134),(0.18898,0.29134),(0.19685,0.29134),(0.20472,0.29134),(0.2126,0.29134),(0.22047,0.29134),(0.22835,0.29134),(0.23622,0.29134),(0.24409,0.29134),(0.25197,0.29134),(0.25984,0.29134),(0.26772,0.29134),(0.27559,0.29134),(0.28346,0.29134),(0.29134,0.29134),(0.29921,0.29134),(0.30709,0.29134),(0.31496,0.29134),(0.32283,0.29134),(0.33071,0.29134),(0.33858,0.29134),(0.34646,0.29134),(0.35433,0.29134),(0.3622,0.29134),(0.37008,0.29134),(0.37795,0.29134),(0.38583,0.29134),(0.3937,0.29134),(0.40157,0.29134),(0.40945,0.29134),(0.41732,0.29134),(0.4252,0.29134),(0.43307,0.29134),(0.44094,0.29134),(0.44882,0.29134),(0.45669,0.29134),(0.46457,0.29134),(0.47244,0.29134),(0.48031,0.29134),(0.48819,0.29134),(0.49606,0.29134),(0.50394,0.29134),(0.51181,0.29134),(0.51969,0.29134),(0.52756,0.29134),(0.53543,0.29134),(0.54331,0.29134),(0.55118,0.29134),(0.55906,0.29134),(0.56693,0.29134),(0.5748,0.29134),(0.58268,0.29134),(0.59055,0.29134),(0.59843,0.29134),(0.6063,0.29134),(0.61417,0.29134),(0.62205,0.29134),(0.62992,0.29134),(0.6378,0.29134),(0.64567,0.29134),(0.65354,0.29134),(0.66142,0.29134),(0.66929,0.29134),(0.67717,0.29134),(0.68504,0.29134),(0.69291,0.29134),(0.70079,0.29134),(0.70866,0.29134),(0.71654,0.29134),(0.72441,0.29134),(0.73228,0.29134),(0.74016,0.29134),(0.74803,0.29134),(0.75591,0.29134),(0.76378,0.29134),(0.77165,0.29134),(0.77953,0.29134),(0.7874,0.29134),(0.79528,0.29134),(0.80315,0.29134),(0.81102,0.29134),(0.8189,0.29134),(0.82677,0.29134),(0.83465,0.29134),(0.84252,0.29134),(0.85039,0.29134),(0.85827,0.29134),(0.86614,0.29134),(0.87402,0.29134),(0.88189,0.29134),(0.88976,0.29134),(0.89764,0.29134),(0.90551,0.29134),(0.91339,0.29134),(0.92126,0.29134),(0.92913,0.29134),(0.93701,0.29134),(0.94488,0.29134),(0.95276,0.29134),(0.96063,0.29134),(0.9685,0.29134),(0.97638,0.29134),(0.98425,0.29134),(0.99213,0.29134),(0.99609,0.29134),(0.00391,0.29921),(0.00787,0.29921),(0.01575,0.29921),(0.02362,0.29921),(0.0315,0.29921),(0.03937,0.29921),(0.04724,0.29921),(0.05512,0.29921),(0.06299,0.29921),(0.07087,0.29921),(0.07874,0.29921),(0.08661,0.29921),(0.09449,0.29921),(0.10236,0.29921),(0.11024,0.29921),(0.11811,0.29921),(0.12598,0.29921),(0.13386,0.29921),(0.14173,0.29921),(0.14961,0.29921),(0.15748,0.29921),(0.16535,0.29921),(0.17323,0.29921),(0.1811,0.29921),(0.18898,0.29921),(0.19685,0.29921),(0.20472,0.29921),(0.2126,0.29921),(0.22047,0.29921),(0.22835,0.29921),(0.23622,0.29921),(0.24409,0.29921),(0.25197,0.29921),(0.25984,0.29921),(0.26772,0.29921),(0.27559,0.29921),(0.28346,0.29921),(0.29134,0.29921),(0.29921,0.29921),(0.30709,0.29921),(0.31496,0.29921),(0.32283,0.29921),(0.33071,0.29921),(0.33858,0.29921),(0.34646,0.29921),(0.35433,0.29921),(0.3622,0.29921),(0.37008,0.29921),(0.37795,0.29921),(0.38583,0.29921),(0.3937,0.29921),(0.40157,0.29921),(0.40945,0.29921),(0.41732,0.29921),(0.4252,0.29921),(0.43307,0.29921),(0.44094,0.29921),(0.44882,0.29921),(0.45669,0.29921),(0.46457,0.29921),(0.47244,0.29921),(0.48031,0.29921),(0.48819,0.29921),(0.49606,0.29921),(0.50394,0.29921),(0.51181,0.29921),(0.51969,0.29921),(0.52756,0.29921),(0.53543,0.29921),(0.54331,0.29921),(0.55118,0.29921),(0.55906,0.29921),(0.56693,0.29921),(0.5748,0.29921),(0.58268,0.29921),(0.59055,0.29921),(0.59843,0.29921),(0.6063,0.29921),(0.61417,0.29921),(0.62205,0.29921),(0.62992,0.29921),(0.6378,0.29921),(0.64567,0.29921),(0.65354,0.29921),(0.66142,0.29921),(0.66929,0.29921),(0.67717,0.29921),(0.68504,0.29921),(0.69291,0.29921),(0.70079,0.29921),(0.70866,0.29921),(0.71654,0.29921),(0.72441,0.29921),(0.73228,0.29921),(0.74016,0.29921),(0.74803,0.29921),(0.75591,0.29921),(0.76378,0.29921),(0.77165,0.29921),(0.77953,0.29921),(0.7874,0.29921),(0.79528,0.29921),(0.80315,0.29921),(0.81102,0.29921),(0.8189,0.29921),(0.82677,0.29921),(0.83465,0.29921),(0.84252,0.29921),(0.85039,0.29921),(0.85827,0.29921),(0.86614,0.29921),(0.87402,0.29921),(0.88189,0.29921),(0.88976,0.29921),(0.89764,0.29921),(0.90551,0.29921),(0.91339,0.29921),(0.92126,0.29921),(0.92913,0.29921),(0.93701,0.29921),(0.94488,0.29921),(0.95276,0.29921),(0.96063,0.29921),(0.9685,0.29921),(0.97638,0.29921),(0.98425,0.29921),(0.99213,0.29921),(0.99609,0.29921),(0.00391,0.30709),(0.00787,0.30709),(0.01575,0.30709),(0.02362,0.30709),(0.0315,0.30709),(0.03937,0.30709),(0.04724,0.30709),(0.05512,0.30709),(0.06299,0.30709),(0.07087,0.30709),(0.07874,0.30709),(0.08661,0.30709),(0.09449,0.30709),(0.10236,0.30709),(0.11024,0.30709),(0.11811,0.30709),(0.12598,0.30709),(0.13386,0.30709),(0.14173,0.30709),(0.14961,0.30709),(0.15748,0.30709),(0.16535,0.30709),(0.17323,0.30709),(0.1811,0.30709),(0.18898,0.30709),(0.19685,0.30709),(0.20472,0.30709),(0.2126,0.30709),(0.22047,0.30709),(0.22835,0.30709),(0.23622,0.30709),(0.24409,0.30709),(0.25197,0.30709),(0.25984,0.30709),(0.26772,0.30709),(0.27559,0.30709),(0.28346,0.30709),(0.29134,0.30709),(0.29921,0.30709),(0.30709,0.30709),(0.31496,0.30709),(0.32283,0.30709),(0.33071,0.30709),(0.33858,0.30709),(0.34646,0.30709),(0.35433,0.30709),(0.3622,0.30709),(0.37008,0.30709),(0.37795,0.30709),(0.38583,0.30709),(0.3937,0.30709),(0.40157,0.30709),(0.40945,0.30709),(0.41732,0.30709),(0.4252,0.30709),(0.43307,0.30709),(0.44094,0.30709),(0.44882,0.30709),(0.45669,0.30709),(0.46457,0.30709),(0.47244,0.30709),(0.48031,0.30709),(0.48819,0.30709),(0.49606,0.30709),(0.50394,0.30709),(0.51181,0.30709),(0.51969,0.30709),(0.52756,0.30709),(0.53543,0.30709),(0.54331,0.30709),(0.55118,0.30709),(0.55906,0.30709),(0.56693,0.30709),(0.5748,0.30709),(0.58268,0.30709),(0.59055,0.30709),(0.59843,0.30709),(0.6063,0.30709),(0.61417,0.30709),(0.62205,0.30709),(0.62992,0.30709),(0.6378,0.30709),(0.64567,0.30709),(0.65354,0.30709),(0.66142,0.30709),(0.66929,0.30709),(0.67717,0.30709),(0.68504,0.30709),(0.69291,0.30709),(0.70079,0.30709),(0.70866,0.30709),(0.71654,0.30709),(0.72441,0.30709),(0.73228,0.30709),(0.74016,0.30709),(0.74803,0.30709),(0.75591,0.30709),(0.76378,0.30709),(0.77165,0.30709),(0.77953,0.30709),(0.7874,0.30709),(0.79528,0.30709),(0.80315,0.30709),(0.81102,0.30709),(0.8189,0.30709),(0.82677,0.30709),(0.83465,0.30709),(0.84252,0.30709),(0.85039,0.30709),(0.85827,0.30709),(0.86614,0.30709),(0.87402,0.30709),(0.88189,0.30709),(0.88976,0.30709),(0.89764,0.30709),(0.90551,0.30709),(0.91339,0.30709),(0.92126,0.30709),(0.92913,0.30709),(0.93701,0.30709),(0.94488,0.30709),(0.95276,0.30709),(0.96063,0.30709),(0.9685,0.30709),(0.97638,0.30709),(0.98425,0.30709),(0.99213,0.30709),(0.99609,0.30709),(0.00391,0.31496),(0.00787,0.31496),(0.01575,0.31496),(0.02362,0.31496),(0.0315,0.31496),(0.03937,0.31496),(0.04724,0.31496),(0.05512,0.31496),(0.06299,0.31496),(0.07087,0.31496),(0.07874,0.31496),(0.08661,0.31496),(0.09449,0.31496),(0.10236,0.31496),(0.11024,0.31496),(0.11811,0.31496),(0.12598,0.31496),(0.13386,0.31496),(0.14173,0.31496),(0.14961,0.31496),(0.15748,0.31496),(0.16535,0.31496),(0.17323,0.31496),(0.1811,0.31496),(0.18898,0.31496),(0.19685,0.31496),(0.20472,0.31496),(0.2126,0.31496),(0.22047,0.31496),(0.22835,0.31496),(0.23622,0.31496),(0.24409,0.31496),(0.25197,0.31496),(0.25984,0.31496),(0.26772,0.31496),(0.27559,0.31496),(0.28346,0.31496),(0.29134,0.31496),(0.29921,0.31496),(0.30709,0.31496),(0.31496,0.31496),(0.32283,0.31496),(0.33071,0.31496),(0.33858,0.31496),(0.34646,0.31496),(0.35433,0.31496),(0.3622,0.31496),(0.37008,0.31496),(0.37795,0.31496),(0.38583,0.31496),(0.3937,0.31496),(0.40157,0.31496),(0.40945,0.31496),(0.41732,0.31496),(0.4252,0.31496),(0.43307,0.31496),(0.44094,0.31496),(0.44882,0.31496),(0.45669,0.31496),(0.46457,0.31496),(0.47244,0.31496),(0.48031,0.31496),(0.48819,0.31496),(0.49606,0.31496),(0.50394,0.31496),(0.51181,0.31496),(0.51969,0.31496),(0.52756,0.31496),(0.53543,0.31496),(0.54331,0.31496),(0.55118,0.31496),(0.55906,0.31496),(0.56693,0.31496),(0.5748,0.31496),(0.58268,0.31496),(0.59055,0.31496),(0.59843,0.31496),(0.6063,0.31496),(0.61417,0.31496),(0.62205,0.31496),(0.62992,0.31496),(0.6378,0.31496),(0.64567,0.31496),(0.65354,0.31496),(0.66142,0.31496),(0.66929,0.31496),(0.67717,0.31496),(0.68504,0.31496),(0.69291,0.31496),(0.70079,0.31496),(0.70866,0.31496),(0.71654,0.31496),(0.72441,0.31496),(0.73228,0.31496),(0.74016,0.31496),(0.74803,0.31496),(0.75591,0.31496),(0.76378,0.31496),(0.77165,0.31496),(0.77953,0.31496),(0.7874,0.31496),(0.79528,0.31496),(0.80315,0.31496),(0.81102,0.31496),(0.8189,0.31496),(0.82677,0.31496),(0.83465,0.31496),(0.84252,0.31496),(0.85039,0.31496),(0.85827,0.31496),(0.86614,0.31496),(0.87402,0.31496),(0.88189,0.31496),(0.88976,0.31496),(0.89764,0.31496),(0.90551,0.31496),(0.91339,0.31496),(0.92126,0.31496),(0.92913,0.31496),(0.93701,0.31496),(0.94488,0.31496),(0.95276,0.31496),(0.96063,0.31496),(0.9685,0.31496),(0.97638,0.31496),(0.98425,0.31496),(0.99213,0.31496),(0.99609,0.31496),(0.00391,0.32283),(0.00787,0.32283),(0.01575,0.32283),(0.02362,0.32283),(0.0315,0.32283),(0.03937,0.32283),(0.04724,0.32283),(0.05512,0.32283),(0.06299,0.32283),(0.07087,0.32283),(0.07874,0.32283),(0.08661,0.32283),(0.09449,0.32283),(0.10236,0.32283),(0.11024,0.32283),(0.11811,0.32283),(0.12598,0.32283),(0.13386,0.32283),(0.14173,0.32283),(0.14961,0.32283),(0.15748,0.32283),(0.16535,0.32283),(0.17323,0.32283),(0.1811,0.32283),(0.18898,0.32283),(0.19685,0.32283),(0.20472,0.32283),(0.2126,0.32283),(0.22047,0.32283),(0.22835,0.32283),(0.23622,0.32283),(0.24409,0.32283),(0.25197,0.32283),(0.25984,0.32283),(0.26772,0.32283),(0.27559,0.32283),(0.28346,0.32283),(0.29134,0.32283),(0.29921,0.32283),(0.30709,0.32283),(0.31496,0.32283),(0.32283,0.32283),(0.33071,0.32283),(0.33858,0.32283),(0.34646,0.32283),(0.35433,0.32283),(0.3622,0.32283),(0.37008,0.32283),(0.37795,0.32283),(0.38583,0.32283),(0.3937,0.32283),(0.40157,0.32283),(0.40945,0.32283),(0.41732,0.32283),(0.4252,0.32283),(0.43307,0.32283),(0.44094,0.32283),(0.44882,0.32283),(0.45669,0.32283),(0.46457,0.32283),(0.47244,0.32283),(0.48031,0.32283),(0.48819,0.32283),(0.49606,0.32283),(0.50394,0.32283),(0.51181,0.32283),(0.51969,0.32283),(0.52756,0.32283),(0.53543,0.32283),(0.54331,0.32283),(0.55118,0.32283),(0.55906,0.32283),(0.56693,0.32283),(0.5748,0.32283),(0.58268,0.32283),(0.59055,0.32283),(0.59843,0.32283),(0.6063,0.32283),(0.61417,0.32283),(0.62205,0.32283),(0.62992,0.32283),(0.6378,0.32283),(0.64567,0.32283),(0.65354,0.32283),(0.66142,0.32283),(0.66929,0.32283),(0.67717,0.32283),(0.68504,0.32283),(0.69291,0.32283),(0.70079,0.32283),(0.70866,0.32283),(0.71654,0.32283),(0.72441,0.32283),(0.73228,0.32283),(0.74016,0.32283),(0.74803,0.32283),(0.75591,0.32283),(0.76378,0.32283),(0.77165,0.32283),(0.77953,0.32283),(0.7874,0.32283),(0.79528,0.32283),(0.80315,0.32283),(0.81102,0.32283),(0.8189,0.32283),(0.82677,0.32283),(0.83465,0.32283),(0.84252,0.32283),(0.85039,0.32283),(0.85827,0.32283),(0.86614,0.32283),(0.87402,0.32283),(0.88189,0.32283),(0.88976,0.32283),(0.89764,0.32283),(0.90551,0.32283),(0.91339,0.32283),(0.92126,0.32283),(0.92913,0.32283),(0.93701,0.32283),(0.94488,0.32283),(0.95276,0.32283),(0.96063,0.32283),(0.9685,0.32283),(0.97638,0.32283),(0.98425,0.32283),(0.99213,0.32283),(0.99609,0.32283),(0.00391,0.33071),(0.00787,0.33071),(0.01575,0.33071),(0.02362,0.33071),(0.0315,0.33071),(0.03937,0.33071),(0.04724,0.33071),(0.05512,0.33071),(0.06299,0.33071),(0.07087,0.33071),(0.07874,0.33071),(0.08661,0.33071),(0.09449,0.33071),(0.10236,0.33071),(0.11024,0.33071),(0.11811,0.33071),(0.12598,0.33071),(0.13386,0.33071),(0.14173,0.33071),(0.14961,0.33071),(0.15748,0.33071),(0.16535,0.33071),(0.17323,0.33071),(0.1811,0.33071),(0.18898,0.33071),(0.19685,0.33071),(0.20472,0.33071),(0.2126,0.33071),(0.22047,0.33071),(0.22835,0.33071),(0.23622,0.33071),(0.24409,0.33071),(0.25197,0.33071),(0.25984,0.33071),(0.26772,0.33071),(0.27559,0.33071),(0.28346,0.33071),(0.29134,0.33071),(0.29921,0.33071),(0.30709,0.33071),(0.31496,0.33071),(0.32283,0.33071),(0.33071,0.33071),(0.33858,0.33071),(0.34646,0.33071),(0.35433,0.33071),(0.3622,0.33071),(0.37008,0.33071),(0.37795,0.33071),(0.38583,0.33071),(0.3937,0.33071),(0.40157,0.33071),(0.40945,0.33071),(0.41732,0.33071),(0.4252,0.33071),(0.43307,0.33071),(0.44094,0.33071),(0.44882,0.33071),(0.45669,0.33071),(0.46457,0.33071),(0.47244,0.33071),(0.48031,0.33071),(0.48819,0.33071),(0.49606,0.33071),(0.50394,0.33071),(0.51181,0.33071),(0.51969,0.33071),(0.52756,0.33071),(0.53543,0.33071),(0.54331,0.33071),(0.55118,0.33071),(0.55906,0.33071),(0.56693,0.33071),(0.5748,0.33071),(0.58268,0.33071),(0.59055,0.33071),(0.59843,0.33071),(0.6063,0.33071),(0.61417,0.33071),(0.62205,0.33071),(0.62992,0.33071),(0.6378,0.33071),(0.64567,0.33071),(0.65354,0.33071),(0.66142,0.33071),(0.66929,0.33071),(0.67717,0.33071),(0.68504,0.33071),(0.69291,0.33071),(0.70079,0.33071),(0.70866,0.33071),(0.71654,0.33071),(0.72441,0.33071),(0.73228,0.33071),(0.74016,0.33071),(0.74803,0.33071),(0.75591,0.33071),(0.76378,0.33071),(0.77165,0.33071),(0.77953,0.33071),(0.7874,0.33071),(0.79528,0.33071),(0.80315,0.33071),(0.81102,0.33071),(0.8189,0.33071),(0.82677,0.33071),(0.83465,0.33071),(0.84252,0.33071),(0.85039,0.33071),(0.85827,0.33071),(0.86614,0.33071),(0.87402,0.33071),(0.88189,0.33071),(0.88976,0.33071),(0.89764,0.33071),(0.90551,0.33071),(0.91339,0.33071),(0.92126,0.33071),(0.92913,0.33071),(0.93701,0.33071),(0.94488,0.33071),(0.95276,0.33071),(0.96063,0.33071),(0.9685,0.33071),(0.97638,0.33071),(0.98425,0.33071),(0.99213,0.33071),(0.99609,0.33071),(0.00391,0.33858),(0.00787,0.33858),(0.01575,0.33858),(0.02362,0.33858),(0.0315,0.33858),(0.03937,0.33858),(0.04724,0.33858),(0.05512,0.33858),(0.06299,0.33858),(0.07087,0.33858),(0.07874,0.33858),(0.08661,0.33858),(0.09449,0.33858),(0.10236,0.33858),(0.11024,0.33858),(0.11811,0.33858),(0.12598,0.33858),(0.13386,0.33858),(0.14173,0.33858),(0.14961,0.33858),(0.15748,0.33858),(0.16535,0.33858),(0.17323,0.33858),(0.1811,0.33858),(0.18898,0.33858),(0.19685,0.33858),(0.20472,0.33858),(0.2126,0.33858),(0.22047,0.33858),(0.22835,0.33858),(0.23622,0.33858),(0.24409,0.33858),(0.25197,0.33858),(0.25984,0.33858),(0.26772,0.33858),(0.27559,0.33858),(0.28346,0.33858),(0.29134,0.33858),(0.29921,0.33858),(0.30709,0.33858),(0.31496,0.33858),(0.32283,0.33858),(0.33071,0.33858),(0.33858,0.33858),(0.34646,0.33858),(0.35433,0.33858),(0.3622,0.33858),(0.37008,0.33858),(0.37795,0.33858),(0.38583,0.33858),(0.3937,0.33858),(0.40157,0.33858),(0.40945,0.33858),(0.41732,0.33858),(0.4252,0.33858),(0.43307,0.33858),(0.44094,0.33858),(0.44882,0.33858),(0.45669,0.33858),(0.46457,0.33858),(0.47244,0.33858),(0.48031,0.33858),(0.48819,0.33858),(0.49606,0.33858),(0.50394,0.33858),(0.51181,0.33858),(0.51969,0.33858),(0.52756,0.33858),(0.53543,0.33858),(0.54331,0.33858),(0.55118,0.33858),(0.55906,0.33858),(0.56693,0.33858),(0.5748,0.33858),(0.58268,0.33858),(0.59055,0.33858),(0.59843,0.33858),(0.6063,0.33858),(0.61417,0.33858),(0.62205,0.33858),(0.62992,0.33858),(0.6378,0.33858),(0.64567,0.33858),(0.65354,0.33858),(0.66142,0.33858),(0.66929,0.33858),(0.67717,0.33858),(0.68504,0.33858),(0.69291,0.33858),(0.70079,0.33858),(0.70866,0.33858),(0.71654,0.33858),(0.72441,0.33858),(0.73228,0.33858),(0.74016,0.33858),(0.74803,0.33858),(0.75591,0.33858),(0.76378,0.33858),(0.77165,0.33858),(0.77953,0.33858),(0.7874,0.33858),(0.79528,0.33858),(0.80315,0.33858),(0.81102,0.33858),(0.8189,0.33858),(0.82677,0.33858),(0.83465,0.33858),(0.84252,0.33858),(0.85039,0.33858),(0.85827,0.33858),(0.86614,0.33858),(0.87402,0.33858),(0.88189,0.33858),(0.88976,0.33858),(0.89764,0.33858),(0.90551,0.33858),(0.91339,0.33858),(0.92126,0.33858),(0.92913,0.33858),(0.93701,0.33858),(0.94488,0.33858),(0.95276,0.33858),(0.96063,0.33858),(0.9685,0.33858),(0.97638,0.33858),(0.98425,0.33858),(0.99213,0.33858),(0.99609,0.33858),(0.00391,0.34646),(0.00787,0.34646),(0.01575,0.34646),(0.02362,0.34646),(0.0315,0.34646),(0.03937,0.34646),(0.04724,0.34646),(0.05512,0.34646),(0.06299,0.34646),(0.07087,0.34646),(0.07874,0.34646),(0.08661,0.34646),(0.09449,0.34646),(0.10236,0.34646),(0.11024,0.34646),(0.11811,0.34646),(0.12598,0.34646),(0.13386,0.34646),(0.14173,0.34646),(0.14961,0.34646),(0.15748,0.34646),(0.16535,0.34646),(0.17323,0.34646),(0.1811,0.34646),(0.18898,0.34646),(0.19685,0.34646),(0.20472,0.34646),(0.2126,0.34646),(0.22047,0.34646),(0.22835,0.34646),(0.23622,0.34646),(0.24409,0.34646),(0.25197,0.34646),(0.25984,0.34646),(0.26772,0.34646),(0.27559,0.34646),(0.28346,0.34646),(0.29134,0.34646),(0.29921,0.34646),(0.30709,0.34646),(0.31496,0.34646),(0.32283,0.34646),(0.33071,0.34646),(0.33858,0.34646),(0.34646,0.34646),(0.35433,0.34646),(0.3622,0.34646),(0.37008,0.34646),(0.37795,0.34646),(0.38583,0.34646),(0.3937,0.34646),(0.40157,0.34646),(0.40945,0.34646),(0.41732,0.34646),(0.4252,0.34646),(0.43307,0.34646),(0.44094,0.34646),(0.44882,0.34646),(0.45669,0.34646),(0.46457,0.34646),(0.47244,0.34646),(0.48031,0.34646),(0.48819,0.34646),(0.49606,0.34646),(0.50394,0.34646),(0.51181,0.34646),(0.51969,0.34646),(0.52756,0.34646),(0.53543,0.34646),(0.54331,0.34646),(0.55118,0.34646),(0.55906,0.34646),(0.56693,0.34646),(0.5748,0.34646),(0.58268,0.34646),(0.59055,0.34646),(0.59843,0.34646),(0.6063,0.34646),(0.61417,0.34646),(0.62205,0.34646),(0.62992,0.34646),(0.6378,0.34646),(0.64567,0.34646),(0.65354,0.34646),(0.66142,0.34646),(0.66929,0.34646),(0.67717,0.34646),(0.68504,0.34646),(0.69291,0.34646),(0.70079,0.34646),(0.70866,0.34646),(0.71654,0.34646),(0.72441,0.34646),(0.73228,0.34646),(0.74016,0.34646),(0.74803,0.34646),(0.75591,0.34646),(0.76378,0.34646),(0.77165,0.34646),(0.77953,0.34646),(0.7874,0.34646),(0.79528,0.34646),(0.80315,0.34646),(0.81102,0.34646),(0.8189,0.34646),(0.82677,0.34646),(0.83465,0.34646),(0.84252,0.34646),(0.85039,0.34646),(0.85827,0.34646),(0.86614,0.34646),(0.87402,0.34646),(0.88189,0.34646),(0.88976,0.34646),(0.89764,0.34646),(0.90551,0.34646),(0.91339,0.34646),(0.92126,0.34646),(0.92913,0.34646),(0.93701,0.34646),(0.94488,0.34646),(0.95276,0.34646),(0.96063,0.34646),(0.9685,0.34646),(0.97638,0.34646),(0.98425,0.34646),(0.99213,0.34646),(0.99609,0.34646),(0.00391,0.35433),(0.00787,0.35433),(0.01575,0.35433),(0.02362,0.35433),(0.0315,0.35433),(0.03937,0.35433),(0.04724,0.35433),(0.05512,0.35433),(0.06299,0.35433),(0.07087,0.35433),(0.07874,0.35433),(0.08661,0.35433),(0.09449,0.35433),(0.10236,0.35433),(0.11024,0.35433),(0.11811,0.35433),(0.12598,0.35433),(0.13386,0.35433),(0.14173,0.35433),(0.14961,0.35433),(0.15748,0.35433),(0.16535,0.35433),(0.17323,0.35433),(0.1811,0.35433),(0.18898,0.35433),(0.19685,0.35433),(0.20472,0.35433),(0.2126,0.35433),(0.22047,0.35433),(0.22835,0.35433),(0.23622,0.35433),(0.24409,0.35433),(0.25197,0.35433),(0.25984,0.35433),(0.26772,0.35433),(0.27559,0.35433),(0.28346,0.35433),(0.29134,0.35433),(0.29921,0.35433),(0.30709,0.35433),(0.31496,0.35433),(0.32283,0.35433),(0.33071,0.35433),(0.33858,0.35433),(0.34646,0.35433),(0.35433,0.35433),(0.3622,0.35433),(0.37008,0.35433),(0.37795,0.35433),(0.38583,0.35433),(0.3937,0.35433),(0.40157,0.35433),(0.40945,0.35433),(0.41732,0.35433),(0.4252,0.35433),(0.43307,0.35433),(0.44094,0.35433),(0.44882,0.35433),(0.45669,0.35433),(0.46457,0.35433),(0.47244,0.35433),(0.48031,0.35433),(0.48819,0.35433),(0.49606,0.35433),(0.50394,0.35433),(0.51181,0.35433),(0.51969,0.35433),(0.52756,0.35433),(0.53543,0.35433),(0.54331,0.35433),(0.55118,0.35433),(0.55906,0.35433),(0.56693,0.35433),(0.5748,0.35433),(0.58268,0.35433),(0.59055,0.35433),(0.59843,0.35433),(0.6063,0.35433),(0.61417,0.35433),(0.62205,0.35433),(0.62992,0.35433),(0.6378,0.35433),(0.64567,0.35433),(0.65354,0.35433),(0.66142,0.35433),(0.66929,0.35433),(0.67717,0.35433),(0.68504,0.35433),(0.69291,0.35433),(0.70079,0.35433),(0.70866,0.35433),(0.71654,0.35433),(0.72441,0.35433),(0.73228,0.35433),(0.74016,0.35433),(0.74803,0.35433),(0.75591,0.35433),(0.76378,0.35433),(0.77165,0.35433),(0.77953,0.35433),(0.7874,0.35433),(0.79528,0.35433),(0.80315,0.35433),(0.81102,0.35433),(0.8189,0.35433),(0.82677,0.35433),(0.83465,0.35433),(0.84252,0.35433),(0.85039,0.35433),(0.85827,0.35433),(0.86614,0.35433),(0.87402,0.35433),(0.88189,0.35433),(0.88976,0.35433),(0.89764,0.35433),(0.90551,0.35433),(0.91339,0.35433),(0.92126,0.35433),(0.92913,0.35433),(0.93701,0.35433),(0.94488,0.35433),(0.95276,0.35433),(0.96063,0.35433),(0.9685,0.35433),(0.97638,0.35433),(0.98425,0.35433),(0.99213,0.35433),(0.99609,0.35433),(0.00391,0.3622),(0.00787,0.3622),(0.01575,0.3622),(0.02362,0.3622),(0.0315,0.3622),(0.03937,0.3622),(0.04724,0.3622),(0.05512,0.3622),(0.06299,0.3622),(0.07087,0.3622),(0.07874,0.3622),(0.08661,0.3622),(0.09449,0.3622),(0.10236,0.3622),(0.11024,0.3622),(0.11811,0.3622),(0.12598,0.3622),(0.13386,0.3622),(0.14173,0.3622),(0.14961,0.3622),(0.15748,0.3622),(0.16535,0.3622),(0.17323,0.3622),(0.1811,0.3622),(0.18898,0.3622),(0.19685,0.3622),(0.20472,0.3622),(0.2126,0.3622),(0.22047,0.3622),(0.22835,0.3622),(0.23622,0.3622),(0.24409,0.3622),(0.25197,0.3622),(0.25984,0.3622),(0.26772,0.3622),(0.27559,0.3622),(0.28346,0.3622),(0.29134,0.3622),(0.29921,0.3622),(0.30709,0.3622),(0.31496,0.3622),(0.32283,0.3622),(0.33071,0.3622),(0.33858,0.3622),(0.34646,0.3622),(0.35433,0.3622),(0.3622,0.3622),(0.37008,0.3622),(0.37795,0.3622),(0.38583,0.3622),(0.3937,0.3622),(0.40157,0.3622),(0.40945,0.3622),(0.41732,0.3622),(0.4252,0.3622),(0.43307,0.3622),(0.44094,0.3622),(0.44882,0.3622),(0.45669,0.3622),(0.46457,0.3622),(0.47244,0.3622),(0.48031,0.3622),(0.48819,0.3622),(0.49606,0.3622),(0.50394,0.3622),(0.51181,0.3622),(0.51969,0.3622),(0.52756,0.3622),(0.53543,0.3622),(0.54331,0.3622),(0.55118,0.3622),(0.55906,0.3622),(0.56693,0.3622),(0.5748,0.3622),(0.58268,0.3622),(0.59055,0.3622),(0.59843,0.3622),(0.6063,0.3622),(0.61417,0.3622),(0.62205,0.3622),(0.62992,0.3622),(0.6378,0.3622),(0.64567,0.3622),(0.65354,0.3622),(0.66142,0.3622),(0.66929,0.3622),(0.67717,0.3622),(0.68504,0.3622),(0.69291,0.3622),(0.70079,0.3622),(0.70866,0.3622),(0.71654,0.3622),(0.72441,0.3622),(0.73228,0.3622),(0.74016,0.3622),(0.74803,0.3622),(0.75591,0.3622),(0.76378,0.3622),(0.77165,0.3622),(0.77953,0.3622),(0.7874,0.3622),(0.79528,0.3622),(0.80315,0.3622),(0.81102,0.3622),(0.8189,0.3622),(0.82677,0.3622),(0.83465,0.3622),(0.84252,0.3622),(0.85039,0.3622),(0.85827,0.3622),(0.86614,0.3622),(0.87402,0.3622),(0.88189,0.3622),(0.88976,0.3622),(0.89764,0.3622),(0.90551,0.3622),(0.91339,0.3622),(0.92126,0.3622),(0.92913,0.3622),(0.93701,0.3622),(0.94488,0.3622),(0.95276,0.3622),(0.96063,0.3622),(0.9685,0.3622),(0.97638,0.3622),(0.98425,0.3622),(0.99213,0.3622),(0.99609,0.3622),(0.00391,0.37008),(0.00787,0.37008),(0.01575,0.37008),(0.02362,0.37008),(0.0315,0.37008),(0.03937,0.37008),(0.04724,0.37008),(0.05512,0.37008),(0.06299,0.37008),(0.07087,0.37008),(0.07874,0.37008),(0.08661,0.37008),(0.09449,0.37008),(0.10236,0.37008),(0.11024,0.37008),(0.11811,0.37008),(0.12598,0.37008),(0.13386,0.37008),(0.14173,0.37008),(0.14961,0.37008),(0.15748,0.37008),(0.16535,0.37008),(0.17323,0.37008),(0.1811,0.37008),(0.18898,0.37008),(0.19685,0.37008),(0.20472,0.37008),(0.2126,0.37008),(0.22047,0.37008),(0.22835,0.37008),(0.23622,0.37008),(0.24409,0.37008),(0.25197,0.37008),(0.25984,0.37008),(0.26772,0.37008),(0.27559,0.37008),(0.28346,0.37008),(0.29134,0.37008),(0.29921,0.37008),(0.30709,0.37008),(0.31496,0.37008),(0.32283,0.37008),(0.33071,0.37008),(0.33858,0.37008),(0.34646,0.37008),(0.35433,0.37008),(0.3622,0.37008),(0.37008,0.37008),(0.37795,0.37008),(0.38583,0.37008),(0.3937,0.37008),(0.40157,0.37008),(0.40945,0.37008),(0.41732,0.37008),(0.4252,0.37008),(0.43307,0.37008),(0.44094,0.37008),(0.44882,0.37008),(0.45669,0.37008),(0.46457,0.37008),(0.47244,0.37008),(0.48031,0.37008),(0.48819,0.37008),(0.49606,0.37008),(0.50394,0.37008),(0.51181,0.37008),(0.51969,0.37008),(0.52756,0.37008),(0.53543,0.37008),(0.54331,0.37008),(0.55118,0.37008),(0.55906,0.37008),(0.56693,0.37008),(0.5748,0.37008),(0.58268,0.37008),(0.59055,0.37008),(0.59843,0.37008),(0.6063,0.37008),(0.61417,0.37008),(0.62205,0.37008),(0.62992,0.37008),(0.6378,0.37008),(0.64567,0.37008),(0.65354,0.37008),(0.66142,0.37008),(0.66929,0.37008),(0.67717,0.37008),(0.68504,0.37008),(0.69291,0.37008),(0.70079,0.37008),(0.70866,0.37008),(0.71654,0.37008),(0.72441,0.37008),(0.73228,0.37008),(0.74016,0.37008),(0.74803,0.37008),(0.75591,0.37008),(0.76378,0.37008),(0.77165,0.37008),(0.77953,0.37008),(0.7874,0.37008),(0.79528,0.37008),(0.80315,0.37008),(0.81102,0.37008),(0.8189,0.37008),(0.82677,0.37008),(0.83465,0.37008),(0.84252,0.37008),(0.85039,0.37008),(0.85827,0.37008),(0.86614,0.37008),(0.87402,0.37008),(0.88189,0.37008),(0.88976,0.37008),(0.89764,0.37008),(0.90551,0.37008),(0.91339,0.37008),(0.92126,0.37008),(0.92913,0.37008),(0.93701,0.37008),(0.94488,0.37008),(0.95276,0.37008),(0.96063,0.37008),(0.9685,0.37008),(0.97638,0.37008),(0.98425,0.37008),(0.99213,0.37008),(0.99609,0.37008),(0.00391,0.37795),(0.00787,0.37795),(0.01575,0.37795),(0.02362,0.37795),(0.0315,0.37795),(0.03937,0.37795),(0.04724,0.37795),(0.05512,0.37795),(0.06299,0.37795),(0.07087,0.37795),(0.07874,0.37795),(0.08661,0.37795),(0.09449,0.37795),(0.10236,0.37795),(0.11024,0.37795),(0.11811,0.37795),(0.12598,0.37795),(0.13386,0.37795),(0.14173,0.37795),(0.14961,0.37795),(0.15748,0.37795),(0.16535,0.37795),(0.17323,0.37795),(0.1811,0.37795),(0.18898,0.37795),(0.19685,0.37795),(0.20472,0.37795),(0.2126,0.37795),(0.22047,0.37795),(0.22835,0.37795),(0.23622,0.37795),(0.24409,0.37795),(0.25197,0.37795),(0.25984,0.37795),(0.26772,0.37795),(0.27559,0.37795),(0.28346,0.37795),(0.29134,0.37795),(0.29921,0.37795),(0.30709,0.37795),(0.31496,0.37795),(0.32283,0.37795),(0.33071,0.37795),(0.33858,0.37795),(0.34646,0.37795),(0.35433,0.37795),(0.3622,0.37795),(0.37008,0.37795),(0.37795,0.37795),(0.38583,0.37795),(0.3937,0.37795),(0.40157,0.37795),(0.40945,0.37795),(0.41732,0.37795),(0.4252,0.37795),(0.43307,0.37795),(0.44094,0.37795),(0.44882,0.37795),(0.45669,0.37795),(0.46457,0.37795),(0.47244,0.37795),(0.48031,0.37795),(0.48819,0.37795),(0.49606,0.37795),(0.50394,0.37795),(0.51181,0.37795),(0.51969,0.37795),(0.52756,0.37795),(0.53543,0.37795),(0.54331,0.37795),(0.55118,0.37795),(0.55906,0.37795),(0.56693,0.37795),(0.5748,0.37795),(0.58268,0.37795),(0.59055,0.37795),(0.59843,0.37795),(0.6063,0.37795),(0.61417,0.37795),(0.62205,0.37795),(0.62992,0.37795),(0.6378,0.37795),(0.64567,0.37795),(0.65354,0.37795),(0.66142,0.37795),(0.66929,0.37795),(0.67717,0.37795),(0.68504,0.37795),(0.69291,0.37795),(0.70079,0.37795),(0.70866,0.37795),(0.71654,0.37795),(0.72441,0.37795),(0.73228,0.37795),(0.74016,0.37795),(0.74803,0.37795),(0.75591,0.37795),(0.76378,0.37795),(0.77165,0.37795),(0.77953,0.37795),(0.7874,0.37795),(0.79528,0.37795),(0.80315,0.37795),(0.81102,0.37795),(0.8189,0.37795),(0.82677,0.37795),(0.83465,0.37795),(0.84252,0.37795),(0.85039,0.37795),(0.85827,0.37795),(0.86614,0.37795),(0.87402,0.37795),(0.88189,0.37795),(0.88976,0.37795),(0.89764,0.37795),(0.90551,0.37795),(0.91339,0.37795),(0.92126,0.37795),(0.92913,0.37795),(0.93701,0.37795),(0.94488,0.37795),(0.95276,0.37795),(0.96063,0.37795),(0.9685,0.37795),(0.97638,0.37795),(0.98425,0.37795),(0.99213,0.37795),(0.99609,0.37795),(0.00391,0.38583),(0.00787,0.38583),(0.01575,0.38583),(0.02362,0.38583),(0.0315,0.38583),(0.03937,0.38583),(0.04724,0.38583),(0.05512,0.38583),(0.06299,0.38583),(0.07087,0.38583),(0.07874,0.38583),(0.08661,0.38583),(0.09449,0.38583),(0.10236,0.38583),(0.11024,0.38583),(0.11811,0.38583),(0.12598,0.38583),(0.13386,0.38583),(0.14173,0.38583),(0.14961,0.38583),(0.15748,0.38583),(0.16535,0.38583),(0.17323,0.38583),(0.1811,0.38583),(0.18898,0.38583),(0.19685,0.38583),(0.20472,0.38583),(0.2126,0.38583),(0.22047,0.38583),(0.22835,0.38583),(0.23622,0.38583),(0.24409,0.38583),(0.25197,0.38583),(0.25984,0.38583),(0.26772,0.38583),(0.27559,0.38583),(0.28346,0.38583),(0.29134,0.38583),(0.29921,0.38583),(0.30709,0.38583),(0.31496,0.38583),(0.32283,0.38583),(0.33071,0.38583),(0.33858,0.38583),(0.34646,0.38583),(0.35433,0.38583),(0.3622,0.38583),(0.37008,0.38583),(0.37795,0.38583),(0.38583,0.38583),(0.3937,0.38583),(0.40157,0.38583),(0.40945,0.38583),(0.41732,0.38583),(0.4252,0.38583),(0.43307,0.38583),(0.44094,0.38583),(0.44882,0.38583),(0.45669,0.38583),(0.46457,0.38583),(0.47244,0.38583),(0.48031,0.38583),(0.48819,0.38583),(0.49606,0.38583),(0.50394,0.38583),(0.51181,0.38583),(0.51969,0.38583),(0.52756,0.38583),(0.53543,0.38583),(0.54331,0.38583),(0.55118,0.38583),(0.55906,0.38583),(0.56693,0.38583),(0.5748,0.38583),(0.58268,0.38583),(0.59055,0.38583),(0.59843,0.38583),(0.6063,0.38583),(0.61417,0.38583),(0.62205,0.38583),(0.62992,0.38583),(0.6378,0.38583),(0.64567,0.38583),(0.65354,0.38583),(0.66142,0.38583),(0.66929,0.38583),(0.67717,0.38583),(0.68504,0.38583),(0.69291,0.38583),(0.70079,0.38583),(0.70866,0.38583),(0.71654,0.38583),(0.72441,0.38583),(0.73228,0.38583),(0.74016,0.38583),(0.74803,0.38583),(0.75591,0.38583),(0.76378,0.38583),(0.77165,0.38583),(0.77953,0.38583),(0.7874,0.38583),(0.79528,0.38583),(0.80315,0.38583),(0.81102,0.38583),(0.8189,0.38583),(0.82677,0.38583),(0.83465,0.38583),(0.84252,0.38583),(0.85039,0.38583),(0.85827,0.38583),(0.86614,0.38583),(0.87402,0.38583),(0.88189,0.38583),(0.88976,0.38583),(0.89764,0.38583),(0.90551,0.38583),(0.91339,0.38583),(0.92126,0.38583),(0.92913,0.38583),(0.93701,0.38583),(0.94488,0.38583),(0.95276,0.38583),(0.96063,0.38583),(0.9685,0.38583),(0.97638,0.38583),(0.98425,0.38583),(0.99213,0.38583),(0.99609,0.38583),(0.00391,0.3937),(0.00787,0.3937),(0.01575,0.3937),(0.02362,0.3937),(0.0315,0.3937),(0.03937,0.3937),(0.04724,0.3937),(0.05512,0.3937),(0.06299,0.3937),(0.07087,0.3937),(0.07874,0.3937),(0.08661,0.3937),(0.09449,0.3937),(0.10236,0.3937),(0.11024,0.3937),(0.11811,0.3937),(0.12598,0.3937),(0.13386,0.3937),(0.14173,0.3937),(0.14961,0.3937),(0.15748,0.3937),(0.16535,0.3937),(0.17323,0.3937),(0.1811,0.3937),(0.18898,0.3937),(0.19685,0.3937),(0.20472,0.3937),(0.2126,0.3937),(0.22047,0.3937),(0.22835,0.3937),(0.23622,0.3937),(0.24409,0.3937),(0.25197,0.3937),(0.25984,0.3937),(0.26772,0.3937),(0.27559,0.3937),(0.28346,0.3937),(0.29134,0.3937),(0.29921,0.3937),(0.30709,0.3937),(0.31496,0.3937),(0.32283,0.3937),(0.33071,0.3937),(0.33858,0.3937),(0.34646,0.3937),(0.35433,0.3937),(0.3622,0.3937),(0.37008,0.3937),(0.37795,0.3937),(0.38583,0.3937),(0.3937,0.3937),(0.40157,0.3937),(0.40945,0.3937),(0.41732,0.3937),(0.4252,0.3937),(0.43307,0.3937),(0.44094,0.3937),(0.44882,0.3937),(0.45669,0.3937),(0.46457,0.3937),(0.47244,0.3937),(0.48031,0.3937),(0.48819,0.3937),(0.49606,0.3937),(0.50394,0.3937),(0.51181,0.3937),(0.51969,0.3937),(0.52756,0.3937),(0.53543,0.3937),(0.54331,0.3937),(0.55118,0.3937),(0.55906,0.3937),(0.56693,0.3937),(0.5748,0.3937),(0.58268,0.3937),(0.59055,0.3937),(0.59843,0.3937),(0.6063,0.3937),(0.61417,0.3937),(0.62205,0.3937),(0.62992,0.3937),(0.6378,0.3937),(0.64567,0.3937),(0.65354,0.3937),(0.66142,0.3937),(0.66929,0.3937),(0.67717,0.3937),(0.68504,0.3937),(0.69291,0.3937),(0.70079,0.3937),(0.70866,0.3937),(0.71654,0.3937),(0.72441,0.3937),(0.73228,0.3937),(0.74016,0.3937),(0.74803,0.3937),(0.75591,0.3937),(0.76378,0.3937),(0.77165,0.3937),(0.77953,0.3937),(0.7874,0.3937),(0.79528,0.3937),(0.80315,0.3937),(0.81102,0.3937),(0.8189,0.3937),(0.82677,0.3937),(0.83465,0.3937),(0.84252,0.3937),(0.85039,0.3937),(0.85827,0.3937),(0.86614,0.3937),(0.87402,0.3937),(0.88189,0.3937),(0.88976,0.3937),(0.89764,0.3937),(0.90551,0.3937),(0.91339,0.3937),(0.92126,0.3937),(0.92913,0.3937),(0.93701,0.3937),(0.94488,0.3937),(0.95276,0.3937),(0.96063,0.3937),(0.9685,0.3937),(0.97638,0.3937),(0.98425,0.3937),(0.99213,0.3937),(0.99609,0.3937),(0.00391,0.40157),(0.00787,0.40157),(0.01575,0.40157),(0.02362,0.40157),(0.0315,0.40157),(0.03937,0.40157),(0.04724,0.40157),(0.05512,0.40157),(0.06299,0.40157),(0.07087,0.40157),(0.07874,0.40157),(0.08661,0.40157),(0.09449,0.40157),(0.10236,0.40157),(0.11024,0.40157),(0.11811,0.40157),(0.12598,0.40157),(0.13386,0.40157),(0.14173,0.40157),(0.14961,0.40157),(0.15748,0.40157),(0.16535,0.40157),(0.17323,0.40157),(0.1811,0.40157),(0.18898,0.40157),(0.19685,0.40157),(0.20472,0.40157),(0.2126,0.40157),(0.22047,0.40157),(0.22835,0.40157),(0.23622,0.40157),(0.24409,0.40157),(0.25197,0.40157),(0.25984,0.40157),(0.26772,0.40157),(0.27559,0.40157),(0.28346,0.40157),(0.29134,0.40157),(0.29921,0.40157),(0.30709,0.40157),(0.31496,0.40157),(0.32283,0.40157),(0.33071,0.40157),(0.33858,0.40157),(0.34646,0.40157),(0.35433,0.40157),(0.3622,0.40157),(0.37008,0.40157),(0.37795,0.40157),(0.38583,0.40157),(0.3937,0.40157),(0.40157,0.40157),(0.40945,0.40157),(0.41732,0.40157),(0.4252,0.40157),(0.43307,0.40157),(0.44094,0.40157),(0.44882,0.40157),(0.45669,0.40157),(0.46457,0.40157),(0.47244,0.40157),(0.48031,0.40157),(0.48819,0.40157),(0.49606,0.40157),(0.50394,0.40157),(0.51181,0.40157),(0.51969,0.40157),(0.52756,0.40157),(0.53543,0.40157),(0.54331,0.40157),(0.55118,0.40157),(0.55906,0.40157),(0.56693,0.40157),(0.5748,0.40157),(0.58268,0.40157),(0.59055,0.40157),(0.59843,0.40157),(0.6063,0.40157),(0.61417,0.40157),(0.62205,0.40157),(0.62992,0.40157),(0.6378,0.40157),(0.64567,0.40157),(0.65354,0.40157),(0.66142,0.40157),(0.66929,0.40157),(0.67717,0.40157),(0.68504,0.40157),(0.69291,0.40157),(0.70079,0.40157),(0.70866,0.40157),(0.71654,0.40157),(0.72441,0.40157),(0.73228,0.40157),(0.74016,0.40157),(0.74803,0.40157),(0.75591,0.40157),(0.76378,0.40157),(0.77165,0.40157),(0.77953,0.40157),(0.7874,0.40157),(0.79528,0.40157),(0.80315,0.40157),(0.81102,0.40157),(0.8189,0.40157),(0.82677,0.40157),(0.83465,0.40157),(0.84252,0.40157),(0.85039,0.40157),(0.85827,0.40157),(0.86614,0.40157),(0.87402,0.40157),(0.88189,0.40157),(0.88976,0.40157),(0.89764,0.40157),(0.90551,0.40157),(0.91339,0.40157),(0.92126,0.40157),(0.92913,0.40157),(0.93701,0.40157),(0.94488,0.40157),(0.95276,0.40157),(0.96063,0.40157),(0.9685,0.40157),(0.97638,0.40157),(0.98425,0.40157),(0.99213,0.40157),(0.99609,0.40157),(0.00391,0.40945),(0.00787,0.40945),(0.01575,0.40945),(0.02362,0.40945),(0.0315,0.40945),(0.03937,0.40945),(0.04724,0.40945),(0.05512,0.40945),(0.06299,0.40945),(0.07087,0.40945),(0.07874,0.40945),(0.08661,0.40945),(0.09449,0.40945),(0.10236,0.40945),(0.11024,0.40945),(0.11811,0.40945),(0.12598,0.40945),(0.13386,0.40945),(0.14173,0.40945),(0.14961,0.40945),(0.15748,0.40945),(0.16535,0.40945),(0.17323,0.40945),(0.1811,0.40945),(0.18898,0.40945),(0.19685,0.40945),(0.20472,0.40945),(0.2126,0.40945),(0.22047,0.40945),(0.22835,0.40945),(0.23622,0.40945),(0.24409,0.40945),(0.25197,0.40945),(0.25984,0.40945),(0.26772,0.40945),(0.27559,0.40945),(0.28346,0.40945),(0.29134,0.40945),(0.29921,0.40945),(0.30709,0.40945),(0.31496,0.40945),(0.32283,0.40945),(0.33071,0.40945),(0.33858,0.40945),(0.34646,0.40945),(0.35433,0.40945),(0.3622,0.40945),(0.37008,0.40945),(0.37795,0.40945),(0.38583,0.40945),(0.3937,0.40945),(0.40157,0.40945),(0.40945,0.40945),(0.41732,0.40945),(0.4252,0.40945),(0.43307,0.40945),(0.44094,0.40945),(0.44882,0.40945),(0.45669,0.40945),(0.46457,0.40945),(0.47244,0.40945),(0.48031,0.40945),(0.48819,0.40945),(0.49606,0.40945),(0.50394,0.40945),(0.51181,0.40945),(0.51969,0.40945),(0.52756,0.40945),(0.53543,0.40945),(0.54331,0.40945),(0.55118,0.40945),(0.55906,0.40945),(0.56693,0.40945),(0.5748,0.40945),(0.58268,0.40945),(0.59055,0.40945),(0.59843,0.40945),(0.6063,0.40945),(0.61417,0.40945),(0.62205,0.40945),(0.62992,0.40945),(0.6378,0.40945),(0.64567,0.40945),(0.65354,0.40945),(0.66142,0.40945),(0.66929,0.40945),(0.67717,0.40945),(0.68504,0.40945),(0.69291,0.40945),(0.70079,0.40945),(0.70866,0.40945),(0.71654,0.40945),(0.72441,0.40945),(0.73228,0.40945),(0.74016,0.40945),(0.74803,0.40945),(0.75591,0.40945),(0.76378,0.40945),(0.77165,0.40945),(0.77953,0.40945),(0.7874,0.40945),(0.79528,0.40945),(0.80315,0.40945),(0.81102,0.40945),(0.8189,0.40945),(0.82677,0.40945),(0.83465,0.40945),(0.84252,0.40945),(0.85039,0.40945),(0.85827,0.40945),(0.86614,0.40945),(0.87402,0.40945),(0.88189,0.40945),(0.88976,0.40945),(0.89764,0.40945),(0.90551,0.40945),(0.91339,0.40945),(0.92126,0.40945),(0.92913,0.40945),(0.93701,0.40945),(0.94488,0.40945),(0.95276,0.40945),(0.96063,0.40945),(0.9685,0.40945),(0.97638,0.40945),(0.98425,0.40945),(0.99213,0.40945),(0.99609,0.40945),(0.00391,0.41732),(0.00787,0.41732),(0.01575,0.41732),(0.02362,0.41732),(0.0315,0.41732),(0.03937,0.41732),(0.04724,0.41732),(0.05512,0.41732),(0.06299,0.41732),(0.07087,0.41732),(0.07874,0.41732),(0.08661,0.41732),(0.09449,0.41732),(0.10236,0.41732),(0.11024,0.41732),(0.11811,0.41732),(0.12598,0.41732),(0.13386,0.41732),(0.14173,0.41732),(0.14961,0.41732),(0.15748,0.41732),(0.16535,0.41732),(0.17323,0.41732),(0.1811,0.41732),(0.18898,0.41732),(0.19685,0.41732),(0.20472,0.41732),(0.2126,0.41732),(0.22047,0.41732),(0.22835,0.41732),(0.23622,0.41732),(0.24409,0.41732),(0.25197,0.41732),(0.25984,0.41732),(0.26772,0.41732),(0.27559,0.41732),(0.28346,0.41732),(0.29134,0.41732),(0.29921,0.41732),(0.30709,0.41732),(0.31496,0.41732),(0.32283,0.41732),(0.33071,0.41732),(0.33858,0.41732),(0.34646,0.41732),(0.35433,0.41732),(0.3622,0.41732),(0.37008,0.41732),(0.37795,0.41732),(0.38583,0.41732),(0.3937,0.41732),(0.40157,0.41732),(0.40945,0.41732),(0.41732,0.41732),(0.4252,0.41732),(0.43307,0.41732),(0.44094,0.41732),(0.44882,0.41732),(0.45669,0.41732),(0.46457,0.41732),(0.47244,0.41732),(0.48031,0.41732),(0.48819,0.41732),(0.49606,0.41732),(0.50394,0.41732),(0.51181,0.41732),(0.51969,0.41732),(0.52756,0.41732),(0.53543,0.41732),(0.54331,0.41732),(0.55118,0.41732),(0.55906,0.41732),(0.56693,0.41732),(0.5748,0.41732),(0.58268,0.41732),(0.59055,0.41732),(0.59843,0.41732),(0.6063,0.41732),(0.61417,0.41732),(0.62205,0.41732),(0.62992,0.41732),(0.6378,0.41732),(0.64567,0.41732),(0.65354,0.41732),(0.66142,0.41732),(0.66929,0.41732),(0.67717,0.41732),(0.68504,0.41732),(0.69291,0.41732),(0.70079,0.41732),(0.70866,0.41732),(0.71654,0.41732),(0.72441,0.41732),(0.73228,0.41732),(0.74016,0.41732),(0.74803,0.41732),(0.75591,0.41732),(0.76378,0.41732),(0.77165,0.41732),(0.77953,0.41732),(0.7874,0.41732),(0.79528,0.41732),(0.80315,0.41732),(0.81102,0.41732),(0.8189,0.41732),(0.82677,0.41732),(0.83465,0.41732),(0.84252,0.41732),(0.85039,0.41732),(0.85827,0.41732),(0.86614,0.41732),(0.87402,0.41732),(0.88189,0.41732),(0.88976,0.41732),(0.89764,0.41732),(0.90551,0.41732),(0.91339,0.41732),(0.92126,0.41732),(0.92913,0.41732),(0.93701,0.41732),(0.94488,0.41732),(0.95276,0.41732),(0.96063,0.41732),(0.9685,0.41732),(0.97638,0.41732),(0.98425,0.41732),(0.99213,0.41732),(0.99609,0.41732),(0.00391,0.4252),(0.00787,0.4252),(0.01575,0.4252),(0.02362,0.4252),(0.0315,0.4252),(0.03937,0.4252),(0.04724,0.4252),(0.05512,0.4252),(0.06299,0.4252),(0.07087,0.4252),(0.07874,0.4252),(0.08661,0.4252),(0.09449,0.4252),(0.10236,0.4252),(0.11024,0.4252),(0.11811,0.4252),(0.12598,0.4252),(0.13386,0.4252),(0.14173,0.4252),(0.14961,0.4252),(0.15748,0.4252),(0.16535,0.4252),(0.17323,0.4252),(0.1811,0.4252),(0.18898,0.4252),(0.19685,0.4252),(0.20472,0.4252),(0.2126,0.4252),(0.22047,0.4252),(0.22835,0.4252),(0.23622,0.4252),(0.24409,0.4252),(0.25197,0.4252),(0.25984,0.4252),(0.26772,0.4252),(0.27559,0.4252),(0.28346,0.4252),(0.29134,0.4252),(0.29921,0.4252),(0.30709,0.4252),(0.31496,0.4252),(0.32283,0.4252),(0.33071,0.4252),(0.33858,0.4252),(0.34646,0.4252),(0.35433,0.4252),(0.3622,0.4252),(0.37008,0.4252),(0.37795,0.4252),(0.38583,0.4252),(0.3937,0.4252),(0.40157,0.4252),(0.40945,0.4252),(0.41732,0.4252),(0.4252,0.4252),(0.43307,0.4252),(0.44094,0.4252),(0.44882,0.4252),(0.45669,0.4252),(0.46457,0.4252),(0.47244,0.4252),(0.48031,0.4252),(0.48819,0.4252),(0.49606,0.4252),(0.50394,0.4252),(0.51181,0.4252),(0.51969,0.4252),(0.52756,0.4252),(0.53543,0.4252),(0.54331,0.4252),(0.55118,0.4252),(0.55906,0.4252),(0.56693,0.4252),(0.5748,0.4252),(0.58268,0.4252),(0.59055,0.4252),(0.59843,0.4252),(0.6063,0.4252),(0.61417,0.4252),(0.62205,0.4252),(0.62992,0.4252),(0.6378,0.4252),(0.64567,0.4252),(0.65354,0.4252),(0.66142,0.4252),(0.66929,0.4252),(0.67717,0.4252),(0.68504,0.4252),(0.69291,0.4252),(0.70079,0.4252),(0.70866,0.4252),(0.71654,0.4252),(0.72441,0.4252),(0.73228,0.4252),(0.74016,0.4252),(0.74803,0.4252),(0.75591,0.4252),(0.76378,0.4252),(0.77165,0.4252),(0.77953,0.4252),(0.7874,0.4252),(0.79528,0.4252),(0.80315,0.4252),(0.81102,0.4252),(0.8189,0.4252),(0.82677,0.4252),(0.83465,0.4252),(0.84252,0.4252),(0.85039,0.4252),(0.85827,0.4252),(0.86614,0.4252),(0.87402,0.4252),(0.88189,0.4252),(0.88976,0.4252),(0.89764,0.4252),(0.90551,0.4252),(0.91339,0.4252),(0.92126,0.4252),(0.92913,0.4252),(0.93701,0.4252),(0.94488,0.4252),(0.95276,0.4252),(0.96063,0.4252),(0.9685,0.4252),(0.97638,0.4252),(0.98425,0.4252),(0.99213,0.4252),(0.99609,0.4252),(0.00391,0.43307),(0.00787,0.43307),(0.01575,0.43307),(0.02362,0.43307),(0.0315,0.43307),(0.03937,0.43307),(0.04724,0.43307),(0.05512,0.43307),(0.06299,0.43307),(0.07087,0.43307),(0.07874,0.43307),(0.08661,0.43307),(0.09449,0.43307),(0.10236,0.43307),(0.11024,0.43307),(0.11811,0.43307),(0.12598,0.43307),(0.13386,0.43307),(0.14173,0.43307),(0.14961,0.43307),(0.15748,0.43307),(0.16535,0.43307),(0.17323,0.43307),(0.1811,0.43307),(0.18898,0.43307),(0.19685,0.43307),(0.20472,0.43307),(0.2126,0.43307),(0.22047,0.43307),(0.22835,0.43307),(0.23622,0.43307),(0.24409,0.43307),(0.25197,0.43307),(0.25984,0.43307),(0.26772,0.43307),(0.27559,0.43307),(0.28346,0.43307),(0.29134,0.43307),(0.29921,0.43307),(0.30709,0.43307),(0.31496,0.43307),(0.32283,0.43307),(0.33071,0.43307),(0.33858,0.43307),(0.34646,0.43307),(0.35433,0.43307),(0.3622,0.43307),(0.37008,0.43307),(0.37795,0.43307),(0.38583,0.43307),(0.3937,0.43307),(0.40157,0.43307),(0.40945,0.43307),(0.41732,0.43307),(0.4252,0.43307),(0.43307,0.43307),(0.44094,0.43307),(0.44882,0.43307),(0.45669,0.43307),(0.46457,0.43307),(0.47244,0.43307),(0.48031,0.43307),(0.48819,0.43307),(0.49606,0.43307),(0.50394,0.43307),(0.51181,0.43307),(0.51969,0.43307),(0.52756,0.43307),(0.53543,0.43307),(0.54331,0.43307),(0.55118,0.43307),(0.55906,0.43307),(0.56693,0.43307),(0.5748,0.43307),(0.58268,0.43307),(0.59055,0.43307),(0.59843,0.43307),(0.6063,0.43307),(0.61417,0.43307),(0.62205,0.43307),(0.62992,0.43307),(0.6378,0.43307),(0.64567,0.43307),(0.65354,0.43307),(0.66142,0.43307),(0.66929,0.43307),(0.67717,0.43307),(0.68504,0.43307),(0.69291,0.43307),(0.70079,0.43307),(0.70866,0.43307),(0.71654,0.43307),(0.72441,0.43307),(0.73228,0.43307),(0.74016,0.43307),(0.74803,0.43307),(0.75591,0.43307),(0.76378,0.43307),(0.77165,0.43307),(0.77953,0.43307),(0.7874,0.43307),(0.79528,0.43307),(0.80315,0.43307),(0.81102,0.43307),(0.8189,0.43307),(0.82677,0.43307),(0.83465,0.43307),(0.84252,0.43307),(0.85039,0.43307),(0.85827,0.43307),(0.86614,0.43307),(0.87402,0.43307),(0.88189,0.43307),(0.88976,0.43307),(0.89764,0.43307),(0.90551,0.43307),(0.91339,0.43307),(0.92126,0.43307),(0.92913,0.43307),(0.93701,0.43307),(0.94488,0.43307),(0.95276,0.43307),(0.96063,0.43307),(0.9685,0.43307),(0.97638,0.43307),(0.98425,0.43307),(0.99213,0.43307),(0.99609,0.43307),(0.00391,0.44094),(0.00787,0.44094),(0.01575,0.44094),(0.02362,0.44094),(0.0315,0.44094),(0.03937,0.44094),(0.04724,0.44094),(0.05512,0.44094),(0.06299,0.44094),(0.07087,0.44094),(0.07874,0.44094),(0.08661,0.44094),(0.09449,0.44094),(0.10236,0.44094),(0.11024,0.44094),(0.11811,0.44094),(0.12598,0.44094),(0.13386,0.44094),(0.14173,0.44094),(0.14961,0.44094),(0.15748,0.44094),(0.16535,0.44094),(0.17323,0.44094),(0.1811,0.44094),(0.18898,0.44094),(0.19685,0.44094),(0.20472,0.44094),(0.2126,0.44094),(0.22047,0.44094),(0.22835,0.44094),(0.23622,0.44094),(0.24409,0.44094),(0.25197,0.44094),(0.25984,0.44094),(0.26772,0.44094),(0.27559,0.44094),(0.28346,0.44094),(0.29134,0.44094),(0.29921,0.44094),(0.30709,0.44094),(0.31496,0.44094),(0.32283,0.44094),(0.33071,0.44094),(0.33858,0.44094),(0.34646,0.44094),(0.35433,0.44094),(0.3622,0.44094),(0.37008,0.44094),(0.37795,0.44094),(0.38583,0.44094),(0.3937,0.44094),(0.40157,0.44094),(0.40945,0.44094),(0.41732,0.44094),(0.4252,0.44094),(0.43307,0.44094),(0.44094,0.44094),(0.44882,0.44094),(0.45669,0.44094),(0.46457,0.44094),(0.47244,0.44094),(0.48031,0.44094),(0.48819,0.44094),(0.49606,0.44094),(0.50394,0.44094),(0.51181,0.44094),(0.51969,0.44094),(0.52756,0.44094),(0.53543,0.44094),(0.54331,0.44094),(0.55118,0.44094),(0.55906,0.44094),(0.56693,0.44094),(0.5748,0.44094),(0.58268,0.44094),(0.59055,0.44094),(0.59843,0.44094),(0.6063,0.44094),(0.61417,0.44094),(0.62205,0.44094),(0.62992,0.44094),(0.6378,0.44094),(0.64567,0.44094),(0.65354,0.44094),(0.66142,0.44094),(0.66929,0.44094),(0.67717,0.44094),(0.68504,0.44094),(0.69291,0.44094),(0.70079,0.44094),(0.70866,0.44094),(0.71654,0.44094),(0.72441,0.44094),(0.73228,0.44094),(0.74016,0.44094),(0.74803,0.44094),(0.75591,0.44094),(0.76378,0.44094),(0.77165,0.44094),(0.77953,0.44094),(0.7874,0.44094),(0.79528,0.44094),(0.80315,0.44094),(0.81102,0.44094),(0.8189,0.44094),(0.82677,0.44094),(0.83465,0.44094),(0.84252,0.44094),(0.85039,0.44094),(0.85827,0.44094),(0.86614,0.44094),(0.87402,0.44094),(0.88189,0.44094),(0.88976,0.44094),(0.89764,0.44094),(0.90551,0.44094),(0.91339,0.44094),(0.92126,0.44094),(0.92913,0.44094),(0.93701,0.44094),(0.94488,0.44094),(0.95276,0.44094),(0.96063,0.44094),(0.9685,0.44094),(0.97638,0.44094),(0.98425,0.44094),(0.99213,0.44094),(0.99609,0.44094),(0.00391,0.44882),(0.00787,0.44882),(0.01575,0.44882),(0.02362,0.44882),(0.0315,0.44882),(0.03937,0.44882),(0.04724,0.44882),(0.05512,0.44882),(0.06299,0.44882),(0.07087,0.44882),(0.07874,0.44882),(0.08661,0.44882),(0.09449,0.44882),(0.10236,0.44882),(0.11024,0.44882),(0.11811,0.44882),(0.12598,0.44882),(0.13386,0.44882),(0.14173,0.44882),(0.14961,0.44882),(0.15748,0.44882),(0.16535,0.44882),(0.17323,0.44882),(0.1811,0.44882),(0.18898,0.44882),(0.19685,0.44882),(0.20472,0.44882),(0.2126,0.44882),(0.22047,0.44882),(0.22835,0.44882),(0.23622,0.44882),(0.24409,0.44882),(0.25197,0.44882),(0.25984,0.44882),(0.26772,0.44882),(0.27559,0.44882),(0.28346,0.44882),(0.29134,0.44882),(0.29921,0.44882),(0.30709,0.44882),(0.31496,0.44882),(0.32283,0.44882),(0.33071,0.44882),(0.33858,0.44882),(0.34646,0.44882),(0.35433,0.44882),(0.3622,0.44882),(0.37008,0.44882),(0.37795,0.44882),(0.38583,0.44882),(0.3937,0.44882),(0.40157,0.44882),(0.40945,0.44882),(0.41732,0.44882),(0.4252,0.44882),(0.43307,0.44882),(0.44094,0.44882),(0.44882,0.44882),(0.45669,0.44882),(0.46457,0.44882),(0.47244,0.44882),(0.48031,0.44882),(0.48819,0.44882),(0.49606,0.44882),(0.50394,0.44882),(0.51181,0.44882),(0.51969,0.44882),(0.52756,0.44882),(0.53543,0.44882),(0.54331,0.44882),(0.55118,0.44882),(0.55906,0.44882),(0.56693,0.44882),(0.5748,0.44882),(0.58268,0.44882),(0.59055,0.44882),(0.59843,0.44882),(0.6063,0.44882),(0.61417,0.44882),(0.62205,0.44882),(0.62992,0.44882),(0.6378,0.44882),(0.64567,0.44882),(0.65354,0.44882),(0.66142,0.44882),(0.66929,0.44882),(0.67717,0.44882),(0.68504,0.44882),(0.69291,0.44882),(0.70079,0.44882),(0.70866,0.44882),(0.71654,0.44882),(0.72441,0.44882),(0.73228,0.44882),(0.74016,0.44882),(0.74803,0.44882),(0.75591,0.44882),(0.76378,0.44882),(0.77165,0.44882),(0.77953,0.44882),(0.7874,0.44882),(0.79528,0.44882),(0.80315,0.44882),(0.81102,0.44882),(0.8189,0.44882),(0.82677,0.44882),(0.83465,0.44882),(0.84252,0.44882),(0.85039,0.44882),(0.85827,0.44882),(0.86614,0.44882),(0.87402,0.44882),(0.88189,0.44882),(0.88976,0.44882),(0.89764,0.44882),(0.90551,0.44882),(0.91339,0.44882),(0.92126,0.44882),(0.92913,0.44882),(0.93701,0.44882),(0.94488,0.44882),(0.95276,0.44882),(0.96063,0.44882),(0.9685,0.44882),(0.97638,0.44882),(0.98425,0.44882),(0.99213,0.44882),(0.99609,0.44882),(0.00391,0.45669),(0.00787,0.45669),(0.01575,0.45669),(0.02362,0.45669),(0.0315,0.45669),(0.03937,0.45669),(0.04724,0.45669),(0.05512,0.45669),(0.06299,0.45669),(0.07087,0.45669),(0.07874,0.45669),(0.08661,0.45669),(0.09449,0.45669),(0.10236,0.45669),(0.11024,0.45669),(0.11811,0.45669),(0.12598,0.45669),(0.13386,0.45669),(0.14173,0.45669),(0.14961,0.45669),(0.15748,0.45669),(0.16535,0.45669),(0.17323,0.45669),(0.1811,0.45669),(0.18898,0.45669),(0.19685,0.45669),(0.20472,0.45669),(0.2126,0.45669),(0.22047,0.45669),(0.22835,0.45669),(0.23622,0.45669),(0.24409,0.45669),(0.25197,0.45669),(0.25984,0.45669),(0.26772,0.45669),(0.27559,0.45669),(0.28346,0.45669),(0.29134,0.45669),(0.29921,0.45669),(0.30709,0.45669),(0.31496,0.45669),(0.32283,0.45669),(0.33071,0.45669),(0.33858,0.45669),(0.34646,0.45669),(0.35433,0.45669),(0.3622,0.45669),(0.37008,0.45669),(0.37795,0.45669),(0.38583,0.45669),(0.3937,0.45669),(0.40157,0.45669),(0.40945,0.45669),(0.41732,0.45669),(0.4252,0.45669),(0.43307,0.45669),(0.44094,0.45669),(0.44882,0.45669),(0.45669,0.45669),(0.46457,0.45669),(0.47244,0.45669),(0.48031,0.45669),(0.48819,0.45669),(0.49606,0.45669),(0.50394,0.45669),(0.51181,0.45669),(0.51969,0.45669),(0.52756,0.45669),(0.53543,0.45669),(0.54331,0.45669),(0.55118,0.45669),(0.55906,0.45669),(0.56693,0.45669),(0.5748,0.45669),(0.58268,0.45669),(0.59055,0.45669),(0.59843,0.45669),(0.6063,0.45669),(0.61417,0.45669),(0.62205,0.45669),(0.62992,0.45669),(0.6378,0.45669),(0.64567,0.45669),(0.65354,0.45669),(0.66142,0.45669),(0.66929,0.45669),(0.67717,0.45669),(0.68504,0.45669),(0.69291,0.45669),(0.70079,0.45669),(0.70866,0.45669),(0.71654,0.45669),(0.72441,0.45669),(0.73228,0.45669),(0.74016,0.45669),(0.74803,0.45669),(0.75591,0.45669),(0.76378,0.45669),(0.77165,0.45669),(0.77953,0.45669),(0.7874,0.45669),(0.79528,0.45669),(0.80315,0.45669),(0.81102,0.45669),(0.8189,0.45669),(0.82677,0.45669),(0.83465,0.45669),(0.84252,0.45669),(0.85039,0.45669),(0.85827,0.45669),(0.86614,0.45669),(0.87402,0.45669),(0.88189,0.45669),(0.88976,0.45669),(0.89764,0.45669),(0.90551,0.45669),(0.91339,0.45669),(0.92126,0.45669),(0.92913,0.45669),(0.93701,0.45669),(0.94488,0.45669),(0.95276,0.45669),(0.96063,0.45669),(0.9685,0.45669),(0.97638,0.45669),(0.98425,0.45669),(0.99213,0.45669),(0.99609,0.45669),(0.00391,0.46457),(0.00787,0.46457),(0.01575,0.46457),(0.02362,0.46457),(0.0315,0.46457),(0.03937,0.46457),(0.04724,0.46457),(0.05512,0.46457),(0.06299,0.46457),(0.07087,0.46457),(0.07874,0.46457),(0.08661,0.46457),(0.09449,0.46457),(0.10236,0.46457),(0.11024,0.46457),(0.11811,0.46457),(0.12598,0.46457),(0.13386,0.46457),(0.14173,0.46457),(0.14961,0.46457),(0.15748,0.46457),(0.16535,0.46457),(0.17323,0.46457),(0.1811,0.46457),(0.18898,0.46457),(0.19685,0.46457),(0.20472,0.46457),(0.2126,0.46457),(0.22047,0.46457),(0.22835,0.46457),(0.23622,0.46457),(0.24409,0.46457),(0.25197,0.46457),(0.25984,0.46457),(0.26772,0.46457),(0.27559,0.46457),(0.28346,0.46457),(0.29134,0.46457),(0.29921,0.46457),(0.30709,0.46457),(0.31496,0.46457),(0.32283,0.46457),(0.33071,0.46457),(0.33858,0.46457),(0.34646,0.46457),(0.35433,0.46457),(0.3622,0.46457),(0.37008,0.46457),(0.37795,0.46457),(0.38583,0.46457),(0.3937,0.46457),(0.40157,0.46457),(0.40945,0.46457),(0.41732,0.46457),(0.4252,0.46457),(0.43307,0.46457),(0.44094,0.46457),(0.44882,0.46457),(0.45669,0.46457),(0.46457,0.46457),(0.47244,0.46457),(0.48031,0.46457),(0.48819,0.46457),(0.49606,0.46457),(0.50394,0.46457),(0.51181,0.46457),(0.51969,0.46457),(0.52756,0.46457),(0.53543,0.46457),(0.54331,0.46457),(0.55118,0.46457),(0.55906,0.46457),(0.56693,0.46457),(0.5748,0.46457),(0.58268,0.46457),(0.59055,0.46457),(0.59843,0.46457),(0.6063,0.46457),(0.61417,0.46457),(0.62205,0.46457),(0.62992,0.46457),(0.6378,0.46457),(0.64567,0.46457),(0.65354,0.46457),(0.66142,0.46457),(0.66929,0.46457),(0.67717,0.46457),(0.68504,0.46457),(0.69291,0.46457),(0.70079,0.46457),(0.70866,0.46457),(0.71654,0.46457),(0.72441,0.46457),(0.73228,0.46457),(0.74016,0.46457),(0.74803,0.46457),(0.75591,0.46457),(0.76378,0.46457),(0.77165,0.46457),(0.77953,0.46457),(0.7874,0.46457),(0.79528,0.46457),(0.80315,0.46457),(0.81102,0.46457),(0.8189,0.46457),(0.82677,0.46457),(0.83465,0.46457),(0.84252,0.46457),(0.85039,0.46457),(0.85827,0.46457),(0.86614,0.46457),(0.87402,0.46457),(0.88189,0.46457),(0.88976,0.46457),(0.89764,0.46457),(0.90551,0.46457),(0.91339,0.46457),(0.92126,0.46457),(0.92913,0.46457),(0.93701,0.46457),(0.94488,0.46457),(0.95276,0.46457),(0.96063,0.46457),(0.9685,0.46457),(0.97638,0.46457),(0.98425,0.46457),(0.99213,0.46457),(0.99609,0.46457),(0.00391,0.47244),(0.00787,0.47244),(0.01575,0.47244),(0.02362,0.47244),(0.0315,0.47244),(0.03937,0.47244),(0.04724,0.47244),(0.05512,0.47244),(0.06299,0.47244),(0.07087,0.47244),(0.07874,0.47244),(0.08661,0.47244),(0.09449,0.47244),(0.10236,0.47244),(0.11024,0.47244),(0.11811,0.47244),(0.12598,0.47244),(0.13386,0.47244),(0.14173,0.47244),(0.14961,0.47244),(0.15748,0.47244),(0.16535,0.47244),(0.17323,0.47244),(0.1811,0.47244),(0.18898,0.47244),(0.19685,0.47244),(0.20472,0.47244),(0.2126,0.47244),(0.22047,0.47244),(0.22835,0.47244),(0.23622,0.47244),(0.24409,0.47244),(0.25197,0.47244),(0.25984,0.47244),(0.26772,0.47244),(0.27559,0.47244),(0.28346,0.47244),(0.29134,0.47244),(0.29921,0.47244),(0.30709,0.47244),(0.31496,0.47244),(0.32283,0.47244),(0.33071,0.47244),(0.33858,0.47244),(0.34646,0.47244),(0.35433,0.47244),(0.3622,0.47244),(0.37008,0.47244),(0.37795,0.47244),(0.38583,0.47244),(0.3937,0.47244),(0.40157,0.47244),(0.40945,0.47244),(0.41732,0.47244),(0.4252,0.47244),(0.43307,0.47244),(0.44094,0.47244),(0.44882,0.47244),(0.45669,0.47244),(0.46457,0.47244),(0.47244,0.47244),(0.48031,0.47244),(0.48819,0.47244),(0.49606,0.47244),(0.50394,0.47244),(0.51181,0.47244),(0.51969,0.47244),(0.52756,0.47244),(0.53543,0.47244),(0.54331,0.47244),(0.55118,0.47244),(0.55906,0.47244),(0.56693,0.47244),(0.5748,0.47244),(0.58268,0.47244),(0.59055,0.47244),(0.59843,0.47244),(0.6063,0.47244),(0.61417,0.47244),(0.62205,0.47244),(0.62992,0.47244),(0.6378,0.47244),(0.64567,0.47244),(0.65354,0.47244),(0.66142,0.47244),(0.66929,0.47244),(0.67717,0.47244),(0.68504,0.47244),(0.69291,0.47244),(0.70079,0.47244),(0.70866,0.47244),(0.71654,0.47244),(0.72441,0.47244),(0.73228,0.47244),(0.74016,0.47244),(0.74803,0.47244),(0.75591,0.47244),(0.76378,0.47244),(0.77165,0.47244),(0.77953,0.47244),(0.7874,0.47244),(0.79528,0.47244),(0.80315,0.47244),(0.81102,0.47244),(0.8189,0.47244),(0.82677,0.47244),(0.83465,0.47244),(0.84252,0.47244),(0.85039,0.47244),(0.85827,0.47244),(0.86614,0.47244),(0.87402,0.47244),(0.88189,0.47244),(0.88976,0.47244),(0.89764,0.47244),(0.90551,0.47244),(0.91339,0.47244),(0.92126,0.47244),(0.92913,0.47244),(0.93701,0.47244),(0.94488,0.47244),(0.95276,0.47244),(0.96063,0.47244),(0.9685,0.47244),(0.97638,0.47244),(0.98425,0.47244),(0.99213,0.47244),(0.99609,0.47244),(0.00391,0.48031),(0.00787,0.48031),(0.01575,0.48031),(0.02362,0.48031),(0.0315,0.48031),(0.03937,0.48031),(0.04724,0.48031),(0.05512,0.48031),(0.06299,0.48031),(0.07087,0.48031),(0.07874,0.48031),(0.08661,0.48031),(0.09449,0.48031),(0.10236,0.48031),(0.11024,0.48031),(0.11811,0.48031),(0.12598,0.48031),(0.13386,0.48031),(0.14173,0.48031),(0.14961,0.48031),(0.15748,0.48031),(0.16535,0.48031),(0.17323,0.48031),(0.1811,0.48031),(0.18898,0.48031),(0.19685,0.48031),(0.20472,0.48031),(0.2126,0.48031),(0.22047,0.48031),(0.22835,0.48031),(0.23622,0.48031),(0.24409,0.48031),(0.25197,0.48031),(0.25984,0.48031),(0.26772,0.48031),(0.27559,0.48031),(0.28346,0.48031),(0.29134,0.48031),(0.29921,0.48031),(0.30709,0.48031),(0.31496,0.48031),(0.32283,0.48031),(0.33071,0.48031),(0.33858,0.48031),(0.34646,0.48031),(0.35433,0.48031),(0.3622,0.48031),(0.37008,0.48031),(0.37795,0.48031),(0.38583,0.48031),(0.3937,0.48031),(0.40157,0.48031),(0.40945,0.48031),(0.41732,0.48031),(0.4252,0.48031),(0.43307,0.48031),(0.44094,0.48031),(0.44882,0.48031),(0.45669,0.48031),(0.46457,0.48031),(0.47244,0.48031),(0.48031,0.48031),(0.48819,0.48031),(0.49606,0.48031),(0.50394,0.48031),(0.51181,0.48031),(0.51969,0.48031),(0.52756,0.48031),(0.53543,0.48031),(0.54331,0.48031),(0.55118,0.48031),(0.55906,0.48031),(0.56693,0.48031),(0.5748,0.48031),(0.58268,0.48031),(0.59055,0.48031),(0.59843,0.48031),(0.6063,0.48031),(0.61417,0.48031),(0.62205,0.48031),(0.62992,0.48031),(0.6378,0.48031),(0.64567,0.48031),(0.65354,0.48031),(0.66142,0.48031),(0.66929,0.48031),(0.67717,0.48031),(0.68504,0.48031),(0.69291,0.48031),(0.70079,0.48031),(0.70866,0.48031),(0.71654,0.48031),(0.72441,0.48031),(0.73228,0.48031),(0.74016,0.48031),(0.74803,0.48031),(0.75591,0.48031),(0.76378,0.48031),(0.77165,0.48031),(0.77953,0.48031),(0.7874,0.48031),(0.79528,0.48031),(0.80315,0.48031),(0.81102,0.48031),(0.8189,0.48031),(0.82677,0.48031),(0.83465,0.48031),(0.84252,0.48031),(0.85039,0.48031),(0.85827,0.48031),(0.86614,0.48031),(0.87402,0.48031),(0.88189,0.48031),(0.88976,0.48031),(0.89764,0.48031),(0.90551,0.48031),(0.91339,0.48031),(0.92126,0.48031),(0.92913,0.48031),(0.93701,0.48031),(0.94488,0.48031),(0.95276,0.48031),(0.96063,0.48031),(0.9685,0.48031),(0.97638,0.48031),(0.98425,0.48031),(0.99213,0.48031),(0.99609,0.48031),(0.00391,0.48819),(0.00787,0.48819),(0.01575,0.48819),(0.02362,0.48819),(0.0315,0.48819),(0.03937,0.48819),(0.04724,0.48819),(0.05512,0.48819),(0.06299,0.48819),(0.07087,0.48819),(0.07874,0.48819),(0.08661,0.48819),(0.09449,0.48819),(0.10236,0.48819),(0.11024,0.48819),(0.11811,0.48819),(0.12598,0.48819),(0.13386,0.48819),(0.14173,0.48819),(0.14961,0.48819),(0.15748,0.48819),(0.16535,0.48819),(0.17323,0.48819),(0.1811,0.48819),(0.18898,0.48819),(0.19685,0.48819),(0.20472,0.48819),(0.2126,0.48819),(0.22047,0.48819),(0.22835,0.48819),(0.23622,0.48819),(0.24409,0.48819),(0.25197,0.48819),(0.25984,0.48819),(0.26772,0.48819),(0.27559,0.48819),(0.28346,0.48819),(0.29134,0.48819),(0.29921,0.48819),(0.30709,0.48819),(0.31496,0.48819),(0.32283,0.48819),(0.33071,0.48819),(0.33858,0.48819),(0.34646,0.48819),(0.35433,0.48819),(0.3622,0.48819),(0.37008,0.48819),(0.37795,0.48819),(0.38583,0.48819),(0.3937,0.48819),(0.40157,0.48819),(0.40945,0.48819),(0.41732,0.48819),(0.4252,0.48819),(0.43307,0.48819),(0.44094,0.48819),(0.44882,0.48819),(0.45669,0.48819),(0.46457,0.48819),(0.47244,0.48819),(0.48031,0.48819),(0.48819,0.48819),(0.49606,0.48819),(0.50394,0.48819),(0.51181,0.48819),(0.51969,0.48819),(0.52756,0.48819),(0.53543,0.48819),(0.54331,0.48819),(0.55118,0.48819),(0.55906,0.48819),(0.56693,0.48819),(0.5748,0.48819),(0.58268,0.48819),(0.59055,0.48819),(0.59843,0.48819),(0.6063,0.48819),(0.61417,0.48819),(0.62205,0.48819),(0.62992,0.48819),(0.6378,0.48819),(0.64567,0.48819),(0.65354,0.48819),(0.66142,0.48819),(0.66929,0.48819),(0.67717,0.48819),(0.68504,0.48819),(0.69291,0.48819),(0.70079,0.48819),(0.70866,0.48819),(0.71654,0.48819),(0.72441,0.48819),(0.73228,0.48819),(0.74016,0.48819),(0.74803,0.48819),(0.75591,0.48819),(0.76378,0.48819),(0.77165,0.48819),(0.77953,0.48819),(0.7874,0.48819),(0.79528,0.48819),(0.80315,0.48819),(0.81102,0.48819),(0.8189,0.48819),(0.82677,0.48819),(0.83465,0.48819),(0.84252,0.48819),(0.85039,0.48819),(0.85827,0.48819),(0.86614,0.48819),(0.87402,0.48819),(0.88189,0.48819),(0.88976,0.48819),(0.89764,0.48819),(0.90551,0.48819),(0.91339,0.48819),(0.92126,0.48819),(0.92913,0.48819),(0.93701,0.48819),(0.94488,0.48819),(0.95276,0.48819),(0.96063,0.48819),(0.9685,0.48819),(0.97638,0.48819),(0.98425,0.48819),(0.99213,0.48819),(0.99609,0.48819),(0.00391,0.49606),(0.00787,0.49606),(0.01575,0.49606),(0.02362,0.49606),(0.0315,0.49606),(0.03937,0.49606),(0.04724,0.49606),(0.05512,0.49606),(0.06299,0.49606),(0.07087,0.49606),(0.07874,0.49606),(0.08661,0.49606),(0.09449,0.49606),(0.10236,0.49606),(0.11024,0.49606),(0.11811,0.49606),(0.12598,0.49606),(0.13386,0.49606),(0.14173,0.49606),(0.14961,0.49606),(0.15748,0.49606),(0.16535,0.49606),(0.17323,0.49606),(0.1811,0.49606),(0.18898,0.49606),(0.19685,0.49606),(0.20472,0.49606),(0.2126,0.49606),(0.22047,0.49606),(0.22835,0.49606),(0.23622,0.49606),(0.24409,0.49606),(0.25197,0.49606),(0.25984,0.49606),(0.26772,0.49606),(0.27559,0.49606),(0.28346,0.49606),(0.29134,0.49606),(0.29921,0.49606),(0.30709,0.49606),(0.31496,0.49606),(0.32283,0.49606),(0.33071,0.49606),(0.33858,0.49606),(0.34646,0.49606),(0.35433,0.49606),(0.3622,0.49606),(0.37008,0.49606),(0.37795,0.49606),(0.38583,0.49606),(0.3937,0.49606),(0.40157,0.49606),(0.40945,0.49606),(0.41732,0.49606),(0.4252,0.49606),(0.43307,0.49606),(0.44094,0.49606),(0.44882,0.49606),(0.45669,0.49606),(0.46457,0.49606),(0.47244,0.49606),(0.48031,0.49606),(0.48819,0.49606),(0.49606,0.49606),(0.50394,0.49606),(0.51181,0.49606),(0.51969,0.49606),(0.52756,0.49606),(0.53543,0.49606),(0.54331,0.49606),(0.55118,0.49606),(0.55906,0.49606),(0.56693,0.49606),(0.5748,0.49606),(0.58268,0.49606),(0.59055,0.49606),(0.59843,0.49606),(0.6063,0.49606),(0.61417,0.49606),(0.62205,0.49606),(0.62992,0.49606),(0.6378,0.49606),(0.64567,0.49606),(0.65354,0.49606),(0.66142,0.49606),(0.66929,0.49606),(0.67717,0.49606),(0.68504,0.49606),(0.69291,0.49606),(0.70079,0.49606),(0.70866,0.49606),(0.71654,0.49606),(0.72441,0.49606),(0.73228,0.49606),(0.74016,0.49606),(0.74803,0.49606),(0.75591,0.49606),(0.76378,0.49606),(0.77165,0.49606),(0.77953,0.49606),(0.7874,0.49606),(0.79528,0.49606),(0.80315,0.49606),(0.81102,0.49606),(0.8189,0.49606),(0.82677,0.49606),(0.83465,0.49606),(0.84252,0.49606),(0.85039,0.49606),(0.85827,0.49606),(0.86614,0.49606),(0.87402,0.49606),(0.88189,0.49606),(0.88976,0.49606),(0.89764,0.49606),(0.90551,0.49606),(0.91339,0.49606),(0.92126,0.49606),(0.92913,0.49606),(0.93701,0.49606),(0.94488,0.49606),(0.95276,0.49606),(0.96063,0.49606),(0.9685,0.49606),(0.97638,0.49606),(0.98425,0.49606),(0.99213,0.49606),(0.99609,0.49606),(0.00391,0.50394),(0.00787,0.50394),(0.01575,0.50394),(0.02362,0.50394),(0.0315,0.50394),(0.03937,0.50394),(0.04724,0.50394),(0.05512,0.50394),(0.06299,0.50394),(0.07087,0.50394),(0.07874,0.50394),(0.08661,0.50394),(0.09449,0.50394),(0.10236,0.50394),(0.11024,0.50394),(0.11811,0.50394),(0.12598,0.50394),(0.13386,0.50394),(0.14173,0.50394),(0.14961,0.50394),(0.15748,0.50394),(0.16535,0.50394),(0.17323,0.50394),(0.1811,0.50394),(0.18898,0.50394),(0.19685,0.50394),(0.20472,0.50394),(0.2126,0.50394),(0.22047,0.50394),(0.22835,0.50394),(0.23622,0.50394),(0.24409,0.50394),(0.25197,0.50394),(0.25984,0.50394),(0.26772,0.50394),(0.27559,0.50394),(0.28346,0.50394),(0.29134,0.50394),(0.29921,0.50394),(0.30709,0.50394),(0.31496,0.50394),(0.32283,0.50394),(0.33071,0.50394),(0.33858,0.50394),(0.34646,0.50394),(0.35433,0.50394),(0.3622,0.50394),(0.37008,0.50394),(0.37795,0.50394),(0.38583,0.50394),(0.3937,0.50394),(0.40157,0.50394),(0.40945,0.50394),(0.41732,0.50394),(0.4252,0.50394),(0.43307,0.50394),(0.44094,0.50394),(0.44882,0.50394),(0.45669,0.50394),(0.46457,0.50394),(0.47244,0.50394),(0.48031,0.50394),(0.48819,0.50394),(0.49606,0.50394),(0.50394,0.50394),(0.51181,0.50394),(0.51969,0.50394),(0.52756,0.50394),(0.53543,0.50394),(0.54331,0.50394),(0.55118,0.50394),(0.55906,0.50394),(0.56693,0.50394),(0.5748,0.50394),(0.58268,0.50394),(0.59055,0.50394),(0.59843,0.50394),(0.6063,0.50394),(0.61417,0.50394),(0.62205,0.50394),(0.62992,0.50394),(0.6378,0.50394),(0.64567,0.50394),(0.65354,0.50394),(0.66142,0.50394),(0.66929,0.50394),(0.67717,0.50394),(0.68504,0.50394),(0.69291,0.50394),(0.70079,0.50394),(0.70866,0.50394),(0.71654,0.50394),(0.72441,0.50394),(0.73228,0.50394),(0.74016,0.50394),(0.74803,0.50394),(0.75591,0.50394),(0.76378,0.50394),(0.77165,0.50394),(0.77953,0.50394),(0.7874,0.50394),(0.79528,0.50394),(0.80315,0.50394),(0.81102,0.50394),(0.8189,0.50394),(0.82677,0.50394),(0.83465,0.50394),(0.84252,0.50394),(0.85039,0.50394),(0.85827,0.50394),(0.86614,0.50394),(0.87402,0.50394),(0.88189,0.50394),(0.88976,0.50394),(0.89764,0.50394),(0.90551,0.50394),(0.91339,0.50394),(0.92126,0.50394),(0.92913,0.50394),(0.93701,0.50394),(0.94488,0.50394),(0.95276,0.50394),(0.96063,0.50394),(0.9685,0.50394),(0.97638,0.50394),(0.98425,0.50394),(0.99213,0.50394),(0.99609,0.50394),(0.00391,0.51181),(0.00787,0.51181),(0.01575,0.51181),(0.02362,0.51181),(0.0315,0.51181),(0.03937,0.51181),(0.04724,0.51181),(0.05512,0.51181),(0.06299,0.51181),(0.07087,0.51181),(0.07874,0.51181),(0.08661,0.51181),(0.09449,0.51181),(0.10236,0.51181),(0.11024,0.51181),(0.11811,0.51181),(0.12598,0.51181),(0.13386,0.51181),(0.14173,0.51181),(0.14961,0.51181),(0.15748,0.51181),(0.16535,0.51181),(0.17323,0.51181),(0.1811,0.51181),(0.18898,0.51181),(0.19685,0.51181),(0.20472,0.51181),(0.2126,0.51181),(0.22047,0.51181),(0.22835,0.51181),(0.23622,0.51181),(0.24409,0.51181),(0.25197,0.51181),(0.25984,0.51181),(0.26772,0.51181),(0.27559,0.51181),(0.28346,0.51181),(0.29134,0.51181),(0.29921,0.51181),(0.30709,0.51181),(0.31496,0.51181),(0.32283,0.51181),(0.33071,0.51181),(0.33858,0.51181),(0.34646,0.51181),(0.35433,0.51181),(0.3622,0.51181),(0.37008,0.51181),(0.37795,0.51181),(0.38583,0.51181),(0.3937,0.51181),(0.40157,0.51181),(0.40945,0.51181),(0.41732,0.51181),(0.4252,0.51181),(0.43307,0.51181),(0.44094,0.51181),(0.44882,0.51181),(0.45669,0.51181),(0.46457,0.51181),(0.47244,0.51181),(0.48031,0.51181),(0.48819,0.51181),(0.49606,0.51181),(0.50394,0.51181),(0.51181,0.51181),(0.51969,0.51181),(0.52756,0.51181),(0.53543,0.51181),(0.54331,0.51181),(0.55118,0.51181),(0.55906,0.51181),(0.56693,0.51181),(0.5748,0.51181),(0.58268,0.51181),(0.59055,0.51181),(0.59843,0.51181),(0.6063,0.51181),(0.61417,0.51181),(0.62205,0.51181),(0.62992,0.51181),(0.6378,0.51181),(0.64567,0.51181),(0.65354,0.51181),(0.66142,0.51181),(0.66929,0.51181),(0.67717,0.51181),(0.68504,0.51181),(0.69291,0.51181),(0.70079,0.51181),(0.70866,0.51181),(0.71654,0.51181),(0.72441,0.51181),(0.73228,0.51181),(0.74016,0.51181),(0.74803,0.51181),(0.75591,0.51181),(0.76378,0.51181),(0.77165,0.51181),(0.77953,0.51181),(0.7874,0.51181),(0.79528,0.51181),(0.80315,0.51181),(0.81102,0.51181),(0.8189,0.51181),(0.82677,0.51181),(0.83465,0.51181),(0.84252,0.51181),(0.85039,0.51181),(0.85827,0.51181),(0.86614,0.51181),(0.87402,0.51181),(0.88189,0.51181),(0.88976,0.51181),(0.89764,0.51181),(0.90551,0.51181),(0.91339,0.51181),(0.92126,0.51181),(0.92913,0.51181),(0.93701,0.51181),(0.94488,0.51181),(0.95276,0.51181),(0.96063,0.51181),(0.9685,0.51181),(0.97638,0.51181),(0.98425,0.51181),(0.99213,0.51181),(0.99609,0.51181),(0.00391,0.51969),(0.00787,0.51969),(0.01575,0.51969),(0.02362,0.51969),(0.0315,0.51969),(0.03937,0.51969),(0.04724,0.51969),(0.05512,0.51969),(0.06299,0.51969),(0.07087,0.51969),(0.07874,0.51969),(0.08661,0.51969),(0.09449,0.51969),(0.10236,0.51969),(0.11024,0.51969),(0.11811,0.51969),(0.12598,0.51969),(0.13386,0.51969),(0.14173,0.51969),(0.14961,0.51969),(0.15748,0.51969),(0.16535,0.51969),(0.17323,0.51969),(0.1811,0.51969),(0.18898,0.51969),(0.19685,0.51969),(0.20472,0.51969),(0.2126,0.51969),(0.22047,0.51969),(0.22835,0.51969),(0.23622,0.51969),(0.24409,0.51969),(0.25197,0.51969),(0.25984,0.51969),(0.26772,0.51969),(0.27559,0.51969),(0.28346,0.51969),(0.29134,0.51969),(0.29921,0.51969),(0.30709,0.51969),(0.31496,0.51969),(0.32283,0.51969),(0.33071,0.51969),(0.33858,0.51969),(0.34646,0.51969),(0.35433,0.51969),(0.3622,0.51969),(0.37008,0.51969),(0.37795,0.51969),(0.38583,0.51969),(0.3937,0.51969),(0.40157,0.51969),(0.40945,0.51969),(0.41732,0.51969),(0.4252,0.51969),(0.43307,0.51969),(0.44094,0.51969),(0.44882,0.51969),(0.45669,0.51969),(0.46457,0.51969),(0.47244,0.51969),(0.48031,0.51969),(0.48819,0.51969),(0.49606,0.51969),(0.50394,0.51969),(0.51181,0.51969),(0.51969,0.51969),(0.52756,0.51969),(0.53543,0.51969),(0.54331,0.51969),(0.55118,0.51969),(0.55906,0.51969),(0.56693,0.51969),(0.5748,0.51969),(0.58268,0.51969),(0.59055,0.51969),(0.59843,0.51969),(0.6063,0.51969),(0.61417,0.51969),(0.62205,0.51969),(0.62992,0.51969),(0.6378,0.51969),(0.64567,0.51969),(0.65354,0.51969),(0.66142,0.51969),(0.66929,0.51969),(0.67717,0.51969),(0.68504,0.51969),(0.69291,0.51969),(0.70079,0.51969),(0.70866,0.51969),(0.71654,0.51969),(0.72441,0.51969),(0.73228,0.51969),(0.74016,0.51969),(0.74803,0.51969),(0.75591,0.51969),(0.76378,0.51969),(0.77165,0.51969),(0.77953,0.51969),(0.7874,0.51969),(0.79528,0.51969),(0.80315,0.51969),(0.81102,0.51969),(0.8189,0.51969),(0.82677,0.51969),(0.83465,0.51969),(0.84252,0.51969),(0.85039,0.51969),(0.85827,0.51969),(0.86614,0.51969),(0.87402,0.51969),(0.88189,0.51969),(0.88976,0.51969),(0.89764,0.51969),(0.90551,0.51969),(0.91339,0.51969),(0.92126,0.51969),(0.92913,0.51969),(0.93701,0.51969),(0.94488,0.51969),(0.95276,0.51969),(0.96063,0.51969),(0.9685,0.51969),(0.97638,0.51969),(0.98425,0.51969),(0.99213,0.51969),(0.99609,0.51969),(0.00391,0.52756),(0.00787,0.52756),(0.01575,0.52756),(0.02362,0.52756),(0.0315,0.52756),(0.03937,0.52756),(0.04724,0.52756),(0.05512,0.52756),(0.06299,0.52756),(0.07087,0.52756),(0.07874,0.52756),(0.08661,0.52756),(0.09449,0.52756),(0.10236,0.52756),(0.11024,0.52756),(0.11811,0.52756),(0.12598,0.52756),(0.13386,0.52756),(0.14173,0.52756),(0.14961,0.52756),(0.15748,0.52756),(0.16535,0.52756),(0.17323,0.52756),(0.1811,0.52756),(0.18898,0.52756),(0.19685,0.52756),(0.20472,0.52756),(0.2126,0.52756),(0.22047,0.52756),(0.22835,0.52756),(0.23622,0.52756),(0.24409,0.52756),(0.25197,0.52756),(0.25984,0.52756),(0.26772,0.52756),(0.27559,0.52756),(0.28346,0.52756),(0.29134,0.52756),(0.29921,0.52756),(0.30709,0.52756),(0.31496,0.52756),(0.32283,0.52756),(0.33071,0.52756),(0.33858,0.52756),(0.34646,0.52756),(0.35433,0.52756),(0.3622,0.52756),(0.37008,0.52756),(0.37795,0.52756),(0.38583,0.52756),(0.3937,0.52756),(0.40157,0.52756),(0.40945,0.52756),(0.41732,0.52756),(0.4252,0.52756),(0.43307,0.52756),(0.44094,0.52756),(0.44882,0.52756),(0.45669,0.52756),(0.46457,0.52756),(0.47244,0.52756),(0.48031,0.52756),(0.48819,0.52756),(0.49606,0.52756),(0.50394,0.52756),(0.51181,0.52756),(0.51969,0.52756),(0.52756,0.52756),(0.53543,0.52756),(0.54331,0.52756),(0.55118,0.52756),(0.55906,0.52756),(0.56693,0.52756),(0.5748,0.52756),(0.58268,0.52756),(0.59055,0.52756),(0.59843,0.52756),(0.6063,0.52756),(0.61417,0.52756),(0.62205,0.52756),(0.62992,0.52756),(0.6378,0.52756),(0.64567,0.52756),(0.65354,0.52756),(0.66142,0.52756),(0.66929,0.52756),(0.67717,0.52756),(0.68504,0.52756),(0.69291,0.52756),(0.70079,0.52756),(0.70866,0.52756),(0.71654,0.52756),(0.72441,0.52756),(0.73228,0.52756),(0.74016,0.52756),(0.74803,0.52756),(0.75591,0.52756),(0.76378,0.52756),(0.77165,0.52756),(0.77953,0.52756),(0.7874,0.52756),(0.79528,0.52756),(0.80315,0.52756),(0.81102,0.52756),(0.8189,0.52756),(0.82677,0.52756),(0.83465,0.52756),(0.84252,0.52756),(0.85039,0.52756),(0.85827,0.52756),(0.86614,0.52756),(0.87402,0.52756),(0.88189,0.52756),(0.88976,0.52756),(0.89764,0.52756),(0.90551,0.52756),(0.91339,0.52756),(0.92126,0.52756),(0.92913,0.52756),(0.93701,0.52756),(0.94488,0.52756),(0.95276,0.52756),(0.96063,0.52756),(0.9685,0.52756),(0.97638,0.52756),(0.98425,0.52756),(0.99213,0.52756),(0.99609,0.52756),(0.00391,0.53543),(0.00787,0.53543),(0.01575,0.53543),(0.02362,0.53543),(0.0315,0.53543),(0.03937,0.53543),(0.04724,0.53543),(0.05512,0.53543),(0.06299,0.53543),(0.07087,0.53543),(0.07874,0.53543),(0.08661,0.53543),(0.09449,0.53543),(0.10236,0.53543),(0.11024,0.53543),(0.11811,0.53543),(0.12598,0.53543),(0.13386,0.53543),(0.14173,0.53543),(0.14961,0.53543),(0.15748,0.53543),(0.16535,0.53543),(0.17323,0.53543),(0.1811,0.53543),(0.18898,0.53543),(0.19685,0.53543),(0.20472,0.53543),(0.2126,0.53543),(0.22047,0.53543),(0.22835,0.53543),(0.23622,0.53543),(0.24409,0.53543),(0.25197,0.53543),(0.25984,0.53543),(0.26772,0.53543),(0.27559,0.53543),(0.28346,0.53543),(0.29134,0.53543),(0.29921,0.53543),(0.30709,0.53543),(0.31496,0.53543),(0.32283,0.53543),(0.33071,0.53543),(0.33858,0.53543),(0.34646,0.53543),(0.35433,0.53543),(0.3622,0.53543),(0.37008,0.53543),(0.37795,0.53543),(0.38583,0.53543),(0.3937,0.53543),(0.40157,0.53543),(0.40945,0.53543),(0.41732,0.53543),(0.4252,0.53543),(0.43307,0.53543),(0.44094,0.53543),(0.44882,0.53543),(0.45669,0.53543),(0.46457,0.53543),(0.47244,0.53543),(0.48031,0.53543),(0.48819,0.53543),(0.49606,0.53543),(0.50394,0.53543),(0.51181,0.53543),(0.51969,0.53543),(0.52756,0.53543),(0.53543,0.53543),(0.54331,0.53543),(0.55118,0.53543),(0.55906,0.53543),(0.56693,0.53543),(0.5748,0.53543),(0.58268,0.53543),(0.59055,0.53543),(0.59843,0.53543),(0.6063,0.53543),(0.61417,0.53543),(0.62205,0.53543),(0.62992,0.53543),(0.6378,0.53543),(0.64567,0.53543),(0.65354,0.53543),(0.66142,0.53543),(0.66929,0.53543),(0.67717,0.53543),(0.68504,0.53543),(0.69291,0.53543),(0.70079,0.53543),(0.70866,0.53543),(0.71654,0.53543),(0.72441,0.53543),(0.73228,0.53543),(0.74016,0.53543),(0.74803,0.53543),(0.75591,0.53543),(0.76378,0.53543),(0.77165,0.53543),(0.77953,0.53543),(0.7874,0.53543),(0.79528,0.53543),(0.80315,0.53543),(0.81102,0.53543),(0.8189,0.53543),(0.82677,0.53543),(0.83465,0.53543),(0.84252,0.53543),(0.85039,0.53543),(0.85827,0.53543),(0.86614,0.53543),(0.87402,0.53543),(0.88189,0.53543),(0.88976,0.53543),(0.89764,0.53543),(0.90551,0.53543),(0.91339,0.53543),(0.92126,0.53543),(0.92913,0.53543),(0.93701,0.53543),(0.94488,0.53543),(0.95276,0.53543),(0.96063,0.53543),(0.9685,0.53543),(0.97638,0.53543),(0.98425,0.53543),(0.99213,0.53543),(0.99609,0.53543),(0.00391,0.54331),(0.00787,0.54331),(0.01575,0.54331),(0.02362,0.54331),(0.0315,0.54331),(0.03937,0.54331),(0.04724,0.54331),(0.05512,0.54331),(0.06299,0.54331),(0.07087,0.54331),(0.07874,0.54331),(0.08661,0.54331),(0.09449,0.54331),(0.10236,0.54331),(0.11024,0.54331),(0.11811,0.54331),(0.12598,0.54331),(0.13386,0.54331),(0.14173,0.54331),(0.14961,0.54331),(0.15748,0.54331),(0.16535,0.54331),(0.17323,0.54331),(0.1811,0.54331),(0.18898,0.54331),(0.19685,0.54331),(0.20472,0.54331),(0.2126,0.54331),(0.22047,0.54331),(0.22835,0.54331),(0.23622,0.54331),(0.24409,0.54331),(0.25197,0.54331),(0.25984,0.54331),(0.26772,0.54331),(0.27559,0.54331),(0.28346,0.54331),(0.29134,0.54331),(0.29921,0.54331),(0.30709,0.54331),(0.31496,0.54331),(0.32283,0.54331),(0.33071,0.54331),(0.33858,0.54331),(0.34646,0.54331),(0.35433,0.54331),(0.3622,0.54331),(0.37008,0.54331),(0.37795,0.54331),(0.38583,0.54331),(0.3937,0.54331),(0.40157,0.54331),(0.40945,0.54331),(0.41732,0.54331),(0.4252,0.54331),(0.43307,0.54331),(0.44094,0.54331),(0.44882,0.54331),(0.45669,0.54331),(0.46457,0.54331),(0.47244,0.54331),(0.48031,0.54331),(0.48819,0.54331),(0.49606,0.54331),(0.50394,0.54331),(0.51181,0.54331),(0.51969,0.54331),(0.52756,0.54331),(0.53543,0.54331),(0.54331,0.54331),(0.55118,0.54331),(0.55906,0.54331),(0.56693,0.54331),(0.5748,0.54331),(0.58268,0.54331),(0.59055,0.54331),(0.59843,0.54331),(0.6063,0.54331),(0.61417,0.54331),(0.62205,0.54331),(0.62992,0.54331),(0.6378,0.54331),(0.64567,0.54331),(0.65354,0.54331),(0.66142,0.54331),(0.66929,0.54331),(0.67717,0.54331),(0.68504,0.54331),(0.69291,0.54331),(0.70079,0.54331),(0.70866,0.54331),(0.71654,0.54331),(0.72441,0.54331),(0.73228,0.54331),(0.74016,0.54331),(0.74803,0.54331),(0.75591,0.54331),(0.76378,0.54331),(0.77165,0.54331),(0.77953,0.54331),(0.7874,0.54331),(0.79528,0.54331),(0.80315,0.54331),(0.81102,0.54331),(0.8189,0.54331),(0.82677,0.54331),(0.83465,0.54331),(0.84252,0.54331),(0.85039,0.54331),(0.85827,0.54331),(0.86614,0.54331),(0.87402,0.54331),(0.88189,0.54331),(0.88976,0.54331),(0.89764,0.54331),(0.90551,0.54331),(0.91339,0.54331),(0.92126,0.54331),(0.92913,0.54331),(0.93701,0.54331),(0.94488,0.54331),(0.95276,0.54331),(0.96063,0.54331),(0.9685,0.54331),(0.97638,0.54331),(0.98425,0.54331),(0.99213,0.54331),(0.99609,0.54331),(0.00391,0.55118),(0.00787,0.55118),(0.01575,0.55118),(0.02362,0.55118),(0.0315,0.55118),(0.03937,0.55118),(0.04724,0.55118),(0.05512,0.55118),(0.06299,0.55118),(0.07087,0.55118),(0.07874,0.55118),(0.08661,0.55118),(0.09449,0.55118),(0.10236,0.55118),(0.11024,0.55118),(0.11811,0.55118),(0.12598,0.55118),(0.13386,0.55118),(0.14173,0.55118),(0.14961,0.55118),(0.15748,0.55118),(0.16535,0.55118),(0.17323,0.55118),(0.1811,0.55118),(0.18898,0.55118),(0.19685,0.55118),(0.20472,0.55118),(0.2126,0.55118),(0.22047,0.55118),(0.22835,0.55118),(0.23622,0.55118),(0.24409,0.55118),(0.25197,0.55118),(0.25984,0.55118),(0.26772,0.55118),(0.27559,0.55118),(0.28346,0.55118),(0.29134,0.55118),(0.29921,0.55118),(0.30709,0.55118),(0.31496,0.55118),(0.32283,0.55118),(0.33071,0.55118),(0.33858,0.55118),(0.34646,0.55118),(0.35433,0.55118),(0.3622,0.55118),(0.37008,0.55118),(0.37795,0.55118),(0.38583,0.55118),(0.3937,0.55118),(0.40157,0.55118),(0.40945,0.55118),(0.41732,0.55118),(0.4252,0.55118),(0.43307,0.55118),(0.44094,0.55118),(0.44882,0.55118),(0.45669,0.55118),(0.46457,0.55118),(0.47244,0.55118),(0.48031,0.55118),(0.48819,0.55118),(0.49606,0.55118),(0.50394,0.55118),(0.51181,0.55118),(0.51969,0.55118),(0.52756,0.55118),(0.53543,0.55118),(0.54331,0.55118),(0.55118,0.55118),(0.55906,0.55118),(0.56693,0.55118),(0.5748,0.55118),(0.58268,0.55118),(0.59055,0.55118),(0.59843,0.55118),(0.6063,0.55118),(0.61417,0.55118),(0.62205,0.55118),(0.62992,0.55118),(0.6378,0.55118),(0.64567,0.55118),(0.65354,0.55118),(0.66142,0.55118),(0.66929,0.55118),(0.67717,0.55118),(0.68504,0.55118),(0.69291,0.55118),(0.70079,0.55118),(0.70866,0.55118),(0.71654,0.55118),(0.72441,0.55118),(0.73228,0.55118),(0.74016,0.55118),(0.74803,0.55118),(0.75591,0.55118),(0.76378,0.55118),(0.77165,0.55118),(0.77953,0.55118),(0.7874,0.55118),(0.79528,0.55118),(0.80315,0.55118),(0.81102,0.55118),(0.8189,0.55118),(0.82677,0.55118),(0.83465,0.55118),(0.84252,0.55118),(0.85039,0.55118),(0.85827,0.55118),(0.86614,0.55118),(0.87402,0.55118),(0.88189,0.55118),(0.88976,0.55118),(0.89764,0.55118),(0.90551,0.55118),(0.91339,0.55118),(0.92126,0.55118),(0.92913,0.55118),(0.93701,0.55118),(0.94488,0.55118),(0.95276,0.55118),(0.96063,0.55118),(0.9685,0.55118),(0.97638,0.55118),(0.98425,0.55118),(0.99213,0.55118),(0.99609,0.55118),(0.00391,0.55906),(0.00787,0.55906),(0.01575,0.55906),(0.02362,0.55906),(0.0315,0.55906),(0.03937,0.55906),(0.04724,0.55906),(0.05512,0.55906),(0.06299,0.55906),(0.07087,0.55906),(0.07874,0.55906),(0.08661,0.55906),(0.09449,0.55906),(0.10236,0.55906),(0.11024,0.55906),(0.11811,0.55906),(0.12598,0.55906),(0.13386,0.55906),(0.14173,0.55906),(0.14961,0.55906),(0.15748,0.55906),(0.16535,0.55906),(0.17323,0.55906),(0.1811,0.55906),(0.18898,0.55906),(0.19685,0.55906),(0.20472,0.55906),(0.2126,0.55906),(0.22047,0.55906),(0.22835,0.55906),(0.23622,0.55906),(0.24409,0.55906),(0.25197,0.55906),(0.25984,0.55906),(0.26772,0.55906),(0.27559,0.55906),(0.28346,0.55906),(0.29134,0.55906),(0.29921,0.55906),(0.30709,0.55906),(0.31496,0.55906),(0.32283,0.55906),(0.33071,0.55906),(0.33858,0.55906),(0.34646,0.55906),(0.35433,0.55906),(0.3622,0.55906),(0.37008,0.55906),(0.37795,0.55906),(0.38583,0.55906),(0.3937,0.55906),(0.40157,0.55906),(0.40945,0.55906),(0.41732,0.55906),(0.4252,0.55906),(0.43307,0.55906),(0.44094,0.55906),(0.44882,0.55906),(0.45669,0.55906),(0.46457,0.55906),(0.47244,0.55906),(0.48031,0.55906),(0.48819,0.55906),(0.49606,0.55906),(0.50394,0.55906),(0.51181,0.55906),(0.51969,0.55906),(0.52756,0.55906),(0.53543,0.55906),(0.54331,0.55906),(0.55118,0.55906),(0.55906,0.55906),(0.56693,0.55906),(0.5748,0.55906),(0.58268,0.55906),(0.59055,0.55906),(0.59843,0.55906),(0.6063,0.55906),(0.61417,0.55906),(0.62205,0.55906),(0.62992,0.55906),(0.6378,0.55906),(0.64567,0.55906),(0.65354,0.55906),(0.66142,0.55906),(0.66929,0.55906),(0.67717,0.55906),(0.68504,0.55906),(0.69291,0.55906),(0.70079,0.55906),(0.70866,0.55906),(0.71654,0.55906),(0.72441,0.55906),(0.73228,0.55906),(0.74016,0.55906),(0.74803,0.55906),(0.75591,0.55906),(0.76378,0.55906),(0.77165,0.55906),(0.77953,0.55906),(0.7874,0.55906),(0.79528,0.55906),(0.80315,0.55906),(0.81102,0.55906),(0.8189,0.55906),(0.82677,0.55906),(0.83465,0.55906),(0.84252,0.55906),(0.85039,0.55906),(0.85827,0.55906),(0.86614,0.55906),(0.87402,0.55906),(0.88189,0.55906),(0.88976,0.55906),(0.89764,0.55906),(0.90551,0.55906),(0.91339,0.55906),(0.92126,0.55906),(0.92913,0.55906),(0.93701,0.55906),(0.94488,0.55906),(0.95276,0.55906),(0.96063,0.55906),(0.9685,0.55906),(0.97638,0.55906),(0.98425,0.55906),(0.99213,0.55906),(0.99609,0.55906),(0.00391,0.56693),(0.00787,0.56693),(0.01575,0.56693),(0.02362,0.56693),(0.0315,0.56693),(0.03937,0.56693),(0.04724,0.56693),(0.05512,0.56693),(0.06299,0.56693),(0.07087,0.56693),(0.07874,0.56693),(0.08661,0.56693),(0.09449,0.56693),(0.10236,0.56693),(0.11024,0.56693),(0.11811,0.56693),(0.12598,0.56693),(0.13386,0.56693),(0.14173,0.56693),(0.14961,0.56693),(0.15748,0.56693),(0.16535,0.56693),(0.17323,0.56693),(0.1811,0.56693),(0.18898,0.56693),(0.19685,0.56693),(0.20472,0.56693),(0.2126,0.56693),(0.22047,0.56693),(0.22835,0.56693),(0.23622,0.56693),(0.24409,0.56693),(0.25197,0.56693),(0.25984,0.56693),(0.26772,0.56693),(0.27559,0.56693),(0.28346,0.56693),(0.29134,0.56693),(0.29921,0.56693),(0.30709,0.56693),(0.31496,0.56693),(0.32283,0.56693),(0.33071,0.56693),(0.33858,0.56693),(0.34646,0.56693),(0.35433,0.56693),(0.3622,0.56693),(0.37008,0.56693),(0.37795,0.56693),(0.38583,0.56693),(0.3937,0.56693),(0.40157,0.56693),(0.40945,0.56693),(0.41732,0.56693),(0.4252,0.56693),(0.43307,0.56693),(0.44094,0.56693),(0.44882,0.56693),(0.45669,0.56693),(0.46457,0.56693),(0.47244,0.56693),(0.48031,0.56693),(0.48819,0.56693),(0.49606,0.56693),(0.50394,0.56693),(0.51181,0.56693),(0.51969,0.56693),(0.52756,0.56693),(0.53543,0.56693),(0.54331,0.56693),(0.55118,0.56693),(0.55906,0.56693),(0.56693,0.56693),(0.5748,0.56693),(0.58268,0.56693),(0.59055,0.56693),(0.59843,0.56693),(0.6063,0.56693),(0.61417,0.56693),(0.62205,0.56693),(0.62992,0.56693),(0.6378,0.56693),(0.64567,0.56693),(0.65354,0.56693),(0.66142,0.56693),(0.66929,0.56693),(0.67717,0.56693),(0.68504,0.56693),(0.69291,0.56693),(0.70079,0.56693),(0.70866,0.56693),(0.71654,0.56693),(0.72441,0.56693),(0.73228,0.56693),(0.74016,0.56693),(0.74803,0.56693),(0.75591,0.56693),(0.76378,0.56693),(0.77165,0.56693),(0.77953,0.56693),(0.7874,0.56693),(0.79528,0.56693),(0.80315,0.56693),(0.81102,0.56693),(0.8189,0.56693),(0.82677,0.56693),(0.83465,0.56693),(0.84252,0.56693),(0.85039,0.56693),(0.85827,0.56693),(0.86614,0.56693),(0.87402,0.56693),(0.88189,0.56693),(0.88976,0.56693),(0.89764,0.56693),(0.90551,0.56693),(0.91339,0.56693),(0.92126,0.56693),(0.92913,0.56693),(0.93701,0.56693),(0.94488,0.56693),(0.95276,0.56693),(0.96063,0.56693),(0.9685,0.56693),(0.97638,0.56693),(0.98425,0.56693),(0.99213,0.56693),(0.99609,0.56693),(0.00391,0.5748),(0.00787,0.5748),(0.01575,0.5748),(0.02362,0.5748),(0.0315,0.5748),(0.03937,0.5748),(0.04724,0.5748),(0.05512,0.5748),(0.06299,0.5748),(0.07087,0.5748),(0.07874,0.5748),(0.08661,0.5748),(0.09449,0.5748),(0.10236,0.5748),(0.11024,0.5748),(0.11811,0.5748),(0.12598,0.5748),(0.13386,0.5748),(0.14173,0.5748),(0.14961,0.5748),(0.15748,0.5748),(0.16535,0.5748),(0.17323,0.5748),(0.1811,0.5748),(0.18898,0.5748),(0.19685,0.5748),(0.20472,0.5748),(0.2126,0.5748),(0.22047,0.5748),(0.22835,0.5748),(0.23622,0.5748),(0.24409,0.5748),(0.25197,0.5748),(0.25984,0.5748),(0.26772,0.5748),(0.27559,0.5748),(0.28346,0.5748),(0.29134,0.5748),(0.29921,0.5748),(0.30709,0.5748),(0.31496,0.5748),(0.32283,0.5748),(0.33071,0.5748),(0.33858,0.5748),(0.34646,0.5748),(0.35433,0.5748),(0.3622,0.5748),(0.37008,0.5748),(0.37795,0.5748),(0.38583,0.5748),(0.3937,0.5748),(0.40157,0.5748),(0.40945,0.5748),(0.41732,0.5748),(0.4252,0.5748),(0.43307,0.5748),(0.44094,0.5748),(0.44882,0.5748),(0.45669,0.5748),(0.46457,0.5748),(0.47244,0.5748),(0.48031,0.5748),(0.48819,0.5748),(0.49606,0.5748),(0.50394,0.5748),(0.51181,0.5748),(0.51969,0.5748),(0.52756,0.5748),(0.53543,0.5748),(0.54331,0.5748),(0.55118,0.5748),(0.55906,0.5748),(0.56693,0.5748),(0.5748,0.5748),(0.58268,0.5748),(0.59055,0.5748),(0.59843,0.5748),(0.6063,0.5748),(0.61417,0.5748),(0.62205,0.5748),(0.62992,0.5748),(0.6378,0.5748),(0.64567,0.5748),(0.65354,0.5748),(0.66142,0.5748),(0.66929,0.5748),(0.67717,0.5748),(0.68504,0.5748),(0.69291,0.5748),(0.70079,0.5748),(0.70866,0.5748),(0.71654,0.5748),(0.72441,0.5748),(0.73228,0.5748),(0.74016,0.5748),(0.74803,0.5748),(0.75591,0.5748),(0.76378,0.5748),(0.77165,0.5748),(0.77953,0.5748),(0.7874,0.5748),(0.79528,0.5748),(0.80315,0.5748),(0.81102,0.5748),(0.8189,0.5748),(0.82677,0.5748),(0.83465,0.5748),(0.84252,0.5748),(0.85039,0.5748),(0.85827,0.5748),(0.86614,0.5748),(0.87402,0.5748),(0.88189,0.5748),(0.88976,0.5748),(0.89764,0.5748),(0.90551,0.5748),(0.91339,0.5748),(0.92126,0.5748),(0.92913,0.5748),(0.93701,0.5748),(0.94488,0.5748),(0.95276,0.5748),(0.96063,0.5748),(0.9685,0.5748),(0.97638,0.5748),(0.98425,0.5748),(0.99213,0.5748),(0.99609,0.5748),(0.00391,0.58268),(0.00787,0.58268),(0.01575,0.58268),(0.02362,0.58268),(0.0315,0.58268),(0.03937,0.58268),(0.04724,0.58268),(0.05512,0.58268),(0.06299,0.58268),(0.07087,0.58268),(0.07874,0.58268),(0.08661,0.58268),(0.09449,0.58268),(0.10236,0.58268),(0.11024,0.58268),(0.11811,0.58268),(0.12598,0.58268),(0.13386,0.58268),(0.14173,0.58268),(0.14961,0.58268),(0.15748,0.58268),(0.16535,0.58268),(0.17323,0.58268),(0.1811,0.58268),(0.18898,0.58268),(0.19685,0.58268),(0.20472,0.58268),(0.2126,0.58268),(0.22047,0.58268),(0.22835,0.58268),(0.23622,0.58268),(0.24409,0.58268),(0.25197,0.58268),(0.25984,0.58268),(0.26772,0.58268),(0.27559,0.58268),(0.28346,0.58268),(0.29134,0.58268),(0.29921,0.58268),(0.30709,0.58268),(0.31496,0.58268),(0.32283,0.58268),(0.33071,0.58268),(0.33858,0.58268),(0.34646,0.58268),(0.35433,0.58268),(0.3622,0.58268),(0.37008,0.58268),(0.37795,0.58268),(0.38583,0.58268),(0.3937,0.58268),(0.40157,0.58268),(0.40945,0.58268),(0.41732,0.58268),(0.4252,0.58268),(0.43307,0.58268),(0.44094,0.58268),(0.44882,0.58268),(0.45669,0.58268),(0.46457,0.58268),(0.47244,0.58268),(0.48031,0.58268),(0.48819,0.58268),(0.49606,0.58268),(0.50394,0.58268),(0.51181,0.58268),(0.51969,0.58268),(0.52756,0.58268),(0.53543,0.58268),(0.54331,0.58268),(0.55118,0.58268),(0.55906,0.58268),(0.56693,0.58268),(0.5748,0.58268),(0.58268,0.58268),(0.59055,0.58268),(0.59843,0.58268),(0.6063,0.58268),(0.61417,0.58268),(0.62205,0.58268),(0.62992,0.58268),(0.6378,0.58268),(0.64567,0.58268),(0.65354,0.58268),(0.66142,0.58268),(0.66929,0.58268),(0.67717,0.58268),(0.68504,0.58268),(0.69291,0.58268),(0.70079,0.58268),(0.70866,0.58268),(0.71654,0.58268),(0.72441,0.58268),(0.73228,0.58268),(0.74016,0.58268),(0.74803,0.58268),(0.75591,0.58268),(0.76378,0.58268),(0.77165,0.58268),(0.77953,0.58268),(0.7874,0.58268),(0.79528,0.58268),(0.80315,0.58268),(0.81102,0.58268),(0.8189,0.58268),(0.82677,0.58268),(0.83465,0.58268),(0.84252,0.58268),(0.85039,0.58268),(0.85827,0.58268),(0.86614,0.58268),(0.87402,0.58268),(0.88189,0.58268),(0.88976,0.58268),(0.89764,0.58268),(0.90551,0.58268),(0.91339,0.58268),(0.92126,0.58268),(0.92913,0.58268),(0.93701,0.58268),(0.94488,0.58268),(0.95276,0.58268),(0.96063,0.58268),(0.9685,0.58268),(0.97638,0.58268),(0.98425,0.58268),(0.99213,0.58268),(0.99609,0.58268),(0.00391,0.59055),(0.00787,0.59055),(0.01575,0.59055),(0.02362,0.59055),(0.0315,0.59055),(0.03937,0.59055),(0.04724,0.59055),(0.05512,0.59055),(0.06299,0.59055),(0.07087,0.59055),(0.07874,0.59055),(0.08661,0.59055),(0.09449,0.59055),(0.10236,0.59055),(0.11024,0.59055),(0.11811,0.59055),(0.12598,0.59055),(0.13386,0.59055),(0.14173,0.59055),(0.14961,0.59055),(0.15748,0.59055),(0.16535,0.59055),(0.17323,0.59055),(0.1811,0.59055),(0.18898,0.59055),(0.19685,0.59055),(0.20472,0.59055),(0.2126,0.59055),(0.22047,0.59055),(0.22835,0.59055),(0.23622,0.59055),(0.24409,0.59055),(0.25197,0.59055),(0.25984,0.59055),(0.26772,0.59055),(0.27559,0.59055),(0.28346,0.59055),(0.29134,0.59055),(0.29921,0.59055),(0.30709,0.59055),(0.31496,0.59055),(0.32283,0.59055),(0.33071,0.59055),(0.33858,0.59055),(0.34646,0.59055),(0.35433,0.59055),(0.3622,0.59055),(0.37008,0.59055),(0.37795,0.59055),(0.38583,0.59055),(0.3937,0.59055),(0.40157,0.59055),(0.40945,0.59055),(0.41732,0.59055),(0.4252,0.59055),(0.43307,0.59055),(0.44094,0.59055),(0.44882,0.59055),(0.45669,0.59055),(0.46457,0.59055),(0.47244,0.59055),(0.48031,0.59055),(0.48819,0.59055),(0.49606,0.59055),(0.50394,0.59055),(0.51181,0.59055),(0.51969,0.59055),(0.52756,0.59055),(0.53543,0.59055),(0.54331,0.59055),(0.55118,0.59055),(0.55906,0.59055),(0.56693,0.59055),(0.5748,0.59055),(0.58268,0.59055),(0.59055,0.59055),(0.59843,0.59055),(0.6063,0.59055),(0.61417,0.59055),(0.62205,0.59055),(0.62992,0.59055),(0.6378,0.59055),(0.64567,0.59055),(0.65354,0.59055),(0.66142,0.59055),(0.66929,0.59055),(0.67717,0.59055),(0.68504,0.59055),(0.69291,0.59055),(0.70079,0.59055),(0.70866,0.59055),(0.71654,0.59055),(0.72441,0.59055),(0.73228,0.59055),(0.74016,0.59055),(0.74803,0.59055),(0.75591,0.59055),(0.76378,0.59055),(0.77165,0.59055),(0.77953,0.59055),(0.7874,0.59055),(0.79528,0.59055),(0.80315,0.59055),(0.81102,0.59055),(0.8189,0.59055),(0.82677,0.59055),(0.83465,0.59055),(0.84252,0.59055),(0.85039,0.59055),(0.85827,0.59055),(0.86614,0.59055),(0.87402,0.59055),(0.88189,0.59055),(0.88976,0.59055),(0.89764,0.59055),(0.90551,0.59055),(0.91339,0.59055),(0.92126,0.59055),(0.92913,0.59055),(0.93701,0.59055),(0.94488,0.59055),(0.95276,0.59055),(0.96063,0.59055),(0.9685,0.59055),(0.97638,0.59055),(0.98425,0.59055),(0.99213,0.59055),(0.99609,0.59055),(0.00391,0.59843),(0.00787,0.59843),(0.01575,0.59843),(0.02362,0.59843),(0.0315,0.59843),(0.03937,0.59843),(0.04724,0.59843),(0.05512,0.59843),(0.06299,0.59843),(0.07087,0.59843),(0.07874,0.59843),(0.08661,0.59843),(0.09449,0.59843),(0.10236,0.59843),(0.11024,0.59843),(0.11811,0.59843),(0.12598,0.59843),(0.13386,0.59843),(0.14173,0.59843),(0.14961,0.59843),(0.15748,0.59843),(0.16535,0.59843),(0.17323,0.59843),(0.1811,0.59843),(0.18898,0.59843),(0.19685,0.59843),(0.20472,0.59843),(0.2126,0.59843),(0.22047,0.59843),(0.22835,0.59843),(0.23622,0.59843),(0.24409,0.59843),(0.25197,0.59843),(0.25984,0.59843),(0.26772,0.59843),(0.27559,0.59843),(0.28346,0.59843),(0.29134,0.59843),(0.29921,0.59843),(0.30709,0.59843),(0.31496,0.59843),(0.32283,0.59843),(0.33071,0.59843),(0.33858,0.59843),(0.34646,0.59843),(0.35433,0.59843),(0.3622,0.59843),(0.37008,0.59843),(0.37795,0.59843),(0.38583,0.59843),(0.3937,0.59843),(0.40157,0.59843),(0.40945,0.59843),(0.41732,0.59843),(0.4252,0.59843),(0.43307,0.59843),(0.44094,0.59843),(0.44882,0.59843),(0.45669,0.59843),(0.46457,0.59843),(0.47244,0.59843),(0.48031,0.59843),(0.48819,0.59843),(0.49606,0.59843),(0.50394,0.59843),(0.51181,0.59843),(0.51969,0.59843),(0.52756,0.59843),(0.53543,0.59843),(0.54331,0.59843),(0.55118,0.59843),(0.55906,0.59843),(0.56693,0.59843),(0.5748,0.59843),(0.58268,0.59843),(0.59055,0.59843),(0.59843,0.59843),(0.6063,0.59843),(0.61417,0.59843),(0.62205,0.59843),(0.62992,0.59843),(0.6378,0.59843),(0.64567,0.59843),(0.65354,0.59843),(0.66142,0.59843),(0.66929,0.59843),(0.67717,0.59843),(0.68504,0.59843),(0.69291,0.59843),(0.70079,0.59843),(0.70866,0.59843),(0.71654,0.59843),(0.72441,0.59843),(0.73228,0.59843),(0.74016,0.59843),(0.74803,0.59843),(0.75591,0.59843),(0.76378,0.59843),(0.77165,0.59843),(0.77953,0.59843),(0.7874,0.59843),(0.79528,0.59843),(0.80315,0.59843),(0.81102,0.59843),(0.8189,0.59843),(0.82677,0.59843),(0.83465,0.59843),(0.84252,0.59843),(0.85039,0.59843),(0.85827,0.59843),(0.86614,0.59843),(0.87402,0.59843),(0.88189,0.59843),(0.88976,0.59843),(0.89764,0.59843),(0.90551,0.59843),(0.91339,0.59843),(0.92126,0.59843),(0.92913,0.59843),(0.93701,0.59843),(0.94488,0.59843),(0.95276,0.59843),(0.96063,0.59843),(0.9685,0.59843),(0.97638,0.59843),(0.98425,0.59843),(0.99213,0.59843),(0.99609,0.59843),(0.00391,0.6063),(0.00787,0.6063),(0.01575,0.6063),(0.02362,0.6063),(0.0315,0.6063),(0.03937,0.6063),(0.04724,0.6063),(0.05512,0.6063),(0.06299,0.6063),(0.07087,0.6063),(0.07874,0.6063),(0.08661,0.6063),(0.09449,0.6063),(0.10236,0.6063),(0.11024,0.6063),(0.11811,0.6063),(0.12598,0.6063),(0.13386,0.6063),(0.14173,0.6063),(0.14961,0.6063),(0.15748,0.6063),(0.16535,0.6063),(0.17323,0.6063),(0.1811,0.6063),(0.18898,0.6063),(0.19685,0.6063),(0.20472,0.6063),(0.2126,0.6063),(0.22047,0.6063),(0.22835,0.6063),(0.23622,0.6063),(0.24409,0.6063),(0.25197,0.6063),(0.25984,0.6063),(0.26772,0.6063),(0.27559,0.6063),(0.28346,0.6063),(0.29134,0.6063),(0.29921,0.6063),(0.30709,0.6063),(0.31496,0.6063),(0.32283,0.6063),(0.33071,0.6063),(0.33858,0.6063),(0.34646,0.6063),(0.35433,0.6063),(0.3622,0.6063),(0.37008,0.6063),(0.37795,0.6063),(0.38583,0.6063),(0.3937,0.6063),(0.40157,0.6063),(0.40945,0.6063),(0.41732,0.6063),(0.4252,0.6063),(0.43307,0.6063),(0.44094,0.6063),(0.44882,0.6063),(0.45669,0.6063),(0.46457,0.6063),(0.47244,0.6063),(0.48031,0.6063),(0.48819,0.6063),(0.49606,0.6063),(0.50394,0.6063),(0.51181,0.6063),(0.51969,0.6063),(0.52756,0.6063),(0.53543,0.6063),(0.54331,0.6063),(0.55118,0.6063),(0.55906,0.6063),(0.56693,0.6063),(0.5748,0.6063),(0.58268,0.6063),(0.59055,0.6063),(0.59843,0.6063),(0.6063,0.6063),(0.61417,0.6063),(0.62205,0.6063),(0.62992,0.6063),(0.6378,0.6063),(0.64567,0.6063),(0.65354,0.6063),(0.66142,0.6063),(0.66929,0.6063),(0.67717,0.6063),(0.68504,0.6063),(0.69291,0.6063),(0.70079,0.6063),(0.70866,0.6063),(0.71654,0.6063),(0.72441,0.6063),(0.73228,0.6063),(0.74016,0.6063),(0.74803,0.6063),(0.75591,0.6063),(0.76378,0.6063),(0.77165,0.6063),(0.77953,0.6063),(0.7874,0.6063),(0.79528,0.6063),(0.80315,0.6063),(0.81102,0.6063),(0.8189,0.6063),(0.82677,0.6063),(0.83465,0.6063),(0.84252,0.6063),(0.85039,0.6063),(0.85827,0.6063),(0.86614,0.6063),(0.87402,0.6063),(0.88189,0.6063),(0.88976,0.6063),(0.89764,0.6063),(0.90551,0.6063),(0.91339,0.6063),(0.92126,0.6063),(0.92913,0.6063),(0.93701,0.6063),(0.94488,0.6063),(0.95276,0.6063),(0.96063,0.6063),(0.9685,0.6063),(0.97638,0.6063),(0.98425,0.6063),(0.99213,0.6063),(0.99609,0.6063),(0.00391,0.61417),(0.00787,0.61417),(0.01575,0.61417),(0.02362,0.61417),(0.0315,0.61417),(0.03937,0.61417),(0.04724,0.61417),(0.05512,0.61417),(0.06299,0.61417),(0.07087,0.61417),(0.07874,0.61417),(0.08661,0.61417),(0.09449,0.61417),(0.10236,0.61417),(0.11024,0.61417),(0.11811,0.61417),(0.12598,0.61417),(0.13386,0.61417),(0.14173,0.61417),(0.14961,0.61417),(0.15748,0.61417),(0.16535,0.61417),(0.17323,0.61417),(0.1811,0.61417),(0.18898,0.61417),(0.19685,0.61417),(0.20472,0.61417),(0.2126,0.61417),(0.22047,0.61417),(0.22835,0.61417),(0.23622,0.61417),(0.24409,0.61417),(0.25197,0.61417),(0.25984,0.61417),(0.26772,0.61417),(0.27559,0.61417),(0.28346,0.61417),(0.29134,0.61417),(0.29921,0.61417),(0.30709,0.61417),(0.31496,0.61417),(0.32283,0.61417),(0.33071,0.61417),(0.33858,0.61417),(0.34646,0.61417),(0.35433,0.61417),(0.3622,0.61417),(0.37008,0.61417),(0.37795,0.61417),(0.38583,0.61417),(0.3937,0.61417),(0.40157,0.61417),(0.40945,0.61417),(0.41732,0.61417),(0.4252,0.61417),(0.43307,0.61417),(0.44094,0.61417),(0.44882,0.61417),(0.45669,0.61417),(0.46457,0.61417),(0.47244,0.61417),(0.48031,0.61417),(0.48819,0.61417),(0.49606,0.61417),(0.50394,0.61417),(0.51181,0.61417),(0.51969,0.61417),(0.52756,0.61417),(0.53543,0.61417),(0.54331,0.61417),(0.55118,0.61417),(0.55906,0.61417),(0.56693,0.61417),(0.5748,0.61417),(0.58268,0.61417),(0.59055,0.61417),(0.59843,0.61417),(0.6063,0.61417),(0.61417,0.61417),(0.62205,0.61417),(0.62992,0.61417),(0.6378,0.61417),(0.64567,0.61417),(0.65354,0.61417),(0.66142,0.61417),(0.66929,0.61417),(0.67717,0.61417),(0.68504,0.61417),(0.69291,0.61417),(0.70079,0.61417),(0.70866,0.61417),(0.71654,0.61417),(0.72441,0.61417),(0.73228,0.61417),(0.74016,0.61417),(0.74803,0.61417),(0.75591,0.61417),(0.76378,0.61417),(0.77165,0.61417),(0.77953,0.61417),(0.7874,0.61417),(0.79528,0.61417),(0.80315,0.61417),(0.81102,0.61417),(0.8189,0.61417),(0.82677,0.61417),(0.83465,0.61417),(0.84252,0.61417),(0.85039,0.61417),(0.85827,0.61417),(0.86614,0.61417),(0.87402,0.61417),(0.88189,0.61417),(0.88976,0.61417),(0.89764,0.61417),(0.90551,0.61417),(0.91339,0.61417),(0.92126,0.61417),(0.92913,0.61417),(0.93701,0.61417),(0.94488,0.61417),(0.95276,0.61417),(0.96063,0.61417),(0.9685,0.61417),(0.97638,0.61417),(0.98425,0.61417),(0.99213,0.61417),(0.99609,0.61417),(0.00391,0.62205),(0.00787,0.62205),(0.01575,0.62205),(0.02362,0.62205),(0.0315,0.62205),(0.03937,0.62205),(0.04724,0.62205),(0.05512,0.62205),(0.06299,0.62205),(0.07087,0.62205),(0.07874,0.62205),(0.08661,0.62205),(0.09449,0.62205),(0.10236,0.62205),(0.11024,0.62205),(0.11811,0.62205),(0.12598,0.62205),(0.13386,0.62205),(0.14173,0.62205),(0.14961,0.62205),(0.15748,0.62205),(0.16535,0.62205),(0.17323,0.62205),(0.1811,0.62205),(0.18898,0.62205),(0.19685,0.62205),(0.20472,0.62205),(0.2126,0.62205),(0.22047,0.62205),(0.22835,0.62205),(0.23622,0.62205),(0.24409,0.62205),(0.25197,0.62205),(0.25984,0.62205),(0.26772,0.62205),(0.27559,0.62205),(0.28346,0.62205),(0.29134,0.62205),(0.29921,0.62205),(0.30709,0.62205),(0.31496,0.62205),(0.32283,0.62205),(0.33071,0.62205),(0.33858,0.62205),(0.34646,0.62205),(0.35433,0.62205),(0.3622,0.62205),(0.37008,0.62205),(0.37795,0.62205),(0.38583,0.62205),(0.3937,0.62205),(0.40157,0.62205),(0.40945,0.62205),(0.41732,0.62205),(0.4252,0.62205),(0.43307,0.62205),(0.44094,0.62205),(0.44882,0.62205),(0.45669,0.62205),(0.46457,0.62205),(0.47244,0.62205),(0.48031,0.62205),(0.48819,0.62205),(0.49606,0.62205),(0.50394,0.62205),(0.51181,0.62205),(0.51969,0.62205),(0.52756,0.62205),(0.53543,0.62205),(0.54331,0.62205),(0.55118,0.62205),(0.55906,0.62205),(0.56693,0.62205),(0.5748,0.62205),(0.58268,0.62205),(0.59055,0.62205),(0.59843,0.62205),(0.6063,0.62205),(0.61417,0.62205),(0.62205,0.62205),(0.62992,0.62205),(0.6378,0.62205),(0.64567,0.62205),(0.65354,0.62205),(0.66142,0.62205),(0.66929,0.62205),(0.67717,0.62205),(0.68504,0.62205),(0.69291,0.62205),(0.70079,0.62205),(0.70866,0.62205),(0.71654,0.62205),(0.72441,0.62205),(0.73228,0.62205),(0.74016,0.62205),(0.74803,0.62205),(0.75591,0.62205),(0.76378,0.62205),(0.77165,0.62205),(0.77953,0.62205),(0.7874,0.62205),(0.79528,0.62205),(0.80315,0.62205),(0.81102,0.62205),(0.8189,0.62205),(0.82677,0.62205),(0.83465,0.62205),(0.84252,0.62205),(0.85039,0.62205),(0.85827,0.62205),(0.86614,0.62205),(0.87402,0.62205),(0.88189,0.62205),(0.88976,0.62205),(0.89764,0.62205),(0.90551,0.62205),(0.91339,0.62205),(0.92126,0.62205),(0.92913,0.62205),(0.93701,0.62205),(0.94488,0.62205),(0.95276,0.62205),(0.96063,0.62205),(0.9685,0.62205),(0.97638,0.62205),(0.98425,0.62205),(0.99213,0.62205),(0.99609,0.62205),(0.00391,0.62992),(0.00787,0.62992),(0.01575,0.62992),(0.02362,0.62992),(0.0315,0.62992),(0.03937,0.62992),(0.04724,0.62992),(0.05512,0.62992),(0.06299,0.62992),(0.07087,0.62992),(0.07874,0.62992),(0.08661,0.62992),(0.09449,0.62992),(0.10236,0.62992),(0.11024,0.62992),(0.11811,0.62992),(0.12598,0.62992),(0.13386,0.62992),(0.14173,0.62992),(0.14961,0.62992),(0.15748,0.62992),(0.16535,0.62992),(0.17323,0.62992),(0.1811,0.62992),(0.18898,0.62992),(0.19685,0.62992),(0.20472,0.62992),(0.2126,0.62992),(0.22047,0.62992),(0.22835,0.62992),(0.23622,0.62992),(0.24409,0.62992),(0.25197,0.62992),(0.25984,0.62992),(0.26772,0.62992),(0.27559,0.62992),(0.28346,0.62992),(0.29134,0.62992),(0.29921,0.62992),(0.30709,0.62992),(0.31496,0.62992),(0.32283,0.62992),(0.33071,0.62992),(0.33858,0.62992),(0.34646,0.62992),(0.35433,0.62992),(0.3622,0.62992),(0.37008,0.62992),(0.37795,0.62992),(0.38583,0.62992),(0.3937,0.62992),(0.40157,0.62992),(0.40945,0.62992),(0.41732,0.62992),(0.4252,0.62992),(0.43307,0.62992),(0.44094,0.62992),(0.44882,0.62992),(0.45669,0.62992),(0.46457,0.62992),(0.47244,0.62992),(0.48031,0.62992),(0.48819,0.62992),(0.49606,0.62992),(0.50394,0.62992),(0.51181,0.62992),(0.51969,0.62992),(0.52756,0.62992),(0.53543,0.62992),(0.54331,0.62992),(0.55118,0.62992),(0.55906,0.62992),(0.56693,0.62992),(0.5748,0.62992),(0.58268,0.62992),(0.59055,0.62992),(0.59843,0.62992),(0.6063,0.62992),(0.61417,0.62992),(0.62205,0.62992),(0.62992,0.62992),(0.6378,0.62992),(0.64567,0.62992),(0.65354,0.62992),(0.66142,0.62992),(0.66929,0.62992),(0.67717,0.62992),(0.68504,0.62992),(0.69291,0.62992),(0.70079,0.62992),(0.70866,0.62992),(0.71654,0.62992),(0.72441,0.62992),(0.73228,0.62992),(0.74016,0.62992),(0.74803,0.62992),(0.75591,0.62992),(0.76378,0.62992),(0.77165,0.62992),(0.77953,0.62992),(0.7874,0.62992),(0.79528,0.62992),(0.80315,0.62992),(0.81102,0.62992),(0.8189,0.62992),(0.82677,0.62992),(0.83465,0.62992),(0.84252,0.62992),(0.85039,0.62992),(0.85827,0.62992),(0.86614,0.62992),(0.87402,0.62992),(0.88189,0.62992),(0.88976,0.62992),(0.89764,0.62992),(0.90551,0.62992),(0.91339,0.62992),(0.92126,0.62992),(0.92913,0.62992),(0.93701,0.62992),(0.94488,0.62992),(0.95276,0.62992),(0.96063,0.62992),(0.9685,0.62992),(0.97638,0.62992),(0.98425,0.62992),(0.99213,0.62992),(0.99609,0.62992),(0.00391,0.6378),(0.00787,0.6378),(0.01575,0.6378),(0.02362,0.6378),(0.0315,0.6378),(0.03937,0.6378),(0.04724,0.6378),(0.05512,0.6378),(0.06299,0.6378),(0.07087,0.6378),(0.07874,0.6378),(0.08661,0.6378),(0.09449,0.6378),(0.10236,0.6378),(0.11024,0.6378),(0.11811,0.6378),(0.12598,0.6378),(0.13386,0.6378),(0.14173,0.6378),(0.14961,0.6378),(0.15748,0.6378),(0.16535,0.6378),(0.17323,0.6378),(0.1811,0.6378),(0.18898,0.6378),(0.19685,0.6378),(0.20472,0.6378),(0.2126,0.6378),(0.22047,0.6378),(0.22835,0.6378),(0.23622,0.6378),(0.24409,0.6378),(0.25197,0.6378),(0.25984,0.6378),(0.26772,0.6378),(0.27559,0.6378),(0.28346,0.6378),(0.29134,0.6378),(0.29921,0.6378),(0.30709,0.6378),(0.31496,0.6378),(0.32283,0.6378),(0.33071,0.6378),(0.33858,0.6378),(0.34646,0.6378),(0.35433,0.6378),(0.3622,0.6378),(0.37008,0.6378),(0.37795,0.6378),(0.38583,0.6378),(0.3937,0.6378),(0.40157,0.6378),(0.40945,0.6378),(0.41732,0.6378),(0.4252,0.6378),(0.43307,0.6378),(0.44094,0.6378),(0.44882,0.6378),(0.45669,0.6378),(0.46457,0.6378),(0.47244,0.6378),(0.48031,0.6378),(0.48819,0.6378),(0.49606,0.6378),(0.50394,0.6378),(0.51181,0.6378),(0.51969,0.6378),(0.52756,0.6378),(0.53543,0.6378),(0.54331,0.6378),(0.55118,0.6378),(0.55906,0.6378),(0.56693,0.6378),(0.5748,0.6378),(0.58268,0.6378),(0.59055,0.6378),(0.59843,0.6378),(0.6063,0.6378),(0.61417,0.6378),(0.62205,0.6378),(0.62992,0.6378),(0.6378,0.6378),(0.64567,0.6378),(0.65354,0.6378),(0.66142,0.6378),(0.66929,0.6378),(0.67717,0.6378),(0.68504,0.6378),(0.69291,0.6378),(0.70079,0.6378),(0.70866,0.6378),(0.71654,0.6378),(0.72441,0.6378),(0.73228,0.6378),(0.74016,0.6378),(0.74803,0.6378),(0.75591,0.6378),(0.76378,0.6378),(0.77165,0.6378),(0.77953,0.6378),(0.7874,0.6378),(0.79528,0.6378),(0.80315,0.6378),(0.81102,0.6378),(0.8189,0.6378),(0.82677,0.6378),(0.83465,0.6378),(0.84252,0.6378),(0.85039,0.6378),(0.85827,0.6378),(0.86614,0.6378),(0.87402,0.6378),(0.88189,0.6378),(0.88976,0.6378),(0.89764,0.6378),(0.90551,0.6378),(0.91339,0.6378),(0.92126,0.6378),(0.92913,0.6378),(0.93701,0.6378),(0.94488,0.6378),(0.95276,0.6378),(0.96063,0.6378),(0.9685,0.6378),(0.97638,0.6378),(0.98425,0.6378),(0.99213,0.6378),(0.99609,0.6378),(0.00391,0.64567),(0.00787,0.64567),(0.01575,0.64567),(0.02362,0.64567),(0.0315,0.64567),(0.03937,0.64567),(0.04724,0.64567),(0.05512,0.64567),(0.06299,0.64567),(0.07087,0.64567),(0.07874,0.64567),(0.08661,0.64567),(0.09449,0.64567),(0.10236,0.64567),(0.11024,0.64567),(0.11811,0.64567),(0.12598,0.64567),(0.13386,0.64567),(0.14173,0.64567),(0.14961,0.64567),(0.15748,0.64567),(0.16535,0.64567),(0.17323,0.64567),(0.1811,0.64567),(0.18898,0.64567),(0.19685,0.64567),(0.20472,0.64567),(0.2126,0.64567),(0.22047,0.64567),(0.22835,0.64567),(0.23622,0.64567),(0.24409,0.64567),(0.25197,0.64567),(0.25984,0.64567),(0.26772,0.64567),(0.27559,0.64567),(0.28346,0.64567),(0.29134,0.64567),(0.29921,0.64567),(0.30709,0.64567),(0.31496,0.64567),(0.32283,0.64567),(0.33071,0.64567),(0.33858,0.64567),(0.34646,0.64567),(0.35433,0.64567),(0.3622,0.64567),(0.37008,0.64567),(0.37795,0.64567),(0.38583,0.64567),(0.3937,0.64567),(0.40157,0.64567),(0.40945,0.64567),(0.41732,0.64567),(0.4252,0.64567),(0.43307,0.64567),(0.44094,0.64567),(0.44882,0.64567),(0.45669,0.64567),(0.46457,0.64567),(0.47244,0.64567),(0.48031,0.64567),(0.48819,0.64567),(0.49606,0.64567),(0.50394,0.64567),(0.51181,0.64567),(0.51969,0.64567),(0.52756,0.64567),(0.53543,0.64567),(0.54331,0.64567),(0.55118,0.64567),(0.55906,0.64567),(0.56693,0.64567),(0.5748,0.64567),(0.58268,0.64567),(0.59055,0.64567),(0.59843,0.64567),(0.6063,0.64567),(0.61417,0.64567),(0.62205,0.64567),(0.62992,0.64567),(0.6378,0.64567),(0.64567,0.64567),(0.65354,0.64567),(0.66142,0.64567),(0.66929,0.64567),(0.67717,0.64567),(0.68504,0.64567),(0.69291,0.64567),(0.70079,0.64567),(0.70866,0.64567),(0.71654,0.64567),(0.72441,0.64567),(0.73228,0.64567),(0.74016,0.64567),(0.74803,0.64567),(0.75591,0.64567),(0.76378,0.64567),(0.77165,0.64567),(0.77953,0.64567),(0.7874,0.64567),(0.79528,0.64567),(0.80315,0.64567),(0.81102,0.64567),(0.8189,0.64567),(0.82677,0.64567),(0.83465,0.64567),(0.84252,0.64567),(0.85039,0.64567),(0.85827,0.64567),(0.86614,0.64567),(0.87402,0.64567),(0.88189,0.64567),(0.88976,0.64567),(0.89764,0.64567),(0.90551,0.64567),(0.91339,0.64567),(0.92126,0.64567),(0.92913,0.64567),(0.93701,0.64567),(0.94488,0.64567),(0.95276,0.64567),(0.96063,0.64567),(0.9685,0.64567),(0.97638,0.64567),(0.98425,0.64567),(0.99213,0.64567),(0.99609,0.64567),(0.00391,0.65354),(0.00787,0.65354),(0.01575,0.65354),(0.02362,0.65354),(0.0315,0.65354),(0.03937,0.65354),(0.04724,0.65354),(0.05512,0.65354),(0.06299,0.65354),(0.07087,0.65354),(0.07874,0.65354),(0.08661,0.65354),(0.09449,0.65354),(0.10236,0.65354),(0.11024,0.65354),(0.11811,0.65354),(0.12598,0.65354),(0.13386,0.65354),(0.14173,0.65354),(0.14961,0.65354),(0.15748,0.65354),(0.16535,0.65354),(0.17323,0.65354),(0.1811,0.65354),(0.18898,0.65354),(0.19685,0.65354),(0.20472,0.65354),(0.2126,0.65354),(0.22047,0.65354),(0.22835,0.65354),(0.23622,0.65354),(0.24409,0.65354),(0.25197,0.65354),(0.25984,0.65354),(0.26772,0.65354),(0.27559,0.65354),(0.28346,0.65354),(0.29134,0.65354),(0.29921,0.65354),(0.30709,0.65354),(0.31496,0.65354),(0.32283,0.65354),(0.33071,0.65354),(0.33858,0.65354),(0.34646,0.65354),(0.35433,0.65354),(0.3622,0.65354),(0.37008,0.65354),(0.37795,0.65354),(0.38583,0.65354),(0.3937,0.65354),(0.40157,0.65354),(0.40945,0.65354),(0.41732,0.65354),(0.4252,0.65354),(0.43307,0.65354),(0.44094,0.65354),(0.44882,0.65354),(0.45669,0.65354),(0.46457,0.65354),(0.47244,0.65354),(0.48031,0.65354),(0.48819,0.65354),(0.49606,0.65354),(0.50394,0.65354),(0.51181,0.65354),(0.51969,0.65354),(0.52756,0.65354),(0.53543,0.65354),(0.54331,0.65354),(0.55118,0.65354),(0.55906,0.65354),(0.56693,0.65354),(0.5748,0.65354),(0.58268,0.65354),(0.59055,0.65354),(0.59843,0.65354),(0.6063,0.65354),(0.61417,0.65354),(0.62205,0.65354),(0.62992,0.65354),(0.6378,0.65354),(0.64567,0.65354),(0.65354,0.65354),(0.66142,0.65354),(0.66929,0.65354),(0.67717,0.65354),(0.68504,0.65354),(0.69291,0.65354),(0.70079,0.65354),(0.70866,0.65354),(0.71654,0.65354),(0.72441,0.65354),(0.73228,0.65354),(0.74016,0.65354),(0.74803,0.65354),(0.75591,0.65354),(0.76378,0.65354),(0.77165,0.65354),(0.77953,0.65354),(0.7874,0.65354),(0.79528,0.65354),(0.80315,0.65354),(0.81102,0.65354),(0.8189,0.65354),(0.82677,0.65354),(0.83465,0.65354),(0.84252,0.65354),(0.85039,0.65354),(0.85827,0.65354),(0.86614,0.65354),(0.87402,0.65354),(0.88189,0.65354),(0.88976,0.65354),(0.89764,0.65354),(0.90551,0.65354),(0.91339,0.65354),(0.92126,0.65354),(0.92913,0.65354),(0.93701,0.65354),(0.94488,0.65354),(0.95276,0.65354),(0.96063,0.65354),(0.9685,0.65354),(0.97638,0.65354),(0.98425,0.65354),(0.99213,0.65354),(0.99609,0.65354),(0.00391,0.66142),(0.00787,0.66142),(0.01575,0.66142),(0.02362,0.66142),(0.0315,0.66142),(0.03937,0.66142),(0.04724,0.66142),(0.05512,0.66142),(0.06299,0.66142),(0.07087,0.66142),(0.07874,0.66142),(0.08661,0.66142),(0.09449,0.66142),(0.10236,0.66142),(0.11024,0.66142),(0.11811,0.66142),(0.12598,0.66142),(0.13386,0.66142),(0.14173,0.66142),(0.14961,0.66142),(0.15748,0.66142),(0.16535,0.66142),(0.17323,0.66142),(0.1811,0.66142),(0.18898,0.66142),(0.19685,0.66142),(0.20472,0.66142),(0.2126,0.66142),(0.22047,0.66142),(0.22835,0.66142),(0.23622,0.66142),(0.24409,0.66142),(0.25197,0.66142),(0.25984,0.66142),(0.26772,0.66142),(0.27559,0.66142),(0.28346,0.66142),(0.29134,0.66142),(0.29921,0.66142),(0.30709,0.66142),(0.31496,0.66142),(0.32283,0.66142),(0.33071,0.66142),(0.33858,0.66142),(0.34646,0.66142),(0.35433,0.66142),(0.3622,0.66142),(0.37008,0.66142),(0.37795,0.66142),(0.38583,0.66142),(0.3937,0.66142),(0.40157,0.66142),(0.40945,0.66142),(0.41732,0.66142),(0.4252,0.66142),(0.43307,0.66142),(0.44094,0.66142),(0.44882,0.66142),(0.45669,0.66142),(0.46457,0.66142),(0.47244,0.66142),(0.48031,0.66142),(0.48819,0.66142),(0.49606,0.66142),(0.50394,0.66142),(0.51181,0.66142),(0.51969,0.66142),(0.52756,0.66142),(0.53543,0.66142),(0.54331,0.66142),(0.55118,0.66142),(0.55906,0.66142),(0.56693,0.66142),(0.5748,0.66142),(0.58268,0.66142),(0.59055,0.66142),(0.59843,0.66142),(0.6063,0.66142),(0.61417,0.66142),(0.62205,0.66142),(0.62992,0.66142),(0.6378,0.66142),(0.64567,0.66142),(0.65354,0.66142),(0.66142,0.66142),(0.66929,0.66142),(0.67717,0.66142),(0.68504,0.66142),(0.69291,0.66142),(0.70079,0.66142),(0.70866,0.66142),(0.71654,0.66142),(0.72441,0.66142),(0.73228,0.66142),(0.74016,0.66142),(0.74803,0.66142),(0.75591,0.66142),(0.76378,0.66142),(0.77165,0.66142),(0.77953,0.66142),(0.7874,0.66142),(0.79528,0.66142),(0.80315,0.66142),(0.81102,0.66142),(0.8189,0.66142),(0.82677,0.66142),(0.83465,0.66142),(0.84252,0.66142),(0.85039,0.66142),(0.85827,0.66142),(0.86614,0.66142),(0.87402,0.66142),(0.88189,0.66142),(0.88976,0.66142),(0.89764,0.66142),(0.90551,0.66142),(0.91339,0.66142),(0.92126,0.66142),(0.92913,0.66142),(0.93701,0.66142),(0.94488,0.66142),(0.95276,0.66142),(0.96063,0.66142),(0.9685,0.66142),(0.97638,0.66142),(0.98425,0.66142),(0.99213,0.66142),(0.99609,0.66142),(0.00391,0.66929),(0.00787,0.66929),(0.01575,0.66929),(0.02362,0.66929),(0.0315,0.66929),(0.03937,0.66929),(0.04724,0.66929),(0.05512,0.66929),(0.06299,0.66929),(0.07087,0.66929),(0.07874,0.66929),(0.08661,0.66929),(0.09449,0.66929),(0.10236,0.66929),(0.11024,0.66929),(0.11811,0.66929),(0.12598,0.66929),(0.13386,0.66929),(0.14173,0.66929),(0.14961,0.66929),(0.15748,0.66929),(0.16535,0.66929),(0.17323,0.66929),(0.1811,0.66929),(0.18898,0.66929),(0.19685,0.66929),(0.20472,0.66929),(0.2126,0.66929),(0.22047,0.66929),(0.22835,0.66929),(0.23622,0.66929),(0.24409,0.66929),(0.25197,0.66929),(0.25984,0.66929),(0.26772,0.66929),(0.27559,0.66929),(0.28346,0.66929),(0.29134,0.66929),(0.29921,0.66929),(0.30709,0.66929),(0.31496,0.66929),(0.32283,0.66929),(0.33071,0.66929),(0.33858,0.66929),(0.34646,0.66929),(0.35433,0.66929),(0.3622,0.66929),(0.37008,0.66929),(0.37795,0.66929),(0.38583,0.66929),(0.3937,0.66929),(0.40157,0.66929),(0.40945,0.66929),(0.41732,0.66929),(0.4252,0.66929),(0.43307,0.66929),(0.44094,0.66929),(0.44882,0.66929),(0.45669,0.66929),(0.46457,0.66929),(0.47244,0.66929),(0.48031,0.66929),(0.48819,0.66929),(0.49606,0.66929),(0.50394,0.66929),(0.51181,0.66929),(0.51969,0.66929),(0.52756,0.66929),(0.53543,0.66929),(0.54331,0.66929),(0.55118,0.66929),(0.55906,0.66929),(0.56693,0.66929),(0.5748,0.66929),(0.58268,0.66929),(0.59055,0.66929),(0.59843,0.66929),(0.6063,0.66929),(0.61417,0.66929),(0.62205,0.66929),(0.62992,0.66929),(0.6378,0.66929),(0.64567,0.66929),(0.65354,0.66929),(0.66142,0.66929),(0.66929,0.66929),(0.67717,0.66929),(0.68504,0.66929),(0.69291,0.66929),(0.70079,0.66929),(0.70866,0.66929),(0.71654,0.66929),(0.72441,0.66929),(0.73228,0.66929),(0.74016,0.66929),(0.74803,0.66929),(0.75591,0.66929),(0.76378,0.66929),(0.77165,0.66929),(0.77953,0.66929),(0.7874,0.66929),(0.79528,0.66929),(0.80315,0.66929),(0.81102,0.66929),(0.8189,0.66929),(0.82677,0.66929),(0.83465,0.66929),(0.84252,0.66929),(0.85039,0.66929),(0.85827,0.66929),(0.86614,0.66929),(0.87402,0.66929),(0.88189,0.66929),(0.88976,0.66929),(0.89764,0.66929),(0.90551,0.66929),(0.91339,0.66929),(0.92126,0.66929),(0.92913,0.66929),(0.93701,0.66929),(0.94488,0.66929),(0.95276,0.66929),(0.96063,0.66929),(0.9685,0.66929),(0.97638,0.66929),(0.98425,0.66929),(0.99213,0.66929),(0.99609,0.66929),(0.00391,0.67717),(0.00787,0.67717),(0.01575,0.67717),(0.02362,0.67717),(0.0315,0.67717),(0.03937,0.67717),(0.04724,0.67717),(0.05512,0.67717),(0.06299,0.67717),(0.07087,0.67717),(0.07874,0.67717),(0.08661,0.67717),(0.09449,0.67717),(0.10236,0.67717),(0.11024,0.67717),(0.11811,0.67717),(0.12598,0.67717),(0.13386,0.67717),(0.14173,0.67717),(0.14961,0.67717),(0.15748,0.67717),(0.16535,0.67717),(0.17323,0.67717),(0.1811,0.67717),(0.18898,0.67717),(0.19685,0.67717),(0.20472,0.67717),(0.2126,0.67717),(0.22047,0.67717),(0.22835,0.67717),(0.23622,0.67717),(0.24409,0.67717),(0.25197,0.67717),(0.25984,0.67717),(0.26772,0.67717),(0.27559,0.67717),(0.28346,0.67717),(0.29134,0.67717),(0.29921,0.67717),(0.30709,0.67717),(0.31496,0.67717),(0.32283,0.67717),(0.33071,0.67717),(0.33858,0.67717),(0.34646,0.67717),(0.35433,0.67717),(0.3622,0.67717),(0.37008,0.67717),(0.37795,0.67717),(0.38583,0.67717),(0.3937,0.67717),(0.40157,0.67717),(0.40945,0.67717),(0.41732,0.67717),(0.4252,0.67717),(0.43307,0.67717),(0.44094,0.67717),(0.44882,0.67717),(0.45669,0.67717),(0.46457,0.67717),(0.47244,0.67717),(0.48031,0.67717),(0.48819,0.67717),(0.49606,0.67717),(0.50394,0.67717),(0.51181,0.67717),(0.51969,0.67717),(0.52756,0.67717),(0.53543,0.67717),(0.54331,0.67717),(0.55118,0.67717),(0.55906,0.67717),(0.56693,0.67717),(0.5748,0.67717),(0.58268,0.67717),(0.59055,0.67717),(0.59843,0.67717),(0.6063,0.67717),(0.61417,0.67717),(0.62205,0.67717),(0.62992,0.67717),(0.6378,0.67717),(0.64567,0.67717),(0.65354,0.67717),(0.66142,0.67717),(0.66929,0.67717),(0.67717,0.67717),(0.68504,0.67717),(0.69291,0.67717),(0.70079,0.67717),(0.70866,0.67717),(0.71654,0.67717),(0.72441,0.67717),(0.73228,0.67717),(0.74016,0.67717),(0.74803,0.67717),(0.75591,0.67717),(0.76378,0.67717),(0.77165,0.67717),(0.77953,0.67717),(0.7874,0.67717),(0.79528,0.67717),(0.80315,0.67717),(0.81102,0.67717),(0.8189,0.67717),(0.82677,0.67717),(0.83465,0.67717),(0.84252,0.67717),(0.85039,0.67717),(0.85827,0.67717),(0.86614,0.67717),(0.87402,0.67717),(0.88189,0.67717),(0.88976,0.67717),(0.89764,0.67717),(0.90551,0.67717),(0.91339,0.67717),(0.92126,0.67717),(0.92913,0.67717),(0.93701,0.67717),(0.94488,0.67717),(0.95276,0.67717),(0.96063,0.67717),(0.9685,0.67717),(0.97638,0.67717),(0.98425,0.67717),(0.99213,0.67717),(0.99609,0.67717),(0.00391,0.68504),(0.00787,0.68504),(0.01575,0.68504),(0.02362,0.68504),(0.0315,0.68504),(0.03937,0.68504),(0.04724,0.68504),(0.05512,0.68504),(0.06299,0.68504),(0.07087,0.68504),(0.07874,0.68504),(0.08661,0.68504),(0.09449,0.68504),(0.10236,0.68504),(0.11024,0.68504),(0.11811,0.68504),(0.12598,0.68504),(0.13386,0.68504),(0.14173,0.68504),(0.14961,0.68504),(0.15748,0.68504),(0.16535,0.68504),(0.17323,0.68504),(0.1811,0.68504),(0.18898,0.68504),(0.19685,0.68504),(0.20472,0.68504),(0.2126,0.68504),(0.22047,0.68504),(0.22835,0.68504),(0.23622,0.68504),(0.24409,0.68504),(0.25197,0.68504),(0.25984,0.68504),(0.26772,0.68504),(0.27559,0.68504),(0.28346,0.68504),(0.29134,0.68504),(0.29921,0.68504),(0.30709,0.68504),(0.31496,0.68504),(0.32283,0.68504),(0.33071,0.68504),(0.33858,0.68504),(0.34646,0.68504),(0.35433,0.68504),(0.3622,0.68504),(0.37008,0.68504),(0.37795,0.68504),(0.38583,0.68504),(0.3937,0.68504),(0.40157,0.68504),(0.40945,0.68504),(0.41732,0.68504),(0.4252,0.68504),(0.43307,0.68504),(0.44094,0.68504),(0.44882,0.68504),(0.45669,0.68504),(0.46457,0.68504),(0.47244,0.68504),(0.48031,0.68504),(0.48819,0.68504),(0.49606,0.68504),(0.50394,0.68504),(0.51181,0.68504),(0.51969,0.68504),(0.52756,0.68504),(0.53543,0.68504),(0.54331,0.68504),(0.55118,0.68504),(0.55906,0.68504),(0.56693,0.68504),(0.5748,0.68504),(0.58268,0.68504),(0.59055,0.68504),(0.59843,0.68504),(0.6063,0.68504),(0.61417,0.68504),(0.62205,0.68504),(0.62992,0.68504),(0.6378,0.68504),(0.64567,0.68504),(0.65354,0.68504),(0.66142,0.68504),(0.66929,0.68504),(0.67717,0.68504),(0.68504,0.68504),(0.69291,0.68504),(0.70079,0.68504),(0.70866,0.68504),(0.71654,0.68504),(0.72441,0.68504),(0.73228,0.68504),(0.74016,0.68504),(0.74803,0.68504),(0.75591,0.68504),(0.76378,0.68504),(0.77165,0.68504),(0.77953,0.68504),(0.7874,0.68504),(0.79528,0.68504),(0.80315,0.68504),(0.81102,0.68504),(0.8189,0.68504),(0.82677,0.68504),(0.83465,0.68504),(0.84252,0.68504),(0.85039,0.68504),(0.85827,0.68504),(0.86614,0.68504),(0.87402,0.68504),(0.88189,0.68504),(0.88976,0.68504),(0.89764,0.68504),(0.90551,0.68504),(0.91339,0.68504),(0.92126,0.68504),(0.92913,0.68504),(0.93701,0.68504),(0.94488,0.68504),(0.95276,0.68504),(0.96063,0.68504),(0.9685,0.68504),(0.97638,0.68504),(0.98425,0.68504),(0.99213,0.68504),(0.99609,0.68504),(0.00391,0.69291),(0.00787,0.69291),(0.01575,0.69291),(0.02362,0.69291),(0.0315,0.69291),(0.03937,0.69291),(0.04724,0.69291),(0.05512,0.69291),(0.06299,0.69291),(0.07087,0.69291),(0.07874,0.69291),(0.08661,0.69291),(0.09449,0.69291),(0.10236,0.69291),(0.11024,0.69291),(0.11811,0.69291),(0.12598,0.69291),(0.13386,0.69291),(0.14173,0.69291),(0.14961,0.69291),(0.15748,0.69291),(0.16535,0.69291),(0.17323,0.69291),(0.1811,0.69291),(0.18898,0.69291),(0.19685,0.69291),(0.20472,0.69291),(0.2126,0.69291),(0.22047,0.69291),(0.22835,0.69291),(0.23622,0.69291),(0.24409,0.69291),(0.25197,0.69291),(0.25984,0.69291),(0.26772,0.69291),(0.27559,0.69291),(0.28346,0.69291),(0.29134,0.69291),(0.29921,0.69291),(0.30709,0.69291),(0.31496,0.69291),(0.32283,0.69291),(0.33071,0.69291),(0.33858,0.69291),(0.34646,0.69291),(0.35433,0.69291),(0.3622,0.69291),(0.37008,0.69291),(0.37795,0.69291),(0.38583,0.69291),(0.3937,0.69291),(0.40157,0.69291),(0.40945,0.69291),(0.41732,0.69291),(0.4252,0.69291),(0.43307,0.69291),(0.44094,0.69291),(0.44882,0.69291),(0.45669,0.69291),(0.46457,0.69291),(0.47244,0.69291),(0.48031,0.69291),(0.48819,0.69291),(0.49606,0.69291),(0.50394,0.69291),(0.51181,0.69291),(0.51969,0.69291),(0.52756,0.69291),(0.53543,0.69291),(0.54331,0.69291),(0.55118,0.69291),(0.55906,0.69291),(0.56693,0.69291),(0.5748,0.69291),(0.58268,0.69291),(0.59055,0.69291),(0.59843,0.69291),(0.6063,0.69291),(0.61417,0.69291),(0.62205,0.69291),(0.62992,0.69291),(0.6378,0.69291),(0.64567,0.69291),(0.65354,0.69291),(0.66142,0.69291),(0.66929,0.69291),(0.67717,0.69291),(0.68504,0.69291),(0.69291,0.69291),(0.70079,0.69291),(0.70866,0.69291),(0.71654,0.69291),(0.72441,0.69291),(0.73228,0.69291),(0.74016,0.69291),(0.74803,0.69291),(0.75591,0.69291),(0.76378,0.69291),(0.77165,0.69291),(0.77953,0.69291),(0.7874,0.69291),(0.79528,0.69291),(0.80315,0.69291),(0.81102,0.69291),(0.8189,0.69291),(0.82677,0.69291),(0.83465,0.69291),(0.84252,0.69291),(0.85039,0.69291),(0.85827,0.69291),(0.86614,0.69291),(0.87402,0.69291),(0.88189,0.69291),(0.88976,0.69291),(0.89764,0.69291),(0.90551,0.69291),(0.91339,0.69291),(0.92126,0.69291),(0.92913,0.69291),(0.93701,0.69291),(0.94488,0.69291),(0.95276,0.69291),(0.96063,0.69291),(0.9685,0.69291),(0.97638,0.69291),(0.98425,0.69291),(0.99213,0.69291),(0.99609,0.69291),(0.00391,0.70079),(0.00787,0.70079),(0.01575,0.70079),(0.02362,0.70079),(0.0315,0.70079),(0.03937,0.70079),(0.04724,0.70079),(0.05512,0.70079),(0.06299,0.70079),(0.07087,0.70079),(0.07874,0.70079),(0.08661,0.70079),(0.09449,0.70079),(0.10236,0.70079),(0.11024,0.70079),(0.11811,0.70079),(0.12598,0.70079),(0.13386,0.70079),(0.14173,0.70079),(0.14961,0.70079),(0.15748,0.70079),(0.16535,0.70079),(0.17323,0.70079),(0.1811,0.70079),(0.18898,0.70079),(0.19685,0.70079),(0.20472,0.70079),(0.2126,0.70079),(0.22047,0.70079),(0.22835,0.70079),(0.23622,0.70079),(0.24409,0.70079),(0.25197,0.70079),(0.25984,0.70079),(0.26772,0.70079),(0.27559,0.70079),(0.28346,0.70079),(0.29134,0.70079),(0.29921,0.70079),(0.30709,0.70079),(0.31496,0.70079),(0.32283,0.70079),(0.33071,0.70079),(0.33858,0.70079),(0.34646,0.70079),(0.35433,0.70079),(0.3622,0.70079),(0.37008,0.70079),(0.37795,0.70079),(0.38583,0.70079),(0.3937,0.70079),(0.40157,0.70079),(0.40945,0.70079),(0.41732,0.70079),(0.4252,0.70079),(0.43307,0.70079),(0.44094,0.70079),(0.44882,0.70079),(0.45669,0.70079),(0.46457,0.70079),(0.47244,0.70079),(0.48031,0.70079),(0.48819,0.70079),(0.49606,0.70079),(0.50394,0.70079),(0.51181,0.70079),(0.51969,0.70079),(0.52756,0.70079),(0.53543,0.70079),(0.54331,0.70079),(0.55118,0.70079),(0.55906,0.70079),(0.56693,0.70079),(0.5748,0.70079),(0.58268,0.70079),(0.59055,0.70079),(0.59843,0.70079),(0.6063,0.70079),(0.61417,0.70079),(0.62205,0.70079),(0.62992,0.70079),(0.6378,0.70079),(0.64567,0.70079),(0.65354,0.70079),(0.66142,0.70079),(0.66929,0.70079),(0.67717,0.70079),(0.68504,0.70079),(0.69291,0.70079),(0.70079,0.70079),(0.70866,0.70079),(0.71654,0.70079),(0.72441,0.70079),(0.73228,0.70079),(0.74016,0.70079),(0.74803,0.70079),(0.75591,0.70079),(0.76378,0.70079),(0.77165,0.70079),(0.77953,0.70079),(0.7874,0.70079),(0.79528,0.70079),(0.80315,0.70079),(0.81102,0.70079),(0.8189,0.70079),(0.82677,0.70079),(0.83465,0.70079),(0.84252,0.70079),(0.85039,0.70079),(0.85827,0.70079),(0.86614,0.70079),(0.87402,0.70079),(0.88189,0.70079),(0.88976,0.70079),(0.89764,0.70079),(0.90551,0.70079),(0.91339,0.70079),(0.92126,0.70079),(0.92913,0.70079),(0.93701,0.70079),(0.94488,0.70079),(0.95276,0.70079),(0.96063,0.70079),(0.9685,0.70079),(0.97638,0.70079),(0.98425,0.70079),(0.99213,0.70079),(0.99609,0.70079),(0.00391,0.70866),(0.00787,0.70866),(0.01575,0.70866),(0.02362,0.70866),(0.0315,0.70866),(0.03937,0.70866),(0.04724,0.70866),(0.05512,0.70866),(0.06299,0.70866),(0.07087,0.70866),(0.07874,0.70866),(0.08661,0.70866),(0.09449,0.70866),(0.10236,0.70866),(0.11024,0.70866),(0.11811,0.70866),(0.12598,0.70866),(0.13386,0.70866),(0.14173,0.70866),(0.14961,0.70866),(0.15748,0.70866),(0.16535,0.70866),(0.17323,0.70866),(0.1811,0.70866),(0.18898,0.70866),(0.19685,0.70866),(0.20472,0.70866),(0.2126,0.70866),(0.22047,0.70866),(0.22835,0.70866),(0.23622,0.70866),(0.24409,0.70866),(0.25197,0.70866),(0.25984,0.70866),(0.26772,0.70866),(0.27559,0.70866),(0.28346,0.70866),(0.29134,0.70866),(0.29921,0.70866),(0.30709,0.70866),(0.31496,0.70866),(0.32283,0.70866),(0.33071,0.70866),(0.33858,0.70866),(0.34646,0.70866),(0.35433,0.70866),(0.3622,0.70866),(0.37008,0.70866),(0.37795,0.70866),(0.38583,0.70866),(0.3937,0.70866),(0.40157,0.70866),(0.40945,0.70866),(0.41732,0.70866),(0.4252,0.70866),(0.43307,0.70866),(0.44094,0.70866),(0.44882,0.70866),(0.45669,0.70866),(0.46457,0.70866),(0.47244,0.70866),(0.48031,0.70866),(0.48819,0.70866),(0.49606,0.70866),(0.50394,0.70866),(0.51181,0.70866),(0.51969,0.70866),(0.52756,0.70866),(0.53543,0.70866),(0.54331,0.70866),(0.55118,0.70866),(0.55906,0.70866),(0.56693,0.70866),(0.5748,0.70866),(0.58268,0.70866),(0.59055,0.70866),(0.59843,0.70866),(0.6063,0.70866),(0.61417,0.70866),(0.62205,0.70866),(0.62992,0.70866),(0.6378,0.70866),(0.64567,0.70866),(0.65354,0.70866),(0.66142,0.70866),(0.66929,0.70866),(0.67717,0.70866),(0.68504,0.70866),(0.69291,0.70866),(0.70079,0.70866),(0.70866,0.70866),(0.71654,0.70866),(0.72441,0.70866),(0.73228,0.70866),(0.74016,0.70866),(0.74803,0.70866),(0.75591,0.70866),(0.76378,0.70866),(0.77165,0.70866),(0.77953,0.70866),(0.7874,0.70866),(0.79528,0.70866),(0.80315,0.70866),(0.81102,0.70866),(0.8189,0.70866),(0.82677,0.70866),(0.83465,0.70866),(0.84252,0.70866),(0.85039,0.70866),(0.85827,0.70866),(0.86614,0.70866),(0.87402,0.70866),(0.88189,0.70866),(0.88976,0.70866),(0.89764,0.70866),(0.90551,0.70866),(0.91339,0.70866),(0.92126,0.70866),(0.92913,0.70866),(0.93701,0.70866),(0.94488,0.70866),(0.95276,0.70866),(0.96063,0.70866),(0.9685,0.70866),(0.97638,0.70866),(0.98425,0.70866),(0.99213,0.70866),(0.99609,0.70866),(0.00391,0.71654),(0.00787,0.71654),(0.01575,0.71654),(0.02362,0.71654),(0.0315,0.71654),(0.03937,0.71654),(0.04724,0.71654),(0.05512,0.71654),(0.06299,0.71654),(0.07087,0.71654),(0.07874,0.71654),(0.08661,0.71654),(0.09449,0.71654),(0.10236,0.71654),(0.11024,0.71654),(0.11811,0.71654),(0.12598,0.71654),(0.13386,0.71654),(0.14173,0.71654),(0.14961,0.71654),(0.15748,0.71654),(0.16535,0.71654),(0.17323,0.71654),(0.1811,0.71654),(0.18898,0.71654),(0.19685,0.71654),(0.20472,0.71654),(0.2126,0.71654),(0.22047,0.71654),(0.22835,0.71654),(0.23622,0.71654),(0.24409,0.71654),(0.25197,0.71654),(0.25984,0.71654),(0.26772,0.71654),(0.27559,0.71654),(0.28346,0.71654),(0.29134,0.71654),(0.29921,0.71654),(0.30709,0.71654),(0.31496,0.71654),(0.32283,0.71654),(0.33071,0.71654),(0.33858,0.71654),(0.34646,0.71654),(0.35433,0.71654),(0.3622,0.71654),(0.37008,0.71654),(0.37795,0.71654),(0.38583,0.71654),(0.3937,0.71654),(0.40157,0.71654),(0.40945,0.71654),(0.41732,0.71654),(0.4252,0.71654),(0.43307,0.71654),(0.44094,0.71654),(0.44882,0.71654),(0.45669,0.71654),(0.46457,0.71654),(0.47244,0.71654),(0.48031,0.71654),(0.48819,0.71654),(0.49606,0.71654),(0.50394,0.71654),(0.51181,0.71654),(0.51969,0.71654),(0.52756,0.71654),(0.53543,0.71654),(0.54331,0.71654),(0.55118,0.71654),(0.55906,0.71654),(0.56693,0.71654),(0.5748,0.71654),(0.58268,0.71654),(0.59055,0.71654),(0.59843,0.71654),(0.6063,0.71654),(0.61417,0.71654),(0.62205,0.71654),(0.62992,0.71654),(0.6378,0.71654),(0.64567,0.71654),(0.65354,0.71654),(0.66142,0.71654),(0.66929,0.71654),(0.67717,0.71654),(0.68504,0.71654),(0.69291,0.71654),(0.70079,0.71654),(0.70866,0.71654),(0.71654,0.71654),(0.72441,0.71654),(0.73228,0.71654),(0.74016,0.71654),(0.74803,0.71654),(0.75591,0.71654),(0.76378,0.71654),(0.77165,0.71654),(0.77953,0.71654),(0.7874,0.71654),(0.79528,0.71654),(0.80315,0.71654),(0.81102,0.71654),(0.8189,0.71654),(0.82677,0.71654),(0.83465,0.71654),(0.84252,0.71654),(0.85039,0.71654),(0.85827,0.71654),(0.86614,0.71654),(0.87402,0.71654),(0.88189,0.71654),(0.88976,0.71654),(0.89764,0.71654),(0.90551,0.71654),(0.91339,0.71654),(0.92126,0.71654),(0.92913,0.71654),(0.93701,0.71654),(0.94488,0.71654),(0.95276,0.71654),(0.96063,0.71654),(0.9685,0.71654),(0.97638,0.71654),(0.98425,0.71654),(0.99213,0.71654),(0.99609,0.71654),(0.00391,0.72441),(0.00787,0.72441),(0.01575,0.72441),(0.02362,0.72441),(0.0315,0.72441),(0.03937,0.72441),(0.04724,0.72441),(0.05512,0.72441),(0.06299,0.72441),(0.07087,0.72441),(0.07874,0.72441),(0.08661,0.72441),(0.09449,0.72441),(0.10236,0.72441),(0.11024,0.72441),(0.11811,0.72441),(0.12598,0.72441),(0.13386,0.72441),(0.14173,0.72441),(0.14961,0.72441),(0.15748,0.72441),(0.16535,0.72441),(0.17323,0.72441),(0.1811,0.72441),(0.18898,0.72441),(0.19685,0.72441),(0.20472,0.72441),(0.2126,0.72441),(0.22047,0.72441),(0.22835,0.72441),(0.23622,0.72441),(0.24409,0.72441),(0.25197,0.72441),(0.25984,0.72441),(0.26772,0.72441),(0.27559,0.72441),(0.28346,0.72441),(0.29134,0.72441),(0.29921,0.72441),(0.30709,0.72441),(0.31496,0.72441),(0.32283,0.72441),(0.33071,0.72441),(0.33858,0.72441),(0.34646,0.72441),(0.35433,0.72441),(0.3622,0.72441),(0.37008,0.72441),(0.37795,0.72441),(0.38583,0.72441),(0.3937,0.72441),(0.40157,0.72441),(0.40945,0.72441),(0.41732,0.72441),(0.4252,0.72441),(0.43307,0.72441),(0.44094,0.72441),(0.44882,0.72441),(0.45669,0.72441),(0.46457,0.72441),(0.47244,0.72441),(0.48031,0.72441),(0.48819,0.72441),(0.49606,0.72441),(0.50394,0.72441),(0.51181,0.72441),(0.51969,0.72441),(0.52756,0.72441),(0.53543,0.72441),(0.54331,0.72441),(0.55118,0.72441),(0.55906,0.72441),(0.56693,0.72441),(0.5748,0.72441),(0.58268,0.72441),(0.59055,0.72441),(0.59843,0.72441),(0.6063,0.72441),(0.61417,0.72441),(0.62205,0.72441),(0.62992,0.72441),(0.6378,0.72441),(0.64567,0.72441),(0.65354,0.72441),(0.66142,0.72441),(0.66929,0.72441),(0.67717,0.72441),(0.68504,0.72441),(0.69291,0.72441),(0.70079,0.72441),(0.70866,0.72441),(0.71654,0.72441),(0.72441,0.72441),(0.73228,0.72441),(0.74016,0.72441),(0.74803,0.72441),(0.75591,0.72441),(0.76378,0.72441),(0.77165,0.72441),(0.77953,0.72441),(0.7874,0.72441),(0.79528,0.72441),(0.80315,0.72441),(0.81102,0.72441),(0.8189,0.72441),(0.82677,0.72441),(0.83465,0.72441),(0.84252,0.72441),(0.85039,0.72441),(0.85827,0.72441),(0.86614,0.72441),(0.87402,0.72441),(0.88189,0.72441),(0.88976,0.72441),(0.89764,0.72441),(0.90551,0.72441),(0.91339,0.72441),(0.92126,0.72441),(0.92913,0.72441),(0.93701,0.72441),(0.94488,0.72441),(0.95276,0.72441),(0.96063,0.72441),(0.9685,0.72441),(0.97638,0.72441),(0.98425,0.72441),(0.99213,0.72441),(0.99609,0.72441),(0.00391,0.73228),(0.00787,0.73228),(0.01575,0.73228),(0.02362,0.73228),(0.0315,0.73228),(0.03937,0.73228),(0.04724,0.73228),(0.05512,0.73228),(0.06299,0.73228),(0.07087,0.73228),(0.07874,0.73228),(0.08661,0.73228),(0.09449,0.73228),(0.10236,0.73228),(0.11024,0.73228),(0.11811,0.73228),(0.12598,0.73228),(0.13386,0.73228),(0.14173,0.73228),(0.14961,0.73228),(0.15748,0.73228),(0.16535,0.73228),(0.17323,0.73228),(0.1811,0.73228),(0.18898,0.73228),(0.19685,0.73228),(0.20472,0.73228),(0.2126,0.73228),(0.22047,0.73228),(0.22835,0.73228),(0.23622,0.73228),(0.24409,0.73228),(0.25197,0.73228),(0.25984,0.73228),(0.26772,0.73228),(0.27559,0.73228),(0.28346,0.73228),(0.29134,0.73228),(0.29921,0.73228),(0.30709,0.73228),(0.31496,0.73228),(0.32283,0.73228),(0.33071,0.73228),(0.33858,0.73228),(0.34646,0.73228),(0.35433,0.73228),(0.3622,0.73228),(0.37008,0.73228),(0.37795,0.73228),(0.38583,0.73228),(0.3937,0.73228),(0.40157,0.73228),(0.40945,0.73228),(0.41732,0.73228),(0.4252,0.73228),(0.43307,0.73228),(0.44094,0.73228),(0.44882,0.73228),(0.45669,0.73228),(0.46457,0.73228),(0.47244,0.73228),(0.48031,0.73228),(0.48819,0.73228),(0.49606,0.73228),(0.50394,0.73228),(0.51181,0.73228),(0.51969,0.73228),(0.52756,0.73228),(0.53543,0.73228),(0.54331,0.73228),(0.55118,0.73228),(0.55906,0.73228),(0.56693,0.73228),(0.5748,0.73228),(0.58268,0.73228),(0.59055,0.73228),(0.59843,0.73228),(0.6063,0.73228),(0.61417,0.73228),(0.62205,0.73228),(0.62992,0.73228),(0.6378,0.73228),(0.64567,0.73228),(0.65354,0.73228),(0.66142,0.73228),(0.66929,0.73228),(0.67717,0.73228),(0.68504,0.73228),(0.69291,0.73228),(0.70079,0.73228),(0.70866,0.73228),(0.71654,0.73228),(0.72441,0.73228),(0.73228,0.73228),(0.74016,0.73228),(0.74803,0.73228),(0.75591,0.73228),(0.76378,0.73228),(0.77165,0.73228),(0.77953,0.73228),(0.7874,0.73228),(0.79528,0.73228),(0.80315,0.73228),(0.81102,0.73228),(0.8189,0.73228),(0.82677,0.73228),(0.83465,0.73228),(0.84252,0.73228),(0.85039,0.73228),(0.85827,0.73228),(0.86614,0.73228),(0.87402,0.73228),(0.88189,0.73228),(0.88976,0.73228),(0.89764,0.73228),(0.90551,0.73228),(0.91339,0.73228),(0.92126,0.73228),(0.92913,0.73228),(0.93701,0.73228),(0.94488,0.73228),(0.95276,0.73228),(0.96063,0.73228),(0.9685,0.73228),(0.97638,0.73228),(0.98425,0.73228),(0.99213,0.73228),(0.99609,0.73228),(0.00391,0.74016),(0.00787,0.74016),(0.01575,0.74016),(0.02362,0.74016),(0.0315,0.74016),(0.03937,0.74016),(0.04724,0.74016),(0.05512,0.74016),(0.06299,0.74016),(0.07087,0.74016),(0.07874,0.74016),(0.08661,0.74016),(0.09449,0.74016),(0.10236,0.74016),(0.11024,0.74016),(0.11811,0.74016),(0.12598,0.74016),(0.13386,0.74016),(0.14173,0.74016),(0.14961,0.74016),(0.15748,0.74016),(0.16535,0.74016),(0.17323,0.74016),(0.1811,0.74016),(0.18898,0.74016),(0.19685,0.74016),(0.20472,0.74016),(0.2126,0.74016),(0.22047,0.74016),(0.22835,0.74016),(0.23622,0.74016),(0.24409,0.74016),(0.25197,0.74016),(0.25984,0.74016),(0.26772,0.74016),(0.27559,0.74016),(0.28346,0.74016),(0.29134,0.74016),(0.29921,0.74016),(0.30709,0.74016),(0.31496,0.74016),(0.32283,0.74016),(0.33071,0.74016),(0.33858,0.74016),(0.34646,0.74016),(0.35433,0.74016),(0.3622,0.74016),(0.37008,0.74016),(0.37795,0.74016),(0.38583,0.74016),(0.3937,0.74016),(0.40157,0.74016),(0.40945,0.74016),(0.41732,0.74016),(0.4252,0.74016),(0.43307,0.74016),(0.44094,0.74016),(0.44882,0.74016),(0.45669,0.74016),(0.46457,0.74016),(0.47244,0.74016),(0.48031,0.74016),(0.48819,0.74016),(0.49606,0.74016),(0.50394,0.74016),(0.51181,0.74016),(0.51969,0.74016),(0.52756,0.74016),(0.53543,0.74016),(0.54331,0.74016),(0.55118,0.74016),(0.55906,0.74016),(0.56693,0.74016),(0.5748,0.74016),(0.58268,0.74016),(0.59055,0.74016),(0.59843,0.74016),(0.6063,0.74016),(0.61417,0.74016),(0.62205,0.74016),(0.62992,0.74016),(0.6378,0.74016),(0.64567,0.74016),(0.65354,0.74016),(0.66142,0.74016),(0.66929,0.74016),(0.67717,0.74016),(0.68504,0.74016),(0.69291,0.74016),(0.70079,0.74016),(0.70866,0.74016),(0.71654,0.74016),(0.72441,0.74016),(0.73228,0.74016),(0.74016,0.74016),(0.74803,0.74016),(0.75591,0.74016),(0.76378,0.74016),(0.77165,0.74016),(0.77953,0.74016),(0.7874,0.74016),(0.79528,0.74016),(0.80315,0.74016),(0.81102,0.74016),(0.8189,0.74016),(0.82677,0.74016),(0.83465,0.74016),(0.84252,0.74016),(0.85039,0.74016),(0.85827,0.74016),(0.86614,0.74016),(0.87402,0.74016),(0.88189,0.74016),(0.88976,0.74016),(0.89764,0.74016),(0.90551,0.74016),(0.91339,0.74016),(0.92126,0.74016),(0.92913,0.74016),(0.93701,0.74016),(0.94488,0.74016),(0.95276,0.74016),(0.96063,0.74016),(0.9685,0.74016),(0.97638,0.74016),(0.98425,0.74016),(0.99213,0.74016),(0.99609,0.74016),(0.00391,0.74803),(0.00787,0.74803),(0.01575,0.74803),(0.02362,0.74803),(0.0315,0.74803),(0.03937,0.74803),(0.04724,0.74803),(0.05512,0.74803),(0.06299,0.74803),(0.07087,0.74803),(0.07874,0.74803),(0.08661,0.74803),(0.09449,0.74803),(0.10236,0.74803),(0.11024,0.74803),(0.11811,0.74803),(0.12598,0.74803),(0.13386,0.74803),(0.14173,0.74803),(0.14961,0.74803),(0.15748,0.74803),(0.16535,0.74803),(0.17323,0.74803),(0.1811,0.74803),(0.18898,0.74803),(0.19685,0.74803),(0.20472,0.74803),(0.2126,0.74803),(0.22047,0.74803),(0.22835,0.74803),(0.23622,0.74803),(0.24409,0.74803),(0.25197,0.74803),(0.25984,0.74803),(0.26772,0.74803),(0.27559,0.74803),(0.28346,0.74803),(0.29134,0.74803),(0.29921,0.74803),(0.30709,0.74803),(0.31496,0.74803),(0.32283,0.74803),(0.33071,0.74803),(0.33858,0.74803),(0.34646,0.74803),(0.35433,0.74803),(0.3622,0.74803),(0.37008,0.74803),(0.37795,0.74803),(0.38583,0.74803),(0.3937,0.74803),(0.40157,0.74803),(0.40945,0.74803),(0.41732,0.74803),(0.4252,0.74803),(0.43307,0.74803),(0.44094,0.74803),(0.44882,0.74803),(0.45669,0.74803),(0.46457,0.74803),(0.47244,0.74803),(0.48031,0.74803),(0.48819,0.74803),(0.49606,0.74803),(0.50394,0.74803),(0.51181,0.74803),(0.51969,0.74803),(0.52756,0.74803),(0.53543,0.74803),(0.54331,0.74803),(0.55118,0.74803),(0.55906,0.74803),(0.56693,0.74803),(0.5748,0.74803),(0.58268,0.74803),(0.59055,0.74803),(0.59843,0.74803),(0.6063,0.74803),(0.61417,0.74803),(0.62205,0.74803),(0.62992,0.74803),(0.6378,0.74803),(0.64567,0.74803),(0.65354,0.74803),(0.66142,0.74803),(0.66929,0.74803),(0.67717,0.74803),(0.68504,0.74803),(0.69291,0.74803),(0.70079,0.74803),(0.70866,0.74803),(0.71654,0.74803),(0.72441,0.74803),(0.73228,0.74803),(0.74016,0.74803),(0.74803,0.74803),(0.75591,0.74803),(0.76378,0.74803),(0.77165,0.74803),(0.77953,0.74803),(0.7874,0.74803),(0.79528,0.74803),(0.80315,0.74803),(0.81102,0.74803),(0.8189,0.74803),(0.82677,0.74803),(0.83465,0.74803),(0.84252,0.74803),(0.85039,0.74803),(0.85827,0.74803),(0.86614,0.74803),(0.87402,0.74803),(0.88189,0.74803),(0.88976,0.74803),(0.89764,0.74803),(0.90551,0.74803),(0.91339,0.74803),(0.92126,0.74803),(0.92913,0.74803),(0.93701,0.74803),(0.94488,0.74803),(0.95276,0.74803),(0.96063,0.74803),(0.9685,0.74803),(0.97638,0.74803),(0.98425,0.74803),(0.99213,0.74803),(0.99609,0.74803),(0.00391,0.75591),(0.00787,0.75591),(0.01575,0.75591),(0.02362,0.75591),(0.0315,0.75591),(0.03937,0.75591),(0.04724,0.75591),(0.05512,0.75591),(0.06299,0.75591),(0.07087,0.75591),(0.07874,0.75591),(0.08661,0.75591),(0.09449,0.75591),(0.10236,0.75591),(0.11024,0.75591),(0.11811,0.75591),(0.12598,0.75591),(0.13386,0.75591),(0.14173,0.75591),(0.14961,0.75591),(0.15748,0.75591),(0.16535,0.75591),(0.17323,0.75591),(0.1811,0.75591),(0.18898,0.75591),(0.19685,0.75591),(0.20472,0.75591),(0.2126,0.75591),(0.22047,0.75591),(0.22835,0.75591),(0.23622,0.75591),(0.24409,0.75591),(0.25197,0.75591),(0.25984,0.75591),(0.26772,0.75591),(0.27559,0.75591),(0.28346,0.75591),(0.29134,0.75591),(0.29921,0.75591),(0.30709,0.75591),(0.31496,0.75591),(0.32283,0.75591),(0.33071,0.75591),(0.33858,0.75591),(0.34646,0.75591),(0.35433,0.75591),(0.3622,0.75591),(0.37008,0.75591),(0.37795,0.75591),(0.38583,0.75591),(0.3937,0.75591),(0.40157,0.75591),(0.40945,0.75591),(0.41732,0.75591),(0.4252,0.75591),(0.43307,0.75591),(0.44094,0.75591),(0.44882,0.75591),(0.45669,0.75591),(0.46457,0.75591),(0.47244,0.75591),(0.48031,0.75591),(0.48819,0.75591),(0.49606,0.75591),(0.50394,0.75591),(0.51181,0.75591),(0.51969,0.75591),(0.52756,0.75591),(0.53543,0.75591),(0.54331,0.75591),(0.55118,0.75591),(0.55906,0.75591),(0.56693,0.75591),(0.5748,0.75591),(0.58268,0.75591),(0.59055,0.75591),(0.59843,0.75591),(0.6063,0.75591),(0.61417,0.75591),(0.62205,0.75591),(0.62992,0.75591),(0.6378,0.75591),(0.64567,0.75591),(0.65354,0.75591),(0.66142,0.75591),(0.66929,0.75591),(0.67717,0.75591),(0.68504,0.75591),(0.69291,0.75591),(0.70079,0.75591),(0.70866,0.75591),(0.71654,0.75591),(0.72441,0.75591),(0.73228,0.75591),(0.74016,0.75591),(0.74803,0.75591),(0.75591,0.75591),(0.76378,0.75591),(0.77165,0.75591),(0.77953,0.75591),(0.7874,0.75591),(0.79528,0.75591),(0.80315,0.75591),(0.81102,0.75591),(0.8189,0.75591),(0.82677,0.75591),(0.83465,0.75591),(0.84252,0.75591),(0.85039,0.75591),(0.85827,0.75591),(0.86614,0.75591),(0.87402,0.75591),(0.88189,0.75591),(0.88976,0.75591),(0.89764,0.75591),(0.90551,0.75591),(0.91339,0.75591),(0.92126,0.75591),(0.92913,0.75591),(0.93701,0.75591),(0.94488,0.75591),(0.95276,0.75591),(0.96063,0.75591),(0.9685,0.75591),(0.97638,0.75591),(0.98425,0.75591),(0.99213,0.75591),(0.99609,0.75591),(0.00391,0.76378),(0.00787,0.76378),(0.01575,0.76378),(0.02362,0.76378),(0.0315,0.76378),(0.03937,0.76378),(0.04724,0.76378),(0.05512,0.76378),(0.06299,0.76378),(0.07087,0.76378),(0.07874,0.76378),(0.08661,0.76378),(0.09449,0.76378),(0.10236,0.76378),(0.11024,0.76378),(0.11811,0.76378),(0.12598,0.76378),(0.13386,0.76378),(0.14173,0.76378),(0.14961,0.76378),(0.15748,0.76378),(0.16535,0.76378),(0.17323,0.76378),(0.1811,0.76378),(0.18898,0.76378),(0.19685,0.76378),(0.20472,0.76378),(0.2126,0.76378),(0.22047,0.76378),(0.22835,0.76378),(0.23622,0.76378),(0.24409,0.76378),(0.25197,0.76378),(0.25984,0.76378),(0.26772,0.76378),(0.27559,0.76378),(0.28346,0.76378),(0.29134,0.76378),(0.29921,0.76378),(0.30709,0.76378),(0.31496,0.76378),(0.32283,0.76378),(0.33071,0.76378),(0.33858,0.76378),(0.34646,0.76378),(0.35433,0.76378),(0.3622,0.76378),(0.37008,0.76378),(0.37795,0.76378),(0.38583,0.76378),(0.3937,0.76378),(0.40157,0.76378),(0.40945,0.76378),(0.41732,0.76378),(0.4252,0.76378),(0.43307,0.76378),(0.44094,0.76378),(0.44882,0.76378),(0.45669,0.76378),(0.46457,0.76378),(0.47244,0.76378),(0.48031,0.76378),(0.48819,0.76378),(0.49606,0.76378),(0.50394,0.76378),(0.51181,0.76378),(0.51969,0.76378),(0.52756,0.76378),(0.53543,0.76378),(0.54331,0.76378),(0.55118,0.76378),(0.55906,0.76378),(0.56693,0.76378),(0.5748,0.76378),(0.58268,0.76378),(0.59055,0.76378),(0.59843,0.76378),(0.6063,0.76378),(0.61417,0.76378),(0.62205,0.76378),(0.62992,0.76378),(0.6378,0.76378),(0.64567,0.76378),(0.65354,0.76378),(0.66142,0.76378),(0.66929,0.76378),(0.67717,0.76378),(0.68504,0.76378),(0.69291,0.76378),(0.70079,0.76378),(0.70866,0.76378),(0.71654,0.76378),(0.72441,0.76378),(0.73228,0.76378),(0.74016,0.76378),(0.74803,0.76378),(0.75591,0.76378),(0.76378,0.76378),(0.77165,0.76378),(0.77953,0.76378),(0.7874,0.76378),(0.79528,0.76378),(0.80315,0.76378),(0.81102,0.76378),(0.8189,0.76378),(0.82677,0.76378),(0.83465,0.76378),(0.84252,0.76378),(0.85039,0.76378),(0.85827,0.76378),(0.86614,0.76378),(0.87402,0.76378),(0.88189,0.76378),(0.88976,0.76378),(0.89764,0.76378),(0.90551,0.76378),(0.91339,0.76378),(0.92126,0.76378),(0.92913,0.76378),(0.93701,0.76378),(0.94488,0.76378),(0.95276,0.76378),(0.96063,0.76378),(0.9685,0.76378),(0.97638,0.76378),(0.98425,0.76378),(0.99213,0.76378),(0.99609,0.76378),(0.00391,0.77165),(0.00787,0.77165),(0.01575,0.77165),(0.02362,0.77165),(0.0315,0.77165),(0.03937,0.77165),(0.04724,0.77165),(0.05512,0.77165),(0.06299,0.77165),(0.07087,0.77165),(0.07874,0.77165),(0.08661,0.77165),(0.09449,0.77165),(0.10236,0.77165),(0.11024,0.77165),(0.11811,0.77165),(0.12598,0.77165),(0.13386,0.77165),(0.14173,0.77165),(0.14961,0.77165),(0.15748,0.77165),(0.16535,0.77165),(0.17323,0.77165),(0.1811,0.77165),(0.18898,0.77165),(0.19685,0.77165),(0.20472,0.77165),(0.2126,0.77165),(0.22047,0.77165),(0.22835,0.77165),(0.23622,0.77165),(0.24409,0.77165),(0.25197,0.77165),(0.25984,0.77165),(0.26772,0.77165),(0.27559,0.77165),(0.28346,0.77165),(0.29134,0.77165),(0.29921,0.77165),(0.30709,0.77165),(0.31496,0.77165),(0.32283,0.77165),(0.33071,0.77165),(0.33858,0.77165),(0.34646,0.77165),(0.35433,0.77165),(0.3622,0.77165),(0.37008,0.77165),(0.37795,0.77165),(0.38583,0.77165),(0.3937,0.77165),(0.40157,0.77165),(0.40945,0.77165),(0.41732,0.77165),(0.4252,0.77165),(0.43307,0.77165),(0.44094,0.77165),(0.44882,0.77165),(0.45669,0.77165),(0.46457,0.77165),(0.47244,0.77165),(0.48031,0.77165),(0.48819,0.77165),(0.49606,0.77165),(0.50394,0.77165),(0.51181,0.77165),(0.51969,0.77165),(0.52756,0.77165),(0.53543,0.77165),(0.54331,0.77165),(0.55118,0.77165),(0.55906,0.77165),(0.56693,0.77165),(0.5748,0.77165),(0.58268,0.77165),(0.59055,0.77165),(0.59843,0.77165),(0.6063,0.77165),(0.61417,0.77165),(0.62205,0.77165),(0.62992,0.77165),(0.6378,0.77165),(0.64567,0.77165),(0.65354,0.77165),(0.66142,0.77165),(0.66929,0.77165),(0.67717,0.77165),(0.68504,0.77165),(0.69291,0.77165),(0.70079,0.77165),(0.70866,0.77165),(0.71654,0.77165),(0.72441,0.77165),(0.73228,0.77165),(0.74016,0.77165),(0.74803,0.77165),(0.75591,0.77165),(0.76378,0.77165),(0.77165,0.77165),(0.77953,0.77165),(0.7874,0.77165),(0.79528,0.77165),(0.80315,0.77165),(0.81102,0.77165),(0.8189,0.77165),(0.82677,0.77165),(0.83465,0.77165),(0.84252,0.77165),(0.85039,0.77165),(0.85827,0.77165),(0.86614,0.77165),(0.87402,0.77165),(0.88189,0.77165),(0.88976,0.77165),(0.89764,0.77165),(0.90551,0.77165),(0.91339,0.77165),(0.92126,0.77165),(0.92913,0.77165),(0.93701,0.77165),(0.94488,0.77165),(0.95276,0.77165),(0.96063,0.77165),(0.9685,0.77165),(0.97638,0.77165),(0.98425,0.77165),(0.99213,0.77165),(0.99609,0.77165),(0.00391,0.77953),(0.00787,0.77953),(0.01575,0.77953),(0.02362,0.77953),(0.0315,0.77953),(0.03937,0.77953),(0.04724,0.77953),(0.05512,0.77953),(0.06299,0.77953),(0.07087,0.77953),(0.07874,0.77953),(0.08661,0.77953),(0.09449,0.77953),(0.10236,0.77953),(0.11024,0.77953),(0.11811,0.77953),(0.12598,0.77953),(0.13386,0.77953),(0.14173,0.77953),(0.14961,0.77953),(0.15748,0.77953),(0.16535,0.77953),(0.17323,0.77953),(0.1811,0.77953),(0.18898,0.77953),(0.19685,0.77953),(0.20472,0.77953),(0.2126,0.77953),(0.22047,0.77953),(0.22835,0.77953),(0.23622,0.77953),(0.24409,0.77953),(0.25197,0.77953),(0.25984,0.77953),(0.26772,0.77953),(0.27559,0.77953),(0.28346,0.77953),(0.29134,0.77953),(0.29921,0.77953),(0.30709,0.77953),(0.31496,0.77953),(0.32283,0.77953),(0.33071,0.77953),(0.33858,0.77953),(0.34646,0.77953),(0.35433,0.77953),(0.3622,0.77953),(0.37008,0.77953),(0.37795,0.77953),(0.38583,0.77953),(0.3937,0.77953),(0.40157,0.77953),(0.40945,0.77953),(0.41732,0.77953),(0.4252,0.77953),(0.43307,0.77953),(0.44094,0.77953),(0.44882,0.77953),(0.45669,0.77953),(0.46457,0.77953),(0.47244,0.77953),(0.48031,0.77953),(0.48819,0.77953),(0.49606,0.77953),(0.50394,0.77953),(0.51181,0.77953),(0.51969,0.77953),(0.52756,0.77953),(0.53543,0.77953),(0.54331,0.77953),(0.55118,0.77953),(0.55906,0.77953),(0.56693,0.77953),(0.5748,0.77953),(0.58268,0.77953),(0.59055,0.77953),(0.59843,0.77953),(0.6063,0.77953),(0.61417,0.77953),(0.62205,0.77953),(0.62992,0.77953),(0.6378,0.77953),(0.64567,0.77953),(0.65354,0.77953),(0.66142,0.77953),(0.66929,0.77953),(0.67717,0.77953),(0.68504,0.77953),(0.69291,0.77953),(0.70079,0.77953),(0.70866,0.77953),(0.71654,0.77953),(0.72441,0.77953),(0.73228,0.77953),(0.74016,0.77953),(0.74803,0.77953),(0.75591,0.77953),(0.76378,0.77953),(0.77165,0.77953),(0.77953,0.77953),(0.7874,0.77953),(0.79528,0.77953),(0.80315,0.77953),(0.81102,0.77953),(0.8189,0.77953),(0.82677,0.77953),(0.83465,0.77953),(0.84252,0.77953),(0.85039,0.77953),(0.85827,0.77953),(0.86614,0.77953),(0.87402,0.77953),(0.88189,0.77953),(0.88976,0.77953),(0.89764,0.77953),(0.90551,0.77953),(0.91339,0.77953),(0.92126,0.77953),(0.92913,0.77953),(0.93701,0.77953),(0.94488,0.77953),(0.95276,0.77953),(0.96063,0.77953),(0.9685,0.77953),(0.97638,0.77953),(0.98425,0.77953),(0.99213,0.77953),(0.99609,0.77953),(0.00391,0.7874),(0.00787,0.7874),(0.01575,0.7874),(0.02362,0.7874),(0.0315,0.7874),(0.03937,0.7874),(0.04724,0.7874),(0.05512,0.7874),(0.06299,0.7874),(0.07087,0.7874),(0.07874,0.7874),(0.08661,0.7874),(0.09449,0.7874),(0.10236,0.7874),(0.11024,0.7874),(0.11811,0.7874),(0.12598,0.7874),(0.13386,0.7874),(0.14173,0.7874),(0.14961,0.7874),(0.15748,0.7874),(0.16535,0.7874),(0.17323,0.7874),(0.1811,0.7874),(0.18898,0.7874),(0.19685,0.7874),(0.20472,0.7874),(0.2126,0.7874),(0.22047,0.7874),(0.22835,0.7874),(0.23622,0.7874),(0.24409,0.7874),(0.25197,0.7874),(0.25984,0.7874),(0.26772,0.7874),(0.27559,0.7874),(0.28346,0.7874),(0.29134,0.7874),(0.29921,0.7874),(0.30709,0.7874),(0.31496,0.7874),(0.32283,0.7874),(0.33071,0.7874),(0.33858,0.7874),(0.34646,0.7874),(0.35433,0.7874),(0.3622,0.7874),(0.37008,0.7874),(0.37795,0.7874),(0.38583,0.7874),(0.3937,0.7874),(0.40157,0.7874),(0.40945,0.7874),(0.41732,0.7874),(0.4252,0.7874),(0.43307,0.7874),(0.44094,0.7874),(0.44882,0.7874),(0.45669,0.7874),(0.46457,0.7874),(0.47244,0.7874),(0.48031,0.7874),(0.48819,0.7874),(0.49606,0.7874),(0.50394,0.7874),(0.51181,0.7874),(0.51969,0.7874),(0.52756,0.7874),(0.53543,0.7874),(0.54331,0.7874),(0.55118,0.7874),(0.55906,0.7874),(0.56693,0.7874),(0.5748,0.7874),(0.58268,0.7874),(0.59055,0.7874),(0.59843,0.7874),(0.6063,0.7874),(0.61417,0.7874),(0.62205,0.7874),(0.62992,0.7874),(0.6378,0.7874),(0.64567,0.7874),(0.65354,0.7874),(0.66142,0.7874),(0.66929,0.7874),(0.67717,0.7874),(0.68504,0.7874),(0.69291,0.7874),(0.70079,0.7874),(0.70866,0.7874),(0.71654,0.7874),(0.72441,0.7874),(0.73228,0.7874),(0.74016,0.7874),(0.74803,0.7874),(0.75591,0.7874),(0.76378,0.7874),(0.77165,0.7874),(0.77953,0.7874),(0.7874,0.7874),(0.79528,0.7874),(0.80315,0.7874),(0.81102,0.7874),(0.8189,0.7874),(0.82677,0.7874),(0.83465,0.7874),(0.84252,0.7874),(0.85039,0.7874),(0.85827,0.7874),(0.86614,0.7874),(0.87402,0.7874),(0.88189,0.7874),(0.88976,0.7874),(0.89764,0.7874),(0.90551,0.7874),(0.91339,0.7874),(0.92126,0.7874),(0.92913,0.7874),(0.93701,0.7874),(0.94488,0.7874),(0.95276,0.7874),(0.96063,0.7874),(0.9685,0.7874),(0.97638,0.7874),(0.98425,0.7874),(0.99213,0.7874),(0.99609,0.7874),(0.00391,0.79528),(0.00787,0.79528),(0.01575,0.79528),(0.02362,0.79528),(0.0315,0.79528),(0.03937,0.79528),(0.04724,0.79528),(0.05512,0.79528),(0.06299,0.79528),(0.07087,0.79528),(0.07874,0.79528),(0.08661,0.79528),(0.09449,0.79528),(0.10236,0.79528),(0.11024,0.79528),(0.11811,0.79528),(0.12598,0.79528),(0.13386,0.79528),(0.14173,0.79528),(0.14961,0.79528),(0.15748,0.79528),(0.16535,0.79528),(0.17323,0.79528),(0.1811,0.79528),(0.18898,0.79528),(0.19685,0.79528),(0.20472,0.79528),(0.2126,0.79528),(0.22047,0.79528),(0.22835,0.79528),(0.23622,0.79528),(0.24409,0.79528),(0.25197,0.79528),(0.25984,0.79528),(0.26772,0.79528),(0.27559,0.79528),(0.28346,0.79528),(0.29134,0.79528),(0.29921,0.79528),(0.30709,0.79528),(0.31496,0.79528),(0.32283,0.79528),(0.33071,0.79528),(0.33858,0.79528),(0.34646,0.79528),(0.35433,0.79528),(0.3622,0.79528),(0.37008,0.79528),(0.37795,0.79528),(0.38583,0.79528),(0.3937,0.79528),(0.40157,0.79528),(0.40945,0.79528),(0.41732,0.79528),(0.4252,0.79528),(0.43307,0.79528),(0.44094,0.79528),(0.44882,0.79528),(0.45669,0.79528),(0.46457,0.79528),(0.47244,0.79528),(0.48031,0.79528),(0.48819,0.79528),(0.49606,0.79528),(0.50394,0.79528),(0.51181,0.79528),(0.51969,0.79528),(0.52756,0.79528),(0.53543,0.79528),(0.54331,0.79528),(0.55118,0.79528),(0.55906,0.79528),(0.56693,0.79528),(0.5748,0.79528),(0.58268,0.79528),(0.59055,0.79528),(0.59843,0.79528),(0.6063,0.79528),(0.61417,0.79528),(0.62205,0.79528),(0.62992,0.79528),(0.6378,0.79528),(0.64567,0.79528),(0.65354,0.79528),(0.66142,0.79528),(0.66929,0.79528),(0.67717,0.79528),(0.68504,0.79528),(0.69291,0.79528),(0.70079,0.79528),(0.70866,0.79528),(0.71654,0.79528),(0.72441,0.79528),(0.73228,0.79528),(0.74016,0.79528),(0.74803,0.79528),(0.75591,0.79528),(0.76378,0.79528),(0.77165,0.79528),(0.77953,0.79528),(0.7874,0.79528),(0.79528,0.79528),(0.80315,0.79528),(0.81102,0.79528),(0.8189,0.79528),(0.82677,0.79528),(0.83465,0.79528),(0.84252,0.79528),(0.85039,0.79528),(0.85827,0.79528),(0.86614,0.79528),(0.87402,0.79528),(0.88189,0.79528),(0.88976,0.79528),(0.89764,0.79528),(0.90551,0.79528),(0.91339,0.79528),(0.92126,0.79528),(0.92913,0.79528),(0.93701,0.79528),(0.94488,0.79528),(0.95276,0.79528),(0.96063,0.79528),(0.9685,0.79528),(0.97638,0.79528),(0.98425,0.79528),(0.99213,0.79528),(0.99609,0.79528),(0.00391,0.80315),(0.00787,0.80315),(0.01575,0.80315),(0.02362,0.80315),(0.0315,0.80315),(0.03937,0.80315),(0.04724,0.80315),(0.05512,0.80315),(0.06299,0.80315),(0.07087,0.80315),(0.07874,0.80315),(0.08661,0.80315),(0.09449,0.80315),(0.10236,0.80315),(0.11024,0.80315),(0.11811,0.80315),(0.12598,0.80315),(0.13386,0.80315),(0.14173,0.80315),(0.14961,0.80315),(0.15748,0.80315),(0.16535,0.80315),(0.17323,0.80315),(0.1811,0.80315),(0.18898,0.80315),(0.19685,0.80315),(0.20472,0.80315),(0.2126,0.80315),(0.22047,0.80315),(0.22835,0.80315),(0.23622,0.80315),(0.24409,0.80315),(0.25197,0.80315),(0.25984,0.80315),(0.26772,0.80315),(0.27559,0.80315),(0.28346,0.80315),(0.29134,0.80315),(0.29921,0.80315),(0.30709,0.80315),(0.31496,0.80315),(0.32283,0.80315),(0.33071,0.80315),(0.33858,0.80315),(0.34646,0.80315),(0.35433,0.80315),(0.3622,0.80315),(0.37008,0.80315),(0.37795,0.80315),(0.38583,0.80315),(0.3937,0.80315),(0.40157,0.80315),(0.40945,0.80315),(0.41732,0.80315),(0.4252,0.80315),(0.43307,0.80315),(0.44094,0.80315),(0.44882,0.80315),(0.45669,0.80315),(0.46457,0.80315),(0.47244,0.80315),(0.48031,0.80315),(0.48819,0.80315),(0.49606,0.80315),(0.50394,0.80315),(0.51181,0.80315),(0.51969,0.80315),(0.52756,0.80315),(0.53543,0.80315),(0.54331,0.80315),(0.55118,0.80315),(0.55906,0.80315),(0.56693,0.80315),(0.5748,0.80315),(0.58268,0.80315),(0.59055,0.80315),(0.59843,0.80315),(0.6063,0.80315),(0.61417,0.80315),(0.62205,0.80315),(0.62992,0.80315),(0.6378,0.80315),(0.64567,0.80315),(0.65354,0.80315),(0.66142,0.80315),(0.66929,0.80315),(0.67717,0.80315),(0.68504,0.80315),(0.69291,0.80315),(0.70079,0.80315),(0.70866,0.80315),(0.71654,0.80315),(0.72441,0.80315),(0.73228,0.80315),(0.74016,0.80315),(0.74803,0.80315),(0.75591,0.80315),(0.76378,0.80315),(0.77165,0.80315),(0.77953,0.80315),(0.7874,0.80315),(0.79528,0.80315),(0.80315,0.80315),(0.81102,0.80315),(0.8189,0.80315),(0.82677,0.80315),(0.83465,0.80315),(0.84252,0.80315),(0.85039,0.80315),(0.85827,0.80315),(0.86614,0.80315),(0.87402,0.80315),(0.88189,0.80315),(0.88976,0.80315),(0.89764,0.80315),(0.90551,0.80315),(0.91339,0.80315),(0.92126,0.80315),(0.92913,0.80315),(0.93701,0.80315),(0.94488,0.80315),(0.95276,0.80315),(0.96063,0.80315),(0.9685,0.80315),(0.97638,0.80315),(0.98425,0.80315),(0.99213,0.80315),(0.99609,0.80315),(0.00391,0.81102),(0.00787,0.81102),(0.01575,0.81102),(0.02362,0.81102),(0.0315,0.81102),(0.03937,0.81102),(0.04724,0.81102),(0.05512,0.81102),(0.06299,0.81102),(0.07087,0.81102),(0.07874,0.81102),(0.08661,0.81102),(0.09449,0.81102),(0.10236,0.81102),(0.11024,0.81102),(0.11811,0.81102),(0.12598,0.81102),(0.13386,0.81102),(0.14173,0.81102),(0.14961,0.81102),(0.15748,0.81102),(0.16535,0.81102),(0.17323,0.81102),(0.1811,0.81102),(0.18898,0.81102),(0.19685,0.81102),(0.20472,0.81102),(0.2126,0.81102),(0.22047,0.81102),(0.22835,0.81102),(0.23622,0.81102),(0.24409,0.81102),(0.25197,0.81102),(0.25984,0.81102),(0.26772,0.81102),(0.27559,0.81102),(0.28346,0.81102),(0.29134,0.81102),(0.29921,0.81102),(0.30709,0.81102),(0.31496,0.81102),(0.32283,0.81102),(0.33071,0.81102),(0.33858,0.81102),(0.34646,0.81102),(0.35433,0.81102),(0.3622,0.81102),(0.37008,0.81102),(0.37795,0.81102),(0.38583,0.81102),(0.3937,0.81102),(0.40157,0.81102),(0.40945,0.81102),(0.41732,0.81102),(0.4252,0.81102),(0.43307,0.81102),(0.44094,0.81102),(0.44882,0.81102),(0.45669,0.81102),(0.46457,0.81102),(0.47244,0.81102),(0.48031,0.81102),(0.48819,0.81102),(0.49606,0.81102),(0.50394,0.81102),(0.51181,0.81102),(0.51969,0.81102),(0.52756,0.81102),(0.53543,0.81102),(0.54331,0.81102),(0.55118,0.81102),(0.55906,0.81102),(0.56693,0.81102),(0.5748,0.81102),(0.58268,0.81102),(0.59055,0.81102),(0.59843,0.81102),(0.6063,0.81102),(0.61417,0.81102),(0.62205,0.81102),(0.62992,0.81102),(0.6378,0.81102),(0.64567,0.81102),(0.65354,0.81102),(0.66142,0.81102),(0.66929,0.81102),(0.67717,0.81102),(0.68504,0.81102),(0.69291,0.81102),(0.70079,0.81102),(0.70866,0.81102),(0.71654,0.81102),(0.72441,0.81102),(0.73228,0.81102),(0.74016,0.81102),(0.74803,0.81102),(0.75591,0.81102),(0.76378,0.81102),(0.77165,0.81102),(0.77953,0.81102),(0.7874,0.81102),(0.79528,0.81102),(0.80315,0.81102),(0.81102,0.81102),(0.8189,0.81102),(0.82677,0.81102),(0.83465,0.81102),(0.84252,0.81102),(0.85039,0.81102),(0.85827,0.81102),(0.86614,0.81102),(0.87402,0.81102),(0.88189,0.81102),(0.88976,0.81102),(0.89764,0.81102),(0.90551,0.81102),(0.91339,0.81102),(0.92126,0.81102),(0.92913,0.81102),(0.93701,0.81102),(0.94488,0.81102),(0.95276,0.81102),(0.96063,0.81102),(0.9685,0.81102),(0.97638,0.81102),(0.98425,0.81102),(0.99213,0.81102),(0.99609,0.81102),(0.00391,0.8189),(0.00787,0.8189),(0.01575,0.8189),(0.02362,0.8189),(0.0315,0.8189),(0.03937,0.8189),(0.04724,0.8189),(0.05512,0.8189),(0.06299,0.8189),(0.07087,0.8189),(0.07874,0.8189),(0.08661,0.8189),(0.09449,0.8189),(0.10236,0.8189),(0.11024,0.8189),(0.11811,0.8189),(0.12598,0.8189),(0.13386,0.8189),(0.14173,0.8189),(0.14961,0.8189),(0.15748,0.8189),(0.16535,0.8189),(0.17323,0.8189),(0.1811,0.8189),(0.18898,0.8189),(0.19685,0.8189),(0.20472,0.8189),(0.2126,0.8189),(0.22047,0.8189),(0.22835,0.8189),(0.23622,0.8189),(0.24409,0.8189),(0.25197,0.8189),(0.25984,0.8189),(0.26772,0.8189),(0.27559,0.8189),(0.28346,0.8189),(0.29134,0.8189),(0.29921,0.8189),(0.30709,0.8189),(0.31496,0.8189),(0.32283,0.8189),(0.33071,0.8189),(0.33858,0.8189),(0.34646,0.8189),(0.35433,0.8189),(0.3622,0.8189),(0.37008,0.8189),(0.37795,0.8189),(0.38583,0.8189),(0.3937,0.8189),(0.40157,0.8189),(0.40945,0.8189),(0.41732,0.8189),(0.4252,0.8189),(0.43307,0.8189),(0.44094,0.8189),(0.44882,0.8189),(0.45669,0.8189),(0.46457,0.8189),(0.47244,0.8189),(0.48031,0.8189),(0.48819,0.8189),(0.49606,0.8189),(0.50394,0.8189),(0.51181,0.8189),(0.51969,0.8189),(0.52756,0.8189),(0.53543,0.8189),(0.54331,0.8189),(0.55118,0.8189),(0.55906,0.8189),(0.56693,0.8189),(0.5748,0.8189),(0.58268,0.8189),(0.59055,0.8189),(0.59843,0.8189),(0.6063,0.8189),(0.61417,0.8189),(0.62205,0.8189),(0.62992,0.8189),(0.6378,0.8189),(0.64567,0.8189),(0.65354,0.8189),(0.66142,0.8189),(0.66929,0.8189),(0.67717,0.8189),(0.68504,0.8189),(0.69291,0.8189),(0.70079,0.8189),(0.70866,0.8189),(0.71654,0.8189),(0.72441,0.8189),(0.73228,0.8189),(0.74016,0.8189),(0.74803,0.8189),(0.75591,0.8189),(0.76378,0.8189),(0.77165,0.8189),(0.77953,0.8189),(0.7874,0.8189),(0.79528,0.8189),(0.80315,0.8189),(0.81102,0.8189),(0.8189,0.8189),(0.82677,0.8189),(0.83465,0.8189),(0.84252,0.8189),(0.85039,0.8189),(0.85827,0.8189),(0.86614,0.8189),(0.87402,0.8189),(0.88189,0.8189),(0.88976,0.8189),(0.89764,0.8189),(0.90551,0.8189),(0.91339,0.8189),(0.92126,0.8189),(0.92913,0.8189),(0.93701,0.8189),(0.94488,0.8189),(0.95276,0.8189),(0.96063,0.8189),(0.9685,0.8189),(0.97638,0.8189),(0.98425,0.8189),(0.99213,0.8189),(0.99609,0.8189),(0.00391,0.82677),(0.00787,0.82677),(0.01575,0.82677),(0.02362,0.82677),(0.0315,0.82677),(0.03937,0.82677),(0.04724,0.82677),(0.05512,0.82677),(0.06299,0.82677),(0.07087,0.82677),(0.07874,0.82677),(0.08661,0.82677),(0.09449,0.82677),(0.10236,0.82677),(0.11024,0.82677),(0.11811,0.82677),(0.12598,0.82677),(0.13386,0.82677),(0.14173,0.82677),(0.14961,0.82677),(0.15748,0.82677),(0.16535,0.82677),(0.17323,0.82677),(0.1811,0.82677),(0.18898,0.82677),(0.19685,0.82677),(0.20472,0.82677),(0.2126,0.82677),(0.22047,0.82677),(0.22835,0.82677),(0.23622,0.82677),(0.24409,0.82677),(0.25197,0.82677),(0.25984,0.82677),(0.26772,0.82677),(0.27559,0.82677),(0.28346,0.82677),(0.29134,0.82677),(0.29921,0.82677),(0.30709,0.82677),(0.31496,0.82677),(0.32283,0.82677),(0.33071,0.82677),(0.33858,0.82677),(0.34646,0.82677),(0.35433,0.82677),(0.3622,0.82677),(0.37008,0.82677),(0.37795,0.82677),(0.38583,0.82677),(0.3937,0.82677),(0.40157,0.82677),(0.40945,0.82677),(0.41732,0.82677),(0.4252,0.82677),(0.43307,0.82677),(0.44094,0.82677),(0.44882,0.82677),(0.45669,0.82677),(0.46457,0.82677),(0.47244,0.82677),(0.48031,0.82677),(0.48819,0.82677),(0.49606,0.82677),(0.50394,0.82677),(0.51181,0.82677),(0.51969,0.82677),(0.52756,0.82677),(0.53543,0.82677),(0.54331,0.82677),(0.55118,0.82677),(0.55906,0.82677),(0.56693,0.82677),(0.5748,0.82677),(0.58268,0.82677),(0.59055,0.82677),(0.59843,0.82677),(0.6063,0.82677),(0.61417,0.82677),(0.62205,0.82677),(0.62992,0.82677),(0.6378,0.82677),(0.64567,0.82677),(0.65354,0.82677),(0.66142,0.82677),(0.66929,0.82677),(0.67717,0.82677),(0.68504,0.82677),(0.69291,0.82677),(0.70079,0.82677),(0.70866,0.82677),(0.71654,0.82677),(0.72441,0.82677),(0.73228,0.82677),(0.74016,0.82677),(0.74803,0.82677),(0.75591,0.82677),(0.76378,0.82677),(0.77165,0.82677),(0.77953,0.82677),(0.7874,0.82677),(0.79528,0.82677),(0.80315,0.82677),(0.81102,0.82677),(0.8189,0.82677),(0.82677,0.82677),(0.83465,0.82677),(0.84252,0.82677),(0.85039,0.82677),(0.85827,0.82677),(0.86614,0.82677),(0.87402,0.82677),(0.88189,0.82677),(0.88976,0.82677),(0.89764,0.82677),(0.90551,0.82677),(0.91339,0.82677),(0.92126,0.82677),(0.92913,0.82677),(0.93701,0.82677),(0.94488,0.82677),(0.95276,0.82677),(0.96063,0.82677),(0.9685,0.82677),(0.97638,0.82677),(0.98425,0.82677),(0.99213,0.82677),(0.99609,0.82677),(0.00391,0.83465),(0.00787,0.83465),(0.01575,0.83465),(0.02362,0.83465),(0.0315,0.83465),(0.03937,0.83465),(0.04724,0.83465),(0.05512,0.83465),(0.06299,0.83465),(0.07087,0.83465),(0.07874,0.83465),(0.08661,0.83465),(0.09449,0.83465),(0.10236,0.83465),(0.11024,0.83465),(0.11811,0.83465),(0.12598,0.83465),(0.13386,0.83465),(0.14173,0.83465),(0.14961,0.83465),(0.15748,0.83465),(0.16535,0.83465),(0.17323,0.83465),(0.1811,0.83465),(0.18898,0.83465),(0.19685,0.83465),(0.20472,0.83465),(0.2126,0.83465),(0.22047,0.83465),(0.22835,0.83465),(0.23622,0.83465),(0.24409,0.83465),(0.25197,0.83465),(0.25984,0.83465),(0.26772,0.83465),(0.27559,0.83465),(0.28346,0.83465),(0.29134,0.83465),(0.29921,0.83465),(0.30709,0.83465),(0.31496,0.83465),(0.32283,0.83465),(0.33071,0.83465),(0.33858,0.83465),(0.34646,0.83465),(0.35433,0.83465),(0.3622,0.83465),(0.37008,0.83465),(0.37795,0.83465),(0.38583,0.83465),(0.3937,0.83465),(0.40157,0.83465),(0.40945,0.83465),(0.41732,0.83465),(0.4252,0.83465),(0.43307,0.83465),(0.44094,0.83465),(0.44882,0.83465),(0.45669,0.83465),(0.46457,0.83465),(0.47244,0.83465),(0.48031,0.83465),(0.48819,0.83465),(0.49606,0.83465),(0.50394,0.83465),(0.51181,0.83465),(0.51969,0.83465),(0.52756,0.83465),(0.53543,0.83465),(0.54331,0.83465),(0.55118,0.83465),(0.55906,0.83465),(0.56693,0.83465),(0.5748,0.83465),(0.58268,0.83465),(0.59055,0.83465),(0.59843,0.83465),(0.6063,0.83465),(0.61417,0.83465),(0.62205,0.83465),(0.62992,0.83465),(0.6378,0.83465),(0.64567,0.83465),(0.65354,0.83465),(0.66142,0.83465),(0.66929,0.83465),(0.67717,0.83465),(0.68504,0.83465),(0.69291,0.83465),(0.70079,0.83465),(0.70866,0.83465),(0.71654,0.83465),(0.72441,0.83465),(0.73228,0.83465),(0.74016,0.83465),(0.74803,0.83465),(0.75591,0.83465),(0.76378,0.83465),(0.77165,0.83465),(0.77953,0.83465),(0.7874,0.83465),(0.79528,0.83465),(0.80315,0.83465),(0.81102,0.83465),(0.8189,0.83465),(0.82677,0.83465),(0.83465,0.83465),(0.84252,0.83465),(0.85039,0.83465),(0.85827,0.83465),(0.86614,0.83465),(0.87402,0.83465),(0.88189,0.83465),(0.88976,0.83465),(0.89764,0.83465),(0.90551,0.83465),(0.91339,0.83465),(0.92126,0.83465),(0.92913,0.83465),(0.93701,0.83465),(0.94488,0.83465),(0.95276,0.83465),(0.96063,0.83465),(0.9685,0.83465),(0.97638,0.83465),(0.98425,0.83465),(0.99213,0.83465),(0.99609,0.83465),(0.00391,0.84252),(0.00787,0.84252),(0.01575,0.84252),(0.02362,0.84252),(0.0315,0.84252),(0.03937,0.84252),(0.04724,0.84252),(0.05512,0.84252),(0.06299,0.84252),(0.07087,0.84252),(0.07874,0.84252),(0.08661,0.84252),(0.09449,0.84252),(0.10236,0.84252),(0.11024,0.84252),(0.11811,0.84252),(0.12598,0.84252),(0.13386,0.84252),(0.14173,0.84252),(0.14961,0.84252),(0.15748,0.84252),(0.16535,0.84252),(0.17323,0.84252),(0.1811,0.84252),(0.18898,0.84252),(0.19685,0.84252),(0.20472,0.84252),(0.2126,0.84252),(0.22047,0.84252),(0.22835,0.84252),(0.23622,0.84252),(0.24409,0.84252),(0.25197,0.84252),(0.25984,0.84252),(0.26772,0.84252),(0.27559,0.84252),(0.28346,0.84252),(0.29134,0.84252),(0.29921,0.84252),(0.30709,0.84252),(0.31496,0.84252),(0.32283,0.84252),(0.33071,0.84252),(0.33858,0.84252),(0.34646,0.84252),(0.35433,0.84252),(0.3622,0.84252),(0.37008,0.84252),(0.37795,0.84252),(0.38583,0.84252),(0.3937,0.84252),(0.40157,0.84252),(0.40945,0.84252),(0.41732,0.84252),(0.4252,0.84252),(0.43307,0.84252),(0.44094,0.84252),(0.44882,0.84252),(0.45669,0.84252),(0.46457,0.84252),(0.47244,0.84252),(0.48031,0.84252),(0.48819,0.84252),(0.49606,0.84252),(0.50394,0.84252),(0.51181,0.84252),(0.51969,0.84252),(0.52756,0.84252),(0.53543,0.84252),(0.54331,0.84252),(0.55118,0.84252),(0.55906,0.84252),(0.56693,0.84252),(0.5748,0.84252),(0.58268,0.84252),(0.59055,0.84252),(0.59843,0.84252),(0.6063,0.84252),(0.61417,0.84252),(0.62205,0.84252),(0.62992,0.84252),(0.6378,0.84252),(0.64567,0.84252),(0.65354,0.84252),(0.66142,0.84252),(0.66929,0.84252),(0.67717,0.84252),(0.68504,0.84252),(0.69291,0.84252),(0.70079,0.84252),(0.70866,0.84252),(0.71654,0.84252),(0.72441,0.84252),(0.73228,0.84252),(0.74016,0.84252),(0.74803,0.84252),(0.75591,0.84252),(0.76378,0.84252),(0.77165,0.84252),(0.77953,0.84252),(0.7874,0.84252),(0.79528,0.84252),(0.80315,0.84252),(0.81102,0.84252),(0.8189,0.84252),(0.82677,0.84252),(0.83465,0.84252),(0.84252,0.84252),(0.85039,0.84252),(0.85827,0.84252),(0.86614,0.84252),(0.87402,0.84252),(0.88189,0.84252),(0.88976,0.84252),(0.89764,0.84252),(0.90551,0.84252),(0.91339,0.84252),(0.92126,0.84252),(0.92913,0.84252),(0.93701,0.84252),(0.94488,0.84252),(0.95276,0.84252),(0.96063,0.84252),(0.9685,0.84252),(0.97638,0.84252),(0.98425,0.84252),(0.99213,0.84252),(0.99609,0.84252),(0.00391,0.85039),(0.00787,0.85039),(0.01575,0.85039),(0.02362,0.85039),(0.0315,0.85039),(0.03937,0.85039),(0.04724,0.85039),(0.05512,0.85039),(0.06299,0.85039),(0.07087,0.85039),(0.07874,0.85039),(0.08661,0.85039),(0.09449,0.85039),(0.10236,0.85039),(0.11024,0.85039),(0.11811,0.85039),(0.12598,0.85039),(0.13386,0.85039),(0.14173,0.85039),(0.14961,0.85039),(0.15748,0.85039),(0.16535,0.85039),(0.17323,0.85039),(0.1811,0.85039),(0.18898,0.85039),(0.19685,0.85039),(0.20472,0.85039),(0.2126,0.85039),(0.22047,0.85039),(0.22835,0.85039),(0.23622,0.85039),(0.24409,0.85039),(0.25197,0.85039),(0.25984,0.85039),(0.26772,0.85039),(0.27559,0.85039),(0.28346,0.85039),(0.29134,0.85039),(0.29921,0.85039),(0.30709,0.85039),(0.31496,0.85039),(0.32283,0.85039),(0.33071,0.85039),(0.33858,0.85039),(0.34646,0.85039),(0.35433,0.85039),(0.3622,0.85039),(0.37008,0.85039),(0.37795,0.85039),(0.38583,0.85039),(0.3937,0.85039),(0.40157,0.85039),(0.40945,0.85039),(0.41732,0.85039),(0.4252,0.85039),(0.43307,0.85039),(0.44094,0.85039),(0.44882,0.85039),(0.45669,0.85039),(0.46457,0.85039),(0.47244,0.85039),(0.48031,0.85039),(0.48819,0.85039),(0.49606,0.85039),(0.50394,0.85039),(0.51181,0.85039),(0.51969,0.85039),(0.52756,0.85039),(0.53543,0.85039),(0.54331,0.85039),(0.55118,0.85039),(0.55906,0.85039),(0.56693,0.85039),(0.5748,0.85039),(0.58268,0.85039),(0.59055,0.85039),(0.59843,0.85039),(0.6063,0.85039),(0.61417,0.85039),(0.62205,0.85039),(0.62992,0.85039),(0.6378,0.85039),(0.64567,0.85039),(0.65354,0.85039),(0.66142,0.85039),(0.66929,0.85039),(0.67717,0.85039),(0.68504,0.85039),(0.69291,0.85039),(0.70079,0.85039),(0.70866,0.85039),(0.71654,0.85039),(0.72441,0.85039),(0.73228,0.85039),(0.74016,0.85039),(0.74803,0.85039),(0.75591,0.85039),(0.76378,0.85039),(0.77165,0.85039),(0.77953,0.85039),(0.7874,0.85039),(0.79528,0.85039),(0.80315,0.85039),(0.81102,0.85039),(0.8189,0.85039),(0.82677,0.85039),(0.83465,0.85039),(0.84252,0.85039),(0.85039,0.85039),(0.85827,0.85039),(0.86614,0.85039),(0.87402,0.85039),(0.88189,0.85039),(0.88976,0.85039),(0.89764,0.85039),(0.90551,0.85039),(0.91339,0.85039),(0.92126,0.85039),(0.92913,0.85039),(0.93701,0.85039),(0.94488,0.85039),(0.95276,0.85039),(0.96063,0.85039),(0.9685,0.85039),(0.97638,0.85039),(0.98425,0.85039),(0.99213,0.85039),(0.99609,0.85039),(0.00391,0.85827),(0.00787,0.85827),(0.01575,0.85827),(0.02362,0.85827),(0.0315,0.85827),(0.03937,0.85827),(0.04724,0.85827),(0.05512,0.85827),(0.06299,0.85827),(0.07087,0.85827),(0.07874,0.85827),(0.08661,0.85827),(0.09449,0.85827),(0.10236,0.85827),(0.11024,0.85827),(0.11811,0.85827),(0.12598,0.85827),(0.13386,0.85827),(0.14173,0.85827),(0.14961,0.85827),(0.15748,0.85827),(0.16535,0.85827),(0.17323,0.85827),(0.1811,0.85827),(0.18898,0.85827),(0.19685,0.85827),(0.20472,0.85827),(0.2126,0.85827),(0.22047,0.85827),(0.22835,0.85827),(0.23622,0.85827),(0.24409,0.85827),(0.25197,0.85827),(0.25984,0.85827),(0.26772,0.85827),(0.27559,0.85827),(0.28346,0.85827),(0.29134,0.85827),(0.29921,0.85827),(0.30709,0.85827),(0.31496,0.85827),(0.32283,0.85827),(0.33071,0.85827),(0.33858,0.85827),(0.34646,0.85827),(0.35433,0.85827),(0.3622,0.85827),(0.37008,0.85827),(0.37795,0.85827),(0.38583,0.85827),(0.3937,0.85827),(0.40157,0.85827),(0.40945,0.85827),(0.41732,0.85827),(0.4252,0.85827),(0.43307,0.85827),(0.44094,0.85827),(0.44882,0.85827),(0.45669,0.85827),(0.46457,0.85827),(0.47244,0.85827),(0.48031,0.85827),(0.48819,0.85827),(0.49606,0.85827),(0.50394,0.85827),(0.51181,0.85827),(0.51969,0.85827),(0.52756,0.85827),(0.53543,0.85827),(0.54331,0.85827),(0.55118,0.85827),(0.55906,0.85827),(0.56693,0.85827),(0.5748,0.85827),(0.58268,0.85827),(0.59055,0.85827),(0.59843,0.85827),(0.6063,0.85827),(0.61417,0.85827),(0.62205,0.85827),(0.62992,0.85827),(0.6378,0.85827),(0.64567,0.85827),(0.65354,0.85827),(0.66142,0.85827),(0.66929,0.85827),(0.67717,0.85827),(0.68504,0.85827),(0.69291,0.85827),(0.70079,0.85827),(0.70866,0.85827),(0.71654,0.85827),(0.72441,0.85827),(0.73228,0.85827),(0.74016,0.85827),(0.74803,0.85827),(0.75591,0.85827),(0.76378,0.85827),(0.77165,0.85827),(0.77953,0.85827),(0.7874,0.85827),(0.79528,0.85827),(0.80315,0.85827),(0.81102,0.85827),(0.8189,0.85827),(0.82677,0.85827),(0.83465,0.85827),(0.84252,0.85827),(0.85039,0.85827),(0.85827,0.85827),(0.86614,0.85827),(0.87402,0.85827),(0.88189,0.85827),(0.88976,0.85827),(0.89764,0.85827),(0.90551,0.85827),(0.91339,0.85827),(0.92126,0.85827),(0.92913,0.85827),(0.93701,0.85827),(0.94488,0.85827),(0.95276,0.85827),(0.96063,0.85827),(0.9685,0.85827),(0.97638,0.85827),(0.98425,0.85827),(0.99213,0.85827),(0.99609,0.85827),(0.00391,0.86614),(0.00787,0.86614),(0.01575,0.86614),(0.02362,0.86614),(0.0315,0.86614),(0.03937,0.86614),(0.04724,0.86614),(0.05512,0.86614),(0.06299,0.86614),(0.07087,0.86614),(0.07874,0.86614),(0.08661,0.86614),(0.09449,0.86614),(0.10236,0.86614),(0.11024,0.86614),(0.11811,0.86614),(0.12598,0.86614),(0.13386,0.86614),(0.14173,0.86614),(0.14961,0.86614),(0.15748,0.86614),(0.16535,0.86614),(0.17323,0.86614),(0.1811,0.86614),(0.18898,0.86614),(0.19685,0.86614),(0.20472,0.86614),(0.2126,0.86614),(0.22047,0.86614),(0.22835,0.86614),(0.23622,0.86614),(0.24409,0.86614),(0.25197,0.86614),(0.25984,0.86614),(0.26772,0.86614),(0.27559,0.86614),(0.28346,0.86614),(0.29134,0.86614),(0.29921,0.86614),(0.30709,0.86614),(0.31496,0.86614),(0.32283,0.86614),(0.33071,0.86614),(0.33858,0.86614),(0.34646,0.86614),(0.35433,0.86614),(0.3622,0.86614),(0.37008,0.86614),(0.37795,0.86614),(0.38583,0.86614),(0.3937,0.86614),(0.40157,0.86614),(0.40945,0.86614),(0.41732,0.86614),(0.4252,0.86614),(0.43307,0.86614),(0.44094,0.86614),(0.44882,0.86614),(0.45669,0.86614),(0.46457,0.86614),(0.47244,0.86614),(0.48031,0.86614),(0.48819,0.86614),(0.49606,0.86614),(0.50394,0.86614),(0.51181,0.86614),(0.51969,0.86614),(0.52756,0.86614),(0.53543,0.86614),(0.54331,0.86614),(0.55118,0.86614),(0.55906,0.86614),(0.56693,0.86614),(0.5748,0.86614),(0.58268,0.86614),(0.59055,0.86614),(0.59843,0.86614),(0.6063,0.86614),(0.61417,0.86614),(0.62205,0.86614),(0.62992,0.86614),(0.6378,0.86614),(0.64567,0.86614),(0.65354,0.86614),(0.66142,0.86614),(0.66929,0.86614),(0.67717,0.86614),(0.68504,0.86614),(0.69291,0.86614),(0.70079,0.86614),(0.70866,0.86614),(0.71654,0.86614),(0.72441,0.86614),(0.73228,0.86614),(0.74016,0.86614),(0.74803,0.86614),(0.75591,0.86614),(0.76378,0.86614),(0.77165,0.86614),(0.77953,0.86614),(0.7874,0.86614),(0.79528,0.86614),(0.80315,0.86614),(0.81102,0.86614),(0.8189,0.86614),(0.82677,0.86614),(0.83465,0.86614),(0.84252,0.86614),(0.85039,0.86614),(0.85827,0.86614),(0.86614,0.86614),(0.87402,0.86614),(0.88189,0.86614),(0.88976,0.86614),(0.89764,0.86614),(0.90551,0.86614),(0.91339,0.86614),(0.92126,0.86614),(0.92913,0.86614),(0.93701,0.86614),(0.94488,0.86614),(0.95276,0.86614),(0.96063,0.86614),(0.9685,0.86614),(0.97638,0.86614),(0.98425,0.86614),(0.99213,0.86614),(0.99609,0.86614),(0.00391,0.87402),(0.00787,0.87402),(0.01575,0.87402),(0.02362,0.87402),(0.0315,0.87402),(0.03937,0.87402),(0.04724,0.87402),(0.05512,0.87402),(0.06299,0.87402),(0.07087,0.87402),(0.07874,0.87402),(0.08661,0.87402),(0.09449,0.87402),(0.10236,0.87402),(0.11024,0.87402),(0.11811,0.87402),(0.12598,0.87402),(0.13386,0.87402),(0.14173,0.87402),(0.14961,0.87402),(0.15748,0.87402),(0.16535,0.87402),(0.17323,0.87402),(0.1811,0.87402),(0.18898,0.87402),(0.19685,0.87402),(0.20472,0.87402),(0.2126,0.87402),(0.22047,0.87402),(0.22835,0.87402),(0.23622,0.87402),(0.24409,0.87402),(0.25197,0.87402),(0.25984,0.87402),(0.26772,0.87402),(0.27559,0.87402),(0.28346,0.87402),(0.29134,0.87402),(0.29921,0.87402),(0.30709,0.87402),(0.31496,0.87402),(0.32283,0.87402),(0.33071,0.87402),(0.33858,0.87402),(0.34646,0.87402),(0.35433,0.87402),(0.3622,0.87402),(0.37008,0.87402),(0.37795,0.87402),(0.38583,0.87402),(0.3937,0.87402),(0.40157,0.87402),(0.40945,0.87402),(0.41732,0.87402),(0.4252,0.87402),(0.43307,0.87402),(0.44094,0.87402),(0.44882,0.87402),(0.45669,0.87402),(0.46457,0.87402),(0.47244,0.87402),(0.48031,0.87402),(0.48819,0.87402),(0.49606,0.87402),(0.50394,0.87402),(0.51181,0.87402),(0.51969,0.87402),(0.52756,0.87402),(0.53543,0.87402),(0.54331,0.87402),(0.55118,0.87402),(0.55906,0.87402),(0.56693,0.87402),(0.5748,0.87402),(0.58268,0.87402),(0.59055,0.87402),(0.59843,0.87402),(0.6063,0.87402),(0.61417,0.87402),(0.62205,0.87402),(0.62992,0.87402),(0.6378,0.87402),(0.64567,0.87402),(0.65354,0.87402),(0.66142,0.87402),(0.66929,0.87402),(0.67717,0.87402),(0.68504,0.87402),(0.69291,0.87402),(0.70079,0.87402),(0.70866,0.87402),(0.71654,0.87402),(0.72441,0.87402),(0.73228,0.87402),(0.74016,0.87402),(0.74803,0.87402),(0.75591,0.87402),(0.76378,0.87402),(0.77165,0.87402),(0.77953,0.87402),(0.7874,0.87402),(0.79528,0.87402),(0.80315,0.87402),(0.81102,0.87402),(0.8189,0.87402),(0.82677,0.87402),(0.83465,0.87402),(0.84252,0.87402),(0.85039,0.87402),(0.85827,0.87402),(0.86614,0.87402),(0.87402,0.87402),(0.88189,0.87402),(0.88976,0.87402),(0.89764,0.87402),(0.90551,0.87402),(0.91339,0.87402),(0.92126,0.87402),(0.92913,0.87402),(0.93701,0.87402),(0.94488,0.87402),(0.95276,0.87402),(0.96063,0.87402),(0.9685,0.87402),(0.97638,0.87402),(0.98425,0.87402),(0.99213,0.87402),(0.99609,0.87402),(0.00391,0.88189),(0.00787,0.88189),(0.01575,0.88189),(0.02362,0.88189),(0.0315,0.88189),(0.03937,0.88189),(0.04724,0.88189),(0.05512,0.88189),(0.06299,0.88189),(0.07087,0.88189),(0.07874,0.88189),(0.08661,0.88189),(0.09449,0.88189),(0.10236,0.88189),(0.11024,0.88189),(0.11811,0.88189),(0.12598,0.88189),(0.13386,0.88189),(0.14173,0.88189),(0.14961,0.88189),(0.15748,0.88189),(0.16535,0.88189),(0.17323,0.88189),(0.1811,0.88189),(0.18898,0.88189),(0.19685,0.88189),(0.20472,0.88189),(0.2126,0.88189),(0.22047,0.88189),(0.22835,0.88189),(0.23622,0.88189),(0.24409,0.88189),(0.25197,0.88189),(0.25984,0.88189),(0.26772,0.88189),(0.27559,0.88189),(0.28346,0.88189),(0.29134,0.88189),(0.29921,0.88189),(0.30709,0.88189),(0.31496,0.88189),(0.32283,0.88189),(0.33071,0.88189),(0.33858,0.88189),(0.34646,0.88189),(0.35433,0.88189),(0.3622,0.88189),(0.37008,0.88189),(0.37795,0.88189),(0.38583,0.88189),(0.3937,0.88189),(0.40157,0.88189),(0.40945,0.88189),(0.41732,0.88189),(0.4252,0.88189),(0.43307,0.88189),(0.44094,0.88189),(0.44882,0.88189),(0.45669,0.88189),(0.46457,0.88189),(0.47244,0.88189),(0.48031,0.88189),(0.48819,0.88189),(0.49606,0.88189),(0.50394,0.88189),(0.51181,0.88189),(0.51969,0.88189),(0.52756,0.88189),(0.53543,0.88189),(0.54331,0.88189),(0.55118,0.88189),(0.55906,0.88189),(0.56693,0.88189),(0.5748,0.88189),(0.58268,0.88189),(0.59055,0.88189),(0.59843,0.88189),(0.6063,0.88189),(0.61417,0.88189),(0.62205,0.88189),(0.62992,0.88189),(0.6378,0.88189),(0.64567,0.88189),(0.65354,0.88189),(0.66142,0.88189),(0.66929,0.88189),(0.67717,0.88189),(0.68504,0.88189),(0.69291,0.88189),(0.70079,0.88189),(0.70866,0.88189),(0.71654,0.88189),(0.72441,0.88189),(0.73228,0.88189),(0.74016,0.88189),(0.74803,0.88189),(0.75591,0.88189),(0.76378,0.88189),(0.77165,0.88189),(0.77953,0.88189),(0.7874,0.88189),(0.79528,0.88189),(0.80315,0.88189),(0.81102,0.88189),(0.8189,0.88189),(0.82677,0.88189),(0.83465,0.88189),(0.84252,0.88189),(0.85039,0.88189),(0.85827,0.88189),(0.86614,0.88189),(0.87402,0.88189),(0.88189,0.88189),(0.88976,0.88189),(0.89764,0.88189),(0.90551,0.88189),(0.91339,0.88189),(0.92126,0.88189),(0.92913,0.88189),(0.93701,0.88189),(0.94488,0.88189),(0.95276,0.88189),(0.96063,0.88189),(0.9685,0.88189),(0.97638,0.88189),(0.98425,0.88189),(0.99213,0.88189),(0.99609,0.88189),(0.00391,0.88976),(0.00787,0.88976),(0.01575,0.88976),(0.02362,0.88976),(0.0315,0.88976),(0.03937,0.88976),(0.04724,0.88976),(0.05512,0.88976),(0.06299,0.88976),(0.07087,0.88976),(0.07874,0.88976),(0.08661,0.88976),(0.09449,0.88976),(0.10236,0.88976),(0.11024,0.88976),(0.11811,0.88976),(0.12598,0.88976),(0.13386,0.88976),(0.14173,0.88976),(0.14961,0.88976),(0.15748,0.88976),(0.16535,0.88976),(0.17323,0.88976),(0.1811,0.88976),(0.18898,0.88976),(0.19685,0.88976),(0.20472,0.88976),(0.2126,0.88976),(0.22047,0.88976),(0.22835,0.88976),(0.23622,0.88976),(0.24409,0.88976),(0.25197,0.88976),(0.25984,0.88976),(0.26772,0.88976),(0.27559,0.88976),(0.28346,0.88976),(0.29134,0.88976),(0.29921,0.88976),(0.30709,0.88976),(0.31496,0.88976),(0.32283,0.88976),(0.33071,0.88976),(0.33858,0.88976),(0.34646,0.88976),(0.35433,0.88976),(0.3622,0.88976),(0.37008,0.88976),(0.37795,0.88976),(0.38583,0.88976),(0.3937,0.88976),(0.40157,0.88976),(0.40945,0.88976),(0.41732,0.88976),(0.4252,0.88976),(0.43307,0.88976),(0.44094,0.88976),(0.44882,0.88976),(0.45669,0.88976),(0.46457,0.88976),(0.47244,0.88976),(0.48031,0.88976),(0.48819,0.88976),(0.49606,0.88976),(0.50394,0.88976),(0.51181,0.88976),(0.51969,0.88976),(0.52756,0.88976),(0.53543,0.88976),(0.54331,0.88976),(0.55118,0.88976),(0.55906,0.88976),(0.56693,0.88976),(0.5748,0.88976),(0.58268,0.88976),(0.59055,0.88976),(0.59843,0.88976),(0.6063,0.88976),(0.61417,0.88976),(0.62205,0.88976),(0.62992,0.88976),(0.6378,0.88976),(0.64567,0.88976),(0.65354,0.88976),(0.66142,0.88976),(0.66929,0.88976),(0.67717,0.88976),(0.68504,0.88976),(0.69291,0.88976),(0.70079,0.88976),(0.70866,0.88976),(0.71654,0.88976),(0.72441,0.88976),(0.73228,0.88976),(0.74016,0.88976),(0.74803,0.88976),(0.75591,0.88976),(0.76378,0.88976),(0.77165,0.88976),(0.77953,0.88976),(0.7874,0.88976),(0.79528,0.88976),(0.80315,0.88976),(0.81102,0.88976),(0.8189,0.88976),(0.82677,0.88976),(0.83465,0.88976),(0.84252,0.88976),(0.85039,0.88976),(0.85827,0.88976),(0.86614,0.88976),(0.87402,0.88976),(0.88189,0.88976),(0.88976,0.88976),(0.89764,0.88976),(0.90551,0.88976),(0.91339,0.88976),(0.92126,0.88976),(0.92913,0.88976),(0.93701,0.88976),(0.94488,0.88976),(0.95276,0.88976),(0.96063,0.88976),(0.9685,0.88976),(0.97638,0.88976),(0.98425,0.88976),(0.99213,0.88976),(0.99609,0.88976),(0.00391,0.89764),(0.00787,0.89764),(0.01575,0.89764),(0.02362,0.89764),(0.0315,0.89764),(0.03937,0.89764),(0.04724,0.89764),(0.05512,0.89764),(0.06299,0.89764),(0.07087,0.89764),(0.07874,0.89764),(0.08661,0.89764),(0.09449,0.89764),(0.10236,0.89764),(0.11024,0.89764),(0.11811,0.89764),(0.12598,0.89764),(0.13386,0.89764),(0.14173,0.89764),(0.14961,0.89764),(0.15748,0.89764),(0.16535,0.89764),(0.17323,0.89764),(0.1811,0.89764),(0.18898,0.89764),(0.19685,0.89764),(0.20472,0.89764),(0.2126,0.89764),(0.22047,0.89764),(0.22835,0.89764),(0.23622,0.89764),(0.24409,0.89764),(0.25197,0.89764),(0.25984,0.89764),(0.26772,0.89764),(0.27559,0.89764),(0.28346,0.89764),(0.29134,0.89764),(0.29921,0.89764),(0.30709,0.89764),(0.31496,0.89764),(0.32283,0.89764),(0.33071,0.89764),(0.33858,0.89764),(0.34646,0.89764),(0.35433,0.89764),(0.3622,0.89764),(0.37008,0.89764),(0.37795,0.89764),(0.38583,0.89764),(0.3937,0.89764),(0.40157,0.89764),(0.40945,0.89764),(0.41732,0.89764),(0.4252,0.89764),(0.43307,0.89764),(0.44094,0.89764),(0.44882,0.89764),(0.45669,0.89764),(0.46457,0.89764),(0.47244,0.89764),(0.48031,0.89764),(0.48819,0.89764),(0.49606,0.89764),(0.50394,0.89764),(0.51181,0.89764),(0.51969,0.89764),(0.52756,0.89764),(0.53543,0.89764),(0.54331,0.89764),(0.55118,0.89764),(0.55906,0.89764),(0.56693,0.89764),(0.5748,0.89764),(0.58268,0.89764),(0.59055,0.89764),(0.59843,0.89764),(0.6063,0.89764),(0.61417,0.89764),(0.62205,0.89764),(0.62992,0.89764),(0.6378,0.89764),(0.64567,0.89764),(0.65354,0.89764),(0.66142,0.89764),(0.66929,0.89764),(0.67717,0.89764),(0.68504,0.89764),(0.69291,0.89764),(0.70079,0.89764),(0.70866,0.89764),(0.71654,0.89764),(0.72441,0.89764),(0.73228,0.89764),(0.74016,0.89764),(0.74803,0.89764),(0.75591,0.89764),(0.76378,0.89764),(0.77165,0.89764),(0.77953,0.89764),(0.7874,0.89764),(0.79528,0.89764),(0.80315,0.89764),(0.81102,0.89764),(0.8189,0.89764),(0.82677,0.89764),(0.83465,0.89764),(0.84252,0.89764),(0.85039,0.89764),(0.85827,0.89764),(0.86614,0.89764),(0.87402,0.89764),(0.88189,0.89764),(0.88976,0.89764),(0.89764,0.89764),(0.90551,0.89764),(0.91339,0.89764),(0.92126,0.89764),(0.92913,0.89764),(0.93701,0.89764),(0.94488,0.89764),(0.95276,0.89764),(0.96063,0.89764),(0.9685,0.89764),(0.97638,0.89764),(0.98425,0.89764),(0.99213,0.89764),(0.99609,0.89764),(0.00391,0.90551),(0.00787,0.90551),(0.01575,0.90551),(0.02362,0.90551),(0.0315,0.90551),(0.03937,0.90551),(0.04724,0.90551),(0.05512,0.90551),(0.06299,0.90551),(0.07087,0.90551),(0.07874,0.90551),(0.08661,0.90551),(0.09449,0.90551),(0.10236,0.90551),(0.11024,0.90551),(0.11811,0.90551),(0.12598,0.90551),(0.13386,0.90551),(0.14173,0.90551),(0.14961,0.90551),(0.15748,0.90551),(0.16535,0.90551),(0.17323,0.90551),(0.1811,0.90551),(0.18898,0.90551),(0.19685,0.90551),(0.20472,0.90551),(0.2126,0.90551),(0.22047,0.90551),(0.22835,0.90551),(0.23622,0.90551),(0.24409,0.90551),(0.25197,0.90551),(0.25984,0.90551),(0.26772,0.90551),(0.27559,0.90551),(0.28346,0.90551),(0.29134,0.90551),(0.29921,0.90551),(0.30709,0.90551),(0.31496,0.90551),(0.32283,0.90551),(0.33071,0.90551),(0.33858,0.90551),(0.34646,0.90551),(0.35433,0.90551),(0.3622,0.90551),(0.37008,0.90551),(0.37795,0.90551),(0.38583,0.90551),(0.3937,0.90551),(0.40157,0.90551),(0.40945,0.90551),(0.41732,0.90551),(0.4252,0.90551),(0.43307,0.90551),(0.44094,0.90551),(0.44882,0.90551),(0.45669,0.90551),(0.46457,0.90551),(0.47244,0.90551),(0.48031,0.90551),(0.48819,0.90551),(0.49606,0.90551),(0.50394,0.90551),(0.51181,0.90551),(0.51969,0.90551),(0.52756,0.90551),(0.53543,0.90551),(0.54331,0.90551),(0.55118,0.90551),(0.55906,0.90551),(0.56693,0.90551),(0.5748,0.90551),(0.58268,0.90551),(0.59055,0.90551),(0.59843,0.90551),(0.6063,0.90551),(0.61417,0.90551),(0.62205,0.90551),(0.62992,0.90551),(0.6378,0.90551),(0.64567,0.90551),(0.65354,0.90551),(0.66142,0.90551),(0.66929,0.90551),(0.67717,0.90551),(0.68504,0.90551),(0.69291,0.90551),(0.70079,0.90551),(0.70866,0.90551),(0.71654,0.90551),(0.72441,0.90551),(0.73228,0.90551),(0.74016,0.90551),(0.74803,0.90551),(0.75591,0.90551),(0.76378,0.90551),(0.77165,0.90551),(0.77953,0.90551),(0.7874,0.90551),(0.79528,0.90551),(0.80315,0.90551),(0.81102,0.90551),(0.8189,0.90551),(0.82677,0.90551),(0.83465,0.90551),(0.84252,0.90551),(0.85039,0.90551),(0.85827,0.90551),(0.86614,0.90551),(0.87402,0.90551),(0.88189,0.90551),(0.88976,0.90551),(0.89764,0.90551),(0.90551,0.90551),(0.91339,0.90551),(0.92126,0.90551),(0.92913,0.90551),(0.93701,0.90551),(0.94488,0.90551),(0.95276,0.90551),(0.96063,0.90551),(0.9685,0.90551),(0.97638,0.90551),(0.98425,0.90551),(0.99213,0.90551),(0.99609,0.90551),(0.00391,0.91339),(0.00787,0.91339),(0.01575,0.91339),(0.02362,0.91339),(0.0315,0.91339),(0.03937,0.91339),(0.04724,0.91339),(0.05512,0.91339),(0.06299,0.91339),(0.07087,0.91339),(0.07874,0.91339),(0.08661,0.91339),(0.09449,0.91339),(0.10236,0.91339),(0.11024,0.91339),(0.11811,0.91339),(0.12598,0.91339),(0.13386,0.91339),(0.14173,0.91339),(0.14961,0.91339),(0.15748,0.91339),(0.16535,0.91339),(0.17323,0.91339),(0.1811,0.91339),(0.18898,0.91339),(0.19685,0.91339),(0.20472,0.91339),(0.2126,0.91339),(0.22047,0.91339),(0.22835,0.91339),(0.23622,0.91339),(0.24409,0.91339),(0.25197,0.91339),(0.25984,0.91339),(0.26772,0.91339),(0.27559,0.91339),(0.28346,0.91339),(0.29134,0.91339),(0.29921,0.91339),(0.30709,0.91339),(0.31496,0.91339),(0.32283,0.91339),(0.33071,0.91339),(0.33858,0.91339),(0.34646,0.91339),(0.35433,0.91339),(0.3622,0.91339),(0.37008,0.91339),(0.37795,0.91339),(0.38583,0.91339),(0.3937,0.91339),(0.40157,0.91339),(0.40945,0.91339),(0.41732,0.91339),(0.4252,0.91339),(0.43307,0.91339),(0.44094,0.91339),(0.44882,0.91339),(0.45669,0.91339),(0.46457,0.91339),(0.47244,0.91339),(0.48031,0.91339),(0.48819,0.91339),(0.49606,0.91339),(0.50394,0.91339),(0.51181,0.91339),(0.51969,0.91339),(0.52756,0.91339),(0.53543,0.91339),(0.54331,0.91339),(0.55118,0.91339),(0.55906,0.91339),(0.56693,0.91339),(0.5748,0.91339),(0.58268,0.91339),(0.59055,0.91339),(0.59843,0.91339),(0.6063,0.91339),(0.61417,0.91339),(0.62205,0.91339),(0.62992,0.91339),(0.6378,0.91339),(0.64567,0.91339),(0.65354,0.91339),(0.66142,0.91339),(0.66929,0.91339),(0.67717,0.91339),(0.68504,0.91339),(0.69291,0.91339),(0.70079,0.91339),(0.70866,0.91339),(0.71654,0.91339),(0.72441,0.91339),(0.73228,0.91339),(0.74016,0.91339),(0.74803,0.91339),(0.75591,0.91339),(0.76378,0.91339),(0.77165,0.91339),(0.77953,0.91339),(0.7874,0.91339),(0.79528,0.91339),(0.80315,0.91339),(0.81102,0.91339),(0.8189,0.91339),(0.82677,0.91339),(0.83465,0.91339),(0.84252,0.91339),(0.85039,0.91339),(0.85827,0.91339),(0.86614,0.91339),(0.87402,0.91339),(0.88189,0.91339),(0.88976,0.91339),(0.89764,0.91339),(0.90551,0.91339),(0.91339,0.91339),(0.92126,0.91339),(0.92913,0.91339),(0.93701,0.91339),(0.94488,0.91339),(0.95276,0.91339),(0.96063,0.91339),(0.9685,0.91339),(0.97638,0.91339),(0.98425,0.91339),(0.99213,0.91339),(0.99609,0.91339),(0.00391,0.92126),(0.00787,0.92126),(0.01575,0.92126),(0.02362,0.92126),(0.0315,0.92126),(0.03937,0.92126),(0.04724,0.92126),(0.05512,0.92126),(0.06299,0.92126),(0.07087,0.92126),(0.07874,0.92126),(0.08661,0.92126),(0.09449,0.92126),(0.10236,0.92126),(0.11024,0.92126),(0.11811,0.92126),(0.12598,0.92126),(0.13386,0.92126),(0.14173,0.92126),(0.14961,0.92126),(0.15748,0.92126),(0.16535,0.92126),(0.17323,0.92126),(0.1811,0.92126),(0.18898,0.92126),(0.19685,0.92126),(0.20472,0.92126),(0.2126,0.92126),(0.22047,0.92126),(0.22835,0.92126),(0.23622,0.92126),(0.24409,0.92126),(0.25197,0.92126),(0.25984,0.92126),(0.26772,0.92126),(0.27559,0.92126),(0.28346,0.92126),(0.29134,0.92126),(0.29921,0.92126),(0.30709,0.92126),(0.31496,0.92126),(0.32283,0.92126),(0.33071,0.92126),(0.33858,0.92126),(0.34646,0.92126),(0.35433,0.92126),(0.3622,0.92126),(0.37008,0.92126),(0.37795,0.92126),(0.38583,0.92126),(0.3937,0.92126),(0.40157,0.92126),(0.40945,0.92126),(0.41732,0.92126),(0.4252,0.92126),(0.43307,0.92126),(0.44094,0.92126),(0.44882,0.92126),(0.45669,0.92126),(0.46457,0.92126),(0.47244,0.92126),(0.48031,0.92126),(0.48819,0.92126),(0.49606,0.92126),(0.50394,0.92126),(0.51181,0.92126),(0.51969,0.92126),(0.52756,0.92126),(0.53543,0.92126),(0.54331,0.92126),(0.55118,0.92126),(0.55906,0.92126),(0.56693,0.92126),(0.5748,0.92126),(0.58268,0.92126),(0.59055,0.92126),(0.59843,0.92126),(0.6063,0.92126),(0.61417,0.92126),(0.62205,0.92126),(0.62992,0.92126),(0.6378,0.92126),(0.64567,0.92126),(0.65354,0.92126),(0.66142,0.92126),(0.66929,0.92126),(0.67717,0.92126),(0.68504,0.92126),(0.69291,0.92126),(0.70079,0.92126),(0.70866,0.92126),(0.71654,0.92126),(0.72441,0.92126),(0.73228,0.92126),(0.74016,0.92126),(0.74803,0.92126),(0.75591,0.92126),(0.76378,0.92126),(0.77165,0.92126),(0.77953,0.92126),(0.7874,0.92126),(0.79528,0.92126),(0.80315,0.92126),(0.81102,0.92126),(0.8189,0.92126),(0.82677,0.92126),(0.83465,0.92126),(0.84252,0.92126),(0.85039,0.92126),(0.85827,0.92126),(0.86614,0.92126),(0.87402,0.92126),(0.88189,0.92126),(0.88976,0.92126),(0.89764,0.92126),(0.90551,0.92126),(0.91339,0.92126),(0.92126,0.92126),(0.92913,0.92126),(0.93701,0.92126),(0.94488,0.92126),(0.95276,0.92126),(0.96063,0.92126),(0.9685,0.92126),(0.97638,0.92126),(0.98425,0.92126),(0.99213,0.92126),(0.99609,0.92126),(0.00391,0.92913),(0.00787,0.92913),(0.01575,0.92913),(0.02362,0.92913),(0.0315,0.92913),(0.03937,0.92913),(0.04724,0.92913),(0.05512,0.92913),(0.06299,0.92913),(0.07087,0.92913),(0.07874,0.92913),(0.08661,0.92913),(0.09449,0.92913),(0.10236,0.92913),(0.11024,0.92913),(0.11811,0.92913),(0.12598,0.92913),(0.13386,0.92913),(0.14173,0.92913),(0.14961,0.92913),(0.15748,0.92913),(0.16535,0.92913),(0.17323,0.92913),(0.1811,0.92913),(0.18898,0.92913),(0.19685,0.92913),(0.20472,0.92913),(0.2126,0.92913),(0.22047,0.92913),(0.22835,0.92913),(0.23622,0.92913),(0.24409,0.92913),(0.25197,0.92913),(0.25984,0.92913),(0.26772,0.92913),(0.27559,0.92913),(0.28346,0.92913),(0.29134,0.92913),(0.29921,0.92913),(0.30709,0.92913),(0.31496,0.92913),(0.32283,0.92913),(0.33071,0.92913),(0.33858,0.92913),(0.34646,0.92913),(0.35433,0.92913),(0.3622,0.92913),(0.37008,0.92913),(0.37795,0.92913),(0.38583,0.92913),(0.3937,0.92913),(0.40157,0.92913),(0.40945,0.92913),(0.41732,0.92913),(0.4252,0.92913),(0.43307,0.92913),(0.44094,0.92913),(0.44882,0.92913),(0.45669,0.92913),(0.46457,0.92913),(0.47244,0.92913),(0.48031,0.92913),(0.48819,0.92913),(0.49606,0.92913),(0.50394,0.92913),(0.51181,0.92913),(0.51969,0.92913),(0.52756,0.92913),(0.53543,0.92913),(0.54331,0.92913),(0.55118,0.92913),(0.55906,0.92913),(0.56693,0.92913),(0.5748,0.92913),(0.58268,0.92913),(0.59055,0.92913),(0.59843,0.92913),(0.6063,0.92913),(0.61417,0.92913),(0.62205,0.92913),(0.62992,0.92913),(0.6378,0.92913),(0.64567,0.92913),(0.65354,0.92913),(0.66142,0.92913),(0.66929,0.92913),(0.67717,0.92913),(0.68504,0.92913),(0.69291,0.92913),(0.70079,0.92913),(0.70866,0.92913),(0.71654,0.92913),(0.72441,0.92913),(0.73228,0.92913),(0.74016,0.92913),(0.74803,0.92913),(0.75591,0.92913),(0.76378,0.92913),(0.77165,0.92913),(0.77953,0.92913),(0.7874,0.92913),(0.79528,0.92913),(0.80315,0.92913),(0.81102,0.92913),(0.8189,0.92913),(0.82677,0.92913),(0.83465,0.92913),(0.84252,0.92913),(0.85039,0.92913),(0.85827,0.92913),(0.86614,0.92913),(0.87402,0.92913),(0.88189,0.92913),(0.88976,0.92913),(0.89764,0.92913),(0.90551,0.92913),(0.91339,0.92913),(0.92126,0.92913),(0.92913,0.92913),(0.93701,0.92913),(0.94488,0.92913),(0.95276,0.92913),(0.96063,0.92913),(0.9685,0.92913),(0.97638,0.92913),(0.98425,0.92913),(0.99213,0.92913),(0.99609,0.92913),(0.00391,0.93701),(0.00787,0.93701),(0.01575,0.93701),(0.02362,0.93701),(0.0315,0.93701),(0.03937,0.93701),(0.04724,0.93701),(0.05512,0.93701),(0.06299,0.93701),(0.07087,0.93701),(0.07874,0.93701),(0.08661,0.93701),(0.09449,0.93701),(0.10236,0.93701),(0.11024,0.93701),(0.11811,0.93701),(0.12598,0.93701),(0.13386,0.93701),(0.14173,0.93701),(0.14961,0.93701),(0.15748,0.93701),(0.16535,0.93701),(0.17323,0.93701),(0.1811,0.93701),(0.18898,0.93701),(0.19685,0.93701),(0.20472,0.93701),(0.2126,0.93701),(0.22047,0.93701),(0.22835,0.93701),(0.23622,0.93701),(0.24409,0.93701),(0.25197,0.93701),(0.25984,0.93701),(0.26772,0.93701),(0.27559,0.93701),(0.28346,0.93701),(0.29134,0.93701),(0.29921,0.93701),(0.30709,0.93701),(0.31496,0.93701),(0.32283,0.93701),(0.33071,0.93701),(0.33858,0.93701),(0.34646,0.93701),(0.35433,0.93701),(0.3622,0.93701),(0.37008,0.93701),(0.37795,0.93701),(0.38583,0.93701),(0.3937,0.93701),(0.40157,0.93701),(0.40945,0.93701),(0.41732,0.93701),(0.4252,0.93701),(0.43307,0.93701),(0.44094,0.93701),(0.44882,0.93701),(0.45669,0.93701),(0.46457,0.93701),(0.47244,0.93701),(0.48031,0.93701),(0.48819,0.93701),(0.49606,0.93701),(0.50394,0.93701),(0.51181,0.93701),(0.51969,0.93701),(0.52756,0.93701),(0.53543,0.93701),(0.54331,0.93701),(0.55118,0.93701),(0.55906,0.93701),(0.56693,0.93701),(0.5748,0.93701),(0.58268,0.93701),(0.59055,0.93701),(0.59843,0.93701),(0.6063,0.93701),(0.61417,0.93701),(0.62205,0.93701),(0.62992,0.93701),(0.6378,0.93701),(0.64567,0.93701),(0.65354,0.93701),(0.66142,0.93701),(0.66929,0.93701),(0.67717,0.93701),(0.68504,0.93701),(0.69291,0.93701),(0.70079,0.93701),(0.70866,0.93701),(0.71654,0.93701),(0.72441,0.93701),(0.73228,0.93701),(0.74016,0.93701),(0.74803,0.93701),(0.75591,0.93701),(0.76378,0.93701),(0.77165,0.93701),(0.77953,0.93701),(0.7874,0.93701),(0.79528,0.93701),(0.80315,0.93701),(0.81102,0.93701),(0.8189,0.93701),(0.82677,0.93701),(0.83465,0.93701),(0.84252,0.93701),(0.85039,0.93701),(0.85827,0.93701),(0.86614,0.93701),(0.87402,0.93701),(0.88189,0.93701),(0.88976,0.93701),(0.89764,0.93701),(0.90551,0.93701),(0.91339,0.93701),(0.92126,0.93701),(0.92913,0.93701),(0.93701,0.93701),(0.94488,0.93701),(0.95276,0.93701),(0.96063,0.93701),(0.9685,0.93701),(0.97638,0.93701),(0.98425,0.93701),(0.99213,0.93701),(0.99609,0.93701),(0.00391,0.94488),(0.00787,0.94488),(0.01575,0.94488),(0.02362,0.94488),(0.0315,0.94488),(0.03937,0.94488),(0.04724,0.94488),(0.05512,0.94488),(0.06299,0.94488),(0.07087,0.94488),(0.07874,0.94488),(0.08661,0.94488),(0.09449,0.94488),(0.10236,0.94488),(0.11024,0.94488),(0.11811,0.94488),(0.12598,0.94488),(0.13386,0.94488),(0.14173,0.94488),(0.14961,0.94488),(0.15748,0.94488),(0.16535,0.94488),(0.17323,0.94488),(0.1811,0.94488),(0.18898,0.94488),(0.19685,0.94488),(0.20472,0.94488),(0.2126,0.94488),(0.22047,0.94488),(0.22835,0.94488),(0.23622,0.94488),(0.24409,0.94488),(0.25197,0.94488),(0.25984,0.94488),(0.26772,0.94488),(0.27559,0.94488),(0.28346,0.94488),(0.29134,0.94488),(0.29921,0.94488),(0.30709,0.94488),(0.31496,0.94488),(0.32283,0.94488),(0.33071,0.94488),(0.33858,0.94488),(0.34646,0.94488),(0.35433,0.94488),(0.3622,0.94488),(0.37008,0.94488),(0.37795,0.94488),(0.38583,0.94488),(0.3937,0.94488),(0.40157,0.94488),(0.40945,0.94488),(0.41732,0.94488),(0.4252,0.94488),(0.43307,0.94488),(0.44094,0.94488),(0.44882,0.94488),(0.45669,0.94488),(0.46457,0.94488),(0.47244,0.94488),(0.48031,0.94488),(0.48819,0.94488),(0.49606,0.94488),(0.50394,0.94488),(0.51181,0.94488),(0.51969,0.94488),(0.52756,0.94488),(0.53543,0.94488),(0.54331,0.94488),(0.55118,0.94488),(0.55906,0.94488),(0.56693,0.94488),(0.5748,0.94488),(0.58268,0.94488),(0.59055,0.94488),(0.59843,0.94488),(0.6063,0.94488),(0.61417,0.94488),(0.62205,0.94488),(0.62992,0.94488),(0.6378,0.94488),(0.64567,0.94488),(0.65354,0.94488),(0.66142,0.94488),(0.66929,0.94488),(0.67717,0.94488),(0.68504,0.94488),(0.69291,0.94488),(0.70079,0.94488),(0.70866,0.94488),(0.71654,0.94488),(0.72441,0.94488),(0.73228,0.94488),(0.74016,0.94488),(0.74803,0.94488),(0.75591,0.94488),(0.76378,0.94488),(0.77165,0.94488),(0.77953,0.94488),(0.7874,0.94488),(0.79528,0.94488),(0.80315,0.94488),(0.81102,0.94488),(0.8189,0.94488),(0.82677,0.94488),(0.83465,0.94488),(0.84252,0.94488),(0.85039,0.94488),(0.85827,0.94488),(0.86614,0.94488),(0.87402,0.94488),(0.88189,0.94488),(0.88976,0.94488),(0.89764,0.94488),(0.90551,0.94488),(0.91339,0.94488),(0.92126,0.94488),(0.92913,0.94488),(0.93701,0.94488),(0.94488,0.94488),(0.95276,0.94488),(0.96063,0.94488),(0.9685,0.94488),(0.97638,0.94488),(0.98425,0.94488),(0.99213,0.94488),(0.99609,0.94488),(0.00391,0.95276),(0.00787,0.95276),(0.01575,0.95276),(0.02362,0.95276),(0.0315,0.95276),(0.03937,0.95276),(0.04724,0.95276),(0.05512,0.95276),(0.06299,0.95276),(0.07087,0.95276),(0.07874,0.95276),(0.08661,0.95276),(0.09449,0.95276),(0.10236,0.95276),(0.11024,0.95276),(0.11811,0.95276),(0.12598,0.95276),(0.13386,0.95276),(0.14173,0.95276),(0.14961,0.95276),(0.15748,0.95276),(0.16535,0.95276),(0.17323,0.95276),(0.1811,0.95276),(0.18898,0.95276),(0.19685,0.95276),(0.20472,0.95276),(0.2126,0.95276),(0.22047,0.95276),(0.22835,0.95276),(0.23622,0.95276),(0.24409,0.95276),(0.25197,0.95276),(0.25984,0.95276),(0.26772,0.95276),(0.27559,0.95276),(0.28346,0.95276),(0.29134,0.95276),(0.29921,0.95276),(0.30709,0.95276),(0.31496,0.95276),(0.32283,0.95276),(0.33071,0.95276),(0.33858,0.95276),(0.34646,0.95276),(0.35433,0.95276),(0.3622,0.95276),(0.37008,0.95276),(0.37795,0.95276),(0.38583,0.95276),(0.3937,0.95276),(0.40157,0.95276),(0.40945,0.95276),(0.41732,0.95276),(0.4252,0.95276),(0.43307,0.95276),(0.44094,0.95276),(0.44882,0.95276),(0.45669,0.95276),(0.46457,0.95276),(0.47244,0.95276),(0.48031,0.95276),(0.48819,0.95276),(0.49606,0.95276),(0.50394,0.95276),(0.51181,0.95276),(0.51969,0.95276),(0.52756,0.95276),(0.53543,0.95276),(0.54331,0.95276),(0.55118,0.95276),(0.55906,0.95276),(0.56693,0.95276),(0.5748,0.95276),(0.58268,0.95276),(0.59055,0.95276),(0.59843,0.95276),(0.6063,0.95276),(0.61417,0.95276),(0.62205,0.95276),(0.62992,0.95276),(0.6378,0.95276),(0.64567,0.95276),(0.65354,0.95276),(0.66142,0.95276),(0.66929,0.95276),(0.67717,0.95276),(0.68504,0.95276),(0.69291,0.95276),(0.70079,0.95276),(0.70866,0.95276),(0.71654,0.95276),(0.72441,0.95276),(0.73228,0.95276),(0.74016,0.95276),(0.74803,0.95276),(0.75591,0.95276),(0.76378,0.95276),(0.77165,0.95276),(0.77953,0.95276),(0.7874,0.95276),(0.79528,0.95276),(0.80315,0.95276),(0.81102,0.95276),(0.8189,0.95276),(0.82677,0.95276),(0.83465,0.95276),(0.84252,0.95276),(0.85039,0.95276),(0.85827,0.95276),(0.86614,0.95276),(0.87402,0.95276),(0.88189,0.95276),(0.88976,0.95276),(0.89764,0.95276),(0.90551,0.95276),(0.91339,0.95276),(0.92126,0.95276),(0.92913,0.95276),(0.93701,0.95276),(0.94488,0.95276),(0.95276,0.95276),(0.96063,0.95276),(0.9685,0.95276),(0.97638,0.95276),(0.98425,0.95276),(0.99213,0.95276),(0.99609,0.95276),(0.00391,0.96063),(0.00787,0.96063),(0.01575,0.96063),(0.02362,0.96063),(0.0315,0.96063),(0.03937,0.96063),(0.04724,0.96063),(0.05512,0.96063),(0.06299,0.96063),(0.07087,0.96063),(0.07874,0.96063),(0.08661,0.96063),(0.09449,0.96063),(0.10236,0.96063),(0.11024,0.96063),(0.11811,0.96063),(0.12598,0.96063),(0.13386,0.96063),(0.14173,0.96063),(0.14961,0.96063),(0.15748,0.96063),(0.16535,0.96063),(0.17323,0.96063),(0.1811,0.96063),(0.18898,0.96063),(0.19685,0.96063),(0.20472,0.96063),(0.2126,0.96063),(0.22047,0.96063),(0.22835,0.96063),(0.23622,0.96063),(0.24409,0.96063),(0.25197,0.96063),(0.25984,0.96063),(0.26772,0.96063),(0.27559,0.96063),(0.28346,0.96063),(0.29134,0.96063),(0.29921,0.96063),(0.30709,0.96063),(0.31496,0.96063),(0.32283,0.96063),(0.33071,0.96063),(0.33858,0.96063),(0.34646,0.96063),(0.35433,0.96063),(0.3622,0.96063),(0.37008,0.96063),(0.37795,0.96063),(0.38583,0.96063),(0.3937,0.96063),(0.40157,0.96063),(0.40945,0.96063),(0.41732,0.96063),(0.4252,0.96063),(0.43307,0.96063),(0.44094,0.96063),(0.44882,0.96063),(0.45669,0.96063),(0.46457,0.96063),(0.47244,0.96063),(0.48031,0.96063),(0.48819,0.96063),(0.49606,0.96063),(0.50394,0.96063),(0.51181,0.96063),(0.51969,0.96063),(0.52756,0.96063),(0.53543,0.96063),(0.54331,0.96063),(0.55118,0.96063),(0.55906,0.96063),(0.56693,0.96063),(0.5748,0.96063),(0.58268,0.96063),(0.59055,0.96063),(0.59843,0.96063),(0.6063,0.96063),(0.61417,0.96063),(0.62205,0.96063),(0.62992,0.96063),(0.6378,0.96063),(0.64567,0.96063),(0.65354,0.96063),(0.66142,0.96063),(0.66929,0.96063),(0.67717,0.96063),(0.68504,0.96063),(0.69291,0.96063),(0.70079,0.96063),(0.70866,0.96063),(0.71654,0.96063),(0.72441,0.96063),(0.73228,0.96063),(0.74016,0.96063),(0.74803,0.96063),(0.75591,0.96063),(0.76378,0.96063),(0.77165,0.96063),(0.77953,0.96063),(0.7874,0.96063),(0.79528,0.96063),(0.80315,0.96063),(0.81102,0.96063),(0.8189,0.96063),(0.82677,0.96063),(0.83465,0.96063),(0.84252,0.96063),(0.85039,0.96063),(0.85827,0.96063),(0.86614,0.96063),(0.87402,0.96063),(0.88189,0.96063),(0.88976,0.96063),(0.89764,0.96063),(0.90551,0.96063),(0.91339,0.96063),(0.92126,0.96063),(0.92913,0.96063),(0.93701,0.96063),(0.94488,0.96063),(0.95276,0.96063),(0.96063,0.96063),(0.9685,0.96063),(0.97638,0.96063),(0.98425,0.96063),(0.99213,0.96063),(0.99609,0.96063),(0.00391,0.9685),(0.00787,0.9685),(0.01575,0.9685),(0.02362,0.9685),(0.0315,0.9685),(0.03937,0.9685),(0.04724,0.9685),(0.05512,0.9685),(0.06299,0.9685),(0.07087,0.9685),(0.07874,0.9685),(0.08661,0.9685),(0.09449,0.9685),(0.10236,0.9685),(0.11024,0.9685),(0.11811,0.9685),(0.12598,0.9685),(0.13386,0.9685),(0.14173,0.9685),(0.14961,0.9685),(0.15748,0.9685),(0.16535,0.9685),(0.17323,0.9685),(0.1811,0.9685),(0.18898,0.9685),(0.19685,0.9685),(0.20472,0.9685),(0.2126,0.9685),(0.22047,0.9685),(0.22835,0.9685),(0.23622,0.9685),(0.24409,0.9685),(0.25197,0.9685),(0.25984,0.9685),(0.26772,0.9685),(0.27559,0.9685),(0.28346,0.9685),(0.29134,0.9685),(0.29921,0.9685),(0.30709,0.9685),(0.31496,0.9685),(0.32283,0.9685),(0.33071,0.9685),(0.33858,0.9685),(0.34646,0.9685),(0.35433,0.9685),(0.3622,0.9685),(0.37008,0.9685),(0.37795,0.9685),(0.38583,0.9685),(0.3937,0.9685),(0.40157,0.9685),(0.40945,0.9685),(0.41732,0.9685),(0.4252,0.9685),(0.43307,0.9685),(0.44094,0.9685),(0.44882,0.9685),(0.45669,0.9685),(0.46457,0.9685),(0.47244,0.9685),(0.48031,0.9685),(0.48819,0.9685),(0.49606,0.9685),(0.50394,0.9685),(0.51181,0.9685),(0.51969,0.9685),(0.52756,0.9685),(0.53543,0.9685),(0.54331,0.9685),(0.55118,0.9685),(0.55906,0.9685),(0.56693,0.9685),(0.5748,0.9685),(0.58268,0.9685),(0.59055,0.9685),(0.59843,0.9685),(0.6063,0.9685),(0.61417,0.9685),(0.62205,0.9685),(0.62992,0.9685),(0.6378,0.9685),(0.64567,0.9685),(0.65354,0.9685),(0.66142,0.9685),(0.66929,0.9685),(0.67717,0.9685),(0.68504,0.9685),(0.69291,0.9685),(0.70079,0.9685),(0.70866,0.9685),(0.71654,0.9685),(0.72441,0.9685),(0.73228,0.9685),(0.74016,0.9685),(0.74803,0.9685),(0.75591,0.9685),(0.76378,0.9685),(0.77165,0.9685),(0.77953,0.9685),(0.7874,0.9685),(0.79528,0.9685),(0.80315,0.9685),(0.81102,0.9685),(0.8189,0.9685),(0.82677,0.9685),(0.83465,0.9685),(0.84252,0.9685),(0.85039,0.9685),(0.85827,0.9685),(0.86614,0.9685),(0.87402,0.9685),(0.88189,0.9685),(0.88976,0.9685),(0.89764,0.9685),(0.90551,0.9685),(0.91339,0.9685),(0.92126,0.9685),(0.92913,0.9685),(0.93701,0.9685),(0.94488,0.9685),(0.95276,0.9685),(0.96063,0.9685),(0.9685,0.9685),(0.97638,0.9685),(0.98425,0.9685),(0.99213,0.9685),(0.99609,0.9685),(0.00391,0.97638),(0.00787,0.97638),(0.01575,0.97638),(0.02362,0.97638),(0.0315,0.97638),(0.03937,0.97638),(0.04724,0.97638),(0.05512,0.97638),(0.06299,0.97638),(0.07087,0.97638),(0.07874,0.97638),(0.08661,0.97638),(0.09449,0.97638),(0.10236,0.97638),(0.11024,0.97638),(0.11811,0.97638),(0.12598,0.97638),(0.13386,0.97638),(0.14173,0.97638),(0.14961,0.97638),(0.15748,0.97638),(0.16535,0.97638),(0.17323,0.97638),(0.1811,0.97638),(0.18898,0.97638),(0.19685,0.97638),(0.20472,0.97638),(0.2126,0.97638),(0.22047,0.97638),(0.22835,0.97638),(0.23622,0.97638),(0.24409,0.97638),(0.25197,0.97638),(0.25984,0.97638),(0.26772,0.97638),(0.27559,0.97638),(0.28346,0.97638),(0.29134,0.97638),(0.29921,0.97638),(0.30709,0.97638),(0.31496,0.97638),(0.32283,0.97638),(0.33071,0.97638),(0.33858,0.97638),(0.34646,0.97638),(0.35433,0.97638),(0.3622,0.97638),(0.37008,0.97638),(0.37795,0.97638),(0.38583,0.97638),(0.3937,0.97638),(0.40157,0.97638),(0.40945,0.97638),(0.41732,0.97638),(0.4252,0.97638),(0.43307,0.97638),(0.44094,0.97638),(0.44882,0.97638),(0.45669,0.97638),(0.46457,0.97638),(0.47244,0.97638),(0.48031,0.97638),(0.48819,0.97638),(0.49606,0.97638),(0.50394,0.97638),(0.51181,0.97638),(0.51969,0.97638),(0.52756,0.97638),(0.53543,0.97638),(0.54331,0.97638),(0.55118,0.97638),(0.55906,0.97638),(0.56693,0.97638),(0.5748,0.97638),(0.58268,0.97638),(0.59055,0.97638),(0.59843,0.97638),(0.6063,0.97638),(0.61417,0.97638),(0.62205,0.97638),(0.62992,0.97638),(0.6378,0.97638),(0.64567,0.97638),(0.65354,0.97638),(0.66142,0.97638),(0.66929,0.97638),(0.67717,0.97638),(0.68504,0.97638),(0.69291,0.97638),(0.70079,0.97638),(0.70866,0.97638),(0.71654,0.97638),(0.72441,0.97638),(0.73228,0.97638),(0.74016,0.97638),(0.74803,0.97638),(0.75591,0.97638),(0.76378,0.97638),(0.77165,0.97638),(0.77953,0.97638),(0.7874,0.97638),(0.79528,0.97638),(0.80315,0.97638),(0.81102,0.97638),(0.8189,0.97638),(0.82677,0.97638),(0.83465,0.97638),(0.84252,0.97638),(0.85039,0.97638),(0.85827,0.97638),(0.86614,0.97638),(0.87402,0.97638),(0.88189,0.97638),(0.88976,0.97638),(0.89764,0.97638),(0.90551,0.97638),(0.91339,0.97638),(0.92126,0.97638),(0.92913,0.97638),(0.93701,0.97638),(0.94488,0.97638),(0.95276,0.97638),(0.96063,0.97638),(0.9685,0.97638),(0.97638,0.97638),(0.98425,0.97638),(0.99213,0.97638),(0.99609,0.97638),(0.00391,0.98425),(0.00787,0.98425),(0.01575,0.98425),(0.02362,0.98425),(0.0315,0.98425),(0.03937,0.98425),(0.04724,0.98425),(0.05512,0.98425),(0.06299,0.98425),(0.07087,0.98425),(0.07874,0.98425),(0.08661,0.98425),(0.09449,0.98425),(0.10236,0.98425),(0.11024,0.98425),(0.11811,0.98425),(0.12598,0.98425),(0.13386,0.98425),(0.14173,0.98425),(0.14961,0.98425),(0.15748,0.98425),(0.16535,0.98425),(0.17323,0.98425),(0.1811,0.98425),(0.18898,0.98425),(0.19685,0.98425),(0.20472,0.98425),(0.2126,0.98425),(0.22047,0.98425),(0.22835,0.98425),(0.23622,0.98425),(0.24409,0.98425),(0.25197,0.98425),(0.25984,0.98425),(0.26772,0.98425),(0.27559,0.98425),(0.28346,0.98425),(0.29134,0.98425),(0.29921,0.98425),(0.30709,0.98425),(0.31496,0.98425),(0.32283,0.98425),(0.33071,0.98425),(0.33858,0.98425),(0.34646,0.98425),(0.35433,0.98425),(0.3622,0.98425),(0.37008,0.98425),(0.37795,0.98425),(0.38583,0.98425),(0.3937,0.98425),(0.40157,0.98425),(0.40945,0.98425),(0.41732,0.98425),(0.4252,0.98425),(0.43307,0.98425),(0.44094,0.98425),(0.44882,0.98425),(0.45669,0.98425),(0.46457,0.98425),(0.47244,0.98425),(0.48031,0.98425),(0.48819,0.98425),(0.49606,0.98425),(0.50394,0.98425),(0.51181,0.98425),(0.51969,0.98425),(0.52756,0.98425),(0.53543,0.98425),(0.54331,0.98425),(0.55118,0.98425),(0.55906,0.98425),(0.56693,0.98425),(0.5748,0.98425),(0.58268,0.98425),(0.59055,0.98425),(0.59843,0.98425),(0.6063,0.98425),(0.61417,0.98425),(0.62205,0.98425),(0.62992,0.98425),(0.6378,0.98425),(0.64567,0.98425),(0.65354,0.98425),(0.66142,0.98425),(0.66929,0.98425),(0.67717,0.98425),(0.68504,0.98425),(0.69291,0.98425),(0.70079,0.98425),(0.70866,0.98425),(0.71654,0.98425),(0.72441,0.98425),(0.73228,0.98425),(0.74016,0.98425),(0.74803,0.98425),(0.75591,0.98425),(0.76378,0.98425),(0.77165,0.98425),(0.77953,0.98425),(0.7874,0.98425),(0.79528,0.98425),(0.80315,0.98425),(0.81102,0.98425),(0.8189,0.98425),(0.82677,0.98425),(0.83465,0.98425),(0.84252,0.98425),(0.85039,0.98425),(0.85827,0.98425),(0.86614,0.98425),(0.87402,0.98425),(0.88189,0.98425),(0.88976,0.98425),(0.89764,0.98425),(0.90551,0.98425),(0.91339,0.98425),(0.92126,0.98425),(0.92913,0.98425),(0.93701,0.98425),(0.94488,0.98425),(0.95276,0.98425),(0.96063,0.98425),(0.9685,0.98425),(0.97638,0.98425),(0.98425,0.98425),(0.99213,0.98425),(0.99609,0.98425),(0.00391,0.99213),(0.00787,0.99213),(0.01575,0.99213),(0.02362,0.99213),(0.0315,0.99213),(0.03937,0.99213),(0.04724,0.99213),(0.05512,0.99213),(0.06299,0.99213),(0.07087,0.99213),(0.07874,0.99213),(0.08661,0.99213),(0.09449,0.99213),(0.10236,0.99213),(0.11024,0.99213),(0.11811,0.99213),(0.12598,0.99213),(0.13386,0.99213),(0.14173,0.99213),(0.14961,0.99213),(0.15748,0.99213),(0.16535,0.99213),(0.17323,0.99213),(0.1811,0.99213),(0.18898,0.99213),(0.19685,0.99213),(0.20472,0.99213),(0.2126,0.99213),(0.22047,0.99213),(0.22835,0.99213),(0.23622,0.99213),(0.24409,0.99213),(0.25197,0.99213),(0.25984,0.99213),(0.26772,0.99213),(0.27559,0.99213),(0.28346,0.99213),(0.29134,0.99213),(0.29921,0.99213),(0.30709,0.99213),(0.31496,0.99213),(0.32283,0.99213),(0.33071,0.99213),(0.33858,0.99213),(0.34646,0.99213),(0.35433,0.99213),(0.3622,0.99213),(0.37008,0.99213),(0.37795,0.99213),(0.38583,0.99213),(0.3937,0.99213),(0.40157,0.99213),(0.40945,0.99213),(0.41732,0.99213),(0.4252,0.99213),(0.43307,0.99213),(0.44094,0.99213),(0.44882,0.99213),(0.45669,0.99213),(0.46457,0.99213),(0.47244,0.99213),(0.48031,0.99213),(0.48819,0.99213),(0.49606,0.99213),(0.50394,0.99213),(0.51181,0.99213),(0.51969,0.99213),(0.52756,0.99213),(0.53543,0.99213),(0.54331,0.99213),(0.55118,0.99213),(0.55906,0.99213),(0.56693,0.99213),(0.5748,0.99213),(0.58268,0.99213),(0.59055,0.99213),(0.59843,0.99213),(0.6063,0.99213),(0.61417,0.99213),(0.62205,0.99213),(0.62992,0.99213),(0.6378,0.99213),(0.64567,0.99213),(0.65354,0.99213),(0.66142,0.99213),(0.66929,0.99213),(0.67717,0.99213),(0.68504,0.99213),(0.69291,0.99213),(0.70079,0.99213),(0.70866,0.99213),(0.71654,0.99213),(0.72441,0.99213),(0.73228,0.99213),(0.74016,0.99213),(0.74803,0.99213),(0.75591,0.99213),(0.76378,0.99213),(0.77165,0.99213),(0.77953,0.99213),(0.7874,0.99213),(0.79528,0.99213),(0.80315,0.99213),(0.81102,0.99213),(0.8189,0.99213),(0.82677,0.99213),(0.83465,0.99213),(0.84252,0.99213),(0.85039,0.99213),(0.85827,0.99213),(0.86614,0.99213),(0.87402,0.99213),(0.88189,0.99213),(0.88976,0.99213),(0.89764,0.99213),(0.90551,0.99213),(0.91339,0.99213),(0.92126,0.99213),(0.92913,0.99213),(0.93701,0.99213),(0.94488,0.99213),(0.95276,0.99213),(0.96063,0.99213),(0.9685,0.99213),(0.97638,0.99213),(0.98425,0.99213),(0.99213,0.99213),(0.99609,0.99213),(0.00391,0.99609),(0.00787,0.99609),(0.01575,0.99609),(0.02362,0.99609),(0.0315,0.99609),(0.03937,0.99609),(0.04724,0.99609),(0.05512,0.99609),(0.06299,0.99609),(0.07087,0.99609),(0.07874,0.99609),(0.08661,0.99609),(0.09449,0.99609),(0.10236,0.99609),(0.11024,0.99609),(0.11811,0.99609),(0.12598,0.99609),(0.13386,0.99609),(0.14173,0.99609),(0.14961,0.99609),(0.15748,0.99609),(0.16535,0.99609),(0.17323,0.99609),(0.1811,0.99609),(0.18898,0.99609),(0.19685,0.99609),(0.20472,0.99609),(0.2126,0.99609),(0.22047,0.99609),(0.22835,0.99609),(0.23622,0.99609),(0.24409,0.99609),(0.25197,0.99609),(0.25984,0.99609),(0.26772,0.99609),(0.27559,0.99609),(0.28346,0.99609),(0.29134,0.99609),(0.29921,0.99609),(0.30709,0.99609),(0.31496,0.99609),(0.32283,0.99609),(0.33071,0.99609),(0.33858,0.99609),(0.34646,0.99609),(0.35433,0.99609),(0.3622,0.99609),(0.37008,0.99609),(0.37795,0.99609),(0.38583,0.99609),(0.3937,0.99609),(0.40157,0.99609),(0.40945,0.99609),(0.41732,0.99609),(0.4252,0.99609),(0.43307,0.99609),(0.44094,0.99609),(0.44882,0.99609),(0.45669,0.99609),(0.46457,0.99609),(0.47244,0.99609),(0.48031,0.99609),(0.48819,0.99609),(0.49606,0.99609),(0.50394,0.99609),(0.51181,0.99609),(0.51969,0.99609),(0.52756,0.99609),(0.53543,0.99609),(0.54331,0.99609),(0.55118,0.99609),(0.55906,0.99609),(0.56693,0.99609),(0.5748,0.99609),(0.58268,0.99609),(0.59055,0.99609),(0.59843,0.99609),(0.6063,0.99609),(0.61417,0.99609),(0.62205,0.99609),(0.62992,0.99609),(0.6378,0.99609),(0.64567,0.99609),(0.65354,0.99609),(0.66142,0.99609),(0.66929,0.99609),(0.67717,0.99609),(0.68504,0.99609),(0.69291,0.99609),(0.70079,0.99609),(0.70866,0.99609),(0.71654,0.99609),(0.72441,0.99609),(0.73228,0.99609),(0.74016,0.99609),(0.74803,0.99609),(0.75591,0.99609),(0.76378,0.99609),(0.77165,0.99609),(0.77953,0.99609),(0.7874,0.99609),(0.79528,0.99609),(0.80315,0.99609),(0.81102,0.99609),(0.8189,0.99609),(0.82677,0.99609),(0.83465,0.99609),(0.84252,0.99609),(0.85039,0.99609),(0.85827,0.99609),(0.86614,0.99609),(0.87402,0.99609),(0.88189,0.99609),(0.88976,0.99609),(0.89764,0.99609),(0.90551,0.99609),(0.91339,0.99609),(0.92126,0.99609),(0.92913,0.99609),(0.93701,0.99609),(0.94488,0.99609),(0.95276,0.99609),(0.96063,0.99609),(0.9685,0.99609),(0.97638,0.99609),(0.98425,0.99609),(0.99213,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD020.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD020.py load and self-test diagnostics complete.")
