####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD019.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD019.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD019.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD019.x3d'),
    GeoLOD(center=(-44.940476,134.940476,-38825.000000),child1Url=["MarsLOD020.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD020.x3d"],range=1.8E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars006.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars006.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,90.000000,0.000000),height=[3561.9143,3517.8032,3463.3247,3430.0706,3455.827,3494.8464,3562.0737,3586.5322,3591.0137,3589.633,3580.3877,3567.8423,3595.4604,3633.2573,3697.7942,3719.3306,3748.4763,3787.9475,3810.818,3817.5896,3816.4253,3808.7522,3827.5872,3886.8638,3948.1206,3959.3203,3956.185,3955.113,3958.2708,3962.0334,3960.9697,3951.1326,3937.9927,3928.0886,3917.0374,3911.6062,3910.4097,3908.9543,3900.0242,3885.3047,3872.8184,3865.3035,3851.5156,3840.356,3829.5942,3797.5403,3764.287,3756.8335,3725.2466,3676.1733,3661.6792,3651.4795,3663.4395,3639.8914,3633.7085,3613.8083,3594.4905,3552.4724,3526.8306,3498.0034,3457.5684,3425.2224,3359.7664,3289.342,3211.6885,3145.2996,3050.0977,2928.4548,2859.4478,2925.9148,3074.7913,3148.93,3196.2551,3227.0754,3253.6367,3298.6646,3318.35,3305.1084,3389.66,3464.6184,3482.6987,3520.613,3550.5437,3559.1965,3566.4778,3579.7952,3620.916,3630.4053,3627.3552,3623.035,3623.0989,3611.4531,3599.7368,3588.7312,3563.8652,3522.5962,3482.121,3444.875,3405.5005,3369.9834,3344.6914,3326.1523,3294.231,3251.305,3207.0378,3172.3223,3130.0732,3086.027,3039.8462,3009.2725,2988.2761,2999.1775,2998.0896,2979.0586,2998.0422,3002.765,3027.7996,3022.84,3037.0984,3030.7756,3003.3425,2965.5059,2977.6594,2930.3335,2770.329,2588.1667,2490.5476,2459.2083,3078.032,2950.3887,2726.9194,2404.3801,1825.5925,1620.8262,1816.8091,2167.4534,2319.4812,2468.01,2564.949,2657.0833,2723.817,2828.6958,2925.6104,2974.8496,3051.6323,3088.6294,3099.2637,3104.59,3110.4783,3139.4265,3160.5623,3161.6953,3139.5012,3079.062,3040.7437,3039.9612,3029.7734,2991.8618,2949.1384,2916.2026,2878.5295,2831.1016,2768.449,2741.864,2722.3176,2714.66,2731.7988,2764.7227,2807.3616,2860.9438,2930.2185,2986.2056,3017.7737,3030.899,3022.8704,2983.6472,2946.5273,2921.9277,2914.9792,2920.3872,2920.2104,2921.9888,2925.9458,2906.443,2886.593,2839.817,2799.4504,2776.1758,2773.618,2793.413,2863.4097,2915.2432,2676.369,2521.5498,2152.7034,1689.5952,1403.2896,1338.3613,1327.4531,1341.1659,1474.59,1880.213,2181.574,2230.75,2236.6506,2308.2969,2459.6326,2582.3904,2604.4285,2637.3477,2671.024,2674.9258,2668.2957,2640.0874,2624.2588,2613.3252,2612.7307,2599.6094,2574.1475,2570.955,2583.8948,2629.4568,2670.351,2684.1616,2730.4546,2744.4797,2732.6406,2700.9778,2666.9656,2629.6492,2536.4517,2434.8572,2368.4143,2358.1592,2372.6665,2375.1504,2410.916,2488.7275,2563.8384,2628.5557,2767.8875,2814.1304,2825.142,2861.8115,2897.0125,2930.553,2936.8806,2954.148,2979.5496,2996.7734,3023.6128,3032.882,3036.924,3042.1575,3050.6406,3052.9067,1789.2852,1511.8318,1297.3635,1245.7278,1253.9464,1241.3616,1257.6505,1336.9487,1627.5751,2044.0166,2155.9211,2160.8267,2148.964,2204.4998,2202.5889,2216.0527,2224.6816,2250.5444,2291.2617,2311.1135,2304.3708,2271.6213,2269.835,2322.442,2368.9907,2409.3884,2460.9702,2500.27,2501.602,2477.7024,2466.4395,2424.9832,2332.5103,2142.0818,1949.4154,1842.7762,1846.4473,2097.1167,2316.7888,2521.9988,2655.777,2746.7566,2833.2583,2865.2544,2925.454,3021.293,3066.1228,3039.7126,2956.6685,2807.809,2616.2976,2437.7014,2479.7446,2664.8188,2667.7812,2726.2778,2932.0537,2984.898,3048.1423,3065.3193,3065.2937,3060.224,3047.282,3032.5125,1097.1581,1127.0466,1166.9092,1290.4321,1482.7621,1778.158,2033.5999,2187.5054,2352.2214,2407.7468,2447.8406,2405.1448,2340.4297,2382.91,2423.4727,2352.9343,2325.325,2275.7107,2215.331,2176.0605,2222.7263,2156.0352,2068.0308,2091.2207,2090.698,2072.377,2144.2815,2132.216,2042.1035,1954.0072,1856.6897,1772.4816,1737.015,1819.7139,1916.1654,1960.7495,1999.541,2274.4795,2392.7053,2367.1777,2338.4785,2389.447,2363.2644,2271.958,2189.0464,2195.8567,2265.262,2305.565,2418.8782,2503.2769,2618.1648,2774.7354,2901.83,2898.8286,2890.307,2867.4905,2816.3296,2846.7268,2935.695,2908.18,2887.7058,2879.8809,2946.4153,2929.9626,989.28674,1026.5642,1077.1304,1279.9674,1383.011,1382.2971,1384.0116,1377.3478,1672.5573,1895.76,2016.9758,2112.093,2150.2634,2080.242,1890.6635,1963.6924,2196.3733,2151.9392,2168.0718,2091.1128,2112.5608,2200.5566,2178.427,2114.3193,2058.258,1989.8527,1836.7689,1575.1621,1524.7544,1570.0061,1670.2799,1773.3438,1730.4215,2096.8433,2174.997,2146.8184,1910.3384,1934.5813,2227.5105,2339.4739,2447.5918,2618.5015,2683.6423,2714.2502,2752.902,2719.6006,2727.4136,2841.0583,2840.2488,2820.6643,2797.8723,2759.0227,2722.8262,2738.6868,2813.8774,2803.1748,2819.531,2852.9707,2849.0505,2811.037,2776.9783,2740.745,2741.0376,2716.4204,1049.1122,1020.01953,994.69617,958.78906,967.3874,963.53094,993.43805,998.3119,982.83856,978.55023,962.7544,980.6981,1046.8958,1172.5266,1285.3282,1472.6758,1639.6714,1772.7772,1862.4908,1968.1113,1882.1682,2036.0577,1980.9629,1871.259,1737.8622,1618.194,1370.7709,1418.572,1648.5345,1993.7618,2122.8655,2243.7068,1619.7151,2057.4421,2521.3203,2435.94,2283.0195,2154.6853,2149.1516,2199.5747,2226.3865,2360.6343,2359.9062,2233.2998,2284.1501,2443.4182,2569.7454,2607.9966,2654.8218,2660.548,2673.9326,2683.4316,2663.9985,2582.2842,2459.3901,2637.0432,2684.5508,2726.8027,2675.6106,2565.547,2561.5615,2473.2183,2407.8816,2453.3523,1210.8119,1200.2942,1128.9502,1184.4714,1177.1417,1235.7018,1356.0916,1326.9237,1444.6062,1485.53,1471.1869,1379.4459,1283.717,1281.4508,1040.7789,1032.8293,1211.137,1415.5522,1382.82,1362.8569,1337.7275,1332.9125,1379.4015,1617.1782,1705.3926,1611.7476,1512.7705,1580.3184,1899.6641,2205.537,2203.023,2256.3857,2327.9177,2537.899,2547.9558,2507.3171,2534.1497,2533.8103,2541.6133,2530.521,2510.4666,2358.279,2315.212,2506.4346,2557.286,2524.3928,2499.2642,2422.9934,2378.4097,2412.8745,2459.783,2460.4941,2429.9207,2304.6765,2356.0935,2472.4802,2449.5095,2460.288,2411.6973,2350.2334,2268.6035,2154.643,2149.412,2216.5447,1639.1044,1747.0156,1495.3129,1760.9149,1811.2677,2086.8987,1767.4003,2076.9148,2427.5151,2542.1807,1369.5277,899.3406,965.89087,1005.24384,1076.4341,1596.9835,1573.8235,1155.3038,1266.1685,1108.3978,930.61993,930.57544,1034.3611,1078.1068,1327.9344,1303.0676,1246.7931,1244.6162,1392.2208,1652.8636,2302.8071,2618.8108,2716.2432,2710.5327,2593.0737,2428.7292,2702.9297,2831.0723,2799.7166,2716.6653,2729.2283,2669.2852,2448.066,2484.6565,2658.7964,2579.3337,2513.8125,2396.8086,2333.1223,2342.391,2378.0781,2371.96,2362.9607,2358.508,2384.2595,2354.5427,2296.047,2225.1104,2160.8967,2088.207,2045.9755,2035.0428,2024.7211,1981.285,1381.3424,1493.6858,1558.8165,1685.5901,1762.3401,1847.737,1974.2413,2292.7695,2314.1677,2362.2366,2205.8113,1768.9052,1646.8953,1589.5472,1718.872,1919.5402,1533.968,1556.9723,1888.5958,1758.615,1511.6239,1337.1882,1311.1927,1236.8752,1206.6112,1053.732,1091.8247,1095.4672,1075.0887,1290.7168,1965.9165,2492.1243,2725.5647,2797.756,2790.0156,2744.2288,2683.5952,2713.5015,2690.4148,2552.4365,2524.8994,2498.073,2352.5117,2401.3801,2445.5872,2486.667,2383.699,2338.8647,2299.069,2147.2039,2161.3093,2111.8462,2016.7485,1947.3464,1952.3809,1876.8024,1913.6118,1969.466,1959.2333,1925.8616,1909.3068,1939.998,1898.0602,1929.9799,1204.8469,1328.8246,1354.5553,1403.6904,1417.7374,1481.1584,1502.1332,1779.7393,1889.7538,2017.1447,2037.4869,1897.9967,1976.5042,1867.9066,1705.0598,1523.0994,1594.0637,1814.9059,1116.912,653.7114,596.2837,1105.8119,1596.1954,2069.6262,2054.421,1551.8749,1167.7646,975.81195,918.8014,960.60474,1090.9893,1215.158,1496.422,2102.4902,2331.7505,2174.523,2347.669,2370.2405,2384.2214,1995.664,1307.6985,2060.032,2228.0522,2041.598,1910.1285,1878.3533,1858.5791,1863.4258,1837.3419,1650.5824,1429.7382,1329.2133,1422.7401,1454.4952,1536.25,1621.8004,1657.8147,1691.1117,1688.6266,1683.6128,1734.4637,1889.8102,1850.6273,1504.5402,323.16293,942.8408,1387.397,1549.003,1423.4518,1831.0892,1641.9637,1724.5728,1604.7144,1715.9557,975.83795,868.92474,1299.9685,1495.7795,1241.4902,990.6325,1139.5968,1269.9342,1278.2498,993.18567,935.2904,1259.0509,1278.7501,1214.0276,1104.2511,839.6367,1075.9987,832.32886,305.9933,159.9183,251.1361,414.99002,879.3802,1080.19,862.0636,1189.4233,1277.0348,1039.3097,908.75995,665.49774,1018.1048,1110.3206,1113.0919,1026.6401,883.3331,950.55444,1098.6802,1214.7292,1319.9191,1180.0859,1204.8368,1132.6058,1066.5847,1024.1462,1011.23126,1141.4644,1440.461,1506.4082,1455.8094,1446.4952,1494.4017,1645.2013,1740.1078,1783.9952,1634.7148,2028.64,1909.7289,2108.9573,2092.409,1890.8813,1929.1343,1901.0791,1999.9803,2112.4443,1875.9791,1791.7687,1747.3795,1543.9434,1325.5719,1219.7106,1197.3632,1376.7921,1330.5446,1042.7434,1022.6036,926.62476,933.50665,889.2754,865.7952,903.2744,1078.4619,1352.8384,795.0824,269.93707,157.47275,345.27475,443.9276,277.39832,313.39227,361.0559,459.73605,544.09235,720.5672,834.6737,850.6387,866.8894,989.8377,1018.7988,1053.2568,1063.8176,1025.0399,1336.7755,1719.5061,1414.0118,1291.5605,1169.4993,1088.7402,1035.3763,1036.2191,1133.6084,1366.2015,1459.4324,1496.8099,1540.9022,1543.4065,1546.3444,1488.1282,1294.9545,1839.5093,1457.8219,2193.5903,2314.255,2393.4324,2197.0132,2046.6975,2013.8444,1879.9358,1916.0995,1932.9807,2123.5737,2180.659,2076.3435,1628.6492,1403.7538,1284.5299,1345.892,1411.3586,1182.3704,1214.3236,1239.1179,1484.7223,1359.029,1152.3356,1227.6853,1649.7229,1389.2898,1006.69,639.34283,546.4432,583.27344,1483.712,931.10596,352.7534,395.7911,502.5307,617.94476,706.4236,794.6103,899.607,968.08716,1293.3761,1382.2618,1183.0028,1561.0374,1566.5338,1451.8406,1794.9797,1974.3082,1575.5103,1308.516,1056.6669,1142.9521,1231.5605,1358.364,1451.0734,1396.6472,1630.5477,1720.271,1708.3983,1687.5522,1599.5554,1481.0673,1859.0186,1904.3105,1986.4983,2248.888,2489.3562,2197.0125,2035.8417,2368.551,2302.1846,2165.555,2060.651,1889.4402,1359.2333,1760.105,1695.0961,1639.9181,1854.7861,1944.6505,1807.0162,1495.7421,1252.5266,1271.454,1274.6322,1248.9526,1016.8789,1017.05115,1046.3711,867.9733,833.8463,810.0802,749.09576,855.2982,874.1136,1170.1974,903.44617,807.89294,752.2664,880.8356,908.5208,982.09467,1079.2185,1126.6128,1184.7927,1053.6425,1159.614,1091.7876,1183.0824,1207.5297,1334.3267,1503.0199,1725.8582,1237.9341,1278.4607,1312.7786,1457.6206,1499.3662,1693.2678,1629.5131,1635.9688,1919.6735,1725.8324,1882.8656,1835.0635,1664.417,1023.8914,1544.2546,1685.2018,1904.5531,2183.9944,1833.5299,2111.9197,2395.0298,2410.7854,2354.1592,1905.5211,1855.1731,1818.0975,1717.7683,1739.314,1917.2832,2147.2795,1666.3368,1509.3328,1904.1415,1660.3802,1258.3057,789.9769,1067.8262,1199.3623,1282.2769,1080.4979,954.1967,1163.7809,1998.869,1661.8427,1318.3269,1205.0377,1450.9617,1624.1198,1705.4476,1424.2372,1503.1162,1203.6976,949.74774,1155.1963,1241.457,1066.615,1107.0199,1039.8778,1060.4276,1024.5126,1044.3542,1045.9602,1251.4524,1604.0822,1550.725,1533.9642,1604.184,1918.6029,1760.0741,1745.1998,1635.5663,1744.96,1786.2615,1818.301,1905.347,1997.8431,2050.6455,1035.6141,1766.5834,1622.5887,1532.7058,1719.4661,1904.4677,2070.9841,2338.659,2281.444,2084.7134,2093.9739,2052.3853,1919.5126,2020.3219,1856.4167,2111.3464,2174.2332,2343.518,1847.2172,1107.1818,2264.888,2188.1655,1844.938,1430.0024,1404.1543,1350.3857,1252.6813,1116.8462,1276.0908,1627.9324,1650.9546,1581.1958,1521.9111,1534.5801,1370.7357,1319.7916,1253.6399,1773.2667,1796.2449,1310.1815,1335.9459,1696.7965,1827.3253,1466.9567,1555.3839,1335.4772,1201.4985,1119.3716,1183.8401,836.5379,1268.4104,1406.4213,1538.63,1437.0826,1697.0782,1594.1415,1222.8284,1437.1906,1425.0353,1546.2124,1617.7131,1762.3029,1586.4155,1974.376,1350.8025,1673.5997,1631.3639,1659.353,1747.7394,1829.8448,1973.8894,1677.9684,1490.5498,1818.6766,1735.8214,1867.5115,1657.2692,1835.8718,1960.433,2092.3245,2178.3345,2194.4338,2358.0684,2535.9548,2446.1243,1776.4031,1585.7932,1609.9193,1772.952,1717.337,1670.1384,1499.0012,1267.2194,976.24005,881.2718,854.9257,814.9715,881.5974,1129.2925,1127.718,1355.0713,1447.5275,1368.684,1372.5579,1419.0812,1510.1367,1713.4441,1948.2999,2217.4326,2179.4624,2007.4213,1764.1355,1520.9496,1373.4869,1087.2828,1201.6666,1160.7336,1223.0222,1168.1533,1148.4291,1173.6588,1409.9363,1656.851,1664.5995,1519.7843,1529.3148,1584.3762,1719.8629,798.72565,1218.1984,1607.6898,1175.3284,1533.5664,1680.1406,1765.2695,1868.6,1794.8734,1877.8743,1976.7302,1638.9451,1651.3491,2101.288,2094.514,2270.9902,2262.8174,2115.5713,2207.8276,2264.6555,1634.4567,1943.9835,1907.6658,1864.8099,1824.9158,1937.5519,1853.5396,1793.1519,1478.8206,922.4764,561.73566,411.87668,297.8458,347.631,450.17136,547.66034,766.8899,1019.6205,1278.8982,1365.7164,1602.267,1551.78,1688.1011,1901.7263,2115.4753,2270.083,2144.6084,1885.9309,1897.5457,2277.7375,1902.7981,1515.2764,1270.8081,1197.8676,1241.9086,1694.0839,2063.8984,1686.003,2024.4924,1965.3555,1463.5033,1199.1079,1590.8767,1914.7427,459.92886,845.11694,1106.2466,1871.114,1770.1257,1707.3389,1675.4205,1930.9304,2063.8047,2134.487,2371.8481,2299.4053,2187.1367,1808.6134,1557.4176,2059.2905,2077.0425,1940.8313,2339.8662,2209.378,1975.2249,1945.1201,1934.2109,1006.13965,1538.9491,1868.7745,1657.202,1604.3593,1554.5386,1086.8756,607.4945,381.74493,336.85516,302.32852,372.11633,488.95752,620.10626,722.1033,820.96783,1037.6028,1114.6649,1242.0773,1520.918,1711.7426,1906.8779,1979.7454,2021.1504,1952.1727,1933.4432,2231.8594,2312.1812,2002.0778,1952.609,1780.0072,1755.4509,1823.5327,2214.851,1946.2302,2013.2219,1754.3766,1315.0845,1145.3883,1078.6508,966.05457,214.17863,552.8514,651.2462,2062.3477,2250.3667,2370.9954,2307.5017,1329.8008,759.9125,763.61597,1054.1256,2177.1396,2573.6084,1820.4425,1441.127,1899.5448,2042.2269,2207.3933,2524.3066,2456.0369,2047.2377,1954.525,2118.0847,1840.9707,2013.5072,1840.5664,1433.224,1091.8333,929.3414,805.9788,709.25555,554.31915,610.23865,646.72644,640.09015,665.90796,598.9906,607.1228,694.53174,780.79407,902.39307,1068.83,1347.5435,1618.8676,1789.3715,1948.8342,2127.348,2050.904,1980.3456,2045.2377,1919.4882,1843.709,2574.734,2304.9385,2183.0396,1944.6981,1445.2905,1581.9126,1566.941,1457.2872,1481.3551,1464.6129,1274.501,1076.8759,-155.54352,-183.564,181.0656,1006.4556,1591.6676,2209.921,2101.5374,696.7383,334.3276,308.26474,326.52112,1821.3123,2153.47,1748.6798,1654.4962,1555.2249,1887.0323,2304.4243,2217.5576,2346.9382,1604.154,1738.4879,1681.0951,1715.0359,1617.3958,1431.9652,1500.3895,1180.69,833.64435,796.33356,941.0117,795.8135,1070.0359,1433.0801,2002.9719,1687.294,903.0723,587.31177,628.1904,709.57086,904.08215,1123.5359,1423.0289,1656.515,1756.5638,2038.2426,2098.746,2039.3693,1950.3245,1825.3213,2189.9043,2548.5156,2532.5947,2319.7837,2088.5942,1883.9606,847.4198,1412.5673,1898.8545,1807.9662,1958.9072,1710.9891,1574.7299,1133.4513,-530.6158,-327.6376,147.30678,253.52654,208.17433,1065.0345,1006.0754,854.0029,1091.2772,1480.6552,1733.5656,2061.2273,1854.5873,1587.7014,1486.3041,1542.2568,1821.272,2127.2576,1951.9446,1878.0934,1752.4177,1453.1305,1229.2373,1096.4576,988.3873,589.9082,1016.3876,1167.1315,1425.0122,1362.9565,1109.142,846.2475,1465.6962,1680.8441,1705.4318,1197.0117,960.55237,919.45276,740.0842,936.92474,1201.9922,1510.1157,1858.2155,1990.32,1987.6134,1847.2012,1688.8063,1540.7014,1391.4457,1665.3718,1731.8389,2116.1428,2202.0696,1997.8505,1867.359,1945.506,1922.0192,2103.7805,2003.313,2095.9055,1942.6511,1824.0936,1522.9438,1304.8469,-626.00867,-271.93546,-107.45175,5.666246,177.80827,570.75977,1014.421,1175.4885,1081.3225,1395.576,1732.0219,1611.7341,1351.414,1914.9247,2640.762,2646.4785,2081.9553,2060.97,1726.858,1785.7836,1436.5292,1120.6643,905.7356,1009.52795,1004.7243,454.46713,410.98724,567.59924,1102.2219,974.289,1239.3998,1351.0758,1841.345,1651.3989,2172.0413,906.485,524.7044,947.4888,1183.5421,1124.0034,1254.3389,1546.6554,1722.6648,1750.7555,1539.2786,1752.9734,1454.6564,1429.6515,1389.9901,1499.0582,1481.7856,1647.5836,2087.6848,1420.5681,1057.8846,1674.9647,2106.2478,2045.3868,1945.9578,1682.9875,1611.9039,1508.8157,1180.339,981.0979,-863.2222,-915.2362,-1020.8175,-783.4429,53.41687,951.21313,1000.2554,859.23914,862.94855,1404.3479,1712.5763,1532.435,1752.0894,1967.6018,1335.5503,934.93884,1275.7526,1516.5973,1490.7991,1453.4894,1693.9532,1630.8739,1414.7543,1460.4701,1477.1501,873.286,534.0191,432.87708,221.40456,804.2105,1222.6462,1242.5725,1779.7001,1147.298,788.2795,1224.7059,888.09955,774.93536,814.8598,780.9492,1026.1768,1331.2809,1499.7952,1510.1134,1458.3209,1691.4288,1565.143,1740.6866,1609.3042,1519.199,1396.5012,1345.3801,1948.06,2097.59,1940.3479,2381.2188,2136.6125,1681.8839,1475.4316,1351.1294,1290.5797,1151.4276,913.6627,1014.3172,-1326.9409,-1235.3486,-717.7982,371.99878,329.3598,523.8533,650.226,615.0049,1109.5851,1440.563,1595.9048,1341.703,1710.0625,2355.1921,1279.7736,765.2607,1293.1295,1380.9448,1155.9951,1188.6497,1364.2217,1382.2253,1321.3546,1030.7249,790.1729,1012.4018,1135.2737,1497.1946,1005.0385,871.11566,984.18945,1009.1169,1427.667,994.40967,564.92255,687.6671,837.9964,1223.2307,1533.7888,1095.7566,891.7707,1035.4279,1214.9156,1379.4219,1489.283,1748.3976,1340.2366,1763.9368,1464.9199,1392.0315,1372.9473,1743.2607,1948.3331,2077.231,2316.1191,2274.6829,2085.455,1653.5856,1502.2906,1424.7112,1348.5498,1211.4916,1150.6456,1112.938,-3018.2673,-1585.1353,-1256.3376,-511.37076,262.47906,415.4988,763.6942,-39.34593,393.83536,1013.415,1255.0742,472.0679,557.20636,1650.1711,1871.434,2456.222,2238.706,1250.7028,1004.16003,1067.6732,1401.9874,1169.5637,826.7973,785.9437,1020.1858,945.1778,922.209,1579.0535,1471.9984,1252.1731,976.2055,992.44086,934.8297,1185.372,1143.7186,1190.2378,1383.6239,1052.4557,1266.4437,1837.2395,1124.4058,844.28375,889.8027,1191.0828,1153.9012,1131.1333,893.7596,933.3344,1093.4636,844.1935,877.5162,837.2131,1483.7952,1324.6605,1769.8113,1870.8013,1960.4156,1986.0734,1959.78,1907.3184,1671.7346,1424.3263,1365.2299,1245.5596,-4246.2515,-2989.4893,-1498.1024,-1080.026,-507.86963,-484.76575,-184.87038,-248.42592,203.5547,441.12225,1042.5924,1757.6917,1531.7145,1247.1339,1342.6399,2005.0526,1691.5151,1371.1091,1611.5603,1302.8921,1159.6741,1201.5186,1300.4696,1264.7831,1264.4291,1319.1218,1411.5873,1422.2028,1481.8932,1315.3584,1167.3068,1227.079,1355.052,1580.6625,1766.5673,1687.5123,1902.5148,2187.3916,1895.9453,1653.7908,1311.0964,1622.0962,1637.5367,1509.173,969.81024,728.3506,827.77795,441.3835,1197.9471,746.82074,610.32336,750.5744,908.7551,1083.4393,1420.5962,1813.8556,1981.704,2267.906,2286.468,2215.5708,2088.0005,2027.0652,1652.1527,1573.2538,-5415.261,-4394.1143,-3174.3374,-2092.6272,-1242.9581,-803.86017,-369.5923,-265.55118,-231.6439,-178.07462,455.50867,1748.9757,1848.7522,1022.7187,652.78235,812.0616,829.1115,1011.264,1131.4722,1238.3293,1018.85364,1260.3024,1109.698,1715.8727,1603.7755,1585.745,1659.2822,1294.7377,1647.8647,1576.6938,1518.3099,1681.9209,1792.8447,1973.0978,2367.451,1992.3693,1248.2578,1105.0983,1498.5184,2146.2324,1810.5862,1756.8503,1671.8079,1007.9557,796.9308,813.5291,746.0102,609.31964,601.47955,593.3631,624.39764,803.65436,912.6681,1342.4717,1805.5768,1810.0448,1766.4784,2058.272,1973.5725,1938.4403,2018.1018,2091.382,1878.5292,1699.1697,-5451.8013,-4977.767,-4433.88,-3638.919,-1952.8687,-1285.9414,-907.6568,-615.81256,-408.18573,-365.41095,-277.379,81.24664,634.60815,587.85925,964.2715,914.73517,1405.4238,1446.1503,930.46564,915.5389,925.4072,967.0037,988.25464,1374.0701,1261.7908,2187.305,1633.0845,1568.3552,1786.3221,1644.2094,1362.7878,1350.9204,2162.0815,2452.4036,2888.754,2202.3418,1080.8877,1005.11035,1564.175,1930.4218,1424.0968,1116.8167,1049.665,994.4168,1097.703,1318.8447,789.6811,603.6791,773.4066,888.47546,879.7376,908.5707,1035.4116,1505.2173,1742.758,1731.2792,1926.3628,1833.3556,2012.9767,2070.1458,1988.1704,1844.574,1767.5935,1785.5354,-5539.3125,-5127.925,-4553.259,-3959.915,-2606.959,-1635.3917,-1178.9022,-785.5512,-432.2984,-402.20728,-462.4902,279.1855,321.1935,863.1417,753.056,792.0115,755.4509,890.1701,1200.4259,1272.2664,1162.4545,1110.5292,1061.0068,1367.625,1485.2036,1548.8971,1569.3558,1567.302,1638.8021,1865.152,1749.9465,1937.6335,2022.4377,2179.166,2376.6316,2796.057,2212.6565,2152.826,2137.0762,1789.8972,1109.4413,610.93353,574.33746,811.71826,959.2401,1043.6521,608.4034,802.6329,955.21814,1055.1746,965.2457,845.2597,1084.1195,1669.5359,1879.9974,1835.7303,1776.416,1940.8766,2601.3801,2595.9045,2009.9503,1791.8105,1715.14,1699.4088,-5261.3364,-5017.0415,-4637.4443,-3942.7468,-2970.6467,-1873.867,-1358.1088,-1089.72,-1048.8038,-1205.599,-619.5715,-350.90057,-233.30762,168.52512,1160.9917,578.72406,681.257,730.0434,1385.6335,1558.1473,971.87585,786.1944,855.2539,733.91174,1080.4702,1215.627,1412.0369,1444.0099,1520.903,1696.8281,2064.4438,2144.9973,2028.0707,1993.8313,2129.2234,2265.8728,2488.435,2467.1472,2053.0308,1624.3691,1005.13153,310.24622,213.60416,256.756,670.4389,545.4685,605.60266,968.32965,1066.1158,1017.2284,939.5865,1132.5773,1424.2046,2288.914,1954.8729,1584.5608,1550.2482,1623.4728,1260.5533,2137.4268,1753.7501,1600.373,1291.5151,1261.9458,-5032.936,-4836.2974,-4452.782,-3843.2869,-3003.4053,-2322.0012,-1604.5695,-1183.6239,-1206.8992,-1151.6498,-507.17487,-62.020283,-163.59082,353.27542,1344.0719,984.70966,677.2843,748.92236,906.85095,797.63385,645.5108,684.39636,696.24756,730.7484,950.14655,928.73505,1354.2076,1409.2666,1550.038,1615.4427,1893.7273,1988.934,1770.8326,1881.9027,1910.6072,2158.9084,2145.2654,2247.0547,2017.9827,1540.6699,906.95483,506.7907,325.4132,379.91086,815.52966,799.78906,676.46484,1416.0729,1487.3586,1204.5969,955.02875,1250.0735,1961.077,2486.0002,1898.0791,1450.6753,1453.7128,1611.0322,1337.2382,1608.3246,1612.8856,1262.5308,1023.3758,984.47205,-4815.3784,-4661.5522,-4183.0957,-3793.3008,-2999.3374,-2388.7615,-1858.0459,-1703.0186,-1191.3405,-327.4307,-405.22012,127.75328,196.0392,252.21674,405.68362,930.0593,954.12915,782.1244,661.4762,600.9991,700.236,648.8265,755.5389,600.5115,588.4936,1098.006,1492.1931,1715.1409,1810.2163,1678.4926,1814.626,1854.9509,1341.5635,1382.2473,1512.8647,1685.101,1604.8776,1395.4188,2005.9635,1619.6029,1292.9089,1004.115,1013.43677,1014.1371,1078.2601,583.6841,478.26495,1204.5217,1562.7462,1403.3873,1177.8944,1414.7295,1988.8258,2007.4093,1717.7488,1271.4791,1306.0242,1706.4083,1619.952,1406.6794,1128.6144,906.1517,809.7373,910.85614,-4491.7773,-4288.149,-3970.8687,-3712.757,-3156.1094,-2327.9514,-1524.7299,-715.66675,-415.74542,-281.4805,574.9106,368.2848,646.5891,717.9547,666.47437,525.2711,624.5573,616.0764,544.0641,1008.8966,873.7621,668.7536,763.0947,596.499,543.43695,951.5624,1160.7185,1432.8553,1520.6544,1238.5509,1453.6818,1712.9312,1673.3566,1533.1433,1365.8062,1447.4468,1599.4913,1704.3917,1887.8401,1701.6433,1695.1182,1554.4792,1319.7885,1176.5562,774.13306,497.19672,623.143,949.40607,1385.2867,1383.7026,960.9519,1231.1045,1396.9302,1212.6519,931.84283,945.4311,997.9408,1197.1469,1349.1046,1101.5894,1029.5021,746.59607,693.39624,574.0782,-4296.527,-3904.0393,-3594.707,-3422.41,-3096.2468,-1853.8562,-398.3925,-653.2491,80.3088,102.84361,1344.3254,1198.5677,1097.8278,916.2416,987.4344,770.4807,398.85284,422.50323,501.6703,739.53284,661.42883,530.7314,580.6736,663.1906,672.074,802.85803,854.33636,897.9409,922.2099,969.9782,962.20746,1057.8195,1215.6152,1103.7847,1009.5083,1986.8365,1644.7574,1661.9938,1763.2568,1797.382,2017.7462,1632.3455,1283.0476,1378.771,945.636,774.1545,964.1017,999.5484,1213.9216,1196.1757,728.468,787.17554,830.56647,781.0328,820.05963,844.8873,926.39197,1146.5786,1210.0569,813.0033,623.45197,467.70807,608.41876,130.93782,-3932.588,-3671.6335,-3080.459,-2717.0151,-2113.8604,-2076.2021,-1887.5321,-1656.8859,-98.35544,165.62692,514.2888,703.5026,874.2703,976.441,986.99426,999.7873,633.0286,686.7166,546.97174,508.70734,498.48492,626.94244,695.3432,633.5845,682.8035,811.00476,1036.0317,1047.3292,980.6466,998.499,998.76013,1169.5862,1196.6389,1278.7108,1290.8135,1245.7755,1279.0823,1368.0013,1558.5392,1886.6869,1739.0769,1478.6118,1223.847,1430.4769,856.7138,828.61444,891.75116,1068.551,891.22424,731.8959,744.55164,608.3695,675.1144,943.66754,942.2294,963.6601,1012.5943,1200.3145,1130.695,300.402,131.55591,127.9197,170.00687,7.529438,-3274.2515,-3362.1682,-3288.2625,-2762.8455,-2260.6665,-2088.5945,-2069.7449,-1459.1005,-189.21233,327.108,548.39606,761.2321,857.62024,1027.3872,1153.1462,1026.8722,860.60645,754.44696,704.2999,594.1637,510.02264,527.1101,597.8258,866.30786,1219.307,1309.67,1630.4209,1826.3572,1475.216,1217.6309,1279.1852,1504.3153,1657.5416,1604.5336,1289.2118,1056.6289,1291.9583,1260.0895,1336.9897,1352.945,1595.5128,1265.3987,1299.2953,1536.2838,1211.0563,1310.8511,1283.8112,1143.353,1266.5298,1473.386,1444.1154,573.52686,529.2666,817.72107,1019.92444,913.69543,857.267,1116.0238,510.01263,-58.297745,56.95179,286.02356,663.12854,1074.9968,-2610.3596,-2562.0295,-3430.0627,-2894.2224,-2515.211,-1852.5762,-1761.9846,-1628.0513,-1053.5345,146.63231,627.7934,786.6767,981.62524,1121.0514,1112.9961,1151.3469,1080.0137,911.85016,983.17896,869.8217,786.2613,623.5997,688.05804,1175.4847,1602.2185,1315.6667,1459.8743,2231.0178,2020.1833,1947.2194,1853.422,1775.7268,1786.9812,1913.0193,1299.0367,1555.1998,1532.1334,1342.3568,1392.6658,1668.2356,1505.9366,1347.0632,1472.3037,1444.5111,1434.1273,1257.4116,1145.16,1036.2542,1246.7932,1359.0995,1359.9305,730.7163,407.03952,728.9231,1134.3763,988.4783,950.35175,1103.6217,441.26453,272.28525,394.42346,786.30365,1060.1893,1333.4803,-1960.0548,-1856.6155,-1814.3307,-2251.25,-2137.0073,-1907.9363,-1431.3744,-1276.9553,-623.04315,292.99677,613.03864,898.8941,1116.858,1206.4469,1305.9395,1380.51,1262.2009,1070.6201,1226.5898,1159.2317,1107.3496,935.0577,913.7409,1110.8398,1676.8896,1581.3276,1399.6116,1773.3312,2250.6519,2305.9648,2234.779,1995.1046,2058.044,2223.9722,2176.536,2257.231,1207.8025,1184.3219,1143.9216,1518.198,1296.3313,1378.5138,1336.4275,1309.2935,1504.6736,1201.878,1145.9556,716.1982,849.706,1088.4297,1226.1116,1121.7124,1037.5751,1597.4056,1229.1038,929.8134,885.87463,1041.7953,779.4786,643.9017,680.2648,912.8858,974.0547,761.7337,-1252.2782,-1081.9935,-1151.2296,-1353.5157,-1695.3052,-1466.1968,-659.65247,-661.7677,-490.937,497.32138,673.3121,829.3494,1089.5171,1253.7546,1329.3354,1444.8479,1391.349,1201.7725,1303.5966,1294.8594,1277.4951,1048.4614,1022.18494,1166.1912,1461.9784,1394.485,1318.9552,1438.759,1829.8256,1934.7383,2087.323,2081.5303,2219.12,2264.6465,2477.7651,2398.0127,1745.1995,1143.2938,963.3121,970.2947,1051.2257,1214.0424,1007.3116,896.54974,1268.6305,918.06195,976.88763,650.0449,891.03705,858.27216,1135.2904,1116.682,1002.34265,1275.9373,1032.5856,953.0061,1006.42816,1140.26,1013.291,940.68317,856.6104,834.0598,825.6795,787.2872,-1092.3641,-718.65796,-862.8068,-1052.6581,-1329.5496,-798.131,-94.90492,7.719004,99.00231,416.64908,717.1107,904.28125,1026.2854,1052.0931,1278.3336,1348.9818,1368.0369,1301.3857,1303.3049,1268.1571,1349.1532,1194.0645,1127.8983,1172.7152,1299.3148,1377.0148,1605.3584,1624.6786,1701.6895,1963.4712,2165.2559,2507.3958,2333.3062,2310.0479,2265.3696,2385.5886,1908.615,1099.3706,962.47595,891.7544,1121.2203,1222.2222,936.83813,1246.7869,1229.92,909.63007,810.8577,653.06775,1012.86017,1218.7935,1083.1434,1038.8685,1123.1675,1316.5276,1103.6033,1227.5579,1126.0798,1010.4184,1090.0491,1083.1171,886.8214,937.9846,754.03424,744.3888,-613.7871,-659.46344,-228.5099,-295.94022,-773.71063,-855.95215,182.78389,631.8776,551.5309,759.3107,936.20386,1081.1674,1155.0085,1155.2671,1191.7102,1228.3682,1321.7391,1262.6932,1254.1024,1306.5375,1321.7856,1278.5667,1232.8345,1427.4204,1696.253,1928.3652,2196.231,2118.597,1896.8938,2000.8208,2028.4954,2440.7258,2530.9507,2303.32,1771.8226,1882.8036,2033.7642,1517.1921,1233.7505,992.6545,1143.7517,1218.227,712.6606,1255.2358,1244.6046,955.19257,821.0901,750.5052,920.37103,1041.3861,916.14575,937.13153,1117.5686,1420.1837,1538.0,1570.1156,1679.4006,1307.0294,1200.1458,1183.0969,1260.8024,1135.5946,1054.368,752.3537,-331.8997,-389.8973,1207.6088,966.1515,-202.11493,-283.31876,541.3651,1509.6821,954.71277,1142.1925,1254.9316,1363.0338,1360.1287,1357.7461,1261.9305,1318.3171,1272.709,1264.147,1261.5824,1360.5906,1382.332,1407.893,1464.26,1579.9954,1991.1061,2316.7412,2662.313,2362.982,2336.4758,2195.4849,2120.0537,2512.828,2524.5146,2724.2292,2242.2112,1823.3171,2119.519,2127.599,1955.1531,1372.2915,1076.8156,1004.26855,728.8716,1300.599,1144.3955,888.86066,1225.2574,1405.163,861.4764,739.1952,728.4447,865.0254,1068.8176,1478.8196,1803.983,1986.2365,1754.3341,1520.9138,1102.7727,1567.9305,1342.6527,731.7903,480.72028,648.5087,-71.31343,740.91284,1383.7247,882.70355,558.57025,1457.5491,1467.8568,1172.7731,1334.6318,1482.9398,1589.102,1662.399,1619.8134,1591.7947,1505.2932,1558.4281,1425.6292,1394.0192,1353.6674,1399.0815,1509.3628,1574.4835,1613.4644,1527.7938,1932.6173,2227.3044,2550.8584,2177.2832,2352.3208,2249.895,2012.1824,2006.44,2224.2292,2683.103,2570.7544,2303.4832,2345.7134,1942.1122,1958.9326,1759.7598,1328.1976,1062.9171,1348.9331,1693.8167,1148.7253,933.43207,1265.0383,1335.3479,990.24756,688.8017,861.2803,948.3053,1391.8267,1794.7178,1697.9744,1373.4281,1284.5978,1325.7609,1713.3568,1564.9369,1014.2976,453.72998,453.4702,744.00977,823.7292,1474.6599,1971.1414,1718.7147,1397.1793,1502.2389,1520.049,1367.9584,1673.8677,1753.8174,1955.2885,2083.0828,1896.6416,1708.34,1601.532,1518.6134,1517.618,1436.5441,1375.7397,1468.4725,1652.1909,1678.1313,1711.9027,1564.2809,1607.1927,1689.5726,1671.0267,2070.3235,2244.3535,2346.9285,2115.3079,1738.241,1977.6871,2340.3179,2609.6636,2417.5798,2210.142,2282.4675,2032.1755,1586.4016,1368.4313,1303.1271,1449.859,1427.1237,1278.6292,1137.0532,1101.4058,559.6471,1020.47345,549.99945,1076.1984,1035.4121,1130.9956,1684.2526,1835.6105,1293.1917,1088.0321,1162.9052,1510.9685,1418.8137,784.7729,270.4815,324.95905,715.71643,1403.6265,2091.8906,2447.6482,2673.4153,2560.51,2374.3677,1543.8207,1465.03,1520.8105,1765.615,2005.0385,2308.0693,2277.4973,1745.0339,1527.4911,1464.2369,1497.8413,1399.3878,1396.025,1545.1974,1662.5155,1673.9893,1751.7057,2067.7024,1810.3525,1759.2336,2006.9458,1607.8616,1533.3977,2256.712,2271.0972,1807.2153,2175.1904,2468.8943,2132.998,2251.3203,2153.6099,2439.8428,2124.926,1920.061,1525.5801,1281.1147,1091.8417,1074.9281,1262.7511,1212.9895,1272.607,1146.2797,1033.5474,401.41443,803.5639,1160.4105,658.98975,891.19226,1020.0045,1308.4348,1094.5956,1177.3333,1207.2672,1322.1733,1051.131,629.42993,412.4757,807.02277,1714.0684,2113.4326,2638.3247,2801.8328,2673.2712,2138.946,1790.608,1648.4395,1675.9128,1770.9478,1903.6748,2153.04,2437.9558,1871.8145,1547.7283,1474.6309,1478.2891,1461.6418,1447.8441,1536.5477,1608.9915,1676.8317,1842.3656,2216.9258,2303.691,2402.606,2367.5508,1569.6918,1443.7518,2015.7854,1956.1415,1793.6053,1915.4362,2316.9092,2357.9795,1876.5261,1937.9633,1990.3903,1829.7611,1916.2794,2061.639,1764.486,1312.971,1197.8838,1291.4333,1017.0479,1017.6797,1493.0873,1253.6296,524.70135,294.46304,223.22266,436.9196,563.7745,511.4902,406.34378,532.1781,525.4573,884.9111,1202.2338,1076.0841,938.3969,837.30194,1110.1687,1754.8805,1958.6493,2427.2134,2646.8027,2755.3782,2416.6692,1788.7821,1707.0178,1705.268,1654.0286,1631.588,1480.9224,1577.2963,1541.8248,1552.6737,1534.9629,1480.6122,1461.979,1498.018,1539.9222,1643.768,1736.0206,1773.3239,2271.927,1892.4183,2640.2327,2425.5618,1560.1793,1556.9724,1405.4233,1800.367,1846.5654,1888.1415,2367.29,2119.529,1841.0096,1851.2555,1593.7855,1989.4019,2123.9402,1905.084,1851.4019,1580.3837,1443.8608,1459.72,1543.5518,1716.428,1538.0027,904.135,373.6125,165.91974,-123.83791,-14.215419,-188.29169,-334.17822,-466.11917,1.337547,-116.66718,474.59222,705.91455,705.18365,884.20264,687.6368,1303.5125,1788.8644,2010.2919,2366.8943,2461.5388,2636.5493,2349.7446,1785.1328,1763.341,1639.5042,1567.8837,1423.6315,1362.883,1315.9535,1431.683,1493.3512,1518.2648,1524.199,1464.3126,1540.0293,1634.4183,1652.1674,1843.1547,1738.5707,1995.7119,2141.5862,2178.6694,2378.8503,2205.6846,1973.5563,1912.9366,1964.2434,1757.0148,1668.024,2065.6887,1809.1781,1691.514,1758.6498,1838.2421,1756.7898,1869.1548,2034.7335,1948.5875,1827.126,1965.1327,1661.1107,1704.5929,1664.8591,1481.4539,1082.6697,584.8001,43.302708,-401.4697,-566.5711,-591.4772,-576.751,-795.4526,-430.6352,-421.1767,-311.81824,-11.001119,182.21371,613.13324,461.18515,1230.9023,1990.3021,2193.5315,2231.1702,2648.5405,2548.9465,2305.4592,2006.6357,1719.1097,1528.9316,1499.2142,1371.4728,1360.9441,1273.9631,1444.6017,1468.522,1509.113,1546.4911,1538.4735,1655.0377,1680.5798,1760.7509,1955.154,1812.3517,1843.0261,1874.095,2180.9917,2291.507,2165.104,1611.2393,1808.0425,2080.535,1999.485,1688.5732,1748.3699,1613.6976,1513.1084,1571.1349,1764.8828,1712.5072,2014.9381,1912.1329,2028.9142,1674.7656,1984.8687,1804.8491,1746.4463,1735.0691,1248.9761,941.4959,306.59393,-29.04046,-358.24557,-560.6693,-789.1437,-932.01306,-994.3512,-843.44244,-757.9818,-657.7221,-409.72525,-172.68796,168.16179,128.42403,657.0487,1994.7682,2450.2988,2700.397,2760.6152,2552.9587,2231.8699,1757.176,1733.5928,1561.8698,1412.0764,1417.823,1430.4702,1380.1737,1455.1548,1372.2458,1441.3708,1493.0442,1629.1298,1499.6763,1760.7704,1917.716,1677.1743,1861.1857,1856.0884,1891.897,2200.9485,2594.584,2003.0695,1539.7058,1305.207,1723.1478,1733.6368,1698.2866,1664.0099,1653.9122,1634.1294,1533.9628,1568.9785,1566.3352,1764.4773,1952.9692,1841.7047,1614.6688,1451.21,1467.7079,1494.1519,1531.4751,1113.927,884.2724,35.310165,-211.91965,-856.8649,-1386.9735,-910.171,-894.7462,-1009.10504,-400.981,-740.4294,-1330.8578,-704.04333,-982.2148,-1499.5194,309.73502,425.6938,2367.5334,2434.8384,2724.7844,2705.0425,2410.1245,2110.127,1610.7919,1723.9955,1530.4176,1521.6613,1451.5892,1419.363,1415.7623,1419.8042,1380.1553,1427.8348,1598.5016,1412.8313,1743.3706,1860.4796,2067.9146,2046.94,1919.8512,1873.3344,2062.5334,1968.7485,2290.5168,1644.713,1308.9578,1309.7891,1853.9104,1956.5114,1854.4008,1896.5592,1559.961,1607.5032,1693.0576,1615.6552,1662.1692,1796.7467,2094.7495,2161.598,1829.6932,1142.3022,1102.086,1053.3329,843.8987,915.7377,493.92188,-331.61908,-602.8707,-1122.8765,-1620.6862,-1419.4719,-1473.3607,-1266.7306,-1048.8503,-1604.8894,-1666.1317,-1586.2413,-1560.4313,-1707.3998,-846.1708,-721.3933,2320.5813,2353.8938,2631.1025,2649.9368,2244.8657,2032.7682,1910.1658,1793.813,1379.6351,1447.0715,1339.3655,1422.719,1383.8745,1346.9337,1332.0737,1418.236,1537.8964,1561.4592,1910.1288,2045.9973,1907.969,1988.9495,1960.9515,1878.4309,1787.4044,2346.4502,2360.8354,2540.9634,1854.7072,1883.3751,2042.3567,1797.48,1646.2919,1713.2848,1530.1464,1525.4937,1741.2523,1716.5939,1601.6141,1783.036,2067.4104,2228.098,1829.8212,974.3306,669.2054,708.7832,391.99814,159.98904,-277.1956,-850.67426,-1214.2426,-1331.3323,-1511.2192,-1686.3856,-1577.5247,-1478.9259,-1369.9393,-1623.4905,-1957.042,-2088.553,-1935.6736,-1594.5033,-1740.6375,-1676.5012,2303.2766,2458.1436,2527.4126,2236.1753,1980.993,1795.6025,1711.1104,1481.495,1216.2001,1244.1259,1299.381,1498.5901,1381.1023,1279.8212,1291.1333,1353.8301,1505.9019,1450.1747,1553.2955,1858.397,1606.8146,1655.9689,1421.8701,2174.391,2112.0005,2451.9277,2494.1875,2293.682,2373.888,2099.6235,1881.106,1394.4438,1351.4963,1819.389,1596.4214,1375.4746,1355.4729,1245.4629,959.02783,615.0651,1120.7006,1360.2854,1009.73236,323.8097,482.5644,420.7989,238.15446,9.29569,-341.61847,-910.4341,-1237.8538,-1539.9581,-1597.3807,-1808.4235,-1753.0149,-1795.025,-1899.8064,-2030.4852,-2189.9912,-2210.4502,-1704.1482,-1489.7517,-1592.6616,-1420.6671,1966.0415,2594.5393,2246.5015,1822.7028,1731.1821,1791.4125,1594.4846,1439.9196,1181.9502,1198.1791,1141.9258,1268.9668,1290.1976,1145.9137,1228.0299,1294.393,1372.7124,1361.1476,1167.4061,1341.4917,1317.8229,1657.7762,2118.2676,2422.0068,2420.9944,2465.3796,2138.5981,1682.7959,1645.7467,1672.6776,1611.197,1278.9764,974.7691,1294.8853,1158.7554,945.21814,1027.9843,371.48724,-161.54883,-656.33276,-341.22125,182.87404,102.53276,-669.49384,-124.89328,-211.32127,-473.78915,-897.8546,-878.87787,-943.5849,-1234.3457,-1673.6602,-1840.5337,-1978.6755,-2043.3737,-2366.9355,-2374.1748,-2490.2283,-2447.447,-1940.191,365.20035,-623.0892,-1480.9197,-1234.7654,2353.4973,2274.8906,1992.7968,1286.7495,1587.9177,2171.41,1756.1804,1282.0935,1192.0128,1058.8866,1005.3332,945.54095,1030.9215,1105.6505,1045.2444,1134.8975,1196.8545,1073.5627,1161.0992,1159.0637,1180.1862,1850.1826,2443.8857,2629.6853,2491.386,2852.4683,2394.1191,1682.6265,1417.9963,1610.5876,1395.8115,1224.8501,986.129,781.64325,930.1395,878.85333,452.04083,-281.109,-1135.1279,-1490.4304,-1068.5769,-541.6679,-543.53577,-1225.5706,-1201.391,-1090.574,-1154.9474,-1564.0013,-1704.9928,-1670.8503,-1768.517,-1909.5798,-1977.0985,-2101.0415,-2218.1287,-2297.5803,-2619.1646,-2716.397,-2771.0574,-1659.6567,1465.6858,-818.01984,-1776.9476,-1384.9215,2279.2617,1937.3456,1887.3073,1343.5369,1436.6493,1929.9412,1525.2874,1327.8082,1165.8381,1291.443,1070.139,836.2929,861.04144,962.0539,888.16486,842.6274,773.0466,685.7135,851.1689,880.3676,824.45917,1147.1254,2328.3687,2523.1104,2747.2427,2446.4512,2129.686,1997.1439,1993.4393,1255.6748,654.493,-118.45104,453.38098,-163.64664,-587.5295,-75.55879,-516.38135,-1191.8652,-1340.8967,-1284.6765,-1115.4398,-1358.6003,-1631.2408,-1981.8745,-1952.9304,-1845.3372,-1990.001,-2101.6204,-2133.6128,-2059.42,-2144.0571,-2079.9304,-2074.5857,-2236.7578,-2479.3684,-2529.5566,-2616.8706,-2790.5867,-2888.302,-2343.412,-1493.4703,-2103.579,-1793.0465,-1521.6394,1906.4957,1653.3229,1823.8468,1273.1151,947.66046,1352.1351,1536.3142,1210.1265,1203.5519,1333.8365,970.6257,537.5731,446.29422,889.8948,774.1962,661.5832,397.3029,190.97841,133.66269,576.00665,728.07434,1071.2571,1795.0336,1832.2236,2131.5408,1803.774,1450.3851,1482.9716,1574.4457,1229.4368,494.7896,-759.83734,-550.60596,-1569.765,-2309.756,-1593.4001,-1328.5149,-2216.859,-1380.4498,-1207.6733,-1560.6587,-1703.8588,-1839.6508,-2112.1777,-2343.8843,-2310.5464,-2330.1682,-2280.0593,-2226.3164,-2308.8455,-2317.2937,-2252.9712,-2305.6243,-2504.9653,-2739.0132,-2678.407,-2586.6284,-2638.243,-2725.77,-2627.8367,-2604.8647,-2247.2869,-1961.2001,-1877.9554,1133.0083,1448.3538,1626.2003,1385.3073,1033.3523,1024.2239,1272.0115,1221.1315,1282.4882,1168.9017,581.80664,161.59154,106.30432,309.77182,38.677265,410.40027,229.58635,-290.92935,314.5661,800.13336,813.4742,1083.4146,1345.783,1782.9143,1713.8833,1520.1027,1316.111,1483.9578,1274.2484,633.10406,26.645061,-1713.5552,-1471.1252,-1947.5016,-3012.4368,-2053.648,-1664.5486,-1643.2711,-1522.8414,-1454.5997,-1975.5123,-1647.8848,-1798.65,-2279.9067,-2505.64,-2321.1375,-2082.9678,-2038.1177,-2288.6685,-2423.0447,-2503.5293,-2517.1013,-2624.9263,-2812.9402,-2934.492,-2856.8584,-2818.725,-2916.408,-2923.8972,-2945.9238,-2799.6995,-2533.9937,-2282.6458,-2074.0198,1044.68,762.8023,1472.9688,1074.179,1093.6564,974.67395,1274.3771,1435.133,1192.9332,1081.2277,345.45334,12.003916,-135.57144,183.06447,305.37338,-202.53078,-239.37624,-399.02432,156.33897,674.4862,997.9058,1330.2615,1459.5066,1588.6968,1433.8086,1390.4695,1190.376,1297.182,1138.3097,429.90857,-794.512,-2148.4568,-2058.694,-2377.5142,-2440.105,-2004.4846,-1932.5664,-2221.7126,-2068.6396,-1894.4141,-1841.8245,-1705.4514,-2085.9644,-2456.0522,-2456.1829,-2147.5647,-1960.9526,-2253.9448,-2619.0308,-2686.1611,-2739.3389,-2792.8325,-2860.6553,-2909.3816,-2949.808,-2967.7896,-2974.6965,-2998.215,-2916.7966,-2878.4048,-2856.1963,-2624.2595,-2395.3962,-2317.2463,449.49298,588.266,1000.60175,539.0421,413.38586,1019.6746,1203.4148,1108.2504,993.7385,770.9889,208.90259,-118.71605,-309.29843,-24.197018,-471.4153,-592.6089,-528.1956,-365.01562,374.36517,568.393,778.2576,1281.1263,1429.8866,1347.9336,957.0873,484.5618,224.66817,351.26434,91.86822,-1099.3942,-2078.9465,-2178.078,-2380.0527,-2263.4526,-2444.7205,-2325.3547,-2580.4685,-2680.922,-2314.3015,-2148.7827,-1992.7946,-2052.6763,-2440.767,-2394.0786,-2077.2075,-1836.6387,-2054.3882,-2513.3037,-2734.8994,-2802.4739,-2828.1428,-2868.4514,-2892.345,-2902.3748,-2939.4324,-2993.6477,-3014.9832,-2999.9968,-2871.943,-2842.9226,-2859.5168,-2730.7542,-2521.3064,-2393.2188,138.16336,327.78622,531.3893,285.44058,595.7413,655.81433,823.8323,413.4699,55.197727,234.05153,100.6901,-592.1725,-690.6465,-694.74194,-623.71747,-442.74185,-2.899528,126.97329,333.21686,453.13956,482.59622,915.5916,1122.8446,771.5239,405.4048,-153.73602,-642.964,-924.1827,-1173.0372,-1697.054,-2147.798,-2287.9958,-2568.0227,-2477.617,-2446.0208,-2468.2551,-2621.1575,-2611.2644,-2405.4465,-2108.4915,-2217.1208,-2457.7478,-2551.1692,-2356.4392,-2002.0121,-2038.209,-2286.4478,-2631.7605,-2728.481,-2802.9468,-2824.184,-2876.1746,-2900.5015,-2909.994,-2942.307,-2979.8193,-3005.235,-3002.4363,-2975.351,-2942.8364,-2932.7097,-2871.911,-2685.2139,-2539.6975],solid=False,xDimension=64,xSpacing=1.428571,yScale=50.0,zDimension=64,zSpacing=1.428571,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.01587,0.00391),(0.03175,0.00391),(0.04762,0.00391),(0.06349,0.00391),(0.07937,0.00391),(0.09524,0.00391),(0.11111,0.00391),(0.12698,0.00391),(0.14286,0.00391),(0.15873,0.00391),(0.1746,0.00391),(0.19048,0.00391),(0.20635,0.00391),(0.22222,0.00391),(0.2381,0.00391),(0.25397,0.00391),(0.26984,0.00391),(0.28571,0.00391),(0.30159,0.00391),(0.31746,0.00391),(0.33333,0.00391),(0.34921,0.00391),(0.36508,0.00391),(0.38095,0.00391),(0.39683,0.00391),(0.4127,0.00391),(0.42857,0.00391),(0.44444,0.00391),(0.46032,0.00391),(0.47619,0.00391),(0.49206,0.00391),(0.50794,0.00391),(0.52381,0.00391),(0.53968,0.00391),(0.55556,0.00391),(0.57143,0.00391),(0.5873,0.00391),(0.60317,0.00391),(0.61905,0.00391),(0.63492,0.00391),(0.65079,0.00391),(0.66667,0.00391),(0.68254,0.00391),(0.69841,0.00391),(0.71429,0.00391),(0.73016,0.00391),(0.74603,0.00391),(0.7619,0.00391),(0.77778,0.00391),(0.79365,0.00391),(0.80952,0.00391),(0.8254,0.00391),(0.84127,0.00391),(0.85714,0.00391),(0.87302,0.00391),(0.88889,0.00391),(0.90476,0.00391),(0.92063,0.00391),(0.93651,0.00391),(0.95238,0.00391),(0.96825,0.00391),(0.98413,0.00391),(0.99609,0.00391),(0.00391,0.01587),(0.01587,0.01587),(0.03175,0.01587),(0.04762,0.01587),(0.06349,0.01587),(0.07937,0.01587),(0.09524,0.01587),(0.11111,0.01587),(0.12698,0.01587),(0.14286,0.01587),(0.15873,0.01587),(0.1746,0.01587),(0.19048,0.01587),(0.20635,0.01587),(0.22222,0.01587),(0.2381,0.01587),(0.25397,0.01587),(0.26984,0.01587),(0.28571,0.01587),(0.30159,0.01587),(0.31746,0.01587),(0.33333,0.01587),(0.34921,0.01587),(0.36508,0.01587),(0.38095,0.01587),(0.39683,0.01587),(0.4127,0.01587),(0.42857,0.01587),(0.44444,0.01587),(0.46032,0.01587),(0.47619,0.01587),(0.49206,0.01587),(0.50794,0.01587),(0.52381,0.01587),(0.53968,0.01587),(0.55556,0.01587),(0.57143,0.01587),(0.5873,0.01587),(0.60317,0.01587),(0.61905,0.01587),(0.63492,0.01587),(0.65079,0.01587),(0.66667,0.01587),(0.68254,0.01587),(0.69841,0.01587),(0.71429,0.01587),(0.73016,0.01587),(0.74603,0.01587),(0.7619,0.01587),(0.77778,0.01587),(0.79365,0.01587),(0.80952,0.01587),(0.8254,0.01587),(0.84127,0.01587),(0.85714,0.01587),(0.87302,0.01587),(0.88889,0.01587),(0.90476,0.01587),(0.92063,0.01587),(0.93651,0.01587),(0.95238,0.01587),(0.96825,0.01587),(0.98413,0.01587),(0.99609,0.01587),(0.00391,0.03175),(0.01587,0.03175),(0.03175,0.03175),(0.04762,0.03175),(0.06349,0.03175),(0.07937,0.03175),(0.09524,0.03175),(0.11111,0.03175),(0.12698,0.03175),(0.14286,0.03175),(0.15873,0.03175),(0.1746,0.03175),(0.19048,0.03175),(0.20635,0.03175),(0.22222,0.03175),(0.2381,0.03175),(0.25397,0.03175),(0.26984,0.03175),(0.28571,0.03175),(0.30159,0.03175),(0.31746,0.03175),(0.33333,0.03175),(0.34921,0.03175),(0.36508,0.03175),(0.38095,0.03175),(0.39683,0.03175),(0.4127,0.03175),(0.42857,0.03175),(0.44444,0.03175),(0.46032,0.03175),(0.47619,0.03175),(0.49206,0.03175),(0.50794,0.03175),(0.52381,0.03175),(0.53968,0.03175),(0.55556,0.03175),(0.57143,0.03175),(0.5873,0.03175),(0.60317,0.03175),(0.61905,0.03175),(0.63492,0.03175),(0.65079,0.03175),(0.66667,0.03175),(0.68254,0.03175),(0.69841,0.03175),(0.71429,0.03175),(0.73016,0.03175),(0.74603,0.03175),(0.7619,0.03175),(0.77778,0.03175),(0.79365,0.03175),(0.80952,0.03175),(0.8254,0.03175),(0.84127,0.03175),(0.85714,0.03175),(0.87302,0.03175),(0.88889,0.03175),(0.90476,0.03175),(0.92063,0.03175),(0.93651,0.03175),(0.95238,0.03175),(0.96825,0.03175),(0.98413,0.03175),(0.99609,0.03175),(0.00391,0.04762),(0.01587,0.04762),(0.03175,0.04762),(0.04762,0.04762),(0.06349,0.04762),(0.07937,0.04762),(0.09524,0.04762),(0.11111,0.04762),(0.12698,0.04762),(0.14286,0.04762),(0.15873,0.04762),(0.1746,0.04762),(0.19048,0.04762),(0.20635,0.04762),(0.22222,0.04762),(0.2381,0.04762),(0.25397,0.04762),(0.26984,0.04762),(0.28571,0.04762),(0.30159,0.04762),(0.31746,0.04762),(0.33333,0.04762),(0.34921,0.04762),(0.36508,0.04762),(0.38095,0.04762),(0.39683,0.04762),(0.4127,0.04762),(0.42857,0.04762),(0.44444,0.04762),(0.46032,0.04762),(0.47619,0.04762),(0.49206,0.04762),(0.50794,0.04762),(0.52381,0.04762),(0.53968,0.04762),(0.55556,0.04762),(0.57143,0.04762),(0.5873,0.04762),(0.60317,0.04762),(0.61905,0.04762),(0.63492,0.04762),(0.65079,0.04762),(0.66667,0.04762),(0.68254,0.04762),(0.69841,0.04762),(0.71429,0.04762),(0.73016,0.04762),(0.74603,0.04762),(0.7619,0.04762),(0.77778,0.04762),(0.79365,0.04762),(0.80952,0.04762),(0.8254,0.04762),(0.84127,0.04762),(0.85714,0.04762),(0.87302,0.04762),(0.88889,0.04762),(0.90476,0.04762),(0.92063,0.04762),(0.93651,0.04762),(0.95238,0.04762),(0.96825,0.04762),(0.98413,0.04762),(0.99609,0.04762),(0.00391,0.06349),(0.01587,0.06349),(0.03175,0.06349),(0.04762,0.06349),(0.06349,0.06349),(0.07937,0.06349),(0.09524,0.06349),(0.11111,0.06349),(0.12698,0.06349),(0.14286,0.06349),(0.15873,0.06349),(0.1746,0.06349),(0.19048,0.06349),(0.20635,0.06349),(0.22222,0.06349),(0.2381,0.06349),(0.25397,0.06349),(0.26984,0.06349),(0.28571,0.06349),(0.30159,0.06349),(0.31746,0.06349),(0.33333,0.06349),(0.34921,0.06349),(0.36508,0.06349),(0.38095,0.06349),(0.39683,0.06349),(0.4127,0.06349),(0.42857,0.06349),(0.44444,0.06349),(0.46032,0.06349),(0.47619,0.06349),(0.49206,0.06349),(0.50794,0.06349),(0.52381,0.06349),(0.53968,0.06349),(0.55556,0.06349),(0.57143,0.06349),(0.5873,0.06349),(0.60317,0.06349),(0.61905,0.06349),(0.63492,0.06349),(0.65079,0.06349),(0.66667,0.06349),(0.68254,0.06349),(0.69841,0.06349),(0.71429,0.06349),(0.73016,0.06349),(0.74603,0.06349),(0.7619,0.06349),(0.77778,0.06349),(0.79365,0.06349),(0.80952,0.06349),(0.8254,0.06349),(0.84127,0.06349),(0.85714,0.06349),(0.87302,0.06349),(0.88889,0.06349),(0.90476,0.06349),(0.92063,0.06349),(0.93651,0.06349),(0.95238,0.06349),(0.96825,0.06349),(0.98413,0.06349),(0.99609,0.06349),(0.00391,0.07937),(0.01587,0.07937),(0.03175,0.07937),(0.04762,0.07937),(0.06349,0.07937),(0.07937,0.07937),(0.09524,0.07937),(0.11111,0.07937),(0.12698,0.07937),(0.14286,0.07937),(0.15873,0.07937),(0.1746,0.07937),(0.19048,0.07937),(0.20635,0.07937),(0.22222,0.07937),(0.2381,0.07937),(0.25397,0.07937),(0.26984,0.07937),(0.28571,0.07937),(0.30159,0.07937),(0.31746,0.07937),(0.33333,0.07937),(0.34921,0.07937),(0.36508,0.07937),(0.38095,0.07937),(0.39683,0.07937),(0.4127,0.07937),(0.42857,0.07937),(0.44444,0.07937),(0.46032,0.07937),(0.47619,0.07937),(0.49206,0.07937),(0.50794,0.07937),(0.52381,0.07937),(0.53968,0.07937),(0.55556,0.07937),(0.57143,0.07937),(0.5873,0.07937),(0.60317,0.07937),(0.61905,0.07937),(0.63492,0.07937),(0.65079,0.07937),(0.66667,0.07937),(0.68254,0.07937),(0.69841,0.07937),(0.71429,0.07937),(0.73016,0.07937),(0.74603,0.07937),(0.7619,0.07937),(0.77778,0.07937),(0.79365,0.07937),(0.80952,0.07937),(0.8254,0.07937),(0.84127,0.07937),(0.85714,0.07937),(0.87302,0.07937),(0.88889,0.07937),(0.90476,0.07937),(0.92063,0.07937),(0.93651,0.07937),(0.95238,0.07937),(0.96825,0.07937),(0.98413,0.07937),(0.99609,0.07937),(0.00391,0.09524),(0.01587,0.09524),(0.03175,0.09524),(0.04762,0.09524),(0.06349,0.09524),(0.07937,0.09524),(0.09524,0.09524),(0.11111,0.09524),(0.12698,0.09524),(0.14286,0.09524),(0.15873,0.09524),(0.1746,0.09524),(0.19048,0.09524),(0.20635,0.09524),(0.22222,0.09524),(0.2381,0.09524),(0.25397,0.09524),(0.26984,0.09524),(0.28571,0.09524),(0.30159,0.09524),(0.31746,0.09524),(0.33333,0.09524),(0.34921,0.09524),(0.36508,0.09524),(0.38095,0.09524),(0.39683,0.09524),(0.4127,0.09524),(0.42857,0.09524),(0.44444,0.09524),(0.46032,0.09524),(0.47619,0.09524),(0.49206,0.09524),(0.50794,0.09524),(0.52381,0.09524),(0.53968,0.09524),(0.55556,0.09524),(0.57143,0.09524),(0.5873,0.09524),(0.60317,0.09524),(0.61905,0.09524),(0.63492,0.09524),(0.65079,0.09524),(0.66667,0.09524),(0.68254,0.09524),(0.69841,0.09524),(0.71429,0.09524),(0.73016,0.09524),(0.74603,0.09524),(0.7619,0.09524),(0.77778,0.09524),(0.79365,0.09524),(0.80952,0.09524),(0.8254,0.09524),(0.84127,0.09524),(0.85714,0.09524),(0.87302,0.09524),(0.88889,0.09524),(0.90476,0.09524),(0.92063,0.09524),(0.93651,0.09524),(0.95238,0.09524),(0.96825,0.09524),(0.98413,0.09524),(0.99609,0.09524),(0.00391,0.11111),(0.01587,0.11111),(0.03175,0.11111),(0.04762,0.11111),(0.06349,0.11111),(0.07937,0.11111),(0.09524,0.11111),(0.11111,0.11111),(0.12698,0.11111),(0.14286,0.11111),(0.15873,0.11111),(0.1746,0.11111),(0.19048,0.11111),(0.20635,0.11111),(0.22222,0.11111),(0.2381,0.11111),(0.25397,0.11111),(0.26984,0.11111),(0.28571,0.11111),(0.30159,0.11111),(0.31746,0.11111),(0.33333,0.11111),(0.34921,0.11111),(0.36508,0.11111),(0.38095,0.11111),(0.39683,0.11111),(0.4127,0.11111),(0.42857,0.11111),(0.44444,0.11111),(0.46032,0.11111),(0.47619,0.11111),(0.49206,0.11111),(0.50794,0.11111),(0.52381,0.11111),(0.53968,0.11111),(0.55556,0.11111),(0.57143,0.11111),(0.5873,0.11111),(0.60317,0.11111),(0.61905,0.11111),(0.63492,0.11111),(0.65079,0.11111),(0.66667,0.11111),(0.68254,0.11111),(0.69841,0.11111),(0.71429,0.11111),(0.73016,0.11111),(0.74603,0.11111),(0.7619,0.11111),(0.77778,0.11111),(0.79365,0.11111),(0.80952,0.11111),(0.8254,0.11111),(0.84127,0.11111),(0.85714,0.11111),(0.87302,0.11111),(0.88889,0.11111),(0.90476,0.11111),(0.92063,0.11111),(0.93651,0.11111),(0.95238,0.11111),(0.96825,0.11111),(0.98413,0.11111),(0.99609,0.11111),(0.00391,0.12698),(0.01587,0.12698),(0.03175,0.12698),(0.04762,0.12698),(0.06349,0.12698),(0.07937,0.12698),(0.09524,0.12698),(0.11111,0.12698),(0.12698,0.12698),(0.14286,0.12698),(0.15873,0.12698),(0.1746,0.12698),(0.19048,0.12698),(0.20635,0.12698),(0.22222,0.12698),(0.2381,0.12698),(0.25397,0.12698),(0.26984,0.12698),(0.28571,0.12698),(0.30159,0.12698),(0.31746,0.12698),(0.33333,0.12698),(0.34921,0.12698),(0.36508,0.12698),(0.38095,0.12698),(0.39683,0.12698),(0.4127,0.12698),(0.42857,0.12698),(0.44444,0.12698),(0.46032,0.12698),(0.47619,0.12698),(0.49206,0.12698),(0.50794,0.12698),(0.52381,0.12698),(0.53968,0.12698),(0.55556,0.12698),(0.57143,0.12698),(0.5873,0.12698),(0.60317,0.12698),(0.61905,0.12698),(0.63492,0.12698),(0.65079,0.12698),(0.66667,0.12698),(0.68254,0.12698),(0.69841,0.12698),(0.71429,0.12698),(0.73016,0.12698),(0.74603,0.12698),(0.7619,0.12698),(0.77778,0.12698),(0.79365,0.12698),(0.80952,0.12698),(0.8254,0.12698),(0.84127,0.12698),(0.85714,0.12698),(0.87302,0.12698),(0.88889,0.12698),(0.90476,0.12698),(0.92063,0.12698),(0.93651,0.12698),(0.95238,0.12698),(0.96825,0.12698),(0.98413,0.12698),(0.99609,0.12698),(0.00391,0.14286),(0.01587,0.14286),(0.03175,0.14286),(0.04762,0.14286),(0.06349,0.14286),(0.07937,0.14286),(0.09524,0.14286),(0.11111,0.14286),(0.12698,0.14286),(0.14286,0.14286),(0.15873,0.14286),(0.1746,0.14286),(0.19048,0.14286),(0.20635,0.14286),(0.22222,0.14286),(0.2381,0.14286),(0.25397,0.14286),(0.26984,0.14286),(0.28571,0.14286),(0.30159,0.14286),(0.31746,0.14286),(0.33333,0.14286),(0.34921,0.14286),(0.36508,0.14286),(0.38095,0.14286),(0.39683,0.14286),(0.4127,0.14286),(0.42857,0.14286),(0.44444,0.14286),(0.46032,0.14286),(0.47619,0.14286),(0.49206,0.14286),(0.50794,0.14286),(0.52381,0.14286),(0.53968,0.14286),(0.55556,0.14286),(0.57143,0.14286),(0.5873,0.14286),(0.60317,0.14286),(0.61905,0.14286),(0.63492,0.14286),(0.65079,0.14286),(0.66667,0.14286),(0.68254,0.14286),(0.69841,0.14286),(0.71429,0.14286),(0.73016,0.14286),(0.74603,0.14286),(0.7619,0.14286),(0.77778,0.14286),(0.79365,0.14286),(0.80952,0.14286),(0.8254,0.14286),(0.84127,0.14286),(0.85714,0.14286),(0.87302,0.14286),(0.88889,0.14286),(0.90476,0.14286),(0.92063,0.14286),(0.93651,0.14286),(0.95238,0.14286),(0.96825,0.14286),(0.98413,0.14286),(0.99609,0.14286),(0.00391,0.15873),(0.01587,0.15873),(0.03175,0.15873),(0.04762,0.15873),(0.06349,0.15873),(0.07937,0.15873),(0.09524,0.15873),(0.11111,0.15873),(0.12698,0.15873),(0.14286,0.15873),(0.15873,0.15873),(0.1746,0.15873),(0.19048,0.15873),(0.20635,0.15873),(0.22222,0.15873),(0.2381,0.15873),(0.25397,0.15873),(0.26984,0.15873),(0.28571,0.15873),(0.30159,0.15873),(0.31746,0.15873),(0.33333,0.15873),(0.34921,0.15873),(0.36508,0.15873),(0.38095,0.15873),(0.39683,0.15873),(0.4127,0.15873),(0.42857,0.15873),(0.44444,0.15873),(0.46032,0.15873),(0.47619,0.15873),(0.49206,0.15873),(0.50794,0.15873),(0.52381,0.15873),(0.53968,0.15873),(0.55556,0.15873),(0.57143,0.15873),(0.5873,0.15873),(0.60317,0.15873),(0.61905,0.15873),(0.63492,0.15873),(0.65079,0.15873),(0.66667,0.15873),(0.68254,0.15873),(0.69841,0.15873),(0.71429,0.15873),(0.73016,0.15873),(0.74603,0.15873),(0.7619,0.15873),(0.77778,0.15873),(0.79365,0.15873),(0.80952,0.15873),(0.8254,0.15873),(0.84127,0.15873),(0.85714,0.15873),(0.87302,0.15873),(0.88889,0.15873),(0.90476,0.15873),(0.92063,0.15873),(0.93651,0.15873),(0.95238,0.15873),(0.96825,0.15873),(0.98413,0.15873),(0.99609,0.15873),(0.00391,0.1746),(0.01587,0.1746),(0.03175,0.1746),(0.04762,0.1746),(0.06349,0.1746),(0.07937,0.1746),(0.09524,0.1746),(0.11111,0.1746),(0.12698,0.1746),(0.14286,0.1746),(0.15873,0.1746),(0.1746,0.1746),(0.19048,0.1746),(0.20635,0.1746),(0.22222,0.1746),(0.2381,0.1746),(0.25397,0.1746),(0.26984,0.1746),(0.28571,0.1746),(0.30159,0.1746),(0.31746,0.1746),(0.33333,0.1746),(0.34921,0.1746),(0.36508,0.1746),(0.38095,0.1746),(0.39683,0.1746),(0.4127,0.1746),(0.42857,0.1746),(0.44444,0.1746),(0.46032,0.1746),(0.47619,0.1746),(0.49206,0.1746),(0.50794,0.1746),(0.52381,0.1746),(0.53968,0.1746),(0.55556,0.1746),(0.57143,0.1746),(0.5873,0.1746),(0.60317,0.1746),(0.61905,0.1746),(0.63492,0.1746),(0.65079,0.1746),(0.66667,0.1746),(0.68254,0.1746),(0.69841,0.1746),(0.71429,0.1746),(0.73016,0.1746),(0.74603,0.1746),(0.7619,0.1746),(0.77778,0.1746),(0.79365,0.1746),(0.80952,0.1746),(0.8254,0.1746),(0.84127,0.1746),(0.85714,0.1746),(0.87302,0.1746),(0.88889,0.1746),(0.90476,0.1746),(0.92063,0.1746),(0.93651,0.1746),(0.95238,0.1746),(0.96825,0.1746),(0.98413,0.1746),(0.99609,0.1746),(0.00391,0.19048),(0.01587,0.19048),(0.03175,0.19048),(0.04762,0.19048),(0.06349,0.19048),(0.07937,0.19048),(0.09524,0.19048),(0.11111,0.19048),(0.12698,0.19048),(0.14286,0.19048),(0.15873,0.19048),(0.1746,0.19048),(0.19048,0.19048),(0.20635,0.19048),(0.22222,0.19048),(0.2381,0.19048),(0.25397,0.19048),(0.26984,0.19048),(0.28571,0.19048),(0.30159,0.19048),(0.31746,0.19048),(0.33333,0.19048),(0.34921,0.19048),(0.36508,0.19048),(0.38095,0.19048),(0.39683,0.19048),(0.4127,0.19048),(0.42857,0.19048),(0.44444,0.19048),(0.46032,0.19048),(0.47619,0.19048),(0.49206,0.19048),(0.50794,0.19048),(0.52381,0.19048),(0.53968,0.19048),(0.55556,0.19048),(0.57143,0.19048),(0.5873,0.19048),(0.60317,0.19048),(0.61905,0.19048),(0.63492,0.19048),(0.65079,0.19048),(0.66667,0.19048),(0.68254,0.19048),(0.69841,0.19048),(0.71429,0.19048),(0.73016,0.19048),(0.74603,0.19048),(0.7619,0.19048),(0.77778,0.19048),(0.79365,0.19048),(0.80952,0.19048),(0.8254,0.19048),(0.84127,0.19048),(0.85714,0.19048),(0.87302,0.19048),(0.88889,0.19048),(0.90476,0.19048),(0.92063,0.19048),(0.93651,0.19048),(0.95238,0.19048),(0.96825,0.19048),(0.98413,0.19048),(0.99609,0.19048),(0.00391,0.20635),(0.01587,0.20635),(0.03175,0.20635),(0.04762,0.20635),(0.06349,0.20635),(0.07937,0.20635),(0.09524,0.20635),(0.11111,0.20635),(0.12698,0.20635),(0.14286,0.20635),(0.15873,0.20635),(0.1746,0.20635),(0.19048,0.20635),(0.20635,0.20635),(0.22222,0.20635),(0.2381,0.20635),(0.25397,0.20635),(0.26984,0.20635),(0.28571,0.20635),(0.30159,0.20635),(0.31746,0.20635),(0.33333,0.20635),(0.34921,0.20635),(0.36508,0.20635),(0.38095,0.20635),(0.39683,0.20635),(0.4127,0.20635),(0.42857,0.20635),(0.44444,0.20635),(0.46032,0.20635),(0.47619,0.20635),(0.49206,0.20635),(0.50794,0.20635),(0.52381,0.20635),(0.53968,0.20635),(0.55556,0.20635),(0.57143,0.20635),(0.5873,0.20635),(0.60317,0.20635),(0.61905,0.20635),(0.63492,0.20635),(0.65079,0.20635),(0.66667,0.20635),(0.68254,0.20635),(0.69841,0.20635),(0.71429,0.20635),(0.73016,0.20635),(0.74603,0.20635),(0.7619,0.20635),(0.77778,0.20635),(0.79365,0.20635),(0.80952,0.20635),(0.8254,0.20635),(0.84127,0.20635),(0.85714,0.20635),(0.87302,0.20635),(0.88889,0.20635),(0.90476,0.20635),(0.92063,0.20635),(0.93651,0.20635),(0.95238,0.20635),(0.96825,0.20635),(0.98413,0.20635),(0.99609,0.20635),(0.00391,0.22222),(0.01587,0.22222),(0.03175,0.22222),(0.04762,0.22222),(0.06349,0.22222),(0.07937,0.22222),(0.09524,0.22222),(0.11111,0.22222),(0.12698,0.22222),(0.14286,0.22222),(0.15873,0.22222),(0.1746,0.22222),(0.19048,0.22222),(0.20635,0.22222),(0.22222,0.22222),(0.2381,0.22222),(0.25397,0.22222),(0.26984,0.22222),(0.28571,0.22222),(0.30159,0.22222),(0.31746,0.22222),(0.33333,0.22222),(0.34921,0.22222),(0.36508,0.22222),(0.38095,0.22222),(0.39683,0.22222),(0.4127,0.22222),(0.42857,0.22222),(0.44444,0.22222),(0.46032,0.22222),(0.47619,0.22222),(0.49206,0.22222),(0.50794,0.22222),(0.52381,0.22222),(0.53968,0.22222),(0.55556,0.22222),(0.57143,0.22222),(0.5873,0.22222),(0.60317,0.22222),(0.61905,0.22222),(0.63492,0.22222),(0.65079,0.22222),(0.66667,0.22222),(0.68254,0.22222),(0.69841,0.22222),(0.71429,0.22222),(0.73016,0.22222),(0.74603,0.22222),(0.7619,0.22222),(0.77778,0.22222),(0.79365,0.22222),(0.80952,0.22222),(0.8254,0.22222),(0.84127,0.22222),(0.85714,0.22222),(0.87302,0.22222),(0.88889,0.22222),(0.90476,0.22222),(0.92063,0.22222),(0.93651,0.22222),(0.95238,0.22222),(0.96825,0.22222),(0.98413,0.22222),(0.99609,0.22222),(0.00391,0.2381),(0.01587,0.2381),(0.03175,0.2381),(0.04762,0.2381),(0.06349,0.2381),(0.07937,0.2381),(0.09524,0.2381),(0.11111,0.2381),(0.12698,0.2381),(0.14286,0.2381),(0.15873,0.2381),(0.1746,0.2381),(0.19048,0.2381),(0.20635,0.2381),(0.22222,0.2381),(0.2381,0.2381),(0.25397,0.2381),(0.26984,0.2381),(0.28571,0.2381),(0.30159,0.2381),(0.31746,0.2381),(0.33333,0.2381),(0.34921,0.2381),(0.36508,0.2381),(0.38095,0.2381),(0.39683,0.2381),(0.4127,0.2381),(0.42857,0.2381),(0.44444,0.2381),(0.46032,0.2381),(0.47619,0.2381),(0.49206,0.2381),(0.50794,0.2381),(0.52381,0.2381),(0.53968,0.2381),(0.55556,0.2381),(0.57143,0.2381),(0.5873,0.2381),(0.60317,0.2381),(0.61905,0.2381),(0.63492,0.2381),(0.65079,0.2381),(0.66667,0.2381),(0.68254,0.2381),(0.69841,0.2381),(0.71429,0.2381),(0.73016,0.2381),(0.74603,0.2381),(0.7619,0.2381),(0.77778,0.2381),(0.79365,0.2381),(0.80952,0.2381),(0.8254,0.2381),(0.84127,0.2381),(0.85714,0.2381),(0.87302,0.2381),(0.88889,0.2381),(0.90476,0.2381),(0.92063,0.2381),(0.93651,0.2381),(0.95238,0.2381),(0.96825,0.2381),(0.98413,0.2381),(0.99609,0.2381),(0.00391,0.25397),(0.01587,0.25397),(0.03175,0.25397),(0.04762,0.25397),(0.06349,0.25397),(0.07937,0.25397),(0.09524,0.25397),(0.11111,0.25397),(0.12698,0.25397),(0.14286,0.25397),(0.15873,0.25397),(0.1746,0.25397),(0.19048,0.25397),(0.20635,0.25397),(0.22222,0.25397),(0.2381,0.25397),(0.25397,0.25397),(0.26984,0.25397),(0.28571,0.25397),(0.30159,0.25397),(0.31746,0.25397),(0.33333,0.25397),(0.34921,0.25397),(0.36508,0.25397),(0.38095,0.25397),(0.39683,0.25397),(0.4127,0.25397),(0.42857,0.25397),(0.44444,0.25397),(0.46032,0.25397),(0.47619,0.25397),(0.49206,0.25397),(0.50794,0.25397),(0.52381,0.25397),(0.53968,0.25397),(0.55556,0.25397),(0.57143,0.25397),(0.5873,0.25397),(0.60317,0.25397),(0.61905,0.25397),(0.63492,0.25397),(0.65079,0.25397),(0.66667,0.25397),(0.68254,0.25397),(0.69841,0.25397),(0.71429,0.25397),(0.73016,0.25397),(0.74603,0.25397),(0.7619,0.25397),(0.77778,0.25397),(0.79365,0.25397),(0.80952,0.25397),(0.8254,0.25397),(0.84127,0.25397),(0.85714,0.25397),(0.87302,0.25397),(0.88889,0.25397),(0.90476,0.25397),(0.92063,0.25397),(0.93651,0.25397),(0.95238,0.25397),(0.96825,0.25397),(0.98413,0.25397),(0.99609,0.25397),(0.00391,0.26984),(0.01587,0.26984),(0.03175,0.26984),(0.04762,0.26984),(0.06349,0.26984),(0.07937,0.26984),(0.09524,0.26984),(0.11111,0.26984),(0.12698,0.26984),(0.14286,0.26984),(0.15873,0.26984),(0.1746,0.26984),(0.19048,0.26984),(0.20635,0.26984),(0.22222,0.26984),(0.2381,0.26984),(0.25397,0.26984),(0.26984,0.26984),(0.28571,0.26984),(0.30159,0.26984),(0.31746,0.26984),(0.33333,0.26984),(0.34921,0.26984),(0.36508,0.26984),(0.38095,0.26984),(0.39683,0.26984),(0.4127,0.26984),(0.42857,0.26984),(0.44444,0.26984),(0.46032,0.26984),(0.47619,0.26984),(0.49206,0.26984),(0.50794,0.26984),(0.52381,0.26984),(0.53968,0.26984),(0.55556,0.26984),(0.57143,0.26984),(0.5873,0.26984),(0.60317,0.26984),(0.61905,0.26984),(0.63492,0.26984),(0.65079,0.26984),(0.66667,0.26984),(0.68254,0.26984),(0.69841,0.26984),(0.71429,0.26984),(0.73016,0.26984),(0.74603,0.26984),(0.7619,0.26984),(0.77778,0.26984),(0.79365,0.26984),(0.80952,0.26984),(0.8254,0.26984),(0.84127,0.26984),(0.85714,0.26984),(0.87302,0.26984),(0.88889,0.26984),(0.90476,0.26984),(0.92063,0.26984),(0.93651,0.26984),(0.95238,0.26984),(0.96825,0.26984),(0.98413,0.26984),(0.99609,0.26984),(0.00391,0.28571),(0.01587,0.28571),(0.03175,0.28571),(0.04762,0.28571),(0.06349,0.28571),(0.07937,0.28571),(0.09524,0.28571),(0.11111,0.28571),(0.12698,0.28571),(0.14286,0.28571),(0.15873,0.28571),(0.1746,0.28571),(0.19048,0.28571),(0.20635,0.28571),(0.22222,0.28571),(0.2381,0.28571),(0.25397,0.28571),(0.26984,0.28571),(0.28571,0.28571),(0.30159,0.28571),(0.31746,0.28571),(0.33333,0.28571),(0.34921,0.28571),(0.36508,0.28571),(0.38095,0.28571),(0.39683,0.28571),(0.4127,0.28571),(0.42857,0.28571),(0.44444,0.28571),(0.46032,0.28571),(0.47619,0.28571),(0.49206,0.28571),(0.50794,0.28571),(0.52381,0.28571),(0.53968,0.28571),(0.55556,0.28571),(0.57143,0.28571),(0.5873,0.28571),(0.60317,0.28571),(0.61905,0.28571),(0.63492,0.28571),(0.65079,0.28571),(0.66667,0.28571),(0.68254,0.28571),(0.69841,0.28571),(0.71429,0.28571),(0.73016,0.28571),(0.74603,0.28571),(0.7619,0.28571),(0.77778,0.28571),(0.79365,0.28571),(0.80952,0.28571),(0.8254,0.28571),(0.84127,0.28571),(0.85714,0.28571),(0.87302,0.28571),(0.88889,0.28571),(0.90476,0.28571),(0.92063,0.28571),(0.93651,0.28571),(0.95238,0.28571),(0.96825,0.28571),(0.98413,0.28571),(0.99609,0.28571),(0.00391,0.30159),(0.01587,0.30159),(0.03175,0.30159),(0.04762,0.30159),(0.06349,0.30159),(0.07937,0.30159),(0.09524,0.30159),(0.11111,0.30159),(0.12698,0.30159),(0.14286,0.30159),(0.15873,0.30159),(0.1746,0.30159),(0.19048,0.30159),(0.20635,0.30159),(0.22222,0.30159),(0.2381,0.30159),(0.25397,0.30159),(0.26984,0.30159),(0.28571,0.30159),(0.30159,0.30159),(0.31746,0.30159),(0.33333,0.30159),(0.34921,0.30159),(0.36508,0.30159),(0.38095,0.30159),(0.39683,0.30159),(0.4127,0.30159),(0.42857,0.30159),(0.44444,0.30159),(0.46032,0.30159),(0.47619,0.30159),(0.49206,0.30159),(0.50794,0.30159),(0.52381,0.30159),(0.53968,0.30159),(0.55556,0.30159),(0.57143,0.30159),(0.5873,0.30159),(0.60317,0.30159),(0.61905,0.30159),(0.63492,0.30159),(0.65079,0.30159),(0.66667,0.30159),(0.68254,0.30159),(0.69841,0.30159),(0.71429,0.30159),(0.73016,0.30159),(0.74603,0.30159),(0.7619,0.30159),(0.77778,0.30159),(0.79365,0.30159),(0.80952,0.30159),(0.8254,0.30159),(0.84127,0.30159),(0.85714,0.30159),(0.87302,0.30159),(0.88889,0.30159),(0.90476,0.30159),(0.92063,0.30159),(0.93651,0.30159),(0.95238,0.30159),(0.96825,0.30159),(0.98413,0.30159),(0.99609,0.30159),(0.00391,0.31746),(0.01587,0.31746),(0.03175,0.31746),(0.04762,0.31746),(0.06349,0.31746),(0.07937,0.31746),(0.09524,0.31746),(0.11111,0.31746),(0.12698,0.31746),(0.14286,0.31746),(0.15873,0.31746),(0.1746,0.31746),(0.19048,0.31746),(0.20635,0.31746),(0.22222,0.31746),(0.2381,0.31746),(0.25397,0.31746),(0.26984,0.31746),(0.28571,0.31746),(0.30159,0.31746),(0.31746,0.31746),(0.33333,0.31746),(0.34921,0.31746),(0.36508,0.31746),(0.38095,0.31746),(0.39683,0.31746),(0.4127,0.31746),(0.42857,0.31746),(0.44444,0.31746),(0.46032,0.31746),(0.47619,0.31746),(0.49206,0.31746),(0.50794,0.31746),(0.52381,0.31746),(0.53968,0.31746),(0.55556,0.31746),(0.57143,0.31746),(0.5873,0.31746),(0.60317,0.31746),(0.61905,0.31746),(0.63492,0.31746),(0.65079,0.31746),(0.66667,0.31746),(0.68254,0.31746),(0.69841,0.31746),(0.71429,0.31746),(0.73016,0.31746),(0.74603,0.31746),(0.7619,0.31746),(0.77778,0.31746),(0.79365,0.31746),(0.80952,0.31746),(0.8254,0.31746),(0.84127,0.31746),(0.85714,0.31746),(0.87302,0.31746),(0.88889,0.31746),(0.90476,0.31746),(0.92063,0.31746),(0.93651,0.31746),(0.95238,0.31746),(0.96825,0.31746),(0.98413,0.31746),(0.99609,0.31746),(0.00391,0.33333),(0.01587,0.33333),(0.03175,0.33333),(0.04762,0.33333),(0.06349,0.33333),(0.07937,0.33333),(0.09524,0.33333),(0.11111,0.33333),(0.12698,0.33333),(0.14286,0.33333),(0.15873,0.33333),(0.1746,0.33333),(0.19048,0.33333),(0.20635,0.33333),(0.22222,0.33333),(0.2381,0.33333),(0.25397,0.33333),(0.26984,0.33333),(0.28571,0.33333),(0.30159,0.33333),(0.31746,0.33333),(0.33333,0.33333),(0.34921,0.33333),(0.36508,0.33333),(0.38095,0.33333),(0.39683,0.33333),(0.4127,0.33333),(0.42857,0.33333),(0.44444,0.33333),(0.46032,0.33333),(0.47619,0.33333),(0.49206,0.33333),(0.50794,0.33333),(0.52381,0.33333),(0.53968,0.33333),(0.55556,0.33333),(0.57143,0.33333),(0.5873,0.33333),(0.60317,0.33333),(0.61905,0.33333),(0.63492,0.33333),(0.65079,0.33333),(0.66667,0.33333),(0.68254,0.33333),(0.69841,0.33333),(0.71429,0.33333),(0.73016,0.33333),(0.74603,0.33333),(0.7619,0.33333),(0.77778,0.33333),(0.79365,0.33333),(0.80952,0.33333),(0.8254,0.33333),(0.84127,0.33333),(0.85714,0.33333),(0.87302,0.33333),(0.88889,0.33333),(0.90476,0.33333),(0.92063,0.33333),(0.93651,0.33333),(0.95238,0.33333),(0.96825,0.33333),(0.98413,0.33333),(0.99609,0.33333),(0.00391,0.34921),(0.01587,0.34921),(0.03175,0.34921),(0.04762,0.34921),(0.06349,0.34921),(0.07937,0.34921),(0.09524,0.34921),(0.11111,0.34921),(0.12698,0.34921),(0.14286,0.34921),(0.15873,0.34921),(0.1746,0.34921),(0.19048,0.34921),(0.20635,0.34921),(0.22222,0.34921),(0.2381,0.34921),(0.25397,0.34921),(0.26984,0.34921),(0.28571,0.34921),(0.30159,0.34921),(0.31746,0.34921),(0.33333,0.34921),(0.34921,0.34921),(0.36508,0.34921),(0.38095,0.34921),(0.39683,0.34921),(0.4127,0.34921),(0.42857,0.34921),(0.44444,0.34921),(0.46032,0.34921),(0.47619,0.34921),(0.49206,0.34921),(0.50794,0.34921),(0.52381,0.34921),(0.53968,0.34921),(0.55556,0.34921),(0.57143,0.34921),(0.5873,0.34921),(0.60317,0.34921),(0.61905,0.34921),(0.63492,0.34921),(0.65079,0.34921),(0.66667,0.34921),(0.68254,0.34921),(0.69841,0.34921),(0.71429,0.34921),(0.73016,0.34921),(0.74603,0.34921),(0.7619,0.34921),(0.77778,0.34921),(0.79365,0.34921),(0.80952,0.34921),(0.8254,0.34921),(0.84127,0.34921),(0.85714,0.34921),(0.87302,0.34921),(0.88889,0.34921),(0.90476,0.34921),(0.92063,0.34921),(0.93651,0.34921),(0.95238,0.34921),(0.96825,0.34921),(0.98413,0.34921),(0.99609,0.34921),(0.00391,0.36508),(0.01587,0.36508),(0.03175,0.36508),(0.04762,0.36508),(0.06349,0.36508),(0.07937,0.36508),(0.09524,0.36508),(0.11111,0.36508),(0.12698,0.36508),(0.14286,0.36508),(0.15873,0.36508),(0.1746,0.36508),(0.19048,0.36508),(0.20635,0.36508),(0.22222,0.36508),(0.2381,0.36508),(0.25397,0.36508),(0.26984,0.36508),(0.28571,0.36508),(0.30159,0.36508),(0.31746,0.36508),(0.33333,0.36508),(0.34921,0.36508),(0.36508,0.36508),(0.38095,0.36508),(0.39683,0.36508),(0.4127,0.36508),(0.42857,0.36508),(0.44444,0.36508),(0.46032,0.36508),(0.47619,0.36508),(0.49206,0.36508),(0.50794,0.36508),(0.52381,0.36508),(0.53968,0.36508),(0.55556,0.36508),(0.57143,0.36508),(0.5873,0.36508),(0.60317,0.36508),(0.61905,0.36508),(0.63492,0.36508),(0.65079,0.36508),(0.66667,0.36508),(0.68254,0.36508),(0.69841,0.36508),(0.71429,0.36508),(0.73016,0.36508),(0.74603,0.36508),(0.7619,0.36508),(0.77778,0.36508),(0.79365,0.36508),(0.80952,0.36508),(0.8254,0.36508),(0.84127,0.36508),(0.85714,0.36508),(0.87302,0.36508),(0.88889,0.36508),(0.90476,0.36508),(0.92063,0.36508),(0.93651,0.36508),(0.95238,0.36508),(0.96825,0.36508),(0.98413,0.36508),(0.99609,0.36508),(0.00391,0.38095),(0.01587,0.38095),(0.03175,0.38095),(0.04762,0.38095),(0.06349,0.38095),(0.07937,0.38095),(0.09524,0.38095),(0.11111,0.38095),(0.12698,0.38095),(0.14286,0.38095),(0.15873,0.38095),(0.1746,0.38095),(0.19048,0.38095),(0.20635,0.38095),(0.22222,0.38095),(0.2381,0.38095),(0.25397,0.38095),(0.26984,0.38095),(0.28571,0.38095),(0.30159,0.38095),(0.31746,0.38095),(0.33333,0.38095),(0.34921,0.38095),(0.36508,0.38095),(0.38095,0.38095),(0.39683,0.38095),(0.4127,0.38095),(0.42857,0.38095),(0.44444,0.38095),(0.46032,0.38095),(0.47619,0.38095),(0.49206,0.38095),(0.50794,0.38095),(0.52381,0.38095),(0.53968,0.38095),(0.55556,0.38095),(0.57143,0.38095),(0.5873,0.38095),(0.60317,0.38095),(0.61905,0.38095),(0.63492,0.38095),(0.65079,0.38095),(0.66667,0.38095),(0.68254,0.38095),(0.69841,0.38095),(0.71429,0.38095),(0.73016,0.38095),(0.74603,0.38095),(0.7619,0.38095),(0.77778,0.38095),(0.79365,0.38095),(0.80952,0.38095),(0.8254,0.38095),(0.84127,0.38095),(0.85714,0.38095),(0.87302,0.38095),(0.88889,0.38095),(0.90476,0.38095),(0.92063,0.38095),(0.93651,0.38095),(0.95238,0.38095),(0.96825,0.38095),(0.98413,0.38095),(0.99609,0.38095),(0.00391,0.39683),(0.01587,0.39683),(0.03175,0.39683),(0.04762,0.39683),(0.06349,0.39683),(0.07937,0.39683),(0.09524,0.39683),(0.11111,0.39683),(0.12698,0.39683),(0.14286,0.39683),(0.15873,0.39683),(0.1746,0.39683),(0.19048,0.39683),(0.20635,0.39683),(0.22222,0.39683),(0.2381,0.39683),(0.25397,0.39683),(0.26984,0.39683),(0.28571,0.39683),(0.30159,0.39683),(0.31746,0.39683),(0.33333,0.39683),(0.34921,0.39683),(0.36508,0.39683),(0.38095,0.39683),(0.39683,0.39683),(0.4127,0.39683),(0.42857,0.39683),(0.44444,0.39683),(0.46032,0.39683),(0.47619,0.39683),(0.49206,0.39683),(0.50794,0.39683),(0.52381,0.39683),(0.53968,0.39683),(0.55556,0.39683),(0.57143,0.39683),(0.5873,0.39683),(0.60317,0.39683),(0.61905,0.39683),(0.63492,0.39683),(0.65079,0.39683),(0.66667,0.39683),(0.68254,0.39683),(0.69841,0.39683),(0.71429,0.39683),(0.73016,0.39683),(0.74603,0.39683),(0.7619,0.39683),(0.77778,0.39683),(0.79365,0.39683),(0.80952,0.39683),(0.8254,0.39683),(0.84127,0.39683),(0.85714,0.39683),(0.87302,0.39683),(0.88889,0.39683),(0.90476,0.39683),(0.92063,0.39683),(0.93651,0.39683),(0.95238,0.39683),(0.96825,0.39683),(0.98413,0.39683),(0.99609,0.39683),(0.00391,0.4127),(0.01587,0.4127),(0.03175,0.4127),(0.04762,0.4127),(0.06349,0.4127),(0.07937,0.4127),(0.09524,0.4127),(0.11111,0.4127),(0.12698,0.4127),(0.14286,0.4127),(0.15873,0.4127),(0.1746,0.4127),(0.19048,0.4127),(0.20635,0.4127),(0.22222,0.4127),(0.2381,0.4127),(0.25397,0.4127),(0.26984,0.4127),(0.28571,0.4127),(0.30159,0.4127),(0.31746,0.4127),(0.33333,0.4127),(0.34921,0.4127),(0.36508,0.4127),(0.38095,0.4127),(0.39683,0.4127),(0.4127,0.4127),(0.42857,0.4127),(0.44444,0.4127),(0.46032,0.4127),(0.47619,0.4127),(0.49206,0.4127),(0.50794,0.4127),(0.52381,0.4127),(0.53968,0.4127),(0.55556,0.4127),(0.57143,0.4127),(0.5873,0.4127),(0.60317,0.4127),(0.61905,0.4127),(0.63492,0.4127),(0.65079,0.4127),(0.66667,0.4127),(0.68254,0.4127),(0.69841,0.4127),(0.71429,0.4127),(0.73016,0.4127),(0.74603,0.4127),(0.7619,0.4127),(0.77778,0.4127),(0.79365,0.4127),(0.80952,0.4127),(0.8254,0.4127),(0.84127,0.4127),(0.85714,0.4127),(0.87302,0.4127),(0.88889,0.4127),(0.90476,0.4127),(0.92063,0.4127),(0.93651,0.4127),(0.95238,0.4127),(0.96825,0.4127),(0.98413,0.4127),(0.99609,0.4127),(0.00391,0.42857),(0.01587,0.42857),(0.03175,0.42857),(0.04762,0.42857),(0.06349,0.42857),(0.07937,0.42857),(0.09524,0.42857),(0.11111,0.42857),(0.12698,0.42857),(0.14286,0.42857),(0.15873,0.42857),(0.1746,0.42857),(0.19048,0.42857),(0.20635,0.42857),(0.22222,0.42857),(0.2381,0.42857),(0.25397,0.42857),(0.26984,0.42857),(0.28571,0.42857),(0.30159,0.42857),(0.31746,0.42857),(0.33333,0.42857),(0.34921,0.42857),(0.36508,0.42857),(0.38095,0.42857),(0.39683,0.42857),(0.4127,0.42857),(0.42857,0.42857),(0.44444,0.42857),(0.46032,0.42857),(0.47619,0.42857),(0.49206,0.42857),(0.50794,0.42857),(0.52381,0.42857),(0.53968,0.42857),(0.55556,0.42857),(0.57143,0.42857),(0.5873,0.42857),(0.60317,0.42857),(0.61905,0.42857),(0.63492,0.42857),(0.65079,0.42857),(0.66667,0.42857),(0.68254,0.42857),(0.69841,0.42857),(0.71429,0.42857),(0.73016,0.42857),(0.74603,0.42857),(0.7619,0.42857),(0.77778,0.42857),(0.79365,0.42857),(0.80952,0.42857),(0.8254,0.42857),(0.84127,0.42857),(0.85714,0.42857),(0.87302,0.42857),(0.88889,0.42857),(0.90476,0.42857),(0.92063,0.42857),(0.93651,0.42857),(0.95238,0.42857),(0.96825,0.42857),(0.98413,0.42857),(0.99609,0.42857),(0.00391,0.44444),(0.01587,0.44444),(0.03175,0.44444),(0.04762,0.44444),(0.06349,0.44444),(0.07937,0.44444),(0.09524,0.44444),(0.11111,0.44444),(0.12698,0.44444),(0.14286,0.44444),(0.15873,0.44444),(0.1746,0.44444),(0.19048,0.44444),(0.20635,0.44444),(0.22222,0.44444),(0.2381,0.44444),(0.25397,0.44444),(0.26984,0.44444),(0.28571,0.44444),(0.30159,0.44444),(0.31746,0.44444),(0.33333,0.44444),(0.34921,0.44444),(0.36508,0.44444),(0.38095,0.44444),(0.39683,0.44444),(0.4127,0.44444),(0.42857,0.44444),(0.44444,0.44444),(0.46032,0.44444),(0.47619,0.44444),(0.49206,0.44444),(0.50794,0.44444),(0.52381,0.44444),(0.53968,0.44444),(0.55556,0.44444),(0.57143,0.44444),(0.5873,0.44444),(0.60317,0.44444),(0.61905,0.44444),(0.63492,0.44444),(0.65079,0.44444),(0.66667,0.44444),(0.68254,0.44444),(0.69841,0.44444),(0.71429,0.44444),(0.73016,0.44444),(0.74603,0.44444),(0.7619,0.44444),(0.77778,0.44444),(0.79365,0.44444),(0.80952,0.44444),(0.8254,0.44444),(0.84127,0.44444),(0.85714,0.44444),(0.87302,0.44444),(0.88889,0.44444),(0.90476,0.44444),(0.92063,0.44444),(0.93651,0.44444),(0.95238,0.44444),(0.96825,0.44444),(0.98413,0.44444),(0.99609,0.44444),(0.00391,0.46032),(0.01587,0.46032),(0.03175,0.46032),(0.04762,0.46032),(0.06349,0.46032),(0.07937,0.46032),(0.09524,0.46032),(0.11111,0.46032),(0.12698,0.46032),(0.14286,0.46032),(0.15873,0.46032),(0.1746,0.46032),(0.19048,0.46032),(0.20635,0.46032),(0.22222,0.46032),(0.2381,0.46032),(0.25397,0.46032),(0.26984,0.46032),(0.28571,0.46032),(0.30159,0.46032),(0.31746,0.46032),(0.33333,0.46032),(0.34921,0.46032),(0.36508,0.46032),(0.38095,0.46032),(0.39683,0.46032),(0.4127,0.46032),(0.42857,0.46032),(0.44444,0.46032),(0.46032,0.46032),(0.47619,0.46032),(0.49206,0.46032),(0.50794,0.46032),(0.52381,0.46032),(0.53968,0.46032),(0.55556,0.46032),(0.57143,0.46032),(0.5873,0.46032),(0.60317,0.46032),(0.61905,0.46032),(0.63492,0.46032),(0.65079,0.46032),(0.66667,0.46032),(0.68254,0.46032),(0.69841,0.46032),(0.71429,0.46032),(0.73016,0.46032),(0.74603,0.46032),(0.7619,0.46032),(0.77778,0.46032),(0.79365,0.46032),(0.80952,0.46032),(0.8254,0.46032),(0.84127,0.46032),(0.85714,0.46032),(0.87302,0.46032),(0.88889,0.46032),(0.90476,0.46032),(0.92063,0.46032),(0.93651,0.46032),(0.95238,0.46032),(0.96825,0.46032),(0.98413,0.46032),(0.99609,0.46032),(0.00391,0.47619),(0.01587,0.47619),(0.03175,0.47619),(0.04762,0.47619),(0.06349,0.47619),(0.07937,0.47619),(0.09524,0.47619),(0.11111,0.47619),(0.12698,0.47619),(0.14286,0.47619),(0.15873,0.47619),(0.1746,0.47619),(0.19048,0.47619),(0.20635,0.47619),(0.22222,0.47619),(0.2381,0.47619),(0.25397,0.47619),(0.26984,0.47619),(0.28571,0.47619),(0.30159,0.47619),(0.31746,0.47619),(0.33333,0.47619),(0.34921,0.47619),(0.36508,0.47619),(0.38095,0.47619),(0.39683,0.47619),(0.4127,0.47619),(0.42857,0.47619),(0.44444,0.47619),(0.46032,0.47619),(0.47619,0.47619),(0.49206,0.47619),(0.50794,0.47619),(0.52381,0.47619),(0.53968,0.47619),(0.55556,0.47619),(0.57143,0.47619),(0.5873,0.47619),(0.60317,0.47619),(0.61905,0.47619),(0.63492,0.47619),(0.65079,0.47619),(0.66667,0.47619),(0.68254,0.47619),(0.69841,0.47619),(0.71429,0.47619),(0.73016,0.47619),(0.74603,0.47619),(0.7619,0.47619),(0.77778,0.47619),(0.79365,0.47619),(0.80952,0.47619),(0.8254,0.47619),(0.84127,0.47619),(0.85714,0.47619),(0.87302,0.47619),(0.88889,0.47619),(0.90476,0.47619),(0.92063,0.47619),(0.93651,0.47619),(0.95238,0.47619),(0.96825,0.47619),(0.98413,0.47619),(0.99609,0.47619),(0.00391,0.49206),(0.01587,0.49206),(0.03175,0.49206),(0.04762,0.49206),(0.06349,0.49206),(0.07937,0.49206),(0.09524,0.49206),(0.11111,0.49206),(0.12698,0.49206),(0.14286,0.49206),(0.15873,0.49206),(0.1746,0.49206),(0.19048,0.49206),(0.20635,0.49206),(0.22222,0.49206),(0.2381,0.49206),(0.25397,0.49206),(0.26984,0.49206),(0.28571,0.49206),(0.30159,0.49206),(0.31746,0.49206),(0.33333,0.49206),(0.34921,0.49206),(0.36508,0.49206),(0.38095,0.49206),(0.39683,0.49206),(0.4127,0.49206),(0.42857,0.49206),(0.44444,0.49206),(0.46032,0.49206),(0.47619,0.49206),(0.49206,0.49206),(0.50794,0.49206),(0.52381,0.49206),(0.53968,0.49206),(0.55556,0.49206),(0.57143,0.49206),(0.5873,0.49206),(0.60317,0.49206),(0.61905,0.49206),(0.63492,0.49206),(0.65079,0.49206),(0.66667,0.49206),(0.68254,0.49206),(0.69841,0.49206),(0.71429,0.49206),(0.73016,0.49206),(0.74603,0.49206),(0.7619,0.49206),(0.77778,0.49206),(0.79365,0.49206),(0.80952,0.49206),(0.8254,0.49206),(0.84127,0.49206),(0.85714,0.49206),(0.87302,0.49206),(0.88889,0.49206),(0.90476,0.49206),(0.92063,0.49206),(0.93651,0.49206),(0.95238,0.49206),(0.96825,0.49206),(0.98413,0.49206),(0.99609,0.49206),(0.00391,0.50794),(0.01587,0.50794),(0.03175,0.50794),(0.04762,0.50794),(0.06349,0.50794),(0.07937,0.50794),(0.09524,0.50794),(0.11111,0.50794),(0.12698,0.50794),(0.14286,0.50794),(0.15873,0.50794),(0.1746,0.50794),(0.19048,0.50794),(0.20635,0.50794),(0.22222,0.50794),(0.2381,0.50794),(0.25397,0.50794),(0.26984,0.50794),(0.28571,0.50794),(0.30159,0.50794),(0.31746,0.50794),(0.33333,0.50794),(0.34921,0.50794),(0.36508,0.50794),(0.38095,0.50794),(0.39683,0.50794),(0.4127,0.50794),(0.42857,0.50794),(0.44444,0.50794),(0.46032,0.50794),(0.47619,0.50794),(0.49206,0.50794),(0.50794,0.50794),(0.52381,0.50794),(0.53968,0.50794),(0.55556,0.50794),(0.57143,0.50794),(0.5873,0.50794),(0.60317,0.50794),(0.61905,0.50794),(0.63492,0.50794),(0.65079,0.50794),(0.66667,0.50794),(0.68254,0.50794),(0.69841,0.50794),(0.71429,0.50794),(0.73016,0.50794),(0.74603,0.50794),(0.7619,0.50794),(0.77778,0.50794),(0.79365,0.50794),(0.80952,0.50794),(0.8254,0.50794),(0.84127,0.50794),(0.85714,0.50794),(0.87302,0.50794),(0.88889,0.50794),(0.90476,0.50794),(0.92063,0.50794),(0.93651,0.50794),(0.95238,0.50794),(0.96825,0.50794),(0.98413,0.50794),(0.99609,0.50794),(0.00391,0.52381),(0.01587,0.52381),(0.03175,0.52381),(0.04762,0.52381),(0.06349,0.52381),(0.07937,0.52381),(0.09524,0.52381),(0.11111,0.52381),(0.12698,0.52381),(0.14286,0.52381),(0.15873,0.52381),(0.1746,0.52381),(0.19048,0.52381),(0.20635,0.52381),(0.22222,0.52381),(0.2381,0.52381),(0.25397,0.52381),(0.26984,0.52381),(0.28571,0.52381),(0.30159,0.52381),(0.31746,0.52381),(0.33333,0.52381),(0.34921,0.52381),(0.36508,0.52381),(0.38095,0.52381),(0.39683,0.52381),(0.4127,0.52381),(0.42857,0.52381),(0.44444,0.52381),(0.46032,0.52381),(0.47619,0.52381),(0.49206,0.52381),(0.50794,0.52381),(0.52381,0.52381),(0.53968,0.52381),(0.55556,0.52381),(0.57143,0.52381),(0.5873,0.52381),(0.60317,0.52381),(0.61905,0.52381),(0.63492,0.52381),(0.65079,0.52381),(0.66667,0.52381),(0.68254,0.52381),(0.69841,0.52381),(0.71429,0.52381),(0.73016,0.52381),(0.74603,0.52381),(0.7619,0.52381),(0.77778,0.52381),(0.79365,0.52381),(0.80952,0.52381),(0.8254,0.52381),(0.84127,0.52381),(0.85714,0.52381),(0.87302,0.52381),(0.88889,0.52381),(0.90476,0.52381),(0.92063,0.52381),(0.93651,0.52381),(0.95238,0.52381),(0.96825,0.52381),(0.98413,0.52381),(0.99609,0.52381),(0.00391,0.53968),(0.01587,0.53968),(0.03175,0.53968),(0.04762,0.53968),(0.06349,0.53968),(0.07937,0.53968),(0.09524,0.53968),(0.11111,0.53968),(0.12698,0.53968),(0.14286,0.53968),(0.15873,0.53968),(0.1746,0.53968),(0.19048,0.53968),(0.20635,0.53968),(0.22222,0.53968),(0.2381,0.53968),(0.25397,0.53968),(0.26984,0.53968),(0.28571,0.53968),(0.30159,0.53968),(0.31746,0.53968),(0.33333,0.53968),(0.34921,0.53968),(0.36508,0.53968),(0.38095,0.53968),(0.39683,0.53968),(0.4127,0.53968),(0.42857,0.53968),(0.44444,0.53968),(0.46032,0.53968),(0.47619,0.53968),(0.49206,0.53968),(0.50794,0.53968),(0.52381,0.53968),(0.53968,0.53968),(0.55556,0.53968),(0.57143,0.53968),(0.5873,0.53968),(0.60317,0.53968),(0.61905,0.53968),(0.63492,0.53968),(0.65079,0.53968),(0.66667,0.53968),(0.68254,0.53968),(0.69841,0.53968),(0.71429,0.53968),(0.73016,0.53968),(0.74603,0.53968),(0.7619,0.53968),(0.77778,0.53968),(0.79365,0.53968),(0.80952,0.53968),(0.8254,0.53968),(0.84127,0.53968),(0.85714,0.53968),(0.87302,0.53968),(0.88889,0.53968),(0.90476,0.53968),(0.92063,0.53968),(0.93651,0.53968),(0.95238,0.53968),(0.96825,0.53968),(0.98413,0.53968),(0.99609,0.53968),(0.00391,0.55556),(0.01587,0.55556),(0.03175,0.55556),(0.04762,0.55556),(0.06349,0.55556),(0.07937,0.55556),(0.09524,0.55556),(0.11111,0.55556),(0.12698,0.55556),(0.14286,0.55556),(0.15873,0.55556),(0.1746,0.55556),(0.19048,0.55556),(0.20635,0.55556),(0.22222,0.55556),(0.2381,0.55556),(0.25397,0.55556),(0.26984,0.55556),(0.28571,0.55556),(0.30159,0.55556),(0.31746,0.55556),(0.33333,0.55556),(0.34921,0.55556),(0.36508,0.55556),(0.38095,0.55556),(0.39683,0.55556),(0.4127,0.55556),(0.42857,0.55556),(0.44444,0.55556),(0.46032,0.55556),(0.47619,0.55556),(0.49206,0.55556),(0.50794,0.55556),(0.52381,0.55556),(0.53968,0.55556),(0.55556,0.55556),(0.57143,0.55556),(0.5873,0.55556),(0.60317,0.55556),(0.61905,0.55556),(0.63492,0.55556),(0.65079,0.55556),(0.66667,0.55556),(0.68254,0.55556),(0.69841,0.55556),(0.71429,0.55556),(0.73016,0.55556),(0.74603,0.55556),(0.7619,0.55556),(0.77778,0.55556),(0.79365,0.55556),(0.80952,0.55556),(0.8254,0.55556),(0.84127,0.55556),(0.85714,0.55556),(0.87302,0.55556),(0.88889,0.55556),(0.90476,0.55556),(0.92063,0.55556),(0.93651,0.55556),(0.95238,0.55556),(0.96825,0.55556),(0.98413,0.55556),(0.99609,0.55556),(0.00391,0.57143),(0.01587,0.57143),(0.03175,0.57143),(0.04762,0.57143),(0.06349,0.57143),(0.07937,0.57143),(0.09524,0.57143),(0.11111,0.57143),(0.12698,0.57143),(0.14286,0.57143),(0.15873,0.57143),(0.1746,0.57143),(0.19048,0.57143),(0.20635,0.57143),(0.22222,0.57143),(0.2381,0.57143),(0.25397,0.57143),(0.26984,0.57143),(0.28571,0.57143),(0.30159,0.57143),(0.31746,0.57143),(0.33333,0.57143),(0.34921,0.57143),(0.36508,0.57143),(0.38095,0.57143),(0.39683,0.57143),(0.4127,0.57143),(0.42857,0.57143),(0.44444,0.57143),(0.46032,0.57143),(0.47619,0.57143),(0.49206,0.57143),(0.50794,0.57143),(0.52381,0.57143),(0.53968,0.57143),(0.55556,0.57143),(0.57143,0.57143),(0.5873,0.57143),(0.60317,0.57143),(0.61905,0.57143),(0.63492,0.57143),(0.65079,0.57143),(0.66667,0.57143),(0.68254,0.57143),(0.69841,0.57143),(0.71429,0.57143),(0.73016,0.57143),(0.74603,0.57143),(0.7619,0.57143),(0.77778,0.57143),(0.79365,0.57143),(0.80952,0.57143),(0.8254,0.57143),(0.84127,0.57143),(0.85714,0.57143),(0.87302,0.57143),(0.88889,0.57143),(0.90476,0.57143),(0.92063,0.57143),(0.93651,0.57143),(0.95238,0.57143),(0.96825,0.57143),(0.98413,0.57143),(0.99609,0.57143),(0.00391,0.5873),(0.01587,0.5873),(0.03175,0.5873),(0.04762,0.5873),(0.06349,0.5873),(0.07937,0.5873),(0.09524,0.5873),(0.11111,0.5873),(0.12698,0.5873),(0.14286,0.5873),(0.15873,0.5873),(0.1746,0.5873),(0.19048,0.5873),(0.20635,0.5873),(0.22222,0.5873),(0.2381,0.5873),(0.25397,0.5873),(0.26984,0.5873),(0.28571,0.5873),(0.30159,0.5873),(0.31746,0.5873),(0.33333,0.5873),(0.34921,0.5873),(0.36508,0.5873),(0.38095,0.5873),(0.39683,0.5873),(0.4127,0.5873),(0.42857,0.5873),(0.44444,0.5873),(0.46032,0.5873),(0.47619,0.5873),(0.49206,0.5873),(0.50794,0.5873),(0.52381,0.5873),(0.53968,0.5873),(0.55556,0.5873),(0.57143,0.5873),(0.5873,0.5873),(0.60317,0.5873),(0.61905,0.5873),(0.63492,0.5873),(0.65079,0.5873),(0.66667,0.5873),(0.68254,0.5873),(0.69841,0.5873),(0.71429,0.5873),(0.73016,0.5873),(0.74603,0.5873),(0.7619,0.5873),(0.77778,0.5873),(0.79365,0.5873),(0.80952,0.5873),(0.8254,0.5873),(0.84127,0.5873),(0.85714,0.5873),(0.87302,0.5873),(0.88889,0.5873),(0.90476,0.5873),(0.92063,0.5873),(0.93651,0.5873),(0.95238,0.5873),(0.96825,0.5873),(0.98413,0.5873),(0.99609,0.5873),(0.00391,0.60317),(0.01587,0.60317),(0.03175,0.60317),(0.04762,0.60317),(0.06349,0.60317),(0.07937,0.60317),(0.09524,0.60317),(0.11111,0.60317),(0.12698,0.60317),(0.14286,0.60317),(0.15873,0.60317),(0.1746,0.60317),(0.19048,0.60317),(0.20635,0.60317),(0.22222,0.60317),(0.2381,0.60317),(0.25397,0.60317),(0.26984,0.60317),(0.28571,0.60317),(0.30159,0.60317),(0.31746,0.60317),(0.33333,0.60317),(0.34921,0.60317),(0.36508,0.60317),(0.38095,0.60317),(0.39683,0.60317),(0.4127,0.60317),(0.42857,0.60317),(0.44444,0.60317),(0.46032,0.60317),(0.47619,0.60317),(0.49206,0.60317),(0.50794,0.60317),(0.52381,0.60317),(0.53968,0.60317),(0.55556,0.60317),(0.57143,0.60317),(0.5873,0.60317),(0.60317,0.60317),(0.61905,0.60317),(0.63492,0.60317),(0.65079,0.60317),(0.66667,0.60317),(0.68254,0.60317),(0.69841,0.60317),(0.71429,0.60317),(0.73016,0.60317),(0.74603,0.60317),(0.7619,0.60317),(0.77778,0.60317),(0.79365,0.60317),(0.80952,0.60317),(0.8254,0.60317),(0.84127,0.60317),(0.85714,0.60317),(0.87302,0.60317),(0.88889,0.60317),(0.90476,0.60317),(0.92063,0.60317),(0.93651,0.60317),(0.95238,0.60317),(0.96825,0.60317),(0.98413,0.60317),(0.99609,0.60317),(0.00391,0.61905),(0.01587,0.61905),(0.03175,0.61905),(0.04762,0.61905),(0.06349,0.61905),(0.07937,0.61905),(0.09524,0.61905),(0.11111,0.61905),(0.12698,0.61905),(0.14286,0.61905),(0.15873,0.61905),(0.1746,0.61905),(0.19048,0.61905),(0.20635,0.61905),(0.22222,0.61905),(0.2381,0.61905),(0.25397,0.61905),(0.26984,0.61905),(0.28571,0.61905),(0.30159,0.61905),(0.31746,0.61905),(0.33333,0.61905),(0.34921,0.61905),(0.36508,0.61905),(0.38095,0.61905),(0.39683,0.61905),(0.4127,0.61905),(0.42857,0.61905),(0.44444,0.61905),(0.46032,0.61905),(0.47619,0.61905),(0.49206,0.61905),(0.50794,0.61905),(0.52381,0.61905),(0.53968,0.61905),(0.55556,0.61905),(0.57143,0.61905),(0.5873,0.61905),(0.60317,0.61905),(0.61905,0.61905),(0.63492,0.61905),(0.65079,0.61905),(0.66667,0.61905),(0.68254,0.61905),(0.69841,0.61905),(0.71429,0.61905),(0.73016,0.61905),(0.74603,0.61905),(0.7619,0.61905),(0.77778,0.61905),(0.79365,0.61905),(0.80952,0.61905),(0.8254,0.61905),(0.84127,0.61905),(0.85714,0.61905),(0.87302,0.61905),(0.88889,0.61905),(0.90476,0.61905),(0.92063,0.61905),(0.93651,0.61905),(0.95238,0.61905),(0.96825,0.61905),(0.98413,0.61905),(0.99609,0.61905),(0.00391,0.63492),(0.01587,0.63492),(0.03175,0.63492),(0.04762,0.63492),(0.06349,0.63492),(0.07937,0.63492),(0.09524,0.63492),(0.11111,0.63492),(0.12698,0.63492),(0.14286,0.63492),(0.15873,0.63492),(0.1746,0.63492),(0.19048,0.63492),(0.20635,0.63492),(0.22222,0.63492),(0.2381,0.63492),(0.25397,0.63492),(0.26984,0.63492),(0.28571,0.63492),(0.30159,0.63492),(0.31746,0.63492),(0.33333,0.63492),(0.34921,0.63492),(0.36508,0.63492),(0.38095,0.63492),(0.39683,0.63492),(0.4127,0.63492),(0.42857,0.63492),(0.44444,0.63492),(0.46032,0.63492),(0.47619,0.63492),(0.49206,0.63492),(0.50794,0.63492),(0.52381,0.63492),(0.53968,0.63492),(0.55556,0.63492),(0.57143,0.63492),(0.5873,0.63492),(0.60317,0.63492),(0.61905,0.63492),(0.63492,0.63492),(0.65079,0.63492),(0.66667,0.63492),(0.68254,0.63492),(0.69841,0.63492),(0.71429,0.63492),(0.73016,0.63492),(0.74603,0.63492),(0.7619,0.63492),(0.77778,0.63492),(0.79365,0.63492),(0.80952,0.63492),(0.8254,0.63492),(0.84127,0.63492),(0.85714,0.63492),(0.87302,0.63492),(0.88889,0.63492),(0.90476,0.63492),(0.92063,0.63492),(0.93651,0.63492),(0.95238,0.63492),(0.96825,0.63492),(0.98413,0.63492),(0.99609,0.63492),(0.00391,0.65079),(0.01587,0.65079),(0.03175,0.65079),(0.04762,0.65079),(0.06349,0.65079),(0.07937,0.65079),(0.09524,0.65079),(0.11111,0.65079),(0.12698,0.65079),(0.14286,0.65079),(0.15873,0.65079),(0.1746,0.65079),(0.19048,0.65079),(0.20635,0.65079),(0.22222,0.65079),(0.2381,0.65079),(0.25397,0.65079),(0.26984,0.65079),(0.28571,0.65079),(0.30159,0.65079),(0.31746,0.65079),(0.33333,0.65079),(0.34921,0.65079),(0.36508,0.65079),(0.38095,0.65079),(0.39683,0.65079),(0.4127,0.65079),(0.42857,0.65079),(0.44444,0.65079),(0.46032,0.65079),(0.47619,0.65079),(0.49206,0.65079),(0.50794,0.65079),(0.52381,0.65079),(0.53968,0.65079),(0.55556,0.65079),(0.57143,0.65079),(0.5873,0.65079),(0.60317,0.65079),(0.61905,0.65079),(0.63492,0.65079),(0.65079,0.65079),(0.66667,0.65079),(0.68254,0.65079),(0.69841,0.65079),(0.71429,0.65079),(0.73016,0.65079),(0.74603,0.65079),(0.7619,0.65079),(0.77778,0.65079),(0.79365,0.65079),(0.80952,0.65079),(0.8254,0.65079),(0.84127,0.65079),(0.85714,0.65079),(0.87302,0.65079),(0.88889,0.65079),(0.90476,0.65079),(0.92063,0.65079),(0.93651,0.65079),(0.95238,0.65079),(0.96825,0.65079),(0.98413,0.65079),(0.99609,0.65079),(0.00391,0.66667),(0.01587,0.66667),(0.03175,0.66667),(0.04762,0.66667),(0.06349,0.66667),(0.07937,0.66667),(0.09524,0.66667),(0.11111,0.66667),(0.12698,0.66667),(0.14286,0.66667),(0.15873,0.66667),(0.1746,0.66667),(0.19048,0.66667),(0.20635,0.66667),(0.22222,0.66667),(0.2381,0.66667),(0.25397,0.66667),(0.26984,0.66667),(0.28571,0.66667),(0.30159,0.66667),(0.31746,0.66667),(0.33333,0.66667),(0.34921,0.66667),(0.36508,0.66667),(0.38095,0.66667),(0.39683,0.66667),(0.4127,0.66667),(0.42857,0.66667),(0.44444,0.66667),(0.46032,0.66667),(0.47619,0.66667),(0.49206,0.66667),(0.50794,0.66667),(0.52381,0.66667),(0.53968,0.66667),(0.55556,0.66667),(0.57143,0.66667),(0.5873,0.66667),(0.60317,0.66667),(0.61905,0.66667),(0.63492,0.66667),(0.65079,0.66667),(0.66667,0.66667),(0.68254,0.66667),(0.69841,0.66667),(0.71429,0.66667),(0.73016,0.66667),(0.74603,0.66667),(0.7619,0.66667),(0.77778,0.66667),(0.79365,0.66667),(0.80952,0.66667),(0.8254,0.66667),(0.84127,0.66667),(0.85714,0.66667),(0.87302,0.66667),(0.88889,0.66667),(0.90476,0.66667),(0.92063,0.66667),(0.93651,0.66667),(0.95238,0.66667),(0.96825,0.66667),(0.98413,0.66667),(0.99609,0.66667),(0.00391,0.68254),(0.01587,0.68254),(0.03175,0.68254),(0.04762,0.68254),(0.06349,0.68254),(0.07937,0.68254),(0.09524,0.68254),(0.11111,0.68254),(0.12698,0.68254),(0.14286,0.68254),(0.15873,0.68254),(0.1746,0.68254),(0.19048,0.68254),(0.20635,0.68254),(0.22222,0.68254),(0.2381,0.68254),(0.25397,0.68254),(0.26984,0.68254),(0.28571,0.68254),(0.30159,0.68254),(0.31746,0.68254),(0.33333,0.68254),(0.34921,0.68254),(0.36508,0.68254),(0.38095,0.68254),(0.39683,0.68254),(0.4127,0.68254),(0.42857,0.68254),(0.44444,0.68254),(0.46032,0.68254),(0.47619,0.68254),(0.49206,0.68254),(0.50794,0.68254),(0.52381,0.68254),(0.53968,0.68254),(0.55556,0.68254),(0.57143,0.68254),(0.5873,0.68254),(0.60317,0.68254),(0.61905,0.68254),(0.63492,0.68254),(0.65079,0.68254),(0.66667,0.68254),(0.68254,0.68254),(0.69841,0.68254),(0.71429,0.68254),(0.73016,0.68254),(0.74603,0.68254),(0.7619,0.68254),(0.77778,0.68254),(0.79365,0.68254),(0.80952,0.68254),(0.8254,0.68254),(0.84127,0.68254),(0.85714,0.68254),(0.87302,0.68254),(0.88889,0.68254),(0.90476,0.68254),(0.92063,0.68254),(0.93651,0.68254),(0.95238,0.68254),(0.96825,0.68254),(0.98413,0.68254),(0.99609,0.68254),(0.00391,0.69841),(0.01587,0.69841),(0.03175,0.69841),(0.04762,0.69841),(0.06349,0.69841),(0.07937,0.69841),(0.09524,0.69841),(0.11111,0.69841),(0.12698,0.69841),(0.14286,0.69841),(0.15873,0.69841),(0.1746,0.69841),(0.19048,0.69841),(0.20635,0.69841),(0.22222,0.69841),(0.2381,0.69841),(0.25397,0.69841),(0.26984,0.69841),(0.28571,0.69841),(0.30159,0.69841),(0.31746,0.69841),(0.33333,0.69841),(0.34921,0.69841),(0.36508,0.69841),(0.38095,0.69841),(0.39683,0.69841),(0.4127,0.69841),(0.42857,0.69841),(0.44444,0.69841),(0.46032,0.69841),(0.47619,0.69841),(0.49206,0.69841),(0.50794,0.69841),(0.52381,0.69841),(0.53968,0.69841),(0.55556,0.69841),(0.57143,0.69841),(0.5873,0.69841),(0.60317,0.69841),(0.61905,0.69841),(0.63492,0.69841),(0.65079,0.69841),(0.66667,0.69841),(0.68254,0.69841),(0.69841,0.69841),(0.71429,0.69841),(0.73016,0.69841),(0.74603,0.69841),(0.7619,0.69841),(0.77778,0.69841),(0.79365,0.69841),(0.80952,0.69841),(0.8254,0.69841),(0.84127,0.69841),(0.85714,0.69841),(0.87302,0.69841),(0.88889,0.69841),(0.90476,0.69841),(0.92063,0.69841),(0.93651,0.69841),(0.95238,0.69841),(0.96825,0.69841),(0.98413,0.69841),(0.99609,0.69841),(0.00391,0.71429),(0.01587,0.71429),(0.03175,0.71429),(0.04762,0.71429),(0.06349,0.71429),(0.07937,0.71429),(0.09524,0.71429),(0.11111,0.71429),(0.12698,0.71429),(0.14286,0.71429),(0.15873,0.71429),(0.1746,0.71429),(0.19048,0.71429),(0.20635,0.71429),(0.22222,0.71429),(0.2381,0.71429),(0.25397,0.71429),(0.26984,0.71429),(0.28571,0.71429),(0.30159,0.71429),(0.31746,0.71429),(0.33333,0.71429),(0.34921,0.71429),(0.36508,0.71429),(0.38095,0.71429),(0.39683,0.71429),(0.4127,0.71429),(0.42857,0.71429),(0.44444,0.71429),(0.46032,0.71429),(0.47619,0.71429),(0.49206,0.71429),(0.50794,0.71429),(0.52381,0.71429),(0.53968,0.71429),(0.55556,0.71429),(0.57143,0.71429),(0.5873,0.71429),(0.60317,0.71429),(0.61905,0.71429),(0.63492,0.71429),(0.65079,0.71429),(0.66667,0.71429),(0.68254,0.71429),(0.69841,0.71429),(0.71429,0.71429),(0.73016,0.71429),(0.74603,0.71429),(0.7619,0.71429),(0.77778,0.71429),(0.79365,0.71429),(0.80952,0.71429),(0.8254,0.71429),(0.84127,0.71429),(0.85714,0.71429),(0.87302,0.71429),(0.88889,0.71429),(0.90476,0.71429),(0.92063,0.71429),(0.93651,0.71429),(0.95238,0.71429),(0.96825,0.71429),(0.98413,0.71429),(0.99609,0.71429),(0.00391,0.73016),(0.01587,0.73016),(0.03175,0.73016),(0.04762,0.73016),(0.06349,0.73016),(0.07937,0.73016),(0.09524,0.73016),(0.11111,0.73016),(0.12698,0.73016),(0.14286,0.73016),(0.15873,0.73016),(0.1746,0.73016),(0.19048,0.73016),(0.20635,0.73016),(0.22222,0.73016),(0.2381,0.73016),(0.25397,0.73016),(0.26984,0.73016),(0.28571,0.73016),(0.30159,0.73016),(0.31746,0.73016),(0.33333,0.73016),(0.34921,0.73016),(0.36508,0.73016),(0.38095,0.73016),(0.39683,0.73016),(0.4127,0.73016),(0.42857,0.73016),(0.44444,0.73016),(0.46032,0.73016),(0.47619,0.73016),(0.49206,0.73016),(0.50794,0.73016),(0.52381,0.73016),(0.53968,0.73016),(0.55556,0.73016),(0.57143,0.73016),(0.5873,0.73016),(0.60317,0.73016),(0.61905,0.73016),(0.63492,0.73016),(0.65079,0.73016),(0.66667,0.73016),(0.68254,0.73016),(0.69841,0.73016),(0.71429,0.73016),(0.73016,0.73016),(0.74603,0.73016),(0.7619,0.73016),(0.77778,0.73016),(0.79365,0.73016),(0.80952,0.73016),(0.8254,0.73016),(0.84127,0.73016),(0.85714,0.73016),(0.87302,0.73016),(0.88889,0.73016),(0.90476,0.73016),(0.92063,0.73016),(0.93651,0.73016),(0.95238,0.73016),(0.96825,0.73016),(0.98413,0.73016),(0.99609,0.73016),(0.00391,0.74603),(0.01587,0.74603),(0.03175,0.74603),(0.04762,0.74603),(0.06349,0.74603),(0.07937,0.74603),(0.09524,0.74603),(0.11111,0.74603),(0.12698,0.74603),(0.14286,0.74603),(0.15873,0.74603),(0.1746,0.74603),(0.19048,0.74603),(0.20635,0.74603),(0.22222,0.74603),(0.2381,0.74603),(0.25397,0.74603),(0.26984,0.74603),(0.28571,0.74603),(0.30159,0.74603),(0.31746,0.74603),(0.33333,0.74603),(0.34921,0.74603),(0.36508,0.74603),(0.38095,0.74603),(0.39683,0.74603),(0.4127,0.74603),(0.42857,0.74603),(0.44444,0.74603),(0.46032,0.74603),(0.47619,0.74603),(0.49206,0.74603),(0.50794,0.74603),(0.52381,0.74603),(0.53968,0.74603),(0.55556,0.74603),(0.57143,0.74603),(0.5873,0.74603),(0.60317,0.74603),(0.61905,0.74603),(0.63492,0.74603),(0.65079,0.74603),(0.66667,0.74603),(0.68254,0.74603),(0.69841,0.74603),(0.71429,0.74603),(0.73016,0.74603),(0.74603,0.74603),(0.7619,0.74603),(0.77778,0.74603),(0.79365,0.74603),(0.80952,0.74603),(0.8254,0.74603),(0.84127,0.74603),(0.85714,0.74603),(0.87302,0.74603),(0.88889,0.74603),(0.90476,0.74603),(0.92063,0.74603),(0.93651,0.74603),(0.95238,0.74603),(0.96825,0.74603),(0.98413,0.74603),(0.99609,0.74603),(0.00391,0.7619),(0.01587,0.7619),(0.03175,0.7619),(0.04762,0.7619),(0.06349,0.7619),(0.07937,0.7619),(0.09524,0.7619),(0.11111,0.7619),(0.12698,0.7619),(0.14286,0.7619),(0.15873,0.7619),(0.1746,0.7619),(0.19048,0.7619),(0.20635,0.7619),(0.22222,0.7619),(0.2381,0.7619),(0.25397,0.7619),(0.26984,0.7619),(0.28571,0.7619),(0.30159,0.7619),(0.31746,0.7619),(0.33333,0.7619),(0.34921,0.7619),(0.36508,0.7619),(0.38095,0.7619),(0.39683,0.7619),(0.4127,0.7619),(0.42857,0.7619),(0.44444,0.7619),(0.46032,0.7619),(0.47619,0.7619),(0.49206,0.7619),(0.50794,0.7619),(0.52381,0.7619),(0.53968,0.7619),(0.55556,0.7619),(0.57143,0.7619),(0.5873,0.7619),(0.60317,0.7619),(0.61905,0.7619),(0.63492,0.7619),(0.65079,0.7619),(0.66667,0.7619),(0.68254,0.7619),(0.69841,0.7619),(0.71429,0.7619),(0.73016,0.7619),(0.74603,0.7619),(0.7619,0.7619),(0.77778,0.7619),(0.79365,0.7619),(0.80952,0.7619),(0.8254,0.7619),(0.84127,0.7619),(0.85714,0.7619),(0.87302,0.7619),(0.88889,0.7619),(0.90476,0.7619),(0.92063,0.7619),(0.93651,0.7619),(0.95238,0.7619),(0.96825,0.7619),(0.98413,0.7619),(0.99609,0.7619),(0.00391,0.77778),(0.01587,0.77778),(0.03175,0.77778),(0.04762,0.77778),(0.06349,0.77778),(0.07937,0.77778),(0.09524,0.77778),(0.11111,0.77778),(0.12698,0.77778),(0.14286,0.77778),(0.15873,0.77778),(0.1746,0.77778),(0.19048,0.77778),(0.20635,0.77778),(0.22222,0.77778),(0.2381,0.77778),(0.25397,0.77778),(0.26984,0.77778),(0.28571,0.77778),(0.30159,0.77778),(0.31746,0.77778),(0.33333,0.77778),(0.34921,0.77778),(0.36508,0.77778),(0.38095,0.77778),(0.39683,0.77778),(0.4127,0.77778),(0.42857,0.77778),(0.44444,0.77778),(0.46032,0.77778),(0.47619,0.77778),(0.49206,0.77778),(0.50794,0.77778),(0.52381,0.77778),(0.53968,0.77778),(0.55556,0.77778),(0.57143,0.77778),(0.5873,0.77778),(0.60317,0.77778),(0.61905,0.77778),(0.63492,0.77778),(0.65079,0.77778),(0.66667,0.77778),(0.68254,0.77778),(0.69841,0.77778),(0.71429,0.77778),(0.73016,0.77778),(0.74603,0.77778),(0.7619,0.77778),(0.77778,0.77778),(0.79365,0.77778),(0.80952,0.77778),(0.8254,0.77778),(0.84127,0.77778),(0.85714,0.77778),(0.87302,0.77778),(0.88889,0.77778),(0.90476,0.77778),(0.92063,0.77778),(0.93651,0.77778),(0.95238,0.77778),(0.96825,0.77778),(0.98413,0.77778),(0.99609,0.77778),(0.00391,0.79365),(0.01587,0.79365),(0.03175,0.79365),(0.04762,0.79365),(0.06349,0.79365),(0.07937,0.79365),(0.09524,0.79365),(0.11111,0.79365),(0.12698,0.79365),(0.14286,0.79365),(0.15873,0.79365),(0.1746,0.79365),(0.19048,0.79365),(0.20635,0.79365),(0.22222,0.79365),(0.2381,0.79365),(0.25397,0.79365),(0.26984,0.79365),(0.28571,0.79365),(0.30159,0.79365),(0.31746,0.79365),(0.33333,0.79365),(0.34921,0.79365),(0.36508,0.79365),(0.38095,0.79365),(0.39683,0.79365),(0.4127,0.79365),(0.42857,0.79365),(0.44444,0.79365),(0.46032,0.79365),(0.47619,0.79365),(0.49206,0.79365),(0.50794,0.79365),(0.52381,0.79365),(0.53968,0.79365),(0.55556,0.79365),(0.57143,0.79365),(0.5873,0.79365),(0.60317,0.79365),(0.61905,0.79365),(0.63492,0.79365),(0.65079,0.79365),(0.66667,0.79365),(0.68254,0.79365),(0.69841,0.79365),(0.71429,0.79365),(0.73016,0.79365),(0.74603,0.79365),(0.7619,0.79365),(0.77778,0.79365),(0.79365,0.79365),(0.80952,0.79365),(0.8254,0.79365),(0.84127,0.79365),(0.85714,0.79365),(0.87302,0.79365),(0.88889,0.79365),(0.90476,0.79365),(0.92063,0.79365),(0.93651,0.79365),(0.95238,0.79365),(0.96825,0.79365),(0.98413,0.79365),(0.99609,0.79365),(0.00391,0.80952),(0.01587,0.80952),(0.03175,0.80952),(0.04762,0.80952),(0.06349,0.80952),(0.07937,0.80952),(0.09524,0.80952),(0.11111,0.80952),(0.12698,0.80952),(0.14286,0.80952),(0.15873,0.80952),(0.1746,0.80952),(0.19048,0.80952),(0.20635,0.80952),(0.22222,0.80952),(0.2381,0.80952),(0.25397,0.80952),(0.26984,0.80952),(0.28571,0.80952),(0.30159,0.80952),(0.31746,0.80952),(0.33333,0.80952),(0.34921,0.80952),(0.36508,0.80952),(0.38095,0.80952),(0.39683,0.80952),(0.4127,0.80952),(0.42857,0.80952),(0.44444,0.80952),(0.46032,0.80952),(0.47619,0.80952),(0.49206,0.80952),(0.50794,0.80952),(0.52381,0.80952),(0.53968,0.80952),(0.55556,0.80952),(0.57143,0.80952),(0.5873,0.80952),(0.60317,0.80952),(0.61905,0.80952),(0.63492,0.80952),(0.65079,0.80952),(0.66667,0.80952),(0.68254,0.80952),(0.69841,0.80952),(0.71429,0.80952),(0.73016,0.80952),(0.74603,0.80952),(0.7619,0.80952),(0.77778,0.80952),(0.79365,0.80952),(0.80952,0.80952),(0.8254,0.80952),(0.84127,0.80952),(0.85714,0.80952),(0.87302,0.80952),(0.88889,0.80952),(0.90476,0.80952),(0.92063,0.80952),(0.93651,0.80952),(0.95238,0.80952),(0.96825,0.80952),(0.98413,0.80952),(0.99609,0.80952),(0.00391,0.8254),(0.01587,0.8254),(0.03175,0.8254),(0.04762,0.8254),(0.06349,0.8254),(0.07937,0.8254),(0.09524,0.8254),(0.11111,0.8254),(0.12698,0.8254),(0.14286,0.8254),(0.15873,0.8254),(0.1746,0.8254),(0.19048,0.8254),(0.20635,0.8254),(0.22222,0.8254),(0.2381,0.8254),(0.25397,0.8254),(0.26984,0.8254),(0.28571,0.8254),(0.30159,0.8254),(0.31746,0.8254),(0.33333,0.8254),(0.34921,0.8254),(0.36508,0.8254),(0.38095,0.8254),(0.39683,0.8254),(0.4127,0.8254),(0.42857,0.8254),(0.44444,0.8254),(0.46032,0.8254),(0.47619,0.8254),(0.49206,0.8254),(0.50794,0.8254),(0.52381,0.8254),(0.53968,0.8254),(0.55556,0.8254),(0.57143,0.8254),(0.5873,0.8254),(0.60317,0.8254),(0.61905,0.8254),(0.63492,0.8254),(0.65079,0.8254),(0.66667,0.8254),(0.68254,0.8254),(0.69841,0.8254),(0.71429,0.8254),(0.73016,0.8254),(0.74603,0.8254),(0.7619,0.8254),(0.77778,0.8254),(0.79365,0.8254),(0.80952,0.8254),(0.8254,0.8254),(0.84127,0.8254),(0.85714,0.8254),(0.87302,0.8254),(0.88889,0.8254),(0.90476,0.8254),(0.92063,0.8254),(0.93651,0.8254),(0.95238,0.8254),(0.96825,0.8254),(0.98413,0.8254),(0.99609,0.8254),(0.00391,0.84127),(0.01587,0.84127),(0.03175,0.84127),(0.04762,0.84127),(0.06349,0.84127),(0.07937,0.84127),(0.09524,0.84127),(0.11111,0.84127),(0.12698,0.84127),(0.14286,0.84127),(0.15873,0.84127),(0.1746,0.84127),(0.19048,0.84127),(0.20635,0.84127),(0.22222,0.84127),(0.2381,0.84127),(0.25397,0.84127),(0.26984,0.84127),(0.28571,0.84127),(0.30159,0.84127),(0.31746,0.84127),(0.33333,0.84127),(0.34921,0.84127),(0.36508,0.84127),(0.38095,0.84127),(0.39683,0.84127),(0.4127,0.84127),(0.42857,0.84127),(0.44444,0.84127),(0.46032,0.84127),(0.47619,0.84127),(0.49206,0.84127),(0.50794,0.84127),(0.52381,0.84127),(0.53968,0.84127),(0.55556,0.84127),(0.57143,0.84127),(0.5873,0.84127),(0.60317,0.84127),(0.61905,0.84127),(0.63492,0.84127),(0.65079,0.84127),(0.66667,0.84127),(0.68254,0.84127),(0.69841,0.84127),(0.71429,0.84127),(0.73016,0.84127),(0.74603,0.84127),(0.7619,0.84127),(0.77778,0.84127),(0.79365,0.84127),(0.80952,0.84127),(0.8254,0.84127),(0.84127,0.84127),(0.85714,0.84127),(0.87302,0.84127),(0.88889,0.84127),(0.90476,0.84127),(0.92063,0.84127),(0.93651,0.84127),(0.95238,0.84127),(0.96825,0.84127),(0.98413,0.84127),(0.99609,0.84127),(0.00391,0.85714),(0.01587,0.85714),(0.03175,0.85714),(0.04762,0.85714),(0.06349,0.85714),(0.07937,0.85714),(0.09524,0.85714),(0.11111,0.85714),(0.12698,0.85714),(0.14286,0.85714),(0.15873,0.85714),(0.1746,0.85714),(0.19048,0.85714),(0.20635,0.85714),(0.22222,0.85714),(0.2381,0.85714),(0.25397,0.85714),(0.26984,0.85714),(0.28571,0.85714),(0.30159,0.85714),(0.31746,0.85714),(0.33333,0.85714),(0.34921,0.85714),(0.36508,0.85714),(0.38095,0.85714),(0.39683,0.85714),(0.4127,0.85714),(0.42857,0.85714),(0.44444,0.85714),(0.46032,0.85714),(0.47619,0.85714),(0.49206,0.85714),(0.50794,0.85714),(0.52381,0.85714),(0.53968,0.85714),(0.55556,0.85714),(0.57143,0.85714),(0.5873,0.85714),(0.60317,0.85714),(0.61905,0.85714),(0.63492,0.85714),(0.65079,0.85714),(0.66667,0.85714),(0.68254,0.85714),(0.69841,0.85714),(0.71429,0.85714),(0.73016,0.85714),(0.74603,0.85714),(0.7619,0.85714),(0.77778,0.85714),(0.79365,0.85714),(0.80952,0.85714),(0.8254,0.85714),(0.84127,0.85714),(0.85714,0.85714),(0.87302,0.85714),(0.88889,0.85714),(0.90476,0.85714),(0.92063,0.85714),(0.93651,0.85714),(0.95238,0.85714),(0.96825,0.85714),(0.98413,0.85714),(0.99609,0.85714),(0.00391,0.87302),(0.01587,0.87302),(0.03175,0.87302),(0.04762,0.87302),(0.06349,0.87302),(0.07937,0.87302),(0.09524,0.87302),(0.11111,0.87302),(0.12698,0.87302),(0.14286,0.87302),(0.15873,0.87302),(0.1746,0.87302),(0.19048,0.87302),(0.20635,0.87302),(0.22222,0.87302),(0.2381,0.87302),(0.25397,0.87302),(0.26984,0.87302),(0.28571,0.87302),(0.30159,0.87302),(0.31746,0.87302),(0.33333,0.87302),(0.34921,0.87302),(0.36508,0.87302),(0.38095,0.87302),(0.39683,0.87302),(0.4127,0.87302),(0.42857,0.87302),(0.44444,0.87302),(0.46032,0.87302),(0.47619,0.87302),(0.49206,0.87302),(0.50794,0.87302),(0.52381,0.87302),(0.53968,0.87302),(0.55556,0.87302),(0.57143,0.87302),(0.5873,0.87302),(0.60317,0.87302),(0.61905,0.87302),(0.63492,0.87302),(0.65079,0.87302),(0.66667,0.87302),(0.68254,0.87302),(0.69841,0.87302),(0.71429,0.87302),(0.73016,0.87302),(0.74603,0.87302),(0.7619,0.87302),(0.77778,0.87302),(0.79365,0.87302),(0.80952,0.87302),(0.8254,0.87302),(0.84127,0.87302),(0.85714,0.87302),(0.87302,0.87302),(0.88889,0.87302),(0.90476,0.87302),(0.92063,0.87302),(0.93651,0.87302),(0.95238,0.87302),(0.96825,0.87302),(0.98413,0.87302),(0.99609,0.87302),(0.00391,0.88889),(0.01587,0.88889),(0.03175,0.88889),(0.04762,0.88889),(0.06349,0.88889),(0.07937,0.88889),(0.09524,0.88889),(0.11111,0.88889),(0.12698,0.88889),(0.14286,0.88889),(0.15873,0.88889),(0.1746,0.88889),(0.19048,0.88889),(0.20635,0.88889),(0.22222,0.88889),(0.2381,0.88889),(0.25397,0.88889),(0.26984,0.88889),(0.28571,0.88889),(0.30159,0.88889),(0.31746,0.88889),(0.33333,0.88889),(0.34921,0.88889),(0.36508,0.88889),(0.38095,0.88889),(0.39683,0.88889),(0.4127,0.88889),(0.42857,0.88889),(0.44444,0.88889),(0.46032,0.88889),(0.47619,0.88889),(0.49206,0.88889),(0.50794,0.88889),(0.52381,0.88889),(0.53968,0.88889),(0.55556,0.88889),(0.57143,0.88889),(0.5873,0.88889),(0.60317,0.88889),(0.61905,0.88889),(0.63492,0.88889),(0.65079,0.88889),(0.66667,0.88889),(0.68254,0.88889),(0.69841,0.88889),(0.71429,0.88889),(0.73016,0.88889),(0.74603,0.88889),(0.7619,0.88889),(0.77778,0.88889),(0.79365,0.88889),(0.80952,0.88889),(0.8254,0.88889),(0.84127,0.88889),(0.85714,0.88889),(0.87302,0.88889),(0.88889,0.88889),(0.90476,0.88889),(0.92063,0.88889),(0.93651,0.88889),(0.95238,0.88889),(0.96825,0.88889),(0.98413,0.88889),(0.99609,0.88889),(0.00391,0.90476),(0.01587,0.90476),(0.03175,0.90476),(0.04762,0.90476),(0.06349,0.90476),(0.07937,0.90476),(0.09524,0.90476),(0.11111,0.90476),(0.12698,0.90476),(0.14286,0.90476),(0.15873,0.90476),(0.1746,0.90476),(0.19048,0.90476),(0.20635,0.90476),(0.22222,0.90476),(0.2381,0.90476),(0.25397,0.90476),(0.26984,0.90476),(0.28571,0.90476),(0.30159,0.90476),(0.31746,0.90476),(0.33333,0.90476),(0.34921,0.90476),(0.36508,0.90476),(0.38095,0.90476),(0.39683,0.90476),(0.4127,0.90476),(0.42857,0.90476),(0.44444,0.90476),(0.46032,0.90476),(0.47619,0.90476),(0.49206,0.90476),(0.50794,0.90476),(0.52381,0.90476),(0.53968,0.90476),(0.55556,0.90476),(0.57143,0.90476),(0.5873,0.90476),(0.60317,0.90476),(0.61905,0.90476),(0.63492,0.90476),(0.65079,0.90476),(0.66667,0.90476),(0.68254,0.90476),(0.69841,0.90476),(0.71429,0.90476),(0.73016,0.90476),(0.74603,0.90476),(0.7619,0.90476),(0.77778,0.90476),(0.79365,0.90476),(0.80952,0.90476),(0.8254,0.90476),(0.84127,0.90476),(0.85714,0.90476),(0.87302,0.90476),(0.88889,0.90476),(0.90476,0.90476),(0.92063,0.90476),(0.93651,0.90476),(0.95238,0.90476),(0.96825,0.90476),(0.98413,0.90476),(0.99609,0.90476),(0.00391,0.92063),(0.01587,0.92063),(0.03175,0.92063),(0.04762,0.92063),(0.06349,0.92063),(0.07937,0.92063),(0.09524,0.92063),(0.11111,0.92063),(0.12698,0.92063),(0.14286,0.92063),(0.15873,0.92063),(0.1746,0.92063),(0.19048,0.92063),(0.20635,0.92063),(0.22222,0.92063),(0.2381,0.92063),(0.25397,0.92063),(0.26984,0.92063),(0.28571,0.92063),(0.30159,0.92063),(0.31746,0.92063),(0.33333,0.92063),(0.34921,0.92063),(0.36508,0.92063),(0.38095,0.92063),(0.39683,0.92063),(0.4127,0.92063),(0.42857,0.92063),(0.44444,0.92063),(0.46032,0.92063),(0.47619,0.92063),(0.49206,0.92063),(0.50794,0.92063),(0.52381,0.92063),(0.53968,0.92063),(0.55556,0.92063),(0.57143,0.92063),(0.5873,0.92063),(0.60317,0.92063),(0.61905,0.92063),(0.63492,0.92063),(0.65079,0.92063),(0.66667,0.92063),(0.68254,0.92063),(0.69841,0.92063),(0.71429,0.92063),(0.73016,0.92063),(0.74603,0.92063),(0.7619,0.92063),(0.77778,0.92063),(0.79365,0.92063),(0.80952,0.92063),(0.8254,0.92063),(0.84127,0.92063),(0.85714,0.92063),(0.87302,0.92063),(0.88889,0.92063),(0.90476,0.92063),(0.92063,0.92063),(0.93651,0.92063),(0.95238,0.92063),(0.96825,0.92063),(0.98413,0.92063),(0.99609,0.92063),(0.00391,0.93651),(0.01587,0.93651),(0.03175,0.93651),(0.04762,0.93651),(0.06349,0.93651),(0.07937,0.93651),(0.09524,0.93651),(0.11111,0.93651),(0.12698,0.93651),(0.14286,0.93651),(0.15873,0.93651),(0.1746,0.93651),(0.19048,0.93651),(0.20635,0.93651),(0.22222,0.93651),(0.2381,0.93651),(0.25397,0.93651),(0.26984,0.93651),(0.28571,0.93651),(0.30159,0.93651),(0.31746,0.93651),(0.33333,0.93651),(0.34921,0.93651),(0.36508,0.93651),(0.38095,0.93651),(0.39683,0.93651),(0.4127,0.93651),(0.42857,0.93651),(0.44444,0.93651),(0.46032,0.93651),(0.47619,0.93651),(0.49206,0.93651),(0.50794,0.93651),(0.52381,0.93651),(0.53968,0.93651),(0.55556,0.93651),(0.57143,0.93651),(0.5873,0.93651),(0.60317,0.93651),(0.61905,0.93651),(0.63492,0.93651),(0.65079,0.93651),(0.66667,0.93651),(0.68254,0.93651),(0.69841,0.93651),(0.71429,0.93651),(0.73016,0.93651),(0.74603,0.93651),(0.7619,0.93651),(0.77778,0.93651),(0.79365,0.93651),(0.80952,0.93651),(0.8254,0.93651),(0.84127,0.93651),(0.85714,0.93651),(0.87302,0.93651),(0.88889,0.93651),(0.90476,0.93651),(0.92063,0.93651),(0.93651,0.93651),(0.95238,0.93651),(0.96825,0.93651),(0.98413,0.93651),(0.99609,0.93651),(0.00391,0.95238),(0.01587,0.95238),(0.03175,0.95238),(0.04762,0.95238),(0.06349,0.95238),(0.07937,0.95238),(0.09524,0.95238),(0.11111,0.95238),(0.12698,0.95238),(0.14286,0.95238),(0.15873,0.95238),(0.1746,0.95238),(0.19048,0.95238),(0.20635,0.95238),(0.22222,0.95238),(0.2381,0.95238),(0.25397,0.95238),(0.26984,0.95238),(0.28571,0.95238),(0.30159,0.95238),(0.31746,0.95238),(0.33333,0.95238),(0.34921,0.95238),(0.36508,0.95238),(0.38095,0.95238),(0.39683,0.95238),(0.4127,0.95238),(0.42857,0.95238),(0.44444,0.95238),(0.46032,0.95238),(0.47619,0.95238),(0.49206,0.95238),(0.50794,0.95238),(0.52381,0.95238),(0.53968,0.95238),(0.55556,0.95238),(0.57143,0.95238),(0.5873,0.95238),(0.60317,0.95238),(0.61905,0.95238),(0.63492,0.95238),(0.65079,0.95238),(0.66667,0.95238),(0.68254,0.95238),(0.69841,0.95238),(0.71429,0.95238),(0.73016,0.95238),(0.74603,0.95238),(0.7619,0.95238),(0.77778,0.95238),(0.79365,0.95238),(0.80952,0.95238),(0.8254,0.95238),(0.84127,0.95238),(0.85714,0.95238),(0.87302,0.95238),(0.88889,0.95238),(0.90476,0.95238),(0.92063,0.95238),(0.93651,0.95238),(0.95238,0.95238),(0.96825,0.95238),(0.98413,0.95238),(0.99609,0.95238),(0.00391,0.96825),(0.01587,0.96825),(0.03175,0.96825),(0.04762,0.96825),(0.06349,0.96825),(0.07937,0.96825),(0.09524,0.96825),(0.11111,0.96825),(0.12698,0.96825),(0.14286,0.96825),(0.15873,0.96825),(0.1746,0.96825),(0.19048,0.96825),(0.20635,0.96825),(0.22222,0.96825),(0.2381,0.96825),(0.25397,0.96825),(0.26984,0.96825),(0.28571,0.96825),(0.30159,0.96825),(0.31746,0.96825),(0.33333,0.96825),(0.34921,0.96825),(0.36508,0.96825),(0.38095,0.96825),(0.39683,0.96825),(0.4127,0.96825),(0.42857,0.96825),(0.44444,0.96825),(0.46032,0.96825),(0.47619,0.96825),(0.49206,0.96825),(0.50794,0.96825),(0.52381,0.96825),(0.53968,0.96825),(0.55556,0.96825),(0.57143,0.96825),(0.5873,0.96825),(0.60317,0.96825),(0.61905,0.96825),(0.63492,0.96825),(0.65079,0.96825),(0.66667,0.96825),(0.68254,0.96825),(0.69841,0.96825),(0.71429,0.96825),(0.73016,0.96825),(0.74603,0.96825),(0.7619,0.96825),(0.77778,0.96825),(0.79365,0.96825),(0.80952,0.96825),(0.8254,0.96825),(0.84127,0.96825),(0.85714,0.96825),(0.87302,0.96825),(0.88889,0.96825),(0.90476,0.96825),(0.92063,0.96825),(0.93651,0.96825),(0.95238,0.96825),(0.96825,0.96825),(0.98413,0.96825),(0.99609,0.96825),(0.00391,0.98413),(0.01587,0.98413),(0.03175,0.98413),(0.04762,0.98413),(0.06349,0.98413),(0.07937,0.98413),(0.09524,0.98413),(0.11111,0.98413),(0.12698,0.98413),(0.14286,0.98413),(0.15873,0.98413),(0.1746,0.98413),(0.19048,0.98413),(0.20635,0.98413),(0.22222,0.98413),(0.2381,0.98413),(0.25397,0.98413),(0.26984,0.98413),(0.28571,0.98413),(0.30159,0.98413),(0.31746,0.98413),(0.33333,0.98413),(0.34921,0.98413),(0.36508,0.98413),(0.38095,0.98413),(0.39683,0.98413),(0.4127,0.98413),(0.42857,0.98413),(0.44444,0.98413),(0.46032,0.98413),(0.47619,0.98413),(0.49206,0.98413),(0.50794,0.98413),(0.52381,0.98413),(0.53968,0.98413),(0.55556,0.98413),(0.57143,0.98413),(0.5873,0.98413),(0.60317,0.98413),(0.61905,0.98413),(0.63492,0.98413),(0.65079,0.98413),(0.66667,0.98413),(0.68254,0.98413),(0.69841,0.98413),(0.71429,0.98413),(0.73016,0.98413),(0.74603,0.98413),(0.7619,0.98413),(0.77778,0.98413),(0.79365,0.98413),(0.80952,0.98413),(0.8254,0.98413),(0.84127,0.98413),(0.85714,0.98413),(0.87302,0.98413),(0.88889,0.98413),(0.90476,0.98413),(0.92063,0.98413),(0.93651,0.98413),(0.95238,0.98413),(0.96825,0.98413),(0.98413,0.98413),(0.99609,0.98413),(0.00391,0.99609),(0.01587,0.99609),(0.03175,0.99609),(0.04762,0.99609),(0.06349,0.99609),(0.07937,0.99609),(0.09524,0.99609),(0.11111,0.99609),(0.12698,0.99609),(0.14286,0.99609),(0.15873,0.99609),(0.1746,0.99609),(0.19048,0.99609),(0.20635,0.99609),(0.22222,0.99609),(0.2381,0.99609),(0.25397,0.99609),(0.26984,0.99609),(0.28571,0.99609),(0.30159,0.99609),(0.31746,0.99609),(0.33333,0.99609),(0.34921,0.99609),(0.36508,0.99609),(0.38095,0.99609),(0.39683,0.99609),(0.4127,0.99609),(0.42857,0.99609),(0.44444,0.99609),(0.46032,0.99609),(0.47619,0.99609),(0.49206,0.99609),(0.50794,0.99609),(0.52381,0.99609),(0.53968,0.99609),(0.55556,0.99609),(0.57143,0.99609),(0.5873,0.99609),(0.60317,0.99609),(0.61905,0.99609),(0.63492,0.99609),(0.65079,0.99609),(0.66667,0.99609),(0.68254,0.99609),(0.69841,0.99609),(0.71429,0.99609),(0.73016,0.99609),(0.74603,0.99609),(0.7619,0.99609),(0.77778,0.99609),(0.79365,0.99609),(0.80952,0.99609),(0.8254,0.99609),(0.84127,0.99609),(0.85714,0.99609),(0.87302,0.99609),(0.88889,0.99609),(0.90476,0.99609),(0.92063,0.99609),(0.93651,0.99609),(0.95238,0.99609),(0.96825,0.99609),(0.98413,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD019.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD019.py load and self-test diagnostics complete.")
