####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD018.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD018.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD018.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD018.x3d'),
    GeoLOD(center=(-45.000000,135.000000,-48925.000000),child1Url=["MarsLOD019.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD019.x3d"],range=3.6E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars006.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars006.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,90.000000,0.000000),height=[3192.7854,3011.0469,2712.232,2766.0854,2953.1072,3090.181,3151.7432,3252.6152,3382.6443,3447.3699,3470.8984,3508.2654,3522.225,3496.8467,3474.5474,3448.9788,3385.8484,3317.163,3270.4885,3242.1968,3182.8135,3107.008,3023.5537,2977.4722,2978.4775,2966.0962,2989.9834,3000.7012,2972.591,2937.4863,2841.9814,2642.84,2452.109,2021.1635,1502.6704,1388.6213,1643.4584,2195.3572,2311.8262,2416.6045,2526.0376,2586.378,2600.6614,2583.1736,2610.2642,2621.409,2640.8938,2650.8909,2618.5059,2476.137,2380.6309,2437.9644,2501.4329,2615.9653,2732.0527,2860.3125,2906.0933,2818.3179,2778.9595,2850.0974,2911.5576,2980.6897,2996.5964,3010.3533,1076.2611,1174.615,1522.2158,1856.8246,2219.43,2442.2488,2416.08,2409.106,2293.0693,2169.329,2156.7642,2105.527,2058.0872,2045.7303,1971.3419,1743.4259,1731.7257,1849.2305,1883.9713,2130.3162,2273.613,2408.4888,2367.906,2392.5073,2593.296,2698.1846,2821.4065,2824.7256,2791.4766,2910.5981,2864.4233,2892.4194,1121.4808,1088.0355,1106.8981,1179.0668,1261.1272,1398.7026,1445.9451,1325.6122,1546.2638,1789.0548,1766.8789,1831.7919,1866.0828,1617.1677,1608.7151,2014.5708,2062.721,2517.9937,2395.6882,2405.1582,2471.7695,2489.977,2556.1487,2603.6409,2586.2695,2600.8655,2582.5137,2539.4697,2657.0308,2627.3882,2505.7346,2402.8655,1466.7389,1573.0309,1699.7845,1890.903,2199.2473,1995.4644,1212.3031,1258.2417,1535.064,1485.7073,1277.4772,1155.5784,1270.6008,1230.3668,1335.6074,2029.4602,2640.7903,2688.9895,2639.1975,2721.182,2629.141,2421.6072,2540.121,2500.5059,2367.1824,2328.9568,2293.6465,2235.2932,2184.8994,2140.0703,2044.4698,2007.3778,1236.245,1397.6812,1484.5269,1612.7151,1780.9469,2041.3513,1856.4323,1701.8533,1551.4193,1319.6519,847.6402,1350.2181,1817.2202,1216.0533,893.65906,919.50397,1451.4061,2052.8652,2051.7468,2136.633,1605.2809,1932.6007,1826.0051,1773.2325,1794.5143,1481.7305,1370.9147,1436.8502,1609.8297,1665.6779,1706.3566,1797.2228,1325.8639,1771.1218,2050.462,1945.8801,1891.6746,1801.6134,1762.0037,1525.6733,1237.4656,1327.8019,1057.6997,1134.6041,1051.5353,1163.6582,891.6419,345.72415,713.01843,460.25125,601.53784,734.02576,861.00726,1085.9303,1117.5212,1233.4531,1626.9926,1451.5068,1141.3877,1106.4851,1339.2517,1512.3916,1600.4741,1585.2982,1715.0715,1904.5546,2313.924,2165.0652,2338.931,2075.8223,1770.144,1687.5128,1813.0374,1874.003,1345.3944,1185.9803,1076.5491,1029.5718,973.738,935.9366,1025.3989,1270.6749,962.67163,949.9856,1073.3871,1132.6058,1070.4192,1122.0255,1225.1482,1566.1935,1364.1283,1466.8799,1669.3702,1674.0306,1863.035,1887.4653,1094.8417,1644.2084,1796.0542,1902.9172,2039.6267,2005.5892,1870.5764,1859.0316,2094.3025,1914.2195,2079.8003,1607.5737,1462.7567,1412.8961,1237.4935,1533.0178,1205.1545,1283.0992,1441.616,1499.1682,1294.2504,1492.9136,1617.1162,1481.593,1285.9171,1254.2771,1381.9252,1537.4902,1429.9742,1578.0964,1643.1421,1715.2054,697.8216,1288.3761,1596.056,1706.7288,1892.0715,2101.657,1914.4259,1932.3949,2140.8794,2223.6145,2083.8577,1785.8942,1572.4232,1803.0219,1557.906,762.34406,423.13605,517.58936,755.97394,1084.1715,1359.5515,1599.881,1986.5782,2051.229,1858.664,2002.778,1519.6235,1427.9677,1781.5181,1947.9503,1565.91,1400.1796,101.491936,769.1357,1843.2949,2111.0042,1136.9789,1104.7133,2220.7817,1448.7941,1944.3427,2362.0981,2138.5093,1857.6848,1790.8142,1533.339,1064.4044,798.8067,650.2572,807.6924,708.9317,664.17847,890.1143,1328.5693,1766.4366,2009.7979,1948.292,2005.35,2324.3643,2122.706,1716.1432,1645.0586,1525.5687,1326.8035,-450.96268,-57.12169,428.69138,1147.928,995.1662,1383.256,1763.1788,1864.5109,1957.8939,1937.107,1773.2814,1293.0422,1133.8263,814.03766,1122.799,1100.8326,1307.1796,1806.4606,979.785,888.6278,1125.7812,1620.4336,1827.0447,1749.7983,1535.9259,1748.8284,2140.774,1705.239,1818.058,1987.0869,1830.3444,1461.2772,-835.88513,-950.9588,-328.18503,776.07935,905.1226,1598.1146,1720.3542,1450.7303,1010.313,1437.9454,1512.5585,1497.5557,1294.5293,742.3112,349.8188,1026.6943,1462.4789,721.75745,947.4481,963.57855,960.1774,1379.659,1544.9584,1694.8363,1556.0547,1450.049,1873.6859,2092.1104,2085.5127,1526.9005,1290.2557,1028.9412,-3310.8457,-1425.1804,7.766452,319.91806,459.77338,1153.8544,1335.9182,1620.729,1775.6167,1296.2198,1250.8606,1153.7018,998.64996,1242.9149,1429.8324,1098.7965,1168.8767,1221.1091,1328.2886,1606.3984,1314.0889,1237.7931,1237.556,1062.1991,1227.7904,964.875,1346.5723,1671.6415,1995.7155,1953.3206,1769.928,1457.0549,-5360.393,-3722.1223,-1727.0627,-688.06934,-274.32672,158.68005,1132.2961,910.7391,1215.4633,1159.6606,1050.5426,1204.6464,1443.5259,1670.401,1630.5098,1447.2625,1677.9061,2342.379,1554.9897,1425.266,1714.9196,1450.3817,945.70416,798.28235,721.1241,722.8449,934.54224,1621.0345,1889.1155,2016.4688,1996.8215,1821.9868,-5559.7188,-4751.8916,-3067.7834,-1377.3633,-633.09064,-536.5658,293.98035,781.21826,821.13513,1045.6119,1146.3364,1078.8263,1350.5145,1515.59,1635.788,1835.7728,1987.056,2373.7358,2347.9956,2099.1365,1300.7688,665.7927,886.835,886.2489,970.2128,1020.8,1135.4025,1882.9222,1715.1904,2239.1877,2136.523,1675.1582,-5070.235,-4539.999,-3282.5637,-1864.5464,-1263.6736,-601.3034,-13.040279,783.06903,820.34515,888.20874,804.12836,716.56903,763.6706,1261.9862,1598.8384,1810.6132,1836.4573,1754.0745,2035.9104,2028.5575,1214.283,582.4367,724.4909,763.79285,1391.0599,1143.2488,1723.5521,2020.392,1501.1422,1473.306,1512.2793,1065.2537,-4604.98,-4067.0159,-3505.2703,-1618.5497,-577.978,140.79497,644.7158,696.6608,568.6883,534.4441,1020.6733,687.10876,556.1003,1033.5293,1366.1282,1277.913,1595.9962,1360.8555,1573.5043,1829.0083,1667.9503,1340.8922,973.3405,664.7316,1204.9292,1095.0969,1237.7797,1000.2646,1010.71716,1299.0062,992.243,751.7742,-3876.5566,-3404.109,-2526.3918,-1613.7827,-456.08017,614.49945,943.21295,1053.952,782.92163,603.062,514.83746,598.9192,823.62897,1089.927,1120.1569,1098.7097,1270.34,1185.2367,1442.0369,1529.3547,1722.1161,1408.0521,1251.8259,1048.2429,1140.1432,987.39575,679.89966,907.12933,962.0109,1093.0425,261.17664,395.85187,-2606.1008,-2656.1938,-2465.412,-1779.0892,-824.8255,435.14752,937.8686,1195.4675,1122.9812,992.90466,852.6729,771.57227,1409.2555,1521.2561,1957.4976,1919.74,1884.857,1716.8248,1500.184,1285.7003,1501.7252,1402.8741,1437.7897,1147.2035,1063.5015,1254.2996,799.82745,1174.7937,979.2926,692.7821,423.09616,888.3867,-1589.7743,-1147.6117,-1575.6746,-1027.2194,-449.9427,752.72253,1026.2292,1170.2122,1369.6135,1293.138,1262.3759,1077.959,1427.7678,1431.3394,1786.8152,2074.994,2151.43,2349.3076,1925.8776,1039.1249,1078.6163,1083.9294,1145.3368,892.44464,854.84436,1054.2805,1077.046,1168.9425,1060.6152,1045.767,908.31866,847.07434,-782.6826,-294.6773,-523.7231,-174.9294,662.6366,928.8679,1155.8771,1224.4087,1298.6162,1273.4281,1335.1157,1308.0234,1607.9623,2055.622,2010.6545,2119.4956,2460.5059,2193.9673,1928.791,1473.756,1086.4447,918.01495,1340.8314,932.14014,923.70276,941.19354,1081.5261,1516.6387,1518.631,1203.7081,1187.3422,855.40875,-29.19768,1020.99243,661.461,1466.9663,1355.1492,1586.0211,1662.1978,1533.3469,1479.4911,1367.0133,1480.9185,1566.2589,1745.2942,2224.8394,2396.2798,2099.4053,2159.766,2631.2502,2231.9382,1999.41,1438.5929,1323.8434,1391.5177,1109.7738,1057.4291,823.6016,1352.0142,1744.7373,1260.7646,1627.3164,1095.8035,533.4671,1158.1843,2178.1614,2372.173,1755.7678,1587.8138,1897.6655,2126.9207,1631.7206,1494.3761,1427.7476,1603.119,1810.2593,1846.7054,1886.6152,1737.027,2174.7124,1967.5458,2460.0547,2182.3774,2039.9062,1674.3398,1357.1978,1215.7684,1092.7511,1098.4591,653.70325,756.2677,1106.5887,958.44305,1124.0984,1046.8201,525.31104,1655.5524,2239.8484,2668.946,1988.8159,1696.5006,1636.2228,1618.8479,1545.033,1492.7223,1490.4,1622.2009,1871.0905,2113.1208,2293.2566,1751.862,1785.5354,1915.2949,2221.0894,1827.1609,1860.925,1953.0334,1737.4642,1488.4535,1534.9084,1133.4714,236.03804,-87.65104,-204.88603,-180.5919,228.75484,660.0002,686.5624,2000.5836,2321.4453,2553.2349,2072.6968,1626.9874,1439.3866,1364.5256,1454.9539,1527.2551,1614.3759,1732.5754,1875.8765,1877.1364,2225.2666,1853.2312,1951.9348,1828.7313,1684.3016,1579.3363,1706.1545,1982.5117,1798.572,1845.8645,1587.4865,1035.4517,41.422035,-637.018,-849.9458,-883.66724,-716.3511,-303.17264,65.42465,2381.5151,2548.7053,2493.459,1888.8853,1588.4182,1430.6448,1415.3644,1372.81,1483.608,1692.863,1948.721,1901.7188,1932.3127,2208.8008,1684.7855,1677.0135,1838.5481,1667.8132,1625.2859,1620.3705,1961.7648,1770.8289,1065.0155,940.72565,451.99442,-635.4799,-1318.6727,-1372.0702,-1194.0344,-1608.9211,-1514.3248,-966.6385,2368.0818,2438.4,2060.2173,1716.6003,1351.2355,1291.1652,1426.2812,1294.0485,1434.0072,1521.5615,1697.8097,1793.3545,2159.6208,2405.1306,2245.0605,1884.3083,1533.4733,1643.2255,1268.6758,962.41345,826.5205,958.2356,266.84518,227.99843,-263.55475,-1122.7823,-1592.6357,-1821.9888,-1920.8335,-2161.891,-1785.8374,-1502.9979,2134.7854,2048.478,1574.5823,1765.7749,1258.5348,1105.513,1012.88806,1063.0935,1081.0443,1101.5933,1118.4569,1993.5529,2564.961,2314.1821,1660.5717,1285.1351,756.54803,583.0671,335.30768,-796.88324,-1020.31287,-789.27515,-1303.7954,-1241.965,-1596.3762,-1670.9773,-1958.7408,-2218.2983,-2543.8188,-2703.4636,-726.5845,-1374.7562,1795.6886,1688.0065,1268.2556,1409.193,1295.547,1032.9043,550.6254,543.1039,509.96094,428.12805,764.16144,1475.5901,2132.107,1698.336,1581.0806,563.2153,-727.1067,-2008.298,-1442.4547,-1407.5706,-1451.6598,-1751.6488,-2275.9968,-2179.1743,-2194.7732,-2297.1484,-2342.0876,-2664.3418,-2701.896,-2817.5273,-2470.2258,-2066.2295,991.4003,1005.3961,993.2529,1093.4708,1199.936,662.47565,-26.555382,201.67513,-172.539,107.43727,854.4398,1385.8564,1425.3867,1241.5425,1015.9035,-466.55063,-2075.7007,-2413.5503,-1948.497,-2047.6704,-1915.9795,-2022.9781,-2421.9106,-2093.7039,-2510.4607,-2717.0881,-2827.5723,-2935.264,-2973.7737,-2950.448,-2840.2522,-2459.808,39.084858,282.788,387.9909,674.91724,372.6384,20.41758,-547.06384,-619.8989,-250.39296,239.92792,534.36127,876.9392,352.05145,-625.56104,-911.2202,-1950.1691,-2427.954,-2426.8936,-2548.037,-2445.3342,-2282.4807,-2458.5657,-2205.5034,-2245.136,-2705.8904,-2822.843,-2891.253,-2934.0051,-2990.9263,-2967.4321,-2924.6506,-2733.158],solid=False,xDimension=32,xSpacing=2.903226,yScale=50.0,zDimension=32,zSpacing=2.903226,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.03226,0.00391),(0.06452,0.00391),(0.09677,0.00391),(0.12903,0.00391),(0.16129,0.00391),(0.19355,0.00391),(0.22581,0.00391),(0.25806,0.00391),(0.29032,0.00391),(0.32258,0.00391),(0.35484,0.00391),(0.3871,0.00391),(0.41935,0.00391),(0.45161,0.00391),(0.48387,0.00391),(0.51613,0.00391),(0.54839,0.00391),(0.58065,0.00391),(0.6129,0.00391),(0.64516,0.00391),(0.67742,0.00391),(0.70968,0.00391),(0.74194,0.00391),(0.77419,0.00391),(0.80645,0.00391),(0.83871,0.00391),(0.87097,0.00391),(0.90323,0.00391),(0.93548,0.00391),(0.96774,0.00391),(0.99609,0.00391),(0.00391,0.03226),(0.03226,0.03226),(0.06452,0.03226),(0.09677,0.03226),(0.12903,0.03226),(0.16129,0.03226),(0.19355,0.03226),(0.22581,0.03226),(0.25806,0.03226),(0.29032,0.03226),(0.32258,0.03226),(0.35484,0.03226),(0.3871,0.03226),(0.41935,0.03226),(0.45161,0.03226),(0.48387,0.03226),(0.51613,0.03226),(0.54839,0.03226),(0.58065,0.03226),(0.6129,0.03226),(0.64516,0.03226),(0.67742,0.03226),(0.70968,0.03226),(0.74194,0.03226),(0.77419,0.03226),(0.80645,0.03226),(0.83871,0.03226),(0.87097,0.03226),(0.90323,0.03226),(0.93548,0.03226),(0.96774,0.03226),(0.99609,0.03226),(0.00391,0.06452),(0.03226,0.06452),(0.06452,0.06452),(0.09677,0.06452),(0.12903,0.06452),(0.16129,0.06452),(0.19355,0.06452),(0.22581,0.06452),(0.25806,0.06452),(0.29032,0.06452),(0.32258,0.06452),(0.35484,0.06452),(0.3871,0.06452),(0.41935,0.06452),(0.45161,0.06452),(0.48387,0.06452),(0.51613,0.06452),(0.54839,0.06452),(0.58065,0.06452),(0.6129,0.06452),(0.64516,0.06452),(0.67742,0.06452),(0.70968,0.06452),(0.74194,0.06452),(0.77419,0.06452),(0.80645,0.06452),(0.83871,0.06452),(0.87097,0.06452),(0.90323,0.06452),(0.93548,0.06452),(0.96774,0.06452),(0.99609,0.06452),(0.00391,0.09677),(0.03226,0.09677),(0.06452,0.09677),(0.09677,0.09677),(0.12903,0.09677),(0.16129,0.09677),(0.19355,0.09677),(0.22581,0.09677),(0.25806,0.09677),(0.29032,0.09677),(0.32258,0.09677),(0.35484,0.09677),(0.3871,0.09677),(0.41935,0.09677),(0.45161,0.09677),(0.48387,0.09677),(0.51613,0.09677),(0.54839,0.09677),(0.58065,0.09677),(0.6129,0.09677),(0.64516,0.09677),(0.67742,0.09677),(0.70968,0.09677),(0.74194,0.09677),(0.77419,0.09677),(0.80645,0.09677),(0.83871,0.09677),(0.87097,0.09677),(0.90323,0.09677),(0.93548,0.09677),(0.96774,0.09677),(0.99609,0.09677),(0.00391,0.12903),(0.03226,0.12903),(0.06452,0.12903),(0.09677,0.12903),(0.12903,0.12903),(0.16129,0.12903),(0.19355,0.12903),(0.22581,0.12903),(0.25806,0.12903),(0.29032,0.12903),(0.32258,0.12903),(0.35484,0.12903),(0.3871,0.12903),(0.41935,0.12903),(0.45161,0.12903),(0.48387,0.12903),(0.51613,0.12903),(0.54839,0.12903),(0.58065,0.12903),(0.6129,0.12903),(0.64516,0.12903),(0.67742,0.12903),(0.70968,0.12903),(0.74194,0.12903),(0.77419,0.12903),(0.80645,0.12903),(0.83871,0.12903),(0.87097,0.12903),(0.90323,0.12903),(0.93548,0.12903),(0.96774,0.12903),(0.99609,0.12903),(0.00391,0.16129),(0.03226,0.16129),(0.06452,0.16129),(0.09677,0.16129),(0.12903,0.16129),(0.16129,0.16129),(0.19355,0.16129),(0.22581,0.16129),(0.25806,0.16129),(0.29032,0.16129),(0.32258,0.16129),(0.35484,0.16129),(0.3871,0.16129),(0.41935,0.16129),(0.45161,0.16129),(0.48387,0.16129),(0.51613,0.16129),(0.54839,0.16129),(0.58065,0.16129),(0.6129,0.16129),(0.64516,0.16129),(0.67742,0.16129),(0.70968,0.16129),(0.74194,0.16129),(0.77419,0.16129),(0.80645,0.16129),(0.83871,0.16129),(0.87097,0.16129),(0.90323,0.16129),(0.93548,0.16129),(0.96774,0.16129),(0.99609,0.16129),(0.00391,0.19355),(0.03226,0.19355),(0.06452,0.19355),(0.09677,0.19355),(0.12903,0.19355),(0.16129,0.19355),(0.19355,0.19355),(0.22581,0.19355),(0.25806,0.19355),(0.29032,0.19355),(0.32258,0.19355),(0.35484,0.19355),(0.3871,0.19355),(0.41935,0.19355),(0.45161,0.19355),(0.48387,0.19355),(0.51613,0.19355),(0.54839,0.19355),(0.58065,0.19355),(0.6129,0.19355),(0.64516,0.19355),(0.67742,0.19355),(0.70968,0.19355),(0.74194,0.19355),(0.77419,0.19355),(0.80645,0.19355),(0.83871,0.19355),(0.87097,0.19355),(0.90323,0.19355),(0.93548,0.19355),(0.96774,0.19355),(0.99609,0.19355),(0.00391,0.22581),(0.03226,0.22581),(0.06452,0.22581),(0.09677,0.22581),(0.12903,0.22581),(0.16129,0.22581),(0.19355,0.22581),(0.22581,0.22581),(0.25806,0.22581),(0.29032,0.22581),(0.32258,0.22581),(0.35484,0.22581),(0.3871,0.22581),(0.41935,0.22581),(0.45161,0.22581),(0.48387,0.22581),(0.51613,0.22581),(0.54839,0.22581),(0.58065,0.22581),(0.6129,0.22581),(0.64516,0.22581),(0.67742,0.22581),(0.70968,0.22581),(0.74194,0.22581),(0.77419,0.22581),(0.80645,0.22581),(0.83871,0.22581),(0.87097,0.22581),(0.90323,0.22581),(0.93548,0.22581),(0.96774,0.22581),(0.99609,0.22581),(0.00391,0.25806),(0.03226,0.25806),(0.06452,0.25806),(0.09677,0.25806),(0.12903,0.25806),(0.16129,0.25806),(0.19355,0.25806),(0.22581,0.25806),(0.25806,0.25806),(0.29032,0.25806),(0.32258,0.25806),(0.35484,0.25806),(0.3871,0.25806),(0.41935,0.25806),(0.45161,0.25806),(0.48387,0.25806),(0.51613,0.25806),(0.54839,0.25806),(0.58065,0.25806),(0.6129,0.25806),(0.64516,0.25806),(0.67742,0.25806),(0.70968,0.25806),(0.74194,0.25806),(0.77419,0.25806),(0.80645,0.25806),(0.83871,0.25806),(0.87097,0.25806),(0.90323,0.25806),(0.93548,0.25806),(0.96774,0.25806),(0.99609,0.25806),(0.00391,0.29032),(0.03226,0.29032),(0.06452,0.29032),(0.09677,0.29032),(0.12903,0.29032),(0.16129,0.29032),(0.19355,0.29032),(0.22581,0.29032),(0.25806,0.29032),(0.29032,0.29032),(0.32258,0.29032),(0.35484,0.29032),(0.3871,0.29032),(0.41935,0.29032),(0.45161,0.29032),(0.48387,0.29032),(0.51613,0.29032),(0.54839,0.29032),(0.58065,0.29032),(0.6129,0.29032),(0.64516,0.29032),(0.67742,0.29032),(0.70968,0.29032),(0.74194,0.29032),(0.77419,0.29032),(0.80645,0.29032),(0.83871,0.29032),(0.87097,0.29032),(0.90323,0.29032),(0.93548,0.29032),(0.96774,0.29032),(0.99609,0.29032),(0.00391,0.32258),(0.03226,0.32258),(0.06452,0.32258),(0.09677,0.32258),(0.12903,0.32258),(0.16129,0.32258),(0.19355,0.32258),(0.22581,0.32258),(0.25806,0.32258),(0.29032,0.32258),(0.32258,0.32258),(0.35484,0.32258),(0.3871,0.32258),(0.41935,0.32258),(0.45161,0.32258),(0.48387,0.32258),(0.51613,0.32258),(0.54839,0.32258),(0.58065,0.32258),(0.6129,0.32258),(0.64516,0.32258),(0.67742,0.32258),(0.70968,0.32258),(0.74194,0.32258),(0.77419,0.32258),(0.80645,0.32258),(0.83871,0.32258),(0.87097,0.32258),(0.90323,0.32258),(0.93548,0.32258),(0.96774,0.32258),(0.99609,0.32258),(0.00391,0.35484),(0.03226,0.35484),(0.06452,0.35484),(0.09677,0.35484),(0.12903,0.35484),(0.16129,0.35484),(0.19355,0.35484),(0.22581,0.35484),(0.25806,0.35484),(0.29032,0.35484),(0.32258,0.35484),(0.35484,0.35484),(0.3871,0.35484),(0.41935,0.35484),(0.45161,0.35484),(0.48387,0.35484),(0.51613,0.35484),(0.54839,0.35484),(0.58065,0.35484),(0.6129,0.35484),(0.64516,0.35484),(0.67742,0.35484),(0.70968,0.35484),(0.74194,0.35484),(0.77419,0.35484),(0.80645,0.35484),(0.83871,0.35484),(0.87097,0.35484),(0.90323,0.35484),(0.93548,0.35484),(0.96774,0.35484),(0.99609,0.35484),(0.00391,0.3871),(0.03226,0.3871),(0.06452,0.3871),(0.09677,0.3871),(0.12903,0.3871),(0.16129,0.3871),(0.19355,0.3871),(0.22581,0.3871),(0.25806,0.3871),(0.29032,0.3871),(0.32258,0.3871),(0.35484,0.3871),(0.3871,0.3871),(0.41935,0.3871),(0.45161,0.3871),(0.48387,0.3871),(0.51613,0.3871),(0.54839,0.3871),(0.58065,0.3871),(0.6129,0.3871),(0.64516,0.3871),(0.67742,0.3871),(0.70968,0.3871),(0.74194,0.3871),(0.77419,0.3871),(0.80645,0.3871),(0.83871,0.3871),(0.87097,0.3871),(0.90323,0.3871),(0.93548,0.3871),(0.96774,0.3871),(0.99609,0.3871),(0.00391,0.41935),(0.03226,0.41935),(0.06452,0.41935),(0.09677,0.41935),(0.12903,0.41935),(0.16129,0.41935),(0.19355,0.41935),(0.22581,0.41935),(0.25806,0.41935),(0.29032,0.41935),(0.32258,0.41935),(0.35484,0.41935),(0.3871,0.41935),(0.41935,0.41935),(0.45161,0.41935),(0.48387,0.41935),(0.51613,0.41935),(0.54839,0.41935),(0.58065,0.41935),(0.6129,0.41935),(0.64516,0.41935),(0.67742,0.41935),(0.70968,0.41935),(0.74194,0.41935),(0.77419,0.41935),(0.80645,0.41935),(0.83871,0.41935),(0.87097,0.41935),(0.90323,0.41935),(0.93548,0.41935),(0.96774,0.41935),(0.99609,0.41935),(0.00391,0.45161),(0.03226,0.45161),(0.06452,0.45161),(0.09677,0.45161),(0.12903,0.45161),(0.16129,0.45161),(0.19355,0.45161),(0.22581,0.45161),(0.25806,0.45161),(0.29032,0.45161),(0.32258,0.45161),(0.35484,0.45161),(0.3871,0.45161),(0.41935,0.45161),(0.45161,0.45161),(0.48387,0.45161),(0.51613,0.45161),(0.54839,0.45161),(0.58065,0.45161),(0.6129,0.45161),(0.64516,0.45161),(0.67742,0.45161),(0.70968,0.45161),(0.74194,0.45161),(0.77419,0.45161),(0.80645,0.45161),(0.83871,0.45161),(0.87097,0.45161),(0.90323,0.45161),(0.93548,0.45161),(0.96774,0.45161),(0.99609,0.45161),(0.00391,0.48387),(0.03226,0.48387),(0.06452,0.48387),(0.09677,0.48387),(0.12903,0.48387),(0.16129,0.48387),(0.19355,0.48387),(0.22581,0.48387),(0.25806,0.48387),(0.29032,0.48387),(0.32258,0.48387),(0.35484,0.48387),(0.3871,0.48387),(0.41935,0.48387),(0.45161,0.48387),(0.48387,0.48387),(0.51613,0.48387),(0.54839,0.48387),(0.58065,0.48387),(0.6129,0.48387),(0.64516,0.48387),(0.67742,0.48387),(0.70968,0.48387),(0.74194,0.48387),(0.77419,0.48387),(0.80645,0.48387),(0.83871,0.48387),(0.87097,0.48387),(0.90323,0.48387),(0.93548,0.48387),(0.96774,0.48387),(0.99609,0.48387),(0.00391,0.51613),(0.03226,0.51613),(0.06452,0.51613),(0.09677,0.51613),(0.12903,0.51613),(0.16129,0.51613),(0.19355,0.51613),(0.22581,0.51613),(0.25806,0.51613),(0.29032,0.51613),(0.32258,0.51613),(0.35484,0.51613),(0.3871,0.51613),(0.41935,0.51613),(0.45161,0.51613),(0.48387,0.51613),(0.51613,0.51613),(0.54839,0.51613),(0.58065,0.51613),(0.6129,0.51613),(0.64516,0.51613),(0.67742,0.51613),(0.70968,0.51613),(0.74194,0.51613),(0.77419,0.51613),(0.80645,0.51613),(0.83871,0.51613),(0.87097,0.51613),(0.90323,0.51613),(0.93548,0.51613),(0.96774,0.51613),(0.99609,0.51613),(0.00391,0.54839),(0.03226,0.54839),(0.06452,0.54839),(0.09677,0.54839),(0.12903,0.54839),(0.16129,0.54839),(0.19355,0.54839),(0.22581,0.54839),(0.25806,0.54839),(0.29032,0.54839),(0.32258,0.54839),(0.35484,0.54839),(0.3871,0.54839),(0.41935,0.54839),(0.45161,0.54839),(0.48387,0.54839),(0.51613,0.54839),(0.54839,0.54839),(0.58065,0.54839),(0.6129,0.54839),(0.64516,0.54839),(0.67742,0.54839),(0.70968,0.54839),(0.74194,0.54839),(0.77419,0.54839),(0.80645,0.54839),(0.83871,0.54839),(0.87097,0.54839),(0.90323,0.54839),(0.93548,0.54839),(0.96774,0.54839),(0.99609,0.54839),(0.00391,0.58065),(0.03226,0.58065),(0.06452,0.58065),(0.09677,0.58065),(0.12903,0.58065),(0.16129,0.58065),(0.19355,0.58065),(0.22581,0.58065),(0.25806,0.58065),(0.29032,0.58065),(0.32258,0.58065),(0.35484,0.58065),(0.3871,0.58065),(0.41935,0.58065),(0.45161,0.58065),(0.48387,0.58065),(0.51613,0.58065),(0.54839,0.58065),(0.58065,0.58065),(0.6129,0.58065),(0.64516,0.58065),(0.67742,0.58065),(0.70968,0.58065),(0.74194,0.58065),(0.77419,0.58065),(0.80645,0.58065),(0.83871,0.58065),(0.87097,0.58065),(0.90323,0.58065),(0.93548,0.58065),(0.96774,0.58065),(0.99609,0.58065),(0.00391,0.6129),(0.03226,0.6129),(0.06452,0.6129),(0.09677,0.6129),(0.12903,0.6129),(0.16129,0.6129),(0.19355,0.6129),(0.22581,0.6129),(0.25806,0.6129),(0.29032,0.6129),(0.32258,0.6129),(0.35484,0.6129),(0.3871,0.6129),(0.41935,0.6129),(0.45161,0.6129),(0.48387,0.6129),(0.51613,0.6129),(0.54839,0.6129),(0.58065,0.6129),(0.6129,0.6129),(0.64516,0.6129),(0.67742,0.6129),(0.70968,0.6129),(0.74194,0.6129),(0.77419,0.6129),(0.80645,0.6129),(0.83871,0.6129),(0.87097,0.6129),(0.90323,0.6129),(0.93548,0.6129),(0.96774,0.6129),(0.99609,0.6129),(0.00391,0.64516),(0.03226,0.64516),(0.06452,0.64516),(0.09677,0.64516),(0.12903,0.64516),(0.16129,0.64516),(0.19355,0.64516),(0.22581,0.64516),(0.25806,0.64516),(0.29032,0.64516),(0.32258,0.64516),(0.35484,0.64516),(0.3871,0.64516),(0.41935,0.64516),(0.45161,0.64516),(0.48387,0.64516),(0.51613,0.64516),(0.54839,0.64516),(0.58065,0.64516),(0.6129,0.64516),(0.64516,0.64516),(0.67742,0.64516),(0.70968,0.64516),(0.74194,0.64516),(0.77419,0.64516),(0.80645,0.64516),(0.83871,0.64516),(0.87097,0.64516),(0.90323,0.64516),(0.93548,0.64516),(0.96774,0.64516),(0.99609,0.64516),(0.00391,0.67742),(0.03226,0.67742),(0.06452,0.67742),(0.09677,0.67742),(0.12903,0.67742),(0.16129,0.67742),(0.19355,0.67742),(0.22581,0.67742),(0.25806,0.67742),(0.29032,0.67742),(0.32258,0.67742),(0.35484,0.67742),(0.3871,0.67742),(0.41935,0.67742),(0.45161,0.67742),(0.48387,0.67742),(0.51613,0.67742),(0.54839,0.67742),(0.58065,0.67742),(0.6129,0.67742),(0.64516,0.67742),(0.67742,0.67742),(0.70968,0.67742),(0.74194,0.67742),(0.77419,0.67742),(0.80645,0.67742),(0.83871,0.67742),(0.87097,0.67742),(0.90323,0.67742),(0.93548,0.67742),(0.96774,0.67742),(0.99609,0.67742),(0.00391,0.70968),(0.03226,0.70968),(0.06452,0.70968),(0.09677,0.70968),(0.12903,0.70968),(0.16129,0.70968),(0.19355,0.70968),(0.22581,0.70968),(0.25806,0.70968),(0.29032,0.70968),(0.32258,0.70968),(0.35484,0.70968),(0.3871,0.70968),(0.41935,0.70968),(0.45161,0.70968),(0.48387,0.70968),(0.51613,0.70968),(0.54839,0.70968),(0.58065,0.70968),(0.6129,0.70968),(0.64516,0.70968),(0.67742,0.70968),(0.70968,0.70968),(0.74194,0.70968),(0.77419,0.70968),(0.80645,0.70968),(0.83871,0.70968),(0.87097,0.70968),(0.90323,0.70968),(0.93548,0.70968),(0.96774,0.70968),(0.99609,0.70968),(0.00391,0.74194),(0.03226,0.74194),(0.06452,0.74194),(0.09677,0.74194),(0.12903,0.74194),(0.16129,0.74194),(0.19355,0.74194),(0.22581,0.74194),(0.25806,0.74194),(0.29032,0.74194),(0.32258,0.74194),(0.35484,0.74194),(0.3871,0.74194),(0.41935,0.74194),(0.45161,0.74194),(0.48387,0.74194),(0.51613,0.74194),(0.54839,0.74194),(0.58065,0.74194),(0.6129,0.74194),(0.64516,0.74194),(0.67742,0.74194),(0.70968,0.74194),(0.74194,0.74194),(0.77419,0.74194),(0.80645,0.74194),(0.83871,0.74194),(0.87097,0.74194),(0.90323,0.74194),(0.93548,0.74194),(0.96774,0.74194),(0.99609,0.74194),(0.00391,0.77419),(0.03226,0.77419),(0.06452,0.77419),(0.09677,0.77419),(0.12903,0.77419),(0.16129,0.77419),(0.19355,0.77419),(0.22581,0.77419),(0.25806,0.77419),(0.29032,0.77419),(0.32258,0.77419),(0.35484,0.77419),(0.3871,0.77419),(0.41935,0.77419),(0.45161,0.77419),(0.48387,0.77419),(0.51613,0.77419),(0.54839,0.77419),(0.58065,0.77419),(0.6129,0.77419),(0.64516,0.77419),(0.67742,0.77419),(0.70968,0.77419),(0.74194,0.77419),(0.77419,0.77419),(0.80645,0.77419),(0.83871,0.77419),(0.87097,0.77419),(0.90323,0.77419),(0.93548,0.77419),(0.96774,0.77419),(0.99609,0.77419),(0.00391,0.80645),(0.03226,0.80645),(0.06452,0.80645),(0.09677,0.80645),(0.12903,0.80645),(0.16129,0.80645),(0.19355,0.80645),(0.22581,0.80645),(0.25806,0.80645),(0.29032,0.80645),(0.32258,0.80645),(0.35484,0.80645),(0.3871,0.80645),(0.41935,0.80645),(0.45161,0.80645),(0.48387,0.80645),(0.51613,0.80645),(0.54839,0.80645),(0.58065,0.80645),(0.6129,0.80645),(0.64516,0.80645),(0.67742,0.80645),(0.70968,0.80645),(0.74194,0.80645),(0.77419,0.80645),(0.80645,0.80645),(0.83871,0.80645),(0.87097,0.80645),(0.90323,0.80645),(0.93548,0.80645),(0.96774,0.80645),(0.99609,0.80645),(0.00391,0.83871),(0.03226,0.83871),(0.06452,0.83871),(0.09677,0.83871),(0.12903,0.83871),(0.16129,0.83871),(0.19355,0.83871),(0.22581,0.83871),(0.25806,0.83871),(0.29032,0.83871),(0.32258,0.83871),(0.35484,0.83871),(0.3871,0.83871),(0.41935,0.83871),(0.45161,0.83871),(0.48387,0.83871),(0.51613,0.83871),(0.54839,0.83871),(0.58065,0.83871),(0.6129,0.83871),(0.64516,0.83871),(0.67742,0.83871),(0.70968,0.83871),(0.74194,0.83871),(0.77419,0.83871),(0.80645,0.83871),(0.83871,0.83871),(0.87097,0.83871),(0.90323,0.83871),(0.93548,0.83871),(0.96774,0.83871),(0.99609,0.83871),(0.00391,0.87097),(0.03226,0.87097),(0.06452,0.87097),(0.09677,0.87097),(0.12903,0.87097),(0.16129,0.87097),(0.19355,0.87097),(0.22581,0.87097),(0.25806,0.87097),(0.29032,0.87097),(0.32258,0.87097),(0.35484,0.87097),(0.3871,0.87097),(0.41935,0.87097),(0.45161,0.87097),(0.48387,0.87097),(0.51613,0.87097),(0.54839,0.87097),(0.58065,0.87097),(0.6129,0.87097),(0.64516,0.87097),(0.67742,0.87097),(0.70968,0.87097),(0.74194,0.87097),(0.77419,0.87097),(0.80645,0.87097),(0.83871,0.87097),(0.87097,0.87097),(0.90323,0.87097),(0.93548,0.87097),(0.96774,0.87097),(0.99609,0.87097),(0.00391,0.90323),(0.03226,0.90323),(0.06452,0.90323),(0.09677,0.90323),(0.12903,0.90323),(0.16129,0.90323),(0.19355,0.90323),(0.22581,0.90323),(0.25806,0.90323),(0.29032,0.90323),(0.32258,0.90323),(0.35484,0.90323),(0.3871,0.90323),(0.41935,0.90323),(0.45161,0.90323),(0.48387,0.90323),(0.51613,0.90323),(0.54839,0.90323),(0.58065,0.90323),(0.6129,0.90323),(0.64516,0.90323),(0.67742,0.90323),(0.70968,0.90323),(0.74194,0.90323),(0.77419,0.90323),(0.80645,0.90323),(0.83871,0.90323),(0.87097,0.90323),(0.90323,0.90323),(0.93548,0.90323),(0.96774,0.90323),(0.99609,0.90323),(0.00391,0.93548),(0.03226,0.93548),(0.06452,0.93548),(0.09677,0.93548),(0.12903,0.93548),(0.16129,0.93548),(0.19355,0.93548),(0.22581,0.93548),(0.25806,0.93548),(0.29032,0.93548),(0.32258,0.93548),(0.35484,0.93548),(0.3871,0.93548),(0.41935,0.93548),(0.45161,0.93548),(0.48387,0.93548),(0.51613,0.93548),(0.54839,0.93548),(0.58065,0.93548),(0.6129,0.93548),(0.64516,0.93548),(0.67742,0.93548),(0.70968,0.93548),(0.74194,0.93548),(0.77419,0.93548),(0.80645,0.93548),(0.83871,0.93548),(0.87097,0.93548),(0.90323,0.93548),(0.93548,0.93548),(0.96774,0.93548),(0.99609,0.93548),(0.00391,0.96774),(0.03226,0.96774),(0.06452,0.96774),(0.09677,0.96774),(0.12903,0.96774),(0.16129,0.96774),(0.19355,0.96774),(0.22581,0.96774),(0.25806,0.96774),(0.29032,0.96774),(0.32258,0.96774),(0.35484,0.96774),(0.3871,0.96774),(0.41935,0.96774),(0.45161,0.96774),(0.48387,0.96774),(0.51613,0.96774),(0.54839,0.96774),(0.58065,0.96774),(0.6129,0.96774),(0.64516,0.96774),(0.67742,0.96774),(0.70968,0.96774),(0.74194,0.96774),(0.77419,0.96774),(0.80645,0.96774),(0.83871,0.96774),(0.87097,0.96774),(0.90323,0.96774),(0.93548,0.96774),(0.96774,0.96774),(0.99609,0.96774),(0.00391,0.99609),(0.03226,0.99609),(0.06452,0.99609),(0.09677,0.99609),(0.12903,0.99609),(0.16129,0.99609),(0.19355,0.99609),(0.22581,0.99609),(0.25806,0.99609),(0.29032,0.99609),(0.32258,0.99609),(0.35484,0.99609),(0.3871,0.99609),(0.41935,0.99609),(0.45161,0.99609),(0.48387,0.99609),(0.51613,0.99609),(0.54839,0.99609),(0.58065,0.99609),(0.6129,0.99609),(0.64516,0.99609),(0.67742,0.99609),(0.70968,0.99609),(0.74194,0.99609),(0.77419,0.99609),(0.80645,0.99609),(0.83871,0.99609),(0.87097,0.99609),(0.90323,0.99609),(0.93548,0.99609),(0.96774,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD018.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD018.py load and self-test diagnostics complete.")
