package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD017Index.html" target="_blank">MarsLOD017</a>,  source <a href="../../../Geospatial/MarsLOD017.java">MarsLOD017.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD017.x3d">MarsLOD017.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD017.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD017.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD017
{
	/** Default constructor to create this object. */
	public MarsLOD017 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD017.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD017.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD017.x3d"))
    .addChild(new GeoLOD().setCenter(44.911417,45.000000,-89475.000000).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars005.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars005.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,0.000000,0.000000).setSolid(false).setXDimension(128).setXSpacing(0.708661).setYScale(50.0).setZDimension(128).setZSpacing(0.708661).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {-1272.5734,-1127.6741,-1266.1727,-1328.7568,-1330.677,-1233.7026,-1055.934,-1063.8777,-1019.4208,-996.51385,-1013.38947,-855.3219,-951.28534,-863.69196,-667.5216,-518.4954,-436.01282,-216.38957,-114.90721,14.882741,-357.78647,-509.50183,-521.97797,-441.6405,-358.65485,-362.19113,-262.28128,121.11267,455.10654,605.32764,648.3082,491.40555,529.3537,683.7746,802.05975,870.92584,1007.90735,1145.4683,1220.3575,1162.7449,1012.9706,996.55597,1271.3884,1287.5732,1456.3209,1141.7356,1435.1458,1209.3757,931.92395,780.61664,752.2874,608.6066,791.0491,874.79785,907.08026,838.8775,825.64557,936.8872,905.397,636.9019,1022.0885,1169.8665,1312.106,797.21515,837.51074,2009.0204,1919.1273,1839.7207,1948.4343,1952.4155,1984.41,2107.0552,2266.0273,2165.2893,2129.7627,2085.9685,2179.882,1897.8933,1533.3431,1619.6626,1566.448,1911.3829,2090.7068,1770.1721,1665.1708,1645.9094,1738.8031,1998.6882,2253.1533,1906.6006,1866.6327,1856.6003,1775.0011,1829.726,2003.1821,2046.056,1988.9384,1834.612,1780.21,1769.4596};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {1714.2115,1670.9471,1565.793,1501.637,1465.6744,1435.1322,1392.8522,1141.2474,1100.722,1017.9628,942.11743,827.21454,963.3317,686.6441,535.58746,911.06683,1222.5847,846.0358,1552.7722,1158.0483,1246.3958,1024.1017,1082.9987,892.2586,446.9127,34.867817,-52.504635,226.70465,-1222.5358,-1140.0411,-1274.8524,-1341.4783,-1331.9199,-1233.3126,-1111.6119,-1082.9026,-1004.69116,-970.6378,-1040.3054,-1101.8517,-1000.20215,-903.5813,-716.8166,-619.4308,-482.8908,-303.59332,-345.5469,-245.62259,149.55544,175.07413,18.599527,-107.466835,77.05285,327.6025,338.8188,438.9166,387.01236,501.13266,397.49112,233.71132,281.73392,462.94986,581.75104,686.9498,921.3463,1116.2466,1103.9825,1172.1732,1090.3373,1075.0667,590.30194,1078.573,1497.4559,396.3246,1239.3129,1143.2206,802.8549,750.9385,650.0676,699.53864,763.9024,996.61127,996.96643,833.2776,824.6446,848.9876,614.35406,89.56431,1103.1145,1430.2125,1631.596,955.95593,735.11316,2087.6938,1662.8173,1647.0665,1975.8586,1928.3748,2015.0496,2058.7996};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2160.4165,1965.6014,1826.1339,1743.9535,1852.6266,1783.3958,1893.1837,2046.4344,2130.4797,2176.7878,1962.426,1662.6008,1628.9847,1664.9387,1736.7089,2162.4333,2084.9746,2097.3574,2056.4976,1859.3218,1882.8258,1858.4637,1846.7946,1802.6299,1844.004,1844.3687,1822.7869,1736.8188,1691.2795,1637.1505,1538.1444,1463.754,1442.2649,1353.9476,1337.7468,1205.9382,1134.2917,950.9027,877.0983,858.2937,949.7504,546.7667,93.83722,63.02004,175.39975,318.72858,667.60803,118.81533,101.31664,-88.772285,425.4203,-11.550305,473.36154,162.25435,-407.49786,527.9296,-1310.5087,-1222.3219,-1144.494,-1283.483,-1353.954,-1337.9176,-1215.439,-1036.3105,-951.8652,-962.81165,-1140.0496,-1224.3488,-1068.2991,-906.8279,-903.131,-643.442,-378.0964,-363.03036,-399.64734,-290.28464,-105.48821,187.83023,374.6961,173.56963,215.89804,412.15097,120.31276,213.67633,292.70224,356.93573,251.17097,183.70844,176.92122,300.74484,447.3278,531.1514,740.86664,48.898113,-524.87476,834.0027,855.14044,786.44073,-48.64127,559.304};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {1420.9868,1464.3003,1410.9106,941.89813,707.34875,622.5685,497.15762,781.531,916.3818,667.2398,937.38696,1175.8313,910.9682,901.07526,1074.4016,1011.3831,1445.543,1639.3575,1750.5665,1997.7999,2132.0234,2108.6204,1799.8771,1745.2628,1861.0079,1886.025,1825.2822,2017.0237,1909.6835,1647.26,1780.3593,1811.0667,1757.4651,1621.4261,1574.015,1678.4882,1807.7089,1769.6473,1715.1943,1568.2242,1613.6547,1681.6344,1998.9454,2225.239,1967.0103,1921.2036,1981.2535,1947.8724,1864.7289,1851.1989,1842.214,1812.5237,1815.4171,1839.1588,1781.9115,1695.3977,1623.2853,1584.6136,1501.381,1471.2627,1391.7374,1318.9797,1270.097,1135.3643,1093.6112,907.007,817.4735,794.3983,669.4465,232.85306,656.48395,-11.777222,-255.52592,404.77606,-210.27429,-336.90997,-288.10306,-295.3268,-282.8325,-523.74396,16.86393,-77.80124,-644.8654,-699.94275,-1362.9469,-1253.6862,-1265.147,-1233.3145,-1393.9032,-1410.7545,-1253.5801,-1066.7046,-996.23175,-1042.5582,-1031.1378,-1021.7111,-991.2052,-828.5949,-816.1057,-934.58167};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-385.51355,-406.65576,-465.67868,-271.68597,-42.707905,154.74774,140.61897,-17.550463,-146.5206,-186.27199,-146.20866,14.090708,197.33891,251.24716,209.66412,67.18295,116.79546,118.00328,181.87926,239.5256,445.04935,339.56647,126.883255,182.54826,-233.61853,827.32855,941.9695,-18.986067,889.3865,884.3433,659.0352,751.48694,564.9208,325.44736,549.9606,623.8972,-79.05538,-258.56442,17.470085,1200.1268,962.8853,813.6665,1049.9244,1418.7715,1589.4419,1710.9305,1655.0343,1498.4425,1730.7758,1882.5787,1732.9478,1668.0309,1711.1483,1795.0493,1671.0819,1627.328,1716.4287,1722.561,1759.4749,1710.5947,1769.4197,1636.7633,1532.6953,1461.7632,1536.0337,1691.8215,1589.8624,1551.5536,1632.2335,1731.7266,1868.2452,1840.2295,1861.3853,1846.0156,1873.6367,1920.983,1873.9196,1868.6808,1844.2314,1778.585,1791.9634,1759.0236,1723.3186,1664.6056,1593.2875,1499.5775,1460.3523,1369.4261,1349.9038,1276.7168,1188.8716,1113.6444,1067.115,900.7754,820.1105,821.64307,296.59943,39.883614,143.33617,37.59803};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {-672.27106,-273.29962,-589.29205,-353.61642,-742.71844,-665.0946,-1104.788,-1038.0206,-1199.7306,-886.5469,-1366.9547,-1752.8146,-1352.2604,-1367.6648,-1632.589,-1292.8962,-1364.0175,-1341.2161,-1341.5574,-1178.7196,-1050.5128,-1029.6924,-1068.466,-950.94775,-890.1359,-912.8703,-744.1874,-601.8832,-575.0082,-559.66504,-492.64868,-457.1011,-277.8852,-135.46881,-303.13766,-259.4948,-367.6895,-267.77966,-127.685684,-17.995682,-29.243595,16.329449,112.60601,36.157898,-16.1279,-198.37215,-70.61752,-40.61848,118.22076,264.52316,466.7048,89.56625,-353.0947,554.9581,866.22095,1037.2212,1136.2676,978.51154,743.23944,552.9165,378.34955,318.04575,438.40503,354.63928,-235.00986,-281.1582,-156.1448,926.3296,1069.3484,810.4953,936.178,1389.8292,1472.9961,1222.4403,1475.4708,1483.0472,1334.7012,1749.1627,1686.5597,1601.4541,1648.9458,1774.5208,1648.5013,1493.5282,1386.6592,1517.7406,1749.875,1383.3676,1556.3643,1659.5575,1585.317,1647.8625,1815.8617,1104.4534,1025.3264,1565.6788,1622.7115,1703.1005,1741.1365,1773.2162};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1816.9807,1875.4796,1843.2712,1868.7908,1873.6188,1826.587,1823.7357,1727.7031,1723.5117,1770.1863,1674.3054,1664.5977,1630.8916,1528.1895,1476.7473,1368.074,1322.3624,1246.5236,1157.6504,1071.6445,971.1253,832.7066,734.2666,721.18353,704.9043,394.89655,-187.07246,-356.53455,-922.3189,-893.555,-1430.0889,-1738.6669,-1922.2678,-2211.828,-1798.7592,-1767.7544,-2255.2004,-2056.21,-1785.8127,-1883.9241,-1367.4152,-1386.4706,-1758.1833,-1415.9805,-1378.087,-1326.5642,-1245.8444,-1076.4374,-986.6728,-953.54565,-918.685,-872.6901,-858.05914,-954.97705,-834.82996,-713.6042,-624.8732,-577.7451,-579.88293,-598.94354,-556.72894,-454.19223,-328.87167,-299.3154,-324.42703,-257.0127,-131.63704,-97.59945,-110.92941,-82.906044,29.061365,-39.474045,-88.86331,-62.06264,-131.27397,-146.5367,-77.671646,26.010317,140.89021,326.5061,313.85703,334.7639,493.0401,727.977,876.59534,960.0535,657.7267,347.46976,234.28346,255.57816,428.26273,577.7522,146.9278,-37.361176,708.22,1544.3748,1179.6277,830.28375,809.2568,1122.385};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1326.0422,1012.26746,1385.3125,1607.3118,1662.6812,1699.3069,1645.1383,1651.0533,1715.5162,1727.1926,1748.164,1559.2324,1478.8121,1449.1221,1759.2327,1588.0957,1695.9078,1587.6166,1552.9471,1625.7828,1779.855,1505.6936,1398.9683,1555.0317,1616.6718,1691.8977,1791.4216,1824.6854,1831.4908,1815.3738,1865.5315,1899.8407,1921.501,1875.4302,1830.7715,1785.5779,1785.1089,1791.2056,1667.6875,1707.4209,1339.3872,1611.3386,1476.5514,1357.6881,1302.8601,1250.2034,1121.1986,972.6711,869.56244,786.72687,705.5227,577.0674,522.8781,153.40887,-552.257,-948.3123,-1869.8644,-2402.272,-2634.66,-3106.3484,-3198.8367,-2998.9268,-3180.9382,-3197.7563,-3028.3,-3354.4436,-3230.854,-3044.236,-1339.2146,-1202.3043,-1317.5469,-1370.5154,-1407.2513,-1357.2512,-1182.1473,-875.041,-786.6913,-862.8417,-865.1522,-765.7946,-750.4329,-722.688,-766.9551,-775.1011,-690.2328,-652.56415,-597.24414,-615.64075,-597.7067,-523.48083,-435.65924,-268.08203,-291.17496,-314.7131,-181.83252,-126.4417,-121.34687,28.860018,88.74439,-86.32734};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-67.37804,138.46928,190.29576,108.44178,69.70163,-38.61459,72.78329,148.83794,219.8278,187.55022,80.92374,18.665297,508.08185,856.4589,509.13922,250.56763,155.79948,165.44347,198.1363,290.58554,521.6425,618.5629,1483.4414,1897.6754,1233.1534,970.28424,828.172,895.119,1554.7902,1698.0627,1855.5751,1864.128,1710.2598,1624.0519,1638.0894,1848.4738,1788.7719,1806.9594,1858.9218,1783.0977,1668.0713,1644.6346,1584.1217,1599.6503,1505.51,1500.3761,1508.3405,1539.0983,1563.9904,1704.9238,1633.4998,1581.9459,1662.2247,1721.9803,1737.3317,1779.6393,1842.3086,1874.911,1916.9214,1920.8883,1954.2725,1910.0319,1869.6683,1821.7245,1832.1415,1653.3297,1532.8126,1623.4596,1325.6853,1619.7844,1484.922,1400.6571,1284.9518,1157.3132,1036.4242,873.7608,765.7112,771.5922,548.22656,459.16803,-12.298398,-421.92624,-894.4523,-1003.404,-2545.7207,-3247.127,-3645.5093,-3707.2686,-3737.8584,-3766.0085,-3808.171,-3724.8943,-3715.3071,-3763.1086,-3705.3945,-3601.5037,-1354.6772,-1243.3708,-1281.1335,-1308.699};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-1316.3505,-1282.5409,-1094.4098,-899.7678,-1167.8765,-717.9936,-801.03577,-779.6446,-761.1816,-682.99554,-682.02466,-725.2848,-659.00275,-644.26044,-652.5068,-601.23376,-594.7719,-662.268,-625.18665,-742.76746,-343.18155,-207.58856,-115.03964,-134.63849,1.067783,110.75801,-284.98282,-323.3311,-30.477095,24.783278,87.984924,133.71367,33.430332,-86.44226,33.287346,102.33218,179.41473,144.54929,138.18143,188.58177,260.72772,346.1867,240.72202,151.67685,162.17006,281.41068,149.50195,116.142815,148.56926,409.19946,861.92316,1374.6077,910.26117,1039.121,947.99677,1168.0032,1720.0632,1806.097,1656.7699,1690.2496,1614.9518,1640.7257,1734.4032,1933.1288,1700.1401,1602.6208,1760.8987,1721.6068,1741.377,1693.4248,1613.3458,1595.7865,1493.8513,1525.8871,1505.6766,1531.8135,1562.7152,1603.6454,1534.0066,1582.8873,1633.6151,1715.3157,1744.102,1776.0619,1833.1637,1869.1982,1928.5676,1966.327,1996.0831,2015.3783,1924.9314,1867.0387,1733.8256,1343.0684,1365.9714,1537.5095,1577.4641,1523.3121,1472.9513,1361.4678};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {1262.5706,1141.0333,1012.5807,873.57385,737.12396,546.1986,359.85028,159.12433,-158.53358,-689.43933,-1201.5479,-2194.3215,-3266.1848,-3632.0068,-3757.637,-3801.8857,-3825.244,-3846.3547,-3854.6387,-3796.2686,-3800.3696,-3802.2974,-3778.2808,-3726.714,-1464.1709,-1237.631,-1301.422,-1300.28,-1297.1953,-1175.4592,-1029.2382,-928.689,-1015.6317,-770.86194,-858.7836,-735.8528,-1076.1664,-645.16284,-605.3234,-675.7565,-569.87866,-560.7917,-582.1409,-572.4807,-600.182,-652.7101,-601.994,-641.14294,-386.4776,-126.74947,-119.73987,-131.80135,-5.035966,20.155602,-158.09619,-123.06307,-5.951262,59.9233,103.80711,97.671394,1.150653,-61.440388,81.72386,185.30156,277.41956,109.84985,23.839808,-141.28253,130.9939,160.40062,148.36154,246.44763,309.72296,135.52202,322.2578,200.24432,118.96308,159.92183,552.2217,945.9588,931.611,1024.3344,1266.4685,1642.5961,1930.8749,1990.8695,1746.1588,1619.6234,1419.7648,1619.4841,1929.3994,1930.7208,1555.8953,1131.6621,1570.6084,1743.2627,1762.486,1746.5208,1779.9829,1699.8079};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {1726.7667,1610.0411,1658.7405,1694.7632,1648.4894,1597.9146,1603.213,1597.625,1615.2354,1741.6613,1621.1963,1752.9908,1826.7985,1895.6285,1954.8964,1984.6222,2006.1442,2046.9537,1982.4524,1759.0822,1281.5262,1010.6462,1298.5818,1474.992,1559.7506,1522.6191,1469.4464,1358.395,1258.6943,1114.6318,971.30963,825.80133,649.24896,455.85858,368.8361,-120.83223,-556.67645,-1601.7814,-2061.2974,-2912.9055,-3605.512,-3781.562,-3820.4695,-3811.725,-3844.4114,-3864.8115,-3866.943,-3820.748,-3815.0432,-3809.9382,-3819.8975,-3792.0334,-1419.956,-1317.4868,-1273.1559,-1296.1681,-1304.047,-1202.798,-1198.6895,-1080.968,-977.209,-920.20264,-867.82715,-755.719,-833.9285,-597.4167,-702.48004,-610.3722,-751.6858,-914.2685,-522.8763,-792.62726,-1530.529,-676.2156,-530.36145,-453.6311,-271.67328,-264.6678,-190.15443,11.001006,-50.958313,5.909813,65.829056,46.43473,64.81919,-24.091503,46.42936,-25.170488,-50.298683,63.04928,-31.460457,375.63962,382.63574,84.80178,3.732175,-102.953804,-36.516388,155.80774,328.84366,463.142};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {133.93527,-973.22,-188.08224,128.94148,50.802856,38.14953,-336.4643,366.6208,259.77692,-388.4484,859.57587,573.61206,1141.5027,1883.6267,1696.1891,1400.6267,1254.4916,1547.068,1908.2476,1956.3134,1626.4473,1944.1156,1889.2328,1804.6096,1829.2065,1834.7573,1773.3619,1660.2623,1913.9336,1577.679,1696.848,1669.3551,1642.9767,1580.0121,1626.3911,1668.2582,1774.3718,1687.0406,1756.9585,1720.7301,1803.3611,1895.473,1967.1334,2018.387,2009.9734,2059.9578,1939.8275,1427.7758,714.111,725.0143,1311.637,1544.8553,1580.4485,1568.6614,1535.2207,1377.7146,1253.3436,1120.3419,960.71606,771.70764,585.1705,122.783966,-60.597893,-842.92365,-1156.311,-1913.594,-2840.7273,-3484.49,-3830.1895,-3861.7078,-3859.125,-3854.8064,-3853.4163,-3869.647,-3864.7275,-3804.1033,-3815.2014,-3807.2175,-3815.4172,-3789.6726,-1384.3167,-1325.9431,-1269.2336,-1265.8014,-1258.2146,-1227.8334,-1196.7258,-1133.7657,-1025.021,-1148.6788,-1139.5459,-816.465,-784.56116,-668.66595,-818.1991,-646.54254,-663.41315,-682.2363,-442.6466,-562.3276};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {-939.9802,-568.6262,-494.88644,-475.10944,-411.88016,-511.38876,93.622375,122.48715,3.41618,97.752144,-165.57135,56.366272,7.268774,97.37224,125.924835,-72.86713,-167.22765,-27.512976,247.1414,492.0119,401.8136,249.37663,68.320564,-17.776752,-33.4548,181.9836,465.48544,631.2668,358.4396,-376.2122,-7.711418,137.83035,174.5341,34.681286,-486.00168,-168.35358,191.34645,-192.6112,404.47095,26.47199,462.88254,1419.1796,1410.6805,1352.7175,1245.2247,1324.8147,1744.118,1988.5637,1962.0997,1892.8031,1689.1528,1817.7317,1830.7856,1970.7047,1629.1642,1795.7137,1855.5283,1637.842,1600.8673,1572.8016,1614.054,1651.344,1640.4636,1506.9833,1505.849,1567.9447,1723.6947,1828.4121,1808.7769,1844.0352,1922.9513,1962.5378,1936.9736,1980.4867,1638.8322,1036.2524,609.46765,545.8143,1420.4003,1610.941,1645.5752,1662.9998,1578.4526,1403.2587,1253.1757,1113.9387,900.2884,709.11444,418.6849,-191.77008,-691.5994,-1370.3795,-1885.5475,-2641.5034,-3350.2124,-3806.445,-3849.8625,-3869.3013,-3846.6816,-3852.6963};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {-3830.9436,-3835.3733,-3832.3875,-3806.9114,-3810.285,-3819.3418,-3810.532,-3782.0732,-1322.2705,-1251.3453,-1285.092,-1263.0913,-1265.6833,-1243.0281,-1241.1132,-1091.3951,-1037.9235,-1010.9676,-968.9959,-870.6653,-880.6286,-776.6326,-669.86725,-504.974,-426.7218,-296.04404,-282.32114,-328.6888,-387.65906,-510.33847,-547.00964,-410.68033,-290.38058,-688.4495,-1444.9568,-385.31146,227.898,352.4288,307.84805,160.73807,130.03871,121.88329,78.945984,-168.82072,-112.796715,57.245247,550.4356,577.42096,619.74414,380.03375,77.07608,-82.29684,-3.136591,197.01321,483.56763,721.5873,495.72775,345.4823,195.72777,241.37387,223.9622,321.49207,149.34091,273.62106,747.1946,967.2413,762.79816,840.632,1072.7103,973.78827,885.62384,1012.8578,1269.7712,1182.2582,1311.5614,1338.6094,1403.2034,1370.6014,1591.3109,1758.6533,1904.191,1992.3505,1874.6038,1810.7561,1757.3043,1670.2537,1547.2832,1528.1212,1668.8496,1355.3138,1924.6211,1622.5962,1629.5204,1669.7771,1728.9883,1787.3176,1715.5322,1765.1373,1855.2968,1925.1007};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {1975.3522,1975.9974,1547.5627,1088.3967,799.3371,1044.178,1597.6797,1739.1245,1756.2463,1687.4823,1567.5083,1390.1467,1222.0566,1065.5826,790.6345,513.5643,128.58131,-302.59232,-862.3273,-1747.2456,-2442.0356,-3024.7122,-3430.9204,-3790.6836,-3863.9648,-3873.2417,-3848.322,-3851.3196,-3876.3718,-3834.681,-3852.4204,-3829.9473,-3829.791,-3849.773,-3835.4563,-3786.7625,-1346.3799,-1316.4956,-1500.587,-1210.9928,-1225.2625,-1219.6056,-1156.8623,-1044.0054,-1164.4843,-1091.3276,-1000.6261,-932.47894,-1048.0798,-866.2138,-920.75214,-1177.5891,-1091.902,-935.5631,-362.01617,-386.99612,-400.92905,-454.98773,-531.5355,-486.37103,-276.94513,-819.65485,-1608.3256,-726.59,248.32219,-535.15607,-369.17737,214.29465,214.97609,238.14693,365.65918,262.92175,435.59125,468.92386,674.97205,815.8912,158.22224,151.18054,-6.841043,-142.36893,-118.85781,27.935818,145.01085,230.42323,409.47803,409.06403,361.96625,392.1289,275.20392,407.96222,447.93967,297.93054,533.746,788.7243,850.5701,956.6954,980.3828,821.0592,703.2065,975.982};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1280.262,1170.0792,921.6385,889.66754,994.5508,1183.92,1475.4862,1640.1954,1723.1735,1694.1327,1552.4641,1701.2499,1665.0918,1619.5476,1537.4722,1526.6228,1554.3986,1336.8053,1886.3577,2143.8662,2137.4614,1867.6411,1721.3984,1736.3594,1775.9718,1816.4133,1869.8813,1989.1592,2094.9216,2067.505,1503.5813,603.35175,739.375,1220.11,1692.7461,1746.0763,1758.194,1666.863,1508.7448,1308.3645,1148.8274,889.35864,665.7755,325.5184,-32.281822,-528.73224,-1114.2399,-1948.3699,-2709.5146,-3301.3577,-3585.7656,-3819.834,-3896.547,-3899.913,-3860.1401,-3863.2803,-3874.764,-3858.1143,-3872.4988,-3856.0146,-3834.2039,-3846.2637,-3832.9934,-3784.9326,-1406.3385,-1375.623,-1307.3958,-1206.6249,-1235.287,-1187.523,-1197.6194,-1166.7876,-1313.5503,-1188.2914,-1030.488,-931.04,-940.68317,-974.8133,-927.39496,-1012.2797,-1016.439,-1967.351,-826.1726,-391.6028,-381.91638,-651.983,-530.5309,-484.06003,-379.1681,-157.2503,-356.22815,-155.91676,-79.76077,-20.623343,69.07096,340.5529,248.92464,39.289696,384.59824,624.51276};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {639.8738,615.19946,766.03955,449.4719,553.94696,58.60678,-260.86108,-297.01852,-282.64557,-275.7747,-154.92308,69.515785,373.08298,538.11584,504.0517,620.8867,507.8165,580.4151,545.2627,653.25916,408.0722,714.5098,812.1763,940.7707,480.80402,489.08466,660.3528,910.98773,989.1792,820.409,716.89087,511.5891,718.9252,756.1791,1371.8158,1714.3652,1761.022,1676.4858,1673.0103,1779.1205,1655.9061,1653.2943,1650.1964,1585.2238,1614.1184,1642.3414,1671.3392,1578.7065,1949.1683,1718.1627,1660.7704,1641.3041,1735.5106,1762.4935,1857.4147,1988.6946,2086.5002,2138.7234,1531.9103,614.532,1019.38666,1419.218,1619.2609,1642.4021,1645.7001,1587.4756,1408.2021,1197.2034,1029.3893,762.35223,543.67236,205.57573,-251.40417,-785.742,-1434.5464,-2242.0483,-2976.0803,-3498.886,-3691.753,-3884.4744,-3886.5596,-3884.2615,-3864.7039,-3885.7678,-3886.871,-3886.1084,-3866.5254,-3849.5261,-3837.6665,-3810.3752,-3773.0774,-3797.4673,-1764.9331,-1586.5355,-1237.5343,-1271.753,-1697.5981,-1229.8845,-1231.0895,-1297.7286};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {-1252.4473,-1198.1506,-1049.3165,-1736.3635,-1462.2191,-1047.4768,-908.23016,-651.7079,-474.96396,-595.2169,-385.5398,-832.3865,-375.00577,-1328.3982,-1117.3956,-524.5508,-421.3429,-312.4651,-274.4228,-356.90448,-388.0507,-178.29138,93.26794,-632.38135,-1220.085,-1472.0731,-608.38666,520.4776,511.809,725.9422,779.80896,612.5712,571.65466,-212.0559,-315.08118,-378.2216,-322.5312,-358.95047,-202.43742,177.86719,640.3746,768.2525,586.0158,541.5992,959.77484,917.43463,713.3822,686.229,674.7718,811.6187,758.2884,666.65643,707.0164,748.3131,822.8415,828.34784,734.5577,614.70435,563.7553,477.97354,560.01013,538.6033,1424.8201,1825.3751,1819.4707,1997.6127,1913.3488,1630.3744,1881.0856,1658.8367,1589.242,1585.8196,1641.637,1663.1547,1472.3861,1640.3927,1757.6481,1668.2362,1639.5496,1610.8593,1633.6306,1687.5557,1786.7103,1879.0238,2044.6152,2153.4375,2100.523,1808.0404,1560.9688,1583.0598,1613.0978,1580.7311,1516.1737,1396.1096,1229.9465,1112.7626,917.34155,680.2352,386.2678,31.975128};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {-485.6076,-1083.9119,-1686.7797,-2355.7632,-3106.6667,-3640.1157,-3798.6514,-3860.129,-3839.6882,-3818.209,-3868.373,-3887.9873,-3889.6145,-3883.671,-3872.4949,-3841.7317,-3824.6084,-3795.355,-3760.3755,-3758.2559,-1439.6735,-1717.1848,-1309.0471,-1231.4064,-1342.3091,-1235.0956,-1334.9296,-1321.0585,-1314.6992,-1293.9202,-1220.4976,-1156.2588,-1348.5001,-1697.2285,-1001.5543,-874.842,-811.16327,-1204.2792,-569.1962,-1372.0317,-618.99756,-597.00195,-911.27356,-691.7931,-543.22015,-493.20483,-480.76053,-569.32434,-675.80676,-500.34256,-139.4856,-471.8917,-526.95654,-644.25494,-1417.5216,251.08667,726.6961,788.2226,649.88306,373.26193,330.84177,-257.0392,-273.9638,-265.96964,-161.15912,-312.70184,-459.17828,-347.34686,747.7839,827.9938,420.7753,467.8465,125.60538,852.5159,940.4573,783.1925,562.55634,579.1455,571.46136,384.73163,642.2204,605.0715,581.48096,639.8598,681.3526,572.04913,478.82562,366.87854,466.647,925.9348,994.4378,1563.8846,1410.0442,1790.144,1677.1798,1744.6251,1860.2954,1613.6011,1377.6393,1597.6583};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {1264.3756,1745.277,1719.7213,1644.8306,1627.1139,1607.8301,1575.0902,1577.8789,1546.1074,1617.4696,1749.2346,1866.5479,1940.223,2009.7164,2068.568,1994.1566,1843.4672,1839.6112,1743.1765,1547.2671,1381.6592,1238.4564,1105.6198,925.6834,776.6656,493.54233,264.34933,-136.44994,-727.7549,-1319.2393,-1851.9209,-2513.818,-3179.6204,-3630.2869,-3831.985,-3861.3345,-3882.541,-3889.194,-3910.489,-3917.6167,-3921.2976,-3925.958,-3908.2737,-3857.4065,-3797.7158,-3751.4546,-3733.52,-3734.654,-1538.0127,-1468.761,-1342.0844,-1255.752,-1331.8591,-1336.4391,-1450.0603,-1363.7871,-1390.632,-1319.4115,-1372.7458,-1300.4916,-1241.7848,-1201.8823,-1019.83435,-935.78784,-1014.4319,-1266.8118,-1181.4731,-2258.6377,-614.80994,-516.4898,-870.55286,-709.5737,-657.77216,-1082.5404,-756.94995,-776.8911,-797.0608,-630.2593,-339.7539,-733.9727,-1014.8714,-830.158,-1625.152,-73.40638,422.52072,451.35895,482.5196,-195.05748,106.15923,-169.67668,-345.70328,-92.5706,63.52098,-206.53563,-1068.6965,-1422.1156,-123.34937,-526.2314,-738.887,-889.94086};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {-830.9173,-79.42387,1037.855,1086.6835,771.81775,437.9607,451.84277,427.72507,508.66888,520.63525,287.2381,417.81894,711.76404,608.99927,465.73206,293.01862,466.77002,824.69714,-117.08925,1256.7318,1494.2712,1517.9236,1486.2302,1671.0343,1371.1018,1420.2861,1320.4734,1430.1483,1164.2625,1402.909,1517.2606,1561.066,1460.5974,1566.49,1542.7268,1550.6228,1571.0411,1668.0912,1760.0789,1809.7119,1853.9596,1912.9929,1977.4944,1965.1265,1857.2291,1783.0739,1559.2809,1377.2571,1283.0585,1171.1279,1012.6622,838.70087,606.8445,396.58563,112.67756,-233.99294,-801.018,-1454.4651,-2035.2542,-2705.7627,-3140.5735,-3620.8577,-3867.6094,-3850.9995,-3893.3713,-3899.6172,-3911.9658,-3919.4392,-3912.1248,-3911.7153,-3872.8328,-3825.6174,-3743.7515,-3780.0107,-3762.7354,-3732.8018,-1482.579,-1475.2118,-1329.8428,-1288.7416,-1365.6006,-1753.2803,-1424.1678,-1390.1337,-1364.2446,-1354.4777,-1386.5753,-1334.9825,-1285.77,-1229.491,-1071.7014,-992.626,-979.2284,-822.33185,-900.9933,-1570.5496,-711.7726,-938.09204,-876.213,-795.1554};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {-795.77264,-885.46564,-799.82794,-1092.3162,-1008.97876,-855.21606,-612.0471,-328.8028,-933.438,-1181.7336,-301.06635,-9.33636,181.59483,175.8438,-53.300545,-773.7527,-122.68828,-296.76892,-298.2218,-224.87546,-213.64992,-286.80734,-532.78296,-618.5117,-635.1664,-1061.0348,-1181.4523,-1007.70703,-1093.2098,-1065.7673,-91.89114,1039.2354,750.7067,222.48048,348.4026,279.39453,222.7224,204.68161,229.44983,355.04916,559.4262,578.54095,359.2195,349.85568,508.24924,810.2464,825.4627,1204.0629,1364.1173,1258.0708,1383.6865,1577.5199,1106.33,1230.9167,1170.0317,1015.98596,1007.07184,988.1727,850.87213,934.3661,1210.1333,1417.3704,1473.976,1528.1425,1542.9183,1613.2233,1644.8981,1668.3153,1719.1832,1795.3445,1842.2556,1793.0298,1729.1548,1649.8846,1465.0117,1337.1475,1246.561,1104.2177,926.69,749.1596,471.85703,225.76892,-103.11334,-425.99274,-882.20264,-1484.8196,-2061.3464,-2728.6345,-3238.5872,-3650.672,-3855.0361,-3886.5562,-3900.2888,-3919.4268,-3907.4585,-3897.036,-3891.974,-3881.903,-3845.1033,-3796.977};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {-3780.6616,-3825.364,-3810.5432,-3759.457,-1316.5281,-1418.752,-1285.6354,-1334.0917,-1432.8862,-1717.3806,-1484.8442,-1441.9843,-1349.1863,-1484.6019,-1494.4352,-1377.3373,-1409.9995,-1510.797,-1027.7594,-848.3656,-895.61304,-884.2784,-855.1752,-742.79626,-826.5472,-962.4272,-1039.228,-922.4243,-1052.7406,-1063.8544,-1110.6923,-1125.5596,-1219.0732,-1079.7627,-1035.8668,-582.8804,-240.72345,27.229126,268.62683,-34.124973,8.694788,40.93549,-30.976805,-113.85589,-133.21277,-410.19943,-439.3237,-426.56226,-446.0071,-292.8274,-218.32925,-611.5575,-776.57196,-896.2042,-1264.8866,-1222.1875,-1023.00604,-1200.5369,-888.32306,414.4396,524.81824,76.97148,130.46582,-225.32292,-95.1168,-52.25618,39.37515,224.30801,360.6067,492.5786,409.08856,433.53076,625.6468,669.7289,879.182,954.60126,1009.19104,1132.0066,1248.2736,1341.8967,1181.5305,1069.6534,960.91534,843.93976,786.8589,903.9496,796.72943,894.5821,1008.56415,1206.9468,1086.9534,1453.4637,1494.168,1517.4741,1504.1366,1568.3644,1610.0989,1655.354,1667.4954,1632.6577};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {1562.5529,1524.8297,1364.8218,1268.3196,1237.5981,1040.3154,862.6208,678.43134,407.69614,127.693306,-255.49072,-694.6453,-1168.6766,-1675.8148,-2174.8787,-2738.1833,-3273.9202,-3712.562,-3866.3367,-3860.9934,-3886.7014,-3900.7063,-3886.984,-3882.3396,-3859.3533,-3860.0703,-3822.092,-3794.2505,-3808.7131,-3812.3357,-3773.205,-3762.7683,-1274.6788,-1300.1426,-1345.4397,-1402.163,-1472.7025,-1453.3302,-1508.6473,-1471.2142,-1333.5011,-1346.7084,-1441.8774,-1452.8956,-1641.4329,-2006.7902,-1039.6843,-817.3253,-1169.7032,-975.15625,-1018.6766,-926.32666,-953.23254,-1073.7286,-1049.5264,-1049.8563,-1245.2217,-1300.4437,-1483.3246,-1403.6637,-1326.8209,-1318.7977,-1134.3882,-1015.9968,-698.84607,-309.2107,-140.07956,-178.28378,-152.23997,-119.55819,-101.32205,-130.90079,-222.7258,-383.2996,-480.50958,-430.49557,-480.53284,-428.61813,-154.13287,-977.11237,-1128.4674,-847.10175,-1107.2784,-1401.0771,-1337.4478,-1399.1434,-1032.2002,227.16722,227.45729,14.225384,62.626534,-120.46059,-174.95271,-130.4649,18.00808,270.55423,421.1706,502.46262,550.002,591.3517};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {563.95154,569.266,757.5741,682.9116,787.09515,940.97565,1109.857,1186.9796,1117.6318,971.7215,925.04767,846.4496,811.9298,875.90594,924.228,897.8902,1022.0175,1114.2529,1269.9514,1347.7571,1224.2245,1346.7297,1419.6984,1533.9327,1516.9938,1572.4901,1466.9698,1449.096,1421.8342,1409.8845,1267.4034,1158.9548,1154.7426,958.15955,800.17706,618.11847,358.75543,1.760248,-454.16675,-1043.9584,-1593.9597,-2043.2526,-2545.4158,-2964.9258,-3441.7578,-3847.297,-3879.9587,-3817.3875,-3849.8406,-3903.6316,-3890.8564,-3860.7664,-3821.5244,-3822.6262,-3830.4324,-3803.6284,-3779.51,-3801.2212,-3766.7473,-3737.1865,-1632.6714,-2418.8748,-2440.8884,-1644.3346,-1484.4904,-1479.0648,-1549.5613,-1536.7863,-1394.679,-1383.1995,-1442.0481,-1470.0575,-1326.7681,-941.99677,-961.5054,-1074.558,-1085.8083,-1103.4941,-1122.3834,-1068.1257,-1251.6014,-1315.119,-1219.8806,-1337.2661,-1332.1168,-1444.6406,-1546.266,-1540.4373,-1325.4652,-1087.6534,-1203.3529,-1268.5502,-1059.3969,-633.8331,-405.32483,-334.74918,-475.57434,-244.40582,-215.22678,-225.75865};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-302.92313,-416.04416,-547.4386,-360.36612,-437.00256,-460.9935,-117.4853,-872.2768,-1255.3646,-1472.4886,-1303.6619,-1412.5371,-1287.2826,-1250.3972,-566.89215,332.061,98.80136,61.31556,-31.45853,-89.97177,46.598614,31.87741,34.617596,-262.0496,-370.86035,358.4396,299.52618,596.74585,564.26355,649.2861,654.12305,514.537,576.53876,848.4783,1035.7084,1134.3143,962.3919,358.4662,888.8632,876.5101,830.5091,838.16315,857.6277,903.6022,1046.8538,1034.4695,1200.859,1313.6658,1023.2714,1280.002,1332.9265,1414.1669,1437.9056,1386.5446,1304.4922,1279.8341,1285.5668,1273.3823,1161.5967,1043.3428,1014.05707,879.2596,726.5817,534.8095,241.37541,-105.5369,-607.21893,-1148.717,-1676.914,-2217.0205,-2703.74,-3213.6938,-3716.6592,-3860.35,-3870.4475,-3814.566,-3808.3562,-3823.297,-3813.1125,-3793.8118,-3811.8018,-3784.5886,-3762.0251,-3796.5967,-3817.68,-3787.0256,-3745.7502,-3697.4895,-1886.9055,-3073.4705,-2621.0596,-1520.3823,-1565.1959,-1529.4525,-1386.5321,-1346.1891,-1325.1765,-1385.1371,-1434.0961,-1545.8535};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {-1191.365,-2031.6685,-940.4711,-1381.3496,-1107.1941,-1139.1881,-1209.6635,-1221.6324,-1340.2146,-1330.2365,-1340.1407,-1443.227,-1401.3605,-1594.773,-1557.841,-1641.5079,-1290.537,-1169.3495,-1101.0043,-1281.6434,-1275.3798,-1052.8392,-744.63165,-472.07697,-746.57086,-332.4259,-446.33157,-427.54547,-620.40643,-442.28302,-296.75043,-394.33075,-1124.4016,-1520.024,-965.00806,-44.230972,-801.5864,-1618.5669,-1278.7815,-1472.9124,-1061.9014,-289.18933,207.46127,568.1083,223.99237,236.85986,-31.013536,26.896212,-128.066,59.054035,107.93989,-119.20774,-378.52017,165.94861,-204.245,216.2724,560.88055,570.8372,536.8758,458.26328,608.81775,718.7346,869.75494,715.089,1133.6714,906.50433,1218.15,1045.3679,907.1999,892.8213,865.1238,917.6255,978.01575,932.1749,1186.9926,1232.3798,1188.511,1193.3092,1195.3257,1256.5688,1285.0852,981.235,1168.2279,1143.3939,1180.5255,991.4272,1087.7009,951.8095,852.386,763.8481,669.6004,428.51706,-35.979607,-344.60202,-790.5809,-1267.9409,-1679.0746,-2369.128,-2919.4075,-3634.528};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {-3818.9197,-3810.7258,-3838.713,-3875.094,-3810.3274,-3756.2834,-3759.8599,-3807.9949,-3783.633,-3751.854,-3753.3345,-3776.3384,-3767.7307,-3745.9817,-3696.5005,-3697.1196,-1688.1189,-1765.1289,-1685.2643,-1650.4215,-1849.0061,-2124.342,-1409.5406,-2123.181,-2216.2993,-1249.4813,-1365.6753,-1512.9174,-1306.0643,-1008.9339,-1317.3292,-1307.2218,-1342.7125,-1526.7454,-1920.7383,-1653.8888,-1425.0609,-1442.5421,-1459.8186,-1459.9027,-1523.0656,-1668.352,-1681.3757,-1721.3956,-1714.8461,-1452.159,-1525.6581,-1511.5115,-1463.208,-1322.9623,-921.4042,-649.2175,-413.60126,-352.28085,-418.126,-563.6326,-654.718,-576.23206,-538.6315,-757.97424,-743.5855,-708.4962,-376.96225,-328.13315,-603.1317,-1011.0542,-866.5364,-736.2421,-604.0393,-56.367043,412.03885,365.8206,202.91716,242.7856,23.613451,-31.38075,-21.56208,50.975937,5.597753,180.30568,375.4094,356.81,69.52416,248.99174,407.64044,373.49487,402.32123,395.98895,587.1751,678.57996,875.492,1084.2662,1351.7291,1586.4944,1222.8807,1039.9625,985.62305,923.4343,899.3251,912.7452};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {928.08795,984.4218,1272.1676,1179.98,1008.8586,1074.3755,1077.2454,1114.4161,1128.0502,1103.927,1112.3937,1029.9585,1059.9722,628.6944,972.6408,765.8108,636.25226,647.23956,418.73486,323.73026,-370.3407,-640.7381,-1036.535,-1449.0524,-1982.8531,-2454.049,-2915.4197,-3574.015,-3786.9907,-3808.4783,-3808.869,-3825.4836,-3761.5923,-3764.1743,-3771.0134,-3799.7341,-3803.9275,-3801.2004,-3752.972,-3736.0425,-3724.873,-3698.9158,-3671.3982,-3694.6719,-1796.309,-1817.3855,-1826.4135,-1770.731,-2079.545,-1697.3973,-1434.1625,-1738.1809,-1753.0137,-1012.45215,-1296.8724,-1448.7439,-1451.0677,-1384.5905,-1740.7306,-1634.8607,-1685.48,-1841.255,-2792.4,-2359.4136,-1736.5735,-1587.9934,-1769.0461,-1394.8065,-1650.5006,-1719.4415,-1754.6807,-1806.9237,-1746.9789,-1719.6853,-1674.97,-1570.0887,-1519.7407,-1430.9453,-1022.5237,-805.76404,-662.475,-599.5654,-760.8864,-739.97375,-817.3509,-812.80176,-970.39966,-1018.7963,-968.35315,-910.2218,-999.5952,-1136.9875,-1105.1694,-891.1722,-325.49988,-214.98997,-102.665596,270.99997,251.62917,186.39667};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {172.64153,148.01425,8.64592,-49.232883,-14.713043,-59.70275,-101.78786,47.02382,193.00764,179.60045,225.16676,258.74002,289.14014,311.45557,430.5613,365.26117,540.1143,627.46344,750.8932,912.5699,1418.7992,1586.5322,1428.2902,1101.0786,1113.4282,1038.6324,981.6735,971.4681,901.0279,1039.6354,1032.6654,1066.6263,1009.2988,963.3663,967.13306,1022.9644,1052.7925,1001.926,980.7323,934.84064,954.0886,916.05817,850.1848,653.286,514.62274,553.2944,262.5108,-201.31734,-656.9163,-887.664,-1000.51117,-1237.804,-2077.7466,-2591.473,-3048.4658,-3449.2776,-3759.7915,-3795.223,-3789.9675,-3753.9514,-3756.1216,-3799.4058,-3793.156,-3793.2295,-3775.852,-3764.7534,-3747.2393,-3732.3706,-3709.2505,-3670.5972,-3677.7114,-3706.3328,-1853.6072,-1936.1053,-1962.762,-2002.6278,-1926.5709,-1643.6792,-2019.3044,-1430.9373,-2547.1501,-1936.2667,-1423.7251,-1448.7584,-1556.578,-1501.3682,-1517.664,-1575.8374,-1644.8641,-1666.0983,-1756.0303,-1690.3934,-1645.1536,-1596.3962,-1608.7484,-1499.1971,-1594.9674,-1754.0358,-1738.6217,-1787.4592};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {-1817.9167,-1750.8834,-1744.1891,-1631.1356,-1519.346,-1491.5961,-1258.5033,-937.34827,-897.28613,-832.1524,-832.2173,-753.8255,-934.5289,-1103.8396,-1232.2534,-1188.728,-1105.8907,-1178.1353,-1147.1533,-1214.9764,-1238.3776,-1005.71136,-785.1316,-201.2339,-99.72491,109.72368,86.57126,239.63142,239.39844,20.290968,-85.7224,-151.43193,-145.02922,-122.22702,24.135923,60.024113,135.88284,130.1023,174.63492,275.14368,298.22916,344.8932,433.33527,234.36143,486.07532,453.56827,562.0107,812.24884,1348.9814,1691.4736,1391.1052,1122.0667,1290.5426,933.01263,988.14075,987.6697,895.62006,887.8171,809.9036,1069.6936,967.0945,892.1855,906.3984,929.33813,959.62134,936.8173,881.8011,831.97723,830.1326,774.14026,743.2261,634.7043,498.91217,201.34479,-4.353389,-562.3536,-632.69354,-839.81116,-961.78534,-913.17706,-2298.3708,-2605.625,-3300.9744,-3527.439,-3691.551,-3700.0474,-3733.6536,-3743.6902,-3760.2268,-3764.487,-3761.7678,-3740.0168,-3747.3965,-3742.7551,-3723.8352,-3706.9783,-3692.6694,-3690.6726,-3667.375,-3647.7786};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {-1999.9972,-1986.9314,-1979.5665,-2014.2334,-1991.1051,-1816.4194,-1398.951,-1930.8134,-2648.9055,-1593.7765,-1507.5275,-1519.1266,-1564.9109,-1622.048,-1455.4741,-1683.1415,-1706.4055,-1713.3734,-1746.1438,-1689.8345,-1556.7,-1475.7511,-1724.4858,-1612.0831,-1582.1897,-1748.5344,-1772.3431,-1751.5883,-1761.3994,-1830.8071,-1729.3398,-1571.3835,-1540.6105,-1507.4547,-1227.5566,-1018.03674,-999.3315,-999.0279,-854.5554,-900.76685,-1072.448,-1285.0333,-1308.4762,-1318.2892,-1115.4048,-1167.131,-1077.9447,-1175.5712,-1205.5885,-1225.1812,-1119.0942,-702.1459,-397.81464,-126.496315,-96.81987,22.51142,4.618282,38.39195,42.538525,-217.32077,-300.4702,-288.27472,-19.373829,14.381951,117.67953,265.65015,196.71599,232.19638,196.3725,254.53448,308.80307,210.64552,322.9206,186.95654,168.12645,706.75964,1193.9481,1435.8593,811.65765,590.21875,966.66,911.44604,845.2925,809.5038,796.2546,862.7959,990.0167,1229.7186,1064.825,884.9748,874.10913,803.56415,868.28235,861.5819,786.4721,729.939,781.999,675.6085,658.2065,574.761};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {422.64868,283.06424,90.72016,-392.083,-577.98816,-744.4879,-845.2753,-1097.5399,-1962.3342,-2347.2395,-2859.3809,-3264.2942,-3591.754,-3600.981,-3722.2537,-3739.1768,-3747.3967,-3722.701,-3705.8584,-3692.5593,-3682.241,-3676.3647,-3666.2234,-3654.4075,-3688.734,-3694.1484,-3666.216,-3610.9336,-2017.505,-2051.728,-1965.4192,-2011.9357,-2003.3175,-1913.4915,-1490.2598,-1342.0443,-1326.1107,-1483.6307,-1720.0522,-1616.7164,-1724.5184,-1475.1093,-1635.5568,-1745.7546,-1735.2887,-1735.3136,-1715.732,-1747.7645,-2569.2756,-1648.1923,-1996.7018,-1739.3842,-1502.3291,-1708.4727,-1734.5898,-1802.5586,-1862.1636,-1739.9484,-1689.186,-1701.7301,-1667.219,-1580.1056,-1133.5131,-1098.3468,-780.0334,-868.0817,-1033.9187,-1279.2152,-1524.7257,-1480.0972,-1276.4425,-1342.2052,-970.1044,-665.85675,-886.905,-1095.2102,-1184.5354,-1157.8226,-887.98395,-513.912,-439.04788,-273.80725,-209.6932,-137.12527,-97.884384,-41.076084,-130.74802,-355.948,-290.32248,-247.44276,316.62747,151.35689,330.50967,397.5103,207.20378,119.37962,130.65948,-375.82977,179.54578,201.58801};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {316.40942,102.86602,570.5621,777.7769,1122.4697,1368.8549,1279.8608,992.96014,1009.90283,869.6195,683.31726,767.2446,692.2097,719.68207,591.10693,623.9774,1180.8767,870.72125,802.9789,704.8978,681.47614,822.15424,793.6472,712.701,703.46545,661.0441,605.3581,514.4474,380.31177,215.83984,-90.34269,-202.97945,-362.7827,-352.51608,-247.35007,-911.09375,-1677.292,-2177.893,-2418.946,-2551.8047,-3332.2039,-3452.5115,-3581.975,-3652.042,-3689.6885,-3722.3225,-3710.0208,-3638.672,-3628.7747,-3666.0325,-3676.2002,-3659.6602,-3670.6846,-3659.7556,-3647.8306,-3595.0007,-2025.1752,-2057.3635,-2028.9889,-2052.6118,-2018.5984,-1963.4323,-1813.6416,-2245.9885,-1781.0515,-1669.934,-1708.915,-1573.0046,-1640.2244,-1751.0353,-1854.6549,-1863.15,-1846.0945,-1766.602,-1760.4613,-1775.7026,-2061.5408,-1656.7931,-1568.6698,-1517.0497,-1572.5563,-1645.939,-1680.0625,-1848.7466,-1848.681,-1865.6125,-1744.5741,-1621.3373,-1329.8773,-1218.41,-2452.2097,-2836.9006,-1099.3757,-881.936,-1316.1721,-1520.0363,-1609.956,-1540.8773,-1447.1064,-1097.124};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {-610.56415,-552.0787,-597.31805,-587.0535,-830.47784,-957.964,-892.83923,-821.2688,-431.77756,-466.00302,-340.6953,-307.83633,-193.63972,-133.53868,-168.62888,-209.75682,-75.614044,33.713512,331.96268,358.122,163.40767,465.05566,471.27524,333.91757,321.11942,411.6179,89.54146,-49.629646,-1.098443,132.04387,705.96423,1011.74554,890.1007,681.6334,626.14606,265.67017,771.3457,1012.21326,664.35547,463.9026,394.06625,336.3437,289.78793,313.05594,252.75827,113.40702,563.8049,720.32965,765.24445,800.65375,768.3381,742.6374,844.9729,704.3137,677.35913,497.23218,302.00977,108.23046,-197.66495,-305.32428,-230.4848,-130.42422,-170.92493,-489.32654,-1360.1259,-1816.9954,-2158.9143,-2711.322,-2920.891,-3058.5278,-3422.1948,-3527.7207,-3638.7202,-3674.6653,-3665.0586,-3618.8667,-3629.4407,-3639.1287,-3602.2856,-3640.7449,-3627.8013,-3615.0537,-3612.59,-3614.7146,-2077.1875,-2085.9573,-1991.5885,-2031.6759,-2001.5078,-1999.5298,-1940.28,-1793.3546,-1745.2388,-1811.0012,-1862.3524,-1625.5786,-1697.0292,-1855.751,-1911.7408,-1886.972};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-2010.5331,-2356.9578,-1780.1401,-1751.0267,-1714.2821,-1771.0995,-1790.8585,-1744.1183,-1620.951,-1481.1483,-1621.891,-1925.4408,-1826.6222,-1841.1853,-1769.989,-1579.688,-1095.0918,-859.0862,-2316.9102,-2947.819,-1267.0295,-1170.2079,-1494.6915,-1515.6833,-1545.0875,-1387.5706,-1053.3826,-531.91754,-148.12764,256.29352,251.8537,43.08827,-96.68016,-466.84494,-652.0633,-594.27576,-512.14935,-558.763,-343.88736,-208.48183,-115.26316,-5.292691,-7.76521,140.74997,267.50583,374.96332,568.40625,436.36493,397.01044,564.2024,650.3889,622.73846,792.792,482.79446,-74.984024,-281.38748,-274.2149,-85.45378,506.82327,459.82584,570.1573,307.36737,271.4853,160.07448,1059.5942,1457.071,498.60342,299.52988,199.55988,155.29185,87.91571,71.26435,137.83449,202.53485,365.23978,656.0514,711.5757,526.00134,739.7009,1012.9169,1470.4432,1141.2537,427.52002,636.8515,122.6277,-125.39999,-257.79657,-246.30896,-334.50635,62.47669,85.94969,-281.31064,-1018.14374,-1334.194,-1512.5057,-2260.1392,-2936.7012,-2836.3076,-3196.7205,-3295.749};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {-3409.4805,-3513.5503,-3588.2195,-3548.2437,-3590.9695,-3568.9487,-3702.7864,-3583.0598,-3573.146,-3570.3171,-3592.446,-3586.4622,-2141.178,-1966.7008,-2001.4637,-2084.2112,-2029.7649,-1959.0365,-1912.5084,-1829.4316,-1847.2559,-1782.1039,-1650.287,-1681.5732,-1770.5758,-1911.753,-1960.2281,-1959.21,-1972.3658,-1950.005,-1644.6993,-1771.6964,-1933.7148,-1773.7054,-1810.723,-1728.2319,-1666.3885,-1483.4808,-1439.0736,-1639.0859,-1884.225,-1815.0449,-1745.6492,-1279.2712,-1182.7701,-1073.998,-925.1797,-948.4588,-1145.7361,-1456.9438,-1514.6669,-1524.8927,-1357.8663,-1016.5351,-951.1614,-553.9657,-442.9509,-532.0122,-775.79315,-1060.4165,122.31395,170.27238,-82.309746,-321.96677,-540.6718,-421.66937,-507.2163,-970.7618,-430.69003,-27.401033,-227.22923,222.99854,325.5378,248.70578,635.4918,403.52823,356.77338,293.35986,420.46027,635.2496,784.4435,-141.39256,-120.44682,-188.45175,-273.63217,-171.1925,413.38586,591.5474,707.28,898.1191,813.28265,897.3907,1534.3522,1627.7562,537.84717,232.67513,128.99446,97.20616,94.19928,56.861595};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {98.048645,164.25555,189.79312,559.6103,854.8049,811.60956,816.586,796.9599,1168.2611,729.5017,-302.52097,458.07602,106.82077,-103.34705,-179.03256,117.252495,-43.903526,61.609325,-298.24533,-952.57446,-553.2305,-1052.0435,-1195.8932,-1803.0415,-2522.58,-2472.609,-2802.8171,-2993.211,-3069.8757,-3217.6619,-3353.7932,-3408.5386,-3474.143,-3491.4326,-3491.0552,-3457.2495,-3474.2852,-3473.4875,-3528.035,-3554.4202,-2101.8906,-1924.7117,-2034.2711,-2024.2982,-1986.3951,-2039.8403,-1918.4401,-1796.6167,-1919.6948,-1817.4114,-1749.8119,-1780.8342,-1969.7438,-2018.7957,-1975.4667,-1945.4097,-1976.8083,-1896.6581,-1837.8862,-1607.0151,-1486.5918,-1830.827,-1838.7715,-1887.0233,-1854.0317,-1864.772,-1834.543,-1838.0718,-1918.76,-1805.4425,-1762.9651,-1383.2455,-1360.8131,-1346.5576,-1146.3475,-1047.3905,-1312.807,-1558.6984,-1560.1123,-1395.3756,-1027.3046,-927.2346,-1189.5619,-1146.3345,-1073.1738,-933.3153,-1164.2672,-1784.3442,-757.0226,-89.69989,170.53629,-247.81894,-476.48038,-828.6863,-622.4752,-966.6536,-450.63684,35.676502,74.90797,294.93527};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {554.9751,598.9939,589.00964,410.67804,321.0023,290.14972,239.41232,555.5509,424.71426,34.13356,412.99777,144.44266,101.88869,331.349,612.6081,591.3432,600.5007,524.131,622.4629,942.4625,1549.8402,1412.1722,-283.75876,110.67746,133.81891,118.75886,112.769455,95.38388,85.57723,186.91254,353.98703,971.6413,783.16925,686.1984,1094.0839,590.9022,706.87067,427.9033,556.71216,623.4862,413.01535,164.84407,-115.54616,-239.55898,41.536366,-348.16928,-211.78265,-521.28174,146.55048,-738.31696,-922.37555,-1196.2186,-1567.7163,-1901.2887,-2474.6467,-2565.9106,-2531.3462,-2811.4937,-3043.4138,-3151.3833,-3267.2527,-3285.9727,-3327.136,-3355.2861,-3363.1936,-3348.5347,-3385.9246,-3465.7566,-2128.396,-1909.3535,-1946.3926,-1954.052,-1951.413,-1903.4781,-1708.9459,-1849.2081,-1927.336,-1875.0524,-2006.2369,-1993.3154,-2134.0068,-2184.1,-2279.1538,-2009.8094,-1912.4148,-1952.146,-2022.6176,-1760.6635,-1492.9421,-1735.4384,-1940.7467,-2012.8574,-2002.8306,-1980.8416,-1980.8892,-1944.5343,-1738.6207,-1632.4418,-1379.2018,-1324.1533};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {-1411.6299,-1373.9126,-1095.8077,-1003.88367,-1364.1438,-1546.7612,-1517.2235,-1409.3466,-1137.8254,-1163.0665,-1187.3762,-1336.9237,-1208.1193,-1291.1614,-1134.148,-994.06384,-804.96124,-690.1799,-97.55706,-249.16304,-433.03314,-659.45306,-547.66156,-386.36697,-154.65535,-18.732954,91.54382,86.43315,437.13812,588.50305,498.9872,393.73843,348.01407,363.94202,397.17926,420.57205,459.7893,657.9417,126.214325,-192.24632,816.0688,835.3958,492.3355,-243.26239,367.71567,428.6271,398.812,831.30927,1431.7366,1754.7683,233.53682,285.0368,176.50789,134.93515,134.36151,108.7043,92.5785,241.60774,675.6482,-40.318573,-1145.1832,-1154.7975,-34.66536,664.0313,775.04895,8.491375,646.0159,739.32574,304.4749,136.48882,-163.91469,268.07812,419.53726,71.15914,-344.37384,144.3366,289.40125,-694.9966,-849.3691,-1201.8755,-1509.444,-1910.8855,-2325.5974,-1985.768,-2323.5242,-2673.4429,-2753.2007,-2902.221,-3057.2476,-3028.1636,-3102.5205,-3262.6492,-3190.4067,-3262.5085,-3245.286,-3310.753,-2088.6846,-2096.905,-1952.1903,-2097.4297};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_42()
		{
			double[] value = {-1929.0793,-1919.1262,-1895.3048,-1974.5414,-1919.0343,-1903.6567,-2149.0188,-2074.6196,-2132.329,-2293.436,-2157.344,-2281.0088,-2235.8308,-2188.011,-2213.7463,-2043.0853,-1823.9691,-1565.2382,-1952.5588,-2065.3596,-2034.8422,-2005.6066,-1998.3225,-1935.469,-2141.9758,-2125.1213,-1322.7599,-1236.2284,-1385.6238,-1330.7714,-1085.7548,-972.0205,-1670.0175,-1424.0939,-1365.477,-1225.6193,-999.0028,-1208.8033,-1388.1743,-1322.4578,-1305.631,-1245.7307,-1232.7726,-1294.2894,-1132.8226,-694.77856,-438.4021,-10.585337,-303.24615,-534.0915,-700.8756,-605.582,-295.55795,-168.12625,-144.39693,-4.699874,119.65846,89.773285,244.63574,274.85672,281.224,275.50275,432.41852,383.73434,356.79477,378.1832,-131.1586,1.870318,563.38196,592.2858,222.08485,-446.25128,397.0234,493.4489,649.0613,1103.5466,1451.9816,1684.4272,763.4812,305.44113,182.13756,137.97247,90.8864,61.5467,107.29215,387.93515,500.3653,-761.3931,-1019.64954,-1139.0,-770.9437,23.070961,395.07568,551.0064,572.9399,948.1691,758.1036,192.7842,159.82735,420.04526};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_43()
		{
			double[] value = {113.36319,-375.07614,-392.25043,3.546774,316.48322,-631.3216,-1036.4338,-1039.9268,-1155.4064,-1627.9564,-1633.8569,-1950.3369,-2215.9546,-2322.4402,-2347.8123,-2593.5742,-2739.582,-2754.01,-2842.0994,-2979.9302,-3018.451,-3065.054,-3179.2263,-3270.0183,-1890.2551,-2147.4077,-1999.1239,-2409.5186,-2069.589,-1948.5448,-2119.1382,-2075.351,-1991.8923,-1989.2246,-2139.1763,-2136.8694,-2194.4946,-2182.0554,-2166.8179,-2174.7456,-2289.1472,-2531.5256,-2616.625,-2368.2202,-2070.318,-1527.862,-1896.9746,-2062.0623,-2035.0671,-2018.9734,-1970.0416,-1935.9943,-1816.8851,-1730.4424,-1410.766,-1139.2401,-1356.6818,-1286.0801,-1059.7611,-1182.6466,-1340.2639,-1465.5245,-1464.4413,-1348.5105,-1638.4647,-1584.5651,-1546.5095,-1330.6788,-1369.5764,-1260.4987,-1377.3226,-1442.3105,-1447.7054,-1189.5645,-622.2031,-238.69632,-522.75793,-675.3245,-894.95905,-798.9242,-513.1126,-381.31546,-290.60306,-98.5781,77.6227,1.158678,-83.981186,8.236222,62.158688,246.8221,493.23743,467.25513,474.7374,652.80176,593.4874,516.86084,300.05316,341.20486,410.16043,342.6803};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_44()
		{
			double[] value = {347.3869,508.5861,826.39105,1218.8126,1341.1892,1424.043,968.93195,586.57184,313.48428,210.16377,183.41449,196.39024,220.67369,565.1068,865.1086,-389.6997,-1087.6914,-1195.6259,-693.0359,-195.54433,124.64879,508.53818,391.80795,745.4358,579.4056,609.4928,486.9747,47.242973,-24.902514,396.08698,-32.07537,-330.07874,184.36356,-353.25085,-646.497,-911.656,-915.76196,-1148.5175,-1385.5741,-1645.5061,-2010.3574,-2051.4143,-2137.039,-2278.7898,-2398.538,-2539.3481,-2620.9407,-2788.9402,-2903.5234,-2927.0723,-3146.4133,-3269.3872,-2000.6423,-2124.1184,-2211.0054,-2139.2627,-2091.9866,-2048.3633,-2144.964,-2159.8672,-2083.803,-2200.6138,-2211.7144,-2154.24,-2116.0298,-2043.0157,-2041.6107,-1987.9412,-2056.6418,-2477.3499,-2646.586,-2391.2112,-2119.5422,-1624.438,-1868.8672,-2121.6301,-2061.8352,-1989.372,-1979.461,-1836.8623,-1767.7267,-1441.4885,-1078.1627,-930.03033,-1371.9418,-1339.2103,-1412.895,-1605.4445,-1574.3472,-1583.4916,-1394.8888,-1138.1381,-1257.5187,-1780.3676,-1642.3445,-1605.8505,-1584.5713,-1487.1185,-1470.7145,-1503.0947};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_45()
		{
			double[] value = {-1536.5397,-1153.6514,-403.3899,-293.49683,-831.0694,-1059.011,-1135.5232,-990.45795,-612.01953,-444.48215,-403.245,-592.55237,-395.09036,-418.06064,-416.9825,-278.2555,-26.441742,246.90718,561.9913,-819.64996,-113.07243,232.65846,212.27393,548.7873,288.51132,208.62683,216.5563,231.96088,298.86392,510.7541,980.62164,1181.7556,1203.7544,1099.0347,1034.4047,1499.1716,786.59814,359.6399,288.41928,371.60132,461.0124,886.9304,1778.8262,1079.0859,-250.53423,-576.56836,25.011871,516.7247,602.68915,516.07227,538.0525,565.0471,493.77078,476.9943,476.7889,391.4988,502.5822,338.7644,334.62057,-110.63564,-569.9497,-406.4925,-390.3138,-644.345,-795.3012,-1446.2689,-1506.3042,-1713.4309,-1942.8639,-1938.1084,-1979.4645,-2053.6226,-2195.104,-2334.2175,-2482.7183,-2638.66,-2782.2183,-2943.5002,-3127.7954,-3249.0283,-2036.2734,-2114.43,-2140.2124,-2199.69,-2280.3704,-2174.4004,-2141.4736,-2176.2656,-2205.8796,-2346.9644,-2192.009,-2134.2146,-2196.3096,-1981.9896,-1827.8041,-2250.1562,-2249.295,-2271.786,-2445.5627,-2322.7375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_46()
		{
			double[] value = {-2094.5398,-1766.0763,-1794.7782,-1993.7874,-2046.738,-1991.3617,-1993.2239,-1905.8276,-1745.0872,-1354.6495,-1090.8129,-1215.9043,-1492.8419,-1487.6849,-1687.1129,-1647.8527,-1636.3859,-1632.7207,-1459.6237,-1106.584,-918.29083,-1754.2086,-1790.2115,-1828.7086,-1752.4886,-1641.8402,-1556.6625,-1582.675,-1599.166,-1256.2043,-351.07416,-451.0822,-1075.326,-1170.6848,-1183.2496,-1123.1208,-816.78516,-395.27243,-545.1632,-425.41113,-600.413,-712.5112,-664.50946,-514.6561,-117.72927,460.73328,261.12634,-1006.6371,-1018.0717,-896.2245,-502.40707,517.647,291.04938,162.27754,76.56608,-35.57851,350.57043,653.6108,877.4737,999.34216,1172.7081,1170.0673,1216.5219,1447.0183,1439.2261,828.0343,553.59436,638.69476,725.8952,1080.5316,1499.8434,1597.9379,916.52606,458.49817,475.18024,612.23724,582.23413,517.4389,390.38654,412.9488,469.8321,350.96042,322.893,367.93808,654.2187,25.729319,-80.851006,225.0545,-347.3957,-512.08124,-233.14587,-230.54855,-349.70255,-1292.6926,-1549.0448,-1596.3689,-1824.6166,-1867.8834,-2051.8723,-2010.4125};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_47()
		{
			double[] value = {-1966.9034,-2233.203,-2374.9773,-2556.2625,-2764.4072,-2962.204,-3188.9485,-3327.1155,-2126.9685,-2093.8262,-2220.1274,-2394.1519,-2470.863,-2343.1375,-1983.2799,-2181.4883,-2295.9333,-2331.6033,-2247.5125,-2204.7896,-2195.8472,-2108.266,-2231.3694,-3231.8904,-3093.2888,-2270.494,-2291.9385,-2217.65,-2025.509,-2054.4097,-2146.0576,-1838.6407,-1814.8844,-1961.4269,-2045.2524,-1977.4506,-1784.3279,-1489.0857,-1356.4625,-1371.217,-1434.9557,-1514.9355,-1662.019,-1617.7443,-1683.1733,-1625.1017,-1431.0913,-978.19183,-307.71564,-842.97,-1544.8344,-1772.4376,-1627.9331,-1519.6564,-1591.6494,-1660.804,-1430.5991,-712.89343,-147.05255,-682.79205,-1220.1681,-1226.4739,-1190.9795,-969.18646,-605.83575,-314.40854,-664.36694,-741.7513,-744.3025,-899.9674,-892.96356,-752.45374,-310.23975,301.24884,-339.05316,-1338.7045,-1386.7268,-1410.2496,-740.81036,370.13538,170.84116,16.12849,-91.16803,112.8707,276.9475,816.5034,826.0155,690.9516,-56.86239,367.7107,1065.6161,1124.7614,1034.0895,945.255,778.3984,578.93976,743.0403,892.59155,1003.8442,943.6372};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_48()
		{
			double[] value = {493.9512,603.596,417.43723,320.855,451.30988,580.98035,428.9668,272.05856,287.39716,316.50177,294.66833,478.66348,107.84678,875.04645,778.18286,580.6489,293.56207,-89.05573,-517.7023,-119.77547,144.26562,-717.32947,-1026.28,-1543.4017,-1796.1074,-1602.5393,-3078.779,-3111.2588,-1762.6686,-2217.0083,-2398.0051,-2593.6477,-2809.2715,-3074.4238,-3266.0156,-3350.4504,-2183.4497,-2099.3884,-2221.8516,-2428.9602,-2512.3096,-2441.422,-2278.0334,-2726.257,-2349.2432,-2210.243,-2242.975,-2279.1123,-2144.2363,-2072.9214,-2221.2031,-2745.4434,-2623.3362,-2082.744,-2081.3657,-1943.664,-2033.2163,-2152.5867,-2036.7021,-1846.6179,-1559.2819,-1745.6423,-1839.3672,-1868.2166,-1868.3054,-1612.3466,-1403.5315,-1318.5161,-1347.5461,-1499.8955,-1577.7427,-1657.3916,-1669.3662,-1670.5243,-1595.9592,-1342.4263,-765.10333,-561.05035,-836.9989,-1279.1012,-1300.2543,-1334.8789,-1473.6576,-1493.2986,-1169.9752,-885.97156,-491.3216,-958.9738,-1257.899,-1500.0597,-1031.7423,-1295.7842,-677.24945,-534.35205,-1157.5608,-1282.581,-874.1939,-935.16547,-1198.175,-831.47284};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_49()
		{
			double[] value = {-488.61356,-10.805817,-219.89932,-883.7124,-1310.6528,-1199.0377,-345.45203,116.33831,-223.11635,-274.66922,-437.61765,-227.80357,238.57762,-138.54144,-619.6128,-306.47668,-1468.5078,-1246.1471,589.81213,849.1241,767.8168,666.69617,517.6797,251.63489,-801.46576,-366.46713,161.87408,873.2384,713.1251,504.86667,81.27042,221.54118,692.4774,757.20337,542.7304,406.33203,475.6223,689.875,553.9688,714.8048,809.09106,767.52124,266.90817,521.9074,-26.617977,-161.76062,-134.58531,-200.90987,-460.90036,-779.00323,-756.72906,-1285.5479,-1622.7202,-1629.1842,-2283.491,-2349.8015,-1918.8772,-2268.5498,-2507.4392,-2739.2527,-2930.2607,-3144.5012,-3305.9226,-3400.6238,-2104.636,-2124.3118,-2112.2637,-2195.2017,-2410.2703,-2458.7346,-2274.5176,-2176.225,-2002.4872,-2101.843,-2142.6218,-2131.9963,-2076.5798,-2064.9788,-1982.0138,-2019.4338,-2196.8013,-2087.4314,-2308.4404,-2048.2986,-2326.6204,-2291.287,-1965.3077,-1760.793,-1626.0105,-1580.4255,-1534.2158,-1540.2361,-1515.1294,-1801.2821,-2657.31,-1652.2561,-1202.5673,-1489.6063,-1555.7496,-1620.301};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_50()
		{
			double[] value = {-1688.3397,-1740.7205,-1627.6896,-1463.8466,-1084.7324,-574.65405,-353.5923,-844.25775,-1999.5947,-1464.6302,-595.96356,-582.5863,-406.64838,-499.11407,-1198.1896,-1207.9366,-1225.8757,-1202.0958,-803.6583,-867.2378,-840.90485,-616.2265,-720.15546,-909.58246,-860.67975,-918.1561,-1263.2683,-834.2626,-572.4592,-309.18332,-345.47418,-405.76834,-501.54935,-395.064,-327.7359,-393.4398,-765.37427,-586.7422,-555.4317,-401.30505,-273.5973,-1475.1954,-1187.7871,234.89447,-600.4026,-16.653175,732.1913,598.50684,565.0315,340.3355,356.76886,407.94354,-752.63293,-981.8995,-149.57391,580.6874,627.772,582.93915,129.67221,335.04843,715.54114,418.60468,723.34564,807.0681,860.7461,872.9927,848.93567,826.7846,832.9586,-537.26117,-40.525967,-364.85364,-849.712,-819.6169,-304.52368,-24.862846,-384.14624,-968.94965,-1242.6012,-1537.8944,-1681.5579,-1724.5887,-1845.5397,-2016.6532,-2239.4634,-2432.862,-2666.1648,-2940.4229,-3073.353,-3262.6401,-3377.1187,-3456.2717,-2107.2139,-2513.357,-2250.8616,-2644.8967,-2217.0776,-2292.786,-2383.6804,-2152.6724};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_51()
		{
			double[] value = {-2540.6777,-2266.1448,-2166.6428,-2056.9521,-2318.7627,-2603.4072,-2479.105,-2041.158,-2674.8127,-2087.3938,-2292.0928,-2313.6116,-2393.4756,-2041.0947,-1818.3981,-1802.6271,-1794.3608,-1664.3799,-1702.7827,-1410.2357,-1386.3654,-1683.6053,-2609.076,-1624.6326,-1091.1729,-1279.5416,-1490.9436,-1628.4595,-1669.2762,-1676.4502,-1606.7568,-1808.5674,-1357.6658,-602.8211,-267.15836,-574.9621,-1701.0503,-1097.0026,135.92851,54.23819,-275.7884,-1186.7871,-1318.7971,-1233.192,-1232.9023,-1014.25885,-833.9422,-954.0968,-863.2349,-757.7185,-851.0129,-903.39166,-876.6864,-844.27795,-916.48096,-887.54895,-845.49713,-1162.0863,-1193.3151,-1137.9435,-1015.80133,-919.86273,-825.01294,-818.97095,-871.9303,-865.89557,-729.2875,-451.8698,-226.51285,-732.3303,-124.95843,657.91595,498.3346,560.0125,471.93527,337.65845,218.97513,126.27463,233.02469,330.92703,288.70673,-174.89705,377.7543,541.2004,660.5314,728.0292,606.86456,320.2897,282.97437,259.1231,689.3507,847.53406,934.4841,695.54,1197.965,742.01373,661.5567,431.74652,530.85065,-288.83258};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_52()
		{
			double[] value = {-1025.3981,-1178.3782,-852.7423,-446.05264,-555.73584,-1279.6873,-1552.8347,-1674.6151,-1827.5692,-1909.1909,-2018.6038,-2234.454,-2445.5452,-2625.8967,-2986.4841,-3145.0396,-3286.6497,-3374.039,-3439.912,-3519.0205,-2138.31,-2386.1575,-2191.6516,-2201.9128,-2416.2073,-2326.343,-2392.483,-2275.0876,-2252.5,-2214.7708,-2155.5786,-2035.7682,-2401.6233,-2720.6123,-2661.9094,-2250.8809,-3254.6172,-2282.8765,-2406.1934,-2408.602,-2272.2588,-2066.4888,-1889.6111,-1847.4718,-1861.592,-1717.2444,-2021.7776,-1472.2504,-1416.8638,-1470.0251,-1556.1077,-1339.4296,-1166.9004,-1568.9202,-1559.4102,-1655.8466,-1706.4507,-1710.3275,-1796.1467,-2451.9365,-1882.8105,-991.0059,-708.24005,-472.67175,-358.3721,-287.1426,-111.94289,-137.64677,-342.40897,-879.68445,-1011.7171,-1106.4418,-1156.4996,-809.6396,-857.5033,-888.69727,-665.1201,-781.1908,-841.1494,-877.20593,-875.0376,-847.75104,-772.3542,-823.24274,-1131.1597,-1441.7051,-1687.748,-1619.0061,-1543.5969,-1411.3372,-1342.4937,-1360.9365,-1229.3665,-1037.0266,-722.9863,-533.87946,-927.93695,-108.71126,190.18045,165.35947};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_53()
		{
			double[] value = {202.65356,268.57867,285.57617,212.26393,222.88123,57.79619,65.23313,271.0478,354.15106,363.7653,481.00095,528.5136,592.02484,588.89307,596.8962,424.45154,450.85004,74.17823,738.65814,609.6087,657.41876,591.22327,587.20935,149.91393,147.84174,-201.10188,-1188.831,-1280.2607,-1850.7295,-1464.7311,-1250.4631,-925.86816,-1385.5585,-1757.3107,-1848.8634,-1812.9907,-1930.3188,-2060.161,-2553.6802,-2313.6775,-2596.9656,-2893.5564,-3178.0227,-3258.6953,-3344.5251,-3399.228,-3463.8015,-3543.8247,-2381.2476,-2286.058,-2412.4392,-2496.6934,-2664.8667,-2450.8535,-2311.1106,-2290.5085,-1996.1261,-2005.3789,-2017.0963,-1877.6703,-1773.6667,-2375.5728,-2157.5977,-1927.9497,-2139.921,-2296.2612,-2396.346,-2085.6829,-1993.8235,-2196.3438,-2024.8029,-1864.0913,-1787.5963,-1702.6774,-1624.8503,-1576.5404,-1432.3823,-1454.8892,-1497.3219,-1305.8558,-1313.3453,-1755.053,-1605.558,-1566.7814,-1669.5244,-1781.0647,-1666.9626,-1513.6797,-1213.3589,-1161.1459,-1108.5406,-879.849,-696.1701,-641.844,-491.00244,-374.4453,-500.82053,-771.10754,-941.71136,-977.4984};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_54()
		{
			double[] value = {-1129.6549,-710.8494,-833.0455,-521.73096,-505.88104,-740.2666,-859.72437,-884.2459,-828.19946,-715.5521,-727.932,-922.2732,-1433.4799,-1601.7223,-1634.6118,-1653.5048,-1587.129,-1562.7697,-1536.0048,-1391.9442,-1439.2095,-1242.0593,-845.8843,-566.16534,-168.6842,-15.068032,-12.008726,40.89676,95.02995,75.927666,158.8604,212.67622,-5.815143,-67.11309,-88.97159,-93.07571,185.22939,346.5573,330.79193,417.69296,355.64072,332.3092,383.3851,341.86813,672.4968,524.14136,759.3984,-135.87732,53.98804,-340.08743,-1619.5425,-968.6991,-1352.1116,-1915.2552,-1927.8264,-1807.6985,-1692.336,-1799.4857,-1655.425,-1893.1564,-2009.0519,-1938.6512,-2206.7969,-2083.074,-2140.1292,-2177.7993,-2739.2039,-2548.451,-2985.1602,-3047.165,-3233.1182,-3333.1257,-3390.3293,-3435.6707,-3501.2512,-3595.1814,-2523.9773,-2532.4927,-2622.2803,-2541.4998,-2546.3252,-2481.6072,-2425.9443,-2374.1128,-2668.8745,-3267.5972,-2558.9116,-1910.083,-2201.7969,-2389.4739,-2154.0737,-2190.1353,-2501.5164,-2579.41,-2317.7422,-2220.0537,-2284.834,-2149.3901,-2042.7904,-2075.6047};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_55()
		{
			double[] value = {-1799.1543,-1733.582,-1898.4192,-1731.8456,-1880.6058,-2078.0159,-1354.0587,-1466.4779,-1583.6241,-1528.6619,-1650.3252,-1683.8345,-1891.2203,-1641.0284,-1606.342,-1531.3821,-1452.6641,-1338.9943,-1271.7672,-1150.1835,-1142.557,-950.5052,-705.672,-444.9963,-404.77036,-600.27765,-717.4831,-732.0207,-901.0459,-681.3957,-634.9979,-441.69583,-479.42368,-733.5603,-718.416,-687.4088,-644.49054,-700.9318,-770.0203,-1007.1633,-1469.8369,-1647.8394,-1655.2687,-1604.6959,-1497.3016,-1467.3242,-1352.633,-1378.627,-1443.5565,-1305.8103,-955.18353,-730.7095,-383.33356,-107.38959,39.88771,-68.21129,-102.80743,11.511258,35.830013,11.48213,-93.331154,-177.40498,-121.74972,97.365486,258.87665,106.57641,282.33264,571.4571,472.15607,285.7644,126.34511,209.60591,347.48718,83.79214,751.41846,-695.76715,-883.32184,-49.608406,-1071.3815,-1465.7638,-1881.9902,-1757.6887,-1883.025,-1980.2711,-1776.1794,-1689.2917,-1804.6398,-2160.874,-1840.8838,-1834.6918,-2014.9877,-2371.2202,-2511.6555,-2573.6262,-2677.073,-2883.278,-3041.9807,-3246.6272,-3306.8213,-3442.9297};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_56()
		{
			double[] value = {-3447.3296,-3490.7166,-3570.0864,-3645.0742,-2614.911,-2615.0806,-2686.9255,-2481.299,-2581.9038,-2439.3625,-2330.6577,-2278.631,-2362.9673,-3164.4336,-2195.4966,-2286.7908,-2741.439,-2826.6348,-2653.68,-2340.3262,-2477.1997,-2741.921,-2242.8767,-2164.8682,-2138.7378,-1913.7428,-1907.7102,-1894.6741,-1827.6421,-2247.5288,-2039.5785,-1859.5443,-1936.1085,-1813.4525,-1298.6687,-1552.6508,-1740.5327,-1785.7037,-1788.802,-1779.2189,-1774.8678,-1464.8231,-1500.6647,-1467.7839,-1445.9371,-1313.2054,-1207.1107,-1155.1469,-1146.0397,-1001.0683,-820.8822,-444.66138,-343.74307,-561.049,-811.19183,-669.40765,-1140.6177,-763.8129,-809.54285,-856.876,-567.0607,-613.36676,-580.29956,-552.6411,-646.00354,-698.3858,-648.33093,-1011.328,-1392.8739,-1571.076,-1596.5499,-1569.6459,-1450.9875,-1406.8008,-1876.446,-1281.2023,-1383.4591,-1234.1079,-976.1925,-667.37134,-338.28723,-76.72934,-106.59991,-58.383503,-68.41409,-159.14352,-171.81865,-137.1506,-207.09862,-241.35904,-146.89574,-431.2628,-1003.2877,-811.03467,-916.1532,493.442,389.22977,237.9894,154.0328,515.07947};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_57()
		{
			double[] value = {-177.92392,429.65643,747.285,652.4157,546.35223,-36.568424,-771.5118,-184.47438,-1057.118,-1920.2313,-2105.6846,-2104.4263,-1607.2814,-1482.0822,-1886.4221,-2268.8042,-1922.9277,-2032.0978,-2095.288,-2426.906,-2707.4895,-2850.4875,-2954.7192,-3035.676,-3203.395,-3323.716,-3377.9438,-3466.7258,-3498.704,-3539.5337,-3614.8396,-3661.3362,-2586.1533,-2631.0708,-2594.4905,-2535.5566,-2479.2456,-2340.8965,-2254.473,-2289.142,-2341.1677,-2028.621,-2082.3025,-2477.2358,-2851.9604,-2797.3865,-2714.3428,-2450.2761,-2411.426,-2453.61,-2078.3604,-2003.6819,-1849.3143,-1842.9069,-1802.4307,-1598.9417,-1718.0735,-1690.0931,-1905.0131,-2076.592,-1929.6024,-1583.7837,-1336.1838,-1464.4186,-1505.3553,-1589.0931,-1778.6763,-1789.8756,-1675.2742,-1661.4198,-1682.1401,-1636.2275,-1361.1863,-1477.0162,-1306.1743,-1221.7122,-1171.3094,-898.17834,-777.2142,-441.038,-461.48697,-631.62506,-1044.2144,-914.7039,-973.9937,-804.7688,-565.75757,-606.95557,-567.47266,-483.5693,-556.87634,-601.90173,-523.5566,-508.23346,-890.2205,-1078.0784,-1277.7312,-1447.3645,-1726.6107,-1489.8884};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_58()
		{
			double[] value = {-1438.0498,-1464.7003,-1649.2339,-1304.8885,-1333.2205,-1129.217,-815.3123,-599.64594,-672.9384,-285.66064,-152.31804,-164.82387,-340.3831,-299.33167,-190.31882,-306.14136,-487.4377,-398.08643,-451.64252,-198.42944,-265.20667,-1304.8943,-907.7403,199.56775,-10.398579,-588.27527,104.74422,449.75876,-584.9044,-632.1138,430.02338,204.15771,109.37178,-273.95715,-584.5462,-1068.4747,-1592.8179,-2056.4756,-1923.7915,-2064.9353,-1989.9089,-1820.2024,-1975.4254,-2172.7925,-2310.5386,-2450.6108,-2580.9546,-2659.4602,-2940.9768,-3044.6914,-3140.1025,-3213.1511,-3305.1282,-3361.4597,-3425.838,-3490.5793,-3527.2522,-3572.2092,-3664.7478,-3717.585,-2493.9185,-2450.4822,-2503.4727,-2414.031,-2240.524,-2220.1265,-2239.5747,-2299.8008,-2600.6416,-2386.7996,-2390.7107,-2283.5903,-2205.699,-2455.0908,-2315.3306,-2278.0159,-2339.7905,-2248.8533,-1976.9275,-2095.8977,-1760.2671,-2127.587,-2246.944,-2179.2744,-1679.6543,-1767.3875,-1909.2216,-1948.6793,-1892.5024,-1645.8016,-2162.6384,-2987.5005,-2202.9473,-1513.7197,-1585.509,-1718.6472,-1802.9908,-1896.6945,-2031.9396,-2522.3342};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_59()
		{
			double[] value = {-1964.7494,-1042.0223,-1030.925,-1058.2949,-1028.7662,-884.27094,-788.64856,-633.87445,-611.59265,-606.37,-694.40814,-771.3294,-815.5789,-836.5748,-633.97174,-498.0914,-478.76422,-506.7845,-576.21924,-614.82245,-473.51273,-583.1256,-898.47675,-1038.001,-1284.7708,-1422.5793,-1439.166,-1410.6807,-1406.986,-1422.6295,-1246.264,-1295.771,-1107.1746,-991.7333,-820.9095,-555.8797,-1084.289,-309.30792,-177.21861,-240.00093,-284.24716,-353.34796,-212.443,-492.69965,-619.98535,-481.36694,-502.134,-389.82605,-212.70467,-409.99915,-481.4333,-318.73447,-377.68222,-414.54044,-115.66653,94.184395,-89.56255,-516.4631,297.5145,83.34607,-61.021748,73.4265,-128.75996,-831.3597,-2318.4375,-2236.991,-2135.4487,-2085.1914,-2102.807,-2047.0875,-2192.8723,-2391.0957,-2618.637,-2707.0754,-2899.193,-2982.254,-3093.3555,-3145.8418,-3223.9578,-3268.0364,-3344.8926,-3404.2485,-3458.1912,-3528.6572,-3568.7717,-3629.263,-3670.563,-3730.6624,-2261.7102,-2272.8457,-2353.336,-2259.0684,-2424.6902,-2259.0461,-2258.4202,-2297.223,-2498.5647,-2373.6184,-2276.2634,-2065.0027};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_60()
		{
			double[] value = {-2108.585,-2192.7568,-2428.3992,-2255.3296,-2177.1233,-2009.5093,-1855.309,-1980.9763,-1853.0065,-2367.6572,-2527.9575,-2683.4485,-1801.384,-1986.9362,-1908.1575,-1955.2037,-1709.3896,-1381.5358,-2818.8955,-3703.022,-2848.0342,-1367.2134,-1510.4867,-1763.2124,-1788.1802,-1368.446,-1705.7405,-2202.552,-2660.209,-1752.3593,-1744.3243,-1107.1019,-1006.13947,-851.6624,-844.05804,-678.1946,-684.1194,-720.2605,-830.5037,-827.9515,-843.8693,-759.0899,-560.74896,-471.90707,-335.9165,-286.62247,-297.8523,-278.39575,-327.675,-530.33765,-735.58716,-948.5283,-1156.6903,-1282.0784,-1365.7155,-1341.7908,-1302.0795,-1243.6519,-1088.3041,-992.443,-797.3451,-1202.0121,-1198.0499,-512.84094,-364.53082,-272.7423,-558.74603,-245.1034,-403.4652,-308.81952,-463.78375,-829.6814,-1028.1094,-443.307,-388.5119,-826.8082,-1065.258,-884.20544,-646.28766,-910.9463,-901.977,-534.90155,-278.83112,-30.751774,157.02155,-446.52014,37.676067,-48.098385,-568.99866,-435.17404,-635.4078,-254.25665,-1178.5651,-2199.8696,-2152.102,-2029.9496,-2164.7952,-2322.002,-2377.5066,-2519.8232};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_61()
		{
			double[] value = {-2673.8672,-2735.346,-2834.5261,-3025.5784,-3152.0813,-3156.107,-3275.8489,-3309.5593,-3384.1785,-3459.3938,-3513.6128,-3560.0217,-3612.438,-3675.6348,-3712.1675,-3739.0222,-2408.055,-2454.7358,-2261.5217,-2426.3625,-2133.8044,-2401.9502,-2230.9106,-2390.161,-2480.3896,-2536.2986,-2263.497,-2038.0337,-2313.2068,-2209.5728,-2242.1458,-2091.3188,-1921.9324,-1918.576,-2167.6309,-1808.0742,-1801.5883,-1698.2809,-1687.2649,-1746.9261,-2232.4578,-2163.5242,-1957.6892,-2105.3684,-1656.7816,-1363.5969,-1513.8151,-1952.8184,-1357.8981,-1242.9385,-1391.3473,-1518.5089,-1603.1748,-1302.3318,-1016.48505,-1093.7101,-2015.0897,-2239.3127,-2358.5654,-1428.8574,-768.51984,-794.7103,-1183.3285,-602.60596,-486.88608,-526.8309,-680.19684,-769.3635,-806.7783,-1080.2678,-616.08374,-102.18187,108.2541,-223.97304,-15.657997,212.15048,-56.963634,-364.1918,-584.3996,-844.8282,-913.75183,-991.5145,-1102.4406,-1128.1248,-996.2941,-936.72766,-793.7384,-650.67065,-448.58505,-521.96204,-509.19873,-478.20218,-455.09174,-431.05957,-768.82306,-569.75146,-436.05304,-439.33823,-542.9254,-873.7773};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_62()
		{
			double[] value = {-1651.4615,-1380.9806,-1046.566,-1247.7697,-1595.0824,-995.4456,-741.2291,-1167.7328,-1164.9222,-733.65656,-348.07248,-127.4788,-203.1169,-353.30273,-513.5756,-675.25116,-1342.2059,-1028.8528,-1141.543,-1518.6613,-1802.1282,-2124.8508,-2202.8618,-2381.085,-2416.3196,-2447.6365,-2653.6018,-2855.661,-2783.536,-2836.3086,-2984.3137,-3078.6409,-3180.1633,-3308.9814,-3328.2212,-3361.5059,-3433.232,-3509.3398,-3543.8306,-3590.3494,-3641.0637,-3698.9546,-3731.5813,-3778.0242,-2434.4607,-2387.2437,-2369.0222,-2231.4004,-2147.9927,-2324.0762,-2711.704,-2474.7239,-2355.7793,-2396.2776,-2378.2424,-2301.8938,-2268.7095,-2099.8823,-2045.4381,-1964.0962,-1887.3232,-2182.8713,-2588.558,-1863.5924,-1703.7743,-2037.1096,-1918.863,-2048.8735,-3185.801,-2220.8535,-1786.1497,-1744.5801,-1735.3961,-1427.7012,-1435.325,-1263.3192,-1106.4254,-1274.6011,-1351.9746,-1322.9816,-1377.3153,-1249.8214,-1120.9987,-1198.8136,-1802.7704,-2192.269,-1961.3888,-1285.9164,-774.47504,-882.7557,-1172.0364,-539.4716,-509.445,-801.7523,-1004.7477,-499.04175,-684.57294,-1357.2478,-837.91547,-266.56982};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_63()
		{
			double[] value = {-808.79047,-1203.2251,-1271.3492,-31.13177,137.95763,-220.932,-554.7213,-698.66595,-648.0534,-648.2728,-591.53644,-610.99335,-609.5943,-566.6131,-352.9918,-344.51746,-301.71793,-425.38617,-584.2844,-458.34225,-379.3125,-517.0435,-552.36896,-564.66693,-540.2969,-495.91003,-683.70276,-1466.8691,-2073.691,-2086.3704,-2046.5938,-1652.5227,-1685.9138,-1375.2277,-1147.2076,-1622.8911,-1791.2723,-1326.037,-906.21136,-682.0903,-938.33167,-773.80756,-976.6446,-1185.1703,-1663.1055,-1587.3746,-2272.0977,-2078.3708,-2223.9233,-2304.6587,-2253.2158,-2599.452,-2388.559,-2651.4482,-2998.6592,-2942.9565,-2880.2097,-2988.453,-3057.1206,-3137.8696,-3245.4458,-3353.6604,-3363.8745,-3387.8394,-3514.4475,-3544.4321,-3574.7708,-3622.8604,-3672.048,-3713.3455,-3773.507,-3842.4607,-2227.5679,-2248.8738,-2378.181,-2289.472,-2382.0188,-2298.6914,-2336.7156,-2505.676,-2270.1045,-2487.6582,-2357.3254,-2169.0198,-2617.5417,-2330.2979,-2051.208,-1946.2975,-1890.2814,-1872.7861,-1825.9531,-1811.1931,-1848.3568,-1909.1318,-1964.239,-1979.6436,-2517.9927,-2106.9949,-1819.2815,-1827.1543};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_64()
		{
			double[] value = {-1826.3853,-1655.307,-1689.246,-1573.6509,-1534.2379,-1375.124,-1333.5835,-1519.2439,-1567.795,-1512.5851,-1433.3314,-1827.4026,-1128.6963,-1126.2677,-901.85675,-919.83295,-825.0605,-843.94885,-617.979,-637.10736,-601.67426,-1020.86194,-1675.6208,-1016.5789,-662.9992,-741.7868,-507.26227,-45.04527,-900.4799,-1363.5103,-1322.0804,-83.874626,165.64221,-126.92373,-346.46918,-395.98798,-329.3177,-293.20847,-241.80408,-223.15115,-183.6551,-141.93979,-160.82817,-37.093773,-69.0887,-200.54762,-262.49506,-325.60855,-305.29013,-481.39456,-489.8088,-655.7194,-392.38892,-522.1477,-604.61346,-1240.0331,-1381.6183,-1976.5115,-1902.7979,-1451.9905,-1577.5892,-1717.0828,-1881.4155,-2102.5688,-2182.3784,-2208.5234,-2001.5952,-1489.7332,-1164.7657,-1410.9344,-1518.9005,-1633.8403,-1837.5032,-2072.0435,-2302.7961,-2263.1367,-2269.425,-2326.4001,-2399.326,-2476.6814,-2471.3862,-2761.5403,-2995.259,-2867.696,-3002.7544,-3092.8958,-3153.057,-3178.7297,-3293.1338,-3418.3357,-3461.7297,-3493.3538,-3526.0547,-3568.8413,-3618.2285,-3667.1238,-3719.3225,-3762.731,-3795.3855,-3832.7183};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_65()
		{
			double[] value = {-3065.4075,-2519.2327,-2456.8643,-2414.045,-2370.043,-2258.6477,-2381.416,-2278.1646,-2154.3516,-2841.2388,-2213.6333,-2248.321,-2710.987,-2673.344,-2045.868,-2022.9989,-2129.4224,-2582.6555,-2209.2275,-2271.2678,-2327.415,-1995.9987,-2067.3794,-2226.364,-2136.6353,-1909.4874,-1822.9626,-1842.1964,-1865.1212,-1916.3453,-2162.5383,-1994.4124,-1905.7408,-1707.1206,-1598.7528,-1670.0378,-1916.8732,-1799.3276,-1626.127,-1668.5905,-1543.2886,-1547.3079,-1279.1289,-974.3063,-1093.4185,-1081.7705,-864.34985,-691.3873,-601.4997,-1209.3035,-1942.9307,-1272.8164,-712.39276,-760.34753,-557.6977,-33.08001,-168.09886,-537.1701,-469.8928,235.26987,117.100464,-121.68561,-378.46436,-236.6383,-109.75195,21.4426,-118.73089,100.58095,91.520035,154.81696,165.76225,206.22794,138.93997,8.242373,-102.45993,-226.23875,-281.81528,-360.84207,-269.37814,-718.9114,-774.30566,-467.40714,-897.7699,-1636.1747,-1588.5234,-1882.1042,-1486.1976,-1752.8304,-1859.6632,-1851.9799,-1746.5045,-2283.9011,-2362.6477,-2606.1846,-2353.6997,-2189.758,-1954.2887,-1928.3615,-1917.8721,-1543.7449};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_66()
		{
			double[] value = {-2025.9906,-2486.8372,-2305.5625,-2296.3977,-2311.311,-2356.5457,-2375.018,-2480.7957,-2634.4614,-2858.6653,-2862.0923,-2966.6262,-3065.5388,-3223.4932,-3270.6626,-3275.5054,-3349.1538,-3437.1377,-3498.012,-3528.7156,-3560.7498,-3615.8904,-3663.233,-3698.7114,-3749.5898,-3782.4329,-3820.8584,-3896.832,-3065.9033,-2849.273,-2548.9492,-2519.1853,-2578.889,-2397.8167,-2253.662,-2092.0164,-2093.5078,-2123.285,-2162.0173,-2316.1316,-2363.1968,-2431.871,-2333.9365,-2194.6338,-2126.4097,-2058.125,-3076.2324,-3361.4587,-3243.8376,-2611.61,-2182.24,-2011.7249,-2022.9062,-1882.7885,-1738.8007,-1695.3522,-1862.7838,-2270.4187,-2404.109,-2281.0151,-2255.176,-2230.2913,-1921.0107,-1802.4558,-1765.5902,-2143.035,-1850.3342,-1786.4277,-1786.6273,-1806.5485,-1358.1318,-1275.0624,-1423.1077,-1353.2363,-971.8524,-928.6969,-837.0098,-677.6634,-816.3805,-839.2157,-771.57227,-792.7633,-732.3312,-486.6113,25.189846,168.47247,111.16632,38.070164,-55.144176,-155.26645,-100.775314,-39.285187,104.438446,67.553,-103.19871,190.99489,298.33582,397.98358,427.3604,426.31482};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_67()
		{
			double[] value = {262.9152,75.83953,-79.796295,-181.10425,-206.83229,-78.546875,-80.222885,-598.343,-1191.902,-1651.6161,-2041.8773,-1834.3276,-1628.5442,-1321.2433,-1029.5471,-1518.3794,-1910.994,-2073.5342,-2188.7275,-2033.7002,-1958.5857,-1686.7142,-1800.9758,-2008.8964,-2263.4229,-2213.4946,-2050.9734,-2206.1907,-2286.295,-2249.49,-2336.4065,-2411.8247,-2365.0051,-2450.2485,-2499.1057,-2542.0806,-2810.7075,-2919.653,-2995.101,-3015.9924,-2954.507,-3216.014,-3288.0752,-3316.565,-3423.0872,-3484.819,-3538.8303,-3590.862,-3612.3894,-3630.2104,-3689.2905,-3723.4385,-3736.8406,-3825.3372,-3884.0437,-3947.0,-3118.622,-2679.5264,-2555.987,-2477.193,-2483.1062,-2362.0586,-2292.8743,-2180.6094,-2125.7898,-2157.315,-2235.0154,-2250.5935,-2279.3723,-2231.7712,-2275.5403,-2224.6824,-2079.8916,-2302.6006,-2807.0427,-3157.1309,-3391.8552,-2833.7056,-2267.6472,-2010.565,-2256.3787,-2484.676,-2109.3477,-1720.137,-1861.4869,-2162.9795,-2392.8792,-2329.5627,-2342.206,-2468.799,-2348.9114,-1982.3682,-1808.1,-1918.7964,-2374.731,-2079.917,-2074.857,-1946.0632,-1787.0802,-2241.5706};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_68()
		{
			double[] value = {-1647.434,-1575.3079,-1241.0796,-1140.5438,-1085.8884,-934.2065,-854.076,-785.70306,-773.46014,-704.1554,-582.26685,-459.6179,-354.19208,-101.04796,-125.862076,-238.15392,-148.67041,-132.2387,-108.7736,-45.538845,116.29808,178.74376,262.79184,321.0353,387.59195,387.6693,401.35843,401.84998,214.05838,158.08331,-45.278324,-94.50983,-432.55502,-112.237816,-264.31238,-1816.0963,-2539.9133,-2434.2317,-2331.371,-2124.0251,-2157.632,-1899.7938,-1477.3596,-1578.0839,-1940.6923,-1763.7133,-1420.0167,-1531.6127,-1733.6824,-1945.2435,-1526.6167,-1864.9484,-2076.5874,-2206.9336,-2153.1895,-2493.6418,-2483.451,-2361.5803,-2432.402,-2468.9763,-2477.4863,-2564.512,-2599.248,-2768.8474,-3032.3438,-3045.219,-3066.0918,-3072.5745,-3145.9292,-3253.7031,-3322.3364,-3371.3755,-3466.0798,-3549.1965,-3601.2607,-3629.268,-3657.3428,-3669.3643,-3701.586,-3737.0002,-3823.6846,-3889.9492,-3938.2708,-3980.1511,-3274.0164,-2789.4504,-2693.5498,-2633.5762,-2503.7788,-2458.1394,-2338.7878,-2296.487,-2208.0598,-2217.8757,-2261.3606,-2198.119,-2407.7297,-2448.176,-2468.0073,-2270.7922};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_69()
		{
			double[] value = {-2101.3372,-2532.2834,-2421.578,-2066.02,-2147.7659,-2208.6492,-2732.8948,-2231.3386,-2302.8616,-2879.0781,-2819.5525,-2897.218,-2446.8848,-2064.1052,-2214.9426,-2318.149,-2314.514,-2538.1191,-2620.488,-1983.5907,-1779.3667,-1777.7723,-1999.4534,-1928.5403,-2158.1716,-2282.9631,-1947.958,-1902.1342,-2184.2068,-1564.5626,-1566.5605,-1615.987,-1552.5917,-1310.9354,-761.3016,-552.4474,-890.43384,-794.43445,-736.3869,-531.2321,-338.85202,-174.98538,-204.14098,-121.83988,-62.455185,-41.972397,-31.582056,-14.748796,-177.65254,77.26184,253.88951,275.1882,324.0116,261.484,389.45364,123.83709,-244.93494,-17.158318,139.5824,74.68915,-758.1981,-551.30884,-601.1864,-832.15656,-2196.5515,-2342.8777,-2031.4677,-2261.7356,-2466.7568,-2475.8308,-2215.028,-2067.7607,-1788.936,-1532.2123,-1485.5641,-1680.0734,-1944.3375,-2155.1338,-2015.4883,-1901.0491,-2167.7148,-2365.4192,-2394.398,-2508.1516,-2444.123,-2421.2104,-2586.7966,-2635.44,-2664.6377,-2625.1416,-2633.8274,-2786.27,-2998.294,-3083.5205,-3157.904,-3179.6912,-3250.6736,-3323.7556,-3404.6023,-3462.5356};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_70()
		{
			double[] value = {-3531.8801,-3564.7642,-3611.4702,-3642.1582,-3657.378,-3707.382,-3723.7888,-3791.5193,-3857.6753,-3934.98,-4000.961,-4055.593,-3010.4023,-2767.6943,-2854.6118,-2705.1597,-2501.0852,-2626.5242,-2710.025,-2521.5452,-2782.5378,-2552.3508,-2877.3071,-2547.295,-2721.0967,-2738.8315,-2614.2349,-2380.182,-2194.769,-2130.7954,-2118.866,-2008.9103,-2018.5496,-2051.0168,-2172.434,-2359.3445,-2521.9697,-2221.6968,-1753.3701,-1943.2195,-2518.0266,-2223.3901,-1963.2698,-2056.4658,-2288.0955,-2726.563,-2356.0327,-1936.2843,-1853.9297,-1792.9954,-1826.9489,-1958.8267,-2034.7802,-2115.567,-2076.546,-1902.6265,-1929.6444,-1690.2789,-1635.4347,-1616.6074,-1793.4298,-1958.2323,-1008.8858,-968.9417,-946.8308,-962.7539,-1544.3866,-1430.1154,-856.4567,-546.49133,-396.17502,-63.397633,142.6304,140.1536,91.85686,55.021133,71.64648,166.6208,161.54631,102.693855,147.87904,178.57079,29.273636,-754.55817,-1168.2538,-513.2744,-29.243853,-177.04051,-231.72404,-282.66138,-467.97162,-813.66656,-1950.1448,-2284.5952,-2179.2834,-2444.094,-2481.525,-2496.7998,-2455.1394,-2266.8901};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_71()
		{
			double[] value = {-2095.8357,-2077.9814,-1784.8335,-1853.0931,-2041.1278,-2211.9214,-2289.4475,-2125.4866,-2341.9646,-2426.724,-2449.3743,-2518.7673,-2431.183,-2561.2163,-2681.1143,-2647.7114,-2799.393,-2738.0225,-2749.8125,-2779.3496,-3009.0051,-3022.182,-3060.8293,-3240.4111,-3281.7534,-3347.0999,-3394.1843,-3440.7854,-3667.3052,-3636.7668,-3640.7915,-3679.9214,-3697.852,-3740.1895,-3789.1199,-3847.686,-3886.8032,-3921.0981,-4014.1172,-4078.0647,-3179.7576,-3043.384,-3691.3792,-3249.3232,-2739.4573,-2907.6208,-2705.172,-3102.0352,-3070.915,-2590.0474,-2638.61,-2588.6008,-2693.3047,-2586.423,-2540.6404,-2449.9436,-2312.9438,-2224.3562,-2137.2974,-2190.8015,-2178.5386,-2123.6772,-2112.132,-2185.406,-2339.0188,-2111.2405,-2028.5876,-1922.8269,-2042.3958,-2733.6797,-1902.3735,-2027.17,-3060.7246,-3467.8616,-3109.0989,-2325.2227,-1879.5875,-1857.19,-1841.3784,-1968.0961,-1969.4739,-2537.663,-2196.6836,-1832.7909,-1822.4318,-1537.4071,-1481.4474,-1669.1255,-1718.3955,-1487.0476,-1233.1938,-1063.0311,-1037.7129,-1045.6138,-1435.612,-1336.834,-960.10126,-848.1386,-861.0386,-678.6062};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_72()
		{
			double[] value = {9.348033,154.47627,-106.383995,-1110.8131,-950.3393,-47.961956,-29.772234,-42.264183,-76.82507,-49.79603,11.277006,-233.85895,-770.44116,-376.9587,-135.78256,-275.83524,-640.28973,-525.21747,-586.8071,-1008.34674,-2038.7585,-2435.551,-2431.5625,-2377.3267,-2467.7012,-2478.4128,-2376.1724,-2219.982,-2156.0251,-2283.1328,-2230.068,-2204.7112,-2234.4827,-2353.7988,-2430.0127,-2381.1875,-2530.2136,-2540.433,-2526.4688,-2529.4492,-2583.9146,-2664.99,-2695.6772,-2710.8037,-2864.8206,-2897.4226,-2986.2908,-2997.8103,-3029.2354,-3123.0605,-3233.58,-3317.8787,-3361.457,-3408.0369,-3456.4558,-3512.4084,-3585.5454,-3654.477,-3683.1392,-3706.516,-3721.8909,-3770.3167,-3810.9092,-3879.5376,-3924.4214,-3957.1094,-4020.035,-4103.8555,-3265.9592,-3330.2412,-3311.6885,-3162.5361,-3086.0813,-3162.0242,-3041.734,-2892.3635,-2854.516,-3166.976,-3030.2654,-2959.2612,-2906.3755,-2655.848,-2562.114,-2480.6545,-2437.2297,-2331.2078,-2305.231,-2331.6128,-2281.462,-2172.788,-2384.5034,-2545.4375,-2719.1729,-2642.767,-2939.058,-2813.6267,-2756.432,-2980.1167,-2984.8018,-3349.5889};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_73()
		{
			double[] value = {-3511.9614,-3599.7163,-3515.7825,-2905.59,-1981.9702,-1943.2529,-1973.1711,-2037.813,-2459.5942,-3044.1575,-3113.2366,-2097.7722,-1717.9252,-1390.122,-1224.1733,-1378.5217,-1578.9465,-1577.7386,-1245.3928,-1300.5327,-1450.7925,-1497.0183,-1460.7299,-1360.7771,-1180.764,-1034.9083,-863.88385,-645.5677,-620.7408,-431.38284,-536.3905,-1449.8104,-1442.3652,-306.73834,-243.19911,-239.64389,-151.53307,31.49707,-109.60995,-161.91203,-376.68542,-406.46286,-291.13257,-413.0439,-541.408,-626.625,-704.94574,-2270.2776,-2818.3604,-2604.423,-2408.208,-2311.2583,-2420.2964,-2451.5793,-2376.0542,-2201.399,-2205.3748,-2382.7175,-2433.9714,-2477.3433,-2468.67,-2545.011,-2595.534,-2559.3567,-2634.77,-2643.7012,-2622.8958,-2736.3096,-2797.6367,-2811.1655,-2814.3245,-2904.144,-2969.359,-3053.558,-3066.0447,-3105.185,-3022.2336,-3220.687,-3319.3955,-3377.0,-3409.1587,-3465.3013,-3528.7017,-3586.151,-3619.4604,-3675.6992,-3693.9116,-3713.3494,-3710.0146,-3783.8958,-3874.6704,-3917.8767,-3941.0532,-4003.4893,-4067.9104,-4138.896,-3518.9263,-3532.8806,-3577.0017,-3642.3894};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_74()
		{
			double[] value = {-3731.1787,-3709.2183,-3546.0596,-3262.1658,-3125.9133,-3255.056,-3161.468,-3195.9302,-2959.2644,-2789.8965,-2724.6758,-2702.2065,-2625.8281,-2568.3528,-2498.0383,-2445.9673,-2339.4678,-2384.535,-2811.6587,-2251.6958,-2539.3586,-3360.0889,-3514.508,-2697.379,-2768.318,-3012.6025,-3020.02,-2986.0059,-3015.7126,-2987.8,-3025.3538,-2622.7717,-2066.5266,-2065.7258,-1927.1622,-2269.6812,-2980.0063,-3167.0781,-3030.0215,-2155.744,-1174.4368,-654.0228,-457.51724,-874.5356,-1712.3268,-1866.1764,-1632.7043,-1718.7097,-1830.4366,-1842.6459,-1725.8185,-1615.3748,-1501.3978,-1311.747,-1075.4335,-907.5077,-702.27045,-699.723,-796.60767,-1683.0076,-1628.4749,-1224.713,-1216.1978,-590.89526,-165.96513,-316.34906,-520.5054,-409.47177,-998.67365,-1785.0216,-658.9652,-774.86127,-796.2095,-609.9399,-894.2756,-2369.973,-2605.454,-2415.4387,-2415.7898,-2345.7205,-2370.3247,-2470.8367,-2453.014,-2402.0942,-2453.4785,-2554.8894,-2551.0625,-2543.8545,-2581.5037,-2665.2178,-2649.1575,-2689.8018,-2751.9636,-2774.6597,-2787.9563,-2892.941,-2900.287,-2936.7383,-2946.6868,-3037.0317};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_75()
		{
			double[] value = {-3098.3125,-3138.5403,-3103.4602,-3136.7495,-3208.4136,-3310.8535,-3369.225,-3461.8423,-3491.0835,-3517.793,-3576.6633,-3603.0945,-3649.5962,-3680.5647,-3722.6067,-3723.9258,-3734.347,-3780.532,-3833.6519,-3881.007,-3965.882,-4045.633,-4122.3887,-4177.396,-3809.8928,-3423.3923,-3549.5364,-3741.5435,-3819.2615,-3803.983,-3747.5376,-3516.291,-3418.5537,-3322.4321,-3268.137,-3214.9368,-3170.8386,-3101.7754,-2901.3264,-2852.463,-2873.7861,-2820.6123,-2607.9897,-2453.8916,-2328.5667,-2870.4614,-2439.9988,-2343.9248,-2523.1042,-3383.9688,-3377.418,-2210.5894,-2460.1887,-3268.5273,-3591.495,-3517.7812,-3565.1123,-3281.7786,-3386.5654,-3563.2097,-3286.1765,-2289.9604,-1885.0886,-2013.4773,-2059.957,-2904.1855,-2595.6714,-1198.9958,-1340.183,-1568.1969,-549.4986,-1356.2557,-1823.311,-1776.6533,-1758.9445,-1933.0361,-2042.7681,-1831.7927,-1825.9883,-1651.1077,-1674.1744,-1478.0833,-1201.3168,-1231.8308,-1217.1471,-1956.693,-2564.8936,-2652.3823,-1487.4412,-1238.6094,-2116.6853,-1981.2925,-807.23413,-592.6963,-1188.6566,-684.7158,-1203.4862,-1738.8295,-1630.7943,-2230.8896};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_76()
		{
			double[] value = {-2353.6604,-1258.6963,-1565.9777,-2106.4,-2098.2551,-2565.5967,-2503.5076,-2453.0615,-2388.9294,-2429.8652,-2355.9321,-2409.2617,-2387.3005,-2515.4954,-2596.565,-2666.1223,-2798.1555,-2866.1086,-2767.933,-2817.2212,-2866.1272,-2875.315,-2913.5571,-2934.9268,-2920.4292,-3121.3499,-3104.922,-3106.362,-3095.1013,-3082.6775,-3124.958,-3123.854,-3237.0667,-3335.2659,-3427.5208,-3514.9966,-3552.3003,-3583.936,-3615.9646,-3644.9104,-3664.7456,-3677.285,-3714.7783,-3746.6868,-3786.298,-3823.6724,-3834.976,-3925.7861,-3947.8154,-4073.2778,-4154.4907,-4209.149,-3878.7317,-3712.5864,-3684.574,-3761.4126,-3840.9,-3797.4004,-3779.39,-3681.0073,-3626.5066,-3545.913,-3403.327,-3434.9216,-3628.774,-3410.7222,-2995.2903,-3005.806,-3124.8157,-3129.749,-2765.5908,-2917.4675,-3303.3909,-3422.4038,-3262.9153,-3025.486,-2943.0596,-2913.3499,-2908.893,-2036.6771,-3216.865,-3658.1194,-3559.639,-3604.5295,-3681.162,-3631.264,-3560.2197,-3602.1985,-3604.3699,-3176.0864,-2944.3225,-2945.3914,-2469.6423,-1912.4613,-1638.7666,-2217.6394,-2255.0168,-2371.0708,-2366.1365,-2803.139};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_77()
		{
			double[] value = {-2084.2195,-2044.2816,-1903.9332,-2117.6753,-1886.9556,-2214.6675,-2035.5052,-1659.1879,-1679.8516,-1589.5815,-1230.6016,-1208.281,-1334.2212,-2582.8245,-4035.499,-3916.043,-3521.2622,-1807.0709,-1972.151,-1825.941,-1985.0851,-1627.2615,-1547.2161,-1545.8556,-2284.0415,-2408.3525,-2816.7708,-2799.812,-2750.1003,-1943.5618,-1701.4082,-2184.045,-2506.7708,-2673.5793,-2569.6138,-2429.7961,-2490.9753,-2585.9504,-2363.7424,-2307.5815,-2675.9863,-2790.0483,-2611.346,-2721.676,-2818.6328,-2823.1533,-2836.652,-2857.3198,-2934.0273,-3037.4277,-3106.4258,-3069.093,-3047.0278,-3115.694,-3117.5098,-3051.205,-3073.8274,-3147.8333,-3141.0217,-3145.6648,-3348.8564,-3463.1528,-3540.8064,-3569.8738,-3593.9036,-3613.315,-3630.644,-3664.6985,-3678.6934,-3705.5796,-3730.8423,-3750.7024,-3797.7834,-3813.7246,-3880.9495,-3949.8376,-3960.4902,-4092.869,-4174.6025,-4224.938,-3950.4468,-3909.193,-3895.4175,-3850.4392,-3828.0645,-3833.8608,-3822.0813,-3806.6538,-3816.2246,-3756.4844,-3649.2668,-3492.949,-3465.0105,-3303.792,-3179.2056,-3201.9692,-3347.2913,-2870.767,-2920.1868,-2992.5955};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_78()
		{
			double[] value = {-3462.8577,-3190.888,-3211.9417,-3268.1787,-3589.3196,-3402.29,-3303.847,-3120.7197,-3596.8687,-3654.126,-3371.8118,-3562.0696,-3677.6997,-3549.7336,-3178.9119,-3559.8354,-3389.3074,-3015.6018,-3495.5857,-3251.7751,-3018.4453,-2039.039,-2396.7886,-2940.9905,-3282.7988,-3203.457,-3195.639,-3008.9353,-2836.083,-3029.7185,-2169.3013,-1925.9684,-1952.5546,-1951.9026,-1842.5895,-1761.3291,-1664.467,-1488.6611,-1024.5211,-1372.0842,-2275.1538,-2979.7295,-4047.9985,-3906.537,-3469.228,-1694.9614,-1174.4166,-869.8849,-1216.8271,-2410.6497,-2146.8403,-1708.6365,-2516.8542,-2533.5002,-2575.0422,-2441.428,-2637.0317,-2623.1626,-2409.3188,-2415.7625,-2611.2124,-2657.1826,-2527.2036,-2579.5115,-2691.7007,-2689.0425,-2540.8694,-2398.224,-3367.4587,-3347.324,-2745.223,-2955.56,-2967.2832,-2877.1755,-2936.0618,-3408.8398,-3053.8762,-3077.9941,-3112.922,-3096.1592,-3086.4675,-3081.2583,-3109.2642,-3144.387,-3174.479,-3181.7761,-3098.8396,-3139.7214,-3476.7532,-3562.67,-3555.4272,-3595.339,-3599.8308,-3588.3884,-3577.9912,-3640.7878,-3702.2737,-3735.4734,-3752.4807,-3783.368};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_79()
		{
			double[] value = {-3829.2207,-3834.0078,-3927.749,-3975.8972,-4010.1758,-4076.683,-4187.4424,-4237.734,-4000.9246,-3993.4536,-3940.1394,-3910.3052,-3912.8237,-3910.661,-3898.9238,-3919.5347,-3931.2776,-3890.2266,-3708.0625,-3567.1372,-3611.3435,-3488.6348,-3451.6648,-3430.5344,-3172.3364,-3083.899,-3042.3503,-3195.467,-3409.0154,-2802.7935,-2757.6494,-3436.7666,-3564.6575,-3585.5627,-3413.126,-3633.113,-3723.6882,-3713.4302,-3694.737,-3725.09,-3717.4229,-3282.0364,-2959.8828,-3144.4705,-2572.741,-2703.6614,-3442.076,-3504.8936,-3434.5645,-3184.4004,-3426.6436,-3434.9602,-3371.3738,-3397.635,-3340.4578,-3406.7185,-3176.7266,-3457.669,-2725.659,-1664.2966,-1703.6748,-1730.1498,-1576.1093,-1386.6396,-1311.7268,-1218.1708,-985.59283,-2168.8325,-2667.3855,-2414.4758,-2145.538,-2157.0684,-1434.8113,-1202.862,-1050.4268,-1114.1177,-1515.7069,-2539.0808,-2708.9966,-2793.185,-2729.3923,-2386.7258,-2429.412,-2511.6616,-2496.9402,-2483.2876,-2411.7952,-2646.6196,-2582.346,-2440.2495,-2605.7627,-2660.3875,-2680.2676,-2674.9355,-2705.0703,-2641.829,-2624.8496,-2680.8855,-2927.0515,-3162.8872};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_80()
		{
			double[] value = {-3166.0574,-3061.6763,-3124.6807,-3793.9165,-3087.3218,-3131.4255,-3075.5793,-3090.7358,-3121.1802,-3064.9688,-3130.8328,-3210.801,-3238.934,-3278.2776,-3406.0486,-3506.1453,-3558.424,-3587.0933,-3607.432,-3627.5054,-3601.0269,-3580.8271,-3582.9778,-3607.7192,-3697.4875,-3794.677,-3829.3523,-3820.566,-3818.6248,-3818.4478,-3907.653,-3997.6028,-4056.7979,-4091.006,-4200.9473,-4231.405,-4064.2737,-4014.9714,-3997.566,-4015.6094,-3988.1084,-4005.4434,-3962.0068,-3905.5247,-3923.8975,-3901.4314,-3820.0732,-3756.4695,-3747.001,-3749.2947,-3567.1548,-3384.2021,-3336.5474,-3234.317,-3113.9602,-3283.6772,-2993.7976,-3058.1196,-3013.7817,-3624.4841,-3619.3745,-3601.648,-3578.9163,-3619.588,-3794.3286,-3722.6926,-3663.957,-3686.6675,-3700.3992,-3477.213,-3084.077,-3008.3093,-3070.7268,-3339.0762,-3623.8486,-3528.5479,-3343.0986,-3120.136,-3247.745,-3414.8198,-3374.956,-3260.761,-3152.9712,-3474.9138,-3485.411,-3408.8167,-3354.6375,-2901.5583,-2276.627,-1645.5812,-1078.4261,-935.14777,-1583.4513,-2699.576,-2330.2058,-2732.3518,-2709.9194,-2574.4817,-1709.7072,-1264.9963};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_81()
		{
			double[] value = {-948.90094,-947.0554,-799.24854,-1527.6572,-2268.9666,-2629.4478,-2929.3792,-2776.767,-2399.4856,-2129.1238,-2148.448,-2353.571,-2407.3167,-2424.9585,-2566.3752,-2643.7815,-2670.3765,-2727.6082,-2664.2637,-2690.12,-2645.4165,-2738.7498,-2791.8113,-2827.7449,-2810.3767,-2896.449,-2962.9807,-3082.86,-3126.1226,-3119.1428,-3178.075,-3162.7126,-3168.3628,-3198.984,-3117.032,-3205.388,-3243.3953,-3208.8875,-3271.0845,-3334.3892,-3349.9856,-3373.6553,-3490.2097,-3523.004,-3511.66,-3566.043,-3611.7344,-3629.0396,-3591.3843,-3619.685,-3646.2324,-3665.7021,-3716.3625,-3798.1917,-3857.9626,-3853.8096,-3853.589,-3827.5417,-3925.5466,-4003.1216,-4077.1216,-4125.3906,-4208.8613,-4265.0396,-4059.5486,-4051.3992,-4150.8438,-4207.501,-4169.014,-4067.2932,-4099.992,-4004.848,-3923.852,-3864.7612,-3874.4097,-3833.1826,-3798.3882,-3685.4094,-3629.168,-3601.465,-3511.1255,-3354.0103,-3219.048,-3404.1555,-3143.812,-3138.6843,-3120.3877,-3707.1892,-3710.7314,-3647.197,-3699.166,-3707.7734,-3706.9075,-3667.9443,-2969.5408,-3190.659,-3618.5059,-3561.8643,-3289.3096,-3076.8103};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_82()
		{
			double[] value = {-3341.1072,-3515.0796,-3616.7874,-3418.9338,-3172.8064,-3413.6106,-3386.7366,-3540.707,-3569.8713,-3459.5647,-3467.968,-3530.4055,-3516.832,-3466.8198,-3450.0027,-3461.9468,-3363.981,-2749.5615,-1360.6663,-870.9657,-1213.2233,-2659.0347,-2443.3242,-2847.595,-2803.5132,-2799.504,-2703.3604,-2379.5037,-1364.2986,-907.4478,-895.3249,-1591.3047,-2577.3254,-2705.3848,-2970.3335,-2793.7961,-2357.8645,-2141.5315,-2265.2905,-2232.4976,-2427.9985,-2376.9014,-2655.8623,-2707.8943,-2660.0112,-2745.6416,-2872.882,-2849.6323,-2778.6777,-2860.4546,-2760.1267,-2935.2324,-2942.6445,-3012.3877,-2912.249,-2997.0723,-3130.7896,-3247.4417,-3294.383,-3290.5808,-3301.6472,-3210.962,-3172.6816,-3351.4573,-3399.1692,-3384.1194,-3407.0498,-3437.2617,-3409.6604,-3389.8623,-3512.0574,-3557.5247,-3538.4287,-3574.6274,-3601.804,-3615.4321,-3610.9553,-3690.4495,-3738.346,-3763.7268,-3742.9277,-3768.476,-3843.7876,-3871.4133,-3895.7085,-3871.1616,-3936.1313,-4021.5996,-4117.6123,-4162.3447,-4248.049,-4251.837,-4113.2373,-4127.7725,-4180.8228,-4236.3584,-4206.0015,-4129.2007,-4095.1748,-4030.799};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_83()
		{
			double[] value = {-4015.613,-3995.4739,-3935.0579,-3938.5366,-3896.2285,-3884.3135,-3881.7598,-3853.3733,-3844.77,-3649.5776,-3420.2178,-3379.3425,-3461.6838,-3406.6506,-3481.2854,-3502.5947,-3622.3008,-3720.0696,-3627.0256,-3566.9902,-3691.7222,-3451.4397,-2985.5588,-3184.5403,-3080.8877,-2886.2156,-2958.2627,-2760.9924,-3152.5498,-3119.4534,-3369.7966,-3132.6118,-3104.6895,-2856.92,-3127.24,-3360.7117,-3453.3906,-3499.5137,-3527.4702,-3495.3577,-3505.7717,-3517.7231,-3466.3052,-3451.3804,-3239.569,-2448.8801,-2116.9202,-2020.8792,-1412.3505,-889.37915,-1928.2297,-2783.2297,-2569.3975,-2523.2942,-2572.4963,-2502.9492,-1997.266,-2417.062,-2318.0125,-2673.0293,-2843.04,-2753.1646,-2837.4983,-2703.5657,-2589.856,-2556.0525,-2261.92,-2170.8145,-2532.7183,-2604.526,-2814.7292,-2840.328,-2727.071,-2731.9038,-2893.0325,-2881.0635,-2893.51,-2888.136,-2922.575,-3017.9092,-3099.7456,-3069.573,-3090.087,-3180.7625,-3238.614,-3337.105,-3394.2495,-3373.66,-3336.365,-3339.8945,-3340.5647,-3470.4524,-3429.6777,-3441.5674,-3454.3384,-3463.091,-3489.4668,-3495.9014,-3517.7144,-3588.0342};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_84()
		{
			double[] value = {-3601.6882,-3637.3447,-3662.179,-3675.8013,-3691.239,-3730.516,-3736.144,-3726.3838,-3761.3215,-3770.943,-3831.5886,-3900.7673,-3941.75,-3955.845,-3978.9573,-4068.2354,-4155.3657,-4204.3257,-4288.285,-4336.676,-4709.1387,-4223.1396,-4221.892,-4255.886,-4214.2603,-4181.585,-4177.9126,-4162.547,-4123.5405,-4092.6643,-4071.0657,-3983.4185,-3928.233,-3999.2383,-3974.7566,-3945.1104,-3871.4255,-3858.2637,-3724.5789,-3679.0432,-3691.9026,-3627.0596,-3708.9343,-3663.6501,-3731.409,-3834.3767,-3525.6042,-3599.6277,-3796.3794,-3717.9688,-3474.267,-3116.261,-3152.9507,-3099.4028,-3279.1787,-3191.0027,-3295.8584,-3413.659,-3544.684,-3019.1743,-2637.8232,-2958.2305,-3127.9836,-3165.7903,-3500.101,-3488.664,-3531.2966,-3325.9707,-3555.8062,-3577.0945,-3507.6934,-3433.0583,-3236.0847,-2241.0164,-2132.4385,-2308.1516,-1530.9514,-1753.3329,-2492.4873,-2775.8167,-2855.0264,-2823.0222,-2862.88,-2896.6467,-2589.9375,-2782.6807,-2610.4246,-2406.8489,-2801.9321,-2745.1228,-2415.0955,-2415.0432,-2368.0398,-2582.7026,-2183.538,-1840.027,-2486.7134,-2773.6357,-2822.6362,-2843.2048};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_85()
		{
			double[] value = {-2804.6838,-2823.8113,-2969.1963,-2979.433,-3050.7327,-3087.1287,-3055.2642,-3139.45,-3097.7551,-3071.7993,-3195.9146,-3293.1643,-3336.9922,-3397.8835,-3372.377,-3336.6995,-3409.5432,-3458.2378,-3451.325,-3449.498,-3440.9443,-3474.4343,-3488.451,-3516.22,-3549.4016,-3549.0518,-3559.709,-3603.4924,-3622.8503,-3671.7922,-3695.6155,-3720.2168,-3741.66,-3761.0654,-3779.252,-3784.615,-3834.7195,-3881.2576,-3878.9587,-3941.3652,-4011.15,-4007.7058,-4060.668,-4129.327,-4209.3125,-4259.2144,-4337.097,-4386.0425,-4433.5654,-4262.697,-4283.0083,-4249.4014,-4247.706,-4241.417,-4205.294,-4204.7915,-4188.7705,-4158.2705,-4155.0103,-4087.1553,-4008.0,-3958.9312,-3987.1497,-4024.0222,-4002.4485,-3894.4397,-3835.5393,-3792.7925,-3875.031,-3862.3818,-3777.7573,-3859.4692,-3817.7693,-3806.2595,-3715.8418,-3609.4736,-3698.309,-3630.6255,-3669.7646,-3511.053,-3775.9143,-3495.3438,-3665.866,-3468.5286,-3599.5115,-3572.4146,-3505.2986,-3090.0554,-2787.268,-3290.566,-3462.6357,-3547.729,-3537.0623,-3582.8093,-3542.679,-3534.725,-3333.5044,-3521.0317,-3528.9998,-3516.544};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_86()
		{
			double[] value = {-3404.5874,-3289.1633,-3022.973,-2766.1194,-2949.6836,-2809.6692,-2605.039,-2907.3635,-2960.3352,-2996.935,-2991.828,-2900.53,-2754.2925,-2652.6968,-2919.153,-2937.8987,-3086.047,-2702.5295,-2371.5168,-2352.3342,-2297.088,-2659.8865,-2553.5383,-2211.1865,-2533.399,-2930.6226,-2965.2146,-2836.2595,-2916.9722,-3007.9158,-3067.2341,-3053.9336,-3137.5786,-3139.7192,-3160.6985,-3173.6687,-3184.878,-3280.7556,-3328.121,-3366.8735,-3424.1062,-3462.653,-3390.8875,-3396.6147,-3484.434,-3496.359,-3518.8281,-3477.4395,-3502.1313,-3535.651,-3547.8481,-3540.6995,-3543.43,-3541.6313,-3535.472,-3578.6335,-3618.7632,-3666.067,-3723.6636,-3744.0132,-3760.5916,-3789.799,-3833.192,-3851.962,-3873.166,-3901.7095,-3940.3357,-3977.9802,-3994.4463,-4018.036,-4084.8042,-4163.829,-4260.3413,-4358.7407,-4412.899,-4455.947,-4331.6304,-4293.3965,-4319.2954,-4336.4917,-4269.3696,-4243.072,-4179.2925,-4211.043,-4233.677,-4208.8584,-4160.8906,-4055.6438,-4017.064,-4007.5193,-4060.613,-4063.6533,-3967.424,-3947.7878,-3929.9812,-3874.718,-3881.141,-3843.5771,-3886.333,-3826.4392};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_87()
		{
			double[] value = {-3797.322,-3814.3037,-3822.59,-3749.4934,-3804.6829,-3742.086,-3781.5308,-3804.204,-3732.3428,-3776.5447,-3743.7014,-3778.0388,-3718.9502,-3643.8103,-3486.4382,-3226.3357,-3340.911,-3276.7043,-3244.1204,-3517.109,-3458.8928,-3561.87,-3359.8076,-3257.823,-3098.9202,-3417.38,-3458.4197,-3483.473,-3477.516,-3392.4688,-3177.6707,-3142.67,-3231.4377,-2974.8425,-2840.7976,-3077.092,-2988.8823,-2955.0059,-3037.7957,-3063.2441,-2850.817,-3116.6394,-3178.3628,-3152.0781,-3145.8628,-3160.8142,-2996.453,-2724.969,-2560.5598,-2627.3945,-2878.6116,-2845.0764,-2928.584,-2941.2903,-2966.091,-3021.742,-3024.0198,-3114.4805,-3127.609,-3172.5793,-3205.4424,-3175.2861,-3222.5427,-3239.0754,-3254.0847,-3297.4712,-3396.6826,-3434.3484,-3465.4395,-3496.8394,-3422.835,-3429.2158,-3491.8967,-3513.9993,-3510.2014,-3502.8108,-3557.6404,-3562.893,-3572.1006,-3578.3079,-3553.2393,-3527.2937,-3587.592,-3645.509,-3673.1074,-3691.5842,-3702.4639,-3720.22,-3748.6162,-3796.6804,-3847.4744,-3889.725,-3888.969,-3925.078,-3961.1697,-4006.712,-4031.3025,-4075.9834,-4120.5845,-4163.702};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_88()
		{
			double[] value = {-4344.7993,-4514.932,-4557.222,-4569.123,-4370.5615,-4377.7476,-4400.636,-4363.1494,-4261.816,-4257.114,-4256.052,-4278.2446,-4257.95,-4193.4346,-4131.8022,-4071.876,-4108.3086,-4126.311,-4125.418,-4099.4985,-4072.5796,-4059.4126,-4047.7441,-4028.103,-3998.4753,-3929.614,-3926.226,-3857.275,-3833.9478,-3806.89,-3841.382,-3848.9229,-3825.374,-3858.7192,-3804.8198,-3850.4304,-3825.2432,-3800.716,-3836.7605,-3807.1348,-3771.7444,-3687.282,-3535.1616,-3579.9707,-3471.469,-3449.8213,-3431.9707,-3499.7273,-3482.4248,-3612.313,-3543.0388,-3538.1294,-3462.9978,-3539.826,-3454.2827,-3483.2275,-3490.8508,-3428.6582,-3335.6753,-3338.0776,-3281.6748,-3136.2886,-3149.9976,-3116.009,-2871.9692,-2924.1426,-3080.0667,-3106.5981,-3272.2212,-3282.6045,-3328.1868,-3221.4177,-3242.4363,-3184.3218,-3021.5999,-2991.5432,-2862.6814,-2909.0527,-2848.3618,-2884.8457,-2916.2683,-2968.85,-3171.2747,-3254.131,-3249.8445,-3231.7383,-3242.7058,-3257.9517,-3239.9492,-3226.0688,-3287.7925,-3310.7021,-3245.9534,-3325.767,-3469.666,-3482.429,-3455.1494,-3476.4138,-3488.722,-3407.7424};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_89()
		{
			double[] value = {-3433.0007,-3494.6628,-3536.7737,-3541.0696,-3597.642,-3607.3955,-3620.7307,-3619.342,-3587.373,-3533.167,-3634.4368,-3685.872,-3713.1147,-3727.7026,-3737.8416,-3740.7341,-3762.0469,-3783.491,-3803.73,-3834.8425,-3870.7612,-3922.9106,-3937.222,-4032.2612,-4087.1921,-4148.7896,-4182.276,-4243.8516,-4424.111,-4514.4624,-4547.2827,-4573.8613,-4468.0225,-4467.2773,-4444.7974,-4393.9473,-4342.7075,-4283.2964,-4290.3413,-4278.0522,-4231.8623,-4181.581,-4172.599,-4176.782,-4132.9907,-4119.7266,-4132.6265,-4095.9119,-4066.652,-4067.5056,-4029.3254,-4003.3845,-4016.416,-3961.717,-3955.1335,-3918.9485,-3918.5276,-3943.4592,-3924.3696,-3920.0205,-3926.6982,-3888.7305,-3816.152,-3853.9973,-3862.677,-3858.3552,-3877.0344,-3816.3599,-3763.629,-3720.2832,-3509.9417,-3766.8232,-4218.4814,-4083.0383,-3874.7996,-3407.5586,-3404.5142,-3484.4358,-3542.0415,-3536.1746,-3600.783,-3607.9397,-3593.606,-3545.9353,-3487.99,-3400.715,-3264.1936,-3241.4714,-3237.5933,-3176.8027,-3223.45,-3192.2158,-3212.8032,-3196.0747,-3113.685,-3099.168,-3183.7007,-3327.0142,-3280.7256,-3204.0474};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_90()
		{
			double[] value = {-3188.4717,-3229.8035,-3202.6235,-3279.8296,-3138.041,-3062.0686,-3132.8877,-3121.6252,-3154.3953,-3200.9224,-3260.9988,-3292.6375,-3353.7954,-3359.1587,-3292.3674,-3325.7295,-3345.073,-3330.2087,-3327.467,-3328.3032,-3268.8477,-3429.0437,-3498.0986,-3503.7249,-3518.3064,-3510.6147,-3486.8413,-3492.5535,-3458.6853,-3490.5024,-3530.5854,-3553.4158,-3591.9663,-3603.8176,-3607.1091,-3585.3115,-3572.9324,-3587.892,-3626.8147,-3672.093,-3693.7512,-3703.087,-3713.8594,-3755.348,-3802.699,-3840.8406,-3878.8335,-3890.6367,-3936.8547,-4002.2107,-4022.249,-4060.3494,-4099.566,-4158.082,-4198.9697,-4246.1616,-4394.498,-4488.369,-4510.059,-4567.244,-4484.4453,-4474.438,-4445.2046,-4432.8613,-4333.8394,-4275.618,-4335.996,-4249.8335,-4244.304,-4244.3154,-4182.9087,-4163.821,-4134.0107,-4128.9517,-4106.8306,-4130.1035,-4087.4463,-4083.7803,-4065.6348,-4046.7498,-3977.3494,-4013.8728,-3982.496,-3986.1897,-4033.5925,-4017.1516,-3950.1787,-3933.6418,-3905.4375,-3901.4133,-3866.7366,-3835.7432,-3878.8809,-3846.7485,-3732.7383,-3657.4167,-3626.2097,-3584.9407,-4038.1226,-5205.3755};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_91()
		{
			double[] value = {-5538.673,-5197.697,-4988.6636,-4868.4,-3911.4128,-3087.266,-3335.4475,-3461.4512,-3577.3662,-3611.4526,-3628.745,-3546.5725,-3549.192,-3475.0786,-3323.531,-3286.478,-3181.8748,-3116.6992,-3219.6946,-3238.1775,-3273.866,-3260.8113,-3295.847,-3270.9773,-3349.0586,-3344.4624,-3304.4272,-3239.263,-3087.751,-3212.4705,-3326.9053,-3378.9253,-3121.2498,-3209.4065,-3236.111,-3270.176,-3375.737,-3356.405,-3342.802,-3383.6667,-3403.093,-3395.5732,-3389.9155,-3368.495,-3325.2544,-3334.0728,-3350.5088,-3379.4048,-3366.157,-3451.1206,-3518.0496,-3526.9612,-3526.4937,-3531.097,-3533.5142,-3517.9514,-3536.062,-3549.417,-3577.2158,-3609.4268,-3615.8801,-3620.1787,-3612.4714,-3575.5288,-3573.8047,-3645.7285,-3661.538,-3670.4512,-3685.0925,-3718.9644,-3729.33,-3754.9058,-3803.8135,-3843.4077,-3899.8591,-3919.3687,-3950.467,-3997.7922,-4026.7122,-4064.652,-4134.04,-4170.81,-4206.3125,-4242.867,-4315.115,-4415.907,-4474.246,-4488.272,-4520.133,-4512.23,-4488.463,-4472.0566,-4415.143,-4319.921,-4285.6606,-4331.3003,-4291.052,-4279.492,-4230.0938,-4177.964};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_92()
		{
			double[] value = {-4161.193,-4154.285,-4148.8887,-4116.7837,-4081.6577,-4102.6533,-4102.0327,-4064.575,-4094.9502,-4090.1287,-4011.2876,-4049.7622,-3963.649,-3960.4016,-3956.9592,-3946.7107,-3996.082,-3948.5251,-3947.972,-3940.3909,-3931.3425,-3815.8887,-3776.9163,-3668.1145,-3585.704,-3663.7612,-5249.1826,-5715.074,-5719.905,-5618.0024,-4860.867,-4322.18,-4238.53,-3061.2427,-3135.9072,-3440.7205,-3574.3936,-3613.6216,-3575.144,-3596.8044,-3611.948,-3514.603,-3393.2742,-3267.8225,-3312.0164,-3364.2473,-3275.2124,-3311.3367,-3288.2466,-3222.0588,-3377.1785,-3354.0635,-3396.1597,-3292.9736,-3378.5642,-3285.812,-3304.1477,-3455.3237,-3486.407,-3423.3755,-3371.1018,-3278.8823,-3330.8967,-3404.2341,-3461.6284,-3462.4138,-3467.9082,-3451.7205,-3462.1086,-3457.0493,-3466.5933,-3449.8892,-3399.446,-3366.7354,-3378.3052,-3447.6816,-3490.6108,-3516.739,-3516.4524,-3517.8252,-3518.7705,-3533.8645,-3562.1282,-3557.802,-3534.559,-3564.5903,-3612.4705,-3644.7588,-3657.759,-3659.7456,-3642.9907,-3605.1345,-3589.7278,-3633.3787,-3661.0486,-3671.3164,-3673.9597,-3714.1616,-3733.4912,-3765.711};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_93()
		{
			double[] value = {-3789.775,-3833.8662,-3897.867,-3935.5361,-3947.0276,-3930.5654,-4022.4487,-4101.2837,-4161.101,-4168.787,-4202.552,-4267.82,-4341.5044,-4371.7793,-4374.9395,-4375.0254,-4543.9736,-4520.951,-4510.1675,-4493.252,-4456.1367,-4416.5444,-4383.248,-4370.686,-4349.1865,-4309.5425,-4272.4663,-4264.6113,-4224.038,-4212.3906,-4180.652,-4170.2783,-4158.233,-4128.025,-4123.287,-4120.2583,-4121.6846,-4030.3062,-4100.864,-4510.883,-3985.2588,-3947.8203,-3993.888,-4022.483,-4041.178,-4006.3665,-3978.308,-3991.34,-3961.2527,-3955.922,-3851.1794,-3730.6868,-3582.8152,-3728.1694,-5343.381,-4642.4805,-5031.998,-6184.699,-5382.169,-4136.727,-3876.6611,-2943.5588,-3004.0693,-3268.5044,-3472.2014,-3509.084,-3642.2107,-3694.0955,-3628.804,-3535.7107,-3414.8728,-3369.4885,-3452.6753,-3478.0037,-3393.2214,-3349.8745,-3361.8633,-3366.2048,-3361.277,-3428.8699,-3466.502,-3501.2688,-3495.164,-3496.8687,-3489.6118,-3549.5312,-3491.2698,-3429.2488,-3425.2998,-3389.7346,-3427.549,-3458.8545,-3457.7744,-3448.9119,-3473.539,-3470.4585,-3488.76,-3495.1196,-3495.059,-3505.424};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_94()
		{
			double[] value = {-3482.6123,-3503.3855,-3507.295,-3522.5217,-3516.27,-3543.2703,-3530.4468,-3536.6594,-3553.2869,-3555.3103,-3562.3083,-3536.3098,-3562.8591,-3563.463,-3587.8555,-3633.1082,-3628.3518,-3648.3748,-3647.877,-3580.0718,-3602.4758,-3598.6433,-3664.2983,-3695.66,-3707.9448,-3721.3645,-3748.431,-3786.6514,-3829.6624,-3867.3518,-3898.0862,-3903.6885,-3935.257,-3987.6729,-4061.6233,-4068.383,-4118.869,-4171.949,-4245.3486,-4286.5996,-4343.386,-4359.6807,-4363.6934,-4319.9844,-4493.342,-4529.1865,-4522.768,-4492.549,-4428.0664,-4437.469,-4424.6816,-4393.155,-4355.3623,-4300.211,-4314.8804,-4285.501,-4266.0703,-4245.279,-4211.779,-4194.1455,-4201.1714,-4146.801,-4117.8916,-4123.511,-4073.3484,-4033.1492,-4036.3284,-3990.6875,-3967.3008,-3965.346,-3954.6538,-4030.1895,-4045.0361,-4030.2808,-3992.6274,-3978.4854,-3967.424,-3969.4617,-3838.8894,-3652.1057,-3467.9275,-3404.772,-4450.275,-4809.077,-4937.1353,-4222.2153,-3500.1594,-3798.547,-3456.3313,-3122.0278,-3023.1926,-3186.517,-3525.2192,-3673.5295,-3718.092,-3696.0044,-3621.3767,-3577.0117,-3546.9067,-3526.0806};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_95()
		{
			double[] value = {-3569.9463,-3584.6218,-3516.6807,-3483.9634,-3485.3513,-3472.764,-3424.055,-3429.9216,-3404.7793,-3514.5732,-3491.1506,-3469.924,-3511.0444,-3573.1116,-3528.174,-3497.5688,-3484.5388,-3437.9312,-3445.9739,-3479.3801,-3418.4705,-3407.5945,-3498.5544,-3498.1975,-3536.8225,-3584.3677,-3603.9263,-3632.681,-3565.912,-3558.642,-3545.951,-3580.4497,-3589.1514,-3578.6997,-3496.2937,-3490.5815,-3508.5615,-3548.0012,-3549.2483,-3562.7893,-3569.4807,-3581.92,-3573.837,-3575.0488,-3622.1914,-3641.5083,-3623.3472,-3558.2788,-3562.8196,-3563.4707,-3688.823,-3718.226,-3728.63,-3738.586,-3768.387,-3777.062,-3790.5154,-3826.006,-3865.7136,-3908.495,-3979.0935,-4025.6555,-4017.2769,-4072.1934,-4159.698,-4209.0127,-4245.137,-4282.326,-4299.5396,-4353.5522,-4362.12,-4306.015,-4534.255,-4525.384,-4515.0615,-4498.776,-4452.8276,-4468.0728,-4439.225,-4434.6753,-4405.542,-4376.269,-4352.1147,-4333.0493,-4313.1562,-4296.846,-4276.0884,-4210.412,-4183.7764,-4159.8306,-4150.841,-4185.2505,-4157.0356,-4128.029,-4081.1,-4038.5627,-4063.7788,-4051.117,-4050.3481,-4097.241};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_96()
		{
			double[] value = {-4095.5457,-4030.6384,-3968.5098,-3949.95,-3977.5947,-3957.3328,-3902.861,-3846.3533,-3701.7393,-3560.95,-3478.3594,-3415.717,-3436.1504,-3304.693,-3026.5947,-3234.2554,-3206.7573,-3484.3457,-3416.476,-3437.3962,-3476.5903,-3606.0762,-3743.364,-3725.8105,-3660.6753,-3623.2744,-3578.8218,-3529.0793,-3577.647,-3544.7874,-3562.9558,-3588.516,-3595.9905,-3599.2722,-3546.4968,-3497.0093,-3524.442,-3520.1785,-3511.9617,-3557.9019,-3587.447,-3591.6357,-3600.1199,-3575.2437,-3551.46,-3554.6677,-3569.102,-3558.7659,-3559.4458,-3584.4004,-3586.6497,-3566.212,-3596.2065,-3625.841,-3620.299,-3617.464,-3631.4417,-3609.6426,-3621.3635,-3619.848,-3622.4956,-3594.458,-3536.6865,-3527.2534,-3541.4634,-3546.8953,-3567.9773,-3582.9265,-3613.0344,-3616.7856,-3626.4482,-3628.936,-3636.2354,-3631.7512,-3626.1948,-3599.7422,-3560.79,-3570.0845,-3677.7754,-3738.8276,-3759.674,-3768.1497,-3785.549,-3808.6277,-3838.8843,-3873.9563,-3879.1904,-3904.3892,-3951.899,-3976.8843,-4027.894,-4084.0198,-4144.27,-4195.6616,-4231.313,-4262.485,-4287.86,-4313.8643,-4275.9053,-4296.496};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_97()
		{
			double[] value = {-4570.5493,-4569.502,-4553.071,-4513.7827,-4504.302,-4484.6255,-4458.145,-4447.9507,-4399.4966,-4382.5913,-4381.935,-4373.1777,-4321.219,-4305.853,-4300.585,-4238.267,-4260.7515,-4306.823,-4247.413,-4248.859,-4192.3965,-4257.367,-4173.006,-4128.3394,-4167.815,-4159.6304,-4136.784,-4125.1597,-4126.9897,-4055.9016,-4003.6323,-3980.5508,-3990.646,-4014.3972,-3975.0793,-3893.5376,-3825.8408,-3778.2854,-3701.791,-3687.0693,-3475.0933,-3371.1372,-3201.4153,-3387.6797,-3541.1995,-3534.1658,-3535.2158,-3552.3716,-3642.5266,-3724.8809,-3753.628,-3718.502,-3690.9607,-3659.2322,-3636.8005,-3646.2825,-3612.8655,-3579.535,-3629.9785,-3649.9565,-3622.634,-3648.55,-3592.2979,-3585.0662,-3534.7983,-3569.2249,-3605.4966,-3622.9153,-3633.076,-3617.5781,-3592.8293,-3576.325,-3578.9365,-3622.9382,-3606.1995,-3638.2698,-3680.0925,-3696.4863,-3686.7505,-3662.864,-3649.0188,-3732.941,-3870.7466,-3654.593,-3687.8027,-3639.3037,-3639.7908,-3649.1936,-3630.8572,-3607.9768,-3569.0288,-3548.8071,-3548.9705,-3564.1238,-3592.5505,-3602.2766,-3609.3513,-3623.0276,-3625.4343,-3631.2014};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_98()
		{
			double[] value = {-3630.3591,-3611.6116,-3620.6973,-3596.2266,-3594.4917,-3614.8713,-3645.9333,-3663.8186,-3716.5657,-3728.381,-3767.7275,-3797.7764,-3797.989,-3852.8547,-3877.3933,-3926.0886,-3976.9924,-4021.5356,-4065.1843,-4104.21,-4133.6353,-4161.496,-4214.1113,-4241.0913,-4248.13,-4210.301,-4224.2456,-4276.828,-4581.823,-4573.026,-4581.4136,-4534.3394,-4534.5063,-4508.4316,-4491.446,-4456.4614,-4455.316,-4424.789,-4405.9077,-4384.0435,-4348.4165,-4291.8213,-4258.627,-4254.69,-4263.666,-4306.4805,-4288.155,-4271.7686,-4234.059,-4198.7183,-4195.819,-4183.464,-4201.038,-4176.283,-4169.3887,-4153.336,-4115.3564,-4033.3176,-4007.0537,-4015.3108,-4013.1477,-4014.3083,-4010.494,-3957.4092,-3948.6716,-3901.2703,-3871.8816,-3862.0508,-3776.783,-3683.5305,-3580.9812,-3675.7463,-3698.338,-3719.582,-3637.334,-3625.1138,-3675.4307,-3785.3481,-3826.0261,-3786.7898,-3719.079,-3721.359,-3733.817,-3740.275,-3700.1958,-3685.5288,-3665.8528,-3638.6445,-3662.8223,-3678.2742,-3677.418,-3669.9548,-3627.7969,-3642.1746,-3663.7585,-3672.9272,-3670.9863,-3656.0886,-3599.4524,-3603.957};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_99()
		{
			double[] value = {-3668.4927,-3654.476,-3665.0044,-3716.9314,-3750.88,-3749.856,-3752.8796,-3707.4475,-3684.0789,-3714.264,-3823.357,-3700.5186,-3726.617,-3680.7866,-3658.8987,-3675.2646,-3645.1633,-3628.231,-3618.5806,-3562.0073,-3574.306,-3598.8608,-3619.2378,-3628.1628,-3622.236,-3638.0078,-3634.397,-3621.2944,-3585.9248,-3582.7544,-3579.692,-3582.209,-3654.1946,-3710.863,-3742.4233,-3718.0378,-3726.2148,-3740.378,-3745.2812,-3784.813,-3841.3555,-3859.7441,-3908.182,-3952.3281,-3985.6497,-4031.762,-4084.9844,-4114.746,-4131.6924,-4151.6636,-4188.1724,-4161.6,-4152.9116,-4184.988,-4224.0615,-4276.803,-4642.1206,-4632.425,-4593.272,-4551.41,-4565.826,-4545.295,-4531.4023,-4526.5127,-4493.309,-4468.153,-4434.8774,-4387.1167,-4383.655,-4351.363,-4307.4785,-4337.113,-4333.3735,-4301.5522,-4289.6553,-4266.2256,-4243.0244,-4254.636,-4232.6953,-4202.7236,-4195.85,-4215.3853,-4176.4,-4140.296,-4107.0127,-4075.612,-4055.552,-4042.271,-4033.5518,-4022.7036,-4005.7275,-3975.0833,-3916.5828,-3904.9695,-3944.9001,-3929.503,-3906.573,-3910.4705,-3844.4956,-3865.2515};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_100()
		{
			double[] value = {-3869.209,-3891.4402,-3859.5676,-3788.1638,-3815.1558,-3824.2742,-3858.4517,-3814.0464,-3745.3738,-3749.129,-3763.2815,-3771.3137,-3725.5232,-3713.6348,-3769.2925,-3683.4019,-3702.7412,-3728.7405,-3745.817,-3761.5066,-3743.4495,-3739.1384,-3702.8572,-3696.641,-3707.2046,-3689.3655,-3670.2175,-3693.4802,-3761.648,-3753.643,-3749.5237,-3787.2454,-3783.0566,-3788.0054,-3801.5522,-3771.2095,-3745.2568,-3739.9263,-3734.8044,-3750.8645,-3751.605,-3715.8174,-3666.0046,-3683.2646,-3671.0664,-3649.087,-3632.8381,-3609.9993,-3618.4746,-3609.341,-3607.8384,-3602.3154,-3610.5474,-3602.2227,-3607.7197,-3580.9233,-3578.6946,-3586.0344,-3580.8462,-3585.3113,-3664.2158,-3698.2307,-3727.3594,-3738.305,-3759.5303,-3778.1328,-3771.689,-3812.2937,-3844.7874,-3870.587,-3941.2979,-3967.9111,-4009.7832,-4050.5813,-4073.2734,-4097.845,-4104.0977,-4112.6025,-4077.6577,-4105.428,-4141.942,-4174.249,-4224.3813,-4270.5923,-4664.435,-4653.7935,-4617.211,-4598.773,-4603.0474,-4568.7363,-4565.817,-4542.2627,-4522.146,-4508.893,-4464.5215,-4404.375,-4350.111,-4326.6953,-4361.595,-4339.1797};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_101()
		{
			double[] value = {-4314.6523,-4306.9014,-4309.2246,-4308.703,-4300.5024,-4277.438,-4243.7637,-4176.934,-4233.9478,-4201.252,-4155.9478,-4178.4395,-4158.3286,-4147.059,-4130.65,-4112.5767,-4101.1826,-4042.4043,-4017.1836,-4008.6838,-3947.9211,-3942.5962,-3937.7373,-3947.697,-3971.2085,-3953.9993,-3864.0476,-3865.2588,-3900.9536,-3905.1094,-3859.9436,-3798.7866,-3835.9487,-3852.6782,-3814.9424,-3812.123,-3830.0461,-3790.692,-3776.7236,-3784.0208,-3789.726,-3789.3665,-3780.5176,-3766.24,-3745.4646,-3735.5205,-3739.3252,-3771.2192,-3742.384,-3762.9595,-3764.9578,-3726.86,-3714.657,-3722.4072,-3752.3792,-3786.2585,-3793.5256,-3800.1858,-3828.4163,-3855.6167,-3844.8364,-3822.5933,-3835.122,-3833.748,-3817.0024,-3837.8738,-3813.8613,-3815.053,-3766.4014,-3737.4053,-3702.4448,-3700.464,-3690.3762,-3665.098,-3635.3074,-3647.9326,-3632.0535,-3620.2722,-3619.3228,-3615.7354,-3616.3354,-3587.3818,-3577.3633,-3587.0337,-3568.603,-3604.8745,-3618.6973,-3662.5432,-3731.199,-3720.8066,-3758.947,-3765.2341,-3767.4583,-3755.314,-3710.4644,-3765.243,-3838.238,-3880.4014,-3911.9272,-3940.8545};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_102()
		{
			double[] value = {-4009.6794,-4031.4404,-4037.5098,-4062.0254,-4090.9277,-4082.2422,-4060.453,-4114.4517,-4139.1016,-4157.063,-4212.6978,-4254.9565,-4654.4746,-4652.3975,-4638.4556,-4627.8433,-4622.585,-4564.7505,-4547.8076,-4552.6567,-4542.453,-4472.7188,-4457.3257,-4441.246,-4418.7344,-4390.1553,-4373.553,-4361.134,-4358.1084,-4363.0674,-4366.3022,-4350.1514,-4329.807,-4299.7563,-4270.763,-4283.017,-4285.8926,-4242.8306,-4227.694,-4219.334,-4173.34,-4163.053,-4148.5093,-4129.574,-4098.5117,-4073.974,-4073.9126,-4028.3826,-3993.274,-3996.2612,-3966.001,-3952.247,-3918.5234,-3918.0461,-3895.6714,-3857.5305,-3846.5166,-3833.0305,-3820.5935,-3814.3357,-3822.7114,-3807.0015,-3810.2478,-3830.9958,-3857.565,-3844.7454,-3854.515,-3844.3738,-3807.02,-3834.7173,-3831.0315,-3814.7168,-3834.8323,-3824.5503,-3805.8591,-3791.3938,-3796.3647,-3818.2366,-3827.334,-3801.2124,-3777.3413,-3782.1638,-3794.056,-3816.5095,-3845.161,-3851.6628,-3912.345,-3897.9622,-3887.9763,-3884.6636,-3852.5388,-3835.9414,-3856.919,-3864.703,-3848.0022,-3811.5237,-3788.0198,-3776.3127,-3748.7034,-3766.847};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_103()
		{
			double[] value = {-3766.187,-3738.4917,-3703.3992,-3665.9927,-3655.4329,-3628.8335,-3635.4858,-3632.3086,-3612.364,-3575.0972,-3589.6106,-3611.704,-3636.0579,-3655.4192,-3648.451,-3675.4292,-3684.5745,-3722.779,-3752.9458,-3764.9663,-3774.7583,-3782.5898,-3781.727,-3763.927,-3795.5125,-3861.5635,-3905.1477,-3935.9243,-3982.1482,-4019.946,-4042.021,-4061.1047,-4051.599,-4017.702,-4046.786,-4078.0083,-4118.0,-4134.976,-4200.951,-4240.686,-4670.4717,-4692.45,-4678.696,-4640.396,-4587.2983,-4584.2627,-4591.7393,-4572.9663,-4537.724,-4505.846,-4485.4707,-4496.805,-4481.6177,-4458.387,-4385.1895,-4399.5444,-4401.5625,-4410.4644,-4396.498,-4356.9487,-4320.0195,-4341.3853,-4384.66,-4335.6562,-4307.2485,-4282.075,-4269.957,-4235.2603,-4146.085,-4178.863,-4159.1816,-4122.175,-4088.4116,-4110.325,-4097.5703,-4045.3403,-4022.787,-4008.4746,-3974.8518,-3934.3213,-3916.0872,-3934.1855,-3919.6409,-3904.843,-3862.1685,-3821.8213,-3841.7827,-3855.796,-3840.067,-3811.977,-3826.1353,-3863.1052,-3901.356,-3916.1433,-3902.2495,-3900.2585,-3883.7256,-3887.2036,-3873.3105,-3858.94};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_104()
		{
			double[] value = {-3856.7437,-3863.7932,-3892.219,-3867.3296,-3856.3884,-3893.728,-3907.806,-3929.4832,-3902.4941,-3896.0735,-3883.7795,-3860.574,-3893.7827,-3907.0198,-3948.9976,-3949.3088,-3935.3232,-3933.7832,-3897.9375,-3883.9695,-3884.276,-3902.2014,-3827.0022,-3782.3284,-3732.2378,-3745.2737,-3788.1099,-3801.2961,-3790.871,-3767.1394,-3752.8362,-3744.0056,-3726.7397,-3681.954,-3708.5215,-3685.9268,-3637.4438,-3621.8635,-3676.4011,-3667.1711,-3668.3333,-3688.2893,-3674.4895,-3695.3438,-3723.9001,-3673.3494,-3717.0999,-3750.198,-3765.2722,-3795.376,-3785.862,-3817.1953,-3806.9653,-3809.5503,-3881.298,-3928.7751,-3968.782,-4002.1472,-4003.6091,-4002.0898,-4003.0422,-4014.4673,-4059.036,-4065.8025,-4091.6233,-4083.2683,-4136.3677,-4196.4287,-4716.7417,-4722.006,-4695.926,-4649.8306,-4621.0513,-4628.519,-4592.919,-4578.5186,-4564.7886,-4564.367,-4543.0903,-4536.3994,-4516.6514,-4518.05,-4460.967,-4431.85,-4432.717,-4439.8774,-4414.386,-4387.37,-4356.839,-4343.261,-4351.2954,-4323.8364,-4307.678,-4275.1826,-4240.909,-4181.367,-4188.26,-4196.638,-4186.9067,-4178.318};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_105()
		{
			double[] value = {-4167.691,-4155.051,-4131.266,-4062.5652,-4026.0903,-4023.6877,-3971.1511,-3961.949,-3946.8953,-3943.7036,-3935.9146,-3920.7183,-3940.5144,-3937.9922,-3934.3774,-3908.829,-3854.6123,-3866.9932,-3885.3508,-3924.323,-3945.251,-3959.945,-3945.294,-3921.21,-3919.8267,-3915.5288,-3882.524,-3907.79,-3911.7964,-3929.0886,-3936.4678,-3960.1672,-3946.559,-3944.2263,-3950.1843,-3967.9255,-3957.7869,-3943.7776,-3967.9646,-3977.2998,-3964.0696,-3983.9143,-3999.5103,-3989.8303,-3979.4316,-3964.8203,-3965.4956,-3963.3474,-3907.6602,-3886.667,-3850.6753,-3812.2063,-3820.204,-3790.6462,-3760.4072,-3754.433,-3775.9385,-3764.6853,-3770.5332,-3748.7856,-3737.5137,-3730.8257,-3714.986,-3687.0361,-3674.7073,-3685.1003,-3730.7017,-3701.0398,-3709.5374,-3709.396,-3706.3042,-3693.3972,-3688.1023,-3695.1387,-3724.6694,-3755.6335,-3775.947,-3800.9414,-3805.5981,-3810.9407,-3847.1702,-3826.2798,-3894.924,-3938.4417,-3935.0188,-3954.6042,-3969.1277,-4006.2422,-4038.4543,-4053.0188,-4064.9817,-4046.7322,-4072.9207,-4082.9844,-4090.2622,-4122.317,-4717.103,-4704.4854,-4672.1646,-4645.6494};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_106()
		{
			double[] value = {-4652.0425,-4638.277,-4636.655,-4618.9175,-4605.832,-4596.085,-4580.2295,-4579.1167,-4557.458,-4551.253,-4498.6577,-4483.1523,-4481.0356,-4456.3066,-4446.0273,-4419.417,-4386.3276,-4377.8896,-4366.409,-4321.235,-4319.4736,-4292.867,-4223.4556,-4212.7227,-4293.552,-4177.991,-4201.523,-4210.222,-4196.4517,-4170.398,-4149.3696,-4106.3896,-4061.3108,-4069.0183,-4045.2002,-4040.5464,-4026.6555,-4015.3137,-4000.285,-3999.3489,-4012.9573,-4000.5896,-3995.9216,-3983.9177,-3919.449,-3921.5627,-3941.547,-3961.5876,-3966.7573,-3961.5835,-3951.9172,-3936.636,-3963.1262,-3952.278,-3920.4243,-3930.231,-4056.9766,-3987.613,-3998.3076,-4015.1772,-4017.6035,-4002.0798,-3985.419,-3977.9226,-4004.7285,-3981.0496,-3982.9456,-4009.7603,-4025.3428,-4040.2915,-4053.813,-4035.6558,-4009.063,-4006.0986,-3986.512,-3944.9685,-3921.125,-3883.3313,-4158.0312,-4432.1724,-3787.096,-3793.069,-3817.1514,-3776.7793,-3811.003,-3799.2852,-3825.4368,-3800.8228,-3777.3271,-3736.6765,-3723.0935,-3712.2751,-3726.3762,-3712.0771,-3716.4636,-3697.6172,-3710.5127,-3712.1235,-3701.8562,-3687.7437};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_107()
		{
			double[] value = {-3683.2483,-3698.0847,-3713.1172,-3757.9907,-3774.0598,-3788.1658,-3780.7512,-3803.9272,-3826.6265,-3833.268,-3890.6536,-3951.2634,-3923.2124,-3956.7837,-3999.9,-4019.3528,-4057.468,-4080.6511,-4088.5198,-4055.9243,-4017.6965,-4046.8027,-4067.0593,-4094.106,-4732.215,-4715.131,-4618.491,-4658.145,-4698.0312,-4666.167,-4640.524,-4633.4155,-4624.097,-4615.297,-4601.61,-4591.369,-4561.6377,-4419.628,-4365.04,-4325.5576,-4397.265,-4461.471,-4480.6655,-4445.5776,-4409.5522,-4394.1147,-4379.852,-4344.855,-4323.579,-4286.987,-4268.941,-4238.8203,-4196.9487,-4210.442,-4222.7695,-4214.769,-4195.452,-4169.041,-4152.2456,-4132.6733,-4086.4143,-4091.9524,-4108.1606,-4113.6465,-4110.709,-4091.5803,-4067.147,-4065.2458,-4058.1755,-4032.2998,-4029.2124,-4020.8503,-4003.2507,-3983.3662,-3960.7678,-3942.657,-3974.1587,-3971.062,-3943.0908,-3949.777,-3996.9954,-4008.4185,-4017.2576,-3993.5203,-3992.8748,-3995.702,-4044.9697,-4056.6953,-4048.8677,-4053.0435,-4032.9617,-3986.2039,-3999.971,-4010.6672,-4015.3638,-4021.4104,-4035.6543,-4041.9924,-4055.214,-4045.6738};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_108()
		{
			double[] value = {-4045.5208,-4038.122,-3995.447,-3942.534,-3938.9639,-3931.302,-3921.3755,-4127.2837,-3671.6187,-3838.3843,-3867.2402,-3767.2046,-3815.9768,-3756.3523,-3806.3599,-3811.4092,-3789.7424,-3756.1,-3733.686,-3677.6855,-3687.4775,-3707.8572,-3739.2778,-3707.8647,-3675.3064,-3707.5664,-3761.189,-3826.9941,-3693.174,-3714.0825,-3772.017,-3742.9324,-3743.6968,-3767.8423,-3786.9226,-3821.588,-3827.581,-3865.8308,-3886.899,-3915.0488,-3894.1892,-3910.3643,-3975.9214,-3997.8367,-4026.471,-4056.9473,-4105.651,-4073.249,-4052.1804,-3989.24,-3989.1504,-4016.8472,-4700.143,-4668.878,-4667.897,-4677.756,-4681.8394,-4668.5913,-4642.1426,-4616.947,-4614.2563,-4615.688,-4599.662,-4576.3223,-4527.187,-4458.541,-4373.171,-4464.383,-4502.675,-4491.597,-4486.284,-4447.9414,-4424.8247,-4420.232,-4372.379,-4335.3833,-4335.022,-4351.1763,-4305.9404,-4274.224,-4275.444,-4238.8047,-4224.874,-4222.2153,-4209.183,-4187.997,-4194.5796,-4183.2544,-4174.884,-4150.7744,-4138.8877,-4127.791,-4120.396,-4114.0645,-4105.771,-4098.7163,-4080.8547,-4049.9026,-4008.0776,-3961.3496};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_109()
		{
			double[] value = {-3994.4597,-3988.8438,-4010.6182,-4002.2336,-4000.9949,-4005.4268,-4001.8577,-4026.5593,-4057.8977,-4064.106,-4069.5906,-4079.5735,-4079.6165,-4077.3342,-4066.9736,-4066.3748,-4093.3037,-4089.412,-4083.949,-4053.3098,-4019.937,-4031.0505,-4018.5503,-4044.076,-4067.7488,-4068.8518,-4065.101,-4062.754,-4087.9595,-4071.8862,-4039.3472,-3987.9136,-3965.237,-3941.0066,-3929.2898,-3905.1553,-3915.8223,-3910.9326,-3892.6594,-3841.4285,-3838.5654,-3847.9148,-3825.5593,-3797.9133,-3785.9324,-3791.649,-3791.6846,-3773.3152,-3764.36,-3745.4937,-3750.6194,-3751.0486,-3737.4185,-3723.3977,-3716.8943,-3718.777,-3727.8638,-3731.5134,-3754.4397,-3770.5237,-3784.7085,-3802.4167,-3827.0112,-3820.2698,-3833.5005,-3914.8125,-3919.2363,-3870.7297,-3865.4324,-3890.8142,-3928.6096,-3970.2898,-4006.4556,-4024.835,-4030.233,-4050.1873,-4066.3767,-4078.2356,-4046.626,-4018.132,-4703.9946,-4670.631,-4694.569,-4674.369,-4675.953,-4674.2295,-4654.6763,-4631.469,-4622.533,-4603.9995,-4584.4146,-4572.1357,-4591.6196,-4604.667,-4594.0317,-4567.516,-4542.335,-4538.6167,-4517.5474,-4474.678};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_110()
		{
			double[] value = {-4440.0386,-4417.777,-4397.104,-4384.533,-4342.0522,-4351.1504,-4341.0327,-4275.098,-4269.6636,-4265.431,-4271.069,-4267.8276,-4237.9956,-4202.093,-4206.502,-4184.243,-4193.3066,-4193.408,-4179.4688,-4160.8545,-4150.0283,-4148.6284,-4129.247,-4126.1763,-4124.595,-4089.7373,-4068.556,-4071.8477,-4050.8972,-4071.7383,-4078.3218,-4068.8884,-4071.7644,-4073.2734,-4066.3728,-4078.2244,-4076.4478,-4066.6265,-4097.1255,-4116.621,-4118.6055,-4115.14,-4108.4604,-4119.2515,-4120.8403,-4136.0796,-4137.7793,-4114.859,-4091.1,-4077.123,-4079.3118,-4079.1865,-4101.0864,-4112.999,-4046.4731,-4053.1082,-4103.828,-4090.9197,-4065.0254,-4016.3909,-3959.6228,-3936.3677,-3933.5442,-3940.625,-3904.4602,-3885.9678,-3936.1516,-3934.6414,-3947.0483,-3934.6003,-3902.198,-3866.1624,-3823.8257,-3846.309,-3827.9653,-3803.094,-3778.9045,-3759.7188,-3756.7134,-3746.6077,-3762.4846,-3759.982,-3764.345,-3772.011,-3773.1797,-3728.5938,-3766.3408,-3798.5803,-3799.1167,-3803.4514,-3824.8667,-3833.117,-3832.2588,-3827.4243,-3864.9138,-3885.3445,-3892.4517,-3901.8994,-3899.5322,-3931.8787};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_111()
		{
			double[] value = {-3965.477,-3979.5894,-4016.7217,-4036.0198,-4038.5117,-4049.0022,-4063.2603,-4072.6758,-4713.7544,-4676.244,-4698.167,-4687.172,-4683.942,-4675.2085,-4665.0034,-4647.468,-4635.846,-4627.6226,-4616.325,-4626.183,-4599.659,-4597.9814,-4661.668,-4626.28,-4611.2817,-4567.4644,-4510.1904,-4446.076,-4431.1685,-4436.137,-4436.256,-4418.8267,-4401.765,-4385.9985,-4370.1626,-4325.1978,-4289.0947,-4290.3247,-4295.576,-4298.9106,-4273.6753,-4243.935,-4221.703,-4208.343,-4220.5425,-4213.474,-4202.4,-4196.8105,-4184.8833,-4172.9375,-4161.1255,-4154.7314,-4139.3213,-4133.8555,-4120.5024,-4113.047,-4096.971,-4066.6777,-4061.879,-4109.4414,-4118.727,-4128.7217,-4133.7163,-4147.5073,-4141.681,-4113.1943,-4126.3564,-4150.1465,-4143.3022,-4154.072,-4162.105,-4164.9277,-4163.021,-4151.601,-4156.5176,-4154.941,-4149.222,-4146.3584,-4132.781,-4097.7734,-4148.338,-4149.1963,-4122.1216,-4124.684,-4144.767,-4123.6396,-4096.875,-4074.645,-4042.7578,-4010.4573,-3957.4827,-3947.1033,-3940.7793,-3959.794,-3991.582,-4007.8625,-3998.9438,-3973.4539,-3931.8257,-3895.2305};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_112()
		{
			double[] value = {-3858.2124,-3851.6584,-3852.5833,-3833.6382,-3813.2463,-3796.199,-3800.7188,-3778.7156,-3783.0237,-3782.854,-3762.0913,-3760.549,-3782.0522,-3739.6274,-3761.3674,-3776.4001,-3782.0762,-3817.5076,-3824.4475,-3842.8281,-3856.6218,-3857.2227,-3865.6567,-3877.3987,-3879.461,-3898.2773,-3875.911,-3895.0007,-3948.6597,-3961.859,-3921.9158,-3905.6794,-4014.038,-3819.9062,-3939.839,-4011.691,-4741.4565,-4705.58,-4730.553,-4717.4863,-4709.001,-4694.1025,-4673.1704,-4663.286,-4643.228,-4627.5093,-4610.0527,-4608.9585,-4590.698,-4628.482,-4660.496,-4640.218,-4618.215,-4557.738,-4513.144,-4435.5728,-4411.4585,-4455.8604,-4457.9995,-4441.7173,-4414.3896,-4378.5757,-4367.4526,-4354.907,-4335.99,-4324.766,-4282.167,-4259.4185,-4274.7163,-4224.0566,-4223.6904,-4248.36,-4241.3535,-4235.6206,-4210.4814,-4192.9746,-4190.2456,-4199.161,-4191.053,-4189.494,-4177.0005,-4139.6597,-4130.105,-4126.711,-4150.369,-4166.0728,-4163.6294,-4167.4746,-4151.351,-4139.214,-4151.6904,-4180.544,-4178.109,-4169.717,-4169.5044,-4198.6143,-4184.8975,-4174.229,-4196.3994,-4193.469};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_113()
		{
			double[] value = {-4175.8657,-4189.4966,-4191.218,-4166.103,-4158.1157,-4146.5493,-4125.3037,-4131.786,-4163.3203,-4157.0234,-4127.6216,-4126.4287,-4120.3174,-4123.9253,-4143.4653,-4139.415,-4104.9062,-4076.5251,-4028.91,-3995.3696,-3960.506,-4005.677,-4017.4482,-4009.9946,-4002.2688,-3979.2566,-3955.962,-3904.881,-3844.5005,-3884.974,-3884.8523,-3859.9941,-3862.1194,-3853.5566,-3838.781,-3795.3215,-3799.5576,-3801.8208,-3778.925,-3793.4846,-3814.8953,-3752.385,-3736.745,-3760.1738,-3767.944,-3796.9397,-3810.798,-3796.3975,-3823.9695,-3841.858,-3838.4812,-3834.6663,-3841.8672,-3864.464,-3881.802,-3896.7832,-3914.4602,-3911.085,-3833.3708,-3839.8894,-3982.477,-3882.754,-3976.0186,-4020.209,-4761.5664,-4758.009,-4750.5786,-4743.2246,-4729.602,-4684.26,-4663.954,-4646.6787,-4597.916,-4813.296,-4570.824,-4581.87,-4614.5073,-4643.475,-4614.684,-4577.1577,-4588.673,-4529.605,-4454.124,-4416.961,-4420.7144,-4477.6865,-4467.7935,-4403.324,-4385.4053,-4396.9062,-4399.7207,-4371.141,-4370.5845,-4342.809,-4289.0093,-4269.877,-4283.8916,-4264.252,-4259.3135,-4335.0366};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_114()
		{
			double[] value = {-4287.705,-4251.649,-4229.015,-4206.791,-4209.2026,-4217.932,-4216.432,-4211.436,-4198.8574,-4201.947,-4200.31,-4193.8257,-4180.195,-4194.505,-4207.6646,-4200.5967,-4188.5806,-4161.9277,-4171.616,-4182.2896,-4189.4575,-4193.191,-4159.1704,-4192.6836,-4224.7236,-4201.442,-4188.7134,-4231.0503,-4221.489,-4217.923,-4211.958,-4201.21,-4186.809,-4167.369,-4175.4863,-4204.943,-4178.7383,-4171.818,-4166.056,-4168.2666,-4157.9854,-4136.031,-4152.8184,-4144.756,-4132.889,-4108.416,-4057.1108,-4046.4124,-4014.7834,-4026.2769,-4051.6465,-4013.2727,-4001.653,-3977.746,-3978.7744,-3965.178,-3935.173,-3940.322,-3930.8875,-3902.7246,-3894.197,-3884.421,-3865.4165,-3814.5193,-3810.852,-3833.9253,-3813.2986,-3841.58,-3829.768,-3803.3347,-3742.883,-3765.5308,-3779.5674,-3782.0176,-3811.679,-3828.2397,-3826.9294,-3847.4666,-3832.5657,-3818.8613,-3837.7178,-3864.7446,-3881.59,-3901.4885,-3917.572,-3925.5408,-3914.8071,-3908.8113,-3958.9988,-4001.157,-4035.7756,-4064.0708,-4774.4287,-4767.599,-4772.557,-4759.176,-4729.635,-4701.098,-4686.9487,-4655.6973};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_115()
		{
			double[] value = {-4614.265,-4588.478,-4597.0537,-4618.1875,-4640.1914,-4656.658,-4634.236,-4592.0405,-4537.7476,-4497.325,-4418.2383,-4437.0215,-4453.0293,-4491.9033,-4475.5415,-4416.6045,-4411.377,-4419.9824,-4413.0337,-4400.6006,-4391.5303,-4386.7114,-4366.1934,-4348.0903,-4340.795,-4331.8013,-4302.679,-4251.3413,-4271.4937,-4237.8394,-4258.772,-4256.9155,-4250.238,-4260.2485,-4257.767,-4266.787,-4270.1533,-4264.8584,-4246.5127,-4235.915,-4217.019,-4221.558,-4240.522,-4230.5576,-4225.1445,-4214.9106,-4225.4087,-4227.5986,-4229.8994,-4251.381,-4247.8545,-4232.6978,-4234.036,-4218.6416,-4205.6064,-4243.8926,-4237.7783,-4226.458,-4232.166,-4213.514,-4202.009,-4224.9043,-4261.0513,-4212.78,-4200.1133,-4187.375,-4174.6885,-4189.798,-4167.9683,-4147.3477,-4139.03,-4160.9067,-4159.811,-4144.7256,-4107.7515,-4086.7896,-4056.7427,-4066.196,-4070.5999,-4038.845,-4050.022,-4034.0405,-4029.804,-4020.6455,-3995.0903,-3975.0269,-3955.687,-3948.9526,-3921.0815,-3916.195,-3906.828,-3883.304,-3891.0535,-3876.5188,-3873.2197,-3849.4363,-3836.4573,-3822.745,-3807.5457,-3800.2124};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_116()
		{
			double[] value = {-3807.4983,-3795.8315,-3808.2898,-3827.871,-3829.4277,-3840.6724,-3841.654,-3826.6091,-3832.0593,-3854.8782,-3875.5083,-3885.6816,-3900.7305,-3917.902,-3920.5437,-3899.9778,-3916.3586,-3962.8403,-4004.8762,-4032.7952,-4804.6904,-4793.5293,-4773.8145,-4752.8516,-4733.72,-4721.293,-4713.728,-4674.514,-4659.2476,-4652.184,-4646.9517,-4626.972,-4615.0273,-4627.6514,-4549.099,-4643.2017,-4531.1235,-4445.1523,-4516.458,-4511.64,-4492.679,-4480.0137,-4486.5796,-4461.752,-4454.351,-4439.3145,-4430.2866,-4407.164,-4426.0938,-4401.0645,-4391.7993,-4368.5933,-4358.122,-4346.424,-4326.518,-4310.312,-4292.5967,-4274.155,-4307.0864,-4294.277,-4281.8247,-4297.423,-4281.774,-4274.937,-4259.7227,-4261.6694,-4271.8525,-4264.665,-4259.463,-4262.6694,-4269.0796,-4268.509,-4280.102,-4286.82,-4268.4233,-4237.145,-4261.5073,-4281.041,-4275.8794,-4267.303,-4260.0547,-4244.0103,-4224.0576,-4271.382,-4277.221,-4246.7334,-4230.881,-4201.7285,-4183.502,-4187.322,-4227.3945,-4204.53,-4209.36,-4220.472,-4208.8843,-4220.4976,-4212.3813,-4175.975,-4156.651,-4175.5957};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_117()
		{
			double[] value = {-4205.914,-4195.066,-4188.3833,-4156.15,-4136.2085,-4105.0933,-4085.811,-4073.3418,-4072.608,-4057.519,-4054.911,-4065.7056,-4052.7683,-4027.3813,-4008.0938,-4000.5237,-3987.7412,-3970.7563,-3955.7385,-3920.4185,-3925.0806,-3898.509,-3886.2507,-3865.0781,-3874.5771,-3873.1904,-3870.344,-3875.3513,-3871.5872,-3838.884,-3839.6946,-3848.6707,-3841.0168,-3816.791,-3811.073,-3831.3835,-3855.4248,-3875.4446,-3882.2788,-3898.3574,-3909.0833,-3914.9595,-3931.7441,-3935.1355,-3902.7139,-3916.2017,-3959.349,-3996.8445,-4825.085,-4809.497,-4782.895,-4763.178,-4746.4556,-4748.2886,-4724.5005,-4667.335,-4678.6777,-4674.26,-4653.118,-4646.544,-4613.5776,-4573.2407,-4531.257,-5018.996,-4937.01,-4424.973,-4514.9424,-4535.6978,-4525.106,-4515.9497,-4514.78,-4470.0835,-4496.659,-4476.341,-4457.377,-4438.768,-4415.4746,-4422.0557,-4413.5586,-4390.6753,-4364.272,-4334.4844,-4336.857,-4317.7295,-4314.375,-4342.463,-4338.205,-4337.794,-4321.5493,-4332.2007,-4333.7095,-4305.3975,-4300.581,-4302.1177,-4304.436,-4302.9385,-4284.26,-4279.0312,-4293.719,-4300.1084};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_118()
		{
			double[] value = {-4307.129,-4286.055,-4288.681,-4271.875,-4287.74,-4289.034,-4279.205,-4279.028,-4268.843,-4251.2715,-4276.6665,-4284.91,-4268.7446,-4261.6704,-4251.4805,-4240.171,-4228.3794,-4200.506,-4215.218,-4226.458,-4207.248,-4241.107,-4254.287,-4250.44,-4237.2334,-4203.0312,-4174.096,-4164.9697,-4209.542,-4210.611,-4195.5576,-4185.6333,-4172.0566,-4156.0903,-4145.376,-4116.6523,-4085.6492,-4099.341,-4070.119,-4080.2183,-4081.8486,-4073.6194,-4000.7163,-3965.7954,-3990.0247,-3978.3962,-3984.842,-3959.7068,-3937.4888,-3944.7224,-3931.3052,-3912.0278,-3900.155,-3894.435,-3889.0356,-3895.4236,-3898.383,-3893.1438,-3872.8916,-3870.8403,-3863.5234,-3849.2139,-3862.1575,-3865.0513,-3871.838,-3877.423,-3882.5159,-3898.2708,-3894.1736,-3883.2856,-3916.4084,-3944.7676,-3948.1553,-3937.437,-3926.1821,-3934.6711,-4842.1,-4825.0503,-4797.732,-4766.2993,-4754.349,-4733.114,-4730.579,-4726.099,-4716.6797,-4671.736,-4653.173,-4662.134,-4653.138,-4631.4253,-4590.994,-4543.6,-4536.178,-4537.634,-4526.1265,-4544.5337,-4538.748,-4537.73,-4526.5693,-4508.7993};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_119()
		{
			double[] value = {-4517.2295,-4514.69,-4489.5757,-4473.72,-4449.548,-4435.243,-4441.4927,-4420.275,-4390.1904,-4361.288,-4366.2046,-4366.2407,-4355.1006,-4359.4927,-4356.5195,-4357.375,-4360.0034,-4368.8457,-4357.106,-4310.9077,-4348.989,-4282.742,-4294.9336,-4311.6636,-4303.144,-4298.031,-4309.983,-4315.785,-4295.0674,-4311.1514,-4314.0444,-4313.9272,-4313.8584,-4320.4785,-4319.9536,-4317.12,-4308.714,-4296.951,-4322.4155,-4326.0356,-4317.9155,-4308.679,-4295.7236,-4270.8057,-4238.0713,-4225.4424,-4237.218,-4238.78,-4220.7744,-4229.751,-4257.634,-4270.8647,-4255.1787,-4238.966,-4204.1914,-4187.9155,-4205.408,-4232.312,-4234.7827,-4227.9785,-4210.88,-4200.875,-4196.8804,-4169.822,-4163.5093,-4148.463,-4139.4287,-4134.931,-4129.527,-4104.5864,-4028.4253,-3949.5042,-3958.7432,-4017.6372,-4022.8577,-3983.6572,-3957.5332,-3969.6926,-3966.4592,-3957.2344,-3943.5486,-3931.5544,-3899.364,-3896.5637,-3914.439,-3914.2485,-3902.535,-3851.5605,-3845.1416,-3881.6108,-3885.28,-3886.2737,-3886.908,-3890.2249,-3926.3513,-3927.0586,-3890.5203,-3905.792,-3920.2139,-3923.822};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_120()
		{
			double[] value = {-3933.379,-3956.4207,-3967.5764,-3957.3408,-4843.2847,-4810.219,-4809.9136,-4788.161,-4757.934,-4721.7246,-4729.5024,-4733.25,-4712.1846,-4703.8726,-4689.371,-4664.87,-4641.3765,-4613.823,-4604.6035,-4599.5366,-4597.0635,-4583.4146,-4579.729,-4568.2905,-4547.289,-4552.8496,-4573.504,-4540.7856,-4527.4165,-4525.6543,-4506.95,-4484.8276,-4482.6562,-4464.7837,-4437.965,-4447.435,-4446.329,-4428.9136,-4419.5996,-4410.795,-4398.5156,-4355.3276,-4315.7915,-4357.0713,-4385.2417,-4386.726,-4381.183,-4345.98,-4276.5415,-4262.29,-4274.2783,-4317.116,-4338.3994,-4342.6416,-4344.882,-4349.7485,-4325.213,-4334.9946,-4322.1353,-4290.5986,-4304.008,-4304.206,-4310.9253,-4313.7744,-4320.76,-4339.199,-4352.528,-4358.7456,-4348.959,-4338.322,-4319.6377,-4291.4478,-4259.2144,-4224.33,-4236.4727,-4250.4277,-4249.941,-4234.578,-4223.0923,-4288.539,-4288.118,-4262.293,-4244.3394,-4239.851,-4215.866,-4232.21,-4263.596,-4267.849,-4239.984,-4246.7065,-4227.2383,-4238.094,-4221.5283,-4190.384,-4167.4326,-4192.411,-4171.7266,-4168.549,-4138.113,-4100.2344};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_121()
		{
			double[] value = {-4073.6636,-4053.8904,-4061.8115,-4012.7363,-4010.7378,-3973.2466,-3951.2544,-3967.0588,-3953.1235,-3923.6196,-3939.7173,-3922.529,-3892.186,-3871.5776,-3899.8882,-3896.161,-3890.9834,-3880.163,-3886.2622,-3899.9902,-3885.0952,-3876.1375,-3895.2925,-3901.5576,-3899.5232,-3912.8047,-3910.9116,-3896.2117,-3910.1377,-3953.85,-3962.6565,-3964.1045,-4833.22,-4820.2534,-4801.272,-4794.8257,-4765.3115,-4740.366,-4765.3345,-4753.82,-4744.213,-4724.8516,-4692.4224,-4672.337,-4642.793,-4586.9946,-4620.6123,-4632.4883,-4627.3643,-4597.3037,-4583.0063,-4570.9155,-4552.045,-4551.2363,-4560.9937,-4547.8003,-4515.6313,-4479.3027,-4482.7065,-4478.6704,-4474.815,-4474.96,-4478.3047,-4456.299,-4460.9287,-4455.6587,-4444.455,-4413.406,-4416.6396,-4404.958,-4411.9966,-4410.0127,-4404.2715,-4377.436,-4376.927,-4367.3066,-4354.022,-4349.1265,-4342.555,-4353.788,-4356.987,-4359.2285,-4361.44,-4348.269,-4318.215,-4304.276,-4291.085,-4263.605,-4630.916,-4260.0864,-4274.988,-4298.1216,-4319.9253,-4352.441,-4366.7974,-4369.394,-4356.4023,-4337.942,-4328.259,-4319.313};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_122()
		{
			double[] value = {-4301.5557,-4282.4507,-4280.693,-4295.961,-4273.0537,-4252.99,-4244.5654,-4250.289,-4294.848,-4288.258,-4271.3013,-4257.136,-4249.4194,-4232.3486,-4261.6865,-4276.567,-4287.8364,-4268.4624,-4255.6904,-4260.8555,-4239.368,-4233.996,-4254.6987,-4242.0977,-4194.731,-4190.023,-4166.6455,-4126.496,-4111.989,-4085.4458,-4090.6624,-4073.9888,-4060.999,-4050.258,-4048.2627,-4006.7656,-3958.9688,-3960.1682,-3958.4487,-3945.9717,-3938.7666,-3911.3699,-3898.2231,-3900.9333,-3905.2158,-3892.032,-3868.61,-3832.0254,-3840.3267,-3885.8193,-3912.4448,-3909.473,-3902.5005,-3911.572,-3902.8691,-3912.181,-3914.5007,-3916.2034,-3932.6133,-3949.1284,-4842.872,-4817.0376,-4796.095,-4814.4233,-4791.7954,-4782.261,-4778.9097,-4757.868,-4745.5005,-4718.3486,-4697.9316,-4688.231,-4663.306,-4653.7183,-4651.4624,-4639.617,-4633.132,-4602.89,-4581.456,-4583.8555,-4566.2207,-4545.4624,-4545.8667,-4548.263,-4535.2705,-4496.616,-4470.4673,-4460.409,-4458.06,-4460.107,-4468.9243,-4471.407,-4464.0586,-4458.427,-4448.2466,-4436.3657,-4420.7915,-4426.3545,-4418.3716,-4423.5034};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_123()
		{
			double[] value = {-4404.513,-4371.589,-4373.8877,-4373.563,-4370.4053,-4373.6377,-4378.5776,-4363.774,-4351.1533,-4348.5547,-4345.2666,-4338.6035,-4295.054,-4288.5435,-4271.2026,-4215.1387,-4269.8896,-4214.411,-4303.0615,-4291.2993,-4353.5312,-4382.4966,-4385.0293,-4382.565,-4379.4272,-4358.465,-4349.88,-4335.56,-4332.424,-4334.5254,-4343.726,-4346.331,-4323.665,-4299.209,-4280.78,-4256.915,-4279.507,-4300.7964,-4296.261,-4279.9243,-4293.978,-4285.6665,-4285.191,-4269.091,-4279.0723,-4288.2065,-4271.84,-4260.462,-4247.2466,-4222.862,-4221.755,-4211.1724,-4210.572,-4191.35,-4180.334,-4158.9004,-4138.2334,-4125.5513,-4077.844,-4099.526,-4089.4314,-4075.4211,-4060.1387,-4073.4104,-4050.1873,-4013.373,-3978.088,-3969.5078,-3982.7747,-3976.4966,-3970.3125,-3952.713,-3942.078,-3933.817,-3912.8713,-3895.8167,-3901.2585,-3894.7075,-3891.6682,-3894.3855,-3903.0305,-3906.343,-3901.9458,-3885.8591,-3897.5242,-3899.8604,-3931.165,-3945.2563,-4843.7075,-4819.7056,-4811.326,-4800.063,-4761.5044,-4769.216,-4775.538,-4760.85,-4743.8364,-4732.275,-4700.0996,-4698.7993};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_124()
		{
			double[] value = {-4688.353,-4682.7905,-4672.135,-4629.6357,-4643.753,-4644.694,-4626.564,-4609.519,-4601.86,-4591.9126,-4569.465,-4557.4746,-4561.1978,-4543.8926,-4534.2583,-4528.5376,-4508.5405,-4478.956,-4452.01,-4466.4697,-4479.0327,-4470.16,-4457.5625,-4426.855,-4414.2144,-4407.453,-4366.7617,-4386.78,-4405.026,-4401.7656,-4397.169,-4390.66,-4381.4033,-4384.7188,-4393.197,-4387.798,-4378.3486,-4370.154,-4364.5405,-4357.005,-4369.246,-4351.3555,-4331.8154,-4313.9805,-4299.972,-4285.952,-4311.889,-4330.687,-4358.0425,-4370.701,-4373.1177,-4370.7495,-4368.975,-4390.4697,-4384.2095,-4359.887,-4357.645,-4353.4224,-4362.281,-4354.07,-4338.0166,-4317.858,-4306.478,-4273.2383,-4284.4507,-4319.53,-4320.491,-4326.7085,-4314.525,-4291.3413,-4281.1587,-4281.023,-4262.1055,-4275.8086,-4268.527,-4267.7964,-4268.1094,-4248.041,-4234.8877,-4224.0474,-4207.4414,-4205.4653,-4193.355,-4211.065,-4193.746,-4154.553,-4135.686,-4138.374,-4120.088,-4108.809,-4094.819,-4108.7314,-4094.7092,-4091.6438,-4061.879,-4042.4966,-4019.354,-3999.2397,-3984.747,-3982.4026};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_125()
		{
			double[] value = {-3979.9932,-3957.426,-3951.9094,-3927.9602,-3909.856,-3915.4937,-3912.3284,-3900.8665,-3905.0132,-3911.1448,-3912.2847,-3908.5095,-3911.1812,-3898.381,-3915.823,-3936.4822,-4823.0264,-4811.6255,-4787.5703,-4786.296,-4790.4536,-4786.7446,-4775.1987,-4759.905,-4769.724,-4758.095,-4710.5186,-4703.042,-4697.464,-4687.0923,-4678.658,-4661.691,-4641.668,-4609.0845,-4641.9556,-4581.3184,-4607.931,-4615.4136,-4592.64,-4578.604,-4589.3145,-4583.3003,-4576.646,-4563.36,-4548.164,-4528.9385,-4515.4956,-4498.4146,-4509.1855,-4511.7163,-4494.06,-4477.222,-4475.7334,-4458.469,-4431.966,-4416.5034,-4432.8506,-4446.8076,-4430.547,-4436.579,-4443.533,-4440.702,-4433.081,-4417.393,-4402.5576,-4386.7705,-4398.1816,-4408.927,-4425.5596,-4415.304,-4410.3286,-4401.734,-4385.1123,-4365.538,-4371.01,-4369.8306,-4363.329,-4375.444,-4376.7217,-4366.8955,-4364.5923,-4378.3423,-4400.4414,-4397.7246,-4392.361,-4390.2744,-4375.0044,-4360.632,-4347.986,-4334.1235,-4322.528,-4302.1377,-4300.257,-4324.374,-4326.556,-4321.4375,-4321.9453,-4289.9424,-4283.8257,-4275.6924};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_126()
		{
			double[] value = {-4249.4517,-4225.9116,-4218.919,-4265.704,-4274.581,-4279.7314,-4272.34,-4260.2363,-4247.246,-4230.964,-4207.7764,-4208.3066,-4201.7974,-4179.3867,-4158.576,-4162.7695,-4154.715,-4144.9854,-4135.8184,-4114.5747,-4123.289,-4103.961,-4087.6816,-4086.643,-4079.6846,-4062.5808,-4047.2766,-4026.3015,-4010.7485,-3991.0464,-3979.4153,-3967.8618,-3957.556,-3962.14,-3962.3535,-3947.8374,-3936.1724,-3916.1116,-3921.538,-3912.3198,-3905.9456,-3909.151,-3924.3127,-3930.765,-4822.7134,-4815.156,-4802.5093,-4801.5493,-4790.5483,-4783.684,-4770.2773,-4746.041,-4729.3887,-4722.8403,-4718.113,-4709.2075,-4711.1626,-4702.5186,-4682.749,-4638.4653,-4635.9766,-4601.7524,-4630.3213,-4617.044,-4628.0337,-4620.002,-4613.947,-4602.1943,-4583.8276,-4577.6733,-4577.505,-4565.8633,-4554.4233,-4548.3584,-4545.4478,-4547.2314,-4536.107,-4529.5786,-4527.097,-4507.454,-4488.596,-4454.387,-4448.876,-4437.438,-4440.963,-4455.8037,-4477.405,-4480.6797,-4476.1895,-4466.4707,-4455.2935,-4450.793,-4438.2544,-4426.546,-4434.112,-4439.839,-4435.3486,-4426.25,-4429.6187,-4430.684};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_127()
		{
			double[] value = {-4419.1445,-4378.6797,-4378.4873,-4374.3657,-4370.9746,-4381.304,-4396.6006,-4396.4854,-4386.79,-4372.2383,-4373.308,-4399.4595,-4403.984,-4406.309,-4401.0596,-4390.353,-4376.8975,-4367.3975,-4343.527,-4334.829,-4342.419,-4338.186,-4348.0806,-4353.667,-4333.996,-4331.32,-4307.91,-4290.7085,-4267.878,-4247.6206,-4255.3706,-4291.3706,-4275.1284,-4271.951,-4274.95,-4262.2573,-4253.2583,-4234.6997,-4237.9453,-4238.513,-4210.7515,-4182.76,-4179.2437,-4151.192,-4152.2974,-4179.877,-4172.962,-4158.809,-4161.045,-4145.326,-4124.197,-4121.8193,-4108.139,-4103.9756,-4100.2866,-4088.037,-4080.9912,-4064.4187,-4059.726,-4048.7744,-4019.6877,-3991.1519,-3981.1016,-3989.4668,-3985.018,-3961.1091,-3959.9324,-3956.607,-3939.581,-3907.2048,-3907.6868,-3917.5815,-4837.219,-4829.795,-4821.6562,-4800.071,-4781.795,-4766.491,-4740.1255,-4722.208,-4713.564,-4718.8105,-4725.3174,-4730.9556,-4728.8994,-4732.425,-4686.8584,-4679.07,-4676.4614,-4669.858,-4658.6245,-4635.503,-4621.127,-4616.6343,-4620.888,-4617.871,-4602.646,-4590.226,-4567.5513,-4553.039};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_128()
		{
			double[] value = {-4548.245,-4539.944,-4532.1455,-4523.9883,-4518.376,-4526.2,-4528.1924,-4516.329,-4502.4717,-4499.561,-4506.238,-4509.3975,-4493.0337,-4489.308,-4487.353,-4488.197,-4487.865,-4480.3027,-4478.1987,-4478.2656,-4461.2173,-4451.062,-4448.358,-4437.7095,-4422.898,-4433.91,-4459.017,-4449.313,-4434.751,-4385.8154,-4400.3057,-4361.884,-4348.1055,-4369.0835,-4384.448,-4394.086,-4405.076,-4400.999,-4404.8877,-4412.463,-4409.6777,-4407.8,-4394.2373,-4385.1157,-4382.8506,-4386.9697,-4380.647,-4388.255,-4391.8774,-4390.8477,-4384.0728,-4364.7017,-4367.8022,-4369.003,-4349.49,-4321.348,-4284.9795,-4263.3896,-4254.144,-4309.842,-4313.6504,-4286.6284,-4246.72,-4237.368,-4223.638,-4233.786,-4237.0938,-4251.3447,-4228.893,-4212.9976,-4211.851,-4204.1616,-4182.778,-4181.4556,-4178.5083,-4167.597,-4172.337,-4184.056,-4134.5796,-4144.861,-4136.23,-4135.4746,-4125.918,-4109.503,-4110.7803,-4100.7993,-4089.4602,-4078.0437,-4059.5862,-4055.8823,-4043.0137,-4026.573,-4023.2207,-4008.09,-4010.0566,-4005.685,-3991.8813,-3983.605,-3973.1626,-3948.5962};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_129()
		{
			double[] value = {-4850.982,-4826.753,-4811.9414,-4789.751,-4768.6436,-4740.51,-4715.1816,-4716.0723,-4740.2305,-4744.9214,-4745.8735,-4750.3438,-4728.923,-4710.2866,-4695.844,-4684.9375,-4678.686,-4667.282,-4652.721,-4622.3516,-4625.106,-4627.3022,-4625.2324,-4624.297,-4617.071,-4616.3716,-4631.098,-4582.286,-4559.5864,-4544.255,-4524.5464,-4506.4834,-4498.463,-4510.9175,-4512.6035,-4518.7046,-4529.9775,-4536.0396,-4526.991,-4524.111,-4527.1626,-4520.63,-4511.845,-4502.885,-4507.283,-4505.49,-4501.3696,-4478.0166,-4488.2144,-4480.193,-4472.196,-4455.156,-4437.9575,-4444.0933,-4449.1504,-4452.599,-4450.1846,-4422.1934,-4417.816,-4407.949,-4414.8374,-4416.2915,-4406.111,-4393.9443,-4416.1167,-4424.5005,-4422.375,-4413.7744,-4410.967,-4410.29,-4405.603,-4398.875,-4404.0396,-4408.14,-4409.702,-4403.1934,-4407.3457,-4401.3506,-4391.848,-4380.0117,-4355.095,-4353.8384,-4358.037,-4337.2183,-4311.4395,-4294.8784,-4290.991,-4302.877,-4324.87,-4316.172,-4290.7295,-4265.7227,-4258.879,-4255.903,-4256.6235,-4257.6704,-4249.903,-4242.4175,-4230.335,-4223.019};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_130()
		{
			double[] value = {-4216.6597,-4213.278,-4199.2686,-4198.6626,-4183.715,-4190.59,-4190.9165,-4179.922,-4160.299,-4138.6646,-4130.207,-4117.326,-4139.299,-4144.725,-4126.9136,-4116.8647,-4108.175,-4106.894,-4095.7869,-4075.939,-4060.593,-4041.4446,-4040.4795,-4041.6567,-4027.3076,-4018.4272,-4001.8293,-4001.1565,-4816.669,-4792.661,-4777.37,-4757.347,-4743.4233,-4743.7905,-4749.167,-4755.4126,-4759.3193,-4752.7354,-4751.211,-4733.684,-4716.5845,-4700.2744,-4696.945,-4696.093,-4684.4023,-4672.647,-4663.1943,-4658.5645,-4657.135,-4649.043,-4640.231,-4628.57,-4622.3804,-4616.735,-4603.1714,-4592.7983,-4577.3057,-4562.7188,-4553.165,-4536.063,-4530.2485,-4516.311,-4505.4746,-4492.1743,-4496.7266,-4496.9644,-4500.5317,-4507.114,-4510.0806,-4515.557,-4520.5366,-4511.744,-4503.9385,-4510.427,-4504.981,-4497.389,-4490.6904,-4481.6875,-4474.3516,-4474.2144,-4470.8105,-4468.0576,-4458.218,-4467.2886,-4470.6777,-4472.767,-4486.6025,-4470.6836,-4453.757,-4446.0884,-4425.9775,-4422.633,-4436.871,-4424.4106,-4426.1177,-4418.073,-4406.3013,-4401.937,-4402.1484,-4414.215};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_131()
		{
			double[] value = {-4403.0195,-4393.0356,-4384.1665,-4382.7666,-4385.3027,-4375.261,-4361.186,-4352.7144,-4329.3853,-4354.5356,-4354.7217,-4354.0967,-4341.1143,-4333.5317,-4283.9463,-4283.004,-4303.6904,-4317.8784,-4313.2783,-4299.878,-4290.395,-4286.7046,-4270.6265,-4270.6533,-4257.7627,-4253.1074,-4259.305,-4249.7954,-4242.6943,-4236.5254,-4226.93,-4225.8193,-4216.868,-4222.4272,-4222.355,-4215.153,-4205.164,-4195.6387,-4202.6875,-4167.0903,-4152.318,-4158.437,-4142.244,-4113.2925,-4135.1104,-4139.077,-4129.9224,-4117.833,-4106.0854,-4097.637,-4094.156,-4089.296,-4081.56,-4064.3176,-4050.7725,-4049.4775,-4792.4043,-4768.719,-4777.714,-4767.1396,-4768.713,-4779.8584,-4770.568,-4760.9917,-4756.509,-4749.7925,-4747.218,-4731.029,-4714.7417,-4707.0425,-4696.6787,-4693.3545,-4682.7183,-4672.617,-4677.6855,-4675.8867,-4669.683,-4664.47,-4654.3887,-4648.933,-4638.537,-4632.3867,-4620.9434,-4611.5063,-4603.747,-4588.986,-4581.3086,-4565.6196,-4557.4253,-4553.4746,-4543.0537,-4529.418,-4513.7817,-4499.6416,-4490.604,-4494.8706,-4495.1777,-4504.418,-4499.443,-4499.495};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_132()
		{
			double[] value = {-4495.3066,-4488.24,-4493.8877,-4502.027,-4496.1006,-4491.675,-4492.653,-4490.3145,-4489.7925,-4493.6016,-4477.8784,-4459.522,-4470.302,-4457.4297,-4465.9087,-4470.7036,-4463.321,-4460.7427,-4455.8823,-4456.816,-4461.1133,-4449.4155,-4449.004,-4433.389,-4436.1953,-4432.164,-4437.8335,-4462.529,-4431.063,-4413.811,-4405.635,-4403.65,-4382.4697,-4354.5503,-4339.2754,-4345.418,-4343.859,-4329.885,-4337.649,-4338.738,-4353.768,-4370.1523,-4362.2554,-4343.119,-4328.7095,-4308.243,-4306.5415,-4306.542,-4305.4663,-4293.545,-4290.577,-4264.812,-4285.881,-4250.2114,-4252.3335,-4239.9443,-4248.1416,-4256.9385,-4256.725,-4259.2954,-4257.915,-4255.787,-4240.048,-4233.414,-4233.817,-4237.232,-4240.1426,-4221.264,-4215.2134,-4208.712,-4194.025,-4173.9624,-4163.76,-4153.486,-4144.5293,-4139.88,-4135.1274,-4126.604,-4117.4243,-4117.495,-4113.1226,-4107.846,-4090.9294,-4090.7703,-4842.9653,-4820.2114,-4798.886,-4783.5254,-4777.8613,-4764.282,-4768.1763,-4765.369,-4759.007,-4746.886,-4747.1333,-4731.3687,-4711.5366,-4691.279,-4680.996,-4673.2104};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_133()
		{
			double[] value = {-4664.018,-4665.5703,-4672.7153,-4674.8286,-4672.3535,-4666.763,-4657.2324,-4652.6064,-4648.8643,-4642.218,-4626.989,-4616.074,-4605.277,-4602.3906,-4580.4614,-4576.0005,-4579.347,-4574.8643,-4570.1826,-4559.114,-4545.936,-4528.4146,-4518.9175,-4514.276,-4522.9243,-4525.522,-4520.8325,-4508.861,-4507.0454,-4506.3047,-4497.438,-4493.8623,-4500.2393,-4499.108,-4492.395,-4472.3164,-4449.3887,-4486.508,-4485.79,-4449.2144,-4450.6597,-4458.9463,-4471.8276,-4472.821,-4461.6553,-4459.7607,-4464.1963,-4466.6465,-4459.8477,-4452.1626,-4455.818,-4458.008,-4465.9443,-4460.419,-4466.8774,-4473.905,-4452.6606,-4448.243,-4445.734,-4438.746,-4430.5845,-4411.458,-4389.9907,-4366.109,-4346.5093,-4328.5977,-4349.546,-4348.821,-4348.697,-4348.694,-4386.979,-4403.8657,-4396.7207,-4383.785,-4356.396,-4330.6665,-4307.8584,-4308.3477,-4292.713,-4278.9326,-4274.132,-4272.2617,-4289.7793,-4266.1235,-4260.809,-4238.7144,-4233.4165,-4235.028,-4245.1367,-4265.854,-4251.0967,-4225.6533,-4238.351,-4225.483,-4222.277,-4221.831,-4218.065,-4211.846,-4202.4043,-4207.0854};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_134()
		{
			double[] value = {-4188.7456,-4179.2363,-4172.28,-4160.5176,-4150.942,-4148.417,-4153.436,-4154.2144,-4152.001,-4153.6577,-4152.5977,-4151.9644,-4852.327,-4830.191,-4803.796,-4813.8076,-4760.785,-4751.299,-4753.3643,-4742.207,-4738.192,-4740.5737,-4740.5625,-4735.298,-4722.712,-4697.1294,-4672.4,-4662.978,-4658.334,-4651.1226,-4659.9,-4666.981,-4663.9854,-4658.5474,-4642.88,-4630.4062,-4622.2114,-4624.171,-4620.4487,-4619.57,-4619.6836,-4609.2,-4578.81,-4579.974,-4577.895,-4583.8853,-4574.164,-4566.123,-4558.652,-4517.005,-4525.888,-4509.87,-4497.9297,-4538.04,-4543.3545,-4542.136,-4531.7075,-4522.1665,-4511.95,-4499.5874,-4484.6265,-4476.611,-4477.456,-4471.381,-4480.358,-4481.4663,-4485.9424,-4447.61,-4462.6313,-4468.7637,-4481.0127,-4488.687,-4493.2256,-4491.0986,-4494.306,-4494.746,-4491.7725,-4486.5796,-4480.7,-4477.6123,-4471.176,-4465.9014,-4468.092,-4474.9795,-4474.2666,-4473.356,-4471.106,-4462.787,-4456.8555,-4443.5273,-4425.5063,-4407.3384,-4385.5454,-4368.312,-4347.183,-4341.204,-4356.2705,-4343.3667,-4351.0815,-4373.937};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_135()
		{
			double[] value = {-4384.854,-4396.3364,-4401.0312,-4394.2676,-4380.232,-4368.8047,-4350.2173,-4331.3486,-4327.518,-4318.477,-4319.039,-4314.4165,-4304.2075,-4290.244,-4267.7124,-4269.7134,-4260.517,-4270.398,-4287.603,-4276.031,-4255.1484,-4246.529,-4246.825,-4238.5557,-4228.526,-4223.443,-4213.8047,-4207.64,-4194.16,-4185.0156,-4185.5586,-4185.7817,-4183.3823,-4177.7515,-4170.8916,-4168.2495,-4167.921,-4169.2925,-4167.9536,-4161.8975,-4841.5527,-4797.0303,-4787.097,-4870.604,-4749.482,-4739.8965,-4745.797,-4744.787,-4744.065,-4731.7393,-4723.1973,-4714.489,-4710.557,-4697.2446,-4674.9985,-4664.587,-4645.642,-4650.65,-4650.577,-4666.4116,-4661.618,-4649.3423,-4646.561,-4638.0728,-4627.711,-4611.9385,-4614.4463,-4615.313,-4615.418,-4608.497,-4600.3896,-4593.2583,-4578.6895,-4580.0947,-4573.1636,-4569.734,-4569.6636,-4558.369,-4547.1646,-4557.111,-4551.701,-4552.275,-4547.2734,-4546.5728,-4538.7266,-4521.1353,-4523.3477,-4519.902,-4513.4175,-4507.2026,-4495.443,-4490.8413,-4489.4966,-4487.9175,-4487.642,-4502.9375,-4503.87,-4499.5117,-4510.996,-4522.1924};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_136()
		{
			double[] value = {-4515.6924,-4510.2095,-4496.4595,-4497.9087,-4508.084,-4507.832,-4499.0576,-4473.8564,-4476.109,-4476.452,-4480.7544,-4487.6743,-4486.519,-4481.8516,-4461.444,-4454.2764,-4461.0474,-4461.029,-4450.317,-4432.2114,-4410.8574,-4392.782,-4372.111,-4353.4336,-4359.0815,-4372.976,-4366.5566,-4372.3105,-4351.924,-4355.478,-4368.633,-4386.9243,-4401.7285,-4406.538,-4387.5874,-4365.7144,-4369.4995,-4357.761,-4330.0024,-4312.443,-4319.0327,-4324.7554,-4312.7344,-4310.7627,-4304.468,-4294.434,-4289.6626,-4288.2144,-4303.5024,-4309.258,-4269.744,-4255.006,-4271.437,-4277.201,-4270.811,-4262.8667,-4253.7085,-4251.238,-4250.9214,-4234.1885,-4211.858,-4207.3237,-4211.4033,-4221.726,-4220.643,-4220.0166,-4208.7134,-4193.274,-4812.3535,-4806.732,-4798.864,-4784.989,-4777.439,-4774.2876,-4772.0723,-4768.1426,-4756.16,-4737.628,-4730.6533,-4725.51,-4720.5356,-4710.6396,-4710.1943,-4703.636,-4694.977,-4685.052,-4655.726,-4649.3066,-4635.6245,-4647.9565,-4633.513,-4635.0234,-4625.3438,-4605.8203,-4606.519,-4612.042,-4612.733,-4614.9497,-4614.3286,-4602.8926};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_137()
		{
			double[] value = {-4594.996,-4591.9653,-4582.9136,-4580.7456,-4571.888,-4565.2046,-4559.485,-4563.6055,-4567.5522,-4563.1895,-4561.127,-4556.956,-4559.476,-4558.6265,-4550.3716,-4548.361,-4536.3545,-4511.848,-4498.7974,-4492.4106,-4495.4224,-4512.7417,-4517.0825,-4515.489,-4514.4907,-4511.1597,-4513.9023,-4522.074,-4514.7607,-4507.9414,-4505.748,-4507.901,-4504.3677,-4509.577,-4511.2544,-4498.974,-4483.279,-4478.5635,-4476.545,-4483.331,-4473.9414,-4469.0454,-4467.4033,-4460.3804,-4460.2583,-4466.927,-4456.731,-4448.6055,-4434.9434,-4404.1836,-4393.863,-4398.14,-4401.0283,-4400.335,-4408.3374,-4405.8794,-4401.8955,-4393.7705,-4383.5176,-4368.953,-4393.506,-4422.513,-4416.0317,-4406.268,-4406.701,-4396.576,-4390.5127,-4368.825,-4358.6416,-4335.6304,-4310.0376,-4327.365,-4332.7393,-4328.6187,-4313.7563,-4310.931,-4300.292,-4275.563,-4217.52,-4226.7,-4276.711,-4311.3774,-4294.4893,-4292.0947,-4294.5806,-4288.0894,-4279.0312,-4265.399,-4243.2803,-4235.415,-4247.1675,-4241.119,-4240.288,-4226.479,-4222.93,-4229.359,-4833.7363,-4820.219,-4811.2627,-4808.817};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_138()
		{
			double[] value = {-4797.374,-4795.95,-4788.1973,-4772.8833,-4748.37,-4740.888,-4737.032,-4735.7393,-4734.4927,-4737.8433,-4730.7563,-4729.785,-4727.5903,-4724.499,-4730.3335,-4744.92,-4720.3613,-4697.869,-4650.85,-4643.032,-4633.636,-4623.972,-4621.4053,-4610.4634,-4609.416,-4608.042,-4601.7715,-4597.733,-4599.5537,-4599.6626,-4594.1533,-4593.798,-4582.9272,-4566.0273,-4557.5234,-4561.383,-4560.467,-4558.0366,-4548.544,-4549.4873,-4554.425,-4564.852,-4563.881,-4565.9805,-4556.7393,-4540.797,-4528.743,-4528.245,-4534.366,-4547.1885,-4556.0737,-4557.8726,-4551.615,-4545.3843,-4537.334,-4541.3765,-4530.2476,-4518.0605,-4522.5425,-4528.6855,-4530.522,-4523.866,-4516.2383,-4510.955,-4504.3477,-4503.0635,-4494.0264,-4486.753,-4490.592,-4484.854,-4477.881,-4468.9004,-4470.318,-4481.213,-4476.3506,-4469.96,-4445.539,-4409.418,-4427.9116,-4435.028,-4439.4917,-4433.078,-4431.8687,-4443.3896,-4438.4634,-4404.7437,-4399.2407,-4382.298,-4375.927,-4410.6123,-4427.7974,-4432.8867,-4431.601,-4423.068,-4419.7114,-4415.848,-4409.306,-4384.566,-4365.729,-4359.434};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_139()
		{
			double[] value = {-4363.596,-4360.7017,-4353.9326,-4353.5864,-4338.369,-4329.148,-4311.0645,-4299.844,-4301.973,-4302.6836,-4310.307,-4319.095,-4303.0625,-4291.483,-4302.052,-4307.3633,-4310.0947,-4304.6504,-4303.38,-4291.2876,-4276.053,-4278.988,-4248.2275,-4246.7534,-4836.9385,-4825.614,-4815.502,-4819.552,-4838.466,-4812.9395,-4797.3345,-4786.939,-4763.1016,-4741.7764,-4734.337,-4735.585,-4734.248,-4741.947,-4745.6934,-4741.8813,-4739.5166,-4746.3003,-4769.323,-4783.003,-4766.6943,-4729.2896,-4683.5815,-4656.054,-4653.005,-4651.4946,-4634.225,-4638.815,-4640.5728,-4636.1978,-4626.449,-4611.759,-4603.5903,-4602.8013,-4604.4824,-4605.6914,-4607.0054,-4604.6846,-4596.499,-4593.775,-4596.686,-4589.6855,-4580.4497,-4576.727,-4567.208,-4565.45,-4565.949,-4561.128,-4553.4595,-4551.4463,-4552.0063,-4556.0044,-4553.1353,-4567.9326,-4574.525,-4573.204,-4569.6514,-4561.184,-4559.118,-4554.0703,-4541.444,-4546.3467,-4538.1064,-4522.1904,-4531.799,-4530.8447,-4523.4736,-4517.958,-4507.4565,-4506.545,-4502.2725,-4503.1655,-4497.6377,-4495.774,-4487.4336,-4483.54};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_140()
		{
			double[] value = {-4477.5444,-4473.926,-4472.0127,-4457.4,-4414.908,-4425.5566,-4445.6694,-4448.712,-4451.053,-4445.604,-4448.371,-4441.4414,-4434.1133,-4433.6523,-4432.704,-4416.4346,-4403.1304,-4375.1763,-4413.209,-4437.532,-4445.255,-4442.7476,-4441.1924,-4438.097,-4431.1406,-4424.204,-4426.5605,-4416.8022,-4400.692,-4381.459,-4390.863,-4390.7656,-4379.1167,-4360.9385,-4356.7837,-4359.721,-4354.4775,-4330.476,-4327.6924,-4326.226,-4331.3213,-4325.027,-4324.878,-4332.966,-4331.64,-4325.953,-4329.2197,-4318.763,-4312.6875,-4305.6245,-4289.872,-4260.246,-4843.615,-4840.315,-4829.28,-4829.644,-4835.1064,-4816.8477,-4803.5205,-4791.5923,-4782.6963,-4765.507,-4751.6465,-4749.7764,-4736.963,-4729.9775,-4736.6816,-4742.7397,-4737.805,-4731.313,-4730.549,-4724.895,-4721.8984,-4712.32,-4702.4834,-4684.684,-4681.7036,-4674.003,-4666.752,-4664.7515,-4659.6025,-4653.615,-4645.4346,-4645.0767,-4638.763,-4634.1167,-4623.3447,-4619.1104,-4600.7734,-4633.1987,-4613.315,-4599.6816,-4616.7803,-4609.3296,-4608.0747,-4598.498,-4597.033,-4590.618,-4587.1157,-4579.6};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_141()
		{
			double[] value = {-4585.484,-4586.5884,-4583.3877,-4580.307,-4575.7666,-4579.534,-4582.457,-4580.0566,-4575.02,-4568.4263,-4564.18,-4564.126,-4560.277,-4552.4863,-4549.295,-4537.116,-4514.886,-4500.9707,-4494.1875,-4497.1953,-4504.003,-4505.593,-4496.2905,-4499.1426,-4501.1777,-4505.4995,-4504.3403,-4497.8623,-4500.9517,-4490.404,-4486.0356,-4475.3213,-4446.592,-4437.8438,-4428.4487,-4434.2476,-4435.769,-4437.5645,-4446.824,-4443.0195,-4421.601,-4442.2915,-4444.073,-4449.617,-4449.6875,-4453.7017,-4453.1523,-4461.697,-4463.162,-4463.195,-4457.0015,-4456.8843,-4458.8027,-4472.4727,-4472.6577,-4449.006,-4437.945,-4433.7686,-4428.488,-4423.074,-4416.2046,-4405.776,-4381.7837,-4373.1133,-4388.4683,-4390.3496,-4379.968,-4373.147,-4362.556,-4354.395,-4347.718,-4342.4956,-4340.203,-4331.044,-4303.71,-4299.5303,-4260.6235,-4233.7036,-4226.4956,-4219.3086,-4850.4653,-4854.039,-4846.941,-4836.8457,-4832.453,-4816.397,-4792.953,-4782.0503,-4741.2695,-4688.011,-4732.777,-4730.761,-4710.6924,-4719.1743,-4730.775,-4736.8623,-4743.948,-4744.252,-4738.715,-4733.5166};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_142()
		{
			double[] value = {-4730.5156,-4727.862,-4719.7026,-4709.0806,-4704.4395,-4689.5605,-4672.7227,-4666.136,-4663.833,-4659.005,-4659.2593,-4651.478,-4645.1675,-4641.323,-4633.3467,-4639.4,-4629.4546,-4630.692,-4625.177,-4630.2197,-4627.9385,-4621.3384,-4619.607,-4614.2676,-4606.191,-4603.7495,-4599.242,-4594.9067,-4597.874,-4608.229,-4601.7993,-4602.902,-4606.681,-4601.405,-4592.834,-4584.2935,-4578.7534,-4578.403,-4572.782,-4571.3066,-4568.084,-4564.3633,-4558.8604,-4551.527,-4542.3877,-4537.677,-4531.635,-4522.6235,-4524.691,-4521.3687,-4512.846,-4507.515,-4495.845,-4500.984,-4521.517,-4517.9424,-4512.541,-4514.443,-4490.1895,-4493.86,-4507.591,-4495.318,-4460.3975,-4432.0615,-4421.3315,-4405.496,-4428.419,-4455.5806,-4462.274,-4470.1562,-4469.6587,-4470.0493,-4472.135,-4473.8325,-4478.2554,-4480.4556,-4483.447,-4485.4087,-4477.4614,-4472.9575,-4469.982,-4472.8115,-4470.8735,-4456.044,-4456.2036,-4452.5483,-4449.9185,-4448.2505,-4439.8125,-4432.359,-4427.817,-4411.7183,-4416.7197,-4422.2344,-4416.347,-4406.542,-4412.065,-4411.656,-4409.5767,-4402.1387};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_143()
		{
			double[] value = {-4390.2944,-4373.461,-4338.48,-4322.387,-4216.942,-4260.9277,-4146.136,-4161.449,-4829.423,-4825.034,-4806.9297,-4811.0073,-4807.05,-4791.2485,-4793.2305,-4770.097,-4716.4395,-4690.6973,-4688.261,-4691.0854,-4693.7173,-4687.3447,-4659.871,-4646.842,-4653.5664,-4655.83,-4659.4375,-4684.8223,-4711.1226,-4717.7227,-4705.333,-4708.984,-4710.2676,-4700.0522,-4694.5293,-4693.3013,-4695.975,-4692.577,-4677.611,-4672.446,-4668.596,-4665.613,-4661.4795,-4659.036,-4656.3613,-4652.154,-4646.2,-4646.0835,-4647.0186,-4645.216,-4651.043,-4644.312,-4646.6924,-4639.5166,-4626.2744,-4618.7373,-4609.496,-4609.283,-4617.3086,-4619.7637,-4617.0093,-4610.659,-4594.0073,-4581.3633,-4597.6646,-4585.808,-4567.1177,-4562.361,-4577.5938,-4576.561,-4565.2837,-4556.0176,-4543.1406,-4542.4004,-4536.4136,-4531.617,-4533.49,-4529.325,-4527.4673,-4519.001,-4511.2095,-4500.474,-4508.709,-4486.402,-4496.3677,-4513.0845,-4523.214,-4521.907,-4509.389,-4509.5938,-4506.2964,-4500.623,-4498.415,-4497.4355,-4480.2764,-4479.473,-4479.4033,-4478.268,-4469.0703,-4447.417};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_144()
		{
			double[] value = {-4457.1035,-4469.9404,-4455.9272,-4454.854,-4463.548,-4471.3887,-4478.923,-4475.3677,-4460.947,-4469.6494,-4478.6895,-4478.3296,-4474.0024,-4467.6655,-4456.3574,-4454.887,-4452.4487,-4442.8315,-4442.0444,-4441.7686,-4451.1343,-4443.077,-4439.251,-4426.609,-4414.9663,-4415.8555,-4417.118,-4419.781,-4422.538,-4418.226,-4417.804,-4405.483,-4385.013,-4389.058,-4395.0024,-4409.7036,-4531.1333,-4513.9497,-4518.6313,-4548.896,-4619.978,-4621.854,-4622.9873,-4573.8984,-4451.2617,-4416.3774,-4440.651,-4524.559,-4546.431,-4608.871,-4628.608,-4477.619,-4432.0786,-4584.1055,-4552.349,-4565.642,-4605.987,-4691.4995,-4586.737,-4402.5503,-4393.078,-4494.512,-4599.3613,-4657.389,-4671.9,-4640.988,-4599.9287,-4506.8716,-4585.973,-4612.5083,-4639.957,-4656.3955,-4649.7124,-4646.3027,-4620.063,-4586.988,-4615.9614,-4643.94,-4647.1606,-4644.0015,-4642.2373,-4634.0024,-4636.552,-4638.1074,-4632.336,-4627.812,-4629.727,-4624.0825,-4621.4375,-4615.7983,-4612.053,-4604.3315,-4593.019,-4580.5015,-4586.873,-4583.5566,-4583.7896,-4582.6167,-4587.486,-4586.56};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_145()
		{
			double[] value = {-4583.7764,-4580.343,-4573.111,-4566.2744,-4558.362,-4546.8306,-4536.199,-4543.3115,-4544.804,-4539.4985,-4535.527,-4529.3145,-4522.8057,-4525.399,-4523.573,-4521.1333,-4514.7275,-4516.8853,-4496.678,-4476.0015,-4458.4233,-4452.0107,-4501.526,-4464.9507,-4472.927,-4485.3027,-4498.4795,-4495.5903,-4488.716,-4482.13,-4466.606,-4463.751,-4465.964,-4467.922,-4459.735,-4464.8926,-4471.271,-4472.0615,-4478.6006,-4486.0166,-4473.206,-4457.6997,-4442.458,-4433.707,-4439.1787,-4464.484,-4474.128,-4471.9478,-4472.796,-4461.12,-4461.8486,-4461.715,-4463.418,-4466.722,-4462.8535,-4459.1304,-4454.4746,-4440.8623,-4435.1133,-4441.347,-4445.234,-4438.311,-4435.4043,-4440.5166,-3882.505,-3897.3418,-3992.3455,-4067.4617,-4062.4827,-4097.857,-4281.953,-4120.968,-4008.0598,-4072.5767,-4202.2437,-4305.237,-4277.132,-4128.466,-4036.7144,-3942.3625,-3962.317,-3972.0,-3905.0054,-4070.965,-4145.818,-4267.8184,-4306.5938,-4414.4775,-4513.671,-4345.6963,-4056.0044,-3941.221,-3839.5596,-3846.3738,-3857.2668,-3895.7366,-4027.2446,-4160.7305,-4191.662,-4102.297};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_146()
		{
			double[] value = {-4212.3096,-4385.418,-4471.827,-4467.5903,-4498.21,-4502.3115,-4477.5474,-4477.6475,-4499.9844,-4513.698,-4537.414,-4561.643,-4584.9863,-4595.2593,-4593.539,-4605.269,-4606.5947,-4581.587,-4575.8975,-4570.0137,-4574.4014,-4583.7666,-4592.5933,-4592.906,-4594.4023,-4595.0005,-4596.8604,-4587.715,-4580.107,-4578.7266,-4576.024,-4561.993,-4548.3975,-4519.886,-4512.0796,-4535.541,-4546.9927,-4553.984,-4551.876,-4544.8604,-4543.5493,-4538.6377,-4530.8154,-4529.024,-4528.162,-4524.925,-4508.2026,-4448.4946,-4396.2217,-4422.1104,-4527.1387,-4359.307,-4265.5034,-4345.7173,-4421.7734,-4449.706,-4462.1875,-4467.1006,-4469.306,-4477.0693,-4481.7476,-4490.2207,-4479.872,-4472.3423,-4480.812,-4479.5635,-4479.0903,-4481.811,-4469.9336,-4463.4634,-4461.9224,-4463.8633,-4472.0684,-4473.105,-4475.898,-4473.4497,-4464.4883,-4468.157,-4472.288,-4477.7505,-4473.0083,-4476.244,-4480.65,-4486.7944,-4466.7593,-4471.0034,-4473.505,-4475.4116,-4478.804,-4477.8374,-4478.8477,-4477.5713,-3664.0964,-3640.859,-3652.6145,-3758.3792,-3848.7961,-3836.1523,-3814.6086,-3796.5479};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_147()
		{
			double[] value = {-3757.7617,-3663.924,-3608.2163,-3559.6355,-3563.8267,-3578.2468,-3645.1018,-3767.1587,-3832.2856,-3807.2002,-3852.2942,-3853.3062,-3708.4348,-3709.8625,-3799.3894,-3853.8354,-3724.3362,-3629.484,-3639.692,-3678.93,-3710.717,-3719.1738,-3766.8315,-3830.388,-3774.5564,-3864.8025,-3894.7754,-3951.07,-4089.9827,-4164.063,-4245.2593,-4137.6475,-3989.6816,-4013.239,-4057.2363,-4076.525,-4253.415,-4441.17,-4467.9854,-4418.3955,-4419.696,-4381.1523,-4330.6914,-4332.821,-4383.7573,-4433.6797,-4426.527,-4447.535,-4473.448,-4477.9204,-4472.9033,-4463.244,-4473.412,-4490.063,-4498.4575,-4506.8735,-4504.7925,-4494.787,-4478.7407,-4459.0464,-4444.692,-4437.6997,-4448.3438,-4445.539,-4431.0444,-4427.3555,-4422.955,-4425.823,-4423.984,-4435.6323,-4455.509,-4482.1226,-4504.1562,-4527.552,-4483.219,-4335.043,-4298.7285,-4301.1357,-4310.8164,-4313.406,-4322.109,-4328.8413,-4333.658,-4341.91,-4348.6113,-4350.096,-4359.392,-4368.95,-4381.616,-4395.953,-4409.1123,-4418.7124,-4426.483,-4435.089,-4432.355,-4427.8228,-4402.5703,-4399.061,-4411.176,-4420.361};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_148()
		{
			double[] value = {-4423.7354,-4431.719,-4437.6553,-4447.0815,-4447.2505,-4444.9863,-4438.248,-4440.96,-4440.736,-4438.2324,-4442.72,-4452.4453,-4452.0527,-4456.985,-4457.0703,-4462.063,-4475.2666,-4474.8423,-4481.2383,-4475.532,-3392.6042,-3419.0754,-3570.8174,-3727.5566,-3581.303,-3489.7314,-3425.0896,-3374.775,-3353.8215,-3343.8281,-3334.4727,-3373.1787,-3508.0222,-3708.2627,-3603.3801,-3438.3865,-3509.702,-3617.6926,-3489.0586,-3403.9187,-3340.6392,-3272.773,-3262.835,-3254.426,-3245.4614,-3254.9338,-3278.0889,-3310.1511,-3396.4785,-3573.5134,-3529.3953,-3430.4937,-3462.8008,-3767.2573,-3803.2583,-3646.5952,-3637.659,-3663.3218,-3577.1672,-3545.4116,-3613.2583,-3793.739,-3820.0208,-3930.86,-3955.8296,-3847.4646,-3621.9888,-3514.354,-3673.9998,-3861.25,-3978.8125,-3934.5322,-3941.5535,-4242.2407,-4372.105,-4360.4307,-4352.5557,-4272.81,-4211.903,-4177.528,-4186.8325,-4194.938,-4204.8145,-4233.1323,-4300.5127,-4365.5,-4435.4243,-4445.6523,-4427.99,-4431.4927,-4434.877,-4427.9907,-4451.4355,-4429.6587,-4458.1143,-4327.0386,-4237.0156,-4207.3584,-4310.926,-4393.7266};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_149()
		{
			double[] value = {-4428.434,-4381.5264,-4264.26,-4177.5225,-4148.6084,-4150.817,-4172.9146,-4200.409,-4218.1177,-4222.3525,-4223.219,-4244.2495,-4293.495,-4322.666,-4292.6196,-4266.48,-4267.9863,-4301.2393,-4364.0713,-4444.7207,-4462.203,-4323.044,-4271.5273,-4264.355,-4256.0137,-4259.1904,-4312.302,-4358.454,-4393.733,-4429.0293,-4414.3447,-4375.576,-4321.1855,-4292.054,-4283.4565,-4287.638,-4297.3857,-4310.778,-4321.6313,-4330.1924,-4340.875,-4355.1367,-4367.236,-4384.6587,-4410.1816,-4410.562,-4406.9536,-4405.401,-3272.0637,-3314.1057,-3330.543,-3291.3909,-3262.9697,-3235.6763,-3206.0327,-3202.2678,-3206.7346,-3201.6843,-3200.7668,-3250.5305,-3265.4836,-3198.496,-3175.265,-3196.081,-3206.394,-3162.8987,-3139.8223,-3144.0518,-3133.8813,-3123.631,-3121.1194,-3115.672,-3121.7664,-3133.5073,-3135.8506,-3182.5474,-3250.6777,-3226.7935,-3142.2483,-3113.0222,-3190.9363,-3309.7297,-3363.623,-3409.6428,-3339.9688,-3349.5693,-3335.9626,-3301.3982,-3272.0818,-3233.9932,-3204.0032,-3228.962,-3270.5854,-3302.6267,-3320.5432,-3321.7505,-3317.6807,-3362.264,-3344.7844,-3401.1118};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_150()
		{
			double[] value = {-3626.5347,-3741.7742,-3856.9314,-3930.7075,-3917.8887,-3861.5513,-3795.2864,-3748.1687,-3731.7288,-3681.8186,-3641.6758,-3699.9722,-3759.9736,-4001.4531,-4206.669,-4196.282,-4073.8035,-4069.5334,-4162.755,-4198.226,-4185.7773,-4150.3735,-4040.2485,-3961.9712,-3938.5183,-3934.1616,-3940.9546,-3924.3062,-3892.0125,-3882.5527,-3903.4832,-3935.5286,-3943.155,-3972.5674,-4023.8242,-4004.4622,-3945.215,-3948.3264,-3992.323,-4052.6072,-4036.057,-3986.1467,-3975.391,-4013.0127,-4044.0874,-4120.383,-4135.4336,-4112.3047,-4075.0479,-4016.7278,-3998.4429,-4013.8767,-4129.9917,-4188.3003,-4099.5957,-4043.595,-3997.6555,-3970.7375,-3971.2642,-4021.0044,-4074.285,-4084.4634,-4080.5645,-4067.1875,-4063.1443,-4079.1943,-4097.97,-4117.8013,-4123.9165,-4132.991,-4153.711,-4180.461,-4195.3433,-4194.4995,-4191.685,-4200.418,-3208.259,-3204.0073,-3206.3203,-3202.0527,-3193.3196,-3186.29,-3179.9756,-3171.4214,-3166.104,-3158.7473,-3151.5095,-3147.4912,-3140.7483,-3134.6978,-3124.5825,-3113.2195,-3106.1611,-3099.4592,-3098.8462,-3097.9863,-3092.8652,-3086.9834,-3082.5862,-3078.7751};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_151()
		{
			double[] value = {-3075.573,-3070.9658,-3067.3826,-3064.6887,-3059.5747,-3056.3774,-3053.5977,-3049.978,-3045.1697,-3042.2307,-3042.7102,-3050.929,-3056.475,-3059.1506,-3072.4006,-3082.7742,-3072.9036,-3059.599,-3082.3018,-3134.5205,-3171.1619,-3172.8716,-3131.705,-3136.0913,-3183.8362,-3217.1367,-3207.233,-3204.921,-3243.2778,-3284.4102,-3315.5444,-3338.4912,-3367.3757,-3383.5127,-3386.7483,-3394.7683,-3419.063,-3455.2502,-3499.037,-3526.7861,-3530.099,-3538.2864,-3577.3267,-3634.0618,-3672.9104,-3668.3984,-3674.2686,-3694.9297,-3654.476,-3623.2185,-3608.1624,-3609.2458,-3621.0938,-3638.3606,-3663.9172,-3692.3032,-3733.541,-3776.8916,-3786.824,-3778.0227,-3762.5605,-3777.0103,-3822.9858,-3846.3887,-3833.4795,-3787.9006,-3701.0596,-3638.6465,-3630.5564,-3632.8967,-3642.5813,-3657.928,-3705.958,-3782.085,-3852.3372,-3886.8677,-3859.5532,-3758.7063,-3685.9978,-3720.0913,-3845.2998,-3926.79,-3814.264,-3719.4668,-3677.2158,-3682.4592,-3683.2327,-3686.7517,-3691.101,-3713.23,-3736.5605,-3741.4834,-3742.543,-3740.2295,-3738.9802,-3756.9412,-3783.3096,-3817.602,-3840.6355,-3814.2683};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_152()
		{
			double[] value = {-3780.282,-3791.5288,-3811.8413,-3842.4216,-3298.8494,-3295.9148,-3290.6428,-3287.9255,-3284.7576,-3280.472,-3276.3022,-3272.3826,-3267.322,-3259.934,-3251.121,-3243.0583,-3234.3809,-3225.4038,-3216.1775,-3207.367,-3199.3508,-3189.2976,-3179.6426,-3170.3918,-3162.2227,-3154.367,-3149.4028,-3143.8147,-3139.8452,-3137.7842,-3133.11,-3127.8867,-3120.9397,-3112.5242,-3103.685,-3094.5583,-3084.8152,-3075.906,-3069.2434,-3062.5986,-3057.1833,-3050.4624,-3043.7402,-3036.836,-3030.7288,-3024.4695,-3017.5427,-3011.8186,-3007.661,-3003.757,-3001.1665,-2998.4824,-2994.361,-2989.998,-2986.3787,-2991.4507,-3013.161,-3063.5354,-3112.5625,-3160.024,-3208.31,-3249.6868,-3294.4072,-3342.6443,-3387.7913,-3423.9763,-3446.454,-3460.1504,-3474.047,-3484.1567,-3501.4343,-3504.8147,-3485.342,-3444.9775,-3456.8286,-3510.8547,-3540.1165,-3567.1501,-3595.8782,-3610.5928,-3626.7024,-3636.2153,-3640.22,-3629.2693,-3591.1355,-3514.909,-3443.3357,-3397.6968,-3393.725,-3403.2744,-3406.1345,-3431.0984,-3470.8726,-3504.9036,-3524.5676,-3531.639,-3538.2175,-3539.6318,-3541.086,-3551.756};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_153()
		{
			double[] value = {-3566.6143,-3579.7625,-3575.159,-3545.0657,-3526.8787,-3536.2922,-3537.8003,-3520.6753,-3515.5618,-3519.1526,-3527.5876,-3538.261,-3540.8203,-3531.7434,-3512.7546,-3501.032,-3492.0579,-3487.6921,-3495.5837,-3515.975,-3538.1018,-3558.4,-3562.9634,-3551.2207,-3532.0225,-3538.256,-3548.343,-3546.5764,-3540.3418,-3543.9937,-3551.2798,-3563.2444,-3527.0134,-3535.4246,-3541.1272,-3544.5781,-3544.9607,-3540.278,-3534.8696,-3517.7468,-3494.962,-3478.1636,-3466.8643,-3447.9475,-3424.16,-3404.9163,-3388.776,-3379.4377,-3363.5305,-3344.5005,-3327.259,-3318.1748,-3309.9226,-3297.9092,-3325.3477,-3320.207,-3275.6758,-3247.0525,-3227.3203,-3215.9312,-3205.668,-3197.054,-3188.8293,-3178.3599,-3169.692,-3160.4563,-3147.3362,-3132.9302,-3118.6545,-3105.8467,-3094.381,-3083.9563,-3074.4968,-3066.6292,-3059.1353,-3052.7224,-3047.9602,-3042.8994,-3039.0483,-3034.2817,-3029.241,-3023.4443,-3017.182,-3011.999,-3009.2012,-3008.6748,-3010.001,-3012.9805,-3018.5398,-3025.9849,-3038.467,-3052.6987,-3066.406,-3080.213,-3093.66,-3107.724,-3120.6309,-3133.1577,-3146.7644,-3162.86};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_154()
		{
			double[] value = {-3181.1294,-3196.985,-3210.5261,-3223.472,-3236.4573,-3249.4045,-3259.3643,-3267.4675,-3274.5876,-3276.662,-3282.5288,-3287.7605,-3294.3696,-3303.1267,-3314.2683,-3323.047,-3335.5542,-3346.431,-3354.8157,-3360.4133,-3369.1904,-3377.5637,-3381.3652,-3383.6812,-3384.1824,-3384.728,-3383.6282,-3381.8113,-3383.933,-3377.0132,-3365.671,-3346.1628,-3330.9004,-3318.5898,-3320.1025,-3338.6187,-3362.941,-3375.6624,-3380.75,-3377.838,-3361.7869,-3342.003,-3325.9211,-3316.3252,-3316.274,-3322.5474,-3329.2385,-3334.3481,-3332.5273,-3330.0903,-3336.7554,-3344.6902,-3350.8555,-3358.3625,-3364.121,-3373.8064,-3380.1511,-3380.347,-3374.139,-3364.4265,-4214.194,-4299.8413,-4400.816,-4430.5127,-4379.5684,-4172.4194,-3997.8408,-3937.6477,-3865.556,-3856.6924,-3787.173,-3712.5286,-3665.732,-3621.7327,-3602.0977,-3600.6384,-3544.0083,-3486.9722,-3455.2407,-3447.1353,-3489.142,-3452.063,-3532.752,-3669.6167,-3473.8113,-3395.0457,-3349.7158,-3293.069,-3259.7249,-3235.1355,-3214.1506,-3200.351,-3188.5068,-3174.7197,-3159.7544,-3145.5525,-3132.0884,-3120.703,-3109.7654,-3101.2014};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_155()
		{
			double[] value = {-3092.7036,-3085.5947,-3078.486,-3072.6528,-3066.9983,-3061.2576,-3054.775,-3047.3323,-3040.2383,-3033.191,-3027.1045,-3020.6692,-3016.0413,-3012.2644,-3010.3198,-3008.2505,-3008.3342,-3007.4492,-3008.051,-3009.5898,-3012.6963,-3016.3247,-3020.3772,-3024.7268,-3029.0789,-3033.558,-3037.3955,-3042.6462,-3047.1714,-3052.2673,-3058.3965,-3064.4177,-3069.1638,-3074.3735,-3078.896,-3082.7393,-3086.4485,-3090.383,-3094.949,-3099.402,-3102.7634,-3106.976,-3110.3308,-3113.6838,-3116.0576,-3119.3252,-3122.5469,-3126.3638,-3129.9082,-3136.05,-3143.2744,-3153.6592,-3165.174,-3173.9788,-3180.7097,-3185.3743,-3180.592,-3167.9846,-3154.351,-3146.1594,-3141.0989,-3140.9617,-3140.756,-3140.969,-3140.6382,-3139.6738,-3137.3164,-3135.7002,-3133.3037,-3132.7253,-3132.5217,-3133.613,-3138.5032,-3148.745,-3157.4873,-3159.881,-3178.1917,-3186.0735,-3186.3577,-3188.547,-3185.1326,-3178.6428,-3170.1528,-3166.8518,-3167.2026,-3168.073,-3171.309,-3171.963,-4276.9893,-4348.8877,-4351.561,-4284.704,-4155.624,-3877.5132,-3589.5874,-3549.8218,-3505.135,-3451.2854,-3406.5742,-3383.7134};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_156()
		{
			double[] value = {-3376.6228,-3374.8643,-3362.1958,-3339.2344,-3318.5203,-3305.2788,-3300.979,-3306.7534,-3313.8503,-3293.3706,-3260.7854,-3244.5107,-3205.4824,-3176.7625,-3154.1477,-3141.3484,-3131.1106,-3125.026,-3118.7075,-3113.7327,-3104.659,-3098.767,-3092.2026,-3085.1978,-3079.6306,-3073.082,-3066.6233,-3059.466,-3049.9026,-3038.334,-3026.868,-3017.0813,-3007.7935,-2999.0537,-2990.5854,-2982.1052,-2975.6262,-2969.2625,-2964.2559,-2958.9229,-2953.4255,-2949.0078,-2944.5938,-2940.1794,-2936.2517,-2933.6003,-2932.3696,-2931.5073,-2931.3535,-2932.767,-2934.6033,-2936.546,-2938.1301,-2940.2622,-2942.0308,-2943.3018,-2944.3394,-2945.9797,-2948.8064,-2952.2698,-2956.7805,-2961.3428,-2966.1536,-2970.1252,-2974.3206,-2978.5007,-2981.9033,-2985.3604,-2988.3306,-2990.8967,-2992.5222,-2994.5728,-2997.7678,-3001.7175,-3005.3513,-3009.3655,-3012.3862,-3014.3418,-3015.7551,-3017.0505,-3017.0505,-3017.0505,-3017.0667,-3016.3298,-3014.5964,-3013.3833,-3013.426,-3012.527,-3011.9978,-3011.283,-3012.0613,-3012.745,-3015.093,-3016.5767,-3017.444,-3022.1118,-3029.8384,-3044.6638,-3056.1182,-3059.3032};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_157()
		{
			double[] value = {-3063.6443,-3063.3606,-3058.591,-3051.1592,-3039.3892,-3031.7776,-3032.8862,-3035.5999,-3039.5369,-3042.7417,-3044.5737,-3044.2156,-3044.2185,-3044.3694,-3045.9653,-3049.1736,-3249.1736,-3245.5413,-3242.4573,-3233.573,-3220.5408,-3204.03,-3189.884,-3171.3586,-3154.2478,-3136.2021,-3122.0916,-3107.986,-3096.1987,-3085.3376,-3074.2756,-3063.3538,-3054.1458,-3048.3154,-3040.7239,-3029.402,-3016.762,-3005.9124,-2996.6628,-2988.3284,-2982.3613,-2975.5598,-2970.6477,-2966.3022,-2964.0347,-2963.8633,-2962.8767,-2962.012,-2959.2505,-2958.4814,-2956.165,-2953.229,-2949.6943,-2943.6165,-2937.136,-2931.8042,-2929.2285,-2931.7961,-2930.599,-2921.3032,-2912.7878,-2906.953,-2899.8242,-2892.0142,-2883.9717,-2874.033,-2862.0073,-2850.7046,-2840.4185,-2830.6895,-2822.5225,-2817.0583,-2812.3906,-2809.2996,-2808.2122,-2808.8018,-2810.7126,-2813.7837,-2817.85,-2824.4,-2830.6702,-2838.2463,-2846.0662,-2854.3386,-2863.1785,-2871.2747,-2881.4617,-2888.6184,-2886.446,-2884.687,-2884.3867,-2875.0708,-2874.7798,-2876.2295,-2875.7231,-2873.6252,-2877.637,-2880.9165,-2881.9563,-2882.9229};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_158()
		{
			double[] value = {-2884.344,-2885.7158,-2887.4854,-2889.374,-2892.364,-2893.1401,-2894.5596,-2891.3198,-2891.188,-2891.5466,-2881.5737,-2870.19,-2863.0977,-2866.6865,-2873.8838,-2881.2754,-2893.9207,-2904.8625,-2904.4165,-2909.473,-2914.1143,-2919.2476,-2924.8845,-2936.781,-2955.2544,-2970.1426,-2973.1018,-2962.4126,-2949.6714,-2939.63,-2935.889,-2936.8142,-2940.7969,-2945.8208,-2948.9543,-2954.021,-2954.6272,-2959.7852,-2964.903,-2973.6204,-2982.862,-2979.2332,-2968.6768,-2953.523,-3002.38,-2987.42,-2975.294,-2968.3298,-2963.3052,-2958.3652,-2954.387,-2951.8352,-2949.3848,-2945.8577,-2940.5803,-2936.21,-2930.4307,-2925.861,-2923.9219,-2926.467,-2927.9385,-2929.482,-2924.4287,-2918.4875,-2909.0315,-2900.6055,-2891.181,-2883.3865,-2875.0796,-2870.0469,-2866.411,-2861.8809,-2853.9854,-2842.2385,-2835.5164,-2829.8994,-2824.1926,-2811.1316,-2800.4263,-2791.7,-2789.7031,-2781.2388,-2774.6885,-2767.5898,-2753.404,-2738.1648,-2725.727,-2719.2505,-2716.3752,-2715.2278,-2715.563,-2719.9204,-2729.5278,-2732.7002,-2739.464,-2746.6946,-2750.5308,-2742.5305,-2745.13,-2740.7942};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_159()
		{
			double[] value = {-2739.28,-2728.9143,-2719.0466,-2714.9517,-2710.7224,-2705.3396,-2696.3628,-2689.5996,-2681.7476,-2674.3076,-2667.9749,-2656.334,-2649.9448,-2645.6504,-2638.3003,-2625.18,-2617.5364,-2622.9526,-2636.648,-2650.8958,-2662.4473,-2671.6897,-2679.1426,-2681.3105,-2681.217,-2677.6934,-2674.6873,-2671.1282,-2668.5808,-2672.103,-2678.745,-2693.411,-2714.7034,-2727.0623,-2727.2632,-2735.4407,-2729.7415,-2728.891,-2734.2004,-2742.1118,-2752.414,-2762.0186,-2770.4883,-2778.124,-2783.271,-2785.7651,-2782.6462,-2778.2637,-2778.2498,-2781.3022,-2790.2598,-2805.4277,-2820.5728,-2836.7295,-2855.0735,-2866.826,-2869.2139,-2860.9722,-2860.824,-2854.4788,-2844.9016,-2842.1877,-2839.523,-2828.6711,-2822.9316,-2816.67,-2809.512,-2807.6409,-2781.8271,-2771.4456,-2798.1643,-2833.9326,-2836.036,-2797.627,-2805.7358,-2840.8452,-2825.3467,-2782.5825,-2747.2703,-2740.0347,-2743.6836,-2712.3967,-2694.6982,-2684.8706,-2678.1223,-2675.3381,-2672.214,-2667.4011,-2663.0833,-2657.9683,-2653.2063,-2669.1096,-2694.4587,-2674.3967,-2686.567,-2655.305,-2680.1528,-2708.371,-2735.321,-2749.3372};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_160()
		{
			double[] value = {-2749.985,-2727.1755,-2686.8096,-2640.339,-2610.9924,-2591.0496,-2585.863,-2586.5957,-2596.1606,-2617.8057,-2645.3057,-2595.3948,-2572.7078,-2572.531,-2576.8352,-2579.3362,-2580.9146,-2582.0815,-2579.0537,-2573.346,-2561.938,-2553.6304,-2539.985,-2540.013,-2523.9094,-2513.7107,-2509.061,-2506.822,-2501.8818,-2495.0632,-2493.696,-2504.2803,-2509.945,-2509.776,-2506.4756,-2504.0083,-2502.0095,-2493.434,-2483.85,-2471.3872,-2465.2405,-2463.393,-2463.868,-2464.562,-2467.526,-2471.2542,-2475.811,-2484.5845,-2495.7065,-2505.1218,-2513.8945,-2534.2551,-2568.5369,-2598.2495,-2612.0278,-2630.7373,-2680.2266,-2710.7483,-2696.3923,-2622.4478,-2549.8296,-2540.244,-2555.3965,-2563.876,-2562.0315,-2563.1257,-2560.0166,-2557.8145,-2560.5447,-2559.6333,-2560.838,-2568.6675,-2586.358,-2607.585,-2628.7073,-2642.02,-2650.3064,-2667.1562,-2661.1018,-2626.6672,-2614.0154,-2623.4292,-2625.4316,-2616.1506,-2630.613,-2670.8792,-2696.4998,-2678.6133,-2600.991,-2623.0686,-2590.4275,-2547.1277,-2522.4663,-2519.006,-2527.8042,-2537.3323,-2552.243,-2536.9756,-2517.3987,-2504.0027};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_161()
		{
			double[] value = {-2816.9036,-2792.345,-2707.2566,-2674.7021,-2646.2666,-2575.574,-2500.057,-2495.788,-2551.9497,-2475.1448,-2466.6584,-2469.316,-2473.9438,-2483.2285,-2494.7607,-2503.1995,-2511.0825,-2505.19,-2491.6506,-2492.274,-2532.4321,-2526.3254,-2509.5747,-2482.6624,-2511.3823,-2537.5693,-2573.9265,-2608.0984,-2618.6995,-2592.8572,-2547.6985,-2491.6775,-2438.715,-2395.0417,-2373.8127,-2377.9053,-2407.34,-2452.618,-2489.4663,-2430.957,-2386.7097,-2377.7192,-2381.5674,-2397.6199,-2415.327,-2424.4102,-2424.0251,-2410.0947,-2397.2617,-2396.9353,-2407.8499,-2414.6567,-2408.8442,-2406.5537,-2407.7,-2409.2322,-2401.2493,-2381.7449,-2423.715,-2460.582,-2474.4023,-2435.7095,-2398.1772,-2372.2478,-2348.807,-2327.647,-2309.8938,-2292.0745,-2282.8147,-2288.117,-2295.6858,-2300.4946,-2305.0513,-2312.1016,-2320.9028,-2332.696,-2342.715,-2350.7312,-2360.6943,-2372.752,-2392.0452,-2411.09,-2419.931,-2424.8672,-2435.9426,-2445.6707,-2446.2605,-2433.2139,-2432.2786,-2488.8567,-2549.9548,-2588.4773,-2580.9812,-2537.5322,-2472.0427,-2447.6624,-2486.702,-2527.617,-2532.33,-2541.6123};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_162()
		{
			double[] value = {-2563.411,-2583.4216,-2575.2043,-2480.4546,-2340.204,-2452.8982,-2407.6838,-2262.4683,-2217.0054,-2222.7834,-2237.4775,-2248.0898,-2236.3977,-2251.3645,-2283.905,-2291.1133,-2238.191,-2276.2866,-2285.3335,-2269.8237,-2273.7903,-2313.969,-2324.27,-2265.9822,-2342.7988,-2310.219,-2286.0874,-2276.8281,-2458.5254,-2462.593,-2410.6602,-2354.0615,-2332.2388,-2340.599,-2354.221,-2353.241,-2352.042,-2350.623,-2358.362,-2363.165,-2368.8066,-2365.7542,-2358.7083,-2355.19,-2349.6506,-2344.8816,-2334.8005,-2330.0994,-2322.2378,-2319.238,-2315.3782,-2318.1204,-2327.3733,-2325.4272,-2337.7317,-2348.286,-2351.808,-2341.7275,-2333.9116,-2331.9043,-2328.4043,-2329.4443,-2328.7625,-2336.6907,-2341.6523,-2337.5027,-2317.909,-2298.7043,-2287.6492,-2280.5017,-2274.0737,-2267.5833,-2263.0437,-2259.2527,-2257.3086,-2266.1372,-2306.0256,-2253.799,-2255.126,-2288.3938,-2246.5295,-2248.2766,-2248.7258,-2259.4543,-2298.6907,-2286.1218,-2336.028,-2371.4753,-2342.7776,-2283.478,-2237.388,-2218.4692,-2206.8508,-2199.3306,-2193.4707,-2190.0994,-2186.7097,-2186.9648,-2188.1956,-2187.32};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_163()
		{
			double[] value = {-2185.3845,-2182.9912,-2181.0535,-2178.1616,-2175.8003,-2172.4993,-2169.4087,-2165.4695,-2163.8032,-2162.685,-2160.919,-2159.0962,-2157.9895,-2154.4795,-2150.9377,-2146.796,-2139.7349,-2133.4568,-2125.8755,-2113.7966,-2105.4949,-2124.5715,-2134.615,-2129.7664,-2193.8213,-2252.3762,-2262.1082,-2256.4187,-2252.7932,-2247.6035,-2210.3843,-2141.9207,-2136.674,-2177.0808,-2172.6663,-2141.5056,-2126.9148,-2123.3894,-2122.8909,-2122.409,-2115.5027,-2111.3125,-2111.9456,-2115.8103,-2119.407,-2124.9255,-2141.8882,-2127.3,-2131.6963,-2151.6272,-2155.1787,-2118.185,-2110.4841,-2096.4985,-2092.4219,-2087.5962,-2156.0864,-2137.0864,-2164.7058,-2186.8809,-2200.7627,-2245.0547,-2231.592,-2191.7092,-2168.174,-2164.6028,-2191.0225,-2146.7732,-2134.193,-2127.1846,-2127.911,-2130.6885,-2139.7654,-2178.9612,-2178.7578,-2134.2495,-2128.3208,-2129.562,-2130.548,-2134.5503,-2138.948,-2156.0342,-2190.8435,-2168.982,-2134.6516,-2127.0667,-2122.561,-2120.754,-2120.6228,-2120.3132,-2119.127,-2125.0789,-2127.7434,-2122.4043,-2116.7805,-2112.1462,-2108.8318,-2107.2825,-2107.5598,-2105.363};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_164()
		{
			double[] value = {-2108.1477,-2110.3704,-2114.2725,-2141.0781,-2135.1924,-2124.94,-2136.3193,-2151.1086,-2143.7524,-2139.2053,-2131.3367,-2118.7253,-2119.126,-2116.1873,-2116.2834,-2115.4995,-2115.174,-2112.9124,-2110.1042,-2104.9119,-2101.0708,-2097.9585,-2094.8464,-2091.936,-2090.5312,-2085.942,-2083.5664,-2080.0627,-2077.4998,-2076.3533,-2072.9941,-2071.345,-2066.5771,-2063.7456,-2063.0393,-2063.2092,-2065.4048,-2065.9163,-2067.6692,-2069.201,-2071.994,-2075.9778,-2073.4702,-2068.1929,-2065.2847,-2063.7668,-2061.368,-2060.8262,-2060.306,-2062.5818,-2062.13,-2062.9724,-2065.597,-2074.9907,-2084.0208,-2073.5222,-2066.7898,-2061.4814,-2058.0605,-2053.1494,-2053.5125,-2053.6953,-2053.0647,-2050.9397,-2049.281,-2049.3289,-2050.4749,-2052.0723,-2053.1392,-2052.9697,-2051.3672,-2048.343,-2042.5223,-2037.823,-2039.4436,-2030.2119,-2023.7336,-2028.7584,-2040.5497,-2034.3451,-2021.1912,-2011.85,-2004.5542,-2000.7144};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.00787,0.00391,0.01575,0.00391,0.02362,0.00391,0.0315,0.00391,0.03937,0.00391,0.04724,0.00391,0.05512,0.00391,0.06299,0.00391,0.07087,0.00391,0.07874,0.00391,0.08661,0.00391,0.09449,0.00391,0.10236,0.00391,0.11024,0.00391,0.11811,0.00391,0.12598,0.00391,0.13386,0.00391,0.14173,0.00391,0.14961,0.00391,0.15748,0.00391,0.16535,0.00391,0.17323,0.00391,0.1811,0.00391,0.18898,0.00391,0.19685,0.00391,0.20472,0.00391,0.2126,0.00391,0.22047,0.00391,0.22835,0.00391,0.23622,0.00391,0.24409,0.00391,0.25197,0.00391,0.25984,0.00391,0.26772,0.00391,0.27559,0.00391,0.28346,0.00391,0.29134,0.00391,0.29921,0.00391,0.30709,0.00391,0.31496,0.00391,0.32283,0.00391,0.33071,0.00391,0.33858,0.00391,0.34646,0.00391,0.35433,0.00391,0.3622,0.00391,0.37008,0.00391,0.37795,0.00391,0.38583,0.00391,0.3937,0.00391,0.40157,0.00391,0.40945,0.00391,0.41732,0.00391,0.4252,0.00391,0.43307,0.00391,0.44094,0.00391,0.44882,0.00391,0.45669,0.00391,0.46457,0.00391,0.47244,0.00391,0.48031,0.00391,0.48819,0.00391,0.49606,0.00391,0.50394,0.00391,0.51181,0.00391,0.51969,0.00391,0.52756,0.00391,0.53543,0.00391,0.54331,0.00391,0.55118,0.00391,0.55906,0.00391,0.56693,0.00391,0.5748,0.00391,0.58268,0.00391,0.59055,0.00391,0.59843,0.00391,0.6063,0.00391,0.61417,0.00391,0.62205,0.00391,0.62992,0.00391,0.6378,0.00391,0.64567,0.00391,0.65354,0.00391,0.66142,0.00391,0.66929,0.00391,0.67717,0.00391,0.68504,0.00391,0.69291,0.00391,0.70079,0.00391,0.70866,0.00391,0.71654,0.00391,0.72441,0.00391,0.73228,0.00391,0.74016,0.00391,0.74803,0.00391,0.75591,0.00391,0.76378,0.00391,0.77165,0.00391,0.77953,0.00391};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.7874,0.00391,0.79528,0.00391,0.80315,0.00391,0.81102,0.00391,0.8189,0.00391,0.82677,0.00391,0.83465,0.00391,0.84252,0.00391,0.85039,0.00391,0.85827,0.00391,0.86614,0.00391,0.87402,0.00391,0.88189,0.00391,0.88976,0.00391,0.89764,0.00391,0.90551,0.00391,0.91339,0.00391,0.92126,0.00391,0.92913,0.00391,0.93701,0.00391,0.94488,0.00391,0.95276,0.00391,0.96063,0.00391,0.9685,0.00391,0.97638,0.00391,0.98425,0.00391,0.99213,0.00391,0.99609,0.00391,0.00391,0.00787,0.00787,0.00787,0.01575,0.00787,0.02362,0.00787,0.0315,0.00787,0.03937,0.00787,0.04724,0.00787,0.05512,0.00787,0.06299,0.00787,0.07087,0.00787,0.07874,0.00787,0.08661,0.00787,0.09449,0.00787,0.10236,0.00787,0.11024,0.00787,0.11811,0.00787,0.12598,0.00787,0.13386,0.00787,0.14173,0.00787,0.14961,0.00787,0.15748,0.00787,0.16535,0.00787,0.17323,0.00787,0.1811,0.00787,0.18898,0.00787,0.19685,0.00787,0.20472,0.00787,0.2126,0.00787,0.22047,0.00787,0.22835,0.00787,0.23622,0.00787,0.24409,0.00787,0.25197,0.00787,0.25984,0.00787,0.26772,0.00787,0.27559,0.00787,0.28346,0.00787,0.29134,0.00787,0.29921,0.00787,0.30709,0.00787,0.31496,0.00787,0.32283,0.00787,0.33071,0.00787,0.33858,0.00787,0.34646,0.00787,0.35433,0.00787,0.3622,0.00787,0.37008,0.00787,0.37795,0.00787,0.38583,0.00787,0.3937,0.00787,0.40157,0.00787,0.40945,0.00787,0.41732,0.00787,0.4252,0.00787,0.43307,0.00787,0.44094,0.00787,0.44882,0.00787,0.45669,0.00787,0.46457,0.00787,0.47244,0.00787,0.48031,0.00787,0.48819,0.00787,0.49606,0.00787,0.50394,0.00787,0.51181,0.00787,0.51969,0.00787,0.52756,0.00787,0.53543,0.00787,0.54331,0.00787,0.55118,0.00787,0.55906,0.00787};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.56693,0.00787,0.5748,0.00787,0.58268,0.00787,0.59055,0.00787,0.59843,0.00787,0.6063,0.00787,0.61417,0.00787,0.62205,0.00787,0.62992,0.00787,0.6378,0.00787,0.64567,0.00787,0.65354,0.00787,0.66142,0.00787,0.66929,0.00787,0.67717,0.00787,0.68504,0.00787,0.69291,0.00787,0.70079,0.00787,0.70866,0.00787,0.71654,0.00787,0.72441,0.00787,0.73228,0.00787,0.74016,0.00787,0.74803,0.00787,0.75591,0.00787,0.76378,0.00787,0.77165,0.00787,0.77953,0.00787,0.7874,0.00787,0.79528,0.00787,0.80315,0.00787,0.81102,0.00787,0.8189,0.00787,0.82677,0.00787,0.83465,0.00787,0.84252,0.00787,0.85039,0.00787,0.85827,0.00787,0.86614,0.00787,0.87402,0.00787,0.88189,0.00787,0.88976,0.00787,0.89764,0.00787,0.90551,0.00787,0.91339,0.00787,0.92126,0.00787,0.92913,0.00787,0.93701,0.00787,0.94488,0.00787,0.95276,0.00787,0.96063,0.00787,0.9685,0.00787,0.97638,0.00787,0.98425,0.00787,0.99213,0.00787,0.99609,0.00787,0.00391,0.01575,0.00787,0.01575,0.01575,0.01575,0.02362,0.01575,0.0315,0.01575,0.03937,0.01575,0.04724,0.01575,0.05512,0.01575,0.06299,0.01575,0.07087,0.01575,0.07874,0.01575,0.08661,0.01575,0.09449,0.01575,0.10236,0.01575,0.11024,0.01575,0.11811,0.01575,0.12598,0.01575,0.13386,0.01575,0.14173,0.01575,0.14961,0.01575,0.15748,0.01575,0.16535,0.01575,0.17323,0.01575,0.1811,0.01575,0.18898,0.01575,0.19685,0.01575,0.20472,0.01575,0.2126,0.01575,0.22047,0.01575,0.22835,0.01575,0.23622,0.01575,0.24409,0.01575,0.25197,0.01575,0.25984,0.01575,0.26772,0.01575,0.27559,0.01575,0.28346,0.01575,0.29134,0.01575,0.29921,0.01575,0.30709,0.01575,0.31496,0.01575,0.32283,0.01575,0.33071,0.01575,0.33858,0.01575};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.34646,0.01575,0.35433,0.01575,0.3622,0.01575,0.37008,0.01575,0.37795,0.01575,0.38583,0.01575,0.3937,0.01575,0.40157,0.01575,0.40945,0.01575,0.41732,0.01575,0.4252,0.01575,0.43307,0.01575,0.44094,0.01575,0.44882,0.01575,0.45669,0.01575,0.46457,0.01575,0.47244,0.01575,0.48031,0.01575,0.48819,0.01575,0.49606,0.01575,0.50394,0.01575,0.51181,0.01575,0.51969,0.01575,0.52756,0.01575,0.53543,0.01575,0.54331,0.01575,0.55118,0.01575,0.55906,0.01575,0.56693,0.01575,0.5748,0.01575,0.58268,0.01575,0.59055,0.01575,0.59843,0.01575,0.6063,0.01575,0.61417,0.01575,0.62205,0.01575,0.62992,0.01575,0.6378,0.01575,0.64567,0.01575,0.65354,0.01575,0.66142,0.01575,0.66929,0.01575,0.67717,0.01575,0.68504,0.01575,0.69291,0.01575,0.70079,0.01575,0.70866,0.01575,0.71654,0.01575,0.72441,0.01575,0.73228,0.01575,0.74016,0.01575,0.74803,0.01575,0.75591,0.01575,0.76378,0.01575,0.77165,0.01575,0.77953,0.01575,0.7874,0.01575,0.79528,0.01575,0.80315,0.01575,0.81102,0.01575,0.8189,0.01575,0.82677,0.01575,0.83465,0.01575,0.84252,0.01575,0.85039,0.01575,0.85827,0.01575,0.86614,0.01575,0.87402,0.01575,0.88189,0.01575,0.88976,0.01575,0.89764,0.01575,0.90551,0.01575,0.91339,0.01575,0.92126,0.01575,0.92913,0.01575,0.93701,0.01575,0.94488,0.01575,0.95276,0.01575,0.96063,0.01575,0.9685,0.01575,0.97638,0.01575,0.98425,0.01575,0.99213,0.01575,0.99609,0.01575,0.00391,0.02362,0.00787,0.02362,0.01575,0.02362,0.02362,0.02362,0.0315,0.02362,0.03937,0.02362,0.04724,0.02362,0.05512,0.02362,0.06299,0.02362,0.07087,0.02362,0.07874,0.02362,0.08661,0.02362,0.09449,0.02362,0.10236,0.02362,0.11024,0.02362,0.11811,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.12598,0.02362,0.13386,0.02362,0.14173,0.02362,0.14961,0.02362,0.15748,0.02362,0.16535,0.02362,0.17323,0.02362,0.1811,0.02362,0.18898,0.02362,0.19685,0.02362,0.20472,0.02362,0.2126,0.02362,0.22047,0.02362,0.22835,0.02362,0.23622,0.02362,0.24409,0.02362,0.25197,0.02362,0.25984,0.02362,0.26772,0.02362,0.27559,0.02362,0.28346,0.02362,0.29134,0.02362,0.29921,0.02362,0.30709,0.02362,0.31496,0.02362,0.32283,0.02362,0.33071,0.02362,0.33858,0.02362,0.34646,0.02362,0.35433,0.02362,0.3622,0.02362,0.37008,0.02362,0.37795,0.02362,0.38583,0.02362,0.3937,0.02362,0.40157,0.02362,0.40945,0.02362,0.41732,0.02362,0.4252,0.02362,0.43307,0.02362,0.44094,0.02362,0.44882,0.02362,0.45669,0.02362,0.46457,0.02362,0.47244,0.02362,0.48031,0.02362,0.48819,0.02362,0.49606,0.02362,0.50394,0.02362,0.51181,0.02362,0.51969,0.02362,0.52756,0.02362,0.53543,0.02362,0.54331,0.02362,0.55118,0.02362,0.55906,0.02362,0.56693,0.02362,0.5748,0.02362,0.58268,0.02362,0.59055,0.02362,0.59843,0.02362,0.6063,0.02362,0.61417,0.02362,0.62205,0.02362,0.62992,0.02362,0.6378,0.02362,0.64567,0.02362,0.65354,0.02362,0.66142,0.02362,0.66929,0.02362,0.67717,0.02362,0.68504,0.02362,0.69291,0.02362,0.70079,0.02362,0.70866,0.02362,0.71654,0.02362,0.72441,0.02362,0.73228,0.02362,0.74016,0.02362,0.74803,0.02362,0.75591,0.02362,0.76378,0.02362,0.77165,0.02362,0.77953,0.02362,0.7874,0.02362,0.79528,0.02362,0.80315,0.02362,0.81102,0.02362,0.8189,0.02362,0.82677,0.02362,0.83465,0.02362,0.84252,0.02362,0.85039,0.02362,0.85827,0.02362,0.86614,0.02362,0.87402,0.02362,0.88189,0.02362,0.88976,0.02362,0.89764,0.02362,0.90551,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.91339,0.02362,0.92126,0.02362,0.92913,0.02362,0.93701,0.02362,0.94488,0.02362,0.95276,0.02362,0.96063,0.02362,0.9685,0.02362,0.97638,0.02362,0.98425,0.02362,0.99213,0.02362,0.99609,0.02362,0.00391,0.0315,0.00787,0.0315,0.01575,0.0315,0.02362,0.0315,0.0315,0.0315,0.03937,0.0315,0.04724,0.0315,0.05512,0.0315,0.06299,0.0315,0.07087,0.0315,0.07874,0.0315,0.08661,0.0315,0.09449,0.0315,0.10236,0.0315,0.11024,0.0315,0.11811,0.0315,0.12598,0.0315,0.13386,0.0315,0.14173,0.0315,0.14961,0.0315,0.15748,0.0315,0.16535,0.0315,0.17323,0.0315,0.1811,0.0315,0.18898,0.0315,0.19685,0.0315,0.20472,0.0315,0.2126,0.0315,0.22047,0.0315,0.22835,0.0315,0.23622,0.0315,0.24409,0.0315,0.25197,0.0315,0.25984,0.0315,0.26772,0.0315,0.27559,0.0315,0.28346,0.0315,0.29134,0.0315,0.29921,0.0315,0.30709,0.0315,0.31496,0.0315,0.32283,0.0315,0.33071,0.0315,0.33858,0.0315,0.34646,0.0315,0.35433,0.0315,0.3622,0.0315,0.37008,0.0315,0.37795,0.0315,0.38583,0.0315,0.3937,0.0315,0.40157,0.0315,0.40945,0.0315,0.41732,0.0315,0.4252,0.0315,0.43307,0.0315,0.44094,0.0315,0.44882,0.0315,0.45669,0.0315,0.46457,0.0315,0.47244,0.0315,0.48031,0.0315,0.48819,0.0315,0.49606,0.0315,0.50394,0.0315,0.51181,0.0315,0.51969,0.0315,0.52756,0.0315,0.53543,0.0315,0.54331,0.0315,0.55118,0.0315,0.55906,0.0315,0.56693,0.0315,0.5748,0.0315,0.58268,0.0315,0.59055,0.0315,0.59843,0.0315,0.6063,0.0315,0.61417,0.0315,0.62205,0.0315,0.62992,0.0315,0.6378,0.0315,0.64567,0.0315,0.65354,0.0315,0.66142,0.0315,0.66929,0.0315,0.67717,0.0315,0.68504,0.0315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.69291,0.0315,0.70079,0.0315,0.70866,0.0315,0.71654,0.0315,0.72441,0.0315,0.73228,0.0315,0.74016,0.0315,0.74803,0.0315,0.75591,0.0315,0.76378,0.0315,0.77165,0.0315,0.77953,0.0315,0.7874,0.0315,0.79528,0.0315,0.80315,0.0315,0.81102,0.0315,0.8189,0.0315,0.82677,0.0315,0.83465,0.0315,0.84252,0.0315,0.85039,0.0315,0.85827,0.0315,0.86614,0.0315,0.87402,0.0315,0.88189,0.0315,0.88976,0.0315,0.89764,0.0315,0.90551,0.0315,0.91339,0.0315,0.92126,0.0315,0.92913,0.0315,0.93701,0.0315,0.94488,0.0315,0.95276,0.0315,0.96063,0.0315,0.9685,0.0315,0.97638,0.0315,0.98425,0.0315,0.99213,0.0315,0.99609,0.0315,0.00391,0.03937,0.00787,0.03937,0.01575,0.03937,0.02362,0.03937,0.0315,0.03937,0.03937,0.03937,0.04724,0.03937,0.05512,0.03937,0.06299,0.03937,0.07087,0.03937,0.07874,0.03937,0.08661,0.03937,0.09449,0.03937,0.10236,0.03937,0.11024,0.03937,0.11811,0.03937,0.12598,0.03937,0.13386,0.03937,0.14173,0.03937,0.14961,0.03937,0.15748,0.03937,0.16535,0.03937,0.17323,0.03937,0.1811,0.03937,0.18898,0.03937,0.19685,0.03937,0.20472,0.03937,0.2126,0.03937,0.22047,0.03937,0.22835,0.03937,0.23622,0.03937,0.24409,0.03937,0.25197,0.03937,0.25984,0.03937,0.26772,0.03937,0.27559,0.03937,0.28346,0.03937,0.29134,0.03937,0.29921,0.03937,0.30709,0.03937,0.31496,0.03937,0.32283,0.03937,0.33071,0.03937,0.33858,0.03937,0.34646,0.03937,0.35433,0.03937,0.3622,0.03937,0.37008,0.03937,0.37795,0.03937,0.38583,0.03937,0.3937,0.03937,0.40157,0.03937,0.40945,0.03937,0.41732,0.03937,0.4252,0.03937,0.43307,0.03937,0.44094,0.03937,0.44882,0.03937,0.45669,0.03937,0.46457,0.03937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.47244,0.03937,0.48031,0.03937,0.48819,0.03937,0.49606,0.03937,0.50394,0.03937,0.51181,0.03937,0.51969,0.03937,0.52756,0.03937,0.53543,0.03937,0.54331,0.03937,0.55118,0.03937,0.55906,0.03937,0.56693,0.03937,0.5748,0.03937,0.58268,0.03937,0.59055,0.03937,0.59843,0.03937,0.6063,0.03937,0.61417,0.03937,0.62205,0.03937,0.62992,0.03937,0.6378,0.03937,0.64567,0.03937,0.65354,0.03937,0.66142,0.03937,0.66929,0.03937,0.67717,0.03937,0.68504,0.03937,0.69291,0.03937,0.70079,0.03937,0.70866,0.03937,0.71654,0.03937,0.72441,0.03937,0.73228,0.03937,0.74016,0.03937,0.74803,0.03937,0.75591,0.03937,0.76378,0.03937,0.77165,0.03937,0.77953,0.03937,0.7874,0.03937,0.79528,0.03937,0.80315,0.03937,0.81102,0.03937,0.8189,0.03937,0.82677,0.03937,0.83465,0.03937,0.84252,0.03937,0.85039,0.03937,0.85827,0.03937,0.86614,0.03937,0.87402,0.03937,0.88189,0.03937,0.88976,0.03937,0.89764,0.03937,0.90551,0.03937,0.91339,0.03937,0.92126,0.03937,0.92913,0.03937,0.93701,0.03937,0.94488,0.03937,0.95276,0.03937,0.96063,0.03937,0.9685,0.03937,0.97638,0.03937,0.98425,0.03937,0.99213,0.03937,0.99609,0.03937,0.00391,0.04724,0.00787,0.04724,0.01575,0.04724,0.02362,0.04724,0.0315,0.04724,0.03937,0.04724,0.04724,0.04724,0.05512,0.04724,0.06299,0.04724,0.07087,0.04724,0.07874,0.04724,0.08661,0.04724,0.09449,0.04724,0.10236,0.04724,0.11024,0.04724,0.11811,0.04724,0.12598,0.04724,0.13386,0.04724,0.14173,0.04724,0.14961,0.04724,0.15748,0.04724,0.16535,0.04724,0.17323,0.04724,0.1811,0.04724,0.18898,0.04724,0.19685,0.04724,0.20472,0.04724,0.2126,0.04724,0.22047,0.04724,0.22835,0.04724,0.23622,0.04724,0.24409,0.04724};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.25197,0.04724,0.25984,0.04724,0.26772,0.04724,0.27559,0.04724,0.28346,0.04724,0.29134,0.04724,0.29921,0.04724,0.30709,0.04724,0.31496,0.04724,0.32283,0.04724,0.33071,0.04724,0.33858,0.04724,0.34646,0.04724,0.35433,0.04724,0.3622,0.04724,0.37008,0.04724,0.37795,0.04724,0.38583,0.04724,0.3937,0.04724,0.40157,0.04724,0.40945,0.04724,0.41732,0.04724,0.4252,0.04724,0.43307,0.04724,0.44094,0.04724,0.44882,0.04724,0.45669,0.04724,0.46457,0.04724,0.47244,0.04724,0.48031,0.04724,0.48819,0.04724,0.49606,0.04724,0.50394,0.04724,0.51181,0.04724,0.51969,0.04724,0.52756,0.04724,0.53543,0.04724,0.54331,0.04724,0.55118,0.04724,0.55906,0.04724,0.56693,0.04724,0.5748,0.04724,0.58268,0.04724,0.59055,0.04724,0.59843,0.04724,0.6063,0.04724,0.61417,0.04724,0.62205,0.04724,0.62992,0.04724,0.6378,0.04724,0.64567,0.04724,0.65354,0.04724,0.66142,0.04724,0.66929,0.04724,0.67717,0.04724,0.68504,0.04724,0.69291,0.04724,0.70079,0.04724,0.70866,0.04724,0.71654,0.04724,0.72441,0.04724,0.73228,0.04724,0.74016,0.04724,0.74803,0.04724,0.75591,0.04724,0.76378,0.04724,0.77165,0.04724,0.77953,0.04724,0.7874,0.04724,0.79528,0.04724,0.80315,0.04724,0.81102,0.04724,0.8189,0.04724,0.82677,0.04724,0.83465,0.04724,0.84252,0.04724,0.85039,0.04724,0.85827,0.04724,0.86614,0.04724,0.87402,0.04724,0.88189,0.04724,0.88976,0.04724,0.89764,0.04724,0.90551,0.04724,0.91339,0.04724,0.92126,0.04724,0.92913,0.04724,0.93701,0.04724,0.94488,0.04724,0.95276,0.04724,0.96063,0.04724,0.9685,0.04724,0.97638,0.04724,0.98425,0.04724,0.99213,0.04724,0.99609,0.04724,0.00391,0.05512,0.00787,0.05512,0.01575,0.05512,0.02362,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.0315,0.05512,0.03937,0.05512,0.04724,0.05512,0.05512,0.05512,0.06299,0.05512,0.07087,0.05512,0.07874,0.05512,0.08661,0.05512,0.09449,0.05512,0.10236,0.05512,0.11024,0.05512,0.11811,0.05512,0.12598,0.05512,0.13386,0.05512,0.14173,0.05512,0.14961,0.05512,0.15748,0.05512,0.16535,0.05512,0.17323,0.05512,0.1811,0.05512,0.18898,0.05512,0.19685,0.05512,0.20472,0.05512,0.2126,0.05512,0.22047,0.05512,0.22835,0.05512,0.23622,0.05512,0.24409,0.05512,0.25197,0.05512,0.25984,0.05512,0.26772,0.05512,0.27559,0.05512,0.28346,0.05512,0.29134,0.05512,0.29921,0.05512,0.30709,0.05512,0.31496,0.05512,0.32283,0.05512,0.33071,0.05512,0.33858,0.05512,0.34646,0.05512,0.35433,0.05512,0.3622,0.05512,0.37008,0.05512,0.37795,0.05512,0.38583,0.05512,0.3937,0.05512,0.40157,0.05512,0.40945,0.05512,0.41732,0.05512,0.4252,0.05512,0.43307,0.05512,0.44094,0.05512,0.44882,0.05512,0.45669,0.05512,0.46457,0.05512,0.47244,0.05512,0.48031,0.05512,0.48819,0.05512,0.49606,0.05512,0.50394,0.05512,0.51181,0.05512,0.51969,0.05512,0.52756,0.05512,0.53543,0.05512,0.54331,0.05512,0.55118,0.05512,0.55906,0.05512,0.56693,0.05512,0.5748,0.05512,0.58268,0.05512,0.59055,0.05512,0.59843,0.05512,0.6063,0.05512,0.61417,0.05512,0.62205,0.05512,0.62992,0.05512,0.6378,0.05512,0.64567,0.05512,0.65354,0.05512,0.66142,0.05512,0.66929,0.05512,0.67717,0.05512,0.68504,0.05512,0.69291,0.05512,0.70079,0.05512,0.70866,0.05512,0.71654,0.05512,0.72441,0.05512,0.73228,0.05512,0.74016,0.05512,0.74803,0.05512,0.75591,0.05512,0.76378,0.05512,0.77165,0.05512,0.77953,0.05512,0.7874,0.05512,0.79528,0.05512,0.80315,0.05512,0.81102,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.8189,0.05512,0.82677,0.05512,0.83465,0.05512,0.84252,0.05512,0.85039,0.05512,0.85827,0.05512,0.86614,0.05512,0.87402,0.05512,0.88189,0.05512,0.88976,0.05512,0.89764,0.05512,0.90551,0.05512,0.91339,0.05512,0.92126,0.05512,0.92913,0.05512,0.93701,0.05512,0.94488,0.05512,0.95276,0.05512,0.96063,0.05512,0.9685,0.05512,0.97638,0.05512,0.98425,0.05512,0.99213,0.05512,0.99609,0.05512,0.00391,0.06299,0.00787,0.06299,0.01575,0.06299,0.02362,0.06299,0.0315,0.06299,0.03937,0.06299,0.04724,0.06299,0.05512,0.06299,0.06299,0.06299,0.07087,0.06299,0.07874,0.06299,0.08661,0.06299,0.09449,0.06299,0.10236,0.06299,0.11024,0.06299,0.11811,0.06299,0.12598,0.06299,0.13386,0.06299,0.14173,0.06299,0.14961,0.06299,0.15748,0.06299,0.16535,0.06299,0.17323,0.06299,0.1811,0.06299,0.18898,0.06299,0.19685,0.06299,0.20472,0.06299,0.2126,0.06299,0.22047,0.06299,0.22835,0.06299,0.23622,0.06299,0.24409,0.06299,0.25197,0.06299,0.25984,0.06299,0.26772,0.06299,0.27559,0.06299,0.28346,0.06299,0.29134,0.06299,0.29921,0.06299,0.30709,0.06299,0.31496,0.06299,0.32283,0.06299,0.33071,0.06299,0.33858,0.06299,0.34646,0.06299,0.35433,0.06299,0.3622,0.06299,0.37008,0.06299,0.37795,0.06299,0.38583,0.06299,0.3937,0.06299,0.40157,0.06299,0.40945,0.06299,0.41732,0.06299,0.4252,0.06299,0.43307,0.06299,0.44094,0.06299,0.44882,0.06299,0.45669,0.06299,0.46457,0.06299,0.47244,0.06299,0.48031,0.06299,0.48819,0.06299,0.49606,0.06299,0.50394,0.06299,0.51181,0.06299,0.51969,0.06299,0.52756,0.06299,0.53543,0.06299,0.54331,0.06299,0.55118,0.06299,0.55906,0.06299,0.56693,0.06299,0.5748,0.06299,0.58268,0.06299,0.59055,0.06299};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.59843,0.06299,0.6063,0.06299,0.61417,0.06299,0.62205,0.06299,0.62992,0.06299,0.6378,0.06299,0.64567,0.06299,0.65354,0.06299,0.66142,0.06299,0.66929,0.06299,0.67717,0.06299,0.68504,0.06299,0.69291,0.06299,0.70079,0.06299,0.70866,0.06299,0.71654,0.06299,0.72441,0.06299,0.73228,0.06299,0.74016,0.06299,0.74803,0.06299,0.75591,0.06299,0.76378,0.06299,0.77165,0.06299,0.77953,0.06299,0.7874,0.06299,0.79528,0.06299,0.80315,0.06299,0.81102,0.06299,0.8189,0.06299,0.82677,0.06299,0.83465,0.06299,0.84252,0.06299,0.85039,0.06299,0.85827,0.06299,0.86614,0.06299,0.87402,0.06299,0.88189,0.06299,0.88976,0.06299,0.89764,0.06299,0.90551,0.06299,0.91339,0.06299,0.92126,0.06299,0.92913,0.06299,0.93701,0.06299,0.94488,0.06299,0.95276,0.06299,0.96063,0.06299,0.9685,0.06299,0.97638,0.06299,0.98425,0.06299,0.99213,0.06299,0.99609,0.06299,0.00391,0.07087,0.00787,0.07087,0.01575,0.07087,0.02362,0.07087,0.0315,0.07087,0.03937,0.07087,0.04724,0.07087,0.05512,0.07087,0.06299,0.07087,0.07087,0.07087,0.07874,0.07087,0.08661,0.07087,0.09449,0.07087,0.10236,0.07087,0.11024,0.07087,0.11811,0.07087,0.12598,0.07087,0.13386,0.07087,0.14173,0.07087,0.14961,0.07087,0.15748,0.07087,0.16535,0.07087,0.17323,0.07087,0.1811,0.07087,0.18898,0.07087,0.19685,0.07087,0.20472,0.07087,0.2126,0.07087,0.22047,0.07087,0.22835,0.07087,0.23622,0.07087,0.24409,0.07087,0.25197,0.07087,0.25984,0.07087,0.26772,0.07087,0.27559,0.07087,0.28346,0.07087,0.29134,0.07087,0.29921,0.07087,0.30709,0.07087,0.31496,0.07087,0.32283,0.07087,0.33071,0.07087,0.33858,0.07087,0.34646,0.07087,0.35433,0.07087,0.3622,0.07087,0.37008,0.07087};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.37795,0.07087,0.38583,0.07087,0.3937,0.07087,0.40157,0.07087,0.40945,0.07087,0.41732,0.07087,0.4252,0.07087,0.43307,0.07087,0.44094,0.07087,0.44882,0.07087,0.45669,0.07087,0.46457,0.07087,0.47244,0.07087,0.48031,0.07087,0.48819,0.07087,0.49606,0.07087,0.50394,0.07087,0.51181,0.07087,0.51969,0.07087,0.52756,0.07087,0.53543,0.07087,0.54331,0.07087,0.55118,0.07087,0.55906,0.07087,0.56693,0.07087,0.5748,0.07087,0.58268,0.07087,0.59055,0.07087,0.59843,0.07087,0.6063,0.07087,0.61417,0.07087,0.62205,0.07087,0.62992,0.07087,0.6378,0.07087,0.64567,0.07087,0.65354,0.07087,0.66142,0.07087,0.66929,0.07087,0.67717,0.07087,0.68504,0.07087,0.69291,0.07087,0.70079,0.07087,0.70866,0.07087,0.71654,0.07087,0.72441,0.07087,0.73228,0.07087,0.74016,0.07087,0.74803,0.07087,0.75591,0.07087,0.76378,0.07087,0.77165,0.07087,0.77953,0.07087,0.7874,0.07087,0.79528,0.07087,0.80315,0.07087,0.81102,0.07087,0.8189,0.07087,0.82677,0.07087,0.83465,0.07087,0.84252,0.07087,0.85039,0.07087,0.85827,0.07087,0.86614,0.07087,0.87402,0.07087,0.88189,0.07087,0.88976,0.07087,0.89764,0.07087,0.90551,0.07087,0.91339,0.07087,0.92126,0.07087,0.92913,0.07087,0.93701,0.07087,0.94488,0.07087,0.95276,0.07087,0.96063,0.07087,0.9685,0.07087,0.97638,0.07087,0.98425,0.07087,0.99213,0.07087,0.99609,0.07087,0.00391,0.07874,0.00787,0.07874,0.01575,0.07874,0.02362,0.07874,0.0315,0.07874,0.03937,0.07874,0.04724,0.07874,0.05512,0.07874,0.06299,0.07874,0.07087,0.07874,0.07874,0.07874,0.08661,0.07874,0.09449,0.07874,0.10236,0.07874,0.11024,0.07874,0.11811,0.07874,0.12598,0.07874,0.13386,0.07874,0.14173,0.07874,0.14961,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.15748,0.07874,0.16535,0.07874,0.17323,0.07874,0.1811,0.07874,0.18898,0.07874,0.19685,0.07874,0.20472,0.07874,0.2126,0.07874,0.22047,0.07874,0.22835,0.07874,0.23622,0.07874,0.24409,0.07874,0.25197,0.07874,0.25984,0.07874,0.26772,0.07874,0.27559,0.07874,0.28346,0.07874,0.29134,0.07874,0.29921,0.07874,0.30709,0.07874,0.31496,0.07874,0.32283,0.07874,0.33071,0.07874,0.33858,0.07874,0.34646,0.07874,0.35433,0.07874,0.3622,0.07874,0.37008,0.07874,0.37795,0.07874,0.38583,0.07874,0.3937,0.07874,0.40157,0.07874,0.40945,0.07874,0.41732,0.07874,0.4252,0.07874,0.43307,0.07874,0.44094,0.07874,0.44882,0.07874,0.45669,0.07874,0.46457,0.07874,0.47244,0.07874,0.48031,0.07874,0.48819,0.07874,0.49606,0.07874,0.50394,0.07874,0.51181,0.07874,0.51969,0.07874,0.52756,0.07874,0.53543,0.07874,0.54331,0.07874,0.55118,0.07874,0.55906,0.07874,0.56693,0.07874,0.5748,0.07874,0.58268,0.07874,0.59055,0.07874,0.59843,0.07874,0.6063,0.07874,0.61417,0.07874,0.62205,0.07874,0.62992,0.07874,0.6378,0.07874,0.64567,0.07874,0.65354,0.07874,0.66142,0.07874,0.66929,0.07874,0.67717,0.07874,0.68504,0.07874,0.69291,0.07874,0.70079,0.07874,0.70866,0.07874,0.71654,0.07874,0.72441,0.07874,0.73228,0.07874,0.74016,0.07874,0.74803,0.07874,0.75591,0.07874,0.76378,0.07874,0.77165,0.07874,0.77953,0.07874,0.7874,0.07874,0.79528,0.07874,0.80315,0.07874,0.81102,0.07874,0.8189,0.07874,0.82677,0.07874,0.83465,0.07874,0.84252,0.07874,0.85039,0.07874,0.85827,0.07874,0.86614,0.07874,0.87402,0.07874,0.88189,0.07874,0.88976,0.07874,0.89764,0.07874,0.90551,0.07874,0.91339,0.07874,0.92126,0.07874,0.92913,0.07874,0.93701,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.94488,0.07874,0.95276,0.07874,0.96063,0.07874,0.9685,0.07874,0.97638,0.07874,0.98425,0.07874,0.99213,0.07874,0.99609,0.07874,0.00391,0.08661,0.00787,0.08661,0.01575,0.08661,0.02362,0.08661,0.0315,0.08661,0.03937,0.08661,0.04724,0.08661,0.05512,0.08661,0.06299,0.08661,0.07087,0.08661,0.07874,0.08661,0.08661,0.08661,0.09449,0.08661,0.10236,0.08661,0.11024,0.08661,0.11811,0.08661,0.12598,0.08661,0.13386,0.08661,0.14173,0.08661,0.14961,0.08661,0.15748,0.08661,0.16535,0.08661,0.17323,0.08661,0.1811,0.08661,0.18898,0.08661,0.19685,0.08661,0.20472,0.08661,0.2126,0.08661,0.22047,0.08661,0.22835,0.08661,0.23622,0.08661,0.24409,0.08661,0.25197,0.08661,0.25984,0.08661,0.26772,0.08661,0.27559,0.08661,0.28346,0.08661,0.29134,0.08661,0.29921,0.08661,0.30709,0.08661,0.31496,0.08661,0.32283,0.08661,0.33071,0.08661,0.33858,0.08661,0.34646,0.08661,0.35433,0.08661,0.3622,0.08661,0.37008,0.08661,0.37795,0.08661,0.38583,0.08661,0.3937,0.08661,0.40157,0.08661,0.40945,0.08661,0.41732,0.08661,0.4252,0.08661,0.43307,0.08661,0.44094,0.08661,0.44882,0.08661,0.45669,0.08661,0.46457,0.08661,0.47244,0.08661,0.48031,0.08661,0.48819,0.08661,0.49606,0.08661,0.50394,0.08661,0.51181,0.08661,0.51969,0.08661,0.52756,0.08661,0.53543,0.08661,0.54331,0.08661,0.55118,0.08661,0.55906,0.08661,0.56693,0.08661,0.5748,0.08661,0.58268,0.08661,0.59055,0.08661,0.59843,0.08661,0.6063,0.08661,0.61417,0.08661,0.62205,0.08661,0.62992,0.08661,0.6378,0.08661,0.64567,0.08661,0.65354,0.08661,0.66142,0.08661,0.66929,0.08661,0.67717,0.08661,0.68504,0.08661,0.69291,0.08661,0.70079,0.08661,0.70866,0.08661,0.71654,0.08661};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.72441,0.08661,0.73228,0.08661,0.74016,0.08661,0.74803,0.08661,0.75591,0.08661,0.76378,0.08661,0.77165,0.08661,0.77953,0.08661,0.7874,0.08661,0.79528,0.08661,0.80315,0.08661,0.81102,0.08661,0.8189,0.08661,0.82677,0.08661,0.83465,0.08661,0.84252,0.08661,0.85039,0.08661,0.85827,0.08661,0.86614,0.08661,0.87402,0.08661,0.88189,0.08661,0.88976,0.08661,0.89764,0.08661,0.90551,0.08661,0.91339,0.08661,0.92126,0.08661,0.92913,0.08661,0.93701,0.08661,0.94488,0.08661,0.95276,0.08661,0.96063,0.08661,0.9685,0.08661,0.97638,0.08661,0.98425,0.08661,0.99213,0.08661,0.99609,0.08661,0.00391,0.09449,0.00787,0.09449,0.01575,0.09449,0.02362,0.09449,0.0315,0.09449,0.03937,0.09449,0.04724,0.09449,0.05512,0.09449,0.06299,0.09449,0.07087,0.09449,0.07874,0.09449,0.08661,0.09449,0.09449,0.09449,0.10236,0.09449,0.11024,0.09449,0.11811,0.09449,0.12598,0.09449,0.13386,0.09449,0.14173,0.09449,0.14961,0.09449,0.15748,0.09449,0.16535,0.09449,0.17323,0.09449,0.1811,0.09449,0.18898,0.09449,0.19685,0.09449,0.20472,0.09449,0.2126,0.09449,0.22047,0.09449,0.22835,0.09449,0.23622,0.09449,0.24409,0.09449,0.25197,0.09449,0.25984,0.09449,0.26772,0.09449,0.27559,0.09449,0.28346,0.09449,0.29134,0.09449,0.29921,0.09449,0.30709,0.09449,0.31496,0.09449,0.32283,0.09449,0.33071,0.09449,0.33858,0.09449,0.34646,0.09449,0.35433,0.09449,0.3622,0.09449,0.37008,0.09449,0.37795,0.09449,0.38583,0.09449,0.3937,0.09449,0.40157,0.09449,0.40945,0.09449,0.41732,0.09449,0.4252,0.09449,0.43307,0.09449,0.44094,0.09449,0.44882,0.09449,0.45669,0.09449,0.46457,0.09449,0.47244,0.09449,0.48031,0.09449,0.48819,0.09449,0.49606,0.09449};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.50394,0.09449,0.51181,0.09449,0.51969,0.09449,0.52756,0.09449,0.53543,0.09449,0.54331,0.09449,0.55118,0.09449,0.55906,0.09449,0.56693,0.09449,0.5748,0.09449,0.58268,0.09449,0.59055,0.09449,0.59843,0.09449,0.6063,0.09449,0.61417,0.09449,0.62205,0.09449,0.62992,0.09449,0.6378,0.09449,0.64567,0.09449,0.65354,0.09449,0.66142,0.09449,0.66929,0.09449,0.67717,0.09449,0.68504,0.09449,0.69291,0.09449,0.70079,0.09449,0.70866,0.09449,0.71654,0.09449,0.72441,0.09449,0.73228,0.09449,0.74016,0.09449,0.74803,0.09449,0.75591,0.09449,0.76378,0.09449,0.77165,0.09449,0.77953,0.09449,0.7874,0.09449,0.79528,0.09449,0.80315,0.09449,0.81102,0.09449,0.8189,0.09449,0.82677,0.09449,0.83465,0.09449,0.84252,0.09449,0.85039,0.09449,0.85827,0.09449,0.86614,0.09449,0.87402,0.09449,0.88189,0.09449,0.88976,0.09449,0.89764,0.09449,0.90551,0.09449,0.91339,0.09449,0.92126,0.09449,0.92913,0.09449,0.93701,0.09449,0.94488,0.09449,0.95276,0.09449,0.96063,0.09449,0.9685,0.09449,0.97638,0.09449,0.98425,0.09449,0.99213,0.09449,0.99609,0.09449,0.00391,0.10236,0.00787,0.10236,0.01575,0.10236,0.02362,0.10236,0.0315,0.10236,0.03937,0.10236,0.04724,0.10236,0.05512,0.10236,0.06299,0.10236,0.07087,0.10236,0.07874,0.10236,0.08661,0.10236,0.09449,0.10236,0.10236,0.10236,0.11024,0.10236,0.11811,0.10236,0.12598,0.10236,0.13386,0.10236,0.14173,0.10236,0.14961,0.10236,0.15748,0.10236,0.16535,0.10236,0.17323,0.10236,0.1811,0.10236,0.18898,0.10236,0.19685,0.10236,0.20472,0.10236,0.2126,0.10236,0.22047,0.10236,0.22835,0.10236,0.23622,0.10236,0.24409,0.10236,0.25197,0.10236,0.25984,0.10236,0.26772,0.10236,0.27559,0.10236};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.28346,0.10236,0.29134,0.10236,0.29921,0.10236,0.30709,0.10236,0.31496,0.10236,0.32283,0.10236,0.33071,0.10236,0.33858,0.10236,0.34646,0.10236,0.35433,0.10236,0.3622,0.10236,0.37008,0.10236,0.37795,0.10236,0.38583,0.10236,0.3937,0.10236,0.40157,0.10236,0.40945,0.10236,0.41732,0.10236,0.4252,0.10236,0.43307,0.10236,0.44094,0.10236,0.44882,0.10236,0.45669,0.10236,0.46457,0.10236,0.47244,0.10236,0.48031,0.10236,0.48819,0.10236,0.49606,0.10236,0.50394,0.10236,0.51181,0.10236,0.51969,0.10236,0.52756,0.10236,0.53543,0.10236,0.54331,0.10236,0.55118,0.10236,0.55906,0.10236,0.56693,0.10236,0.5748,0.10236,0.58268,0.10236,0.59055,0.10236,0.59843,0.10236,0.6063,0.10236,0.61417,0.10236,0.62205,0.10236,0.62992,0.10236,0.6378,0.10236,0.64567,0.10236,0.65354,0.10236,0.66142,0.10236,0.66929,0.10236,0.67717,0.10236,0.68504,0.10236,0.69291,0.10236,0.70079,0.10236,0.70866,0.10236,0.71654,0.10236,0.72441,0.10236,0.73228,0.10236,0.74016,0.10236,0.74803,0.10236,0.75591,0.10236,0.76378,0.10236,0.77165,0.10236,0.77953,0.10236,0.7874,0.10236,0.79528,0.10236,0.80315,0.10236,0.81102,0.10236,0.8189,0.10236,0.82677,0.10236,0.83465,0.10236,0.84252,0.10236,0.85039,0.10236,0.85827,0.10236,0.86614,0.10236,0.87402,0.10236,0.88189,0.10236,0.88976,0.10236,0.89764,0.10236,0.90551,0.10236,0.91339,0.10236,0.92126,0.10236,0.92913,0.10236,0.93701,0.10236,0.94488,0.10236,0.95276,0.10236,0.96063,0.10236,0.9685,0.10236,0.97638,0.10236,0.98425,0.10236,0.99213,0.10236,0.99609,0.10236,0.00391,0.11024,0.00787,0.11024,0.01575,0.11024,0.02362,0.11024,0.0315,0.11024,0.03937,0.11024,0.04724,0.11024,0.05512,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.06299,0.11024,0.07087,0.11024,0.07874,0.11024,0.08661,0.11024,0.09449,0.11024,0.10236,0.11024,0.11024,0.11024,0.11811,0.11024,0.12598,0.11024,0.13386,0.11024,0.14173,0.11024,0.14961,0.11024,0.15748,0.11024,0.16535,0.11024,0.17323,0.11024,0.1811,0.11024,0.18898,0.11024,0.19685,0.11024,0.20472,0.11024,0.2126,0.11024,0.22047,0.11024,0.22835,0.11024,0.23622,0.11024,0.24409,0.11024,0.25197,0.11024,0.25984,0.11024,0.26772,0.11024,0.27559,0.11024,0.28346,0.11024,0.29134,0.11024,0.29921,0.11024,0.30709,0.11024,0.31496,0.11024,0.32283,0.11024,0.33071,0.11024,0.33858,0.11024,0.34646,0.11024,0.35433,0.11024,0.3622,0.11024,0.37008,0.11024,0.37795,0.11024,0.38583,0.11024,0.3937,0.11024,0.40157,0.11024,0.40945,0.11024,0.41732,0.11024,0.4252,0.11024,0.43307,0.11024,0.44094,0.11024,0.44882,0.11024,0.45669,0.11024,0.46457,0.11024,0.47244,0.11024,0.48031,0.11024,0.48819,0.11024,0.49606,0.11024,0.50394,0.11024,0.51181,0.11024,0.51969,0.11024,0.52756,0.11024,0.53543,0.11024,0.54331,0.11024,0.55118,0.11024,0.55906,0.11024,0.56693,0.11024,0.5748,0.11024,0.58268,0.11024,0.59055,0.11024,0.59843,0.11024,0.6063,0.11024,0.61417,0.11024,0.62205,0.11024,0.62992,0.11024,0.6378,0.11024,0.64567,0.11024,0.65354,0.11024,0.66142,0.11024,0.66929,0.11024,0.67717,0.11024,0.68504,0.11024,0.69291,0.11024,0.70079,0.11024,0.70866,0.11024,0.71654,0.11024,0.72441,0.11024,0.73228,0.11024,0.74016,0.11024,0.74803,0.11024,0.75591,0.11024,0.76378,0.11024,0.77165,0.11024,0.77953,0.11024,0.7874,0.11024,0.79528,0.11024,0.80315,0.11024,0.81102,0.11024,0.8189,0.11024,0.82677,0.11024,0.83465,0.11024,0.84252,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.85039,0.11024,0.85827,0.11024,0.86614,0.11024,0.87402,0.11024,0.88189,0.11024,0.88976,0.11024,0.89764,0.11024,0.90551,0.11024,0.91339,0.11024,0.92126,0.11024,0.92913,0.11024,0.93701,0.11024,0.94488,0.11024,0.95276,0.11024,0.96063,0.11024,0.9685,0.11024,0.97638,0.11024,0.98425,0.11024,0.99213,0.11024,0.99609,0.11024,0.00391,0.11811,0.00787,0.11811,0.01575,0.11811,0.02362,0.11811,0.0315,0.11811,0.03937,0.11811,0.04724,0.11811,0.05512,0.11811,0.06299,0.11811,0.07087,0.11811,0.07874,0.11811,0.08661,0.11811,0.09449,0.11811,0.10236,0.11811,0.11024,0.11811,0.11811,0.11811,0.12598,0.11811,0.13386,0.11811,0.14173,0.11811,0.14961,0.11811,0.15748,0.11811,0.16535,0.11811,0.17323,0.11811,0.1811,0.11811,0.18898,0.11811,0.19685,0.11811,0.20472,0.11811,0.2126,0.11811,0.22047,0.11811,0.22835,0.11811,0.23622,0.11811,0.24409,0.11811,0.25197,0.11811,0.25984,0.11811,0.26772,0.11811,0.27559,0.11811,0.28346,0.11811,0.29134,0.11811,0.29921,0.11811,0.30709,0.11811,0.31496,0.11811,0.32283,0.11811,0.33071,0.11811,0.33858,0.11811,0.34646,0.11811,0.35433,0.11811,0.3622,0.11811,0.37008,0.11811,0.37795,0.11811,0.38583,0.11811,0.3937,0.11811,0.40157,0.11811,0.40945,0.11811,0.41732,0.11811,0.4252,0.11811,0.43307,0.11811,0.44094,0.11811,0.44882,0.11811,0.45669,0.11811,0.46457,0.11811,0.47244,0.11811,0.48031,0.11811,0.48819,0.11811,0.49606,0.11811,0.50394,0.11811,0.51181,0.11811,0.51969,0.11811,0.52756,0.11811,0.53543,0.11811,0.54331,0.11811,0.55118,0.11811,0.55906,0.11811,0.56693,0.11811,0.5748,0.11811,0.58268,0.11811,0.59055,0.11811,0.59843,0.11811,0.6063,0.11811,0.61417,0.11811,0.62205,0.11811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.62992,0.11811,0.6378,0.11811,0.64567,0.11811,0.65354,0.11811,0.66142,0.11811,0.66929,0.11811,0.67717,0.11811,0.68504,0.11811,0.69291,0.11811,0.70079,0.11811,0.70866,0.11811,0.71654,0.11811,0.72441,0.11811,0.73228,0.11811,0.74016,0.11811,0.74803,0.11811,0.75591,0.11811,0.76378,0.11811,0.77165,0.11811,0.77953,0.11811,0.7874,0.11811,0.79528,0.11811,0.80315,0.11811,0.81102,0.11811,0.8189,0.11811,0.82677,0.11811,0.83465,0.11811,0.84252,0.11811,0.85039,0.11811,0.85827,0.11811,0.86614,0.11811,0.87402,0.11811,0.88189,0.11811,0.88976,0.11811,0.89764,0.11811,0.90551,0.11811,0.91339,0.11811,0.92126,0.11811,0.92913,0.11811,0.93701,0.11811,0.94488,0.11811,0.95276,0.11811,0.96063,0.11811,0.9685,0.11811,0.97638,0.11811,0.98425,0.11811,0.99213,0.11811,0.99609,0.11811,0.00391,0.12598,0.00787,0.12598,0.01575,0.12598,0.02362,0.12598,0.0315,0.12598,0.03937,0.12598,0.04724,0.12598,0.05512,0.12598,0.06299,0.12598,0.07087,0.12598,0.07874,0.12598,0.08661,0.12598,0.09449,0.12598,0.10236,0.12598,0.11024,0.12598,0.11811,0.12598,0.12598,0.12598,0.13386,0.12598,0.14173,0.12598,0.14961,0.12598,0.15748,0.12598,0.16535,0.12598,0.17323,0.12598,0.1811,0.12598,0.18898,0.12598,0.19685,0.12598,0.20472,0.12598,0.2126,0.12598,0.22047,0.12598,0.22835,0.12598,0.23622,0.12598,0.24409,0.12598,0.25197,0.12598,0.25984,0.12598,0.26772,0.12598,0.27559,0.12598,0.28346,0.12598,0.29134,0.12598,0.29921,0.12598,0.30709,0.12598,0.31496,0.12598,0.32283,0.12598,0.33071,0.12598,0.33858,0.12598,0.34646,0.12598,0.35433,0.12598,0.3622,0.12598,0.37008,0.12598,0.37795,0.12598,0.38583,0.12598,0.3937,0.12598,0.40157,0.12598};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.40945,0.12598,0.41732,0.12598,0.4252,0.12598,0.43307,0.12598,0.44094,0.12598,0.44882,0.12598,0.45669,0.12598,0.46457,0.12598,0.47244,0.12598,0.48031,0.12598,0.48819,0.12598,0.49606,0.12598,0.50394,0.12598,0.51181,0.12598,0.51969,0.12598,0.52756,0.12598,0.53543,0.12598,0.54331,0.12598,0.55118,0.12598,0.55906,0.12598,0.56693,0.12598,0.5748,0.12598,0.58268,0.12598,0.59055,0.12598,0.59843,0.12598,0.6063,0.12598,0.61417,0.12598,0.62205,0.12598,0.62992,0.12598,0.6378,0.12598,0.64567,0.12598,0.65354,0.12598,0.66142,0.12598,0.66929,0.12598,0.67717,0.12598,0.68504,0.12598,0.69291,0.12598,0.70079,0.12598,0.70866,0.12598,0.71654,0.12598,0.72441,0.12598,0.73228,0.12598,0.74016,0.12598,0.74803,0.12598,0.75591,0.12598,0.76378,0.12598,0.77165,0.12598,0.77953,0.12598,0.7874,0.12598,0.79528,0.12598,0.80315,0.12598,0.81102,0.12598,0.8189,0.12598,0.82677,0.12598,0.83465,0.12598,0.84252,0.12598,0.85039,0.12598,0.85827,0.12598,0.86614,0.12598,0.87402,0.12598,0.88189,0.12598,0.88976,0.12598,0.89764,0.12598,0.90551,0.12598,0.91339,0.12598,0.92126,0.12598,0.92913,0.12598,0.93701,0.12598,0.94488,0.12598,0.95276,0.12598,0.96063,0.12598,0.9685,0.12598,0.97638,0.12598,0.98425,0.12598,0.99213,0.12598,0.99609,0.12598,0.00391,0.13386,0.00787,0.13386,0.01575,0.13386,0.02362,0.13386,0.0315,0.13386,0.03937,0.13386,0.04724,0.13386,0.05512,0.13386,0.06299,0.13386,0.07087,0.13386,0.07874,0.13386,0.08661,0.13386,0.09449,0.13386,0.10236,0.13386,0.11024,0.13386,0.11811,0.13386,0.12598,0.13386,0.13386,0.13386,0.14173,0.13386,0.14961,0.13386,0.15748,0.13386,0.16535,0.13386,0.17323,0.13386,0.1811,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.18898,0.13386,0.19685,0.13386,0.20472,0.13386,0.2126,0.13386,0.22047,0.13386,0.22835,0.13386,0.23622,0.13386,0.24409,0.13386,0.25197,0.13386,0.25984,0.13386,0.26772,0.13386,0.27559,0.13386,0.28346,0.13386,0.29134,0.13386,0.29921,0.13386,0.30709,0.13386,0.31496,0.13386,0.32283,0.13386,0.33071,0.13386,0.33858,0.13386,0.34646,0.13386,0.35433,0.13386,0.3622,0.13386,0.37008,0.13386,0.37795,0.13386,0.38583,0.13386,0.3937,0.13386,0.40157,0.13386,0.40945,0.13386,0.41732,0.13386,0.4252,0.13386,0.43307,0.13386,0.44094,0.13386,0.44882,0.13386,0.45669,0.13386,0.46457,0.13386,0.47244,0.13386,0.48031,0.13386,0.48819,0.13386,0.49606,0.13386,0.50394,0.13386,0.51181,0.13386,0.51969,0.13386,0.52756,0.13386,0.53543,0.13386,0.54331,0.13386,0.55118,0.13386,0.55906,0.13386,0.56693,0.13386,0.5748,0.13386,0.58268,0.13386,0.59055,0.13386,0.59843,0.13386,0.6063,0.13386,0.61417,0.13386,0.62205,0.13386,0.62992,0.13386,0.6378,0.13386,0.64567,0.13386,0.65354,0.13386,0.66142,0.13386,0.66929,0.13386,0.67717,0.13386,0.68504,0.13386,0.69291,0.13386,0.70079,0.13386,0.70866,0.13386,0.71654,0.13386,0.72441,0.13386,0.73228,0.13386,0.74016,0.13386,0.74803,0.13386,0.75591,0.13386,0.76378,0.13386,0.77165,0.13386,0.77953,0.13386,0.7874,0.13386,0.79528,0.13386,0.80315,0.13386,0.81102,0.13386,0.8189,0.13386,0.82677,0.13386,0.83465,0.13386,0.84252,0.13386,0.85039,0.13386,0.85827,0.13386,0.86614,0.13386,0.87402,0.13386,0.88189,0.13386,0.88976,0.13386,0.89764,0.13386,0.90551,0.13386,0.91339,0.13386,0.92126,0.13386,0.92913,0.13386,0.93701,0.13386,0.94488,0.13386,0.95276,0.13386,0.96063,0.13386,0.9685,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.97638,0.13386,0.98425,0.13386,0.99213,0.13386,0.99609,0.13386,0.00391,0.14173,0.00787,0.14173,0.01575,0.14173,0.02362,0.14173,0.0315,0.14173,0.03937,0.14173,0.04724,0.14173,0.05512,0.14173,0.06299,0.14173,0.07087,0.14173,0.07874,0.14173,0.08661,0.14173,0.09449,0.14173,0.10236,0.14173,0.11024,0.14173,0.11811,0.14173,0.12598,0.14173,0.13386,0.14173,0.14173,0.14173,0.14961,0.14173,0.15748,0.14173,0.16535,0.14173,0.17323,0.14173,0.1811,0.14173,0.18898,0.14173,0.19685,0.14173,0.20472,0.14173,0.2126,0.14173,0.22047,0.14173,0.22835,0.14173,0.23622,0.14173,0.24409,0.14173,0.25197,0.14173,0.25984,0.14173,0.26772,0.14173,0.27559,0.14173,0.28346,0.14173,0.29134,0.14173,0.29921,0.14173,0.30709,0.14173,0.31496,0.14173,0.32283,0.14173,0.33071,0.14173,0.33858,0.14173,0.34646,0.14173,0.35433,0.14173,0.3622,0.14173,0.37008,0.14173,0.37795,0.14173,0.38583,0.14173,0.3937,0.14173,0.40157,0.14173,0.40945,0.14173,0.41732,0.14173,0.4252,0.14173,0.43307,0.14173,0.44094,0.14173,0.44882,0.14173,0.45669,0.14173,0.46457,0.14173,0.47244,0.14173,0.48031,0.14173,0.48819,0.14173,0.49606,0.14173,0.50394,0.14173,0.51181,0.14173,0.51969,0.14173,0.52756,0.14173,0.53543,0.14173,0.54331,0.14173,0.55118,0.14173,0.55906,0.14173,0.56693,0.14173,0.5748,0.14173,0.58268,0.14173,0.59055,0.14173,0.59843,0.14173,0.6063,0.14173,0.61417,0.14173,0.62205,0.14173,0.62992,0.14173,0.6378,0.14173,0.64567,0.14173,0.65354,0.14173,0.66142,0.14173,0.66929,0.14173,0.67717,0.14173,0.68504,0.14173,0.69291,0.14173,0.70079,0.14173,0.70866,0.14173,0.71654,0.14173,0.72441,0.14173,0.73228,0.14173,0.74016,0.14173,0.74803,0.14173};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.75591,0.14173,0.76378,0.14173,0.77165,0.14173,0.77953,0.14173,0.7874,0.14173,0.79528,0.14173,0.80315,0.14173,0.81102,0.14173,0.8189,0.14173,0.82677,0.14173,0.83465,0.14173,0.84252,0.14173,0.85039,0.14173,0.85827,0.14173,0.86614,0.14173,0.87402,0.14173,0.88189,0.14173,0.88976,0.14173,0.89764,0.14173,0.90551,0.14173,0.91339,0.14173,0.92126,0.14173,0.92913,0.14173,0.93701,0.14173,0.94488,0.14173,0.95276,0.14173,0.96063,0.14173,0.9685,0.14173,0.97638,0.14173,0.98425,0.14173,0.99213,0.14173,0.99609,0.14173,0.00391,0.14961,0.00787,0.14961,0.01575,0.14961,0.02362,0.14961,0.0315,0.14961,0.03937,0.14961,0.04724,0.14961,0.05512,0.14961,0.06299,0.14961,0.07087,0.14961,0.07874,0.14961,0.08661,0.14961,0.09449,0.14961,0.10236,0.14961,0.11024,0.14961,0.11811,0.14961,0.12598,0.14961,0.13386,0.14961,0.14173,0.14961,0.14961,0.14961,0.15748,0.14961,0.16535,0.14961,0.17323,0.14961,0.1811,0.14961,0.18898,0.14961,0.19685,0.14961,0.20472,0.14961,0.2126,0.14961,0.22047,0.14961,0.22835,0.14961,0.23622,0.14961,0.24409,0.14961,0.25197,0.14961,0.25984,0.14961,0.26772,0.14961,0.27559,0.14961,0.28346,0.14961,0.29134,0.14961,0.29921,0.14961,0.30709,0.14961,0.31496,0.14961,0.32283,0.14961,0.33071,0.14961,0.33858,0.14961,0.34646,0.14961,0.35433,0.14961,0.3622,0.14961,0.37008,0.14961,0.37795,0.14961,0.38583,0.14961,0.3937,0.14961,0.40157,0.14961,0.40945,0.14961,0.41732,0.14961,0.4252,0.14961,0.43307,0.14961,0.44094,0.14961,0.44882,0.14961,0.45669,0.14961,0.46457,0.14961,0.47244,0.14961,0.48031,0.14961,0.48819,0.14961,0.49606,0.14961,0.50394,0.14961,0.51181,0.14961,0.51969,0.14961,0.52756,0.14961};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.53543,0.14961,0.54331,0.14961,0.55118,0.14961,0.55906,0.14961,0.56693,0.14961,0.5748,0.14961,0.58268,0.14961,0.59055,0.14961,0.59843,0.14961,0.6063,0.14961,0.61417,0.14961,0.62205,0.14961,0.62992,0.14961,0.6378,0.14961,0.64567,0.14961,0.65354,0.14961,0.66142,0.14961,0.66929,0.14961,0.67717,0.14961,0.68504,0.14961,0.69291,0.14961,0.70079,0.14961,0.70866,0.14961,0.71654,0.14961,0.72441,0.14961,0.73228,0.14961,0.74016,0.14961,0.74803,0.14961,0.75591,0.14961,0.76378,0.14961,0.77165,0.14961,0.77953,0.14961,0.7874,0.14961,0.79528,0.14961,0.80315,0.14961,0.81102,0.14961,0.8189,0.14961,0.82677,0.14961,0.83465,0.14961,0.84252,0.14961,0.85039,0.14961,0.85827,0.14961,0.86614,0.14961,0.87402,0.14961,0.88189,0.14961,0.88976,0.14961,0.89764,0.14961,0.90551,0.14961,0.91339,0.14961,0.92126,0.14961,0.92913,0.14961,0.93701,0.14961,0.94488,0.14961,0.95276,0.14961,0.96063,0.14961,0.9685,0.14961,0.97638,0.14961,0.98425,0.14961,0.99213,0.14961,0.99609,0.14961,0.00391,0.15748,0.00787,0.15748,0.01575,0.15748,0.02362,0.15748,0.0315,0.15748,0.03937,0.15748,0.04724,0.15748,0.05512,0.15748,0.06299,0.15748,0.07087,0.15748,0.07874,0.15748,0.08661,0.15748,0.09449,0.15748,0.10236,0.15748,0.11024,0.15748,0.11811,0.15748,0.12598,0.15748,0.13386,0.15748,0.14173,0.15748,0.14961,0.15748,0.15748,0.15748,0.16535,0.15748,0.17323,0.15748,0.1811,0.15748,0.18898,0.15748,0.19685,0.15748,0.20472,0.15748,0.2126,0.15748,0.22047,0.15748,0.22835,0.15748,0.23622,0.15748,0.24409,0.15748,0.25197,0.15748,0.25984,0.15748,0.26772,0.15748,0.27559,0.15748,0.28346,0.15748,0.29134,0.15748,0.29921,0.15748,0.30709,0.15748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.31496,0.15748,0.32283,0.15748,0.33071,0.15748,0.33858,0.15748,0.34646,0.15748,0.35433,0.15748,0.3622,0.15748,0.37008,0.15748,0.37795,0.15748,0.38583,0.15748,0.3937,0.15748,0.40157,0.15748,0.40945,0.15748,0.41732,0.15748,0.4252,0.15748,0.43307,0.15748,0.44094,0.15748,0.44882,0.15748,0.45669,0.15748,0.46457,0.15748,0.47244,0.15748,0.48031,0.15748,0.48819,0.15748,0.49606,0.15748,0.50394,0.15748,0.51181,0.15748,0.51969,0.15748,0.52756,0.15748,0.53543,0.15748,0.54331,0.15748,0.55118,0.15748,0.55906,0.15748,0.56693,0.15748,0.5748,0.15748,0.58268,0.15748,0.59055,0.15748,0.59843,0.15748,0.6063,0.15748,0.61417,0.15748,0.62205,0.15748,0.62992,0.15748,0.6378,0.15748,0.64567,0.15748,0.65354,0.15748,0.66142,0.15748,0.66929,0.15748,0.67717,0.15748,0.68504,0.15748,0.69291,0.15748,0.70079,0.15748,0.70866,0.15748,0.71654,0.15748,0.72441,0.15748,0.73228,0.15748,0.74016,0.15748,0.74803,0.15748,0.75591,0.15748,0.76378,0.15748,0.77165,0.15748,0.77953,0.15748,0.7874,0.15748,0.79528,0.15748,0.80315,0.15748,0.81102,0.15748,0.8189,0.15748,0.82677,0.15748,0.83465,0.15748,0.84252,0.15748,0.85039,0.15748,0.85827,0.15748,0.86614,0.15748,0.87402,0.15748,0.88189,0.15748,0.88976,0.15748,0.89764,0.15748,0.90551,0.15748,0.91339,0.15748,0.92126,0.15748,0.92913,0.15748,0.93701,0.15748,0.94488,0.15748,0.95276,0.15748,0.96063,0.15748,0.9685,0.15748,0.97638,0.15748,0.98425,0.15748,0.99213,0.15748,0.99609,0.15748,0.00391,0.16535,0.00787,0.16535,0.01575,0.16535,0.02362,0.16535,0.0315,0.16535,0.03937,0.16535,0.04724,0.16535,0.05512,0.16535,0.06299,0.16535,0.07087,0.16535,0.07874,0.16535,0.08661,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.09449,0.16535,0.10236,0.16535,0.11024,0.16535,0.11811,0.16535,0.12598,0.16535,0.13386,0.16535,0.14173,0.16535,0.14961,0.16535,0.15748,0.16535,0.16535,0.16535,0.17323,0.16535,0.1811,0.16535,0.18898,0.16535,0.19685,0.16535,0.20472,0.16535,0.2126,0.16535,0.22047,0.16535,0.22835,0.16535,0.23622,0.16535,0.24409,0.16535,0.25197,0.16535,0.25984,0.16535,0.26772,0.16535,0.27559,0.16535,0.28346,0.16535,0.29134,0.16535,0.29921,0.16535,0.30709,0.16535,0.31496,0.16535,0.32283,0.16535,0.33071,0.16535,0.33858,0.16535,0.34646,0.16535,0.35433,0.16535,0.3622,0.16535,0.37008,0.16535,0.37795,0.16535,0.38583,0.16535,0.3937,0.16535,0.40157,0.16535,0.40945,0.16535,0.41732,0.16535,0.4252,0.16535,0.43307,0.16535,0.44094,0.16535,0.44882,0.16535,0.45669,0.16535,0.46457,0.16535,0.47244,0.16535,0.48031,0.16535,0.48819,0.16535,0.49606,0.16535,0.50394,0.16535,0.51181,0.16535,0.51969,0.16535,0.52756,0.16535,0.53543,0.16535,0.54331,0.16535,0.55118,0.16535,0.55906,0.16535,0.56693,0.16535,0.5748,0.16535,0.58268,0.16535,0.59055,0.16535,0.59843,0.16535,0.6063,0.16535,0.61417,0.16535,0.62205,0.16535,0.62992,0.16535,0.6378,0.16535,0.64567,0.16535,0.65354,0.16535,0.66142,0.16535,0.66929,0.16535,0.67717,0.16535,0.68504,0.16535,0.69291,0.16535,0.70079,0.16535,0.70866,0.16535,0.71654,0.16535,0.72441,0.16535,0.73228,0.16535,0.74016,0.16535,0.74803,0.16535,0.75591,0.16535,0.76378,0.16535,0.77165,0.16535,0.77953,0.16535,0.7874,0.16535,0.79528,0.16535,0.80315,0.16535,0.81102,0.16535,0.8189,0.16535,0.82677,0.16535,0.83465,0.16535,0.84252,0.16535,0.85039,0.16535,0.85827,0.16535,0.86614,0.16535,0.87402,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.88189,0.16535,0.88976,0.16535,0.89764,0.16535,0.90551,0.16535,0.91339,0.16535,0.92126,0.16535,0.92913,0.16535,0.93701,0.16535,0.94488,0.16535,0.95276,0.16535,0.96063,0.16535,0.9685,0.16535,0.97638,0.16535,0.98425,0.16535,0.99213,0.16535,0.99609,0.16535,0.00391,0.17323,0.00787,0.17323,0.01575,0.17323,0.02362,0.17323,0.0315,0.17323,0.03937,0.17323,0.04724,0.17323,0.05512,0.17323,0.06299,0.17323,0.07087,0.17323,0.07874,0.17323,0.08661,0.17323,0.09449,0.17323,0.10236,0.17323,0.11024,0.17323,0.11811,0.17323,0.12598,0.17323,0.13386,0.17323,0.14173,0.17323,0.14961,0.17323,0.15748,0.17323,0.16535,0.17323,0.17323,0.17323,0.1811,0.17323,0.18898,0.17323,0.19685,0.17323,0.20472,0.17323,0.2126,0.17323,0.22047,0.17323,0.22835,0.17323,0.23622,0.17323,0.24409,0.17323,0.25197,0.17323,0.25984,0.17323,0.26772,0.17323,0.27559,0.17323,0.28346,0.17323,0.29134,0.17323,0.29921,0.17323,0.30709,0.17323,0.31496,0.17323,0.32283,0.17323,0.33071,0.17323,0.33858,0.17323,0.34646,0.17323,0.35433,0.17323,0.3622,0.17323,0.37008,0.17323,0.37795,0.17323,0.38583,0.17323,0.3937,0.17323,0.40157,0.17323,0.40945,0.17323,0.41732,0.17323,0.4252,0.17323,0.43307,0.17323,0.44094,0.17323,0.44882,0.17323,0.45669,0.17323,0.46457,0.17323,0.47244,0.17323,0.48031,0.17323,0.48819,0.17323,0.49606,0.17323,0.50394,0.17323,0.51181,0.17323,0.51969,0.17323,0.52756,0.17323,0.53543,0.17323,0.54331,0.17323,0.55118,0.17323,0.55906,0.17323,0.56693,0.17323,0.5748,0.17323,0.58268,0.17323,0.59055,0.17323,0.59843,0.17323,0.6063,0.17323,0.61417,0.17323,0.62205,0.17323,0.62992,0.17323,0.6378,0.17323,0.64567,0.17323,0.65354,0.17323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.66142,0.17323,0.66929,0.17323,0.67717,0.17323,0.68504,0.17323,0.69291,0.17323,0.70079,0.17323,0.70866,0.17323,0.71654,0.17323,0.72441,0.17323,0.73228,0.17323,0.74016,0.17323,0.74803,0.17323,0.75591,0.17323,0.76378,0.17323,0.77165,0.17323,0.77953,0.17323,0.7874,0.17323,0.79528,0.17323,0.80315,0.17323,0.81102,0.17323,0.8189,0.17323,0.82677,0.17323,0.83465,0.17323,0.84252,0.17323,0.85039,0.17323,0.85827,0.17323,0.86614,0.17323,0.87402,0.17323,0.88189,0.17323,0.88976,0.17323,0.89764,0.17323,0.90551,0.17323,0.91339,0.17323,0.92126,0.17323,0.92913,0.17323,0.93701,0.17323,0.94488,0.17323,0.95276,0.17323,0.96063,0.17323,0.9685,0.17323,0.97638,0.17323,0.98425,0.17323,0.99213,0.17323,0.99609,0.17323,0.00391,0.1811,0.00787,0.1811,0.01575,0.1811,0.02362,0.1811,0.0315,0.1811,0.03937,0.1811,0.04724,0.1811,0.05512,0.1811,0.06299,0.1811,0.07087,0.1811,0.07874,0.1811,0.08661,0.1811,0.09449,0.1811,0.10236,0.1811,0.11024,0.1811,0.11811,0.1811,0.12598,0.1811,0.13386,0.1811,0.14173,0.1811,0.14961,0.1811,0.15748,0.1811,0.16535,0.1811,0.17323,0.1811,0.1811,0.1811,0.18898,0.1811,0.19685,0.1811,0.20472,0.1811,0.2126,0.1811,0.22047,0.1811,0.22835,0.1811,0.23622,0.1811,0.24409,0.1811,0.25197,0.1811,0.25984,0.1811,0.26772,0.1811,0.27559,0.1811,0.28346,0.1811,0.29134,0.1811,0.29921,0.1811,0.30709,0.1811,0.31496,0.1811,0.32283,0.1811,0.33071,0.1811,0.33858,0.1811,0.34646,0.1811,0.35433,0.1811,0.3622,0.1811,0.37008,0.1811,0.37795,0.1811,0.38583,0.1811,0.3937,0.1811,0.40157,0.1811,0.40945,0.1811,0.41732,0.1811,0.4252,0.1811,0.43307,0.1811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.44094,0.1811,0.44882,0.1811,0.45669,0.1811,0.46457,0.1811,0.47244,0.1811,0.48031,0.1811,0.48819,0.1811,0.49606,0.1811,0.50394,0.1811,0.51181,0.1811,0.51969,0.1811,0.52756,0.1811,0.53543,0.1811,0.54331,0.1811,0.55118,0.1811,0.55906,0.1811,0.56693,0.1811,0.5748,0.1811,0.58268,0.1811,0.59055,0.1811,0.59843,0.1811,0.6063,0.1811,0.61417,0.1811,0.62205,0.1811,0.62992,0.1811,0.6378,0.1811,0.64567,0.1811,0.65354,0.1811,0.66142,0.1811,0.66929,0.1811,0.67717,0.1811,0.68504,0.1811,0.69291,0.1811,0.70079,0.1811,0.70866,0.1811,0.71654,0.1811,0.72441,0.1811,0.73228,0.1811,0.74016,0.1811,0.74803,0.1811,0.75591,0.1811,0.76378,0.1811,0.77165,0.1811,0.77953,0.1811,0.7874,0.1811,0.79528,0.1811,0.80315,0.1811,0.81102,0.1811,0.8189,0.1811,0.82677,0.1811,0.83465,0.1811,0.84252,0.1811,0.85039,0.1811,0.85827,0.1811,0.86614,0.1811,0.87402,0.1811,0.88189,0.1811,0.88976,0.1811,0.89764,0.1811,0.90551,0.1811,0.91339,0.1811,0.92126,0.1811,0.92913,0.1811,0.93701,0.1811,0.94488,0.1811,0.95276,0.1811,0.96063,0.1811,0.9685,0.1811,0.97638,0.1811,0.98425,0.1811,0.99213,0.1811,0.99609,0.1811,0.00391,0.18898,0.00787,0.18898,0.01575,0.18898,0.02362,0.18898,0.0315,0.18898,0.03937,0.18898,0.04724,0.18898,0.05512,0.18898,0.06299,0.18898,0.07087,0.18898,0.07874,0.18898,0.08661,0.18898,0.09449,0.18898,0.10236,0.18898,0.11024,0.18898,0.11811,0.18898,0.12598,0.18898,0.13386,0.18898,0.14173,0.18898,0.14961,0.18898,0.15748,0.18898,0.16535,0.18898,0.17323,0.18898,0.1811,0.18898,0.18898,0.18898,0.19685,0.18898,0.20472,0.18898,0.2126,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.22047,0.18898,0.22835,0.18898,0.23622,0.18898,0.24409,0.18898,0.25197,0.18898,0.25984,0.18898,0.26772,0.18898,0.27559,0.18898,0.28346,0.18898,0.29134,0.18898,0.29921,0.18898,0.30709,0.18898,0.31496,0.18898,0.32283,0.18898,0.33071,0.18898,0.33858,0.18898,0.34646,0.18898,0.35433,0.18898,0.3622,0.18898,0.37008,0.18898,0.37795,0.18898,0.38583,0.18898,0.3937,0.18898,0.40157,0.18898,0.40945,0.18898,0.41732,0.18898,0.4252,0.18898,0.43307,0.18898,0.44094,0.18898,0.44882,0.18898,0.45669,0.18898,0.46457,0.18898,0.47244,0.18898,0.48031,0.18898,0.48819,0.18898,0.49606,0.18898,0.50394,0.18898,0.51181,0.18898,0.51969,0.18898,0.52756,0.18898,0.53543,0.18898,0.54331,0.18898,0.55118,0.18898,0.55906,0.18898,0.56693,0.18898,0.5748,0.18898,0.58268,0.18898,0.59055,0.18898,0.59843,0.18898,0.6063,0.18898,0.61417,0.18898,0.62205,0.18898,0.62992,0.18898,0.6378,0.18898,0.64567,0.18898,0.65354,0.18898,0.66142,0.18898,0.66929,0.18898,0.67717,0.18898,0.68504,0.18898,0.69291,0.18898,0.70079,0.18898,0.70866,0.18898,0.71654,0.18898,0.72441,0.18898,0.73228,0.18898,0.74016,0.18898,0.74803,0.18898,0.75591,0.18898,0.76378,0.18898,0.77165,0.18898,0.77953,0.18898,0.7874,0.18898,0.79528,0.18898,0.80315,0.18898,0.81102,0.18898,0.8189,0.18898,0.82677,0.18898,0.83465,0.18898,0.84252,0.18898,0.85039,0.18898,0.85827,0.18898,0.86614,0.18898,0.87402,0.18898,0.88189,0.18898,0.88976,0.18898,0.89764,0.18898,0.90551,0.18898,0.91339,0.18898,0.92126,0.18898,0.92913,0.18898,0.93701,0.18898,0.94488,0.18898,0.95276,0.18898,0.96063,0.18898,0.9685,0.18898,0.97638,0.18898,0.98425,0.18898,0.99213,0.18898,0.99609,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.19685,0.00787,0.19685,0.01575,0.19685,0.02362,0.19685,0.0315,0.19685,0.03937,0.19685,0.04724,0.19685,0.05512,0.19685,0.06299,0.19685,0.07087,0.19685,0.07874,0.19685,0.08661,0.19685,0.09449,0.19685,0.10236,0.19685,0.11024,0.19685,0.11811,0.19685,0.12598,0.19685,0.13386,0.19685,0.14173,0.19685,0.14961,0.19685,0.15748,0.19685,0.16535,0.19685,0.17323,0.19685,0.1811,0.19685,0.18898,0.19685,0.19685,0.19685,0.20472,0.19685,0.2126,0.19685,0.22047,0.19685,0.22835,0.19685,0.23622,0.19685,0.24409,0.19685,0.25197,0.19685,0.25984,0.19685,0.26772,0.19685,0.27559,0.19685,0.28346,0.19685,0.29134,0.19685,0.29921,0.19685,0.30709,0.19685,0.31496,0.19685,0.32283,0.19685,0.33071,0.19685,0.33858,0.19685,0.34646,0.19685,0.35433,0.19685,0.3622,0.19685,0.37008,0.19685,0.37795,0.19685,0.38583,0.19685,0.3937,0.19685,0.40157,0.19685,0.40945,0.19685,0.41732,0.19685,0.4252,0.19685,0.43307,0.19685,0.44094,0.19685,0.44882,0.19685,0.45669,0.19685,0.46457,0.19685,0.47244,0.19685,0.48031,0.19685,0.48819,0.19685,0.49606,0.19685,0.50394,0.19685,0.51181,0.19685,0.51969,0.19685,0.52756,0.19685,0.53543,0.19685,0.54331,0.19685,0.55118,0.19685,0.55906,0.19685,0.56693,0.19685,0.5748,0.19685,0.58268,0.19685,0.59055,0.19685,0.59843,0.19685,0.6063,0.19685,0.61417,0.19685,0.62205,0.19685,0.62992,0.19685,0.6378,0.19685,0.64567,0.19685,0.65354,0.19685,0.66142,0.19685,0.66929,0.19685,0.67717,0.19685,0.68504,0.19685,0.69291,0.19685,0.70079,0.19685,0.70866,0.19685,0.71654,0.19685,0.72441,0.19685,0.73228,0.19685,0.74016,0.19685,0.74803,0.19685,0.75591,0.19685,0.76378,0.19685,0.77165,0.19685,0.77953,0.19685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.7874,0.19685,0.79528,0.19685,0.80315,0.19685,0.81102,0.19685,0.8189,0.19685,0.82677,0.19685,0.83465,0.19685,0.84252,0.19685,0.85039,0.19685,0.85827,0.19685,0.86614,0.19685,0.87402,0.19685,0.88189,0.19685,0.88976,0.19685,0.89764,0.19685,0.90551,0.19685,0.91339,0.19685,0.92126,0.19685,0.92913,0.19685,0.93701,0.19685,0.94488,0.19685,0.95276,0.19685,0.96063,0.19685,0.9685,0.19685,0.97638,0.19685,0.98425,0.19685,0.99213,0.19685,0.99609,0.19685,0.00391,0.20472,0.00787,0.20472,0.01575,0.20472,0.02362,0.20472,0.0315,0.20472,0.03937,0.20472,0.04724,0.20472,0.05512,0.20472,0.06299,0.20472,0.07087,0.20472,0.07874,0.20472,0.08661,0.20472,0.09449,0.20472,0.10236,0.20472,0.11024,0.20472,0.11811,0.20472,0.12598,0.20472,0.13386,0.20472,0.14173,0.20472,0.14961,0.20472,0.15748,0.20472,0.16535,0.20472,0.17323,0.20472,0.1811,0.20472,0.18898,0.20472,0.19685,0.20472,0.20472,0.20472,0.2126,0.20472,0.22047,0.20472,0.22835,0.20472,0.23622,0.20472,0.24409,0.20472,0.25197,0.20472,0.25984,0.20472,0.26772,0.20472,0.27559,0.20472,0.28346,0.20472,0.29134,0.20472,0.29921,0.20472,0.30709,0.20472,0.31496,0.20472,0.32283,0.20472,0.33071,0.20472,0.33858,0.20472,0.34646,0.20472,0.35433,0.20472,0.3622,0.20472,0.37008,0.20472,0.37795,0.20472,0.38583,0.20472,0.3937,0.20472,0.40157,0.20472,0.40945,0.20472,0.41732,0.20472,0.4252,0.20472,0.43307,0.20472,0.44094,0.20472,0.44882,0.20472,0.45669,0.20472,0.46457,0.20472,0.47244,0.20472,0.48031,0.20472,0.48819,0.20472,0.49606,0.20472,0.50394,0.20472,0.51181,0.20472,0.51969,0.20472,0.52756,0.20472,0.53543,0.20472,0.54331,0.20472,0.55118,0.20472,0.55906,0.20472};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.56693,0.20472,0.5748,0.20472,0.58268,0.20472,0.59055,0.20472,0.59843,0.20472,0.6063,0.20472,0.61417,0.20472,0.62205,0.20472,0.62992,0.20472,0.6378,0.20472,0.64567,0.20472,0.65354,0.20472,0.66142,0.20472,0.66929,0.20472,0.67717,0.20472,0.68504,0.20472,0.69291,0.20472,0.70079,0.20472,0.70866,0.20472,0.71654,0.20472,0.72441,0.20472,0.73228,0.20472,0.74016,0.20472,0.74803,0.20472,0.75591,0.20472,0.76378,0.20472,0.77165,0.20472,0.77953,0.20472,0.7874,0.20472,0.79528,0.20472,0.80315,0.20472,0.81102,0.20472,0.8189,0.20472,0.82677,0.20472,0.83465,0.20472,0.84252,0.20472,0.85039,0.20472,0.85827,0.20472,0.86614,0.20472,0.87402,0.20472,0.88189,0.20472,0.88976,0.20472,0.89764,0.20472,0.90551,0.20472,0.91339,0.20472,0.92126,0.20472,0.92913,0.20472,0.93701,0.20472,0.94488,0.20472,0.95276,0.20472,0.96063,0.20472,0.9685,0.20472,0.97638,0.20472,0.98425,0.20472,0.99213,0.20472,0.99609,0.20472,0.00391,0.2126,0.00787,0.2126,0.01575,0.2126,0.02362,0.2126,0.0315,0.2126,0.03937,0.2126,0.04724,0.2126,0.05512,0.2126,0.06299,0.2126,0.07087,0.2126,0.07874,0.2126,0.08661,0.2126,0.09449,0.2126,0.10236,0.2126,0.11024,0.2126,0.11811,0.2126,0.12598,0.2126,0.13386,0.2126,0.14173,0.2126,0.14961,0.2126,0.15748,0.2126,0.16535,0.2126,0.17323,0.2126,0.1811,0.2126,0.18898,0.2126,0.19685,0.2126,0.20472,0.2126,0.2126,0.2126,0.22047,0.2126,0.22835,0.2126,0.23622,0.2126,0.24409,0.2126,0.25197,0.2126,0.25984,0.2126,0.26772,0.2126,0.27559,0.2126,0.28346,0.2126,0.29134,0.2126,0.29921,0.2126,0.30709,0.2126,0.31496,0.2126,0.32283,0.2126,0.33071,0.2126,0.33858,0.2126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.34646,0.2126,0.35433,0.2126,0.3622,0.2126,0.37008,0.2126,0.37795,0.2126,0.38583,0.2126,0.3937,0.2126,0.40157,0.2126,0.40945,0.2126,0.41732,0.2126,0.4252,0.2126,0.43307,0.2126,0.44094,0.2126,0.44882,0.2126,0.45669,0.2126,0.46457,0.2126,0.47244,0.2126,0.48031,0.2126,0.48819,0.2126,0.49606,0.2126,0.50394,0.2126,0.51181,0.2126,0.51969,0.2126,0.52756,0.2126,0.53543,0.2126,0.54331,0.2126,0.55118,0.2126,0.55906,0.2126,0.56693,0.2126,0.5748,0.2126,0.58268,0.2126,0.59055,0.2126,0.59843,0.2126,0.6063,0.2126,0.61417,0.2126,0.62205,0.2126,0.62992,0.2126,0.6378,0.2126,0.64567,0.2126,0.65354,0.2126,0.66142,0.2126,0.66929,0.2126,0.67717,0.2126,0.68504,0.2126,0.69291,0.2126,0.70079,0.2126,0.70866,0.2126,0.71654,0.2126,0.72441,0.2126,0.73228,0.2126,0.74016,0.2126,0.74803,0.2126,0.75591,0.2126,0.76378,0.2126,0.77165,0.2126,0.77953,0.2126,0.7874,0.2126,0.79528,0.2126,0.80315,0.2126,0.81102,0.2126,0.8189,0.2126,0.82677,0.2126,0.83465,0.2126,0.84252,0.2126,0.85039,0.2126,0.85827,0.2126,0.86614,0.2126,0.87402,0.2126,0.88189,0.2126,0.88976,0.2126,0.89764,0.2126,0.90551,0.2126,0.91339,0.2126,0.92126,0.2126,0.92913,0.2126,0.93701,0.2126,0.94488,0.2126,0.95276,0.2126,0.96063,0.2126,0.9685,0.2126,0.97638,0.2126,0.98425,0.2126,0.99213,0.2126,0.99609,0.2126,0.00391,0.22047,0.00787,0.22047,0.01575,0.22047,0.02362,0.22047,0.0315,0.22047,0.03937,0.22047,0.04724,0.22047,0.05512,0.22047,0.06299,0.22047,0.07087,0.22047,0.07874,0.22047,0.08661,0.22047,0.09449,0.22047,0.10236,0.22047,0.11024,0.22047,0.11811,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.12598,0.22047,0.13386,0.22047,0.14173,0.22047,0.14961,0.22047,0.15748,0.22047,0.16535,0.22047,0.17323,0.22047,0.1811,0.22047,0.18898,0.22047,0.19685,0.22047,0.20472,0.22047,0.2126,0.22047,0.22047,0.22047,0.22835,0.22047,0.23622,0.22047,0.24409,0.22047,0.25197,0.22047,0.25984,0.22047,0.26772,0.22047,0.27559,0.22047,0.28346,0.22047,0.29134,0.22047,0.29921,0.22047,0.30709,0.22047,0.31496,0.22047,0.32283,0.22047,0.33071,0.22047,0.33858,0.22047,0.34646,0.22047,0.35433,0.22047,0.3622,0.22047,0.37008,0.22047,0.37795,0.22047,0.38583,0.22047,0.3937,0.22047,0.40157,0.22047,0.40945,0.22047,0.41732,0.22047,0.4252,0.22047,0.43307,0.22047,0.44094,0.22047,0.44882,0.22047,0.45669,0.22047,0.46457,0.22047,0.47244,0.22047,0.48031,0.22047,0.48819,0.22047,0.49606,0.22047,0.50394,0.22047,0.51181,0.22047,0.51969,0.22047,0.52756,0.22047,0.53543,0.22047,0.54331,0.22047,0.55118,0.22047,0.55906,0.22047,0.56693,0.22047,0.5748,0.22047,0.58268,0.22047,0.59055,0.22047,0.59843,0.22047,0.6063,0.22047,0.61417,0.22047,0.62205,0.22047,0.62992,0.22047,0.6378,0.22047,0.64567,0.22047,0.65354,0.22047,0.66142,0.22047,0.66929,0.22047,0.67717,0.22047,0.68504,0.22047,0.69291,0.22047,0.70079,0.22047,0.70866,0.22047,0.71654,0.22047,0.72441,0.22047,0.73228,0.22047,0.74016,0.22047,0.74803,0.22047,0.75591,0.22047,0.76378,0.22047,0.77165,0.22047,0.77953,0.22047,0.7874,0.22047,0.79528,0.22047,0.80315,0.22047,0.81102,0.22047,0.8189,0.22047,0.82677,0.22047,0.83465,0.22047,0.84252,0.22047,0.85039,0.22047,0.85827,0.22047,0.86614,0.22047,0.87402,0.22047,0.88189,0.22047,0.88976,0.22047,0.89764,0.22047,0.90551,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.91339,0.22047,0.92126,0.22047,0.92913,0.22047,0.93701,0.22047,0.94488,0.22047,0.95276,0.22047,0.96063,0.22047,0.9685,0.22047,0.97638,0.22047,0.98425,0.22047,0.99213,0.22047,0.99609,0.22047,0.00391,0.22835,0.00787,0.22835,0.01575,0.22835,0.02362,0.22835,0.0315,0.22835,0.03937,0.22835,0.04724,0.22835,0.05512,0.22835,0.06299,0.22835,0.07087,0.22835,0.07874,0.22835,0.08661,0.22835,0.09449,0.22835,0.10236,0.22835,0.11024,0.22835,0.11811,0.22835,0.12598,0.22835,0.13386,0.22835,0.14173,0.22835,0.14961,0.22835,0.15748,0.22835,0.16535,0.22835,0.17323,0.22835,0.1811,0.22835,0.18898,0.22835,0.19685,0.22835,0.20472,0.22835,0.2126,0.22835,0.22047,0.22835,0.22835,0.22835,0.23622,0.22835,0.24409,0.22835,0.25197,0.22835,0.25984,0.22835,0.26772,0.22835,0.27559,0.22835,0.28346,0.22835,0.29134,0.22835,0.29921,0.22835,0.30709,0.22835,0.31496,0.22835,0.32283,0.22835,0.33071,0.22835,0.33858,0.22835,0.34646,0.22835,0.35433,0.22835,0.3622,0.22835,0.37008,0.22835,0.37795,0.22835,0.38583,0.22835,0.3937,0.22835,0.40157,0.22835,0.40945,0.22835,0.41732,0.22835,0.4252,0.22835,0.43307,0.22835,0.44094,0.22835,0.44882,0.22835,0.45669,0.22835,0.46457,0.22835,0.47244,0.22835,0.48031,0.22835,0.48819,0.22835,0.49606,0.22835,0.50394,0.22835,0.51181,0.22835,0.51969,0.22835,0.52756,0.22835,0.53543,0.22835,0.54331,0.22835,0.55118,0.22835,0.55906,0.22835,0.56693,0.22835,0.5748,0.22835,0.58268,0.22835,0.59055,0.22835,0.59843,0.22835,0.6063,0.22835,0.61417,0.22835,0.62205,0.22835,0.62992,0.22835,0.6378,0.22835,0.64567,0.22835,0.65354,0.22835,0.66142,0.22835,0.66929,0.22835,0.67717,0.22835,0.68504,0.22835};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.69291,0.22835,0.70079,0.22835,0.70866,0.22835,0.71654,0.22835,0.72441,0.22835,0.73228,0.22835,0.74016,0.22835,0.74803,0.22835,0.75591,0.22835,0.76378,0.22835,0.77165,0.22835,0.77953,0.22835,0.7874,0.22835,0.79528,0.22835,0.80315,0.22835,0.81102,0.22835,0.8189,0.22835,0.82677,0.22835,0.83465,0.22835,0.84252,0.22835,0.85039,0.22835,0.85827,0.22835,0.86614,0.22835,0.87402,0.22835,0.88189,0.22835,0.88976,0.22835,0.89764,0.22835,0.90551,0.22835,0.91339,0.22835,0.92126,0.22835,0.92913,0.22835,0.93701,0.22835,0.94488,0.22835,0.95276,0.22835,0.96063,0.22835,0.9685,0.22835,0.97638,0.22835,0.98425,0.22835,0.99213,0.22835,0.99609,0.22835,0.00391,0.23622,0.00787,0.23622,0.01575,0.23622,0.02362,0.23622,0.0315,0.23622,0.03937,0.23622,0.04724,0.23622,0.05512,0.23622,0.06299,0.23622,0.07087,0.23622,0.07874,0.23622,0.08661,0.23622,0.09449,0.23622,0.10236,0.23622,0.11024,0.23622,0.11811,0.23622,0.12598,0.23622,0.13386,0.23622,0.14173,0.23622,0.14961,0.23622,0.15748,0.23622,0.16535,0.23622,0.17323,0.23622,0.1811,0.23622,0.18898,0.23622,0.19685,0.23622,0.20472,0.23622,0.2126,0.23622,0.22047,0.23622,0.22835,0.23622,0.23622,0.23622,0.24409,0.23622,0.25197,0.23622,0.25984,0.23622,0.26772,0.23622,0.27559,0.23622,0.28346,0.23622,0.29134,0.23622,0.29921,0.23622,0.30709,0.23622,0.31496,0.23622,0.32283,0.23622,0.33071,0.23622,0.33858,0.23622,0.34646,0.23622,0.35433,0.23622,0.3622,0.23622,0.37008,0.23622,0.37795,0.23622,0.38583,0.23622,0.3937,0.23622,0.40157,0.23622,0.40945,0.23622,0.41732,0.23622,0.4252,0.23622,0.43307,0.23622,0.44094,0.23622,0.44882,0.23622,0.45669,0.23622,0.46457,0.23622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.47244,0.23622,0.48031,0.23622,0.48819,0.23622,0.49606,0.23622,0.50394,0.23622,0.51181,0.23622,0.51969,0.23622,0.52756,0.23622,0.53543,0.23622,0.54331,0.23622,0.55118,0.23622,0.55906,0.23622,0.56693,0.23622,0.5748,0.23622,0.58268,0.23622,0.59055,0.23622,0.59843,0.23622,0.6063,0.23622,0.61417,0.23622,0.62205,0.23622,0.62992,0.23622,0.6378,0.23622,0.64567,0.23622,0.65354,0.23622,0.66142,0.23622,0.66929,0.23622,0.67717,0.23622,0.68504,0.23622,0.69291,0.23622,0.70079,0.23622,0.70866,0.23622,0.71654,0.23622,0.72441,0.23622,0.73228,0.23622,0.74016,0.23622,0.74803,0.23622,0.75591,0.23622,0.76378,0.23622,0.77165,0.23622,0.77953,0.23622,0.7874,0.23622,0.79528,0.23622,0.80315,0.23622,0.81102,0.23622,0.8189,0.23622,0.82677,0.23622,0.83465,0.23622,0.84252,0.23622,0.85039,0.23622,0.85827,0.23622,0.86614,0.23622,0.87402,0.23622,0.88189,0.23622,0.88976,0.23622,0.89764,0.23622,0.90551,0.23622,0.91339,0.23622,0.92126,0.23622,0.92913,0.23622,0.93701,0.23622,0.94488,0.23622,0.95276,0.23622,0.96063,0.23622,0.9685,0.23622,0.97638,0.23622,0.98425,0.23622,0.99213,0.23622,0.99609,0.23622,0.00391,0.24409,0.00787,0.24409,0.01575,0.24409,0.02362,0.24409,0.0315,0.24409,0.03937,0.24409,0.04724,0.24409,0.05512,0.24409,0.06299,0.24409,0.07087,0.24409,0.07874,0.24409,0.08661,0.24409,0.09449,0.24409,0.10236,0.24409,0.11024,0.24409,0.11811,0.24409,0.12598,0.24409,0.13386,0.24409,0.14173,0.24409,0.14961,0.24409,0.15748,0.24409,0.16535,0.24409,0.17323,0.24409,0.1811,0.24409,0.18898,0.24409,0.19685,0.24409,0.20472,0.24409,0.2126,0.24409,0.22047,0.24409,0.22835,0.24409,0.23622,0.24409,0.24409,0.24409};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.25197,0.24409,0.25984,0.24409,0.26772,0.24409,0.27559,0.24409,0.28346,0.24409,0.29134,0.24409,0.29921,0.24409,0.30709,0.24409,0.31496,0.24409,0.32283,0.24409,0.33071,0.24409,0.33858,0.24409,0.34646,0.24409,0.35433,0.24409,0.3622,0.24409,0.37008,0.24409,0.37795,0.24409,0.38583,0.24409,0.3937,0.24409,0.40157,0.24409,0.40945,0.24409,0.41732,0.24409,0.4252,0.24409,0.43307,0.24409,0.44094,0.24409,0.44882,0.24409,0.45669,0.24409,0.46457,0.24409,0.47244,0.24409,0.48031,0.24409,0.48819,0.24409,0.49606,0.24409,0.50394,0.24409,0.51181,0.24409,0.51969,0.24409,0.52756,0.24409,0.53543,0.24409,0.54331,0.24409,0.55118,0.24409,0.55906,0.24409,0.56693,0.24409,0.5748,0.24409,0.58268,0.24409,0.59055,0.24409,0.59843,0.24409,0.6063,0.24409,0.61417,0.24409,0.62205,0.24409,0.62992,0.24409,0.6378,0.24409,0.64567,0.24409,0.65354,0.24409,0.66142,0.24409,0.66929,0.24409,0.67717,0.24409,0.68504,0.24409,0.69291,0.24409,0.70079,0.24409,0.70866,0.24409,0.71654,0.24409,0.72441,0.24409,0.73228,0.24409,0.74016,0.24409,0.74803,0.24409,0.75591,0.24409,0.76378,0.24409,0.77165,0.24409,0.77953,0.24409,0.7874,0.24409,0.79528,0.24409,0.80315,0.24409,0.81102,0.24409,0.8189,0.24409,0.82677,0.24409,0.83465,0.24409,0.84252,0.24409,0.85039,0.24409,0.85827,0.24409,0.86614,0.24409,0.87402,0.24409,0.88189,0.24409,0.88976,0.24409,0.89764,0.24409,0.90551,0.24409,0.91339,0.24409,0.92126,0.24409,0.92913,0.24409,0.93701,0.24409,0.94488,0.24409,0.95276,0.24409,0.96063,0.24409,0.9685,0.24409,0.97638,0.24409,0.98425,0.24409,0.99213,0.24409,0.99609,0.24409,0.00391,0.25197,0.00787,0.25197,0.01575,0.25197,0.02362,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_42()
		{
			double[] value = {0.0315,0.25197,0.03937,0.25197,0.04724,0.25197,0.05512,0.25197,0.06299,0.25197,0.07087,0.25197,0.07874,0.25197,0.08661,0.25197,0.09449,0.25197,0.10236,0.25197,0.11024,0.25197,0.11811,0.25197,0.12598,0.25197,0.13386,0.25197,0.14173,0.25197,0.14961,0.25197,0.15748,0.25197,0.16535,0.25197,0.17323,0.25197,0.1811,0.25197,0.18898,0.25197,0.19685,0.25197,0.20472,0.25197,0.2126,0.25197,0.22047,0.25197,0.22835,0.25197,0.23622,0.25197,0.24409,0.25197,0.25197,0.25197,0.25984,0.25197,0.26772,0.25197,0.27559,0.25197,0.28346,0.25197,0.29134,0.25197,0.29921,0.25197,0.30709,0.25197,0.31496,0.25197,0.32283,0.25197,0.33071,0.25197,0.33858,0.25197,0.34646,0.25197,0.35433,0.25197,0.3622,0.25197,0.37008,0.25197,0.37795,0.25197,0.38583,0.25197,0.3937,0.25197,0.40157,0.25197,0.40945,0.25197,0.41732,0.25197,0.4252,0.25197,0.43307,0.25197,0.44094,0.25197,0.44882,0.25197,0.45669,0.25197,0.46457,0.25197,0.47244,0.25197,0.48031,0.25197,0.48819,0.25197,0.49606,0.25197,0.50394,0.25197,0.51181,0.25197,0.51969,0.25197,0.52756,0.25197,0.53543,0.25197,0.54331,0.25197,0.55118,0.25197,0.55906,0.25197,0.56693,0.25197,0.5748,0.25197,0.58268,0.25197,0.59055,0.25197,0.59843,0.25197,0.6063,0.25197,0.61417,0.25197,0.62205,0.25197,0.62992,0.25197,0.6378,0.25197,0.64567,0.25197,0.65354,0.25197,0.66142,0.25197,0.66929,0.25197,0.67717,0.25197,0.68504,0.25197,0.69291,0.25197,0.70079,0.25197,0.70866,0.25197,0.71654,0.25197,0.72441,0.25197,0.73228,0.25197,0.74016,0.25197,0.74803,0.25197,0.75591,0.25197,0.76378,0.25197,0.77165,0.25197,0.77953,0.25197,0.7874,0.25197,0.79528,0.25197,0.80315,0.25197,0.81102,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_43()
		{
			double[] value = {0.8189,0.25197,0.82677,0.25197,0.83465,0.25197,0.84252,0.25197,0.85039,0.25197,0.85827,0.25197,0.86614,0.25197,0.87402,0.25197,0.88189,0.25197,0.88976,0.25197,0.89764,0.25197,0.90551,0.25197,0.91339,0.25197,0.92126,0.25197,0.92913,0.25197,0.93701,0.25197,0.94488,0.25197,0.95276,0.25197,0.96063,0.25197,0.9685,0.25197,0.97638,0.25197,0.98425,0.25197,0.99213,0.25197,0.99609,0.25197,0.00391,0.25984,0.00787,0.25984,0.01575,0.25984,0.02362,0.25984,0.0315,0.25984,0.03937,0.25984,0.04724,0.25984,0.05512,0.25984,0.06299,0.25984,0.07087,0.25984,0.07874,0.25984,0.08661,0.25984,0.09449,0.25984,0.10236,0.25984,0.11024,0.25984,0.11811,0.25984,0.12598,0.25984,0.13386,0.25984,0.14173,0.25984,0.14961,0.25984,0.15748,0.25984,0.16535,0.25984,0.17323,0.25984,0.1811,0.25984,0.18898,0.25984,0.19685,0.25984,0.20472,0.25984,0.2126,0.25984,0.22047,0.25984,0.22835,0.25984,0.23622,0.25984,0.24409,0.25984,0.25197,0.25984,0.25984,0.25984,0.26772,0.25984,0.27559,0.25984,0.28346,0.25984,0.29134,0.25984,0.29921,0.25984,0.30709,0.25984,0.31496,0.25984,0.32283,0.25984,0.33071,0.25984,0.33858,0.25984,0.34646,0.25984,0.35433,0.25984,0.3622,0.25984,0.37008,0.25984,0.37795,0.25984,0.38583,0.25984,0.3937,0.25984,0.40157,0.25984,0.40945,0.25984,0.41732,0.25984,0.4252,0.25984,0.43307,0.25984,0.44094,0.25984,0.44882,0.25984,0.45669,0.25984,0.46457,0.25984,0.47244,0.25984,0.48031,0.25984,0.48819,0.25984,0.49606,0.25984,0.50394,0.25984,0.51181,0.25984,0.51969,0.25984,0.52756,0.25984,0.53543,0.25984,0.54331,0.25984,0.55118,0.25984,0.55906,0.25984,0.56693,0.25984,0.5748,0.25984,0.58268,0.25984,0.59055,0.25984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_44()
		{
			double[] value = {0.59843,0.25984,0.6063,0.25984,0.61417,0.25984,0.62205,0.25984,0.62992,0.25984,0.6378,0.25984,0.64567,0.25984,0.65354,0.25984,0.66142,0.25984,0.66929,0.25984,0.67717,0.25984,0.68504,0.25984,0.69291,0.25984,0.70079,0.25984,0.70866,0.25984,0.71654,0.25984,0.72441,0.25984,0.73228,0.25984,0.74016,0.25984,0.74803,0.25984,0.75591,0.25984,0.76378,0.25984,0.77165,0.25984,0.77953,0.25984,0.7874,0.25984,0.79528,0.25984,0.80315,0.25984,0.81102,0.25984,0.8189,0.25984,0.82677,0.25984,0.83465,0.25984,0.84252,0.25984,0.85039,0.25984,0.85827,0.25984,0.86614,0.25984,0.87402,0.25984,0.88189,0.25984,0.88976,0.25984,0.89764,0.25984,0.90551,0.25984,0.91339,0.25984,0.92126,0.25984,0.92913,0.25984,0.93701,0.25984,0.94488,0.25984,0.95276,0.25984,0.96063,0.25984,0.9685,0.25984,0.97638,0.25984,0.98425,0.25984,0.99213,0.25984,0.99609,0.25984,0.00391,0.26772,0.00787,0.26772,0.01575,0.26772,0.02362,0.26772,0.0315,0.26772,0.03937,0.26772,0.04724,0.26772,0.05512,0.26772,0.06299,0.26772,0.07087,0.26772,0.07874,0.26772,0.08661,0.26772,0.09449,0.26772,0.10236,0.26772,0.11024,0.26772,0.11811,0.26772,0.12598,0.26772,0.13386,0.26772,0.14173,0.26772,0.14961,0.26772,0.15748,0.26772,0.16535,0.26772,0.17323,0.26772,0.1811,0.26772,0.18898,0.26772,0.19685,0.26772,0.20472,0.26772,0.2126,0.26772,0.22047,0.26772,0.22835,0.26772,0.23622,0.26772,0.24409,0.26772,0.25197,0.26772,0.25984,0.26772,0.26772,0.26772,0.27559,0.26772,0.28346,0.26772,0.29134,0.26772,0.29921,0.26772,0.30709,0.26772,0.31496,0.26772,0.32283,0.26772,0.33071,0.26772,0.33858,0.26772,0.34646,0.26772,0.35433,0.26772,0.3622,0.26772,0.37008,0.26772};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_45()
		{
			double[] value = {0.37795,0.26772,0.38583,0.26772,0.3937,0.26772,0.40157,0.26772,0.40945,0.26772,0.41732,0.26772,0.4252,0.26772,0.43307,0.26772,0.44094,0.26772,0.44882,0.26772,0.45669,0.26772,0.46457,0.26772,0.47244,0.26772,0.48031,0.26772,0.48819,0.26772,0.49606,0.26772,0.50394,0.26772,0.51181,0.26772,0.51969,0.26772,0.52756,0.26772,0.53543,0.26772,0.54331,0.26772,0.55118,0.26772,0.55906,0.26772,0.56693,0.26772,0.5748,0.26772,0.58268,0.26772,0.59055,0.26772,0.59843,0.26772,0.6063,0.26772,0.61417,0.26772,0.62205,0.26772,0.62992,0.26772,0.6378,0.26772,0.64567,0.26772,0.65354,0.26772,0.66142,0.26772,0.66929,0.26772,0.67717,0.26772,0.68504,0.26772,0.69291,0.26772,0.70079,0.26772,0.70866,0.26772,0.71654,0.26772,0.72441,0.26772,0.73228,0.26772,0.74016,0.26772,0.74803,0.26772,0.75591,0.26772,0.76378,0.26772,0.77165,0.26772,0.77953,0.26772,0.7874,0.26772,0.79528,0.26772,0.80315,0.26772,0.81102,0.26772,0.8189,0.26772,0.82677,0.26772,0.83465,0.26772,0.84252,0.26772,0.85039,0.26772,0.85827,0.26772,0.86614,0.26772,0.87402,0.26772,0.88189,0.26772,0.88976,0.26772,0.89764,0.26772,0.90551,0.26772,0.91339,0.26772,0.92126,0.26772,0.92913,0.26772,0.93701,0.26772,0.94488,0.26772,0.95276,0.26772,0.96063,0.26772,0.9685,0.26772,0.97638,0.26772,0.98425,0.26772,0.99213,0.26772,0.99609,0.26772,0.00391,0.27559,0.00787,0.27559,0.01575,0.27559,0.02362,0.27559,0.0315,0.27559,0.03937,0.27559,0.04724,0.27559,0.05512,0.27559,0.06299,0.27559,0.07087,0.27559,0.07874,0.27559,0.08661,0.27559,0.09449,0.27559,0.10236,0.27559,0.11024,0.27559,0.11811,0.27559,0.12598,0.27559,0.13386,0.27559,0.14173,0.27559,0.14961,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_46()
		{
			double[] value = {0.15748,0.27559,0.16535,0.27559,0.17323,0.27559,0.1811,0.27559,0.18898,0.27559,0.19685,0.27559,0.20472,0.27559,0.2126,0.27559,0.22047,0.27559,0.22835,0.27559,0.23622,0.27559,0.24409,0.27559,0.25197,0.27559,0.25984,0.27559,0.26772,0.27559,0.27559,0.27559,0.28346,0.27559,0.29134,0.27559,0.29921,0.27559,0.30709,0.27559,0.31496,0.27559,0.32283,0.27559,0.33071,0.27559,0.33858,0.27559,0.34646,0.27559,0.35433,0.27559,0.3622,0.27559,0.37008,0.27559,0.37795,0.27559,0.38583,0.27559,0.3937,0.27559,0.40157,0.27559,0.40945,0.27559,0.41732,0.27559,0.4252,0.27559,0.43307,0.27559,0.44094,0.27559,0.44882,0.27559,0.45669,0.27559,0.46457,0.27559,0.47244,0.27559,0.48031,0.27559,0.48819,0.27559,0.49606,0.27559,0.50394,0.27559,0.51181,0.27559,0.51969,0.27559,0.52756,0.27559,0.53543,0.27559,0.54331,0.27559,0.55118,0.27559,0.55906,0.27559,0.56693,0.27559,0.5748,0.27559,0.58268,0.27559,0.59055,0.27559,0.59843,0.27559,0.6063,0.27559,0.61417,0.27559,0.62205,0.27559,0.62992,0.27559,0.6378,0.27559,0.64567,0.27559,0.65354,0.27559,0.66142,0.27559,0.66929,0.27559,0.67717,0.27559,0.68504,0.27559,0.69291,0.27559,0.70079,0.27559,0.70866,0.27559,0.71654,0.27559,0.72441,0.27559,0.73228,0.27559,0.74016,0.27559,0.74803,0.27559,0.75591,0.27559,0.76378,0.27559,0.77165,0.27559,0.77953,0.27559,0.7874,0.27559,0.79528,0.27559,0.80315,0.27559,0.81102,0.27559,0.8189,0.27559,0.82677,0.27559,0.83465,0.27559,0.84252,0.27559,0.85039,0.27559,0.85827,0.27559,0.86614,0.27559,0.87402,0.27559,0.88189,0.27559,0.88976,0.27559,0.89764,0.27559,0.90551,0.27559,0.91339,0.27559,0.92126,0.27559,0.92913,0.27559,0.93701,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_47()
		{
			double[] value = {0.94488,0.27559,0.95276,0.27559,0.96063,0.27559,0.9685,0.27559,0.97638,0.27559,0.98425,0.27559,0.99213,0.27559,0.99609,0.27559,0.00391,0.28346,0.00787,0.28346,0.01575,0.28346,0.02362,0.28346,0.0315,0.28346,0.03937,0.28346,0.04724,0.28346,0.05512,0.28346,0.06299,0.28346,0.07087,0.28346,0.07874,0.28346,0.08661,0.28346,0.09449,0.28346,0.10236,0.28346,0.11024,0.28346,0.11811,0.28346,0.12598,0.28346,0.13386,0.28346,0.14173,0.28346,0.14961,0.28346,0.15748,0.28346,0.16535,0.28346,0.17323,0.28346,0.1811,0.28346,0.18898,0.28346,0.19685,0.28346,0.20472,0.28346,0.2126,0.28346,0.22047,0.28346,0.22835,0.28346,0.23622,0.28346,0.24409,0.28346,0.25197,0.28346,0.25984,0.28346,0.26772,0.28346,0.27559,0.28346,0.28346,0.28346,0.29134,0.28346,0.29921,0.28346,0.30709,0.28346,0.31496,0.28346,0.32283,0.28346,0.33071,0.28346,0.33858,0.28346,0.34646,0.28346,0.35433,0.28346,0.3622,0.28346,0.37008,0.28346,0.37795,0.28346,0.38583,0.28346,0.3937,0.28346,0.40157,0.28346,0.40945,0.28346,0.41732,0.28346,0.4252,0.28346,0.43307,0.28346,0.44094,0.28346,0.44882,0.28346,0.45669,0.28346,0.46457,0.28346,0.47244,0.28346,0.48031,0.28346,0.48819,0.28346,0.49606,0.28346,0.50394,0.28346,0.51181,0.28346,0.51969,0.28346,0.52756,0.28346,0.53543,0.28346,0.54331,0.28346,0.55118,0.28346,0.55906,0.28346,0.56693,0.28346,0.5748,0.28346,0.58268,0.28346,0.59055,0.28346,0.59843,0.28346,0.6063,0.28346,0.61417,0.28346,0.62205,0.28346,0.62992,0.28346,0.6378,0.28346,0.64567,0.28346,0.65354,0.28346,0.66142,0.28346,0.66929,0.28346,0.67717,0.28346,0.68504,0.28346,0.69291,0.28346,0.70079,0.28346,0.70866,0.28346,0.71654,0.28346};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_48()
		{
			double[] value = {0.72441,0.28346,0.73228,0.28346,0.74016,0.28346,0.74803,0.28346,0.75591,0.28346,0.76378,0.28346,0.77165,0.28346,0.77953,0.28346,0.7874,0.28346,0.79528,0.28346,0.80315,0.28346,0.81102,0.28346,0.8189,0.28346,0.82677,0.28346,0.83465,0.28346,0.84252,0.28346,0.85039,0.28346,0.85827,0.28346,0.86614,0.28346,0.87402,0.28346,0.88189,0.28346,0.88976,0.28346,0.89764,0.28346,0.90551,0.28346,0.91339,0.28346,0.92126,0.28346,0.92913,0.28346,0.93701,0.28346,0.94488,0.28346,0.95276,0.28346,0.96063,0.28346,0.9685,0.28346,0.97638,0.28346,0.98425,0.28346,0.99213,0.28346,0.99609,0.28346,0.00391,0.29134,0.00787,0.29134,0.01575,0.29134,0.02362,0.29134,0.0315,0.29134,0.03937,0.29134,0.04724,0.29134,0.05512,0.29134,0.06299,0.29134,0.07087,0.29134,0.07874,0.29134,0.08661,0.29134,0.09449,0.29134,0.10236,0.29134,0.11024,0.29134,0.11811,0.29134,0.12598,0.29134,0.13386,0.29134,0.14173,0.29134,0.14961,0.29134,0.15748,0.29134,0.16535,0.29134,0.17323,0.29134,0.1811,0.29134,0.18898,0.29134,0.19685,0.29134,0.20472,0.29134,0.2126,0.29134,0.22047,0.29134,0.22835,0.29134,0.23622,0.29134,0.24409,0.29134,0.25197,0.29134,0.25984,0.29134,0.26772,0.29134,0.27559,0.29134,0.28346,0.29134,0.29134,0.29134,0.29921,0.29134,0.30709,0.29134,0.31496,0.29134,0.32283,0.29134,0.33071,0.29134,0.33858,0.29134,0.34646,0.29134,0.35433,0.29134,0.3622,0.29134,0.37008,0.29134,0.37795,0.29134,0.38583,0.29134,0.3937,0.29134,0.40157,0.29134,0.40945,0.29134,0.41732,0.29134,0.4252,0.29134,0.43307,0.29134,0.44094,0.29134,0.44882,0.29134,0.45669,0.29134,0.46457,0.29134,0.47244,0.29134,0.48031,0.29134,0.48819,0.29134,0.49606,0.29134};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_49()
		{
			double[] value = {0.50394,0.29134,0.51181,0.29134,0.51969,0.29134,0.52756,0.29134,0.53543,0.29134,0.54331,0.29134,0.55118,0.29134,0.55906,0.29134,0.56693,0.29134,0.5748,0.29134,0.58268,0.29134,0.59055,0.29134,0.59843,0.29134,0.6063,0.29134,0.61417,0.29134,0.62205,0.29134,0.62992,0.29134,0.6378,0.29134,0.64567,0.29134,0.65354,0.29134,0.66142,0.29134,0.66929,0.29134,0.67717,0.29134,0.68504,0.29134,0.69291,0.29134,0.70079,0.29134,0.70866,0.29134,0.71654,0.29134,0.72441,0.29134,0.73228,0.29134,0.74016,0.29134,0.74803,0.29134,0.75591,0.29134,0.76378,0.29134,0.77165,0.29134,0.77953,0.29134,0.7874,0.29134,0.79528,0.29134,0.80315,0.29134,0.81102,0.29134,0.8189,0.29134,0.82677,0.29134,0.83465,0.29134,0.84252,0.29134,0.85039,0.29134,0.85827,0.29134,0.86614,0.29134,0.87402,0.29134,0.88189,0.29134,0.88976,0.29134,0.89764,0.29134,0.90551,0.29134,0.91339,0.29134,0.92126,0.29134,0.92913,0.29134,0.93701,0.29134,0.94488,0.29134,0.95276,0.29134,0.96063,0.29134,0.9685,0.29134,0.97638,0.29134,0.98425,0.29134,0.99213,0.29134,0.99609,0.29134,0.00391,0.29921,0.00787,0.29921,0.01575,0.29921,0.02362,0.29921,0.0315,0.29921,0.03937,0.29921,0.04724,0.29921,0.05512,0.29921,0.06299,0.29921,0.07087,0.29921,0.07874,0.29921,0.08661,0.29921,0.09449,0.29921,0.10236,0.29921,0.11024,0.29921,0.11811,0.29921,0.12598,0.29921,0.13386,0.29921,0.14173,0.29921,0.14961,0.29921,0.15748,0.29921,0.16535,0.29921,0.17323,0.29921,0.1811,0.29921,0.18898,0.29921,0.19685,0.29921,0.20472,0.29921,0.2126,0.29921,0.22047,0.29921,0.22835,0.29921,0.23622,0.29921,0.24409,0.29921,0.25197,0.29921,0.25984,0.29921,0.26772,0.29921,0.27559,0.29921};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_50()
		{
			double[] value = {0.28346,0.29921,0.29134,0.29921,0.29921,0.29921,0.30709,0.29921,0.31496,0.29921,0.32283,0.29921,0.33071,0.29921,0.33858,0.29921,0.34646,0.29921,0.35433,0.29921,0.3622,0.29921,0.37008,0.29921,0.37795,0.29921,0.38583,0.29921,0.3937,0.29921,0.40157,0.29921,0.40945,0.29921,0.41732,0.29921,0.4252,0.29921,0.43307,0.29921,0.44094,0.29921,0.44882,0.29921,0.45669,0.29921,0.46457,0.29921,0.47244,0.29921,0.48031,0.29921,0.48819,0.29921,0.49606,0.29921,0.50394,0.29921,0.51181,0.29921,0.51969,0.29921,0.52756,0.29921,0.53543,0.29921,0.54331,0.29921,0.55118,0.29921,0.55906,0.29921,0.56693,0.29921,0.5748,0.29921,0.58268,0.29921,0.59055,0.29921,0.59843,0.29921,0.6063,0.29921,0.61417,0.29921,0.62205,0.29921,0.62992,0.29921,0.6378,0.29921,0.64567,0.29921,0.65354,0.29921,0.66142,0.29921,0.66929,0.29921,0.67717,0.29921,0.68504,0.29921,0.69291,0.29921,0.70079,0.29921,0.70866,0.29921,0.71654,0.29921,0.72441,0.29921,0.73228,0.29921,0.74016,0.29921,0.74803,0.29921,0.75591,0.29921,0.76378,0.29921,0.77165,0.29921,0.77953,0.29921,0.7874,0.29921,0.79528,0.29921,0.80315,0.29921,0.81102,0.29921,0.8189,0.29921,0.82677,0.29921,0.83465,0.29921,0.84252,0.29921,0.85039,0.29921,0.85827,0.29921,0.86614,0.29921,0.87402,0.29921,0.88189,0.29921,0.88976,0.29921,0.89764,0.29921,0.90551,0.29921,0.91339,0.29921,0.92126,0.29921,0.92913,0.29921,0.93701,0.29921,0.94488,0.29921,0.95276,0.29921,0.96063,0.29921,0.9685,0.29921,0.97638,0.29921,0.98425,0.29921,0.99213,0.29921,0.99609,0.29921,0.00391,0.30709,0.00787,0.30709,0.01575,0.30709,0.02362,0.30709,0.0315,0.30709,0.03937,0.30709,0.04724,0.30709,0.05512,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_51()
		{
			double[] value = {0.06299,0.30709,0.07087,0.30709,0.07874,0.30709,0.08661,0.30709,0.09449,0.30709,0.10236,0.30709,0.11024,0.30709,0.11811,0.30709,0.12598,0.30709,0.13386,0.30709,0.14173,0.30709,0.14961,0.30709,0.15748,0.30709,0.16535,0.30709,0.17323,0.30709,0.1811,0.30709,0.18898,0.30709,0.19685,0.30709,0.20472,0.30709,0.2126,0.30709,0.22047,0.30709,0.22835,0.30709,0.23622,0.30709,0.24409,0.30709,0.25197,0.30709,0.25984,0.30709,0.26772,0.30709,0.27559,0.30709,0.28346,0.30709,0.29134,0.30709,0.29921,0.30709,0.30709,0.30709,0.31496,0.30709,0.32283,0.30709,0.33071,0.30709,0.33858,0.30709,0.34646,0.30709,0.35433,0.30709,0.3622,0.30709,0.37008,0.30709,0.37795,0.30709,0.38583,0.30709,0.3937,0.30709,0.40157,0.30709,0.40945,0.30709,0.41732,0.30709,0.4252,0.30709,0.43307,0.30709,0.44094,0.30709,0.44882,0.30709,0.45669,0.30709,0.46457,0.30709,0.47244,0.30709,0.48031,0.30709,0.48819,0.30709,0.49606,0.30709,0.50394,0.30709,0.51181,0.30709,0.51969,0.30709,0.52756,0.30709,0.53543,0.30709,0.54331,0.30709,0.55118,0.30709,0.55906,0.30709,0.56693,0.30709,0.5748,0.30709,0.58268,0.30709,0.59055,0.30709,0.59843,0.30709,0.6063,0.30709,0.61417,0.30709,0.62205,0.30709,0.62992,0.30709,0.6378,0.30709,0.64567,0.30709,0.65354,0.30709,0.66142,0.30709,0.66929,0.30709,0.67717,0.30709,0.68504,0.30709,0.69291,0.30709,0.70079,0.30709,0.70866,0.30709,0.71654,0.30709,0.72441,0.30709,0.73228,0.30709,0.74016,0.30709,0.74803,0.30709,0.75591,0.30709,0.76378,0.30709,0.77165,0.30709,0.77953,0.30709,0.7874,0.30709,0.79528,0.30709,0.80315,0.30709,0.81102,0.30709,0.8189,0.30709,0.82677,0.30709,0.83465,0.30709,0.84252,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_52()
		{
			double[] value = {0.85039,0.30709,0.85827,0.30709,0.86614,0.30709,0.87402,0.30709,0.88189,0.30709,0.88976,0.30709,0.89764,0.30709,0.90551,0.30709,0.91339,0.30709,0.92126,0.30709,0.92913,0.30709,0.93701,0.30709,0.94488,0.30709,0.95276,0.30709,0.96063,0.30709,0.9685,0.30709,0.97638,0.30709,0.98425,0.30709,0.99213,0.30709,0.99609,0.30709,0.00391,0.31496,0.00787,0.31496,0.01575,0.31496,0.02362,0.31496,0.0315,0.31496,0.03937,0.31496,0.04724,0.31496,0.05512,0.31496,0.06299,0.31496,0.07087,0.31496,0.07874,0.31496,0.08661,0.31496,0.09449,0.31496,0.10236,0.31496,0.11024,0.31496,0.11811,0.31496,0.12598,0.31496,0.13386,0.31496,0.14173,0.31496,0.14961,0.31496,0.15748,0.31496,0.16535,0.31496,0.17323,0.31496,0.1811,0.31496,0.18898,0.31496,0.19685,0.31496,0.20472,0.31496,0.2126,0.31496,0.22047,0.31496,0.22835,0.31496,0.23622,0.31496,0.24409,0.31496,0.25197,0.31496,0.25984,0.31496,0.26772,0.31496,0.27559,0.31496,0.28346,0.31496,0.29134,0.31496,0.29921,0.31496,0.30709,0.31496,0.31496,0.31496,0.32283,0.31496,0.33071,0.31496,0.33858,0.31496,0.34646,0.31496,0.35433,0.31496,0.3622,0.31496,0.37008,0.31496,0.37795,0.31496,0.38583,0.31496,0.3937,0.31496,0.40157,0.31496,0.40945,0.31496,0.41732,0.31496,0.4252,0.31496,0.43307,0.31496,0.44094,0.31496,0.44882,0.31496,0.45669,0.31496,0.46457,0.31496,0.47244,0.31496,0.48031,0.31496,0.48819,0.31496,0.49606,0.31496,0.50394,0.31496,0.51181,0.31496,0.51969,0.31496,0.52756,0.31496,0.53543,0.31496,0.54331,0.31496,0.55118,0.31496,0.55906,0.31496,0.56693,0.31496,0.5748,0.31496,0.58268,0.31496,0.59055,0.31496,0.59843,0.31496,0.6063,0.31496,0.61417,0.31496,0.62205,0.31496};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_53()
		{
			double[] value = {0.62992,0.31496,0.6378,0.31496,0.64567,0.31496,0.65354,0.31496,0.66142,0.31496,0.66929,0.31496,0.67717,0.31496,0.68504,0.31496,0.69291,0.31496,0.70079,0.31496,0.70866,0.31496,0.71654,0.31496,0.72441,0.31496,0.73228,0.31496,0.74016,0.31496,0.74803,0.31496,0.75591,0.31496,0.76378,0.31496,0.77165,0.31496,0.77953,0.31496,0.7874,0.31496,0.79528,0.31496,0.80315,0.31496,0.81102,0.31496,0.8189,0.31496,0.82677,0.31496,0.83465,0.31496,0.84252,0.31496,0.85039,0.31496,0.85827,0.31496,0.86614,0.31496,0.87402,0.31496,0.88189,0.31496,0.88976,0.31496,0.89764,0.31496,0.90551,0.31496,0.91339,0.31496,0.92126,0.31496,0.92913,0.31496,0.93701,0.31496,0.94488,0.31496,0.95276,0.31496,0.96063,0.31496,0.9685,0.31496,0.97638,0.31496,0.98425,0.31496,0.99213,0.31496,0.99609,0.31496,0.00391,0.32283,0.00787,0.32283,0.01575,0.32283,0.02362,0.32283,0.0315,0.32283,0.03937,0.32283,0.04724,0.32283,0.05512,0.32283,0.06299,0.32283,0.07087,0.32283,0.07874,0.32283,0.08661,0.32283,0.09449,0.32283,0.10236,0.32283,0.11024,0.32283,0.11811,0.32283,0.12598,0.32283,0.13386,0.32283,0.14173,0.32283,0.14961,0.32283,0.15748,0.32283,0.16535,0.32283,0.17323,0.32283,0.1811,0.32283,0.18898,0.32283,0.19685,0.32283,0.20472,0.32283,0.2126,0.32283,0.22047,0.32283,0.22835,0.32283,0.23622,0.32283,0.24409,0.32283,0.25197,0.32283,0.25984,0.32283,0.26772,0.32283,0.27559,0.32283,0.28346,0.32283,0.29134,0.32283,0.29921,0.32283,0.30709,0.32283,0.31496,0.32283,0.32283,0.32283,0.33071,0.32283,0.33858,0.32283,0.34646,0.32283,0.35433,0.32283,0.3622,0.32283,0.37008,0.32283,0.37795,0.32283,0.38583,0.32283,0.3937,0.32283,0.40157,0.32283};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_54()
		{
			double[] value = {0.40945,0.32283,0.41732,0.32283,0.4252,0.32283,0.43307,0.32283,0.44094,0.32283,0.44882,0.32283,0.45669,0.32283,0.46457,0.32283,0.47244,0.32283,0.48031,0.32283,0.48819,0.32283,0.49606,0.32283,0.50394,0.32283,0.51181,0.32283,0.51969,0.32283,0.52756,0.32283,0.53543,0.32283,0.54331,0.32283,0.55118,0.32283,0.55906,0.32283,0.56693,0.32283,0.5748,0.32283,0.58268,0.32283,0.59055,0.32283,0.59843,0.32283,0.6063,0.32283,0.61417,0.32283,0.62205,0.32283,0.62992,0.32283,0.6378,0.32283,0.64567,0.32283,0.65354,0.32283,0.66142,0.32283,0.66929,0.32283,0.67717,0.32283,0.68504,0.32283,0.69291,0.32283,0.70079,0.32283,0.70866,0.32283,0.71654,0.32283,0.72441,0.32283,0.73228,0.32283,0.74016,0.32283,0.74803,0.32283,0.75591,0.32283,0.76378,0.32283,0.77165,0.32283,0.77953,0.32283,0.7874,0.32283,0.79528,0.32283,0.80315,0.32283,0.81102,0.32283,0.8189,0.32283,0.82677,0.32283,0.83465,0.32283,0.84252,0.32283,0.85039,0.32283,0.85827,0.32283,0.86614,0.32283,0.87402,0.32283,0.88189,0.32283,0.88976,0.32283,0.89764,0.32283,0.90551,0.32283,0.91339,0.32283,0.92126,0.32283,0.92913,0.32283,0.93701,0.32283,0.94488,0.32283,0.95276,0.32283,0.96063,0.32283,0.9685,0.32283,0.97638,0.32283,0.98425,0.32283,0.99213,0.32283,0.99609,0.32283,0.00391,0.33071,0.00787,0.33071,0.01575,0.33071,0.02362,0.33071,0.0315,0.33071,0.03937,0.33071,0.04724,0.33071,0.05512,0.33071,0.06299,0.33071,0.07087,0.33071,0.07874,0.33071,0.08661,0.33071,0.09449,0.33071,0.10236,0.33071,0.11024,0.33071,0.11811,0.33071,0.12598,0.33071,0.13386,0.33071,0.14173,0.33071,0.14961,0.33071,0.15748,0.33071,0.16535,0.33071,0.17323,0.33071,0.1811,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_55()
		{
			double[] value = {0.18898,0.33071,0.19685,0.33071,0.20472,0.33071,0.2126,0.33071,0.22047,0.33071,0.22835,0.33071,0.23622,0.33071,0.24409,0.33071,0.25197,0.33071,0.25984,0.33071,0.26772,0.33071,0.27559,0.33071,0.28346,0.33071,0.29134,0.33071,0.29921,0.33071,0.30709,0.33071,0.31496,0.33071,0.32283,0.33071,0.33071,0.33071,0.33858,0.33071,0.34646,0.33071,0.35433,0.33071,0.3622,0.33071,0.37008,0.33071,0.37795,0.33071,0.38583,0.33071,0.3937,0.33071,0.40157,0.33071,0.40945,0.33071,0.41732,0.33071,0.4252,0.33071,0.43307,0.33071,0.44094,0.33071,0.44882,0.33071,0.45669,0.33071,0.46457,0.33071,0.47244,0.33071,0.48031,0.33071,0.48819,0.33071,0.49606,0.33071,0.50394,0.33071,0.51181,0.33071,0.51969,0.33071,0.52756,0.33071,0.53543,0.33071,0.54331,0.33071,0.55118,0.33071,0.55906,0.33071,0.56693,0.33071,0.5748,0.33071,0.58268,0.33071,0.59055,0.33071,0.59843,0.33071,0.6063,0.33071,0.61417,0.33071,0.62205,0.33071,0.62992,0.33071,0.6378,0.33071,0.64567,0.33071,0.65354,0.33071,0.66142,0.33071,0.66929,0.33071,0.67717,0.33071,0.68504,0.33071,0.69291,0.33071,0.70079,0.33071,0.70866,0.33071,0.71654,0.33071,0.72441,0.33071,0.73228,0.33071,0.74016,0.33071,0.74803,0.33071,0.75591,0.33071,0.76378,0.33071,0.77165,0.33071,0.77953,0.33071,0.7874,0.33071,0.79528,0.33071,0.80315,0.33071,0.81102,0.33071,0.8189,0.33071,0.82677,0.33071,0.83465,0.33071,0.84252,0.33071,0.85039,0.33071,0.85827,0.33071,0.86614,0.33071,0.87402,0.33071,0.88189,0.33071,0.88976,0.33071,0.89764,0.33071,0.90551,0.33071,0.91339,0.33071,0.92126,0.33071,0.92913,0.33071,0.93701,0.33071,0.94488,0.33071,0.95276,0.33071,0.96063,0.33071,0.9685,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_56()
		{
			double[] value = {0.97638,0.33071,0.98425,0.33071,0.99213,0.33071,0.99609,0.33071,0.00391,0.33858,0.00787,0.33858,0.01575,0.33858,0.02362,0.33858,0.0315,0.33858,0.03937,0.33858,0.04724,0.33858,0.05512,0.33858,0.06299,0.33858,0.07087,0.33858,0.07874,0.33858,0.08661,0.33858,0.09449,0.33858,0.10236,0.33858,0.11024,0.33858,0.11811,0.33858,0.12598,0.33858,0.13386,0.33858,0.14173,0.33858,0.14961,0.33858,0.15748,0.33858,0.16535,0.33858,0.17323,0.33858,0.1811,0.33858,0.18898,0.33858,0.19685,0.33858,0.20472,0.33858,0.2126,0.33858,0.22047,0.33858,0.22835,0.33858,0.23622,0.33858,0.24409,0.33858,0.25197,0.33858,0.25984,0.33858,0.26772,0.33858,0.27559,0.33858,0.28346,0.33858,0.29134,0.33858,0.29921,0.33858,0.30709,0.33858,0.31496,0.33858,0.32283,0.33858,0.33071,0.33858,0.33858,0.33858,0.34646,0.33858,0.35433,0.33858,0.3622,0.33858,0.37008,0.33858,0.37795,0.33858,0.38583,0.33858,0.3937,0.33858,0.40157,0.33858,0.40945,0.33858,0.41732,0.33858,0.4252,0.33858,0.43307,0.33858,0.44094,0.33858,0.44882,0.33858,0.45669,0.33858,0.46457,0.33858,0.47244,0.33858,0.48031,0.33858,0.48819,0.33858,0.49606,0.33858,0.50394,0.33858,0.51181,0.33858,0.51969,0.33858,0.52756,0.33858,0.53543,0.33858,0.54331,0.33858,0.55118,0.33858,0.55906,0.33858,0.56693,0.33858,0.5748,0.33858,0.58268,0.33858,0.59055,0.33858,0.59843,0.33858,0.6063,0.33858,0.61417,0.33858,0.62205,0.33858,0.62992,0.33858,0.6378,0.33858,0.64567,0.33858,0.65354,0.33858,0.66142,0.33858,0.66929,0.33858,0.67717,0.33858,0.68504,0.33858,0.69291,0.33858,0.70079,0.33858,0.70866,0.33858,0.71654,0.33858,0.72441,0.33858,0.73228,0.33858,0.74016,0.33858,0.74803,0.33858};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_57()
		{
			double[] value = {0.75591,0.33858,0.76378,0.33858,0.77165,0.33858,0.77953,0.33858,0.7874,0.33858,0.79528,0.33858,0.80315,0.33858,0.81102,0.33858,0.8189,0.33858,0.82677,0.33858,0.83465,0.33858,0.84252,0.33858,0.85039,0.33858,0.85827,0.33858,0.86614,0.33858,0.87402,0.33858,0.88189,0.33858,0.88976,0.33858,0.89764,0.33858,0.90551,0.33858,0.91339,0.33858,0.92126,0.33858,0.92913,0.33858,0.93701,0.33858,0.94488,0.33858,0.95276,0.33858,0.96063,0.33858,0.9685,0.33858,0.97638,0.33858,0.98425,0.33858,0.99213,0.33858,0.99609,0.33858,0.00391,0.34646,0.00787,0.34646,0.01575,0.34646,0.02362,0.34646,0.0315,0.34646,0.03937,0.34646,0.04724,0.34646,0.05512,0.34646,0.06299,0.34646,0.07087,0.34646,0.07874,0.34646,0.08661,0.34646,0.09449,0.34646,0.10236,0.34646,0.11024,0.34646,0.11811,0.34646,0.12598,0.34646,0.13386,0.34646,0.14173,0.34646,0.14961,0.34646,0.15748,0.34646,0.16535,0.34646,0.17323,0.34646,0.1811,0.34646,0.18898,0.34646,0.19685,0.34646,0.20472,0.34646,0.2126,0.34646,0.22047,0.34646,0.22835,0.34646,0.23622,0.34646,0.24409,0.34646,0.25197,0.34646,0.25984,0.34646,0.26772,0.34646,0.27559,0.34646,0.28346,0.34646,0.29134,0.34646,0.29921,0.34646,0.30709,0.34646,0.31496,0.34646,0.32283,0.34646,0.33071,0.34646,0.33858,0.34646,0.34646,0.34646,0.35433,0.34646,0.3622,0.34646,0.37008,0.34646,0.37795,0.34646,0.38583,0.34646,0.3937,0.34646,0.40157,0.34646,0.40945,0.34646,0.41732,0.34646,0.4252,0.34646,0.43307,0.34646,0.44094,0.34646,0.44882,0.34646,0.45669,0.34646,0.46457,0.34646,0.47244,0.34646,0.48031,0.34646,0.48819,0.34646,0.49606,0.34646,0.50394,0.34646,0.51181,0.34646,0.51969,0.34646,0.52756,0.34646};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_58()
		{
			double[] value = {0.53543,0.34646,0.54331,0.34646,0.55118,0.34646,0.55906,0.34646,0.56693,0.34646,0.5748,0.34646,0.58268,0.34646,0.59055,0.34646,0.59843,0.34646,0.6063,0.34646,0.61417,0.34646,0.62205,0.34646,0.62992,0.34646,0.6378,0.34646,0.64567,0.34646,0.65354,0.34646,0.66142,0.34646,0.66929,0.34646,0.67717,0.34646,0.68504,0.34646,0.69291,0.34646,0.70079,0.34646,0.70866,0.34646,0.71654,0.34646,0.72441,0.34646,0.73228,0.34646,0.74016,0.34646,0.74803,0.34646,0.75591,0.34646,0.76378,0.34646,0.77165,0.34646,0.77953,0.34646,0.7874,0.34646,0.79528,0.34646,0.80315,0.34646,0.81102,0.34646,0.8189,0.34646,0.82677,0.34646,0.83465,0.34646,0.84252,0.34646,0.85039,0.34646,0.85827,0.34646,0.86614,0.34646,0.87402,0.34646,0.88189,0.34646,0.88976,0.34646,0.89764,0.34646,0.90551,0.34646,0.91339,0.34646,0.92126,0.34646,0.92913,0.34646,0.93701,0.34646,0.94488,0.34646,0.95276,0.34646,0.96063,0.34646,0.9685,0.34646,0.97638,0.34646,0.98425,0.34646,0.99213,0.34646,0.99609,0.34646,0.00391,0.35433,0.00787,0.35433,0.01575,0.35433,0.02362,0.35433,0.0315,0.35433,0.03937,0.35433,0.04724,0.35433,0.05512,0.35433,0.06299,0.35433,0.07087,0.35433,0.07874,0.35433,0.08661,0.35433,0.09449,0.35433,0.10236,0.35433,0.11024,0.35433,0.11811,0.35433,0.12598,0.35433,0.13386,0.35433,0.14173,0.35433,0.14961,0.35433,0.15748,0.35433,0.16535,0.35433,0.17323,0.35433,0.1811,0.35433,0.18898,0.35433,0.19685,0.35433,0.20472,0.35433,0.2126,0.35433,0.22047,0.35433,0.22835,0.35433,0.23622,0.35433,0.24409,0.35433,0.25197,0.35433,0.25984,0.35433,0.26772,0.35433,0.27559,0.35433,0.28346,0.35433,0.29134,0.35433,0.29921,0.35433,0.30709,0.35433};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_59()
		{
			double[] value = {0.31496,0.35433,0.32283,0.35433,0.33071,0.35433,0.33858,0.35433,0.34646,0.35433,0.35433,0.35433,0.3622,0.35433,0.37008,0.35433,0.37795,0.35433,0.38583,0.35433,0.3937,0.35433,0.40157,0.35433,0.40945,0.35433,0.41732,0.35433,0.4252,0.35433,0.43307,0.35433,0.44094,0.35433,0.44882,0.35433,0.45669,0.35433,0.46457,0.35433,0.47244,0.35433,0.48031,0.35433,0.48819,0.35433,0.49606,0.35433,0.50394,0.35433,0.51181,0.35433,0.51969,0.35433,0.52756,0.35433,0.53543,0.35433,0.54331,0.35433,0.55118,0.35433,0.55906,0.35433,0.56693,0.35433,0.5748,0.35433,0.58268,0.35433,0.59055,0.35433,0.59843,0.35433,0.6063,0.35433,0.61417,0.35433,0.62205,0.35433,0.62992,0.35433,0.6378,0.35433,0.64567,0.35433,0.65354,0.35433,0.66142,0.35433,0.66929,0.35433,0.67717,0.35433,0.68504,0.35433,0.69291,0.35433,0.70079,0.35433,0.70866,0.35433,0.71654,0.35433,0.72441,0.35433,0.73228,0.35433,0.74016,0.35433,0.74803,0.35433,0.75591,0.35433,0.76378,0.35433,0.77165,0.35433,0.77953,0.35433,0.7874,0.35433,0.79528,0.35433,0.80315,0.35433,0.81102,0.35433,0.8189,0.35433,0.82677,0.35433,0.83465,0.35433,0.84252,0.35433,0.85039,0.35433,0.85827,0.35433,0.86614,0.35433,0.87402,0.35433,0.88189,0.35433,0.88976,0.35433,0.89764,0.35433,0.90551,0.35433,0.91339,0.35433,0.92126,0.35433,0.92913,0.35433,0.93701,0.35433,0.94488,0.35433,0.95276,0.35433,0.96063,0.35433,0.9685,0.35433,0.97638,0.35433,0.98425,0.35433,0.99213,0.35433,0.99609,0.35433,0.00391,0.3622,0.00787,0.3622,0.01575,0.3622,0.02362,0.3622,0.0315,0.3622,0.03937,0.3622,0.04724,0.3622,0.05512,0.3622,0.06299,0.3622,0.07087,0.3622,0.07874,0.3622,0.08661,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_60()
		{
			double[] value = {0.09449,0.3622,0.10236,0.3622,0.11024,0.3622,0.11811,0.3622,0.12598,0.3622,0.13386,0.3622,0.14173,0.3622,0.14961,0.3622,0.15748,0.3622,0.16535,0.3622,0.17323,0.3622,0.1811,0.3622,0.18898,0.3622,0.19685,0.3622,0.20472,0.3622,0.2126,0.3622,0.22047,0.3622,0.22835,0.3622,0.23622,0.3622,0.24409,0.3622,0.25197,0.3622,0.25984,0.3622,0.26772,0.3622,0.27559,0.3622,0.28346,0.3622,0.29134,0.3622,0.29921,0.3622,0.30709,0.3622,0.31496,0.3622,0.32283,0.3622,0.33071,0.3622,0.33858,0.3622,0.34646,0.3622,0.35433,0.3622,0.3622,0.3622,0.37008,0.3622,0.37795,0.3622,0.38583,0.3622,0.3937,0.3622,0.40157,0.3622,0.40945,0.3622,0.41732,0.3622,0.4252,0.3622,0.43307,0.3622,0.44094,0.3622,0.44882,0.3622,0.45669,0.3622,0.46457,0.3622,0.47244,0.3622,0.48031,0.3622,0.48819,0.3622,0.49606,0.3622,0.50394,0.3622,0.51181,0.3622,0.51969,0.3622,0.52756,0.3622,0.53543,0.3622,0.54331,0.3622,0.55118,0.3622,0.55906,0.3622,0.56693,0.3622,0.5748,0.3622,0.58268,0.3622,0.59055,0.3622,0.59843,0.3622,0.6063,0.3622,0.61417,0.3622,0.62205,0.3622,0.62992,0.3622,0.6378,0.3622,0.64567,0.3622,0.65354,0.3622,0.66142,0.3622,0.66929,0.3622,0.67717,0.3622,0.68504,0.3622,0.69291,0.3622,0.70079,0.3622,0.70866,0.3622,0.71654,0.3622,0.72441,0.3622,0.73228,0.3622,0.74016,0.3622,0.74803,0.3622,0.75591,0.3622,0.76378,0.3622,0.77165,0.3622,0.77953,0.3622,0.7874,0.3622,0.79528,0.3622,0.80315,0.3622,0.81102,0.3622,0.8189,0.3622,0.82677,0.3622,0.83465,0.3622,0.84252,0.3622,0.85039,0.3622,0.85827,0.3622,0.86614,0.3622,0.87402,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_61()
		{
			double[] value = {0.88189,0.3622,0.88976,0.3622,0.89764,0.3622,0.90551,0.3622,0.91339,0.3622,0.92126,0.3622,0.92913,0.3622,0.93701,0.3622,0.94488,0.3622,0.95276,0.3622,0.96063,0.3622,0.9685,0.3622,0.97638,0.3622,0.98425,0.3622,0.99213,0.3622,0.99609,0.3622,0.00391,0.37008,0.00787,0.37008,0.01575,0.37008,0.02362,0.37008,0.0315,0.37008,0.03937,0.37008,0.04724,0.37008,0.05512,0.37008,0.06299,0.37008,0.07087,0.37008,0.07874,0.37008,0.08661,0.37008,0.09449,0.37008,0.10236,0.37008,0.11024,0.37008,0.11811,0.37008,0.12598,0.37008,0.13386,0.37008,0.14173,0.37008,0.14961,0.37008,0.15748,0.37008,0.16535,0.37008,0.17323,0.37008,0.1811,0.37008,0.18898,0.37008,0.19685,0.37008,0.20472,0.37008,0.2126,0.37008,0.22047,0.37008,0.22835,0.37008,0.23622,0.37008,0.24409,0.37008,0.25197,0.37008,0.25984,0.37008,0.26772,0.37008,0.27559,0.37008,0.28346,0.37008,0.29134,0.37008,0.29921,0.37008,0.30709,0.37008,0.31496,0.37008,0.32283,0.37008,0.33071,0.37008,0.33858,0.37008,0.34646,0.37008,0.35433,0.37008,0.3622,0.37008,0.37008,0.37008,0.37795,0.37008,0.38583,0.37008,0.3937,0.37008,0.40157,0.37008,0.40945,0.37008,0.41732,0.37008,0.4252,0.37008,0.43307,0.37008,0.44094,0.37008,0.44882,0.37008,0.45669,0.37008,0.46457,0.37008,0.47244,0.37008,0.48031,0.37008,0.48819,0.37008,0.49606,0.37008,0.50394,0.37008,0.51181,0.37008,0.51969,0.37008,0.52756,0.37008,0.53543,0.37008,0.54331,0.37008,0.55118,0.37008,0.55906,0.37008,0.56693,0.37008,0.5748,0.37008,0.58268,0.37008,0.59055,0.37008,0.59843,0.37008,0.6063,0.37008,0.61417,0.37008,0.62205,0.37008,0.62992,0.37008,0.6378,0.37008,0.64567,0.37008,0.65354,0.37008};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_62()
		{
			double[] value = {0.66142,0.37008,0.66929,0.37008,0.67717,0.37008,0.68504,0.37008,0.69291,0.37008,0.70079,0.37008,0.70866,0.37008,0.71654,0.37008,0.72441,0.37008,0.73228,0.37008,0.74016,0.37008,0.74803,0.37008,0.75591,0.37008,0.76378,0.37008,0.77165,0.37008,0.77953,0.37008,0.7874,0.37008,0.79528,0.37008,0.80315,0.37008,0.81102,0.37008,0.8189,0.37008,0.82677,0.37008,0.83465,0.37008,0.84252,0.37008,0.85039,0.37008,0.85827,0.37008,0.86614,0.37008,0.87402,0.37008,0.88189,0.37008,0.88976,0.37008,0.89764,0.37008,0.90551,0.37008,0.91339,0.37008,0.92126,0.37008,0.92913,0.37008,0.93701,0.37008,0.94488,0.37008,0.95276,0.37008,0.96063,0.37008,0.9685,0.37008,0.97638,0.37008,0.98425,0.37008,0.99213,0.37008,0.99609,0.37008,0.00391,0.37795,0.00787,0.37795,0.01575,0.37795,0.02362,0.37795,0.0315,0.37795,0.03937,0.37795,0.04724,0.37795,0.05512,0.37795,0.06299,0.37795,0.07087,0.37795,0.07874,0.37795,0.08661,0.37795,0.09449,0.37795,0.10236,0.37795,0.11024,0.37795,0.11811,0.37795,0.12598,0.37795,0.13386,0.37795,0.14173,0.37795,0.14961,0.37795,0.15748,0.37795,0.16535,0.37795,0.17323,0.37795,0.1811,0.37795,0.18898,0.37795,0.19685,0.37795,0.20472,0.37795,0.2126,0.37795,0.22047,0.37795,0.22835,0.37795,0.23622,0.37795,0.24409,0.37795,0.25197,0.37795,0.25984,0.37795,0.26772,0.37795,0.27559,0.37795,0.28346,0.37795,0.29134,0.37795,0.29921,0.37795,0.30709,0.37795,0.31496,0.37795,0.32283,0.37795,0.33071,0.37795,0.33858,0.37795,0.34646,0.37795,0.35433,0.37795,0.3622,0.37795,0.37008,0.37795,0.37795,0.37795,0.38583,0.37795,0.3937,0.37795,0.40157,0.37795,0.40945,0.37795,0.41732,0.37795,0.4252,0.37795,0.43307,0.37795};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_63()
		{
			double[] value = {0.44094,0.37795,0.44882,0.37795,0.45669,0.37795,0.46457,0.37795,0.47244,0.37795,0.48031,0.37795,0.48819,0.37795,0.49606,0.37795,0.50394,0.37795,0.51181,0.37795,0.51969,0.37795,0.52756,0.37795,0.53543,0.37795,0.54331,0.37795,0.55118,0.37795,0.55906,0.37795,0.56693,0.37795,0.5748,0.37795,0.58268,0.37795,0.59055,0.37795,0.59843,0.37795,0.6063,0.37795,0.61417,0.37795,0.62205,0.37795,0.62992,0.37795,0.6378,0.37795,0.64567,0.37795,0.65354,0.37795,0.66142,0.37795,0.66929,0.37795,0.67717,0.37795,0.68504,0.37795,0.69291,0.37795,0.70079,0.37795,0.70866,0.37795,0.71654,0.37795,0.72441,0.37795,0.73228,0.37795,0.74016,0.37795,0.74803,0.37795,0.75591,0.37795,0.76378,0.37795,0.77165,0.37795,0.77953,0.37795,0.7874,0.37795,0.79528,0.37795,0.80315,0.37795,0.81102,0.37795,0.8189,0.37795,0.82677,0.37795,0.83465,0.37795,0.84252,0.37795,0.85039,0.37795,0.85827,0.37795,0.86614,0.37795,0.87402,0.37795,0.88189,0.37795,0.88976,0.37795,0.89764,0.37795,0.90551,0.37795,0.91339,0.37795,0.92126,0.37795,0.92913,0.37795,0.93701,0.37795,0.94488,0.37795,0.95276,0.37795,0.96063,0.37795,0.9685,0.37795,0.97638,0.37795,0.98425,0.37795,0.99213,0.37795,0.99609,0.37795,0.00391,0.38583,0.00787,0.38583,0.01575,0.38583,0.02362,0.38583,0.0315,0.38583,0.03937,0.38583,0.04724,0.38583,0.05512,0.38583,0.06299,0.38583,0.07087,0.38583,0.07874,0.38583,0.08661,0.38583,0.09449,0.38583,0.10236,0.38583,0.11024,0.38583,0.11811,0.38583,0.12598,0.38583,0.13386,0.38583,0.14173,0.38583,0.14961,0.38583,0.15748,0.38583,0.16535,0.38583,0.17323,0.38583,0.1811,0.38583,0.18898,0.38583,0.19685,0.38583,0.20472,0.38583,0.2126,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_64()
		{
			double[] value = {0.22047,0.38583,0.22835,0.38583,0.23622,0.38583,0.24409,0.38583,0.25197,0.38583,0.25984,0.38583,0.26772,0.38583,0.27559,0.38583,0.28346,0.38583,0.29134,0.38583,0.29921,0.38583,0.30709,0.38583,0.31496,0.38583,0.32283,0.38583,0.33071,0.38583,0.33858,0.38583,0.34646,0.38583,0.35433,0.38583,0.3622,0.38583,0.37008,0.38583,0.37795,0.38583,0.38583,0.38583,0.3937,0.38583,0.40157,0.38583,0.40945,0.38583,0.41732,0.38583,0.4252,0.38583,0.43307,0.38583,0.44094,0.38583,0.44882,0.38583,0.45669,0.38583,0.46457,0.38583,0.47244,0.38583,0.48031,0.38583,0.48819,0.38583,0.49606,0.38583,0.50394,0.38583,0.51181,0.38583,0.51969,0.38583,0.52756,0.38583,0.53543,0.38583,0.54331,0.38583,0.55118,0.38583,0.55906,0.38583,0.56693,0.38583,0.5748,0.38583,0.58268,0.38583,0.59055,0.38583,0.59843,0.38583,0.6063,0.38583,0.61417,0.38583,0.62205,0.38583,0.62992,0.38583,0.6378,0.38583,0.64567,0.38583,0.65354,0.38583,0.66142,0.38583,0.66929,0.38583,0.67717,0.38583,0.68504,0.38583,0.69291,0.38583,0.70079,0.38583,0.70866,0.38583,0.71654,0.38583,0.72441,0.38583,0.73228,0.38583,0.74016,0.38583,0.74803,0.38583,0.75591,0.38583,0.76378,0.38583,0.77165,0.38583,0.77953,0.38583,0.7874,0.38583,0.79528,0.38583,0.80315,0.38583,0.81102,0.38583,0.8189,0.38583,0.82677,0.38583,0.83465,0.38583,0.84252,0.38583,0.85039,0.38583,0.85827,0.38583,0.86614,0.38583,0.87402,0.38583,0.88189,0.38583,0.88976,0.38583,0.89764,0.38583,0.90551,0.38583,0.91339,0.38583,0.92126,0.38583,0.92913,0.38583,0.93701,0.38583,0.94488,0.38583,0.95276,0.38583,0.96063,0.38583,0.9685,0.38583,0.97638,0.38583,0.98425,0.38583,0.99213,0.38583,0.99609,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_65()
		{
			double[] value = {0.00391,0.3937,0.00787,0.3937,0.01575,0.3937,0.02362,0.3937,0.0315,0.3937,0.03937,0.3937,0.04724,0.3937,0.05512,0.3937,0.06299,0.3937,0.07087,0.3937,0.07874,0.3937,0.08661,0.3937,0.09449,0.3937,0.10236,0.3937,0.11024,0.3937,0.11811,0.3937,0.12598,0.3937,0.13386,0.3937,0.14173,0.3937,0.14961,0.3937,0.15748,0.3937,0.16535,0.3937,0.17323,0.3937,0.1811,0.3937,0.18898,0.3937,0.19685,0.3937,0.20472,0.3937,0.2126,0.3937,0.22047,0.3937,0.22835,0.3937,0.23622,0.3937,0.24409,0.3937,0.25197,0.3937,0.25984,0.3937,0.26772,0.3937,0.27559,0.3937,0.28346,0.3937,0.29134,0.3937,0.29921,0.3937,0.30709,0.3937,0.31496,0.3937,0.32283,0.3937,0.33071,0.3937,0.33858,0.3937,0.34646,0.3937,0.35433,0.3937,0.3622,0.3937,0.37008,0.3937,0.37795,0.3937,0.38583,0.3937,0.3937,0.3937,0.40157,0.3937,0.40945,0.3937,0.41732,0.3937,0.4252,0.3937,0.43307,0.3937,0.44094,0.3937,0.44882,0.3937,0.45669,0.3937,0.46457,0.3937,0.47244,0.3937,0.48031,0.3937,0.48819,0.3937,0.49606,0.3937,0.50394,0.3937,0.51181,0.3937,0.51969,0.3937,0.52756,0.3937,0.53543,0.3937,0.54331,0.3937,0.55118,0.3937,0.55906,0.3937,0.56693,0.3937,0.5748,0.3937,0.58268,0.3937,0.59055,0.3937,0.59843,0.3937,0.6063,0.3937,0.61417,0.3937,0.62205,0.3937,0.62992,0.3937,0.6378,0.3937,0.64567,0.3937,0.65354,0.3937,0.66142,0.3937,0.66929,0.3937,0.67717,0.3937,0.68504,0.3937,0.69291,0.3937,0.70079,0.3937,0.70866,0.3937,0.71654,0.3937,0.72441,0.3937,0.73228,0.3937,0.74016,0.3937,0.74803,0.3937,0.75591,0.3937,0.76378,0.3937,0.77165,0.3937,0.77953,0.3937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_66()
		{
			double[] value = {0.7874,0.3937,0.79528,0.3937,0.80315,0.3937,0.81102,0.3937,0.8189,0.3937,0.82677,0.3937,0.83465,0.3937,0.84252,0.3937,0.85039,0.3937,0.85827,0.3937,0.86614,0.3937,0.87402,0.3937,0.88189,0.3937,0.88976,0.3937,0.89764,0.3937,0.90551,0.3937,0.91339,0.3937,0.92126,0.3937,0.92913,0.3937,0.93701,0.3937,0.94488,0.3937,0.95276,0.3937,0.96063,0.3937,0.9685,0.3937,0.97638,0.3937,0.98425,0.3937,0.99213,0.3937,0.99609,0.3937,0.00391,0.40157,0.00787,0.40157,0.01575,0.40157,0.02362,0.40157,0.0315,0.40157,0.03937,0.40157,0.04724,0.40157,0.05512,0.40157,0.06299,0.40157,0.07087,0.40157,0.07874,0.40157,0.08661,0.40157,0.09449,0.40157,0.10236,0.40157,0.11024,0.40157,0.11811,0.40157,0.12598,0.40157,0.13386,0.40157,0.14173,0.40157,0.14961,0.40157,0.15748,0.40157,0.16535,0.40157,0.17323,0.40157,0.1811,0.40157,0.18898,0.40157,0.19685,0.40157,0.20472,0.40157,0.2126,0.40157,0.22047,0.40157,0.22835,0.40157,0.23622,0.40157,0.24409,0.40157,0.25197,0.40157,0.25984,0.40157,0.26772,0.40157,0.27559,0.40157,0.28346,0.40157,0.29134,0.40157,0.29921,0.40157,0.30709,0.40157,0.31496,0.40157,0.32283,0.40157,0.33071,0.40157,0.33858,0.40157,0.34646,0.40157,0.35433,0.40157,0.3622,0.40157,0.37008,0.40157,0.37795,0.40157,0.38583,0.40157,0.3937,0.40157,0.40157,0.40157,0.40945,0.40157,0.41732,0.40157,0.4252,0.40157,0.43307,0.40157,0.44094,0.40157,0.44882,0.40157,0.45669,0.40157,0.46457,0.40157,0.47244,0.40157,0.48031,0.40157,0.48819,0.40157,0.49606,0.40157,0.50394,0.40157,0.51181,0.40157,0.51969,0.40157,0.52756,0.40157,0.53543,0.40157,0.54331,0.40157,0.55118,0.40157,0.55906,0.40157};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_67()
		{
			double[] value = {0.56693,0.40157,0.5748,0.40157,0.58268,0.40157,0.59055,0.40157,0.59843,0.40157,0.6063,0.40157,0.61417,0.40157,0.62205,0.40157,0.62992,0.40157,0.6378,0.40157,0.64567,0.40157,0.65354,0.40157,0.66142,0.40157,0.66929,0.40157,0.67717,0.40157,0.68504,0.40157,0.69291,0.40157,0.70079,0.40157,0.70866,0.40157,0.71654,0.40157,0.72441,0.40157,0.73228,0.40157,0.74016,0.40157,0.74803,0.40157,0.75591,0.40157,0.76378,0.40157,0.77165,0.40157,0.77953,0.40157,0.7874,0.40157,0.79528,0.40157,0.80315,0.40157,0.81102,0.40157,0.8189,0.40157,0.82677,0.40157,0.83465,0.40157,0.84252,0.40157,0.85039,0.40157,0.85827,0.40157,0.86614,0.40157,0.87402,0.40157,0.88189,0.40157,0.88976,0.40157,0.89764,0.40157,0.90551,0.40157,0.91339,0.40157,0.92126,0.40157,0.92913,0.40157,0.93701,0.40157,0.94488,0.40157,0.95276,0.40157,0.96063,0.40157,0.9685,0.40157,0.97638,0.40157,0.98425,0.40157,0.99213,0.40157,0.99609,0.40157,0.00391,0.40945,0.00787,0.40945,0.01575,0.40945,0.02362,0.40945,0.0315,0.40945,0.03937,0.40945,0.04724,0.40945,0.05512,0.40945,0.06299,0.40945,0.07087,0.40945,0.07874,0.40945,0.08661,0.40945,0.09449,0.40945,0.10236,0.40945,0.11024,0.40945,0.11811,0.40945,0.12598,0.40945,0.13386,0.40945,0.14173,0.40945,0.14961,0.40945,0.15748,0.40945,0.16535,0.40945,0.17323,0.40945,0.1811,0.40945,0.18898,0.40945,0.19685,0.40945,0.20472,0.40945,0.2126,0.40945,0.22047,0.40945,0.22835,0.40945,0.23622,0.40945,0.24409,0.40945,0.25197,0.40945,0.25984,0.40945,0.26772,0.40945,0.27559,0.40945,0.28346,0.40945,0.29134,0.40945,0.29921,0.40945,0.30709,0.40945,0.31496,0.40945,0.32283,0.40945,0.33071,0.40945,0.33858,0.40945};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_68()
		{
			double[] value = {0.34646,0.40945,0.35433,0.40945,0.3622,0.40945,0.37008,0.40945,0.37795,0.40945,0.38583,0.40945,0.3937,0.40945,0.40157,0.40945,0.40945,0.40945,0.41732,0.40945,0.4252,0.40945,0.43307,0.40945,0.44094,0.40945,0.44882,0.40945,0.45669,0.40945,0.46457,0.40945,0.47244,0.40945,0.48031,0.40945,0.48819,0.40945,0.49606,0.40945,0.50394,0.40945,0.51181,0.40945,0.51969,0.40945,0.52756,0.40945,0.53543,0.40945,0.54331,0.40945,0.55118,0.40945,0.55906,0.40945,0.56693,0.40945,0.5748,0.40945,0.58268,0.40945,0.59055,0.40945,0.59843,0.40945,0.6063,0.40945,0.61417,0.40945,0.62205,0.40945,0.62992,0.40945,0.6378,0.40945,0.64567,0.40945,0.65354,0.40945,0.66142,0.40945,0.66929,0.40945,0.67717,0.40945,0.68504,0.40945,0.69291,0.40945,0.70079,0.40945,0.70866,0.40945,0.71654,0.40945,0.72441,0.40945,0.73228,0.40945,0.74016,0.40945,0.74803,0.40945,0.75591,0.40945,0.76378,0.40945,0.77165,0.40945,0.77953,0.40945,0.7874,0.40945,0.79528,0.40945,0.80315,0.40945,0.81102,0.40945,0.8189,0.40945,0.82677,0.40945,0.83465,0.40945,0.84252,0.40945,0.85039,0.40945,0.85827,0.40945,0.86614,0.40945,0.87402,0.40945,0.88189,0.40945,0.88976,0.40945,0.89764,0.40945,0.90551,0.40945,0.91339,0.40945,0.92126,0.40945,0.92913,0.40945,0.93701,0.40945,0.94488,0.40945,0.95276,0.40945,0.96063,0.40945,0.9685,0.40945,0.97638,0.40945,0.98425,0.40945,0.99213,0.40945,0.99609,0.40945,0.00391,0.41732,0.00787,0.41732,0.01575,0.41732,0.02362,0.41732,0.0315,0.41732,0.03937,0.41732,0.04724,0.41732,0.05512,0.41732,0.06299,0.41732,0.07087,0.41732,0.07874,0.41732,0.08661,0.41732,0.09449,0.41732,0.10236,0.41732,0.11024,0.41732,0.11811,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_69()
		{
			double[] value = {0.12598,0.41732,0.13386,0.41732,0.14173,0.41732,0.14961,0.41732,0.15748,0.41732,0.16535,0.41732,0.17323,0.41732,0.1811,0.41732,0.18898,0.41732,0.19685,0.41732,0.20472,0.41732,0.2126,0.41732,0.22047,0.41732,0.22835,0.41732,0.23622,0.41732,0.24409,0.41732,0.25197,0.41732,0.25984,0.41732,0.26772,0.41732,0.27559,0.41732,0.28346,0.41732,0.29134,0.41732,0.29921,0.41732,0.30709,0.41732,0.31496,0.41732,0.32283,0.41732,0.33071,0.41732,0.33858,0.41732,0.34646,0.41732,0.35433,0.41732,0.3622,0.41732,0.37008,0.41732,0.37795,0.41732,0.38583,0.41732,0.3937,0.41732,0.40157,0.41732,0.40945,0.41732,0.41732,0.41732,0.4252,0.41732,0.43307,0.41732,0.44094,0.41732,0.44882,0.41732,0.45669,0.41732,0.46457,0.41732,0.47244,0.41732,0.48031,0.41732,0.48819,0.41732,0.49606,0.41732,0.50394,0.41732,0.51181,0.41732,0.51969,0.41732,0.52756,0.41732,0.53543,0.41732,0.54331,0.41732,0.55118,0.41732,0.55906,0.41732,0.56693,0.41732,0.5748,0.41732,0.58268,0.41732,0.59055,0.41732,0.59843,0.41732,0.6063,0.41732,0.61417,0.41732,0.62205,0.41732,0.62992,0.41732,0.6378,0.41732,0.64567,0.41732,0.65354,0.41732,0.66142,0.41732,0.66929,0.41732,0.67717,0.41732,0.68504,0.41732,0.69291,0.41732,0.70079,0.41732,0.70866,0.41732,0.71654,0.41732,0.72441,0.41732,0.73228,0.41732,0.74016,0.41732,0.74803,0.41732,0.75591,0.41732,0.76378,0.41732,0.77165,0.41732,0.77953,0.41732,0.7874,0.41732,0.79528,0.41732,0.80315,0.41732,0.81102,0.41732,0.8189,0.41732,0.82677,0.41732,0.83465,0.41732,0.84252,0.41732,0.85039,0.41732,0.85827,0.41732,0.86614,0.41732,0.87402,0.41732,0.88189,0.41732,0.88976,0.41732,0.89764,0.41732,0.90551,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_70()
		{
			double[] value = {0.91339,0.41732,0.92126,0.41732,0.92913,0.41732,0.93701,0.41732,0.94488,0.41732,0.95276,0.41732,0.96063,0.41732,0.9685,0.41732,0.97638,0.41732,0.98425,0.41732,0.99213,0.41732,0.99609,0.41732,0.00391,0.4252,0.00787,0.4252,0.01575,0.4252,0.02362,0.4252,0.0315,0.4252,0.03937,0.4252,0.04724,0.4252,0.05512,0.4252,0.06299,0.4252,0.07087,0.4252,0.07874,0.4252,0.08661,0.4252,0.09449,0.4252,0.10236,0.4252,0.11024,0.4252,0.11811,0.4252,0.12598,0.4252,0.13386,0.4252,0.14173,0.4252,0.14961,0.4252,0.15748,0.4252,0.16535,0.4252,0.17323,0.4252,0.1811,0.4252,0.18898,0.4252,0.19685,0.4252,0.20472,0.4252,0.2126,0.4252,0.22047,0.4252,0.22835,0.4252,0.23622,0.4252,0.24409,0.4252,0.25197,0.4252,0.25984,0.4252,0.26772,0.4252,0.27559,0.4252,0.28346,0.4252,0.29134,0.4252,0.29921,0.4252,0.30709,0.4252,0.31496,0.4252,0.32283,0.4252,0.33071,0.4252,0.33858,0.4252,0.34646,0.4252,0.35433,0.4252,0.3622,0.4252,0.37008,0.4252,0.37795,0.4252,0.38583,0.4252,0.3937,0.4252,0.40157,0.4252,0.40945,0.4252,0.41732,0.4252,0.4252,0.4252,0.43307,0.4252,0.44094,0.4252,0.44882,0.4252,0.45669,0.4252,0.46457,0.4252,0.47244,0.4252,0.48031,0.4252,0.48819,0.4252,0.49606,0.4252,0.50394,0.4252,0.51181,0.4252,0.51969,0.4252,0.52756,0.4252,0.53543,0.4252,0.54331,0.4252,0.55118,0.4252,0.55906,0.4252,0.56693,0.4252,0.5748,0.4252,0.58268,0.4252,0.59055,0.4252,0.59843,0.4252,0.6063,0.4252,0.61417,0.4252,0.62205,0.4252,0.62992,0.4252,0.6378,0.4252,0.64567,0.4252,0.65354,0.4252,0.66142,0.4252,0.66929,0.4252,0.67717,0.4252,0.68504,0.4252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_71()
		{
			double[] value = {0.69291,0.4252,0.70079,0.4252,0.70866,0.4252,0.71654,0.4252,0.72441,0.4252,0.73228,0.4252,0.74016,0.4252,0.74803,0.4252,0.75591,0.4252,0.76378,0.4252,0.77165,0.4252,0.77953,0.4252,0.7874,0.4252,0.79528,0.4252,0.80315,0.4252,0.81102,0.4252,0.8189,0.4252,0.82677,0.4252,0.83465,0.4252,0.84252,0.4252,0.85039,0.4252,0.85827,0.4252,0.86614,0.4252,0.87402,0.4252,0.88189,0.4252,0.88976,0.4252,0.89764,0.4252,0.90551,0.4252,0.91339,0.4252,0.92126,0.4252,0.92913,0.4252,0.93701,0.4252,0.94488,0.4252,0.95276,0.4252,0.96063,0.4252,0.9685,0.4252,0.97638,0.4252,0.98425,0.4252,0.99213,0.4252,0.99609,0.4252,0.00391,0.43307,0.00787,0.43307,0.01575,0.43307,0.02362,0.43307,0.0315,0.43307,0.03937,0.43307,0.04724,0.43307,0.05512,0.43307,0.06299,0.43307,0.07087,0.43307,0.07874,0.43307,0.08661,0.43307,0.09449,0.43307,0.10236,0.43307,0.11024,0.43307,0.11811,0.43307,0.12598,0.43307,0.13386,0.43307,0.14173,0.43307,0.14961,0.43307,0.15748,0.43307,0.16535,0.43307,0.17323,0.43307,0.1811,0.43307,0.18898,0.43307,0.19685,0.43307,0.20472,0.43307,0.2126,0.43307,0.22047,0.43307,0.22835,0.43307,0.23622,0.43307,0.24409,0.43307,0.25197,0.43307,0.25984,0.43307,0.26772,0.43307,0.27559,0.43307,0.28346,0.43307,0.29134,0.43307,0.29921,0.43307,0.30709,0.43307,0.31496,0.43307,0.32283,0.43307,0.33071,0.43307,0.33858,0.43307,0.34646,0.43307,0.35433,0.43307,0.3622,0.43307,0.37008,0.43307,0.37795,0.43307,0.38583,0.43307,0.3937,0.43307,0.40157,0.43307,0.40945,0.43307,0.41732,0.43307,0.4252,0.43307,0.43307,0.43307,0.44094,0.43307,0.44882,0.43307,0.45669,0.43307,0.46457,0.43307};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_72()
		{
			double[] value = {0.47244,0.43307,0.48031,0.43307,0.48819,0.43307,0.49606,0.43307,0.50394,0.43307,0.51181,0.43307,0.51969,0.43307,0.52756,0.43307,0.53543,0.43307,0.54331,0.43307,0.55118,0.43307,0.55906,0.43307,0.56693,0.43307,0.5748,0.43307,0.58268,0.43307,0.59055,0.43307,0.59843,0.43307,0.6063,0.43307,0.61417,0.43307,0.62205,0.43307,0.62992,0.43307,0.6378,0.43307,0.64567,0.43307,0.65354,0.43307,0.66142,0.43307,0.66929,0.43307,0.67717,0.43307,0.68504,0.43307,0.69291,0.43307,0.70079,0.43307,0.70866,0.43307,0.71654,0.43307,0.72441,0.43307,0.73228,0.43307,0.74016,0.43307,0.74803,0.43307,0.75591,0.43307,0.76378,0.43307,0.77165,0.43307,0.77953,0.43307,0.7874,0.43307,0.79528,0.43307,0.80315,0.43307,0.81102,0.43307,0.8189,0.43307,0.82677,0.43307,0.83465,0.43307,0.84252,0.43307,0.85039,0.43307,0.85827,0.43307,0.86614,0.43307,0.87402,0.43307,0.88189,0.43307,0.88976,0.43307,0.89764,0.43307,0.90551,0.43307,0.91339,0.43307,0.92126,0.43307,0.92913,0.43307,0.93701,0.43307,0.94488,0.43307,0.95276,0.43307,0.96063,0.43307,0.9685,0.43307,0.97638,0.43307,0.98425,0.43307,0.99213,0.43307,0.99609,0.43307,0.00391,0.44094,0.00787,0.44094,0.01575,0.44094,0.02362,0.44094,0.0315,0.44094,0.03937,0.44094,0.04724,0.44094,0.05512,0.44094,0.06299,0.44094,0.07087,0.44094,0.07874,0.44094,0.08661,0.44094,0.09449,0.44094,0.10236,0.44094,0.11024,0.44094,0.11811,0.44094,0.12598,0.44094,0.13386,0.44094,0.14173,0.44094,0.14961,0.44094,0.15748,0.44094,0.16535,0.44094,0.17323,0.44094,0.1811,0.44094,0.18898,0.44094,0.19685,0.44094,0.20472,0.44094,0.2126,0.44094,0.22047,0.44094,0.22835,0.44094,0.23622,0.44094,0.24409,0.44094};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_73()
		{
			double[] value = {0.25197,0.44094,0.25984,0.44094,0.26772,0.44094,0.27559,0.44094,0.28346,0.44094,0.29134,0.44094,0.29921,0.44094,0.30709,0.44094,0.31496,0.44094,0.32283,0.44094,0.33071,0.44094,0.33858,0.44094,0.34646,0.44094,0.35433,0.44094,0.3622,0.44094,0.37008,0.44094,0.37795,0.44094,0.38583,0.44094,0.3937,0.44094,0.40157,0.44094,0.40945,0.44094,0.41732,0.44094,0.4252,0.44094,0.43307,0.44094,0.44094,0.44094,0.44882,0.44094,0.45669,0.44094,0.46457,0.44094,0.47244,0.44094,0.48031,0.44094,0.48819,0.44094,0.49606,0.44094,0.50394,0.44094,0.51181,0.44094,0.51969,0.44094,0.52756,0.44094,0.53543,0.44094,0.54331,0.44094,0.55118,0.44094,0.55906,0.44094,0.56693,0.44094,0.5748,0.44094,0.58268,0.44094,0.59055,0.44094,0.59843,0.44094,0.6063,0.44094,0.61417,0.44094,0.62205,0.44094,0.62992,0.44094,0.6378,0.44094,0.64567,0.44094,0.65354,0.44094,0.66142,0.44094,0.66929,0.44094,0.67717,0.44094,0.68504,0.44094,0.69291,0.44094,0.70079,0.44094,0.70866,0.44094,0.71654,0.44094,0.72441,0.44094,0.73228,0.44094,0.74016,0.44094,0.74803,0.44094,0.75591,0.44094,0.76378,0.44094,0.77165,0.44094,0.77953,0.44094,0.7874,0.44094,0.79528,0.44094,0.80315,0.44094,0.81102,0.44094,0.8189,0.44094,0.82677,0.44094,0.83465,0.44094,0.84252,0.44094,0.85039,0.44094,0.85827,0.44094,0.86614,0.44094,0.87402,0.44094,0.88189,0.44094,0.88976,0.44094,0.89764,0.44094,0.90551,0.44094,0.91339,0.44094,0.92126,0.44094,0.92913,0.44094,0.93701,0.44094,0.94488,0.44094,0.95276,0.44094,0.96063,0.44094,0.9685,0.44094,0.97638,0.44094,0.98425,0.44094,0.99213,0.44094,0.99609,0.44094,0.00391,0.44882,0.00787,0.44882,0.01575,0.44882,0.02362,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_74()
		{
			double[] value = {0.0315,0.44882,0.03937,0.44882,0.04724,0.44882,0.05512,0.44882,0.06299,0.44882,0.07087,0.44882,0.07874,0.44882,0.08661,0.44882,0.09449,0.44882,0.10236,0.44882,0.11024,0.44882,0.11811,0.44882,0.12598,0.44882,0.13386,0.44882,0.14173,0.44882,0.14961,0.44882,0.15748,0.44882,0.16535,0.44882,0.17323,0.44882,0.1811,0.44882,0.18898,0.44882,0.19685,0.44882,0.20472,0.44882,0.2126,0.44882,0.22047,0.44882,0.22835,0.44882,0.23622,0.44882,0.24409,0.44882,0.25197,0.44882,0.25984,0.44882,0.26772,0.44882,0.27559,0.44882,0.28346,0.44882,0.29134,0.44882,0.29921,0.44882,0.30709,0.44882,0.31496,0.44882,0.32283,0.44882,0.33071,0.44882,0.33858,0.44882,0.34646,0.44882,0.35433,0.44882,0.3622,0.44882,0.37008,0.44882,0.37795,0.44882,0.38583,0.44882,0.3937,0.44882,0.40157,0.44882,0.40945,0.44882,0.41732,0.44882,0.4252,0.44882,0.43307,0.44882,0.44094,0.44882,0.44882,0.44882,0.45669,0.44882,0.46457,0.44882,0.47244,0.44882,0.48031,0.44882,0.48819,0.44882,0.49606,0.44882,0.50394,0.44882,0.51181,0.44882,0.51969,0.44882,0.52756,0.44882,0.53543,0.44882,0.54331,0.44882,0.55118,0.44882,0.55906,0.44882,0.56693,0.44882,0.5748,0.44882,0.58268,0.44882,0.59055,0.44882,0.59843,0.44882,0.6063,0.44882,0.61417,0.44882,0.62205,0.44882,0.62992,0.44882,0.6378,0.44882,0.64567,0.44882,0.65354,0.44882,0.66142,0.44882,0.66929,0.44882,0.67717,0.44882,0.68504,0.44882,0.69291,0.44882,0.70079,0.44882,0.70866,0.44882,0.71654,0.44882,0.72441,0.44882,0.73228,0.44882,0.74016,0.44882,0.74803,0.44882,0.75591,0.44882,0.76378,0.44882,0.77165,0.44882,0.77953,0.44882,0.7874,0.44882,0.79528,0.44882,0.80315,0.44882,0.81102,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_75()
		{
			double[] value = {0.8189,0.44882,0.82677,0.44882,0.83465,0.44882,0.84252,0.44882,0.85039,0.44882,0.85827,0.44882,0.86614,0.44882,0.87402,0.44882,0.88189,0.44882,0.88976,0.44882,0.89764,0.44882,0.90551,0.44882,0.91339,0.44882,0.92126,0.44882,0.92913,0.44882,0.93701,0.44882,0.94488,0.44882,0.95276,0.44882,0.96063,0.44882,0.9685,0.44882,0.97638,0.44882,0.98425,0.44882,0.99213,0.44882,0.99609,0.44882,0.00391,0.45669,0.00787,0.45669,0.01575,0.45669,0.02362,0.45669,0.0315,0.45669,0.03937,0.45669,0.04724,0.45669,0.05512,0.45669,0.06299,0.45669,0.07087,0.45669,0.07874,0.45669,0.08661,0.45669,0.09449,0.45669,0.10236,0.45669,0.11024,0.45669,0.11811,0.45669,0.12598,0.45669,0.13386,0.45669,0.14173,0.45669,0.14961,0.45669,0.15748,0.45669,0.16535,0.45669,0.17323,0.45669,0.1811,0.45669,0.18898,0.45669,0.19685,0.45669,0.20472,0.45669,0.2126,0.45669,0.22047,0.45669,0.22835,0.45669,0.23622,0.45669,0.24409,0.45669,0.25197,0.45669,0.25984,0.45669,0.26772,0.45669,0.27559,0.45669,0.28346,0.45669,0.29134,0.45669,0.29921,0.45669,0.30709,0.45669,0.31496,0.45669,0.32283,0.45669,0.33071,0.45669,0.33858,0.45669,0.34646,0.45669,0.35433,0.45669,0.3622,0.45669,0.37008,0.45669,0.37795,0.45669,0.38583,0.45669,0.3937,0.45669,0.40157,0.45669,0.40945,0.45669,0.41732,0.45669,0.4252,0.45669,0.43307,0.45669,0.44094,0.45669,0.44882,0.45669,0.45669,0.45669,0.46457,0.45669,0.47244,0.45669,0.48031,0.45669,0.48819,0.45669,0.49606,0.45669,0.50394,0.45669,0.51181,0.45669,0.51969,0.45669,0.52756,0.45669,0.53543,0.45669,0.54331,0.45669,0.55118,0.45669,0.55906,0.45669,0.56693,0.45669,0.5748,0.45669,0.58268,0.45669,0.59055,0.45669};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_76()
		{
			double[] value = {0.59843,0.45669,0.6063,0.45669,0.61417,0.45669,0.62205,0.45669,0.62992,0.45669,0.6378,0.45669,0.64567,0.45669,0.65354,0.45669,0.66142,0.45669,0.66929,0.45669,0.67717,0.45669,0.68504,0.45669,0.69291,0.45669,0.70079,0.45669,0.70866,0.45669,0.71654,0.45669,0.72441,0.45669,0.73228,0.45669,0.74016,0.45669,0.74803,0.45669,0.75591,0.45669,0.76378,0.45669,0.77165,0.45669,0.77953,0.45669,0.7874,0.45669,0.79528,0.45669,0.80315,0.45669,0.81102,0.45669,0.8189,0.45669,0.82677,0.45669,0.83465,0.45669,0.84252,0.45669,0.85039,0.45669,0.85827,0.45669,0.86614,0.45669,0.87402,0.45669,0.88189,0.45669,0.88976,0.45669,0.89764,0.45669,0.90551,0.45669,0.91339,0.45669,0.92126,0.45669,0.92913,0.45669,0.93701,0.45669,0.94488,0.45669,0.95276,0.45669,0.96063,0.45669,0.9685,0.45669,0.97638,0.45669,0.98425,0.45669,0.99213,0.45669,0.99609,0.45669,0.00391,0.46457,0.00787,0.46457,0.01575,0.46457,0.02362,0.46457,0.0315,0.46457,0.03937,0.46457,0.04724,0.46457,0.05512,0.46457,0.06299,0.46457,0.07087,0.46457,0.07874,0.46457,0.08661,0.46457,0.09449,0.46457,0.10236,0.46457,0.11024,0.46457,0.11811,0.46457,0.12598,0.46457,0.13386,0.46457,0.14173,0.46457,0.14961,0.46457,0.15748,0.46457,0.16535,0.46457,0.17323,0.46457,0.1811,0.46457,0.18898,0.46457,0.19685,0.46457,0.20472,0.46457,0.2126,0.46457,0.22047,0.46457,0.22835,0.46457,0.23622,0.46457,0.24409,0.46457,0.25197,0.46457,0.25984,0.46457,0.26772,0.46457,0.27559,0.46457,0.28346,0.46457,0.29134,0.46457,0.29921,0.46457,0.30709,0.46457,0.31496,0.46457,0.32283,0.46457,0.33071,0.46457,0.33858,0.46457,0.34646,0.46457,0.35433,0.46457,0.3622,0.46457,0.37008,0.46457};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_77()
		{
			double[] value = {0.37795,0.46457,0.38583,0.46457,0.3937,0.46457,0.40157,0.46457,0.40945,0.46457,0.41732,0.46457,0.4252,0.46457,0.43307,0.46457,0.44094,0.46457,0.44882,0.46457,0.45669,0.46457,0.46457,0.46457,0.47244,0.46457,0.48031,0.46457,0.48819,0.46457,0.49606,0.46457,0.50394,0.46457,0.51181,0.46457,0.51969,0.46457,0.52756,0.46457,0.53543,0.46457,0.54331,0.46457,0.55118,0.46457,0.55906,0.46457,0.56693,0.46457,0.5748,0.46457,0.58268,0.46457,0.59055,0.46457,0.59843,0.46457,0.6063,0.46457,0.61417,0.46457,0.62205,0.46457,0.62992,0.46457,0.6378,0.46457,0.64567,0.46457,0.65354,0.46457,0.66142,0.46457,0.66929,0.46457,0.67717,0.46457,0.68504,0.46457,0.69291,0.46457,0.70079,0.46457,0.70866,0.46457,0.71654,0.46457,0.72441,0.46457,0.73228,0.46457,0.74016,0.46457,0.74803,0.46457,0.75591,0.46457,0.76378,0.46457,0.77165,0.46457,0.77953,0.46457,0.7874,0.46457,0.79528,0.46457,0.80315,0.46457,0.81102,0.46457,0.8189,0.46457,0.82677,0.46457,0.83465,0.46457,0.84252,0.46457,0.85039,0.46457,0.85827,0.46457,0.86614,0.46457,0.87402,0.46457,0.88189,0.46457,0.88976,0.46457,0.89764,0.46457,0.90551,0.46457,0.91339,0.46457,0.92126,0.46457,0.92913,0.46457,0.93701,0.46457,0.94488,0.46457,0.95276,0.46457,0.96063,0.46457,0.9685,0.46457,0.97638,0.46457,0.98425,0.46457,0.99213,0.46457,0.99609,0.46457,0.00391,0.47244,0.00787,0.47244,0.01575,0.47244,0.02362,0.47244,0.0315,0.47244,0.03937,0.47244,0.04724,0.47244,0.05512,0.47244,0.06299,0.47244,0.07087,0.47244,0.07874,0.47244,0.08661,0.47244,0.09449,0.47244,0.10236,0.47244,0.11024,0.47244,0.11811,0.47244,0.12598,0.47244,0.13386,0.47244,0.14173,0.47244,0.14961,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_78()
		{
			double[] value = {0.15748,0.47244,0.16535,0.47244,0.17323,0.47244,0.1811,0.47244,0.18898,0.47244,0.19685,0.47244,0.20472,0.47244,0.2126,0.47244,0.22047,0.47244,0.22835,0.47244,0.23622,0.47244,0.24409,0.47244,0.25197,0.47244,0.25984,0.47244,0.26772,0.47244,0.27559,0.47244,0.28346,0.47244,0.29134,0.47244,0.29921,0.47244,0.30709,0.47244,0.31496,0.47244,0.32283,0.47244,0.33071,0.47244,0.33858,0.47244,0.34646,0.47244,0.35433,0.47244,0.3622,0.47244,0.37008,0.47244,0.37795,0.47244,0.38583,0.47244,0.3937,0.47244,0.40157,0.47244,0.40945,0.47244,0.41732,0.47244,0.4252,0.47244,0.43307,0.47244,0.44094,0.47244,0.44882,0.47244,0.45669,0.47244,0.46457,0.47244,0.47244,0.47244,0.48031,0.47244,0.48819,0.47244,0.49606,0.47244,0.50394,0.47244,0.51181,0.47244,0.51969,0.47244,0.52756,0.47244,0.53543,0.47244,0.54331,0.47244,0.55118,0.47244,0.55906,0.47244,0.56693,0.47244,0.5748,0.47244,0.58268,0.47244,0.59055,0.47244,0.59843,0.47244,0.6063,0.47244,0.61417,0.47244,0.62205,0.47244,0.62992,0.47244,0.6378,0.47244,0.64567,0.47244,0.65354,0.47244,0.66142,0.47244,0.66929,0.47244,0.67717,0.47244,0.68504,0.47244,0.69291,0.47244,0.70079,0.47244,0.70866,0.47244,0.71654,0.47244,0.72441,0.47244,0.73228,0.47244,0.74016,0.47244,0.74803,0.47244,0.75591,0.47244,0.76378,0.47244,0.77165,0.47244,0.77953,0.47244,0.7874,0.47244,0.79528,0.47244,0.80315,0.47244,0.81102,0.47244,0.8189,0.47244,0.82677,0.47244,0.83465,0.47244,0.84252,0.47244,0.85039,0.47244,0.85827,0.47244,0.86614,0.47244,0.87402,0.47244,0.88189,0.47244,0.88976,0.47244,0.89764,0.47244,0.90551,0.47244,0.91339,0.47244,0.92126,0.47244,0.92913,0.47244,0.93701,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_79()
		{
			double[] value = {0.94488,0.47244,0.95276,0.47244,0.96063,0.47244,0.9685,0.47244,0.97638,0.47244,0.98425,0.47244,0.99213,0.47244,0.99609,0.47244,0.00391,0.48031,0.00787,0.48031,0.01575,0.48031,0.02362,0.48031,0.0315,0.48031,0.03937,0.48031,0.04724,0.48031,0.05512,0.48031,0.06299,0.48031,0.07087,0.48031,0.07874,0.48031,0.08661,0.48031,0.09449,0.48031,0.10236,0.48031,0.11024,0.48031,0.11811,0.48031,0.12598,0.48031,0.13386,0.48031,0.14173,0.48031,0.14961,0.48031,0.15748,0.48031,0.16535,0.48031,0.17323,0.48031,0.1811,0.48031,0.18898,0.48031,0.19685,0.48031,0.20472,0.48031,0.2126,0.48031,0.22047,0.48031,0.22835,0.48031,0.23622,0.48031,0.24409,0.48031,0.25197,0.48031,0.25984,0.48031,0.26772,0.48031,0.27559,0.48031,0.28346,0.48031,0.29134,0.48031,0.29921,0.48031,0.30709,0.48031,0.31496,0.48031,0.32283,0.48031,0.33071,0.48031,0.33858,0.48031,0.34646,0.48031,0.35433,0.48031,0.3622,0.48031,0.37008,0.48031,0.37795,0.48031,0.38583,0.48031,0.3937,0.48031,0.40157,0.48031,0.40945,0.48031,0.41732,0.48031,0.4252,0.48031,0.43307,0.48031,0.44094,0.48031,0.44882,0.48031,0.45669,0.48031,0.46457,0.48031,0.47244,0.48031,0.48031,0.48031,0.48819,0.48031,0.49606,0.48031,0.50394,0.48031,0.51181,0.48031,0.51969,0.48031,0.52756,0.48031,0.53543,0.48031,0.54331,0.48031,0.55118,0.48031,0.55906,0.48031,0.56693,0.48031,0.5748,0.48031,0.58268,0.48031,0.59055,0.48031,0.59843,0.48031,0.6063,0.48031,0.61417,0.48031,0.62205,0.48031,0.62992,0.48031,0.6378,0.48031,0.64567,0.48031,0.65354,0.48031,0.66142,0.48031,0.66929,0.48031,0.67717,0.48031,0.68504,0.48031,0.69291,0.48031,0.70079,0.48031,0.70866,0.48031,0.71654,0.48031};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_80()
		{
			double[] value = {0.72441,0.48031,0.73228,0.48031,0.74016,0.48031,0.74803,0.48031,0.75591,0.48031,0.76378,0.48031,0.77165,0.48031,0.77953,0.48031,0.7874,0.48031,0.79528,0.48031,0.80315,0.48031,0.81102,0.48031,0.8189,0.48031,0.82677,0.48031,0.83465,0.48031,0.84252,0.48031,0.85039,0.48031,0.85827,0.48031,0.86614,0.48031,0.87402,0.48031,0.88189,0.48031,0.88976,0.48031,0.89764,0.48031,0.90551,0.48031,0.91339,0.48031,0.92126,0.48031,0.92913,0.48031,0.93701,0.48031,0.94488,0.48031,0.95276,0.48031,0.96063,0.48031,0.9685,0.48031,0.97638,0.48031,0.98425,0.48031,0.99213,0.48031,0.99609,0.48031,0.00391,0.48819,0.00787,0.48819,0.01575,0.48819,0.02362,0.48819,0.0315,0.48819,0.03937,0.48819,0.04724,0.48819,0.05512,0.48819,0.06299,0.48819,0.07087,0.48819,0.07874,0.48819,0.08661,0.48819,0.09449,0.48819,0.10236,0.48819,0.11024,0.48819,0.11811,0.48819,0.12598,0.48819,0.13386,0.48819,0.14173,0.48819,0.14961,0.48819,0.15748,0.48819,0.16535,0.48819,0.17323,0.48819,0.1811,0.48819,0.18898,0.48819,0.19685,0.48819,0.20472,0.48819,0.2126,0.48819,0.22047,0.48819,0.22835,0.48819,0.23622,0.48819,0.24409,0.48819,0.25197,0.48819,0.25984,0.48819,0.26772,0.48819,0.27559,0.48819,0.28346,0.48819,0.29134,0.48819,0.29921,0.48819,0.30709,0.48819,0.31496,0.48819,0.32283,0.48819,0.33071,0.48819,0.33858,0.48819,0.34646,0.48819,0.35433,0.48819,0.3622,0.48819,0.37008,0.48819,0.37795,0.48819,0.38583,0.48819,0.3937,0.48819,0.40157,0.48819,0.40945,0.48819,0.41732,0.48819,0.4252,0.48819,0.43307,0.48819,0.44094,0.48819,0.44882,0.48819,0.45669,0.48819,0.46457,0.48819,0.47244,0.48819,0.48031,0.48819,0.48819,0.48819,0.49606,0.48819};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_81()
		{
			double[] value = {0.50394,0.48819,0.51181,0.48819,0.51969,0.48819,0.52756,0.48819,0.53543,0.48819,0.54331,0.48819,0.55118,0.48819,0.55906,0.48819,0.56693,0.48819,0.5748,0.48819,0.58268,0.48819,0.59055,0.48819,0.59843,0.48819,0.6063,0.48819,0.61417,0.48819,0.62205,0.48819,0.62992,0.48819,0.6378,0.48819,0.64567,0.48819,0.65354,0.48819,0.66142,0.48819,0.66929,0.48819,0.67717,0.48819,0.68504,0.48819,0.69291,0.48819,0.70079,0.48819,0.70866,0.48819,0.71654,0.48819,0.72441,0.48819,0.73228,0.48819,0.74016,0.48819,0.74803,0.48819,0.75591,0.48819,0.76378,0.48819,0.77165,0.48819,0.77953,0.48819,0.7874,0.48819,0.79528,0.48819,0.80315,0.48819,0.81102,0.48819,0.8189,0.48819,0.82677,0.48819,0.83465,0.48819,0.84252,0.48819,0.85039,0.48819,0.85827,0.48819,0.86614,0.48819,0.87402,0.48819,0.88189,0.48819,0.88976,0.48819,0.89764,0.48819,0.90551,0.48819,0.91339,0.48819,0.92126,0.48819,0.92913,0.48819,0.93701,0.48819,0.94488,0.48819,0.95276,0.48819,0.96063,0.48819,0.9685,0.48819,0.97638,0.48819,0.98425,0.48819,0.99213,0.48819,0.99609,0.48819,0.00391,0.49606,0.00787,0.49606,0.01575,0.49606,0.02362,0.49606,0.0315,0.49606,0.03937,0.49606,0.04724,0.49606,0.05512,0.49606,0.06299,0.49606,0.07087,0.49606,0.07874,0.49606,0.08661,0.49606,0.09449,0.49606,0.10236,0.49606,0.11024,0.49606,0.11811,0.49606,0.12598,0.49606,0.13386,0.49606,0.14173,0.49606,0.14961,0.49606,0.15748,0.49606,0.16535,0.49606,0.17323,0.49606,0.1811,0.49606,0.18898,0.49606,0.19685,0.49606,0.20472,0.49606,0.2126,0.49606,0.22047,0.49606,0.22835,0.49606,0.23622,0.49606,0.24409,0.49606,0.25197,0.49606,0.25984,0.49606,0.26772,0.49606,0.27559,0.49606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_82()
		{
			double[] value = {0.28346,0.49606,0.29134,0.49606,0.29921,0.49606,0.30709,0.49606,0.31496,0.49606,0.32283,0.49606,0.33071,0.49606,0.33858,0.49606,0.34646,0.49606,0.35433,0.49606,0.3622,0.49606,0.37008,0.49606,0.37795,0.49606,0.38583,0.49606,0.3937,0.49606,0.40157,0.49606,0.40945,0.49606,0.41732,0.49606,0.4252,0.49606,0.43307,0.49606,0.44094,0.49606,0.44882,0.49606,0.45669,0.49606,0.46457,0.49606,0.47244,0.49606,0.48031,0.49606,0.48819,0.49606,0.49606,0.49606,0.50394,0.49606,0.51181,0.49606,0.51969,0.49606,0.52756,0.49606,0.53543,0.49606,0.54331,0.49606,0.55118,0.49606,0.55906,0.49606,0.56693,0.49606,0.5748,0.49606,0.58268,0.49606,0.59055,0.49606,0.59843,0.49606,0.6063,0.49606,0.61417,0.49606,0.62205,0.49606,0.62992,0.49606,0.6378,0.49606,0.64567,0.49606,0.65354,0.49606,0.66142,0.49606,0.66929,0.49606,0.67717,0.49606,0.68504,0.49606,0.69291,0.49606,0.70079,0.49606,0.70866,0.49606,0.71654,0.49606,0.72441,0.49606,0.73228,0.49606,0.74016,0.49606,0.74803,0.49606,0.75591,0.49606,0.76378,0.49606,0.77165,0.49606,0.77953,0.49606,0.7874,0.49606,0.79528,0.49606,0.80315,0.49606,0.81102,0.49606,0.8189,0.49606,0.82677,0.49606,0.83465,0.49606,0.84252,0.49606,0.85039,0.49606,0.85827,0.49606,0.86614,0.49606,0.87402,0.49606,0.88189,0.49606,0.88976,0.49606,0.89764,0.49606,0.90551,0.49606,0.91339,0.49606,0.92126,0.49606,0.92913,0.49606,0.93701,0.49606,0.94488,0.49606,0.95276,0.49606,0.96063,0.49606,0.9685,0.49606,0.97638,0.49606,0.98425,0.49606,0.99213,0.49606,0.99609,0.49606,0.00391,0.50394,0.00787,0.50394,0.01575,0.50394,0.02362,0.50394,0.0315,0.50394,0.03937,0.50394,0.04724,0.50394,0.05512,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_83()
		{
			double[] value = {0.06299,0.50394,0.07087,0.50394,0.07874,0.50394,0.08661,0.50394,0.09449,0.50394,0.10236,0.50394,0.11024,0.50394,0.11811,0.50394,0.12598,0.50394,0.13386,0.50394,0.14173,0.50394,0.14961,0.50394,0.15748,0.50394,0.16535,0.50394,0.17323,0.50394,0.1811,0.50394,0.18898,0.50394,0.19685,0.50394,0.20472,0.50394,0.2126,0.50394,0.22047,0.50394,0.22835,0.50394,0.23622,0.50394,0.24409,0.50394,0.25197,0.50394,0.25984,0.50394,0.26772,0.50394,0.27559,0.50394,0.28346,0.50394,0.29134,0.50394,0.29921,0.50394,0.30709,0.50394,0.31496,0.50394,0.32283,0.50394,0.33071,0.50394,0.33858,0.50394,0.34646,0.50394,0.35433,0.50394,0.3622,0.50394,0.37008,0.50394,0.37795,0.50394,0.38583,0.50394,0.3937,0.50394,0.40157,0.50394,0.40945,0.50394,0.41732,0.50394,0.4252,0.50394,0.43307,0.50394,0.44094,0.50394,0.44882,0.50394,0.45669,0.50394,0.46457,0.50394,0.47244,0.50394,0.48031,0.50394,0.48819,0.50394,0.49606,0.50394,0.50394,0.50394,0.51181,0.50394,0.51969,0.50394,0.52756,0.50394,0.53543,0.50394,0.54331,0.50394,0.55118,0.50394,0.55906,0.50394,0.56693,0.50394,0.5748,0.50394,0.58268,0.50394,0.59055,0.50394,0.59843,0.50394,0.6063,0.50394,0.61417,0.50394,0.62205,0.50394,0.62992,0.50394,0.6378,0.50394,0.64567,0.50394,0.65354,0.50394,0.66142,0.50394,0.66929,0.50394,0.67717,0.50394,0.68504,0.50394,0.69291,0.50394,0.70079,0.50394,0.70866,0.50394,0.71654,0.50394,0.72441,0.50394,0.73228,0.50394,0.74016,0.50394,0.74803,0.50394,0.75591,0.50394,0.76378,0.50394,0.77165,0.50394,0.77953,0.50394,0.7874,0.50394,0.79528,0.50394,0.80315,0.50394,0.81102,0.50394,0.8189,0.50394,0.82677,0.50394,0.83465,0.50394,0.84252,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_84()
		{
			double[] value = {0.85039,0.50394,0.85827,0.50394,0.86614,0.50394,0.87402,0.50394,0.88189,0.50394,0.88976,0.50394,0.89764,0.50394,0.90551,0.50394,0.91339,0.50394,0.92126,0.50394,0.92913,0.50394,0.93701,0.50394,0.94488,0.50394,0.95276,0.50394,0.96063,0.50394,0.9685,0.50394,0.97638,0.50394,0.98425,0.50394,0.99213,0.50394,0.99609,0.50394,0.00391,0.51181,0.00787,0.51181,0.01575,0.51181,0.02362,0.51181,0.0315,0.51181,0.03937,0.51181,0.04724,0.51181,0.05512,0.51181,0.06299,0.51181,0.07087,0.51181,0.07874,0.51181,0.08661,0.51181,0.09449,0.51181,0.10236,0.51181,0.11024,0.51181,0.11811,0.51181,0.12598,0.51181,0.13386,0.51181,0.14173,0.51181,0.14961,0.51181,0.15748,0.51181,0.16535,0.51181,0.17323,0.51181,0.1811,0.51181,0.18898,0.51181,0.19685,0.51181,0.20472,0.51181,0.2126,0.51181,0.22047,0.51181,0.22835,0.51181,0.23622,0.51181,0.24409,0.51181,0.25197,0.51181,0.25984,0.51181,0.26772,0.51181,0.27559,0.51181,0.28346,0.51181,0.29134,0.51181,0.29921,0.51181,0.30709,0.51181,0.31496,0.51181,0.32283,0.51181,0.33071,0.51181,0.33858,0.51181,0.34646,0.51181,0.35433,0.51181,0.3622,0.51181,0.37008,0.51181,0.37795,0.51181,0.38583,0.51181,0.3937,0.51181,0.40157,0.51181,0.40945,0.51181,0.41732,0.51181,0.4252,0.51181,0.43307,0.51181,0.44094,0.51181,0.44882,0.51181,0.45669,0.51181,0.46457,0.51181,0.47244,0.51181,0.48031,0.51181,0.48819,0.51181,0.49606,0.51181,0.50394,0.51181,0.51181,0.51181,0.51969,0.51181,0.52756,0.51181,0.53543,0.51181,0.54331,0.51181,0.55118,0.51181,0.55906,0.51181,0.56693,0.51181,0.5748,0.51181,0.58268,0.51181,0.59055,0.51181,0.59843,0.51181,0.6063,0.51181,0.61417,0.51181,0.62205,0.51181};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_85()
		{
			double[] value = {0.62992,0.51181,0.6378,0.51181,0.64567,0.51181,0.65354,0.51181,0.66142,0.51181,0.66929,0.51181,0.67717,0.51181,0.68504,0.51181,0.69291,0.51181,0.70079,0.51181,0.70866,0.51181,0.71654,0.51181,0.72441,0.51181,0.73228,0.51181,0.74016,0.51181,0.74803,0.51181,0.75591,0.51181,0.76378,0.51181,0.77165,0.51181,0.77953,0.51181,0.7874,0.51181,0.79528,0.51181,0.80315,0.51181,0.81102,0.51181,0.8189,0.51181,0.82677,0.51181,0.83465,0.51181,0.84252,0.51181,0.85039,0.51181,0.85827,0.51181,0.86614,0.51181,0.87402,0.51181,0.88189,0.51181,0.88976,0.51181,0.89764,0.51181,0.90551,0.51181,0.91339,0.51181,0.92126,0.51181,0.92913,0.51181,0.93701,0.51181,0.94488,0.51181,0.95276,0.51181,0.96063,0.51181,0.9685,0.51181,0.97638,0.51181,0.98425,0.51181,0.99213,0.51181,0.99609,0.51181,0.00391,0.51969,0.00787,0.51969,0.01575,0.51969,0.02362,0.51969,0.0315,0.51969,0.03937,0.51969,0.04724,0.51969,0.05512,0.51969,0.06299,0.51969,0.07087,0.51969,0.07874,0.51969,0.08661,0.51969,0.09449,0.51969,0.10236,0.51969,0.11024,0.51969,0.11811,0.51969,0.12598,0.51969,0.13386,0.51969,0.14173,0.51969,0.14961,0.51969,0.15748,0.51969,0.16535,0.51969,0.17323,0.51969,0.1811,0.51969,0.18898,0.51969,0.19685,0.51969,0.20472,0.51969,0.2126,0.51969,0.22047,0.51969,0.22835,0.51969,0.23622,0.51969,0.24409,0.51969,0.25197,0.51969,0.25984,0.51969,0.26772,0.51969,0.27559,0.51969,0.28346,0.51969,0.29134,0.51969,0.29921,0.51969,0.30709,0.51969,0.31496,0.51969,0.32283,0.51969,0.33071,0.51969,0.33858,0.51969,0.34646,0.51969,0.35433,0.51969,0.3622,0.51969,0.37008,0.51969,0.37795,0.51969,0.38583,0.51969,0.3937,0.51969,0.40157,0.51969};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_86()
		{
			double[] value = {0.40945,0.51969,0.41732,0.51969,0.4252,0.51969,0.43307,0.51969,0.44094,0.51969,0.44882,0.51969,0.45669,0.51969,0.46457,0.51969,0.47244,0.51969,0.48031,0.51969,0.48819,0.51969,0.49606,0.51969,0.50394,0.51969,0.51181,0.51969,0.51969,0.51969,0.52756,0.51969,0.53543,0.51969,0.54331,0.51969,0.55118,0.51969,0.55906,0.51969,0.56693,0.51969,0.5748,0.51969,0.58268,0.51969,0.59055,0.51969,0.59843,0.51969,0.6063,0.51969,0.61417,0.51969,0.62205,0.51969,0.62992,0.51969,0.6378,0.51969,0.64567,0.51969,0.65354,0.51969,0.66142,0.51969,0.66929,0.51969,0.67717,0.51969,0.68504,0.51969,0.69291,0.51969,0.70079,0.51969,0.70866,0.51969,0.71654,0.51969,0.72441,0.51969,0.73228,0.51969,0.74016,0.51969,0.74803,0.51969,0.75591,0.51969,0.76378,0.51969,0.77165,0.51969,0.77953,0.51969,0.7874,0.51969,0.79528,0.51969,0.80315,0.51969,0.81102,0.51969,0.8189,0.51969,0.82677,0.51969,0.83465,0.51969,0.84252,0.51969,0.85039,0.51969,0.85827,0.51969,0.86614,0.51969,0.87402,0.51969,0.88189,0.51969,0.88976,0.51969,0.89764,0.51969,0.90551,0.51969,0.91339,0.51969,0.92126,0.51969,0.92913,0.51969,0.93701,0.51969,0.94488,0.51969,0.95276,0.51969,0.96063,0.51969,0.9685,0.51969,0.97638,0.51969,0.98425,0.51969,0.99213,0.51969,0.99609,0.51969,0.00391,0.52756,0.00787,0.52756,0.01575,0.52756,0.02362,0.52756,0.0315,0.52756,0.03937,0.52756,0.04724,0.52756,0.05512,0.52756,0.06299,0.52756,0.07087,0.52756,0.07874,0.52756,0.08661,0.52756,0.09449,0.52756,0.10236,0.52756,0.11024,0.52756,0.11811,0.52756,0.12598,0.52756,0.13386,0.52756,0.14173,0.52756,0.14961,0.52756,0.15748,0.52756,0.16535,0.52756,0.17323,0.52756,0.1811,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_87()
		{
			double[] value = {0.18898,0.52756,0.19685,0.52756,0.20472,0.52756,0.2126,0.52756,0.22047,0.52756,0.22835,0.52756,0.23622,0.52756,0.24409,0.52756,0.25197,0.52756,0.25984,0.52756,0.26772,0.52756,0.27559,0.52756,0.28346,0.52756,0.29134,0.52756,0.29921,0.52756,0.30709,0.52756,0.31496,0.52756,0.32283,0.52756,0.33071,0.52756,0.33858,0.52756,0.34646,0.52756,0.35433,0.52756,0.3622,0.52756,0.37008,0.52756,0.37795,0.52756,0.38583,0.52756,0.3937,0.52756,0.40157,0.52756,0.40945,0.52756,0.41732,0.52756,0.4252,0.52756,0.43307,0.52756,0.44094,0.52756,0.44882,0.52756,0.45669,0.52756,0.46457,0.52756,0.47244,0.52756,0.48031,0.52756,0.48819,0.52756,0.49606,0.52756,0.50394,0.52756,0.51181,0.52756,0.51969,0.52756,0.52756,0.52756,0.53543,0.52756,0.54331,0.52756,0.55118,0.52756,0.55906,0.52756,0.56693,0.52756,0.5748,0.52756,0.58268,0.52756,0.59055,0.52756,0.59843,0.52756,0.6063,0.52756,0.61417,0.52756,0.62205,0.52756,0.62992,0.52756,0.6378,0.52756,0.64567,0.52756,0.65354,0.52756,0.66142,0.52756,0.66929,0.52756,0.67717,0.52756,0.68504,0.52756,0.69291,0.52756,0.70079,0.52756,0.70866,0.52756,0.71654,0.52756,0.72441,0.52756,0.73228,0.52756,0.74016,0.52756,0.74803,0.52756,0.75591,0.52756,0.76378,0.52756,0.77165,0.52756,0.77953,0.52756,0.7874,0.52756,0.79528,0.52756,0.80315,0.52756,0.81102,0.52756,0.8189,0.52756,0.82677,0.52756,0.83465,0.52756,0.84252,0.52756,0.85039,0.52756,0.85827,0.52756,0.86614,0.52756,0.87402,0.52756,0.88189,0.52756,0.88976,0.52756,0.89764,0.52756,0.90551,0.52756,0.91339,0.52756,0.92126,0.52756,0.92913,0.52756,0.93701,0.52756,0.94488,0.52756,0.95276,0.52756,0.96063,0.52756,0.9685,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_88()
		{
			double[] value = {0.97638,0.52756,0.98425,0.52756,0.99213,0.52756,0.99609,0.52756,0.00391,0.53543,0.00787,0.53543,0.01575,0.53543,0.02362,0.53543,0.0315,0.53543,0.03937,0.53543,0.04724,0.53543,0.05512,0.53543,0.06299,0.53543,0.07087,0.53543,0.07874,0.53543,0.08661,0.53543,0.09449,0.53543,0.10236,0.53543,0.11024,0.53543,0.11811,0.53543,0.12598,0.53543,0.13386,0.53543,0.14173,0.53543,0.14961,0.53543,0.15748,0.53543,0.16535,0.53543,0.17323,0.53543,0.1811,0.53543,0.18898,0.53543,0.19685,0.53543,0.20472,0.53543,0.2126,0.53543,0.22047,0.53543,0.22835,0.53543,0.23622,0.53543,0.24409,0.53543,0.25197,0.53543,0.25984,0.53543,0.26772,0.53543,0.27559,0.53543,0.28346,0.53543,0.29134,0.53543,0.29921,0.53543,0.30709,0.53543,0.31496,0.53543,0.32283,0.53543,0.33071,0.53543,0.33858,0.53543,0.34646,0.53543,0.35433,0.53543,0.3622,0.53543,0.37008,0.53543,0.37795,0.53543,0.38583,0.53543,0.3937,0.53543,0.40157,0.53543,0.40945,0.53543,0.41732,0.53543,0.4252,0.53543,0.43307,0.53543,0.44094,0.53543,0.44882,0.53543,0.45669,0.53543,0.46457,0.53543,0.47244,0.53543,0.48031,0.53543,0.48819,0.53543,0.49606,0.53543,0.50394,0.53543,0.51181,0.53543,0.51969,0.53543,0.52756,0.53543,0.53543,0.53543,0.54331,0.53543,0.55118,0.53543,0.55906,0.53543,0.56693,0.53543,0.5748,0.53543,0.58268,0.53543,0.59055,0.53543,0.59843,0.53543,0.6063,0.53543,0.61417,0.53543,0.62205,0.53543,0.62992,0.53543,0.6378,0.53543,0.64567,0.53543,0.65354,0.53543,0.66142,0.53543,0.66929,0.53543,0.67717,0.53543,0.68504,0.53543,0.69291,0.53543,0.70079,0.53543,0.70866,0.53543,0.71654,0.53543,0.72441,0.53543,0.73228,0.53543,0.74016,0.53543,0.74803,0.53543};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_89()
		{
			double[] value = {0.75591,0.53543,0.76378,0.53543,0.77165,0.53543,0.77953,0.53543,0.7874,0.53543,0.79528,0.53543,0.80315,0.53543,0.81102,0.53543,0.8189,0.53543,0.82677,0.53543,0.83465,0.53543,0.84252,0.53543,0.85039,0.53543,0.85827,0.53543,0.86614,0.53543,0.87402,0.53543,0.88189,0.53543,0.88976,0.53543,0.89764,0.53543,0.90551,0.53543,0.91339,0.53543,0.92126,0.53543,0.92913,0.53543,0.93701,0.53543,0.94488,0.53543,0.95276,0.53543,0.96063,0.53543,0.9685,0.53543,0.97638,0.53543,0.98425,0.53543,0.99213,0.53543,0.99609,0.53543,0.00391,0.54331,0.00787,0.54331,0.01575,0.54331,0.02362,0.54331,0.0315,0.54331,0.03937,0.54331,0.04724,0.54331,0.05512,0.54331,0.06299,0.54331,0.07087,0.54331,0.07874,0.54331,0.08661,0.54331,0.09449,0.54331,0.10236,0.54331,0.11024,0.54331,0.11811,0.54331,0.12598,0.54331,0.13386,0.54331,0.14173,0.54331,0.14961,0.54331,0.15748,0.54331,0.16535,0.54331,0.17323,0.54331,0.1811,0.54331,0.18898,0.54331,0.19685,0.54331,0.20472,0.54331,0.2126,0.54331,0.22047,0.54331,0.22835,0.54331,0.23622,0.54331,0.24409,0.54331,0.25197,0.54331,0.25984,0.54331,0.26772,0.54331,0.27559,0.54331,0.28346,0.54331,0.29134,0.54331,0.29921,0.54331,0.30709,0.54331,0.31496,0.54331,0.32283,0.54331,0.33071,0.54331,0.33858,0.54331,0.34646,0.54331,0.35433,0.54331,0.3622,0.54331,0.37008,0.54331,0.37795,0.54331,0.38583,0.54331,0.3937,0.54331,0.40157,0.54331,0.40945,0.54331,0.41732,0.54331,0.4252,0.54331,0.43307,0.54331,0.44094,0.54331,0.44882,0.54331,0.45669,0.54331,0.46457,0.54331,0.47244,0.54331,0.48031,0.54331,0.48819,0.54331,0.49606,0.54331,0.50394,0.54331,0.51181,0.54331,0.51969,0.54331,0.52756,0.54331};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_90()
		{
			double[] value = {0.53543,0.54331,0.54331,0.54331,0.55118,0.54331,0.55906,0.54331,0.56693,0.54331,0.5748,0.54331,0.58268,0.54331,0.59055,0.54331,0.59843,0.54331,0.6063,0.54331,0.61417,0.54331,0.62205,0.54331,0.62992,0.54331,0.6378,0.54331,0.64567,0.54331,0.65354,0.54331,0.66142,0.54331,0.66929,0.54331,0.67717,0.54331,0.68504,0.54331,0.69291,0.54331,0.70079,0.54331,0.70866,0.54331,0.71654,0.54331,0.72441,0.54331,0.73228,0.54331,0.74016,0.54331,0.74803,0.54331,0.75591,0.54331,0.76378,0.54331,0.77165,0.54331,0.77953,0.54331,0.7874,0.54331,0.79528,0.54331,0.80315,0.54331,0.81102,0.54331,0.8189,0.54331,0.82677,0.54331,0.83465,0.54331,0.84252,0.54331,0.85039,0.54331,0.85827,0.54331,0.86614,0.54331,0.87402,0.54331,0.88189,0.54331,0.88976,0.54331,0.89764,0.54331,0.90551,0.54331,0.91339,0.54331,0.92126,0.54331,0.92913,0.54331,0.93701,0.54331,0.94488,0.54331,0.95276,0.54331,0.96063,0.54331,0.9685,0.54331,0.97638,0.54331,0.98425,0.54331,0.99213,0.54331,0.99609,0.54331,0.00391,0.55118,0.00787,0.55118,0.01575,0.55118,0.02362,0.55118,0.0315,0.55118,0.03937,0.55118,0.04724,0.55118,0.05512,0.55118,0.06299,0.55118,0.07087,0.55118,0.07874,0.55118,0.08661,0.55118,0.09449,0.55118,0.10236,0.55118,0.11024,0.55118,0.11811,0.55118,0.12598,0.55118,0.13386,0.55118,0.14173,0.55118,0.14961,0.55118,0.15748,0.55118,0.16535,0.55118,0.17323,0.55118,0.1811,0.55118,0.18898,0.55118,0.19685,0.55118,0.20472,0.55118,0.2126,0.55118,0.22047,0.55118,0.22835,0.55118,0.23622,0.55118,0.24409,0.55118,0.25197,0.55118,0.25984,0.55118,0.26772,0.55118,0.27559,0.55118,0.28346,0.55118,0.29134,0.55118,0.29921,0.55118,0.30709,0.55118};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_91()
		{
			double[] value = {0.31496,0.55118,0.32283,0.55118,0.33071,0.55118,0.33858,0.55118,0.34646,0.55118,0.35433,0.55118,0.3622,0.55118,0.37008,0.55118,0.37795,0.55118,0.38583,0.55118,0.3937,0.55118,0.40157,0.55118,0.40945,0.55118,0.41732,0.55118,0.4252,0.55118,0.43307,0.55118,0.44094,0.55118,0.44882,0.55118,0.45669,0.55118,0.46457,0.55118,0.47244,0.55118,0.48031,0.55118,0.48819,0.55118,0.49606,0.55118,0.50394,0.55118,0.51181,0.55118,0.51969,0.55118,0.52756,0.55118,0.53543,0.55118,0.54331,0.55118,0.55118,0.55118,0.55906,0.55118,0.56693,0.55118,0.5748,0.55118,0.58268,0.55118,0.59055,0.55118,0.59843,0.55118,0.6063,0.55118,0.61417,0.55118,0.62205,0.55118,0.62992,0.55118,0.6378,0.55118,0.64567,0.55118,0.65354,0.55118,0.66142,0.55118,0.66929,0.55118,0.67717,0.55118,0.68504,0.55118,0.69291,0.55118,0.70079,0.55118,0.70866,0.55118,0.71654,0.55118,0.72441,0.55118,0.73228,0.55118,0.74016,0.55118,0.74803,0.55118,0.75591,0.55118,0.76378,0.55118,0.77165,0.55118,0.77953,0.55118,0.7874,0.55118,0.79528,0.55118,0.80315,0.55118,0.81102,0.55118,0.8189,0.55118,0.82677,0.55118,0.83465,0.55118,0.84252,0.55118,0.85039,0.55118,0.85827,0.55118,0.86614,0.55118,0.87402,0.55118,0.88189,0.55118,0.88976,0.55118,0.89764,0.55118,0.90551,0.55118,0.91339,0.55118,0.92126,0.55118,0.92913,0.55118,0.93701,0.55118,0.94488,0.55118,0.95276,0.55118,0.96063,0.55118,0.9685,0.55118,0.97638,0.55118,0.98425,0.55118,0.99213,0.55118,0.99609,0.55118,0.00391,0.55906,0.00787,0.55906,0.01575,0.55906,0.02362,0.55906,0.0315,0.55906,0.03937,0.55906,0.04724,0.55906,0.05512,0.55906,0.06299,0.55906,0.07087,0.55906,0.07874,0.55906,0.08661,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_92()
		{
			double[] value = {0.09449,0.55906,0.10236,0.55906,0.11024,0.55906,0.11811,0.55906,0.12598,0.55906,0.13386,0.55906,0.14173,0.55906,0.14961,0.55906,0.15748,0.55906,0.16535,0.55906,0.17323,0.55906,0.1811,0.55906,0.18898,0.55906,0.19685,0.55906,0.20472,0.55906,0.2126,0.55906,0.22047,0.55906,0.22835,0.55906,0.23622,0.55906,0.24409,0.55906,0.25197,0.55906,0.25984,0.55906,0.26772,0.55906,0.27559,0.55906,0.28346,0.55906,0.29134,0.55906,0.29921,0.55906,0.30709,0.55906,0.31496,0.55906,0.32283,0.55906,0.33071,0.55906,0.33858,0.55906,0.34646,0.55906,0.35433,0.55906,0.3622,0.55906,0.37008,0.55906,0.37795,0.55906,0.38583,0.55906,0.3937,0.55906,0.40157,0.55906,0.40945,0.55906,0.41732,0.55906,0.4252,0.55906,0.43307,0.55906,0.44094,0.55906,0.44882,0.55906,0.45669,0.55906,0.46457,0.55906,0.47244,0.55906,0.48031,0.55906,0.48819,0.55906,0.49606,0.55906,0.50394,0.55906,0.51181,0.55906,0.51969,0.55906,0.52756,0.55906,0.53543,0.55906,0.54331,0.55906,0.55118,0.55906,0.55906,0.55906,0.56693,0.55906,0.5748,0.55906,0.58268,0.55906,0.59055,0.55906,0.59843,0.55906,0.6063,0.55906,0.61417,0.55906,0.62205,0.55906,0.62992,0.55906,0.6378,0.55906,0.64567,0.55906,0.65354,0.55906,0.66142,0.55906,0.66929,0.55906,0.67717,0.55906,0.68504,0.55906,0.69291,0.55906,0.70079,0.55906,0.70866,0.55906,0.71654,0.55906,0.72441,0.55906,0.73228,0.55906,0.74016,0.55906,0.74803,0.55906,0.75591,0.55906,0.76378,0.55906,0.77165,0.55906,0.77953,0.55906,0.7874,0.55906,0.79528,0.55906,0.80315,0.55906,0.81102,0.55906,0.8189,0.55906,0.82677,0.55906,0.83465,0.55906,0.84252,0.55906,0.85039,0.55906,0.85827,0.55906,0.86614,0.55906,0.87402,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_93()
		{
			double[] value = {0.88189,0.55906,0.88976,0.55906,0.89764,0.55906,0.90551,0.55906,0.91339,0.55906,0.92126,0.55906,0.92913,0.55906,0.93701,0.55906,0.94488,0.55906,0.95276,0.55906,0.96063,0.55906,0.9685,0.55906,0.97638,0.55906,0.98425,0.55906,0.99213,0.55906,0.99609,0.55906,0.00391,0.56693,0.00787,0.56693,0.01575,0.56693,0.02362,0.56693,0.0315,0.56693,0.03937,0.56693,0.04724,0.56693,0.05512,0.56693,0.06299,0.56693,0.07087,0.56693,0.07874,0.56693,0.08661,0.56693,0.09449,0.56693,0.10236,0.56693,0.11024,0.56693,0.11811,0.56693,0.12598,0.56693,0.13386,0.56693,0.14173,0.56693,0.14961,0.56693,0.15748,0.56693,0.16535,0.56693,0.17323,0.56693,0.1811,0.56693,0.18898,0.56693,0.19685,0.56693,0.20472,0.56693,0.2126,0.56693,0.22047,0.56693,0.22835,0.56693,0.23622,0.56693,0.24409,0.56693,0.25197,0.56693,0.25984,0.56693,0.26772,0.56693,0.27559,0.56693,0.28346,0.56693,0.29134,0.56693,0.29921,0.56693,0.30709,0.56693,0.31496,0.56693,0.32283,0.56693,0.33071,0.56693,0.33858,0.56693,0.34646,0.56693,0.35433,0.56693,0.3622,0.56693,0.37008,0.56693,0.37795,0.56693,0.38583,0.56693,0.3937,0.56693,0.40157,0.56693,0.40945,0.56693,0.41732,0.56693,0.4252,0.56693,0.43307,0.56693,0.44094,0.56693,0.44882,0.56693,0.45669,0.56693,0.46457,0.56693,0.47244,0.56693,0.48031,0.56693,0.48819,0.56693,0.49606,0.56693,0.50394,0.56693,0.51181,0.56693,0.51969,0.56693,0.52756,0.56693,0.53543,0.56693,0.54331,0.56693,0.55118,0.56693,0.55906,0.56693,0.56693,0.56693,0.5748,0.56693,0.58268,0.56693,0.59055,0.56693,0.59843,0.56693,0.6063,0.56693,0.61417,0.56693,0.62205,0.56693,0.62992,0.56693,0.6378,0.56693,0.64567,0.56693,0.65354,0.56693};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_94()
		{
			double[] value = {0.66142,0.56693,0.66929,0.56693,0.67717,0.56693,0.68504,0.56693,0.69291,0.56693,0.70079,0.56693,0.70866,0.56693,0.71654,0.56693,0.72441,0.56693,0.73228,0.56693,0.74016,0.56693,0.74803,0.56693,0.75591,0.56693,0.76378,0.56693,0.77165,0.56693,0.77953,0.56693,0.7874,0.56693,0.79528,0.56693,0.80315,0.56693,0.81102,0.56693,0.8189,0.56693,0.82677,0.56693,0.83465,0.56693,0.84252,0.56693,0.85039,0.56693,0.85827,0.56693,0.86614,0.56693,0.87402,0.56693,0.88189,0.56693,0.88976,0.56693,0.89764,0.56693,0.90551,0.56693,0.91339,0.56693,0.92126,0.56693,0.92913,0.56693,0.93701,0.56693,0.94488,0.56693,0.95276,0.56693,0.96063,0.56693,0.9685,0.56693,0.97638,0.56693,0.98425,0.56693,0.99213,0.56693,0.99609,0.56693,0.00391,0.5748,0.00787,0.5748,0.01575,0.5748,0.02362,0.5748,0.0315,0.5748,0.03937,0.5748,0.04724,0.5748,0.05512,0.5748,0.06299,0.5748,0.07087,0.5748,0.07874,0.5748,0.08661,0.5748,0.09449,0.5748,0.10236,0.5748,0.11024,0.5748,0.11811,0.5748,0.12598,0.5748,0.13386,0.5748,0.14173,0.5748,0.14961,0.5748,0.15748,0.5748,0.16535,0.5748,0.17323,0.5748,0.1811,0.5748,0.18898,0.5748,0.19685,0.5748,0.20472,0.5748,0.2126,0.5748,0.22047,0.5748,0.22835,0.5748,0.23622,0.5748,0.24409,0.5748,0.25197,0.5748,0.25984,0.5748,0.26772,0.5748,0.27559,0.5748,0.28346,0.5748,0.29134,0.5748,0.29921,0.5748,0.30709,0.5748,0.31496,0.5748,0.32283,0.5748,0.33071,0.5748,0.33858,0.5748,0.34646,0.5748,0.35433,0.5748,0.3622,0.5748,0.37008,0.5748,0.37795,0.5748,0.38583,0.5748,0.3937,0.5748,0.40157,0.5748,0.40945,0.5748,0.41732,0.5748,0.4252,0.5748,0.43307,0.5748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_95()
		{
			double[] value = {0.44094,0.5748,0.44882,0.5748,0.45669,0.5748,0.46457,0.5748,0.47244,0.5748,0.48031,0.5748,0.48819,0.5748,0.49606,0.5748,0.50394,0.5748,0.51181,0.5748,0.51969,0.5748,0.52756,0.5748,0.53543,0.5748,0.54331,0.5748,0.55118,0.5748,0.55906,0.5748,0.56693,0.5748,0.5748,0.5748,0.58268,0.5748,0.59055,0.5748,0.59843,0.5748,0.6063,0.5748,0.61417,0.5748,0.62205,0.5748,0.62992,0.5748,0.6378,0.5748,0.64567,0.5748,0.65354,0.5748,0.66142,0.5748,0.66929,0.5748,0.67717,0.5748,0.68504,0.5748,0.69291,0.5748,0.70079,0.5748,0.70866,0.5748,0.71654,0.5748,0.72441,0.5748,0.73228,0.5748,0.74016,0.5748,0.74803,0.5748,0.75591,0.5748,0.76378,0.5748,0.77165,0.5748,0.77953,0.5748,0.7874,0.5748,0.79528,0.5748,0.80315,0.5748,0.81102,0.5748,0.8189,0.5748,0.82677,0.5748,0.83465,0.5748,0.84252,0.5748,0.85039,0.5748,0.85827,0.5748,0.86614,0.5748,0.87402,0.5748,0.88189,0.5748,0.88976,0.5748,0.89764,0.5748,0.90551,0.5748,0.91339,0.5748,0.92126,0.5748,0.92913,0.5748,0.93701,0.5748,0.94488,0.5748,0.95276,0.5748,0.96063,0.5748,0.9685,0.5748,0.97638,0.5748,0.98425,0.5748,0.99213,0.5748,0.99609,0.5748,0.00391,0.58268,0.00787,0.58268,0.01575,0.58268,0.02362,0.58268,0.0315,0.58268,0.03937,0.58268,0.04724,0.58268,0.05512,0.58268,0.06299,0.58268,0.07087,0.58268,0.07874,0.58268,0.08661,0.58268,0.09449,0.58268,0.10236,0.58268,0.11024,0.58268,0.11811,0.58268,0.12598,0.58268,0.13386,0.58268,0.14173,0.58268,0.14961,0.58268,0.15748,0.58268,0.16535,0.58268,0.17323,0.58268,0.1811,0.58268,0.18898,0.58268,0.19685,0.58268,0.20472,0.58268,0.2126,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_96()
		{
			double[] value = {0.22047,0.58268,0.22835,0.58268,0.23622,0.58268,0.24409,0.58268,0.25197,0.58268,0.25984,0.58268,0.26772,0.58268,0.27559,0.58268,0.28346,0.58268,0.29134,0.58268,0.29921,0.58268,0.30709,0.58268,0.31496,0.58268,0.32283,0.58268,0.33071,0.58268,0.33858,0.58268,0.34646,0.58268,0.35433,0.58268,0.3622,0.58268,0.37008,0.58268,0.37795,0.58268,0.38583,0.58268,0.3937,0.58268,0.40157,0.58268,0.40945,0.58268,0.41732,0.58268,0.4252,0.58268,0.43307,0.58268,0.44094,0.58268,0.44882,0.58268,0.45669,0.58268,0.46457,0.58268,0.47244,0.58268,0.48031,0.58268,0.48819,0.58268,0.49606,0.58268,0.50394,0.58268,0.51181,0.58268,0.51969,0.58268,0.52756,0.58268,0.53543,0.58268,0.54331,0.58268,0.55118,0.58268,0.55906,0.58268,0.56693,0.58268,0.5748,0.58268,0.58268,0.58268,0.59055,0.58268,0.59843,0.58268,0.6063,0.58268,0.61417,0.58268,0.62205,0.58268,0.62992,0.58268,0.6378,0.58268,0.64567,0.58268,0.65354,0.58268,0.66142,0.58268,0.66929,0.58268,0.67717,0.58268,0.68504,0.58268,0.69291,0.58268,0.70079,0.58268,0.70866,0.58268,0.71654,0.58268,0.72441,0.58268,0.73228,0.58268,0.74016,0.58268,0.74803,0.58268,0.75591,0.58268,0.76378,0.58268,0.77165,0.58268,0.77953,0.58268,0.7874,0.58268,0.79528,0.58268,0.80315,0.58268,0.81102,0.58268,0.8189,0.58268,0.82677,0.58268,0.83465,0.58268,0.84252,0.58268,0.85039,0.58268,0.85827,0.58268,0.86614,0.58268,0.87402,0.58268,0.88189,0.58268,0.88976,0.58268,0.89764,0.58268,0.90551,0.58268,0.91339,0.58268,0.92126,0.58268,0.92913,0.58268,0.93701,0.58268,0.94488,0.58268,0.95276,0.58268,0.96063,0.58268,0.9685,0.58268,0.97638,0.58268,0.98425,0.58268,0.99213,0.58268,0.99609,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_97()
		{
			double[] value = {0.00391,0.59055,0.00787,0.59055,0.01575,0.59055,0.02362,0.59055,0.0315,0.59055,0.03937,0.59055,0.04724,0.59055,0.05512,0.59055,0.06299,0.59055,0.07087,0.59055,0.07874,0.59055,0.08661,0.59055,0.09449,0.59055,0.10236,0.59055,0.11024,0.59055,0.11811,0.59055,0.12598,0.59055,0.13386,0.59055,0.14173,0.59055,0.14961,0.59055,0.15748,0.59055,0.16535,0.59055,0.17323,0.59055,0.1811,0.59055,0.18898,0.59055,0.19685,0.59055,0.20472,0.59055,0.2126,0.59055,0.22047,0.59055,0.22835,0.59055,0.23622,0.59055,0.24409,0.59055,0.25197,0.59055,0.25984,0.59055,0.26772,0.59055,0.27559,0.59055,0.28346,0.59055,0.29134,0.59055,0.29921,0.59055,0.30709,0.59055,0.31496,0.59055,0.32283,0.59055,0.33071,0.59055,0.33858,0.59055,0.34646,0.59055,0.35433,0.59055,0.3622,0.59055,0.37008,0.59055,0.37795,0.59055,0.38583,0.59055,0.3937,0.59055,0.40157,0.59055,0.40945,0.59055,0.41732,0.59055,0.4252,0.59055,0.43307,0.59055,0.44094,0.59055,0.44882,0.59055,0.45669,0.59055,0.46457,0.59055,0.47244,0.59055,0.48031,0.59055,0.48819,0.59055,0.49606,0.59055,0.50394,0.59055,0.51181,0.59055,0.51969,0.59055,0.52756,0.59055,0.53543,0.59055,0.54331,0.59055,0.55118,0.59055,0.55906,0.59055,0.56693,0.59055,0.5748,0.59055,0.58268,0.59055,0.59055,0.59055,0.59843,0.59055,0.6063,0.59055,0.61417,0.59055,0.62205,0.59055,0.62992,0.59055,0.6378,0.59055,0.64567,0.59055,0.65354,0.59055,0.66142,0.59055,0.66929,0.59055,0.67717,0.59055,0.68504,0.59055,0.69291,0.59055,0.70079,0.59055,0.70866,0.59055,0.71654,0.59055,0.72441,0.59055,0.73228,0.59055,0.74016,0.59055,0.74803,0.59055,0.75591,0.59055,0.76378,0.59055,0.77165,0.59055,0.77953,0.59055};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_98()
		{
			double[] value = {0.7874,0.59055,0.79528,0.59055,0.80315,0.59055,0.81102,0.59055,0.8189,0.59055,0.82677,0.59055,0.83465,0.59055,0.84252,0.59055,0.85039,0.59055,0.85827,0.59055,0.86614,0.59055,0.87402,0.59055,0.88189,0.59055,0.88976,0.59055,0.89764,0.59055,0.90551,0.59055,0.91339,0.59055,0.92126,0.59055,0.92913,0.59055,0.93701,0.59055,0.94488,0.59055,0.95276,0.59055,0.96063,0.59055,0.9685,0.59055,0.97638,0.59055,0.98425,0.59055,0.99213,0.59055,0.99609,0.59055,0.00391,0.59843,0.00787,0.59843,0.01575,0.59843,0.02362,0.59843,0.0315,0.59843,0.03937,0.59843,0.04724,0.59843,0.05512,0.59843,0.06299,0.59843,0.07087,0.59843,0.07874,0.59843,0.08661,0.59843,0.09449,0.59843,0.10236,0.59843,0.11024,0.59843,0.11811,0.59843,0.12598,0.59843,0.13386,0.59843,0.14173,0.59843,0.14961,0.59843,0.15748,0.59843,0.16535,0.59843,0.17323,0.59843,0.1811,0.59843,0.18898,0.59843,0.19685,0.59843,0.20472,0.59843,0.2126,0.59843,0.22047,0.59843,0.22835,0.59843,0.23622,0.59843,0.24409,0.59843,0.25197,0.59843,0.25984,0.59843,0.26772,0.59843,0.27559,0.59843,0.28346,0.59843,0.29134,0.59843,0.29921,0.59843,0.30709,0.59843,0.31496,0.59843,0.32283,0.59843,0.33071,0.59843,0.33858,0.59843,0.34646,0.59843,0.35433,0.59843,0.3622,0.59843,0.37008,0.59843,0.37795,0.59843,0.38583,0.59843,0.3937,0.59843,0.40157,0.59843,0.40945,0.59843,0.41732,0.59843,0.4252,0.59843,0.43307,0.59843,0.44094,0.59843,0.44882,0.59843,0.45669,0.59843,0.46457,0.59843,0.47244,0.59843,0.48031,0.59843,0.48819,0.59843,0.49606,0.59843,0.50394,0.59843,0.51181,0.59843,0.51969,0.59843,0.52756,0.59843,0.53543,0.59843,0.54331,0.59843,0.55118,0.59843,0.55906,0.59843};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_99()
		{
			double[] value = {0.56693,0.59843,0.5748,0.59843,0.58268,0.59843,0.59055,0.59843,0.59843,0.59843,0.6063,0.59843,0.61417,0.59843,0.62205,0.59843,0.62992,0.59843,0.6378,0.59843,0.64567,0.59843,0.65354,0.59843,0.66142,0.59843,0.66929,0.59843,0.67717,0.59843,0.68504,0.59843,0.69291,0.59843,0.70079,0.59843,0.70866,0.59843,0.71654,0.59843,0.72441,0.59843,0.73228,0.59843,0.74016,0.59843,0.74803,0.59843,0.75591,0.59843,0.76378,0.59843,0.77165,0.59843,0.77953,0.59843,0.7874,0.59843,0.79528,0.59843,0.80315,0.59843,0.81102,0.59843,0.8189,0.59843,0.82677,0.59843,0.83465,0.59843,0.84252,0.59843,0.85039,0.59843,0.85827,0.59843,0.86614,0.59843,0.87402,0.59843,0.88189,0.59843,0.88976,0.59843,0.89764,0.59843,0.90551,0.59843,0.91339,0.59843,0.92126,0.59843,0.92913,0.59843,0.93701,0.59843,0.94488,0.59843,0.95276,0.59843,0.96063,0.59843,0.9685,0.59843,0.97638,0.59843,0.98425,0.59843,0.99213,0.59843,0.99609,0.59843,0.00391,0.6063,0.00787,0.6063,0.01575,0.6063,0.02362,0.6063,0.0315,0.6063,0.03937,0.6063,0.04724,0.6063,0.05512,0.6063,0.06299,0.6063,0.07087,0.6063,0.07874,0.6063,0.08661,0.6063,0.09449,0.6063,0.10236,0.6063,0.11024,0.6063,0.11811,0.6063,0.12598,0.6063,0.13386,0.6063,0.14173,0.6063,0.14961,0.6063,0.15748,0.6063,0.16535,0.6063,0.17323,0.6063,0.1811,0.6063,0.18898,0.6063,0.19685,0.6063,0.20472,0.6063,0.2126,0.6063,0.22047,0.6063,0.22835,0.6063,0.23622,0.6063,0.24409,0.6063,0.25197,0.6063,0.25984,0.6063,0.26772,0.6063,0.27559,0.6063,0.28346,0.6063,0.29134,0.6063,0.29921,0.6063,0.30709,0.6063,0.31496,0.6063,0.32283,0.6063,0.33071,0.6063,0.33858,0.6063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_100()
		{
			double[] value = {0.34646,0.6063,0.35433,0.6063,0.3622,0.6063,0.37008,0.6063,0.37795,0.6063,0.38583,0.6063,0.3937,0.6063,0.40157,0.6063,0.40945,0.6063,0.41732,0.6063,0.4252,0.6063,0.43307,0.6063,0.44094,0.6063,0.44882,0.6063,0.45669,0.6063,0.46457,0.6063,0.47244,0.6063,0.48031,0.6063,0.48819,0.6063,0.49606,0.6063,0.50394,0.6063,0.51181,0.6063,0.51969,0.6063,0.52756,0.6063,0.53543,0.6063,0.54331,0.6063,0.55118,0.6063,0.55906,0.6063,0.56693,0.6063,0.5748,0.6063,0.58268,0.6063,0.59055,0.6063,0.59843,0.6063,0.6063,0.6063,0.61417,0.6063,0.62205,0.6063,0.62992,0.6063,0.6378,0.6063,0.64567,0.6063,0.65354,0.6063,0.66142,0.6063,0.66929,0.6063,0.67717,0.6063,0.68504,0.6063,0.69291,0.6063,0.70079,0.6063,0.70866,0.6063,0.71654,0.6063,0.72441,0.6063,0.73228,0.6063,0.74016,0.6063,0.74803,0.6063,0.75591,0.6063,0.76378,0.6063,0.77165,0.6063,0.77953,0.6063,0.7874,0.6063,0.79528,0.6063,0.80315,0.6063,0.81102,0.6063,0.8189,0.6063,0.82677,0.6063,0.83465,0.6063,0.84252,0.6063,0.85039,0.6063,0.85827,0.6063,0.86614,0.6063,0.87402,0.6063,0.88189,0.6063,0.88976,0.6063,0.89764,0.6063,0.90551,0.6063,0.91339,0.6063,0.92126,0.6063,0.92913,0.6063,0.93701,0.6063,0.94488,0.6063,0.95276,0.6063,0.96063,0.6063,0.9685,0.6063,0.97638,0.6063,0.98425,0.6063,0.99213,0.6063,0.99609,0.6063,0.00391,0.61417,0.00787,0.61417,0.01575,0.61417,0.02362,0.61417,0.0315,0.61417,0.03937,0.61417,0.04724,0.61417,0.05512,0.61417,0.06299,0.61417,0.07087,0.61417,0.07874,0.61417,0.08661,0.61417,0.09449,0.61417,0.10236,0.61417,0.11024,0.61417,0.11811,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_101()
		{
			double[] value = {0.12598,0.61417,0.13386,0.61417,0.14173,0.61417,0.14961,0.61417,0.15748,0.61417,0.16535,0.61417,0.17323,0.61417,0.1811,0.61417,0.18898,0.61417,0.19685,0.61417,0.20472,0.61417,0.2126,0.61417,0.22047,0.61417,0.22835,0.61417,0.23622,0.61417,0.24409,0.61417,0.25197,0.61417,0.25984,0.61417,0.26772,0.61417,0.27559,0.61417,0.28346,0.61417,0.29134,0.61417,0.29921,0.61417,0.30709,0.61417,0.31496,0.61417,0.32283,0.61417,0.33071,0.61417,0.33858,0.61417,0.34646,0.61417,0.35433,0.61417,0.3622,0.61417,0.37008,0.61417,0.37795,0.61417,0.38583,0.61417,0.3937,0.61417,0.40157,0.61417,0.40945,0.61417,0.41732,0.61417,0.4252,0.61417,0.43307,0.61417,0.44094,0.61417,0.44882,0.61417,0.45669,0.61417,0.46457,0.61417,0.47244,0.61417,0.48031,0.61417,0.48819,0.61417,0.49606,0.61417,0.50394,0.61417,0.51181,0.61417,0.51969,0.61417,0.52756,0.61417,0.53543,0.61417,0.54331,0.61417,0.55118,0.61417,0.55906,0.61417,0.56693,0.61417,0.5748,0.61417,0.58268,0.61417,0.59055,0.61417,0.59843,0.61417,0.6063,0.61417,0.61417,0.61417,0.62205,0.61417,0.62992,0.61417,0.6378,0.61417,0.64567,0.61417,0.65354,0.61417,0.66142,0.61417,0.66929,0.61417,0.67717,0.61417,0.68504,0.61417,0.69291,0.61417,0.70079,0.61417,0.70866,0.61417,0.71654,0.61417,0.72441,0.61417,0.73228,0.61417,0.74016,0.61417,0.74803,0.61417,0.75591,0.61417,0.76378,0.61417,0.77165,0.61417,0.77953,0.61417,0.7874,0.61417,0.79528,0.61417,0.80315,0.61417,0.81102,0.61417,0.8189,0.61417,0.82677,0.61417,0.83465,0.61417,0.84252,0.61417,0.85039,0.61417,0.85827,0.61417,0.86614,0.61417,0.87402,0.61417,0.88189,0.61417,0.88976,0.61417,0.89764,0.61417,0.90551,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_102()
		{
			double[] value = {0.91339,0.61417,0.92126,0.61417,0.92913,0.61417,0.93701,0.61417,0.94488,0.61417,0.95276,0.61417,0.96063,0.61417,0.9685,0.61417,0.97638,0.61417,0.98425,0.61417,0.99213,0.61417,0.99609,0.61417,0.00391,0.62205,0.00787,0.62205,0.01575,0.62205,0.02362,0.62205,0.0315,0.62205,0.03937,0.62205,0.04724,0.62205,0.05512,0.62205,0.06299,0.62205,0.07087,0.62205,0.07874,0.62205,0.08661,0.62205,0.09449,0.62205,0.10236,0.62205,0.11024,0.62205,0.11811,0.62205,0.12598,0.62205,0.13386,0.62205,0.14173,0.62205,0.14961,0.62205,0.15748,0.62205,0.16535,0.62205,0.17323,0.62205,0.1811,0.62205,0.18898,0.62205,0.19685,0.62205,0.20472,0.62205,0.2126,0.62205,0.22047,0.62205,0.22835,0.62205,0.23622,0.62205,0.24409,0.62205,0.25197,0.62205,0.25984,0.62205,0.26772,0.62205,0.27559,0.62205,0.28346,0.62205,0.29134,0.62205,0.29921,0.62205,0.30709,0.62205,0.31496,0.62205,0.32283,0.62205,0.33071,0.62205,0.33858,0.62205,0.34646,0.62205,0.35433,0.62205,0.3622,0.62205,0.37008,0.62205,0.37795,0.62205,0.38583,0.62205,0.3937,0.62205,0.40157,0.62205,0.40945,0.62205,0.41732,0.62205,0.4252,0.62205,0.43307,0.62205,0.44094,0.62205,0.44882,0.62205,0.45669,0.62205,0.46457,0.62205,0.47244,0.62205,0.48031,0.62205,0.48819,0.62205,0.49606,0.62205,0.50394,0.62205,0.51181,0.62205,0.51969,0.62205,0.52756,0.62205,0.53543,0.62205,0.54331,0.62205,0.55118,0.62205,0.55906,0.62205,0.56693,0.62205,0.5748,0.62205,0.58268,0.62205,0.59055,0.62205,0.59843,0.62205,0.6063,0.62205,0.61417,0.62205,0.62205,0.62205,0.62992,0.62205,0.6378,0.62205,0.64567,0.62205,0.65354,0.62205,0.66142,0.62205,0.66929,0.62205,0.67717,0.62205,0.68504,0.62205};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_103()
		{
			double[] value = {0.69291,0.62205,0.70079,0.62205,0.70866,0.62205,0.71654,0.62205,0.72441,0.62205,0.73228,0.62205,0.74016,0.62205,0.74803,0.62205,0.75591,0.62205,0.76378,0.62205,0.77165,0.62205,0.77953,0.62205,0.7874,0.62205,0.79528,0.62205,0.80315,0.62205,0.81102,0.62205,0.8189,0.62205,0.82677,0.62205,0.83465,0.62205,0.84252,0.62205,0.85039,0.62205,0.85827,0.62205,0.86614,0.62205,0.87402,0.62205,0.88189,0.62205,0.88976,0.62205,0.89764,0.62205,0.90551,0.62205,0.91339,0.62205,0.92126,0.62205,0.92913,0.62205,0.93701,0.62205,0.94488,0.62205,0.95276,0.62205,0.96063,0.62205,0.9685,0.62205,0.97638,0.62205,0.98425,0.62205,0.99213,0.62205,0.99609,0.62205,0.00391,0.62992,0.00787,0.62992,0.01575,0.62992,0.02362,0.62992,0.0315,0.62992,0.03937,0.62992,0.04724,0.62992,0.05512,0.62992,0.06299,0.62992,0.07087,0.62992,0.07874,0.62992,0.08661,0.62992,0.09449,0.62992,0.10236,0.62992,0.11024,0.62992,0.11811,0.62992,0.12598,0.62992,0.13386,0.62992,0.14173,0.62992,0.14961,0.62992,0.15748,0.62992,0.16535,0.62992,0.17323,0.62992,0.1811,0.62992,0.18898,0.62992,0.19685,0.62992,0.20472,0.62992,0.2126,0.62992,0.22047,0.62992,0.22835,0.62992,0.23622,0.62992,0.24409,0.62992,0.25197,0.62992,0.25984,0.62992,0.26772,0.62992,0.27559,0.62992,0.28346,0.62992,0.29134,0.62992,0.29921,0.62992,0.30709,0.62992,0.31496,0.62992,0.32283,0.62992,0.33071,0.62992,0.33858,0.62992,0.34646,0.62992,0.35433,0.62992,0.3622,0.62992,0.37008,0.62992,0.37795,0.62992,0.38583,0.62992,0.3937,0.62992,0.40157,0.62992,0.40945,0.62992,0.41732,0.62992,0.4252,0.62992,0.43307,0.62992,0.44094,0.62992,0.44882,0.62992,0.45669,0.62992,0.46457,0.62992};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_104()
		{
			double[] value = {0.47244,0.62992,0.48031,0.62992,0.48819,0.62992,0.49606,0.62992,0.50394,0.62992,0.51181,0.62992,0.51969,0.62992,0.52756,0.62992,0.53543,0.62992,0.54331,0.62992,0.55118,0.62992,0.55906,0.62992,0.56693,0.62992,0.5748,0.62992,0.58268,0.62992,0.59055,0.62992,0.59843,0.62992,0.6063,0.62992,0.61417,0.62992,0.62205,0.62992,0.62992,0.62992,0.6378,0.62992,0.64567,0.62992,0.65354,0.62992,0.66142,0.62992,0.66929,0.62992,0.67717,0.62992,0.68504,0.62992,0.69291,0.62992,0.70079,0.62992,0.70866,0.62992,0.71654,0.62992,0.72441,0.62992,0.73228,0.62992,0.74016,0.62992,0.74803,0.62992,0.75591,0.62992,0.76378,0.62992,0.77165,0.62992,0.77953,0.62992,0.7874,0.62992,0.79528,0.62992,0.80315,0.62992,0.81102,0.62992,0.8189,0.62992,0.82677,0.62992,0.83465,0.62992,0.84252,0.62992,0.85039,0.62992,0.85827,0.62992,0.86614,0.62992,0.87402,0.62992,0.88189,0.62992,0.88976,0.62992,0.89764,0.62992,0.90551,0.62992,0.91339,0.62992,0.92126,0.62992,0.92913,0.62992,0.93701,0.62992,0.94488,0.62992,0.95276,0.62992,0.96063,0.62992,0.9685,0.62992,0.97638,0.62992,0.98425,0.62992,0.99213,0.62992,0.99609,0.62992,0.00391,0.6378,0.00787,0.6378,0.01575,0.6378,0.02362,0.6378,0.0315,0.6378,0.03937,0.6378,0.04724,0.6378,0.05512,0.6378,0.06299,0.6378,0.07087,0.6378,0.07874,0.6378,0.08661,0.6378,0.09449,0.6378,0.10236,0.6378,0.11024,0.6378,0.11811,0.6378,0.12598,0.6378,0.13386,0.6378,0.14173,0.6378,0.14961,0.6378,0.15748,0.6378,0.16535,0.6378,0.17323,0.6378,0.1811,0.6378,0.18898,0.6378,0.19685,0.6378,0.20472,0.6378,0.2126,0.6378,0.22047,0.6378,0.22835,0.6378,0.23622,0.6378,0.24409,0.6378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_105()
		{
			double[] value = {0.25197,0.6378,0.25984,0.6378,0.26772,0.6378,0.27559,0.6378,0.28346,0.6378,0.29134,0.6378,0.29921,0.6378,0.30709,0.6378,0.31496,0.6378,0.32283,0.6378,0.33071,0.6378,0.33858,0.6378,0.34646,0.6378,0.35433,0.6378,0.3622,0.6378,0.37008,0.6378,0.37795,0.6378,0.38583,0.6378,0.3937,0.6378,0.40157,0.6378,0.40945,0.6378,0.41732,0.6378,0.4252,0.6378,0.43307,0.6378,0.44094,0.6378,0.44882,0.6378,0.45669,0.6378,0.46457,0.6378,0.47244,0.6378,0.48031,0.6378,0.48819,0.6378,0.49606,0.6378,0.50394,0.6378,0.51181,0.6378,0.51969,0.6378,0.52756,0.6378,0.53543,0.6378,0.54331,0.6378,0.55118,0.6378,0.55906,0.6378,0.56693,0.6378,0.5748,0.6378,0.58268,0.6378,0.59055,0.6378,0.59843,0.6378,0.6063,0.6378,0.61417,0.6378,0.62205,0.6378,0.62992,0.6378,0.6378,0.6378,0.64567,0.6378,0.65354,0.6378,0.66142,0.6378,0.66929,0.6378,0.67717,0.6378,0.68504,0.6378,0.69291,0.6378,0.70079,0.6378,0.70866,0.6378,0.71654,0.6378,0.72441,0.6378,0.73228,0.6378,0.74016,0.6378,0.74803,0.6378,0.75591,0.6378,0.76378,0.6378,0.77165,0.6378,0.77953,0.6378,0.7874,0.6378,0.79528,0.6378,0.80315,0.6378,0.81102,0.6378,0.8189,0.6378,0.82677,0.6378,0.83465,0.6378,0.84252,0.6378,0.85039,0.6378,0.85827,0.6378,0.86614,0.6378,0.87402,0.6378,0.88189,0.6378,0.88976,0.6378,0.89764,0.6378,0.90551,0.6378,0.91339,0.6378,0.92126,0.6378,0.92913,0.6378,0.93701,0.6378,0.94488,0.6378,0.95276,0.6378,0.96063,0.6378,0.9685,0.6378,0.97638,0.6378,0.98425,0.6378,0.99213,0.6378,0.99609,0.6378,0.00391,0.64567,0.00787,0.64567,0.01575,0.64567,0.02362,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_106()
		{
			double[] value = {0.0315,0.64567,0.03937,0.64567,0.04724,0.64567,0.05512,0.64567,0.06299,0.64567,0.07087,0.64567,0.07874,0.64567,0.08661,0.64567,0.09449,0.64567,0.10236,0.64567,0.11024,0.64567,0.11811,0.64567,0.12598,0.64567,0.13386,0.64567,0.14173,0.64567,0.14961,0.64567,0.15748,0.64567,0.16535,0.64567,0.17323,0.64567,0.1811,0.64567,0.18898,0.64567,0.19685,0.64567,0.20472,0.64567,0.2126,0.64567,0.22047,0.64567,0.22835,0.64567,0.23622,0.64567,0.24409,0.64567,0.25197,0.64567,0.25984,0.64567,0.26772,0.64567,0.27559,0.64567,0.28346,0.64567,0.29134,0.64567,0.29921,0.64567,0.30709,0.64567,0.31496,0.64567,0.32283,0.64567,0.33071,0.64567,0.33858,0.64567,0.34646,0.64567,0.35433,0.64567,0.3622,0.64567,0.37008,0.64567,0.37795,0.64567,0.38583,0.64567,0.3937,0.64567,0.40157,0.64567,0.40945,0.64567,0.41732,0.64567,0.4252,0.64567,0.43307,0.64567,0.44094,0.64567,0.44882,0.64567,0.45669,0.64567,0.46457,0.64567,0.47244,0.64567,0.48031,0.64567,0.48819,0.64567,0.49606,0.64567,0.50394,0.64567,0.51181,0.64567,0.51969,0.64567,0.52756,0.64567,0.53543,0.64567,0.54331,0.64567,0.55118,0.64567,0.55906,0.64567,0.56693,0.64567,0.5748,0.64567,0.58268,0.64567,0.59055,0.64567,0.59843,0.64567,0.6063,0.64567,0.61417,0.64567,0.62205,0.64567,0.62992,0.64567,0.6378,0.64567,0.64567,0.64567,0.65354,0.64567,0.66142,0.64567,0.66929,0.64567,0.67717,0.64567,0.68504,0.64567,0.69291,0.64567,0.70079,0.64567,0.70866,0.64567,0.71654,0.64567,0.72441,0.64567,0.73228,0.64567,0.74016,0.64567,0.74803,0.64567,0.75591,0.64567,0.76378,0.64567,0.77165,0.64567,0.77953,0.64567,0.7874,0.64567,0.79528,0.64567,0.80315,0.64567,0.81102,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_107()
		{
			double[] value = {0.8189,0.64567,0.82677,0.64567,0.83465,0.64567,0.84252,0.64567,0.85039,0.64567,0.85827,0.64567,0.86614,0.64567,0.87402,0.64567,0.88189,0.64567,0.88976,0.64567,0.89764,0.64567,0.90551,0.64567,0.91339,0.64567,0.92126,0.64567,0.92913,0.64567,0.93701,0.64567,0.94488,0.64567,0.95276,0.64567,0.96063,0.64567,0.9685,0.64567,0.97638,0.64567,0.98425,0.64567,0.99213,0.64567,0.99609,0.64567,0.00391,0.65354,0.00787,0.65354,0.01575,0.65354,0.02362,0.65354,0.0315,0.65354,0.03937,0.65354,0.04724,0.65354,0.05512,0.65354,0.06299,0.65354,0.07087,0.65354,0.07874,0.65354,0.08661,0.65354,0.09449,0.65354,0.10236,0.65354,0.11024,0.65354,0.11811,0.65354,0.12598,0.65354,0.13386,0.65354,0.14173,0.65354,0.14961,0.65354,0.15748,0.65354,0.16535,0.65354,0.17323,0.65354,0.1811,0.65354,0.18898,0.65354,0.19685,0.65354,0.20472,0.65354,0.2126,0.65354,0.22047,0.65354,0.22835,0.65354,0.23622,0.65354,0.24409,0.65354,0.25197,0.65354,0.25984,0.65354,0.26772,0.65354,0.27559,0.65354,0.28346,0.65354,0.29134,0.65354,0.29921,0.65354,0.30709,0.65354,0.31496,0.65354,0.32283,0.65354,0.33071,0.65354,0.33858,0.65354,0.34646,0.65354,0.35433,0.65354,0.3622,0.65354,0.37008,0.65354,0.37795,0.65354,0.38583,0.65354,0.3937,0.65354,0.40157,0.65354,0.40945,0.65354,0.41732,0.65354,0.4252,0.65354,0.43307,0.65354,0.44094,0.65354,0.44882,0.65354,0.45669,0.65354,0.46457,0.65354,0.47244,0.65354,0.48031,0.65354,0.48819,0.65354,0.49606,0.65354,0.50394,0.65354,0.51181,0.65354,0.51969,0.65354,0.52756,0.65354,0.53543,0.65354,0.54331,0.65354,0.55118,0.65354,0.55906,0.65354,0.56693,0.65354,0.5748,0.65354,0.58268,0.65354,0.59055,0.65354};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_108()
		{
			double[] value = {0.59843,0.65354,0.6063,0.65354,0.61417,0.65354,0.62205,0.65354,0.62992,0.65354,0.6378,0.65354,0.64567,0.65354,0.65354,0.65354,0.66142,0.65354,0.66929,0.65354,0.67717,0.65354,0.68504,0.65354,0.69291,0.65354,0.70079,0.65354,0.70866,0.65354,0.71654,0.65354,0.72441,0.65354,0.73228,0.65354,0.74016,0.65354,0.74803,0.65354,0.75591,0.65354,0.76378,0.65354,0.77165,0.65354,0.77953,0.65354,0.7874,0.65354,0.79528,0.65354,0.80315,0.65354,0.81102,0.65354,0.8189,0.65354,0.82677,0.65354,0.83465,0.65354,0.84252,0.65354,0.85039,0.65354,0.85827,0.65354,0.86614,0.65354,0.87402,0.65354,0.88189,0.65354,0.88976,0.65354,0.89764,0.65354,0.90551,0.65354,0.91339,0.65354,0.92126,0.65354,0.92913,0.65354,0.93701,0.65354,0.94488,0.65354,0.95276,0.65354,0.96063,0.65354,0.9685,0.65354,0.97638,0.65354,0.98425,0.65354,0.99213,0.65354,0.99609,0.65354,0.00391,0.66142,0.00787,0.66142,0.01575,0.66142,0.02362,0.66142,0.0315,0.66142,0.03937,0.66142,0.04724,0.66142,0.05512,0.66142,0.06299,0.66142,0.07087,0.66142,0.07874,0.66142,0.08661,0.66142,0.09449,0.66142,0.10236,0.66142,0.11024,0.66142,0.11811,0.66142,0.12598,0.66142,0.13386,0.66142,0.14173,0.66142,0.14961,0.66142,0.15748,0.66142,0.16535,0.66142,0.17323,0.66142,0.1811,0.66142,0.18898,0.66142,0.19685,0.66142,0.20472,0.66142,0.2126,0.66142,0.22047,0.66142,0.22835,0.66142,0.23622,0.66142,0.24409,0.66142,0.25197,0.66142,0.25984,0.66142,0.26772,0.66142,0.27559,0.66142,0.28346,0.66142,0.29134,0.66142,0.29921,0.66142,0.30709,0.66142,0.31496,0.66142,0.32283,0.66142,0.33071,0.66142,0.33858,0.66142,0.34646,0.66142,0.35433,0.66142,0.3622,0.66142,0.37008,0.66142};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_109()
		{
			double[] value = {0.37795,0.66142,0.38583,0.66142,0.3937,0.66142,0.40157,0.66142,0.40945,0.66142,0.41732,0.66142,0.4252,0.66142,0.43307,0.66142,0.44094,0.66142,0.44882,0.66142,0.45669,0.66142,0.46457,0.66142,0.47244,0.66142,0.48031,0.66142,0.48819,0.66142,0.49606,0.66142,0.50394,0.66142,0.51181,0.66142,0.51969,0.66142,0.52756,0.66142,0.53543,0.66142,0.54331,0.66142,0.55118,0.66142,0.55906,0.66142,0.56693,0.66142,0.5748,0.66142,0.58268,0.66142,0.59055,0.66142,0.59843,0.66142,0.6063,0.66142,0.61417,0.66142,0.62205,0.66142,0.62992,0.66142,0.6378,0.66142,0.64567,0.66142,0.65354,0.66142,0.66142,0.66142,0.66929,0.66142,0.67717,0.66142,0.68504,0.66142,0.69291,0.66142,0.70079,0.66142,0.70866,0.66142,0.71654,0.66142,0.72441,0.66142,0.73228,0.66142,0.74016,0.66142,0.74803,0.66142,0.75591,0.66142,0.76378,0.66142,0.77165,0.66142,0.77953,0.66142,0.7874,0.66142,0.79528,0.66142,0.80315,0.66142,0.81102,0.66142,0.8189,0.66142,0.82677,0.66142,0.83465,0.66142,0.84252,0.66142,0.85039,0.66142,0.85827,0.66142,0.86614,0.66142,0.87402,0.66142,0.88189,0.66142,0.88976,0.66142,0.89764,0.66142,0.90551,0.66142,0.91339,0.66142,0.92126,0.66142,0.92913,0.66142,0.93701,0.66142,0.94488,0.66142,0.95276,0.66142,0.96063,0.66142,0.9685,0.66142,0.97638,0.66142,0.98425,0.66142,0.99213,0.66142,0.99609,0.66142,0.00391,0.66929,0.00787,0.66929,0.01575,0.66929,0.02362,0.66929,0.0315,0.66929,0.03937,0.66929,0.04724,0.66929,0.05512,0.66929,0.06299,0.66929,0.07087,0.66929,0.07874,0.66929,0.08661,0.66929,0.09449,0.66929,0.10236,0.66929,0.11024,0.66929,0.11811,0.66929,0.12598,0.66929,0.13386,0.66929,0.14173,0.66929,0.14961,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_110()
		{
			double[] value = {0.15748,0.66929,0.16535,0.66929,0.17323,0.66929,0.1811,0.66929,0.18898,0.66929,0.19685,0.66929,0.20472,0.66929,0.2126,0.66929,0.22047,0.66929,0.22835,0.66929,0.23622,0.66929,0.24409,0.66929,0.25197,0.66929,0.25984,0.66929,0.26772,0.66929,0.27559,0.66929,0.28346,0.66929,0.29134,0.66929,0.29921,0.66929,0.30709,0.66929,0.31496,0.66929,0.32283,0.66929,0.33071,0.66929,0.33858,0.66929,0.34646,0.66929,0.35433,0.66929,0.3622,0.66929,0.37008,0.66929,0.37795,0.66929,0.38583,0.66929,0.3937,0.66929,0.40157,0.66929,0.40945,0.66929,0.41732,0.66929,0.4252,0.66929,0.43307,0.66929,0.44094,0.66929,0.44882,0.66929,0.45669,0.66929,0.46457,0.66929,0.47244,0.66929,0.48031,0.66929,0.48819,0.66929,0.49606,0.66929,0.50394,0.66929,0.51181,0.66929,0.51969,0.66929,0.52756,0.66929,0.53543,0.66929,0.54331,0.66929,0.55118,0.66929,0.55906,0.66929,0.56693,0.66929,0.5748,0.66929,0.58268,0.66929,0.59055,0.66929,0.59843,0.66929,0.6063,0.66929,0.61417,0.66929,0.62205,0.66929,0.62992,0.66929,0.6378,0.66929,0.64567,0.66929,0.65354,0.66929,0.66142,0.66929,0.66929,0.66929,0.67717,0.66929,0.68504,0.66929,0.69291,0.66929,0.70079,0.66929,0.70866,0.66929,0.71654,0.66929,0.72441,0.66929,0.73228,0.66929,0.74016,0.66929,0.74803,0.66929,0.75591,0.66929,0.76378,0.66929,0.77165,0.66929,0.77953,0.66929,0.7874,0.66929,0.79528,0.66929,0.80315,0.66929,0.81102,0.66929,0.8189,0.66929,0.82677,0.66929,0.83465,0.66929,0.84252,0.66929,0.85039,0.66929,0.85827,0.66929,0.86614,0.66929,0.87402,0.66929,0.88189,0.66929,0.88976,0.66929,0.89764,0.66929,0.90551,0.66929,0.91339,0.66929,0.92126,0.66929,0.92913,0.66929,0.93701,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_111()
		{
			double[] value = {0.94488,0.66929,0.95276,0.66929,0.96063,0.66929,0.9685,0.66929,0.97638,0.66929,0.98425,0.66929,0.99213,0.66929,0.99609,0.66929,0.00391,0.67717,0.00787,0.67717,0.01575,0.67717,0.02362,0.67717,0.0315,0.67717,0.03937,0.67717,0.04724,0.67717,0.05512,0.67717,0.06299,0.67717,0.07087,0.67717,0.07874,0.67717,0.08661,0.67717,0.09449,0.67717,0.10236,0.67717,0.11024,0.67717,0.11811,0.67717,0.12598,0.67717,0.13386,0.67717,0.14173,0.67717,0.14961,0.67717,0.15748,0.67717,0.16535,0.67717,0.17323,0.67717,0.1811,0.67717,0.18898,0.67717,0.19685,0.67717,0.20472,0.67717,0.2126,0.67717,0.22047,0.67717,0.22835,0.67717,0.23622,0.67717,0.24409,0.67717,0.25197,0.67717,0.25984,0.67717,0.26772,0.67717,0.27559,0.67717,0.28346,0.67717,0.29134,0.67717,0.29921,0.67717,0.30709,0.67717,0.31496,0.67717,0.32283,0.67717,0.33071,0.67717,0.33858,0.67717,0.34646,0.67717,0.35433,0.67717,0.3622,0.67717,0.37008,0.67717,0.37795,0.67717,0.38583,0.67717,0.3937,0.67717,0.40157,0.67717,0.40945,0.67717,0.41732,0.67717,0.4252,0.67717,0.43307,0.67717,0.44094,0.67717,0.44882,0.67717,0.45669,0.67717,0.46457,0.67717,0.47244,0.67717,0.48031,0.67717,0.48819,0.67717,0.49606,0.67717,0.50394,0.67717,0.51181,0.67717,0.51969,0.67717,0.52756,0.67717,0.53543,0.67717,0.54331,0.67717,0.55118,0.67717,0.55906,0.67717,0.56693,0.67717,0.5748,0.67717,0.58268,0.67717,0.59055,0.67717,0.59843,0.67717,0.6063,0.67717,0.61417,0.67717,0.62205,0.67717,0.62992,0.67717,0.6378,0.67717,0.64567,0.67717,0.65354,0.67717,0.66142,0.67717,0.66929,0.67717,0.67717,0.67717,0.68504,0.67717,0.69291,0.67717,0.70079,0.67717,0.70866,0.67717,0.71654,0.67717};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_112()
		{
			double[] value = {0.72441,0.67717,0.73228,0.67717,0.74016,0.67717,0.74803,0.67717,0.75591,0.67717,0.76378,0.67717,0.77165,0.67717,0.77953,0.67717,0.7874,0.67717,0.79528,0.67717,0.80315,0.67717,0.81102,0.67717,0.8189,0.67717,0.82677,0.67717,0.83465,0.67717,0.84252,0.67717,0.85039,0.67717,0.85827,0.67717,0.86614,0.67717,0.87402,0.67717,0.88189,0.67717,0.88976,0.67717,0.89764,0.67717,0.90551,0.67717,0.91339,0.67717,0.92126,0.67717,0.92913,0.67717,0.93701,0.67717,0.94488,0.67717,0.95276,0.67717,0.96063,0.67717,0.9685,0.67717,0.97638,0.67717,0.98425,0.67717,0.99213,0.67717,0.99609,0.67717,0.00391,0.68504,0.00787,0.68504,0.01575,0.68504,0.02362,0.68504,0.0315,0.68504,0.03937,0.68504,0.04724,0.68504,0.05512,0.68504,0.06299,0.68504,0.07087,0.68504,0.07874,0.68504,0.08661,0.68504,0.09449,0.68504,0.10236,0.68504,0.11024,0.68504,0.11811,0.68504,0.12598,0.68504,0.13386,0.68504,0.14173,0.68504,0.14961,0.68504,0.15748,0.68504,0.16535,0.68504,0.17323,0.68504,0.1811,0.68504,0.18898,0.68504,0.19685,0.68504,0.20472,0.68504,0.2126,0.68504,0.22047,0.68504,0.22835,0.68504,0.23622,0.68504,0.24409,0.68504,0.25197,0.68504,0.25984,0.68504,0.26772,0.68504,0.27559,0.68504,0.28346,0.68504,0.29134,0.68504,0.29921,0.68504,0.30709,0.68504,0.31496,0.68504,0.32283,0.68504,0.33071,0.68504,0.33858,0.68504,0.34646,0.68504,0.35433,0.68504,0.3622,0.68504,0.37008,0.68504,0.37795,0.68504,0.38583,0.68504,0.3937,0.68504,0.40157,0.68504,0.40945,0.68504,0.41732,0.68504,0.4252,0.68504,0.43307,0.68504,0.44094,0.68504,0.44882,0.68504,0.45669,0.68504,0.46457,0.68504,0.47244,0.68504,0.48031,0.68504,0.48819,0.68504,0.49606,0.68504};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_113()
		{
			double[] value = {0.50394,0.68504,0.51181,0.68504,0.51969,0.68504,0.52756,0.68504,0.53543,0.68504,0.54331,0.68504,0.55118,0.68504,0.55906,0.68504,0.56693,0.68504,0.5748,0.68504,0.58268,0.68504,0.59055,0.68504,0.59843,0.68504,0.6063,0.68504,0.61417,0.68504,0.62205,0.68504,0.62992,0.68504,0.6378,0.68504,0.64567,0.68504,0.65354,0.68504,0.66142,0.68504,0.66929,0.68504,0.67717,0.68504,0.68504,0.68504,0.69291,0.68504,0.70079,0.68504,0.70866,0.68504,0.71654,0.68504,0.72441,0.68504,0.73228,0.68504,0.74016,0.68504,0.74803,0.68504,0.75591,0.68504,0.76378,0.68504,0.77165,0.68504,0.77953,0.68504,0.7874,0.68504,0.79528,0.68504,0.80315,0.68504,0.81102,0.68504,0.8189,0.68504,0.82677,0.68504,0.83465,0.68504,0.84252,0.68504,0.85039,0.68504,0.85827,0.68504,0.86614,0.68504,0.87402,0.68504,0.88189,0.68504,0.88976,0.68504,0.89764,0.68504,0.90551,0.68504,0.91339,0.68504,0.92126,0.68504,0.92913,0.68504,0.93701,0.68504,0.94488,0.68504,0.95276,0.68504,0.96063,0.68504,0.9685,0.68504,0.97638,0.68504,0.98425,0.68504,0.99213,0.68504,0.99609,0.68504,0.00391,0.69291,0.00787,0.69291,0.01575,0.69291,0.02362,0.69291,0.0315,0.69291,0.03937,0.69291,0.04724,0.69291,0.05512,0.69291,0.06299,0.69291,0.07087,0.69291,0.07874,0.69291,0.08661,0.69291,0.09449,0.69291,0.10236,0.69291,0.11024,0.69291,0.11811,0.69291,0.12598,0.69291,0.13386,0.69291,0.14173,0.69291,0.14961,0.69291,0.15748,0.69291,0.16535,0.69291,0.17323,0.69291,0.1811,0.69291,0.18898,0.69291,0.19685,0.69291,0.20472,0.69291,0.2126,0.69291,0.22047,0.69291,0.22835,0.69291,0.23622,0.69291,0.24409,0.69291,0.25197,0.69291,0.25984,0.69291,0.26772,0.69291,0.27559,0.69291};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_114()
		{
			double[] value = {0.28346,0.69291,0.29134,0.69291,0.29921,0.69291,0.30709,0.69291,0.31496,0.69291,0.32283,0.69291,0.33071,0.69291,0.33858,0.69291,0.34646,0.69291,0.35433,0.69291,0.3622,0.69291,0.37008,0.69291,0.37795,0.69291,0.38583,0.69291,0.3937,0.69291,0.40157,0.69291,0.40945,0.69291,0.41732,0.69291,0.4252,0.69291,0.43307,0.69291,0.44094,0.69291,0.44882,0.69291,0.45669,0.69291,0.46457,0.69291,0.47244,0.69291,0.48031,0.69291,0.48819,0.69291,0.49606,0.69291,0.50394,0.69291,0.51181,0.69291,0.51969,0.69291,0.52756,0.69291,0.53543,0.69291,0.54331,0.69291,0.55118,0.69291,0.55906,0.69291,0.56693,0.69291,0.5748,0.69291,0.58268,0.69291,0.59055,0.69291,0.59843,0.69291,0.6063,0.69291,0.61417,0.69291,0.62205,0.69291,0.62992,0.69291,0.6378,0.69291,0.64567,0.69291,0.65354,0.69291,0.66142,0.69291,0.66929,0.69291,0.67717,0.69291,0.68504,0.69291,0.69291,0.69291,0.70079,0.69291,0.70866,0.69291,0.71654,0.69291,0.72441,0.69291,0.73228,0.69291,0.74016,0.69291,0.74803,0.69291,0.75591,0.69291,0.76378,0.69291,0.77165,0.69291,0.77953,0.69291,0.7874,0.69291,0.79528,0.69291,0.80315,0.69291,0.81102,0.69291,0.8189,0.69291,0.82677,0.69291,0.83465,0.69291,0.84252,0.69291,0.85039,0.69291,0.85827,0.69291,0.86614,0.69291,0.87402,0.69291,0.88189,0.69291,0.88976,0.69291,0.89764,0.69291,0.90551,0.69291,0.91339,0.69291,0.92126,0.69291,0.92913,0.69291,0.93701,0.69291,0.94488,0.69291,0.95276,0.69291,0.96063,0.69291,0.9685,0.69291,0.97638,0.69291,0.98425,0.69291,0.99213,0.69291,0.99609,0.69291,0.00391,0.70079,0.00787,0.70079,0.01575,0.70079,0.02362,0.70079,0.0315,0.70079,0.03937,0.70079,0.04724,0.70079,0.05512,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_115()
		{
			double[] value = {0.06299,0.70079,0.07087,0.70079,0.07874,0.70079,0.08661,0.70079,0.09449,0.70079,0.10236,0.70079,0.11024,0.70079,0.11811,0.70079,0.12598,0.70079,0.13386,0.70079,0.14173,0.70079,0.14961,0.70079,0.15748,0.70079,0.16535,0.70079,0.17323,0.70079,0.1811,0.70079,0.18898,0.70079,0.19685,0.70079,0.20472,0.70079,0.2126,0.70079,0.22047,0.70079,0.22835,0.70079,0.23622,0.70079,0.24409,0.70079,0.25197,0.70079,0.25984,0.70079,0.26772,0.70079,0.27559,0.70079,0.28346,0.70079,0.29134,0.70079,0.29921,0.70079,0.30709,0.70079,0.31496,0.70079,0.32283,0.70079,0.33071,0.70079,0.33858,0.70079,0.34646,0.70079,0.35433,0.70079,0.3622,0.70079,0.37008,0.70079,0.37795,0.70079,0.38583,0.70079,0.3937,0.70079,0.40157,0.70079,0.40945,0.70079,0.41732,0.70079,0.4252,0.70079,0.43307,0.70079,0.44094,0.70079,0.44882,0.70079,0.45669,0.70079,0.46457,0.70079,0.47244,0.70079,0.48031,0.70079,0.48819,0.70079,0.49606,0.70079,0.50394,0.70079,0.51181,0.70079,0.51969,0.70079,0.52756,0.70079,0.53543,0.70079,0.54331,0.70079,0.55118,0.70079,0.55906,0.70079,0.56693,0.70079,0.5748,0.70079,0.58268,0.70079,0.59055,0.70079,0.59843,0.70079,0.6063,0.70079,0.61417,0.70079,0.62205,0.70079,0.62992,0.70079,0.6378,0.70079,0.64567,0.70079,0.65354,0.70079,0.66142,0.70079,0.66929,0.70079,0.67717,0.70079,0.68504,0.70079,0.69291,0.70079,0.70079,0.70079,0.70866,0.70079,0.71654,0.70079,0.72441,0.70079,0.73228,0.70079,0.74016,0.70079,0.74803,0.70079,0.75591,0.70079,0.76378,0.70079,0.77165,0.70079,0.77953,0.70079,0.7874,0.70079,0.79528,0.70079,0.80315,0.70079,0.81102,0.70079,0.8189,0.70079,0.82677,0.70079,0.83465,0.70079,0.84252,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_116()
		{
			double[] value = {0.85039,0.70079,0.85827,0.70079,0.86614,0.70079,0.87402,0.70079,0.88189,0.70079,0.88976,0.70079,0.89764,0.70079,0.90551,0.70079,0.91339,0.70079,0.92126,0.70079,0.92913,0.70079,0.93701,0.70079,0.94488,0.70079,0.95276,0.70079,0.96063,0.70079,0.9685,0.70079,0.97638,0.70079,0.98425,0.70079,0.99213,0.70079,0.99609,0.70079,0.00391,0.70866,0.00787,0.70866,0.01575,0.70866,0.02362,0.70866,0.0315,0.70866,0.03937,0.70866,0.04724,0.70866,0.05512,0.70866,0.06299,0.70866,0.07087,0.70866,0.07874,0.70866,0.08661,0.70866,0.09449,0.70866,0.10236,0.70866,0.11024,0.70866,0.11811,0.70866,0.12598,0.70866,0.13386,0.70866,0.14173,0.70866,0.14961,0.70866,0.15748,0.70866,0.16535,0.70866,0.17323,0.70866,0.1811,0.70866,0.18898,0.70866,0.19685,0.70866,0.20472,0.70866,0.2126,0.70866,0.22047,0.70866,0.22835,0.70866,0.23622,0.70866,0.24409,0.70866,0.25197,0.70866,0.25984,0.70866,0.26772,0.70866,0.27559,0.70866,0.28346,0.70866,0.29134,0.70866,0.29921,0.70866,0.30709,0.70866,0.31496,0.70866,0.32283,0.70866,0.33071,0.70866,0.33858,0.70866,0.34646,0.70866,0.35433,0.70866,0.3622,0.70866,0.37008,0.70866,0.37795,0.70866,0.38583,0.70866,0.3937,0.70866,0.40157,0.70866,0.40945,0.70866,0.41732,0.70866,0.4252,0.70866,0.43307,0.70866,0.44094,0.70866,0.44882,0.70866,0.45669,0.70866,0.46457,0.70866,0.47244,0.70866,0.48031,0.70866,0.48819,0.70866,0.49606,0.70866,0.50394,0.70866,0.51181,0.70866,0.51969,0.70866,0.52756,0.70866,0.53543,0.70866,0.54331,0.70866,0.55118,0.70866,0.55906,0.70866,0.56693,0.70866,0.5748,0.70866,0.58268,0.70866,0.59055,0.70866,0.59843,0.70866,0.6063,0.70866,0.61417,0.70866,0.62205,0.70866};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_117()
		{
			double[] value = {0.62992,0.70866,0.6378,0.70866,0.64567,0.70866,0.65354,0.70866,0.66142,0.70866,0.66929,0.70866,0.67717,0.70866,0.68504,0.70866,0.69291,0.70866,0.70079,0.70866,0.70866,0.70866,0.71654,0.70866,0.72441,0.70866,0.73228,0.70866,0.74016,0.70866,0.74803,0.70866,0.75591,0.70866,0.76378,0.70866,0.77165,0.70866,0.77953,0.70866,0.7874,0.70866,0.79528,0.70866,0.80315,0.70866,0.81102,0.70866,0.8189,0.70866,0.82677,0.70866,0.83465,0.70866,0.84252,0.70866,0.85039,0.70866,0.85827,0.70866,0.86614,0.70866,0.87402,0.70866,0.88189,0.70866,0.88976,0.70866,0.89764,0.70866,0.90551,0.70866,0.91339,0.70866,0.92126,0.70866,0.92913,0.70866,0.93701,0.70866,0.94488,0.70866,0.95276,0.70866,0.96063,0.70866,0.9685,0.70866,0.97638,0.70866,0.98425,0.70866,0.99213,0.70866,0.99609,0.70866,0.00391,0.71654,0.00787,0.71654,0.01575,0.71654,0.02362,0.71654,0.0315,0.71654,0.03937,0.71654,0.04724,0.71654,0.05512,0.71654,0.06299,0.71654,0.07087,0.71654,0.07874,0.71654,0.08661,0.71654,0.09449,0.71654,0.10236,0.71654,0.11024,0.71654,0.11811,0.71654,0.12598,0.71654,0.13386,0.71654,0.14173,0.71654,0.14961,0.71654,0.15748,0.71654,0.16535,0.71654,0.17323,0.71654,0.1811,0.71654,0.18898,0.71654,0.19685,0.71654,0.20472,0.71654,0.2126,0.71654,0.22047,0.71654,0.22835,0.71654,0.23622,0.71654,0.24409,0.71654,0.25197,0.71654,0.25984,0.71654,0.26772,0.71654,0.27559,0.71654,0.28346,0.71654,0.29134,0.71654,0.29921,0.71654,0.30709,0.71654,0.31496,0.71654,0.32283,0.71654,0.33071,0.71654,0.33858,0.71654,0.34646,0.71654,0.35433,0.71654,0.3622,0.71654,0.37008,0.71654,0.37795,0.71654,0.38583,0.71654,0.3937,0.71654,0.40157,0.71654};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_118()
		{
			double[] value = {0.40945,0.71654,0.41732,0.71654,0.4252,0.71654,0.43307,0.71654,0.44094,0.71654,0.44882,0.71654,0.45669,0.71654,0.46457,0.71654,0.47244,0.71654,0.48031,0.71654,0.48819,0.71654,0.49606,0.71654,0.50394,0.71654,0.51181,0.71654,0.51969,0.71654,0.52756,0.71654,0.53543,0.71654,0.54331,0.71654,0.55118,0.71654,0.55906,0.71654,0.56693,0.71654,0.5748,0.71654,0.58268,0.71654,0.59055,0.71654,0.59843,0.71654,0.6063,0.71654,0.61417,0.71654,0.62205,0.71654,0.62992,0.71654,0.6378,0.71654,0.64567,0.71654,0.65354,0.71654,0.66142,0.71654,0.66929,0.71654,0.67717,0.71654,0.68504,0.71654,0.69291,0.71654,0.70079,0.71654,0.70866,0.71654,0.71654,0.71654,0.72441,0.71654,0.73228,0.71654,0.74016,0.71654,0.74803,0.71654,0.75591,0.71654,0.76378,0.71654,0.77165,0.71654,0.77953,0.71654,0.7874,0.71654,0.79528,0.71654,0.80315,0.71654,0.81102,0.71654,0.8189,0.71654,0.82677,0.71654,0.83465,0.71654,0.84252,0.71654,0.85039,0.71654,0.85827,0.71654,0.86614,0.71654,0.87402,0.71654,0.88189,0.71654,0.88976,0.71654,0.89764,0.71654,0.90551,0.71654,0.91339,0.71654,0.92126,0.71654,0.92913,0.71654,0.93701,0.71654,0.94488,0.71654,0.95276,0.71654,0.96063,0.71654,0.9685,0.71654,0.97638,0.71654,0.98425,0.71654,0.99213,0.71654,0.99609,0.71654,0.00391,0.72441,0.00787,0.72441,0.01575,0.72441,0.02362,0.72441,0.0315,0.72441,0.03937,0.72441,0.04724,0.72441,0.05512,0.72441,0.06299,0.72441,0.07087,0.72441,0.07874,0.72441,0.08661,0.72441,0.09449,0.72441,0.10236,0.72441,0.11024,0.72441,0.11811,0.72441,0.12598,0.72441,0.13386,0.72441,0.14173,0.72441,0.14961,0.72441,0.15748,0.72441,0.16535,0.72441,0.17323,0.72441,0.1811,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_119()
		{
			double[] value = {0.18898,0.72441,0.19685,0.72441,0.20472,0.72441,0.2126,0.72441,0.22047,0.72441,0.22835,0.72441,0.23622,0.72441,0.24409,0.72441,0.25197,0.72441,0.25984,0.72441,0.26772,0.72441,0.27559,0.72441,0.28346,0.72441,0.29134,0.72441,0.29921,0.72441,0.30709,0.72441,0.31496,0.72441,0.32283,0.72441,0.33071,0.72441,0.33858,0.72441,0.34646,0.72441,0.35433,0.72441,0.3622,0.72441,0.37008,0.72441,0.37795,0.72441,0.38583,0.72441,0.3937,0.72441,0.40157,0.72441,0.40945,0.72441,0.41732,0.72441,0.4252,0.72441,0.43307,0.72441,0.44094,0.72441,0.44882,0.72441,0.45669,0.72441,0.46457,0.72441,0.47244,0.72441,0.48031,0.72441,0.48819,0.72441,0.49606,0.72441,0.50394,0.72441,0.51181,0.72441,0.51969,0.72441,0.52756,0.72441,0.53543,0.72441,0.54331,0.72441,0.55118,0.72441,0.55906,0.72441,0.56693,0.72441,0.5748,0.72441,0.58268,0.72441,0.59055,0.72441,0.59843,0.72441,0.6063,0.72441,0.61417,0.72441,0.62205,0.72441,0.62992,0.72441,0.6378,0.72441,0.64567,0.72441,0.65354,0.72441,0.66142,0.72441,0.66929,0.72441,0.67717,0.72441,0.68504,0.72441,0.69291,0.72441,0.70079,0.72441,0.70866,0.72441,0.71654,0.72441,0.72441,0.72441,0.73228,0.72441,0.74016,0.72441,0.74803,0.72441,0.75591,0.72441,0.76378,0.72441,0.77165,0.72441,0.77953,0.72441,0.7874,0.72441,0.79528,0.72441,0.80315,0.72441,0.81102,0.72441,0.8189,0.72441,0.82677,0.72441,0.83465,0.72441,0.84252,0.72441,0.85039,0.72441,0.85827,0.72441,0.86614,0.72441,0.87402,0.72441,0.88189,0.72441,0.88976,0.72441,0.89764,0.72441,0.90551,0.72441,0.91339,0.72441,0.92126,0.72441,0.92913,0.72441,0.93701,0.72441,0.94488,0.72441,0.95276,0.72441,0.96063,0.72441,0.9685,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_120()
		{
			double[] value = {0.97638,0.72441,0.98425,0.72441,0.99213,0.72441,0.99609,0.72441,0.00391,0.73228,0.00787,0.73228,0.01575,0.73228,0.02362,0.73228,0.0315,0.73228,0.03937,0.73228,0.04724,0.73228,0.05512,0.73228,0.06299,0.73228,0.07087,0.73228,0.07874,0.73228,0.08661,0.73228,0.09449,0.73228,0.10236,0.73228,0.11024,0.73228,0.11811,0.73228,0.12598,0.73228,0.13386,0.73228,0.14173,0.73228,0.14961,0.73228,0.15748,0.73228,0.16535,0.73228,0.17323,0.73228,0.1811,0.73228,0.18898,0.73228,0.19685,0.73228,0.20472,0.73228,0.2126,0.73228,0.22047,0.73228,0.22835,0.73228,0.23622,0.73228,0.24409,0.73228,0.25197,0.73228,0.25984,0.73228,0.26772,0.73228,0.27559,0.73228,0.28346,0.73228,0.29134,0.73228,0.29921,0.73228,0.30709,0.73228,0.31496,0.73228,0.32283,0.73228,0.33071,0.73228,0.33858,0.73228,0.34646,0.73228,0.35433,0.73228,0.3622,0.73228,0.37008,0.73228,0.37795,0.73228,0.38583,0.73228,0.3937,0.73228,0.40157,0.73228,0.40945,0.73228,0.41732,0.73228,0.4252,0.73228,0.43307,0.73228,0.44094,0.73228,0.44882,0.73228,0.45669,0.73228,0.46457,0.73228,0.47244,0.73228,0.48031,0.73228,0.48819,0.73228,0.49606,0.73228,0.50394,0.73228,0.51181,0.73228,0.51969,0.73228,0.52756,0.73228,0.53543,0.73228,0.54331,0.73228,0.55118,0.73228,0.55906,0.73228,0.56693,0.73228,0.5748,0.73228,0.58268,0.73228,0.59055,0.73228,0.59843,0.73228,0.6063,0.73228,0.61417,0.73228,0.62205,0.73228,0.62992,0.73228,0.6378,0.73228,0.64567,0.73228,0.65354,0.73228,0.66142,0.73228,0.66929,0.73228,0.67717,0.73228,0.68504,0.73228,0.69291,0.73228,0.70079,0.73228,0.70866,0.73228,0.71654,0.73228,0.72441,0.73228,0.73228,0.73228,0.74016,0.73228,0.74803,0.73228};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_121()
		{
			double[] value = {0.75591,0.73228,0.76378,0.73228,0.77165,0.73228,0.77953,0.73228,0.7874,0.73228,0.79528,0.73228,0.80315,0.73228,0.81102,0.73228,0.8189,0.73228,0.82677,0.73228,0.83465,0.73228,0.84252,0.73228,0.85039,0.73228,0.85827,0.73228,0.86614,0.73228,0.87402,0.73228,0.88189,0.73228,0.88976,0.73228,0.89764,0.73228,0.90551,0.73228,0.91339,0.73228,0.92126,0.73228,0.92913,0.73228,0.93701,0.73228,0.94488,0.73228,0.95276,0.73228,0.96063,0.73228,0.9685,0.73228,0.97638,0.73228,0.98425,0.73228,0.99213,0.73228,0.99609,0.73228,0.00391,0.74016,0.00787,0.74016,0.01575,0.74016,0.02362,0.74016,0.0315,0.74016,0.03937,0.74016,0.04724,0.74016,0.05512,0.74016,0.06299,0.74016,0.07087,0.74016,0.07874,0.74016,0.08661,0.74016,0.09449,0.74016,0.10236,0.74016,0.11024,0.74016,0.11811,0.74016,0.12598,0.74016,0.13386,0.74016,0.14173,0.74016,0.14961,0.74016,0.15748,0.74016,0.16535,0.74016,0.17323,0.74016,0.1811,0.74016,0.18898,0.74016,0.19685,0.74016,0.20472,0.74016,0.2126,0.74016,0.22047,0.74016,0.22835,0.74016,0.23622,0.74016,0.24409,0.74016,0.25197,0.74016,0.25984,0.74016,0.26772,0.74016,0.27559,0.74016,0.28346,0.74016,0.29134,0.74016,0.29921,0.74016,0.30709,0.74016,0.31496,0.74016,0.32283,0.74016,0.33071,0.74016,0.33858,0.74016,0.34646,0.74016,0.35433,0.74016,0.3622,0.74016,0.37008,0.74016,0.37795,0.74016,0.38583,0.74016,0.3937,0.74016,0.40157,0.74016,0.40945,0.74016,0.41732,0.74016,0.4252,0.74016,0.43307,0.74016,0.44094,0.74016,0.44882,0.74016,0.45669,0.74016,0.46457,0.74016,0.47244,0.74016,0.48031,0.74016,0.48819,0.74016,0.49606,0.74016,0.50394,0.74016,0.51181,0.74016,0.51969,0.74016,0.52756,0.74016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_122()
		{
			double[] value = {0.53543,0.74016,0.54331,0.74016,0.55118,0.74016,0.55906,0.74016,0.56693,0.74016,0.5748,0.74016,0.58268,0.74016,0.59055,0.74016,0.59843,0.74016,0.6063,0.74016,0.61417,0.74016,0.62205,0.74016,0.62992,0.74016,0.6378,0.74016,0.64567,0.74016,0.65354,0.74016,0.66142,0.74016,0.66929,0.74016,0.67717,0.74016,0.68504,0.74016,0.69291,0.74016,0.70079,0.74016,0.70866,0.74016,0.71654,0.74016,0.72441,0.74016,0.73228,0.74016,0.74016,0.74016,0.74803,0.74016,0.75591,0.74016,0.76378,0.74016,0.77165,0.74016,0.77953,0.74016,0.7874,0.74016,0.79528,0.74016,0.80315,0.74016,0.81102,0.74016,0.8189,0.74016,0.82677,0.74016,0.83465,0.74016,0.84252,0.74016,0.85039,0.74016,0.85827,0.74016,0.86614,0.74016,0.87402,0.74016,0.88189,0.74016,0.88976,0.74016,0.89764,0.74016,0.90551,0.74016,0.91339,0.74016,0.92126,0.74016,0.92913,0.74016,0.93701,0.74016,0.94488,0.74016,0.95276,0.74016,0.96063,0.74016,0.9685,0.74016,0.97638,0.74016,0.98425,0.74016,0.99213,0.74016,0.99609,0.74016,0.00391,0.74803,0.00787,0.74803,0.01575,0.74803,0.02362,0.74803,0.0315,0.74803,0.03937,0.74803,0.04724,0.74803,0.05512,0.74803,0.06299,0.74803,0.07087,0.74803,0.07874,0.74803,0.08661,0.74803,0.09449,0.74803,0.10236,0.74803,0.11024,0.74803,0.11811,0.74803,0.12598,0.74803,0.13386,0.74803,0.14173,0.74803,0.14961,0.74803,0.15748,0.74803,0.16535,0.74803,0.17323,0.74803,0.1811,0.74803,0.18898,0.74803,0.19685,0.74803,0.20472,0.74803,0.2126,0.74803,0.22047,0.74803,0.22835,0.74803,0.23622,0.74803,0.24409,0.74803,0.25197,0.74803,0.25984,0.74803,0.26772,0.74803,0.27559,0.74803,0.28346,0.74803,0.29134,0.74803,0.29921,0.74803,0.30709,0.74803};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_123()
		{
			double[] value = {0.31496,0.74803,0.32283,0.74803,0.33071,0.74803,0.33858,0.74803,0.34646,0.74803,0.35433,0.74803,0.3622,0.74803,0.37008,0.74803,0.37795,0.74803,0.38583,0.74803,0.3937,0.74803,0.40157,0.74803,0.40945,0.74803,0.41732,0.74803,0.4252,0.74803,0.43307,0.74803,0.44094,0.74803,0.44882,0.74803,0.45669,0.74803,0.46457,0.74803,0.47244,0.74803,0.48031,0.74803,0.48819,0.74803,0.49606,0.74803,0.50394,0.74803,0.51181,0.74803,0.51969,0.74803,0.52756,0.74803,0.53543,0.74803,0.54331,0.74803,0.55118,0.74803,0.55906,0.74803,0.56693,0.74803,0.5748,0.74803,0.58268,0.74803,0.59055,0.74803,0.59843,0.74803,0.6063,0.74803,0.61417,0.74803,0.62205,0.74803,0.62992,0.74803,0.6378,0.74803,0.64567,0.74803,0.65354,0.74803,0.66142,0.74803,0.66929,0.74803,0.67717,0.74803,0.68504,0.74803,0.69291,0.74803,0.70079,0.74803,0.70866,0.74803,0.71654,0.74803,0.72441,0.74803,0.73228,0.74803,0.74016,0.74803,0.74803,0.74803,0.75591,0.74803,0.76378,0.74803,0.77165,0.74803,0.77953,0.74803,0.7874,0.74803,0.79528,0.74803,0.80315,0.74803,0.81102,0.74803,0.8189,0.74803,0.82677,0.74803,0.83465,0.74803,0.84252,0.74803,0.85039,0.74803,0.85827,0.74803,0.86614,0.74803,0.87402,0.74803,0.88189,0.74803,0.88976,0.74803,0.89764,0.74803,0.90551,0.74803,0.91339,0.74803,0.92126,0.74803,0.92913,0.74803,0.93701,0.74803,0.94488,0.74803,0.95276,0.74803,0.96063,0.74803,0.9685,0.74803,0.97638,0.74803,0.98425,0.74803,0.99213,0.74803,0.99609,0.74803,0.00391,0.75591,0.00787,0.75591,0.01575,0.75591,0.02362,0.75591,0.0315,0.75591,0.03937,0.75591,0.04724,0.75591,0.05512,0.75591,0.06299,0.75591,0.07087,0.75591,0.07874,0.75591,0.08661,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_124()
		{
			double[] value = {0.09449,0.75591,0.10236,0.75591,0.11024,0.75591,0.11811,0.75591,0.12598,0.75591,0.13386,0.75591,0.14173,0.75591,0.14961,0.75591,0.15748,0.75591,0.16535,0.75591,0.17323,0.75591,0.1811,0.75591,0.18898,0.75591,0.19685,0.75591,0.20472,0.75591,0.2126,0.75591,0.22047,0.75591,0.22835,0.75591,0.23622,0.75591,0.24409,0.75591,0.25197,0.75591,0.25984,0.75591,0.26772,0.75591,0.27559,0.75591,0.28346,0.75591,0.29134,0.75591,0.29921,0.75591,0.30709,0.75591,0.31496,0.75591,0.32283,0.75591,0.33071,0.75591,0.33858,0.75591,0.34646,0.75591,0.35433,0.75591,0.3622,0.75591,0.37008,0.75591,0.37795,0.75591,0.38583,0.75591,0.3937,0.75591,0.40157,0.75591,0.40945,0.75591,0.41732,0.75591,0.4252,0.75591,0.43307,0.75591,0.44094,0.75591,0.44882,0.75591,0.45669,0.75591,0.46457,0.75591,0.47244,0.75591,0.48031,0.75591,0.48819,0.75591,0.49606,0.75591,0.50394,0.75591,0.51181,0.75591,0.51969,0.75591,0.52756,0.75591,0.53543,0.75591,0.54331,0.75591,0.55118,0.75591,0.55906,0.75591,0.56693,0.75591,0.5748,0.75591,0.58268,0.75591,0.59055,0.75591,0.59843,0.75591,0.6063,0.75591,0.61417,0.75591,0.62205,0.75591,0.62992,0.75591,0.6378,0.75591,0.64567,0.75591,0.65354,0.75591,0.66142,0.75591,0.66929,0.75591,0.67717,0.75591,0.68504,0.75591,0.69291,0.75591,0.70079,0.75591,0.70866,0.75591,0.71654,0.75591,0.72441,0.75591,0.73228,0.75591,0.74016,0.75591,0.74803,0.75591,0.75591,0.75591,0.76378,0.75591,0.77165,0.75591,0.77953,0.75591,0.7874,0.75591,0.79528,0.75591,0.80315,0.75591,0.81102,0.75591,0.8189,0.75591,0.82677,0.75591,0.83465,0.75591,0.84252,0.75591,0.85039,0.75591,0.85827,0.75591,0.86614,0.75591,0.87402,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_125()
		{
			double[] value = {0.88189,0.75591,0.88976,0.75591,0.89764,0.75591,0.90551,0.75591,0.91339,0.75591,0.92126,0.75591,0.92913,0.75591,0.93701,0.75591,0.94488,0.75591,0.95276,0.75591,0.96063,0.75591,0.9685,0.75591,0.97638,0.75591,0.98425,0.75591,0.99213,0.75591,0.99609,0.75591,0.00391,0.76378,0.00787,0.76378,0.01575,0.76378,0.02362,0.76378,0.0315,0.76378,0.03937,0.76378,0.04724,0.76378,0.05512,0.76378,0.06299,0.76378,0.07087,0.76378,0.07874,0.76378,0.08661,0.76378,0.09449,0.76378,0.10236,0.76378,0.11024,0.76378,0.11811,0.76378,0.12598,0.76378,0.13386,0.76378,0.14173,0.76378,0.14961,0.76378,0.15748,0.76378,0.16535,0.76378,0.17323,0.76378,0.1811,0.76378,0.18898,0.76378,0.19685,0.76378,0.20472,0.76378,0.2126,0.76378,0.22047,0.76378,0.22835,0.76378,0.23622,0.76378,0.24409,0.76378,0.25197,0.76378,0.25984,0.76378,0.26772,0.76378,0.27559,0.76378,0.28346,0.76378,0.29134,0.76378,0.29921,0.76378,0.30709,0.76378,0.31496,0.76378,0.32283,0.76378,0.33071,0.76378,0.33858,0.76378,0.34646,0.76378,0.35433,0.76378,0.3622,0.76378,0.37008,0.76378,0.37795,0.76378,0.38583,0.76378,0.3937,0.76378,0.40157,0.76378,0.40945,0.76378,0.41732,0.76378,0.4252,0.76378,0.43307,0.76378,0.44094,0.76378,0.44882,0.76378,0.45669,0.76378,0.46457,0.76378,0.47244,0.76378,0.48031,0.76378,0.48819,0.76378,0.49606,0.76378,0.50394,0.76378,0.51181,0.76378,0.51969,0.76378,0.52756,0.76378,0.53543,0.76378,0.54331,0.76378,0.55118,0.76378,0.55906,0.76378,0.56693,0.76378,0.5748,0.76378,0.58268,0.76378,0.59055,0.76378,0.59843,0.76378,0.6063,0.76378,0.61417,0.76378,0.62205,0.76378,0.62992,0.76378,0.6378,0.76378,0.64567,0.76378,0.65354,0.76378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_126()
		{
			double[] value = {0.66142,0.76378,0.66929,0.76378,0.67717,0.76378,0.68504,0.76378,0.69291,0.76378,0.70079,0.76378,0.70866,0.76378,0.71654,0.76378,0.72441,0.76378,0.73228,0.76378,0.74016,0.76378,0.74803,0.76378,0.75591,0.76378,0.76378,0.76378,0.77165,0.76378,0.77953,0.76378,0.7874,0.76378,0.79528,0.76378,0.80315,0.76378,0.81102,0.76378,0.8189,0.76378,0.82677,0.76378,0.83465,0.76378,0.84252,0.76378,0.85039,0.76378,0.85827,0.76378,0.86614,0.76378,0.87402,0.76378,0.88189,0.76378,0.88976,0.76378,0.89764,0.76378,0.90551,0.76378,0.91339,0.76378,0.92126,0.76378,0.92913,0.76378,0.93701,0.76378,0.94488,0.76378,0.95276,0.76378,0.96063,0.76378,0.9685,0.76378,0.97638,0.76378,0.98425,0.76378,0.99213,0.76378,0.99609,0.76378,0.00391,0.77165,0.00787,0.77165,0.01575,0.77165,0.02362,0.77165,0.0315,0.77165,0.03937,0.77165,0.04724,0.77165,0.05512,0.77165,0.06299,0.77165,0.07087,0.77165,0.07874,0.77165,0.08661,0.77165,0.09449,0.77165,0.10236,0.77165,0.11024,0.77165,0.11811,0.77165,0.12598,0.77165,0.13386,0.77165,0.14173,0.77165,0.14961,0.77165,0.15748,0.77165,0.16535,0.77165,0.17323,0.77165,0.1811,0.77165,0.18898,0.77165,0.19685,0.77165,0.20472,0.77165,0.2126,0.77165,0.22047,0.77165,0.22835,0.77165,0.23622,0.77165,0.24409,0.77165,0.25197,0.77165,0.25984,0.77165,0.26772,0.77165,0.27559,0.77165,0.28346,0.77165,0.29134,0.77165,0.29921,0.77165,0.30709,0.77165,0.31496,0.77165,0.32283,0.77165,0.33071,0.77165,0.33858,0.77165,0.34646,0.77165,0.35433,0.77165,0.3622,0.77165,0.37008,0.77165,0.37795,0.77165,0.38583,0.77165,0.3937,0.77165,0.40157,0.77165,0.40945,0.77165,0.41732,0.77165,0.4252,0.77165,0.43307,0.77165};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_127()
		{
			double[] value = {0.44094,0.77165,0.44882,0.77165,0.45669,0.77165,0.46457,0.77165,0.47244,0.77165,0.48031,0.77165,0.48819,0.77165,0.49606,0.77165,0.50394,0.77165,0.51181,0.77165,0.51969,0.77165,0.52756,0.77165,0.53543,0.77165,0.54331,0.77165,0.55118,0.77165,0.55906,0.77165,0.56693,0.77165,0.5748,0.77165,0.58268,0.77165,0.59055,0.77165,0.59843,0.77165,0.6063,0.77165,0.61417,0.77165,0.62205,0.77165,0.62992,0.77165,0.6378,0.77165,0.64567,0.77165,0.65354,0.77165,0.66142,0.77165,0.66929,0.77165,0.67717,0.77165,0.68504,0.77165,0.69291,0.77165,0.70079,0.77165,0.70866,0.77165,0.71654,0.77165,0.72441,0.77165,0.73228,0.77165,0.74016,0.77165,0.74803,0.77165,0.75591,0.77165,0.76378,0.77165,0.77165,0.77165,0.77953,0.77165,0.7874,0.77165,0.79528,0.77165,0.80315,0.77165,0.81102,0.77165,0.8189,0.77165,0.82677,0.77165,0.83465,0.77165,0.84252,0.77165,0.85039,0.77165,0.85827,0.77165,0.86614,0.77165,0.87402,0.77165,0.88189,0.77165,0.88976,0.77165,0.89764,0.77165,0.90551,0.77165,0.91339,0.77165,0.92126,0.77165,0.92913,0.77165,0.93701,0.77165,0.94488,0.77165,0.95276,0.77165,0.96063,0.77165,0.9685,0.77165,0.97638,0.77165,0.98425,0.77165,0.99213,0.77165,0.99609,0.77165,0.00391,0.77953,0.00787,0.77953,0.01575,0.77953,0.02362,0.77953,0.0315,0.77953,0.03937,0.77953,0.04724,0.77953,0.05512,0.77953,0.06299,0.77953,0.07087,0.77953,0.07874,0.77953,0.08661,0.77953,0.09449,0.77953,0.10236,0.77953,0.11024,0.77953,0.11811,0.77953,0.12598,0.77953,0.13386,0.77953,0.14173,0.77953,0.14961,0.77953,0.15748,0.77953,0.16535,0.77953,0.17323,0.77953,0.1811,0.77953,0.18898,0.77953,0.19685,0.77953,0.20472,0.77953,0.2126,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_128()
		{
			double[] value = {0.22047,0.77953,0.22835,0.77953,0.23622,0.77953,0.24409,0.77953,0.25197,0.77953,0.25984,0.77953,0.26772,0.77953,0.27559,0.77953,0.28346,0.77953,0.29134,0.77953,0.29921,0.77953,0.30709,0.77953,0.31496,0.77953,0.32283,0.77953,0.33071,0.77953,0.33858,0.77953,0.34646,0.77953,0.35433,0.77953,0.3622,0.77953,0.37008,0.77953,0.37795,0.77953,0.38583,0.77953,0.3937,0.77953,0.40157,0.77953,0.40945,0.77953,0.41732,0.77953,0.4252,0.77953,0.43307,0.77953,0.44094,0.77953,0.44882,0.77953,0.45669,0.77953,0.46457,0.77953,0.47244,0.77953,0.48031,0.77953,0.48819,0.77953,0.49606,0.77953,0.50394,0.77953,0.51181,0.77953,0.51969,0.77953,0.52756,0.77953,0.53543,0.77953,0.54331,0.77953,0.55118,0.77953,0.55906,0.77953,0.56693,0.77953,0.5748,0.77953,0.58268,0.77953,0.59055,0.77953,0.59843,0.77953,0.6063,0.77953,0.61417,0.77953,0.62205,0.77953,0.62992,0.77953,0.6378,0.77953,0.64567,0.77953,0.65354,0.77953,0.66142,0.77953,0.66929,0.77953,0.67717,0.77953,0.68504,0.77953,0.69291,0.77953,0.70079,0.77953,0.70866,0.77953,0.71654,0.77953,0.72441,0.77953,0.73228,0.77953,0.74016,0.77953,0.74803,0.77953,0.75591,0.77953,0.76378,0.77953,0.77165,0.77953,0.77953,0.77953,0.7874,0.77953,0.79528,0.77953,0.80315,0.77953,0.81102,0.77953,0.8189,0.77953,0.82677,0.77953,0.83465,0.77953,0.84252,0.77953,0.85039,0.77953,0.85827,0.77953,0.86614,0.77953,0.87402,0.77953,0.88189,0.77953,0.88976,0.77953,0.89764,0.77953,0.90551,0.77953,0.91339,0.77953,0.92126,0.77953,0.92913,0.77953,0.93701,0.77953,0.94488,0.77953,0.95276,0.77953,0.96063,0.77953,0.9685,0.77953,0.97638,0.77953,0.98425,0.77953,0.99213,0.77953,0.99609,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_129()
		{
			double[] value = {0.00391,0.7874,0.00787,0.7874,0.01575,0.7874,0.02362,0.7874,0.0315,0.7874,0.03937,0.7874,0.04724,0.7874,0.05512,0.7874,0.06299,0.7874,0.07087,0.7874,0.07874,0.7874,0.08661,0.7874,0.09449,0.7874,0.10236,0.7874,0.11024,0.7874,0.11811,0.7874,0.12598,0.7874,0.13386,0.7874,0.14173,0.7874,0.14961,0.7874,0.15748,0.7874,0.16535,0.7874,0.17323,0.7874,0.1811,0.7874,0.18898,0.7874,0.19685,0.7874,0.20472,0.7874,0.2126,0.7874,0.22047,0.7874,0.22835,0.7874,0.23622,0.7874,0.24409,0.7874,0.25197,0.7874,0.25984,0.7874,0.26772,0.7874,0.27559,0.7874,0.28346,0.7874,0.29134,0.7874,0.29921,0.7874,0.30709,0.7874,0.31496,0.7874,0.32283,0.7874,0.33071,0.7874,0.33858,0.7874,0.34646,0.7874,0.35433,0.7874,0.3622,0.7874,0.37008,0.7874,0.37795,0.7874,0.38583,0.7874,0.3937,0.7874,0.40157,0.7874,0.40945,0.7874,0.41732,0.7874,0.4252,0.7874,0.43307,0.7874,0.44094,0.7874,0.44882,0.7874,0.45669,0.7874,0.46457,0.7874,0.47244,0.7874,0.48031,0.7874,0.48819,0.7874,0.49606,0.7874,0.50394,0.7874,0.51181,0.7874,0.51969,0.7874,0.52756,0.7874,0.53543,0.7874,0.54331,0.7874,0.55118,0.7874,0.55906,0.7874,0.56693,0.7874,0.5748,0.7874,0.58268,0.7874,0.59055,0.7874,0.59843,0.7874,0.6063,0.7874,0.61417,0.7874,0.62205,0.7874,0.62992,0.7874,0.6378,0.7874,0.64567,0.7874,0.65354,0.7874,0.66142,0.7874,0.66929,0.7874,0.67717,0.7874,0.68504,0.7874,0.69291,0.7874,0.70079,0.7874,0.70866,0.7874,0.71654,0.7874,0.72441,0.7874,0.73228,0.7874,0.74016,0.7874,0.74803,0.7874,0.75591,0.7874,0.76378,0.7874,0.77165,0.7874,0.77953,0.7874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_130()
		{
			double[] value = {0.7874,0.7874,0.79528,0.7874,0.80315,0.7874,0.81102,0.7874,0.8189,0.7874,0.82677,0.7874,0.83465,0.7874,0.84252,0.7874,0.85039,0.7874,0.85827,0.7874,0.86614,0.7874,0.87402,0.7874,0.88189,0.7874,0.88976,0.7874,0.89764,0.7874,0.90551,0.7874,0.91339,0.7874,0.92126,0.7874,0.92913,0.7874,0.93701,0.7874,0.94488,0.7874,0.95276,0.7874,0.96063,0.7874,0.9685,0.7874,0.97638,0.7874,0.98425,0.7874,0.99213,0.7874,0.99609,0.7874,0.00391,0.79528,0.00787,0.79528,0.01575,0.79528,0.02362,0.79528,0.0315,0.79528,0.03937,0.79528,0.04724,0.79528,0.05512,0.79528,0.06299,0.79528,0.07087,0.79528,0.07874,0.79528,0.08661,0.79528,0.09449,0.79528,0.10236,0.79528,0.11024,0.79528,0.11811,0.79528,0.12598,0.79528,0.13386,0.79528,0.14173,0.79528,0.14961,0.79528,0.15748,0.79528,0.16535,0.79528,0.17323,0.79528,0.1811,0.79528,0.18898,0.79528,0.19685,0.79528,0.20472,0.79528,0.2126,0.79528,0.22047,0.79528,0.22835,0.79528,0.23622,0.79528,0.24409,0.79528,0.25197,0.79528,0.25984,0.79528,0.26772,0.79528,0.27559,0.79528,0.28346,0.79528,0.29134,0.79528,0.29921,0.79528,0.30709,0.79528,0.31496,0.79528,0.32283,0.79528,0.33071,0.79528,0.33858,0.79528,0.34646,0.79528,0.35433,0.79528,0.3622,0.79528,0.37008,0.79528,0.37795,0.79528,0.38583,0.79528,0.3937,0.79528,0.40157,0.79528,0.40945,0.79528,0.41732,0.79528,0.4252,0.79528,0.43307,0.79528,0.44094,0.79528,0.44882,0.79528,0.45669,0.79528,0.46457,0.79528,0.47244,0.79528,0.48031,0.79528,0.48819,0.79528,0.49606,0.79528,0.50394,0.79528,0.51181,0.79528,0.51969,0.79528,0.52756,0.79528,0.53543,0.79528,0.54331,0.79528,0.55118,0.79528,0.55906,0.79528};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_131()
		{
			double[] value = {0.56693,0.79528,0.5748,0.79528,0.58268,0.79528,0.59055,0.79528,0.59843,0.79528,0.6063,0.79528,0.61417,0.79528,0.62205,0.79528,0.62992,0.79528,0.6378,0.79528,0.64567,0.79528,0.65354,0.79528,0.66142,0.79528,0.66929,0.79528,0.67717,0.79528,0.68504,0.79528,0.69291,0.79528,0.70079,0.79528,0.70866,0.79528,0.71654,0.79528,0.72441,0.79528,0.73228,0.79528,0.74016,0.79528,0.74803,0.79528,0.75591,0.79528,0.76378,0.79528,0.77165,0.79528,0.77953,0.79528,0.7874,0.79528,0.79528,0.79528,0.80315,0.79528,0.81102,0.79528,0.8189,0.79528,0.82677,0.79528,0.83465,0.79528,0.84252,0.79528,0.85039,0.79528,0.85827,0.79528,0.86614,0.79528,0.87402,0.79528,0.88189,0.79528,0.88976,0.79528,0.89764,0.79528,0.90551,0.79528,0.91339,0.79528,0.92126,0.79528,0.92913,0.79528,0.93701,0.79528,0.94488,0.79528,0.95276,0.79528,0.96063,0.79528,0.9685,0.79528,0.97638,0.79528,0.98425,0.79528,0.99213,0.79528,0.99609,0.79528,0.00391,0.80315,0.00787,0.80315,0.01575,0.80315,0.02362,0.80315,0.0315,0.80315,0.03937,0.80315,0.04724,0.80315,0.05512,0.80315,0.06299,0.80315,0.07087,0.80315,0.07874,0.80315,0.08661,0.80315,0.09449,0.80315,0.10236,0.80315,0.11024,0.80315,0.11811,0.80315,0.12598,0.80315,0.13386,0.80315,0.14173,0.80315,0.14961,0.80315,0.15748,0.80315,0.16535,0.80315,0.17323,0.80315,0.1811,0.80315,0.18898,0.80315,0.19685,0.80315,0.20472,0.80315,0.2126,0.80315,0.22047,0.80315,0.22835,0.80315,0.23622,0.80315,0.24409,0.80315,0.25197,0.80315,0.25984,0.80315,0.26772,0.80315,0.27559,0.80315,0.28346,0.80315,0.29134,0.80315,0.29921,0.80315,0.30709,0.80315,0.31496,0.80315,0.32283,0.80315,0.33071,0.80315,0.33858,0.80315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_132()
		{
			double[] value = {0.34646,0.80315,0.35433,0.80315,0.3622,0.80315,0.37008,0.80315,0.37795,0.80315,0.38583,0.80315,0.3937,0.80315,0.40157,0.80315,0.40945,0.80315,0.41732,0.80315,0.4252,0.80315,0.43307,0.80315,0.44094,0.80315,0.44882,0.80315,0.45669,0.80315,0.46457,0.80315,0.47244,0.80315,0.48031,0.80315,0.48819,0.80315,0.49606,0.80315,0.50394,0.80315,0.51181,0.80315,0.51969,0.80315,0.52756,0.80315,0.53543,0.80315,0.54331,0.80315,0.55118,0.80315,0.55906,0.80315,0.56693,0.80315,0.5748,0.80315,0.58268,0.80315,0.59055,0.80315,0.59843,0.80315,0.6063,0.80315,0.61417,0.80315,0.62205,0.80315,0.62992,0.80315,0.6378,0.80315,0.64567,0.80315,0.65354,0.80315,0.66142,0.80315,0.66929,0.80315,0.67717,0.80315,0.68504,0.80315,0.69291,0.80315,0.70079,0.80315,0.70866,0.80315,0.71654,0.80315,0.72441,0.80315,0.73228,0.80315,0.74016,0.80315,0.74803,0.80315,0.75591,0.80315,0.76378,0.80315,0.77165,0.80315,0.77953,0.80315,0.7874,0.80315,0.79528,0.80315,0.80315,0.80315,0.81102,0.80315,0.8189,0.80315,0.82677,0.80315,0.83465,0.80315,0.84252,0.80315,0.85039,0.80315,0.85827,0.80315,0.86614,0.80315,0.87402,0.80315,0.88189,0.80315,0.88976,0.80315,0.89764,0.80315,0.90551,0.80315,0.91339,0.80315,0.92126,0.80315,0.92913,0.80315,0.93701,0.80315,0.94488,0.80315,0.95276,0.80315,0.96063,0.80315,0.9685,0.80315,0.97638,0.80315,0.98425,0.80315,0.99213,0.80315,0.99609,0.80315,0.00391,0.81102,0.00787,0.81102,0.01575,0.81102,0.02362,0.81102,0.0315,0.81102,0.03937,0.81102,0.04724,0.81102,0.05512,0.81102,0.06299,0.81102,0.07087,0.81102,0.07874,0.81102,0.08661,0.81102,0.09449,0.81102,0.10236,0.81102,0.11024,0.81102,0.11811,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_133()
		{
			double[] value = {0.12598,0.81102,0.13386,0.81102,0.14173,0.81102,0.14961,0.81102,0.15748,0.81102,0.16535,0.81102,0.17323,0.81102,0.1811,0.81102,0.18898,0.81102,0.19685,0.81102,0.20472,0.81102,0.2126,0.81102,0.22047,0.81102,0.22835,0.81102,0.23622,0.81102,0.24409,0.81102,0.25197,0.81102,0.25984,0.81102,0.26772,0.81102,0.27559,0.81102,0.28346,0.81102,0.29134,0.81102,0.29921,0.81102,0.30709,0.81102,0.31496,0.81102,0.32283,0.81102,0.33071,0.81102,0.33858,0.81102,0.34646,0.81102,0.35433,0.81102,0.3622,0.81102,0.37008,0.81102,0.37795,0.81102,0.38583,0.81102,0.3937,0.81102,0.40157,0.81102,0.40945,0.81102,0.41732,0.81102,0.4252,0.81102,0.43307,0.81102,0.44094,0.81102,0.44882,0.81102,0.45669,0.81102,0.46457,0.81102,0.47244,0.81102,0.48031,0.81102,0.48819,0.81102,0.49606,0.81102,0.50394,0.81102,0.51181,0.81102,0.51969,0.81102,0.52756,0.81102,0.53543,0.81102,0.54331,0.81102,0.55118,0.81102,0.55906,0.81102,0.56693,0.81102,0.5748,0.81102,0.58268,0.81102,0.59055,0.81102,0.59843,0.81102,0.6063,0.81102,0.61417,0.81102,0.62205,0.81102,0.62992,0.81102,0.6378,0.81102,0.64567,0.81102,0.65354,0.81102,0.66142,0.81102,0.66929,0.81102,0.67717,0.81102,0.68504,0.81102,0.69291,0.81102,0.70079,0.81102,0.70866,0.81102,0.71654,0.81102,0.72441,0.81102,0.73228,0.81102,0.74016,0.81102,0.74803,0.81102,0.75591,0.81102,0.76378,0.81102,0.77165,0.81102,0.77953,0.81102,0.7874,0.81102,0.79528,0.81102,0.80315,0.81102,0.81102,0.81102,0.8189,0.81102,0.82677,0.81102,0.83465,0.81102,0.84252,0.81102,0.85039,0.81102,0.85827,0.81102,0.86614,0.81102,0.87402,0.81102,0.88189,0.81102,0.88976,0.81102,0.89764,0.81102,0.90551,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_134()
		{
			double[] value = {0.91339,0.81102,0.92126,0.81102,0.92913,0.81102,0.93701,0.81102,0.94488,0.81102,0.95276,0.81102,0.96063,0.81102,0.9685,0.81102,0.97638,0.81102,0.98425,0.81102,0.99213,0.81102,0.99609,0.81102,0.00391,0.8189,0.00787,0.8189,0.01575,0.8189,0.02362,0.8189,0.0315,0.8189,0.03937,0.8189,0.04724,0.8189,0.05512,0.8189,0.06299,0.8189,0.07087,0.8189,0.07874,0.8189,0.08661,0.8189,0.09449,0.8189,0.10236,0.8189,0.11024,0.8189,0.11811,0.8189,0.12598,0.8189,0.13386,0.8189,0.14173,0.8189,0.14961,0.8189,0.15748,0.8189,0.16535,0.8189,0.17323,0.8189,0.1811,0.8189,0.18898,0.8189,0.19685,0.8189,0.20472,0.8189,0.2126,0.8189,0.22047,0.8189,0.22835,0.8189,0.23622,0.8189,0.24409,0.8189,0.25197,0.8189,0.25984,0.8189,0.26772,0.8189,0.27559,0.8189,0.28346,0.8189,0.29134,0.8189,0.29921,0.8189,0.30709,0.8189,0.31496,0.8189,0.32283,0.8189,0.33071,0.8189,0.33858,0.8189,0.34646,0.8189,0.35433,0.8189,0.3622,0.8189,0.37008,0.8189,0.37795,0.8189,0.38583,0.8189,0.3937,0.8189,0.40157,0.8189,0.40945,0.8189,0.41732,0.8189,0.4252,0.8189,0.43307,0.8189,0.44094,0.8189,0.44882,0.8189,0.45669,0.8189,0.46457,0.8189,0.47244,0.8189,0.48031,0.8189,0.48819,0.8189,0.49606,0.8189,0.50394,0.8189,0.51181,0.8189,0.51969,0.8189,0.52756,0.8189,0.53543,0.8189,0.54331,0.8189,0.55118,0.8189,0.55906,0.8189,0.56693,0.8189,0.5748,0.8189,0.58268,0.8189,0.59055,0.8189,0.59843,0.8189,0.6063,0.8189,0.61417,0.8189,0.62205,0.8189,0.62992,0.8189,0.6378,0.8189,0.64567,0.8189,0.65354,0.8189,0.66142,0.8189,0.66929,0.8189,0.67717,0.8189,0.68504,0.8189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_135()
		{
			double[] value = {0.69291,0.8189,0.70079,0.8189,0.70866,0.8189,0.71654,0.8189,0.72441,0.8189,0.73228,0.8189,0.74016,0.8189,0.74803,0.8189,0.75591,0.8189,0.76378,0.8189,0.77165,0.8189,0.77953,0.8189,0.7874,0.8189,0.79528,0.8189,0.80315,0.8189,0.81102,0.8189,0.8189,0.8189,0.82677,0.8189,0.83465,0.8189,0.84252,0.8189,0.85039,0.8189,0.85827,0.8189,0.86614,0.8189,0.87402,0.8189,0.88189,0.8189,0.88976,0.8189,0.89764,0.8189,0.90551,0.8189,0.91339,0.8189,0.92126,0.8189,0.92913,0.8189,0.93701,0.8189,0.94488,0.8189,0.95276,0.8189,0.96063,0.8189,0.9685,0.8189,0.97638,0.8189,0.98425,0.8189,0.99213,0.8189,0.99609,0.8189,0.00391,0.82677,0.00787,0.82677,0.01575,0.82677,0.02362,0.82677,0.0315,0.82677,0.03937,0.82677,0.04724,0.82677,0.05512,0.82677,0.06299,0.82677,0.07087,0.82677,0.07874,0.82677,0.08661,0.82677,0.09449,0.82677,0.10236,0.82677,0.11024,0.82677,0.11811,0.82677,0.12598,0.82677,0.13386,0.82677,0.14173,0.82677,0.14961,0.82677,0.15748,0.82677,0.16535,0.82677,0.17323,0.82677,0.1811,0.82677,0.18898,0.82677,0.19685,0.82677,0.20472,0.82677,0.2126,0.82677,0.22047,0.82677,0.22835,0.82677,0.23622,0.82677,0.24409,0.82677,0.25197,0.82677,0.25984,0.82677,0.26772,0.82677,0.27559,0.82677,0.28346,0.82677,0.29134,0.82677,0.29921,0.82677,0.30709,0.82677,0.31496,0.82677,0.32283,0.82677,0.33071,0.82677,0.33858,0.82677,0.34646,0.82677,0.35433,0.82677,0.3622,0.82677,0.37008,0.82677,0.37795,0.82677,0.38583,0.82677,0.3937,0.82677,0.40157,0.82677,0.40945,0.82677,0.41732,0.82677,0.4252,0.82677,0.43307,0.82677,0.44094,0.82677,0.44882,0.82677,0.45669,0.82677,0.46457,0.82677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_136()
		{
			double[] value = {0.47244,0.82677,0.48031,0.82677,0.48819,0.82677,0.49606,0.82677,0.50394,0.82677,0.51181,0.82677,0.51969,0.82677,0.52756,0.82677,0.53543,0.82677,0.54331,0.82677,0.55118,0.82677,0.55906,0.82677,0.56693,0.82677,0.5748,0.82677,0.58268,0.82677,0.59055,0.82677,0.59843,0.82677,0.6063,0.82677,0.61417,0.82677,0.62205,0.82677,0.62992,0.82677,0.6378,0.82677,0.64567,0.82677,0.65354,0.82677,0.66142,0.82677,0.66929,0.82677,0.67717,0.82677,0.68504,0.82677,0.69291,0.82677,0.70079,0.82677,0.70866,0.82677,0.71654,0.82677,0.72441,0.82677,0.73228,0.82677,0.74016,0.82677,0.74803,0.82677,0.75591,0.82677,0.76378,0.82677,0.77165,0.82677,0.77953,0.82677,0.7874,0.82677,0.79528,0.82677,0.80315,0.82677,0.81102,0.82677,0.8189,0.82677,0.82677,0.82677,0.83465,0.82677,0.84252,0.82677,0.85039,0.82677,0.85827,0.82677,0.86614,0.82677,0.87402,0.82677,0.88189,0.82677,0.88976,0.82677,0.89764,0.82677,0.90551,0.82677,0.91339,0.82677,0.92126,0.82677,0.92913,0.82677,0.93701,0.82677,0.94488,0.82677,0.95276,0.82677,0.96063,0.82677,0.9685,0.82677,0.97638,0.82677,0.98425,0.82677,0.99213,0.82677,0.99609,0.82677,0.00391,0.83465,0.00787,0.83465,0.01575,0.83465,0.02362,0.83465,0.0315,0.83465,0.03937,0.83465,0.04724,0.83465,0.05512,0.83465,0.06299,0.83465,0.07087,0.83465,0.07874,0.83465,0.08661,0.83465,0.09449,0.83465,0.10236,0.83465,0.11024,0.83465,0.11811,0.83465,0.12598,0.83465,0.13386,0.83465,0.14173,0.83465,0.14961,0.83465,0.15748,0.83465,0.16535,0.83465,0.17323,0.83465,0.1811,0.83465,0.18898,0.83465,0.19685,0.83465,0.20472,0.83465,0.2126,0.83465,0.22047,0.83465,0.22835,0.83465,0.23622,0.83465,0.24409,0.83465};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_137()
		{
			double[] value = {0.25197,0.83465,0.25984,0.83465,0.26772,0.83465,0.27559,0.83465,0.28346,0.83465,0.29134,0.83465,0.29921,0.83465,0.30709,0.83465,0.31496,0.83465,0.32283,0.83465,0.33071,0.83465,0.33858,0.83465,0.34646,0.83465,0.35433,0.83465,0.3622,0.83465,0.37008,0.83465,0.37795,0.83465,0.38583,0.83465,0.3937,0.83465,0.40157,0.83465,0.40945,0.83465,0.41732,0.83465,0.4252,0.83465,0.43307,0.83465,0.44094,0.83465,0.44882,0.83465,0.45669,0.83465,0.46457,0.83465,0.47244,0.83465,0.48031,0.83465,0.48819,0.83465,0.49606,0.83465,0.50394,0.83465,0.51181,0.83465,0.51969,0.83465,0.52756,0.83465,0.53543,0.83465,0.54331,0.83465,0.55118,0.83465,0.55906,0.83465,0.56693,0.83465,0.5748,0.83465,0.58268,0.83465,0.59055,0.83465,0.59843,0.83465,0.6063,0.83465,0.61417,0.83465,0.62205,0.83465,0.62992,0.83465,0.6378,0.83465,0.64567,0.83465,0.65354,0.83465,0.66142,0.83465,0.66929,0.83465,0.67717,0.83465,0.68504,0.83465,0.69291,0.83465,0.70079,0.83465,0.70866,0.83465,0.71654,0.83465,0.72441,0.83465,0.73228,0.83465,0.74016,0.83465,0.74803,0.83465,0.75591,0.83465,0.76378,0.83465,0.77165,0.83465,0.77953,0.83465,0.7874,0.83465,0.79528,0.83465,0.80315,0.83465,0.81102,0.83465,0.8189,0.83465,0.82677,0.83465,0.83465,0.83465,0.84252,0.83465,0.85039,0.83465,0.85827,0.83465,0.86614,0.83465,0.87402,0.83465,0.88189,0.83465,0.88976,0.83465,0.89764,0.83465,0.90551,0.83465,0.91339,0.83465,0.92126,0.83465,0.92913,0.83465,0.93701,0.83465,0.94488,0.83465,0.95276,0.83465,0.96063,0.83465,0.9685,0.83465,0.97638,0.83465,0.98425,0.83465,0.99213,0.83465,0.99609,0.83465,0.00391,0.84252,0.00787,0.84252,0.01575,0.84252,0.02362,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_138()
		{
			double[] value = {0.0315,0.84252,0.03937,0.84252,0.04724,0.84252,0.05512,0.84252,0.06299,0.84252,0.07087,0.84252,0.07874,0.84252,0.08661,0.84252,0.09449,0.84252,0.10236,0.84252,0.11024,0.84252,0.11811,0.84252,0.12598,0.84252,0.13386,0.84252,0.14173,0.84252,0.14961,0.84252,0.15748,0.84252,0.16535,0.84252,0.17323,0.84252,0.1811,0.84252,0.18898,0.84252,0.19685,0.84252,0.20472,0.84252,0.2126,0.84252,0.22047,0.84252,0.22835,0.84252,0.23622,0.84252,0.24409,0.84252,0.25197,0.84252,0.25984,0.84252,0.26772,0.84252,0.27559,0.84252,0.28346,0.84252,0.29134,0.84252,0.29921,0.84252,0.30709,0.84252,0.31496,0.84252,0.32283,0.84252,0.33071,0.84252,0.33858,0.84252,0.34646,0.84252,0.35433,0.84252,0.3622,0.84252,0.37008,0.84252,0.37795,0.84252,0.38583,0.84252,0.3937,0.84252,0.40157,0.84252,0.40945,0.84252,0.41732,0.84252,0.4252,0.84252,0.43307,0.84252,0.44094,0.84252,0.44882,0.84252,0.45669,0.84252,0.46457,0.84252,0.47244,0.84252,0.48031,0.84252,0.48819,0.84252,0.49606,0.84252,0.50394,0.84252,0.51181,0.84252,0.51969,0.84252,0.52756,0.84252,0.53543,0.84252,0.54331,0.84252,0.55118,0.84252,0.55906,0.84252,0.56693,0.84252,0.5748,0.84252,0.58268,0.84252,0.59055,0.84252,0.59843,0.84252,0.6063,0.84252,0.61417,0.84252,0.62205,0.84252,0.62992,0.84252,0.6378,0.84252,0.64567,0.84252,0.65354,0.84252,0.66142,0.84252,0.66929,0.84252,0.67717,0.84252,0.68504,0.84252,0.69291,0.84252,0.70079,0.84252,0.70866,0.84252,0.71654,0.84252,0.72441,0.84252,0.73228,0.84252,0.74016,0.84252,0.74803,0.84252,0.75591,0.84252,0.76378,0.84252,0.77165,0.84252,0.77953,0.84252,0.7874,0.84252,0.79528,0.84252,0.80315,0.84252,0.81102,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_139()
		{
			double[] value = {0.8189,0.84252,0.82677,0.84252,0.83465,0.84252,0.84252,0.84252,0.85039,0.84252,0.85827,0.84252,0.86614,0.84252,0.87402,0.84252,0.88189,0.84252,0.88976,0.84252,0.89764,0.84252,0.90551,0.84252,0.91339,0.84252,0.92126,0.84252,0.92913,0.84252,0.93701,0.84252,0.94488,0.84252,0.95276,0.84252,0.96063,0.84252,0.9685,0.84252,0.97638,0.84252,0.98425,0.84252,0.99213,0.84252,0.99609,0.84252,0.00391,0.85039,0.00787,0.85039,0.01575,0.85039,0.02362,0.85039,0.0315,0.85039,0.03937,0.85039,0.04724,0.85039,0.05512,0.85039,0.06299,0.85039,0.07087,0.85039,0.07874,0.85039,0.08661,0.85039,0.09449,0.85039,0.10236,0.85039,0.11024,0.85039,0.11811,0.85039,0.12598,0.85039,0.13386,0.85039,0.14173,0.85039,0.14961,0.85039,0.15748,0.85039,0.16535,0.85039,0.17323,0.85039,0.1811,0.85039,0.18898,0.85039,0.19685,0.85039,0.20472,0.85039,0.2126,0.85039,0.22047,0.85039,0.22835,0.85039,0.23622,0.85039,0.24409,0.85039,0.25197,0.85039,0.25984,0.85039,0.26772,0.85039,0.27559,0.85039,0.28346,0.85039,0.29134,0.85039,0.29921,0.85039,0.30709,0.85039,0.31496,0.85039,0.32283,0.85039,0.33071,0.85039,0.33858,0.85039,0.34646,0.85039,0.35433,0.85039,0.3622,0.85039,0.37008,0.85039,0.37795,0.85039,0.38583,0.85039,0.3937,0.85039,0.40157,0.85039,0.40945,0.85039,0.41732,0.85039,0.4252,0.85039,0.43307,0.85039,0.44094,0.85039,0.44882,0.85039,0.45669,0.85039,0.46457,0.85039,0.47244,0.85039,0.48031,0.85039,0.48819,0.85039,0.49606,0.85039,0.50394,0.85039,0.51181,0.85039,0.51969,0.85039,0.52756,0.85039,0.53543,0.85039,0.54331,0.85039,0.55118,0.85039,0.55906,0.85039,0.56693,0.85039,0.5748,0.85039,0.58268,0.85039,0.59055,0.85039};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_140()
		{
			double[] value = {0.59843,0.85039,0.6063,0.85039,0.61417,0.85039,0.62205,0.85039,0.62992,0.85039,0.6378,0.85039,0.64567,0.85039,0.65354,0.85039,0.66142,0.85039,0.66929,0.85039,0.67717,0.85039,0.68504,0.85039,0.69291,0.85039,0.70079,0.85039,0.70866,0.85039,0.71654,0.85039,0.72441,0.85039,0.73228,0.85039,0.74016,0.85039,0.74803,0.85039,0.75591,0.85039,0.76378,0.85039,0.77165,0.85039,0.77953,0.85039,0.7874,0.85039,0.79528,0.85039,0.80315,0.85039,0.81102,0.85039,0.8189,0.85039,0.82677,0.85039,0.83465,0.85039,0.84252,0.85039,0.85039,0.85039,0.85827,0.85039,0.86614,0.85039,0.87402,0.85039,0.88189,0.85039,0.88976,0.85039,0.89764,0.85039,0.90551,0.85039,0.91339,0.85039,0.92126,0.85039,0.92913,0.85039,0.93701,0.85039,0.94488,0.85039,0.95276,0.85039,0.96063,0.85039,0.9685,0.85039,0.97638,0.85039,0.98425,0.85039,0.99213,0.85039,0.99609,0.85039,0.00391,0.85827,0.00787,0.85827,0.01575,0.85827,0.02362,0.85827,0.0315,0.85827,0.03937,0.85827,0.04724,0.85827,0.05512,0.85827,0.06299,0.85827,0.07087,0.85827,0.07874,0.85827,0.08661,0.85827,0.09449,0.85827,0.10236,0.85827,0.11024,0.85827,0.11811,0.85827,0.12598,0.85827,0.13386,0.85827,0.14173,0.85827,0.14961,0.85827,0.15748,0.85827,0.16535,0.85827,0.17323,0.85827,0.1811,0.85827,0.18898,0.85827,0.19685,0.85827,0.20472,0.85827,0.2126,0.85827,0.22047,0.85827,0.22835,0.85827,0.23622,0.85827,0.24409,0.85827,0.25197,0.85827,0.25984,0.85827,0.26772,0.85827,0.27559,0.85827,0.28346,0.85827,0.29134,0.85827,0.29921,0.85827,0.30709,0.85827,0.31496,0.85827,0.32283,0.85827,0.33071,0.85827,0.33858,0.85827,0.34646,0.85827,0.35433,0.85827,0.3622,0.85827,0.37008,0.85827};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_141()
		{
			double[] value = {0.37795,0.85827,0.38583,0.85827,0.3937,0.85827,0.40157,0.85827,0.40945,0.85827,0.41732,0.85827,0.4252,0.85827,0.43307,0.85827,0.44094,0.85827,0.44882,0.85827,0.45669,0.85827,0.46457,0.85827,0.47244,0.85827,0.48031,0.85827,0.48819,0.85827,0.49606,0.85827,0.50394,0.85827,0.51181,0.85827,0.51969,0.85827,0.52756,0.85827,0.53543,0.85827,0.54331,0.85827,0.55118,0.85827,0.55906,0.85827,0.56693,0.85827,0.5748,0.85827,0.58268,0.85827,0.59055,0.85827,0.59843,0.85827,0.6063,0.85827,0.61417,0.85827,0.62205,0.85827,0.62992,0.85827,0.6378,0.85827,0.64567,0.85827,0.65354,0.85827,0.66142,0.85827,0.66929,0.85827,0.67717,0.85827,0.68504,0.85827,0.69291,0.85827,0.70079,0.85827,0.70866,0.85827,0.71654,0.85827,0.72441,0.85827,0.73228,0.85827,0.74016,0.85827,0.74803,0.85827,0.75591,0.85827,0.76378,0.85827,0.77165,0.85827,0.77953,0.85827,0.7874,0.85827,0.79528,0.85827,0.80315,0.85827,0.81102,0.85827,0.8189,0.85827,0.82677,0.85827,0.83465,0.85827,0.84252,0.85827,0.85039,0.85827,0.85827,0.85827,0.86614,0.85827,0.87402,0.85827,0.88189,0.85827,0.88976,0.85827,0.89764,0.85827,0.90551,0.85827,0.91339,0.85827,0.92126,0.85827,0.92913,0.85827,0.93701,0.85827,0.94488,0.85827,0.95276,0.85827,0.96063,0.85827,0.9685,0.85827,0.97638,0.85827,0.98425,0.85827,0.99213,0.85827,0.99609,0.85827,0.00391,0.86614,0.00787,0.86614,0.01575,0.86614,0.02362,0.86614,0.0315,0.86614,0.03937,0.86614,0.04724,0.86614,0.05512,0.86614,0.06299,0.86614,0.07087,0.86614,0.07874,0.86614,0.08661,0.86614,0.09449,0.86614,0.10236,0.86614,0.11024,0.86614,0.11811,0.86614,0.12598,0.86614,0.13386,0.86614,0.14173,0.86614,0.14961,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_142()
		{
			double[] value = {0.15748,0.86614,0.16535,0.86614,0.17323,0.86614,0.1811,0.86614,0.18898,0.86614,0.19685,0.86614,0.20472,0.86614,0.2126,0.86614,0.22047,0.86614,0.22835,0.86614,0.23622,0.86614,0.24409,0.86614,0.25197,0.86614,0.25984,0.86614,0.26772,0.86614,0.27559,0.86614,0.28346,0.86614,0.29134,0.86614,0.29921,0.86614,0.30709,0.86614,0.31496,0.86614,0.32283,0.86614,0.33071,0.86614,0.33858,0.86614,0.34646,0.86614,0.35433,0.86614,0.3622,0.86614,0.37008,0.86614,0.37795,0.86614,0.38583,0.86614,0.3937,0.86614,0.40157,0.86614,0.40945,0.86614,0.41732,0.86614,0.4252,0.86614,0.43307,0.86614,0.44094,0.86614,0.44882,0.86614,0.45669,0.86614,0.46457,0.86614,0.47244,0.86614,0.48031,0.86614,0.48819,0.86614,0.49606,0.86614,0.50394,0.86614,0.51181,0.86614,0.51969,0.86614,0.52756,0.86614,0.53543,0.86614,0.54331,0.86614,0.55118,0.86614,0.55906,0.86614,0.56693,0.86614,0.5748,0.86614,0.58268,0.86614,0.59055,0.86614,0.59843,0.86614,0.6063,0.86614,0.61417,0.86614,0.62205,0.86614,0.62992,0.86614,0.6378,0.86614,0.64567,0.86614,0.65354,0.86614,0.66142,0.86614,0.66929,0.86614,0.67717,0.86614,0.68504,0.86614,0.69291,0.86614,0.70079,0.86614,0.70866,0.86614,0.71654,0.86614,0.72441,0.86614,0.73228,0.86614,0.74016,0.86614,0.74803,0.86614,0.75591,0.86614,0.76378,0.86614,0.77165,0.86614,0.77953,0.86614,0.7874,0.86614,0.79528,0.86614,0.80315,0.86614,0.81102,0.86614,0.8189,0.86614,0.82677,0.86614,0.83465,0.86614,0.84252,0.86614,0.85039,0.86614,0.85827,0.86614,0.86614,0.86614,0.87402,0.86614,0.88189,0.86614,0.88976,0.86614,0.89764,0.86614,0.90551,0.86614,0.91339,0.86614,0.92126,0.86614,0.92913,0.86614,0.93701,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_143()
		{
			double[] value = {0.94488,0.86614,0.95276,0.86614,0.96063,0.86614,0.9685,0.86614,0.97638,0.86614,0.98425,0.86614,0.99213,0.86614,0.99609,0.86614,0.00391,0.87402,0.00787,0.87402,0.01575,0.87402,0.02362,0.87402,0.0315,0.87402,0.03937,0.87402,0.04724,0.87402,0.05512,0.87402,0.06299,0.87402,0.07087,0.87402,0.07874,0.87402,0.08661,0.87402,0.09449,0.87402,0.10236,0.87402,0.11024,0.87402,0.11811,0.87402,0.12598,0.87402,0.13386,0.87402,0.14173,0.87402,0.14961,0.87402,0.15748,0.87402,0.16535,0.87402,0.17323,0.87402,0.1811,0.87402,0.18898,0.87402,0.19685,0.87402,0.20472,0.87402,0.2126,0.87402,0.22047,0.87402,0.22835,0.87402,0.23622,0.87402,0.24409,0.87402,0.25197,0.87402,0.25984,0.87402,0.26772,0.87402,0.27559,0.87402,0.28346,0.87402,0.29134,0.87402,0.29921,0.87402,0.30709,0.87402,0.31496,0.87402,0.32283,0.87402,0.33071,0.87402,0.33858,0.87402,0.34646,0.87402,0.35433,0.87402,0.3622,0.87402,0.37008,0.87402,0.37795,0.87402,0.38583,0.87402,0.3937,0.87402,0.40157,0.87402,0.40945,0.87402,0.41732,0.87402,0.4252,0.87402,0.43307,0.87402,0.44094,0.87402,0.44882,0.87402,0.45669,0.87402,0.46457,0.87402,0.47244,0.87402,0.48031,0.87402,0.48819,0.87402,0.49606,0.87402,0.50394,0.87402,0.51181,0.87402,0.51969,0.87402,0.52756,0.87402,0.53543,0.87402,0.54331,0.87402,0.55118,0.87402,0.55906,0.87402,0.56693,0.87402,0.5748,0.87402,0.58268,0.87402,0.59055,0.87402,0.59843,0.87402,0.6063,0.87402,0.61417,0.87402,0.62205,0.87402,0.62992,0.87402,0.6378,0.87402,0.64567,0.87402,0.65354,0.87402,0.66142,0.87402,0.66929,0.87402,0.67717,0.87402,0.68504,0.87402,0.69291,0.87402,0.70079,0.87402,0.70866,0.87402,0.71654,0.87402};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_144()
		{
			double[] value = {0.72441,0.87402,0.73228,0.87402,0.74016,0.87402,0.74803,0.87402,0.75591,0.87402,0.76378,0.87402,0.77165,0.87402,0.77953,0.87402,0.7874,0.87402,0.79528,0.87402,0.80315,0.87402,0.81102,0.87402,0.8189,0.87402,0.82677,0.87402,0.83465,0.87402,0.84252,0.87402,0.85039,0.87402,0.85827,0.87402,0.86614,0.87402,0.87402,0.87402,0.88189,0.87402,0.88976,0.87402,0.89764,0.87402,0.90551,0.87402,0.91339,0.87402,0.92126,0.87402,0.92913,0.87402,0.93701,0.87402,0.94488,0.87402,0.95276,0.87402,0.96063,0.87402,0.9685,0.87402,0.97638,0.87402,0.98425,0.87402,0.99213,0.87402,0.99609,0.87402,0.00391,0.88189,0.00787,0.88189,0.01575,0.88189,0.02362,0.88189,0.0315,0.88189,0.03937,0.88189,0.04724,0.88189,0.05512,0.88189,0.06299,0.88189,0.07087,0.88189,0.07874,0.88189,0.08661,0.88189,0.09449,0.88189,0.10236,0.88189,0.11024,0.88189,0.11811,0.88189,0.12598,0.88189,0.13386,0.88189,0.14173,0.88189,0.14961,0.88189,0.15748,0.88189,0.16535,0.88189,0.17323,0.88189,0.1811,0.88189,0.18898,0.88189,0.19685,0.88189,0.20472,0.88189,0.2126,0.88189,0.22047,0.88189,0.22835,0.88189,0.23622,0.88189,0.24409,0.88189,0.25197,0.88189,0.25984,0.88189,0.26772,0.88189,0.27559,0.88189,0.28346,0.88189,0.29134,0.88189,0.29921,0.88189,0.30709,0.88189,0.31496,0.88189,0.32283,0.88189,0.33071,0.88189,0.33858,0.88189,0.34646,0.88189,0.35433,0.88189,0.3622,0.88189,0.37008,0.88189,0.37795,0.88189,0.38583,0.88189,0.3937,0.88189,0.40157,0.88189,0.40945,0.88189,0.41732,0.88189,0.4252,0.88189,0.43307,0.88189,0.44094,0.88189,0.44882,0.88189,0.45669,0.88189,0.46457,0.88189,0.47244,0.88189,0.48031,0.88189,0.48819,0.88189,0.49606,0.88189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_145()
		{
			double[] value = {0.50394,0.88189,0.51181,0.88189,0.51969,0.88189,0.52756,0.88189,0.53543,0.88189,0.54331,0.88189,0.55118,0.88189,0.55906,0.88189,0.56693,0.88189,0.5748,0.88189,0.58268,0.88189,0.59055,0.88189,0.59843,0.88189,0.6063,0.88189,0.61417,0.88189,0.62205,0.88189,0.62992,0.88189,0.6378,0.88189,0.64567,0.88189,0.65354,0.88189,0.66142,0.88189,0.66929,0.88189,0.67717,0.88189,0.68504,0.88189,0.69291,0.88189,0.70079,0.88189,0.70866,0.88189,0.71654,0.88189,0.72441,0.88189,0.73228,0.88189,0.74016,0.88189,0.74803,0.88189,0.75591,0.88189,0.76378,0.88189,0.77165,0.88189,0.77953,0.88189,0.7874,0.88189,0.79528,0.88189,0.80315,0.88189,0.81102,0.88189,0.8189,0.88189,0.82677,0.88189,0.83465,0.88189,0.84252,0.88189,0.85039,0.88189,0.85827,0.88189,0.86614,0.88189,0.87402,0.88189,0.88189,0.88189,0.88976,0.88189,0.89764,0.88189,0.90551,0.88189,0.91339,0.88189,0.92126,0.88189,0.92913,0.88189,0.93701,0.88189,0.94488,0.88189,0.95276,0.88189,0.96063,0.88189,0.9685,0.88189,0.97638,0.88189,0.98425,0.88189,0.99213,0.88189,0.99609,0.88189,0.00391,0.88976,0.00787,0.88976,0.01575,0.88976,0.02362,0.88976,0.0315,0.88976,0.03937,0.88976,0.04724,0.88976,0.05512,0.88976,0.06299,0.88976,0.07087,0.88976,0.07874,0.88976,0.08661,0.88976,0.09449,0.88976,0.10236,0.88976,0.11024,0.88976,0.11811,0.88976,0.12598,0.88976,0.13386,0.88976,0.14173,0.88976,0.14961,0.88976,0.15748,0.88976,0.16535,0.88976,0.17323,0.88976,0.1811,0.88976,0.18898,0.88976,0.19685,0.88976,0.20472,0.88976,0.2126,0.88976,0.22047,0.88976,0.22835,0.88976,0.23622,0.88976,0.24409,0.88976,0.25197,0.88976,0.25984,0.88976,0.26772,0.88976,0.27559,0.88976};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_146()
		{
			double[] value = {0.28346,0.88976,0.29134,0.88976,0.29921,0.88976,0.30709,0.88976,0.31496,0.88976,0.32283,0.88976,0.33071,0.88976,0.33858,0.88976,0.34646,0.88976,0.35433,0.88976,0.3622,0.88976,0.37008,0.88976,0.37795,0.88976,0.38583,0.88976,0.3937,0.88976,0.40157,0.88976,0.40945,0.88976,0.41732,0.88976,0.4252,0.88976,0.43307,0.88976,0.44094,0.88976,0.44882,0.88976,0.45669,0.88976,0.46457,0.88976,0.47244,0.88976,0.48031,0.88976,0.48819,0.88976,0.49606,0.88976,0.50394,0.88976,0.51181,0.88976,0.51969,0.88976,0.52756,0.88976,0.53543,0.88976,0.54331,0.88976,0.55118,0.88976,0.55906,0.88976,0.56693,0.88976,0.5748,0.88976,0.58268,0.88976,0.59055,0.88976,0.59843,0.88976,0.6063,0.88976,0.61417,0.88976,0.62205,0.88976,0.62992,0.88976,0.6378,0.88976,0.64567,0.88976,0.65354,0.88976,0.66142,0.88976,0.66929,0.88976,0.67717,0.88976,0.68504,0.88976,0.69291,0.88976,0.70079,0.88976,0.70866,0.88976,0.71654,0.88976,0.72441,0.88976,0.73228,0.88976,0.74016,0.88976,0.74803,0.88976,0.75591,0.88976,0.76378,0.88976,0.77165,0.88976,0.77953,0.88976,0.7874,0.88976,0.79528,0.88976,0.80315,0.88976,0.81102,0.88976,0.8189,0.88976,0.82677,0.88976,0.83465,0.88976,0.84252,0.88976,0.85039,0.88976,0.85827,0.88976,0.86614,0.88976,0.87402,0.88976,0.88189,0.88976,0.88976,0.88976,0.89764,0.88976,0.90551,0.88976,0.91339,0.88976,0.92126,0.88976,0.92913,0.88976,0.93701,0.88976,0.94488,0.88976,0.95276,0.88976,0.96063,0.88976,0.9685,0.88976,0.97638,0.88976,0.98425,0.88976,0.99213,0.88976,0.99609,0.88976,0.00391,0.89764,0.00787,0.89764,0.01575,0.89764,0.02362,0.89764,0.0315,0.89764,0.03937,0.89764,0.04724,0.89764,0.05512,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_147()
		{
			double[] value = {0.06299,0.89764,0.07087,0.89764,0.07874,0.89764,0.08661,0.89764,0.09449,0.89764,0.10236,0.89764,0.11024,0.89764,0.11811,0.89764,0.12598,0.89764,0.13386,0.89764,0.14173,0.89764,0.14961,0.89764,0.15748,0.89764,0.16535,0.89764,0.17323,0.89764,0.1811,0.89764,0.18898,0.89764,0.19685,0.89764,0.20472,0.89764,0.2126,0.89764,0.22047,0.89764,0.22835,0.89764,0.23622,0.89764,0.24409,0.89764,0.25197,0.89764,0.25984,0.89764,0.26772,0.89764,0.27559,0.89764,0.28346,0.89764,0.29134,0.89764,0.29921,0.89764,0.30709,0.89764,0.31496,0.89764,0.32283,0.89764,0.33071,0.89764,0.33858,0.89764,0.34646,0.89764,0.35433,0.89764,0.3622,0.89764,0.37008,0.89764,0.37795,0.89764,0.38583,0.89764,0.3937,0.89764,0.40157,0.89764,0.40945,0.89764,0.41732,0.89764,0.4252,0.89764,0.43307,0.89764,0.44094,0.89764,0.44882,0.89764,0.45669,0.89764,0.46457,0.89764,0.47244,0.89764,0.48031,0.89764,0.48819,0.89764,0.49606,0.89764,0.50394,0.89764,0.51181,0.89764,0.51969,0.89764,0.52756,0.89764,0.53543,0.89764,0.54331,0.89764,0.55118,0.89764,0.55906,0.89764,0.56693,0.89764,0.5748,0.89764,0.58268,0.89764,0.59055,0.89764,0.59843,0.89764,0.6063,0.89764,0.61417,0.89764,0.62205,0.89764,0.62992,0.89764,0.6378,0.89764,0.64567,0.89764,0.65354,0.89764,0.66142,0.89764,0.66929,0.89764,0.67717,0.89764,0.68504,0.89764,0.69291,0.89764,0.70079,0.89764,0.70866,0.89764,0.71654,0.89764,0.72441,0.89764,0.73228,0.89764,0.74016,0.89764,0.74803,0.89764,0.75591,0.89764,0.76378,0.89764,0.77165,0.89764,0.77953,0.89764,0.7874,0.89764,0.79528,0.89764,0.80315,0.89764,0.81102,0.89764,0.8189,0.89764,0.82677,0.89764,0.83465,0.89764,0.84252,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_148()
		{
			double[] value = {0.85039,0.89764,0.85827,0.89764,0.86614,0.89764,0.87402,0.89764,0.88189,0.89764,0.88976,0.89764,0.89764,0.89764,0.90551,0.89764,0.91339,0.89764,0.92126,0.89764,0.92913,0.89764,0.93701,0.89764,0.94488,0.89764,0.95276,0.89764,0.96063,0.89764,0.9685,0.89764,0.97638,0.89764,0.98425,0.89764,0.99213,0.89764,0.99609,0.89764,0.00391,0.90551,0.00787,0.90551,0.01575,0.90551,0.02362,0.90551,0.0315,0.90551,0.03937,0.90551,0.04724,0.90551,0.05512,0.90551,0.06299,0.90551,0.07087,0.90551,0.07874,0.90551,0.08661,0.90551,0.09449,0.90551,0.10236,0.90551,0.11024,0.90551,0.11811,0.90551,0.12598,0.90551,0.13386,0.90551,0.14173,0.90551,0.14961,0.90551,0.15748,0.90551,0.16535,0.90551,0.17323,0.90551,0.1811,0.90551,0.18898,0.90551,0.19685,0.90551,0.20472,0.90551,0.2126,0.90551,0.22047,0.90551,0.22835,0.90551,0.23622,0.90551,0.24409,0.90551,0.25197,0.90551,0.25984,0.90551,0.26772,0.90551,0.27559,0.90551,0.28346,0.90551,0.29134,0.90551,0.29921,0.90551,0.30709,0.90551,0.31496,0.90551,0.32283,0.90551,0.33071,0.90551,0.33858,0.90551,0.34646,0.90551,0.35433,0.90551,0.3622,0.90551,0.37008,0.90551,0.37795,0.90551,0.38583,0.90551,0.3937,0.90551,0.40157,0.90551,0.40945,0.90551,0.41732,0.90551,0.4252,0.90551,0.43307,0.90551,0.44094,0.90551,0.44882,0.90551,0.45669,0.90551,0.46457,0.90551,0.47244,0.90551,0.48031,0.90551,0.48819,0.90551,0.49606,0.90551,0.50394,0.90551,0.51181,0.90551,0.51969,0.90551,0.52756,0.90551,0.53543,0.90551,0.54331,0.90551,0.55118,0.90551,0.55906,0.90551,0.56693,0.90551,0.5748,0.90551,0.58268,0.90551,0.59055,0.90551,0.59843,0.90551,0.6063,0.90551,0.61417,0.90551,0.62205,0.90551};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_149()
		{
			double[] value = {0.62992,0.90551,0.6378,0.90551,0.64567,0.90551,0.65354,0.90551,0.66142,0.90551,0.66929,0.90551,0.67717,0.90551,0.68504,0.90551,0.69291,0.90551,0.70079,0.90551,0.70866,0.90551,0.71654,0.90551,0.72441,0.90551,0.73228,0.90551,0.74016,0.90551,0.74803,0.90551,0.75591,0.90551,0.76378,0.90551,0.77165,0.90551,0.77953,0.90551,0.7874,0.90551,0.79528,0.90551,0.80315,0.90551,0.81102,0.90551,0.8189,0.90551,0.82677,0.90551,0.83465,0.90551,0.84252,0.90551,0.85039,0.90551,0.85827,0.90551,0.86614,0.90551,0.87402,0.90551,0.88189,0.90551,0.88976,0.90551,0.89764,0.90551,0.90551,0.90551,0.91339,0.90551,0.92126,0.90551,0.92913,0.90551,0.93701,0.90551,0.94488,0.90551,0.95276,0.90551,0.96063,0.90551,0.9685,0.90551,0.97638,0.90551,0.98425,0.90551,0.99213,0.90551,0.99609,0.90551,0.00391,0.91339,0.00787,0.91339,0.01575,0.91339,0.02362,0.91339,0.0315,0.91339,0.03937,0.91339,0.04724,0.91339,0.05512,0.91339,0.06299,0.91339,0.07087,0.91339,0.07874,0.91339,0.08661,0.91339,0.09449,0.91339,0.10236,0.91339,0.11024,0.91339,0.11811,0.91339,0.12598,0.91339,0.13386,0.91339,0.14173,0.91339,0.14961,0.91339,0.15748,0.91339,0.16535,0.91339,0.17323,0.91339,0.1811,0.91339,0.18898,0.91339,0.19685,0.91339,0.20472,0.91339,0.2126,0.91339,0.22047,0.91339,0.22835,0.91339,0.23622,0.91339,0.24409,0.91339,0.25197,0.91339,0.25984,0.91339,0.26772,0.91339,0.27559,0.91339,0.28346,0.91339,0.29134,0.91339,0.29921,0.91339,0.30709,0.91339,0.31496,0.91339,0.32283,0.91339,0.33071,0.91339,0.33858,0.91339,0.34646,0.91339,0.35433,0.91339,0.3622,0.91339,0.37008,0.91339,0.37795,0.91339,0.38583,0.91339,0.3937,0.91339,0.40157,0.91339};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_150()
		{
			double[] value = {0.40945,0.91339,0.41732,0.91339,0.4252,0.91339,0.43307,0.91339,0.44094,0.91339,0.44882,0.91339,0.45669,0.91339,0.46457,0.91339,0.47244,0.91339,0.48031,0.91339,0.48819,0.91339,0.49606,0.91339,0.50394,0.91339,0.51181,0.91339,0.51969,0.91339,0.52756,0.91339,0.53543,0.91339,0.54331,0.91339,0.55118,0.91339,0.55906,0.91339,0.56693,0.91339,0.5748,0.91339,0.58268,0.91339,0.59055,0.91339,0.59843,0.91339,0.6063,0.91339,0.61417,0.91339,0.62205,0.91339,0.62992,0.91339,0.6378,0.91339,0.64567,0.91339,0.65354,0.91339,0.66142,0.91339,0.66929,0.91339,0.67717,0.91339,0.68504,0.91339,0.69291,0.91339,0.70079,0.91339,0.70866,0.91339,0.71654,0.91339,0.72441,0.91339,0.73228,0.91339,0.74016,0.91339,0.74803,0.91339,0.75591,0.91339,0.76378,0.91339,0.77165,0.91339,0.77953,0.91339,0.7874,0.91339,0.79528,0.91339,0.80315,0.91339,0.81102,0.91339,0.8189,0.91339,0.82677,0.91339,0.83465,0.91339,0.84252,0.91339,0.85039,0.91339,0.85827,0.91339,0.86614,0.91339,0.87402,0.91339,0.88189,0.91339,0.88976,0.91339,0.89764,0.91339,0.90551,0.91339,0.91339,0.91339,0.92126,0.91339,0.92913,0.91339,0.93701,0.91339,0.94488,0.91339,0.95276,0.91339,0.96063,0.91339,0.9685,0.91339,0.97638,0.91339,0.98425,0.91339,0.99213,0.91339,0.99609,0.91339,0.00391,0.92126,0.00787,0.92126,0.01575,0.92126,0.02362,0.92126,0.0315,0.92126,0.03937,0.92126,0.04724,0.92126,0.05512,0.92126,0.06299,0.92126,0.07087,0.92126,0.07874,0.92126,0.08661,0.92126,0.09449,0.92126,0.10236,0.92126,0.11024,0.92126,0.11811,0.92126,0.12598,0.92126,0.13386,0.92126,0.14173,0.92126,0.14961,0.92126,0.15748,0.92126,0.16535,0.92126,0.17323,0.92126,0.1811,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_151()
		{
			double[] value = {0.18898,0.92126,0.19685,0.92126,0.20472,0.92126,0.2126,0.92126,0.22047,0.92126,0.22835,0.92126,0.23622,0.92126,0.24409,0.92126,0.25197,0.92126,0.25984,0.92126,0.26772,0.92126,0.27559,0.92126,0.28346,0.92126,0.29134,0.92126,0.29921,0.92126,0.30709,0.92126,0.31496,0.92126,0.32283,0.92126,0.33071,0.92126,0.33858,0.92126,0.34646,0.92126,0.35433,0.92126,0.3622,0.92126,0.37008,0.92126,0.37795,0.92126,0.38583,0.92126,0.3937,0.92126,0.40157,0.92126,0.40945,0.92126,0.41732,0.92126,0.4252,0.92126,0.43307,0.92126,0.44094,0.92126,0.44882,0.92126,0.45669,0.92126,0.46457,0.92126,0.47244,0.92126,0.48031,0.92126,0.48819,0.92126,0.49606,0.92126,0.50394,0.92126,0.51181,0.92126,0.51969,0.92126,0.52756,0.92126,0.53543,0.92126,0.54331,0.92126,0.55118,0.92126,0.55906,0.92126,0.56693,0.92126,0.5748,0.92126,0.58268,0.92126,0.59055,0.92126,0.59843,0.92126,0.6063,0.92126,0.61417,0.92126,0.62205,0.92126,0.62992,0.92126,0.6378,0.92126,0.64567,0.92126,0.65354,0.92126,0.66142,0.92126,0.66929,0.92126,0.67717,0.92126,0.68504,0.92126,0.69291,0.92126,0.70079,0.92126,0.70866,0.92126,0.71654,0.92126,0.72441,0.92126,0.73228,0.92126,0.74016,0.92126,0.74803,0.92126,0.75591,0.92126,0.76378,0.92126,0.77165,0.92126,0.77953,0.92126,0.7874,0.92126,0.79528,0.92126,0.80315,0.92126,0.81102,0.92126,0.8189,0.92126,0.82677,0.92126,0.83465,0.92126,0.84252,0.92126,0.85039,0.92126,0.85827,0.92126,0.86614,0.92126,0.87402,0.92126,0.88189,0.92126,0.88976,0.92126,0.89764,0.92126,0.90551,0.92126,0.91339,0.92126,0.92126,0.92126,0.92913,0.92126,0.93701,0.92126,0.94488,0.92126,0.95276,0.92126,0.96063,0.92126,0.9685,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_152()
		{
			double[] value = {0.97638,0.92126,0.98425,0.92126,0.99213,0.92126,0.99609,0.92126,0.00391,0.92913,0.00787,0.92913,0.01575,0.92913,0.02362,0.92913,0.0315,0.92913,0.03937,0.92913,0.04724,0.92913,0.05512,0.92913,0.06299,0.92913,0.07087,0.92913,0.07874,0.92913,0.08661,0.92913,0.09449,0.92913,0.10236,0.92913,0.11024,0.92913,0.11811,0.92913,0.12598,0.92913,0.13386,0.92913,0.14173,0.92913,0.14961,0.92913,0.15748,0.92913,0.16535,0.92913,0.17323,0.92913,0.1811,0.92913,0.18898,0.92913,0.19685,0.92913,0.20472,0.92913,0.2126,0.92913,0.22047,0.92913,0.22835,0.92913,0.23622,0.92913,0.24409,0.92913,0.25197,0.92913,0.25984,0.92913,0.26772,0.92913,0.27559,0.92913,0.28346,0.92913,0.29134,0.92913,0.29921,0.92913,0.30709,0.92913,0.31496,0.92913,0.32283,0.92913,0.33071,0.92913,0.33858,0.92913,0.34646,0.92913,0.35433,0.92913,0.3622,0.92913,0.37008,0.92913,0.37795,0.92913,0.38583,0.92913,0.3937,0.92913,0.40157,0.92913,0.40945,0.92913,0.41732,0.92913,0.4252,0.92913,0.43307,0.92913,0.44094,0.92913,0.44882,0.92913,0.45669,0.92913,0.46457,0.92913,0.47244,0.92913,0.48031,0.92913,0.48819,0.92913,0.49606,0.92913,0.50394,0.92913,0.51181,0.92913,0.51969,0.92913,0.52756,0.92913,0.53543,0.92913,0.54331,0.92913,0.55118,0.92913,0.55906,0.92913,0.56693,0.92913,0.5748,0.92913,0.58268,0.92913,0.59055,0.92913,0.59843,0.92913,0.6063,0.92913,0.61417,0.92913,0.62205,0.92913,0.62992,0.92913,0.6378,0.92913,0.64567,0.92913,0.65354,0.92913,0.66142,0.92913,0.66929,0.92913,0.67717,0.92913,0.68504,0.92913,0.69291,0.92913,0.70079,0.92913,0.70866,0.92913,0.71654,0.92913,0.72441,0.92913,0.73228,0.92913,0.74016,0.92913,0.74803,0.92913};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_153()
		{
			double[] value = {0.75591,0.92913,0.76378,0.92913,0.77165,0.92913,0.77953,0.92913,0.7874,0.92913,0.79528,0.92913,0.80315,0.92913,0.81102,0.92913,0.8189,0.92913,0.82677,0.92913,0.83465,0.92913,0.84252,0.92913,0.85039,0.92913,0.85827,0.92913,0.86614,0.92913,0.87402,0.92913,0.88189,0.92913,0.88976,0.92913,0.89764,0.92913,0.90551,0.92913,0.91339,0.92913,0.92126,0.92913,0.92913,0.92913,0.93701,0.92913,0.94488,0.92913,0.95276,0.92913,0.96063,0.92913,0.9685,0.92913,0.97638,0.92913,0.98425,0.92913,0.99213,0.92913,0.99609,0.92913,0.00391,0.93701,0.00787,0.93701,0.01575,0.93701,0.02362,0.93701,0.0315,0.93701,0.03937,0.93701,0.04724,0.93701,0.05512,0.93701,0.06299,0.93701,0.07087,0.93701,0.07874,0.93701,0.08661,0.93701,0.09449,0.93701,0.10236,0.93701,0.11024,0.93701,0.11811,0.93701,0.12598,0.93701,0.13386,0.93701,0.14173,0.93701,0.14961,0.93701,0.15748,0.93701,0.16535,0.93701,0.17323,0.93701,0.1811,0.93701,0.18898,0.93701,0.19685,0.93701,0.20472,0.93701,0.2126,0.93701,0.22047,0.93701,0.22835,0.93701,0.23622,0.93701,0.24409,0.93701,0.25197,0.93701,0.25984,0.93701,0.26772,0.93701,0.27559,0.93701,0.28346,0.93701,0.29134,0.93701,0.29921,0.93701,0.30709,0.93701,0.31496,0.93701,0.32283,0.93701,0.33071,0.93701,0.33858,0.93701,0.34646,0.93701,0.35433,0.93701,0.3622,0.93701,0.37008,0.93701,0.37795,0.93701,0.38583,0.93701,0.3937,0.93701,0.40157,0.93701,0.40945,0.93701,0.41732,0.93701,0.4252,0.93701,0.43307,0.93701,0.44094,0.93701,0.44882,0.93701,0.45669,0.93701,0.46457,0.93701,0.47244,0.93701,0.48031,0.93701,0.48819,0.93701,0.49606,0.93701,0.50394,0.93701,0.51181,0.93701,0.51969,0.93701,0.52756,0.93701};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_154()
		{
			double[] value = {0.53543,0.93701,0.54331,0.93701,0.55118,0.93701,0.55906,0.93701,0.56693,0.93701,0.5748,0.93701,0.58268,0.93701,0.59055,0.93701,0.59843,0.93701,0.6063,0.93701,0.61417,0.93701,0.62205,0.93701,0.62992,0.93701,0.6378,0.93701,0.64567,0.93701,0.65354,0.93701,0.66142,0.93701,0.66929,0.93701,0.67717,0.93701,0.68504,0.93701,0.69291,0.93701,0.70079,0.93701,0.70866,0.93701,0.71654,0.93701,0.72441,0.93701,0.73228,0.93701,0.74016,0.93701,0.74803,0.93701,0.75591,0.93701,0.76378,0.93701,0.77165,0.93701,0.77953,0.93701,0.7874,0.93701,0.79528,0.93701,0.80315,0.93701,0.81102,0.93701,0.8189,0.93701,0.82677,0.93701,0.83465,0.93701,0.84252,0.93701,0.85039,0.93701,0.85827,0.93701,0.86614,0.93701,0.87402,0.93701,0.88189,0.93701,0.88976,0.93701,0.89764,0.93701,0.90551,0.93701,0.91339,0.93701,0.92126,0.93701,0.92913,0.93701,0.93701,0.93701,0.94488,0.93701,0.95276,0.93701,0.96063,0.93701,0.9685,0.93701,0.97638,0.93701,0.98425,0.93701,0.99213,0.93701,0.99609,0.93701,0.00391,0.94488,0.00787,0.94488,0.01575,0.94488,0.02362,0.94488,0.0315,0.94488,0.03937,0.94488,0.04724,0.94488,0.05512,0.94488,0.06299,0.94488,0.07087,0.94488,0.07874,0.94488,0.08661,0.94488,0.09449,0.94488,0.10236,0.94488,0.11024,0.94488,0.11811,0.94488,0.12598,0.94488,0.13386,0.94488,0.14173,0.94488,0.14961,0.94488,0.15748,0.94488,0.16535,0.94488,0.17323,0.94488,0.1811,0.94488,0.18898,0.94488,0.19685,0.94488,0.20472,0.94488,0.2126,0.94488,0.22047,0.94488,0.22835,0.94488,0.23622,0.94488,0.24409,0.94488,0.25197,0.94488,0.25984,0.94488,0.26772,0.94488,0.27559,0.94488,0.28346,0.94488,0.29134,0.94488,0.29921,0.94488,0.30709,0.94488};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_155()
		{
			double[] value = {0.31496,0.94488,0.32283,0.94488,0.33071,0.94488,0.33858,0.94488,0.34646,0.94488,0.35433,0.94488,0.3622,0.94488,0.37008,0.94488,0.37795,0.94488,0.38583,0.94488,0.3937,0.94488,0.40157,0.94488,0.40945,0.94488,0.41732,0.94488,0.4252,0.94488,0.43307,0.94488,0.44094,0.94488,0.44882,0.94488,0.45669,0.94488,0.46457,0.94488,0.47244,0.94488,0.48031,0.94488,0.48819,0.94488,0.49606,0.94488,0.50394,0.94488,0.51181,0.94488,0.51969,0.94488,0.52756,0.94488,0.53543,0.94488,0.54331,0.94488,0.55118,0.94488,0.55906,0.94488,0.56693,0.94488,0.5748,0.94488,0.58268,0.94488,0.59055,0.94488,0.59843,0.94488,0.6063,0.94488,0.61417,0.94488,0.62205,0.94488,0.62992,0.94488,0.6378,0.94488,0.64567,0.94488,0.65354,0.94488,0.66142,0.94488,0.66929,0.94488,0.67717,0.94488,0.68504,0.94488,0.69291,0.94488,0.70079,0.94488,0.70866,0.94488,0.71654,0.94488,0.72441,0.94488,0.73228,0.94488,0.74016,0.94488,0.74803,0.94488,0.75591,0.94488,0.76378,0.94488,0.77165,0.94488,0.77953,0.94488,0.7874,0.94488,0.79528,0.94488,0.80315,0.94488,0.81102,0.94488,0.8189,0.94488,0.82677,0.94488,0.83465,0.94488,0.84252,0.94488,0.85039,0.94488,0.85827,0.94488,0.86614,0.94488,0.87402,0.94488,0.88189,0.94488,0.88976,0.94488,0.89764,0.94488,0.90551,0.94488,0.91339,0.94488,0.92126,0.94488,0.92913,0.94488,0.93701,0.94488,0.94488,0.94488,0.95276,0.94488,0.96063,0.94488,0.9685,0.94488,0.97638,0.94488,0.98425,0.94488,0.99213,0.94488,0.99609,0.94488,0.00391,0.95276,0.00787,0.95276,0.01575,0.95276,0.02362,0.95276,0.0315,0.95276,0.03937,0.95276,0.04724,0.95276,0.05512,0.95276,0.06299,0.95276,0.07087,0.95276,0.07874,0.95276,0.08661,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_156()
		{
			double[] value = {0.09449,0.95276,0.10236,0.95276,0.11024,0.95276,0.11811,0.95276,0.12598,0.95276,0.13386,0.95276,0.14173,0.95276,0.14961,0.95276,0.15748,0.95276,0.16535,0.95276,0.17323,0.95276,0.1811,0.95276,0.18898,0.95276,0.19685,0.95276,0.20472,0.95276,0.2126,0.95276,0.22047,0.95276,0.22835,0.95276,0.23622,0.95276,0.24409,0.95276,0.25197,0.95276,0.25984,0.95276,0.26772,0.95276,0.27559,0.95276,0.28346,0.95276,0.29134,0.95276,0.29921,0.95276,0.30709,0.95276,0.31496,0.95276,0.32283,0.95276,0.33071,0.95276,0.33858,0.95276,0.34646,0.95276,0.35433,0.95276,0.3622,0.95276,0.37008,0.95276,0.37795,0.95276,0.38583,0.95276,0.3937,0.95276,0.40157,0.95276,0.40945,0.95276,0.41732,0.95276,0.4252,0.95276,0.43307,0.95276,0.44094,0.95276,0.44882,0.95276,0.45669,0.95276,0.46457,0.95276,0.47244,0.95276,0.48031,0.95276,0.48819,0.95276,0.49606,0.95276,0.50394,0.95276,0.51181,0.95276,0.51969,0.95276,0.52756,0.95276,0.53543,0.95276,0.54331,0.95276,0.55118,0.95276,0.55906,0.95276,0.56693,0.95276,0.5748,0.95276,0.58268,0.95276,0.59055,0.95276,0.59843,0.95276,0.6063,0.95276,0.61417,0.95276,0.62205,0.95276,0.62992,0.95276,0.6378,0.95276,0.64567,0.95276,0.65354,0.95276,0.66142,0.95276,0.66929,0.95276,0.67717,0.95276,0.68504,0.95276,0.69291,0.95276,0.70079,0.95276,0.70866,0.95276,0.71654,0.95276,0.72441,0.95276,0.73228,0.95276,0.74016,0.95276,0.74803,0.95276,0.75591,0.95276,0.76378,0.95276,0.77165,0.95276,0.77953,0.95276,0.7874,0.95276,0.79528,0.95276,0.80315,0.95276,0.81102,0.95276,0.8189,0.95276,0.82677,0.95276,0.83465,0.95276,0.84252,0.95276,0.85039,0.95276,0.85827,0.95276,0.86614,0.95276,0.87402,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_157()
		{
			double[] value = {0.88189,0.95276,0.88976,0.95276,0.89764,0.95276,0.90551,0.95276,0.91339,0.95276,0.92126,0.95276,0.92913,0.95276,0.93701,0.95276,0.94488,0.95276,0.95276,0.95276,0.96063,0.95276,0.9685,0.95276,0.97638,0.95276,0.98425,0.95276,0.99213,0.95276,0.99609,0.95276,0.00391,0.96063,0.00787,0.96063,0.01575,0.96063,0.02362,0.96063,0.0315,0.96063,0.03937,0.96063,0.04724,0.96063,0.05512,0.96063,0.06299,0.96063,0.07087,0.96063,0.07874,0.96063,0.08661,0.96063,0.09449,0.96063,0.10236,0.96063,0.11024,0.96063,0.11811,0.96063,0.12598,0.96063,0.13386,0.96063,0.14173,0.96063,0.14961,0.96063,0.15748,0.96063,0.16535,0.96063,0.17323,0.96063,0.1811,0.96063,0.18898,0.96063,0.19685,0.96063,0.20472,0.96063,0.2126,0.96063,0.22047,0.96063,0.22835,0.96063,0.23622,0.96063,0.24409,0.96063,0.25197,0.96063,0.25984,0.96063,0.26772,0.96063,0.27559,0.96063,0.28346,0.96063,0.29134,0.96063,0.29921,0.96063,0.30709,0.96063,0.31496,0.96063,0.32283,0.96063,0.33071,0.96063,0.33858,0.96063,0.34646,0.96063,0.35433,0.96063,0.3622,0.96063,0.37008,0.96063,0.37795,0.96063,0.38583,0.96063,0.3937,0.96063,0.40157,0.96063,0.40945,0.96063,0.41732,0.96063,0.4252,0.96063,0.43307,0.96063,0.44094,0.96063,0.44882,0.96063,0.45669,0.96063,0.46457,0.96063,0.47244,0.96063,0.48031,0.96063,0.48819,0.96063,0.49606,0.96063,0.50394,0.96063,0.51181,0.96063,0.51969,0.96063,0.52756,0.96063,0.53543,0.96063,0.54331,0.96063,0.55118,0.96063,0.55906,0.96063,0.56693,0.96063,0.5748,0.96063,0.58268,0.96063,0.59055,0.96063,0.59843,0.96063,0.6063,0.96063,0.61417,0.96063,0.62205,0.96063,0.62992,0.96063,0.6378,0.96063,0.64567,0.96063,0.65354,0.96063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_158()
		{
			double[] value = {0.66142,0.96063,0.66929,0.96063,0.67717,0.96063,0.68504,0.96063,0.69291,0.96063,0.70079,0.96063,0.70866,0.96063,0.71654,0.96063,0.72441,0.96063,0.73228,0.96063,0.74016,0.96063,0.74803,0.96063,0.75591,0.96063,0.76378,0.96063,0.77165,0.96063,0.77953,0.96063,0.7874,0.96063,0.79528,0.96063,0.80315,0.96063,0.81102,0.96063,0.8189,0.96063,0.82677,0.96063,0.83465,0.96063,0.84252,0.96063,0.85039,0.96063,0.85827,0.96063,0.86614,0.96063,0.87402,0.96063,0.88189,0.96063,0.88976,0.96063,0.89764,0.96063,0.90551,0.96063,0.91339,0.96063,0.92126,0.96063,0.92913,0.96063,0.93701,0.96063,0.94488,0.96063,0.95276,0.96063,0.96063,0.96063,0.9685,0.96063,0.97638,0.96063,0.98425,0.96063,0.99213,0.96063,0.99609,0.96063,0.00391,0.9685,0.00787,0.9685,0.01575,0.9685,0.02362,0.9685,0.0315,0.9685,0.03937,0.9685,0.04724,0.9685,0.05512,0.9685,0.06299,0.9685,0.07087,0.9685,0.07874,0.9685,0.08661,0.9685,0.09449,0.9685,0.10236,0.9685,0.11024,0.9685,0.11811,0.9685,0.12598,0.9685,0.13386,0.9685,0.14173,0.9685,0.14961,0.9685,0.15748,0.9685,0.16535,0.9685,0.17323,0.9685,0.1811,0.9685,0.18898,0.9685,0.19685,0.9685,0.20472,0.9685,0.2126,0.9685,0.22047,0.9685,0.22835,0.9685,0.23622,0.9685,0.24409,0.9685,0.25197,0.9685,0.25984,0.9685,0.26772,0.9685,0.27559,0.9685,0.28346,0.9685,0.29134,0.9685,0.29921,0.9685,0.30709,0.9685,0.31496,0.9685,0.32283,0.9685,0.33071,0.9685,0.33858,0.9685,0.34646,0.9685,0.35433,0.9685,0.3622,0.9685,0.37008,0.9685,0.37795,0.9685,0.38583,0.9685,0.3937,0.9685,0.40157,0.9685,0.40945,0.9685,0.41732,0.9685,0.4252,0.9685,0.43307,0.9685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_159()
		{
			double[] value = {0.44094,0.9685,0.44882,0.9685,0.45669,0.9685,0.46457,0.9685,0.47244,0.9685,0.48031,0.9685,0.48819,0.9685,0.49606,0.9685,0.50394,0.9685,0.51181,0.9685,0.51969,0.9685,0.52756,0.9685,0.53543,0.9685,0.54331,0.9685,0.55118,0.9685,0.55906,0.9685,0.56693,0.9685,0.5748,0.9685,0.58268,0.9685,0.59055,0.9685,0.59843,0.9685,0.6063,0.9685,0.61417,0.9685,0.62205,0.9685,0.62992,0.9685,0.6378,0.9685,0.64567,0.9685,0.65354,0.9685,0.66142,0.9685,0.66929,0.9685,0.67717,0.9685,0.68504,0.9685,0.69291,0.9685,0.70079,0.9685,0.70866,0.9685,0.71654,0.9685,0.72441,0.9685,0.73228,0.9685,0.74016,0.9685,0.74803,0.9685,0.75591,0.9685,0.76378,0.9685,0.77165,0.9685,0.77953,0.9685,0.7874,0.9685,0.79528,0.9685,0.80315,0.9685,0.81102,0.9685,0.8189,0.9685,0.82677,0.9685,0.83465,0.9685,0.84252,0.9685,0.85039,0.9685,0.85827,0.9685,0.86614,0.9685,0.87402,0.9685,0.88189,0.9685,0.88976,0.9685,0.89764,0.9685,0.90551,0.9685,0.91339,0.9685,0.92126,0.9685,0.92913,0.9685,0.93701,0.9685,0.94488,0.9685,0.95276,0.9685,0.96063,0.9685,0.9685,0.9685,0.97638,0.9685,0.98425,0.9685,0.99213,0.9685,0.99609,0.9685,0.00391,0.97638,0.00787,0.97638,0.01575,0.97638,0.02362,0.97638,0.0315,0.97638,0.03937,0.97638,0.04724,0.97638,0.05512,0.97638,0.06299,0.97638,0.07087,0.97638,0.07874,0.97638,0.08661,0.97638,0.09449,0.97638,0.10236,0.97638,0.11024,0.97638,0.11811,0.97638,0.12598,0.97638,0.13386,0.97638,0.14173,0.97638,0.14961,0.97638,0.15748,0.97638,0.16535,0.97638,0.17323,0.97638,0.1811,0.97638,0.18898,0.97638,0.19685,0.97638,0.20472,0.97638,0.2126,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_160()
		{
			double[] value = {0.22047,0.97638,0.22835,0.97638,0.23622,0.97638,0.24409,0.97638,0.25197,0.97638,0.25984,0.97638,0.26772,0.97638,0.27559,0.97638,0.28346,0.97638,0.29134,0.97638,0.29921,0.97638,0.30709,0.97638,0.31496,0.97638,0.32283,0.97638,0.33071,0.97638,0.33858,0.97638,0.34646,0.97638,0.35433,0.97638,0.3622,0.97638,0.37008,0.97638,0.37795,0.97638,0.38583,0.97638,0.3937,0.97638,0.40157,0.97638,0.40945,0.97638,0.41732,0.97638,0.4252,0.97638,0.43307,0.97638,0.44094,0.97638,0.44882,0.97638,0.45669,0.97638,0.46457,0.97638,0.47244,0.97638,0.48031,0.97638,0.48819,0.97638,0.49606,0.97638,0.50394,0.97638,0.51181,0.97638,0.51969,0.97638,0.52756,0.97638,0.53543,0.97638,0.54331,0.97638,0.55118,0.97638,0.55906,0.97638,0.56693,0.97638,0.5748,0.97638,0.58268,0.97638,0.59055,0.97638,0.59843,0.97638,0.6063,0.97638,0.61417,0.97638,0.62205,0.97638,0.62992,0.97638,0.6378,0.97638,0.64567,0.97638,0.65354,0.97638,0.66142,0.97638,0.66929,0.97638,0.67717,0.97638,0.68504,0.97638,0.69291,0.97638,0.70079,0.97638,0.70866,0.97638,0.71654,0.97638,0.72441,0.97638,0.73228,0.97638,0.74016,0.97638,0.74803,0.97638,0.75591,0.97638,0.76378,0.97638,0.77165,0.97638,0.77953,0.97638,0.7874,0.97638,0.79528,0.97638,0.80315,0.97638,0.81102,0.97638,0.8189,0.97638,0.82677,0.97638,0.83465,0.97638,0.84252,0.97638,0.85039,0.97638,0.85827,0.97638,0.86614,0.97638,0.87402,0.97638,0.88189,0.97638,0.88976,0.97638,0.89764,0.97638,0.90551,0.97638,0.91339,0.97638,0.92126,0.97638,0.92913,0.97638,0.93701,0.97638,0.94488,0.97638,0.95276,0.97638,0.96063,0.97638,0.9685,0.97638,0.97638,0.97638,0.98425,0.97638,0.99213,0.97638,0.99609,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_161()
		{
			double[] value = {0.00391,0.98425,0.00787,0.98425,0.01575,0.98425,0.02362,0.98425,0.0315,0.98425,0.03937,0.98425,0.04724,0.98425,0.05512,0.98425,0.06299,0.98425,0.07087,0.98425,0.07874,0.98425,0.08661,0.98425,0.09449,0.98425,0.10236,0.98425,0.11024,0.98425,0.11811,0.98425,0.12598,0.98425,0.13386,0.98425,0.14173,0.98425,0.14961,0.98425,0.15748,0.98425,0.16535,0.98425,0.17323,0.98425,0.1811,0.98425,0.18898,0.98425,0.19685,0.98425,0.20472,0.98425,0.2126,0.98425,0.22047,0.98425,0.22835,0.98425,0.23622,0.98425,0.24409,0.98425,0.25197,0.98425,0.25984,0.98425,0.26772,0.98425,0.27559,0.98425,0.28346,0.98425,0.29134,0.98425,0.29921,0.98425,0.30709,0.98425,0.31496,0.98425,0.32283,0.98425,0.33071,0.98425,0.33858,0.98425,0.34646,0.98425,0.35433,0.98425,0.3622,0.98425,0.37008,0.98425,0.37795,0.98425,0.38583,0.98425,0.3937,0.98425,0.40157,0.98425,0.40945,0.98425,0.41732,0.98425,0.4252,0.98425,0.43307,0.98425,0.44094,0.98425,0.44882,0.98425,0.45669,0.98425,0.46457,0.98425,0.47244,0.98425,0.48031,0.98425,0.48819,0.98425,0.49606,0.98425,0.50394,0.98425,0.51181,0.98425,0.51969,0.98425,0.52756,0.98425,0.53543,0.98425,0.54331,0.98425,0.55118,0.98425,0.55906,0.98425,0.56693,0.98425,0.5748,0.98425,0.58268,0.98425,0.59055,0.98425,0.59843,0.98425,0.6063,0.98425,0.61417,0.98425,0.62205,0.98425,0.62992,0.98425,0.6378,0.98425,0.64567,0.98425,0.65354,0.98425,0.66142,0.98425,0.66929,0.98425,0.67717,0.98425,0.68504,0.98425,0.69291,0.98425,0.70079,0.98425,0.70866,0.98425,0.71654,0.98425,0.72441,0.98425,0.73228,0.98425,0.74016,0.98425,0.74803,0.98425,0.75591,0.98425,0.76378,0.98425,0.77165,0.98425,0.77953,0.98425};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_162()
		{
			double[] value = {0.7874,0.98425,0.79528,0.98425,0.80315,0.98425,0.81102,0.98425,0.8189,0.98425,0.82677,0.98425,0.83465,0.98425,0.84252,0.98425,0.85039,0.98425,0.85827,0.98425,0.86614,0.98425,0.87402,0.98425,0.88189,0.98425,0.88976,0.98425,0.89764,0.98425,0.90551,0.98425,0.91339,0.98425,0.92126,0.98425,0.92913,0.98425,0.93701,0.98425,0.94488,0.98425,0.95276,0.98425,0.96063,0.98425,0.9685,0.98425,0.97638,0.98425,0.98425,0.98425,0.99213,0.98425,0.99609,0.98425,0.00391,0.99213,0.00787,0.99213,0.01575,0.99213,0.02362,0.99213,0.0315,0.99213,0.03937,0.99213,0.04724,0.99213,0.05512,0.99213,0.06299,0.99213,0.07087,0.99213,0.07874,0.99213,0.08661,0.99213,0.09449,0.99213,0.10236,0.99213,0.11024,0.99213,0.11811,0.99213,0.12598,0.99213,0.13386,0.99213,0.14173,0.99213,0.14961,0.99213,0.15748,0.99213,0.16535,0.99213,0.17323,0.99213,0.1811,0.99213,0.18898,0.99213,0.19685,0.99213,0.20472,0.99213,0.2126,0.99213,0.22047,0.99213,0.22835,0.99213,0.23622,0.99213,0.24409,0.99213,0.25197,0.99213,0.25984,0.99213,0.26772,0.99213,0.27559,0.99213,0.28346,0.99213,0.29134,0.99213,0.29921,0.99213,0.30709,0.99213,0.31496,0.99213,0.32283,0.99213,0.33071,0.99213,0.33858,0.99213,0.34646,0.99213,0.35433,0.99213,0.3622,0.99213,0.37008,0.99213,0.37795,0.99213,0.38583,0.99213,0.3937,0.99213,0.40157,0.99213,0.40945,0.99213,0.41732,0.99213,0.4252,0.99213,0.43307,0.99213,0.44094,0.99213,0.44882,0.99213,0.45669,0.99213,0.46457,0.99213,0.47244,0.99213,0.48031,0.99213,0.48819,0.99213,0.49606,0.99213,0.50394,0.99213,0.51181,0.99213,0.51969,0.99213,0.52756,0.99213,0.53543,0.99213,0.54331,0.99213,0.55118,0.99213,0.55906,0.99213};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_163()
		{
			double[] value = {0.56693,0.99213,0.5748,0.99213,0.58268,0.99213,0.59055,0.99213,0.59843,0.99213,0.6063,0.99213,0.61417,0.99213,0.62205,0.99213,0.62992,0.99213,0.6378,0.99213,0.64567,0.99213,0.65354,0.99213,0.66142,0.99213,0.66929,0.99213,0.67717,0.99213,0.68504,0.99213,0.69291,0.99213,0.70079,0.99213,0.70866,0.99213,0.71654,0.99213,0.72441,0.99213,0.73228,0.99213,0.74016,0.99213,0.74803,0.99213,0.75591,0.99213,0.76378,0.99213,0.77165,0.99213,0.77953,0.99213,0.7874,0.99213,0.79528,0.99213,0.80315,0.99213,0.81102,0.99213,0.8189,0.99213,0.82677,0.99213,0.83465,0.99213,0.84252,0.99213,0.85039,0.99213,0.85827,0.99213,0.86614,0.99213,0.87402,0.99213,0.88189,0.99213,0.88976,0.99213,0.89764,0.99213,0.90551,0.99213,0.91339,0.99213,0.92126,0.99213,0.92913,0.99213,0.93701,0.99213,0.94488,0.99213,0.95276,0.99213,0.96063,0.99213,0.9685,0.99213,0.97638,0.99213,0.98425,0.99213,0.99213,0.99213,0.99609,0.99213,0.00391,0.99609,0.00787,0.99609,0.01575,0.99609,0.02362,0.99609,0.0315,0.99609,0.03937,0.99609,0.04724,0.99609,0.05512,0.99609,0.06299,0.99609,0.07087,0.99609,0.07874,0.99609,0.08661,0.99609,0.09449,0.99609,0.10236,0.99609,0.11024,0.99609,0.11811,0.99609,0.12598,0.99609,0.13386,0.99609,0.14173,0.99609,0.14961,0.99609,0.15748,0.99609,0.16535,0.99609,0.17323,0.99609,0.1811,0.99609,0.18898,0.99609,0.19685,0.99609,0.20472,0.99609,0.2126,0.99609,0.22047,0.99609,0.22835,0.99609,0.23622,0.99609,0.24409,0.99609,0.25197,0.99609,0.25984,0.99609,0.26772,0.99609,0.27559,0.99609,0.28346,0.99609,0.29134,0.99609,0.29921,0.99609,0.30709,0.99609,0.31496,0.99609,0.32283,0.99609,0.33071,0.99609,0.33858,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_164()
		{
			double[] value = {0.34646,0.99609,0.35433,0.99609,0.3622,0.99609,0.37008,0.99609,0.37795,0.99609,0.38583,0.99609,0.3937,0.99609,0.40157,0.99609,0.40945,0.99609,0.41732,0.99609,0.4252,0.99609,0.43307,0.99609,0.44094,0.99609,0.44882,0.99609,0.45669,0.99609,0.46457,0.99609,0.47244,0.99609,0.48031,0.99609,0.48819,0.99609,0.49606,0.99609,0.50394,0.99609,0.51181,0.99609,0.51969,0.99609,0.52756,0.99609,0.53543,0.99609,0.54331,0.99609,0.55118,0.99609,0.55906,0.99609,0.56693,0.99609,0.5748,0.99609,0.58268,0.99609,0.59055,0.99609,0.59843,0.99609,0.6063,0.99609,0.61417,0.99609,0.62205,0.99609,0.62992,0.99609,0.6378,0.99609,0.64567,0.99609,0.65354,0.99609,0.66142,0.99609,0.66929,0.99609,0.67717,0.99609,0.68504,0.99609,0.69291,0.99609,0.70079,0.99609,0.70866,0.99609,0.71654,0.99609,0.72441,0.99609,0.73228,0.99609,0.74016,0.99609,0.74803,0.99609,0.75591,0.99609,0.76378,0.99609,0.77165,0.99609,0.77953,0.99609,0.7874,0.99609,0.79528,0.99609,0.80315,0.99609,0.81102,0.99609,0.8189,0.99609,0.82677,0.99609,0.83465,0.99609,0.84252,0.99609,0.85039,0.99609,0.85827,0.99609,0.86614,0.99609,0.87402,0.99609,0.88189,0.99609,0.88976,0.99609,0.89764,0.99609,0.90551,0.99609,0.91339,0.99609,0.92126,0.99609,0.92913,0.99609,0.93701,0.99609,0.94488,0.99609,0.95276,0.99609,0.96063,0.99609,0.9685,0.99609,0.97638,0.99609,0.98425,0.99609,0.99213,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 16384 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_42()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_43()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_44()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_45()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_46()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_47()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_48()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_49()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_50()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_51()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_52()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_53()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_54()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_55()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_56()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_57()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_58()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_59()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_60()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_61()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_62()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_63()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_64()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_65()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_66()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_67()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_68()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_69()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_70()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_71()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_72()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_73()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_74()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_75()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_76()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_77()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_78()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_79()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_80()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_81()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_82()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_83()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_84()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_85()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_86()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_87()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_88()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_89()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_90()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_91()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_92()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_93()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_94()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_95()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_96()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_97()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_98()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_99()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_100()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_101()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_102()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_103()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_104()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_105()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_106()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_107()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_108()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_109()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_110()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_111()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_112()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_113()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_114()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_115()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_116()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_117()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_118()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_119()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_120()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_121()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_122()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_123()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_124()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_125()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_126()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_127()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_128()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_129()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_130()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_131()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_132()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_133()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_134()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_135()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_136()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_137()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_138()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_139()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_140()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_141()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_142()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_143()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_144()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_145()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_146()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_147()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_148()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_149()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_150()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_151()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_152()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_153()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_154()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_155()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_156()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_157()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_158()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_159()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_160()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_161()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_162()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_163()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_164()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 32768 total numbers made up of 16384 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_42()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_43()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_44()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_45()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_46()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_47()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_48()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_49()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_50()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_51()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_52()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_53()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_54()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_55()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_56()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_57()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_58()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_59()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_60()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_61()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_62()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_63()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_64()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_65()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_66()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_67()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_68()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_69()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_70()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_71()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_72()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_73()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_74()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_75()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_76()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_77()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_78()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_79()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_80()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_81()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_82()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_83()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_84()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_85()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_86()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_87()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_88()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_89()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_90()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_91()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_92()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_93()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_94()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_95()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_96()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_97()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_98()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_99()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_100()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_101()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_102()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_103()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_104()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_105()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_106()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_107()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_108()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_109()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_110()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_111()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_112()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_113()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_114()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_115()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_116()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_117()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_118()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_119()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_120()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_121()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_122()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_123()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_124()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_125()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_126()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_127()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_128()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_129()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_130()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_131()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_132()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_133()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_134()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_135()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_136()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_137()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_138()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_139()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_140()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_141()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_142()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_143()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_144()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_145()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_146()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_147()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_148()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_149()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_150()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_151()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_152()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_153()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_154()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_155()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_156()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_157()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_158()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_159()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_160()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_161()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_162()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_163()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_164()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD017 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD017().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD017\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD017 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD017_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD017_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD017_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD017_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
