####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD016.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD016.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD016.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD016.x3d'),
    GeoLOD(center=(44.940476,45.000000,-89950.000000),child1Url=["MarsLOD017.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD017.x3d"],range=1.8E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars005.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars005.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,0.000000,0.000000),height=[-1206.532,-1279.385,-1296.1755,-1105.8995,-1024.8959,-961.0144,-908.9415,-655.1957,-400.26947,-81.59428,-199.02808,-340.05356,-235.89716,-104.19337,330.32205,524.306,514.08215,787.3493,1072.1794,1210.6646,1073.3788,1163.4857,1275.9667,1305.9297,959.5342,695.9901,874.7056,928.26715,875.3351,689.5073,1076.5751,1175.5138,1517.7064,1912.0361,1919.9938,2034.7849,2170.8064,2104.277,1982.2876,1671.3589,1783.2648,1851.8802,1684.9481,1866.1068,2157.781,1925.598,1833.0817,2010.6963,1920.7854,1771.3755,1681.089,1533.6664,1444.8344,1290.528,975.92065,906.0505,810.3778,793.4751,822.96625,1267.35,787.76514,795.2804,198.51157,138.16336,-1305.739,-1169.9058,-1337.5223,-1190.8684,-977.5116,-1104.5027,-1061.1672,-785.7406,-398.95844,-357.72543,-50.87689,297.71597,178.9202,103.391754,300.22583,243.63382,223.1657,449.6603,673.6013,225.87016,910.6531,437.23666,1254.2937,1259.7266,709.54926,611.6935,657.548,995.4791,943.0983,1010.3741,1484.0883,1753.7683,2059.337,1801.4219,1874.3771,1821.2448,1845.6248,1792.749,1721.927,1628.5762,1778.1504,1641.9043,1671.3457,2023.1378,1938.5988,1928.1056,1870.1772,1833.8854,1827.4712,1748.2697,1611.5844,1468.4391,1362.05,1185.1057,1011.56445,816.02747,426.73087,256.70395,80.62808,-269.0886,-193.7055,-374.7502,-300.37845,-932.4225,-1388.4546,-1474.0107,-1352.0245,-1250.6316,-1034.7054,-988.16815,-898.8131,-823.8126,-562.47656,-480.11816,-244.4779,-195.11337,-263.32608,-126.634315,28.303118,73.48923,-18.60121,-11.114182,178.78455,253.6339,95.60339,723.0461,911.1897,576.1825,378.33005,583.0676,-55.189728,506.95447,1028.4609,1084.97,1428.0884,1462.7018,1637.9021,1679.9763,1712.9412,1646.8965,1532.0536,1659.9233,1596.8826,1572.2378,1553.272,1498.4023,1660.4299,1775.8317,1837.8832,1868.2875,1872.1278,1804.4979,1762.5786,1667.643,1555.8743,1402.4751,1281.7327,1101.983,900.627,743.4412,324.2613,-423.26178,-1153.8889,-1533.7578,-1930.8856,-1970.6606,-1998.6514,-2114.6106,-1349.7528,-1385.5507,-1354.6823,-1129.284,-873.9308,-841.1607,-753.0776,-757.3113,-656.11487,-622.196,-577.662,-468.26483,-329.55603,-144.14296,-46.691128,-53.904568,-50.54568,62.865524,-2.541949,95.687004,232.51698,235.96329,586.6394,434.6785,224.3543,267.78903,337.73798,1330.1028,1090.3232,942.1382,1552.8951,1665.8004,1663.2363,1707.6566,1774.7755,1793.4106,1628.518,1629.0336,1532.1182,1532.5217,1588.0684,1565.3052,1671.7008,1769.0656,1845.7935,1914.4034,1947.0073,1851.2069,1696.5807,1556.1187,1547.2445,1419.0305,1226.404,967.866,730.2745,464.84076,-82.14901,-1261.1097,-2900.337,-3472.1697,-3574.3167,-3607.431,-3616.2632,-3509.5657,-1380.9325,-1314.826,-1264.6749,-1051.9675,-1069.64,-789.933,-1009.69727,-639.1202,-620.39136,-602.09076,-669.30743,-598.396,-374.2586,-64.83593,-51.743107,-246.29439,16.809532,83.509605,-20.790127,83.98339,207.58142,18.1085,143.54349,174.10173,164.11385,238.05302,155.18863,642.5025,868.0142,1221.3491,1821.2394,1714.2391,1493.9036,1881.0754,1430.1813,1638.5967,1750.2845,1728.5349,1633.0192,1643.8722,1622.252,1596.1229,1643.8876,1743.3864,1853.6665,1958.8765,2027.4332,1841.8728,1172.0918,1416.5233,1533.2137,1414.1309,1183.6521,898.22,554.7545,-16.190107,-1091.8159,-2625.3135,-3659.0833,-3818.5852,-3852.7546,-3840.814,-3811.6484,-3797.7979,-1360.2123,-1273.4629,-1262.4003,-1193.8378,-1039.1143,-954.52563,-824.6424,-672.2379,-644.66785,-545.05475,-755.2169,-503.6046,-414.12064,-361.26233,89.84961,63.19824,78.090195,17.308651,-100.93928,295.73593,400.03674,36.210197,42.248455,458.83185,63.75778,46.843784,136.74431,-158.43446,385.35724,473.77634,1046.9529,1330.9858,1263.9431,1649.0304,1779.9994,1745.7578,1893.3971,1704.6569,1749.213,1599.3079,1647.1539,1607.558,1621.4303,1747.6011,1801.1609,1932.4742,1986.1045,1439.7888,764.482,1536.5762,1649.2688,1468.8534,1160.4299,769.1093,109.736115,-1017.6727,-2221.5935,-3452.4421,-3852.521,-3851.0762,-3847.503,-3827.6106,-3819.676,-3800.5251,-1345.8121,-1400.6787,-1218.8699,-1116.9653,-1143.5936,-1009.52,-990.5153,-974.2524,-1100.4572,-634.7012,-419.4248,-485.7105,-453.00214,-1392.8127,-174.41046,-111.61051,212.2116,316.49408,429.2577,669.88464,253.04242,-15.271124,-83.235374,152.1208,378.31235,336.1175,373.07187,350.11496,558.4376,851.63525,932.57794,884.6489,1219.1149,956.38763,1087.6448,1530.7086,1716.9817,1615.0253,1656.9469,1538.6284,1590.9763,1908.1394,1999.1204,1725.7423,1791.869,1928.1409,2078.1794,1133.6847,986.78284,1701.5486,1692.6932,1397.4452,1014.37744,472.3598,-305.96945,-1619.0645,-3032.8096,-3706.7468,-3896.3372,-3861.2522,-3864.1702,-3862.776,-3838.7156,-3801.382,-1505.1127,-1286.0365,-1312.4186,-1241.7156,-1279.835,-1189.3418,-1249.6193,-963.01355,-802.3903,-970.9613,-659.36743,-881.98376,-410.70657,-241.17339,-285.53262,-50.617878,-570.1885,-170.21536,620.9534,616.47296,297.39032,-312.7486,-307.02875,-170.02281,523.64374,524.7699,672.4912,719.2344,635.7309,717.0745,520.32654,743.46246,747.3628,535.6036,604.8381,1382.9802,1795.8303,1791.7867,1677.4175,1590.3557,1578.643,1572.9608,1728.6749,1618.9265,1663.249,1850.021,2068.5483,1738.0255,1552.4763,1612.0948,1460.6149,1161.8026,779.16516,205.51324,-803.2112,-2075.6619,-3406.4019,-3817.1843,-3855.594,-3887.688,-3896.0012,-3859.3965,-3798.9043,-3755.3677,-1478.87,-1345.1332,-1302.4541,-1367.8231,-1351.5361,-1312.3466,-1274.8534,-1082.4474,-980.9609,-1257.8157,-914.0836,-857.95197,-745.3971,-697.4917,-754.7244,-380.92288,-1040.6024,-720.32965,430.13284,107.851234,-74.1228,-235.86053,-154.76448,-702.419,-337.29733,-539.7576,-361.59116,812.7238,679.2068,416.27084,475.89932,441.0083,660.01697,401.91864,634.7584,720.7404,1532.1761,1556.4203,1468.7146,1341.5869,1239.8286,1343.243,1483.5182,1556.59,1583.341,1756.2385,1882.0883,1945.1495,1798.1993,1494.4849,1234.0176,922.3131,477.54364,-97.79467,-1126.5536,-2359.8337,-3446.3208,-3865.2808,-3890.0654,-3909.546,-3904.3784,-3845.6724,-3780.6626,-3745.2788,-1524.8779,-1314.52,-1542.1342,-1558.2756,-1393.6423,-1422.7985,-1395.6873,-1108.0668,-920.10065,-827.7117,-841.4043,-1002.2735,-988.0599,-1119.8823,-1152.2897,-838.1945,-276.3705,46.0267,20.565956,-93.35611,-222.33545,-423.47687,-378.3198,-281.41565,-819.35645,-1221.4607,-1143.8723,-338.93533,476.09082,40.175125,-50.028637,138.53728,439.39948,474.79437,614.7291,933.5854,1058.1558,1293.9052,1199.1981,935.1445,823.081,879.7007,1093.7194,1368.2906,1494.8851,1550.2493,1626.0774,1650.5277,1554.34,1317.5253,1119.8927,773.6583,253.42635,-486.02332,-1450.0756,-2547.545,-3534.095,-3861.7407,-3896.7578,-3888.0674,-3867.1523,-3811.8142,-3801.8809,-3782.981,-1890.606,-2091.7136,-1464.6985,-1488.555,-1392.4545,-1437.3129,-1377.814,-1177.4313,-1104.4209,-1082.1031,-1189.0552,-1212.8153,-1351.2604,-1541.2472,-1323.3914,-1180.7458,-947.3237,-425.14172,-442.7375,-219.98431,-361.0454,-436.20068,-654.8705,-445.22717,-1128.1978,-1308.5892,-1201.1549,-165.88737,168.5291,-23.192844,-47.988483,-19.062168,93.99743,383.44775,568.81134,632.10815,735.03674,1050.0774,880.84125,953.2258,859.0197,880.7869,1039.3451,1230.842,1185.8408,1356.3323,1385.0402,1310.7866,1264.5214,1109.866,930.0519,637.1887,6.451165,-907.94476,-1958.5234,-3016.0652,-3779.3691,-3846.797,-3827.723,-3819.8264,-3794.212,-3787.6816,-3781.5632,-3717.1338,-1775.403,-1746.8033,-1817.8699,-1705.2659,-2145.0237,-1379.0552,-1310.2324,-1261.0997,-1351.2952,-1799.0524,-1485.5623,-1460.0347,-1555.3384,-1687.4711,-1616.9017,-1507.1514,-1391.9403,-874.58295,-441.26624,-470.85675,-616.83844,-599.1003,-764.9696,-469.39413,-764.1307,-840.1358,-374.32364,315.92487,193.48598,23.644407,-1.087614,84.213005,332.74622,207.48233,381.67343,430.64682,602.0157,941.35895,1342.788,1128.6888,949.3721,907.0231,970.96265,1163.805,1040.1033,1105.3502,1113.046,1088.9215,869.8867,870.76276,657.37445,394.66425,-519.5941,-1237.3135,-2219.0579,-3273.9734,-3798.7537,-3804.5632,-3769.7866,-3785.2346,-3795.5308,-3742.3064,-3709.9534,-3684.5703,-1989.8357,-1930.265,-1903.3112,-1529.8673,-2022.8633,-1449.411,-1522.3862,-1585.7592,-1670.5698,-1962.0009,-1689.0115,-1681.0461,-1635.649,-1777.154,-1769.469,-1692.2957,-1491.497,-1144.4862,-839.46564,-808.18396,-954.0357,-1168.436,-1098.8075,-1126.1077,-1133.2069,-592.1064,-33.123962,113.94125,127.19813,-60.18136,-142.18315,-25.587217,156.18265,211.21231,283.1695,392.77863,422.99774,632.3583,1354.5212,1137.2994,1099.5721,957.69867,896.4065,1027.7909,955.7035,921.81714,951.0524,868.97217,809.2452,699.33923,378.4361,-163.53937,-737.70184,-985.2306,-2392.875,-3259.8916,-3710.0847,-3747.051,-3761.357,-3754.0576,-3735.889,-3708.4329,-3688.5737,-3664.1655,-2001.1196,-2013.8348,-1989.6766,-1744.9738,-1881.374,-1614.1958,-1637.7545,-1670.725,-1749.8722,-1759.568,-1896.2098,-1684.7443,-1610.77,-1755.6165,-1822.7281,-1694.9027,-1520.1293,-1590.7445,-880.9581,-1102.735,-1415.227,-1368.7399,-942.85455,-962.7136,-1088.6149,-874.3197,-416.12738,-193.37083,-105.702415,-189.78827,-203.06982,88.63568,332.94473,245.67067,133.92598,197.69183,162.2089,650.78485,1171.4608,809.9071,875.3866,730.4826,641.18414,668.91187,699.5734,716.7011,837.1709,763.6764,676.0574,565.50507,277.04245,-180.2659,-401.6903,-689.86975,-1917.754,-2739.007,-3380.778,-3629.4407,-3709.3145,-3675.2815,-3662.1992,-3654.1792,-3659.8445,-3624.691,-2039.7057,-2007.7072,-1998.5564,-1965.7079,-1721.306,-1724.2594,-1710.105,-1898.851,-2099.0776,-1781.2517,-1738.2148,-1746.8855,-1612.4971,-1698.6674,-1839.1229,-1748.2952,-1255.9034,-2240.8235,-1218.0778,-1428.2909,-1509.4496,-970.4615,-229.56242,-84.16746,-383.62714,-636.82983,-541.32104,-384.6394,-156.38356,13.31488,258.11185,434.98343,328.20306,599.66534,585.04846,-94.23989,-108.94417,677.94727,424.62115,261.59207,984.9711,491.5517,217.55794,123.435974,158.87012,502.3733,694.88446,856.3756,1046.4651,604.98175,36.47029,-242.62407,-133.75385,-205.68454,-1244.994,-2045.8674,-2765.529,-3250.8728,-3467.7263,-3569.3948,-3564.2678,-3601.5564,-3572.371,-3587.6401,-2064.7688,-2008.1211,-1999.6051,-1857.2122,-1876.4387,-1798.344,-1957.2216,-2018.6193,-1985.1409,-1794.2728,-1691.93,-1856.9324,-1821.1119,-1754.1721,-1809.2863,-1546.6978,-1307.963,-1076.1842,-1314.0262,-1502.2065,-1087.6996,-1077.3717,-918.9807,-1026.8524,-525.81525,-9.170605,-553.8118,-682.5481,-339.18198,92.853134,459.0116,476.5182,329.56818,412.4226,376.41354,124.756584,198.42444,451.98907,549.0963,723.4252,1289.021,295.63605,132.91403,97.858894,110.1952,444.82205,260.08383,753.9464,555.6515,466.3181,203.17766,-101.440765,-5.785231,-374.0224,-431.03336,-1269.6482,-1978.4304,-2535.7805,-2806.4087,-3127.6643,-3271.8767,-3346.6328,-3362.2222,-3433.065,-2080.3289,-1969.4227,-2012.65,-1932.9325,-1942.9476,-2064.8765,-2140.8142,-2217.4268,-2227.4834,-2137.6775,-1754.0822,-1940.875,-2025.9252,-1997.6299,-2004.3269,-1402.7499,-1365.3254,-1085.6998,-1577.603,-1320.7327,-1089.113,-1322.589,-1278.9701,-1231.2549,-970.57446,-212.56557,-381.9347,-669.93353,-287.8568,-69.0206,105.00809,270.10483,252.12106,393.9178,369.4631,-23.83347,494.6589,-10.347915,274.71094,837.0876,1384.0062,591.08777,163.5837,96.162186,195.51024,-19.75233,-1020.56665,-359.7042,424.5599,744.797,467.14926,288.23148,-73.649185,-171.8851,-140.87578,-1009.3966,-1408.766,-1843.5891,-2290.755,-2504.1353,-2749.5742,-2930.26,-3066.4368,-3255.893,-1941.2072,-2152.8474,-2146.1487,-2123.1353,-2106.4558,-2164.85,-2162.8142,-2063.2776,-2189.8477,-2546.1194,-1992.3981,-1853.1477,-2037.7292,-1979.4357,-1695.5713,-1132.8939,-1381.0107,-1401.5034,-1506.85,-1382.8934,-1506.4163,-1652.8037,-1512.7675,-1481.1017,-1394.7205,-323.49014,-784.80743,-1035.0228,-600.9077,-401.67,-316.1161,-314.19183,66.10274,163.4472,-32.63228,300.38638,301.8418,269.7785,418.49515,1006.19055,1189.0027,1154.6163,633.8557,369.61472,586.8485,929.13336,-373.07385,100.540665,471.72885,501.6495,538.7523,330.71335,306.49567,31.314259,-343.35147,-565.47784,-1010.9039,-1616.7384,-1930.6277,-2099.8093,-2310.955,-2596.7727,-2915.3167,-3232.7183,-2093.4111,-2211.2227,-2373.1877,-2267.8687,-2306.8647,-2257.4026,-2162.428,-2419.4443,-2592.5818,-2248.383,-2048.5583,-1981.8369,-1876.9288,-1991.7676,-1687.8788,-1294.5995,-1467.0299,-1615.9924,-1649.7482,-1361.0836,-753.65643,-1460.9893,-1601.2648,-1587.8552,-1271.9662,-373.13156,-1143.607,-1135.3835,-644.30664,-897.9123,-784.779,-783.0361,-89.996185,-413.05118,-1258.4119,-352.449,94.93584,2.68439,478.36823,394.62296,61.247288,979.49536,963.12506,564.26086,405.72202,916.6732,609.7008,357.85184,568.5541,369.1549,398.01486,519.2912,448.59106,543.8917,-48.708874,-226.93163,-526.0215,-1307.1086,-1712.0317,-2595.7607,-2224.2937,-2541.5652,-2966.799,-3327.0537,-2141.4963,-2194.2224,-2400.283,-2409.6292,-2176.704,-2155.6436,-2146.6082,-2061.7617,-2213.2263,-2078.0247,-2222.9353,-1945.5854,-1633.0181,-1648.022,-1686.8899,-1908.0614,-1267.6829,-1562.0957,-1692.5552,-1627.8846,-970.48773,-608.32446,-1349.9401,-745.08496,-652.6275,-1008.0841,-1234.3842,-1090.3942,-758.6377,-831.8946,-890.9018,-978.17395,-485.7322,-498.6493,-735.8317,-375.70746,-538.28796,-792.97394,-633.1481,-366.85312,-510.54965,509.77393,507.4455,333.94177,-803.02905,128.25105,640.6888,243.30428,535.6913,718.2105,758.2949,710.9401,525.33527,-13.030252,-732.57965,-203.80948,-825.9066,-1334.949,-1711.5391,-1891.7413,-2324.1416,-2824.9922,-3180.5466,-3425.706,-2255.1929,-2279.9453,-2411.9182,-2339.241,-2202.5876,-2091.6157,-2234.045,-2392.2185,-2509.7034,-2274.1633,-2209.8977,-1901.3528,-1778.4169,-1759.4207,-1450.7142,-1663.0173,-1279.5913,-1573.5354,-1688.2311,-1833.0419,-1326.603,-715.9836,-755.9596,-137.18568,-575.6247,-1097.3795,-1017.00665,-843.0678,-735.59125,-854.6814,-850.2475,-836.22327,-1240.3171,-1473.4015,-1353.7013,-1219.6302,-1105.3618,-693.5058,-347.06833,157.0647,285.85083,285.92557,135.8829,126.856224,229.73529,434.50238,553.20197,495.0463,317.83508,644.2975,413.36087,157.74469,-303.63626,-907.49384,-1491.2684,-1133.0205,-1486.2471,-1865.281,-1995.8596,-2415.0046,-2756.9114,-3200.7947,-3377.0781,-3518.3303,-2490.98,-2595.274,-2512.1992,-2385.9978,-2684.053,-2498.195,-2223.3738,-2250.7317,-2496.798,-2354.487,-2226.3794,-2018.7452,-1834.6862,-1867.7286,-1858.2888,-1497.3798,-1560.0472,-1654.2345,-1861.194,-1590.6669,-1426.1702,-1215.8829,-1042.1788,-635.89996,-501.39172,-758.1763,-757.85046,-580.82745,-547.4736,-717.4412,-697.193,-860.8628,-1527.9504,-1623.7566,-1505.0823,-1368.5245,-1357.0631,-864.7454,-293.6116,-2.096422,-63.38795,42.435028,-111.60291,-6.16944,223.1316,342.86487,390.1319,198.71414,173.87495,34.172546,-482.83554,-1172.4348,-1785.3176,-1927.9644,-1700.4375,-1993.2277,-1822.0149,-2188.8484,-2522.5312,-2787.3645,-3159.739,-3363.4275,-3496.414,-3614.421,-2554.255,-2591.537,-2429.2605,-2298.2498,-2355.3315,-2295.1062,-2675.873,-2570.7285,-2485.3423,-2199.1558,-1958.614,-1920.2582,-1830.2618,-1977.5944,-1826.4467,-1673.4718,-1770.314,-1735.5706,-1704.19,-1712.8561,-1405.1483,-1271.3342,-1056.5525,-738.21277,-522.1139,-819.3971,-872.4427,-711.78735,-547.628,-570.41656,-605.1022,-863.0201,-1370.4679,-1544.8558,-1430.8613,-1562.0798,-1206.4768,-761.98816,-404.03302,-158.76149,-224.33974,-245.56386,-408.54465,-347.66248,-783.18506,-464.15353,-113.52286,92.725784,-172.64377,434.78976,30.45377,-672.19073,-1743.1898,-2055.8455,-1815.9111,-2143.7314,-2304.6895,-2602.0615,-2960.4126,-3151.1536,-3327.1406,-3459.5037,-3563.9507,-3689.9656,-2414.9314,-2370.1377,-2272.759,-2250.1152,-2449.1145,-2299.4314,-2347.966,-2320.8586,-2146.7815,-1908.397,-1942.7611,-2069.173,-1926.4072,-2003.4268,-1729.3553,-2483.3245,-2234.7988,-1555.1459,-1746.639,-1681.6171,-1940.9708,-1560.2493,-941.0002,-791.4512,-615.4528,-775.92224,-793.7267,-518.6549,-241.85844,-238.28076,-373.13818,-804.5304,-1169.9204,-1343.438,-1239.3965,-1048.1218,-897.3373,-701.88196,-448.71606,-470.68903,-363.14883,-571.0858,-847.6755,-645.03375,-853.0046,-747.92847,-642.2374,-155.50664,-206.65869,-158.79398,-464.56967,-522.22034,-1801.2738,-2119.994,-2248.7131,-2477.0667,-2706.4912,-2964.4373,-3187.465,-3300.1484,-3425.022,-3535.642,-3642.7656,-3724.9119,-2378.9514,-2323.8108,-2325.3665,-2448.961,-2429.346,-2292.6619,-2195.9453,-2066.6313,-1863.5737,-2284.666,-1804.6265,-1929.2096,-2458.5908,-1853.6895,-1637.2402,-1364.0255,-1203.2115,-1329.7595,-1385.28,-1193.1675,-1849.9802,-1749.5773,-883.54144,-1118.2985,-597.48517,-850.6864,-961.08167,-495.19507,-572.62024,-457.4839,-0.985485,-560.121,-664.1182,-669.70715,-663.26654,-399.7403,-335.72787,-478.61572,-460.18658,-591.9476,-503.45413,-925.2746,-1957.4054,-1744.6106,-1605.5391,-1306.166,-1446.9323,-786.64484,-784.0822,-956.2699,-1558.3037,-2123.8547,-2205.7852,-2448.1152,-2544.3325,-2888.9272,-2935.5044,-3094.7666,-3310.6272,-3395.127,-3516.6304,-3602.8293,-3699.7175,-3805.4185,-2744.589,-2473.9878,-2380.2747,-2331.591,-2257.1858,-2306.3274,-2585.2695,-2198.736,-2084.737,-2326.6008,-2303.3608,-2086.335,-2095.637,-1804.715,-1863.5421,-2000.8882,-1824.9646,-1628.417,-1745.4377,-1720.5763,-1489.1198,-1205.5345,-1074.7579,-798.29407,-800.36285,-1483.0516,-770.30853,-422.25552,-390.77927,-327.12305,16.324577,-233.75209,-105.282,-69.02935,73.400566,135.3041,41.788715,-189.20541,-297.10785,-448.38773,-763.0215,-1298.0472,-1610.3694,-1605.4065,-1834.742,-2053.6392,-2168.963,-2008.669,-1834.1383,-1728.9512,-2150.016,-2326.0908,-2342.002,-2451.417,-2743.5623,-2932.694,-3102.2656,-3257.6572,-3406.3752,-3516.3179,-3589.109,-3680.8352,-3767.3313,-3863.8818,-3221.8904,-2549.9883,-2447.1277,-2271.5496,-2151.008,-2225.968,-2303.681,-2244.1448,-2095.2197,-2822.2002,-3133.6123,-2287.6104,-2252.7776,-1987.3717,-1927.1957,-2335.7295,-2349.1992,-2197.588,-1835.5765,-2127.9102,-2066.985,-1861.1576,-1676.8558,-1209.2606,-1011.2972,-864.03046,-743.98224,-513.5697,-307.98868,-161.10481,-133.12758,-88.829025,125.07089,264.5521,378.50992,381.14346,215.83388,-83.05412,-213.87433,-865.53046,-2398.54,-2205.2153,-2021.3365,-1606.3716,-1914.0143,-1541.7639,-1859.464,-1680.3094,-2145.167,-2294.099,-2421.429,-2458.6282,-2506.6963,-2677.3232,-3021.1423,-3062.1013,-3205.285,-3354.899,-3509.9265,-3614.3494,-3659.7246,-3723.417,-3859.3481,-3959.1365,-3122.4873,-2965.126,-2637.5361,-2585.4521,-2612.558,-2529.684,-2617.422,-2504.976,-2206.1582,-2234.0652,-2051.4253,-2346.516,-2402.292,-2204.8774,-2330.9775,-2100.8625,-2506.5642,-2448.4377,-1827.9443,-1874.4493,-2156.2952,-2049.6506,-1846.7944,-1591.9785,-1682.115,-933.88654,-901.57104,-1205.9241,-664.38196,-328.63385,54.976982,-107.240555,-140.18082,173.69952,150.31674,-12.241212,-494.2157,-58.908863,-397.25485,-566.4931,-2086.523,-2300.0486,-2477.4688,-2296.2505,-1986.8213,-1850.6146,-2137.9893,-2213.8845,-2363.865,-2492.7942,-2519.8274,-2663.6497,-2761.3462,-2796.2866,-3046.3499,-3193.3516,-3324.7244,-3460.2917,-3615.9648,-3657.1821,-3720.9583,-3811.1294,-3918.9856,-4058.1804,-3359.7703,-3455.1555,-3206.672,-3079.2427,-2990.1646,-2987.5835,-2850.7344,-2585.973,-2432.0886,-2315.571,-2239.3633,-2404.5605,-2526.7832,-2864.7861,-2761.6147,-2841.5044,-3256.8843,-3078.4944,-1979.6309,-2001.4083,-2629.0078,-2615.9775,-1587.7339,-1191.1494,-1606.3582,-1308.3752,-1425.666,-1537.148,-1157.5231,-835.1606,-430.71317,-799.96716,-935.0137,-495.13422,-57.303787,-201.4021,-631.2611,-325.07617,-586.8085,-1225.3168,-2554.3533,-2403.1218,-2412.0623,-2317.5393,-2311.5042,-2403.083,-2429.9675,-2553.3232,-2621.9224,-2683.0925,-2778.3342,-2831.6257,-3000.249,-3069.0383,-3136.6348,-3341.028,-3437.6052,-3548.5967,-3655.5547,-3703.0398,-3756.16,-3879.8748,-3981.6301,-4116.5327,-3723.8254,-3614.002,-3794.0981,-3671.4636,-3361.6794,-3256.568,-3153.6238,-2907.164,-2880.242,-2598.6016,-2595.8857,-2722.1292,-2844.2258,-3222.4883,-2566.0818,-3255.4229,-3217.7969,-3185.5613,-2782.3997,-2182.1665,-2630.9214,-2317.5706,-1406.4431,-865.76764,-1754.782,-1803.6035,-1954.3716,-1738.2384,-1578.5295,-1191.8289,-1150.5825,-2276.3794,-1439.1904,-1474.5752,-791.4169,-1052.9625,-1623.822,-1614.9795,-1428.7301,-1849.1077,-2351.3347,-2412.4111,-2420.049,-2442.9502,-2572.5466,-2633.6396,-2791.0112,-2767.2517,-2860.058,-2923.6328,-3011.6636,-3078.9177,-3108.8293,-3130.1365,-3314.1592,-3478.9697,-3554.298,-3628.615,-3667.0234,-3738.4626,-3797.836,-3883.2864,-4028.5715,-4187.852,-3928.2437,-3837.831,-3842.7441,-3818.704,-3766.6016,-3584.554,-3552.5444,-3235.865,-3171.8064,-2966.2244,-3236.382,-3146.029,-3306.0293,-3112.0117,-3359.5603,-3568.618,-3619.843,-3382.9885,-3224.6802,-3153.4436,-2694.5518,-2532.8113,-2942.2683,-2933.3586,-2808.14,-2054.3596,-1934.7632,-1769.7365,-1504.6328,-1274.9548,-2185.8044,-3372.0972,-2338.589,-1380.1992,-1813.2192,-2103.43,-2390.9812,-2581.767,-2488.0305,-2261.3027,-2569.8154,-2561.6777,-2619.3933,-2495.9036,-3046.8474,-2819.73,-2932.3638,-3052.1616,-3116.3792,-3088.9204,-3084.599,-3126.4412,-3169.3281,-3221.687,-3499.6938,-3580.8867,-3595.7356,-3625.8325,-3722.6216,-3778.2156,-3816.2815,-3947.7224,-4064.9,-4219.7095,-4048.8955,-3996.5972,-3993.1453,-3939.471,-3916.2893,-3808.5476,-3725.9165,-3546.0342,-3304.194,-3171.9783,-3075.036,-3084.955,-3601.751,-3567.6008,-3717.4187,-3676.1184,-3606.2139,-3141.7068,-3096.2922,-3515.0881,-3203.5125,-3294.2815,-3334.0269,-3212.7092,-3439.1948,-3179.5896,-2068.047,-1126.1677,-1655.2922,-2475.4062,-2632.5017,-1739.9918,-1038.2953,-1182.3053,-2301.4556,-2837.8057,-2324.4966,-2246.1897,-2441.6711,-2586.6663,-2668.9404,-2673.973,-2670.183,-2796.776,-2851.552,-3016.8503,-3111.6316,-3173.248,-3188.294,-3145.543,-3218.4734,-3295.7378,-3367.0645,-3488.2483,-3545.3794,-3613.0688,-3604.0354,-3652.2212,-3766.658,-3852.081,-3833.618,-3973.125,-4106.3545,-4251.5957,-4176.67,-4188.8623,-4190.259,-4097.3823,-4010.4006,-3944.8652,-3870.17,-3814.38,-3718.4214,-3470.3237,-3389.414,-3444.6523,-3676.9734,-3636.3567,-3625.587,-3180.9736,-3238.2688,-3067.5576,-3274.094,-3324.4832,-3061.3054,-3248.543,-3483.5718,-3509.872,-3507.8706,-3465.7207,-3014.5625,-1962.4341,-1502.106,-2401.494,-2703.5823,-2617.4226,-2004.679,-2114.7593,-2698.6519,-2742.417,-2470.1316,-2181.1892,-2462.1924,-2784.2937,-2750.9417,-2893.1038,-2899.2832,-2972.6494,-3051.1323,-3100.8354,-3270.615,-3352.1577,-3328.7837,-3382.4053,-3427.1382,-3457.9233,-3478.5327,-3560.529,-3605.8748,-3656.7568,-3702.7793,-3751.553,-3783.2415,-3877.2415,-3935.9712,-4034.1377,-4188.254,-4310.8984,-4345.512,-4266.2246,-4247.9634,-4199.2812,-4174.107,-4111.011,-3982.7876,-3993.0623,-3947.4797,-3816.8635,-3792.3657,-3776.0212,-3794.0645,-3698.294,-3676.8787,-3565.8103,-3563.6484,-3509.2815,-3562.075,-3306.479,-2994.4924,-3327.919,-3508.7334,-3502.13,-3410.8813,-3505.653,-3214.7476,-2641.4912,-2578.2605,-2707.167,-2946.7808,-2921.6697,-2670.4954,-2865.6484,-2946.8628,-2536.8398,-2487.3625,-2461.662,-2687.5535,-2886.0874,-2935.211,-3042.6562,-3130.0813,-3154.4277,-3209.7876,-3325.6074,-3430.9485,-3389.5593,-3472.707,-3482.0447,-3509.8352,-3536.315,-3539.3372,-3580.9707,-3650.4243,-3715.1482,-3766.0627,-3833.4465,-3886.5095,-3954.2402,-4012.5254,-4120.453,-4323.5913,-4462.9126,-4367.495,-4379.471,-4300.2153,-4238.524,-4239.601,-4136.3374,-4078.6746,-4097.9883,-4037.0962,-4005.57,-3943.0625,-3918.2874,-3835.5042,-3847.9478,-3830.5002,-3843.5325,-3786.0356,-3805.5398,-3738.0244,-3580.486,-3572.9895,-3507.1729,-3510.1475,-3395.667,-3444.263,-3476.0637,-3464.9421,-3357.918,-3230.3076,-3114.4468,-2962.789,-3080.0735,-3222.2266,-3253.125,-3201.9243,-3016.346,-2868.968,-2885.7622,-2984.1482,-3166.6711,-3194.001,-3233.3276,-3244.0544,-3273.2612,-3275.1465,-3449.5928,-3481.5178,-3461.2434,-3478.0974,-3524.0364,-3585.9219,-3602.7627,-3574.1055,-3650.76,-3710.1882,-3733.3364,-3784.8245,-3850.3918,-3913.7625,-3995.703,-4112.5996,-4210.27,-4454.6997,-4562.5273,-4485.8687,-4456.641,-4359.6475,-4290.965,-4251.7207,-4194.42,-4138.692,-4123.2983,-4083.2832,-4059.681,-4025.2024,-3975.7559,-3970.5469,-3943.351,-3922.2502,-3869.3413,-3874.1775,-3772.3284,-3677.3108,-4327.284,-5036.857,-4440.677,-3631.0984,-3387.766,-3580.36,-3592.204,-3500.079,-3316.1287,-3225.2983,-3233.7156,-3248.5405,-3231.575,-3297.3293,-3278.7385,-3222.6853,-3320.2358,-3209.1255,-3232.3174,-3312.9202,-3353.6418,-3396.325,-3378.0076,-3343.4912,-3361.456,-3404.359,-3512.0115,-3521.8008,-3521.8198,-3524.2092,-3585.4453,-3619.2307,-3604.9175,-3600.3367,-3659.4275,-3700.2764,-3746.3096,-3820.415,-3904.8523,-3965.4216,-4052.9739,-4151.6826,-4233.202,-4394.153,-4476.683,-4540.921,-4507.0796,-4449.873,-4385.39,-4338.676,-4272.5513,-4214.328,-4181.4717,-4147.1636,-4118.964,-4094.6113,-4099.297,-4081.9817,-3990.2764,-4020.42,-3982.9363,-3956.9058,-3821.0938,-3634.5427,-4702.124,-5611.6523,-5203.771,-3584.5264,-3085.5386,-3467.1665,-3661.2244,-3596.5007,-3380.487,-3433.3735,-3374.304,-3357.743,-3388.2432,-3475.521,-3476.9976,-3503.8413,-3468.9536,-3396.4883,-3428.0317,-3460.641,-3467.8516,-3483.4368,-3495.208,-3474.4595,-3511.0242,-3520.194,-3537.203,-3552.3584,-3556.2922,-3558.6365,-3613.1687,-3644.3381,-3613.7478,-3610.6997,-3674.6423,-3712.838,-3767.8997,-3849.1533,-3904.5432,-3966.2505,-4073.8794,-4149.6035,-4269.431,-4353.6416,-4344.747,-4534.1963,-4522.2095,-4469.9404,-4443.758,-4387.3574,-4342.0854,-4297.7705,-4249.809,-4205.9165,-4168.8003,-4141.7534,-4084.2815,-4045.962,-4042.5466,-4069.3533,-3983.8723,-3970.893,-3871.2368,-3637.2124,-3804.2837,-3886.7524,-3359.3354,-3374.573,-3334.3955,-3553.8303,-3737.4072,-3647.5256,-3572.538,-3568.5647,-3565.8652,-3562.8708,-3516.3276,-3506.76,-3532.9282,-3578.4165,-3566.877,-3534.7937,-3544.5447,-3546.0054,-3566.5974,-3614.099,-3635.2349,-3614.8835,-3605.1257,-3610.6812,-3531.026,-3540.0637,-3573.0393,-3600.946,-3608.9202,-3628.214,-3603.4646,-3589.8713,-3692.6692,-3746.6123,-3784.6028,-3834.8494,-3902.9126,-3987.3276,-4064.9268,-4174.247,-4252.4917,-4295.391,-4291.422,-4593.0474,-4567.2583,-4518.0957,-4488.914,-4441.5684,-4401.846,-4350.447,-4282.145,-4281.203,-4277.0063,-4226.4653,-4192.8843,-4178.4756,-4156.939,-4091.3855,-4019.029,-4000.522,-3981.633,-3894.3013,-3833.2488,-3694.1072,-3549.7625,-3677.5715,-3637.1257,-3693.505,-3815.49,-3725.256,-3720.7722,-3662.7383,-3694.966,-3658.629,-3668.9365,-3635.3806,-3650.8997,-3656.2258,-3612.244,-3659.1494,-3682.2107,-3731.7817,-3725.157,-3720.8909,-3715.0684,-3694.7346,-3668.6748,-3633.2424,-3593.3918,-3584.7117,-3610.3416,-3625.6895,-3627.8584,-3598.5737,-3587.2651,-3664.2168,-3713.833,-3748.847,-3785.9119,-3851.6626,-3929.11,-4013.1418,-4096.1206,-4145.95,-4168.7,-4190.524,-4255.242,-4656.332,-4610.2056,-4586.2573,-4556.4536,-4516.751,-4447.7314,-4375.215,-4346.636,-4330.5405,-4306.0757,-4288.5527,-4240.6743,-4219.504,-4179.3027,-4145.789,-4103.6953,-4073.092,-4019.5662,-3942.5168,-3937.5122,-3960.7761,-3898.7788,-3901.7195,-3876.4666,-3849.0051,-3830.6716,-3793.639,-3791.178,-3775.2825,-3756.1584,-3757.6099,-3766.9104,-3767.102,-3750.287,-3731.5586,-3748.0547,-3790.491,-3828.6304,-3828.941,-3827.3496,-3798.7546,-3790.3757,-3752.0972,-3709.4968,-3688.5837,-3647.6282,-3624.7761,-3616.5532,-3596.4395,-3592.05,-3586.336,-3620.9731,-3703.9905,-3747.6948,-3762.89,-3778.6948,-3854.654,-3945.861,-4026.4668,-4062.1162,-4076.7996,-4085.9653,-4154.5713,-4244.4956,-4687.877,-4666.969,-4611.2144,-4576.9805,-4541.57,-4492.7285,-4465.0596,-4409.156,-4395.5303,-4383.156,-4334.131,-4330.1963,-4290.0713,-4245.518,-4182.5,-4158.458,-4115.2446,-4079.392,-4008.3252,-3969.339,-3929.402,-3910.0967,-3869.154,-3854.2725,-3832.846,-3839.7612,-3893.389,-3893.4548,-3866.5996,-3858.5813,-3859.5093,-3865.7795,-3862.5457,-3888.889,-3869.6902,-3875.2139,-3895.9805,-3943.068,-3927.6243,-3892.791,-3875.5493,-3833.88,-3774.419,-3772.142,-3763.5396,-3728.3643,-3686.1177,-3672.9092,-3628.003,-3662.9001,-3667.9368,-3680.2107,-3703.0076,-3745.6448,-3782.7908,-3797.5347,-3823.5286,-3914.5986,-3986.2905,-4016.7996,-4025.6099,-4062.5693,-4105.041,-4176.636,-4713.6636,-4674.9697,-4640.258,-4626.737,-4598.1895,-4579.8774,-4549.542,-4505.7637,-4470.882,-4435.9224,-4387.278,-4363.5225,-4311.1895,-4217.2183,-4219.293,-4199.207,-4187.132,-4134.432,-4056.3015,-4038.521,-4004.3823,-3994.2708,-3996.691,-3981.4297,-3923.9539,-3943.9756,-3962.9963,-3944.6687,-3949.3035,-3922.5383,-4023.787,-3993.9192,-4005.2344,-3979.6443,-3985.56,-3986.4597,-4025.8975,-4043.144,-4007.2395,-3968.7952,-3910.5042,-4203.858,-3786.235,-3789.235,-3800.9387,-3809.1492,-3757.482,-3718.7427,-3713.1765,-3712.412,-3707.0076,-3694.7896,-3693.7434,-3738.513,-3778.659,-3798.456,-3831.6707,-3909.623,-3941.53,-4012.8423,-4067.6338,-4068.4119,-4044.4534,-4089.8694,-4705.682,-4659.882,-4676.4565,-4643.63,-4618.9976,-4596.8545,-4547.4775,-4432.73,-4471.837,-4479.8047,-4424.3975,-4377.9575,-4334.4526,-4292.8306,-4245.4775,-4233.6167,-4207.6504,-4177.401,-4146.9893,-4134.4536,-4122.698,-4097.214,-4073.1057,-4024.8484,-4005.7957,-4002.2869,-4001.7844,-4001.9255,-4039.3972,-4056.766,-4058.9421,-4068.639,-4083.709,-4063.0776,-4034.347,-4036.6282,-4062.9534,-4054.9453,-4066.1606,-4007.6504,-3944.4734,-3960.5527,-3851.8677,-3859.5544,-3843.8833,-3820.2297,-3793.7212,-3768.296,-3737.958,-3744.622,-3722.6638,-3757.2117,-3732.2664,-3759.0405,-3783.345,-3817.3855,-3861.4382,-3891.9922,-3889.919,-3962.1477,-4017.5037,-4055.0376,-4048.4502,-4022.3274,-4720.9355,-4717.357,-4686.0273,-4660.0703,-4634.392,-4617.299,-4592.88,-4615.958,-4588.5435,-4500.985,-4438.013,-4426.0654,-4391.2134,-4356.6313,-4295.2344,-4288.529,-4256.8926,-4216.167,-4218.721,-4196.537,-4175.682,-4156.5737,-4133.5474,-4099.3765,-4085.8103,-4083.5732,-4110.0435,-4123.232,-4129.488,-4133.926,-4140.576,-4150.655,-4151.646,-4146.077,-4128.6484,-4113.9844,-4129.245,-4100.1416,-4121.1763,-4088.0889,-4018.9849,-3966.4138,-3941.1377,-3977.952,-3977.0618,-3908.0474,-3846.016,-3839.46,-3803.1904,-3787.7458,-3771.7024,-3756.7395,-3766.339,-3769.7563,-3798.4456,-3830.583,-3850.919,-3868.8127,-3884.188,-3895.2627,-3944.6597,-3923.3135,-3953.6206,-4017.257,-4753.693,-4735.11,-4716.2715,-4674.0737,-4639.1157,-4616.3047,-4608.1025,-4631.0503,-4581.779,-4475.56,-4440.728,-4461.983,-4403.551,-4386.319,-4357.409,-4291.0117,-4279.1914,-4267.3823,-4260.9873,-4221.987,-4208.8833,-4220.104,-4198.402,-4180.3,-4187.342,-4206.4053,-4177.698,-4181.2656,-4191.3003,-4195.037,-4210.6606,-4209.019,-4209.88,-4203.532,-4176.858,-4170.3486,-4175.379,-4153.8647,-4138.9434,-4152.1953,-4116.889,-4052.9045,-4009.0046,-4029.3118,-3999.24,-3957.8604,-3921.2446,-3910.6514,-3886.0176,-3842.8728,-3822.7034,-3821.7283,-3806.1262,-3763.8472,-3783.0352,-3807.0212,-3830.744,-3828.81,-3853.8477,-3893.4778,-3918.6558,-3875.2725,-3949.6953,-4037.8157,-4796.6396,-4773.9917,-4738.022,-4695.606,-4644.4995,-4630.4062,-4619.4375,-4655.3657,-4605.6084,-4478.5225,-4488.247,-4486.4043,-4445.3643,-4427.4736,-4404.9277,-4382.357,-4350.263,-4311.5713,-4288.7075,-4288.8735,-4282.916,-4284.16,-4274.209,-4268.8926,-4252.471,-4264.5156,-4262.98,-4249.731,-4256.534,-4260.903,-4247.058,-4247.7383,-4248.1543,-4227.5894,-4203.5337,-4229.382,-4210.6636,-4211.375,-4188.473,-4157.86,-4183.394,-4147.2124,-4109.3228,-4079.9072,-4062.3623,-4046.2034,-4027.513,-3982.442,-3958.7654,-3930.34,-3906.0305,-3881.1746,-3861.3645,-3851.9897,-3845.1382,-3842.8994,-3837.4377,-3838.1428,-3860.823,-3886.8564,-3903.9812,-3925.5713,-3934.1064,-3983.2905,-4837.2295,-4796.0854,-4750.6226,-4730.1514,-4702.547,-4659.8857,-4650.439,-4576.2495,-4526.213,-4524.818,-4539.4673,-4521.8853,-4510.179,-4482.758,-4446.864,-4428.342,-4382.185,-4357.409,-4350.9683,-4355.4033,-4357.097,-4350.802,-4318.315,-4299.84,-4299.3027,-4304.336,-4304.8433,-4306.7993,-4316.0625,-4313.5537,-4298.948,-4308.7837,-4309.8076,-4280.8887,-4233.63,-4233.0786,-4226.947,-4262.8735,-4244.8486,-4191.281,-4216.516,-4225.6963,-4199.519,-4174.515,-4153.4854,-4131.368,-4108.1387,-3984.8225,-3987.0557,-3999.6223,-3964.0776,-3953.028,-3927.6477,-3898.1956,-3912.0059,-3868.9392,-3865.3076,-3883.1675,-3888.068,-3916.5303,-3902.842,-3925.1997,-3946.5327,-3960.7964,-4834.7944,-4804.3486,-4768.6196,-4750.9946,-4731.5215,-4692.7314,-4645.815,-4617.3037,-4612.3745,-4581.2437,-4555.261,-4558.4565,-4519.219,-4487.832,-4472.087,-4461.163,-4453.3345,-4431.6196,-4408.771,-4386.837,-4391.1904,-4372.32,-4334.7256,-4332.0356,-4350.3965,-4352.3853,-4321.6616,-4270.989,-4358.633,-4293.941,-4336.693,-4364.2705,-4351.7534,-4323.8936,-4284.844,-4279.6714,-4267.065,-4252.421,-4281.3555,-4262.9404,-4248.785,-4267.82,-4267.1973,-4253.3135,-4224.2803,-4215.8125,-4187.6934,-4143.4478,-4092.934,-4067.6702,-4037.3074,-4010.4036,-3966.8347,-3947.099,-3919.7798,-3908.3152,-3902.49,-3877.0217,-3879.9568,-3903.7986,-3908.882,-3905.7795,-3923.4414,-3947.058,-4841.8228,-4808.386,-4781.4365,-4771.788,-4744.841,-4706.021,-4680.219,-4659.951,-4643.5737,-4616.3706,-4594.8535,-4568.428,-4552.207,-4527.662,-4501.6367,-4472.9785,-4473.7407,-4451.339,-4423.0366,-4396.91,-4403.2983,-4394.679,-4382.61,-4385.568,-4369.9805,-4363.299,-4357.7935,-4317.4995,-4360.668,-4317.5225,-4360.1616,-4371.7427,-4370.649,-4375.543,-4355.2007,-4352.6323,-4322.3955,-4288.426,-4295.62,-4314.337,-4298.8374,-4275.0996,-4261.0415,-4267.7485,-4260.7427,-4231.9688,-4209.683,-4192.0947,-4162.428,-4130.54,-4111.884,-4094.7712,-4074.3123,-4035.901,-4008.4565,-3975.9934,-3961.094,-3931.0293,-3911.5579,-3913.7812,-3905.7773,-3905.832,-3911.7092,-3932.7742,-4824.1665,-4796.1763,-4789.891,-4765.7812,-4742.7285,-4721.4795,-4709.0083,-4676.914,-4634.0405,-4615.9146,-4614.6924,-4607.4336,-4590.2524,-4576.8564,-4551.788,-4531.934,-4525.7925,-4514.5503,-4488.4863,-4454.3936,-4452.448,-4465.651,-4468.5454,-4453.4067,-4428.5703,-4425.52,-4429.778,-4427.621,-4403.8394,-4379.9404,-4368.835,-4385.829,-4380.3584,-4391.3203,-4401.361,-4386.5586,-4367.2144,-4339.414,-4335.012,-4343.8325,-4328.9805,-4302.356,-4260.194,-4261.374,-4278.235,-4267.383,-4242.821,-4224.4478,-4200.1567,-4170.464,-4166.2627,-4151.808,-4140.322,-4118.6733,-4099.4165,-4082.277,-4050.9255,-4026.2278,-3996.6938,-3981.7124,-3961.6128,-3949.2783,-3922.6946,-3926.388,-4838.4224,-4806.59,-4766.0146,-4734.7324,-4734.5215,-4738.94,-4724.3184,-4696.756,-4678.1294,-4653.8447,-4632.1777,-4626.2725,-4612.3467,-4592.0854,-4557.0527,-4531.496,-4515.336,-4512.598,-4509.94,-4516.23,-4512.768,-4503.439,-4498.3813,-4490.9604,-4475.0884,-4460.756,-4445.5654,-4454.6885,-4441.2983,-4426.484,-4401.6064,-4401.839,-4416.0347,-4412.204,-4406.9365,-4397.8745,-4393.784,-4390.06,-4395.2725,-4377.297,-4355.1924,-4346.821,-4297.907,-4291.281,-4312.0264,-4276.647,-4252.82,-4250.32,-4239.973,-4227.615,-4207.505,-4194.0806,-4186.3877,-4177.4814,-4157.365,-4133.627,-4128.0405,-4106.4854,-4095.4355,-4076.1736,-4048.7114,-4042.548,-4020.9333,-3996.809,-4796.383,-4774.46,-4764.9204,-4768.561,-4756.735,-4743.065,-4716.7227,-4697.5303,-4681.586,-4674.963,-4667.0566,-4650.457,-4635.5474,-4618.2324,-4595.9556,-4572.809,-4550.1055,-4533.619,-4506.62,-4486.769,-4494.011,-4506.819,-4496.7,-4498.4087,-4493.8726,-4487.6777,-4489.1514,-4468.4443,-4470.827,-4464.9126,-4458.9204,-4453.0557,-4449.6,-4441.8887,-4430.452,-4434.3213,-4423.4316,-4397.807,-4366.1753,-4342.5254,-4339.9307,-4339.504,-4363.2637,-4338.3247,-4315.027,-4306.0986,-4296.735,-4285.181,-4260.2617,-4249.281,-4250.2944,-4255.9463,-4249.3574,-4233.3843,-4227.215,-4218.3237,-4203.775,-4175.069,-4153.2876,-4134.499,-4121.876,-4109.1763,-4098.0977,-4076.8577,-4842.8096,-4800.742,-4780.2285,-4755.058,-4747.654,-4737.5103,-4713.978,-4678.27,-4659.4727,-4663.5312,-4664.714,-4647.4365,-4633.7305,-4620.4253,-4612.166,-4586.5815,-4577.061,-4571.3037,-4552.3696,-4524.3423,-4525.0127,-4534.3955,-4521.9277,-4507.0728,-4495.24,-4485.867,-4477.638,-4477.613,-4468.6885,-4483.6895,-4483.6763,-4483.509,-4481.5815,-4473.144,-4469.9937,-4471.666,-4468.131,-4456.67,-4441.183,-4409.3735,-4370.6113,-4349.435,-4353.38,-4375.2896,-4383.7773,-4373.155,-4357.1406,-4328.5776,-4312.766,-4303.9556,-4281.1914,-4261.6216,-4267.594,-4263.1797,-4252.8394,-4236.7886,-4230.635,-4218.0767,-4198.4224,-4189.5576,-4174.7896,-4171.2505,-4172.202,-4167.7603,-4826.849,-4798.0273,-4784.6533,-4767.6523,-4750.6704,-4731.26,-4723.3433,-4704.1187,-4687.3706,-4660.49,-4647.417,-4633.3984,-4620.681,-4610.7754,-4613.8916,-4609.061,-4591.21,-4581.488,-4568.717,-4556.7046,-4560.0923,-4558.5356,-4555.7017,-4545.3984,-4526.4565,-4496.1973,-4496.6484,-4509.6865,-4510.7856,-4515.264,-4514.9697,-4508.9194,-4508.215,-4502.2554,-4482.2217,-4479.792,-4476.553,-4466.121,-4464.908,-4451.0054,-4419.1294,-4392.9727,-4396.3164,-4399.544,-4394.464,-4381.6465,-4410.2,-4406.29,-4392.062,-4373.6196,-4342.367,-4318.001,-4323.526,-4314.591,-4292.823,-4252.392,-4292.7075,-4289.697,-4279.335,-4261.6636,-4241.0947,-4241.5415,-4228.081,-4219.5625,-4835.8423,-4818.242,-4816.6006,-4795.599,-4759.74,-4739.288,-4733.8745,-4739.2573,-4736.9404,-4759.12,-4751.6826,-4676.893,-4650.715,-4633.9995,-4628.9736,-4615.6406,-4607.175,-4605.2075,-4596.37,-4584.795,-4582.014,-4570.9473,-4565.477,-4568.8433,-4557.5376,-4548.082,-4562.2915,-4571.4175,-4565.1577,-4555.111,-4539.9756,-4531.8223,-4529.019,-4516.243,-4507.582,-4498.7427,-4495.1787,-4484.798,-4478.2407,-4475.109,-4433.288,-4439.876,-4444.522,-4444.8843,-4430.5513,-4413.5,-4397.517,-4432.3257,-4440.9155,-4433.816,-4425.51,-4409.177,-4389.705,-4384.2925,-4362.688,-4344.3765,-4331.154,-4328.0,-4317.872,-4325.005,-4323.7427,-4313.129,-4289.4004,-4252.368,-4847.222,-4832.5327,-4825.782,-4800.176,-4757.5664,-4731.522,-4718.8125,-4717.785,-4724.0645,-4722.7573,-4726.1426,-4709.704,-4695.477,-4680.2812,-4669.932,-4659.0503,-4649.33,-4639.195,-4626.7993,-4628.658,-4625.966,-4621.0713,-4612.0947,-4598.0605,-4595.15,-4597.638,-4596.536,-4586.13,-4581.1255,-4567.366,-4566.484,-4551.7256,-4525.9575,-4517.8447,-4517.4785,-4508.438,-4501.6733,-4505.161,-4504.063,-4497.939,-4482.1953,-4460.75,-4446.753,-4447.987,-4448.391,-4453.996,-4461.091,-4465.7236,-4472.053,-4468.5684,-4467.3276,-4464.449,-4451.4263,-4442.314,-4425.225,-4405.2314,-4412.8477,-4399.343,-4385.7954,-4382.6177,-4372.332,-4338.993,-4281.387,-4251.122,-4620.8853,-4604.192,-4659.8706,-4668.348,-4537.71,-4524.767,-4591.7754,-4596.1377,-4531.725,-4580.029,-4640.992,-4616.481,-4518.3755,-4628.7188,-4670.3247,-4602.163,-4606.4683,-4647.6494,-4650.202,-4624.4473,-4632.5903,-4647.4795,-4641.0244,-4637.6147,-4630.507,-4627.6577,-4617.9688,-4605.94,-4583.1074,-4581.334,-4583.489,-4580.7124,-4576.6772,-4561.806,-4548.514,-4536.0854,-4534.1504,-4519.4844,-4517.7793,-4520.047,-4507.3916,-4487.262,-4471.2817,-4487.0923,-4493.6562,-4493.7065,-4479.7617,-4457.4634,-4465.0737,-4466.133,-4474.984,-4485.2954,-4466.124,-4442.8267,-4457.593,-4471.388,-4468.937,-4458.9863,-4459.239,-4451.876,-4438.183,-4429.1704,-4431.632,-4432.956,-3703.8372,-3768.593,-3865.8474,-3877.7903,-3788.3127,-3778.044,-3817.0723,-3786.2415,-3830.5522,-3816.617,-3819.548,-3897.5527,-3893.8994,-3716.2314,-3715.6875,-3767.1934,-3850.9531,-3964.8193,-4057.3916,-4171.808,-4136.9927,-4200.5586,-4308.1294,-4322.0444,-4345.97,-4364.301,-4409.7197,-4470.126,-4483.0034,-4468.719,-4473.5034,-4480.917,-4495.079,-4500.6216,-4474.3804,-4470.6396,-4477.609,-4469.283,-4436.5894,-4468.7773,-4495.2017,-4406.252,-4314.8413,-4323.4746,-4297.1704,-4352.8735,-4384.063,-4388.863,-4405.9624,-4434.988,-4440.441,-4417.1475,-4398.3647,-4419.404,-4444.004,-4446.179,-4427.341,-4424.494,-4428.141,-4437.5474,-4442.3604,-4450.8823,-4463.504,-4463.8213,-3317.7197,-3362.7039,-3347.3337,-3281.6873,-3252.808,-3247.1985,-3290.0994,-3258.7942,-3270.803,-3236.9133,-3197.683,-3176.2349,-3175.0437,-3190.024,-3261.978,-3226.119,-3256.1233,-3408.2637,-3412.526,-3392.8289,-3328.0781,-3349.8445,-3442.708,-3446.0725,-3451.8518,-3466.9863,-3683.9773,-3901.7732,-3922.168,-3834.887,-3796.365,-3792.1455,-3913.4426,-4149.2183,-4091.5474,-4180.0493,-4152.6343,-4026.575,-3967.104,-3982.1064,-3976.8623,-3963.5552,-3972.6462,-4014.4377,-3987.9248,-4051.9604,-4054.5935,-4042.6099,-4106.5454,-4127.254,-4090.4578,-4062.4983,-4179.4062,-4079.5842,-4014.0889,-4035.8203,-4094.8206,-4094.9417,-4103.004,-4132.5347,-4152.2163,-4189.946,-4219.6133,-4227.2583,-3294.6736,-3290.366,-3285.5823,-3275.3682,-3258.4314,-3241.7373,-3222.9358,-3204.2349,-3185.2368,-3167.156,-3154.3123,-3148.5146,-3133.9995,-3120.1538,-3106.679,-3092.5793,-3077.692,-3063.838,-3054.5515,-3055.3848,-3045.0842,-3043.888,-3060.8696,-3046.6597,-3073.8984,-3087.7957,-3114.702,-3178.1807,-3246.5833,-3299.9966,-3363.1929,-3422.5566,-3439.857,-3484.4102,-3505.5205,-3495.978,-3534.6401,-3556.2732,-3580.6274,-3607.3655,-3606.7537,-3560.2195,-3539.3445,-3584.1377,-3605.5437,-3539.806,-3520.3506,-3533.181,-3593.008,-3660.8755,-3607.241,-3541.5737,-3601.8657,-3605.077,-3568.8357,-3549.7642,-3534.4436,-3558.0396,-3577.3313,-3583.0642,-3604.4705,-3614.4294,-3588.7712,-3608.746,-4096.6914,-4198.117,-4078.5928,-3770.918,-3652.2617,-3576.4216,-3513.3452,-3477.1643,-3426.991,-3387.2278,-3383.7385,-3384.643,-3334.3523,-3248.1733,-3204.7664,-3178.061,-3158.2417,-3137.155,-3116.5444,-3100.6824,-3083.6128,-3065.705,-3050.5127,-3036.1553,-3021.612,-3008.944,-3000.3958,-2997.4993,-3000.1213,-3009.4402,-3023.1978,-3038.681,-3053.3848,-3068.3674,-3085.554,-3101.3613,-3116.5425,-3130.9128,-3142.013,-3150.0598,-3158.1646,-3168.5574,-3180.133,-3190.6567,-3202.747,-3213.5645,-3222.63,-3226.7607,-3224.1963,-3207.9375,-3189.3633,-3188.4,-3204.8147,-3210.043,-3201.6646,-3195.6575,-3204.4895,-3212.4575,-3208.903,-3212.2798,-3215.575,-3217.621,-3223.385,-3225.4832,-3334.3418,-3314.6338,-3279.0095,-3236.6208,-3192.744,-3153.2463,-3126.5676,-3106.599,-3089.1074,-3076.6301,-3059.707,-3040.2537,-3025.5522,-3013.3118,-3009.6018,-3009.8743,-3001.4846,-2992.3867,-2979.508,-2958.732,-2945.2239,-2938.226,-2924.7532,-2913.1147,-2900.5396,-2884.3125,-2866.8591,-2851.0024,-2840.4937,-2836.2227,-2837.1035,-2844.3984,-2854.3252,-2864.2559,-2874.9844,-2887.8857,-2893.2087,-2894.5322,-2895.0754,-2898.448,-2902.627,-2904.6687,-2907.3486,-2913.037,-2918.7097,-2919.871,-2919.6257,-2909.8772,-2900.4895,-2905.6892,-2917.5198,-2923.6074,-2933.2703,-2947.907,-2980.957,-2989.8477,-2968.0715,-2958.2156,-2960.3577,-2969.797,-2981.7239,-2991.4434,-2992.447,-2975.6106,-2895.0422,-2864.7349,-2847.1777,-2794.614,-2785.7146,-2753.9497,-2741.4185,-2739.242,-2737.354,-2729.1938,-2734.3145,-2726.3835,-2720.9255,-2747.663,-2750.7183,-2710.1184,-2662.6921,-2636.6287,-2643.6594,-2651.2864,-2612.6277,-2602.5715,-2604.9583,-2603.1418,-2595.7017,-2593.3088,-2586.714,-2579.2458,-2570.808,-2570.343,-2577.382,-2557.1157,-2540.2612,-2521.7356,-2507.2983,-2503.3003,-2501.1177,-2514.0503,-2532.5266,-2548.1687,-2575.2249,-2594.0852,-2627.1257,-2625.6548,-2608.1318,-2640.1252,-2641.146,-2623.4978,-2636.3784,-2649.672,-2670.0098,-2672.0984,-2647.8032,-2635.2803,-2618.911,-2633.6096,-2646.0906,-2655.7666,-2635.4592,-2618.4978,-2604.5264,-2604.281,-2599.235,-2597.134,-2492.2825,-2455.5679,-2404.4392,-2390.9365,-2392.7898,-2388.3257,-2394.6345,-2388.5642,-2382.4312,-2372.9353,-2369.279,-2365.1187,-2370.9795,-2395.401,-2403.0454,-2376.4097,-2353.8289,-2349.1304,-2362.1377,-2346.0354,-2308.4924,-2298.6223,-2295.027,-2297.9456,-2302.198,-2297.3743,-2289.8838,-2280.1416,-2311.797,-2345.9731,-2337.0598,-2267.305,-2238.014,-2221.3608,-2212.6428,-2214.158,-2213.551,-2213.8503,-2215.1018,-2215.5981,-2224.9033,-2229.6716,-2237.432,-2221.5735,-2192.256,-2190.4568,-2191.6748,-2199.3877,-2259.0042,-2289.8665,-2291.228,-2243.1875,-2218.5984,-2210.0837,-2177.5408,-2179.2927,-2178.443,-2183.2368,-2176.8015,-2176.4236,-2177.0732,-2170.921,-2148.8271,-2130.4001],solid=False,xDimension=64,xSpacing=1.428571,yScale=50.0,zDimension=64,zSpacing=1.428571,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.01587,0.00391),(0.03175,0.00391),(0.04762,0.00391),(0.06349,0.00391),(0.07937,0.00391),(0.09524,0.00391),(0.11111,0.00391),(0.12698,0.00391),(0.14286,0.00391),(0.15873,0.00391),(0.1746,0.00391),(0.19048,0.00391),(0.20635,0.00391),(0.22222,0.00391),(0.2381,0.00391),(0.25397,0.00391),(0.26984,0.00391),(0.28571,0.00391),(0.30159,0.00391),(0.31746,0.00391),(0.33333,0.00391),(0.34921,0.00391),(0.36508,0.00391),(0.38095,0.00391),(0.39683,0.00391),(0.4127,0.00391),(0.42857,0.00391),(0.44444,0.00391),(0.46032,0.00391),(0.47619,0.00391),(0.49206,0.00391),(0.50794,0.00391),(0.52381,0.00391),(0.53968,0.00391),(0.55556,0.00391),(0.57143,0.00391),(0.5873,0.00391),(0.60317,0.00391),(0.61905,0.00391),(0.63492,0.00391),(0.65079,0.00391),(0.66667,0.00391),(0.68254,0.00391),(0.69841,0.00391),(0.71429,0.00391),(0.73016,0.00391),(0.74603,0.00391),(0.7619,0.00391),(0.77778,0.00391),(0.79365,0.00391),(0.80952,0.00391),(0.8254,0.00391),(0.84127,0.00391),(0.85714,0.00391),(0.87302,0.00391),(0.88889,0.00391),(0.90476,0.00391),(0.92063,0.00391),(0.93651,0.00391),(0.95238,0.00391),(0.96825,0.00391),(0.98413,0.00391),(0.99609,0.00391),(0.00391,0.01587),(0.01587,0.01587),(0.03175,0.01587),(0.04762,0.01587),(0.06349,0.01587),(0.07937,0.01587),(0.09524,0.01587),(0.11111,0.01587),(0.12698,0.01587),(0.14286,0.01587),(0.15873,0.01587),(0.1746,0.01587),(0.19048,0.01587),(0.20635,0.01587),(0.22222,0.01587),(0.2381,0.01587),(0.25397,0.01587),(0.26984,0.01587),(0.28571,0.01587),(0.30159,0.01587),(0.31746,0.01587),(0.33333,0.01587),(0.34921,0.01587),(0.36508,0.01587),(0.38095,0.01587),(0.39683,0.01587),(0.4127,0.01587),(0.42857,0.01587),(0.44444,0.01587),(0.46032,0.01587),(0.47619,0.01587),(0.49206,0.01587),(0.50794,0.01587),(0.52381,0.01587),(0.53968,0.01587),(0.55556,0.01587),(0.57143,0.01587),(0.5873,0.01587),(0.60317,0.01587),(0.61905,0.01587),(0.63492,0.01587),(0.65079,0.01587),(0.66667,0.01587),(0.68254,0.01587),(0.69841,0.01587),(0.71429,0.01587),(0.73016,0.01587),(0.74603,0.01587),(0.7619,0.01587),(0.77778,0.01587),(0.79365,0.01587),(0.80952,0.01587),(0.8254,0.01587),(0.84127,0.01587),(0.85714,0.01587),(0.87302,0.01587),(0.88889,0.01587),(0.90476,0.01587),(0.92063,0.01587),(0.93651,0.01587),(0.95238,0.01587),(0.96825,0.01587),(0.98413,0.01587),(0.99609,0.01587),(0.00391,0.03175),(0.01587,0.03175),(0.03175,0.03175),(0.04762,0.03175),(0.06349,0.03175),(0.07937,0.03175),(0.09524,0.03175),(0.11111,0.03175),(0.12698,0.03175),(0.14286,0.03175),(0.15873,0.03175),(0.1746,0.03175),(0.19048,0.03175),(0.20635,0.03175),(0.22222,0.03175),(0.2381,0.03175),(0.25397,0.03175),(0.26984,0.03175),(0.28571,0.03175),(0.30159,0.03175),(0.31746,0.03175),(0.33333,0.03175),(0.34921,0.03175),(0.36508,0.03175),(0.38095,0.03175),(0.39683,0.03175),(0.4127,0.03175),(0.42857,0.03175),(0.44444,0.03175),(0.46032,0.03175),(0.47619,0.03175),(0.49206,0.03175),(0.50794,0.03175),(0.52381,0.03175),(0.53968,0.03175),(0.55556,0.03175),(0.57143,0.03175),(0.5873,0.03175),(0.60317,0.03175),(0.61905,0.03175),(0.63492,0.03175),(0.65079,0.03175),(0.66667,0.03175),(0.68254,0.03175),(0.69841,0.03175),(0.71429,0.03175),(0.73016,0.03175),(0.74603,0.03175),(0.7619,0.03175),(0.77778,0.03175),(0.79365,0.03175),(0.80952,0.03175),(0.8254,0.03175),(0.84127,0.03175),(0.85714,0.03175),(0.87302,0.03175),(0.88889,0.03175),(0.90476,0.03175),(0.92063,0.03175),(0.93651,0.03175),(0.95238,0.03175),(0.96825,0.03175),(0.98413,0.03175),(0.99609,0.03175),(0.00391,0.04762),(0.01587,0.04762),(0.03175,0.04762),(0.04762,0.04762),(0.06349,0.04762),(0.07937,0.04762),(0.09524,0.04762),(0.11111,0.04762),(0.12698,0.04762),(0.14286,0.04762),(0.15873,0.04762),(0.1746,0.04762),(0.19048,0.04762),(0.20635,0.04762),(0.22222,0.04762),(0.2381,0.04762),(0.25397,0.04762),(0.26984,0.04762),(0.28571,0.04762),(0.30159,0.04762),(0.31746,0.04762),(0.33333,0.04762),(0.34921,0.04762),(0.36508,0.04762),(0.38095,0.04762),(0.39683,0.04762),(0.4127,0.04762),(0.42857,0.04762),(0.44444,0.04762),(0.46032,0.04762),(0.47619,0.04762),(0.49206,0.04762),(0.50794,0.04762),(0.52381,0.04762),(0.53968,0.04762),(0.55556,0.04762),(0.57143,0.04762),(0.5873,0.04762),(0.60317,0.04762),(0.61905,0.04762),(0.63492,0.04762),(0.65079,0.04762),(0.66667,0.04762),(0.68254,0.04762),(0.69841,0.04762),(0.71429,0.04762),(0.73016,0.04762),(0.74603,0.04762),(0.7619,0.04762),(0.77778,0.04762),(0.79365,0.04762),(0.80952,0.04762),(0.8254,0.04762),(0.84127,0.04762),(0.85714,0.04762),(0.87302,0.04762),(0.88889,0.04762),(0.90476,0.04762),(0.92063,0.04762),(0.93651,0.04762),(0.95238,0.04762),(0.96825,0.04762),(0.98413,0.04762),(0.99609,0.04762),(0.00391,0.06349),(0.01587,0.06349),(0.03175,0.06349),(0.04762,0.06349),(0.06349,0.06349),(0.07937,0.06349),(0.09524,0.06349),(0.11111,0.06349),(0.12698,0.06349),(0.14286,0.06349),(0.15873,0.06349),(0.1746,0.06349),(0.19048,0.06349),(0.20635,0.06349),(0.22222,0.06349),(0.2381,0.06349),(0.25397,0.06349),(0.26984,0.06349),(0.28571,0.06349),(0.30159,0.06349),(0.31746,0.06349),(0.33333,0.06349),(0.34921,0.06349),(0.36508,0.06349),(0.38095,0.06349),(0.39683,0.06349),(0.4127,0.06349),(0.42857,0.06349),(0.44444,0.06349),(0.46032,0.06349),(0.47619,0.06349),(0.49206,0.06349),(0.50794,0.06349),(0.52381,0.06349),(0.53968,0.06349),(0.55556,0.06349),(0.57143,0.06349),(0.5873,0.06349),(0.60317,0.06349),(0.61905,0.06349),(0.63492,0.06349),(0.65079,0.06349),(0.66667,0.06349),(0.68254,0.06349),(0.69841,0.06349),(0.71429,0.06349),(0.73016,0.06349),(0.74603,0.06349),(0.7619,0.06349),(0.77778,0.06349),(0.79365,0.06349),(0.80952,0.06349),(0.8254,0.06349),(0.84127,0.06349),(0.85714,0.06349),(0.87302,0.06349),(0.88889,0.06349),(0.90476,0.06349),(0.92063,0.06349),(0.93651,0.06349),(0.95238,0.06349),(0.96825,0.06349),(0.98413,0.06349),(0.99609,0.06349),(0.00391,0.07937),(0.01587,0.07937),(0.03175,0.07937),(0.04762,0.07937),(0.06349,0.07937),(0.07937,0.07937),(0.09524,0.07937),(0.11111,0.07937),(0.12698,0.07937),(0.14286,0.07937),(0.15873,0.07937),(0.1746,0.07937),(0.19048,0.07937),(0.20635,0.07937),(0.22222,0.07937),(0.2381,0.07937),(0.25397,0.07937),(0.26984,0.07937),(0.28571,0.07937),(0.30159,0.07937),(0.31746,0.07937),(0.33333,0.07937),(0.34921,0.07937),(0.36508,0.07937),(0.38095,0.07937),(0.39683,0.07937),(0.4127,0.07937),(0.42857,0.07937),(0.44444,0.07937),(0.46032,0.07937),(0.47619,0.07937),(0.49206,0.07937),(0.50794,0.07937),(0.52381,0.07937),(0.53968,0.07937),(0.55556,0.07937),(0.57143,0.07937),(0.5873,0.07937),(0.60317,0.07937),(0.61905,0.07937),(0.63492,0.07937),(0.65079,0.07937),(0.66667,0.07937),(0.68254,0.07937),(0.69841,0.07937),(0.71429,0.07937),(0.73016,0.07937),(0.74603,0.07937),(0.7619,0.07937),(0.77778,0.07937),(0.79365,0.07937),(0.80952,0.07937),(0.8254,0.07937),(0.84127,0.07937),(0.85714,0.07937),(0.87302,0.07937),(0.88889,0.07937),(0.90476,0.07937),(0.92063,0.07937),(0.93651,0.07937),(0.95238,0.07937),(0.96825,0.07937),(0.98413,0.07937),(0.99609,0.07937),(0.00391,0.09524),(0.01587,0.09524),(0.03175,0.09524),(0.04762,0.09524),(0.06349,0.09524),(0.07937,0.09524),(0.09524,0.09524),(0.11111,0.09524),(0.12698,0.09524),(0.14286,0.09524),(0.15873,0.09524),(0.1746,0.09524),(0.19048,0.09524),(0.20635,0.09524),(0.22222,0.09524),(0.2381,0.09524),(0.25397,0.09524),(0.26984,0.09524),(0.28571,0.09524),(0.30159,0.09524),(0.31746,0.09524),(0.33333,0.09524),(0.34921,0.09524),(0.36508,0.09524),(0.38095,0.09524),(0.39683,0.09524),(0.4127,0.09524),(0.42857,0.09524),(0.44444,0.09524),(0.46032,0.09524),(0.47619,0.09524),(0.49206,0.09524),(0.50794,0.09524),(0.52381,0.09524),(0.53968,0.09524),(0.55556,0.09524),(0.57143,0.09524),(0.5873,0.09524),(0.60317,0.09524),(0.61905,0.09524),(0.63492,0.09524),(0.65079,0.09524),(0.66667,0.09524),(0.68254,0.09524),(0.69841,0.09524),(0.71429,0.09524),(0.73016,0.09524),(0.74603,0.09524),(0.7619,0.09524),(0.77778,0.09524),(0.79365,0.09524),(0.80952,0.09524),(0.8254,0.09524),(0.84127,0.09524),(0.85714,0.09524),(0.87302,0.09524),(0.88889,0.09524),(0.90476,0.09524),(0.92063,0.09524),(0.93651,0.09524),(0.95238,0.09524),(0.96825,0.09524),(0.98413,0.09524),(0.99609,0.09524),(0.00391,0.11111),(0.01587,0.11111),(0.03175,0.11111),(0.04762,0.11111),(0.06349,0.11111),(0.07937,0.11111),(0.09524,0.11111),(0.11111,0.11111),(0.12698,0.11111),(0.14286,0.11111),(0.15873,0.11111),(0.1746,0.11111),(0.19048,0.11111),(0.20635,0.11111),(0.22222,0.11111),(0.2381,0.11111),(0.25397,0.11111),(0.26984,0.11111),(0.28571,0.11111),(0.30159,0.11111),(0.31746,0.11111),(0.33333,0.11111),(0.34921,0.11111),(0.36508,0.11111),(0.38095,0.11111),(0.39683,0.11111),(0.4127,0.11111),(0.42857,0.11111),(0.44444,0.11111),(0.46032,0.11111),(0.47619,0.11111),(0.49206,0.11111),(0.50794,0.11111),(0.52381,0.11111),(0.53968,0.11111),(0.55556,0.11111),(0.57143,0.11111),(0.5873,0.11111),(0.60317,0.11111),(0.61905,0.11111),(0.63492,0.11111),(0.65079,0.11111),(0.66667,0.11111),(0.68254,0.11111),(0.69841,0.11111),(0.71429,0.11111),(0.73016,0.11111),(0.74603,0.11111),(0.7619,0.11111),(0.77778,0.11111),(0.79365,0.11111),(0.80952,0.11111),(0.8254,0.11111),(0.84127,0.11111),(0.85714,0.11111),(0.87302,0.11111),(0.88889,0.11111),(0.90476,0.11111),(0.92063,0.11111),(0.93651,0.11111),(0.95238,0.11111),(0.96825,0.11111),(0.98413,0.11111),(0.99609,0.11111),(0.00391,0.12698),(0.01587,0.12698),(0.03175,0.12698),(0.04762,0.12698),(0.06349,0.12698),(0.07937,0.12698),(0.09524,0.12698),(0.11111,0.12698),(0.12698,0.12698),(0.14286,0.12698),(0.15873,0.12698),(0.1746,0.12698),(0.19048,0.12698),(0.20635,0.12698),(0.22222,0.12698),(0.2381,0.12698),(0.25397,0.12698),(0.26984,0.12698),(0.28571,0.12698),(0.30159,0.12698),(0.31746,0.12698),(0.33333,0.12698),(0.34921,0.12698),(0.36508,0.12698),(0.38095,0.12698),(0.39683,0.12698),(0.4127,0.12698),(0.42857,0.12698),(0.44444,0.12698),(0.46032,0.12698),(0.47619,0.12698),(0.49206,0.12698),(0.50794,0.12698),(0.52381,0.12698),(0.53968,0.12698),(0.55556,0.12698),(0.57143,0.12698),(0.5873,0.12698),(0.60317,0.12698),(0.61905,0.12698),(0.63492,0.12698),(0.65079,0.12698),(0.66667,0.12698),(0.68254,0.12698),(0.69841,0.12698),(0.71429,0.12698),(0.73016,0.12698),(0.74603,0.12698),(0.7619,0.12698),(0.77778,0.12698),(0.79365,0.12698),(0.80952,0.12698),(0.8254,0.12698),(0.84127,0.12698),(0.85714,0.12698),(0.87302,0.12698),(0.88889,0.12698),(0.90476,0.12698),(0.92063,0.12698),(0.93651,0.12698),(0.95238,0.12698),(0.96825,0.12698),(0.98413,0.12698),(0.99609,0.12698),(0.00391,0.14286),(0.01587,0.14286),(0.03175,0.14286),(0.04762,0.14286),(0.06349,0.14286),(0.07937,0.14286),(0.09524,0.14286),(0.11111,0.14286),(0.12698,0.14286),(0.14286,0.14286),(0.15873,0.14286),(0.1746,0.14286),(0.19048,0.14286),(0.20635,0.14286),(0.22222,0.14286),(0.2381,0.14286),(0.25397,0.14286),(0.26984,0.14286),(0.28571,0.14286),(0.30159,0.14286),(0.31746,0.14286),(0.33333,0.14286),(0.34921,0.14286),(0.36508,0.14286),(0.38095,0.14286),(0.39683,0.14286),(0.4127,0.14286),(0.42857,0.14286),(0.44444,0.14286),(0.46032,0.14286),(0.47619,0.14286),(0.49206,0.14286),(0.50794,0.14286),(0.52381,0.14286),(0.53968,0.14286),(0.55556,0.14286),(0.57143,0.14286),(0.5873,0.14286),(0.60317,0.14286),(0.61905,0.14286),(0.63492,0.14286),(0.65079,0.14286),(0.66667,0.14286),(0.68254,0.14286),(0.69841,0.14286),(0.71429,0.14286),(0.73016,0.14286),(0.74603,0.14286),(0.7619,0.14286),(0.77778,0.14286),(0.79365,0.14286),(0.80952,0.14286),(0.8254,0.14286),(0.84127,0.14286),(0.85714,0.14286),(0.87302,0.14286),(0.88889,0.14286),(0.90476,0.14286),(0.92063,0.14286),(0.93651,0.14286),(0.95238,0.14286),(0.96825,0.14286),(0.98413,0.14286),(0.99609,0.14286),(0.00391,0.15873),(0.01587,0.15873),(0.03175,0.15873),(0.04762,0.15873),(0.06349,0.15873),(0.07937,0.15873),(0.09524,0.15873),(0.11111,0.15873),(0.12698,0.15873),(0.14286,0.15873),(0.15873,0.15873),(0.1746,0.15873),(0.19048,0.15873),(0.20635,0.15873),(0.22222,0.15873),(0.2381,0.15873),(0.25397,0.15873),(0.26984,0.15873),(0.28571,0.15873),(0.30159,0.15873),(0.31746,0.15873),(0.33333,0.15873),(0.34921,0.15873),(0.36508,0.15873),(0.38095,0.15873),(0.39683,0.15873),(0.4127,0.15873),(0.42857,0.15873),(0.44444,0.15873),(0.46032,0.15873),(0.47619,0.15873),(0.49206,0.15873),(0.50794,0.15873),(0.52381,0.15873),(0.53968,0.15873),(0.55556,0.15873),(0.57143,0.15873),(0.5873,0.15873),(0.60317,0.15873),(0.61905,0.15873),(0.63492,0.15873),(0.65079,0.15873),(0.66667,0.15873),(0.68254,0.15873),(0.69841,0.15873),(0.71429,0.15873),(0.73016,0.15873),(0.74603,0.15873),(0.7619,0.15873),(0.77778,0.15873),(0.79365,0.15873),(0.80952,0.15873),(0.8254,0.15873),(0.84127,0.15873),(0.85714,0.15873),(0.87302,0.15873),(0.88889,0.15873),(0.90476,0.15873),(0.92063,0.15873),(0.93651,0.15873),(0.95238,0.15873),(0.96825,0.15873),(0.98413,0.15873),(0.99609,0.15873),(0.00391,0.1746),(0.01587,0.1746),(0.03175,0.1746),(0.04762,0.1746),(0.06349,0.1746),(0.07937,0.1746),(0.09524,0.1746),(0.11111,0.1746),(0.12698,0.1746),(0.14286,0.1746),(0.15873,0.1746),(0.1746,0.1746),(0.19048,0.1746),(0.20635,0.1746),(0.22222,0.1746),(0.2381,0.1746),(0.25397,0.1746),(0.26984,0.1746),(0.28571,0.1746),(0.30159,0.1746),(0.31746,0.1746),(0.33333,0.1746),(0.34921,0.1746),(0.36508,0.1746),(0.38095,0.1746),(0.39683,0.1746),(0.4127,0.1746),(0.42857,0.1746),(0.44444,0.1746),(0.46032,0.1746),(0.47619,0.1746),(0.49206,0.1746),(0.50794,0.1746),(0.52381,0.1746),(0.53968,0.1746),(0.55556,0.1746),(0.57143,0.1746),(0.5873,0.1746),(0.60317,0.1746),(0.61905,0.1746),(0.63492,0.1746),(0.65079,0.1746),(0.66667,0.1746),(0.68254,0.1746),(0.69841,0.1746),(0.71429,0.1746),(0.73016,0.1746),(0.74603,0.1746),(0.7619,0.1746),(0.77778,0.1746),(0.79365,0.1746),(0.80952,0.1746),(0.8254,0.1746),(0.84127,0.1746),(0.85714,0.1746),(0.87302,0.1746),(0.88889,0.1746),(0.90476,0.1746),(0.92063,0.1746),(0.93651,0.1746),(0.95238,0.1746),(0.96825,0.1746),(0.98413,0.1746),(0.99609,0.1746),(0.00391,0.19048),(0.01587,0.19048),(0.03175,0.19048),(0.04762,0.19048),(0.06349,0.19048),(0.07937,0.19048),(0.09524,0.19048),(0.11111,0.19048),(0.12698,0.19048),(0.14286,0.19048),(0.15873,0.19048),(0.1746,0.19048),(0.19048,0.19048),(0.20635,0.19048),(0.22222,0.19048),(0.2381,0.19048),(0.25397,0.19048),(0.26984,0.19048),(0.28571,0.19048),(0.30159,0.19048),(0.31746,0.19048),(0.33333,0.19048),(0.34921,0.19048),(0.36508,0.19048),(0.38095,0.19048),(0.39683,0.19048),(0.4127,0.19048),(0.42857,0.19048),(0.44444,0.19048),(0.46032,0.19048),(0.47619,0.19048),(0.49206,0.19048),(0.50794,0.19048),(0.52381,0.19048),(0.53968,0.19048),(0.55556,0.19048),(0.57143,0.19048),(0.5873,0.19048),(0.60317,0.19048),(0.61905,0.19048),(0.63492,0.19048),(0.65079,0.19048),(0.66667,0.19048),(0.68254,0.19048),(0.69841,0.19048),(0.71429,0.19048),(0.73016,0.19048),(0.74603,0.19048),(0.7619,0.19048),(0.77778,0.19048),(0.79365,0.19048),(0.80952,0.19048),(0.8254,0.19048),(0.84127,0.19048),(0.85714,0.19048),(0.87302,0.19048),(0.88889,0.19048),(0.90476,0.19048),(0.92063,0.19048),(0.93651,0.19048),(0.95238,0.19048),(0.96825,0.19048),(0.98413,0.19048),(0.99609,0.19048),(0.00391,0.20635),(0.01587,0.20635),(0.03175,0.20635),(0.04762,0.20635),(0.06349,0.20635),(0.07937,0.20635),(0.09524,0.20635),(0.11111,0.20635),(0.12698,0.20635),(0.14286,0.20635),(0.15873,0.20635),(0.1746,0.20635),(0.19048,0.20635),(0.20635,0.20635),(0.22222,0.20635),(0.2381,0.20635),(0.25397,0.20635),(0.26984,0.20635),(0.28571,0.20635),(0.30159,0.20635),(0.31746,0.20635),(0.33333,0.20635),(0.34921,0.20635),(0.36508,0.20635),(0.38095,0.20635),(0.39683,0.20635),(0.4127,0.20635),(0.42857,0.20635),(0.44444,0.20635),(0.46032,0.20635),(0.47619,0.20635),(0.49206,0.20635),(0.50794,0.20635),(0.52381,0.20635),(0.53968,0.20635),(0.55556,0.20635),(0.57143,0.20635),(0.5873,0.20635),(0.60317,0.20635),(0.61905,0.20635),(0.63492,0.20635),(0.65079,0.20635),(0.66667,0.20635),(0.68254,0.20635),(0.69841,0.20635),(0.71429,0.20635),(0.73016,0.20635),(0.74603,0.20635),(0.7619,0.20635),(0.77778,0.20635),(0.79365,0.20635),(0.80952,0.20635),(0.8254,0.20635),(0.84127,0.20635),(0.85714,0.20635),(0.87302,0.20635),(0.88889,0.20635),(0.90476,0.20635),(0.92063,0.20635),(0.93651,0.20635),(0.95238,0.20635),(0.96825,0.20635),(0.98413,0.20635),(0.99609,0.20635),(0.00391,0.22222),(0.01587,0.22222),(0.03175,0.22222),(0.04762,0.22222),(0.06349,0.22222),(0.07937,0.22222),(0.09524,0.22222),(0.11111,0.22222),(0.12698,0.22222),(0.14286,0.22222),(0.15873,0.22222),(0.1746,0.22222),(0.19048,0.22222),(0.20635,0.22222),(0.22222,0.22222),(0.2381,0.22222),(0.25397,0.22222),(0.26984,0.22222),(0.28571,0.22222),(0.30159,0.22222),(0.31746,0.22222),(0.33333,0.22222),(0.34921,0.22222),(0.36508,0.22222),(0.38095,0.22222),(0.39683,0.22222),(0.4127,0.22222),(0.42857,0.22222),(0.44444,0.22222),(0.46032,0.22222),(0.47619,0.22222),(0.49206,0.22222),(0.50794,0.22222),(0.52381,0.22222),(0.53968,0.22222),(0.55556,0.22222),(0.57143,0.22222),(0.5873,0.22222),(0.60317,0.22222),(0.61905,0.22222),(0.63492,0.22222),(0.65079,0.22222),(0.66667,0.22222),(0.68254,0.22222),(0.69841,0.22222),(0.71429,0.22222),(0.73016,0.22222),(0.74603,0.22222),(0.7619,0.22222),(0.77778,0.22222),(0.79365,0.22222),(0.80952,0.22222),(0.8254,0.22222),(0.84127,0.22222),(0.85714,0.22222),(0.87302,0.22222),(0.88889,0.22222),(0.90476,0.22222),(0.92063,0.22222),(0.93651,0.22222),(0.95238,0.22222),(0.96825,0.22222),(0.98413,0.22222),(0.99609,0.22222),(0.00391,0.2381),(0.01587,0.2381),(0.03175,0.2381),(0.04762,0.2381),(0.06349,0.2381),(0.07937,0.2381),(0.09524,0.2381),(0.11111,0.2381),(0.12698,0.2381),(0.14286,0.2381),(0.15873,0.2381),(0.1746,0.2381),(0.19048,0.2381),(0.20635,0.2381),(0.22222,0.2381),(0.2381,0.2381),(0.25397,0.2381),(0.26984,0.2381),(0.28571,0.2381),(0.30159,0.2381),(0.31746,0.2381),(0.33333,0.2381),(0.34921,0.2381),(0.36508,0.2381),(0.38095,0.2381),(0.39683,0.2381),(0.4127,0.2381),(0.42857,0.2381),(0.44444,0.2381),(0.46032,0.2381),(0.47619,0.2381),(0.49206,0.2381),(0.50794,0.2381),(0.52381,0.2381),(0.53968,0.2381),(0.55556,0.2381),(0.57143,0.2381),(0.5873,0.2381),(0.60317,0.2381),(0.61905,0.2381),(0.63492,0.2381),(0.65079,0.2381),(0.66667,0.2381),(0.68254,0.2381),(0.69841,0.2381),(0.71429,0.2381),(0.73016,0.2381),(0.74603,0.2381),(0.7619,0.2381),(0.77778,0.2381),(0.79365,0.2381),(0.80952,0.2381),(0.8254,0.2381),(0.84127,0.2381),(0.85714,0.2381),(0.87302,0.2381),(0.88889,0.2381),(0.90476,0.2381),(0.92063,0.2381),(0.93651,0.2381),(0.95238,0.2381),(0.96825,0.2381),(0.98413,0.2381),(0.99609,0.2381),(0.00391,0.25397),(0.01587,0.25397),(0.03175,0.25397),(0.04762,0.25397),(0.06349,0.25397),(0.07937,0.25397),(0.09524,0.25397),(0.11111,0.25397),(0.12698,0.25397),(0.14286,0.25397),(0.15873,0.25397),(0.1746,0.25397),(0.19048,0.25397),(0.20635,0.25397),(0.22222,0.25397),(0.2381,0.25397),(0.25397,0.25397),(0.26984,0.25397),(0.28571,0.25397),(0.30159,0.25397),(0.31746,0.25397),(0.33333,0.25397),(0.34921,0.25397),(0.36508,0.25397),(0.38095,0.25397),(0.39683,0.25397),(0.4127,0.25397),(0.42857,0.25397),(0.44444,0.25397),(0.46032,0.25397),(0.47619,0.25397),(0.49206,0.25397),(0.50794,0.25397),(0.52381,0.25397),(0.53968,0.25397),(0.55556,0.25397),(0.57143,0.25397),(0.5873,0.25397),(0.60317,0.25397),(0.61905,0.25397),(0.63492,0.25397),(0.65079,0.25397),(0.66667,0.25397),(0.68254,0.25397),(0.69841,0.25397),(0.71429,0.25397),(0.73016,0.25397),(0.74603,0.25397),(0.7619,0.25397),(0.77778,0.25397),(0.79365,0.25397),(0.80952,0.25397),(0.8254,0.25397),(0.84127,0.25397),(0.85714,0.25397),(0.87302,0.25397),(0.88889,0.25397),(0.90476,0.25397),(0.92063,0.25397),(0.93651,0.25397),(0.95238,0.25397),(0.96825,0.25397),(0.98413,0.25397),(0.99609,0.25397),(0.00391,0.26984),(0.01587,0.26984),(0.03175,0.26984),(0.04762,0.26984),(0.06349,0.26984),(0.07937,0.26984),(0.09524,0.26984),(0.11111,0.26984),(0.12698,0.26984),(0.14286,0.26984),(0.15873,0.26984),(0.1746,0.26984),(0.19048,0.26984),(0.20635,0.26984),(0.22222,0.26984),(0.2381,0.26984),(0.25397,0.26984),(0.26984,0.26984),(0.28571,0.26984),(0.30159,0.26984),(0.31746,0.26984),(0.33333,0.26984),(0.34921,0.26984),(0.36508,0.26984),(0.38095,0.26984),(0.39683,0.26984),(0.4127,0.26984),(0.42857,0.26984),(0.44444,0.26984),(0.46032,0.26984),(0.47619,0.26984),(0.49206,0.26984),(0.50794,0.26984),(0.52381,0.26984),(0.53968,0.26984),(0.55556,0.26984),(0.57143,0.26984),(0.5873,0.26984),(0.60317,0.26984),(0.61905,0.26984),(0.63492,0.26984),(0.65079,0.26984),(0.66667,0.26984),(0.68254,0.26984),(0.69841,0.26984),(0.71429,0.26984),(0.73016,0.26984),(0.74603,0.26984),(0.7619,0.26984),(0.77778,0.26984),(0.79365,0.26984),(0.80952,0.26984),(0.8254,0.26984),(0.84127,0.26984),(0.85714,0.26984),(0.87302,0.26984),(0.88889,0.26984),(0.90476,0.26984),(0.92063,0.26984),(0.93651,0.26984),(0.95238,0.26984),(0.96825,0.26984),(0.98413,0.26984),(0.99609,0.26984),(0.00391,0.28571),(0.01587,0.28571),(0.03175,0.28571),(0.04762,0.28571),(0.06349,0.28571),(0.07937,0.28571),(0.09524,0.28571),(0.11111,0.28571),(0.12698,0.28571),(0.14286,0.28571),(0.15873,0.28571),(0.1746,0.28571),(0.19048,0.28571),(0.20635,0.28571),(0.22222,0.28571),(0.2381,0.28571),(0.25397,0.28571),(0.26984,0.28571),(0.28571,0.28571),(0.30159,0.28571),(0.31746,0.28571),(0.33333,0.28571),(0.34921,0.28571),(0.36508,0.28571),(0.38095,0.28571),(0.39683,0.28571),(0.4127,0.28571),(0.42857,0.28571),(0.44444,0.28571),(0.46032,0.28571),(0.47619,0.28571),(0.49206,0.28571),(0.50794,0.28571),(0.52381,0.28571),(0.53968,0.28571),(0.55556,0.28571),(0.57143,0.28571),(0.5873,0.28571),(0.60317,0.28571),(0.61905,0.28571),(0.63492,0.28571),(0.65079,0.28571),(0.66667,0.28571),(0.68254,0.28571),(0.69841,0.28571),(0.71429,0.28571),(0.73016,0.28571),(0.74603,0.28571),(0.7619,0.28571),(0.77778,0.28571),(0.79365,0.28571),(0.80952,0.28571),(0.8254,0.28571),(0.84127,0.28571),(0.85714,0.28571),(0.87302,0.28571),(0.88889,0.28571),(0.90476,0.28571),(0.92063,0.28571),(0.93651,0.28571),(0.95238,0.28571),(0.96825,0.28571),(0.98413,0.28571),(0.99609,0.28571),(0.00391,0.30159),(0.01587,0.30159),(0.03175,0.30159),(0.04762,0.30159),(0.06349,0.30159),(0.07937,0.30159),(0.09524,0.30159),(0.11111,0.30159),(0.12698,0.30159),(0.14286,0.30159),(0.15873,0.30159),(0.1746,0.30159),(0.19048,0.30159),(0.20635,0.30159),(0.22222,0.30159),(0.2381,0.30159),(0.25397,0.30159),(0.26984,0.30159),(0.28571,0.30159),(0.30159,0.30159),(0.31746,0.30159),(0.33333,0.30159),(0.34921,0.30159),(0.36508,0.30159),(0.38095,0.30159),(0.39683,0.30159),(0.4127,0.30159),(0.42857,0.30159),(0.44444,0.30159),(0.46032,0.30159),(0.47619,0.30159),(0.49206,0.30159),(0.50794,0.30159),(0.52381,0.30159),(0.53968,0.30159),(0.55556,0.30159),(0.57143,0.30159),(0.5873,0.30159),(0.60317,0.30159),(0.61905,0.30159),(0.63492,0.30159),(0.65079,0.30159),(0.66667,0.30159),(0.68254,0.30159),(0.69841,0.30159),(0.71429,0.30159),(0.73016,0.30159),(0.74603,0.30159),(0.7619,0.30159),(0.77778,0.30159),(0.79365,0.30159),(0.80952,0.30159),(0.8254,0.30159),(0.84127,0.30159),(0.85714,0.30159),(0.87302,0.30159),(0.88889,0.30159),(0.90476,0.30159),(0.92063,0.30159),(0.93651,0.30159),(0.95238,0.30159),(0.96825,0.30159),(0.98413,0.30159),(0.99609,0.30159),(0.00391,0.31746),(0.01587,0.31746),(0.03175,0.31746),(0.04762,0.31746),(0.06349,0.31746),(0.07937,0.31746),(0.09524,0.31746),(0.11111,0.31746),(0.12698,0.31746),(0.14286,0.31746),(0.15873,0.31746),(0.1746,0.31746),(0.19048,0.31746),(0.20635,0.31746),(0.22222,0.31746),(0.2381,0.31746),(0.25397,0.31746),(0.26984,0.31746),(0.28571,0.31746),(0.30159,0.31746),(0.31746,0.31746),(0.33333,0.31746),(0.34921,0.31746),(0.36508,0.31746),(0.38095,0.31746),(0.39683,0.31746),(0.4127,0.31746),(0.42857,0.31746),(0.44444,0.31746),(0.46032,0.31746),(0.47619,0.31746),(0.49206,0.31746),(0.50794,0.31746),(0.52381,0.31746),(0.53968,0.31746),(0.55556,0.31746),(0.57143,0.31746),(0.5873,0.31746),(0.60317,0.31746),(0.61905,0.31746),(0.63492,0.31746),(0.65079,0.31746),(0.66667,0.31746),(0.68254,0.31746),(0.69841,0.31746),(0.71429,0.31746),(0.73016,0.31746),(0.74603,0.31746),(0.7619,0.31746),(0.77778,0.31746),(0.79365,0.31746),(0.80952,0.31746),(0.8254,0.31746),(0.84127,0.31746),(0.85714,0.31746),(0.87302,0.31746),(0.88889,0.31746),(0.90476,0.31746),(0.92063,0.31746),(0.93651,0.31746),(0.95238,0.31746),(0.96825,0.31746),(0.98413,0.31746),(0.99609,0.31746),(0.00391,0.33333),(0.01587,0.33333),(0.03175,0.33333),(0.04762,0.33333),(0.06349,0.33333),(0.07937,0.33333),(0.09524,0.33333),(0.11111,0.33333),(0.12698,0.33333),(0.14286,0.33333),(0.15873,0.33333),(0.1746,0.33333),(0.19048,0.33333),(0.20635,0.33333),(0.22222,0.33333),(0.2381,0.33333),(0.25397,0.33333),(0.26984,0.33333),(0.28571,0.33333),(0.30159,0.33333),(0.31746,0.33333),(0.33333,0.33333),(0.34921,0.33333),(0.36508,0.33333),(0.38095,0.33333),(0.39683,0.33333),(0.4127,0.33333),(0.42857,0.33333),(0.44444,0.33333),(0.46032,0.33333),(0.47619,0.33333),(0.49206,0.33333),(0.50794,0.33333),(0.52381,0.33333),(0.53968,0.33333),(0.55556,0.33333),(0.57143,0.33333),(0.5873,0.33333),(0.60317,0.33333),(0.61905,0.33333),(0.63492,0.33333),(0.65079,0.33333),(0.66667,0.33333),(0.68254,0.33333),(0.69841,0.33333),(0.71429,0.33333),(0.73016,0.33333),(0.74603,0.33333),(0.7619,0.33333),(0.77778,0.33333),(0.79365,0.33333),(0.80952,0.33333),(0.8254,0.33333),(0.84127,0.33333),(0.85714,0.33333),(0.87302,0.33333),(0.88889,0.33333),(0.90476,0.33333),(0.92063,0.33333),(0.93651,0.33333),(0.95238,0.33333),(0.96825,0.33333),(0.98413,0.33333),(0.99609,0.33333),(0.00391,0.34921),(0.01587,0.34921),(0.03175,0.34921),(0.04762,0.34921),(0.06349,0.34921),(0.07937,0.34921),(0.09524,0.34921),(0.11111,0.34921),(0.12698,0.34921),(0.14286,0.34921),(0.15873,0.34921),(0.1746,0.34921),(0.19048,0.34921),(0.20635,0.34921),(0.22222,0.34921),(0.2381,0.34921),(0.25397,0.34921),(0.26984,0.34921),(0.28571,0.34921),(0.30159,0.34921),(0.31746,0.34921),(0.33333,0.34921),(0.34921,0.34921),(0.36508,0.34921),(0.38095,0.34921),(0.39683,0.34921),(0.4127,0.34921),(0.42857,0.34921),(0.44444,0.34921),(0.46032,0.34921),(0.47619,0.34921),(0.49206,0.34921),(0.50794,0.34921),(0.52381,0.34921),(0.53968,0.34921),(0.55556,0.34921),(0.57143,0.34921),(0.5873,0.34921),(0.60317,0.34921),(0.61905,0.34921),(0.63492,0.34921),(0.65079,0.34921),(0.66667,0.34921),(0.68254,0.34921),(0.69841,0.34921),(0.71429,0.34921),(0.73016,0.34921),(0.74603,0.34921),(0.7619,0.34921),(0.77778,0.34921),(0.79365,0.34921),(0.80952,0.34921),(0.8254,0.34921),(0.84127,0.34921),(0.85714,0.34921),(0.87302,0.34921),(0.88889,0.34921),(0.90476,0.34921),(0.92063,0.34921),(0.93651,0.34921),(0.95238,0.34921),(0.96825,0.34921),(0.98413,0.34921),(0.99609,0.34921),(0.00391,0.36508),(0.01587,0.36508),(0.03175,0.36508),(0.04762,0.36508),(0.06349,0.36508),(0.07937,0.36508),(0.09524,0.36508),(0.11111,0.36508),(0.12698,0.36508),(0.14286,0.36508),(0.15873,0.36508),(0.1746,0.36508),(0.19048,0.36508),(0.20635,0.36508),(0.22222,0.36508),(0.2381,0.36508),(0.25397,0.36508),(0.26984,0.36508),(0.28571,0.36508),(0.30159,0.36508),(0.31746,0.36508),(0.33333,0.36508),(0.34921,0.36508),(0.36508,0.36508),(0.38095,0.36508),(0.39683,0.36508),(0.4127,0.36508),(0.42857,0.36508),(0.44444,0.36508),(0.46032,0.36508),(0.47619,0.36508),(0.49206,0.36508),(0.50794,0.36508),(0.52381,0.36508),(0.53968,0.36508),(0.55556,0.36508),(0.57143,0.36508),(0.5873,0.36508),(0.60317,0.36508),(0.61905,0.36508),(0.63492,0.36508),(0.65079,0.36508),(0.66667,0.36508),(0.68254,0.36508),(0.69841,0.36508),(0.71429,0.36508),(0.73016,0.36508),(0.74603,0.36508),(0.7619,0.36508),(0.77778,0.36508),(0.79365,0.36508),(0.80952,0.36508),(0.8254,0.36508),(0.84127,0.36508),(0.85714,0.36508),(0.87302,0.36508),(0.88889,0.36508),(0.90476,0.36508),(0.92063,0.36508),(0.93651,0.36508),(0.95238,0.36508),(0.96825,0.36508),(0.98413,0.36508),(0.99609,0.36508),(0.00391,0.38095),(0.01587,0.38095),(0.03175,0.38095),(0.04762,0.38095),(0.06349,0.38095),(0.07937,0.38095),(0.09524,0.38095),(0.11111,0.38095),(0.12698,0.38095),(0.14286,0.38095),(0.15873,0.38095),(0.1746,0.38095),(0.19048,0.38095),(0.20635,0.38095),(0.22222,0.38095),(0.2381,0.38095),(0.25397,0.38095),(0.26984,0.38095),(0.28571,0.38095),(0.30159,0.38095),(0.31746,0.38095),(0.33333,0.38095),(0.34921,0.38095),(0.36508,0.38095),(0.38095,0.38095),(0.39683,0.38095),(0.4127,0.38095),(0.42857,0.38095),(0.44444,0.38095),(0.46032,0.38095),(0.47619,0.38095),(0.49206,0.38095),(0.50794,0.38095),(0.52381,0.38095),(0.53968,0.38095),(0.55556,0.38095),(0.57143,0.38095),(0.5873,0.38095),(0.60317,0.38095),(0.61905,0.38095),(0.63492,0.38095),(0.65079,0.38095),(0.66667,0.38095),(0.68254,0.38095),(0.69841,0.38095),(0.71429,0.38095),(0.73016,0.38095),(0.74603,0.38095),(0.7619,0.38095),(0.77778,0.38095),(0.79365,0.38095),(0.80952,0.38095),(0.8254,0.38095),(0.84127,0.38095),(0.85714,0.38095),(0.87302,0.38095),(0.88889,0.38095),(0.90476,0.38095),(0.92063,0.38095),(0.93651,0.38095),(0.95238,0.38095),(0.96825,0.38095),(0.98413,0.38095),(0.99609,0.38095),(0.00391,0.39683),(0.01587,0.39683),(0.03175,0.39683),(0.04762,0.39683),(0.06349,0.39683),(0.07937,0.39683),(0.09524,0.39683),(0.11111,0.39683),(0.12698,0.39683),(0.14286,0.39683),(0.15873,0.39683),(0.1746,0.39683),(0.19048,0.39683),(0.20635,0.39683),(0.22222,0.39683),(0.2381,0.39683),(0.25397,0.39683),(0.26984,0.39683),(0.28571,0.39683),(0.30159,0.39683),(0.31746,0.39683),(0.33333,0.39683),(0.34921,0.39683),(0.36508,0.39683),(0.38095,0.39683),(0.39683,0.39683),(0.4127,0.39683),(0.42857,0.39683),(0.44444,0.39683),(0.46032,0.39683),(0.47619,0.39683),(0.49206,0.39683),(0.50794,0.39683),(0.52381,0.39683),(0.53968,0.39683),(0.55556,0.39683),(0.57143,0.39683),(0.5873,0.39683),(0.60317,0.39683),(0.61905,0.39683),(0.63492,0.39683),(0.65079,0.39683),(0.66667,0.39683),(0.68254,0.39683),(0.69841,0.39683),(0.71429,0.39683),(0.73016,0.39683),(0.74603,0.39683),(0.7619,0.39683),(0.77778,0.39683),(0.79365,0.39683),(0.80952,0.39683),(0.8254,0.39683),(0.84127,0.39683),(0.85714,0.39683),(0.87302,0.39683),(0.88889,0.39683),(0.90476,0.39683),(0.92063,0.39683),(0.93651,0.39683),(0.95238,0.39683),(0.96825,0.39683),(0.98413,0.39683),(0.99609,0.39683),(0.00391,0.4127),(0.01587,0.4127),(0.03175,0.4127),(0.04762,0.4127),(0.06349,0.4127),(0.07937,0.4127),(0.09524,0.4127),(0.11111,0.4127),(0.12698,0.4127),(0.14286,0.4127),(0.15873,0.4127),(0.1746,0.4127),(0.19048,0.4127),(0.20635,0.4127),(0.22222,0.4127),(0.2381,0.4127),(0.25397,0.4127),(0.26984,0.4127),(0.28571,0.4127),(0.30159,0.4127),(0.31746,0.4127),(0.33333,0.4127),(0.34921,0.4127),(0.36508,0.4127),(0.38095,0.4127),(0.39683,0.4127),(0.4127,0.4127),(0.42857,0.4127),(0.44444,0.4127),(0.46032,0.4127),(0.47619,0.4127),(0.49206,0.4127),(0.50794,0.4127),(0.52381,0.4127),(0.53968,0.4127),(0.55556,0.4127),(0.57143,0.4127),(0.5873,0.4127),(0.60317,0.4127),(0.61905,0.4127),(0.63492,0.4127),(0.65079,0.4127),(0.66667,0.4127),(0.68254,0.4127),(0.69841,0.4127),(0.71429,0.4127),(0.73016,0.4127),(0.74603,0.4127),(0.7619,0.4127),(0.77778,0.4127),(0.79365,0.4127),(0.80952,0.4127),(0.8254,0.4127),(0.84127,0.4127),(0.85714,0.4127),(0.87302,0.4127),(0.88889,0.4127),(0.90476,0.4127),(0.92063,0.4127),(0.93651,0.4127),(0.95238,0.4127),(0.96825,0.4127),(0.98413,0.4127),(0.99609,0.4127),(0.00391,0.42857),(0.01587,0.42857),(0.03175,0.42857),(0.04762,0.42857),(0.06349,0.42857),(0.07937,0.42857),(0.09524,0.42857),(0.11111,0.42857),(0.12698,0.42857),(0.14286,0.42857),(0.15873,0.42857),(0.1746,0.42857),(0.19048,0.42857),(0.20635,0.42857),(0.22222,0.42857),(0.2381,0.42857),(0.25397,0.42857),(0.26984,0.42857),(0.28571,0.42857),(0.30159,0.42857),(0.31746,0.42857),(0.33333,0.42857),(0.34921,0.42857),(0.36508,0.42857),(0.38095,0.42857),(0.39683,0.42857),(0.4127,0.42857),(0.42857,0.42857),(0.44444,0.42857),(0.46032,0.42857),(0.47619,0.42857),(0.49206,0.42857),(0.50794,0.42857),(0.52381,0.42857),(0.53968,0.42857),(0.55556,0.42857),(0.57143,0.42857),(0.5873,0.42857),(0.60317,0.42857),(0.61905,0.42857),(0.63492,0.42857),(0.65079,0.42857),(0.66667,0.42857),(0.68254,0.42857),(0.69841,0.42857),(0.71429,0.42857),(0.73016,0.42857),(0.74603,0.42857),(0.7619,0.42857),(0.77778,0.42857),(0.79365,0.42857),(0.80952,0.42857),(0.8254,0.42857),(0.84127,0.42857),(0.85714,0.42857),(0.87302,0.42857),(0.88889,0.42857),(0.90476,0.42857),(0.92063,0.42857),(0.93651,0.42857),(0.95238,0.42857),(0.96825,0.42857),(0.98413,0.42857),(0.99609,0.42857),(0.00391,0.44444),(0.01587,0.44444),(0.03175,0.44444),(0.04762,0.44444),(0.06349,0.44444),(0.07937,0.44444),(0.09524,0.44444),(0.11111,0.44444),(0.12698,0.44444),(0.14286,0.44444),(0.15873,0.44444),(0.1746,0.44444),(0.19048,0.44444),(0.20635,0.44444),(0.22222,0.44444),(0.2381,0.44444),(0.25397,0.44444),(0.26984,0.44444),(0.28571,0.44444),(0.30159,0.44444),(0.31746,0.44444),(0.33333,0.44444),(0.34921,0.44444),(0.36508,0.44444),(0.38095,0.44444),(0.39683,0.44444),(0.4127,0.44444),(0.42857,0.44444),(0.44444,0.44444),(0.46032,0.44444),(0.47619,0.44444),(0.49206,0.44444),(0.50794,0.44444),(0.52381,0.44444),(0.53968,0.44444),(0.55556,0.44444),(0.57143,0.44444),(0.5873,0.44444),(0.60317,0.44444),(0.61905,0.44444),(0.63492,0.44444),(0.65079,0.44444),(0.66667,0.44444),(0.68254,0.44444),(0.69841,0.44444),(0.71429,0.44444),(0.73016,0.44444),(0.74603,0.44444),(0.7619,0.44444),(0.77778,0.44444),(0.79365,0.44444),(0.80952,0.44444),(0.8254,0.44444),(0.84127,0.44444),(0.85714,0.44444),(0.87302,0.44444),(0.88889,0.44444),(0.90476,0.44444),(0.92063,0.44444),(0.93651,0.44444),(0.95238,0.44444),(0.96825,0.44444),(0.98413,0.44444),(0.99609,0.44444),(0.00391,0.46032),(0.01587,0.46032),(0.03175,0.46032),(0.04762,0.46032),(0.06349,0.46032),(0.07937,0.46032),(0.09524,0.46032),(0.11111,0.46032),(0.12698,0.46032),(0.14286,0.46032),(0.15873,0.46032),(0.1746,0.46032),(0.19048,0.46032),(0.20635,0.46032),(0.22222,0.46032),(0.2381,0.46032),(0.25397,0.46032),(0.26984,0.46032),(0.28571,0.46032),(0.30159,0.46032),(0.31746,0.46032),(0.33333,0.46032),(0.34921,0.46032),(0.36508,0.46032),(0.38095,0.46032),(0.39683,0.46032),(0.4127,0.46032),(0.42857,0.46032),(0.44444,0.46032),(0.46032,0.46032),(0.47619,0.46032),(0.49206,0.46032),(0.50794,0.46032),(0.52381,0.46032),(0.53968,0.46032),(0.55556,0.46032),(0.57143,0.46032),(0.5873,0.46032),(0.60317,0.46032),(0.61905,0.46032),(0.63492,0.46032),(0.65079,0.46032),(0.66667,0.46032),(0.68254,0.46032),(0.69841,0.46032),(0.71429,0.46032),(0.73016,0.46032),(0.74603,0.46032),(0.7619,0.46032),(0.77778,0.46032),(0.79365,0.46032),(0.80952,0.46032),(0.8254,0.46032),(0.84127,0.46032),(0.85714,0.46032),(0.87302,0.46032),(0.88889,0.46032),(0.90476,0.46032),(0.92063,0.46032),(0.93651,0.46032),(0.95238,0.46032),(0.96825,0.46032),(0.98413,0.46032),(0.99609,0.46032),(0.00391,0.47619),(0.01587,0.47619),(0.03175,0.47619),(0.04762,0.47619),(0.06349,0.47619),(0.07937,0.47619),(0.09524,0.47619),(0.11111,0.47619),(0.12698,0.47619),(0.14286,0.47619),(0.15873,0.47619),(0.1746,0.47619),(0.19048,0.47619),(0.20635,0.47619),(0.22222,0.47619),(0.2381,0.47619),(0.25397,0.47619),(0.26984,0.47619),(0.28571,0.47619),(0.30159,0.47619),(0.31746,0.47619),(0.33333,0.47619),(0.34921,0.47619),(0.36508,0.47619),(0.38095,0.47619),(0.39683,0.47619),(0.4127,0.47619),(0.42857,0.47619),(0.44444,0.47619),(0.46032,0.47619),(0.47619,0.47619),(0.49206,0.47619),(0.50794,0.47619),(0.52381,0.47619),(0.53968,0.47619),(0.55556,0.47619),(0.57143,0.47619),(0.5873,0.47619),(0.60317,0.47619),(0.61905,0.47619),(0.63492,0.47619),(0.65079,0.47619),(0.66667,0.47619),(0.68254,0.47619),(0.69841,0.47619),(0.71429,0.47619),(0.73016,0.47619),(0.74603,0.47619),(0.7619,0.47619),(0.77778,0.47619),(0.79365,0.47619),(0.80952,0.47619),(0.8254,0.47619),(0.84127,0.47619),(0.85714,0.47619),(0.87302,0.47619),(0.88889,0.47619),(0.90476,0.47619),(0.92063,0.47619),(0.93651,0.47619),(0.95238,0.47619),(0.96825,0.47619),(0.98413,0.47619),(0.99609,0.47619),(0.00391,0.49206),(0.01587,0.49206),(0.03175,0.49206),(0.04762,0.49206),(0.06349,0.49206),(0.07937,0.49206),(0.09524,0.49206),(0.11111,0.49206),(0.12698,0.49206),(0.14286,0.49206),(0.15873,0.49206),(0.1746,0.49206),(0.19048,0.49206),(0.20635,0.49206),(0.22222,0.49206),(0.2381,0.49206),(0.25397,0.49206),(0.26984,0.49206),(0.28571,0.49206),(0.30159,0.49206),(0.31746,0.49206),(0.33333,0.49206),(0.34921,0.49206),(0.36508,0.49206),(0.38095,0.49206),(0.39683,0.49206),(0.4127,0.49206),(0.42857,0.49206),(0.44444,0.49206),(0.46032,0.49206),(0.47619,0.49206),(0.49206,0.49206),(0.50794,0.49206),(0.52381,0.49206),(0.53968,0.49206),(0.55556,0.49206),(0.57143,0.49206),(0.5873,0.49206),(0.60317,0.49206),(0.61905,0.49206),(0.63492,0.49206),(0.65079,0.49206),(0.66667,0.49206),(0.68254,0.49206),(0.69841,0.49206),(0.71429,0.49206),(0.73016,0.49206),(0.74603,0.49206),(0.7619,0.49206),(0.77778,0.49206),(0.79365,0.49206),(0.80952,0.49206),(0.8254,0.49206),(0.84127,0.49206),(0.85714,0.49206),(0.87302,0.49206),(0.88889,0.49206),(0.90476,0.49206),(0.92063,0.49206),(0.93651,0.49206),(0.95238,0.49206),(0.96825,0.49206),(0.98413,0.49206),(0.99609,0.49206),(0.00391,0.50794),(0.01587,0.50794),(0.03175,0.50794),(0.04762,0.50794),(0.06349,0.50794),(0.07937,0.50794),(0.09524,0.50794),(0.11111,0.50794),(0.12698,0.50794),(0.14286,0.50794),(0.15873,0.50794),(0.1746,0.50794),(0.19048,0.50794),(0.20635,0.50794),(0.22222,0.50794),(0.2381,0.50794),(0.25397,0.50794),(0.26984,0.50794),(0.28571,0.50794),(0.30159,0.50794),(0.31746,0.50794),(0.33333,0.50794),(0.34921,0.50794),(0.36508,0.50794),(0.38095,0.50794),(0.39683,0.50794),(0.4127,0.50794),(0.42857,0.50794),(0.44444,0.50794),(0.46032,0.50794),(0.47619,0.50794),(0.49206,0.50794),(0.50794,0.50794),(0.52381,0.50794),(0.53968,0.50794),(0.55556,0.50794),(0.57143,0.50794),(0.5873,0.50794),(0.60317,0.50794),(0.61905,0.50794),(0.63492,0.50794),(0.65079,0.50794),(0.66667,0.50794),(0.68254,0.50794),(0.69841,0.50794),(0.71429,0.50794),(0.73016,0.50794),(0.74603,0.50794),(0.7619,0.50794),(0.77778,0.50794),(0.79365,0.50794),(0.80952,0.50794),(0.8254,0.50794),(0.84127,0.50794),(0.85714,0.50794),(0.87302,0.50794),(0.88889,0.50794),(0.90476,0.50794),(0.92063,0.50794),(0.93651,0.50794),(0.95238,0.50794),(0.96825,0.50794),(0.98413,0.50794),(0.99609,0.50794),(0.00391,0.52381),(0.01587,0.52381),(0.03175,0.52381),(0.04762,0.52381),(0.06349,0.52381),(0.07937,0.52381),(0.09524,0.52381),(0.11111,0.52381),(0.12698,0.52381),(0.14286,0.52381),(0.15873,0.52381),(0.1746,0.52381),(0.19048,0.52381),(0.20635,0.52381),(0.22222,0.52381),(0.2381,0.52381),(0.25397,0.52381),(0.26984,0.52381),(0.28571,0.52381),(0.30159,0.52381),(0.31746,0.52381),(0.33333,0.52381),(0.34921,0.52381),(0.36508,0.52381),(0.38095,0.52381),(0.39683,0.52381),(0.4127,0.52381),(0.42857,0.52381),(0.44444,0.52381),(0.46032,0.52381),(0.47619,0.52381),(0.49206,0.52381),(0.50794,0.52381),(0.52381,0.52381),(0.53968,0.52381),(0.55556,0.52381),(0.57143,0.52381),(0.5873,0.52381),(0.60317,0.52381),(0.61905,0.52381),(0.63492,0.52381),(0.65079,0.52381),(0.66667,0.52381),(0.68254,0.52381),(0.69841,0.52381),(0.71429,0.52381),(0.73016,0.52381),(0.74603,0.52381),(0.7619,0.52381),(0.77778,0.52381),(0.79365,0.52381),(0.80952,0.52381),(0.8254,0.52381),(0.84127,0.52381),(0.85714,0.52381),(0.87302,0.52381),(0.88889,0.52381),(0.90476,0.52381),(0.92063,0.52381),(0.93651,0.52381),(0.95238,0.52381),(0.96825,0.52381),(0.98413,0.52381),(0.99609,0.52381),(0.00391,0.53968),(0.01587,0.53968),(0.03175,0.53968),(0.04762,0.53968),(0.06349,0.53968),(0.07937,0.53968),(0.09524,0.53968),(0.11111,0.53968),(0.12698,0.53968),(0.14286,0.53968),(0.15873,0.53968),(0.1746,0.53968),(0.19048,0.53968),(0.20635,0.53968),(0.22222,0.53968),(0.2381,0.53968),(0.25397,0.53968),(0.26984,0.53968),(0.28571,0.53968),(0.30159,0.53968),(0.31746,0.53968),(0.33333,0.53968),(0.34921,0.53968),(0.36508,0.53968),(0.38095,0.53968),(0.39683,0.53968),(0.4127,0.53968),(0.42857,0.53968),(0.44444,0.53968),(0.46032,0.53968),(0.47619,0.53968),(0.49206,0.53968),(0.50794,0.53968),(0.52381,0.53968),(0.53968,0.53968),(0.55556,0.53968),(0.57143,0.53968),(0.5873,0.53968),(0.60317,0.53968),(0.61905,0.53968),(0.63492,0.53968),(0.65079,0.53968),(0.66667,0.53968),(0.68254,0.53968),(0.69841,0.53968),(0.71429,0.53968),(0.73016,0.53968),(0.74603,0.53968),(0.7619,0.53968),(0.77778,0.53968),(0.79365,0.53968),(0.80952,0.53968),(0.8254,0.53968),(0.84127,0.53968),(0.85714,0.53968),(0.87302,0.53968),(0.88889,0.53968),(0.90476,0.53968),(0.92063,0.53968),(0.93651,0.53968),(0.95238,0.53968),(0.96825,0.53968),(0.98413,0.53968),(0.99609,0.53968),(0.00391,0.55556),(0.01587,0.55556),(0.03175,0.55556),(0.04762,0.55556),(0.06349,0.55556),(0.07937,0.55556),(0.09524,0.55556),(0.11111,0.55556),(0.12698,0.55556),(0.14286,0.55556),(0.15873,0.55556),(0.1746,0.55556),(0.19048,0.55556),(0.20635,0.55556),(0.22222,0.55556),(0.2381,0.55556),(0.25397,0.55556),(0.26984,0.55556),(0.28571,0.55556),(0.30159,0.55556),(0.31746,0.55556),(0.33333,0.55556),(0.34921,0.55556),(0.36508,0.55556),(0.38095,0.55556),(0.39683,0.55556),(0.4127,0.55556),(0.42857,0.55556),(0.44444,0.55556),(0.46032,0.55556),(0.47619,0.55556),(0.49206,0.55556),(0.50794,0.55556),(0.52381,0.55556),(0.53968,0.55556),(0.55556,0.55556),(0.57143,0.55556),(0.5873,0.55556),(0.60317,0.55556),(0.61905,0.55556),(0.63492,0.55556),(0.65079,0.55556),(0.66667,0.55556),(0.68254,0.55556),(0.69841,0.55556),(0.71429,0.55556),(0.73016,0.55556),(0.74603,0.55556),(0.7619,0.55556),(0.77778,0.55556),(0.79365,0.55556),(0.80952,0.55556),(0.8254,0.55556),(0.84127,0.55556),(0.85714,0.55556),(0.87302,0.55556),(0.88889,0.55556),(0.90476,0.55556),(0.92063,0.55556),(0.93651,0.55556),(0.95238,0.55556),(0.96825,0.55556),(0.98413,0.55556),(0.99609,0.55556),(0.00391,0.57143),(0.01587,0.57143),(0.03175,0.57143),(0.04762,0.57143),(0.06349,0.57143),(0.07937,0.57143),(0.09524,0.57143),(0.11111,0.57143),(0.12698,0.57143),(0.14286,0.57143),(0.15873,0.57143),(0.1746,0.57143),(0.19048,0.57143),(0.20635,0.57143),(0.22222,0.57143),(0.2381,0.57143),(0.25397,0.57143),(0.26984,0.57143),(0.28571,0.57143),(0.30159,0.57143),(0.31746,0.57143),(0.33333,0.57143),(0.34921,0.57143),(0.36508,0.57143),(0.38095,0.57143),(0.39683,0.57143),(0.4127,0.57143),(0.42857,0.57143),(0.44444,0.57143),(0.46032,0.57143),(0.47619,0.57143),(0.49206,0.57143),(0.50794,0.57143),(0.52381,0.57143),(0.53968,0.57143),(0.55556,0.57143),(0.57143,0.57143),(0.5873,0.57143),(0.60317,0.57143),(0.61905,0.57143),(0.63492,0.57143),(0.65079,0.57143),(0.66667,0.57143),(0.68254,0.57143),(0.69841,0.57143),(0.71429,0.57143),(0.73016,0.57143),(0.74603,0.57143),(0.7619,0.57143),(0.77778,0.57143),(0.79365,0.57143),(0.80952,0.57143),(0.8254,0.57143),(0.84127,0.57143),(0.85714,0.57143),(0.87302,0.57143),(0.88889,0.57143),(0.90476,0.57143),(0.92063,0.57143),(0.93651,0.57143),(0.95238,0.57143),(0.96825,0.57143),(0.98413,0.57143),(0.99609,0.57143),(0.00391,0.5873),(0.01587,0.5873),(0.03175,0.5873),(0.04762,0.5873),(0.06349,0.5873),(0.07937,0.5873),(0.09524,0.5873),(0.11111,0.5873),(0.12698,0.5873),(0.14286,0.5873),(0.15873,0.5873),(0.1746,0.5873),(0.19048,0.5873),(0.20635,0.5873),(0.22222,0.5873),(0.2381,0.5873),(0.25397,0.5873),(0.26984,0.5873),(0.28571,0.5873),(0.30159,0.5873),(0.31746,0.5873),(0.33333,0.5873),(0.34921,0.5873),(0.36508,0.5873),(0.38095,0.5873),(0.39683,0.5873),(0.4127,0.5873),(0.42857,0.5873),(0.44444,0.5873),(0.46032,0.5873),(0.47619,0.5873),(0.49206,0.5873),(0.50794,0.5873),(0.52381,0.5873),(0.53968,0.5873),(0.55556,0.5873),(0.57143,0.5873),(0.5873,0.5873),(0.60317,0.5873),(0.61905,0.5873),(0.63492,0.5873),(0.65079,0.5873),(0.66667,0.5873),(0.68254,0.5873),(0.69841,0.5873),(0.71429,0.5873),(0.73016,0.5873),(0.74603,0.5873),(0.7619,0.5873),(0.77778,0.5873),(0.79365,0.5873),(0.80952,0.5873),(0.8254,0.5873),(0.84127,0.5873),(0.85714,0.5873),(0.87302,0.5873),(0.88889,0.5873),(0.90476,0.5873),(0.92063,0.5873),(0.93651,0.5873),(0.95238,0.5873),(0.96825,0.5873),(0.98413,0.5873),(0.99609,0.5873),(0.00391,0.60317),(0.01587,0.60317),(0.03175,0.60317),(0.04762,0.60317),(0.06349,0.60317),(0.07937,0.60317),(0.09524,0.60317),(0.11111,0.60317),(0.12698,0.60317),(0.14286,0.60317),(0.15873,0.60317),(0.1746,0.60317),(0.19048,0.60317),(0.20635,0.60317),(0.22222,0.60317),(0.2381,0.60317),(0.25397,0.60317),(0.26984,0.60317),(0.28571,0.60317),(0.30159,0.60317),(0.31746,0.60317),(0.33333,0.60317),(0.34921,0.60317),(0.36508,0.60317),(0.38095,0.60317),(0.39683,0.60317),(0.4127,0.60317),(0.42857,0.60317),(0.44444,0.60317),(0.46032,0.60317),(0.47619,0.60317),(0.49206,0.60317),(0.50794,0.60317),(0.52381,0.60317),(0.53968,0.60317),(0.55556,0.60317),(0.57143,0.60317),(0.5873,0.60317),(0.60317,0.60317),(0.61905,0.60317),(0.63492,0.60317),(0.65079,0.60317),(0.66667,0.60317),(0.68254,0.60317),(0.69841,0.60317),(0.71429,0.60317),(0.73016,0.60317),(0.74603,0.60317),(0.7619,0.60317),(0.77778,0.60317),(0.79365,0.60317),(0.80952,0.60317),(0.8254,0.60317),(0.84127,0.60317),(0.85714,0.60317),(0.87302,0.60317),(0.88889,0.60317),(0.90476,0.60317),(0.92063,0.60317),(0.93651,0.60317),(0.95238,0.60317),(0.96825,0.60317),(0.98413,0.60317),(0.99609,0.60317),(0.00391,0.61905),(0.01587,0.61905),(0.03175,0.61905),(0.04762,0.61905),(0.06349,0.61905),(0.07937,0.61905),(0.09524,0.61905),(0.11111,0.61905),(0.12698,0.61905),(0.14286,0.61905),(0.15873,0.61905),(0.1746,0.61905),(0.19048,0.61905),(0.20635,0.61905),(0.22222,0.61905),(0.2381,0.61905),(0.25397,0.61905),(0.26984,0.61905),(0.28571,0.61905),(0.30159,0.61905),(0.31746,0.61905),(0.33333,0.61905),(0.34921,0.61905),(0.36508,0.61905),(0.38095,0.61905),(0.39683,0.61905),(0.4127,0.61905),(0.42857,0.61905),(0.44444,0.61905),(0.46032,0.61905),(0.47619,0.61905),(0.49206,0.61905),(0.50794,0.61905),(0.52381,0.61905),(0.53968,0.61905),(0.55556,0.61905),(0.57143,0.61905),(0.5873,0.61905),(0.60317,0.61905),(0.61905,0.61905),(0.63492,0.61905),(0.65079,0.61905),(0.66667,0.61905),(0.68254,0.61905),(0.69841,0.61905),(0.71429,0.61905),(0.73016,0.61905),(0.74603,0.61905),(0.7619,0.61905),(0.77778,0.61905),(0.79365,0.61905),(0.80952,0.61905),(0.8254,0.61905),(0.84127,0.61905),(0.85714,0.61905),(0.87302,0.61905),(0.88889,0.61905),(0.90476,0.61905),(0.92063,0.61905),(0.93651,0.61905),(0.95238,0.61905),(0.96825,0.61905),(0.98413,0.61905),(0.99609,0.61905),(0.00391,0.63492),(0.01587,0.63492),(0.03175,0.63492),(0.04762,0.63492),(0.06349,0.63492),(0.07937,0.63492),(0.09524,0.63492),(0.11111,0.63492),(0.12698,0.63492),(0.14286,0.63492),(0.15873,0.63492),(0.1746,0.63492),(0.19048,0.63492),(0.20635,0.63492),(0.22222,0.63492),(0.2381,0.63492),(0.25397,0.63492),(0.26984,0.63492),(0.28571,0.63492),(0.30159,0.63492),(0.31746,0.63492),(0.33333,0.63492),(0.34921,0.63492),(0.36508,0.63492),(0.38095,0.63492),(0.39683,0.63492),(0.4127,0.63492),(0.42857,0.63492),(0.44444,0.63492),(0.46032,0.63492),(0.47619,0.63492),(0.49206,0.63492),(0.50794,0.63492),(0.52381,0.63492),(0.53968,0.63492),(0.55556,0.63492),(0.57143,0.63492),(0.5873,0.63492),(0.60317,0.63492),(0.61905,0.63492),(0.63492,0.63492),(0.65079,0.63492),(0.66667,0.63492),(0.68254,0.63492),(0.69841,0.63492),(0.71429,0.63492),(0.73016,0.63492),(0.74603,0.63492),(0.7619,0.63492),(0.77778,0.63492),(0.79365,0.63492),(0.80952,0.63492),(0.8254,0.63492),(0.84127,0.63492),(0.85714,0.63492),(0.87302,0.63492),(0.88889,0.63492),(0.90476,0.63492),(0.92063,0.63492),(0.93651,0.63492),(0.95238,0.63492),(0.96825,0.63492),(0.98413,0.63492),(0.99609,0.63492),(0.00391,0.65079),(0.01587,0.65079),(0.03175,0.65079),(0.04762,0.65079),(0.06349,0.65079),(0.07937,0.65079),(0.09524,0.65079),(0.11111,0.65079),(0.12698,0.65079),(0.14286,0.65079),(0.15873,0.65079),(0.1746,0.65079),(0.19048,0.65079),(0.20635,0.65079),(0.22222,0.65079),(0.2381,0.65079),(0.25397,0.65079),(0.26984,0.65079),(0.28571,0.65079),(0.30159,0.65079),(0.31746,0.65079),(0.33333,0.65079),(0.34921,0.65079),(0.36508,0.65079),(0.38095,0.65079),(0.39683,0.65079),(0.4127,0.65079),(0.42857,0.65079),(0.44444,0.65079),(0.46032,0.65079),(0.47619,0.65079),(0.49206,0.65079),(0.50794,0.65079),(0.52381,0.65079),(0.53968,0.65079),(0.55556,0.65079),(0.57143,0.65079),(0.5873,0.65079),(0.60317,0.65079),(0.61905,0.65079),(0.63492,0.65079),(0.65079,0.65079),(0.66667,0.65079),(0.68254,0.65079),(0.69841,0.65079),(0.71429,0.65079),(0.73016,0.65079),(0.74603,0.65079),(0.7619,0.65079),(0.77778,0.65079),(0.79365,0.65079),(0.80952,0.65079),(0.8254,0.65079),(0.84127,0.65079),(0.85714,0.65079),(0.87302,0.65079),(0.88889,0.65079),(0.90476,0.65079),(0.92063,0.65079),(0.93651,0.65079),(0.95238,0.65079),(0.96825,0.65079),(0.98413,0.65079),(0.99609,0.65079),(0.00391,0.66667),(0.01587,0.66667),(0.03175,0.66667),(0.04762,0.66667),(0.06349,0.66667),(0.07937,0.66667),(0.09524,0.66667),(0.11111,0.66667),(0.12698,0.66667),(0.14286,0.66667),(0.15873,0.66667),(0.1746,0.66667),(0.19048,0.66667),(0.20635,0.66667),(0.22222,0.66667),(0.2381,0.66667),(0.25397,0.66667),(0.26984,0.66667),(0.28571,0.66667),(0.30159,0.66667),(0.31746,0.66667),(0.33333,0.66667),(0.34921,0.66667),(0.36508,0.66667),(0.38095,0.66667),(0.39683,0.66667),(0.4127,0.66667),(0.42857,0.66667),(0.44444,0.66667),(0.46032,0.66667),(0.47619,0.66667),(0.49206,0.66667),(0.50794,0.66667),(0.52381,0.66667),(0.53968,0.66667),(0.55556,0.66667),(0.57143,0.66667),(0.5873,0.66667),(0.60317,0.66667),(0.61905,0.66667),(0.63492,0.66667),(0.65079,0.66667),(0.66667,0.66667),(0.68254,0.66667),(0.69841,0.66667),(0.71429,0.66667),(0.73016,0.66667),(0.74603,0.66667),(0.7619,0.66667),(0.77778,0.66667),(0.79365,0.66667),(0.80952,0.66667),(0.8254,0.66667),(0.84127,0.66667),(0.85714,0.66667),(0.87302,0.66667),(0.88889,0.66667),(0.90476,0.66667),(0.92063,0.66667),(0.93651,0.66667),(0.95238,0.66667),(0.96825,0.66667),(0.98413,0.66667),(0.99609,0.66667),(0.00391,0.68254),(0.01587,0.68254),(0.03175,0.68254),(0.04762,0.68254),(0.06349,0.68254),(0.07937,0.68254),(0.09524,0.68254),(0.11111,0.68254),(0.12698,0.68254),(0.14286,0.68254),(0.15873,0.68254),(0.1746,0.68254),(0.19048,0.68254),(0.20635,0.68254),(0.22222,0.68254),(0.2381,0.68254),(0.25397,0.68254),(0.26984,0.68254),(0.28571,0.68254),(0.30159,0.68254),(0.31746,0.68254),(0.33333,0.68254),(0.34921,0.68254),(0.36508,0.68254),(0.38095,0.68254),(0.39683,0.68254),(0.4127,0.68254),(0.42857,0.68254),(0.44444,0.68254),(0.46032,0.68254),(0.47619,0.68254),(0.49206,0.68254),(0.50794,0.68254),(0.52381,0.68254),(0.53968,0.68254),(0.55556,0.68254),(0.57143,0.68254),(0.5873,0.68254),(0.60317,0.68254),(0.61905,0.68254),(0.63492,0.68254),(0.65079,0.68254),(0.66667,0.68254),(0.68254,0.68254),(0.69841,0.68254),(0.71429,0.68254),(0.73016,0.68254),(0.74603,0.68254),(0.7619,0.68254),(0.77778,0.68254),(0.79365,0.68254),(0.80952,0.68254),(0.8254,0.68254),(0.84127,0.68254),(0.85714,0.68254),(0.87302,0.68254),(0.88889,0.68254),(0.90476,0.68254),(0.92063,0.68254),(0.93651,0.68254),(0.95238,0.68254),(0.96825,0.68254),(0.98413,0.68254),(0.99609,0.68254),(0.00391,0.69841),(0.01587,0.69841),(0.03175,0.69841),(0.04762,0.69841),(0.06349,0.69841),(0.07937,0.69841),(0.09524,0.69841),(0.11111,0.69841),(0.12698,0.69841),(0.14286,0.69841),(0.15873,0.69841),(0.1746,0.69841),(0.19048,0.69841),(0.20635,0.69841),(0.22222,0.69841),(0.2381,0.69841),(0.25397,0.69841),(0.26984,0.69841),(0.28571,0.69841),(0.30159,0.69841),(0.31746,0.69841),(0.33333,0.69841),(0.34921,0.69841),(0.36508,0.69841),(0.38095,0.69841),(0.39683,0.69841),(0.4127,0.69841),(0.42857,0.69841),(0.44444,0.69841),(0.46032,0.69841),(0.47619,0.69841),(0.49206,0.69841),(0.50794,0.69841),(0.52381,0.69841),(0.53968,0.69841),(0.55556,0.69841),(0.57143,0.69841),(0.5873,0.69841),(0.60317,0.69841),(0.61905,0.69841),(0.63492,0.69841),(0.65079,0.69841),(0.66667,0.69841),(0.68254,0.69841),(0.69841,0.69841),(0.71429,0.69841),(0.73016,0.69841),(0.74603,0.69841),(0.7619,0.69841),(0.77778,0.69841),(0.79365,0.69841),(0.80952,0.69841),(0.8254,0.69841),(0.84127,0.69841),(0.85714,0.69841),(0.87302,0.69841),(0.88889,0.69841),(0.90476,0.69841),(0.92063,0.69841),(0.93651,0.69841),(0.95238,0.69841),(0.96825,0.69841),(0.98413,0.69841),(0.99609,0.69841),(0.00391,0.71429),(0.01587,0.71429),(0.03175,0.71429),(0.04762,0.71429),(0.06349,0.71429),(0.07937,0.71429),(0.09524,0.71429),(0.11111,0.71429),(0.12698,0.71429),(0.14286,0.71429),(0.15873,0.71429),(0.1746,0.71429),(0.19048,0.71429),(0.20635,0.71429),(0.22222,0.71429),(0.2381,0.71429),(0.25397,0.71429),(0.26984,0.71429),(0.28571,0.71429),(0.30159,0.71429),(0.31746,0.71429),(0.33333,0.71429),(0.34921,0.71429),(0.36508,0.71429),(0.38095,0.71429),(0.39683,0.71429),(0.4127,0.71429),(0.42857,0.71429),(0.44444,0.71429),(0.46032,0.71429),(0.47619,0.71429),(0.49206,0.71429),(0.50794,0.71429),(0.52381,0.71429),(0.53968,0.71429),(0.55556,0.71429),(0.57143,0.71429),(0.5873,0.71429),(0.60317,0.71429),(0.61905,0.71429),(0.63492,0.71429),(0.65079,0.71429),(0.66667,0.71429),(0.68254,0.71429),(0.69841,0.71429),(0.71429,0.71429),(0.73016,0.71429),(0.74603,0.71429),(0.7619,0.71429),(0.77778,0.71429),(0.79365,0.71429),(0.80952,0.71429),(0.8254,0.71429),(0.84127,0.71429),(0.85714,0.71429),(0.87302,0.71429),(0.88889,0.71429),(0.90476,0.71429),(0.92063,0.71429),(0.93651,0.71429),(0.95238,0.71429),(0.96825,0.71429),(0.98413,0.71429),(0.99609,0.71429),(0.00391,0.73016),(0.01587,0.73016),(0.03175,0.73016),(0.04762,0.73016),(0.06349,0.73016),(0.07937,0.73016),(0.09524,0.73016),(0.11111,0.73016),(0.12698,0.73016),(0.14286,0.73016),(0.15873,0.73016),(0.1746,0.73016),(0.19048,0.73016),(0.20635,0.73016),(0.22222,0.73016),(0.2381,0.73016),(0.25397,0.73016),(0.26984,0.73016),(0.28571,0.73016),(0.30159,0.73016),(0.31746,0.73016),(0.33333,0.73016),(0.34921,0.73016),(0.36508,0.73016),(0.38095,0.73016),(0.39683,0.73016),(0.4127,0.73016),(0.42857,0.73016),(0.44444,0.73016),(0.46032,0.73016),(0.47619,0.73016),(0.49206,0.73016),(0.50794,0.73016),(0.52381,0.73016),(0.53968,0.73016),(0.55556,0.73016),(0.57143,0.73016),(0.5873,0.73016),(0.60317,0.73016),(0.61905,0.73016),(0.63492,0.73016),(0.65079,0.73016),(0.66667,0.73016),(0.68254,0.73016),(0.69841,0.73016),(0.71429,0.73016),(0.73016,0.73016),(0.74603,0.73016),(0.7619,0.73016),(0.77778,0.73016),(0.79365,0.73016),(0.80952,0.73016),(0.8254,0.73016),(0.84127,0.73016),(0.85714,0.73016),(0.87302,0.73016),(0.88889,0.73016),(0.90476,0.73016),(0.92063,0.73016),(0.93651,0.73016),(0.95238,0.73016),(0.96825,0.73016),(0.98413,0.73016),(0.99609,0.73016),(0.00391,0.74603),(0.01587,0.74603),(0.03175,0.74603),(0.04762,0.74603),(0.06349,0.74603),(0.07937,0.74603),(0.09524,0.74603),(0.11111,0.74603),(0.12698,0.74603),(0.14286,0.74603),(0.15873,0.74603),(0.1746,0.74603),(0.19048,0.74603),(0.20635,0.74603),(0.22222,0.74603),(0.2381,0.74603),(0.25397,0.74603),(0.26984,0.74603),(0.28571,0.74603),(0.30159,0.74603),(0.31746,0.74603),(0.33333,0.74603),(0.34921,0.74603),(0.36508,0.74603),(0.38095,0.74603),(0.39683,0.74603),(0.4127,0.74603),(0.42857,0.74603),(0.44444,0.74603),(0.46032,0.74603),(0.47619,0.74603),(0.49206,0.74603),(0.50794,0.74603),(0.52381,0.74603),(0.53968,0.74603),(0.55556,0.74603),(0.57143,0.74603),(0.5873,0.74603),(0.60317,0.74603),(0.61905,0.74603),(0.63492,0.74603),(0.65079,0.74603),(0.66667,0.74603),(0.68254,0.74603),(0.69841,0.74603),(0.71429,0.74603),(0.73016,0.74603),(0.74603,0.74603),(0.7619,0.74603),(0.77778,0.74603),(0.79365,0.74603),(0.80952,0.74603),(0.8254,0.74603),(0.84127,0.74603),(0.85714,0.74603),(0.87302,0.74603),(0.88889,0.74603),(0.90476,0.74603),(0.92063,0.74603),(0.93651,0.74603),(0.95238,0.74603),(0.96825,0.74603),(0.98413,0.74603),(0.99609,0.74603),(0.00391,0.7619),(0.01587,0.7619),(0.03175,0.7619),(0.04762,0.7619),(0.06349,0.7619),(0.07937,0.7619),(0.09524,0.7619),(0.11111,0.7619),(0.12698,0.7619),(0.14286,0.7619),(0.15873,0.7619),(0.1746,0.7619),(0.19048,0.7619),(0.20635,0.7619),(0.22222,0.7619),(0.2381,0.7619),(0.25397,0.7619),(0.26984,0.7619),(0.28571,0.7619),(0.30159,0.7619),(0.31746,0.7619),(0.33333,0.7619),(0.34921,0.7619),(0.36508,0.7619),(0.38095,0.7619),(0.39683,0.7619),(0.4127,0.7619),(0.42857,0.7619),(0.44444,0.7619),(0.46032,0.7619),(0.47619,0.7619),(0.49206,0.7619),(0.50794,0.7619),(0.52381,0.7619),(0.53968,0.7619),(0.55556,0.7619),(0.57143,0.7619),(0.5873,0.7619),(0.60317,0.7619),(0.61905,0.7619),(0.63492,0.7619),(0.65079,0.7619),(0.66667,0.7619),(0.68254,0.7619),(0.69841,0.7619),(0.71429,0.7619),(0.73016,0.7619),(0.74603,0.7619),(0.7619,0.7619),(0.77778,0.7619),(0.79365,0.7619),(0.80952,0.7619),(0.8254,0.7619),(0.84127,0.7619),(0.85714,0.7619),(0.87302,0.7619),(0.88889,0.7619),(0.90476,0.7619),(0.92063,0.7619),(0.93651,0.7619),(0.95238,0.7619),(0.96825,0.7619),(0.98413,0.7619),(0.99609,0.7619),(0.00391,0.77778),(0.01587,0.77778),(0.03175,0.77778),(0.04762,0.77778),(0.06349,0.77778),(0.07937,0.77778),(0.09524,0.77778),(0.11111,0.77778),(0.12698,0.77778),(0.14286,0.77778),(0.15873,0.77778),(0.1746,0.77778),(0.19048,0.77778),(0.20635,0.77778),(0.22222,0.77778),(0.2381,0.77778),(0.25397,0.77778),(0.26984,0.77778),(0.28571,0.77778),(0.30159,0.77778),(0.31746,0.77778),(0.33333,0.77778),(0.34921,0.77778),(0.36508,0.77778),(0.38095,0.77778),(0.39683,0.77778),(0.4127,0.77778),(0.42857,0.77778),(0.44444,0.77778),(0.46032,0.77778),(0.47619,0.77778),(0.49206,0.77778),(0.50794,0.77778),(0.52381,0.77778),(0.53968,0.77778),(0.55556,0.77778),(0.57143,0.77778),(0.5873,0.77778),(0.60317,0.77778),(0.61905,0.77778),(0.63492,0.77778),(0.65079,0.77778),(0.66667,0.77778),(0.68254,0.77778),(0.69841,0.77778),(0.71429,0.77778),(0.73016,0.77778),(0.74603,0.77778),(0.7619,0.77778),(0.77778,0.77778),(0.79365,0.77778),(0.80952,0.77778),(0.8254,0.77778),(0.84127,0.77778),(0.85714,0.77778),(0.87302,0.77778),(0.88889,0.77778),(0.90476,0.77778),(0.92063,0.77778),(0.93651,0.77778),(0.95238,0.77778),(0.96825,0.77778),(0.98413,0.77778),(0.99609,0.77778),(0.00391,0.79365),(0.01587,0.79365),(0.03175,0.79365),(0.04762,0.79365),(0.06349,0.79365),(0.07937,0.79365),(0.09524,0.79365),(0.11111,0.79365),(0.12698,0.79365),(0.14286,0.79365),(0.15873,0.79365),(0.1746,0.79365),(0.19048,0.79365),(0.20635,0.79365),(0.22222,0.79365),(0.2381,0.79365),(0.25397,0.79365),(0.26984,0.79365),(0.28571,0.79365),(0.30159,0.79365),(0.31746,0.79365),(0.33333,0.79365),(0.34921,0.79365),(0.36508,0.79365),(0.38095,0.79365),(0.39683,0.79365),(0.4127,0.79365),(0.42857,0.79365),(0.44444,0.79365),(0.46032,0.79365),(0.47619,0.79365),(0.49206,0.79365),(0.50794,0.79365),(0.52381,0.79365),(0.53968,0.79365),(0.55556,0.79365),(0.57143,0.79365),(0.5873,0.79365),(0.60317,0.79365),(0.61905,0.79365),(0.63492,0.79365),(0.65079,0.79365),(0.66667,0.79365),(0.68254,0.79365),(0.69841,0.79365),(0.71429,0.79365),(0.73016,0.79365),(0.74603,0.79365),(0.7619,0.79365),(0.77778,0.79365),(0.79365,0.79365),(0.80952,0.79365),(0.8254,0.79365),(0.84127,0.79365),(0.85714,0.79365),(0.87302,0.79365),(0.88889,0.79365),(0.90476,0.79365),(0.92063,0.79365),(0.93651,0.79365),(0.95238,0.79365),(0.96825,0.79365),(0.98413,0.79365),(0.99609,0.79365),(0.00391,0.80952),(0.01587,0.80952),(0.03175,0.80952),(0.04762,0.80952),(0.06349,0.80952),(0.07937,0.80952),(0.09524,0.80952),(0.11111,0.80952),(0.12698,0.80952),(0.14286,0.80952),(0.15873,0.80952),(0.1746,0.80952),(0.19048,0.80952),(0.20635,0.80952),(0.22222,0.80952),(0.2381,0.80952),(0.25397,0.80952),(0.26984,0.80952),(0.28571,0.80952),(0.30159,0.80952),(0.31746,0.80952),(0.33333,0.80952),(0.34921,0.80952),(0.36508,0.80952),(0.38095,0.80952),(0.39683,0.80952),(0.4127,0.80952),(0.42857,0.80952),(0.44444,0.80952),(0.46032,0.80952),(0.47619,0.80952),(0.49206,0.80952),(0.50794,0.80952),(0.52381,0.80952),(0.53968,0.80952),(0.55556,0.80952),(0.57143,0.80952),(0.5873,0.80952),(0.60317,0.80952),(0.61905,0.80952),(0.63492,0.80952),(0.65079,0.80952),(0.66667,0.80952),(0.68254,0.80952),(0.69841,0.80952),(0.71429,0.80952),(0.73016,0.80952),(0.74603,0.80952),(0.7619,0.80952),(0.77778,0.80952),(0.79365,0.80952),(0.80952,0.80952),(0.8254,0.80952),(0.84127,0.80952),(0.85714,0.80952),(0.87302,0.80952),(0.88889,0.80952),(0.90476,0.80952),(0.92063,0.80952),(0.93651,0.80952),(0.95238,0.80952),(0.96825,0.80952),(0.98413,0.80952),(0.99609,0.80952),(0.00391,0.8254),(0.01587,0.8254),(0.03175,0.8254),(0.04762,0.8254),(0.06349,0.8254),(0.07937,0.8254),(0.09524,0.8254),(0.11111,0.8254),(0.12698,0.8254),(0.14286,0.8254),(0.15873,0.8254),(0.1746,0.8254),(0.19048,0.8254),(0.20635,0.8254),(0.22222,0.8254),(0.2381,0.8254),(0.25397,0.8254),(0.26984,0.8254),(0.28571,0.8254),(0.30159,0.8254),(0.31746,0.8254),(0.33333,0.8254),(0.34921,0.8254),(0.36508,0.8254),(0.38095,0.8254),(0.39683,0.8254),(0.4127,0.8254),(0.42857,0.8254),(0.44444,0.8254),(0.46032,0.8254),(0.47619,0.8254),(0.49206,0.8254),(0.50794,0.8254),(0.52381,0.8254),(0.53968,0.8254),(0.55556,0.8254),(0.57143,0.8254),(0.5873,0.8254),(0.60317,0.8254),(0.61905,0.8254),(0.63492,0.8254),(0.65079,0.8254),(0.66667,0.8254),(0.68254,0.8254),(0.69841,0.8254),(0.71429,0.8254),(0.73016,0.8254),(0.74603,0.8254),(0.7619,0.8254),(0.77778,0.8254),(0.79365,0.8254),(0.80952,0.8254),(0.8254,0.8254),(0.84127,0.8254),(0.85714,0.8254),(0.87302,0.8254),(0.88889,0.8254),(0.90476,0.8254),(0.92063,0.8254),(0.93651,0.8254),(0.95238,0.8254),(0.96825,0.8254),(0.98413,0.8254),(0.99609,0.8254),(0.00391,0.84127),(0.01587,0.84127),(0.03175,0.84127),(0.04762,0.84127),(0.06349,0.84127),(0.07937,0.84127),(0.09524,0.84127),(0.11111,0.84127),(0.12698,0.84127),(0.14286,0.84127),(0.15873,0.84127),(0.1746,0.84127),(0.19048,0.84127),(0.20635,0.84127),(0.22222,0.84127),(0.2381,0.84127),(0.25397,0.84127),(0.26984,0.84127),(0.28571,0.84127),(0.30159,0.84127),(0.31746,0.84127),(0.33333,0.84127),(0.34921,0.84127),(0.36508,0.84127),(0.38095,0.84127),(0.39683,0.84127),(0.4127,0.84127),(0.42857,0.84127),(0.44444,0.84127),(0.46032,0.84127),(0.47619,0.84127),(0.49206,0.84127),(0.50794,0.84127),(0.52381,0.84127),(0.53968,0.84127),(0.55556,0.84127),(0.57143,0.84127),(0.5873,0.84127),(0.60317,0.84127),(0.61905,0.84127),(0.63492,0.84127),(0.65079,0.84127),(0.66667,0.84127),(0.68254,0.84127),(0.69841,0.84127),(0.71429,0.84127),(0.73016,0.84127),(0.74603,0.84127),(0.7619,0.84127),(0.77778,0.84127),(0.79365,0.84127),(0.80952,0.84127),(0.8254,0.84127),(0.84127,0.84127),(0.85714,0.84127),(0.87302,0.84127),(0.88889,0.84127),(0.90476,0.84127),(0.92063,0.84127),(0.93651,0.84127),(0.95238,0.84127),(0.96825,0.84127),(0.98413,0.84127),(0.99609,0.84127),(0.00391,0.85714),(0.01587,0.85714),(0.03175,0.85714),(0.04762,0.85714),(0.06349,0.85714),(0.07937,0.85714),(0.09524,0.85714),(0.11111,0.85714),(0.12698,0.85714),(0.14286,0.85714),(0.15873,0.85714),(0.1746,0.85714),(0.19048,0.85714),(0.20635,0.85714),(0.22222,0.85714),(0.2381,0.85714),(0.25397,0.85714),(0.26984,0.85714),(0.28571,0.85714),(0.30159,0.85714),(0.31746,0.85714),(0.33333,0.85714),(0.34921,0.85714),(0.36508,0.85714),(0.38095,0.85714),(0.39683,0.85714),(0.4127,0.85714),(0.42857,0.85714),(0.44444,0.85714),(0.46032,0.85714),(0.47619,0.85714),(0.49206,0.85714),(0.50794,0.85714),(0.52381,0.85714),(0.53968,0.85714),(0.55556,0.85714),(0.57143,0.85714),(0.5873,0.85714),(0.60317,0.85714),(0.61905,0.85714),(0.63492,0.85714),(0.65079,0.85714),(0.66667,0.85714),(0.68254,0.85714),(0.69841,0.85714),(0.71429,0.85714),(0.73016,0.85714),(0.74603,0.85714),(0.7619,0.85714),(0.77778,0.85714),(0.79365,0.85714),(0.80952,0.85714),(0.8254,0.85714),(0.84127,0.85714),(0.85714,0.85714),(0.87302,0.85714),(0.88889,0.85714),(0.90476,0.85714),(0.92063,0.85714),(0.93651,0.85714),(0.95238,0.85714),(0.96825,0.85714),(0.98413,0.85714),(0.99609,0.85714),(0.00391,0.87302),(0.01587,0.87302),(0.03175,0.87302),(0.04762,0.87302),(0.06349,0.87302),(0.07937,0.87302),(0.09524,0.87302),(0.11111,0.87302),(0.12698,0.87302),(0.14286,0.87302),(0.15873,0.87302),(0.1746,0.87302),(0.19048,0.87302),(0.20635,0.87302),(0.22222,0.87302),(0.2381,0.87302),(0.25397,0.87302),(0.26984,0.87302),(0.28571,0.87302),(0.30159,0.87302),(0.31746,0.87302),(0.33333,0.87302),(0.34921,0.87302),(0.36508,0.87302),(0.38095,0.87302),(0.39683,0.87302),(0.4127,0.87302),(0.42857,0.87302),(0.44444,0.87302),(0.46032,0.87302),(0.47619,0.87302),(0.49206,0.87302),(0.50794,0.87302),(0.52381,0.87302),(0.53968,0.87302),(0.55556,0.87302),(0.57143,0.87302),(0.5873,0.87302),(0.60317,0.87302),(0.61905,0.87302),(0.63492,0.87302),(0.65079,0.87302),(0.66667,0.87302),(0.68254,0.87302),(0.69841,0.87302),(0.71429,0.87302),(0.73016,0.87302),(0.74603,0.87302),(0.7619,0.87302),(0.77778,0.87302),(0.79365,0.87302),(0.80952,0.87302),(0.8254,0.87302),(0.84127,0.87302),(0.85714,0.87302),(0.87302,0.87302),(0.88889,0.87302),(0.90476,0.87302),(0.92063,0.87302),(0.93651,0.87302),(0.95238,0.87302),(0.96825,0.87302),(0.98413,0.87302),(0.99609,0.87302),(0.00391,0.88889),(0.01587,0.88889),(0.03175,0.88889),(0.04762,0.88889),(0.06349,0.88889),(0.07937,0.88889),(0.09524,0.88889),(0.11111,0.88889),(0.12698,0.88889),(0.14286,0.88889),(0.15873,0.88889),(0.1746,0.88889),(0.19048,0.88889),(0.20635,0.88889),(0.22222,0.88889),(0.2381,0.88889),(0.25397,0.88889),(0.26984,0.88889),(0.28571,0.88889),(0.30159,0.88889),(0.31746,0.88889),(0.33333,0.88889),(0.34921,0.88889),(0.36508,0.88889),(0.38095,0.88889),(0.39683,0.88889),(0.4127,0.88889),(0.42857,0.88889),(0.44444,0.88889),(0.46032,0.88889),(0.47619,0.88889),(0.49206,0.88889),(0.50794,0.88889),(0.52381,0.88889),(0.53968,0.88889),(0.55556,0.88889),(0.57143,0.88889),(0.5873,0.88889),(0.60317,0.88889),(0.61905,0.88889),(0.63492,0.88889),(0.65079,0.88889),(0.66667,0.88889),(0.68254,0.88889),(0.69841,0.88889),(0.71429,0.88889),(0.73016,0.88889),(0.74603,0.88889),(0.7619,0.88889),(0.77778,0.88889),(0.79365,0.88889),(0.80952,0.88889),(0.8254,0.88889),(0.84127,0.88889),(0.85714,0.88889),(0.87302,0.88889),(0.88889,0.88889),(0.90476,0.88889),(0.92063,0.88889),(0.93651,0.88889),(0.95238,0.88889),(0.96825,0.88889),(0.98413,0.88889),(0.99609,0.88889),(0.00391,0.90476),(0.01587,0.90476),(0.03175,0.90476),(0.04762,0.90476),(0.06349,0.90476),(0.07937,0.90476),(0.09524,0.90476),(0.11111,0.90476),(0.12698,0.90476),(0.14286,0.90476),(0.15873,0.90476),(0.1746,0.90476),(0.19048,0.90476),(0.20635,0.90476),(0.22222,0.90476),(0.2381,0.90476),(0.25397,0.90476),(0.26984,0.90476),(0.28571,0.90476),(0.30159,0.90476),(0.31746,0.90476),(0.33333,0.90476),(0.34921,0.90476),(0.36508,0.90476),(0.38095,0.90476),(0.39683,0.90476),(0.4127,0.90476),(0.42857,0.90476),(0.44444,0.90476),(0.46032,0.90476),(0.47619,0.90476),(0.49206,0.90476),(0.50794,0.90476),(0.52381,0.90476),(0.53968,0.90476),(0.55556,0.90476),(0.57143,0.90476),(0.5873,0.90476),(0.60317,0.90476),(0.61905,0.90476),(0.63492,0.90476),(0.65079,0.90476),(0.66667,0.90476),(0.68254,0.90476),(0.69841,0.90476),(0.71429,0.90476),(0.73016,0.90476),(0.74603,0.90476),(0.7619,0.90476),(0.77778,0.90476),(0.79365,0.90476),(0.80952,0.90476),(0.8254,0.90476),(0.84127,0.90476),(0.85714,0.90476),(0.87302,0.90476),(0.88889,0.90476),(0.90476,0.90476),(0.92063,0.90476),(0.93651,0.90476),(0.95238,0.90476),(0.96825,0.90476),(0.98413,0.90476),(0.99609,0.90476),(0.00391,0.92063),(0.01587,0.92063),(0.03175,0.92063),(0.04762,0.92063),(0.06349,0.92063),(0.07937,0.92063),(0.09524,0.92063),(0.11111,0.92063),(0.12698,0.92063),(0.14286,0.92063),(0.15873,0.92063),(0.1746,0.92063),(0.19048,0.92063),(0.20635,0.92063),(0.22222,0.92063),(0.2381,0.92063),(0.25397,0.92063),(0.26984,0.92063),(0.28571,0.92063),(0.30159,0.92063),(0.31746,0.92063),(0.33333,0.92063),(0.34921,0.92063),(0.36508,0.92063),(0.38095,0.92063),(0.39683,0.92063),(0.4127,0.92063),(0.42857,0.92063),(0.44444,0.92063),(0.46032,0.92063),(0.47619,0.92063),(0.49206,0.92063),(0.50794,0.92063),(0.52381,0.92063),(0.53968,0.92063),(0.55556,0.92063),(0.57143,0.92063),(0.5873,0.92063),(0.60317,0.92063),(0.61905,0.92063),(0.63492,0.92063),(0.65079,0.92063),(0.66667,0.92063),(0.68254,0.92063),(0.69841,0.92063),(0.71429,0.92063),(0.73016,0.92063),(0.74603,0.92063),(0.7619,0.92063),(0.77778,0.92063),(0.79365,0.92063),(0.80952,0.92063),(0.8254,0.92063),(0.84127,0.92063),(0.85714,0.92063),(0.87302,0.92063),(0.88889,0.92063),(0.90476,0.92063),(0.92063,0.92063),(0.93651,0.92063),(0.95238,0.92063),(0.96825,0.92063),(0.98413,0.92063),(0.99609,0.92063),(0.00391,0.93651),(0.01587,0.93651),(0.03175,0.93651),(0.04762,0.93651),(0.06349,0.93651),(0.07937,0.93651),(0.09524,0.93651),(0.11111,0.93651),(0.12698,0.93651),(0.14286,0.93651),(0.15873,0.93651),(0.1746,0.93651),(0.19048,0.93651),(0.20635,0.93651),(0.22222,0.93651),(0.2381,0.93651),(0.25397,0.93651),(0.26984,0.93651),(0.28571,0.93651),(0.30159,0.93651),(0.31746,0.93651),(0.33333,0.93651),(0.34921,0.93651),(0.36508,0.93651),(0.38095,0.93651),(0.39683,0.93651),(0.4127,0.93651),(0.42857,0.93651),(0.44444,0.93651),(0.46032,0.93651),(0.47619,0.93651),(0.49206,0.93651),(0.50794,0.93651),(0.52381,0.93651),(0.53968,0.93651),(0.55556,0.93651),(0.57143,0.93651),(0.5873,0.93651),(0.60317,0.93651),(0.61905,0.93651),(0.63492,0.93651),(0.65079,0.93651),(0.66667,0.93651),(0.68254,0.93651),(0.69841,0.93651),(0.71429,0.93651),(0.73016,0.93651),(0.74603,0.93651),(0.7619,0.93651),(0.77778,0.93651),(0.79365,0.93651),(0.80952,0.93651),(0.8254,0.93651),(0.84127,0.93651),(0.85714,0.93651),(0.87302,0.93651),(0.88889,0.93651),(0.90476,0.93651),(0.92063,0.93651),(0.93651,0.93651),(0.95238,0.93651),(0.96825,0.93651),(0.98413,0.93651),(0.99609,0.93651),(0.00391,0.95238),(0.01587,0.95238),(0.03175,0.95238),(0.04762,0.95238),(0.06349,0.95238),(0.07937,0.95238),(0.09524,0.95238),(0.11111,0.95238),(0.12698,0.95238),(0.14286,0.95238),(0.15873,0.95238),(0.1746,0.95238),(0.19048,0.95238),(0.20635,0.95238),(0.22222,0.95238),(0.2381,0.95238),(0.25397,0.95238),(0.26984,0.95238),(0.28571,0.95238),(0.30159,0.95238),(0.31746,0.95238),(0.33333,0.95238),(0.34921,0.95238),(0.36508,0.95238),(0.38095,0.95238),(0.39683,0.95238),(0.4127,0.95238),(0.42857,0.95238),(0.44444,0.95238),(0.46032,0.95238),(0.47619,0.95238),(0.49206,0.95238),(0.50794,0.95238),(0.52381,0.95238),(0.53968,0.95238),(0.55556,0.95238),(0.57143,0.95238),(0.5873,0.95238),(0.60317,0.95238),(0.61905,0.95238),(0.63492,0.95238),(0.65079,0.95238),(0.66667,0.95238),(0.68254,0.95238),(0.69841,0.95238),(0.71429,0.95238),(0.73016,0.95238),(0.74603,0.95238),(0.7619,0.95238),(0.77778,0.95238),(0.79365,0.95238),(0.80952,0.95238),(0.8254,0.95238),(0.84127,0.95238),(0.85714,0.95238),(0.87302,0.95238),(0.88889,0.95238),(0.90476,0.95238),(0.92063,0.95238),(0.93651,0.95238),(0.95238,0.95238),(0.96825,0.95238),(0.98413,0.95238),(0.99609,0.95238),(0.00391,0.96825),(0.01587,0.96825),(0.03175,0.96825),(0.04762,0.96825),(0.06349,0.96825),(0.07937,0.96825),(0.09524,0.96825),(0.11111,0.96825),(0.12698,0.96825),(0.14286,0.96825),(0.15873,0.96825),(0.1746,0.96825),(0.19048,0.96825),(0.20635,0.96825),(0.22222,0.96825),(0.2381,0.96825),(0.25397,0.96825),(0.26984,0.96825),(0.28571,0.96825),(0.30159,0.96825),(0.31746,0.96825),(0.33333,0.96825),(0.34921,0.96825),(0.36508,0.96825),(0.38095,0.96825),(0.39683,0.96825),(0.4127,0.96825),(0.42857,0.96825),(0.44444,0.96825),(0.46032,0.96825),(0.47619,0.96825),(0.49206,0.96825),(0.50794,0.96825),(0.52381,0.96825),(0.53968,0.96825),(0.55556,0.96825),(0.57143,0.96825),(0.5873,0.96825),(0.60317,0.96825),(0.61905,0.96825),(0.63492,0.96825),(0.65079,0.96825),(0.66667,0.96825),(0.68254,0.96825),(0.69841,0.96825),(0.71429,0.96825),(0.73016,0.96825),(0.74603,0.96825),(0.7619,0.96825),(0.77778,0.96825),(0.79365,0.96825),(0.80952,0.96825),(0.8254,0.96825),(0.84127,0.96825),(0.85714,0.96825),(0.87302,0.96825),(0.88889,0.96825),(0.90476,0.96825),(0.92063,0.96825),(0.93651,0.96825),(0.95238,0.96825),(0.96825,0.96825),(0.98413,0.96825),(0.99609,0.96825),(0.00391,0.98413),(0.01587,0.98413),(0.03175,0.98413),(0.04762,0.98413),(0.06349,0.98413),(0.07937,0.98413),(0.09524,0.98413),(0.11111,0.98413),(0.12698,0.98413),(0.14286,0.98413),(0.15873,0.98413),(0.1746,0.98413),(0.19048,0.98413),(0.20635,0.98413),(0.22222,0.98413),(0.2381,0.98413),(0.25397,0.98413),(0.26984,0.98413),(0.28571,0.98413),(0.30159,0.98413),(0.31746,0.98413),(0.33333,0.98413),(0.34921,0.98413),(0.36508,0.98413),(0.38095,0.98413),(0.39683,0.98413),(0.4127,0.98413),(0.42857,0.98413),(0.44444,0.98413),(0.46032,0.98413),(0.47619,0.98413),(0.49206,0.98413),(0.50794,0.98413),(0.52381,0.98413),(0.53968,0.98413),(0.55556,0.98413),(0.57143,0.98413),(0.5873,0.98413),(0.60317,0.98413),(0.61905,0.98413),(0.63492,0.98413),(0.65079,0.98413),(0.66667,0.98413),(0.68254,0.98413),(0.69841,0.98413),(0.71429,0.98413),(0.73016,0.98413),(0.74603,0.98413),(0.7619,0.98413),(0.77778,0.98413),(0.79365,0.98413),(0.80952,0.98413),(0.8254,0.98413),(0.84127,0.98413),(0.85714,0.98413),(0.87302,0.98413),(0.88889,0.98413),(0.90476,0.98413),(0.92063,0.98413),(0.93651,0.98413),(0.95238,0.98413),(0.96825,0.98413),(0.98413,0.98413),(0.99609,0.98413),(0.00391,0.99609),(0.01587,0.99609),(0.03175,0.99609),(0.04762,0.99609),(0.06349,0.99609),(0.07937,0.99609),(0.09524,0.99609),(0.11111,0.99609),(0.12698,0.99609),(0.14286,0.99609),(0.15873,0.99609),(0.1746,0.99609),(0.19048,0.99609),(0.20635,0.99609),(0.22222,0.99609),(0.2381,0.99609),(0.25397,0.99609),(0.26984,0.99609),(0.28571,0.99609),(0.30159,0.99609),(0.31746,0.99609),(0.33333,0.99609),(0.34921,0.99609),(0.36508,0.99609),(0.38095,0.99609),(0.39683,0.99609),(0.4127,0.99609),(0.42857,0.99609),(0.44444,0.99609),(0.46032,0.99609),(0.47619,0.99609),(0.49206,0.99609),(0.50794,0.99609),(0.52381,0.99609),(0.53968,0.99609),(0.55556,0.99609),(0.57143,0.99609),(0.5873,0.99609),(0.60317,0.99609),(0.61905,0.99609),(0.63492,0.99609),(0.65079,0.99609),(0.66667,0.99609),(0.68254,0.99609),(0.69841,0.99609),(0.71429,0.99609),(0.73016,0.99609),(0.74603,0.99609),(0.7619,0.99609),(0.77778,0.99609),(0.79365,0.99609),(0.80952,0.99609),(0.8254,0.99609),(0.84127,0.99609),(0.85714,0.99609),(0.87302,0.99609),(0.88889,0.99609),(0.90476,0.99609),(0.92063,0.99609),(0.93651,0.99609),(0.95238,0.99609),(0.96825,0.99609),(0.98413,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD016.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD016.py load and self-test diagnostics complete.")
