package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD015Index.html" target="_blank">MarsLOD015</a>,  source <a href="../../../Geospatial/MarsLOD015.java">MarsLOD015.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD015.x3d">MarsLOD015.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD015.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD015.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD015
{
	/** Default constructor to create this object. */
	public MarsLOD015 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD015.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD015.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD015.x3d"))
    .addChild(new GeoLOD().setCenter(45.000000,45.000000,-71800.000000).setRange(3.6E7).setChild1Url(new String[] {"MarsLOD016.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD016.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars005.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars005.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,0.000000,0.000000).setSolid(false).setXDimension(32).setXSpacing(2.903226).setYScale(50.0).setZDimension(32).setZSpacing(2.903226).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {-1245.0776,-1285.8411,-1000.8268,-824.9554,-380.76215,-169.71938,-147.6029,235.401,599.44446,967.997,1022.2208,1246.5522,936.8606,896.28143,902.0665,1234.6677,1715.1399,1957.8855,2163.4395,1750.8284,1668.0436,1835.7396,2040.0967,1952.2089,1867.9835,1635.5358,1326.9783,989.58636,876.09076,846.4521,603.117,39.084858,-1439.4521,-1354.8188,-1062.6648,-902.2267,-602.17474,-297.88144,-213.09673,24.976292,-22.308092,194.01564,447.80212,756.299,497.49875,217.87776,962.6231,1385.5604,1633.0728,1732.1577,1596.29,1615.0088,1566.4243,1731.077,1860.8683,1838.9116,1741.2433,1487.6951,1183.9291,772.96313,-159.0406,-1494.8121,-2027.515,-2151.8743,-1339.6028,-1286.4452,-958.62085,-778.7468,-646.3056,-610.3579,-349.7818,-72.6869,45.237656,70.085075,163.33736,199.28246,171.43628,346.37524,873.2717,1625.3566,1651.3535,1668.8651,1732.0548,1597.0348,1612.7664,1697.3987,1889.4441,1819.3542,1325.003,1480.7859,1016.8518,111.6433,-1890.0918,-3719.4856,-3820.1343,-3783.3306,-1420.7526,-1263.5898,-1122.6418,-965.7848};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {-810.5044,-647.82764,-405.78305,-201.93198,-80.86175,401.31775,183.29669,-38.1789,280.37216,409.71362,576.7606,872.28796,1045.518,1309.8302,1768.391,1634.2128,1658.6315,1726.7397,1828.9242,1620.8451,1369.2189,1471.4534,717.431,-1018.3761,-3282.658,-3865.3887,-3853.0422,-3804.5151,-1574.2535,-1323.3309,-1338.4761,-1279.4757,-1036.0143,-912.69385,-723.47253,-602.7324,-972.6156,101.76401,-111.68662,-271.27914,-250.4747,13.072268,559.31793,460.10022,496.37994,665.12085,1538.1832,1423.7472,1331.4113,1506.3434,1650.2507,1882.1989,1662.644,1069.0161,167.84131,-1810.7424,-3614.597,-3899.1938,-3860.467,-3759.863,-1730.5999,-1624.2761,-1514.324,-1325.6444,-1123.8665,-1186.4718,-1307.7229,-1303.0896,-763.8782,-282.33994,-405.57486,-552.4587,-958.5465,-774.0436,92.9052,-4.454953,275.45282,589.02576,892.6359,1033.8652,890.6968,1138.6547,1287.005,1368.4551,1179.7858,706.1113,-491.82278,-2438.8164,-3724.6316,-3832.86,-3797.9053,-3745.9153,-1962.687,-1853.8665,-1714.8802,-1478.5098,-1675.8527,-1678.3196,-1629.6362,-1711.4806};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {-1428.8723,-859.0674,-999.2139,-1086.0061,-975.0862,-115.144226,33.041267,-117.21783,151.96147,335.54016,547.2127,1139.3029,987.6874,991.5527,952.4126,915.46576,765.48346,130.3648,-836.29114,-2781.1396,-3697.118,-3750.456,-3715.679,-3674.609,-2043.7485,-1996.1603,-1768.3186,-1779.1606,-1889.484,-1802.548,-1675.4591,-1758.1968,-1362.137,-1481.5087,-1346.8264,-700.47125,-611.4775,-481.3993,-162.48741,230.89647,388.81375,231.4134,257.75995,648.3739,847.56366,294.4021,413.98108,728.7616,675.20166,26.805653,-257.14386,-1697.5417,-2995.5059,-3462.4443,-3541.0828,-3555.016,-2107.6416,-2027.0049,-1977.1754,-2081.9978,-2127.7551,-1908.4468,-1958.2079,-1699.411,-1302.849,-1325.3821,-1322.3065,-1231.0248,-681.4025,-562.1843,-337.59155,145.74533,267.10565,302.56613,298.708,625.7776,1061.6837,236.6331,419.38925,-101.53897,533.9659,326.93216,-96.59482,-686.2127,-1776.6237,-2487.4753,-2904.4873,-3222.4243,-2142.6204,-2303.6719,-2248.7764,-2135.8306,-2460.8237,-2059.3464,-1903.8068,-1585.2745,-1493.8529,-1539.2532,-1191.2161,-1595.9392};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {-968.20416,-1088.615,-794.5104,-757.3154,-422.90057,-802.01355,116.01535,458.76907,590.0904,757.8712,742.1144,621.35736,489.29456,455.27646,386.08707,-294.72873,-1117.8884,-2150.5972,-2447.894,-3205.638,-2291.378,-2418.8228,-2298.7424,-2279.8315,-2275.6833,-2136.056,-1743.2916,-1690.7765,-1409.3998,-1692.7892,-1078.833,-813.47986,-731.74066,-973.4406,-780.3823,-858.47614,-1087.5692,-1089.9658,-848.5281,-325.52866,68.473434,196.84099,60.51671,462.4989,425.98767,160.65047,-679.51697,-1222.1617,-1587.2137,-2220.4915,-2948.942,-3453.2712,-2525.489,-2405.4207,-2330.3315,-2528.3608,-2344.3914,-2025.5504,-1827.5964,-1810.6588,-1729.7338,-1770.6342,-1391.137,-918.24384,-668.5875,-805.68945,-595.41595,-667.93933,-1356.0724,-1481.2312,-1046.4806,-288.17352,-227.01558,-319.15933,-544.59863,45.064404,60.302746,-442.1955,-1879.1019,-1980.4034,-2510.1648,-3033.3037,-3382.227,-3629.6592,-2452.6194,-2323.4827,-2351.1196,-2292.1843,-2053.315,-2017.1472,-2166.4282,-1821.6698,-1640.7325,-1494.7736,-1842.0062,-943.943,-816.34424,-789.3241,-354.95987,-269.41165};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-734.4303,-624.48566,-438.56018,-476.8184,-690.7498,-1319.119,-1293.0641,-1078.0386,-817.1401,-1497.6943,-2204.2253,-2639.8018,-3015.5361,-3359.7246,-3562.8022,-3760.4636,-2937.6482,-2451.6362,-2317.426,-2414.4016,-2231.6072,-2406.4792,-2264.321,-2080.8193,-2195.2908,-1873.6637,-1811.3856,-1465.6384,-1134.7618,-741.1305,-369.67566,-71.77845,49.031906,240.68141,-93.265205,-411.18408,-1814.1685,-1901.1005,-1779.1782,-1954.3053,-2127.4182,-2399.3945,-2569.1145,-3006.7788,-3285.1611,-3558.9875,-3706.0596,-3917.7017,-3438.4304,-3147.723,-2967.649,-2765.6418,-2428.4292,-2278.64,-2436.1619,-2624.2302,-3211.981,-2221.893,-2517.3171,-1662.3253,-1468.2384,-1343.5079,-1076.4431,-300.1236,-703.1586,-145.81386,-603.86865,-793.78894,-2413.3147,-2358.213,-2326.1877,-2451.3674,-2626.975,-2791.9453,-3001.9758,-3227.4841,-3492.5576,-3687.646,-3829.2615,-4055.8408,-3893.8035,-3854.703,-3658.722,-3401.2095,-3062.1917,-2973.4812,-3190.0642,-3312.42,-3407.2952,-3073.879,-2730.0703,-2487.6353,-2422.3184,-1905.1434,-1552.6174,-2229.4937,-1818.5026,-1751.849,-2135.851,-2107.8765};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {-2535.534,-2547.8384,-2797.5205,-2959.1394,-3039.6355,-3120.5151,-3225.0417,-3499.5115,-3618.8105,-3754.3796,-3893.1094,-4163.737,-4185.328,-4144.268,-4003.4167,-3847.8347,-3648.6604,-3407.7783,-3658.5464,-3517.4749,-3234.8428,-3215.9385,-3099.2832,-3434.5676,-3436.9626,-2541.5212,-1943.6034,-2688.3438,-2196.3413,-2647.5786,-2407.3357,-2594.4426,-2783.0815,-2925.2288,-3058.9072,-3281.2832,-3334.1567,-3410.373,-3502.253,-3634.9626,-3720.0903,-3838.0828,-4011.1663,-4264.6875,-4381.748,-4290.9473,-4205.964,-4078.9805,-4020.107,-3921.208,-3850.1167,-3787.1882,-3770.417,-3680.484,-3654.6348,-3531.4116,-3477.0767,-3395.5076,-3065.212,-3039.3865,-3097.6921,-3043.3298,-2807.8022,-3024.8967,-3170.3499,-3238.772,-3359.8083,-3460.442,-3511.8147,-3571.9983,-3599.0627,-3712.6616,-3831.596,-3963.4265,-4164.056,-4495.122,-4514.8955,-4416.1587,-4316.687,-4213.541,-4135.005,-4064.8826,-4016.895,-3971.9268,-3919.2869,-3937.015,-4703.2476,-3550.8606,-3539.6106,-3538.2034,-3386.824,-3367.643,-3397.7578,-3437.213,-3377.8936,-3420.722,-3480.1982,-3479.0151,-3513.452,-3537.3667};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {-3575.9058,-3614.7202,-3649.1426,-3747.2632,-3874.1448,-4026.5222,-4221.8003,-4386.1514,-4577.4814,-4515.3843,-4433.695,-4338.1104,-4265.442,-4218.3594,-4163.265,-4076.5535,-4002.0317,-3850.778,-3518.0017,-3597.8315,-3714.0413,-3705.3428,-3665.4524,-3652.868,-3631.3982,-3628.1338,-3654.5544,-3708.141,-3724.439,-3669.496,-3613.1606,-3590.1633,-3626.799,-3610.7295,-3675.2793,-3770.9072,-3891.574,-4056.029,-4168.2827,-4232.8003,-4680.4067,-4608.125,-4539.974,-4446.4453,-4385.054,-4330.5317,-4263.2515,-4175.268,-4109.602,-4004.4343,-3947.978,-3899.696,-3862.3909,-3870.551,-3848.27,-3857.0447,-3858.6326,-3846.2695,-3895.716,-3899.8152,-3852.6235,-3787.9246,-3732.4568,-3673.668,-3638.1584,-3659.0244,-3724.2373,-3786.186,-3891.8364,-4016.3018,-4068.0144,-4153.2944,-4710.574,-4667.56,-4610.3833,-4525.2505,-4466.6475,-4417.6514,-4326.4272,-4246.868,-4195.552,-4137.0693,-4095.4214,-4044.7678,-3996.7385,-4003.43,-4026.1343,-4050.0396,-4057.7883,-4026.7083,-4052.474,-4031.1592,-3928.3376,-3879.272,-3838.4438,-3777.0002,-3737.5442,-3728.876,-3748.8823,-3804.338};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {-3874.421,-3935.6672,-4033.8145,-4048.859,-4757.4336,-4707.823,-4644.1816,-4620.2656,-4582.178,-4461.884,-4406.9023,-4341.1353,-4277.191,-4243.875,-4214.418,-4186.384,-4168.188,-4174.055,-4183.7397,-4191.756,-4195.4473,-4167.417,-4161.642,-4138.1636,-4074.638,-4022.4097,-3985.9634,-3906.9224,-3857.1453,-3816.563,-3783.2393,-3813.3801,-3841.9194,-3880.4915,-3920.0234,-3963.3608,-4813.592,-4745.4927,-4687.598,-4627.077,-4580.7935,-4523.877,-4483.841,-4437.758,-4384.8228,-4341.5034,-4339.5273,-4303.484,-4297.938,-4292.7197,-4284.844,-4288.6753,-4287.2603,-4236.85,-4232.584,-4215.223,-4205.3276,-4173.5273,-4130.58,-4062.4565,-3999.5205,-3943.9182,-3897.9377,-3872.029,-3863.7124,-3891.1313,-3914.1887,-3959.8882,-4838.3413,-4784.249,-4739.856,-4672.971,-4630.9653,-4582.1567,-4539.5146,-4488.483,-4470.2627,-4422.4487,-4396.653,-4376.181,-4364.917,-4344.705,-4328.993,-4366.2656,-4366.392,-4347.6396,-4305.793,-4300.4604,-4285.4277,-4269.201,-4242.0337,-4195.864,-4130.9653,-4091.371,-4032.0413,-3981.6145,-3928.0706,-3908.0493,-3905.38,-3923.381};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-4825.7705,-4776.0376,-4740.6313,-4714.103,-4662.3403,-4633.153,-4606.0576,-4560.782,-4526.809,-4499.8687,-4488.065,-4484.1143,-4460.0884,-4447.9634,-4426.5483,-4402.31,-4409.459,-4406.45,-4385.015,-4363.4053,-4336.6167,-4297.149,-4289.609,-4254.1733,-4218.468,-4195.9395,-4173.0913,-4141.4624,-4099.759,-4058.76,-4024.6182,-3989.9465,-4833.995,-4774.4287,-4745.862,-4709.6636,-4665.133,-4656.9097,-4629.4316,-4600.8594,-4569.4683,-4540.479,-4528.9253,-4518.0425,-4492.5874,-4476.836,-4477.116,-4480.5806,-4472.0293,-4461.5503,-4455.477,-4420.664,-4363.2437,-4357.137,-4366.4937,-4336.9805,-4302.179,-4272.6353,-4263.0903,-4241.0854,-4214.4453,-4185.5815,-4164.275,-4152.6006,-4832.8604,-4803.535,-4758.543,-4728.748,-4719.8984,-4694.183,-4644.161,-4626.1196,-4606.899,-4590.1426,-4579.3774,-4569.1123,-4548.036,-4545.674,-4546.2896,-4531.0454,-4518.4473,-4497.8394,-4485.027,-4475.367,-4434.4727,-4431.634,-4417.4683,-4419.3076,-4426.213,-4393.599,-4370.274,-4332.5083,-4326.401,-4315.5967,-4295.208,-4254.638,-4479.1084,-4508.517,-4480.7964,-4457.8057};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-4427.825,-4490.9355,-4483.606,-4409.6226,-4455.4814,-4511.281,-4562.3076,-4578.0103,-4595.117,-4584.317,-4573.494,-4576.587,-4546.6543,-4515.8906,-4514.432,-4512.1694,-4489.6416,-4445.644,-4436.8794,-4455.2397,-4465.2715,-4467.372,-4449.4326,-4447.2617,-4441.1924,-4431.876,-4411.184,-4378.9756,-3406.3025,-3470.722,-3340.9553,-3364.723,-3386.206,-3305.3474,-3267.3792,-3347.5317,-3426.8816,-3556.3684,-3498.5256,-3630.9849,-3665.7646,-3914.6252,-4043.6792,-3968.652,-4142.19,-4237.3867,-4209.8145,-4111.6777,-4122.9062,-4074.1877,-4103.6777,-4144.135,-4205.9097,-4198.6704,-4195.1978,-4159.6504,-4181.6396,-4205.7944,-4255.9985,-4298.447,-3591.9355,-3565.2542,-3397.7886,-3319.1868,-3262.7559,-3227.0122,-3188.2139,-3128.0261,-3095.0117,-3064.4543,-3037.86,-3025.512,-3015.575,-3021.8345,-3067.3088,-3126.5884,-3174.226,-3207.5913,-3242.458,-3272.2573,-3280.785,-3284.7593,-3301.0735,-3288.841,-3321.0642,-3297.0132,-3315.789,-3302.266,-3297.2437,-3309.729,-3326.1,-3328.223,-3066.6208,-3018.7688,-2885.952,-2837.0144,-2820.7395,-2814.2961,-2801.872,-2798.9832};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {-2713.886,-2700.3918,-2670.663,-2661.1765,-2649.3862,-2634.2703,-2622.3083,-2623.9531,-2591.609,-2571.6282,-2578.5596,-2608.8127,-2655.515,-2685.9705,-2676.477,-2687.2048,-2694.2056,-2715.0415,-2702.384,-2681.6897,-2702.5735,-2678.7346,-2659.0571,-2650.8972};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.03226,0.00391,0.06452,0.00391,0.09677,0.00391,0.12903,0.00391,0.16129,0.00391,0.19355,0.00391,0.22581,0.00391,0.25806,0.00391,0.29032,0.00391,0.32258,0.00391,0.35484,0.00391,0.3871,0.00391,0.41935,0.00391,0.45161,0.00391,0.48387,0.00391,0.51613,0.00391,0.54839,0.00391,0.58065,0.00391,0.6129,0.00391,0.64516,0.00391,0.67742,0.00391,0.70968,0.00391,0.74194,0.00391,0.77419,0.00391,0.80645,0.00391,0.83871,0.00391,0.87097,0.00391,0.90323,0.00391,0.93548,0.00391,0.96774,0.00391,0.99609,0.00391,0.00391,0.03226,0.03226,0.03226,0.06452,0.03226,0.09677,0.03226,0.12903,0.03226,0.16129,0.03226,0.19355,0.03226,0.22581,0.03226,0.25806,0.03226,0.29032,0.03226,0.32258,0.03226,0.35484,0.03226,0.3871,0.03226,0.41935,0.03226,0.45161,0.03226,0.48387,0.03226,0.51613,0.03226,0.54839,0.03226,0.58065,0.03226,0.6129,0.03226,0.64516,0.03226,0.67742,0.03226,0.70968,0.03226,0.74194,0.03226,0.77419,0.03226,0.80645,0.03226,0.83871,0.03226,0.87097,0.03226,0.90323,0.03226,0.93548,0.03226,0.96774,0.03226,0.99609,0.03226,0.00391,0.06452,0.03226,0.06452,0.06452,0.06452,0.09677,0.06452,0.12903,0.06452,0.16129,0.06452,0.19355,0.06452,0.22581,0.06452,0.25806,0.06452,0.29032,0.06452,0.32258,0.06452,0.35484,0.06452,0.3871,0.06452,0.41935,0.06452,0.45161,0.06452,0.48387,0.06452,0.51613,0.06452,0.54839,0.06452,0.58065,0.06452,0.6129,0.06452,0.64516,0.06452,0.67742,0.06452,0.70968,0.06452,0.74194,0.06452,0.77419,0.06452,0.80645,0.06452,0.83871,0.06452,0.87097,0.06452,0.90323,0.06452,0.93548,0.06452,0.96774,0.06452,0.99609,0.06452,0.00391,0.09677,0.03226,0.09677,0.06452,0.09677,0.09677,0.09677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.12903,0.09677,0.16129,0.09677,0.19355,0.09677,0.22581,0.09677,0.25806,0.09677,0.29032,0.09677,0.32258,0.09677,0.35484,0.09677,0.3871,0.09677,0.41935,0.09677,0.45161,0.09677,0.48387,0.09677,0.51613,0.09677,0.54839,0.09677,0.58065,0.09677,0.6129,0.09677,0.64516,0.09677,0.67742,0.09677,0.70968,0.09677,0.74194,0.09677,0.77419,0.09677,0.80645,0.09677,0.83871,0.09677,0.87097,0.09677,0.90323,0.09677,0.93548,0.09677,0.96774,0.09677,0.99609,0.09677,0.00391,0.12903,0.03226,0.12903,0.06452,0.12903,0.09677,0.12903,0.12903,0.12903,0.16129,0.12903,0.19355,0.12903,0.22581,0.12903,0.25806,0.12903,0.29032,0.12903,0.32258,0.12903,0.35484,0.12903,0.3871,0.12903,0.41935,0.12903,0.45161,0.12903,0.48387,0.12903,0.51613,0.12903,0.54839,0.12903,0.58065,0.12903,0.6129,0.12903,0.64516,0.12903,0.67742,0.12903,0.70968,0.12903,0.74194,0.12903,0.77419,0.12903,0.80645,0.12903,0.83871,0.12903,0.87097,0.12903,0.90323,0.12903,0.93548,0.12903,0.96774,0.12903,0.99609,0.12903,0.00391,0.16129,0.03226,0.16129,0.06452,0.16129,0.09677,0.16129,0.12903,0.16129,0.16129,0.16129,0.19355,0.16129,0.22581,0.16129,0.25806,0.16129,0.29032,0.16129,0.32258,0.16129,0.35484,0.16129,0.3871,0.16129,0.41935,0.16129,0.45161,0.16129,0.48387,0.16129,0.51613,0.16129,0.54839,0.16129,0.58065,0.16129,0.6129,0.16129,0.64516,0.16129,0.67742,0.16129,0.70968,0.16129,0.74194,0.16129,0.77419,0.16129,0.80645,0.16129,0.83871,0.16129,0.87097,0.16129,0.90323,0.16129,0.93548,0.16129,0.96774,0.16129,0.99609,0.16129,0.00391,0.19355,0.03226,0.19355,0.06452,0.19355,0.09677,0.19355,0.12903,0.19355,0.16129,0.19355,0.19355,0.19355,0.22581,0.19355};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.25806,0.19355,0.29032,0.19355,0.32258,0.19355,0.35484,0.19355,0.3871,0.19355,0.41935,0.19355,0.45161,0.19355,0.48387,0.19355,0.51613,0.19355,0.54839,0.19355,0.58065,0.19355,0.6129,0.19355,0.64516,0.19355,0.67742,0.19355,0.70968,0.19355,0.74194,0.19355,0.77419,0.19355,0.80645,0.19355,0.83871,0.19355,0.87097,0.19355,0.90323,0.19355,0.93548,0.19355,0.96774,0.19355,0.99609,0.19355,0.00391,0.22581,0.03226,0.22581,0.06452,0.22581,0.09677,0.22581,0.12903,0.22581,0.16129,0.22581,0.19355,0.22581,0.22581,0.22581,0.25806,0.22581,0.29032,0.22581,0.32258,0.22581,0.35484,0.22581,0.3871,0.22581,0.41935,0.22581,0.45161,0.22581,0.48387,0.22581,0.51613,0.22581,0.54839,0.22581,0.58065,0.22581,0.6129,0.22581,0.64516,0.22581,0.67742,0.22581,0.70968,0.22581,0.74194,0.22581,0.77419,0.22581,0.80645,0.22581,0.83871,0.22581,0.87097,0.22581,0.90323,0.22581,0.93548,0.22581,0.96774,0.22581,0.99609,0.22581,0.00391,0.25806,0.03226,0.25806,0.06452,0.25806,0.09677,0.25806,0.12903,0.25806,0.16129,0.25806,0.19355,0.25806,0.22581,0.25806,0.25806,0.25806,0.29032,0.25806,0.32258,0.25806,0.35484,0.25806,0.3871,0.25806,0.41935,0.25806,0.45161,0.25806,0.48387,0.25806,0.51613,0.25806,0.54839,0.25806,0.58065,0.25806,0.6129,0.25806,0.64516,0.25806,0.67742,0.25806,0.70968,0.25806,0.74194,0.25806,0.77419,0.25806,0.80645,0.25806,0.83871,0.25806,0.87097,0.25806,0.90323,0.25806,0.93548,0.25806,0.96774,0.25806,0.99609,0.25806,0.00391,0.29032,0.03226,0.29032,0.06452,0.29032,0.09677,0.29032,0.12903,0.29032,0.16129,0.29032,0.19355,0.29032,0.22581,0.29032,0.25806,0.29032,0.29032,0.29032,0.32258,0.29032,0.35484,0.29032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.3871,0.29032,0.41935,0.29032,0.45161,0.29032,0.48387,0.29032,0.51613,0.29032,0.54839,0.29032,0.58065,0.29032,0.6129,0.29032,0.64516,0.29032,0.67742,0.29032,0.70968,0.29032,0.74194,0.29032,0.77419,0.29032,0.80645,0.29032,0.83871,0.29032,0.87097,0.29032,0.90323,0.29032,0.93548,0.29032,0.96774,0.29032,0.99609,0.29032,0.00391,0.32258,0.03226,0.32258,0.06452,0.32258,0.09677,0.32258,0.12903,0.32258,0.16129,0.32258,0.19355,0.32258,0.22581,0.32258,0.25806,0.32258,0.29032,0.32258,0.32258,0.32258,0.35484,0.32258,0.3871,0.32258,0.41935,0.32258,0.45161,0.32258,0.48387,0.32258,0.51613,0.32258,0.54839,0.32258,0.58065,0.32258,0.6129,0.32258,0.64516,0.32258,0.67742,0.32258,0.70968,0.32258,0.74194,0.32258,0.77419,0.32258,0.80645,0.32258,0.83871,0.32258,0.87097,0.32258,0.90323,0.32258,0.93548,0.32258,0.96774,0.32258,0.99609,0.32258,0.00391,0.35484,0.03226,0.35484,0.06452,0.35484,0.09677,0.35484,0.12903,0.35484,0.16129,0.35484,0.19355,0.35484,0.22581,0.35484,0.25806,0.35484,0.29032,0.35484,0.32258,0.35484,0.35484,0.35484,0.3871,0.35484,0.41935,0.35484,0.45161,0.35484,0.48387,0.35484,0.51613,0.35484,0.54839,0.35484,0.58065,0.35484,0.6129,0.35484,0.64516,0.35484,0.67742,0.35484,0.70968,0.35484,0.74194,0.35484,0.77419,0.35484,0.80645,0.35484,0.83871,0.35484,0.87097,0.35484,0.90323,0.35484,0.93548,0.35484,0.96774,0.35484,0.99609,0.35484,0.00391,0.3871,0.03226,0.3871,0.06452,0.3871,0.09677,0.3871,0.12903,0.3871,0.16129,0.3871,0.19355,0.3871,0.22581,0.3871,0.25806,0.3871,0.29032,0.3871,0.32258,0.3871,0.35484,0.3871,0.3871,0.3871,0.41935,0.3871,0.45161,0.3871,0.48387,0.3871};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.51613,0.3871,0.54839,0.3871,0.58065,0.3871,0.6129,0.3871,0.64516,0.3871,0.67742,0.3871,0.70968,0.3871,0.74194,0.3871,0.77419,0.3871,0.80645,0.3871,0.83871,0.3871,0.87097,0.3871,0.90323,0.3871,0.93548,0.3871,0.96774,0.3871,0.99609,0.3871,0.00391,0.41935,0.03226,0.41935,0.06452,0.41935,0.09677,0.41935,0.12903,0.41935,0.16129,0.41935,0.19355,0.41935,0.22581,0.41935,0.25806,0.41935,0.29032,0.41935,0.32258,0.41935,0.35484,0.41935,0.3871,0.41935,0.41935,0.41935,0.45161,0.41935,0.48387,0.41935,0.51613,0.41935,0.54839,0.41935,0.58065,0.41935,0.6129,0.41935,0.64516,0.41935,0.67742,0.41935,0.70968,0.41935,0.74194,0.41935,0.77419,0.41935,0.80645,0.41935,0.83871,0.41935,0.87097,0.41935,0.90323,0.41935,0.93548,0.41935,0.96774,0.41935,0.99609,0.41935,0.00391,0.45161,0.03226,0.45161,0.06452,0.45161,0.09677,0.45161,0.12903,0.45161,0.16129,0.45161,0.19355,0.45161,0.22581,0.45161,0.25806,0.45161,0.29032,0.45161,0.32258,0.45161,0.35484,0.45161,0.3871,0.45161,0.41935,0.45161,0.45161,0.45161,0.48387,0.45161,0.51613,0.45161,0.54839,0.45161,0.58065,0.45161,0.6129,0.45161,0.64516,0.45161,0.67742,0.45161,0.70968,0.45161,0.74194,0.45161,0.77419,0.45161,0.80645,0.45161,0.83871,0.45161,0.87097,0.45161,0.90323,0.45161,0.93548,0.45161,0.96774,0.45161,0.99609,0.45161,0.00391,0.48387,0.03226,0.48387,0.06452,0.48387,0.09677,0.48387,0.12903,0.48387,0.16129,0.48387,0.19355,0.48387,0.22581,0.48387,0.25806,0.48387,0.29032,0.48387,0.32258,0.48387,0.35484,0.48387,0.3871,0.48387,0.41935,0.48387,0.45161,0.48387,0.48387,0.48387,0.51613,0.48387,0.54839,0.48387,0.58065,0.48387,0.6129,0.48387};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.64516,0.48387,0.67742,0.48387,0.70968,0.48387,0.74194,0.48387,0.77419,0.48387,0.80645,0.48387,0.83871,0.48387,0.87097,0.48387,0.90323,0.48387,0.93548,0.48387,0.96774,0.48387,0.99609,0.48387,0.00391,0.51613,0.03226,0.51613,0.06452,0.51613,0.09677,0.51613,0.12903,0.51613,0.16129,0.51613,0.19355,0.51613,0.22581,0.51613,0.25806,0.51613,0.29032,0.51613,0.32258,0.51613,0.35484,0.51613,0.3871,0.51613,0.41935,0.51613,0.45161,0.51613,0.48387,0.51613,0.51613,0.51613,0.54839,0.51613,0.58065,0.51613,0.6129,0.51613,0.64516,0.51613,0.67742,0.51613,0.70968,0.51613,0.74194,0.51613,0.77419,0.51613,0.80645,0.51613,0.83871,0.51613,0.87097,0.51613,0.90323,0.51613,0.93548,0.51613,0.96774,0.51613,0.99609,0.51613,0.00391,0.54839,0.03226,0.54839,0.06452,0.54839,0.09677,0.54839,0.12903,0.54839,0.16129,0.54839,0.19355,0.54839,0.22581,0.54839,0.25806,0.54839,0.29032,0.54839,0.32258,0.54839,0.35484,0.54839,0.3871,0.54839,0.41935,0.54839,0.45161,0.54839,0.48387,0.54839,0.51613,0.54839,0.54839,0.54839,0.58065,0.54839,0.6129,0.54839,0.64516,0.54839,0.67742,0.54839,0.70968,0.54839,0.74194,0.54839,0.77419,0.54839,0.80645,0.54839,0.83871,0.54839,0.87097,0.54839,0.90323,0.54839,0.93548,0.54839,0.96774,0.54839,0.99609,0.54839,0.00391,0.58065,0.03226,0.58065,0.06452,0.58065,0.09677,0.58065,0.12903,0.58065,0.16129,0.58065,0.19355,0.58065,0.22581,0.58065,0.25806,0.58065,0.29032,0.58065,0.32258,0.58065,0.35484,0.58065,0.3871,0.58065,0.41935,0.58065,0.45161,0.58065,0.48387,0.58065,0.51613,0.58065,0.54839,0.58065,0.58065,0.58065,0.6129,0.58065,0.64516,0.58065,0.67742,0.58065,0.70968,0.58065,0.74194,0.58065};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.77419,0.58065,0.80645,0.58065,0.83871,0.58065,0.87097,0.58065,0.90323,0.58065,0.93548,0.58065,0.96774,0.58065,0.99609,0.58065,0.00391,0.6129,0.03226,0.6129,0.06452,0.6129,0.09677,0.6129,0.12903,0.6129,0.16129,0.6129,0.19355,0.6129,0.22581,0.6129,0.25806,0.6129,0.29032,0.6129,0.32258,0.6129,0.35484,0.6129,0.3871,0.6129,0.41935,0.6129,0.45161,0.6129,0.48387,0.6129,0.51613,0.6129,0.54839,0.6129,0.58065,0.6129,0.6129,0.6129,0.64516,0.6129,0.67742,0.6129,0.70968,0.6129,0.74194,0.6129,0.77419,0.6129,0.80645,0.6129,0.83871,0.6129,0.87097,0.6129,0.90323,0.6129,0.93548,0.6129,0.96774,0.6129,0.99609,0.6129,0.00391,0.64516,0.03226,0.64516,0.06452,0.64516,0.09677,0.64516,0.12903,0.64516,0.16129,0.64516,0.19355,0.64516,0.22581,0.64516,0.25806,0.64516,0.29032,0.64516,0.32258,0.64516,0.35484,0.64516,0.3871,0.64516,0.41935,0.64516,0.45161,0.64516,0.48387,0.64516,0.51613,0.64516,0.54839,0.64516,0.58065,0.64516,0.6129,0.64516,0.64516,0.64516,0.67742,0.64516,0.70968,0.64516,0.74194,0.64516,0.77419,0.64516,0.80645,0.64516,0.83871,0.64516,0.87097,0.64516,0.90323,0.64516,0.93548,0.64516,0.96774,0.64516,0.99609,0.64516,0.00391,0.67742,0.03226,0.67742,0.06452,0.67742,0.09677,0.67742,0.12903,0.67742,0.16129,0.67742,0.19355,0.67742,0.22581,0.67742,0.25806,0.67742,0.29032,0.67742,0.32258,0.67742,0.35484,0.67742,0.3871,0.67742,0.41935,0.67742,0.45161,0.67742,0.48387,0.67742,0.51613,0.67742,0.54839,0.67742,0.58065,0.67742,0.6129,0.67742,0.64516,0.67742,0.67742,0.67742,0.70968,0.67742,0.74194,0.67742,0.77419,0.67742,0.80645,0.67742,0.83871,0.67742,0.87097,0.67742};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.90323,0.67742,0.93548,0.67742,0.96774,0.67742,0.99609,0.67742,0.00391,0.70968,0.03226,0.70968,0.06452,0.70968,0.09677,0.70968,0.12903,0.70968,0.16129,0.70968,0.19355,0.70968,0.22581,0.70968,0.25806,0.70968,0.29032,0.70968,0.32258,0.70968,0.35484,0.70968,0.3871,0.70968,0.41935,0.70968,0.45161,0.70968,0.48387,0.70968,0.51613,0.70968,0.54839,0.70968,0.58065,0.70968,0.6129,0.70968,0.64516,0.70968,0.67742,0.70968,0.70968,0.70968,0.74194,0.70968,0.77419,0.70968,0.80645,0.70968,0.83871,0.70968,0.87097,0.70968,0.90323,0.70968,0.93548,0.70968,0.96774,0.70968,0.99609,0.70968,0.00391,0.74194,0.03226,0.74194,0.06452,0.74194,0.09677,0.74194,0.12903,0.74194,0.16129,0.74194,0.19355,0.74194,0.22581,0.74194,0.25806,0.74194,0.29032,0.74194,0.32258,0.74194,0.35484,0.74194,0.3871,0.74194,0.41935,0.74194,0.45161,0.74194,0.48387,0.74194,0.51613,0.74194,0.54839,0.74194,0.58065,0.74194,0.6129,0.74194,0.64516,0.74194,0.67742,0.74194,0.70968,0.74194,0.74194,0.74194,0.77419,0.74194,0.80645,0.74194,0.83871,0.74194,0.87097,0.74194,0.90323,0.74194,0.93548,0.74194,0.96774,0.74194,0.99609,0.74194,0.00391,0.77419,0.03226,0.77419,0.06452,0.77419,0.09677,0.77419,0.12903,0.77419,0.16129,0.77419,0.19355,0.77419,0.22581,0.77419,0.25806,0.77419,0.29032,0.77419,0.32258,0.77419,0.35484,0.77419,0.3871,0.77419,0.41935,0.77419,0.45161,0.77419,0.48387,0.77419,0.51613,0.77419,0.54839,0.77419,0.58065,0.77419,0.6129,0.77419,0.64516,0.77419,0.67742,0.77419,0.70968,0.77419,0.74194,0.77419,0.77419,0.77419,0.80645,0.77419,0.83871,0.77419,0.87097,0.77419,0.90323,0.77419,0.93548,0.77419,0.96774,0.77419,0.99609,0.77419};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.80645,0.03226,0.80645,0.06452,0.80645,0.09677,0.80645,0.12903,0.80645,0.16129,0.80645,0.19355,0.80645,0.22581,0.80645,0.25806,0.80645,0.29032,0.80645,0.32258,0.80645,0.35484,0.80645,0.3871,0.80645,0.41935,0.80645,0.45161,0.80645,0.48387,0.80645,0.51613,0.80645,0.54839,0.80645,0.58065,0.80645,0.6129,0.80645,0.64516,0.80645,0.67742,0.80645,0.70968,0.80645,0.74194,0.80645,0.77419,0.80645,0.80645,0.80645,0.83871,0.80645,0.87097,0.80645,0.90323,0.80645,0.93548,0.80645,0.96774,0.80645,0.99609,0.80645,0.00391,0.83871,0.03226,0.83871,0.06452,0.83871,0.09677,0.83871,0.12903,0.83871,0.16129,0.83871,0.19355,0.83871,0.22581,0.83871,0.25806,0.83871,0.29032,0.83871,0.32258,0.83871,0.35484,0.83871,0.3871,0.83871,0.41935,0.83871,0.45161,0.83871,0.48387,0.83871,0.51613,0.83871,0.54839,0.83871,0.58065,0.83871,0.6129,0.83871,0.64516,0.83871,0.67742,0.83871,0.70968,0.83871,0.74194,0.83871,0.77419,0.83871,0.80645,0.83871,0.83871,0.83871,0.87097,0.83871,0.90323,0.83871,0.93548,0.83871,0.96774,0.83871,0.99609,0.83871,0.00391,0.87097,0.03226,0.87097,0.06452,0.87097,0.09677,0.87097,0.12903,0.87097,0.16129,0.87097,0.19355,0.87097,0.22581,0.87097,0.25806,0.87097,0.29032,0.87097,0.32258,0.87097,0.35484,0.87097,0.3871,0.87097,0.41935,0.87097,0.45161,0.87097,0.48387,0.87097,0.51613,0.87097,0.54839,0.87097,0.58065,0.87097,0.6129,0.87097,0.64516,0.87097,0.67742,0.87097,0.70968,0.87097,0.74194,0.87097,0.77419,0.87097,0.80645,0.87097,0.83871,0.87097,0.87097,0.87097,0.90323,0.87097,0.93548,0.87097,0.96774,0.87097,0.99609,0.87097,0.00391,0.90323,0.03226,0.90323,0.06452,0.90323,0.09677,0.90323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.12903,0.90323,0.16129,0.90323,0.19355,0.90323,0.22581,0.90323,0.25806,0.90323,0.29032,0.90323,0.32258,0.90323,0.35484,0.90323,0.3871,0.90323,0.41935,0.90323,0.45161,0.90323,0.48387,0.90323,0.51613,0.90323,0.54839,0.90323,0.58065,0.90323,0.6129,0.90323,0.64516,0.90323,0.67742,0.90323,0.70968,0.90323,0.74194,0.90323,0.77419,0.90323,0.80645,0.90323,0.83871,0.90323,0.87097,0.90323,0.90323,0.90323,0.93548,0.90323,0.96774,0.90323,0.99609,0.90323,0.00391,0.93548,0.03226,0.93548,0.06452,0.93548,0.09677,0.93548,0.12903,0.93548,0.16129,0.93548,0.19355,0.93548,0.22581,0.93548,0.25806,0.93548,0.29032,0.93548,0.32258,0.93548,0.35484,0.93548,0.3871,0.93548,0.41935,0.93548,0.45161,0.93548,0.48387,0.93548,0.51613,0.93548,0.54839,0.93548,0.58065,0.93548,0.6129,0.93548,0.64516,0.93548,0.67742,0.93548,0.70968,0.93548,0.74194,0.93548,0.77419,0.93548,0.80645,0.93548,0.83871,0.93548,0.87097,0.93548,0.90323,0.93548,0.93548,0.93548,0.96774,0.93548,0.99609,0.93548,0.00391,0.96774,0.03226,0.96774,0.06452,0.96774,0.09677,0.96774,0.12903,0.96774,0.16129,0.96774,0.19355,0.96774,0.22581,0.96774,0.25806,0.96774,0.29032,0.96774,0.32258,0.96774,0.35484,0.96774,0.3871,0.96774,0.41935,0.96774,0.45161,0.96774,0.48387,0.96774,0.51613,0.96774,0.54839,0.96774,0.58065,0.96774,0.6129,0.96774,0.64516,0.96774,0.67742,0.96774,0.70968,0.96774,0.74194,0.96774,0.77419,0.96774,0.80645,0.96774,0.83871,0.96774,0.87097,0.96774,0.90323,0.96774,0.93548,0.96774,0.96774,0.96774,0.99609,0.96774,0.00391,0.99609,0.03226,0.99609,0.06452,0.99609,0.09677,0.99609,0.12903,0.99609,0.16129,0.99609,0.19355,0.99609,0.22581,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.25806,0.99609,0.29032,0.99609,0.32258,0.99609,0.35484,0.99609,0.3871,0.99609,0.41935,0.99609,0.45161,0.99609,0.48387,0.99609,0.51613,0.99609,0.54839,0.99609,0.58065,0.99609,0.6129,0.99609,0.64516,0.99609,0.67742,0.99609,0.70968,0.99609,0.74194,0.99609,0.77419,0.99609,0.80645,0.99609,0.83871,0.99609,0.87097,0.99609,0.90323,0.99609,0.93548,0.99609,0.96774,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 1024 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 2048 total numbers made up of 1024 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD015 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD015().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD015\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD015 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD015_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD015_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD015_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD015_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
