package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD013Index.html" target="_blank">MarsLOD013</a>,  source <a href="../../../Geospatial/MarsLOD013.java">MarsLOD013.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD013.x3d">MarsLOD013.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD013.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD013.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD013
{
	/** Default constructor to create this object. */
	public MarsLOD013 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD013.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD013.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD013.x3d"))
    .addChild(new GeoLOD().setCenter(-44.940476,45.000000,-71025.000000).setRange(1.8E7).setChild1Url(new String[] {"MarsLOD014.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD014.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars004.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars004.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(-90.000000,0.000000,0.000000).setSolid(false).setXDimension(64).setXSpacing(1.428571).setYScale(50.0).setZDimension(64).setZSpacing(1.428571).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {4328.7573,4328.3833,4311.3423,4298.695,4289.965,4275.9062,4266.453,4264.337,4259.08,4277.746,4215.48,4152.1865,4209.26,4195.181,4183.79,4172.316,4162.0483,4164.0815,4157.6797,4136.9688,4118.226,4102.526,4082.851,4076.175,4066.8696,4066.664,4067.1204,4065.5713,4060.5474,4057.4614,4065.8337,4068.6704,4066.075,4058.4426,4044.3416,4039.9004,4034.47,4017.1865,3998.5725,3984.0771,3947.1057,3946.4941,3960.218,3938.9934,3929.6782,3935.5815,3918.5825,3882.5623,3836.2717,3796.7505,3805.6628,3806.8135,3794.33,3778.1736,3752.7153,3752.7754,3759.1235,3732.8384,3683.4844,3652.449,3625.9265,3628.9958,3599.99,3561.9143,4618.373,4604.6763,4594.6157,4571.374,4546.0347,4520.8286,4483.0503,4375.851,4359.8945,4369.4287,4299.552,4204.7134,4232.4224,4181.8096,4151.7656,4125.9478,4096.4165,4061.747,4026.3384,3991.3071,3961.663,3923.422,3916.9749,3910.6028,3890.6025,3859.07,3832.3115,3808.0503,3795.0125,3798.6387,3808.5771,3811.0972,3809.314,3807.7346,3802.0557,3794.0913};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {3783.2075,3771.219,3759.6033,3744.326,3722.5247,3704.5732,3672.3677,3649.0808,3634.2634,3632.6458,3611.1343,3568.8167,3519.1106,3492.1338,3487.7102,3481.6348,3461.7478,3441.2222,3412.6277,3408.922,3413.0254,3396.4126,3383.9773,3377.8945,3364.965,3330.9033,3275.1917,3211.6885,4064.4702,4042.4426,4023.3323,3997.6057,3977.4568,3945.8523,3912.9504,3889.2944,3869.7441,3829.3098,3767.0325,3763.1052,3770.9204,3768.7903,3751.0564,3697.4922,3625.2795,3559.57,3497.993,3457.4675,3430.7144,3397.8887,3365.4158,3348.408,3339.585,3335.956,3335.0,3309.1255,3264.16,3229.4592,3225.6377,3234.8738,3212.3125,3170.973,3168.945,3236.543,3305.6714,3338.809,3340.3457,3330.843,3312.8914,3292.312,3272.0132,3252.183,3229.3005,3200.5637,3169.95,3138.503,3101.0637,3070.2603,3031.2434,2991.845,2985.9365,3003.0767,3031.109,3062.8892,3088.7253,3100.9817,3107.8206,3111.054,3114.5603,3113.1157,3103.9863,3078.032,2286.028,2359.1506,2515.8901,2535.9424,2524.785,2550.4443,2606.318,2641.8862};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2658.9272,2675.1448,2682.806,2664.8843,2659.5188,2637.672,2602.5427,2656.8486,2786.078,2811.0598,2834.331,2799.405,2770.733,2722.225,2698.0623,2674.4407,2654.3496,2641.5457,2608.6184,2579.3337,2572.6594,2572.2024,2568.6187,2534.8884,2523.5068,2541.8142,2539.834,2546.2703,2561.9724,2573.5308,2584.9033,2609.5735,2638.3833,2655.4612,2677.6284,2707.1501,2749.6504,2751.991,2745.3982,2735.9924,2725.12,2733.6855,2770.4473,2800.83,2806.5881,2802.4731,2785.9663,2791.7676,2802.583,2797.4949,2789.6685,2777.616,2754.7327,2743.5398,2732.2483,2676.369,2110.1863,2139.025,2137.5852,2089.237,2038.5365,2093.216,2184.5518,2315.3733,2396.7869,2440.1074,2431.5056,2368.6611,2297.983,2322.1284,2312.6814,2287.904,2289.6206,2286.778,2388.8064,2299.6477,2240.5962,2120.9473,2022.8956,2001.5518,1975.7513,2010.9255,2033.7611,2026.6414,2036.581,2101.843,2101.387,2007.5098,1943.4552,1848.9714,1723.4121,1666.4198,1672.6764,1726.542,1772.3341,1864.0431,1979.8353,2083.3972,2128.3318,2139.5889};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2141.645,2176.2827,2212.9617,2240.054,2255.2646,2276.9795,2291.4263,2301.8176,2319.4978,2330.5964,2332.1394,2311.0432,2291.473,2285.771,2287.8538,2269.348,2222.2134,2122.344,1990.6508,1789.2852,2059.716,2077.246,2094.7139,2128.83,2118.8772,2192.1035,2291.2124,2454.6602,2692.0098,2920.0881,3052.2188,3042.1184,2910.716,2810.948,2674.5938,2443.9666,2264.0042,2204.1675,2145.633,2107.9543,2017.9042,1905.751,1782.0432,1700.9724,1637.367,1570.0068,1532.0901,1602.6539,1836.7133,1770.7083,1689.0046,1630.4497,1570.757,1460.6584,1396.8257,1347.3536,1300.7838,1273.8558,1261.625,1260.0441,1298.7485,1324.9026,1341.1196,1370.3085,1404.9089,1417.2651,1438.5977,1461.1467,1492.6836,1446.944,1528.7576,1631.8961,1648.4131,1622.7516,1594.4502,1583.4878,1548.2279,1483.5065,1413.464,1373.3376,1339.0985,1273.2422,1157.0931,1097.1581,1705.6042,1712.994,1830.3008,1867.7156,1918.2828,2033.777,2253.0056,2392.854,2515.3494,2646.36,2584.4773,2478.9233,2329.4324,2292.5684,2273.0422,2156.1377};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {1951.4113,1871.7881,1804.7097,1799.4404,1756.3021,1657.7932,1583.9434,1553.1028,1489.0741,1454.3142,1450.5902,1384.1327,1501.5289,1486.4506,1487.1514,1569.1128,1676.8124,1614.6573,1592.7872,1559.8553,1428.0426,1379.247,1258.1118,1175.4708,1148.2528,1114.9917,1083.5267,1051.5686,1033.4811,1039.1327,1068.658,1093.4851,1107.6882,991.37555,1086.1979,1190.3804,1188.8743,1157.1165,1156.7578,1140.0402,1111.2252,1113.1958,1086.1516,1051.4834,1056.4055,1081.5914,1036.8445,989.28674,1803.31,1710.387,1739.6759,1769.1946,1861.8,1999.2651,2164.717,2212.1606,2312.3486,2470.122,2423.868,2340.941,1982.1149,1825.7406,1897.08,1891.4565,1779.744,1694.0494,1677.4851,1642.5654,1581.8054,1452.156,1401.2518,1399.4352,1407.863,1464.7485,1527.1067,1518.0021,1614.9545,1565.2617,1515.193,1610.695,1610.5968,1614.6028,1735.5964,1881.7081,1866.9977,1634.451,1692.9231,1771.3983,1136.7719,1037.4237,1036.6136,1040.6533,1076.4622,1063.1201,1009.30634,989.39294,975.1824,977.44904,1019.0411,1121.6493};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1075.7004,1055.334,1041.6644,1015.3166,1029.8439,1076.3525,1116.4938,1108.401,1042.8351,1052.0197,1040.5847,1049.1122,1751.5452,1713.4222,1769.0272,1879.5891,1881.0527,1949.2891,2035.031,2154.8315,2370.8455,2476.0183,2406.5852,2283.932,1982.9874,1713.6868,1147.9017,1096.0239,990.8733,1084.8347,1720.4109,1618.8536,1548.9999,1578.9647,1537.8896,1532.708,1522.0453,1493.1433,1549.4618,1449.1199,1452.012,1512.8033,1530.5905,1626.1692,1580.3452,1367.1229,1168.624,1250.7158,1409.1575,1627.686,1764.0615,1954.5798,1991.9988,1926.1052,2004.3035,2074.9277,2009.0128,2055.661,1836.0662,1820.1914,1628.4355,1514.6346,1361.2377,1404.6663,1459.9525,1548.8375,1559.8868,1551.5139,1579.6304,1635.0294,1355.6224,1128.2499,1199.5944,1490.2115,1320.4922,1210.8119,1567.5132,1587.0944,1659.4626,1734.1565,1658.0356,1670.4879,1680.6821,1705.589,1722.8502,1733.5312,1750.8364,1706.1608,1762.5809,1756.725,1623.4222,1484.2274,1474.4746,1501.7,1596.5026,1538.0065,1534.0138,1607.4908,1567.7023,1536.8885};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1747.3708,1561.466,1523.7252,1534.4961,1587.051,1613.429,1652.3489,1895.705,1566.664,1244.909,1515.409,1535.7758,1760.6011,1763.3817,1884.1768,2106.1157,2135.488,2197.1794,2257.561,2292.8967,2379.8318,2163.6062,2063.8147,2088.1487,2046.2216,1931.1345,1355.2587,1136.4901,1677.6338,1998.9181,2001.3756,1971.3833,2121.1772,2027.8037,1729.5977,1179.1718,1635.0513,1907.0161,1582.8904,1639.1044,1566.0377,1696.0192,1810.9257,1749.4225,1777.4843,1701.5629,1627.4929,1497.7126,1451.8308,1423.9314,1414.3158,1411.5585,1375.5231,1355.1587,1395.1588,1457.948,1460.2605,1426.4218,1451.2693,1490.5476,1350.8319,1308.5759,1293.3235,1304.7657,1350.4443,1265.131,1475.9126,1617.061,1755.8098,1863.3871,1896.4363,2012.8229,2037.0674,2066.4194,2055.8545,2054.179,2134.5889,2046.2095,2068.441,2200.3618,2012.2522,1843.8094,1874.9877,1993.3906,2011.1538,2030.1924,1804.0374,1667.3693,1930.9404,2382.7107,2176.216,1798.8649,1892.8909,1840.7198,1864.3068,1919.4729,1994.1884,1895.279,1671.4993,1471.3694};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1417.2557,1305.1311,1316.2277,1381.3424,1399.7056,1398.8707,1475.8417,1563.9586,1579.614,1489.1262,1468.3442,1418.0111,1361.8483,1277.7291,1257.0107,1260.5292,1256.1422,1256.5961,1258.206,1256.5966,1253.1691,1233.8878,1215.0468,1208.583,1232.0743,1368.5192,1387.4253,1373.6217,1464.8354,1542.4786,1728.166,1708.1449,1963.0865,2087.224,2210.2717,2191.1333,1883.2675,1741.0092,1561.7205,1571.5139,1603.6453,1575.6442,1590.9486,1679.5093,1591.3414,1572.4073,1596.6359,1641.1385,1838.6849,1928.9136,1976.2087,1927.0012,2011.9325,1965.7538,1893.009,1815.5342,1716.5157,1611.816,1591.4569,1530.7301,1702.4188,1510.2167,1091.8655,1346.6073,1466.5442,1417.4275,1170.0789,1204.8469,889.0193,977.3574,1127.326,1283.6592,1287.5692,1280.3363,1289.4838,1283.8728,1321.4832,1265.109,1316.1974,1355.5557,1224.6384,1185.1868,1174.1227,1215.1266,1238.7458,1238.872,1227.9669,1214.9515,1233.8422,1225.3778,1380.8969,1614.4309,1822.4634,1873.0328,1761.0897,1709.9585,1757.8564,1750.3219,1799.3759,1711.2968};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1574.9813,1477.3553,1402.5249,1371.2739,1342.2151,1293.1824,1342.8512,1406.4432,1360.6401,1219.698,1235.0302,1381.833,1414.146,1286.6787,1210.6316,1283.0573,1019.7706,1443.1998,1515.2643,1557.2716,1623.4222,1654.1824,1169.3593,946.414,1178.2668,1082.5406,664.2807,1238.7041,1429.3105,1570.2217,1270.1013,323.16293,1190.656,1186.2412,1157.5409,1244.2942,1250.571,1214.4384,1136.1396,1124.6632,1137.7681,1142.9006,1242.0336,1511.2302,1230.1963,1105.3379,918.90643,1145.228,1297.7682,1125.894,1133.4674,1217.7816,1188.466,1178.0803,1395.5558,1855.1619,2065.819,1815.099,1607.5535,1486.1885,1474.035,1542.5992,1461.0209,1491.4602,1529.4053,1530.844,1374.6016,1320.7878,1348.2666,1431.3566,1452.3779,1395.4304,1318.2888,1274.0929,1132.7018,1003.66296,985.85254,928.80914,1008.69104,946.9723,982.79565,1079.7914,1214.7877,1463.805,1354.8707,1551.7612,1443.4099,1203.6005,1277.2042,1254.6139,1245.5391,1400.1584,1642.4757,1942.1051,1753.475,1634.7148,1396.7421,1181.8647,1258.7784,1413.2308};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {1318.5483,1167.8125,1108.372,1126.6857,1250.4536,1090.9408,1069.3912,1079.3867,1085.4,1081.5687,1030.6656,1027.6849,1070.4161,1027.6978,1041.3937,1069.2762,1280.8639,1707.9146,1910.2004,1761.736,1100.6422,728.19446,796.817,1049.7087,1104.1577,1151.4049,1223.2426,1275.7167,1366.517,1371.6099,1427.6868,1496.9482,1651.7382,1470.8845,1186.3411,1003.66846,835.2402,731.7759,674.13336,653.94476,675.89813,634.352,615.59784,600.68243,618.593,627.4443,688.27124,933.299,962.17,852.16785,946.1135,1452.3488,1658.3381,1433.2094,1724.4763,1531.8959,1163.9907,1053.8048,1098.1523,1839.5093,1400.4131,1362.8379,1236.2584,1235.8143,1188.7418,1123.3022,1111.6244,1093.081,1048.8098,1082.1501,1138.1536,1203.5883,1206.4235,1226.7773,1270.1707,1397.3607,1589.6783,1672.9532,1487.2401,1526.7284,1845.3499,2037.3882,1743.0623,976.31213,403.78116,213.15312,290.16098,673.6839,1018.40796,947.12366,1096.0283,1174.4877,1226.4982,1418.7633,1458.1104,1442.0583,1314.5342,1125.5664,990.0094,836.17676};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {700.0796,628.60394,596.7714,638.73566,650.34424,607.2434,566.58417,581.9462,588.8818,560.1815,445.29913,545.66486,344.98117,310.42532,333.6448,666.0319,1170.5613,1609.765,1967.1213,1789.2549,1203.9897,1138.3389,1582.044,1859.0186,1237.775,1243.1908,1264.9661,1245.8157,1220.1456,1136.5142,1134.1104,1119.6903,1078.9973,1048.5607,1102.3176,1195.4946,1184.2896,1211.0658,1398.8691,1549.8796,1586.9242,1629.1217,1657.3138,1679.698,1857.0377,1863.2413,1618.0974,1235.1669,871.77637,733.13416,725.30554,808.9942,1049.9517,1298.6249,1394.3351,1444.9271,1445.0774,1366.0353,1300.7678,1113.6888,887.2846,775.6197,694.3957,669.88416,707.95905,777.424,737.8772,787.31177,762.97614,624.096,432.9875,484.1262,472.51135,514.1589,439.07593,428.8015,396.4515,371.96994,468.47034,562.6222,1047.1133,1310.677,1156.6622,1099.9236,1394.6301,1444.7388,1396.2574,1023.8914,1460.1018,1367.6447,1330.0994,1307.4331,1263.0857,1292.0028,1235.2217,1677.8374,1157.4102,1072.3401,1102.1514,1209.576};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {1294.7758,1249.8661,1258.6498,1374.9384,1301.0896,1347.0844,1527.9348,1505.0082,1503.0941,1623.0194,1600.3053,1668.2358,1883.9891,1963.0779,1886.8762,1896.8132,1916.8041,1639.9915,1721.9388,1494.0885,1291.3146,896.3236,562.88293,142.09955,-48.51011,-71.92345,208.93578,504.28006,636.9986,700.1327,696.3815,721.9041,624.3736,555.84656,488.12915,428.41635,361.6373,351.79654,341.858,366.2789,353.61688,409.0115,428.05585,626.437,1043.8278,1265.7306,1248.149,1147.577,1186.6176,1091.655,1190.0775,1035.6141,1418.7029,1303.6691,1371.9944,1316.6781,1343.5608,1284.8971,1284.0522,1306.246,1328.49,1308.5426,1269.0021,1241.4651,1465.3854,1276.2277,1129.759,1145.1661,1292.943,1349.0433,1357.804,1180.9437,1202.388,1564.0808,1631.9487,1620.3652,1772.1771,1798.9568,1800.3773,1816.7795,1693.8043,1413.1439,1274.4374,1301.8916,992.3599,612.2048,219.31186,18.166122,41.865494,30.06139,121.42335,391.4951,510.4158,566.42773,614.4382,681.8302,691.9431,597.2161,531.3449,507.92148};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {355.43976,230.76576,182.61296,244.42676,281.6375,303.85028,403.4029,547.96173,380.32214,515.0158,727.4773,1025.4161,789.65546,891.54004,1057.4397,1350.8025,1339.1061,1321.9452,1422.7411,1357.993,1219.8444,1259.5758,1385.0475,1372.8453,1286.7556,1278.6384,1268.3557,1289.8483,1249.6593,1139.5569,1049.297,1154.3634,1265.098,1390.412,1364.5483,1219.5995,1419.6194,1516.1322,1363.9135,1436.9635,1466.5205,1414.8944,1413.217,1219.987,1227.5831,1120.112,1077.681,1020.4382,794.82355,528.0517,247.8241,148.75435,349.08493,536.23627,523.5048,624.6839,662.7849,774.22675,539.2885,-227.57338,91.640915,1009.09705,712.4308,596.4345,424.33606,358.21057,280.98773,186.4488,72.65248,125.41334,281.24774,271.53864,112.82048,-285.2825,-58.73729,555.59344,1063.0198,596.84,590.80664,798.72565,1432.9211,1463.6039,1362.8383,1382.187,1269.3428,1209.1135,1241.5338,1214.559,1299.2637,1387.803,1430.4347,1351.3699,1208.3427,1315.3528,1228.5358,1320.7087,1282.8564,1225.3134,1321.1945,1336.509};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {1412.441,994.2533,1234.8143,1229.9333,1269.631,1262.7843,1194.1045,1080.0126,977.2398,919.48267,870.70105,689.7746,682.78076,635.53406,601.43066,509.95755,588.5384,914.99426,713.3016,867.3345,973.956,1209.1406,1173.5814,603.59985,797.5846,1161.9373,820.5532,576.40155,389.03482,197.1509,49.097294,-17.531565,-38.56427,-81.47668,11.063495,-101.54804,-601.30707,-315.60696,392.95126,1149.7362,699.0963,313.3473,282.73453,459.92886,1762.3844,1530.5931,1230.8538,1204.5206,1270.6415,1361.863,1199.4048,1394.7639,1480.1936,1580.5004,1544.8473,1498.4552,1283.0322,1623.7887,1545.6075,1581.2635,1339.5278,1442.7614,1464.4375,1383.5936,1363.5394,1197.272,1204.9111,1264.3511,1233.2345,1159.4895,1078.8098,939.1143,860.74744,772.1886,663.4419,527.15125,446.4686,485.68204,608.02954,693.46625,734.6541,638.6901,659.7878,805.863,1026.4197,1407.4155,1561.3053,1622.7542,1517.4623,1005.92175,606.4603,273.9625,-39.342278,-302.9079,-421.62637,-469.11212,-437.6827,-572.3294,-537.786,-667.6249};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {-840.11005,-578.2922,-260.52106,-32.758915,-59.675262,-144.31526,177.45905,214.17863,1487.3702,1326.4962,1212.614,1344.3042,1799.6432,1679.0122,1604.088,1881.1158,1898.1501,1801.9021,1702.1252,1738.2308,1567.4335,1831.9791,1899.4968,1787.9745,1702.7086,1742.6707,1896.7571,1832.1665,1731.0627,1449.4955,1275.7878,1242.1656,1061.6444,1001.99066,877.0785,747.1007,642.6711,555.73395,413.00034,274.98315,160.03772,237.81125,276.45386,350.7597,487.56668,325.00797,481.53284,358.54227,397.04413,657.1549,1027.865,1032.8632,784.5569,309.43573,-88.97848,-486.87164,-814.618,-1069.639,-1031.5446,-1148.9902,-1096.2563,-1024.6786,-1215.0823,-1265.4706,-885.35126,-461.97272,-264.90112,-11.405324,-21.323889,-659.913,-77.4086,-155.54352,1686.2681,1393.328,1394.4417,1316.3672,1383.0671,1468.5719,1647.6755,1684.1394,1555.6849,1349.8284,1462.6117,1505.9546,1512.5455,1550.2719,1558.8123,1693.9355,2028.7834,1982.08,1966.1482,1850.3627,1846.6354,1597.4698,1234.7714,1055.722,992.687,854.1714,707.68823,560.04626};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {465.26746,294.44867,121.84478,-50.71845,-191.31003,-337.78928,-288.83905,-342.3059,-344.51865,-447.1384,-510.07782,-655.7428,-660.708,-663.01794,-893.0379,-915.06525,-1055.0103,-1319.9027,-1619.3365,-1919.9221,-2110.06,-2147.938,-2013.1453,-1934.3558,-1833.5682,-1863.7465,-1934.3953,-1783.0039,-811.5867,-941.1454,-772.6215,-616.2129,-843.64233,-582.59106,-373.31912,-530.6158,1649.9733,1518.4442,1519.2313,1473.3651,1392.0624,1506.3217,1451.1881,1234.8826,416.1754,284.80396,1157.2523,1405.8195,1442.7122,1492.9912,1390.5614,1395.721,1580.4573,1853.9388,2077.148,2187.4585,2172.5518,1770.9618,1599.1707,1104.964,924.71454,815.1047,609.2271,429.6899,224.93915,83.95024,-82.04881,-301.58496,-561.7761,-765.5139,-845.4306,-1072.8181,-1281.0365,-1482.9694,-1693.3094,-1927.3861,-2121.0618,-2375.743,-2845.352,-3053.6785,-3350.2617,-3442.1597,-3466.4556,-3547.8977,-3767.1545,-3498.3901,-3282.0784,-3046.553,-3040.3643,-3174.0334,-3375.5935,-2890.4856,-2043.195,-1792.5831,-1431.8073,-1138.334,-1113.9716,-321.55258,-594.8129,-626.00867};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1544.2804,1612.7886,1506.8937,1691.9141,1667.5641,1434.7664,1507.1827,1625.6125,1605.475,1403.9402,1519.2852,1507.1261,1482.7412,1555.9214,1510.6609,1376.7397,1356.1145,1600.0304,1809.0806,2328.2007,1940.6841,1337.1096,1672.3103,1225.5029,970.15485,788.0567,588.7776,615.31323,239.40111,-27.866356,-314.6432,-605.0301,-873.033,-1132.5782,-1334.0428,-1725.1512,-2137.0676,-2400.9866,-2685.824,-3018.2893,-3416.764,-3803.9875,-4280.526,-4597.289,-4813.3438,-4891.359,-4966.34,-5022.4907,-5119.2646,-4873.11,-4677.9272,-4513.77,-4602.762,-4530.0493,-4581.854,-4357.736,-3923.3264,-3648.0498,-2461.0984,-2054.2534,-2012.7474,-1673.6984,-873.7127,-863.2222,1378.9432,1478.6823,1196.2561,1247.2162,1264.5018,1167.5181,1156.3527,1587.9971,1808.8384,1738.4613,1616.0442,1568.0769,1508.5248,1774.3071,1695.6393,1356.4257,1431.0111,1597.2533,1546.4304,1669.74,1489.7261,1652.7987,1700.4705,1279.162,960.7102,686.8544,377.35477,386.56888,255.57245,-327.4101,-613.4592,-892.3336,-1047.8741,-1525.3711,-1863.392,-2326.9792};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {-2681.7546,-3051.4944,-3548.8047,-4020.0117,-4491.3643,-4871.8765,-5282.432,-5426.567,-5664.424,-5726.164,-5773.3853,-5906.878,-5830.489,-5801.674,-5762.664,-5699.0806,-5714.1553,-5673.6475,-5606.3735,-5616.055,-5394.7886,-5222.817,-4491.061,-3772.5916,-2657.4387,-2431.453,-1564.1967,-1326.9409,1331.0765,1142.3783,1298.2811,1127.4421,1083.83,1096.6628,1243.32,1761.2958,1925.705,2049.525,1734.6777,1597.938,1562.7568,1710.4799,1848.1903,2093.1475,1975.0895,1794.51,1363.7783,1350.1381,1271.7622,1363.9838,859.9887,859.22925,924.2621,566.84717,384.0506,341.69916,288.66534,64.15099,-847.8428,-1052.1578,-1548.6316,-1982.0149,-2486.223,-2988.8967,-3473.0032,-3932.715,-4349.4053,-4840.868,-5088.8745,-5482.809,-5650.782,-5887.6943,-6048.016,-6047.8706,-6130.463,-6177.1416,-6319.4116,-6296.0054,-6287.6963,-6237.2964,-6217.25,-6204.701,-6128.92,-6046.654,-6111.1206,-6059.5166,-5996.0903,-5592.2417,-4556.4507,-3921.5657,-3861.2905,-3018.2673,1374.9603,641.4624,1047.5295,781.3456,887.9984,992.6418,1369.7275,1577.9689};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {1629.6481,2020.1997,1365.0144,1655.7834,1804.7896,1993.9514,1964.3927,2045.6461,1925.9135,1611.9202,1430.3982,1288.4451,1064.6459,1096.9369,1360.3506,1429.2186,758.4411,648.7515,401.0526,325.44922,293.60928,245.4437,-639.70966,-769.6602,-1659.2225,-2388.8953,-3234.8271,-4132.311,-4451.1875,-4880.4014,-5138.977,-5411.011,-5814.3022,-6090.671,-6206.853,-6446.099,-6597.067,-6459.2954,-6336.5024,-6258.834,-6122.1104,-6076.685,-6148.029,-6162.05,-6298.574,-6343.3247,-6226.1875,-6129.2134,-6164.363,-6180.134,-6100.893,-6035.4233,-5907.9653,-5379.667,-5090.897,-4246.2515,1306.145,1204.363,1243.1182,795.31116,805.5673,1239.6608,1589.3029,1951.8167,2165.3335,1915.5988,1873.5492,2030.0659,1795.812,1395.766,1623.2145,2448.934,2092.459,1859.5402,1661.1333,1283.3679,658.6999,582.0679,999.5616,1265.1721,518.424,559.74457,346.7917,280.5527,257.718,461.5431,58.724976,-703.55774,-1497.5741,-1835.3687,-3594.7937,-4981.8335,-5545.397,-5756.809,-5987.082,-6280.5024,-6670.024,-6741.005,-6580.211,-6310.6553};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {-6413.7773,-6340.8394,-6513.6113,-6132.1665,-6096.936,-6166.233,-6110.0566,-5932.152,-5991.2104,-6214.2817,-6209.798,-6165.7466,-6170.7217,-6138.514,-6095.3423,-6068.0767,-6052.064,-5954.064,-5721.6777,-5415.261,930.10895,1219.1907,1262.099,1108.6852,1103.8163,1268.0326,1444.9196,1756.356,1786.2158,1800.4834,1740.0917,1966.4076,1305.0039,874.41864,1043.5491,2243.9875,2371.2603,2047.7285,1804.9254,1627.1616,1426.0276,1258.7291,1478.5807,1014.7709,677.55884,390.20227,227.55464,234.95761,248.29733,572.39844,-167.95876,-771.1407,-2025.5535,-3015.5872,-4778.5273,-5611.9375,-6048.4717,-6359.2544,-6591.6177,-7030.8276,-6910.8237,-6555.248,-6445.933,-6418.6533,-6313.317,-6660.184,-6602.697,-6582.75,-6339.3096,-6258.3013,-6100.882,-6521.761,-6365.3374,-5999.318,-6181.3174,-6163.695,-6149.777,-6119.042,-6126.941,-6086.9834,-6050.1797,-5988.997,-5765.307,-5451.8013,1233.127,1424.1439,1284.5508,1297.0813,994.7185,1259.8263,1489.3884,1667.5916,1679.6941,1784.2427,1754.6603,1909.4937,1805.1519,1544.0942,1868.0494,2403.9236};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {2112.6426,1877.338,1794.464,1640.2815,1422.3296,1967.9948,1758.9873,1147.1686,710.0846,582.50494,507.07672,440.75333,455.62323,255.48741,82.46667,-798.95844,-1672.4333,-3763.648,-5274.334,-6097.3076,-6429.142,-6772.585,-6769.3096,-6652.2056,-6588.8145,-6756.155,-6752.7886,-6579.1836,-6668.5728,-6836.9375,-6430.8535,-6552.2896,-6555.7935,-6678.1895,-6655.5713,-6531.329,-6514.1855,-6244.0757,-6207.4365,-6271.196,-6192.5396,-6136.8735,-6114.626,-6154.9043,-6087.4136,-6014.4585,-5786.0254,-5539.3125,1585.9141,1441.8494,1458.4103,1347.917,1340.8453,1302.1235,1418.358,1328.5392,1775.0956,1063.1642,1804.5131,1729.5865,1300.4042,1818.1498,2160.2424,1945.1243,1904.4729,1937.3046,1960.5834,2169.428,2426.2058,1841.9772,1642.6146,1399.505,130.97673,170.83533,979.183,890.2573,118.97125,422.82617,200.8721,-1062.6638,-1817.8536,-4220.3896,-5547.304,-6487.0884,-6688.829,-6767.9683,-6435.976,-6506.8584,-6614.5015,-6870.1987,-6964.8096,-6698.4136,-6671.4014,-6733.0425,-6589.2095,-6652.3086,-6526.1733,-6442.095,-6256.949,-6310.1006};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {-6631.4883,-6535.529,-6416.161,-6256.1836,-6264.7363,-6240.9893,-6142.1353,-6129.471,-6004.575,-5852.1875,-5577.7188,-5261.3364,1366.9652,874.6675,1315.7113,1570.9176,1521.0264,1425.7526,1440.9274,1555.8802,1655.914,2005.6224,1885.6564,1755.8679,1532.8904,1655.496,1893.8295,2191.0334,2036.2622,2319.681,2360.9788,2655.4597,2212.1528,2214.553,2112.8293,1413.7456,1092.4065,1046.8549,680.1991,639.5881,453.16165,295.81406,116.75121,-849.8479,-2651.8398,-4634.4697,-5528.282,-6524.648,-6624.8022,-6387.7734,-6245.1465,-6553.5063,-6721.4976,-6865.6875,-6839.6245,-6697.808,-6555.6216,-6731.2734,-6790.1284,-6754.467,-6728.021,-6368.0063,-6428.4697,-6362.6196,-6446.919,-6363.8574,-6393.522,-6438.377,-6453.1685,-6357.328,-6189.609,-6044.442,-5617.7427,-5444.2144,-5211.0693,-5032.936,1195.8333,1175.1581,1257.2821,1403.5465,1359.342,1777.3007,1365.5544,1633.2484,1143.6783,1966.8284,1870.5629,1838.1377,1674.957,1642.3433,1975.3954,2435.3987,2802.7576,2598.324,2469.5671,2588.7747,1835.3254,2103.4229,1834.4591,1571.8259};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {771.6488,1186.3313,873.76794,791.49646,645.809,552.229,5.262283,-745.53687,-2437.4858,-4500.4507,-5342.899,-6564.641,-6573.928,-6360.542,-6233.1,-6496.0894,-6646.4497,-6659.262,-6813.488,-6716.9424,-6704.004,-6725.7754,-6914.214,-6902.851,-6776.5527,-6568.18,-6465.3086,-6635.404,-6409.5703,-6438.6753,-6523.161,-6463.105,-6344.709,-6288.656,-6130.693,-5904.1475,-5348.1064,-5101.678,-4986.0547,-4815.3784,979.00836,860.6793,746.4482,904.2912,1070.5304,1659.272,1649.5859,1553.2222,1547.4962,1686.0386,1871.3824,1959.3285,1782.575,1203.668,1647.7876,2308.1948,2216.6987,1749.8948,2330.416,2187.923,2244.4521,2243.509,2025.3367,1815.9664,1270.066,951.6588,973.449,953.4137,562.5439,635.99146,-28.78609,-1092.5631,-2478.956,-3986.8027,-5180.821,-6316.9653,-6843.4775,-6870.9316,-6829.4326,-6651.5337,-6564.0137,-6704.984,-6780.1787,-6856.9565,-6746.165,-6873.9634,-6813.2866,-6858.2617,-6767.7,-6656.708,-6498.411,-6567.705,-6607.0293,-6573.9014,-6603.7974,-6464.0205,-6379.0835,-6186.698,-5949.2095,-5533.8403};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {-5197.3384,-5002.9453,-4794.2197,-4491.7773,896.7845,842.5294,863.3891,896.0887,967.3315,1329.9377,1884.5461,1531.0399,1687.661,1402.6366,1735.0651,1815.1036,1081.3738,1614.4912,1754.0454,2115.5283,2273.6597,2253.3354,2284.567,2101.4224,2023.9185,2067.6487,2097.284,1103.9243,1207.7964,1143.5405,976.9379,636.2682,1026.1561,237.77927,-596.22626,-524.33563,-2014.6183,-3857.346,-4908.2754,-5861.0293,-6701.4795,-6947.9746,-7099.577,-7213.76,-6948.7173,-6917.1304,-6685.0625,-6794.681,-6746.529,-6631.047,-6798.7964,-6865.246,-6751.8823,-6478.2363,-6462.7256,-6626.1704,-6617.612,-6528.5986,-6488.2285,-6430.6045,-6367.919,-6203.133,-5902.495,-5372.886,-5009.1104,-4733.7705,-4550.8384,-4296.527,1171.5905,894.93304,872.3649,865.97424,994.60583,1259.0016,1676.9368,1574.7152,1444.2935,1640.2444,1603.2173,1808.7789,2018.1504,2126.9438,1984.5082,2205.2185,2267.3694,2304.9172,2195.7485,2193.6238,2031.0964,1955.0604,2054.213,843.48035,1200.7476,1081.6332,844.7991,713.61505,967.46576,357.76147,667.4758,-42.324535};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {-623.20844,-2378.02,-3876.4993,-5157.6494,-6532.76,-6922.8857,-7073.277,-7251.0957,-7272.238,-6973.0728,-6695.4385,-6702.741,-6677.5825,-6803.137,-6768.688,-6687.1504,-6680.0063,-6538.182,-6465.1724,-6484.8057,-6547.2847,-6535.685,-6544.875,-6544.0093,-6391.937,-6188.764,-5628.4014,-5254.021,-4894.498,-4512.888,-4050.1077,-3932.588,1384.9576,1083.725,1038.1599,1018.4635,1213.7802,1568.6282,1639.1763,1563.1676,1593.5712,1462.0857,1154.8397,1184.957,1808.7029,1858.8137,1895.0542,2146.773,2456.748,2427.3018,2433.8306,2124.7964,1909.0887,1836.3853,1935.9498,1846.8501,1526.6829,1122.0831,898.5046,840.47375,872.3705,960.937,853.74695,65.90446,-271.2771,-886.81476,-2289.9082,-3504.1917,-5279.7837,-6632.0547,-6888.1074,-7006.721,-7178.669,-7361.277,-7210.279,-6917.4834,-6920.5874,-6984.721,-7018.566,-6878.679,-6680.635,-6458.391,-6532.346,-6544.6797,-6527.431,-6584.682,-6528.0396,-6463.2295,-6106.1143,-5708.217,-4784.8125,-4024.875,-3618.413,-3690.7456,-3599.2568,-3274.2515,1413.8362,1522.6736,1478.8966,1463.4225};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {1400.4735,1384.4387,1492.2505,1581.0583,1527.9279,1616.8411,1170.5275,1337.6539,1711.3567,1846.9886,1902.5298,2084.7107,2264.6384,2397.769,2483.5388,2219.539,1865.2278,1849.5953,1879.9797,2153.5107,1901.6703,1464.466,1148.8093,1105.7755,913.18884,915.71313,1100.704,1003.81366,1149.4484,655.46484,-49.232105,-1657.1261,-3746.8906,-5689.2197,-6619.3765,-6849.2026,-6993.5806,-7186.9443,-7308.864,-7321.384,-7449.455,-7348.6045,-6815.3813,-6720.46,-6632.1157,-6631.628,-6607.6187,-6475.245,-6455.1504,-6541.0967,-6319.679,-5773.5938,-5331.1426,-4948.0283,-3921.5583,-3062.8865,-2910.9937,-2684.2969,-2598.382,-2610.3596,1339.4517,1417.7867,1398.7625,1396.9159,1311.7826,1151.0485,1417.2006,1301.0446,1460.4183,1552.3986,1459.5835,1527.2192,1675.5454,1972.351,2311.234,2041.1294,2212.8894,2164.0603,2264.8042,2300.673,1867.7675,1780.1779,1538.2332,1860.2407,1981.6575,1068.2772,1342.2395,1040.5502,968.916,946.3955,1327.0586,1221.2938,1109.2914,1115.7029,778.449,-726.2447,-1907.8777,-3995.2307,-4270.4453,-5078.4326};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-6187.297,-6711.687,-6931.319,-7116.7734,-7246.43,-6787.275,-6387.7417,-6433.9775,-6573.435,-6596.4883,-6597.8267,-6502.7754,-6385.739,-6173.9497,-5019.3726,-4447.221,-4181.068,-4123.239,-3746.5784,-2730.0156,-2522.965,-2442.785,-2253.2634,-1960.0548,1468.1031,1534.2998,1367.9146,1469.4996,1387.4182,1343.2922,1338.5707,1277.7354,1513.906,1604.0499,1396.7646,1650.37,1539.7374,1873.3296,1937.6251,1956.3123,1563.3622,1724.9773,1974.928,1876.8542,1739.822,1612.6903,1229.2463,1279.312,1636.251,1591.8823,1410.214,1242.1971,863.3905,835.1197,1099.9744,861.8407,650.1119,740.372,507.99152,-28.066282,-38.59662,-1970.5586,-2507.0576,-3226.2212,-3740.623,-5256.403,-6030.239,-6261.4165,-6679.4614,-6547.2466,-6398.2783,-6511.7607,-6460.77,-6497.172,-6453.9746,-6242.592,-6021.9297,-5087.2217,-3760.1377,-3175.7727,-2763.83,-2962.8289,-2674.0405,-2646.1204,-2317.956,-1978.4637,-1983.88,-1252.2782,1405.3138,862.84436,1387.8353,1269.5778,1274.178,1374.4518,1357.334,1334.4022,1188.9062,1444.2837,1623.7067,1859.6592};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {1572.7726,1907.873,1760.4032,1411.5732,1391.7408,1582.3247,1833.3479,1592.3796,1433.6079,1381.2795,1283.0376,1158.869,1251.4779,1538.538,1799.6292,1089.0543,1089.2874,1042.5814,958.4391,754.7866,724.77527,538.17096,1040.6238,1298.0819,348.0465,-1024.4725,-1072.479,-1317.4613,-1960.5288,-2693.8525,-3667.4412,-3850.7312,-4009.3198,-4600.6865,-5531.2373,-6001.522,-5672.2407,-6004.399,-5596.051,-4807.711,-4771.794,-3688.4248,-2766.2822,-2240.3352,-1886.6732,-1660.0449,-1580.9637,-1916.707,-1993.8578,-1178.9772,-1624.9082,-1092.3641,1570.4102,1319.7847,1200.133,1197.5508,1268.1096,1297.653,1300.0244,1509.4718,1326.757,1409.6497,1755.1095,1915.3903,1788.552,1868.8645,1575.4852,1333.6283,1120.8749,1685.6827,1315.5427,1431.1144,1371.97,1304.5831,1289.6874,1243.8955,1341.9653,1691.8038,1933.183,1479.8668,1305.033,1484.0868,1131.0468,760.4989,765.544,526.2944,1048.4305,508.25113,505.13248,-210.2678,-833.3957,-990.0881,-1521.6377,-1361.1694,-1667.5032,-1840.2856,-2399.9375,-2674.149,-3032.378,-2890.9167};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {-2777.4092,-3147.7026,-3329.2568,-3730.5298,-4352.113,-3430.8918,-2650.6018,-1956.4199,-1360.8322,-901.2527,-985.1123,-1453.481,-1519.7457,-1476.3441,-1095.4773,-613.7871,1511.9412,1406.6609,1289.1873,1223.517,1348.7637,1606.4108,1484.8931,1357.562,1387.28,1310.6488,1678.327,1809.8082,1779.3784,1544.2969,1347.0538,1389.3932,1564.0665,1380.565,1552.969,1516.793,1362.675,1165.7905,1511.7278,1384.2637,1564.408,2125.0923,2194.6362,2068.2134,1771.2333,1583.6954,1270.4445,1036.3173,1079.6678,1192.4445,1137.8885,1280.0944,1066.521,1148.9924,-282.34058,-732.8055,-647.5224,-1036.3616,-1084.0968,-1279.9823,-1583.6771,-1667.55,-1489.6473,-1703.1268,-1792.799,-1919.8802,-2586.1782,-2455.6646,-1834.6554,-2197.7214,-2067.619,-1664.1499,-962.82776,-346.42456,-196.92444,-539.6284,-893.6615,-1120.895,-538.0315,-331.8997,792.2181,875.57294,1117.5345,1089.5762,1395.5605,1618.4978,1365.4867,1353.0907,1359.4604,1354.0083,1691.0438,1958.1859,2230.516,1696.5281,1524.247,1470.5404,1701.7385,1460.6522,1592.6112,1692.863};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {1624.263,1551.3384,1926.6184,1700.4164,1813.0063,2427.5527,2505.6284,2172.139,1919.5844,1879.8639,1810.8218,1304.0748,1220.5876,1170.8932,1213.766,388.8387,1046.2997,878.6209,309.3465,-164.97237,-608.94885,-902.28546,-741.50616,-1081.9456,-879.73334,-945.4087,-777.5851,-1199.5446,-1132.9053,-1476.6637,-2453.4343,-2298.7625,-867.16235,-999.05237,-839.12305,-406.71628,-201.06567,14.900116,-14.20286,29.533457,-308.31992,-508.3891,-275.9591,-71.31343,841.2296,811.7199,964.5204,798.51306,1213.4912,1028.8113,776.8526,1208.6757,1260.3971,1386.4578,1460.1733,587.07465,1968.5071,2075.1345,1531.3832,1660.2126,1802.5294,1691.1775,1483.8063,1229.9705,1407.0181,1701.8851,1831.9763,1990.0627,2075.775,2489.73,2415.8096,2081.4937,2116.064,1696.276,1673.0398,1392.3998,1372.9376,1594.7054,1558.4908,475.45502,1138.758,1172.1483,802.6281,681.1108,11.135028,-273.15985,-387.7358,-471.88812,-79.173134,-643.49194,-386.54294,-950.3075,-1081.677,-1145.401,-1981.0658,-1504.5251,-575.20795,-850.94324,-534.1198,-89.677155};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {-67.520195,102.58101,619.74994,435.1991,157.50623,47.790413,232.28864,823.7292,1355.3804,1103.515,979.7787,676.3392,718.75775,737.4846,651.5069,1096.2522,1200.8265,1411.118,1231.6559,-43.030125,1551.878,1914.5297,1651.0702,1832.6846,1849.0466,1979.2067,1966.8356,2036.0616,2269.8296,2066.8872,2346.1814,2585.1926,2539.1702,2758.2507,2180.0837,2373.2212,2438.384,1761.5059,1457.8646,1553.8105,1676.0468,1720.9435,1812.7837,1908.6533,1332.8071,1111.1569,973.93774,698.0165,349.34338,-181.84619,-588.5011,-583.1335,-695.03534,-723.6299,-729.6281,-1304.1571,-610.5123,-912.4016,-1206.4706,-1234.0168,-656.73126,14.069595,-300.3639,91.427475,155.51738,360.3009,703.0699,842.9467,804.38257,681.38965,924.0272,1403.6265,1051.781,933.5347,660.3723,513.4938,455.7676,634.0665,690.4464,1041.5221,1224.9824,1361.2053,1643.238,1777.4213,1868.864,1753.6677,1579.2476,1605.2041,1433.2035,1927.7046,2232.017,2191.0103,1964.3451,1937.68,2266.9932,2551.8655,2751.12,2705.124,2458.2021,2336.23};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {2458.1274,2208.0842,2198.155,1871.3481,2066.7197,1810.0073,1687.4939,1680.5044,1349.1586,1226.2056,962.72,752.2917,590.12134,246.04543,-59.7958,-73.40011,-350.5633,-565.00256,-589.4573,-909.0239,-339.48093,-169.82825,-90.54765,-264.81024,-113.682076,791.27686,277.90384,385.58325,553.4229,564.35266,797.20935,920.9769,807.3505,1010.6568,1177.73,1714.0684,300.12723,626.5703,454.29477,355.34863,212.47096,573.3769,451.33768,1074.2489,1378.8376,1518.8687,1460.1724,1600.2605,1592.5833,1989.495,1783.9161,1509.7838,1485.6536,1934.2047,2039.6313,2287.2139,2209.1826,1937.8562,2109.7314,2451.497,2766.5508,2114.7441,2284.4592,2216.3408,2451.6594,2501.6414,2343.1467,2302.488,2431.3206,1891.1105,1665.3513,1743.2877,1565.6084,1442.6509,1397.9358,1370.891,1216.8236,1078.1039,650.0257,291.82,407.6218,-52.068768,-308.75537,-319.59738,4.795325,202.85054,421.78018,926.7891,959.2946,749.4711,646.5294,654.7366,761.16724,956.6178,1131.961,1183.4606,1429.586,1101.2028,1483.2496,1754.8805};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {82.08737,363.67798,338.68988,225.77873,448.569,512.84076,322.68024,790.017,363.31418,1319.2723,1292.731,1357.4999,1637.785,1352.7247,1562.7388,1743.5198,1647.4813,1874.062,2182.1506,1916.1523,2281.8325,2261.2195,2479.755,2261.9834,2546.213,2458.6892,2294.2183,2403.1763,2246.7478,2105.097,2102.6226,2117.549,2171.1072,2140.063,2267.648,1984.3892,1662.7053,1869.6385,1937.6095,2076.2654,1937.3799,1478.0546,979.5541,590.8017,593.7422,563.52344,795.98425,572.8852,302.03537,519.7994,484.00443,858.06433,892.4779,764.0217,703.14874,770.8966,954.3345,1147.0332,1546.772,1881.7815,2037.3146,2024.9941,1741.538,1788.8644,56.497864,4.715861,213.17726,251.28226,622.3203,651.6367,735.9216,914.8283,916.039,1173.9679,1194.6088,1377.5206,1428.0737,917.84705,1011.7467,1792.1965,1932.026,1866.525,2250.8948,2280.0889,2319.622,2423.9573,2674.1782,2458.206,2430.1323,2393.767,2302.0007,2236.4932,2193.9475,2188.6965,2277.7705,2537.1714,2438.7031,2431.3064,2356.8765,2286.2207};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {2349.9265,2165.1543,1760.6725,1562.3816,1523.1812,1576.8547,1760.9086,1444.1698,1308.398,872.8339,1129.3533,1072.1843,1097.5996,863.6837,499.5195,503.36612,536.065,563.3258,700.58185,908.11273,1153.8358,1682.6592,1832.6061,2442.8652,2467.9387,2277.2466,2020.9746,1990.3021,-269.5436,-267.52686,-122.19829,259.64822,415.10385,659.0217,564.39954,380.77377,824.4142,955.74554,1195.8091,1391.4049,1681.2911,1027.2793,1183.8988,1916.3066,1926.169,2099.6008,2324.5803,2354.1145,2353.693,2526.3198,2614.9,2514.43,2483.7117,2405.2698,2481.0996,2529.0332,2179.7896,2447.247,2529.28,2788.3057,2828.1628,2695.2546,2688.2236,2649.1506,3050.8984,2321.6045,1622.5609,1323.5299,1495.7186,1400.797,1986.7194,1661.3071,1290.822,1299.1406,1348.9484,1247.8905,1148.8458,925.7474,637.3811,363.56607,380.665,625.90906,1006.6947,1120.9792,1491.356,1839.7771,2476.8044,2546.8975,2739.3848,2579.9175,2378.917,1994.7682,-389.78076,-234.13605,-260.25354,-44.20915,307.86267,383.59598,172.93932,470.7393};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {614.08167,849.9798,1111.9808,1085.0404,1429.8981,1610.4874,1521.986,1647.9075,1766.5817,1973.5477,2043.7848,2198.1309,1998.2744,2459.428,2390.4946,2415.476,2540.7156,2548.8923,2635.074,2643.462,2521.2607,2730.1348,2522.274,2801.2983,2987.5227,2879.697,2770.7507,2786.5803,2844.624,2356.8115,1687.7015,1270.8181,1231.7235,1364.9954,2126.973,1477.0331,1244.9053,1243.94,1365.3035,1545.8846,1551.8431,1452.6366,1031.5197,808.4346,879.56824,471.9308,1101.2513,1353.0354,1710.1729,2224.9895,2655.378,2437.4934,2984.254,2844.1267,2712.443,2367.5334,-587.5809,-452.03488,-435.96167,-235.45903,16.41621,197.77222,256.55966,318.5736,441.32834,664.4248,974.21783,1142.2535,1274.2979,1304.4529,1327.1187,1301.959,1620.7744,1944.3188,2117.238,2297.89,2467.8762,2392.234,2494.234,2635.6377,2611.5854,2572.2,2660.2231,2793.8003,2762.4482,2894.1335,2722.7966,2804.5867,3062.206,2765.1602,2715.3472,2743.0757,2845.6648,2480.5383,2158.97,1605.498,1519.1222,1496.3245,2040.0128,1342.2489};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {1294.5846,1299.7001,1220.8401,1664.1042,1813.2954,1541.628,1161.3632,998.3753,874.6535,955.01935,1091.4132,1285.5203,1612.6781,2101.0745,2684.6028,2662.2463,2928.2253,2458.6265,2683.6072,2320.5813,-738.56964,-555.2506,-909.97626,-369.93524,-140.33717,154.80785,301.73563,304.66214,298.4198,434.2132,574.65814,1457.948,1853.6937,1780.3085,1351.7145,1252.7916,1446.7019,1799.8787,2103.938,2138.5754,2161.6597,2444.9258,2543.6729,2707.7966,2488.6184,2553.671,2571.2139,2466.4722,2576.6936,2383.5378,2634.5894,2632.3179,2872.5144,2784.8577,2622.2266,2534.4495,2588.068,2613.14,2459.5388,2026.4191,1902.9368,1966.4131,1885.2297,1708.159,1445.0344,1448.6667,1507.0996,1630.7205,1898.7089,1726.3206,1537.253,1225.283,1115.226,1087.9602,1187.3137,1270.9316,1171.4117,1742.9099,2362.4607,2794.199,2800.3708,2547.8745,2534.962,2303.2766,-1014.9108,-1084.2947,-624.416,-508.26285,-575.93396,-263.96967,254.25865,260.40433,352.8341,469.9145,778.11584,1556.2047,2008.0498,2003.6465,1445.9819,1255.2681};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {1294.718,1581.4714,1789.2098,1774.7131,1857.3994,2384.0789,2325.8909,2672.3777,2303.0999,2414.7725,1446.3906,796.98303,2180.2803,2564.3213,2016.744,2493.3213,2519.2493,2430.3433,2327.189,2378.4595,2460.921,2699.5085,2718.9434,2495.9758,2302.3472,2082.1797,1970.0769,1997.7595,1948.4232,1761.9006,1696.3519,1831.7405,2124.9773,2155.7988,1805.6208,1601.1074,1185.1477,1181.9539,1231.8093,1089.8007,1089.2427,1504.2029,2211.7075,1828.6122,2673.8762,2153.2205,2279.3376,1966.0415,-1125.4067,-787.1685,-781.7327,-674.7346,-613.15356,-447.70642,-82.476295,36.305134,-78.658066,167.37683,265.04382,944.95135,1260.1132,1341.9471,1235.9161,1374.2412,2127.6277,2188.5283,1691.3066,1787.8467,1808.5936,2150.233,2369.9724,2225.7517,2087.3594,2234.5085,1375.7401,558.357,2146.537,2283.5085,2288.0754,2462.5579,2228.4668,2281.0671,2371.1294,2327.244,2373.512,2380.484,2150.84,1794.6245,1749.5394,1873.6027,2145.83,2258.6301,2309.6704,2343.1997,2398.65,2310.0479,2294.118,2231.0676,2026.6125,1647.3237};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {1571.12,1409.2567,1146.8275,1070.045,1162.7556,1412.2697,1809.7201,2294.0732,2528.466,2186.2776,2078.2344,2353.4973,-1016.8605,-936.93256,-887.8399,-655.65326,-468.2661,-266.16013,-335.354,-387.61856,-507.09842,-481.12793,-27.3627,873.8339,1077.7754,1054.5206,1215.5427,2020.0034,2115.6345,2019.027,1800.8374,1814.8368,2137.4185,2320.0964,1896.4889,1870.8605,2093.4377,2113.4478,2121.173,2013.3954,2023.4277,1828.8256,1900.0188,1874.462,1844.2522,2168.4614,2392.2502,2450.685,2474.4885,2450.2913,2176.0046,1864.1268,1861.3096,1911.1184,2135.256,2323.5415,2595.871,2760.5825,2605.2488,2644.3408,2390.425,2228.587,1764.4829,1844.1759,1761.0636,1606.2609,1169.2383,1098.0541,1198.3309,1245.8009,1521.8821,1990.6868,2441.3298,2541.148,2108.6643,2279.2617,-1228.5159,-1124.5212,-847.8,-741.9154,-368.7707,-46.937504,-356.6911,-460.503,-583.28784,-482.36456,13.712261,285.41525,291.6659,489.3324,963.4467,1793.1907,2301.664,2228.7148,2105.8535,1807.4841,1524.9291,1855.2908,1833.6847,1925.6399};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {2031.3552,1954.1245,1940.0708,1905.5298,1578.8518,1465.5758,1380.3416,1478.6172,1659.9386,2093.397,2383.4973,2407.3953,2613.2876,2431.311,2393.238,2305.932,2479.3535,2030.3118,2172.6682,2475.3938,2684.2375,2420.1133,2335.1084,2335.6785,2403.8076,2195.573,2151.059,2054.7483,2009.8066,1708.7487,1450.0787,1116.9225,1329.9319,1320.7949,1607.0458,1984.3765,2315.633,2429.5063,2283.9875,1906.4957,-1161.3192,-1256.2533,-987.681,-731.4086,-511.98053,-341.09653,-397.25552,-507.50607,-546.3571,-320.94266,-299.91864,-325.8218,-120.0886,38.30582,172.52261,1191.5923,1920.3771,1860.3485,1791.8195,1581.8967,1343.659,1453.9171,1628.3456,1754.1584,1663.9935,1724.626,1782.0768,1722.2893,1586.7322,1262.9952,1287.1378,1331.9641,1709.6659,2089.844,2272.8413,2429.147,2403.8777,2594.8403,2575.6455,2235.8274,2401.787,2201.9084,2154.5571,2326.25,2282.072,2233.0332,2208.2908,2215.5186,2216.1006,2215.5427,2047.6396,958.6139,1966.3351,1670.0824,1281.7523,1112.8693,1162.0928,1456.1016,2070.371,2173.396};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {2014.5514,2126.1184,1514.8551,1133.0083,-1215.9922,-1132.3716,-1119.5708,-897.2886,-750.12787,-628.50116,-516.0391,-447.58344,-384.26913,27.918118,-388.46786,-344.33612,-412.74408,-441.10416,-205.11911,819.10266,1411.4984,1354.4396,1549.7328,1498.4265,1327.3782,1438.2343,1514.7627,1602.1389,1326.2494,1358.0521,1484.6614,1474.7344,1238.405,1115.2881,1348.0513,1389.9169,1728.8452,2000.7509,2067.6484,2464.9167,2544.111,2744.9534,2118.3884,1628.9894,1231.4052,1911.4884,1852.9816,2081.7334,2204.3218,2168.397,2116.4365,1898.4054,1982.3505,2090.008,2028.7604,1844.5984,1785.691,1480.9071,1376.8004,1237.9978,1222.6708,1691.4785,1973.3315,1720.1158,1766.905,1663.9685,1095.8519,1044.68,-1217.0905,-1298.3424,-1263.4327,-1045.2354,-884.46436,-823.3754,-620.8942,-537.1114,-293.84595,202.98907,-396.1102,-398.393,-374.24237,-460.22653,-97.0532,647.6492,899.9564,1178.1193,1382.7573,1456.0598,1356.941,1327.2275,1503.9257,1527.0841,1136.3046,1117.2053,1136.3025,1054.3346,969.52716,895.25745,898.16345,1228.1139};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {1831.0706,1920.91,1962.9124,2251.21,2468.1226,2675.299,2043.179,1442.6328,1257.2166,1749.6606,1801.3666,1843.4764,2116.4897,2105.6836,1997.0587,2045.4191,2198.718,1879.1093,1844.6493,1739.6777,1495.8599,1188.556,1097.2626,1242.9722,1273.2985,1661.7147,1346.8798,1707.8936,1330.2639,1138.6223,1046.3038,449.49298,-1206.532,-1279.385,-1296.1755,-1105.8995,-1024.8959,-961.0144,-908.9415,-655.1957,-400.26947,-81.59428,-199.02808,-340.05356,-235.89716,-104.19337,330.32205,524.306,514.08215,787.3493,1072.1794,1210.6646,1073.3788,1163.4857,1275.9667,1305.9297,959.5342,695.9901,874.7056,928.26715,875.3351,689.5073,1076.5751,1175.5138,1517.7064,1912.0361,1919.9938,2034.7849,2170.8064,2104.277,1982.2876,1671.3589,1783.2648,1851.8802,1684.9481,1866.1068,2157.781,1925.598,1833.0817,2010.6963,1920.7854,1771.3755,1681.089,1533.6664,1444.8344,1290.528,975.92065,906.0505,810.3778,793.4751,822.96625,1267.35,787.76514,795.2804,198.51157,138.16336};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.01587,0.00391,0.03175,0.00391,0.04762,0.00391,0.06349,0.00391,0.07937,0.00391,0.09524,0.00391,0.11111,0.00391,0.12698,0.00391,0.14286,0.00391,0.15873,0.00391,0.1746,0.00391,0.19048,0.00391,0.20635,0.00391,0.22222,0.00391,0.2381,0.00391,0.25397,0.00391,0.26984,0.00391,0.28571,0.00391,0.30159,0.00391,0.31746,0.00391,0.33333,0.00391,0.34921,0.00391,0.36508,0.00391,0.38095,0.00391,0.39683,0.00391,0.4127,0.00391,0.42857,0.00391,0.44444,0.00391,0.46032,0.00391,0.47619,0.00391,0.49206,0.00391,0.50794,0.00391,0.52381,0.00391,0.53968,0.00391,0.55556,0.00391,0.57143,0.00391,0.5873,0.00391,0.60317,0.00391,0.61905,0.00391,0.63492,0.00391,0.65079,0.00391,0.66667,0.00391,0.68254,0.00391,0.69841,0.00391,0.71429,0.00391,0.73016,0.00391,0.74603,0.00391,0.7619,0.00391,0.77778,0.00391,0.79365,0.00391,0.80952,0.00391,0.8254,0.00391,0.84127,0.00391,0.85714,0.00391,0.87302,0.00391,0.88889,0.00391,0.90476,0.00391,0.92063,0.00391,0.93651,0.00391,0.95238,0.00391,0.96825,0.00391,0.98413,0.00391,0.99609,0.00391,0.00391,0.01587,0.01587,0.01587,0.03175,0.01587,0.04762,0.01587,0.06349,0.01587,0.07937,0.01587,0.09524,0.01587,0.11111,0.01587,0.12698,0.01587,0.14286,0.01587,0.15873,0.01587,0.1746,0.01587,0.19048,0.01587,0.20635,0.01587,0.22222,0.01587,0.2381,0.01587,0.25397,0.01587,0.26984,0.01587,0.28571,0.01587,0.30159,0.01587,0.31746,0.01587,0.33333,0.01587,0.34921,0.01587,0.36508,0.01587,0.38095,0.01587,0.39683,0.01587,0.4127,0.01587,0.42857,0.01587,0.44444,0.01587,0.46032,0.01587,0.47619,0.01587,0.49206,0.01587,0.50794,0.01587,0.52381,0.01587,0.53968,0.01587,0.55556,0.01587};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.57143,0.01587,0.5873,0.01587,0.60317,0.01587,0.61905,0.01587,0.63492,0.01587,0.65079,0.01587,0.66667,0.01587,0.68254,0.01587,0.69841,0.01587,0.71429,0.01587,0.73016,0.01587,0.74603,0.01587,0.7619,0.01587,0.77778,0.01587,0.79365,0.01587,0.80952,0.01587,0.8254,0.01587,0.84127,0.01587,0.85714,0.01587,0.87302,0.01587,0.88889,0.01587,0.90476,0.01587,0.92063,0.01587,0.93651,0.01587,0.95238,0.01587,0.96825,0.01587,0.98413,0.01587,0.99609,0.01587,0.00391,0.03175,0.01587,0.03175,0.03175,0.03175,0.04762,0.03175,0.06349,0.03175,0.07937,0.03175,0.09524,0.03175,0.11111,0.03175,0.12698,0.03175,0.14286,0.03175,0.15873,0.03175,0.1746,0.03175,0.19048,0.03175,0.20635,0.03175,0.22222,0.03175,0.2381,0.03175,0.25397,0.03175,0.26984,0.03175,0.28571,0.03175,0.30159,0.03175,0.31746,0.03175,0.33333,0.03175,0.34921,0.03175,0.36508,0.03175,0.38095,0.03175,0.39683,0.03175,0.4127,0.03175,0.42857,0.03175,0.44444,0.03175,0.46032,0.03175,0.47619,0.03175,0.49206,0.03175,0.50794,0.03175,0.52381,0.03175,0.53968,0.03175,0.55556,0.03175,0.57143,0.03175,0.5873,0.03175,0.60317,0.03175,0.61905,0.03175,0.63492,0.03175,0.65079,0.03175,0.66667,0.03175,0.68254,0.03175,0.69841,0.03175,0.71429,0.03175,0.73016,0.03175,0.74603,0.03175,0.7619,0.03175,0.77778,0.03175,0.79365,0.03175,0.80952,0.03175,0.8254,0.03175,0.84127,0.03175,0.85714,0.03175,0.87302,0.03175,0.88889,0.03175,0.90476,0.03175,0.92063,0.03175,0.93651,0.03175,0.95238,0.03175,0.96825,0.03175,0.98413,0.03175,0.99609,0.03175,0.00391,0.04762,0.01587,0.04762,0.03175,0.04762,0.04762,0.04762,0.06349,0.04762,0.07937,0.04762,0.09524,0.04762,0.11111,0.04762};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.12698,0.04762,0.14286,0.04762,0.15873,0.04762,0.1746,0.04762,0.19048,0.04762,0.20635,0.04762,0.22222,0.04762,0.2381,0.04762,0.25397,0.04762,0.26984,0.04762,0.28571,0.04762,0.30159,0.04762,0.31746,0.04762,0.33333,0.04762,0.34921,0.04762,0.36508,0.04762,0.38095,0.04762,0.39683,0.04762,0.4127,0.04762,0.42857,0.04762,0.44444,0.04762,0.46032,0.04762,0.47619,0.04762,0.49206,0.04762,0.50794,0.04762,0.52381,0.04762,0.53968,0.04762,0.55556,0.04762,0.57143,0.04762,0.5873,0.04762,0.60317,0.04762,0.61905,0.04762,0.63492,0.04762,0.65079,0.04762,0.66667,0.04762,0.68254,0.04762,0.69841,0.04762,0.71429,0.04762,0.73016,0.04762,0.74603,0.04762,0.7619,0.04762,0.77778,0.04762,0.79365,0.04762,0.80952,0.04762,0.8254,0.04762,0.84127,0.04762,0.85714,0.04762,0.87302,0.04762,0.88889,0.04762,0.90476,0.04762,0.92063,0.04762,0.93651,0.04762,0.95238,0.04762,0.96825,0.04762,0.98413,0.04762,0.99609,0.04762,0.00391,0.06349,0.01587,0.06349,0.03175,0.06349,0.04762,0.06349,0.06349,0.06349,0.07937,0.06349,0.09524,0.06349,0.11111,0.06349,0.12698,0.06349,0.14286,0.06349,0.15873,0.06349,0.1746,0.06349,0.19048,0.06349,0.20635,0.06349,0.22222,0.06349,0.2381,0.06349,0.25397,0.06349,0.26984,0.06349,0.28571,0.06349,0.30159,0.06349,0.31746,0.06349,0.33333,0.06349,0.34921,0.06349,0.36508,0.06349,0.38095,0.06349,0.39683,0.06349,0.4127,0.06349,0.42857,0.06349,0.44444,0.06349,0.46032,0.06349,0.47619,0.06349,0.49206,0.06349,0.50794,0.06349,0.52381,0.06349,0.53968,0.06349,0.55556,0.06349,0.57143,0.06349,0.5873,0.06349,0.60317,0.06349,0.61905,0.06349,0.63492,0.06349,0.65079,0.06349,0.66667,0.06349,0.68254,0.06349};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.69841,0.06349,0.71429,0.06349,0.73016,0.06349,0.74603,0.06349,0.7619,0.06349,0.77778,0.06349,0.79365,0.06349,0.80952,0.06349,0.8254,0.06349,0.84127,0.06349,0.85714,0.06349,0.87302,0.06349,0.88889,0.06349,0.90476,0.06349,0.92063,0.06349,0.93651,0.06349,0.95238,0.06349,0.96825,0.06349,0.98413,0.06349,0.99609,0.06349,0.00391,0.07937,0.01587,0.07937,0.03175,0.07937,0.04762,0.07937,0.06349,0.07937,0.07937,0.07937,0.09524,0.07937,0.11111,0.07937,0.12698,0.07937,0.14286,0.07937,0.15873,0.07937,0.1746,0.07937,0.19048,0.07937,0.20635,0.07937,0.22222,0.07937,0.2381,0.07937,0.25397,0.07937,0.26984,0.07937,0.28571,0.07937,0.30159,0.07937,0.31746,0.07937,0.33333,0.07937,0.34921,0.07937,0.36508,0.07937,0.38095,0.07937,0.39683,0.07937,0.4127,0.07937,0.42857,0.07937,0.44444,0.07937,0.46032,0.07937,0.47619,0.07937,0.49206,0.07937,0.50794,0.07937,0.52381,0.07937,0.53968,0.07937,0.55556,0.07937,0.57143,0.07937,0.5873,0.07937,0.60317,0.07937,0.61905,0.07937,0.63492,0.07937,0.65079,0.07937,0.66667,0.07937,0.68254,0.07937,0.69841,0.07937,0.71429,0.07937,0.73016,0.07937,0.74603,0.07937,0.7619,0.07937,0.77778,0.07937,0.79365,0.07937,0.80952,0.07937,0.8254,0.07937,0.84127,0.07937,0.85714,0.07937,0.87302,0.07937,0.88889,0.07937,0.90476,0.07937,0.92063,0.07937,0.93651,0.07937,0.95238,0.07937,0.96825,0.07937,0.98413,0.07937,0.99609,0.07937,0.00391,0.09524,0.01587,0.09524,0.03175,0.09524,0.04762,0.09524,0.06349,0.09524,0.07937,0.09524,0.09524,0.09524,0.11111,0.09524,0.12698,0.09524,0.14286,0.09524,0.15873,0.09524,0.1746,0.09524,0.19048,0.09524,0.20635,0.09524,0.22222,0.09524,0.2381,0.09524};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.25397,0.09524,0.26984,0.09524,0.28571,0.09524,0.30159,0.09524,0.31746,0.09524,0.33333,0.09524,0.34921,0.09524,0.36508,0.09524,0.38095,0.09524,0.39683,0.09524,0.4127,0.09524,0.42857,0.09524,0.44444,0.09524,0.46032,0.09524,0.47619,0.09524,0.49206,0.09524,0.50794,0.09524,0.52381,0.09524,0.53968,0.09524,0.55556,0.09524,0.57143,0.09524,0.5873,0.09524,0.60317,0.09524,0.61905,0.09524,0.63492,0.09524,0.65079,0.09524,0.66667,0.09524,0.68254,0.09524,0.69841,0.09524,0.71429,0.09524,0.73016,0.09524,0.74603,0.09524,0.7619,0.09524,0.77778,0.09524,0.79365,0.09524,0.80952,0.09524,0.8254,0.09524,0.84127,0.09524,0.85714,0.09524,0.87302,0.09524,0.88889,0.09524,0.90476,0.09524,0.92063,0.09524,0.93651,0.09524,0.95238,0.09524,0.96825,0.09524,0.98413,0.09524,0.99609,0.09524,0.00391,0.11111,0.01587,0.11111,0.03175,0.11111,0.04762,0.11111,0.06349,0.11111,0.07937,0.11111,0.09524,0.11111,0.11111,0.11111,0.12698,0.11111,0.14286,0.11111,0.15873,0.11111,0.1746,0.11111,0.19048,0.11111,0.20635,0.11111,0.22222,0.11111,0.2381,0.11111,0.25397,0.11111,0.26984,0.11111,0.28571,0.11111,0.30159,0.11111,0.31746,0.11111,0.33333,0.11111,0.34921,0.11111,0.36508,0.11111,0.38095,0.11111,0.39683,0.11111,0.4127,0.11111,0.42857,0.11111,0.44444,0.11111,0.46032,0.11111,0.47619,0.11111,0.49206,0.11111,0.50794,0.11111,0.52381,0.11111,0.53968,0.11111,0.55556,0.11111,0.57143,0.11111,0.5873,0.11111,0.60317,0.11111,0.61905,0.11111,0.63492,0.11111,0.65079,0.11111,0.66667,0.11111,0.68254,0.11111,0.69841,0.11111,0.71429,0.11111,0.73016,0.11111,0.74603,0.11111,0.7619,0.11111,0.77778,0.11111,0.79365,0.11111,0.80952,0.11111};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.8254,0.11111,0.84127,0.11111,0.85714,0.11111,0.87302,0.11111,0.88889,0.11111,0.90476,0.11111,0.92063,0.11111,0.93651,0.11111,0.95238,0.11111,0.96825,0.11111,0.98413,0.11111,0.99609,0.11111,0.00391,0.12698,0.01587,0.12698,0.03175,0.12698,0.04762,0.12698,0.06349,0.12698,0.07937,0.12698,0.09524,0.12698,0.11111,0.12698,0.12698,0.12698,0.14286,0.12698,0.15873,0.12698,0.1746,0.12698,0.19048,0.12698,0.20635,0.12698,0.22222,0.12698,0.2381,0.12698,0.25397,0.12698,0.26984,0.12698,0.28571,0.12698,0.30159,0.12698,0.31746,0.12698,0.33333,0.12698,0.34921,0.12698,0.36508,0.12698,0.38095,0.12698,0.39683,0.12698,0.4127,0.12698,0.42857,0.12698,0.44444,0.12698,0.46032,0.12698,0.47619,0.12698,0.49206,0.12698,0.50794,0.12698,0.52381,0.12698,0.53968,0.12698,0.55556,0.12698,0.57143,0.12698,0.5873,0.12698,0.60317,0.12698,0.61905,0.12698,0.63492,0.12698,0.65079,0.12698,0.66667,0.12698,0.68254,0.12698,0.69841,0.12698,0.71429,0.12698,0.73016,0.12698,0.74603,0.12698,0.7619,0.12698,0.77778,0.12698,0.79365,0.12698,0.80952,0.12698,0.8254,0.12698,0.84127,0.12698,0.85714,0.12698,0.87302,0.12698,0.88889,0.12698,0.90476,0.12698,0.92063,0.12698,0.93651,0.12698,0.95238,0.12698,0.96825,0.12698,0.98413,0.12698,0.99609,0.12698,0.00391,0.14286,0.01587,0.14286,0.03175,0.14286,0.04762,0.14286,0.06349,0.14286,0.07937,0.14286,0.09524,0.14286,0.11111,0.14286,0.12698,0.14286,0.14286,0.14286,0.15873,0.14286,0.1746,0.14286,0.19048,0.14286,0.20635,0.14286,0.22222,0.14286,0.2381,0.14286,0.25397,0.14286,0.26984,0.14286,0.28571,0.14286,0.30159,0.14286,0.31746,0.14286,0.33333,0.14286,0.34921,0.14286,0.36508,0.14286};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.38095,0.14286,0.39683,0.14286,0.4127,0.14286,0.42857,0.14286,0.44444,0.14286,0.46032,0.14286,0.47619,0.14286,0.49206,0.14286,0.50794,0.14286,0.52381,0.14286,0.53968,0.14286,0.55556,0.14286,0.57143,0.14286,0.5873,0.14286,0.60317,0.14286,0.61905,0.14286,0.63492,0.14286,0.65079,0.14286,0.66667,0.14286,0.68254,0.14286,0.69841,0.14286,0.71429,0.14286,0.73016,0.14286,0.74603,0.14286,0.7619,0.14286,0.77778,0.14286,0.79365,0.14286,0.80952,0.14286,0.8254,0.14286,0.84127,0.14286,0.85714,0.14286,0.87302,0.14286,0.88889,0.14286,0.90476,0.14286,0.92063,0.14286,0.93651,0.14286,0.95238,0.14286,0.96825,0.14286,0.98413,0.14286,0.99609,0.14286,0.00391,0.15873,0.01587,0.15873,0.03175,0.15873,0.04762,0.15873,0.06349,0.15873,0.07937,0.15873,0.09524,0.15873,0.11111,0.15873,0.12698,0.15873,0.14286,0.15873,0.15873,0.15873,0.1746,0.15873,0.19048,0.15873,0.20635,0.15873,0.22222,0.15873,0.2381,0.15873,0.25397,0.15873,0.26984,0.15873,0.28571,0.15873,0.30159,0.15873,0.31746,0.15873,0.33333,0.15873,0.34921,0.15873,0.36508,0.15873,0.38095,0.15873,0.39683,0.15873,0.4127,0.15873,0.42857,0.15873,0.44444,0.15873,0.46032,0.15873,0.47619,0.15873,0.49206,0.15873,0.50794,0.15873,0.52381,0.15873,0.53968,0.15873,0.55556,0.15873,0.57143,0.15873,0.5873,0.15873,0.60317,0.15873,0.61905,0.15873,0.63492,0.15873,0.65079,0.15873,0.66667,0.15873,0.68254,0.15873,0.69841,0.15873,0.71429,0.15873,0.73016,0.15873,0.74603,0.15873,0.7619,0.15873,0.77778,0.15873,0.79365,0.15873,0.80952,0.15873,0.8254,0.15873,0.84127,0.15873,0.85714,0.15873,0.87302,0.15873,0.88889,0.15873,0.90476,0.15873,0.92063,0.15873,0.93651,0.15873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.95238,0.15873,0.96825,0.15873,0.98413,0.15873,0.99609,0.15873,0.00391,0.1746,0.01587,0.1746,0.03175,0.1746,0.04762,0.1746,0.06349,0.1746,0.07937,0.1746,0.09524,0.1746,0.11111,0.1746,0.12698,0.1746,0.14286,0.1746,0.15873,0.1746,0.1746,0.1746,0.19048,0.1746,0.20635,0.1746,0.22222,0.1746,0.2381,0.1746,0.25397,0.1746,0.26984,0.1746,0.28571,0.1746,0.30159,0.1746,0.31746,0.1746,0.33333,0.1746,0.34921,0.1746,0.36508,0.1746,0.38095,0.1746,0.39683,0.1746,0.4127,0.1746,0.42857,0.1746,0.44444,0.1746,0.46032,0.1746,0.47619,0.1746,0.49206,0.1746,0.50794,0.1746,0.52381,0.1746,0.53968,0.1746,0.55556,0.1746,0.57143,0.1746,0.5873,0.1746,0.60317,0.1746,0.61905,0.1746,0.63492,0.1746,0.65079,0.1746,0.66667,0.1746,0.68254,0.1746,0.69841,0.1746,0.71429,0.1746,0.73016,0.1746,0.74603,0.1746,0.7619,0.1746,0.77778,0.1746,0.79365,0.1746,0.80952,0.1746,0.8254,0.1746,0.84127,0.1746,0.85714,0.1746,0.87302,0.1746,0.88889,0.1746,0.90476,0.1746,0.92063,0.1746,0.93651,0.1746,0.95238,0.1746,0.96825,0.1746,0.98413,0.1746,0.99609,0.1746,0.00391,0.19048,0.01587,0.19048,0.03175,0.19048,0.04762,0.19048,0.06349,0.19048,0.07937,0.19048,0.09524,0.19048,0.11111,0.19048,0.12698,0.19048,0.14286,0.19048,0.15873,0.19048,0.1746,0.19048,0.19048,0.19048,0.20635,0.19048,0.22222,0.19048,0.2381,0.19048,0.25397,0.19048,0.26984,0.19048,0.28571,0.19048,0.30159,0.19048,0.31746,0.19048,0.33333,0.19048,0.34921,0.19048,0.36508,0.19048,0.38095,0.19048,0.39683,0.19048,0.4127,0.19048,0.42857,0.19048,0.44444,0.19048,0.46032,0.19048,0.47619,0.19048,0.49206,0.19048};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.50794,0.19048,0.52381,0.19048,0.53968,0.19048,0.55556,0.19048,0.57143,0.19048,0.5873,0.19048,0.60317,0.19048,0.61905,0.19048,0.63492,0.19048,0.65079,0.19048,0.66667,0.19048,0.68254,0.19048,0.69841,0.19048,0.71429,0.19048,0.73016,0.19048,0.74603,0.19048,0.7619,0.19048,0.77778,0.19048,0.79365,0.19048,0.80952,0.19048,0.8254,0.19048,0.84127,0.19048,0.85714,0.19048,0.87302,0.19048,0.88889,0.19048,0.90476,0.19048,0.92063,0.19048,0.93651,0.19048,0.95238,0.19048,0.96825,0.19048,0.98413,0.19048,0.99609,0.19048,0.00391,0.20635,0.01587,0.20635,0.03175,0.20635,0.04762,0.20635,0.06349,0.20635,0.07937,0.20635,0.09524,0.20635,0.11111,0.20635,0.12698,0.20635,0.14286,0.20635,0.15873,0.20635,0.1746,0.20635,0.19048,0.20635,0.20635,0.20635,0.22222,0.20635,0.2381,0.20635,0.25397,0.20635,0.26984,0.20635,0.28571,0.20635,0.30159,0.20635,0.31746,0.20635,0.33333,0.20635,0.34921,0.20635,0.36508,0.20635,0.38095,0.20635,0.39683,0.20635,0.4127,0.20635,0.42857,0.20635,0.44444,0.20635,0.46032,0.20635,0.47619,0.20635,0.49206,0.20635,0.50794,0.20635,0.52381,0.20635,0.53968,0.20635,0.55556,0.20635,0.57143,0.20635,0.5873,0.20635,0.60317,0.20635,0.61905,0.20635,0.63492,0.20635,0.65079,0.20635,0.66667,0.20635,0.68254,0.20635,0.69841,0.20635,0.71429,0.20635,0.73016,0.20635,0.74603,0.20635,0.7619,0.20635,0.77778,0.20635,0.79365,0.20635,0.80952,0.20635,0.8254,0.20635,0.84127,0.20635,0.85714,0.20635,0.87302,0.20635,0.88889,0.20635,0.90476,0.20635,0.92063,0.20635,0.93651,0.20635,0.95238,0.20635,0.96825,0.20635,0.98413,0.20635,0.99609,0.20635,0.00391,0.22222,0.01587,0.22222,0.03175,0.22222,0.04762,0.22222};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.06349,0.22222,0.07937,0.22222,0.09524,0.22222,0.11111,0.22222,0.12698,0.22222,0.14286,0.22222,0.15873,0.22222,0.1746,0.22222,0.19048,0.22222,0.20635,0.22222,0.22222,0.22222,0.2381,0.22222,0.25397,0.22222,0.26984,0.22222,0.28571,0.22222,0.30159,0.22222,0.31746,0.22222,0.33333,0.22222,0.34921,0.22222,0.36508,0.22222,0.38095,0.22222,0.39683,0.22222,0.4127,0.22222,0.42857,0.22222,0.44444,0.22222,0.46032,0.22222,0.47619,0.22222,0.49206,0.22222,0.50794,0.22222,0.52381,0.22222,0.53968,0.22222,0.55556,0.22222,0.57143,0.22222,0.5873,0.22222,0.60317,0.22222,0.61905,0.22222,0.63492,0.22222,0.65079,0.22222,0.66667,0.22222,0.68254,0.22222,0.69841,0.22222,0.71429,0.22222,0.73016,0.22222,0.74603,0.22222,0.7619,0.22222,0.77778,0.22222,0.79365,0.22222,0.80952,0.22222,0.8254,0.22222,0.84127,0.22222,0.85714,0.22222,0.87302,0.22222,0.88889,0.22222,0.90476,0.22222,0.92063,0.22222,0.93651,0.22222,0.95238,0.22222,0.96825,0.22222,0.98413,0.22222,0.99609,0.22222,0.00391,0.2381,0.01587,0.2381,0.03175,0.2381,0.04762,0.2381,0.06349,0.2381,0.07937,0.2381,0.09524,0.2381,0.11111,0.2381,0.12698,0.2381,0.14286,0.2381,0.15873,0.2381,0.1746,0.2381,0.19048,0.2381,0.20635,0.2381,0.22222,0.2381,0.2381,0.2381,0.25397,0.2381,0.26984,0.2381,0.28571,0.2381,0.30159,0.2381,0.31746,0.2381,0.33333,0.2381,0.34921,0.2381,0.36508,0.2381,0.38095,0.2381,0.39683,0.2381,0.4127,0.2381,0.42857,0.2381,0.44444,0.2381,0.46032,0.2381,0.47619,0.2381,0.49206,0.2381,0.50794,0.2381,0.52381,0.2381,0.53968,0.2381,0.55556,0.2381,0.57143,0.2381,0.5873,0.2381,0.60317,0.2381,0.61905,0.2381};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.63492,0.2381,0.65079,0.2381,0.66667,0.2381,0.68254,0.2381,0.69841,0.2381,0.71429,0.2381,0.73016,0.2381,0.74603,0.2381,0.7619,0.2381,0.77778,0.2381,0.79365,0.2381,0.80952,0.2381,0.8254,0.2381,0.84127,0.2381,0.85714,0.2381,0.87302,0.2381,0.88889,0.2381,0.90476,0.2381,0.92063,0.2381,0.93651,0.2381,0.95238,0.2381,0.96825,0.2381,0.98413,0.2381,0.99609,0.2381,0.00391,0.25397,0.01587,0.25397,0.03175,0.25397,0.04762,0.25397,0.06349,0.25397,0.07937,0.25397,0.09524,0.25397,0.11111,0.25397,0.12698,0.25397,0.14286,0.25397,0.15873,0.25397,0.1746,0.25397,0.19048,0.25397,0.20635,0.25397,0.22222,0.25397,0.2381,0.25397,0.25397,0.25397,0.26984,0.25397,0.28571,0.25397,0.30159,0.25397,0.31746,0.25397,0.33333,0.25397,0.34921,0.25397,0.36508,0.25397,0.38095,0.25397,0.39683,0.25397,0.4127,0.25397,0.42857,0.25397,0.44444,0.25397,0.46032,0.25397,0.47619,0.25397,0.49206,0.25397,0.50794,0.25397,0.52381,0.25397,0.53968,0.25397,0.55556,0.25397,0.57143,0.25397,0.5873,0.25397,0.60317,0.25397,0.61905,0.25397,0.63492,0.25397,0.65079,0.25397,0.66667,0.25397,0.68254,0.25397,0.69841,0.25397,0.71429,0.25397,0.73016,0.25397,0.74603,0.25397,0.7619,0.25397,0.77778,0.25397,0.79365,0.25397,0.80952,0.25397,0.8254,0.25397,0.84127,0.25397,0.85714,0.25397,0.87302,0.25397,0.88889,0.25397,0.90476,0.25397,0.92063,0.25397,0.93651,0.25397,0.95238,0.25397,0.96825,0.25397,0.98413,0.25397,0.99609,0.25397,0.00391,0.26984,0.01587,0.26984,0.03175,0.26984,0.04762,0.26984,0.06349,0.26984,0.07937,0.26984,0.09524,0.26984,0.11111,0.26984,0.12698,0.26984,0.14286,0.26984,0.15873,0.26984,0.1746,0.26984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.19048,0.26984,0.20635,0.26984,0.22222,0.26984,0.2381,0.26984,0.25397,0.26984,0.26984,0.26984,0.28571,0.26984,0.30159,0.26984,0.31746,0.26984,0.33333,0.26984,0.34921,0.26984,0.36508,0.26984,0.38095,0.26984,0.39683,0.26984,0.4127,0.26984,0.42857,0.26984,0.44444,0.26984,0.46032,0.26984,0.47619,0.26984,0.49206,0.26984,0.50794,0.26984,0.52381,0.26984,0.53968,0.26984,0.55556,0.26984,0.57143,0.26984,0.5873,0.26984,0.60317,0.26984,0.61905,0.26984,0.63492,0.26984,0.65079,0.26984,0.66667,0.26984,0.68254,0.26984,0.69841,0.26984,0.71429,0.26984,0.73016,0.26984,0.74603,0.26984,0.7619,0.26984,0.77778,0.26984,0.79365,0.26984,0.80952,0.26984,0.8254,0.26984,0.84127,0.26984,0.85714,0.26984,0.87302,0.26984,0.88889,0.26984,0.90476,0.26984,0.92063,0.26984,0.93651,0.26984,0.95238,0.26984,0.96825,0.26984,0.98413,0.26984,0.99609,0.26984,0.00391,0.28571,0.01587,0.28571,0.03175,0.28571,0.04762,0.28571,0.06349,0.28571,0.07937,0.28571,0.09524,0.28571,0.11111,0.28571,0.12698,0.28571,0.14286,0.28571,0.15873,0.28571,0.1746,0.28571,0.19048,0.28571,0.20635,0.28571,0.22222,0.28571,0.2381,0.28571,0.25397,0.28571,0.26984,0.28571,0.28571,0.28571,0.30159,0.28571,0.31746,0.28571,0.33333,0.28571,0.34921,0.28571,0.36508,0.28571,0.38095,0.28571,0.39683,0.28571,0.4127,0.28571,0.42857,0.28571,0.44444,0.28571,0.46032,0.28571,0.47619,0.28571,0.49206,0.28571,0.50794,0.28571,0.52381,0.28571,0.53968,0.28571,0.55556,0.28571,0.57143,0.28571,0.5873,0.28571,0.60317,0.28571,0.61905,0.28571,0.63492,0.28571,0.65079,0.28571,0.66667,0.28571,0.68254,0.28571,0.69841,0.28571,0.71429,0.28571,0.73016,0.28571,0.74603,0.28571};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.7619,0.28571,0.77778,0.28571,0.79365,0.28571,0.80952,0.28571,0.8254,0.28571,0.84127,0.28571,0.85714,0.28571,0.87302,0.28571,0.88889,0.28571,0.90476,0.28571,0.92063,0.28571,0.93651,0.28571,0.95238,0.28571,0.96825,0.28571,0.98413,0.28571,0.99609,0.28571,0.00391,0.30159,0.01587,0.30159,0.03175,0.30159,0.04762,0.30159,0.06349,0.30159,0.07937,0.30159,0.09524,0.30159,0.11111,0.30159,0.12698,0.30159,0.14286,0.30159,0.15873,0.30159,0.1746,0.30159,0.19048,0.30159,0.20635,0.30159,0.22222,0.30159,0.2381,0.30159,0.25397,0.30159,0.26984,0.30159,0.28571,0.30159,0.30159,0.30159,0.31746,0.30159,0.33333,0.30159,0.34921,0.30159,0.36508,0.30159,0.38095,0.30159,0.39683,0.30159,0.4127,0.30159,0.42857,0.30159,0.44444,0.30159,0.46032,0.30159,0.47619,0.30159,0.49206,0.30159,0.50794,0.30159,0.52381,0.30159,0.53968,0.30159,0.55556,0.30159,0.57143,0.30159,0.5873,0.30159,0.60317,0.30159,0.61905,0.30159,0.63492,0.30159,0.65079,0.30159,0.66667,0.30159,0.68254,0.30159,0.69841,0.30159,0.71429,0.30159,0.73016,0.30159,0.74603,0.30159,0.7619,0.30159,0.77778,0.30159,0.79365,0.30159,0.80952,0.30159,0.8254,0.30159,0.84127,0.30159,0.85714,0.30159,0.87302,0.30159,0.88889,0.30159,0.90476,0.30159,0.92063,0.30159,0.93651,0.30159,0.95238,0.30159,0.96825,0.30159,0.98413,0.30159,0.99609,0.30159,0.00391,0.31746,0.01587,0.31746,0.03175,0.31746,0.04762,0.31746,0.06349,0.31746,0.07937,0.31746,0.09524,0.31746,0.11111,0.31746,0.12698,0.31746,0.14286,0.31746,0.15873,0.31746,0.1746,0.31746,0.19048,0.31746,0.20635,0.31746,0.22222,0.31746,0.2381,0.31746,0.25397,0.31746,0.26984,0.31746,0.28571,0.31746,0.30159,0.31746};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.31746,0.31746,0.33333,0.31746,0.34921,0.31746,0.36508,0.31746,0.38095,0.31746,0.39683,0.31746,0.4127,0.31746,0.42857,0.31746,0.44444,0.31746,0.46032,0.31746,0.47619,0.31746,0.49206,0.31746,0.50794,0.31746,0.52381,0.31746,0.53968,0.31746,0.55556,0.31746,0.57143,0.31746,0.5873,0.31746,0.60317,0.31746,0.61905,0.31746,0.63492,0.31746,0.65079,0.31746,0.66667,0.31746,0.68254,0.31746,0.69841,0.31746,0.71429,0.31746,0.73016,0.31746,0.74603,0.31746,0.7619,0.31746,0.77778,0.31746,0.79365,0.31746,0.80952,0.31746,0.8254,0.31746,0.84127,0.31746,0.85714,0.31746,0.87302,0.31746,0.88889,0.31746,0.90476,0.31746,0.92063,0.31746,0.93651,0.31746,0.95238,0.31746,0.96825,0.31746,0.98413,0.31746,0.99609,0.31746,0.00391,0.33333,0.01587,0.33333,0.03175,0.33333,0.04762,0.33333,0.06349,0.33333,0.07937,0.33333,0.09524,0.33333,0.11111,0.33333,0.12698,0.33333,0.14286,0.33333,0.15873,0.33333,0.1746,0.33333,0.19048,0.33333,0.20635,0.33333,0.22222,0.33333,0.2381,0.33333,0.25397,0.33333,0.26984,0.33333,0.28571,0.33333,0.30159,0.33333,0.31746,0.33333,0.33333,0.33333,0.34921,0.33333,0.36508,0.33333,0.38095,0.33333,0.39683,0.33333,0.4127,0.33333,0.42857,0.33333,0.44444,0.33333,0.46032,0.33333,0.47619,0.33333,0.49206,0.33333,0.50794,0.33333,0.52381,0.33333,0.53968,0.33333,0.55556,0.33333,0.57143,0.33333,0.5873,0.33333,0.60317,0.33333,0.61905,0.33333,0.63492,0.33333,0.65079,0.33333,0.66667,0.33333,0.68254,0.33333,0.69841,0.33333,0.71429,0.33333,0.73016,0.33333,0.74603,0.33333,0.7619,0.33333,0.77778,0.33333,0.79365,0.33333,0.80952,0.33333,0.8254,0.33333,0.84127,0.33333,0.85714,0.33333,0.87302,0.33333};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.88889,0.33333,0.90476,0.33333,0.92063,0.33333,0.93651,0.33333,0.95238,0.33333,0.96825,0.33333,0.98413,0.33333,0.99609,0.33333,0.00391,0.34921,0.01587,0.34921,0.03175,0.34921,0.04762,0.34921,0.06349,0.34921,0.07937,0.34921,0.09524,0.34921,0.11111,0.34921,0.12698,0.34921,0.14286,0.34921,0.15873,0.34921,0.1746,0.34921,0.19048,0.34921,0.20635,0.34921,0.22222,0.34921,0.2381,0.34921,0.25397,0.34921,0.26984,0.34921,0.28571,0.34921,0.30159,0.34921,0.31746,0.34921,0.33333,0.34921,0.34921,0.34921,0.36508,0.34921,0.38095,0.34921,0.39683,0.34921,0.4127,0.34921,0.42857,0.34921,0.44444,0.34921,0.46032,0.34921,0.47619,0.34921,0.49206,0.34921,0.50794,0.34921,0.52381,0.34921,0.53968,0.34921,0.55556,0.34921,0.57143,0.34921,0.5873,0.34921,0.60317,0.34921,0.61905,0.34921,0.63492,0.34921,0.65079,0.34921,0.66667,0.34921,0.68254,0.34921,0.69841,0.34921,0.71429,0.34921,0.73016,0.34921,0.74603,0.34921,0.7619,0.34921,0.77778,0.34921,0.79365,0.34921,0.80952,0.34921,0.8254,0.34921,0.84127,0.34921,0.85714,0.34921,0.87302,0.34921,0.88889,0.34921,0.90476,0.34921,0.92063,0.34921,0.93651,0.34921,0.95238,0.34921,0.96825,0.34921,0.98413,0.34921,0.99609,0.34921,0.00391,0.36508,0.01587,0.36508,0.03175,0.36508,0.04762,0.36508,0.06349,0.36508,0.07937,0.36508,0.09524,0.36508,0.11111,0.36508,0.12698,0.36508,0.14286,0.36508,0.15873,0.36508,0.1746,0.36508,0.19048,0.36508,0.20635,0.36508,0.22222,0.36508,0.2381,0.36508,0.25397,0.36508,0.26984,0.36508,0.28571,0.36508,0.30159,0.36508,0.31746,0.36508,0.33333,0.36508,0.34921,0.36508,0.36508,0.36508,0.38095,0.36508,0.39683,0.36508,0.4127,0.36508,0.42857,0.36508};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.44444,0.36508,0.46032,0.36508,0.47619,0.36508,0.49206,0.36508,0.50794,0.36508,0.52381,0.36508,0.53968,0.36508,0.55556,0.36508,0.57143,0.36508,0.5873,0.36508,0.60317,0.36508,0.61905,0.36508,0.63492,0.36508,0.65079,0.36508,0.66667,0.36508,0.68254,0.36508,0.69841,0.36508,0.71429,0.36508,0.73016,0.36508,0.74603,0.36508,0.7619,0.36508,0.77778,0.36508,0.79365,0.36508,0.80952,0.36508,0.8254,0.36508,0.84127,0.36508,0.85714,0.36508,0.87302,0.36508,0.88889,0.36508,0.90476,0.36508,0.92063,0.36508,0.93651,0.36508,0.95238,0.36508,0.96825,0.36508,0.98413,0.36508,0.99609,0.36508,0.00391,0.38095,0.01587,0.38095,0.03175,0.38095,0.04762,0.38095,0.06349,0.38095,0.07937,0.38095,0.09524,0.38095,0.11111,0.38095,0.12698,0.38095,0.14286,0.38095,0.15873,0.38095,0.1746,0.38095,0.19048,0.38095,0.20635,0.38095,0.22222,0.38095,0.2381,0.38095,0.25397,0.38095,0.26984,0.38095,0.28571,0.38095,0.30159,0.38095,0.31746,0.38095,0.33333,0.38095,0.34921,0.38095,0.36508,0.38095,0.38095,0.38095,0.39683,0.38095,0.4127,0.38095,0.42857,0.38095,0.44444,0.38095,0.46032,0.38095,0.47619,0.38095,0.49206,0.38095,0.50794,0.38095,0.52381,0.38095,0.53968,0.38095,0.55556,0.38095,0.57143,0.38095,0.5873,0.38095,0.60317,0.38095,0.61905,0.38095,0.63492,0.38095,0.65079,0.38095,0.66667,0.38095,0.68254,0.38095,0.69841,0.38095,0.71429,0.38095,0.73016,0.38095,0.74603,0.38095,0.7619,0.38095,0.77778,0.38095,0.79365,0.38095,0.80952,0.38095,0.8254,0.38095,0.84127,0.38095,0.85714,0.38095,0.87302,0.38095,0.88889,0.38095,0.90476,0.38095,0.92063,0.38095,0.93651,0.38095,0.95238,0.38095,0.96825,0.38095,0.98413,0.38095,0.99609,0.38095};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.00391,0.39683,0.01587,0.39683,0.03175,0.39683,0.04762,0.39683,0.06349,0.39683,0.07937,0.39683,0.09524,0.39683,0.11111,0.39683,0.12698,0.39683,0.14286,0.39683,0.15873,0.39683,0.1746,0.39683,0.19048,0.39683,0.20635,0.39683,0.22222,0.39683,0.2381,0.39683,0.25397,0.39683,0.26984,0.39683,0.28571,0.39683,0.30159,0.39683,0.31746,0.39683,0.33333,0.39683,0.34921,0.39683,0.36508,0.39683,0.38095,0.39683,0.39683,0.39683,0.4127,0.39683,0.42857,0.39683,0.44444,0.39683,0.46032,0.39683,0.47619,0.39683,0.49206,0.39683,0.50794,0.39683,0.52381,0.39683,0.53968,0.39683,0.55556,0.39683,0.57143,0.39683,0.5873,0.39683,0.60317,0.39683,0.61905,0.39683,0.63492,0.39683,0.65079,0.39683,0.66667,0.39683,0.68254,0.39683,0.69841,0.39683,0.71429,0.39683,0.73016,0.39683,0.74603,0.39683,0.7619,0.39683,0.77778,0.39683,0.79365,0.39683,0.80952,0.39683,0.8254,0.39683,0.84127,0.39683,0.85714,0.39683,0.87302,0.39683,0.88889,0.39683,0.90476,0.39683,0.92063,0.39683,0.93651,0.39683,0.95238,0.39683,0.96825,0.39683,0.98413,0.39683,0.99609,0.39683,0.00391,0.4127,0.01587,0.4127,0.03175,0.4127,0.04762,0.4127,0.06349,0.4127,0.07937,0.4127,0.09524,0.4127,0.11111,0.4127,0.12698,0.4127,0.14286,0.4127,0.15873,0.4127,0.1746,0.4127,0.19048,0.4127,0.20635,0.4127,0.22222,0.4127,0.2381,0.4127,0.25397,0.4127,0.26984,0.4127,0.28571,0.4127,0.30159,0.4127,0.31746,0.4127,0.33333,0.4127,0.34921,0.4127,0.36508,0.4127,0.38095,0.4127,0.39683,0.4127,0.4127,0.4127,0.42857,0.4127,0.44444,0.4127,0.46032,0.4127,0.47619,0.4127,0.49206,0.4127,0.50794,0.4127,0.52381,0.4127,0.53968,0.4127,0.55556,0.4127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.57143,0.4127,0.5873,0.4127,0.60317,0.4127,0.61905,0.4127,0.63492,0.4127,0.65079,0.4127,0.66667,0.4127,0.68254,0.4127,0.69841,0.4127,0.71429,0.4127,0.73016,0.4127,0.74603,0.4127,0.7619,0.4127,0.77778,0.4127,0.79365,0.4127,0.80952,0.4127,0.8254,0.4127,0.84127,0.4127,0.85714,0.4127,0.87302,0.4127,0.88889,0.4127,0.90476,0.4127,0.92063,0.4127,0.93651,0.4127,0.95238,0.4127,0.96825,0.4127,0.98413,0.4127,0.99609,0.4127,0.00391,0.42857,0.01587,0.42857,0.03175,0.42857,0.04762,0.42857,0.06349,0.42857,0.07937,0.42857,0.09524,0.42857,0.11111,0.42857,0.12698,0.42857,0.14286,0.42857,0.15873,0.42857,0.1746,0.42857,0.19048,0.42857,0.20635,0.42857,0.22222,0.42857,0.2381,0.42857,0.25397,0.42857,0.26984,0.42857,0.28571,0.42857,0.30159,0.42857,0.31746,0.42857,0.33333,0.42857,0.34921,0.42857,0.36508,0.42857,0.38095,0.42857,0.39683,0.42857,0.4127,0.42857,0.42857,0.42857,0.44444,0.42857,0.46032,0.42857,0.47619,0.42857,0.49206,0.42857,0.50794,0.42857,0.52381,0.42857,0.53968,0.42857,0.55556,0.42857,0.57143,0.42857,0.5873,0.42857,0.60317,0.42857,0.61905,0.42857,0.63492,0.42857,0.65079,0.42857,0.66667,0.42857,0.68254,0.42857,0.69841,0.42857,0.71429,0.42857,0.73016,0.42857,0.74603,0.42857,0.7619,0.42857,0.77778,0.42857,0.79365,0.42857,0.80952,0.42857,0.8254,0.42857,0.84127,0.42857,0.85714,0.42857,0.87302,0.42857,0.88889,0.42857,0.90476,0.42857,0.92063,0.42857,0.93651,0.42857,0.95238,0.42857,0.96825,0.42857,0.98413,0.42857,0.99609,0.42857,0.00391,0.44444,0.01587,0.44444,0.03175,0.44444,0.04762,0.44444,0.06349,0.44444,0.07937,0.44444,0.09524,0.44444,0.11111,0.44444};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.12698,0.44444,0.14286,0.44444,0.15873,0.44444,0.1746,0.44444,0.19048,0.44444,0.20635,0.44444,0.22222,0.44444,0.2381,0.44444,0.25397,0.44444,0.26984,0.44444,0.28571,0.44444,0.30159,0.44444,0.31746,0.44444,0.33333,0.44444,0.34921,0.44444,0.36508,0.44444,0.38095,0.44444,0.39683,0.44444,0.4127,0.44444,0.42857,0.44444,0.44444,0.44444,0.46032,0.44444,0.47619,0.44444,0.49206,0.44444,0.50794,0.44444,0.52381,0.44444,0.53968,0.44444,0.55556,0.44444,0.57143,0.44444,0.5873,0.44444,0.60317,0.44444,0.61905,0.44444,0.63492,0.44444,0.65079,0.44444,0.66667,0.44444,0.68254,0.44444,0.69841,0.44444,0.71429,0.44444,0.73016,0.44444,0.74603,0.44444,0.7619,0.44444,0.77778,0.44444,0.79365,0.44444,0.80952,0.44444,0.8254,0.44444,0.84127,0.44444,0.85714,0.44444,0.87302,0.44444,0.88889,0.44444,0.90476,0.44444,0.92063,0.44444,0.93651,0.44444,0.95238,0.44444,0.96825,0.44444,0.98413,0.44444,0.99609,0.44444,0.00391,0.46032,0.01587,0.46032,0.03175,0.46032,0.04762,0.46032,0.06349,0.46032,0.07937,0.46032,0.09524,0.46032,0.11111,0.46032,0.12698,0.46032,0.14286,0.46032,0.15873,0.46032,0.1746,0.46032,0.19048,0.46032,0.20635,0.46032,0.22222,0.46032,0.2381,0.46032,0.25397,0.46032,0.26984,0.46032,0.28571,0.46032,0.30159,0.46032,0.31746,0.46032,0.33333,0.46032,0.34921,0.46032,0.36508,0.46032,0.38095,0.46032,0.39683,0.46032,0.4127,0.46032,0.42857,0.46032,0.44444,0.46032,0.46032,0.46032,0.47619,0.46032,0.49206,0.46032,0.50794,0.46032,0.52381,0.46032,0.53968,0.46032,0.55556,0.46032,0.57143,0.46032,0.5873,0.46032,0.60317,0.46032,0.61905,0.46032,0.63492,0.46032,0.65079,0.46032,0.66667,0.46032,0.68254,0.46032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.69841,0.46032,0.71429,0.46032,0.73016,0.46032,0.74603,0.46032,0.7619,0.46032,0.77778,0.46032,0.79365,0.46032,0.80952,0.46032,0.8254,0.46032,0.84127,0.46032,0.85714,0.46032,0.87302,0.46032,0.88889,0.46032,0.90476,0.46032,0.92063,0.46032,0.93651,0.46032,0.95238,0.46032,0.96825,0.46032,0.98413,0.46032,0.99609,0.46032,0.00391,0.47619,0.01587,0.47619,0.03175,0.47619,0.04762,0.47619,0.06349,0.47619,0.07937,0.47619,0.09524,0.47619,0.11111,0.47619,0.12698,0.47619,0.14286,0.47619,0.15873,0.47619,0.1746,0.47619,0.19048,0.47619,0.20635,0.47619,0.22222,0.47619,0.2381,0.47619,0.25397,0.47619,0.26984,0.47619,0.28571,0.47619,0.30159,0.47619,0.31746,0.47619,0.33333,0.47619,0.34921,0.47619,0.36508,0.47619,0.38095,0.47619,0.39683,0.47619,0.4127,0.47619,0.42857,0.47619,0.44444,0.47619,0.46032,0.47619,0.47619,0.47619,0.49206,0.47619,0.50794,0.47619,0.52381,0.47619,0.53968,0.47619,0.55556,0.47619,0.57143,0.47619,0.5873,0.47619,0.60317,0.47619,0.61905,0.47619,0.63492,0.47619,0.65079,0.47619,0.66667,0.47619,0.68254,0.47619,0.69841,0.47619,0.71429,0.47619,0.73016,0.47619,0.74603,0.47619,0.7619,0.47619,0.77778,0.47619,0.79365,0.47619,0.80952,0.47619,0.8254,0.47619,0.84127,0.47619,0.85714,0.47619,0.87302,0.47619,0.88889,0.47619,0.90476,0.47619,0.92063,0.47619,0.93651,0.47619,0.95238,0.47619,0.96825,0.47619,0.98413,0.47619,0.99609,0.47619,0.00391,0.49206,0.01587,0.49206,0.03175,0.49206,0.04762,0.49206,0.06349,0.49206,0.07937,0.49206,0.09524,0.49206,0.11111,0.49206,0.12698,0.49206,0.14286,0.49206,0.15873,0.49206,0.1746,0.49206,0.19048,0.49206,0.20635,0.49206,0.22222,0.49206,0.2381,0.49206};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.25397,0.49206,0.26984,0.49206,0.28571,0.49206,0.30159,0.49206,0.31746,0.49206,0.33333,0.49206,0.34921,0.49206,0.36508,0.49206,0.38095,0.49206,0.39683,0.49206,0.4127,0.49206,0.42857,0.49206,0.44444,0.49206,0.46032,0.49206,0.47619,0.49206,0.49206,0.49206,0.50794,0.49206,0.52381,0.49206,0.53968,0.49206,0.55556,0.49206,0.57143,0.49206,0.5873,0.49206,0.60317,0.49206,0.61905,0.49206,0.63492,0.49206,0.65079,0.49206,0.66667,0.49206,0.68254,0.49206,0.69841,0.49206,0.71429,0.49206,0.73016,0.49206,0.74603,0.49206,0.7619,0.49206,0.77778,0.49206,0.79365,0.49206,0.80952,0.49206,0.8254,0.49206,0.84127,0.49206,0.85714,0.49206,0.87302,0.49206,0.88889,0.49206,0.90476,0.49206,0.92063,0.49206,0.93651,0.49206,0.95238,0.49206,0.96825,0.49206,0.98413,0.49206,0.99609,0.49206,0.00391,0.50794,0.01587,0.50794,0.03175,0.50794,0.04762,0.50794,0.06349,0.50794,0.07937,0.50794,0.09524,0.50794,0.11111,0.50794,0.12698,0.50794,0.14286,0.50794,0.15873,0.50794,0.1746,0.50794,0.19048,0.50794,0.20635,0.50794,0.22222,0.50794,0.2381,0.50794,0.25397,0.50794,0.26984,0.50794,0.28571,0.50794,0.30159,0.50794,0.31746,0.50794,0.33333,0.50794,0.34921,0.50794,0.36508,0.50794,0.38095,0.50794,0.39683,0.50794,0.4127,0.50794,0.42857,0.50794,0.44444,0.50794,0.46032,0.50794,0.47619,0.50794,0.49206,0.50794,0.50794,0.50794,0.52381,0.50794,0.53968,0.50794,0.55556,0.50794,0.57143,0.50794,0.5873,0.50794,0.60317,0.50794,0.61905,0.50794,0.63492,0.50794,0.65079,0.50794,0.66667,0.50794,0.68254,0.50794,0.69841,0.50794,0.71429,0.50794,0.73016,0.50794,0.74603,0.50794,0.7619,0.50794,0.77778,0.50794,0.79365,0.50794,0.80952,0.50794};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.8254,0.50794,0.84127,0.50794,0.85714,0.50794,0.87302,0.50794,0.88889,0.50794,0.90476,0.50794,0.92063,0.50794,0.93651,0.50794,0.95238,0.50794,0.96825,0.50794,0.98413,0.50794,0.99609,0.50794,0.00391,0.52381,0.01587,0.52381,0.03175,0.52381,0.04762,0.52381,0.06349,0.52381,0.07937,0.52381,0.09524,0.52381,0.11111,0.52381,0.12698,0.52381,0.14286,0.52381,0.15873,0.52381,0.1746,0.52381,0.19048,0.52381,0.20635,0.52381,0.22222,0.52381,0.2381,0.52381,0.25397,0.52381,0.26984,0.52381,0.28571,0.52381,0.30159,0.52381,0.31746,0.52381,0.33333,0.52381,0.34921,0.52381,0.36508,0.52381,0.38095,0.52381,0.39683,0.52381,0.4127,0.52381,0.42857,0.52381,0.44444,0.52381,0.46032,0.52381,0.47619,0.52381,0.49206,0.52381,0.50794,0.52381,0.52381,0.52381,0.53968,0.52381,0.55556,0.52381,0.57143,0.52381,0.5873,0.52381,0.60317,0.52381,0.61905,0.52381,0.63492,0.52381,0.65079,0.52381,0.66667,0.52381,0.68254,0.52381,0.69841,0.52381,0.71429,0.52381,0.73016,0.52381,0.74603,0.52381,0.7619,0.52381,0.77778,0.52381,0.79365,0.52381,0.80952,0.52381,0.8254,0.52381,0.84127,0.52381,0.85714,0.52381,0.87302,0.52381,0.88889,0.52381,0.90476,0.52381,0.92063,0.52381,0.93651,0.52381,0.95238,0.52381,0.96825,0.52381,0.98413,0.52381,0.99609,0.52381,0.00391,0.53968,0.01587,0.53968,0.03175,0.53968,0.04762,0.53968,0.06349,0.53968,0.07937,0.53968,0.09524,0.53968,0.11111,0.53968,0.12698,0.53968,0.14286,0.53968,0.15873,0.53968,0.1746,0.53968,0.19048,0.53968,0.20635,0.53968,0.22222,0.53968,0.2381,0.53968,0.25397,0.53968,0.26984,0.53968,0.28571,0.53968,0.30159,0.53968,0.31746,0.53968,0.33333,0.53968,0.34921,0.53968,0.36508,0.53968};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.38095,0.53968,0.39683,0.53968,0.4127,0.53968,0.42857,0.53968,0.44444,0.53968,0.46032,0.53968,0.47619,0.53968,0.49206,0.53968,0.50794,0.53968,0.52381,0.53968,0.53968,0.53968,0.55556,0.53968,0.57143,0.53968,0.5873,0.53968,0.60317,0.53968,0.61905,0.53968,0.63492,0.53968,0.65079,0.53968,0.66667,0.53968,0.68254,0.53968,0.69841,0.53968,0.71429,0.53968,0.73016,0.53968,0.74603,0.53968,0.7619,0.53968,0.77778,0.53968,0.79365,0.53968,0.80952,0.53968,0.8254,0.53968,0.84127,0.53968,0.85714,0.53968,0.87302,0.53968,0.88889,0.53968,0.90476,0.53968,0.92063,0.53968,0.93651,0.53968,0.95238,0.53968,0.96825,0.53968,0.98413,0.53968,0.99609,0.53968,0.00391,0.55556,0.01587,0.55556,0.03175,0.55556,0.04762,0.55556,0.06349,0.55556,0.07937,0.55556,0.09524,0.55556,0.11111,0.55556,0.12698,0.55556,0.14286,0.55556,0.15873,0.55556,0.1746,0.55556,0.19048,0.55556,0.20635,0.55556,0.22222,0.55556,0.2381,0.55556,0.25397,0.55556,0.26984,0.55556,0.28571,0.55556,0.30159,0.55556,0.31746,0.55556,0.33333,0.55556,0.34921,0.55556,0.36508,0.55556,0.38095,0.55556,0.39683,0.55556,0.4127,0.55556,0.42857,0.55556,0.44444,0.55556,0.46032,0.55556,0.47619,0.55556,0.49206,0.55556,0.50794,0.55556,0.52381,0.55556,0.53968,0.55556,0.55556,0.55556,0.57143,0.55556,0.5873,0.55556,0.60317,0.55556,0.61905,0.55556,0.63492,0.55556,0.65079,0.55556,0.66667,0.55556,0.68254,0.55556,0.69841,0.55556,0.71429,0.55556,0.73016,0.55556,0.74603,0.55556,0.7619,0.55556,0.77778,0.55556,0.79365,0.55556,0.80952,0.55556,0.8254,0.55556,0.84127,0.55556,0.85714,0.55556,0.87302,0.55556,0.88889,0.55556,0.90476,0.55556,0.92063,0.55556,0.93651,0.55556};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.95238,0.55556,0.96825,0.55556,0.98413,0.55556,0.99609,0.55556,0.00391,0.57143,0.01587,0.57143,0.03175,0.57143,0.04762,0.57143,0.06349,0.57143,0.07937,0.57143,0.09524,0.57143,0.11111,0.57143,0.12698,0.57143,0.14286,0.57143,0.15873,0.57143,0.1746,0.57143,0.19048,0.57143,0.20635,0.57143,0.22222,0.57143,0.2381,0.57143,0.25397,0.57143,0.26984,0.57143,0.28571,0.57143,0.30159,0.57143,0.31746,0.57143,0.33333,0.57143,0.34921,0.57143,0.36508,0.57143,0.38095,0.57143,0.39683,0.57143,0.4127,0.57143,0.42857,0.57143,0.44444,0.57143,0.46032,0.57143,0.47619,0.57143,0.49206,0.57143,0.50794,0.57143,0.52381,0.57143,0.53968,0.57143,0.55556,0.57143,0.57143,0.57143,0.5873,0.57143,0.60317,0.57143,0.61905,0.57143,0.63492,0.57143,0.65079,0.57143,0.66667,0.57143,0.68254,0.57143,0.69841,0.57143,0.71429,0.57143,0.73016,0.57143,0.74603,0.57143,0.7619,0.57143,0.77778,0.57143,0.79365,0.57143,0.80952,0.57143,0.8254,0.57143,0.84127,0.57143,0.85714,0.57143,0.87302,0.57143,0.88889,0.57143,0.90476,0.57143,0.92063,0.57143,0.93651,0.57143,0.95238,0.57143,0.96825,0.57143,0.98413,0.57143,0.99609,0.57143,0.00391,0.5873,0.01587,0.5873,0.03175,0.5873,0.04762,0.5873,0.06349,0.5873,0.07937,0.5873,0.09524,0.5873,0.11111,0.5873,0.12698,0.5873,0.14286,0.5873,0.15873,0.5873,0.1746,0.5873,0.19048,0.5873,0.20635,0.5873,0.22222,0.5873,0.2381,0.5873,0.25397,0.5873,0.26984,0.5873,0.28571,0.5873,0.30159,0.5873,0.31746,0.5873,0.33333,0.5873,0.34921,0.5873,0.36508,0.5873,0.38095,0.5873,0.39683,0.5873,0.4127,0.5873,0.42857,0.5873,0.44444,0.5873,0.46032,0.5873,0.47619,0.5873,0.49206,0.5873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.50794,0.5873,0.52381,0.5873,0.53968,0.5873,0.55556,0.5873,0.57143,0.5873,0.5873,0.5873,0.60317,0.5873,0.61905,0.5873,0.63492,0.5873,0.65079,0.5873,0.66667,0.5873,0.68254,0.5873,0.69841,0.5873,0.71429,0.5873,0.73016,0.5873,0.74603,0.5873,0.7619,0.5873,0.77778,0.5873,0.79365,0.5873,0.80952,0.5873,0.8254,0.5873,0.84127,0.5873,0.85714,0.5873,0.87302,0.5873,0.88889,0.5873,0.90476,0.5873,0.92063,0.5873,0.93651,0.5873,0.95238,0.5873,0.96825,0.5873,0.98413,0.5873,0.99609,0.5873,0.00391,0.60317,0.01587,0.60317,0.03175,0.60317,0.04762,0.60317,0.06349,0.60317,0.07937,0.60317,0.09524,0.60317,0.11111,0.60317,0.12698,0.60317,0.14286,0.60317,0.15873,0.60317,0.1746,0.60317,0.19048,0.60317,0.20635,0.60317,0.22222,0.60317,0.2381,0.60317,0.25397,0.60317,0.26984,0.60317,0.28571,0.60317,0.30159,0.60317,0.31746,0.60317,0.33333,0.60317,0.34921,0.60317,0.36508,0.60317,0.38095,0.60317,0.39683,0.60317,0.4127,0.60317,0.42857,0.60317,0.44444,0.60317,0.46032,0.60317,0.47619,0.60317,0.49206,0.60317,0.50794,0.60317,0.52381,0.60317,0.53968,0.60317,0.55556,0.60317,0.57143,0.60317,0.5873,0.60317,0.60317,0.60317,0.61905,0.60317,0.63492,0.60317,0.65079,0.60317,0.66667,0.60317,0.68254,0.60317,0.69841,0.60317,0.71429,0.60317,0.73016,0.60317,0.74603,0.60317,0.7619,0.60317,0.77778,0.60317,0.79365,0.60317,0.80952,0.60317,0.8254,0.60317,0.84127,0.60317,0.85714,0.60317,0.87302,0.60317,0.88889,0.60317,0.90476,0.60317,0.92063,0.60317,0.93651,0.60317,0.95238,0.60317,0.96825,0.60317,0.98413,0.60317,0.99609,0.60317,0.00391,0.61905,0.01587,0.61905,0.03175,0.61905,0.04762,0.61905};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.06349,0.61905,0.07937,0.61905,0.09524,0.61905,0.11111,0.61905,0.12698,0.61905,0.14286,0.61905,0.15873,0.61905,0.1746,0.61905,0.19048,0.61905,0.20635,0.61905,0.22222,0.61905,0.2381,0.61905,0.25397,0.61905,0.26984,0.61905,0.28571,0.61905,0.30159,0.61905,0.31746,0.61905,0.33333,0.61905,0.34921,0.61905,0.36508,0.61905,0.38095,0.61905,0.39683,0.61905,0.4127,0.61905,0.42857,0.61905,0.44444,0.61905,0.46032,0.61905,0.47619,0.61905,0.49206,0.61905,0.50794,0.61905,0.52381,0.61905,0.53968,0.61905,0.55556,0.61905,0.57143,0.61905,0.5873,0.61905,0.60317,0.61905,0.61905,0.61905,0.63492,0.61905,0.65079,0.61905,0.66667,0.61905,0.68254,0.61905,0.69841,0.61905,0.71429,0.61905,0.73016,0.61905,0.74603,0.61905,0.7619,0.61905,0.77778,0.61905,0.79365,0.61905,0.80952,0.61905,0.8254,0.61905,0.84127,0.61905,0.85714,0.61905,0.87302,0.61905,0.88889,0.61905,0.90476,0.61905,0.92063,0.61905,0.93651,0.61905,0.95238,0.61905,0.96825,0.61905,0.98413,0.61905,0.99609,0.61905,0.00391,0.63492,0.01587,0.63492,0.03175,0.63492,0.04762,0.63492,0.06349,0.63492,0.07937,0.63492,0.09524,0.63492,0.11111,0.63492,0.12698,0.63492,0.14286,0.63492,0.15873,0.63492,0.1746,0.63492,0.19048,0.63492,0.20635,0.63492,0.22222,0.63492,0.2381,0.63492,0.25397,0.63492,0.26984,0.63492,0.28571,0.63492,0.30159,0.63492,0.31746,0.63492,0.33333,0.63492,0.34921,0.63492,0.36508,0.63492,0.38095,0.63492,0.39683,0.63492,0.4127,0.63492,0.42857,0.63492,0.44444,0.63492,0.46032,0.63492,0.47619,0.63492,0.49206,0.63492,0.50794,0.63492,0.52381,0.63492,0.53968,0.63492,0.55556,0.63492,0.57143,0.63492,0.5873,0.63492,0.60317,0.63492,0.61905,0.63492};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.63492,0.63492,0.65079,0.63492,0.66667,0.63492,0.68254,0.63492,0.69841,0.63492,0.71429,0.63492,0.73016,0.63492,0.74603,0.63492,0.7619,0.63492,0.77778,0.63492,0.79365,0.63492,0.80952,0.63492,0.8254,0.63492,0.84127,0.63492,0.85714,0.63492,0.87302,0.63492,0.88889,0.63492,0.90476,0.63492,0.92063,0.63492,0.93651,0.63492,0.95238,0.63492,0.96825,0.63492,0.98413,0.63492,0.99609,0.63492,0.00391,0.65079,0.01587,0.65079,0.03175,0.65079,0.04762,0.65079,0.06349,0.65079,0.07937,0.65079,0.09524,0.65079,0.11111,0.65079,0.12698,0.65079,0.14286,0.65079,0.15873,0.65079,0.1746,0.65079,0.19048,0.65079,0.20635,0.65079,0.22222,0.65079,0.2381,0.65079,0.25397,0.65079,0.26984,0.65079,0.28571,0.65079,0.30159,0.65079,0.31746,0.65079,0.33333,0.65079,0.34921,0.65079,0.36508,0.65079,0.38095,0.65079,0.39683,0.65079,0.4127,0.65079,0.42857,0.65079,0.44444,0.65079,0.46032,0.65079,0.47619,0.65079,0.49206,0.65079,0.50794,0.65079,0.52381,0.65079,0.53968,0.65079,0.55556,0.65079,0.57143,0.65079,0.5873,0.65079,0.60317,0.65079,0.61905,0.65079,0.63492,0.65079,0.65079,0.65079,0.66667,0.65079,0.68254,0.65079,0.69841,0.65079,0.71429,0.65079,0.73016,0.65079,0.74603,0.65079,0.7619,0.65079,0.77778,0.65079,0.79365,0.65079,0.80952,0.65079,0.8254,0.65079,0.84127,0.65079,0.85714,0.65079,0.87302,0.65079,0.88889,0.65079,0.90476,0.65079,0.92063,0.65079,0.93651,0.65079,0.95238,0.65079,0.96825,0.65079,0.98413,0.65079,0.99609,0.65079,0.00391,0.66667,0.01587,0.66667,0.03175,0.66667,0.04762,0.66667,0.06349,0.66667,0.07937,0.66667,0.09524,0.66667,0.11111,0.66667,0.12698,0.66667,0.14286,0.66667,0.15873,0.66667,0.1746,0.66667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.19048,0.66667,0.20635,0.66667,0.22222,0.66667,0.2381,0.66667,0.25397,0.66667,0.26984,0.66667,0.28571,0.66667,0.30159,0.66667,0.31746,0.66667,0.33333,0.66667,0.34921,0.66667,0.36508,0.66667,0.38095,0.66667,0.39683,0.66667,0.4127,0.66667,0.42857,0.66667,0.44444,0.66667,0.46032,0.66667,0.47619,0.66667,0.49206,0.66667,0.50794,0.66667,0.52381,0.66667,0.53968,0.66667,0.55556,0.66667,0.57143,0.66667,0.5873,0.66667,0.60317,0.66667,0.61905,0.66667,0.63492,0.66667,0.65079,0.66667,0.66667,0.66667,0.68254,0.66667,0.69841,0.66667,0.71429,0.66667,0.73016,0.66667,0.74603,0.66667,0.7619,0.66667,0.77778,0.66667,0.79365,0.66667,0.80952,0.66667,0.8254,0.66667,0.84127,0.66667,0.85714,0.66667,0.87302,0.66667,0.88889,0.66667,0.90476,0.66667,0.92063,0.66667,0.93651,0.66667,0.95238,0.66667,0.96825,0.66667,0.98413,0.66667,0.99609,0.66667,0.00391,0.68254,0.01587,0.68254,0.03175,0.68254,0.04762,0.68254,0.06349,0.68254,0.07937,0.68254,0.09524,0.68254,0.11111,0.68254,0.12698,0.68254,0.14286,0.68254,0.15873,0.68254,0.1746,0.68254,0.19048,0.68254,0.20635,0.68254,0.22222,0.68254,0.2381,0.68254,0.25397,0.68254,0.26984,0.68254,0.28571,0.68254,0.30159,0.68254,0.31746,0.68254,0.33333,0.68254,0.34921,0.68254,0.36508,0.68254,0.38095,0.68254,0.39683,0.68254,0.4127,0.68254,0.42857,0.68254,0.44444,0.68254,0.46032,0.68254,0.47619,0.68254,0.49206,0.68254,0.50794,0.68254,0.52381,0.68254,0.53968,0.68254,0.55556,0.68254,0.57143,0.68254,0.5873,0.68254,0.60317,0.68254,0.61905,0.68254,0.63492,0.68254,0.65079,0.68254,0.66667,0.68254,0.68254,0.68254,0.69841,0.68254,0.71429,0.68254,0.73016,0.68254,0.74603,0.68254};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.7619,0.68254,0.77778,0.68254,0.79365,0.68254,0.80952,0.68254,0.8254,0.68254,0.84127,0.68254,0.85714,0.68254,0.87302,0.68254,0.88889,0.68254,0.90476,0.68254,0.92063,0.68254,0.93651,0.68254,0.95238,0.68254,0.96825,0.68254,0.98413,0.68254,0.99609,0.68254,0.00391,0.69841,0.01587,0.69841,0.03175,0.69841,0.04762,0.69841,0.06349,0.69841,0.07937,0.69841,0.09524,0.69841,0.11111,0.69841,0.12698,0.69841,0.14286,0.69841,0.15873,0.69841,0.1746,0.69841,0.19048,0.69841,0.20635,0.69841,0.22222,0.69841,0.2381,0.69841,0.25397,0.69841,0.26984,0.69841,0.28571,0.69841,0.30159,0.69841,0.31746,0.69841,0.33333,0.69841,0.34921,0.69841,0.36508,0.69841,0.38095,0.69841,0.39683,0.69841,0.4127,0.69841,0.42857,0.69841,0.44444,0.69841,0.46032,0.69841,0.47619,0.69841,0.49206,0.69841,0.50794,0.69841,0.52381,0.69841,0.53968,0.69841,0.55556,0.69841,0.57143,0.69841,0.5873,0.69841,0.60317,0.69841,0.61905,0.69841,0.63492,0.69841,0.65079,0.69841,0.66667,0.69841,0.68254,0.69841,0.69841,0.69841,0.71429,0.69841,0.73016,0.69841,0.74603,0.69841,0.7619,0.69841,0.77778,0.69841,0.79365,0.69841,0.80952,0.69841,0.8254,0.69841,0.84127,0.69841,0.85714,0.69841,0.87302,0.69841,0.88889,0.69841,0.90476,0.69841,0.92063,0.69841,0.93651,0.69841,0.95238,0.69841,0.96825,0.69841,0.98413,0.69841,0.99609,0.69841,0.00391,0.71429,0.01587,0.71429,0.03175,0.71429,0.04762,0.71429,0.06349,0.71429,0.07937,0.71429,0.09524,0.71429,0.11111,0.71429,0.12698,0.71429,0.14286,0.71429,0.15873,0.71429,0.1746,0.71429,0.19048,0.71429,0.20635,0.71429,0.22222,0.71429,0.2381,0.71429,0.25397,0.71429,0.26984,0.71429,0.28571,0.71429,0.30159,0.71429};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.31746,0.71429,0.33333,0.71429,0.34921,0.71429,0.36508,0.71429,0.38095,0.71429,0.39683,0.71429,0.4127,0.71429,0.42857,0.71429,0.44444,0.71429,0.46032,0.71429,0.47619,0.71429,0.49206,0.71429,0.50794,0.71429,0.52381,0.71429,0.53968,0.71429,0.55556,0.71429,0.57143,0.71429,0.5873,0.71429,0.60317,0.71429,0.61905,0.71429,0.63492,0.71429,0.65079,0.71429,0.66667,0.71429,0.68254,0.71429,0.69841,0.71429,0.71429,0.71429,0.73016,0.71429,0.74603,0.71429,0.7619,0.71429,0.77778,0.71429,0.79365,0.71429,0.80952,0.71429,0.8254,0.71429,0.84127,0.71429,0.85714,0.71429,0.87302,0.71429,0.88889,0.71429,0.90476,0.71429,0.92063,0.71429,0.93651,0.71429,0.95238,0.71429,0.96825,0.71429,0.98413,0.71429,0.99609,0.71429,0.00391,0.73016,0.01587,0.73016,0.03175,0.73016,0.04762,0.73016,0.06349,0.73016,0.07937,0.73016,0.09524,0.73016,0.11111,0.73016,0.12698,0.73016,0.14286,0.73016,0.15873,0.73016,0.1746,0.73016,0.19048,0.73016,0.20635,0.73016,0.22222,0.73016,0.2381,0.73016,0.25397,0.73016,0.26984,0.73016,0.28571,0.73016,0.30159,0.73016,0.31746,0.73016,0.33333,0.73016,0.34921,0.73016,0.36508,0.73016,0.38095,0.73016,0.39683,0.73016,0.4127,0.73016,0.42857,0.73016,0.44444,0.73016,0.46032,0.73016,0.47619,0.73016,0.49206,0.73016,0.50794,0.73016,0.52381,0.73016,0.53968,0.73016,0.55556,0.73016,0.57143,0.73016,0.5873,0.73016,0.60317,0.73016,0.61905,0.73016,0.63492,0.73016,0.65079,0.73016,0.66667,0.73016,0.68254,0.73016,0.69841,0.73016,0.71429,0.73016,0.73016,0.73016,0.74603,0.73016,0.7619,0.73016,0.77778,0.73016,0.79365,0.73016,0.80952,0.73016,0.8254,0.73016,0.84127,0.73016,0.85714,0.73016,0.87302,0.73016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.88889,0.73016,0.90476,0.73016,0.92063,0.73016,0.93651,0.73016,0.95238,0.73016,0.96825,0.73016,0.98413,0.73016,0.99609,0.73016,0.00391,0.74603,0.01587,0.74603,0.03175,0.74603,0.04762,0.74603,0.06349,0.74603,0.07937,0.74603,0.09524,0.74603,0.11111,0.74603,0.12698,0.74603,0.14286,0.74603,0.15873,0.74603,0.1746,0.74603,0.19048,0.74603,0.20635,0.74603,0.22222,0.74603,0.2381,0.74603,0.25397,0.74603,0.26984,0.74603,0.28571,0.74603,0.30159,0.74603,0.31746,0.74603,0.33333,0.74603,0.34921,0.74603,0.36508,0.74603,0.38095,0.74603,0.39683,0.74603,0.4127,0.74603,0.42857,0.74603,0.44444,0.74603,0.46032,0.74603,0.47619,0.74603,0.49206,0.74603,0.50794,0.74603,0.52381,0.74603,0.53968,0.74603,0.55556,0.74603,0.57143,0.74603,0.5873,0.74603,0.60317,0.74603,0.61905,0.74603,0.63492,0.74603,0.65079,0.74603,0.66667,0.74603,0.68254,0.74603,0.69841,0.74603,0.71429,0.74603,0.73016,0.74603,0.74603,0.74603,0.7619,0.74603,0.77778,0.74603,0.79365,0.74603,0.80952,0.74603,0.8254,0.74603,0.84127,0.74603,0.85714,0.74603,0.87302,0.74603,0.88889,0.74603,0.90476,0.74603,0.92063,0.74603,0.93651,0.74603,0.95238,0.74603,0.96825,0.74603,0.98413,0.74603,0.99609,0.74603,0.00391,0.7619,0.01587,0.7619,0.03175,0.7619,0.04762,0.7619,0.06349,0.7619,0.07937,0.7619,0.09524,0.7619,0.11111,0.7619,0.12698,0.7619,0.14286,0.7619,0.15873,0.7619,0.1746,0.7619,0.19048,0.7619,0.20635,0.7619,0.22222,0.7619,0.2381,0.7619,0.25397,0.7619,0.26984,0.7619,0.28571,0.7619,0.30159,0.7619,0.31746,0.7619,0.33333,0.7619,0.34921,0.7619,0.36508,0.7619,0.38095,0.7619,0.39683,0.7619,0.4127,0.7619,0.42857,0.7619};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.44444,0.7619,0.46032,0.7619,0.47619,0.7619,0.49206,0.7619,0.50794,0.7619,0.52381,0.7619,0.53968,0.7619,0.55556,0.7619,0.57143,0.7619,0.5873,0.7619,0.60317,0.7619,0.61905,0.7619,0.63492,0.7619,0.65079,0.7619,0.66667,0.7619,0.68254,0.7619,0.69841,0.7619,0.71429,0.7619,0.73016,0.7619,0.74603,0.7619,0.7619,0.7619,0.77778,0.7619,0.79365,0.7619,0.80952,0.7619,0.8254,0.7619,0.84127,0.7619,0.85714,0.7619,0.87302,0.7619,0.88889,0.7619,0.90476,0.7619,0.92063,0.7619,0.93651,0.7619,0.95238,0.7619,0.96825,0.7619,0.98413,0.7619,0.99609,0.7619,0.00391,0.77778,0.01587,0.77778,0.03175,0.77778,0.04762,0.77778,0.06349,0.77778,0.07937,0.77778,0.09524,0.77778,0.11111,0.77778,0.12698,0.77778,0.14286,0.77778,0.15873,0.77778,0.1746,0.77778,0.19048,0.77778,0.20635,0.77778,0.22222,0.77778,0.2381,0.77778,0.25397,0.77778,0.26984,0.77778,0.28571,0.77778,0.30159,0.77778,0.31746,0.77778,0.33333,0.77778,0.34921,0.77778,0.36508,0.77778,0.38095,0.77778,0.39683,0.77778,0.4127,0.77778,0.42857,0.77778,0.44444,0.77778,0.46032,0.77778,0.47619,0.77778,0.49206,0.77778,0.50794,0.77778,0.52381,0.77778,0.53968,0.77778,0.55556,0.77778,0.57143,0.77778,0.5873,0.77778,0.60317,0.77778,0.61905,0.77778,0.63492,0.77778,0.65079,0.77778,0.66667,0.77778,0.68254,0.77778,0.69841,0.77778,0.71429,0.77778,0.73016,0.77778,0.74603,0.77778,0.7619,0.77778,0.77778,0.77778,0.79365,0.77778,0.80952,0.77778,0.8254,0.77778,0.84127,0.77778,0.85714,0.77778,0.87302,0.77778,0.88889,0.77778,0.90476,0.77778,0.92063,0.77778,0.93651,0.77778,0.95238,0.77778,0.96825,0.77778,0.98413,0.77778,0.99609,0.77778};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.79365,0.01587,0.79365,0.03175,0.79365,0.04762,0.79365,0.06349,0.79365,0.07937,0.79365,0.09524,0.79365,0.11111,0.79365,0.12698,0.79365,0.14286,0.79365,0.15873,0.79365,0.1746,0.79365,0.19048,0.79365,0.20635,0.79365,0.22222,0.79365,0.2381,0.79365,0.25397,0.79365,0.26984,0.79365,0.28571,0.79365,0.30159,0.79365,0.31746,0.79365,0.33333,0.79365,0.34921,0.79365,0.36508,0.79365,0.38095,0.79365,0.39683,0.79365,0.4127,0.79365,0.42857,0.79365,0.44444,0.79365,0.46032,0.79365,0.47619,0.79365,0.49206,0.79365,0.50794,0.79365,0.52381,0.79365,0.53968,0.79365,0.55556,0.79365,0.57143,0.79365,0.5873,0.79365,0.60317,0.79365,0.61905,0.79365,0.63492,0.79365,0.65079,0.79365,0.66667,0.79365,0.68254,0.79365,0.69841,0.79365,0.71429,0.79365,0.73016,0.79365,0.74603,0.79365,0.7619,0.79365,0.77778,0.79365,0.79365,0.79365,0.80952,0.79365,0.8254,0.79365,0.84127,0.79365,0.85714,0.79365,0.87302,0.79365,0.88889,0.79365,0.90476,0.79365,0.92063,0.79365,0.93651,0.79365,0.95238,0.79365,0.96825,0.79365,0.98413,0.79365,0.99609,0.79365,0.00391,0.80952,0.01587,0.80952,0.03175,0.80952,0.04762,0.80952,0.06349,0.80952,0.07937,0.80952,0.09524,0.80952,0.11111,0.80952,0.12698,0.80952,0.14286,0.80952,0.15873,0.80952,0.1746,0.80952,0.19048,0.80952,0.20635,0.80952,0.22222,0.80952,0.2381,0.80952,0.25397,0.80952,0.26984,0.80952,0.28571,0.80952,0.30159,0.80952,0.31746,0.80952,0.33333,0.80952,0.34921,0.80952,0.36508,0.80952,0.38095,0.80952,0.39683,0.80952,0.4127,0.80952,0.42857,0.80952,0.44444,0.80952,0.46032,0.80952,0.47619,0.80952,0.49206,0.80952,0.50794,0.80952,0.52381,0.80952,0.53968,0.80952,0.55556,0.80952};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.57143,0.80952,0.5873,0.80952,0.60317,0.80952,0.61905,0.80952,0.63492,0.80952,0.65079,0.80952,0.66667,0.80952,0.68254,0.80952,0.69841,0.80952,0.71429,0.80952,0.73016,0.80952,0.74603,0.80952,0.7619,0.80952,0.77778,0.80952,0.79365,0.80952,0.80952,0.80952,0.8254,0.80952,0.84127,0.80952,0.85714,0.80952,0.87302,0.80952,0.88889,0.80952,0.90476,0.80952,0.92063,0.80952,0.93651,0.80952,0.95238,0.80952,0.96825,0.80952,0.98413,0.80952,0.99609,0.80952,0.00391,0.8254,0.01587,0.8254,0.03175,0.8254,0.04762,0.8254,0.06349,0.8254,0.07937,0.8254,0.09524,0.8254,0.11111,0.8254,0.12698,0.8254,0.14286,0.8254,0.15873,0.8254,0.1746,0.8254,0.19048,0.8254,0.20635,0.8254,0.22222,0.8254,0.2381,0.8254,0.25397,0.8254,0.26984,0.8254,0.28571,0.8254,0.30159,0.8254,0.31746,0.8254,0.33333,0.8254,0.34921,0.8254,0.36508,0.8254,0.38095,0.8254,0.39683,0.8254,0.4127,0.8254,0.42857,0.8254,0.44444,0.8254,0.46032,0.8254,0.47619,0.8254,0.49206,0.8254,0.50794,0.8254,0.52381,0.8254,0.53968,0.8254,0.55556,0.8254,0.57143,0.8254,0.5873,0.8254,0.60317,0.8254,0.61905,0.8254,0.63492,0.8254,0.65079,0.8254,0.66667,0.8254,0.68254,0.8254,0.69841,0.8254,0.71429,0.8254,0.73016,0.8254,0.74603,0.8254,0.7619,0.8254,0.77778,0.8254,0.79365,0.8254,0.80952,0.8254,0.8254,0.8254,0.84127,0.8254,0.85714,0.8254,0.87302,0.8254,0.88889,0.8254,0.90476,0.8254,0.92063,0.8254,0.93651,0.8254,0.95238,0.8254,0.96825,0.8254,0.98413,0.8254,0.99609,0.8254,0.00391,0.84127,0.01587,0.84127,0.03175,0.84127,0.04762,0.84127,0.06349,0.84127,0.07937,0.84127,0.09524,0.84127,0.11111,0.84127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.12698,0.84127,0.14286,0.84127,0.15873,0.84127,0.1746,0.84127,0.19048,0.84127,0.20635,0.84127,0.22222,0.84127,0.2381,0.84127,0.25397,0.84127,0.26984,0.84127,0.28571,0.84127,0.30159,0.84127,0.31746,0.84127,0.33333,0.84127,0.34921,0.84127,0.36508,0.84127,0.38095,0.84127,0.39683,0.84127,0.4127,0.84127,0.42857,0.84127,0.44444,0.84127,0.46032,0.84127,0.47619,0.84127,0.49206,0.84127,0.50794,0.84127,0.52381,0.84127,0.53968,0.84127,0.55556,0.84127,0.57143,0.84127,0.5873,0.84127,0.60317,0.84127,0.61905,0.84127,0.63492,0.84127,0.65079,0.84127,0.66667,0.84127,0.68254,0.84127,0.69841,0.84127,0.71429,0.84127,0.73016,0.84127,0.74603,0.84127,0.7619,0.84127,0.77778,0.84127,0.79365,0.84127,0.80952,0.84127,0.8254,0.84127,0.84127,0.84127,0.85714,0.84127,0.87302,0.84127,0.88889,0.84127,0.90476,0.84127,0.92063,0.84127,0.93651,0.84127,0.95238,0.84127,0.96825,0.84127,0.98413,0.84127,0.99609,0.84127,0.00391,0.85714,0.01587,0.85714,0.03175,0.85714,0.04762,0.85714,0.06349,0.85714,0.07937,0.85714,0.09524,0.85714,0.11111,0.85714,0.12698,0.85714,0.14286,0.85714,0.15873,0.85714,0.1746,0.85714,0.19048,0.85714,0.20635,0.85714,0.22222,0.85714,0.2381,0.85714,0.25397,0.85714,0.26984,0.85714,0.28571,0.85714,0.30159,0.85714,0.31746,0.85714,0.33333,0.85714,0.34921,0.85714,0.36508,0.85714,0.38095,0.85714,0.39683,0.85714,0.4127,0.85714,0.42857,0.85714,0.44444,0.85714,0.46032,0.85714,0.47619,0.85714,0.49206,0.85714,0.50794,0.85714,0.52381,0.85714,0.53968,0.85714,0.55556,0.85714,0.57143,0.85714,0.5873,0.85714,0.60317,0.85714,0.61905,0.85714,0.63492,0.85714,0.65079,0.85714,0.66667,0.85714,0.68254,0.85714};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.69841,0.85714,0.71429,0.85714,0.73016,0.85714,0.74603,0.85714,0.7619,0.85714,0.77778,0.85714,0.79365,0.85714,0.80952,0.85714,0.8254,0.85714,0.84127,0.85714,0.85714,0.85714,0.87302,0.85714,0.88889,0.85714,0.90476,0.85714,0.92063,0.85714,0.93651,0.85714,0.95238,0.85714,0.96825,0.85714,0.98413,0.85714,0.99609,0.85714,0.00391,0.87302,0.01587,0.87302,0.03175,0.87302,0.04762,0.87302,0.06349,0.87302,0.07937,0.87302,0.09524,0.87302,0.11111,0.87302,0.12698,0.87302,0.14286,0.87302,0.15873,0.87302,0.1746,0.87302,0.19048,0.87302,0.20635,0.87302,0.22222,0.87302,0.2381,0.87302,0.25397,0.87302,0.26984,0.87302,0.28571,0.87302,0.30159,0.87302,0.31746,0.87302,0.33333,0.87302,0.34921,0.87302,0.36508,0.87302,0.38095,0.87302,0.39683,0.87302,0.4127,0.87302,0.42857,0.87302,0.44444,0.87302,0.46032,0.87302,0.47619,0.87302,0.49206,0.87302,0.50794,0.87302,0.52381,0.87302,0.53968,0.87302,0.55556,0.87302,0.57143,0.87302,0.5873,0.87302,0.60317,0.87302,0.61905,0.87302,0.63492,0.87302,0.65079,0.87302,0.66667,0.87302,0.68254,0.87302,0.69841,0.87302,0.71429,0.87302,0.73016,0.87302,0.74603,0.87302,0.7619,0.87302,0.77778,0.87302,0.79365,0.87302,0.80952,0.87302,0.8254,0.87302,0.84127,0.87302,0.85714,0.87302,0.87302,0.87302,0.88889,0.87302,0.90476,0.87302,0.92063,0.87302,0.93651,0.87302,0.95238,0.87302,0.96825,0.87302,0.98413,0.87302,0.99609,0.87302,0.00391,0.88889,0.01587,0.88889,0.03175,0.88889,0.04762,0.88889,0.06349,0.88889,0.07937,0.88889,0.09524,0.88889,0.11111,0.88889,0.12698,0.88889,0.14286,0.88889,0.15873,0.88889,0.1746,0.88889,0.19048,0.88889,0.20635,0.88889,0.22222,0.88889,0.2381,0.88889};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.25397,0.88889,0.26984,0.88889,0.28571,0.88889,0.30159,0.88889,0.31746,0.88889,0.33333,0.88889,0.34921,0.88889,0.36508,0.88889,0.38095,0.88889,0.39683,0.88889,0.4127,0.88889,0.42857,0.88889,0.44444,0.88889,0.46032,0.88889,0.47619,0.88889,0.49206,0.88889,0.50794,0.88889,0.52381,0.88889,0.53968,0.88889,0.55556,0.88889,0.57143,0.88889,0.5873,0.88889,0.60317,0.88889,0.61905,0.88889,0.63492,0.88889,0.65079,0.88889,0.66667,0.88889,0.68254,0.88889,0.69841,0.88889,0.71429,0.88889,0.73016,0.88889,0.74603,0.88889,0.7619,0.88889,0.77778,0.88889,0.79365,0.88889,0.80952,0.88889,0.8254,0.88889,0.84127,0.88889,0.85714,0.88889,0.87302,0.88889,0.88889,0.88889,0.90476,0.88889,0.92063,0.88889,0.93651,0.88889,0.95238,0.88889,0.96825,0.88889,0.98413,0.88889,0.99609,0.88889,0.00391,0.90476,0.01587,0.90476,0.03175,0.90476,0.04762,0.90476,0.06349,0.90476,0.07937,0.90476,0.09524,0.90476,0.11111,0.90476,0.12698,0.90476,0.14286,0.90476,0.15873,0.90476,0.1746,0.90476,0.19048,0.90476,0.20635,0.90476,0.22222,0.90476,0.2381,0.90476,0.25397,0.90476,0.26984,0.90476,0.28571,0.90476,0.30159,0.90476,0.31746,0.90476,0.33333,0.90476,0.34921,0.90476,0.36508,0.90476,0.38095,0.90476,0.39683,0.90476,0.4127,0.90476,0.42857,0.90476,0.44444,0.90476,0.46032,0.90476,0.47619,0.90476,0.49206,0.90476,0.50794,0.90476,0.52381,0.90476,0.53968,0.90476,0.55556,0.90476,0.57143,0.90476,0.5873,0.90476,0.60317,0.90476,0.61905,0.90476,0.63492,0.90476,0.65079,0.90476,0.66667,0.90476,0.68254,0.90476,0.69841,0.90476,0.71429,0.90476,0.73016,0.90476,0.74603,0.90476,0.7619,0.90476,0.77778,0.90476,0.79365,0.90476,0.80952,0.90476};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.8254,0.90476,0.84127,0.90476,0.85714,0.90476,0.87302,0.90476,0.88889,0.90476,0.90476,0.90476,0.92063,0.90476,0.93651,0.90476,0.95238,0.90476,0.96825,0.90476,0.98413,0.90476,0.99609,0.90476,0.00391,0.92063,0.01587,0.92063,0.03175,0.92063,0.04762,0.92063,0.06349,0.92063,0.07937,0.92063,0.09524,0.92063,0.11111,0.92063,0.12698,0.92063,0.14286,0.92063,0.15873,0.92063,0.1746,0.92063,0.19048,0.92063,0.20635,0.92063,0.22222,0.92063,0.2381,0.92063,0.25397,0.92063,0.26984,0.92063,0.28571,0.92063,0.30159,0.92063,0.31746,0.92063,0.33333,0.92063,0.34921,0.92063,0.36508,0.92063,0.38095,0.92063,0.39683,0.92063,0.4127,0.92063,0.42857,0.92063,0.44444,0.92063,0.46032,0.92063,0.47619,0.92063,0.49206,0.92063,0.50794,0.92063,0.52381,0.92063,0.53968,0.92063,0.55556,0.92063,0.57143,0.92063,0.5873,0.92063,0.60317,0.92063,0.61905,0.92063,0.63492,0.92063,0.65079,0.92063,0.66667,0.92063,0.68254,0.92063,0.69841,0.92063,0.71429,0.92063,0.73016,0.92063,0.74603,0.92063,0.7619,0.92063,0.77778,0.92063,0.79365,0.92063,0.80952,0.92063,0.8254,0.92063,0.84127,0.92063,0.85714,0.92063,0.87302,0.92063,0.88889,0.92063,0.90476,0.92063,0.92063,0.92063,0.93651,0.92063,0.95238,0.92063,0.96825,0.92063,0.98413,0.92063,0.99609,0.92063,0.00391,0.93651,0.01587,0.93651,0.03175,0.93651,0.04762,0.93651,0.06349,0.93651,0.07937,0.93651,0.09524,0.93651,0.11111,0.93651,0.12698,0.93651,0.14286,0.93651,0.15873,0.93651,0.1746,0.93651,0.19048,0.93651,0.20635,0.93651,0.22222,0.93651,0.2381,0.93651,0.25397,0.93651,0.26984,0.93651,0.28571,0.93651,0.30159,0.93651,0.31746,0.93651,0.33333,0.93651,0.34921,0.93651,0.36508,0.93651};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.38095,0.93651,0.39683,0.93651,0.4127,0.93651,0.42857,0.93651,0.44444,0.93651,0.46032,0.93651,0.47619,0.93651,0.49206,0.93651,0.50794,0.93651,0.52381,0.93651,0.53968,0.93651,0.55556,0.93651,0.57143,0.93651,0.5873,0.93651,0.60317,0.93651,0.61905,0.93651,0.63492,0.93651,0.65079,0.93651,0.66667,0.93651,0.68254,0.93651,0.69841,0.93651,0.71429,0.93651,0.73016,0.93651,0.74603,0.93651,0.7619,0.93651,0.77778,0.93651,0.79365,0.93651,0.80952,0.93651,0.8254,0.93651,0.84127,0.93651,0.85714,0.93651,0.87302,0.93651,0.88889,0.93651,0.90476,0.93651,0.92063,0.93651,0.93651,0.93651,0.95238,0.93651,0.96825,0.93651,0.98413,0.93651,0.99609,0.93651,0.00391,0.95238,0.01587,0.95238,0.03175,0.95238,0.04762,0.95238,0.06349,0.95238,0.07937,0.95238,0.09524,0.95238,0.11111,0.95238,0.12698,0.95238,0.14286,0.95238,0.15873,0.95238,0.1746,0.95238,0.19048,0.95238,0.20635,0.95238,0.22222,0.95238,0.2381,0.95238,0.25397,0.95238,0.26984,0.95238,0.28571,0.95238,0.30159,0.95238,0.31746,0.95238,0.33333,0.95238,0.34921,0.95238,0.36508,0.95238,0.38095,0.95238,0.39683,0.95238,0.4127,0.95238,0.42857,0.95238,0.44444,0.95238,0.46032,0.95238,0.47619,0.95238,0.49206,0.95238,0.50794,0.95238,0.52381,0.95238,0.53968,0.95238,0.55556,0.95238,0.57143,0.95238,0.5873,0.95238,0.60317,0.95238,0.61905,0.95238,0.63492,0.95238,0.65079,0.95238,0.66667,0.95238,0.68254,0.95238,0.69841,0.95238,0.71429,0.95238,0.73016,0.95238,0.74603,0.95238,0.7619,0.95238,0.77778,0.95238,0.79365,0.95238,0.80952,0.95238,0.8254,0.95238,0.84127,0.95238,0.85714,0.95238,0.87302,0.95238,0.88889,0.95238,0.90476,0.95238,0.92063,0.95238,0.93651,0.95238};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.95238,0.95238,0.96825,0.95238,0.98413,0.95238,0.99609,0.95238,0.00391,0.96825,0.01587,0.96825,0.03175,0.96825,0.04762,0.96825,0.06349,0.96825,0.07937,0.96825,0.09524,0.96825,0.11111,0.96825,0.12698,0.96825,0.14286,0.96825,0.15873,0.96825,0.1746,0.96825,0.19048,0.96825,0.20635,0.96825,0.22222,0.96825,0.2381,0.96825,0.25397,0.96825,0.26984,0.96825,0.28571,0.96825,0.30159,0.96825,0.31746,0.96825,0.33333,0.96825,0.34921,0.96825,0.36508,0.96825,0.38095,0.96825,0.39683,0.96825,0.4127,0.96825,0.42857,0.96825,0.44444,0.96825,0.46032,0.96825,0.47619,0.96825,0.49206,0.96825,0.50794,0.96825,0.52381,0.96825,0.53968,0.96825,0.55556,0.96825,0.57143,0.96825,0.5873,0.96825,0.60317,0.96825,0.61905,0.96825,0.63492,0.96825,0.65079,0.96825,0.66667,0.96825,0.68254,0.96825,0.69841,0.96825,0.71429,0.96825,0.73016,0.96825,0.74603,0.96825,0.7619,0.96825,0.77778,0.96825,0.79365,0.96825,0.80952,0.96825,0.8254,0.96825,0.84127,0.96825,0.85714,0.96825,0.87302,0.96825,0.88889,0.96825,0.90476,0.96825,0.92063,0.96825,0.93651,0.96825,0.95238,0.96825,0.96825,0.96825,0.98413,0.96825,0.99609,0.96825,0.00391,0.98413,0.01587,0.98413,0.03175,0.98413,0.04762,0.98413,0.06349,0.98413,0.07937,0.98413,0.09524,0.98413,0.11111,0.98413,0.12698,0.98413,0.14286,0.98413,0.15873,0.98413,0.1746,0.98413,0.19048,0.98413,0.20635,0.98413,0.22222,0.98413,0.2381,0.98413,0.25397,0.98413,0.26984,0.98413,0.28571,0.98413,0.30159,0.98413,0.31746,0.98413,0.33333,0.98413,0.34921,0.98413,0.36508,0.98413,0.38095,0.98413,0.39683,0.98413,0.4127,0.98413,0.42857,0.98413,0.44444,0.98413,0.46032,0.98413,0.47619,0.98413,0.49206,0.98413};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.50794,0.98413,0.52381,0.98413,0.53968,0.98413,0.55556,0.98413,0.57143,0.98413,0.5873,0.98413,0.60317,0.98413,0.61905,0.98413,0.63492,0.98413,0.65079,0.98413,0.66667,0.98413,0.68254,0.98413,0.69841,0.98413,0.71429,0.98413,0.73016,0.98413,0.74603,0.98413,0.7619,0.98413,0.77778,0.98413,0.79365,0.98413,0.80952,0.98413,0.8254,0.98413,0.84127,0.98413,0.85714,0.98413,0.87302,0.98413,0.88889,0.98413,0.90476,0.98413,0.92063,0.98413,0.93651,0.98413,0.95238,0.98413,0.96825,0.98413,0.98413,0.98413,0.99609,0.98413,0.00391,0.99609,0.01587,0.99609,0.03175,0.99609,0.04762,0.99609,0.06349,0.99609,0.07937,0.99609,0.09524,0.99609,0.11111,0.99609,0.12698,0.99609,0.14286,0.99609,0.15873,0.99609,0.1746,0.99609,0.19048,0.99609,0.20635,0.99609,0.22222,0.99609,0.2381,0.99609,0.25397,0.99609,0.26984,0.99609,0.28571,0.99609,0.30159,0.99609,0.31746,0.99609,0.33333,0.99609,0.34921,0.99609,0.36508,0.99609,0.38095,0.99609,0.39683,0.99609,0.4127,0.99609,0.42857,0.99609,0.44444,0.99609,0.46032,0.99609,0.47619,0.99609,0.49206,0.99609,0.50794,0.99609,0.52381,0.99609,0.53968,0.99609,0.55556,0.99609,0.57143,0.99609,0.5873,0.99609,0.60317,0.99609,0.61905,0.99609,0.63492,0.99609,0.65079,0.99609,0.66667,0.99609,0.68254,0.99609,0.69841,0.99609,0.71429,0.99609,0.73016,0.99609,0.74603,0.99609,0.7619,0.99609,0.77778,0.99609,0.79365,0.99609,0.80952,0.99609,0.8254,0.99609,0.84127,0.99609,0.85714,0.99609,0.87302,0.99609,0.88889,0.99609,0.90476,0.99609,0.92063,0.99609,0.93651,0.99609,0.95238,0.99609,0.96825,0.99609,0.98413,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 4096 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 8192 total numbers made up of 4096 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD013 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD013().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD013\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD013 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD013_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD013_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD013_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD013_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
