####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD012.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD012.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD012.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD012.x3d'),
    GeoLOD(center=(-45.000000,45.000000,-68375.000000),child1Url=["MarsLOD013.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD013.x3d"],range=3.6E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars004.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars004.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,0.000000,0.000000),height=[4367.651,4370.034,4334.8794,4270.3315,4206.1943,4118.777,4081.965,4014.8997,3972.5378,3899.4387,3828.4517,3787.8376,3756.4465,3713.196,3683.7703,3692.3804,3681.213,3662.4712,3653.993,3641.023,3609.1113,3564.932,3533.935,3490.1792,3406.1235,3394.8867,3372.6658,3341.365,3342.5288,3326.555,3294.7185,3192.7854,2549.2576,2623.639,2593.4,2660.0176,2754.6064,2751.9429,2702.6128,2688.0286,2728.161,2737.593,2660.2217,2548.437,2523.3037,2512.4187,2493.0657,2475.5562,2398.8867,2337.8857,2371.414,2426.8633,2520.337,2576.6323,2612.4456,2621.6702,2618.859,2637.7993,2653.2107,2655.949,2656.9775,2646.6885,2585.7754,2452.109,1963.687,2010.09,2100.409,2279.02,2621.4885,2914.2966,2810.098,2639.102,2230.6018,2093.4734,1952.1089,1744.9832,1589.0309,1518.7744,1661.0472,1572.8848,1494.2382,1361.5183,1284.6368,1241.5542,1261.6843,1266.6466,1292.7468,1346.5769,1341.0529,1437.5405,1541.3457,1499.0978,1406.5948,1280.982,1215.9047,1076.2611,1717.4557,1766.7936,1882.9335,2133.347,2381.1357,2402.5703,1996.4536,1659.589,1463.6772,1616.9445,1571.4512,1497.864,1469.4369,1508.1172,1515.5044,1564.4805,1601.7227,1541.5465,1578.125,1626.8856,1450.348,1435.823,1449.5038,1365.7826,1248.2711,1211.4215,1264.6935,1248.3447,1264.7389,1111.8043,1148.0652,1121.4808,1614.8019,1754.1532,1747.763,1708.3676,1718.4482,1718.1715,1636.9191,1497.6759,1429.538,1534.1461,1493.8539,1481.4291,1497.8978,1510.9958,1630.8207,1765.8715,1744.1428,1736.8243,1899.6309,2047.0891,2064.0764,2097.297,2116.1287,1860.0718,1979.0713,1619.7883,1811.5945,1922.2192,1945.3873,1501.849,1509.8973,1466.7389,1311.7642,1429.8718,1529.5286,1425.3727,1339.6161,1295.9209,1266.3754,1231.4957,1254.245,1215.9779,1267.4044,1364.7454,1550.1584,1724.3835,1914.4735,2108.4678,1826.2598,1548.6743,1567.4213,1628.2576,1572.3044,1611.5763,1806.7415,1842.6249,1904.8544,1804.9446,1651.2534,1533.064,1503.1228,1237.2037,1459.8302,1236.245,1229.3372,1197.9233,1280.4458,1162.1333,1185.8456,1218.543,1158.0457,1077.5092,1193.7252,1120.6384,1274.3949,1607.8259,1573.5676,1340.0654,1413.9132,1458.9525,1466.1016,1385.0519,1438.8018,1323.726,1116.409,966.3498,931.10535,877.3099,900.6551,1144.4609,1296.58,1240.7501,1304.7305,1366.6173,1437.3545,1325.8639,1330.2646,1270.7335,1178.1898,1115.8936,1074.498,1168.1091,1220.9888,1345.2719,1643.7717,1625.868,1917.5018,1462.611,437.79483,396.94925,906.5022,1202.5839,1331.5812,1436.3292,1209.805,916.0519,678.5589,655.7832,671.3815,584.8759,602.52856,440.4716,367.34116,639.9879,1390.3363,1736.8088,1330.8405,1715.0715,1365.5363,1332.9497,1269.624,1311.2656,1221.8962,1165.372,1286.1876,1276.2356,1387.1449,1438.9406,1552.4266,1620.909,1601.901,1561.2772,1539.2587,1462.5591,1114.2634,535.7056,223.29689,388.72513,648.0139,723.6647,639.8063,466.922,349.76605,330.01862,349.66107,485.81955,870.21216,971.4296,1129.1099,1094.8417,1363.258,1391.2622,1287.736,1278.337,1291.6497,1318.719,1293.1838,1173.5785,1218.2067,1319.3871,1325.336,1393.407,1426.8303,1378.5273,1187.1995,1040.9788,707.39545,327.5385,408.74112,620.2935,781.8505,379.66922,750.98895,668.47156,360.72168,171.71089,93.14607,219.22745,-107.565796,696.62726,747.4712,697.8216,1738.7092,1258.5961,1321.7471,1376.4069,1526.3883,1550.5541,1305.437,1582.9675,1461.7808,1491.4038,1351.3444,1209.9167,1176.9569,1006.9342,791.24835,565.32947,440.05008,540.41437,632.98267,644.441,1009.3492,1405.8406,1087.5809,272.22357,-318.19415,-547.56573,-592.2297,-659.11066,-632.9095,-154.27637,-59.26334,101.491936,1598.4027,1415.0448,1449.5507,1567.2114,1286.3118,1380.8306,1502.7389,1585.8765,1823.084,1949.7455,1830.4596,1321.448,959.2177,672.5274,373.20908,49.544113,-273.0564,-399.6163,-554.7486,-791.24335,-982.67236,-1204.3307,-1602.488,-2077.5588,-2416.4998,-2204.9248,-2128.3655,-2106.3057,-1278.8871,-797.0587,-557.1118,-450.96268,1504.9747,1432.1897,1540.264,1385.5161,1689.1682,1515.8276,1503.7491,1487.3218,1379.6304,1853.1719,1595.7012,1471.6123,915.6579,483.7539,216.82983,-467.31604,-993.63885,-1555.1378,-2274.1975,-2949.1506,-3746.3477,-4523.8184,-4971.3174,-5132.7363,-5130.5894,-4798.573,-4747.2466,-4648.7026,-3938.8086,-2430.4868,-1721.7107,-835.88513,1275.5585,1147.831,1048.1624,1323.7124,1825.9371,1670.8177,1661.7322,1842.0112,1806.0641,1495.3275,1347.5443,1274.0992,826.91595,389.63797,108.15364,-722.8799,-1642.1139,-2847.41,-3805.6235,-4604.982,-5378.0747,-5884.6997,-6142.803,-6142.707,-6113.5044,-6141.978,-6145.9556,-6030.4443,-5997.2207,-5520.24,-4224.6416,-3310.8457,1156.378,1203.6461,970.55945,1518.1343,1912.105,1842.2244,1575.564,1698.9915,2105.0483,1629.0955,988.8022,1103.2931,665.32794,300.535,372.40988,-270.02298,-1873.9652,-4407.5664,-5603.3135,-6191.0117,-6571.619,-6399.263,-6398.4863,-6402.0234,-6121.639,-6095.09,-6201.969,-6178.2104,-6141.8726,-6085.304,-5889.958,-5360.393,1243.9531,1305.8286,1197.9083,1476.365,1695.7168,1802.5393,1668.2303,1914.2047,2112.309,1790.2721,1786.9873,1570.0675,678.2127,489.4516,348.8644,-159.53528,-2638.4824,-5580.127,-6512.1206,-6693.0796,-6668.948,-6650.4253,-6734.1523,-6619.372,-6621.0146,-6601.228,-6248.8125,-6251.977,-6178.4253,-6130.1147,-5982.0522,-5559.7188,1270.6901,1371.3151,1463.681,1426.6217,1652.1632,1815.6659,1564.767,2005.9796,2288.4646,2399.9873,2162.701,1769.1816,864.0718,764.07336,490.2881,-145.34666,-3126.527,-5902.342,-6548.8057,-6412.5713,-6728.269,-6763.5454,-6687.4717,-6772.552,-6570.736,-6428.6143,-6444.942,-6433.6226,-6325.899,-6061.198,-5528.4023,-5070.235,956.06506,834.219,1178.0956,1584.3365,1614.6736,1827.2946,1611.8342,1854.4353,2036.2145,2181.7969,2169.0332,1967.7065,1213.775,906.4667,651.383,-476.757,-2905.471,-5580.9253,-6830.0215,-6829.5645,-6619.1924,-6837.682,-6766.8574,-6841.079,-6664.6177,-6544.2715,-6566.1484,-6508.3774,-6242.9146,-5707.7275,-5063.0903,-4604.98,1162.5121,932.4877,1119.1455,1591.5885,1549.0403,1533.0454,1609.1313,1966.3029,2358.0273,2243.0615,2001.3883,1724.5552,1254.5327,905.43744,714.7734,147.70593,-1417.3702,-4004.7388,-6303.694,-7080.4014,-7137.0186,-6858.048,-6805.036,-6824.871,-6597.537,-6507.604,-6554.0146,-6479.801,-6139.0977,-5075.7646,-4356.2686,-3876.5566,1379.751,1365.6705,1319.5543,1449.9672,1501.207,1349.3053,1760.5912,2045.5756,2310.7998,2348.5198,1919.86,1896.6283,1634.2228,1141.876,965.94476,996.91455,723.083,-767.7948,-4086.6445,-6047.4136,-6978.4644,-7177.081,-7219.527,-6687.7695,-6607.6577,-6549.805,-6471.508,-5711.2393,-5004.99,-3507.692,-2887.169,-2606.1008,1460.6749,1368.1058,1383.1606,1324.3339,1433.4617,1583.2509,1611.7023,1912.1919,1570.6012,1880.2911,1688.0013,1307.9568,1583.2561,1396.316,897.75934,1086.571,752.11456,266.91962,-844.83386,-2746.2344,-4196.043,-5765.958,-6292.4634,-6190.5225,-6230.689,-6146.208,-5411.597,-3420.3242,-2861.6272,-2591.1401,-2098.759,-1589.7743,1440.2974,1271.3988,1306.3936,1414.1273,1355.5421,1698.0415,1735.9623,1528.995,1409.997,1514.0339,1355.0602,1314.9867,1535.0837,1887.5737,1432.1261,1037.4401,774.6261,1020.4835,382.3616,-752.1423,-1449.7278,-2019.8278,-2672.2224,-3165.0205,-3284.0908,-3648.9592,-3342.9353,-2197.6133,-1104.4648,-1157.787,-1305.9734,-782.6826,972.2702,1093.974,1331.1111,1350.7306,1375.117,1753.29,2145.76,1563.05,1628.6871,1543.1907,1577.1672,1751.7753,1949.4706,2361.545,1875.4552,1611.4757,1218.7145,753.09265,794.4132,153.25253,-682.70984,-931.59143,-898.59424,-1010.3954,-1237.0001,-2106.1858,-1104.9576,-671.02527,-212.02316,7.633394,-342.98175,-29.19768,1010.76263,865.45435,700.92126,789.3998,1296.7975,1015.99414,1698.6342,1713.6099,1730.6984,1865.0618,1884.3583,2167.4841,2576.0574,2360.3381,2126.2788,1698.4132,1681.6549,1659.3356,1246.1815,902.78864,197.05128,-271.63885,-514.675,-805.931,-639.63556,-957.3875,-119.11053,5.500666,379.37366,804.428,613.0243,1158.1843,358.9073,441.88034,412.64584,674.39417,1041.5099,1474.8268,1704.5829,1679.4639,1525.0477,2098.525,2094.5757,2270.414,2558.026,2331.6917,2316.6711,2155.017,2056.5583,1894.3068,1476.8943,1538.5132,1209.393,419.15497,111.29681,-84.12082,87.43882,438.92148,783.47644,616.87946,843.5721,1352.0099,1387.3971,1655.5524,-54.426437,185.6159,478.7257,753.30707,902.41473,1232.2771,1427.6936,1335.2924,1921.0923,2145.179,2368.5906,2536.3547,2433.6353,2323.8882,2222.4602,2356.3499,2498.368,2372.063,2250.999,1685.5829,1605.4314,1500.9233,1107.091,1032.0635,987.8928,523.65424,565.39557,852.4195,1470.3785,2093.223,2338.673,2000.5836,-430.45563,-278.24884,229.10933,294.73563,666.6983,1050.3551,1431.6317,1459.1681,1807.5729,2163.5046,2324.4668,2486.5286,2533.3806,2603.2466,2629.035,2637.4329,2865.2878,2738.4812,2641.217,1639.7955,1497.1633,1596.821,1266.3423,1404.9177,1468.9515,885.5129,710.7212,1202.5107,1906.1273,2571.0273,2781.5376,2381.5151,-712.77014,-833.22186,-128.18636,280.6894,377.22147,926.4951,1939.6919,1444.9342,1488.2091,2000.5846,2245.492,2555.1448,2528.9688,2440.9932,2470.4978,2615.0938,2734.2427,2572.3438,2555.7847,2288.8735,1959.0514,1807.392,1462.0386,1605.8507,1902.4095,1384.9474,1105.3326,1175.2958,1546.0646,2511.7117,2682.1875,2368.0818,-1033.9602,-703.7373,-528.036,-140.69656,-1.143665,530.1494,1398.0247,1408.6185,1971.7788,1767.1445,2000.19,2253.3298,2215.5608,1439.3567,1928.1852,2141.0874,2244.7197,2344.2527,2456.0413,2240.2783,1976.6157,2136.3213,2298.393,2268.4514,2256.576,1806.7534,1450.9495,1153.8981,1326.4766,1880.226,2361.8323,2134.7854,-1165.6986,-903.6566,-433.20688,-353.94034,-512.02014,-75.53935,380.34094,1052.4526,2216.4526,1858.1565,1743.728,1856.7313,1937.2316,1928.4114,1642.5334,1470.7666,1872.8237,2376.0027,2492.631,2343.6602,2257.354,2266.573,2430.1199,2396.7805,2292.6401,1926.1272,1726.9279,1237.8873,1270.1274,1963.1581,2262.1975,1795.6886,-1227.7656,-1074.348,-744.6776,-503.77307,-347.35062,-291.8212,-403.2757,157.61949,1255.2089,1509.5149,1323.5195,1473.238,1385.4514,1464.3182,1225.0803,1280.1417,1811.907,2231.0388,2557.8438,1883.7079,1575.3798,2067.9082,2203.2942,1993.1555,2144.2805,1942.0426,1565.1794,1298.8864,1506.3066,1871.2491,1592.688,991.4003,-1245.0776,-1285.8411,-1000.8268,-824.9554,-380.76215,-169.71938,-147.6029,235.401,599.44446,967.997,1022.2208,1246.5522,936.8606,896.28143,902.0665,1234.6677,1715.1399,1957.8855,2163.4395,1750.8284,1668.0436,1835.7396,2040.0967,1952.2089,1867.9835,1635.5358,1326.9783,989.58636,876.09076,846.4521,603.117,39.084858],solid=False,xDimension=32,xSpacing=2.903226,yScale=50.0,zDimension=32,zSpacing=2.903226,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.03226,0.00391),(0.06452,0.00391),(0.09677,0.00391),(0.12903,0.00391),(0.16129,0.00391),(0.19355,0.00391),(0.22581,0.00391),(0.25806,0.00391),(0.29032,0.00391),(0.32258,0.00391),(0.35484,0.00391),(0.3871,0.00391),(0.41935,0.00391),(0.45161,0.00391),(0.48387,0.00391),(0.51613,0.00391),(0.54839,0.00391),(0.58065,0.00391),(0.6129,0.00391),(0.64516,0.00391),(0.67742,0.00391),(0.70968,0.00391),(0.74194,0.00391),(0.77419,0.00391),(0.80645,0.00391),(0.83871,0.00391),(0.87097,0.00391),(0.90323,0.00391),(0.93548,0.00391),(0.96774,0.00391),(0.99609,0.00391),(0.00391,0.03226),(0.03226,0.03226),(0.06452,0.03226),(0.09677,0.03226),(0.12903,0.03226),(0.16129,0.03226),(0.19355,0.03226),(0.22581,0.03226),(0.25806,0.03226),(0.29032,0.03226),(0.32258,0.03226),(0.35484,0.03226),(0.3871,0.03226),(0.41935,0.03226),(0.45161,0.03226),(0.48387,0.03226),(0.51613,0.03226),(0.54839,0.03226),(0.58065,0.03226),(0.6129,0.03226),(0.64516,0.03226),(0.67742,0.03226),(0.70968,0.03226),(0.74194,0.03226),(0.77419,0.03226),(0.80645,0.03226),(0.83871,0.03226),(0.87097,0.03226),(0.90323,0.03226),(0.93548,0.03226),(0.96774,0.03226),(0.99609,0.03226),(0.00391,0.06452),(0.03226,0.06452),(0.06452,0.06452),(0.09677,0.06452),(0.12903,0.06452),(0.16129,0.06452),(0.19355,0.06452),(0.22581,0.06452),(0.25806,0.06452),(0.29032,0.06452),(0.32258,0.06452),(0.35484,0.06452),(0.3871,0.06452),(0.41935,0.06452),(0.45161,0.06452),(0.48387,0.06452),(0.51613,0.06452),(0.54839,0.06452),(0.58065,0.06452),(0.6129,0.06452),(0.64516,0.06452),(0.67742,0.06452),(0.70968,0.06452),(0.74194,0.06452),(0.77419,0.06452),(0.80645,0.06452),(0.83871,0.06452),(0.87097,0.06452),(0.90323,0.06452),(0.93548,0.06452),(0.96774,0.06452),(0.99609,0.06452),(0.00391,0.09677),(0.03226,0.09677),(0.06452,0.09677),(0.09677,0.09677),(0.12903,0.09677),(0.16129,0.09677),(0.19355,0.09677),(0.22581,0.09677),(0.25806,0.09677),(0.29032,0.09677),(0.32258,0.09677),(0.35484,0.09677),(0.3871,0.09677),(0.41935,0.09677),(0.45161,0.09677),(0.48387,0.09677),(0.51613,0.09677),(0.54839,0.09677),(0.58065,0.09677),(0.6129,0.09677),(0.64516,0.09677),(0.67742,0.09677),(0.70968,0.09677),(0.74194,0.09677),(0.77419,0.09677),(0.80645,0.09677),(0.83871,0.09677),(0.87097,0.09677),(0.90323,0.09677),(0.93548,0.09677),(0.96774,0.09677),(0.99609,0.09677),(0.00391,0.12903),(0.03226,0.12903),(0.06452,0.12903),(0.09677,0.12903),(0.12903,0.12903),(0.16129,0.12903),(0.19355,0.12903),(0.22581,0.12903),(0.25806,0.12903),(0.29032,0.12903),(0.32258,0.12903),(0.35484,0.12903),(0.3871,0.12903),(0.41935,0.12903),(0.45161,0.12903),(0.48387,0.12903),(0.51613,0.12903),(0.54839,0.12903),(0.58065,0.12903),(0.6129,0.12903),(0.64516,0.12903),(0.67742,0.12903),(0.70968,0.12903),(0.74194,0.12903),(0.77419,0.12903),(0.80645,0.12903),(0.83871,0.12903),(0.87097,0.12903),(0.90323,0.12903),(0.93548,0.12903),(0.96774,0.12903),(0.99609,0.12903),(0.00391,0.16129),(0.03226,0.16129),(0.06452,0.16129),(0.09677,0.16129),(0.12903,0.16129),(0.16129,0.16129),(0.19355,0.16129),(0.22581,0.16129),(0.25806,0.16129),(0.29032,0.16129),(0.32258,0.16129),(0.35484,0.16129),(0.3871,0.16129),(0.41935,0.16129),(0.45161,0.16129),(0.48387,0.16129),(0.51613,0.16129),(0.54839,0.16129),(0.58065,0.16129),(0.6129,0.16129),(0.64516,0.16129),(0.67742,0.16129),(0.70968,0.16129),(0.74194,0.16129),(0.77419,0.16129),(0.80645,0.16129),(0.83871,0.16129),(0.87097,0.16129),(0.90323,0.16129),(0.93548,0.16129),(0.96774,0.16129),(0.99609,0.16129),(0.00391,0.19355),(0.03226,0.19355),(0.06452,0.19355),(0.09677,0.19355),(0.12903,0.19355),(0.16129,0.19355),(0.19355,0.19355),(0.22581,0.19355),(0.25806,0.19355),(0.29032,0.19355),(0.32258,0.19355),(0.35484,0.19355),(0.3871,0.19355),(0.41935,0.19355),(0.45161,0.19355),(0.48387,0.19355),(0.51613,0.19355),(0.54839,0.19355),(0.58065,0.19355),(0.6129,0.19355),(0.64516,0.19355),(0.67742,0.19355),(0.70968,0.19355),(0.74194,0.19355),(0.77419,0.19355),(0.80645,0.19355),(0.83871,0.19355),(0.87097,0.19355),(0.90323,0.19355),(0.93548,0.19355),(0.96774,0.19355),(0.99609,0.19355),(0.00391,0.22581),(0.03226,0.22581),(0.06452,0.22581),(0.09677,0.22581),(0.12903,0.22581),(0.16129,0.22581),(0.19355,0.22581),(0.22581,0.22581),(0.25806,0.22581),(0.29032,0.22581),(0.32258,0.22581),(0.35484,0.22581),(0.3871,0.22581),(0.41935,0.22581),(0.45161,0.22581),(0.48387,0.22581),(0.51613,0.22581),(0.54839,0.22581),(0.58065,0.22581),(0.6129,0.22581),(0.64516,0.22581),(0.67742,0.22581),(0.70968,0.22581),(0.74194,0.22581),(0.77419,0.22581),(0.80645,0.22581),(0.83871,0.22581),(0.87097,0.22581),(0.90323,0.22581),(0.93548,0.22581),(0.96774,0.22581),(0.99609,0.22581),(0.00391,0.25806),(0.03226,0.25806),(0.06452,0.25806),(0.09677,0.25806),(0.12903,0.25806),(0.16129,0.25806),(0.19355,0.25806),(0.22581,0.25806),(0.25806,0.25806),(0.29032,0.25806),(0.32258,0.25806),(0.35484,0.25806),(0.3871,0.25806),(0.41935,0.25806),(0.45161,0.25806),(0.48387,0.25806),(0.51613,0.25806),(0.54839,0.25806),(0.58065,0.25806),(0.6129,0.25806),(0.64516,0.25806),(0.67742,0.25806),(0.70968,0.25806),(0.74194,0.25806),(0.77419,0.25806),(0.80645,0.25806),(0.83871,0.25806),(0.87097,0.25806),(0.90323,0.25806),(0.93548,0.25806),(0.96774,0.25806),(0.99609,0.25806),(0.00391,0.29032),(0.03226,0.29032),(0.06452,0.29032),(0.09677,0.29032),(0.12903,0.29032),(0.16129,0.29032),(0.19355,0.29032),(0.22581,0.29032),(0.25806,0.29032),(0.29032,0.29032),(0.32258,0.29032),(0.35484,0.29032),(0.3871,0.29032),(0.41935,0.29032),(0.45161,0.29032),(0.48387,0.29032),(0.51613,0.29032),(0.54839,0.29032),(0.58065,0.29032),(0.6129,0.29032),(0.64516,0.29032),(0.67742,0.29032),(0.70968,0.29032),(0.74194,0.29032),(0.77419,0.29032),(0.80645,0.29032),(0.83871,0.29032),(0.87097,0.29032),(0.90323,0.29032),(0.93548,0.29032),(0.96774,0.29032),(0.99609,0.29032),(0.00391,0.32258),(0.03226,0.32258),(0.06452,0.32258),(0.09677,0.32258),(0.12903,0.32258),(0.16129,0.32258),(0.19355,0.32258),(0.22581,0.32258),(0.25806,0.32258),(0.29032,0.32258),(0.32258,0.32258),(0.35484,0.32258),(0.3871,0.32258),(0.41935,0.32258),(0.45161,0.32258),(0.48387,0.32258),(0.51613,0.32258),(0.54839,0.32258),(0.58065,0.32258),(0.6129,0.32258),(0.64516,0.32258),(0.67742,0.32258),(0.70968,0.32258),(0.74194,0.32258),(0.77419,0.32258),(0.80645,0.32258),(0.83871,0.32258),(0.87097,0.32258),(0.90323,0.32258),(0.93548,0.32258),(0.96774,0.32258),(0.99609,0.32258),(0.00391,0.35484),(0.03226,0.35484),(0.06452,0.35484),(0.09677,0.35484),(0.12903,0.35484),(0.16129,0.35484),(0.19355,0.35484),(0.22581,0.35484),(0.25806,0.35484),(0.29032,0.35484),(0.32258,0.35484),(0.35484,0.35484),(0.3871,0.35484),(0.41935,0.35484),(0.45161,0.35484),(0.48387,0.35484),(0.51613,0.35484),(0.54839,0.35484),(0.58065,0.35484),(0.6129,0.35484),(0.64516,0.35484),(0.67742,0.35484),(0.70968,0.35484),(0.74194,0.35484),(0.77419,0.35484),(0.80645,0.35484),(0.83871,0.35484),(0.87097,0.35484),(0.90323,0.35484),(0.93548,0.35484),(0.96774,0.35484),(0.99609,0.35484),(0.00391,0.3871),(0.03226,0.3871),(0.06452,0.3871),(0.09677,0.3871),(0.12903,0.3871),(0.16129,0.3871),(0.19355,0.3871),(0.22581,0.3871),(0.25806,0.3871),(0.29032,0.3871),(0.32258,0.3871),(0.35484,0.3871),(0.3871,0.3871),(0.41935,0.3871),(0.45161,0.3871),(0.48387,0.3871),(0.51613,0.3871),(0.54839,0.3871),(0.58065,0.3871),(0.6129,0.3871),(0.64516,0.3871),(0.67742,0.3871),(0.70968,0.3871),(0.74194,0.3871),(0.77419,0.3871),(0.80645,0.3871),(0.83871,0.3871),(0.87097,0.3871),(0.90323,0.3871),(0.93548,0.3871),(0.96774,0.3871),(0.99609,0.3871),(0.00391,0.41935),(0.03226,0.41935),(0.06452,0.41935),(0.09677,0.41935),(0.12903,0.41935),(0.16129,0.41935),(0.19355,0.41935),(0.22581,0.41935),(0.25806,0.41935),(0.29032,0.41935),(0.32258,0.41935),(0.35484,0.41935),(0.3871,0.41935),(0.41935,0.41935),(0.45161,0.41935),(0.48387,0.41935),(0.51613,0.41935),(0.54839,0.41935),(0.58065,0.41935),(0.6129,0.41935),(0.64516,0.41935),(0.67742,0.41935),(0.70968,0.41935),(0.74194,0.41935),(0.77419,0.41935),(0.80645,0.41935),(0.83871,0.41935),(0.87097,0.41935),(0.90323,0.41935),(0.93548,0.41935),(0.96774,0.41935),(0.99609,0.41935),(0.00391,0.45161),(0.03226,0.45161),(0.06452,0.45161),(0.09677,0.45161),(0.12903,0.45161),(0.16129,0.45161),(0.19355,0.45161),(0.22581,0.45161),(0.25806,0.45161),(0.29032,0.45161),(0.32258,0.45161),(0.35484,0.45161),(0.3871,0.45161),(0.41935,0.45161),(0.45161,0.45161),(0.48387,0.45161),(0.51613,0.45161),(0.54839,0.45161),(0.58065,0.45161),(0.6129,0.45161),(0.64516,0.45161),(0.67742,0.45161),(0.70968,0.45161),(0.74194,0.45161),(0.77419,0.45161),(0.80645,0.45161),(0.83871,0.45161),(0.87097,0.45161),(0.90323,0.45161),(0.93548,0.45161),(0.96774,0.45161),(0.99609,0.45161),(0.00391,0.48387),(0.03226,0.48387),(0.06452,0.48387),(0.09677,0.48387),(0.12903,0.48387),(0.16129,0.48387),(0.19355,0.48387),(0.22581,0.48387),(0.25806,0.48387),(0.29032,0.48387),(0.32258,0.48387),(0.35484,0.48387),(0.3871,0.48387),(0.41935,0.48387),(0.45161,0.48387),(0.48387,0.48387),(0.51613,0.48387),(0.54839,0.48387),(0.58065,0.48387),(0.6129,0.48387),(0.64516,0.48387),(0.67742,0.48387),(0.70968,0.48387),(0.74194,0.48387),(0.77419,0.48387),(0.80645,0.48387),(0.83871,0.48387),(0.87097,0.48387),(0.90323,0.48387),(0.93548,0.48387),(0.96774,0.48387),(0.99609,0.48387),(0.00391,0.51613),(0.03226,0.51613),(0.06452,0.51613),(0.09677,0.51613),(0.12903,0.51613),(0.16129,0.51613),(0.19355,0.51613),(0.22581,0.51613),(0.25806,0.51613),(0.29032,0.51613),(0.32258,0.51613),(0.35484,0.51613),(0.3871,0.51613),(0.41935,0.51613),(0.45161,0.51613),(0.48387,0.51613),(0.51613,0.51613),(0.54839,0.51613),(0.58065,0.51613),(0.6129,0.51613),(0.64516,0.51613),(0.67742,0.51613),(0.70968,0.51613),(0.74194,0.51613),(0.77419,0.51613),(0.80645,0.51613),(0.83871,0.51613),(0.87097,0.51613),(0.90323,0.51613),(0.93548,0.51613),(0.96774,0.51613),(0.99609,0.51613),(0.00391,0.54839),(0.03226,0.54839),(0.06452,0.54839),(0.09677,0.54839),(0.12903,0.54839),(0.16129,0.54839),(0.19355,0.54839),(0.22581,0.54839),(0.25806,0.54839),(0.29032,0.54839),(0.32258,0.54839),(0.35484,0.54839),(0.3871,0.54839),(0.41935,0.54839),(0.45161,0.54839),(0.48387,0.54839),(0.51613,0.54839),(0.54839,0.54839),(0.58065,0.54839),(0.6129,0.54839),(0.64516,0.54839),(0.67742,0.54839),(0.70968,0.54839),(0.74194,0.54839),(0.77419,0.54839),(0.80645,0.54839),(0.83871,0.54839),(0.87097,0.54839),(0.90323,0.54839),(0.93548,0.54839),(0.96774,0.54839),(0.99609,0.54839),(0.00391,0.58065),(0.03226,0.58065),(0.06452,0.58065),(0.09677,0.58065),(0.12903,0.58065),(0.16129,0.58065),(0.19355,0.58065),(0.22581,0.58065),(0.25806,0.58065),(0.29032,0.58065),(0.32258,0.58065),(0.35484,0.58065),(0.3871,0.58065),(0.41935,0.58065),(0.45161,0.58065),(0.48387,0.58065),(0.51613,0.58065),(0.54839,0.58065),(0.58065,0.58065),(0.6129,0.58065),(0.64516,0.58065),(0.67742,0.58065),(0.70968,0.58065),(0.74194,0.58065),(0.77419,0.58065),(0.80645,0.58065),(0.83871,0.58065),(0.87097,0.58065),(0.90323,0.58065),(0.93548,0.58065),(0.96774,0.58065),(0.99609,0.58065),(0.00391,0.6129),(0.03226,0.6129),(0.06452,0.6129),(0.09677,0.6129),(0.12903,0.6129),(0.16129,0.6129),(0.19355,0.6129),(0.22581,0.6129),(0.25806,0.6129),(0.29032,0.6129),(0.32258,0.6129),(0.35484,0.6129),(0.3871,0.6129),(0.41935,0.6129),(0.45161,0.6129),(0.48387,0.6129),(0.51613,0.6129),(0.54839,0.6129),(0.58065,0.6129),(0.6129,0.6129),(0.64516,0.6129),(0.67742,0.6129),(0.70968,0.6129),(0.74194,0.6129),(0.77419,0.6129),(0.80645,0.6129),(0.83871,0.6129),(0.87097,0.6129),(0.90323,0.6129),(0.93548,0.6129),(0.96774,0.6129),(0.99609,0.6129),(0.00391,0.64516),(0.03226,0.64516),(0.06452,0.64516),(0.09677,0.64516),(0.12903,0.64516),(0.16129,0.64516),(0.19355,0.64516),(0.22581,0.64516),(0.25806,0.64516),(0.29032,0.64516),(0.32258,0.64516),(0.35484,0.64516),(0.3871,0.64516),(0.41935,0.64516),(0.45161,0.64516),(0.48387,0.64516),(0.51613,0.64516),(0.54839,0.64516),(0.58065,0.64516),(0.6129,0.64516),(0.64516,0.64516),(0.67742,0.64516),(0.70968,0.64516),(0.74194,0.64516),(0.77419,0.64516),(0.80645,0.64516),(0.83871,0.64516),(0.87097,0.64516),(0.90323,0.64516),(0.93548,0.64516),(0.96774,0.64516),(0.99609,0.64516),(0.00391,0.67742),(0.03226,0.67742),(0.06452,0.67742),(0.09677,0.67742),(0.12903,0.67742),(0.16129,0.67742),(0.19355,0.67742),(0.22581,0.67742),(0.25806,0.67742),(0.29032,0.67742),(0.32258,0.67742),(0.35484,0.67742),(0.3871,0.67742),(0.41935,0.67742),(0.45161,0.67742),(0.48387,0.67742),(0.51613,0.67742),(0.54839,0.67742),(0.58065,0.67742),(0.6129,0.67742),(0.64516,0.67742),(0.67742,0.67742),(0.70968,0.67742),(0.74194,0.67742),(0.77419,0.67742),(0.80645,0.67742),(0.83871,0.67742),(0.87097,0.67742),(0.90323,0.67742),(0.93548,0.67742),(0.96774,0.67742),(0.99609,0.67742),(0.00391,0.70968),(0.03226,0.70968),(0.06452,0.70968),(0.09677,0.70968),(0.12903,0.70968),(0.16129,0.70968),(0.19355,0.70968),(0.22581,0.70968),(0.25806,0.70968),(0.29032,0.70968),(0.32258,0.70968),(0.35484,0.70968),(0.3871,0.70968),(0.41935,0.70968),(0.45161,0.70968),(0.48387,0.70968),(0.51613,0.70968),(0.54839,0.70968),(0.58065,0.70968),(0.6129,0.70968),(0.64516,0.70968),(0.67742,0.70968),(0.70968,0.70968),(0.74194,0.70968),(0.77419,0.70968),(0.80645,0.70968),(0.83871,0.70968),(0.87097,0.70968),(0.90323,0.70968),(0.93548,0.70968),(0.96774,0.70968),(0.99609,0.70968),(0.00391,0.74194),(0.03226,0.74194),(0.06452,0.74194),(0.09677,0.74194),(0.12903,0.74194),(0.16129,0.74194),(0.19355,0.74194),(0.22581,0.74194),(0.25806,0.74194),(0.29032,0.74194),(0.32258,0.74194),(0.35484,0.74194),(0.3871,0.74194),(0.41935,0.74194),(0.45161,0.74194),(0.48387,0.74194),(0.51613,0.74194),(0.54839,0.74194),(0.58065,0.74194),(0.6129,0.74194),(0.64516,0.74194),(0.67742,0.74194),(0.70968,0.74194),(0.74194,0.74194),(0.77419,0.74194),(0.80645,0.74194),(0.83871,0.74194),(0.87097,0.74194),(0.90323,0.74194),(0.93548,0.74194),(0.96774,0.74194),(0.99609,0.74194),(0.00391,0.77419),(0.03226,0.77419),(0.06452,0.77419),(0.09677,0.77419),(0.12903,0.77419),(0.16129,0.77419),(0.19355,0.77419),(0.22581,0.77419),(0.25806,0.77419),(0.29032,0.77419),(0.32258,0.77419),(0.35484,0.77419),(0.3871,0.77419),(0.41935,0.77419),(0.45161,0.77419),(0.48387,0.77419),(0.51613,0.77419),(0.54839,0.77419),(0.58065,0.77419),(0.6129,0.77419),(0.64516,0.77419),(0.67742,0.77419),(0.70968,0.77419),(0.74194,0.77419),(0.77419,0.77419),(0.80645,0.77419),(0.83871,0.77419),(0.87097,0.77419),(0.90323,0.77419),(0.93548,0.77419),(0.96774,0.77419),(0.99609,0.77419),(0.00391,0.80645),(0.03226,0.80645),(0.06452,0.80645),(0.09677,0.80645),(0.12903,0.80645),(0.16129,0.80645),(0.19355,0.80645),(0.22581,0.80645),(0.25806,0.80645),(0.29032,0.80645),(0.32258,0.80645),(0.35484,0.80645),(0.3871,0.80645),(0.41935,0.80645),(0.45161,0.80645),(0.48387,0.80645),(0.51613,0.80645),(0.54839,0.80645),(0.58065,0.80645),(0.6129,0.80645),(0.64516,0.80645),(0.67742,0.80645),(0.70968,0.80645),(0.74194,0.80645),(0.77419,0.80645),(0.80645,0.80645),(0.83871,0.80645),(0.87097,0.80645),(0.90323,0.80645),(0.93548,0.80645),(0.96774,0.80645),(0.99609,0.80645),(0.00391,0.83871),(0.03226,0.83871),(0.06452,0.83871),(0.09677,0.83871),(0.12903,0.83871),(0.16129,0.83871),(0.19355,0.83871),(0.22581,0.83871),(0.25806,0.83871),(0.29032,0.83871),(0.32258,0.83871),(0.35484,0.83871),(0.3871,0.83871),(0.41935,0.83871),(0.45161,0.83871),(0.48387,0.83871),(0.51613,0.83871),(0.54839,0.83871),(0.58065,0.83871),(0.6129,0.83871),(0.64516,0.83871),(0.67742,0.83871),(0.70968,0.83871),(0.74194,0.83871),(0.77419,0.83871),(0.80645,0.83871),(0.83871,0.83871),(0.87097,0.83871),(0.90323,0.83871),(0.93548,0.83871),(0.96774,0.83871),(0.99609,0.83871),(0.00391,0.87097),(0.03226,0.87097),(0.06452,0.87097),(0.09677,0.87097),(0.12903,0.87097),(0.16129,0.87097),(0.19355,0.87097),(0.22581,0.87097),(0.25806,0.87097),(0.29032,0.87097),(0.32258,0.87097),(0.35484,0.87097),(0.3871,0.87097),(0.41935,0.87097),(0.45161,0.87097),(0.48387,0.87097),(0.51613,0.87097),(0.54839,0.87097),(0.58065,0.87097),(0.6129,0.87097),(0.64516,0.87097),(0.67742,0.87097),(0.70968,0.87097),(0.74194,0.87097),(0.77419,0.87097),(0.80645,0.87097),(0.83871,0.87097),(0.87097,0.87097),(0.90323,0.87097),(0.93548,0.87097),(0.96774,0.87097),(0.99609,0.87097),(0.00391,0.90323),(0.03226,0.90323),(0.06452,0.90323),(0.09677,0.90323),(0.12903,0.90323),(0.16129,0.90323),(0.19355,0.90323),(0.22581,0.90323),(0.25806,0.90323),(0.29032,0.90323),(0.32258,0.90323),(0.35484,0.90323),(0.3871,0.90323),(0.41935,0.90323),(0.45161,0.90323),(0.48387,0.90323),(0.51613,0.90323),(0.54839,0.90323),(0.58065,0.90323),(0.6129,0.90323),(0.64516,0.90323),(0.67742,0.90323),(0.70968,0.90323),(0.74194,0.90323),(0.77419,0.90323),(0.80645,0.90323),(0.83871,0.90323),(0.87097,0.90323),(0.90323,0.90323),(0.93548,0.90323),(0.96774,0.90323),(0.99609,0.90323),(0.00391,0.93548),(0.03226,0.93548),(0.06452,0.93548),(0.09677,0.93548),(0.12903,0.93548),(0.16129,0.93548),(0.19355,0.93548),(0.22581,0.93548),(0.25806,0.93548),(0.29032,0.93548),(0.32258,0.93548),(0.35484,0.93548),(0.3871,0.93548),(0.41935,0.93548),(0.45161,0.93548),(0.48387,0.93548),(0.51613,0.93548),(0.54839,0.93548),(0.58065,0.93548),(0.6129,0.93548),(0.64516,0.93548),(0.67742,0.93548),(0.70968,0.93548),(0.74194,0.93548),(0.77419,0.93548),(0.80645,0.93548),(0.83871,0.93548),(0.87097,0.93548),(0.90323,0.93548),(0.93548,0.93548),(0.96774,0.93548),(0.99609,0.93548),(0.00391,0.96774),(0.03226,0.96774),(0.06452,0.96774),(0.09677,0.96774),(0.12903,0.96774),(0.16129,0.96774),(0.19355,0.96774),(0.22581,0.96774),(0.25806,0.96774),(0.29032,0.96774),(0.32258,0.96774),(0.35484,0.96774),(0.3871,0.96774),(0.41935,0.96774),(0.45161,0.96774),(0.48387,0.96774),(0.51613,0.96774),(0.54839,0.96774),(0.58065,0.96774),(0.6129,0.96774),(0.64516,0.96774),(0.67742,0.96774),(0.70968,0.96774),(0.74194,0.96774),(0.77419,0.96774),(0.80645,0.96774),(0.83871,0.96774),(0.87097,0.96774),(0.90323,0.96774),(0.93548,0.96774),(0.96774,0.96774),(0.99609,0.96774),(0.00391,0.99609),(0.03226,0.99609),(0.06452,0.99609),(0.09677,0.99609),(0.12903,0.99609),(0.16129,0.99609),(0.19355,0.99609),(0.22581,0.99609),(0.25806,0.99609),(0.29032,0.99609),(0.32258,0.99609),(0.35484,0.99609),(0.3871,0.99609),(0.41935,0.99609),(0.45161,0.99609),(0.48387,0.99609),(0.51613,0.99609),(0.54839,0.99609),(0.58065,0.99609),(0.6129,0.99609),(0.64516,0.99609),(0.67742,0.99609),(0.70968,0.99609),(0.74194,0.99609),(0.77419,0.99609),(0.80645,0.99609),(0.83871,0.99609),(0.87097,0.99609),(0.90323,0.99609),(0.93548,0.99609),(0.96774,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD012.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD012.py load and self-test diagnostics complete.")
