####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD011.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD011.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD011.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD011.x3d'),
    GeoLOD(center=(44.911417,-45.000000,-59125.000000),range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars003.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars003.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,-90.000000,0.000000),height=[2997.4866,2829.7004,2702.3013,2609.618,2520.806,2422.1755,2226.834,2039.5488,1855.033,1688.7931,1486.843,1339.2358,1121.4788,-808.35834,465.44244,3149.61,3749.198,2932.7869,2207.452,2685.5823,3126.629,3552.2332,3525.099,3510.7117,3410.9675,3370.8796,3324.3552,3272.7207,3081.0308,2744.176,2397.475,2156.9614,1968.2957,1752.0448,1626.9838,1575.0697,1584.0204,1490.8569,1434.715,1394.4384,1213.5332,329.95535,551.8444,907.1537,965.95386,1233.0702,1442.0287,799.0692,779.98505,760.9241,520.03015,1236.7473,928.90454,866.5732,892.7185,793.6038,589.7236,504.46515,520.6834,505.90366,808.0457,-1687.5538,-2636.6335,-3023.8455,-162.29982,55.45822,33.354008,-287.8447,-673.86957,-929.29205,-1131.7341,-1216.8324,-3258.9382,-3764.1895,-2663.1538,-1978.3816,-3610.6416,-3971.0825,-4684.837,-4903.6006,-4348.2783,-3030.8872,-1789.6205,-1604.8358,-1457.138,-1698.8573,-2187.9338,-1590.6372,-1728.2416,-1947.1569,-1895.4135,-2059.4763,-1705.8046,-1515.505,-2279.2654,-2260.237,-1784.4049,-1442.5342,-1304.6333,-1590.3889,-1802.8022,-2803.4072,-3098.3738,-2846.9753,-2682.2117,-2513.6187,-2321.1353,-2233.0632,-2077.807,-2014.1431,-2028.6472,-2113.6296,-2016.9414,-1955.4191,-2026.5983,-1922.779,-1791.9037,-1630.3251,-1566.6052,-1458.9998,-1394.4283,-1396.4448,-1400.7465,-1310.2893,-1266.8615,-1221.9246,-1219.992,-1272.5734,2902.6816,2698.2896,2564.6167,2457.5657,2347.8655,2265.3389,2086.555,1931.7421,1727.9963,1497.4329,1295.7194,837.67883,1375.4266,-398.8538,1641.2875,3071.8792,3543.7605,3840.6462,3755.6375,3694.0432,3841.585,3679.7578,3522.928,3375.2366,3350.6602,3286.684,3181.7642,3100.5486,2837.6787,2553.5205,2255.5688,2019.4098,1877.3962,1730.569,1560.8673,1470.5482,1423.1356,1421.0199,1331.3336,1234.9425,1307.1674,675.3885,643.039,1278.3295,1137.6058,976.8133,1138.2574,287.932,202.44756,225.07242,132.93823,652.26306,1048.5491,757.4118,726.7825,689.93677,605.4151,589.45514,484.2024,610.6737,741.08887,446.58533,-433.4253,-1873.8422,-1043.8318,271.15314,17.625338,-361.1103,-511.58554,-557.9283,-572.79944,-940.6879,-2058.2756,-3356.9893,-3720.642,-3697.6387,-3723.8044,-4031.101,-4330.6445,-4401.2705,-4437.72,-3451.5576,-1794.7567,-1537.7625,-1272.4032,-1445.5068,-1816.2028,-1814.7672,-1837.7003,-1853.598,-2234.1113,-2165.7488,-1740.4501,-1313.4019,-1260.6492,-1899.0487,-2756.2053,-3082.4014,-2265.7356,-1393.3118,-1533.3772,-2506.7996,-3062.6367,-2811.3037,-2634.5261,-2352.2185,-2294.9624,-2069.7307,-1892.4025,-1894.8999,-2030.4135,-2203.287,-1923.6578,-1871.4001,-2120.3452,-1859.1523,-1812.3846,-1594.9425,-1519.23,-1458.5372,-1335.5956,-1508.5514,-1323.3687,-1294.2999,-1271.8536,-1250.3369,-1205.4277,-1222.5358,2737.8196,2593.5686,2496.7134,2366.67,2219.4385,2070.0356,1920.9601,1768.1678,1539.4266,1389.6289,1244.819,931.5353,-308.52792,-648.41895,-34.110786,1668.1453,2300.7053,2928.5042,3289.6653,3519.7039,3822.8906,3737.0989,3543.8503,3335.293,3181.7024,3091.929,2912.181,2820.4106,2631.68,2349.7373,2048.877,1859.5228,1710.2313,1546.4996,1445.9276,1359.3561,1315.2823,1276.3612,1189.2126,1055.3534,920.263,612.48236,100.19727,665.68494,1459.186,1151.8452,938.4152,396.67224,50.02032,7.428793,245.47774,896.5164,978.33417,995.00824,718.6918,711.16473,647.597,619.34106,28.848192,450.0403,496.77893,474.7074,256.4228,-133.51822,-1558.7427,-755.2216,-273.29852,-346.5109,-504.10825,-667.7249,-700.5678,-1257.3605,-1455.733,-1948.5204,-2249.201,-3713.2822,-3857.8892,-4160.999,-4173.8647,-4005.4028,-4309.4785,-3355.2397,-2233.2637,-1630.9756,-1416.7712,-1278.5243,-2001.897,-2471.562,-1736.7268,-1684.6956,-2569.7004,-2601.1133,-2142.233,-1348.5004,-1881.3068,-2391.5159,-2814.6548,-3034.8796,-2587.2732,-2186.985,-1544.8817,-2197.7153,-2977.756,-2561.7468,-2510.3818,-2165.8462,-2246.345,-2172.711,-1897.107,-1844.7437,-1866.2645,-1958.797,-1825.5885,-1848.2479,-1818.0039,-1734.3679,-1817.0415,-1777.7565,-1675.5376,-1480.5238,-1384.7048,-1432.1232,-1305.1615,-1272.8499,-1315.6335,-1310.9606,-1338.2026,-1310.5087,2612.9883,2458.8638,2321.5813,2190.441,2051.4412,1920.0267,1759.6239,1618.2198,1486.6311,1308.7654,1198.7783,1074.8469,-285.79932,-788.4436,-737.6768,477.35516,1217.1053,1905.4386,2736.272,3316.5576,3492.597,3441.2046,3018.634,3102.263,2891.612,2724.6587,2573.8787,2407.1443,2212.507,1950.2245,1773.2217,1631.6584,1475.2888,1404.1655,1354.1354,1246.2708,1224.6906,1150.6813,1080.254,939.9228,818.211,501.5612,394.84222,1051.9188,750.139,1149.1747,920.1662,569.7547,577.4486,655.70215,858.27765,1101.0918,523.4032,-414.33017,-857.3561,630.5568,617.3684,495.22513,539.65906,507.9419,337.12964,187.14465,-79.13864,-245.88644,-464.3427,-1161.6786,-528.3672,-533.4317,-701.3993,-870.00055,-760.41156,-910.0417,-1254.3315,-1914.6173,-1640.6373,-2821.8474,-3877.757,-4187.818,-4064.9668,-4076.0105,-4131.577,-3153.5842,-2843.5073,-2295.1062,-1664.0845,-1639.0676,-3061.217,-2023.8726,-2511.921,-1712.6667,-2689.5312,-3235.856,-2905.396,-1446.5548,-2579.9893,-2895.3052,-3126.624,-2848.701,-2561.3938,-2842.552,-1798.3901,-1741.4462,-2890.7795,-2059.0288,-2706.6562,-2380.1555,-2271.8025,-2115.4692,-1989.6368,-1968.7844,-1960.6522,-1900.8767,-1780.0723,-2308.3003,-2347.114,-1942.1221,-2104.0881,-1751.0526,-1671.8003,-1412.3901,-1341.6343,-1323.0305,-1270.288,-1303.0892,-1356.1244,-1478.6831,-1501.4983,-1362.9469,2503.6812,2319.755,2108.9163,1952.6265,1826.8048,1738.3773,1586.0178,1425.2653,1314.0841,1164.4213,1057.4119,1052.5773,580.2613,-805.7948,-813.12164,-307.81805,783.06665,1443.7157,2145.661,2776.5894,2750.0444,2799.3635,2763.6047,2554.2039,2356.871,2103.8062,2023.0298,1937.7428,1767.0094,1588.3038,1428.2523,1372.8214,1265.2316,1224.5754,1188.8763,1112.0731,1100.6836,1049.9982,963.8559,881.04193,704.3766,388.22177,353.79968,1028.2258,435.13895,981.07733,809.36554,807.29065,966.31006,1071.5057,1056.1238,1079.8502,-171.21062,-446.64798,-704.0601,350.16013,416.54797,300.72617,696.6569,567.75525,281.57214,45.582195,-126.673744,-696.4636,-564.79443,-1097.8116,-817.6452,-696.63043,-868.43854,-1007.0566,-1041.7573,-1097.4055,-1426.569,-1652.7109,-1669.8179,-1696.9884,-3648.5461,-3870.9373,-3640.2842,-3629.6948,-3911.9502,-2230.172,-2151.7021,-2893.0525,-2299.7473,-1831.2614,-3216.3171,-3263.4841,-3052.6384,-3053.9585,-3524.7583,-3074.513,-2130.8975,-1310.8092,-2297.4375,-3073.5078,-3076.8757,-2699.6191,-2711.7024,-2735.1794,-2129.535,-2125.8257,-2836.6497,-1916.6832,-2791.3606,-2404.1504,-2272.318,-2094.6387,-1934.9941,-1947.2339,-1934.0968,-1876.025,-1690.7443,-2174.718,-2436.5122,-1754.049,-1796.9755,-1744.3265,-1654.8846,-1368.1936,-1279.8555,-1229.5571,-1245.0696,-1553.7291,-1365.7562,-1422.3264,-1444.4183,-1352.2604,2316.4448,2164.3513,1970.2931,1809.6409,1638.9078,1539.0157,1336.3916,1243.5565,1095.1313,964.39374,858.0709,834.2122,600.14844,-804.97656,-806.7438,-176.86711,514.7559,1264.0255,1909.4233,2148.163,2032.2844,1905.4615,1778.9775,1622.0995,1529.6625,1419.7423,1338.959,1283.1438,1233.4419,1137.7728,1106.5314,1031.3136,990.29553,1039.2137,983.9515,951.3667,907.2613,891.9157,751.62396,736.9931,600.39905,414.14554,63.74529,494.97003,1025.7871,1023.1991,955.19116,921.65326,991.3677,1002.5633,1029.8384,1084.8994,21.813995,-367.02704,-447.77164,-6.386767,190.27525,90.51448,118.98472,107.6189,-235.95824,-156.46909,-376.14413,-493.149,-736.33636,-1455.0837,-831.0855,-887.76996,-1017.2755,-1185.5802,-1329.1498,-1424.8591,-1759.4484,-1832.082,-1733.2593,-2598.2385,-2735.3164,-2257.542,-1876.3188,-1850.5951,-3744.9446,-3165.6265,-2088.5037,-2987.9163,-2082.32,-2532.8728,-3319.5923,-3244.9307,-2986.1628,-2921.815,-2757.3787,-2517.1682,-2165.1758,-1678.1254,-2002.7872,-2683.6965,-3011.735,-2812.667,-2830.3347,-2358.3357,-1426.895,-1995.7711,-2876.791,-1934.889,-2528.6453,-2118.2002,-2184.5232,-2213.285,-2019.0656,-1883.0737,-2188.2993,-1802.3458,-1703.2728,-1804.5265,-1785.5481,-1672.3994,-1636.8116,-1636.58,-1597.434,-1431.8376,-1331.1505,-1193.2261,-1222.3541,-1378.4226,-1372.3849,-1622.2062,-1544.459,-1367.4152,2154.692,1976.626,1771.3026,1606.8438,1475.9803,1353.0002,1217.1975,1017.1325,905.0949,786.9503,661.8406,587.3199,-116.11873,-801.44196,-795.7426,-787.8727,-376.00546,1120.119,1745.891,1948.3557,1776.2981,1596.626,1408.7758,1231.5973,1080.5515,938.09033,873.8376,800.61255,689.59753,290.28024,824.237,722.53406,737.63666,564.6955,758.395,785.2115,712.4238,730.6239,673.49774,588.75134,461.14642,417.67386,104.43065,233.33308,557.79553,708.7925,852.2031,895.55096,1044.0894,972.6261,1185.2386,1249.7283,932.8329,455.75284,432.418,270.5639,10.667524,-61.060173,-160.94221,-226.81676,-281.62503,-424.63837,-532.718,-863.9587,-1170.5581,-1604.182,-1016.34314,-951.92737,-1556.8776,-1410.7672,-1500.9097,-1684.4329,-1982.8657,-2497.0183,-2033.6539,-3048.461,-2065.9153,-1814.0359,-1716.1815,-1943.4733,-3296.5935,-3390.9265,-3203.235,-2833.2688,-2280.2732,-3326.2031,-3240.275,-3228.0125,-1972.4196,-1781.6842,-1965.186,-2268.3423,-2196.4348,-1865.802,-1665.9905,-2269.7507,-2764.141,-2809.4353,-2689.216,-1904.4058,-1269.1405,-2623.3086,-2956.5056,-2367.2935,-2405.3503,-2020.9652,-1922.3727,-1956.9579,-1990.8193,-1946.1803,-1959.6101,-1740.9713,-2238.7405,-2103.3145,-1795.3646,-1849.761,-1790.1732,-1702.129,-1634.0197,-1681.953,-1427.6947,-1196.4891,-1254.9744,-1406.007,-1404.5848,-1479.7437,-1493.2614,-1339.2146,1924.4976,1740.989,1586.3395,1444.1404,1289.0297,1195.7324,1086.6558,932.4017,722.00726,597.73395,489.63574,301.70856,-327.72858,-759.71747,-800.4013,-820.9456,-808.6286,432.49615,1534.7255,1669.2821,1573.274,1428.3557,1150.5847,1072.596,996.7967,868.6015,808.9324,765.9554,718.1301,484.9609,742.7629,639.9339,609.85675,584.20593,558.14825,552.0931,498.25635,515.6908,479.5484,442.99146,312.95407,277.4884,-59.349396,25.268784,-10.829437,339.03888,463.4392,411.91046,954.60425,909.8055,1046.4808,547.87744,769.84924,978.4968,842.60126,204.06654,-124.639915,-305.34616,-347.33237,-709.6115,-680.08905,-651.2109,-761.54004,-1003.2772,-1213.459,-1288.9336,-944.6709,-1119.2637,-1277.575,-1509.8447,-1636.261,-1864.0913,-1968.1898,-1994.287,-3103.0303,-3720.103,-3032.1223,-2081.0066,-2059.466,-1997.9635,-2924.5452,-3418.096,-3926.6902,-3519.4832,-3407.9482,-3422.2659,-2914.073,-1997.9885,-2597.2407,-2685.9624,-2003.6451,-1831.3044,-2536.2676,-2146.5679,-1817.2037,-1875.8622,-1980.1168,-2168.6997,-1740.8948,-1339.4889,-1749.615,-3076.078,-2437.3584,-2007.2141,-1923.9015,-1856.3176,-1944.821,-1961.7356,-1972.5402,-1949.9355,-2040.9113,-2065.2004,-2596.1033,-2782.6462,-1904.9432,-1945.3402,-1936.7799,-1766.2787,-1477.4834,-1348.0891,-1337.3563,-1290.3035,-1443.0828,-1437.386,-1445.5444,-1408.3285,-1398.0858,-1354.6772,1655.4645,1563.3798,1454.7587,1346.6477,1233.3948,1114.9818,959.09796,800.3175,607.9367,472.57358,329.34686,98.75351,-168.24287,-624.896,-782.5357,-833.17346,-837.80334,-243.93347,1190.2961,1333.7063,1341.5864,1226.5712,1085.2015,988.89136,886.4519,788.9761,826.2562,775.1567,753.8009,744.75726,678.42773,589.50104,570.5556,517.61127,423.88257,373.09308,314.6956,285.2169,245.61801,263.66092,180.2437,152.3974,-104.59307,-105.991806,-200.34843,30.892933,230.82072,655.77136,886.49756,678.9236,580.2556,229.8686,214.256,314.59952,357.93262,-147.78369,-388.8959,-495.55026,-521.3319,-631.21466,-674.3206,-787.7736,-898.78394,-1100.466,-1153.0308,-1457.3684,-1587.3003,-1267.941,-1351.3031,-1516.302,-1645.0833,-1912.0577,-2008.8861,-2065.3381,-3335.198,-4024.0154,-3861.207,-2533.3984,-2182.6436,-2104.1113,-2632.1423,-3333.7378,-3844.23,-4000.0273,-4005.9094,-3916.0276,-2754.6313,-1975.3073,-2996.0393,-3103.8193,-2462.1147,-1631.652,-2080.4407,-2487.962,-2234.0688,-2119.1277,-1712.6163,-1689.6746,-1648.3932,-1756.8131,-2486.2686,-3203.5034,-2264.0632,-2032.7699,-1908.8936,-1932.6428,-1931.2424,-1905.0333,-1913.561,-1954.2968,-1967.7761,-1970.2408,-2409.7444,-2316.1362,-1822.8085,-1838.4501,-2002.8539,-1794.4058,-1438.5968,-1376.3818,-1533.5189,-1511.5845,-1622.2527,-1487.612,-1503.6431,-1397.2324,-1370.7593,-1464.1709,1646.676,1543.1644,1459.8945,1331.6882,1210.2804,1070.6482,920.4819,746.57214,599.3116,439.92563,246.3613,7.38345,-165.82344,-616.84247,-801.9507,-810.7607,-820.98535,-704.86304,471.203,812.87866,968.6267,975.64496,912.9253,891.3034,777.11,743.5202,790.28723,724.9807,740.9818,699.7937,605.89636,523.4337,501.12378,439.7738,363.87894,280.0338,204.46501,144.30498,37.168518,35.950813,-35.2125,-67.91927,-200.05394,-296.23975,-298.3004,-88.61221,191.22617,552.4925,717.9092,666.8396,439.46384,81.4826,19.760899,-7.423482,-93.12764,-443.58957,-566.8469,-566.85175,-830.52545,-851.7444,-980.78015,-1016.08044,-1054.9272,-1196.3392,-1306.0304,-1250.4309,-1606.6207,-1796.3221,-1626.3455,-1553.9532,-1754.4385,-2040.6909,-2105.6858,-2976.069,-3205.2056,-3936.336,-4003.4565,-3363.733,-2697.8005,-2587.9014,-2277.0598,-2462.0913,-3839.1057,-3920.8083,-3857.5046,-2875.5793,-2235.2478,-1738.6156,-2708.4563,-2929.6606,-2245.8118,-1571.1414,-2028.1907,-2432.5894,-2609.6357,-2205.2068,-2224.6838,-2145.8855,-2324.389,-2557.3982,-3109.2468,-2496.0793,-2178.8315,-1958.5632,-1937.8326,-1969.6295,-1972.2418,-2006.2797,-2527.8745,-1913.144,-1935.9751,-1924.9219,-1721.5499,-1678.915,-1846.4657,-1910.6255,-1788.668,-1654.4431,-1447.8053,-1364.691,-1350.0848,-1497.0796,-1507.0005,-1463.0653,-1403.5046,-1376.9489,-1372.8643,-1419.956,1674.5748,1558.206,1436.4326,1305.2567,1194.8263,1076.6929,900.84045,718.9258,565.6952,408.36914,207.62149,-14.321866,-197.76237,-606.8556,-768.47424,-752.45685,-561.99603,-876.25507,-695.6916,-105.09356,515.1465,706.70807,732.0065,735.5644,714.1672,701.38525,742.822,674.64557,683.4054,659.1266,560.976,470.8427,435.74316,352.5676,278.59393,190.61436,122.74023,64.950745,-44.857037,-100.10058,-153.5044,-206.16893,-342.6946,-547.73376,-285.32367,-271.59503,105.9946,298.04456,578.48846,709.9314,508.65378,-380.1236,40.2788,-128.64055,-348.01382,-569.45557,-814.04047,-351.4776,-1101.7817,-981.16254,-1089.7905,-1413.8429,-1241.4098,-1322.0135,-1661.6003,-1448.7413,-1430.7527,-2494.8462,-1939.9965,-1845.1415,-1828.5988,-2024.3356,-2172.312,-3100.297,-3410.546,-3870.6829,-3923.31,-3919.0242,-3786.5205,-3576.0234,-3815.98,-3382.5332,-3917.7131,-3643.0005,-3404.1414,-2269.068,-2134.1301,-2263.185,-1842.7948,-2027.9668,-1840.19,-1833.7131,-2093.9514,-2270.176,-2625.9258,-2657.4592,-2594.1572,-2966.9893,-3018.0422,-2899.945,-2458.997,-2292.6409,-2091.6174,-2020.7485,-1989.945,-2032.8374,-1999.7303,-2057.9875,-2203.9143,-1939.8796,-1981.6885,-1984.0566,-1766.4805,-1627.1208,-1635.7982,-1719.7777,-1657.9369,-1716.706,-1540.4393,-1391.8129,-1362.1172,-1463.1476,-1558.3102,-1490.3387,-1168.0618,-1157.3207,-1319.8308,-1384.3167,1662.5554,1530.7156,1384.487,1254.5481,1139.5636,1018.058,878.2929,725.2969,580.2452,425.2703,236.77269,-4.466097,-270.66394,-540.06946,-672.3424,-776.8331,-569.4408,-806.22437,-877.9338,-770.8967,-148.46053,396.11517,541.38464,599.34,654.88495,621.91144,653.1577,633.6275,616.02893,623.2123,499.51102,403.01434,353.17584,270.0321,205.36183,122.88377,60.58148,5.344089,-83.790596,-134.65903,-235.03955,-297.95114,-485.85333,-417.2063,-336.59387,-356.892,-115.22469,132.43738,155.41374,213.80777,120.86999,214.81013,-190.1369,-154.8938,-414.9752,-595.634,-748.7252,-1078.4097,-733.1747,-1132.2516,-1182.6958,-1362.1322,-1270.2764,-1433.176,-1474.6226,-1480.4921,-1612.0387,-2795.8936,-3137.606,-2018.5388,-1932.9479,-2284.7908,-2294.8901,-3124.7869,-3894.4038,-3602.0764,-3880.1658,-3924.6365,-3883.3286,-3726.4658,-4186.8867,-3724.4905,-3876.051,-3182.1511,-3000.2773,-2529.1807,-2754.7896,-2081.196,-2072.5164,-2164.7212,-2190.0752,-1961.7357,-2082.1384,-2305.0332,-2382.3943,-2914.697,-3467.5188,-3015.3445,-2571.48,-2404.531,-2111.3562,-2098.8774,-2070.7383,-2012.6792,-1987.0063,-1986.7952,-1986.7822,-2069.0488,-2099.853,-2036.0836,-2059.8218,-2106.0134,-1957.738,-1791.8191,-1748.2448,-1898.4498,-1858.4032,-2464.5042,-1819.8438,-1477.973,-1565.8723,-1689.7699,-1576.0215,-1517.4858,-1347.0771,-1302.2921,-1514.5925,-1322.2705,1693.8298,1527.2394,1377.4379,1258.9182,1117.1589,956.5357,795.4074,669.364,540.0104,394.8175,194.71086,-10.196077,-269.5667,-509.27402,-625.82056,-766.237,-821.0928,-840.7776,-863.74677,-904.5071,-638.60297,48.127552,357.10922,453.4552,542.7268,539.8489,576.0015,582.6059,548.4595,524.06274,446.43402,373.42197,326.29733,243.69942,130.45291,55.465073,-13.919405,-87.46688,-131.4107,-215.70212,-301.85562,-315.58813,-486.89172,-577.6651,-532.26556,-613.7857,-562.3931,-150.36955,6.535222,-453.60315,-119.64088,97.33908,-49.10223,-185.36691,-517.3706,-768.6742,-1248.6082,-1923.7968,-1351.2053,-1475.3026,-1551.5247,-1620.3057,-1583.5458,-1692.047,-1684.3966,-1851.2585,-1764.0656,-2394.8884,-2723.194,-2509.973,-2117.4797,-2146.6719,-3093.562,-3869.3103,-3606.0225,-3509.3347,-3922.5696,-3939.6885,-3912.5908,-3881.2144,-3857.4502,-3792.1667,-3364.57,-2709.333,-2645.383,-2483.454,-2603.2,-2377.3757,-2484.4314,-2480.4822,-2329.896,-2102.886,-2399.6794,-2082.1506,-2373.0105,-3155.0823,-2824.1445,-2268.2754,-2238.5896,-2200.1394,-2121.59,-2065.2173,-2014.0558,-2000.038,-2801.0718,-2796.867,-1968.4938,-2083.5022,-2105.4753,-2060.7769,-2065.083,-2059.1785,-2011.826,-1845.9791,-1835.7292,-1971.7239,-1941.6371,-2177.862,-1870.2588,-1793.022,-1770.424,-1754.4186,-1696.1885,-1682.4036,-1614.2018,-1658.4227,-1329.1682,-1346.3799,1724.5981,1548.1107,1376.6604,1218.2976,1082.7732,909.7234,758.4157,627.11847,511.89502,370.80722,192.69882,12.669285,-210.35655,-478.9066,-617.2308,-721.4937,-806.3703,-776.1878,-825.4978,-930.4068,-912.4815,-454.92102,194.09859,342.1575,416.67343,470.13333,427.99686,516.14923,514.0992,460.79178,393.30695,327.59946,249.95181,174.35835,73.757256,-0.23023,-87.8439,-163.0689,-186.14223,-286.76593,-351.59164,-399.47925,-448.85913,-611.30023,-655.47845,-584.3479,-500.21332,-243.83926,-8.901919,68.40384,-42.53596,12.388193,-178.71936,-217.0728,-567.87067,-850.9771,-968.55725,-1079.196,-1503.37,-1721.7578,-1801.6654,-1831.0862,-1864.1487,-1935.5522,-1933.3611,-2147.6746,-2008.3699,-2269.5461,-2389.3333,-2299.9363,-3050.6187,-2996.577,-3802.306,-3858.4524,-3689.9534,-3801.2266,-3952.7864,-3250.6365,-2971.268,-3246.5056,-3880.6646,-3770.9531,-3080.244,-2443.9995,-2421.8901,-2431.5059,-2530.8992,-2565.3596,-2655.443,-2710.2603,-2724.7185,-2748.9624,-2583.4792,-2338.6506,-3022.6033,-2863.1504,-2266.4143,-2131.1516,-2149.052,-2143.763,-2100.72,-2100.707,-1968.983,-2032.744,-2222.1343,-2170.3547,-1883.8496,-1957.052,-2113.3962,-1981.2352,-2137.079,-2337.7026,-2001.3535,-2083.3582,-1917.8853,-1828.6499,-1684.9464,-1803.0502,-1940.3857,-1977.5403,-2003.6669,-1915.7372,-1828.758,-1784.5386,-1835.1378,-1711.8173,-1433.8162,-1406.3385,1726.4202,1534.0674,1340.7013,1160.4946,1004.8179,877.83514,745.4782,608.7215,470.24356,300.7185,141.53342,-22.720997,-201.85579,-386.48096,-543.79364,-659.46204,-739.2756,-728.4523,-812.5945,-937.9524,-930.9392,-669.5953,55.844524,222.11491,289.5549,353.04172,427.69238,435.67105,406.17508,398.83652,362.63666,296.84366,194.11124,117.65488,59.950237,-46.021694,-135.09804,-223.12465,-259.13315,-356.63318,-406.3886,-437.71405,-452.42764,-567.94434,-685.5509,-646.01495,-472.39014,-254.01656,-20.128143,-3.084429,-45.43826,-150.74309,-352.19943,-1346.5402,-545.53894,-944.6878,-1063.3792,-1360.5717,-1604.15,-1785.05,-1897.489,-2128.7534,-2138.4954,-2108.1306,-2163.7788,-2299.6692,-2380.9976,-2425.9126,-2375.8667,-2572.3657,-3363.1545,-3801.5945,-3941.8057,-3871.8672,-3799.156,-3965.854,-3850.1816,-2953.5986,-2710.382,-3718.72,-3504.8804,-3740.3474,-2565.4468,-2388.6724,-2316.2302,-2318.8984,-2540.9143,-2640.1843,-2866.9624,-2956.7607,-3226.3262,-3200.6387,-2874.5693,-2900.0012,-2357.7988,-2018.4092,-2216.1685,-2400.306,-2094.5828,-2000.9669,-2033.0779,-2034.1188,-1915.2643,-2076.5874,-2075.6045,-2097.2734,-1902.3219,-1826.0854,-2134.9915,-1920.4069,-1788.4863,-1900.3718,-2016.0111,-2118.862,-1921.2355,-1868.8324,-1918.0494,-1980.4807,-2030.2874,-2076.028,-2010.979,-1972.2697,-1853.1885,-1779.3728,-1695.679,-1794.338,-1363.77,-1764.9331,1721.9276,1510.8204,1312.0527,1121.6793,973.8326,831.93,702.9278,567.3357,404.0689,235.17784,93.92535,-34.189236,-199.63914,-348.9468,-503.5589,-619.2097,-712.9819,-757.03595,-844.8213,-920.19336,-896.0116,-816.3873,-176.86069,153.75035,246.63052,250.96805,339.15973,342.92957,337.0296,358.90372,304.37027,238.26466,159.86754,101.67448,-18.286606,-84.69414,-155.08209,-285.28693,-403.87732,-418.13718,-454.7623,-438.85367,-463.30872,-633.18445,-716.657,-564.163,-391.83078,-252.48364,-118.62988,-95.76517,-132.01889,-382.28156,-587.7166,-1043.6355,-798.01337,-1044.0718,-1201.5604,-1416.7725,-1598.6199,-2126.8545,-2029.0756,-2144.9622,-2270.1763,-2330.1042,-2397.544,-2492.1138,-2506.9797,-2524.8967,-2718.2065,-3207.1667,-3706.8784,-3797.0264,-3972.063,-3866.8088,-3904.117,-3926.1377,-3610.29,-2634.1743,-2459.6074,-2977.9739,-3839.888,-3664.6284,-2232.3086,-3964.1282,-3819.0444,-2268.9465,-2558.9238,-2810.5356,-3199.4507,-3353.4148,-3315.067,-2849.2495,-2446.5247,-2247.3782,-1968.8534,-1902.9845,-1781.5868,-2259.8586,-2019.6233,-1973.9022,-2025.1965,-1991.0654,-1902.0426,-2095.0505,-2049.9563,-1975.1914,-2251.1108,-2944.5596,-2152.328,-1852.9192,-1855.568,-1921.8164,-1961.4147,-2086.4336,-2036.1317,-2028.2365,-2082.3901,-2342.3203,-2351.2026,-1968.0848,-2096.7317,-2176.5645,-1815.8961,-1866.6245,-1844.4603,-2455.7727,-1268.2014,-1439.6735,1735.4725,1514.9462,1294.927,1084.4463,910.40265,771.2477,608.54224,520.2404,375.77982,132.79404,36.847828,-70.94016,-210.67227,-364.6862,-488.68747,-601.37286,-695.7853,-780.5223,-844.993,-839.6698,-862.72205,-820.7183,-305.7827,99.70447,167.00589,202.1152,225.66031,227.20836,262.74615,266.9261,155.33548,103.845,74.1972,-13.076631,-129.03847,-189.3341,-228.8906,-274.2172,-349.9857,-437.56567,-458.11517,-507.0459,-506.27957,-641.14386,-745.09094,-593.618,-93.35644,-0.78765,-58.866913,-25.761618,-201.42908,-365.97693,-865.41644,-700.01086,-1175.3444,-1120.6135,-1175.8475,-1516.0789,-1716.4457,-1886.7814,-2209.795,-2323.5635,-2478.218,-2635.713,-2608.476,-2643.2837,-2642.6262,-2824.7666,-2650.7104,-2948.3894,-3803.6401,-3802.9714,-3945.8145,-3909.776,-3770.0718,-3812.6199,-3504.2822,-2759.5852,-2498.1223,-3402.0112,-3868.7341,-3672.0369,-2513.491,-2868.272,-3014.6628,-2529.867,-2630.6116,-3031.8203,-3451.2537,-3289.472,-2849.551,-2422.9888,-2253.0742,-2258.4329,-2094.6917,-1888.7107,-1897.4116,-2377.6328,-2145.3425,-2071.0747,-1992.5698,-2000.5681,-1930.8473,-2096.7864,-2040.1664,-2006.3098,-2173.5894,-2802.8704,-2063.3801,-1743.3077,-1852.9725,-1792.8439,-1957.1732,-2464.135,-1966.434,-2087.884,-2006.643,-1867.5314,-1805.1781,-1907.1663,-1936.6891,-1978.3966,-1591.0588,-1824.7509,-1751.6571,-1687.066,-1429.9741,-1538.0127,1690.8671,1473.3129,1243.7328,1026.2454,842.5937,699.5434,572.2301,418.54614,262.8146,84.9808,-1.74456,-70.28188,-196.23834,-343.3504,-468.788,-597.608,-674.31573,-767.26263,-794.0119,-801.4959,-823.8429,-826.1062,-239.77454,119.86044,149.91411,188.23337,171.39575,162.40228,171.29169,171.99623,112.66555,44.621525,-63.805504,-125.256935,-163.24605,-243.96542,-285.12793,-328.26163,-412.7643,-538.76074,-594.4302,-535.35504,-521.5579,-667.0318,-766.78687,-723.70526,-458.09375,-506.91965,-375.91205,-440.66614,-348.5091,-1094.3911,-926.13727,-975.96814,-1202.3129,-1464.6732,-1546.815,-1631.7888,-1753.1548,-1939.1415,-2451.4553,-2593.0188,-2638.2705,-2740.4556,-2769.9563,-2821.2283,-2852.242,-3071.0017,-2744.9744,-3280.1377,-3866.322,-3575.089,-3882.039,-3911.637,-3628.491,-3755.585,-3141.3625,-2712.8174,-3280.7986,-3385.3013,-3543.4617,-3760.014,-3279.6223,-2244.1887,-2456.7644,-2504.613,-2955.2136,-3455.393,-3361.9204,-2922.5447,-3133.5154,-2527.8428,-2315.9626,-2184.2053,-2063.864,-1937.1478,-1640.7925,-2542.2625,-1717.7095,-1871.424,-1780.9066,-1711.6112,-1853.4623,-1921.2272,-2036.7302,-1995.7461,-1936.3137,-1884.9163,-1921.6177,-1895.3219,-1913.5316,-1894.9766,-1939.525,-1965.0533,-1992.4338,-2044.1565,-1980.7257,-2125.8772,-1859.1653,-1865.7504,-1863.5981,-1858.0309,-1836.3003,-1615.8275,-1644.3289,-1506.2803,-1656.3413,-1482.579,1468.8304,1313.9915,1135.4739,929.6096,771.0322,622.1347,516.7878,409.95972,246.8747,68.880936,-24.560076,-103.938416,-194.07936,-291.78598,-369.59406,-658.9405,-698.81915,-753.5991,-773.26935,-794.44214,-813.1869,-792.2512,-246.37479,139.3069,155.05489,184.4588,161.26897,145.86029,109.5877,89.83725,41.08414,-36.832455,-118.26477,-159.6159,-193.35872,-273.55347,-370.10193,-389.6258,-436.72504,-505.0134,-522.6187,-566.9233,-536.7359,-619.94507,-742.6901,-734.7249,-715.5018,-736.33057,-478.09564,-1208.3401,-546.74243,-958.56885,-847.001,-1104.4551,-1309.8511,-1382.3398,-1654.8871,-2169.1116,-2703.9492,-2370.6206,-2608.1536,-2735.861,-2850.3787,-2861.1394,-2913.166,-2916.6738,-2979.326,-3035.4521,-3019.486,-3629.3289,-3885.0056,-3687.5393,-3882.3035,-3919.155,-3841.6084,-3845.0044,-3043.298,-2750.2449,-3345.7983,-3282.0178,-2703.4358,-3445.4883,-2671.622,-2555.72,-2580.898,-2795.2002,-3461.0586,-3471.6199,-3117.4087,-2680.0518,-2647.8948,-2596.9128,-2117.0833,-1853.3193,-2010.3472,-2104.8135,-1631.0616,-1839.7822,-1950.329,-2048.077,-1579.317,-1772.7133,-1827.4053,-1892.28,-1973.7747,-1974.2793,-2011.019,-2211.111,-1943.3644,-1968.6853,-2000.1647,-1915.6887,-1881.7615,-1819.6608,-1889.7375,-1867.0714,-2904.3247,-3274.643,-1961.457,-1759.1752,-1876.5853,-2375.2422,-3097.091,-1957.7388,-1590.9669,-1512.8713,-1670.3757,-1316.5281,1202.9438,1108.4918,995.0536,872.18427,692.90204,543.21454,413.6422,317.93808,233.39241,75.83338,-38.421673,-107.71438,-178.74858,-250.34016,-423.64163,-669.4409,-727.9614,-783.6241,-806.9968,-805.6005,-814.9104,-680.03406,-395.332,-298.60452,127.2577,174.49606,141.33327,101.4519,63.482635,16.536066,-19.628355,-101.352455,-140.2087,-215.21689,-301.24786,-344.4439,-366.6083,-419.815,-478.63287,-518.6865,-566.6447,-566.85547,-571.1107,-597.3689,-722.0319,-712.52563,-679.6704,-746.11615,-761.933,-527.6106,-555.22595,-651.4966,-967.7308,-1267.5183,-1499.8346,-1664.8654,-2042.3357,-2550.961,-2476.0881,-2611.8406,-2753.211,-2910.0327,-2953.354,-2997.909,-2974.4912,-3008.7346,-3096.683,-3109.0752,-3324.4634,-3711.5989,-3795.7542,-3817.1882,-3922.4514,-3831.345,-3619.6133,-3330.9768,-3223.7134,-2912.905,-2838.6128,-3298.1765,-2720.2708,-2739.372,-2533.2917,-2656.211,-2615.6387,-3359.6309,-3571.139,-3256.2837,-2802.1326,-2505.2336,-2543.0508,-2633.946,-2505.5378,-2174.032,-2304.9387,-2287.2778,-2028.1145,-1832.1033,-3109.4143,-3273.534,-1524.8923,-1949.7417,-1957.8472,-1945.9772,-1939.2955,-1949.2953,-1867.5004,-1922.1989,-1773.2809,-1908.7225,-2012.2275,-1912.6226,-2108.87,-3263.0618,-2010.2903,-1766.0283,-2380.6099,-2818.5007,-1958.8743,-1827.8273,-1870.9346,-2078.0962,-2935.9734,-1861.8308,-1549.4052,-1636.9347,-2306.4211,-1274.6788,1052.7129,976.14777,895.2962,804.86163,665.1358,513.9292,365.29758,242.49179,152.4086,42.823544,-38.67304,-97.748276,-169.99265,-235.87154,-451.7849,-620.1063,-714.85297,-770.6445,-786.7157,-811.11,-829.66986,-708.8429,-426.503,-358.3834,47.9192,192.64226,114.33238,91.0511,23.420818,-31.286316,-93.28352,-143.9084,-184.75507,-246.58824,-333.71637,-382.0423,-431.38943,-471.85422,-543.13434,-568.07635,-614.3267,-603.54865,-590.00574,-649.3969,-704.0384,-749.8318,-669.70276,-669.95166,-891.9206,-742.48035,-652.1941,-840.7713,-1125.6836,-1333.8416,-1759.5812,-2085.6887,-2369.384,-2557.804,-2707.8594,-2812.6047,-2862.43,-2998.767,-2981.9612,-3015.7253,-3041.829,-3049.9297,-3138.8066,-3165.0579,-3633.5088,-3713.0156,-3851.5337,-3833.5603,-3930.436,-3871.0518,-3673.222,-3036.9631,-3558.5735,-3334.2688,-3542.0437,-3244.3914,-3148.1348,-2766.6821,-2650.6748,-2833.9263,-3222.337,-3612.091,-3397.2998,-2823.0178,-2510.4624,-2366.558,-2502.905,-2597.8162,-2750.052,-2621.9912,-2681.7932,-2324.3423,-2329.663,-1907.7489,-2083.3142,-2118.257,-1654.8518,-2041.1022,-2393.4065,-1844.2367,-1820.9838,-1745.5981,-1683.4723,-1583.6373,-1981.446,-1705.3041,-1863.2135,-2022.6305,-2063.8323,-2785.7593,-1871.1233,-1907.4679,-1815.7161,-1816.9036,-1830.6252,-1906.9601,-1912.7489,-1721.9413,-1644.3342,-1709.0953,-1631.8745,-1626.6268,-2049.403,-1632.6714,1078.8284,895.61914,774.9582,689.67236,598.28015,512.53674,359.59094,232.52235,115.99384,57.095856,-8.726642,-83.66924,-142.75461,-229.86424,-459.5087,-575.173,-691.3484,-754.4673,-772.9812,-792.03687,-818.9571,-804.8375,-501.46158,-344.46365,-202.70177,37.4468,107.660965,85.212746,15.936566,-75.57112,-129.77232,-169.82669,-222.22147,-283.39725,-381.59665,-448.698,-524.4672,-498.7765,-564.2727,-606.6451,-594.55774,-607.14636,-613.2186,-667.3546,-740.4461,-811.47986,-632.925,-437.85324,-889.798,-575.35876,-630.1955,-838.9301,-1231.82,-1950.6558,-2468.057,-2484.8892,-2616.1816,-2705.1282,-2770.178,-2861.8665,-2929.1514,-3001.1162,-3013.222,-3055.474,-3127.2979,-3120.403,-3112.6448,-3343.739,-3748.3525,-3705.55,-3720.2363,-3562.1592,-3900.4177,-4010.0657,-3880.3777,-3141.7822,-3740.988,-3560.579,-3536.7368,-3203.5103,-3017.926,-2861.064,-2840.618,-3285.1924,-3608.485,-3509.2874,-2968.9856,-2567.3545,-2508.4382,-2851.634,-2201.3472,-2559.9421,-2541.873,-2577.9683,-2518.0173,-2568.6995,-3062.4807,-2330.1052,-1961.6906,-1766.5513,-2729.3584,-1920.0544,-1907.5673,-1943.4348,-1853.0262,-1583.8477,-1299.8691,-2004.1277,-3039.0432,-2021.6531,-1770.5037,-2012.1017,-1930.1179,-1824.5419,-1883.8456,-1909.5753,-1941.7487,-1870.6436,-1867.4979,-1904.0487,-1894.6483,-1861.3352,-1773.8374,-1814.1453,-1734.75,-1883.9778,-1635.812,-1886.9055,1050.6538,843.1168,710.089,600.3074,512.9881,430.02512,338.97797,207.14217,90.27485,-0.737925,-92.65873,-152.81183,-162.23564,-229.32408,-418.62476,-506.63455,-647.75,-742.1786,-783.9705,-795.8274,-778.9222,-815.13794,-653.42084,-41.97309,252.28854,85.32489,48.596302,16.759987,-16.1823,-98.91059,-157.65828,-232.33957,-251.22803,-330.89798,-394.7167,-459.5246,-529.65405,-536.0939,-594.6247,-611.33545,-605.17487,-627.9056,-649.65497,-692.27673,-751.5727,-857.5397,-790.5382,-806.6709,-893.1402,-753.3943,-1205.3662,-574.695,-1208.106,-2033.1261,-2384.28,-2567.0276,-2645.4976,-2738.627,-2844.8281,-2910.3784,-2957.9912,-2988.3037,-3038.8735,-3113.1892,-3182.6448,-3201.305,-3209.4534,-3549.865,-3665.096,-3624.1877,-3397.418,-3734.9739,-3776.7693,-3861.766,-3754.2332,-3589.2944,-3725.5078,-3338.5027,-3560.3635,-3269.1506,-2922.0498,-3179.9866,-3474.9214,-3604.1904,-3538.7393,-3112.9727,-2663.8943,-2573.8726,-2613.9385,-3179.4055,-2414.076,-2591.7708,-2497.1292,-2547.4565,-2536.0815,-2979.024,-2652.8057,-2258.5417,-2127.024,-2137.9465,-1864.2593,-1959.5305,-1880.3394,-1849.8707,-1651.0732,-1754.6692,-1401.6877,-2089.08,-3438.1453,-3599.8367,-2570.3699,-1961.5613,-1954.031,-1880.3291,-1906.0577,-1991.1442,-2153.85,-1842.957,-1868.4414,-1784.0342,-1715.6715,-1830.0818,-1837.9752,-1723.3882,-1709.8798,-1769.19,-1763.194,-1688.1189,1009.5625,826.6651,680.1588,519.1596,416.518,365.1292,293.87024,189.14757,64.06272,-51.589497,-128.94777,-183.70866,-214.36368,-245.83641,-358.92987,-435.9177,-651.15295,-734.94275,-800.55054,-814.91144,-784.2411,-901.0166,-787.9224,-38.187202,287.2686,46.382244,130.16768,52.53843,-31.775728,-102.156425,-175.06822,-259.78656,-272.62558,-353.97842,-442.54715,-461.21722,-526.45435,-564.5238,-596.8176,-620.78125,-605.2679,-648.27216,-763.83606,-725.40063,-759.8976,-872.5401,-904.6946,-990.0225,-946.4727,-806.8329,-941.92505,-1237.029,-1938.273,-2348.444,-2427.8198,-2544.499,-2697.4158,-2817.6274,-2944.2935,-2978.5176,-3025.2397,-3078.541,-3096.8225,-3204.5327,-3261.2356,-3309.722,-3342.6118,-3639.6494,-3700.614,-3549.4849,-3658.9902,-3693.692,-3725.5024,-3699.7827,-3482.2231,-3646.165,-3686.3079,-3582.841,-3261.6282,-3111.822,-3204.3972,-3523.0505,-3630.2292,-3557.1729,-3275.7112,-2889.309,-2685.2375,-2720.6814,-2668.1833,-2694.7788,-2679.201,-2750.3076,-2619.8381,-2551.7722,-2634.2673,-2653.8577,-2411.301,-2376.3518,-2281.6926,-2173.695,-2065.938,-1955.0289,-1918.2788,-2397.9863,-2709.1455,-2736.839,-2382.8452,-2479.9094,-3548.1794,-3661.8428,-2920.531,-1901.9697,-1865.3041,-1791.2947,-1873.1656,-2046.8076,-2031.2103,-1837.1013,-1728.038,-1909.2249,-2708.0586,-2029.5065,-1874.7628,-2052.4346,-1791.9338,-1908.8387,-2041.0226,-1796.309,1027.0281,807.9593,660.0548,541.06775,419.51212,327.45453,219.59889,133.37128,38.220497,-33.27308,-101.68673,-178.68155,-241.16068,-273.79208,-326.4936,-373.2719,-655.8761,-809.7059,-846.0722,-840.04456,-729.86334,-917.1046,-609.78485,126.12545,220.89276,177.10582,140.68861,45.421337,-25.864866,-127.38158,-206.09424,-280.42438,-322.71545,-403.92798,-440.16818,-483.1513,-541.32605,-581.519,-575.1048,-603.77954,-605.2332,-647.1902,-675.691,-719.9443,-758.39575,-826.91437,-930.001,-1129.513,-1205.7673,-1116.9193,-1149.1329,-1790.0981,-2162.3613,-2408.3528,-2434.0496,-2516.5845,-2704.9436,-2861.4688,-3053.5002,-3083.0813,-3140.8423,-3186.081,-3247.1982,-3344.6577,-3361.5898,-3471.0576,-3556.5962,-3719.59,-3703.408,-3657.7527,-3753.4583,-3449.1743,-3661.8818,-3758.4976,-3613.7207,-3671.0715,-3726.5066,-3720.0493,-3352.9556,-3445.9023,-3519.4563,-3505.0073,-3607.8008,-3461.9675,-3074.6152,-2991.58,-2967.9365,-2773.825,-2758.9104,-2706.5613,-2798.8506,-2910.57,-2707.862,-2738.5981,-2692.8394,-2755.783,-2525.1416,-2364.8064,-2338.6763,-2151.6416,-2051.5764,-2050.8218,-1767.7968,-1680.9365,-1742.6353,-2572.094,-2194.3657,-1847.0486,-3029.5127,-3148.7278,-2149.6953,-1870.3325,-2004.0027,-1989.6863,-1914.5624,-1910.7811,-1936.2363,-1950.7626,-1822.7441,-2748.8784,-3721.4075,-3149.1763,-1854.3469,-2258.7375,-1848.5695,-2131.9126,-2630.2498,-1853.6072,1143.6511,866.2443,683.0786,551.3358,437.3447,305.11798,167.88434,65.0209,-39.164207,-98.76972,-125.2281,-184.74063,-255.52422,-304.26898,-321.88852,-374.72046,-597.5232,-856.1,-874.73413,-863.2318,-674.8778,-718.4119,-835.1984,117.069496,400.591,222.39519,161.89766,82.51147,26.195612,-198.15462,-314.7067,-280.11972,-346.95898,-440.03793,-491.53,-483.25546,-536.57263,-580.6592,-590.6625,-602.6354,-615.696,-644.8832,-700.1079,-735.89844,-746.7,-804.458,-862.8114,-1008.43744,-1147.9257,-1408.0063,-1604.8975,-2025.7728,-2278.366,-2413.648,-2502.341,-2574.5444,-2783.2756,-2939.1877,-3130.3308,-3184.4644,-3228.7712,-3430.3376,-3403.9382,-3495.196,-3440.4033,-3613.2827,-3704.1675,-3734.1921,-3710.3892,-3654.362,-3772.3853,-3474.8047,-3658.5884,-3774.5024,-3595.1128,-3683.7747,-3748.7136,-3733.815,-3624.9893,-3585.625,-3496.365,-3355.867,-3595.4624,-3470.5059,-3172.8699,-3024.2986,-2847.0408,-2921.0469,-2875.8484,-2855.4482,-2925.295,-2957.3606,-2882.9272,-2852.6592,-2838.928,-2687.7336,-2680.6724,-2425.59,-2240.0488,-2184.516,-2097.558,-1982.3923,-2027.075,-2160.6614,-1520.374,-1542.927,-1533.9244,-1628.283,-1752.1165,-1961.0884,-1826.3754,-1801.6293,-1935.455,-1957.7874,-1971.8676,-2175.6912,-1964.1855,-1949.9205,-1837.3285,-2040.0312,-2943.7683,-2175.1028,-1793.39,-1840.6504,-1942.3406,-1897.85,-1863.6455,-1999.9972,1248.4307,975.5676,688.9346,543.226,420.99255,246.98495,126.50171,8.36553,-80.49268,-154.92856,-196.74315,-222.50056,-254.30661,-310.7377,-335.89395,-344.8038,-496.33008,-887.1505,-901.09766,-868.7082,-651.70184,-394.74854,-1425.7474,-724.7383,-53.604897,122.98751,253.03966,136.43588,48.311886,-57.117325,-163.67572,-289.16272,-382.81256,-453.21973,-485.2318,-459.8232,-537.7138,-561.7666,-618.964,-633.774,-618.5753,-659.48834,-728.6337,-715.59625,-715.7376,-840.9191,-897.3887,-952.9073,-1216.3972,-1434.547,-1549.9512,-2398.4233,-2419.519,-2487.5586,-2594.3674,-2725.1782,-2940.0837,-3047.3752,-3188.965,-3292.3987,-3348.7124,-3508.4512,-3549.6846,-3587.582,-3841.7854,-3904.7734,-3737.663,-3765.2341,-3732.7998,-3735.2578,-3734.7734,-3581.1484,-3792.484,-3776.609,-3718.2056,-3719.757,-3702.1606,-3731.094,-3697.0698,-3601.2976,-3540.1248,-3521.7026,-3560.8413,-3491.6255,-3274.5134,-3072.005,-2980.4395,-3022.933,-3021.235,-2945.6846,-2977.298,-3001.5474,-3098.6658,-2910.547,-2750.2983,-2573.3662,-2454.2231,-2325.4143,-2226.9128,-2152.403,-2076.613,-1966.0917,-2247.196,-2485.2356,-1788.6991,-1825.8495,-2410.5012,-2240.594,-2275.381,-2058.8328,-1808.4388,-2088.3032,-2731.2278,-2018.54,-1915.3202,-1935.3339,-1858.5262,-1912.7423,-1900.7236,-1718.3367,-2203.4614,-1731.563,-1768.5399,-1917.274,-1990.2921,-1972.4406,-1936.663,-2017.505,1333.6667,1047.8098,733.4058,453.0501,333.81552,245.87268,142.12225,2.411563,-100.72119,-187.52054,-243.73071,-270.6636,-279.4645,-330.90155,-352.6952,-419.59473,-522.5612,-814.5061,-944.0355,-878.00305,-657.8074,-624.16864,-1088.6227,-1100.784,-254.4728,90.34517,269.7878,127.380844,30.737669,-54.867123,-131.46153,-242.54756,-324.02393,-380.74048,-422.94653,-451.02676,-493.39102,-571.6321,-602.4401,-614.8159,-595.47797,-690.27783,-722.548,-872.371,-896.5665,-829.2377,-888.9492,-1027.4855,-1281.7354,-1703.3121,-2135.9258,-2354.587,-2490.3748,-2667.5112,-2783.7625,-2896.495,-3044.8567,-3147.274,-3292.4724,-3433.121,-3471.207,-3555.1873,-3606.5613,-3608.8425,-3605.0698,-3738.6526,-3740.4106,-3767.4658,-3746.2722,-3750.8765,-3668.694,-3716.7273,-3831.035,-3774.9111,-3764.8503,-3735.4888,-3775.3362,-3753.2278,-3725.9104,-3724.7307,-3656.0884,-3603.3054,-3559.755,-3563.4846,-3320.5325,-3182.949,-3109.9434,-3079.737,-3089.4421,-3036.9485,-3115.2615,-3078.463,-3103.127,-2975.4475,-3154.961,-2726.4048,-2442.448,-2465.2786,-2437.2024,-2238.0366,-2141.1807,-2118.3135,-2009.2625,-1923.6632,-2209.3643,-2350.4204,-2569.156,-2494.7227,-2243.3408,-2140.4043,-1946.6589,-3238.5913,-3653.9143,-2240.325,-1766.8721,-1783.4076,-1826.9172,-1847.2333,-1995.7517,-1644.261,-1737.3915,-1802.362,-2209.9016,-2017.4188,-2225.0583,-2094.718,-2001.964,-2025.1752,1349.3899,1122.3844,823.96796,504.30917,308.53784,228.82573,131.20671,55.97798,-29.376286,-121.25065,-211.08383,-264.24738,-310.29205,-355.43585,-371.04147,-434.4436,-525.2476,-651.32623,-920.4132,-969.3614,-761.01135,-592.0531,-924.6522,-1255.5665,61.34804,239.48802,280.93317,105.54915,41.977753,-17.716537,-88.907104,-169.14505,-217.46692,-312.2551,-375.86118,-408.89868,-470.04855,-537.1575,-560.85223,-587.6706,-573.89746,-714.31586,-739.38715,-677.2113,-855.42114,-849.7002,-875.9453,-868.2784,-1399.0846,-1870.8485,-2194.8083,-2373.8457,-2522.7717,-2640.972,-2771.6594,-3038.7114,-3112.6677,-3305.9033,-3347.6633,-3504.7534,-3531.1438,-3588.3582,-3649.8718,-3622.841,-3694.1426,-3772.8206,-3788.5173,-3777.2214,-3796.001,-3806.4802,-3742.2043,-3815.7754,-3804.6223,-3769.582,-3821.8408,-3772.474,-3762.2698,-3751.624,-3733.3003,-3767.5847,-3758.9604,-3632.3118,-3564.9453,-3585.967,-3295.0247,-3158.541,-3197.9155,-3119.4907,-3176.612,-3194.9897,-3212.7312,-3181.1077,-3119.143,-3000.213,-2899.6694,-2780.229,-2752.1418,-2479.6147,-2608.2522,-2367.821,-2218.827,-2117.529,-1922.021,-1935.5873,-1718.151,-1683.1208,-2234.703,-2414.5696,-2238.5068,-2158.2283,-1963.6997,-2214.4097,-2194.1506,-1534.5645,-2464.8994,-2292.4214,-1557.3073,-1962.9537,-2148.8032,-1691.7,-1775.7635,-2062.7698,-2066.8054,-2041.4783,-2218.3618,-2101.4622,-1984.8188,-2077.1875,1351.8738,1131.068,857.92535,592.53613,351.04446,241.41057,128.72162,50.577065,-21.610857,-106.90333,-175.81818,-240.34291,-302.75507,-347.36432,-325.8254,-411.18048,-514.6351,-565.77484,-804.4094,-987.61597,-947.28467,-677.189,-911.2557,-1704.5519,-310.20215,421.12128,329.6436,135.2665,4.004236,-42.780903,-63.929337,-88.39146,-179.38853,-245.80675,-328.91074,-342.23166,-402.66644,-469.75095,-456.42358,-538.82074,-544.9455,-634.95667,-708.4041,-752.28864,-819.7179,-852.6232,-969.72705,-1046.8197,-1545.0177,-1948.0692,-2189.6238,-2309.0164,-2464.091,-2695.4873,-2880.145,-3052.8652,-3209.066,-3419.661,-3575.3218,-3541.9438,-3558.8306,-3625.953,-3670.125,-3634.6824,-3732.4915,-3791.923,-3809.0586,-3794.7495,-3803.8567,-3809.0269,-3796.2842,-3799.5598,-3811.072,-3807.4546,-3839.2197,-3771.9507,-3749.307,-3721.8179,-3746.4688,-3730.5142,-3760.0242,-3714.9558,-3575.6853,-3558.593,-3284.2642,-3194.938,-3283.5784,-3176.9448,-3262.799,-3246.0386,-3267.4495,-3243.4766,-3145.6543,-3312.026,-2893.316,-2996.8455,-2648.7097,-2757.7039,-2553.2014,-2422.345,-2377.8354,-2069.9407,-1857.7318,-1666.6342,-1611.1195,-1751.46,-2359.845,-2134.7656,-2185.0256,-2136.2493,-2065.4084,-2157.8564,-1499.9639,-1480.6892,-2090.2441,-2110.1418,-1655.4851,-1618.6118,-1633.8915,-1771.8922,-1809.0292,-1901.8602,-2024.4509,-1981.8281,-2004.1111,-2084.6907,-1924.3593,-2141.178,1336.817,1090.7214,837.31555,502.1731,-423.85715,-300.29028,156.1869,50.86153,12.082429,-23.610521,-79.10389,-144.88364,-208.78127,-228.55205,-171.01318,-225.50775,-426.24213,-540.948,-647.5414,-890.3528,-1062.8397,-971.72095,-916.6626,-1121.7661,-1122.9337,-741.647,-220.439,84.51569,12.598581,-22.970005,-74.28282,-44.250675,-125.45239,-191.8619,-294.74866,-318.84692,-366.3985,-415.1428,-396.79697,-486.82172,-493.03653,-789.2699,-634.53687,-745.86194,-796.19696,-726.3325,-976.21,-1059.2186,-1455.9673,-2101.4075,-2155.3806,-2312.5142,-2508.2175,-2688.9827,-2828.715,-2960.2478,-3194.4993,-3483.3655,-3625.975,-3580.5198,-3618.2175,-3678.6292,-3688.7139,-3704.2197,-3763.4824,-3818.2134,-3822.55,-3829.4038,-3824.994,-3828.3303,-3848.6472,-3815.1475,-3839.964,-3759.8464,-3834.3306,-3660.5286,-3641.2737,-3671.0632,-3679.134,-3666.0635,-3726.0244,-3799.1912,-3638.1714,-3581.3066,-3302.5388,-3292.2112,-3381.7686,-3304.635,-3267.5603,-3297.1362,-3411.4033,-3412.082,-3271.8308,-3248.398,-3039.5874,-3536.099,-2756.6968,-2568.4712,-2562.0847,-2382.5366,-2299.3293,-2202.0535,-2860.2607,-1992.9116,-1780.3491,-2163.6372,-2354.2573,-2187.4136,-2154.602,-2057.3103,-1769.3661,-1651.2313,-1679.6088,-1662.9226,-2214.932,-3151.9883,-3304.3032,-2298.6973,-1693.5669,-1816.0581,-1957.1641,-1933.6501,-1971.7452,-1946.8208,-2055.367,-2100.2227,-2120.9062,-2101.8906,1261.1891,1037.4733,830.13586,434.8942,-675.5832,-806.4015,217.85345,123.46481,66.60015,43.025677,4.123449,-54.80428,-115.11625,-95.39362,-28.545551,-211.2455,-302.57684,-362.24167,-534.60156,-666.571,-965.93835,-1132.5272,-1237.0146,-1559.1683,-1705.3406,-1950.3186,-1677.0995,-1273.394,-495.20825,-31.774698,-72.025894,-59.62319,-127.30666,-182.99583,-411.2662,-361.52432,-666.1414,-391.1603,-408.5285,-439.52753,-480.77414,-543.2262,-586.99567,-667.5841,-780.0069,-543.80084,-886.0864,-955.67303,-1498.6542,-1936.5237,-2141.9238,-2314.1592,-2509.2917,-2691.032,-2835.8333,-2959.2856,-3189.3538,-3444.673,-3604.6416,-3609.3496,-3647.4465,-3728.7,-3712.7812,-3709.33,-3798.0154,-3822.9363,-3841.8083,-3859.7085,-3830.927,-3843.5027,-3839.0825,-3832.1926,-3827.4326,-3696.8245,-3805.938,-3719.627,-3632.273,-3620.6147,-3563.7427,-3541.3738,-3722.8948,-3836.8835,-3780.8713,-3628.6428,-3329.9636,-3380.923,-3488.2222,-3407.6763,-3331.2256,-3412.373,-3471.3994,-3527.9956,-3499.775,-3391.0688,-3795.0288,-4976.5386,-3511.7917,-3271.5742,-2506.0195,-2637.5352,-2001.0344,-2134.408,-1998.4731,-1989.203,-1992.6051,-2325.5168,-2140.9436,-1999.4066,-2209.5908,-2103.2422,-1856.8127,-1754.89,-1739.4863,-1743.7474,-3098.0298,-3796.6262,-3515.0193,-2649.3154,-1522.6088,-1812.2787,-1972.7128,-1928.6648,-1980.5928,-1899.867,-2016.0166,-2113.7336,-2280.7256,-2128.396,1191.9167,950.53827,804.72534,681.13495,456.8283,359.56906,334.5825,239.13438,194.55452,146.46088,65.76653,-13.082353,-47.94116,-18.222227,-45.23676,-184.68916,-235.97597,-308.2356,-358.16492,-456.092,-689.9739,-919.3873,-1179.451,-1314.5068,-1207.3165,-1406.0005,-1673.7968,-1735.2301,-1257.8762,-1309.4775,-1296.9258,-1490.1488,-1758.856,-1653.2881,-1707.5964,-2043.9471,-1792.6515,-1518.2046,-850.3739,-412.57892,-493.51614,-568.8611,-581.6959,-623.46423,-682.4796,-677.2994,-704.12177,-851.1708,-1535.1802,-1986.5242,-2136.0063,-2316.8223,-2501.9485,-2682.1335,-2848.4146,-2962.515,-3165.8628,-3459.0745,-3592.5662,-3623.8164,-3659.7031,-3739.4604,-3719.5815,-3745.0608,-3826.2659,-3843.4885,-3839.818,-3868.9956,-3842.699,-3859.2678,-3824.2808,-3860.9998,-3812.8435,-3785.3582,-3866.6367,-3778.6572,-3672.1184,-3624.5417,-3585.4292,-3723.5466,-3631.8032,-3851.6375,-3729.5327,-3713.2266,-3416.657,-3494.3381,-3513.591,-3527.8801,-3484.7356,-3552.1592,-3559.2747,-3592.359,-3572.5854,-3443.8901,-3467.3875,-3897.7302,-3315.3936,-3116.1057,-2770.2346,-2276.3381,-2220.82,-2588.4558,-2441.123,-2275.731,-2157.9192,-2230.3599,-1991.1398,-2063.4216,-2169.3208,-2058.5046,-1888.1492,-1798.7771,-1716.1606,-1707.9971,-2477.2688,-3581.6465,-3295.0098,-2386.0454,-1886.8596,-1974.3562,-1966.8118,-1974.7941,-1966.5831,-1987.898,-1964.644,-2006.6581,-2047.1548,-2088.6846,1205.3966,851.23724,710.0519,616.72864,536.29517,395.646,341.7862,283.05215,258.48267,202.95232,127.97744,39.75885,-22.97254,-15.300613,-106.3131,-149.06744,-190.37212,-240.33246,-291.8603,-279.2268,-394.3103,-667.6007,-859.0672,-1244.9614,-900.5062,-707.3567,-725.3449,-436.54437,-123.84056,-108.09861,-293.1333,-366.56815,-782.29395,-891.2134,-1251.3015,-2506.8694,-2482.4424,-2333.5647,-2331.6355,-1679.4711,-1735.4475,-1586.7035,-1550.073,-1192.8844,-741.2311,-476.09872,-572.2803,-802.1579,-1568.0752,-2032.121,-2152.592,-2329.8203,-2510.702,-2665.2346,-2872.8625,-2980.5422,-3199.3367,-3472.6907,-3563.926,-3616.3813,-3672.1606,-3744.2832,-3727.0847,-3768.5774,-3836.5837,-3861.0627,-3844.8079,-3866.0537,-3869.5208,-3882.2598,-3890.9248,-3868.2305,-3826.6704,-3837.6816,-3909.5945,-3839.973,-3745.263,-3717.527,-3660.684,-4433.6494,-3763.9136,-3842.815,-3819.1768,-3757.7473,-3624.0303,-3653.2192,-3544.0874,-3552.531,-3574.1577,-3602.5295,-3664.8933,-3641.9897,-3566.0935,-3627.469,-3669.956,-3219.713,-2989.2922,-3017.4373,-3854.2568,-3519.1665,-2641.154,-2631.5808,-2242.5261,-2020.6907,-2102.451,-1804.7133,-2071.4917,-2625.0256,-2022.5204,-1967.5508,-1910.4966,-1872.7023,-1774.2886,-1830.538,-1778.466,-2062.4368,-2021.2925,-1904.5758,-1974.3141,-2119.435,-2076.777,-2069.5315,-1985.0319,-2017.81,-1998.9424,-2233.9656,-1730.0891,-1890.2551,1228.5299,806.35156,666.06903,582.4952,498.50735,421.27274,371.15845,333.4955,283.98468,253.47401,182.8161,94.41934,8.768287,17.338408,-47.899063,-120.57433,-176.12096,-198.73424,-251.61223,-244.9566,-271.7025,-460.6704,-698.8998,-1086.5538,-898.43616,-391.02457,-396.5925,-255.16673,-67.14629,-31.933302,-167.88626,-168.8939,-489.43942,-342.99588,-109.56926,-555.7154,-1633.7437,-1828.6664,-1122.9025,-1610.3815,-2581.608,-2658.5002,-2496.6655,-2124.451,-1131.9337,-769.4954,-540.73724,-918.495,-1736.9702,-2038.5172,-2247.97,-2444.235,-2633.3074,-2780.597,-2958.219,-3160.9856,-3329.3926,-3521.3525,-3645.9226,-3711.1626,-3695.4958,-3769.3674,-3746.0967,-3787.698,-3853.0461,-3857.3381,-3853.569,-3888.815,-3883.2188,-3922.611,-3908.3684,-3886.0,-3857.3267,-3848.8567,-3903.6948,-3929.9482,-3850.4106,-3764.3093,-3604.7163,-3666.4326,-3603.6375,-3782.6733,-3759.4888,-3801.7097,-3668.665,-3618.2612,-3613.7297,-3637.7317,-3621.1865,-3681.216,-3723.2214,-3702.9573,-3652.089,-3740.026,-3737.611,-3621.1658,-3230.155,-3162.8613,-3943.6797,-3493.4805,-2562.96,-2765.253,-2397.4766,-2389.6404,-1980.8282,-1901.0774,-2128.7144,-2319.1455,-1948.5214,-2008.1835,-1907.8588,-2226.2087,-2587.129,-2140.2336,-2189.807,-2020.7021,-2073.4104,-2111.7354,-2168.2192,-2145.3735,-2153.1982,-2115.947,-2089.8516,-1983.4468,-2291.4417,-3412.767,-1697.2908,-2000.6423,1212.3619,820.00146,646.27563,555.2036,462.07516,408.33643,375.20123,341.45673,326.99182,277.31058,209.40915,138.8109,89.22185,137.0609,240.93692,138.78937,-59.825066,-201.476,-238.83423,-214.29646,-263.84314,-351.3475,-499.90823,-923.7932,-770.76483,90.04706,-19.974024,-87.96353,-81.76715,-86.48966,-113.39909,-131.37854,-210.77448,-206.99243,-118.61709,-119.91639,-422.61108,-1313.6858,-2183.706,-2207.9114,-2483.1729,-2675.091,-3050.341,-2673.9543,-1073.7644,-858.88025,-977.19934,-1311.1649,-2121.0286,-2008.9159,-2547.4036,-2785.985,-3068.5828,-3120.015,-3281.4053,-3416.6677,-3564.6262,-3669.5508,-3704.5815,-3732.9216,-3747.207,-3802.4153,-3788.8757,-3807.9978,-3861.1995,-3857.6555,-3859.119,-3895.9963,-3893.6125,-3927.5854,-3908.707,-3904.6301,-3889.0005,-3856.9417,-3884.6968,-3922.1375,-3917.745,-3839.176,-3682.172,-3624.1624,-3726.953,-3765.8738,-3527.267,-3727.345,-3802.9604,-3724.7646,-3687.1377,-3688.044,-3666.3545,-3700.8455,-3725.6118,-3704.114,-3755.196,-3811.4277,-3848.5693,-3653.4353,-3388.8252,-3187.6848,-3274.3613,-3000.6084,-2899.3308,-3066.8647,-2482.9736,-2128.7546,-2208.34,-2078.2295,-1917.9406,-1936.0211,-2119.4397,-2276.3262,-2055.3708,-2561.9453,-2881.9734,-2030.1742,-2161.5498,-2182.464,-2226.6548,-2306.188,-2242.4314,-2164.3293,-2142.5579,-2168.8523,-2150.6528,-2107.826,-2031.2269,-2262.7827,-1851.0317,-2036.2734,1133.1484,807.2334,654.885,531.02783,459.9356,414.35287,365.5327,336.7044,321.25064,296.40353,234.46014,180.11931,223.4056,339.4764,481.01935,608.6555,572.5562,166.43867,112.8839,-128.79004,-154.79416,25.825941,-439.97852,-797.5422,-1173.3987,-574.35675,-373.62216,-229.26198,-183.10913,-176.83026,-162.41878,-157.75723,-206.56932,-247.87746,-211.76422,-850.1822,-391.2087,-1180.333,-2027.9299,-2256.9824,-2806.2363,-3171.9092,-3314.8225,-3410.9746,-3084.3738,-2074.1038,-1887.9348,-1546.2715,-1848.4655,-2547.9663,-2515.1946,-3115.9224,-3212.1648,-3374.7712,-3450.1316,-3542.4766,-3686.7886,-3720.3235,-3749.865,-3776.6077,-3801.7075,-3821.337,-3812.328,-3793.0752,-3856.6536,-3871.6965,-3879.7693,-3911.8887,-3908.1255,-3911.7056,-3904.5127,-3916.1055,-3900.6619,-3867.3894,-3886.6375,-3903.381,-3943.5886,-3928.4314,-3801.6284,-3712.6133,-3824.549,-3741.9321,-3569.6772,-3573.361,-3840.967,-3856.4666,-3735.2666,-3718.5466,-3710.6292,-3677.977,-3703.5593,-3726.3599,-3781.464,-3823.8955,-3881.572,-3842.1226,-3844.322,-3321.0647,-3287.379,-3158.0996,-3225.8064,-3211.906,-2493.9055,-2330.4277,-2347.1362,-2328.3965,-2149.4607,-2117.4944,-2312.638,-2348.4558,-2204.1953,-2202.8616,-2085.5366,-2124.587,-2247.5776,-2313.2642,-2079.304,-2181.9985,-2243.2085,-2180.6516,-2195.1729,-2244.709,-2149.0735,-2211.5332,-2118.9324,-2003.8015,-2012.3242,-2126.9685,1106.7477,811.4442,672.89935,575.4308,489.58502,426.973,343.60068,380.1674,363.87686,326.54327,279.54047,264.53128,340.0257,456.9647,590.3986,671.3406,728.7457,761.5519,674.30707,415.69827,195.69478,-318.2254,-281.15887,-630.1311,-1219.0173,-1325.6014,-1415.5309,-1424.8528,-1273.6409,-583.2826,-306.83505,-202.18803,-205.37093,-238.22427,-596.0093,-1237.3995,-1834.5413,-2419.9094,-2525.2166,-2528.5066,-2537.6016,-2500.2402,-2266.9832,-2048.4707,-2429.415,-2617.9106,-3033.1821,-2944.3567,-3181.4973,-3239.775,-3419.373,-3423.5713,-3260.784,-3272.5142,-3354.602,-3528.7266,-3654.426,-3717.936,-3756.0217,-3780.9194,-3788.9417,-3765.441,-3781.2273,-3892.3567,-3860.1843,-3863.1252,-3899.8657,-3932.8083,-3936.3088,-3927.7812,-3910.553,-3893.1453,-3960.0967,-3845.9255,-3904.833,-3834.9844,-3894.3682,-3962.7527,-3898.304,-3841.003,-3834.489,-3732.307,-3729.4065,-3640.4355,-3793.8513,-3906.4854,-3826.0374,-3753.0247,-3716.9365,-3694.2798,-3758.9849,-3756.4717,-3759.1702,-3800.213,-3877.2524,-3901.2979,-3848.0916,-3773.445,-3813.6382,-3619.4648,-3470.4905,-3162.7803,-2634.6035,-2751.208,-2504.4092,-2516.0347,-2389.3096,-2498.0742,-2402.0325,-2481.4028,-2833.1458,-2498.4492,-2384.797,-2335.6504,-2301.274,-2554.1848,-2586.292,-2150.6533,-2164.7803,-2099.582,-2144.7263,-2103.5151,-2358.8909,-2231.026,-2166.5776,-2141.619,-2133.3,-2183.4497,1106.4062,844.9041,718.89795,649.0408,531.4121,457.8434,443.15292,434.92944,416.45853,372.73853,337.43546,430.82968,521.9414,597.55316,728.33813,792.5177,801.46,766.94324,715.9108,702.3664,355.00134,-500.29926,-591.2263,-652.94257,-793.8315,-1157.988,-1242.5822,-1166.4326,-1312.0852,-1904.241,-1476.3251,-1138.7979,-1355.1992,-1736.9052,-2190.6963,-2097.7935,-2043.939,-2160.5164,-2398.0583,-2661.5337,-2721.2134,-2378.6667,-559.6268,-1735.865,-2847.6775,-1987.6754,-1553.1638,-2754.9187,-3271.2046,-3412.1658,-3551.566,-3596.4731,-3611.6372,-3635.6963,-3606.3564,-3729.649,-3667.4539,-3718.4023,-3750.7795,-3773.883,-3755.6511,-3786.4778,-3792.6345,-3809.5151,-3846.2942,-3876.1226,-3903.3154,-3919.161,-3935.5542,-3920.7,-3955.2925,-3892.444,-3909.8054,-3837.623,-3893.1743,-3898.1,-3849.6777,-3917.3005,-3974.0403,-3892.8628,-3825.1338,-3712.6812,-3664.7817,-3650.3452,-3743.56,-3895.477,-3875.2659,-3774.5967,-3733.669,-3749.6687,-3771.1936,-3810.4407,-3793.0505,-3793.844,-3888.1575,-3906.9832,-3858.4504,-3868.1436,-3833.7632,-3655.2056,-3219.845,-3192.188,-2572.558,-2886.7766,-2717.7234,-2697.441,-2523.4775,-2474.536,-2522.145,-2659.906,-2596.0024,-2648.0984,-2587.7148,-2374.2668,-2347.686,-2300.062,-2300.4827,-2162.952,-2068.5513,-2036.0532,-2034.3444,-1976.1925,-2147.8667,-2222.2026,-2230.8982,-2223.6294,-2201.186,-2104.636,1132.7627,906.2698,783.7733,666.8775,549.1959,464.3896,434.66464,415.5778,422.9711,371.56055,416.23242,634.74304,787.3699,771.8551,812.63983,907.01385,813.6497,737.2131,629.8485,456.70667,-130.245,-564.7168,-659.30505,-707.69586,-721.4402,-636.18536,-954.3759,-1248.624,-1286.3624,-1404.6577,-1737.0332,-1845.9358,-1771.3972,-1732.349,-1688.1744,-1695.5206,-1782.6082,-1883.2347,-2004.3762,-2262.4805,-2646.5645,-2746.3594,-1364.9521,-1377.4427,-2085.6516,-1171.4358,-652.4692,-1394.1356,-2349.864,-3195.6475,-3396.1086,-3486.9456,-3604.0417,-3616.039,-3630.806,-3513.62,-3552.2002,-3671.5881,-3720.948,-3718.7886,-3710.2124,-3769.9265,-3770.5945,-3798.1848,-3818.9968,-3855.324,-3910.1487,-3915.562,-3935.6992,-3924.918,-3887.3843,-3892.99,-3860.5762,-3886.5168,-3918.1128,-3943.6045,-3929.8042,-3887.8267,-3962.0325,-4002.3777,-3907.549,-3802.7634,-3781.5852,-3721.1174,-3764.0068,-3872.6045,-3898.8489,-3769.2056,-3763.0537,-3764.7961,-3819.888,-3843.46,-3808.6572,-3822.2908,-3907.186,-3938.766,-3868.9836,-3916.2844,-3852.6877,-3525.6316,-3239.4019,-2989.2837,-3266.374,-3003.2395,-2904.4683,-2886.7837,-2615.7131,-2564.249,-2600.1638,-2641.1475,-2608.7273,-2713.2932,-2664.5864,-2477.2036,-2437.5635,-2379.6064,-2169.083,-2137.5256,-1936.702,-2018.5295,-1942.3733,-1948.7753,-2156.564,-2305.6064,-2289.0217,-2301.0,-2122.1086,-2107.2139,1088.9307,920.4865,790.9542,662.96674,558.34863,463.75058,425.36758,412.92877,415.9592,383.3781,482.21814,717.0804,908.4223,971.3441,922.4567,781.7423,653.448,694.4402,615.332,404.4774,140.71786,-363.43265,-725.98914,-745.13293,-757.4107,-556.34717,-669.3401,-989.6353,-1108.1844,-1202.4517,-1248.04,-1276.2089,-1316.807,-1506.0364,-1565.3053,-1674.5574,-1775.693,-1920.2377,-2006.3363,-2147.6365,-2409.4612,-2957.2332,-1966.1675,-1415.6508,-726.4628,-448.84427,-967.66516,-2107.5527,-2963.9924,-3234.856,-3445.1147,-3352.977,-3382.1594,-3417.409,-3319.3833,-2999.1199,-3195.3818,-3621.6309,-3644.5095,-3625.0632,-3685.9949,-3742.8,-3747.5999,-3787.4607,-3778.8716,-3826.923,-3908.1035,-3932.5818,-3944.9656,-3945.7207,-3867.433,-3877.4102,-3893.116,-3867.0178,-3927.3418,-3957.7837,-3962.8174,-3937.8867,-3949.7305,-3988.984,-4001.016,-3939.4531,-3903.2964,-3802.737,-3801.0415,-3862.3127,-3940.46,-3794.9792,-3831.6794,-3784.8943,-3833.4343,-3861.2427,-3828.4233,-3854.3564,-3924.9866,-3954.6062,-3897.9263,-3955.6821,-3960.8892,-3822.2917,-3602.8828,-3388.2256,-3251.154,-3136.847,-3073.7183,-3394.2925,-2783.2795,-2699.1062,-2676.5273,-2921.6558,-2783.3418,-2704.9937,-2820.5762,-2905.5508,-2573.6328,-2457.5244,-1903.0111,-2098.4287,-1917.0465,-2048.8127,-3074.0005,-2566.8965,-2094.9797,-2327.2593,-2212.9175,-2574.1357,-2342.358,-2138.31,1029.4414,891.7,747.5683,630.4016,530.9307,437.16467,387.1439,367.61697,384.99847,400.49286,487.9499,680.93304,921.62524,1036.1776,1001.50995,806.3481,643.45386,428.52795,384.66727,220.31622,456.16284,383.70984,-474.37878,-745.20355,-782.14844,-854.32855,-860.18713,-919.96606,-988.81903,-1062.1256,-1095.9618,-1134.318,-1119.6256,-1263.0723,-1535.6774,-1766.6846,-1872.8318,-1962.3699,-2046.0764,-2167.4385,-2289.0872,-2945.9429,-2629.677,-2232.3628,-2235.9204,-2303.1028,-2330.4172,-2986.5217,-3112.1812,-3367.4033,-3088.1318,-2919.2346,-3061.0674,-3107.273,-2678.7725,-2881.0654,-3268.6233,-3609.5396,-3528.4172,-3600.7856,-3639.4927,-3672.5518,-3696.3545,-3756.1802,-3714.727,-3788.4055,-3870.0742,-3921.8262,-3936.1404,-3908.1345,-3878.3054,-3880.6511,-3914.894,-3879.29,-3931.5725,-3956.41,-3962.0981,-3970.253,-3932.8943,-3960.6304,-3986.9763,-3992.4746,-4017.0305,-3917.8884,-3911.1228,-3927.4473,-3960.228,-3902.7148,-3846.753,-3818.951,-3853.2827,-3875.8235,-3873.9038,-3905.7998,-3944.316,-3968.559,-3926.713,-3981.1465,-4018.4785,-3993.1472,-3937.8345,-3619.6453,-3493.1904,-3307.027,-3170.702,-3115.0476,-2978.963,-2917.8271,-2810.892,-3020.3757,-2864.6333,-2863.378,-2913.714,-2851.4023,-2540.1252,-2355.6094,-2137.1804,-2186.0967,-1798.6525,-3166.3748,-4347.8413,-3796.2083,-2198.4956,-2265.9507,-2356.0984,-2079.4768,-2151.3442,-2381.2476,956.8998,853.98834,734.0193,589.12305,493.25128,433.8452,363.23697,339.74573,337.67035,337.96985,458.52774,695.31085,912.4587,1016.428,989.3632,744.56287,562.88257,426.5428,356.25885,340.13846,353.77127,251.22563,158.34315,-369.62747,-418.2963,-647.33685,-858.06036,-886.1911,-900.44086,-994.43726,-918.90454,-946.1704,-977.5358,-913.05554,-1505.9598,-1752.0592,-1849.5547,-1937.0189,-2028.6425,-2163.2803,-2249.903,-2504.3208,-2966.129,-3014.6685,-2922.013,-2975.0146,-3143.6575,-3297.3677,-3376.277,-3309.953,-3178.5273,-3266.7512,-3324.6394,-3245.78,-2999.7822,-3228.514,-3487.7505,-3522.0142,-3570.3523,-3518.925,-3619.506,-3670.7866,-3696.2551,-3720.9143,-3691.5366,-3756.9922,-3821.3801,-3912.6907,-3923.9407,-3913.009,-3934.5898,-3885.603,-3925.7058,-3891.1917,-3918.5234,-3967.2056,-3965.6199,-3928.6797,-3954.8574,-4000.0806,-3973.8806,-3995.002,-3988.8914,-3977.743,-4008.1675,-3973.4617,-3992.3662,-3942.4307,-3918.9353,-3863.5962,-3880.5962,-3920.408,-3944.7544,-3945.6174,-3964.7292,-3978.5806,-3923.9712,-3988.7207,-4033.913,-3920.4968,-3961.5332,-3767.8416,-3585.0413,-3366.6655,-3263.8262,-3129.696,-3165.5034,-3137.667,-3013.649,-3108.1277,-3195.2776,-3252.0457,-3023.7085,-2633.2295,-2409.1155,-2387.549,-2378.24,-2341.149,-2038.5713,-2702.8003,-3081.3203,-2452.7698,-2207.542,-2385.2913,-2325.7617,-2258.4858,-2446.7234,-2523.9773,898.29364,813.6264,726.0336,605.0673,450.3049,396.85736,317.28873,287.18298,284.5844,283.22836,455.36658,730.0268,948.8316,946.61896,822.78265,602.56665,409.03278,356.43887,367.57437,373.00436,341.99384,182.35522,105.66369,155.07452,-22.47148,-134.17294,-788.64844,-690.1236,-576.0952,-713.3998,-625.8218,-684.1232,-741.92804,-792.53644,-1089.9686,-1525.673,-1760.9042,-1921.5156,-2008.3502,-2147.4263,-2238.9197,-2311.1187,-2497.0022,-2714.8386,-2844.0635,-3006.9402,-2916.5486,-2974.4954,-2972.9739,-3016.9763,-3109.5688,-3188.5374,-3161.3696,-3290.5764,-3445.1821,-3539.4429,-3567.0144,-3494.6714,-3589.0527,-3603.063,-3572.1665,-3632.6042,-3658.634,-3679.4734,-3675.6013,-3690.6077,-3772.946,-3880.8433,-3911.3303,-3845.9785,-3929.2668,-3933.0657,-3955.5623,-3923.9675,-3901.512,-3978.895,-3950.568,-3942.9897,-3985.0942,-3988.9124,-3998.8628,-3946.056,-3984.6855,-4035.6372,-4067.9734,-4056.1125,-4014.7466,-3983.2712,-3963.3833,-3899.3867,-3922.865,-3936.363,-3950.2341,-3967.78,-3995.5872,-3981.4236,-3945.7385,-4017.5708,-4027.97,-3817.1694,-4042.571,-3835.88,-3845.1453,-3548.4512,-3375.069,-3292.052,-3379.7593,-3304.6736,-3111.1902,-3227.5305,-3473.101,-3405.573,-2987.5432,-2647.3398,-2515.789,-2502.7446,-2503.684,-2415.8147,-2170.4783,-2119.4944,-2008.8075,-1990.2101,-2252.216,-2396.3777,-2411.5615,-2382.3787,-2485.0796,-2614.911,850.4362,779.9802,690.31775,637.6438,541.0976,516.7932,365.89594,272.9174,396.24692,440.78134,563.3,811.99207,1149.8312,971.6149,756.3344,493.8547,328.47052,316.84424,333.8841,329.65164,296.3307,215.26889,103.12742,31.978481,108.68893,-19.159481,-312.45938,-352.14767,-407.58658,-513.4494,-536.2867,-660.3952,-718.67834,-729.8027,-821.2882,-1114.054,-2362.2632,-1923.977,-1928.551,-2178.8518,-2281.7878,-2331.009,-2314.8862,-2039.9102,-2103.9705,-2524.577,-2682.6484,-2572.5046,-2581.3215,-2902.256,-2942.9038,-3075.5852,-3041.1042,-3298.3325,-3356.0354,-3345.2107,-3364.6895,-3391.758,-3490.7297,-3555.917,-3573.6016,-3634.092,-3650.115,-3685.5315,-3689.8674,-3701.718,-3736.836,-3812.7048,-3882.951,-3900.3655,-3912.1921,-3920.4695,-3976.6204,-3981.2627,-3930.2651,-3969.6523,-3965.487,-3968.5159,-4008.3713,-3989.275,-4028.833,-3959.587,-3947.522,-4015.9387,-4082.3613,-4106.478,-4080.9185,-4017.8604,-3968.4482,-3949.315,-3965.0645,-3961.9792,-3987.7312,-3990.7112,-4030.6406,-3978.6667,-3972.0967,-3977.9736,-4025.2227,-3955.6782,-3987.493,-3898.4412,-3886.936,-3876.7847,-3888.242,-3746.2078,-3543.2578,-3600.391,-3523.7344,-3402.6333,-3451.941,-3302.0225,-3182.2551,-2910.138,-3072.1611,-2576.6003,-2522.5522,-2486.7625,-2403.5837,-2363.867,-2094.2415,-2087.6414,-2336.987,-2305.4321,-2375.8313,-2509.5134,-2482.6506,-2586.1533,810.83716,755.5752,729.1684,757.30115,680.58746,704.1205,572.44617,565.7576,732.44666,729.97797,859.53595,1164.1147,1239.7101,975.275,751.28577,442.91205,299.99704,270.0212,263.46152,258.7489,213.88318,170.81255,110.69267,-5.654964,-26.904726,-61.367783,-182.71837,-268.30844,-421.16013,-539.85095,-521.9521,-590.1373,-673.95856,-834.80414,-911.0355,-873.0486,-1009.7006,-943.2703,-1474.579,-2009.1549,-1943.5457,-1932.9436,-1442.2526,-800.32996,-724.6318,-1259.5353,-1749.1289,-1775.1412,-1977.5907,-2796.002,-3047.7424,-3060.3118,-3137.8948,-3274.3962,-3308.9644,-3249.4658,-3466.427,-3468.3127,-3560.2346,-3565.9705,-3606.5693,-3639.613,-3661.7053,-3676.6343,-3696.1694,-3721.9182,-3724.6655,-3755.8928,-3817.7776,-3862.9805,-3916.4065,-3945.1582,-3948.4233,-3961.2197,-3978.337,-4017.82,-4009.4216,-4013.6104,-4033.4626,-4042.392,-4048.0027,-4038.6667,-3989.7878,-4007.1672,-4075.9243,-4146.681,-4152.391,-4107.733,-4031.3325,-3982.3237,-3980.5825,-4000.486,-4017.8713,-4045.3396,-4068.3396,-3987.825,-3998.9385,-3976.5657,-4002.1748,-4018.89,-3987.1714,-3973.5066,-3985.1328,-3987.0088,-3939.731,-3879.8364,-3666.3872,-3494.178,-3852.5293,-3419.224,-3334.5708,-3228.8726,-3114.8938,-2965.812,-2809.3303,-2690.4695,-2624.198,-2545.849,-2572.422,-2857.092,-2685.0664,-2616.3892,-2594.649,-2340.1814,-2606.5618,-2676.6433,-2535.5024,-2493.9185,822.28326,758.876,779.97943,932.7578,886.81885,822.9778,885.35394,1039.5859,823.66254,816.61847,825.72833,965.0102,1062.341,864.2014,620.0083,413.66367,324.0697,254.88692,191.48183,167.77754,140.54878,96.10975,91.245575,43.29899,-44.823666,-160.68317,-265.0114,-338.95007,-511.9047,-648.617,-722.5708,-794.36475,-890.7045,-881.25793,-1003.5371,-1049.6322,-922.39154,-870.5321,-928.1194,-908.5877,-1032.6437,-873.0544,-818.95874,-810.88855,-1019.708,-1001.9776,-857.82056,-1057.5126,-1434.4518,-2012.2067,-2320.956,-3131.6257,-3227.179,-3257.4395,-3326.057,-3399.607,-3543.5894,-3576.0598,-3574.1748,-3610.6802,-3650.3184,-3660.4246,-3682.7944,-3689.7737,-3714.2441,-3732.9258,-3723.0632,-3760.1177,-3803.4595,-3819.6785,-3903.8127,-3942.1372,-3897.7085,-3939.0464,-4001.3018,-4034.3042,-4027.7632,-4049.8013,-4061.113,-4062.9583,-4085.0593,-4094.4924,-4098.8584,-4090.2139,-4081.994,-4141.9604,-4176.7275,-4173.965,-4113.54,-4049.9788,-4013.2373,-4053.3843,-4089.1672,-4091.7378,-4091.7117,-4010.7769,-4021.0127,-4018.1577,-3963.2854,-4056.9165,-4078.645,-4078.462,-4051.377,-4003.5989,-4010.2192,-3930.5173,-3777.632,-3504.35,-3343.8728,-3502.5754,-3519.577,-3277.461,-3163.7249,-3102.5715,-3081.6802,-2947.92,-2705.8396,-2610.7356,-2504.3933,-2563.5205,-2583.0833,-2384.7273,-2163.3914,-2213.484,-2528.1484,-2404.5383,-2285.6067,-2261.7102,949.10144,834.55524,837.4443,809.6964,782.4799,783.74384,831.18555,806.11786,835.1458,1044.0763,1085.5004,998.5717,989.14307,746.5314,564.9819,449.88922,358.38934,209.13046,116.96001,86.453964,95.034836,95.697014,148.7385,165.01152,160.73083,28.445286,-133.20079,-351.75665,-591.4141,-719.7208,-806.71075,-882.61115,-984.3014,-989.77905,-1104.7134,-1072.2239,-990.9284,-965.83405,-1040.6538,-1051.117,-1110.7604,-1089.9922,-1043.4507,-1041.8835,-1068.3558,-1103.3217,-1082.2399,-936.81287,-1332.5354,-1895.7133,-2409.1418,-3225.1667,-3065.457,-3157.1562,-3148.1125,-3278.4468,-3499.3784,-3561.0938,-3581.6748,-3629.859,-3652.516,-3682.9724,-3702.5422,-3701.1328,-3739.2634,-3750.1335,-3746.688,-3740.4275,-3823.963,-3815.8086,-3884.1184,-3935.8228,-3948.311,-3947.8477,-4043.6848,-4080.5986,-4038.9407,-4084.433,-4090.0496,-4070.3792,-4111.474,-4096.7554,-4255.499,-4104.261,-4132.065,-4158.446,-4175.974,-4206.612,-4167.7817,-4131.092,-4105.798,-4129.7905,-4152.6787,-4124.7925,-4155.006,-4071.5317,-4076.0242,-4056.7021,-3995.4167,-4082.5159,-4125.47,-4131.8867,-4100.382,-4084.8445,-4060.9434,-3987.9634,-3905.2302,-3793.2798,-3729.334,-3495.6663,-3536.6604,-3861.9224,-3271.273,-3201.7434,-3054.963,-2905.9219,-2816.618,-2741.9363,-2590.4956,-2465.8042,-2461.044,-2362.514,-2741.6697,-2765.818,-2530.271,-2367.4143,-2605.3582,-2408.055,1228.548,1008.1829,856.4255,828.81525,716.8352,600.4543,586.56995,547.6196,621.3649,924.799,1257.1263,1169.1334,1015.7614,754.50494,600.46326,496.22488,242.78221,152.46466,53.46585,2.356835,24.721998,154.95033,276.13123,354.84555,337.80612,170.12155,-27.365467,-326.2946,-555.10504,-759.37537,-888.0692,-987.91815,-1029.5427,-1089.4138,-1181.5198,-1115.414,-1082.8903,-1124.9397,-1184.9858,-1193.3387,-1220.7627,-1210.4496,-1185.6746,-1213.7733,-1218.7443,-1212.3004,-1084.5604,-986.933,-1150.8448,-1631.7012,-2325.8076,-3259.5159,-3200.2388,-3222.0107,-3376.2134,-3458.7117,-3535.8613,-3556.8674,-3569.6387,-3626.4026,-3645.2996,-3681.542,-3697.5322,-3675.7969,-3705.047,-3770.7961,-3780.7014,-3740.9067,-3832.7156,-3822.877,-3793.1743,-3854.6594,-3941.0718,-3997.3115,-4162.3726,-4192.802,-4080.138,-4101.9907,-4104.395,-4105.4365,-4112.137,-4097.5503,-4141.24,-4099.031,-4171.8765,-4189.2734,-4206.5317,-4204.621,-4198.6323,-4178.994,-4143.7666,-4182.0737,-4192.8716,-4185.7666,-4189.3745,-4162.48,-4134.549,-4088.725,-4064.777,-4040.1125,-4151.179,-4161.0938,-4125.6304,-4094.0327,-4099.7744,-4021.2656,-3947.0366,-4014.8303,-3757.7744,-3591.6711,-3608.2866,-4493.4985,-3968.9875,-3494.2378,-3057.1838,-2957.5725,-3012.053,-2809.793,-2591.4792,-2559.5671,-2778.1106,-2446.6697,-2969.9526,-2976.9702,-2793.4797,-2487.9243,-2164.2893,-2434.4607,1455.0535,1209.2615,1008.7382,782.7939,659.95184,549.72876,398.42065,433.15567,522.2766,769.36884,1081.5946,1161.2358,1011.67847,791.2744,602.18384,530.89197,333.70538,179.88528,173.00087,202.01575,302.8869,493.6616,533.7094,371.1495,360.9775,160.12862,-9.251504,-277.23532,-545.813,-755.6876,-890.0681,-1002.8438,-1070.6246,-1151.1893,-1187.6469,-1264.4797,-1182.4395,-1209.9669,-1254.8325,-1284.5945,-1305.6937,-1272.45,-1314.8359,-1319.0157,-1289.0878,-1236.79,-1121.0165,-1326.0941,-1332.842,-1624.3584,-2425.3838,-3047.8733,-3267.5457,-3355.8022,-3362.607,-3496.4832,-3536.6528,-3570.5708,-3588.3953,-3620.621,-3657.597,-3695.91,-3699.0503,-3672.7578,-3696.517,-3760.3416,-3777.6868,-3761.863,-3811.0654,-3843.8362,-3861.3584,-3825.5,-3933.6519,-4005.541,-4133.415,-4164.3247,-4055.496,-4061.129,-4096.9614,-4129.2603,-4118.1,-4144.0073,-4139.2095,-4154.8438,-4184.607,-4215.048,-4235.5513,-4223.655,-4220.7285,-4214.4707,-4217.836,-4248.4893,-4250.8677,-4226.3687,-4230.216,-4199.769,-4195.2544,-4156.5005,-4087.6418,-4076.804,-4172.588,-4187.4033,-4149.603,-4117.1846,-4133.9707,-4090.5464,-4079.9053,-4045.0974,-3713.6711,-3707.3013,-3436.5347,-3636.8564,-3687.6897,-3456.325,-3286.1958,-3022.112,-3142.1226,-2874.2559,-3174.543,-2949.4004,-2906.331,-2650.515,-2754.4666,-2775.871,-2923.6094,-2982.659,-2233.8828,-2227.5679,1340.2814,1355.8069,1096.2937,869.2001,595.69775,491.36255,589.8958,468.6397,538.1313,647.86865,865.63745,1002.9526,908.8689,767.6304,640.76135,465.3077,510.72116,670.3477,683.42505,800.9353,837.4835,801.8904,766.846,701.51306,506.1538,169.88669,54.056267,-178.57521,-470.0437,-732.03375,-884.72485,-1002.05286,-1059.5397,-1115.3954,-1184.3269,-1262.375,-1295.1996,-1268.0312,-1286.7352,-1318.3805,-1319.6787,-1346.5411,-1338.3527,-1341.9047,-1311.4802,-1219.7345,-1234.3896,-1382.5471,-1598.7821,-1847.3754,-2544.8418,-2845.2798,-3288.2139,-3376.7856,-3456.8865,-3538.1484,-3535.034,-3586.4727,-3612.2412,-3621.2368,-3659.517,-3684.3333,-3694.7358,-3676.4175,-3698.1807,-3759.482,-3770.6196,-3772.793,-3781.7773,-3842.5984,-3905.0544,-3893.457,-3948.0476,-3995.949,-4031.0283,-4062.505,-4075.6953,-4055.82,-4049.9436,-4113.6885,-4155.3916,-4189.2256,-4177.0293,-4172.0405,-4177.875,-4222.664,-4248.4316,-4263.619,-4267.5874,-4226.264,-4260.3467,-4295.499,-4306.6924,-4260.7163,-4252.606,-4228.439,-4227.5425,-4180.9443,-4114.5264,-4129.2026,-4191.1323,-4187.537,-4118.863,-4125.49,-4148.1733,-4115.116,-4095.6343,-4073.92,-3824.301,-3926.6133,-3681.2627,-3525.6094,-3536.458,-3571.3784,-3253.7598,-3233.9128,-3350.6956,-3133.5571,-3180.634,-3279.0151,-3114.6562,-3127.1104,-2987.173,-2845.0635,-2720.8066,-2689.5054,-3182.6414,-3065.4075,1196.5608,1141.0631,1121.3755,1004.8521,759.5588,511.27188,571.8799,718.5372,664.0218,712.1694,658.19293,511.45825,704.8882,662.3903,518.4048,489.61108,555.8379,980.6208,1149.2515,1088.303,967.3436,944.0113,946.9817,985.54645,887.4948,393.00558,309.6126,121.068146,-295.45447,-646.7297,-859.0067,-965.24506,-1046.1445,-1093.5631,-1197.5435,-1248.1837,-1271.3053,-1283.7781,-1302.7832,-1317.3551,-1282.2906,-1285.3882,-1323.5822,-1341.1929,-1272.8502,-1163.1337,-1172.431,-1304.0643,-1655.7217,-2102.1318,-2539.445,-2854.1836,-3243.8567,-3274.2708,-3378.8264,-3524.3813,-3560.0693,-3573.543,-3606.7148,-3627.5867,-3636.0574,-3756.7153,-3661.2986,-3671.432,-3717.9817,-3746.6995,-3771.0747,-3807.8154,-3820.221,-4080.103,-3914.255,-3938.3162,-3960.7183,-3988.4246,-4032.1162,-4026.456,-4082.3372,-4105.353,-4074.3862,-4132.946,-4175.881,-4206.681,-4213.683,-4172.0415,-4181.754,-4238.6797,-4275.029,-4303.9746,-4290.078,-4242.674,-4283.5293,-4319.362,-4325.3467,-4271.2715,-4293.9326,-4269.1826,-4304.426,-4217.497,-4166.043,-4236.584,-4249.812,-4219.1304,-4154.432,-4154.461,-4135.065,-4134.8843,-4133.2,-4087.2527,-3993.8193,-3823.1082,-3770.5051,-3895.9219,-3800.2463,-3473.1487,-3249.7876,-3550.9343,-3539.6216,-3479.8274,-3551.818,-3506.492,-3349.7896,-3170.0366,-3145.1995,-3120.5981,-2997.351,-2835.109,-3387.4631,-3065.9033,975.6664,998.69183,1011.53595,950.5408,941.42035,818.94965,735.92206,634.4886,634.4363,625.2659,492.15237,201.45782,190.01907,488.1131,607.452,681.3983,738.6701,825.2773,1068.7571,1130.6818,1039.571,986.1493,1077.6417,1184.5588,1232.1226,975.07477,593.3417,481.09814,69.754845,-388.5426,-752.33026,-916.76556,-1164.9093,-1099.9884,-1149.359,-1229.7452,-1250.2887,-1292.204,-1198.8119,-1230.4453,-1180.0096,-987.91516,-1091.3788,-1181.0587,-1168.941,-1113.821,-1109.245,-1231.3114,-1836.4164,-2093.5417,-2517.2078,-2921.8218,-3253.695,-3362.1313,-3440.9453,-3461.8628,-3495.3733,-3517.5208,-3600.8923,-3625.5632,-3650.2495,-3656.349,-3688.2495,-3684.3184,-3710.3171,-3732.0283,-3784.6404,-3833.599,-3834.6143,-3863.3313,-3914.5562,-3930.4702,-3973.854,-4000.6582,-4026.3606,-4069.6028,-4100.9556,-4097.4077,-4104.2065,-4151.946,-4197.3633,-4211.915,-4229.883,-4233.82,-4244.7676,-4280.4575,-4293.1646,-4317.672,-4354.1323,-4314.0557,-4320.286,-4340.421,-4324.6206,-4303.765,-4334.7344,-4310.885,-4278.743,-4253.287,-4241.711,-4294.409,-4293.2173,-4233.2583,-4187.58,-4203.7812,-4192.721,-4186.8022,-4167.9067,-4194.9565,-4081.4014,-3986.8665,-3917.579,-3955.4412,-3897.7107,-3763.336,-3896.7402,-3815.143,-3678.573,-3675.0413,-3746.2957,-3561.1028,-3429.8582,-3170.345,-3285.6729,-3104.0554,-3111.7893,-3490.713,-3956.3396,-3118.622,943.2846,973.26245,1035.2838,954.169,696.3056,1160.0393,832.6737,616.4452,518.0433,380.26428,244.99504,-9.305062,-51.022156,72.93741,590.28326,719.6971,858.3682,798.22797,921.4655,1313.1049,1140.506,1114.2135,1138.7876,1206.0021,1429.678,1386.3877,983.0876,757.17737,413.0276,-78.27117,-571.9941,-885.32635,-1006.076,-1059.4324,-1085.7036,-1167.4271,-1224.5398,-1320.9469,-1357.988,-1298.8358,-1257.9447,-1001.6809,-1480.3634,-1653.9929,-1354.4619,-1443.6685,-1261.0746,-1260.5703,-2124.7122,-2170.322,-2520.8208,-2896.0999,-3182.7192,-3338.503,-3448.2598,-3461.181,-3501.7278,-3567.8916,-3616.8818,-3612.3203,-3635.9836,-3681.05,-3705.9397,-3730.621,-3729.322,-3743.0537,-3770.3713,-3840.9756,-3881.16,-3941.1907,-3929.3706,-3953.3372,-3980.1978,-4050.2173,-4050.1016,-4065.9478,-4101.961,-4094.1833,-4087.6033,-4156.623,-4205.9707,-4202.5396,-4235.8535,-4255.6846,-4283.801,-4299.4854,-4326.6836,-4321.821,-4395.475,-4390.152,-4373.5864,-4378.4487,-4365.9604,-4399.252,-4403.891,-4350.0474,-4305.9985,-4288.5293,-4324.618,-4321.5767,-4328.9736,-4262.852,-4284.6313,-4297.395,-4257.7695,-4238.458,-4226.4556,-4184.298,-4193.815,-4213.474,-4123.5728,-4061.1553,-4055.1604,-3927.4565,-3844.3538,-3855.7678,-3821.09,-3845.7217,-3823.0696,-3741.7595,-3673.0,-3336.708,-3417.3394,-3181.6318,-3489.5845,-3578.938,-3611.3914,-3274.0164,913.01105,894.22406,1008.8932,1224.9164,1009.3653,1861.761,1527.2267,817.7757,565.95386,435.829,345.39877,257.74533,43.416595,-13.84501,373.6752,686.9216,733.94586,831.7763,762.1305,934.75244,903.7629,924.49603,1072.5038,1316.1334,1283.9974,1418.2219,1211.0963,916.4905,651.93823,160.20068,-445.5692,-758.996,-884.6448,-927.5688,-1022.4186,-1099.4396,-1158.5753,-1269.0247,-1310.8513,-1322.638,-1134.0171,-983.0214,-1498.2802,-1630.6166,-1608.9762,-1631.0024,-1557.8574,-1457.9719,-1426.7728,-1769.7532,-2323.233,-2737.93,-3069.2427,-3314.7383,-3458.6716,-3520.5574,-3522.7366,-3591.804,-3624.6672,-3641.1187,-3651.2737,-3685.048,-3710.3762,-3747.3083,-3747.0908,-3762.182,-3787.9136,-3847.043,-3892.5574,-3909.4924,-3940.2341,-3999.2454,-4029.3345,-4058.9368,-4055.7627,-4087.0398,-4132.456,-4122.153,-4121.4395,-4168.814,-4216.077,-4214.4224,-4264.4062,-4295.298,-4330.8794,-4317.9883,-4346.013,-4363.929,-4401.256,-4434.851,-4401.4155,-4401.539,-4412.296,-4437.9614,-4460.9194,-4425.2905,-4393.0293,-4318.605,-4337.0273,-4355.054,-4326.4365,-4274.7817,-4325.4976,-4334.8525,-4306.31,-4252.5483,-4233.345,-4282.176,-4313.4487,-4362.4185,-4242.71,-4075.5505,-4141.365,-4021.499,-3900.034,-3866.5713,-3896.4375,-3844.5215,-3841.6956,-3738.249,-3688.9944,-3648.7004,-3494.3142,-3432.08,-3372.2986,-3315.9192,-3230.9763,-3010.4023,780.57874,797.7411,945.3601,1052.4143,1103.4344,2437.441,2127.3477,1094.2334,337.15918,590.9496,606.50977,389.8243,457.59436,261.3647,309.43387,643.072,773.6662,501.43103,991.269,1149.5135,1059.6937,1039.0133,1104.9779,1442.9984,1083.0487,1287.4752,1322.0078,979.51746,577.72034,322.6667,-228.0323,-544.4066,-774.9223,-853.9603,-947.6672,-984.17004,-1084.4512,-1208.0713,-1252.9242,-1117.7048,-920.66034,-1187.4905,-1517.1758,-1599.417,-1728.5419,-1710.9233,-1681.0135,-1700.1532,-1677.5659,-1789.4702,-2128.5066,-2599.1753,-2889.567,-3188.0078,-3460.021,-3580.877,-3575.213,-3610.4863,-3643.3896,-3639.2905,-3654.112,-3685.367,-3709.1025,-3725.1255,-3755.1821,-3799.8186,-3839.457,-3861.699,-3879.3027,-3914.4314,-3964.5613,-4025.1714,-4057.1626,-4086.189,-4075.2043,-4081.1963,-4140.7896,-4153.026,-4133.359,-4205.8535,-4260.859,-4238.9907,-4289.4033,-4335.116,-4362.902,-4345.2563,-4385.969,-4414.1133,-4421.482,-4443.087,-4403.35,-4448.5234,-4467.763,-4470.1235,-4480.9307,-4472.8794,-4455.0674,-4382.146,-4382.3755,-4401.2793,-4395.075,-4343.445,-4332.7427,-4358.6807,-4345.5103,-4344.147,-4272.2666,-4287.6123,-4328.65,-4329.878,-4250.6333,-4211.742,-4240.4224,-4085.2256,-4034.3076,-4027.3652,-4001.4167,-3919.1934,-3841.1094,-3827.0737,-3848.0918,-3811.5544,-3654.5813,-3676.1663,-3586.0127,-3428.508,-3454.951,-3179.7576,703.24176,720.72015,800.8201,791.0114,963.7302,2157.989,2164.1985,1315.4196,822.3384,723.13824,700.5633,690.90515,629.4595,578.2991,630.11316,722.9328,913.1695,796.3485,610.05286,1200.7328,1126.478,1328.0895,1468.1259,1233.2162,1346.5989,1285.9817,1160.2604,1019.64233,757.91345,412.78284,157.1126,-99.2628,-396.54373,-624.7303,-874.5726,-892.6548,-910.31335,-1012.6516,-958.80066,-861.237,-810.4289,-1040.9141,-1459.6127,-1624.8671,-1753.4855,-1653.6265,-1721.5691,-1768.0281,-1767.6088,-1833.0903,-2105.2468,-2553.4338,-2849.8604,-3096.4307,-3338.7498,-3548.8425,-3611.135,-3634.6697,-3665.84,-3640.5,-3666.202,-3683.724,-3721.975,-3704.8323,-3762.76,-3817.8562,-3829.2163,-3864.5642,-3878.5024,-3942.0342,-3986.4436,-4025.2864,-4045.4512,-4107.473,-4149.887,-4150.3887,-4147.867,-4143.535,-4155.209,-4238.2876,-4295.371,-4294.246,-4300.959,-4362.1304,-4379.3335,-4365.2124,-4423.8564,-4446.7593,-4456.2637,-4461.211,-4430.7036,-4459.375,-4507.459,-4490.376,-4486.952,-4490.2007,-4479.395,-4452.6523,-4465.159,-4465.708,-4428.682,-4362.783,-4373.2974,-4402.4985,-4416.367,-4399.944,-4322.824,-4337.287,-4352.864,-4326.2466,-4314.2646,-4295.1978,-4315.5747,-3983.7896,-4078.113,-4094.604,-4050.2039,-4012.3635,-3928.7078,-3874.8645,-3875.6353,-3805.4148,-4085.2227,-3791.8267,-3639.311,-3614.808,-3454.5432,-3265.9592,699.27905,632.021,685.9409,867.5459,987.58,1482.9303,1871.5315,1329.2776,932.7521,859.5493,794.91254,769.2231,738.24255,899.4799,922.6627,939.45123,1003.981,1128.2432,1166.339,1150.501,1056.8092,949.76056,1217.0204,1284.6206,641.9242,807.5917,957.585,945.7622,849.02936,602.7716,254.75954,-5.598641,-288.78363,-504.10217,-780.1551,-850.46466,-887.23236,-932.2325,-927.5235,-823.93964,-704.9948,-726.0786,-1090.3068,-1488.9414,-1726.7623,-1676.2848,-1781.9579,-1810.9907,-1730.8292,-1815.4572,-2079.026,-2471.251,-2987.6086,-3103.1377,-3273.1245,-3509.7354,-3630.2583,-3647.0305,-3674.5696,-3650.307,-3683.706,-3709.944,-3737.3088,-3717.999,-3711.9736,-3773.4944,-3860.1462,-3881.7249,-3893.6155,-3927.3853,-3974.3306,-4031.271,-4034.263,-4084.6426,-4149.819,-4168.3643,-4174.994,-4153.516,-4233.495,-4279.607,-4305.0796,-4314.5776,-4351.0244,-4390.5894,-4394.757,-4390.9604,-4453.1465,-4492.0063,-4506.1704,-4489.7607,-4462.1357,-4497.9834,-4540.416,-4523.78,-4521.8936,-4520.767,-4500.869,-4499.4097,-4526.735,-4516.004,-4486.1245,-4457.4204,-4453.904,-4464.824,-4483.8994,-4479.964,-4443.901,-4510.211,-4481.528,-4435.87,-4393.1895,-4413.8745,-4225.7266,-4226.5596,-4197.0137,-4173.8594,-4151.8433,-4105.8135,-4005.89,-3962.0217,-3956.96,-3826.9932,-4006.0703,-3826.4426,-3721.5173,-3772.7676,-3804.152,-3518.9263,633.9203,613.56134,591.0995,718.277,850.13135,1014.82294,1387.438,1283.6534,970.6395,892.9502,867.3051,886.8451,921.33997,952.8725,947.31036,978.64594,1015.2739,1069.4021,1179.1244,1184.6624,1166.5632,1075.2021,1281.2095,970.474,763.00244,340.9505,703.9014,740.18036,689.0231,575.6309,329.091,61.71258,-171.72781,-519.4404,-750.4046,-847.08246,-831.46814,-794.3706,-806.6421,-826.41406,-770.7197,-1094.5406,-994.1507,-1266.8531,-1544.5488,-1659.0502,-1774.8473,-1798.3344,-1704.975,-1808.316,-1982.6721,-2356.2822,-2897.7217,-3086.7893,-3257.1948,-3494.523,-3630.469,-3666.411,-3696.0403,-3664.449,-3722.8535,-3759.8235,-3752.276,-3745.4175,-3943.1855,-3759.8564,-3850.555,-3906.375,-3922.9465,-3963.6284,-4004.2532,-4038.6353,-4040.0405,-4098.2437,-4149.645,-4128.0415,-4184.672,-4202.3623,-4269.401,-4310.868,-4305.8765,-4361.2085,-4404.087,-4409.0054,-4415.421,-4445.3496,-4485.4023,-4510.553,-4527.474,-4485.1846,-4505.3413,-4537.8735,-4594.8403,-4545.4575,-4559.1543,-4532.542,-4538.8193,-4539.708,-4564.8154,-4538.772,-4507.683,-4487.1865,-4485.2417,-4510.031,-4513.568,-4435.7056,-4499.0547,-4594.209,-4593.315,-4565.601,-4485.1177,-4451.999,-4412.556,-4348.721,-4252.167,-4230.845,-4155.258,-4083.9717,-4071.5676,-4098.146,-4055.6086,-3960.4275,-3883.0952,-3824.5293,-3822.1533,-3878.4219,-3926.058,-3809.8928,628.2282,696.44434,629.35126,644.7249,985.61176,1312.9005,1209.9916,1161.0657,1352.8956,1003.4914,919.1697,1006.1544,1052.4858,1063.4672,995.0793,911.4762,890.8648,914.44696,965.7579,1024.1515,1075.29,1085.96,1194.8042,762.0392,817.12805,406.76447,539.12787,700.68726,617.4779,482.84207,240.29874,94.85908,0.561246,-270.37125,-699.28485,-923.2003,-1280.1482,-1122.6324,-878.6378,-911.9447,-942.2655,-948.3923,-1034.4404,-1146.517,-1290.2203,-1493.9496,-1691.8105,-1869.0797,-1757.1769,-1724.5537,-1832.1012,-2143.419,-2550.2073,-2846.9487,-3181.9092,-3450.5347,-3648.3286,-3703.3577,-3726.2073,-3700.9136,-3754.2688,-3787.187,-3773.5715,-3778.403,-3778.229,-3812.015,-3869.2866,-3889.7773,-3944.1538,-3999.9385,-4039.5254,-4054.3926,-4077.5706,-4137.46,-4188.9307,-4196.909,-4227.8296,-4274.6587,-4318.56,-4339.4927,-4349.434,-4382.9834,-4382.5615,-4443.6714,-4503.326,-4446.683,-4509.106,-4537.505,-4546.594,-4509.216,-4530.3726,-4553.1577,-4551.1074,-4554.734,-4564.99,-4558.122,-4587.13,-4567.432,-4568.1147,-4554.4897,-4551.8633,-4507.802,-4521.1265,-4539.6772,-4510.6255,-4456.62,-4469.74,-4509.423,-4543.691,-4556.4116,-4558.537,-4502.454,-4469.4937,-4421.918,-4398.71,-4264.684,-4217.997,-4211.9673,-4198.4395,-4184.771,-4113.375,-3985.6387,-3947.1736,-3937.8496,-3894.8945,-3942.0952,-3944.5925,-3878.7317,601.45624,683.6476,556.0869,638.09827,1439.6954,1770.2081,1561.6421,1196.9269,1190.4602,1085.4827,1060.6788,1096.5355,1053.5592,973.24866,973.3215,861.1484,807.5371,744.99817,752.77136,928.96344,1010.985,823.55225,1130.6224,789.10455,794.11566,502.04022,343.02435,689.75366,631.2168,540.04285,388.27835,350.353,87.554214,-399.8879,-642.28925,-901.83685,-1266.5725,-1088.996,-880.7716,-1050.8176,-1169.861,-1177.2869,-1167.2252,-1171.4812,-1241.7708,-1399.6871,-1506.5492,-1624.7769,-1552.423,-1598.4955,-1777.0106,-2543.2615,-2768.9175,-2637.4854,-3054.7632,-3451.1482,-3641.1052,-3718.774,-3758.2925,-3762.5117,-3800.563,-3826.797,-3827.561,-3847.766,-3867.4617,-3890.6501,-3905.2869,-3941.93,-3992.2322,-4026.152,-4085.502,-4082.8918,-4136.1504,-4203.3413,-4218.2056,-4246.5356,-4288.3716,-4339.559,-4357.6904,-4383.039,-4382.775,-4412.474,-4376.256,-4424.4385,-4561.4785,-4432.378,-4526.644,-4568.106,-4570.73,-4575.0654,-4574.396,-4561.249,-4554.2275,-4565.975,-4578.967,-4584.2104,-4603.5405,-4604.083,-4561.635,-4567.9224,-4582.9673,-4542.2935,-4552.9214,-4562.065,-4499.789,-4587.437,-4539.3896,-4497.7417,-4529.274,-4514.8755,-4538.7217,-4582.165,-4566.9595,-4516.891,-4504.228,-4307.3657,-4271.9043,-4258.784,-4232.7163,-4217.2954,-4190.9624,-4111.5356,-4056.8203,-4055.3074,-4046.056,-4027.061,-3984.8271,-3950.4468,729.35815,954.44653,819.9979,574.08527,366.41904,805.9313,1718.8512,1383.7974,1080.2617,1004.97266,1050.5751,1028.2964,1061.9692,1049.7552,938.8282,909.03375,823.69543,764.866,764.3869,852.8544,1150.1427,1338.1162,1314.9371,1049.5607,695.87787,368.806,228.92795,373.24142,505.96344,411.91104,359.2755,322.3764,131.88829,-133.53958,-377.52536,-631.604,-619.0724,-783.86847,-1099.7408,-1291.7883,-1418.6866,-1404.2551,-1417.2374,-1415.3734,-1320.9042,-1362.1926,-1452.1376,-1511.6309,-1598.0529,-1760.0969,-1884.4103,-2528.5266,-2764.7964,-2693.6233,-3106.9307,-3467.263,-3659.993,-3713.6536,-3781.7258,-3800.5244,-3840.967,-3856.5562,-3861.6323,-3905.102,-3899.003,-3916.0906,-3953.0679,-3990.6663,-4039.603,-4055.6692,-4060.472,-4125.703,-4203.769,-4259.863,-4260.1436,-4255.4434,-4338.0483,-4391.689,-4403.9287,-4395.3193,-4436.52,-4477.636,-4443.309,-4567.99,-4466.2646,-4503.136,-4556.2456,-4584.5474,-4561.078,-4603.6445,-4605.131,-4567.4663,-4551.9375,-4577.7393,-4607.67,-4619.734,-4628.397,-4623.325,-4560.381,-4582.1978,-4607.1973,-4568.455,-4587.7993,-4584.685,-4555.8525,-4492.3267,-4488.4736,-4516.087,-4521.515,-4486.0703,-4510.4062,-4591.1377,-4563.786,-4464.325,-4428.1475,-4308.0254,-4338.824,-4318.744,-4289.211,-4263.397,-4218.9575,-4173.44,-4103.109,-4084.0747,-4130.9155,-4123.352,-4013.5308,-4000.9246,95.45562,237.14912,227.98323,302.02466,312.552,666.9552,1599.3794,859.7402,744.97156,785.1841,1123.1232,888.9156,936.9736,1114.1499,1319.1724,1404.9792,1250.2168,1292.1836,1293.3271,1327.222,1379.1538,1255.0354,1041.1976,1017.27454,618.62823,234.1967,-151.69542,-58.696133,161.53633,254.37737,184.35757,102.693985,-78.72129,-272.73428,-434.9492,-584.9235,-678.4413,-898.6211,-1253.6034,-1504.5942,-1584.506,-1587.4608,-1618.9915,-1566.4252,-1532.3282,-1589.517,-1625.232,-1736.3209,-1847.5845,-2050.5808,-2192.3113,-2327.195,-2547.3042,-2892.558,-3214.7078,-3457.245,-3655.0754,-3728.253,-3791.8674,-3829.6638,-3857.6274,-3881.6677,-3884.001,-3915.9192,-3920.7988,-3944.6226,-3995.1912,-4013.2312,-4070.9578,-4051.3337,-4086.907,-4163.6543,-4262.6104,-4288.3022,-4272.6113,-4294.7104,-4375.6475,-4423.2,-4447.384,-4441.516,-4466.037,-4510.828,-4510.4097,-4501.093,-4528.626,-4527.0674,-4576.589,-4609.305,-4618.5137,-4621.525,-4620.8716,-4600.442,-4594.247,-4617.483,-4637.301,-4657.8027,-4666.771,-4647.4697,-4578.9043,-4601.821,-4641.0317,-4619.1763,-4618.757,-4605.089,-4561.32,-4574.709,-4585.8896,-4567.692,-4559.1387,-4530.955,-4518.0146,-4510.3687,-4504.2188,-4442.4863,-4408.9155,-4332.2026,-4336.153,-4350.7437,-4327.864,-4279.035,-4248.438,-4268.6084,-4220.9136,-4181.671,-4153.3047,-4167.878,-4076.6943,-4064.2737,-443.3237,-350.83545,-243.00432,-223.58243,-266.31625,-141.19756,620.4163,1529.8613,1878.0231,601.37354,468.0941,726.04126,881.2307,1061.7214,1521.3217,2060.6272,2055.92,1901.2299,1416.1407,1026.8131,704.1548,684.8257,555.7213,569.639,536.4419,243.60782,295.60532,690.16406,920.43604,729.62213,85.03993,-488.61862,-621.26263,-743.2067,-770.4214,-671.9116,-652.9264,-877.9575,-1118.7537,-1387.5729,-1558.4943,-1706.9373,-1681.4353,-1719.304,-1615.4757,-1711.0677,-1959.8298,-2070.9722,-2210.6582,-2294.2827,-2373.477,-2508.7686,-2727.465,-2961.5852,-3188.5598,-3409.698,-3575.722,-3748.018,-3814.6323,-3819.443,-3870.958,-3895.28,-3909.7432,-3932.0134,-3965.9277,-4022.6614,-4029.5635,-4050.2651,-4125.6987,-4097.8564,-4171.414,-4185.96,-4282.5913,-4329.881,-4314.3647,-4351.1323,-4404.227,-4440.1934,-4470.0386,-4489.1504,-4523.044,-4531.5884,-4521.7114,-4527.742,-4548.6987,-4554.5044,-4616.7686,-4638.567,-4638.507,-4634.617,-4685.035,-4635.6836,-4616.8076,-4643.517,-4657.965,-4663.1763,-4659.8237,-4683.361,-4635.408,-4616.141,-4636.551,-4629.7095,-4650.2246,-4634.038,-4609.749,-4615.6797,-4595.9976,-4586.2324,-4582.237,-4572.518,-4535.8896,-4509.196,-4475.7256,-4459.731,-4472.7227,-4411.4,-4300.0815,-4379.091,-4324.117,-4286.0264,-4263.954,-4288.4985,-4278.0806,-4204.8076,-4195.506,-4201.2817,-4140.1353,-4059.5486,-668.83093,-745.2412,-796.697,-807.8775,-812.6364,-802.25104,-730.0811,234.1924,1324.5875,753.0837,489.01666,648.2777,1202.9247,1123.6919,1379.2915,1433.6578,1676.4624,1689.1786,906.47705,527.24786,174.6025,304.41895,401.26648,292.62302,274.618,115.89041,160.10788,743.6014,337.93893,-51.564137,-93.87908,-685.6862,-1085.1644,-897.6607,-808.9936,-758.97833,-886.565,-943.836,-1081.3855,-1339.3556,-1545.6576,-1677.1395,-1754.5104,-1875.7477,-1843.9724,-1957.8834,-2244.7395,-2323.917,-2422.1682,-2558.651,-2724.812,-2970.3242,-2915.715,-3096.3108,-3258.2446,-3445.9246,-3598.2246,-3765.292,-3823.852,-3835.5361,-3850.9817,-3874.0405,-3943.3523,-3981.9978,-4021.057,-4054.8616,-4076.7852,-4126.068,-4141.4297,-4162.0215,-4182.5244,-4211.331,-4259.638,-4312.8164,-4365.509,-4411.911,-4425.0415,-4457.2583,-4473.4473,-4498.7646,-4539.5864,-4542.9507,-4535.0576,-4543.535,-4558.6494,-4599.837,-4643.0547,-4636.223,-4644.214,-4663.348,-4698.0625,-4679.1704,-4648.1685,-4699.905,-4718.46,-4702.8813,-4732.2456,-4758.052,-4715.6343,-4690.203,-4632.368,-4638.7134,-4683.5044,-4661.1084,-4653.121,-4641.9697,-4632.121,-4603.2393,-4607.609,-4579.415,-4545.441,-4546.643,-4503.256,-4493.2095,-4505.0415,-4482.0874,-4433.077,-4400.7456,-4435.1562,-4412.2056,-4388.7812,-4356.3433,-4356.7524,-4282.5884,-4161.006,-4175.7285,-4119.8667,-4113.2373,-845.2759,-921.9981,-941.09155,-966.34656,-1004.0209,-1005.1533,-987.7572,-770.4209,427.26334,623.7153,1647.681,1408.9506,983.2185,953.3794,1187.6877,1519.474,1546.5603,1419.034,770.1345,191.92459,-17.97842,68.92173,285.48544,209.93466,115.46239,4.032306,-221.97873,-167.34392,-391.63718,-831.3518,-1152.3254,-1178.1371,-1403.8694,-1198.7632,-870.55035,-548.93335,-869.69434,-977.937,-1090.0607,-1293.0226,-1459.9313,-1613.3347,-1764.3978,-1890.6157,-2092.471,-2158.4243,-2404.235,-2511.1958,-2611.2158,-2718.4832,-2931.2256,-3103.628,-3111.6606,-3303.491,-3434.7715,-3612.695,-3722.917,-3820.8508,-3855.2375,-3884.349,-3892.8823,-3940.4783,-3983.875,-4006.753,-4057.8677,-4085.3538,-4107.8433,-4141.1797,-4126.5483,-4174.741,-4238.8135,-4284.7593,-4310.7397,-4366.3037,-4419.897,-4440.032,-4441.337,-4468.7715,-4491.2925,-4510.3706,-4561.0923,-4579.059,-4556.9937,-4552.947,-4572.324,-4620.6064,-4643.7,-4587.529,-4528.778,-4561.248,-4657.2075,-4568.8506,-4563.942,-4753.922,-4831.729,-4798.939,-4769.786,-4735.1772,-4709.053,-4715.5474,-4676.846,-4669.033,-4690.808,-4693.055,-4674.277,-4677.681,-4659.7573,-4631.515,-4617.717,-4593.418,-4563.3735,-4539.3794,-4540.7646,-4538.8975,-4518.2334,-4534.622,-4530.788,-4500.592,-4472.478,-4480.022,-4446.1777,-4430.556,-4389.914,-4347.403,-4239.988,-4283.3706,-4222.5176,-4709.1387,-885.047,-979.0512,-989.4279,-946.8695,-953.2751,-971.35803,-975.95966,-744.9625,1015.75336,-26.424738,1390.0155,1373.9298,1293.5884,803.1868,703.81354,973.4757,1078.838,799.1291,375.4632,-270.73605,-424.61493,-537.1122,-383.1651,-129.06612,-228.61783,-346.79346,-511.28552,-852.5472,-843.59467,-1140.7198,-1180.1118,-1278.136,-1535.0038,-2067.4365,-1383.4961,-666.0487,-881.4682,-976.992,-1163.8734,-1296.2063,-1470.2997,-1646.1531,-1803.3484,-1938.5646,-2038.9711,-2184.3352,-2434.7195,-2638.2915,-2734.9658,-2866.2458,-3006.6572,-3143.0776,-3317.1511,-3469.9402,-3603.7078,-3776.3118,-3860.5674,-3870.7346,-3899.9924,-3934.625,-3949.5662,-3980.697,-4015.4116,-4024.3237,-4089.9307,-4114.6094,-4146.41,-4165.2876,-4180.463,-4212.5425,-4281.057,-4323.986,-4355.939,-4417.881,-4451.5566,-4445.014,-4457.1016,-4495.172,-4476.435,-4506.3276,-4569.025,-4577.8203,-4591.7954,-4595.361,-4581.088,-4592.762,-4575.188,-4608.2476,-4543.756,-4466.6997,-4519.863,-4367.0835,-4118.2754,-4473.416,-4742.4688,-4848.484,-4782.336,-4733.4946,-4712.036,-4725.811,-4717.6855,-4741.482,-4740.569,-4723.0557,-4720.286,-4682.3843,-4683.142,-4651.2036,-4614.198,-4628.2275,-4618.6323,-4580.0195,-4578.9277,-4571.0835,-4547.5303,-4556.3345,-4554.964,-4550.141,-4521.657,-4473.6074,-4471.598,-4465.3594,-4439.584,-4410.096,-4314.6567,-4349.9385,-4231.9736,-4433.5654,-807.5856,-910.7384,-951.2299,-913.0627,-874.4102,-836.781,-827.74036,-783.093,201.6206,348.78064,1143.7954,961.01404,1010.62134,596.39325,280.15454,283.41574,266.36615,-207.93253,-422.27512,-667.2223,-1114.3447,-1068.6914,-840.87775,-705.91565,-630.8941,-678.0494,-709.2547,-819.2096,-1247.2467,-1398.784,-1581.3988,-1458.8124,-1162.6996,-1766.5515,-2322.3337,-2156.5361,-1269.2124,-1006.7351,-1166.3356,-1318.8566,-1452.4608,-1680.2548,-1834.4106,-1975.273,-2081.5896,-2221.6626,-2407.7344,-2734.625,-2869.1765,-2998.1387,-3168.645,-3310.3499,-3491.1382,-3635.828,-3724.5627,-3780.1006,-3876.5327,-3889.7795,-3929.8364,-3971.4287,-3981.8743,-4008.7026,-4039.3376,-4067.3728,-4126.6084,-4169.846,-4202.5215,-4212.1562,-4220.277,-4264.14,-4322.906,-4369.099,-4381.5635,-4436.0625,-4464.6924,-4434.4863,-4491.4185,-4515.3843,-4497.8833,-4547.2124,-4570.2593,-4590.219,-4623.6714,-4590.694,-4587.5576,-4608.4023,-4580.073,-4542.133,-4594.2056,-4562.4883,-4525.612,-4490.6963,-4381.965,-4500.8135,-4732.16,-4759.0522,-4773.6606,-4752.179,-4724.464,-4757.4546,-4725.196,-4753.8506,-4763.143,-4746.1533,-4717.4443,-4710.8115,-4673.8906,-4642.966,-4676.3506,-4686.4927,-4658.717,-4618.7886,-4597.7744,-4573.5933,-4590.517,-4595.3364,-4601.5776,-4576.743,-4540.6475,-4514.8735,-4520.955,-4476.5684,-4449.5684,-4448.674,-4402.8706,-4351.9272,-4379.8633,-4331.6304,-717.6732,-821.14594,-821.6562,-816.7322,-808.6474,-702.4712,-601.10376,-597.66864,-446.57846,-248.55363,314.2416,565.116,666.90015,150.04341,-38.589737,-198.3709,-259.16406,-495.11404,-1897.4774,-1904.2769,-2054.3953,-1653.9207,-1368.6682,-1401.0398,-1274.3336,-1371.3416,-1660.8723,-815.4139,-1008.0388,-1325.7354,-1694.1815,-1453.865,-1140.3281,-1385.2742,-1568.8738,-2298.9731,-3110.0562,-1924.1239,-1245.8558,-1306.3906,-1510.9337,-1885.185,-2031.1666,-2019.3522,-2205.084,-2395.1477,-2788.5027,-2904.9617,-2939.5076,-3080.0999,-3266.9998,-3432.3125,-3550.387,-3724.4585,-3770.407,-3838.4326,-3883.553,-3912.4707,-3962.416,-3993.5393,-3986.4631,-4040.4924,-4110.6904,-4199.4287,-4189.5063,-4188.2744,-4205.778,-4222.1035,-4232.38,-4307.1157,-4361.9023,-4357.8813,-4369.722,-4437.5024,-4461.047,-4456.034,-4467.23,-4504.7607,-4549.2705,-4547.8965,-4519.7007,-4574.1724,-4596.416,-4594.3296,-4638.41,-4610.5513,-4608.81,-4650.8604,-4675.6875,-4678.4077,-4643.827,-4643.1494,-4524.1533,-4654.4224,-4754.263,-4756.82,-4730.106,-4686.8857,-4688.8853,-4711.4395,-4735.399,-4741.3994,-4743.958,-4753.44,-4710.0137,-4683.2534,-4663.7183,-4650.366,-4712.4697,-4708.0386,-4683.902,-4649.937,-4641.5835,-4626.084,-4598.7935,-4598.2705,-4610.292,-4592.243,-4569.84,-4535.0757,-4527.255,-4505.767,-4493.3467,-4510.9536,-4499.602,-4462.05,-4390.0493,-4370.5615,-642.2788,-694.6267,-869.63873,-727.5359,-717.1045,-680.2331,-292.12244,-134.35281,-230.84685,-736.2299,-1092.65,-735.92444,244.41837,-752.96265,-1131.6084,-1162.797,-1545.7991,-1682.5074,-2440.4202,-3014.5312,-3027.9104,-2783.0662,-2546.7322,-2301.5273,-2039.3555,-2003.3746,-2038.8717,-1529.115,-1272.0802,-1363.7263,-1535.0481,-1447.3606,-1461.4116,-1529.1644,-1690.6783,-1769.5037,-2197.5823,-2863.42,-2440.275,-1700.8088,-1609.6012,-1811.8812,-2020.9904,-2235.5483,-2490.3794,-2699.1956,-2991.2837,-3104.0498,-3164.5806,-3300.795,-3361.1912,-3427.3518,-3589.883,-3609.0183,-3661.5737,-3735.3813,-3876.8284,-3945.5366,-3996.4944,-4009.2615,-4059.1592,-4093.012,-4109.638,-4177.5947,-4206.728,-4201.8184,-4223.635,-4243.3804,-4316.4087,-4361.509,-4381.9272,-4381.685,-4416.968,-4465.9565,-4485.7915,-4474.222,-4515.2617,-4546.4814,-4562.9688,-4548.2983,-4531.866,-4616.552,-4600.924,-4625.2734,-4653.937,-4601.1963,-4596.712,-4593.376,-4709.329,-4695.2163,-4681.8706,-4565.5615,-4544.366,-4783.39,-4764.763,-4756.617,-4750.433,-4773.445,-4717.7114,-4775.543,-4798.335,-4785.21,-4748.0967,-4765.705,-4789.765,-4734.5063,-4694.5225,-4702.6577,-4701.6523,-4690.4053,-4673.4336,-4652.198,-4637.6904,-4653.4683,-4610.2944,-4623.608,-4635.2446,-4611.691,-4601.839,-4567.322,-4519.6577,-4512.1665,-4513.4272,-4553.3853,-4556.9976,-4521.9834,-4483.4233,-4468.0225,-585.7565,-681.72754,-773.86993,-748.3287,-834.487,-862.1205,-898.478,-951.73444,-1051.1985,-1410.965,-1664.7145,-1281.8484,-153.23569,-1107.9148,-2456.504,-2733.3186,-2895.3787,-2964.7844,-3047.261,-3089.7583,-3065.5232,-3099.1309,-3221.4204,-3095.8955,-2817.628,-2470.3423,-2628.113,-2337.8762,-2018.7853,-1687.8734,-1748.7788,-1737.8931,-1711.2479,-1807.7158,-1768.733,-1733.9897,-1734.8374,-1818.8077,-2233.2317,-2321.0645,-1985.7743,-2026.2281,-2248.0085,-2504.5715,-2658.476,-2848.6802,-2967.4487,-3175.5984,-3317.8147,-3430.8962,-3576.184,-3644.54,-3723.616,-3683.3262,-3870.6255,-3853.5754,-3918.113,-3980.378,-4015.27,-4022.8196,-4103.551,-4119.8833,-4149.404,-4250.982,-4273.3096,-4280.32,-4289.7363,-4326.0293,-4363.928,-4406.4873,-4420.4297,-4424.599,-4455.8843,-4511.1196,-4506.742,-4533.05,-4586.3633,-4586.352,-4589.353,-4587.0903,-4609.121,-4666.76,-4679.3716,-4649.6465,-4625.9214,-4624.609,-4634.1147,-4659.266,-4714.806,-4682.7114,-4730.758,-4680.8994,-4647.8877,-4752.5073,-4773.406,-4696.7007,-4796.978,-4794.807,-4773.008,-4758.0005,-4787.3003,-4771.271,-4758.967,-4755.3384,-4766.668,-4771.2163,-4749.746,-4762.6104,-4749.306,-4700.681,-4679.232,-4694.5244,-4686.068,-4655.4634,-4641.995,-4608.1187,-4649.324,-4632.0615,-4585.9517,-4550.7344,-4532.7256,-4524.874,-4513.1797,-4545.574,-4545.1216,-4499.4644,-4464.9473,-4484.4453,-592.08765,-694.2207,-860.34827,-1023.4527,-1104.7743,-1159.9408,-1274.4834,-1438.7719,-1713.2722,-1943.7502,-2050.882,-2018.6399,-2459.2498,-2570.7927,-2739.5073,-2916.3918,-3044.041,-3118.8276,-3173.9414,-3183.9548,-3161.8708,-3106.748,-3333.2788,-3283.8694,-3294.8225,-3342.8691,-3181.0686,-3080.777,-2792.401,-2540.788,-1986.2468,-1808.5588,-1750.7554,-1938.5126,-1963.8281,-1787.6664,-1721.2115,-1788.9249,-1772.5819,-1909.4773,-2428.403,-3052.295,-2842.9243,-2759.2563,-2859.0278,-2986.5256,-3139.8452,-3291.2563,-3403.088,-3504.5044,-3630.6687,-3769.0588,-3842.506,-3880.7395,-3969.7466,-3940.8225,-3962.5886,-4015.3943,-4047.1948,-4078.439,-4074.9607,-4120.6294,-4178.846,-4265.831,-4316.196,-4345.025,-4337.468,-4385.714,-4435.1123,-4444.2065,-4468.3,-4474.7114,-4497.2095,-4526.3354,-4533.3345,-4577.496,-4607.115,-4603.5225,-4593.7764,-4632.353,-4680.164,-4709.3823,-4718.618,-4725.617,-4691.4595,-4729.4214,-4710.5903,-4722.0713,-4749.757,-4784.106,-4759.283,-4679.939,-4722.191,-4745.5796,-4849.254,-4804.6045,-4790.647,-4832.277,-4817.302,-4783.199,-4790.8677,-4772.986,-4769.2534,-4750.542,-4762.8857,-4772.3765,-4769.9087,-4775.6255,-4788.47,-4679.0005,-4705.9634,-4699.4473,-4688.426,-4687.3306,-4646.573,-4721.975,-4637.681,-4624.674,-4599.3633,-4563.607,-4571.3223,-4560.511,-4559.1675,-4548.0713,-4553.186,-4549.2783,-4524.648,-4520.133,-804.2545,-858.7731,-1123.3826,-1085.487,-1281.2029,-1466.0571,-1546.6675,-1771.7241,-2165.088,-2433.9734,-2523.9224,-2598.8806,-2694.4028,-2802.6287,-2882.0896,-2945.0928,-3021.7766,-3076.691,-3145.8638,-3204.5835,-3269.9617,-3297.8833,-3363.0718,-3395.0112,-3436.0222,-3456.511,-3478.8628,-3411.7964,-3294.5771,-3101.2344,-2416.5796,-2229.532,-1935.8273,-1811.7236,-1830.4491,-1926.5437,-1985.936,-2047.4174,-2117.862,-2262.745,-2564.6611,-2958.7432,-3194.7783,-3006.1868,-3052.134,-3187.6626,-3310.6487,-3434.0015,-3492.1602,-3606.797,-3747.6562,-3877.5767,-3925.364,-3965.164,-3973.6987,-3968.471,-4003.604,-4040.2996,-4084.1743,-4127.2646,-4155.032,-4165.392,-4202.3374,-4278.14,-4324.713,-4358.005,-4389.6357,-4413.5635,-4438.139,-4458.8286,-4471.0757,-4497.5566,-4545.694,-4564.569,-4584.6665,-4625.6416,-4641.953,-4661.188,-4669.3174,-4699.4966,-4674.993,-4691.633,-4709.102,-4712.7495,-4706.0073,-4728.429,-4723.686,-4715.9463,-4748.325,-4803.116,-4807.8228,-4748.583,-4708.406,-4823.592,-4926.5757,-4980.644,-4833.844,-4898.7866,-4915.2383,-4826.061,-4746.82,-4678.545,-4753.631,-4754.8354,-4765.4043,-4797.295,-4799.3413,-4764.7246,-4676.4717,-4648.9585,-4723.718,-4754.18,-4722.17,-4675.004,-4676.212,-4651.267,-4606.5044,-4588.129,-4571.4814,-4559.8613,-4557.9756,-4566.5073,-4586.694,-4580.6914,-4568.9897,-4561.958,-4567.5034,-4543.9736,-1053.5447,-1212.097,-1317.8673,-1430.2717,-1447.4021,-1610.5803,-1845.8411,-1968.7794,-2253.463,-2426.9087,-2530.9006,-2664.5876,-2779.1577,-2862.34,-2937.9673,-3000.1113,-3061.482,-3099.693,-3160.1772,-3211.0527,-3278.9763,-3341.0627,-3365.6494,-3382.2021,-3411.5093,-3444.8142,-3324.4583,-3478.2258,-3546.181,-3434.7598,-2766.425,-2309.9146,-1862.6873,-1759.5323,-1946.6036,-1961.593,-2126.427,-2176.5928,-2357.5898,-2604.0193,-2762.711,-2973.8499,-3271.2651,-3257.281,-3318.2893,-3378.3452,-3568.792,-3674.254,-3648.498,-3731.2195,-3872.1782,-3960.6626,-3979.7231,-3983.089,-3945.792,-3985.0537,-4018.2336,-4088.507,-4152.1206,-4168.402,-4192.158,-4219.614,-4271.1245,-4340.2227,-4377.2095,-4417.2915,-4428.4453,-4419.693,-4462.35,-4473.1587,-4514.839,-4559.69,-4606.765,-4628.781,-4645.0747,-4658.6167,-4637.1304,-4626.8677,-4720.671,-4729.9233,-4696.8286,-4725.411,-4744.1475,-4735.683,-4747.2188,-4775.7437,-4764.0737,-4787.0693,-4744.392,-4754.362,-4745.4146,-4790.417,-4803.331,-4767.81,-4827.9897,-4890.646,-4894.6064,-4983.396,-4886.365,-4946.3276,-4817.404,-4769.13,-4765.293,-4800.737,-4761.5347,-4802.743,-4811.5244,-4772.628,-4673.8735,-4681.599,-4664.897,-4727.9355,-4694.4536,-4693.78,-4671.8696,-4695.636,-4645.888,-4593.6606,-4544.1875,-4564.3354,-4613.1133,-4589.687,-4606.018,-4619.5747,-4579.504,-4540.157,-4535.8594,-4493.342,-1268.4039,-1439.7562,-1559.6635,-1695.9763,-1708.6936,-1744.7913,-1944.0321,-2109.673,-2260.3872,-2417.5425,-2547.0823,-2682.0571,-2803.654,-2887.9846,-2960.9895,-3026.3633,-3096.2537,-3177.573,-3246.7268,-3299.8557,-3328.1685,-3333.2488,-3382.9248,-3404.7153,-3422.3704,-3440.9158,-3366.564,-3387.5078,-3543.8796,-3589.953,-3249.923,-2691.8616,-2302.4243,-2010.2528,-1963.7976,-2718.2842,-2506.6284,-2248.5657,-2522.651,-2874.5293,-3094.3608,-3351.8594,-3505.611,-3506.1292,-3473.5764,-3575.7034,-3690.0256,-3812.9185,-3845.8992,-3884.6743,-3939.1562,-3989.0317,-3994.1533,-3996.0713,-4008.2117,-4043.8367,-4064.782,-4138.9106,-4210.226,-4206.534,-4246.602,-4300.0386,-4349.9404,-4391.239,-4431.5737,-4470.1763,-4456.5806,-4456.6064,-4488.402,-4506.811,-4570.4307,-4607.5967,-4641.7627,-4662.9536,-4670.248,-4681.462,-4672.422,-4689.8447,-4717.625,-4718.4673,-4726.9727,-4759.28,-4779.601,-4766.0513,-4762.701,-4779.0,-4786.6533,-4778.6426,-4775.948,-4773.856,-4774.9287,-4813.6646,-4865.4175,-4848.953,-4850.3604,-4868.549,-4940.5757,-4959.009,-4914.9404,-4898.911,-4769.229,-4780.5415,-4817.3755,-4861.2036,-4869.34,-4826.029,-4819.2417,-4761.92,-4735.769,-4756.5693,-4762.466,-4774.17,-4753.4727,-4784.4585,-4817.7314,-4767.253,-4705.1904,-4663.569,-4633.2334,-4639.861,-4666.145,-4640.0835,-4610.286,-4605.636,-4573.757,-4530.075,-4536.3745,-4534.255,-1568.237,-1680.28,-1771.7893,-1835.0222,-1872.068,-1974.9158,-2117.4062,-2253.0413,-2367.72,-2479.816,-2612.3315,-2732.2676,-2863.9805,-2962.2788,-3034.7163,-3094.1821,-3163.075,-3221.5103,-3278.2156,-3320.7322,-3336.0618,-3365.7866,-3393.2856,-3423.9092,-3441.46,-3496.1443,-3518.012,-3528.949,-3546.925,-3601.3113,-3536.6865,-3219.0142,-2704.5654,-2518.8079,-2483.3586,-3440.909,-2991.5046,-2246.896,-2559.112,-2832.1191,-3160.5593,-3481.2964,-3599.7349,-3756.4937,-3817.246,-3849.081,-3884.1274,-3944.7402,-3967.5286,-3987.461,-4056.1177,-4092.3647,-4051.1338,-4061.2974,-4103.9956,-4124.319,-4160.454,-4213.0723,-4271.5454,-4261.1562,-4330.8794,-4383.7676,-4412.635,-4434.1035,-4471.795,-4504.7817,-4486.9478,-4521.195,-4545.0996,-4562.01,-4601.6577,-4653.5146,-4682.1733,-4686.2183,-4709.0894,-4713.097,-4702.161,-4727.2207,-4725.0947,-4729.9917,-4742.832,-4774.717,-4776.1973,-4786.1216,-4789.403,-4818.5283,-4827.0044,-4785.75,-4794.1543,-4791.783,-4809.076,-4804.328,-4831.1274,-4856.329,-4885.9175,-4940.1724,-4956.535,-4873.919,-4880.7114,-4864.002,-4769.3496,-4813.7725,-4839.4624,-4850.6772,-4838.3745,-4807.694,-4825.9595,-4762.5156,-4792.6553,-4812.3394,-4773.127,-4770.3584,-4774.573,-4826.0894,-4811.326,-4793.317,-4822.56,-4811.7197,-4692.237,-4676.4746,-4679.1226,-4677.839,-4668.645,-4645.9355,-4558.696,-4526.565,-4578.868,-4570.5493,-1678.1125,-1811.7886,-1935.24,-2015.4039,-2035.1526,-2089.7266,-2237.975,-2386.5864,-2499.034,-2611.9883,-2717.6355,-2828.2317,-2911.5361,-3023.4631,-3081.3645,-3173.5642,-3251.3616,-3285.2534,-3289.5544,-3329.3105,-3355.595,-3382.6035,-3423.8037,-3456.1482,-3495.6602,-3530.0684,-3547.8816,-3542.2292,-3554.6472,-3612.6987,-3645.731,-3580.899,-3205.5547,-2657.2495,-2393.5852,-3032.6023,-3131.166,-3352.6963,-3230.113,-3230.2688,-3548.825,-3745.735,-3856.2388,-3893.3223,-3941.495,-4012.4514,-4033.9573,-4038.0242,-4048.5054,-4107.269,-4158.1797,-4147.1875,-4144.517,-4157.314,-4192.9033,-4229.4673,-4257.3306,-4285.689,-4328.5,-4352.315,-4403.9893,-4431.4917,-4456.4517,-4485.2856,-4521.495,-4548.9683,-4542.3145,-4560.1997,-4575.628,-4605.7295,-4652.497,-4698.662,-4716.5815,-4710.647,-4728.1074,-4745.142,-4748.5215,-4739.3804,-4751.353,-4769.3843,-4781.711,-4778.6216,-4773.965,-4792.7534,-4824.279,-4831.492,-4824.709,-4845.284,-4841.3496,-4865.587,-4845.1523,-4844.151,-4822.3037,-4819.2095,-4873.6333,-4876.5054,-4850.3296,-4820.988,-4880.277,-4868.0225,-4814.455,-4846.058,-4867.9907,-4864.1143,-4869.914,-4846.17,-4840.878,-4829.893,-4844.722,-4861.035,-4842.599,-4829.8403,-4883.0312,-4867.624,-4820.631,-4853.043,-4879.4634,-4789.1245,-4742.873,-4712.1836,-4688.3994,-4666.4893,-4678.6787,-4690.718,-4642.4917,-4614.8696,-4612.0864,-4581.823,-1780.0933,-1870.9924,-1978.4159,-2120.4497,-2158.7808,-2209.5352,-2342.1558,-2577.3677,-2661.0918,-2791.0781,-2918.8916,-3026.0762,-3084.3716,-3159.4177,-3218.384,-3262.7207,-3306.5535,-3318.4626,-3342.3943,-3353.3948,-3352.4905,-3396.3704,-3449.927,-3480.7153,-3509.5562,-3551.6904,-3560.198,-3587.1726,-3620.7776,-3659.9482,-3682.6729,-3695.8606,-3581.5632,-3626.8726,-3650.8308,-3730.016,-3834.7043,-3907.7156,-3894.4116,-3882.8975,-3896.2559,-3945.0576,-3966.6807,-3979.0117,-4013.8748,-4071.0754,-4092.2065,-4153.2397,-4165.3315,-4186.378,-4211.107,-4247.8076,-4300.0527,-4326.9644,-4352.1987,-4369.327,-4374.6523,-4405.6675,-4439.1562,-4441.8306,-4456.324,-4489.743,-4513.472,-4547.734,-4559.5215,-4576.302,-4570.651,-4592.1655,-4628.1323,-4665.8833,-4699.062,-4726.0015,-4747.3154,-4761.151,-4780.91,-4769.779,-4762.61,-4756.2197,-4798.3975,-4819.8926,-4817.3203,-4805.7017,-4813.7173,-4845.958,-4856.562,-4845.2935,-4847.9976,-4870.663,-4876.5854,-4866.5156,-4877.657,-4888.375,-4841.2017,-4841.7373,-4887.5547,-4911.2393,-4871.6143,-4882.8604,-4907.031,-4894.73,-4865.1616,-4949.138,-4980.153,-4884.3027,-4891.2534,-4898.5176,-4879.0483,-4864.071,-4867.599,-4871.634,-4865.6323,-4902.991,-4944.8174,-4933.226,-4824.5767,-4826.311,-4813.7173,-4775.986,-4753.6636,-4745.207,-4732.935,-4708.6294,-4687.0684,-4677.716,-4663.064,-4620.5376,-4630.965,-4642.1206,-1860.5713,-1963.1069,-2068.5723,-2228.6804,-2288.1133,-2316.9563,-2652.094,-3684.7063,-3597.0576,-3043.5906,-3087.655,-3188.8184,-3255.807,-3299.1033,-3326.9683,-3337.5212,-3347.1008,-3329.2075,-3374.7102,-3227.4028,-4170.354,-3553.0945,-3476.6624,-3507.5112,-3510.6865,-3564.4321,-3589.8115,-3618.092,-3648.9204,-3695.8054,-3742.2593,-3772.199,-3787.224,-3812.5713,-3831.6062,-3853.7095,-3914.2004,-3966.303,-3995.9976,-4021.632,-4041.9712,-4084.9944,-4105.2783,-4102.3667,-4143.618,-4115.0054,-4157.4707,-4236.455,-4279.699,-4300.4067,-4327.255,-4341.4224,-4370.6562,-4393.455,-4436.7695,-4453.9897,-4456.091,-4480.1455,-4515.5317,-4504.8945,-4519.6,-4553.493,-4577.3467,-4597.658,-4610.4375,-4614.848,-4626.199,-4640.3154,-4668.9575,-4693.6157,-4725.6313,-4754.191,-4786.6523,-4805.053,-4807.4336,-4796.1846,-4818.955,-4807.393,-4839.2495,-4867.6245,-4852.994,-4851.5576,-4851.3413,-4895.9146,-4893.6396,-4861.683,-4858.377,-4891.397,-4898.031,-4874.6387,-4896.3335,-4890.268,-4859.5786,-4869.4365,-4869.1094,-4903.208,-4941.2295,-4969.745,-4944.5923,-4893.088,-4857.097,-4899.1973,-4901.0713,-4876.7954,-4863.232,-4878.5664,-4879.194,-4888.064,-4870.325,-4852.373,-4904.601,-4921.0005,-4828.368,-4798.9785,-4730.37,-4789.3745,-4803.3145,-4759.9653,-4771.2573,-4761.648,-4740.9897,-4741.6533,-4698.669,-4680.9707,-4726.2583,-4681.441,-4678.831,-4664.435,-1977.2018,-2081.4478,-2187.3562,-2299.274,-2392.7585,-2488.4841,-2597.8306,-3037.801,-3112.5798,-3078.9373,-3177.249,-3244.64,-3287.79,-3322.4348,-3347.041,-3364.0444,-3377.0376,-3364.883,-3395.4485,-3402.8772,-3388.5598,-3457.015,-3507.2222,-3521.9165,-3552.9282,-3586.5115,-3621.713,-3665.0657,-3713.7188,-3752.9087,-3797.45,-3829.707,-3848.0115,-3917.3252,-3872.1316,-3891.558,-3944.8955,-3993.58,-4027.7905,-4066.5745,-4122.078,-4142.67,-4177.1597,-4216.5957,-4225.7515,-4237.454,-4274.7827,-4320.864,-4351.3105,-4366.168,-4384.8447,-4399.8306,-4422.5884,-4444.821,-4470.2944,-4494.1235,-4499.085,-4534.253,-4550.801,-4546.232,-4559.01,-4602.4,-4627.3774,-4650.643,-4654.99,-4655.8335,-4688.075,-4708.734,-4725.4326,-4742.592,-4765.3843,-4785.1313,-4804.263,-4819.1416,-4831.821,-4832.346,-4835.2197,-4849.713,-4876.6597,-4884.6763,-4896.7446,-4877.8574,-4888.592,-4902.495,-4899.196,-4893.17,-4900.3125,-4925.744,-4923.975,-4907.7764,-4927.537,-4917.696,-4911.5137,-4926.9707,-4945.6865,-4924.785,-4934.191,-4956.978,-4928.7524,-4886.335,-4884.553,-4882.52,-4895.8438,-4886.9663,-4910.356,-4931.4893,-4926.9326,-4912.7407,-4890.556,-4881.2793,-4897.788,-4865.699,-4934.8525,-4922.129,-4830.2007,-4850.719,-4819.416,-4780.025,-4772.3584,-4737.3354,-4751.558,-4743.407,-4706.919,-4731.5347,-4745.6475,-4719.846,-4692.04,-4654.4746,-2071.252,-2190.8215,-2294.2676,-2390.848,-2496.9624,-2621.34,-2721.7542,-2844.1707,-2993.4517,-3104.8591,-3184.7144,-3248.2354,-3289.9836,-3324.0806,-3348.6912,-3376.6558,-3402.9023,-3419.2334,-3424.5757,-3441.9346,-3467.0276,-3481.5972,-3495.4487,-3552.9329,-3589.8757,-3618.5793,-3660.968,-3709.9497,-3757.7402,-3795.346,-3836.0688,-3858.6719,-3877.0024,-3914.2014,-3929.7214,-3965.2092,-4008.5903,-4038.1533,-4075.476,-4116.224,-4180.7275,-4215.7573,-4244.344,-4273.687,-4286.568,-4331.7456,-4357.739,-4392.65,-4414.751,-4423.539,-4433.4434,-4452.9204,-4478.1797,-4499.9634,-4516.1626,-4530.527,-4544.5376,-4560.7163,-4580.4453,-4577.021,-4609.6543,-4646.2627,-4666.1636,-4679.2793,-4695.5435,-4710.04,-4731.944,-4749.094,-4768.8965,-4790.373,-4804.0854,-4806.8315,-4816.6055,-4813.2373,-4794.3076,-4849.7217,-4845.8794,-4870.294,-4892.934,-4891.2095,-4899.097,-4882.361,-4910.899,-4936.9556,-4943.144,-4927.8853,-4935.2534,-4962.0303,-4935.934,-4955.3413,-4965.2065,-4944.35,-4941.086,-4974.265,-4942.102,-4926.5366,-4919.51,-4934.8643,-4922.4937,-4913.821,-4918.72,-4912.575,-4904.729,-4901.7563,-4949.9536,-5012.4253,-4934.0723,-4925.4443,-4906.127,-4923.2075,-4895.8057,-4650.0503,-4588.4136,-4805.908,-4667.826,-4715.238,-4762.7686,-4792.7173,-4790.59,-4767.7515,-4759.3296,-4749.6265,-4744.256,-4736.12,-4752.466,-4736.4707,-4720.427,-4670.4717,-2233.464,-2335.1946,-2462.4888,-2558.3708,-2655.6667,-2754.1724,-2827.1238,-2941.0317,-3090.2397,-3167.817,-3214.6257,-3252.6606,-3295.327,-3348.6426,-3377.8674,-3399.7288,-3421.1965,-3441.3586,-3464.2935,-3493.8784,-3517.591,-3534.0703,-3555.5906,-3589.7139,-3627.2192,-3657.9495,-3700.0625,-3734.7993,-3780.0273,-3816.2727,-3852.1328,-3889.983,-3920.196,-3955.0955,-4006.379,-4048.9458,-4076.4685,-4105.876,-4129.0625,-4165.3667,-4204.5015,-4257.2524,-4302.543,-4351.2515,-4389.7188,-4412.324,-4424.5366,-4446.1484,-4461.853,-4470.906,-4494.286,-4510.7476,-4518.5493,-4535.9624,-4565.4346,-4582.8003,-4594.3477,-4596.8335,-4614.1743,-4637.373,-4654.758,-4686.322,-4692.412,-4708.66,-4725.343,-4727.191,-4744.7417,-4762.1416,-4784.0967,-4812.087,-4826.5566,-4822.4287,-4844.7026,-4869.433,-5034.3867,-4877.56,-4905.5815,-4926.107,-4925.7583,-4916.4346,-4927.56,-4927.199,-4937.008,-4942.5225,-4944.434,-4939.528,-4968.12,-4977.769,-4989.5176,-4976.3843,-4977.8066,-4951.741,-4965.6973,-4981.8687,-4961.624,-4948.9194,-4936.1313,-4945.896,-4939.753,-4983.597,-4927.837,-4928.897,-4972.13,-4969.943,-4908.4746,-4919.5747,-4901.803,-4911.0513,-4901.251,-4912.0234,-4880.3887,-4604.6357,-4928.764,-5789.144,-5588.9956,-4674.056,-4790.3804,-4823.2188,-4794.4673,-4783.372,-4762.9062,-4755.4497,-4770.9697,-4754.722,-4727.752,-4717.1904,-4708.6157,-4716.7417,-2417.9048,-2537.906,-2627.084,-2728.9568,-2840.6394,-2914.1465,-3024.9714,-3108.3132,-3164.0637,-3210.4016,-3248.1924,-3288.8801,-3339.017,-3379.5518,-3405.7778,-3427.8855,-3437.8743,-3458.2761,-3480.0027,-3515.069,-3557.4197,-3593.266,-3619.7725,-3649.7866,-3681.411,-3708.1191,-3744.8037,-3777.4146,-3812.606,-3846.993,-3880.0378,-3919.7803,-3955.014,-3996.8528,-4035.1323,-4074.997,-4121.6396,-4144.76,-4180.959,-4237.2607,-4261.92,-4324.061,-4365.444,-4418.934,-4454.6934,-4476.8945,-4483.4614,-4477.3726,-4504.1196,-4522.7,-4541.3335,-4549.3286,-4570.9097,-4593.516,-4601.0884,-4626.572,-4646.968,-4642.318,-4649.6943,-4667.9497,-4698.561,-4717.2173,-4731.1675,-4753.2427,-4758.405,-4756.2007,-4766.377,-4795.308,-4807.7705,-4802.6436,-4809.5967,-4820.701,-4857.9937,-4874.5586,-4891.179,-4904.309,-4924.244,-4933.374,-4933.016,-4939.07,-4962.5117,-4981.0483,-4975.4805,-4961.5024,-4959.5312,-4954.9136,-4979.6577,-5012.248,-5011.7065,-4973.781,-4978.2104,-4989.611,-5052.669,-5043.5996,-5015.2466,-4983.2036,-4958.6924,-4950.6387,-4982.424,-4988.7935,-4964.728,-4960.0493,-4948.786,-4939.443,-4932.1255,-4923.202,-4927.941,-4925.4453,-4924.0654,-4945.324,-4918.496,-4809.8516,-4679.4775,-4855.107,-4744.8877,-4793.301,-4865.291,-4837.8687,-4793.94,-4787.8486,-4799.4653,-4803.9814,-4776.914,-4771.9893,-4758.5366,-4743.405,-4718.384,-4717.103,-2619.5833,-2717.6082,-2830.8225,-2897.2498,-2969.122,-3054.6323,-3126.4878,-3166.0884,-3205.9026,-3270.679,-3311.6658,-3349.3484,-3382.9973,-3412.2249,-3443.4717,-3465.9482,-3486.0564,-3507.681,-3526.8135,-3558.2114,-3603.1135,-3641.9397,-3658.8462,-3700.5935,-3732.3716,-3755.2139,-3791.7573,-3823.249,-3851.1055,-3889.3503,-3930.5872,-3963.4224,-3992.162,-4029.1265,-4050.5667,-4086.8228,-4155.7456,-4173.0215,-4215.355,-4269.468,-4321.724,-4368.9893,-4404.6787,-4462.395,-4499.1387,-4517.144,-4511.2617,-4531.1343,-4562.5786,-4579.5054,-4594.624,-4607.9937,-4622.936,-4624.9287,-4651.473,-4673.951,-4684.209,-4693.28,-4697.8716,-4712.894,-4725.1743,-4744.4424,-4771.311,-4797.002,-4805.2407,-4784.083,-4783.45,-4819.3,-4844.883,-4836.135,-4832.358,-4872.9663,-4896.2446,-4902.1504,-4909.8667,-4913.711,-4906.846,-4921.445,-4932.254,-4946.682,-4954.0854,-4954.6943,-4958.136,-4964.7705,-5002.0117,-5063.6934,-5029.5815,-5022.3843,-4998.303,-5012.8965,-5017.3115,-5043.576,-5038.2676,-5026.7646,-5023.0107,-5019.0825,-5023.1743,-4995.8506,-4986.023,-4981.664,-4984.6387,-4930.3423,-4932.968,-4941.3706,-4966.7583,-4941.0728,-4952.8506,-4935.3096,-4944.8193,-4954.2036,-4923.2373,-4917.143,-4916.5596,-4918.9497,-4905.3076,-4889.1875,-4897.7266,-4868.813,-4830.024,-4822.999,-4824.629,-4800.9263,-4806.6655,-4804.7856,-4782.712,-4757.3467,-4713.341,-4732.215,-2856.4016,-2926.98,-2994.3203,-3034.4795,-3076.1895,-3121.1848,-3165.8147,-3224.8477,-3275.8955,-3332.0151,-3377.8933,-3406.2454,-3429.3447,-3447.581,-3466.0068,-3512.1575,-3545.8696,-3578.322,-3622.7412,-3639.4004,-3655.9414,-3681.836,-3701.7898,-3735.1323,-3788.5432,-3831.1584,-3856.1333,-3883.9656,-3909.3372,-3933.221,-3973.1313,-4009.5127,-4049.6572,-4089.3643,-4125.86,-4147.0205,-4177.6294,-4220.5947,-4256.043,-4296.292,-4349.4893,-4398.223,-4447.032,-4494.826,-4517.697,-4638.6826,-4558.5723,-4586.808,-4603.915,-4633.496,-4653.0366,-4655.523,-4656.518,-4671.301,-4682.4365,-4692.692,-4703.6025,-4721.14,-4747.2827,-4760.7314,-4771.124,-4788.3086,-4808.5635,-4821.0566,-4803.386,-4813.2554,-4837.1113,-4873.555,-4872.095,-4860.284,-4873.002,-4892.2246,-4909.2563,-4918.708,-4920.1187,-4906.567,-4910.337,-4935.5107,-4942.111,-4958.396,-4980.015,-4981.5654,-4973.0205,-4992.8613,-5000.352,-5004.8994,-5008.782,-4986.7617,-4976.477,-5005.53,-5018.0327,-5010.71,-5042.0146,-5061.8716,-5058.1216,-5046.504,-5027.4424,-5025.2827,-5009.818,-5007.582,-4969.87,-4938.2744,-4956.6836,-4974.969,-4975.511,-4962.4546,-4962.2383,-4947.5894,-4932.5464,-4911.1006,-4904.928,-4911.276,-4922.305,-4934.092,-4896.2324,-4879.2256,-4889.38,-4875.6753,-4858.9883,-4858.049,-4846.742,-4839.8413,-4828.719,-4817.0513,-4787.3457,-4747.4404,-4700.088,-4700.143,-3002.9897,-3035.4563,-3063.0813,-3088.289,-3132.7598,-3187.6892,-3242.342,-3293.1504,-3342.1719,-3391.3042,-3424.2026,-3443.208,-3476.707,-3472.387,-3451.8044,-3487.025,-3598.1226,-3627.9917,-3683.6926,-3716.3762,-3730.988,-3743.728,-3764.6533,-3801.3125,-3843.5435,-3887.156,-3924.2307,-3961.129,-3989.4136,-4010.5095,-4036.697,-4075.7146,-4123.8516,-4153.85,-4197.5186,-4219.374,-4243.002,-4271.173,-4294.07,-4312.189,-4355.054,-4403.425,-4436.427,-4476.818,-4532.656,-4574.321,-4550.5864,-4619.393,-4658.7383,-4686.3022,-4707.644,-4720.1714,-4701.4165,-4704.7515,-4704.855,-4723.59,-4756.853,-4773.7153,-4793.8574,-4792.3867,-4794.739,-4801.274,-4827.1763,-4813.449,-4831.7075,-4857.06,-4875.747,-4871.1763,-4876.0703,-4904.876,-4921.7397,-4930.4736,-4944.4834,-4950.841,-4941.8555,-4944.9673,-4945.651,-4954.4604,-4961.0703,-4984.878,-5009.059,-5027.207,-5068.3423,-5052.2554,-5026.1475,-5013.578,-4991.6606,-5013.9,-4989.0156,-4991.6436,-4983.196,-4980.0576,-5013.867,-5072.795,-5068.0986,-5055.154,-5014.5796,-5025.012,-5046.045,-5092.2334,-5013.974,-4990.072,-4988.1665,-5002.704,-5018.556,-4997.5522,-4981.9146,-4961.478,-4944.287,-4911.303,-4923.854,-4917.139,-4917.1797,-4913.5376,-4897.8203,-4897.022,-4900.8174,-4931.439,-4902.552,-4863.8706,-4821.9814,-4801.2144,-4827.106,-4817.8403,-4807.058,-4786.7886,-4766.5464,-4703.9946,-3094.4805,-3111.4858,-3134.2244,-3181.0305,-3213.7986,-3259.2312,-3305.821,-3351.549,-3396.2004,-3449.08,-3492.5771,-3502.398,-3531.8992,-3510.702,-3830.311,-4033.0732,-3633.2974,-3695.5422,-3711.6238,-3743.401,-3815.6597,-3840.6404,-3858.5476,-3878.065,-3917.2495,-3937.3396,-3985.8208,-4026.3374,-4052.6553,-4078.231,-4104.825,-4136.736,-4173.3535,-4205.3306,-4251.323,-4280.554,-4316.7505,-4330.215,-4354.6245,-4371.9556,-4396.7524,-4428.0874,-4443.049,-4473.0093,-4549.543,-4597.1426,-4647.32,-4681.7173,-4713.032,-4709.972,-4727.025,-4724.1074,-4730.116,-4757.7563,-4770.113,-4803.5166,-4801.7925,-4800.096,-4817.533,-4789.568,-4830.795,-4816.317,-4827.7617,-4865.4497,-4889.035,-4900.831,-4919.0825,-4926.935,-4930.6426,-4937.9717,-4951.783,-4963.214,-4979.9243,-4989.7837,-4982.797,-4961.404,-4962.5605,-4974.3384,-4985.8413,-5021.5205,-5049.069,-5048.0654,-5054.1577,-5074.765,-5061.546,-5044.545,-5031.4756,-5056.5024,-5054.6636,-5038.7363,-5037.4478,-5028.449,-5025.9976,-5031.692,-5039.3364,-5046.1895,-5042.587,-5089.314,-5103.096,-5136.2827,-5053.16,-5035.955,-5015.222,-5020.1543,-5028.1074,-5019.0015,-5000.7383,-4978.6963,-4954.479,-4968.8853,-4967.0034,-4956.28,-4937.3926,-4918.9927,-4927.0146,-4923.2183,-4915.9907,-4900.5474,-4880.5493,-4912.439,-4899.7485,-4863.6875,-4840.0967,-4820.7056,-4825.914,-4796.7866,-4753.7227,-4713.7544,-3185.642,-3216.0874,-3236.8833,-3267.5012,-3301.1902,-3328.2285,-3368.7568,-3411.268,-3459.3865,-3510.726,-3563.8523,-3595.0503,-3619.1958,-3630.8328,-3638.882,-3686.0554,-3713.3271,-3785.4646,-3816.3984,-3855.6975,-3889.3777,-3917.3572,-3959.666,-3973.4023,-4001.6284,-4027.008,-4059.54,-4081.9658,-4119.093,-4154.181,-4184.2744,-4212.3765,-4244.164,-4274.839,-4302.561,-4338.8066,-4371.5654,-4401.1973,-4414.0693,-4423.081,-4453.528,-4484.495,-4509.8403,-4563.783,-4597.448,-4632.046,-4676.642,-4687.0415,-4704.616,-4726.6084,-4727.296,-4740.3223,-4763.3955,-4843.874,-4810.868,-4823.4844,-4836.465,-4824.979,-5274.5474,-4828.467,-4805.861,-4830.1226,-4891.016,-4924.1704,-4939.6587,-4938.4395,-4947.324,-4952.853,-4941.8496,-4963.35,-4979.3325,-5002.805,-5022.9497,-5024.505,-4995.167,-4983.331,-4998.12,-5010.4385,-5026.637,-5046.0,-5068.144,-5078.0654,-5088.0366,-5120.536,-5108.047,-5102.535,-5089.2324,-5062.543,-5067.848,-5087.465,-5110.904,-5092.487,-5056.8027,-5053.041,-5050.5513,-5038.6133,-5041.676,-5062.886,-5076.4224,-5062.111,-5043.2417,-5037.759,-5032.1846,-5028.826,-5029.8896,-5010.765,-4994.905,-4993.187,-5008.4653,-4994.9595,-4989.243,-4980.238,-4959.838,-4976.399,-4955.0835,-4947.6187,-4919.191,-4881.2173,-4855.078,-4856.3184,-4860.309,-4837.3677,-4826.3555,-4818.8574,-4791.245,-4772.071,-4767.6865,-4741.4565,-3285.5642,-3308.0894,-3339.2302,-3367.3657,-3397.9202,-3429.4636,-3459.641,-3486.7097,-3536.9875,-3587.163,-3626.4895,-3658.8457,-3703.4739,-3751.3328,-3786.2124,-3803.6362,-3825.075,-3842.8064,-3861.7358,-3911.7166,-3951.0422,-3978.9324,-4016.633,-4048.4949,-4089.0725,-4113.803,-4132.895,-4172.7314,-4195.8184,-4229.2456,-4257.1357,-4282.3804,-4311.358,-4339.0786,-4363.0273,-4392.386,-4416.302,-4449.4375,-4475.031,-4487.9927,-4519.75,-4541.4165,-4543.0127,-4577.2705,-4624.286,-4670.037,-4701.9023,-4705.206,-4729.037,-4751.0425,-4779.032,-4814.5,-4819.6484,-4973.67,-4853.381,-4853.0425,-4802.747,-4755.24,-4775.097,-4822.6626,-4900.9575,-4923.838,-4944.704,-4967.967,-4965.9795,-4958.2866,-4971.235,-4976.3535,-4983.0454,-4998.0127,-5021.544,-5044.598,-5040.7905,-5024.8267,-5007.708,-5019.4185,-5040.4175,-5046.2573,-5041.9634,-5049.2993,-5048.76,-5068.643,-5131.9043,-5124.1606,-5135.1616,-5130.4795,-5094.991,-5094.783,-5101.2896,-5090.7954,-5091.983,-5093.0366,-5084.2207,-5061.7456,-5056.502,-5034.206,-5027.1465,-5051.483,-5051.36,-5058.9526,-5062.8105,-5055.2886,-5058.3467,-5043.982,-5023.4644,-5001.462,-5018.8145,-5013.8906,-5005.0225,-4989.001,-4979.4175,-4984.4014,-4984.5283,-4964.689,-4935.2437,-4903.525,-4893.941,-4860.1323,-4848.673,-4873.4893,-4868.7534,-4855.7803,-4823.6797,-4804.7046,-4775.202,-4789.427,-4770.9116,-4761.5664,-3377.254,-3411.0098,-3450.54,-3478.3127,-3499.314,-3520.157,-3550.0735,-3571.6455,-3609.0876,-3649.4717,-3689.3394,-3726.3323,-3774.819,-3812.867,-3851.9036,-3883.2688,-3905.6418,-3921.8975,-3944.7393,-3976.4426,-4016.741,-4053.9373,-4089.4712,-4126.1436,-4160.6035,-4194.7124,-4236.808,-4264.4263,-4283.116,-4304.0503,-4329.9854,-4349.9097,-4375.5054,-4407.9214,-4424.249,-4451.286,-4478.7437,-4510.286,-4538.3115,-4555.1577,-4578.21,-4598.889,-4607.3936,-4618.6196,-4666.8184,-4710.126,-4732.913,-4754.717,-4789.5767,-4808.3564,-4837.542,-4857.343,-4876.6304,-4880.927,-4891.4136,-4901.024,-4904.5933,-4894.987,-4897.395,-4941.0054,-4968.9165,-4985.237,-4982.4033,-4976.1504,-4970.922,-4984.101,-4990.733,-4998.388,-4991.917,-5004.7603,-5031.213,-5047.9683,-5041.1724,-5027.2026,-5027.2114,-5035.489,-5034.7715,-5046.143,-5059.6714,-5056.7075,-5056.4727,-5065.3433,-5087.414,-5105.5044,-5120.74,-5132.0127,-5128.4614,-5108.354,-5101.4507,-5099.847,-5099.7153,-5080.9194,-5064.097,-5058.5176,-5062.8975,-5067.712,-5045.295,-5033.949,-5057.578,-5073.3853,-5084.268,-5077.198,-5070.5923,-5053.7236,-5028.851,-5016.7153,-5034.838,-5026.833,-5013.1997,-4995.437,-4982.2437,-4981.1484,-4956.751,-4921.6367,-4918.9746,-4861.327,-4857.0044,-4878.9443,-4885.3003,-4866.827,-4847.959,-4837.8003,-4838.0405,-4818.5796,-4791.8726,-4801.489,-4785.414,-4774.4287,-3521.8782,-3534.9397,-3549.0085,-3578.1064,-3595.4983,-3619.6946,-3629.9583,-3660.6934,-3700.8394,-3739.896,-3762.6926,-3778.555,-3808.343,-3866.0864,-3911.4226,-3949.9304,-3976.914,-3995.1785,-4030.7705,-4045.5786,-4086.7056,-4131.0884,-4167.86,-4194.9663,-4240.09,-4275.2397,-4302.871,-4333.9653,-4359.985,-4384.031,-4393.89,-4413.7456,-4448.2417,-4486.448,-4507.425,-4518.304,-4537.58,-4573.309,-4604.9707,-4616.0654,-4639.288,-4652.039,-4666.808,-4675.3486,-4717.9263,-4755.9097,-4773.5337,-4799.162,-4826.4507,-4836.712,-4855.1943,-4895.6255,-4907.205,-4913.9976,-4916.7007,-4911.181,-4914.0063,-4948.435,-4980.5967,-4995.9565,-4999.366,-4991.4917,-5007.199,-5008.771,-5008.712,-5010.3145,-5004.124,-5003.1343,-5018.863,-5027.9927,-5031.8623,-5043.5835,-5055.447,-5034.7627,-5041.5977,-5059.6465,-5067.5034,-5078.601,-5084.86,-5081.821,-5074.4824,-5089.366,-5104.4253,-5092.6245,-5110.321,-5136.924,-5122.9985,-5122.1816,-5114.635,-5102.5815,-5091.488,-5079.677,-5081.908,-5089.793,-5066.761,-5058.629,-5053.6743,-5034.944,-5072.3657,-5091.705,-5096.0894,-5095.6646,-5084.6694,-5080.814,-5070.0947,-5050.712,-5018.002,-5025.037,-4991.345,-4989.0596,-4973.4316,-4946.103,-4875.297,-4781.2993,-4740.4707,-4767.407,-4856.7407,-4865.2817,-4878.6646,-4861.7524,-4854.903,-4858.7114,-4849.7344,-4827.9746,-4809.8213,-4814.977,-4810.7695,-4804.6904,-3625.8665,-3623.749,-3634.2415,-3657.0312,-3678.628,-3704.2659,-3722.989,-3747.0142,-3792.28,-3821.523,-3839.65,-3867.5447,-3894.696,-3929.9136,-3972.7207,-4004.7383,-4039.1748,-4066.4543,-4094.2734,-4126.9785,-4165.05,-4204.8745,-4239.3096,-4271.696,-4310.4785,-4340.1035,-4365.329,-4396.157,-4428.0605,-4453.161,-4527.9023,-4564.862,-4528.349,-4568.433,-4588.5757,-4600.252,-4664.133,-4609.1104,-4670.39,-4691.7793,-4707.223,-4717.9097,-4729.407,-4737.9897,-4750.89,-4790.4253,-4817.176,-4836.193,-4864.4214,-4883.3906,-4886.274,-4908.449,-4918.964,-4927.0317,-4924.071,-4941.0996,-4977.893,-4993.802,-5010.5767,-5028.96,-5026.172,-5020.152,-5022.22,-5025.262,-5017.8354,-5008.651,-5005.007,-5012.833,-5037.829,-5052.21,-5066.697,-5066.8384,-5057.4233,-5038.156,-5050.8633,-5068.2515,-5080.772,-5093.977,-5092.6597,-5088.521,-5087.423,-5098.861,-5101.4907,-5112.491,-5114.7134,-5115.773,-5130.2915,-5131.1294,-5117.325,-5113.874,-5116.8867,-5121.277,-5117.44,-5097.2886,-5080.84,-5095.8833,-5098.539,-5109.8315,-5115.96,-5115.2617,-5112.08,-5113.9663,-5096.9604,-5079.8535,-5058.001,-5049.0034,-5048.639,-5020.6333,-4962.4463,-4936.256,-4859.092,-4708.597,-4830.1943,-4957.918,-4938.641,-4765.327,-4582.317,-4585.563,-4753.095,-4828.504,-4852.172,-4861.3223,-4854.6025,-4840.81,-4833.84,-4833.638,-4830.0127,-4825.085,-3708.9875,-3722.2817,-3738.5574,-3756.2266,-3776.5532,-3802.739,-3829.8171,-3844.529,-3873.4795,-3896.9817,-3923.9797,-3953.4915,-3976.358,-4008.8218,-4040.1917,-4061.1743,-4097.5728,-4111.758,-4142.518,-4186.2285,-4229.0215,-4274.255,-4302.6924,-4335.7114,-4379.031,-4412.5947,-4443.864,-4473.1504,-4505.521,-4537.0493,-4572.888,-4603.3516,-4627.786,-4657.2417,-4690.2134,-4708.8027,-4722.215,-4735.127,-4749.5684,-4765.756,-4767.299,-4771.9995,-4791.307,-4798.8027,-4812.2466,-4847.6465,-4877.885,-4899.356,-4916.97,-4935.573,-4926.3374,-4938.8286,-4937.062,-4961.0938,-4986.6025,-5006.961,-5014.5547,-5029.82,-5043.65,-5052.8975,-5052.6978,-5053.1953,-5046.2617,-5031.997,-5012.2827,-4999.97,-5033.05,-5058.6997,-5074.6943,-5087.375,-5091.14,-5062.8677,-5055.547,-5056.743,-5060.0854,-5058.8037,-5083.333,-5107.0854,-5114.6904,-5118.76,-5116.1333,-5109.3315,-5124.843,-5127.1475,-5119.7983,-5130.0547,-5141.6943,-5136.599,-5133.639,-5133.604,-5127.6997,-5125.9556,-5124.9277,-5115.049,-5109.5435,-5117.4004,-5120.786,-5130.87,-5145.5815,-5139.953,-5128.256,-5130.285,-5104.0293,-5085.7534,-5078.326,-5061.0146,-5034.199,-5020.05,-4967.421,-4836.8574,-4580.152,-4873.469,-6128.524,-6402.66,-6365.897,-6274.76,-5639.467,-4403.865,-4334.995,-4741.0625,-4844.0957,-4851.0796,-4856.347,-4852.277,-4840.792,-4836.896,-4847.6777,-4842.1,-3783.3098,-3807.4338,-3828.8381,-3833.2617,-3862.474,-3887.9885,-3917.2458,-3951.6533,-3969.339,-3980.7202,-4005.402,-4029.8955,-4052.0823,-4087.0837,-4114.098,-4141.604,-4160.189,-4182.065,-4236.218,-4395.8457,-4263.1323,-4322.133,-4368.5825,-4401.3667,-4438.319,-4470.6577,-4504.5405,-4540.7847,-4577.231,-4604.9663,-4636.02,-4679.517,-4711.571,-4748.461,-4777.695,-4810.9785,-4844.7314,-4860.6157,-4871.136,-4879.5083,-4881.432,-4879.1587,-4884.315,-4908.3374,-4926.6626,-4946.331,-4962.281,-4976.7007,-4985.811,-4982.1406,-4971.529,-4967.392,-4982.9897,-5016.8877,-5032.5176,-5036.415,-5040.5835,-5048.5103,-5062.909,-5067.01,-5067.5747,-5066.3394,-5061.913,-5028.4736,-5023.935,-5054.0894,-5073.102,-5096.8477,-5095.849,-5101.0225,-5094.0283,-5068.0435,-5065.191,-5083.746,-5083.3706,-5099.1123,-5107.478,-5125.9585,-5134.5635,-5129.6206,-5127.4946,-5124.241,-5120.001,-5103.2554,-5114.692,-5140.6724,-5130.121,-5142.558,-5150.1724,-5144.172,-5125.3726,-5104.187,-5111.6245,-5122.2817,-5133.6113,-5141.129,-5132.0938,-5106.633,-5133.6484,-5150.4263,-5142.003,-5116.7285,-5095.893,-5097.0186,-5098.809,-5081.4097,-5052.9155,-5036.3413,-4971.1006,-4781.7686,-4459.742,-4720.574,-5997.8423,-6373.557,-6417.6353,-6244.747,-5296.631,-4298.912,-4292.1313,-4760.8237,-4849.0303,-4870.5156,-4867.0312,-4869.2124,-4841.3726,-4820.252,-4843.824,-4843.2847,-3851.655,-3884.5212,-3912.2656,-3930.695,-3947.5957,-3967.9194,-3996.3167,-4026.6096,-4055.475,-4074.4827,-4090.3535,-4106.5474,-4126.4556,-4162.658,-4187.66,-4214.8115,-4244.651,-4270.99,-4289.644,-4326.958,-4356.5586,-4392.0864,-4426.0547,-4458.704,-4496.7793,-4528.99,-4569.9126,-4614.3926,-4658.2827,-4687.8135,-4704.236,-4754.1367,-4797.885,-4825.148,-4854.5728,-4886.561,-4916.748,-4951.257,-4971.348,-4983.1416,-4994.7837,-5005.803,-5015.2446,-5025.6577,-5036.8916,-5040.633,-5039.245,-5041.8213,-5046.547,-5047.201,-5037.6675,-5040.8228,-5046.9824,-5045.2124,-5052.459,-5056.9087,-5057.9473,-5059.007,-5063.529,-5070.259,-5076.3867,-5073.2275,-5055.812,-5041.979,-5061.1807,-5089.7515,-5111.883,-5122.874,-5116.6055,-5112.275,-5094.7646,-5089.021,-5102.9087,-5118.904,-5128.124,-5138.9194,-5147.6367,-5152.9585,-5148.088,-5145.9917,-5149.3945,-5140.561,-5128.1704,-5116.3345,-5130.155,-5136.4224,-5142.1924,-5154.694,-5154.1733,-5145.7104,-5133.7554,-5110.221,-5098.012,-5129.3076,-5151.999,-5163.765,-5177.695,-5207.2534,-5142.8154,-5145.9,-5135.8896,-5110.4194,-5104.7065,-5098.6714,-5093.212,-5078.275,-5048.656,-5033.361,-5016.1387,-4950.595,-4792.094,-4604.1973,-4537.7837,-4671.9507,-4801.722,-4625.4297,-4481.0107,-4523.087,-4729.4165,-4841.843,-4868.271,-4863.9355,-4860.8994,-4861.509,-4851.994,-4842.0493,-4846.154,-4833.22,-3918.6501,-3948.266,-3978.9094,-4005.9905,-4027.346,-4055.5544,-4080.003,-4105.8257,-4128.667,-4154.507,-4172.5454,-4183.519,-4205.2563,-4242.9395,-4278.3594,-4307.346,-4325.6533,-4361.543,-4400.3984,-4422.2476,-4454.6484,-4494.0215,-4535.456,-4570.894,-4598.3022,-4644.3726,-4683.376,-4721.157,-4751.539,-4787.9727,-4824.029,-4849.5264,-4879.704,-4916.461,-4946.3447,-4963.533,-4977.7573,-5017.315,-5029.769,-5050.4023,-5081.688,-5111.2124,-5122.53,-5119.662,-5130.9756,-5127.6914,-5123.0596,-5115.3936,-5086.48,-5095.358,-5097.3936,-5090.107,-5081.521,-5080.2153,-5078.46,-5081.2744,-5080.0884,-5081.6006,-5084.081,-5096.821,-5083.368,-5067.974,-5069.851,-5092.241,-5114.2466,-5127.338,-5137.653,-5134.2524,-5124.5806,-5121.9194,-5109.943,-5130.478,-5140.3706,-5151.6436,-5154.6206,-5144.717,-5160.4434,-5148.27,-5143.8003,-5145.313,-5160.238,-5169.737,-5161.953,-5161.942,-5157.046,-5158.304,-5155.5283,-5172.5835,-5158.842,-5143.1016,-5126.759,-5087.8496,-5106.109,-5147.6772,-5164.376,-5172.6055,-5163.2397,-5157.098,-5160.2363,-5152.9014,-5130.302,-5112.334,-5113.1978,-5086.5483,-5075.1816,-5035.4033,-5024.505,-5028.412,-4998.1084,-4994.941,-4980.062,-4938.1587,-4916.4316,-4877.0234,-4848.5938,-4838.458,-4842.994,-4860.929,-4857.8535,-4873.3086,-4869.969,-4867.401,-4863.5913,-4865.6855,-4867.077,-4864.2915,-4859.6665,-4842.872,-3988.4006,-4016.7349,-4044.4053,-4075.041,-4103.512,-4137.183,-4163.0957,-4192.3477,-4220.884,-4261.2373,-4299.4775,-4334.273,-4364.9175,-4409.707,-4437.0747,-4450.9517,-4484.609,-4511.004,-4549.03,-4577.121,-4598.9897,-4630.5967,-4668.574,-4690.264,-4717.002,-4735.138,-4758.8496,-4802.6074,-4828.3906,-4858.597,-4891.5703,-4923.703,-4942.423,-4972.366,-4999.605,-5015.0093,-5032.146,-5044.128,-5065.3047,-5082.774,-5099.717,-5117.317,-5139.8643,-5153.344,-5159.978,-5152.9233,-5145.76,-5146.7637,-5124.213,-5116.6016,-5116.378,-5083.4863,-5072.7363,-5095.7324,-5099.4785,-5102.464,-5103.066,-5091.845,-5091.442,-5085.2705,-5084.9395,-5097.8916,-5125.791,-5122.198,-5137.435,-5140.4956,-5144.077,-5143.9175,-5131.2153,-5127.865,-5141.522,-5165.447,-5172.7305,-5178.917,-5173.027,-5166.4194,-5155.817,-5144.5723,-5149.6235,-5184.993,-5191.723,-5188.179,-5183.8867,-5176.6016,-5158.434,-5145.7954,-5171.335,-5178.343,-5165.8525,-5132.3506,-5090.064,-5097.0996,-5125.301,-5146.771,-5160.36,-5160.93,-5157.9717,-5153.3994,-5149.14,-5144.304,-5120.7583,-5103.612,-5094.7173,-5079.6133,-5050.52,-5045.0425,-5034.8867,-5034.9355,-5029.134,-5020.8784,-5007.0156,-4986.087,-4976.948,-4962.777,-4938.8906,-4936.965,-4923.3203,-4883.2334,-4868.627,-4886.411,-4873.8394,-4865.4565,-4878.601,-4886.5947,-4882.1553,-4875.667,-4866.071,-4843.7075,-4062.0913,-4089.7747,-4117.4067,-4149.803,-4211.8394,-4264.904,-4311.1343,-4325.558,-4357.713,-4399.1167,-4443.1426,-4475.4946,-4499.7144,-4515.5825,-4538.197,-4566.4585,-4590.2095,-4598.8447,-4639.7866,-4657.356,-4666.743,-4698.045,-4736.8296,-4759.211,-4782.177,-4807.639,-4828.9653,-4847.38,-4871.8926,-4903.136,-4934.516,-4960.157,-4982.125,-5003.7095,-5014.0654,-5030.13,-5046.4575,-5055.3228,-5072.7866,-5089.5913,-5104.5537,-5109.2197,-5112.7524,-5125.525,-5139.169,-5148.7593,-5160.809,-5164.092,-5154.4927,-5135.555,-5135.045,-5117.9663,-5107.3267,-5102.759,-5118.973,-5119.2725,-5107.021,-5087.0723,-5094.4463,-5096.6655,-5103.76,-5117.8643,-5130.289,-5140.233,-5143.6484,-5146.3975,-5138.743,-5127.6055,-5130.2886,-5158.7993,-5176.3535,-5182.441,-5186.871,-5183.3022,-5174.754,-5164.97,-5160.535,-5175.41,-5196.073,-5206.5186,-5199.8047,-5194.0933,-5189.0703,-5178.9937,-5150.2134,-5153.323,-5159.5645,-5169.887,-5146.8,-5115.308,-5115.5767,-5133.057,-5148.5,-5154.45,-5149.3677,-5144.0405,-5144.461,-5150.5723,-5143.8403,-5132.657,-5095.386,-5075.551,-5065.4443,-5067.15,-5077.1416,-5081.704,-5067.818,-5062.577,-5059.4473,-5039.085,-5025.126,-5010.9175,-5002.717,-4985.05,-4964.4966,-4955.6587,-4927.114,-4900.78,-4899.886,-4897.9805,-4882.7583,-4855.8394,-4878.163,-4896.6343,-4887.397,-4871.9785,-4848.6353,-4823.0264,-4178.1567,-4208.0703,-4239.5786,-4290.777,-4308.7305,-4353.564,-4393.846,-4445.793,-4479.95,-4501.876,-4513.709,-4538.7217,-4578.1406,-4608.893,-4635.908,-4649.4214,-4672.4463,-4691.886,-4693.38,-4702.6064,-4716.6045,-4744.3354,-4769.369,-4798.7686,-4819.0264,-4834.7695,-4861.3506,-4882.641,-4901.3696,-4927.4253,-4958.9224,-4974.427,-4998.8994,-5015.4126,-5014.903,-5026.676,-5043.1787,-5064.1206,-5081.4395,-5094.1533,-5102.0938,-5103.146,-5111.312,-5113.0273,-5118.635,-5123.997,-5136.41,-5139.985,-5131.895,-5121.374,-5134.0107,-5134.539,-5124.5625,-5120.501,-5119.966,-5114.084,-5108.786,-5116.7905,-5131.9434,-5134.4517,-5137.0137,-5141.7744,-5155.151,-5161.1875,-5152.6206,-5146.158,-5138.689,-5142.7983,-5160.1636,-5176.646,-5180.286,-5180.6797,-5193.825,-5187.4653,-5179.1753,-5173.9824,-5194.464,-5212.151,-5216.054,-5216.2876,-5206.694,-5195.6147,-5184.012,-5164.163,-5158.6216,-5170.1475,-5187.136,-5208.203,-5177.044,-5167.211,-5164.1084,-5145.121,-5146.9316,-5152.4556,-5145.564,-5145.5435,-5140.232,-5143.8003,-5131.8105,-5103.4316,-5086.9604,-5067.3716,-5064.875,-5078.8804,-5092.166,-5095.9565,-5085.302,-5053.928,-5042.4824,-5027.1436,-5024.521,-5011.7812,-5010.6553,-4997.2847,-4979.6074,-4961.068,-4929.3354,-4907.0786,-4913.8438,-4906.7617,-4884.3667,-4850.7637,-4851.7954,-4865.712,-4861.4575,-4835.69,-4829.285,-4822.7134,-4298.0107,-4332.0645,-4356.232,-4383.545,-4396.1064,-4511.562,-4464.7275,-4510.664,-4544.174,-4575.5396,-4599.5474,-4620.6147,-4643.3784,-4668.5723,-4678.523,-4697.375,-4719.5674,-4739.4287,-4731.547,-4716.145,-4778.5854,-4844.263,-4781.363,-4801.253,-4831.6006,-4849.8467,-4873.7056,-4892.8926,-4913.9766,-4933.8584,-4950.7886,-4966.4927,-4981.7603,-4992.7725,-5007.331,-5023.3623,-5042.8027,-5064.7534,-5079.0645,-5088.1787,-5079.71,-5083.7935,-5096.124,-5102.0244,-5101.655,-5104.178,-5105.8574,-5105.843,-5099.6543,-5103.8667,-5103.479,-5100.6094,-5105.449,-5099.433,-5106.553,-5121.8926,-5131.541,-5140.1885,-5146.8315,-5153.401,-5161.1826,-5165.2407,-5170.303,-5166.1997,-5162.061,-5155.94,-5160.6035,-5178.172,-5185.3584,-5186.708,-5190.2886,-5192.1577,-5182.5186,-5187.511,-5195.955,-5205.2544,-5206.0044,-5203.875,-5211.9067,-5214.209,-5208.979,-5201.8677,-5188.216,-5179.0723,-5162.432,-5151.745,-5173.5283,-5208.885,-5205.926,-5210.9688,-5164.264,-5148.462,-5148.77,-5152.135,-5148.191,-5136.8174,-5122.0425,-5123.0596,-5110.4336,-5097.0107,-5091.5312,-5079.0615,-5077.9204,-5085.4243,-5088.088,-5084.494,-5070.076,-5050.8257,-5036.612,-5019.618,-5008.7793,-4991.4707,-4978.12,-4925.759,-4876.3584,-5141.749,-5165.734,-4840.7505,-4848.506,-4896.885,-4899.341,-4891.373,-4883.3286,-4872.88,-4873.2705,-4864.4956,-4851.082,-4837.219,-4401.764,-4415.9165,-4434.425,-4453.7725,-4475.305,-4512.8633,-4555.6904,-4581.3477,-4607.3765,-4639.1074,-4660.815,-4680.193,-4696.273,-4715.5366,-4727.116,-4750.0093,-4770.8975,-4754.796,-4773.528,-4778.39,-4781.1367,-4789.0522,-4775.69,-4816.236,-4835.8633,-4856.7246,-4895.8926,-4899.5483,-4914.111,-4924.93,-4944.4834,-4958.266,-4968.3296,-4986.988,-4996.7773,-5013.0786,-5028.6484,-5040.827,-5056.094,-5066.2197,-5066.057,-5068.71,-5062.951,-5062.688,-5066.2363,-5074.8037,-5078.632,-5079.3447,-5078.8423,-5080.55,-5079.38,-5076.893,-5088.4556,-5095.3574,-5104.428,-5115.4487,-5126.649,-5141.8706,-5143.7246,-5156.232,-5161.6265,-5164.7715,-5175.378,-5184.812,-5179.219,-5182.1055,-5188.1685,-5192.423,-5194.821,-5192.539,-5186.2246,-5185.694,-5188.2485,-5198.0254,-5206.41,-5209.712,-5188.489,-5190.7915,-5212.8423,-5213.598,-5207.4595,-5197.077,-5201.1147,-5195.3403,-5163.1284,-5121.944,-5107.7666,-5131.9004,-5142.7847,-5159.758,-5157.278,-5158.9404,-5157.7,-5146.1587,-5142.048,-5120.6685,-5129.328,-5126.0913,-5106.655,-5084.484,-5037.8145,-5057.6475,-5096.7827,-5106.3022,-5109.3354,-5094.0527,-5073.352,-5048.784,-5035.4985,-5035.4004,-5021.983,-5002.4155,-4964.3887,-4870.438,-4816.4736,-5315.945,-5378.06,-4819.006,-4854.221,-4927.039,-4938.168,-4927.859,-4909.57,-4895.0537,-4874.936,-4871.2666,-4870.006,-4850.982,-4465.9814,-4477.098,-4484.405,-4523.251,-4547.9824,-4578.28,-4616.0864,-4640.2505,-4667.7646,-4674.1704,-4683.867,-4718.3555,-4745.3477,-4761.476,-4776.642,-4803.1978,-4807.5454,-4824.744,-4841.169,-4840.7847,-4848.539,-4851.5713,-4848.9937,-4849.6235,-4860.176,-4863.62,-4880.3496,-4901.7544,-4905.1,-4921.2886,-4928.846,-4936.5835,-4948.509,-4964.127,-4975.911,-4982.3164,-4990.907,-5002.68,-5009.014,-5011.5024,-5019.3516,-5023.5444,-5025.7505,-5024.472,-5020.3516,-5043.788,-5055.104,-5054.816,-5054.6123,-5061.1724,-5071.3125,-5083.6562,-5087.158,-5089.349,-5087.551,-5092.1245,-5108.2837,-5131.0493,-5134.388,-5149.83,-5149.0176,-5150.434,-5161.578,-5172.4697,-5178.5996,-5200.7236,-5207.5728,-5196.042,-5189.7583,-5183.2627,-5183.7007,-5200.3784,-5208.5483,-5218.104,-5205.0796,-5192.2163,-5191.045,-5197.876,-5204.9995,-5208.0757,-5221.195,-5217.509,-5205.6323,-5188.522,-5158.7324,-5153.0674,-5152.1084,-5122.392,-5146.324,-5178.116,-5173.6616,-5163.085,-5169.4517,-5165.181,-5156.514,-5145.887,-5136.6978,-5121.3174,-5099.33,-5085.765,-5090.158,-5096.221,-5093.564,-5075.764,-5073.046,-5071.054,-5064.537,-5045.207,-5023.183,-5021.154,-5015.171,-4999.1357,-4965.646,-4963.469,-4958.8926,-4927.0894,-4923.9067,-4928.5547,-4936.57,-4933.238,-4930.517,-4924.966,-4913.243,-4890.548,-4871.1006,-4856.598,-4844.7666,-4816.669,-4534.8076,-4555.428,-4578.6055,-4595.3335,-4640.952,-4672.062,-4690.666,-4706.369,-4736.0425,-4746.346,-4755.305,-4754.986,-4777.224,-4802.37,-4832.0425,-4867.0327,-4876.7607,-4878.144,-4874.688,-4880.102,-4882.7354,-4877.547,-4873.8413,-4879.173,-4882.7544,-4891.7705,-4899.912,-4903.3496,-4906.1426,-4914.3335,-4917.7524,-4923.493,-4928.8823,-4930.6504,-4947.3647,-4959.752,-4967.3794,-4971.9023,-4978.272,-4989.873,-4993.3745,-4993.576,-4995.353,-5000.961,-5009.594,-5017.8076,-5021.463,-5026.5586,-5037.8306,-5052.3887,-5061.4517,-5070.2036,-5074.4863,-5080.055,-5086.3145,-5095.9287,-5099.5044,-5120.1655,-5132.1304,-5136.232,-5136.612,-5142.5474,-5152.519,-5160.1235,-5167.255,-5163.0664,-5157.184,-5167.1675,-5176.084,-5174.5903,-5186.6133,-5193.1147,-5188.691,-5184.1978,-5180.4795,-5188.7637,-5206.4976,-5205.777,-5203.504,-5213.6987,-5216.1753,-5196.3594,-5181.621,-5173.698,-5182.037,-5178.9,-5180.227,-5172.3433,-5180.9165,-5183.1934,-5170.52,-5139.068,-5153.7554,-5159.6304,-5152.7573,-5139.9272,-5120.7227,-5100.7456,-5081.0264,-5072.5195,-5075.675,-5076.8994,-5061.8057,-5030.511,-4994.7695,-5148.209,-5023.495,-4986.0103,-5010.928,-5006.4673,-5007.461,-5013.8877,-4996.1396,-4993.4937,-4991.817,-4980.6694,-4963.3647,-4930.041,-4900.9526,-4884.085,-4891.0293,-4892.1836,-4891.5786,-4872.6797,-4855.254,-4840.1694,-4819.5635,-4792.4043,-4622.586,-4637.9766,-4659.8867,-4677.18,-4691.842,-4727.9893,-4752.66,-4769.055,-4782.713,-4786.6284,-4793.5317,-4779.367,-4795.574,-4828.9146,-4844.886,-4868.571,-4897.129,-4899.823,-4908.7256,-4909.088,-4911.0522,-4895.783,-4889.8496,-4913.551,-4918.077,-4910.8374,-4911.866,-4912.1597,-4921.8813,-4912.982,-4908.291,-4918.2197,-4929.69,-4937.8335,-4943.8545,-4948.9062,-4953.9297,-4936.5244,-4951.979,-4970.861,-4978.0264,-4973.6294,-4970.845,-4977.9937,-4991.7373,-5008.5107,-5026.013,-5040.144,-5040.4233,-5051.2734,-5058.6694,-5059.066,-5063.2007,-5072.3604,-5084.4526,-5093.1494,-5102.3735,-5111.057,-5127.5146,-5143.9727,-5153.7256,-5158.099,-5164.6997,-5160.7217,-5133.8022,-5102.628,-5120.6475,-5153.304,-5157.024,-5159.6274,-5163.553,-5169.2837,-5175.874,-5180.663,-5181.217,-5203.5015,-5214.3,-5213.621,-5209.175,-5209.4326,-5194.534,-5176.926,-5174.903,-5191.017,-5177.522,-5195.455,-5210.1816,-5202.438,-5195.899,-5187.837,-5173.132,-5150.1035,-5148.1523,-5144.4326,-5133.3765,-5117.5557,-5107.6523,-5083.8745,-5048.868,-5036.3374,-5043.4346,-5066.7246,-5050.0327,-5034.9946,-4997.0967,-4976.282,-4979.9385,-4996.6064,-5007.3516,-5003.647,-5008.6445,-5012.651,-5005.0786,-4998.917,-4990.0615,-4974.9634,-4958.816,-4945.0454,-4918.35,-4899.487,-4890.2065,-4898.242,-4879.3516,-4868.161,-4857.296,-4854.8276,-4848.993,-4842.9653,-4700.186,-4705.1997,-4708.8105,-4719.588,-4746.949,-4769.3413,-4745.637,-4778.494,-4814.9634,-4814.1514,-4812.6016,-4817.5425,-4834.5015,-4854.1655,-4868.2153,-4881.3516,-4903.513,-4922.4185,-4943.8696,-4957.7456,-4945.298,-4948.06,-4954.63,-4958.6636,-4949.552,-4952.5884,-4959.2554,-4947.6924,-4955.5034,-4945.7085,-4948.133,-4941.295,-4934.379,-4926.7397,-4931.786,-4936.525,-4928.924,-4925.2896,-4927.523,-4946.998,-4965.2026,-4974.7754,-4983.8594,-4993.033,-5000.5137,-5000.128,-5020.004,-5024.5796,-5032.641,-5049.5435,-5051.386,-5049.9546,-5051.411,-5059.3496,-5068.375,-5078.602,-5090.795,-5105.4736,-5121.681,-5134.8657,-5129.697,-5119.9,-5113.1274,-5117.5205,-5122.1807,-5131.6797,-5136.5283,-5131.846,-5128.733,-5155.529,-5180.7915,-5181.6016,-5191.924,-5207.1313,-5207.4194,-5205.362,-5213.371,-5216.912,-5209.151,-5194.651,-5165.927,-5168.569,-5185.8477,-5194.3223,-5205.586,-5208.33,-5207.372,-5206.088,-5206.191,-5198.6045,-5184.9473,-5171.4663,-5160.2827,-5145.3403,-5129.5303,-5108.1836,-5089.84,-5073.3716,-5062.491,-5070.1514,-5075.4717,-5070.547,-5059.565,-5045.3306,-5037.635,-5026.251,-5012.1733,-5002.158,-5002.8647,-4980.582,-5002.235,-4981.8306,-4987.259,-4985.1567,-4981.421,-4972.327,-4960.0117,-4948.4546,-4934.459,-4924.656,-4916.6274,-4903.7666,-4896.724,-4889.565,-4876.7793,-4875.9175,-4869.762,-4852.327,-4738.412,-4724.2866,-4710.234,-4705.753,-4740.437,-4798.4736,-4780.1597,-4749.005,-4827.459,-4847.8765,-4839.574,-4844.5103,-4861.8076,-4903.828,-4906.832,-4918.8706,-4920.8447,-4918.4946,-4936.8516,-4944.216,-4965.857,-4976.642,-4989.375,-4976.534,-4961.726,-4992.0293,-4997.2026,-4981.1807,-4966.731,-4954.071,-4946.6616,-4943.705,-4939.7324,-4931.8438,-4934.1177,-4934.6587,-4922.8896,-4927.6777,-4941.969,-4972.157,-4986.746,-4998.8506,-5005.402,-5003.272,-5001.53,-5013.3335,-5027.966,-5040.21,-5055.1045,-5068.9746,-5078.7583,-5082.6943,-5092.512,-5092.544,-5090.539,-5091.4165,-5094.0913,-5104.838,-5123.141,-5117.512,-5089.1816,-5091.9785,-5101.2944,-5118.6333,-5121.325,-5127.117,-5123.128,-5128.56,-5150.043,-5157.894,-5148.9775,-5170.873,-5175.794,-5168.7793,-5141.1,-5165.948,-5198.4336,-5205.0796,-5193.334,-5181.1562,-5178.5874,-5176.307,-5177.6494,-5190.6665,-5203.381,-5212.464,-5213.037,-5211.6074,-5201.574,-5187.852,-5184.029,-5171.5317,-5153.99,-5121.4873,-5108.768,-5091.9507,-5079.782,-5085.7725,-5099.7065,-5102.312,-5087.952,-5068.554,-5070.4927,-5062.797,-5054.1494,-5041.1895,-5028.0957,-5010.302,-4987.9976,-4952.011,-4973.6577,-4962.325,-4966.7866,-4967.992,-4969.8984,-4964.648,-4954.916,-4941.7725,-4925.165,-4916.2036,-4908.158,-4898.4844,-4884.6016,-4877.5317,-4868.018,-4868.8086,-4855.7275,-4841.5527,-4762.5225,-4748.9756,-4715.682,-4748.85,-4800.0493,-4817.53,-4814.658,-4810.2275,-4820.3384,-4836.0854,-4848.7485,-4880.4385,-4895.816,-4920.0874,-4926.896,-4929.4126,-4932.7163,-4952.2393,-4962.132,-4966.2407,-4980.59,-4979.5776,-4983.448,-4980.0605,-4974.0,-4973.6187,-4980.879,-4974.801,-4958.63,-4945.0044,-4983.7227,-4995.3584,-4983.2344,-4976.207,-4973.053,-4972.566,-4978.344,-4987.664,-4995.995,-5002.965,-5007.4824,-5012.7495,-5016.1562,-5029.1445,-5043.3003,-5049.6387,-5063.0366,-5077.9766,-5088.779,-5108.976,-5115.016,-5113.4287,-5112.504,-5116.923,-5123.4116,-5132.2856,-5135.824,-5132.563,-5123.3057,-5096.8506,-5084.394,-5101.8735,-5121.706,-5130.7783,-5118.812,-5110.8774,-5100.8457,-5110.306,-5120.9844,-5118.2437,-5097.1836,-5141.17,-5156.8296,-5167.3823,-5176.808,-5175.2466,-5183.8706,-5188.9097,-5182.675,-5176.9873,-5175.461,-5166.2656,-5174.826,-5184.023,-5189.162,-5199.8154,-5202.492,-5195.8105,-5183.3022,-5169.8193,-5169.637,-5157.394,-5134.515,-5112.165,-5102.4927,-5094.359,-5093.735,-5085.7974,-5078.1997,-5095.018,-5074.49,-5071.308,-5069.3228,-5053.713,-5047.274,-5041.6733,-5007.083,-4972.493,-5025.0864,-4961.629,-4963.0757,-4976.1855,-4969.78,-4951.5503,-4952.277,-4948.0205,-4929.135,-4922.918,-4914.557,-4897.067,-4880.378,-4867.447,-4861.454,-4860.5054,-4852.686,-4855.7295,-4844.87,-4812.3535,-4770.824,-4756.824,-4762.3,-4763.289,-4800.271,-4822.915,-4835.486,-4837.643,-4838.3403,-4856.408,-4883.5503,-4904.8438,-4922.1265,-4941.5645,-4950.2485,-4954.271,-4970.013,-4980.5415,-4966.5767,-4961.8,-4974.323,-4979.5884,-4980.2954,-4992.2393,-4994.158,-4993.8555,-5005.433,-5020.4595,-5035.604,-4966.417,-5044.5825,-5031.147,-4998.124,-4981.7812,-4984.5596,-4991.2275,-4999.0776,-5007.9414,-5018.481,-5026.5405,-5039.009,-5058.15,-5069.436,-5078.7637,-5083.9966,-5094.1924,-5106.6797,-5111.112,-5115.6694,-5134.094,-5146.3696,-5141.3135,-5133.728,-5133.3516,-5132.896,-5134.066,-5135.5117,-5125.562,-5102.842,-5098.6094,-5110.4595,-5108.847,-5114.5303,-5120.3247,-5115.9146,-5120.38,-5130.3545,-5143.49,-5120.126,-5127.669,-5150.877,-5157.8906,-5162.8745,-5166.059,-5168.123,-5161.268,-5168.1714,-5172.972,-5166.731,-5160.7217,-5152.9062,-5147.038,-5149.862,-5152.427,-5153.501,-5162.5977,-5168.0815,-5159.69,-5149.0503,-5148.6816,-5148.444,-5139.2153,-5127.7227,-5113.015,-5102.4155,-5095.4,-5101.992,-5092.878,-5073.8936,-5092.2163,-5058.2485,-5074.342,-5071.392,-5059.938,-5058.547,-5036.574,-4996.217,-4980.6885,-5024.112,-4996.0674,-4966.947,-4962.3174,-4944.228,-4932.025,-4927.977,-4908.8774,-4887.074,-4884.3066,-4889.6006,-4875.464,-4860.9053,-4833.417,-4843.9424,-4857.0894,-4853.063,-4851.2207,-4845.2827,-4833.7363,-4903.9956,-4884.8857,-4845.7554,-4840.478,-4839.0493,-4842.8066,-4854.245,-4866.0957,-4876.1265,-4881.235,-4900.1084,-4915.1953,-4926.2266,-4950.5703,-4964.609,-4973.367,-4973.507,-4973.5107,-4975.7856,-4973.4185,-4968.0156,-4974.9355,-4992.0312,-5018.6416,-5032.3584,-5048.271,-5061.751,-5077.8994,-5085.1333,-5084.149,-5077.4414,-5069.048,-5061.4697,-5050.788,-5028.302,-5021.7676,-5024.044,-5033.14,-5048.352,-5067.0776,-5092.9097,-5116.188,-5122.1313,-5131.288,-5139.389,-5147.048,-5141.5137,-5129.268,-5129.322,-5133.251,-5151.676,-5157.3735,-5154.1484,-5156.444,-5155.8735,-5148.9893,-5143.614,-5132.7983,-5121.3286,-5115.4375,-5100.52,-5085.408,-5095.9497,-5098.9,-5098.067,-5111.6177,-5117.172,-5109.1313,-5119.1777,-5137.4595,-5143.7705,-5158.0967,-5162.045,-5137.954,-5147.0674,-5157.995,-5147.931,-5152.6997,-5166.124,-5166.271,-5150.9297,-5144.29,-5154.376,-5179.511,-5151.538,-5129.044,-5131.06,-5131.767,-5123.118,-5120.383,-5121.5527,-5117.1406,-5109.236,-5113.213,-5110.394,-5105.2593,-5104.503,-5096.9614,-5088.821,-5081.845,-5074.7544,-5068.15,-5066.666,-5062.2896,-5065.6836,-5061.619,-5046.7217,-5027.294,-5015.0723,-5007.2627,-4986.339,-4966.347,-4948.2837,-4922.917,-4920.8267,-4895.1953,-4848.833,-4849.979,-4860.671,-4866.792,-4871.639,-4872.143,-4864.08,-4850.576,-4843.5957,-4843.993,-4838.3145,-4836.9385,-4909.7227,-4906.1455,-4884.1436,-4879.062,-4885.3286,-4884.611,-4891.2124,-4906.0703,-4916.9766,-4922.5674,-4938.706,-4943.0063,-4949.8975,-4957.812,-4975.0317,-4993.441,-4999.313,-5003.006,-4990.9688,-4975.872,-4966.2812,-4964.4766,-4983.0693,-5018.114,-5044.329,-5054.079,-5065.879,-5073.333,-5031.9487,-5051.5845,-5095.5474,-5104.8203,-5100.4907,-5104.004,-5108.323,-5105.462,-5105.1855,-5105.7124,-5110.5103,-5115.426,-5125.162,-5132.8467,-5148.7085,-5154.552,-5156.512,-5157.9897,-4987.8296,-4886.444,-4892.8877,-5032.401,-5014.0293,-5030.4604,-5141.7627,-5160.7734,-5136.824,-5121.2993,-5110.762,-5094.9873,-5089.407,-5087.152,-5087.226,-5092.466,-5096.1855,-5103.62,-5105.083,-5094.2866,-5087.3506,-5092.9634,-5101.329,-5104.193,-5109.657,-5125.28,-5148.3726,-5140.772,-5123.3306,-5133.447,-5130.6777,-5135.5576,-5147.953,-5148.953,-5127.977,-5119.554,-5112.494,-5110.843,-5113.9194,-5106.317,-5107.028,-5090.9053,-5084.7505,-5093.3623,-5093.0825,-5091.485,-5099.86,-5104.7534,-5101.643,-5097.3984,-5093.342,-5081.943,-5069.085,-5063.2993,-5061.661,-5044.628,-5030.609,-5022.888,-5018.54,-5016.1504,-5008.158,-4998.217,-4995.0176,-4988.776,-4985.7754,-4969.634,-4962.4106,-4947.7974,-4930.557,-4909.4355,-4891.931,-4863.2715,-4853.6533,-4843.402,-4846.2744,-4855.0933,-4876.1367,-4881.5273,-4873.396,-4861.7686,-4848.9893,-4843.615,-4867.233,-4881.858,-4899.105,-4901.5405,-4908.9214,-4928.611,-4944.114,-4959.494,-4953.7344,-4953.634,-4964.8506,-4966.2734,-4974.271,-4972.667,-4977.3804,-4985.3164,-5000.4536,-5017.888,-5023.552,-5015.188,-5013.2153,-4979.264,-5036.016,-5048.6406,-5061.4087,-5064.301,-5060.1963,-5044.196,-5014.4863,-5099.594,-5125.836,-5144.0576,-5135.982,-5118.4727,-5113.4536,-5126.7866,-5136.944,-5136.494,-5132.73,-5143.903,-5148.988,-5153.595,-5139.219,-5139.004,-5157.6084,-5150.1562,-4802.0254,-4526.2935,-4600.651,-4745.415,-4795.921,-4915.5483,-5033.7373,-5086.16,-5089.9546,-5112.0586,-5126.0938,-5131.6035,-5112.871,-5112.68,-5102.3926,-5103.6606,-5100.817,-5100.6226,-5102.213,-5096.671,-5087.3257,-5083.034,-5080.022,-5079.996,-5088.775,-5090.95,-5088.7524,-5099.579,-5105.019,-5101.6694,-5109.2227,-5114.9263,-5118.08,-5117.9434,-5114.943,-5099.1157,-5088.7964,-5097.2026,-5092.3,-5089.737,-5092.928,-5093.549,-5090.866,-5087.6484,-5075.4556,-5076.19,-5082.6147,-5090.787,-5111.363,-5126.516,-5129.758,-5118.026,-5086.1577,-5076.916,-5072.986,-5050.56,-5022.084,-5011.7124,-5019.267,-5001.8887,-4991.7266,-4984.0005,-4982.7666,-4963.6304,-4959.8525,-4967.9546,-4961.6685,-4953.111,-4938.4224,-4925.731,-4910.6357,-4885.6665,-4871.5063,-4861.805,-4858.673,-4864.2397,-4880.276,-4890.905,-4890.4775,-4883.523,-4858.3877,-4850.4653,-4884.662,-4901.987,-4909.171,-4898.611,-4909.9517,-4921.9062,-4927.102,-4930.8105,-4937.5005,-4950.3774,-4958.4155,-4964.761,-4968.9185,-4977.2095,-4985.0576,-4989.9,-4989.3477,-4994.437,-5012.0825,-5016.007,-5018.9375,-5024.9253,-5031.877,-5043.037,-5050.8975,-5059.915,-5070.4165,-5083.0728,-5097.4604,-5121.768,-5130.056,-5105.2734,-5068.272,-5110.639,-5127.5283,-5144.798,-5152.655,-5158.658,-5167.8438,-5172.1836,-5184.092,-5193.442,-5223.3003,-5214.6577,-5188.709,-5171.5244,-5063.383,-5039.1025,-5093.7344,-5066.3184,-5024.1396,-5027.5645,-5036.0747,-5054.303,-5083.843,-5126.233,-5166.486,-5181.4697,-5175.8755,-5172.7534,-5169.0444,-5157.5186,-5155.6665,-5156.544,-5147.5537,-5127.6187,-5115.913,-5111.9624,-5105.717,-5098.271,-5094.462,-5086.8276,-5074.7324,-5077.032,-5081.101,-5079.9766,-5083.3193,-5085.69,-5083.5728,-5080.5903,-5083.3906,-5085.107,-5093.073,-5091.5205,-5063.309,-5048.8506,-5064.2485,-5086.1523,-5064.387,-5082.742,-5109.248,-5099.023,-5100.007,-5099.7837,-5094.9307,-5115.4844,-5113.8833,-5072.9224,-5058.7065,-5074.1636,-5083.58,-5070.961,-5042.0815,-5006.7354,-4992.9663,-4983.4507,-4973.9316,-4972.7964,-4975.212,-4972.2173,-4973.8574,-4971.5776,-4959.531,-4948.222,-4940.512,-4929.389,-4913.1655,-4885.4893,-4865.4233,-4856.7993,-4853.672,-4852.4473,-4865.1016,-4866.8154,-4866.505,-4860.8228,-4852.4775,-4829.423,-4877.9634,-4897.856,-4897.549,-4903.9106,-4919.245,-4920.9404,-4918.21,-4931.967,-4931.5767,-4938.0723,-4945.4414,-4955.5054,-4967.012,-4977.2666,-4981.7646,-5005.124,-5010.976,-5019.41,-5017.2983,-5030.642,-5041.4717,-5018.774,-5039.681,-5048.85,-5066.1006,-5070.623,-5079.3906,-5086.1104,-5088.109,-5093.282,-5100.045,-5102.6724,-5110.9814,-5134.8813,-5147.1704,-5152.673,-5152.611,-5152.3545,-5163.055,-5162.1587,-5169.06,-5155.3833,-5172.055,-5179.9585,-5169.5024,-5166.537,-5168.396,-5178.0093,-5172.787,-5165.214,-5166.967,-5176.577,-5173.4814,-5164.881,-5155.7324,-5148.199,-5143.3467,-5157.609,-5204.8076,-5230.0405,-5213.734,-5201.4336,-5191.847,-5175.5913,-5155.261,-5144.244,-5131.082,-5123.225,-5120.4814,-5108.045,-5092.7207,-5081.3213,-5077.5776,-5072.5605,-5064.907,-5055.65,-5055.3022,-5064.7827,-5061.7896,-5055.193,-5055.996,-5059.5205,-5067.5664,-5062.37,-5016.932,-4965.385,-4961.6143,-5063.7627,-4948.3027,-4964.101,-4973.604,-4987.483,-5002.684,-5017.7007,-5025.09,-5039.1514,-5052.511,-5037.325,-5017.466,-5000.1943,-4996.743,-5003.1143,-4990.593,-4965.17,-4950.833,-4948.835,-4932.851,-4905.4824,-4875.926,-4829.7017,-4822.147,-4854.818,-4916.0977,-4871.8594,-4814.9434,-4788.2207,-4777.029,-4778.978,-4786.156,-4791.17,-4742.7314,-4699.9644,-4667.9644,-4620.5864,-4576.296,-4527.6543,-4524.1997,-4531.1333,-4871.141,-4878.099,-4894.4194,-4894.988,-4909.226,-4920.2954,-4934.053,-4949.0786,-4955.795,-4966.133,-4978.1733,-4990.348,-5001.9175,-5000.824,-5005.0444,-5020.7515,-5023.2847,-5019.5264,-5017.545,-5012.8735,-5020.4883,-5024.4663,-5033.863,-5038.6553,-5037.1816,-5043.782,-5063.5103,-5082.1816,-5085.027,-5084.414,-5079.2183,-5068.416,-5067.2983,-5067.8574,-5076.026,-5093.5137,-5105.494,-5107.606,-5121.344,-5133.13,-5131.772,-5128.1836,-5129.684,-5135.026,-5149.093,-5133.5625,-5135.2036,-5135.312,-5103.469,-5072.365,-5024.9414,-5021.195,-5024.8237,-5066.7344,-5097.717,-5150.9644,-5237.092,-5197.741,-5179.0835,-5207.698,-5208.1284,-5198.5723,-5180.9663,-5161.4146,-5139.35,-5127.0664,-5116.7676,-5106.4185,-5096.102,-5088.078,-5085.6895,-5082.463,-5069.6655,-5060.1772,-5053.265,-5025.647,-4999.4043,-4983.9165,-4978.336,-4978.4062,-4984.0376,-4991.389,-4988.868,-4991.665,-4984.1836,-4977.0493,-4973.2837,-4971.406,-4946.5293,-4924.844,-4920.054,-4927.731,-4945.241,-4928.2334,-4900.421,-4925.832,-4882.516,-4864.8994,-4827.106,-4825.5205,-4849.1533,-4867.4385,-4815.5337,-4753.9727,-4702.418,-4599.713,-4535.0166,-4497.3965,-4474.929,-4495.8936,-4583.9873,-4732.137,-4738.9756,-4586.015,-4426.528,-4284.721,-4194.478,-4106.5386,-4041.076,-4043.7424,-4177.006,-4291.9717,-4242.001,-4270.3228,-4112.302,-3984.7034,-3921.1682,-3882.505,-4907.9346,-4912.075,-4916.7695,-4923.436,-4932.4053,-4944.0586,-4953.291,-4952.408,-4967.065,-4979.4497,-4988.911,-4991.8774,-4977.797,-4970.2754,-4970.7354,-4918.153,-4863.1426,-4847.692,-4851.6772,-4858.814,-4856.88,-4856.1187,-4862.0527,-4875.9683,-4891.349,-4911.1855,-4935.5366,-4948.4585,-4969.1855,-4997.146,-5030.007,-5052.165,-5072.479,-5091.7065,-5098.915,-5091.099,-5083.2783,-5092.823,-5087.946,-5089.0444,-5092.894,-5100.338,-5081.4287,-5043.757,-5020.501,-4951.7617,-4888.135,-4870.165,-4871.4326,-4886.628,-4903.923,-4912.5693,-4917.615,-4926.1055,-4927.497,-4958.5566,-5060.4683,-5173.418,-5196.0327,-5181.3994,-5169.5845,-5138.085,-5101.8755,-5065.964,-5039.756,-5021.4585,-5006.042,-4989.164,-4979.2935,-4983.437,-4998.5713,-4984.9517,-4956.6997,-4932.125,-4908.5737,-4889.5356,-4878.2246,-4873.1157,-4867.1313,-4865.2783,-4826.022,-4837.093,-4801.8003,-4746.885,-4707.3325,-4775.2603,-4809.0786,-4738.5103,-4673.754,-4599.8213,-4513.4414,-4445.7524,-4429.187,-4487.0645,-4498.9927,-4470.319,-4450.6377,-4428.2964,-4333.5947,-4239.068,-4164.0664,-4093.4026,-4087.7344,-4156.609,-4279.7354,-4299.8374,-4257.1562,-4166.377,-4055.9128,-3987.3438,-3949.1667,-3889.0146,-3815.741,-3823.3564,-3858.234,-3894.2876,-3868.7705,-3878.5295,-3874.1897,-3887.9194,-3872.3877,-3825.0334,-3742.056,-3707.3477,-3724.9978,-3719.5408,-3696.152,-3664.0964,-4922.9795,-4943.314,-4946.0425,-4937.831,-4916.15,-4886.752,-4852.42,-4821.7676,-4819.576,-4827.0034,-4840.119,-4845.218,-4836.2686,-4851.139,-4703.1284,-4556.0073,-4577.6426,-4594.709,-4554.591,-4531.6167,-4574.5938,-4607.7466,-4598.661,-4599.9346,-4634.674,-4654.633,-4677.0117,-4743.584,-4854.287,-4936.523,-4983.984,-5020.0825,-4985.1284,-4914.53,-4827.338,-4682.835,-4596.7646,-4594.0566,-4661.2715,-4851.498,-5009.1533,-5033.5107,-5036.515,-4991.831,-4876.1484,-4846.6914,-4848.533,-4854.2363,-4854.5483,-4870.3784,-4890.3276,-4889.579,-4892.1167,-4904.0615,-4919.6772,-4940.6533,-4966.5054,-4985.0083,-5012.919,-5038.0503,-5098.3945,-5059.588,-4982.123,-4893.6904,-4843.815,-4822.794,-4825.2056,-4802.4106,-4757.221,-4717.515,-4661.7495,-4649.6846,-4686.4766,-4706.1396,-4669.471,-4640.5767,-4593.527,-4492.2246,-4424.768,-4434.907,-4567.319,-4531.4707,-4462.2954,-4495.6313,-4507.24,-4422.993,-4264.5884,-4161.1045,-4158.2925,-4146.365,-4092.128,-4129.948,-4261.7324,-4290.286,-4161.1616,-4040.5808,-3944.188,-3915.2458,-3931.2502,-3975.3225,-4023.7092,-4023.421,-3893.796,-3791.2324,-3728.6665,-3717.523,-3710.2334,-3685.557,-3658.4817,-3661.8774,-3753.7576,-3688.5408,-3654.8096,-3690.5908,-3706.6301,-3606.2866,-3551.798,-3543.885,-3529.7007,-3495.1807,-3502.5798,-3532.0708,-3518.2654,-3493.348,-3465.1628,-3425.183,-3406.7983,-3392.6042,-4606.7617,-4606.321,-4639.817,-4634.571,-4649.8086,-4695.8623,-4718.9897,-4726.003,-4719.9346,-4735.5293,-4785.6094,-4808.0024,-4802.381,-4759.151,-4693.4404,-4629.7017,-4567.304,-4543.157,-4434.899,-4331.4707,-4277.8604,-4252.902,-4313.204,-4453.0845,-4647.309,-4832.771,-4827.0454,-4605.58,-4332.692,-4163.572,-4058.3066,-3990.0605,-3964.1663,-3954.466,-3936.1643,-3935.5293,-3953.1868,-3981.6096,-4021.016,-4064.121,-4127.1587,-4188.953,-4321.849,-4546.8374,-4731.475,-4778.4053,-4803.277,-4820.884,-4847.8237,-4866.65,-4877.793,-4885.016,-4898.751,-4904.1978,-4915.9336,-4920.5615,-4927.275,-4941.6235,-4961.8975,-4965.1694,-4938.3867,-4897.4863,-4835.373,-4751.797,-4685.149,-4653.922,-4614.0454,-4543.1343,-4494.4707,-4482.071,-4501.0747,-4483.2427,-4435.0977,-4353.348,-4295.9194,-4298.5024,-4256.066,-4180.679,-4146.7573,-4164.8257,-4239.806,-4253.7476,-4189.0474,-4065.682,-4008.7002,-3993.784,-4016.4397,-4026.1853,-3980.9045,-3950.709,-3967.7378,-3986.6643,-3927.565,-3810.8687,-3774.9304,-3771.7505,-3800.172,-3828.0222,-3792.6902,-3713.549,-3650.9521,-3626.2388,-3619.923,-3612.4995,-3659.1584,-3700.3633,-3575.0542,-3526.308,-3508.0896,-3499.8542,-3481.748,-3469.183,-3453.876,-3445.404,-3459.4841,-3439.9958,-3405.3137,-3378.487,-3353.8535,-3345.4,-3342.6155,-3359.718,-3358.026,-3329.934,-3304.9233,-3286.2246,-3280.8313,-3272.0637,-4053.6985,-4061.329,-4082.4277,-4075.345,-4059.0981,-4063.6313,-4069.9556,-4082.7034,-4091.6733,-4116.935,-4165.1875,-4208.1846,-4261.452,-4388.003,-4485.0156,-4567.217,-4612.5103,-4670.0527,-4728.58,-4655.8115,-4556.0728,-4570.674,-4655.1167,-4681.791,-4738.167,-4688.293,-4364.7236,-4132.68,-4091.589,-4019.4944,-3919.7017,-3910.2363,-3908.013,-3903.3164,-3890.8015,-3879.5815,-3877.1245,-3885.0193,-3898.225,-3893.8145,-3910.8467,-3960.7007,-4041.2085,-4151.7817,-4339.225,-4550.2695,-4651.1694,-4752.7114,-4801.2847,-4822.0796,-4843.6016,-4864.4795,-4879.112,-4886.07,-4894.135,-4909.1357,-4921.983,-4934.2397,-4945.9277,-4947.4414,-4946.7725,-4940.7603,-4917.654,-4880.246,-4804.373,-4711.447,-4618.4766,-4531.6704,-4460.153,-4425.088,-4371.3926,-4301.811,-4249.948,-4245.9937,-4267.1704,-4219.9497,-4128.347,-4080.8162,-4066.4873,-4072.675,-4057.2617,-3995.2969,-3947.9995,-3924.905,-3907.0256,-3907.4417,-3928.914,-3885.6206,-3836.9194,-3834.1086,-3832.0164,-3785.2463,-3745.9785,-3717.6455,-3698.814,-3686.2373,-3692.2617,-3662.621,-3621.889,-3590.997,-3579.12,-3562.5217,-3562.877,-3558.1606,-3618.8054,-3602.2554,-3520.8296,-3483.9358,-3461.37,-3443.919,-3422.517,-3406.52,-3395.1152,-3384.4695,-3381.0906,-3370.8162,-3354.613,-3328.9578,-3306.7307,-3293.8772,-3288.2588,-3281.274,-3269.222,-3259.842,-3247.6802,-3233.2397,-3221.0144,-3208.259,-3673.8188,-3687.8188,-3693.6912,-3699.1365,-3703.7615,-3714.282,-3736.8572,-3767.5078,-3801.3638,-3826.0469,-3844.6897,-3861.1042,-3874.8105,-3885.2505,-3892.4534,-3900.9614,-3925.3267,-3976.9868,-4047.1677,-4137.802,-4209.921,-4209.6494,-4210.4517,-4228.5723,-4196.571,-4086.4883,-3987.4233,-3965.4436,-3972.6042,-3967.829,-3946.2188,-3925.019,-3904.755,-3879.9963,-3851.4724,-3833.7834,-3824.5981,-3817.126,-3815.5312,-3813.7922,-3826.8755,-3875.3955,-3919.5354,-3836.8047,-3937.859,-4147.7095,-4283.1973,-4301.3745,-4332.6704,-4348.252,-4393.4766,-4489.2007,-4628.201,-4724.476,-4779.4053,-4814.313,-4829.8975,-4825.063,-4804.213,-4820.89,-4859.1484,-4906.592,-4937.2476,-4938.7554,-4933.105,-4921.4023,-4898.015,-4857.0522,-4796.1567,-4715.608,-4626.8364,-4530.2974,-4457.544,-4406.0767,-4390.9883,-4350.85,-4299.571,-4254.715,-4215.424,-4157.949,-4127.251,-4075.552,-4029.929,-3993.0898,-3966.2283,-3945.3962,-3942.5251,-3919.6458,-3882.901,-3845.5818,-3820.9275,-3803.0293,-3783.0525,-3763.8257,-3736.3572,-3711.7163,-3693.7153,-3680.5496,-3669.87,-3658.5266,-3635.1116,-3613.9204,-3595.4243,-3581.8528,-3566.1545,-3566.4568,-3565.736,-3554.849,-3532.9675,-3511.199,-3486.798,-3462.6926,-3444.552,-3423.267,-3411.134,-3396.7122,-3390.381,-3383.7883,-3369.6956,-3352.502,-3337.8174,-3324.6726,-3316.6606,-3311.2063,-3309.221,-3306.8696,-3302.8682,-3298.8494,-3452.8699,-3459.1567,-3462.71,-3469.186,-3479.7373,-3498.0994,-3518.221,-3540.5823,-3554.4856,-3546.395,-3543.1921,-3551.4573,-3569.799,-3599.2893,-3636.423,-3665.7698,-3677.479,-3676.786,-3667.9512,-3696.2488,-3756.7185,-3807.585,-3837.4092,-3852.5696,-3862.429,-3870.7031,-3865.2183,-3865.7805,-3867.9219,-3858.211,-3840.1294,-3817.8323,-3802.3657,-3792.4082,-3787.083,-3779.4026,-3770.679,-3758.4504,-3745.0225,-3732.0518,-3720.069,-3712.6414,-3703.0337,-3686.0874,-3657.9058,-3668.1555,-3722.3857,-3781.4846,-3827.3843,-3852.3406,-3884.2876,-3987.417,-4077.4233,-4148.933,-4208.5234,-4279.533,-4338.077,-4401.749,-4461.0537,-4528.6284,-4608.575,-4677.2803,-4741.788,-4783.621,-4813.667,-4851.505,-4887.4653,-4910.504,-4924.9463,-4917.7305,-4899.589,-4882.352,-4848.7256,-4809.1,-4769.6597,-4728.3735,-4686.662,-4642.765,-4602.658,-4560.18,-4522.3066,-4490.8765,-4450.8384,-4393.25,-4344.8276,-4297.1367,-4245.909,-4201.875,-4172.793,-4144.5938,-4108.9116,-4066.0925,-4027.3323,-3977.0083,-3938.4932,-3908.2773,-3885.3638,-3873.607,-3866.85,-3859.9167,-3868.8647,-3876.8853,-3848.2893,-3816.5376,-3792.9185,-3766.1887,-3744.3113,-3714.0706,-3685.1067,-3662.0254,-3634.4958,-3605.219,-3580.154,-3557.452,-3536.5527,-3518.1067,-3503.0515,-3491.7712,-3485.059,-3481.718,-3481.7046,-3483.7537,-3487.7651,-3492.7024,-3500.699,-3509.4512,-3517.9316,-3527.0134,-3174.665,-3168.3792,-3156.46,-3150.5337,-3149.954,-3155.9197,-3164.1294,-3179.4768,-3196.2393,-3205.785,-3209.847,-3219.1345,-3228.8281,-3237.383,-3247.617,-3262.276,-3276.5588,-3291.8545,-3310.1755,-3332.3994,-3353.3691,-3375.622,-3395.4714,-3428.0122,-3456.193,-3496.3086,-3545.2793,-3587.8015,-3613.032,-3624.8704,-3621.2302,-3619.183,-3620.3684,-3624.8962,-3631.9526,-3641.079,-3646.482,-3646.0833,-3642.9429,-3636.4329,-3628.5334,-3619.8298,-3614.9395,-3614.4907,-3613.8484,-3610.9182,-3611.3762,-3607.5522,-3608.7932,-3613.0193,-3617.371,-3624.9067,-3631.673,-3639.7405,-3718.3354,-3804.3513,-3874.646,-3904.4573,-3913.0347,-3910.5688,-3896.7505,-3895.651,-3908.9893,-3980.6077,-4066.7283,-4161.483,-4246.4727,-4334.815,-4402.535,-4471.909,-4533.1543,-4587.304,-4633.5938,-4677.5884,-4716.475,-4758.4556,-4791.7446,-4812.4995,-4809.0244,-4798.2217,-4790.919,-4784.985,-4779.061,-4772.202,-4765.7144,-4758.455,-4752.395,-4745.085,-4735.711,-4720.198,-4703.7686,-4693.805,-4685.3394,-4680.1606,-4666.1343,-4663.246,-4669.885,-4691.951,-4736.82,-4791.5615,-4832.076,-4838.322,-4764.5103,-4587.118,-4287.0225,-4180.953,-4106.33,-4056.0002,-4016.4182,-3983.7588,-3955.592,-3910.1733,-3872.708,-3850.119,-3840.2844,-3840.7522,-3843.9749,-3848.5063,-3856.733,-3865.7244,-3879.359,-3895.6533,-3919.7002,-3959.9658,-4012.3152,-4074.4126,-4140.983,-4214.194,-3100.5671,-3093.4275,-3092.0264,-3093.7876,-3092.3237,-3085.39,-3074.6223,-3067.02,-3056.6836,-3061.703,-3082.3745,-3115.152,-3145.629,-3159.835,-3153.5308,-3136.5422,-3118.679,-3105.42,-3101.542,-3102.8994,-3105.4023,-3114.6357,-3124.9292,-3144.0063,-3165.3843,-3191.2822,-3220.1443,-3248.562,-3283.112,-3318.966,-3354.4534,-3384.9192,-3395.81,-3400.0933,-3405.8364,-3408.91,-3411.1418,-3415.6812,-3424.1848,-3423.5159,-3417.8086,-3414.2734,-3408.8132,-3408.7761,-3410.6658,-3426.646,-3435.6365,-3440.1523,-3435.5564,-3435.4558,-3442.0627,-3443.1719,-3435.0808,-3421.1575,-3408.4626,-3400.862,-3405.29,-3431.6895,-3467.8396,-3517.6917,-3562.5322,-3602.023,-3631.3845,-3659.4397,-3679.579,-3699.9863,-3716.2183,-3739.0833,-3753.1772,-3784.0781,-3814.245,-3835.514,-3857.0166,-3878.6863,-3904.2986,-3922.0103,-3957.6743,-4023.2554,-4084.0913,-4130.346,-4155.0747,-4152.7964,-4161.5596,-4184.798,-4202.385,-4233.3706,-4260.259,-4281.616,-4331.4795,-4389.199,-4433.5034,-4465.2427,-4468.86,-4469.3706,-4502.0596,-4539.352,-4560.9927,-4576.7583,-4592.223,-4604.404,-4602.2817,-4592.489,-4554.4165,-4377.7217,-4251.7837,-4225.7993,-4204.7783,-4142.8013,-4074.341,-4027.1147,-3999.8345,-3993.8027,-3978.9602,-3981.0864,-3992.6482,-4005.4807,-4017.8499,-3991.232,-4021.102,-4082.2869,-4072.9075,-4018.6204,-3981.9038,-4009.9722,-4080.4844,-4141.531,-4198.711,-4276.9893,-2852.2302,-2856.813,-2858.5403,-2862.851,-2864.991,-2867.208,-2874.9214,-2884.1445,-2892.0413,-2899.1792,-2907.7676,-2914.5845,-2914.5588,-2906.7825,-2902.918,-2904.286,-2906.192,-2904.1365,-2895.8867,-2887.2644,-2882.322,-2880.307,-2881.7556,-2889.6218,-2901.2544,-2913.0278,-2928.4229,-2948.5176,-2966.4258,-2983.176,-3002.586,-3019.4666,-3036.5215,-3057.1062,-3077.1274,-3095.3538,-3109.8413,-3121.5447,-3130.272,-3140.0706,-3142.998,-3147.219,-3149.114,-3153.079,-3151.9065,-3156.8528,-3162.7964,-3158.7922,-3152.8074,-3133.0354,-3098.6267,-3089.662,-3133.8503,-3191.6892,-3228.5613,-3266.8694,-3290.6196,-3308.6687,-3328.4563,-3351.644,-3364.8235,-3393.0308,-3405.811,-3416.072,-3428.7668,-3445.9314,-3455.9707,-3473.291,-3484.0847,-3491.3555,-3502.533,-3513.4778,-3526.2075,-3535.0889,-3558.9568,-3580.1006,-3587.2092,-3594.621,-3605.103,-3615.1016,-3621.2278,-3625.953,-3628.3386,-3633.0417,-3635.8474,-3636.8533,-3642.6807,-3656.5405,-3663.4358,-3676.3977,-3680.8518,-3673.2007,-3649.4524,-3616.9822,-3590.1956,-3561.4692,-3545.4556,-3537.6145,-3521.9302,-3498.043,-3476.7148,-3461.4316,-3442.0972,-3431.937,-3430.8948,-3434.9888,-3441.5364,-3426.6064,-3409.5288,-3410.1682,-3419.4814,-3427.1057,-3422.6675,-3415.7803,-3389.6506,-3354.5781,-3331.292,-3304.322,-3306.2112,-3329.3403,-3323.1675,-3307.512,-3278.6487,-3256.7427,-3244.6274,-3243.7961,-3246.9297,-3249.1736,-2607.4019,-2608.655,-2611.9187,-2617.2224,-2622.676,-2630.781,-2637.5032,-2643.7446,-2652.0747,-2659.3252,-2669.4504,-2677.235,-2683.3086,-2688.9597,-2694.543,-2694.555,-2694.1494,-2691.695,-2688.199,-2683.1072,-2680.9482,-2677.8303,-2676.004,-2677.1768,-2682.2288,-2687.957,-2690.9587,-2692.9966,-2697.2122,-2703.3809,-2712.3423,-2731.9807,-2753.1077,-2775.675,-2797.5635,-2813.4922,-2826.202,-2838.5154,-2849.9497,-2858.9126,-2867.7002,-2875.5837,-2881.4756,-2886.7556,-2890.17,-2893.5608,-2898.9592,-2905.3403,-2912.0225,-2916.045,-2918.0212,-2919.6228,-2913.225,-2897.0886,-2895.3542,-2915.3293,-2943.6323,-2957.8276,-2996.6616,-3003.9414,-3005.9272,-3008.4995,-3008.441,-3003.591,-3004.026,-3006.8523,-3009.0586,-3010.2703,-3016.5784,-3022.8464,-3026.6262,-3030.8926,-3035.78,-3042.9456,-3051.456,-3054.998,-3060.5603,-3065.8086,-3071.0251,-3080.347,-3088.4465,-3095.0793,-3103.105,-3114.579,-3117.9597,-3119.1292,-3123.7402,-3129.0388,-3136.2036,-3144.8591,-3155.2651,-3160.2937,-3164.808,-3166.7258,-3167.0427,-3164.6204,-3162.1057,-3159.4204,-3161.8704,-3167.706,-3181.3867,-3197.2861,-3214.0986,-3226.1453,-3231.8435,-3226.8652,-3219.8733,-3205.4954,-3196.557,-3187.7903,-3177.302,-3167.3667,-3157.1912,-3145.5056,-3139.4714,-3133.5784,-3124.886,-3115.6592,-3108.4407,-3101.5837,-3092.977,-3080.2188,-3069.7058,-3057.5889,-3043.7812,-3032.3298,-3019.4143,-3002.38,-2412.1382,-2376.4863,-2356.3723,-2351.5544,-2348.4011,-2351.0479,-2351.159,-2352.9543,-2363.6233,-2369.8784,-2379.7432,-2394.663,-2405.1768,-2403.0762,-2403.193,-2408.5288,-2427.916,-2429.93,-2428.963,-2435.3867,-2442.1265,-2449.9238,-2451.4595,-2465.735,-2479.4001,-2504.3354,-2528.8645,-2540.1704,-2534.5132,-2526.9238,-2538.7751,-2537.2024,-2531.333,-2562.23,-2546.4102,-2538.258,-2546.2905,-2555.8667,-2566.785,-2577.6985,-2588.4358,-2608.5964,-2631.132,-2643.866,-2647.8647,-2650.0913,-2664.3054,-2675.067,-2662.4966,-2642.9673,-2640.9956,-2648.5874,-2650.7104,-2633.563,-2621.3235,-2619.6848,-2597.141,-2585.9683,-2581.0676,-2582.2773,-2590.1013,-2615.7673,-2654.0693,-2691.789,-2692.1716,-2691.1765,-2711.4065,-2692.4536,-2710.9258,-2775.9756,-2811.3003,-2767.0579,-2769.0476,-2846.453,-2822.8093,-2796.2356,-2793.2893,-2789.3516,-2786.1714,-2800.4263,-2824.3218,-2841.689,-2862.8953,-2920.3667,-2922.1704,-2889.1277,-2964.5264,-2927.4565,-2876.9414,-2864.9724,-2880.296,-2911.4797,-2870.4949,-2880.6233,-2940.0205,-2939.2107,-2891.368,-2916.7505,-2941.708,-2932.715,-2905.2903,-2894.9285,-2893.921,-2885.165,-2871.2534,-2852.798,-2838.299,-2854.5066,-2822.081,-2818.347,-2828.9429,-2893.507,-2941.0083,-2875.7263,-2826.266,-2816.697,-2819.3652,-2821.8235,-2829.2263,-2896.3604,-2872.1575,-2799.4016,-2815.146,-2806.3386,-2837.6929,-2874.5364,-2869.7837,-2836.036,-2240.9563,-2188.3474,-2127.8936,-2113.8467,-2127.3967,-2143.495,-2148.5852,-2158.818,-2184.9097,-2176.1028,-2151.0251,-2153.287,-2167.9304,-2160.4558,-2154.1594,-2153.1755,-2174.8933,-2174.1938,-2165.8157,-2174.3162,-2195.1199,-2237.8237,-2227.1614,-2248.7603,-2266.4492,-2270.613,-2274.1306,-2266.155,-2275.3875,-2258.8135,-2250.4644,-2254.1604,-2281.2456,-2324.8997,-2311.5164,-2294.9692,-2296.0518,-2301.321,-2304.8735,-2306.592,-2310.1611,-2340.8596,-2391.2559,-2354.265,-2369.721,-2359.9377,-2346.0132,-2369.3762,-2425.241,-2413.9675,-2384.8376,-2396.5923,-2425.9863,-2421.6917,-2411.733,-2423.2632,-2387.7966,-2382.402,-2381.5088,-2382.66,-2391.6675,-2422.4868,-2512.2473,-2655.5723,-2552.0315,-2544.1375,-2599.385,-2535.8865,-2515.2898,-2563.1196,-2493.1606,-2472.085,-2551.7383,-2709.8584,-2651.451,-2572.5706,-2545.2302,-2530.5063,-2526.4644,-2533.9956,-2545.0505,-2571.045,-2612.4395,-2726.714,-2727.6064,-2556.2732,-2486.3477,-2487.4348,-2510.435,-2528.8093,-2549.4285,-2578.2715,-2583.0955,-2621.4905,-2674.8254,-2691.9236,-2645.8228,-2780.6733,-2910.7368,-2867.8943,-2722.6643,-2679.0571,-2673.9429,-2640.2139,-2600.092,-2565.76,-2561.842,-2616.2302,-2532.221,-2530.9692,-2563.3694,-2653.2502,-2700.5325,-2626.4106,-2558.8262,-2543.4133,-2547.7256,-2555.222,-2577.1992,-2633.6711,-2608.4104,-2533.8357,-2585.4775,-2712.438,-2556.357,-2602.535,-2680.4104,-2816.9036,-2021.9951,-2010.8241,-2000.0767,-1996.1063,-1997.3586,-2000.0309,-2000.7855,-2000.9904,-2002.4442,-2002.6852,-2001.4076,-2001.3176,-2000.4071,-2002.8065,-2006.2013,-2012.5033,-2024.1316,-2033.2579,-2042.2571,-2042.9694,-2047.2568,-2056.4802,-2054.686,-2059.2532,-2069.4978,-2076.5674,-2086.0032,-2095.1423,-2106.0479,-2113.72,-2119.1167,-2122.1355,-2126.0076,-2131.5347,-2133.9954,-2133.6135,-2137.8948,-2145.3398,-2148.9927,-2148.956,-2149.7854,-2152.722,-2190.749,-2168.2417,-2169.8596,-2170.4978,-2169.175,-2173.4346,-2180.374,-2182.3577,-2182.3994,-2188.667,-2210.7263,-2242.636,-2248.686,-2256.8464,-2269.0042,-2279.8948,-2251.4028,-2234.9463,-2232.5396,-2233.886,-2239.1685,-2242.4321,-2249.2832,-2265.808,-2271.7856,-2292.071,-2274.1973,-2304.8281,-2300.8003,-2296.4329,-2314.8596,-2336.3403,-2345.9602,-2344.4648,-2341.3835,-2346.4473,-2351.8838,-2357.9507,-2355.949,-2348.0994,-2344.169,-2347.7673,-2338.082,-2313.543,-2301.131,-2301.5093,-2305.9485,-2307.9604,-2311.77,-2321.394,-2331.9836,-2358.287,-2352.5168,-2371.2976,-2418.2673,-2375.7175,-2368.8948,-2357.708,-2360.8992,-2364.3647,-2353.082,-2352.105,-2345.915,-2346.4646,-2342.1367,-2368.3755,-2347.7766,-2349.8374,-2356.3496,-2367.954,-2374.8074,-2368.185,-2360.4258,-2360.1438,-2360.4995,-2362.2068,-2367.7205,-2376.3394,-2370.3584,-2361.8123,-2383.9873,-2410.4885,-2351.5874,-2363.2878,-2411.8748,-2458.5254,-1944.6355,-1944.552,-1943.9407,-1943.4541,-1941.1984,-1941.6987,-1941.3905,-1939.5381,-1942.1536,-1945.5114,-1948.1616,-1947.861,-1947.4574,-1949.3326,-1952.261,-1956.6548,-1959.1234,-1962.0968,-1963.5242,-1967.1693,-1973.1812,-1978.7379,-1981.1991,-1985.3245,-1989.8344,-1995.597,-2002.0785,-2006.8624,-2007.6843,-2011.1855,-2016.4579,-2019.3699,-2023.5714,-2027.8759,-2034.1403,-2039.5828,-2049.5981,-2057.3318,-2057.7524,-2057.047,-2057.5566,-2052.1807,-2056.9478,-2057.9656,-2060.2952,-2058.1743,-2058.159,-2055.1885,-2053.251,-2051.6284,-2050.772,-2054.6501,-2060.1438,-2065.832,-2076.352,-2084.9692,-2090.0225,-2105.7954,-2108.3535,-2105.1885,-2102.2078,-2089.9143,-2079.0925,-2079.963,-2105.7134,-2089.9102,-2077.9094,-2078.4736,-2080.1213,-2082.5103,-2081.491,-2083.4092,-2087.8267,-2089.6104,-2087.9983,-2090.8618,-2093.0173,-2094.3396,-2098.8535,-2103.7898,-2102.646,-2103.6223,-2107.3738,-2108.342,-2110.5767,-2111.22,-2112.8074,-2118.654,-2120.1074,-2119.2385,-2121.6433,-2124.7644,-2125.179,-2132.387,-2143.2908,-2136.983,-2165.8594,-2154.38,-2135.5454,-2124.8994,-2124.8958,-2126.1355,-2135.472,-2155.1462,-2175.022,-2184.998,-2184.5781,-2207.9849,-2209.819,-2217.2798,-2234.5833,-2251.3176,-2259.1743,-2259.12,-2249.1753,-2240.495,-2230.4246,-2223.3235,-2221.5261,-2218.3608,-2214.5989,-2208.9072,-2207.7502,-2201.7708,-2197.0718,-2197.5598,-2203.0054,-2156.0864],solid=False,xDimension=128,xSpacing=0.708661,yScale=50.0,zDimension=128,zSpacing=0.708661,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.00787,0.00391),(0.01575,0.00391),(0.02362,0.00391),(0.0315,0.00391),(0.03937,0.00391),(0.04724,0.00391),(0.05512,0.00391),(0.06299,0.00391),(0.07087,0.00391),(0.07874,0.00391),(0.08661,0.00391),(0.09449,0.00391),(0.10236,0.00391),(0.11024,0.00391),(0.11811,0.00391),(0.12598,0.00391),(0.13386,0.00391),(0.14173,0.00391),(0.14961,0.00391),(0.15748,0.00391),(0.16535,0.00391),(0.17323,0.00391),(0.1811,0.00391),(0.18898,0.00391),(0.19685,0.00391),(0.20472,0.00391),(0.2126,0.00391),(0.22047,0.00391),(0.22835,0.00391),(0.23622,0.00391),(0.24409,0.00391),(0.25197,0.00391),(0.25984,0.00391),(0.26772,0.00391),(0.27559,0.00391),(0.28346,0.00391),(0.29134,0.00391),(0.29921,0.00391),(0.30709,0.00391),(0.31496,0.00391),(0.32283,0.00391),(0.33071,0.00391),(0.33858,0.00391),(0.34646,0.00391),(0.35433,0.00391),(0.3622,0.00391),(0.37008,0.00391),(0.37795,0.00391),(0.38583,0.00391),(0.3937,0.00391),(0.40157,0.00391),(0.40945,0.00391),(0.41732,0.00391),(0.4252,0.00391),(0.43307,0.00391),(0.44094,0.00391),(0.44882,0.00391),(0.45669,0.00391),(0.46457,0.00391),(0.47244,0.00391),(0.48031,0.00391),(0.48819,0.00391),(0.49606,0.00391),(0.50394,0.00391),(0.51181,0.00391),(0.51969,0.00391),(0.52756,0.00391),(0.53543,0.00391),(0.54331,0.00391),(0.55118,0.00391),(0.55906,0.00391),(0.56693,0.00391),(0.5748,0.00391),(0.58268,0.00391),(0.59055,0.00391),(0.59843,0.00391),(0.6063,0.00391),(0.61417,0.00391),(0.62205,0.00391),(0.62992,0.00391),(0.6378,0.00391),(0.64567,0.00391),(0.65354,0.00391),(0.66142,0.00391),(0.66929,0.00391),(0.67717,0.00391),(0.68504,0.00391),(0.69291,0.00391),(0.70079,0.00391),(0.70866,0.00391),(0.71654,0.00391),(0.72441,0.00391),(0.73228,0.00391),(0.74016,0.00391),(0.74803,0.00391),(0.75591,0.00391),(0.76378,0.00391),(0.77165,0.00391),(0.77953,0.00391),(0.7874,0.00391),(0.79528,0.00391),(0.80315,0.00391),(0.81102,0.00391),(0.8189,0.00391),(0.82677,0.00391),(0.83465,0.00391),(0.84252,0.00391),(0.85039,0.00391),(0.85827,0.00391),(0.86614,0.00391),(0.87402,0.00391),(0.88189,0.00391),(0.88976,0.00391),(0.89764,0.00391),(0.90551,0.00391),(0.91339,0.00391),(0.92126,0.00391),(0.92913,0.00391),(0.93701,0.00391),(0.94488,0.00391),(0.95276,0.00391),(0.96063,0.00391),(0.9685,0.00391),(0.97638,0.00391),(0.98425,0.00391),(0.99213,0.00391),(0.99609,0.00391),(0.00391,0.00787),(0.00787,0.00787),(0.01575,0.00787),(0.02362,0.00787),(0.0315,0.00787),(0.03937,0.00787),(0.04724,0.00787),(0.05512,0.00787),(0.06299,0.00787),(0.07087,0.00787),(0.07874,0.00787),(0.08661,0.00787),(0.09449,0.00787),(0.10236,0.00787),(0.11024,0.00787),(0.11811,0.00787),(0.12598,0.00787),(0.13386,0.00787),(0.14173,0.00787),(0.14961,0.00787),(0.15748,0.00787),(0.16535,0.00787),(0.17323,0.00787),(0.1811,0.00787),(0.18898,0.00787),(0.19685,0.00787),(0.20472,0.00787),(0.2126,0.00787),(0.22047,0.00787),(0.22835,0.00787),(0.23622,0.00787),(0.24409,0.00787),(0.25197,0.00787),(0.25984,0.00787),(0.26772,0.00787),(0.27559,0.00787),(0.28346,0.00787),(0.29134,0.00787),(0.29921,0.00787),(0.30709,0.00787),(0.31496,0.00787),(0.32283,0.00787),(0.33071,0.00787),(0.33858,0.00787),(0.34646,0.00787),(0.35433,0.00787),(0.3622,0.00787),(0.37008,0.00787),(0.37795,0.00787),(0.38583,0.00787),(0.3937,0.00787),(0.40157,0.00787),(0.40945,0.00787),(0.41732,0.00787),(0.4252,0.00787),(0.43307,0.00787),(0.44094,0.00787),(0.44882,0.00787),(0.45669,0.00787),(0.46457,0.00787),(0.47244,0.00787),(0.48031,0.00787),(0.48819,0.00787),(0.49606,0.00787),(0.50394,0.00787),(0.51181,0.00787),(0.51969,0.00787),(0.52756,0.00787),(0.53543,0.00787),(0.54331,0.00787),(0.55118,0.00787),(0.55906,0.00787),(0.56693,0.00787),(0.5748,0.00787),(0.58268,0.00787),(0.59055,0.00787),(0.59843,0.00787),(0.6063,0.00787),(0.61417,0.00787),(0.62205,0.00787),(0.62992,0.00787),(0.6378,0.00787),(0.64567,0.00787),(0.65354,0.00787),(0.66142,0.00787),(0.66929,0.00787),(0.67717,0.00787),(0.68504,0.00787),(0.69291,0.00787),(0.70079,0.00787),(0.70866,0.00787),(0.71654,0.00787),(0.72441,0.00787),(0.73228,0.00787),(0.74016,0.00787),(0.74803,0.00787),(0.75591,0.00787),(0.76378,0.00787),(0.77165,0.00787),(0.77953,0.00787),(0.7874,0.00787),(0.79528,0.00787),(0.80315,0.00787),(0.81102,0.00787),(0.8189,0.00787),(0.82677,0.00787),(0.83465,0.00787),(0.84252,0.00787),(0.85039,0.00787),(0.85827,0.00787),(0.86614,0.00787),(0.87402,0.00787),(0.88189,0.00787),(0.88976,0.00787),(0.89764,0.00787),(0.90551,0.00787),(0.91339,0.00787),(0.92126,0.00787),(0.92913,0.00787),(0.93701,0.00787),(0.94488,0.00787),(0.95276,0.00787),(0.96063,0.00787),(0.9685,0.00787),(0.97638,0.00787),(0.98425,0.00787),(0.99213,0.00787),(0.99609,0.00787),(0.00391,0.01575),(0.00787,0.01575),(0.01575,0.01575),(0.02362,0.01575),(0.0315,0.01575),(0.03937,0.01575),(0.04724,0.01575),(0.05512,0.01575),(0.06299,0.01575),(0.07087,0.01575),(0.07874,0.01575),(0.08661,0.01575),(0.09449,0.01575),(0.10236,0.01575),(0.11024,0.01575),(0.11811,0.01575),(0.12598,0.01575),(0.13386,0.01575),(0.14173,0.01575),(0.14961,0.01575),(0.15748,0.01575),(0.16535,0.01575),(0.17323,0.01575),(0.1811,0.01575),(0.18898,0.01575),(0.19685,0.01575),(0.20472,0.01575),(0.2126,0.01575),(0.22047,0.01575),(0.22835,0.01575),(0.23622,0.01575),(0.24409,0.01575),(0.25197,0.01575),(0.25984,0.01575),(0.26772,0.01575),(0.27559,0.01575),(0.28346,0.01575),(0.29134,0.01575),(0.29921,0.01575),(0.30709,0.01575),(0.31496,0.01575),(0.32283,0.01575),(0.33071,0.01575),(0.33858,0.01575),(0.34646,0.01575),(0.35433,0.01575),(0.3622,0.01575),(0.37008,0.01575),(0.37795,0.01575),(0.38583,0.01575),(0.3937,0.01575),(0.40157,0.01575),(0.40945,0.01575),(0.41732,0.01575),(0.4252,0.01575),(0.43307,0.01575),(0.44094,0.01575),(0.44882,0.01575),(0.45669,0.01575),(0.46457,0.01575),(0.47244,0.01575),(0.48031,0.01575),(0.48819,0.01575),(0.49606,0.01575),(0.50394,0.01575),(0.51181,0.01575),(0.51969,0.01575),(0.52756,0.01575),(0.53543,0.01575),(0.54331,0.01575),(0.55118,0.01575),(0.55906,0.01575),(0.56693,0.01575),(0.5748,0.01575),(0.58268,0.01575),(0.59055,0.01575),(0.59843,0.01575),(0.6063,0.01575),(0.61417,0.01575),(0.62205,0.01575),(0.62992,0.01575),(0.6378,0.01575),(0.64567,0.01575),(0.65354,0.01575),(0.66142,0.01575),(0.66929,0.01575),(0.67717,0.01575),(0.68504,0.01575),(0.69291,0.01575),(0.70079,0.01575),(0.70866,0.01575),(0.71654,0.01575),(0.72441,0.01575),(0.73228,0.01575),(0.74016,0.01575),(0.74803,0.01575),(0.75591,0.01575),(0.76378,0.01575),(0.77165,0.01575),(0.77953,0.01575),(0.7874,0.01575),(0.79528,0.01575),(0.80315,0.01575),(0.81102,0.01575),(0.8189,0.01575),(0.82677,0.01575),(0.83465,0.01575),(0.84252,0.01575),(0.85039,0.01575),(0.85827,0.01575),(0.86614,0.01575),(0.87402,0.01575),(0.88189,0.01575),(0.88976,0.01575),(0.89764,0.01575),(0.90551,0.01575),(0.91339,0.01575),(0.92126,0.01575),(0.92913,0.01575),(0.93701,0.01575),(0.94488,0.01575),(0.95276,0.01575),(0.96063,0.01575),(0.9685,0.01575),(0.97638,0.01575),(0.98425,0.01575),(0.99213,0.01575),(0.99609,0.01575),(0.00391,0.02362),(0.00787,0.02362),(0.01575,0.02362),(0.02362,0.02362),(0.0315,0.02362),(0.03937,0.02362),(0.04724,0.02362),(0.05512,0.02362),(0.06299,0.02362),(0.07087,0.02362),(0.07874,0.02362),(0.08661,0.02362),(0.09449,0.02362),(0.10236,0.02362),(0.11024,0.02362),(0.11811,0.02362),(0.12598,0.02362),(0.13386,0.02362),(0.14173,0.02362),(0.14961,0.02362),(0.15748,0.02362),(0.16535,0.02362),(0.17323,0.02362),(0.1811,0.02362),(0.18898,0.02362),(0.19685,0.02362),(0.20472,0.02362),(0.2126,0.02362),(0.22047,0.02362),(0.22835,0.02362),(0.23622,0.02362),(0.24409,0.02362),(0.25197,0.02362),(0.25984,0.02362),(0.26772,0.02362),(0.27559,0.02362),(0.28346,0.02362),(0.29134,0.02362),(0.29921,0.02362),(0.30709,0.02362),(0.31496,0.02362),(0.32283,0.02362),(0.33071,0.02362),(0.33858,0.02362),(0.34646,0.02362),(0.35433,0.02362),(0.3622,0.02362),(0.37008,0.02362),(0.37795,0.02362),(0.38583,0.02362),(0.3937,0.02362),(0.40157,0.02362),(0.40945,0.02362),(0.41732,0.02362),(0.4252,0.02362),(0.43307,0.02362),(0.44094,0.02362),(0.44882,0.02362),(0.45669,0.02362),(0.46457,0.02362),(0.47244,0.02362),(0.48031,0.02362),(0.48819,0.02362),(0.49606,0.02362),(0.50394,0.02362),(0.51181,0.02362),(0.51969,0.02362),(0.52756,0.02362),(0.53543,0.02362),(0.54331,0.02362),(0.55118,0.02362),(0.55906,0.02362),(0.56693,0.02362),(0.5748,0.02362),(0.58268,0.02362),(0.59055,0.02362),(0.59843,0.02362),(0.6063,0.02362),(0.61417,0.02362),(0.62205,0.02362),(0.62992,0.02362),(0.6378,0.02362),(0.64567,0.02362),(0.65354,0.02362),(0.66142,0.02362),(0.66929,0.02362),(0.67717,0.02362),(0.68504,0.02362),(0.69291,0.02362),(0.70079,0.02362),(0.70866,0.02362),(0.71654,0.02362),(0.72441,0.02362),(0.73228,0.02362),(0.74016,0.02362),(0.74803,0.02362),(0.75591,0.02362),(0.76378,0.02362),(0.77165,0.02362),(0.77953,0.02362),(0.7874,0.02362),(0.79528,0.02362),(0.80315,0.02362),(0.81102,0.02362),(0.8189,0.02362),(0.82677,0.02362),(0.83465,0.02362),(0.84252,0.02362),(0.85039,0.02362),(0.85827,0.02362),(0.86614,0.02362),(0.87402,0.02362),(0.88189,0.02362),(0.88976,0.02362),(0.89764,0.02362),(0.90551,0.02362),(0.91339,0.02362),(0.92126,0.02362),(0.92913,0.02362),(0.93701,0.02362),(0.94488,0.02362),(0.95276,0.02362),(0.96063,0.02362),(0.9685,0.02362),(0.97638,0.02362),(0.98425,0.02362),(0.99213,0.02362),(0.99609,0.02362),(0.00391,0.0315),(0.00787,0.0315),(0.01575,0.0315),(0.02362,0.0315),(0.0315,0.0315),(0.03937,0.0315),(0.04724,0.0315),(0.05512,0.0315),(0.06299,0.0315),(0.07087,0.0315),(0.07874,0.0315),(0.08661,0.0315),(0.09449,0.0315),(0.10236,0.0315),(0.11024,0.0315),(0.11811,0.0315),(0.12598,0.0315),(0.13386,0.0315),(0.14173,0.0315),(0.14961,0.0315),(0.15748,0.0315),(0.16535,0.0315),(0.17323,0.0315),(0.1811,0.0315),(0.18898,0.0315),(0.19685,0.0315),(0.20472,0.0315),(0.2126,0.0315),(0.22047,0.0315),(0.22835,0.0315),(0.23622,0.0315),(0.24409,0.0315),(0.25197,0.0315),(0.25984,0.0315),(0.26772,0.0315),(0.27559,0.0315),(0.28346,0.0315),(0.29134,0.0315),(0.29921,0.0315),(0.30709,0.0315),(0.31496,0.0315),(0.32283,0.0315),(0.33071,0.0315),(0.33858,0.0315),(0.34646,0.0315),(0.35433,0.0315),(0.3622,0.0315),(0.37008,0.0315),(0.37795,0.0315),(0.38583,0.0315),(0.3937,0.0315),(0.40157,0.0315),(0.40945,0.0315),(0.41732,0.0315),(0.4252,0.0315),(0.43307,0.0315),(0.44094,0.0315),(0.44882,0.0315),(0.45669,0.0315),(0.46457,0.0315),(0.47244,0.0315),(0.48031,0.0315),(0.48819,0.0315),(0.49606,0.0315),(0.50394,0.0315),(0.51181,0.0315),(0.51969,0.0315),(0.52756,0.0315),(0.53543,0.0315),(0.54331,0.0315),(0.55118,0.0315),(0.55906,0.0315),(0.56693,0.0315),(0.5748,0.0315),(0.58268,0.0315),(0.59055,0.0315),(0.59843,0.0315),(0.6063,0.0315),(0.61417,0.0315),(0.62205,0.0315),(0.62992,0.0315),(0.6378,0.0315),(0.64567,0.0315),(0.65354,0.0315),(0.66142,0.0315),(0.66929,0.0315),(0.67717,0.0315),(0.68504,0.0315),(0.69291,0.0315),(0.70079,0.0315),(0.70866,0.0315),(0.71654,0.0315),(0.72441,0.0315),(0.73228,0.0315),(0.74016,0.0315),(0.74803,0.0315),(0.75591,0.0315),(0.76378,0.0315),(0.77165,0.0315),(0.77953,0.0315),(0.7874,0.0315),(0.79528,0.0315),(0.80315,0.0315),(0.81102,0.0315),(0.8189,0.0315),(0.82677,0.0315),(0.83465,0.0315),(0.84252,0.0315),(0.85039,0.0315),(0.85827,0.0315),(0.86614,0.0315),(0.87402,0.0315),(0.88189,0.0315),(0.88976,0.0315),(0.89764,0.0315),(0.90551,0.0315),(0.91339,0.0315),(0.92126,0.0315),(0.92913,0.0315),(0.93701,0.0315),(0.94488,0.0315),(0.95276,0.0315),(0.96063,0.0315),(0.9685,0.0315),(0.97638,0.0315),(0.98425,0.0315),(0.99213,0.0315),(0.99609,0.0315),(0.00391,0.03937),(0.00787,0.03937),(0.01575,0.03937),(0.02362,0.03937),(0.0315,0.03937),(0.03937,0.03937),(0.04724,0.03937),(0.05512,0.03937),(0.06299,0.03937),(0.07087,0.03937),(0.07874,0.03937),(0.08661,0.03937),(0.09449,0.03937),(0.10236,0.03937),(0.11024,0.03937),(0.11811,0.03937),(0.12598,0.03937),(0.13386,0.03937),(0.14173,0.03937),(0.14961,0.03937),(0.15748,0.03937),(0.16535,0.03937),(0.17323,0.03937),(0.1811,0.03937),(0.18898,0.03937),(0.19685,0.03937),(0.20472,0.03937),(0.2126,0.03937),(0.22047,0.03937),(0.22835,0.03937),(0.23622,0.03937),(0.24409,0.03937),(0.25197,0.03937),(0.25984,0.03937),(0.26772,0.03937),(0.27559,0.03937),(0.28346,0.03937),(0.29134,0.03937),(0.29921,0.03937),(0.30709,0.03937),(0.31496,0.03937),(0.32283,0.03937),(0.33071,0.03937),(0.33858,0.03937),(0.34646,0.03937),(0.35433,0.03937),(0.3622,0.03937),(0.37008,0.03937),(0.37795,0.03937),(0.38583,0.03937),(0.3937,0.03937),(0.40157,0.03937),(0.40945,0.03937),(0.41732,0.03937),(0.4252,0.03937),(0.43307,0.03937),(0.44094,0.03937),(0.44882,0.03937),(0.45669,0.03937),(0.46457,0.03937),(0.47244,0.03937),(0.48031,0.03937),(0.48819,0.03937),(0.49606,0.03937),(0.50394,0.03937),(0.51181,0.03937),(0.51969,0.03937),(0.52756,0.03937),(0.53543,0.03937),(0.54331,0.03937),(0.55118,0.03937),(0.55906,0.03937),(0.56693,0.03937),(0.5748,0.03937),(0.58268,0.03937),(0.59055,0.03937),(0.59843,0.03937),(0.6063,0.03937),(0.61417,0.03937),(0.62205,0.03937),(0.62992,0.03937),(0.6378,0.03937),(0.64567,0.03937),(0.65354,0.03937),(0.66142,0.03937),(0.66929,0.03937),(0.67717,0.03937),(0.68504,0.03937),(0.69291,0.03937),(0.70079,0.03937),(0.70866,0.03937),(0.71654,0.03937),(0.72441,0.03937),(0.73228,0.03937),(0.74016,0.03937),(0.74803,0.03937),(0.75591,0.03937),(0.76378,0.03937),(0.77165,0.03937),(0.77953,0.03937),(0.7874,0.03937),(0.79528,0.03937),(0.80315,0.03937),(0.81102,0.03937),(0.8189,0.03937),(0.82677,0.03937),(0.83465,0.03937),(0.84252,0.03937),(0.85039,0.03937),(0.85827,0.03937),(0.86614,0.03937),(0.87402,0.03937),(0.88189,0.03937),(0.88976,0.03937),(0.89764,0.03937),(0.90551,0.03937),(0.91339,0.03937),(0.92126,0.03937),(0.92913,0.03937),(0.93701,0.03937),(0.94488,0.03937),(0.95276,0.03937),(0.96063,0.03937),(0.9685,0.03937),(0.97638,0.03937),(0.98425,0.03937),(0.99213,0.03937),(0.99609,0.03937),(0.00391,0.04724),(0.00787,0.04724),(0.01575,0.04724),(0.02362,0.04724),(0.0315,0.04724),(0.03937,0.04724),(0.04724,0.04724),(0.05512,0.04724),(0.06299,0.04724),(0.07087,0.04724),(0.07874,0.04724),(0.08661,0.04724),(0.09449,0.04724),(0.10236,0.04724),(0.11024,0.04724),(0.11811,0.04724),(0.12598,0.04724),(0.13386,0.04724),(0.14173,0.04724),(0.14961,0.04724),(0.15748,0.04724),(0.16535,0.04724),(0.17323,0.04724),(0.1811,0.04724),(0.18898,0.04724),(0.19685,0.04724),(0.20472,0.04724),(0.2126,0.04724),(0.22047,0.04724),(0.22835,0.04724),(0.23622,0.04724),(0.24409,0.04724),(0.25197,0.04724),(0.25984,0.04724),(0.26772,0.04724),(0.27559,0.04724),(0.28346,0.04724),(0.29134,0.04724),(0.29921,0.04724),(0.30709,0.04724),(0.31496,0.04724),(0.32283,0.04724),(0.33071,0.04724),(0.33858,0.04724),(0.34646,0.04724),(0.35433,0.04724),(0.3622,0.04724),(0.37008,0.04724),(0.37795,0.04724),(0.38583,0.04724),(0.3937,0.04724),(0.40157,0.04724),(0.40945,0.04724),(0.41732,0.04724),(0.4252,0.04724),(0.43307,0.04724),(0.44094,0.04724),(0.44882,0.04724),(0.45669,0.04724),(0.46457,0.04724),(0.47244,0.04724),(0.48031,0.04724),(0.48819,0.04724),(0.49606,0.04724),(0.50394,0.04724),(0.51181,0.04724),(0.51969,0.04724),(0.52756,0.04724),(0.53543,0.04724),(0.54331,0.04724),(0.55118,0.04724),(0.55906,0.04724),(0.56693,0.04724),(0.5748,0.04724),(0.58268,0.04724),(0.59055,0.04724),(0.59843,0.04724),(0.6063,0.04724),(0.61417,0.04724),(0.62205,0.04724),(0.62992,0.04724),(0.6378,0.04724),(0.64567,0.04724),(0.65354,0.04724),(0.66142,0.04724),(0.66929,0.04724),(0.67717,0.04724),(0.68504,0.04724),(0.69291,0.04724),(0.70079,0.04724),(0.70866,0.04724),(0.71654,0.04724),(0.72441,0.04724),(0.73228,0.04724),(0.74016,0.04724),(0.74803,0.04724),(0.75591,0.04724),(0.76378,0.04724),(0.77165,0.04724),(0.77953,0.04724),(0.7874,0.04724),(0.79528,0.04724),(0.80315,0.04724),(0.81102,0.04724),(0.8189,0.04724),(0.82677,0.04724),(0.83465,0.04724),(0.84252,0.04724),(0.85039,0.04724),(0.85827,0.04724),(0.86614,0.04724),(0.87402,0.04724),(0.88189,0.04724),(0.88976,0.04724),(0.89764,0.04724),(0.90551,0.04724),(0.91339,0.04724),(0.92126,0.04724),(0.92913,0.04724),(0.93701,0.04724),(0.94488,0.04724),(0.95276,0.04724),(0.96063,0.04724),(0.9685,0.04724),(0.97638,0.04724),(0.98425,0.04724),(0.99213,0.04724),(0.99609,0.04724),(0.00391,0.05512),(0.00787,0.05512),(0.01575,0.05512),(0.02362,0.05512),(0.0315,0.05512),(0.03937,0.05512),(0.04724,0.05512),(0.05512,0.05512),(0.06299,0.05512),(0.07087,0.05512),(0.07874,0.05512),(0.08661,0.05512),(0.09449,0.05512),(0.10236,0.05512),(0.11024,0.05512),(0.11811,0.05512),(0.12598,0.05512),(0.13386,0.05512),(0.14173,0.05512),(0.14961,0.05512),(0.15748,0.05512),(0.16535,0.05512),(0.17323,0.05512),(0.1811,0.05512),(0.18898,0.05512),(0.19685,0.05512),(0.20472,0.05512),(0.2126,0.05512),(0.22047,0.05512),(0.22835,0.05512),(0.23622,0.05512),(0.24409,0.05512),(0.25197,0.05512),(0.25984,0.05512),(0.26772,0.05512),(0.27559,0.05512),(0.28346,0.05512),(0.29134,0.05512),(0.29921,0.05512),(0.30709,0.05512),(0.31496,0.05512),(0.32283,0.05512),(0.33071,0.05512),(0.33858,0.05512),(0.34646,0.05512),(0.35433,0.05512),(0.3622,0.05512),(0.37008,0.05512),(0.37795,0.05512),(0.38583,0.05512),(0.3937,0.05512),(0.40157,0.05512),(0.40945,0.05512),(0.41732,0.05512),(0.4252,0.05512),(0.43307,0.05512),(0.44094,0.05512),(0.44882,0.05512),(0.45669,0.05512),(0.46457,0.05512),(0.47244,0.05512),(0.48031,0.05512),(0.48819,0.05512),(0.49606,0.05512),(0.50394,0.05512),(0.51181,0.05512),(0.51969,0.05512),(0.52756,0.05512),(0.53543,0.05512),(0.54331,0.05512),(0.55118,0.05512),(0.55906,0.05512),(0.56693,0.05512),(0.5748,0.05512),(0.58268,0.05512),(0.59055,0.05512),(0.59843,0.05512),(0.6063,0.05512),(0.61417,0.05512),(0.62205,0.05512),(0.62992,0.05512),(0.6378,0.05512),(0.64567,0.05512),(0.65354,0.05512),(0.66142,0.05512),(0.66929,0.05512),(0.67717,0.05512),(0.68504,0.05512),(0.69291,0.05512),(0.70079,0.05512),(0.70866,0.05512),(0.71654,0.05512),(0.72441,0.05512),(0.73228,0.05512),(0.74016,0.05512),(0.74803,0.05512),(0.75591,0.05512),(0.76378,0.05512),(0.77165,0.05512),(0.77953,0.05512),(0.7874,0.05512),(0.79528,0.05512),(0.80315,0.05512),(0.81102,0.05512),(0.8189,0.05512),(0.82677,0.05512),(0.83465,0.05512),(0.84252,0.05512),(0.85039,0.05512),(0.85827,0.05512),(0.86614,0.05512),(0.87402,0.05512),(0.88189,0.05512),(0.88976,0.05512),(0.89764,0.05512),(0.90551,0.05512),(0.91339,0.05512),(0.92126,0.05512),(0.92913,0.05512),(0.93701,0.05512),(0.94488,0.05512),(0.95276,0.05512),(0.96063,0.05512),(0.9685,0.05512),(0.97638,0.05512),(0.98425,0.05512),(0.99213,0.05512),(0.99609,0.05512),(0.00391,0.06299),(0.00787,0.06299),(0.01575,0.06299),(0.02362,0.06299),(0.0315,0.06299),(0.03937,0.06299),(0.04724,0.06299),(0.05512,0.06299),(0.06299,0.06299),(0.07087,0.06299),(0.07874,0.06299),(0.08661,0.06299),(0.09449,0.06299),(0.10236,0.06299),(0.11024,0.06299),(0.11811,0.06299),(0.12598,0.06299),(0.13386,0.06299),(0.14173,0.06299),(0.14961,0.06299),(0.15748,0.06299),(0.16535,0.06299),(0.17323,0.06299),(0.1811,0.06299),(0.18898,0.06299),(0.19685,0.06299),(0.20472,0.06299),(0.2126,0.06299),(0.22047,0.06299),(0.22835,0.06299),(0.23622,0.06299),(0.24409,0.06299),(0.25197,0.06299),(0.25984,0.06299),(0.26772,0.06299),(0.27559,0.06299),(0.28346,0.06299),(0.29134,0.06299),(0.29921,0.06299),(0.30709,0.06299),(0.31496,0.06299),(0.32283,0.06299),(0.33071,0.06299),(0.33858,0.06299),(0.34646,0.06299),(0.35433,0.06299),(0.3622,0.06299),(0.37008,0.06299),(0.37795,0.06299),(0.38583,0.06299),(0.3937,0.06299),(0.40157,0.06299),(0.40945,0.06299),(0.41732,0.06299),(0.4252,0.06299),(0.43307,0.06299),(0.44094,0.06299),(0.44882,0.06299),(0.45669,0.06299),(0.46457,0.06299),(0.47244,0.06299),(0.48031,0.06299),(0.48819,0.06299),(0.49606,0.06299),(0.50394,0.06299),(0.51181,0.06299),(0.51969,0.06299),(0.52756,0.06299),(0.53543,0.06299),(0.54331,0.06299),(0.55118,0.06299),(0.55906,0.06299),(0.56693,0.06299),(0.5748,0.06299),(0.58268,0.06299),(0.59055,0.06299),(0.59843,0.06299),(0.6063,0.06299),(0.61417,0.06299),(0.62205,0.06299),(0.62992,0.06299),(0.6378,0.06299),(0.64567,0.06299),(0.65354,0.06299),(0.66142,0.06299),(0.66929,0.06299),(0.67717,0.06299),(0.68504,0.06299),(0.69291,0.06299),(0.70079,0.06299),(0.70866,0.06299),(0.71654,0.06299),(0.72441,0.06299),(0.73228,0.06299),(0.74016,0.06299),(0.74803,0.06299),(0.75591,0.06299),(0.76378,0.06299),(0.77165,0.06299),(0.77953,0.06299),(0.7874,0.06299),(0.79528,0.06299),(0.80315,0.06299),(0.81102,0.06299),(0.8189,0.06299),(0.82677,0.06299),(0.83465,0.06299),(0.84252,0.06299),(0.85039,0.06299),(0.85827,0.06299),(0.86614,0.06299),(0.87402,0.06299),(0.88189,0.06299),(0.88976,0.06299),(0.89764,0.06299),(0.90551,0.06299),(0.91339,0.06299),(0.92126,0.06299),(0.92913,0.06299),(0.93701,0.06299),(0.94488,0.06299),(0.95276,0.06299),(0.96063,0.06299),(0.9685,0.06299),(0.97638,0.06299),(0.98425,0.06299),(0.99213,0.06299),(0.99609,0.06299),(0.00391,0.07087),(0.00787,0.07087),(0.01575,0.07087),(0.02362,0.07087),(0.0315,0.07087),(0.03937,0.07087),(0.04724,0.07087),(0.05512,0.07087),(0.06299,0.07087),(0.07087,0.07087),(0.07874,0.07087),(0.08661,0.07087),(0.09449,0.07087),(0.10236,0.07087),(0.11024,0.07087),(0.11811,0.07087),(0.12598,0.07087),(0.13386,0.07087),(0.14173,0.07087),(0.14961,0.07087),(0.15748,0.07087),(0.16535,0.07087),(0.17323,0.07087),(0.1811,0.07087),(0.18898,0.07087),(0.19685,0.07087),(0.20472,0.07087),(0.2126,0.07087),(0.22047,0.07087),(0.22835,0.07087),(0.23622,0.07087),(0.24409,0.07087),(0.25197,0.07087),(0.25984,0.07087),(0.26772,0.07087),(0.27559,0.07087),(0.28346,0.07087),(0.29134,0.07087),(0.29921,0.07087),(0.30709,0.07087),(0.31496,0.07087),(0.32283,0.07087),(0.33071,0.07087),(0.33858,0.07087),(0.34646,0.07087),(0.35433,0.07087),(0.3622,0.07087),(0.37008,0.07087),(0.37795,0.07087),(0.38583,0.07087),(0.3937,0.07087),(0.40157,0.07087),(0.40945,0.07087),(0.41732,0.07087),(0.4252,0.07087),(0.43307,0.07087),(0.44094,0.07087),(0.44882,0.07087),(0.45669,0.07087),(0.46457,0.07087),(0.47244,0.07087),(0.48031,0.07087),(0.48819,0.07087),(0.49606,0.07087),(0.50394,0.07087),(0.51181,0.07087),(0.51969,0.07087),(0.52756,0.07087),(0.53543,0.07087),(0.54331,0.07087),(0.55118,0.07087),(0.55906,0.07087),(0.56693,0.07087),(0.5748,0.07087),(0.58268,0.07087),(0.59055,0.07087),(0.59843,0.07087),(0.6063,0.07087),(0.61417,0.07087),(0.62205,0.07087),(0.62992,0.07087),(0.6378,0.07087),(0.64567,0.07087),(0.65354,0.07087),(0.66142,0.07087),(0.66929,0.07087),(0.67717,0.07087),(0.68504,0.07087),(0.69291,0.07087),(0.70079,0.07087),(0.70866,0.07087),(0.71654,0.07087),(0.72441,0.07087),(0.73228,0.07087),(0.74016,0.07087),(0.74803,0.07087),(0.75591,0.07087),(0.76378,0.07087),(0.77165,0.07087),(0.77953,0.07087),(0.7874,0.07087),(0.79528,0.07087),(0.80315,0.07087),(0.81102,0.07087),(0.8189,0.07087),(0.82677,0.07087),(0.83465,0.07087),(0.84252,0.07087),(0.85039,0.07087),(0.85827,0.07087),(0.86614,0.07087),(0.87402,0.07087),(0.88189,0.07087),(0.88976,0.07087),(0.89764,0.07087),(0.90551,0.07087),(0.91339,0.07087),(0.92126,0.07087),(0.92913,0.07087),(0.93701,0.07087),(0.94488,0.07087),(0.95276,0.07087),(0.96063,0.07087),(0.9685,0.07087),(0.97638,0.07087),(0.98425,0.07087),(0.99213,0.07087),(0.99609,0.07087),(0.00391,0.07874),(0.00787,0.07874),(0.01575,0.07874),(0.02362,0.07874),(0.0315,0.07874),(0.03937,0.07874),(0.04724,0.07874),(0.05512,0.07874),(0.06299,0.07874),(0.07087,0.07874),(0.07874,0.07874),(0.08661,0.07874),(0.09449,0.07874),(0.10236,0.07874),(0.11024,0.07874),(0.11811,0.07874),(0.12598,0.07874),(0.13386,0.07874),(0.14173,0.07874),(0.14961,0.07874),(0.15748,0.07874),(0.16535,0.07874),(0.17323,0.07874),(0.1811,0.07874),(0.18898,0.07874),(0.19685,0.07874),(0.20472,0.07874),(0.2126,0.07874),(0.22047,0.07874),(0.22835,0.07874),(0.23622,0.07874),(0.24409,0.07874),(0.25197,0.07874),(0.25984,0.07874),(0.26772,0.07874),(0.27559,0.07874),(0.28346,0.07874),(0.29134,0.07874),(0.29921,0.07874),(0.30709,0.07874),(0.31496,0.07874),(0.32283,0.07874),(0.33071,0.07874),(0.33858,0.07874),(0.34646,0.07874),(0.35433,0.07874),(0.3622,0.07874),(0.37008,0.07874),(0.37795,0.07874),(0.38583,0.07874),(0.3937,0.07874),(0.40157,0.07874),(0.40945,0.07874),(0.41732,0.07874),(0.4252,0.07874),(0.43307,0.07874),(0.44094,0.07874),(0.44882,0.07874),(0.45669,0.07874),(0.46457,0.07874),(0.47244,0.07874),(0.48031,0.07874),(0.48819,0.07874),(0.49606,0.07874),(0.50394,0.07874),(0.51181,0.07874),(0.51969,0.07874),(0.52756,0.07874),(0.53543,0.07874),(0.54331,0.07874),(0.55118,0.07874),(0.55906,0.07874),(0.56693,0.07874),(0.5748,0.07874),(0.58268,0.07874),(0.59055,0.07874),(0.59843,0.07874),(0.6063,0.07874),(0.61417,0.07874),(0.62205,0.07874),(0.62992,0.07874),(0.6378,0.07874),(0.64567,0.07874),(0.65354,0.07874),(0.66142,0.07874),(0.66929,0.07874),(0.67717,0.07874),(0.68504,0.07874),(0.69291,0.07874),(0.70079,0.07874),(0.70866,0.07874),(0.71654,0.07874),(0.72441,0.07874),(0.73228,0.07874),(0.74016,0.07874),(0.74803,0.07874),(0.75591,0.07874),(0.76378,0.07874),(0.77165,0.07874),(0.77953,0.07874),(0.7874,0.07874),(0.79528,0.07874),(0.80315,0.07874),(0.81102,0.07874),(0.8189,0.07874),(0.82677,0.07874),(0.83465,0.07874),(0.84252,0.07874),(0.85039,0.07874),(0.85827,0.07874),(0.86614,0.07874),(0.87402,0.07874),(0.88189,0.07874),(0.88976,0.07874),(0.89764,0.07874),(0.90551,0.07874),(0.91339,0.07874),(0.92126,0.07874),(0.92913,0.07874),(0.93701,0.07874),(0.94488,0.07874),(0.95276,0.07874),(0.96063,0.07874),(0.9685,0.07874),(0.97638,0.07874),(0.98425,0.07874),(0.99213,0.07874),(0.99609,0.07874),(0.00391,0.08661),(0.00787,0.08661),(0.01575,0.08661),(0.02362,0.08661),(0.0315,0.08661),(0.03937,0.08661),(0.04724,0.08661),(0.05512,0.08661),(0.06299,0.08661),(0.07087,0.08661),(0.07874,0.08661),(0.08661,0.08661),(0.09449,0.08661),(0.10236,0.08661),(0.11024,0.08661),(0.11811,0.08661),(0.12598,0.08661),(0.13386,0.08661),(0.14173,0.08661),(0.14961,0.08661),(0.15748,0.08661),(0.16535,0.08661),(0.17323,0.08661),(0.1811,0.08661),(0.18898,0.08661),(0.19685,0.08661),(0.20472,0.08661),(0.2126,0.08661),(0.22047,0.08661),(0.22835,0.08661),(0.23622,0.08661),(0.24409,0.08661),(0.25197,0.08661),(0.25984,0.08661),(0.26772,0.08661),(0.27559,0.08661),(0.28346,0.08661),(0.29134,0.08661),(0.29921,0.08661),(0.30709,0.08661),(0.31496,0.08661),(0.32283,0.08661),(0.33071,0.08661),(0.33858,0.08661),(0.34646,0.08661),(0.35433,0.08661),(0.3622,0.08661),(0.37008,0.08661),(0.37795,0.08661),(0.38583,0.08661),(0.3937,0.08661),(0.40157,0.08661),(0.40945,0.08661),(0.41732,0.08661),(0.4252,0.08661),(0.43307,0.08661),(0.44094,0.08661),(0.44882,0.08661),(0.45669,0.08661),(0.46457,0.08661),(0.47244,0.08661),(0.48031,0.08661),(0.48819,0.08661),(0.49606,0.08661),(0.50394,0.08661),(0.51181,0.08661),(0.51969,0.08661),(0.52756,0.08661),(0.53543,0.08661),(0.54331,0.08661),(0.55118,0.08661),(0.55906,0.08661),(0.56693,0.08661),(0.5748,0.08661),(0.58268,0.08661),(0.59055,0.08661),(0.59843,0.08661),(0.6063,0.08661),(0.61417,0.08661),(0.62205,0.08661),(0.62992,0.08661),(0.6378,0.08661),(0.64567,0.08661),(0.65354,0.08661),(0.66142,0.08661),(0.66929,0.08661),(0.67717,0.08661),(0.68504,0.08661),(0.69291,0.08661),(0.70079,0.08661),(0.70866,0.08661),(0.71654,0.08661),(0.72441,0.08661),(0.73228,0.08661),(0.74016,0.08661),(0.74803,0.08661),(0.75591,0.08661),(0.76378,0.08661),(0.77165,0.08661),(0.77953,0.08661),(0.7874,0.08661),(0.79528,0.08661),(0.80315,0.08661),(0.81102,0.08661),(0.8189,0.08661),(0.82677,0.08661),(0.83465,0.08661),(0.84252,0.08661),(0.85039,0.08661),(0.85827,0.08661),(0.86614,0.08661),(0.87402,0.08661),(0.88189,0.08661),(0.88976,0.08661),(0.89764,0.08661),(0.90551,0.08661),(0.91339,0.08661),(0.92126,0.08661),(0.92913,0.08661),(0.93701,0.08661),(0.94488,0.08661),(0.95276,0.08661),(0.96063,0.08661),(0.9685,0.08661),(0.97638,0.08661),(0.98425,0.08661),(0.99213,0.08661),(0.99609,0.08661),(0.00391,0.09449),(0.00787,0.09449),(0.01575,0.09449),(0.02362,0.09449),(0.0315,0.09449),(0.03937,0.09449),(0.04724,0.09449),(0.05512,0.09449),(0.06299,0.09449),(0.07087,0.09449),(0.07874,0.09449),(0.08661,0.09449),(0.09449,0.09449),(0.10236,0.09449),(0.11024,0.09449),(0.11811,0.09449),(0.12598,0.09449),(0.13386,0.09449),(0.14173,0.09449),(0.14961,0.09449),(0.15748,0.09449),(0.16535,0.09449),(0.17323,0.09449),(0.1811,0.09449),(0.18898,0.09449),(0.19685,0.09449),(0.20472,0.09449),(0.2126,0.09449),(0.22047,0.09449),(0.22835,0.09449),(0.23622,0.09449),(0.24409,0.09449),(0.25197,0.09449),(0.25984,0.09449),(0.26772,0.09449),(0.27559,0.09449),(0.28346,0.09449),(0.29134,0.09449),(0.29921,0.09449),(0.30709,0.09449),(0.31496,0.09449),(0.32283,0.09449),(0.33071,0.09449),(0.33858,0.09449),(0.34646,0.09449),(0.35433,0.09449),(0.3622,0.09449),(0.37008,0.09449),(0.37795,0.09449),(0.38583,0.09449),(0.3937,0.09449),(0.40157,0.09449),(0.40945,0.09449),(0.41732,0.09449),(0.4252,0.09449),(0.43307,0.09449),(0.44094,0.09449),(0.44882,0.09449),(0.45669,0.09449),(0.46457,0.09449),(0.47244,0.09449),(0.48031,0.09449),(0.48819,0.09449),(0.49606,0.09449),(0.50394,0.09449),(0.51181,0.09449),(0.51969,0.09449),(0.52756,0.09449),(0.53543,0.09449),(0.54331,0.09449),(0.55118,0.09449),(0.55906,0.09449),(0.56693,0.09449),(0.5748,0.09449),(0.58268,0.09449),(0.59055,0.09449),(0.59843,0.09449),(0.6063,0.09449),(0.61417,0.09449),(0.62205,0.09449),(0.62992,0.09449),(0.6378,0.09449),(0.64567,0.09449),(0.65354,0.09449),(0.66142,0.09449),(0.66929,0.09449),(0.67717,0.09449),(0.68504,0.09449),(0.69291,0.09449),(0.70079,0.09449),(0.70866,0.09449),(0.71654,0.09449),(0.72441,0.09449),(0.73228,0.09449),(0.74016,0.09449),(0.74803,0.09449),(0.75591,0.09449),(0.76378,0.09449),(0.77165,0.09449),(0.77953,0.09449),(0.7874,0.09449),(0.79528,0.09449),(0.80315,0.09449),(0.81102,0.09449),(0.8189,0.09449),(0.82677,0.09449),(0.83465,0.09449),(0.84252,0.09449),(0.85039,0.09449),(0.85827,0.09449),(0.86614,0.09449),(0.87402,0.09449),(0.88189,0.09449),(0.88976,0.09449),(0.89764,0.09449),(0.90551,0.09449),(0.91339,0.09449),(0.92126,0.09449),(0.92913,0.09449),(0.93701,0.09449),(0.94488,0.09449),(0.95276,0.09449),(0.96063,0.09449),(0.9685,0.09449),(0.97638,0.09449),(0.98425,0.09449),(0.99213,0.09449),(0.99609,0.09449),(0.00391,0.10236),(0.00787,0.10236),(0.01575,0.10236),(0.02362,0.10236),(0.0315,0.10236),(0.03937,0.10236),(0.04724,0.10236),(0.05512,0.10236),(0.06299,0.10236),(0.07087,0.10236),(0.07874,0.10236),(0.08661,0.10236),(0.09449,0.10236),(0.10236,0.10236),(0.11024,0.10236),(0.11811,0.10236),(0.12598,0.10236),(0.13386,0.10236),(0.14173,0.10236),(0.14961,0.10236),(0.15748,0.10236),(0.16535,0.10236),(0.17323,0.10236),(0.1811,0.10236),(0.18898,0.10236),(0.19685,0.10236),(0.20472,0.10236),(0.2126,0.10236),(0.22047,0.10236),(0.22835,0.10236),(0.23622,0.10236),(0.24409,0.10236),(0.25197,0.10236),(0.25984,0.10236),(0.26772,0.10236),(0.27559,0.10236),(0.28346,0.10236),(0.29134,0.10236),(0.29921,0.10236),(0.30709,0.10236),(0.31496,0.10236),(0.32283,0.10236),(0.33071,0.10236),(0.33858,0.10236),(0.34646,0.10236),(0.35433,0.10236),(0.3622,0.10236),(0.37008,0.10236),(0.37795,0.10236),(0.38583,0.10236),(0.3937,0.10236),(0.40157,0.10236),(0.40945,0.10236),(0.41732,0.10236),(0.4252,0.10236),(0.43307,0.10236),(0.44094,0.10236),(0.44882,0.10236),(0.45669,0.10236),(0.46457,0.10236),(0.47244,0.10236),(0.48031,0.10236),(0.48819,0.10236),(0.49606,0.10236),(0.50394,0.10236),(0.51181,0.10236),(0.51969,0.10236),(0.52756,0.10236),(0.53543,0.10236),(0.54331,0.10236),(0.55118,0.10236),(0.55906,0.10236),(0.56693,0.10236),(0.5748,0.10236),(0.58268,0.10236),(0.59055,0.10236),(0.59843,0.10236),(0.6063,0.10236),(0.61417,0.10236),(0.62205,0.10236),(0.62992,0.10236),(0.6378,0.10236),(0.64567,0.10236),(0.65354,0.10236),(0.66142,0.10236),(0.66929,0.10236),(0.67717,0.10236),(0.68504,0.10236),(0.69291,0.10236),(0.70079,0.10236),(0.70866,0.10236),(0.71654,0.10236),(0.72441,0.10236),(0.73228,0.10236),(0.74016,0.10236),(0.74803,0.10236),(0.75591,0.10236),(0.76378,0.10236),(0.77165,0.10236),(0.77953,0.10236),(0.7874,0.10236),(0.79528,0.10236),(0.80315,0.10236),(0.81102,0.10236),(0.8189,0.10236),(0.82677,0.10236),(0.83465,0.10236),(0.84252,0.10236),(0.85039,0.10236),(0.85827,0.10236),(0.86614,0.10236),(0.87402,0.10236),(0.88189,0.10236),(0.88976,0.10236),(0.89764,0.10236),(0.90551,0.10236),(0.91339,0.10236),(0.92126,0.10236),(0.92913,0.10236),(0.93701,0.10236),(0.94488,0.10236),(0.95276,0.10236),(0.96063,0.10236),(0.9685,0.10236),(0.97638,0.10236),(0.98425,0.10236),(0.99213,0.10236),(0.99609,0.10236),(0.00391,0.11024),(0.00787,0.11024),(0.01575,0.11024),(0.02362,0.11024),(0.0315,0.11024),(0.03937,0.11024),(0.04724,0.11024),(0.05512,0.11024),(0.06299,0.11024),(0.07087,0.11024),(0.07874,0.11024),(0.08661,0.11024),(0.09449,0.11024),(0.10236,0.11024),(0.11024,0.11024),(0.11811,0.11024),(0.12598,0.11024),(0.13386,0.11024),(0.14173,0.11024),(0.14961,0.11024),(0.15748,0.11024),(0.16535,0.11024),(0.17323,0.11024),(0.1811,0.11024),(0.18898,0.11024),(0.19685,0.11024),(0.20472,0.11024),(0.2126,0.11024),(0.22047,0.11024),(0.22835,0.11024),(0.23622,0.11024),(0.24409,0.11024),(0.25197,0.11024),(0.25984,0.11024),(0.26772,0.11024),(0.27559,0.11024),(0.28346,0.11024),(0.29134,0.11024),(0.29921,0.11024),(0.30709,0.11024),(0.31496,0.11024),(0.32283,0.11024),(0.33071,0.11024),(0.33858,0.11024),(0.34646,0.11024),(0.35433,0.11024),(0.3622,0.11024),(0.37008,0.11024),(0.37795,0.11024),(0.38583,0.11024),(0.3937,0.11024),(0.40157,0.11024),(0.40945,0.11024),(0.41732,0.11024),(0.4252,0.11024),(0.43307,0.11024),(0.44094,0.11024),(0.44882,0.11024),(0.45669,0.11024),(0.46457,0.11024),(0.47244,0.11024),(0.48031,0.11024),(0.48819,0.11024),(0.49606,0.11024),(0.50394,0.11024),(0.51181,0.11024),(0.51969,0.11024),(0.52756,0.11024),(0.53543,0.11024),(0.54331,0.11024),(0.55118,0.11024),(0.55906,0.11024),(0.56693,0.11024),(0.5748,0.11024),(0.58268,0.11024),(0.59055,0.11024),(0.59843,0.11024),(0.6063,0.11024),(0.61417,0.11024),(0.62205,0.11024),(0.62992,0.11024),(0.6378,0.11024),(0.64567,0.11024),(0.65354,0.11024),(0.66142,0.11024),(0.66929,0.11024),(0.67717,0.11024),(0.68504,0.11024),(0.69291,0.11024),(0.70079,0.11024),(0.70866,0.11024),(0.71654,0.11024),(0.72441,0.11024),(0.73228,0.11024),(0.74016,0.11024),(0.74803,0.11024),(0.75591,0.11024),(0.76378,0.11024),(0.77165,0.11024),(0.77953,0.11024),(0.7874,0.11024),(0.79528,0.11024),(0.80315,0.11024),(0.81102,0.11024),(0.8189,0.11024),(0.82677,0.11024),(0.83465,0.11024),(0.84252,0.11024),(0.85039,0.11024),(0.85827,0.11024),(0.86614,0.11024),(0.87402,0.11024),(0.88189,0.11024),(0.88976,0.11024),(0.89764,0.11024),(0.90551,0.11024),(0.91339,0.11024),(0.92126,0.11024),(0.92913,0.11024),(0.93701,0.11024),(0.94488,0.11024),(0.95276,0.11024),(0.96063,0.11024),(0.9685,0.11024),(0.97638,0.11024),(0.98425,0.11024),(0.99213,0.11024),(0.99609,0.11024),(0.00391,0.11811),(0.00787,0.11811),(0.01575,0.11811),(0.02362,0.11811),(0.0315,0.11811),(0.03937,0.11811),(0.04724,0.11811),(0.05512,0.11811),(0.06299,0.11811),(0.07087,0.11811),(0.07874,0.11811),(0.08661,0.11811),(0.09449,0.11811),(0.10236,0.11811),(0.11024,0.11811),(0.11811,0.11811),(0.12598,0.11811),(0.13386,0.11811),(0.14173,0.11811),(0.14961,0.11811),(0.15748,0.11811),(0.16535,0.11811),(0.17323,0.11811),(0.1811,0.11811),(0.18898,0.11811),(0.19685,0.11811),(0.20472,0.11811),(0.2126,0.11811),(0.22047,0.11811),(0.22835,0.11811),(0.23622,0.11811),(0.24409,0.11811),(0.25197,0.11811),(0.25984,0.11811),(0.26772,0.11811),(0.27559,0.11811),(0.28346,0.11811),(0.29134,0.11811),(0.29921,0.11811),(0.30709,0.11811),(0.31496,0.11811),(0.32283,0.11811),(0.33071,0.11811),(0.33858,0.11811),(0.34646,0.11811),(0.35433,0.11811),(0.3622,0.11811),(0.37008,0.11811),(0.37795,0.11811),(0.38583,0.11811),(0.3937,0.11811),(0.40157,0.11811),(0.40945,0.11811),(0.41732,0.11811),(0.4252,0.11811),(0.43307,0.11811),(0.44094,0.11811),(0.44882,0.11811),(0.45669,0.11811),(0.46457,0.11811),(0.47244,0.11811),(0.48031,0.11811),(0.48819,0.11811),(0.49606,0.11811),(0.50394,0.11811),(0.51181,0.11811),(0.51969,0.11811),(0.52756,0.11811),(0.53543,0.11811),(0.54331,0.11811),(0.55118,0.11811),(0.55906,0.11811),(0.56693,0.11811),(0.5748,0.11811),(0.58268,0.11811),(0.59055,0.11811),(0.59843,0.11811),(0.6063,0.11811),(0.61417,0.11811),(0.62205,0.11811),(0.62992,0.11811),(0.6378,0.11811),(0.64567,0.11811),(0.65354,0.11811),(0.66142,0.11811),(0.66929,0.11811),(0.67717,0.11811),(0.68504,0.11811),(0.69291,0.11811),(0.70079,0.11811),(0.70866,0.11811),(0.71654,0.11811),(0.72441,0.11811),(0.73228,0.11811),(0.74016,0.11811),(0.74803,0.11811),(0.75591,0.11811),(0.76378,0.11811),(0.77165,0.11811),(0.77953,0.11811),(0.7874,0.11811),(0.79528,0.11811),(0.80315,0.11811),(0.81102,0.11811),(0.8189,0.11811),(0.82677,0.11811),(0.83465,0.11811),(0.84252,0.11811),(0.85039,0.11811),(0.85827,0.11811),(0.86614,0.11811),(0.87402,0.11811),(0.88189,0.11811),(0.88976,0.11811),(0.89764,0.11811),(0.90551,0.11811),(0.91339,0.11811),(0.92126,0.11811),(0.92913,0.11811),(0.93701,0.11811),(0.94488,0.11811),(0.95276,0.11811),(0.96063,0.11811),(0.9685,0.11811),(0.97638,0.11811),(0.98425,0.11811),(0.99213,0.11811),(0.99609,0.11811),(0.00391,0.12598),(0.00787,0.12598),(0.01575,0.12598),(0.02362,0.12598),(0.0315,0.12598),(0.03937,0.12598),(0.04724,0.12598),(0.05512,0.12598),(0.06299,0.12598),(0.07087,0.12598),(0.07874,0.12598),(0.08661,0.12598),(0.09449,0.12598),(0.10236,0.12598),(0.11024,0.12598),(0.11811,0.12598),(0.12598,0.12598),(0.13386,0.12598),(0.14173,0.12598),(0.14961,0.12598),(0.15748,0.12598),(0.16535,0.12598),(0.17323,0.12598),(0.1811,0.12598),(0.18898,0.12598),(0.19685,0.12598),(0.20472,0.12598),(0.2126,0.12598),(0.22047,0.12598),(0.22835,0.12598),(0.23622,0.12598),(0.24409,0.12598),(0.25197,0.12598),(0.25984,0.12598),(0.26772,0.12598),(0.27559,0.12598),(0.28346,0.12598),(0.29134,0.12598),(0.29921,0.12598),(0.30709,0.12598),(0.31496,0.12598),(0.32283,0.12598),(0.33071,0.12598),(0.33858,0.12598),(0.34646,0.12598),(0.35433,0.12598),(0.3622,0.12598),(0.37008,0.12598),(0.37795,0.12598),(0.38583,0.12598),(0.3937,0.12598),(0.40157,0.12598),(0.40945,0.12598),(0.41732,0.12598),(0.4252,0.12598),(0.43307,0.12598),(0.44094,0.12598),(0.44882,0.12598),(0.45669,0.12598),(0.46457,0.12598),(0.47244,0.12598),(0.48031,0.12598),(0.48819,0.12598),(0.49606,0.12598),(0.50394,0.12598),(0.51181,0.12598),(0.51969,0.12598),(0.52756,0.12598),(0.53543,0.12598),(0.54331,0.12598),(0.55118,0.12598),(0.55906,0.12598),(0.56693,0.12598),(0.5748,0.12598),(0.58268,0.12598),(0.59055,0.12598),(0.59843,0.12598),(0.6063,0.12598),(0.61417,0.12598),(0.62205,0.12598),(0.62992,0.12598),(0.6378,0.12598),(0.64567,0.12598),(0.65354,0.12598),(0.66142,0.12598),(0.66929,0.12598),(0.67717,0.12598),(0.68504,0.12598),(0.69291,0.12598),(0.70079,0.12598),(0.70866,0.12598),(0.71654,0.12598),(0.72441,0.12598),(0.73228,0.12598),(0.74016,0.12598),(0.74803,0.12598),(0.75591,0.12598),(0.76378,0.12598),(0.77165,0.12598),(0.77953,0.12598),(0.7874,0.12598),(0.79528,0.12598),(0.80315,0.12598),(0.81102,0.12598),(0.8189,0.12598),(0.82677,0.12598),(0.83465,0.12598),(0.84252,0.12598),(0.85039,0.12598),(0.85827,0.12598),(0.86614,0.12598),(0.87402,0.12598),(0.88189,0.12598),(0.88976,0.12598),(0.89764,0.12598),(0.90551,0.12598),(0.91339,0.12598),(0.92126,0.12598),(0.92913,0.12598),(0.93701,0.12598),(0.94488,0.12598),(0.95276,0.12598),(0.96063,0.12598),(0.9685,0.12598),(0.97638,0.12598),(0.98425,0.12598),(0.99213,0.12598),(0.99609,0.12598),(0.00391,0.13386),(0.00787,0.13386),(0.01575,0.13386),(0.02362,0.13386),(0.0315,0.13386),(0.03937,0.13386),(0.04724,0.13386),(0.05512,0.13386),(0.06299,0.13386),(0.07087,0.13386),(0.07874,0.13386),(0.08661,0.13386),(0.09449,0.13386),(0.10236,0.13386),(0.11024,0.13386),(0.11811,0.13386),(0.12598,0.13386),(0.13386,0.13386),(0.14173,0.13386),(0.14961,0.13386),(0.15748,0.13386),(0.16535,0.13386),(0.17323,0.13386),(0.1811,0.13386),(0.18898,0.13386),(0.19685,0.13386),(0.20472,0.13386),(0.2126,0.13386),(0.22047,0.13386),(0.22835,0.13386),(0.23622,0.13386),(0.24409,0.13386),(0.25197,0.13386),(0.25984,0.13386),(0.26772,0.13386),(0.27559,0.13386),(0.28346,0.13386),(0.29134,0.13386),(0.29921,0.13386),(0.30709,0.13386),(0.31496,0.13386),(0.32283,0.13386),(0.33071,0.13386),(0.33858,0.13386),(0.34646,0.13386),(0.35433,0.13386),(0.3622,0.13386),(0.37008,0.13386),(0.37795,0.13386),(0.38583,0.13386),(0.3937,0.13386),(0.40157,0.13386),(0.40945,0.13386),(0.41732,0.13386),(0.4252,0.13386),(0.43307,0.13386),(0.44094,0.13386),(0.44882,0.13386),(0.45669,0.13386),(0.46457,0.13386),(0.47244,0.13386),(0.48031,0.13386),(0.48819,0.13386),(0.49606,0.13386),(0.50394,0.13386),(0.51181,0.13386),(0.51969,0.13386),(0.52756,0.13386),(0.53543,0.13386),(0.54331,0.13386),(0.55118,0.13386),(0.55906,0.13386),(0.56693,0.13386),(0.5748,0.13386),(0.58268,0.13386),(0.59055,0.13386),(0.59843,0.13386),(0.6063,0.13386),(0.61417,0.13386),(0.62205,0.13386),(0.62992,0.13386),(0.6378,0.13386),(0.64567,0.13386),(0.65354,0.13386),(0.66142,0.13386),(0.66929,0.13386),(0.67717,0.13386),(0.68504,0.13386),(0.69291,0.13386),(0.70079,0.13386),(0.70866,0.13386),(0.71654,0.13386),(0.72441,0.13386),(0.73228,0.13386),(0.74016,0.13386),(0.74803,0.13386),(0.75591,0.13386),(0.76378,0.13386),(0.77165,0.13386),(0.77953,0.13386),(0.7874,0.13386),(0.79528,0.13386),(0.80315,0.13386),(0.81102,0.13386),(0.8189,0.13386),(0.82677,0.13386),(0.83465,0.13386),(0.84252,0.13386),(0.85039,0.13386),(0.85827,0.13386),(0.86614,0.13386),(0.87402,0.13386),(0.88189,0.13386),(0.88976,0.13386),(0.89764,0.13386),(0.90551,0.13386),(0.91339,0.13386),(0.92126,0.13386),(0.92913,0.13386),(0.93701,0.13386),(0.94488,0.13386),(0.95276,0.13386),(0.96063,0.13386),(0.9685,0.13386),(0.97638,0.13386),(0.98425,0.13386),(0.99213,0.13386),(0.99609,0.13386),(0.00391,0.14173),(0.00787,0.14173),(0.01575,0.14173),(0.02362,0.14173),(0.0315,0.14173),(0.03937,0.14173),(0.04724,0.14173),(0.05512,0.14173),(0.06299,0.14173),(0.07087,0.14173),(0.07874,0.14173),(0.08661,0.14173),(0.09449,0.14173),(0.10236,0.14173),(0.11024,0.14173),(0.11811,0.14173),(0.12598,0.14173),(0.13386,0.14173),(0.14173,0.14173),(0.14961,0.14173),(0.15748,0.14173),(0.16535,0.14173),(0.17323,0.14173),(0.1811,0.14173),(0.18898,0.14173),(0.19685,0.14173),(0.20472,0.14173),(0.2126,0.14173),(0.22047,0.14173),(0.22835,0.14173),(0.23622,0.14173),(0.24409,0.14173),(0.25197,0.14173),(0.25984,0.14173),(0.26772,0.14173),(0.27559,0.14173),(0.28346,0.14173),(0.29134,0.14173),(0.29921,0.14173),(0.30709,0.14173),(0.31496,0.14173),(0.32283,0.14173),(0.33071,0.14173),(0.33858,0.14173),(0.34646,0.14173),(0.35433,0.14173),(0.3622,0.14173),(0.37008,0.14173),(0.37795,0.14173),(0.38583,0.14173),(0.3937,0.14173),(0.40157,0.14173),(0.40945,0.14173),(0.41732,0.14173),(0.4252,0.14173),(0.43307,0.14173),(0.44094,0.14173),(0.44882,0.14173),(0.45669,0.14173),(0.46457,0.14173),(0.47244,0.14173),(0.48031,0.14173),(0.48819,0.14173),(0.49606,0.14173),(0.50394,0.14173),(0.51181,0.14173),(0.51969,0.14173),(0.52756,0.14173),(0.53543,0.14173),(0.54331,0.14173),(0.55118,0.14173),(0.55906,0.14173),(0.56693,0.14173),(0.5748,0.14173),(0.58268,0.14173),(0.59055,0.14173),(0.59843,0.14173),(0.6063,0.14173),(0.61417,0.14173),(0.62205,0.14173),(0.62992,0.14173),(0.6378,0.14173),(0.64567,0.14173),(0.65354,0.14173),(0.66142,0.14173),(0.66929,0.14173),(0.67717,0.14173),(0.68504,0.14173),(0.69291,0.14173),(0.70079,0.14173),(0.70866,0.14173),(0.71654,0.14173),(0.72441,0.14173),(0.73228,0.14173),(0.74016,0.14173),(0.74803,0.14173),(0.75591,0.14173),(0.76378,0.14173),(0.77165,0.14173),(0.77953,0.14173),(0.7874,0.14173),(0.79528,0.14173),(0.80315,0.14173),(0.81102,0.14173),(0.8189,0.14173),(0.82677,0.14173),(0.83465,0.14173),(0.84252,0.14173),(0.85039,0.14173),(0.85827,0.14173),(0.86614,0.14173),(0.87402,0.14173),(0.88189,0.14173),(0.88976,0.14173),(0.89764,0.14173),(0.90551,0.14173),(0.91339,0.14173),(0.92126,0.14173),(0.92913,0.14173),(0.93701,0.14173),(0.94488,0.14173),(0.95276,0.14173),(0.96063,0.14173),(0.9685,0.14173),(0.97638,0.14173),(0.98425,0.14173),(0.99213,0.14173),(0.99609,0.14173),(0.00391,0.14961),(0.00787,0.14961),(0.01575,0.14961),(0.02362,0.14961),(0.0315,0.14961),(0.03937,0.14961),(0.04724,0.14961),(0.05512,0.14961),(0.06299,0.14961),(0.07087,0.14961),(0.07874,0.14961),(0.08661,0.14961),(0.09449,0.14961),(0.10236,0.14961),(0.11024,0.14961),(0.11811,0.14961),(0.12598,0.14961),(0.13386,0.14961),(0.14173,0.14961),(0.14961,0.14961),(0.15748,0.14961),(0.16535,0.14961),(0.17323,0.14961),(0.1811,0.14961),(0.18898,0.14961),(0.19685,0.14961),(0.20472,0.14961),(0.2126,0.14961),(0.22047,0.14961),(0.22835,0.14961),(0.23622,0.14961),(0.24409,0.14961),(0.25197,0.14961),(0.25984,0.14961),(0.26772,0.14961),(0.27559,0.14961),(0.28346,0.14961),(0.29134,0.14961),(0.29921,0.14961),(0.30709,0.14961),(0.31496,0.14961),(0.32283,0.14961),(0.33071,0.14961),(0.33858,0.14961),(0.34646,0.14961),(0.35433,0.14961),(0.3622,0.14961),(0.37008,0.14961),(0.37795,0.14961),(0.38583,0.14961),(0.3937,0.14961),(0.40157,0.14961),(0.40945,0.14961),(0.41732,0.14961),(0.4252,0.14961),(0.43307,0.14961),(0.44094,0.14961),(0.44882,0.14961),(0.45669,0.14961),(0.46457,0.14961),(0.47244,0.14961),(0.48031,0.14961),(0.48819,0.14961),(0.49606,0.14961),(0.50394,0.14961),(0.51181,0.14961),(0.51969,0.14961),(0.52756,0.14961),(0.53543,0.14961),(0.54331,0.14961),(0.55118,0.14961),(0.55906,0.14961),(0.56693,0.14961),(0.5748,0.14961),(0.58268,0.14961),(0.59055,0.14961),(0.59843,0.14961),(0.6063,0.14961),(0.61417,0.14961),(0.62205,0.14961),(0.62992,0.14961),(0.6378,0.14961),(0.64567,0.14961),(0.65354,0.14961),(0.66142,0.14961),(0.66929,0.14961),(0.67717,0.14961),(0.68504,0.14961),(0.69291,0.14961),(0.70079,0.14961),(0.70866,0.14961),(0.71654,0.14961),(0.72441,0.14961),(0.73228,0.14961),(0.74016,0.14961),(0.74803,0.14961),(0.75591,0.14961),(0.76378,0.14961),(0.77165,0.14961),(0.77953,0.14961),(0.7874,0.14961),(0.79528,0.14961),(0.80315,0.14961),(0.81102,0.14961),(0.8189,0.14961),(0.82677,0.14961),(0.83465,0.14961),(0.84252,0.14961),(0.85039,0.14961),(0.85827,0.14961),(0.86614,0.14961),(0.87402,0.14961),(0.88189,0.14961),(0.88976,0.14961),(0.89764,0.14961),(0.90551,0.14961),(0.91339,0.14961),(0.92126,0.14961),(0.92913,0.14961),(0.93701,0.14961),(0.94488,0.14961),(0.95276,0.14961),(0.96063,0.14961),(0.9685,0.14961),(0.97638,0.14961),(0.98425,0.14961),(0.99213,0.14961),(0.99609,0.14961),(0.00391,0.15748),(0.00787,0.15748),(0.01575,0.15748),(0.02362,0.15748),(0.0315,0.15748),(0.03937,0.15748),(0.04724,0.15748),(0.05512,0.15748),(0.06299,0.15748),(0.07087,0.15748),(0.07874,0.15748),(0.08661,0.15748),(0.09449,0.15748),(0.10236,0.15748),(0.11024,0.15748),(0.11811,0.15748),(0.12598,0.15748),(0.13386,0.15748),(0.14173,0.15748),(0.14961,0.15748),(0.15748,0.15748),(0.16535,0.15748),(0.17323,0.15748),(0.1811,0.15748),(0.18898,0.15748),(0.19685,0.15748),(0.20472,0.15748),(0.2126,0.15748),(0.22047,0.15748),(0.22835,0.15748),(0.23622,0.15748),(0.24409,0.15748),(0.25197,0.15748),(0.25984,0.15748),(0.26772,0.15748),(0.27559,0.15748),(0.28346,0.15748),(0.29134,0.15748),(0.29921,0.15748),(0.30709,0.15748),(0.31496,0.15748),(0.32283,0.15748),(0.33071,0.15748),(0.33858,0.15748),(0.34646,0.15748),(0.35433,0.15748),(0.3622,0.15748),(0.37008,0.15748),(0.37795,0.15748),(0.38583,0.15748),(0.3937,0.15748),(0.40157,0.15748),(0.40945,0.15748),(0.41732,0.15748),(0.4252,0.15748),(0.43307,0.15748),(0.44094,0.15748),(0.44882,0.15748),(0.45669,0.15748),(0.46457,0.15748),(0.47244,0.15748),(0.48031,0.15748),(0.48819,0.15748),(0.49606,0.15748),(0.50394,0.15748),(0.51181,0.15748),(0.51969,0.15748),(0.52756,0.15748),(0.53543,0.15748),(0.54331,0.15748),(0.55118,0.15748),(0.55906,0.15748),(0.56693,0.15748),(0.5748,0.15748),(0.58268,0.15748),(0.59055,0.15748),(0.59843,0.15748),(0.6063,0.15748),(0.61417,0.15748),(0.62205,0.15748),(0.62992,0.15748),(0.6378,0.15748),(0.64567,0.15748),(0.65354,0.15748),(0.66142,0.15748),(0.66929,0.15748),(0.67717,0.15748),(0.68504,0.15748),(0.69291,0.15748),(0.70079,0.15748),(0.70866,0.15748),(0.71654,0.15748),(0.72441,0.15748),(0.73228,0.15748),(0.74016,0.15748),(0.74803,0.15748),(0.75591,0.15748),(0.76378,0.15748),(0.77165,0.15748),(0.77953,0.15748),(0.7874,0.15748),(0.79528,0.15748),(0.80315,0.15748),(0.81102,0.15748),(0.8189,0.15748),(0.82677,0.15748),(0.83465,0.15748),(0.84252,0.15748),(0.85039,0.15748),(0.85827,0.15748),(0.86614,0.15748),(0.87402,0.15748),(0.88189,0.15748),(0.88976,0.15748),(0.89764,0.15748),(0.90551,0.15748),(0.91339,0.15748),(0.92126,0.15748),(0.92913,0.15748),(0.93701,0.15748),(0.94488,0.15748),(0.95276,0.15748),(0.96063,0.15748),(0.9685,0.15748),(0.97638,0.15748),(0.98425,0.15748),(0.99213,0.15748),(0.99609,0.15748),(0.00391,0.16535),(0.00787,0.16535),(0.01575,0.16535),(0.02362,0.16535),(0.0315,0.16535),(0.03937,0.16535),(0.04724,0.16535),(0.05512,0.16535),(0.06299,0.16535),(0.07087,0.16535),(0.07874,0.16535),(0.08661,0.16535),(0.09449,0.16535),(0.10236,0.16535),(0.11024,0.16535),(0.11811,0.16535),(0.12598,0.16535),(0.13386,0.16535),(0.14173,0.16535),(0.14961,0.16535),(0.15748,0.16535),(0.16535,0.16535),(0.17323,0.16535),(0.1811,0.16535),(0.18898,0.16535),(0.19685,0.16535),(0.20472,0.16535),(0.2126,0.16535),(0.22047,0.16535),(0.22835,0.16535),(0.23622,0.16535),(0.24409,0.16535),(0.25197,0.16535),(0.25984,0.16535),(0.26772,0.16535),(0.27559,0.16535),(0.28346,0.16535),(0.29134,0.16535),(0.29921,0.16535),(0.30709,0.16535),(0.31496,0.16535),(0.32283,0.16535),(0.33071,0.16535),(0.33858,0.16535),(0.34646,0.16535),(0.35433,0.16535),(0.3622,0.16535),(0.37008,0.16535),(0.37795,0.16535),(0.38583,0.16535),(0.3937,0.16535),(0.40157,0.16535),(0.40945,0.16535),(0.41732,0.16535),(0.4252,0.16535),(0.43307,0.16535),(0.44094,0.16535),(0.44882,0.16535),(0.45669,0.16535),(0.46457,0.16535),(0.47244,0.16535),(0.48031,0.16535),(0.48819,0.16535),(0.49606,0.16535),(0.50394,0.16535),(0.51181,0.16535),(0.51969,0.16535),(0.52756,0.16535),(0.53543,0.16535),(0.54331,0.16535),(0.55118,0.16535),(0.55906,0.16535),(0.56693,0.16535),(0.5748,0.16535),(0.58268,0.16535),(0.59055,0.16535),(0.59843,0.16535),(0.6063,0.16535),(0.61417,0.16535),(0.62205,0.16535),(0.62992,0.16535),(0.6378,0.16535),(0.64567,0.16535),(0.65354,0.16535),(0.66142,0.16535),(0.66929,0.16535),(0.67717,0.16535),(0.68504,0.16535),(0.69291,0.16535),(0.70079,0.16535),(0.70866,0.16535),(0.71654,0.16535),(0.72441,0.16535),(0.73228,0.16535),(0.74016,0.16535),(0.74803,0.16535),(0.75591,0.16535),(0.76378,0.16535),(0.77165,0.16535),(0.77953,0.16535),(0.7874,0.16535),(0.79528,0.16535),(0.80315,0.16535),(0.81102,0.16535),(0.8189,0.16535),(0.82677,0.16535),(0.83465,0.16535),(0.84252,0.16535),(0.85039,0.16535),(0.85827,0.16535),(0.86614,0.16535),(0.87402,0.16535),(0.88189,0.16535),(0.88976,0.16535),(0.89764,0.16535),(0.90551,0.16535),(0.91339,0.16535),(0.92126,0.16535),(0.92913,0.16535),(0.93701,0.16535),(0.94488,0.16535),(0.95276,0.16535),(0.96063,0.16535),(0.9685,0.16535),(0.97638,0.16535),(0.98425,0.16535),(0.99213,0.16535),(0.99609,0.16535),(0.00391,0.17323),(0.00787,0.17323),(0.01575,0.17323),(0.02362,0.17323),(0.0315,0.17323),(0.03937,0.17323),(0.04724,0.17323),(0.05512,0.17323),(0.06299,0.17323),(0.07087,0.17323),(0.07874,0.17323),(0.08661,0.17323),(0.09449,0.17323),(0.10236,0.17323),(0.11024,0.17323),(0.11811,0.17323),(0.12598,0.17323),(0.13386,0.17323),(0.14173,0.17323),(0.14961,0.17323),(0.15748,0.17323),(0.16535,0.17323),(0.17323,0.17323),(0.1811,0.17323),(0.18898,0.17323),(0.19685,0.17323),(0.20472,0.17323),(0.2126,0.17323),(0.22047,0.17323),(0.22835,0.17323),(0.23622,0.17323),(0.24409,0.17323),(0.25197,0.17323),(0.25984,0.17323),(0.26772,0.17323),(0.27559,0.17323),(0.28346,0.17323),(0.29134,0.17323),(0.29921,0.17323),(0.30709,0.17323),(0.31496,0.17323),(0.32283,0.17323),(0.33071,0.17323),(0.33858,0.17323),(0.34646,0.17323),(0.35433,0.17323),(0.3622,0.17323),(0.37008,0.17323),(0.37795,0.17323),(0.38583,0.17323),(0.3937,0.17323),(0.40157,0.17323),(0.40945,0.17323),(0.41732,0.17323),(0.4252,0.17323),(0.43307,0.17323),(0.44094,0.17323),(0.44882,0.17323),(0.45669,0.17323),(0.46457,0.17323),(0.47244,0.17323),(0.48031,0.17323),(0.48819,0.17323),(0.49606,0.17323),(0.50394,0.17323),(0.51181,0.17323),(0.51969,0.17323),(0.52756,0.17323),(0.53543,0.17323),(0.54331,0.17323),(0.55118,0.17323),(0.55906,0.17323),(0.56693,0.17323),(0.5748,0.17323),(0.58268,0.17323),(0.59055,0.17323),(0.59843,0.17323),(0.6063,0.17323),(0.61417,0.17323),(0.62205,0.17323),(0.62992,0.17323),(0.6378,0.17323),(0.64567,0.17323),(0.65354,0.17323),(0.66142,0.17323),(0.66929,0.17323),(0.67717,0.17323),(0.68504,0.17323),(0.69291,0.17323),(0.70079,0.17323),(0.70866,0.17323),(0.71654,0.17323),(0.72441,0.17323),(0.73228,0.17323),(0.74016,0.17323),(0.74803,0.17323),(0.75591,0.17323),(0.76378,0.17323),(0.77165,0.17323),(0.77953,0.17323),(0.7874,0.17323),(0.79528,0.17323),(0.80315,0.17323),(0.81102,0.17323),(0.8189,0.17323),(0.82677,0.17323),(0.83465,0.17323),(0.84252,0.17323),(0.85039,0.17323),(0.85827,0.17323),(0.86614,0.17323),(0.87402,0.17323),(0.88189,0.17323),(0.88976,0.17323),(0.89764,0.17323),(0.90551,0.17323),(0.91339,0.17323),(0.92126,0.17323),(0.92913,0.17323),(0.93701,0.17323),(0.94488,0.17323),(0.95276,0.17323),(0.96063,0.17323),(0.9685,0.17323),(0.97638,0.17323),(0.98425,0.17323),(0.99213,0.17323),(0.99609,0.17323),(0.00391,0.1811),(0.00787,0.1811),(0.01575,0.1811),(0.02362,0.1811),(0.0315,0.1811),(0.03937,0.1811),(0.04724,0.1811),(0.05512,0.1811),(0.06299,0.1811),(0.07087,0.1811),(0.07874,0.1811),(0.08661,0.1811),(0.09449,0.1811),(0.10236,0.1811),(0.11024,0.1811),(0.11811,0.1811),(0.12598,0.1811),(0.13386,0.1811),(0.14173,0.1811),(0.14961,0.1811),(0.15748,0.1811),(0.16535,0.1811),(0.17323,0.1811),(0.1811,0.1811),(0.18898,0.1811),(0.19685,0.1811),(0.20472,0.1811),(0.2126,0.1811),(0.22047,0.1811),(0.22835,0.1811),(0.23622,0.1811),(0.24409,0.1811),(0.25197,0.1811),(0.25984,0.1811),(0.26772,0.1811),(0.27559,0.1811),(0.28346,0.1811),(0.29134,0.1811),(0.29921,0.1811),(0.30709,0.1811),(0.31496,0.1811),(0.32283,0.1811),(0.33071,0.1811),(0.33858,0.1811),(0.34646,0.1811),(0.35433,0.1811),(0.3622,0.1811),(0.37008,0.1811),(0.37795,0.1811),(0.38583,0.1811),(0.3937,0.1811),(0.40157,0.1811),(0.40945,0.1811),(0.41732,0.1811),(0.4252,0.1811),(0.43307,0.1811),(0.44094,0.1811),(0.44882,0.1811),(0.45669,0.1811),(0.46457,0.1811),(0.47244,0.1811),(0.48031,0.1811),(0.48819,0.1811),(0.49606,0.1811),(0.50394,0.1811),(0.51181,0.1811),(0.51969,0.1811),(0.52756,0.1811),(0.53543,0.1811),(0.54331,0.1811),(0.55118,0.1811),(0.55906,0.1811),(0.56693,0.1811),(0.5748,0.1811),(0.58268,0.1811),(0.59055,0.1811),(0.59843,0.1811),(0.6063,0.1811),(0.61417,0.1811),(0.62205,0.1811),(0.62992,0.1811),(0.6378,0.1811),(0.64567,0.1811),(0.65354,0.1811),(0.66142,0.1811),(0.66929,0.1811),(0.67717,0.1811),(0.68504,0.1811),(0.69291,0.1811),(0.70079,0.1811),(0.70866,0.1811),(0.71654,0.1811),(0.72441,0.1811),(0.73228,0.1811),(0.74016,0.1811),(0.74803,0.1811),(0.75591,0.1811),(0.76378,0.1811),(0.77165,0.1811),(0.77953,0.1811),(0.7874,0.1811),(0.79528,0.1811),(0.80315,0.1811),(0.81102,0.1811),(0.8189,0.1811),(0.82677,0.1811),(0.83465,0.1811),(0.84252,0.1811),(0.85039,0.1811),(0.85827,0.1811),(0.86614,0.1811),(0.87402,0.1811),(0.88189,0.1811),(0.88976,0.1811),(0.89764,0.1811),(0.90551,0.1811),(0.91339,0.1811),(0.92126,0.1811),(0.92913,0.1811),(0.93701,0.1811),(0.94488,0.1811),(0.95276,0.1811),(0.96063,0.1811),(0.9685,0.1811),(0.97638,0.1811),(0.98425,0.1811),(0.99213,0.1811),(0.99609,0.1811),(0.00391,0.18898),(0.00787,0.18898),(0.01575,0.18898),(0.02362,0.18898),(0.0315,0.18898),(0.03937,0.18898),(0.04724,0.18898),(0.05512,0.18898),(0.06299,0.18898),(0.07087,0.18898),(0.07874,0.18898),(0.08661,0.18898),(0.09449,0.18898),(0.10236,0.18898),(0.11024,0.18898),(0.11811,0.18898),(0.12598,0.18898),(0.13386,0.18898),(0.14173,0.18898),(0.14961,0.18898),(0.15748,0.18898),(0.16535,0.18898),(0.17323,0.18898),(0.1811,0.18898),(0.18898,0.18898),(0.19685,0.18898),(0.20472,0.18898),(0.2126,0.18898),(0.22047,0.18898),(0.22835,0.18898),(0.23622,0.18898),(0.24409,0.18898),(0.25197,0.18898),(0.25984,0.18898),(0.26772,0.18898),(0.27559,0.18898),(0.28346,0.18898),(0.29134,0.18898),(0.29921,0.18898),(0.30709,0.18898),(0.31496,0.18898),(0.32283,0.18898),(0.33071,0.18898),(0.33858,0.18898),(0.34646,0.18898),(0.35433,0.18898),(0.3622,0.18898),(0.37008,0.18898),(0.37795,0.18898),(0.38583,0.18898),(0.3937,0.18898),(0.40157,0.18898),(0.40945,0.18898),(0.41732,0.18898),(0.4252,0.18898),(0.43307,0.18898),(0.44094,0.18898),(0.44882,0.18898),(0.45669,0.18898),(0.46457,0.18898),(0.47244,0.18898),(0.48031,0.18898),(0.48819,0.18898),(0.49606,0.18898),(0.50394,0.18898),(0.51181,0.18898),(0.51969,0.18898),(0.52756,0.18898),(0.53543,0.18898),(0.54331,0.18898),(0.55118,0.18898),(0.55906,0.18898),(0.56693,0.18898),(0.5748,0.18898),(0.58268,0.18898),(0.59055,0.18898),(0.59843,0.18898),(0.6063,0.18898),(0.61417,0.18898),(0.62205,0.18898),(0.62992,0.18898),(0.6378,0.18898),(0.64567,0.18898),(0.65354,0.18898),(0.66142,0.18898),(0.66929,0.18898),(0.67717,0.18898),(0.68504,0.18898),(0.69291,0.18898),(0.70079,0.18898),(0.70866,0.18898),(0.71654,0.18898),(0.72441,0.18898),(0.73228,0.18898),(0.74016,0.18898),(0.74803,0.18898),(0.75591,0.18898),(0.76378,0.18898),(0.77165,0.18898),(0.77953,0.18898),(0.7874,0.18898),(0.79528,0.18898),(0.80315,0.18898),(0.81102,0.18898),(0.8189,0.18898),(0.82677,0.18898),(0.83465,0.18898),(0.84252,0.18898),(0.85039,0.18898),(0.85827,0.18898),(0.86614,0.18898),(0.87402,0.18898),(0.88189,0.18898),(0.88976,0.18898),(0.89764,0.18898),(0.90551,0.18898),(0.91339,0.18898),(0.92126,0.18898),(0.92913,0.18898),(0.93701,0.18898),(0.94488,0.18898),(0.95276,0.18898),(0.96063,0.18898),(0.9685,0.18898),(0.97638,0.18898),(0.98425,0.18898),(0.99213,0.18898),(0.99609,0.18898),(0.00391,0.19685),(0.00787,0.19685),(0.01575,0.19685),(0.02362,0.19685),(0.0315,0.19685),(0.03937,0.19685),(0.04724,0.19685),(0.05512,0.19685),(0.06299,0.19685),(0.07087,0.19685),(0.07874,0.19685),(0.08661,0.19685),(0.09449,0.19685),(0.10236,0.19685),(0.11024,0.19685),(0.11811,0.19685),(0.12598,0.19685),(0.13386,0.19685),(0.14173,0.19685),(0.14961,0.19685),(0.15748,0.19685),(0.16535,0.19685),(0.17323,0.19685),(0.1811,0.19685),(0.18898,0.19685),(0.19685,0.19685),(0.20472,0.19685),(0.2126,0.19685),(0.22047,0.19685),(0.22835,0.19685),(0.23622,0.19685),(0.24409,0.19685),(0.25197,0.19685),(0.25984,0.19685),(0.26772,0.19685),(0.27559,0.19685),(0.28346,0.19685),(0.29134,0.19685),(0.29921,0.19685),(0.30709,0.19685),(0.31496,0.19685),(0.32283,0.19685),(0.33071,0.19685),(0.33858,0.19685),(0.34646,0.19685),(0.35433,0.19685),(0.3622,0.19685),(0.37008,0.19685),(0.37795,0.19685),(0.38583,0.19685),(0.3937,0.19685),(0.40157,0.19685),(0.40945,0.19685),(0.41732,0.19685),(0.4252,0.19685),(0.43307,0.19685),(0.44094,0.19685),(0.44882,0.19685),(0.45669,0.19685),(0.46457,0.19685),(0.47244,0.19685),(0.48031,0.19685),(0.48819,0.19685),(0.49606,0.19685),(0.50394,0.19685),(0.51181,0.19685),(0.51969,0.19685),(0.52756,0.19685),(0.53543,0.19685),(0.54331,0.19685),(0.55118,0.19685),(0.55906,0.19685),(0.56693,0.19685),(0.5748,0.19685),(0.58268,0.19685),(0.59055,0.19685),(0.59843,0.19685),(0.6063,0.19685),(0.61417,0.19685),(0.62205,0.19685),(0.62992,0.19685),(0.6378,0.19685),(0.64567,0.19685),(0.65354,0.19685),(0.66142,0.19685),(0.66929,0.19685),(0.67717,0.19685),(0.68504,0.19685),(0.69291,0.19685),(0.70079,0.19685),(0.70866,0.19685),(0.71654,0.19685),(0.72441,0.19685),(0.73228,0.19685),(0.74016,0.19685),(0.74803,0.19685),(0.75591,0.19685),(0.76378,0.19685),(0.77165,0.19685),(0.77953,0.19685),(0.7874,0.19685),(0.79528,0.19685),(0.80315,0.19685),(0.81102,0.19685),(0.8189,0.19685),(0.82677,0.19685),(0.83465,0.19685),(0.84252,0.19685),(0.85039,0.19685),(0.85827,0.19685),(0.86614,0.19685),(0.87402,0.19685),(0.88189,0.19685),(0.88976,0.19685),(0.89764,0.19685),(0.90551,0.19685),(0.91339,0.19685),(0.92126,0.19685),(0.92913,0.19685),(0.93701,0.19685),(0.94488,0.19685),(0.95276,0.19685),(0.96063,0.19685),(0.9685,0.19685),(0.97638,0.19685),(0.98425,0.19685),(0.99213,0.19685),(0.99609,0.19685),(0.00391,0.20472),(0.00787,0.20472),(0.01575,0.20472),(0.02362,0.20472),(0.0315,0.20472),(0.03937,0.20472),(0.04724,0.20472),(0.05512,0.20472),(0.06299,0.20472),(0.07087,0.20472),(0.07874,0.20472),(0.08661,0.20472),(0.09449,0.20472),(0.10236,0.20472),(0.11024,0.20472),(0.11811,0.20472),(0.12598,0.20472),(0.13386,0.20472),(0.14173,0.20472),(0.14961,0.20472),(0.15748,0.20472),(0.16535,0.20472),(0.17323,0.20472),(0.1811,0.20472),(0.18898,0.20472),(0.19685,0.20472),(0.20472,0.20472),(0.2126,0.20472),(0.22047,0.20472),(0.22835,0.20472),(0.23622,0.20472),(0.24409,0.20472),(0.25197,0.20472),(0.25984,0.20472),(0.26772,0.20472),(0.27559,0.20472),(0.28346,0.20472),(0.29134,0.20472),(0.29921,0.20472),(0.30709,0.20472),(0.31496,0.20472),(0.32283,0.20472),(0.33071,0.20472),(0.33858,0.20472),(0.34646,0.20472),(0.35433,0.20472),(0.3622,0.20472),(0.37008,0.20472),(0.37795,0.20472),(0.38583,0.20472),(0.3937,0.20472),(0.40157,0.20472),(0.40945,0.20472),(0.41732,0.20472),(0.4252,0.20472),(0.43307,0.20472),(0.44094,0.20472),(0.44882,0.20472),(0.45669,0.20472),(0.46457,0.20472),(0.47244,0.20472),(0.48031,0.20472),(0.48819,0.20472),(0.49606,0.20472),(0.50394,0.20472),(0.51181,0.20472),(0.51969,0.20472),(0.52756,0.20472),(0.53543,0.20472),(0.54331,0.20472),(0.55118,0.20472),(0.55906,0.20472),(0.56693,0.20472),(0.5748,0.20472),(0.58268,0.20472),(0.59055,0.20472),(0.59843,0.20472),(0.6063,0.20472),(0.61417,0.20472),(0.62205,0.20472),(0.62992,0.20472),(0.6378,0.20472),(0.64567,0.20472),(0.65354,0.20472),(0.66142,0.20472),(0.66929,0.20472),(0.67717,0.20472),(0.68504,0.20472),(0.69291,0.20472),(0.70079,0.20472),(0.70866,0.20472),(0.71654,0.20472),(0.72441,0.20472),(0.73228,0.20472),(0.74016,0.20472),(0.74803,0.20472),(0.75591,0.20472),(0.76378,0.20472),(0.77165,0.20472),(0.77953,0.20472),(0.7874,0.20472),(0.79528,0.20472),(0.80315,0.20472),(0.81102,0.20472),(0.8189,0.20472),(0.82677,0.20472),(0.83465,0.20472),(0.84252,0.20472),(0.85039,0.20472),(0.85827,0.20472),(0.86614,0.20472),(0.87402,0.20472),(0.88189,0.20472),(0.88976,0.20472),(0.89764,0.20472),(0.90551,0.20472),(0.91339,0.20472),(0.92126,0.20472),(0.92913,0.20472),(0.93701,0.20472),(0.94488,0.20472),(0.95276,0.20472),(0.96063,0.20472),(0.9685,0.20472),(0.97638,0.20472),(0.98425,0.20472),(0.99213,0.20472),(0.99609,0.20472),(0.00391,0.2126),(0.00787,0.2126),(0.01575,0.2126),(0.02362,0.2126),(0.0315,0.2126),(0.03937,0.2126),(0.04724,0.2126),(0.05512,0.2126),(0.06299,0.2126),(0.07087,0.2126),(0.07874,0.2126),(0.08661,0.2126),(0.09449,0.2126),(0.10236,0.2126),(0.11024,0.2126),(0.11811,0.2126),(0.12598,0.2126),(0.13386,0.2126),(0.14173,0.2126),(0.14961,0.2126),(0.15748,0.2126),(0.16535,0.2126),(0.17323,0.2126),(0.1811,0.2126),(0.18898,0.2126),(0.19685,0.2126),(0.20472,0.2126),(0.2126,0.2126),(0.22047,0.2126),(0.22835,0.2126),(0.23622,0.2126),(0.24409,0.2126),(0.25197,0.2126),(0.25984,0.2126),(0.26772,0.2126),(0.27559,0.2126),(0.28346,0.2126),(0.29134,0.2126),(0.29921,0.2126),(0.30709,0.2126),(0.31496,0.2126),(0.32283,0.2126),(0.33071,0.2126),(0.33858,0.2126),(0.34646,0.2126),(0.35433,0.2126),(0.3622,0.2126),(0.37008,0.2126),(0.37795,0.2126),(0.38583,0.2126),(0.3937,0.2126),(0.40157,0.2126),(0.40945,0.2126),(0.41732,0.2126),(0.4252,0.2126),(0.43307,0.2126),(0.44094,0.2126),(0.44882,0.2126),(0.45669,0.2126),(0.46457,0.2126),(0.47244,0.2126),(0.48031,0.2126),(0.48819,0.2126),(0.49606,0.2126),(0.50394,0.2126),(0.51181,0.2126),(0.51969,0.2126),(0.52756,0.2126),(0.53543,0.2126),(0.54331,0.2126),(0.55118,0.2126),(0.55906,0.2126),(0.56693,0.2126),(0.5748,0.2126),(0.58268,0.2126),(0.59055,0.2126),(0.59843,0.2126),(0.6063,0.2126),(0.61417,0.2126),(0.62205,0.2126),(0.62992,0.2126),(0.6378,0.2126),(0.64567,0.2126),(0.65354,0.2126),(0.66142,0.2126),(0.66929,0.2126),(0.67717,0.2126),(0.68504,0.2126),(0.69291,0.2126),(0.70079,0.2126),(0.70866,0.2126),(0.71654,0.2126),(0.72441,0.2126),(0.73228,0.2126),(0.74016,0.2126),(0.74803,0.2126),(0.75591,0.2126),(0.76378,0.2126),(0.77165,0.2126),(0.77953,0.2126),(0.7874,0.2126),(0.79528,0.2126),(0.80315,0.2126),(0.81102,0.2126),(0.8189,0.2126),(0.82677,0.2126),(0.83465,0.2126),(0.84252,0.2126),(0.85039,0.2126),(0.85827,0.2126),(0.86614,0.2126),(0.87402,0.2126),(0.88189,0.2126),(0.88976,0.2126),(0.89764,0.2126),(0.90551,0.2126),(0.91339,0.2126),(0.92126,0.2126),(0.92913,0.2126),(0.93701,0.2126),(0.94488,0.2126),(0.95276,0.2126),(0.96063,0.2126),(0.9685,0.2126),(0.97638,0.2126),(0.98425,0.2126),(0.99213,0.2126),(0.99609,0.2126),(0.00391,0.22047),(0.00787,0.22047),(0.01575,0.22047),(0.02362,0.22047),(0.0315,0.22047),(0.03937,0.22047),(0.04724,0.22047),(0.05512,0.22047),(0.06299,0.22047),(0.07087,0.22047),(0.07874,0.22047),(0.08661,0.22047),(0.09449,0.22047),(0.10236,0.22047),(0.11024,0.22047),(0.11811,0.22047),(0.12598,0.22047),(0.13386,0.22047),(0.14173,0.22047),(0.14961,0.22047),(0.15748,0.22047),(0.16535,0.22047),(0.17323,0.22047),(0.1811,0.22047),(0.18898,0.22047),(0.19685,0.22047),(0.20472,0.22047),(0.2126,0.22047),(0.22047,0.22047),(0.22835,0.22047),(0.23622,0.22047),(0.24409,0.22047),(0.25197,0.22047),(0.25984,0.22047),(0.26772,0.22047),(0.27559,0.22047),(0.28346,0.22047),(0.29134,0.22047),(0.29921,0.22047),(0.30709,0.22047),(0.31496,0.22047),(0.32283,0.22047),(0.33071,0.22047),(0.33858,0.22047),(0.34646,0.22047),(0.35433,0.22047),(0.3622,0.22047),(0.37008,0.22047),(0.37795,0.22047),(0.38583,0.22047),(0.3937,0.22047),(0.40157,0.22047),(0.40945,0.22047),(0.41732,0.22047),(0.4252,0.22047),(0.43307,0.22047),(0.44094,0.22047),(0.44882,0.22047),(0.45669,0.22047),(0.46457,0.22047),(0.47244,0.22047),(0.48031,0.22047),(0.48819,0.22047),(0.49606,0.22047),(0.50394,0.22047),(0.51181,0.22047),(0.51969,0.22047),(0.52756,0.22047),(0.53543,0.22047),(0.54331,0.22047),(0.55118,0.22047),(0.55906,0.22047),(0.56693,0.22047),(0.5748,0.22047),(0.58268,0.22047),(0.59055,0.22047),(0.59843,0.22047),(0.6063,0.22047),(0.61417,0.22047),(0.62205,0.22047),(0.62992,0.22047),(0.6378,0.22047),(0.64567,0.22047),(0.65354,0.22047),(0.66142,0.22047),(0.66929,0.22047),(0.67717,0.22047),(0.68504,0.22047),(0.69291,0.22047),(0.70079,0.22047),(0.70866,0.22047),(0.71654,0.22047),(0.72441,0.22047),(0.73228,0.22047),(0.74016,0.22047),(0.74803,0.22047),(0.75591,0.22047),(0.76378,0.22047),(0.77165,0.22047),(0.77953,0.22047),(0.7874,0.22047),(0.79528,0.22047),(0.80315,0.22047),(0.81102,0.22047),(0.8189,0.22047),(0.82677,0.22047),(0.83465,0.22047),(0.84252,0.22047),(0.85039,0.22047),(0.85827,0.22047),(0.86614,0.22047),(0.87402,0.22047),(0.88189,0.22047),(0.88976,0.22047),(0.89764,0.22047),(0.90551,0.22047),(0.91339,0.22047),(0.92126,0.22047),(0.92913,0.22047),(0.93701,0.22047),(0.94488,0.22047),(0.95276,0.22047),(0.96063,0.22047),(0.9685,0.22047),(0.97638,0.22047),(0.98425,0.22047),(0.99213,0.22047),(0.99609,0.22047),(0.00391,0.22835),(0.00787,0.22835),(0.01575,0.22835),(0.02362,0.22835),(0.0315,0.22835),(0.03937,0.22835),(0.04724,0.22835),(0.05512,0.22835),(0.06299,0.22835),(0.07087,0.22835),(0.07874,0.22835),(0.08661,0.22835),(0.09449,0.22835),(0.10236,0.22835),(0.11024,0.22835),(0.11811,0.22835),(0.12598,0.22835),(0.13386,0.22835),(0.14173,0.22835),(0.14961,0.22835),(0.15748,0.22835),(0.16535,0.22835),(0.17323,0.22835),(0.1811,0.22835),(0.18898,0.22835),(0.19685,0.22835),(0.20472,0.22835),(0.2126,0.22835),(0.22047,0.22835),(0.22835,0.22835),(0.23622,0.22835),(0.24409,0.22835),(0.25197,0.22835),(0.25984,0.22835),(0.26772,0.22835),(0.27559,0.22835),(0.28346,0.22835),(0.29134,0.22835),(0.29921,0.22835),(0.30709,0.22835),(0.31496,0.22835),(0.32283,0.22835),(0.33071,0.22835),(0.33858,0.22835),(0.34646,0.22835),(0.35433,0.22835),(0.3622,0.22835),(0.37008,0.22835),(0.37795,0.22835),(0.38583,0.22835),(0.3937,0.22835),(0.40157,0.22835),(0.40945,0.22835),(0.41732,0.22835),(0.4252,0.22835),(0.43307,0.22835),(0.44094,0.22835),(0.44882,0.22835),(0.45669,0.22835),(0.46457,0.22835),(0.47244,0.22835),(0.48031,0.22835),(0.48819,0.22835),(0.49606,0.22835),(0.50394,0.22835),(0.51181,0.22835),(0.51969,0.22835),(0.52756,0.22835),(0.53543,0.22835),(0.54331,0.22835),(0.55118,0.22835),(0.55906,0.22835),(0.56693,0.22835),(0.5748,0.22835),(0.58268,0.22835),(0.59055,0.22835),(0.59843,0.22835),(0.6063,0.22835),(0.61417,0.22835),(0.62205,0.22835),(0.62992,0.22835),(0.6378,0.22835),(0.64567,0.22835),(0.65354,0.22835),(0.66142,0.22835),(0.66929,0.22835),(0.67717,0.22835),(0.68504,0.22835),(0.69291,0.22835),(0.70079,0.22835),(0.70866,0.22835),(0.71654,0.22835),(0.72441,0.22835),(0.73228,0.22835),(0.74016,0.22835),(0.74803,0.22835),(0.75591,0.22835),(0.76378,0.22835),(0.77165,0.22835),(0.77953,0.22835),(0.7874,0.22835),(0.79528,0.22835),(0.80315,0.22835),(0.81102,0.22835),(0.8189,0.22835),(0.82677,0.22835),(0.83465,0.22835),(0.84252,0.22835),(0.85039,0.22835),(0.85827,0.22835),(0.86614,0.22835),(0.87402,0.22835),(0.88189,0.22835),(0.88976,0.22835),(0.89764,0.22835),(0.90551,0.22835),(0.91339,0.22835),(0.92126,0.22835),(0.92913,0.22835),(0.93701,0.22835),(0.94488,0.22835),(0.95276,0.22835),(0.96063,0.22835),(0.9685,0.22835),(0.97638,0.22835),(0.98425,0.22835),(0.99213,0.22835),(0.99609,0.22835),(0.00391,0.23622),(0.00787,0.23622),(0.01575,0.23622),(0.02362,0.23622),(0.0315,0.23622),(0.03937,0.23622),(0.04724,0.23622),(0.05512,0.23622),(0.06299,0.23622),(0.07087,0.23622),(0.07874,0.23622),(0.08661,0.23622),(0.09449,0.23622),(0.10236,0.23622),(0.11024,0.23622),(0.11811,0.23622),(0.12598,0.23622),(0.13386,0.23622),(0.14173,0.23622),(0.14961,0.23622),(0.15748,0.23622),(0.16535,0.23622),(0.17323,0.23622),(0.1811,0.23622),(0.18898,0.23622),(0.19685,0.23622),(0.20472,0.23622),(0.2126,0.23622),(0.22047,0.23622),(0.22835,0.23622),(0.23622,0.23622),(0.24409,0.23622),(0.25197,0.23622),(0.25984,0.23622),(0.26772,0.23622),(0.27559,0.23622),(0.28346,0.23622),(0.29134,0.23622),(0.29921,0.23622),(0.30709,0.23622),(0.31496,0.23622),(0.32283,0.23622),(0.33071,0.23622),(0.33858,0.23622),(0.34646,0.23622),(0.35433,0.23622),(0.3622,0.23622),(0.37008,0.23622),(0.37795,0.23622),(0.38583,0.23622),(0.3937,0.23622),(0.40157,0.23622),(0.40945,0.23622),(0.41732,0.23622),(0.4252,0.23622),(0.43307,0.23622),(0.44094,0.23622),(0.44882,0.23622),(0.45669,0.23622),(0.46457,0.23622),(0.47244,0.23622),(0.48031,0.23622),(0.48819,0.23622),(0.49606,0.23622),(0.50394,0.23622),(0.51181,0.23622),(0.51969,0.23622),(0.52756,0.23622),(0.53543,0.23622),(0.54331,0.23622),(0.55118,0.23622),(0.55906,0.23622),(0.56693,0.23622),(0.5748,0.23622),(0.58268,0.23622),(0.59055,0.23622),(0.59843,0.23622),(0.6063,0.23622),(0.61417,0.23622),(0.62205,0.23622),(0.62992,0.23622),(0.6378,0.23622),(0.64567,0.23622),(0.65354,0.23622),(0.66142,0.23622),(0.66929,0.23622),(0.67717,0.23622),(0.68504,0.23622),(0.69291,0.23622),(0.70079,0.23622),(0.70866,0.23622),(0.71654,0.23622),(0.72441,0.23622),(0.73228,0.23622),(0.74016,0.23622),(0.74803,0.23622),(0.75591,0.23622),(0.76378,0.23622),(0.77165,0.23622),(0.77953,0.23622),(0.7874,0.23622),(0.79528,0.23622),(0.80315,0.23622),(0.81102,0.23622),(0.8189,0.23622),(0.82677,0.23622),(0.83465,0.23622),(0.84252,0.23622),(0.85039,0.23622),(0.85827,0.23622),(0.86614,0.23622),(0.87402,0.23622),(0.88189,0.23622),(0.88976,0.23622),(0.89764,0.23622),(0.90551,0.23622),(0.91339,0.23622),(0.92126,0.23622),(0.92913,0.23622),(0.93701,0.23622),(0.94488,0.23622),(0.95276,0.23622),(0.96063,0.23622),(0.9685,0.23622),(0.97638,0.23622),(0.98425,0.23622),(0.99213,0.23622),(0.99609,0.23622),(0.00391,0.24409),(0.00787,0.24409),(0.01575,0.24409),(0.02362,0.24409),(0.0315,0.24409),(0.03937,0.24409),(0.04724,0.24409),(0.05512,0.24409),(0.06299,0.24409),(0.07087,0.24409),(0.07874,0.24409),(0.08661,0.24409),(0.09449,0.24409),(0.10236,0.24409),(0.11024,0.24409),(0.11811,0.24409),(0.12598,0.24409),(0.13386,0.24409),(0.14173,0.24409),(0.14961,0.24409),(0.15748,0.24409),(0.16535,0.24409),(0.17323,0.24409),(0.1811,0.24409),(0.18898,0.24409),(0.19685,0.24409),(0.20472,0.24409),(0.2126,0.24409),(0.22047,0.24409),(0.22835,0.24409),(0.23622,0.24409),(0.24409,0.24409),(0.25197,0.24409),(0.25984,0.24409),(0.26772,0.24409),(0.27559,0.24409),(0.28346,0.24409),(0.29134,0.24409),(0.29921,0.24409),(0.30709,0.24409),(0.31496,0.24409),(0.32283,0.24409),(0.33071,0.24409),(0.33858,0.24409),(0.34646,0.24409),(0.35433,0.24409),(0.3622,0.24409),(0.37008,0.24409),(0.37795,0.24409),(0.38583,0.24409),(0.3937,0.24409),(0.40157,0.24409),(0.40945,0.24409),(0.41732,0.24409),(0.4252,0.24409),(0.43307,0.24409),(0.44094,0.24409),(0.44882,0.24409),(0.45669,0.24409),(0.46457,0.24409),(0.47244,0.24409),(0.48031,0.24409),(0.48819,0.24409),(0.49606,0.24409),(0.50394,0.24409),(0.51181,0.24409),(0.51969,0.24409),(0.52756,0.24409),(0.53543,0.24409),(0.54331,0.24409),(0.55118,0.24409),(0.55906,0.24409),(0.56693,0.24409),(0.5748,0.24409),(0.58268,0.24409),(0.59055,0.24409),(0.59843,0.24409),(0.6063,0.24409),(0.61417,0.24409),(0.62205,0.24409),(0.62992,0.24409),(0.6378,0.24409),(0.64567,0.24409),(0.65354,0.24409),(0.66142,0.24409),(0.66929,0.24409),(0.67717,0.24409),(0.68504,0.24409),(0.69291,0.24409),(0.70079,0.24409),(0.70866,0.24409),(0.71654,0.24409),(0.72441,0.24409),(0.73228,0.24409),(0.74016,0.24409),(0.74803,0.24409),(0.75591,0.24409),(0.76378,0.24409),(0.77165,0.24409),(0.77953,0.24409),(0.7874,0.24409),(0.79528,0.24409),(0.80315,0.24409),(0.81102,0.24409),(0.8189,0.24409),(0.82677,0.24409),(0.83465,0.24409),(0.84252,0.24409),(0.85039,0.24409),(0.85827,0.24409),(0.86614,0.24409),(0.87402,0.24409),(0.88189,0.24409),(0.88976,0.24409),(0.89764,0.24409),(0.90551,0.24409),(0.91339,0.24409),(0.92126,0.24409),(0.92913,0.24409),(0.93701,0.24409),(0.94488,0.24409),(0.95276,0.24409),(0.96063,0.24409),(0.9685,0.24409),(0.97638,0.24409),(0.98425,0.24409),(0.99213,0.24409),(0.99609,0.24409),(0.00391,0.25197),(0.00787,0.25197),(0.01575,0.25197),(0.02362,0.25197),(0.0315,0.25197),(0.03937,0.25197),(0.04724,0.25197),(0.05512,0.25197),(0.06299,0.25197),(0.07087,0.25197),(0.07874,0.25197),(0.08661,0.25197),(0.09449,0.25197),(0.10236,0.25197),(0.11024,0.25197),(0.11811,0.25197),(0.12598,0.25197),(0.13386,0.25197),(0.14173,0.25197),(0.14961,0.25197),(0.15748,0.25197),(0.16535,0.25197),(0.17323,0.25197),(0.1811,0.25197),(0.18898,0.25197),(0.19685,0.25197),(0.20472,0.25197),(0.2126,0.25197),(0.22047,0.25197),(0.22835,0.25197),(0.23622,0.25197),(0.24409,0.25197),(0.25197,0.25197),(0.25984,0.25197),(0.26772,0.25197),(0.27559,0.25197),(0.28346,0.25197),(0.29134,0.25197),(0.29921,0.25197),(0.30709,0.25197),(0.31496,0.25197),(0.32283,0.25197),(0.33071,0.25197),(0.33858,0.25197),(0.34646,0.25197),(0.35433,0.25197),(0.3622,0.25197),(0.37008,0.25197),(0.37795,0.25197),(0.38583,0.25197),(0.3937,0.25197),(0.40157,0.25197),(0.40945,0.25197),(0.41732,0.25197),(0.4252,0.25197),(0.43307,0.25197),(0.44094,0.25197),(0.44882,0.25197),(0.45669,0.25197),(0.46457,0.25197),(0.47244,0.25197),(0.48031,0.25197),(0.48819,0.25197),(0.49606,0.25197),(0.50394,0.25197),(0.51181,0.25197),(0.51969,0.25197),(0.52756,0.25197),(0.53543,0.25197),(0.54331,0.25197),(0.55118,0.25197),(0.55906,0.25197),(0.56693,0.25197),(0.5748,0.25197),(0.58268,0.25197),(0.59055,0.25197),(0.59843,0.25197),(0.6063,0.25197),(0.61417,0.25197),(0.62205,0.25197),(0.62992,0.25197),(0.6378,0.25197),(0.64567,0.25197),(0.65354,0.25197),(0.66142,0.25197),(0.66929,0.25197),(0.67717,0.25197),(0.68504,0.25197),(0.69291,0.25197),(0.70079,0.25197),(0.70866,0.25197),(0.71654,0.25197),(0.72441,0.25197),(0.73228,0.25197),(0.74016,0.25197),(0.74803,0.25197),(0.75591,0.25197),(0.76378,0.25197),(0.77165,0.25197),(0.77953,0.25197),(0.7874,0.25197),(0.79528,0.25197),(0.80315,0.25197),(0.81102,0.25197),(0.8189,0.25197),(0.82677,0.25197),(0.83465,0.25197),(0.84252,0.25197),(0.85039,0.25197),(0.85827,0.25197),(0.86614,0.25197),(0.87402,0.25197),(0.88189,0.25197),(0.88976,0.25197),(0.89764,0.25197),(0.90551,0.25197),(0.91339,0.25197),(0.92126,0.25197),(0.92913,0.25197),(0.93701,0.25197),(0.94488,0.25197),(0.95276,0.25197),(0.96063,0.25197),(0.9685,0.25197),(0.97638,0.25197),(0.98425,0.25197),(0.99213,0.25197),(0.99609,0.25197),(0.00391,0.25984),(0.00787,0.25984),(0.01575,0.25984),(0.02362,0.25984),(0.0315,0.25984),(0.03937,0.25984),(0.04724,0.25984),(0.05512,0.25984),(0.06299,0.25984),(0.07087,0.25984),(0.07874,0.25984),(0.08661,0.25984),(0.09449,0.25984),(0.10236,0.25984),(0.11024,0.25984),(0.11811,0.25984),(0.12598,0.25984),(0.13386,0.25984),(0.14173,0.25984),(0.14961,0.25984),(0.15748,0.25984),(0.16535,0.25984),(0.17323,0.25984),(0.1811,0.25984),(0.18898,0.25984),(0.19685,0.25984),(0.20472,0.25984),(0.2126,0.25984),(0.22047,0.25984),(0.22835,0.25984),(0.23622,0.25984),(0.24409,0.25984),(0.25197,0.25984),(0.25984,0.25984),(0.26772,0.25984),(0.27559,0.25984),(0.28346,0.25984),(0.29134,0.25984),(0.29921,0.25984),(0.30709,0.25984),(0.31496,0.25984),(0.32283,0.25984),(0.33071,0.25984),(0.33858,0.25984),(0.34646,0.25984),(0.35433,0.25984),(0.3622,0.25984),(0.37008,0.25984),(0.37795,0.25984),(0.38583,0.25984),(0.3937,0.25984),(0.40157,0.25984),(0.40945,0.25984),(0.41732,0.25984),(0.4252,0.25984),(0.43307,0.25984),(0.44094,0.25984),(0.44882,0.25984),(0.45669,0.25984),(0.46457,0.25984),(0.47244,0.25984),(0.48031,0.25984),(0.48819,0.25984),(0.49606,0.25984),(0.50394,0.25984),(0.51181,0.25984),(0.51969,0.25984),(0.52756,0.25984),(0.53543,0.25984),(0.54331,0.25984),(0.55118,0.25984),(0.55906,0.25984),(0.56693,0.25984),(0.5748,0.25984),(0.58268,0.25984),(0.59055,0.25984),(0.59843,0.25984),(0.6063,0.25984),(0.61417,0.25984),(0.62205,0.25984),(0.62992,0.25984),(0.6378,0.25984),(0.64567,0.25984),(0.65354,0.25984),(0.66142,0.25984),(0.66929,0.25984),(0.67717,0.25984),(0.68504,0.25984),(0.69291,0.25984),(0.70079,0.25984),(0.70866,0.25984),(0.71654,0.25984),(0.72441,0.25984),(0.73228,0.25984),(0.74016,0.25984),(0.74803,0.25984),(0.75591,0.25984),(0.76378,0.25984),(0.77165,0.25984),(0.77953,0.25984),(0.7874,0.25984),(0.79528,0.25984),(0.80315,0.25984),(0.81102,0.25984),(0.8189,0.25984),(0.82677,0.25984),(0.83465,0.25984),(0.84252,0.25984),(0.85039,0.25984),(0.85827,0.25984),(0.86614,0.25984),(0.87402,0.25984),(0.88189,0.25984),(0.88976,0.25984),(0.89764,0.25984),(0.90551,0.25984),(0.91339,0.25984),(0.92126,0.25984),(0.92913,0.25984),(0.93701,0.25984),(0.94488,0.25984),(0.95276,0.25984),(0.96063,0.25984),(0.9685,0.25984),(0.97638,0.25984),(0.98425,0.25984),(0.99213,0.25984),(0.99609,0.25984),(0.00391,0.26772),(0.00787,0.26772),(0.01575,0.26772),(0.02362,0.26772),(0.0315,0.26772),(0.03937,0.26772),(0.04724,0.26772),(0.05512,0.26772),(0.06299,0.26772),(0.07087,0.26772),(0.07874,0.26772),(0.08661,0.26772),(0.09449,0.26772),(0.10236,0.26772),(0.11024,0.26772),(0.11811,0.26772),(0.12598,0.26772),(0.13386,0.26772),(0.14173,0.26772),(0.14961,0.26772),(0.15748,0.26772),(0.16535,0.26772),(0.17323,0.26772),(0.1811,0.26772),(0.18898,0.26772),(0.19685,0.26772),(0.20472,0.26772),(0.2126,0.26772),(0.22047,0.26772),(0.22835,0.26772),(0.23622,0.26772),(0.24409,0.26772),(0.25197,0.26772),(0.25984,0.26772),(0.26772,0.26772),(0.27559,0.26772),(0.28346,0.26772),(0.29134,0.26772),(0.29921,0.26772),(0.30709,0.26772),(0.31496,0.26772),(0.32283,0.26772),(0.33071,0.26772),(0.33858,0.26772),(0.34646,0.26772),(0.35433,0.26772),(0.3622,0.26772),(0.37008,0.26772),(0.37795,0.26772),(0.38583,0.26772),(0.3937,0.26772),(0.40157,0.26772),(0.40945,0.26772),(0.41732,0.26772),(0.4252,0.26772),(0.43307,0.26772),(0.44094,0.26772),(0.44882,0.26772),(0.45669,0.26772),(0.46457,0.26772),(0.47244,0.26772),(0.48031,0.26772),(0.48819,0.26772),(0.49606,0.26772),(0.50394,0.26772),(0.51181,0.26772),(0.51969,0.26772),(0.52756,0.26772),(0.53543,0.26772),(0.54331,0.26772),(0.55118,0.26772),(0.55906,0.26772),(0.56693,0.26772),(0.5748,0.26772),(0.58268,0.26772),(0.59055,0.26772),(0.59843,0.26772),(0.6063,0.26772),(0.61417,0.26772),(0.62205,0.26772),(0.62992,0.26772),(0.6378,0.26772),(0.64567,0.26772),(0.65354,0.26772),(0.66142,0.26772),(0.66929,0.26772),(0.67717,0.26772),(0.68504,0.26772),(0.69291,0.26772),(0.70079,0.26772),(0.70866,0.26772),(0.71654,0.26772),(0.72441,0.26772),(0.73228,0.26772),(0.74016,0.26772),(0.74803,0.26772),(0.75591,0.26772),(0.76378,0.26772),(0.77165,0.26772),(0.77953,0.26772),(0.7874,0.26772),(0.79528,0.26772),(0.80315,0.26772),(0.81102,0.26772),(0.8189,0.26772),(0.82677,0.26772),(0.83465,0.26772),(0.84252,0.26772),(0.85039,0.26772),(0.85827,0.26772),(0.86614,0.26772),(0.87402,0.26772),(0.88189,0.26772),(0.88976,0.26772),(0.89764,0.26772),(0.90551,0.26772),(0.91339,0.26772),(0.92126,0.26772),(0.92913,0.26772),(0.93701,0.26772),(0.94488,0.26772),(0.95276,0.26772),(0.96063,0.26772),(0.9685,0.26772),(0.97638,0.26772),(0.98425,0.26772),(0.99213,0.26772),(0.99609,0.26772),(0.00391,0.27559),(0.00787,0.27559),(0.01575,0.27559),(0.02362,0.27559),(0.0315,0.27559),(0.03937,0.27559),(0.04724,0.27559),(0.05512,0.27559),(0.06299,0.27559),(0.07087,0.27559),(0.07874,0.27559),(0.08661,0.27559),(0.09449,0.27559),(0.10236,0.27559),(0.11024,0.27559),(0.11811,0.27559),(0.12598,0.27559),(0.13386,0.27559),(0.14173,0.27559),(0.14961,0.27559),(0.15748,0.27559),(0.16535,0.27559),(0.17323,0.27559),(0.1811,0.27559),(0.18898,0.27559),(0.19685,0.27559),(0.20472,0.27559),(0.2126,0.27559),(0.22047,0.27559),(0.22835,0.27559),(0.23622,0.27559),(0.24409,0.27559),(0.25197,0.27559),(0.25984,0.27559),(0.26772,0.27559),(0.27559,0.27559),(0.28346,0.27559),(0.29134,0.27559),(0.29921,0.27559),(0.30709,0.27559),(0.31496,0.27559),(0.32283,0.27559),(0.33071,0.27559),(0.33858,0.27559),(0.34646,0.27559),(0.35433,0.27559),(0.3622,0.27559),(0.37008,0.27559),(0.37795,0.27559),(0.38583,0.27559),(0.3937,0.27559),(0.40157,0.27559),(0.40945,0.27559),(0.41732,0.27559),(0.4252,0.27559),(0.43307,0.27559),(0.44094,0.27559),(0.44882,0.27559),(0.45669,0.27559),(0.46457,0.27559),(0.47244,0.27559),(0.48031,0.27559),(0.48819,0.27559),(0.49606,0.27559),(0.50394,0.27559),(0.51181,0.27559),(0.51969,0.27559),(0.52756,0.27559),(0.53543,0.27559),(0.54331,0.27559),(0.55118,0.27559),(0.55906,0.27559),(0.56693,0.27559),(0.5748,0.27559),(0.58268,0.27559),(0.59055,0.27559),(0.59843,0.27559),(0.6063,0.27559),(0.61417,0.27559),(0.62205,0.27559),(0.62992,0.27559),(0.6378,0.27559),(0.64567,0.27559),(0.65354,0.27559),(0.66142,0.27559),(0.66929,0.27559),(0.67717,0.27559),(0.68504,0.27559),(0.69291,0.27559),(0.70079,0.27559),(0.70866,0.27559),(0.71654,0.27559),(0.72441,0.27559),(0.73228,0.27559),(0.74016,0.27559),(0.74803,0.27559),(0.75591,0.27559),(0.76378,0.27559),(0.77165,0.27559),(0.77953,0.27559),(0.7874,0.27559),(0.79528,0.27559),(0.80315,0.27559),(0.81102,0.27559),(0.8189,0.27559),(0.82677,0.27559),(0.83465,0.27559),(0.84252,0.27559),(0.85039,0.27559),(0.85827,0.27559),(0.86614,0.27559),(0.87402,0.27559),(0.88189,0.27559),(0.88976,0.27559),(0.89764,0.27559),(0.90551,0.27559),(0.91339,0.27559),(0.92126,0.27559),(0.92913,0.27559),(0.93701,0.27559),(0.94488,0.27559),(0.95276,0.27559),(0.96063,0.27559),(0.9685,0.27559),(0.97638,0.27559),(0.98425,0.27559),(0.99213,0.27559),(0.99609,0.27559),(0.00391,0.28346),(0.00787,0.28346),(0.01575,0.28346),(0.02362,0.28346),(0.0315,0.28346),(0.03937,0.28346),(0.04724,0.28346),(0.05512,0.28346),(0.06299,0.28346),(0.07087,0.28346),(0.07874,0.28346),(0.08661,0.28346),(0.09449,0.28346),(0.10236,0.28346),(0.11024,0.28346),(0.11811,0.28346),(0.12598,0.28346),(0.13386,0.28346),(0.14173,0.28346),(0.14961,0.28346),(0.15748,0.28346),(0.16535,0.28346),(0.17323,0.28346),(0.1811,0.28346),(0.18898,0.28346),(0.19685,0.28346),(0.20472,0.28346),(0.2126,0.28346),(0.22047,0.28346),(0.22835,0.28346),(0.23622,0.28346),(0.24409,0.28346),(0.25197,0.28346),(0.25984,0.28346),(0.26772,0.28346),(0.27559,0.28346),(0.28346,0.28346),(0.29134,0.28346),(0.29921,0.28346),(0.30709,0.28346),(0.31496,0.28346),(0.32283,0.28346),(0.33071,0.28346),(0.33858,0.28346),(0.34646,0.28346),(0.35433,0.28346),(0.3622,0.28346),(0.37008,0.28346),(0.37795,0.28346),(0.38583,0.28346),(0.3937,0.28346),(0.40157,0.28346),(0.40945,0.28346),(0.41732,0.28346),(0.4252,0.28346),(0.43307,0.28346),(0.44094,0.28346),(0.44882,0.28346),(0.45669,0.28346),(0.46457,0.28346),(0.47244,0.28346),(0.48031,0.28346),(0.48819,0.28346),(0.49606,0.28346),(0.50394,0.28346),(0.51181,0.28346),(0.51969,0.28346),(0.52756,0.28346),(0.53543,0.28346),(0.54331,0.28346),(0.55118,0.28346),(0.55906,0.28346),(0.56693,0.28346),(0.5748,0.28346),(0.58268,0.28346),(0.59055,0.28346),(0.59843,0.28346),(0.6063,0.28346),(0.61417,0.28346),(0.62205,0.28346),(0.62992,0.28346),(0.6378,0.28346),(0.64567,0.28346),(0.65354,0.28346),(0.66142,0.28346),(0.66929,0.28346),(0.67717,0.28346),(0.68504,0.28346),(0.69291,0.28346),(0.70079,0.28346),(0.70866,0.28346),(0.71654,0.28346),(0.72441,0.28346),(0.73228,0.28346),(0.74016,0.28346),(0.74803,0.28346),(0.75591,0.28346),(0.76378,0.28346),(0.77165,0.28346),(0.77953,0.28346),(0.7874,0.28346),(0.79528,0.28346),(0.80315,0.28346),(0.81102,0.28346),(0.8189,0.28346),(0.82677,0.28346),(0.83465,0.28346),(0.84252,0.28346),(0.85039,0.28346),(0.85827,0.28346),(0.86614,0.28346),(0.87402,0.28346),(0.88189,0.28346),(0.88976,0.28346),(0.89764,0.28346),(0.90551,0.28346),(0.91339,0.28346),(0.92126,0.28346),(0.92913,0.28346),(0.93701,0.28346),(0.94488,0.28346),(0.95276,0.28346),(0.96063,0.28346),(0.9685,0.28346),(0.97638,0.28346),(0.98425,0.28346),(0.99213,0.28346),(0.99609,0.28346),(0.00391,0.29134),(0.00787,0.29134),(0.01575,0.29134),(0.02362,0.29134),(0.0315,0.29134),(0.03937,0.29134),(0.04724,0.29134),(0.05512,0.29134),(0.06299,0.29134),(0.07087,0.29134),(0.07874,0.29134),(0.08661,0.29134),(0.09449,0.29134),(0.10236,0.29134),(0.11024,0.29134),(0.11811,0.29134),(0.12598,0.29134),(0.13386,0.29134),(0.14173,0.29134),(0.14961,0.29134),(0.15748,0.29134),(0.16535,0.29134),(0.17323,0.29134),(0.1811,0.29134),(0.18898,0.29134),(0.19685,0.29134),(0.20472,0.29134),(0.2126,0.29134),(0.22047,0.29134),(0.22835,0.29134),(0.23622,0.29134),(0.24409,0.29134),(0.25197,0.29134),(0.25984,0.29134),(0.26772,0.29134),(0.27559,0.29134),(0.28346,0.29134),(0.29134,0.29134),(0.29921,0.29134),(0.30709,0.29134),(0.31496,0.29134),(0.32283,0.29134),(0.33071,0.29134),(0.33858,0.29134),(0.34646,0.29134),(0.35433,0.29134),(0.3622,0.29134),(0.37008,0.29134),(0.37795,0.29134),(0.38583,0.29134),(0.3937,0.29134),(0.40157,0.29134),(0.40945,0.29134),(0.41732,0.29134),(0.4252,0.29134),(0.43307,0.29134),(0.44094,0.29134),(0.44882,0.29134),(0.45669,0.29134),(0.46457,0.29134),(0.47244,0.29134),(0.48031,0.29134),(0.48819,0.29134),(0.49606,0.29134),(0.50394,0.29134),(0.51181,0.29134),(0.51969,0.29134),(0.52756,0.29134),(0.53543,0.29134),(0.54331,0.29134),(0.55118,0.29134),(0.55906,0.29134),(0.56693,0.29134),(0.5748,0.29134),(0.58268,0.29134),(0.59055,0.29134),(0.59843,0.29134),(0.6063,0.29134),(0.61417,0.29134),(0.62205,0.29134),(0.62992,0.29134),(0.6378,0.29134),(0.64567,0.29134),(0.65354,0.29134),(0.66142,0.29134),(0.66929,0.29134),(0.67717,0.29134),(0.68504,0.29134),(0.69291,0.29134),(0.70079,0.29134),(0.70866,0.29134),(0.71654,0.29134),(0.72441,0.29134),(0.73228,0.29134),(0.74016,0.29134),(0.74803,0.29134),(0.75591,0.29134),(0.76378,0.29134),(0.77165,0.29134),(0.77953,0.29134),(0.7874,0.29134),(0.79528,0.29134),(0.80315,0.29134),(0.81102,0.29134),(0.8189,0.29134),(0.82677,0.29134),(0.83465,0.29134),(0.84252,0.29134),(0.85039,0.29134),(0.85827,0.29134),(0.86614,0.29134),(0.87402,0.29134),(0.88189,0.29134),(0.88976,0.29134),(0.89764,0.29134),(0.90551,0.29134),(0.91339,0.29134),(0.92126,0.29134),(0.92913,0.29134),(0.93701,0.29134),(0.94488,0.29134),(0.95276,0.29134),(0.96063,0.29134),(0.9685,0.29134),(0.97638,0.29134),(0.98425,0.29134),(0.99213,0.29134),(0.99609,0.29134),(0.00391,0.29921),(0.00787,0.29921),(0.01575,0.29921),(0.02362,0.29921),(0.0315,0.29921),(0.03937,0.29921),(0.04724,0.29921),(0.05512,0.29921),(0.06299,0.29921),(0.07087,0.29921),(0.07874,0.29921),(0.08661,0.29921),(0.09449,0.29921),(0.10236,0.29921),(0.11024,0.29921),(0.11811,0.29921),(0.12598,0.29921),(0.13386,0.29921),(0.14173,0.29921),(0.14961,0.29921),(0.15748,0.29921),(0.16535,0.29921),(0.17323,0.29921),(0.1811,0.29921),(0.18898,0.29921),(0.19685,0.29921),(0.20472,0.29921),(0.2126,0.29921),(0.22047,0.29921),(0.22835,0.29921),(0.23622,0.29921),(0.24409,0.29921),(0.25197,0.29921),(0.25984,0.29921),(0.26772,0.29921),(0.27559,0.29921),(0.28346,0.29921),(0.29134,0.29921),(0.29921,0.29921),(0.30709,0.29921),(0.31496,0.29921),(0.32283,0.29921),(0.33071,0.29921),(0.33858,0.29921),(0.34646,0.29921),(0.35433,0.29921),(0.3622,0.29921),(0.37008,0.29921),(0.37795,0.29921),(0.38583,0.29921),(0.3937,0.29921),(0.40157,0.29921),(0.40945,0.29921),(0.41732,0.29921),(0.4252,0.29921),(0.43307,0.29921),(0.44094,0.29921),(0.44882,0.29921),(0.45669,0.29921),(0.46457,0.29921),(0.47244,0.29921),(0.48031,0.29921),(0.48819,0.29921),(0.49606,0.29921),(0.50394,0.29921),(0.51181,0.29921),(0.51969,0.29921),(0.52756,0.29921),(0.53543,0.29921),(0.54331,0.29921),(0.55118,0.29921),(0.55906,0.29921),(0.56693,0.29921),(0.5748,0.29921),(0.58268,0.29921),(0.59055,0.29921),(0.59843,0.29921),(0.6063,0.29921),(0.61417,0.29921),(0.62205,0.29921),(0.62992,0.29921),(0.6378,0.29921),(0.64567,0.29921),(0.65354,0.29921),(0.66142,0.29921),(0.66929,0.29921),(0.67717,0.29921),(0.68504,0.29921),(0.69291,0.29921),(0.70079,0.29921),(0.70866,0.29921),(0.71654,0.29921),(0.72441,0.29921),(0.73228,0.29921),(0.74016,0.29921),(0.74803,0.29921),(0.75591,0.29921),(0.76378,0.29921),(0.77165,0.29921),(0.77953,0.29921),(0.7874,0.29921),(0.79528,0.29921),(0.80315,0.29921),(0.81102,0.29921),(0.8189,0.29921),(0.82677,0.29921),(0.83465,0.29921),(0.84252,0.29921),(0.85039,0.29921),(0.85827,0.29921),(0.86614,0.29921),(0.87402,0.29921),(0.88189,0.29921),(0.88976,0.29921),(0.89764,0.29921),(0.90551,0.29921),(0.91339,0.29921),(0.92126,0.29921),(0.92913,0.29921),(0.93701,0.29921),(0.94488,0.29921),(0.95276,0.29921),(0.96063,0.29921),(0.9685,0.29921),(0.97638,0.29921),(0.98425,0.29921),(0.99213,0.29921),(0.99609,0.29921),(0.00391,0.30709),(0.00787,0.30709),(0.01575,0.30709),(0.02362,0.30709),(0.0315,0.30709),(0.03937,0.30709),(0.04724,0.30709),(0.05512,0.30709),(0.06299,0.30709),(0.07087,0.30709),(0.07874,0.30709),(0.08661,0.30709),(0.09449,0.30709),(0.10236,0.30709),(0.11024,0.30709),(0.11811,0.30709),(0.12598,0.30709),(0.13386,0.30709),(0.14173,0.30709),(0.14961,0.30709),(0.15748,0.30709),(0.16535,0.30709),(0.17323,0.30709),(0.1811,0.30709),(0.18898,0.30709),(0.19685,0.30709),(0.20472,0.30709),(0.2126,0.30709),(0.22047,0.30709),(0.22835,0.30709),(0.23622,0.30709),(0.24409,0.30709),(0.25197,0.30709),(0.25984,0.30709),(0.26772,0.30709),(0.27559,0.30709),(0.28346,0.30709),(0.29134,0.30709),(0.29921,0.30709),(0.30709,0.30709),(0.31496,0.30709),(0.32283,0.30709),(0.33071,0.30709),(0.33858,0.30709),(0.34646,0.30709),(0.35433,0.30709),(0.3622,0.30709),(0.37008,0.30709),(0.37795,0.30709),(0.38583,0.30709),(0.3937,0.30709),(0.40157,0.30709),(0.40945,0.30709),(0.41732,0.30709),(0.4252,0.30709),(0.43307,0.30709),(0.44094,0.30709),(0.44882,0.30709),(0.45669,0.30709),(0.46457,0.30709),(0.47244,0.30709),(0.48031,0.30709),(0.48819,0.30709),(0.49606,0.30709),(0.50394,0.30709),(0.51181,0.30709),(0.51969,0.30709),(0.52756,0.30709),(0.53543,0.30709),(0.54331,0.30709),(0.55118,0.30709),(0.55906,0.30709),(0.56693,0.30709),(0.5748,0.30709),(0.58268,0.30709),(0.59055,0.30709),(0.59843,0.30709),(0.6063,0.30709),(0.61417,0.30709),(0.62205,0.30709),(0.62992,0.30709),(0.6378,0.30709),(0.64567,0.30709),(0.65354,0.30709),(0.66142,0.30709),(0.66929,0.30709),(0.67717,0.30709),(0.68504,0.30709),(0.69291,0.30709),(0.70079,0.30709),(0.70866,0.30709),(0.71654,0.30709),(0.72441,0.30709),(0.73228,0.30709),(0.74016,0.30709),(0.74803,0.30709),(0.75591,0.30709),(0.76378,0.30709),(0.77165,0.30709),(0.77953,0.30709),(0.7874,0.30709),(0.79528,0.30709),(0.80315,0.30709),(0.81102,0.30709),(0.8189,0.30709),(0.82677,0.30709),(0.83465,0.30709),(0.84252,0.30709),(0.85039,0.30709),(0.85827,0.30709),(0.86614,0.30709),(0.87402,0.30709),(0.88189,0.30709),(0.88976,0.30709),(0.89764,0.30709),(0.90551,0.30709),(0.91339,0.30709),(0.92126,0.30709),(0.92913,0.30709),(0.93701,0.30709),(0.94488,0.30709),(0.95276,0.30709),(0.96063,0.30709),(0.9685,0.30709),(0.97638,0.30709),(0.98425,0.30709),(0.99213,0.30709),(0.99609,0.30709),(0.00391,0.31496),(0.00787,0.31496),(0.01575,0.31496),(0.02362,0.31496),(0.0315,0.31496),(0.03937,0.31496),(0.04724,0.31496),(0.05512,0.31496),(0.06299,0.31496),(0.07087,0.31496),(0.07874,0.31496),(0.08661,0.31496),(0.09449,0.31496),(0.10236,0.31496),(0.11024,0.31496),(0.11811,0.31496),(0.12598,0.31496),(0.13386,0.31496),(0.14173,0.31496),(0.14961,0.31496),(0.15748,0.31496),(0.16535,0.31496),(0.17323,0.31496),(0.1811,0.31496),(0.18898,0.31496),(0.19685,0.31496),(0.20472,0.31496),(0.2126,0.31496),(0.22047,0.31496),(0.22835,0.31496),(0.23622,0.31496),(0.24409,0.31496),(0.25197,0.31496),(0.25984,0.31496),(0.26772,0.31496),(0.27559,0.31496),(0.28346,0.31496),(0.29134,0.31496),(0.29921,0.31496),(0.30709,0.31496),(0.31496,0.31496),(0.32283,0.31496),(0.33071,0.31496),(0.33858,0.31496),(0.34646,0.31496),(0.35433,0.31496),(0.3622,0.31496),(0.37008,0.31496),(0.37795,0.31496),(0.38583,0.31496),(0.3937,0.31496),(0.40157,0.31496),(0.40945,0.31496),(0.41732,0.31496),(0.4252,0.31496),(0.43307,0.31496),(0.44094,0.31496),(0.44882,0.31496),(0.45669,0.31496),(0.46457,0.31496),(0.47244,0.31496),(0.48031,0.31496),(0.48819,0.31496),(0.49606,0.31496),(0.50394,0.31496),(0.51181,0.31496),(0.51969,0.31496),(0.52756,0.31496),(0.53543,0.31496),(0.54331,0.31496),(0.55118,0.31496),(0.55906,0.31496),(0.56693,0.31496),(0.5748,0.31496),(0.58268,0.31496),(0.59055,0.31496),(0.59843,0.31496),(0.6063,0.31496),(0.61417,0.31496),(0.62205,0.31496),(0.62992,0.31496),(0.6378,0.31496),(0.64567,0.31496),(0.65354,0.31496),(0.66142,0.31496),(0.66929,0.31496),(0.67717,0.31496),(0.68504,0.31496),(0.69291,0.31496),(0.70079,0.31496),(0.70866,0.31496),(0.71654,0.31496),(0.72441,0.31496),(0.73228,0.31496),(0.74016,0.31496),(0.74803,0.31496),(0.75591,0.31496),(0.76378,0.31496),(0.77165,0.31496),(0.77953,0.31496),(0.7874,0.31496),(0.79528,0.31496),(0.80315,0.31496),(0.81102,0.31496),(0.8189,0.31496),(0.82677,0.31496),(0.83465,0.31496),(0.84252,0.31496),(0.85039,0.31496),(0.85827,0.31496),(0.86614,0.31496),(0.87402,0.31496),(0.88189,0.31496),(0.88976,0.31496),(0.89764,0.31496),(0.90551,0.31496),(0.91339,0.31496),(0.92126,0.31496),(0.92913,0.31496),(0.93701,0.31496),(0.94488,0.31496),(0.95276,0.31496),(0.96063,0.31496),(0.9685,0.31496),(0.97638,0.31496),(0.98425,0.31496),(0.99213,0.31496),(0.99609,0.31496),(0.00391,0.32283),(0.00787,0.32283),(0.01575,0.32283),(0.02362,0.32283),(0.0315,0.32283),(0.03937,0.32283),(0.04724,0.32283),(0.05512,0.32283),(0.06299,0.32283),(0.07087,0.32283),(0.07874,0.32283),(0.08661,0.32283),(0.09449,0.32283),(0.10236,0.32283),(0.11024,0.32283),(0.11811,0.32283),(0.12598,0.32283),(0.13386,0.32283),(0.14173,0.32283),(0.14961,0.32283),(0.15748,0.32283),(0.16535,0.32283),(0.17323,0.32283),(0.1811,0.32283),(0.18898,0.32283),(0.19685,0.32283),(0.20472,0.32283),(0.2126,0.32283),(0.22047,0.32283),(0.22835,0.32283),(0.23622,0.32283),(0.24409,0.32283),(0.25197,0.32283),(0.25984,0.32283),(0.26772,0.32283),(0.27559,0.32283),(0.28346,0.32283),(0.29134,0.32283),(0.29921,0.32283),(0.30709,0.32283),(0.31496,0.32283),(0.32283,0.32283),(0.33071,0.32283),(0.33858,0.32283),(0.34646,0.32283),(0.35433,0.32283),(0.3622,0.32283),(0.37008,0.32283),(0.37795,0.32283),(0.38583,0.32283),(0.3937,0.32283),(0.40157,0.32283),(0.40945,0.32283),(0.41732,0.32283),(0.4252,0.32283),(0.43307,0.32283),(0.44094,0.32283),(0.44882,0.32283),(0.45669,0.32283),(0.46457,0.32283),(0.47244,0.32283),(0.48031,0.32283),(0.48819,0.32283),(0.49606,0.32283),(0.50394,0.32283),(0.51181,0.32283),(0.51969,0.32283),(0.52756,0.32283),(0.53543,0.32283),(0.54331,0.32283),(0.55118,0.32283),(0.55906,0.32283),(0.56693,0.32283),(0.5748,0.32283),(0.58268,0.32283),(0.59055,0.32283),(0.59843,0.32283),(0.6063,0.32283),(0.61417,0.32283),(0.62205,0.32283),(0.62992,0.32283),(0.6378,0.32283),(0.64567,0.32283),(0.65354,0.32283),(0.66142,0.32283),(0.66929,0.32283),(0.67717,0.32283),(0.68504,0.32283),(0.69291,0.32283),(0.70079,0.32283),(0.70866,0.32283),(0.71654,0.32283),(0.72441,0.32283),(0.73228,0.32283),(0.74016,0.32283),(0.74803,0.32283),(0.75591,0.32283),(0.76378,0.32283),(0.77165,0.32283),(0.77953,0.32283),(0.7874,0.32283),(0.79528,0.32283),(0.80315,0.32283),(0.81102,0.32283),(0.8189,0.32283),(0.82677,0.32283),(0.83465,0.32283),(0.84252,0.32283),(0.85039,0.32283),(0.85827,0.32283),(0.86614,0.32283),(0.87402,0.32283),(0.88189,0.32283),(0.88976,0.32283),(0.89764,0.32283),(0.90551,0.32283),(0.91339,0.32283),(0.92126,0.32283),(0.92913,0.32283),(0.93701,0.32283),(0.94488,0.32283),(0.95276,0.32283),(0.96063,0.32283),(0.9685,0.32283),(0.97638,0.32283),(0.98425,0.32283),(0.99213,0.32283),(0.99609,0.32283),(0.00391,0.33071),(0.00787,0.33071),(0.01575,0.33071),(0.02362,0.33071),(0.0315,0.33071),(0.03937,0.33071),(0.04724,0.33071),(0.05512,0.33071),(0.06299,0.33071),(0.07087,0.33071),(0.07874,0.33071),(0.08661,0.33071),(0.09449,0.33071),(0.10236,0.33071),(0.11024,0.33071),(0.11811,0.33071),(0.12598,0.33071),(0.13386,0.33071),(0.14173,0.33071),(0.14961,0.33071),(0.15748,0.33071),(0.16535,0.33071),(0.17323,0.33071),(0.1811,0.33071),(0.18898,0.33071),(0.19685,0.33071),(0.20472,0.33071),(0.2126,0.33071),(0.22047,0.33071),(0.22835,0.33071),(0.23622,0.33071),(0.24409,0.33071),(0.25197,0.33071),(0.25984,0.33071),(0.26772,0.33071),(0.27559,0.33071),(0.28346,0.33071),(0.29134,0.33071),(0.29921,0.33071),(0.30709,0.33071),(0.31496,0.33071),(0.32283,0.33071),(0.33071,0.33071),(0.33858,0.33071),(0.34646,0.33071),(0.35433,0.33071),(0.3622,0.33071),(0.37008,0.33071),(0.37795,0.33071),(0.38583,0.33071),(0.3937,0.33071),(0.40157,0.33071),(0.40945,0.33071),(0.41732,0.33071),(0.4252,0.33071),(0.43307,0.33071),(0.44094,0.33071),(0.44882,0.33071),(0.45669,0.33071),(0.46457,0.33071),(0.47244,0.33071),(0.48031,0.33071),(0.48819,0.33071),(0.49606,0.33071),(0.50394,0.33071),(0.51181,0.33071),(0.51969,0.33071),(0.52756,0.33071),(0.53543,0.33071),(0.54331,0.33071),(0.55118,0.33071),(0.55906,0.33071),(0.56693,0.33071),(0.5748,0.33071),(0.58268,0.33071),(0.59055,0.33071),(0.59843,0.33071),(0.6063,0.33071),(0.61417,0.33071),(0.62205,0.33071),(0.62992,0.33071),(0.6378,0.33071),(0.64567,0.33071),(0.65354,0.33071),(0.66142,0.33071),(0.66929,0.33071),(0.67717,0.33071),(0.68504,0.33071),(0.69291,0.33071),(0.70079,0.33071),(0.70866,0.33071),(0.71654,0.33071),(0.72441,0.33071),(0.73228,0.33071),(0.74016,0.33071),(0.74803,0.33071),(0.75591,0.33071),(0.76378,0.33071),(0.77165,0.33071),(0.77953,0.33071),(0.7874,0.33071),(0.79528,0.33071),(0.80315,0.33071),(0.81102,0.33071),(0.8189,0.33071),(0.82677,0.33071),(0.83465,0.33071),(0.84252,0.33071),(0.85039,0.33071),(0.85827,0.33071),(0.86614,0.33071),(0.87402,0.33071),(0.88189,0.33071),(0.88976,0.33071),(0.89764,0.33071),(0.90551,0.33071),(0.91339,0.33071),(0.92126,0.33071),(0.92913,0.33071),(0.93701,0.33071),(0.94488,0.33071),(0.95276,0.33071),(0.96063,0.33071),(0.9685,0.33071),(0.97638,0.33071),(0.98425,0.33071),(0.99213,0.33071),(0.99609,0.33071),(0.00391,0.33858),(0.00787,0.33858),(0.01575,0.33858),(0.02362,0.33858),(0.0315,0.33858),(0.03937,0.33858),(0.04724,0.33858),(0.05512,0.33858),(0.06299,0.33858),(0.07087,0.33858),(0.07874,0.33858),(0.08661,0.33858),(0.09449,0.33858),(0.10236,0.33858),(0.11024,0.33858),(0.11811,0.33858),(0.12598,0.33858),(0.13386,0.33858),(0.14173,0.33858),(0.14961,0.33858),(0.15748,0.33858),(0.16535,0.33858),(0.17323,0.33858),(0.1811,0.33858),(0.18898,0.33858),(0.19685,0.33858),(0.20472,0.33858),(0.2126,0.33858),(0.22047,0.33858),(0.22835,0.33858),(0.23622,0.33858),(0.24409,0.33858),(0.25197,0.33858),(0.25984,0.33858),(0.26772,0.33858),(0.27559,0.33858),(0.28346,0.33858),(0.29134,0.33858),(0.29921,0.33858),(0.30709,0.33858),(0.31496,0.33858),(0.32283,0.33858),(0.33071,0.33858),(0.33858,0.33858),(0.34646,0.33858),(0.35433,0.33858),(0.3622,0.33858),(0.37008,0.33858),(0.37795,0.33858),(0.38583,0.33858),(0.3937,0.33858),(0.40157,0.33858),(0.40945,0.33858),(0.41732,0.33858),(0.4252,0.33858),(0.43307,0.33858),(0.44094,0.33858),(0.44882,0.33858),(0.45669,0.33858),(0.46457,0.33858),(0.47244,0.33858),(0.48031,0.33858),(0.48819,0.33858),(0.49606,0.33858),(0.50394,0.33858),(0.51181,0.33858),(0.51969,0.33858),(0.52756,0.33858),(0.53543,0.33858),(0.54331,0.33858),(0.55118,0.33858),(0.55906,0.33858),(0.56693,0.33858),(0.5748,0.33858),(0.58268,0.33858),(0.59055,0.33858),(0.59843,0.33858),(0.6063,0.33858),(0.61417,0.33858),(0.62205,0.33858),(0.62992,0.33858),(0.6378,0.33858),(0.64567,0.33858),(0.65354,0.33858),(0.66142,0.33858),(0.66929,0.33858),(0.67717,0.33858),(0.68504,0.33858),(0.69291,0.33858),(0.70079,0.33858),(0.70866,0.33858),(0.71654,0.33858),(0.72441,0.33858),(0.73228,0.33858),(0.74016,0.33858),(0.74803,0.33858),(0.75591,0.33858),(0.76378,0.33858),(0.77165,0.33858),(0.77953,0.33858),(0.7874,0.33858),(0.79528,0.33858),(0.80315,0.33858),(0.81102,0.33858),(0.8189,0.33858),(0.82677,0.33858),(0.83465,0.33858),(0.84252,0.33858),(0.85039,0.33858),(0.85827,0.33858),(0.86614,0.33858),(0.87402,0.33858),(0.88189,0.33858),(0.88976,0.33858),(0.89764,0.33858),(0.90551,0.33858),(0.91339,0.33858),(0.92126,0.33858),(0.92913,0.33858),(0.93701,0.33858),(0.94488,0.33858),(0.95276,0.33858),(0.96063,0.33858),(0.9685,0.33858),(0.97638,0.33858),(0.98425,0.33858),(0.99213,0.33858),(0.99609,0.33858),(0.00391,0.34646),(0.00787,0.34646),(0.01575,0.34646),(0.02362,0.34646),(0.0315,0.34646),(0.03937,0.34646),(0.04724,0.34646),(0.05512,0.34646),(0.06299,0.34646),(0.07087,0.34646),(0.07874,0.34646),(0.08661,0.34646),(0.09449,0.34646),(0.10236,0.34646),(0.11024,0.34646),(0.11811,0.34646),(0.12598,0.34646),(0.13386,0.34646),(0.14173,0.34646),(0.14961,0.34646),(0.15748,0.34646),(0.16535,0.34646),(0.17323,0.34646),(0.1811,0.34646),(0.18898,0.34646),(0.19685,0.34646),(0.20472,0.34646),(0.2126,0.34646),(0.22047,0.34646),(0.22835,0.34646),(0.23622,0.34646),(0.24409,0.34646),(0.25197,0.34646),(0.25984,0.34646),(0.26772,0.34646),(0.27559,0.34646),(0.28346,0.34646),(0.29134,0.34646),(0.29921,0.34646),(0.30709,0.34646),(0.31496,0.34646),(0.32283,0.34646),(0.33071,0.34646),(0.33858,0.34646),(0.34646,0.34646),(0.35433,0.34646),(0.3622,0.34646),(0.37008,0.34646),(0.37795,0.34646),(0.38583,0.34646),(0.3937,0.34646),(0.40157,0.34646),(0.40945,0.34646),(0.41732,0.34646),(0.4252,0.34646),(0.43307,0.34646),(0.44094,0.34646),(0.44882,0.34646),(0.45669,0.34646),(0.46457,0.34646),(0.47244,0.34646),(0.48031,0.34646),(0.48819,0.34646),(0.49606,0.34646),(0.50394,0.34646),(0.51181,0.34646),(0.51969,0.34646),(0.52756,0.34646),(0.53543,0.34646),(0.54331,0.34646),(0.55118,0.34646),(0.55906,0.34646),(0.56693,0.34646),(0.5748,0.34646),(0.58268,0.34646),(0.59055,0.34646),(0.59843,0.34646),(0.6063,0.34646),(0.61417,0.34646),(0.62205,0.34646),(0.62992,0.34646),(0.6378,0.34646),(0.64567,0.34646),(0.65354,0.34646),(0.66142,0.34646),(0.66929,0.34646),(0.67717,0.34646),(0.68504,0.34646),(0.69291,0.34646),(0.70079,0.34646),(0.70866,0.34646),(0.71654,0.34646),(0.72441,0.34646),(0.73228,0.34646),(0.74016,0.34646),(0.74803,0.34646),(0.75591,0.34646),(0.76378,0.34646),(0.77165,0.34646),(0.77953,0.34646),(0.7874,0.34646),(0.79528,0.34646),(0.80315,0.34646),(0.81102,0.34646),(0.8189,0.34646),(0.82677,0.34646),(0.83465,0.34646),(0.84252,0.34646),(0.85039,0.34646),(0.85827,0.34646),(0.86614,0.34646),(0.87402,0.34646),(0.88189,0.34646),(0.88976,0.34646),(0.89764,0.34646),(0.90551,0.34646),(0.91339,0.34646),(0.92126,0.34646),(0.92913,0.34646),(0.93701,0.34646),(0.94488,0.34646),(0.95276,0.34646),(0.96063,0.34646),(0.9685,0.34646),(0.97638,0.34646),(0.98425,0.34646),(0.99213,0.34646),(0.99609,0.34646),(0.00391,0.35433),(0.00787,0.35433),(0.01575,0.35433),(0.02362,0.35433),(0.0315,0.35433),(0.03937,0.35433),(0.04724,0.35433),(0.05512,0.35433),(0.06299,0.35433),(0.07087,0.35433),(0.07874,0.35433),(0.08661,0.35433),(0.09449,0.35433),(0.10236,0.35433),(0.11024,0.35433),(0.11811,0.35433),(0.12598,0.35433),(0.13386,0.35433),(0.14173,0.35433),(0.14961,0.35433),(0.15748,0.35433),(0.16535,0.35433),(0.17323,0.35433),(0.1811,0.35433),(0.18898,0.35433),(0.19685,0.35433),(0.20472,0.35433),(0.2126,0.35433),(0.22047,0.35433),(0.22835,0.35433),(0.23622,0.35433),(0.24409,0.35433),(0.25197,0.35433),(0.25984,0.35433),(0.26772,0.35433),(0.27559,0.35433),(0.28346,0.35433),(0.29134,0.35433),(0.29921,0.35433),(0.30709,0.35433),(0.31496,0.35433),(0.32283,0.35433),(0.33071,0.35433),(0.33858,0.35433),(0.34646,0.35433),(0.35433,0.35433),(0.3622,0.35433),(0.37008,0.35433),(0.37795,0.35433),(0.38583,0.35433),(0.3937,0.35433),(0.40157,0.35433),(0.40945,0.35433),(0.41732,0.35433),(0.4252,0.35433),(0.43307,0.35433),(0.44094,0.35433),(0.44882,0.35433),(0.45669,0.35433),(0.46457,0.35433),(0.47244,0.35433),(0.48031,0.35433),(0.48819,0.35433),(0.49606,0.35433),(0.50394,0.35433),(0.51181,0.35433),(0.51969,0.35433),(0.52756,0.35433),(0.53543,0.35433),(0.54331,0.35433),(0.55118,0.35433),(0.55906,0.35433),(0.56693,0.35433),(0.5748,0.35433),(0.58268,0.35433),(0.59055,0.35433),(0.59843,0.35433),(0.6063,0.35433),(0.61417,0.35433),(0.62205,0.35433),(0.62992,0.35433),(0.6378,0.35433),(0.64567,0.35433),(0.65354,0.35433),(0.66142,0.35433),(0.66929,0.35433),(0.67717,0.35433),(0.68504,0.35433),(0.69291,0.35433),(0.70079,0.35433),(0.70866,0.35433),(0.71654,0.35433),(0.72441,0.35433),(0.73228,0.35433),(0.74016,0.35433),(0.74803,0.35433),(0.75591,0.35433),(0.76378,0.35433),(0.77165,0.35433),(0.77953,0.35433),(0.7874,0.35433),(0.79528,0.35433),(0.80315,0.35433),(0.81102,0.35433),(0.8189,0.35433),(0.82677,0.35433),(0.83465,0.35433),(0.84252,0.35433),(0.85039,0.35433),(0.85827,0.35433),(0.86614,0.35433),(0.87402,0.35433),(0.88189,0.35433),(0.88976,0.35433),(0.89764,0.35433),(0.90551,0.35433),(0.91339,0.35433),(0.92126,0.35433),(0.92913,0.35433),(0.93701,0.35433),(0.94488,0.35433),(0.95276,0.35433),(0.96063,0.35433),(0.9685,0.35433),(0.97638,0.35433),(0.98425,0.35433),(0.99213,0.35433),(0.99609,0.35433),(0.00391,0.3622),(0.00787,0.3622),(0.01575,0.3622),(0.02362,0.3622),(0.0315,0.3622),(0.03937,0.3622),(0.04724,0.3622),(0.05512,0.3622),(0.06299,0.3622),(0.07087,0.3622),(0.07874,0.3622),(0.08661,0.3622),(0.09449,0.3622),(0.10236,0.3622),(0.11024,0.3622),(0.11811,0.3622),(0.12598,0.3622),(0.13386,0.3622),(0.14173,0.3622),(0.14961,0.3622),(0.15748,0.3622),(0.16535,0.3622),(0.17323,0.3622),(0.1811,0.3622),(0.18898,0.3622),(0.19685,0.3622),(0.20472,0.3622),(0.2126,0.3622),(0.22047,0.3622),(0.22835,0.3622),(0.23622,0.3622),(0.24409,0.3622),(0.25197,0.3622),(0.25984,0.3622),(0.26772,0.3622),(0.27559,0.3622),(0.28346,0.3622),(0.29134,0.3622),(0.29921,0.3622),(0.30709,0.3622),(0.31496,0.3622),(0.32283,0.3622),(0.33071,0.3622),(0.33858,0.3622),(0.34646,0.3622),(0.35433,0.3622),(0.3622,0.3622),(0.37008,0.3622),(0.37795,0.3622),(0.38583,0.3622),(0.3937,0.3622),(0.40157,0.3622),(0.40945,0.3622),(0.41732,0.3622),(0.4252,0.3622),(0.43307,0.3622),(0.44094,0.3622),(0.44882,0.3622),(0.45669,0.3622),(0.46457,0.3622),(0.47244,0.3622),(0.48031,0.3622),(0.48819,0.3622),(0.49606,0.3622),(0.50394,0.3622),(0.51181,0.3622),(0.51969,0.3622),(0.52756,0.3622),(0.53543,0.3622),(0.54331,0.3622),(0.55118,0.3622),(0.55906,0.3622),(0.56693,0.3622),(0.5748,0.3622),(0.58268,0.3622),(0.59055,0.3622),(0.59843,0.3622),(0.6063,0.3622),(0.61417,0.3622),(0.62205,0.3622),(0.62992,0.3622),(0.6378,0.3622),(0.64567,0.3622),(0.65354,0.3622),(0.66142,0.3622),(0.66929,0.3622),(0.67717,0.3622),(0.68504,0.3622),(0.69291,0.3622),(0.70079,0.3622),(0.70866,0.3622),(0.71654,0.3622),(0.72441,0.3622),(0.73228,0.3622),(0.74016,0.3622),(0.74803,0.3622),(0.75591,0.3622),(0.76378,0.3622),(0.77165,0.3622),(0.77953,0.3622),(0.7874,0.3622),(0.79528,0.3622),(0.80315,0.3622),(0.81102,0.3622),(0.8189,0.3622),(0.82677,0.3622),(0.83465,0.3622),(0.84252,0.3622),(0.85039,0.3622),(0.85827,0.3622),(0.86614,0.3622),(0.87402,0.3622),(0.88189,0.3622),(0.88976,0.3622),(0.89764,0.3622),(0.90551,0.3622),(0.91339,0.3622),(0.92126,0.3622),(0.92913,0.3622),(0.93701,0.3622),(0.94488,0.3622),(0.95276,0.3622),(0.96063,0.3622),(0.9685,0.3622),(0.97638,0.3622),(0.98425,0.3622),(0.99213,0.3622),(0.99609,0.3622),(0.00391,0.37008),(0.00787,0.37008),(0.01575,0.37008),(0.02362,0.37008),(0.0315,0.37008),(0.03937,0.37008),(0.04724,0.37008),(0.05512,0.37008),(0.06299,0.37008),(0.07087,0.37008),(0.07874,0.37008),(0.08661,0.37008),(0.09449,0.37008),(0.10236,0.37008),(0.11024,0.37008),(0.11811,0.37008),(0.12598,0.37008),(0.13386,0.37008),(0.14173,0.37008),(0.14961,0.37008),(0.15748,0.37008),(0.16535,0.37008),(0.17323,0.37008),(0.1811,0.37008),(0.18898,0.37008),(0.19685,0.37008),(0.20472,0.37008),(0.2126,0.37008),(0.22047,0.37008),(0.22835,0.37008),(0.23622,0.37008),(0.24409,0.37008),(0.25197,0.37008),(0.25984,0.37008),(0.26772,0.37008),(0.27559,0.37008),(0.28346,0.37008),(0.29134,0.37008),(0.29921,0.37008),(0.30709,0.37008),(0.31496,0.37008),(0.32283,0.37008),(0.33071,0.37008),(0.33858,0.37008),(0.34646,0.37008),(0.35433,0.37008),(0.3622,0.37008),(0.37008,0.37008),(0.37795,0.37008),(0.38583,0.37008),(0.3937,0.37008),(0.40157,0.37008),(0.40945,0.37008),(0.41732,0.37008),(0.4252,0.37008),(0.43307,0.37008),(0.44094,0.37008),(0.44882,0.37008),(0.45669,0.37008),(0.46457,0.37008),(0.47244,0.37008),(0.48031,0.37008),(0.48819,0.37008),(0.49606,0.37008),(0.50394,0.37008),(0.51181,0.37008),(0.51969,0.37008),(0.52756,0.37008),(0.53543,0.37008),(0.54331,0.37008),(0.55118,0.37008),(0.55906,0.37008),(0.56693,0.37008),(0.5748,0.37008),(0.58268,0.37008),(0.59055,0.37008),(0.59843,0.37008),(0.6063,0.37008),(0.61417,0.37008),(0.62205,0.37008),(0.62992,0.37008),(0.6378,0.37008),(0.64567,0.37008),(0.65354,0.37008),(0.66142,0.37008),(0.66929,0.37008),(0.67717,0.37008),(0.68504,0.37008),(0.69291,0.37008),(0.70079,0.37008),(0.70866,0.37008),(0.71654,0.37008),(0.72441,0.37008),(0.73228,0.37008),(0.74016,0.37008),(0.74803,0.37008),(0.75591,0.37008),(0.76378,0.37008),(0.77165,0.37008),(0.77953,0.37008),(0.7874,0.37008),(0.79528,0.37008),(0.80315,0.37008),(0.81102,0.37008),(0.8189,0.37008),(0.82677,0.37008),(0.83465,0.37008),(0.84252,0.37008),(0.85039,0.37008),(0.85827,0.37008),(0.86614,0.37008),(0.87402,0.37008),(0.88189,0.37008),(0.88976,0.37008),(0.89764,0.37008),(0.90551,0.37008),(0.91339,0.37008),(0.92126,0.37008),(0.92913,0.37008),(0.93701,0.37008),(0.94488,0.37008),(0.95276,0.37008),(0.96063,0.37008),(0.9685,0.37008),(0.97638,0.37008),(0.98425,0.37008),(0.99213,0.37008),(0.99609,0.37008),(0.00391,0.37795),(0.00787,0.37795),(0.01575,0.37795),(0.02362,0.37795),(0.0315,0.37795),(0.03937,0.37795),(0.04724,0.37795),(0.05512,0.37795),(0.06299,0.37795),(0.07087,0.37795),(0.07874,0.37795),(0.08661,0.37795),(0.09449,0.37795),(0.10236,0.37795),(0.11024,0.37795),(0.11811,0.37795),(0.12598,0.37795),(0.13386,0.37795),(0.14173,0.37795),(0.14961,0.37795),(0.15748,0.37795),(0.16535,0.37795),(0.17323,0.37795),(0.1811,0.37795),(0.18898,0.37795),(0.19685,0.37795),(0.20472,0.37795),(0.2126,0.37795),(0.22047,0.37795),(0.22835,0.37795),(0.23622,0.37795),(0.24409,0.37795),(0.25197,0.37795),(0.25984,0.37795),(0.26772,0.37795),(0.27559,0.37795),(0.28346,0.37795),(0.29134,0.37795),(0.29921,0.37795),(0.30709,0.37795),(0.31496,0.37795),(0.32283,0.37795),(0.33071,0.37795),(0.33858,0.37795),(0.34646,0.37795),(0.35433,0.37795),(0.3622,0.37795),(0.37008,0.37795),(0.37795,0.37795),(0.38583,0.37795),(0.3937,0.37795),(0.40157,0.37795),(0.40945,0.37795),(0.41732,0.37795),(0.4252,0.37795),(0.43307,0.37795),(0.44094,0.37795),(0.44882,0.37795),(0.45669,0.37795),(0.46457,0.37795),(0.47244,0.37795),(0.48031,0.37795),(0.48819,0.37795),(0.49606,0.37795),(0.50394,0.37795),(0.51181,0.37795),(0.51969,0.37795),(0.52756,0.37795),(0.53543,0.37795),(0.54331,0.37795),(0.55118,0.37795),(0.55906,0.37795),(0.56693,0.37795),(0.5748,0.37795),(0.58268,0.37795),(0.59055,0.37795),(0.59843,0.37795),(0.6063,0.37795),(0.61417,0.37795),(0.62205,0.37795),(0.62992,0.37795),(0.6378,0.37795),(0.64567,0.37795),(0.65354,0.37795),(0.66142,0.37795),(0.66929,0.37795),(0.67717,0.37795),(0.68504,0.37795),(0.69291,0.37795),(0.70079,0.37795),(0.70866,0.37795),(0.71654,0.37795),(0.72441,0.37795),(0.73228,0.37795),(0.74016,0.37795),(0.74803,0.37795),(0.75591,0.37795),(0.76378,0.37795),(0.77165,0.37795),(0.77953,0.37795),(0.7874,0.37795),(0.79528,0.37795),(0.80315,0.37795),(0.81102,0.37795),(0.8189,0.37795),(0.82677,0.37795),(0.83465,0.37795),(0.84252,0.37795),(0.85039,0.37795),(0.85827,0.37795),(0.86614,0.37795),(0.87402,0.37795),(0.88189,0.37795),(0.88976,0.37795),(0.89764,0.37795),(0.90551,0.37795),(0.91339,0.37795),(0.92126,0.37795),(0.92913,0.37795),(0.93701,0.37795),(0.94488,0.37795),(0.95276,0.37795),(0.96063,0.37795),(0.9685,0.37795),(0.97638,0.37795),(0.98425,0.37795),(0.99213,0.37795),(0.99609,0.37795),(0.00391,0.38583),(0.00787,0.38583),(0.01575,0.38583),(0.02362,0.38583),(0.0315,0.38583),(0.03937,0.38583),(0.04724,0.38583),(0.05512,0.38583),(0.06299,0.38583),(0.07087,0.38583),(0.07874,0.38583),(0.08661,0.38583),(0.09449,0.38583),(0.10236,0.38583),(0.11024,0.38583),(0.11811,0.38583),(0.12598,0.38583),(0.13386,0.38583),(0.14173,0.38583),(0.14961,0.38583),(0.15748,0.38583),(0.16535,0.38583),(0.17323,0.38583),(0.1811,0.38583),(0.18898,0.38583),(0.19685,0.38583),(0.20472,0.38583),(0.2126,0.38583),(0.22047,0.38583),(0.22835,0.38583),(0.23622,0.38583),(0.24409,0.38583),(0.25197,0.38583),(0.25984,0.38583),(0.26772,0.38583),(0.27559,0.38583),(0.28346,0.38583),(0.29134,0.38583),(0.29921,0.38583),(0.30709,0.38583),(0.31496,0.38583),(0.32283,0.38583),(0.33071,0.38583),(0.33858,0.38583),(0.34646,0.38583),(0.35433,0.38583),(0.3622,0.38583),(0.37008,0.38583),(0.37795,0.38583),(0.38583,0.38583),(0.3937,0.38583),(0.40157,0.38583),(0.40945,0.38583),(0.41732,0.38583),(0.4252,0.38583),(0.43307,0.38583),(0.44094,0.38583),(0.44882,0.38583),(0.45669,0.38583),(0.46457,0.38583),(0.47244,0.38583),(0.48031,0.38583),(0.48819,0.38583),(0.49606,0.38583),(0.50394,0.38583),(0.51181,0.38583),(0.51969,0.38583),(0.52756,0.38583),(0.53543,0.38583),(0.54331,0.38583),(0.55118,0.38583),(0.55906,0.38583),(0.56693,0.38583),(0.5748,0.38583),(0.58268,0.38583),(0.59055,0.38583),(0.59843,0.38583),(0.6063,0.38583),(0.61417,0.38583),(0.62205,0.38583),(0.62992,0.38583),(0.6378,0.38583),(0.64567,0.38583),(0.65354,0.38583),(0.66142,0.38583),(0.66929,0.38583),(0.67717,0.38583),(0.68504,0.38583),(0.69291,0.38583),(0.70079,0.38583),(0.70866,0.38583),(0.71654,0.38583),(0.72441,0.38583),(0.73228,0.38583),(0.74016,0.38583),(0.74803,0.38583),(0.75591,0.38583),(0.76378,0.38583),(0.77165,0.38583),(0.77953,0.38583),(0.7874,0.38583),(0.79528,0.38583),(0.80315,0.38583),(0.81102,0.38583),(0.8189,0.38583),(0.82677,0.38583),(0.83465,0.38583),(0.84252,0.38583),(0.85039,0.38583),(0.85827,0.38583),(0.86614,0.38583),(0.87402,0.38583),(0.88189,0.38583),(0.88976,0.38583),(0.89764,0.38583),(0.90551,0.38583),(0.91339,0.38583),(0.92126,0.38583),(0.92913,0.38583),(0.93701,0.38583),(0.94488,0.38583),(0.95276,0.38583),(0.96063,0.38583),(0.9685,0.38583),(0.97638,0.38583),(0.98425,0.38583),(0.99213,0.38583),(0.99609,0.38583),(0.00391,0.3937),(0.00787,0.3937),(0.01575,0.3937),(0.02362,0.3937),(0.0315,0.3937),(0.03937,0.3937),(0.04724,0.3937),(0.05512,0.3937),(0.06299,0.3937),(0.07087,0.3937),(0.07874,0.3937),(0.08661,0.3937),(0.09449,0.3937),(0.10236,0.3937),(0.11024,0.3937),(0.11811,0.3937),(0.12598,0.3937),(0.13386,0.3937),(0.14173,0.3937),(0.14961,0.3937),(0.15748,0.3937),(0.16535,0.3937),(0.17323,0.3937),(0.1811,0.3937),(0.18898,0.3937),(0.19685,0.3937),(0.20472,0.3937),(0.2126,0.3937),(0.22047,0.3937),(0.22835,0.3937),(0.23622,0.3937),(0.24409,0.3937),(0.25197,0.3937),(0.25984,0.3937),(0.26772,0.3937),(0.27559,0.3937),(0.28346,0.3937),(0.29134,0.3937),(0.29921,0.3937),(0.30709,0.3937),(0.31496,0.3937),(0.32283,0.3937),(0.33071,0.3937),(0.33858,0.3937),(0.34646,0.3937),(0.35433,0.3937),(0.3622,0.3937),(0.37008,0.3937),(0.37795,0.3937),(0.38583,0.3937),(0.3937,0.3937),(0.40157,0.3937),(0.40945,0.3937),(0.41732,0.3937),(0.4252,0.3937),(0.43307,0.3937),(0.44094,0.3937),(0.44882,0.3937),(0.45669,0.3937),(0.46457,0.3937),(0.47244,0.3937),(0.48031,0.3937),(0.48819,0.3937),(0.49606,0.3937),(0.50394,0.3937),(0.51181,0.3937),(0.51969,0.3937),(0.52756,0.3937),(0.53543,0.3937),(0.54331,0.3937),(0.55118,0.3937),(0.55906,0.3937),(0.56693,0.3937),(0.5748,0.3937),(0.58268,0.3937),(0.59055,0.3937),(0.59843,0.3937),(0.6063,0.3937),(0.61417,0.3937),(0.62205,0.3937),(0.62992,0.3937),(0.6378,0.3937),(0.64567,0.3937),(0.65354,0.3937),(0.66142,0.3937),(0.66929,0.3937),(0.67717,0.3937),(0.68504,0.3937),(0.69291,0.3937),(0.70079,0.3937),(0.70866,0.3937),(0.71654,0.3937),(0.72441,0.3937),(0.73228,0.3937),(0.74016,0.3937),(0.74803,0.3937),(0.75591,0.3937),(0.76378,0.3937),(0.77165,0.3937),(0.77953,0.3937),(0.7874,0.3937),(0.79528,0.3937),(0.80315,0.3937),(0.81102,0.3937),(0.8189,0.3937),(0.82677,0.3937),(0.83465,0.3937),(0.84252,0.3937),(0.85039,0.3937),(0.85827,0.3937),(0.86614,0.3937),(0.87402,0.3937),(0.88189,0.3937),(0.88976,0.3937),(0.89764,0.3937),(0.90551,0.3937),(0.91339,0.3937),(0.92126,0.3937),(0.92913,0.3937),(0.93701,0.3937),(0.94488,0.3937),(0.95276,0.3937),(0.96063,0.3937),(0.9685,0.3937),(0.97638,0.3937),(0.98425,0.3937),(0.99213,0.3937),(0.99609,0.3937),(0.00391,0.40157),(0.00787,0.40157),(0.01575,0.40157),(0.02362,0.40157),(0.0315,0.40157),(0.03937,0.40157),(0.04724,0.40157),(0.05512,0.40157),(0.06299,0.40157),(0.07087,0.40157),(0.07874,0.40157),(0.08661,0.40157),(0.09449,0.40157),(0.10236,0.40157),(0.11024,0.40157),(0.11811,0.40157),(0.12598,0.40157),(0.13386,0.40157),(0.14173,0.40157),(0.14961,0.40157),(0.15748,0.40157),(0.16535,0.40157),(0.17323,0.40157),(0.1811,0.40157),(0.18898,0.40157),(0.19685,0.40157),(0.20472,0.40157),(0.2126,0.40157),(0.22047,0.40157),(0.22835,0.40157),(0.23622,0.40157),(0.24409,0.40157),(0.25197,0.40157),(0.25984,0.40157),(0.26772,0.40157),(0.27559,0.40157),(0.28346,0.40157),(0.29134,0.40157),(0.29921,0.40157),(0.30709,0.40157),(0.31496,0.40157),(0.32283,0.40157),(0.33071,0.40157),(0.33858,0.40157),(0.34646,0.40157),(0.35433,0.40157),(0.3622,0.40157),(0.37008,0.40157),(0.37795,0.40157),(0.38583,0.40157),(0.3937,0.40157),(0.40157,0.40157),(0.40945,0.40157),(0.41732,0.40157),(0.4252,0.40157),(0.43307,0.40157),(0.44094,0.40157),(0.44882,0.40157),(0.45669,0.40157),(0.46457,0.40157),(0.47244,0.40157),(0.48031,0.40157),(0.48819,0.40157),(0.49606,0.40157),(0.50394,0.40157),(0.51181,0.40157),(0.51969,0.40157),(0.52756,0.40157),(0.53543,0.40157),(0.54331,0.40157),(0.55118,0.40157),(0.55906,0.40157),(0.56693,0.40157),(0.5748,0.40157),(0.58268,0.40157),(0.59055,0.40157),(0.59843,0.40157),(0.6063,0.40157),(0.61417,0.40157),(0.62205,0.40157),(0.62992,0.40157),(0.6378,0.40157),(0.64567,0.40157),(0.65354,0.40157),(0.66142,0.40157),(0.66929,0.40157),(0.67717,0.40157),(0.68504,0.40157),(0.69291,0.40157),(0.70079,0.40157),(0.70866,0.40157),(0.71654,0.40157),(0.72441,0.40157),(0.73228,0.40157),(0.74016,0.40157),(0.74803,0.40157),(0.75591,0.40157),(0.76378,0.40157),(0.77165,0.40157),(0.77953,0.40157),(0.7874,0.40157),(0.79528,0.40157),(0.80315,0.40157),(0.81102,0.40157),(0.8189,0.40157),(0.82677,0.40157),(0.83465,0.40157),(0.84252,0.40157),(0.85039,0.40157),(0.85827,0.40157),(0.86614,0.40157),(0.87402,0.40157),(0.88189,0.40157),(0.88976,0.40157),(0.89764,0.40157),(0.90551,0.40157),(0.91339,0.40157),(0.92126,0.40157),(0.92913,0.40157),(0.93701,0.40157),(0.94488,0.40157),(0.95276,0.40157),(0.96063,0.40157),(0.9685,0.40157),(0.97638,0.40157),(0.98425,0.40157),(0.99213,0.40157),(0.99609,0.40157),(0.00391,0.40945),(0.00787,0.40945),(0.01575,0.40945),(0.02362,0.40945),(0.0315,0.40945),(0.03937,0.40945),(0.04724,0.40945),(0.05512,0.40945),(0.06299,0.40945),(0.07087,0.40945),(0.07874,0.40945),(0.08661,0.40945),(0.09449,0.40945),(0.10236,0.40945),(0.11024,0.40945),(0.11811,0.40945),(0.12598,0.40945),(0.13386,0.40945),(0.14173,0.40945),(0.14961,0.40945),(0.15748,0.40945),(0.16535,0.40945),(0.17323,0.40945),(0.1811,0.40945),(0.18898,0.40945),(0.19685,0.40945),(0.20472,0.40945),(0.2126,0.40945),(0.22047,0.40945),(0.22835,0.40945),(0.23622,0.40945),(0.24409,0.40945),(0.25197,0.40945),(0.25984,0.40945),(0.26772,0.40945),(0.27559,0.40945),(0.28346,0.40945),(0.29134,0.40945),(0.29921,0.40945),(0.30709,0.40945),(0.31496,0.40945),(0.32283,0.40945),(0.33071,0.40945),(0.33858,0.40945),(0.34646,0.40945),(0.35433,0.40945),(0.3622,0.40945),(0.37008,0.40945),(0.37795,0.40945),(0.38583,0.40945),(0.3937,0.40945),(0.40157,0.40945),(0.40945,0.40945),(0.41732,0.40945),(0.4252,0.40945),(0.43307,0.40945),(0.44094,0.40945),(0.44882,0.40945),(0.45669,0.40945),(0.46457,0.40945),(0.47244,0.40945),(0.48031,0.40945),(0.48819,0.40945),(0.49606,0.40945),(0.50394,0.40945),(0.51181,0.40945),(0.51969,0.40945),(0.52756,0.40945),(0.53543,0.40945),(0.54331,0.40945),(0.55118,0.40945),(0.55906,0.40945),(0.56693,0.40945),(0.5748,0.40945),(0.58268,0.40945),(0.59055,0.40945),(0.59843,0.40945),(0.6063,0.40945),(0.61417,0.40945),(0.62205,0.40945),(0.62992,0.40945),(0.6378,0.40945),(0.64567,0.40945),(0.65354,0.40945),(0.66142,0.40945),(0.66929,0.40945),(0.67717,0.40945),(0.68504,0.40945),(0.69291,0.40945),(0.70079,0.40945),(0.70866,0.40945),(0.71654,0.40945),(0.72441,0.40945),(0.73228,0.40945),(0.74016,0.40945),(0.74803,0.40945),(0.75591,0.40945),(0.76378,0.40945),(0.77165,0.40945),(0.77953,0.40945),(0.7874,0.40945),(0.79528,0.40945),(0.80315,0.40945),(0.81102,0.40945),(0.8189,0.40945),(0.82677,0.40945),(0.83465,0.40945),(0.84252,0.40945),(0.85039,0.40945),(0.85827,0.40945),(0.86614,0.40945),(0.87402,0.40945),(0.88189,0.40945),(0.88976,0.40945),(0.89764,0.40945),(0.90551,0.40945),(0.91339,0.40945),(0.92126,0.40945),(0.92913,0.40945),(0.93701,0.40945),(0.94488,0.40945),(0.95276,0.40945),(0.96063,0.40945),(0.9685,0.40945),(0.97638,0.40945),(0.98425,0.40945),(0.99213,0.40945),(0.99609,0.40945),(0.00391,0.41732),(0.00787,0.41732),(0.01575,0.41732),(0.02362,0.41732),(0.0315,0.41732),(0.03937,0.41732),(0.04724,0.41732),(0.05512,0.41732),(0.06299,0.41732),(0.07087,0.41732),(0.07874,0.41732),(0.08661,0.41732),(0.09449,0.41732),(0.10236,0.41732),(0.11024,0.41732),(0.11811,0.41732),(0.12598,0.41732),(0.13386,0.41732),(0.14173,0.41732),(0.14961,0.41732),(0.15748,0.41732),(0.16535,0.41732),(0.17323,0.41732),(0.1811,0.41732),(0.18898,0.41732),(0.19685,0.41732),(0.20472,0.41732),(0.2126,0.41732),(0.22047,0.41732),(0.22835,0.41732),(0.23622,0.41732),(0.24409,0.41732),(0.25197,0.41732),(0.25984,0.41732),(0.26772,0.41732),(0.27559,0.41732),(0.28346,0.41732),(0.29134,0.41732),(0.29921,0.41732),(0.30709,0.41732),(0.31496,0.41732),(0.32283,0.41732),(0.33071,0.41732),(0.33858,0.41732),(0.34646,0.41732),(0.35433,0.41732),(0.3622,0.41732),(0.37008,0.41732),(0.37795,0.41732),(0.38583,0.41732),(0.3937,0.41732),(0.40157,0.41732),(0.40945,0.41732),(0.41732,0.41732),(0.4252,0.41732),(0.43307,0.41732),(0.44094,0.41732),(0.44882,0.41732),(0.45669,0.41732),(0.46457,0.41732),(0.47244,0.41732),(0.48031,0.41732),(0.48819,0.41732),(0.49606,0.41732),(0.50394,0.41732),(0.51181,0.41732),(0.51969,0.41732),(0.52756,0.41732),(0.53543,0.41732),(0.54331,0.41732),(0.55118,0.41732),(0.55906,0.41732),(0.56693,0.41732),(0.5748,0.41732),(0.58268,0.41732),(0.59055,0.41732),(0.59843,0.41732),(0.6063,0.41732),(0.61417,0.41732),(0.62205,0.41732),(0.62992,0.41732),(0.6378,0.41732),(0.64567,0.41732),(0.65354,0.41732),(0.66142,0.41732),(0.66929,0.41732),(0.67717,0.41732),(0.68504,0.41732),(0.69291,0.41732),(0.70079,0.41732),(0.70866,0.41732),(0.71654,0.41732),(0.72441,0.41732),(0.73228,0.41732),(0.74016,0.41732),(0.74803,0.41732),(0.75591,0.41732),(0.76378,0.41732),(0.77165,0.41732),(0.77953,0.41732),(0.7874,0.41732),(0.79528,0.41732),(0.80315,0.41732),(0.81102,0.41732),(0.8189,0.41732),(0.82677,0.41732),(0.83465,0.41732),(0.84252,0.41732),(0.85039,0.41732),(0.85827,0.41732),(0.86614,0.41732),(0.87402,0.41732),(0.88189,0.41732),(0.88976,0.41732),(0.89764,0.41732),(0.90551,0.41732),(0.91339,0.41732),(0.92126,0.41732),(0.92913,0.41732),(0.93701,0.41732),(0.94488,0.41732),(0.95276,0.41732),(0.96063,0.41732),(0.9685,0.41732),(0.97638,0.41732),(0.98425,0.41732),(0.99213,0.41732),(0.99609,0.41732),(0.00391,0.4252),(0.00787,0.4252),(0.01575,0.4252),(0.02362,0.4252),(0.0315,0.4252),(0.03937,0.4252),(0.04724,0.4252),(0.05512,0.4252),(0.06299,0.4252),(0.07087,0.4252),(0.07874,0.4252),(0.08661,0.4252),(0.09449,0.4252),(0.10236,0.4252),(0.11024,0.4252),(0.11811,0.4252),(0.12598,0.4252),(0.13386,0.4252),(0.14173,0.4252),(0.14961,0.4252),(0.15748,0.4252),(0.16535,0.4252),(0.17323,0.4252),(0.1811,0.4252),(0.18898,0.4252),(0.19685,0.4252),(0.20472,0.4252),(0.2126,0.4252),(0.22047,0.4252),(0.22835,0.4252),(0.23622,0.4252),(0.24409,0.4252),(0.25197,0.4252),(0.25984,0.4252),(0.26772,0.4252),(0.27559,0.4252),(0.28346,0.4252),(0.29134,0.4252),(0.29921,0.4252),(0.30709,0.4252),(0.31496,0.4252),(0.32283,0.4252),(0.33071,0.4252),(0.33858,0.4252),(0.34646,0.4252),(0.35433,0.4252),(0.3622,0.4252),(0.37008,0.4252),(0.37795,0.4252),(0.38583,0.4252),(0.3937,0.4252),(0.40157,0.4252),(0.40945,0.4252),(0.41732,0.4252),(0.4252,0.4252),(0.43307,0.4252),(0.44094,0.4252),(0.44882,0.4252),(0.45669,0.4252),(0.46457,0.4252),(0.47244,0.4252),(0.48031,0.4252),(0.48819,0.4252),(0.49606,0.4252),(0.50394,0.4252),(0.51181,0.4252),(0.51969,0.4252),(0.52756,0.4252),(0.53543,0.4252),(0.54331,0.4252),(0.55118,0.4252),(0.55906,0.4252),(0.56693,0.4252),(0.5748,0.4252),(0.58268,0.4252),(0.59055,0.4252),(0.59843,0.4252),(0.6063,0.4252),(0.61417,0.4252),(0.62205,0.4252),(0.62992,0.4252),(0.6378,0.4252),(0.64567,0.4252),(0.65354,0.4252),(0.66142,0.4252),(0.66929,0.4252),(0.67717,0.4252),(0.68504,0.4252),(0.69291,0.4252),(0.70079,0.4252),(0.70866,0.4252),(0.71654,0.4252),(0.72441,0.4252),(0.73228,0.4252),(0.74016,0.4252),(0.74803,0.4252),(0.75591,0.4252),(0.76378,0.4252),(0.77165,0.4252),(0.77953,0.4252),(0.7874,0.4252),(0.79528,0.4252),(0.80315,0.4252),(0.81102,0.4252),(0.8189,0.4252),(0.82677,0.4252),(0.83465,0.4252),(0.84252,0.4252),(0.85039,0.4252),(0.85827,0.4252),(0.86614,0.4252),(0.87402,0.4252),(0.88189,0.4252),(0.88976,0.4252),(0.89764,0.4252),(0.90551,0.4252),(0.91339,0.4252),(0.92126,0.4252),(0.92913,0.4252),(0.93701,0.4252),(0.94488,0.4252),(0.95276,0.4252),(0.96063,0.4252),(0.9685,0.4252),(0.97638,0.4252),(0.98425,0.4252),(0.99213,0.4252),(0.99609,0.4252),(0.00391,0.43307),(0.00787,0.43307),(0.01575,0.43307),(0.02362,0.43307),(0.0315,0.43307),(0.03937,0.43307),(0.04724,0.43307),(0.05512,0.43307),(0.06299,0.43307),(0.07087,0.43307),(0.07874,0.43307),(0.08661,0.43307),(0.09449,0.43307),(0.10236,0.43307),(0.11024,0.43307),(0.11811,0.43307),(0.12598,0.43307),(0.13386,0.43307),(0.14173,0.43307),(0.14961,0.43307),(0.15748,0.43307),(0.16535,0.43307),(0.17323,0.43307),(0.1811,0.43307),(0.18898,0.43307),(0.19685,0.43307),(0.20472,0.43307),(0.2126,0.43307),(0.22047,0.43307),(0.22835,0.43307),(0.23622,0.43307),(0.24409,0.43307),(0.25197,0.43307),(0.25984,0.43307),(0.26772,0.43307),(0.27559,0.43307),(0.28346,0.43307),(0.29134,0.43307),(0.29921,0.43307),(0.30709,0.43307),(0.31496,0.43307),(0.32283,0.43307),(0.33071,0.43307),(0.33858,0.43307),(0.34646,0.43307),(0.35433,0.43307),(0.3622,0.43307),(0.37008,0.43307),(0.37795,0.43307),(0.38583,0.43307),(0.3937,0.43307),(0.40157,0.43307),(0.40945,0.43307),(0.41732,0.43307),(0.4252,0.43307),(0.43307,0.43307),(0.44094,0.43307),(0.44882,0.43307),(0.45669,0.43307),(0.46457,0.43307),(0.47244,0.43307),(0.48031,0.43307),(0.48819,0.43307),(0.49606,0.43307),(0.50394,0.43307),(0.51181,0.43307),(0.51969,0.43307),(0.52756,0.43307),(0.53543,0.43307),(0.54331,0.43307),(0.55118,0.43307),(0.55906,0.43307),(0.56693,0.43307),(0.5748,0.43307),(0.58268,0.43307),(0.59055,0.43307),(0.59843,0.43307),(0.6063,0.43307),(0.61417,0.43307),(0.62205,0.43307),(0.62992,0.43307),(0.6378,0.43307),(0.64567,0.43307),(0.65354,0.43307),(0.66142,0.43307),(0.66929,0.43307),(0.67717,0.43307),(0.68504,0.43307),(0.69291,0.43307),(0.70079,0.43307),(0.70866,0.43307),(0.71654,0.43307),(0.72441,0.43307),(0.73228,0.43307),(0.74016,0.43307),(0.74803,0.43307),(0.75591,0.43307),(0.76378,0.43307),(0.77165,0.43307),(0.77953,0.43307),(0.7874,0.43307),(0.79528,0.43307),(0.80315,0.43307),(0.81102,0.43307),(0.8189,0.43307),(0.82677,0.43307),(0.83465,0.43307),(0.84252,0.43307),(0.85039,0.43307),(0.85827,0.43307),(0.86614,0.43307),(0.87402,0.43307),(0.88189,0.43307),(0.88976,0.43307),(0.89764,0.43307),(0.90551,0.43307),(0.91339,0.43307),(0.92126,0.43307),(0.92913,0.43307),(0.93701,0.43307),(0.94488,0.43307),(0.95276,0.43307),(0.96063,0.43307),(0.9685,0.43307),(0.97638,0.43307),(0.98425,0.43307),(0.99213,0.43307),(0.99609,0.43307),(0.00391,0.44094),(0.00787,0.44094),(0.01575,0.44094),(0.02362,0.44094),(0.0315,0.44094),(0.03937,0.44094),(0.04724,0.44094),(0.05512,0.44094),(0.06299,0.44094),(0.07087,0.44094),(0.07874,0.44094),(0.08661,0.44094),(0.09449,0.44094),(0.10236,0.44094),(0.11024,0.44094),(0.11811,0.44094),(0.12598,0.44094),(0.13386,0.44094),(0.14173,0.44094),(0.14961,0.44094),(0.15748,0.44094),(0.16535,0.44094),(0.17323,0.44094),(0.1811,0.44094),(0.18898,0.44094),(0.19685,0.44094),(0.20472,0.44094),(0.2126,0.44094),(0.22047,0.44094),(0.22835,0.44094),(0.23622,0.44094),(0.24409,0.44094),(0.25197,0.44094),(0.25984,0.44094),(0.26772,0.44094),(0.27559,0.44094),(0.28346,0.44094),(0.29134,0.44094),(0.29921,0.44094),(0.30709,0.44094),(0.31496,0.44094),(0.32283,0.44094),(0.33071,0.44094),(0.33858,0.44094),(0.34646,0.44094),(0.35433,0.44094),(0.3622,0.44094),(0.37008,0.44094),(0.37795,0.44094),(0.38583,0.44094),(0.3937,0.44094),(0.40157,0.44094),(0.40945,0.44094),(0.41732,0.44094),(0.4252,0.44094),(0.43307,0.44094),(0.44094,0.44094),(0.44882,0.44094),(0.45669,0.44094),(0.46457,0.44094),(0.47244,0.44094),(0.48031,0.44094),(0.48819,0.44094),(0.49606,0.44094),(0.50394,0.44094),(0.51181,0.44094),(0.51969,0.44094),(0.52756,0.44094),(0.53543,0.44094),(0.54331,0.44094),(0.55118,0.44094),(0.55906,0.44094),(0.56693,0.44094),(0.5748,0.44094),(0.58268,0.44094),(0.59055,0.44094),(0.59843,0.44094),(0.6063,0.44094),(0.61417,0.44094),(0.62205,0.44094),(0.62992,0.44094),(0.6378,0.44094),(0.64567,0.44094),(0.65354,0.44094),(0.66142,0.44094),(0.66929,0.44094),(0.67717,0.44094),(0.68504,0.44094),(0.69291,0.44094),(0.70079,0.44094),(0.70866,0.44094),(0.71654,0.44094),(0.72441,0.44094),(0.73228,0.44094),(0.74016,0.44094),(0.74803,0.44094),(0.75591,0.44094),(0.76378,0.44094),(0.77165,0.44094),(0.77953,0.44094),(0.7874,0.44094),(0.79528,0.44094),(0.80315,0.44094),(0.81102,0.44094),(0.8189,0.44094),(0.82677,0.44094),(0.83465,0.44094),(0.84252,0.44094),(0.85039,0.44094),(0.85827,0.44094),(0.86614,0.44094),(0.87402,0.44094),(0.88189,0.44094),(0.88976,0.44094),(0.89764,0.44094),(0.90551,0.44094),(0.91339,0.44094),(0.92126,0.44094),(0.92913,0.44094),(0.93701,0.44094),(0.94488,0.44094),(0.95276,0.44094),(0.96063,0.44094),(0.9685,0.44094),(0.97638,0.44094),(0.98425,0.44094),(0.99213,0.44094),(0.99609,0.44094),(0.00391,0.44882),(0.00787,0.44882),(0.01575,0.44882),(0.02362,0.44882),(0.0315,0.44882),(0.03937,0.44882),(0.04724,0.44882),(0.05512,0.44882),(0.06299,0.44882),(0.07087,0.44882),(0.07874,0.44882),(0.08661,0.44882),(0.09449,0.44882),(0.10236,0.44882),(0.11024,0.44882),(0.11811,0.44882),(0.12598,0.44882),(0.13386,0.44882),(0.14173,0.44882),(0.14961,0.44882),(0.15748,0.44882),(0.16535,0.44882),(0.17323,0.44882),(0.1811,0.44882),(0.18898,0.44882),(0.19685,0.44882),(0.20472,0.44882),(0.2126,0.44882),(0.22047,0.44882),(0.22835,0.44882),(0.23622,0.44882),(0.24409,0.44882),(0.25197,0.44882),(0.25984,0.44882),(0.26772,0.44882),(0.27559,0.44882),(0.28346,0.44882),(0.29134,0.44882),(0.29921,0.44882),(0.30709,0.44882),(0.31496,0.44882),(0.32283,0.44882),(0.33071,0.44882),(0.33858,0.44882),(0.34646,0.44882),(0.35433,0.44882),(0.3622,0.44882),(0.37008,0.44882),(0.37795,0.44882),(0.38583,0.44882),(0.3937,0.44882),(0.40157,0.44882),(0.40945,0.44882),(0.41732,0.44882),(0.4252,0.44882),(0.43307,0.44882),(0.44094,0.44882),(0.44882,0.44882),(0.45669,0.44882),(0.46457,0.44882),(0.47244,0.44882),(0.48031,0.44882),(0.48819,0.44882),(0.49606,0.44882),(0.50394,0.44882),(0.51181,0.44882),(0.51969,0.44882),(0.52756,0.44882),(0.53543,0.44882),(0.54331,0.44882),(0.55118,0.44882),(0.55906,0.44882),(0.56693,0.44882),(0.5748,0.44882),(0.58268,0.44882),(0.59055,0.44882),(0.59843,0.44882),(0.6063,0.44882),(0.61417,0.44882),(0.62205,0.44882),(0.62992,0.44882),(0.6378,0.44882),(0.64567,0.44882),(0.65354,0.44882),(0.66142,0.44882),(0.66929,0.44882),(0.67717,0.44882),(0.68504,0.44882),(0.69291,0.44882),(0.70079,0.44882),(0.70866,0.44882),(0.71654,0.44882),(0.72441,0.44882),(0.73228,0.44882),(0.74016,0.44882),(0.74803,0.44882),(0.75591,0.44882),(0.76378,0.44882),(0.77165,0.44882),(0.77953,0.44882),(0.7874,0.44882),(0.79528,0.44882),(0.80315,0.44882),(0.81102,0.44882),(0.8189,0.44882),(0.82677,0.44882),(0.83465,0.44882),(0.84252,0.44882),(0.85039,0.44882),(0.85827,0.44882),(0.86614,0.44882),(0.87402,0.44882),(0.88189,0.44882),(0.88976,0.44882),(0.89764,0.44882),(0.90551,0.44882),(0.91339,0.44882),(0.92126,0.44882),(0.92913,0.44882),(0.93701,0.44882),(0.94488,0.44882),(0.95276,0.44882),(0.96063,0.44882),(0.9685,0.44882),(0.97638,0.44882),(0.98425,0.44882),(0.99213,0.44882),(0.99609,0.44882),(0.00391,0.45669),(0.00787,0.45669),(0.01575,0.45669),(0.02362,0.45669),(0.0315,0.45669),(0.03937,0.45669),(0.04724,0.45669),(0.05512,0.45669),(0.06299,0.45669),(0.07087,0.45669),(0.07874,0.45669),(0.08661,0.45669),(0.09449,0.45669),(0.10236,0.45669),(0.11024,0.45669),(0.11811,0.45669),(0.12598,0.45669),(0.13386,0.45669),(0.14173,0.45669),(0.14961,0.45669),(0.15748,0.45669),(0.16535,0.45669),(0.17323,0.45669),(0.1811,0.45669),(0.18898,0.45669),(0.19685,0.45669),(0.20472,0.45669),(0.2126,0.45669),(0.22047,0.45669),(0.22835,0.45669),(0.23622,0.45669),(0.24409,0.45669),(0.25197,0.45669),(0.25984,0.45669),(0.26772,0.45669),(0.27559,0.45669),(0.28346,0.45669),(0.29134,0.45669),(0.29921,0.45669),(0.30709,0.45669),(0.31496,0.45669),(0.32283,0.45669),(0.33071,0.45669),(0.33858,0.45669),(0.34646,0.45669),(0.35433,0.45669),(0.3622,0.45669),(0.37008,0.45669),(0.37795,0.45669),(0.38583,0.45669),(0.3937,0.45669),(0.40157,0.45669),(0.40945,0.45669),(0.41732,0.45669),(0.4252,0.45669),(0.43307,0.45669),(0.44094,0.45669),(0.44882,0.45669),(0.45669,0.45669),(0.46457,0.45669),(0.47244,0.45669),(0.48031,0.45669),(0.48819,0.45669),(0.49606,0.45669),(0.50394,0.45669),(0.51181,0.45669),(0.51969,0.45669),(0.52756,0.45669),(0.53543,0.45669),(0.54331,0.45669),(0.55118,0.45669),(0.55906,0.45669),(0.56693,0.45669),(0.5748,0.45669),(0.58268,0.45669),(0.59055,0.45669),(0.59843,0.45669),(0.6063,0.45669),(0.61417,0.45669),(0.62205,0.45669),(0.62992,0.45669),(0.6378,0.45669),(0.64567,0.45669),(0.65354,0.45669),(0.66142,0.45669),(0.66929,0.45669),(0.67717,0.45669),(0.68504,0.45669),(0.69291,0.45669),(0.70079,0.45669),(0.70866,0.45669),(0.71654,0.45669),(0.72441,0.45669),(0.73228,0.45669),(0.74016,0.45669),(0.74803,0.45669),(0.75591,0.45669),(0.76378,0.45669),(0.77165,0.45669),(0.77953,0.45669),(0.7874,0.45669),(0.79528,0.45669),(0.80315,0.45669),(0.81102,0.45669),(0.8189,0.45669),(0.82677,0.45669),(0.83465,0.45669),(0.84252,0.45669),(0.85039,0.45669),(0.85827,0.45669),(0.86614,0.45669),(0.87402,0.45669),(0.88189,0.45669),(0.88976,0.45669),(0.89764,0.45669),(0.90551,0.45669),(0.91339,0.45669),(0.92126,0.45669),(0.92913,0.45669),(0.93701,0.45669),(0.94488,0.45669),(0.95276,0.45669),(0.96063,0.45669),(0.9685,0.45669),(0.97638,0.45669),(0.98425,0.45669),(0.99213,0.45669),(0.99609,0.45669),(0.00391,0.46457),(0.00787,0.46457),(0.01575,0.46457),(0.02362,0.46457),(0.0315,0.46457),(0.03937,0.46457),(0.04724,0.46457),(0.05512,0.46457),(0.06299,0.46457),(0.07087,0.46457),(0.07874,0.46457),(0.08661,0.46457),(0.09449,0.46457),(0.10236,0.46457),(0.11024,0.46457),(0.11811,0.46457),(0.12598,0.46457),(0.13386,0.46457),(0.14173,0.46457),(0.14961,0.46457),(0.15748,0.46457),(0.16535,0.46457),(0.17323,0.46457),(0.1811,0.46457),(0.18898,0.46457),(0.19685,0.46457),(0.20472,0.46457),(0.2126,0.46457),(0.22047,0.46457),(0.22835,0.46457),(0.23622,0.46457),(0.24409,0.46457),(0.25197,0.46457),(0.25984,0.46457),(0.26772,0.46457),(0.27559,0.46457),(0.28346,0.46457),(0.29134,0.46457),(0.29921,0.46457),(0.30709,0.46457),(0.31496,0.46457),(0.32283,0.46457),(0.33071,0.46457),(0.33858,0.46457),(0.34646,0.46457),(0.35433,0.46457),(0.3622,0.46457),(0.37008,0.46457),(0.37795,0.46457),(0.38583,0.46457),(0.3937,0.46457),(0.40157,0.46457),(0.40945,0.46457),(0.41732,0.46457),(0.4252,0.46457),(0.43307,0.46457),(0.44094,0.46457),(0.44882,0.46457),(0.45669,0.46457),(0.46457,0.46457),(0.47244,0.46457),(0.48031,0.46457),(0.48819,0.46457),(0.49606,0.46457),(0.50394,0.46457),(0.51181,0.46457),(0.51969,0.46457),(0.52756,0.46457),(0.53543,0.46457),(0.54331,0.46457),(0.55118,0.46457),(0.55906,0.46457),(0.56693,0.46457),(0.5748,0.46457),(0.58268,0.46457),(0.59055,0.46457),(0.59843,0.46457),(0.6063,0.46457),(0.61417,0.46457),(0.62205,0.46457),(0.62992,0.46457),(0.6378,0.46457),(0.64567,0.46457),(0.65354,0.46457),(0.66142,0.46457),(0.66929,0.46457),(0.67717,0.46457),(0.68504,0.46457),(0.69291,0.46457),(0.70079,0.46457),(0.70866,0.46457),(0.71654,0.46457),(0.72441,0.46457),(0.73228,0.46457),(0.74016,0.46457),(0.74803,0.46457),(0.75591,0.46457),(0.76378,0.46457),(0.77165,0.46457),(0.77953,0.46457),(0.7874,0.46457),(0.79528,0.46457),(0.80315,0.46457),(0.81102,0.46457),(0.8189,0.46457),(0.82677,0.46457),(0.83465,0.46457),(0.84252,0.46457),(0.85039,0.46457),(0.85827,0.46457),(0.86614,0.46457),(0.87402,0.46457),(0.88189,0.46457),(0.88976,0.46457),(0.89764,0.46457),(0.90551,0.46457),(0.91339,0.46457),(0.92126,0.46457),(0.92913,0.46457),(0.93701,0.46457),(0.94488,0.46457),(0.95276,0.46457),(0.96063,0.46457),(0.9685,0.46457),(0.97638,0.46457),(0.98425,0.46457),(0.99213,0.46457),(0.99609,0.46457),(0.00391,0.47244),(0.00787,0.47244),(0.01575,0.47244),(0.02362,0.47244),(0.0315,0.47244),(0.03937,0.47244),(0.04724,0.47244),(0.05512,0.47244),(0.06299,0.47244),(0.07087,0.47244),(0.07874,0.47244),(0.08661,0.47244),(0.09449,0.47244),(0.10236,0.47244),(0.11024,0.47244),(0.11811,0.47244),(0.12598,0.47244),(0.13386,0.47244),(0.14173,0.47244),(0.14961,0.47244),(0.15748,0.47244),(0.16535,0.47244),(0.17323,0.47244),(0.1811,0.47244),(0.18898,0.47244),(0.19685,0.47244),(0.20472,0.47244),(0.2126,0.47244),(0.22047,0.47244),(0.22835,0.47244),(0.23622,0.47244),(0.24409,0.47244),(0.25197,0.47244),(0.25984,0.47244),(0.26772,0.47244),(0.27559,0.47244),(0.28346,0.47244),(0.29134,0.47244),(0.29921,0.47244),(0.30709,0.47244),(0.31496,0.47244),(0.32283,0.47244),(0.33071,0.47244),(0.33858,0.47244),(0.34646,0.47244),(0.35433,0.47244),(0.3622,0.47244),(0.37008,0.47244),(0.37795,0.47244),(0.38583,0.47244),(0.3937,0.47244),(0.40157,0.47244),(0.40945,0.47244),(0.41732,0.47244),(0.4252,0.47244),(0.43307,0.47244),(0.44094,0.47244),(0.44882,0.47244),(0.45669,0.47244),(0.46457,0.47244),(0.47244,0.47244),(0.48031,0.47244),(0.48819,0.47244),(0.49606,0.47244),(0.50394,0.47244),(0.51181,0.47244),(0.51969,0.47244),(0.52756,0.47244),(0.53543,0.47244),(0.54331,0.47244),(0.55118,0.47244),(0.55906,0.47244),(0.56693,0.47244),(0.5748,0.47244),(0.58268,0.47244),(0.59055,0.47244),(0.59843,0.47244),(0.6063,0.47244),(0.61417,0.47244),(0.62205,0.47244),(0.62992,0.47244),(0.6378,0.47244),(0.64567,0.47244),(0.65354,0.47244),(0.66142,0.47244),(0.66929,0.47244),(0.67717,0.47244),(0.68504,0.47244),(0.69291,0.47244),(0.70079,0.47244),(0.70866,0.47244),(0.71654,0.47244),(0.72441,0.47244),(0.73228,0.47244),(0.74016,0.47244),(0.74803,0.47244),(0.75591,0.47244),(0.76378,0.47244),(0.77165,0.47244),(0.77953,0.47244),(0.7874,0.47244),(0.79528,0.47244),(0.80315,0.47244),(0.81102,0.47244),(0.8189,0.47244),(0.82677,0.47244),(0.83465,0.47244),(0.84252,0.47244),(0.85039,0.47244),(0.85827,0.47244),(0.86614,0.47244),(0.87402,0.47244),(0.88189,0.47244),(0.88976,0.47244),(0.89764,0.47244),(0.90551,0.47244),(0.91339,0.47244),(0.92126,0.47244),(0.92913,0.47244),(0.93701,0.47244),(0.94488,0.47244),(0.95276,0.47244),(0.96063,0.47244),(0.9685,0.47244),(0.97638,0.47244),(0.98425,0.47244),(0.99213,0.47244),(0.99609,0.47244),(0.00391,0.48031),(0.00787,0.48031),(0.01575,0.48031),(0.02362,0.48031),(0.0315,0.48031),(0.03937,0.48031),(0.04724,0.48031),(0.05512,0.48031),(0.06299,0.48031),(0.07087,0.48031),(0.07874,0.48031),(0.08661,0.48031),(0.09449,0.48031),(0.10236,0.48031),(0.11024,0.48031),(0.11811,0.48031),(0.12598,0.48031),(0.13386,0.48031),(0.14173,0.48031),(0.14961,0.48031),(0.15748,0.48031),(0.16535,0.48031),(0.17323,0.48031),(0.1811,0.48031),(0.18898,0.48031),(0.19685,0.48031),(0.20472,0.48031),(0.2126,0.48031),(0.22047,0.48031),(0.22835,0.48031),(0.23622,0.48031),(0.24409,0.48031),(0.25197,0.48031),(0.25984,0.48031),(0.26772,0.48031),(0.27559,0.48031),(0.28346,0.48031),(0.29134,0.48031),(0.29921,0.48031),(0.30709,0.48031),(0.31496,0.48031),(0.32283,0.48031),(0.33071,0.48031),(0.33858,0.48031),(0.34646,0.48031),(0.35433,0.48031),(0.3622,0.48031),(0.37008,0.48031),(0.37795,0.48031),(0.38583,0.48031),(0.3937,0.48031),(0.40157,0.48031),(0.40945,0.48031),(0.41732,0.48031),(0.4252,0.48031),(0.43307,0.48031),(0.44094,0.48031),(0.44882,0.48031),(0.45669,0.48031),(0.46457,0.48031),(0.47244,0.48031),(0.48031,0.48031),(0.48819,0.48031),(0.49606,0.48031),(0.50394,0.48031),(0.51181,0.48031),(0.51969,0.48031),(0.52756,0.48031),(0.53543,0.48031),(0.54331,0.48031),(0.55118,0.48031),(0.55906,0.48031),(0.56693,0.48031),(0.5748,0.48031),(0.58268,0.48031),(0.59055,0.48031),(0.59843,0.48031),(0.6063,0.48031),(0.61417,0.48031),(0.62205,0.48031),(0.62992,0.48031),(0.6378,0.48031),(0.64567,0.48031),(0.65354,0.48031),(0.66142,0.48031),(0.66929,0.48031),(0.67717,0.48031),(0.68504,0.48031),(0.69291,0.48031),(0.70079,0.48031),(0.70866,0.48031),(0.71654,0.48031),(0.72441,0.48031),(0.73228,0.48031),(0.74016,0.48031),(0.74803,0.48031),(0.75591,0.48031),(0.76378,0.48031),(0.77165,0.48031),(0.77953,0.48031),(0.7874,0.48031),(0.79528,0.48031),(0.80315,0.48031),(0.81102,0.48031),(0.8189,0.48031),(0.82677,0.48031),(0.83465,0.48031),(0.84252,0.48031),(0.85039,0.48031),(0.85827,0.48031),(0.86614,0.48031),(0.87402,0.48031),(0.88189,0.48031),(0.88976,0.48031),(0.89764,0.48031),(0.90551,0.48031),(0.91339,0.48031),(0.92126,0.48031),(0.92913,0.48031),(0.93701,0.48031),(0.94488,0.48031),(0.95276,0.48031),(0.96063,0.48031),(0.9685,0.48031),(0.97638,0.48031),(0.98425,0.48031),(0.99213,0.48031),(0.99609,0.48031),(0.00391,0.48819),(0.00787,0.48819),(0.01575,0.48819),(0.02362,0.48819),(0.0315,0.48819),(0.03937,0.48819),(0.04724,0.48819),(0.05512,0.48819),(0.06299,0.48819),(0.07087,0.48819),(0.07874,0.48819),(0.08661,0.48819),(0.09449,0.48819),(0.10236,0.48819),(0.11024,0.48819),(0.11811,0.48819),(0.12598,0.48819),(0.13386,0.48819),(0.14173,0.48819),(0.14961,0.48819),(0.15748,0.48819),(0.16535,0.48819),(0.17323,0.48819),(0.1811,0.48819),(0.18898,0.48819),(0.19685,0.48819),(0.20472,0.48819),(0.2126,0.48819),(0.22047,0.48819),(0.22835,0.48819),(0.23622,0.48819),(0.24409,0.48819),(0.25197,0.48819),(0.25984,0.48819),(0.26772,0.48819),(0.27559,0.48819),(0.28346,0.48819),(0.29134,0.48819),(0.29921,0.48819),(0.30709,0.48819),(0.31496,0.48819),(0.32283,0.48819),(0.33071,0.48819),(0.33858,0.48819),(0.34646,0.48819),(0.35433,0.48819),(0.3622,0.48819),(0.37008,0.48819),(0.37795,0.48819),(0.38583,0.48819),(0.3937,0.48819),(0.40157,0.48819),(0.40945,0.48819),(0.41732,0.48819),(0.4252,0.48819),(0.43307,0.48819),(0.44094,0.48819),(0.44882,0.48819),(0.45669,0.48819),(0.46457,0.48819),(0.47244,0.48819),(0.48031,0.48819),(0.48819,0.48819),(0.49606,0.48819),(0.50394,0.48819),(0.51181,0.48819),(0.51969,0.48819),(0.52756,0.48819),(0.53543,0.48819),(0.54331,0.48819),(0.55118,0.48819),(0.55906,0.48819),(0.56693,0.48819),(0.5748,0.48819),(0.58268,0.48819),(0.59055,0.48819),(0.59843,0.48819),(0.6063,0.48819),(0.61417,0.48819),(0.62205,0.48819),(0.62992,0.48819),(0.6378,0.48819),(0.64567,0.48819),(0.65354,0.48819),(0.66142,0.48819),(0.66929,0.48819),(0.67717,0.48819),(0.68504,0.48819),(0.69291,0.48819),(0.70079,0.48819),(0.70866,0.48819),(0.71654,0.48819),(0.72441,0.48819),(0.73228,0.48819),(0.74016,0.48819),(0.74803,0.48819),(0.75591,0.48819),(0.76378,0.48819),(0.77165,0.48819),(0.77953,0.48819),(0.7874,0.48819),(0.79528,0.48819),(0.80315,0.48819),(0.81102,0.48819),(0.8189,0.48819),(0.82677,0.48819),(0.83465,0.48819),(0.84252,0.48819),(0.85039,0.48819),(0.85827,0.48819),(0.86614,0.48819),(0.87402,0.48819),(0.88189,0.48819),(0.88976,0.48819),(0.89764,0.48819),(0.90551,0.48819),(0.91339,0.48819),(0.92126,0.48819),(0.92913,0.48819),(0.93701,0.48819),(0.94488,0.48819),(0.95276,0.48819),(0.96063,0.48819),(0.9685,0.48819),(0.97638,0.48819),(0.98425,0.48819),(0.99213,0.48819),(0.99609,0.48819),(0.00391,0.49606),(0.00787,0.49606),(0.01575,0.49606),(0.02362,0.49606),(0.0315,0.49606),(0.03937,0.49606),(0.04724,0.49606),(0.05512,0.49606),(0.06299,0.49606),(0.07087,0.49606),(0.07874,0.49606),(0.08661,0.49606),(0.09449,0.49606),(0.10236,0.49606),(0.11024,0.49606),(0.11811,0.49606),(0.12598,0.49606),(0.13386,0.49606),(0.14173,0.49606),(0.14961,0.49606),(0.15748,0.49606),(0.16535,0.49606),(0.17323,0.49606),(0.1811,0.49606),(0.18898,0.49606),(0.19685,0.49606),(0.20472,0.49606),(0.2126,0.49606),(0.22047,0.49606),(0.22835,0.49606),(0.23622,0.49606),(0.24409,0.49606),(0.25197,0.49606),(0.25984,0.49606),(0.26772,0.49606),(0.27559,0.49606),(0.28346,0.49606),(0.29134,0.49606),(0.29921,0.49606),(0.30709,0.49606),(0.31496,0.49606),(0.32283,0.49606),(0.33071,0.49606),(0.33858,0.49606),(0.34646,0.49606),(0.35433,0.49606),(0.3622,0.49606),(0.37008,0.49606),(0.37795,0.49606),(0.38583,0.49606),(0.3937,0.49606),(0.40157,0.49606),(0.40945,0.49606),(0.41732,0.49606),(0.4252,0.49606),(0.43307,0.49606),(0.44094,0.49606),(0.44882,0.49606),(0.45669,0.49606),(0.46457,0.49606),(0.47244,0.49606),(0.48031,0.49606),(0.48819,0.49606),(0.49606,0.49606),(0.50394,0.49606),(0.51181,0.49606),(0.51969,0.49606),(0.52756,0.49606),(0.53543,0.49606),(0.54331,0.49606),(0.55118,0.49606),(0.55906,0.49606),(0.56693,0.49606),(0.5748,0.49606),(0.58268,0.49606),(0.59055,0.49606),(0.59843,0.49606),(0.6063,0.49606),(0.61417,0.49606),(0.62205,0.49606),(0.62992,0.49606),(0.6378,0.49606),(0.64567,0.49606),(0.65354,0.49606),(0.66142,0.49606),(0.66929,0.49606),(0.67717,0.49606),(0.68504,0.49606),(0.69291,0.49606),(0.70079,0.49606),(0.70866,0.49606),(0.71654,0.49606),(0.72441,0.49606),(0.73228,0.49606),(0.74016,0.49606),(0.74803,0.49606),(0.75591,0.49606),(0.76378,0.49606),(0.77165,0.49606),(0.77953,0.49606),(0.7874,0.49606),(0.79528,0.49606),(0.80315,0.49606),(0.81102,0.49606),(0.8189,0.49606),(0.82677,0.49606),(0.83465,0.49606),(0.84252,0.49606),(0.85039,0.49606),(0.85827,0.49606),(0.86614,0.49606),(0.87402,0.49606),(0.88189,0.49606),(0.88976,0.49606),(0.89764,0.49606),(0.90551,0.49606),(0.91339,0.49606),(0.92126,0.49606),(0.92913,0.49606),(0.93701,0.49606),(0.94488,0.49606),(0.95276,0.49606),(0.96063,0.49606),(0.9685,0.49606),(0.97638,0.49606),(0.98425,0.49606),(0.99213,0.49606),(0.99609,0.49606),(0.00391,0.50394),(0.00787,0.50394),(0.01575,0.50394),(0.02362,0.50394),(0.0315,0.50394),(0.03937,0.50394),(0.04724,0.50394),(0.05512,0.50394),(0.06299,0.50394),(0.07087,0.50394),(0.07874,0.50394),(0.08661,0.50394),(0.09449,0.50394),(0.10236,0.50394),(0.11024,0.50394),(0.11811,0.50394),(0.12598,0.50394),(0.13386,0.50394),(0.14173,0.50394),(0.14961,0.50394),(0.15748,0.50394),(0.16535,0.50394),(0.17323,0.50394),(0.1811,0.50394),(0.18898,0.50394),(0.19685,0.50394),(0.20472,0.50394),(0.2126,0.50394),(0.22047,0.50394),(0.22835,0.50394),(0.23622,0.50394),(0.24409,0.50394),(0.25197,0.50394),(0.25984,0.50394),(0.26772,0.50394),(0.27559,0.50394),(0.28346,0.50394),(0.29134,0.50394),(0.29921,0.50394),(0.30709,0.50394),(0.31496,0.50394),(0.32283,0.50394),(0.33071,0.50394),(0.33858,0.50394),(0.34646,0.50394),(0.35433,0.50394),(0.3622,0.50394),(0.37008,0.50394),(0.37795,0.50394),(0.38583,0.50394),(0.3937,0.50394),(0.40157,0.50394),(0.40945,0.50394),(0.41732,0.50394),(0.4252,0.50394),(0.43307,0.50394),(0.44094,0.50394),(0.44882,0.50394),(0.45669,0.50394),(0.46457,0.50394),(0.47244,0.50394),(0.48031,0.50394),(0.48819,0.50394),(0.49606,0.50394),(0.50394,0.50394),(0.51181,0.50394),(0.51969,0.50394),(0.52756,0.50394),(0.53543,0.50394),(0.54331,0.50394),(0.55118,0.50394),(0.55906,0.50394),(0.56693,0.50394),(0.5748,0.50394),(0.58268,0.50394),(0.59055,0.50394),(0.59843,0.50394),(0.6063,0.50394),(0.61417,0.50394),(0.62205,0.50394),(0.62992,0.50394),(0.6378,0.50394),(0.64567,0.50394),(0.65354,0.50394),(0.66142,0.50394),(0.66929,0.50394),(0.67717,0.50394),(0.68504,0.50394),(0.69291,0.50394),(0.70079,0.50394),(0.70866,0.50394),(0.71654,0.50394),(0.72441,0.50394),(0.73228,0.50394),(0.74016,0.50394),(0.74803,0.50394),(0.75591,0.50394),(0.76378,0.50394),(0.77165,0.50394),(0.77953,0.50394),(0.7874,0.50394),(0.79528,0.50394),(0.80315,0.50394),(0.81102,0.50394),(0.8189,0.50394),(0.82677,0.50394),(0.83465,0.50394),(0.84252,0.50394),(0.85039,0.50394),(0.85827,0.50394),(0.86614,0.50394),(0.87402,0.50394),(0.88189,0.50394),(0.88976,0.50394),(0.89764,0.50394),(0.90551,0.50394),(0.91339,0.50394),(0.92126,0.50394),(0.92913,0.50394),(0.93701,0.50394),(0.94488,0.50394),(0.95276,0.50394),(0.96063,0.50394),(0.9685,0.50394),(0.97638,0.50394),(0.98425,0.50394),(0.99213,0.50394),(0.99609,0.50394),(0.00391,0.51181),(0.00787,0.51181),(0.01575,0.51181),(0.02362,0.51181),(0.0315,0.51181),(0.03937,0.51181),(0.04724,0.51181),(0.05512,0.51181),(0.06299,0.51181),(0.07087,0.51181),(0.07874,0.51181),(0.08661,0.51181),(0.09449,0.51181),(0.10236,0.51181),(0.11024,0.51181),(0.11811,0.51181),(0.12598,0.51181),(0.13386,0.51181),(0.14173,0.51181),(0.14961,0.51181),(0.15748,0.51181),(0.16535,0.51181),(0.17323,0.51181),(0.1811,0.51181),(0.18898,0.51181),(0.19685,0.51181),(0.20472,0.51181),(0.2126,0.51181),(0.22047,0.51181),(0.22835,0.51181),(0.23622,0.51181),(0.24409,0.51181),(0.25197,0.51181),(0.25984,0.51181),(0.26772,0.51181),(0.27559,0.51181),(0.28346,0.51181),(0.29134,0.51181),(0.29921,0.51181),(0.30709,0.51181),(0.31496,0.51181),(0.32283,0.51181),(0.33071,0.51181),(0.33858,0.51181),(0.34646,0.51181),(0.35433,0.51181),(0.3622,0.51181),(0.37008,0.51181),(0.37795,0.51181),(0.38583,0.51181),(0.3937,0.51181),(0.40157,0.51181),(0.40945,0.51181),(0.41732,0.51181),(0.4252,0.51181),(0.43307,0.51181),(0.44094,0.51181),(0.44882,0.51181),(0.45669,0.51181),(0.46457,0.51181),(0.47244,0.51181),(0.48031,0.51181),(0.48819,0.51181),(0.49606,0.51181),(0.50394,0.51181),(0.51181,0.51181),(0.51969,0.51181),(0.52756,0.51181),(0.53543,0.51181),(0.54331,0.51181),(0.55118,0.51181),(0.55906,0.51181),(0.56693,0.51181),(0.5748,0.51181),(0.58268,0.51181),(0.59055,0.51181),(0.59843,0.51181),(0.6063,0.51181),(0.61417,0.51181),(0.62205,0.51181),(0.62992,0.51181),(0.6378,0.51181),(0.64567,0.51181),(0.65354,0.51181),(0.66142,0.51181),(0.66929,0.51181),(0.67717,0.51181),(0.68504,0.51181),(0.69291,0.51181),(0.70079,0.51181),(0.70866,0.51181),(0.71654,0.51181),(0.72441,0.51181),(0.73228,0.51181),(0.74016,0.51181),(0.74803,0.51181),(0.75591,0.51181),(0.76378,0.51181),(0.77165,0.51181),(0.77953,0.51181),(0.7874,0.51181),(0.79528,0.51181),(0.80315,0.51181),(0.81102,0.51181),(0.8189,0.51181),(0.82677,0.51181),(0.83465,0.51181),(0.84252,0.51181),(0.85039,0.51181),(0.85827,0.51181),(0.86614,0.51181),(0.87402,0.51181),(0.88189,0.51181),(0.88976,0.51181),(0.89764,0.51181),(0.90551,0.51181),(0.91339,0.51181),(0.92126,0.51181),(0.92913,0.51181),(0.93701,0.51181),(0.94488,0.51181),(0.95276,0.51181),(0.96063,0.51181),(0.9685,0.51181),(0.97638,0.51181),(0.98425,0.51181),(0.99213,0.51181),(0.99609,0.51181),(0.00391,0.51969),(0.00787,0.51969),(0.01575,0.51969),(0.02362,0.51969),(0.0315,0.51969),(0.03937,0.51969),(0.04724,0.51969),(0.05512,0.51969),(0.06299,0.51969),(0.07087,0.51969),(0.07874,0.51969),(0.08661,0.51969),(0.09449,0.51969),(0.10236,0.51969),(0.11024,0.51969),(0.11811,0.51969),(0.12598,0.51969),(0.13386,0.51969),(0.14173,0.51969),(0.14961,0.51969),(0.15748,0.51969),(0.16535,0.51969),(0.17323,0.51969),(0.1811,0.51969),(0.18898,0.51969),(0.19685,0.51969),(0.20472,0.51969),(0.2126,0.51969),(0.22047,0.51969),(0.22835,0.51969),(0.23622,0.51969),(0.24409,0.51969),(0.25197,0.51969),(0.25984,0.51969),(0.26772,0.51969),(0.27559,0.51969),(0.28346,0.51969),(0.29134,0.51969),(0.29921,0.51969),(0.30709,0.51969),(0.31496,0.51969),(0.32283,0.51969),(0.33071,0.51969),(0.33858,0.51969),(0.34646,0.51969),(0.35433,0.51969),(0.3622,0.51969),(0.37008,0.51969),(0.37795,0.51969),(0.38583,0.51969),(0.3937,0.51969),(0.40157,0.51969),(0.40945,0.51969),(0.41732,0.51969),(0.4252,0.51969),(0.43307,0.51969),(0.44094,0.51969),(0.44882,0.51969),(0.45669,0.51969),(0.46457,0.51969),(0.47244,0.51969),(0.48031,0.51969),(0.48819,0.51969),(0.49606,0.51969),(0.50394,0.51969),(0.51181,0.51969),(0.51969,0.51969),(0.52756,0.51969),(0.53543,0.51969),(0.54331,0.51969),(0.55118,0.51969),(0.55906,0.51969),(0.56693,0.51969),(0.5748,0.51969),(0.58268,0.51969),(0.59055,0.51969),(0.59843,0.51969),(0.6063,0.51969),(0.61417,0.51969),(0.62205,0.51969),(0.62992,0.51969),(0.6378,0.51969),(0.64567,0.51969),(0.65354,0.51969),(0.66142,0.51969),(0.66929,0.51969),(0.67717,0.51969),(0.68504,0.51969),(0.69291,0.51969),(0.70079,0.51969),(0.70866,0.51969),(0.71654,0.51969),(0.72441,0.51969),(0.73228,0.51969),(0.74016,0.51969),(0.74803,0.51969),(0.75591,0.51969),(0.76378,0.51969),(0.77165,0.51969),(0.77953,0.51969),(0.7874,0.51969),(0.79528,0.51969),(0.80315,0.51969),(0.81102,0.51969),(0.8189,0.51969),(0.82677,0.51969),(0.83465,0.51969),(0.84252,0.51969),(0.85039,0.51969),(0.85827,0.51969),(0.86614,0.51969),(0.87402,0.51969),(0.88189,0.51969),(0.88976,0.51969),(0.89764,0.51969),(0.90551,0.51969),(0.91339,0.51969),(0.92126,0.51969),(0.92913,0.51969),(0.93701,0.51969),(0.94488,0.51969),(0.95276,0.51969),(0.96063,0.51969),(0.9685,0.51969),(0.97638,0.51969),(0.98425,0.51969),(0.99213,0.51969),(0.99609,0.51969),(0.00391,0.52756),(0.00787,0.52756),(0.01575,0.52756),(0.02362,0.52756),(0.0315,0.52756),(0.03937,0.52756),(0.04724,0.52756),(0.05512,0.52756),(0.06299,0.52756),(0.07087,0.52756),(0.07874,0.52756),(0.08661,0.52756),(0.09449,0.52756),(0.10236,0.52756),(0.11024,0.52756),(0.11811,0.52756),(0.12598,0.52756),(0.13386,0.52756),(0.14173,0.52756),(0.14961,0.52756),(0.15748,0.52756),(0.16535,0.52756),(0.17323,0.52756),(0.1811,0.52756),(0.18898,0.52756),(0.19685,0.52756),(0.20472,0.52756),(0.2126,0.52756),(0.22047,0.52756),(0.22835,0.52756),(0.23622,0.52756),(0.24409,0.52756),(0.25197,0.52756),(0.25984,0.52756),(0.26772,0.52756),(0.27559,0.52756),(0.28346,0.52756),(0.29134,0.52756),(0.29921,0.52756),(0.30709,0.52756),(0.31496,0.52756),(0.32283,0.52756),(0.33071,0.52756),(0.33858,0.52756),(0.34646,0.52756),(0.35433,0.52756),(0.3622,0.52756),(0.37008,0.52756),(0.37795,0.52756),(0.38583,0.52756),(0.3937,0.52756),(0.40157,0.52756),(0.40945,0.52756),(0.41732,0.52756),(0.4252,0.52756),(0.43307,0.52756),(0.44094,0.52756),(0.44882,0.52756),(0.45669,0.52756),(0.46457,0.52756),(0.47244,0.52756),(0.48031,0.52756),(0.48819,0.52756),(0.49606,0.52756),(0.50394,0.52756),(0.51181,0.52756),(0.51969,0.52756),(0.52756,0.52756),(0.53543,0.52756),(0.54331,0.52756),(0.55118,0.52756),(0.55906,0.52756),(0.56693,0.52756),(0.5748,0.52756),(0.58268,0.52756),(0.59055,0.52756),(0.59843,0.52756),(0.6063,0.52756),(0.61417,0.52756),(0.62205,0.52756),(0.62992,0.52756),(0.6378,0.52756),(0.64567,0.52756),(0.65354,0.52756),(0.66142,0.52756),(0.66929,0.52756),(0.67717,0.52756),(0.68504,0.52756),(0.69291,0.52756),(0.70079,0.52756),(0.70866,0.52756),(0.71654,0.52756),(0.72441,0.52756),(0.73228,0.52756),(0.74016,0.52756),(0.74803,0.52756),(0.75591,0.52756),(0.76378,0.52756),(0.77165,0.52756),(0.77953,0.52756),(0.7874,0.52756),(0.79528,0.52756),(0.80315,0.52756),(0.81102,0.52756),(0.8189,0.52756),(0.82677,0.52756),(0.83465,0.52756),(0.84252,0.52756),(0.85039,0.52756),(0.85827,0.52756),(0.86614,0.52756),(0.87402,0.52756),(0.88189,0.52756),(0.88976,0.52756),(0.89764,0.52756),(0.90551,0.52756),(0.91339,0.52756),(0.92126,0.52756),(0.92913,0.52756),(0.93701,0.52756),(0.94488,0.52756),(0.95276,0.52756),(0.96063,0.52756),(0.9685,0.52756),(0.97638,0.52756),(0.98425,0.52756),(0.99213,0.52756),(0.99609,0.52756),(0.00391,0.53543),(0.00787,0.53543),(0.01575,0.53543),(0.02362,0.53543),(0.0315,0.53543),(0.03937,0.53543),(0.04724,0.53543),(0.05512,0.53543),(0.06299,0.53543),(0.07087,0.53543),(0.07874,0.53543),(0.08661,0.53543),(0.09449,0.53543),(0.10236,0.53543),(0.11024,0.53543),(0.11811,0.53543),(0.12598,0.53543),(0.13386,0.53543),(0.14173,0.53543),(0.14961,0.53543),(0.15748,0.53543),(0.16535,0.53543),(0.17323,0.53543),(0.1811,0.53543),(0.18898,0.53543),(0.19685,0.53543),(0.20472,0.53543),(0.2126,0.53543),(0.22047,0.53543),(0.22835,0.53543),(0.23622,0.53543),(0.24409,0.53543),(0.25197,0.53543),(0.25984,0.53543),(0.26772,0.53543),(0.27559,0.53543),(0.28346,0.53543),(0.29134,0.53543),(0.29921,0.53543),(0.30709,0.53543),(0.31496,0.53543),(0.32283,0.53543),(0.33071,0.53543),(0.33858,0.53543),(0.34646,0.53543),(0.35433,0.53543),(0.3622,0.53543),(0.37008,0.53543),(0.37795,0.53543),(0.38583,0.53543),(0.3937,0.53543),(0.40157,0.53543),(0.40945,0.53543),(0.41732,0.53543),(0.4252,0.53543),(0.43307,0.53543),(0.44094,0.53543),(0.44882,0.53543),(0.45669,0.53543),(0.46457,0.53543),(0.47244,0.53543),(0.48031,0.53543),(0.48819,0.53543),(0.49606,0.53543),(0.50394,0.53543),(0.51181,0.53543),(0.51969,0.53543),(0.52756,0.53543),(0.53543,0.53543),(0.54331,0.53543),(0.55118,0.53543),(0.55906,0.53543),(0.56693,0.53543),(0.5748,0.53543),(0.58268,0.53543),(0.59055,0.53543),(0.59843,0.53543),(0.6063,0.53543),(0.61417,0.53543),(0.62205,0.53543),(0.62992,0.53543),(0.6378,0.53543),(0.64567,0.53543),(0.65354,0.53543),(0.66142,0.53543),(0.66929,0.53543),(0.67717,0.53543),(0.68504,0.53543),(0.69291,0.53543),(0.70079,0.53543),(0.70866,0.53543),(0.71654,0.53543),(0.72441,0.53543),(0.73228,0.53543),(0.74016,0.53543),(0.74803,0.53543),(0.75591,0.53543),(0.76378,0.53543),(0.77165,0.53543),(0.77953,0.53543),(0.7874,0.53543),(0.79528,0.53543),(0.80315,0.53543),(0.81102,0.53543),(0.8189,0.53543),(0.82677,0.53543),(0.83465,0.53543),(0.84252,0.53543),(0.85039,0.53543),(0.85827,0.53543),(0.86614,0.53543),(0.87402,0.53543),(0.88189,0.53543),(0.88976,0.53543),(0.89764,0.53543),(0.90551,0.53543),(0.91339,0.53543),(0.92126,0.53543),(0.92913,0.53543),(0.93701,0.53543),(0.94488,0.53543),(0.95276,0.53543),(0.96063,0.53543),(0.9685,0.53543),(0.97638,0.53543),(0.98425,0.53543),(0.99213,0.53543),(0.99609,0.53543),(0.00391,0.54331),(0.00787,0.54331),(0.01575,0.54331),(0.02362,0.54331),(0.0315,0.54331),(0.03937,0.54331),(0.04724,0.54331),(0.05512,0.54331),(0.06299,0.54331),(0.07087,0.54331),(0.07874,0.54331),(0.08661,0.54331),(0.09449,0.54331),(0.10236,0.54331),(0.11024,0.54331),(0.11811,0.54331),(0.12598,0.54331),(0.13386,0.54331),(0.14173,0.54331),(0.14961,0.54331),(0.15748,0.54331),(0.16535,0.54331),(0.17323,0.54331),(0.1811,0.54331),(0.18898,0.54331),(0.19685,0.54331),(0.20472,0.54331),(0.2126,0.54331),(0.22047,0.54331),(0.22835,0.54331),(0.23622,0.54331),(0.24409,0.54331),(0.25197,0.54331),(0.25984,0.54331),(0.26772,0.54331),(0.27559,0.54331),(0.28346,0.54331),(0.29134,0.54331),(0.29921,0.54331),(0.30709,0.54331),(0.31496,0.54331),(0.32283,0.54331),(0.33071,0.54331),(0.33858,0.54331),(0.34646,0.54331),(0.35433,0.54331),(0.3622,0.54331),(0.37008,0.54331),(0.37795,0.54331),(0.38583,0.54331),(0.3937,0.54331),(0.40157,0.54331),(0.40945,0.54331),(0.41732,0.54331),(0.4252,0.54331),(0.43307,0.54331),(0.44094,0.54331),(0.44882,0.54331),(0.45669,0.54331),(0.46457,0.54331),(0.47244,0.54331),(0.48031,0.54331),(0.48819,0.54331),(0.49606,0.54331),(0.50394,0.54331),(0.51181,0.54331),(0.51969,0.54331),(0.52756,0.54331),(0.53543,0.54331),(0.54331,0.54331),(0.55118,0.54331),(0.55906,0.54331),(0.56693,0.54331),(0.5748,0.54331),(0.58268,0.54331),(0.59055,0.54331),(0.59843,0.54331),(0.6063,0.54331),(0.61417,0.54331),(0.62205,0.54331),(0.62992,0.54331),(0.6378,0.54331),(0.64567,0.54331),(0.65354,0.54331),(0.66142,0.54331),(0.66929,0.54331),(0.67717,0.54331),(0.68504,0.54331),(0.69291,0.54331),(0.70079,0.54331),(0.70866,0.54331),(0.71654,0.54331),(0.72441,0.54331),(0.73228,0.54331),(0.74016,0.54331),(0.74803,0.54331),(0.75591,0.54331),(0.76378,0.54331),(0.77165,0.54331),(0.77953,0.54331),(0.7874,0.54331),(0.79528,0.54331),(0.80315,0.54331),(0.81102,0.54331),(0.8189,0.54331),(0.82677,0.54331),(0.83465,0.54331),(0.84252,0.54331),(0.85039,0.54331),(0.85827,0.54331),(0.86614,0.54331),(0.87402,0.54331),(0.88189,0.54331),(0.88976,0.54331),(0.89764,0.54331),(0.90551,0.54331),(0.91339,0.54331),(0.92126,0.54331),(0.92913,0.54331),(0.93701,0.54331),(0.94488,0.54331),(0.95276,0.54331),(0.96063,0.54331),(0.9685,0.54331),(0.97638,0.54331),(0.98425,0.54331),(0.99213,0.54331),(0.99609,0.54331),(0.00391,0.55118),(0.00787,0.55118),(0.01575,0.55118),(0.02362,0.55118),(0.0315,0.55118),(0.03937,0.55118),(0.04724,0.55118),(0.05512,0.55118),(0.06299,0.55118),(0.07087,0.55118),(0.07874,0.55118),(0.08661,0.55118),(0.09449,0.55118),(0.10236,0.55118),(0.11024,0.55118),(0.11811,0.55118),(0.12598,0.55118),(0.13386,0.55118),(0.14173,0.55118),(0.14961,0.55118),(0.15748,0.55118),(0.16535,0.55118),(0.17323,0.55118),(0.1811,0.55118),(0.18898,0.55118),(0.19685,0.55118),(0.20472,0.55118),(0.2126,0.55118),(0.22047,0.55118),(0.22835,0.55118),(0.23622,0.55118),(0.24409,0.55118),(0.25197,0.55118),(0.25984,0.55118),(0.26772,0.55118),(0.27559,0.55118),(0.28346,0.55118),(0.29134,0.55118),(0.29921,0.55118),(0.30709,0.55118),(0.31496,0.55118),(0.32283,0.55118),(0.33071,0.55118),(0.33858,0.55118),(0.34646,0.55118),(0.35433,0.55118),(0.3622,0.55118),(0.37008,0.55118),(0.37795,0.55118),(0.38583,0.55118),(0.3937,0.55118),(0.40157,0.55118),(0.40945,0.55118),(0.41732,0.55118),(0.4252,0.55118),(0.43307,0.55118),(0.44094,0.55118),(0.44882,0.55118),(0.45669,0.55118),(0.46457,0.55118),(0.47244,0.55118),(0.48031,0.55118),(0.48819,0.55118),(0.49606,0.55118),(0.50394,0.55118),(0.51181,0.55118),(0.51969,0.55118),(0.52756,0.55118),(0.53543,0.55118),(0.54331,0.55118),(0.55118,0.55118),(0.55906,0.55118),(0.56693,0.55118),(0.5748,0.55118),(0.58268,0.55118),(0.59055,0.55118),(0.59843,0.55118),(0.6063,0.55118),(0.61417,0.55118),(0.62205,0.55118),(0.62992,0.55118),(0.6378,0.55118),(0.64567,0.55118),(0.65354,0.55118),(0.66142,0.55118),(0.66929,0.55118),(0.67717,0.55118),(0.68504,0.55118),(0.69291,0.55118),(0.70079,0.55118),(0.70866,0.55118),(0.71654,0.55118),(0.72441,0.55118),(0.73228,0.55118),(0.74016,0.55118),(0.74803,0.55118),(0.75591,0.55118),(0.76378,0.55118),(0.77165,0.55118),(0.77953,0.55118),(0.7874,0.55118),(0.79528,0.55118),(0.80315,0.55118),(0.81102,0.55118),(0.8189,0.55118),(0.82677,0.55118),(0.83465,0.55118),(0.84252,0.55118),(0.85039,0.55118),(0.85827,0.55118),(0.86614,0.55118),(0.87402,0.55118),(0.88189,0.55118),(0.88976,0.55118),(0.89764,0.55118),(0.90551,0.55118),(0.91339,0.55118),(0.92126,0.55118),(0.92913,0.55118),(0.93701,0.55118),(0.94488,0.55118),(0.95276,0.55118),(0.96063,0.55118),(0.9685,0.55118),(0.97638,0.55118),(0.98425,0.55118),(0.99213,0.55118),(0.99609,0.55118),(0.00391,0.55906),(0.00787,0.55906),(0.01575,0.55906),(0.02362,0.55906),(0.0315,0.55906),(0.03937,0.55906),(0.04724,0.55906),(0.05512,0.55906),(0.06299,0.55906),(0.07087,0.55906),(0.07874,0.55906),(0.08661,0.55906),(0.09449,0.55906),(0.10236,0.55906),(0.11024,0.55906),(0.11811,0.55906),(0.12598,0.55906),(0.13386,0.55906),(0.14173,0.55906),(0.14961,0.55906),(0.15748,0.55906),(0.16535,0.55906),(0.17323,0.55906),(0.1811,0.55906),(0.18898,0.55906),(0.19685,0.55906),(0.20472,0.55906),(0.2126,0.55906),(0.22047,0.55906),(0.22835,0.55906),(0.23622,0.55906),(0.24409,0.55906),(0.25197,0.55906),(0.25984,0.55906),(0.26772,0.55906),(0.27559,0.55906),(0.28346,0.55906),(0.29134,0.55906),(0.29921,0.55906),(0.30709,0.55906),(0.31496,0.55906),(0.32283,0.55906),(0.33071,0.55906),(0.33858,0.55906),(0.34646,0.55906),(0.35433,0.55906),(0.3622,0.55906),(0.37008,0.55906),(0.37795,0.55906),(0.38583,0.55906),(0.3937,0.55906),(0.40157,0.55906),(0.40945,0.55906),(0.41732,0.55906),(0.4252,0.55906),(0.43307,0.55906),(0.44094,0.55906),(0.44882,0.55906),(0.45669,0.55906),(0.46457,0.55906),(0.47244,0.55906),(0.48031,0.55906),(0.48819,0.55906),(0.49606,0.55906),(0.50394,0.55906),(0.51181,0.55906),(0.51969,0.55906),(0.52756,0.55906),(0.53543,0.55906),(0.54331,0.55906),(0.55118,0.55906),(0.55906,0.55906),(0.56693,0.55906),(0.5748,0.55906),(0.58268,0.55906),(0.59055,0.55906),(0.59843,0.55906),(0.6063,0.55906),(0.61417,0.55906),(0.62205,0.55906),(0.62992,0.55906),(0.6378,0.55906),(0.64567,0.55906),(0.65354,0.55906),(0.66142,0.55906),(0.66929,0.55906),(0.67717,0.55906),(0.68504,0.55906),(0.69291,0.55906),(0.70079,0.55906),(0.70866,0.55906),(0.71654,0.55906),(0.72441,0.55906),(0.73228,0.55906),(0.74016,0.55906),(0.74803,0.55906),(0.75591,0.55906),(0.76378,0.55906),(0.77165,0.55906),(0.77953,0.55906),(0.7874,0.55906),(0.79528,0.55906),(0.80315,0.55906),(0.81102,0.55906),(0.8189,0.55906),(0.82677,0.55906),(0.83465,0.55906),(0.84252,0.55906),(0.85039,0.55906),(0.85827,0.55906),(0.86614,0.55906),(0.87402,0.55906),(0.88189,0.55906),(0.88976,0.55906),(0.89764,0.55906),(0.90551,0.55906),(0.91339,0.55906),(0.92126,0.55906),(0.92913,0.55906),(0.93701,0.55906),(0.94488,0.55906),(0.95276,0.55906),(0.96063,0.55906),(0.9685,0.55906),(0.97638,0.55906),(0.98425,0.55906),(0.99213,0.55906),(0.99609,0.55906),(0.00391,0.56693),(0.00787,0.56693),(0.01575,0.56693),(0.02362,0.56693),(0.0315,0.56693),(0.03937,0.56693),(0.04724,0.56693),(0.05512,0.56693),(0.06299,0.56693),(0.07087,0.56693),(0.07874,0.56693),(0.08661,0.56693),(0.09449,0.56693),(0.10236,0.56693),(0.11024,0.56693),(0.11811,0.56693),(0.12598,0.56693),(0.13386,0.56693),(0.14173,0.56693),(0.14961,0.56693),(0.15748,0.56693),(0.16535,0.56693),(0.17323,0.56693),(0.1811,0.56693),(0.18898,0.56693),(0.19685,0.56693),(0.20472,0.56693),(0.2126,0.56693),(0.22047,0.56693),(0.22835,0.56693),(0.23622,0.56693),(0.24409,0.56693),(0.25197,0.56693),(0.25984,0.56693),(0.26772,0.56693),(0.27559,0.56693),(0.28346,0.56693),(0.29134,0.56693),(0.29921,0.56693),(0.30709,0.56693),(0.31496,0.56693),(0.32283,0.56693),(0.33071,0.56693),(0.33858,0.56693),(0.34646,0.56693),(0.35433,0.56693),(0.3622,0.56693),(0.37008,0.56693),(0.37795,0.56693),(0.38583,0.56693),(0.3937,0.56693),(0.40157,0.56693),(0.40945,0.56693),(0.41732,0.56693),(0.4252,0.56693),(0.43307,0.56693),(0.44094,0.56693),(0.44882,0.56693),(0.45669,0.56693),(0.46457,0.56693),(0.47244,0.56693),(0.48031,0.56693),(0.48819,0.56693),(0.49606,0.56693),(0.50394,0.56693),(0.51181,0.56693),(0.51969,0.56693),(0.52756,0.56693),(0.53543,0.56693),(0.54331,0.56693),(0.55118,0.56693),(0.55906,0.56693),(0.56693,0.56693),(0.5748,0.56693),(0.58268,0.56693),(0.59055,0.56693),(0.59843,0.56693),(0.6063,0.56693),(0.61417,0.56693),(0.62205,0.56693),(0.62992,0.56693),(0.6378,0.56693),(0.64567,0.56693),(0.65354,0.56693),(0.66142,0.56693),(0.66929,0.56693),(0.67717,0.56693),(0.68504,0.56693),(0.69291,0.56693),(0.70079,0.56693),(0.70866,0.56693),(0.71654,0.56693),(0.72441,0.56693),(0.73228,0.56693),(0.74016,0.56693),(0.74803,0.56693),(0.75591,0.56693),(0.76378,0.56693),(0.77165,0.56693),(0.77953,0.56693),(0.7874,0.56693),(0.79528,0.56693),(0.80315,0.56693),(0.81102,0.56693),(0.8189,0.56693),(0.82677,0.56693),(0.83465,0.56693),(0.84252,0.56693),(0.85039,0.56693),(0.85827,0.56693),(0.86614,0.56693),(0.87402,0.56693),(0.88189,0.56693),(0.88976,0.56693),(0.89764,0.56693),(0.90551,0.56693),(0.91339,0.56693),(0.92126,0.56693),(0.92913,0.56693),(0.93701,0.56693),(0.94488,0.56693),(0.95276,0.56693),(0.96063,0.56693),(0.9685,0.56693),(0.97638,0.56693),(0.98425,0.56693),(0.99213,0.56693),(0.99609,0.56693),(0.00391,0.5748),(0.00787,0.5748),(0.01575,0.5748),(0.02362,0.5748),(0.0315,0.5748),(0.03937,0.5748),(0.04724,0.5748),(0.05512,0.5748),(0.06299,0.5748),(0.07087,0.5748),(0.07874,0.5748),(0.08661,0.5748),(0.09449,0.5748),(0.10236,0.5748),(0.11024,0.5748),(0.11811,0.5748),(0.12598,0.5748),(0.13386,0.5748),(0.14173,0.5748),(0.14961,0.5748),(0.15748,0.5748),(0.16535,0.5748),(0.17323,0.5748),(0.1811,0.5748),(0.18898,0.5748),(0.19685,0.5748),(0.20472,0.5748),(0.2126,0.5748),(0.22047,0.5748),(0.22835,0.5748),(0.23622,0.5748),(0.24409,0.5748),(0.25197,0.5748),(0.25984,0.5748),(0.26772,0.5748),(0.27559,0.5748),(0.28346,0.5748),(0.29134,0.5748),(0.29921,0.5748),(0.30709,0.5748),(0.31496,0.5748),(0.32283,0.5748),(0.33071,0.5748),(0.33858,0.5748),(0.34646,0.5748),(0.35433,0.5748),(0.3622,0.5748),(0.37008,0.5748),(0.37795,0.5748),(0.38583,0.5748),(0.3937,0.5748),(0.40157,0.5748),(0.40945,0.5748),(0.41732,0.5748),(0.4252,0.5748),(0.43307,0.5748),(0.44094,0.5748),(0.44882,0.5748),(0.45669,0.5748),(0.46457,0.5748),(0.47244,0.5748),(0.48031,0.5748),(0.48819,0.5748),(0.49606,0.5748),(0.50394,0.5748),(0.51181,0.5748),(0.51969,0.5748),(0.52756,0.5748),(0.53543,0.5748),(0.54331,0.5748),(0.55118,0.5748),(0.55906,0.5748),(0.56693,0.5748),(0.5748,0.5748),(0.58268,0.5748),(0.59055,0.5748),(0.59843,0.5748),(0.6063,0.5748),(0.61417,0.5748),(0.62205,0.5748),(0.62992,0.5748),(0.6378,0.5748),(0.64567,0.5748),(0.65354,0.5748),(0.66142,0.5748),(0.66929,0.5748),(0.67717,0.5748),(0.68504,0.5748),(0.69291,0.5748),(0.70079,0.5748),(0.70866,0.5748),(0.71654,0.5748),(0.72441,0.5748),(0.73228,0.5748),(0.74016,0.5748),(0.74803,0.5748),(0.75591,0.5748),(0.76378,0.5748),(0.77165,0.5748),(0.77953,0.5748),(0.7874,0.5748),(0.79528,0.5748),(0.80315,0.5748),(0.81102,0.5748),(0.8189,0.5748),(0.82677,0.5748),(0.83465,0.5748),(0.84252,0.5748),(0.85039,0.5748),(0.85827,0.5748),(0.86614,0.5748),(0.87402,0.5748),(0.88189,0.5748),(0.88976,0.5748),(0.89764,0.5748),(0.90551,0.5748),(0.91339,0.5748),(0.92126,0.5748),(0.92913,0.5748),(0.93701,0.5748),(0.94488,0.5748),(0.95276,0.5748),(0.96063,0.5748),(0.9685,0.5748),(0.97638,0.5748),(0.98425,0.5748),(0.99213,0.5748),(0.99609,0.5748),(0.00391,0.58268),(0.00787,0.58268),(0.01575,0.58268),(0.02362,0.58268),(0.0315,0.58268),(0.03937,0.58268),(0.04724,0.58268),(0.05512,0.58268),(0.06299,0.58268),(0.07087,0.58268),(0.07874,0.58268),(0.08661,0.58268),(0.09449,0.58268),(0.10236,0.58268),(0.11024,0.58268),(0.11811,0.58268),(0.12598,0.58268),(0.13386,0.58268),(0.14173,0.58268),(0.14961,0.58268),(0.15748,0.58268),(0.16535,0.58268),(0.17323,0.58268),(0.1811,0.58268),(0.18898,0.58268),(0.19685,0.58268),(0.20472,0.58268),(0.2126,0.58268),(0.22047,0.58268),(0.22835,0.58268),(0.23622,0.58268),(0.24409,0.58268),(0.25197,0.58268),(0.25984,0.58268),(0.26772,0.58268),(0.27559,0.58268),(0.28346,0.58268),(0.29134,0.58268),(0.29921,0.58268),(0.30709,0.58268),(0.31496,0.58268),(0.32283,0.58268),(0.33071,0.58268),(0.33858,0.58268),(0.34646,0.58268),(0.35433,0.58268),(0.3622,0.58268),(0.37008,0.58268),(0.37795,0.58268),(0.38583,0.58268),(0.3937,0.58268),(0.40157,0.58268),(0.40945,0.58268),(0.41732,0.58268),(0.4252,0.58268),(0.43307,0.58268),(0.44094,0.58268),(0.44882,0.58268),(0.45669,0.58268),(0.46457,0.58268),(0.47244,0.58268),(0.48031,0.58268),(0.48819,0.58268),(0.49606,0.58268),(0.50394,0.58268),(0.51181,0.58268),(0.51969,0.58268),(0.52756,0.58268),(0.53543,0.58268),(0.54331,0.58268),(0.55118,0.58268),(0.55906,0.58268),(0.56693,0.58268),(0.5748,0.58268),(0.58268,0.58268),(0.59055,0.58268),(0.59843,0.58268),(0.6063,0.58268),(0.61417,0.58268),(0.62205,0.58268),(0.62992,0.58268),(0.6378,0.58268),(0.64567,0.58268),(0.65354,0.58268),(0.66142,0.58268),(0.66929,0.58268),(0.67717,0.58268),(0.68504,0.58268),(0.69291,0.58268),(0.70079,0.58268),(0.70866,0.58268),(0.71654,0.58268),(0.72441,0.58268),(0.73228,0.58268),(0.74016,0.58268),(0.74803,0.58268),(0.75591,0.58268),(0.76378,0.58268),(0.77165,0.58268),(0.77953,0.58268),(0.7874,0.58268),(0.79528,0.58268),(0.80315,0.58268),(0.81102,0.58268),(0.8189,0.58268),(0.82677,0.58268),(0.83465,0.58268),(0.84252,0.58268),(0.85039,0.58268),(0.85827,0.58268),(0.86614,0.58268),(0.87402,0.58268),(0.88189,0.58268),(0.88976,0.58268),(0.89764,0.58268),(0.90551,0.58268),(0.91339,0.58268),(0.92126,0.58268),(0.92913,0.58268),(0.93701,0.58268),(0.94488,0.58268),(0.95276,0.58268),(0.96063,0.58268),(0.9685,0.58268),(0.97638,0.58268),(0.98425,0.58268),(0.99213,0.58268),(0.99609,0.58268),(0.00391,0.59055),(0.00787,0.59055),(0.01575,0.59055),(0.02362,0.59055),(0.0315,0.59055),(0.03937,0.59055),(0.04724,0.59055),(0.05512,0.59055),(0.06299,0.59055),(0.07087,0.59055),(0.07874,0.59055),(0.08661,0.59055),(0.09449,0.59055),(0.10236,0.59055),(0.11024,0.59055),(0.11811,0.59055),(0.12598,0.59055),(0.13386,0.59055),(0.14173,0.59055),(0.14961,0.59055),(0.15748,0.59055),(0.16535,0.59055),(0.17323,0.59055),(0.1811,0.59055),(0.18898,0.59055),(0.19685,0.59055),(0.20472,0.59055),(0.2126,0.59055),(0.22047,0.59055),(0.22835,0.59055),(0.23622,0.59055),(0.24409,0.59055),(0.25197,0.59055),(0.25984,0.59055),(0.26772,0.59055),(0.27559,0.59055),(0.28346,0.59055),(0.29134,0.59055),(0.29921,0.59055),(0.30709,0.59055),(0.31496,0.59055),(0.32283,0.59055),(0.33071,0.59055),(0.33858,0.59055),(0.34646,0.59055),(0.35433,0.59055),(0.3622,0.59055),(0.37008,0.59055),(0.37795,0.59055),(0.38583,0.59055),(0.3937,0.59055),(0.40157,0.59055),(0.40945,0.59055),(0.41732,0.59055),(0.4252,0.59055),(0.43307,0.59055),(0.44094,0.59055),(0.44882,0.59055),(0.45669,0.59055),(0.46457,0.59055),(0.47244,0.59055),(0.48031,0.59055),(0.48819,0.59055),(0.49606,0.59055),(0.50394,0.59055),(0.51181,0.59055),(0.51969,0.59055),(0.52756,0.59055),(0.53543,0.59055),(0.54331,0.59055),(0.55118,0.59055),(0.55906,0.59055),(0.56693,0.59055),(0.5748,0.59055),(0.58268,0.59055),(0.59055,0.59055),(0.59843,0.59055),(0.6063,0.59055),(0.61417,0.59055),(0.62205,0.59055),(0.62992,0.59055),(0.6378,0.59055),(0.64567,0.59055),(0.65354,0.59055),(0.66142,0.59055),(0.66929,0.59055),(0.67717,0.59055),(0.68504,0.59055),(0.69291,0.59055),(0.70079,0.59055),(0.70866,0.59055),(0.71654,0.59055),(0.72441,0.59055),(0.73228,0.59055),(0.74016,0.59055),(0.74803,0.59055),(0.75591,0.59055),(0.76378,0.59055),(0.77165,0.59055),(0.77953,0.59055),(0.7874,0.59055),(0.79528,0.59055),(0.80315,0.59055),(0.81102,0.59055),(0.8189,0.59055),(0.82677,0.59055),(0.83465,0.59055),(0.84252,0.59055),(0.85039,0.59055),(0.85827,0.59055),(0.86614,0.59055),(0.87402,0.59055),(0.88189,0.59055),(0.88976,0.59055),(0.89764,0.59055),(0.90551,0.59055),(0.91339,0.59055),(0.92126,0.59055),(0.92913,0.59055),(0.93701,0.59055),(0.94488,0.59055),(0.95276,0.59055),(0.96063,0.59055),(0.9685,0.59055),(0.97638,0.59055),(0.98425,0.59055),(0.99213,0.59055),(0.99609,0.59055),(0.00391,0.59843),(0.00787,0.59843),(0.01575,0.59843),(0.02362,0.59843),(0.0315,0.59843),(0.03937,0.59843),(0.04724,0.59843),(0.05512,0.59843),(0.06299,0.59843),(0.07087,0.59843),(0.07874,0.59843),(0.08661,0.59843),(0.09449,0.59843),(0.10236,0.59843),(0.11024,0.59843),(0.11811,0.59843),(0.12598,0.59843),(0.13386,0.59843),(0.14173,0.59843),(0.14961,0.59843),(0.15748,0.59843),(0.16535,0.59843),(0.17323,0.59843),(0.1811,0.59843),(0.18898,0.59843),(0.19685,0.59843),(0.20472,0.59843),(0.2126,0.59843),(0.22047,0.59843),(0.22835,0.59843),(0.23622,0.59843),(0.24409,0.59843),(0.25197,0.59843),(0.25984,0.59843),(0.26772,0.59843),(0.27559,0.59843),(0.28346,0.59843),(0.29134,0.59843),(0.29921,0.59843),(0.30709,0.59843),(0.31496,0.59843),(0.32283,0.59843),(0.33071,0.59843),(0.33858,0.59843),(0.34646,0.59843),(0.35433,0.59843),(0.3622,0.59843),(0.37008,0.59843),(0.37795,0.59843),(0.38583,0.59843),(0.3937,0.59843),(0.40157,0.59843),(0.40945,0.59843),(0.41732,0.59843),(0.4252,0.59843),(0.43307,0.59843),(0.44094,0.59843),(0.44882,0.59843),(0.45669,0.59843),(0.46457,0.59843),(0.47244,0.59843),(0.48031,0.59843),(0.48819,0.59843),(0.49606,0.59843),(0.50394,0.59843),(0.51181,0.59843),(0.51969,0.59843),(0.52756,0.59843),(0.53543,0.59843),(0.54331,0.59843),(0.55118,0.59843),(0.55906,0.59843),(0.56693,0.59843),(0.5748,0.59843),(0.58268,0.59843),(0.59055,0.59843),(0.59843,0.59843),(0.6063,0.59843),(0.61417,0.59843),(0.62205,0.59843),(0.62992,0.59843),(0.6378,0.59843),(0.64567,0.59843),(0.65354,0.59843),(0.66142,0.59843),(0.66929,0.59843),(0.67717,0.59843),(0.68504,0.59843),(0.69291,0.59843),(0.70079,0.59843),(0.70866,0.59843),(0.71654,0.59843),(0.72441,0.59843),(0.73228,0.59843),(0.74016,0.59843),(0.74803,0.59843),(0.75591,0.59843),(0.76378,0.59843),(0.77165,0.59843),(0.77953,0.59843),(0.7874,0.59843),(0.79528,0.59843),(0.80315,0.59843),(0.81102,0.59843),(0.8189,0.59843),(0.82677,0.59843),(0.83465,0.59843),(0.84252,0.59843),(0.85039,0.59843),(0.85827,0.59843),(0.86614,0.59843),(0.87402,0.59843),(0.88189,0.59843),(0.88976,0.59843),(0.89764,0.59843),(0.90551,0.59843),(0.91339,0.59843),(0.92126,0.59843),(0.92913,0.59843),(0.93701,0.59843),(0.94488,0.59843),(0.95276,0.59843),(0.96063,0.59843),(0.9685,0.59843),(0.97638,0.59843),(0.98425,0.59843),(0.99213,0.59843),(0.99609,0.59843),(0.00391,0.6063),(0.00787,0.6063),(0.01575,0.6063),(0.02362,0.6063),(0.0315,0.6063),(0.03937,0.6063),(0.04724,0.6063),(0.05512,0.6063),(0.06299,0.6063),(0.07087,0.6063),(0.07874,0.6063),(0.08661,0.6063),(0.09449,0.6063),(0.10236,0.6063),(0.11024,0.6063),(0.11811,0.6063),(0.12598,0.6063),(0.13386,0.6063),(0.14173,0.6063),(0.14961,0.6063),(0.15748,0.6063),(0.16535,0.6063),(0.17323,0.6063),(0.1811,0.6063),(0.18898,0.6063),(0.19685,0.6063),(0.20472,0.6063),(0.2126,0.6063),(0.22047,0.6063),(0.22835,0.6063),(0.23622,0.6063),(0.24409,0.6063),(0.25197,0.6063),(0.25984,0.6063),(0.26772,0.6063),(0.27559,0.6063),(0.28346,0.6063),(0.29134,0.6063),(0.29921,0.6063),(0.30709,0.6063),(0.31496,0.6063),(0.32283,0.6063),(0.33071,0.6063),(0.33858,0.6063),(0.34646,0.6063),(0.35433,0.6063),(0.3622,0.6063),(0.37008,0.6063),(0.37795,0.6063),(0.38583,0.6063),(0.3937,0.6063),(0.40157,0.6063),(0.40945,0.6063),(0.41732,0.6063),(0.4252,0.6063),(0.43307,0.6063),(0.44094,0.6063),(0.44882,0.6063),(0.45669,0.6063),(0.46457,0.6063),(0.47244,0.6063),(0.48031,0.6063),(0.48819,0.6063),(0.49606,0.6063),(0.50394,0.6063),(0.51181,0.6063),(0.51969,0.6063),(0.52756,0.6063),(0.53543,0.6063),(0.54331,0.6063),(0.55118,0.6063),(0.55906,0.6063),(0.56693,0.6063),(0.5748,0.6063),(0.58268,0.6063),(0.59055,0.6063),(0.59843,0.6063),(0.6063,0.6063),(0.61417,0.6063),(0.62205,0.6063),(0.62992,0.6063),(0.6378,0.6063),(0.64567,0.6063),(0.65354,0.6063),(0.66142,0.6063),(0.66929,0.6063),(0.67717,0.6063),(0.68504,0.6063),(0.69291,0.6063),(0.70079,0.6063),(0.70866,0.6063),(0.71654,0.6063),(0.72441,0.6063),(0.73228,0.6063),(0.74016,0.6063),(0.74803,0.6063),(0.75591,0.6063),(0.76378,0.6063),(0.77165,0.6063),(0.77953,0.6063),(0.7874,0.6063),(0.79528,0.6063),(0.80315,0.6063),(0.81102,0.6063),(0.8189,0.6063),(0.82677,0.6063),(0.83465,0.6063),(0.84252,0.6063),(0.85039,0.6063),(0.85827,0.6063),(0.86614,0.6063),(0.87402,0.6063),(0.88189,0.6063),(0.88976,0.6063),(0.89764,0.6063),(0.90551,0.6063),(0.91339,0.6063),(0.92126,0.6063),(0.92913,0.6063),(0.93701,0.6063),(0.94488,0.6063),(0.95276,0.6063),(0.96063,0.6063),(0.9685,0.6063),(0.97638,0.6063),(0.98425,0.6063),(0.99213,0.6063),(0.99609,0.6063),(0.00391,0.61417),(0.00787,0.61417),(0.01575,0.61417),(0.02362,0.61417),(0.0315,0.61417),(0.03937,0.61417),(0.04724,0.61417),(0.05512,0.61417),(0.06299,0.61417),(0.07087,0.61417),(0.07874,0.61417),(0.08661,0.61417),(0.09449,0.61417),(0.10236,0.61417),(0.11024,0.61417),(0.11811,0.61417),(0.12598,0.61417),(0.13386,0.61417),(0.14173,0.61417),(0.14961,0.61417),(0.15748,0.61417),(0.16535,0.61417),(0.17323,0.61417),(0.1811,0.61417),(0.18898,0.61417),(0.19685,0.61417),(0.20472,0.61417),(0.2126,0.61417),(0.22047,0.61417),(0.22835,0.61417),(0.23622,0.61417),(0.24409,0.61417),(0.25197,0.61417),(0.25984,0.61417),(0.26772,0.61417),(0.27559,0.61417),(0.28346,0.61417),(0.29134,0.61417),(0.29921,0.61417),(0.30709,0.61417),(0.31496,0.61417),(0.32283,0.61417),(0.33071,0.61417),(0.33858,0.61417),(0.34646,0.61417),(0.35433,0.61417),(0.3622,0.61417),(0.37008,0.61417),(0.37795,0.61417),(0.38583,0.61417),(0.3937,0.61417),(0.40157,0.61417),(0.40945,0.61417),(0.41732,0.61417),(0.4252,0.61417),(0.43307,0.61417),(0.44094,0.61417),(0.44882,0.61417),(0.45669,0.61417),(0.46457,0.61417),(0.47244,0.61417),(0.48031,0.61417),(0.48819,0.61417),(0.49606,0.61417),(0.50394,0.61417),(0.51181,0.61417),(0.51969,0.61417),(0.52756,0.61417),(0.53543,0.61417),(0.54331,0.61417),(0.55118,0.61417),(0.55906,0.61417),(0.56693,0.61417),(0.5748,0.61417),(0.58268,0.61417),(0.59055,0.61417),(0.59843,0.61417),(0.6063,0.61417),(0.61417,0.61417),(0.62205,0.61417),(0.62992,0.61417),(0.6378,0.61417),(0.64567,0.61417),(0.65354,0.61417),(0.66142,0.61417),(0.66929,0.61417),(0.67717,0.61417),(0.68504,0.61417),(0.69291,0.61417),(0.70079,0.61417),(0.70866,0.61417),(0.71654,0.61417),(0.72441,0.61417),(0.73228,0.61417),(0.74016,0.61417),(0.74803,0.61417),(0.75591,0.61417),(0.76378,0.61417),(0.77165,0.61417),(0.77953,0.61417),(0.7874,0.61417),(0.79528,0.61417),(0.80315,0.61417),(0.81102,0.61417),(0.8189,0.61417),(0.82677,0.61417),(0.83465,0.61417),(0.84252,0.61417),(0.85039,0.61417),(0.85827,0.61417),(0.86614,0.61417),(0.87402,0.61417),(0.88189,0.61417),(0.88976,0.61417),(0.89764,0.61417),(0.90551,0.61417),(0.91339,0.61417),(0.92126,0.61417),(0.92913,0.61417),(0.93701,0.61417),(0.94488,0.61417),(0.95276,0.61417),(0.96063,0.61417),(0.9685,0.61417),(0.97638,0.61417),(0.98425,0.61417),(0.99213,0.61417),(0.99609,0.61417),(0.00391,0.62205),(0.00787,0.62205),(0.01575,0.62205),(0.02362,0.62205),(0.0315,0.62205),(0.03937,0.62205),(0.04724,0.62205),(0.05512,0.62205),(0.06299,0.62205),(0.07087,0.62205),(0.07874,0.62205),(0.08661,0.62205),(0.09449,0.62205),(0.10236,0.62205),(0.11024,0.62205),(0.11811,0.62205),(0.12598,0.62205),(0.13386,0.62205),(0.14173,0.62205),(0.14961,0.62205),(0.15748,0.62205),(0.16535,0.62205),(0.17323,0.62205),(0.1811,0.62205),(0.18898,0.62205),(0.19685,0.62205),(0.20472,0.62205),(0.2126,0.62205),(0.22047,0.62205),(0.22835,0.62205),(0.23622,0.62205),(0.24409,0.62205),(0.25197,0.62205),(0.25984,0.62205),(0.26772,0.62205),(0.27559,0.62205),(0.28346,0.62205),(0.29134,0.62205),(0.29921,0.62205),(0.30709,0.62205),(0.31496,0.62205),(0.32283,0.62205),(0.33071,0.62205),(0.33858,0.62205),(0.34646,0.62205),(0.35433,0.62205),(0.3622,0.62205),(0.37008,0.62205),(0.37795,0.62205),(0.38583,0.62205),(0.3937,0.62205),(0.40157,0.62205),(0.40945,0.62205),(0.41732,0.62205),(0.4252,0.62205),(0.43307,0.62205),(0.44094,0.62205),(0.44882,0.62205),(0.45669,0.62205),(0.46457,0.62205),(0.47244,0.62205),(0.48031,0.62205),(0.48819,0.62205),(0.49606,0.62205),(0.50394,0.62205),(0.51181,0.62205),(0.51969,0.62205),(0.52756,0.62205),(0.53543,0.62205),(0.54331,0.62205),(0.55118,0.62205),(0.55906,0.62205),(0.56693,0.62205),(0.5748,0.62205),(0.58268,0.62205),(0.59055,0.62205),(0.59843,0.62205),(0.6063,0.62205),(0.61417,0.62205),(0.62205,0.62205),(0.62992,0.62205),(0.6378,0.62205),(0.64567,0.62205),(0.65354,0.62205),(0.66142,0.62205),(0.66929,0.62205),(0.67717,0.62205),(0.68504,0.62205),(0.69291,0.62205),(0.70079,0.62205),(0.70866,0.62205),(0.71654,0.62205),(0.72441,0.62205),(0.73228,0.62205),(0.74016,0.62205),(0.74803,0.62205),(0.75591,0.62205),(0.76378,0.62205),(0.77165,0.62205),(0.77953,0.62205),(0.7874,0.62205),(0.79528,0.62205),(0.80315,0.62205),(0.81102,0.62205),(0.8189,0.62205),(0.82677,0.62205),(0.83465,0.62205),(0.84252,0.62205),(0.85039,0.62205),(0.85827,0.62205),(0.86614,0.62205),(0.87402,0.62205),(0.88189,0.62205),(0.88976,0.62205),(0.89764,0.62205),(0.90551,0.62205),(0.91339,0.62205),(0.92126,0.62205),(0.92913,0.62205),(0.93701,0.62205),(0.94488,0.62205),(0.95276,0.62205),(0.96063,0.62205),(0.9685,0.62205),(0.97638,0.62205),(0.98425,0.62205),(0.99213,0.62205),(0.99609,0.62205),(0.00391,0.62992),(0.00787,0.62992),(0.01575,0.62992),(0.02362,0.62992),(0.0315,0.62992),(0.03937,0.62992),(0.04724,0.62992),(0.05512,0.62992),(0.06299,0.62992),(0.07087,0.62992),(0.07874,0.62992),(0.08661,0.62992),(0.09449,0.62992),(0.10236,0.62992),(0.11024,0.62992),(0.11811,0.62992),(0.12598,0.62992),(0.13386,0.62992),(0.14173,0.62992),(0.14961,0.62992),(0.15748,0.62992),(0.16535,0.62992),(0.17323,0.62992),(0.1811,0.62992),(0.18898,0.62992),(0.19685,0.62992),(0.20472,0.62992),(0.2126,0.62992),(0.22047,0.62992),(0.22835,0.62992),(0.23622,0.62992),(0.24409,0.62992),(0.25197,0.62992),(0.25984,0.62992),(0.26772,0.62992),(0.27559,0.62992),(0.28346,0.62992),(0.29134,0.62992),(0.29921,0.62992),(0.30709,0.62992),(0.31496,0.62992),(0.32283,0.62992),(0.33071,0.62992),(0.33858,0.62992),(0.34646,0.62992),(0.35433,0.62992),(0.3622,0.62992),(0.37008,0.62992),(0.37795,0.62992),(0.38583,0.62992),(0.3937,0.62992),(0.40157,0.62992),(0.40945,0.62992),(0.41732,0.62992),(0.4252,0.62992),(0.43307,0.62992),(0.44094,0.62992),(0.44882,0.62992),(0.45669,0.62992),(0.46457,0.62992),(0.47244,0.62992),(0.48031,0.62992),(0.48819,0.62992),(0.49606,0.62992),(0.50394,0.62992),(0.51181,0.62992),(0.51969,0.62992),(0.52756,0.62992),(0.53543,0.62992),(0.54331,0.62992),(0.55118,0.62992),(0.55906,0.62992),(0.56693,0.62992),(0.5748,0.62992),(0.58268,0.62992),(0.59055,0.62992),(0.59843,0.62992),(0.6063,0.62992),(0.61417,0.62992),(0.62205,0.62992),(0.62992,0.62992),(0.6378,0.62992),(0.64567,0.62992),(0.65354,0.62992),(0.66142,0.62992),(0.66929,0.62992),(0.67717,0.62992),(0.68504,0.62992),(0.69291,0.62992),(0.70079,0.62992),(0.70866,0.62992),(0.71654,0.62992),(0.72441,0.62992),(0.73228,0.62992),(0.74016,0.62992),(0.74803,0.62992),(0.75591,0.62992),(0.76378,0.62992),(0.77165,0.62992),(0.77953,0.62992),(0.7874,0.62992),(0.79528,0.62992),(0.80315,0.62992),(0.81102,0.62992),(0.8189,0.62992),(0.82677,0.62992),(0.83465,0.62992),(0.84252,0.62992),(0.85039,0.62992),(0.85827,0.62992),(0.86614,0.62992),(0.87402,0.62992),(0.88189,0.62992),(0.88976,0.62992),(0.89764,0.62992),(0.90551,0.62992),(0.91339,0.62992),(0.92126,0.62992),(0.92913,0.62992),(0.93701,0.62992),(0.94488,0.62992),(0.95276,0.62992),(0.96063,0.62992),(0.9685,0.62992),(0.97638,0.62992),(0.98425,0.62992),(0.99213,0.62992),(0.99609,0.62992),(0.00391,0.6378),(0.00787,0.6378),(0.01575,0.6378),(0.02362,0.6378),(0.0315,0.6378),(0.03937,0.6378),(0.04724,0.6378),(0.05512,0.6378),(0.06299,0.6378),(0.07087,0.6378),(0.07874,0.6378),(0.08661,0.6378),(0.09449,0.6378),(0.10236,0.6378),(0.11024,0.6378),(0.11811,0.6378),(0.12598,0.6378),(0.13386,0.6378),(0.14173,0.6378),(0.14961,0.6378),(0.15748,0.6378),(0.16535,0.6378),(0.17323,0.6378),(0.1811,0.6378),(0.18898,0.6378),(0.19685,0.6378),(0.20472,0.6378),(0.2126,0.6378),(0.22047,0.6378),(0.22835,0.6378),(0.23622,0.6378),(0.24409,0.6378),(0.25197,0.6378),(0.25984,0.6378),(0.26772,0.6378),(0.27559,0.6378),(0.28346,0.6378),(0.29134,0.6378),(0.29921,0.6378),(0.30709,0.6378),(0.31496,0.6378),(0.32283,0.6378),(0.33071,0.6378),(0.33858,0.6378),(0.34646,0.6378),(0.35433,0.6378),(0.3622,0.6378),(0.37008,0.6378),(0.37795,0.6378),(0.38583,0.6378),(0.3937,0.6378),(0.40157,0.6378),(0.40945,0.6378),(0.41732,0.6378),(0.4252,0.6378),(0.43307,0.6378),(0.44094,0.6378),(0.44882,0.6378),(0.45669,0.6378),(0.46457,0.6378),(0.47244,0.6378),(0.48031,0.6378),(0.48819,0.6378),(0.49606,0.6378),(0.50394,0.6378),(0.51181,0.6378),(0.51969,0.6378),(0.52756,0.6378),(0.53543,0.6378),(0.54331,0.6378),(0.55118,0.6378),(0.55906,0.6378),(0.56693,0.6378),(0.5748,0.6378),(0.58268,0.6378),(0.59055,0.6378),(0.59843,0.6378),(0.6063,0.6378),(0.61417,0.6378),(0.62205,0.6378),(0.62992,0.6378),(0.6378,0.6378),(0.64567,0.6378),(0.65354,0.6378),(0.66142,0.6378),(0.66929,0.6378),(0.67717,0.6378),(0.68504,0.6378),(0.69291,0.6378),(0.70079,0.6378),(0.70866,0.6378),(0.71654,0.6378),(0.72441,0.6378),(0.73228,0.6378),(0.74016,0.6378),(0.74803,0.6378),(0.75591,0.6378),(0.76378,0.6378),(0.77165,0.6378),(0.77953,0.6378),(0.7874,0.6378),(0.79528,0.6378),(0.80315,0.6378),(0.81102,0.6378),(0.8189,0.6378),(0.82677,0.6378),(0.83465,0.6378),(0.84252,0.6378),(0.85039,0.6378),(0.85827,0.6378),(0.86614,0.6378),(0.87402,0.6378),(0.88189,0.6378),(0.88976,0.6378),(0.89764,0.6378),(0.90551,0.6378),(0.91339,0.6378),(0.92126,0.6378),(0.92913,0.6378),(0.93701,0.6378),(0.94488,0.6378),(0.95276,0.6378),(0.96063,0.6378),(0.9685,0.6378),(0.97638,0.6378),(0.98425,0.6378),(0.99213,0.6378),(0.99609,0.6378),(0.00391,0.64567),(0.00787,0.64567),(0.01575,0.64567),(0.02362,0.64567),(0.0315,0.64567),(0.03937,0.64567),(0.04724,0.64567),(0.05512,0.64567),(0.06299,0.64567),(0.07087,0.64567),(0.07874,0.64567),(0.08661,0.64567),(0.09449,0.64567),(0.10236,0.64567),(0.11024,0.64567),(0.11811,0.64567),(0.12598,0.64567),(0.13386,0.64567),(0.14173,0.64567),(0.14961,0.64567),(0.15748,0.64567),(0.16535,0.64567),(0.17323,0.64567),(0.1811,0.64567),(0.18898,0.64567),(0.19685,0.64567),(0.20472,0.64567),(0.2126,0.64567),(0.22047,0.64567),(0.22835,0.64567),(0.23622,0.64567),(0.24409,0.64567),(0.25197,0.64567),(0.25984,0.64567),(0.26772,0.64567),(0.27559,0.64567),(0.28346,0.64567),(0.29134,0.64567),(0.29921,0.64567),(0.30709,0.64567),(0.31496,0.64567),(0.32283,0.64567),(0.33071,0.64567),(0.33858,0.64567),(0.34646,0.64567),(0.35433,0.64567),(0.3622,0.64567),(0.37008,0.64567),(0.37795,0.64567),(0.38583,0.64567),(0.3937,0.64567),(0.40157,0.64567),(0.40945,0.64567),(0.41732,0.64567),(0.4252,0.64567),(0.43307,0.64567),(0.44094,0.64567),(0.44882,0.64567),(0.45669,0.64567),(0.46457,0.64567),(0.47244,0.64567),(0.48031,0.64567),(0.48819,0.64567),(0.49606,0.64567),(0.50394,0.64567),(0.51181,0.64567),(0.51969,0.64567),(0.52756,0.64567),(0.53543,0.64567),(0.54331,0.64567),(0.55118,0.64567),(0.55906,0.64567),(0.56693,0.64567),(0.5748,0.64567),(0.58268,0.64567),(0.59055,0.64567),(0.59843,0.64567),(0.6063,0.64567),(0.61417,0.64567),(0.62205,0.64567),(0.62992,0.64567),(0.6378,0.64567),(0.64567,0.64567),(0.65354,0.64567),(0.66142,0.64567),(0.66929,0.64567),(0.67717,0.64567),(0.68504,0.64567),(0.69291,0.64567),(0.70079,0.64567),(0.70866,0.64567),(0.71654,0.64567),(0.72441,0.64567),(0.73228,0.64567),(0.74016,0.64567),(0.74803,0.64567),(0.75591,0.64567),(0.76378,0.64567),(0.77165,0.64567),(0.77953,0.64567),(0.7874,0.64567),(0.79528,0.64567),(0.80315,0.64567),(0.81102,0.64567),(0.8189,0.64567),(0.82677,0.64567),(0.83465,0.64567),(0.84252,0.64567),(0.85039,0.64567),(0.85827,0.64567),(0.86614,0.64567),(0.87402,0.64567),(0.88189,0.64567),(0.88976,0.64567),(0.89764,0.64567),(0.90551,0.64567),(0.91339,0.64567),(0.92126,0.64567),(0.92913,0.64567),(0.93701,0.64567),(0.94488,0.64567),(0.95276,0.64567),(0.96063,0.64567),(0.9685,0.64567),(0.97638,0.64567),(0.98425,0.64567),(0.99213,0.64567),(0.99609,0.64567),(0.00391,0.65354),(0.00787,0.65354),(0.01575,0.65354),(0.02362,0.65354),(0.0315,0.65354),(0.03937,0.65354),(0.04724,0.65354),(0.05512,0.65354),(0.06299,0.65354),(0.07087,0.65354),(0.07874,0.65354),(0.08661,0.65354),(0.09449,0.65354),(0.10236,0.65354),(0.11024,0.65354),(0.11811,0.65354),(0.12598,0.65354),(0.13386,0.65354),(0.14173,0.65354),(0.14961,0.65354),(0.15748,0.65354),(0.16535,0.65354),(0.17323,0.65354),(0.1811,0.65354),(0.18898,0.65354),(0.19685,0.65354),(0.20472,0.65354),(0.2126,0.65354),(0.22047,0.65354),(0.22835,0.65354),(0.23622,0.65354),(0.24409,0.65354),(0.25197,0.65354),(0.25984,0.65354),(0.26772,0.65354),(0.27559,0.65354),(0.28346,0.65354),(0.29134,0.65354),(0.29921,0.65354),(0.30709,0.65354),(0.31496,0.65354),(0.32283,0.65354),(0.33071,0.65354),(0.33858,0.65354),(0.34646,0.65354),(0.35433,0.65354),(0.3622,0.65354),(0.37008,0.65354),(0.37795,0.65354),(0.38583,0.65354),(0.3937,0.65354),(0.40157,0.65354),(0.40945,0.65354),(0.41732,0.65354),(0.4252,0.65354),(0.43307,0.65354),(0.44094,0.65354),(0.44882,0.65354),(0.45669,0.65354),(0.46457,0.65354),(0.47244,0.65354),(0.48031,0.65354),(0.48819,0.65354),(0.49606,0.65354),(0.50394,0.65354),(0.51181,0.65354),(0.51969,0.65354),(0.52756,0.65354),(0.53543,0.65354),(0.54331,0.65354),(0.55118,0.65354),(0.55906,0.65354),(0.56693,0.65354),(0.5748,0.65354),(0.58268,0.65354),(0.59055,0.65354),(0.59843,0.65354),(0.6063,0.65354),(0.61417,0.65354),(0.62205,0.65354),(0.62992,0.65354),(0.6378,0.65354),(0.64567,0.65354),(0.65354,0.65354),(0.66142,0.65354),(0.66929,0.65354),(0.67717,0.65354),(0.68504,0.65354),(0.69291,0.65354),(0.70079,0.65354),(0.70866,0.65354),(0.71654,0.65354),(0.72441,0.65354),(0.73228,0.65354),(0.74016,0.65354),(0.74803,0.65354),(0.75591,0.65354),(0.76378,0.65354),(0.77165,0.65354),(0.77953,0.65354),(0.7874,0.65354),(0.79528,0.65354),(0.80315,0.65354),(0.81102,0.65354),(0.8189,0.65354),(0.82677,0.65354),(0.83465,0.65354),(0.84252,0.65354),(0.85039,0.65354),(0.85827,0.65354),(0.86614,0.65354),(0.87402,0.65354),(0.88189,0.65354),(0.88976,0.65354),(0.89764,0.65354),(0.90551,0.65354),(0.91339,0.65354),(0.92126,0.65354),(0.92913,0.65354),(0.93701,0.65354),(0.94488,0.65354),(0.95276,0.65354),(0.96063,0.65354),(0.9685,0.65354),(0.97638,0.65354),(0.98425,0.65354),(0.99213,0.65354),(0.99609,0.65354),(0.00391,0.66142),(0.00787,0.66142),(0.01575,0.66142),(0.02362,0.66142),(0.0315,0.66142),(0.03937,0.66142),(0.04724,0.66142),(0.05512,0.66142),(0.06299,0.66142),(0.07087,0.66142),(0.07874,0.66142),(0.08661,0.66142),(0.09449,0.66142),(0.10236,0.66142),(0.11024,0.66142),(0.11811,0.66142),(0.12598,0.66142),(0.13386,0.66142),(0.14173,0.66142),(0.14961,0.66142),(0.15748,0.66142),(0.16535,0.66142),(0.17323,0.66142),(0.1811,0.66142),(0.18898,0.66142),(0.19685,0.66142),(0.20472,0.66142),(0.2126,0.66142),(0.22047,0.66142),(0.22835,0.66142),(0.23622,0.66142),(0.24409,0.66142),(0.25197,0.66142),(0.25984,0.66142),(0.26772,0.66142),(0.27559,0.66142),(0.28346,0.66142),(0.29134,0.66142),(0.29921,0.66142),(0.30709,0.66142),(0.31496,0.66142),(0.32283,0.66142),(0.33071,0.66142),(0.33858,0.66142),(0.34646,0.66142),(0.35433,0.66142),(0.3622,0.66142),(0.37008,0.66142),(0.37795,0.66142),(0.38583,0.66142),(0.3937,0.66142),(0.40157,0.66142),(0.40945,0.66142),(0.41732,0.66142),(0.4252,0.66142),(0.43307,0.66142),(0.44094,0.66142),(0.44882,0.66142),(0.45669,0.66142),(0.46457,0.66142),(0.47244,0.66142),(0.48031,0.66142),(0.48819,0.66142),(0.49606,0.66142),(0.50394,0.66142),(0.51181,0.66142),(0.51969,0.66142),(0.52756,0.66142),(0.53543,0.66142),(0.54331,0.66142),(0.55118,0.66142),(0.55906,0.66142),(0.56693,0.66142),(0.5748,0.66142),(0.58268,0.66142),(0.59055,0.66142),(0.59843,0.66142),(0.6063,0.66142),(0.61417,0.66142),(0.62205,0.66142),(0.62992,0.66142),(0.6378,0.66142),(0.64567,0.66142),(0.65354,0.66142),(0.66142,0.66142),(0.66929,0.66142),(0.67717,0.66142),(0.68504,0.66142),(0.69291,0.66142),(0.70079,0.66142),(0.70866,0.66142),(0.71654,0.66142),(0.72441,0.66142),(0.73228,0.66142),(0.74016,0.66142),(0.74803,0.66142),(0.75591,0.66142),(0.76378,0.66142),(0.77165,0.66142),(0.77953,0.66142),(0.7874,0.66142),(0.79528,0.66142),(0.80315,0.66142),(0.81102,0.66142),(0.8189,0.66142),(0.82677,0.66142),(0.83465,0.66142),(0.84252,0.66142),(0.85039,0.66142),(0.85827,0.66142),(0.86614,0.66142),(0.87402,0.66142),(0.88189,0.66142),(0.88976,0.66142),(0.89764,0.66142),(0.90551,0.66142),(0.91339,0.66142),(0.92126,0.66142),(0.92913,0.66142),(0.93701,0.66142),(0.94488,0.66142),(0.95276,0.66142),(0.96063,0.66142),(0.9685,0.66142),(0.97638,0.66142),(0.98425,0.66142),(0.99213,0.66142),(0.99609,0.66142),(0.00391,0.66929),(0.00787,0.66929),(0.01575,0.66929),(0.02362,0.66929),(0.0315,0.66929),(0.03937,0.66929),(0.04724,0.66929),(0.05512,0.66929),(0.06299,0.66929),(0.07087,0.66929),(0.07874,0.66929),(0.08661,0.66929),(0.09449,0.66929),(0.10236,0.66929),(0.11024,0.66929),(0.11811,0.66929),(0.12598,0.66929),(0.13386,0.66929),(0.14173,0.66929),(0.14961,0.66929),(0.15748,0.66929),(0.16535,0.66929),(0.17323,0.66929),(0.1811,0.66929),(0.18898,0.66929),(0.19685,0.66929),(0.20472,0.66929),(0.2126,0.66929),(0.22047,0.66929),(0.22835,0.66929),(0.23622,0.66929),(0.24409,0.66929),(0.25197,0.66929),(0.25984,0.66929),(0.26772,0.66929),(0.27559,0.66929),(0.28346,0.66929),(0.29134,0.66929),(0.29921,0.66929),(0.30709,0.66929),(0.31496,0.66929),(0.32283,0.66929),(0.33071,0.66929),(0.33858,0.66929),(0.34646,0.66929),(0.35433,0.66929),(0.3622,0.66929),(0.37008,0.66929),(0.37795,0.66929),(0.38583,0.66929),(0.3937,0.66929),(0.40157,0.66929),(0.40945,0.66929),(0.41732,0.66929),(0.4252,0.66929),(0.43307,0.66929),(0.44094,0.66929),(0.44882,0.66929),(0.45669,0.66929),(0.46457,0.66929),(0.47244,0.66929),(0.48031,0.66929),(0.48819,0.66929),(0.49606,0.66929),(0.50394,0.66929),(0.51181,0.66929),(0.51969,0.66929),(0.52756,0.66929),(0.53543,0.66929),(0.54331,0.66929),(0.55118,0.66929),(0.55906,0.66929),(0.56693,0.66929),(0.5748,0.66929),(0.58268,0.66929),(0.59055,0.66929),(0.59843,0.66929),(0.6063,0.66929),(0.61417,0.66929),(0.62205,0.66929),(0.62992,0.66929),(0.6378,0.66929),(0.64567,0.66929),(0.65354,0.66929),(0.66142,0.66929),(0.66929,0.66929),(0.67717,0.66929),(0.68504,0.66929),(0.69291,0.66929),(0.70079,0.66929),(0.70866,0.66929),(0.71654,0.66929),(0.72441,0.66929),(0.73228,0.66929),(0.74016,0.66929),(0.74803,0.66929),(0.75591,0.66929),(0.76378,0.66929),(0.77165,0.66929),(0.77953,0.66929),(0.7874,0.66929),(0.79528,0.66929),(0.80315,0.66929),(0.81102,0.66929),(0.8189,0.66929),(0.82677,0.66929),(0.83465,0.66929),(0.84252,0.66929),(0.85039,0.66929),(0.85827,0.66929),(0.86614,0.66929),(0.87402,0.66929),(0.88189,0.66929),(0.88976,0.66929),(0.89764,0.66929),(0.90551,0.66929),(0.91339,0.66929),(0.92126,0.66929),(0.92913,0.66929),(0.93701,0.66929),(0.94488,0.66929),(0.95276,0.66929),(0.96063,0.66929),(0.9685,0.66929),(0.97638,0.66929),(0.98425,0.66929),(0.99213,0.66929),(0.99609,0.66929),(0.00391,0.67717),(0.00787,0.67717),(0.01575,0.67717),(0.02362,0.67717),(0.0315,0.67717),(0.03937,0.67717),(0.04724,0.67717),(0.05512,0.67717),(0.06299,0.67717),(0.07087,0.67717),(0.07874,0.67717),(0.08661,0.67717),(0.09449,0.67717),(0.10236,0.67717),(0.11024,0.67717),(0.11811,0.67717),(0.12598,0.67717),(0.13386,0.67717),(0.14173,0.67717),(0.14961,0.67717),(0.15748,0.67717),(0.16535,0.67717),(0.17323,0.67717),(0.1811,0.67717),(0.18898,0.67717),(0.19685,0.67717),(0.20472,0.67717),(0.2126,0.67717),(0.22047,0.67717),(0.22835,0.67717),(0.23622,0.67717),(0.24409,0.67717),(0.25197,0.67717),(0.25984,0.67717),(0.26772,0.67717),(0.27559,0.67717),(0.28346,0.67717),(0.29134,0.67717),(0.29921,0.67717),(0.30709,0.67717),(0.31496,0.67717),(0.32283,0.67717),(0.33071,0.67717),(0.33858,0.67717),(0.34646,0.67717),(0.35433,0.67717),(0.3622,0.67717),(0.37008,0.67717),(0.37795,0.67717),(0.38583,0.67717),(0.3937,0.67717),(0.40157,0.67717),(0.40945,0.67717),(0.41732,0.67717),(0.4252,0.67717),(0.43307,0.67717),(0.44094,0.67717),(0.44882,0.67717),(0.45669,0.67717),(0.46457,0.67717),(0.47244,0.67717),(0.48031,0.67717),(0.48819,0.67717),(0.49606,0.67717),(0.50394,0.67717),(0.51181,0.67717),(0.51969,0.67717),(0.52756,0.67717),(0.53543,0.67717),(0.54331,0.67717),(0.55118,0.67717),(0.55906,0.67717),(0.56693,0.67717),(0.5748,0.67717),(0.58268,0.67717),(0.59055,0.67717),(0.59843,0.67717),(0.6063,0.67717),(0.61417,0.67717),(0.62205,0.67717),(0.62992,0.67717),(0.6378,0.67717),(0.64567,0.67717),(0.65354,0.67717),(0.66142,0.67717),(0.66929,0.67717),(0.67717,0.67717),(0.68504,0.67717),(0.69291,0.67717),(0.70079,0.67717),(0.70866,0.67717),(0.71654,0.67717),(0.72441,0.67717),(0.73228,0.67717),(0.74016,0.67717),(0.74803,0.67717),(0.75591,0.67717),(0.76378,0.67717),(0.77165,0.67717),(0.77953,0.67717),(0.7874,0.67717),(0.79528,0.67717),(0.80315,0.67717),(0.81102,0.67717),(0.8189,0.67717),(0.82677,0.67717),(0.83465,0.67717),(0.84252,0.67717),(0.85039,0.67717),(0.85827,0.67717),(0.86614,0.67717),(0.87402,0.67717),(0.88189,0.67717),(0.88976,0.67717),(0.89764,0.67717),(0.90551,0.67717),(0.91339,0.67717),(0.92126,0.67717),(0.92913,0.67717),(0.93701,0.67717),(0.94488,0.67717),(0.95276,0.67717),(0.96063,0.67717),(0.9685,0.67717),(0.97638,0.67717),(0.98425,0.67717),(0.99213,0.67717),(0.99609,0.67717),(0.00391,0.68504),(0.00787,0.68504),(0.01575,0.68504),(0.02362,0.68504),(0.0315,0.68504),(0.03937,0.68504),(0.04724,0.68504),(0.05512,0.68504),(0.06299,0.68504),(0.07087,0.68504),(0.07874,0.68504),(0.08661,0.68504),(0.09449,0.68504),(0.10236,0.68504),(0.11024,0.68504),(0.11811,0.68504),(0.12598,0.68504),(0.13386,0.68504),(0.14173,0.68504),(0.14961,0.68504),(0.15748,0.68504),(0.16535,0.68504),(0.17323,0.68504),(0.1811,0.68504),(0.18898,0.68504),(0.19685,0.68504),(0.20472,0.68504),(0.2126,0.68504),(0.22047,0.68504),(0.22835,0.68504),(0.23622,0.68504),(0.24409,0.68504),(0.25197,0.68504),(0.25984,0.68504),(0.26772,0.68504),(0.27559,0.68504),(0.28346,0.68504),(0.29134,0.68504),(0.29921,0.68504),(0.30709,0.68504),(0.31496,0.68504),(0.32283,0.68504),(0.33071,0.68504),(0.33858,0.68504),(0.34646,0.68504),(0.35433,0.68504),(0.3622,0.68504),(0.37008,0.68504),(0.37795,0.68504),(0.38583,0.68504),(0.3937,0.68504),(0.40157,0.68504),(0.40945,0.68504),(0.41732,0.68504),(0.4252,0.68504),(0.43307,0.68504),(0.44094,0.68504),(0.44882,0.68504),(0.45669,0.68504),(0.46457,0.68504),(0.47244,0.68504),(0.48031,0.68504),(0.48819,0.68504),(0.49606,0.68504),(0.50394,0.68504),(0.51181,0.68504),(0.51969,0.68504),(0.52756,0.68504),(0.53543,0.68504),(0.54331,0.68504),(0.55118,0.68504),(0.55906,0.68504),(0.56693,0.68504),(0.5748,0.68504),(0.58268,0.68504),(0.59055,0.68504),(0.59843,0.68504),(0.6063,0.68504),(0.61417,0.68504),(0.62205,0.68504),(0.62992,0.68504),(0.6378,0.68504),(0.64567,0.68504),(0.65354,0.68504),(0.66142,0.68504),(0.66929,0.68504),(0.67717,0.68504),(0.68504,0.68504),(0.69291,0.68504),(0.70079,0.68504),(0.70866,0.68504),(0.71654,0.68504),(0.72441,0.68504),(0.73228,0.68504),(0.74016,0.68504),(0.74803,0.68504),(0.75591,0.68504),(0.76378,0.68504),(0.77165,0.68504),(0.77953,0.68504),(0.7874,0.68504),(0.79528,0.68504),(0.80315,0.68504),(0.81102,0.68504),(0.8189,0.68504),(0.82677,0.68504),(0.83465,0.68504),(0.84252,0.68504),(0.85039,0.68504),(0.85827,0.68504),(0.86614,0.68504),(0.87402,0.68504),(0.88189,0.68504),(0.88976,0.68504),(0.89764,0.68504),(0.90551,0.68504),(0.91339,0.68504),(0.92126,0.68504),(0.92913,0.68504),(0.93701,0.68504),(0.94488,0.68504),(0.95276,0.68504),(0.96063,0.68504),(0.9685,0.68504),(0.97638,0.68504),(0.98425,0.68504),(0.99213,0.68504),(0.99609,0.68504),(0.00391,0.69291),(0.00787,0.69291),(0.01575,0.69291),(0.02362,0.69291),(0.0315,0.69291),(0.03937,0.69291),(0.04724,0.69291),(0.05512,0.69291),(0.06299,0.69291),(0.07087,0.69291),(0.07874,0.69291),(0.08661,0.69291),(0.09449,0.69291),(0.10236,0.69291),(0.11024,0.69291),(0.11811,0.69291),(0.12598,0.69291),(0.13386,0.69291),(0.14173,0.69291),(0.14961,0.69291),(0.15748,0.69291),(0.16535,0.69291),(0.17323,0.69291),(0.1811,0.69291),(0.18898,0.69291),(0.19685,0.69291),(0.20472,0.69291),(0.2126,0.69291),(0.22047,0.69291),(0.22835,0.69291),(0.23622,0.69291),(0.24409,0.69291),(0.25197,0.69291),(0.25984,0.69291),(0.26772,0.69291),(0.27559,0.69291),(0.28346,0.69291),(0.29134,0.69291),(0.29921,0.69291),(0.30709,0.69291),(0.31496,0.69291),(0.32283,0.69291),(0.33071,0.69291),(0.33858,0.69291),(0.34646,0.69291),(0.35433,0.69291),(0.3622,0.69291),(0.37008,0.69291),(0.37795,0.69291),(0.38583,0.69291),(0.3937,0.69291),(0.40157,0.69291),(0.40945,0.69291),(0.41732,0.69291),(0.4252,0.69291),(0.43307,0.69291),(0.44094,0.69291),(0.44882,0.69291),(0.45669,0.69291),(0.46457,0.69291),(0.47244,0.69291),(0.48031,0.69291),(0.48819,0.69291),(0.49606,0.69291),(0.50394,0.69291),(0.51181,0.69291),(0.51969,0.69291),(0.52756,0.69291),(0.53543,0.69291),(0.54331,0.69291),(0.55118,0.69291),(0.55906,0.69291),(0.56693,0.69291),(0.5748,0.69291),(0.58268,0.69291),(0.59055,0.69291),(0.59843,0.69291),(0.6063,0.69291),(0.61417,0.69291),(0.62205,0.69291),(0.62992,0.69291),(0.6378,0.69291),(0.64567,0.69291),(0.65354,0.69291),(0.66142,0.69291),(0.66929,0.69291),(0.67717,0.69291),(0.68504,0.69291),(0.69291,0.69291),(0.70079,0.69291),(0.70866,0.69291),(0.71654,0.69291),(0.72441,0.69291),(0.73228,0.69291),(0.74016,0.69291),(0.74803,0.69291),(0.75591,0.69291),(0.76378,0.69291),(0.77165,0.69291),(0.77953,0.69291),(0.7874,0.69291),(0.79528,0.69291),(0.80315,0.69291),(0.81102,0.69291),(0.8189,0.69291),(0.82677,0.69291),(0.83465,0.69291),(0.84252,0.69291),(0.85039,0.69291),(0.85827,0.69291),(0.86614,0.69291),(0.87402,0.69291),(0.88189,0.69291),(0.88976,0.69291),(0.89764,0.69291),(0.90551,0.69291),(0.91339,0.69291),(0.92126,0.69291),(0.92913,0.69291),(0.93701,0.69291),(0.94488,0.69291),(0.95276,0.69291),(0.96063,0.69291),(0.9685,0.69291),(0.97638,0.69291),(0.98425,0.69291),(0.99213,0.69291),(0.99609,0.69291),(0.00391,0.70079),(0.00787,0.70079),(0.01575,0.70079),(0.02362,0.70079),(0.0315,0.70079),(0.03937,0.70079),(0.04724,0.70079),(0.05512,0.70079),(0.06299,0.70079),(0.07087,0.70079),(0.07874,0.70079),(0.08661,0.70079),(0.09449,0.70079),(0.10236,0.70079),(0.11024,0.70079),(0.11811,0.70079),(0.12598,0.70079),(0.13386,0.70079),(0.14173,0.70079),(0.14961,0.70079),(0.15748,0.70079),(0.16535,0.70079),(0.17323,0.70079),(0.1811,0.70079),(0.18898,0.70079),(0.19685,0.70079),(0.20472,0.70079),(0.2126,0.70079),(0.22047,0.70079),(0.22835,0.70079),(0.23622,0.70079),(0.24409,0.70079),(0.25197,0.70079),(0.25984,0.70079),(0.26772,0.70079),(0.27559,0.70079),(0.28346,0.70079),(0.29134,0.70079),(0.29921,0.70079),(0.30709,0.70079),(0.31496,0.70079),(0.32283,0.70079),(0.33071,0.70079),(0.33858,0.70079),(0.34646,0.70079),(0.35433,0.70079),(0.3622,0.70079),(0.37008,0.70079),(0.37795,0.70079),(0.38583,0.70079),(0.3937,0.70079),(0.40157,0.70079),(0.40945,0.70079),(0.41732,0.70079),(0.4252,0.70079),(0.43307,0.70079),(0.44094,0.70079),(0.44882,0.70079),(0.45669,0.70079),(0.46457,0.70079),(0.47244,0.70079),(0.48031,0.70079),(0.48819,0.70079),(0.49606,0.70079),(0.50394,0.70079),(0.51181,0.70079),(0.51969,0.70079),(0.52756,0.70079),(0.53543,0.70079),(0.54331,0.70079),(0.55118,0.70079),(0.55906,0.70079),(0.56693,0.70079),(0.5748,0.70079),(0.58268,0.70079),(0.59055,0.70079),(0.59843,0.70079),(0.6063,0.70079),(0.61417,0.70079),(0.62205,0.70079),(0.62992,0.70079),(0.6378,0.70079),(0.64567,0.70079),(0.65354,0.70079),(0.66142,0.70079),(0.66929,0.70079),(0.67717,0.70079),(0.68504,0.70079),(0.69291,0.70079),(0.70079,0.70079),(0.70866,0.70079),(0.71654,0.70079),(0.72441,0.70079),(0.73228,0.70079),(0.74016,0.70079),(0.74803,0.70079),(0.75591,0.70079),(0.76378,0.70079),(0.77165,0.70079),(0.77953,0.70079),(0.7874,0.70079),(0.79528,0.70079),(0.80315,0.70079),(0.81102,0.70079),(0.8189,0.70079),(0.82677,0.70079),(0.83465,0.70079),(0.84252,0.70079),(0.85039,0.70079),(0.85827,0.70079),(0.86614,0.70079),(0.87402,0.70079),(0.88189,0.70079),(0.88976,0.70079),(0.89764,0.70079),(0.90551,0.70079),(0.91339,0.70079),(0.92126,0.70079),(0.92913,0.70079),(0.93701,0.70079),(0.94488,0.70079),(0.95276,0.70079),(0.96063,0.70079),(0.9685,0.70079),(0.97638,0.70079),(0.98425,0.70079),(0.99213,0.70079),(0.99609,0.70079),(0.00391,0.70866),(0.00787,0.70866),(0.01575,0.70866),(0.02362,0.70866),(0.0315,0.70866),(0.03937,0.70866),(0.04724,0.70866),(0.05512,0.70866),(0.06299,0.70866),(0.07087,0.70866),(0.07874,0.70866),(0.08661,0.70866),(0.09449,0.70866),(0.10236,0.70866),(0.11024,0.70866),(0.11811,0.70866),(0.12598,0.70866),(0.13386,0.70866),(0.14173,0.70866),(0.14961,0.70866),(0.15748,0.70866),(0.16535,0.70866),(0.17323,0.70866),(0.1811,0.70866),(0.18898,0.70866),(0.19685,0.70866),(0.20472,0.70866),(0.2126,0.70866),(0.22047,0.70866),(0.22835,0.70866),(0.23622,0.70866),(0.24409,0.70866),(0.25197,0.70866),(0.25984,0.70866),(0.26772,0.70866),(0.27559,0.70866),(0.28346,0.70866),(0.29134,0.70866),(0.29921,0.70866),(0.30709,0.70866),(0.31496,0.70866),(0.32283,0.70866),(0.33071,0.70866),(0.33858,0.70866),(0.34646,0.70866),(0.35433,0.70866),(0.3622,0.70866),(0.37008,0.70866),(0.37795,0.70866),(0.38583,0.70866),(0.3937,0.70866),(0.40157,0.70866),(0.40945,0.70866),(0.41732,0.70866),(0.4252,0.70866),(0.43307,0.70866),(0.44094,0.70866),(0.44882,0.70866),(0.45669,0.70866),(0.46457,0.70866),(0.47244,0.70866),(0.48031,0.70866),(0.48819,0.70866),(0.49606,0.70866),(0.50394,0.70866),(0.51181,0.70866),(0.51969,0.70866),(0.52756,0.70866),(0.53543,0.70866),(0.54331,0.70866),(0.55118,0.70866),(0.55906,0.70866),(0.56693,0.70866),(0.5748,0.70866),(0.58268,0.70866),(0.59055,0.70866),(0.59843,0.70866),(0.6063,0.70866),(0.61417,0.70866),(0.62205,0.70866),(0.62992,0.70866),(0.6378,0.70866),(0.64567,0.70866),(0.65354,0.70866),(0.66142,0.70866),(0.66929,0.70866),(0.67717,0.70866),(0.68504,0.70866),(0.69291,0.70866),(0.70079,0.70866),(0.70866,0.70866),(0.71654,0.70866),(0.72441,0.70866),(0.73228,0.70866),(0.74016,0.70866),(0.74803,0.70866),(0.75591,0.70866),(0.76378,0.70866),(0.77165,0.70866),(0.77953,0.70866),(0.7874,0.70866),(0.79528,0.70866),(0.80315,0.70866),(0.81102,0.70866),(0.8189,0.70866),(0.82677,0.70866),(0.83465,0.70866),(0.84252,0.70866),(0.85039,0.70866),(0.85827,0.70866),(0.86614,0.70866),(0.87402,0.70866),(0.88189,0.70866),(0.88976,0.70866),(0.89764,0.70866),(0.90551,0.70866),(0.91339,0.70866),(0.92126,0.70866),(0.92913,0.70866),(0.93701,0.70866),(0.94488,0.70866),(0.95276,0.70866),(0.96063,0.70866),(0.9685,0.70866),(0.97638,0.70866),(0.98425,0.70866),(0.99213,0.70866),(0.99609,0.70866),(0.00391,0.71654),(0.00787,0.71654),(0.01575,0.71654),(0.02362,0.71654),(0.0315,0.71654),(0.03937,0.71654),(0.04724,0.71654),(0.05512,0.71654),(0.06299,0.71654),(0.07087,0.71654),(0.07874,0.71654),(0.08661,0.71654),(0.09449,0.71654),(0.10236,0.71654),(0.11024,0.71654),(0.11811,0.71654),(0.12598,0.71654),(0.13386,0.71654),(0.14173,0.71654),(0.14961,0.71654),(0.15748,0.71654),(0.16535,0.71654),(0.17323,0.71654),(0.1811,0.71654),(0.18898,0.71654),(0.19685,0.71654),(0.20472,0.71654),(0.2126,0.71654),(0.22047,0.71654),(0.22835,0.71654),(0.23622,0.71654),(0.24409,0.71654),(0.25197,0.71654),(0.25984,0.71654),(0.26772,0.71654),(0.27559,0.71654),(0.28346,0.71654),(0.29134,0.71654),(0.29921,0.71654),(0.30709,0.71654),(0.31496,0.71654),(0.32283,0.71654),(0.33071,0.71654),(0.33858,0.71654),(0.34646,0.71654),(0.35433,0.71654),(0.3622,0.71654),(0.37008,0.71654),(0.37795,0.71654),(0.38583,0.71654),(0.3937,0.71654),(0.40157,0.71654),(0.40945,0.71654),(0.41732,0.71654),(0.4252,0.71654),(0.43307,0.71654),(0.44094,0.71654),(0.44882,0.71654),(0.45669,0.71654),(0.46457,0.71654),(0.47244,0.71654),(0.48031,0.71654),(0.48819,0.71654),(0.49606,0.71654),(0.50394,0.71654),(0.51181,0.71654),(0.51969,0.71654),(0.52756,0.71654),(0.53543,0.71654),(0.54331,0.71654),(0.55118,0.71654),(0.55906,0.71654),(0.56693,0.71654),(0.5748,0.71654),(0.58268,0.71654),(0.59055,0.71654),(0.59843,0.71654),(0.6063,0.71654),(0.61417,0.71654),(0.62205,0.71654),(0.62992,0.71654),(0.6378,0.71654),(0.64567,0.71654),(0.65354,0.71654),(0.66142,0.71654),(0.66929,0.71654),(0.67717,0.71654),(0.68504,0.71654),(0.69291,0.71654),(0.70079,0.71654),(0.70866,0.71654),(0.71654,0.71654),(0.72441,0.71654),(0.73228,0.71654),(0.74016,0.71654),(0.74803,0.71654),(0.75591,0.71654),(0.76378,0.71654),(0.77165,0.71654),(0.77953,0.71654),(0.7874,0.71654),(0.79528,0.71654),(0.80315,0.71654),(0.81102,0.71654),(0.8189,0.71654),(0.82677,0.71654),(0.83465,0.71654),(0.84252,0.71654),(0.85039,0.71654),(0.85827,0.71654),(0.86614,0.71654),(0.87402,0.71654),(0.88189,0.71654),(0.88976,0.71654),(0.89764,0.71654),(0.90551,0.71654),(0.91339,0.71654),(0.92126,0.71654),(0.92913,0.71654),(0.93701,0.71654),(0.94488,0.71654),(0.95276,0.71654),(0.96063,0.71654),(0.9685,0.71654),(0.97638,0.71654),(0.98425,0.71654),(0.99213,0.71654),(0.99609,0.71654),(0.00391,0.72441),(0.00787,0.72441),(0.01575,0.72441),(0.02362,0.72441),(0.0315,0.72441),(0.03937,0.72441),(0.04724,0.72441),(0.05512,0.72441),(0.06299,0.72441),(0.07087,0.72441),(0.07874,0.72441),(0.08661,0.72441),(0.09449,0.72441),(0.10236,0.72441),(0.11024,0.72441),(0.11811,0.72441),(0.12598,0.72441),(0.13386,0.72441),(0.14173,0.72441),(0.14961,0.72441),(0.15748,0.72441),(0.16535,0.72441),(0.17323,0.72441),(0.1811,0.72441),(0.18898,0.72441),(0.19685,0.72441),(0.20472,0.72441),(0.2126,0.72441),(0.22047,0.72441),(0.22835,0.72441),(0.23622,0.72441),(0.24409,0.72441),(0.25197,0.72441),(0.25984,0.72441),(0.26772,0.72441),(0.27559,0.72441),(0.28346,0.72441),(0.29134,0.72441),(0.29921,0.72441),(0.30709,0.72441),(0.31496,0.72441),(0.32283,0.72441),(0.33071,0.72441),(0.33858,0.72441),(0.34646,0.72441),(0.35433,0.72441),(0.3622,0.72441),(0.37008,0.72441),(0.37795,0.72441),(0.38583,0.72441),(0.3937,0.72441),(0.40157,0.72441),(0.40945,0.72441),(0.41732,0.72441),(0.4252,0.72441),(0.43307,0.72441),(0.44094,0.72441),(0.44882,0.72441),(0.45669,0.72441),(0.46457,0.72441),(0.47244,0.72441),(0.48031,0.72441),(0.48819,0.72441),(0.49606,0.72441),(0.50394,0.72441),(0.51181,0.72441),(0.51969,0.72441),(0.52756,0.72441),(0.53543,0.72441),(0.54331,0.72441),(0.55118,0.72441),(0.55906,0.72441),(0.56693,0.72441),(0.5748,0.72441),(0.58268,0.72441),(0.59055,0.72441),(0.59843,0.72441),(0.6063,0.72441),(0.61417,0.72441),(0.62205,0.72441),(0.62992,0.72441),(0.6378,0.72441),(0.64567,0.72441),(0.65354,0.72441),(0.66142,0.72441),(0.66929,0.72441),(0.67717,0.72441),(0.68504,0.72441),(0.69291,0.72441),(0.70079,0.72441),(0.70866,0.72441),(0.71654,0.72441),(0.72441,0.72441),(0.73228,0.72441),(0.74016,0.72441),(0.74803,0.72441),(0.75591,0.72441),(0.76378,0.72441),(0.77165,0.72441),(0.77953,0.72441),(0.7874,0.72441),(0.79528,0.72441),(0.80315,0.72441),(0.81102,0.72441),(0.8189,0.72441),(0.82677,0.72441),(0.83465,0.72441),(0.84252,0.72441),(0.85039,0.72441),(0.85827,0.72441),(0.86614,0.72441),(0.87402,0.72441),(0.88189,0.72441),(0.88976,0.72441),(0.89764,0.72441),(0.90551,0.72441),(0.91339,0.72441),(0.92126,0.72441),(0.92913,0.72441),(0.93701,0.72441),(0.94488,0.72441),(0.95276,0.72441),(0.96063,0.72441),(0.9685,0.72441),(0.97638,0.72441),(0.98425,0.72441),(0.99213,0.72441),(0.99609,0.72441),(0.00391,0.73228),(0.00787,0.73228),(0.01575,0.73228),(0.02362,0.73228),(0.0315,0.73228),(0.03937,0.73228),(0.04724,0.73228),(0.05512,0.73228),(0.06299,0.73228),(0.07087,0.73228),(0.07874,0.73228),(0.08661,0.73228),(0.09449,0.73228),(0.10236,0.73228),(0.11024,0.73228),(0.11811,0.73228),(0.12598,0.73228),(0.13386,0.73228),(0.14173,0.73228),(0.14961,0.73228),(0.15748,0.73228),(0.16535,0.73228),(0.17323,0.73228),(0.1811,0.73228),(0.18898,0.73228),(0.19685,0.73228),(0.20472,0.73228),(0.2126,0.73228),(0.22047,0.73228),(0.22835,0.73228),(0.23622,0.73228),(0.24409,0.73228),(0.25197,0.73228),(0.25984,0.73228),(0.26772,0.73228),(0.27559,0.73228),(0.28346,0.73228),(0.29134,0.73228),(0.29921,0.73228),(0.30709,0.73228),(0.31496,0.73228),(0.32283,0.73228),(0.33071,0.73228),(0.33858,0.73228),(0.34646,0.73228),(0.35433,0.73228),(0.3622,0.73228),(0.37008,0.73228),(0.37795,0.73228),(0.38583,0.73228),(0.3937,0.73228),(0.40157,0.73228),(0.40945,0.73228),(0.41732,0.73228),(0.4252,0.73228),(0.43307,0.73228),(0.44094,0.73228),(0.44882,0.73228),(0.45669,0.73228),(0.46457,0.73228),(0.47244,0.73228),(0.48031,0.73228),(0.48819,0.73228),(0.49606,0.73228),(0.50394,0.73228),(0.51181,0.73228),(0.51969,0.73228),(0.52756,0.73228),(0.53543,0.73228),(0.54331,0.73228),(0.55118,0.73228),(0.55906,0.73228),(0.56693,0.73228),(0.5748,0.73228),(0.58268,0.73228),(0.59055,0.73228),(0.59843,0.73228),(0.6063,0.73228),(0.61417,0.73228),(0.62205,0.73228),(0.62992,0.73228),(0.6378,0.73228),(0.64567,0.73228),(0.65354,0.73228),(0.66142,0.73228),(0.66929,0.73228),(0.67717,0.73228),(0.68504,0.73228),(0.69291,0.73228),(0.70079,0.73228),(0.70866,0.73228),(0.71654,0.73228),(0.72441,0.73228),(0.73228,0.73228),(0.74016,0.73228),(0.74803,0.73228),(0.75591,0.73228),(0.76378,0.73228),(0.77165,0.73228),(0.77953,0.73228),(0.7874,0.73228),(0.79528,0.73228),(0.80315,0.73228),(0.81102,0.73228),(0.8189,0.73228),(0.82677,0.73228),(0.83465,0.73228),(0.84252,0.73228),(0.85039,0.73228),(0.85827,0.73228),(0.86614,0.73228),(0.87402,0.73228),(0.88189,0.73228),(0.88976,0.73228),(0.89764,0.73228),(0.90551,0.73228),(0.91339,0.73228),(0.92126,0.73228),(0.92913,0.73228),(0.93701,0.73228),(0.94488,0.73228),(0.95276,0.73228),(0.96063,0.73228),(0.9685,0.73228),(0.97638,0.73228),(0.98425,0.73228),(0.99213,0.73228),(0.99609,0.73228),(0.00391,0.74016),(0.00787,0.74016),(0.01575,0.74016),(0.02362,0.74016),(0.0315,0.74016),(0.03937,0.74016),(0.04724,0.74016),(0.05512,0.74016),(0.06299,0.74016),(0.07087,0.74016),(0.07874,0.74016),(0.08661,0.74016),(0.09449,0.74016),(0.10236,0.74016),(0.11024,0.74016),(0.11811,0.74016),(0.12598,0.74016),(0.13386,0.74016),(0.14173,0.74016),(0.14961,0.74016),(0.15748,0.74016),(0.16535,0.74016),(0.17323,0.74016),(0.1811,0.74016),(0.18898,0.74016),(0.19685,0.74016),(0.20472,0.74016),(0.2126,0.74016),(0.22047,0.74016),(0.22835,0.74016),(0.23622,0.74016),(0.24409,0.74016),(0.25197,0.74016),(0.25984,0.74016),(0.26772,0.74016),(0.27559,0.74016),(0.28346,0.74016),(0.29134,0.74016),(0.29921,0.74016),(0.30709,0.74016),(0.31496,0.74016),(0.32283,0.74016),(0.33071,0.74016),(0.33858,0.74016),(0.34646,0.74016),(0.35433,0.74016),(0.3622,0.74016),(0.37008,0.74016),(0.37795,0.74016),(0.38583,0.74016),(0.3937,0.74016),(0.40157,0.74016),(0.40945,0.74016),(0.41732,0.74016),(0.4252,0.74016),(0.43307,0.74016),(0.44094,0.74016),(0.44882,0.74016),(0.45669,0.74016),(0.46457,0.74016),(0.47244,0.74016),(0.48031,0.74016),(0.48819,0.74016),(0.49606,0.74016),(0.50394,0.74016),(0.51181,0.74016),(0.51969,0.74016),(0.52756,0.74016),(0.53543,0.74016),(0.54331,0.74016),(0.55118,0.74016),(0.55906,0.74016),(0.56693,0.74016),(0.5748,0.74016),(0.58268,0.74016),(0.59055,0.74016),(0.59843,0.74016),(0.6063,0.74016),(0.61417,0.74016),(0.62205,0.74016),(0.62992,0.74016),(0.6378,0.74016),(0.64567,0.74016),(0.65354,0.74016),(0.66142,0.74016),(0.66929,0.74016),(0.67717,0.74016),(0.68504,0.74016),(0.69291,0.74016),(0.70079,0.74016),(0.70866,0.74016),(0.71654,0.74016),(0.72441,0.74016),(0.73228,0.74016),(0.74016,0.74016),(0.74803,0.74016),(0.75591,0.74016),(0.76378,0.74016),(0.77165,0.74016),(0.77953,0.74016),(0.7874,0.74016),(0.79528,0.74016),(0.80315,0.74016),(0.81102,0.74016),(0.8189,0.74016),(0.82677,0.74016),(0.83465,0.74016),(0.84252,0.74016),(0.85039,0.74016),(0.85827,0.74016),(0.86614,0.74016),(0.87402,0.74016),(0.88189,0.74016),(0.88976,0.74016),(0.89764,0.74016),(0.90551,0.74016),(0.91339,0.74016),(0.92126,0.74016),(0.92913,0.74016),(0.93701,0.74016),(0.94488,0.74016),(0.95276,0.74016),(0.96063,0.74016),(0.9685,0.74016),(0.97638,0.74016),(0.98425,0.74016),(0.99213,0.74016),(0.99609,0.74016),(0.00391,0.74803),(0.00787,0.74803),(0.01575,0.74803),(0.02362,0.74803),(0.0315,0.74803),(0.03937,0.74803),(0.04724,0.74803),(0.05512,0.74803),(0.06299,0.74803),(0.07087,0.74803),(0.07874,0.74803),(0.08661,0.74803),(0.09449,0.74803),(0.10236,0.74803),(0.11024,0.74803),(0.11811,0.74803),(0.12598,0.74803),(0.13386,0.74803),(0.14173,0.74803),(0.14961,0.74803),(0.15748,0.74803),(0.16535,0.74803),(0.17323,0.74803),(0.1811,0.74803),(0.18898,0.74803),(0.19685,0.74803),(0.20472,0.74803),(0.2126,0.74803),(0.22047,0.74803),(0.22835,0.74803),(0.23622,0.74803),(0.24409,0.74803),(0.25197,0.74803),(0.25984,0.74803),(0.26772,0.74803),(0.27559,0.74803),(0.28346,0.74803),(0.29134,0.74803),(0.29921,0.74803),(0.30709,0.74803),(0.31496,0.74803),(0.32283,0.74803),(0.33071,0.74803),(0.33858,0.74803),(0.34646,0.74803),(0.35433,0.74803),(0.3622,0.74803),(0.37008,0.74803),(0.37795,0.74803),(0.38583,0.74803),(0.3937,0.74803),(0.40157,0.74803),(0.40945,0.74803),(0.41732,0.74803),(0.4252,0.74803),(0.43307,0.74803),(0.44094,0.74803),(0.44882,0.74803),(0.45669,0.74803),(0.46457,0.74803),(0.47244,0.74803),(0.48031,0.74803),(0.48819,0.74803),(0.49606,0.74803),(0.50394,0.74803),(0.51181,0.74803),(0.51969,0.74803),(0.52756,0.74803),(0.53543,0.74803),(0.54331,0.74803),(0.55118,0.74803),(0.55906,0.74803),(0.56693,0.74803),(0.5748,0.74803),(0.58268,0.74803),(0.59055,0.74803),(0.59843,0.74803),(0.6063,0.74803),(0.61417,0.74803),(0.62205,0.74803),(0.62992,0.74803),(0.6378,0.74803),(0.64567,0.74803),(0.65354,0.74803),(0.66142,0.74803),(0.66929,0.74803),(0.67717,0.74803),(0.68504,0.74803),(0.69291,0.74803),(0.70079,0.74803),(0.70866,0.74803),(0.71654,0.74803),(0.72441,0.74803),(0.73228,0.74803),(0.74016,0.74803),(0.74803,0.74803),(0.75591,0.74803),(0.76378,0.74803),(0.77165,0.74803),(0.77953,0.74803),(0.7874,0.74803),(0.79528,0.74803),(0.80315,0.74803),(0.81102,0.74803),(0.8189,0.74803),(0.82677,0.74803),(0.83465,0.74803),(0.84252,0.74803),(0.85039,0.74803),(0.85827,0.74803),(0.86614,0.74803),(0.87402,0.74803),(0.88189,0.74803),(0.88976,0.74803),(0.89764,0.74803),(0.90551,0.74803),(0.91339,0.74803),(0.92126,0.74803),(0.92913,0.74803),(0.93701,0.74803),(0.94488,0.74803),(0.95276,0.74803),(0.96063,0.74803),(0.9685,0.74803),(0.97638,0.74803),(0.98425,0.74803),(0.99213,0.74803),(0.99609,0.74803),(0.00391,0.75591),(0.00787,0.75591),(0.01575,0.75591),(0.02362,0.75591),(0.0315,0.75591),(0.03937,0.75591),(0.04724,0.75591),(0.05512,0.75591),(0.06299,0.75591),(0.07087,0.75591),(0.07874,0.75591),(0.08661,0.75591),(0.09449,0.75591),(0.10236,0.75591),(0.11024,0.75591),(0.11811,0.75591),(0.12598,0.75591),(0.13386,0.75591),(0.14173,0.75591),(0.14961,0.75591),(0.15748,0.75591),(0.16535,0.75591),(0.17323,0.75591),(0.1811,0.75591),(0.18898,0.75591),(0.19685,0.75591),(0.20472,0.75591),(0.2126,0.75591),(0.22047,0.75591),(0.22835,0.75591),(0.23622,0.75591),(0.24409,0.75591),(0.25197,0.75591),(0.25984,0.75591),(0.26772,0.75591),(0.27559,0.75591),(0.28346,0.75591),(0.29134,0.75591),(0.29921,0.75591),(0.30709,0.75591),(0.31496,0.75591),(0.32283,0.75591),(0.33071,0.75591),(0.33858,0.75591),(0.34646,0.75591),(0.35433,0.75591),(0.3622,0.75591),(0.37008,0.75591),(0.37795,0.75591),(0.38583,0.75591),(0.3937,0.75591),(0.40157,0.75591),(0.40945,0.75591),(0.41732,0.75591),(0.4252,0.75591),(0.43307,0.75591),(0.44094,0.75591),(0.44882,0.75591),(0.45669,0.75591),(0.46457,0.75591),(0.47244,0.75591),(0.48031,0.75591),(0.48819,0.75591),(0.49606,0.75591),(0.50394,0.75591),(0.51181,0.75591),(0.51969,0.75591),(0.52756,0.75591),(0.53543,0.75591),(0.54331,0.75591),(0.55118,0.75591),(0.55906,0.75591),(0.56693,0.75591),(0.5748,0.75591),(0.58268,0.75591),(0.59055,0.75591),(0.59843,0.75591),(0.6063,0.75591),(0.61417,0.75591),(0.62205,0.75591),(0.62992,0.75591),(0.6378,0.75591),(0.64567,0.75591),(0.65354,0.75591),(0.66142,0.75591),(0.66929,0.75591),(0.67717,0.75591),(0.68504,0.75591),(0.69291,0.75591),(0.70079,0.75591),(0.70866,0.75591),(0.71654,0.75591),(0.72441,0.75591),(0.73228,0.75591),(0.74016,0.75591),(0.74803,0.75591),(0.75591,0.75591),(0.76378,0.75591),(0.77165,0.75591),(0.77953,0.75591),(0.7874,0.75591),(0.79528,0.75591),(0.80315,0.75591),(0.81102,0.75591),(0.8189,0.75591),(0.82677,0.75591),(0.83465,0.75591),(0.84252,0.75591),(0.85039,0.75591),(0.85827,0.75591),(0.86614,0.75591),(0.87402,0.75591),(0.88189,0.75591),(0.88976,0.75591),(0.89764,0.75591),(0.90551,0.75591),(0.91339,0.75591),(0.92126,0.75591),(0.92913,0.75591),(0.93701,0.75591),(0.94488,0.75591),(0.95276,0.75591),(0.96063,0.75591),(0.9685,0.75591),(0.97638,0.75591),(0.98425,0.75591),(0.99213,0.75591),(0.99609,0.75591),(0.00391,0.76378),(0.00787,0.76378),(0.01575,0.76378),(0.02362,0.76378),(0.0315,0.76378),(0.03937,0.76378),(0.04724,0.76378),(0.05512,0.76378),(0.06299,0.76378),(0.07087,0.76378),(0.07874,0.76378),(0.08661,0.76378),(0.09449,0.76378),(0.10236,0.76378),(0.11024,0.76378),(0.11811,0.76378),(0.12598,0.76378),(0.13386,0.76378),(0.14173,0.76378),(0.14961,0.76378),(0.15748,0.76378),(0.16535,0.76378),(0.17323,0.76378),(0.1811,0.76378),(0.18898,0.76378),(0.19685,0.76378),(0.20472,0.76378),(0.2126,0.76378),(0.22047,0.76378),(0.22835,0.76378),(0.23622,0.76378),(0.24409,0.76378),(0.25197,0.76378),(0.25984,0.76378),(0.26772,0.76378),(0.27559,0.76378),(0.28346,0.76378),(0.29134,0.76378),(0.29921,0.76378),(0.30709,0.76378),(0.31496,0.76378),(0.32283,0.76378),(0.33071,0.76378),(0.33858,0.76378),(0.34646,0.76378),(0.35433,0.76378),(0.3622,0.76378),(0.37008,0.76378),(0.37795,0.76378),(0.38583,0.76378),(0.3937,0.76378),(0.40157,0.76378),(0.40945,0.76378),(0.41732,0.76378),(0.4252,0.76378),(0.43307,0.76378),(0.44094,0.76378),(0.44882,0.76378),(0.45669,0.76378),(0.46457,0.76378),(0.47244,0.76378),(0.48031,0.76378),(0.48819,0.76378),(0.49606,0.76378),(0.50394,0.76378),(0.51181,0.76378),(0.51969,0.76378),(0.52756,0.76378),(0.53543,0.76378),(0.54331,0.76378),(0.55118,0.76378),(0.55906,0.76378),(0.56693,0.76378),(0.5748,0.76378),(0.58268,0.76378),(0.59055,0.76378),(0.59843,0.76378),(0.6063,0.76378),(0.61417,0.76378),(0.62205,0.76378),(0.62992,0.76378),(0.6378,0.76378),(0.64567,0.76378),(0.65354,0.76378),(0.66142,0.76378),(0.66929,0.76378),(0.67717,0.76378),(0.68504,0.76378),(0.69291,0.76378),(0.70079,0.76378),(0.70866,0.76378),(0.71654,0.76378),(0.72441,0.76378),(0.73228,0.76378),(0.74016,0.76378),(0.74803,0.76378),(0.75591,0.76378),(0.76378,0.76378),(0.77165,0.76378),(0.77953,0.76378),(0.7874,0.76378),(0.79528,0.76378),(0.80315,0.76378),(0.81102,0.76378),(0.8189,0.76378),(0.82677,0.76378),(0.83465,0.76378),(0.84252,0.76378),(0.85039,0.76378),(0.85827,0.76378),(0.86614,0.76378),(0.87402,0.76378),(0.88189,0.76378),(0.88976,0.76378),(0.89764,0.76378),(0.90551,0.76378),(0.91339,0.76378),(0.92126,0.76378),(0.92913,0.76378),(0.93701,0.76378),(0.94488,0.76378),(0.95276,0.76378),(0.96063,0.76378),(0.9685,0.76378),(0.97638,0.76378),(0.98425,0.76378),(0.99213,0.76378),(0.99609,0.76378),(0.00391,0.77165),(0.00787,0.77165),(0.01575,0.77165),(0.02362,0.77165),(0.0315,0.77165),(0.03937,0.77165),(0.04724,0.77165),(0.05512,0.77165),(0.06299,0.77165),(0.07087,0.77165),(0.07874,0.77165),(0.08661,0.77165),(0.09449,0.77165),(0.10236,0.77165),(0.11024,0.77165),(0.11811,0.77165),(0.12598,0.77165),(0.13386,0.77165),(0.14173,0.77165),(0.14961,0.77165),(0.15748,0.77165),(0.16535,0.77165),(0.17323,0.77165),(0.1811,0.77165),(0.18898,0.77165),(0.19685,0.77165),(0.20472,0.77165),(0.2126,0.77165),(0.22047,0.77165),(0.22835,0.77165),(0.23622,0.77165),(0.24409,0.77165),(0.25197,0.77165),(0.25984,0.77165),(0.26772,0.77165),(0.27559,0.77165),(0.28346,0.77165),(0.29134,0.77165),(0.29921,0.77165),(0.30709,0.77165),(0.31496,0.77165),(0.32283,0.77165),(0.33071,0.77165),(0.33858,0.77165),(0.34646,0.77165),(0.35433,0.77165),(0.3622,0.77165),(0.37008,0.77165),(0.37795,0.77165),(0.38583,0.77165),(0.3937,0.77165),(0.40157,0.77165),(0.40945,0.77165),(0.41732,0.77165),(0.4252,0.77165),(0.43307,0.77165),(0.44094,0.77165),(0.44882,0.77165),(0.45669,0.77165),(0.46457,0.77165),(0.47244,0.77165),(0.48031,0.77165),(0.48819,0.77165),(0.49606,0.77165),(0.50394,0.77165),(0.51181,0.77165),(0.51969,0.77165),(0.52756,0.77165),(0.53543,0.77165),(0.54331,0.77165),(0.55118,0.77165),(0.55906,0.77165),(0.56693,0.77165),(0.5748,0.77165),(0.58268,0.77165),(0.59055,0.77165),(0.59843,0.77165),(0.6063,0.77165),(0.61417,0.77165),(0.62205,0.77165),(0.62992,0.77165),(0.6378,0.77165),(0.64567,0.77165),(0.65354,0.77165),(0.66142,0.77165),(0.66929,0.77165),(0.67717,0.77165),(0.68504,0.77165),(0.69291,0.77165),(0.70079,0.77165),(0.70866,0.77165),(0.71654,0.77165),(0.72441,0.77165),(0.73228,0.77165),(0.74016,0.77165),(0.74803,0.77165),(0.75591,0.77165),(0.76378,0.77165),(0.77165,0.77165),(0.77953,0.77165),(0.7874,0.77165),(0.79528,0.77165),(0.80315,0.77165),(0.81102,0.77165),(0.8189,0.77165),(0.82677,0.77165),(0.83465,0.77165),(0.84252,0.77165),(0.85039,0.77165),(0.85827,0.77165),(0.86614,0.77165),(0.87402,0.77165),(0.88189,0.77165),(0.88976,0.77165),(0.89764,0.77165),(0.90551,0.77165),(0.91339,0.77165),(0.92126,0.77165),(0.92913,0.77165),(0.93701,0.77165),(0.94488,0.77165),(0.95276,0.77165),(0.96063,0.77165),(0.9685,0.77165),(0.97638,0.77165),(0.98425,0.77165),(0.99213,0.77165),(0.99609,0.77165),(0.00391,0.77953),(0.00787,0.77953),(0.01575,0.77953),(0.02362,0.77953),(0.0315,0.77953),(0.03937,0.77953),(0.04724,0.77953),(0.05512,0.77953),(0.06299,0.77953),(0.07087,0.77953),(0.07874,0.77953),(0.08661,0.77953),(0.09449,0.77953),(0.10236,0.77953),(0.11024,0.77953),(0.11811,0.77953),(0.12598,0.77953),(0.13386,0.77953),(0.14173,0.77953),(0.14961,0.77953),(0.15748,0.77953),(0.16535,0.77953),(0.17323,0.77953),(0.1811,0.77953),(0.18898,0.77953),(0.19685,0.77953),(0.20472,0.77953),(0.2126,0.77953),(0.22047,0.77953),(0.22835,0.77953),(0.23622,0.77953),(0.24409,0.77953),(0.25197,0.77953),(0.25984,0.77953),(0.26772,0.77953),(0.27559,0.77953),(0.28346,0.77953),(0.29134,0.77953),(0.29921,0.77953),(0.30709,0.77953),(0.31496,0.77953),(0.32283,0.77953),(0.33071,0.77953),(0.33858,0.77953),(0.34646,0.77953),(0.35433,0.77953),(0.3622,0.77953),(0.37008,0.77953),(0.37795,0.77953),(0.38583,0.77953),(0.3937,0.77953),(0.40157,0.77953),(0.40945,0.77953),(0.41732,0.77953),(0.4252,0.77953),(0.43307,0.77953),(0.44094,0.77953),(0.44882,0.77953),(0.45669,0.77953),(0.46457,0.77953),(0.47244,0.77953),(0.48031,0.77953),(0.48819,0.77953),(0.49606,0.77953),(0.50394,0.77953),(0.51181,0.77953),(0.51969,0.77953),(0.52756,0.77953),(0.53543,0.77953),(0.54331,0.77953),(0.55118,0.77953),(0.55906,0.77953),(0.56693,0.77953),(0.5748,0.77953),(0.58268,0.77953),(0.59055,0.77953),(0.59843,0.77953),(0.6063,0.77953),(0.61417,0.77953),(0.62205,0.77953),(0.62992,0.77953),(0.6378,0.77953),(0.64567,0.77953),(0.65354,0.77953),(0.66142,0.77953),(0.66929,0.77953),(0.67717,0.77953),(0.68504,0.77953),(0.69291,0.77953),(0.70079,0.77953),(0.70866,0.77953),(0.71654,0.77953),(0.72441,0.77953),(0.73228,0.77953),(0.74016,0.77953),(0.74803,0.77953),(0.75591,0.77953),(0.76378,0.77953),(0.77165,0.77953),(0.77953,0.77953),(0.7874,0.77953),(0.79528,0.77953),(0.80315,0.77953),(0.81102,0.77953),(0.8189,0.77953),(0.82677,0.77953),(0.83465,0.77953),(0.84252,0.77953),(0.85039,0.77953),(0.85827,0.77953),(0.86614,0.77953),(0.87402,0.77953),(0.88189,0.77953),(0.88976,0.77953),(0.89764,0.77953),(0.90551,0.77953),(0.91339,0.77953),(0.92126,0.77953),(0.92913,0.77953),(0.93701,0.77953),(0.94488,0.77953),(0.95276,0.77953),(0.96063,0.77953),(0.9685,0.77953),(0.97638,0.77953),(0.98425,0.77953),(0.99213,0.77953),(0.99609,0.77953),(0.00391,0.7874),(0.00787,0.7874),(0.01575,0.7874),(0.02362,0.7874),(0.0315,0.7874),(0.03937,0.7874),(0.04724,0.7874),(0.05512,0.7874),(0.06299,0.7874),(0.07087,0.7874),(0.07874,0.7874),(0.08661,0.7874),(0.09449,0.7874),(0.10236,0.7874),(0.11024,0.7874),(0.11811,0.7874),(0.12598,0.7874),(0.13386,0.7874),(0.14173,0.7874),(0.14961,0.7874),(0.15748,0.7874),(0.16535,0.7874),(0.17323,0.7874),(0.1811,0.7874),(0.18898,0.7874),(0.19685,0.7874),(0.20472,0.7874),(0.2126,0.7874),(0.22047,0.7874),(0.22835,0.7874),(0.23622,0.7874),(0.24409,0.7874),(0.25197,0.7874),(0.25984,0.7874),(0.26772,0.7874),(0.27559,0.7874),(0.28346,0.7874),(0.29134,0.7874),(0.29921,0.7874),(0.30709,0.7874),(0.31496,0.7874),(0.32283,0.7874),(0.33071,0.7874),(0.33858,0.7874),(0.34646,0.7874),(0.35433,0.7874),(0.3622,0.7874),(0.37008,0.7874),(0.37795,0.7874),(0.38583,0.7874),(0.3937,0.7874),(0.40157,0.7874),(0.40945,0.7874),(0.41732,0.7874),(0.4252,0.7874),(0.43307,0.7874),(0.44094,0.7874),(0.44882,0.7874),(0.45669,0.7874),(0.46457,0.7874),(0.47244,0.7874),(0.48031,0.7874),(0.48819,0.7874),(0.49606,0.7874),(0.50394,0.7874),(0.51181,0.7874),(0.51969,0.7874),(0.52756,0.7874),(0.53543,0.7874),(0.54331,0.7874),(0.55118,0.7874),(0.55906,0.7874),(0.56693,0.7874),(0.5748,0.7874),(0.58268,0.7874),(0.59055,0.7874),(0.59843,0.7874),(0.6063,0.7874),(0.61417,0.7874),(0.62205,0.7874),(0.62992,0.7874),(0.6378,0.7874),(0.64567,0.7874),(0.65354,0.7874),(0.66142,0.7874),(0.66929,0.7874),(0.67717,0.7874),(0.68504,0.7874),(0.69291,0.7874),(0.70079,0.7874),(0.70866,0.7874),(0.71654,0.7874),(0.72441,0.7874),(0.73228,0.7874),(0.74016,0.7874),(0.74803,0.7874),(0.75591,0.7874),(0.76378,0.7874),(0.77165,0.7874),(0.77953,0.7874),(0.7874,0.7874),(0.79528,0.7874),(0.80315,0.7874),(0.81102,0.7874),(0.8189,0.7874),(0.82677,0.7874),(0.83465,0.7874),(0.84252,0.7874),(0.85039,0.7874),(0.85827,0.7874),(0.86614,0.7874),(0.87402,0.7874),(0.88189,0.7874),(0.88976,0.7874),(0.89764,0.7874),(0.90551,0.7874),(0.91339,0.7874),(0.92126,0.7874),(0.92913,0.7874),(0.93701,0.7874),(0.94488,0.7874),(0.95276,0.7874),(0.96063,0.7874),(0.9685,0.7874),(0.97638,0.7874),(0.98425,0.7874),(0.99213,0.7874),(0.99609,0.7874),(0.00391,0.79528),(0.00787,0.79528),(0.01575,0.79528),(0.02362,0.79528),(0.0315,0.79528),(0.03937,0.79528),(0.04724,0.79528),(0.05512,0.79528),(0.06299,0.79528),(0.07087,0.79528),(0.07874,0.79528),(0.08661,0.79528),(0.09449,0.79528),(0.10236,0.79528),(0.11024,0.79528),(0.11811,0.79528),(0.12598,0.79528),(0.13386,0.79528),(0.14173,0.79528),(0.14961,0.79528),(0.15748,0.79528),(0.16535,0.79528),(0.17323,0.79528),(0.1811,0.79528),(0.18898,0.79528),(0.19685,0.79528),(0.20472,0.79528),(0.2126,0.79528),(0.22047,0.79528),(0.22835,0.79528),(0.23622,0.79528),(0.24409,0.79528),(0.25197,0.79528),(0.25984,0.79528),(0.26772,0.79528),(0.27559,0.79528),(0.28346,0.79528),(0.29134,0.79528),(0.29921,0.79528),(0.30709,0.79528),(0.31496,0.79528),(0.32283,0.79528),(0.33071,0.79528),(0.33858,0.79528),(0.34646,0.79528),(0.35433,0.79528),(0.3622,0.79528),(0.37008,0.79528),(0.37795,0.79528),(0.38583,0.79528),(0.3937,0.79528),(0.40157,0.79528),(0.40945,0.79528),(0.41732,0.79528),(0.4252,0.79528),(0.43307,0.79528),(0.44094,0.79528),(0.44882,0.79528),(0.45669,0.79528),(0.46457,0.79528),(0.47244,0.79528),(0.48031,0.79528),(0.48819,0.79528),(0.49606,0.79528),(0.50394,0.79528),(0.51181,0.79528),(0.51969,0.79528),(0.52756,0.79528),(0.53543,0.79528),(0.54331,0.79528),(0.55118,0.79528),(0.55906,0.79528),(0.56693,0.79528),(0.5748,0.79528),(0.58268,0.79528),(0.59055,0.79528),(0.59843,0.79528),(0.6063,0.79528),(0.61417,0.79528),(0.62205,0.79528),(0.62992,0.79528),(0.6378,0.79528),(0.64567,0.79528),(0.65354,0.79528),(0.66142,0.79528),(0.66929,0.79528),(0.67717,0.79528),(0.68504,0.79528),(0.69291,0.79528),(0.70079,0.79528),(0.70866,0.79528),(0.71654,0.79528),(0.72441,0.79528),(0.73228,0.79528),(0.74016,0.79528),(0.74803,0.79528),(0.75591,0.79528),(0.76378,0.79528),(0.77165,0.79528),(0.77953,0.79528),(0.7874,0.79528),(0.79528,0.79528),(0.80315,0.79528),(0.81102,0.79528),(0.8189,0.79528),(0.82677,0.79528),(0.83465,0.79528),(0.84252,0.79528),(0.85039,0.79528),(0.85827,0.79528),(0.86614,0.79528),(0.87402,0.79528),(0.88189,0.79528),(0.88976,0.79528),(0.89764,0.79528),(0.90551,0.79528),(0.91339,0.79528),(0.92126,0.79528),(0.92913,0.79528),(0.93701,0.79528),(0.94488,0.79528),(0.95276,0.79528),(0.96063,0.79528),(0.9685,0.79528),(0.97638,0.79528),(0.98425,0.79528),(0.99213,0.79528),(0.99609,0.79528),(0.00391,0.80315),(0.00787,0.80315),(0.01575,0.80315),(0.02362,0.80315),(0.0315,0.80315),(0.03937,0.80315),(0.04724,0.80315),(0.05512,0.80315),(0.06299,0.80315),(0.07087,0.80315),(0.07874,0.80315),(0.08661,0.80315),(0.09449,0.80315),(0.10236,0.80315),(0.11024,0.80315),(0.11811,0.80315),(0.12598,0.80315),(0.13386,0.80315),(0.14173,0.80315),(0.14961,0.80315),(0.15748,0.80315),(0.16535,0.80315),(0.17323,0.80315),(0.1811,0.80315),(0.18898,0.80315),(0.19685,0.80315),(0.20472,0.80315),(0.2126,0.80315),(0.22047,0.80315),(0.22835,0.80315),(0.23622,0.80315),(0.24409,0.80315),(0.25197,0.80315),(0.25984,0.80315),(0.26772,0.80315),(0.27559,0.80315),(0.28346,0.80315),(0.29134,0.80315),(0.29921,0.80315),(0.30709,0.80315),(0.31496,0.80315),(0.32283,0.80315),(0.33071,0.80315),(0.33858,0.80315),(0.34646,0.80315),(0.35433,0.80315),(0.3622,0.80315),(0.37008,0.80315),(0.37795,0.80315),(0.38583,0.80315),(0.3937,0.80315),(0.40157,0.80315),(0.40945,0.80315),(0.41732,0.80315),(0.4252,0.80315),(0.43307,0.80315),(0.44094,0.80315),(0.44882,0.80315),(0.45669,0.80315),(0.46457,0.80315),(0.47244,0.80315),(0.48031,0.80315),(0.48819,0.80315),(0.49606,0.80315),(0.50394,0.80315),(0.51181,0.80315),(0.51969,0.80315),(0.52756,0.80315),(0.53543,0.80315),(0.54331,0.80315),(0.55118,0.80315),(0.55906,0.80315),(0.56693,0.80315),(0.5748,0.80315),(0.58268,0.80315),(0.59055,0.80315),(0.59843,0.80315),(0.6063,0.80315),(0.61417,0.80315),(0.62205,0.80315),(0.62992,0.80315),(0.6378,0.80315),(0.64567,0.80315),(0.65354,0.80315),(0.66142,0.80315),(0.66929,0.80315),(0.67717,0.80315),(0.68504,0.80315),(0.69291,0.80315),(0.70079,0.80315),(0.70866,0.80315),(0.71654,0.80315),(0.72441,0.80315),(0.73228,0.80315),(0.74016,0.80315),(0.74803,0.80315),(0.75591,0.80315),(0.76378,0.80315),(0.77165,0.80315),(0.77953,0.80315),(0.7874,0.80315),(0.79528,0.80315),(0.80315,0.80315),(0.81102,0.80315),(0.8189,0.80315),(0.82677,0.80315),(0.83465,0.80315),(0.84252,0.80315),(0.85039,0.80315),(0.85827,0.80315),(0.86614,0.80315),(0.87402,0.80315),(0.88189,0.80315),(0.88976,0.80315),(0.89764,0.80315),(0.90551,0.80315),(0.91339,0.80315),(0.92126,0.80315),(0.92913,0.80315),(0.93701,0.80315),(0.94488,0.80315),(0.95276,0.80315),(0.96063,0.80315),(0.9685,0.80315),(0.97638,0.80315),(0.98425,0.80315),(0.99213,0.80315),(0.99609,0.80315),(0.00391,0.81102),(0.00787,0.81102),(0.01575,0.81102),(0.02362,0.81102),(0.0315,0.81102),(0.03937,0.81102),(0.04724,0.81102),(0.05512,0.81102),(0.06299,0.81102),(0.07087,0.81102),(0.07874,0.81102),(0.08661,0.81102),(0.09449,0.81102),(0.10236,0.81102),(0.11024,0.81102),(0.11811,0.81102),(0.12598,0.81102),(0.13386,0.81102),(0.14173,0.81102),(0.14961,0.81102),(0.15748,0.81102),(0.16535,0.81102),(0.17323,0.81102),(0.1811,0.81102),(0.18898,0.81102),(0.19685,0.81102),(0.20472,0.81102),(0.2126,0.81102),(0.22047,0.81102),(0.22835,0.81102),(0.23622,0.81102),(0.24409,0.81102),(0.25197,0.81102),(0.25984,0.81102),(0.26772,0.81102),(0.27559,0.81102),(0.28346,0.81102),(0.29134,0.81102),(0.29921,0.81102),(0.30709,0.81102),(0.31496,0.81102),(0.32283,0.81102),(0.33071,0.81102),(0.33858,0.81102),(0.34646,0.81102),(0.35433,0.81102),(0.3622,0.81102),(0.37008,0.81102),(0.37795,0.81102),(0.38583,0.81102),(0.3937,0.81102),(0.40157,0.81102),(0.40945,0.81102),(0.41732,0.81102),(0.4252,0.81102),(0.43307,0.81102),(0.44094,0.81102),(0.44882,0.81102),(0.45669,0.81102),(0.46457,0.81102),(0.47244,0.81102),(0.48031,0.81102),(0.48819,0.81102),(0.49606,0.81102),(0.50394,0.81102),(0.51181,0.81102),(0.51969,0.81102),(0.52756,0.81102),(0.53543,0.81102),(0.54331,0.81102),(0.55118,0.81102),(0.55906,0.81102),(0.56693,0.81102),(0.5748,0.81102),(0.58268,0.81102),(0.59055,0.81102),(0.59843,0.81102),(0.6063,0.81102),(0.61417,0.81102),(0.62205,0.81102),(0.62992,0.81102),(0.6378,0.81102),(0.64567,0.81102),(0.65354,0.81102),(0.66142,0.81102),(0.66929,0.81102),(0.67717,0.81102),(0.68504,0.81102),(0.69291,0.81102),(0.70079,0.81102),(0.70866,0.81102),(0.71654,0.81102),(0.72441,0.81102),(0.73228,0.81102),(0.74016,0.81102),(0.74803,0.81102),(0.75591,0.81102),(0.76378,0.81102),(0.77165,0.81102),(0.77953,0.81102),(0.7874,0.81102),(0.79528,0.81102),(0.80315,0.81102),(0.81102,0.81102),(0.8189,0.81102),(0.82677,0.81102),(0.83465,0.81102),(0.84252,0.81102),(0.85039,0.81102),(0.85827,0.81102),(0.86614,0.81102),(0.87402,0.81102),(0.88189,0.81102),(0.88976,0.81102),(0.89764,0.81102),(0.90551,0.81102),(0.91339,0.81102),(0.92126,0.81102),(0.92913,0.81102),(0.93701,0.81102),(0.94488,0.81102),(0.95276,0.81102),(0.96063,0.81102),(0.9685,0.81102),(0.97638,0.81102),(0.98425,0.81102),(0.99213,0.81102),(0.99609,0.81102),(0.00391,0.8189),(0.00787,0.8189),(0.01575,0.8189),(0.02362,0.8189),(0.0315,0.8189),(0.03937,0.8189),(0.04724,0.8189),(0.05512,0.8189),(0.06299,0.8189),(0.07087,0.8189),(0.07874,0.8189),(0.08661,0.8189),(0.09449,0.8189),(0.10236,0.8189),(0.11024,0.8189),(0.11811,0.8189),(0.12598,0.8189),(0.13386,0.8189),(0.14173,0.8189),(0.14961,0.8189),(0.15748,0.8189),(0.16535,0.8189),(0.17323,0.8189),(0.1811,0.8189),(0.18898,0.8189),(0.19685,0.8189),(0.20472,0.8189),(0.2126,0.8189),(0.22047,0.8189),(0.22835,0.8189),(0.23622,0.8189),(0.24409,0.8189),(0.25197,0.8189),(0.25984,0.8189),(0.26772,0.8189),(0.27559,0.8189),(0.28346,0.8189),(0.29134,0.8189),(0.29921,0.8189),(0.30709,0.8189),(0.31496,0.8189),(0.32283,0.8189),(0.33071,0.8189),(0.33858,0.8189),(0.34646,0.8189),(0.35433,0.8189),(0.3622,0.8189),(0.37008,0.8189),(0.37795,0.8189),(0.38583,0.8189),(0.3937,0.8189),(0.40157,0.8189),(0.40945,0.8189),(0.41732,0.8189),(0.4252,0.8189),(0.43307,0.8189),(0.44094,0.8189),(0.44882,0.8189),(0.45669,0.8189),(0.46457,0.8189),(0.47244,0.8189),(0.48031,0.8189),(0.48819,0.8189),(0.49606,0.8189),(0.50394,0.8189),(0.51181,0.8189),(0.51969,0.8189),(0.52756,0.8189),(0.53543,0.8189),(0.54331,0.8189),(0.55118,0.8189),(0.55906,0.8189),(0.56693,0.8189),(0.5748,0.8189),(0.58268,0.8189),(0.59055,0.8189),(0.59843,0.8189),(0.6063,0.8189),(0.61417,0.8189),(0.62205,0.8189),(0.62992,0.8189),(0.6378,0.8189),(0.64567,0.8189),(0.65354,0.8189),(0.66142,0.8189),(0.66929,0.8189),(0.67717,0.8189),(0.68504,0.8189),(0.69291,0.8189),(0.70079,0.8189),(0.70866,0.8189),(0.71654,0.8189),(0.72441,0.8189),(0.73228,0.8189),(0.74016,0.8189),(0.74803,0.8189),(0.75591,0.8189),(0.76378,0.8189),(0.77165,0.8189),(0.77953,0.8189),(0.7874,0.8189),(0.79528,0.8189),(0.80315,0.8189),(0.81102,0.8189),(0.8189,0.8189),(0.82677,0.8189),(0.83465,0.8189),(0.84252,0.8189),(0.85039,0.8189),(0.85827,0.8189),(0.86614,0.8189),(0.87402,0.8189),(0.88189,0.8189),(0.88976,0.8189),(0.89764,0.8189),(0.90551,0.8189),(0.91339,0.8189),(0.92126,0.8189),(0.92913,0.8189),(0.93701,0.8189),(0.94488,0.8189),(0.95276,0.8189),(0.96063,0.8189),(0.9685,0.8189),(0.97638,0.8189),(0.98425,0.8189),(0.99213,0.8189),(0.99609,0.8189),(0.00391,0.82677),(0.00787,0.82677),(0.01575,0.82677),(0.02362,0.82677),(0.0315,0.82677),(0.03937,0.82677),(0.04724,0.82677),(0.05512,0.82677),(0.06299,0.82677),(0.07087,0.82677),(0.07874,0.82677),(0.08661,0.82677),(0.09449,0.82677),(0.10236,0.82677),(0.11024,0.82677),(0.11811,0.82677),(0.12598,0.82677),(0.13386,0.82677),(0.14173,0.82677),(0.14961,0.82677),(0.15748,0.82677),(0.16535,0.82677),(0.17323,0.82677),(0.1811,0.82677),(0.18898,0.82677),(0.19685,0.82677),(0.20472,0.82677),(0.2126,0.82677),(0.22047,0.82677),(0.22835,0.82677),(0.23622,0.82677),(0.24409,0.82677),(0.25197,0.82677),(0.25984,0.82677),(0.26772,0.82677),(0.27559,0.82677),(0.28346,0.82677),(0.29134,0.82677),(0.29921,0.82677),(0.30709,0.82677),(0.31496,0.82677),(0.32283,0.82677),(0.33071,0.82677),(0.33858,0.82677),(0.34646,0.82677),(0.35433,0.82677),(0.3622,0.82677),(0.37008,0.82677),(0.37795,0.82677),(0.38583,0.82677),(0.3937,0.82677),(0.40157,0.82677),(0.40945,0.82677),(0.41732,0.82677),(0.4252,0.82677),(0.43307,0.82677),(0.44094,0.82677),(0.44882,0.82677),(0.45669,0.82677),(0.46457,0.82677),(0.47244,0.82677),(0.48031,0.82677),(0.48819,0.82677),(0.49606,0.82677),(0.50394,0.82677),(0.51181,0.82677),(0.51969,0.82677),(0.52756,0.82677),(0.53543,0.82677),(0.54331,0.82677),(0.55118,0.82677),(0.55906,0.82677),(0.56693,0.82677),(0.5748,0.82677),(0.58268,0.82677),(0.59055,0.82677),(0.59843,0.82677),(0.6063,0.82677),(0.61417,0.82677),(0.62205,0.82677),(0.62992,0.82677),(0.6378,0.82677),(0.64567,0.82677),(0.65354,0.82677),(0.66142,0.82677),(0.66929,0.82677),(0.67717,0.82677),(0.68504,0.82677),(0.69291,0.82677),(0.70079,0.82677),(0.70866,0.82677),(0.71654,0.82677),(0.72441,0.82677),(0.73228,0.82677),(0.74016,0.82677),(0.74803,0.82677),(0.75591,0.82677),(0.76378,0.82677),(0.77165,0.82677),(0.77953,0.82677),(0.7874,0.82677),(0.79528,0.82677),(0.80315,0.82677),(0.81102,0.82677),(0.8189,0.82677),(0.82677,0.82677),(0.83465,0.82677),(0.84252,0.82677),(0.85039,0.82677),(0.85827,0.82677),(0.86614,0.82677),(0.87402,0.82677),(0.88189,0.82677),(0.88976,0.82677),(0.89764,0.82677),(0.90551,0.82677),(0.91339,0.82677),(0.92126,0.82677),(0.92913,0.82677),(0.93701,0.82677),(0.94488,0.82677),(0.95276,0.82677),(0.96063,0.82677),(0.9685,0.82677),(0.97638,0.82677),(0.98425,0.82677),(0.99213,0.82677),(0.99609,0.82677),(0.00391,0.83465),(0.00787,0.83465),(0.01575,0.83465),(0.02362,0.83465),(0.0315,0.83465),(0.03937,0.83465),(0.04724,0.83465),(0.05512,0.83465),(0.06299,0.83465),(0.07087,0.83465),(0.07874,0.83465),(0.08661,0.83465),(0.09449,0.83465),(0.10236,0.83465),(0.11024,0.83465),(0.11811,0.83465),(0.12598,0.83465),(0.13386,0.83465),(0.14173,0.83465),(0.14961,0.83465),(0.15748,0.83465),(0.16535,0.83465),(0.17323,0.83465),(0.1811,0.83465),(0.18898,0.83465),(0.19685,0.83465),(0.20472,0.83465),(0.2126,0.83465),(0.22047,0.83465),(0.22835,0.83465),(0.23622,0.83465),(0.24409,0.83465),(0.25197,0.83465),(0.25984,0.83465),(0.26772,0.83465),(0.27559,0.83465),(0.28346,0.83465),(0.29134,0.83465),(0.29921,0.83465),(0.30709,0.83465),(0.31496,0.83465),(0.32283,0.83465),(0.33071,0.83465),(0.33858,0.83465),(0.34646,0.83465),(0.35433,0.83465),(0.3622,0.83465),(0.37008,0.83465),(0.37795,0.83465),(0.38583,0.83465),(0.3937,0.83465),(0.40157,0.83465),(0.40945,0.83465),(0.41732,0.83465),(0.4252,0.83465),(0.43307,0.83465),(0.44094,0.83465),(0.44882,0.83465),(0.45669,0.83465),(0.46457,0.83465),(0.47244,0.83465),(0.48031,0.83465),(0.48819,0.83465),(0.49606,0.83465),(0.50394,0.83465),(0.51181,0.83465),(0.51969,0.83465),(0.52756,0.83465),(0.53543,0.83465),(0.54331,0.83465),(0.55118,0.83465),(0.55906,0.83465),(0.56693,0.83465),(0.5748,0.83465),(0.58268,0.83465),(0.59055,0.83465),(0.59843,0.83465),(0.6063,0.83465),(0.61417,0.83465),(0.62205,0.83465),(0.62992,0.83465),(0.6378,0.83465),(0.64567,0.83465),(0.65354,0.83465),(0.66142,0.83465),(0.66929,0.83465),(0.67717,0.83465),(0.68504,0.83465),(0.69291,0.83465),(0.70079,0.83465),(0.70866,0.83465),(0.71654,0.83465),(0.72441,0.83465),(0.73228,0.83465),(0.74016,0.83465),(0.74803,0.83465),(0.75591,0.83465),(0.76378,0.83465),(0.77165,0.83465),(0.77953,0.83465),(0.7874,0.83465),(0.79528,0.83465),(0.80315,0.83465),(0.81102,0.83465),(0.8189,0.83465),(0.82677,0.83465),(0.83465,0.83465),(0.84252,0.83465),(0.85039,0.83465),(0.85827,0.83465),(0.86614,0.83465),(0.87402,0.83465),(0.88189,0.83465),(0.88976,0.83465),(0.89764,0.83465),(0.90551,0.83465),(0.91339,0.83465),(0.92126,0.83465),(0.92913,0.83465),(0.93701,0.83465),(0.94488,0.83465),(0.95276,0.83465),(0.96063,0.83465),(0.9685,0.83465),(0.97638,0.83465),(0.98425,0.83465),(0.99213,0.83465),(0.99609,0.83465),(0.00391,0.84252),(0.00787,0.84252),(0.01575,0.84252),(0.02362,0.84252),(0.0315,0.84252),(0.03937,0.84252),(0.04724,0.84252),(0.05512,0.84252),(0.06299,0.84252),(0.07087,0.84252),(0.07874,0.84252),(0.08661,0.84252),(0.09449,0.84252),(0.10236,0.84252),(0.11024,0.84252),(0.11811,0.84252),(0.12598,0.84252),(0.13386,0.84252),(0.14173,0.84252),(0.14961,0.84252),(0.15748,0.84252),(0.16535,0.84252),(0.17323,0.84252),(0.1811,0.84252),(0.18898,0.84252),(0.19685,0.84252),(0.20472,0.84252),(0.2126,0.84252),(0.22047,0.84252),(0.22835,0.84252),(0.23622,0.84252),(0.24409,0.84252),(0.25197,0.84252),(0.25984,0.84252),(0.26772,0.84252),(0.27559,0.84252),(0.28346,0.84252),(0.29134,0.84252),(0.29921,0.84252),(0.30709,0.84252),(0.31496,0.84252),(0.32283,0.84252),(0.33071,0.84252),(0.33858,0.84252),(0.34646,0.84252),(0.35433,0.84252),(0.3622,0.84252),(0.37008,0.84252),(0.37795,0.84252),(0.38583,0.84252),(0.3937,0.84252),(0.40157,0.84252),(0.40945,0.84252),(0.41732,0.84252),(0.4252,0.84252),(0.43307,0.84252),(0.44094,0.84252),(0.44882,0.84252),(0.45669,0.84252),(0.46457,0.84252),(0.47244,0.84252),(0.48031,0.84252),(0.48819,0.84252),(0.49606,0.84252),(0.50394,0.84252),(0.51181,0.84252),(0.51969,0.84252),(0.52756,0.84252),(0.53543,0.84252),(0.54331,0.84252),(0.55118,0.84252),(0.55906,0.84252),(0.56693,0.84252),(0.5748,0.84252),(0.58268,0.84252),(0.59055,0.84252),(0.59843,0.84252),(0.6063,0.84252),(0.61417,0.84252),(0.62205,0.84252),(0.62992,0.84252),(0.6378,0.84252),(0.64567,0.84252),(0.65354,0.84252),(0.66142,0.84252),(0.66929,0.84252),(0.67717,0.84252),(0.68504,0.84252),(0.69291,0.84252),(0.70079,0.84252),(0.70866,0.84252),(0.71654,0.84252),(0.72441,0.84252),(0.73228,0.84252),(0.74016,0.84252),(0.74803,0.84252),(0.75591,0.84252),(0.76378,0.84252),(0.77165,0.84252),(0.77953,0.84252),(0.7874,0.84252),(0.79528,0.84252),(0.80315,0.84252),(0.81102,0.84252),(0.8189,0.84252),(0.82677,0.84252),(0.83465,0.84252),(0.84252,0.84252),(0.85039,0.84252),(0.85827,0.84252),(0.86614,0.84252),(0.87402,0.84252),(0.88189,0.84252),(0.88976,0.84252),(0.89764,0.84252),(0.90551,0.84252),(0.91339,0.84252),(0.92126,0.84252),(0.92913,0.84252),(0.93701,0.84252),(0.94488,0.84252),(0.95276,0.84252),(0.96063,0.84252),(0.9685,0.84252),(0.97638,0.84252),(0.98425,0.84252),(0.99213,0.84252),(0.99609,0.84252),(0.00391,0.85039),(0.00787,0.85039),(0.01575,0.85039),(0.02362,0.85039),(0.0315,0.85039),(0.03937,0.85039),(0.04724,0.85039),(0.05512,0.85039),(0.06299,0.85039),(0.07087,0.85039),(0.07874,0.85039),(0.08661,0.85039),(0.09449,0.85039),(0.10236,0.85039),(0.11024,0.85039),(0.11811,0.85039),(0.12598,0.85039),(0.13386,0.85039),(0.14173,0.85039),(0.14961,0.85039),(0.15748,0.85039),(0.16535,0.85039),(0.17323,0.85039),(0.1811,0.85039),(0.18898,0.85039),(0.19685,0.85039),(0.20472,0.85039),(0.2126,0.85039),(0.22047,0.85039),(0.22835,0.85039),(0.23622,0.85039),(0.24409,0.85039),(0.25197,0.85039),(0.25984,0.85039),(0.26772,0.85039),(0.27559,0.85039),(0.28346,0.85039),(0.29134,0.85039),(0.29921,0.85039),(0.30709,0.85039),(0.31496,0.85039),(0.32283,0.85039),(0.33071,0.85039),(0.33858,0.85039),(0.34646,0.85039),(0.35433,0.85039),(0.3622,0.85039),(0.37008,0.85039),(0.37795,0.85039),(0.38583,0.85039),(0.3937,0.85039),(0.40157,0.85039),(0.40945,0.85039),(0.41732,0.85039),(0.4252,0.85039),(0.43307,0.85039),(0.44094,0.85039),(0.44882,0.85039),(0.45669,0.85039),(0.46457,0.85039),(0.47244,0.85039),(0.48031,0.85039),(0.48819,0.85039),(0.49606,0.85039),(0.50394,0.85039),(0.51181,0.85039),(0.51969,0.85039),(0.52756,0.85039),(0.53543,0.85039),(0.54331,0.85039),(0.55118,0.85039),(0.55906,0.85039),(0.56693,0.85039),(0.5748,0.85039),(0.58268,0.85039),(0.59055,0.85039),(0.59843,0.85039),(0.6063,0.85039),(0.61417,0.85039),(0.62205,0.85039),(0.62992,0.85039),(0.6378,0.85039),(0.64567,0.85039),(0.65354,0.85039),(0.66142,0.85039),(0.66929,0.85039),(0.67717,0.85039),(0.68504,0.85039),(0.69291,0.85039),(0.70079,0.85039),(0.70866,0.85039),(0.71654,0.85039),(0.72441,0.85039),(0.73228,0.85039),(0.74016,0.85039),(0.74803,0.85039),(0.75591,0.85039),(0.76378,0.85039),(0.77165,0.85039),(0.77953,0.85039),(0.7874,0.85039),(0.79528,0.85039),(0.80315,0.85039),(0.81102,0.85039),(0.8189,0.85039),(0.82677,0.85039),(0.83465,0.85039),(0.84252,0.85039),(0.85039,0.85039),(0.85827,0.85039),(0.86614,0.85039),(0.87402,0.85039),(0.88189,0.85039),(0.88976,0.85039),(0.89764,0.85039),(0.90551,0.85039),(0.91339,0.85039),(0.92126,0.85039),(0.92913,0.85039),(0.93701,0.85039),(0.94488,0.85039),(0.95276,0.85039),(0.96063,0.85039),(0.9685,0.85039),(0.97638,0.85039),(0.98425,0.85039),(0.99213,0.85039),(0.99609,0.85039),(0.00391,0.85827),(0.00787,0.85827),(0.01575,0.85827),(0.02362,0.85827),(0.0315,0.85827),(0.03937,0.85827),(0.04724,0.85827),(0.05512,0.85827),(0.06299,0.85827),(0.07087,0.85827),(0.07874,0.85827),(0.08661,0.85827),(0.09449,0.85827),(0.10236,0.85827),(0.11024,0.85827),(0.11811,0.85827),(0.12598,0.85827),(0.13386,0.85827),(0.14173,0.85827),(0.14961,0.85827),(0.15748,0.85827),(0.16535,0.85827),(0.17323,0.85827),(0.1811,0.85827),(0.18898,0.85827),(0.19685,0.85827),(0.20472,0.85827),(0.2126,0.85827),(0.22047,0.85827),(0.22835,0.85827),(0.23622,0.85827),(0.24409,0.85827),(0.25197,0.85827),(0.25984,0.85827),(0.26772,0.85827),(0.27559,0.85827),(0.28346,0.85827),(0.29134,0.85827),(0.29921,0.85827),(0.30709,0.85827),(0.31496,0.85827),(0.32283,0.85827),(0.33071,0.85827),(0.33858,0.85827),(0.34646,0.85827),(0.35433,0.85827),(0.3622,0.85827),(0.37008,0.85827),(0.37795,0.85827),(0.38583,0.85827),(0.3937,0.85827),(0.40157,0.85827),(0.40945,0.85827),(0.41732,0.85827),(0.4252,0.85827),(0.43307,0.85827),(0.44094,0.85827),(0.44882,0.85827),(0.45669,0.85827),(0.46457,0.85827),(0.47244,0.85827),(0.48031,0.85827),(0.48819,0.85827),(0.49606,0.85827),(0.50394,0.85827),(0.51181,0.85827),(0.51969,0.85827),(0.52756,0.85827),(0.53543,0.85827),(0.54331,0.85827),(0.55118,0.85827),(0.55906,0.85827),(0.56693,0.85827),(0.5748,0.85827),(0.58268,0.85827),(0.59055,0.85827),(0.59843,0.85827),(0.6063,0.85827),(0.61417,0.85827),(0.62205,0.85827),(0.62992,0.85827),(0.6378,0.85827),(0.64567,0.85827),(0.65354,0.85827),(0.66142,0.85827),(0.66929,0.85827),(0.67717,0.85827),(0.68504,0.85827),(0.69291,0.85827),(0.70079,0.85827),(0.70866,0.85827),(0.71654,0.85827),(0.72441,0.85827),(0.73228,0.85827),(0.74016,0.85827),(0.74803,0.85827),(0.75591,0.85827),(0.76378,0.85827),(0.77165,0.85827),(0.77953,0.85827),(0.7874,0.85827),(0.79528,0.85827),(0.80315,0.85827),(0.81102,0.85827),(0.8189,0.85827),(0.82677,0.85827),(0.83465,0.85827),(0.84252,0.85827),(0.85039,0.85827),(0.85827,0.85827),(0.86614,0.85827),(0.87402,0.85827),(0.88189,0.85827),(0.88976,0.85827),(0.89764,0.85827),(0.90551,0.85827),(0.91339,0.85827),(0.92126,0.85827),(0.92913,0.85827),(0.93701,0.85827),(0.94488,0.85827),(0.95276,0.85827),(0.96063,0.85827),(0.9685,0.85827),(0.97638,0.85827),(0.98425,0.85827),(0.99213,0.85827),(0.99609,0.85827),(0.00391,0.86614),(0.00787,0.86614),(0.01575,0.86614),(0.02362,0.86614),(0.0315,0.86614),(0.03937,0.86614),(0.04724,0.86614),(0.05512,0.86614),(0.06299,0.86614),(0.07087,0.86614),(0.07874,0.86614),(0.08661,0.86614),(0.09449,0.86614),(0.10236,0.86614),(0.11024,0.86614),(0.11811,0.86614),(0.12598,0.86614),(0.13386,0.86614),(0.14173,0.86614),(0.14961,0.86614),(0.15748,0.86614),(0.16535,0.86614),(0.17323,0.86614),(0.1811,0.86614),(0.18898,0.86614),(0.19685,0.86614),(0.20472,0.86614),(0.2126,0.86614),(0.22047,0.86614),(0.22835,0.86614),(0.23622,0.86614),(0.24409,0.86614),(0.25197,0.86614),(0.25984,0.86614),(0.26772,0.86614),(0.27559,0.86614),(0.28346,0.86614),(0.29134,0.86614),(0.29921,0.86614),(0.30709,0.86614),(0.31496,0.86614),(0.32283,0.86614),(0.33071,0.86614),(0.33858,0.86614),(0.34646,0.86614),(0.35433,0.86614),(0.3622,0.86614),(0.37008,0.86614),(0.37795,0.86614),(0.38583,0.86614),(0.3937,0.86614),(0.40157,0.86614),(0.40945,0.86614),(0.41732,0.86614),(0.4252,0.86614),(0.43307,0.86614),(0.44094,0.86614),(0.44882,0.86614),(0.45669,0.86614),(0.46457,0.86614),(0.47244,0.86614),(0.48031,0.86614),(0.48819,0.86614),(0.49606,0.86614),(0.50394,0.86614),(0.51181,0.86614),(0.51969,0.86614),(0.52756,0.86614),(0.53543,0.86614),(0.54331,0.86614),(0.55118,0.86614),(0.55906,0.86614),(0.56693,0.86614),(0.5748,0.86614),(0.58268,0.86614),(0.59055,0.86614),(0.59843,0.86614),(0.6063,0.86614),(0.61417,0.86614),(0.62205,0.86614),(0.62992,0.86614),(0.6378,0.86614),(0.64567,0.86614),(0.65354,0.86614),(0.66142,0.86614),(0.66929,0.86614),(0.67717,0.86614),(0.68504,0.86614),(0.69291,0.86614),(0.70079,0.86614),(0.70866,0.86614),(0.71654,0.86614),(0.72441,0.86614),(0.73228,0.86614),(0.74016,0.86614),(0.74803,0.86614),(0.75591,0.86614),(0.76378,0.86614),(0.77165,0.86614),(0.77953,0.86614),(0.7874,0.86614),(0.79528,0.86614),(0.80315,0.86614),(0.81102,0.86614),(0.8189,0.86614),(0.82677,0.86614),(0.83465,0.86614),(0.84252,0.86614),(0.85039,0.86614),(0.85827,0.86614),(0.86614,0.86614),(0.87402,0.86614),(0.88189,0.86614),(0.88976,0.86614),(0.89764,0.86614),(0.90551,0.86614),(0.91339,0.86614),(0.92126,0.86614),(0.92913,0.86614),(0.93701,0.86614),(0.94488,0.86614),(0.95276,0.86614),(0.96063,0.86614),(0.9685,0.86614),(0.97638,0.86614),(0.98425,0.86614),(0.99213,0.86614),(0.99609,0.86614),(0.00391,0.87402),(0.00787,0.87402),(0.01575,0.87402),(0.02362,0.87402),(0.0315,0.87402),(0.03937,0.87402),(0.04724,0.87402),(0.05512,0.87402),(0.06299,0.87402),(0.07087,0.87402),(0.07874,0.87402),(0.08661,0.87402),(0.09449,0.87402),(0.10236,0.87402),(0.11024,0.87402),(0.11811,0.87402),(0.12598,0.87402),(0.13386,0.87402),(0.14173,0.87402),(0.14961,0.87402),(0.15748,0.87402),(0.16535,0.87402),(0.17323,0.87402),(0.1811,0.87402),(0.18898,0.87402),(0.19685,0.87402),(0.20472,0.87402),(0.2126,0.87402),(0.22047,0.87402),(0.22835,0.87402),(0.23622,0.87402),(0.24409,0.87402),(0.25197,0.87402),(0.25984,0.87402),(0.26772,0.87402),(0.27559,0.87402),(0.28346,0.87402),(0.29134,0.87402),(0.29921,0.87402),(0.30709,0.87402),(0.31496,0.87402),(0.32283,0.87402),(0.33071,0.87402),(0.33858,0.87402),(0.34646,0.87402),(0.35433,0.87402),(0.3622,0.87402),(0.37008,0.87402),(0.37795,0.87402),(0.38583,0.87402),(0.3937,0.87402),(0.40157,0.87402),(0.40945,0.87402),(0.41732,0.87402),(0.4252,0.87402),(0.43307,0.87402),(0.44094,0.87402),(0.44882,0.87402),(0.45669,0.87402),(0.46457,0.87402),(0.47244,0.87402),(0.48031,0.87402),(0.48819,0.87402),(0.49606,0.87402),(0.50394,0.87402),(0.51181,0.87402),(0.51969,0.87402),(0.52756,0.87402),(0.53543,0.87402),(0.54331,0.87402),(0.55118,0.87402),(0.55906,0.87402),(0.56693,0.87402),(0.5748,0.87402),(0.58268,0.87402),(0.59055,0.87402),(0.59843,0.87402),(0.6063,0.87402),(0.61417,0.87402),(0.62205,0.87402),(0.62992,0.87402),(0.6378,0.87402),(0.64567,0.87402),(0.65354,0.87402),(0.66142,0.87402),(0.66929,0.87402),(0.67717,0.87402),(0.68504,0.87402),(0.69291,0.87402),(0.70079,0.87402),(0.70866,0.87402),(0.71654,0.87402),(0.72441,0.87402),(0.73228,0.87402),(0.74016,0.87402),(0.74803,0.87402),(0.75591,0.87402),(0.76378,0.87402),(0.77165,0.87402),(0.77953,0.87402),(0.7874,0.87402),(0.79528,0.87402),(0.80315,0.87402),(0.81102,0.87402),(0.8189,0.87402),(0.82677,0.87402),(0.83465,0.87402),(0.84252,0.87402),(0.85039,0.87402),(0.85827,0.87402),(0.86614,0.87402),(0.87402,0.87402),(0.88189,0.87402),(0.88976,0.87402),(0.89764,0.87402),(0.90551,0.87402),(0.91339,0.87402),(0.92126,0.87402),(0.92913,0.87402),(0.93701,0.87402),(0.94488,0.87402),(0.95276,0.87402),(0.96063,0.87402),(0.9685,0.87402),(0.97638,0.87402),(0.98425,0.87402),(0.99213,0.87402),(0.99609,0.87402),(0.00391,0.88189),(0.00787,0.88189),(0.01575,0.88189),(0.02362,0.88189),(0.0315,0.88189),(0.03937,0.88189),(0.04724,0.88189),(0.05512,0.88189),(0.06299,0.88189),(0.07087,0.88189),(0.07874,0.88189),(0.08661,0.88189),(0.09449,0.88189),(0.10236,0.88189),(0.11024,0.88189),(0.11811,0.88189),(0.12598,0.88189),(0.13386,0.88189),(0.14173,0.88189),(0.14961,0.88189),(0.15748,0.88189),(0.16535,0.88189),(0.17323,0.88189),(0.1811,0.88189),(0.18898,0.88189),(0.19685,0.88189),(0.20472,0.88189),(0.2126,0.88189),(0.22047,0.88189),(0.22835,0.88189),(0.23622,0.88189),(0.24409,0.88189),(0.25197,0.88189),(0.25984,0.88189),(0.26772,0.88189),(0.27559,0.88189),(0.28346,0.88189),(0.29134,0.88189),(0.29921,0.88189),(0.30709,0.88189),(0.31496,0.88189),(0.32283,0.88189),(0.33071,0.88189),(0.33858,0.88189),(0.34646,0.88189),(0.35433,0.88189),(0.3622,0.88189),(0.37008,0.88189),(0.37795,0.88189),(0.38583,0.88189),(0.3937,0.88189),(0.40157,0.88189),(0.40945,0.88189),(0.41732,0.88189),(0.4252,0.88189),(0.43307,0.88189),(0.44094,0.88189),(0.44882,0.88189),(0.45669,0.88189),(0.46457,0.88189),(0.47244,0.88189),(0.48031,0.88189),(0.48819,0.88189),(0.49606,0.88189),(0.50394,0.88189),(0.51181,0.88189),(0.51969,0.88189),(0.52756,0.88189),(0.53543,0.88189),(0.54331,0.88189),(0.55118,0.88189),(0.55906,0.88189),(0.56693,0.88189),(0.5748,0.88189),(0.58268,0.88189),(0.59055,0.88189),(0.59843,0.88189),(0.6063,0.88189),(0.61417,0.88189),(0.62205,0.88189),(0.62992,0.88189),(0.6378,0.88189),(0.64567,0.88189),(0.65354,0.88189),(0.66142,0.88189),(0.66929,0.88189),(0.67717,0.88189),(0.68504,0.88189),(0.69291,0.88189),(0.70079,0.88189),(0.70866,0.88189),(0.71654,0.88189),(0.72441,0.88189),(0.73228,0.88189),(0.74016,0.88189),(0.74803,0.88189),(0.75591,0.88189),(0.76378,0.88189),(0.77165,0.88189),(0.77953,0.88189),(0.7874,0.88189),(0.79528,0.88189),(0.80315,0.88189),(0.81102,0.88189),(0.8189,0.88189),(0.82677,0.88189),(0.83465,0.88189),(0.84252,0.88189),(0.85039,0.88189),(0.85827,0.88189),(0.86614,0.88189),(0.87402,0.88189),(0.88189,0.88189),(0.88976,0.88189),(0.89764,0.88189),(0.90551,0.88189),(0.91339,0.88189),(0.92126,0.88189),(0.92913,0.88189),(0.93701,0.88189),(0.94488,0.88189),(0.95276,0.88189),(0.96063,0.88189),(0.9685,0.88189),(0.97638,0.88189),(0.98425,0.88189),(0.99213,0.88189),(0.99609,0.88189),(0.00391,0.88976),(0.00787,0.88976),(0.01575,0.88976),(0.02362,0.88976),(0.0315,0.88976),(0.03937,0.88976),(0.04724,0.88976),(0.05512,0.88976),(0.06299,0.88976),(0.07087,0.88976),(0.07874,0.88976),(0.08661,0.88976),(0.09449,0.88976),(0.10236,0.88976),(0.11024,0.88976),(0.11811,0.88976),(0.12598,0.88976),(0.13386,0.88976),(0.14173,0.88976),(0.14961,0.88976),(0.15748,0.88976),(0.16535,0.88976),(0.17323,0.88976),(0.1811,0.88976),(0.18898,0.88976),(0.19685,0.88976),(0.20472,0.88976),(0.2126,0.88976),(0.22047,0.88976),(0.22835,0.88976),(0.23622,0.88976),(0.24409,0.88976),(0.25197,0.88976),(0.25984,0.88976),(0.26772,0.88976),(0.27559,0.88976),(0.28346,0.88976),(0.29134,0.88976),(0.29921,0.88976),(0.30709,0.88976),(0.31496,0.88976),(0.32283,0.88976),(0.33071,0.88976),(0.33858,0.88976),(0.34646,0.88976),(0.35433,0.88976),(0.3622,0.88976),(0.37008,0.88976),(0.37795,0.88976),(0.38583,0.88976),(0.3937,0.88976),(0.40157,0.88976),(0.40945,0.88976),(0.41732,0.88976),(0.4252,0.88976),(0.43307,0.88976),(0.44094,0.88976),(0.44882,0.88976),(0.45669,0.88976),(0.46457,0.88976),(0.47244,0.88976),(0.48031,0.88976),(0.48819,0.88976),(0.49606,0.88976),(0.50394,0.88976),(0.51181,0.88976),(0.51969,0.88976),(0.52756,0.88976),(0.53543,0.88976),(0.54331,0.88976),(0.55118,0.88976),(0.55906,0.88976),(0.56693,0.88976),(0.5748,0.88976),(0.58268,0.88976),(0.59055,0.88976),(0.59843,0.88976),(0.6063,0.88976),(0.61417,0.88976),(0.62205,0.88976),(0.62992,0.88976),(0.6378,0.88976),(0.64567,0.88976),(0.65354,0.88976),(0.66142,0.88976),(0.66929,0.88976),(0.67717,0.88976),(0.68504,0.88976),(0.69291,0.88976),(0.70079,0.88976),(0.70866,0.88976),(0.71654,0.88976),(0.72441,0.88976),(0.73228,0.88976),(0.74016,0.88976),(0.74803,0.88976),(0.75591,0.88976),(0.76378,0.88976),(0.77165,0.88976),(0.77953,0.88976),(0.7874,0.88976),(0.79528,0.88976),(0.80315,0.88976),(0.81102,0.88976),(0.8189,0.88976),(0.82677,0.88976),(0.83465,0.88976),(0.84252,0.88976),(0.85039,0.88976),(0.85827,0.88976),(0.86614,0.88976),(0.87402,0.88976),(0.88189,0.88976),(0.88976,0.88976),(0.89764,0.88976),(0.90551,0.88976),(0.91339,0.88976),(0.92126,0.88976),(0.92913,0.88976),(0.93701,0.88976),(0.94488,0.88976),(0.95276,0.88976),(0.96063,0.88976),(0.9685,0.88976),(0.97638,0.88976),(0.98425,0.88976),(0.99213,0.88976),(0.99609,0.88976),(0.00391,0.89764),(0.00787,0.89764),(0.01575,0.89764),(0.02362,0.89764),(0.0315,0.89764),(0.03937,0.89764),(0.04724,0.89764),(0.05512,0.89764),(0.06299,0.89764),(0.07087,0.89764),(0.07874,0.89764),(0.08661,0.89764),(0.09449,0.89764),(0.10236,0.89764),(0.11024,0.89764),(0.11811,0.89764),(0.12598,0.89764),(0.13386,0.89764),(0.14173,0.89764),(0.14961,0.89764),(0.15748,0.89764),(0.16535,0.89764),(0.17323,0.89764),(0.1811,0.89764),(0.18898,0.89764),(0.19685,0.89764),(0.20472,0.89764),(0.2126,0.89764),(0.22047,0.89764),(0.22835,0.89764),(0.23622,0.89764),(0.24409,0.89764),(0.25197,0.89764),(0.25984,0.89764),(0.26772,0.89764),(0.27559,0.89764),(0.28346,0.89764),(0.29134,0.89764),(0.29921,0.89764),(0.30709,0.89764),(0.31496,0.89764),(0.32283,0.89764),(0.33071,0.89764),(0.33858,0.89764),(0.34646,0.89764),(0.35433,0.89764),(0.3622,0.89764),(0.37008,0.89764),(0.37795,0.89764),(0.38583,0.89764),(0.3937,0.89764),(0.40157,0.89764),(0.40945,0.89764),(0.41732,0.89764),(0.4252,0.89764),(0.43307,0.89764),(0.44094,0.89764),(0.44882,0.89764),(0.45669,0.89764),(0.46457,0.89764),(0.47244,0.89764),(0.48031,0.89764),(0.48819,0.89764),(0.49606,0.89764),(0.50394,0.89764),(0.51181,0.89764),(0.51969,0.89764),(0.52756,0.89764),(0.53543,0.89764),(0.54331,0.89764),(0.55118,0.89764),(0.55906,0.89764),(0.56693,0.89764),(0.5748,0.89764),(0.58268,0.89764),(0.59055,0.89764),(0.59843,0.89764),(0.6063,0.89764),(0.61417,0.89764),(0.62205,0.89764),(0.62992,0.89764),(0.6378,0.89764),(0.64567,0.89764),(0.65354,0.89764),(0.66142,0.89764),(0.66929,0.89764),(0.67717,0.89764),(0.68504,0.89764),(0.69291,0.89764),(0.70079,0.89764),(0.70866,0.89764),(0.71654,0.89764),(0.72441,0.89764),(0.73228,0.89764),(0.74016,0.89764),(0.74803,0.89764),(0.75591,0.89764),(0.76378,0.89764),(0.77165,0.89764),(0.77953,0.89764),(0.7874,0.89764),(0.79528,0.89764),(0.80315,0.89764),(0.81102,0.89764),(0.8189,0.89764),(0.82677,0.89764),(0.83465,0.89764),(0.84252,0.89764),(0.85039,0.89764),(0.85827,0.89764),(0.86614,0.89764),(0.87402,0.89764),(0.88189,0.89764),(0.88976,0.89764),(0.89764,0.89764),(0.90551,0.89764),(0.91339,0.89764),(0.92126,0.89764),(0.92913,0.89764),(0.93701,0.89764),(0.94488,0.89764),(0.95276,0.89764),(0.96063,0.89764),(0.9685,0.89764),(0.97638,0.89764),(0.98425,0.89764),(0.99213,0.89764),(0.99609,0.89764),(0.00391,0.90551),(0.00787,0.90551),(0.01575,0.90551),(0.02362,0.90551),(0.0315,0.90551),(0.03937,0.90551),(0.04724,0.90551),(0.05512,0.90551),(0.06299,0.90551),(0.07087,0.90551),(0.07874,0.90551),(0.08661,0.90551),(0.09449,0.90551),(0.10236,0.90551),(0.11024,0.90551),(0.11811,0.90551),(0.12598,0.90551),(0.13386,0.90551),(0.14173,0.90551),(0.14961,0.90551),(0.15748,0.90551),(0.16535,0.90551),(0.17323,0.90551),(0.1811,0.90551),(0.18898,0.90551),(0.19685,0.90551),(0.20472,0.90551),(0.2126,0.90551),(0.22047,0.90551),(0.22835,0.90551),(0.23622,0.90551),(0.24409,0.90551),(0.25197,0.90551),(0.25984,0.90551),(0.26772,0.90551),(0.27559,0.90551),(0.28346,0.90551),(0.29134,0.90551),(0.29921,0.90551),(0.30709,0.90551),(0.31496,0.90551),(0.32283,0.90551),(0.33071,0.90551),(0.33858,0.90551),(0.34646,0.90551),(0.35433,0.90551),(0.3622,0.90551),(0.37008,0.90551),(0.37795,0.90551),(0.38583,0.90551),(0.3937,0.90551),(0.40157,0.90551),(0.40945,0.90551),(0.41732,0.90551),(0.4252,0.90551),(0.43307,0.90551),(0.44094,0.90551),(0.44882,0.90551),(0.45669,0.90551),(0.46457,0.90551),(0.47244,0.90551),(0.48031,0.90551),(0.48819,0.90551),(0.49606,0.90551),(0.50394,0.90551),(0.51181,0.90551),(0.51969,0.90551),(0.52756,0.90551),(0.53543,0.90551),(0.54331,0.90551),(0.55118,0.90551),(0.55906,0.90551),(0.56693,0.90551),(0.5748,0.90551),(0.58268,0.90551),(0.59055,0.90551),(0.59843,0.90551),(0.6063,0.90551),(0.61417,0.90551),(0.62205,0.90551),(0.62992,0.90551),(0.6378,0.90551),(0.64567,0.90551),(0.65354,0.90551),(0.66142,0.90551),(0.66929,0.90551),(0.67717,0.90551),(0.68504,0.90551),(0.69291,0.90551),(0.70079,0.90551),(0.70866,0.90551),(0.71654,0.90551),(0.72441,0.90551),(0.73228,0.90551),(0.74016,0.90551),(0.74803,0.90551),(0.75591,0.90551),(0.76378,0.90551),(0.77165,0.90551),(0.77953,0.90551),(0.7874,0.90551),(0.79528,0.90551),(0.80315,0.90551),(0.81102,0.90551),(0.8189,0.90551),(0.82677,0.90551),(0.83465,0.90551),(0.84252,0.90551),(0.85039,0.90551),(0.85827,0.90551),(0.86614,0.90551),(0.87402,0.90551),(0.88189,0.90551),(0.88976,0.90551),(0.89764,0.90551),(0.90551,0.90551),(0.91339,0.90551),(0.92126,0.90551),(0.92913,0.90551),(0.93701,0.90551),(0.94488,0.90551),(0.95276,0.90551),(0.96063,0.90551),(0.9685,0.90551),(0.97638,0.90551),(0.98425,0.90551),(0.99213,0.90551),(0.99609,0.90551),(0.00391,0.91339),(0.00787,0.91339),(0.01575,0.91339),(0.02362,0.91339),(0.0315,0.91339),(0.03937,0.91339),(0.04724,0.91339),(0.05512,0.91339),(0.06299,0.91339),(0.07087,0.91339),(0.07874,0.91339),(0.08661,0.91339),(0.09449,0.91339),(0.10236,0.91339),(0.11024,0.91339),(0.11811,0.91339),(0.12598,0.91339),(0.13386,0.91339),(0.14173,0.91339),(0.14961,0.91339),(0.15748,0.91339),(0.16535,0.91339),(0.17323,0.91339),(0.1811,0.91339),(0.18898,0.91339),(0.19685,0.91339),(0.20472,0.91339),(0.2126,0.91339),(0.22047,0.91339),(0.22835,0.91339),(0.23622,0.91339),(0.24409,0.91339),(0.25197,0.91339),(0.25984,0.91339),(0.26772,0.91339),(0.27559,0.91339),(0.28346,0.91339),(0.29134,0.91339),(0.29921,0.91339),(0.30709,0.91339),(0.31496,0.91339),(0.32283,0.91339),(0.33071,0.91339),(0.33858,0.91339),(0.34646,0.91339),(0.35433,0.91339),(0.3622,0.91339),(0.37008,0.91339),(0.37795,0.91339),(0.38583,0.91339),(0.3937,0.91339),(0.40157,0.91339),(0.40945,0.91339),(0.41732,0.91339),(0.4252,0.91339),(0.43307,0.91339),(0.44094,0.91339),(0.44882,0.91339),(0.45669,0.91339),(0.46457,0.91339),(0.47244,0.91339),(0.48031,0.91339),(0.48819,0.91339),(0.49606,0.91339),(0.50394,0.91339),(0.51181,0.91339),(0.51969,0.91339),(0.52756,0.91339),(0.53543,0.91339),(0.54331,0.91339),(0.55118,0.91339),(0.55906,0.91339),(0.56693,0.91339),(0.5748,0.91339),(0.58268,0.91339),(0.59055,0.91339),(0.59843,0.91339),(0.6063,0.91339),(0.61417,0.91339),(0.62205,0.91339),(0.62992,0.91339),(0.6378,0.91339),(0.64567,0.91339),(0.65354,0.91339),(0.66142,0.91339),(0.66929,0.91339),(0.67717,0.91339),(0.68504,0.91339),(0.69291,0.91339),(0.70079,0.91339),(0.70866,0.91339),(0.71654,0.91339),(0.72441,0.91339),(0.73228,0.91339),(0.74016,0.91339),(0.74803,0.91339),(0.75591,0.91339),(0.76378,0.91339),(0.77165,0.91339),(0.77953,0.91339),(0.7874,0.91339),(0.79528,0.91339),(0.80315,0.91339),(0.81102,0.91339),(0.8189,0.91339),(0.82677,0.91339),(0.83465,0.91339),(0.84252,0.91339),(0.85039,0.91339),(0.85827,0.91339),(0.86614,0.91339),(0.87402,0.91339),(0.88189,0.91339),(0.88976,0.91339),(0.89764,0.91339),(0.90551,0.91339),(0.91339,0.91339),(0.92126,0.91339),(0.92913,0.91339),(0.93701,0.91339),(0.94488,0.91339),(0.95276,0.91339),(0.96063,0.91339),(0.9685,0.91339),(0.97638,0.91339),(0.98425,0.91339),(0.99213,0.91339),(0.99609,0.91339),(0.00391,0.92126),(0.00787,0.92126),(0.01575,0.92126),(0.02362,0.92126),(0.0315,0.92126),(0.03937,0.92126),(0.04724,0.92126),(0.05512,0.92126),(0.06299,0.92126),(0.07087,0.92126),(0.07874,0.92126),(0.08661,0.92126),(0.09449,0.92126),(0.10236,0.92126),(0.11024,0.92126),(0.11811,0.92126),(0.12598,0.92126),(0.13386,0.92126),(0.14173,0.92126),(0.14961,0.92126),(0.15748,0.92126),(0.16535,0.92126),(0.17323,0.92126),(0.1811,0.92126),(0.18898,0.92126),(0.19685,0.92126),(0.20472,0.92126),(0.2126,0.92126),(0.22047,0.92126),(0.22835,0.92126),(0.23622,0.92126),(0.24409,0.92126),(0.25197,0.92126),(0.25984,0.92126),(0.26772,0.92126),(0.27559,0.92126),(0.28346,0.92126),(0.29134,0.92126),(0.29921,0.92126),(0.30709,0.92126),(0.31496,0.92126),(0.32283,0.92126),(0.33071,0.92126),(0.33858,0.92126),(0.34646,0.92126),(0.35433,0.92126),(0.3622,0.92126),(0.37008,0.92126),(0.37795,0.92126),(0.38583,0.92126),(0.3937,0.92126),(0.40157,0.92126),(0.40945,0.92126),(0.41732,0.92126),(0.4252,0.92126),(0.43307,0.92126),(0.44094,0.92126),(0.44882,0.92126),(0.45669,0.92126),(0.46457,0.92126),(0.47244,0.92126),(0.48031,0.92126),(0.48819,0.92126),(0.49606,0.92126),(0.50394,0.92126),(0.51181,0.92126),(0.51969,0.92126),(0.52756,0.92126),(0.53543,0.92126),(0.54331,0.92126),(0.55118,0.92126),(0.55906,0.92126),(0.56693,0.92126),(0.5748,0.92126),(0.58268,0.92126),(0.59055,0.92126),(0.59843,0.92126),(0.6063,0.92126),(0.61417,0.92126),(0.62205,0.92126),(0.62992,0.92126),(0.6378,0.92126),(0.64567,0.92126),(0.65354,0.92126),(0.66142,0.92126),(0.66929,0.92126),(0.67717,0.92126),(0.68504,0.92126),(0.69291,0.92126),(0.70079,0.92126),(0.70866,0.92126),(0.71654,0.92126),(0.72441,0.92126),(0.73228,0.92126),(0.74016,0.92126),(0.74803,0.92126),(0.75591,0.92126),(0.76378,0.92126),(0.77165,0.92126),(0.77953,0.92126),(0.7874,0.92126),(0.79528,0.92126),(0.80315,0.92126),(0.81102,0.92126),(0.8189,0.92126),(0.82677,0.92126),(0.83465,0.92126),(0.84252,0.92126),(0.85039,0.92126),(0.85827,0.92126),(0.86614,0.92126),(0.87402,0.92126),(0.88189,0.92126),(0.88976,0.92126),(0.89764,0.92126),(0.90551,0.92126),(0.91339,0.92126),(0.92126,0.92126),(0.92913,0.92126),(0.93701,0.92126),(0.94488,0.92126),(0.95276,0.92126),(0.96063,0.92126),(0.9685,0.92126),(0.97638,0.92126),(0.98425,0.92126),(0.99213,0.92126),(0.99609,0.92126),(0.00391,0.92913),(0.00787,0.92913),(0.01575,0.92913),(0.02362,0.92913),(0.0315,0.92913),(0.03937,0.92913),(0.04724,0.92913),(0.05512,0.92913),(0.06299,0.92913),(0.07087,0.92913),(0.07874,0.92913),(0.08661,0.92913),(0.09449,0.92913),(0.10236,0.92913),(0.11024,0.92913),(0.11811,0.92913),(0.12598,0.92913),(0.13386,0.92913),(0.14173,0.92913),(0.14961,0.92913),(0.15748,0.92913),(0.16535,0.92913),(0.17323,0.92913),(0.1811,0.92913),(0.18898,0.92913),(0.19685,0.92913),(0.20472,0.92913),(0.2126,0.92913),(0.22047,0.92913),(0.22835,0.92913),(0.23622,0.92913),(0.24409,0.92913),(0.25197,0.92913),(0.25984,0.92913),(0.26772,0.92913),(0.27559,0.92913),(0.28346,0.92913),(0.29134,0.92913),(0.29921,0.92913),(0.30709,0.92913),(0.31496,0.92913),(0.32283,0.92913),(0.33071,0.92913),(0.33858,0.92913),(0.34646,0.92913),(0.35433,0.92913),(0.3622,0.92913),(0.37008,0.92913),(0.37795,0.92913),(0.38583,0.92913),(0.3937,0.92913),(0.40157,0.92913),(0.40945,0.92913),(0.41732,0.92913),(0.4252,0.92913),(0.43307,0.92913),(0.44094,0.92913),(0.44882,0.92913),(0.45669,0.92913),(0.46457,0.92913),(0.47244,0.92913),(0.48031,0.92913),(0.48819,0.92913),(0.49606,0.92913),(0.50394,0.92913),(0.51181,0.92913),(0.51969,0.92913),(0.52756,0.92913),(0.53543,0.92913),(0.54331,0.92913),(0.55118,0.92913),(0.55906,0.92913),(0.56693,0.92913),(0.5748,0.92913),(0.58268,0.92913),(0.59055,0.92913),(0.59843,0.92913),(0.6063,0.92913),(0.61417,0.92913),(0.62205,0.92913),(0.62992,0.92913),(0.6378,0.92913),(0.64567,0.92913),(0.65354,0.92913),(0.66142,0.92913),(0.66929,0.92913),(0.67717,0.92913),(0.68504,0.92913),(0.69291,0.92913),(0.70079,0.92913),(0.70866,0.92913),(0.71654,0.92913),(0.72441,0.92913),(0.73228,0.92913),(0.74016,0.92913),(0.74803,0.92913),(0.75591,0.92913),(0.76378,0.92913),(0.77165,0.92913),(0.77953,0.92913),(0.7874,0.92913),(0.79528,0.92913),(0.80315,0.92913),(0.81102,0.92913),(0.8189,0.92913),(0.82677,0.92913),(0.83465,0.92913),(0.84252,0.92913),(0.85039,0.92913),(0.85827,0.92913),(0.86614,0.92913),(0.87402,0.92913),(0.88189,0.92913),(0.88976,0.92913),(0.89764,0.92913),(0.90551,0.92913),(0.91339,0.92913),(0.92126,0.92913),(0.92913,0.92913),(0.93701,0.92913),(0.94488,0.92913),(0.95276,0.92913),(0.96063,0.92913),(0.9685,0.92913),(0.97638,0.92913),(0.98425,0.92913),(0.99213,0.92913),(0.99609,0.92913),(0.00391,0.93701),(0.00787,0.93701),(0.01575,0.93701),(0.02362,0.93701),(0.0315,0.93701),(0.03937,0.93701),(0.04724,0.93701),(0.05512,0.93701),(0.06299,0.93701),(0.07087,0.93701),(0.07874,0.93701),(0.08661,0.93701),(0.09449,0.93701),(0.10236,0.93701),(0.11024,0.93701),(0.11811,0.93701),(0.12598,0.93701),(0.13386,0.93701),(0.14173,0.93701),(0.14961,0.93701),(0.15748,0.93701),(0.16535,0.93701),(0.17323,0.93701),(0.1811,0.93701),(0.18898,0.93701),(0.19685,0.93701),(0.20472,0.93701),(0.2126,0.93701),(0.22047,0.93701),(0.22835,0.93701),(0.23622,0.93701),(0.24409,0.93701),(0.25197,0.93701),(0.25984,0.93701),(0.26772,0.93701),(0.27559,0.93701),(0.28346,0.93701),(0.29134,0.93701),(0.29921,0.93701),(0.30709,0.93701),(0.31496,0.93701),(0.32283,0.93701),(0.33071,0.93701),(0.33858,0.93701),(0.34646,0.93701),(0.35433,0.93701),(0.3622,0.93701),(0.37008,0.93701),(0.37795,0.93701),(0.38583,0.93701),(0.3937,0.93701),(0.40157,0.93701),(0.40945,0.93701),(0.41732,0.93701),(0.4252,0.93701),(0.43307,0.93701),(0.44094,0.93701),(0.44882,0.93701),(0.45669,0.93701),(0.46457,0.93701),(0.47244,0.93701),(0.48031,0.93701),(0.48819,0.93701),(0.49606,0.93701),(0.50394,0.93701),(0.51181,0.93701),(0.51969,0.93701),(0.52756,0.93701),(0.53543,0.93701),(0.54331,0.93701),(0.55118,0.93701),(0.55906,0.93701),(0.56693,0.93701),(0.5748,0.93701),(0.58268,0.93701),(0.59055,0.93701),(0.59843,0.93701),(0.6063,0.93701),(0.61417,0.93701),(0.62205,0.93701),(0.62992,0.93701),(0.6378,0.93701),(0.64567,0.93701),(0.65354,0.93701),(0.66142,0.93701),(0.66929,0.93701),(0.67717,0.93701),(0.68504,0.93701),(0.69291,0.93701),(0.70079,0.93701),(0.70866,0.93701),(0.71654,0.93701),(0.72441,0.93701),(0.73228,0.93701),(0.74016,0.93701),(0.74803,0.93701),(0.75591,0.93701),(0.76378,0.93701),(0.77165,0.93701),(0.77953,0.93701),(0.7874,0.93701),(0.79528,0.93701),(0.80315,0.93701),(0.81102,0.93701),(0.8189,0.93701),(0.82677,0.93701),(0.83465,0.93701),(0.84252,0.93701),(0.85039,0.93701),(0.85827,0.93701),(0.86614,0.93701),(0.87402,0.93701),(0.88189,0.93701),(0.88976,0.93701),(0.89764,0.93701),(0.90551,0.93701),(0.91339,0.93701),(0.92126,0.93701),(0.92913,0.93701),(0.93701,0.93701),(0.94488,0.93701),(0.95276,0.93701),(0.96063,0.93701),(0.9685,0.93701),(0.97638,0.93701),(0.98425,0.93701),(0.99213,0.93701),(0.99609,0.93701),(0.00391,0.94488),(0.00787,0.94488),(0.01575,0.94488),(0.02362,0.94488),(0.0315,0.94488),(0.03937,0.94488),(0.04724,0.94488),(0.05512,0.94488),(0.06299,0.94488),(0.07087,0.94488),(0.07874,0.94488),(0.08661,0.94488),(0.09449,0.94488),(0.10236,0.94488),(0.11024,0.94488),(0.11811,0.94488),(0.12598,0.94488),(0.13386,0.94488),(0.14173,0.94488),(0.14961,0.94488),(0.15748,0.94488),(0.16535,0.94488),(0.17323,0.94488),(0.1811,0.94488),(0.18898,0.94488),(0.19685,0.94488),(0.20472,0.94488),(0.2126,0.94488),(0.22047,0.94488),(0.22835,0.94488),(0.23622,0.94488),(0.24409,0.94488),(0.25197,0.94488),(0.25984,0.94488),(0.26772,0.94488),(0.27559,0.94488),(0.28346,0.94488),(0.29134,0.94488),(0.29921,0.94488),(0.30709,0.94488),(0.31496,0.94488),(0.32283,0.94488),(0.33071,0.94488),(0.33858,0.94488),(0.34646,0.94488),(0.35433,0.94488),(0.3622,0.94488),(0.37008,0.94488),(0.37795,0.94488),(0.38583,0.94488),(0.3937,0.94488),(0.40157,0.94488),(0.40945,0.94488),(0.41732,0.94488),(0.4252,0.94488),(0.43307,0.94488),(0.44094,0.94488),(0.44882,0.94488),(0.45669,0.94488),(0.46457,0.94488),(0.47244,0.94488),(0.48031,0.94488),(0.48819,0.94488),(0.49606,0.94488),(0.50394,0.94488),(0.51181,0.94488),(0.51969,0.94488),(0.52756,0.94488),(0.53543,0.94488),(0.54331,0.94488),(0.55118,0.94488),(0.55906,0.94488),(0.56693,0.94488),(0.5748,0.94488),(0.58268,0.94488),(0.59055,0.94488),(0.59843,0.94488),(0.6063,0.94488),(0.61417,0.94488),(0.62205,0.94488),(0.62992,0.94488),(0.6378,0.94488),(0.64567,0.94488),(0.65354,0.94488),(0.66142,0.94488),(0.66929,0.94488),(0.67717,0.94488),(0.68504,0.94488),(0.69291,0.94488),(0.70079,0.94488),(0.70866,0.94488),(0.71654,0.94488),(0.72441,0.94488),(0.73228,0.94488),(0.74016,0.94488),(0.74803,0.94488),(0.75591,0.94488),(0.76378,0.94488),(0.77165,0.94488),(0.77953,0.94488),(0.7874,0.94488),(0.79528,0.94488),(0.80315,0.94488),(0.81102,0.94488),(0.8189,0.94488),(0.82677,0.94488),(0.83465,0.94488),(0.84252,0.94488),(0.85039,0.94488),(0.85827,0.94488),(0.86614,0.94488),(0.87402,0.94488),(0.88189,0.94488),(0.88976,0.94488),(0.89764,0.94488),(0.90551,0.94488),(0.91339,0.94488),(0.92126,0.94488),(0.92913,0.94488),(0.93701,0.94488),(0.94488,0.94488),(0.95276,0.94488),(0.96063,0.94488),(0.9685,0.94488),(0.97638,0.94488),(0.98425,0.94488),(0.99213,0.94488),(0.99609,0.94488),(0.00391,0.95276),(0.00787,0.95276),(0.01575,0.95276),(0.02362,0.95276),(0.0315,0.95276),(0.03937,0.95276),(0.04724,0.95276),(0.05512,0.95276),(0.06299,0.95276),(0.07087,0.95276),(0.07874,0.95276),(0.08661,0.95276),(0.09449,0.95276),(0.10236,0.95276),(0.11024,0.95276),(0.11811,0.95276),(0.12598,0.95276),(0.13386,0.95276),(0.14173,0.95276),(0.14961,0.95276),(0.15748,0.95276),(0.16535,0.95276),(0.17323,0.95276),(0.1811,0.95276),(0.18898,0.95276),(0.19685,0.95276),(0.20472,0.95276),(0.2126,0.95276),(0.22047,0.95276),(0.22835,0.95276),(0.23622,0.95276),(0.24409,0.95276),(0.25197,0.95276),(0.25984,0.95276),(0.26772,0.95276),(0.27559,0.95276),(0.28346,0.95276),(0.29134,0.95276),(0.29921,0.95276),(0.30709,0.95276),(0.31496,0.95276),(0.32283,0.95276),(0.33071,0.95276),(0.33858,0.95276),(0.34646,0.95276),(0.35433,0.95276),(0.3622,0.95276),(0.37008,0.95276),(0.37795,0.95276),(0.38583,0.95276),(0.3937,0.95276),(0.40157,0.95276),(0.40945,0.95276),(0.41732,0.95276),(0.4252,0.95276),(0.43307,0.95276),(0.44094,0.95276),(0.44882,0.95276),(0.45669,0.95276),(0.46457,0.95276),(0.47244,0.95276),(0.48031,0.95276),(0.48819,0.95276),(0.49606,0.95276),(0.50394,0.95276),(0.51181,0.95276),(0.51969,0.95276),(0.52756,0.95276),(0.53543,0.95276),(0.54331,0.95276),(0.55118,0.95276),(0.55906,0.95276),(0.56693,0.95276),(0.5748,0.95276),(0.58268,0.95276),(0.59055,0.95276),(0.59843,0.95276),(0.6063,0.95276),(0.61417,0.95276),(0.62205,0.95276),(0.62992,0.95276),(0.6378,0.95276),(0.64567,0.95276),(0.65354,0.95276),(0.66142,0.95276),(0.66929,0.95276),(0.67717,0.95276),(0.68504,0.95276),(0.69291,0.95276),(0.70079,0.95276),(0.70866,0.95276),(0.71654,0.95276),(0.72441,0.95276),(0.73228,0.95276),(0.74016,0.95276),(0.74803,0.95276),(0.75591,0.95276),(0.76378,0.95276),(0.77165,0.95276),(0.77953,0.95276),(0.7874,0.95276),(0.79528,0.95276),(0.80315,0.95276),(0.81102,0.95276),(0.8189,0.95276),(0.82677,0.95276),(0.83465,0.95276),(0.84252,0.95276),(0.85039,0.95276),(0.85827,0.95276),(0.86614,0.95276),(0.87402,0.95276),(0.88189,0.95276),(0.88976,0.95276),(0.89764,0.95276),(0.90551,0.95276),(0.91339,0.95276),(0.92126,0.95276),(0.92913,0.95276),(0.93701,0.95276),(0.94488,0.95276),(0.95276,0.95276),(0.96063,0.95276),(0.9685,0.95276),(0.97638,0.95276),(0.98425,0.95276),(0.99213,0.95276),(0.99609,0.95276),(0.00391,0.96063),(0.00787,0.96063),(0.01575,0.96063),(0.02362,0.96063),(0.0315,0.96063),(0.03937,0.96063),(0.04724,0.96063),(0.05512,0.96063),(0.06299,0.96063),(0.07087,0.96063),(0.07874,0.96063),(0.08661,0.96063),(0.09449,0.96063),(0.10236,0.96063),(0.11024,0.96063),(0.11811,0.96063),(0.12598,0.96063),(0.13386,0.96063),(0.14173,0.96063),(0.14961,0.96063),(0.15748,0.96063),(0.16535,0.96063),(0.17323,0.96063),(0.1811,0.96063),(0.18898,0.96063),(0.19685,0.96063),(0.20472,0.96063),(0.2126,0.96063),(0.22047,0.96063),(0.22835,0.96063),(0.23622,0.96063),(0.24409,0.96063),(0.25197,0.96063),(0.25984,0.96063),(0.26772,0.96063),(0.27559,0.96063),(0.28346,0.96063),(0.29134,0.96063),(0.29921,0.96063),(0.30709,0.96063),(0.31496,0.96063),(0.32283,0.96063),(0.33071,0.96063),(0.33858,0.96063),(0.34646,0.96063),(0.35433,0.96063),(0.3622,0.96063),(0.37008,0.96063),(0.37795,0.96063),(0.38583,0.96063),(0.3937,0.96063),(0.40157,0.96063),(0.40945,0.96063),(0.41732,0.96063),(0.4252,0.96063),(0.43307,0.96063),(0.44094,0.96063),(0.44882,0.96063),(0.45669,0.96063),(0.46457,0.96063),(0.47244,0.96063),(0.48031,0.96063),(0.48819,0.96063),(0.49606,0.96063),(0.50394,0.96063),(0.51181,0.96063),(0.51969,0.96063),(0.52756,0.96063),(0.53543,0.96063),(0.54331,0.96063),(0.55118,0.96063),(0.55906,0.96063),(0.56693,0.96063),(0.5748,0.96063),(0.58268,0.96063),(0.59055,0.96063),(0.59843,0.96063),(0.6063,0.96063),(0.61417,0.96063),(0.62205,0.96063),(0.62992,0.96063),(0.6378,0.96063),(0.64567,0.96063),(0.65354,0.96063),(0.66142,0.96063),(0.66929,0.96063),(0.67717,0.96063),(0.68504,0.96063),(0.69291,0.96063),(0.70079,0.96063),(0.70866,0.96063),(0.71654,0.96063),(0.72441,0.96063),(0.73228,0.96063),(0.74016,0.96063),(0.74803,0.96063),(0.75591,0.96063),(0.76378,0.96063),(0.77165,0.96063),(0.77953,0.96063),(0.7874,0.96063),(0.79528,0.96063),(0.80315,0.96063),(0.81102,0.96063),(0.8189,0.96063),(0.82677,0.96063),(0.83465,0.96063),(0.84252,0.96063),(0.85039,0.96063),(0.85827,0.96063),(0.86614,0.96063),(0.87402,0.96063),(0.88189,0.96063),(0.88976,0.96063),(0.89764,0.96063),(0.90551,0.96063),(0.91339,0.96063),(0.92126,0.96063),(0.92913,0.96063),(0.93701,0.96063),(0.94488,0.96063),(0.95276,0.96063),(0.96063,0.96063),(0.9685,0.96063),(0.97638,0.96063),(0.98425,0.96063),(0.99213,0.96063),(0.99609,0.96063),(0.00391,0.9685),(0.00787,0.9685),(0.01575,0.9685),(0.02362,0.9685),(0.0315,0.9685),(0.03937,0.9685),(0.04724,0.9685),(0.05512,0.9685),(0.06299,0.9685),(0.07087,0.9685),(0.07874,0.9685),(0.08661,0.9685),(0.09449,0.9685),(0.10236,0.9685),(0.11024,0.9685),(0.11811,0.9685),(0.12598,0.9685),(0.13386,0.9685),(0.14173,0.9685),(0.14961,0.9685),(0.15748,0.9685),(0.16535,0.9685),(0.17323,0.9685),(0.1811,0.9685),(0.18898,0.9685),(0.19685,0.9685),(0.20472,0.9685),(0.2126,0.9685),(0.22047,0.9685),(0.22835,0.9685),(0.23622,0.9685),(0.24409,0.9685),(0.25197,0.9685),(0.25984,0.9685),(0.26772,0.9685),(0.27559,0.9685),(0.28346,0.9685),(0.29134,0.9685),(0.29921,0.9685),(0.30709,0.9685),(0.31496,0.9685),(0.32283,0.9685),(0.33071,0.9685),(0.33858,0.9685),(0.34646,0.9685),(0.35433,0.9685),(0.3622,0.9685),(0.37008,0.9685),(0.37795,0.9685),(0.38583,0.9685),(0.3937,0.9685),(0.40157,0.9685),(0.40945,0.9685),(0.41732,0.9685),(0.4252,0.9685),(0.43307,0.9685),(0.44094,0.9685),(0.44882,0.9685),(0.45669,0.9685),(0.46457,0.9685),(0.47244,0.9685),(0.48031,0.9685),(0.48819,0.9685),(0.49606,0.9685),(0.50394,0.9685),(0.51181,0.9685),(0.51969,0.9685),(0.52756,0.9685),(0.53543,0.9685),(0.54331,0.9685),(0.55118,0.9685),(0.55906,0.9685),(0.56693,0.9685),(0.5748,0.9685),(0.58268,0.9685),(0.59055,0.9685),(0.59843,0.9685),(0.6063,0.9685),(0.61417,0.9685),(0.62205,0.9685),(0.62992,0.9685),(0.6378,0.9685),(0.64567,0.9685),(0.65354,0.9685),(0.66142,0.9685),(0.66929,0.9685),(0.67717,0.9685),(0.68504,0.9685),(0.69291,0.9685),(0.70079,0.9685),(0.70866,0.9685),(0.71654,0.9685),(0.72441,0.9685),(0.73228,0.9685),(0.74016,0.9685),(0.74803,0.9685),(0.75591,0.9685),(0.76378,0.9685),(0.77165,0.9685),(0.77953,0.9685),(0.7874,0.9685),(0.79528,0.9685),(0.80315,0.9685),(0.81102,0.9685),(0.8189,0.9685),(0.82677,0.9685),(0.83465,0.9685),(0.84252,0.9685),(0.85039,0.9685),(0.85827,0.9685),(0.86614,0.9685),(0.87402,0.9685),(0.88189,0.9685),(0.88976,0.9685),(0.89764,0.9685),(0.90551,0.9685),(0.91339,0.9685),(0.92126,0.9685),(0.92913,0.9685),(0.93701,0.9685),(0.94488,0.9685),(0.95276,0.9685),(0.96063,0.9685),(0.9685,0.9685),(0.97638,0.9685),(0.98425,0.9685),(0.99213,0.9685),(0.99609,0.9685),(0.00391,0.97638),(0.00787,0.97638),(0.01575,0.97638),(0.02362,0.97638),(0.0315,0.97638),(0.03937,0.97638),(0.04724,0.97638),(0.05512,0.97638),(0.06299,0.97638),(0.07087,0.97638),(0.07874,0.97638),(0.08661,0.97638),(0.09449,0.97638),(0.10236,0.97638),(0.11024,0.97638),(0.11811,0.97638),(0.12598,0.97638),(0.13386,0.97638),(0.14173,0.97638),(0.14961,0.97638),(0.15748,0.97638),(0.16535,0.97638),(0.17323,0.97638),(0.1811,0.97638),(0.18898,0.97638),(0.19685,0.97638),(0.20472,0.97638),(0.2126,0.97638),(0.22047,0.97638),(0.22835,0.97638),(0.23622,0.97638),(0.24409,0.97638),(0.25197,0.97638),(0.25984,0.97638),(0.26772,0.97638),(0.27559,0.97638),(0.28346,0.97638),(0.29134,0.97638),(0.29921,0.97638),(0.30709,0.97638),(0.31496,0.97638),(0.32283,0.97638),(0.33071,0.97638),(0.33858,0.97638),(0.34646,0.97638),(0.35433,0.97638),(0.3622,0.97638),(0.37008,0.97638),(0.37795,0.97638),(0.38583,0.97638),(0.3937,0.97638),(0.40157,0.97638),(0.40945,0.97638),(0.41732,0.97638),(0.4252,0.97638),(0.43307,0.97638),(0.44094,0.97638),(0.44882,0.97638),(0.45669,0.97638),(0.46457,0.97638),(0.47244,0.97638),(0.48031,0.97638),(0.48819,0.97638),(0.49606,0.97638),(0.50394,0.97638),(0.51181,0.97638),(0.51969,0.97638),(0.52756,0.97638),(0.53543,0.97638),(0.54331,0.97638),(0.55118,0.97638),(0.55906,0.97638),(0.56693,0.97638),(0.5748,0.97638),(0.58268,0.97638),(0.59055,0.97638),(0.59843,0.97638),(0.6063,0.97638),(0.61417,0.97638),(0.62205,0.97638),(0.62992,0.97638),(0.6378,0.97638),(0.64567,0.97638),(0.65354,0.97638),(0.66142,0.97638),(0.66929,0.97638),(0.67717,0.97638),(0.68504,0.97638),(0.69291,0.97638),(0.70079,0.97638),(0.70866,0.97638),(0.71654,0.97638),(0.72441,0.97638),(0.73228,0.97638),(0.74016,0.97638),(0.74803,0.97638),(0.75591,0.97638),(0.76378,0.97638),(0.77165,0.97638),(0.77953,0.97638),(0.7874,0.97638),(0.79528,0.97638),(0.80315,0.97638),(0.81102,0.97638),(0.8189,0.97638),(0.82677,0.97638),(0.83465,0.97638),(0.84252,0.97638),(0.85039,0.97638),(0.85827,0.97638),(0.86614,0.97638),(0.87402,0.97638),(0.88189,0.97638),(0.88976,0.97638),(0.89764,0.97638),(0.90551,0.97638),(0.91339,0.97638),(0.92126,0.97638),(0.92913,0.97638),(0.93701,0.97638),(0.94488,0.97638),(0.95276,0.97638),(0.96063,0.97638),(0.9685,0.97638),(0.97638,0.97638),(0.98425,0.97638),(0.99213,0.97638),(0.99609,0.97638),(0.00391,0.98425),(0.00787,0.98425),(0.01575,0.98425),(0.02362,0.98425),(0.0315,0.98425),(0.03937,0.98425),(0.04724,0.98425),(0.05512,0.98425),(0.06299,0.98425),(0.07087,0.98425),(0.07874,0.98425),(0.08661,0.98425),(0.09449,0.98425),(0.10236,0.98425),(0.11024,0.98425),(0.11811,0.98425),(0.12598,0.98425),(0.13386,0.98425),(0.14173,0.98425),(0.14961,0.98425),(0.15748,0.98425),(0.16535,0.98425),(0.17323,0.98425),(0.1811,0.98425),(0.18898,0.98425),(0.19685,0.98425),(0.20472,0.98425),(0.2126,0.98425),(0.22047,0.98425),(0.22835,0.98425),(0.23622,0.98425),(0.24409,0.98425),(0.25197,0.98425),(0.25984,0.98425),(0.26772,0.98425),(0.27559,0.98425),(0.28346,0.98425),(0.29134,0.98425),(0.29921,0.98425),(0.30709,0.98425),(0.31496,0.98425),(0.32283,0.98425),(0.33071,0.98425),(0.33858,0.98425),(0.34646,0.98425),(0.35433,0.98425),(0.3622,0.98425),(0.37008,0.98425),(0.37795,0.98425),(0.38583,0.98425),(0.3937,0.98425),(0.40157,0.98425),(0.40945,0.98425),(0.41732,0.98425),(0.4252,0.98425),(0.43307,0.98425),(0.44094,0.98425),(0.44882,0.98425),(0.45669,0.98425),(0.46457,0.98425),(0.47244,0.98425),(0.48031,0.98425),(0.48819,0.98425),(0.49606,0.98425),(0.50394,0.98425),(0.51181,0.98425),(0.51969,0.98425),(0.52756,0.98425),(0.53543,0.98425),(0.54331,0.98425),(0.55118,0.98425),(0.55906,0.98425),(0.56693,0.98425),(0.5748,0.98425),(0.58268,0.98425),(0.59055,0.98425),(0.59843,0.98425),(0.6063,0.98425),(0.61417,0.98425),(0.62205,0.98425),(0.62992,0.98425),(0.6378,0.98425),(0.64567,0.98425),(0.65354,0.98425),(0.66142,0.98425),(0.66929,0.98425),(0.67717,0.98425),(0.68504,0.98425),(0.69291,0.98425),(0.70079,0.98425),(0.70866,0.98425),(0.71654,0.98425),(0.72441,0.98425),(0.73228,0.98425),(0.74016,0.98425),(0.74803,0.98425),(0.75591,0.98425),(0.76378,0.98425),(0.77165,0.98425),(0.77953,0.98425),(0.7874,0.98425),(0.79528,0.98425),(0.80315,0.98425),(0.81102,0.98425),(0.8189,0.98425),(0.82677,0.98425),(0.83465,0.98425),(0.84252,0.98425),(0.85039,0.98425),(0.85827,0.98425),(0.86614,0.98425),(0.87402,0.98425),(0.88189,0.98425),(0.88976,0.98425),(0.89764,0.98425),(0.90551,0.98425),(0.91339,0.98425),(0.92126,0.98425),(0.92913,0.98425),(0.93701,0.98425),(0.94488,0.98425),(0.95276,0.98425),(0.96063,0.98425),(0.9685,0.98425),(0.97638,0.98425),(0.98425,0.98425),(0.99213,0.98425),(0.99609,0.98425),(0.00391,0.99213),(0.00787,0.99213),(0.01575,0.99213),(0.02362,0.99213),(0.0315,0.99213),(0.03937,0.99213),(0.04724,0.99213),(0.05512,0.99213),(0.06299,0.99213),(0.07087,0.99213),(0.07874,0.99213),(0.08661,0.99213),(0.09449,0.99213),(0.10236,0.99213),(0.11024,0.99213),(0.11811,0.99213),(0.12598,0.99213),(0.13386,0.99213),(0.14173,0.99213),(0.14961,0.99213),(0.15748,0.99213),(0.16535,0.99213),(0.17323,0.99213),(0.1811,0.99213),(0.18898,0.99213),(0.19685,0.99213),(0.20472,0.99213),(0.2126,0.99213),(0.22047,0.99213),(0.22835,0.99213),(0.23622,0.99213),(0.24409,0.99213),(0.25197,0.99213),(0.25984,0.99213),(0.26772,0.99213),(0.27559,0.99213),(0.28346,0.99213),(0.29134,0.99213),(0.29921,0.99213),(0.30709,0.99213),(0.31496,0.99213),(0.32283,0.99213),(0.33071,0.99213),(0.33858,0.99213),(0.34646,0.99213),(0.35433,0.99213),(0.3622,0.99213),(0.37008,0.99213),(0.37795,0.99213),(0.38583,0.99213),(0.3937,0.99213),(0.40157,0.99213),(0.40945,0.99213),(0.41732,0.99213),(0.4252,0.99213),(0.43307,0.99213),(0.44094,0.99213),(0.44882,0.99213),(0.45669,0.99213),(0.46457,0.99213),(0.47244,0.99213),(0.48031,0.99213),(0.48819,0.99213),(0.49606,0.99213),(0.50394,0.99213),(0.51181,0.99213),(0.51969,0.99213),(0.52756,0.99213),(0.53543,0.99213),(0.54331,0.99213),(0.55118,0.99213),(0.55906,0.99213),(0.56693,0.99213),(0.5748,0.99213),(0.58268,0.99213),(0.59055,0.99213),(0.59843,0.99213),(0.6063,0.99213),(0.61417,0.99213),(0.62205,0.99213),(0.62992,0.99213),(0.6378,0.99213),(0.64567,0.99213),(0.65354,0.99213),(0.66142,0.99213),(0.66929,0.99213),(0.67717,0.99213),(0.68504,0.99213),(0.69291,0.99213),(0.70079,0.99213),(0.70866,0.99213),(0.71654,0.99213),(0.72441,0.99213),(0.73228,0.99213),(0.74016,0.99213),(0.74803,0.99213),(0.75591,0.99213),(0.76378,0.99213),(0.77165,0.99213),(0.77953,0.99213),(0.7874,0.99213),(0.79528,0.99213),(0.80315,0.99213),(0.81102,0.99213),(0.8189,0.99213),(0.82677,0.99213),(0.83465,0.99213),(0.84252,0.99213),(0.85039,0.99213),(0.85827,0.99213),(0.86614,0.99213),(0.87402,0.99213),(0.88189,0.99213),(0.88976,0.99213),(0.89764,0.99213),(0.90551,0.99213),(0.91339,0.99213),(0.92126,0.99213),(0.92913,0.99213),(0.93701,0.99213),(0.94488,0.99213),(0.95276,0.99213),(0.96063,0.99213),(0.9685,0.99213),(0.97638,0.99213),(0.98425,0.99213),(0.99213,0.99213),(0.99609,0.99213),(0.00391,0.99609),(0.00787,0.99609),(0.01575,0.99609),(0.02362,0.99609),(0.0315,0.99609),(0.03937,0.99609),(0.04724,0.99609),(0.05512,0.99609),(0.06299,0.99609),(0.07087,0.99609),(0.07874,0.99609),(0.08661,0.99609),(0.09449,0.99609),(0.10236,0.99609),(0.11024,0.99609),(0.11811,0.99609),(0.12598,0.99609),(0.13386,0.99609),(0.14173,0.99609),(0.14961,0.99609),(0.15748,0.99609),(0.16535,0.99609),(0.17323,0.99609),(0.1811,0.99609),(0.18898,0.99609),(0.19685,0.99609),(0.20472,0.99609),(0.2126,0.99609),(0.22047,0.99609),(0.22835,0.99609),(0.23622,0.99609),(0.24409,0.99609),(0.25197,0.99609),(0.25984,0.99609),(0.26772,0.99609),(0.27559,0.99609),(0.28346,0.99609),(0.29134,0.99609),(0.29921,0.99609),(0.30709,0.99609),(0.31496,0.99609),(0.32283,0.99609),(0.33071,0.99609),(0.33858,0.99609),(0.34646,0.99609),(0.35433,0.99609),(0.3622,0.99609),(0.37008,0.99609),(0.37795,0.99609),(0.38583,0.99609),(0.3937,0.99609),(0.40157,0.99609),(0.40945,0.99609),(0.41732,0.99609),(0.4252,0.99609),(0.43307,0.99609),(0.44094,0.99609),(0.44882,0.99609),(0.45669,0.99609),(0.46457,0.99609),(0.47244,0.99609),(0.48031,0.99609),(0.48819,0.99609),(0.49606,0.99609),(0.50394,0.99609),(0.51181,0.99609),(0.51969,0.99609),(0.52756,0.99609),(0.53543,0.99609),(0.54331,0.99609),(0.55118,0.99609),(0.55906,0.99609),(0.56693,0.99609),(0.5748,0.99609),(0.58268,0.99609),(0.59055,0.99609),(0.59843,0.99609),(0.6063,0.99609),(0.61417,0.99609),(0.62205,0.99609),(0.62992,0.99609),(0.6378,0.99609),(0.64567,0.99609),(0.65354,0.99609),(0.66142,0.99609),(0.66929,0.99609),(0.67717,0.99609),(0.68504,0.99609),(0.69291,0.99609),(0.70079,0.99609),(0.70866,0.99609),(0.71654,0.99609),(0.72441,0.99609),(0.73228,0.99609),(0.74016,0.99609),(0.74803,0.99609),(0.75591,0.99609),(0.76378,0.99609),(0.77165,0.99609),(0.77953,0.99609),(0.7874,0.99609),(0.79528,0.99609),(0.80315,0.99609),(0.81102,0.99609),(0.8189,0.99609),(0.82677,0.99609),(0.83465,0.99609),(0.84252,0.99609),(0.85039,0.99609),(0.85827,0.99609),(0.86614,0.99609),(0.87402,0.99609),(0.88189,0.99609),(0.88976,0.99609),(0.89764,0.99609),(0.90551,0.99609),(0.91339,0.99609),(0.92126,0.99609),(0.92913,0.99609),(0.93701,0.99609),(0.94488,0.99609),(0.95276,0.99609),(0.96063,0.99609),(0.9685,0.99609),(0.97638,0.99609),(0.98425,0.99609),(0.99213,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD011.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD011.py load and self-test diagnostics complete.")
