package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD010Index.html" target="_blank">MarsLOD010</a>,  source <a href="../../../Geospatial/MarsLOD010.java">MarsLOD010.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD010.x3d">MarsLOD010.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD010.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD010.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD010
{
	/** Default constructor to create this object. */
	public MarsLOD010 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD010.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD010.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD010.x3d"))
    .addChild(new GeoLOD().setCenter(44.940476,-45.000000,-63625.000000).setRange(1.8E7).setChild1Url(new String[] {"MarsLOD011.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD011.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars003.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars003.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,-90.000000,0.000000).setSolid(false).setXDimension(64).setXSpacing(1.428571).setYScale(50.0).setZDimension(64).setZSpacing(1.428571).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2925.5825,2664.6853,2479.8933,2161.7483,1801.4552,1392.8225,287.18637,1422.4167,2551.0957,1873.533,2449.3464,3431.8372,3398.5159,3268.8306,2919.6582,2292.0562,1879.1665,1620.6492,1528.1433,1432.7888,803.4859,877.2123,1140.5265,974.4529,625.83234,865.8414,820.30945,775.72156,553.6789,544.5703,-599.1668,-2238.928,-147.23836,-352.01532,-757.6813,-1058.611,-3361.8616,-2771.8086,-3574.6897,-4578.152,-3403.829,-1743.6323,-1723.5631,-1877.3069,-1860.2405,-2027.2346,-1685.079,-1987.9003,-2019.3801,-1728.123,-2636.6572,-2880.9824,-2494.369,-2198.511,-1956.6431,-2099.095,-1991.9856,-1915.4783,-1680.3807,-1468.6737,-1404.6393,-1304.9363,-1225.0049,-1206.532,2673.8762,2443.309,2168.1333,1856.0424,1509.0807,1110.2738,-183.7647,845.7655,2514.0505,3391.438,3762.7803,3438.0967,3127.4814,2859.9016,2477.7153,1959.2394,1621.7775,1409.734,1289.4326,1123.4751,719.52606,459.6597,1295.373,612.4936,79.62219,597.9096,965.5632,678.5044,611.82825,354.97055,361.84616,-227.40094,-910.453,-367.01196,-624.9212,-1092.1672};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {-1874.6753,-3072.1858,-4105.9854,-4187.7646,-3465.039,-1845.5542,-1475.0227,-2369.9868,-1872.1981,-2651.3508,-1814.0529,-2304.6191,-2899.4658,-2129.9766,-1960.0159,-2678.446,-2214.1814,-2156.8958,-1891.6299,-1931.1458,-1844.1228,-1766.9242,-1768.2311,-1492.5524,-1381.1467,-1304.0427,-1322.4058,-1305.739,2430.2544,2080.3418,1803.2179,1518.9198,1240.9623,982.78253,-133.4707,-567.64905,1143.6567,2473.6934,2745.775,2535.3232,2202.6694,1949.6757,1649.6659,1390.0728,1247.2795,1140.8892,1059.0995,890.48627,547.9789,737.599,754.1277,852.33276,962.6632,892.8145,-357.93106,-286.60342,351.6452,449.90628,54.88822,-378.33182,-757.1375,-744.7098,-957.758,-1086.2804,-1684.394,-2297.1028,-3547.8655,-3457.6995,-2918.1892,-2592.521,-2315.9475,-3090.9697,-2863.838,-3012.4763,-1963.0115,-2750.2937,-2869.2998,-2518.9827,-1767.2466,-2421.428,-2329.741,-2147.3567,-1997.8468,-1900.7201,-2089.2974,-1836.7242,-1749.7612,-1427.6409,-1256.5271,-1344.1754,-1488.9646,-1388.4546,2080.6116,1722.6528,1426.5574,1158.518,864.7819,617.2512,-303.62512,-738.11896};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {268.73172,1786.1011,1723.6814,1388.819,1126.8021,967.7672,694.10956,842.0264,737.16626,766.49695,723.46954,604.9055,363.56073,159.11073,641.43494,729.79114,1014.0475,1010.2802,511.48874,238.51282,-37.571526,-203.91772,-470.01062,-689.07056,-1119.1647,-981.02826,-1347.4774,-1645.2283,-2063.9453,-2626.2627,-2093.4778,-2186.0393,-3137.6587,-3043.9612,-2919.3982,-2911.1685,-2325.7708,-2197.5288,-2020.8759,-2164.8818,-2658.6243,-1916.458,-2243.1233,-2371.6538,-2001.2107,-2025.3684,-2002.516,-1961.6986,-2105.2473,-1848.3704,-1696.0789,-1514.4869,-1257.267,-1369.073,-1452.5183,-1349.7528,1645.9817,1434.4998,1195.3707,905.30273,570.7322,254.6164,-383.6743,-806.3021,-380.04062,1107.1995,1280.9686,1038.5164,842.41254,785.38403,748.6527,640.9658,538.3858,405.30197,313.7984,268.6511,108.548065,-82.86297,-96.42096,452.62454,817.9548,445.4292,320.0601,92.99976,-418.53238,-590.118,-774.78375,-1049.7648,-1359.0262,-1323.2605,-1479.8478,-1859.6505,-2206.7227,-3698.8247,-2902.9895,-2304.7676,-3235.0828,-3961.9854,-3712.4526,-2167.493};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {-2882.2625,-1706.503,-2316.1445,-2090.7783,-1692.1208,-1861.3451,-3037.0017,-2077.823,-1919.8428,-1941.852,-1963.4998,-2043.5212,-2278.5562,-1854.8313,-1762.502,-1408.1174,-1508.2065,-1532.3762,-1404.8131,-1380.9325,1618.0779,1383.6267,1138.5533,837.03955,516.2062,132.19278,-391.489,-773.5837,-650.5728,-243.478,568.5807,738.3356,701.373,704.3675,671.5589,519.9872,386.91727,239.65288,94.451195,-57.355812,-201.92677,-360.17505,-266.18646,220.11644,533.3046,173.74573,-63.41669,-449.71188,-626.3954,-974.9863,-1174.2316,-1268.128,-1470.3514,-2092.4229,-1937.7574,-2084.3909,-2665.847,-3714.789,-3836.883,-3438.9167,-3248.6672,-3720.7888,-2792.228,-2146.6455,-2205.0432,-1815.8463,-2274.0945,-2574.1821,-2749.4993,-2670.776,-2329.7986,-2033.7101,-1992.2493,-2074.2583,-2039.202,-1979.733,-1731.9215,-1816.692,-1777.2666,-1439.0642,-1503.0931,-1445.3162,-1259.9443,-1360.2123,1633.3151,1340.2487,1060.9509,750.44305,481.4866,105.23832,-355.02545,-692.54144,-811.8954,-872.85736,-351.2875,396.5202,537.12823,575.89307,537.5881,413.91663};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {279.5934,94.57912,-52.951958,-172.1192,-328.60785,-536.9796,-535.0562,-257.0717,-130.77539,-34.57803,-213.37958,-713.0323,-1487.3406,-1426.733,-1566.4982,-1644.6726,-1770.7478,-2173.2043,-2476.5857,-2256.8823,-3560.8186,-3681.3025,-3945.9907,-3890.6467,-3802.967,-2959.1345,-2588.34,-2435.7722,-2442.5535,-2177.6387,-2251.1567,-2976.262,-2415.4724,-2210.3745,-2081.305,-2168.1833,-2566.507,-2030.2131,-2081.3955,-2034.6179,-1881.7473,-1948.7826,-1971.5845,-1778.0995,-1751.501,-1671.719,-1631.4358,-1345.8121,1655.3091,1283.6613,965.2888,685.773,400.33148,84.83608,-287.94305,-602.42694,-754.8956,-879.4403,-775.7991,44.988586,340.23245,412.4124,413.59265,318.46606,165.62624,-3.426203,-175.92628,-310.4891,-414.8947,-534.71045,-642.4337,-328.44888,-12.376635,-62.188805,-707.19336,-768.3317,-1208.0664,-1746.903,-1991.0273,-2118.6353,-2221.946,-2369.3335,-2656.0002,-3511.6338,-3890.778,-3874.3682,-3239.8828,-3098.2874,-3698.8652,-2660.0413,-2538.288,-2654.3884,-2977.7185,-3000.4158,-2584.4922,-2293.6768,-2166.2217,-2061.7966,-2049.7148,-2013.9921};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {-2038.5197,-2074.4185,-1969.7375,-2053.0178,-2041.0295,-1881.4166,-1994.0807,-2034.2155,-1993.968,-1794.5796,-1881.5725,-1505.1127,1651.7373,1215.0477,860.8777,576.86304,263.44434,4.424707,-263.8666,-540.0155,-729.03357,-836.1183,-784.50385,-132.61398,201.50667,236.60023,260.6803,156.80623,19.367481,-142.94675,-269.24054,-415.7373,-512.1516,-595.07196,-651.86346,-267.8223,-108.02233,-371.8712,-872.4779,-1175.979,-1455.9691,-1828.4716,-2296.3572,-2538.891,-2623.6465,-2783.9695,-2966.5396,-3709.0798,-3899.1816,-3737.6545,-2867.5515,-3054.0747,-3699.0137,-2777.5532,-2677.159,-2996.9949,-3271.1458,-2649.2217,-2239.6362,-1891.3555,-2159.5842,-1946.6729,-1958.6318,-1989.6937,-1987.1453,-2259.3984,-1928.0957,-1859.1942,-2046.9556,-2051.8774,-2027.883,-1960.1726,-1899.8763,-1693.4789,-1823.5403,-1478.87,1424.796,1070.2329,720.1717,467.53168,168.92993,-54.989292,-240.66747,-513.94525,-714.04974,-783.56287,-758.7866,-140.43692,168.4828,154.81177,102.65466,2.511684,-135.76697,-237.74629,-371.73706,-498.63135,-524.3701,-594.8308,-748.63574,-726.51135};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {-840.48364,-849.9849,-1042.8011,-1380.5232,-1932.1865,-2407.8179,-2682.0137,-2829.8357,-2910.8594,-3021.4534,-3404.9346,-3739.565,-3909.9954,-3652.8992,-2809.1396,-3277.3223,-3419.2317,-2616.974,-2853.5686,-3444.9475,-2887.0752,-2633.7324,-2109.8591,-2024.6238,-1813.4172,-1923.985,-1667.2936,-1911.1604,-1974.6321,-2025.9604,-1946.697,-1958.3599,-1987.6531,-1920.3914,-2523.8325,-1852.9877,-2177.9353,-2021.8411,-1569.6259,-1524.8779,1063.8474,854.30695,607.0834,335.86093,121.61009,-56.92679,-197.67648,-535.18555,-731.6688,-794.8876,-769.63947,-420.4901,88.693695,107.009285,3.588288,-108.16522,-215.73247,-364.49628,-451.1736,-551.5865,-590.7812,-622.5734,-735.01666,-659.4103,-749.24677,-755.149,-1324.1869,-1997.5515,-2501.8467,-2725.4844,-2922.6487,-2998.8145,-3050.945,-3196.67,-3675.443,-3770.912,-3894.3608,-3545.5522,-3284.8723,-3234.2327,-2838.8022,-2841.391,-3360.2637,-3013.4814,-2527.0847,-2582.9387,-2540.775,-2404.0583,-2245.0654,-2225.421,-1936.0796,-1972.5134,-1780.1979,-1800.4355,-1921.816,-2021.8732,-2267.6113,-1877.6729,-2037.3513,-1889.325};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {-1920.8278,-1817.5184,-1677.405,-1890.606,970.9572,678.38196,483.36108,287.99463,55.141678,-124.04951,-203.65309,-455.1075,-681.4353,-786.58344,-771.16565,-331.9917,165.7655,34.90412,-50.387306,-183.66705,-295.99258,-424.81995,-532.14233,-605.4669,-617.3839,-672.63,-789.7549,-817.7817,-800.8417,-935.319,-1716.0981,-2474.4907,-2702.2896,-2878.2405,-2979.379,-3086.9346,-3190.0674,-3431.8738,-3621.7014,-3676.6833,-3820.8386,-3688.658,-3494.2012,-3296.1167,-3166.8318,-3509.8652,-3164.9365,-2615.059,-2685.2444,-2602.6855,-2541.753,-2851.132,-2289.7966,-2051.78,-1939.3989,-1827.4023,-1856.2678,-2119.049,-3304.2798,-1959.2633,-1909.0253,-2006.6744,-1926.3739,-1776.1963,-1786.1115,-1739.6483,-1784.4211,-1775.403,963.8674,619.3386,389.03503,192.25804,-2.735348,-141.54475,-249.45575,-345.87128,-697.18976,-829.0577,-764.2588,-287.20587,219.27933,89.91314,-67.104355,-236.99068,-366.3479,-469.3684,-552.0419,-597.9634,-635.88605,-726.7226,-801.7479,-1011.262,-1089.5991,-1533.1077,-2315.3313,-2519.6846,-2813.9155,-3068.6982,-3184.526,-3289.2104};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-3408.6064,-3652.6897,-3685.458,-3553.7256,-3739.2256,-3636.2354,-3681.4097,-3379.857,-3474.6018,-3502.392,-3027.1853,-2794.0159,-2765.9531,-2864.6086,-2715.133,-2682.5894,-2414.7854,-2192.914,-2015.0398,-2020.4282,-2389.7363,-2220.3684,-2881.9395,-1905.0681,-1920.472,-2001.2914,-1899.4033,-2483.508,-2684.172,-1949.2474,-1993.992,-1989.8357,1137.5616,647.79913,350.41714,98.45662,-105.91102,-213.86142,-280.74185,-351.79083,-652.66675,-872.5869,-690.9566,-704.2872,55.151257,169.13579,-37.613064,-241.85999,-395.76883,-468.3484,-546.7896,-615.9147,-645.4861,-755.75476,-770.6507,-965.8659,-1392.2456,-2026.8209,-2473.3474,-2696.0337,-2980.107,-3259.1597,-3435.9607,-3554.42,-3686.8457,-3749.6162,-3718.9136,-3647.2,-3773.2458,-3709.6348,-3749.3416,-3641.4548,-3520.1064,-3500.1387,-3126.7197,-2981.0347,-2973.8599,-2994.071,-2965.3782,-2688.9268,-2420.3933,-2197.878,-2037.3136,-2113.5786,-2025.8368,-2290.356,-1991.0647,-2291.6904,-2297.434,-1921.582,-1920.4119,-1924.378,-2093.0242,-1946.456,-1948.3612,-2001.1196,1270.4259,703.07135,288.10895,101.15425};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-81.25558,-232.59953,-322.94186,-381.07022,-618.94855,-911.8482,-715.7603,-1063.2883,60.84706,211.38608,2.068874,-133.10944,-280.78632,-402.92462,-499.7893,-572.9197,-632.7458,-722.5492,-907.9213,-911.13763,-1670.2554,-2288.561,-2608.81,-2932.5505,-3243.5635,-3456.9695,-3573.0635,-3639.464,-3729.3008,-3778.0798,-3774.2043,-3799.6675,-3787.2556,-3784.7266,-3755.264,-3744.8098,-3659.8564,-3533.796,-3253.8464,-3163.5322,-3181.7993,-3184.2468,-3052.3638,-2845.3062,-2512.7146,-2401.944,-2186.81,-1898.0256,-1713.4968,-2298.1301,-2114.0193,-2280.9758,-2110.9917,-2154.5415,-1834.3885,-1759.8163,-1939.573,-2154.753,-2172.2625,-2039.7057,1240.8132,661.0153,-229.83792,130.51529,-2.329095,-113.27569,-213.50131,-211.06337,-468.24542,-756.8999,-981.7661,-1230.9031,-876.295,-329.09082,-79.542076,-71.66819,-165.73065,-342.16965,-414.32535,-451.8549,-569.9916,-695.5127,-803.49945,-957.38074,-1818.7766,-2253.9714,-2616.8076,-2946.6975,-3366.0874,-3592.256,-3649.3936,-3687.5132,-3790.2195,-3824.1643,-3825.4683,-3822.031,-3792.282,-3751.559,-3669.854,-3676.6409};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {-3766.5928,-3573.9045,-3329.7595,-3331.5442,-3316.4734,-3390.8555,-3295.7695,-3543.7605,-2710.0608,-2393.1714,-2259.4111,-2019.028,-2064.687,-2200.6963,-2044.2771,-1825.843,-1823.1611,-2970.4468,-2252.1165,-1815.792,-1934.3271,-1978.6876,-2098.612,-2064.7688,1105.3741,741.2104,332.19336,292.9285,169.71538,29.727367,-33.667458,-113.850746,-271.95108,-413.96005,-802.4675,-1206.971,-1266.0172,-1444.9073,-1106.5466,-1295.5183,-1575.7065,-1869.8325,-1608.0476,-570.49243,-534.53,-602.99005,-680.14764,-826.57965,-1828.1678,-2248.243,-2616.3557,-2934.9307,-3361.9446,-3613.5286,-3706.83,-3723.8655,-3830.5664,-3862.6257,-3849.669,-3853.5952,-3794.4028,-3790.2605,-3638.915,-3642.214,-3821.9722,-3674.9236,-3479.8704,-3517.7651,-3516.4834,-3584.5845,-3492.2046,-3682.5596,-3074.208,-2406.6184,-2562.8926,-2264.6743,-2177.6116,-2068.2305,-2031.6956,-1804.9287,-1879.8135,-3478.205,-2526.3335,-1938.3882,-1977.8274,-1972.1764,-2005.5795,-2080.3289,1047.6016,647.0138,460.3714,346.00412,268.6021,139.80249,33.571606,-26.535877,-174.49106,-249.65378,-385.03357,-919.79156};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {-578.9009,-300.06503,-75.78441,-186.20126,-403.085,-770.38617,-1720.3274,-1831.5825,-2366.671,-2154.339,-832.29675,-884.6974,-1954.0764,-2412.2673,-2774.176,-3112.3096,-3472.0452,-3664.4285,-3738.7385,-3769.3179,-3850.0557,-3878.9495,-3898.8186,-3890.886,-3853.091,-3882.2852,-3793.9258,-3765.8445,-3811.7231,-3749.073,-3651.8442,-3620.369,-3653.5193,-3690.4487,-3700.0762,-3547.6536,-3199.809,-3315.1062,-2831.762,-2242.4133,-1917.741,-2218.47,-2044.9988,-2039.1487,-2127.7454,-1995.629,-2069.9583,-2139.202,-2112.4553,-1991.6447,-2705.81,-1941.2072,1015.2752,617.51196,450.15448,347.76462,317.18228,218.3607,254.80766,460.40567,384.8971,50.05761,-124.8778,-574.65186,-866.66345,-612.1449,-246.99016,-166.1828,-220.61848,-366.3965,-1283.8853,-2232.493,-2722.263,-2921.6567,-2238.755,-1927.7542,-2590.6287,-2935.5627,-3165.8477,-3414.8682,-3680.0088,-3758.4922,-3788.0173,-3816.5432,-3862.683,-3907.6711,-3914.6975,-3902.3535,-3870.434,-3899.6235,-3918.5283,-3764.974,-3753.4565,-3669.8115,-3797.3816,-3720.295,-3700.7117,-3727.9697,-3806.6448,-3804.8828};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {-3523.271,-3306.205,-3204.239,-2487.1287,-2292.7205,-2198.9165,-2357.302,-2268.0996,-2266.0,-2335.0308,-2203.8374,-2164.8716,-2194.4976,-2159.8,-2130.5574,-2093.4111,1002.4217,680.2003,496.987,420.36377,385.48837,359.6735,549.48724,733.18726,781.8235,696.3785,-81.14866,-619.0151,-1012.7373,-1274.3384,-1547.085,-1041.0095,-1088.1375,-1879.8132,-2254.321,-2536.1658,-2321.0286,-1446.8793,-2194.5046,-2455.8457,-3244.7537,-3525.6013,-3573.2075,-3599.322,-3684.9343,-3756.1238,-3784.54,-3797.9275,-3866.4639,-3914.7812,-3932.5706,-3902.93,-3913.575,-3887.705,-3899.21,-3914.2021,-3748.6614,-3665.2405,-3852.7898,-3796.7097,-3744.3533,-3797.9983,-3808.2585,-3891.8765,-3855.71,-3646.7124,-3097.481,-2709.0293,-2694.4116,-2476.6333,-2673.9336,-2671.7446,-2448.3843,-2411.7666,-2233.4907,-2039.804,-2084.1748,-2236.3855,-2236.0793,-2141.4963,1023.84174,731.8762,513.9838,415.16556,397.00418,547.5396,872.4447,878.9238,676.8092,471.15805,-34.333057,-642.5958,-747.165,-874.1342,-1181.6672,-1384.886,-1479.401,-1656.1511,-1865.7253,-2101.9712};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {-2466.5742,-1777.0322,-1379.7404,-1802.5256,-3073.841,-3322.9868,-3395.694,-3223.8945,-3534.6738,-3647.4844,-3712.556,-3764.1458,-3816.0288,-3915.5806,-3926.255,-3892.357,-3883.459,-3941.3098,-3935.0176,-3967.1958,-3921.6448,-3840.1958,-3876.6636,-3862.4197,-3808.4092,-3854.0005,-3857.84,-3938.6267,-3919.5835,-3796.7734,-3350.045,-3178.8413,-3136.4731,-2704.2795,-2784.465,-2731.3616,-2705.4922,-2415.014,-2038.1205,-2467.601,-2721.4924,-2260.8853,-2296.2507,-2255.1929,924.83075,684.5406,475.6578,358.39465,340.1449,556.52765,936.55035,881.20026,520.45416,350.92786,300.53702,-171.19167,-505.3715,-853.2012,-964.346,-953.01434,-943.9505,-1635.6685,-1893.5331,-2106.1458,-2438.6868,-2915.0967,-2879.3462,-3180.2996,-3343.417,-3246.853,-3278.1052,-3154.1943,-3497.4438,-3549.9307,-3650.5864,-3712.921,-3737.265,-3889.0996,-3916.4512,-3901.7695,-3913.7622,-3945.639,-3939.3606,-3974.5552,-3993.6233,-3979.9385,-3983.597,-3962.362,-3885.4736,-3910.8455,-3943.208,-3969.7407,-3961.79,-3973.6157,-3803.7454,-3414.8994,-3160.5042,-3107.2168,-3111.8264,-3162.1582};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {-2702.8926,-2394.6958,-2263.588,-2735.8225,-2621.0723,-2325.2617,-2264.2783,-2490.98,830.533,691.06915,531.7863,390.31033,425.71698,699.94525,984.785,661.8138,343.83804,323.4676,250.86589,99.98987,17.472252,-413.8165,-502.57367,-595.8038,-741.1447,-1103.3733,-1631.222,-2050.2766,-2193.3477,-2043.6215,-2192.1826,-2490.4526,-2757.603,-3026.6533,-3226.0205,-3397.6458,-3435.0315,-3565.7239,-3611.6707,-3669.7131,-3701.275,-3797.1167,-3881.3535,-3922.171,-3963.6277,-3960.5308,-3965.4937,-4009.0671,-3977.2178,-4011.2163,-4087.3313,-4037.8442,-3960.8625,-3960.7007,-3996.7808,-3983.0566,-3990.5098,-3997.1812,-3914.0425,-3822.2856,-3633.9812,-3488.8262,-3384.5764,-3363.5972,-2935.539,-2589.157,-2469.3213,-2332.4915,-2226.053,-2376.3403,-2505.9004,-2554.255,811.0852,801.9204,796.57184,801.8215,844.9588,929.345,945.4637,531.51886,296.14377,190.66884,142.73848,73.93811,-33.58457,-274.6408,-566.1645,-727.3004,-867.8028,-1000.9816,-956.0069,-1204.5192,-1260.0005,-973.18024,-1064.4089,-1204.9974,-1953.6362,-2803.6406,-3185.1936,-3312.6711};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {-3515.147,-3595.9607,-3653.6057,-3694.5156,-3724.1506,-3743.224,-3829.6985,-3928.181,-3940.418,-4012.6184,-4039.9229,-4061.0005,-4078.5818,-4082.0586,-4129.37,-4159.1577,-4066.4358,-4050.8877,-4085.4553,-4036.0,-4017.9473,-4023.9622,-4065.234,-4034.567,-3925.2454,-3638.0295,-3521.3079,-3315.614,-3088.1375,-2858.5496,-2632.3904,-2553.7898,-2473.082,-2436.135,-2459.0017,-2414.9314,1102.0322,853.839,695.6222,631.85144,806.6054,1176.3562,881.4173,564.4703,259.12845,79.1888,132.41809,292.5364,229.80316,-188.80243,-665.0705,-916.2209,-1047.3583,-1151.4125,-1099.3271,-1174.5614,-1197.0974,-1188.4481,-1199.1353,-1077.4556,-1549.0621,-2780.1497,-3188.8364,-3372.715,-3537.6956,-3605.7075,-3670.7388,-3689.1028,-3744.032,-3750.4507,-3832.0874,-3868.1143,-3980.0024,-4113.0605,-4081.9424,-4105.204,-4101.0967,-4164.1616,-4181.1006,-4205.78,-4174.585,-4177.42,-4186.44,-4154.061,-4095.371,-4084.6345,-4155.6743,-4100.944,-4031.269,-3933.3887,-3560.704,-4059.8364,-3412.3716,-2973.376,-2831.4453,-2611.743,-2674.6438,-2884.6465,-2506.296,-2378.9514};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1339.5021,988.71655,601.6498,520.51447,634.1364,908.55396,818.2064,547.1608,513.22815,656.58844,714.93317,691.9577,386.26443,-44.600597,-588.6589,-930.86176,-1089.4265,-1221.002,-1258.5419,-1301.2336,-1314.7944,-1334.7512,-1256.7346,-1296.514,-1737.9999,-2724.796,-3315.3547,-3466.4866,-3567.9873,-3617.7449,-3677.5186,-3684.6826,-3733.0127,-3777.3977,-3865.785,-3890.7024,-3987.1565,-4072.6836,-4069.7678,-4106.3823,-4171.95,-4169.2505,-4214.6694,-4257.8755,-4243.512,-4280.709,-4266.7817,-4233.971,-4197.036,-4149.0303,-4198.539,-4135.5215,-4117.2217,-4024.4497,-3777.689,-3622.9888,-3478.7983,-3241.1245,-3231.3062,-3204.1858,-3007.2095,-2906.8513,-2808.5972,-2744.589,994.50464,1000.3566,864.852,702.75037,625.89325,392.65598,384.89282,616.81244,794.6935,1078.2852,1017.82666,1108.9956,1101.1064,490.10098,-183.44986,-864.26056,-1082.1387,-1188.4932,-1272.1497,-1211.5477,-1130.346,-1151.3989,-1148.0226,-1208.6195,-2016.134,-2754.1528,-3323.692,-3460.7363,-3509.6877,-3616.287,-3660.2644,-3687.5586,-3730.4934,-3817.8652,-3860.8599,-3924.6519};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {-3992.7427,-4058.2573,-4096.9204,-4135.8843,-4206.445,-4223.3306,-4275.886,-4308.4316,-4327.281,-4335.658,-4313.9634,-4302.0605,-4261.1294,-4268.861,-4248.4526,-4192.708,-4183.4287,-4153.7144,-3977.0674,-3930.9573,-3823.9814,-3791.096,-3669.9197,-3555.273,-3281.2388,-3134.9644,-3400.712,-3221.8904,900.3759,987.6271,1296.4108,1212.5831,506.08807,308.3914,86.18774,558.63055,776.7693,989.79736,1023.0798,1211.7268,1341.2516,1047.978,336.34088,-578.6478,-918.90564,-1063.1549,-1221.8306,-1311.0261,-1174.5116,-1583.5122,-1563.185,-1479.1432,-1848.7633,-2581.978,-3200.774,-3485.2969,-3571.3938,-3632.8223,-3669.9358,-3726.3438,-3757.8328,-3833.7898,-3908.521,-3978.69,-4046.8489,-4082.882,-4122.9023,-4155.957,-4214.082,-4284.82,-4325.479,-4361.3184,-4408.144,-4402.5605,-4428.5073,-4414.198,-4346.66,-4348.9546,-4305.615,-4318.539,-4273.0137,-4250.9663,-4277.536,-4135.2407,-4023.7783,-3900.8298,-3870.5662,-3772.9077,-3611.858,-3459.936,-3412.4377,-3122.4873,705.1283,839.537,1503.8573,1798.8915,793.82904,673.1664,588.0609,692.2661};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {860.9607,987.0488,1086.2893,1304.963,1124.2935,1073.8333,599.4377,-78.431625,-548.76514,-934.0221,-992.90906,-990.1716,-952.06195,-1517.9004,-1725.6024,-1731.3064,-1776.1886,-2377.8264,-3020.1248,-3457.881,-3621.793,-3650.4648,-3677.9207,-3725.234,-3785.8516,-3859.033,-3914.7822,-4012.0063,-4077.0195,-4136.17,-4149.913,-4216.685,-4279.319,-4341.3955,-4378.367,-4441.4976,-4450.904,-4457.266,-4497.4194,-4490.368,-4454.746,-4450.659,-4386.863,-4397.8984,-4404.423,-4347.575,-4334.8447,-4295.7217,-4133.011,-4083.6582,-3998.3684,-3885.6157,-3894.881,-3815.1445,-3595.8262,-3359.7703,644.8818,721.96313,931.51996,1402.7882,1002.0043,879.6407,913.64874,952.2769,1032.6877,1188.1245,1102.2866,1060.4609,520.1485,742.1001,658.338,178.66637,-344.77655,-768.69293,-901.4285,-839.80566,-843.32513,-1157.8898,-1621.9955,-1778.431,-1753.7991,-2284.4333,-3001.3398,-3383.8271,-3648.0574,-3685.6155,-3734.488,-3745.951,-3811.3313,-3886.0818,-3943.8281,-4024.8591,-4076.2544,-4166.8584,-4190.9287,-4293.773,-4345.571,-4406.6836,-4438.9395,-4504.6113};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {-4508.241,-4528.4644,-4552.596,-4533.5127,-4538.488,-4541.4556,-4487.218,-4498.3677,-4458.72,-4547.5693,-4534.752,-4443.102,-4327.1323,-4227.7266,-4122.7964,-4073.9834,-3938.286,-3801.953,-3868.5222,-3723.8254,719.0383,721.29724,1105.2532,1433.8417,1126.2988,1025.4159,1039.3871,928.3353,819.2136,886.68164,1081.4254,953.0258,640.41125,479.6856,547.89087,281.2242,-129.15779,-726.71576,-1008.4264,-989.62256,-1156.5167,-1207.7074,-1349.5299,-1619.4043,-1656.5778,-2168.9854,-2716.946,-3306.3684,-3680.3757,-3758.4397,-3804.1926,-3826.6985,-3863.4526,-3927.6394,-4013.6267,-4077.246,-4173.9155,-4236.4023,-4316.798,-4367.569,-4411.234,-4444.2925,-4493.5864,-4554.4683,-4560.26,-4562.7803,-4562.417,-4584.696,-4595.1577,-4571.752,-4546.1245,-4547.7734,-4523.3823,-4501.527,-4522.82,-4555.09,-4489.9053,-4301.062,-4256.6934,-4215.9634,-4096.7363,-4019.915,-4019.953,-3928.2437,224.05125,291.1406,479.98206,1371.4495,801.31464,1011.8707,1034.2516,1325.2814,1217.1223,1269.1979,1334.5105,1062.7919,468.4292,-47.61799,239.83769,153.96205};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {-162.21164,-515.9095,-823.05597,-1387.4323,-1573.1565,-1568.2444,-1564.7241,-1672.0183,-1944.6696,-2280.6497,-2737.4097,-3358.4285,-3692.2856,-3817.0835,-3860.9294,-3905.3564,-3939.866,-4002.6372,-4059.4485,-4145.528,-4276.2695,-4300.235,-4408.6396,-4443.376,-4496.3457,-4503.749,-4535.687,-4594.863,-4616.441,-4604.961,-4609.493,-4650.3403,-4641.859,-4604.964,-4620.928,-4598.155,-4575.0557,-4567.6406,-4532.4956,-4515.084,-4458.744,-4331.4053,-4338.93,-4269.812,-4247.0884,-4172.586,-4158.8955,-4048.8955,-647.0317,-655.8351,-667.5128,3.380492,872.1158,769.3409,1041.7535,1501.1785,1668.6182,874.7976,318.29227,383.9465,248.75833,316.41516,215.7755,-473.96393,-921.5533,-756.02924,-864.5525,-1227.025,-1596.6993,-1791.0176,-1895.9727,-2217.7532,-2465.883,-2739.5881,-3018.9055,-3387.3887,-3719.122,-3838.0503,-3885.7803,-3964.6938,-4034.5864,-4092.386,-4146.863,-4209.1846,-4314.784,-4384.8325,-4445.9146,-4496.0605,-4543.348,-4539.163,-4591.1655,-4631.199,-4642.532,-4642.6807,-4668.84,-4711.6704,-4717.3594,-4673.1245,-4634.8755,-4661.599};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {-4641.2817,-4611.163,-4582.5796,-4524.399,-4496.6055,-4471.876,-4408.1924,-4381.7036,-4347.2036,-4259.8496,-4206.895,-4176.67,-887.19116,-959.7797,-945.9107,-702.7259,253.33308,1275.619,1011.9177,865.00726,855.9632,95.10663,-423.97913,-240.82193,-276.6759,-546.2388,-999.6402,-1266.9423,-1693.7068,-1269.2539,-900.726,-1230.8003,-1560.466,-1876.6703,-2135.9802,-2522.0317,-2795.2275,-3096.8591,-3388.8943,-3664.6226,-3842.9893,-3911.8962,-3967.9548,-4023.0332,-4109.4917,-4162.713,-4207.9956,-4306.903,-4384.739,-4445.4062,-4484.8433,-4506.5093,-4572.6006,-4584.9585,-4594.277,-4587.5195,-4541.644,-4465.167,-4467.192,-4780.4756,-4745.673,-4713.1455,-4721.0576,-4724.432,-4689.63,-4649.1875,-4622.9775,-4585.274,-4556.6123,-4557.5107,-4537.7207,-4489.581,-4453.9062,-4371.845,-4335.1494,-4345.512,-772.0,-853.86334,-788.0925,-600.3838,-138.67058,391.6182,365.0869,-206.931,-570.3438,-1493.4608,-1802.8715,-1398.9198,-1158.0842,-1166.2024,-1269.7083,-1524.1682,-1373.9875,-2069.5793,-1989.7935,-1387.959,-1654.4374,-1993.7522,-2317.1887,-2776.888};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {-3036.7175,-3358.2607,-3640.192,-3783.5117,-3894.3027,-3979.1516,-4027.1843,-4125.541,-4184.1416,-4223.092,-4282.137,-4362.37,-4421.683,-4467.629,-4506.043,-4547.838,-4583.7373,-4610.798,-4602.2393,-4598.492,-4639.5103,-4602.558,-4629.572,-4749.11,-4739.5195,-4735.8213,-4746.762,-4744.1577,-4706.956,-4670.023,-4703.795,-4645.4854,-4617.0386,-4604.721,-4595.267,-4544.5347,-4504.207,-4497.456,-4419.458,-4367.495,-627.6364,-804.9385,-865.7055,-779.11523,-1095.9459,-1476.8685,-1154.138,-2100.8625,-2523.6816,-2964.7332,-3039.5454,-2906.9111,-2594.8855,-2361.623,-1840.3545,-1686.0322,-1704.7025,-1791.0519,-2038.3535,-2070.9314,-2091.1267,-2402.2676,-2749.5283,-3108.0193,-3353.3765,-3566.465,-3712.9817,-3842.3274,-3951.0007,-4029.1023,-4093.5554,-4195.834,-4267.074,-4299.4497,-4388.4126,-4421.467,-4482.166,-4526.34,-4571.7124,-4583.7305,-4649.529,-4661.716,-4646.3867,-4651.8364,-4722.0117,-4651.0664,-4710.957,-4759.9336,-4783.231,-4777.0557,-4780.8955,-4761.572,-4757.4688,-4740.4697,-4705.632,-4678.039,-4656.4126,-4648.8887,-4623.029,-4566.143};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {-4528.9805,-4544.8013,-4521.1284,-4485.8687,-795.92804,-1041.1206,-1323.6587,-1620.1675,-2214.0427,-2522.0747,-2679.998,-2897.7349,-3050.0728,-3170.3328,-3277.5337,-3364.4568,-3431.751,-3394.1313,-3173.9016,-2256.341,-1874.5825,-1871.969,-1996.3082,-2154.2427,-2745.1716,-3032.4287,-3108.7815,-3364.5527,-3544.2634,-3798.0808,-3944.3584,-3972.7563,-4022.171,-4106.922,-4153.2075,-4249.035,-4343.0093,-4404.104,-4448.3794,-4488.2646,-4556.7993,-4604.8374,-4651.8687,-4675.5615,-4691.524,-4710.8696,-4722.852,-4718.1943,-4782.711,-4752.8535,-4804.997,-4920.42,-4869.6416,-4835.3975,-4697.99,-4756.7715,-4790.5386,-4759.6724,-4687.7734,-4739.318,-4689.884,-4649.5405,-4590.821,-4559.2783,-4570.502,-4575.539,-4562.92,-4540.921,-1318.7881,-1560.1927,-1687.6492,-2006.5566,-2336.9258,-2608.1277,-2839.0884,-2995.3127,-3127.267,-3245.212,-3328.157,-3386.329,-3434.6543,-3439.166,-3542.8901,-2903.639,-2150.1938,-2309.8762,-2373.5566,-2642.1538,-3137.7847,-3456.9534,-3543.2874,-3743.1514,-3836.1348,-3962.6653,-4006.041,-4027.212,-4116.2837,-4208.208,-4273.2236,-4370.1187};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {-4440.493,-4455.473,-4505.8154,-4587.427,-4652.74,-4671.2026,-4673.205,-4722.0054,-4746.536,-4764.2188,-4777.165,-4788.471,-4768.3794,-4805.8623,-4832.638,-4868.138,-4949.26,-4869.329,-4783.12,-4824.035,-4819.623,-4777.4624,-4735.131,-4746.6914,-4755.048,-4751.341,-4668.372,-4630.8433,-4637.409,-4607.955,-4536.335,-4534.1963,-1696.8694,-1922.3994,-2033.4736,-2271.3489,-2534.944,-2770.7327,-2963.844,-3119.2598,-3250.414,-3313.3562,-3371.9429,-3433.7502,-3507.0205,-3540.014,-3590.446,-3514.9563,-2998.8457,-3041.9434,-3271.631,-3233.2297,-3619.761,-3836.9062,-3938.9675,-4020.3777,-4062.138,-4134.1274,-4155.0605,-4210.477,-4271.552,-4343.537,-4408.6553,-4471.497,-4524.819,-4543.382,-4598.807,-4677.2573,-4713.05,-4733.613,-4737.4634,-4763.5996,-4777.5957,-4790.3477,-4823.446,-4828.394,-4840.1245,-4835.757,-4841.1416,-4891.7666,-4852.532,-4857.58,-4833.204,-4866.1387,-4853.2666,-4830.5967,-4835.9473,-4830.9565,-4861.478,-4836.5713,-4790.209,-4711.154,-4679.81,-4657.7485,-4597.999,-4593.0474,-1901.8926,-2101.272,-2279.5532,-2712.5762};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {-3039.165,-3091.608,-3235.875,-3308.4138,-3341.5989,-3340.7058,-3628.0444,-3475.639,-3538.6257,-3604.5837,-3676.33,-3742.9094,-3786.3933,-3830.042,-3927.1008,-3998.907,-4035.6653,-4076.0452,-4119.6436,-4197.8027,-4272.873,-4318.214,-4381.584,-4435.015,-4464.911,-4497.9175,-4529.854,-4585.304,-4606.7153,-4632.492,-4687.2866,-4740.4956,-4792.2134,-4801.301,-4799.749,-4845.093,-4845.456,-4872.863,-4865.7876,-4885.5825,-4891.0464,-4900.227,-4870.395,-4902.2686,-4937.24,-4898.413,-4927.406,-4910.8486,-4895.2334,-4884.237,-4877.513,-4900.4043,-4851.158,-4805.635,-4779.104,-4752.7036,-4728.8657,-4698.978,-4671.8403,-4656.332,-2111.8325,-2329.875,-2536.33,-2778.4973,-3067.498,-3212.439,-3305.8838,-3364.6094,-3402.1592,-3432.4897,-3464.6904,-3532.3154,-3599.461,-3677.2305,-3765.6248,-3840.366,-3901.5903,-3946.5325,-4019.7817,-4088.5886,-4182.0166,-4255.815,-4304.536,-4365.404,-4409.8677,-4441.7495,-4476.675,-4521.84,-4553.644,-4581.8823,-4624.8706,-4669.2256,-4695.6562,-4730.57,-4770.862,-4801.8394,-4827.773,-4871.6074,-4867.714,-4897.014};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-4891.472,-4920.5425,-4921.202,-4946.973,-4949.353,-4937.534,-4948.4883,-4934.475,-4937.143,-4920.067,-4902.9946,-4919.9287,-4947.5684,-4914.6416,-4903.665,-4803.941,-5044.101,-4757.6226,-4792.286,-4766.611,-4746.204,-4740.324,-4724.5938,-4687.877,-2439.6824,-2641.8743,-2843.4883,-3034.5615,-3173.1262,-3259.6975,-3347.989,-3411.5205,-3443.9597,-3492.8176,-3565.558,-3626.0615,-3686.7046,-3754.3833,-3825.838,-3895.6165,-3971.924,-4052.6345,-4125.2773,-4208.0723,-4286.4976,-4385.3813,-4457.4067,-4474.7837,-4509.1973,-4541.6895,-4580.003,-4610.1924,-4634.9614,-4658.66,-4704.54,-4738.593,-4753.6675,-4783.6465,-4807.555,-4817.6055,-4868.7446,-4898.7075,-4934.7334,-4938.1006,-4972.435,-4961.342,-4959.598,-4992.9204,-4986.1055,-4982.801,-5030.509,-4977.8247,-4957.413,-4975.659,-4961.932,-4944.3335,-4924.7056,-4922.094,-4928.936,-4813.866,-4810.626,-4771.8315,-4829.0273,-4788.358,-4794.781,-4767.6494,-4740.088,-4713.6636,-2828.2283,-2966.9558,-3075.4163,-3186.472,-3289.4155,-3375.8396,-3428.4976,-3466.9668,-3548.8335,-3611.7722,-3664.976,-3719.4658};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {-3799.576,-3861.8276,-3920.6624,-3989.2654,-4063.7185,-4128.5547,-4197.926,-4272.768,-4366.388,-4460.1294,-4530.168,-4575.928,-4616.19,-4647.013,-4658.464,-4686.8633,-4717.197,-4747.3945,-4772.904,-4808.8003,-4813.3457,-4844.9053,-4864.2505,-4887.58,-4916.9453,-4917.2324,-4928.6914,-4955.2285,-4979.653,-4994.704,-5016.962,-5002.499,-4999.611,-5016.415,-5047.199,-5039.6855,-5015.702,-5006.518,-4951.331,-4966.2236,-4964.5044,-4951.0483,-4927.1367,-4913.078,-4916.192,-4886.5415,-4881.59,-4847.9966,-4823.0933,-4808.933,-4759.399,-4705.682,-3085.4543,-3148.9778,-3220.7695,-3312.7988,-3409.7463,-3490.1414,-3519.6094,-3773.4348,-3651.823,-3736.9194,-3813.685,-3860.499,-3923.2664,-3992.607,-4056.1206,-4114.021,-4184.0156,-4257.342,-4312.317,-4359.018,-4411.0635,-4476.4146,-4579.906,-4660.2935,-4701.4395,-4716.766,-4741.912,-4774.6772,-4794.656,-4798.2637,-4804.086,-4854.172,-4890.4175,-4919.7524,-4926.395,-4955.4243,-4983.397,-4964.9067,-4969.2397,-5010.316,-5044.895,-5064.296,-5049.162,-5039.422,-5040.274,-5033.406,-5038.4434,-5046.658};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {-5058.21,-5078.291,-5023.117,-5017.602,-5012.914,-4977.3813,-4962.5034,-4951.824,-4932.2476,-4922.5513,-4901.1357,-4890.6934,-4850.9062,-4827.0977,-4788.6455,-4720.9355,-3279.6716,-3334.7324,-3392.711,-3457.0352,-3543.8804,-3631.703,-3700.8376,-3765.3196,-3820.427,-3882.885,-3957.2222,-4021.5793,-4088.57,-4138.797,-4200.809,-4260.3306,-4317.0693,-4370.198,-4432.4077,-4469.2734,-4520.617,-4567.718,-4646.1543,-4699.7363,-4743.202,-4785.3643,-4863.6636,-4844.428,-4817.072,-4965.5527,-4893.564,-4952.275,-4961.42,-4970.659,-4982.006,-5024.609,-5029.0054,-5013.185,-5036.5317,-5047.081,-5070.311,-5120.3105,-5124.616,-5085.337,-5094.548,-5093.893,-5063.7056,-5043.3813,-5046.2065,-5059.6694,-5053.3135,-5039.8237,-5008.961,-5010.9385,-4996.501,-4981.7544,-4961.8555,-4916.968,-4873.2227,-4857.0947,-4847.3325,-4804.214,-4780.572,-4753.693,-3496.4688,-3539.6267,-3585.9275,-3631.5862,-3702.1753,-3763.3972,-3834.361,-3917.2288,-3974.101,-4022.592,-4095.5913,-4170.257,-4241.2886,-4305.746,-4355.991,-4418.6606,-4459.2437,-4504.219,-4550.152,-4604.715};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {-4640.834,-4663.0254,-4726.5586,-4781.6724,-4831.8506,-4872.145,-4900.758,-4912.249,-4934.369,-4971.899,-4996.4375,-5000.2183,-4998.835,-5000.9976,-5021.779,-5046.085,-5040.1807,-5046.0205,-5069.079,-5073.5166,-5080.7866,-5101.508,-5124.969,-5118.9204,-5106.2197,-5094.082,-5078.3584,-5069.4565,-5061.0664,-5086.4155,-5094.1865,-5069.0015,-5038.1206,-5021.767,-4981.388,-4905.9033,-4782.111,-4698.2993,-4815.168,-4856.2,-4850.665,-4827.517,-4812.6714,-4796.6396,-3700.3813,-3729.5547,-3771.9036,-3822.3838,-3868.9736,-3923.387,-3979.1472,-4040.0261,-4098.1846,-4155.6934,-4239.977,-4307.9404,-4384.3047,-4447.6426,-4509.769,-4575.3325,-4631.2993,-4682.4126,-4713.8286,-4745.8228,-4761.7188,-4787.0737,-4823.0737,-4879.4185,-4918.3413,-4926.4946,-4946.0957,-4986.196,-5018.7417,-5045.4263,-5047.852,-5034.58,-5010.477,-5045.196,-5078.922,-5069.2397,-5057.063,-5064.3047,-5099.12,-5112.953,-5108.7515,-5124.5996,-5127.816,-5138.7754,-5128.3994,-5125.3755,-5116.955,-5113.011,-5125.1943,-5134.2085,-5127.484,-5091.7563,-5061.2236,-5012.4297,-4842.23,-4864.168};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {-6176.509,-6137.2334,-4688.102,-4709.57,-4854.102,-4847.4507,-4838.3203,-4837.2295,-3851.3596,-3901.18,-3942.218,-3996.2175,-4045.8328,-4084.0598,-4132.9053,-4192.1626,-4240.24,-4335.519,-4363.585,-4442.0156,-4513.268,-4588.5557,-4662.723,-4724.888,-4800.7603,-4861.2656,-4920.1826,-4954.7266,-4977.033,-4997.018,-5019.761,-5031.542,-5033.6616,-5025.4424,-5038.2095,-5052.8486,-5058.65,-5071.259,-5069.964,-5053.783,-5074.397,-5113.1504,-5108.672,-5093.239,-5107.0884,-5124.224,-5141.0117,-5141.815,-5140.4526,-5124.6987,-5139.04,-5149.28,-5145.3774,-5107.511,-5124.6626,-5152.8735,-5162.9653,-5144.9775,-5116.279,-5097.204,-5072.0957,-5028.1675,-4890.4897,-4728.436,-5257.333,-5239.7837,-4615.4673,-4785.2524,-4865.691,-4861.611,-4840.5996,-4834.7944,-3988.8704,-4045.1936,-4100.637,-4164.6655,-4230.4834,-4299.0527,-4361.4023,-4414.795,-4471.244,-4531.759,-4585.243,-4649.0293,-4702.536,-4763.088,-4828.263,-4889.2476,-4944.532,-4994.6816,-5027.653,-5065.14,-5101.382,-5130.099,-5144.681,-5140.5674,-5116.741,-5097.6816,-5087.3193,-5096.4277};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {-5088.9185,-5086.738,-5095.4834,-5114.3447,-5134.549,-5140.8657,-5131.1055,-5153.393,-5168.9146,-5163.8555,-5149.7485,-5171.543,-5182.479,-5169.456,-5154.2046,-5173.364,-5136.772,-5102.7627,-5140.1274,-5160.5327,-5156.8047,-5141.313,-5102.6113,-5080.5264,-5052.872,-5037.4795,-5018.6333,-4967.645,-4918.1753,-4879.485,-4872.9126,-4879.0894,-4869.664,-4879.132,-4871.192,-4841.8228,-4166.5312,-4230.5356,-4320.3535,-4401.063,-4463.1885,-4519.4653,-4573.48,-4621.0723,-4659.611,-4686.697,-4729.4785,-4776.3877,-4821.5137,-4864.449,-4906.3804,-4961.038,-5000.6245,-5020.492,-5054.2183,-5085.6553,-5101.8647,-5111.7935,-5126.6997,-5141.875,-5127.5615,-5126.304,-5112.7866,-5118.5522,-5109.772,-5123.879,-5133.59,-5154.0522,-5148.606,-5140.421,-5166.15,-5183.014,-5188.2715,-5178.6465,-5196.1045,-5210.28,-5199.0894,-5176.6367,-5161.0215,-5180.434,-5156.289,-5144.5117,-5151.8574,-5144.4717,-5137.6426,-5114.836,-5072.555,-5074.942,-5091.366,-5061.9507,-5037.842,-5011.7993,-4982.7476,-4995.7363,-4920.4404,-4899.9463,-4869.6406,-4875.6934,-4854.969,-4824.1665};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {-4383.016,-4422.4956,-4488.0723,-4546.122,-4605.381,-4648.8467,-4694.377,-4728.3604,-4761.736,-4771.088,-4812.6255,-4811.9487,-4846.177,-4886.155,-4920.3765,-4950.0674,-4977.9697,-5003.095,-5033.8613,-5057.739,-5062.482,-5067.4336,-5073.9204,-5083.8315,-5083.9736,-5089.292,-5096.8677,-5108.195,-5133.8037,-5150.074,-5162.141,-5174.1265,-5175.6777,-5187.6133,-5189.199,-5189.99,-5196.6562,-5201.3916,-5194.4365,-5211.564,-5205.653,-5188.1636,-5149.144,-5155.023,-5173.5234,-5155.889,-5153.383,-5137.6826,-5122.9854,-5092.3677,-5076.9062,-5092.362,-5087.993,-5054.6904,-5027.097,-4995.82,-4919.3345,-5110.417,-4951.1704,-4914.039,-4912.806,-4886.708,-4864.859,-4838.4224,-4530.1396,-4573.0317,-4635.6333,-4682.4297,-4725.0474,-4751.4717,-4781.729,-4839.0166,-4863.8647,-4871.312,-4874.5645,-4873.3975,-4884.887,-4899.6426,-4911.034,-4922.619,-4934.35,-4957.1875,-4974.9287,-4989.9224,-4998.4355,-5003.0527,-5017.7905,-5030.8433,-5047.9263,-5067.449,-5078.906,-5091.312,-5115.119,-5135.861,-5141.5107,-5157.982,-5172.241,-5172.652,-5178.6655,-5194.719};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {-5193.815,-5191.398,-5206.437,-5209.6904,-5206.457,-5179.3096,-5176.2866,-5170.446,-5178.0654,-5153.2603,-5161.142,-5144.009,-5107.0522,-5078.644,-5080.075,-5041.374,-5113.919,-4999.6353,-5009.4272,-5007.5645,-4986.0947,-4980.6416,-4935.8,-4897.36,-4898.2134,-4876.8994,-4844.1436,-4796.383,-4682.836,-4694.708,-4739.6,-4764.585,-4803.5,-4810.2153,-4837.5815,-4873.5527,-4908.1323,-4933.1514,-4936.137,-4941.3213,-4942.585,-4946.67,-4940.628,-4933.356,-4932.9004,-4938.75,-4933.8716,-4951.548,-4977.041,-4985.8394,-5002.811,-5027.535,-5048.1943,-5060.0522,-5068.533,-5084.1836,-5103.863,-5129.838,-5129.186,-5131.68,-5124.371,-5136.586,-5152.038,-5172.3486,-5186.102,-5195.7617,-5212.9526,-5198.7427,-5175.201,-5189.622,-5204.127,-5205.7075,-5194.039,-5166.9243,-5143.491,-5111.7637,-5081.61,-5063.177,-5069.181,-5044.6855,-5014.201,-5002.282,-4991.063,-4996.0376,-4987.028,-4972.63,-4945.0166,-4915.0005,-4900.349,-4878.368,-4865.675,-4842.8096,-4755.1997,-4733.4214,-4798.5996,-4806.0034,-4825.354,-4860.711,-4904.7056,-4925.5103};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {-4941.946,-4961.403,-4977.322,-4978.6655,-4972.0103,-4975.149,-4955.14,-4984.0845,-4971.109,-4967.117,-4973.5557,-4989.3745,-5005.6963,-5027.8174,-5045.804,-5066.223,-5092.1875,-5106.8667,-5106.6987,-5121.2583,-5126.795,-5109.664,-5101.4497,-5122.9014,-5116.594,-5120.1807,-5129.5093,-5145.9517,-5170.436,-5177.091,-5190.2485,-5179.4434,-5173.26,-5181.3193,-5196.7686,-5198.3833,-5178.691,-5161.5693,-5122.6353,-5097.6045,-5087.5835,-5083.7495,-5072.195,-5055.7046,-5038.27,-4997.3105,-4979.546,-4972.358,-4959.0205,-4948.518,-4925.3022,-4899.2153,-4873.9087,-4863.2085,-4857.6304,-4826.849,-4842.391,-4824.221,-4833.2915,-4857.517,-4875.5576,-4905.446,-4938.485,-4964.566,-4978.403,-4970.692,-4973.973,-5001.543,-5027.5127,-5050.1313,-5052.775,-5065.166,-5036.1885,-5021.2427,-5030.8687,-5054.117,-5089.134,-5112.36,-5120.8955,-5092.3457,-5105.765,-5134.1196,-5147.5,-5140.045,-5126.368,-5106.3823,-5100.504,-5107.13,-5110.978,-5120.045,-5122.3813,-5151.1357,-5153.267,-5153.3257,-5155.376,-5158.8364,-5138.7466,-5149.0146,-5140.0615,-5135.589};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {-5125.8027,-5121.686,-5111.776,-5102.2075,-5096.3135,-5076.481,-5068.258,-5062.305,-5047.246,-5010.831,-4997.5415,-4966.4556,-4933.4473,-4900.819,-4863.8306,-4867.73,-4855.1113,-4855.33,-4849.275,-4835.8423,-4894.044,-4897.619,-4902.8477,-4921.3022,-4936.2085,-4956.109,-4966.6772,-4986.42,-4999.9043,-5002.932,-4993.5405,-5021.159,-5054.2856,-5061.2485,-5069.637,-5111.4185,-5102.5117,-5113.8574,-5125.993,-5136.3657,-5155.1426,-5166.59,-5136.9043,-4888.4478,-4908.184,-4983.1626,-5092.0176,-5116.5537,-5133.644,-5119.664,-5112.001,-5113.729,-5108.655,-5095.5776,-5094.3193,-5102.418,-5110.8677,-5108.8228,-5116.7505,-5121.736,-5108.5425,-5101.244,-5095.8584,-5099.029,-5095.095,-5091.808,-5098.3315,-5113.1304,-5097.298,-5074.6274,-5058.705,-5022.354,-5005.224,-4992.291,-4983.8467,-4969.991,-4951.217,-4923.3887,-4887.2944,-4861.4546,-4863.517,-4879.247,-4870.2256,-4847.222,-4886.023,-4900.7383,-4918.9546,-4926.301,-4939.8984,-4948.6836,-4966.879,-4986.195,-5006.307,-5021.0215,-5031.3516,-5038.501,-5066.373,-5079.4663,-5094.6333,-5110.981};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-5134.3022,-5157.952,-5161.308,-5168.7446,-5175.782,-5189.34,-5173.278,-5170.8374,-5154.083,-5143.8667,-5138.347,-5135.226,-5156.0137,-5206.373,-5200.549,-5176.347,-5143.449,-5122.9966,-5112.3457,-5086.4585,-5074.1426,-5063.33,-5065.3906,-5058.9644,-5060.6016,-5063.244,-4988.8965,-5023.206,-4981.765,-5019.3403,-5040.88,-5057.304,-5051.933,-5023.7695,-5020.817,-4981.2065,-4955.4155,-4921.9453,-4872.7603,-4891.628,-4894.959,-4832.1694,-4804.239,-4793.0957,-4746.8105,-4700.2915,-4635.0117,-4620.8853,-4903.798,-4918.728,-4926.055,-4929.198,-4939.3765,-4959.1143,-4961.406,-4908.156,-4869.5684,-4857.8213,-4871.974,-4884.516,-4908.0723,-4954.0425,-5008.503,-5048.1587,-5050.1567,-5021.3,-4998.161,-5034.9253,-5092.769,-5078.8223,-5021.4946,-4965.6035,-4949.9517,-4946.774,-4962.77,-5019.1426,-5130.205,-5157.3203,-5149.7764,-5084.478,-5032.0034,-5005.5933,-4975.6743,-4956.7095,-4941.071,-4903.4126,-4849.0977,-4827.9644,-4840.9697,-4805.1323,-4782.4556,-4729.2646,-4658.5205,-4580.8433,-4598.6836,-4550.4536,-4506.233,-4431.019,-4368.6484,-4303.2314};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {-4292.86,-4224.402,-4146.301,-4159.028,-4078.5098,-3978.6873,-3899.4565,-3895.9326,-3933.7666,-3862.0789,-3761.2822,-3703.8372,-4605.2515,-4628.7876,-4633.5146,-4662.3823,-4692.6445,-4806.19,-4815.09,-4708.2935,-4591.701,-4443.2007,-4351.7646,-4464.75,-4769.8525,-4662.5205,-4336.3013,-4214.722,-4175.215,-4134.19,-4141.084,-4217.486,-4335.6987,-4534.6206,-4766.806,-4817.0503,-4857.8955,-4882.076,-4902.007,-4919.383,-4956.6685,-4991.5757,-4951.84,-4824.0757,-4703.1953,-4616.3975,-4550.2754,-4528.3696,-4443.0493,-4373.2056,-4284.107,-4254.2373,-4295.3594,-4170.0317,-4106.715,-4087.6401,-4014.4612,-3996.4312,-3926.2761,-3863.9302,-3850.2527,-3765.409,-3704.114,-3696.9495,-3733.079,-3580.1042,-3537.4204,-3513.9705,-3502.7717,-3492.6294,-3432.0493,-3392.852,-3389.56,-3369.979,-3329.561,-3317.7197,-3770.6084,-3787.5444,-3801.5764,-3834.2302,-3865.2637,-3875.896,-3951.1035,-4081.3552,-4188.446,-4308.4346,-4340.475,-4370.988,-4318.9707,-4075.6272,-3999.6848,-3909.9778,-3881.2332,-3850.817,-3835.5027,-3825.882,-3862.2856,-3917.2498,-4137.091,-4377.5127};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {-4463.9863,-4548.9233,-4690.8706,-4765.632,-4803.0703,-4819.1885,-4874.687,-4906.631,-4851.5044,-4754.1313,-4637.292,-4497.006,-4400.8066,-4349.836,-4246.5547,-4182.333,-4101.934,-4026.7415,-3986.9124,-3951.686,-3882.6548,-3838.521,-3782.9172,-3731.6602,-3697.0654,-3663.1836,-3632.5696,-3610.9673,-3605.3289,-3554.1526,-3507.6042,-3462.3975,-3427.9646,-3403.96,-3378.8057,-3348.177,-3327.7607,-3315.835,-3305.706,-3294.6736,-3287.2336,-3289.5203,-3303.3462,-3316.6687,-3323.6455,-3335.6162,-3375.4487,-3409.5234,-3420.5198,-3436.018,-3487.5703,-3533.6367,-3572.541,-3613.4019,-3650.7317,-3658.771,-3655.4329,-3656.3892,-3654.4878,-3652.0425,-3640.4285,-3629.9805,-3621.7102,-3650.4275,-3670.853,-3707.9014,-3776.337,-3867.248,-3967.2363,-4057.5654,-4145.177,-4232.7686,-4331.3896,-4427.763,-4492.579,-4537.3022,-4551.534,-4546.9023,-4560.2427,-4573.3335,-4564.457,-4541.88,-4519.234,-4499.165,-4500.616,-4498.8286,-4461.5503,-4440.9546,-4441.9395,-4468.1235,-4488.8394,-4312.7373,-4087.2104,-4000.5251,-3934.635,-3878.0774,-3844.1162,-3832.573,-3832.194,-3848.5032};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {-3851.297,-3883.7231,-3980.6428,-4096.6914,-2911.0012,-2901.7021,-2887.91,-2888.5188,-2906.6833,-2936.992,-2952.0415,-2944.545,-2937.574,-2920.3682,-2911.9336,-2923.0334,-2955.1313,-2999.7297,-3045.4407,-3085.6218,-3116.706,-3144.0356,-3161.3203,-3165.778,-3161.1296,-3160.4275,-3173.8108,-3215.3564,-3232.2207,-3226.8945,-3267.5898,-3304.3882,-3331.0615,-3361.9094,-3397.5615,-3422.358,-3441.753,-3461.878,-3478.343,-3498.6301,-3528.103,-3586.8574,-3620.4878,-3641.384,-3635.2231,-3628.504,-3633.3647,-3657.574,-3690.0945,-3697.757,-3679.5254,-3672.2158,-3679.9775,-3674.081,-3639.4604,-3607.3171,-3611.4116,-3578.117,-3500.9,-3502.259,-3473.4902,-3442.1384,-3401.229,-3438.5552,-3398.3428,-3345.2146,-3335.6218,-3334.3418,-2450.7612,-2418.3208,-2421.1294,-2431.557,-2447.5837,-2457.9893,-2472.614,-2477.3228,-2488.3367,-2488.678,-2499.081,-2511.6287,-2532.115,-2551.1584,-2553.4658,-2562.4712,-2592.4287,-2604.8506,-2619.4905,-2639.7678,-2665.2207,-2689.5593,-2699.4302,-2710.4146,-2717.711,-2708.2456,-2703.7195,-2691.2593,-2689.9575,-2703.287,-2725.6797,-2791.4243};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {-2796.6025,-2796.9583,-2820.2192,-2829.4458,-2878.946,-2878.0525,-2863.6433,-2873.3855,-2902.0076,-2952.3438,-2947.96,-2940.6445,-2928.8354,-2957.7397,-2961.6682,-2984.762,-2987.091,-3015.553,-2977.868,-2973.027,-2945.0745,-2933.7402,-2909.316,-2940.757,-2934.5044,-2889.6628,-2887.6423,-2920.434,-2875.2192,-2877.3499,-2883.6187,-2895.0422,-2061.4817,-2033.2543,-2032.5022,-2037.015,-2041.2998,-2040.0343,-2042.1951,-2046.1467,-2066.4358,-2077.0178,-2090.0522,-2101.6396,-2118.8022,-2140.8054,-2155.2686,-2163.7788,-2177.259,-2177.2925,-2183.9646,-2191.1746,-2204.5645,-2217.8574,-2218.879,-2224.3794,-2233.6743,-2236.6514,-2270.9316,-2284.1216,-2297.928,-2273.3608,-2273.3682,-2304.8733,-2309.9478,-2325.3518,-2330.3762,-2339.1802,-2377.9333,-2380.7078,-2371.247,-2378.5093,-2382.7324,-2400.171,-2378.384,-2359.7092,-2355.078,-2376.1895,-2397.8398,-2426.2795,-2449.599,-2442.8035,-2426.5208,-2416.9854,-2406.7395,-2412.624,-2405.4148,-2436.9556,-2440.8694,-2416.6438,-2419.0657,-2444.586,-2421.3896,-2434.4465,-2429.014,-2492.2825};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.01587,0.00391,0.03175,0.00391,0.04762,0.00391,0.06349,0.00391,0.07937,0.00391,0.09524,0.00391,0.11111,0.00391,0.12698,0.00391,0.14286,0.00391,0.15873,0.00391,0.1746,0.00391,0.19048,0.00391,0.20635,0.00391,0.22222,0.00391,0.2381,0.00391,0.25397,0.00391,0.26984,0.00391,0.28571,0.00391,0.30159,0.00391,0.31746,0.00391,0.33333,0.00391,0.34921,0.00391,0.36508,0.00391,0.38095,0.00391,0.39683,0.00391,0.4127,0.00391,0.42857,0.00391,0.44444,0.00391,0.46032,0.00391,0.47619,0.00391,0.49206,0.00391,0.50794,0.00391,0.52381,0.00391,0.53968,0.00391,0.55556,0.00391,0.57143,0.00391,0.5873,0.00391,0.60317,0.00391,0.61905,0.00391,0.63492,0.00391,0.65079,0.00391,0.66667,0.00391,0.68254,0.00391,0.69841,0.00391,0.71429,0.00391,0.73016,0.00391,0.74603,0.00391,0.7619,0.00391,0.77778,0.00391,0.79365,0.00391,0.80952,0.00391,0.8254,0.00391,0.84127,0.00391,0.85714,0.00391,0.87302,0.00391,0.88889,0.00391,0.90476,0.00391,0.92063,0.00391,0.93651,0.00391,0.95238,0.00391,0.96825,0.00391,0.98413,0.00391,0.99609,0.00391,0.00391,0.01587,0.01587,0.01587,0.03175,0.01587,0.04762,0.01587,0.06349,0.01587,0.07937,0.01587,0.09524,0.01587,0.11111,0.01587,0.12698,0.01587,0.14286,0.01587,0.15873,0.01587,0.1746,0.01587,0.19048,0.01587,0.20635,0.01587,0.22222,0.01587,0.2381,0.01587,0.25397,0.01587,0.26984,0.01587,0.28571,0.01587,0.30159,0.01587,0.31746,0.01587,0.33333,0.01587,0.34921,0.01587,0.36508,0.01587,0.38095,0.01587,0.39683,0.01587,0.4127,0.01587,0.42857,0.01587,0.44444,0.01587,0.46032,0.01587,0.47619,0.01587,0.49206,0.01587,0.50794,0.01587,0.52381,0.01587,0.53968,0.01587,0.55556,0.01587};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.57143,0.01587,0.5873,0.01587,0.60317,0.01587,0.61905,0.01587,0.63492,0.01587,0.65079,0.01587,0.66667,0.01587,0.68254,0.01587,0.69841,0.01587,0.71429,0.01587,0.73016,0.01587,0.74603,0.01587,0.7619,0.01587,0.77778,0.01587,0.79365,0.01587,0.80952,0.01587,0.8254,0.01587,0.84127,0.01587,0.85714,0.01587,0.87302,0.01587,0.88889,0.01587,0.90476,0.01587,0.92063,0.01587,0.93651,0.01587,0.95238,0.01587,0.96825,0.01587,0.98413,0.01587,0.99609,0.01587,0.00391,0.03175,0.01587,0.03175,0.03175,0.03175,0.04762,0.03175,0.06349,0.03175,0.07937,0.03175,0.09524,0.03175,0.11111,0.03175,0.12698,0.03175,0.14286,0.03175,0.15873,0.03175,0.1746,0.03175,0.19048,0.03175,0.20635,0.03175,0.22222,0.03175,0.2381,0.03175,0.25397,0.03175,0.26984,0.03175,0.28571,0.03175,0.30159,0.03175,0.31746,0.03175,0.33333,0.03175,0.34921,0.03175,0.36508,0.03175,0.38095,0.03175,0.39683,0.03175,0.4127,0.03175,0.42857,0.03175,0.44444,0.03175,0.46032,0.03175,0.47619,0.03175,0.49206,0.03175,0.50794,0.03175,0.52381,0.03175,0.53968,0.03175,0.55556,0.03175,0.57143,0.03175,0.5873,0.03175,0.60317,0.03175,0.61905,0.03175,0.63492,0.03175,0.65079,0.03175,0.66667,0.03175,0.68254,0.03175,0.69841,0.03175,0.71429,0.03175,0.73016,0.03175,0.74603,0.03175,0.7619,0.03175,0.77778,0.03175,0.79365,0.03175,0.80952,0.03175,0.8254,0.03175,0.84127,0.03175,0.85714,0.03175,0.87302,0.03175,0.88889,0.03175,0.90476,0.03175,0.92063,0.03175,0.93651,0.03175,0.95238,0.03175,0.96825,0.03175,0.98413,0.03175,0.99609,0.03175,0.00391,0.04762,0.01587,0.04762,0.03175,0.04762,0.04762,0.04762,0.06349,0.04762,0.07937,0.04762,0.09524,0.04762,0.11111,0.04762};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.12698,0.04762,0.14286,0.04762,0.15873,0.04762,0.1746,0.04762,0.19048,0.04762,0.20635,0.04762,0.22222,0.04762,0.2381,0.04762,0.25397,0.04762,0.26984,0.04762,0.28571,0.04762,0.30159,0.04762,0.31746,0.04762,0.33333,0.04762,0.34921,0.04762,0.36508,0.04762,0.38095,0.04762,0.39683,0.04762,0.4127,0.04762,0.42857,0.04762,0.44444,0.04762,0.46032,0.04762,0.47619,0.04762,0.49206,0.04762,0.50794,0.04762,0.52381,0.04762,0.53968,0.04762,0.55556,0.04762,0.57143,0.04762,0.5873,0.04762,0.60317,0.04762,0.61905,0.04762,0.63492,0.04762,0.65079,0.04762,0.66667,0.04762,0.68254,0.04762,0.69841,0.04762,0.71429,0.04762,0.73016,0.04762,0.74603,0.04762,0.7619,0.04762,0.77778,0.04762,0.79365,0.04762,0.80952,0.04762,0.8254,0.04762,0.84127,0.04762,0.85714,0.04762,0.87302,0.04762,0.88889,0.04762,0.90476,0.04762,0.92063,0.04762,0.93651,0.04762,0.95238,0.04762,0.96825,0.04762,0.98413,0.04762,0.99609,0.04762,0.00391,0.06349,0.01587,0.06349,0.03175,0.06349,0.04762,0.06349,0.06349,0.06349,0.07937,0.06349,0.09524,0.06349,0.11111,0.06349,0.12698,0.06349,0.14286,0.06349,0.15873,0.06349,0.1746,0.06349,0.19048,0.06349,0.20635,0.06349,0.22222,0.06349,0.2381,0.06349,0.25397,0.06349,0.26984,0.06349,0.28571,0.06349,0.30159,0.06349,0.31746,0.06349,0.33333,0.06349,0.34921,0.06349,0.36508,0.06349,0.38095,0.06349,0.39683,0.06349,0.4127,0.06349,0.42857,0.06349,0.44444,0.06349,0.46032,0.06349,0.47619,0.06349,0.49206,0.06349,0.50794,0.06349,0.52381,0.06349,0.53968,0.06349,0.55556,0.06349,0.57143,0.06349,0.5873,0.06349,0.60317,0.06349,0.61905,0.06349,0.63492,0.06349,0.65079,0.06349,0.66667,0.06349,0.68254,0.06349};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.69841,0.06349,0.71429,0.06349,0.73016,0.06349,0.74603,0.06349,0.7619,0.06349,0.77778,0.06349,0.79365,0.06349,0.80952,0.06349,0.8254,0.06349,0.84127,0.06349,0.85714,0.06349,0.87302,0.06349,0.88889,0.06349,0.90476,0.06349,0.92063,0.06349,0.93651,0.06349,0.95238,0.06349,0.96825,0.06349,0.98413,0.06349,0.99609,0.06349,0.00391,0.07937,0.01587,0.07937,0.03175,0.07937,0.04762,0.07937,0.06349,0.07937,0.07937,0.07937,0.09524,0.07937,0.11111,0.07937,0.12698,0.07937,0.14286,0.07937,0.15873,0.07937,0.1746,0.07937,0.19048,0.07937,0.20635,0.07937,0.22222,0.07937,0.2381,0.07937,0.25397,0.07937,0.26984,0.07937,0.28571,0.07937,0.30159,0.07937,0.31746,0.07937,0.33333,0.07937,0.34921,0.07937,0.36508,0.07937,0.38095,0.07937,0.39683,0.07937,0.4127,0.07937,0.42857,0.07937,0.44444,0.07937,0.46032,0.07937,0.47619,0.07937,0.49206,0.07937,0.50794,0.07937,0.52381,0.07937,0.53968,0.07937,0.55556,0.07937,0.57143,0.07937,0.5873,0.07937,0.60317,0.07937,0.61905,0.07937,0.63492,0.07937,0.65079,0.07937,0.66667,0.07937,0.68254,0.07937,0.69841,0.07937,0.71429,0.07937,0.73016,0.07937,0.74603,0.07937,0.7619,0.07937,0.77778,0.07937,0.79365,0.07937,0.80952,0.07937,0.8254,0.07937,0.84127,0.07937,0.85714,0.07937,0.87302,0.07937,0.88889,0.07937,0.90476,0.07937,0.92063,0.07937,0.93651,0.07937,0.95238,0.07937,0.96825,0.07937,0.98413,0.07937,0.99609,0.07937,0.00391,0.09524,0.01587,0.09524,0.03175,0.09524,0.04762,0.09524,0.06349,0.09524,0.07937,0.09524,0.09524,0.09524,0.11111,0.09524,0.12698,0.09524,0.14286,0.09524,0.15873,0.09524,0.1746,0.09524,0.19048,0.09524,0.20635,0.09524,0.22222,0.09524,0.2381,0.09524};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.25397,0.09524,0.26984,0.09524,0.28571,0.09524,0.30159,0.09524,0.31746,0.09524,0.33333,0.09524,0.34921,0.09524,0.36508,0.09524,0.38095,0.09524,0.39683,0.09524,0.4127,0.09524,0.42857,0.09524,0.44444,0.09524,0.46032,0.09524,0.47619,0.09524,0.49206,0.09524,0.50794,0.09524,0.52381,0.09524,0.53968,0.09524,0.55556,0.09524,0.57143,0.09524,0.5873,0.09524,0.60317,0.09524,0.61905,0.09524,0.63492,0.09524,0.65079,0.09524,0.66667,0.09524,0.68254,0.09524,0.69841,0.09524,0.71429,0.09524,0.73016,0.09524,0.74603,0.09524,0.7619,0.09524,0.77778,0.09524,0.79365,0.09524,0.80952,0.09524,0.8254,0.09524,0.84127,0.09524,0.85714,0.09524,0.87302,0.09524,0.88889,0.09524,0.90476,0.09524,0.92063,0.09524,0.93651,0.09524,0.95238,0.09524,0.96825,0.09524,0.98413,0.09524,0.99609,0.09524,0.00391,0.11111,0.01587,0.11111,0.03175,0.11111,0.04762,0.11111,0.06349,0.11111,0.07937,0.11111,0.09524,0.11111,0.11111,0.11111,0.12698,0.11111,0.14286,0.11111,0.15873,0.11111,0.1746,0.11111,0.19048,0.11111,0.20635,0.11111,0.22222,0.11111,0.2381,0.11111,0.25397,0.11111,0.26984,0.11111,0.28571,0.11111,0.30159,0.11111,0.31746,0.11111,0.33333,0.11111,0.34921,0.11111,0.36508,0.11111,0.38095,0.11111,0.39683,0.11111,0.4127,0.11111,0.42857,0.11111,0.44444,0.11111,0.46032,0.11111,0.47619,0.11111,0.49206,0.11111,0.50794,0.11111,0.52381,0.11111,0.53968,0.11111,0.55556,0.11111,0.57143,0.11111,0.5873,0.11111,0.60317,0.11111,0.61905,0.11111,0.63492,0.11111,0.65079,0.11111,0.66667,0.11111,0.68254,0.11111,0.69841,0.11111,0.71429,0.11111,0.73016,0.11111,0.74603,0.11111,0.7619,0.11111,0.77778,0.11111,0.79365,0.11111,0.80952,0.11111};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.8254,0.11111,0.84127,0.11111,0.85714,0.11111,0.87302,0.11111,0.88889,0.11111,0.90476,0.11111,0.92063,0.11111,0.93651,0.11111,0.95238,0.11111,0.96825,0.11111,0.98413,0.11111,0.99609,0.11111,0.00391,0.12698,0.01587,0.12698,0.03175,0.12698,0.04762,0.12698,0.06349,0.12698,0.07937,0.12698,0.09524,0.12698,0.11111,0.12698,0.12698,0.12698,0.14286,0.12698,0.15873,0.12698,0.1746,0.12698,0.19048,0.12698,0.20635,0.12698,0.22222,0.12698,0.2381,0.12698,0.25397,0.12698,0.26984,0.12698,0.28571,0.12698,0.30159,0.12698,0.31746,0.12698,0.33333,0.12698,0.34921,0.12698,0.36508,0.12698,0.38095,0.12698,0.39683,0.12698,0.4127,0.12698,0.42857,0.12698,0.44444,0.12698,0.46032,0.12698,0.47619,0.12698,0.49206,0.12698,0.50794,0.12698,0.52381,0.12698,0.53968,0.12698,0.55556,0.12698,0.57143,0.12698,0.5873,0.12698,0.60317,0.12698,0.61905,0.12698,0.63492,0.12698,0.65079,0.12698,0.66667,0.12698,0.68254,0.12698,0.69841,0.12698,0.71429,0.12698,0.73016,0.12698,0.74603,0.12698,0.7619,0.12698,0.77778,0.12698,0.79365,0.12698,0.80952,0.12698,0.8254,0.12698,0.84127,0.12698,0.85714,0.12698,0.87302,0.12698,0.88889,0.12698,0.90476,0.12698,0.92063,0.12698,0.93651,0.12698,0.95238,0.12698,0.96825,0.12698,0.98413,0.12698,0.99609,0.12698,0.00391,0.14286,0.01587,0.14286,0.03175,0.14286,0.04762,0.14286,0.06349,0.14286,0.07937,0.14286,0.09524,0.14286,0.11111,0.14286,0.12698,0.14286,0.14286,0.14286,0.15873,0.14286,0.1746,0.14286,0.19048,0.14286,0.20635,0.14286,0.22222,0.14286,0.2381,0.14286,0.25397,0.14286,0.26984,0.14286,0.28571,0.14286,0.30159,0.14286,0.31746,0.14286,0.33333,0.14286,0.34921,0.14286,0.36508,0.14286};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.38095,0.14286,0.39683,0.14286,0.4127,0.14286,0.42857,0.14286,0.44444,0.14286,0.46032,0.14286,0.47619,0.14286,0.49206,0.14286,0.50794,0.14286,0.52381,0.14286,0.53968,0.14286,0.55556,0.14286,0.57143,0.14286,0.5873,0.14286,0.60317,0.14286,0.61905,0.14286,0.63492,0.14286,0.65079,0.14286,0.66667,0.14286,0.68254,0.14286,0.69841,0.14286,0.71429,0.14286,0.73016,0.14286,0.74603,0.14286,0.7619,0.14286,0.77778,0.14286,0.79365,0.14286,0.80952,0.14286,0.8254,0.14286,0.84127,0.14286,0.85714,0.14286,0.87302,0.14286,0.88889,0.14286,0.90476,0.14286,0.92063,0.14286,0.93651,0.14286,0.95238,0.14286,0.96825,0.14286,0.98413,0.14286,0.99609,0.14286,0.00391,0.15873,0.01587,0.15873,0.03175,0.15873,0.04762,0.15873,0.06349,0.15873,0.07937,0.15873,0.09524,0.15873,0.11111,0.15873,0.12698,0.15873,0.14286,0.15873,0.15873,0.15873,0.1746,0.15873,0.19048,0.15873,0.20635,0.15873,0.22222,0.15873,0.2381,0.15873,0.25397,0.15873,0.26984,0.15873,0.28571,0.15873,0.30159,0.15873,0.31746,0.15873,0.33333,0.15873,0.34921,0.15873,0.36508,0.15873,0.38095,0.15873,0.39683,0.15873,0.4127,0.15873,0.42857,0.15873,0.44444,0.15873,0.46032,0.15873,0.47619,0.15873,0.49206,0.15873,0.50794,0.15873,0.52381,0.15873,0.53968,0.15873,0.55556,0.15873,0.57143,0.15873,0.5873,0.15873,0.60317,0.15873,0.61905,0.15873,0.63492,0.15873,0.65079,0.15873,0.66667,0.15873,0.68254,0.15873,0.69841,0.15873,0.71429,0.15873,0.73016,0.15873,0.74603,0.15873,0.7619,0.15873,0.77778,0.15873,0.79365,0.15873,0.80952,0.15873,0.8254,0.15873,0.84127,0.15873,0.85714,0.15873,0.87302,0.15873,0.88889,0.15873,0.90476,0.15873,0.92063,0.15873,0.93651,0.15873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.95238,0.15873,0.96825,0.15873,0.98413,0.15873,0.99609,0.15873,0.00391,0.1746,0.01587,0.1746,0.03175,0.1746,0.04762,0.1746,0.06349,0.1746,0.07937,0.1746,0.09524,0.1746,0.11111,0.1746,0.12698,0.1746,0.14286,0.1746,0.15873,0.1746,0.1746,0.1746,0.19048,0.1746,0.20635,0.1746,0.22222,0.1746,0.2381,0.1746,0.25397,0.1746,0.26984,0.1746,0.28571,0.1746,0.30159,0.1746,0.31746,0.1746,0.33333,0.1746,0.34921,0.1746,0.36508,0.1746,0.38095,0.1746,0.39683,0.1746,0.4127,0.1746,0.42857,0.1746,0.44444,0.1746,0.46032,0.1746,0.47619,0.1746,0.49206,0.1746,0.50794,0.1746,0.52381,0.1746,0.53968,0.1746,0.55556,0.1746,0.57143,0.1746,0.5873,0.1746,0.60317,0.1746,0.61905,0.1746,0.63492,0.1746,0.65079,0.1746,0.66667,0.1746,0.68254,0.1746,0.69841,0.1746,0.71429,0.1746,0.73016,0.1746,0.74603,0.1746,0.7619,0.1746,0.77778,0.1746,0.79365,0.1746,0.80952,0.1746,0.8254,0.1746,0.84127,0.1746,0.85714,0.1746,0.87302,0.1746,0.88889,0.1746,0.90476,0.1746,0.92063,0.1746,0.93651,0.1746,0.95238,0.1746,0.96825,0.1746,0.98413,0.1746,0.99609,0.1746,0.00391,0.19048,0.01587,0.19048,0.03175,0.19048,0.04762,0.19048,0.06349,0.19048,0.07937,0.19048,0.09524,0.19048,0.11111,0.19048,0.12698,0.19048,0.14286,0.19048,0.15873,0.19048,0.1746,0.19048,0.19048,0.19048,0.20635,0.19048,0.22222,0.19048,0.2381,0.19048,0.25397,0.19048,0.26984,0.19048,0.28571,0.19048,0.30159,0.19048,0.31746,0.19048,0.33333,0.19048,0.34921,0.19048,0.36508,0.19048,0.38095,0.19048,0.39683,0.19048,0.4127,0.19048,0.42857,0.19048,0.44444,0.19048,0.46032,0.19048,0.47619,0.19048,0.49206,0.19048};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.50794,0.19048,0.52381,0.19048,0.53968,0.19048,0.55556,0.19048,0.57143,0.19048,0.5873,0.19048,0.60317,0.19048,0.61905,0.19048,0.63492,0.19048,0.65079,0.19048,0.66667,0.19048,0.68254,0.19048,0.69841,0.19048,0.71429,0.19048,0.73016,0.19048,0.74603,0.19048,0.7619,0.19048,0.77778,0.19048,0.79365,0.19048,0.80952,0.19048,0.8254,0.19048,0.84127,0.19048,0.85714,0.19048,0.87302,0.19048,0.88889,0.19048,0.90476,0.19048,0.92063,0.19048,0.93651,0.19048,0.95238,0.19048,0.96825,0.19048,0.98413,0.19048,0.99609,0.19048,0.00391,0.20635,0.01587,0.20635,0.03175,0.20635,0.04762,0.20635,0.06349,0.20635,0.07937,0.20635,0.09524,0.20635,0.11111,0.20635,0.12698,0.20635,0.14286,0.20635,0.15873,0.20635,0.1746,0.20635,0.19048,0.20635,0.20635,0.20635,0.22222,0.20635,0.2381,0.20635,0.25397,0.20635,0.26984,0.20635,0.28571,0.20635,0.30159,0.20635,0.31746,0.20635,0.33333,0.20635,0.34921,0.20635,0.36508,0.20635,0.38095,0.20635,0.39683,0.20635,0.4127,0.20635,0.42857,0.20635,0.44444,0.20635,0.46032,0.20635,0.47619,0.20635,0.49206,0.20635,0.50794,0.20635,0.52381,0.20635,0.53968,0.20635,0.55556,0.20635,0.57143,0.20635,0.5873,0.20635,0.60317,0.20635,0.61905,0.20635,0.63492,0.20635,0.65079,0.20635,0.66667,0.20635,0.68254,0.20635,0.69841,0.20635,0.71429,0.20635,0.73016,0.20635,0.74603,0.20635,0.7619,0.20635,0.77778,0.20635,0.79365,0.20635,0.80952,0.20635,0.8254,0.20635,0.84127,0.20635,0.85714,0.20635,0.87302,0.20635,0.88889,0.20635,0.90476,0.20635,0.92063,0.20635,0.93651,0.20635,0.95238,0.20635,0.96825,0.20635,0.98413,0.20635,0.99609,0.20635,0.00391,0.22222,0.01587,0.22222,0.03175,0.22222,0.04762,0.22222};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.06349,0.22222,0.07937,0.22222,0.09524,0.22222,0.11111,0.22222,0.12698,0.22222,0.14286,0.22222,0.15873,0.22222,0.1746,0.22222,0.19048,0.22222,0.20635,0.22222,0.22222,0.22222,0.2381,0.22222,0.25397,0.22222,0.26984,0.22222,0.28571,0.22222,0.30159,0.22222,0.31746,0.22222,0.33333,0.22222,0.34921,0.22222,0.36508,0.22222,0.38095,0.22222,0.39683,0.22222,0.4127,0.22222,0.42857,0.22222,0.44444,0.22222,0.46032,0.22222,0.47619,0.22222,0.49206,0.22222,0.50794,0.22222,0.52381,0.22222,0.53968,0.22222,0.55556,0.22222,0.57143,0.22222,0.5873,0.22222,0.60317,0.22222,0.61905,0.22222,0.63492,0.22222,0.65079,0.22222,0.66667,0.22222,0.68254,0.22222,0.69841,0.22222,0.71429,0.22222,0.73016,0.22222,0.74603,0.22222,0.7619,0.22222,0.77778,0.22222,0.79365,0.22222,0.80952,0.22222,0.8254,0.22222,0.84127,0.22222,0.85714,0.22222,0.87302,0.22222,0.88889,0.22222,0.90476,0.22222,0.92063,0.22222,0.93651,0.22222,0.95238,0.22222,0.96825,0.22222,0.98413,0.22222,0.99609,0.22222,0.00391,0.2381,0.01587,0.2381,0.03175,0.2381,0.04762,0.2381,0.06349,0.2381,0.07937,0.2381,0.09524,0.2381,0.11111,0.2381,0.12698,0.2381,0.14286,0.2381,0.15873,0.2381,0.1746,0.2381,0.19048,0.2381,0.20635,0.2381,0.22222,0.2381,0.2381,0.2381,0.25397,0.2381,0.26984,0.2381,0.28571,0.2381,0.30159,0.2381,0.31746,0.2381,0.33333,0.2381,0.34921,0.2381,0.36508,0.2381,0.38095,0.2381,0.39683,0.2381,0.4127,0.2381,0.42857,0.2381,0.44444,0.2381,0.46032,0.2381,0.47619,0.2381,0.49206,0.2381,0.50794,0.2381,0.52381,0.2381,0.53968,0.2381,0.55556,0.2381,0.57143,0.2381,0.5873,0.2381,0.60317,0.2381,0.61905,0.2381};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.63492,0.2381,0.65079,0.2381,0.66667,0.2381,0.68254,0.2381,0.69841,0.2381,0.71429,0.2381,0.73016,0.2381,0.74603,0.2381,0.7619,0.2381,0.77778,0.2381,0.79365,0.2381,0.80952,0.2381,0.8254,0.2381,0.84127,0.2381,0.85714,0.2381,0.87302,0.2381,0.88889,0.2381,0.90476,0.2381,0.92063,0.2381,0.93651,0.2381,0.95238,0.2381,0.96825,0.2381,0.98413,0.2381,0.99609,0.2381,0.00391,0.25397,0.01587,0.25397,0.03175,0.25397,0.04762,0.25397,0.06349,0.25397,0.07937,0.25397,0.09524,0.25397,0.11111,0.25397,0.12698,0.25397,0.14286,0.25397,0.15873,0.25397,0.1746,0.25397,0.19048,0.25397,0.20635,0.25397,0.22222,0.25397,0.2381,0.25397,0.25397,0.25397,0.26984,0.25397,0.28571,0.25397,0.30159,0.25397,0.31746,0.25397,0.33333,0.25397,0.34921,0.25397,0.36508,0.25397,0.38095,0.25397,0.39683,0.25397,0.4127,0.25397,0.42857,0.25397,0.44444,0.25397,0.46032,0.25397,0.47619,0.25397,0.49206,0.25397,0.50794,0.25397,0.52381,0.25397,0.53968,0.25397,0.55556,0.25397,0.57143,0.25397,0.5873,0.25397,0.60317,0.25397,0.61905,0.25397,0.63492,0.25397,0.65079,0.25397,0.66667,0.25397,0.68254,0.25397,0.69841,0.25397,0.71429,0.25397,0.73016,0.25397,0.74603,0.25397,0.7619,0.25397,0.77778,0.25397,0.79365,0.25397,0.80952,0.25397,0.8254,0.25397,0.84127,0.25397,0.85714,0.25397,0.87302,0.25397,0.88889,0.25397,0.90476,0.25397,0.92063,0.25397,0.93651,0.25397,0.95238,0.25397,0.96825,0.25397,0.98413,0.25397,0.99609,0.25397,0.00391,0.26984,0.01587,0.26984,0.03175,0.26984,0.04762,0.26984,0.06349,0.26984,0.07937,0.26984,0.09524,0.26984,0.11111,0.26984,0.12698,0.26984,0.14286,0.26984,0.15873,0.26984,0.1746,0.26984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.19048,0.26984,0.20635,0.26984,0.22222,0.26984,0.2381,0.26984,0.25397,0.26984,0.26984,0.26984,0.28571,0.26984,0.30159,0.26984,0.31746,0.26984,0.33333,0.26984,0.34921,0.26984,0.36508,0.26984,0.38095,0.26984,0.39683,0.26984,0.4127,0.26984,0.42857,0.26984,0.44444,0.26984,0.46032,0.26984,0.47619,0.26984,0.49206,0.26984,0.50794,0.26984,0.52381,0.26984,0.53968,0.26984,0.55556,0.26984,0.57143,0.26984,0.5873,0.26984,0.60317,0.26984,0.61905,0.26984,0.63492,0.26984,0.65079,0.26984,0.66667,0.26984,0.68254,0.26984,0.69841,0.26984,0.71429,0.26984,0.73016,0.26984,0.74603,0.26984,0.7619,0.26984,0.77778,0.26984,0.79365,0.26984,0.80952,0.26984,0.8254,0.26984,0.84127,0.26984,0.85714,0.26984,0.87302,0.26984,0.88889,0.26984,0.90476,0.26984,0.92063,0.26984,0.93651,0.26984,0.95238,0.26984,0.96825,0.26984,0.98413,0.26984,0.99609,0.26984,0.00391,0.28571,0.01587,0.28571,0.03175,0.28571,0.04762,0.28571,0.06349,0.28571,0.07937,0.28571,0.09524,0.28571,0.11111,0.28571,0.12698,0.28571,0.14286,0.28571,0.15873,0.28571,0.1746,0.28571,0.19048,0.28571,0.20635,0.28571,0.22222,0.28571,0.2381,0.28571,0.25397,0.28571,0.26984,0.28571,0.28571,0.28571,0.30159,0.28571,0.31746,0.28571,0.33333,0.28571,0.34921,0.28571,0.36508,0.28571,0.38095,0.28571,0.39683,0.28571,0.4127,0.28571,0.42857,0.28571,0.44444,0.28571,0.46032,0.28571,0.47619,0.28571,0.49206,0.28571,0.50794,0.28571,0.52381,0.28571,0.53968,0.28571,0.55556,0.28571,0.57143,0.28571,0.5873,0.28571,0.60317,0.28571,0.61905,0.28571,0.63492,0.28571,0.65079,0.28571,0.66667,0.28571,0.68254,0.28571,0.69841,0.28571,0.71429,0.28571,0.73016,0.28571,0.74603,0.28571};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.7619,0.28571,0.77778,0.28571,0.79365,0.28571,0.80952,0.28571,0.8254,0.28571,0.84127,0.28571,0.85714,0.28571,0.87302,0.28571,0.88889,0.28571,0.90476,0.28571,0.92063,0.28571,0.93651,0.28571,0.95238,0.28571,0.96825,0.28571,0.98413,0.28571,0.99609,0.28571,0.00391,0.30159,0.01587,0.30159,0.03175,0.30159,0.04762,0.30159,0.06349,0.30159,0.07937,0.30159,0.09524,0.30159,0.11111,0.30159,0.12698,0.30159,0.14286,0.30159,0.15873,0.30159,0.1746,0.30159,0.19048,0.30159,0.20635,0.30159,0.22222,0.30159,0.2381,0.30159,0.25397,0.30159,0.26984,0.30159,0.28571,0.30159,0.30159,0.30159,0.31746,0.30159,0.33333,0.30159,0.34921,0.30159,0.36508,0.30159,0.38095,0.30159,0.39683,0.30159,0.4127,0.30159,0.42857,0.30159,0.44444,0.30159,0.46032,0.30159,0.47619,0.30159,0.49206,0.30159,0.50794,0.30159,0.52381,0.30159,0.53968,0.30159,0.55556,0.30159,0.57143,0.30159,0.5873,0.30159,0.60317,0.30159,0.61905,0.30159,0.63492,0.30159,0.65079,0.30159,0.66667,0.30159,0.68254,0.30159,0.69841,0.30159,0.71429,0.30159,0.73016,0.30159,0.74603,0.30159,0.7619,0.30159,0.77778,0.30159,0.79365,0.30159,0.80952,0.30159,0.8254,0.30159,0.84127,0.30159,0.85714,0.30159,0.87302,0.30159,0.88889,0.30159,0.90476,0.30159,0.92063,0.30159,0.93651,0.30159,0.95238,0.30159,0.96825,0.30159,0.98413,0.30159,0.99609,0.30159,0.00391,0.31746,0.01587,0.31746,0.03175,0.31746,0.04762,0.31746,0.06349,0.31746,0.07937,0.31746,0.09524,0.31746,0.11111,0.31746,0.12698,0.31746,0.14286,0.31746,0.15873,0.31746,0.1746,0.31746,0.19048,0.31746,0.20635,0.31746,0.22222,0.31746,0.2381,0.31746,0.25397,0.31746,0.26984,0.31746,0.28571,0.31746,0.30159,0.31746};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.31746,0.31746,0.33333,0.31746,0.34921,0.31746,0.36508,0.31746,0.38095,0.31746,0.39683,0.31746,0.4127,0.31746,0.42857,0.31746,0.44444,0.31746,0.46032,0.31746,0.47619,0.31746,0.49206,0.31746,0.50794,0.31746,0.52381,0.31746,0.53968,0.31746,0.55556,0.31746,0.57143,0.31746,0.5873,0.31746,0.60317,0.31746,0.61905,0.31746,0.63492,0.31746,0.65079,0.31746,0.66667,0.31746,0.68254,0.31746,0.69841,0.31746,0.71429,0.31746,0.73016,0.31746,0.74603,0.31746,0.7619,0.31746,0.77778,0.31746,0.79365,0.31746,0.80952,0.31746,0.8254,0.31746,0.84127,0.31746,0.85714,0.31746,0.87302,0.31746,0.88889,0.31746,0.90476,0.31746,0.92063,0.31746,0.93651,0.31746,0.95238,0.31746,0.96825,0.31746,0.98413,0.31746,0.99609,0.31746,0.00391,0.33333,0.01587,0.33333,0.03175,0.33333,0.04762,0.33333,0.06349,0.33333,0.07937,0.33333,0.09524,0.33333,0.11111,0.33333,0.12698,0.33333,0.14286,0.33333,0.15873,0.33333,0.1746,0.33333,0.19048,0.33333,0.20635,0.33333,0.22222,0.33333,0.2381,0.33333,0.25397,0.33333,0.26984,0.33333,0.28571,0.33333,0.30159,0.33333,0.31746,0.33333,0.33333,0.33333,0.34921,0.33333,0.36508,0.33333,0.38095,0.33333,0.39683,0.33333,0.4127,0.33333,0.42857,0.33333,0.44444,0.33333,0.46032,0.33333,0.47619,0.33333,0.49206,0.33333,0.50794,0.33333,0.52381,0.33333,0.53968,0.33333,0.55556,0.33333,0.57143,0.33333,0.5873,0.33333,0.60317,0.33333,0.61905,0.33333,0.63492,0.33333,0.65079,0.33333,0.66667,0.33333,0.68254,0.33333,0.69841,0.33333,0.71429,0.33333,0.73016,0.33333,0.74603,0.33333,0.7619,0.33333,0.77778,0.33333,0.79365,0.33333,0.80952,0.33333,0.8254,0.33333,0.84127,0.33333,0.85714,0.33333,0.87302,0.33333};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.88889,0.33333,0.90476,0.33333,0.92063,0.33333,0.93651,0.33333,0.95238,0.33333,0.96825,0.33333,0.98413,0.33333,0.99609,0.33333,0.00391,0.34921,0.01587,0.34921,0.03175,0.34921,0.04762,0.34921,0.06349,0.34921,0.07937,0.34921,0.09524,0.34921,0.11111,0.34921,0.12698,0.34921,0.14286,0.34921,0.15873,0.34921,0.1746,0.34921,0.19048,0.34921,0.20635,0.34921,0.22222,0.34921,0.2381,0.34921,0.25397,0.34921,0.26984,0.34921,0.28571,0.34921,0.30159,0.34921,0.31746,0.34921,0.33333,0.34921,0.34921,0.34921,0.36508,0.34921,0.38095,0.34921,0.39683,0.34921,0.4127,0.34921,0.42857,0.34921,0.44444,0.34921,0.46032,0.34921,0.47619,0.34921,0.49206,0.34921,0.50794,0.34921,0.52381,0.34921,0.53968,0.34921,0.55556,0.34921,0.57143,0.34921,0.5873,0.34921,0.60317,0.34921,0.61905,0.34921,0.63492,0.34921,0.65079,0.34921,0.66667,0.34921,0.68254,0.34921,0.69841,0.34921,0.71429,0.34921,0.73016,0.34921,0.74603,0.34921,0.7619,0.34921,0.77778,0.34921,0.79365,0.34921,0.80952,0.34921,0.8254,0.34921,0.84127,0.34921,0.85714,0.34921,0.87302,0.34921,0.88889,0.34921,0.90476,0.34921,0.92063,0.34921,0.93651,0.34921,0.95238,0.34921,0.96825,0.34921,0.98413,0.34921,0.99609,0.34921,0.00391,0.36508,0.01587,0.36508,0.03175,0.36508,0.04762,0.36508,0.06349,0.36508,0.07937,0.36508,0.09524,0.36508,0.11111,0.36508,0.12698,0.36508,0.14286,0.36508,0.15873,0.36508,0.1746,0.36508,0.19048,0.36508,0.20635,0.36508,0.22222,0.36508,0.2381,0.36508,0.25397,0.36508,0.26984,0.36508,0.28571,0.36508,0.30159,0.36508,0.31746,0.36508,0.33333,0.36508,0.34921,0.36508,0.36508,0.36508,0.38095,0.36508,0.39683,0.36508,0.4127,0.36508,0.42857,0.36508};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.44444,0.36508,0.46032,0.36508,0.47619,0.36508,0.49206,0.36508,0.50794,0.36508,0.52381,0.36508,0.53968,0.36508,0.55556,0.36508,0.57143,0.36508,0.5873,0.36508,0.60317,0.36508,0.61905,0.36508,0.63492,0.36508,0.65079,0.36508,0.66667,0.36508,0.68254,0.36508,0.69841,0.36508,0.71429,0.36508,0.73016,0.36508,0.74603,0.36508,0.7619,0.36508,0.77778,0.36508,0.79365,0.36508,0.80952,0.36508,0.8254,0.36508,0.84127,0.36508,0.85714,0.36508,0.87302,0.36508,0.88889,0.36508,0.90476,0.36508,0.92063,0.36508,0.93651,0.36508,0.95238,0.36508,0.96825,0.36508,0.98413,0.36508,0.99609,0.36508,0.00391,0.38095,0.01587,0.38095,0.03175,0.38095,0.04762,0.38095,0.06349,0.38095,0.07937,0.38095,0.09524,0.38095,0.11111,0.38095,0.12698,0.38095,0.14286,0.38095,0.15873,0.38095,0.1746,0.38095,0.19048,0.38095,0.20635,0.38095,0.22222,0.38095,0.2381,0.38095,0.25397,0.38095,0.26984,0.38095,0.28571,0.38095,0.30159,0.38095,0.31746,0.38095,0.33333,0.38095,0.34921,0.38095,0.36508,0.38095,0.38095,0.38095,0.39683,0.38095,0.4127,0.38095,0.42857,0.38095,0.44444,0.38095,0.46032,0.38095,0.47619,0.38095,0.49206,0.38095,0.50794,0.38095,0.52381,0.38095,0.53968,0.38095,0.55556,0.38095,0.57143,0.38095,0.5873,0.38095,0.60317,0.38095,0.61905,0.38095,0.63492,0.38095,0.65079,0.38095,0.66667,0.38095,0.68254,0.38095,0.69841,0.38095,0.71429,0.38095,0.73016,0.38095,0.74603,0.38095,0.7619,0.38095,0.77778,0.38095,0.79365,0.38095,0.80952,0.38095,0.8254,0.38095,0.84127,0.38095,0.85714,0.38095,0.87302,0.38095,0.88889,0.38095,0.90476,0.38095,0.92063,0.38095,0.93651,0.38095,0.95238,0.38095,0.96825,0.38095,0.98413,0.38095,0.99609,0.38095};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.00391,0.39683,0.01587,0.39683,0.03175,0.39683,0.04762,0.39683,0.06349,0.39683,0.07937,0.39683,0.09524,0.39683,0.11111,0.39683,0.12698,0.39683,0.14286,0.39683,0.15873,0.39683,0.1746,0.39683,0.19048,0.39683,0.20635,0.39683,0.22222,0.39683,0.2381,0.39683,0.25397,0.39683,0.26984,0.39683,0.28571,0.39683,0.30159,0.39683,0.31746,0.39683,0.33333,0.39683,0.34921,0.39683,0.36508,0.39683,0.38095,0.39683,0.39683,0.39683,0.4127,0.39683,0.42857,0.39683,0.44444,0.39683,0.46032,0.39683,0.47619,0.39683,0.49206,0.39683,0.50794,0.39683,0.52381,0.39683,0.53968,0.39683,0.55556,0.39683,0.57143,0.39683,0.5873,0.39683,0.60317,0.39683,0.61905,0.39683,0.63492,0.39683,0.65079,0.39683,0.66667,0.39683,0.68254,0.39683,0.69841,0.39683,0.71429,0.39683,0.73016,0.39683,0.74603,0.39683,0.7619,0.39683,0.77778,0.39683,0.79365,0.39683,0.80952,0.39683,0.8254,0.39683,0.84127,0.39683,0.85714,0.39683,0.87302,0.39683,0.88889,0.39683,0.90476,0.39683,0.92063,0.39683,0.93651,0.39683,0.95238,0.39683,0.96825,0.39683,0.98413,0.39683,0.99609,0.39683,0.00391,0.4127,0.01587,0.4127,0.03175,0.4127,0.04762,0.4127,0.06349,0.4127,0.07937,0.4127,0.09524,0.4127,0.11111,0.4127,0.12698,0.4127,0.14286,0.4127,0.15873,0.4127,0.1746,0.4127,0.19048,0.4127,0.20635,0.4127,0.22222,0.4127,0.2381,0.4127,0.25397,0.4127,0.26984,0.4127,0.28571,0.4127,0.30159,0.4127,0.31746,0.4127,0.33333,0.4127,0.34921,0.4127,0.36508,0.4127,0.38095,0.4127,0.39683,0.4127,0.4127,0.4127,0.42857,0.4127,0.44444,0.4127,0.46032,0.4127,0.47619,0.4127,0.49206,0.4127,0.50794,0.4127,0.52381,0.4127,0.53968,0.4127,0.55556,0.4127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.57143,0.4127,0.5873,0.4127,0.60317,0.4127,0.61905,0.4127,0.63492,0.4127,0.65079,0.4127,0.66667,0.4127,0.68254,0.4127,0.69841,0.4127,0.71429,0.4127,0.73016,0.4127,0.74603,0.4127,0.7619,0.4127,0.77778,0.4127,0.79365,0.4127,0.80952,0.4127,0.8254,0.4127,0.84127,0.4127,0.85714,0.4127,0.87302,0.4127,0.88889,0.4127,0.90476,0.4127,0.92063,0.4127,0.93651,0.4127,0.95238,0.4127,0.96825,0.4127,0.98413,0.4127,0.99609,0.4127,0.00391,0.42857,0.01587,0.42857,0.03175,0.42857,0.04762,0.42857,0.06349,0.42857,0.07937,0.42857,0.09524,0.42857,0.11111,0.42857,0.12698,0.42857,0.14286,0.42857,0.15873,0.42857,0.1746,0.42857,0.19048,0.42857,0.20635,0.42857,0.22222,0.42857,0.2381,0.42857,0.25397,0.42857,0.26984,0.42857,0.28571,0.42857,0.30159,0.42857,0.31746,0.42857,0.33333,0.42857,0.34921,0.42857,0.36508,0.42857,0.38095,0.42857,0.39683,0.42857,0.4127,0.42857,0.42857,0.42857,0.44444,0.42857,0.46032,0.42857,0.47619,0.42857,0.49206,0.42857,0.50794,0.42857,0.52381,0.42857,0.53968,0.42857,0.55556,0.42857,0.57143,0.42857,0.5873,0.42857,0.60317,0.42857,0.61905,0.42857,0.63492,0.42857,0.65079,0.42857,0.66667,0.42857,0.68254,0.42857,0.69841,0.42857,0.71429,0.42857,0.73016,0.42857,0.74603,0.42857,0.7619,0.42857,0.77778,0.42857,0.79365,0.42857,0.80952,0.42857,0.8254,0.42857,0.84127,0.42857,0.85714,0.42857,0.87302,0.42857,0.88889,0.42857,0.90476,0.42857,0.92063,0.42857,0.93651,0.42857,0.95238,0.42857,0.96825,0.42857,0.98413,0.42857,0.99609,0.42857,0.00391,0.44444,0.01587,0.44444,0.03175,0.44444,0.04762,0.44444,0.06349,0.44444,0.07937,0.44444,0.09524,0.44444,0.11111,0.44444};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.12698,0.44444,0.14286,0.44444,0.15873,0.44444,0.1746,0.44444,0.19048,0.44444,0.20635,0.44444,0.22222,0.44444,0.2381,0.44444,0.25397,0.44444,0.26984,0.44444,0.28571,0.44444,0.30159,0.44444,0.31746,0.44444,0.33333,0.44444,0.34921,0.44444,0.36508,0.44444,0.38095,0.44444,0.39683,0.44444,0.4127,0.44444,0.42857,0.44444,0.44444,0.44444,0.46032,0.44444,0.47619,0.44444,0.49206,0.44444,0.50794,0.44444,0.52381,0.44444,0.53968,0.44444,0.55556,0.44444,0.57143,0.44444,0.5873,0.44444,0.60317,0.44444,0.61905,0.44444,0.63492,0.44444,0.65079,0.44444,0.66667,0.44444,0.68254,0.44444,0.69841,0.44444,0.71429,0.44444,0.73016,0.44444,0.74603,0.44444,0.7619,0.44444,0.77778,0.44444,0.79365,0.44444,0.80952,0.44444,0.8254,0.44444,0.84127,0.44444,0.85714,0.44444,0.87302,0.44444,0.88889,0.44444,0.90476,0.44444,0.92063,0.44444,0.93651,0.44444,0.95238,0.44444,0.96825,0.44444,0.98413,0.44444,0.99609,0.44444,0.00391,0.46032,0.01587,0.46032,0.03175,0.46032,0.04762,0.46032,0.06349,0.46032,0.07937,0.46032,0.09524,0.46032,0.11111,0.46032,0.12698,0.46032,0.14286,0.46032,0.15873,0.46032,0.1746,0.46032,0.19048,0.46032,0.20635,0.46032,0.22222,0.46032,0.2381,0.46032,0.25397,0.46032,0.26984,0.46032,0.28571,0.46032,0.30159,0.46032,0.31746,0.46032,0.33333,0.46032,0.34921,0.46032,0.36508,0.46032,0.38095,0.46032,0.39683,0.46032,0.4127,0.46032,0.42857,0.46032,0.44444,0.46032,0.46032,0.46032,0.47619,0.46032,0.49206,0.46032,0.50794,0.46032,0.52381,0.46032,0.53968,0.46032,0.55556,0.46032,0.57143,0.46032,0.5873,0.46032,0.60317,0.46032,0.61905,0.46032,0.63492,0.46032,0.65079,0.46032,0.66667,0.46032,0.68254,0.46032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.69841,0.46032,0.71429,0.46032,0.73016,0.46032,0.74603,0.46032,0.7619,0.46032,0.77778,0.46032,0.79365,0.46032,0.80952,0.46032,0.8254,0.46032,0.84127,0.46032,0.85714,0.46032,0.87302,0.46032,0.88889,0.46032,0.90476,0.46032,0.92063,0.46032,0.93651,0.46032,0.95238,0.46032,0.96825,0.46032,0.98413,0.46032,0.99609,0.46032,0.00391,0.47619,0.01587,0.47619,0.03175,0.47619,0.04762,0.47619,0.06349,0.47619,0.07937,0.47619,0.09524,0.47619,0.11111,0.47619,0.12698,0.47619,0.14286,0.47619,0.15873,0.47619,0.1746,0.47619,0.19048,0.47619,0.20635,0.47619,0.22222,0.47619,0.2381,0.47619,0.25397,0.47619,0.26984,0.47619,0.28571,0.47619,0.30159,0.47619,0.31746,0.47619,0.33333,0.47619,0.34921,0.47619,0.36508,0.47619,0.38095,0.47619,0.39683,0.47619,0.4127,0.47619,0.42857,0.47619,0.44444,0.47619,0.46032,0.47619,0.47619,0.47619,0.49206,0.47619,0.50794,0.47619,0.52381,0.47619,0.53968,0.47619,0.55556,0.47619,0.57143,0.47619,0.5873,0.47619,0.60317,0.47619,0.61905,0.47619,0.63492,0.47619,0.65079,0.47619,0.66667,0.47619,0.68254,0.47619,0.69841,0.47619,0.71429,0.47619,0.73016,0.47619,0.74603,0.47619,0.7619,0.47619,0.77778,0.47619,0.79365,0.47619,0.80952,0.47619,0.8254,0.47619,0.84127,0.47619,0.85714,0.47619,0.87302,0.47619,0.88889,0.47619,0.90476,0.47619,0.92063,0.47619,0.93651,0.47619,0.95238,0.47619,0.96825,0.47619,0.98413,0.47619,0.99609,0.47619,0.00391,0.49206,0.01587,0.49206,0.03175,0.49206,0.04762,0.49206,0.06349,0.49206,0.07937,0.49206,0.09524,0.49206,0.11111,0.49206,0.12698,0.49206,0.14286,0.49206,0.15873,0.49206,0.1746,0.49206,0.19048,0.49206,0.20635,0.49206,0.22222,0.49206,0.2381,0.49206};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.25397,0.49206,0.26984,0.49206,0.28571,0.49206,0.30159,0.49206,0.31746,0.49206,0.33333,0.49206,0.34921,0.49206,0.36508,0.49206,0.38095,0.49206,0.39683,0.49206,0.4127,0.49206,0.42857,0.49206,0.44444,0.49206,0.46032,0.49206,0.47619,0.49206,0.49206,0.49206,0.50794,0.49206,0.52381,0.49206,0.53968,0.49206,0.55556,0.49206,0.57143,0.49206,0.5873,0.49206,0.60317,0.49206,0.61905,0.49206,0.63492,0.49206,0.65079,0.49206,0.66667,0.49206,0.68254,0.49206,0.69841,0.49206,0.71429,0.49206,0.73016,0.49206,0.74603,0.49206,0.7619,0.49206,0.77778,0.49206,0.79365,0.49206,0.80952,0.49206,0.8254,0.49206,0.84127,0.49206,0.85714,0.49206,0.87302,0.49206,0.88889,0.49206,0.90476,0.49206,0.92063,0.49206,0.93651,0.49206,0.95238,0.49206,0.96825,0.49206,0.98413,0.49206,0.99609,0.49206,0.00391,0.50794,0.01587,0.50794,0.03175,0.50794,0.04762,0.50794,0.06349,0.50794,0.07937,0.50794,0.09524,0.50794,0.11111,0.50794,0.12698,0.50794,0.14286,0.50794,0.15873,0.50794,0.1746,0.50794,0.19048,0.50794,0.20635,0.50794,0.22222,0.50794,0.2381,0.50794,0.25397,0.50794,0.26984,0.50794,0.28571,0.50794,0.30159,0.50794,0.31746,0.50794,0.33333,0.50794,0.34921,0.50794,0.36508,0.50794,0.38095,0.50794,0.39683,0.50794,0.4127,0.50794,0.42857,0.50794,0.44444,0.50794,0.46032,0.50794,0.47619,0.50794,0.49206,0.50794,0.50794,0.50794,0.52381,0.50794,0.53968,0.50794,0.55556,0.50794,0.57143,0.50794,0.5873,0.50794,0.60317,0.50794,0.61905,0.50794,0.63492,0.50794,0.65079,0.50794,0.66667,0.50794,0.68254,0.50794,0.69841,0.50794,0.71429,0.50794,0.73016,0.50794,0.74603,0.50794,0.7619,0.50794,0.77778,0.50794,0.79365,0.50794,0.80952,0.50794};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.8254,0.50794,0.84127,0.50794,0.85714,0.50794,0.87302,0.50794,0.88889,0.50794,0.90476,0.50794,0.92063,0.50794,0.93651,0.50794,0.95238,0.50794,0.96825,0.50794,0.98413,0.50794,0.99609,0.50794,0.00391,0.52381,0.01587,0.52381,0.03175,0.52381,0.04762,0.52381,0.06349,0.52381,0.07937,0.52381,0.09524,0.52381,0.11111,0.52381,0.12698,0.52381,0.14286,0.52381,0.15873,0.52381,0.1746,0.52381,0.19048,0.52381,0.20635,0.52381,0.22222,0.52381,0.2381,0.52381,0.25397,0.52381,0.26984,0.52381,0.28571,0.52381,0.30159,0.52381,0.31746,0.52381,0.33333,0.52381,0.34921,0.52381,0.36508,0.52381,0.38095,0.52381,0.39683,0.52381,0.4127,0.52381,0.42857,0.52381,0.44444,0.52381,0.46032,0.52381,0.47619,0.52381,0.49206,0.52381,0.50794,0.52381,0.52381,0.52381,0.53968,0.52381,0.55556,0.52381,0.57143,0.52381,0.5873,0.52381,0.60317,0.52381,0.61905,0.52381,0.63492,0.52381,0.65079,0.52381,0.66667,0.52381,0.68254,0.52381,0.69841,0.52381,0.71429,0.52381,0.73016,0.52381,0.74603,0.52381,0.7619,0.52381,0.77778,0.52381,0.79365,0.52381,0.80952,0.52381,0.8254,0.52381,0.84127,0.52381,0.85714,0.52381,0.87302,0.52381,0.88889,0.52381,0.90476,0.52381,0.92063,0.52381,0.93651,0.52381,0.95238,0.52381,0.96825,0.52381,0.98413,0.52381,0.99609,0.52381,0.00391,0.53968,0.01587,0.53968,0.03175,0.53968,0.04762,0.53968,0.06349,0.53968,0.07937,0.53968,0.09524,0.53968,0.11111,0.53968,0.12698,0.53968,0.14286,0.53968,0.15873,0.53968,0.1746,0.53968,0.19048,0.53968,0.20635,0.53968,0.22222,0.53968,0.2381,0.53968,0.25397,0.53968,0.26984,0.53968,0.28571,0.53968,0.30159,0.53968,0.31746,0.53968,0.33333,0.53968,0.34921,0.53968,0.36508,0.53968};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.38095,0.53968,0.39683,0.53968,0.4127,0.53968,0.42857,0.53968,0.44444,0.53968,0.46032,0.53968,0.47619,0.53968,0.49206,0.53968,0.50794,0.53968,0.52381,0.53968,0.53968,0.53968,0.55556,0.53968,0.57143,0.53968,0.5873,0.53968,0.60317,0.53968,0.61905,0.53968,0.63492,0.53968,0.65079,0.53968,0.66667,0.53968,0.68254,0.53968,0.69841,0.53968,0.71429,0.53968,0.73016,0.53968,0.74603,0.53968,0.7619,0.53968,0.77778,0.53968,0.79365,0.53968,0.80952,0.53968,0.8254,0.53968,0.84127,0.53968,0.85714,0.53968,0.87302,0.53968,0.88889,0.53968,0.90476,0.53968,0.92063,0.53968,0.93651,0.53968,0.95238,0.53968,0.96825,0.53968,0.98413,0.53968,0.99609,0.53968,0.00391,0.55556,0.01587,0.55556,0.03175,0.55556,0.04762,0.55556,0.06349,0.55556,0.07937,0.55556,0.09524,0.55556,0.11111,0.55556,0.12698,0.55556,0.14286,0.55556,0.15873,0.55556,0.1746,0.55556,0.19048,0.55556,0.20635,0.55556,0.22222,0.55556,0.2381,0.55556,0.25397,0.55556,0.26984,0.55556,0.28571,0.55556,0.30159,0.55556,0.31746,0.55556,0.33333,0.55556,0.34921,0.55556,0.36508,0.55556,0.38095,0.55556,0.39683,0.55556,0.4127,0.55556,0.42857,0.55556,0.44444,0.55556,0.46032,0.55556,0.47619,0.55556,0.49206,0.55556,0.50794,0.55556,0.52381,0.55556,0.53968,0.55556,0.55556,0.55556,0.57143,0.55556,0.5873,0.55556,0.60317,0.55556,0.61905,0.55556,0.63492,0.55556,0.65079,0.55556,0.66667,0.55556,0.68254,0.55556,0.69841,0.55556,0.71429,0.55556,0.73016,0.55556,0.74603,0.55556,0.7619,0.55556,0.77778,0.55556,0.79365,0.55556,0.80952,0.55556,0.8254,0.55556,0.84127,0.55556,0.85714,0.55556,0.87302,0.55556,0.88889,0.55556,0.90476,0.55556,0.92063,0.55556,0.93651,0.55556};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.95238,0.55556,0.96825,0.55556,0.98413,0.55556,0.99609,0.55556,0.00391,0.57143,0.01587,0.57143,0.03175,0.57143,0.04762,0.57143,0.06349,0.57143,0.07937,0.57143,0.09524,0.57143,0.11111,0.57143,0.12698,0.57143,0.14286,0.57143,0.15873,0.57143,0.1746,0.57143,0.19048,0.57143,0.20635,0.57143,0.22222,0.57143,0.2381,0.57143,0.25397,0.57143,0.26984,0.57143,0.28571,0.57143,0.30159,0.57143,0.31746,0.57143,0.33333,0.57143,0.34921,0.57143,0.36508,0.57143,0.38095,0.57143,0.39683,0.57143,0.4127,0.57143,0.42857,0.57143,0.44444,0.57143,0.46032,0.57143,0.47619,0.57143,0.49206,0.57143,0.50794,0.57143,0.52381,0.57143,0.53968,0.57143,0.55556,0.57143,0.57143,0.57143,0.5873,0.57143,0.60317,0.57143,0.61905,0.57143,0.63492,0.57143,0.65079,0.57143,0.66667,0.57143,0.68254,0.57143,0.69841,0.57143,0.71429,0.57143,0.73016,0.57143,0.74603,0.57143,0.7619,0.57143,0.77778,0.57143,0.79365,0.57143,0.80952,0.57143,0.8254,0.57143,0.84127,0.57143,0.85714,0.57143,0.87302,0.57143,0.88889,0.57143,0.90476,0.57143,0.92063,0.57143,0.93651,0.57143,0.95238,0.57143,0.96825,0.57143,0.98413,0.57143,0.99609,0.57143,0.00391,0.5873,0.01587,0.5873,0.03175,0.5873,0.04762,0.5873,0.06349,0.5873,0.07937,0.5873,0.09524,0.5873,0.11111,0.5873,0.12698,0.5873,0.14286,0.5873,0.15873,0.5873,0.1746,0.5873,0.19048,0.5873,0.20635,0.5873,0.22222,0.5873,0.2381,0.5873,0.25397,0.5873,0.26984,0.5873,0.28571,0.5873,0.30159,0.5873,0.31746,0.5873,0.33333,0.5873,0.34921,0.5873,0.36508,0.5873,0.38095,0.5873,0.39683,0.5873,0.4127,0.5873,0.42857,0.5873,0.44444,0.5873,0.46032,0.5873,0.47619,0.5873,0.49206,0.5873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.50794,0.5873,0.52381,0.5873,0.53968,0.5873,0.55556,0.5873,0.57143,0.5873,0.5873,0.5873,0.60317,0.5873,0.61905,0.5873,0.63492,0.5873,0.65079,0.5873,0.66667,0.5873,0.68254,0.5873,0.69841,0.5873,0.71429,0.5873,0.73016,0.5873,0.74603,0.5873,0.7619,0.5873,0.77778,0.5873,0.79365,0.5873,0.80952,0.5873,0.8254,0.5873,0.84127,0.5873,0.85714,0.5873,0.87302,0.5873,0.88889,0.5873,0.90476,0.5873,0.92063,0.5873,0.93651,0.5873,0.95238,0.5873,0.96825,0.5873,0.98413,0.5873,0.99609,0.5873,0.00391,0.60317,0.01587,0.60317,0.03175,0.60317,0.04762,0.60317,0.06349,0.60317,0.07937,0.60317,0.09524,0.60317,0.11111,0.60317,0.12698,0.60317,0.14286,0.60317,0.15873,0.60317,0.1746,0.60317,0.19048,0.60317,0.20635,0.60317,0.22222,0.60317,0.2381,0.60317,0.25397,0.60317,0.26984,0.60317,0.28571,0.60317,0.30159,0.60317,0.31746,0.60317,0.33333,0.60317,0.34921,0.60317,0.36508,0.60317,0.38095,0.60317,0.39683,0.60317,0.4127,0.60317,0.42857,0.60317,0.44444,0.60317,0.46032,0.60317,0.47619,0.60317,0.49206,0.60317,0.50794,0.60317,0.52381,0.60317,0.53968,0.60317,0.55556,0.60317,0.57143,0.60317,0.5873,0.60317,0.60317,0.60317,0.61905,0.60317,0.63492,0.60317,0.65079,0.60317,0.66667,0.60317,0.68254,0.60317,0.69841,0.60317,0.71429,0.60317,0.73016,0.60317,0.74603,0.60317,0.7619,0.60317,0.77778,0.60317,0.79365,0.60317,0.80952,0.60317,0.8254,0.60317,0.84127,0.60317,0.85714,0.60317,0.87302,0.60317,0.88889,0.60317,0.90476,0.60317,0.92063,0.60317,0.93651,0.60317,0.95238,0.60317,0.96825,0.60317,0.98413,0.60317,0.99609,0.60317,0.00391,0.61905,0.01587,0.61905,0.03175,0.61905,0.04762,0.61905};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.06349,0.61905,0.07937,0.61905,0.09524,0.61905,0.11111,0.61905,0.12698,0.61905,0.14286,0.61905,0.15873,0.61905,0.1746,0.61905,0.19048,0.61905,0.20635,0.61905,0.22222,0.61905,0.2381,0.61905,0.25397,0.61905,0.26984,0.61905,0.28571,0.61905,0.30159,0.61905,0.31746,0.61905,0.33333,0.61905,0.34921,0.61905,0.36508,0.61905,0.38095,0.61905,0.39683,0.61905,0.4127,0.61905,0.42857,0.61905,0.44444,0.61905,0.46032,0.61905,0.47619,0.61905,0.49206,0.61905,0.50794,0.61905,0.52381,0.61905,0.53968,0.61905,0.55556,0.61905,0.57143,0.61905,0.5873,0.61905,0.60317,0.61905,0.61905,0.61905,0.63492,0.61905,0.65079,0.61905,0.66667,0.61905,0.68254,0.61905,0.69841,0.61905,0.71429,0.61905,0.73016,0.61905,0.74603,0.61905,0.7619,0.61905,0.77778,0.61905,0.79365,0.61905,0.80952,0.61905,0.8254,0.61905,0.84127,0.61905,0.85714,0.61905,0.87302,0.61905,0.88889,0.61905,0.90476,0.61905,0.92063,0.61905,0.93651,0.61905,0.95238,0.61905,0.96825,0.61905,0.98413,0.61905,0.99609,0.61905,0.00391,0.63492,0.01587,0.63492,0.03175,0.63492,0.04762,0.63492,0.06349,0.63492,0.07937,0.63492,0.09524,0.63492,0.11111,0.63492,0.12698,0.63492,0.14286,0.63492,0.15873,0.63492,0.1746,0.63492,0.19048,0.63492,0.20635,0.63492,0.22222,0.63492,0.2381,0.63492,0.25397,0.63492,0.26984,0.63492,0.28571,0.63492,0.30159,0.63492,0.31746,0.63492,0.33333,0.63492,0.34921,0.63492,0.36508,0.63492,0.38095,0.63492,0.39683,0.63492,0.4127,0.63492,0.42857,0.63492,0.44444,0.63492,0.46032,0.63492,0.47619,0.63492,0.49206,0.63492,0.50794,0.63492,0.52381,0.63492,0.53968,0.63492,0.55556,0.63492,0.57143,0.63492,0.5873,0.63492,0.60317,0.63492,0.61905,0.63492};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.63492,0.63492,0.65079,0.63492,0.66667,0.63492,0.68254,0.63492,0.69841,0.63492,0.71429,0.63492,0.73016,0.63492,0.74603,0.63492,0.7619,0.63492,0.77778,0.63492,0.79365,0.63492,0.80952,0.63492,0.8254,0.63492,0.84127,0.63492,0.85714,0.63492,0.87302,0.63492,0.88889,0.63492,0.90476,0.63492,0.92063,0.63492,0.93651,0.63492,0.95238,0.63492,0.96825,0.63492,0.98413,0.63492,0.99609,0.63492,0.00391,0.65079,0.01587,0.65079,0.03175,0.65079,0.04762,0.65079,0.06349,0.65079,0.07937,0.65079,0.09524,0.65079,0.11111,0.65079,0.12698,0.65079,0.14286,0.65079,0.15873,0.65079,0.1746,0.65079,0.19048,0.65079,0.20635,0.65079,0.22222,0.65079,0.2381,0.65079,0.25397,0.65079,0.26984,0.65079,0.28571,0.65079,0.30159,0.65079,0.31746,0.65079,0.33333,0.65079,0.34921,0.65079,0.36508,0.65079,0.38095,0.65079,0.39683,0.65079,0.4127,0.65079,0.42857,0.65079,0.44444,0.65079,0.46032,0.65079,0.47619,0.65079,0.49206,0.65079,0.50794,0.65079,0.52381,0.65079,0.53968,0.65079,0.55556,0.65079,0.57143,0.65079,0.5873,0.65079,0.60317,0.65079,0.61905,0.65079,0.63492,0.65079,0.65079,0.65079,0.66667,0.65079,0.68254,0.65079,0.69841,0.65079,0.71429,0.65079,0.73016,0.65079,0.74603,0.65079,0.7619,0.65079,0.77778,0.65079,0.79365,0.65079,0.80952,0.65079,0.8254,0.65079,0.84127,0.65079,0.85714,0.65079,0.87302,0.65079,0.88889,0.65079,0.90476,0.65079,0.92063,0.65079,0.93651,0.65079,0.95238,0.65079,0.96825,0.65079,0.98413,0.65079,0.99609,0.65079,0.00391,0.66667,0.01587,0.66667,0.03175,0.66667,0.04762,0.66667,0.06349,0.66667,0.07937,0.66667,0.09524,0.66667,0.11111,0.66667,0.12698,0.66667,0.14286,0.66667,0.15873,0.66667,0.1746,0.66667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.19048,0.66667,0.20635,0.66667,0.22222,0.66667,0.2381,0.66667,0.25397,0.66667,0.26984,0.66667,0.28571,0.66667,0.30159,0.66667,0.31746,0.66667,0.33333,0.66667,0.34921,0.66667,0.36508,0.66667,0.38095,0.66667,0.39683,0.66667,0.4127,0.66667,0.42857,0.66667,0.44444,0.66667,0.46032,0.66667,0.47619,0.66667,0.49206,0.66667,0.50794,0.66667,0.52381,0.66667,0.53968,0.66667,0.55556,0.66667,0.57143,0.66667,0.5873,0.66667,0.60317,0.66667,0.61905,0.66667,0.63492,0.66667,0.65079,0.66667,0.66667,0.66667,0.68254,0.66667,0.69841,0.66667,0.71429,0.66667,0.73016,0.66667,0.74603,0.66667,0.7619,0.66667,0.77778,0.66667,0.79365,0.66667,0.80952,0.66667,0.8254,0.66667,0.84127,0.66667,0.85714,0.66667,0.87302,0.66667,0.88889,0.66667,0.90476,0.66667,0.92063,0.66667,0.93651,0.66667,0.95238,0.66667,0.96825,0.66667,0.98413,0.66667,0.99609,0.66667,0.00391,0.68254,0.01587,0.68254,0.03175,0.68254,0.04762,0.68254,0.06349,0.68254,0.07937,0.68254,0.09524,0.68254,0.11111,0.68254,0.12698,0.68254,0.14286,0.68254,0.15873,0.68254,0.1746,0.68254,0.19048,0.68254,0.20635,0.68254,0.22222,0.68254,0.2381,0.68254,0.25397,0.68254,0.26984,0.68254,0.28571,0.68254,0.30159,0.68254,0.31746,0.68254,0.33333,0.68254,0.34921,0.68254,0.36508,0.68254,0.38095,0.68254,0.39683,0.68254,0.4127,0.68254,0.42857,0.68254,0.44444,0.68254,0.46032,0.68254,0.47619,0.68254,0.49206,0.68254,0.50794,0.68254,0.52381,0.68254,0.53968,0.68254,0.55556,0.68254,0.57143,0.68254,0.5873,0.68254,0.60317,0.68254,0.61905,0.68254,0.63492,0.68254,0.65079,0.68254,0.66667,0.68254,0.68254,0.68254,0.69841,0.68254,0.71429,0.68254,0.73016,0.68254,0.74603,0.68254};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.7619,0.68254,0.77778,0.68254,0.79365,0.68254,0.80952,0.68254,0.8254,0.68254,0.84127,0.68254,0.85714,0.68254,0.87302,0.68254,0.88889,0.68254,0.90476,0.68254,0.92063,0.68254,0.93651,0.68254,0.95238,0.68254,0.96825,0.68254,0.98413,0.68254,0.99609,0.68254,0.00391,0.69841,0.01587,0.69841,0.03175,0.69841,0.04762,0.69841,0.06349,0.69841,0.07937,0.69841,0.09524,0.69841,0.11111,0.69841,0.12698,0.69841,0.14286,0.69841,0.15873,0.69841,0.1746,0.69841,0.19048,0.69841,0.20635,0.69841,0.22222,0.69841,0.2381,0.69841,0.25397,0.69841,0.26984,0.69841,0.28571,0.69841,0.30159,0.69841,0.31746,0.69841,0.33333,0.69841,0.34921,0.69841,0.36508,0.69841,0.38095,0.69841,0.39683,0.69841,0.4127,0.69841,0.42857,0.69841,0.44444,0.69841,0.46032,0.69841,0.47619,0.69841,0.49206,0.69841,0.50794,0.69841,0.52381,0.69841,0.53968,0.69841,0.55556,0.69841,0.57143,0.69841,0.5873,0.69841,0.60317,0.69841,0.61905,0.69841,0.63492,0.69841,0.65079,0.69841,0.66667,0.69841,0.68254,0.69841,0.69841,0.69841,0.71429,0.69841,0.73016,0.69841,0.74603,0.69841,0.7619,0.69841,0.77778,0.69841,0.79365,0.69841,0.80952,0.69841,0.8254,0.69841,0.84127,0.69841,0.85714,0.69841,0.87302,0.69841,0.88889,0.69841,0.90476,0.69841,0.92063,0.69841,0.93651,0.69841,0.95238,0.69841,0.96825,0.69841,0.98413,0.69841,0.99609,0.69841,0.00391,0.71429,0.01587,0.71429,0.03175,0.71429,0.04762,0.71429,0.06349,0.71429,0.07937,0.71429,0.09524,0.71429,0.11111,0.71429,0.12698,0.71429,0.14286,0.71429,0.15873,0.71429,0.1746,0.71429,0.19048,0.71429,0.20635,0.71429,0.22222,0.71429,0.2381,0.71429,0.25397,0.71429,0.26984,0.71429,0.28571,0.71429,0.30159,0.71429};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.31746,0.71429,0.33333,0.71429,0.34921,0.71429,0.36508,0.71429,0.38095,0.71429,0.39683,0.71429,0.4127,0.71429,0.42857,0.71429,0.44444,0.71429,0.46032,0.71429,0.47619,0.71429,0.49206,0.71429,0.50794,0.71429,0.52381,0.71429,0.53968,0.71429,0.55556,0.71429,0.57143,0.71429,0.5873,0.71429,0.60317,0.71429,0.61905,0.71429,0.63492,0.71429,0.65079,0.71429,0.66667,0.71429,0.68254,0.71429,0.69841,0.71429,0.71429,0.71429,0.73016,0.71429,0.74603,0.71429,0.7619,0.71429,0.77778,0.71429,0.79365,0.71429,0.80952,0.71429,0.8254,0.71429,0.84127,0.71429,0.85714,0.71429,0.87302,0.71429,0.88889,0.71429,0.90476,0.71429,0.92063,0.71429,0.93651,0.71429,0.95238,0.71429,0.96825,0.71429,0.98413,0.71429,0.99609,0.71429,0.00391,0.73016,0.01587,0.73016,0.03175,0.73016,0.04762,0.73016,0.06349,0.73016,0.07937,0.73016,0.09524,0.73016,0.11111,0.73016,0.12698,0.73016,0.14286,0.73016,0.15873,0.73016,0.1746,0.73016,0.19048,0.73016,0.20635,0.73016,0.22222,0.73016,0.2381,0.73016,0.25397,0.73016,0.26984,0.73016,0.28571,0.73016,0.30159,0.73016,0.31746,0.73016,0.33333,0.73016,0.34921,0.73016,0.36508,0.73016,0.38095,0.73016,0.39683,0.73016,0.4127,0.73016,0.42857,0.73016,0.44444,0.73016,0.46032,0.73016,0.47619,0.73016,0.49206,0.73016,0.50794,0.73016,0.52381,0.73016,0.53968,0.73016,0.55556,0.73016,0.57143,0.73016,0.5873,0.73016,0.60317,0.73016,0.61905,0.73016,0.63492,0.73016,0.65079,0.73016,0.66667,0.73016,0.68254,0.73016,0.69841,0.73016,0.71429,0.73016,0.73016,0.73016,0.74603,0.73016,0.7619,0.73016,0.77778,0.73016,0.79365,0.73016,0.80952,0.73016,0.8254,0.73016,0.84127,0.73016,0.85714,0.73016,0.87302,0.73016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.88889,0.73016,0.90476,0.73016,0.92063,0.73016,0.93651,0.73016,0.95238,0.73016,0.96825,0.73016,0.98413,0.73016,0.99609,0.73016,0.00391,0.74603,0.01587,0.74603,0.03175,0.74603,0.04762,0.74603,0.06349,0.74603,0.07937,0.74603,0.09524,0.74603,0.11111,0.74603,0.12698,0.74603,0.14286,0.74603,0.15873,0.74603,0.1746,0.74603,0.19048,0.74603,0.20635,0.74603,0.22222,0.74603,0.2381,0.74603,0.25397,0.74603,0.26984,0.74603,0.28571,0.74603,0.30159,0.74603,0.31746,0.74603,0.33333,0.74603,0.34921,0.74603,0.36508,0.74603,0.38095,0.74603,0.39683,0.74603,0.4127,0.74603,0.42857,0.74603,0.44444,0.74603,0.46032,0.74603,0.47619,0.74603,0.49206,0.74603,0.50794,0.74603,0.52381,0.74603,0.53968,0.74603,0.55556,0.74603,0.57143,0.74603,0.5873,0.74603,0.60317,0.74603,0.61905,0.74603,0.63492,0.74603,0.65079,0.74603,0.66667,0.74603,0.68254,0.74603,0.69841,0.74603,0.71429,0.74603,0.73016,0.74603,0.74603,0.74603,0.7619,0.74603,0.77778,0.74603,0.79365,0.74603,0.80952,0.74603,0.8254,0.74603,0.84127,0.74603,0.85714,0.74603,0.87302,0.74603,0.88889,0.74603,0.90476,0.74603,0.92063,0.74603,0.93651,0.74603,0.95238,0.74603,0.96825,0.74603,0.98413,0.74603,0.99609,0.74603,0.00391,0.7619,0.01587,0.7619,0.03175,0.7619,0.04762,0.7619,0.06349,0.7619,0.07937,0.7619,0.09524,0.7619,0.11111,0.7619,0.12698,0.7619,0.14286,0.7619,0.15873,0.7619,0.1746,0.7619,0.19048,0.7619,0.20635,0.7619,0.22222,0.7619,0.2381,0.7619,0.25397,0.7619,0.26984,0.7619,0.28571,0.7619,0.30159,0.7619,0.31746,0.7619,0.33333,0.7619,0.34921,0.7619,0.36508,0.7619,0.38095,0.7619,0.39683,0.7619,0.4127,0.7619,0.42857,0.7619};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.44444,0.7619,0.46032,0.7619,0.47619,0.7619,0.49206,0.7619,0.50794,0.7619,0.52381,0.7619,0.53968,0.7619,0.55556,0.7619,0.57143,0.7619,0.5873,0.7619,0.60317,0.7619,0.61905,0.7619,0.63492,0.7619,0.65079,0.7619,0.66667,0.7619,0.68254,0.7619,0.69841,0.7619,0.71429,0.7619,0.73016,0.7619,0.74603,0.7619,0.7619,0.7619,0.77778,0.7619,0.79365,0.7619,0.80952,0.7619,0.8254,0.7619,0.84127,0.7619,0.85714,0.7619,0.87302,0.7619,0.88889,0.7619,0.90476,0.7619,0.92063,0.7619,0.93651,0.7619,0.95238,0.7619,0.96825,0.7619,0.98413,0.7619,0.99609,0.7619,0.00391,0.77778,0.01587,0.77778,0.03175,0.77778,0.04762,0.77778,0.06349,0.77778,0.07937,0.77778,0.09524,0.77778,0.11111,0.77778,0.12698,0.77778,0.14286,0.77778,0.15873,0.77778,0.1746,0.77778,0.19048,0.77778,0.20635,0.77778,0.22222,0.77778,0.2381,0.77778,0.25397,0.77778,0.26984,0.77778,0.28571,0.77778,0.30159,0.77778,0.31746,0.77778,0.33333,0.77778,0.34921,0.77778,0.36508,0.77778,0.38095,0.77778,0.39683,0.77778,0.4127,0.77778,0.42857,0.77778,0.44444,0.77778,0.46032,0.77778,0.47619,0.77778,0.49206,0.77778,0.50794,0.77778,0.52381,0.77778,0.53968,0.77778,0.55556,0.77778,0.57143,0.77778,0.5873,0.77778,0.60317,0.77778,0.61905,0.77778,0.63492,0.77778,0.65079,0.77778,0.66667,0.77778,0.68254,0.77778,0.69841,0.77778,0.71429,0.77778,0.73016,0.77778,0.74603,0.77778,0.7619,0.77778,0.77778,0.77778,0.79365,0.77778,0.80952,0.77778,0.8254,0.77778,0.84127,0.77778,0.85714,0.77778,0.87302,0.77778,0.88889,0.77778,0.90476,0.77778,0.92063,0.77778,0.93651,0.77778,0.95238,0.77778,0.96825,0.77778,0.98413,0.77778,0.99609,0.77778};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.79365,0.01587,0.79365,0.03175,0.79365,0.04762,0.79365,0.06349,0.79365,0.07937,0.79365,0.09524,0.79365,0.11111,0.79365,0.12698,0.79365,0.14286,0.79365,0.15873,0.79365,0.1746,0.79365,0.19048,0.79365,0.20635,0.79365,0.22222,0.79365,0.2381,0.79365,0.25397,0.79365,0.26984,0.79365,0.28571,0.79365,0.30159,0.79365,0.31746,0.79365,0.33333,0.79365,0.34921,0.79365,0.36508,0.79365,0.38095,0.79365,0.39683,0.79365,0.4127,0.79365,0.42857,0.79365,0.44444,0.79365,0.46032,0.79365,0.47619,0.79365,0.49206,0.79365,0.50794,0.79365,0.52381,0.79365,0.53968,0.79365,0.55556,0.79365,0.57143,0.79365,0.5873,0.79365,0.60317,0.79365,0.61905,0.79365,0.63492,0.79365,0.65079,0.79365,0.66667,0.79365,0.68254,0.79365,0.69841,0.79365,0.71429,0.79365,0.73016,0.79365,0.74603,0.79365,0.7619,0.79365,0.77778,0.79365,0.79365,0.79365,0.80952,0.79365,0.8254,0.79365,0.84127,0.79365,0.85714,0.79365,0.87302,0.79365,0.88889,0.79365,0.90476,0.79365,0.92063,0.79365,0.93651,0.79365,0.95238,0.79365,0.96825,0.79365,0.98413,0.79365,0.99609,0.79365,0.00391,0.80952,0.01587,0.80952,0.03175,0.80952,0.04762,0.80952,0.06349,0.80952,0.07937,0.80952,0.09524,0.80952,0.11111,0.80952,0.12698,0.80952,0.14286,0.80952,0.15873,0.80952,0.1746,0.80952,0.19048,0.80952,0.20635,0.80952,0.22222,0.80952,0.2381,0.80952,0.25397,0.80952,0.26984,0.80952,0.28571,0.80952,0.30159,0.80952,0.31746,0.80952,0.33333,0.80952,0.34921,0.80952,0.36508,0.80952,0.38095,0.80952,0.39683,0.80952,0.4127,0.80952,0.42857,0.80952,0.44444,0.80952,0.46032,0.80952,0.47619,0.80952,0.49206,0.80952,0.50794,0.80952,0.52381,0.80952,0.53968,0.80952,0.55556,0.80952};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.57143,0.80952,0.5873,0.80952,0.60317,0.80952,0.61905,0.80952,0.63492,0.80952,0.65079,0.80952,0.66667,0.80952,0.68254,0.80952,0.69841,0.80952,0.71429,0.80952,0.73016,0.80952,0.74603,0.80952,0.7619,0.80952,0.77778,0.80952,0.79365,0.80952,0.80952,0.80952,0.8254,0.80952,0.84127,0.80952,0.85714,0.80952,0.87302,0.80952,0.88889,0.80952,0.90476,0.80952,0.92063,0.80952,0.93651,0.80952,0.95238,0.80952,0.96825,0.80952,0.98413,0.80952,0.99609,0.80952,0.00391,0.8254,0.01587,0.8254,0.03175,0.8254,0.04762,0.8254,0.06349,0.8254,0.07937,0.8254,0.09524,0.8254,0.11111,0.8254,0.12698,0.8254,0.14286,0.8254,0.15873,0.8254,0.1746,0.8254,0.19048,0.8254,0.20635,0.8254,0.22222,0.8254,0.2381,0.8254,0.25397,0.8254,0.26984,0.8254,0.28571,0.8254,0.30159,0.8254,0.31746,0.8254,0.33333,0.8254,0.34921,0.8254,0.36508,0.8254,0.38095,0.8254,0.39683,0.8254,0.4127,0.8254,0.42857,0.8254,0.44444,0.8254,0.46032,0.8254,0.47619,0.8254,0.49206,0.8254,0.50794,0.8254,0.52381,0.8254,0.53968,0.8254,0.55556,0.8254,0.57143,0.8254,0.5873,0.8254,0.60317,0.8254,0.61905,0.8254,0.63492,0.8254,0.65079,0.8254,0.66667,0.8254,0.68254,0.8254,0.69841,0.8254,0.71429,0.8254,0.73016,0.8254,0.74603,0.8254,0.7619,0.8254,0.77778,0.8254,0.79365,0.8254,0.80952,0.8254,0.8254,0.8254,0.84127,0.8254,0.85714,0.8254,0.87302,0.8254,0.88889,0.8254,0.90476,0.8254,0.92063,0.8254,0.93651,0.8254,0.95238,0.8254,0.96825,0.8254,0.98413,0.8254,0.99609,0.8254,0.00391,0.84127,0.01587,0.84127,0.03175,0.84127,0.04762,0.84127,0.06349,0.84127,0.07937,0.84127,0.09524,0.84127,0.11111,0.84127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.12698,0.84127,0.14286,0.84127,0.15873,0.84127,0.1746,0.84127,0.19048,0.84127,0.20635,0.84127,0.22222,0.84127,0.2381,0.84127,0.25397,0.84127,0.26984,0.84127,0.28571,0.84127,0.30159,0.84127,0.31746,0.84127,0.33333,0.84127,0.34921,0.84127,0.36508,0.84127,0.38095,0.84127,0.39683,0.84127,0.4127,0.84127,0.42857,0.84127,0.44444,0.84127,0.46032,0.84127,0.47619,0.84127,0.49206,0.84127,0.50794,0.84127,0.52381,0.84127,0.53968,0.84127,0.55556,0.84127,0.57143,0.84127,0.5873,0.84127,0.60317,0.84127,0.61905,0.84127,0.63492,0.84127,0.65079,0.84127,0.66667,0.84127,0.68254,0.84127,0.69841,0.84127,0.71429,0.84127,0.73016,0.84127,0.74603,0.84127,0.7619,0.84127,0.77778,0.84127,0.79365,0.84127,0.80952,0.84127,0.8254,0.84127,0.84127,0.84127,0.85714,0.84127,0.87302,0.84127,0.88889,0.84127,0.90476,0.84127,0.92063,0.84127,0.93651,0.84127,0.95238,0.84127,0.96825,0.84127,0.98413,0.84127,0.99609,0.84127,0.00391,0.85714,0.01587,0.85714,0.03175,0.85714,0.04762,0.85714,0.06349,0.85714,0.07937,0.85714,0.09524,0.85714,0.11111,0.85714,0.12698,0.85714,0.14286,0.85714,0.15873,0.85714,0.1746,0.85714,0.19048,0.85714,0.20635,0.85714,0.22222,0.85714,0.2381,0.85714,0.25397,0.85714,0.26984,0.85714,0.28571,0.85714,0.30159,0.85714,0.31746,0.85714,0.33333,0.85714,0.34921,0.85714,0.36508,0.85714,0.38095,0.85714,0.39683,0.85714,0.4127,0.85714,0.42857,0.85714,0.44444,0.85714,0.46032,0.85714,0.47619,0.85714,0.49206,0.85714,0.50794,0.85714,0.52381,0.85714,0.53968,0.85714,0.55556,0.85714,0.57143,0.85714,0.5873,0.85714,0.60317,0.85714,0.61905,0.85714,0.63492,0.85714,0.65079,0.85714,0.66667,0.85714,0.68254,0.85714};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.69841,0.85714,0.71429,0.85714,0.73016,0.85714,0.74603,0.85714,0.7619,0.85714,0.77778,0.85714,0.79365,0.85714,0.80952,0.85714,0.8254,0.85714,0.84127,0.85714,0.85714,0.85714,0.87302,0.85714,0.88889,0.85714,0.90476,0.85714,0.92063,0.85714,0.93651,0.85714,0.95238,0.85714,0.96825,0.85714,0.98413,0.85714,0.99609,0.85714,0.00391,0.87302,0.01587,0.87302,0.03175,0.87302,0.04762,0.87302,0.06349,0.87302,0.07937,0.87302,0.09524,0.87302,0.11111,0.87302,0.12698,0.87302,0.14286,0.87302,0.15873,0.87302,0.1746,0.87302,0.19048,0.87302,0.20635,0.87302,0.22222,0.87302,0.2381,0.87302,0.25397,0.87302,0.26984,0.87302,0.28571,0.87302,0.30159,0.87302,0.31746,0.87302,0.33333,0.87302,0.34921,0.87302,0.36508,0.87302,0.38095,0.87302,0.39683,0.87302,0.4127,0.87302,0.42857,0.87302,0.44444,0.87302,0.46032,0.87302,0.47619,0.87302,0.49206,0.87302,0.50794,0.87302,0.52381,0.87302,0.53968,0.87302,0.55556,0.87302,0.57143,0.87302,0.5873,0.87302,0.60317,0.87302,0.61905,0.87302,0.63492,0.87302,0.65079,0.87302,0.66667,0.87302,0.68254,0.87302,0.69841,0.87302,0.71429,0.87302,0.73016,0.87302,0.74603,0.87302,0.7619,0.87302,0.77778,0.87302,0.79365,0.87302,0.80952,0.87302,0.8254,0.87302,0.84127,0.87302,0.85714,0.87302,0.87302,0.87302,0.88889,0.87302,0.90476,0.87302,0.92063,0.87302,0.93651,0.87302,0.95238,0.87302,0.96825,0.87302,0.98413,0.87302,0.99609,0.87302,0.00391,0.88889,0.01587,0.88889,0.03175,0.88889,0.04762,0.88889,0.06349,0.88889,0.07937,0.88889,0.09524,0.88889,0.11111,0.88889,0.12698,0.88889,0.14286,0.88889,0.15873,0.88889,0.1746,0.88889,0.19048,0.88889,0.20635,0.88889,0.22222,0.88889,0.2381,0.88889};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.25397,0.88889,0.26984,0.88889,0.28571,0.88889,0.30159,0.88889,0.31746,0.88889,0.33333,0.88889,0.34921,0.88889,0.36508,0.88889,0.38095,0.88889,0.39683,0.88889,0.4127,0.88889,0.42857,0.88889,0.44444,0.88889,0.46032,0.88889,0.47619,0.88889,0.49206,0.88889,0.50794,0.88889,0.52381,0.88889,0.53968,0.88889,0.55556,0.88889,0.57143,0.88889,0.5873,0.88889,0.60317,0.88889,0.61905,0.88889,0.63492,0.88889,0.65079,0.88889,0.66667,0.88889,0.68254,0.88889,0.69841,0.88889,0.71429,0.88889,0.73016,0.88889,0.74603,0.88889,0.7619,0.88889,0.77778,0.88889,0.79365,0.88889,0.80952,0.88889,0.8254,0.88889,0.84127,0.88889,0.85714,0.88889,0.87302,0.88889,0.88889,0.88889,0.90476,0.88889,0.92063,0.88889,0.93651,0.88889,0.95238,0.88889,0.96825,0.88889,0.98413,0.88889,0.99609,0.88889,0.00391,0.90476,0.01587,0.90476,0.03175,0.90476,0.04762,0.90476,0.06349,0.90476,0.07937,0.90476,0.09524,0.90476,0.11111,0.90476,0.12698,0.90476,0.14286,0.90476,0.15873,0.90476,0.1746,0.90476,0.19048,0.90476,0.20635,0.90476,0.22222,0.90476,0.2381,0.90476,0.25397,0.90476,0.26984,0.90476,0.28571,0.90476,0.30159,0.90476,0.31746,0.90476,0.33333,0.90476,0.34921,0.90476,0.36508,0.90476,0.38095,0.90476,0.39683,0.90476,0.4127,0.90476,0.42857,0.90476,0.44444,0.90476,0.46032,0.90476,0.47619,0.90476,0.49206,0.90476,0.50794,0.90476,0.52381,0.90476,0.53968,0.90476,0.55556,0.90476,0.57143,0.90476,0.5873,0.90476,0.60317,0.90476,0.61905,0.90476,0.63492,0.90476,0.65079,0.90476,0.66667,0.90476,0.68254,0.90476,0.69841,0.90476,0.71429,0.90476,0.73016,0.90476,0.74603,0.90476,0.7619,0.90476,0.77778,0.90476,0.79365,0.90476,0.80952,0.90476};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.8254,0.90476,0.84127,0.90476,0.85714,0.90476,0.87302,0.90476,0.88889,0.90476,0.90476,0.90476,0.92063,0.90476,0.93651,0.90476,0.95238,0.90476,0.96825,0.90476,0.98413,0.90476,0.99609,0.90476,0.00391,0.92063,0.01587,0.92063,0.03175,0.92063,0.04762,0.92063,0.06349,0.92063,0.07937,0.92063,0.09524,0.92063,0.11111,0.92063,0.12698,0.92063,0.14286,0.92063,0.15873,0.92063,0.1746,0.92063,0.19048,0.92063,0.20635,0.92063,0.22222,0.92063,0.2381,0.92063,0.25397,0.92063,0.26984,0.92063,0.28571,0.92063,0.30159,0.92063,0.31746,0.92063,0.33333,0.92063,0.34921,0.92063,0.36508,0.92063,0.38095,0.92063,0.39683,0.92063,0.4127,0.92063,0.42857,0.92063,0.44444,0.92063,0.46032,0.92063,0.47619,0.92063,0.49206,0.92063,0.50794,0.92063,0.52381,0.92063,0.53968,0.92063,0.55556,0.92063,0.57143,0.92063,0.5873,0.92063,0.60317,0.92063,0.61905,0.92063,0.63492,0.92063,0.65079,0.92063,0.66667,0.92063,0.68254,0.92063,0.69841,0.92063,0.71429,0.92063,0.73016,0.92063,0.74603,0.92063,0.7619,0.92063,0.77778,0.92063,0.79365,0.92063,0.80952,0.92063,0.8254,0.92063,0.84127,0.92063,0.85714,0.92063,0.87302,0.92063,0.88889,0.92063,0.90476,0.92063,0.92063,0.92063,0.93651,0.92063,0.95238,0.92063,0.96825,0.92063,0.98413,0.92063,0.99609,0.92063,0.00391,0.93651,0.01587,0.93651,0.03175,0.93651,0.04762,0.93651,0.06349,0.93651,0.07937,0.93651,0.09524,0.93651,0.11111,0.93651,0.12698,0.93651,0.14286,0.93651,0.15873,0.93651,0.1746,0.93651,0.19048,0.93651,0.20635,0.93651,0.22222,0.93651,0.2381,0.93651,0.25397,0.93651,0.26984,0.93651,0.28571,0.93651,0.30159,0.93651,0.31746,0.93651,0.33333,0.93651,0.34921,0.93651,0.36508,0.93651};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.38095,0.93651,0.39683,0.93651,0.4127,0.93651,0.42857,0.93651,0.44444,0.93651,0.46032,0.93651,0.47619,0.93651,0.49206,0.93651,0.50794,0.93651,0.52381,0.93651,0.53968,0.93651,0.55556,0.93651,0.57143,0.93651,0.5873,0.93651,0.60317,0.93651,0.61905,0.93651,0.63492,0.93651,0.65079,0.93651,0.66667,0.93651,0.68254,0.93651,0.69841,0.93651,0.71429,0.93651,0.73016,0.93651,0.74603,0.93651,0.7619,0.93651,0.77778,0.93651,0.79365,0.93651,0.80952,0.93651,0.8254,0.93651,0.84127,0.93651,0.85714,0.93651,0.87302,0.93651,0.88889,0.93651,0.90476,0.93651,0.92063,0.93651,0.93651,0.93651,0.95238,0.93651,0.96825,0.93651,0.98413,0.93651,0.99609,0.93651,0.00391,0.95238,0.01587,0.95238,0.03175,0.95238,0.04762,0.95238,0.06349,0.95238,0.07937,0.95238,0.09524,0.95238,0.11111,0.95238,0.12698,0.95238,0.14286,0.95238,0.15873,0.95238,0.1746,0.95238,0.19048,0.95238,0.20635,0.95238,0.22222,0.95238,0.2381,0.95238,0.25397,0.95238,0.26984,0.95238,0.28571,0.95238,0.30159,0.95238,0.31746,0.95238,0.33333,0.95238,0.34921,0.95238,0.36508,0.95238,0.38095,0.95238,0.39683,0.95238,0.4127,0.95238,0.42857,0.95238,0.44444,0.95238,0.46032,0.95238,0.47619,0.95238,0.49206,0.95238,0.50794,0.95238,0.52381,0.95238,0.53968,0.95238,0.55556,0.95238,0.57143,0.95238,0.5873,0.95238,0.60317,0.95238,0.61905,0.95238,0.63492,0.95238,0.65079,0.95238,0.66667,0.95238,0.68254,0.95238,0.69841,0.95238,0.71429,0.95238,0.73016,0.95238,0.74603,0.95238,0.7619,0.95238,0.77778,0.95238,0.79365,0.95238,0.80952,0.95238,0.8254,0.95238,0.84127,0.95238,0.85714,0.95238,0.87302,0.95238,0.88889,0.95238,0.90476,0.95238,0.92063,0.95238,0.93651,0.95238};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.95238,0.95238,0.96825,0.95238,0.98413,0.95238,0.99609,0.95238,0.00391,0.96825,0.01587,0.96825,0.03175,0.96825,0.04762,0.96825,0.06349,0.96825,0.07937,0.96825,0.09524,0.96825,0.11111,0.96825,0.12698,0.96825,0.14286,0.96825,0.15873,0.96825,0.1746,0.96825,0.19048,0.96825,0.20635,0.96825,0.22222,0.96825,0.2381,0.96825,0.25397,0.96825,0.26984,0.96825,0.28571,0.96825,0.30159,0.96825,0.31746,0.96825,0.33333,0.96825,0.34921,0.96825,0.36508,0.96825,0.38095,0.96825,0.39683,0.96825,0.4127,0.96825,0.42857,0.96825,0.44444,0.96825,0.46032,0.96825,0.47619,0.96825,0.49206,0.96825,0.50794,0.96825,0.52381,0.96825,0.53968,0.96825,0.55556,0.96825,0.57143,0.96825,0.5873,0.96825,0.60317,0.96825,0.61905,0.96825,0.63492,0.96825,0.65079,0.96825,0.66667,0.96825,0.68254,0.96825,0.69841,0.96825,0.71429,0.96825,0.73016,0.96825,0.74603,0.96825,0.7619,0.96825,0.77778,0.96825,0.79365,0.96825,0.80952,0.96825,0.8254,0.96825,0.84127,0.96825,0.85714,0.96825,0.87302,0.96825,0.88889,0.96825,0.90476,0.96825,0.92063,0.96825,0.93651,0.96825,0.95238,0.96825,0.96825,0.96825,0.98413,0.96825,0.99609,0.96825,0.00391,0.98413,0.01587,0.98413,0.03175,0.98413,0.04762,0.98413,0.06349,0.98413,0.07937,0.98413,0.09524,0.98413,0.11111,0.98413,0.12698,0.98413,0.14286,0.98413,0.15873,0.98413,0.1746,0.98413,0.19048,0.98413,0.20635,0.98413,0.22222,0.98413,0.2381,0.98413,0.25397,0.98413,0.26984,0.98413,0.28571,0.98413,0.30159,0.98413,0.31746,0.98413,0.33333,0.98413,0.34921,0.98413,0.36508,0.98413,0.38095,0.98413,0.39683,0.98413,0.4127,0.98413,0.42857,0.98413,0.44444,0.98413,0.46032,0.98413,0.47619,0.98413,0.49206,0.98413};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.50794,0.98413,0.52381,0.98413,0.53968,0.98413,0.55556,0.98413,0.57143,0.98413,0.5873,0.98413,0.60317,0.98413,0.61905,0.98413,0.63492,0.98413,0.65079,0.98413,0.66667,0.98413,0.68254,0.98413,0.69841,0.98413,0.71429,0.98413,0.73016,0.98413,0.74603,0.98413,0.7619,0.98413,0.77778,0.98413,0.79365,0.98413,0.80952,0.98413,0.8254,0.98413,0.84127,0.98413,0.85714,0.98413,0.87302,0.98413,0.88889,0.98413,0.90476,0.98413,0.92063,0.98413,0.93651,0.98413,0.95238,0.98413,0.96825,0.98413,0.98413,0.98413,0.99609,0.98413,0.00391,0.99609,0.01587,0.99609,0.03175,0.99609,0.04762,0.99609,0.06349,0.99609,0.07937,0.99609,0.09524,0.99609,0.11111,0.99609,0.12698,0.99609,0.14286,0.99609,0.15873,0.99609,0.1746,0.99609,0.19048,0.99609,0.20635,0.99609,0.22222,0.99609,0.2381,0.99609,0.25397,0.99609,0.26984,0.99609,0.28571,0.99609,0.30159,0.99609,0.31746,0.99609,0.33333,0.99609,0.34921,0.99609,0.36508,0.99609,0.38095,0.99609,0.39683,0.99609,0.4127,0.99609,0.42857,0.99609,0.44444,0.99609,0.46032,0.99609,0.47619,0.99609,0.49206,0.99609,0.50794,0.99609,0.52381,0.99609,0.53968,0.99609,0.55556,0.99609,0.57143,0.99609,0.5873,0.99609,0.60317,0.99609,0.61905,0.99609,0.63492,0.99609,0.65079,0.99609,0.66667,0.99609,0.68254,0.99609,0.69841,0.99609,0.71429,0.99609,0.73016,0.99609,0.74603,0.99609,0.7619,0.99609,0.77778,0.99609,0.79365,0.99609,0.80952,0.99609,0.8254,0.99609,0.84127,0.99609,0.85714,0.99609,0.87302,0.99609,0.88889,0.99609,0.90476,0.99609,0.92063,0.99609,0.93651,0.99609,0.95238,0.99609,0.96825,0.99609,0.98413,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 4096 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 8192 total numbers made up of 4096 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD010 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD010().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD010\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD010 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD010_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD010_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD010_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD010_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
