####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD009.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD009.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD009.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD009.x3d'),
    GeoLOD(center=(45.000000,-45.000000,-56675.000000),child1Url=["MarsLOD010.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD010.x3d"],range=3.6E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars003.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars003.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,-90.000000,0.000000),height=[2817.428,2377.7686,1822.4753,1268.8591,2148.3357,2402.4731,3247.3242,2611.7578,1806.448,1472.7885,878.2808,1071.8368,751.0798,852.60156,470.26056,-526.2653,-338.24432,-1202.7878,-2295.2554,-3809.8882,-2299.8506,-1908.3625,-1940.2333,-1944.7366,-2236.205,-2650.1558,-2229.0566,-1971.0515,-1847.4297,-1520.6471,-1295.803,-1245.0776,2297.8135,1694.7782,1132.5745,53.24919,1763.7646,2555.4019,2041.0415,1509.5963,1188.1368,968.57336,602.8718,867.08673,764.4517,70.121765,324.83304,-288.64423,-823.05304,-1198.0461,-2199.559,-3210.155,-2583.684,-2747.1458,-2553.407,-2366.9429,-2424.164,-2391.9497,-2162.5461,-1886.512,-1924.928,-1468.7068,-1325.2252,-1439.4521,1667.6483,1122.4509,521.1337,-493.23892,372.46988,1135.2065,829.6504,643.12946,490.90472,334.08627,39.423813,312.97748,713.3113,156.63156,-514.6302,-981.41925,-1382.2847,-1797.9482,-3136.0425,-2716.6812,-3398.4612,-2727.7605,-2197.987,-2171.1653,-2257.0544,-2174.4534,-1965.1302,-2089.9663,-1905.9222,-1535.141,-1461.4846,-1339.6028,1528.6093,944.53613,331.66574,-456.5301,-709.9499,54.28412,545.65753,486.61044,190.32047,-109.644104,-390.73502,-272.63962,42.552254,-507.19843,-1301.2338,-1644.7589,-2024.9958,-2609.5833,-3622.263,-3582.9797,-3122.4485,-2456.754,-2411.325,-2635.4229,-2315.3352,-2098.2449,-2077.6838,-2010.926,-1870.7471,-1800.8322,-1655.7716,-1420.7526,1467.8578,764.95087,167.67195,-367.95013,-773.83844,-542.6522,218.8717,228.36258,-46.24529,-356.27484,-556.006,-414.83292,-293.02133,-1027.1194,-1741.4869,-2407.528,-2688.3142,-3463.2847,-3783.2903,-2984.5547,-3196.9229,-2786.3435,-2822.6309,-1980.3516,-2026.1863,-1998.2292,-2115.904,-1944.8772,-2080.329,-2030.0818,-1741.1589,-1574.2535,1046.6147,519.9423,40.9569,-330.13873,-735.49634,-580.9868,60.48631,-35.351616,-281.0229,-499.40067,-620.9091,-719.85474,-852.5235,-1686.4294,-2582.3286,-2931.111,-3136.2654,-3699.7185,-3660.9507,-3225.452,-3015.587,-3074.3586,-2585.7114,-2388.189,-2059.0918,-1917.6252,-1974.7859,-2091.015,-2043.8748,-1955.1116,-1928.4594,-1730.5999,845.9715,326.427,-55.61834,-321.85394,-743.1227,-619.2579,108.85169,-166.52444,-409.77682,-577.62164,-676.5089,-897.3301,-1359.9355,-2364.8882,-2976.4678,-3251.5142,-3556.5215,-3670.8936,-3642.7688,-3512.7717,-3395.319,-2871.091,-2786.1472,-2689.089,-2223.595,-1995.2491,-2179.0457,-2090.4746,-1952.4102,-2347.101,-1887.4285,-1962.687,1029.8273,185.3838,-128.22852,-319.4115,-721.25195,-778.2972,-230.634,-81.975365,-347.8131,-537.1778,-687.3954,-890.0732,-1951.9924,-2760.723,-3348.9995,-3615.4636,-3778.43,-3771.911,-3761.0042,-3704.0166,-3528.3484,-3167.1143,-3154.2659,-2972.551,-2357.771,-2040.5691,-2181.5547,-2311.6794,-2046.4948,-1876.4435,-2049.2493,-2043.7485,963.7697,299.82144,94.48914,-122.25658,-379.2362,-845.57227,-883.7743,-478.3043,-1011.3044,-1130.3424,-1043.5836,-813.6754,-2096.9067,-2829.7302,-3547.8403,-3727.3113,-3843.407,-3844.8247,-3815.847,-3711.3218,-3668.3357,-3481.1897,-3514.455,-3511.0908,-2814.8323,-2203.008,-2108.894,-1871.5276,-2345.2214,-2062.29,-1990.6132,-2107.6416,851.487,430.1819,275.48132,274.61148,141.54604,-326.53143,-589.98834,-236.97179,-381.785,-1838.8076,-2562.8494,-1850.1782,-2707.8584,-3324.253,-3722.4187,-3808.0256,-3883.4192,-3902.2366,-3898.6887,-3802.773,-3722.3718,-3740.8635,-3733.067,-3784.679,-3310.9712,-2508.856,-2217.6802,-2365.0159,-2245.0842,-2177.1497,-2147.2534,-2142.6204,879.1625,482.45013,416.01642,779.1349,606.6144,-219.85252,-879.0583,-1226.9333,-1494.4576,-2119.1438,-2251.9294,-2125.4514,-3293.2256,-3367.5723,-3649.0676,-3744.919,-3880.3284,-3911.3582,-3919.4714,-3931.722,-3848.2046,-3884.4417,-3829.7734,-3923.5598,-3746.438,-3132.9114,-2842.2588,-2798.423,-2388.8245,-2368.3916,-2253.57,-2291.378,786.3528,524.4736,573.5419,855.55664,378.21,152.37354,-287.09628,-607.25586,-1022.8819,-1751.8678,-2075.3494,-2279.2605,-2955.6646,-3282.7812,-3522.546,-3652.0974,-3768.601,-3909.2395,-3958.597,-3991.1577,-4011.843,-4049.7183,-3962.531,-3996.3447,-3970.2947,-3799.6785,-3486.122,-3235.9868,-2644.22,-2448.9314,-2394.0894,-2525.489,968.72833,744.44543,910.4867,742.88086,302.31064,263.17786,-32.871796,-757.5857,-1045.3275,-1090.4169,-1138.9534,-1090.2328,-2230.9592,-3320.5625,-3591.5269,-3687.2827,-3753.2952,-3877.5547,-4046.1982,-4086.7927,-4133.401,-4192.333,-4164.18,-4143.1846,-4095.9417,-4093.4487,-3848.8591,-3615.5554,-3051.2974,-2726.1147,-2707.643,-2452.6194,1064.764,798.71765,558.8991,470.3375,787.9396,938.5942,676.46783,-509.31787,-1114.2527,-1276.2982,-1262.7736,-1296.3506,-2353.5938,-3367.693,-3593.099,-3687.7085,-3783.2126,-3918.62,-4052.4082,-4120.543,-4215.4883,-4293.197,-4327.1865,-4314.8525,-4250.3013,-4215.8696,-4121.625,-3901.6956,-3643.8137,-3454.0012,-3157.6035,-2937.6482,784.9253,1367.2677,774.93634,584.06915,879.62683,1124.0117,1122.6881,188.76361,-748.9848,-1069.4413,-1243.4082,-1695.4288,-2115.345,-3286.0076,-3641.2866,-3710.0632,-3837.6262,-3976.206,-4110.422,-4192.6206,-4326.0537,-4409.21,-4461.6836,-4486.42,-4424.1074,-4389.635,-4353.0205,-4290.7114,-4035.0852,-3895.8977,-3780.6133,-3438.4304,580.04193,1027.9407,1010.5169,1000.0568,1036.4819,1072.155,568.5219,368.7415,-443.648,-976.06396,-1229.0292,-1604.6162,-2022.3584,-3150.9504,-3726.9324,-3812.3533,-3902.9182,-4055.8918,-4209.215,-4343.246,-4442.8833,-4519.1343,-4560.5127,-4581.1094,-4569.131,-4543.622,-4522.5596,-4498.7026,-4320.177,-4171.5674,-3986.1653,-3893.8035,-519.1188,-152.68799,771.8569,1187.2163,1150.6672,423.75095,276.5534,-176.2002,-786.9396,-1060.5393,-1652.5504,-2053.5984,-2581.5364,-3267.358,-3808.0051,-3934.2444,-4064.3186,-4190.726,-4356.4053,-4474.4937,-4535.8076,-4612.1426,-4631.3003,-4714.371,-4674.2046,-4651.8853,-4608.519,-4536.7017,-4464.711,-4379.2847,-4261.9365,-4185.328,-847.3451,-749.26355,34.74003,147.44972,-855.0545,-1453.0013,-1202.1538,-1460.8083,-1643.5809,-1479.8489,-1890.1288,-2585.5146,-3197.912,-3693.534,-3944.0083,-4079.2412,-4206.161,-4334.863,-4460.5474,-4536.8975,-4602.5127,-4605.3584,-4545.9434,-4746.0854,-4743.306,-4745.1235,-4688.3257,-4638.605,-4595.5693,-4536.974,-4463.885,-4381.748,-959.7713,-1312.5427,-1988.7031,-2327.9072,-2959.3892,-3194.031,-3062.876,-2511.7705,-1875.9957,-2208.8232,-2752.1091,-3258.6685,-3660.3748,-3902.669,-4074.016,-4225.9204,-4364.121,-4476.8984,-4579.911,-4649.3843,-4696.4307,-4718.4287,-4743.4336,-4840.077,-4828.706,-4776.517,-4756.43,-4706.5933,-4665.009,-4585.088,-4570.5474,-4514.8955,-1744.6028,-2111.8875,-2597.2778,-3008.6619,-3258.7126,-3396.1733,-3508.9417,-3546.6655,-3076.7158,-3028.942,-3656.977,-3943.1204,-4078.483,-4166.118,-4295.806,-4436.517,-4527.916,-4635.068,-4719.179,-4749.9287,-4789.359,-4820.4766,-4828.92,-4892.4053,-4855.093,-4859.6377,-4826.511,-4826.555,-4818.0415,-4719.5796,-4646.138,-4577.4814,-2181.4583,-2660.7695,-3093.661,-3315.191,-3398.1062,-3534.0051,-3632.4492,-3784.2288,-3906.1338,-4049.4207,-4189.377,-4304.6714,-4405.7314,-4492.0894,-4560.275,-4634.8145,-4695.8745,-4774.382,-4844.834,-4877.0884,-4908.4463,-4922.3477,-4936.2065,-4935.756,-4931.4854,-4919.447,-4912.08,-4861.7427,-4855.6826,-4772.2563,-4729.529,-4680.4067,-2825.2056,-3074.1965,-3307.4216,-3439.5598,-3563.5857,-3677.6694,-3813.0596,-3945.1172,-4088.4797,-4225.9175,-4397.6978,-4545.1484,-4619.2734,-4664.9995,-4723.641,-4779.043,-4825.5615,-4874.73,-4915.1885,-4946.9087,-4988.71,-5002.654,-5008.2407,-5033.904,-4993.3486,-4969.392,-4948.288,-4905.34,-4896.6616,-4843.0215,-4800.647,-4710.574,-3272.6108,-3397.0198,-3559.8792,-3702.8984,-3833.6702,-3964.4912,-4086.5928,-4210.2725,-4328.9805,-4437.396,-4535.211,-4673.95,-4766.492,-4828.1963,-4873.5312,-4906.1357,-4955.2505,-4993.068,-5005.673,-5036.341,-5089.8916,-5086.376,-5073.561,-5049.93,-5065.396,-5041.874,-5003.045,-4956.9346,-4889.9087,-4868.424,-4819.011,-4757.4336,-3671.2485,-3759.4219,-3866.778,-3986.6152,-4111.1704,-4243.3496,-4385.8037,-4514.3794,-4631.2847,-4725.2866,-4779.6963,-4858.7046,-4920.9194,-4965.8,-5011.21,-5026.0327,-5036.2437,-5063.1587,-5067.7793,-5102.792,-5112.4185,-5131.4507,-5113.731,-5104.704,-5114.8145,-5087.2524,-5004.9976,-5017.864,-5339.189,-4772.638,-4845.933,-4813.592,-3988.416,-4100.528,-4220.5444,-4333.152,-4447.828,-4569.4097,-4699.239,-4832.275,-4944.721,-5033.2427,-5105.6245,-5126.1597,-5099.4053,-5087.25,-5086.208,-5100.284,-5135.49,-5138.595,-5159.326,-5160.731,-5163.345,-5158.43,-5126.037,-5161.54,-5140.4487,-5089.094,-5034.9463,-4939.6543,-4833.8003,-4864.628,-4871.353,-4838.3413,-4349.5776,-4477.0713,-4594.4375,-4684.5425,-4748.8584,-4803.9087,-4862.576,-4931.5005,-4989.739,-5044.3433,-5069.087,-5090.61,-5095.9976,-5106.1836,-5131.9517,-5155.9385,-5165.7427,-5184.8853,-5191.3877,-5205.085,-5185.57,-5164.9077,-5160.198,-5145.0117,-5103.399,-5075.367,-5059.3477,-5003.037,-4979.2725,-4911.0747,-4879.6562,-4825.7705,-4656.7686,-4720.6724,-4789.1675,-4842.285,-4903.7773,-4925.6733,-4938.0386,-4936.8594,-4940.807,-4951.9453,-4992.179,-5023.6177,-5059.293,-5081.6895,-5121.974,-5132.2925,-5140.753,-5170.8667,-5191.482,-5200.813,-5188.577,-5196.217,-5171.8237,-5120.908,-5077.4746,-5053.158,-5013.785,-4992.3516,-4971.9487,-4921.707,-4881.9,-4833.995,-4806.839,-4834.9565,-4878.208,-4941.2363,-4970.848,-4986.537,-5015.712,-5032.2314,-5022.146,-5036.7773,-5078.9087,-5071.46,-5093.39,-5128.8936,-5119.6133,-5109.021,-5114.3286,-5131.515,-5154.548,-5159.4624,-5153.723,-5153.4062,-5131.1807,-5103.81,-5081.9146,-5055.817,-5010.308,-4970.5728,-4921.3066,-4876.7573,-4859.1,-4832.8604,-4899.9756,-4922.7773,-4954.4155,-4982.2944,-5000.7964,-5011.725,-5056.829,-5090.6104,-5112.6304,-5133.588,-5151.967,-5064.435,-5029.3555,-5099.277,-5163.6284,-5148.322,-5108.317,-5088.126,-5070.185,-5056.177,-5048.78,-5013.7676,-4995.9077,-4979.9443,-4953.24,-4859.472,-4817.112,-4777.867,-4663.419,-4608.993,-4568.8945,-4479.1084,-4719.5605,-4730.4897,-4791.4556,-4788.122,-4578.473,-4506.061,-4685.424,-4515.952,-4442.4824,-4430.0215,-4657.764,-4813.4194,-4873.2065,-4915.4937,-5013.231,-4918.808,-4733.209,-4630.537,-4520.779,-4401.397,-4326.527,-4220.3545,-4083.6387,-4017.6123,-3870.2004,-3805.2175,-3703.2656,-3591.3315,-3575.7627,-3479.9463,-3444.06,-3406.3025,-3408.0505,-3430.2383,-3464.0122,-3545.78,-3651.6821,-3727.0554,-3709.837,-3663.9153,-3639.4697,-3627.9968,-3647.966,-3798.7866,-3925.1692,-4089.7485,-4221.7036,-4342.232,-4393.8916,-4353.191,-4301.143,-4240.9224,-4164.094,-4103.864,-4051.9001,-3979.3086,-3954.7964,-3870.9585,-3730.3694,-3627.657,-3567.9243,-3543.7695,-3530.1287,-3591.9355,-2526.9043,-2514.2695,-2538.2295,-2563.6223,-2572.0598,-2594.527,-2641.3542,-2675.0247,-2714.268,-2743.6113,-2780.3506,-2805.4038,-2812.1133,-2814.1748,-2830.6023,-2901.4954,-2960.2295,-3011.6162,-3063.6785,-3075.4155,-3145.8425,-3142.1174,-3157.692,-3196.4507,-3222.3386,-3171.7883,-3087.6284,-3082.6025,-3032.815,-3038.404,-3023.77,-3066.6208],solid=False,xDimension=32,xSpacing=2.903226,yScale=50.0,zDimension=32,zSpacing=2.903226,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.03226,0.00391),(0.06452,0.00391),(0.09677,0.00391),(0.12903,0.00391),(0.16129,0.00391),(0.19355,0.00391),(0.22581,0.00391),(0.25806,0.00391),(0.29032,0.00391),(0.32258,0.00391),(0.35484,0.00391),(0.3871,0.00391),(0.41935,0.00391),(0.45161,0.00391),(0.48387,0.00391),(0.51613,0.00391),(0.54839,0.00391),(0.58065,0.00391),(0.6129,0.00391),(0.64516,0.00391),(0.67742,0.00391),(0.70968,0.00391),(0.74194,0.00391),(0.77419,0.00391),(0.80645,0.00391),(0.83871,0.00391),(0.87097,0.00391),(0.90323,0.00391),(0.93548,0.00391),(0.96774,0.00391),(0.99609,0.00391),(0.00391,0.03226),(0.03226,0.03226),(0.06452,0.03226),(0.09677,0.03226),(0.12903,0.03226),(0.16129,0.03226),(0.19355,0.03226),(0.22581,0.03226),(0.25806,0.03226),(0.29032,0.03226),(0.32258,0.03226),(0.35484,0.03226),(0.3871,0.03226),(0.41935,0.03226),(0.45161,0.03226),(0.48387,0.03226),(0.51613,0.03226),(0.54839,0.03226),(0.58065,0.03226),(0.6129,0.03226),(0.64516,0.03226),(0.67742,0.03226),(0.70968,0.03226),(0.74194,0.03226),(0.77419,0.03226),(0.80645,0.03226),(0.83871,0.03226),(0.87097,0.03226),(0.90323,0.03226),(0.93548,0.03226),(0.96774,0.03226),(0.99609,0.03226),(0.00391,0.06452),(0.03226,0.06452),(0.06452,0.06452),(0.09677,0.06452),(0.12903,0.06452),(0.16129,0.06452),(0.19355,0.06452),(0.22581,0.06452),(0.25806,0.06452),(0.29032,0.06452),(0.32258,0.06452),(0.35484,0.06452),(0.3871,0.06452),(0.41935,0.06452),(0.45161,0.06452),(0.48387,0.06452),(0.51613,0.06452),(0.54839,0.06452),(0.58065,0.06452),(0.6129,0.06452),(0.64516,0.06452),(0.67742,0.06452),(0.70968,0.06452),(0.74194,0.06452),(0.77419,0.06452),(0.80645,0.06452),(0.83871,0.06452),(0.87097,0.06452),(0.90323,0.06452),(0.93548,0.06452),(0.96774,0.06452),(0.99609,0.06452),(0.00391,0.09677),(0.03226,0.09677),(0.06452,0.09677),(0.09677,0.09677),(0.12903,0.09677),(0.16129,0.09677),(0.19355,0.09677),(0.22581,0.09677),(0.25806,0.09677),(0.29032,0.09677),(0.32258,0.09677),(0.35484,0.09677),(0.3871,0.09677),(0.41935,0.09677),(0.45161,0.09677),(0.48387,0.09677),(0.51613,0.09677),(0.54839,0.09677),(0.58065,0.09677),(0.6129,0.09677),(0.64516,0.09677),(0.67742,0.09677),(0.70968,0.09677),(0.74194,0.09677),(0.77419,0.09677),(0.80645,0.09677),(0.83871,0.09677),(0.87097,0.09677),(0.90323,0.09677),(0.93548,0.09677),(0.96774,0.09677),(0.99609,0.09677),(0.00391,0.12903),(0.03226,0.12903),(0.06452,0.12903),(0.09677,0.12903),(0.12903,0.12903),(0.16129,0.12903),(0.19355,0.12903),(0.22581,0.12903),(0.25806,0.12903),(0.29032,0.12903),(0.32258,0.12903),(0.35484,0.12903),(0.3871,0.12903),(0.41935,0.12903),(0.45161,0.12903),(0.48387,0.12903),(0.51613,0.12903),(0.54839,0.12903),(0.58065,0.12903),(0.6129,0.12903),(0.64516,0.12903),(0.67742,0.12903),(0.70968,0.12903),(0.74194,0.12903),(0.77419,0.12903),(0.80645,0.12903),(0.83871,0.12903),(0.87097,0.12903),(0.90323,0.12903),(0.93548,0.12903),(0.96774,0.12903),(0.99609,0.12903),(0.00391,0.16129),(0.03226,0.16129),(0.06452,0.16129),(0.09677,0.16129),(0.12903,0.16129),(0.16129,0.16129),(0.19355,0.16129),(0.22581,0.16129),(0.25806,0.16129),(0.29032,0.16129),(0.32258,0.16129),(0.35484,0.16129),(0.3871,0.16129),(0.41935,0.16129),(0.45161,0.16129),(0.48387,0.16129),(0.51613,0.16129),(0.54839,0.16129),(0.58065,0.16129),(0.6129,0.16129),(0.64516,0.16129),(0.67742,0.16129),(0.70968,0.16129),(0.74194,0.16129),(0.77419,0.16129),(0.80645,0.16129),(0.83871,0.16129),(0.87097,0.16129),(0.90323,0.16129),(0.93548,0.16129),(0.96774,0.16129),(0.99609,0.16129),(0.00391,0.19355),(0.03226,0.19355),(0.06452,0.19355),(0.09677,0.19355),(0.12903,0.19355),(0.16129,0.19355),(0.19355,0.19355),(0.22581,0.19355),(0.25806,0.19355),(0.29032,0.19355),(0.32258,0.19355),(0.35484,0.19355),(0.3871,0.19355),(0.41935,0.19355),(0.45161,0.19355),(0.48387,0.19355),(0.51613,0.19355),(0.54839,0.19355),(0.58065,0.19355),(0.6129,0.19355),(0.64516,0.19355),(0.67742,0.19355),(0.70968,0.19355),(0.74194,0.19355),(0.77419,0.19355),(0.80645,0.19355),(0.83871,0.19355),(0.87097,0.19355),(0.90323,0.19355),(0.93548,0.19355),(0.96774,0.19355),(0.99609,0.19355),(0.00391,0.22581),(0.03226,0.22581),(0.06452,0.22581),(0.09677,0.22581),(0.12903,0.22581),(0.16129,0.22581),(0.19355,0.22581),(0.22581,0.22581),(0.25806,0.22581),(0.29032,0.22581),(0.32258,0.22581),(0.35484,0.22581),(0.3871,0.22581),(0.41935,0.22581),(0.45161,0.22581),(0.48387,0.22581),(0.51613,0.22581),(0.54839,0.22581),(0.58065,0.22581),(0.6129,0.22581),(0.64516,0.22581),(0.67742,0.22581),(0.70968,0.22581),(0.74194,0.22581),(0.77419,0.22581),(0.80645,0.22581),(0.83871,0.22581),(0.87097,0.22581),(0.90323,0.22581),(0.93548,0.22581),(0.96774,0.22581),(0.99609,0.22581),(0.00391,0.25806),(0.03226,0.25806),(0.06452,0.25806),(0.09677,0.25806),(0.12903,0.25806),(0.16129,0.25806),(0.19355,0.25806),(0.22581,0.25806),(0.25806,0.25806),(0.29032,0.25806),(0.32258,0.25806),(0.35484,0.25806),(0.3871,0.25806),(0.41935,0.25806),(0.45161,0.25806),(0.48387,0.25806),(0.51613,0.25806),(0.54839,0.25806),(0.58065,0.25806),(0.6129,0.25806),(0.64516,0.25806),(0.67742,0.25806),(0.70968,0.25806),(0.74194,0.25806),(0.77419,0.25806),(0.80645,0.25806),(0.83871,0.25806),(0.87097,0.25806),(0.90323,0.25806),(0.93548,0.25806),(0.96774,0.25806),(0.99609,0.25806),(0.00391,0.29032),(0.03226,0.29032),(0.06452,0.29032),(0.09677,0.29032),(0.12903,0.29032),(0.16129,0.29032),(0.19355,0.29032),(0.22581,0.29032),(0.25806,0.29032),(0.29032,0.29032),(0.32258,0.29032),(0.35484,0.29032),(0.3871,0.29032),(0.41935,0.29032),(0.45161,0.29032),(0.48387,0.29032),(0.51613,0.29032),(0.54839,0.29032),(0.58065,0.29032),(0.6129,0.29032),(0.64516,0.29032),(0.67742,0.29032),(0.70968,0.29032),(0.74194,0.29032),(0.77419,0.29032),(0.80645,0.29032),(0.83871,0.29032),(0.87097,0.29032),(0.90323,0.29032),(0.93548,0.29032),(0.96774,0.29032),(0.99609,0.29032),(0.00391,0.32258),(0.03226,0.32258),(0.06452,0.32258),(0.09677,0.32258),(0.12903,0.32258),(0.16129,0.32258),(0.19355,0.32258),(0.22581,0.32258),(0.25806,0.32258),(0.29032,0.32258),(0.32258,0.32258),(0.35484,0.32258),(0.3871,0.32258),(0.41935,0.32258),(0.45161,0.32258),(0.48387,0.32258),(0.51613,0.32258),(0.54839,0.32258),(0.58065,0.32258),(0.6129,0.32258),(0.64516,0.32258),(0.67742,0.32258),(0.70968,0.32258),(0.74194,0.32258),(0.77419,0.32258),(0.80645,0.32258),(0.83871,0.32258),(0.87097,0.32258),(0.90323,0.32258),(0.93548,0.32258),(0.96774,0.32258),(0.99609,0.32258),(0.00391,0.35484),(0.03226,0.35484),(0.06452,0.35484),(0.09677,0.35484),(0.12903,0.35484),(0.16129,0.35484),(0.19355,0.35484),(0.22581,0.35484),(0.25806,0.35484),(0.29032,0.35484),(0.32258,0.35484),(0.35484,0.35484),(0.3871,0.35484),(0.41935,0.35484),(0.45161,0.35484),(0.48387,0.35484),(0.51613,0.35484),(0.54839,0.35484),(0.58065,0.35484),(0.6129,0.35484),(0.64516,0.35484),(0.67742,0.35484),(0.70968,0.35484),(0.74194,0.35484),(0.77419,0.35484),(0.80645,0.35484),(0.83871,0.35484),(0.87097,0.35484),(0.90323,0.35484),(0.93548,0.35484),(0.96774,0.35484),(0.99609,0.35484),(0.00391,0.3871),(0.03226,0.3871),(0.06452,0.3871),(0.09677,0.3871),(0.12903,0.3871),(0.16129,0.3871),(0.19355,0.3871),(0.22581,0.3871),(0.25806,0.3871),(0.29032,0.3871),(0.32258,0.3871),(0.35484,0.3871),(0.3871,0.3871),(0.41935,0.3871),(0.45161,0.3871),(0.48387,0.3871),(0.51613,0.3871),(0.54839,0.3871),(0.58065,0.3871),(0.6129,0.3871),(0.64516,0.3871),(0.67742,0.3871),(0.70968,0.3871),(0.74194,0.3871),(0.77419,0.3871),(0.80645,0.3871),(0.83871,0.3871),(0.87097,0.3871),(0.90323,0.3871),(0.93548,0.3871),(0.96774,0.3871),(0.99609,0.3871),(0.00391,0.41935),(0.03226,0.41935),(0.06452,0.41935),(0.09677,0.41935),(0.12903,0.41935),(0.16129,0.41935),(0.19355,0.41935),(0.22581,0.41935),(0.25806,0.41935),(0.29032,0.41935),(0.32258,0.41935),(0.35484,0.41935),(0.3871,0.41935),(0.41935,0.41935),(0.45161,0.41935),(0.48387,0.41935),(0.51613,0.41935),(0.54839,0.41935),(0.58065,0.41935),(0.6129,0.41935),(0.64516,0.41935),(0.67742,0.41935),(0.70968,0.41935),(0.74194,0.41935),(0.77419,0.41935),(0.80645,0.41935),(0.83871,0.41935),(0.87097,0.41935),(0.90323,0.41935),(0.93548,0.41935),(0.96774,0.41935),(0.99609,0.41935),(0.00391,0.45161),(0.03226,0.45161),(0.06452,0.45161),(0.09677,0.45161),(0.12903,0.45161),(0.16129,0.45161),(0.19355,0.45161),(0.22581,0.45161),(0.25806,0.45161),(0.29032,0.45161),(0.32258,0.45161),(0.35484,0.45161),(0.3871,0.45161),(0.41935,0.45161),(0.45161,0.45161),(0.48387,0.45161),(0.51613,0.45161),(0.54839,0.45161),(0.58065,0.45161),(0.6129,0.45161),(0.64516,0.45161),(0.67742,0.45161),(0.70968,0.45161),(0.74194,0.45161),(0.77419,0.45161),(0.80645,0.45161),(0.83871,0.45161),(0.87097,0.45161),(0.90323,0.45161),(0.93548,0.45161),(0.96774,0.45161),(0.99609,0.45161),(0.00391,0.48387),(0.03226,0.48387),(0.06452,0.48387),(0.09677,0.48387),(0.12903,0.48387),(0.16129,0.48387),(0.19355,0.48387),(0.22581,0.48387),(0.25806,0.48387),(0.29032,0.48387),(0.32258,0.48387),(0.35484,0.48387),(0.3871,0.48387),(0.41935,0.48387),(0.45161,0.48387),(0.48387,0.48387),(0.51613,0.48387),(0.54839,0.48387),(0.58065,0.48387),(0.6129,0.48387),(0.64516,0.48387),(0.67742,0.48387),(0.70968,0.48387),(0.74194,0.48387),(0.77419,0.48387),(0.80645,0.48387),(0.83871,0.48387),(0.87097,0.48387),(0.90323,0.48387),(0.93548,0.48387),(0.96774,0.48387),(0.99609,0.48387),(0.00391,0.51613),(0.03226,0.51613),(0.06452,0.51613),(0.09677,0.51613),(0.12903,0.51613),(0.16129,0.51613),(0.19355,0.51613),(0.22581,0.51613),(0.25806,0.51613),(0.29032,0.51613),(0.32258,0.51613),(0.35484,0.51613),(0.3871,0.51613),(0.41935,0.51613),(0.45161,0.51613),(0.48387,0.51613),(0.51613,0.51613),(0.54839,0.51613),(0.58065,0.51613),(0.6129,0.51613),(0.64516,0.51613),(0.67742,0.51613),(0.70968,0.51613),(0.74194,0.51613),(0.77419,0.51613),(0.80645,0.51613),(0.83871,0.51613),(0.87097,0.51613),(0.90323,0.51613),(0.93548,0.51613),(0.96774,0.51613),(0.99609,0.51613),(0.00391,0.54839),(0.03226,0.54839),(0.06452,0.54839),(0.09677,0.54839),(0.12903,0.54839),(0.16129,0.54839),(0.19355,0.54839),(0.22581,0.54839),(0.25806,0.54839),(0.29032,0.54839),(0.32258,0.54839),(0.35484,0.54839),(0.3871,0.54839),(0.41935,0.54839),(0.45161,0.54839),(0.48387,0.54839),(0.51613,0.54839),(0.54839,0.54839),(0.58065,0.54839),(0.6129,0.54839),(0.64516,0.54839),(0.67742,0.54839),(0.70968,0.54839),(0.74194,0.54839),(0.77419,0.54839),(0.80645,0.54839),(0.83871,0.54839),(0.87097,0.54839),(0.90323,0.54839),(0.93548,0.54839),(0.96774,0.54839),(0.99609,0.54839),(0.00391,0.58065),(0.03226,0.58065),(0.06452,0.58065),(0.09677,0.58065),(0.12903,0.58065),(0.16129,0.58065),(0.19355,0.58065),(0.22581,0.58065),(0.25806,0.58065),(0.29032,0.58065),(0.32258,0.58065),(0.35484,0.58065),(0.3871,0.58065),(0.41935,0.58065),(0.45161,0.58065),(0.48387,0.58065),(0.51613,0.58065),(0.54839,0.58065),(0.58065,0.58065),(0.6129,0.58065),(0.64516,0.58065),(0.67742,0.58065),(0.70968,0.58065),(0.74194,0.58065),(0.77419,0.58065),(0.80645,0.58065),(0.83871,0.58065),(0.87097,0.58065),(0.90323,0.58065),(0.93548,0.58065),(0.96774,0.58065),(0.99609,0.58065),(0.00391,0.6129),(0.03226,0.6129),(0.06452,0.6129),(0.09677,0.6129),(0.12903,0.6129),(0.16129,0.6129),(0.19355,0.6129),(0.22581,0.6129),(0.25806,0.6129),(0.29032,0.6129),(0.32258,0.6129),(0.35484,0.6129),(0.3871,0.6129),(0.41935,0.6129),(0.45161,0.6129),(0.48387,0.6129),(0.51613,0.6129),(0.54839,0.6129),(0.58065,0.6129),(0.6129,0.6129),(0.64516,0.6129),(0.67742,0.6129),(0.70968,0.6129),(0.74194,0.6129),(0.77419,0.6129),(0.80645,0.6129),(0.83871,0.6129),(0.87097,0.6129),(0.90323,0.6129),(0.93548,0.6129),(0.96774,0.6129),(0.99609,0.6129),(0.00391,0.64516),(0.03226,0.64516),(0.06452,0.64516),(0.09677,0.64516),(0.12903,0.64516),(0.16129,0.64516),(0.19355,0.64516),(0.22581,0.64516),(0.25806,0.64516),(0.29032,0.64516),(0.32258,0.64516),(0.35484,0.64516),(0.3871,0.64516),(0.41935,0.64516),(0.45161,0.64516),(0.48387,0.64516),(0.51613,0.64516),(0.54839,0.64516),(0.58065,0.64516),(0.6129,0.64516),(0.64516,0.64516),(0.67742,0.64516),(0.70968,0.64516),(0.74194,0.64516),(0.77419,0.64516),(0.80645,0.64516),(0.83871,0.64516),(0.87097,0.64516),(0.90323,0.64516),(0.93548,0.64516),(0.96774,0.64516),(0.99609,0.64516),(0.00391,0.67742),(0.03226,0.67742),(0.06452,0.67742),(0.09677,0.67742),(0.12903,0.67742),(0.16129,0.67742),(0.19355,0.67742),(0.22581,0.67742),(0.25806,0.67742),(0.29032,0.67742),(0.32258,0.67742),(0.35484,0.67742),(0.3871,0.67742),(0.41935,0.67742),(0.45161,0.67742),(0.48387,0.67742),(0.51613,0.67742),(0.54839,0.67742),(0.58065,0.67742),(0.6129,0.67742),(0.64516,0.67742),(0.67742,0.67742),(0.70968,0.67742),(0.74194,0.67742),(0.77419,0.67742),(0.80645,0.67742),(0.83871,0.67742),(0.87097,0.67742),(0.90323,0.67742),(0.93548,0.67742),(0.96774,0.67742),(0.99609,0.67742),(0.00391,0.70968),(0.03226,0.70968),(0.06452,0.70968),(0.09677,0.70968),(0.12903,0.70968),(0.16129,0.70968),(0.19355,0.70968),(0.22581,0.70968),(0.25806,0.70968),(0.29032,0.70968),(0.32258,0.70968),(0.35484,0.70968),(0.3871,0.70968),(0.41935,0.70968),(0.45161,0.70968),(0.48387,0.70968),(0.51613,0.70968),(0.54839,0.70968),(0.58065,0.70968),(0.6129,0.70968),(0.64516,0.70968),(0.67742,0.70968),(0.70968,0.70968),(0.74194,0.70968),(0.77419,0.70968),(0.80645,0.70968),(0.83871,0.70968),(0.87097,0.70968),(0.90323,0.70968),(0.93548,0.70968),(0.96774,0.70968),(0.99609,0.70968),(0.00391,0.74194),(0.03226,0.74194),(0.06452,0.74194),(0.09677,0.74194),(0.12903,0.74194),(0.16129,0.74194),(0.19355,0.74194),(0.22581,0.74194),(0.25806,0.74194),(0.29032,0.74194),(0.32258,0.74194),(0.35484,0.74194),(0.3871,0.74194),(0.41935,0.74194),(0.45161,0.74194),(0.48387,0.74194),(0.51613,0.74194),(0.54839,0.74194),(0.58065,0.74194),(0.6129,0.74194),(0.64516,0.74194),(0.67742,0.74194),(0.70968,0.74194),(0.74194,0.74194),(0.77419,0.74194),(0.80645,0.74194),(0.83871,0.74194),(0.87097,0.74194),(0.90323,0.74194),(0.93548,0.74194),(0.96774,0.74194),(0.99609,0.74194),(0.00391,0.77419),(0.03226,0.77419),(0.06452,0.77419),(0.09677,0.77419),(0.12903,0.77419),(0.16129,0.77419),(0.19355,0.77419),(0.22581,0.77419),(0.25806,0.77419),(0.29032,0.77419),(0.32258,0.77419),(0.35484,0.77419),(0.3871,0.77419),(0.41935,0.77419),(0.45161,0.77419),(0.48387,0.77419),(0.51613,0.77419),(0.54839,0.77419),(0.58065,0.77419),(0.6129,0.77419),(0.64516,0.77419),(0.67742,0.77419),(0.70968,0.77419),(0.74194,0.77419),(0.77419,0.77419),(0.80645,0.77419),(0.83871,0.77419),(0.87097,0.77419),(0.90323,0.77419),(0.93548,0.77419),(0.96774,0.77419),(0.99609,0.77419),(0.00391,0.80645),(0.03226,0.80645),(0.06452,0.80645),(0.09677,0.80645),(0.12903,0.80645),(0.16129,0.80645),(0.19355,0.80645),(0.22581,0.80645),(0.25806,0.80645),(0.29032,0.80645),(0.32258,0.80645),(0.35484,0.80645),(0.3871,0.80645),(0.41935,0.80645),(0.45161,0.80645),(0.48387,0.80645),(0.51613,0.80645),(0.54839,0.80645),(0.58065,0.80645),(0.6129,0.80645),(0.64516,0.80645),(0.67742,0.80645),(0.70968,0.80645),(0.74194,0.80645),(0.77419,0.80645),(0.80645,0.80645),(0.83871,0.80645),(0.87097,0.80645),(0.90323,0.80645),(0.93548,0.80645),(0.96774,0.80645),(0.99609,0.80645),(0.00391,0.83871),(0.03226,0.83871),(0.06452,0.83871),(0.09677,0.83871),(0.12903,0.83871),(0.16129,0.83871),(0.19355,0.83871),(0.22581,0.83871),(0.25806,0.83871),(0.29032,0.83871),(0.32258,0.83871),(0.35484,0.83871),(0.3871,0.83871),(0.41935,0.83871),(0.45161,0.83871),(0.48387,0.83871),(0.51613,0.83871),(0.54839,0.83871),(0.58065,0.83871),(0.6129,0.83871),(0.64516,0.83871),(0.67742,0.83871),(0.70968,0.83871),(0.74194,0.83871),(0.77419,0.83871),(0.80645,0.83871),(0.83871,0.83871),(0.87097,0.83871),(0.90323,0.83871),(0.93548,0.83871),(0.96774,0.83871),(0.99609,0.83871),(0.00391,0.87097),(0.03226,0.87097),(0.06452,0.87097),(0.09677,0.87097),(0.12903,0.87097),(0.16129,0.87097),(0.19355,0.87097),(0.22581,0.87097),(0.25806,0.87097),(0.29032,0.87097),(0.32258,0.87097),(0.35484,0.87097),(0.3871,0.87097),(0.41935,0.87097),(0.45161,0.87097),(0.48387,0.87097),(0.51613,0.87097),(0.54839,0.87097),(0.58065,0.87097),(0.6129,0.87097),(0.64516,0.87097),(0.67742,0.87097),(0.70968,0.87097),(0.74194,0.87097),(0.77419,0.87097),(0.80645,0.87097),(0.83871,0.87097),(0.87097,0.87097),(0.90323,0.87097),(0.93548,0.87097),(0.96774,0.87097),(0.99609,0.87097),(0.00391,0.90323),(0.03226,0.90323),(0.06452,0.90323),(0.09677,0.90323),(0.12903,0.90323),(0.16129,0.90323),(0.19355,0.90323),(0.22581,0.90323),(0.25806,0.90323),(0.29032,0.90323),(0.32258,0.90323),(0.35484,0.90323),(0.3871,0.90323),(0.41935,0.90323),(0.45161,0.90323),(0.48387,0.90323),(0.51613,0.90323),(0.54839,0.90323),(0.58065,0.90323),(0.6129,0.90323),(0.64516,0.90323),(0.67742,0.90323),(0.70968,0.90323),(0.74194,0.90323),(0.77419,0.90323),(0.80645,0.90323),(0.83871,0.90323),(0.87097,0.90323),(0.90323,0.90323),(0.93548,0.90323),(0.96774,0.90323),(0.99609,0.90323),(0.00391,0.93548),(0.03226,0.93548),(0.06452,0.93548),(0.09677,0.93548),(0.12903,0.93548),(0.16129,0.93548),(0.19355,0.93548),(0.22581,0.93548),(0.25806,0.93548),(0.29032,0.93548),(0.32258,0.93548),(0.35484,0.93548),(0.3871,0.93548),(0.41935,0.93548),(0.45161,0.93548),(0.48387,0.93548),(0.51613,0.93548),(0.54839,0.93548),(0.58065,0.93548),(0.6129,0.93548),(0.64516,0.93548),(0.67742,0.93548),(0.70968,0.93548),(0.74194,0.93548),(0.77419,0.93548),(0.80645,0.93548),(0.83871,0.93548),(0.87097,0.93548),(0.90323,0.93548),(0.93548,0.93548),(0.96774,0.93548),(0.99609,0.93548),(0.00391,0.96774),(0.03226,0.96774),(0.06452,0.96774),(0.09677,0.96774),(0.12903,0.96774),(0.16129,0.96774),(0.19355,0.96774),(0.22581,0.96774),(0.25806,0.96774),(0.29032,0.96774),(0.32258,0.96774),(0.35484,0.96774),(0.3871,0.96774),(0.41935,0.96774),(0.45161,0.96774),(0.48387,0.96774),(0.51613,0.96774),(0.54839,0.96774),(0.58065,0.96774),(0.6129,0.96774),(0.64516,0.96774),(0.67742,0.96774),(0.70968,0.96774),(0.74194,0.96774),(0.77419,0.96774),(0.80645,0.96774),(0.83871,0.96774),(0.87097,0.96774),(0.90323,0.96774),(0.93548,0.96774),(0.96774,0.96774),(0.99609,0.96774),(0.00391,0.99609),(0.03226,0.99609),(0.06452,0.99609),(0.09677,0.99609),(0.12903,0.99609),(0.16129,0.99609),(0.19355,0.99609),(0.22581,0.99609),(0.25806,0.99609),(0.29032,0.99609),(0.32258,0.99609),(0.35484,0.99609),(0.3871,0.99609),(0.41935,0.99609),(0.45161,0.99609),(0.48387,0.99609),(0.51613,0.99609),(0.54839,0.99609),(0.58065,0.99609),(0.6129,0.99609),(0.64516,0.99609),(0.67742,0.99609),(0.70968,0.99609),(0.74194,0.99609),(0.77419,0.99609),(0.80645,0.99609),(0.83871,0.99609),(0.87097,0.99609),(0.90323,0.99609),(0.93548,0.99609),(0.96774,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD009.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD009.py load and self-test diagnostics complete.")
