package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD008Index.html" target="_blank">MarsLOD008</a>,  source <a href="../../../Geospatial/MarsLOD008.java">MarsLOD008.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD008.x3d">MarsLOD008.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD008.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD008.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD008
{
	/** Default constructor to create this object. */
	public MarsLOD008 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD008.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD008.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD008.x3d"))
    .addChild(new GeoLOD().setCenter(-44.911417,-45.000000,31375.000000).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars002.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars002.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(-90.000000,-90.000000,0.000000).setSolid(false).setXDimension(128).setXSpacing(0.708661).setYScale(50.0).setZDimension(128).setZSpacing(0.708661).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {3663.9185,3672.5332,3683.147,3683.025,3689.042,3696.6382,3695.3662,3693.9744,3694.951,3700.363,3710.4055,3711.6956,3711.524,3707.1667,3711.038,3707.8193,3697.0615,3709.3108,3724.091,3718.3127,3721.6887,3727.76,3740.8005,3745.4568,3750.845,3765.375,3777.3257,3782.2344,3784.6147,3792.0774,3795.9685,3803.582,3808.7314,3815.186,3823.4246,3822.405,3819.626,3823.1963,3822.6243,3824.7114,3836.215,3841.2822,3844.6252,3859.3147,3859.1616,3851.0364,3855.7483,3870.2024,3887.503,3891.1404,3894.7158,3900.9412,3894.7473,3884.316,3878.848,3871.6755,3868.1123,3862.2463,3852.48,3834.758,3815.6265,3810.0215,3857.4866,3886.8035,3878.9854,3927.1677,3939.3274,3949.6187,3968.3438,3964.0627,3965.3933,3967.3555,3979.2341,4000.169,4010.3774,4017.5938,4001.6313,3998.8955,4005.7234,4024.6106,4031.7488,4035.9675,4030.5317,4033.3552,4064.2903,4069.386,4070.848,4072.053,4073.9194,4078.7026,4081.6306,4084.6956,4085.6528,4085.5898,4089.144,4094.6685,4095.9922,4099.2134,4094.943,4087.9163};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {4075.6008,4070.4778,4076.6597,4077.9062,4073.1064,4077.8882,4082.573,4084.5845,4078.2515,4072.2373,4067.1772,4067.5789,4066.9282,4057.2139,4051.8345,4048.478,4046.9983,4046.3525,4042.3167,4038.6313,4038.2551,4032.6846,4045.8376,4037.0408,4018.3362,4015.616,4016.4998,4017.3745,3346.9036,3363.395,3380.628,3415.1245,3435.7039,3437.3264,3404.7603,3398.1892,3425.1118,3378.624,3364.1775,3401.209,3416.7778,3412.719,3454.4783,3511.9702,3512.213,3496.8367,3498.427,3505.2988,3523.503,3531.6934,3563.5305,3608.9963,3631.689,3637.504,3642.211,3648.8022,3660.9756,3667.3062,3661.561,3659.2166,3669.5896,3681.1863,3712.1194,3721.0898,3728.7249,3747.6343,3753.6047,3755.7932,3774.9172,3790.4353,3796.9573,3818.5872,3824.2979,3820.0684,3824.7205,3847.668,3855.7917,3860.4636,3839.5847,3802.5598,3776.7156,3811.315,3881.5066,3907.2642,3947.9575,3974.7117,3966.9836,3974.4028,3983.5647,3973.941,3986.876,3990.8254,3999.6409,4047.0151,4060.4365,4065.7544,4072.813,4082.3381,4097.4004,4107.0684};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {4115.442,4124.7163,4127.911,4152.0073,4160.3237,4156.368,4163.5273,4177.583,4184.6787,4194.2993,4201.924,4221.9824,4239.2715,4243.3877,4251.036,4257.997,4258.481,4261.4463,4268.894,4271.243,4275.7563,4277.9736,4278.764,4281.787,4285.8174,4289.3687,4293.043,4299.7183,4308.907,4310.5083,4312.2017,4312.0835,4311.346,4319.1753,4315.533,4312.734,4309.6055,4309.9956,4315.845,4319.7812,4316.823,4298.4814,4279.6963,4256.0723,4294.9077,4330.6855,4329.405,4257.25,4232.5522,4238.848,4254.0605,4275.7715,4297.068,4294.347,4290.909,4286.2446,3024.6682,3037.3147,3025.672,3083.4788,3092.2576,3072.698,3084.0383,3066.157,3059.3767,2982.6167,2964.6265,3044.0203,3079.4016,3107.8406,3190.2122,3279.9788,3286.6067,3288.2458,3291.6987,3291.2817,3287.3276,3280.3037,3300.9365,3357.129,3399.9006,3438.0981,3477.112,3484.4856,3480.4094,3497.8062,3504.7048,3530.284,3553.6243,3568.1846,3588.5625,3597.583,3577.6934,3597.4478,3635.4307,3658.6245,3664.8896,3660.8745,3657.292,3654.9941};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {3642.945,3640.142,3648.0579,3577.164,3571.7974,3736.9583,3753.7856,3739.3718,3728.9265,3780.4688,3929.5156,3970.216,3990.843,4008.7012,4002.9617,4021.6052,4039.3894,4048.5713,4075.8447,4074.2153,4069.6204,4108.29,4132.913,4137.938,4139.5884,4142.229,4151.2485,4162.9097,4177.5225,4190.4355,4220.953,4238.4614,4251.441,4258.359,4260.471,4278.338,4289.8447,4311.3276,4322.1177,4323.766,4329.78,4330.715,4320.6455,4332.348,4337.175,4341.7856,4360.7104,4370.152,4382.616,4396.978,4401.2344,4387.9307,4365.059,4354.614,4375.0854,4433.291,4517.9985,4543.609,4545.7944,4547.944,4553.2915,4566.2764,4575.4243,4579.7944,4583.154,4588.868,4593.2397,4575.259,4545.223,4522.871,4514.281,4574.964,4627.9424,4673.704,4666.668,4558.0234,4563.159,4600.511,4633.4575,4615.5483,4479.35,4532.503,4500.8584,4509.3457,2865.5012,2872.1675,2868.7722,2877.7197,2876.5483,2873.5,2889.3857,2915.5938,2926.0586,2936.8022,2940.6465,2954.192,2959.9749,2982.062,2993.4229,3006.1108};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {3014.5476,3049.0615,3062.0823,3081.9048,3092.5762,3073.9348,3074.744,3159.2485,3219.6516,3228.6284,3252.1794,3268.3135,3284.8135,3288.2122,3281.658,3322.2644,3373.2397,3386.4434,3434.0115,3455.459,3466.1477,3483.996,3501.5432,3514.5652,3518.511,3502.3809,3458.9963,3414.4758,3426.938,3553.458,3664.9946,3685.3997,3681.171,3699.3074,3762.441,3828.5508,3841.018,3858.3293,3896.8838,3910.816,3922.7957,3936.7664,3944.3098,3958.2524,3968.5193,3978.9304,3994.742,3998.2815,4003.5342,4004.3213,4010.2239,4008.168,4002.5413,4014.3098,4046.265,4068.5757,4089.785,4105.48,4106.967,4109.654,4108.8564,4105.8154,4101.049,4103.8745,4134.457,4195.507,4220.569,4230.9854,4240.4414,4265.426,4290.737,4322.796,4338.444,4346.4097,4377.297,4387.0254,4410.109,4425.383,4432.501,4404.5146,4356.6787,4322.096,4333.947,4405.1606,4599.389,4671.3643,4688.0024,4687.297,4690.682,4707.847,4721.2817,4730.97,4737.8677,4744.976,4758.863,4766.1616,4769.791,4772.314,4769.668,4762.8623};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {4757.0547,4750.3115,4743.739,4737.4863,4730.2876,4721.7803,4713.9795,4706.0093,4692.681,4688.973,4674.064,4671.19,2710.7454,2732.974,2747.14,2761.0718,2784.9407,2811.5325,2820.7034,2835.6753,2846.1746,2841.1633,2838.941,2838.8992,2842.9685,2848.565,2848.457,2853.4111,2861.1504,2869.584,2877.1282,2905.7202,2942.3267,2976.743,2987.0525,2997.0203,3010.5764,2985.4297,2976.1274,3015.2095,3077.9907,3121.055,3151.0437,3162.3245,3166.9177,3178.8289,3201.6013,3215.2134,3227.6055,3238.3594,3265.0972,3307.4246,3347.2917,3339.7327,3286.315,3272.8125,3329.7908,3386.354,3487.2886,3625.0166,3638.6755,3656.9763,3697.627,3706.4053,3719.5542,3739.987,3749.8486,3753.44,3759.4421,3766.7764,3769.2146,3770.486,3771.0173,3769.029,3764.8933,3757.0193,3743.1958,3723.389,3680.9485,3583.9934,3581.7554,3648.554,3747.959,3870.5457,3968.345,4051.3894,4100.704,4122.903,4141.454,4152.7393,4160.6333,4163.9966,4171.643,4190.5977,4202.026,4203.4624,4209.9565,4217.5845,4223.237,4230.0693};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {4232.6606,4241.55,4266.0073,4285.1245,4308.1562,4317.6323,4314.1694,4304.2515,4290.0938,4310.212,4360.997,4414.807,4491.251,4547.57,4572.9385,4587.3496,4601.878,4617.003,4627.7197,4636.2354,4643.8574,4654.038,4662.346,4670.311,4676.134,4678.833,4681.781,4681.5684,4680.908,4680.1304,4677.7954,4676.002,4675.3936,4675.902,4672.0303,4667.761,4658.3086,4637.1216,4622.188,4607.191,2506.6143,2511.1409,2509.761,2512.272,2524.604,2543.098,2570.76,2602.0337,2632.4485,2668.539,2696.4143,2719.31,2743.3542,2751.0103,2750.8057,2748.8936,2749.4187,2743.1506,2736.5632,2721.731,2698.6921,2672.1128,2669.4478,2657.0972,2656.5872,2713.0078,2781.5676,2806.0364,2851.3215,2903.2314,2940.6626,2989.517,3016.615,3041.7334,3046.7815,3042.5508,3032.5027,3018.2832,3002.486,2979.397,2987.4036,2988.2744,2989.3284,3061.6743,3140.2324,3210.45,3271.8826,3302.419,3325.0815,3331.1858,3336.0427,3342.2754,3346.0962,3366.0603,3406.5671,3449.5513,3482.5613,3494.2327,3503.9014,3515.536};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {3519.8853,3509.8865,3497.9084,3484.7122,3470.788,3453.2708,3440.7188,3442.1304,3428.0098,3380.1936,3427.4944,3578.052,3700.1284,3771.4053,3840.2712,3898.7292,3927.0146,3942.2349,3954.8274,3967.3745,3971.3315,3973.4648,3982.443,3993.1975,3998.9644,4008.1694,4020.404,4039.0535,4044.6116,4021.4524,4030.0417,4031.7104,4031.0623,4029.0432,4036.2368,4051.8093,4072.1423,4079.6868,4086.6145,4100.1143,4113.123,4132.21,4142.5767,4147.627,4156.052,4162.1523,4173.4644,4180.289,4186.028,4193.5493,4196.8457,4201.3574,4210.6865,4222.6616,4232.8604,4241.3755,4247.6387,4247.3267,4248.7163,4246.1743,4239.7983,4235.812,4230.954,4227.75,4217.5664,4209.2266,4200.0107,4184.8887,2205.085,2223.912,2254.4495,2311.833,2358.242,2365.5574,2355.9385,2360.1543,2375.8918,2400.254,2428.7974,2448.4365,2463.5986,2483.51,2491.7075,2499.4746,2509.2405,2521.275,2543.4614,2549.813,2558.5842,2590.1917,2611.1436,2609.3972,2574.196,2519.5303,2478.264,2448.1604,2433.9468,2431.0151,2444.0212,2480.8894};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {2530.202,2601.1074,2656.1953,2664.6633,2649.4814,2637.7253,2593.8792,2498.8545,2469.6624,2470.5396,2410.4504,2430.166,2558.9548,2774.1843,2948.957,3101.467,3204.5256,3230.1628,3235.255,3230.221,3214.5923,3191.6418,3158.8037,3124.3506,3103.804,3108.3286,3126.5632,3148.594,3186.8372,3164.6616,3134.6592,3092.1204,3005.485,2999.0364,3075.219,3218.8682,3328.152,3360.3416,3369.6387,3371.82,3372.088,3387.4526,3421.1252,3440.2493,3456.3904,3460.0442,3447.8728,3439.9868,3433.5583,3448.6858,3483.9749,3520.6172,3564.3967,3610.729,3652.2969,3667.7588,3657.0264,3589.794,3540.1306,3487.312,3418.1235,3379.3254,3364.7156,3365.0955,3324.4731,3268.1863,3232.9172,3219.0095,3269.9895,3341.4634,3371.6025,3383.1606,3379.5845,3384.6892,3383.7996,3381.5938,3380.9924,3380.311,3377.2415,3374.4177,3373.1375,3381.499,3391.8838,3412.9048,3429.0356,3446.4507,3476.657,3510.3174,3547.958,3580.3713,3603.8323,3631.6626,3639.7378,3589.506,3489.729,3459.2195,2299.9302,2288.5078,2276.6304,2262.289};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {2271.7666,2254.2688,2154.104,1964.977,1891.1176,1890.3015,1887.7372,1925.8915,1974.6614,1998.3638,2012.3463,2019.3086,2025.3402,2014.2339,2053.0718,2123.7354,2185.9573,2244.4043,2307.0037,2336.7046,2396.694,2461.2495,2482.9348,2488.5913,2483.2827,2470.976,2437.364,2390.2944,2356.1448,2340.5164,2330.0098,2318.9238,2353.358,2387.283,2391.2876,2388.06,2372.421,2356.5256,2295.69,2202.1045,2124.1133,2057.6306,2016.1237,2078.8223,2298.0044,2551.2622,2772.1333,2900.631,2928.6582,2918.6687,2862.8477,2773.6714,2690.5906,2667.1743,2693.7498,2754.988,2821.7532,2896.179,2945.6729,2904.0378,2717.6392,2540.3992,2475.482,2445.358,2434.8943,2425.7107,2453.8162,2480.5166,2496.6304,2523.3328,2583.661,2662.1958,2741.5754,2782.1348,2779.5703,2783.0405,2786.2656,2743.214,2694.6084,2682.9333,2688.225,2644.4883,2597.2634,2602.3691,2600.871,2582.3828,2559.5852,2543.733,2529.1577,2486.7578,2424.877,2409.2717,2372.5037,2349.5542,2309.5178,2215.3828,2131.4275,2105.6868,2094.8616,2061.832};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {2051.2876,2079.9429,2111.7236,2072.6553,2001.5669,1959.6323,1924.7026,1873.9373,1839.29,1839.3315,1824.4048,1879.1943,1953.9515,1929.0923,1916.1481,1896.9603,1888.6532,1919.9247,2025.9655,2058.3386,2105.7642,2058.6272,2012.9512,1969.8164,2404.3533,2399.2515,2410.4285,2399.9873,2326.016,2247.4482,2076.458,1909.6532,1845.5804,1924.7776,1971.2472,1999.1293,2023.2155,2045.3618,2072.3137,2080.4143,2073.9272,2061.8606,2049.8088,2063.004,2064.5063,2083.7544,2122.1516,2125.6567,2126.7986,2148.0571,2200.7285,2221.1465,2210.8975,2214.4282,2269.1357,2279.0515,2232.8416,2158.56,2111.659,2070.3745,2030.9739,1988.8145,1966.0449,1982.3308,2021.6914,2148.7405,2242.3323,2239.4055,2128.7905,1994.1108,1942.3579,1934.8627,1958.0818,1988.2952,2012.7622,2079.1497,2161.9163,2239.6555,2310.2976,2370.965,2389.534,2372.1953,2312.0356,2244.4768,2227.9521,2207.021,2227.9443,2321.5073,2397.1604,2413.0544,2371.1553,2321.7893,2262.3464,2195.3086,2121.9631,1945.8768,1674.7606,1483.9062,1477.754,1495.2332};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {1532.5571,1572.9509,1626.2955,1689.2958,1726.1453,1703.8981,1675.3572,1719.3828,1746.5117,1747.4396,1720.8654,1727.674,1726.9402,1685.5096,1666.9135,1655.2162,1685.291,1715.9725,1703.7572,1687.9174,1698.5253,1708.3517,1713.0145,1707.2778,1707.901,1669.2755,1649.966,1635.392,1633.0726,1630.833,1620.0446,1623.8003,1628.1167,1622.8541,1629.5529,1655.1106,1654.2893,1669.71,1729.7054,1725.9962,1708.7261,1720.5453,1741.5071,1748.5887,1755.4518,1748.2242,1754.1259,1744.9945,1762.4152,1750.8378,1746.8798,1794.2852,2403.0942,2398.0737,2413.5237,2408.954,2347.4863,2286.1975,2293.3389,2221.3042,2129.3445,2059.3196,2071.4346,2014.4019,1928.0627,1909.1711,1919.3569,1965.9404,2009.0244,2024.3318,2024.6067,2025.0966,2018.9443,2008.6467,2001.8365,1997.5033,1977.5686,1974.63,1992.0002,2022.9082,2034.2268,2034.4286,2036.4786,2023.406,1963.1442,1900.9601,1831.8491,1748.3088,1697.1451,1529.4529,1513.3411,1482.7439,1377.4331,1496.7284,1733.2283,1759.0559,1832.1112,1779.6587,1739.6058,1688.4698};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {1705.2041,1873.8116,2010.735,2025.2411,1960.5406,1832.948,1685.7267,1629.2361,1682.2351,1798.1052,1898.9478,1935.3485,1995.9575,2004.6118,1987.0713,1929.1666,1723.3279,1630.4023,1609.7863,1681.5465,1910.4479,1968.9047,1954.21,1895.7626,1835.0979,1739.0262,1639.0012,1570.4106,1483.2699,1431.6233,1379.4219,1373.1821,1431.5192,1507.0543,1499.0089,1557.9393,1646.0565,1749.5641,1772.0703,1715.0251,1662.2125,1614.8008,1548.5065,1579.0223,1641.2983,1716.2561,1728.8606,1722.4564,1712.6366,1715.7853,1730.3391,1734.31,1743.054,1741.3501,1733.5793,1700.5048,1750.7294,1850.8916,1852.3141,1833.9047,1823.0569,1815.1581,1809.79,1799.8058,1799.299,1837.1989,1917.3981,1938.4366,1940.2166,1951.8926,1948.2395,1956.4457,1976.9381,1989.6356,1956.5691,1861.9148,1892.2407,1978.1051,2014.6328,2088.0825,2344.47,2330.9226,2351.8176,2358.1985,2318.5713,2363.3596,2360.9602,2302.8462,2123.5845,2087.6714,2129.3596,2149.6025,2127.71,2049.6082,2034.6564,2033.872,1898.3531,1597.8861,1532.8093,1738.114};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {1822.1506,1925.7142,1969.6384,1919.226,1812.8136,1674.549,1812.8666,1846.987,1959.8312,2002.2124,1948.9047,1919.1399,1887.4714,1828.908,1807.8922,1713.5564,1685.2312,1688.278,1624.5715,1429.5288,1289.121,1420.4357,1388.9512,1468.8235,1656.9869,1631.3503,1616.4285,1564.4084,1521.0476,1499.7953,1493.2958,1511.4,1550.7211,1604.483,1575.3519,1516.6359,1454.0507,1370.9286,1386.1632,1477.7332,1490.3478,1433.9491,1399.3425,1366.268,1374.052,1360.2617,1323.1179,1384.9164,1518.2776,1523.9843,1484.6477,1495.4624,1500.1201,1508.1742,1539.624,1564.8529,1558.7373,1534.829,1508.3177,1488.5228,1489.1317,1517.1681,1544.8356,1622.4384,1744.8163,1783.364,1736.0969,1680.1919,1661.1865,1636.9994,1629.0869,1658.8761,1689.8303,1723.8271,1767.2725,1794.3369,1819.8934,1879.5529,1902.072,1911.6454,1903.4476,1925.402,1969.197,1997.7948,2020.2332,2026.2295,2026.8978,2028.7549,2028.5315,2035.5106,2041.1805,2049.8208,2059.6355,2064.0935,2062.8015,2067.393,2090.112,2082.6943,2107.4878,2180.7222};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {2204.1902,2225.1902,2246.9314,2253.5793,2236.4138,2233.995,2231.1606,2237.2576,2364.7344,2346.6155,2329.46,2348.3923,2350.8452,2411.9766,2427.1548,2325.8308,2201.9314,2001.937,2114.9868,2171.63,2253.002,2289.116,2272.921,2153.2927,2025.4434,2008.853,1953.5432,1891.3148,1854.4476,1817.6318,1777.5414,1634.7029,1419.7655,1403.4087,1475.3157,1494.4988,1609.095,1693.6554,1306.5842,1197.9579,1285.8418,1533.296,1681.608,1700.3411,1746.0525,1649.2722,1366.5874,1221.9565,1212.5365,1277.8777,1407.8173,1601.8679,1575.086,1519.3375,1467.6187,1415.5876,1426.6737,1426.3491,1414.0043,1412.7842,1439.1245,1443.8108,1430.4103,1424.6671,1424.8961,1428.3553,1417.796,1398.5375,1390.3256,1387.035,1386.015,1378.8707,1376.4816,1386.5552,1416.2687,1460.6282,1511.637,1560.0753,1557.754,1583.2133,1558.6239,1545.18,1615.3427,1722.0376,1733.1923,1719.0673,1708.1154,1696.4615,1679.1051,1681.6348,1626.6354,1665.997,1674.9855,1666.1989,1673.6239,1699.6807,1735.3756,1750.3641,1754.2473,1746.4326};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {1739.9985,1734.3655,1739.1039,1722.0616,1721.3085,1735.7556,1666.8105,1505.0885,1545.5881,1810.5371,1897.6886,1914.597,1930.0116,1953.7228,1967.1838,1978.0215,1980.5084,1988.2212,1994.2799,1996.8184,2003.0847,2006.9666,2010.4395,2009.2524,2001.686,1976.7366,1986.8042,2024.1215,2037.683,2042.5154,2079.1294,2099.0774,2084.993,2090.1152,2095.1501,2106.3755,2160.5286,2221.4773,2147.5217,2107.5994,2162.4084,2241.295,2194.9775,2116.3713,2198.245,2229.9958,2141.7234,2063.082,2097.0327,2097.91,1993.7999,2059.414,2159.9531,2172.43,2120.0977,2079.3115,2063.7825,2066.0562,1868.2762,1517.7875,1286.4515,1017.3156,953.4677,967.5425,1010.9163,930.644,890.73773,966.25476,1403.2163,1677.7227,1662.6223,1567.4983,1520.9391,1397.4991,1071.3455,938.9645,992.51654,1232.6444,1344.0769,1379.6871,1565.8861,1518.8573,1469.9916,1435.9391,1422.3506,1417.7306,1437.3687,1448.1008,1429.0692,1417.8094,1407.919,1390.3318,1384.9692,1404.2897,1310.7064,1396.8113,1393.2592,1399.0298,1407.1581,1420.2925};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1448.9749,1448.7644,1445.1003,1447.2621,1473.0807,1457.2059,1432.2104,1424.6316,1450.2219,1485.8107,1523.7148,1590.0566,1664.2897,1673.0211,1660.1061,1602.9863,1564.3131,1608.4305,1636.5043,1634.6011,1623.435,1537.3328,1571.8895,1624.0989,1611.6245,1601.7275,1622.048,1633.4537,1642.9495,1649.2322,1659.6555,1667.876,1660.0745,1642.3004,1622.027,1635.6361,1663.612,1690.1765,1707.4211,1688.8643,1731.9406,1831.5847,1873.2959,1885.1392,1893.7622,1906.5782,1913.4883,1910.3005,1899.5695,1880.0365,1848.8763,1863.5193,1920.9166,1922.9032,1913.6904,1901.3136,1879.6108,1866.2338,1855.673,1848.2323,1841.8494,1841.431,1834.5585,1858.9056,1948.6456,1967.2191,2007.6226,2014.0479,1996.9485,1990.3275,1980.8818,1969.944,1965.3082,1975.7758,1927.1226,1947.3483,1976.9147,1988.5598,2015.0881,2025.5171,2048.8071,2048.319,2021.35,2002.793,2023.1925,2012.4794,1967.3002,1746.9153,1336.5548,1158.8116,1211.4642,1119.324,971.02325,1003.8863,1136.8234,1231.1893,1532.7605,1696.6423,1595.8541,1442.8451};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {1244.1147,992.9094,993.0336,964.8493,820.43365,1177.7739,1300.0808,1267.2089,1129.6108,1353.5906,1322.7068,1331.2167,1561.0824,1598.6412,1554.0145,1522.3043,1499.4994,1415.0297,1397.0071,1400.9211,1357.9875,1328.662,1333.2238,1345.9026,1370.0104,1373.486,1375.418,1386.0283,1390.1747,1392.2975,1393.9932,1367.389,1353.1821,1347.9763,1346.9565,1368.5897,1402.338,1405.0883,1423.2803,1491.2074,1498.3868,1516.8995,1491.6226,1472.8588,1494.5093,1491.0255,1475.6932,1469.2638,1462.794,1477.028,1506.0151,1557.3838,1560.1387,1558.2798,1557.848,1560.5739,1562.8113,1566.4744,1589.5006,1572.5896,1547.4612,1556.3005,1580.1575,1604.5137,1610.1938,1579.9238,1612.8923,1653.3271,1655.4492,1711.4633,1791.6941,1809.1228,1793.2482,1842.333,1849.0785,1839.3691,1830.2137,1801.021,1816.8816,1830.6119,1845.0717,1844.2671,1840.3054,1850.7411,1852.2611,1816.9323,1785.9651,1776.4845,1739.1787,1743.9844,1708.354,1712.022,1874.3108,1883.113,1883.0372,1874.907,1887.7177,1919.4038,1941.6465,1963.8967};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {2025.282,2008.2489,2113.224,2194.2097,2160.4397,2029.2972,1935.9333,2038.355,2104.8884,1800.7164,1611.9751,1548.4441,1460.8268,1367.6864,1577.8496,1465.0537,1057.621,1132.9254,1302.5236,1044.1436,998.4472,1104.8806,1162.422,1020.733,1125.5243,1654.9208,1903.1155,1828.8351,1723.6139,1546.6022,1273.3298,1184.9829,1284.0247,1609.4026,1750.7188,1355.731,1224.924,1295.7935,1247.7056,1406.4506,1643.373,1811.7998,1730.1394,1559.0829,1486.4072,1403.8843,1483.4257,1437.7467,1328.9873,1294.4823,1288.0219,1283.0731,1315.1431,1337.4946,1308.1902,1347.4628,1362.5532,1366.187,1351.1163,1345.4327,1361.8198,1370.4487,1387.4133,1366.5308,1414.1283,1403.1946,1373.6625,1365.1744,1380.3783,1399.8951,1398.0474,1398.2261,1406.259,1418.5363,1426.1024,1432.5958,1444.9791,1459.7223,1468.9207,1473.2375,1468.6508,1466.8013,1460.2654,1449.4237,1435.5166,1456.0885,1434.7906,1434.6948,1498.3169,1624.8354,1676.8416,1678.477,1624.2535,1511.3384,1439.6053,1482.8226,1429.9653,1459.9679,1554.8547,1651.3641};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {1654.5111,1643.7603,1649.6677,1643.9119,1651.7773,1591.0614,1512.701,1643.7877,1737.2006,1768.7196,1712.5125,1658.5151,1667.3972,1767.3408,1709.1034,1683.52,1677.9772,1664.4281,1633.1654,1611.4265,1850.728,1888.059,1954.4164,2003.1865,2069.2283,2085.6055,2113.6377,2177.3896,2175.3872,2072.3071,1923.9746,1749.188,1544.8229,1290.6001,1019.93427,1055.535,1412.0897,1511.4952,1602.3966,1474.2926,1107.891,1203.4865,1114.678,1040.4067,1171.2556,1150.2148,1136.3713,1335.7667,1059.9408,1039.967,810.07007,934.50525,1147.2067,1216.6061,1421.6123,1642.5901,1564.4542,1315.1072,1208.827,1294.0065,1485.8756,1787.9001,1602.8185,1344.9941,1412.1012,1437.9681,1576.1654,1847.8828,1859.4016,1830.8351,1761.8844,1669.4509,1621.2544,1593.2955,1589.7133,1571.1028,1386.2194,1284.3346,1245.3778,1222.1124,1199.2047,1172.3734,1200.7468,1255.9492,1298.6542,1298.8353,1303.6064,1315.9224,1323.0275,1317.1957,1319.8345,1292.2377,1339.6227,1362.3953,1376.499,1366.4542,1365.9923,1365.2391,1355.7252,1330.8074};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {1323.3945,1327.092,1340.7518,1345.8462,1348.2587,1346.7539,1344.7604,1332.0426,1333.5768,1321.5723,1317.2035,1306.0209,1316.3453,1360.2576,1387.8916,1438.137,1485.6478,1528.4795,1572.9586,1542.9861,1475.8606,1469.47,1417.48,1299.7235,1355.4694,1459.6781,1421.8844,1493.272,1501.5573,1496.5793,1497.2959,1532.837,1559.9834,1575.5133,1531.7799,1520.4072,1529.3291,1520.0162,1540.0559,1533.8506,1532.5508,1559.3927,1615.9902,1680.0736,1734.6409,1789.9037,1808.7383,1737.6327,1850.2922,1862.8563,1970.6572,2134.7883,2229.022,2198.977,2136.6,2183.7349,2284.9805,2190.6243,2234.8887,2293.7673,2280.4592,2230.6426,1949.2333,1656.3846,1583.7948,1597.1849,1646.7495,1370.8544,1131.916,1313.0759,1330.3716,1472.9276,1488.8673,1110.1895,952.4682,1457.923,1767.5033,1446.4894,1010.82764,1143.573,1756.0613,1754.9547,1527.6035,1391.5851,1204.7623,1282.256,1467.5293,1723.6339,1689.019,1608.645,1447.4854,1530.442,1550.5321,1572.1733,1626.595,1657.1566,1667.1166,1701.999,1702.0198,1630.953};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {1593.6466,1543.2296,1483.1245,1402.0741,1305.2875,1223.3186,1181.1116,1169.9537,1177.0797,1194.8636,1218.9391,1234.8834,1223.1421,1218.1257,1233.1278,1232.2117,1231.9744,1244.4095,1258.529,1269.5133,1276.0686,1286.2489,1287.4714,1263.4382,1258.8352,1251.8048,1245.1702,1237.2874,1236.0243,1252.8771,1230.473,1244.6277,1277.0707,1293.5494,1289.9341,1296.3542,1305.1136,1307.2609,1308.4049,1305.3639,1305.2548,1323.8427,1338.2379,1358.8118,1374.7488,1396.486,1456.598,1469.8422,1454.1013,1418.2035,1330.2504,1270.4761,1316.792,1386.0024,1361.5293,1426.845,1470.4469,1502.1837,1477.7881,1462.1644,1470.7994,1490.9716,1489.1559,1505.967,1545.1989,1458.9175,1487.6821,1531.0614,1518.2361,1528.908,1657.0636,1784.4635,1868.2618,1961.8483,2112.2385,2037.9244,1756.6035,1939.3043,2114.51,2290.4163,2267.8445,1842.452,1433.4615,1914.4082,2173.6726,2264.1858,2172.5637,2280.3867,2187.249,2054.9573,1694.3865,1520.2529,1691.3916,1769.3057,1780.6233,1652.8322,1643.9425,1721.2565,1698.3259,1619.3696};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {1913.0627,1735.8541,1739.8007,1793.8717,1813.9255,1801.1564,1367.7554,1239.1039,1731.0442,1818.8672,1819.1553,1836.3291,1736.7609,1773.0054,1787.3442,1801.452,1651.633,1705.4456,1590.085,1371.463,1371.044,1336.4722,1285.4235,1302.1173,1350.7744,1472.6742,1543.257,1462.3805,1345.4614,1253.4448,1212.789,1161.9064,1133.3683,1145.9335,1195.3622,1204.9017,1187.7153,1181.9214,1173.7252,1165.3622,1161.9105,1159.1381,1177.2816,1175.9368,1171.4485,1182.4159,1188.539,1200.6534,1208.4213,1205.7892,1217.6948,1229.9979,1217.0312,1223.7936,1244.243,1259.8795,1247.8295,1240.6456,1252.0012,1273.229,1273.0813,1266.5143,1270.5638,1272.2678,1265.9335,1280.786,1320.1797,1380.6644,1368.773,1380.6569,1438.1554,1481.8275,1430.083,1491.9867,1543.0771,1557.2249,1555.9235,1630.4229,1668.5278,1679.1736,1699.7118,1773.9176,1806.1425,1813.9675,1805.5502,1731.4672,1707.5712,1664.613,1552.8854,1515.4861,1463.3691,1458.9226,1547.3763,1583.7263,1612.9832,1603.3473,1597.7229,1566.3688,1641.5039,1690.1807};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {1630.7838,1532.2434,1655.5593,1690.272,1709.3867,1675.8862,1900.1293,1955.0051,1999.7018,2037.1544,1926.2009,2010.8575,2094.9358,2147.7073,2148.9736,2238.6455,2259.8684,2187.7666,2136.495,1658.5396,1268.042,1688.3302,1877.5197,1864.8043,2200.6787,2310.0085,2289.2742,2279.2305,2168.1655,2129.1875,2058.808,1736.4502,1578.5536,1950.5271,1929.0078,1816.7667,1856.3877,1804.9668,1145.5586,1329.7858,1232.7135,1263.6519,1327.1134,1219.492,1290.789,1321.9823,1352.8953,1261.926,1229.7281,1157.3196,1094.4138,1124.9558,1134.5028,1147.3086,1219.6796,1227.9342,1178.0747,1137.1991,1131.8284,1119.9308,1131.6255,1149.6147,1163.868,1180.4958,1166.9495,1150.3074,1135.825,1130.2465,1131.7396,1129.1654,1124.1346,1128.523,1126.6194,1138.8141,1164.0614,1196.1116,1223.0527,1258.7145,1287.8317,1273.3728,1274.8746,1289.0754,1292.3185,1262.8298,1418.2614,1425.5645,1410.6207,1391.6344,1367.8094,1350.6144,1367.1832,1221.5099,1289.8319,1535.2095,1553.8492,1548.6255,1555.9836,1596.3455,1613.406,1598.5837};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {1607.4996,1595.5071,1632.8976,1643.3926,1658.9962,1682.564,1726.0424,1795.5292,1797.3407,1771.8898,1761.7676,1755.6649,1771.2828,1763.5571,1748.1504,1737.2777,1720.9932,1672.7816,1668.4373,1678.2181,1654.2246,1635.2794,1617.3655,1639.0111,1663.9073,1739.0088,1656.3732,1647.4261,1620.885,1551.036,1587.1348,1595.48,1588.405,1531.0568,1633.5066,1703.7798,1754.2804,1855.468,1862.9115,1854.6455,1815.5864,1887.0072,1938.903,2042.4161,2183.3445,2021.825,2001.2578,1884.8037,1711.6324,2004.6776,2209.45,2080.2732,2256.193,2262.4834,2236.8193,2249.51,2235.0955,2153.3782,2108.4587,1765.4847,1669.38,1655.6919,1520.5133,1603.2887,1601.3225,1531.032,1451.1259,1465.903,1419.1569,1284.1036,1140.7222,1107.5701,1105.5294,1116.5616,1160.2688,1186.0298,1168.2943,1180.2908,1203.0981,1229.1268,1237.9059,1123.5983,1126.6981,1173.09,1126.8209,1107.8635,1106.8997,1110.5175,1117.8628,1119.5085,1129.8822,1142.6395,1167.2703,1181.9777,1179.7318,1143.1846,1119.5132,1101.3531,1109.2656,1129.1843};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {1150.9227,1163.5532,1203.7744,1296.4402,1367.9381,1436.473,1405.6642,1353.1891,1380.7015,1447.506,1453.2078,1394.7231,1479.0598,1515.8994,1601.6406,1549.377,1432.6036,1452.9231,1506.7139,1457.0913,1483.2784,1620.357,1723.7385,1687.3352,1592.6348,1608.0011,1634.8889,1691.0834,1711.1783,1701.9893,1725.5823,1738.9292,1795.3569,1783.8389,1726.6157,1710.548,1701.2806,1698.4733,1684.2725,1603.9598,1573.2954,1530.0121,1598.0964,1623.9966,1579.9783,1569.7831,1519.3802,1478.1522,1553.968,1590.0372,1599.9163,1422.4528,1523.6838,1570.0747,1545.7207,1550.9773,1558.7675,1548.3605,1539.4563,1557.2396,1485.8876,1475.3773,1478.6105,1508.7035,1527.6871,1585.283,1582.5757,1620.9136,1633.7322,1569.0863,1733.3176,1777.3229,1792.6995,1749.3926,1758.2642,1782.408,1847.6844,2018.0094,1967.4285,1959.1602,2047.413,2008.7881,2029.856,2034.2092,1959.8396,1511.0734,1477.2571,1464.8812,1385.1459,1403.4669,1304.2761,1315.332,1433.5835,1350.9252,1277.9967,1211.3733,1144.5363,1079.8778,1053.5955,1044.7853};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {1037.8121,1026.6028,1001.42,1010.31305,1007.0873,1014.3918,1014.32684,1042.3099,1056.6006,1073.3243,1079.9679,1083.8972,1096.2063,1110.7926,1115.5178,1108.1532,1117.2155,1127.1573,1137.5541,1135.4315,1139.5817,1147.819,1188.9354,1252.2072,1228.0623,1169.6035,1146.4885,1180.743,1249.7681,1385.2952,1435.2692,1388.2831,1397.9664,1438.056,1429.1139,1428.3619,1461.3397,1483.2932,1518.6609,1567.9114,1607.146,1658.3861,1683.8848,1658.2402,1595.083,1592.1683,1580.9667,1571.5433,1603.4274,1647.6031,1618.7002,1555.8087,1476.9248,1622.568,1677.2302,1659.1862,1630.187,1618.2994,1605.9259,1592.5615,1575.7195,1555.5292,1613.9816,1590.9744,1393.7565,1505.023,1598.3934,1411.359,1493.3258,1517.8547,1531.1672,1478.8971,1473.1593,1505.9949,1486.8826,1463.5187,1488.7811,1496.9666,1480.865,1456.1564,1492.6448,1605.4584,1585.3042,1566.7405,1559.3835,1548.716,1566.3712,1590.4763,1489.6295,1484.3334,1480.1068,1467.3344,1448.8419,1490.9503,1487.9055,1495.585,1525.585,1592.5814,1718.4857,1789.8267};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {1793.5966,1648.3267,1648.1675,1527.386,1667.251,1838.2327,1996.1893,2084.2385,1874.254,1825.7213,1721.5696,1621.8289,1637.4061,1540.6045,1604.5504,1577.4452,1457.2524,1280.9294,1231.8754,1199.9628,1188.4712,1167.4384,1068.6583,1023.4041,974.9687,965.43805,970.6498,958.2442,944.3644,948.78723,949.98315,953.0145,962.18475,968.7887,993.1544,1010.2767,1018.14923,1028.5499,1053.4465,1061.3904,1068.0195,1071.2157,1070.0928,1075.6667,1103.0498,1104.6571,1090.2021,1108.9402,1138.1543,1141.3367,1161.6318,1219.2811,1148.5281,992.1226,931.5885,912.28015,920.5866,1104.7983,1365.6506,1286.6631,1237.932,1255.1798,1347.4478,1416.8073,1492.969,1549.6993,1559.91,1631.9775,1727.9218,1770.8699,1729.4966,1708.87,1592.2726,1603.3707,1692.0513,1619.4524,1593.2178,1561.2505,1479.5104,1459.913,1551.9371,1621.575,1544.1934,1558.0128,1496.2163,1451.4456,1439.1001,1483.979,1494.6766,1506.6018,1554.6669,1544.9833,1464.5177,1544.9498,1610.7152,1562.5798,1554.7394,1540.4697,1550.5057,1527.0233};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {1519.0591,1522.8618,1491.7494,1466.4702,1418.1703,1359.1781,1311.3745,1305.4318,1394.3914,1420.0707,1494.0553,1538.2268,1528.0267,1541.3508,1556.1444,1571.973,1513.2205,1499.9222,1491.9971,1475.766,1462.957,1484.6685,1518.7611,1493.9397,1557.7847,1581.21,1622.0797,1667.2244,1605.8616,1466.0518,1143.4697,1081.5642,926.38477,839.8602,1076.6052,1304.7732,1442.2444,1474.6528,1713.8993,1628.2151,1589.7081,1510.2252,1552.7454,1413.8765,1269.0962,1081.0107,1208.7402,1162.9954,1038.6464,1008.2125,1036.2429,998.61725,949.05096,947.4595,931.2168,925.5438,907.4481,905.5368,915.3524,914.65015,914.78827,919.6853,926.2137,970.3867,995.44495,1019.7493,1025.3901,1038.5936,1018.2895,1017.45526,1016.13574,1021.8344,1024.468,1078.7577,1081.8567,1061.9497,1071.443,1067.1284,1067.0854,1091.722,1093.5758,1101.2205,1056.2562,1003.93195,1041.707,1049.3099,1083.7072,1100.8136,1078.4039,1118.4993,1238.5251,1341.0463,1452.9996,1566.2421,1635.7838,1684.4651,1702.5708,1682.0603,1543.8524,1434.9048};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {1410.7552,1548.2899,1743.4679,1772.0253,1665.8695,1658.5698,1675.5978,1532.1324,1506.7833,1505.6047,1508.3994,1438.4452,1361.31,1411.9705,1461.8325,1484.1132,1482.593,1497.2726,1499.7474,1524.2047,1520.6617,1566.5144,1546.1006,1460.1791,1367.1646,1373.627,1485.5833,1518.6217,1510.5104,1428.8676,1420.9626,1480.8239,1444.3668,1474.6951,1401.741,1359.628,1320.3202,1543.346,1549.7479,1521.8346,1466.8512,1480.4401,1490.1504,1496.6813,1471.2151,1472.4542,1474.3435,1466.0923,1469.2234,1513.0128,1598.1108,1648.6923,1705.3823,1369.1985,852.97974,476.80447,193.17996,22.843357,300.62592,407.85025,356.3079,258.9432,157.7163,113.10267,135.80339,295.1244,534.89777,1022.0363,1618.662,1492.8724,1342.4352,1078.957,1051.3749,1065.5697,1031.4253,988.0529,990.01355,973.1093,916.87726,934.1263,921.4624,895.10693,906.24927,908.0486,897.8728,886.1985,886.8157,882.1231,874.0879,870.3652,901.6267,915.48096,928.32153,947.16235,979.908,1017.97906,1044.5255,1008.4954,998.1965,1026.6707};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {1098.2754,1258.0254,1342.541,1239.9624,1132.8993,1102.617,1062.0114,1029.0812,1019.2191,1021.6151,1007.44275,1013.98004,1007.31665,996.0416,999.718,1040.0892,1032.5677,1113.0856,1211.4204,1306.2749,1423.915,1440.7379,1308.4967,1264.3641,1234.6696,1243.4757,1272.1853,1378.3779,1553.6838,1599.179,1572.8191,1585.5347,1628.94,1679.764,1594.0837,1486.7067,1411.8392,1339.1182,1334.6876,1375.6162,1423.2567,1606.1544,1658.6919,1650.1941,1629.0284,1573.2672,1574.8208,1535.4993,1311.5511,1477.5684,1559.9254,1463.875,1392.2207,1407.012,1427.3136,1434.7041,1417.508,1413.7819,1348.5398,1168.2389,1045.2681,1075.7583,1103.1196,1147.5055,1201.8885,1381.4299,1301.4033,1119.414,977.02106,1179.5504,1393.0801,1465.1907,1453.4045,1449.4248,1444.2797,1471.3811,1514.0259,1558.6171,1663.4155,1565.9847,1538.1903,1232.959,359.28192,258.23608,184.59807,112.41878,432.42648,487.6319,373.78876,309.05646,198.64001,140.82863,88.66022,-8.753863,-47.42497,164.67807,1080.2327,1399.0918,1434.9053,1222.1371};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {1085.0282,958.78754,898.5103,923.23206,933.1836,914.85223,902.85486,910.7659,897.6802,879.3287,866.0901,867.71027,867.9074,856.5993,872.31445,864.4437,885.738,868.2719,910.0682,918.19476,923.103,963.9963,1036.7805,1087.355,1255.1986,1318.7307,1333.3162,1217.8876,1085.2513,1112.7489,1057.9305,1013.3466,997.3343,982.461,989.0558,995.1174,996.3351,1022.4598,1039.1631,1140.789,1228.5115,1209.9508,1182.2638,1181.4475,1149.0029,1160.1393,1179.302,1188.4335,1246.0212,1246.4146,1113.1665,1099.6276,1077.6018,1054.4135,995.63275,1183.9211,1529.562,1671.7828,1619.0673,1655.5999,1669.2966,1708.5846,1677.2574,1553.8702,1419.7434,1371.773,1413.1781,1475.3242,1730.2872,1891.2936,1860.8877,1863.5206,1831.2498,1697.7721,1563.265,1519.853,1528.1498,1527.8975,1507.7885,1485.0016,1465.6731,1345.5084,1239.4407,1269.2573,1426.906,1399.7241,1160.5547,967.35095,941.5425,894.1501,876.97015,1054.8656,1215.6484,1148.4037,1311.2806,1300.0177,1153.0996,1042.0065,1280.2809,1276.2649};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {1493.074,1468.1482,1463.7877,1480.6385,1543.5342,1605.093,1737.8492,1710.4772,1590.8442,1303.2787,644.26465,324.0093,215.00528,212.25748,44.74611,-2.13767,165.86325,174.4422,194.75447,198.42648,177.34123,266.07684,474.12894,901.8739,1298.3607,1419.6517,1235.5187,1112.5553,1042.8909,975.28046,940.1251,933.58405,920.0847,904.6949,881.35504,875.97943,885.8383,904.9697,894.45123,891.464,863.1393,846.92224,870.1858,876.2217,902.4765,920.28973,942.79486,987.22784,999.4819,1027.2147,1110.4832,1192.7516,1221.8538,1295.8705,1073.1903,863.18585,888.85077,896.0531,880.9952,902.88947,976.69257,971.79285,973.6668,983.6282,985.11865,989.5862,1004.1878,1042.3083,1199.0472,1429.4646,1445.9159,1363.2977,1315.7828,1258.2961,1252.6216,1276.578,1256.4014,1286.5164,1381.7048,1336.7218,1308.8628,1167.38,1085.4272,1230.167,1584.6353,1419.3243,1128.3398,1034.3915,1265.7665,1731.3633,1870.0101,1846.4305,1825.4598,1852.2217,1915.669,1966.2163,2041.5525,1988.2876,1965.3732,2158.3027};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {1998.069,1864.48,1785.8196,1702.0804,1616.1886,1535.1698,1491.1779,1467.7225,1390.3046,1246.9443,1197.814,1224.548,1321.688,1278.7123,1239.4691,1215.2466,1267.763,1201.4999,1292.9692,1419.1244,1425.038,1302.4944,1303.5753,1338.3923,1311.0862,1211.8727,1039.6852,886.3104,1205.667,1023.17645,1071.9861,1325.7988,1550.6877,1723.5217,1814.956,1826.1017,1745.0176,1691.557,1594.6207,1443.6139,1192.5798,909.5072,616.22626,626.8565,699.50775,786.81683,290.90378,-436.32278,-329.4751,45.17889,1270.5767,1696.3514,1535.7009,1243.1095,1035.4279,943.80865,972.54974,949.17737,905.6398,891.5943,891.8658,887.5733,830.6069,819.80634,836.0754,897.5939,896.63763,872.82056,863.4808,836.41644,839.3364,847.4423,877.4703,979.6574,1100.7188,1183.9618,1209.5442,1145.082,1054.0651,1018.618,1027.8771,1083.0626,1057.9625,951.94257,922.9617,929.94135,935.81647,972.27686,1020.59784,737.1185,965.82104,1007.2494,1011.758,989.856,988.1767,1002.7516,1370.7968,1676.6053,1600.8417,1521.6168};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {1454.5151,1365.2406,1307.6766,1374.0615,1414.195,1427.692,1378.3977,1335.8474,1296.3198,1321.0217,1347.0756,1475.0042,1479.1526,1471.2832,1451.4172,1343.8485,1476.0347,1786.3839,1898.0042,1861.8798,1852.3303,1855.9763,1931.714,2033.7579,2070.5847,2051.9355,2064.8174,2237.9082,1895.4706,1528.7759,1525.0405,1212.7941,1343.306,1408.138,1430.7234,1440.746,1469.4768,1490.4116,1422.5035,1377.2452,1390.0963,1378.8025,1306.782,1443.1188,1344.5897,1270.1677,1267.3505,1254.6013,1342.3168,1344.5941,1179.9823,1079.7334,1200.3109,1237.6637,1038.9413,816.78754,12.304226,-15.464429,-104.922554,-20.368189,810.911,1691.2739,1554.4355,1651.4988,1600.0854,1407.1732,1329.3373,1404.6959,1643.7965,1074.8717,400.39752,553.8973,1010.7532,909.75995,1056.3135,785.6988,664.76337,900.2875,1376.1262,1187.4746,1083.7809,966.86475,934.8049,928.2379,936.85254,918.0373,872.6309,875.1535,937.3445,1008.6131,1045.7056,998.33344,1002.56586,974.45026,950.6921,979.3746,921.5663,880.22644,860.06287,890.49};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {1004.6803,1124.1832,1184.1266,1261.3523,1198.536,1081.1162,938.7444,912.613,914.9419,915.89276,936.89014,946.51416,944.8183,950.7336,967.5632,997.5301,990.1897,1027.8805,1067.7106,1029.5372,1043.3584,1020.7109,1114.9775,1431.6084,1646.3391,1631.6655,1591.5087,1607.5615,1549.2976,1482.8158,1452.9662,1390.2435,1476.6897,1443.0743,1370.3942,1342.9142,1360.348,1385.6134,1262.8538,1314.6963,1430.5068,1431.0471,1462.3813,1449.8317,1445.5359,1459.065,1458.3005,1418.5286,1414.5393,1445.0195,1568.7078,1657.0942,1652.1869,1686.4277,1685.8336,1714.727,1591.0912,1265.7312,1182.1049,1210.816,1179.2817,869.06665,738.67914,737.16644,953.9692,1396.8323,1425.8295,1420.7817,1403.1086,1458.4843,1474.1243,1456.3412,1496.9032,1554.51,1581.1605,1536.8342,1592.3208,1518.9354,1501.3523,1490.2604,1417.0314,1391.6766,1429.4019,1214.103,321.81384,273.61703,236.72636,480.90356,1098.2523,1573.6934,1365.9603,1236.7478,1245.4419,1327.2717,1249.6888,1249.2263,1294.4376,1253.7996,1034.2325,1059.5857};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {1195.5143,1111.5487,1066.7747,1070.7833,1037.2694,1054.8865,1038.6349,974.921,979.7987,974.05164,936.9246,917.29626,939.0799,921.9591,888.3694,878.9776,894.2956,850.3037,866.06104,910.93164,932.4524,951.57874,969.9482,1092.827,1066.6718,1048.8828,1107.7095,1096.7968,1085.2709,1049.3445,998.8057,922.29626,934.26025,950.525,897.6443,867.4577,874.5928,893.163,900.7855,892.3699,940.349,988.60114,1095.0037,1330.4706,1271.981,1364.8074,1426.7046,1470.6394,1393.4155,1397.6659,1495.9543,1535.4368,1547.3508,1550.1803,1570.7074,1545.8752,1521.5277,1514.8688,1538.8698,1530.485,1546.6649,1440.8115,1349.3776,1297.7683,1304.022,1308.1312,1361.732,1343.2347,1248.7275,1035.7711,1129.7925,1265.934,1029.0406,832.387,1187.7661,1521.2389,1534.8672,1600.5878,1686.4708,1725.2998,1681.494,1634.8534,1643.8243,1588.6367,1639.6407,1667.0361,1272.5691,1009.1994,708.4954,667.67487,680.2419,903.518,1228.0828,1612.3999,1566.6257,1536.0526,1565.8679,1658.046,1747.8392,1793.3131};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {1777.782,1773.5066,1754.7394,1777.4518,1805.3689,1761.8451,1686.491,1547.4136,1451.9296,1374.6783,1348.3881,1339.6915,1383.9257,1465.4766,1443.856,1433.5496,1378.4231,1323.6733,1282.2035,1234.0706,1236.9867,1254.0286,1287.5865,1294.8461,1270.2975,1221.0116,1165.0286,1146.67,1111.6226,1066.5631,1059.5361,1070.2714,1072.4056,1068.0394,1017.5377,988.69006,941.6082,924.17267,934.8769,932.1138,924.17804,945.1416,945.69214,933.0299,935.6055,899.0973,900.91907,908.07526,881.41046,953.6334,856.48016,939.5102,987.0877,1056.2445,1304.4387,1250.6984,1161.6274,943.6999,806.5055,843.69336,880.74097,879.41956,826.22314,878.93414,883.75867,911.9719,901.0718,965.1751,1134.0392,1183.0314,1433.2017,1371.8813,1467.9185,1481.3281,1410.1376,1386.3254,1359.5409,1453.6497,1381.6318,1370.973,1413.0598,1398.084,1376.977,1444.4261,1523.9633,1565.6357,1469.8041,910.6344,1203.6139,1563.9813,1226.9735,1257.8656,1209.3145,1158.4535,1074.3065,1032.7183,639.92676,790.33014,1047.8207,1165.2462};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {1182.6005,930.8623,837.7449,1278.2026,1736.7878,1766.775,1889.4413,2037.628,1982.677,1845.2449,1800.0151,1748.6584,1715.6046,1648.2809,1545.5941,1571.64,1706.3148,1729.7047,1263.1874,1089.5276,1237.8531,1909.9515,1746.3623,1742.3484,1685.3209,1699.5806,1758.8586,1750.9033,1674.6644,1648.6387,1619.2216,1660.2993,1743.9325,1773.0985,1620.4741,1521.8887,1442.1844,1368.869,1364.5151,1432.6995,1333.8773,1345.942,1419.7678,1439.8019,1335.117,1300.8163,1262.0823,1277.4575,1299.0538,1331.8936,1288.7532,822.9703,1050.7754,1307.0834,1230.2441,1173.5393,1125.2874,1085.3359,1082.5564,1035.6877,998.4413,1027.2655,1030.3822,1064.7217,1083.2367,1108.3634,1068.0569,992.8551,1062.5363,998.28357,968.4441,940.8693,933.05475,942.9925,933.0478,909.3228,963.4091,862.13165,815.7997,799.95514,843.149,972.7546,1327.5076,1317.895,1147.5079,973.68024,831.0681,841.2403,896.74414,856.2211,823.10596,851.5013,872.8051,940.0005,1147.0322,1239.699,1379.2916,1517.3356,1532.1794,1473.7366};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {1338.47,1133.2152,1074.7744,1092.7002,1082.8951,1137.1094,1197.5621,1308.6317,1367.5629,1338.0399,1366.258,1378.0514,1412.8645,1428.2277,1475.6462,1418.0288,1491.1969,1485.5889,1381.4417,1265.7006,1139.1292,1066.6477,948.9059,928.2668,945.39453,1003.76056,1032.3888,1090.8829,1209.482,1162.1552,1164.4597,1581.386,1759.7623,1605.4357,1546.3153,1902.7185,2087.4602,2004.1885,1946.3586,1981.6045,1908.4698,1900.6029,1854.446,1881.726,1954.4591,1982.7806,1672.7236,1480.1932,1626.9751,1729.9847,1687.1073,1632.0442,1542.903,1561.1566,1616.3741,1522.4266,1461.1991,1475.9023,1394.1035,1402.6499,1508.0698,1667.3906,1638.685,1569.3759,1452.5479,1436.6428,1446.7571,1509.5166,1327.3046,1322.24,1306.0254,1319.564,1301.5298,1379.2258,1237.8607,1231.4775,1266.5077,1293.2734,1255.0787,1117.5975,1191.3308,1258.2587,1226.5752,1173.6553,1119.808,1084.46,1090.6782,1084.4408,1048.073,1044.3348,1036.1239,1055.4095,1056.0352,1107.4082,1067.7043,1019.9605,1118.5077,1018.69165,1002.1087,989.0986};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {897.72156,907.0706,919.1796,918.32294,905.42175,856.7644,854.0544,876.64075,916.43256,952.978,1247.0942,1340.0236,1256.0638,1120.2367,956.7884,836.61316,872.93,876.7825,888.8378,854.3575,857.4891,921.44135,1197.7418,1303.3833,1521.4285,1616.0098,1565.7026,839.9329,-26.822292,-314.84305,-312.36646,-321.6346,-198.96434,-19.528759,335.92648,848.49677,1385.7927,1408.2042,1373.563,1377.9452,1359.7156,1345.2952,1343.2058,1308.1053,1287.942,1285.9694,1259.3514,1223.9839,1125.4722,1048.2631,953.4895,934.19293,1063.496,1098.152,1124.335,1225.5034,1357.456,1461.421,1589.5135,1772.5266,1845.5746,1883.8191,2065.5686,2252.6753,2150.703,2086.3093,1709.4908,1660.2698,1892.8048,2035.2319,1993.3009,1939.6675,1867.3462,1844.3517,1834.3185,1838.109,1715.6033,1591.8759,1522.4729,1472.0654,1413.929,1463.0537,1502.9905,1432.1505,1383.6713,1383.9438,1350.5911,1365.5858,1355.1748,1379.1134,1480.0133,1375.1855,1280.4004,1343.2478,1402.1044,1418.3833,1286.8591,1265.5356,1124.0404,1188.3503};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_42()
		{
			double[] value = {1428.479,1379.0929,1193.9043,1212.6412,1181.4952,1118.9719,1139.8297,1168.5408,1175.5509,1197.3644,1190.2495,1170.2551,1158.6162,1132.4664,1127.0272,1118.6938,1083.6403,1089.2612,1113.5077,1086.3674,1058.9231,1055.196,1049.3408,1041.6783,1036.4822,957.35223,955.6574,970.2146,887.4768,897.18933,919.5503,931.8278,897.4991,838.0414,790.02356,870.89795,1017.01447,1301.8618,1502.7567,1506.4115,1433.2974,1272.707,1187.654,1004.8182,845.5844,825.32324,863.70337,831.1847,871.64215,945.86316,1020.9723,871.9017,768.5095,578.0205,285.12418,-629.5878,-853.9823,-849.5255,-844.1066,-797.57837,-785.32117,-555.0781,-223.4102,240.59859,1039.5958,1589.3567,1435.8702,1309.415,1255.7422,1245.4692,1257.0974,1280.9657,1242.8446,1198.9274,1115.5356,1048.1154,1040.7078,1022.0419,946.9026,940.74225,1101.1449,1214.2551,1326.7113,1456.5189,1684.1208,1707.6042,1772.2473,1952.5768,1865.6974,1550.5166,1586.2269,1744.1401,2113.77,2209.1506,2029.8367,1937.9989,1943.2494,1983.2812,1917.5446,1803.9727};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_43()
		{
			double[] value = {1652.4735,1099.845,1094.3036,1620.525,1637.5669,1535.205,1438.2059,1392.7883,1383.0193,1389.4849,1400.7191,1372.8263,1370.6292,1355.1306,1357.751,1368.4893,1329.8151,1332.049,1500.4539,1483.9543,1224.3365,1242.6362,1266.6675,1235.4622,1321.7238,1293.4951,1318.3358,1384.6344,1260.0051,1201.6854,1199.9868,1190.7723,1187.9703,1180.7197,1168.9623,1154.0198,1120.1115,1144.4481,1153.5961,1159.2184,1156.7906,1158.7874,1191.0676,1206.492,1180.8237,1162.4835,1039.8977,1002.3819,1052.49,1069.5242,1039.2051,1037.7635,1022.8029,979.01166,986.0535,962.1877,948.52,935.8035,946.9223,938.22437,837.8925,810.1816,844.03326,1016.3338,1270.4082,1172.7363,1406.1855,1691.392,1554.503,1397.7985,1126.9932,822.9572,654.366,697.8113,806.868,764.1797,808.7385,916.7732,1131.0123,688.25195,200.80417,225.8071,27.688002,-636.6944,-819.39294,-836.46136,-848.10126,-810.93384,-770.526,-478.3156,14.518979,426.06805,1289.638,1685.379,1542.6821,1405.3134,1311.1443,1217.7013,1219.7246,1259.955};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_44()
		{
			double[] value = {1118.0947,1040.2144,1041.1155,1048.4805,1050.4679,1014.6052,963.9379,908.2775,1014.60266,1175.6724,1110.3176,1252.7334,1764.7872,1822.3145,1876.0326,1941.0452,1843.1774,1549.9034,1294.4929,1131.7103,1846.3398,2203.6033,1972.0177,1990.7544,1965.9113,1930.6328,1905.0205,1843.0703,1733.8588,1581.032,1501.057,1483.1835,1489.3035,1405.3223,1398.2384,1376.7767,1393.3876,1416.6432,1477.8408,1400.9193,1350.1146,1367.6537,1356.7883,1377.5366,1360.1636,1427.9921,1460.909,1448.5674,1298.2957,1281.8513,1258.8945,1199.4594,1349.5518,1205.2897,1169.1487,1178.5046,1221.0667,1267.8463,1217.7457,1173.6603,1148.9059,1140.5817,1122.9885,1094.1643,1142.0535,1171.4324,1158.5114,1260.1034,1255.756,1290.2494,1314.8458,1328.6699,1340.9977,1334.4512,1263.713,1187.5104,1211.5905,1140.3383,1121.7667,1076.2451,992.9124,976.4482,991.234,947.8335,949.8712,916.539,939.253,953.7714,962.1275,1046.471,1161.0671,1359.2307,1718.783,1834.3248,2011.8132,1759.5122,1341.2268,1052.177,932.28906,815.9052};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_45()
		{
			double[] value = {706.24023,726.2468,749.9937,789.88617,597.67285,929.2449,1076.9596,1156.6697,682.2743,502.23044,524.90466,287.86285,118.28251,-405.60623,-370.4955,-360.48563,44.53275,762.72906,1292.9137,1560.8684,1365.6594,1461.737,1862.2428,1527.9728,1349.8063,1291.0155,1231.7589,1240.6763,1196.4174,1149.8793,1083.6729,1060.8131,1067.4823,1002.5191,915.5996,837.679,809.7986,958.4304,1129.4536,1295.9888,1458.8021,1496.7516,1604.5106,1660.7797,1651.1433,1733.4734,1877.0049,2068.7158,2215.9817,2152.9473,2039.6101,2024.5048,2055.0806,2028.3187,1901.3514,1751.6307,1511.8951,1378.4014,1125.5868,1231.3999,1516.1982,1433.6642,1416.7244,1401.2573,1407.9392,1410.8091,1411.47,1377.7809,1347.1968,1374.3948,1368.0435,1356.1102,1371.808,1482.5834,1521.1888,1515.264,1450.725,1326.1797,1272.897,1261.2435,1291.4153,1164.0803,1146.6199,1149.5952,1160.8059,1486.2301,1403.1317,1245.9706,1192.0625,1156.5568,1167.2158,1194.7037,1240.167,1278.8818,1290.8134,1321.7828,1340.9662,1367.3612,1394.1168,1465.0559};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_46()
		{
			double[] value = {1493.656,1519.5754,1534.8668,1588.69,1592.481,1315.5046,1274.788,1244.3295,1174.7614,1164.3286,1202.6453,1202.5248,1295.1349,1252.9572,947.76215,965.07684,1025.628,1066.545,1120.37,1351.9312,1338.3156,1483.1913,718.1966,-225.98647,-383.42667,-153.67842,699.1419,782.1353,676.63763,630.9782,625.57947,631.5342,665.34894,684.30084,800.6272,870.7171,960.0912,1032.043,1080.7018,1204.4454,1232.2882,1205.9554,1190.3048,1268.0353,1362.4692,1511.1996,1309.0668,1163.6144,1132.7426,1154.1602,1249.4341,1164.195,981.7276,1149.8796,1175.4532,1183.539,1200.4525,1168.8624,1124.1498,1084.8234,1072.0623,1052.7443,993.2037,857.9171,752.1902,698.7162,741.4449,795.04224,879.783,1017.2322,1028.527,1037.3674,781.01843,1101.4084,1491.9048,1628.9495,1714.3807,1705.8313,1843.6053,2009.6375,1983.5756,1933.7485,1921.8676,1887.6444,1794.3474,1627.3256,1345.6338,1416.2755,1719.776,1598.5442,1448.7405,1411.4062,1389.5265,1347.4626,1338.9425,1364.4175,1342.2123,1373.7969,1459.0669,1437.3762};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_47()
		{
			double[] value = {788.51495,447.97195,991.8609,1671.7084,1531.9637,1478.2213,1452.3368,1443.4579,1548.7192,1477.7809,1391.7926,1393.8802,760.71027,1252.609,1333.1808,1275.5796,1229.6115,1236.8337,1279.574,1362.9758,1408.333,1420.47,1468.9192,880.0526,1139.2181,1489.6078,1488.3684,1589.6123,1608.4775,1710.842,1773.9137,1807.9832,1777.4945,1721.7118,1664.9669,1535.2131,1490.5817,1502.2737,1573.6405,1715.7815,1786.1208,1121.94,879.58484,958.2361,966.3241,952.0162,966.55743,1016.18243,1014.8453,1063.9889,643.8699,43.52964,-117.445724,224.36118,964.9131,971.5384,840.3793,735.681,638.60077,562.2811,413.39172,497.3611,611.81305,530.4559,598.0459,722.0806,833.46674,968.37714,1049.993,999.64935,797.33624,779.8683,1196.5524,1232.0327,1190.3347,1165.7104,1169.3196,981.5388,589.8219,975.15454,1137.6943,1130.2034,1178.58,1235.5912,1274.297,1318.2141,1262.959,1233.7903,1149.9058,1097.7874,1135.3317,1005.9249,816.50946,665.0158,633.3775,647.7459,660.51086,677.88544,699.43115,687.4324};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_48()
		{
			double[] value = {724.7826,963.2782,984.6277,967.59534,1039.9453,1015.8212,1405.6919,1886.6196,1928.7164,1965.7434,1995.7769,2067.8816,2153.5203,2160.4639,2063.0671,1889.4425,1894.2708,1826.1691,1702.5353,1556.2933,1428.3467,1388.2062,1372.9749,1365.9978,1365.0598,1405.0021,1430.3164,1456.9769,1190.849,1010.3498,1283.3287,1599.1238,1604.5063,1601.1752,1580.6693,1510.0972,1541.2609,1581.2756,1619.8025,1628.1626,1558.9636,1404.6768,1316.5461,1289.5526,1260.0914,1307.6714,1424.3553,1099.7441,1486.799,1561.6458,1615.3414,1625.0745,1492.4403,1275.7175,1610.8716,1724.3444,714.1142,1059.4574,2088.142,1597.101,210.06517,50.605343,690.08875,1732.0839,1686.9968,1726.9539,1745.0074,1726.297,1301.0675,778.509,754.43567,820.22894,823.1577,907.3656,942.82385,925.1769,919.6272,890.24585,932.4686,955.6389,978.00793,994.3035,958.06024,972.2583,889.90814,813.4625,756.4848,682.1978,575.4051,387.61557,233.24886,115.436104,127.94142,498.554,700.67426,948.2369,1098.2732,706.003,113.85408,148.50493};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_49()
		{
			double[] value = {653.71625,1247.8302,1291.1616,1331.2756,1076.1833,722.2887,850.4624,1027.1499,1112.6132,1100.7029,1144.1787,1175.0756,1234.8737,1277.9404,1079.3019,1108.9902,1151.0664,994.0688,1209.2777,1169.8813,1018.23,782.2159,599.2778,557.4045,555.73926,559.5756,571.7694,606.16003,754.0335,751.3732,721.8131,621.08356,693.4936,1011.6884,1213.3285,1292.9922,1425.465,1540.9651,1682.374,1717.9231,1764.5151,1719.2238,1592.3265,1544.608,1616.6666,1669.1583,1819.3323,1566.5123,1447.1438,1416.4976,1343.8888,1420.3943,1327.4226,1326.7104,1383.6324,1367.5474,1334.2136,1306.3029,1334.0576,1413.6073,1432.4296,1405.2103,1437.1069,1455.5426,1599.3926,1777.3945,1945.6447,2015.8839,1708.784,1543.7773,1425.9855,1325.3901,1297.7798,1344.9899,1408.0936,1454.6661,1534.3717,1580.35,1444.7577,1573.3385,1316.0408,1141.4796,1453.0201,1682.2062,1687.4727,1748.9167,1858.8234,1677.4965,1005.7096,909.18994,1255.4551,1694.2134,1587.9115,1598.6965,1650.3042,1136.9132,749.53296,709.69006,723.5087,766.6238};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_50()
		{
			double[] value = {877.3086,899.0148,896.2243,903.1637,831.3192,881.60126,787.66516,808.86774,917.66406,771.38226,349.2543,954.9993,916.40857,788.13763,763.9224,715.6266,564.5005,211.36888,101.930916,37.459183,27.95355,72.6684,270.88873,1004.12634,1257.5358,1093.7649,519.1769,651.5028,1232.303,1238.6288,1120.2443,953.3291,743.0183,806.4808,931.3571,598.2133,928.23535,1022.5076,1071.7773,1131.8667,1166.1575,1140.1044,653.82874,558.7132,-45.97941,-327.57303,-424.3108,-117.84422,786.3829,1018.9149,711.991,517.62616,554.96625,569.1348,603.3111,657.14514,716.5473,851.7174,919.8368,940.80634,1131.1821,1344.1881,1402.6157,1498.161,1506.0056,1404.7212,1224.0079,1325.0079,1222.2816,1168.2366,1322.8846,1361.4264,1426.8181,1411.3981,1467.5786,1290.2987,1482.9077,1665.3589,1686.2314,1717.9062,1685.3938,1483.4099,1408.2521,1384.6625,1353.7852,1383.7445,1363.165,1385.1249,1398.2751,1369.324,1425.546,1297.2362,1948.454,2375.9023,2702.6816,2212.0535,1511.318,1336.5656,1215.2208,1180.9049};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_51()
		{
			double[] value = {1181.8995,1209.5747,1251.157,1305.2194,1362.2937,1458.1521,1662.5961,1734.3927,1540.7983,1379.5531,1324.542,1260.5001,1321.9238,1283.4337,1225.0796,1554.9473,1645.3141,1760.0242,1815.0063,1523.6628,855.0381,801.33685,783.7083,727.11237,696.50446,684.522,695.9148,796.71136,867.80884,809.23627,770.9101,831.0377,814.27563,776.13715,785.2041,791.1221,828.6341,906.5415,844.6555,760.4662,673.07153,753.22723,647.915,220.67404,829.0832,648.7589,376.04044,64.0704,-41.21513,-38.887917,-44.562878,370.32703,775.50073,990.0442,702.08844,897.5623,1075.525,888.09094,702.56036,388.4675,242.27075,220.93614,266.13217,541.2164,696.6588,772.7392,894.4547,980.2545,979.42944,1009.472,1027.6571,466.08386,-842.15234,-907.6519,-933.3261,-759.4477,596.3879,873.27325,938.65356,867.07324,802.1017,849.3061,909.5324,944.27203,948.488,1046.7085,1241.8486,1408.4036,1390.9254,1558.9698,1746.4594,1895.1205,1927.4113,1444.3485,1073.415,1239.5892,1422.228,1361.3492,1447.0437,1355.1016};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_52()
		{
			double[] value = {1390.4474,1584.4553,1547.1123,1528.1306,1538.7681,1598.2653,1654.4733,1714.2952,1885.0497,1921.7668,1709.4805,1572.9293,1454.5111,1523.242,1444.8468,1409.3691,1383.4486,1384.2231,1389.1116,1359.7925,2056.4094,2499.3784,2017.4496,1368.9066,1200.2412,1103.0583,1061.8419,1039.0487,1026.9387,1007.8002,1008.0941,1022.35626,1027.7377,1009.7392,986.6998,1064.4944,1114.8962,1021.64496,942.8192,971.7737,974.61304,993.6939,1047.104,1203.2697,1425.2059,1728.2207,1856.8206,904.63947,684.6649,729.6778,742.7624,718.0257,723.65814,787.37634,804.5197,888.7318,881.2035,798.26184,702.9851,660.437,678.9948,689.79663,796.8974,814.5995,623.56586,662.4952,942.9623,731.3756,877.3497,792.1375,663.9983,817.806,625.3723,549.96967,423.35248,296.4247,207.42108,30.495178,117.123535,173.34552,238.9904,369.21426,529.58905,1009.8463,739.56195,137.21896,145.55334,65.6669,195.40973,117.41104,268.46832,412.47046,505.5713,498.88385,626.7741,996.08453,1543.4604,1479.4811,1033.1068,958.4619};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_53()
		{
			double[] value = {803.91736,692.99133,744.13226,620.9567,762.86365,1303.3345,1038.2783,737.99316,1069.206,1127.7799,848.3605,819.2943,1079.6727,1089.8704,1157.59,1221.8352,1276.6632,1387.9622,1731.7249,2049.0608,2162.1614,2193.0059,2122.3286,1959.968,1646.2753,1604.7671,1499.7792,1134.689,1110.5894,1555.8275,1593.7775,1551.7023,1519.4355,1553.2485,1572.0977,1596.5911,1680.642,1774.1443,1987.0377,1663.0607,1473.6884,1400.6377,1351.766,1317.5565,1331.1271,1331.8489,1319.9606,1356.7731,2155.473,1743.4282,1418.9075,1188.3745,1086.1322,1037.1837,1011.6052,1006.4207,963.86945,916.20874,853.0952,791.5576,788.785,744.9796,699.4108,718.6608,759.8359,738.19946,719.00775,715.2405,702.07294,691.96075,737.2558,929.1082,1225.2756,1458.7175,1238.8638,688.04584,674.33307,701.3029,1033.6326,1002.89484,887.76776,858.8088,933.1447,989.26105,925.61786,943.35486,876.3141,717.7713,685.0242,732.15674,797.7031,872.31464,867.48663,993.8199,757.52454,514.88,1078.001,1236.3448,1229.3524,1283.2683};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_54()
		{
			double[] value = {835.3898,335.3307,297.08334,345.4274,630.0385,472.33517,-120.98781,-46.025597,508.988,880.9934,1051.3278,1000.42725,291.59326,161.98466,347.66522,187.4297,280.00345,154.24777,313.6218,560.2764,395.73843,369.5664,545.9836,1017.3018,1460.885,1222.8644,503.64264,313.247,81.78865,102.35168,-11.876409,507.6431,1308.9062,1872.3846,1478.8315,1027.7178,1002.12946,838.9113,1000.8947,872.04626,1064.5182,1158.4187,1247.2574,1047.5905,1000.51385,894.8997,2018.6506,2209.6384,2255.4216,2224.573,2301.6792,2194.4155,1903.9182,1806.8468,1620.9819,1440.3015,1445.8093,1467.2709,1411.9514,1436.1602,1407.3958,1446.8196,1533.3529,1474.6533,1471.0708,1607.7551,1620.4758,1546.497,1475.1073,1364.0605,1341.9845,1412.6743,1383.639,1342.0818,1328.131,1411.973,1899.7281,1776.4525,1281.1072,1179.1335,1070.5057,1014.1599,951.95013,872.2772,869.7015,826.0812,753.8831,724.6239,717.8362,736.5013,718.94507,698.7332,698.07916,697.0502,703.08997,689.9661,686.1058,669.39484,641.10815,714.9149};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_55()
		{
			double[] value = {678.7477,700.5919,1088.1594,747.10156,708.7765,942.2032,1162.6449,1106.1675,998.5026,715.6649,898.4244,1086.4711,1049.0718,936.0744,826.20593,678.50305,654.11743,714.83813,771.3104,766.3536,928.3509,1078.741,441.24115,95.11487,746.8685,1174.6863,937.66876,1101.3513,1142.8086,678.00903,164.55998,253.2055,995.5609,-342.4588,-841.6493,82.13418,-307.9596,-229.8502,728.2972,1246.362,322.1357,219.49864,180.8446,236.85698,198.30716,569.70905,711.64557,1073.5724,673.00635,661.12823,864.1188,829.1174,341.73593,-263.57697,-619.28784,-53.299187,-543.60724,-956.39954,-211.59135,837.75775,1457.1305,1562.4019,1498.237,1320.9746,1168.4388,1151.5383,1264.976,1218.4584,1249.5319,1094.2327,1198.6816,1243.4133,1421.4447,1799.6504,2368.766,2431.0232,2170.9912,2111.1252,2062.4353,2122.843,2095.6843,2064.2112,1890.1987,1597.5479,1510.6122,1549.156,1543.802,1680.3861,1494.6727,1334.2017,1392.8225,739.178,939.97217,1610.6562,1608.6945,1584.5656,1429.4857,1272.43,1331.7555,1578.0554};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_56()
		{
			double[] value = {1704.4493,1725.605,1726.6534,1666.1471,1401.2191,1518.7565,1428.2974,1187.1173,1075.7314,1032.6615,948.98065,845.9968,779.7817,709.7502,705.0719,714.9705,713.44226,797.9334,773.11743,693.83105,689.508,688.94073,686.7679,663.9061,657.6244,647.81775,625.971,662.82153,647.2638,701.5618,825.3765,824.7946,932.26605,1114.9702,1095.0856,973.4106,1036.7446,1064.9506,1097.51,1131.141,1125.0807,915.69476,784.4073,715.19354,664.93427,641.9784,866.06024,975.1782,1220.6951,1264.346,1299.4248,1276.422,843.1401,-339.2411,-423.49008,155.99942,402.5945,873.93024,1213.4708,1367.9929,1502.7566,198.18127,-814.6527,-361.51776,478.09637,706.4348,1043.747,791.1539,376.69534,138.09152,394.5411,532.99005,490.5579,1645.652,2022.361,1269.1337,1376.7985,1483.027,863.8874,-86.50871,-689.7746,-280.77042,365.14606,1177.8706,892.65466,185.99374,242.83078,175.88945,323.60388,478.07114,890.9966,1341.9563,1293.1259,1295.9839,1358.5789,1287.1827,1403.7819,1562.2758,1523.7367,1367.142};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_57()
		{
			double[] value = {1376.2794,1452.5874,1673.1602,1737.4412,1891.543,1980.2307,1752.7303,1731.0972,1590.3605,1625.3999,1563.5614,1524.7712,1707.3754,1967.2179,1842.3785,1727.342,1516.9556,1254.8281,1325.4948,1487.9248,1536.2577,1490.4402,1561.1107,1512.4824,1506.3137,1256.3226,1181.5287,1292.3064,1896.2062,2221.6938,2151.7083,1760.0062,1182.1239,1442.9485,1509.1289,1438.4539,1291.1296,1124.6205,1005.071,903.3693,807.9924,699.93854,673.86096,649.20386,639.7112,662.827,683.2854,691.9608,679.19275,655.4331,653.31335,635.4362,616.7066,584.27997,615.1192,610.6457,624.30225,581.9375,549.9318,609.127,746.1722,962.02936,1003.6256,1301.5122,1322.7246,1209.792,1211.5085,1238.2534,1122.223,1031.9874,814.63605,770.82684,976.3847,1028.4758,1435.7356,1347.1492,1346.3378,1459.8882,1660.1256,1658.5615,1104.3248,627.85767,575.29834,1028.1593,74.4877,-530.2118,799.52454,2590.0615,2883.242,1161.0083,-653.6364,-923.28796,-853.7551,-205.60916,2062.5393,2006.8236,2316.7996,1786.2072,2154.0405,491.56815};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_58()
		{
			double[] value = {1001.14075,2621.717,1357.6547,-547.9211,-382.32156,-285.17422,-54.150024,-960.6355,139.18547,1173.0367,1252.6265,553.8227,163.92078,-0.209512,-114.90571,-63.169796,-46.65517,-207.35316,-62.465717,371.58633,864.63,1326.789,1407.4508,1345.7723,1405.8658,1554.5315,1505.0728,1423.391,1410.9622,833.36115,348.1182,91.425766,379.96884,1357.213,1638.6648,1673.9619,1815.3666,1759.7008,1674.6655,1563.7428,1555.7197,1892.0802,1834.0615,1613.0234,1389.2119,1202.0875,1193.1366,1262.8501,1288.0222,1352.588,1565.0892,1682.2745,1784.6759,1880.5562,1789.4966,1979.9381,2161.8052,2268.9536,2281.869,1836.749,1331.2665,1448.8218,1574.0425,1679.567,1719.6785,1691.2664,1638.0571,1423.3615,1181.5652,1049.5323,974.14856,881.0432,667.0795,643.7437,618.0708,637.8474,645.6483,634.27295,616.0964,608.00824,674.5973,626.3198,592.8401,619.5484,631.08954,728.5045,813.7173,837.8906,999.362,1401.6287,1485.7208,1461.3959,1571.5067,1504.6018,1496.7634,1539.8553,1599.3372,1642.1157,1555.0156,1541.378};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_59()
		{
			double[] value = {1196.6963,1371.6519,1313.4158,1369.8217,875.5618,728.0145,1192.791,1058.5898,566.3288,784.4866,1139.1317,1726.1394,1687.0643,109.32867,131.6343,261.06323,234.73875,-148.83904,-818.1978,-832.22876,-1119.3478,-850.8945,920.5368,-225.9787,-364.2302,-579.4546,-716.9142,-284.67618,1250.7761,1755.1837,1515.4254,127.26252,-772.37115,-70.59716,-53.13546,545.55804,1480.7069,1512.9946,1053.7324,289.8015,140.98653,237.47426,410.01614,377.59857,210.77518,225.88301,-104.289055,-328.73145,-308.86798,217.36028,579.48224,651.3768,712.16595,944.2237,1240.942,1049.9105,676.80225,-220.45847,-332.2935,-539.8015,-318.3512,-214.71852,368.78387,1335.4812,1684.5739,1628.0981,1592.3776,1566.7992,1523.7954,1586.0951,1616.8999,1436.5607,1419.0072,1283.2891,1288.2091,1304.024,1335.6896,1325.2051,1457.0085,1612.4196,1664.1514,1748.3369,1732.25,1516.711,1920.9293,1666.2317,1509.3295,1598.3322,1470.9991,1607.0078,1754.3196,1918.5635,2104.4172,2211.9983,2163.3306,1932.889,1640.3907,1313.4647,1040.7039,831.3501};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_60()
		{
			double[] value = {702.8366,718.7708,639.40576,618.73737,595.3754,585.6589,589.7743,717.615,973.2918,621.1217,642.8184,640.0271,1071.7275,1363.0391,1035.42,702.1937,698.71204,1165.9924,1973.6344,1899.7123,1685.9691,1377.758,1883.8284,1864.8052,1982.9795,1615.5295,1737.5381,2022.838,2003.784,1985.014,1952.8638,2004.2385,1074.5386,-137.68733,-578.64557,-783.92725,-724.58636,164.98164,148.29483,646.90985,799.8918,565.2451,-685.5568,-1071.1534,-799.0073,-785.22473,-1209.555,-582.93854,-9.138579,-559.6488,1270.2179,701.83685,-1116.9221,-2117.738,-2363.2979,-771.702,2099.0034,2853.0493,1657.5739,121.85596,-1218.4337,-1827.0432,-789.81885,478.4189,1289.108,1349.5413,1947.6948,1696.1102,1055.4971,853.306,1226.352,1237.0784,674.5888,341.6781,163.3821,-284.32465,-126.75788,-105.44269,42.14202,108.6663,305.01614,483.83112,710.76965,508.27325,348.24133,-413.39328,-445.43747,-397.43246,-371.7792,-388.88986,108.65248,1091.2323,1555.6038,1538.8857,1466.524,1491.6953,1495.9451,1593.0742,1427.7627,1013.6838};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_61()
		{
			double[] value = {1287.633,1559.0688,1521.4371,1492.4945,1574.581,1570.316,1577.2397,1561.047,1596.0417,1830.3287,1726.2753,1769.3057,1904.7346,1637.2611,1585.5621,1758.9655,1708.4633,1842.7665,1986.1534,2135.9263,2349.8303,2391.1016,2279.0918,1950.8595,1615.4165,1298.3673,947.12726,769.9425,705.12,654.7865,615.4889,592.1325,699.665,744.4556,789.0671,1010.2081,1073.5758,776.6164,768.4931,1140.2577,1871.8856,1749.2234,1799.1066,1658.7367,1401.1682,1708.3972,2097.625,2017.754,1893.3424,1725.7612,2195.1997,2093.4082,1981.6492,915.80505,1202.6193,2053.0295,1931.7584,1830.6113,2242.7104,2224.9495,1343.925,296.43817,-568.8974,-663.27856,-769.599,-93.12913,-272.29544,-643.99945,739.19867,1447.4177,-440.08038,-1711.9258,-1736.548,-1795.7935,-2211.6602,-854.75104,-255.53534,-1628.1736,-1850.6666,-2347.9307,-2565.402,-2635.8499,-2665.5637,-2400.3596,-2005.6842,-1798.6825,-2029.122,-2015.1897,-2148.3494,-2548.499,-2169.9614,-1059.8617,862.6982,1764.5582,2505.4836,2682.9597,2119.6091,1454.0543,1361.2562,1480.342};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_62()
		{
			double[] value = {842.943,125.73089,-101.32642,531.25854,91.818245,252.93019,-3.117399,-51.501114,257.71582,292.6314,586.7961,682.3018,764.7609,281.84283,-236.67557,-264.87256,-217.1489,-44.57353,1086.3566,1724.1466,1551.1213,1515.9972,1431.6105,1441.1124,1518.3479,1572.4988,1581.8938,1438.5267,1497.3693,1514.8016,1514.6475,1586.2041,1365.4131,969.6581,1498.1345,1015.53754,872.789,1703.7852,1761.5624,1735.7354,1699.9463,1715.4681,1782.0123,1774.34,1729.5477,2017.9341,2292.9668,2311.9812,2196.6604,2305.5886,2209.5676,1840.3795,1515.9893,1366.1746,1033.0487,824.84357,778.5438,711.6934,671.9364,642.9726,656.91046,668.4985,739.9215,775.93555,712.1367,764.0533,869.0938,1188.6332,1432.7458,1714.3236,1703.1764,2071.1594,2510.5732,2422.5388,2182.391,2090.7502,2124.3782,2180.0613,2232.1584,2118.9514,2141.414,1785.2913,2200.569,2157.7173,1209.6526,268.65836,859.34546,1771.7485,636.0399,-506.78183,-464.90945,-448.61044,-651.38696,-1029.5708,-1090.7169,-799.0171,859.9656,1357.8268,1375.1832,547.97};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_63()
		{
			double[] value = {-903.6232,-1765.8555,-2428.0579,-2332.965,-2571.2627,-2610.7144,-2886.303,-2787.4817,-2688.252,-2723.2998,-2745.0405,-2717.426,-2587.1814,-2656.5342,-2672.4512,-2634.9932,-2647.5693,-2507.2842,-1598.9183,-99.23106,1459.4198,2172.4893,3071.461,2484.1882,1802.6862,708.27905,120.89237,-83.43507,-607.7785,-719.65454,-579.82446,-59.08228,486.0739,229.6552,141.1863,109.192474,153.65352,232.78741,361.88605,255.56905,275.2508,358.92847,551.6751,800.0575,1013.65466,1401.2338,1579.2892,1526.6555,1327.0288,1367.3982,1364.7076,1308.4315,1319.2571,1322.1384,1350.5968,1424.6898,1492.9263,1564.7716,1552.2732,1527.1262,1581.9768,1541.1324,1608.8774,1583.6042,1578.0787,1741.7583,1597.2616,1728.774,1641.2014,1709.1322,1757.1063,1718.8724,1628.3077,2054.286,2355.6973,2037.4875,1814.616,1716.6476,1599.1927,1462.0508,1356.2246,1334.8903,1089.6957,1119.1803,1123.4133,915.3146,797.1462,755.59235,751.68567,706.23096,696.3727,691.9429,655.14,641.732,659.26654,934.7217,1361.0557,1283.4839,527.76636,846.6839};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_64()
		{
			double[] value = {2445.059,2311.9426,2130.597,1888.6156,2152.351,2364.413,2504.678,2591.5854,2554.4397,1657.6179,2167.6892,2357.3164,1277.2124,298.02698,-35.238026,633.0442,397.59375,-927.6094,-930.29816,-449.4762,-348.74393,-701.9137,-1044.1636,-1041.85,-410.15698,115.91198,484.32028,-1161.5406,-1760.5234,-2624.544,-2755.5403,-2785.9697,-2719.6978,-2814.2134,-3214.3562,-2879.0266,-2748.3157,-2740.837,-2783.754,-2747.7014,-2604.178,-2551.438,-2715.0383,-2695.8198,-2700.4443,-2693.967,-2449.0986,-2112.1887,-1692.89,-1087.7463,-107.14712,771.97217,-96.19229,-255.91528,-47.654285,36.61461,-846.8768,-115.58306,1789.9537,1362.4589,1496.7354,551.1511,153.26147,437.28766,-27.06671,78.03608,309.65936,376.84656,446.78165,589.99115,508.9822,458.77298,641.4463,858.76935,1069.9419,1230.4175,1200.2032,1106.3208,1086.726,1077.4487,1136.2306,1122.763,1164.3308,1170.3215,1298.1227,1409.3225,1397.8724,1382.4102,1479.8142,1354.8475,1225.7446,1797.8701,1736.6708,1349.2228,1545.6049,1759.9327,1716.2396,1862.7301,1892.2424,1739.089};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_65()
		{
			double[] value = {1860.1401,2015.5966,1998.8868,1710.6672,1536.7567,1447.9752,1388.482,1333.3815,1405.3956,1392.2306,1293.6133,1337.2869,1268.5219,1377.204,1395.1389,1383.1577,1272.4883,1062.9764,895.2395,845.8447,802.14056,777.151,826.7076,1029.9595,1361.7546,1536.7192,1581.4568,1892.8816,2389.9148,1825.3612,1349.6472,1807.1177,2296.467,2483.0247,2483.3713,2373.609,1909.7825,938.3495,1387.6433,1558.0406,1322.9471,655.42816,603.1395,-493.36365,-965.34644,-971.03076,-1021.68976,-784.6675,-602.0505,-263.44675,-541.21356,-128.24304,-563.66296,-921.52484,-1859.7413,-2749.6638,-3068.8484,-3178.1155,-3310.2595,-3135.768,-2930.269,-2948.106,-2930.4312,-2805.5337,-2749.6265,-2737.2126,-2746.999,-2790.084,-2795.4497,-2787.6155,-2764.86,-2729.723,-2684.7192,-2566.0984,-2344.858,-2296.1536,-1905.0276,-1693.3668,-1615.3654,-1140.8604,-904.8799,-176.88087,147.0941,-8.393067,312.1362,908.273,1923.1027,1781.0925,1452.558,849.8709,381.0224,310.85394,116.21024,546.8356,543.3977,719.42505,819.9396,722.3298,620.4397,397.62192};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_66()
		{
			double[] value = {385.9553,518.5062,606.9606,800.7378,876.22546,858.8778,817.06635,803.0563,826.5172,991.246,991.91254,1056.2578,1270.2566,1294.5244,1291.1036,1383.8441,1714.4614,1854.3152,1713.8186,1740.7833,1687.7694,1584.993,1527.9391,1633.7753,1575.3511,1684.3092,1559.9236,1525.1619,1659.0734,1608.7168,1715.5544,1519.8606,1398.3718,1375.3479,1406.9253,1545.6493,1645.0176,1125.5791,610.06915,306.75964,135.7754,498.90936,1300.6226,1978.2563,2042.995,1647.4604,1383.3634,1219.8304,1202.8376,1111.4216,1170.7784,1312.6906,1512.4575,1746.7472,1700.4819,1725.1241,1464.252,1263.6162,841.9817,1143.0334,1511.644,1836.2775,2090.7976,2078.157,1962.1249,1765.6342,1899.5562,1438.0071,1047.5659,479.28223,592.1706,1194.6652,-320.6053,-909.4409,-874.03925,-1103.6854,-863.22644,-714.9474,-784.79193,-1070.608,-1428.631,-2152.9475,-2731.5486,-3261.973,-3430.1367,-3196.7654,-3041.8674,-2958.3845,-2805.074,-2804.7842,-2801.1094,-2783.6272,-2758.144,-2735.2766,-2743.4866,-2796.4497,-2827.2075,-2831.2502,-2806.4727,-2796.428};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_67()
		{
			double[] value = {-2687.6687,-2544.6848,-2542.0906,-2496.2207,-2088.2502,-1785.3124,-1711.3394,-1417.953,-1113.5162,-920.61,310.73804,166.03204,773.60876,840.6364,1074.5272,621.5613,567.2538,455.5406,287.279,-147.66847,-255.07428,553.87286,792.8224,753.66437,704.77814,678.14984,497.10648,363.27887,372.4781,415.31747,447.0641,547.0048,626.7798,626.7579,680.6351,502.86996,563.2123,1047.9714,1031.427,1100.0485,1078.0344,743.68396,479.097,378.42914,751.8246,1638.8223,2088.1138,1890.2266,1627.3446,1458.6831,1431.8893,1394.038,1360.344,1238.1011,1459.2336,1533.7039,1598.8239,1585.2349,1480.2487,1408.872,1412.6968,1474.4774,1652.1016,1526.0486,1223.6832,-33.861,-478.4608,-766.37585,-999.2135,-534.77826,-174.91417,1263.8909,2315.1292,2288.2454,2010.9901,1772.8457,1773.3928,1614.982,1641.704,1734.2538,1996.2753,1982.3715,1782.0104,1502.0206,1264.82,931.04395,645.3144,543.9397,643.0207,848.0989,1293.3271,1342.2327,1441.5802,1597.5054,2019.6558,1944.4983,1673.7036,1579.1571,1635.6683,2186.9922};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_68()
		{
			double[] value = {1010.18036,194.47289,-26.192156,-747.2769,-771.7017,-1525.3,-1197.4397,-1356.4723,-2030.4741,-2852.3503,-3182.99,-3284.513,-3296.044,-3036.5984,-2906.6301,-2698.019,-2685.4465,-2702.8489,-2765.1948,-2725.7913,-2760.5671,-2808.365,-2873.1868,-2817.6687,-2850.444,-2825.8823,-2874.707,-2818.9146,-2732.7937,-2637.871,-2556.5654,-2461.3442,-2206.5156,-1838.2529,-1650.7614,-1334.6741,-637.9382,-341.12845,-241.03595,128.06995,363.07196,451.33093,747.3457,1445.5415,977.3924,798.9951,471.73157,250.96352,255.24959,600.4445,911.8314,675.8593,635.77405,636.23517,497.41922,410.27026,351.0464,338.2263,493.63284,689.5304,755.7318,732.5773,778.55225,819.1637,949.50946,1183.8857,1117.1764,1241.8417,523.3308,-4.570454,-204.91689,-181.5812,-141.114,336.9911,1824.334,1476.3944,1058.9692,1235.8062,1298.6115,1218.4434,1305.5115,1424.7747,1325.1471,1375.3895,1586.9939,1532.0546,1487.1414,1418.238,1401.2537,1447.3918,1546.541,1698.6514,931.7294,-302.4197,-349.8503,-956.5348,-1153.9011,-706.9885,-57.19759,876.2108};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_69()
		{
			double[] value = {2314.1936,2289.3755,2135.7024,2101.8008,2128.7583,2012.2751,1969.1045,2123.2568,2340.5078,2250.4849,1350.6232,821.8819,895.94666,1016.3756,479.58887,191.12273,292.58932,392.95612,451.2179,707.67194,806.16254,659.868,926.7886,1553.7465,1819.351,1951.7338,982.366,-95.6956,245.3233,9.777787,703.45135,-405.8538,-692.2695,-291.10223,-221.47348,-1755.057,-2517.8992,-2858.0166,-3027.1702,-3033.055,-3015.761,-2865.361,-2772.4624,-2710.2646,-2731.2878,-2732.4885,-2821.4312,-2678.4695,-2684.3801,-2731.3206,-2794.9822,-2839.514,-2788.5996,-2808.7712,-2839.3198,-2791.1,-2761.7375,-2568.449,-2438.6892,-2445.998,-2218.0154,-1676.7495,-1738.1259,-1082.4758,-727.6343,-1718.2112,-2474.4487,-2604.849,-2211.6182,-1875.9733,-164.33995,1718.6484,1727.5095,1028.4861,412.0478,394.8149,144.96046,459.0524,840.50726,653.2284,615.98737,529.0037,436.20685,383.40594,414.55597,406.11255,493.61844,679.3619,777.72906,865.9312,896.9392,527.55273,650.0746,1400.9622,1408.4166,1436.4503,745.01074,-31.36965,-204.79654,-133.39122};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_70()
		{
			double[] value = {-133.523,333.39658,1693.2301,1145.0369,857.70435,1069.1602,1322.5868,1244.2092,1294.7422,1281.7417,1312.7804,1311.8932,1523.4293,1461.2805,1438.8668,1418.0753,1390.944,1386.9961,1569.9357,1969.9626,1351.1592,178.99046,-358.14795,-107.79738,-307.72473,-208.90736,262.5816,1696.2538,2156.9185,1947.8632,1898.758,2095.0918,2260.6643,2239.231,2288.6956,2422.539,2494.585,2458.1047,1081.1567,386.4622,322.58795,320.40598,168.62746,154.30998,103.95444,119.05664,239.0983,251.69164,259.9184,702.4294,1316.6758,1527.1469,1591.7224,2226.8677,1827.8448,1014.5894,202.50966,-14.620786,1866.4,279.91275,-754.825,-1214.9208,-1133.8464,-1806.7025,-2726.605,-2842.9968,-3025.011,-3013.278,-2960.646,-2785.4424,-2664.0005,-2737.3196,-2762.0688,-2811.0854,-2773.1868,-2716.372,-2761.2463,-2769.001,-2809.6672,-2862.8242,-2821.1094,-2806.543,-2850.5935,-2789.262,-2757.2012,-2770.288,-2640.0754,-2184.5613,-2052.982,-2072.7856,-1558.0212,-610.732,-1848.2456,-1969.7401,-2069.0186,-2179.9084,-2224.533,-2546.6672,-2676.7744,89.84851};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_71()
		{
			double[] value = {622.5576,334.6614,336.97427,208.80988,236.58597,433.83704,693.3463,633.04333,611.94543,571.3646,521.0801,415.41956,448.25418,466.99142,506.87027,603.85754,693.87573,927.5791,955.2701,1026.7676,1216.2137,1405.0474,1430.3988,1472.4391,1563.7483,849.63306,249.50284,500.29636,732.724,1709.4252,2034.673,1675.4274,1544.2579,1402.5835,1344.0747,1358.9207,1315.2621,1406.5845,1299.9474,1264.8577,1560.2594,1492.0897,1471.8954,1413.7604,1379.7592,1411.5698,1502.371,1720.7898,1871.2131,1527.667,960.64014,661.8241,757.8276,1131.6759,1646.1908,2008.3337,1836.0393,1643.3674,1842.408,1880.9268,2359.5903,2421.5789,2487.3125,2728.9873,2809.7458,2745.3027,2736.5955,2151.548,1366.2712,436.7262,235.906,164.6407,103.23609,79.96991,76.220184,126.03014,449.6269,1346.5793,1290.7833,1274.1543,1703.4862,802.48004,554.9434,1728.7985,1490.9791,-28.663902,456.337,-269.1337,-683.06946,-710.8218,-1554.1295,-2089.2502,-2366.2522,-2751.385,-2942.371,-3133.4277,-3067.809,-2746.0186,-2543.8088,-2586.2312};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_72()
		{
			double[] value = {-2782.2588,-2912.5374,-2841.0083,-2768.05,-2840.3179,-2810.061,-2808.9353,-2823.6372,-2867.5474,-2755.3257,-2822.6821,-2883.444,-2863.7798,-3021.4204,-3244.247,-2616.6636,-2255.0898,-1740.7865,-685.55414,-233.40193,-2040.3236,-2008.4764,-2349.994,-2340.234,-2146.5105,-2193.4092,-2379.5342,-739.42737,515.2712,342.2109,273.00302,210.88782,547.26434,791.64777,686.6823,720.3367,686.3999,690.14056,586.08075,519.0921,505.8014,519.3385,526.28564,622.8504,733.49884,903.0075,1019.62787,1071.1666,1223.604,1333.8901,1398.0303,1551.6833,1723.0654,1777.5576,1788.4358,1944.8468,1997.5098,1851.847,1650.6534,1438.4757,1093.8501,871.5786,1074.8599,1379.0275,1298.1582,1331.2587,1220.5822,1334.573,1571.5371,1514.4275,1513.1099,1500.5481,1463.384,1463.4045,1498.9641,1503.9923,1695.604,1805.8175,2018.948,2003.8036,2017.8185,2001.1635,2048.6743,1984.3169,1811.9279,1838.696,2137.671,2448.4448,2655.1816,2658.2625,2171.669,2831.6072,2902.1443,2777.6917,2729.424,2766.7847,2271.3918,1443.9121,982.196,454.58688};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_73()
		{
			double[] value = {119.94325,87.0128,85.17653,120.78298,716.1328,1390.1132,1078.1119,1011.6799,1457.4905,1481.7635,700.125,-201.8892,-649.8371,-746.455,-994.7499,-831.2222,-929.47253,-830.5045,-1371.1583,-1527.1713,-1883.6394,-2333.3945,-2802.4778,-3083.565,-3263.2896,-3117.9749,-2817.0166,-2820.4192,-2826.4421,-2843.4866,-2883.3838,-2767.6162,-2763.9426,-2736.9395,-2798.6248,-2776.2117,-2846.1724,-2904.4507,-3028.296,-3064.185,-3106.453,-2969.195,-2986.2256,-2642.227,-2413.4536,-1811.9513,-1140.5867,-291.23145,-705.0673,-1984.0582,-2236.1042,-2223.6829,-2150.4011,-1913.7913,-838.834,832.9016,467.25244,883.174,730.9723,300.59763,671.57916,840.8872,830.9907,748.1439,805.9826,938.89087,840.73145,767.9221,631.64014,598.37964,543.1027,644.1507,792.2772,954.8473,1040.6543,1149.0753,1188.7874,1330.2799,1408.7218,1624.8866,1688.6901,1650.042,1859.5195,1985.0117,1814.4879,1693.806,1005.58655,144.8311,-8.474787,-487.33923,484.68756,598.44037,1050.0265,1373.1174,1365.5867,1629.2921,1541.4431,1606.6721,1581.8639,1575.2306};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_74()
		{
			double[] value = {1586.0547,1569.7476,1605.9423,1633.3165,1641.588,1673.8792,1796.7151,1779.8223,1836.0042,1943.5845,1911.0416,2000.059,1934.9277,1992.678,2303.2622,2523.5947,2673.2012,2758.4595,2854.734,2863.797,2900.12,2793.1628,2642.3794,2511.0364,2546.3687,2260.732,1797.2253,1475.5138,944.6448,729.7729,759.1519,1034.4944,1599.8539,1846.5511,1885.9794,1986.0671,2083.0142,1138.5582,664.6454,135.35918,-81.22342,-223.52377,-582.91266,-578.49536,-844.26483,-988.0291,-1000.64056,-814.074,-1434.9159,-2029.2385,-2509.726,-2861.2048,-3363.241,-3344.9307,-3016.781,-2898.6604,-2846.5276,-2810.2795,-2854.9602,-2835.283,-2761.174,-2753.2917,-2800.861,-2805.254,-2871.7268,-2962.2742,-2984.7185,-3034.3196,-2983.9604,-2832.5325,-2755.3228,-2390.6726,-2554.597,-2299.328,-1420.3607,-816.1933,-20.638086,-396.71848,-810.61755,-1252.893,-628.3408,230.97374,817.88995,1347.9786,800.75494,510.94965,-95.43941,-20.34286,799.42914,798.1127,785.04944,764.93445,936.33167,901.97125,559.9269,441.9482,462.8134,592.1619,676.50104,811.2234};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_75()
		{
			double[] value = {862.1355,908.11237,1093.4501,1220.0082,1310.1805,1428.8248,1494.8717,1583.7101,1637.0259,1784.2694,1899.9343,2014.0414,1768.3857,1652.6512,1287.0869,170.52277,-66.08784,-128.33716,409.87085,178.2687,635.8202,1313.2988,1347.9855,1531.7932,1802.2917,1733.6088,1715.4937,1700.5233,1726.5522,1702.1783,1831.331,1870.022,1825.2876,1794.604,1814.1644,1808.9908,1879.7898,1987.4622,1993.1644,1979.4708,2111.79,2000.4857,2399.4414,2533.224,2644.413,2671.8596,2715.8188,2742.4302,2763.1248,2850.873,2884.199,2741.327,2380.732,2049.1824,1947.43,1769.7174,1576.0045,1809.467,1952.4562,1630.8282,1971.0292,2107.1277,2257.4739,2043.265,2021.7179,2014.5392,565.9294,-669.338,-280.20047,351.55176,212.97849,139.75293,148.82915,-680.6841,-867.48315,-1091.4954,-1600.6704,-2216.6775,-1983.2351,-1209.7771,-2461.7986,-3251.851,-3201.4753,-3068.6458,-2895.9453,-2866.4888,-2913.8845,-2972.48,-2853.5571,-2788.5952,-2906.5977,-2909.0469,-2943.3547,-3026.6575,-3088.8687,-3027.394,-2853.1711,-2755.4116,-2696.0918,-2638.4797};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_76()
		{
			double[] value = {-2639.823,-2472.305,-2021.8844,-1259.9957,-814.8816,-565.84576,-152.2407,-442.8417,743.947,1226.7865,1169.5173,1282.4368,488.76807,-934.4139,-1067.2725,-1033.4722,367.36728,1047.0737,948.2133,860.5029,888.42346,380.52435,219.84775,315.9765,473.18518,434.33563,300.52426,788.0923,944.03925,1129.2925,1030.6462,1022.4026,1113.8363,1321.6163,1468.8998,1479.1412,1470.9209,1694.9818,1701.3483,1817.0453,1948.9441,1819.4716,1692.888,1232.366,805.3311,786.8334,1300.419,1537.0499,1384.4922,1267.4877,1193.9696,1354.8411,1865.8762,1896.6238,1906.0577,1899.136,1879.064,1785.865,1885.06,1883.1879,1874.308,1980.5381,1937.3422,1953.0803,2065.7507,2148.353,2138.93,2241.924,2271.074,2347.8918,2463.2505,2573.0586,2679.9556,2724.3313,2648.154,2633.7405,2708.4773,2843.9238,3090.5645,3082.6543,2833.1226,2517.4365,2124.1636,1991.8275,2054.2869,2346.4487,2954.4277,2129.1504,2042.0066,2056.0168,2171.6243,2043.038,2060.825,2206.2268,1790.5387,1292.7716,1617.399,1256.4865,1076.2866,-218.39981};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_77()
		{
			double[] value = {-671.5368,-1008.3058,-1125.7465,-1303.297,-1355.6108,-537.5646,1041.716,783.3456,-1262.9019,-2475.4834,-3312.5413,-3259.895,-3115.8088,-3090.1504,-3073.9377,-3041.1975,-2858.5674,-2947.4663,-3016.9082,-3087.2576,-3051.748,-3150.9202,-3150.961,-3138.9895,-3086.4097,-2851.698,-2843.108,-2710.175,-2790.1963,-2671.2432,-2154.269,-910.8249,914.2627,-626.248,-750.234,-822.62537,-394.91113,-243.95807,-277.85617,396.5257,740.12463,-505.37405,-944.5905,-791.8564,228.12247,637.7787,886.2862,874.1663,965.39856,1148.6912,374.87744,949.80505,571.20667,594.4613,970.82196,1039.7085,1134.9991,1150.6661,936.98724,835.6051,1348.8326,1495.0461,1470.2036,1457.6315,1563.9388,1620.2338,1614.5099,1748.7635,2031.9064,1695.1943,1232.2343,1376.5853,1505.0022,1583.6371,1436.1138,1226.025,1197.6625,1182.2476,1278.4734,1326.0154,2222.5122,2065.0479,2086.339,2068.9724,2100.452,1967.5621,1996.3762,1957.5995,1987.0613,2166.542,2187.6401,2180.7644,2259.2542,2290.684,2320.837,2396.0068,2448.4521,2563.2917,2613.3025,2698.7314};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_78()
		{
			double[] value = {2807.9612,2896.3877,3000.8118,2884.9314,2882.1843,3064.9995,3219.3726,1718.0045,1386.4071,2598.7122,2197.387,1808.8164,2280.684,2510.977,2732.0364,2141.9539,1829.1744,1800.0819,1739.1393,1568.9894,1379.4996,1416.5438,1144.1453,2128.718,1687.7977,835.71375,134.66121,622.27673,841.69086,457.108,-493.831,-1188.0906,-223.1196,508.0626,-433.5744,-427.71414,-714.6142,-2095.3008,-3081.8862,-3248.1587,-3190.5984,-3211.0964,-3193.936,-3179.3044,-3066.1833,-3081.8252,-3165.778,-3152.2505,-3103.2944,-3138.5776,-3155.4714,-3196.8467,-3070.1064,-2999.2488,-2836.9177,-2864.7722,-2865.6287,-2520.568,-1899.6605,-1275.7838,-161.71797,-977.8998,-698.70557,-756.8862,-622.20325,-593.989,-497.55362,366.51157,794.55194,678.8916,599.1491,785.1183,717.44696,800.86505,968.3254,1205.4155,1440.3977,1731.2188,1463.1282,1060.393,839.735,771.56757,1028.4126,1107.7493,987.8917,1151.2274,1374.5499,1287.0414,1260.9375,1374.2416,1479.1223,1404.2921,1614.915,1593.9668,1558.6636,1585.8169,1693.3008,1817.9353,1445.563,1159.6023};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_79()
		{
			double[] value = {1504.2548,1463.9081,1224.737,1189.7843,1247.5621,1246.2975,1305.6357,1332.2352,2702.6206,2347.7742,2203.1292,2205.7622,2210.2131,2267.3462,2489.2664,2547.1191,2578.6477,2684.5107,2727.3567,2333.7654,2551.2463,2631.1418,2619.8613,2645.4272,2711.0586,2692.139,2751.4114,2762.9326,2337.7024,2841.3079,3588.9412,3483.0847,3217.467,3130.1655,3145.3867,2489.568,2192.4207,2602.8823,2252.3938,2057.9558,2130.1492,2154.9836,2230.51,2024.1222,1313.8864,1622.3564,1514.9348,1384.9052,1313.6522,1137.6896,837.7279,1266.8662,1159.8055,505.81485,315.11588,425.0864,168.14293,440.52554,1270.0547,3.196839,-663.7295,52.865314,1113.142,-271.34076,-1267.5359,-1035.3622,-390.64365,-2389.2502,-3302.0164,-3397.066,-3352.2566,-3218.4895,-3141.849,-3327.0183,-3341.0747,-3366.2754,-3227.5923,-3288.9214,-3366.8516,-3319.2568,-3164.8296,-3090.9658,-2960.4277,-2918.382,-2802.974,-2295.6816,-1975.6677,-1321.8868,-1186.7261,-1096.696,-856.3046,-392.9004,-333.42816,-556.57227,-478.69495,572.4628,825.1184,618.2673,569.46906,662.35266};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_80()
		{
			double[] value = {954.39075,1006.3803,1059.422,1157.5281,893.18365,834.6508,1212.1034,1070.7489,1069.2098,882.07263,782.7577,1143.2949,1241.2053,1238.2834,1485.2654,1368.0358,1328.0034,1533.413,1563.3164,1510.6891,1632.3927,1631.0441,1541.315,1598.8044,1649.5154,1776.2357,1751.5455,1636.0957,1165.4717,1071.7678,1193.5985,1129.501,1237.2825,1067.7335,341.01718,492.66937,2625.8347,2417.2808,2282.7925,2272.636,2277.552,2342.8591,2413.4207,2532.9504,2656.1523,2826.371,2891.6223,2763.6282,2951.848,2929.7175,2901.177,2888.6658,2897.9858,2862.6548,2806.723,2796.0789,2829.365,2949.035,3242.9812,3636.16,3668.1074,3615.4204,3610.3865,3199.637,2656.3445,2332.8682,2122.5881,2005.989,1887.3318,1776.9344,1807.8577,1759.2504,1572.2659,1514.4552,1547.9153,1501.0486,1403.106,1657.9401,1337.6718,701.8867,550.3249,576.56885,564.1561,405.05927,185.69464,75.97691,-682.21625,-879.2071,347.54205,28.888405,271.49774,217.51552,-938.21,-2065.7473,-2258.7495,-2529.6606,-2949.1694,-3059.5166,-3224.4038,-3827.2893};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_81()
		{
			double[] value = {-4011.4978,-3935.3286,-3403.0652,-3430.864,-3433.8113,-3443.2273,-3438.8982,-3308.8914,-3207.5566,-3147.5134,-3027.7412,-2968.5884,-2604.9976,-2298.6858,-1809.5717,-1200.0826,-880.8803,-959.9457,-516.14856,31.714815,-323.39645,-782.0961,-800.4822,-75.570526,333.83383,619.01184,697.3132,849.3967,1060.893,1030.2352,883.90424,583.4284,-510.848,-581.9826,226.09749,1271.7352,1246.0873,916.8861,435.36533,1074.7341,1362.3672,1426.9481,1492.2828,1541.5702,1542.3712,1553.4233,1546.7874,1608.5958,1663.4166,1637.9865,1508.8402,1680.2421,1704.8239,1825.1373,1916.3802,1656.6049,1069.4705,887.6187,1210.5039,1150.7365,1194.6777,1240.0363,655.3686,448.41226,2310.061,2289.0469,2298.232,2299.4868,2302.8926,2345.8223,2398.5125,2479.4468,2549.295,2554.152,2725.1418,2782.4724,2814.0383,2899.6453,2913.5676,2908.9683,2952.107,2901.095,2904.8306,2918.9912,2884.7917,2965.0977,3044.6924,3251.9019,3324.5056,3387.0618,3547.4856,3121.6304,2670.3765,2428.9746,2366.815,2212.2712,2115.9763,1836.4204,1865.4152,1868.6395};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_82()
		{
			double[] value = {1605.1016,1547.4951,1577.0458,1583.6335,1268.6322,1237.3707,1217.9271,1008.4314,462.3671,565.7242,585.8837,571.17474,50.692398,451.67145,399.5137,557.00903,25.860174,-827.87946,-579.33716,-827.7592,-1732.0541,-1842.1254,-1951.7089,-1955.0737,-2550.1943,-2552.7163,-3056.8262,-4226.873,-4242.1206,-3973.5193,-3663.5903,-3340.6465,-3451.6816,-3435.8254,-3406.4744,-3338.934,-3278.1753,-3174.4524,-2998.4976,-2932.6104,-2083.061,-1624.7789,-923.91144,-1161.3794,-783.7841,-746.3295,-460.13882,-548.32227,-781.68195,-905.5512,-884.8481,-7.375051,912.67804,1159.8909,1187.431,1187.6783,968.6651,1121.3589,1096.0143,1226.5878,264.18073,-0.963622,677.4446,1197.9691,1301.2842,1228.6187,1182.829,1219.7678,1423.3018,1379.0514,1445.9225,1458.3292,1482.9222,1576.223,1605.7632,1649.1957,1659.9601,1680.7656,1709.5869,1732.9445,1719.0814,1756.1411,1898.5615,1566.9353,1210.5922,1130.3287,1129.3517,1176.1077,1261.0885,1192.9437,1292.6085,1380.8574,2234.3352,2262.0266,2279.8364,2276.6946,2280.0146,2360.9373,2466.1018,2512.2576};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_83()
		{
			double[] value = {2668.0415,2770.9385,2771.7593,2814.1782,2852.201,2882.1638,2939.1711,3020.633,3052.0828,3009.1477,2931.3618,2874.1907,3060.7222,3058.4624,3044.079,2996.78,3012.7205,3080.1807,3191.1047,3002.2188,2668.9185,2242.7239,2205.6633,2098.5342,2322.426,2587.2803,2208.2913,2197.1409,1951.5957,1790.3302,1488.9454,1410.1079,1916.2289,1701.1278,1158.5642,1260.2842,1779.84,1156.7804,252.28902,227.51877,613.6954,681.196,674.6049,1122.2256,417.2076,194.34526,-34.521084,-1105.4971,-1226.8419,-847.5028,33.876602,17.568375,-2337.2656,-2141.9077,-2056.5354,-3409.1455,-3722.3694,-3157.2522,-2872.4797,-2938.211,-3348.3372,-3384.1213,-3315.419,-3233.691,-3075.3113,-2830.655,-2555.7817,-2482.9214,-2273.387,-1804.3385,-1276.1697,-651.09296,-194.49257,-1939.7126,-1641.0452,-230.43819,-510.48566,-906.6123,-687.0246,191.22255,946.3941,990.66016,1068.9293,1243.1764,1265.1116,1148.3824,1381.765,1332.6685,1385.2161,1522.3826,1207.6881,1122.0024,1236.9146,1121.4039,172.7821,-497.89578,-22.987772,1246.862,1489.4578,1370.9092};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_84()
		{
			double[] value = {1474.8628,1441.7256,1580.0704,1691.6855,1722.9375,1723.3396,1654.8619,1396.9266,1572.2223,1763.5659,1867.6271,1431.137,1267.8207,1219.3414,1130.5211,1205.6272,1024.7329,1023.5721,1416.985,1481.8512,2218.326,2285.5874,2315.1094,2323.3035,2316.813,2540.2444,2645.4136,2692.3796,2742.4163,2807.4448,2819.2986,2853.9634,2972.0088,2999.9167,3021.8604,3077.8982,3089.2793,2980.0935,3117.2668,2908.6877,2794.0105,3156.13,3122.945,3078.3264,3038.951,3112.6167,3140.4438,2750.1091,2440.933,2263.1272,2140.0576,2063.8242,2156.004,2489.1384,2675.2002,1762.5773,1549.5868,2000.1757,1610.8197,1370.4236,1794.4951,1212.9402,1600.153,1706.855,1904.436,1791.5588,855.6938,612.50726,633.84644,1015.95514,1343.5996,1244.0745,822.2182,380.36386,-1063.6084,-139.7922,311.2404,164.76994,-527.0536,-1011.1757,-1582.8599,-1577.9299,-1691.6874,-1908.3202,-1853.6173,-1907.0494,-2187.6138,-2577.0425,-2527.2446,-2510.4666,-2752.6484,-2677.8447,-2117.7944,-2159.7705,-2318.8335,-2103.1895,-1683.7162,-1494.066,-936.9679,-206.46255};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_85()
		{
			double[] value = {-643.2327,-1291.4377,-968.21533,-705.49115,-637.93585,-307.42242,244.88391,918.78656,889.22485,847.5554,870.6398,873.2392,701.6177,625.5252,829.34503,1089.5498,1060.7289,826.57513,954.45825,1076.2313,1144.864,190.81381,-1214.5367,-1167.712,-1213.1606,260.6183,1460.3057,1314.212,1195.39,1220.9844,1476.3661,1572.0514,1595.5443,1528.5985,1443.0898,1151.0593,1536.9475,1695.5555,1630.6226,1079.4833,1149.0786,1184.9917,1105.0135,1202.1199,1178.2925,1330.7573,1529.582,1614.1464,2743.7202,2661.4744,2650.708,2713.5286,2709.8782,2914.7092,2916.8254,2899.5173,2799.9766,2773.345,2830.0664,2865.8376,2973.323,3056.0933,3140.4211,3155.7,3204.9634,3184.9028,3216.0508,3112.9639,3167.0662,3176.719,3167.573,3193.4963,3266.8772,3338.1162,3260.6316,2949.5608,2631.9387,2471.0305,2353.9685,2371.1348,2450.4448,2432.1367,2531.293,2094.7632,2120.354,2165.8916,1882.0195,1633.8416,1553.5928,1522.3263,1746.802,1715.8318,1943.9716,1797.1885,1446.8588,1395.2074,529.95825,444.10492,601.25574,1281.4331};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_86()
		{
			double[] value = {1718.7214,1410.274,622.6402,737.9465,692.29767,-147.8702,-609.9282,-1387.0319,-1321.6605,-1114.8682,-1395.6389,-1747.7578,-1587.2656,-1775.4503,-1777.5319,-1640.8523,-1917.7806,-2015.4583,-2010.7902,-1965.8112,-1652.8003,-1147.1699,-1340.1935,-1117.2886,-830.45703,-271.25888,186.77884,-593.8287,-1145.689,-1099.1392,-982.3715,-629.9621,360.06714,710.4244,906.668,981.1528,842.35944,841.15906,800.98676,626.741,577.333,568.2958,734.8303,863.9404,586.3037,471.01974,954.1137,1043.7764,1124.8099,735.9686,-956.5802,-1183.0927,-1082.5704,757.8139,1791.5945,1642.8696,1499.853,1250.2423,1234.4148,1301.2284,1408.3464,1402.0662,1398.207,1599.781,1745.3368,1585.8094,1346.4875,1110.5391,1138.7622,1114.0851,1107.3937,1163.8854,1204.6053,1442.1226,1559.7059,1458.1115,3812.2253,3520.589,3339.5513,3300.2131,3271.374,3243.1328,3224.9797,3152.6736,2982.0662,2836.6658,2830.687,2885.8965,3118.6907,3252.8044,3438.3994,3492.8284,3409.0447,3362.5813,2763.664,2350.9756,3282.1995,3261.4202,3234.3103,3255.984};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_87()
		{
			double[] value = {3402.24,3514.8474,3346.2354,2895.9187,2897.774,2812.213,2559.357,2793.2607,2856.004,2893.2249,2802.2566,2607.4824,2384.749,2008.9034,1874.6104,1680.0529,1716.9906,1750.7296,1508.508,2033.2778,2437.226,2215.1812,1730.4915,1412.3535,963.5146,320.63394,732.19916,1120.5248,595.4149,962.3688,1081.7831,1943.4839,312.34677,-355.0568,-707.9523,-646.40594,-834.12787,-876.9757,-1298.0776,-1554.4725,-1323.7744,-1418.4612,-1524.5028,-1437.3279,-1349.8401,-1709.7723,-1531.1895,-1722.1501,-1447.4644,-619.5677,-964.65814,-884.35425,-519.60626,-483.13693,-736.276,-1015.8318,-840.6666,-508.3138,-266.75146,352.2236,686.3004,683.6784,578.8255,401.03854,277.30383,461.372,605.6688,233.02824,224.98062,522.64294,690.8903,441.0883,297.6984,415.50244,680.91394,928.1083,1067.4644,1066.2921,1045.9791,741.2017,1098.7822,1508.254,1772.033,1609.9335,1522.2242,1373.9106,1320.7917,1308.5482,1333.8334,1363.2472,1469.9954,1634.7322,1253.0515,1384.4065,1438.5173,1209.8593,1142.2382,1099.0745,1089.3157,1191.1399};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_88()
		{
			double[] value = {1185.1937,1358.5829,1213.2198,1301.2812,4429.8936,4055.4338,3788.826,3791.9583,3876.0647,3897.2178,3842.4893,3865.2097,3861.0,3368.2131,3066.437,3015.941,3140.9539,3363.0098,3594.9219,3513.1602,3455.7693,3433.7732,2656.3494,2275.5955,3346.9614,3357.0098,3346.0527,3247.3125,3446.7805,3303.0571,3285.6335,3091.1108,3090.6382,3090.8118,3077.09,3006.522,2962.6953,2769.4495,2647.464,2547.0342,2195.471,1940.4845,1105.836,1348.4188,1908.8556,1840.3566,2085.751,2215.8115,2530.0059,2633.5103,2566.7402,2261.6257,1759.0944,1299.6881,811.87506,683.48895,-153.679,674.3176,1537.1964,448.3486,-830.7772,-790.21826,-49.22562,69.93673,-326.02856,-149.31726,-707.61426,-1102.4918,-1312.1283,-1313.2904,-1508.8763,-1598.4341,-1490.287,-1657.8138,-1779.6674,-1817.0662,-1671.9089,-890.4033,-541.679,-813.7855,-903.4651,-904.5071,-999.20197,-645.1947,-267.72336,394.81622,404.94278,289.0639,124.09645,195.28233,-158.59746,-34.68871,148.12245,466.9902,-248.28015,-1283.727,-1377.9618,-560.7897,267.15073,326.33197};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_89()
		{
			double[] value = {297.84842,695.50616,1028.0857,926.7978,797.01904,812.59235,1032.3651,1041.3567,1296.7916,1375.3063,1498.6332,1484.7009,1395.0771,1371.3287,1408.6151,1459.6202,1451.4402,1491.3331,1456.3062,1316.2399,593.85736,960.4798,1368.491,1149.0612,1107.7328,1180.2766,1043.4847,1092.7567,1194.2507,1262.8068,1026.0656,1298.4279,4880.4424,4428.326,4274.8857,4648.091,5029.8843,5116.506,4815.6,4842.295,4956.8364,4381.4204,3598.5378,3328.5083,3290.205,3527.8179,3578.3672,3446.8281,3447.8293,3496.9849,3458.9348,3382.538,3435.4365,3366.807,3416.255,3393.6282,3143.8108,3310.004,3237.5325,3145.8623,3138.686,3176.4504,3277.24,2807.7693,2960.328,2312.7888,1865.892,2429.3855,2034.1519,1948.3674,1845.0446,1814.8522,1852.6613,1830.6042,1990.7112,2232.637,2245.4785,2418.8518,2727.482,2995.35,2436.2437,1342.72,1000.95807,1106.5059,919.0408,1356.3477,580.99365,-461.16013,-769.96356,-411.00137,16.538744,-568.413,-205.76642,461.06906,-220.95378,-690.8095,-898.87445,-1167.217,-1428.0189,-1426.341};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_90()
		{
			double[] value = {-1314.9535,-1528.2124,-1219.5824,-791.2941,-1106.7712,-467.98773,-60.175735,-890.38763,-1106.6356,-887.29596,-878.583,97.913605,760.3046,561.6007,367.62247,116.24337,25.7449,-125.85812,33.239407,18.56118,12.280128,353.03375,250.22487,-1159.8424,-1330.9196,-503.09613,530.41284,650.40356,1027.5988,1215.9194,949.0885,763.949,703.27,754.70483,891.9968,843.267,1013.681,1236.0557,1419.1874,1468.9818,1310.0831,1239.3529,1245.2345,1464.987,1233.8075,1251.3573,1553.9829,1536.3319,1530.6461,1318.5627,1111.5616,1060.9889,1174.9364,1269.7666,1007.9473,1013.17444,1201.0197,1227.8126,1152.4014,1335.155,5058.032,4783.2036,4775.777,5136.0054,5410.324,5245.7334,5211.47,5227.237,5338.371,5111.468,4738.426,4070.7373,3511.5576,3736.755,3514.3008,3485.8564,3492.4434,3471.4648,3460.6262,3450.0862,3400.9465,3399.9182,3408.9294,3401.162,3332.5085,3289.238,3218.259,3155.4468,3126.205,3161.066,3255.9104,2621.2578,2956.7012,2990.9983,2564.1086,2205.7275,2038.8044,2078.0774,2076.5032,1871.2985};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_91()
		{
			double[] value = {1873.0271,1864.6904,1854.5134,1878.8676,2023.9681,2143.1804,2519.0278,2575.5044,2491.766,2214.3818,1576.28,1655.3986,1849.6595,676.8817,-11.197388,-415.21527,-335.89493,241.41632,-101.20403,-674.77545,-282.6764,409.53638,-726.38165,-1297.3916,-1137.1066,-1724.9059,-1320.4264,-1346.4167,-1512.3953,-1537.4795,-1448.931,-130.63736,-236.04416,-939.0135,-881.6589,-1176.7516,-1181.7859,-708.61926,-335.76248,222.40079,351.54092,453.2748,208.72801,-75.87329,-83.05645,-102.183945,-76.6101,-74.66493,-71.47782,-19.638021,305.04358,412.83087,314.07416,615.0231,813.2601,704.1487,688.6596,639.1744,747.5251,753.1913,712.0168,745.50214,900.69995,849.93384,1016.6594,1196.3446,1235.8176,1249.6229,1210.7584,1185.5563,1230.514,1275.7451,1265.466,1283.6958,1461.5364,1408.0249,1128.0856,1059.6432,1111.2484,1025.9962,262.19992,936.84827,1139.3232,1047.5856,977.6374,1109.588,1004.1608,1108.4375,5090.1045,4836.0845,4813.022,5007.5815,4999.2905,4857.8506,4990.023,5096.1987,5386.183,5308.2817,5320.6143,4751.4365};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_92()
		{
			double[] value = {3991.8955,3577.9727,3470.7578,3476.7307,3480.896,3459.3252,3437.011,3434.5652,3394.1853,3429.8933,3409.6157,3338.2825,3290.35,3249.654,3206.9219,3167.4712,3122.9019,3134.0264,3151.1826,3115.8364,2936.9739,2609.0796,2564.941,2337.6992,2203.1882,2337.4548,2447.463,2494.578,2036.592,1930.4083,1869.1495,1879.2736,2117.71,2057.7058,2024.3469,2084.694,2314.5332,2423.6174,2047.5067,2018.7223,2057.137,-183.9533,143.64949,1082.3546,909.71936,964.834,967.5163,1309.7039,-51.95414,-75.17906,-1154.6996,-1298.5763,-1124.3541,-1173.4457,-839.9067,-1211.9678,-1137.3583,-1404.4835,-1447.4294,-871.5221,-786.7713,-1076.554,-1006.01013,-1151.826,-1161.7562,-427.76263,323.99872,400.22076,258.6353,157.08414,-34.367073,-95.58894,-11.9021,12.205344,48.25758,38.87704,72.56459,32.02359,260.8854,546.13696,583.60223,640.8321,865.5614,773.48114,722.80756,705.4417,788.58673,773.9858,754.92676,801.1616,808.5147,584.9073,35.402866,556.21655,1229.638,1255.8478,1147.2281,1048.1378,1214.292,1243.7839};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_93()
		{
			double[] value = {1203.3226,1362.6344,1450.3527,1411.321,1074.0143,1045.8462,1096.9552,1010.2767,36.710396,569.3828,1060.6646,1021.9158,1151.7438,1273.6902,1232.23,1039.2267,4436.234,4445.7876,4672.5103,4846.266,4595.946,4473.534,4470.5723,4487.924,4713.3516,4808.844,5013.0947,4892.7427,4663.494,4187.133,3911.0273,3865.4417,3630.6484,3503.0037,3445.3467,3419.1506,3399.0613,3430.979,3433.3823,3329.1384,3254.4624,3224.5134,3209.2449,3171.7214,3148.008,3092.21,3090.0396,2881.5625,2665.3567,2476.881,2445.9067,2611.2366,2483.5952,2450.9807,2629.427,2453.9814,2047.8103,2033.8408,2130.2527,2007.675,1890.4783,1785.829,1591.2241,1915.6315,2157.3914,2253.7253,2160.4036,1945.4204,1582.3771,1324.0065,1771.9138,1822.1741,1827.4987,2040.9868,2552.2532,2172.1965,1274.3922,511.58148,-867.04333,-1277.0675,-1169.4613,-1042.424,-443.13696,-508.02106,91.03852,-1035.2557,-1560.7683,-1024.9293,-312.34973,-244.41432,-663.4817,-1027.4429,-1045.5616,-345.61658,304.38855,192.98027,115.42463,84.579445,53.33846,-217.30583};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_94()
		{
			double[] value = {-341.74603,-290.92264,-841.9955,-131.43826,350.3959,337.30634,353.89154,513.5309,675.4346,717.632,719.4305,195.78795,501.23254,762.2069,852.21124,913.3963,801.6626,876.72034,558.43256,372.16647,-468.50656,-94.14208,1136.2902,1275.9075,1290.02,1264.3877,1217.5992,1194.9244,1241.6688,1376.4617,1397.0288,1294.1582,1135.1119,1001.77264,1006.51465,1042.194,1049.0168,1078.1388,1146.6521,1089.8867,1095.9104,1239.985,260.15704,580.45294,4504.3687,4799.137,4942.9717,5007.384,4537.8774,4246.716,4177.6147,4180.659,4335.5557,4469.591,4704.875,4761.0576,4737.839,4574.403,4542.173,4565.98,4090.9602,3795.3992,3613.6506,3428.3914,3363.152,3402.1855,3375.9468,3322.568,3098.941,2881.471,3180.7124,3141.5872,3102.3777,2743.4956,2856.68,2819.955,2749.3293,2606.9585,2425.0251,2354.541,2327.5732,2286.321,2332.1147,2271.0518,2138.1428,2408.4229,2791.2104,2266.355,1924.1082,1628.1178,1599.1519,1644.1161,1728.0405,1627.8652,1324.6637,1544.9553,1449.5183,1446.2008,1583.8771,1708.2621};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_95()
		{
			double[] value = {1836.0482,2200.949,2106.0945,1428.1694,1513.8402,1004.46155,-359.45468,-812.2501,-898.3681,-108.66145,862.17474,346.16516,971.43774,-378.8617,-362.8724,141.03033,185.4122,504.48517,-53.718407,-673.033,-695.1577,-249.06247,43.3598,70.030975,120.18712,206.06122,-384.02942,-588.49567,-457.06323,-285.74048,-1071.7709,-448.43268,414.7842,379.16702,270.4826,528.6648,641.292,663.3151,632.42126,620.4009,667.63116,751.74347,872.9576,832.57184,882.4671,1033.136,1160.4858,1074.4398,619.6308,999.59906,1366.3826,1075.6866,827.14453,1159.4551,1151.8402,1206.174,1317.4752,1303.1781,1358.0326,1200.3967,1331.1628,1283.5051,1212.7969,1216.1102,1218.9973,1378.7136,652.4898,604.7306,1232.3546,1335.6511,1020.5967,889.3077,4755.539,4766.976,4372.831,4297.6846,4392.3833,4130.4966,4048.5615,3945.9912,4156.7,4419.9316,4606.016,4481.7993,4577.0977,4495.1626,4595.987,4706.1997,4485.9854,4097.918,3928.0493,3776.079,3582.5554,3428.5667,3377.1638,3343.7878,3235.342,3016.2585,3266.8765,2972.5764};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_96()
		{
			double[] value = {3178.7695,2906.7087,2689.167,2229.3118,2830.8477,2531.127,2396.628,2408.254,2395.0308,2307.4429,2293.199,2274.1497,2277.8113,2686.4177,2951.5684,2545.0278,2067.3284,1771.057,1680.4816,1695.3539,1681.7935,1651.4133,1599.4948,1417.7446,1376.635,1303.4823,1090.9402,185.16159,1500.7721,1634.3722,567.60693,756.1153,497.3049,-603.3664,-201.31024,-193.21558,173.86436,1722.25,1967.347,924.08124,736.67896,-644.9547,60.620045,105.7549,337.23236,600.0008,219.39478,-493.61163,-457.27255,-18.11588,-54.63834,-215.86206,-157.65742,-206.55664,-632.1317,-82.62446,540.6336,296.65878,319.46902,23.19013,283.31116,471.0136,420.97794,455.20578,506.1292,501.88284,566.20496,554.85925,565.64386,707.7367,879.54895,872.2806,1012.4742,1238.5825,1250.8185,1165.7885,1139.3337,1353.6105,1389.1348,-24.07874,-396.2239,110.45092,924.2636,1110.742,1221.9327,1179.978,1336.6758,1324.0068,1559.0944,1277.5732,1374.2339,1406.784,1477.0989,1403.7943,799.94794,778.27893,1162.7711,1240.0864,1226.0073,1076.3164};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_97()
		{
			double[] value = {5160.2085,4783.7812,4463.4487,4977.209,4263.385,4152.453,4052.1016,3939.0825,4156.1123,4342.9795,4330.751,4239.0244,4340.1406,4586.7764,4582.0957,4731.5938,4640.0015,4626.4277,3984.0232,3960.7434,3675.9246,3383.8286,3323.044,3148.5261,3005.5854,3018.347,2951.424,3193.4578,3116.4468,2988.095,2877.9639,2815.3047,2827.028,2653.8252,2530.4797,2476.786,2388.9138,2406.145,2380.5312,2367.4316,2436.0403,2809.27,2703.2278,2307.1218,1964.9417,1827.0668,1840.5823,2032.21,2106.6875,1296.4058,1708.6238,1442.4104,1311.3094,1358.1279,1281.9086,1176.9471,1720.6521,802.3228,-387.74298,176.45615,822.6327,445.15665,804.6299,50.198635,252.1147,1655.5564,1588.5381,815.5889,387.23938,-674.9222,-700.1982,-247.79433,-87.236626,518.02203,-72.02243,-1437.5988,-1628.7527,-348.3501,-149.78291,-454.01114,-545.8001,-61.615063,396.92828,523.9879,570.5258,462.76013,299.9742,267.88385,294.47018,360.1196,354.56128,347.90457,447.21222,386.4948,321.47995,301.13733,458.38528,664.6653,831.5529,886.90094};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_98()
		{
			double[] value = {1093.4612,1253.743,1271.2817,1165.82,1074.0481,1276.1681,1512.3373,308.16983,-176.6483,244.63086,1025.7894,1061.1614,1234.0394,1251.2904,1301.6178,1326.4589,972.72906,1362.4586,1453.2312,1537.5629,1464.0482,1348.3616,1592.4186,1277.23,1181.2747,1226.7605,1243.458,1230.8483,4885.919,4584.5684,4749.103,4760.0366,4252.048,4249.906,4087.7634,3816.3674,3912.6619,4007.733,3949.7966,4027.5366,4141.2197,3967.8745,3142.037,4190.7314,4686.4937,4610.118,4787.549,4584.5244,3789.6284,3352.7065,3260.459,3207.826,3146.7466,2604.8271,2447.583,3203.0544,2847.3184,2764.0928,2891.395,2807.0847,2665.153,2599.9739,2527.6143,2539.3086,2565.0427,2570.489,2547.9355,2494.1494,2432.3542,2456.904,2441.907,2461.035,2227.6648,2031.0144,1927.1005,2117.244,2507.3792,2137.439,1910.3896,1282.8566,1040.0153,1311.2053,1402.8694,1653.9302,2108.5723,2292.1418,1455.11,1123.1301,1301.8912,1341.771,753.35376,227.4046,629.1125,1666.645,980.19934,578.9124,66.93693,-647.5839,-837.8838,-677.5164};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_99()
		{
			double[] value = {-278.6652,602.03925,-1011.83673,-2185.823,-2165.6562,-838.84467,-130.26208,105.94505,713.13324,829.07684,681.33936,592.6587,437.96176,357.06442,288.5594,284.71487,279.73676,309.3261,303.69385,297.1786,401.99734,303.56973,273.11673,344.45416,336.56946,340.46027,739.2872,826.9085,791.0501,1201.6664,1362.31,1312.8597,1267.154,1176.6582,1410.1005,1552.8035,1304.1525,1335.625,1167.6155,1149.2697,1251.0328,1231.0117,1334.4374,1384.1619,1475.6777,1575.7144,1669.2262,1556.7604,1482.177,1493.0417,1639.0984,1301.5803,1222.1382,1416.5452,1220.1425,1238.3536,4361.978,4203.609,4277.781,4334.3057,3856.5945,3459.9082,4283.356,3985.0132,3813.846,4007.1755,3901.439,3827.6235,4007.9531,4017.3818,3628.6401,4238.5723,4620.38,4704.3706,4919.4707,4664.934,4292.7246,3880.2805,3402.174,3213.5283,3090.7253,2975.6262,2876.125,2781.3625,2704.0437,2623.7927,2654.6982,2657.4988,2623.6375,2617.4448,2606.0764,2620.279,2608.2937,2596.4045,2631.9763,2617.036,2525.5066,2441.3726,2381.6802,2356.264};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_100()
		{
			double[] value = {2351.416,2373.0234,2117.802,1985.3142,2242.4993,2207.9558,1959.3604,1378.3568,889.5005,867.17664,1036.9701,1160.5641,1352.5382,1694.5413,1604.7217,1053.7902,1541.6365,1225.9775,1035.6597,1057.245,1149.6781,1403.4131,989.3478,499.50385,168.46053,-86.824875,-301.8978,-220.87964,364.58417,844.5764,198.00468,-810.89557,-649.63605,40.46514,195.62561,620.8476,900.51276,693.24524,323.89096,500.97018,409.47623,287.50757,322.02667,284.8403,296.5566,345.56876,305.80435,311.29257,322.07758,260.2528,-84.51564,275.0298,296.07016,431.65582,614.5029,717.2937,848.8764,1051.1095,1228.145,1315.3441,1353.6151,1183.4382,1242.4714,1171.5907,1215.4651,1044.7401,1070.0264,1136.0693,1253.0317,1419.8009,1548.7198,1623.09,1435.036,1758.6235,1789.3083,1606.3104,1499.4723,1471.2601,1405.9698,1262.803,1267.9854,1350.0505,1177.1074,1519.0815,3893.9126,4407.0073,4721.714,4110.4536,4126.3276,4076.146,3926.3923,3892.0466,3730.5183,3867.9722,3817.2947,3710.7095,3769.0115,3930.095,4241.884,4334.4014};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_101()
		{
			double[] value = {4493.4097,4492.8726,4885.367,5070.1367,4897.2124,4651.679,3922.6216,3503.7566,3226.4873,3049.8347,2857.863,2713.1992,2646.9355,2587.5403,2574.6907,2571.9294,2558.833,2596.232,2624.2063,2640.3472,2641.528,2611.961,2601.973,2600.5688,2598.3628,2507.7031,2426.7427,2353.7717,2296.2148,2252.7078,2031.5017,1896.3574,2012.0814,2062.629,1714.3573,1328.9491,899.8698,911.25006,1023.014,988.5459,973.6173,1019.0309,505.1756,990.4484,1289.3077,850.92535,826.6038,1282.4922,1216.237,1407.0619,1467.353,1334.4504,1187.8649,1318.4358,1093.274,1197.4329,1115.3899,1297.8049,1402.8081,1477.8699,870.36096,466.57242,711.70294,957.2614,930.6301,642.8062,541.3752,462.77444,530.4151,473.66006,444.34628,392.82767,339.1121,341.56766,280.07907,333.9481,296.20523,263.07874,104.550156,206.75122,295.51785,324.33163,492.64227,661.63635,844.2955,961.2895,964.8768,1022.0488,1145.5874,1095.1422,1038.741,614.49567,900.4607,900.61346,966.9247,1222.3168,1382.6425,1510.954,1522.3198,1380.0155};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_102()
		{
			double[] value = {1133.2043,1666.8431,1821.8784,1608.0411,1501.5608,1449.7466,1361.5609,1334.4543,1340.5701,1357.398,1417.2758,1747.4812,3799.3203,4100.937,4669.2,4070.0312,3646.3528,3943.595,3603.9321,3380.319,3671.886,3740.2903,3546.3323,3502.9863,3516.9763,3628.7888,3813.5994,4156.387,4442.405,4789.3496,5022.723,5646.116,5622.444,5266.6343,4526.9536,4013.436,3691.657,3300.2473,2991.5054,2773.9875,2635.8806,2543.4988,2516.0203,2537.8203,2560.386,2581.8032,2613.0737,2615.0708,2596.2012,2578.0366,2590.9482,2587.9285,2589.7798,2560.634,2461.892,2351.2583,2199.4482,2039.2592,1814.631,1684.3372,1753.9628,2202.687,1508.983,1149.1334,920.2888,893.8242,900.5378,884.1156,899.45245,506.79022,-257.28403,514.6218,940.28564,877.9926,1037.3939,1108.3953,1038.8951,1049.087,1202.7876,949.3875,392.4087,1413.3827,1403.2024,925.6385,809.0884,1240.6779,1207.1224,866.255,-284.4083,460.31735,910.6116,974.0935,932.3553,867.5021,754.9896,704.40375,684.40125,606.18304,540.1637,500.11963};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_103()
		{
			double[] value = {398.88528,331.85907,316.2801,329.5335,366.782,315.59872,414.46045,439.16895,248.20264,253.27972,454.93695,449.0549,736.36786,929.16907,709.7056,741.95715,1054.1608,993.3931,1014.8596,964.5246,989.7469,943.0153,954.0372,1136.8821,1027.467,1404.1705,1356.5751,1123.072,1140.6395,1454.0067,1575.455,1531.8226,1483.5027,1401.4513,1403.93,1475.6079,1420.6693,1409.5325,1140.5144,1429.1915,3544.1125,4171.134,3885.6135,3326.4092,3263.8762,3294.4026,3254.0808,3162.4177,3481.2754,3457.5894,3367.2698,3271.217,3301.9812,3457.7056,3530.6602,3952.389,4277.5493,4536.4453,5131.005,6157.7715,6077.3203,5476.4707,4745.7544,4212.6987,3943.94,3664.9866,3272.0369,2950.735,2717.6958,2646.1316,2700.8357,2800.4995,2656.1758,2595.6917,2588.854,2598.5454,2603.0286,2564.1855,2565.6724,2569.8762,2552.5034,2589.7524,2507.3699,2255.4482,2023.1042,1851.0679,1746.4927,1553.5754,1397.3734,1790.3109,1698.3706,1201.0056,966.2652,913.0796,922.81573,876.0764,911.07056,829.01776,738.98474,802.38214};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_104()
		{
			double[] value = {836.1309,894.9347,855.2751,909.78876,944.8698,1012.4838,1019.1166,1070.9474,980.25116,1088.5189,1065.4446,981.6582,947.61774,943.3447,730.4139,-1118.9104,-1380.1027,-131.0092,1043.9585,962.86743,792.94617,806.00854,773.417,212.06883,677.3479,751.52606,693.2774,654.9199,363.3007,-231.49667,428.82797,356.14844,163.63033,170.61838,406.4127,341.30167,279.74393,287.55676,424.8632,569.70886,644.992,610.8785,423.80234,864.39734,1043.0767,738.9229,614.0711,1022.66327,912.9452,827.37384,946.544,1026.3313,1111.2097,1231.417,1250.8234,1397.6428,1424.9603,1341.7592,1418.6913,1460.8787,1456.6635,1174.5616,1281.736,1509.3085,1487.6006,1425.5742,1131.6912,1409.0068,3371.9475,3375.0742,3328.9136,3183.552,3182.897,3143.755,3123.1287,3108.4116,3228.581,3099.9478,3093.8052,3118.463,3253.7944,3400.6814,3434.756,3995.8108,4456.81,4393.32,4698.0063,3956.3643,5090.7637,5303.4307,4810.7764,4375.563,4043.0737,3831.7473,3635.0037,3256.1704,3077.9744,3198.4888,3343.797,3096.4985};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_105()
		{
			double[] value = {2468.153,2576.4348,2567.4631,2531.6812,2536.271,2509.3774,2512.1094,2523.881,2451.9023,2399.6672,2293.875,2134.3992,1984.6459,1830.8505,1613.89,1419.5214,1290.6956,1280.7083,1894.7709,1435.9181,975.9954,824.51794,910.5358,648.2134,766.1689,791.92523,750.09656,743.76685,718.35767,799.61145,689.1098,640.4982,646.31116,749.7683,870.0153,738.6502,854.7641,800.7808,833.06665,682.8844,723.42194,681.4509,383.66412,-382.87723,-874.61383,497.3921,1020.08203,837.3099,602.32495,823.18994,795.8367,95.015625,703.6572,852.80963,848.69867,825.3379,745.3613,578.3521,497.75067,442.95697,464.64236,-647.824,-302.525,240.19737,212.37474,247.19112,344.03506,450.49432,355.56573,559.18646,592.13654,872.5066,1039.6622,313.51312,-329.22217,1008.87146,858.6139,795.4278,956.70825,1058.0466,1086.2924,1148.9457,1162.0994,1192.9386,1287.2001,1307.5533,1445.5809,1349.675,1249.9526,1259.8254,1144.6198,1471.1697,1504.8988,1495.0441,1183.5745,1433.5573,3321.8625,3264.9292,3249.6877,3214.5918};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_106()
		{
			double[] value = {3193.3179,3131.7822,3076.9458,3063.0552,3038.4915,3031.1885,3018.576,2988.969,3166.6887,3206.161,3316.1355,4166.924,5113.763,4813.016,4940.2734,4333.275,4997.879,4911.1587,4738.981,4537.1626,4357.1895,3987.8687,3963.4272,3705.0728,3537.7493,3784.1782,3886.462,2991.6843,2613.2964,2543.1018,2568.88,2533.7402,2559.3267,2498.3308,2436.5042,2393.1833,2322.471,2202.1052,2086.251,1976.245,1819.8866,1629.5588,1440.5519,1232.6376,1162.2383,1070.6907,1390.6768,1360.6366,1004.73083,886.7054,752.6595,790.6921,957.3543,873.27985,838.8852,788.1228,729.7266,652.8752,565.3606,569.5768,566.37177,660.62164,717.4031,597.0182,721.20123,773.73206,754.1008,711.2543,622.30255,513.37036,77.96444,-247.55344,-276.91058,468.26517,896.67065,921.65485,471.9808,817.03876,633.3135,600.37213,808.15875,856.9721,684.8887,615.5617,756.529,688.1116,451.20297,408.05426,485.28525,246.59334,213.47336,206.46895,171.0573,236.27174,269.40793,225.13063,435.74817,572.3166,720.00903,322.5454};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_107()
		{
			double[] value = {867.08057,939.10944,900.7352,842.35846,742.9832,724.0391,948.16144,692.9834,959.58905,1215.3016,1184.9219,1280.5543,1445.1641,1427.8118,1365.661,1432.7678,1413.0989,1610.1776,1366.095,1441.7517,1378.5275,1465.6877,1452.6724,1431.1145,3319.8083,3245.8896,3212.0015,3193.968,3139.2356,3099.6514,3061.2317,3008.3313,2965.665,2920.8767,2981.6487,2886.9805,2907.1562,2908.4868,2991.7273,3688.8257,5222.974,4324.693,4719.8706,4704.842,4774.6147,4632.23,4576.581,4329.338,4274.0996,4263.927,4391.434,4302.643,4591.3687,4452.0166,4353.2075,3657.9192,3295.2563,2961.8696,2782.7358,2594.963,2769.137,2526.2395,2358.144,2203.0505,2114.2593,1978.9114,1893.5769,1734.6217,1616.5312,1409.3391,1213.4371,1112.7418,1048.2001,998.71454,1031.2615,1044.694,890.2103,810.23724,720.1587,764.2033,812.7109,819.8764,830.6318,697.40515,526.89514,319.53012,573.73566,593.0912,527.09766,582.9362,661.3554,669.3862,696.96655,674.072,743.03485,725.07745,575.3958,363.49768,-306.7757,-1066.4735};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_108()
		{
			double[] value = {-313.2583,658.6251,916.53467,944.8462,1158.5044,942.58356,614.4185,591.795,779.5301,665.4066,785.18036,728.2721,683.5849,603.5309,458.83994,436.82422,541.7021,360.62482,215.28102,95.78412,168.64166,-54.755432,110.24194,-804.8971,40.17318,480.5932,602.5134,549.7566,645.2912,689.6774,305.34482,773.0902,657.08435,662.90796,1002.0326,949.2642,1153.7809,1168.0845,1250.0638,1300.0887,1520.5175,1513.3589,1528.3768,1666.1688,1633.622,1584.1449,1508.1228,1473.7062,1433.5193,1433.4567,1410.0853,1484.36,3264.2634,3224.6929,3168.4922,3129.9836,3081.4565,3039.185,2982.9192,2940.7642,2915.1548,2874.3074,2859.0645,2837.2236,2818.145,2810.498,2786.2327,3106.9402,3897.1829,3682.4885,4093.4756,4593.9565,4619.63,4542.9956,4360.908,4006.3464,3811.5088,3953.2783,4159.6763,4297.94,4896.0273,4826.803,4845.722,4834.5938,4483.446,4043.3896,3565.7117,3401.6013,3043.5188,2511.708,2371.911,2242.5256,2150.7075,1969.7594,1802.0317,1640.3948,1447.326,1196.9402,1054.8583,963.95526};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_109()
		{
			double[] value = {929.36066,864.3815,892.48236,886.893,863.11316,792.73376,814.5318,844.4004,821.1967,857.05676,981.2301,679.15894,476.4729,178.1027,607.7431,707.85583,634.7431,659.7393,574.58276,573.9817,617.6527,674.4622,773.90186,717.9873,582.80273,195.85707,-525.90796,-907.4177,212.95778,926.81696,640.77124,-761.20966,-60.718563,857.3314,674.8248,669.35425,644.5441,709.40125,587.1888,582.59216,604.62634,522.7045,293.70035,63.549908,618.48956,465.61972,112.518364,-412.1823,140.12256,-26.516144,35.118324,121.91816,336.41425,377.32373,507.90942,583.6655,416.98203,428.36246,393.2744,458.58096,515.7461,892.02454,989.2181,968.3737,1141.523,1046.919,1285.465,1433.5554,1545.5599,1353.7341,1333.0746,1432.4703,1511.4403,1601.6027,1588.4238,1532.0109,1464.5975,1431.4568,1406.7506,1408.4159,3405.5413,3194.3481,3152.6162,3115.5881,3053.177,2987.5635,2922.6301,2897.2625,2868.7969,2831.6375,2802.795,2791.463,2789.8447,2790.8296,2772.145,2769.9336,3029.377,3123.9636,3483.0933,3964.0842};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_110()
		{
			double[] value = {3999.6084,4057.9517,3949.4639,3710.441,3698.648,3656.4111,3748.7234,3872.7092,4337.5537,4568.9233,4744.0264,4976.907,4499.2896,4250.6113,4012.1501,3814.9824,3039.7202,2423.4385,2408.8738,2374.1484,2220.866,2036.209,1904.833,1659.6613,1377.017,1133.9929,919.145,862.204,812.8532,791.177,798.6659,819.9647,878.9633,868.82227,992.15106,1043.9037,995.42334,970.79913,946.9018,846.6676,827.6562,884.02844,838.86566,859.1468,793.2177,608.3799,536.92346,537.7844,589.666,643.9193,660.77985,587.4318,469.15768,159.89052,-317.41962,12.412856,643.8448,594.56256,528.23645,8.570501,355.44324,72.294846,443.06564,404.20712,347.57587,401.61475,276.4758,500.87354,500.54477,453.97314,479.17136,479.1109,646.4717,421.96057,116.91155,116.23328,71.02869,0.400344,9.219638,-28.557817,180.44174,220.29382,69.62747,182.11713,158.48756,354.85843,327.9526,389.83807,624.7193,733.57587,886.29156,712.395,1040.6531,939.5164,1203.5704,1365.1709,1523.0677,1339.9651,1329.4283,1506.7876};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_111()
		{
			double[] value = {1524.843,1679.7991,1723.8364,1630.8336,1637.9445,1512.4814,1462.0868,1492.7173,3231.2285,3183.9065,3130.873,3047.7615,2986.0881,2927.9988,2890.0854,2856.5837,2803.904,2789.1558,2742.48,2734.7988,2755.8972,2853.5652,3025.6934,2903.2222,2913.42,2760.3823,2887.0156,3198.8018,3470.1418,3587.8276,3533.9077,3579.567,3548.711,3560.6807,3603.6724,3713.253,3840.4395,3974.902,4003.032,3771.5261,3568.0989,3452.4282,3416.6587,3395.1267,3276.7458,2846.1357,2641.7078,2471.624,2258.9868,2135.7666,1968.6129,1767.4308,1532.8234,1217.5691,925.6698,819.837,750.94293,764.4757,749.3398,774.0411,822.9589,1009.5352,214.73306,-703.4575,827.9613,808.34875,751.22815,924.2387,1084.2288,1030.787,944.9181,920.71625,664.7295,575.09863,543.7067,565.5332,563.6893,559.11066,518.59875,459.98898,382.75018,449.8033,443.62814,-670.8658,-577.6263,60.355576,512.5246,587.1756,577.2932,512.71155,559.36053,402.19064,372.1885,198.32602,77.99102,516.3205,422.00504,350.2883,219.74594,326.84375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_112()
		{
			double[] value = {370.4512,271.6211,154.36012,91.67432,7.415799,-15.256419,-30.069738,-64.94409,42.470036,139.61183,78.540985,60.085922,345.09512,287.77148,207.78719,338.1142,205.98692,627.62933,770.45245,922.0863,945.5338,1081.8417,1199.7671,1298.5511,1381.2621,1150.1903,1220.4143,1423.5281,1352.2913,1469.0017,1396.4302,1681.9363,2082.9875,1565.9263,1723.3339,1646.0121,3179.8555,3077.523,3040.3813,2997.2024,2930.6577,2892.1558,2822.7021,2799.3958,2769.3042,2727.1438,2712.6487,2708.8228,2674.1765,2724.2825,2938.9272,3114.4905,2918.4346,2596.0198,2630.9854,2874.0754,3139.7195,3354.6733,3319.6897,3346.3772,3411.7559,3446.7776,3520.3464,3448.9585,3121.0496,3253.927,3233.2346,3081.892,3065.9014,3006.1377,3032.89,3032.6472,3061.6729,3068.51,2953.0051,2758.8364,2589.2405,2481.6228,2578.8894,2527.167,1985.9603,1501.1414,1204.5043,935.09076,770.4344,710.37756,721.9143,708.2424,743.8676,898.90485,376.93686,-102.624054,832.7118,717.61084,695.59076,757.71173,823.3383,850.1865,749.10815,638.90094};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_113()
		{
			double[] value = {591.3714,556.4989,562.1793,577.7264,564.35706,528.6531,476.28485,482.69897,639.2297,711.4231,577.9993,125.0064,-435.62506,-230.29308,319.44412,207.46587,137.49846,146.5411,223.03413,317.0982,449.24783,381.77362,123.56329,280.8627,94.53164,202.50385,169.84833,197.01874,147.30212,-91.34554,-244.65305,-117.84849,-69.540184,-34.350426,-50.65774,-115.62154,-177.76367,-1.776244,-135.42729,-33.178516,128.35951,220.06755,106.0823,165.50127,473.16586,599.7118,632.8041,776.8243,968.07324,864.41095,974.5336,1149.1926,1198.3387,1265.4331,1188.5773,1074.0001,1201.6449,1367.8389,821.77106,1421.0886,1588.0698,1688.926,1710.358,1629.1057,3178.3074,3076.2815,2985.1902,2927.0864,2899.771,2871.5596,2805.1519,2747.4985,2717.0205,2683.1409,2626.0464,2640.6785,2636.2998,2607.765,2653.143,2644.6648,2561.1567,2467.8474,2465.5227,2498.435,2729.1028,2936.032,3002.7766,3121.7927,3445.138,3451.2717,3287.18,3159.1042,2579.3157,3117.137,3061.315,2947.8547,2880.0789,2878.4485,2891.121,2921.6033};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_114()
		{
			double[] value = {2933.4177,2970.8115,2944.958,2913.049,2893.2708,3117.4207,3633.2463,3306.4287,2624.6885,1916.5443,1491.2167,1150.8864,849.2188,692.36755,674.6716,642.01404,668.8207,777.1156,798.59094,745.21185,672.7401,662.4497,673.5067,642.6175,615.33563,567.80005,515.70013,504.79883,477.3686,556.43976,552.90735,595.7371,713.2106,712.09753,682.52673,614.2558,693.33997,775.5528,-114.091576,-685.03656,179.5342,-443.1488,-363.91992,-626.59625,-216.47577,-219.011,-63.175556,84.2624,359.5532,569.52484,438.54034,142.07292,240.35968,173.2487,25.161337,148.27983,121.25847,-122.425316,-320.77847,-238.62155,-95.60107,-94.333824,-184.73051,-134.79268,-241.83293,-289.67105,-170.70677,-169.06662,14.876183,64.23467,140.07925,234.4387,334.3267,551.62305,429.88974,615.28125,826.3249,892.51025,1026.6267,1076.5032,1059.9579,1037.7964,1055.4062,1018.81903,931.2979,1055.3779,1214.4487,1464.216,1577.7845,1528.6929,1535.5914,1477.3129,3179.8513,3097.9407,3004.3801,2934.5698,2904.8245,2912.839,2837.4224,2755.261};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_115()
		{
			double[] value = {2727.509,2696.6375,2629.4766,2612.524,2604.18,2585.0752,2557.0784,2527.4573,2490.469,2456.887,2421.182,2418.9934,2452.673,2605.783,2703.1052,3028.1401,3311.1604,3501.124,3562.96,3397.1445,3236.4841,3157.582,3009.8948,2925.9463,2869.464,2871.1108,2880.553,2792.8206,2812.355,2890.854,2888.4216,2853.0454,2867.7417,3004.134,3297.9214,3431.1768,3054.0442,2447.6587,1743.6837,1305.9199,914.45856,659.5157,595.8228,617.0333,649.2179,660.5254,746.669,681.47925,634.871,695.128,729.88477,665.5622,589.1034,523.3184,537.109,463.58112,228.72997,650.9072,712.1346,806.3811,837.01416,828.40344,786.4348,808.963,802.54803,917.62976,656.23596,602.859,629.5284,-903.6142,-2200.2766,-2152.9192,-1615.2345,-749.0405,-662.66125,-255.49745,120.18308,448.58908,129.77711,-1203.6313,-217.70012,-92.04119,-206.02628,32.305748,136.08517,-106.39707,-283.71307,-223.26784,-197.60847,-264.8065,-248.02502,-213.36949,-232.45795,-357.65546,-278.3153,-243.47937,-138.65585,-44.808083,-26.845121,53.705204};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_116()
		{
			double[] value = {178.23036,365.33337,365.8461,476.31934,559.67114,582.9757,555.5584,748.70966,835.0753,731.08887,628.96466,838.3191,826.4793,777.5578,991.6893,1352.6893,1496.9302,1460.4349,1485.8556,1573.3337,3203.946,3144.4604,3092.173,3011.4707,2890.6992,2824.664,2831.5295,2773.746,2747.5457,2724.667,2650.1592,2650.6694,2625.4573,2627.3533,2554.3179,2476.536,2439.3364,2414.8203,2385.3184,2402.4443,2441.933,2599.1902,2668.6714,2993.9158,3425.8809,3700.9246,3772.9465,3578.289,3366.4658,3157.92,3016.3167,2940.3713,2876.1545,2791.336,2782.4734,2774.0076,2807.9668,2756.7825,2686.456,2734.7058,2737.0718,2779.6804,2780.1802,3335.7463,4077.3188,3174.5781,2126.8596,1225.3405,977.7216,806.51996,733.0682,748.44025,734.5088,712.7054,721.7946,762.4526,736.0669,643.2184,689.09717,602.3739,431.27762,530.7229,705.08527,771.33105,892.0543,912.03174,949.292,994.42413,869.60095,944.4192,893.79175,819.1493,792.86646,759.0606,685.43066,793.0467,771.72754,-876.87897,-2159.0342,-2215.6006};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_117()
		{
			double[] value = {-2012.6499,-1306.4042,-1405.2358,-1179.6116,-430.11502,82.03553,245.64078,-278.06827,-67.63434,-217.08896,-416.57132,23.986645,-33.912548,-334.40555,-112.39862,-116.31084,-224.2431,-339.91364,-330.61844,-281.1693,-302.40582,-380.32837,-322.4602,-298.80695,-962.31616,-454.77768,-45.881065,19.160288,59.395657,135.6727,203.31586,328.12158,561.9061,783.0823,874.58136,818.7889,728.11163,565.5855,464.49323,603.0428,685.2018,769.2272,687.8968,956.0937,1074.0255,1307.9979,1021.2408,1061.3263,3259.7236,3180.8218,3113.666,3095.5525,2957.007,2832.8647,2834.392,2830.6812,2781.8442,2731.3406,2701.632,2687.3833,2651.278,2624.328,2564.744,2467.491,2422.757,2413.007,2415.044,2432.1597,2522.3386,2694.0537,2703.707,3001.7397,3437.0198,3800.485,3880.4473,3712.6987,3474.712,3160.6516,3034.1245,2954.1746,2869.5715,2803.7834,2738.9163,2672.6677,2695.3945,2710.162,2713.247,2736.571,2774.72,2853.4827,2694.7805,2942.4495,4553.4985,3652.8997,2522.7366,1453.6794,1139.1816,948.1066,923.80536,955.87537};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_118()
		{
			double[] value = {902.13,865.9379,737.7784,783.6344,845.7748,760.8177,719.81396,594.876,642.31177,751.86237,1043.4015,1259.0442,1323.8243,1195.1782,1071.511,976.98663,899.95776,882.55884,874.4771,827.3829,812.7726,736.25476,756.1766,833.10956,908.0741,132.43848,-1409.7817,-1980.5935,-1148.0472,-1379.6022,-1667.2626,-1507.494,-1011.2083,-542.59485,105.71288,-76.1143,-89.705505,-58.9711,-401.55206,-542.5812,-724.13745,-315.8096,-543.2706,-447.06534,-215.14851,-435.09,-470.447,-541.19867,-443.9049,-366.4342,-270.9381,-420.9465,-331.40146,-144.45305,-85.290955,-93.72867,-42.096966,-14.647146,73.3396,-574.63855,77.53403,727.93414,661.5594,605.94,543.2738,484.445,341.04288,328.06393,530.62305,683.72235,472.12305,725.245,939.03973,1380.6344,893.05286,621.0077,3387.5234,3286.9849,3184.2603,3109.585,3033.6614,2899.5437,2818.0513,2807.122,2776.822,2728.8533,2712.9746,2673.9246,2632.1528,2615.021,2604.502,2526.3254,2432.0583,2387.8655,2411.534,2437.439,2479.4697,2552.1597,2557.1597,2916.3738};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_119()
		{
			double[] value = {3367.667,3775.2617,3807.0798,3756.4446,3517.3079,3255.7354,3054.7837,2987.1238,2883.6204,2795.3984,2772.387,2706.0708,2697.8835,2740.9272,2768.418,2887.857,3022.0044,3153.4004,3352.8472,3524.4326,4297.7456,3708.829,2219.413,1407.3062,1192.5442,1050.4717,1013.7506,991.6313,987.9908,1007.22217,1032.0435,802.657,859.2371,806.8809,740.2582,784.34485,823.7925,1048.6027,1303.9668,1466.1699,1398.9865,1281.0507,1129.5774,1012.26746,934.6777,897.08734,859.3153,862.5382,844.0296,718.6789,763.795,797.4359,826.4985,705.56104,95.94748,-373.61374,-834.3872,-1280.8055,-1696.1497,-1654.4869,-1398.2759,-930.74316,-531.9348,-208.96317,-459.54175,-775.10205,-401.76788,-582.2187,-582.523,-321.3409,-1141.9202,-896.74243,-311.35303,-687.318,-730.0348,-397.41693,-405.1289,-327.77698,-969.4149,-194.7774,-574.49603,-1051.682,-867.9084,-212.9716,-116.780624,-134.82695,-85.28274,-132.94852,-325.08032,313.19458,505.8002,504.83435,443.19308,330.15002,163.86505,266.7564,303.94458,246.05214,219.8888,558.1279};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_120()
		{
			double[] value = {823.31195,1151.5692,869.61554,869.3039,3445.8374,3384.2856,3272.6565,3167.7253,3072.4866,3000.0796,2927.2246,2799.32,2733.8716,2742.1458,2710.4216,2685.5125,2599.3162,2577.5989,2563.723,2592.9956,2458.9763,2397.5908,2391.1255,2379.388,2404.4463,2399.363,2372.593,2768.7126,3399.7705,3580.1272,3698.004,3645.453,3384.7192,3234.9995,3089.7166,2972.6184,2895.6018,2838.7458,2860.5107,2656.195,2728.093,2760.6729,2825.273,2974.2024,3126.6082,3280.3657,3538.0667,3815.202,4315.911,3487.3025,2016.4554,1358.601,1210.0073,1114.7014,1065.9093,1041.177,1054.1938,1063.5769,1242.2013,942.1498,880.9254,947.97925,953.4259,929.43445,894.08295,1053.7137,402.46436,1106.2991,1232.6023,1250.2124,1055.3077,960.55383,919.9595,920.4565,937.10004,901.16003,780.23956,798.62006,837.8152,758.2001,715.49896,438.5615,-134.13771,-769.95496,-988.6788,-1085.3389,-1584.7092,-1606.1022,-1384.034,-1337.1831,-835.4502,-758.66315,-646.43915,-580.23016,-328.997,-542.31665,-642.16266,-556.58685,-39.61478,-153.52986};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_121()
		{
			double[] value = {-357.3823,-886.80774,-908.5799,-632.5298,-547.58923,-342.10147,-351.23642,-258.17563,-563.9391,-595.0328,-328.27457,-642.2192,-1243.5765,-391.91113,-711.25977,-662.94476,103.03158,184.64113,322.21222,436.44135,116.34779,198.49896,-60.820736,-16.145588,-46.09546,-4.526082,183.78276,503.24033,827.8071,1150.1678,842.6267,817.32025,3544.7332,3459.644,3379.8225,3308.6704,3172.6223,3113.2488,3085.7969,2859.7422,2755.6487,2766.8093,2712.0117,2672.0684,2604.2422,2589.6807,2577.1106,2522.5486,2350.1887,2399.5325,2360.7705,2319.9336,2299.2039,2357.2205,2327.9763,2537.077,3147.5999,3397.7412,3309.2021,3537.5571,3396.4844,3244.417,3130.79,2992.7375,2893.547,2873.3047,2904.7192,2834.0327,2765.4382,2836.0024,2956.2263,3092.847,3220.248,3237.6667,3378.7732,3902.842,4362.54,3580.0742,2247.8591,1448.9546,1243.4442,1142.9762,1125.6517,1109.5903,1105.5361,1092.9454,1264.1621,1242.0596,1175.5914,1180.8156,1096.7363,1078.758,908.0702,955.493,1143.507,1339.0391,1201.0402,1076.0555,865.5951,876.07153};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_122()
		{
			double[] value = {857.23645,931.1662,1062.3208,1098.2788,894.49,609.09424,532.301,694.1287,615.69617,402.00507,70.18484,-348.03928,-569.5908,-861.1469,-991.18335,-999.1202,-630.1395,-864.0462,-1342.9762,-1096.6846,-315.244,-317.41992,-470.91794,-574.68506,-562.3975,-822.1571,-659.5732,14.890432,-277.4368,-725.51996,-982.49176,-824.3813,-566.1642,-769.4781,-446.54453,-454.59622,-396.2489,-502.99942,-541.8119,-807.90265,-1477.6578,-798.086,-716.1587,-395.81198,-219.97874,-14.015046,97.40494,379.32706,374.06845,11.243518,-158.26678,-149.59569,-101.21441,10.824184,134.38069,374.872,669.8949,1438.9934,1083.031,827.40594,3615.099,3529.652,3444.2476,3388.6072,3318.8179,3184.428,3127.715,3009.0088,2874.2214,2794.8367,2765.8037,2712.9507,2695.9512,2615.866,2653.615,2577.9177,2538.9368,2381.0637,2337.4453,2314.2266,2276.2998,2300.1333,2374.182,2455.778,2916.2014,3212.5183,3336.0732,3354.7527,3326.752,3264.1726,3172.8335,3017.285,2962.6523,2976.1301,2960.7786,2914.1284,2844.4697,2881.8909,3029.6294,3184.7122};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_123()
		{
			double[] value = {3287.0823,3245.2048,3319.0396,3602.5518,3974.3372,3868.52,3115.7249,1741.6449,1300.5232,1164.9181,1135.4927,1135.1044,1150.7375,1232.4729,1350.8025,1435.8218,1445.2316,1443.2122,1093.6818,932.5426,841.3608,856.09686,947.0553,1028.5371,1029.2753,956.3169,875.38696,863.1592,843.3365,1003.4812,590.2216,-10.043266,703.5505,659.219,709.11743,686.95404,614.5088,426.0636,290.8794,22.066113,-122.2257,-290.7268,-431.8988,-399.93964,-268.39722,-446.0775,-1313.6865,-880.639,-400.2562,-386.0227,-468.1566,-608.3639,-655.1757,-789.7798,-793.53394,-346.86435,-418.91968,-726.8541,-923.94183,-905.2907,-635.1731,-481.02075,-497.95285,-623.3478,-555.7295,-605.6022,-647.15295,-759.98035,-963.0578,-1150.5798,-1115.3702,-880.49976,-507.1761,-112.96259,188.43538,346.0946,188.67345,-114.12874,-194.91403,-172.00558,-140.30486,-117.20512,-83.75343,163.78223,510.3486,1212.5759,1758.9093,1309.6725,3670.965,3608.393,3524.3315,3434.242,3382.7908,3319.8733,3229.1826,3150.684,3036.774,2908.381,2869.178,2809.6833};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_124()
		{
			double[] value = {2771.6125,2704.8574,2658.543,2695.8726,2581.5334,2517.4995,2375.1594,2307.2778,2304.569,2326.067,2383.8079,2492.4321,2856.8699,3136.0535,3206.4204,3298.3032,2998.9312,2736.5464,3261.663,3125.1018,3086.7378,3118.6802,3080.4453,2949.0098,2880.9006,3007.726,3116.427,3255.249,3290.8047,3260.2847,3335.6177,3408.2908,3552.6113,3965.8713,3646.6133,2266.7239,1402.3351,1165.5358,1145.6769,1156.1022,1215.8649,1298.1094,1381.9701,1591.4003,1592.8633,1337.7869,1189.5543,1008.7192,865.39453,875.91394,867.1734,887.5704,896.94696,891.0253,885.6848,909.8933,873.9317,1081.5155,-224.98235,-1386.0549,139.26923,972.1516,1464.8282,878.4623,622.8771,479.22562,277.61667,144.49799,139.12007,5.869308,-156.76787,-372.36957,-395.59814,-986.92035,-1493.5068,-493.6824,-582.12286,-594.39795,-461.89487,-586.2526,-627.3819,-830.4542,-1018.91943,-1110.9218,-911.6012,-670.4847,-936.26227,-947.5971,-860.8285,-675.48083,-575.9177,-717.6195,-587.8552,-671.03955,-682.27,-953.60315,-1155.1798,-1267.7166,-1280.5553,-1125.2694};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_125()
		{
			double[] value = {-556.26624,-311.62936,-838.1858,-100.8917,234.94585,-160.1274,-197.26018,-204.1079,-172.28387,-202.58534,-45.789146,111.712746,396.81937,773.1991,1547.7499,1756.6583,3807.973,3736.4658,3623.4595,3526.2214,3450.8235,3389.5598,3280.3325,3190.3489,3138.9026,3019.82,2938.8843,2890.6643,2805.586,2772.965,2714.8967,2674.3064,2610.1216,2559.3567,2443.9968,2388.155,2396.9617,2407.811,2453.7356,2525.3633,2890.1663,3177.9146,3243.3025,3278.9526,3060.157,2781.3975,3285.2388,3252.4036,3296.2205,3251.0886,3173.59,2984.2646,2938.9055,3183.7532,3344.34,3582.421,3719.162,3707.1963,3741.1702,3550.7095,3691.634,3812.8599,3442.684,2211.4363,1461.8953,1266.0326,1229.8202,1192.2887,1327.6421,1379.2197,1370.3154,1385.2836,1567.2351,1453.2754,1225.4938,1044.8978,999.05585,946.95886,953.1905,885.1468,882.6332,904.67926,833.3211,733.9379,818.14307,921.9661,1222.6111,467.9207,602.8308,453.86078,529.5114,938.4641,367.43182,481.82977,272.49637,80.34159,-23.8148,-240.0729,-604.0758,-976.86676};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_126()
		{
			double[] value = {-1495.8445,-1812.8184,-1582.2815,-1390.76,-1196.032,-743.3339,-545.8407,-627.1175,-677.8501,-925.8682,-944.5859,-1115.4617,-1160.0349,-1033.6793,-1070.627,-921.10175,-857.0587,-642.52264,-720.9817,-785.43945,-709.6576,-705.2737,-785.03156,-846.4681,-999.71204,-1163.4557,-1167.3345,-863.139,-404.34634,-593.5615,-919.58215,-255.90308,196.31323,-157.46835,-216.43086,-172.9782,-165.82741,-228.49164,22.543118,186.23358,329.6959,521.82666,948.6399,1131.0338,3947.7307,3829.612,3726.6199,3656.3633,3516.0676,3420.0513,3369.1245,3282.0376,3180.4717,3070.1826,2966.7727,2927.3135,2859.811,2817.3513,2789.6118,2712.6858,2624.8774,2591.3765,2514.0762,2449.921,2492.3047,2474.914,2512.2385,2544.952,2926.2817,3173.3052,3286.3618,3273.839,3282.295,3348.7412,3376.7925,3411.0122,3442.8408,3113.6597,3303.075,3033.338,3076.7483,3532.4727,3966.886,4214.76,4062.9534,4025.7368,4199.368,3552.0752,3507.5112,3394.5974,2992.7922,1948.5238,1491.439,1367.6233,1370.0114,1342.6902,1451.439,1476.3857,1477.7645,1487.8143};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_127()
		{
			double[] value = {1550.032,1439.397,1259.7623,1116.4719,1176.0964,1022.7213,710.1261,952.4322,902.4153,890.5208,824.6582,749.0441,739.91364,796.3744,1372.2649,795.7965,492.0138,482.7185,461.08438,667.55225,629.89014,950.9346,726.6859,277.58276,-62.413174,-676.58777,-1134.1982,-1700.3293,-2049.3796,-1963.995,-1994.285,-1885.307,-1578.511,-1257.6273,-815.27325,-949.9614,-878.7365,-862.6316,-792.67645,-1109.1166,-1295.8787,-1070.6434,-742.2232,-955.71234,-834.16876,-808.7154,-777.74567,-877.2603,-885.7613,-780.49585,-637.2062,-666.82104,-831.1694,-989.66656,-947.11255,-674.5123,-280.3962,-310.139,-512.2963,-457.0466,-57.404152,-79.593254,-197.89243,-191.94069,-244.38293,-38.09744,-223.25002,-292.06644,258.07565,316.41382,484.13733,674.65753,4076.607,3966.2214,3832.5488,3529.8044,3461.345,3483.1013,3430.6284,3364.8071,3241.0254,3107.7683,3017.226,2979.2314,2988.8455,2851.1753,2816.2573,2771.0386,2692.337,2669.249,2576.4387,2485.6929,2513.99,2517.5452,2540.6736,2565.769,2830.1711,3053.4363,3176.3564,3213.988};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_128()
		{
			double[] value = {3300.205,3340.8823,3421.887,3438.4363,3494.4277,3608.3508,3368.9055,3223.4802,3125.4194,3353.8345,3732.2803,3804.0522,3588.3337,3706.5645,3816.3662,3454.5237,3390.4578,3268.5278,2733.6348,1761.8325,1516.8862,1489.3865,1494.6456,1526.9731,1539.8986,1539.8916,1566.9792,1554.8016,1556.2391,1372.9695,1192.5524,1179.8519,1046.4943,1036.8203,991.51447,914.07825,897.6958,923.4463,813.5796,783.4505,726.29266,822.8214,1327.5837,808.2121,480.71515,438.90234,416.07205,426.6241,764.5618,411.23947,433.08325,335.6361,110.43442,-1126.2368,-1657.2335,-1960.0125,-2037.0443,-1962.796,-2106.7642,-2146.013,-1783.242,-1697.9076,-1374.5016,-1026.9172,-791.2819,-658.0109,-995.032,-1296.6526,-1222.6156,-1059.3988,-715.13184,-1288.7695,-907.5438,-831.6911,-767.8574,-843.3354,-761.99146,-790.06256,-571.64154,-631.72766,-1005.43115,-693.65894,-731.6965,-319.23398,-439.13477,-579.54034,-820.469,-616.39966,-517.6209,-251.52542,-179.74425,-175.01031,-177.65811,-154.5371,-273.54575,-292.45697,185.87158,175.57076,45.163784,283.7048};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_129()
		{
			double[] value = {4190.1533,4055.8435,3926.7156,3802.6094,3695.299,3598.508,3509.1843,3449.872,3391.4395,3234.4978,3111.574,3019.547,2977.2634,2931.0125,2920.5735,2829.8218,2767.5469,2668.3142,2711.0457,2625.8042,2581.1194,2570.8647,2562.718,2603.4058,2647.8457,2859.453,2965.0564,3142.2725,3301.608,3382.583,3432.901,3426.7266,3525.7383,3581.9846,3557.613,3414.8945,3245.816,3298.976,3345.32,3403.0703,3400.9597,3515.2527,4110.032,4026.3352,3625.3042,3377.8613,2518.6812,1729.9231,1557.206,1538.649,1600.5431,1628.9087,1646.3833,1680.2238,1547.519,1405.2941,1347.4154,1284.6423,1213.7965,1062.4053,686.0485,809.6504,786.76013,750.4049,689.03876,879.5056,835.2877,902.2995,782.1927,867.73303,1254.5653,1100.0487,522.5568,416.52133,422.46753,425.3031,537.79785,95.21643,-263.92383,-388.4099,-966.803,-1816.0599,-2063.4575,-2027.4523,-1961.5554,-1982.972,-2051.3323,-2062.5034,-2026.1249,-1883.7361,-1394.8438,-1016.0596,-707.12494,-720.01373,-1044.4087,-1364.2412,-1233.8605,-1068.1788,-1646.5189,-2812.8467};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_130()
		{
			double[] value = {-1277.287,-955.5499,-1226.9208,-946.81433,-886.1857,-896.64075,-1287.2196,-893.39636,-720.2363,-931.94604,-1529.1213,-1140.6415,-1121.3229,-1294.7769,-1675.4374,-817.98083,-721.64185,-491.57248,-335.89166,-203.33815,4.713284,-140.48859,-75.66772,-33.845352,-93.81431,-169.91377,-130.09319,101.809746,4308.787,4179.6465,4051.4873,3950.9653,3825.742,3720.8003,3606.2336,3509.1572,3497.3013,3379.867,3201.5024,3068.0527,2993.5164,3002.159,2964.324,2885.598,2865.8699,2735.184,2708.2178,2729.815,2690.9844,2654.7097,2610.3467,2621.9958,2604.4343,2764.8035,2897.3484,3111.63,3272.4138,3413.5107,3488.1313,3603.926,3788.6392,3817.4688,3684.3557,3489.784,3402.9663,3336.0735,3355.1423,3346.1917,3428.0515,3506.8105,4652.675,5027.5825,4069.1768,3568.5427,2330.1567,1704.3379,1595.7446,1596.1157,1701.5955,1762.2809,1765.0283,1736.845,1552.1595,1378.492,1248.5862,1190.374,994.78467,809.7586,496.7054,10.630072,565.21606,745.59973,531.5529,654.80304,714.4705,974.247,915.1672,835.80304,891.66907,639.5902};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_131()
		{
			double[] value = {1312.1023,820.48834,126.41527,511.67606,170.3247,76.26764,-313.759,-555.29645,-1025.1199,-2008.4688,-2021.8976,-2003.1316,-1935.8313,-1909.3407,-1920.701,-2023.1241,-2006.9053,-2127.6855,-2011.001,-1246.7914,-832.5754,-1210.881,-675.58606,-811.4957,-1399.6,-1062.7096,-693.8853,-974.158,-955.3081,-1071.1818,-1134.0665,-1116.6182,-1053.1086,-966.42474,-910.521,-808.9302,-934.4804,-1380.6688,-2184.635,-1299.9613,-1183.3287,-1158.1263,-1156.1459,-863.86237,-814.3499,-512.0094,-746.9896,-1095.1351,-318.4463,-161.46275,-318.31464,-352.62006,-371.60327,-342.66638,-131.67943,179.03722,4399.01,4280.566,4154.7646,4065.9883,3960.7275,3838.6382,3736.3826,3574.7432,3535.9814,3490.2253,3333.3186,3191.7349,3107.6587,3043.4495,3035.458,2972.2334,2946.1562,2833.7937,2788.7988,2847.7292,2801.1943,2743.6584,2753.2947,2695.8477,2699.4927,2803.1199,2976.9377,3106.0215,3273.5496,3430.3987,3588.9822,3774.9014,3922.675,3911.0715,3850.142,3727.2876,3438.3596,2693.52,3349.6836,3406.2727,3526.9114,3501.0244,4278.1553,4637.08};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_132()
		{
			double[] value = {3917.959,3217.3608,2216.789,1756.5723,1662.8405,1691.0059,1639.8695,1985.7521,1992.0123,1968.6206,1778.6022,1446.0875,1077.7052,687.4403,47.502735,-335.904,-1795.5365,-2588.5173,-1771.0123,-460.8712,335.26675,640.3315,914.5208,534.5113,607.43146,769.18555,776.8452,1077.6229,1141.1548,726.33295,513.3008,420.3501,191.33917,5.957919,-149.45561,-314.5552,-1032.0103,-1862.5004,-2084.4407,-2015.1188,-1953.5533,-1917.2035,-1955.4752,-1974.268,-2012.809,-1976.2826,-1446.6702,-768.2676,-618.0956,-588.404,-743.46387,-1077.6741,-1335.4554,-982.07416,-881.69196,-958.9463,-1213.7397,-1294.7368,-1233.6901,-1194.5823,-1112.1584,-1084.6681,-1037.2241,-927.0185,-1268.1908,-1246.1162,-1205.016,-1186.8893,-1162.6659,-1100.7617,-1065.1766,-933.8667,-815.8392,-617.0599,-623.33124,-942.2049,-599.4387,-496.08804,-617.61633,-448.67932,-380.92764,-366.1985,-292.713,318.0683,4569.4375,4437.8604,4295.133,4189.6714,4066.8228,3936.6216,3851.458,3765.4038,3653.9526,3541.0598,3406.7056,3310.2615,3229.7834,3222.4565,3170.9277,3130.2441};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_133()
		{
			double[] value = {3045.1956,2967.001,2897.5122,2946.8882,2956.9932,2912.4985,2890.1904,2798.9895,2800.0417,2960.7002,3170.0652,3227.5454,3356.0142,3507.0217,3714.5598,3936.8723,4035.3408,4109.0806,4114.1577,4016.916,3904.0266,3692.1318,3475.5808,3393.2866,3502.699,3584.733,3738.1143,3748.1946,3458.4172,3022.6377,2291.539,1837.9122,1720.638,1758.6754,1639.9323,2304.782,2235.3628,2002.2994,1888.0856,87.44232,-2232.9592,-2550.9634,-2990.4795,-2384.3608,-3498.7913,-3209.593,-3256.75,-2793.655,-600.95416,326.8492,529.2118,400.4499,422.96783,259.3795,329.52896,901.3748,1063.9513,482.21902,258.77127,183.47762,205.58565,79.48379,-40.575195,-201.88283,-615.7131,-1468.7963,-1902.0394,-2037.9769,-1978.6881,-1967.6111,-1942.3885,-2179.6985,-2049.609,-2013.2672,-1871.1425,-1355.9476,-1167.7988,-713.624,-937.4655,-1375.2682,-1314.1277,-733.9974,-973.04224,-1113.1871,-1286.3142,-1322.2761,-1284.3098,-1291.6838,-1326.7067,-1142.1713,-1079.7994,-996.4775,-1032.5968,-1187.572,-1218.0441,-1191.2926,-1148.2513,-1136.0043,-1072.8484,-882.9019};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_134()
		{
			double[] value = {-872.134,-762.982,-642.83093,-775.8371,-750.74585,-534.6892,-438.47552,-347.34543,-482.754,-336.3267,-115.10365,82.16263,4696.481,4540.5903,4388.961,4280.11,4167.987,4044.3694,3955.138,3824.1848,3723.1755,3660.2847,3547.6262,3464.0942,3752.0356,4204.272,4137.728,3299.9907,3158.6667,3088.4353,3045.096,2989.8323,3125.2478,3078.3787,2985.8208,2913.5117,2995.198,3206.2803,3409.2605,3490.251,3534.0283,3621.3428,3801.1028,3944.1091,4099.4336,4163.022,4226.9243,4150.9077,3796.0457,3342.5076,3578.568,3427.6233,3407.0056,3458.5088,3494.4375,3464.3132,3279.3735,2587.542,1722.1041,1697.7216,1271.7455,1512.702,2088.5247,1804.2805,1132.2612,1076.8643,834.13885,-1514.3812,-3147.7542,-3724.398,-3848.5984,-3761.0872,-3339.3215,-2698.048,-3236.3398,-3537.772,-3517.3923,-3352.5352,-3024.0212,-2502.6968,-197.40393,686.8573,859.7598,748.6852,591.50934,642.0005,416.022,436.70773,160.9028,90.891754,-73.50776,-212.8471,-556.8536,-1290.8662,-1873.1334,-1835.7804,-1889.0271,-1843.7795,-2012.3315,-2016.7375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_135()
		{
			double[] value = {-1988.1881,-2045.7843,-1621.6138,-1180.1661,-1209.1697,-921.4689,-867.0639,-1010.99786,-1325.3342,-1188.7296,-1152.1567,-1254.4504,-1404.141,-1431.2638,-1182.2242,-1232.7224,-1077.87,-1104.3127,-1135.4341,-1139.9337,-1130.2665,-1216.8105,-1342.4937,-1217.5796,-1147.0607,-1129.8094,-1015.8496,-871.2651,-768.96533,-791.87354,-781.3451,-757.0305,-667.12585,-550.23047,-570.72986,-379.99384,-436.24973,-358.31265,-211.80347,-110.831665,4801.227,4614.414,4453.772,4340.851,4220.5684,4112.9097,3994.6548,3871.9976,3828.2788,3780.867,3670.0447,3603.388,3761.0962,4099.802,4181.53,3560.176,3221.4788,3213.4802,3121.054,3119.8691,3109.7075,3073.6233,3014.7888,3101.9019,3252.2192,3434.236,3547.1301,3628.029,3625.2751,3667.592,3800.6392,3945.3125,4067.6697,4094.2097,4155.2583,4079.7295,3837.6929,3545.2358,3664.1008,3504.7222,3353.0557,3326.098,3115.7505,2712.2356,2442.7957,457.55093,-489.79095,-1264.031,-2909.7356,-2598.915,-1827.0483,-2534.0374,-3241.6807,-3173.8223,-3071.7988,-2687.948,-2782.9734,-3905.5886,-3956.915,-3755.543};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_136()
		{
			double[] value = {-3410.849,-3410.4543,-3596.7546,-3860.3298,-3681.5708,-3665.842,-3964.8838,-3880.846,-1192.4984,715.1305,1065.4197,706.05054,346.91043,317.4148,-10.996599,11.739054,-171.90074,-94.743805,-146.54018,-138.8011,-454.12503,-922.5582,-1307.8948,-1631.1198,-1609.7915,-1598.8226,-1721.445,-1794.3593,-1937.3793,-2121.546,-1970.9211,-1380.1146,-995.9803,-983.59,-992.5505,-1243.0839,-1303.0554,-1078.0608,-1391.7578,-1355.4082,-1405.603,-1347.1608,-1293.1708,-1215.5442,-1139.7961,-1090.0386,-1085.7499,-1170.8964,-1127.7549,-1130.2648,-1105.068,-1118.4457,-1123.3795,-1035.1833,-914.01263,-1008.3491,-859.64655,-769.60565,-788.3715,-801.3498,-623.79926,-643.5947,-823.317,-434.6138,-398.9795,-366.5056,-272.43198,-226.74847,4904.44,4674.5337,4519.4995,4384.7266,4280.207,4178.873,4087.902,3997.4094,3916.433,3857.9695,3744.5237,3703.3816,3651.0828,3667.1177,3751.478,3725.5635,3421.5168,3383.951,3289.1316,3232.983,3180.8948,3157.0325,3169.2866,3314.5442,3452.8438,3491.8015,3481.8708,3470.1365,3510.1458,3636.0754,3822.3743,4028.1436};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_137()
		{
			double[] value = {4134.666,4020.894,3506.7727,3273.561,3717.2764,3711.9294,3713.6833,3455.2869,2950.1401,1625.2975,2154.1843,2932.915,2109.0156,-103.43896,-4164.847,-4187.74,-2437.5244,-883.12555,-961.50726,-1988.5503,-3646.3777,-4484.1846,-4079.8357,-4102.952,-4091.6448,-3784.2585,-3163.264,-2946.198,-2689.7825,-2805.2815,-3627.3152,-3900.8206,-4186.497,-3888.434,-3842.468,-3710.424,-1462.6561,65.3009,988.7081,1042.5973,324.5776,-281.10822,-628.17914,-244.65222,-261.22354,-219.18442,-386.1673,-454.76303,-367.18787,-700.16534,-813.0395,-1132.365,-1381.2942,-1414.279,-1432.9099,-1436.2003,-1537.6766,-1677.0516,-1590.4598,-1880.8396,-1409.1162,-1398.7472,-1369.3405,-1415.0754,-1467.1384,-1315.5554,-1380.2006,-1282.4489,-1231.6886,-1156.0189,-1337.901,-1028.9385,-1077.4191,-1089.6475,-1036.5576,-1239.035,-1406.7231,-1693.9209,-1031.3351,-1024.615,-991.6638,-896.88245,-889.3746,-2413.1887,-1918.4774,-1178.6554,-743.8315,-681.13214,-676.77203,-683.17316,-637.1904,-415.7829,-392.82306,-336.16995,-356.45142,-252.41158,4973.3853,4745.799,4600.255,4509.288};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_138()
		{
			double[] value = {4424.1953,4307.6963,4214.93,4089.2466,3965.071,3929.8708,3825.2722,3768.4995,3740.608,3700.7058,3740.1277,3654.7798,3443.6626,3194.773,3138.4512,3298.6384,3341.1829,3383.932,3420.7275,3421.878,3316.1848,2696.7065,2136.0461,1869.4398,2578.5017,3459.3806,3495.0454,3407.388,3595.765,3350.466,2286.301,1661.6536,796.7799,-140.04053,1988.9382,2613.776,891.8539,308.2277,662.4905,-1345.2299,-4135.2095,-4690.773,-2872.3674,-2692.9824,-1237.9539,-1332.615,-1040.706,-1165.6732,-132.72815,-2710.4143,-4441.9946,-4225.515,-3646.8438,-2811.0293,-1361.2654,-1418.9216,-1679.1862,-1966.9733,-1806.9229,-2588.385,-3653.6982,-3013.7263,-3520.482,-3628.7617,-2433.3984,72.32769,512.47217,1096.8552,449.44086,154.79292,38.856155,-232.61664,-365.98788,-394.934,-434.90265,-515.69617,-636.4246,-672.1386,-924.2446,-1093.9106,-1172.116,-1160.1078,-1119.3008,-1246.605,-1277.5935,-1249.5408,-1203.6237,-1776.8256,-1969.697,-1936.2285,-1877.444,-1702.0012,-1566.0156,-1564.3118,-1425.4248,-1211.0758,-1233.6927,-1234.8798,-1215.5801,-1518.2563};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_139()
		{
			double[] value = {-1562.4208,-1021.17615,-1025.6088,-1120.2211,-1061.4745,-1100.1702,-1000.3694,-1001.08716,-942.1537,-857.2962,-903.1332,-1673.2361,-1435.3374,-1217.5544,-755.03577,-756.12775,-701.0399,-575.67896,-475.118,-444.62143,-429.16574,-356.85202,-249.63882,-346.00406,5111.405,4878.0605,4690.384,4569.172,4466.1357,4352.784,4262.1885,4153.7593,4044.9526,3996.071,3891.642,3805.2764,3781.5464,3804.7354,3798.3616,3733.7334,3568.871,3012.0105,3061.8958,3422.5122,3615.3906,3708.0205,3689.4668,3488.6287,1897.1372,-1645.9927,-2053.7163,-2336.1147,-1677.2181,1045.243,-266.57123,-1331.105,-1456.3389,-1076.0096,756.1682,1803.0917,1590.2902,-173.50606,-1530.6484,-2933.492,-4464.3535,-4552.144,-2955.726,-3773.2957,-3677.9631,-1522.384,1803.6921,1709.5242,2124.4485,2249.7512,2328.0918,2239.7102,1993.0753,878.16,-2942.3042,-3929.957,-3884.101,-2568.671,-2468.5044,-1608.793,-1142.3568,-1621.0408,-1994.9501,-2737.2788,-1385.706,-179.49464,138.90202,-2102.768,-3375.0015,-2970.5366,-2794.6099,-1018.57916,564.02246,259.20105,86.37537,-137.70839};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_140()
		{
			double[] value = {-263.37933,-342.08493,-538.4682,-651.29895,-670.3074,-755.6895,-847.56445,-932.77673,-1055.8917,-1092.591,-1348.7633,-1160.2319,-1230.5355,-1290.9406,-1366.1788,-1704.8608,-2141.2554,-2098.8542,-2069.8525,-1964.2708,-1646.7603,-1636.9287,-1553.079,-1291.0718,-1233.4475,-1282.1924,-1262.51,-1163.5654,-1261.3424,-1029.5292,-1101.5071,-1134.8915,-1007.23865,-1017.62115,-918.88074,-836.4221,-948.39905,-870.1192,-868.08624,-853.2087,-1009.60065,-1190.292,-982.90063,-949.5892,-772.03204,-493.37888,-504.88144,-393.00336,-560.36975,-711.9725,-417.7626,-668.9604,5132.3027,5018.706,4803.759,4627.0254,4490.251,4382.0586,4288.4746,4198.523,4099.1816,4020.3647,3954.559,3866.447,3890.253,3929.8057,3951.9878,3954.0454,3628.7358,3261.9668,3387.7087,3682.7024,3865.7637,3310.6033,503.34174,271.11295,-2088.5496,-1664.176,-1537.3296,-2115.8635,-3159.722,-3038.1816,-2404.8518,-2117.1982,-1269.4725,-1107.8649,-2312.7021,-2763.657,-3945.4426,-4462.5103,-4241.831,-2979.4011,-731.05927,68.80281,2624.6062,1694.3481,2563.5754,2590.0557,2519.981,2506.5562};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_141()
		{
			double[] value = {2491.566,2446.252,2423.048,2267.9312,2036.669,1904.3442,1507.0255,-741.5628,-3246.3687,-3382.799,-3317.1423,-3270.551,-2712.8,-2645.3489,-1838.5684,-1106.2333,183.0063,1368.6493,1417.5632,532.205,-974.9314,-3024.4958,-4088.958,-3446.9075,-288.81857,535.0478,191.42963,-161.72046,-483.74744,-608.6177,-555.2096,-727.87994,-803.97614,-855.7902,-948.1127,-939.83167,-1022.55426,-1132.9376,-1321.687,-1200.3187,-1304.058,-1380.0681,-1538.9172,-1867.159,-1912.6858,-2148.8333,-2293.3704,-2040.1208,-1969.3317,-1724.2351,-1732.1355,-1217.5162,-1287.5168,-1341.5728,-1317.1934,-1320.2521,-1337.8351,-1342.0864,-1254.3689,-1215.024,-1413.3214,-1562.4651,-1036.6157,-867.45575,-981.4237,-1218.2905,-999.2251,-1299.8435,-1074.438,-1225.1211,-1102.7954,-839.83014,-943.3029,-1142.164,-1221.0409,-670.1629,-863.1919,-1052.9363,-640.5136,-613.5981,4159.813,5141.4434,4855.8154,4654.0664,4516.1504,4433.77,4333.21,4258.127,4178.616,4106.1445,4025.5723,3968.8713,3978.926,4027.7083,4146.39,4120.423,3776.3147,3547.7944,3633.6462,3792.888};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_142()
		{
			double[] value = {3464.8843,898.5508,-1194.367,-1505.8707,-2094.4475,-2272.9817,-3241.1409,-4182.854,-4675.114,-4083.764,-3415.624,-3907.4976,-4550.017,-4605.1914,-4266.7163,-3102.4158,-1332.3542,166.60825,2082.1514,3550.8289,3959.4104,3768.4395,3452.3167,3168.7507,2944.6172,2830.8472,2739.961,2709.006,2659.164,2612.1995,2527.3892,2388.8357,2161.775,1955.8264,1865.6339,1799.4469,972.67395,65.3266,-1134.455,-903.1132,-1813.2606,-2729.5999,-1735.5996,-1447.4894,-853.1572,111.28789,461.64404,623.1268,492.11963,-1416.9365,-3663.4146,-3542.8035,-3015.532,-730.7557,143.8191,-57.25843,-1449.0425,-2511.977,-1490.7206,-1315.8624,-1076.2911,-915.2323,-898.79376,-853.2797,-862.39734,-956.1009,-977.7299,-1098.36,-1412.1002,-1484.294,-1614.8651,-1966.2584,-2117.887,-2049.8274,-2159.464,-2198.638,-2054.17,-1967.3632,-1888.2819,-1301.796,-1313.1376,-1255.5056,-1352.2356,-1397.098,-1408.7053,-1374.4133,-1380.2235,-1280.3092,-1337.176,-1618.2837,-1296.529,-1458.7893,-1607.0315,-1143.4052,-1076.2135,-1845.6698,-1254.7247,-1325.8297,-1264.5186,-1432.0192};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_143()
		{
			double[] value = {-1316.3444,-1265.0692,-1329.1061,-1080.1056,-782.17474,-725.2358,-660.15607,-520.82526,4372.558,5215.898,4874.896,4668.0347,4507.603,4427.866,4380.907,4282.9067,4230.6616,4153.0728,4093.574,3992.2527,3970.4072,4000.3022,4241.454,4163.949,3942.703,3719.315,3696.606,3852.0854,2348.0896,-1069.9393,-440.13193,-739.7393,-2723.3264,-3861.7532,-4583.108,-4750.6426,-4829.7695,-3803.9785,-4201.634,-4034.5674,-2140.7415,134.89456,2393.941,4032.6216,5359.7783,5210.1245,5061.5205,4582.934,4064.8862,3711.0596,3415.7524,3172.3992,2989.8037,2882.1921,2860.0308,2818.721,2806.6743,2703.013,2575.9087,2490.311,2308.0415,2037.2538,1809.4027,1791.8375,1922.0692,1981.9144,1948.8601,1901.0308,1772.4575,1138.0625,327.0819,-971.3394,-951.86743,283.5049,141.65042,1198.1432,1570.8132,-104.764145,-3562.5884,-3569.9146,-3937.5095,-3421.8506,-1215.7379,272.11755,-1375.7018,-3641.7678,-3627.4443,-2700.9414,-1691.0273,-1475.7686,-1241.5061,-1009.1152,-855.79755,-754.208,-1063.9122,-2143.64,-2725.3518,-1589.4775,-1544.0065,-1805.9017};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_144()
		{
			double[] value = {-2092.362,-2104.4824,-1734.66,-2532.357,-2330.933,-1877.3513,-1750.3734,-1353.8596,-1338.4164,-1327.4059,-1494.2572,-1408.4253,-1586.7917,-1409.3553,-1464.1665,-1411.1967,-1337.8947,-1133.7656,-1146.0482,-1416.6387,-1455.5087,-1239.1605,-1165.3971,-1158.9617,-1554.6903,-1522.3865,-1347.9048,-1439.7903,-1377.4971,-1429.6356,-1224.3352,-1196.7002,-1099.5598,-763.06354,-840.22723,-813.8287,5410.3306,5126.798,4876.7314,4658.4326,4514.2695,4416.1177,4360.4146,4301.0034,4234.659,4178.5444,4124.9253,4058.229,4006.2412,3985.8762,4019.9065,3933.9343,3811.4434,3767.86,3443.0623,3252.9568,911.87787,-595.2209,-788.368,-1606.6825,-3213.2424,-4459.2085,-4636.6313,-4800.7095,-4025.652,-2648.5002,-783.2334,2658.0498,4358.21,5053.915,5430.9673,5305.9644,5343.541,5128.705,4751.7646,4475.4443,3897.486,3530.5715,3298.6646,3120.5625,2976.5903,2910.192,2853.2979,2795.3293,2772.8762,2616.9302,2593.1516,2246.8552,2442.081,2080.6611,1089.4731,1682.9169,1744.6544,1811.1627,1825.8068,1822.6442,1702.5765,-293.22473,137.4353,1021.2986};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_145()
		{
			double[] value = {126.38145,553.9249,1244.8005,1242.4191,955.65485,-410.7192,-3668.5571,-4013.1838,-4017.211,-3781.4526,-3314.2827,-2831.9165,-3335.5544,-3868.037,-3824.0935,-3281.659,-2318.6726,-1629.6626,-1135.1299,-1077.4568,-1273.2014,-2268.961,-2812.2854,-3207.679,-1853.3491,-1364.8833,-1363.539,-1497.7772,-1791.8123,-2170.477,-2130.583,-2078.1602,-2204.907,-2108.4465,-2173.2273,-1768.6614,-1594.388,-1289.104,-1267.7605,-1429.2266,-1519.7083,-1449.3595,-1493.4471,-1492.8817,-1375.4603,-1242.521,-1359.8918,-1328.104,-1302.0615,-1265.7734,-1254.6422,-1274.3793,-1645.0555,-1573.4423,-1324.0137,-1130.3943,-1161.2694,-1182.1368,-1128.4912,-1024.7399,-874.90466,-909.3162,-844.93774,-834.68805,5339.4893,5105.3696,4886.603,4699.3774,4550.299,4405.644,4340.573,4301.094,4249.9604,4177.6567,4119.654,4070.3474,4023.113,3997.5312,3939.1733,3371.6133,3084.1577,2833.8604,-246.98694,-914.7115,-1569.7812,-2028.0171,-2620.4143,-3381.313,-3939.7,-4354.672,-4062.643,-3055.0264,39.72676,2962.735,3928.5308,4758.7764,4970.115,5246.151,5579.625,5482.591};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_146()
		{
			double[] value = {5074.4893,4973.7007,4679.7964,4024.2231,3524.394,3264.878,3089.1326,2952.487,2873.737,2810.7456,2766.8828,2727.3528,2592.1333,2232.3606,2383.998,2003.5212,2412.995,1978.5641,834.4653,1437.9169,1541.856,1679.6328,1744.4071,1708.1848,1606.5571,-1208.3014,-819.4416,1634.937,1241.205,592.76044,647.9072,959.71765,1026.0933,280.4396,-2499.2556,-4073.7244,-3947.2698,-3518.6113,-3375.3274,-4121.379,-4005.1094,-4104.8403,-3965.551,-3843.5762,-3598.0364,-2992.518,-1932.6736,-1190.1674,-1142.9012,-1649.5245,-2464.9785,-1927.5452,-1167.4813,-1229.2025,-1246.7306,-1458.992,-1944.8063,-2511.3403,-2324.794,-2069.9512,-2183.7334,-2200.2388,-2295.2373,-2423.5256,-1815.1199,-1563.8501,-1206.8754,-1234.821,-1521.7465,-1399.5752,-1509.5072,-1480.3458,-1343.4991,-1356.8948,-1460.1395,-1623.254,-1379.569,-1332.2539,-1187.822,-1194.9421,-1802.5809,-1941.5869,-1560.9573,-1109.397,-1158.8414,-1134.9174,-994.0542,-967.4462,-1093.6637,-1037.4432,-910.1442,-892.5416,5070.7783,5077.0015,4980.945,4737.759,4564.257,4437.4,4260.9146,3990.6516};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_147()
		{
			double[] value = {4201.93,4178.148,3891.367,3798.2832,3356.7017,2847.3486,2015.7571,623.3056,-1229.7554,-2244.7014,-2632.5906,-2357.122,-2467.2815,-2716.2957,-3373.4062,-3874.3845,-3930.4817,-3787.4988,-2199.8481,1086.377,3664.915,4178.9053,4604.0703,4816.5024,5015.559,5024.385,4613.9985,3794.3057,4415.8257,4392.139,4021.586,3010.4697,3145.1965,3017.2554,2876.9487,2839.4702,2796.1204,2728.417,2719.2703,2823.3794,2528.6023,2069.412,2179.484,2272.1846,1930.0847,1035.5441,675.7982,1323.0535,1098.9923,894.052,974.6234,932.9196,12.802682,-3020.4644,-1332.9894,730.47095,371.6035,-1114.4897,-1823.0558,-393.536,661.57745,310.2324,-1012.2796,-3409.3008,-4066.7366,-4062.4001,-3971.1426,-4085.4119,-4092.3496,-4151.034,-4204.334,-3932.6697,-3538.978,-2727.031,-2274.7268,-2737.5317,-1707.5853,-1721.3519,-2052.8076,-1599.9731,-1197.2532,-1481.2902,-1369.0542,-1860.925,-2244.9458,-2191.0205,-1945.7206,-2027.9375,-2156.7808,-2506.2976,-2566.3386,-2203.998,-1929.8062,-1678.194,-1487.1276,-1207.9065,-1482.2455,-1535.7081,-1546.6447,-1506.2667};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_148()
		{
			double[] value = {-1475.5035,-1540.9872,-1545.8865,-1549.6421,-1475.2759,-1394.8673,-1391.2681,-1315.1394,-1892.2386,-1885.74,-1852.3176,-1322.0564,-1102.6393,-1032.3486,-1008.79944,-1059.9473,-954.79706,-867.2712,-1231.4313,-849.9693,5468.347,5380.4272,5215.158,4936.9175,4637.6865,4369.6987,3969.4963,3584.1326,2966.5247,2978.5168,1390.7388,228.45865,-463.96597,-475.83203,-1450.576,-2379.3376,-3085.6333,-3561.7046,-2912.0186,-2115.6775,-2344.0876,-2265.8694,-2619.362,-2168.9302,-2239.6597,-2823.5295,255.4763,3746.3699,4321.4023,4774.339,4337.9697,3157.534,2590.7983,2409.8875,2652.3494,874.90686,4136.466,4243.597,3430.1619,3226.6282,2806.9841,2730.89,2722.234,2697.0703,2674.888,2731.8447,2338.5242,2745.014,2414.5881,2068.7322,2144.1147,1979.1757,1344.909,-2341.3818,-2780.1533,-2094.718,-2536.8972,-2830.8528,-2676.673,-2733.8179,-3061.4114,-3570.0286,-3153.7258,-2750.5708,-3039.189,-3030.342,-1648.8882,-2511.7112,-2228.8198,-2451.5154,-2853.0786,-3430.6875,-4086.6982,-4049.242,-4019.954,-4096.8564,-3970.4163,-3954.8848,-3983.848,-3913.5754};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_149()
		{
			double[] value = {-3680.8372,-3510.3643,-3569.79,-3607.055,-3199.3025,-2927.2883,-3091.0168,-3156.1753,-2414.6035,-1670.7374,-1333.1924,-1747.928,-2432.5825,-1772.8248,-1539.4658,-1501.3315,-1976.1094,-2084.7092,-2443.7463,-2161.3875,-1656.8285,-1644.8535,-1694.9991,-1319.3016,-1558.8848,-1662.1213,-1634.9421,-1586.6906,-1467.7654,-1577.0803,-1554.5662,-1520.6096,-1445.0919,-1375.8883,-1907.711,-1417.6693,-1724.4812,-1791.7668,-1655.1923,-1125.9349,-900.7501,-1058.7202,-1041.6908,-998.49316,-906.2788,-812.98315,-1704.8251,-834.48425,5195.1587,5423.9414,5203.689,4938.303,4489.4976,3838.071,2744.7278,1314.6309,-684.24146,-2248.053,-1326.644,-867.6114,-1011.73663,-2815.3865,-3109.194,-2577.6792,-1706.0542,-507.2336,1226.8594,1612.8552,1293.7245,1781.7563,-675.403,-2594.4487,-3165.36,-3153.2856,1459.2682,3380.9846,3911.1096,3479.0847,492.25128,872.8813,1118.6853,852.3414,-187.05856,-2003.2518,2581.5789,4017.145,3260.9763,2890.2905,2491.8271,2524.6133,2575.784,2560.4888,2605.9136,2730.3206,2888.6865,1744.1794,2215.0396,2156.4973,2065.0298,1937.9751};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_150()
		{
			double[] value = {1338.6599,-2178.443,-3586.7178,-3585.8748,-3573.5151,-3238.2795,-3188.7217,-3075.3875,-3615.9395,-2859.635,-2446.2969,-3541.4365,-2973.596,-273.72357,1085.0326,818.18585,-598.9002,-2337.148,-3343.314,-3934.4678,-4142.293,-4081.869,-4063.9739,-4173.8447,-3961.403,-3891.3616,-3961.271,-3622.9536,-3439.1714,-3611.228,-3620.8816,-3989.5469,-4074.5354,-3570.9875,-3296.75,-3764.7861,-3077.1323,-1791.8948,-1595.0717,-1566.376,-1593.2815,-1982.225,-1557.8716,-1384.4829,-1368.8027,-1990.6244,-2667.4648,-2447.7668,-1737.9961,-1855.6819,-1552.7617,-1663.9705,-1695.8602,-1729.4861,-1740.2277,-1736.0111,-1560.9025,-1527.5673,-1532.0701,-1550.5636,-1454.1249,-1639.8945,-1777.7347,-1596.2258,-1381.2053,-1341.6481,-1186.1779,-979.5114,-827.1634,-2291.6921,-1832.9957,-771.5784,-899.1337,-969.02734,-819.6341,-927.47217,2273.589,2998.777,2548.2388,2292.2048,1359.8562,113.70232,-147.00438,-975.3366,-390.85013,-283.07327,692.8624,1111.2164,1248.0099,2123.45,1834.7333,2815.5037,3603.3845,4424.7817,3746.3555,2963.835,1986.7806,455.84622,-2582.4456,-2782.7034};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_151()
		{
			double[] value = {-4462.3916,-3518.6199,-1531.7437,-347.12317,-89.98459,-1492.2356,-2290.8904,-2123.051,-2121.6465,-1427.6414,231.09497,1978.1472,3434.102,3448.0908,2986.4944,1419.6229,2476.3855,2573.9824,2526.4885,2469.008,2484.7573,2545.4736,2460.0032,2396.2537,2168.842,2108.966,2083.6978,1901.4263,1868.6527,1352.698,552.9378,81.69026,-1713.5973,-2443.719,-2346.685,-2946.6548,-2286.4167,13.353827,1042.4921,-954.1482,-593.92456,1113.0675,1269.0708,1131.4724,1087.2522,984.4659,53.262424,-1467.7131,-2468.7385,-4098.7764,-4079.3386,-3958.209,-4181.2573,-4030.0938,-3782.0488,-3447.1284,-3479.6643,-3522.571,-3488.8218,-3616.1113,-3601.6074,-3396.748,-3380.676,-3572.62,-3377.7998,-2671.4592,-1688.4319,-1437.1758,-1453.8179,-1721.8241,-1500.6343,-1563.34,-1655.8531,-1750.37,-2725.1255,-2373.9802,-1929.3025,-1883.3698,-1918.3062,-1741.714,-1876.9402,-1886.2688,-1795.0704,-1760.6295,-1611.2141,-1523.3988,-1615.7549,-1610.6451,-1500.6702,-1446.7098,-1490.6298,-1439.1289,-1298.5338,-1246.3243,-1177.4427,-1032.5223,-963.30066,-938.2853,-915.9315,-1009.1375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_152()
		{
			double[] value = {-884.769,-1027.3745,-964.04224,-1056.641,2464.765,4344.2725,4279.265,3164.4004,2905.1768,3581.1694,3386.2432,3594.63,3846.0662,3998.3088,4112.572,4066.9832,4433.9346,4701.0386,4361.6025,4724.79,4734.446,3808.0325,1884.49,1965.0851,1243.7549,-1170.7152,-1273.1848,-678.5797,-3428.4683,-2560.5215,-2798.573,-3227.6604,-3657.5376,-3064.5674,-1058.0298,830.4994,2277.6348,3444.7822,3690.9658,3480.8699,3139.5593,2825.9556,2713.478,2208.6755,2557.387,2517.5786,2474.5388,2427.4185,2400.7463,2315.6633,2267.4304,2326.2654,2348.5488,2202.7825,2183.1692,1969.1945,2112.6375,1986.4344,1697.0461,1447.1229,691.44366,-2301.8794,-1173.8705,-306.39432,639.3549,1032.5712,1203.5791,920.05566,1010.3992,1091.1094,1240.8883,1252.2805,1324.0103,1313.9149,267.8866,266.03723,43.70948,-1782.141,-3556.7305,-3941.8997,-4094.9023,-4031.8271,-3661.6729,-2148.8347,-1561.2004,-1551.9664,-1878.059,-1407.7256,-2581.5137,-2496.3452,-3202.1912,-3563.2524,-3158.521,-2642.925,-1929.9916,-1511.2567,-1221.7715,-1126.9092,-1405.5518,-1776.9828};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_153()
		{
			double[] value = {-1994.4769,-2077.2917,-1947.5536,-2390.198,-1802.1417,-1878.9757,-1971.7843,-1784.9355,-1986.0974,-1927.6516,-1891.0175,-1923.1544,-1932.7665,-1770.9865,-1599.1744,-1865.9769,-1619.3218,-1587.156,-1218.585,-1343.6659,-1762.2887,-1178.4694,-1203.9135,-1092.319,-1039.6427,-1050.2991,-998.85504,-1098.7106,-1032.0721,-1244.9568,-1035.6646,-1041.1013,2151.4004,2130.1445,2660.7637,4286.1533,4553.5356,4388.151,4350.2744,4197.5347,4256.39,4333.082,4402.4043,4477.6074,4563.3735,3783.1028,909.60516,2935.2466,4580.502,4473.2314,2641.85,2029.2883,-411.1193,-1296.2028,469.53387,-567.7965,-1363.9635,-3341.664,-2377.1096,-1498.8256,770.46643,2405.0627,4038.827,4188.4067,4011.4595,3791.0544,3539.9827,3184.6958,2841.8904,2329.6108,1686.059,1908.918,1905.1334,2337.8796,2358.6086,2321.0264,2359.4253,2203.8774,2111.4807,2195.8066,2480.6497,2184.952,2169.8892,2085.771,2055.6917,2008.188,1452.5172,1388.3313,1317.1555,1369.4677,1051.8387,691.8065,723.63464,639.1548,1022.8474,1290.0868,1121.5913,916.91986,1161.9147,1322.549};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_154()
		{
			double[] value = {1477.0441,1133.6302,715.4885,288.77533,34.70088,-941.42615,-1994.2124,-3822.2954,-4055.7131,-3956.3953,-2432.6682,-692.17444,-597.7011,-691.5607,-1638.3147,-642.01135,-1316.7155,-1906.0966,-3236.5928,-3581.2212,-2963.2756,-3367.6125,-2599.551,-2467.4058,-1438.0829,-1129.2819,-1103.1588,-1257.8688,-1478.3075,-1740.1119,-1794.4675,-2348.396,-1986.1954,-1583.2998,-1800.8668,-2458.18,-2201.3208,-2029.9001,-2020.0516,-1955.7664,-1789.182,-1721.7878,-1728.7029,-1602.5624,-1529.9519,-1710.4012,-1289.5985,-1352.7528,-1279.0026,-1184.921,-1216.4418,-1231.5743,-1145.0107,-1128.0568,-1137.2719,-1098.7028,-1147.8064,-1140.8461,-1172.4557,-1223.3099,883.7017,-177.25536,-773.35754,2227.3333,1076.6799,540.8946,819.8911,1096.9869,3150.0222,3867.0256,3901.6396,3565.7092,3867.3933,2630.9883,2398.5957,4281.4272,4765.0557,4428.2915,1123.3467,-24.447422,22.100813,1368.4581,1675.8712,212.33871,-1090.2607,-2787.1892,-1433.224,-411.09637,2945.8906,4173.5103,3976.2458,3898.5808,3715.4917,3459.789,3044.2712,2477.4536,2580.316,1049.5944,-1787.3723,-2019.3982};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_155()
		{
			double[] value = {-2225.7122,-224.373,2266.4382,2242.4458,1929.4985,2040.0118,2006.5923,1962.4606,2357.303,2096.0188,2027.7197,1825.6547,1755.3026,1662.8143,1317.6833,758.3261,1222.8334,1536.9497,1119.5686,84.769684,367.1475,770.3214,971.2617,1144.4738,1195.2131,842.6288,964.82196,622.9542,977.59827,660.85144,356.193,28.646147,-187.70126,-390.16245,-576.4167,-3132.166,-4015.9812,-3188.3105,-1744.4781,-761.97675,-725.96985,-686.9821,-652.606,-638.8073,-746.0913,-1391.7323,-3288.042,-3771.2126,-3218.3486,-3149.7363,-3125.5042,-3106.1753,-2453.6382,-1171.5977,-1157.4603,-1334.3145,-1439.8464,-1466.4275,-1528.6321,-1918.1675,-2718.4897,-2008.9939,-1946.1149,-2194.7034,-2057.0476,-2081.5413,-2108.0269,-2067.6365,-1904.3451,-1792.8486,-1749.5635,-1665.2714,-1620.495,-1572.5571,-1447.9733,-1371.3699,-1279.8392,-1264.7771,-1224.0187,-1207.7263,-1267.9487,-1290.7703,-1227.4639,-1668.9829,-1288.6066,-1296.9869,-1205.3959,-1389.284,2856.8545,1095.0822,-442.63348,-435.2645,1674.6638,2164.0542,2494.9907,650.1131,3043.0835,4339.268,4471.9834,4586.5186};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_156()
		{
			double[] value = {4717.656,4681.442,4533.864,4596.664,4749.3115,4822.7393,4567.521,4228.9604,4470.791,3298.0837,1468.4158,1339.5326,-44.295464,-1894.0708,-4123.384,-605.8267,3295.4097,3839.165,3858.8115,3755.8318,3376.6519,3075.7744,2492.1091,1140.5151,2312.174,1977.4453,-275.3881,-2299.2278,-3168.1938,-2203.9512,1881.9581,2108.3474,1710.9935,1767.345,1889.6659,1727.318,1995.0927,1959.6362,1900.1605,1540.0403,1514.8077,1299.8805,1146.1482,1065.7131,1066.2926,1145.2476,1188.7805,-3.199535,-504.07724,696.1332,1025.4819,1337.046,1058.9369,762.09204,748.6634,383.6391,428.58627,217.85551,20.24791,-228.1779,-373.59537,-460.7468,-582.29034,-896.27026,-3750.4976,-3189.4949,-1305.1158,-949.3457,-935.8669,-976.32764,-846.1659,-1489.2965,-1225.561,-1304.6396,-3396.5054,-3894.677,-3553.713,-3227.4336,-2682.9368,-2841.6274,-2248.4795,-1759.6207,-1270.9698,-1180.0845,-1317.2456,-1565.1251,-1662.0286,-2416.991,-2484.436,-2357.791,-2040.1376,-2004.3566,-2009.095,-2056.016,-2192.1213,-2149.254,-1920.9437,-1708.7928,-1648.2233,-1604.9082};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_157()
		{
			double[] value = {-1628.3162,-1598.4878,-1643.8352,-1383.9229,-1131.7749,-1314.2928,-1304.6582,-1336.053,-1359.7609,-1451.8716,-1344.5317,-1359.3638,-1364.3105,-1405.992,-1173.7191,-1125.9406,4496.5264,4434.4966,4147.0786,3790.0457,3810.1355,3696.8853,3728.1763,3651.7275,3823.9514,4002.3086,4222.2856,4381.775,4559.4146,4553.711,4396.0103,4414.958,4323.623,4429.251,4618.903,4408.4165,4210.517,3660.204,833.15765,-145.78764,-1280.4038,-1837.7749,-899.2048,2970.021,3553.03,3691.8718,3671.45,3430.2463,2977.0618,2707.7988,2533.5532,2354.3518,2289.418,2187.8484,1947.7642,-1558.8462,-2864.7017,-2031.2428,1471.2909,2137.1968,1838.7576,1713.9999,1646.726,1538.3867,1639.528,1695.178,1770.4476,1467.8329,1062.9591,101.18584,1036.2759,1068.3049,928.2156,980.45996,923.10846,769.51465,-489.55893,-128.03395,569.49634,814.8919,853.50604,672.6979,479.09183,526.09204,52.674248,-90.576065,-146.8757,-373.97116,-488.74512,-603.8557,-629.8801,-597.6218,-2348.4976,-3825.125,-2410.3396,-1652.2494,-1171.0387,-1159.2614,-1113.3867,-1275.346};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_158()
		{
			double[] value = {-1587.444,-1493.162,-2939.9624,-3726.6572,-3594.5798,-2885.9644,-3060.551,-2960.5002,-2148.6934,-1963.4901,-1569.9637,-1338.7594,-1371.6406,-1671.514,-1763.1646,-1955.0243,-2187.8906,-2371.6921,-2124.4553,-2063.2046,-2064.1323,-2369.7695,-2285.0623,-2219.9658,-1998.7461,-1816.7701,-1884.3318,-1755.1522,-1770.7302,-1729.6392,-1659.263,-1508.6504,-1737.0073,-1789.1362,-1598.0835,-1509.8811,-1412.859,-1541.3602,-1528.8162,-1432.3004,-1408.7273,-1522.4264,-1270.7642,-1163.8263,4079.445,4092.6438,3858.461,3571.287,3429.6062,3408.0444,3478.6785,3532.1277,3569.7156,3601.6855,3705.7607,3995.4172,4243.1943,4362.938,4291.3276,4215.803,3546.5142,3536.801,4410.216,4185.1914,4078.9565,4069.795,3586.0503,3416.2734,3283.0884,3125.4407,3139.3022,3359.6545,3179.0225,3487.362,3305.1582,3056.8757,2830.097,2575.397,2438.9946,2310.7112,2212.9236,2069.065,1983.9385,470.29803,-2096.7324,-880.7279,1958.3137,2628.737,2211.5544,1533.765,1394.0099,1411.1154,1377.8438,1460.0044,1532.523,1386.7178,304.14413,-1522.3936,770.9243,1010.98944};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_159()
		{
			double[] value = {860.92523,885.6155,952.5635,1030.8091,89.83849,-672.9404,140.39175,307.51276,606.4996,613.31464,401.7675,351.4776,-80.67988,-287.06052,-339.83286,-488.88916,-660.3932,-751.046,-779.79047,-1373.34,-2053.7415,-3459.6052,-3736.7656,-3715.3364,-1906.946,-1497.9666,-1397.311,-1435.6711,-1785.5029,-2712.193,-3079.878,-2407.6973,-3246.0437,-2124.1462,-2594.49,-2772.6357,-2529.6433,-1793.7144,-1691.5975,-1730.1304,-1612.3732,-1881.6609,-1906.0898,-1883.0841,-2263.6492,-2592.6865,-2336.136,-2236.512,-2439.6816,-2534.5652,-2216.669,-2166.6082,-1996.2773,-1856.3356,-1823.5879,-1702.1079,-1802.918,-1804.4425,-1655.7097,-1785.692,-1879.0231,-1651.2164,-1585.2162,-1550.2385,-1417.6772,-1377.5468,-1393.3054,-1360.7019,-1310.4974,-1278.1179,-1246.7694,-1220.0406,3548.0652,3455.7654,3271.547,3126.532,3076.638,3073.771,3172.113,3210.7578,3201.9592,3181.5095,3128.5725,3208.624,3695.803,3991.1877,4048.0217,3998.7434,3869.0674,3846.5405,3005.6396,2863.1572,2947.235,2826.3433,3107.9736,3578.1445,3641.975,3410.4045,3301.925,3067.7903};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_160()
		{
			double[] value = {3299.033,3388.1748,3138.5383,2848.0022,2676.5522,2450.466,2287.912,2156.92,2096.5808,2003.3243,1893.2489,264.65567,-675.9542,852.2612,1844.226,3374.104,2251.4673,1467.8905,1277.8885,1308.6643,1289.6761,1400.9806,1341.1652,1324.9907,1510.3595,1163.068,1086.097,903.07385,743.1806,746.3802,879.8879,589.79425,487.06015,-830.6618,-368.38916,47.843464,366.3515,361.7624,185.02936,-250.78741,-381.61493,-501.9418,-592.96936,-870.2456,-1001.9783,-843.4212,-874.39795,-879.4286,-939.8474,-2167.704,-4097.803,-3930.8044,-3837.4895,-2460.5076,-1669.4055,-1723.5958,-2109.5632,-2773.7368,-2432.1606,-1867.5159,-2848.1719,-2276.2864,-1804.5968,-1908.463,-2072.8562,-1697.8221,-1699.8259,-2013.5632,-2002.656,-2008.565,-2037.6667,-2156.5369,-2259.3445,-2598.7454,-2566.06,-2538.4646,-2326.139,-2532.6716,-2613.5735,-2317.5098,-2029.1576,-1824.9285,-1936.8378,-1834.9735,-1814.9501,-1721.5941,-1825.5796,-1963.7554,-1777.119,-1565.3595,-1461.0908,-1443.5575,-1421.6636,-1340.803,-1288.4595,-1294.4935,-1257.2041,-1218.6656,-1204.4271,-1236.8278};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_161()
		{
			double[] value = {3187.1802,3042.295,2920.0005,2828.8938,2783.6724,2800.321,2769.1128,2745.674,2700.281,2626.2327,2537.0469,2474.1003,2610.6638,3185.5127,3711.3076,3563.8413,1891.8881,1425.4711,1569.175,708.25244,-1727.1969,-1605.9666,1269.2126,3277.568,3531.5486,3406.1653,3386.654,3385.719,3431.2637,3252.0803,2868.0725,2524.688,2365.345,2178.3071,1998.2133,1946.4517,1901.1173,1868.7194,1788.7302,1316.8195,-56.774986,1243.5793,1376.0516,1992.8561,1867.0703,1483.3141,1241.0311,1353.8193,1378.9172,1481.3522,1386.1725,1297.6598,1284.8403,1151.7562,1005.9713,833.1554,636.9385,637.11554,680.1829,678.4813,642.1198,-958.44684,-1530.4438,34.19661,-122.61723,-525.7201,-1057.6136,-257.87067,-588.3115,-652.9489,-993.2057,-1353.7054,-1931.7504,-1707.912,-1014.55804,-947.66144,-1134.8998,-2794.5269,-4240.8057,-4134.815,-3714.6477,-2229.486,-1974.7089,-1796.6768,-1989.624,-1864.0493,-2015.5424,-1857.2181,-1968.8838,-2022.0541,-1887.5692,-1796.4515,-1830.3557,-1789.7158,-1759.6299,-1847.8739,-1911.6746,-2347.6902,-2585.9385,-2582.5745};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_162()
		{
			double[] value = {-2773.8079,-2647.636,-2551.627,-2529.1365,-2251.048,-2727.318,-2531.5515,-2305.9905,-1922.5042,-1850.2529,-1864.664,-2006.319,-1953.8514,-1840.9745,-1932.9298,-1887.1638,-1787.6838,-1597.9023,-1475.0673,-1451.4025,-1438.1593,-1426.8848,-1273.1239,-1235.697,-1232.0884,-1207.8905,-1159.5197,-1216.1388,3055.731,2947.807,2840.4094,2731.1045,2638.9656,2595.9822,2376.9614,2193.5684,2066.3945,1901.8208,1773.195,1739.7189,985.35443,-345.16827,-119.17784,345.59564,-332.32037,-835.2338,-438.29105,-712.4027,-1178.8218,1119.8462,3566.7954,3505.204,3491.4004,3441.3547,3409.2598,3364.4668,3306.4434,3036.9673,2595.7498,2292.841,2103.6055,1925.3652,1798.1741,1720.0425,1716.3645,1686.2664,1643.2235,1450.4457,369.6205,253.69968,901.2608,1001.71155,1126.5035,1288.3765,1372.4884,1484.2108,977.5036,630.04553,1096.2472,1545.096,905.3169,944.6416,950.43243,537.98016,585.45776,532.67084,486.59515,564.7649,817.27185,-1524.7465,-3200.6287,-1707.0479,40.771515,19.113495,-402.855,-775.9221,-791.51154,-895.34705,-803.16266,-946.5304};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_163()
		{
			double[] value = {-3292.0154,-3039.0354,-1341.0803,-1436.3263,-2359.8484,-3495.8564,-4598.6533,-4560.355,-4381.096,-3179.32,-2151.202,-2087.379,-2039.9775,-1903.1752,-2024.3412,-1643.4567,-1773.712,-1824.6285,-1834.1814,-1878.405,-1826.486,-1720.314,-2069.63,-2106.586,-1841.4335,-1851.7296,-1971.8428,-1901.74,-2620.7427,-3140.1858,-2568.0276,-3053.6462,-2890.4785,-2497.484,-2343.432,-2295.4624,-2027.0509,-1898.5922,-1976.5271,-1962.8041,-2007.141,-1985.1194,-2029.5817,-1946.0625,-1839.9543,-1794.1989,-1562.8285,-1476.8745,-1464.2625,-1445.9813,-1379.2926,-1253.2186,-1205.3829,-1202.9047,-1184.6205,-1195.9458,2997.4866,2829.7004,2702.3013,2609.618,2520.806,2422.1755,2226.834,2039.5488,1855.033,1688.7931,1486.843,1339.2358,1121.4788,-808.35834,465.44244,3149.61,3749.198,2932.7869,2207.452,2685.5823,3126.629,3552.2332,3525.099,3510.7117,3410.9675,3370.8796,3324.3552,3272.7207,3081.0308,2744.176,2397.475,2156.9614,1968.2957,1752.0448,1626.9838,1575.0697,1584.0204,1490.8569,1434.715,1394.4384,1213.5332,329.95535,551.8444,907.1537};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_164()
		{
			double[] value = {965.95386,1233.0702,1442.0287,799.0692,779.98505,760.9241,520.03015,1236.7473,928.90454,866.5732,892.7185,793.6038,589.7236,504.46515,520.6834,505.90366,808.0457,-1687.5538,-2636.6335,-3023.8455,-162.29982,55.45822,33.354008,-287.8447,-673.86957,-929.29205,-1131.7341,-1216.8324,-3258.9382,-3764.1895,-2663.1538,-1978.3816,-3610.6416,-3971.0825,-4684.837,-4903.6006,-4348.2783,-3030.8872,-1789.6205,-1604.8358,-1457.138,-1698.8573,-2187.9338,-1590.6372,-1728.2416,-1947.1569,-1895.4135,-2059.4763,-1705.8046,-1515.505,-2279.2654,-2260.237,-1784.4049,-1442.5342,-1304.6333,-1590.3889,-1802.8022,-2803.4072,-3098.3738,-2846.9753,-2682.2117,-2513.6187,-2321.1353,-2233.0632,-2077.807,-2014.1431,-2028.6472,-2113.6296,-2016.9414,-1955.4191,-2026.5983,-1922.779,-1791.9037,-1630.3251,-1566.6052,-1458.9998,-1394.4283,-1396.4448,-1400.7465,-1310.2893,-1266.8615,-1221.9246,-1219.992,-1272.5734};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.00787,0.00391,0.01575,0.00391,0.02362,0.00391,0.0315,0.00391,0.03937,0.00391,0.04724,0.00391,0.05512,0.00391,0.06299,0.00391,0.07087,0.00391,0.07874,0.00391,0.08661,0.00391,0.09449,0.00391,0.10236,0.00391,0.11024,0.00391,0.11811,0.00391,0.12598,0.00391,0.13386,0.00391,0.14173,0.00391,0.14961,0.00391,0.15748,0.00391,0.16535,0.00391,0.17323,0.00391,0.1811,0.00391,0.18898,0.00391,0.19685,0.00391,0.20472,0.00391,0.2126,0.00391,0.22047,0.00391,0.22835,0.00391,0.23622,0.00391,0.24409,0.00391,0.25197,0.00391,0.25984,0.00391,0.26772,0.00391,0.27559,0.00391,0.28346,0.00391,0.29134,0.00391,0.29921,0.00391,0.30709,0.00391,0.31496,0.00391,0.32283,0.00391,0.33071,0.00391,0.33858,0.00391,0.34646,0.00391,0.35433,0.00391,0.3622,0.00391,0.37008,0.00391,0.37795,0.00391,0.38583,0.00391,0.3937,0.00391,0.40157,0.00391,0.40945,0.00391,0.41732,0.00391,0.4252,0.00391,0.43307,0.00391,0.44094,0.00391,0.44882,0.00391,0.45669,0.00391,0.46457,0.00391,0.47244,0.00391,0.48031,0.00391,0.48819,0.00391,0.49606,0.00391,0.50394,0.00391,0.51181,0.00391,0.51969,0.00391,0.52756,0.00391,0.53543,0.00391,0.54331,0.00391,0.55118,0.00391,0.55906,0.00391,0.56693,0.00391,0.5748,0.00391,0.58268,0.00391,0.59055,0.00391,0.59843,0.00391,0.6063,0.00391,0.61417,0.00391,0.62205,0.00391,0.62992,0.00391,0.6378,0.00391,0.64567,0.00391,0.65354,0.00391,0.66142,0.00391,0.66929,0.00391,0.67717,0.00391,0.68504,0.00391,0.69291,0.00391,0.70079,0.00391,0.70866,0.00391,0.71654,0.00391,0.72441,0.00391,0.73228,0.00391,0.74016,0.00391,0.74803,0.00391,0.75591,0.00391,0.76378,0.00391,0.77165,0.00391,0.77953,0.00391};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.7874,0.00391,0.79528,0.00391,0.80315,0.00391,0.81102,0.00391,0.8189,0.00391,0.82677,0.00391,0.83465,0.00391,0.84252,0.00391,0.85039,0.00391,0.85827,0.00391,0.86614,0.00391,0.87402,0.00391,0.88189,0.00391,0.88976,0.00391,0.89764,0.00391,0.90551,0.00391,0.91339,0.00391,0.92126,0.00391,0.92913,0.00391,0.93701,0.00391,0.94488,0.00391,0.95276,0.00391,0.96063,0.00391,0.9685,0.00391,0.97638,0.00391,0.98425,0.00391,0.99213,0.00391,0.99609,0.00391,0.00391,0.00787,0.00787,0.00787,0.01575,0.00787,0.02362,0.00787,0.0315,0.00787,0.03937,0.00787,0.04724,0.00787,0.05512,0.00787,0.06299,0.00787,0.07087,0.00787,0.07874,0.00787,0.08661,0.00787,0.09449,0.00787,0.10236,0.00787,0.11024,0.00787,0.11811,0.00787,0.12598,0.00787,0.13386,0.00787,0.14173,0.00787,0.14961,0.00787,0.15748,0.00787,0.16535,0.00787,0.17323,0.00787,0.1811,0.00787,0.18898,0.00787,0.19685,0.00787,0.20472,0.00787,0.2126,0.00787,0.22047,0.00787,0.22835,0.00787,0.23622,0.00787,0.24409,0.00787,0.25197,0.00787,0.25984,0.00787,0.26772,0.00787,0.27559,0.00787,0.28346,0.00787,0.29134,0.00787,0.29921,0.00787,0.30709,0.00787,0.31496,0.00787,0.32283,0.00787,0.33071,0.00787,0.33858,0.00787,0.34646,0.00787,0.35433,0.00787,0.3622,0.00787,0.37008,0.00787,0.37795,0.00787,0.38583,0.00787,0.3937,0.00787,0.40157,0.00787,0.40945,0.00787,0.41732,0.00787,0.4252,0.00787,0.43307,0.00787,0.44094,0.00787,0.44882,0.00787,0.45669,0.00787,0.46457,0.00787,0.47244,0.00787,0.48031,0.00787,0.48819,0.00787,0.49606,0.00787,0.50394,0.00787,0.51181,0.00787,0.51969,0.00787,0.52756,0.00787,0.53543,0.00787,0.54331,0.00787,0.55118,0.00787,0.55906,0.00787};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.56693,0.00787,0.5748,0.00787,0.58268,0.00787,0.59055,0.00787,0.59843,0.00787,0.6063,0.00787,0.61417,0.00787,0.62205,0.00787,0.62992,0.00787,0.6378,0.00787,0.64567,0.00787,0.65354,0.00787,0.66142,0.00787,0.66929,0.00787,0.67717,0.00787,0.68504,0.00787,0.69291,0.00787,0.70079,0.00787,0.70866,0.00787,0.71654,0.00787,0.72441,0.00787,0.73228,0.00787,0.74016,0.00787,0.74803,0.00787,0.75591,0.00787,0.76378,0.00787,0.77165,0.00787,0.77953,0.00787,0.7874,0.00787,0.79528,0.00787,0.80315,0.00787,0.81102,0.00787,0.8189,0.00787,0.82677,0.00787,0.83465,0.00787,0.84252,0.00787,0.85039,0.00787,0.85827,0.00787,0.86614,0.00787,0.87402,0.00787,0.88189,0.00787,0.88976,0.00787,0.89764,0.00787,0.90551,0.00787,0.91339,0.00787,0.92126,0.00787,0.92913,0.00787,0.93701,0.00787,0.94488,0.00787,0.95276,0.00787,0.96063,0.00787,0.9685,0.00787,0.97638,0.00787,0.98425,0.00787,0.99213,0.00787,0.99609,0.00787,0.00391,0.01575,0.00787,0.01575,0.01575,0.01575,0.02362,0.01575,0.0315,0.01575,0.03937,0.01575,0.04724,0.01575,0.05512,0.01575,0.06299,0.01575,0.07087,0.01575,0.07874,0.01575,0.08661,0.01575,0.09449,0.01575,0.10236,0.01575,0.11024,0.01575,0.11811,0.01575,0.12598,0.01575,0.13386,0.01575,0.14173,0.01575,0.14961,0.01575,0.15748,0.01575,0.16535,0.01575,0.17323,0.01575,0.1811,0.01575,0.18898,0.01575,0.19685,0.01575,0.20472,0.01575,0.2126,0.01575,0.22047,0.01575,0.22835,0.01575,0.23622,0.01575,0.24409,0.01575,0.25197,0.01575,0.25984,0.01575,0.26772,0.01575,0.27559,0.01575,0.28346,0.01575,0.29134,0.01575,0.29921,0.01575,0.30709,0.01575,0.31496,0.01575,0.32283,0.01575,0.33071,0.01575,0.33858,0.01575};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.34646,0.01575,0.35433,0.01575,0.3622,0.01575,0.37008,0.01575,0.37795,0.01575,0.38583,0.01575,0.3937,0.01575,0.40157,0.01575,0.40945,0.01575,0.41732,0.01575,0.4252,0.01575,0.43307,0.01575,0.44094,0.01575,0.44882,0.01575,0.45669,0.01575,0.46457,0.01575,0.47244,0.01575,0.48031,0.01575,0.48819,0.01575,0.49606,0.01575,0.50394,0.01575,0.51181,0.01575,0.51969,0.01575,0.52756,0.01575,0.53543,0.01575,0.54331,0.01575,0.55118,0.01575,0.55906,0.01575,0.56693,0.01575,0.5748,0.01575,0.58268,0.01575,0.59055,0.01575,0.59843,0.01575,0.6063,0.01575,0.61417,0.01575,0.62205,0.01575,0.62992,0.01575,0.6378,0.01575,0.64567,0.01575,0.65354,0.01575,0.66142,0.01575,0.66929,0.01575,0.67717,0.01575,0.68504,0.01575,0.69291,0.01575,0.70079,0.01575,0.70866,0.01575,0.71654,0.01575,0.72441,0.01575,0.73228,0.01575,0.74016,0.01575,0.74803,0.01575,0.75591,0.01575,0.76378,0.01575,0.77165,0.01575,0.77953,0.01575,0.7874,0.01575,0.79528,0.01575,0.80315,0.01575,0.81102,0.01575,0.8189,0.01575,0.82677,0.01575,0.83465,0.01575,0.84252,0.01575,0.85039,0.01575,0.85827,0.01575,0.86614,0.01575,0.87402,0.01575,0.88189,0.01575,0.88976,0.01575,0.89764,0.01575,0.90551,0.01575,0.91339,0.01575,0.92126,0.01575,0.92913,0.01575,0.93701,0.01575,0.94488,0.01575,0.95276,0.01575,0.96063,0.01575,0.9685,0.01575,0.97638,0.01575,0.98425,0.01575,0.99213,0.01575,0.99609,0.01575,0.00391,0.02362,0.00787,0.02362,0.01575,0.02362,0.02362,0.02362,0.0315,0.02362,0.03937,0.02362,0.04724,0.02362,0.05512,0.02362,0.06299,0.02362,0.07087,0.02362,0.07874,0.02362,0.08661,0.02362,0.09449,0.02362,0.10236,0.02362,0.11024,0.02362,0.11811,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.12598,0.02362,0.13386,0.02362,0.14173,0.02362,0.14961,0.02362,0.15748,0.02362,0.16535,0.02362,0.17323,0.02362,0.1811,0.02362,0.18898,0.02362,0.19685,0.02362,0.20472,0.02362,0.2126,0.02362,0.22047,0.02362,0.22835,0.02362,0.23622,0.02362,0.24409,0.02362,0.25197,0.02362,0.25984,0.02362,0.26772,0.02362,0.27559,0.02362,0.28346,0.02362,0.29134,0.02362,0.29921,0.02362,0.30709,0.02362,0.31496,0.02362,0.32283,0.02362,0.33071,0.02362,0.33858,0.02362,0.34646,0.02362,0.35433,0.02362,0.3622,0.02362,0.37008,0.02362,0.37795,0.02362,0.38583,0.02362,0.3937,0.02362,0.40157,0.02362,0.40945,0.02362,0.41732,0.02362,0.4252,0.02362,0.43307,0.02362,0.44094,0.02362,0.44882,0.02362,0.45669,0.02362,0.46457,0.02362,0.47244,0.02362,0.48031,0.02362,0.48819,0.02362,0.49606,0.02362,0.50394,0.02362,0.51181,0.02362,0.51969,0.02362,0.52756,0.02362,0.53543,0.02362,0.54331,0.02362,0.55118,0.02362,0.55906,0.02362,0.56693,0.02362,0.5748,0.02362,0.58268,0.02362,0.59055,0.02362,0.59843,0.02362,0.6063,0.02362,0.61417,0.02362,0.62205,0.02362,0.62992,0.02362,0.6378,0.02362,0.64567,0.02362,0.65354,0.02362,0.66142,0.02362,0.66929,0.02362,0.67717,0.02362,0.68504,0.02362,0.69291,0.02362,0.70079,0.02362,0.70866,0.02362,0.71654,0.02362,0.72441,0.02362,0.73228,0.02362,0.74016,0.02362,0.74803,0.02362,0.75591,0.02362,0.76378,0.02362,0.77165,0.02362,0.77953,0.02362,0.7874,0.02362,0.79528,0.02362,0.80315,0.02362,0.81102,0.02362,0.8189,0.02362,0.82677,0.02362,0.83465,0.02362,0.84252,0.02362,0.85039,0.02362,0.85827,0.02362,0.86614,0.02362,0.87402,0.02362,0.88189,0.02362,0.88976,0.02362,0.89764,0.02362,0.90551,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.91339,0.02362,0.92126,0.02362,0.92913,0.02362,0.93701,0.02362,0.94488,0.02362,0.95276,0.02362,0.96063,0.02362,0.9685,0.02362,0.97638,0.02362,0.98425,0.02362,0.99213,0.02362,0.99609,0.02362,0.00391,0.0315,0.00787,0.0315,0.01575,0.0315,0.02362,0.0315,0.0315,0.0315,0.03937,0.0315,0.04724,0.0315,0.05512,0.0315,0.06299,0.0315,0.07087,0.0315,0.07874,0.0315,0.08661,0.0315,0.09449,0.0315,0.10236,0.0315,0.11024,0.0315,0.11811,0.0315,0.12598,0.0315,0.13386,0.0315,0.14173,0.0315,0.14961,0.0315,0.15748,0.0315,0.16535,0.0315,0.17323,0.0315,0.1811,0.0315,0.18898,0.0315,0.19685,0.0315,0.20472,0.0315,0.2126,0.0315,0.22047,0.0315,0.22835,0.0315,0.23622,0.0315,0.24409,0.0315,0.25197,0.0315,0.25984,0.0315,0.26772,0.0315,0.27559,0.0315,0.28346,0.0315,0.29134,0.0315,0.29921,0.0315,0.30709,0.0315,0.31496,0.0315,0.32283,0.0315,0.33071,0.0315,0.33858,0.0315,0.34646,0.0315,0.35433,0.0315,0.3622,0.0315,0.37008,0.0315,0.37795,0.0315,0.38583,0.0315,0.3937,0.0315,0.40157,0.0315,0.40945,0.0315,0.41732,0.0315,0.4252,0.0315,0.43307,0.0315,0.44094,0.0315,0.44882,0.0315,0.45669,0.0315,0.46457,0.0315,0.47244,0.0315,0.48031,0.0315,0.48819,0.0315,0.49606,0.0315,0.50394,0.0315,0.51181,0.0315,0.51969,0.0315,0.52756,0.0315,0.53543,0.0315,0.54331,0.0315,0.55118,0.0315,0.55906,0.0315,0.56693,0.0315,0.5748,0.0315,0.58268,0.0315,0.59055,0.0315,0.59843,0.0315,0.6063,0.0315,0.61417,0.0315,0.62205,0.0315,0.62992,0.0315,0.6378,0.0315,0.64567,0.0315,0.65354,0.0315,0.66142,0.0315,0.66929,0.0315,0.67717,0.0315,0.68504,0.0315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.69291,0.0315,0.70079,0.0315,0.70866,0.0315,0.71654,0.0315,0.72441,0.0315,0.73228,0.0315,0.74016,0.0315,0.74803,0.0315,0.75591,0.0315,0.76378,0.0315,0.77165,0.0315,0.77953,0.0315,0.7874,0.0315,0.79528,0.0315,0.80315,0.0315,0.81102,0.0315,0.8189,0.0315,0.82677,0.0315,0.83465,0.0315,0.84252,0.0315,0.85039,0.0315,0.85827,0.0315,0.86614,0.0315,0.87402,0.0315,0.88189,0.0315,0.88976,0.0315,0.89764,0.0315,0.90551,0.0315,0.91339,0.0315,0.92126,0.0315,0.92913,0.0315,0.93701,0.0315,0.94488,0.0315,0.95276,0.0315,0.96063,0.0315,0.9685,0.0315,0.97638,0.0315,0.98425,0.0315,0.99213,0.0315,0.99609,0.0315,0.00391,0.03937,0.00787,0.03937,0.01575,0.03937,0.02362,0.03937,0.0315,0.03937,0.03937,0.03937,0.04724,0.03937,0.05512,0.03937,0.06299,0.03937,0.07087,0.03937,0.07874,0.03937,0.08661,0.03937,0.09449,0.03937,0.10236,0.03937,0.11024,0.03937,0.11811,0.03937,0.12598,0.03937,0.13386,0.03937,0.14173,0.03937,0.14961,0.03937,0.15748,0.03937,0.16535,0.03937,0.17323,0.03937,0.1811,0.03937,0.18898,0.03937,0.19685,0.03937,0.20472,0.03937,0.2126,0.03937,0.22047,0.03937,0.22835,0.03937,0.23622,0.03937,0.24409,0.03937,0.25197,0.03937,0.25984,0.03937,0.26772,0.03937,0.27559,0.03937,0.28346,0.03937,0.29134,0.03937,0.29921,0.03937,0.30709,0.03937,0.31496,0.03937,0.32283,0.03937,0.33071,0.03937,0.33858,0.03937,0.34646,0.03937,0.35433,0.03937,0.3622,0.03937,0.37008,0.03937,0.37795,0.03937,0.38583,0.03937,0.3937,0.03937,0.40157,0.03937,0.40945,0.03937,0.41732,0.03937,0.4252,0.03937,0.43307,0.03937,0.44094,0.03937,0.44882,0.03937,0.45669,0.03937,0.46457,0.03937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.47244,0.03937,0.48031,0.03937,0.48819,0.03937,0.49606,0.03937,0.50394,0.03937,0.51181,0.03937,0.51969,0.03937,0.52756,0.03937,0.53543,0.03937,0.54331,0.03937,0.55118,0.03937,0.55906,0.03937,0.56693,0.03937,0.5748,0.03937,0.58268,0.03937,0.59055,0.03937,0.59843,0.03937,0.6063,0.03937,0.61417,0.03937,0.62205,0.03937,0.62992,0.03937,0.6378,0.03937,0.64567,0.03937,0.65354,0.03937,0.66142,0.03937,0.66929,0.03937,0.67717,0.03937,0.68504,0.03937,0.69291,0.03937,0.70079,0.03937,0.70866,0.03937,0.71654,0.03937,0.72441,0.03937,0.73228,0.03937,0.74016,0.03937,0.74803,0.03937,0.75591,0.03937,0.76378,0.03937,0.77165,0.03937,0.77953,0.03937,0.7874,0.03937,0.79528,0.03937,0.80315,0.03937,0.81102,0.03937,0.8189,0.03937,0.82677,0.03937,0.83465,0.03937,0.84252,0.03937,0.85039,0.03937,0.85827,0.03937,0.86614,0.03937,0.87402,0.03937,0.88189,0.03937,0.88976,0.03937,0.89764,0.03937,0.90551,0.03937,0.91339,0.03937,0.92126,0.03937,0.92913,0.03937,0.93701,0.03937,0.94488,0.03937,0.95276,0.03937,0.96063,0.03937,0.9685,0.03937,0.97638,0.03937,0.98425,0.03937,0.99213,0.03937,0.99609,0.03937,0.00391,0.04724,0.00787,0.04724,0.01575,0.04724,0.02362,0.04724,0.0315,0.04724,0.03937,0.04724,0.04724,0.04724,0.05512,0.04724,0.06299,0.04724,0.07087,0.04724,0.07874,0.04724,0.08661,0.04724,0.09449,0.04724,0.10236,0.04724,0.11024,0.04724,0.11811,0.04724,0.12598,0.04724,0.13386,0.04724,0.14173,0.04724,0.14961,0.04724,0.15748,0.04724,0.16535,0.04724,0.17323,0.04724,0.1811,0.04724,0.18898,0.04724,0.19685,0.04724,0.20472,0.04724,0.2126,0.04724,0.22047,0.04724,0.22835,0.04724,0.23622,0.04724,0.24409,0.04724};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.25197,0.04724,0.25984,0.04724,0.26772,0.04724,0.27559,0.04724,0.28346,0.04724,0.29134,0.04724,0.29921,0.04724,0.30709,0.04724,0.31496,0.04724,0.32283,0.04724,0.33071,0.04724,0.33858,0.04724,0.34646,0.04724,0.35433,0.04724,0.3622,0.04724,0.37008,0.04724,0.37795,0.04724,0.38583,0.04724,0.3937,0.04724,0.40157,0.04724,0.40945,0.04724,0.41732,0.04724,0.4252,0.04724,0.43307,0.04724,0.44094,0.04724,0.44882,0.04724,0.45669,0.04724,0.46457,0.04724,0.47244,0.04724,0.48031,0.04724,0.48819,0.04724,0.49606,0.04724,0.50394,0.04724,0.51181,0.04724,0.51969,0.04724,0.52756,0.04724,0.53543,0.04724,0.54331,0.04724,0.55118,0.04724,0.55906,0.04724,0.56693,0.04724,0.5748,0.04724,0.58268,0.04724,0.59055,0.04724,0.59843,0.04724,0.6063,0.04724,0.61417,0.04724,0.62205,0.04724,0.62992,0.04724,0.6378,0.04724,0.64567,0.04724,0.65354,0.04724,0.66142,0.04724,0.66929,0.04724,0.67717,0.04724,0.68504,0.04724,0.69291,0.04724,0.70079,0.04724,0.70866,0.04724,0.71654,0.04724,0.72441,0.04724,0.73228,0.04724,0.74016,0.04724,0.74803,0.04724,0.75591,0.04724,0.76378,0.04724,0.77165,0.04724,0.77953,0.04724,0.7874,0.04724,0.79528,0.04724,0.80315,0.04724,0.81102,0.04724,0.8189,0.04724,0.82677,0.04724,0.83465,0.04724,0.84252,0.04724,0.85039,0.04724,0.85827,0.04724,0.86614,0.04724,0.87402,0.04724,0.88189,0.04724,0.88976,0.04724,0.89764,0.04724,0.90551,0.04724,0.91339,0.04724,0.92126,0.04724,0.92913,0.04724,0.93701,0.04724,0.94488,0.04724,0.95276,0.04724,0.96063,0.04724,0.9685,0.04724,0.97638,0.04724,0.98425,0.04724,0.99213,0.04724,0.99609,0.04724,0.00391,0.05512,0.00787,0.05512,0.01575,0.05512,0.02362,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.0315,0.05512,0.03937,0.05512,0.04724,0.05512,0.05512,0.05512,0.06299,0.05512,0.07087,0.05512,0.07874,0.05512,0.08661,0.05512,0.09449,0.05512,0.10236,0.05512,0.11024,0.05512,0.11811,0.05512,0.12598,0.05512,0.13386,0.05512,0.14173,0.05512,0.14961,0.05512,0.15748,0.05512,0.16535,0.05512,0.17323,0.05512,0.1811,0.05512,0.18898,0.05512,0.19685,0.05512,0.20472,0.05512,0.2126,0.05512,0.22047,0.05512,0.22835,0.05512,0.23622,0.05512,0.24409,0.05512,0.25197,0.05512,0.25984,0.05512,0.26772,0.05512,0.27559,0.05512,0.28346,0.05512,0.29134,0.05512,0.29921,0.05512,0.30709,0.05512,0.31496,0.05512,0.32283,0.05512,0.33071,0.05512,0.33858,0.05512,0.34646,0.05512,0.35433,0.05512,0.3622,0.05512,0.37008,0.05512,0.37795,0.05512,0.38583,0.05512,0.3937,0.05512,0.40157,0.05512,0.40945,0.05512,0.41732,0.05512,0.4252,0.05512,0.43307,0.05512,0.44094,0.05512,0.44882,0.05512,0.45669,0.05512,0.46457,0.05512,0.47244,0.05512,0.48031,0.05512,0.48819,0.05512,0.49606,0.05512,0.50394,0.05512,0.51181,0.05512,0.51969,0.05512,0.52756,0.05512,0.53543,0.05512,0.54331,0.05512,0.55118,0.05512,0.55906,0.05512,0.56693,0.05512,0.5748,0.05512,0.58268,0.05512,0.59055,0.05512,0.59843,0.05512,0.6063,0.05512,0.61417,0.05512,0.62205,0.05512,0.62992,0.05512,0.6378,0.05512,0.64567,0.05512,0.65354,0.05512,0.66142,0.05512,0.66929,0.05512,0.67717,0.05512,0.68504,0.05512,0.69291,0.05512,0.70079,0.05512,0.70866,0.05512,0.71654,0.05512,0.72441,0.05512,0.73228,0.05512,0.74016,0.05512,0.74803,0.05512,0.75591,0.05512,0.76378,0.05512,0.77165,0.05512,0.77953,0.05512,0.7874,0.05512,0.79528,0.05512,0.80315,0.05512,0.81102,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.8189,0.05512,0.82677,0.05512,0.83465,0.05512,0.84252,0.05512,0.85039,0.05512,0.85827,0.05512,0.86614,0.05512,0.87402,0.05512,0.88189,0.05512,0.88976,0.05512,0.89764,0.05512,0.90551,0.05512,0.91339,0.05512,0.92126,0.05512,0.92913,0.05512,0.93701,0.05512,0.94488,0.05512,0.95276,0.05512,0.96063,0.05512,0.9685,0.05512,0.97638,0.05512,0.98425,0.05512,0.99213,0.05512,0.99609,0.05512,0.00391,0.06299,0.00787,0.06299,0.01575,0.06299,0.02362,0.06299,0.0315,0.06299,0.03937,0.06299,0.04724,0.06299,0.05512,0.06299,0.06299,0.06299,0.07087,0.06299,0.07874,0.06299,0.08661,0.06299,0.09449,0.06299,0.10236,0.06299,0.11024,0.06299,0.11811,0.06299,0.12598,0.06299,0.13386,0.06299,0.14173,0.06299,0.14961,0.06299,0.15748,0.06299,0.16535,0.06299,0.17323,0.06299,0.1811,0.06299,0.18898,0.06299,0.19685,0.06299,0.20472,0.06299,0.2126,0.06299,0.22047,0.06299,0.22835,0.06299,0.23622,0.06299,0.24409,0.06299,0.25197,0.06299,0.25984,0.06299,0.26772,0.06299,0.27559,0.06299,0.28346,0.06299,0.29134,0.06299,0.29921,0.06299,0.30709,0.06299,0.31496,0.06299,0.32283,0.06299,0.33071,0.06299,0.33858,0.06299,0.34646,0.06299,0.35433,0.06299,0.3622,0.06299,0.37008,0.06299,0.37795,0.06299,0.38583,0.06299,0.3937,0.06299,0.40157,0.06299,0.40945,0.06299,0.41732,0.06299,0.4252,0.06299,0.43307,0.06299,0.44094,0.06299,0.44882,0.06299,0.45669,0.06299,0.46457,0.06299,0.47244,0.06299,0.48031,0.06299,0.48819,0.06299,0.49606,0.06299,0.50394,0.06299,0.51181,0.06299,0.51969,0.06299,0.52756,0.06299,0.53543,0.06299,0.54331,0.06299,0.55118,0.06299,0.55906,0.06299,0.56693,0.06299,0.5748,0.06299,0.58268,0.06299,0.59055,0.06299};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.59843,0.06299,0.6063,0.06299,0.61417,0.06299,0.62205,0.06299,0.62992,0.06299,0.6378,0.06299,0.64567,0.06299,0.65354,0.06299,0.66142,0.06299,0.66929,0.06299,0.67717,0.06299,0.68504,0.06299,0.69291,0.06299,0.70079,0.06299,0.70866,0.06299,0.71654,0.06299,0.72441,0.06299,0.73228,0.06299,0.74016,0.06299,0.74803,0.06299,0.75591,0.06299,0.76378,0.06299,0.77165,0.06299,0.77953,0.06299,0.7874,0.06299,0.79528,0.06299,0.80315,0.06299,0.81102,0.06299,0.8189,0.06299,0.82677,0.06299,0.83465,0.06299,0.84252,0.06299,0.85039,0.06299,0.85827,0.06299,0.86614,0.06299,0.87402,0.06299,0.88189,0.06299,0.88976,0.06299,0.89764,0.06299,0.90551,0.06299,0.91339,0.06299,0.92126,0.06299,0.92913,0.06299,0.93701,0.06299,0.94488,0.06299,0.95276,0.06299,0.96063,0.06299,0.9685,0.06299,0.97638,0.06299,0.98425,0.06299,0.99213,0.06299,0.99609,0.06299,0.00391,0.07087,0.00787,0.07087,0.01575,0.07087,0.02362,0.07087,0.0315,0.07087,0.03937,0.07087,0.04724,0.07087,0.05512,0.07087,0.06299,0.07087,0.07087,0.07087,0.07874,0.07087,0.08661,0.07087,0.09449,0.07087,0.10236,0.07087,0.11024,0.07087,0.11811,0.07087,0.12598,0.07087,0.13386,0.07087,0.14173,0.07087,0.14961,0.07087,0.15748,0.07087,0.16535,0.07087,0.17323,0.07087,0.1811,0.07087,0.18898,0.07087,0.19685,0.07087,0.20472,0.07087,0.2126,0.07087,0.22047,0.07087,0.22835,0.07087,0.23622,0.07087,0.24409,0.07087,0.25197,0.07087,0.25984,0.07087,0.26772,0.07087,0.27559,0.07087,0.28346,0.07087,0.29134,0.07087,0.29921,0.07087,0.30709,0.07087,0.31496,0.07087,0.32283,0.07087,0.33071,0.07087,0.33858,0.07087,0.34646,0.07087,0.35433,0.07087,0.3622,0.07087,0.37008,0.07087};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.37795,0.07087,0.38583,0.07087,0.3937,0.07087,0.40157,0.07087,0.40945,0.07087,0.41732,0.07087,0.4252,0.07087,0.43307,0.07087,0.44094,0.07087,0.44882,0.07087,0.45669,0.07087,0.46457,0.07087,0.47244,0.07087,0.48031,0.07087,0.48819,0.07087,0.49606,0.07087,0.50394,0.07087,0.51181,0.07087,0.51969,0.07087,0.52756,0.07087,0.53543,0.07087,0.54331,0.07087,0.55118,0.07087,0.55906,0.07087,0.56693,0.07087,0.5748,0.07087,0.58268,0.07087,0.59055,0.07087,0.59843,0.07087,0.6063,0.07087,0.61417,0.07087,0.62205,0.07087,0.62992,0.07087,0.6378,0.07087,0.64567,0.07087,0.65354,0.07087,0.66142,0.07087,0.66929,0.07087,0.67717,0.07087,0.68504,0.07087,0.69291,0.07087,0.70079,0.07087,0.70866,0.07087,0.71654,0.07087,0.72441,0.07087,0.73228,0.07087,0.74016,0.07087,0.74803,0.07087,0.75591,0.07087,0.76378,0.07087,0.77165,0.07087,0.77953,0.07087,0.7874,0.07087,0.79528,0.07087,0.80315,0.07087,0.81102,0.07087,0.8189,0.07087,0.82677,0.07087,0.83465,0.07087,0.84252,0.07087,0.85039,0.07087,0.85827,0.07087,0.86614,0.07087,0.87402,0.07087,0.88189,0.07087,0.88976,0.07087,0.89764,0.07087,0.90551,0.07087,0.91339,0.07087,0.92126,0.07087,0.92913,0.07087,0.93701,0.07087,0.94488,0.07087,0.95276,0.07087,0.96063,0.07087,0.9685,0.07087,0.97638,0.07087,0.98425,0.07087,0.99213,0.07087,0.99609,0.07087,0.00391,0.07874,0.00787,0.07874,0.01575,0.07874,0.02362,0.07874,0.0315,0.07874,0.03937,0.07874,0.04724,0.07874,0.05512,0.07874,0.06299,0.07874,0.07087,0.07874,0.07874,0.07874,0.08661,0.07874,0.09449,0.07874,0.10236,0.07874,0.11024,0.07874,0.11811,0.07874,0.12598,0.07874,0.13386,0.07874,0.14173,0.07874,0.14961,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.15748,0.07874,0.16535,0.07874,0.17323,0.07874,0.1811,0.07874,0.18898,0.07874,0.19685,0.07874,0.20472,0.07874,0.2126,0.07874,0.22047,0.07874,0.22835,0.07874,0.23622,0.07874,0.24409,0.07874,0.25197,0.07874,0.25984,0.07874,0.26772,0.07874,0.27559,0.07874,0.28346,0.07874,0.29134,0.07874,0.29921,0.07874,0.30709,0.07874,0.31496,0.07874,0.32283,0.07874,0.33071,0.07874,0.33858,0.07874,0.34646,0.07874,0.35433,0.07874,0.3622,0.07874,0.37008,0.07874,0.37795,0.07874,0.38583,0.07874,0.3937,0.07874,0.40157,0.07874,0.40945,0.07874,0.41732,0.07874,0.4252,0.07874,0.43307,0.07874,0.44094,0.07874,0.44882,0.07874,0.45669,0.07874,0.46457,0.07874,0.47244,0.07874,0.48031,0.07874,0.48819,0.07874,0.49606,0.07874,0.50394,0.07874,0.51181,0.07874,0.51969,0.07874,0.52756,0.07874,0.53543,0.07874,0.54331,0.07874,0.55118,0.07874,0.55906,0.07874,0.56693,0.07874,0.5748,0.07874,0.58268,0.07874,0.59055,0.07874,0.59843,0.07874,0.6063,0.07874,0.61417,0.07874,0.62205,0.07874,0.62992,0.07874,0.6378,0.07874,0.64567,0.07874,0.65354,0.07874,0.66142,0.07874,0.66929,0.07874,0.67717,0.07874,0.68504,0.07874,0.69291,0.07874,0.70079,0.07874,0.70866,0.07874,0.71654,0.07874,0.72441,0.07874,0.73228,0.07874,0.74016,0.07874,0.74803,0.07874,0.75591,0.07874,0.76378,0.07874,0.77165,0.07874,0.77953,0.07874,0.7874,0.07874,0.79528,0.07874,0.80315,0.07874,0.81102,0.07874,0.8189,0.07874,0.82677,0.07874,0.83465,0.07874,0.84252,0.07874,0.85039,0.07874,0.85827,0.07874,0.86614,0.07874,0.87402,0.07874,0.88189,0.07874,0.88976,0.07874,0.89764,0.07874,0.90551,0.07874,0.91339,0.07874,0.92126,0.07874,0.92913,0.07874,0.93701,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.94488,0.07874,0.95276,0.07874,0.96063,0.07874,0.9685,0.07874,0.97638,0.07874,0.98425,0.07874,0.99213,0.07874,0.99609,0.07874,0.00391,0.08661,0.00787,0.08661,0.01575,0.08661,0.02362,0.08661,0.0315,0.08661,0.03937,0.08661,0.04724,0.08661,0.05512,0.08661,0.06299,0.08661,0.07087,0.08661,0.07874,0.08661,0.08661,0.08661,0.09449,0.08661,0.10236,0.08661,0.11024,0.08661,0.11811,0.08661,0.12598,0.08661,0.13386,0.08661,0.14173,0.08661,0.14961,0.08661,0.15748,0.08661,0.16535,0.08661,0.17323,0.08661,0.1811,0.08661,0.18898,0.08661,0.19685,0.08661,0.20472,0.08661,0.2126,0.08661,0.22047,0.08661,0.22835,0.08661,0.23622,0.08661,0.24409,0.08661,0.25197,0.08661,0.25984,0.08661,0.26772,0.08661,0.27559,0.08661,0.28346,0.08661,0.29134,0.08661,0.29921,0.08661,0.30709,0.08661,0.31496,0.08661,0.32283,0.08661,0.33071,0.08661,0.33858,0.08661,0.34646,0.08661,0.35433,0.08661,0.3622,0.08661,0.37008,0.08661,0.37795,0.08661,0.38583,0.08661,0.3937,0.08661,0.40157,0.08661,0.40945,0.08661,0.41732,0.08661,0.4252,0.08661,0.43307,0.08661,0.44094,0.08661,0.44882,0.08661,0.45669,0.08661,0.46457,0.08661,0.47244,0.08661,0.48031,0.08661,0.48819,0.08661,0.49606,0.08661,0.50394,0.08661,0.51181,0.08661,0.51969,0.08661,0.52756,0.08661,0.53543,0.08661,0.54331,0.08661,0.55118,0.08661,0.55906,0.08661,0.56693,0.08661,0.5748,0.08661,0.58268,0.08661,0.59055,0.08661,0.59843,0.08661,0.6063,0.08661,0.61417,0.08661,0.62205,0.08661,0.62992,0.08661,0.6378,0.08661,0.64567,0.08661,0.65354,0.08661,0.66142,0.08661,0.66929,0.08661,0.67717,0.08661,0.68504,0.08661,0.69291,0.08661,0.70079,0.08661,0.70866,0.08661,0.71654,0.08661};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.72441,0.08661,0.73228,0.08661,0.74016,0.08661,0.74803,0.08661,0.75591,0.08661,0.76378,0.08661,0.77165,0.08661,0.77953,0.08661,0.7874,0.08661,0.79528,0.08661,0.80315,0.08661,0.81102,0.08661,0.8189,0.08661,0.82677,0.08661,0.83465,0.08661,0.84252,0.08661,0.85039,0.08661,0.85827,0.08661,0.86614,0.08661,0.87402,0.08661,0.88189,0.08661,0.88976,0.08661,0.89764,0.08661,0.90551,0.08661,0.91339,0.08661,0.92126,0.08661,0.92913,0.08661,0.93701,0.08661,0.94488,0.08661,0.95276,0.08661,0.96063,0.08661,0.9685,0.08661,0.97638,0.08661,0.98425,0.08661,0.99213,0.08661,0.99609,0.08661,0.00391,0.09449,0.00787,0.09449,0.01575,0.09449,0.02362,0.09449,0.0315,0.09449,0.03937,0.09449,0.04724,0.09449,0.05512,0.09449,0.06299,0.09449,0.07087,0.09449,0.07874,0.09449,0.08661,0.09449,0.09449,0.09449,0.10236,0.09449,0.11024,0.09449,0.11811,0.09449,0.12598,0.09449,0.13386,0.09449,0.14173,0.09449,0.14961,0.09449,0.15748,0.09449,0.16535,0.09449,0.17323,0.09449,0.1811,0.09449,0.18898,0.09449,0.19685,0.09449,0.20472,0.09449,0.2126,0.09449,0.22047,0.09449,0.22835,0.09449,0.23622,0.09449,0.24409,0.09449,0.25197,0.09449,0.25984,0.09449,0.26772,0.09449,0.27559,0.09449,0.28346,0.09449,0.29134,0.09449,0.29921,0.09449,0.30709,0.09449,0.31496,0.09449,0.32283,0.09449,0.33071,0.09449,0.33858,0.09449,0.34646,0.09449,0.35433,0.09449,0.3622,0.09449,0.37008,0.09449,0.37795,0.09449,0.38583,0.09449,0.3937,0.09449,0.40157,0.09449,0.40945,0.09449,0.41732,0.09449,0.4252,0.09449,0.43307,0.09449,0.44094,0.09449,0.44882,0.09449,0.45669,0.09449,0.46457,0.09449,0.47244,0.09449,0.48031,0.09449,0.48819,0.09449,0.49606,0.09449};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.50394,0.09449,0.51181,0.09449,0.51969,0.09449,0.52756,0.09449,0.53543,0.09449,0.54331,0.09449,0.55118,0.09449,0.55906,0.09449,0.56693,0.09449,0.5748,0.09449,0.58268,0.09449,0.59055,0.09449,0.59843,0.09449,0.6063,0.09449,0.61417,0.09449,0.62205,0.09449,0.62992,0.09449,0.6378,0.09449,0.64567,0.09449,0.65354,0.09449,0.66142,0.09449,0.66929,0.09449,0.67717,0.09449,0.68504,0.09449,0.69291,0.09449,0.70079,0.09449,0.70866,0.09449,0.71654,0.09449,0.72441,0.09449,0.73228,0.09449,0.74016,0.09449,0.74803,0.09449,0.75591,0.09449,0.76378,0.09449,0.77165,0.09449,0.77953,0.09449,0.7874,0.09449,0.79528,0.09449,0.80315,0.09449,0.81102,0.09449,0.8189,0.09449,0.82677,0.09449,0.83465,0.09449,0.84252,0.09449,0.85039,0.09449,0.85827,0.09449,0.86614,0.09449,0.87402,0.09449,0.88189,0.09449,0.88976,0.09449,0.89764,0.09449,0.90551,0.09449,0.91339,0.09449,0.92126,0.09449,0.92913,0.09449,0.93701,0.09449,0.94488,0.09449,0.95276,0.09449,0.96063,0.09449,0.9685,0.09449,0.97638,0.09449,0.98425,0.09449,0.99213,0.09449,0.99609,0.09449,0.00391,0.10236,0.00787,0.10236,0.01575,0.10236,0.02362,0.10236,0.0315,0.10236,0.03937,0.10236,0.04724,0.10236,0.05512,0.10236,0.06299,0.10236,0.07087,0.10236,0.07874,0.10236,0.08661,0.10236,0.09449,0.10236,0.10236,0.10236,0.11024,0.10236,0.11811,0.10236,0.12598,0.10236,0.13386,0.10236,0.14173,0.10236,0.14961,0.10236,0.15748,0.10236,0.16535,0.10236,0.17323,0.10236,0.1811,0.10236,0.18898,0.10236,0.19685,0.10236,0.20472,0.10236,0.2126,0.10236,0.22047,0.10236,0.22835,0.10236,0.23622,0.10236,0.24409,0.10236,0.25197,0.10236,0.25984,0.10236,0.26772,0.10236,0.27559,0.10236};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.28346,0.10236,0.29134,0.10236,0.29921,0.10236,0.30709,0.10236,0.31496,0.10236,0.32283,0.10236,0.33071,0.10236,0.33858,0.10236,0.34646,0.10236,0.35433,0.10236,0.3622,0.10236,0.37008,0.10236,0.37795,0.10236,0.38583,0.10236,0.3937,0.10236,0.40157,0.10236,0.40945,0.10236,0.41732,0.10236,0.4252,0.10236,0.43307,0.10236,0.44094,0.10236,0.44882,0.10236,0.45669,0.10236,0.46457,0.10236,0.47244,0.10236,0.48031,0.10236,0.48819,0.10236,0.49606,0.10236,0.50394,0.10236,0.51181,0.10236,0.51969,0.10236,0.52756,0.10236,0.53543,0.10236,0.54331,0.10236,0.55118,0.10236,0.55906,0.10236,0.56693,0.10236,0.5748,0.10236,0.58268,0.10236,0.59055,0.10236,0.59843,0.10236,0.6063,0.10236,0.61417,0.10236,0.62205,0.10236,0.62992,0.10236,0.6378,0.10236,0.64567,0.10236,0.65354,0.10236,0.66142,0.10236,0.66929,0.10236,0.67717,0.10236,0.68504,0.10236,0.69291,0.10236,0.70079,0.10236,0.70866,0.10236,0.71654,0.10236,0.72441,0.10236,0.73228,0.10236,0.74016,0.10236,0.74803,0.10236,0.75591,0.10236,0.76378,0.10236,0.77165,0.10236,0.77953,0.10236,0.7874,0.10236,0.79528,0.10236,0.80315,0.10236,0.81102,0.10236,0.8189,0.10236,0.82677,0.10236,0.83465,0.10236,0.84252,0.10236,0.85039,0.10236,0.85827,0.10236,0.86614,0.10236,0.87402,0.10236,0.88189,0.10236,0.88976,0.10236,0.89764,0.10236,0.90551,0.10236,0.91339,0.10236,0.92126,0.10236,0.92913,0.10236,0.93701,0.10236,0.94488,0.10236,0.95276,0.10236,0.96063,0.10236,0.9685,0.10236,0.97638,0.10236,0.98425,0.10236,0.99213,0.10236,0.99609,0.10236,0.00391,0.11024,0.00787,0.11024,0.01575,0.11024,0.02362,0.11024,0.0315,0.11024,0.03937,0.11024,0.04724,0.11024,0.05512,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.06299,0.11024,0.07087,0.11024,0.07874,0.11024,0.08661,0.11024,0.09449,0.11024,0.10236,0.11024,0.11024,0.11024,0.11811,0.11024,0.12598,0.11024,0.13386,0.11024,0.14173,0.11024,0.14961,0.11024,0.15748,0.11024,0.16535,0.11024,0.17323,0.11024,0.1811,0.11024,0.18898,0.11024,0.19685,0.11024,0.20472,0.11024,0.2126,0.11024,0.22047,0.11024,0.22835,0.11024,0.23622,0.11024,0.24409,0.11024,0.25197,0.11024,0.25984,0.11024,0.26772,0.11024,0.27559,0.11024,0.28346,0.11024,0.29134,0.11024,0.29921,0.11024,0.30709,0.11024,0.31496,0.11024,0.32283,0.11024,0.33071,0.11024,0.33858,0.11024,0.34646,0.11024,0.35433,0.11024,0.3622,0.11024,0.37008,0.11024,0.37795,0.11024,0.38583,0.11024,0.3937,0.11024,0.40157,0.11024,0.40945,0.11024,0.41732,0.11024,0.4252,0.11024,0.43307,0.11024,0.44094,0.11024,0.44882,0.11024,0.45669,0.11024,0.46457,0.11024,0.47244,0.11024,0.48031,0.11024,0.48819,0.11024,0.49606,0.11024,0.50394,0.11024,0.51181,0.11024,0.51969,0.11024,0.52756,0.11024,0.53543,0.11024,0.54331,0.11024,0.55118,0.11024,0.55906,0.11024,0.56693,0.11024,0.5748,0.11024,0.58268,0.11024,0.59055,0.11024,0.59843,0.11024,0.6063,0.11024,0.61417,0.11024,0.62205,0.11024,0.62992,0.11024,0.6378,0.11024,0.64567,0.11024,0.65354,0.11024,0.66142,0.11024,0.66929,0.11024,0.67717,0.11024,0.68504,0.11024,0.69291,0.11024,0.70079,0.11024,0.70866,0.11024,0.71654,0.11024,0.72441,0.11024,0.73228,0.11024,0.74016,0.11024,0.74803,0.11024,0.75591,0.11024,0.76378,0.11024,0.77165,0.11024,0.77953,0.11024,0.7874,0.11024,0.79528,0.11024,0.80315,0.11024,0.81102,0.11024,0.8189,0.11024,0.82677,0.11024,0.83465,0.11024,0.84252,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.85039,0.11024,0.85827,0.11024,0.86614,0.11024,0.87402,0.11024,0.88189,0.11024,0.88976,0.11024,0.89764,0.11024,0.90551,0.11024,0.91339,0.11024,0.92126,0.11024,0.92913,0.11024,0.93701,0.11024,0.94488,0.11024,0.95276,0.11024,0.96063,0.11024,0.9685,0.11024,0.97638,0.11024,0.98425,0.11024,0.99213,0.11024,0.99609,0.11024,0.00391,0.11811,0.00787,0.11811,0.01575,0.11811,0.02362,0.11811,0.0315,0.11811,0.03937,0.11811,0.04724,0.11811,0.05512,0.11811,0.06299,0.11811,0.07087,0.11811,0.07874,0.11811,0.08661,0.11811,0.09449,0.11811,0.10236,0.11811,0.11024,0.11811,0.11811,0.11811,0.12598,0.11811,0.13386,0.11811,0.14173,0.11811,0.14961,0.11811,0.15748,0.11811,0.16535,0.11811,0.17323,0.11811,0.1811,0.11811,0.18898,0.11811,0.19685,0.11811,0.20472,0.11811,0.2126,0.11811,0.22047,0.11811,0.22835,0.11811,0.23622,0.11811,0.24409,0.11811,0.25197,0.11811,0.25984,0.11811,0.26772,0.11811,0.27559,0.11811,0.28346,0.11811,0.29134,0.11811,0.29921,0.11811,0.30709,0.11811,0.31496,0.11811,0.32283,0.11811,0.33071,0.11811,0.33858,0.11811,0.34646,0.11811,0.35433,0.11811,0.3622,0.11811,0.37008,0.11811,0.37795,0.11811,0.38583,0.11811,0.3937,0.11811,0.40157,0.11811,0.40945,0.11811,0.41732,0.11811,0.4252,0.11811,0.43307,0.11811,0.44094,0.11811,0.44882,0.11811,0.45669,0.11811,0.46457,0.11811,0.47244,0.11811,0.48031,0.11811,0.48819,0.11811,0.49606,0.11811,0.50394,0.11811,0.51181,0.11811,0.51969,0.11811,0.52756,0.11811,0.53543,0.11811,0.54331,0.11811,0.55118,0.11811,0.55906,0.11811,0.56693,0.11811,0.5748,0.11811,0.58268,0.11811,0.59055,0.11811,0.59843,0.11811,0.6063,0.11811,0.61417,0.11811,0.62205,0.11811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.62992,0.11811,0.6378,0.11811,0.64567,0.11811,0.65354,0.11811,0.66142,0.11811,0.66929,0.11811,0.67717,0.11811,0.68504,0.11811,0.69291,0.11811,0.70079,0.11811,0.70866,0.11811,0.71654,0.11811,0.72441,0.11811,0.73228,0.11811,0.74016,0.11811,0.74803,0.11811,0.75591,0.11811,0.76378,0.11811,0.77165,0.11811,0.77953,0.11811,0.7874,0.11811,0.79528,0.11811,0.80315,0.11811,0.81102,0.11811,0.8189,0.11811,0.82677,0.11811,0.83465,0.11811,0.84252,0.11811,0.85039,0.11811,0.85827,0.11811,0.86614,0.11811,0.87402,0.11811,0.88189,0.11811,0.88976,0.11811,0.89764,0.11811,0.90551,0.11811,0.91339,0.11811,0.92126,0.11811,0.92913,0.11811,0.93701,0.11811,0.94488,0.11811,0.95276,0.11811,0.96063,0.11811,0.9685,0.11811,0.97638,0.11811,0.98425,0.11811,0.99213,0.11811,0.99609,0.11811,0.00391,0.12598,0.00787,0.12598,0.01575,0.12598,0.02362,0.12598,0.0315,0.12598,0.03937,0.12598,0.04724,0.12598,0.05512,0.12598,0.06299,0.12598,0.07087,0.12598,0.07874,0.12598,0.08661,0.12598,0.09449,0.12598,0.10236,0.12598,0.11024,0.12598,0.11811,0.12598,0.12598,0.12598,0.13386,0.12598,0.14173,0.12598,0.14961,0.12598,0.15748,0.12598,0.16535,0.12598,0.17323,0.12598,0.1811,0.12598,0.18898,0.12598,0.19685,0.12598,0.20472,0.12598,0.2126,0.12598,0.22047,0.12598,0.22835,0.12598,0.23622,0.12598,0.24409,0.12598,0.25197,0.12598,0.25984,0.12598,0.26772,0.12598,0.27559,0.12598,0.28346,0.12598,0.29134,0.12598,0.29921,0.12598,0.30709,0.12598,0.31496,0.12598,0.32283,0.12598,0.33071,0.12598,0.33858,0.12598,0.34646,0.12598,0.35433,0.12598,0.3622,0.12598,0.37008,0.12598,0.37795,0.12598,0.38583,0.12598,0.3937,0.12598,0.40157,0.12598};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.40945,0.12598,0.41732,0.12598,0.4252,0.12598,0.43307,0.12598,0.44094,0.12598,0.44882,0.12598,0.45669,0.12598,0.46457,0.12598,0.47244,0.12598,0.48031,0.12598,0.48819,0.12598,0.49606,0.12598,0.50394,0.12598,0.51181,0.12598,0.51969,0.12598,0.52756,0.12598,0.53543,0.12598,0.54331,0.12598,0.55118,0.12598,0.55906,0.12598,0.56693,0.12598,0.5748,0.12598,0.58268,0.12598,0.59055,0.12598,0.59843,0.12598,0.6063,0.12598,0.61417,0.12598,0.62205,0.12598,0.62992,0.12598,0.6378,0.12598,0.64567,0.12598,0.65354,0.12598,0.66142,0.12598,0.66929,0.12598,0.67717,0.12598,0.68504,0.12598,0.69291,0.12598,0.70079,0.12598,0.70866,0.12598,0.71654,0.12598,0.72441,0.12598,0.73228,0.12598,0.74016,0.12598,0.74803,0.12598,0.75591,0.12598,0.76378,0.12598,0.77165,0.12598,0.77953,0.12598,0.7874,0.12598,0.79528,0.12598,0.80315,0.12598,0.81102,0.12598,0.8189,0.12598,0.82677,0.12598,0.83465,0.12598,0.84252,0.12598,0.85039,0.12598,0.85827,0.12598,0.86614,0.12598,0.87402,0.12598,0.88189,0.12598,0.88976,0.12598,0.89764,0.12598,0.90551,0.12598,0.91339,0.12598,0.92126,0.12598,0.92913,0.12598,0.93701,0.12598,0.94488,0.12598,0.95276,0.12598,0.96063,0.12598,0.9685,0.12598,0.97638,0.12598,0.98425,0.12598,0.99213,0.12598,0.99609,0.12598,0.00391,0.13386,0.00787,0.13386,0.01575,0.13386,0.02362,0.13386,0.0315,0.13386,0.03937,0.13386,0.04724,0.13386,0.05512,0.13386,0.06299,0.13386,0.07087,0.13386,0.07874,0.13386,0.08661,0.13386,0.09449,0.13386,0.10236,0.13386,0.11024,0.13386,0.11811,0.13386,0.12598,0.13386,0.13386,0.13386,0.14173,0.13386,0.14961,0.13386,0.15748,0.13386,0.16535,0.13386,0.17323,0.13386,0.1811,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.18898,0.13386,0.19685,0.13386,0.20472,0.13386,0.2126,0.13386,0.22047,0.13386,0.22835,0.13386,0.23622,0.13386,0.24409,0.13386,0.25197,0.13386,0.25984,0.13386,0.26772,0.13386,0.27559,0.13386,0.28346,0.13386,0.29134,0.13386,0.29921,0.13386,0.30709,0.13386,0.31496,0.13386,0.32283,0.13386,0.33071,0.13386,0.33858,0.13386,0.34646,0.13386,0.35433,0.13386,0.3622,0.13386,0.37008,0.13386,0.37795,0.13386,0.38583,0.13386,0.3937,0.13386,0.40157,0.13386,0.40945,0.13386,0.41732,0.13386,0.4252,0.13386,0.43307,0.13386,0.44094,0.13386,0.44882,0.13386,0.45669,0.13386,0.46457,0.13386,0.47244,0.13386,0.48031,0.13386,0.48819,0.13386,0.49606,0.13386,0.50394,0.13386,0.51181,0.13386,0.51969,0.13386,0.52756,0.13386,0.53543,0.13386,0.54331,0.13386,0.55118,0.13386,0.55906,0.13386,0.56693,0.13386,0.5748,0.13386,0.58268,0.13386,0.59055,0.13386,0.59843,0.13386,0.6063,0.13386,0.61417,0.13386,0.62205,0.13386,0.62992,0.13386,0.6378,0.13386,0.64567,0.13386,0.65354,0.13386,0.66142,0.13386,0.66929,0.13386,0.67717,0.13386,0.68504,0.13386,0.69291,0.13386,0.70079,0.13386,0.70866,0.13386,0.71654,0.13386,0.72441,0.13386,0.73228,0.13386,0.74016,0.13386,0.74803,0.13386,0.75591,0.13386,0.76378,0.13386,0.77165,0.13386,0.77953,0.13386,0.7874,0.13386,0.79528,0.13386,0.80315,0.13386,0.81102,0.13386,0.8189,0.13386,0.82677,0.13386,0.83465,0.13386,0.84252,0.13386,0.85039,0.13386,0.85827,0.13386,0.86614,0.13386,0.87402,0.13386,0.88189,0.13386,0.88976,0.13386,0.89764,0.13386,0.90551,0.13386,0.91339,0.13386,0.92126,0.13386,0.92913,0.13386,0.93701,0.13386,0.94488,0.13386,0.95276,0.13386,0.96063,0.13386,0.9685,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.97638,0.13386,0.98425,0.13386,0.99213,0.13386,0.99609,0.13386,0.00391,0.14173,0.00787,0.14173,0.01575,0.14173,0.02362,0.14173,0.0315,0.14173,0.03937,0.14173,0.04724,0.14173,0.05512,0.14173,0.06299,0.14173,0.07087,0.14173,0.07874,0.14173,0.08661,0.14173,0.09449,0.14173,0.10236,0.14173,0.11024,0.14173,0.11811,0.14173,0.12598,0.14173,0.13386,0.14173,0.14173,0.14173,0.14961,0.14173,0.15748,0.14173,0.16535,0.14173,0.17323,0.14173,0.1811,0.14173,0.18898,0.14173,0.19685,0.14173,0.20472,0.14173,0.2126,0.14173,0.22047,0.14173,0.22835,0.14173,0.23622,0.14173,0.24409,0.14173,0.25197,0.14173,0.25984,0.14173,0.26772,0.14173,0.27559,0.14173,0.28346,0.14173,0.29134,0.14173,0.29921,0.14173,0.30709,0.14173,0.31496,0.14173,0.32283,0.14173,0.33071,0.14173,0.33858,0.14173,0.34646,0.14173,0.35433,0.14173,0.3622,0.14173,0.37008,0.14173,0.37795,0.14173,0.38583,0.14173,0.3937,0.14173,0.40157,0.14173,0.40945,0.14173,0.41732,0.14173,0.4252,0.14173,0.43307,0.14173,0.44094,0.14173,0.44882,0.14173,0.45669,0.14173,0.46457,0.14173,0.47244,0.14173,0.48031,0.14173,0.48819,0.14173,0.49606,0.14173,0.50394,0.14173,0.51181,0.14173,0.51969,0.14173,0.52756,0.14173,0.53543,0.14173,0.54331,0.14173,0.55118,0.14173,0.55906,0.14173,0.56693,0.14173,0.5748,0.14173,0.58268,0.14173,0.59055,0.14173,0.59843,0.14173,0.6063,0.14173,0.61417,0.14173,0.62205,0.14173,0.62992,0.14173,0.6378,0.14173,0.64567,0.14173,0.65354,0.14173,0.66142,0.14173,0.66929,0.14173,0.67717,0.14173,0.68504,0.14173,0.69291,0.14173,0.70079,0.14173,0.70866,0.14173,0.71654,0.14173,0.72441,0.14173,0.73228,0.14173,0.74016,0.14173,0.74803,0.14173};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.75591,0.14173,0.76378,0.14173,0.77165,0.14173,0.77953,0.14173,0.7874,0.14173,0.79528,0.14173,0.80315,0.14173,0.81102,0.14173,0.8189,0.14173,0.82677,0.14173,0.83465,0.14173,0.84252,0.14173,0.85039,0.14173,0.85827,0.14173,0.86614,0.14173,0.87402,0.14173,0.88189,0.14173,0.88976,0.14173,0.89764,0.14173,0.90551,0.14173,0.91339,0.14173,0.92126,0.14173,0.92913,0.14173,0.93701,0.14173,0.94488,0.14173,0.95276,0.14173,0.96063,0.14173,0.9685,0.14173,0.97638,0.14173,0.98425,0.14173,0.99213,0.14173,0.99609,0.14173,0.00391,0.14961,0.00787,0.14961,0.01575,0.14961,0.02362,0.14961,0.0315,0.14961,0.03937,0.14961,0.04724,0.14961,0.05512,0.14961,0.06299,0.14961,0.07087,0.14961,0.07874,0.14961,0.08661,0.14961,0.09449,0.14961,0.10236,0.14961,0.11024,0.14961,0.11811,0.14961,0.12598,0.14961,0.13386,0.14961,0.14173,0.14961,0.14961,0.14961,0.15748,0.14961,0.16535,0.14961,0.17323,0.14961,0.1811,0.14961,0.18898,0.14961,0.19685,0.14961,0.20472,0.14961,0.2126,0.14961,0.22047,0.14961,0.22835,0.14961,0.23622,0.14961,0.24409,0.14961,0.25197,0.14961,0.25984,0.14961,0.26772,0.14961,0.27559,0.14961,0.28346,0.14961,0.29134,0.14961,0.29921,0.14961,0.30709,0.14961,0.31496,0.14961,0.32283,0.14961,0.33071,0.14961,0.33858,0.14961,0.34646,0.14961,0.35433,0.14961,0.3622,0.14961,0.37008,0.14961,0.37795,0.14961,0.38583,0.14961,0.3937,0.14961,0.40157,0.14961,0.40945,0.14961,0.41732,0.14961,0.4252,0.14961,0.43307,0.14961,0.44094,0.14961,0.44882,0.14961,0.45669,0.14961,0.46457,0.14961,0.47244,0.14961,0.48031,0.14961,0.48819,0.14961,0.49606,0.14961,0.50394,0.14961,0.51181,0.14961,0.51969,0.14961,0.52756,0.14961};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.53543,0.14961,0.54331,0.14961,0.55118,0.14961,0.55906,0.14961,0.56693,0.14961,0.5748,0.14961,0.58268,0.14961,0.59055,0.14961,0.59843,0.14961,0.6063,0.14961,0.61417,0.14961,0.62205,0.14961,0.62992,0.14961,0.6378,0.14961,0.64567,0.14961,0.65354,0.14961,0.66142,0.14961,0.66929,0.14961,0.67717,0.14961,0.68504,0.14961,0.69291,0.14961,0.70079,0.14961,0.70866,0.14961,0.71654,0.14961,0.72441,0.14961,0.73228,0.14961,0.74016,0.14961,0.74803,0.14961,0.75591,0.14961,0.76378,0.14961,0.77165,0.14961,0.77953,0.14961,0.7874,0.14961,0.79528,0.14961,0.80315,0.14961,0.81102,0.14961,0.8189,0.14961,0.82677,0.14961,0.83465,0.14961,0.84252,0.14961,0.85039,0.14961,0.85827,0.14961,0.86614,0.14961,0.87402,0.14961,0.88189,0.14961,0.88976,0.14961,0.89764,0.14961,0.90551,0.14961,0.91339,0.14961,0.92126,0.14961,0.92913,0.14961,0.93701,0.14961,0.94488,0.14961,0.95276,0.14961,0.96063,0.14961,0.9685,0.14961,0.97638,0.14961,0.98425,0.14961,0.99213,0.14961,0.99609,0.14961,0.00391,0.15748,0.00787,0.15748,0.01575,0.15748,0.02362,0.15748,0.0315,0.15748,0.03937,0.15748,0.04724,0.15748,0.05512,0.15748,0.06299,0.15748,0.07087,0.15748,0.07874,0.15748,0.08661,0.15748,0.09449,0.15748,0.10236,0.15748,0.11024,0.15748,0.11811,0.15748,0.12598,0.15748,0.13386,0.15748,0.14173,0.15748,0.14961,0.15748,0.15748,0.15748,0.16535,0.15748,0.17323,0.15748,0.1811,0.15748,0.18898,0.15748,0.19685,0.15748,0.20472,0.15748,0.2126,0.15748,0.22047,0.15748,0.22835,0.15748,0.23622,0.15748,0.24409,0.15748,0.25197,0.15748,0.25984,0.15748,0.26772,0.15748,0.27559,0.15748,0.28346,0.15748,0.29134,0.15748,0.29921,0.15748,0.30709,0.15748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.31496,0.15748,0.32283,0.15748,0.33071,0.15748,0.33858,0.15748,0.34646,0.15748,0.35433,0.15748,0.3622,0.15748,0.37008,0.15748,0.37795,0.15748,0.38583,0.15748,0.3937,0.15748,0.40157,0.15748,0.40945,0.15748,0.41732,0.15748,0.4252,0.15748,0.43307,0.15748,0.44094,0.15748,0.44882,0.15748,0.45669,0.15748,0.46457,0.15748,0.47244,0.15748,0.48031,0.15748,0.48819,0.15748,0.49606,0.15748,0.50394,0.15748,0.51181,0.15748,0.51969,0.15748,0.52756,0.15748,0.53543,0.15748,0.54331,0.15748,0.55118,0.15748,0.55906,0.15748,0.56693,0.15748,0.5748,0.15748,0.58268,0.15748,0.59055,0.15748,0.59843,0.15748,0.6063,0.15748,0.61417,0.15748,0.62205,0.15748,0.62992,0.15748,0.6378,0.15748,0.64567,0.15748,0.65354,0.15748,0.66142,0.15748,0.66929,0.15748,0.67717,0.15748,0.68504,0.15748,0.69291,0.15748,0.70079,0.15748,0.70866,0.15748,0.71654,0.15748,0.72441,0.15748,0.73228,0.15748,0.74016,0.15748,0.74803,0.15748,0.75591,0.15748,0.76378,0.15748,0.77165,0.15748,0.77953,0.15748,0.7874,0.15748,0.79528,0.15748,0.80315,0.15748,0.81102,0.15748,0.8189,0.15748,0.82677,0.15748,0.83465,0.15748,0.84252,0.15748,0.85039,0.15748,0.85827,0.15748,0.86614,0.15748,0.87402,0.15748,0.88189,0.15748,0.88976,0.15748,0.89764,0.15748,0.90551,0.15748,0.91339,0.15748,0.92126,0.15748,0.92913,0.15748,0.93701,0.15748,0.94488,0.15748,0.95276,0.15748,0.96063,0.15748,0.9685,0.15748,0.97638,0.15748,0.98425,0.15748,0.99213,0.15748,0.99609,0.15748,0.00391,0.16535,0.00787,0.16535,0.01575,0.16535,0.02362,0.16535,0.0315,0.16535,0.03937,0.16535,0.04724,0.16535,0.05512,0.16535,0.06299,0.16535,0.07087,0.16535,0.07874,0.16535,0.08661,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.09449,0.16535,0.10236,0.16535,0.11024,0.16535,0.11811,0.16535,0.12598,0.16535,0.13386,0.16535,0.14173,0.16535,0.14961,0.16535,0.15748,0.16535,0.16535,0.16535,0.17323,0.16535,0.1811,0.16535,0.18898,0.16535,0.19685,0.16535,0.20472,0.16535,0.2126,0.16535,0.22047,0.16535,0.22835,0.16535,0.23622,0.16535,0.24409,0.16535,0.25197,0.16535,0.25984,0.16535,0.26772,0.16535,0.27559,0.16535,0.28346,0.16535,0.29134,0.16535,0.29921,0.16535,0.30709,0.16535,0.31496,0.16535,0.32283,0.16535,0.33071,0.16535,0.33858,0.16535,0.34646,0.16535,0.35433,0.16535,0.3622,0.16535,0.37008,0.16535,0.37795,0.16535,0.38583,0.16535,0.3937,0.16535,0.40157,0.16535,0.40945,0.16535,0.41732,0.16535,0.4252,0.16535,0.43307,0.16535,0.44094,0.16535,0.44882,0.16535,0.45669,0.16535,0.46457,0.16535,0.47244,0.16535,0.48031,0.16535,0.48819,0.16535,0.49606,0.16535,0.50394,0.16535,0.51181,0.16535,0.51969,0.16535,0.52756,0.16535,0.53543,0.16535,0.54331,0.16535,0.55118,0.16535,0.55906,0.16535,0.56693,0.16535,0.5748,0.16535,0.58268,0.16535,0.59055,0.16535,0.59843,0.16535,0.6063,0.16535,0.61417,0.16535,0.62205,0.16535,0.62992,0.16535,0.6378,0.16535,0.64567,0.16535,0.65354,0.16535,0.66142,0.16535,0.66929,0.16535,0.67717,0.16535,0.68504,0.16535,0.69291,0.16535,0.70079,0.16535,0.70866,0.16535,0.71654,0.16535,0.72441,0.16535,0.73228,0.16535,0.74016,0.16535,0.74803,0.16535,0.75591,0.16535,0.76378,0.16535,0.77165,0.16535,0.77953,0.16535,0.7874,0.16535,0.79528,0.16535,0.80315,0.16535,0.81102,0.16535,0.8189,0.16535,0.82677,0.16535,0.83465,0.16535,0.84252,0.16535,0.85039,0.16535,0.85827,0.16535,0.86614,0.16535,0.87402,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.88189,0.16535,0.88976,0.16535,0.89764,0.16535,0.90551,0.16535,0.91339,0.16535,0.92126,0.16535,0.92913,0.16535,0.93701,0.16535,0.94488,0.16535,0.95276,0.16535,0.96063,0.16535,0.9685,0.16535,0.97638,0.16535,0.98425,0.16535,0.99213,0.16535,0.99609,0.16535,0.00391,0.17323,0.00787,0.17323,0.01575,0.17323,0.02362,0.17323,0.0315,0.17323,0.03937,0.17323,0.04724,0.17323,0.05512,0.17323,0.06299,0.17323,0.07087,0.17323,0.07874,0.17323,0.08661,0.17323,0.09449,0.17323,0.10236,0.17323,0.11024,0.17323,0.11811,0.17323,0.12598,0.17323,0.13386,0.17323,0.14173,0.17323,0.14961,0.17323,0.15748,0.17323,0.16535,0.17323,0.17323,0.17323,0.1811,0.17323,0.18898,0.17323,0.19685,0.17323,0.20472,0.17323,0.2126,0.17323,0.22047,0.17323,0.22835,0.17323,0.23622,0.17323,0.24409,0.17323,0.25197,0.17323,0.25984,0.17323,0.26772,0.17323,0.27559,0.17323,0.28346,0.17323,0.29134,0.17323,0.29921,0.17323,0.30709,0.17323,0.31496,0.17323,0.32283,0.17323,0.33071,0.17323,0.33858,0.17323,0.34646,0.17323,0.35433,0.17323,0.3622,0.17323,0.37008,0.17323,0.37795,0.17323,0.38583,0.17323,0.3937,0.17323,0.40157,0.17323,0.40945,0.17323,0.41732,0.17323,0.4252,0.17323,0.43307,0.17323,0.44094,0.17323,0.44882,0.17323,0.45669,0.17323,0.46457,0.17323,0.47244,0.17323,0.48031,0.17323,0.48819,0.17323,0.49606,0.17323,0.50394,0.17323,0.51181,0.17323,0.51969,0.17323,0.52756,0.17323,0.53543,0.17323,0.54331,0.17323,0.55118,0.17323,0.55906,0.17323,0.56693,0.17323,0.5748,0.17323,0.58268,0.17323,0.59055,0.17323,0.59843,0.17323,0.6063,0.17323,0.61417,0.17323,0.62205,0.17323,0.62992,0.17323,0.6378,0.17323,0.64567,0.17323,0.65354,0.17323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.66142,0.17323,0.66929,0.17323,0.67717,0.17323,0.68504,0.17323,0.69291,0.17323,0.70079,0.17323,0.70866,0.17323,0.71654,0.17323,0.72441,0.17323,0.73228,0.17323,0.74016,0.17323,0.74803,0.17323,0.75591,0.17323,0.76378,0.17323,0.77165,0.17323,0.77953,0.17323,0.7874,0.17323,0.79528,0.17323,0.80315,0.17323,0.81102,0.17323,0.8189,0.17323,0.82677,0.17323,0.83465,0.17323,0.84252,0.17323,0.85039,0.17323,0.85827,0.17323,0.86614,0.17323,0.87402,0.17323,0.88189,0.17323,0.88976,0.17323,0.89764,0.17323,0.90551,0.17323,0.91339,0.17323,0.92126,0.17323,0.92913,0.17323,0.93701,0.17323,0.94488,0.17323,0.95276,0.17323,0.96063,0.17323,0.9685,0.17323,0.97638,0.17323,0.98425,0.17323,0.99213,0.17323,0.99609,0.17323,0.00391,0.1811,0.00787,0.1811,0.01575,0.1811,0.02362,0.1811,0.0315,0.1811,0.03937,0.1811,0.04724,0.1811,0.05512,0.1811,0.06299,0.1811,0.07087,0.1811,0.07874,0.1811,0.08661,0.1811,0.09449,0.1811,0.10236,0.1811,0.11024,0.1811,0.11811,0.1811,0.12598,0.1811,0.13386,0.1811,0.14173,0.1811,0.14961,0.1811,0.15748,0.1811,0.16535,0.1811,0.17323,0.1811,0.1811,0.1811,0.18898,0.1811,0.19685,0.1811,0.20472,0.1811,0.2126,0.1811,0.22047,0.1811,0.22835,0.1811,0.23622,0.1811,0.24409,0.1811,0.25197,0.1811,0.25984,0.1811,0.26772,0.1811,0.27559,0.1811,0.28346,0.1811,0.29134,0.1811,0.29921,0.1811,0.30709,0.1811,0.31496,0.1811,0.32283,0.1811,0.33071,0.1811,0.33858,0.1811,0.34646,0.1811,0.35433,0.1811,0.3622,0.1811,0.37008,0.1811,0.37795,0.1811,0.38583,0.1811,0.3937,0.1811,0.40157,0.1811,0.40945,0.1811,0.41732,0.1811,0.4252,0.1811,0.43307,0.1811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.44094,0.1811,0.44882,0.1811,0.45669,0.1811,0.46457,0.1811,0.47244,0.1811,0.48031,0.1811,0.48819,0.1811,0.49606,0.1811,0.50394,0.1811,0.51181,0.1811,0.51969,0.1811,0.52756,0.1811,0.53543,0.1811,0.54331,0.1811,0.55118,0.1811,0.55906,0.1811,0.56693,0.1811,0.5748,0.1811,0.58268,0.1811,0.59055,0.1811,0.59843,0.1811,0.6063,0.1811,0.61417,0.1811,0.62205,0.1811,0.62992,0.1811,0.6378,0.1811,0.64567,0.1811,0.65354,0.1811,0.66142,0.1811,0.66929,0.1811,0.67717,0.1811,0.68504,0.1811,0.69291,0.1811,0.70079,0.1811,0.70866,0.1811,0.71654,0.1811,0.72441,0.1811,0.73228,0.1811,0.74016,0.1811,0.74803,0.1811,0.75591,0.1811,0.76378,0.1811,0.77165,0.1811,0.77953,0.1811,0.7874,0.1811,0.79528,0.1811,0.80315,0.1811,0.81102,0.1811,0.8189,0.1811,0.82677,0.1811,0.83465,0.1811,0.84252,0.1811,0.85039,0.1811,0.85827,0.1811,0.86614,0.1811,0.87402,0.1811,0.88189,0.1811,0.88976,0.1811,0.89764,0.1811,0.90551,0.1811,0.91339,0.1811,0.92126,0.1811,0.92913,0.1811,0.93701,0.1811,0.94488,0.1811,0.95276,0.1811,0.96063,0.1811,0.9685,0.1811,0.97638,0.1811,0.98425,0.1811,0.99213,0.1811,0.99609,0.1811,0.00391,0.18898,0.00787,0.18898,0.01575,0.18898,0.02362,0.18898,0.0315,0.18898,0.03937,0.18898,0.04724,0.18898,0.05512,0.18898,0.06299,0.18898,0.07087,0.18898,0.07874,0.18898,0.08661,0.18898,0.09449,0.18898,0.10236,0.18898,0.11024,0.18898,0.11811,0.18898,0.12598,0.18898,0.13386,0.18898,0.14173,0.18898,0.14961,0.18898,0.15748,0.18898,0.16535,0.18898,0.17323,0.18898,0.1811,0.18898,0.18898,0.18898,0.19685,0.18898,0.20472,0.18898,0.2126,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.22047,0.18898,0.22835,0.18898,0.23622,0.18898,0.24409,0.18898,0.25197,0.18898,0.25984,0.18898,0.26772,0.18898,0.27559,0.18898,0.28346,0.18898,0.29134,0.18898,0.29921,0.18898,0.30709,0.18898,0.31496,0.18898,0.32283,0.18898,0.33071,0.18898,0.33858,0.18898,0.34646,0.18898,0.35433,0.18898,0.3622,0.18898,0.37008,0.18898,0.37795,0.18898,0.38583,0.18898,0.3937,0.18898,0.40157,0.18898,0.40945,0.18898,0.41732,0.18898,0.4252,0.18898,0.43307,0.18898,0.44094,0.18898,0.44882,0.18898,0.45669,0.18898,0.46457,0.18898,0.47244,0.18898,0.48031,0.18898,0.48819,0.18898,0.49606,0.18898,0.50394,0.18898,0.51181,0.18898,0.51969,0.18898,0.52756,0.18898,0.53543,0.18898,0.54331,0.18898,0.55118,0.18898,0.55906,0.18898,0.56693,0.18898,0.5748,0.18898,0.58268,0.18898,0.59055,0.18898,0.59843,0.18898,0.6063,0.18898,0.61417,0.18898,0.62205,0.18898,0.62992,0.18898,0.6378,0.18898,0.64567,0.18898,0.65354,0.18898,0.66142,0.18898,0.66929,0.18898,0.67717,0.18898,0.68504,0.18898,0.69291,0.18898,0.70079,0.18898,0.70866,0.18898,0.71654,0.18898,0.72441,0.18898,0.73228,0.18898,0.74016,0.18898,0.74803,0.18898,0.75591,0.18898,0.76378,0.18898,0.77165,0.18898,0.77953,0.18898,0.7874,0.18898,0.79528,0.18898,0.80315,0.18898,0.81102,0.18898,0.8189,0.18898,0.82677,0.18898,0.83465,0.18898,0.84252,0.18898,0.85039,0.18898,0.85827,0.18898,0.86614,0.18898,0.87402,0.18898,0.88189,0.18898,0.88976,0.18898,0.89764,0.18898,0.90551,0.18898,0.91339,0.18898,0.92126,0.18898,0.92913,0.18898,0.93701,0.18898,0.94488,0.18898,0.95276,0.18898,0.96063,0.18898,0.9685,0.18898,0.97638,0.18898,0.98425,0.18898,0.99213,0.18898,0.99609,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.19685,0.00787,0.19685,0.01575,0.19685,0.02362,0.19685,0.0315,0.19685,0.03937,0.19685,0.04724,0.19685,0.05512,0.19685,0.06299,0.19685,0.07087,0.19685,0.07874,0.19685,0.08661,0.19685,0.09449,0.19685,0.10236,0.19685,0.11024,0.19685,0.11811,0.19685,0.12598,0.19685,0.13386,0.19685,0.14173,0.19685,0.14961,0.19685,0.15748,0.19685,0.16535,0.19685,0.17323,0.19685,0.1811,0.19685,0.18898,0.19685,0.19685,0.19685,0.20472,0.19685,0.2126,0.19685,0.22047,0.19685,0.22835,0.19685,0.23622,0.19685,0.24409,0.19685,0.25197,0.19685,0.25984,0.19685,0.26772,0.19685,0.27559,0.19685,0.28346,0.19685,0.29134,0.19685,0.29921,0.19685,0.30709,0.19685,0.31496,0.19685,0.32283,0.19685,0.33071,0.19685,0.33858,0.19685,0.34646,0.19685,0.35433,0.19685,0.3622,0.19685,0.37008,0.19685,0.37795,0.19685,0.38583,0.19685,0.3937,0.19685,0.40157,0.19685,0.40945,0.19685,0.41732,0.19685,0.4252,0.19685,0.43307,0.19685,0.44094,0.19685,0.44882,0.19685,0.45669,0.19685,0.46457,0.19685,0.47244,0.19685,0.48031,0.19685,0.48819,0.19685,0.49606,0.19685,0.50394,0.19685,0.51181,0.19685,0.51969,0.19685,0.52756,0.19685,0.53543,0.19685,0.54331,0.19685,0.55118,0.19685,0.55906,0.19685,0.56693,0.19685,0.5748,0.19685,0.58268,0.19685,0.59055,0.19685,0.59843,0.19685,0.6063,0.19685,0.61417,0.19685,0.62205,0.19685,0.62992,0.19685,0.6378,0.19685,0.64567,0.19685,0.65354,0.19685,0.66142,0.19685,0.66929,0.19685,0.67717,0.19685,0.68504,0.19685,0.69291,0.19685,0.70079,0.19685,0.70866,0.19685,0.71654,0.19685,0.72441,0.19685,0.73228,0.19685,0.74016,0.19685,0.74803,0.19685,0.75591,0.19685,0.76378,0.19685,0.77165,0.19685,0.77953,0.19685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.7874,0.19685,0.79528,0.19685,0.80315,0.19685,0.81102,0.19685,0.8189,0.19685,0.82677,0.19685,0.83465,0.19685,0.84252,0.19685,0.85039,0.19685,0.85827,0.19685,0.86614,0.19685,0.87402,0.19685,0.88189,0.19685,0.88976,0.19685,0.89764,0.19685,0.90551,0.19685,0.91339,0.19685,0.92126,0.19685,0.92913,0.19685,0.93701,0.19685,0.94488,0.19685,0.95276,0.19685,0.96063,0.19685,0.9685,0.19685,0.97638,0.19685,0.98425,0.19685,0.99213,0.19685,0.99609,0.19685,0.00391,0.20472,0.00787,0.20472,0.01575,0.20472,0.02362,0.20472,0.0315,0.20472,0.03937,0.20472,0.04724,0.20472,0.05512,0.20472,0.06299,0.20472,0.07087,0.20472,0.07874,0.20472,0.08661,0.20472,0.09449,0.20472,0.10236,0.20472,0.11024,0.20472,0.11811,0.20472,0.12598,0.20472,0.13386,0.20472,0.14173,0.20472,0.14961,0.20472,0.15748,0.20472,0.16535,0.20472,0.17323,0.20472,0.1811,0.20472,0.18898,0.20472,0.19685,0.20472,0.20472,0.20472,0.2126,0.20472,0.22047,0.20472,0.22835,0.20472,0.23622,0.20472,0.24409,0.20472,0.25197,0.20472,0.25984,0.20472,0.26772,0.20472,0.27559,0.20472,0.28346,0.20472,0.29134,0.20472,0.29921,0.20472,0.30709,0.20472,0.31496,0.20472,0.32283,0.20472,0.33071,0.20472,0.33858,0.20472,0.34646,0.20472,0.35433,0.20472,0.3622,0.20472,0.37008,0.20472,0.37795,0.20472,0.38583,0.20472,0.3937,0.20472,0.40157,0.20472,0.40945,0.20472,0.41732,0.20472,0.4252,0.20472,0.43307,0.20472,0.44094,0.20472,0.44882,0.20472,0.45669,0.20472,0.46457,0.20472,0.47244,0.20472,0.48031,0.20472,0.48819,0.20472,0.49606,0.20472,0.50394,0.20472,0.51181,0.20472,0.51969,0.20472,0.52756,0.20472,0.53543,0.20472,0.54331,0.20472,0.55118,0.20472,0.55906,0.20472};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.56693,0.20472,0.5748,0.20472,0.58268,0.20472,0.59055,0.20472,0.59843,0.20472,0.6063,0.20472,0.61417,0.20472,0.62205,0.20472,0.62992,0.20472,0.6378,0.20472,0.64567,0.20472,0.65354,0.20472,0.66142,0.20472,0.66929,0.20472,0.67717,0.20472,0.68504,0.20472,0.69291,0.20472,0.70079,0.20472,0.70866,0.20472,0.71654,0.20472,0.72441,0.20472,0.73228,0.20472,0.74016,0.20472,0.74803,0.20472,0.75591,0.20472,0.76378,0.20472,0.77165,0.20472,0.77953,0.20472,0.7874,0.20472,0.79528,0.20472,0.80315,0.20472,0.81102,0.20472,0.8189,0.20472,0.82677,0.20472,0.83465,0.20472,0.84252,0.20472,0.85039,0.20472,0.85827,0.20472,0.86614,0.20472,0.87402,0.20472,0.88189,0.20472,0.88976,0.20472,0.89764,0.20472,0.90551,0.20472,0.91339,0.20472,0.92126,0.20472,0.92913,0.20472,0.93701,0.20472,0.94488,0.20472,0.95276,0.20472,0.96063,0.20472,0.9685,0.20472,0.97638,0.20472,0.98425,0.20472,0.99213,0.20472,0.99609,0.20472,0.00391,0.2126,0.00787,0.2126,0.01575,0.2126,0.02362,0.2126,0.0315,0.2126,0.03937,0.2126,0.04724,0.2126,0.05512,0.2126,0.06299,0.2126,0.07087,0.2126,0.07874,0.2126,0.08661,0.2126,0.09449,0.2126,0.10236,0.2126,0.11024,0.2126,0.11811,0.2126,0.12598,0.2126,0.13386,0.2126,0.14173,0.2126,0.14961,0.2126,0.15748,0.2126,0.16535,0.2126,0.17323,0.2126,0.1811,0.2126,0.18898,0.2126,0.19685,0.2126,0.20472,0.2126,0.2126,0.2126,0.22047,0.2126,0.22835,0.2126,0.23622,0.2126,0.24409,0.2126,0.25197,0.2126,0.25984,0.2126,0.26772,0.2126,0.27559,0.2126,0.28346,0.2126,0.29134,0.2126,0.29921,0.2126,0.30709,0.2126,0.31496,0.2126,0.32283,0.2126,0.33071,0.2126,0.33858,0.2126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.34646,0.2126,0.35433,0.2126,0.3622,0.2126,0.37008,0.2126,0.37795,0.2126,0.38583,0.2126,0.3937,0.2126,0.40157,0.2126,0.40945,0.2126,0.41732,0.2126,0.4252,0.2126,0.43307,0.2126,0.44094,0.2126,0.44882,0.2126,0.45669,0.2126,0.46457,0.2126,0.47244,0.2126,0.48031,0.2126,0.48819,0.2126,0.49606,0.2126,0.50394,0.2126,0.51181,0.2126,0.51969,0.2126,0.52756,0.2126,0.53543,0.2126,0.54331,0.2126,0.55118,0.2126,0.55906,0.2126,0.56693,0.2126,0.5748,0.2126,0.58268,0.2126,0.59055,0.2126,0.59843,0.2126,0.6063,0.2126,0.61417,0.2126,0.62205,0.2126,0.62992,0.2126,0.6378,0.2126,0.64567,0.2126,0.65354,0.2126,0.66142,0.2126,0.66929,0.2126,0.67717,0.2126,0.68504,0.2126,0.69291,0.2126,0.70079,0.2126,0.70866,0.2126,0.71654,0.2126,0.72441,0.2126,0.73228,0.2126,0.74016,0.2126,0.74803,0.2126,0.75591,0.2126,0.76378,0.2126,0.77165,0.2126,0.77953,0.2126,0.7874,0.2126,0.79528,0.2126,0.80315,0.2126,0.81102,0.2126,0.8189,0.2126,0.82677,0.2126,0.83465,0.2126,0.84252,0.2126,0.85039,0.2126,0.85827,0.2126,0.86614,0.2126,0.87402,0.2126,0.88189,0.2126,0.88976,0.2126,0.89764,0.2126,0.90551,0.2126,0.91339,0.2126,0.92126,0.2126,0.92913,0.2126,0.93701,0.2126,0.94488,0.2126,0.95276,0.2126,0.96063,0.2126,0.9685,0.2126,0.97638,0.2126,0.98425,0.2126,0.99213,0.2126,0.99609,0.2126,0.00391,0.22047,0.00787,0.22047,0.01575,0.22047,0.02362,0.22047,0.0315,0.22047,0.03937,0.22047,0.04724,0.22047,0.05512,0.22047,0.06299,0.22047,0.07087,0.22047,0.07874,0.22047,0.08661,0.22047,0.09449,0.22047,0.10236,0.22047,0.11024,0.22047,0.11811,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.12598,0.22047,0.13386,0.22047,0.14173,0.22047,0.14961,0.22047,0.15748,0.22047,0.16535,0.22047,0.17323,0.22047,0.1811,0.22047,0.18898,0.22047,0.19685,0.22047,0.20472,0.22047,0.2126,0.22047,0.22047,0.22047,0.22835,0.22047,0.23622,0.22047,0.24409,0.22047,0.25197,0.22047,0.25984,0.22047,0.26772,0.22047,0.27559,0.22047,0.28346,0.22047,0.29134,0.22047,0.29921,0.22047,0.30709,0.22047,0.31496,0.22047,0.32283,0.22047,0.33071,0.22047,0.33858,0.22047,0.34646,0.22047,0.35433,0.22047,0.3622,0.22047,0.37008,0.22047,0.37795,0.22047,0.38583,0.22047,0.3937,0.22047,0.40157,0.22047,0.40945,0.22047,0.41732,0.22047,0.4252,0.22047,0.43307,0.22047,0.44094,0.22047,0.44882,0.22047,0.45669,0.22047,0.46457,0.22047,0.47244,0.22047,0.48031,0.22047,0.48819,0.22047,0.49606,0.22047,0.50394,0.22047,0.51181,0.22047,0.51969,0.22047,0.52756,0.22047,0.53543,0.22047,0.54331,0.22047,0.55118,0.22047,0.55906,0.22047,0.56693,0.22047,0.5748,0.22047,0.58268,0.22047,0.59055,0.22047,0.59843,0.22047,0.6063,0.22047,0.61417,0.22047,0.62205,0.22047,0.62992,0.22047,0.6378,0.22047,0.64567,0.22047,0.65354,0.22047,0.66142,0.22047,0.66929,0.22047,0.67717,0.22047,0.68504,0.22047,0.69291,0.22047,0.70079,0.22047,0.70866,0.22047,0.71654,0.22047,0.72441,0.22047,0.73228,0.22047,0.74016,0.22047,0.74803,0.22047,0.75591,0.22047,0.76378,0.22047,0.77165,0.22047,0.77953,0.22047,0.7874,0.22047,0.79528,0.22047,0.80315,0.22047,0.81102,0.22047,0.8189,0.22047,0.82677,0.22047,0.83465,0.22047,0.84252,0.22047,0.85039,0.22047,0.85827,0.22047,0.86614,0.22047,0.87402,0.22047,0.88189,0.22047,0.88976,0.22047,0.89764,0.22047,0.90551,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.91339,0.22047,0.92126,0.22047,0.92913,0.22047,0.93701,0.22047,0.94488,0.22047,0.95276,0.22047,0.96063,0.22047,0.9685,0.22047,0.97638,0.22047,0.98425,0.22047,0.99213,0.22047,0.99609,0.22047,0.00391,0.22835,0.00787,0.22835,0.01575,0.22835,0.02362,0.22835,0.0315,0.22835,0.03937,0.22835,0.04724,0.22835,0.05512,0.22835,0.06299,0.22835,0.07087,0.22835,0.07874,0.22835,0.08661,0.22835,0.09449,0.22835,0.10236,0.22835,0.11024,0.22835,0.11811,0.22835,0.12598,0.22835,0.13386,0.22835,0.14173,0.22835,0.14961,0.22835,0.15748,0.22835,0.16535,0.22835,0.17323,0.22835,0.1811,0.22835,0.18898,0.22835,0.19685,0.22835,0.20472,0.22835,0.2126,0.22835,0.22047,0.22835,0.22835,0.22835,0.23622,0.22835,0.24409,0.22835,0.25197,0.22835,0.25984,0.22835,0.26772,0.22835,0.27559,0.22835,0.28346,0.22835,0.29134,0.22835,0.29921,0.22835,0.30709,0.22835,0.31496,0.22835,0.32283,0.22835,0.33071,0.22835,0.33858,0.22835,0.34646,0.22835,0.35433,0.22835,0.3622,0.22835,0.37008,0.22835,0.37795,0.22835,0.38583,0.22835,0.3937,0.22835,0.40157,0.22835,0.40945,0.22835,0.41732,0.22835,0.4252,0.22835,0.43307,0.22835,0.44094,0.22835,0.44882,0.22835,0.45669,0.22835,0.46457,0.22835,0.47244,0.22835,0.48031,0.22835,0.48819,0.22835,0.49606,0.22835,0.50394,0.22835,0.51181,0.22835,0.51969,0.22835,0.52756,0.22835,0.53543,0.22835,0.54331,0.22835,0.55118,0.22835,0.55906,0.22835,0.56693,0.22835,0.5748,0.22835,0.58268,0.22835,0.59055,0.22835,0.59843,0.22835,0.6063,0.22835,0.61417,0.22835,0.62205,0.22835,0.62992,0.22835,0.6378,0.22835,0.64567,0.22835,0.65354,0.22835,0.66142,0.22835,0.66929,0.22835,0.67717,0.22835,0.68504,0.22835};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.69291,0.22835,0.70079,0.22835,0.70866,0.22835,0.71654,0.22835,0.72441,0.22835,0.73228,0.22835,0.74016,0.22835,0.74803,0.22835,0.75591,0.22835,0.76378,0.22835,0.77165,0.22835,0.77953,0.22835,0.7874,0.22835,0.79528,0.22835,0.80315,0.22835,0.81102,0.22835,0.8189,0.22835,0.82677,0.22835,0.83465,0.22835,0.84252,0.22835,0.85039,0.22835,0.85827,0.22835,0.86614,0.22835,0.87402,0.22835,0.88189,0.22835,0.88976,0.22835,0.89764,0.22835,0.90551,0.22835,0.91339,0.22835,0.92126,0.22835,0.92913,0.22835,0.93701,0.22835,0.94488,0.22835,0.95276,0.22835,0.96063,0.22835,0.9685,0.22835,0.97638,0.22835,0.98425,0.22835,0.99213,0.22835,0.99609,0.22835,0.00391,0.23622,0.00787,0.23622,0.01575,0.23622,0.02362,0.23622,0.0315,0.23622,0.03937,0.23622,0.04724,0.23622,0.05512,0.23622,0.06299,0.23622,0.07087,0.23622,0.07874,0.23622,0.08661,0.23622,0.09449,0.23622,0.10236,0.23622,0.11024,0.23622,0.11811,0.23622,0.12598,0.23622,0.13386,0.23622,0.14173,0.23622,0.14961,0.23622,0.15748,0.23622,0.16535,0.23622,0.17323,0.23622,0.1811,0.23622,0.18898,0.23622,0.19685,0.23622,0.20472,0.23622,0.2126,0.23622,0.22047,0.23622,0.22835,0.23622,0.23622,0.23622,0.24409,0.23622,0.25197,0.23622,0.25984,0.23622,0.26772,0.23622,0.27559,0.23622,0.28346,0.23622,0.29134,0.23622,0.29921,0.23622,0.30709,0.23622,0.31496,0.23622,0.32283,0.23622,0.33071,0.23622,0.33858,0.23622,0.34646,0.23622,0.35433,0.23622,0.3622,0.23622,0.37008,0.23622,0.37795,0.23622,0.38583,0.23622,0.3937,0.23622,0.40157,0.23622,0.40945,0.23622,0.41732,0.23622,0.4252,0.23622,0.43307,0.23622,0.44094,0.23622,0.44882,0.23622,0.45669,0.23622,0.46457,0.23622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.47244,0.23622,0.48031,0.23622,0.48819,0.23622,0.49606,0.23622,0.50394,0.23622,0.51181,0.23622,0.51969,0.23622,0.52756,0.23622,0.53543,0.23622,0.54331,0.23622,0.55118,0.23622,0.55906,0.23622,0.56693,0.23622,0.5748,0.23622,0.58268,0.23622,0.59055,0.23622,0.59843,0.23622,0.6063,0.23622,0.61417,0.23622,0.62205,0.23622,0.62992,0.23622,0.6378,0.23622,0.64567,0.23622,0.65354,0.23622,0.66142,0.23622,0.66929,0.23622,0.67717,0.23622,0.68504,0.23622,0.69291,0.23622,0.70079,0.23622,0.70866,0.23622,0.71654,0.23622,0.72441,0.23622,0.73228,0.23622,0.74016,0.23622,0.74803,0.23622,0.75591,0.23622,0.76378,0.23622,0.77165,0.23622,0.77953,0.23622,0.7874,0.23622,0.79528,0.23622,0.80315,0.23622,0.81102,0.23622,0.8189,0.23622,0.82677,0.23622,0.83465,0.23622,0.84252,0.23622,0.85039,0.23622,0.85827,0.23622,0.86614,0.23622,0.87402,0.23622,0.88189,0.23622,0.88976,0.23622,0.89764,0.23622,0.90551,0.23622,0.91339,0.23622,0.92126,0.23622,0.92913,0.23622,0.93701,0.23622,0.94488,0.23622,0.95276,0.23622,0.96063,0.23622,0.9685,0.23622,0.97638,0.23622,0.98425,0.23622,0.99213,0.23622,0.99609,0.23622,0.00391,0.24409,0.00787,0.24409,0.01575,0.24409,0.02362,0.24409,0.0315,0.24409,0.03937,0.24409,0.04724,0.24409,0.05512,0.24409,0.06299,0.24409,0.07087,0.24409,0.07874,0.24409,0.08661,0.24409,0.09449,0.24409,0.10236,0.24409,0.11024,0.24409,0.11811,0.24409,0.12598,0.24409,0.13386,0.24409,0.14173,0.24409,0.14961,0.24409,0.15748,0.24409,0.16535,0.24409,0.17323,0.24409,0.1811,0.24409,0.18898,0.24409,0.19685,0.24409,0.20472,0.24409,0.2126,0.24409,0.22047,0.24409,0.22835,0.24409,0.23622,0.24409,0.24409,0.24409};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.25197,0.24409,0.25984,0.24409,0.26772,0.24409,0.27559,0.24409,0.28346,0.24409,0.29134,0.24409,0.29921,0.24409,0.30709,0.24409,0.31496,0.24409,0.32283,0.24409,0.33071,0.24409,0.33858,0.24409,0.34646,0.24409,0.35433,0.24409,0.3622,0.24409,0.37008,0.24409,0.37795,0.24409,0.38583,0.24409,0.3937,0.24409,0.40157,0.24409,0.40945,0.24409,0.41732,0.24409,0.4252,0.24409,0.43307,0.24409,0.44094,0.24409,0.44882,0.24409,0.45669,0.24409,0.46457,0.24409,0.47244,0.24409,0.48031,0.24409,0.48819,0.24409,0.49606,0.24409,0.50394,0.24409,0.51181,0.24409,0.51969,0.24409,0.52756,0.24409,0.53543,0.24409,0.54331,0.24409,0.55118,0.24409,0.55906,0.24409,0.56693,0.24409,0.5748,0.24409,0.58268,0.24409,0.59055,0.24409,0.59843,0.24409,0.6063,0.24409,0.61417,0.24409,0.62205,0.24409,0.62992,0.24409,0.6378,0.24409,0.64567,0.24409,0.65354,0.24409,0.66142,0.24409,0.66929,0.24409,0.67717,0.24409,0.68504,0.24409,0.69291,0.24409,0.70079,0.24409,0.70866,0.24409,0.71654,0.24409,0.72441,0.24409,0.73228,0.24409,0.74016,0.24409,0.74803,0.24409,0.75591,0.24409,0.76378,0.24409,0.77165,0.24409,0.77953,0.24409,0.7874,0.24409,0.79528,0.24409,0.80315,0.24409,0.81102,0.24409,0.8189,0.24409,0.82677,0.24409,0.83465,0.24409,0.84252,0.24409,0.85039,0.24409,0.85827,0.24409,0.86614,0.24409,0.87402,0.24409,0.88189,0.24409,0.88976,0.24409,0.89764,0.24409,0.90551,0.24409,0.91339,0.24409,0.92126,0.24409,0.92913,0.24409,0.93701,0.24409,0.94488,0.24409,0.95276,0.24409,0.96063,0.24409,0.9685,0.24409,0.97638,0.24409,0.98425,0.24409,0.99213,0.24409,0.99609,0.24409,0.00391,0.25197,0.00787,0.25197,0.01575,0.25197,0.02362,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_42()
		{
			double[] value = {0.0315,0.25197,0.03937,0.25197,0.04724,0.25197,0.05512,0.25197,0.06299,0.25197,0.07087,0.25197,0.07874,0.25197,0.08661,0.25197,0.09449,0.25197,0.10236,0.25197,0.11024,0.25197,0.11811,0.25197,0.12598,0.25197,0.13386,0.25197,0.14173,0.25197,0.14961,0.25197,0.15748,0.25197,0.16535,0.25197,0.17323,0.25197,0.1811,0.25197,0.18898,0.25197,0.19685,0.25197,0.20472,0.25197,0.2126,0.25197,0.22047,0.25197,0.22835,0.25197,0.23622,0.25197,0.24409,0.25197,0.25197,0.25197,0.25984,0.25197,0.26772,0.25197,0.27559,0.25197,0.28346,0.25197,0.29134,0.25197,0.29921,0.25197,0.30709,0.25197,0.31496,0.25197,0.32283,0.25197,0.33071,0.25197,0.33858,0.25197,0.34646,0.25197,0.35433,0.25197,0.3622,0.25197,0.37008,0.25197,0.37795,0.25197,0.38583,0.25197,0.3937,0.25197,0.40157,0.25197,0.40945,0.25197,0.41732,0.25197,0.4252,0.25197,0.43307,0.25197,0.44094,0.25197,0.44882,0.25197,0.45669,0.25197,0.46457,0.25197,0.47244,0.25197,0.48031,0.25197,0.48819,0.25197,0.49606,0.25197,0.50394,0.25197,0.51181,0.25197,0.51969,0.25197,0.52756,0.25197,0.53543,0.25197,0.54331,0.25197,0.55118,0.25197,0.55906,0.25197,0.56693,0.25197,0.5748,0.25197,0.58268,0.25197,0.59055,0.25197,0.59843,0.25197,0.6063,0.25197,0.61417,0.25197,0.62205,0.25197,0.62992,0.25197,0.6378,0.25197,0.64567,0.25197,0.65354,0.25197,0.66142,0.25197,0.66929,0.25197,0.67717,0.25197,0.68504,0.25197,0.69291,0.25197,0.70079,0.25197,0.70866,0.25197,0.71654,0.25197,0.72441,0.25197,0.73228,0.25197,0.74016,0.25197,0.74803,0.25197,0.75591,0.25197,0.76378,0.25197,0.77165,0.25197,0.77953,0.25197,0.7874,0.25197,0.79528,0.25197,0.80315,0.25197,0.81102,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_43()
		{
			double[] value = {0.8189,0.25197,0.82677,0.25197,0.83465,0.25197,0.84252,0.25197,0.85039,0.25197,0.85827,0.25197,0.86614,0.25197,0.87402,0.25197,0.88189,0.25197,0.88976,0.25197,0.89764,0.25197,0.90551,0.25197,0.91339,0.25197,0.92126,0.25197,0.92913,0.25197,0.93701,0.25197,0.94488,0.25197,0.95276,0.25197,0.96063,0.25197,0.9685,0.25197,0.97638,0.25197,0.98425,0.25197,0.99213,0.25197,0.99609,0.25197,0.00391,0.25984,0.00787,0.25984,0.01575,0.25984,0.02362,0.25984,0.0315,0.25984,0.03937,0.25984,0.04724,0.25984,0.05512,0.25984,0.06299,0.25984,0.07087,0.25984,0.07874,0.25984,0.08661,0.25984,0.09449,0.25984,0.10236,0.25984,0.11024,0.25984,0.11811,0.25984,0.12598,0.25984,0.13386,0.25984,0.14173,0.25984,0.14961,0.25984,0.15748,0.25984,0.16535,0.25984,0.17323,0.25984,0.1811,0.25984,0.18898,0.25984,0.19685,0.25984,0.20472,0.25984,0.2126,0.25984,0.22047,0.25984,0.22835,0.25984,0.23622,0.25984,0.24409,0.25984,0.25197,0.25984,0.25984,0.25984,0.26772,0.25984,0.27559,0.25984,0.28346,0.25984,0.29134,0.25984,0.29921,0.25984,0.30709,0.25984,0.31496,0.25984,0.32283,0.25984,0.33071,0.25984,0.33858,0.25984,0.34646,0.25984,0.35433,0.25984,0.3622,0.25984,0.37008,0.25984,0.37795,0.25984,0.38583,0.25984,0.3937,0.25984,0.40157,0.25984,0.40945,0.25984,0.41732,0.25984,0.4252,0.25984,0.43307,0.25984,0.44094,0.25984,0.44882,0.25984,0.45669,0.25984,0.46457,0.25984,0.47244,0.25984,0.48031,0.25984,0.48819,0.25984,0.49606,0.25984,0.50394,0.25984,0.51181,0.25984,0.51969,0.25984,0.52756,0.25984,0.53543,0.25984,0.54331,0.25984,0.55118,0.25984,0.55906,0.25984,0.56693,0.25984,0.5748,0.25984,0.58268,0.25984,0.59055,0.25984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_44()
		{
			double[] value = {0.59843,0.25984,0.6063,0.25984,0.61417,0.25984,0.62205,0.25984,0.62992,0.25984,0.6378,0.25984,0.64567,0.25984,0.65354,0.25984,0.66142,0.25984,0.66929,0.25984,0.67717,0.25984,0.68504,0.25984,0.69291,0.25984,0.70079,0.25984,0.70866,0.25984,0.71654,0.25984,0.72441,0.25984,0.73228,0.25984,0.74016,0.25984,0.74803,0.25984,0.75591,0.25984,0.76378,0.25984,0.77165,0.25984,0.77953,0.25984,0.7874,0.25984,0.79528,0.25984,0.80315,0.25984,0.81102,0.25984,0.8189,0.25984,0.82677,0.25984,0.83465,0.25984,0.84252,0.25984,0.85039,0.25984,0.85827,0.25984,0.86614,0.25984,0.87402,0.25984,0.88189,0.25984,0.88976,0.25984,0.89764,0.25984,0.90551,0.25984,0.91339,0.25984,0.92126,0.25984,0.92913,0.25984,0.93701,0.25984,0.94488,0.25984,0.95276,0.25984,0.96063,0.25984,0.9685,0.25984,0.97638,0.25984,0.98425,0.25984,0.99213,0.25984,0.99609,0.25984,0.00391,0.26772,0.00787,0.26772,0.01575,0.26772,0.02362,0.26772,0.0315,0.26772,0.03937,0.26772,0.04724,0.26772,0.05512,0.26772,0.06299,0.26772,0.07087,0.26772,0.07874,0.26772,0.08661,0.26772,0.09449,0.26772,0.10236,0.26772,0.11024,0.26772,0.11811,0.26772,0.12598,0.26772,0.13386,0.26772,0.14173,0.26772,0.14961,0.26772,0.15748,0.26772,0.16535,0.26772,0.17323,0.26772,0.1811,0.26772,0.18898,0.26772,0.19685,0.26772,0.20472,0.26772,0.2126,0.26772,0.22047,0.26772,0.22835,0.26772,0.23622,0.26772,0.24409,0.26772,0.25197,0.26772,0.25984,0.26772,0.26772,0.26772,0.27559,0.26772,0.28346,0.26772,0.29134,0.26772,0.29921,0.26772,0.30709,0.26772,0.31496,0.26772,0.32283,0.26772,0.33071,0.26772,0.33858,0.26772,0.34646,0.26772,0.35433,0.26772,0.3622,0.26772,0.37008,0.26772};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_45()
		{
			double[] value = {0.37795,0.26772,0.38583,0.26772,0.3937,0.26772,0.40157,0.26772,0.40945,0.26772,0.41732,0.26772,0.4252,0.26772,0.43307,0.26772,0.44094,0.26772,0.44882,0.26772,0.45669,0.26772,0.46457,0.26772,0.47244,0.26772,0.48031,0.26772,0.48819,0.26772,0.49606,0.26772,0.50394,0.26772,0.51181,0.26772,0.51969,0.26772,0.52756,0.26772,0.53543,0.26772,0.54331,0.26772,0.55118,0.26772,0.55906,0.26772,0.56693,0.26772,0.5748,0.26772,0.58268,0.26772,0.59055,0.26772,0.59843,0.26772,0.6063,0.26772,0.61417,0.26772,0.62205,0.26772,0.62992,0.26772,0.6378,0.26772,0.64567,0.26772,0.65354,0.26772,0.66142,0.26772,0.66929,0.26772,0.67717,0.26772,0.68504,0.26772,0.69291,0.26772,0.70079,0.26772,0.70866,0.26772,0.71654,0.26772,0.72441,0.26772,0.73228,0.26772,0.74016,0.26772,0.74803,0.26772,0.75591,0.26772,0.76378,0.26772,0.77165,0.26772,0.77953,0.26772,0.7874,0.26772,0.79528,0.26772,0.80315,0.26772,0.81102,0.26772,0.8189,0.26772,0.82677,0.26772,0.83465,0.26772,0.84252,0.26772,0.85039,0.26772,0.85827,0.26772,0.86614,0.26772,0.87402,0.26772,0.88189,0.26772,0.88976,0.26772,0.89764,0.26772,0.90551,0.26772,0.91339,0.26772,0.92126,0.26772,0.92913,0.26772,0.93701,0.26772,0.94488,0.26772,0.95276,0.26772,0.96063,0.26772,0.9685,0.26772,0.97638,0.26772,0.98425,0.26772,0.99213,0.26772,0.99609,0.26772,0.00391,0.27559,0.00787,0.27559,0.01575,0.27559,0.02362,0.27559,0.0315,0.27559,0.03937,0.27559,0.04724,0.27559,0.05512,0.27559,0.06299,0.27559,0.07087,0.27559,0.07874,0.27559,0.08661,0.27559,0.09449,0.27559,0.10236,0.27559,0.11024,0.27559,0.11811,0.27559,0.12598,0.27559,0.13386,0.27559,0.14173,0.27559,0.14961,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_46()
		{
			double[] value = {0.15748,0.27559,0.16535,0.27559,0.17323,0.27559,0.1811,0.27559,0.18898,0.27559,0.19685,0.27559,0.20472,0.27559,0.2126,0.27559,0.22047,0.27559,0.22835,0.27559,0.23622,0.27559,0.24409,0.27559,0.25197,0.27559,0.25984,0.27559,0.26772,0.27559,0.27559,0.27559,0.28346,0.27559,0.29134,0.27559,0.29921,0.27559,0.30709,0.27559,0.31496,0.27559,0.32283,0.27559,0.33071,0.27559,0.33858,0.27559,0.34646,0.27559,0.35433,0.27559,0.3622,0.27559,0.37008,0.27559,0.37795,0.27559,0.38583,0.27559,0.3937,0.27559,0.40157,0.27559,0.40945,0.27559,0.41732,0.27559,0.4252,0.27559,0.43307,0.27559,0.44094,0.27559,0.44882,0.27559,0.45669,0.27559,0.46457,0.27559,0.47244,0.27559,0.48031,0.27559,0.48819,0.27559,0.49606,0.27559,0.50394,0.27559,0.51181,0.27559,0.51969,0.27559,0.52756,0.27559,0.53543,0.27559,0.54331,0.27559,0.55118,0.27559,0.55906,0.27559,0.56693,0.27559,0.5748,0.27559,0.58268,0.27559,0.59055,0.27559,0.59843,0.27559,0.6063,0.27559,0.61417,0.27559,0.62205,0.27559,0.62992,0.27559,0.6378,0.27559,0.64567,0.27559,0.65354,0.27559,0.66142,0.27559,0.66929,0.27559,0.67717,0.27559,0.68504,0.27559,0.69291,0.27559,0.70079,0.27559,0.70866,0.27559,0.71654,0.27559,0.72441,0.27559,0.73228,0.27559,0.74016,0.27559,0.74803,0.27559,0.75591,0.27559,0.76378,0.27559,0.77165,0.27559,0.77953,0.27559,0.7874,0.27559,0.79528,0.27559,0.80315,0.27559,0.81102,0.27559,0.8189,0.27559,0.82677,0.27559,0.83465,0.27559,0.84252,0.27559,0.85039,0.27559,0.85827,0.27559,0.86614,0.27559,0.87402,0.27559,0.88189,0.27559,0.88976,0.27559,0.89764,0.27559,0.90551,0.27559,0.91339,0.27559,0.92126,0.27559,0.92913,0.27559,0.93701,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_47()
		{
			double[] value = {0.94488,0.27559,0.95276,0.27559,0.96063,0.27559,0.9685,0.27559,0.97638,0.27559,0.98425,0.27559,0.99213,0.27559,0.99609,0.27559,0.00391,0.28346,0.00787,0.28346,0.01575,0.28346,0.02362,0.28346,0.0315,0.28346,0.03937,0.28346,0.04724,0.28346,0.05512,0.28346,0.06299,0.28346,0.07087,0.28346,0.07874,0.28346,0.08661,0.28346,0.09449,0.28346,0.10236,0.28346,0.11024,0.28346,0.11811,0.28346,0.12598,0.28346,0.13386,0.28346,0.14173,0.28346,0.14961,0.28346,0.15748,0.28346,0.16535,0.28346,0.17323,0.28346,0.1811,0.28346,0.18898,0.28346,0.19685,0.28346,0.20472,0.28346,0.2126,0.28346,0.22047,0.28346,0.22835,0.28346,0.23622,0.28346,0.24409,0.28346,0.25197,0.28346,0.25984,0.28346,0.26772,0.28346,0.27559,0.28346,0.28346,0.28346,0.29134,0.28346,0.29921,0.28346,0.30709,0.28346,0.31496,0.28346,0.32283,0.28346,0.33071,0.28346,0.33858,0.28346,0.34646,0.28346,0.35433,0.28346,0.3622,0.28346,0.37008,0.28346,0.37795,0.28346,0.38583,0.28346,0.3937,0.28346,0.40157,0.28346,0.40945,0.28346,0.41732,0.28346,0.4252,0.28346,0.43307,0.28346,0.44094,0.28346,0.44882,0.28346,0.45669,0.28346,0.46457,0.28346,0.47244,0.28346,0.48031,0.28346,0.48819,0.28346,0.49606,0.28346,0.50394,0.28346,0.51181,0.28346,0.51969,0.28346,0.52756,0.28346,0.53543,0.28346,0.54331,0.28346,0.55118,0.28346,0.55906,0.28346,0.56693,0.28346,0.5748,0.28346,0.58268,0.28346,0.59055,0.28346,0.59843,0.28346,0.6063,0.28346,0.61417,0.28346,0.62205,0.28346,0.62992,0.28346,0.6378,0.28346,0.64567,0.28346,0.65354,0.28346,0.66142,0.28346,0.66929,0.28346,0.67717,0.28346,0.68504,0.28346,0.69291,0.28346,0.70079,0.28346,0.70866,0.28346,0.71654,0.28346};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_48()
		{
			double[] value = {0.72441,0.28346,0.73228,0.28346,0.74016,0.28346,0.74803,0.28346,0.75591,0.28346,0.76378,0.28346,0.77165,0.28346,0.77953,0.28346,0.7874,0.28346,0.79528,0.28346,0.80315,0.28346,0.81102,0.28346,0.8189,0.28346,0.82677,0.28346,0.83465,0.28346,0.84252,0.28346,0.85039,0.28346,0.85827,0.28346,0.86614,0.28346,0.87402,0.28346,0.88189,0.28346,0.88976,0.28346,0.89764,0.28346,0.90551,0.28346,0.91339,0.28346,0.92126,0.28346,0.92913,0.28346,0.93701,0.28346,0.94488,0.28346,0.95276,0.28346,0.96063,0.28346,0.9685,0.28346,0.97638,0.28346,0.98425,0.28346,0.99213,0.28346,0.99609,0.28346,0.00391,0.29134,0.00787,0.29134,0.01575,0.29134,0.02362,0.29134,0.0315,0.29134,0.03937,0.29134,0.04724,0.29134,0.05512,0.29134,0.06299,0.29134,0.07087,0.29134,0.07874,0.29134,0.08661,0.29134,0.09449,0.29134,0.10236,0.29134,0.11024,0.29134,0.11811,0.29134,0.12598,0.29134,0.13386,0.29134,0.14173,0.29134,0.14961,0.29134,0.15748,0.29134,0.16535,0.29134,0.17323,0.29134,0.1811,0.29134,0.18898,0.29134,0.19685,0.29134,0.20472,0.29134,0.2126,0.29134,0.22047,0.29134,0.22835,0.29134,0.23622,0.29134,0.24409,0.29134,0.25197,0.29134,0.25984,0.29134,0.26772,0.29134,0.27559,0.29134,0.28346,0.29134,0.29134,0.29134,0.29921,0.29134,0.30709,0.29134,0.31496,0.29134,0.32283,0.29134,0.33071,0.29134,0.33858,0.29134,0.34646,0.29134,0.35433,0.29134,0.3622,0.29134,0.37008,0.29134,0.37795,0.29134,0.38583,0.29134,0.3937,0.29134,0.40157,0.29134,0.40945,0.29134,0.41732,0.29134,0.4252,0.29134,0.43307,0.29134,0.44094,0.29134,0.44882,0.29134,0.45669,0.29134,0.46457,0.29134,0.47244,0.29134,0.48031,0.29134,0.48819,0.29134,0.49606,0.29134};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_49()
		{
			double[] value = {0.50394,0.29134,0.51181,0.29134,0.51969,0.29134,0.52756,0.29134,0.53543,0.29134,0.54331,0.29134,0.55118,0.29134,0.55906,0.29134,0.56693,0.29134,0.5748,0.29134,0.58268,0.29134,0.59055,0.29134,0.59843,0.29134,0.6063,0.29134,0.61417,0.29134,0.62205,0.29134,0.62992,0.29134,0.6378,0.29134,0.64567,0.29134,0.65354,0.29134,0.66142,0.29134,0.66929,0.29134,0.67717,0.29134,0.68504,0.29134,0.69291,0.29134,0.70079,0.29134,0.70866,0.29134,0.71654,0.29134,0.72441,0.29134,0.73228,0.29134,0.74016,0.29134,0.74803,0.29134,0.75591,0.29134,0.76378,0.29134,0.77165,0.29134,0.77953,0.29134,0.7874,0.29134,0.79528,0.29134,0.80315,0.29134,0.81102,0.29134,0.8189,0.29134,0.82677,0.29134,0.83465,0.29134,0.84252,0.29134,0.85039,0.29134,0.85827,0.29134,0.86614,0.29134,0.87402,0.29134,0.88189,0.29134,0.88976,0.29134,0.89764,0.29134,0.90551,0.29134,0.91339,0.29134,0.92126,0.29134,0.92913,0.29134,0.93701,0.29134,0.94488,0.29134,0.95276,0.29134,0.96063,0.29134,0.9685,0.29134,0.97638,0.29134,0.98425,0.29134,0.99213,0.29134,0.99609,0.29134,0.00391,0.29921,0.00787,0.29921,0.01575,0.29921,0.02362,0.29921,0.0315,0.29921,0.03937,0.29921,0.04724,0.29921,0.05512,0.29921,0.06299,0.29921,0.07087,0.29921,0.07874,0.29921,0.08661,0.29921,0.09449,0.29921,0.10236,0.29921,0.11024,0.29921,0.11811,0.29921,0.12598,0.29921,0.13386,0.29921,0.14173,0.29921,0.14961,0.29921,0.15748,0.29921,0.16535,0.29921,0.17323,0.29921,0.1811,0.29921,0.18898,0.29921,0.19685,0.29921,0.20472,0.29921,0.2126,0.29921,0.22047,0.29921,0.22835,0.29921,0.23622,0.29921,0.24409,0.29921,0.25197,0.29921,0.25984,0.29921,0.26772,0.29921,0.27559,0.29921};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_50()
		{
			double[] value = {0.28346,0.29921,0.29134,0.29921,0.29921,0.29921,0.30709,0.29921,0.31496,0.29921,0.32283,0.29921,0.33071,0.29921,0.33858,0.29921,0.34646,0.29921,0.35433,0.29921,0.3622,0.29921,0.37008,0.29921,0.37795,0.29921,0.38583,0.29921,0.3937,0.29921,0.40157,0.29921,0.40945,0.29921,0.41732,0.29921,0.4252,0.29921,0.43307,0.29921,0.44094,0.29921,0.44882,0.29921,0.45669,0.29921,0.46457,0.29921,0.47244,0.29921,0.48031,0.29921,0.48819,0.29921,0.49606,0.29921,0.50394,0.29921,0.51181,0.29921,0.51969,0.29921,0.52756,0.29921,0.53543,0.29921,0.54331,0.29921,0.55118,0.29921,0.55906,0.29921,0.56693,0.29921,0.5748,0.29921,0.58268,0.29921,0.59055,0.29921,0.59843,0.29921,0.6063,0.29921,0.61417,0.29921,0.62205,0.29921,0.62992,0.29921,0.6378,0.29921,0.64567,0.29921,0.65354,0.29921,0.66142,0.29921,0.66929,0.29921,0.67717,0.29921,0.68504,0.29921,0.69291,0.29921,0.70079,0.29921,0.70866,0.29921,0.71654,0.29921,0.72441,0.29921,0.73228,0.29921,0.74016,0.29921,0.74803,0.29921,0.75591,0.29921,0.76378,0.29921,0.77165,0.29921,0.77953,0.29921,0.7874,0.29921,0.79528,0.29921,0.80315,0.29921,0.81102,0.29921,0.8189,0.29921,0.82677,0.29921,0.83465,0.29921,0.84252,0.29921,0.85039,0.29921,0.85827,0.29921,0.86614,0.29921,0.87402,0.29921,0.88189,0.29921,0.88976,0.29921,0.89764,0.29921,0.90551,0.29921,0.91339,0.29921,0.92126,0.29921,0.92913,0.29921,0.93701,0.29921,0.94488,0.29921,0.95276,0.29921,0.96063,0.29921,0.9685,0.29921,0.97638,0.29921,0.98425,0.29921,0.99213,0.29921,0.99609,0.29921,0.00391,0.30709,0.00787,0.30709,0.01575,0.30709,0.02362,0.30709,0.0315,0.30709,0.03937,0.30709,0.04724,0.30709,0.05512,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_51()
		{
			double[] value = {0.06299,0.30709,0.07087,0.30709,0.07874,0.30709,0.08661,0.30709,0.09449,0.30709,0.10236,0.30709,0.11024,0.30709,0.11811,0.30709,0.12598,0.30709,0.13386,0.30709,0.14173,0.30709,0.14961,0.30709,0.15748,0.30709,0.16535,0.30709,0.17323,0.30709,0.1811,0.30709,0.18898,0.30709,0.19685,0.30709,0.20472,0.30709,0.2126,0.30709,0.22047,0.30709,0.22835,0.30709,0.23622,0.30709,0.24409,0.30709,0.25197,0.30709,0.25984,0.30709,0.26772,0.30709,0.27559,0.30709,0.28346,0.30709,0.29134,0.30709,0.29921,0.30709,0.30709,0.30709,0.31496,0.30709,0.32283,0.30709,0.33071,0.30709,0.33858,0.30709,0.34646,0.30709,0.35433,0.30709,0.3622,0.30709,0.37008,0.30709,0.37795,0.30709,0.38583,0.30709,0.3937,0.30709,0.40157,0.30709,0.40945,0.30709,0.41732,0.30709,0.4252,0.30709,0.43307,0.30709,0.44094,0.30709,0.44882,0.30709,0.45669,0.30709,0.46457,0.30709,0.47244,0.30709,0.48031,0.30709,0.48819,0.30709,0.49606,0.30709,0.50394,0.30709,0.51181,0.30709,0.51969,0.30709,0.52756,0.30709,0.53543,0.30709,0.54331,0.30709,0.55118,0.30709,0.55906,0.30709,0.56693,0.30709,0.5748,0.30709,0.58268,0.30709,0.59055,0.30709,0.59843,0.30709,0.6063,0.30709,0.61417,0.30709,0.62205,0.30709,0.62992,0.30709,0.6378,0.30709,0.64567,0.30709,0.65354,0.30709,0.66142,0.30709,0.66929,0.30709,0.67717,0.30709,0.68504,0.30709,0.69291,0.30709,0.70079,0.30709,0.70866,0.30709,0.71654,0.30709,0.72441,0.30709,0.73228,0.30709,0.74016,0.30709,0.74803,0.30709,0.75591,0.30709,0.76378,0.30709,0.77165,0.30709,0.77953,0.30709,0.7874,0.30709,0.79528,0.30709,0.80315,0.30709,0.81102,0.30709,0.8189,0.30709,0.82677,0.30709,0.83465,0.30709,0.84252,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_52()
		{
			double[] value = {0.85039,0.30709,0.85827,0.30709,0.86614,0.30709,0.87402,0.30709,0.88189,0.30709,0.88976,0.30709,0.89764,0.30709,0.90551,0.30709,0.91339,0.30709,0.92126,0.30709,0.92913,0.30709,0.93701,0.30709,0.94488,0.30709,0.95276,0.30709,0.96063,0.30709,0.9685,0.30709,0.97638,0.30709,0.98425,0.30709,0.99213,0.30709,0.99609,0.30709,0.00391,0.31496,0.00787,0.31496,0.01575,0.31496,0.02362,0.31496,0.0315,0.31496,0.03937,0.31496,0.04724,0.31496,0.05512,0.31496,0.06299,0.31496,0.07087,0.31496,0.07874,0.31496,0.08661,0.31496,0.09449,0.31496,0.10236,0.31496,0.11024,0.31496,0.11811,0.31496,0.12598,0.31496,0.13386,0.31496,0.14173,0.31496,0.14961,0.31496,0.15748,0.31496,0.16535,0.31496,0.17323,0.31496,0.1811,0.31496,0.18898,0.31496,0.19685,0.31496,0.20472,0.31496,0.2126,0.31496,0.22047,0.31496,0.22835,0.31496,0.23622,0.31496,0.24409,0.31496,0.25197,0.31496,0.25984,0.31496,0.26772,0.31496,0.27559,0.31496,0.28346,0.31496,0.29134,0.31496,0.29921,0.31496,0.30709,0.31496,0.31496,0.31496,0.32283,0.31496,0.33071,0.31496,0.33858,0.31496,0.34646,0.31496,0.35433,0.31496,0.3622,0.31496,0.37008,0.31496,0.37795,0.31496,0.38583,0.31496,0.3937,0.31496,0.40157,0.31496,0.40945,0.31496,0.41732,0.31496,0.4252,0.31496,0.43307,0.31496,0.44094,0.31496,0.44882,0.31496,0.45669,0.31496,0.46457,0.31496,0.47244,0.31496,0.48031,0.31496,0.48819,0.31496,0.49606,0.31496,0.50394,0.31496,0.51181,0.31496,0.51969,0.31496,0.52756,0.31496,0.53543,0.31496,0.54331,0.31496,0.55118,0.31496,0.55906,0.31496,0.56693,0.31496,0.5748,0.31496,0.58268,0.31496,0.59055,0.31496,0.59843,0.31496,0.6063,0.31496,0.61417,0.31496,0.62205,0.31496};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_53()
		{
			double[] value = {0.62992,0.31496,0.6378,0.31496,0.64567,0.31496,0.65354,0.31496,0.66142,0.31496,0.66929,0.31496,0.67717,0.31496,0.68504,0.31496,0.69291,0.31496,0.70079,0.31496,0.70866,0.31496,0.71654,0.31496,0.72441,0.31496,0.73228,0.31496,0.74016,0.31496,0.74803,0.31496,0.75591,0.31496,0.76378,0.31496,0.77165,0.31496,0.77953,0.31496,0.7874,0.31496,0.79528,0.31496,0.80315,0.31496,0.81102,0.31496,0.8189,0.31496,0.82677,0.31496,0.83465,0.31496,0.84252,0.31496,0.85039,0.31496,0.85827,0.31496,0.86614,0.31496,0.87402,0.31496,0.88189,0.31496,0.88976,0.31496,0.89764,0.31496,0.90551,0.31496,0.91339,0.31496,0.92126,0.31496,0.92913,0.31496,0.93701,0.31496,0.94488,0.31496,0.95276,0.31496,0.96063,0.31496,0.9685,0.31496,0.97638,0.31496,0.98425,0.31496,0.99213,0.31496,0.99609,0.31496,0.00391,0.32283,0.00787,0.32283,0.01575,0.32283,0.02362,0.32283,0.0315,0.32283,0.03937,0.32283,0.04724,0.32283,0.05512,0.32283,0.06299,0.32283,0.07087,0.32283,0.07874,0.32283,0.08661,0.32283,0.09449,0.32283,0.10236,0.32283,0.11024,0.32283,0.11811,0.32283,0.12598,0.32283,0.13386,0.32283,0.14173,0.32283,0.14961,0.32283,0.15748,0.32283,0.16535,0.32283,0.17323,0.32283,0.1811,0.32283,0.18898,0.32283,0.19685,0.32283,0.20472,0.32283,0.2126,0.32283,0.22047,0.32283,0.22835,0.32283,0.23622,0.32283,0.24409,0.32283,0.25197,0.32283,0.25984,0.32283,0.26772,0.32283,0.27559,0.32283,0.28346,0.32283,0.29134,0.32283,0.29921,0.32283,0.30709,0.32283,0.31496,0.32283,0.32283,0.32283,0.33071,0.32283,0.33858,0.32283,0.34646,0.32283,0.35433,0.32283,0.3622,0.32283,0.37008,0.32283,0.37795,0.32283,0.38583,0.32283,0.3937,0.32283,0.40157,0.32283};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_54()
		{
			double[] value = {0.40945,0.32283,0.41732,0.32283,0.4252,0.32283,0.43307,0.32283,0.44094,0.32283,0.44882,0.32283,0.45669,0.32283,0.46457,0.32283,0.47244,0.32283,0.48031,0.32283,0.48819,0.32283,0.49606,0.32283,0.50394,0.32283,0.51181,0.32283,0.51969,0.32283,0.52756,0.32283,0.53543,0.32283,0.54331,0.32283,0.55118,0.32283,0.55906,0.32283,0.56693,0.32283,0.5748,0.32283,0.58268,0.32283,0.59055,0.32283,0.59843,0.32283,0.6063,0.32283,0.61417,0.32283,0.62205,0.32283,0.62992,0.32283,0.6378,0.32283,0.64567,0.32283,0.65354,0.32283,0.66142,0.32283,0.66929,0.32283,0.67717,0.32283,0.68504,0.32283,0.69291,0.32283,0.70079,0.32283,0.70866,0.32283,0.71654,0.32283,0.72441,0.32283,0.73228,0.32283,0.74016,0.32283,0.74803,0.32283,0.75591,0.32283,0.76378,0.32283,0.77165,0.32283,0.77953,0.32283,0.7874,0.32283,0.79528,0.32283,0.80315,0.32283,0.81102,0.32283,0.8189,0.32283,0.82677,0.32283,0.83465,0.32283,0.84252,0.32283,0.85039,0.32283,0.85827,0.32283,0.86614,0.32283,0.87402,0.32283,0.88189,0.32283,0.88976,0.32283,0.89764,0.32283,0.90551,0.32283,0.91339,0.32283,0.92126,0.32283,0.92913,0.32283,0.93701,0.32283,0.94488,0.32283,0.95276,0.32283,0.96063,0.32283,0.9685,0.32283,0.97638,0.32283,0.98425,0.32283,0.99213,0.32283,0.99609,0.32283,0.00391,0.33071,0.00787,0.33071,0.01575,0.33071,0.02362,0.33071,0.0315,0.33071,0.03937,0.33071,0.04724,0.33071,0.05512,0.33071,0.06299,0.33071,0.07087,0.33071,0.07874,0.33071,0.08661,0.33071,0.09449,0.33071,0.10236,0.33071,0.11024,0.33071,0.11811,0.33071,0.12598,0.33071,0.13386,0.33071,0.14173,0.33071,0.14961,0.33071,0.15748,0.33071,0.16535,0.33071,0.17323,0.33071,0.1811,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_55()
		{
			double[] value = {0.18898,0.33071,0.19685,0.33071,0.20472,0.33071,0.2126,0.33071,0.22047,0.33071,0.22835,0.33071,0.23622,0.33071,0.24409,0.33071,0.25197,0.33071,0.25984,0.33071,0.26772,0.33071,0.27559,0.33071,0.28346,0.33071,0.29134,0.33071,0.29921,0.33071,0.30709,0.33071,0.31496,0.33071,0.32283,0.33071,0.33071,0.33071,0.33858,0.33071,0.34646,0.33071,0.35433,0.33071,0.3622,0.33071,0.37008,0.33071,0.37795,0.33071,0.38583,0.33071,0.3937,0.33071,0.40157,0.33071,0.40945,0.33071,0.41732,0.33071,0.4252,0.33071,0.43307,0.33071,0.44094,0.33071,0.44882,0.33071,0.45669,0.33071,0.46457,0.33071,0.47244,0.33071,0.48031,0.33071,0.48819,0.33071,0.49606,0.33071,0.50394,0.33071,0.51181,0.33071,0.51969,0.33071,0.52756,0.33071,0.53543,0.33071,0.54331,0.33071,0.55118,0.33071,0.55906,0.33071,0.56693,0.33071,0.5748,0.33071,0.58268,0.33071,0.59055,0.33071,0.59843,0.33071,0.6063,0.33071,0.61417,0.33071,0.62205,0.33071,0.62992,0.33071,0.6378,0.33071,0.64567,0.33071,0.65354,0.33071,0.66142,0.33071,0.66929,0.33071,0.67717,0.33071,0.68504,0.33071,0.69291,0.33071,0.70079,0.33071,0.70866,0.33071,0.71654,0.33071,0.72441,0.33071,0.73228,0.33071,0.74016,0.33071,0.74803,0.33071,0.75591,0.33071,0.76378,0.33071,0.77165,0.33071,0.77953,0.33071,0.7874,0.33071,0.79528,0.33071,0.80315,0.33071,0.81102,0.33071,0.8189,0.33071,0.82677,0.33071,0.83465,0.33071,0.84252,0.33071,0.85039,0.33071,0.85827,0.33071,0.86614,0.33071,0.87402,0.33071,0.88189,0.33071,0.88976,0.33071,0.89764,0.33071,0.90551,0.33071,0.91339,0.33071,0.92126,0.33071,0.92913,0.33071,0.93701,0.33071,0.94488,0.33071,0.95276,0.33071,0.96063,0.33071,0.9685,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_56()
		{
			double[] value = {0.97638,0.33071,0.98425,0.33071,0.99213,0.33071,0.99609,0.33071,0.00391,0.33858,0.00787,0.33858,0.01575,0.33858,0.02362,0.33858,0.0315,0.33858,0.03937,0.33858,0.04724,0.33858,0.05512,0.33858,0.06299,0.33858,0.07087,0.33858,0.07874,0.33858,0.08661,0.33858,0.09449,0.33858,0.10236,0.33858,0.11024,0.33858,0.11811,0.33858,0.12598,0.33858,0.13386,0.33858,0.14173,0.33858,0.14961,0.33858,0.15748,0.33858,0.16535,0.33858,0.17323,0.33858,0.1811,0.33858,0.18898,0.33858,0.19685,0.33858,0.20472,0.33858,0.2126,0.33858,0.22047,0.33858,0.22835,0.33858,0.23622,0.33858,0.24409,0.33858,0.25197,0.33858,0.25984,0.33858,0.26772,0.33858,0.27559,0.33858,0.28346,0.33858,0.29134,0.33858,0.29921,0.33858,0.30709,0.33858,0.31496,0.33858,0.32283,0.33858,0.33071,0.33858,0.33858,0.33858,0.34646,0.33858,0.35433,0.33858,0.3622,0.33858,0.37008,0.33858,0.37795,0.33858,0.38583,0.33858,0.3937,0.33858,0.40157,0.33858,0.40945,0.33858,0.41732,0.33858,0.4252,0.33858,0.43307,0.33858,0.44094,0.33858,0.44882,0.33858,0.45669,0.33858,0.46457,0.33858,0.47244,0.33858,0.48031,0.33858,0.48819,0.33858,0.49606,0.33858,0.50394,0.33858,0.51181,0.33858,0.51969,0.33858,0.52756,0.33858,0.53543,0.33858,0.54331,0.33858,0.55118,0.33858,0.55906,0.33858,0.56693,0.33858,0.5748,0.33858,0.58268,0.33858,0.59055,0.33858,0.59843,0.33858,0.6063,0.33858,0.61417,0.33858,0.62205,0.33858,0.62992,0.33858,0.6378,0.33858,0.64567,0.33858,0.65354,0.33858,0.66142,0.33858,0.66929,0.33858,0.67717,0.33858,0.68504,0.33858,0.69291,0.33858,0.70079,0.33858,0.70866,0.33858,0.71654,0.33858,0.72441,0.33858,0.73228,0.33858,0.74016,0.33858,0.74803,0.33858};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_57()
		{
			double[] value = {0.75591,0.33858,0.76378,0.33858,0.77165,0.33858,0.77953,0.33858,0.7874,0.33858,0.79528,0.33858,0.80315,0.33858,0.81102,0.33858,0.8189,0.33858,0.82677,0.33858,0.83465,0.33858,0.84252,0.33858,0.85039,0.33858,0.85827,0.33858,0.86614,0.33858,0.87402,0.33858,0.88189,0.33858,0.88976,0.33858,0.89764,0.33858,0.90551,0.33858,0.91339,0.33858,0.92126,0.33858,0.92913,0.33858,0.93701,0.33858,0.94488,0.33858,0.95276,0.33858,0.96063,0.33858,0.9685,0.33858,0.97638,0.33858,0.98425,0.33858,0.99213,0.33858,0.99609,0.33858,0.00391,0.34646,0.00787,0.34646,0.01575,0.34646,0.02362,0.34646,0.0315,0.34646,0.03937,0.34646,0.04724,0.34646,0.05512,0.34646,0.06299,0.34646,0.07087,0.34646,0.07874,0.34646,0.08661,0.34646,0.09449,0.34646,0.10236,0.34646,0.11024,0.34646,0.11811,0.34646,0.12598,0.34646,0.13386,0.34646,0.14173,0.34646,0.14961,0.34646,0.15748,0.34646,0.16535,0.34646,0.17323,0.34646,0.1811,0.34646,0.18898,0.34646,0.19685,0.34646,0.20472,0.34646,0.2126,0.34646,0.22047,0.34646,0.22835,0.34646,0.23622,0.34646,0.24409,0.34646,0.25197,0.34646,0.25984,0.34646,0.26772,0.34646,0.27559,0.34646,0.28346,0.34646,0.29134,0.34646,0.29921,0.34646,0.30709,0.34646,0.31496,0.34646,0.32283,0.34646,0.33071,0.34646,0.33858,0.34646,0.34646,0.34646,0.35433,0.34646,0.3622,0.34646,0.37008,0.34646,0.37795,0.34646,0.38583,0.34646,0.3937,0.34646,0.40157,0.34646,0.40945,0.34646,0.41732,0.34646,0.4252,0.34646,0.43307,0.34646,0.44094,0.34646,0.44882,0.34646,0.45669,0.34646,0.46457,0.34646,0.47244,0.34646,0.48031,0.34646,0.48819,0.34646,0.49606,0.34646,0.50394,0.34646,0.51181,0.34646,0.51969,0.34646,0.52756,0.34646};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_58()
		{
			double[] value = {0.53543,0.34646,0.54331,0.34646,0.55118,0.34646,0.55906,0.34646,0.56693,0.34646,0.5748,0.34646,0.58268,0.34646,0.59055,0.34646,0.59843,0.34646,0.6063,0.34646,0.61417,0.34646,0.62205,0.34646,0.62992,0.34646,0.6378,0.34646,0.64567,0.34646,0.65354,0.34646,0.66142,0.34646,0.66929,0.34646,0.67717,0.34646,0.68504,0.34646,0.69291,0.34646,0.70079,0.34646,0.70866,0.34646,0.71654,0.34646,0.72441,0.34646,0.73228,0.34646,0.74016,0.34646,0.74803,0.34646,0.75591,0.34646,0.76378,0.34646,0.77165,0.34646,0.77953,0.34646,0.7874,0.34646,0.79528,0.34646,0.80315,0.34646,0.81102,0.34646,0.8189,0.34646,0.82677,0.34646,0.83465,0.34646,0.84252,0.34646,0.85039,0.34646,0.85827,0.34646,0.86614,0.34646,0.87402,0.34646,0.88189,0.34646,0.88976,0.34646,0.89764,0.34646,0.90551,0.34646,0.91339,0.34646,0.92126,0.34646,0.92913,0.34646,0.93701,0.34646,0.94488,0.34646,0.95276,0.34646,0.96063,0.34646,0.9685,0.34646,0.97638,0.34646,0.98425,0.34646,0.99213,0.34646,0.99609,0.34646,0.00391,0.35433,0.00787,0.35433,0.01575,0.35433,0.02362,0.35433,0.0315,0.35433,0.03937,0.35433,0.04724,0.35433,0.05512,0.35433,0.06299,0.35433,0.07087,0.35433,0.07874,0.35433,0.08661,0.35433,0.09449,0.35433,0.10236,0.35433,0.11024,0.35433,0.11811,0.35433,0.12598,0.35433,0.13386,0.35433,0.14173,0.35433,0.14961,0.35433,0.15748,0.35433,0.16535,0.35433,0.17323,0.35433,0.1811,0.35433,0.18898,0.35433,0.19685,0.35433,0.20472,0.35433,0.2126,0.35433,0.22047,0.35433,0.22835,0.35433,0.23622,0.35433,0.24409,0.35433,0.25197,0.35433,0.25984,0.35433,0.26772,0.35433,0.27559,0.35433,0.28346,0.35433,0.29134,0.35433,0.29921,0.35433,0.30709,0.35433};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_59()
		{
			double[] value = {0.31496,0.35433,0.32283,0.35433,0.33071,0.35433,0.33858,0.35433,0.34646,0.35433,0.35433,0.35433,0.3622,0.35433,0.37008,0.35433,0.37795,0.35433,0.38583,0.35433,0.3937,0.35433,0.40157,0.35433,0.40945,0.35433,0.41732,0.35433,0.4252,0.35433,0.43307,0.35433,0.44094,0.35433,0.44882,0.35433,0.45669,0.35433,0.46457,0.35433,0.47244,0.35433,0.48031,0.35433,0.48819,0.35433,0.49606,0.35433,0.50394,0.35433,0.51181,0.35433,0.51969,0.35433,0.52756,0.35433,0.53543,0.35433,0.54331,0.35433,0.55118,0.35433,0.55906,0.35433,0.56693,0.35433,0.5748,0.35433,0.58268,0.35433,0.59055,0.35433,0.59843,0.35433,0.6063,0.35433,0.61417,0.35433,0.62205,0.35433,0.62992,0.35433,0.6378,0.35433,0.64567,0.35433,0.65354,0.35433,0.66142,0.35433,0.66929,0.35433,0.67717,0.35433,0.68504,0.35433,0.69291,0.35433,0.70079,0.35433,0.70866,0.35433,0.71654,0.35433,0.72441,0.35433,0.73228,0.35433,0.74016,0.35433,0.74803,0.35433,0.75591,0.35433,0.76378,0.35433,0.77165,0.35433,0.77953,0.35433,0.7874,0.35433,0.79528,0.35433,0.80315,0.35433,0.81102,0.35433,0.8189,0.35433,0.82677,0.35433,0.83465,0.35433,0.84252,0.35433,0.85039,0.35433,0.85827,0.35433,0.86614,0.35433,0.87402,0.35433,0.88189,0.35433,0.88976,0.35433,0.89764,0.35433,0.90551,0.35433,0.91339,0.35433,0.92126,0.35433,0.92913,0.35433,0.93701,0.35433,0.94488,0.35433,0.95276,0.35433,0.96063,0.35433,0.9685,0.35433,0.97638,0.35433,0.98425,0.35433,0.99213,0.35433,0.99609,0.35433,0.00391,0.3622,0.00787,0.3622,0.01575,0.3622,0.02362,0.3622,0.0315,0.3622,0.03937,0.3622,0.04724,0.3622,0.05512,0.3622,0.06299,0.3622,0.07087,0.3622,0.07874,0.3622,0.08661,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_60()
		{
			double[] value = {0.09449,0.3622,0.10236,0.3622,0.11024,0.3622,0.11811,0.3622,0.12598,0.3622,0.13386,0.3622,0.14173,0.3622,0.14961,0.3622,0.15748,0.3622,0.16535,0.3622,0.17323,0.3622,0.1811,0.3622,0.18898,0.3622,0.19685,0.3622,0.20472,0.3622,0.2126,0.3622,0.22047,0.3622,0.22835,0.3622,0.23622,0.3622,0.24409,0.3622,0.25197,0.3622,0.25984,0.3622,0.26772,0.3622,0.27559,0.3622,0.28346,0.3622,0.29134,0.3622,0.29921,0.3622,0.30709,0.3622,0.31496,0.3622,0.32283,0.3622,0.33071,0.3622,0.33858,0.3622,0.34646,0.3622,0.35433,0.3622,0.3622,0.3622,0.37008,0.3622,0.37795,0.3622,0.38583,0.3622,0.3937,0.3622,0.40157,0.3622,0.40945,0.3622,0.41732,0.3622,0.4252,0.3622,0.43307,0.3622,0.44094,0.3622,0.44882,0.3622,0.45669,0.3622,0.46457,0.3622,0.47244,0.3622,0.48031,0.3622,0.48819,0.3622,0.49606,0.3622,0.50394,0.3622,0.51181,0.3622,0.51969,0.3622,0.52756,0.3622,0.53543,0.3622,0.54331,0.3622,0.55118,0.3622,0.55906,0.3622,0.56693,0.3622,0.5748,0.3622,0.58268,0.3622,0.59055,0.3622,0.59843,0.3622,0.6063,0.3622,0.61417,0.3622,0.62205,0.3622,0.62992,0.3622,0.6378,0.3622,0.64567,0.3622,0.65354,0.3622,0.66142,0.3622,0.66929,0.3622,0.67717,0.3622,0.68504,0.3622,0.69291,0.3622,0.70079,0.3622,0.70866,0.3622,0.71654,0.3622,0.72441,0.3622,0.73228,0.3622,0.74016,0.3622,0.74803,0.3622,0.75591,0.3622,0.76378,0.3622,0.77165,0.3622,0.77953,0.3622,0.7874,0.3622,0.79528,0.3622,0.80315,0.3622,0.81102,0.3622,0.8189,0.3622,0.82677,0.3622,0.83465,0.3622,0.84252,0.3622,0.85039,0.3622,0.85827,0.3622,0.86614,0.3622,0.87402,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_61()
		{
			double[] value = {0.88189,0.3622,0.88976,0.3622,0.89764,0.3622,0.90551,0.3622,0.91339,0.3622,0.92126,0.3622,0.92913,0.3622,0.93701,0.3622,0.94488,0.3622,0.95276,0.3622,0.96063,0.3622,0.9685,0.3622,0.97638,0.3622,0.98425,0.3622,0.99213,0.3622,0.99609,0.3622,0.00391,0.37008,0.00787,0.37008,0.01575,0.37008,0.02362,0.37008,0.0315,0.37008,0.03937,0.37008,0.04724,0.37008,0.05512,0.37008,0.06299,0.37008,0.07087,0.37008,0.07874,0.37008,0.08661,0.37008,0.09449,0.37008,0.10236,0.37008,0.11024,0.37008,0.11811,0.37008,0.12598,0.37008,0.13386,0.37008,0.14173,0.37008,0.14961,0.37008,0.15748,0.37008,0.16535,0.37008,0.17323,0.37008,0.1811,0.37008,0.18898,0.37008,0.19685,0.37008,0.20472,0.37008,0.2126,0.37008,0.22047,0.37008,0.22835,0.37008,0.23622,0.37008,0.24409,0.37008,0.25197,0.37008,0.25984,0.37008,0.26772,0.37008,0.27559,0.37008,0.28346,0.37008,0.29134,0.37008,0.29921,0.37008,0.30709,0.37008,0.31496,0.37008,0.32283,0.37008,0.33071,0.37008,0.33858,0.37008,0.34646,0.37008,0.35433,0.37008,0.3622,0.37008,0.37008,0.37008,0.37795,0.37008,0.38583,0.37008,0.3937,0.37008,0.40157,0.37008,0.40945,0.37008,0.41732,0.37008,0.4252,0.37008,0.43307,0.37008,0.44094,0.37008,0.44882,0.37008,0.45669,0.37008,0.46457,0.37008,0.47244,0.37008,0.48031,0.37008,0.48819,0.37008,0.49606,0.37008,0.50394,0.37008,0.51181,0.37008,0.51969,0.37008,0.52756,0.37008,0.53543,0.37008,0.54331,0.37008,0.55118,0.37008,0.55906,0.37008,0.56693,0.37008,0.5748,0.37008,0.58268,0.37008,0.59055,0.37008,0.59843,0.37008,0.6063,0.37008,0.61417,0.37008,0.62205,0.37008,0.62992,0.37008,0.6378,0.37008,0.64567,0.37008,0.65354,0.37008};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_62()
		{
			double[] value = {0.66142,0.37008,0.66929,0.37008,0.67717,0.37008,0.68504,0.37008,0.69291,0.37008,0.70079,0.37008,0.70866,0.37008,0.71654,0.37008,0.72441,0.37008,0.73228,0.37008,0.74016,0.37008,0.74803,0.37008,0.75591,0.37008,0.76378,0.37008,0.77165,0.37008,0.77953,0.37008,0.7874,0.37008,0.79528,0.37008,0.80315,0.37008,0.81102,0.37008,0.8189,0.37008,0.82677,0.37008,0.83465,0.37008,0.84252,0.37008,0.85039,0.37008,0.85827,0.37008,0.86614,0.37008,0.87402,0.37008,0.88189,0.37008,0.88976,0.37008,0.89764,0.37008,0.90551,0.37008,0.91339,0.37008,0.92126,0.37008,0.92913,0.37008,0.93701,0.37008,0.94488,0.37008,0.95276,0.37008,0.96063,0.37008,0.9685,0.37008,0.97638,0.37008,0.98425,0.37008,0.99213,0.37008,0.99609,0.37008,0.00391,0.37795,0.00787,0.37795,0.01575,0.37795,0.02362,0.37795,0.0315,0.37795,0.03937,0.37795,0.04724,0.37795,0.05512,0.37795,0.06299,0.37795,0.07087,0.37795,0.07874,0.37795,0.08661,0.37795,0.09449,0.37795,0.10236,0.37795,0.11024,0.37795,0.11811,0.37795,0.12598,0.37795,0.13386,0.37795,0.14173,0.37795,0.14961,0.37795,0.15748,0.37795,0.16535,0.37795,0.17323,0.37795,0.1811,0.37795,0.18898,0.37795,0.19685,0.37795,0.20472,0.37795,0.2126,0.37795,0.22047,0.37795,0.22835,0.37795,0.23622,0.37795,0.24409,0.37795,0.25197,0.37795,0.25984,0.37795,0.26772,0.37795,0.27559,0.37795,0.28346,0.37795,0.29134,0.37795,0.29921,0.37795,0.30709,0.37795,0.31496,0.37795,0.32283,0.37795,0.33071,0.37795,0.33858,0.37795,0.34646,0.37795,0.35433,0.37795,0.3622,0.37795,0.37008,0.37795,0.37795,0.37795,0.38583,0.37795,0.3937,0.37795,0.40157,0.37795,0.40945,0.37795,0.41732,0.37795,0.4252,0.37795,0.43307,0.37795};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_63()
		{
			double[] value = {0.44094,0.37795,0.44882,0.37795,0.45669,0.37795,0.46457,0.37795,0.47244,0.37795,0.48031,0.37795,0.48819,0.37795,0.49606,0.37795,0.50394,0.37795,0.51181,0.37795,0.51969,0.37795,0.52756,0.37795,0.53543,0.37795,0.54331,0.37795,0.55118,0.37795,0.55906,0.37795,0.56693,0.37795,0.5748,0.37795,0.58268,0.37795,0.59055,0.37795,0.59843,0.37795,0.6063,0.37795,0.61417,0.37795,0.62205,0.37795,0.62992,0.37795,0.6378,0.37795,0.64567,0.37795,0.65354,0.37795,0.66142,0.37795,0.66929,0.37795,0.67717,0.37795,0.68504,0.37795,0.69291,0.37795,0.70079,0.37795,0.70866,0.37795,0.71654,0.37795,0.72441,0.37795,0.73228,0.37795,0.74016,0.37795,0.74803,0.37795,0.75591,0.37795,0.76378,0.37795,0.77165,0.37795,0.77953,0.37795,0.7874,0.37795,0.79528,0.37795,0.80315,0.37795,0.81102,0.37795,0.8189,0.37795,0.82677,0.37795,0.83465,0.37795,0.84252,0.37795,0.85039,0.37795,0.85827,0.37795,0.86614,0.37795,0.87402,0.37795,0.88189,0.37795,0.88976,0.37795,0.89764,0.37795,0.90551,0.37795,0.91339,0.37795,0.92126,0.37795,0.92913,0.37795,0.93701,0.37795,0.94488,0.37795,0.95276,0.37795,0.96063,0.37795,0.9685,0.37795,0.97638,0.37795,0.98425,0.37795,0.99213,0.37795,0.99609,0.37795,0.00391,0.38583,0.00787,0.38583,0.01575,0.38583,0.02362,0.38583,0.0315,0.38583,0.03937,0.38583,0.04724,0.38583,0.05512,0.38583,0.06299,0.38583,0.07087,0.38583,0.07874,0.38583,0.08661,0.38583,0.09449,0.38583,0.10236,0.38583,0.11024,0.38583,0.11811,0.38583,0.12598,0.38583,0.13386,0.38583,0.14173,0.38583,0.14961,0.38583,0.15748,0.38583,0.16535,0.38583,0.17323,0.38583,0.1811,0.38583,0.18898,0.38583,0.19685,0.38583,0.20472,0.38583,0.2126,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_64()
		{
			double[] value = {0.22047,0.38583,0.22835,0.38583,0.23622,0.38583,0.24409,0.38583,0.25197,0.38583,0.25984,0.38583,0.26772,0.38583,0.27559,0.38583,0.28346,0.38583,0.29134,0.38583,0.29921,0.38583,0.30709,0.38583,0.31496,0.38583,0.32283,0.38583,0.33071,0.38583,0.33858,0.38583,0.34646,0.38583,0.35433,0.38583,0.3622,0.38583,0.37008,0.38583,0.37795,0.38583,0.38583,0.38583,0.3937,0.38583,0.40157,0.38583,0.40945,0.38583,0.41732,0.38583,0.4252,0.38583,0.43307,0.38583,0.44094,0.38583,0.44882,0.38583,0.45669,0.38583,0.46457,0.38583,0.47244,0.38583,0.48031,0.38583,0.48819,0.38583,0.49606,0.38583,0.50394,0.38583,0.51181,0.38583,0.51969,0.38583,0.52756,0.38583,0.53543,0.38583,0.54331,0.38583,0.55118,0.38583,0.55906,0.38583,0.56693,0.38583,0.5748,0.38583,0.58268,0.38583,0.59055,0.38583,0.59843,0.38583,0.6063,0.38583,0.61417,0.38583,0.62205,0.38583,0.62992,0.38583,0.6378,0.38583,0.64567,0.38583,0.65354,0.38583,0.66142,0.38583,0.66929,0.38583,0.67717,0.38583,0.68504,0.38583,0.69291,0.38583,0.70079,0.38583,0.70866,0.38583,0.71654,0.38583,0.72441,0.38583,0.73228,0.38583,0.74016,0.38583,0.74803,0.38583,0.75591,0.38583,0.76378,0.38583,0.77165,0.38583,0.77953,0.38583,0.7874,0.38583,0.79528,0.38583,0.80315,0.38583,0.81102,0.38583,0.8189,0.38583,0.82677,0.38583,0.83465,0.38583,0.84252,0.38583,0.85039,0.38583,0.85827,0.38583,0.86614,0.38583,0.87402,0.38583,0.88189,0.38583,0.88976,0.38583,0.89764,0.38583,0.90551,0.38583,0.91339,0.38583,0.92126,0.38583,0.92913,0.38583,0.93701,0.38583,0.94488,0.38583,0.95276,0.38583,0.96063,0.38583,0.9685,0.38583,0.97638,0.38583,0.98425,0.38583,0.99213,0.38583,0.99609,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_65()
		{
			double[] value = {0.00391,0.3937,0.00787,0.3937,0.01575,0.3937,0.02362,0.3937,0.0315,0.3937,0.03937,0.3937,0.04724,0.3937,0.05512,0.3937,0.06299,0.3937,0.07087,0.3937,0.07874,0.3937,0.08661,0.3937,0.09449,0.3937,0.10236,0.3937,0.11024,0.3937,0.11811,0.3937,0.12598,0.3937,0.13386,0.3937,0.14173,0.3937,0.14961,0.3937,0.15748,0.3937,0.16535,0.3937,0.17323,0.3937,0.1811,0.3937,0.18898,0.3937,0.19685,0.3937,0.20472,0.3937,0.2126,0.3937,0.22047,0.3937,0.22835,0.3937,0.23622,0.3937,0.24409,0.3937,0.25197,0.3937,0.25984,0.3937,0.26772,0.3937,0.27559,0.3937,0.28346,0.3937,0.29134,0.3937,0.29921,0.3937,0.30709,0.3937,0.31496,0.3937,0.32283,0.3937,0.33071,0.3937,0.33858,0.3937,0.34646,0.3937,0.35433,0.3937,0.3622,0.3937,0.37008,0.3937,0.37795,0.3937,0.38583,0.3937,0.3937,0.3937,0.40157,0.3937,0.40945,0.3937,0.41732,0.3937,0.4252,0.3937,0.43307,0.3937,0.44094,0.3937,0.44882,0.3937,0.45669,0.3937,0.46457,0.3937,0.47244,0.3937,0.48031,0.3937,0.48819,0.3937,0.49606,0.3937,0.50394,0.3937,0.51181,0.3937,0.51969,0.3937,0.52756,0.3937,0.53543,0.3937,0.54331,0.3937,0.55118,0.3937,0.55906,0.3937,0.56693,0.3937,0.5748,0.3937,0.58268,0.3937,0.59055,0.3937,0.59843,0.3937,0.6063,0.3937,0.61417,0.3937,0.62205,0.3937,0.62992,0.3937,0.6378,0.3937,0.64567,0.3937,0.65354,0.3937,0.66142,0.3937,0.66929,0.3937,0.67717,0.3937,0.68504,0.3937,0.69291,0.3937,0.70079,0.3937,0.70866,0.3937,0.71654,0.3937,0.72441,0.3937,0.73228,0.3937,0.74016,0.3937,0.74803,0.3937,0.75591,0.3937,0.76378,0.3937,0.77165,0.3937,0.77953,0.3937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_66()
		{
			double[] value = {0.7874,0.3937,0.79528,0.3937,0.80315,0.3937,0.81102,0.3937,0.8189,0.3937,0.82677,0.3937,0.83465,0.3937,0.84252,0.3937,0.85039,0.3937,0.85827,0.3937,0.86614,0.3937,0.87402,0.3937,0.88189,0.3937,0.88976,0.3937,0.89764,0.3937,0.90551,0.3937,0.91339,0.3937,0.92126,0.3937,0.92913,0.3937,0.93701,0.3937,0.94488,0.3937,0.95276,0.3937,0.96063,0.3937,0.9685,0.3937,0.97638,0.3937,0.98425,0.3937,0.99213,0.3937,0.99609,0.3937,0.00391,0.40157,0.00787,0.40157,0.01575,0.40157,0.02362,0.40157,0.0315,0.40157,0.03937,0.40157,0.04724,0.40157,0.05512,0.40157,0.06299,0.40157,0.07087,0.40157,0.07874,0.40157,0.08661,0.40157,0.09449,0.40157,0.10236,0.40157,0.11024,0.40157,0.11811,0.40157,0.12598,0.40157,0.13386,0.40157,0.14173,0.40157,0.14961,0.40157,0.15748,0.40157,0.16535,0.40157,0.17323,0.40157,0.1811,0.40157,0.18898,0.40157,0.19685,0.40157,0.20472,0.40157,0.2126,0.40157,0.22047,0.40157,0.22835,0.40157,0.23622,0.40157,0.24409,0.40157,0.25197,0.40157,0.25984,0.40157,0.26772,0.40157,0.27559,0.40157,0.28346,0.40157,0.29134,0.40157,0.29921,0.40157,0.30709,0.40157,0.31496,0.40157,0.32283,0.40157,0.33071,0.40157,0.33858,0.40157,0.34646,0.40157,0.35433,0.40157,0.3622,0.40157,0.37008,0.40157,0.37795,0.40157,0.38583,0.40157,0.3937,0.40157,0.40157,0.40157,0.40945,0.40157,0.41732,0.40157,0.4252,0.40157,0.43307,0.40157,0.44094,0.40157,0.44882,0.40157,0.45669,0.40157,0.46457,0.40157,0.47244,0.40157,0.48031,0.40157,0.48819,0.40157,0.49606,0.40157,0.50394,0.40157,0.51181,0.40157,0.51969,0.40157,0.52756,0.40157,0.53543,0.40157,0.54331,0.40157,0.55118,0.40157,0.55906,0.40157};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_67()
		{
			double[] value = {0.56693,0.40157,0.5748,0.40157,0.58268,0.40157,0.59055,0.40157,0.59843,0.40157,0.6063,0.40157,0.61417,0.40157,0.62205,0.40157,0.62992,0.40157,0.6378,0.40157,0.64567,0.40157,0.65354,0.40157,0.66142,0.40157,0.66929,0.40157,0.67717,0.40157,0.68504,0.40157,0.69291,0.40157,0.70079,0.40157,0.70866,0.40157,0.71654,0.40157,0.72441,0.40157,0.73228,0.40157,0.74016,0.40157,0.74803,0.40157,0.75591,0.40157,0.76378,0.40157,0.77165,0.40157,0.77953,0.40157,0.7874,0.40157,0.79528,0.40157,0.80315,0.40157,0.81102,0.40157,0.8189,0.40157,0.82677,0.40157,0.83465,0.40157,0.84252,0.40157,0.85039,0.40157,0.85827,0.40157,0.86614,0.40157,0.87402,0.40157,0.88189,0.40157,0.88976,0.40157,0.89764,0.40157,0.90551,0.40157,0.91339,0.40157,0.92126,0.40157,0.92913,0.40157,0.93701,0.40157,0.94488,0.40157,0.95276,0.40157,0.96063,0.40157,0.9685,0.40157,0.97638,0.40157,0.98425,0.40157,0.99213,0.40157,0.99609,0.40157,0.00391,0.40945,0.00787,0.40945,0.01575,0.40945,0.02362,0.40945,0.0315,0.40945,0.03937,0.40945,0.04724,0.40945,0.05512,0.40945,0.06299,0.40945,0.07087,0.40945,0.07874,0.40945,0.08661,0.40945,0.09449,0.40945,0.10236,0.40945,0.11024,0.40945,0.11811,0.40945,0.12598,0.40945,0.13386,0.40945,0.14173,0.40945,0.14961,0.40945,0.15748,0.40945,0.16535,0.40945,0.17323,0.40945,0.1811,0.40945,0.18898,0.40945,0.19685,0.40945,0.20472,0.40945,0.2126,0.40945,0.22047,0.40945,0.22835,0.40945,0.23622,0.40945,0.24409,0.40945,0.25197,0.40945,0.25984,0.40945,0.26772,0.40945,0.27559,0.40945,0.28346,0.40945,0.29134,0.40945,0.29921,0.40945,0.30709,0.40945,0.31496,0.40945,0.32283,0.40945,0.33071,0.40945,0.33858,0.40945};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_68()
		{
			double[] value = {0.34646,0.40945,0.35433,0.40945,0.3622,0.40945,0.37008,0.40945,0.37795,0.40945,0.38583,0.40945,0.3937,0.40945,0.40157,0.40945,0.40945,0.40945,0.41732,0.40945,0.4252,0.40945,0.43307,0.40945,0.44094,0.40945,0.44882,0.40945,0.45669,0.40945,0.46457,0.40945,0.47244,0.40945,0.48031,0.40945,0.48819,0.40945,0.49606,0.40945,0.50394,0.40945,0.51181,0.40945,0.51969,0.40945,0.52756,0.40945,0.53543,0.40945,0.54331,0.40945,0.55118,0.40945,0.55906,0.40945,0.56693,0.40945,0.5748,0.40945,0.58268,0.40945,0.59055,0.40945,0.59843,0.40945,0.6063,0.40945,0.61417,0.40945,0.62205,0.40945,0.62992,0.40945,0.6378,0.40945,0.64567,0.40945,0.65354,0.40945,0.66142,0.40945,0.66929,0.40945,0.67717,0.40945,0.68504,0.40945,0.69291,0.40945,0.70079,0.40945,0.70866,0.40945,0.71654,0.40945,0.72441,0.40945,0.73228,0.40945,0.74016,0.40945,0.74803,0.40945,0.75591,0.40945,0.76378,0.40945,0.77165,0.40945,0.77953,0.40945,0.7874,0.40945,0.79528,0.40945,0.80315,0.40945,0.81102,0.40945,0.8189,0.40945,0.82677,0.40945,0.83465,0.40945,0.84252,0.40945,0.85039,0.40945,0.85827,0.40945,0.86614,0.40945,0.87402,0.40945,0.88189,0.40945,0.88976,0.40945,0.89764,0.40945,0.90551,0.40945,0.91339,0.40945,0.92126,0.40945,0.92913,0.40945,0.93701,0.40945,0.94488,0.40945,0.95276,0.40945,0.96063,0.40945,0.9685,0.40945,0.97638,0.40945,0.98425,0.40945,0.99213,0.40945,0.99609,0.40945,0.00391,0.41732,0.00787,0.41732,0.01575,0.41732,0.02362,0.41732,0.0315,0.41732,0.03937,0.41732,0.04724,0.41732,0.05512,0.41732,0.06299,0.41732,0.07087,0.41732,0.07874,0.41732,0.08661,0.41732,0.09449,0.41732,0.10236,0.41732,0.11024,0.41732,0.11811,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_69()
		{
			double[] value = {0.12598,0.41732,0.13386,0.41732,0.14173,0.41732,0.14961,0.41732,0.15748,0.41732,0.16535,0.41732,0.17323,0.41732,0.1811,0.41732,0.18898,0.41732,0.19685,0.41732,0.20472,0.41732,0.2126,0.41732,0.22047,0.41732,0.22835,0.41732,0.23622,0.41732,0.24409,0.41732,0.25197,0.41732,0.25984,0.41732,0.26772,0.41732,0.27559,0.41732,0.28346,0.41732,0.29134,0.41732,0.29921,0.41732,0.30709,0.41732,0.31496,0.41732,0.32283,0.41732,0.33071,0.41732,0.33858,0.41732,0.34646,0.41732,0.35433,0.41732,0.3622,0.41732,0.37008,0.41732,0.37795,0.41732,0.38583,0.41732,0.3937,0.41732,0.40157,0.41732,0.40945,0.41732,0.41732,0.41732,0.4252,0.41732,0.43307,0.41732,0.44094,0.41732,0.44882,0.41732,0.45669,0.41732,0.46457,0.41732,0.47244,0.41732,0.48031,0.41732,0.48819,0.41732,0.49606,0.41732,0.50394,0.41732,0.51181,0.41732,0.51969,0.41732,0.52756,0.41732,0.53543,0.41732,0.54331,0.41732,0.55118,0.41732,0.55906,0.41732,0.56693,0.41732,0.5748,0.41732,0.58268,0.41732,0.59055,0.41732,0.59843,0.41732,0.6063,0.41732,0.61417,0.41732,0.62205,0.41732,0.62992,0.41732,0.6378,0.41732,0.64567,0.41732,0.65354,0.41732,0.66142,0.41732,0.66929,0.41732,0.67717,0.41732,0.68504,0.41732,0.69291,0.41732,0.70079,0.41732,0.70866,0.41732,0.71654,0.41732,0.72441,0.41732,0.73228,0.41732,0.74016,0.41732,0.74803,0.41732,0.75591,0.41732,0.76378,0.41732,0.77165,0.41732,0.77953,0.41732,0.7874,0.41732,0.79528,0.41732,0.80315,0.41732,0.81102,0.41732,0.8189,0.41732,0.82677,0.41732,0.83465,0.41732,0.84252,0.41732,0.85039,0.41732,0.85827,0.41732,0.86614,0.41732,0.87402,0.41732,0.88189,0.41732,0.88976,0.41732,0.89764,0.41732,0.90551,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_70()
		{
			double[] value = {0.91339,0.41732,0.92126,0.41732,0.92913,0.41732,0.93701,0.41732,0.94488,0.41732,0.95276,0.41732,0.96063,0.41732,0.9685,0.41732,0.97638,0.41732,0.98425,0.41732,0.99213,0.41732,0.99609,0.41732,0.00391,0.4252,0.00787,0.4252,0.01575,0.4252,0.02362,0.4252,0.0315,0.4252,0.03937,0.4252,0.04724,0.4252,0.05512,0.4252,0.06299,0.4252,0.07087,0.4252,0.07874,0.4252,0.08661,0.4252,0.09449,0.4252,0.10236,0.4252,0.11024,0.4252,0.11811,0.4252,0.12598,0.4252,0.13386,0.4252,0.14173,0.4252,0.14961,0.4252,0.15748,0.4252,0.16535,0.4252,0.17323,0.4252,0.1811,0.4252,0.18898,0.4252,0.19685,0.4252,0.20472,0.4252,0.2126,0.4252,0.22047,0.4252,0.22835,0.4252,0.23622,0.4252,0.24409,0.4252,0.25197,0.4252,0.25984,0.4252,0.26772,0.4252,0.27559,0.4252,0.28346,0.4252,0.29134,0.4252,0.29921,0.4252,0.30709,0.4252,0.31496,0.4252,0.32283,0.4252,0.33071,0.4252,0.33858,0.4252,0.34646,0.4252,0.35433,0.4252,0.3622,0.4252,0.37008,0.4252,0.37795,0.4252,0.38583,0.4252,0.3937,0.4252,0.40157,0.4252,0.40945,0.4252,0.41732,0.4252,0.4252,0.4252,0.43307,0.4252,0.44094,0.4252,0.44882,0.4252,0.45669,0.4252,0.46457,0.4252,0.47244,0.4252,0.48031,0.4252,0.48819,0.4252,0.49606,0.4252,0.50394,0.4252,0.51181,0.4252,0.51969,0.4252,0.52756,0.4252,0.53543,0.4252,0.54331,0.4252,0.55118,0.4252,0.55906,0.4252,0.56693,0.4252,0.5748,0.4252,0.58268,0.4252,0.59055,0.4252,0.59843,0.4252,0.6063,0.4252,0.61417,0.4252,0.62205,0.4252,0.62992,0.4252,0.6378,0.4252,0.64567,0.4252,0.65354,0.4252,0.66142,0.4252,0.66929,0.4252,0.67717,0.4252,0.68504,0.4252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_71()
		{
			double[] value = {0.69291,0.4252,0.70079,0.4252,0.70866,0.4252,0.71654,0.4252,0.72441,0.4252,0.73228,0.4252,0.74016,0.4252,0.74803,0.4252,0.75591,0.4252,0.76378,0.4252,0.77165,0.4252,0.77953,0.4252,0.7874,0.4252,0.79528,0.4252,0.80315,0.4252,0.81102,0.4252,0.8189,0.4252,0.82677,0.4252,0.83465,0.4252,0.84252,0.4252,0.85039,0.4252,0.85827,0.4252,0.86614,0.4252,0.87402,0.4252,0.88189,0.4252,0.88976,0.4252,0.89764,0.4252,0.90551,0.4252,0.91339,0.4252,0.92126,0.4252,0.92913,0.4252,0.93701,0.4252,0.94488,0.4252,0.95276,0.4252,0.96063,0.4252,0.9685,0.4252,0.97638,0.4252,0.98425,0.4252,0.99213,0.4252,0.99609,0.4252,0.00391,0.43307,0.00787,0.43307,0.01575,0.43307,0.02362,0.43307,0.0315,0.43307,0.03937,0.43307,0.04724,0.43307,0.05512,0.43307,0.06299,0.43307,0.07087,0.43307,0.07874,0.43307,0.08661,0.43307,0.09449,0.43307,0.10236,0.43307,0.11024,0.43307,0.11811,0.43307,0.12598,0.43307,0.13386,0.43307,0.14173,0.43307,0.14961,0.43307,0.15748,0.43307,0.16535,0.43307,0.17323,0.43307,0.1811,0.43307,0.18898,0.43307,0.19685,0.43307,0.20472,0.43307,0.2126,0.43307,0.22047,0.43307,0.22835,0.43307,0.23622,0.43307,0.24409,0.43307,0.25197,0.43307,0.25984,0.43307,0.26772,0.43307,0.27559,0.43307,0.28346,0.43307,0.29134,0.43307,0.29921,0.43307,0.30709,0.43307,0.31496,0.43307,0.32283,0.43307,0.33071,0.43307,0.33858,0.43307,0.34646,0.43307,0.35433,0.43307,0.3622,0.43307,0.37008,0.43307,0.37795,0.43307,0.38583,0.43307,0.3937,0.43307,0.40157,0.43307,0.40945,0.43307,0.41732,0.43307,0.4252,0.43307,0.43307,0.43307,0.44094,0.43307,0.44882,0.43307,0.45669,0.43307,0.46457,0.43307};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_72()
		{
			double[] value = {0.47244,0.43307,0.48031,0.43307,0.48819,0.43307,0.49606,0.43307,0.50394,0.43307,0.51181,0.43307,0.51969,0.43307,0.52756,0.43307,0.53543,0.43307,0.54331,0.43307,0.55118,0.43307,0.55906,0.43307,0.56693,0.43307,0.5748,0.43307,0.58268,0.43307,0.59055,0.43307,0.59843,0.43307,0.6063,0.43307,0.61417,0.43307,0.62205,0.43307,0.62992,0.43307,0.6378,0.43307,0.64567,0.43307,0.65354,0.43307,0.66142,0.43307,0.66929,0.43307,0.67717,0.43307,0.68504,0.43307,0.69291,0.43307,0.70079,0.43307,0.70866,0.43307,0.71654,0.43307,0.72441,0.43307,0.73228,0.43307,0.74016,0.43307,0.74803,0.43307,0.75591,0.43307,0.76378,0.43307,0.77165,0.43307,0.77953,0.43307,0.7874,0.43307,0.79528,0.43307,0.80315,0.43307,0.81102,0.43307,0.8189,0.43307,0.82677,0.43307,0.83465,0.43307,0.84252,0.43307,0.85039,0.43307,0.85827,0.43307,0.86614,0.43307,0.87402,0.43307,0.88189,0.43307,0.88976,0.43307,0.89764,0.43307,0.90551,0.43307,0.91339,0.43307,0.92126,0.43307,0.92913,0.43307,0.93701,0.43307,0.94488,0.43307,0.95276,0.43307,0.96063,0.43307,0.9685,0.43307,0.97638,0.43307,0.98425,0.43307,0.99213,0.43307,0.99609,0.43307,0.00391,0.44094,0.00787,0.44094,0.01575,0.44094,0.02362,0.44094,0.0315,0.44094,0.03937,0.44094,0.04724,0.44094,0.05512,0.44094,0.06299,0.44094,0.07087,0.44094,0.07874,0.44094,0.08661,0.44094,0.09449,0.44094,0.10236,0.44094,0.11024,0.44094,0.11811,0.44094,0.12598,0.44094,0.13386,0.44094,0.14173,0.44094,0.14961,0.44094,0.15748,0.44094,0.16535,0.44094,0.17323,0.44094,0.1811,0.44094,0.18898,0.44094,0.19685,0.44094,0.20472,0.44094,0.2126,0.44094,0.22047,0.44094,0.22835,0.44094,0.23622,0.44094,0.24409,0.44094};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_73()
		{
			double[] value = {0.25197,0.44094,0.25984,0.44094,0.26772,0.44094,0.27559,0.44094,0.28346,0.44094,0.29134,0.44094,0.29921,0.44094,0.30709,0.44094,0.31496,0.44094,0.32283,0.44094,0.33071,0.44094,0.33858,0.44094,0.34646,0.44094,0.35433,0.44094,0.3622,0.44094,0.37008,0.44094,0.37795,0.44094,0.38583,0.44094,0.3937,0.44094,0.40157,0.44094,0.40945,0.44094,0.41732,0.44094,0.4252,0.44094,0.43307,0.44094,0.44094,0.44094,0.44882,0.44094,0.45669,0.44094,0.46457,0.44094,0.47244,0.44094,0.48031,0.44094,0.48819,0.44094,0.49606,0.44094,0.50394,0.44094,0.51181,0.44094,0.51969,0.44094,0.52756,0.44094,0.53543,0.44094,0.54331,0.44094,0.55118,0.44094,0.55906,0.44094,0.56693,0.44094,0.5748,0.44094,0.58268,0.44094,0.59055,0.44094,0.59843,0.44094,0.6063,0.44094,0.61417,0.44094,0.62205,0.44094,0.62992,0.44094,0.6378,0.44094,0.64567,0.44094,0.65354,0.44094,0.66142,0.44094,0.66929,0.44094,0.67717,0.44094,0.68504,0.44094,0.69291,0.44094,0.70079,0.44094,0.70866,0.44094,0.71654,0.44094,0.72441,0.44094,0.73228,0.44094,0.74016,0.44094,0.74803,0.44094,0.75591,0.44094,0.76378,0.44094,0.77165,0.44094,0.77953,0.44094,0.7874,0.44094,0.79528,0.44094,0.80315,0.44094,0.81102,0.44094,0.8189,0.44094,0.82677,0.44094,0.83465,0.44094,0.84252,0.44094,0.85039,0.44094,0.85827,0.44094,0.86614,0.44094,0.87402,0.44094,0.88189,0.44094,0.88976,0.44094,0.89764,0.44094,0.90551,0.44094,0.91339,0.44094,0.92126,0.44094,0.92913,0.44094,0.93701,0.44094,0.94488,0.44094,0.95276,0.44094,0.96063,0.44094,0.9685,0.44094,0.97638,0.44094,0.98425,0.44094,0.99213,0.44094,0.99609,0.44094,0.00391,0.44882,0.00787,0.44882,0.01575,0.44882,0.02362,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_74()
		{
			double[] value = {0.0315,0.44882,0.03937,0.44882,0.04724,0.44882,0.05512,0.44882,0.06299,0.44882,0.07087,0.44882,0.07874,0.44882,0.08661,0.44882,0.09449,0.44882,0.10236,0.44882,0.11024,0.44882,0.11811,0.44882,0.12598,0.44882,0.13386,0.44882,0.14173,0.44882,0.14961,0.44882,0.15748,0.44882,0.16535,0.44882,0.17323,0.44882,0.1811,0.44882,0.18898,0.44882,0.19685,0.44882,0.20472,0.44882,0.2126,0.44882,0.22047,0.44882,0.22835,0.44882,0.23622,0.44882,0.24409,0.44882,0.25197,0.44882,0.25984,0.44882,0.26772,0.44882,0.27559,0.44882,0.28346,0.44882,0.29134,0.44882,0.29921,0.44882,0.30709,0.44882,0.31496,0.44882,0.32283,0.44882,0.33071,0.44882,0.33858,0.44882,0.34646,0.44882,0.35433,0.44882,0.3622,0.44882,0.37008,0.44882,0.37795,0.44882,0.38583,0.44882,0.3937,0.44882,0.40157,0.44882,0.40945,0.44882,0.41732,0.44882,0.4252,0.44882,0.43307,0.44882,0.44094,0.44882,0.44882,0.44882,0.45669,0.44882,0.46457,0.44882,0.47244,0.44882,0.48031,0.44882,0.48819,0.44882,0.49606,0.44882,0.50394,0.44882,0.51181,0.44882,0.51969,0.44882,0.52756,0.44882,0.53543,0.44882,0.54331,0.44882,0.55118,0.44882,0.55906,0.44882,0.56693,0.44882,0.5748,0.44882,0.58268,0.44882,0.59055,0.44882,0.59843,0.44882,0.6063,0.44882,0.61417,0.44882,0.62205,0.44882,0.62992,0.44882,0.6378,0.44882,0.64567,0.44882,0.65354,0.44882,0.66142,0.44882,0.66929,0.44882,0.67717,0.44882,0.68504,0.44882,0.69291,0.44882,0.70079,0.44882,0.70866,0.44882,0.71654,0.44882,0.72441,0.44882,0.73228,0.44882,0.74016,0.44882,0.74803,0.44882,0.75591,0.44882,0.76378,0.44882,0.77165,0.44882,0.77953,0.44882,0.7874,0.44882,0.79528,0.44882,0.80315,0.44882,0.81102,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_75()
		{
			double[] value = {0.8189,0.44882,0.82677,0.44882,0.83465,0.44882,0.84252,0.44882,0.85039,0.44882,0.85827,0.44882,0.86614,0.44882,0.87402,0.44882,0.88189,0.44882,0.88976,0.44882,0.89764,0.44882,0.90551,0.44882,0.91339,0.44882,0.92126,0.44882,0.92913,0.44882,0.93701,0.44882,0.94488,0.44882,0.95276,0.44882,0.96063,0.44882,0.9685,0.44882,0.97638,0.44882,0.98425,0.44882,0.99213,0.44882,0.99609,0.44882,0.00391,0.45669,0.00787,0.45669,0.01575,0.45669,0.02362,0.45669,0.0315,0.45669,0.03937,0.45669,0.04724,0.45669,0.05512,0.45669,0.06299,0.45669,0.07087,0.45669,0.07874,0.45669,0.08661,0.45669,0.09449,0.45669,0.10236,0.45669,0.11024,0.45669,0.11811,0.45669,0.12598,0.45669,0.13386,0.45669,0.14173,0.45669,0.14961,0.45669,0.15748,0.45669,0.16535,0.45669,0.17323,0.45669,0.1811,0.45669,0.18898,0.45669,0.19685,0.45669,0.20472,0.45669,0.2126,0.45669,0.22047,0.45669,0.22835,0.45669,0.23622,0.45669,0.24409,0.45669,0.25197,0.45669,0.25984,0.45669,0.26772,0.45669,0.27559,0.45669,0.28346,0.45669,0.29134,0.45669,0.29921,0.45669,0.30709,0.45669,0.31496,0.45669,0.32283,0.45669,0.33071,0.45669,0.33858,0.45669,0.34646,0.45669,0.35433,0.45669,0.3622,0.45669,0.37008,0.45669,0.37795,0.45669,0.38583,0.45669,0.3937,0.45669,0.40157,0.45669,0.40945,0.45669,0.41732,0.45669,0.4252,0.45669,0.43307,0.45669,0.44094,0.45669,0.44882,0.45669,0.45669,0.45669,0.46457,0.45669,0.47244,0.45669,0.48031,0.45669,0.48819,0.45669,0.49606,0.45669,0.50394,0.45669,0.51181,0.45669,0.51969,0.45669,0.52756,0.45669,0.53543,0.45669,0.54331,0.45669,0.55118,0.45669,0.55906,0.45669,0.56693,0.45669,0.5748,0.45669,0.58268,0.45669,0.59055,0.45669};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_76()
		{
			double[] value = {0.59843,0.45669,0.6063,0.45669,0.61417,0.45669,0.62205,0.45669,0.62992,0.45669,0.6378,0.45669,0.64567,0.45669,0.65354,0.45669,0.66142,0.45669,0.66929,0.45669,0.67717,0.45669,0.68504,0.45669,0.69291,0.45669,0.70079,0.45669,0.70866,0.45669,0.71654,0.45669,0.72441,0.45669,0.73228,0.45669,0.74016,0.45669,0.74803,0.45669,0.75591,0.45669,0.76378,0.45669,0.77165,0.45669,0.77953,0.45669,0.7874,0.45669,0.79528,0.45669,0.80315,0.45669,0.81102,0.45669,0.8189,0.45669,0.82677,0.45669,0.83465,0.45669,0.84252,0.45669,0.85039,0.45669,0.85827,0.45669,0.86614,0.45669,0.87402,0.45669,0.88189,0.45669,0.88976,0.45669,0.89764,0.45669,0.90551,0.45669,0.91339,0.45669,0.92126,0.45669,0.92913,0.45669,0.93701,0.45669,0.94488,0.45669,0.95276,0.45669,0.96063,0.45669,0.9685,0.45669,0.97638,0.45669,0.98425,0.45669,0.99213,0.45669,0.99609,0.45669,0.00391,0.46457,0.00787,0.46457,0.01575,0.46457,0.02362,0.46457,0.0315,0.46457,0.03937,0.46457,0.04724,0.46457,0.05512,0.46457,0.06299,0.46457,0.07087,0.46457,0.07874,0.46457,0.08661,0.46457,0.09449,0.46457,0.10236,0.46457,0.11024,0.46457,0.11811,0.46457,0.12598,0.46457,0.13386,0.46457,0.14173,0.46457,0.14961,0.46457,0.15748,0.46457,0.16535,0.46457,0.17323,0.46457,0.1811,0.46457,0.18898,0.46457,0.19685,0.46457,0.20472,0.46457,0.2126,0.46457,0.22047,0.46457,0.22835,0.46457,0.23622,0.46457,0.24409,0.46457,0.25197,0.46457,0.25984,0.46457,0.26772,0.46457,0.27559,0.46457,0.28346,0.46457,0.29134,0.46457,0.29921,0.46457,0.30709,0.46457,0.31496,0.46457,0.32283,0.46457,0.33071,0.46457,0.33858,0.46457,0.34646,0.46457,0.35433,0.46457,0.3622,0.46457,0.37008,0.46457};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_77()
		{
			double[] value = {0.37795,0.46457,0.38583,0.46457,0.3937,0.46457,0.40157,0.46457,0.40945,0.46457,0.41732,0.46457,0.4252,0.46457,0.43307,0.46457,0.44094,0.46457,0.44882,0.46457,0.45669,0.46457,0.46457,0.46457,0.47244,0.46457,0.48031,0.46457,0.48819,0.46457,0.49606,0.46457,0.50394,0.46457,0.51181,0.46457,0.51969,0.46457,0.52756,0.46457,0.53543,0.46457,0.54331,0.46457,0.55118,0.46457,0.55906,0.46457,0.56693,0.46457,0.5748,0.46457,0.58268,0.46457,0.59055,0.46457,0.59843,0.46457,0.6063,0.46457,0.61417,0.46457,0.62205,0.46457,0.62992,0.46457,0.6378,0.46457,0.64567,0.46457,0.65354,0.46457,0.66142,0.46457,0.66929,0.46457,0.67717,0.46457,0.68504,0.46457,0.69291,0.46457,0.70079,0.46457,0.70866,0.46457,0.71654,0.46457,0.72441,0.46457,0.73228,0.46457,0.74016,0.46457,0.74803,0.46457,0.75591,0.46457,0.76378,0.46457,0.77165,0.46457,0.77953,0.46457,0.7874,0.46457,0.79528,0.46457,0.80315,0.46457,0.81102,0.46457,0.8189,0.46457,0.82677,0.46457,0.83465,0.46457,0.84252,0.46457,0.85039,0.46457,0.85827,0.46457,0.86614,0.46457,0.87402,0.46457,0.88189,0.46457,0.88976,0.46457,0.89764,0.46457,0.90551,0.46457,0.91339,0.46457,0.92126,0.46457,0.92913,0.46457,0.93701,0.46457,0.94488,0.46457,0.95276,0.46457,0.96063,0.46457,0.9685,0.46457,0.97638,0.46457,0.98425,0.46457,0.99213,0.46457,0.99609,0.46457,0.00391,0.47244,0.00787,0.47244,0.01575,0.47244,0.02362,0.47244,0.0315,0.47244,0.03937,0.47244,0.04724,0.47244,0.05512,0.47244,0.06299,0.47244,0.07087,0.47244,0.07874,0.47244,0.08661,0.47244,0.09449,0.47244,0.10236,0.47244,0.11024,0.47244,0.11811,0.47244,0.12598,0.47244,0.13386,0.47244,0.14173,0.47244,0.14961,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_78()
		{
			double[] value = {0.15748,0.47244,0.16535,0.47244,0.17323,0.47244,0.1811,0.47244,0.18898,0.47244,0.19685,0.47244,0.20472,0.47244,0.2126,0.47244,0.22047,0.47244,0.22835,0.47244,0.23622,0.47244,0.24409,0.47244,0.25197,0.47244,0.25984,0.47244,0.26772,0.47244,0.27559,0.47244,0.28346,0.47244,0.29134,0.47244,0.29921,0.47244,0.30709,0.47244,0.31496,0.47244,0.32283,0.47244,0.33071,0.47244,0.33858,0.47244,0.34646,0.47244,0.35433,0.47244,0.3622,0.47244,0.37008,0.47244,0.37795,0.47244,0.38583,0.47244,0.3937,0.47244,0.40157,0.47244,0.40945,0.47244,0.41732,0.47244,0.4252,0.47244,0.43307,0.47244,0.44094,0.47244,0.44882,0.47244,0.45669,0.47244,0.46457,0.47244,0.47244,0.47244,0.48031,0.47244,0.48819,0.47244,0.49606,0.47244,0.50394,0.47244,0.51181,0.47244,0.51969,0.47244,0.52756,0.47244,0.53543,0.47244,0.54331,0.47244,0.55118,0.47244,0.55906,0.47244,0.56693,0.47244,0.5748,0.47244,0.58268,0.47244,0.59055,0.47244,0.59843,0.47244,0.6063,0.47244,0.61417,0.47244,0.62205,0.47244,0.62992,0.47244,0.6378,0.47244,0.64567,0.47244,0.65354,0.47244,0.66142,0.47244,0.66929,0.47244,0.67717,0.47244,0.68504,0.47244,0.69291,0.47244,0.70079,0.47244,0.70866,0.47244,0.71654,0.47244,0.72441,0.47244,0.73228,0.47244,0.74016,0.47244,0.74803,0.47244,0.75591,0.47244,0.76378,0.47244,0.77165,0.47244,0.77953,0.47244,0.7874,0.47244,0.79528,0.47244,0.80315,0.47244,0.81102,0.47244,0.8189,0.47244,0.82677,0.47244,0.83465,0.47244,0.84252,0.47244,0.85039,0.47244,0.85827,0.47244,0.86614,0.47244,0.87402,0.47244,0.88189,0.47244,0.88976,0.47244,0.89764,0.47244,0.90551,0.47244,0.91339,0.47244,0.92126,0.47244,0.92913,0.47244,0.93701,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_79()
		{
			double[] value = {0.94488,0.47244,0.95276,0.47244,0.96063,0.47244,0.9685,0.47244,0.97638,0.47244,0.98425,0.47244,0.99213,0.47244,0.99609,0.47244,0.00391,0.48031,0.00787,0.48031,0.01575,0.48031,0.02362,0.48031,0.0315,0.48031,0.03937,0.48031,0.04724,0.48031,0.05512,0.48031,0.06299,0.48031,0.07087,0.48031,0.07874,0.48031,0.08661,0.48031,0.09449,0.48031,0.10236,0.48031,0.11024,0.48031,0.11811,0.48031,0.12598,0.48031,0.13386,0.48031,0.14173,0.48031,0.14961,0.48031,0.15748,0.48031,0.16535,0.48031,0.17323,0.48031,0.1811,0.48031,0.18898,0.48031,0.19685,0.48031,0.20472,0.48031,0.2126,0.48031,0.22047,0.48031,0.22835,0.48031,0.23622,0.48031,0.24409,0.48031,0.25197,0.48031,0.25984,0.48031,0.26772,0.48031,0.27559,0.48031,0.28346,0.48031,0.29134,0.48031,0.29921,0.48031,0.30709,0.48031,0.31496,0.48031,0.32283,0.48031,0.33071,0.48031,0.33858,0.48031,0.34646,0.48031,0.35433,0.48031,0.3622,0.48031,0.37008,0.48031,0.37795,0.48031,0.38583,0.48031,0.3937,0.48031,0.40157,0.48031,0.40945,0.48031,0.41732,0.48031,0.4252,0.48031,0.43307,0.48031,0.44094,0.48031,0.44882,0.48031,0.45669,0.48031,0.46457,0.48031,0.47244,0.48031,0.48031,0.48031,0.48819,0.48031,0.49606,0.48031,0.50394,0.48031,0.51181,0.48031,0.51969,0.48031,0.52756,0.48031,0.53543,0.48031,0.54331,0.48031,0.55118,0.48031,0.55906,0.48031,0.56693,0.48031,0.5748,0.48031,0.58268,0.48031,0.59055,0.48031,0.59843,0.48031,0.6063,0.48031,0.61417,0.48031,0.62205,0.48031,0.62992,0.48031,0.6378,0.48031,0.64567,0.48031,0.65354,0.48031,0.66142,0.48031,0.66929,0.48031,0.67717,0.48031,0.68504,0.48031,0.69291,0.48031,0.70079,0.48031,0.70866,0.48031,0.71654,0.48031};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_80()
		{
			double[] value = {0.72441,0.48031,0.73228,0.48031,0.74016,0.48031,0.74803,0.48031,0.75591,0.48031,0.76378,0.48031,0.77165,0.48031,0.77953,0.48031,0.7874,0.48031,0.79528,0.48031,0.80315,0.48031,0.81102,0.48031,0.8189,0.48031,0.82677,0.48031,0.83465,0.48031,0.84252,0.48031,0.85039,0.48031,0.85827,0.48031,0.86614,0.48031,0.87402,0.48031,0.88189,0.48031,0.88976,0.48031,0.89764,0.48031,0.90551,0.48031,0.91339,0.48031,0.92126,0.48031,0.92913,0.48031,0.93701,0.48031,0.94488,0.48031,0.95276,0.48031,0.96063,0.48031,0.9685,0.48031,0.97638,0.48031,0.98425,0.48031,0.99213,0.48031,0.99609,0.48031,0.00391,0.48819,0.00787,0.48819,0.01575,0.48819,0.02362,0.48819,0.0315,0.48819,0.03937,0.48819,0.04724,0.48819,0.05512,0.48819,0.06299,0.48819,0.07087,0.48819,0.07874,0.48819,0.08661,0.48819,0.09449,0.48819,0.10236,0.48819,0.11024,0.48819,0.11811,0.48819,0.12598,0.48819,0.13386,0.48819,0.14173,0.48819,0.14961,0.48819,0.15748,0.48819,0.16535,0.48819,0.17323,0.48819,0.1811,0.48819,0.18898,0.48819,0.19685,0.48819,0.20472,0.48819,0.2126,0.48819,0.22047,0.48819,0.22835,0.48819,0.23622,0.48819,0.24409,0.48819,0.25197,0.48819,0.25984,0.48819,0.26772,0.48819,0.27559,0.48819,0.28346,0.48819,0.29134,0.48819,0.29921,0.48819,0.30709,0.48819,0.31496,0.48819,0.32283,0.48819,0.33071,0.48819,0.33858,0.48819,0.34646,0.48819,0.35433,0.48819,0.3622,0.48819,0.37008,0.48819,0.37795,0.48819,0.38583,0.48819,0.3937,0.48819,0.40157,0.48819,0.40945,0.48819,0.41732,0.48819,0.4252,0.48819,0.43307,0.48819,0.44094,0.48819,0.44882,0.48819,0.45669,0.48819,0.46457,0.48819,0.47244,0.48819,0.48031,0.48819,0.48819,0.48819,0.49606,0.48819};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_81()
		{
			double[] value = {0.50394,0.48819,0.51181,0.48819,0.51969,0.48819,0.52756,0.48819,0.53543,0.48819,0.54331,0.48819,0.55118,0.48819,0.55906,0.48819,0.56693,0.48819,0.5748,0.48819,0.58268,0.48819,0.59055,0.48819,0.59843,0.48819,0.6063,0.48819,0.61417,0.48819,0.62205,0.48819,0.62992,0.48819,0.6378,0.48819,0.64567,0.48819,0.65354,0.48819,0.66142,0.48819,0.66929,0.48819,0.67717,0.48819,0.68504,0.48819,0.69291,0.48819,0.70079,0.48819,0.70866,0.48819,0.71654,0.48819,0.72441,0.48819,0.73228,0.48819,0.74016,0.48819,0.74803,0.48819,0.75591,0.48819,0.76378,0.48819,0.77165,0.48819,0.77953,0.48819,0.7874,0.48819,0.79528,0.48819,0.80315,0.48819,0.81102,0.48819,0.8189,0.48819,0.82677,0.48819,0.83465,0.48819,0.84252,0.48819,0.85039,0.48819,0.85827,0.48819,0.86614,0.48819,0.87402,0.48819,0.88189,0.48819,0.88976,0.48819,0.89764,0.48819,0.90551,0.48819,0.91339,0.48819,0.92126,0.48819,0.92913,0.48819,0.93701,0.48819,0.94488,0.48819,0.95276,0.48819,0.96063,0.48819,0.9685,0.48819,0.97638,0.48819,0.98425,0.48819,0.99213,0.48819,0.99609,0.48819,0.00391,0.49606,0.00787,0.49606,0.01575,0.49606,0.02362,0.49606,0.0315,0.49606,0.03937,0.49606,0.04724,0.49606,0.05512,0.49606,0.06299,0.49606,0.07087,0.49606,0.07874,0.49606,0.08661,0.49606,0.09449,0.49606,0.10236,0.49606,0.11024,0.49606,0.11811,0.49606,0.12598,0.49606,0.13386,0.49606,0.14173,0.49606,0.14961,0.49606,0.15748,0.49606,0.16535,0.49606,0.17323,0.49606,0.1811,0.49606,0.18898,0.49606,0.19685,0.49606,0.20472,0.49606,0.2126,0.49606,0.22047,0.49606,0.22835,0.49606,0.23622,0.49606,0.24409,0.49606,0.25197,0.49606,0.25984,0.49606,0.26772,0.49606,0.27559,0.49606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_82()
		{
			double[] value = {0.28346,0.49606,0.29134,0.49606,0.29921,0.49606,0.30709,0.49606,0.31496,0.49606,0.32283,0.49606,0.33071,0.49606,0.33858,0.49606,0.34646,0.49606,0.35433,0.49606,0.3622,0.49606,0.37008,0.49606,0.37795,0.49606,0.38583,0.49606,0.3937,0.49606,0.40157,0.49606,0.40945,0.49606,0.41732,0.49606,0.4252,0.49606,0.43307,0.49606,0.44094,0.49606,0.44882,0.49606,0.45669,0.49606,0.46457,0.49606,0.47244,0.49606,0.48031,0.49606,0.48819,0.49606,0.49606,0.49606,0.50394,0.49606,0.51181,0.49606,0.51969,0.49606,0.52756,0.49606,0.53543,0.49606,0.54331,0.49606,0.55118,0.49606,0.55906,0.49606,0.56693,0.49606,0.5748,0.49606,0.58268,0.49606,0.59055,0.49606,0.59843,0.49606,0.6063,0.49606,0.61417,0.49606,0.62205,0.49606,0.62992,0.49606,0.6378,0.49606,0.64567,0.49606,0.65354,0.49606,0.66142,0.49606,0.66929,0.49606,0.67717,0.49606,0.68504,0.49606,0.69291,0.49606,0.70079,0.49606,0.70866,0.49606,0.71654,0.49606,0.72441,0.49606,0.73228,0.49606,0.74016,0.49606,0.74803,0.49606,0.75591,0.49606,0.76378,0.49606,0.77165,0.49606,0.77953,0.49606,0.7874,0.49606,0.79528,0.49606,0.80315,0.49606,0.81102,0.49606,0.8189,0.49606,0.82677,0.49606,0.83465,0.49606,0.84252,0.49606,0.85039,0.49606,0.85827,0.49606,0.86614,0.49606,0.87402,0.49606,0.88189,0.49606,0.88976,0.49606,0.89764,0.49606,0.90551,0.49606,0.91339,0.49606,0.92126,0.49606,0.92913,0.49606,0.93701,0.49606,0.94488,0.49606,0.95276,0.49606,0.96063,0.49606,0.9685,0.49606,0.97638,0.49606,0.98425,0.49606,0.99213,0.49606,0.99609,0.49606,0.00391,0.50394,0.00787,0.50394,0.01575,0.50394,0.02362,0.50394,0.0315,0.50394,0.03937,0.50394,0.04724,0.50394,0.05512,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_83()
		{
			double[] value = {0.06299,0.50394,0.07087,0.50394,0.07874,0.50394,0.08661,0.50394,0.09449,0.50394,0.10236,0.50394,0.11024,0.50394,0.11811,0.50394,0.12598,0.50394,0.13386,0.50394,0.14173,0.50394,0.14961,0.50394,0.15748,0.50394,0.16535,0.50394,0.17323,0.50394,0.1811,0.50394,0.18898,0.50394,0.19685,0.50394,0.20472,0.50394,0.2126,0.50394,0.22047,0.50394,0.22835,0.50394,0.23622,0.50394,0.24409,0.50394,0.25197,0.50394,0.25984,0.50394,0.26772,0.50394,0.27559,0.50394,0.28346,0.50394,0.29134,0.50394,0.29921,0.50394,0.30709,0.50394,0.31496,0.50394,0.32283,0.50394,0.33071,0.50394,0.33858,0.50394,0.34646,0.50394,0.35433,0.50394,0.3622,0.50394,0.37008,0.50394,0.37795,0.50394,0.38583,0.50394,0.3937,0.50394,0.40157,0.50394,0.40945,0.50394,0.41732,0.50394,0.4252,0.50394,0.43307,0.50394,0.44094,0.50394,0.44882,0.50394,0.45669,0.50394,0.46457,0.50394,0.47244,0.50394,0.48031,0.50394,0.48819,0.50394,0.49606,0.50394,0.50394,0.50394,0.51181,0.50394,0.51969,0.50394,0.52756,0.50394,0.53543,0.50394,0.54331,0.50394,0.55118,0.50394,0.55906,0.50394,0.56693,0.50394,0.5748,0.50394,0.58268,0.50394,0.59055,0.50394,0.59843,0.50394,0.6063,0.50394,0.61417,0.50394,0.62205,0.50394,0.62992,0.50394,0.6378,0.50394,0.64567,0.50394,0.65354,0.50394,0.66142,0.50394,0.66929,0.50394,0.67717,0.50394,0.68504,0.50394,0.69291,0.50394,0.70079,0.50394,0.70866,0.50394,0.71654,0.50394,0.72441,0.50394,0.73228,0.50394,0.74016,0.50394,0.74803,0.50394,0.75591,0.50394,0.76378,0.50394,0.77165,0.50394,0.77953,0.50394,0.7874,0.50394,0.79528,0.50394,0.80315,0.50394,0.81102,0.50394,0.8189,0.50394,0.82677,0.50394,0.83465,0.50394,0.84252,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_84()
		{
			double[] value = {0.85039,0.50394,0.85827,0.50394,0.86614,0.50394,0.87402,0.50394,0.88189,0.50394,0.88976,0.50394,0.89764,0.50394,0.90551,0.50394,0.91339,0.50394,0.92126,0.50394,0.92913,0.50394,0.93701,0.50394,0.94488,0.50394,0.95276,0.50394,0.96063,0.50394,0.9685,0.50394,0.97638,0.50394,0.98425,0.50394,0.99213,0.50394,0.99609,0.50394,0.00391,0.51181,0.00787,0.51181,0.01575,0.51181,0.02362,0.51181,0.0315,0.51181,0.03937,0.51181,0.04724,0.51181,0.05512,0.51181,0.06299,0.51181,0.07087,0.51181,0.07874,0.51181,0.08661,0.51181,0.09449,0.51181,0.10236,0.51181,0.11024,0.51181,0.11811,0.51181,0.12598,0.51181,0.13386,0.51181,0.14173,0.51181,0.14961,0.51181,0.15748,0.51181,0.16535,0.51181,0.17323,0.51181,0.1811,0.51181,0.18898,0.51181,0.19685,0.51181,0.20472,0.51181,0.2126,0.51181,0.22047,0.51181,0.22835,0.51181,0.23622,0.51181,0.24409,0.51181,0.25197,0.51181,0.25984,0.51181,0.26772,0.51181,0.27559,0.51181,0.28346,0.51181,0.29134,0.51181,0.29921,0.51181,0.30709,0.51181,0.31496,0.51181,0.32283,0.51181,0.33071,0.51181,0.33858,0.51181,0.34646,0.51181,0.35433,0.51181,0.3622,0.51181,0.37008,0.51181,0.37795,0.51181,0.38583,0.51181,0.3937,0.51181,0.40157,0.51181,0.40945,0.51181,0.41732,0.51181,0.4252,0.51181,0.43307,0.51181,0.44094,0.51181,0.44882,0.51181,0.45669,0.51181,0.46457,0.51181,0.47244,0.51181,0.48031,0.51181,0.48819,0.51181,0.49606,0.51181,0.50394,0.51181,0.51181,0.51181,0.51969,0.51181,0.52756,0.51181,0.53543,0.51181,0.54331,0.51181,0.55118,0.51181,0.55906,0.51181,0.56693,0.51181,0.5748,0.51181,0.58268,0.51181,0.59055,0.51181,0.59843,0.51181,0.6063,0.51181,0.61417,0.51181,0.62205,0.51181};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_85()
		{
			double[] value = {0.62992,0.51181,0.6378,0.51181,0.64567,0.51181,0.65354,0.51181,0.66142,0.51181,0.66929,0.51181,0.67717,0.51181,0.68504,0.51181,0.69291,0.51181,0.70079,0.51181,0.70866,0.51181,0.71654,0.51181,0.72441,0.51181,0.73228,0.51181,0.74016,0.51181,0.74803,0.51181,0.75591,0.51181,0.76378,0.51181,0.77165,0.51181,0.77953,0.51181,0.7874,0.51181,0.79528,0.51181,0.80315,0.51181,0.81102,0.51181,0.8189,0.51181,0.82677,0.51181,0.83465,0.51181,0.84252,0.51181,0.85039,0.51181,0.85827,0.51181,0.86614,0.51181,0.87402,0.51181,0.88189,0.51181,0.88976,0.51181,0.89764,0.51181,0.90551,0.51181,0.91339,0.51181,0.92126,0.51181,0.92913,0.51181,0.93701,0.51181,0.94488,0.51181,0.95276,0.51181,0.96063,0.51181,0.9685,0.51181,0.97638,0.51181,0.98425,0.51181,0.99213,0.51181,0.99609,0.51181,0.00391,0.51969,0.00787,0.51969,0.01575,0.51969,0.02362,0.51969,0.0315,0.51969,0.03937,0.51969,0.04724,0.51969,0.05512,0.51969,0.06299,0.51969,0.07087,0.51969,0.07874,0.51969,0.08661,0.51969,0.09449,0.51969,0.10236,0.51969,0.11024,0.51969,0.11811,0.51969,0.12598,0.51969,0.13386,0.51969,0.14173,0.51969,0.14961,0.51969,0.15748,0.51969,0.16535,0.51969,0.17323,0.51969,0.1811,0.51969,0.18898,0.51969,0.19685,0.51969,0.20472,0.51969,0.2126,0.51969,0.22047,0.51969,0.22835,0.51969,0.23622,0.51969,0.24409,0.51969,0.25197,0.51969,0.25984,0.51969,0.26772,0.51969,0.27559,0.51969,0.28346,0.51969,0.29134,0.51969,0.29921,0.51969,0.30709,0.51969,0.31496,0.51969,0.32283,0.51969,0.33071,0.51969,0.33858,0.51969,0.34646,0.51969,0.35433,0.51969,0.3622,0.51969,0.37008,0.51969,0.37795,0.51969,0.38583,0.51969,0.3937,0.51969,0.40157,0.51969};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_86()
		{
			double[] value = {0.40945,0.51969,0.41732,0.51969,0.4252,0.51969,0.43307,0.51969,0.44094,0.51969,0.44882,0.51969,0.45669,0.51969,0.46457,0.51969,0.47244,0.51969,0.48031,0.51969,0.48819,0.51969,0.49606,0.51969,0.50394,0.51969,0.51181,0.51969,0.51969,0.51969,0.52756,0.51969,0.53543,0.51969,0.54331,0.51969,0.55118,0.51969,0.55906,0.51969,0.56693,0.51969,0.5748,0.51969,0.58268,0.51969,0.59055,0.51969,0.59843,0.51969,0.6063,0.51969,0.61417,0.51969,0.62205,0.51969,0.62992,0.51969,0.6378,0.51969,0.64567,0.51969,0.65354,0.51969,0.66142,0.51969,0.66929,0.51969,0.67717,0.51969,0.68504,0.51969,0.69291,0.51969,0.70079,0.51969,0.70866,0.51969,0.71654,0.51969,0.72441,0.51969,0.73228,0.51969,0.74016,0.51969,0.74803,0.51969,0.75591,0.51969,0.76378,0.51969,0.77165,0.51969,0.77953,0.51969,0.7874,0.51969,0.79528,0.51969,0.80315,0.51969,0.81102,0.51969,0.8189,0.51969,0.82677,0.51969,0.83465,0.51969,0.84252,0.51969,0.85039,0.51969,0.85827,0.51969,0.86614,0.51969,0.87402,0.51969,0.88189,0.51969,0.88976,0.51969,0.89764,0.51969,0.90551,0.51969,0.91339,0.51969,0.92126,0.51969,0.92913,0.51969,0.93701,0.51969,0.94488,0.51969,0.95276,0.51969,0.96063,0.51969,0.9685,0.51969,0.97638,0.51969,0.98425,0.51969,0.99213,0.51969,0.99609,0.51969,0.00391,0.52756,0.00787,0.52756,0.01575,0.52756,0.02362,0.52756,0.0315,0.52756,0.03937,0.52756,0.04724,0.52756,0.05512,0.52756,0.06299,0.52756,0.07087,0.52756,0.07874,0.52756,0.08661,0.52756,0.09449,0.52756,0.10236,0.52756,0.11024,0.52756,0.11811,0.52756,0.12598,0.52756,0.13386,0.52756,0.14173,0.52756,0.14961,0.52756,0.15748,0.52756,0.16535,0.52756,0.17323,0.52756,0.1811,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_87()
		{
			double[] value = {0.18898,0.52756,0.19685,0.52756,0.20472,0.52756,0.2126,0.52756,0.22047,0.52756,0.22835,0.52756,0.23622,0.52756,0.24409,0.52756,0.25197,0.52756,0.25984,0.52756,0.26772,0.52756,0.27559,0.52756,0.28346,0.52756,0.29134,0.52756,0.29921,0.52756,0.30709,0.52756,0.31496,0.52756,0.32283,0.52756,0.33071,0.52756,0.33858,0.52756,0.34646,0.52756,0.35433,0.52756,0.3622,0.52756,0.37008,0.52756,0.37795,0.52756,0.38583,0.52756,0.3937,0.52756,0.40157,0.52756,0.40945,0.52756,0.41732,0.52756,0.4252,0.52756,0.43307,0.52756,0.44094,0.52756,0.44882,0.52756,0.45669,0.52756,0.46457,0.52756,0.47244,0.52756,0.48031,0.52756,0.48819,0.52756,0.49606,0.52756,0.50394,0.52756,0.51181,0.52756,0.51969,0.52756,0.52756,0.52756,0.53543,0.52756,0.54331,0.52756,0.55118,0.52756,0.55906,0.52756,0.56693,0.52756,0.5748,0.52756,0.58268,0.52756,0.59055,0.52756,0.59843,0.52756,0.6063,0.52756,0.61417,0.52756,0.62205,0.52756,0.62992,0.52756,0.6378,0.52756,0.64567,0.52756,0.65354,0.52756,0.66142,0.52756,0.66929,0.52756,0.67717,0.52756,0.68504,0.52756,0.69291,0.52756,0.70079,0.52756,0.70866,0.52756,0.71654,0.52756,0.72441,0.52756,0.73228,0.52756,0.74016,0.52756,0.74803,0.52756,0.75591,0.52756,0.76378,0.52756,0.77165,0.52756,0.77953,0.52756,0.7874,0.52756,0.79528,0.52756,0.80315,0.52756,0.81102,0.52756,0.8189,0.52756,0.82677,0.52756,0.83465,0.52756,0.84252,0.52756,0.85039,0.52756,0.85827,0.52756,0.86614,0.52756,0.87402,0.52756,0.88189,0.52756,0.88976,0.52756,0.89764,0.52756,0.90551,0.52756,0.91339,0.52756,0.92126,0.52756,0.92913,0.52756,0.93701,0.52756,0.94488,0.52756,0.95276,0.52756,0.96063,0.52756,0.9685,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_88()
		{
			double[] value = {0.97638,0.52756,0.98425,0.52756,0.99213,0.52756,0.99609,0.52756,0.00391,0.53543,0.00787,0.53543,0.01575,0.53543,0.02362,0.53543,0.0315,0.53543,0.03937,0.53543,0.04724,0.53543,0.05512,0.53543,0.06299,0.53543,0.07087,0.53543,0.07874,0.53543,0.08661,0.53543,0.09449,0.53543,0.10236,0.53543,0.11024,0.53543,0.11811,0.53543,0.12598,0.53543,0.13386,0.53543,0.14173,0.53543,0.14961,0.53543,0.15748,0.53543,0.16535,0.53543,0.17323,0.53543,0.1811,0.53543,0.18898,0.53543,0.19685,0.53543,0.20472,0.53543,0.2126,0.53543,0.22047,0.53543,0.22835,0.53543,0.23622,0.53543,0.24409,0.53543,0.25197,0.53543,0.25984,0.53543,0.26772,0.53543,0.27559,0.53543,0.28346,0.53543,0.29134,0.53543,0.29921,0.53543,0.30709,0.53543,0.31496,0.53543,0.32283,0.53543,0.33071,0.53543,0.33858,0.53543,0.34646,0.53543,0.35433,0.53543,0.3622,0.53543,0.37008,0.53543,0.37795,0.53543,0.38583,0.53543,0.3937,0.53543,0.40157,0.53543,0.40945,0.53543,0.41732,0.53543,0.4252,0.53543,0.43307,0.53543,0.44094,0.53543,0.44882,0.53543,0.45669,0.53543,0.46457,0.53543,0.47244,0.53543,0.48031,0.53543,0.48819,0.53543,0.49606,0.53543,0.50394,0.53543,0.51181,0.53543,0.51969,0.53543,0.52756,0.53543,0.53543,0.53543,0.54331,0.53543,0.55118,0.53543,0.55906,0.53543,0.56693,0.53543,0.5748,0.53543,0.58268,0.53543,0.59055,0.53543,0.59843,0.53543,0.6063,0.53543,0.61417,0.53543,0.62205,0.53543,0.62992,0.53543,0.6378,0.53543,0.64567,0.53543,0.65354,0.53543,0.66142,0.53543,0.66929,0.53543,0.67717,0.53543,0.68504,0.53543,0.69291,0.53543,0.70079,0.53543,0.70866,0.53543,0.71654,0.53543,0.72441,0.53543,0.73228,0.53543,0.74016,0.53543,0.74803,0.53543};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_89()
		{
			double[] value = {0.75591,0.53543,0.76378,0.53543,0.77165,0.53543,0.77953,0.53543,0.7874,0.53543,0.79528,0.53543,0.80315,0.53543,0.81102,0.53543,0.8189,0.53543,0.82677,0.53543,0.83465,0.53543,0.84252,0.53543,0.85039,0.53543,0.85827,0.53543,0.86614,0.53543,0.87402,0.53543,0.88189,0.53543,0.88976,0.53543,0.89764,0.53543,0.90551,0.53543,0.91339,0.53543,0.92126,0.53543,0.92913,0.53543,0.93701,0.53543,0.94488,0.53543,0.95276,0.53543,0.96063,0.53543,0.9685,0.53543,0.97638,0.53543,0.98425,0.53543,0.99213,0.53543,0.99609,0.53543,0.00391,0.54331,0.00787,0.54331,0.01575,0.54331,0.02362,0.54331,0.0315,0.54331,0.03937,0.54331,0.04724,0.54331,0.05512,0.54331,0.06299,0.54331,0.07087,0.54331,0.07874,0.54331,0.08661,0.54331,0.09449,0.54331,0.10236,0.54331,0.11024,0.54331,0.11811,0.54331,0.12598,0.54331,0.13386,0.54331,0.14173,0.54331,0.14961,0.54331,0.15748,0.54331,0.16535,0.54331,0.17323,0.54331,0.1811,0.54331,0.18898,0.54331,0.19685,0.54331,0.20472,0.54331,0.2126,0.54331,0.22047,0.54331,0.22835,0.54331,0.23622,0.54331,0.24409,0.54331,0.25197,0.54331,0.25984,0.54331,0.26772,0.54331,0.27559,0.54331,0.28346,0.54331,0.29134,0.54331,0.29921,0.54331,0.30709,0.54331,0.31496,0.54331,0.32283,0.54331,0.33071,0.54331,0.33858,0.54331,0.34646,0.54331,0.35433,0.54331,0.3622,0.54331,0.37008,0.54331,0.37795,0.54331,0.38583,0.54331,0.3937,0.54331,0.40157,0.54331,0.40945,0.54331,0.41732,0.54331,0.4252,0.54331,0.43307,0.54331,0.44094,0.54331,0.44882,0.54331,0.45669,0.54331,0.46457,0.54331,0.47244,0.54331,0.48031,0.54331,0.48819,0.54331,0.49606,0.54331,0.50394,0.54331,0.51181,0.54331,0.51969,0.54331,0.52756,0.54331};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_90()
		{
			double[] value = {0.53543,0.54331,0.54331,0.54331,0.55118,0.54331,0.55906,0.54331,0.56693,0.54331,0.5748,0.54331,0.58268,0.54331,0.59055,0.54331,0.59843,0.54331,0.6063,0.54331,0.61417,0.54331,0.62205,0.54331,0.62992,0.54331,0.6378,0.54331,0.64567,0.54331,0.65354,0.54331,0.66142,0.54331,0.66929,0.54331,0.67717,0.54331,0.68504,0.54331,0.69291,0.54331,0.70079,0.54331,0.70866,0.54331,0.71654,0.54331,0.72441,0.54331,0.73228,0.54331,0.74016,0.54331,0.74803,0.54331,0.75591,0.54331,0.76378,0.54331,0.77165,0.54331,0.77953,0.54331,0.7874,0.54331,0.79528,0.54331,0.80315,0.54331,0.81102,0.54331,0.8189,0.54331,0.82677,0.54331,0.83465,0.54331,0.84252,0.54331,0.85039,0.54331,0.85827,0.54331,0.86614,0.54331,0.87402,0.54331,0.88189,0.54331,0.88976,0.54331,0.89764,0.54331,0.90551,0.54331,0.91339,0.54331,0.92126,0.54331,0.92913,0.54331,0.93701,0.54331,0.94488,0.54331,0.95276,0.54331,0.96063,0.54331,0.9685,0.54331,0.97638,0.54331,0.98425,0.54331,0.99213,0.54331,0.99609,0.54331,0.00391,0.55118,0.00787,0.55118,0.01575,0.55118,0.02362,0.55118,0.0315,0.55118,0.03937,0.55118,0.04724,0.55118,0.05512,0.55118,0.06299,0.55118,0.07087,0.55118,0.07874,0.55118,0.08661,0.55118,0.09449,0.55118,0.10236,0.55118,0.11024,0.55118,0.11811,0.55118,0.12598,0.55118,0.13386,0.55118,0.14173,0.55118,0.14961,0.55118,0.15748,0.55118,0.16535,0.55118,0.17323,0.55118,0.1811,0.55118,0.18898,0.55118,0.19685,0.55118,0.20472,0.55118,0.2126,0.55118,0.22047,0.55118,0.22835,0.55118,0.23622,0.55118,0.24409,0.55118,0.25197,0.55118,0.25984,0.55118,0.26772,0.55118,0.27559,0.55118,0.28346,0.55118,0.29134,0.55118,0.29921,0.55118,0.30709,0.55118};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_91()
		{
			double[] value = {0.31496,0.55118,0.32283,0.55118,0.33071,0.55118,0.33858,0.55118,0.34646,0.55118,0.35433,0.55118,0.3622,0.55118,0.37008,0.55118,0.37795,0.55118,0.38583,0.55118,0.3937,0.55118,0.40157,0.55118,0.40945,0.55118,0.41732,0.55118,0.4252,0.55118,0.43307,0.55118,0.44094,0.55118,0.44882,0.55118,0.45669,0.55118,0.46457,0.55118,0.47244,0.55118,0.48031,0.55118,0.48819,0.55118,0.49606,0.55118,0.50394,0.55118,0.51181,0.55118,0.51969,0.55118,0.52756,0.55118,0.53543,0.55118,0.54331,0.55118,0.55118,0.55118,0.55906,0.55118,0.56693,0.55118,0.5748,0.55118,0.58268,0.55118,0.59055,0.55118,0.59843,0.55118,0.6063,0.55118,0.61417,0.55118,0.62205,0.55118,0.62992,0.55118,0.6378,0.55118,0.64567,0.55118,0.65354,0.55118,0.66142,0.55118,0.66929,0.55118,0.67717,0.55118,0.68504,0.55118,0.69291,0.55118,0.70079,0.55118,0.70866,0.55118,0.71654,0.55118,0.72441,0.55118,0.73228,0.55118,0.74016,0.55118,0.74803,0.55118,0.75591,0.55118,0.76378,0.55118,0.77165,0.55118,0.77953,0.55118,0.7874,0.55118,0.79528,0.55118,0.80315,0.55118,0.81102,0.55118,0.8189,0.55118,0.82677,0.55118,0.83465,0.55118,0.84252,0.55118,0.85039,0.55118,0.85827,0.55118,0.86614,0.55118,0.87402,0.55118,0.88189,0.55118,0.88976,0.55118,0.89764,0.55118,0.90551,0.55118,0.91339,0.55118,0.92126,0.55118,0.92913,0.55118,0.93701,0.55118,0.94488,0.55118,0.95276,0.55118,0.96063,0.55118,0.9685,0.55118,0.97638,0.55118,0.98425,0.55118,0.99213,0.55118,0.99609,0.55118,0.00391,0.55906,0.00787,0.55906,0.01575,0.55906,0.02362,0.55906,0.0315,0.55906,0.03937,0.55906,0.04724,0.55906,0.05512,0.55906,0.06299,0.55906,0.07087,0.55906,0.07874,0.55906,0.08661,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_92()
		{
			double[] value = {0.09449,0.55906,0.10236,0.55906,0.11024,0.55906,0.11811,0.55906,0.12598,0.55906,0.13386,0.55906,0.14173,0.55906,0.14961,0.55906,0.15748,0.55906,0.16535,0.55906,0.17323,0.55906,0.1811,0.55906,0.18898,0.55906,0.19685,0.55906,0.20472,0.55906,0.2126,0.55906,0.22047,0.55906,0.22835,0.55906,0.23622,0.55906,0.24409,0.55906,0.25197,0.55906,0.25984,0.55906,0.26772,0.55906,0.27559,0.55906,0.28346,0.55906,0.29134,0.55906,0.29921,0.55906,0.30709,0.55906,0.31496,0.55906,0.32283,0.55906,0.33071,0.55906,0.33858,0.55906,0.34646,0.55906,0.35433,0.55906,0.3622,0.55906,0.37008,0.55906,0.37795,0.55906,0.38583,0.55906,0.3937,0.55906,0.40157,0.55906,0.40945,0.55906,0.41732,0.55906,0.4252,0.55906,0.43307,0.55906,0.44094,0.55906,0.44882,0.55906,0.45669,0.55906,0.46457,0.55906,0.47244,0.55906,0.48031,0.55906,0.48819,0.55906,0.49606,0.55906,0.50394,0.55906,0.51181,0.55906,0.51969,0.55906,0.52756,0.55906,0.53543,0.55906,0.54331,0.55906,0.55118,0.55906,0.55906,0.55906,0.56693,0.55906,0.5748,0.55906,0.58268,0.55906,0.59055,0.55906,0.59843,0.55906,0.6063,0.55906,0.61417,0.55906,0.62205,0.55906,0.62992,0.55906,0.6378,0.55906,0.64567,0.55906,0.65354,0.55906,0.66142,0.55906,0.66929,0.55906,0.67717,0.55906,0.68504,0.55906,0.69291,0.55906,0.70079,0.55906,0.70866,0.55906,0.71654,0.55906,0.72441,0.55906,0.73228,0.55906,0.74016,0.55906,0.74803,0.55906,0.75591,0.55906,0.76378,0.55906,0.77165,0.55906,0.77953,0.55906,0.7874,0.55906,0.79528,0.55906,0.80315,0.55906,0.81102,0.55906,0.8189,0.55906,0.82677,0.55906,0.83465,0.55906,0.84252,0.55906,0.85039,0.55906,0.85827,0.55906,0.86614,0.55906,0.87402,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_93()
		{
			double[] value = {0.88189,0.55906,0.88976,0.55906,0.89764,0.55906,0.90551,0.55906,0.91339,0.55906,0.92126,0.55906,0.92913,0.55906,0.93701,0.55906,0.94488,0.55906,0.95276,0.55906,0.96063,0.55906,0.9685,0.55906,0.97638,0.55906,0.98425,0.55906,0.99213,0.55906,0.99609,0.55906,0.00391,0.56693,0.00787,0.56693,0.01575,0.56693,0.02362,0.56693,0.0315,0.56693,0.03937,0.56693,0.04724,0.56693,0.05512,0.56693,0.06299,0.56693,0.07087,0.56693,0.07874,0.56693,0.08661,0.56693,0.09449,0.56693,0.10236,0.56693,0.11024,0.56693,0.11811,0.56693,0.12598,0.56693,0.13386,0.56693,0.14173,0.56693,0.14961,0.56693,0.15748,0.56693,0.16535,0.56693,0.17323,0.56693,0.1811,0.56693,0.18898,0.56693,0.19685,0.56693,0.20472,0.56693,0.2126,0.56693,0.22047,0.56693,0.22835,0.56693,0.23622,0.56693,0.24409,0.56693,0.25197,0.56693,0.25984,0.56693,0.26772,0.56693,0.27559,0.56693,0.28346,0.56693,0.29134,0.56693,0.29921,0.56693,0.30709,0.56693,0.31496,0.56693,0.32283,0.56693,0.33071,0.56693,0.33858,0.56693,0.34646,0.56693,0.35433,0.56693,0.3622,0.56693,0.37008,0.56693,0.37795,0.56693,0.38583,0.56693,0.3937,0.56693,0.40157,0.56693,0.40945,0.56693,0.41732,0.56693,0.4252,0.56693,0.43307,0.56693,0.44094,0.56693,0.44882,0.56693,0.45669,0.56693,0.46457,0.56693,0.47244,0.56693,0.48031,0.56693,0.48819,0.56693,0.49606,0.56693,0.50394,0.56693,0.51181,0.56693,0.51969,0.56693,0.52756,0.56693,0.53543,0.56693,0.54331,0.56693,0.55118,0.56693,0.55906,0.56693,0.56693,0.56693,0.5748,0.56693,0.58268,0.56693,0.59055,0.56693,0.59843,0.56693,0.6063,0.56693,0.61417,0.56693,0.62205,0.56693,0.62992,0.56693,0.6378,0.56693,0.64567,0.56693,0.65354,0.56693};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_94()
		{
			double[] value = {0.66142,0.56693,0.66929,0.56693,0.67717,0.56693,0.68504,0.56693,0.69291,0.56693,0.70079,0.56693,0.70866,0.56693,0.71654,0.56693,0.72441,0.56693,0.73228,0.56693,0.74016,0.56693,0.74803,0.56693,0.75591,0.56693,0.76378,0.56693,0.77165,0.56693,0.77953,0.56693,0.7874,0.56693,0.79528,0.56693,0.80315,0.56693,0.81102,0.56693,0.8189,0.56693,0.82677,0.56693,0.83465,0.56693,0.84252,0.56693,0.85039,0.56693,0.85827,0.56693,0.86614,0.56693,0.87402,0.56693,0.88189,0.56693,0.88976,0.56693,0.89764,0.56693,0.90551,0.56693,0.91339,0.56693,0.92126,0.56693,0.92913,0.56693,0.93701,0.56693,0.94488,0.56693,0.95276,0.56693,0.96063,0.56693,0.9685,0.56693,0.97638,0.56693,0.98425,0.56693,0.99213,0.56693,0.99609,0.56693,0.00391,0.5748,0.00787,0.5748,0.01575,0.5748,0.02362,0.5748,0.0315,0.5748,0.03937,0.5748,0.04724,0.5748,0.05512,0.5748,0.06299,0.5748,0.07087,0.5748,0.07874,0.5748,0.08661,0.5748,0.09449,0.5748,0.10236,0.5748,0.11024,0.5748,0.11811,0.5748,0.12598,0.5748,0.13386,0.5748,0.14173,0.5748,0.14961,0.5748,0.15748,0.5748,0.16535,0.5748,0.17323,0.5748,0.1811,0.5748,0.18898,0.5748,0.19685,0.5748,0.20472,0.5748,0.2126,0.5748,0.22047,0.5748,0.22835,0.5748,0.23622,0.5748,0.24409,0.5748,0.25197,0.5748,0.25984,0.5748,0.26772,0.5748,0.27559,0.5748,0.28346,0.5748,0.29134,0.5748,0.29921,0.5748,0.30709,0.5748,0.31496,0.5748,0.32283,0.5748,0.33071,0.5748,0.33858,0.5748,0.34646,0.5748,0.35433,0.5748,0.3622,0.5748,0.37008,0.5748,0.37795,0.5748,0.38583,0.5748,0.3937,0.5748,0.40157,0.5748,0.40945,0.5748,0.41732,0.5748,0.4252,0.5748,0.43307,0.5748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_95()
		{
			double[] value = {0.44094,0.5748,0.44882,0.5748,0.45669,0.5748,0.46457,0.5748,0.47244,0.5748,0.48031,0.5748,0.48819,0.5748,0.49606,0.5748,0.50394,0.5748,0.51181,0.5748,0.51969,0.5748,0.52756,0.5748,0.53543,0.5748,0.54331,0.5748,0.55118,0.5748,0.55906,0.5748,0.56693,0.5748,0.5748,0.5748,0.58268,0.5748,0.59055,0.5748,0.59843,0.5748,0.6063,0.5748,0.61417,0.5748,0.62205,0.5748,0.62992,0.5748,0.6378,0.5748,0.64567,0.5748,0.65354,0.5748,0.66142,0.5748,0.66929,0.5748,0.67717,0.5748,0.68504,0.5748,0.69291,0.5748,0.70079,0.5748,0.70866,0.5748,0.71654,0.5748,0.72441,0.5748,0.73228,0.5748,0.74016,0.5748,0.74803,0.5748,0.75591,0.5748,0.76378,0.5748,0.77165,0.5748,0.77953,0.5748,0.7874,0.5748,0.79528,0.5748,0.80315,0.5748,0.81102,0.5748,0.8189,0.5748,0.82677,0.5748,0.83465,0.5748,0.84252,0.5748,0.85039,0.5748,0.85827,0.5748,0.86614,0.5748,0.87402,0.5748,0.88189,0.5748,0.88976,0.5748,0.89764,0.5748,0.90551,0.5748,0.91339,0.5748,0.92126,0.5748,0.92913,0.5748,0.93701,0.5748,0.94488,0.5748,0.95276,0.5748,0.96063,0.5748,0.9685,0.5748,0.97638,0.5748,0.98425,0.5748,0.99213,0.5748,0.99609,0.5748,0.00391,0.58268,0.00787,0.58268,0.01575,0.58268,0.02362,0.58268,0.0315,0.58268,0.03937,0.58268,0.04724,0.58268,0.05512,0.58268,0.06299,0.58268,0.07087,0.58268,0.07874,0.58268,0.08661,0.58268,0.09449,0.58268,0.10236,0.58268,0.11024,0.58268,0.11811,0.58268,0.12598,0.58268,0.13386,0.58268,0.14173,0.58268,0.14961,0.58268,0.15748,0.58268,0.16535,0.58268,0.17323,0.58268,0.1811,0.58268,0.18898,0.58268,0.19685,0.58268,0.20472,0.58268,0.2126,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_96()
		{
			double[] value = {0.22047,0.58268,0.22835,0.58268,0.23622,0.58268,0.24409,0.58268,0.25197,0.58268,0.25984,0.58268,0.26772,0.58268,0.27559,0.58268,0.28346,0.58268,0.29134,0.58268,0.29921,0.58268,0.30709,0.58268,0.31496,0.58268,0.32283,0.58268,0.33071,0.58268,0.33858,0.58268,0.34646,0.58268,0.35433,0.58268,0.3622,0.58268,0.37008,0.58268,0.37795,0.58268,0.38583,0.58268,0.3937,0.58268,0.40157,0.58268,0.40945,0.58268,0.41732,0.58268,0.4252,0.58268,0.43307,0.58268,0.44094,0.58268,0.44882,0.58268,0.45669,0.58268,0.46457,0.58268,0.47244,0.58268,0.48031,0.58268,0.48819,0.58268,0.49606,0.58268,0.50394,0.58268,0.51181,0.58268,0.51969,0.58268,0.52756,0.58268,0.53543,0.58268,0.54331,0.58268,0.55118,0.58268,0.55906,0.58268,0.56693,0.58268,0.5748,0.58268,0.58268,0.58268,0.59055,0.58268,0.59843,0.58268,0.6063,0.58268,0.61417,0.58268,0.62205,0.58268,0.62992,0.58268,0.6378,0.58268,0.64567,0.58268,0.65354,0.58268,0.66142,0.58268,0.66929,0.58268,0.67717,0.58268,0.68504,0.58268,0.69291,0.58268,0.70079,0.58268,0.70866,0.58268,0.71654,0.58268,0.72441,0.58268,0.73228,0.58268,0.74016,0.58268,0.74803,0.58268,0.75591,0.58268,0.76378,0.58268,0.77165,0.58268,0.77953,0.58268,0.7874,0.58268,0.79528,0.58268,0.80315,0.58268,0.81102,0.58268,0.8189,0.58268,0.82677,0.58268,0.83465,0.58268,0.84252,0.58268,0.85039,0.58268,0.85827,0.58268,0.86614,0.58268,0.87402,0.58268,0.88189,0.58268,0.88976,0.58268,0.89764,0.58268,0.90551,0.58268,0.91339,0.58268,0.92126,0.58268,0.92913,0.58268,0.93701,0.58268,0.94488,0.58268,0.95276,0.58268,0.96063,0.58268,0.9685,0.58268,0.97638,0.58268,0.98425,0.58268,0.99213,0.58268,0.99609,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_97()
		{
			double[] value = {0.00391,0.59055,0.00787,0.59055,0.01575,0.59055,0.02362,0.59055,0.0315,0.59055,0.03937,0.59055,0.04724,0.59055,0.05512,0.59055,0.06299,0.59055,0.07087,0.59055,0.07874,0.59055,0.08661,0.59055,0.09449,0.59055,0.10236,0.59055,0.11024,0.59055,0.11811,0.59055,0.12598,0.59055,0.13386,0.59055,0.14173,0.59055,0.14961,0.59055,0.15748,0.59055,0.16535,0.59055,0.17323,0.59055,0.1811,0.59055,0.18898,0.59055,0.19685,0.59055,0.20472,0.59055,0.2126,0.59055,0.22047,0.59055,0.22835,0.59055,0.23622,0.59055,0.24409,0.59055,0.25197,0.59055,0.25984,0.59055,0.26772,0.59055,0.27559,0.59055,0.28346,0.59055,0.29134,0.59055,0.29921,0.59055,0.30709,0.59055,0.31496,0.59055,0.32283,0.59055,0.33071,0.59055,0.33858,0.59055,0.34646,0.59055,0.35433,0.59055,0.3622,0.59055,0.37008,0.59055,0.37795,0.59055,0.38583,0.59055,0.3937,0.59055,0.40157,0.59055,0.40945,0.59055,0.41732,0.59055,0.4252,0.59055,0.43307,0.59055,0.44094,0.59055,0.44882,0.59055,0.45669,0.59055,0.46457,0.59055,0.47244,0.59055,0.48031,0.59055,0.48819,0.59055,0.49606,0.59055,0.50394,0.59055,0.51181,0.59055,0.51969,0.59055,0.52756,0.59055,0.53543,0.59055,0.54331,0.59055,0.55118,0.59055,0.55906,0.59055,0.56693,0.59055,0.5748,0.59055,0.58268,0.59055,0.59055,0.59055,0.59843,0.59055,0.6063,0.59055,0.61417,0.59055,0.62205,0.59055,0.62992,0.59055,0.6378,0.59055,0.64567,0.59055,0.65354,0.59055,0.66142,0.59055,0.66929,0.59055,0.67717,0.59055,0.68504,0.59055,0.69291,0.59055,0.70079,0.59055,0.70866,0.59055,0.71654,0.59055,0.72441,0.59055,0.73228,0.59055,0.74016,0.59055,0.74803,0.59055,0.75591,0.59055,0.76378,0.59055,0.77165,0.59055,0.77953,0.59055};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_98()
		{
			double[] value = {0.7874,0.59055,0.79528,0.59055,0.80315,0.59055,0.81102,0.59055,0.8189,0.59055,0.82677,0.59055,0.83465,0.59055,0.84252,0.59055,0.85039,0.59055,0.85827,0.59055,0.86614,0.59055,0.87402,0.59055,0.88189,0.59055,0.88976,0.59055,0.89764,0.59055,0.90551,0.59055,0.91339,0.59055,0.92126,0.59055,0.92913,0.59055,0.93701,0.59055,0.94488,0.59055,0.95276,0.59055,0.96063,0.59055,0.9685,0.59055,0.97638,0.59055,0.98425,0.59055,0.99213,0.59055,0.99609,0.59055,0.00391,0.59843,0.00787,0.59843,0.01575,0.59843,0.02362,0.59843,0.0315,0.59843,0.03937,0.59843,0.04724,0.59843,0.05512,0.59843,0.06299,0.59843,0.07087,0.59843,0.07874,0.59843,0.08661,0.59843,0.09449,0.59843,0.10236,0.59843,0.11024,0.59843,0.11811,0.59843,0.12598,0.59843,0.13386,0.59843,0.14173,0.59843,0.14961,0.59843,0.15748,0.59843,0.16535,0.59843,0.17323,0.59843,0.1811,0.59843,0.18898,0.59843,0.19685,0.59843,0.20472,0.59843,0.2126,0.59843,0.22047,0.59843,0.22835,0.59843,0.23622,0.59843,0.24409,0.59843,0.25197,0.59843,0.25984,0.59843,0.26772,0.59843,0.27559,0.59843,0.28346,0.59843,0.29134,0.59843,0.29921,0.59843,0.30709,0.59843,0.31496,0.59843,0.32283,0.59843,0.33071,0.59843,0.33858,0.59843,0.34646,0.59843,0.35433,0.59843,0.3622,0.59843,0.37008,0.59843,0.37795,0.59843,0.38583,0.59843,0.3937,0.59843,0.40157,0.59843,0.40945,0.59843,0.41732,0.59843,0.4252,0.59843,0.43307,0.59843,0.44094,0.59843,0.44882,0.59843,0.45669,0.59843,0.46457,0.59843,0.47244,0.59843,0.48031,0.59843,0.48819,0.59843,0.49606,0.59843,0.50394,0.59843,0.51181,0.59843,0.51969,0.59843,0.52756,0.59843,0.53543,0.59843,0.54331,0.59843,0.55118,0.59843,0.55906,0.59843};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_99()
		{
			double[] value = {0.56693,0.59843,0.5748,0.59843,0.58268,0.59843,0.59055,0.59843,0.59843,0.59843,0.6063,0.59843,0.61417,0.59843,0.62205,0.59843,0.62992,0.59843,0.6378,0.59843,0.64567,0.59843,0.65354,0.59843,0.66142,0.59843,0.66929,0.59843,0.67717,0.59843,0.68504,0.59843,0.69291,0.59843,0.70079,0.59843,0.70866,0.59843,0.71654,0.59843,0.72441,0.59843,0.73228,0.59843,0.74016,0.59843,0.74803,0.59843,0.75591,0.59843,0.76378,0.59843,0.77165,0.59843,0.77953,0.59843,0.7874,0.59843,0.79528,0.59843,0.80315,0.59843,0.81102,0.59843,0.8189,0.59843,0.82677,0.59843,0.83465,0.59843,0.84252,0.59843,0.85039,0.59843,0.85827,0.59843,0.86614,0.59843,0.87402,0.59843,0.88189,0.59843,0.88976,0.59843,0.89764,0.59843,0.90551,0.59843,0.91339,0.59843,0.92126,0.59843,0.92913,0.59843,0.93701,0.59843,0.94488,0.59843,0.95276,0.59843,0.96063,0.59843,0.9685,0.59843,0.97638,0.59843,0.98425,0.59843,0.99213,0.59843,0.99609,0.59843,0.00391,0.6063,0.00787,0.6063,0.01575,0.6063,0.02362,0.6063,0.0315,0.6063,0.03937,0.6063,0.04724,0.6063,0.05512,0.6063,0.06299,0.6063,0.07087,0.6063,0.07874,0.6063,0.08661,0.6063,0.09449,0.6063,0.10236,0.6063,0.11024,0.6063,0.11811,0.6063,0.12598,0.6063,0.13386,0.6063,0.14173,0.6063,0.14961,0.6063,0.15748,0.6063,0.16535,0.6063,0.17323,0.6063,0.1811,0.6063,0.18898,0.6063,0.19685,0.6063,0.20472,0.6063,0.2126,0.6063,0.22047,0.6063,0.22835,0.6063,0.23622,0.6063,0.24409,0.6063,0.25197,0.6063,0.25984,0.6063,0.26772,0.6063,0.27559,0.6063,0.28346,0.6063,0.29134,0.6063,0.29921,0.6063,0.30709,0.6063,0.31496,0.6063,0.32283,0.6063,0.33071,0.6063,0.33858,0.6063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_100()
		{
			double[] value = {0.34646,0.6063,0.35433,0.6063,0.3622,0.6063,0.37008,0.6063,0.37795,0.6063,0.38583,0.6063,0.3937,0.6063,0.40157,0.6063,0.40945,0.6063,0.41732,0.6063,0.4252,0.6063,0.43307,0.6063,0.44094,0.6063,0.44882,0.6063,0.45669,0.6063,0.46457,0.6063,0.47244,0.6063,0.48031,0.6063,0.48819,0.6063,0.49606,0.6063,0.50394,0.6063,0.51181,0.6063,0.51969,0.6063,0.52756,0.6063,0.53543,0.6063,0.54331,0.6063,0.55118,0.6063,0.55906,0.6063,0.56693,0.6063,0.5748,0.6063,0.58268,0.6063,0.59055,0.6063,0.59843,0.6063,0.6063,0.6063,0.61417,0.6063,0.62205,0.6063,0.62992,0.6063,0.6378,0.6063,0.64567,0.6063,0.65354,0.6063,0.66142,0.6063,0.66929,0.6063,0.67717,0.6063,0.68504,0.6063,0.69291,0.6063,0.70079,0.6063,0.70866,0.6063,0.71654,0.6063,0.72441,0.6063,0.73228,0.6063,0.74016,0.6063,0.74803,0.6063,0.75591,0.6063,0.76378,0.6063,0.77165,0.6063,0.77953,0.6063,0.7874,0.6063,0.79528,0.6063,0.80315,0.6063,0.81102,0.6063,0.8189,0.6063,0.82677,0.6063,0.83465,0.6063,0.84252,0.6063,0.85039,0.6063,0.85827,0.6063,0.86614,0.6063,0.87402,0.6063,0.88189,0.6063,0.88976,0.6063,0.89764,0.6063,0.90551,0.6063,0.91339,0.6063,0.92126,0.6063,0.92913,0.6063,0.93701,0.6063,0.94488,0.6063,0.95276,0.6063,0.96063,0.6063,0.9685,0.6063,0.97638,0.6063,0.98425,0.6063,0.99213,0.6063,0.99609,0.6063,0.00391,0.61417,0.00787,0.61417,0.01575,0.61417,0.02362,0.61417,0.0315,0.61417,0.03937,0.61417,0.04724,0.61417,0.05512,0.61417,0.06299,0.61417,0.07087,0.61417,0.07874,0.61417,0.08661,0.61417,0.09449,0.61417,0.10236,0.61417,0.11024,0.61417,0.11811,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_101()
		{
			double[] value = {0.12598,0.61417,0.13386,0.61417,0.14173,0.61417,0.14961,0.61417,0.15748,0.61417,0.16535,0.61417,0.17323,0.61417,0.1811,0.61417,0.18898,0.61417,0.19685,0.61417,0.20472,0.61417,0.2126,0.61417,0.22047,0.61417,0.22835,0.61417,0.23622,0.61417,0.24409,0.61417,0.25197,0.61417,0.25984,0.61417,0.26772,0.61417,0.27559,0.61417,0.28346,0.61417,0.29134,0.61417,0.29921,0.61417,0.30709,0.61417,0.31496,0.61417,0.32283,0.61417,0.33071,0.61417,0.33858,0.61417,0.34646,0.61417,0.35433,0.61417,0.3622,0.61417,0.37008,0.61417,0.37795,0.61417,0.38583,0.61417,0.3937,0.61417,0.40157,0.61417,0.40945,0.61417,0.41732,0.61417,0.4252,0.61417,0.43307,0.61417,0.44094,0.61417,0.44882,0.61417,0.45669,0.61417,0.46457,0.61417,0.47244,0.61417,0.48031,0.61417,0.48819,0.61417,0.49606,0.61417,0.50394,0.61417,0.51181,0.61417,0.51969,0.61417,0.52756,0.61417,0.53543,0.61417,0.54331,0.61417,0.55118,0.61417,0.55906,0.61417,0.56693,0.61417,0.5748,0.61417,0.58268,0.61417,0.59055,0.61417,0.59843,0.61417,0.6063,0.61417,0.61417,0.61417,0.62205,0.61417,0.62992,0.61417,0.6378,0.61417,0.64567,0.61417,0.65354,0.61417,0.66142,0.61417,0.66929,0.61417,0.67717,0.61417,0.68504,0.61417,0.69291,0.61417,0.70079,0.61417,0.70866,0.61417,0.71654,0.61417,0.72441,0.61417,0.73228,0.61417,0.74016,0.61417,0.74803,0.61417,0.75591,0.61417,0.76378,0.61417,0.77165,0.61417,0.77953,0.61417,0.7874,0.61417,0.79528,0.61417,0.80315,0.61417,0.81102,0.61417,0.8189,0.61417,0.82677,0.61417,0.83465,0.61417,0.84252,0.61417,0.85039,0.61417,0.85827,0.61417,0.86614,0.61417,0.87402,0.61417,0.88189,0.61417,0.88976,0.61417,0.89764,0.61417,0.90551,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_102()
		{
			double[] value = {0.91339,0.61417,0.92126,0.61417,0.92913,0.61417,0.93701,0.61417,0.94488,0.61417,0.95276,0.61417,0.96063,0.61417,0.9685,0.61417,0.97638,0.61417,0.98425,0.61417,0.99213,0.61417,0.99609,0.61417,0.00391,0.62205,0.00787,0.62205,0.01575,0.62205,0.02362,0.62205,0.0315,0.62205,0.03937,0.62205,0.04724,0.62205,0.05512,0.62205,0.06299,0.62205,0.07087,0.62205,0.07874,0.62205,0.08661,0.62205,0.09449,0.62205,0.10236,0.62205,0.11024,0.62205,0.11811,0.62205,0.12598,0.62205,0.13386,0.62205,0.14173,0.62205,0.14961,0.62205,0.15748,0.62205,0.16535,0.62205,0.17323,0.62205,0.1811,0.62205,0.18898,0.62205,0.19685,0.62205,0.20472,0.62205,0.2126,0.62205,0.22047,0.62205,0.22835,0.62205,0.23622,0.62205,0.24409,0.62205,0.25197,0.62205,0.25984,0.62205,0.26772,0.62205,0.27559,0.62205,0.28346,0.62205,0.29134,0.62205,0.29921,0.62205,0.30709,0.62205,0.31496,0.62205,0.32283,0.62205,0.33071,0.62205,0.33858,0.62205,0.34646,0.62205,0.35433,0.62205,0.3622,0.62205,0.37008,0.62205,0.37795,0.62205,0.38583,0.62205,0.3937,0.62205,0.40157,0.62205,0.40945,0.62205,0.41732,0.62205,0.4252,0.62205,0.43307,0.62205,0.44094,0.62205,0.44882,0.62205,0.45669,0.62205,0.46457,0.62205,0.47244,0.62205,0.48031,0.62205,0.48819,0.62205,0.49606,0.62205,0.50394,0.62205,0.51181,0.62205,0.51969,0.62205,0.52756,0.62205,0.53543,0.62205,0.54331,0.62205,0.55118,0.62205,0.55906,0.62205,0.56693,0.62205,0.5748,0.62205,0.58268,0.62205,0.59055,0.62205,0.59843,0.62205,0.6063,0.62205,0.61417,0.62205,0.62205,0.62205,0.62992,0.62205,0.6378,0.62205,0.64567,0.62205,0.65354,0.62205,0.66142,0.62205,0.66929,0.62205,0.67717,0.62205,0.68504,0.62205};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_103()
		{
			double[] value = {0.69291,0.62205,0.70079,0.62205,0.70866,0.62205,0.71654,0.62205,0.72441,0.62205,0.73228,0.62205,0.74016,0.62205,0.74803,0.62205,0.75591,0.62205,0.76378,0.62205,0.77165,0.62205,0.77953,0.62205,0.7874,0.62205,0.79528,0.62205,0.80315,0.62205,0.81102,0.62205,0.8189,0.62205,0.82677,0.62205,0.83465,0.62205,0.84252,0.62205,0.85039,0.62205,0.85827,0.62205,0.86614,0.62205,0.87402,0.62205,0.88189,0.62205,0.88976,0.62205,0.89764,0.62205,0.90551,0.62205,0.91339,0.62205,0.92126,0.62205,0.92913,0.62205,0.93701,0.62205,0.94488,0.62205,0.95276,0.62205,0.96063,0.62205,0.9685,0.62205,0.97638,0.62205,0.98425,0.62205,0.99213,0.62205,0.99609,0.62205,0.00391,0.62992,0.00787,0.62992,0.01575,0.62992,0.02362,0.62992,0.0315,0.62992,0.03937,0.62992,0.04724,0.62992,0.05512,0.62992,0.06299,0.62992,0.07087,0.62992,0.07874,0.62992,0.08661,0.62992,0.09449,0.62992,0.10236,0.62992,0.11024,0.62992,0.11811,0.62992,0.12598,0.62992,0.13386,0.62992,0.14173,0.62992,0.14961,0.62992,0.15748,0.62992,0.16535,0.62992,0.17323,0.62992,0.1811,0.62992,0.18898,0.62992,0.19685,0.62992,0.20472,0.62992,0.2126,0.62992,0.22047,0.62992,0.22835,0.62992,0.23622,0.62992,0.24409,0.62992,0.25197,0.62992,0.25984,0.62992,0.26772,0.62992,0.27559,0.62992,0.28346,0.62992,0.29134,0.62992,0.29921,0.62992,0.30709,0.62992,0.31496,0.62992,0.32283,0.62992,0.33071,0.62992,0.33858,0.62992,0.34646,0.62992,0.35433,0.62992,0.3622,0.62992,0.37008,0.62992,0.37795,0.62992,0.38583,0.62992,0.3937,0.62992,0.40157,0.62992,0.40945,0.62992,0.41732,0.62992,0.4252,0.62992,0.43307,0.62992,0.44094,0.62992,0.44882,0.62992,0.45669,0.62992,0.46457,0.62992};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_104()
		{
			double[] value = {0.47244,0.62992,0.48031,0.62992,0.48819,0.62992,0.49606,0.62992,0.50394,0.62992,0.51181,0.62992,0.51969,0.62992,0.52756,0.62992,0.53543,0.62992,0.54331,0.62992,0.55118,0.62992,0.55906,0.62992,0.56693,0.62992,0.5748,0.62992,0.58268,0.62992,0.59055,0.62992,0.59843,0.62992,0.6063,0.62992,0.61417,0.62992,0.62205,0.62992,0.62992,0.62992,0.6378,0.62992,0.64567,0.62992,0.65354,0.62992,0.66142,0.62992,0.66929,0.62992,0.67717,0.62992,0.68504,0.62992,0.69291,0.62992,0.70079,0.62992,0.70866,0.62992,0.71654,0.62992,0.72441,0.62992,0.73228,0.62992,0.74016,0.62992,0.74803,0.62992,0.75591,0.62992,0.76378,0.62992,0.77165,0.62992,0.77953,0.62992,0.7874,0.62992,0.79528,0.62992,0.80315,0.62992,0.81102,0.62992,0.8189,0.62992,0.82677,0.62992,0.83465,0.62992,0.84252,0.62992,0.85039,0.62992,0.85827,0.62992,0.86614,0.62992,0.87402,0.62992,0.88189,0.62992,0.88976,0.62992,0.89764,0.62992,0.90551,0.62992,0.91339,0.62992,0.92126,0.62992,0.92913,0.62992,0.93701,0.62992,0.94488,0.62992,0.95276,0.62992,0.96063,0.62992,0.9685,0.62992,0.97638,0.62992,0.98425,0.62992,0.99213,0.62992,0.99609,0.62992,0.00391,0.6378,0.00787,0.6378,0.01575,0.6378,0.02362,0.6378,0.0315,0.6378,0.03937,0.6378,0.04724,0.6378,0.05512,0.6378,0.06299,0.6378,0.07087,0.6378,0.07874,0.6378,0.08661,0.6378,0.09449,0.6378,0.10236,0.6378,0.11024,0.6378,0.11811,0.6378,0.12598,0.6378,0.13386,0.6378,0.14173,0.6378,0.14961,0.6378,0.15748,0.6378,0.16535,0.6378,0.17323,0.6378,0.1811,0.6378,0.18898,0.6378,0.19685,0.6378,0.20472,0.6378,0.2126,0.6378,0.22047,0.6378,0.22835,0.6378,0.23622,0.6378,0.24409,0.6378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_105()
		{
			double[] value = {0.25197,0.6378,0.25984,0.6378,0.26772,0.6378,0.27559,0.6378,0.28346,0.6378,0.29134,0.6378,0.29921,0.6378,0.30709,0.6378,0.31496,0.6378,0.32283,0.6378,0.33071,0.6378,0.33858,0.6378,0.34646,0.6378,0.35433,0.6378,0.3622,0.6378,0.37008,0.6378,0.37795,0.6378,0.38583,0.6378,0.3937,0.6378,0.40157,0.6378,0.40945,0.6378,0.41732,0.6378,0.4252,0.6378,0.43307,0.6378,0.44094,0.6378,0.44882,0.6378,0.45669,0.6378,0.46457,0.6378,0.47244,0.6378,0.48031,0.6378,0.48819,0.6378,0.49606,0.6378,0.50394,0.6378,0.51181,0.6378,0.51969,0.6378,0.52756,0.6378,0.53543,0.6378,0.54331,0.6378,0.55118,0.6378,0.55906,0.6378,0.56693,0.6378,0.5748,0.6378,0.58268,0.6378,0.59055,0.6378,0.59843,0.6378,0.6063,0.6378,0.61417,0.6378,0.62205,0.6378,0.62992,0.6378,0.6378,0.6378,0.64567,0.6378,0.65354,0.6378,0.66142,0.6378,0.66929,0.6378,0.67717,0.6378,0.68504,0.6378,0.69291,0.6378,0.70079,0.6378,0.70866,0.6378,0.71654,0.6378,0.72441,0.6378,0.73228,0.6378,0.74016,0.6378,0.74803,0.6378,0.75591,0.6378,0.76378,0.6378,0.77165,0.6378,0.77953,0.6378,0.7874,0.6378,0.79528,0.6378,0.80315,0.6378,0.81102,0.6378,0.8189,0.6378,0.82677,0.6378,0.83465,0.6378,0.84252,0.6378,0.85039,0.6378,0.85827,0.6378,0.86614,0.6378,0.87402,0.6378,0.88189,0.6378,0.88976,0.6378,0.89764,0.6378,0.90551,0.6378,0.91339,0.6378,0.92126,0.6378,0.92913,0.6378,0.93701,0.6378,0.94488,0.6378,0.95276,0.6378,0.96063,0.6378,0.9685,0.6378,0.97638,0.6378,0.98425,0.6378,0.99213,0.6378,0.99609,0.6378,0.00391,0.64567,0.00787,0.64567,0.01575,0.64567,0.02362,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_106()
		{
			double[] value = {0.0315,0.64567,0.03937,0.64567,0.04724,0.64567,0.05512,0.64567,0.06299,0.64567,0.07087,0.64567,0.07874,0.64567,0.08661,0.64567,0.09449,0.64567,0.10236,0.64567,0.11024,0.64567,0.11811,0.64567,0.12598,0.64567,0.13386,0.64567,0.14173,0.64567,0.14961,0.64567,0.15748,0.64567,0.16535,0.64567,0.17323,0.64567,0.1811,0.64567,0.18898,0.64567,0.19685,0.64567,0.20472,0.64567,0.2126,0.64567,0.22047,0.64567,0.22835,0.64567,0.23622,0.64567,0.24409,0.64567,0.25197,0.64567,0.25984,0.64567,0.26772,0.64567,0.27559,0.64567,0.28346,0.64567,0.29134,0.64567,0.29921,0.64567,0.30709,0.64567,0.31496,0.64567,0.32283,0.64567,0.33071,0.64567,0.33858,0.64567,0.34646,0.64567,0.35433,0.64567,0.3622,0.64567,0.37008,0.64567,0.37795,0.64567,0.38583,0.64567,0.3937,0.64567,0.40157,0.64567,0.40945,0.64567,0.41732,0.64567,0.4252,0.64567,0.43307,0.64567,0.44094,0.64567,0.44882,0.64567,0.45669,0.64567,0.46457,0.64567,0.47244,0.64567,0.48031,0.64567,0.48819,0.64567,0.49606,0.64567,0.50394,0.64567,0.51181,0.64567,0.51969,0.64567,0.52756,0.64567,0.53543,0.64567,0.54331,0.64567,0.55118,0.64567,0.55906,0.64567,0.56693,0.64567,0.5748,0.64567,0.58268,0.64567,0.59055,0.64567,0.59843,0.64567,0.6063,0.64567,0.61417,0.64567,0.62205,0.64567,0.62992,0.64567,0.6378,0.64567,0.64567,0.64567,0.65354,0.64567,0.66142,0.64567,0.66929,0.64567,0.67717,0.64567,0.68504,0.64567,0.69291,0.64567,0.70079,0.64567,0.70866,0.64567,0.71654,0.64567,0.72441,0.64567,0.73228,0.64567,0.74016,0.64567,0.74803,0.64567,0.75591,0.64567,0.76378,0.64567,0.77165,0.64567,0.77953,0.64567,0.7874,0.64567,0.79528,0.64567,0.80315,0.64567,0.81102,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_107()
		{
			double[] value = {0.8189,0.64567,0.82677,0.64567,0.83465,0.64567,0.84252,0.64567,0.85039,0.64567,0.85827,0.64567,0.86614,0.64567,0.87402,0.64567,0.88189,0.64567,0.88976,0.64567,0.89764,0.64567,0.90551,0.64567,0.91339,0.64567,0.92126,0.64567,0.92913,0.64567,0.93701,0.64567,0.94488,0.64567,0.95276,0.64567,0.96063,0.64567,0.9685,0.64567,0.97638,0.64567,0.98425,0.64567,0.99213,0.64567,0.99609,0.64567,0.00391,0.65354,0.00787,0.65354,0.01575,0.65354,0.02362,0.65354,0.0315,0.65354,0.03937,0.65354,0.04724,0.65354,0.05512,0.65354,0.06299,0.65354,0.07087,0.65354,0.07874,0.65354,0.08661,0.65354,0.09449,0.65354,0.10236,0.65354,0.11024,0.65354,0.11811,0.65354,0.12598,0.65354,0.13386,0.65354,0.14173,0.65354,0.14961,0.65354,0.15748,0.65354,0.16535,0.65354,0.17323,0.65354,0.1811,0.65354,0.18898,0.65354,0.19685,0.65354,0.20472,0.65354,0.2126,0.65354,0.22047,0.65354,0.22835,0.65354,0.23622,0.65354,0.24409,0.65354,0.25197,0.65354,0.25984,0.65354,0.26772,0.65354,0.27559,0.65354,0.28346,0.65354,0.29134,0.65354,0.29921,0.65354,0.30709,0.65354,0.31496,0.65354,0.32283,0.65354,0.33071,0.65354,0.33858,0.65354,0.34646,0.65354,0.35433,0.65354,0.3622,0.65354,0.37008,0.65354,0.37795,0.65354,0.38583,0.65354,0.3937,0.65354,0.40157,0.65354,0.40945,0.65354,0.41732,0.65354,0.4252,0.65354,0.43307,0.65354,0.44094,0.65354,0.44882,0.65354,0.45669,0.65354,0.46457,0.65354,0.47244,0.65354,0.48031,0.65354,0.48819,0.65354,0.49606,0.65354,0.50394,0.65354,0.51181,0.65354,0.51969,0.65354,0.52756,0.65354,0.53543,0.65354,0.54331,0.65354,0.55118,0.65354,0.55906,0.65354,0.56693,0.65354,0.5748,0.65354,0.58268,0.65354,0.59055,0.65354};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_108()
		{
			double[] value = {0.59843,0.65354,0.6063,0.65354,0.61417,0.65354,0.62205,0.65354,0.62992,0.65354,0.6378,0.65354,0.64567,0.65354,0.65354,0.65354,0.66142,0.65354,0.66929,0.65354,0.67717,0.65354,0.68504,0.65354,0.69291,0.65354,0.70079,0.65354,0.70866,0.65354,0.71654,0.65354,0.72441,0.65354,0.73228,0.65354,0.74016,0.65354,0.74803,0.65354,0.75591,0.65354,0.76378,0.65354,0.77165,0.65354,0.77953,0.65354,0.7874,0.65354,0.79528,0.65354,0.80315,0.65354,0.81102,0.65354,0.8189,0.65354,0.82677,0.65354,0.83465,0.65354,0.84252,0.65354,0.85039,0.65354,0.85827,0.65354,0.86614,0.65354,0.87402,0.65354,0.88189,0.65354,0.88976,0.65354,0.89764,0.65354,0.90551,0.65354,0.91339,0.65354,0.92126,0.65354,0.92913,0.65354,0.93701,0.65354,0.94488,0.65354,0.95276,0.65354,0.96063,0.65354,0.9685,0.65354,0.97638,0.65354,0.98425,0.65354,0.99213,0.65354,0.99609,0.65354,0.00391,0.66142,0.00787,0.66142,0.01575,0.66142,0.02362,0.66142,0.0315,0.66142,0.03937,0.66142,0.04724,0.66142,0.05512,0.66142,0.06299,0.66142,0.07087,0.66142,0.07874,0.66142,0.08661,0.66142,0.09449,0.66142,0.10236,0.66142,0.11024,0.66142,0.11811,0.66142,0.12598,0.66142,0.13386,0.66142,0.14173,0.66142,0.14961,0.66142,0.15748,0.66142,0.16535,0.66142,0.17323,0.66142,0.1811,0.66142,0.18898,0.66142,0.19685,0.66142,0.20472,0.66142,0.2126,0.66142,0.22047,0.66142,0.22835,0.66142,0.23622,0.66142,0.24409,0.66142,0.25197,0.66142,0.25984,0.66142,0.26772,0.66142,0.27559,0.66142,0.28346,0.66142,0.29134,0.66142,0.29921,0.66142,0.30709,0.66142,0.31496,0.66142,0.32283,0.66142,0.33071,0.66142,0.33858,0.66142,0.34646,0.66142,0.35433,0.66142,0.3622,0.66142,0.37008,0.66142};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_109()
		{
			double[] value = {0.37795,0.66142,0.38583,0.66142,0.3937,0.66142,0.40157,0.66142,0.40945,0.66142,0.41732,0.66142,0.4252,0.66142,0.43307,0.66142,0.44094,0.66142,0.44882,0.66142,0.45669,0.66142,0.46457,0.66142,0.47244,0.66142,0.48031,0.66142,0.48819,0.66142,0.49606,0.66142,0.50394,0.66142,0.51181,0.66142,0.51969,0.66142,0.52756,0.66142,0.53543,0.66142,0.54331,0.66142,0.55118,0.66142,0.55906,0.66142,0.56693,0.66142,0.5748,0.66142,0.58268,0.66142,0.59055,0.66142,0.59843,0.66142,0.6063,0.66142,0.61417,0.66142,0.62205,0.66142,0.62992,0.66142,0.6378,0.66142,0.64567,0.66142,0.65354,0.66142,0.66142,0.66142,0.66929,0.66142,0.67717,0.66142,0.68504,0.66142,0.69291,0.66142,0.70079,0.66142,0.70866,0.66142,0.71654,0.66142,0.72441,0.66142,0.73228,0.66142,0.74016,0.66142,0.74803,0.66142,0.75591,0.66142,0.76378,0.66142,0.77165,0.66142,0.77953,0.66142,0.7874,0.66142,0.79528,0.66142,0.80315,0.66142,0.81102,0.66142,0.8189,0.66142,0.82677,0.66142,0.83465,0.66142,0.84252,0.66142,0.85039,0.66142,0.85827,0.66142,0.86614,0.66142,0.87402,0.66142,0.88189,0.66142,0.88976,0.66142,0.89764,0.66142,0.90551,0.66142,0.91339,0.66142,0.92126,0.66142,0.92913,0.66142,0.93701,0.66142,0.94488,0.66142,0.95276,0.66142,0.96063,0.66142,0.9685,0.66142,0.97638,0.66142,0.98425,0.66142,0.99213,0.66142,0.99609,0.66142,0.00391,0.66929,0.00787,0.66929,0.01575,0.66929,0.02362,0.66929,0.0315,0.66929,0.03937,0.66929,0.04724,0.66929,0.05512,0.66929,0.06299,0.66929,0.07087,0.66929,0.07874,0.66929,0.08661,0.66929,0.09449,0.66929,0.10236,0.66929,0.11024,0.66929,0.11811,0.66929,0.12598,0.66929,0.13386,0.66929,0.14173,0.66929,0.14961,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_110()
		{
			double[] value = {0.15748,0.66929,0.16535,0.66929,0.17323,0.66929,0.1811,0.66929,0.18898,0.66929,0.19685,0.66929,0.20472,0.66929,0.2126,0.66929,0.22047,0.66929,0.22835,0.66929,0.23622,0.66929,0.24409,0.66929,0.25197,0.66929,0.25984,0.66929,0.26772,0.66929,0.27559,0.66929,0.28346,0.66929,0.29134,0.66929,0.29921,0.66929,0.30709,0.66929,0.31496,0.66929,0.32283,0.66929,0.33071,0.66929,0.33858,0.66929,0.34646,0.66929,0.35433,0.66929,0.3622,0.66929,0.37008,0.66929,0.37795,0.66929,0.38583,0.66929,0.3937,0.66929,0.40157,0.66929,0.40945,0.66929,0.41732,0.66929,0.4252,0.66929,0.43307,0.66929,0.44094,0.66929,0.44882,0.66929,0.45669,0.66929,0.46457,0.66929,0.47244,0.66929,0.48031,0.66929,0.48819,0.66929,0.49606,0.66929,0.50394,0.66929,0.51181,0.66929,0.51969,0.66929,0.52756,0.66929,0.53543,0.66929,0.54331,0.66929,0.55118,0.66929,0.55906,0.66929,0.56693,0.66929,0.5748,0.66929,0.58268,0.66929,0.59055,0.66929,0.59843,0.66929,0.6063,0.66929,0.61417,0.66929,0.62205,0.66929,0.62992,0.66929,0.6378,0.66929,0.64567,0.66929,0.65354,0.66929,0.66142,0.66929,0.66929,0.66929,0.67717,0.66929,0.68504,0.66929,0.69291,0.66929,0.70079,0.66929,0.70866,0.66929,0.71654,0.66929,0.72441,0.66929,0.73228,0.66929,0.74016,0.66929,0.74803,0.66929,0.75591,0.66929,0.76378,0.66929,0.77165,0.66929,0.77953,0.66929,0.7874,0.66929,0.79528,0.66929,0.80315,0.66929,0.81102,0.66929,0.8189,0.66929,0.82677,0.66929,0.83465,0.66929,0.84252,0.66929,0.85039,0.66929,0.85827,0.66929,0.86614,0.66929,0.87402,0.66929,0.88189,0.66929,0.88976,0.66929,0.89764,0.66929,0.90551,0.66929,0.91339,0.66929,0.92126,0.66929,0.92913,0.66929,0.93701,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_111()
		{
			double[] value = {0.94488,0.66929,0.95276,0.66929,0.96063,0.66929,0.9685,0.66929,0.97638,0.66929,0.98425,0.66929,0.99213,0.66929,0.99609,0.66929,0.00391,0.67717,0.00787,0.67717,0.01575,0.67717,0.02362,0.67717,0.0315,0.67717,0.03937,0.67717,0.04724,0.67717,0.05512,0.67717,0.06299,0.67717,0.07087,0.67717,0.07874,0.67717,0.08661,0.67717,0.09449,0.67717,0.10236,0.67717,0.11024,0.67717,0.11811,0.67717,0.12598,0.67717,0.13386,0.67717,0.14173,0.67717,0.14961,0.67717,0.15748,0.67717,0.16535,0.67717,0.17323,0.67717,0.1811,0.67717,0.18898,0.67717,0.19685,0.67717,0.20472,0.67717,0.2126,0.67717,0.22047,0.67717,0.22835,0.67717,0.23622,0.67717,0.24409,0.67717,0.25197,0.67717,0.25984,0.67717,0.26772,0.67717,0.27559,0.67717,0.28346,0.67717,0.29134,0.67717,0.29921,0.67717,0.30709,0.67717,0.31496,0.67717,0.32283,0.67717,0.33071,0.67717,0.33858,0.67717,0.34646,0.67717,0.35433,0.67717,0.3622,0.67717,0.37008,0.67717,0.37795,0.67717,0.38583,0.67717,0.3937,0.67717,0.40157,0.67717,0.40945,0.67717,0.41732,0.67717,0.4252,0.67717,0.43307,0.67717,0.44094,0.67717,0.44882,0.67717,0.45669,0.67717,0.46457,0.67717,0.47244,0.67717,0.48031,0.67717,0.48819,0.67717,0.49606,0.67717,0.50394,0.67717,0.51181,0.67717,0.51969,0.67717,0.52756,0.67717,0.53543,0.67717,0.54331,0.67717,0.55118,0.67717,0.55906,0.67717,0.56693,0.67717,0.5748,0.67717,0.58268,0.67717,0.59055,0.67717,0.59843,0.67717,0.6063,0.67717,0.61417,0.67717,0.62205,0.67717,0.62992,0.67717,0.6378,0.67717,0.64567,0.67717,0.65354,0.67717,0.66142,0.67717,0.66929,0.67717,0.67717,0.67717,0.68504,0.67717,0.69291,0.67717,0.70079,0.67717,0.70866,0.67717,0.71654,0.67717};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_112()
		{
			double[] value = {0.72441,0.67717,0.73228,0.67717,0.74016,0.67717,0.74803,0.67717,0.75591,0.67717,0.76378,0.67717,0.77165,0.67717,0.77953,0.67717,0.7874,0.67717,0.79528,0.67717,0.80315,0.67717,0.81102,0.67717,0.8189,0.67717,0.82677,0.67717,0.83465,0.67717,0.84252,0.67717,0.85039,0.67717,0.85827,0.67717,0.86614,0.67717,0.87402,0.67717,0.88189,0.67717,0.88976,0.67717,0.89764,0.67717,0.90551,0.67717,0.91339,0.67717,0.92126,0.67717,0.92913,0.67717,0.93701,0.67717,0.94488,0.67717,0.95276,0.67717,0.96063,0.67717,0.9685,0.67717,0.97638,0.67717,0.98425,0.67717,0.99213,0.67717,0.99609,0.67717,0.00391,0.68504,0.00787,0.68504,0.01575,0.68504,0.02362,0.68504,0.0315,0.68504,0.03937,0.68504,0.04724,0.68504,0.05512,0.68504,0.06299,0.68504,0.07087,0.68504,0.07874,0.68504,0.08661,0.68504,0.09449,0.68504,0.10236,0.68504,0.11024,0.68504,0.11811,0.68504,0.12598,0.68504,0.13386,0.68504,0.14173,0.68504,0.14961,0.68504,0.15748,0.68504,0.16535,0.68504,0.17323,0.68504,0.1811,0.68504,0.18898,0.68504,0.19685,0.68504,0.20472,0.68504,0.2126,0.68504,0.22047,0.68504,0.22835,0.68504,0.23622,0.68504,0.24409,0.68504,0.25197,0.68504,0.25984,0.68504,0.26772,0.68504,0.27559,0.68504,0.28346,0.68504,0.29134,0.68504,0.29921,0.68504,0.30709,0.68504,0.31496,0.68504,0.32283,0.68504,0.33071,0.68504,0.33858,0.68504,0.34646,0.68504,0.35433,0.68504,0.3622,0.68504,0.37008,0.68504,0.37795,0.68504,0.38583,0.68504,0.3937,0.68504,0.40157,0.68504,0.40945,0.68504,0.41732,0.68504,0.4252,0.68504,0.43307,0.68504,0.44094,0.68504,0.44882,0.68504,0.45669,0.68504,0.46457,0.68504,0.47244,0.68504,0.48031,0.68504,0.48819,0.68504,0.49606,0.68504};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_113()
		{
			double[] value = {0.50394,0.68504,0.51181,0.68504,0.51969,0.68504,0.52756,0.68504,0.53543,0.68504,0.54331,0.68504,0.55118,0.68504,0.55906,0.68504,0.56693,0.68504,0.5748,0.68504,0.58268,0.68504,0.59055,0.68504,0.59843,0.68504,0.6063,0.68504,0.61417,0.68504,0.62205,0.68504,0.62992,0.68504,0.6378,0.68504,0.64567,0.68504,0.65354,0.68504,0.66142,0.68504,0.66929,0.68504,0.67717,0.68504,0.68504,0.68504,0.69291,0.68504,0.70079,0.68504,0.70866,0.68504,0.71654,0.68504,0.72441,0.68504,0.73228,0.68504,0.74016,0.68504,0.74803,0.68504,0.75591,0.68504,0.76378,0.68504,0.77165,0.68504,0.77953,0.68504,0.7874,0.68504,0.79528,0.68504,0.80315,0.68504,0.81102,0.68504,0.8189,0.68504,0.82677,0.68504,0.83465,0.68504,0.84252,0.68504,0.85039,0.68504,0.85827,0.68504,0.86614,0.68504,0.87402,0.68504,0.88189,0.68504,0.88976,0.68504,0.89764,0.68504,0.90551,0.68504,0.91339,0.68504,0.92126,0.68504,0.92913,0.68504,0.93701,0.68504,0.94488,0.68504,0.95276,0.68504,0.96063,0.68504,0.9685,0.68504,0.97638,0.68504,0.98425,0.68504,0.99213,0.68504,0.99609,0.68504,0.00391,0.69291,0.00787,0.69291,0.01575,0.69291,0.02362,0.69291,0.0315,0.69291,0.03937,0.69291,0.04724,0.69291,0.05512,0.69291,0.06299,0.69291,0.07087,0.69291,0.07874,0.69291,0.08661,0.69291,0.09449,0.69291,0.10236,0.69291,0.11024,0.69291,0.11811,0.69291,0.12598,0.69291,0.13386,0.69291,0.14173,0.69291,0.14961,0.69291,0.15748,0.69291,0.16535,0.69291,0.17323,0.69291,0.1811,0.69291,0.18898,0.69291,0.19685,0.69291,0.20472,0.69291,0.2126,0.69291,0.22047,0.69291,0.22835,0.69291,0.23622,0.69291,0.24409,0.69291,0.25197,0.69291,0.25984,0.69291,0.26772,0.69291,0.27559,0.69291};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_114()
		{
			double[] value = {0.28346,0.69291,0.29134,0.69291,0.29921,0.69291,0.30709,0.69291,0.31496,0.69291,0.32283,0.69291,0.33071,0.69291,0.33858,0.69291,0.34646,0.69291,0.35433,0.69291,0.3622,0.69291,0.37008,0.69291,0.37795,0.69291,0.38583,0.69291,0.3937,0.69291,0.40157,0.69291,0.40945,0.69291,0.41732,0.69291,0.4252,0.69291,0.43307,0.69291,0.44094,0.69291,0.44882,0.69291,0.45669,0.69291,0.46457,0.69291,0.47244,0.69291,0.48031,0.69291,0.48819,0.69291,0.49606,0.69291,0.50394,0.69291,0.51181,0.69291,0.51969,0.69291,0.52756,0.69291,0.53543,0.69291,0.54331,0.69291,0.55118,0.69291,0.55906,0.69291,0.56693,0.69291,0.5748,0.69291,0.58268,0.69291,0.59055,0.69291,0.59843,0.69291,0.6063,0.69291,0.61417,0.69291,0.62205,0.69291,0.62992,0.69291,0.6378,0.69291,0.64567,0.69291,0.65354,0.69291,0.66142,0.69291,0.66929,0.69291,0.67717,0.69291,0.68504,0.69291,0.69291,0.69291,0.70079,0.69291,0.70866,0.69291,0.71654,0.69291,0.72441,0.69291,0.73228,0.69291,0.74016,0.69291,0.74803,0.69291,0.75591,0.69291,0.76378,0.69291,0.77165,0.69291,0.77953,0.69291,0.7874,0.69291,0.79528,0.69291,0.80315,0.69291,0.81102,0.69291,0.8189,0.69291,0.82677,0.69291,0.83465,0.69291,0.84252,0.69291,0.85039,0.69291,0.85827,0.69291,0.86614,0.69291,0.87402,0.69291,0.88189,0.69291,0.88976,0.69291,0.89764,0.69291,0.90551,0.69291,0.91339,0.69291,0.92126,0.69291,0.92913,0.69291,0.93701,0.69291,0.94488,0.69291,0.95276,0.69291,0.96063,0.69291,0.9685,0.69291,0.97638,0.69291,0.98425,0.69291,0.99213,0.69291,0.99609,0.69291,0.00391,0.70079,0.00787,0.70079,0.01575,0.70079,0.02362,0.70079,0.0315,0.70079,0.03937,0.70079,0.04724,0.70079,0.05512,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_115()
		{
			double[] value = {0.06299,0.70079,0.07087,0.70079,0.07874,0.70079,0.08661,0.70079,0.09449,0.70079,0.10236,0.70079,0.11024,0.70079,0.11811,0.70079,0.12598,0.70079,0.13386,0.70079,0.14173,0.70079,0.14961,0.70079,0.15748,0.70079,0.16535,0.70079,0.17323,0.70079,0.1811,0.70079,0.18898,0.70079,0.19685,0.70079,0.20472,0.70079,0.2126,0.70079,0.22047,0.70079,0.22835,0.70079,0.23622,0.70079,0.24409,0.70079,0.25197,0.70079,0.25984,0.70079,0.26772,0.70079,0.27559,0.70079,0.28346,0.70079,0.29134,0.70079,0.29921,0.70079,0.30709,0.70079,0.31496,0.70079,0.32283,0.70079,0.33071,0.70079,0.33858,0.70079,0.34646,0.70079,0.35433,0.70079,0.3622,0.70079,0.37008,0.70079,0.37795,0.70079,0.38583,0.70079,0.3937,0.70079,0.40157,0.70079,0.40945,0.70079,0.41732,0.70079,0.4252,0.70079,0.43307,0.70079,0.44094,0.70079,0.44882,0.70079,0.45669,0.70079,0.46457,0.70079,0.47244,0.70079,0.48031,0.70079,0.48819,0.70079,0.49606,0.70079,0.50394,0.70079,0.51181,0.70079,0.51969,0.70079,0.52756,0.70079,0.53543,0.70079,0.54331,0.70079,0.55118,0.70079,0.55906,0.70079,0.56693,0.70079,0.5748,0.70079,0.58268,0.70079,0.59055,0.70079,0.59843,0.70079,0.6063,0.70079,0.61417,0.70079,0.62205,0.70079,0.62992,0.70079,0.6378,0.70079,0.64567,0.70079,0.65354,0.70079,0.66142,0.70079,0.66929,0.70079,0.67717,0.70079,0.68504,0.70079,0.69291,0.70079,0.70079,0.70079,0.70866,0.70079,0.71654,0.70079,0.72441,0.70079,0.73228,0.70079,0.74016,0.70079,0.74803,0.70079,0.75591,0.70079,0.76378,0.70079,0.77165,0.70079,0.77953,0.70079,0.7874,0.70079,0.79528,0.70079,0.80315,0.70079,0.81102,0.70079,0.8189,0.70079,0.82677,0.70079,0.83465,0.70079,0.84252,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_116()
		{
			double[] value = {0.85039,0.70079,0.85827,0.70079,0.86614,0.70079,0.87402,0.70079,0.88189,0.70079,0.88976,0.70079,0.89764,0.70079,0.90551,0.70079,0.91339,0.70079,0.92126,0.70079,0.92913,0.70079,0.93701,0.70079,0.94488,0.70079,0.95276,0.70079,0.96063,0.70079,0.9685,0.70079,0.97638,0.70079,0.98425,0.70079,0.99213,0.70079,0.99609,0.70079,0.00391,0.70866,0.00787,0.70866,0.01575,0.70866,0.02362,0.70866,0.0315,0.70866,0.03937,0.70866,0.04724,0.70866,0.05512,0.70866,0.06299,0.70866,0.07087,0.70866,0.07874,0.70866,0.08661,0.70866,0.09449,0.70866,0.10236,0.70866,0.11024,0.70866,0.11811,0.70866,0.12598,0.70866,0.13386,0.70866,0.14173,0.70866,0.14961,0.70866,0.15748,0.70866,0.16535,0.70866,0.17323,0.70866,0.1811,0.70866,0.18898,0.70866,0.19685,0.70866,0.20472,0.70866,0.2126,0.70866,0.22047,0.70866,0.22835,0.70866,0.23622,0.70866,0.24409,0.70866,0.25197,0.70866,0.25984,0.70866,0.26772,0.70866,0.27559,0.70866,0.28346,0.70866,0.29134,0.70866,0.29921,0.70866,0.30709,0.70866,0.31496,0.70866,0.32283,0.70866,0.33071,0.70866,0.33858,0.70866,0.34646,0.70866,0.35433,0.70866,0.3622,0.70866,0.37008,0.70866,0.37795,0.70866,0.38583,0.70866,0.3937,0.70866,0.40157,0.70866,0.40945,0.70866,0.41732,0.70866,0.4252,0.70866,0.43307,0.70866,0.44094,0.70866,0.44882,0.70866,0.45669,0.70866,0.46457,0.70866,0.47244,0.70866,0.48031,0.70866,0.48819,0.70866,0.49606,0.70866,0.50394,0.70866,0.51181,0.70866,0.51969,0.70866,0.52756,0.70866,0.53543,0.70866,0.54331,0.70866,0.55118,0.70866,0.55906,0.70866,0.56693,0.70866,0.5748,0.70866,0.58268,0.70866,0.59055,0.70866,0.59843,0.70866,0.6063,0.70866,0.61417,0.70866,0.62205,0.70866};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_117()
		{
			double[] value = {0.62992,0.70866,0.6378,0.70866,0.64567,0.70866,0.65354,0.70866,0.66142,0.70866,0.66929,0.70866,0.67717,0.70866,0.68504,0.70866,0.69291,0.70866,0.70079,0.70866,0.70866,0.70866,0.71654,0.70866,0.72441,0.70866,0.73228,0.70866,0.74016,0.70866,0.74803,0.70866,0.75591,0.70866,0.76378,0.70866,0.77165,0.70866,0.77953,0.70866,0.7874,0.70866,0.79528,0.70866,0.80315,0.70866,0.81102,0.70866,0.8189,0.70866,0.82677,0.70866,0.83465,0.70866,0.84252,0.70866,0.85039,0.70866,0.85827,0.70866,0.86614,0.70866,0.87402,0.70866,0.88189,0.70866,0.88976,0.70866,0.89764,0.70866,0.90551,0.70866,0.91339,0.70866,0.92126,0.70866,0.92913,0.70866,0.93701,0.70866,0.94488,0.70866,0.95276,0.70866,0.96063,0.70866,0.9685,0.70866,0.97638,0.70866,0.98425,0.70866,0.99213,0.70866,0.99609,0.70866,0.00391,0.71654,0.00787,0.71654,0.01575,0.71654,0.02362,0.71654,0.0315,0.71654,0.03937,0.71654,0.04724,0.71654,0.05512,0.71654,0.06299,0.71654,0.07087,0.71654,0.07874,0.71654,0.08661,0.71654,0.09449,0.71654,0.10236,0.71654,0.11024,0.71654,0.11811,0.71654,0.12598,0.71654,0.13386,0.71654,0.14173,0.71654,0.14961,0.71654,0.15748,0.71654,0.16535,0.71654,0.17323,0.71654,0.1811,0.71654,0.18898,0.71654,0.19685,0.71654,0.20472,0.71654,0.2126,0.71654,0.22047,0.71654,0.22835,0.71654,0.23622,0.71654,0.24409,0.71654,0.25197,0.71654,0.25984,0.71654,0.26772,0.71654,0.27559,0.71654,0.28346,0.71654,0.29134,0.71654,0.29921,0.71654,0.30709,0.71654,0.31496,0.71654,0.32283,0.71654,0.33071,0.71654,0.33858,0.71654,0.34646,0.71654,0.35433,0.71654,0.3622,0.71654,0.37008,0.71654,0.37795,0.71654,0.38583,0.71654,0.3937,0.71654,0.40157,0.71654};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_118()
		{
			double[] value = {0.40945,0.71654,0.41732,0.71654,0.4252,0.71654,0.43307,0.71654,0.44094,0.71654,0.44882,0.71654,0.45669,0.71654,0.46457,0.71654,0.47244,0.71654,0.48031,0.71654,0.48819,0.71654,0.49606,0.71654,0.50394,0.71654,0.51181,0.71654,0.51969,0.71654,0.52756,0.71654,0.53543,0.71654,0.54331,0.71654,0.55118,0.71654,0.55906,0.71654,0.56693,0.71654,0.5748,0.71654,0.58268,0.71654,0.59055,0.71654,0.59843,0.71654,0.6063,0.71654,0.61417,0.71654,0.62205,0.71654,0.62992,0.71654,0.6378,0.71654,0.64567,0.71654,0.65354,0.71654,0.66142,0.71654,0.66929,0.71654,0.67717,0.71654,0.68504,0.71654,0.69291,0.71654,0.70079,0.71654,0.70866,0.71654,0.71654,0.71654,0.72441,0.71654,0.73228,0.71654,0.74016,0.71654,0.74803,0.71654,0.75591,0.71654,0.76378,0.71654,0.77165,0.71654,0.77953,0.71654,0.7874,0.71654,0.79528,0.71654,0.80315,0.71654,0.81102,0.71654,0.8189,0.71654,0.82677,0.71654,0.83465,0.71654,0.84252,0.71654,0.85039,0.71654,0.85827,0.71654,0.86614,0.71654,0.87402,0.71654,0.88189,0.71654,0.88976,0.71654,0.89764,0.71654,0.90551,0.71654,0.91339,0.71654,0.92126,0.71654,0.92913,0.71654,0.93701,0.71654,0.94488,0.71654,0.95276,0.71654,0.96063,0.71654,0.9685,0.71654,0.97638,0.71654,0.98425,0.71654,0.99213,0.71654,0.99609,0.71654,0.00391,0.72441,0.00787,0.72441,0.01575,0.72441,0.02362,0.72441,0.0315,0.72441,0.03937,0.72441,0.04724,0.72441,0.05512,0.72441,0.06299,0.72441,0.07087,0.72441,0.07874,0.72441,0.08661,0.72441,0.09449,0.72441,0.10236,0.72441,0.11024,0.72441,0.11811,0.72441,0.12598,0.72441,0.13386,0.72441,0.14173,0.72441,0.14961,0.72441,0.15748,0.72441,0.16535,0.72441,0.17323,0.72441,0.1811,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_119()
		{
			double[] value = {0.18898,0.72441,0.19685,0.72441,0.20472,0.72441,0.2126,0.72441,0.22047,0.72441,0.22835,0.72441,0.23622,0.72441,0.24409,0.72441,0.25197,0.72441,0.25984,0.72441,0.26772,0.72441,0.27559,0.72441,0.28346,0.72441,0.29134,0.72441,0.29921,0.72441,0.30709,0.72441,0.31496,0.72441,0.32283,0.72441,0.33071,0.72441,0.33858,0.72441,0.34646,0.72441,0.35433,0.72441,0.3622,0.72441,0.37008,0.72441,0.37795,0.72441,0.38583,0.72441,0.3937,0.72441,0.40157,0.72441,0.40945,0.72441,0.41732,0.72441,0.4252,0.72441,0.43307,0.72441,0.44094,0.72441,0.44882,0.72441,0.45669,0.72441,0.46457,0.72441,0.47244,0.72441,0.48031,0.72441,0.48819,0.72441,0.49606,0.72441,0.50394,0.72441,0.51181,0.72441,0.51969,0.72441,0.52756,0.72441,0.53543,0.72441,0.54331,0.72441,0.55118,0.72441,0.55906,0.72441,0.56693,0.72441,0.5748,0.72441,0.58268,0.72441,0.59055,0.72441,0.59843,0.72441,0.6063,0.72441,0.61417,0.72441,0.62205,0.72441,0.62992,0.72441,0.6378,0.72441,0.64567,0.72441,0.65354,0.72441,0.66142,0.72441,0.66929,0.72441,0.67717,0.72441,0.68504,0.72441,0.69291,0.72441,0.70079,0.72441,0.70866,0.72441,0.71654,0.72441,0.72441,0.72441,0.73228,0.72441,0.74016,0.72441,0.74803,0.72441,0.75591,0.72441,0.76378,0.72441,0.77165,0.72441,0.77953,0.72441,0.7874,0.72441,0.79528,0.72441,0.80315,0.72441,0.81102,0.72441,0.8189,0.72441,0.82677,0.72441,0.83465,0.72441,0.84252,0.72441,0.85039,0.72441,0.85827,0.72441,0.86614,0.72441,0.87402,0.72441,0.88189,0.72441,0.88976,0.72441,0.89764,0.72441,0.90551,0.72441,0.91339,0.72441,0.92126,0.72441,0.92913,0.72441,0.93701,0.72441,0.94488,0.72441,0.95276,0.72441,0.96063,0.72441,0.9685,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_120()
		{
			double[] value = {0.97638,0.72441,0.98425,0.72441,0.99213,0.72441,0.99609,0.72441,0.00391,0.73228,0.00787,0.73228,0.01575,0.73228,0.02362,0.73228,0.0315,0.73228,0.03937,0.73228,0.04724,0.73228,0.05512,0.73228,0.06299,0.73228,0.07087,0.73228,0.07874,0.73228,0.08661,0.73228,0.09449,0.73228,0.10236,0.73228,0.11024,0.73228,0.11811,0.73228,0.12598,0.73228,0.13386,0.73228,0.14173,0.73228,0.14961,0.73228,0.15748,0.73228,0.16535,0.73228,0.17323,0.73228,0.1811,0.73228,0.18898,0.73228,0.19685,0.73228,0.20472,0.73228,0.2126,0.73228,0.22047,0.73228,0.22835,0.73228,0.23622,0.73228,0.24409,0.73228,0.25197,0.73228,0.25984,0.73228,0.26772,0.73228,0.27559,0.73228,0.28346,0.73228,0.29134,0.73228,0.29921,0.73228,0.30709,0.73228,0.31496,0.73228,0.32283,0.73228,0.33071,0.73228,0.33858,0.73228,0.34646,0.73228,0.35433,0.73228,0.3622,0.73228,0.37008,0.73228,0.37795,0.73228,0.38583,0.73228,0.3937,0.73228,0.40157,0.73228,0.40945,0.73228,0.41732,0.73228,0.4252,0.73228,0.43307,0.73228,0.44094,0.73228,0.44882,0.73228,0.45669,0.73228,0.46457,0.73228,0.47244,0.73228,0.48031,0.73228,0.48819,0.73228,0.49606,0.73228,0.50394,0.73228,0.51181,0.73228,0.51969,0.73228,0.52756,0.73228,0.53543,0.73228,0.54331,0.73228,0.55118,0.73228,0.55906,0.73228,0.56693,0.73228,0.5748,0.73228,0.58268,0.73228,0.59055,0.73228,0.59843,0.73228,0.6063,0.73228,0.61417,0.73228,0.62205,0.73228,0.62992,0.73228,0.6378,0.73228,0.64567,0.73228,0.65354,0.73228,0.66142,0.73228,0.66929,0.73228,0.67717,0.73228,0.68504,0.73228,0.69291,0.73228,0.70079,0.73228,0.70866,0.73228,0.71654,0.73228,0.72441,0.73228,0.73228,0.73228,0.74016,0.73228,0.74803,0.73228};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_121()
		{
			double[] value = {0.75591,0.73228,0.76378,0.73228,0.77165,0.73228,0.77953,0.73228,0.7874,0.73228,0.79528,0.73228,0.80315,0.73228,0.81102,0.73228,0.8189,0.73228,0.82677,0.73228,0.83465,0.73228,0.84252,0.73228,0.85039,0.73228,0.85827,0.73228,0.86614,0.73228,0.87402,0.73228,0.88189,0.73228,0.88976,0.73228,0.89764,0.73228,0.90551,0.73228,0.91339,0.73228,0.92126,0.73228,0.92913,0.73228,0.93701,0.73228,0.94488,0.73228,0.95276,0.73228,0.96063,0.73228,0.9685,0.73228,0.97638,0.73228,0.98425,0.73228,0.99213,0.73228,0.99609,0.73228,0.00391,0.74016,0.00787,0.74016,0.01575,0.74016,0.02362,0.74016,0.0315,0.74016,0.03937,0.74016,0.04724,0.74016,0.05512,0.74016,0.06299,0.74016,0.07087,0.74016,0.07874,0.74016,0.08661,0.74016,0.09449,0.74016,0.10236,0.74016,0.11024,0.74016,0.11811,0.74016,0.12598,0.74016,0.13386,0.74016,0.14173,0.74016,0.14961,0.74016,0.15748,0.74016,0.16535,0.74016,0.17323,0.74016,0.1811,0.74016,0.18898,0.74016,0.19685,0.74016,0.20472,0.74016,0.2126,0.74016,0.22047,0.74016,0.22835,0.74016,0.23622,0.74016,0.24409,0.74016,0.25197,0.74016,0.25984,0.74016,0.26772,0.74016,0.27559,0.74016,0.28346,0.74016,0.29134,0.74016,0.29921,0.74016,0.30709,0.74016,0.31496,0.74016,0.32283,0.74016,0.33071,0.74016,0.33858,0.74016,0.34646,0.74016,0.35433,0.74016,0.3622,0.74016,0.37008,0.74016,0.37795,0.74016,0.38583,0.74016,0.3937,0.74016,0.40157,0.74016,0.40945,0.74016,0.41732,0.74016,0.4252,0.74016,0.43307,0.74016,0.44094,0.74016,0.44882,0.74016,0.45669,0.74016,0.46457,0.74016,0.47244,0.74016,0.48031,0.74016,0.48819,0.74016,0.49606,0.74016,0.50394,0.74016,0.51181,0.74016,0.51969,0.74016,0.52756,0.74016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_122()
		{
			double[] value = {0.53543,0.74016,0.54331,0.74016,0.55118,0.74016,0.55906,0.74016,0.56693,0.74016,0.5748,0.74016,0.58268,0.74016,0.59055,0.74016,0.59843,0.74016,0.6063,0.74016,0.61417,0.74016,0.62205,0.74016,0.62992,0.74016,0.6378,0.74016,0.64567,0.74016,0.65354,0.74016,0.66142,0.74016,0.66929,0.74016,0.67717,0.74016,0.68504,0.74016,0.69291,0.74016,0.70079,0.74016,0.70866,0.74016,0.71654,0.74016,0.72441,0.74016,0.73228,0.74016,0.74016,0.74016,0.74803,0.74016,0.75591,0.74016,0.76378,0.74016,0.77165,0.74016,0.77953,0.74016,0.7874,0.74016,0.79528,0.74016,0.80315,0.74016,0.81102,0.74016,0.8189,0.74016,0.82677,0.74016,0.83465,0.74016,0.84252,0.74016,0.85039,0.74016,0.85827,0.74016,0.86614,0.74016,0.87402,0.74016,0.88189,0.74016,0.88976,0.74016,0.89764,0.74016,0.90551,0.74016,0.91339,0.74016,0.92126,0.74016,0.92913,0.74016,0.93701,0.74016,0.94488,0.74016,0.95276,0.74016,0.96063,0.74016,0.9685,0.74016,0.97638,0.74016,0.98425,0.74016,0.99213,0.74016,0.99609,0.74016,0.00391,0.74803,0.00787,0.74803,0.01575,0.74803,0.02362,0.74803,0.0315,0.74803,0.03937,0.74803,0.04724,0.74803,0.05512,0.74803,0.06299,0.74803,0.07087,0.74803,0.07874,0.74803,0.08661,0.74803,0.09449,0.74803,0.10236,0.74803,0.11024,0.74803,0.11811,0.74803,0.12598,0.74803,0.13386,0.74803,0.14173,0.74803,0.14961,0.74803,0.15748,0.74803,0.16535,0.74803,0.17323,0.74803,0.1811,0.74803,0.18898,0.74803,0.19685,0.74803,0.20472,0.74803,0.2126,0.74803,0.22047,0.74803,0.22835,0.74803,0.23622,0.74803,0.24409,0.74803,0.25197,0.74803,0.25984,0.74803,0.26772,0.74803,0.27559,0.74803,0.28346,0.74803,0.29134,0.74803,0.29921,0.74803,0.30709,0.74803};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_123()
		{
			double[] value = {0.31496,0.74803,0.32283,0.74803,0.33071,0.74803,0.33858,0.74803,0.34646,0.74803,0.35433,0.74803,0.3622,0.74803,0.37008,0.74803,0.37795,0.74803,0.38583,0.74803,0.3937,0.74803,0.40157,0.74803,0.40945,0.74803,0.41732,0.74803,0.4252,0.74803,0.43307,0.74803,0.44094,0.74803,0.44882,0.74803,0.45669,0.74803,0.46457,0.74803,0.47244,0.74803,0.48031,0.74803,0.48819,0.74803,0.49606,0.74803,0.50394,0.74803,0.51181,0.74803,0.51969,0.74803,0.52756,0.74803,0.53543,0.74803,0.54331,0.74803,0.55118,0.74803,0.55906,0.74803,0.56693,0.74803,0.5748,0.74803,0.58268,0.74803,0.59055,0.74803,0.59843,0.74803,0.6063,0.74803,0.61417,0.74803,0.62205,0.74803,0.62992,0.74803,0.6378,0.74803,0.64567,0.74803,0.65354,0.74803,0.66142,0.74803,0.66929,0.74803,0.67717,0.74803,0.68504,0.74803,0.69291,0.74803,0.70079,0.74803,0.70866,0.74803,0.71654,0.74803,0.72441,0.74803,0.73228,0.74803,0.74016,0.74803,0.74803,0.74803,0.75591,0.74803,0.76378,0.74803,0.77165,0.74803,0.77953,0.74803,0.7874,0.74803,0.79528,0.74803,0.80315,0.74803,0.81102,0.74803,0.8189,0.74803,0.82677,0.74803,0.83465,0.74803,0.84252,0.74803,0.85039,0.74803,0.85827,0.74803,0.86614,0.74803,0.87402,0.74803,0.88189,0.74803,0.88976,0.74803,0.89764,0.74803,0.90551,0.74803,0.91339,0.74803,0.92126,0.74803,0.92913,0.74803,0.93701,0.74803,0.94488,0.74803,0.95276,0.74803,0.96063,0.74803,0.9685,0.74803,0.97638,0.74803,0.98425,0.74803,0.99213,0.74803,0.99609,0.74803,0.00391,0.75591,0.00787,0.75591,0.01575,0.75591,0.02362,0.75591,0.0315,0.75591,0.03937,0.75591,0.04724,0.75591,0.05512,0.75591,0.06299,0.75591,0.07087,0.75591,0.07874,0.75591,0.08661,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_124()
		{
			double[] value = {0.09449,0.75591,0.10236,0.75591,0.11024,0.75591,0.11811,0.75591,0.12598,0.75591,0.13386,0.75591,0.14173,0.75591,0.14961,0.75591,0.15748,0.75591,0.16535,0.75591,0.17323,0.75591,0.1811,0.75591,0.18898,0.75591,0.19685,0.75591,0.20472,0.75591,0.2126,0.75591,0.22047,0.75591,0.22835,0.75591,0.23622,0.75591,0.24409,0.75591,0.25197,0.75591,0.25984,0.75591,0.26772,0.75591,0.27559,0.75591,0.28346,0.75591,0.29134,0.75591,0.29921,0.75591,0.30709,0.75591,0.31496,0.75591,0.32283,0.75591,0.33071,0.75591,0.33858,0.75591,0.34646,0.75591,0.35433,0.75591,0.3622,0.75591,0.37008,0.75591,0.37795,0.75591,0.38583,0.75591,0.3937,0.75591,0.40157,0.75591,0.40945,0.75591,0.41732,0.75591,0.4252,0.75591,0.43307,0.75591,0.44094,0.75591,0.44882,0.75591,0.45669,0.75591,0.46457,0.75591,0.47244,0.75591,0.48031,0.75591,0.48819,0.75591,0.49606,0.75591,0.50394,0.75591,0.51181,0.75591,0.51969,0.75591,0.52756,0.75591,0.53543,0.75591,0.54331,0.75591,0.55118,0.75591,0.55906,0.75591,0.56693,0.75591,0.5748,0.75591,0.58268,0.75591,0.59055,0.75591,0.59843,0.75591,0.6063,0.75591,0.61417,0.75591,0.62205,0.75591,0.62992,0.75591,0.6378,0.75591,0.64567,0.75591,0.65354,0.75591,0.66142,0.75591,0.66929,0.75591,0.67717,0.75591,0.68504,0.75591,0.69291,0.75591,0.70079,0.75591,0.70866,0.75591,0.71654,0.75591,0.72441,0.75591,0.73228,0.75591,0.74016,0.75591,0.74803,0.75591,0.75591,0.75591,0.76378,0.75591,0.77165,0.75591,0.77953,0.75591,0.7874,0.75591,0.79528,0.75591,0.80315,0.75591,0.81102,0.75591,0.8189,0.75591,0.82677,0.75591,0.83465,0.75591,0.84252,0.75591,0.85039,0.75591,0.85827,0.75591,0.86614,0.75591,0.87402,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_125()
		{
			double[] value = {0.88189,0.75591,0.88976,0.75591,0.89764,0.75591,0.90551,0.75591,0.91339,0.75591,0.92126,0.75591,0.92913,0.75591,0.93701,0.75591,0.94488,0.75591,0.95276,0.75591,0.96063,0.75591,0.9685,0.75591,0.97638,0.75591,0.98425,0.75591,0.99213,0.75591,0.99609,0.75591,0.00391,0.76378,0.00787,0.76378,0.01575,0.76378,0.02362,0.76378,0.0315,0.76378,0.03937,0.76378,0.04724,0.76378,0.05512,0.76378,0.06299,0.76378,0.07087,0.76378,0.07874,0.76378,0.08661,0.76378,0.09449,0.76378,0.10236,0.76378,0.11024,0.76378,0.11811,0.76378,0.12598,0.76378,0.13386,0.76378,0.14173,0.76378,0.14961,0.76378,0.15748,0.76378,0.16535,0.76378,0.17323,0.76378,0.1811,0.76378,0.18898,0.76378,0.19685,0.76378,0.20472,0.76378,0.2126,0.76378,0.22047,0.76378,0.22835,0.76378,0.23622,0.76378,0.24409,0.76378,0.25197,0.76378,0.25984,0.76378,0.26772,0.76378,0.27559,0.76378,0.28346,0.76378,0.29134,0.76378,0.29921,0.76378,0.30709,0.76378,0.31496,0.76378,0.32283,0.76378,0.33071,0.76378,0.33858,0.76378,0.34646,0.76378,0.35433,0.76378,0.3622,0.76378,0.37008,0.76378,0.37795,0.76378,0.38583,0.76378,0.3937,0.76378,0.40157,0.76378,0.40945,0.76378,0.41732,0.76378,0.4252,0.76378,0.43307,0.76378,0.44094,0.76378,0.44882,0.76378,0.45669,0.76378,0.46457,0.76378,0.47244,0.76378,0.48031,0.76378,0.48819,0.76378,0.49606,0.76378,0.50394,0.76378,0.51181,0.76378,0.51969,0.76378,0.52756,0.76378,0.53543,0.76378,0.54331,0.76378,0.55118,0.76378,0.55906,0.76378,0.56693,0.76378,0.5748,0.76378,0.58268,0.76378,0.59055,0.76378,0.59843,0.76378,0.6063,0.76378,0.61417,0.76378,0.62205,0.76378,0.62992,0.76378,0.6378,0.76378,0.64567,0.76378,0.65354,0.76378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_126()
		{
			double[] value = {0.66142,0.76378,0.66929,0.76378,0.67717,0.76378,0.68504,0.76378,0.69291,0.76378,0.70079,0.76378,0.70866,0.76378,0.71654,0.76378,0.72441,0.76378,0.73228,0.76378,0.74016,0.76378,0.74803,0.76378,0.75591,0.76378,0.76378,0.76378,0.77165,0.76378,0.77953,0.76378,0.7874,0.76378,0.79528,0.76378,0.80315,0.76378,0.81102,0.76378,0.8189,0.76378,0.82677,0.76378,0.83465,0.76378,0.84252,0.76378,0.85039,0.76378,0.85827,0.76378,0.86614,0.76378,0.87402,0.76378,0.88189,0.76378,0.88976,0.76378,0.89764,0.76378,0.90551,0.76378,0.91339,0.76378,0.92126,0.76378,0.92913,0.76378,0.93701,0.76378,0.94488,0.76378,0.95276,0.76378,0.96063,0.76378,0.9685,0.76378,0.97638,0.76378,0.98425,0.76378,0.99213,0.76378,0.99609,0.76378,0.00391,0.77165,0.00787,0.77165,0.01575,0.77165,0.02362,0.77165,0.0315,0.77165,0.03937,0.77165,0.04724,0.77165,0.05512,0.77165,0.06299,0.77165,0.07087,0.77165,0.07874,0.77165,0.08661,0.77165,0.09449,0.77165,0.10236,0.77165,0.11024,0.77165,0.11811,0.77165,0.12598,0.77165,0.13386,0.77165,0.14173,0.77165,0.14961,0.77165,0.15748,0.77165,0.16535,0.77165,0.17323,0.77165,0.1811,0.77165,0.18898,0.77165,0.19685,0.77165,0.20472,0.77165,0.2126,0.77165,0.22047,0.77165,0.22835,0.77165,0.23622,0.77165,0.24409,0.77165,0.25197,0.77165,0.25984,0.77165,0.26772,0.77165,0.27559,0.77165,0.28346,0.77165,0.29134,0.77165,0.29921,0.77165,0.30709,0.77165,0.31496,0.77165,0.32283,0.77165,0.33071,0.77165,0.33858,0.77165,0.34646,0.77165,0.35433,0.77165,0.3622,0.77165,0.37008,0.77165,0.37795,0.77165,0.38583,0.77165,0.3937,0.77165,0.40157,0.77165,0.40945,0.77165,0.41732,0.77165,0.4252,0.77165,0.43307,0.77165};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_127()
		{
			double[] value = {0.44094,0.77165,0.44882,0.77165,0.45669,0.77165,0.46457,0.77165,0.47244,0.77165,0.48031,0.77165,0.48819,0.77165,0.49606,0.77165,0.50394,0.77165,0.51181,0.77165,0.51969,0.77165,0.52756,0.77165,0.53543,0.77165,0.54331,0.77165,0.55118,0.77165,0.55906,0.77165,0.56693,0.77165,0.5748,0.77165,0.58268,0.77165,0.59055,0.77165,0.59843,0.77165,0.6063,0.77165,0.61417,0.77165,0.62205,0.77165,0.62992,0.77165,0.6378,0.77165,0.64567,0.77165,0.65354,0.77165,0.66142,0.77165,0.66929,0.77165,0.67717,0.77165,0.68504,0.77165,0.69291,0.77165,0.70079,0.77165,0.70866,0.77165,0.71654,0.77165,0.72441,0.77165,0.73228,0.77165,0.74016,0.77165,0.74803,0.77165,0.75591,0.77165,0.76378,0.77165,0.77165,0.77165,0.77953,0.77165,0.7874,0.77165,0.79528,0.77165,0.80315,0.77165,0.81102,0.77165,0.8189,0.77165,0.82677,0.77165,0.83465,0.77165,0.84252,0.77165,0.85039,0.77165,0.85827,0.77165,0.86614,0.77165,0.87402,0.77165,0.88189,0.77165,0.88976,0.77165,0.89764,0.77165,0.90551,0.77165,0.91339,0.77165,0.92126,0.77165,0.92913,0.77165,0.93701,0.77165,0.94488,0.77165,0.95276,0.77165,0.96063,0.77165,0.9685,0.77165,0.97638,0.77165,0.98425,0.77165,0.99213,0.77165,0.99609,0.77165,0.00391,0.77953,0.00787,0.77953,0.01575,0.77953,0.02362,0.77953,0.0315,0.77953,0.03937,0.77953,0.04724,0.77953,0.05512,0.77953,0.06299,0.77953,0.07087,0.77953,0.07874,0.77953,0.08661,0.77953,0.09449,0.77953,0.10236,0.77953,0.11024,0.77953,0.11811,0.77953,0.12598,0.77953,0.13386,0.77953,0.14173,0.77953,0.14961,0.77953,0.15748,0.77953,0.16535,0.77953,0.17323,0.77953,0.1811,0.77953,0.18898,0.77953,0.19685,0.77953,0.20472,0.77953,0.2126,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_128()
		{
			double[] value = {0.22047,0.77953,0.22835,0.77953,0.23622,0.77953,0.24409,0.77953,0.25197,0.77953,0.25984,0.77953,0.26772,0.77953,0.27559,0.77953,0.28346,0.77953,0.29134,0.77953,0.29921,0.77953,0.30709,0.77953,0.31496,0.77953,0.32283,0.77953,0.33071,0.77953,0.33858,0.77953,0.34646,0.77953,0.35433,0.77953,0.3622,0.77953,0.37008,0.77953,0.37795,0.77953,0.38583,0.77953,0.3937,0.77953,0.40157,0.77953,0.40945,0.77953,0.41732,0.77953,0.4252,0.77953,0.43307,0.77953,0.44094,0.77953,0.44882,0.77953,0.45669,0.77953,0.46457,0.77953,0.47244,0.77953,0.48031,0.77953,0.48819,0.77953,0.49606,0.77953,0.50394,0.77953,0.51181,0.77953,0.51969,0.77953,0.52756,0.77953,0.53543,0.77953,0.54331,0.77953,0.55118,0.77953,0.55906,0.77953,0.56693,0.77953,0.5748,0.77953,0.58268,0.77953,0.59055,0.77953,0.59843,0.77953,0.6063,0.77953,0.61417,0.77953,0.62205,0.77953,0.62992,0.77953,0.6378,0.77953,0.64567,0.77953,0.65354,0.77953,0.66142,0.77953,0.66929,0.77953,0.67717,0.77953,0.68504,0.77953,0.69291,0.77953,0.70079,0.77953,0.70866,0.77953,0.71654,0.77953,0.72441,0.77953,0.73228,0.77953,0.74016,0.77953,0.74803,0.77953,0.75591,0.77953,0.76378,0.77953,0.77165,0.77953,0.77953,0.77953,0.7874,0.77953,0.79528,0.77953,0.80315,0.77953,0.81102,0.77953,0.8189,0.77953,0.82677,0.77953,0.83465,0.77953,0.84252,0.77953,0.85039,0.77953,0.85827,0.77953,0.86614,0.77953,0.87402,0.77953,0.88189,0.77953,0.88976,0.77953,0.89764,0.77953,0.90551,0.77953,0.91339,0.77953,0.92126,0.77953,0.92913,0.77953,0.93701,0.77953,0.94488,0.77953,0.95276,0.77953,0.96063,0.77953,0.9685,0.77953,0.97638,0.77953,0.98425,0.77953,0.99213,0.77953,0.99609,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_129()
		{
			double[] value = {0.00391,0.7874,0.00787,0.7874,0.01575,0.7874,0.02362,0.7874,0.0315,0.7874,0.03937,0.7874,0.04724,0.7874,0.05512,0.7874,0.06299,0.7874,0.07087,0.7874,0.07874,0.7874,0.08661,0.7874,0.09449,0.7874,0.10236,0.7874,0.11024,0.7874,0.11811,0.7874,0.12598,0.7874,0.13386,0.7874,0.14173,0.7874,0.14961,0.7874,0.15748,0.7874,0.16535,0.7874,0.17323,0.7874,0.1811,0.7874,0.18898,0.7874,0.19685,0.7874,0.20472,0.7874,0.2126,0.7874,0.22047,0.7874,0.22835,0.7874,0.23622,0.7874,0.24409,0.7874,0.25197,0.7874,0.25984,0.7874,0.26772,0.7874,0.27559,0.7874,0.28346,0.7874,0.29134,0.7874,0.29921,0.7874,0.30709,0.7874,0.31496,0.7874,0.32283,0.7874,0.33071,0.7874,0.33858,0.7874,0.34646,0.7874,0.35433,0.7874,0.3622,0.7874,0.37008,0.7874,0.37795,0.7874,0.38583,0.7874,0.3937,0.7874,0.40157,0.7874,0.40945,0.7874,0.41732,0.7874,0.4252,0.7874,0.43307,0.7874,0.44094,0.7874,0.44882,0.7874,0.45669,0.7874,0.46457,0.7874,0.47244,0.7874,0.48031,0.7874,0.48819,0.7874,0.49606,0.7874,0.50394,0.7874,0.51181,0.7874,0.51969,0.7874,0.52756,0.7874,0.53543,0.7874,0.54331,0.7874,0.55118,0.7874,0.55906,0.7874,0.56693,0.7874,0.5748,0.7874,0.58268,0.7874,0.59055,0.7874,0.59843,0.7874,0.6063,0.7874,0.61417,0.7874,0.62205,0.7874,0.62992,0.7874,0.6378,0.7874,0.64567,0.7874,0.65354,0.7874,0.66142,0.7874,0.66929,0.7874,0.67717,0.7874,0.68504,0.7874,0.69291,0.7874,0.70079,0.7874,0.70866,0.7874,0.71654,0.7874,0.72441,0.7874,0.73228,0.7874,0.74016,0.7874,0.74803,0.7874,0.75591,0.7874,0.76378,0.7874,0.77165,0.7874,0.77953,0.7874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_130()
		{
			double[] value = {0.7874,0.7874,0.79528,0.7874,0.80315,0.7874,0.81102,0.7874,0.8189,0.7874,0.82677,0.7874,0.83465,0.7874,0.84252,0.7874,0.85039,0.7874,0.85827,0.7874,0.86614,0.7874,0.87402,0.7874,0.88189,0.7874,0.88976,0.7874,0.89764,0.7874,0.90551,0.7874,0.91339,0.7874,0.92126,0.7874,0.92913,0.7874,0.93701,0.7874,0.94488,0.7874,0.95276,0.7874,0.96063,0.7874,0.9685,0.7874,0.97638,0.7874,0.98425,0.7874,0.99213,0.7874,0.99609,0.7874,0.00391,0.79528,0.00787,0.79528,0.01575,0.79528,0.02362,0.79528,0.0315,0.79528,0.03937,0.79528,0.04724,0.79528,0.05512,0.79528,0.06299,0.79528,0.07087,0.79528,0.07874,0.79528,0.08661,0.79528,0.09449,0.79528,0.10236,0.79528,0.11024,0.79528,0.11811,0.79528,0.12598,0.79528,0.13386,0.79528,0.14173,0.79528,0.14961,0.79528,0.15748,0.79528,0.16535,0.79528,0.17323,0.79528,0.1811,0.79528,0.18898,0.79528,0.19685,0.79528,0.20472,0.79528,0.2126,0.79528,0.22047,0.79528,0.22835,0.79528,0.23622,0.79528,0.24409,0.79528,0.25197,0.79528,0.25984,0.79528,0.26772,0.79528,0.27559,0.79528,0.28346,0.79528,0.29134,0.79528,0.29921,0.79528,0.30709,0.79528,0.31496,0.79528,0.32283,0.79528,0.33071,0.79528,0.33858,0.79528,0.34646,0.79528,0.35433,0.79528,0.3622,0.79528,0.37008,0.79528,0.37795,0.79528,0.38583,0.79528,0.3937,0.79528,0.40157,0.79528,0.40945,0.79528,0.41732,0.79528,0.4252,0.79528,0.43307,0.79528,0.44094,0.79528,0.44882,0.79528,0.45669,0.79528,0.46457,0.79528,0.47244,0.79528,0.48031,0.79528,0.48819,0.79528,0.49606,0.79528,0.50394,0.79528,0.51181,0.79528,0.51969,0.79528,0.52756,0.79528,0.53543,0.79528,0.54331,0.79528,0.55118,0.79528,0.55906,0.79528};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_131()
		{
			double[] value = {0.56693,0.79528,0.5748,0.79528,0.58268,0.79528,0.59055,0.79528,0.59843,0.79528,0.6063,0.79528,0.61417,0.79528,0.62205,0.79528,0.62992,0.79528,0.6378,0.79528,0.64567,0.79528,0.65354,0.79528,0.66142,0.79528,0.66929,0.79528,0.67717,0.79528,0.68504,0.79528,0.69291,0.79528,0.70079,0.79528,0.70866,0.79528,0.71654,0.79528,0.72441,0.79528,0.73228,0.79528,0.74016,0.79528,0.74803,0.79528,0.75591,0.79528,0.76378,0.79528,0.77165,0.79528,0.77953,0.79528,0.7874,0.79528,0.79528,0.79528,0.80315,0.79528,0.81102,0.79528,0.8189,0.79528,0.82677,0.79528,0.83465,0.79528,0.84252,0.79528,0.85039,0.79528,0.85827,0.79528,0.86614,0.79528,0.87402,0.79528,0.88189,0.79528,0.88976,0.79528,0.89764,0.79528,0.90551,0.79528,0.91339,0.79528,0.92126,0.79528,0.92913,0.79528,0.93701,0.79528,0.94488,0.79528,0.95276,0.79528,0.96063,0.79528,0.9685,0.79528,0.97638,0.79528,0.98425,0.79528,0.99213,0.79528,0.99609,0.79528,0.00391,0.80315,0.00787,0.80315,0.01575,0.80315,0.02362,0.80315,0.0315,0.80315,0.03937,0.80315,0.04724,0.80315,0.05512,0.80315,0.06299,0.80315,0.07087,0.80315,0.07874,0.80315,0.08661,0.80315,0.09449,0.80315,0.10236,0.80315,0.11024,0.80315,0.11811,0.80315,0.12598,0.80315,0.13386,0.80315,0.14173,0.80315,0.14961,0.80315,0.15748,0.80315,0.16535,0.80315,0.17323,0.80315,0.1811,0.80315,0.18898,0.80315,0.19685,0.80315,0.20472,0.80315,0.2126,0.80315,0.22047,0.80315,0.22835,0.80315,0.23622,0.80315,0.24409,0.80315,0.25197,0.80315,0.25984,0.80315,0.26772,0.80315,0.27559,0.80315,0.28346,0.80315,0.29134,0.80315,0.29921,0.80315,0.30709,0.80315,0.31496,0.80315,0.32283,0.80315,0.33071,0.80315,0.33858,0.80315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_132()
		{
			double[] value = {0.34646,0.80315,0.35433,0.80315,0.3622,0.80315,0.37008,0.80315,0.37795,0.80315,0.38583,0.80315,0.3937,0.80315,0.40157,0.80315,0.40945,0.80315,0.41732,0.80315,0.4252,0.80315,0.43307,0.80315,0.44094,0.80315,0.44882,0.80315,0.45669,0.80315,0.46457,0.80315,0.47244,0.80315,0.48031,0.80315,0.48819,0.80315,0.49606,0.80315,0.50394,0.80315,0.51181,0.80315,0.51969,0.80315,0.52756,0.80315,0.53543,0.80315,0.54331,0.80315,0.55118,0.80315,0.55906,0.80315,0.56693,0.80315,0.5748,0.80315,0.58268,0.80315,0.59055,0.80315,0.59843,0.80315,0.6063,0.80315,0.61417,0.80315,0.62205,0.80315,0.62992,0.80315,0.6378,0.80315,0.64567,0.80315,0.65354,0.80315,0.66142,0.80315,0.66929,0.80315,0.67717,0.80315,0.68504,0.80315,0.69291,0.80315,0.70079,0.80315,0.70866,0.80315,0.71654,0.80315,0.72441,0.80315,0.73228,0.80315,0.74016,0.80315,0.74803,0.80315,0.75591,0.80315,0.76378,0.80315,0.77165,0.80315,0.77953,0.80315,0.7874,0.80315,0.79528,0.80315,0.80315,0.80315,0.81102,0.80315,0.8189,0.80315,0.82677,0.80315,0.83465,0.80315,0.84252,0.80315,0.85039,0.80315,0.85827,0.80315,0.86614,0.80315,0.87402,0.80315,0.88189,0.80315,0.88976,0.80315,0.89764,0.80315,0.90551,0.80315,0.91339,0.80315,0.92126,0.80315,0.92913,0.80315,0.93701,0.80315,0.94488,0.80315,0.95276,0.80315,0.96063,0.80315,0.9685,0.80315,0.97638,0.80315,0.98425,0.80315,0.99213,0.80315,0.99609,0.80315,0.00391,0.81102,0.00787,0.81102,0.01575,0.81102,0.02362,0.81102,0.0315,0.81102,0.03937,0.81102,0.04724,0.81102,0.05512,0.81102,0.06299,0.81102,0.07087,0.81102,0.07874,0.81102,0.08661,0.81102,0.09449,0.81102,0.10236,0.81102,0.11024,0.81102,0.11811,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_133()
		{
			double[] value = {0.12598,0.81102,0.13386,0.81102,0.14173,0.81102,0.14961,0.81102,0.15748,0.81102,0.16535,0.81102,0.17323,0.81102,0.1811,0.81102,0.18898,0.81102,0.19685,0.81102,0.20472,0.81102,0.2126,0.81102,0.22047,0.81102,0.22835,0.81102,0.23622,0.81102,0.24409,0.81102,0.25197,0.81102,0.25984,0.81102,0.26772,0.81102,0.27559,0.81102,0.28346,0.81102,0.29134,0.81102,0.29921,0.81102,0.30709,0.81102,0.31496,0.81102,0.32283,0.81102,0.33071,0.81102,0.33858,0.81102,0.34646,0.81102,0.35433,0.81102,0.3622,0.81102,0.37008,0.81102,0.37795,0.81102,0.38583,0.81102,0.3937,0.81102,0.40157,0.81102,0.40945,0.81102,0.41732,0.81102,0.4252,0.81102,0.43307,0.81102,0.44094,0.81102,0.44882,0.81102,0.45669,0.81102,0.46457,0.81102,0.47244,0.81102,0.48031,0.81102,0.48819,0.81102,0.49606,0.81102,0.50394,0.81102,0.51181,0.81102,0.51969,0.81102,0.52756,0.81102,0.53543,0.81102,0.54331,0.81102,0.55118,0.81102,0.55906,0.81102,0.56693,0.81102,0.5748,0.81102,0.58268,0.81102,0.59055,0.81102,0.59843,0.81102,0.6063,0.81102,0.61417,0.81102,0.62205,0.81102,0.62992,0.81102,0.6378,0.81102,0.64567,0.81102,0.65354,0.81102,0.66142,0.81102,0.66929,0.81102,0.67717,0.81102,0.68504,0.81102,0.69291,0.81102,0.70079,0.81102,0.70866,0.81102,0.71654,0.81102,0.72441,0.81102,0.73228,0.81102,0.74016,0.81102,0.74803,0.81102,0.75591,0.81102,0.76378,0.81102,0.77165,0.81102,0.77953,0.81102,0.7874,0.81102,0.79528,0.81102,0.80315,0.81102,0.81102,0.81102,0.8189,0.81102,0.82677,0.81102,0.83465,0.81102,0.84252,0.81102,0.85039,0.81102,0.85827,0.81102,0.86614,0.81102,0.87402,0.81102,0.88189,0.81102,0.88976,0.81102,0.89764,0.81102,0.90551,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_134()
		{
			double[] value = {0.91339,0.81102,0.92126,0.81102,0.92913,0.81102,0.93701,0.81102,0.94488,0.81102,0.95276,0.81102,0.96063,0.81102,0.9685,0.81102,0.97638,0.81102,0.98425,0.81102,0.99213,0.81102,0.99609,0.81102,0.00391,0.8189,0.00787,0.8189,0.01575,0.8189,0.02362,0.8189,0.0315,0.8189,0.03937,0.8189,0.04724,0.8189,0.05512,0.8189,0.06299,0.8189,0.07087,0.8189,0.07874,0.8189,0.08661,0.8189,0.09449,0.8189,0.10236,0.8189,0.11024,0.8189,0.11811,0.8189,0.12598,0.8189,0.13386,0.8189,0.14173,0.8189,0.14961,0.8189,0.15748,0.8189,0.16535,0.8189,0.17323,0.8189,0.1811,0.8189,0.18898,0.8189,0.19685,0.8189,0.20472,0.8189,0.2126,0.8189,0.22047,0.8189,0.22835,0.8189,0.23622,0.8189,0.24409,0.8189,0.25197,0.8189,0.25984,0.8189,0.26772,0.8189,0.27559,0.8189,0.28346,0.8189,0.29134,0.8189,0.29921,0.8189,0.30709,0.8189,0.31496,0.8189,0.32283,0.8189,0.33071,0.8189,0.33858,0.8189,0.34646,0.8189,0.35433,0.8189,0.3622,0.8189,0.37008,0.8189,0.37795,0.8189,0.38583,0.8189,0.3937,0.8189,0.40157,0.8189,0.40945,0.8189,0.41732,0.8189,0.4252,0.8189,0.43307,0.8189,0.44094,0.8189,0.44882,0.8189,0.45669,0.8189,0.46457,0.8189,0.47244,0.8189,0.48031,0.8189,0.48819,0.8189,0.49606,0.8189,0.50394,0.8189,0.51181,0.8189,0.51969,0.8189,0.52756,0.8189,0.53543,0.8189,0.54331,0.8189,0.55118,0.8189,0.55906,0.8189,0.56693,0.8189,0.5748,0.8189,0.58268,0.8189,0.59055,0.8189,0.59843,0.8189,0.6063,0.8189,0.61417,0.8189,0.62205,0.8189,0.62992,0.8189,0.6378,0.8189,0.64567,0.8189,0.65354,0.8189,0.66142,0.8189,0.66929,0.8189,0.67717,0.8189,0.68504,0.8189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_135()
		{
			double[] value = {0.69291,0.8189,0.70079,0.8189,0.70866,0.8189,0.71654,0.8189,0.72441,0.8189,0.73228,0.8189,0.74016,0.8189,0.74803,0.8189,0.75591,0.8189,0.76378,0.8189,0.77165,0.8189,0.77953,0.8189,0.7874,0.8189,0.79528,0.8189,0.80315,0.8189,0.81102,0.8189,0.8189,0.8189,0.82677,0.8189,0.83465,0.8189,0.84252,0.8189,0.85039,0.8189,0.85827,0.8189,0.86614,0.8189,0.87402,0.8189,0.88189,0.8189,0.88976,0.8189,0.89764,0.8189,0.90551,0.8189,0.91339,0.8189,0.92126,0.8189,0.92913,0.8189,0.93701,0.8189,0.94488,0.8189,0.95276,0.8189,0.96063,0.8189,0.9685,0.8189,0.97638,0.8189,0.98425,0.8189,0.99213,0.8189,0.99609,0.8189,0.00391,0.82677,0.00787,0.82677,0.01575,0.82677,0.02362,0.82677,0.0315,0.82677,0.03937,0.82677,0.04724,0.82677,0.05512,0.82677,0.06299,0.82677,0.07087,0.82677,0.07874,0.82677,0.08661,0.82677,0.09449,0.82677,0.10236,0.82677,0.11024,0.82677,0.11811,0.82677,0.12598,0.82677,0.13386,0.82677,0.14173,0.82677,0.14961,0.82677,0.15748,0.82677,0.16535,0.82677,0.17323,0.82677,0.1811,0.82677,0.18898,0.82677,0.19685,0.82677,0.20472,0.82677,0.2126,0.82677,0.22047,0.82677,0.22835,0.82677,0.23622,0.82677,0.24409,0.82677,0.25197,0.82677,0.25984,0.82677,0.26772,0.82677,0.27559,0.82677,0.28346,0.82677,0.29134,0.82677,0.29921,0.82677,0.30709,0.82677,0.31496,0.82677,0.32283,0.82677,0.33071,0.82677,0.33858,0.82677,0.34646,0.82677,0.35433,0.82677,0.3622,0.82677,0.37008,0.82677,0.37795,0.82677,0.38583,0.82677,0.3937,0.82677,0.40157,0.82677,0.40945,0.82677,0.41732,0.82677,0.4252,0.82677,0.43307,0.82677,0.44094,0.82677,0.44882,0.82677,0.45669,0.82677,0.46457,0.82677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_136()
		{
			double[] value = {0.47244,0.82677,0.48031,0.82677,0.48819,0.82677,0.49606,0.82677,0.50394,0.82677,0.51181,0.82677,0.51969,0.82677,0.52756,0.82677,0.53543,0.82677,0.54331,0.82677,0.55118,0.82677,0.55906,0.82677,0.56693,0.82677,0.5748,0.82677,0.58268,0.82677,0.59055,0.82677,0.59843,0.82677,0.6063,0.82677,0.61417,0.82677,0.62205,0.82677,0.62992,0.82677,0.6378,0.82677,0.64567,0.82677,0.65354,0.82677,0.66142,0.82677,0.66929,0.82677,0.67717,0.82677,0.68504,0.82677,0.69291,0.82677,0.70079,0.82677,0.70866,0.82677,0.71654,0.82677,0.72441,0.82677,0.73228,0.82677,0.74016,0.82677,0.74803,0.82677,0.75591,0.82677,0.76378,0.82677,0.77165,0.82677,0.77953,0.82677,0.7874,0.82677,0.79528,0.82677,0.80315,0.82677,0.81102,0.82677,0.8189,0.82677,0.82677,0.82677,0.83465,0.82677,0.84252,0.82677,0.85039,0.82677,0.85827,0.82677,0.86614,0.82677,0.87402,0.82677,0.88189,0.82677,0.88976,0.82677,0.89764,0.82677,0.90551,0.82677,0.91339,0.82677,0.92126,0.82677,0.92913,0.82677,0.93701,0.82677,0.94488,0.82677,0.95276,0.82677,0.96063,0.82677,0.9685,0.82677,0.97638,0.82677,0.98425,0.82677,0.99213,0.82677,0.99609,0.82677,0.00391,0.83465,0.00787,0.83465,0.01575,0.83465,0.02362,0.83465,0.0315,0.83465,0.03937,0.83465,0.04724,0.83465,0.05512,0.83465,0.06299,0.83465,0.07087,0.83465,0.07874,0.83465,0.08661,0.83465,0.09449,0.83465,0.10236,0.83465,0.11024,0.83465,0.11811,0.83465,0.12598,0.83465,0.13386,0.83465,0.14173,0.83465,0.14961,0.83465,0.15748,0.83465,0.16535,0.83465,0.17323,0.83465,0.1811,0.83465,0.18898,0.83465,0.19685,0.83465,0.20472,0.83465,0.2126,0.83465,0.22047,0.83465,0.22835,0.83465,0.23622,0.83465,0.24409,0.83465};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_137()
		{
			double[] value = {0.25197,0.83465,0.25984,0.83465,0.26772,0.83465,0.27559,0.83465,0.28346,0.83465,0.29134,0.83465,0.29921,0.83465,0.30709,0.83465,0.31496,0.83465,0.32283,0.83465,0.33071,0.83465,0.33858,0.83465,0.34646,0.83465,0.35433,0.83465,0.3622,0.83465,0.37008,0.83465,0.37795,0.83465,0.38583,0.83465,0.3937,0.83465,0.40157,0.83465,0.40945,0.83465,0.41732,0.83465,0.4252,0.83465,0.43307,0.83465,0.44094,0.83465,0.44882,0.83465,0.45669,0.83465,0.46457,0.83465,0.47244,0.83465,0.48031,0.83465,0.48819,0.83465,0.49606,0.83465,0.50394,0.83465,0.51181,0.83465,0.51969,0.83465,0.52756,0.83465,0.53543,0.83465,0.54331,0.83465,0.55118,0.83465,0.55906,0.83465,0.56693,0.83465,0.5748,0.83465,0.58268,0.83465,0.59055,0.83465,0.59843,0.83465,0.6063,0.83465,0.61417,0.83465,0.62205,0.83465,0.62992,0.83465,0.6378,0.83465,0.64567,0.83465,0.65354,0.83465,0.66142,0.83465,0.66929,0.83465,0.67717,0.83465,0.68504,0.83465,0.69291,0.83465,0.70079,0.83465,0.70866,0.83465,0.71654,0.83465,0.72441,0.83465,0.73228,0.83465,0.74016,0.83465,0.74803,0.83465,0.75591,0.83465,0.76378,0.83465,0.77165,0.83465,0.77953,0.83465,0.7874,0.83465,0.79528,0.83465,0.80315,0.83465,0.81102,0.83465,0.8189,0.83465,0.82677,0.83465,0.83465,0.83465,0.84252,0.83465,0.85039,0.83465,0.85827,0.83465,0.86614,0.83465,0.87402,0.83465,0.88189,0.83465,0.88976,0.83465,0.89764,0.83465,0.90551,0.83465,0.91339,0.83465,0.92126,0.83465,0.92913,0.83465,0.93701,0.83465,0.94488,0.83465,0.95276,0.83465,0.96063,0.83465,0.9685,0.83465,0.97638,0.83465,0.98425,0.83465,0.99213,0.83465,0.99609,0.83465,0.00391,0.84252,0.00787,0.84252,0.01575,0.84252,0.02362,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_138()
		{
			double[] value = {0.0315,0.84252,0.03937,0.84252,0.04724,0.84252,0.05512,0.84252,0.06299,0.84252,0.07087,0.84252,0.07874,0.84252,0.08661,0.84252,0.09449,0.84252,0.10236,0.84252,0.11024,0.84252,0.11811,0.84252,0.12598,0.84252,0.13386,0.84252,0.14173,0.84252,0.14961,0.84252,0.15748,0.84252,0.16535,0.84252,0.17323,0.84252,0.1811,0.84252,0.18898,0.84252,0.19685,0.84252,0.20472,0.84252,0.2126,0.84252,0.22047,0.84252,0.22835,0.84252,0.23622,0.84252,0.24409,0.84252,0.25197,0.84252,0.25984,0.84252,0.26772,0.84252,0.27559,0.84252,0.28346,0.84252,0.29134,0.84252,0.29921,0.84252,0.30709,0.84252,0.31496,0.84252,0.32283,0.84252,0.33071,0.84252,0.33858,0.84252,0.34646,0.84252,0.35433,0.84252,0.3622,0.84252,0.37008,0.84252,0.37795,0.84252,0.38583,0.84252,0.3937,0.84252,0.40157,0.84252,0.40945,0.84252,0.41732,0.84252,0.4252,0.84252,0.43307,0.84252,0.44094,0.84252,0.44882,0.84252,0.45669,0.84252,0.46457,0.84252,0.47244,0.84252,0.48031,0.84252,0.48819,0.84252,0.49606,0.84252,0.50394,0.84252,0.51181,0.84252,0.51969,0.84252,0.52756,0.84252,0.53543,0.84252,0.54331,0.84252,0.55118,0.84252,0.55906,0.84252,0.56693,0.84252,0.5748,0.84252,0.58268,0.84252,0.59055,0.84252,0.59843,0.84252,0.6063,0.84252,0.61417,0.84252,0.62205,0.84252,0.62992,0.84252,0.6378,0.84252,0.64567,0.84252,0.65354,0.84252,0.66142,0.84252,0.66929,0.84252,0.67717,0.84252,0.68504,0.84252,0.69291,0.84252,0.70079,0.84252,0.70866,0.84252,0.71654,0.84252,0.72441,0.84252,0.73228,0.84252,0.74016,0.84252,0.74803,0.84252,0.75591,0.84252,0.76378,0.84252,0.77165,0.84252,0.77953,0.84252,0.7874,0.84252,0.79528,0.84252,0.80315,0.84252,0.81102,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_139()
		{
			double[] value = {0.8189,0.84252,0.82677,0.84252,0.83465,0.84252,0.84252,0.84252,0.85039,0.84252,0.85827,0.84252,0.86614,0.84252,0.87402,0.84252,0.88189,0.84252,0.88976,0.84252,0.89764,0.84252,0.90551,0.84252,0.91339,0.84252,0.92126,0.84252,0.92913,0.84252,0.93701,0.84252,0.94488,0.84252,0.95276,0.84252,0.96063,0.84252,0.9685,0.84252,0.97638,0.84252,0.98425,0.84252,0.99213,0.84252,0.99609,0.84252,0.00391,0.85039,0.00787,0.85039,0.01575,0.85039,0.02362,0.85039,0.0315,0.85039,0.03937,0.85039,0.04724,0.85039,0.05512,0.85039,0.06299,0.85039,0.07087,0.85039,0.07874,0.85039,0.08661,0.85039,0.09449,0.85039,0.10236,0.85039,0.11024,0.85039,0.11811,0.85039,0.12598,0.85039,0.13386,0.85039,0.14173,0.85039,0.14961,0.85039,0.15748,0.85039,0.16535,0.85039,0.17323,0.85039,0.1811,0.85039,0.18898,0.85039,0.19685,0.85039,0.20472,0.85039,0.2126,0.85039,0.22047,0.85039,0.22835,0.85039,0.23622,0.85039,0.24409,0.85039,0.25197,0.85039,0.25984,0.85039,0.26772,0.85039,0.27559,0.85039,0.28346,0.85039,0.29134,0.85039,0.29921,0.85039,0.30709,0.85039,0.31496,0.85039,0.32283,0.85039,0.33071,0.85039,0.33858,0.85039,0.34646,0.85039,0.35433,0.85039,0.3622,0.85039,0.37008,0.85039,0.37795,0.85039,0.38583,0.85039,0.3937,0.85039,0.40157,0.85039,0.40945,0.85039,0.41732,0.85039,0.4252,0.85039,0.43307,0.85039,0.44094,0.85039,0.44882,0.85039,0.45669,0.85039,0.46457,0.85039,0.47244,0.85039,0.48031,0.85039,0.48819,0.85039,0.49606,0.85039,0.50394,0.85039,0.51181,0.85039,0.51969,0.85039,0.52756,0.85039,0.53543,0.85039,0.54331,0.85039,0.55118,0.85039,0.55906,0.85039,0.56693,0.85039,0.5748,0.85039,0.58268,0.85039,0.59055,0.85039};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_140()
		{
			double[] value = {0.59843,0.85039,0.6063,0.85039,0.61417,0.85039,0.62205,0.85039,0.62992,0.85039,0.6378,0.85039,0.64567,0.85039,0.65354,0.85039,0.66142,0.85039,0.66929,0.85039,0.67717,0.85039,0.68504,0.85039,0.69291,0.85039,0.70079,0.85039,0.70866,0.85039,0.71654,0.85039,0.72441,0.85039,0.73228,0.85039,0.74016,0.85039,0.74803,0.85039,0.75591,0.85039,0.76378,0.85039,0.77165,0.85039,0.77953,0.85039,0.7874,0.85039,0.79528,0.85039,0.80315,0.85039,0.81102,0.85039,0.8189,0.85039,0.82677,0.85039,0.83465,0.85039,0.84252,0.85039,0.85039,0.85039,0.85827,0.85039,0.86614,0.85039,0.87402,0.85039,0.88189,0.85039,0.88976,0.85039,0.89764,0.85039,0.90551,0.85039,0.91339,0.85039,0.92126,0.85039,0.92913,0.85039,0.93701,0.85039,0.94488,0.85039,0.95276,0.85039,0.96063,0.85039,0.9685,0.85039,0.97638,0.85039,0.98425,0.85039,0.99213,0.85039,0.99609,0.85039,0.00391,0.85827,0.00787,0.85827,0.01575,0.85827,0.02362,0.85827,0.0315,0.85827,0.03937,0.85827,0.04724,0.85827,0.05512,0.85827,0.06299,0.85827,0.07087,0.85827,0.07874,0.85827,0.08661,0.85827,0.09449,0.85827,0.10236,0.85827,0.11024,0.85827,0.11811,0.85827,0.12598,0.85827,0.13386,0.85827,0.14173,0.85827,0.14961,0.85827,0.15748,0.85827,0.16535,0.85827,0.17323,0.85827,0.1811,0.85827,0.18898,0.85827,0.19685,0.85827,0.20472,0.85827,0.2126,0.85827,0.22047,0.85827,0.22835,0.85827,0.23622,0.85827,0.24409,0.85827,0.25197,0.85827,0.25984,0.85827,0.26772,0.85827,0.27559,0.85827,0.28346,0.85827,0.29134,0.85827,0.29921,0.85827,0.30709,0.85827,0.31496,0.85827,0.32283,0.85827,0.33071,0.85827,0.33858,0.85827,0.34646,0.85827,0.35433,0.85827,0.3622,0.85827,0.37008,0.85827};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_141()
		{
			double[] value = {0.37795,0.85827,0.38583,0.85827,0.3937,0.85827,0.40157,0.85827,0.40945,0.85827,0.41732,0.85827,0.4252,0.85827,0.43307,0.85827,0.44094,0.85827,0.44882,0.85827,0.45669,0.85827,0.46457,0.85827,0.47244,0.85827,0.48031,0.85827,0.48819,0.85827,0.49606,0.85827,0.50394,0.85827,0.51181,0.85827,0.51969,0.85827,0.52756,0.85827,0.53543,0.85827,0.54331,0.85827,0.55118,0.85827,0.55906,0.85827,0.56693,0.85827,0.5748,0.85827,0.58268,0.85827,0.59055,0.85827,0.59843,0.85827,0.6063,0.85827,0.61417,0.85827,0.62205,0.85827,0.62992,0.85827,0.6378,0.85827,0.64567,0.85827,0.65354,0.85827,0.66142,0.85827,0.66929,0.85827,0.67717,0.85827,0.68504,0.85827,0.69291,0.85827,0.70079,0.85827,0.70866,0.85827,0.71654,0.85827,0.72441,0.85827,0.73228,0.85827,0.74016,0.85827,0.74803,0.85827,0.75591,0.85827,0.76378,0.85827,0.77165,0.85827,0.77953,0.85827,0.7874,0.85827,0.79528,0.85827,0.80315,0.85827,0.81102,0.85827,0.8189,0.85827,0.82677,0.85827,0.83465,0.85827,0.84252,0.85827,0.85039,0.85827,0.85827,0.85827,0.86614,0.85827,0.87402,0.85827,0.88189,0.85827,0.88976,0.85827,0.89764,0.85827,0.90551,0.85827,0.91339,0.85827,0.92126,0.85827,0.92913,0.85827,0.93701,0.85827,0.94488,0.85827,0.95276,0.85827,0.96063,0.85827,0.9685,0.85827,0.97638,0.85827,0.98425,0.85827,0.99213,0.85827,0.99609,0.85827,0.00391,0.86614,0.00787,0.86614,0.01575,0.86614,0.02362,0.86614,0.0315,0.86614,0.03937,0.86614,0.04724,0.86614,0.05512,0.86614,0.06299,0.86614,0.07087,0.86614,0.07874,0.86614,0.08661,0.86614,0.09449,0.86614,0.10236,0.86614,0.11024,0.86614,0.11811,0.86614,0.12598,0.86614,0.13386,0.86614,0.14173,0.86614,0.14961,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_142()
		{
			double[] value = {0.15748,0.86614,0.16535,0.86614,0.17323,0.86614,0.1811,0.86614,0.18898,0.86614,0.19685,0.86614,0.20472,0.86614,0.2126,0.86614,0.22047,0.86614,0.22835,0.86614,0.23622,0.86614,0.24409,0.86614,0.25197,0.86614,0.25984,0.86614,0.26772,0.86614,0.27559,0.86614,0.28346,0.86614,0.29134,0.86614,0.29921,0.86614,0.30709,0.86614,0.31496,0.86614,0.32283,0.86614,0.33071,0.86614,0.33858,0.86614,0.34646,0.86614,0.35433,0.86614,0.3622,0.86614,0.37008,0.86614,0.37795,0.86614,0.38583,0.86614,0.3937,0.86614,0.40157,0.86614,0.40945,0.86614,0.41732,0.86614,0.4252,0.86614,0.43307,0.86614,0.44094,0.86614,0.44882,0.86614,0.45669,0.86614,0.46457,0.86614,0.47244,0.86614,0.48031,0.86614,0.48819,0.86614,0.49606,0.86614,0.50394,0.86614,0.51181,0.86614,0.51969,0.86614,0.52756,0.86614,0.53543,0.86614,0.54331,0.86614,0.55118,0.86614,0.55906,0.86614,0.56693,0.86614,0.5748,0.86614,0.58268,0.86614,0.59055,0.86614,0.59843,0.86614,0.6063,0.86614,0.61417,0.86614,0.62205,0.86614,0.62992,0.86614,0.6378,0.86614,0.64567,0.86614,0.65354,0.86614,0.66142,0.86614,0.66929,0.86614,0.67717,0.86614,0.68504,0.86614,0.69291,0.86614,0.70079,0.86614,0.70866,0.86614,0.71654,0.86614,0.72441,0.86614,0.73228,0.86614,0.74016,0.86614,0.74803,0.86614,0.75591,0.86614,0.76378,0.86614,0.77165,0.86614,0.77953,0.86614,0.7874,0.86614,0.79528,0.86614,0.80315,0.86614,0.81102,0.86614,0.8189,0.86614,0.82677,0.86614,0.83465,0.86614,0.84252,0.86614,0.85039,0.86614,0.85827,0.86614,0.86614,0.86614,0.87402,0.86614,0.88189,0.86614,0.88976,0.86614,0.89764,0.86614,0.90551,0.86614,0.91339,0.86614,0.92126,0.86614,0.92913,0.86614,0.93701,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_143()
		{
			double[] value = {0.94488,0.86614,0.95276,0.86614,0.96063,0.86614,0.9685,0.86614,0.97638,0.86614,0.98425,0.86614,0.99213,0.86614,0.99609,0.86614,0.00391,0.87402,0.00787,0.87402,0.01575,0.87402,0.02362,0.87402,0.0315,0.87402,0.03937,0.87402,0.04724,0.87402,0.05512,0.87402,0.06299,0.87402,0.07087,0.87402,0.07874,0.87402,0.08661,0.87402,0.09449,0.87402,0.10236,0.87402,0.11024,0.87402,0.11811,0.87402,0.12598,0.87402,0.13386,0.87402,0.14173,0.87402,0.14961,0.87402,0.15748,0.87402,0.16535,0.87402,0.17323,0.87402,0.1811,0.87402,0.18898,0.87402,0.19685,0.87402,0.20472,0.87402,0.2126,0.87402,0.22047,0.87402,0.22835,0.87402,0.23622,0.87402,0.24409,0.87402,0.25197,0.87402,0.25984,0.87402,0.26772,0.87402,0.27559,0.87402,0.28346,0.87402,0.29134,0.87402,0.29921,0.87402,0.30709,0.87402,0.31496,0.87402,0.32283,0.87402,0.33071,0.87402,0.33858,0.87402,0.34646,0.87402,0.35433,0.87402,0.3622,0.87402,0.37008,0.87402,0.37795,0.87402,0.38583,0.87402,0.3937,0.87402,0.40157,0.87402,0.40945,0.87402,0.41732,0.87402,0.4252,0.87402,0.43307,0.87402,0.44094,0.87402,0.44882,0.87402,0.45669,0.87402,0.46457,0.87402,0.47244,0.87402,0.48031,0.87402,0.48819,0.87402,0.49606,0.87402,0.50394,0.87402,0.51181,0.87402,0.51969,0.87402,0.52756,0.87402,0.53543,0.87402,0.54331,0.87402,0.55118,0.87402,0.55906,0.87402,0.56693,0.87402,0.5748,0.87402,0.58268,0.87402,0.59055,0.87402,0.59843,0.87402,0.6063,0.87402,0.61417,0.87402,0.62205,0.87402,0.62992,0.87402,0.6378,0.87402,0.64567,0.87402,0.65354,0.87402,0.66142,0.87402,0.66929,0.87402,0.67717,0.87402,0.68504,0.87402,0.69291,0.87402,0.70079,0.87402,0.70866,0.87402,0.71654,0.87402};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_144()
		{
			double[] value = {0.72441,0.87402,0.73228,0.87402,0.74016,0.87402,0.74803,0.87402,0.75591,0.87402,0.76378,0.87402,0.77165,0.87402,0.77953,0.87402,0.7874,0.87402,0.79528,0.87402,0.80315,0.87402,0.81102,0.87402,0.8189,0.87402,0.82677,0.87402,0.83465,0.87402,0.84252,0.87402,0.85039,0.87402,0.85827,0.87402,0.86614,0.87402,0.87402,0.87402,0.88189,0.87402,0.88976,0.87402,0.89764,0.87402,0.90551,0.87402,0.91339,0.87402,0.92126,0.87402,0.92913,0.87402,0.93701,0.87402,0.94488,0.87402,0.95276,0.87402,0.96063,0.87402,0.9685,0.87402,0.97638,0.87402,0.98425,0.87402,0.99213,0.87402,0.99609,0.87402,0.00391,0.88189,0.00787,0.88189,0.01575,0.88189,0.02362,0.88189,0.0315,0.88189,0.03937,0.88189,0.04724,0.88189,0.05512,0.88189,0.06299,0.88189,0.07087,0.88189,0.07874,0.88189,0.08661,0.88189,0.09449,0.88189,0.10236,0.88189,0.11024,0.88189,0.11811,0.88189,0.12598,0.88189,0.13386,0.88189,0.14173,0.88189,0.14961,0.88189,0.15748,0.88189,0.16535,0.88189,0.17323,0.88189,0.1811,0.88189,0.18898,0.88189,0.19685,0.88189,0.20472,0.88189,0.2126,0.88189,0.22047,0.88189,0.22835,0.88189,0.23622,0.88189,0.24409,0.88189,0.25197,0.88189,0.25984,0.88189,0.26772,0.88189,0.27559,0.88189,0.28346,0.88189,0.29134,0.88189,0.29921,0.88189,0.30709,0.88189,0.31496,0.88189,0.32283,0.88189,0.33071,0.88189,0.33858,0.88189,0.34646,0.88189,0.35433,0.88189,0.3622,0.88189,0.37008,0.88189,0.37795,0.88189,0.38583,0.88189,0.3937,0.88189,0.40157,0.88189,0.40945,0.88189,0.41732,0.88189,0.4252,0.88189,0.43307,0.88189,0.44094,0.88189,0.44882,0.88189,0.45669,0.88189,0.46457,0.88189,0.47244,0.88189,0.48031,0.88189,0.48819,0.88189,0.49606,0.88189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_145()
		{
			double[] value = {0.50394,0.88189,0.51181,0.88189,0.51969,0.88189,0.52756,0.88189,0.53543,0.88189,0.54331,0.88189,0.55118,0.88189,0.55906,0.88189,0.56693,0.88189,0.5748,0.88189,0.58268,0.88189,0.59055,0.88189,0.59843,0.88189,0.6063,0.88189,0.61417,0.88189,0.62205,0.88189,0.62992,0.88189,0.6378,0.88189,0.64567,0.88189,0.65354,0.88189,0.66142,0.88189,0.66929,0.88189,0.67717,0.88189,0.68504,0.88189,0.69291,0.88189,0.70079,0.88189,0.70866,0.88189,0.71654,0.88189,0.72441,0.88189,0.73228,0.88189,0.74016,0.88189,0.74803,0.88189,0.75591,0.88189,0.76378,0.88189,0.77165,0.88189,0.77953,0.88189,0.7874,0.88189,0.79528,0.88189,0.80315,0.88189,0.81102,0.88189,0.8189,0.88189,0.82677,0.88189,0.83465,0.88189,0.84252,0.88189,0.85039,0.88189,0.85827,0.88189,0.86614,0.88189,0.87402,0.88189,0.88189,0.88189,0.88976,0.88189,0.89764,0.88189,0.90551,0.88189,0.91339,0.88189,0.92126,0.88189,0.92913,0.88189,0.93701,0.88189,0.94488,0.88189,0.95276,0.88189,0.96063,0.88189,0.9685,0.88189,0.97638,0.88189,0.98425,0.88189,0.99213,0.88189,0.99609,0.88189,0.00391,0.88976,0.00787,0.88976,0.01575,0.88976,0.02362,0.88976,0.0315,0.88976,0.03937,0.88976,0.04724,0.88976,0.05512,0.88976,0.06299,0.88976,0.07087,0.88976,0.07874,0.88976,0.08661,0.88976,0.09449,0.88976,0.10236,0.88976,0.11024,0.88976,0.11811,0.88976,0.12598,0.88976,0.13386,0.88976,0.14173,0.88976,0.14961,0.88976,0.15748,0.88976,0.16535,0.88976,0.17323,0.88976,0.1811,0.88976,0.18898,0.88976,0.19685,0.88976,0.20472,0.88976,0.2126,0.88976,0.22047,0.88976,0.22835,0.88976,0.23622,0.88976,0.24409,0.88976,0.25197,0.88976,0.25984,0.88976,0.26772,0.88976,0.27559,0.88976};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_146()
		{
			double[] value = {0.28346,0.88976,0.29134,0.88976,0.29921,0.88976,0.30709,0.88976,0.31496,0.88976,0.32283,0.88976,0.33071,0.88976,0.33858,0.88976,0.34646,0.88976,0.35433,0.88976,0.3622,0.88976,0.37008,0.88976,0.37795,0.88976,0.38583,0.88976,0.3937,0.88976,0.40157,0.88976,0.40945,0.88976,0.41732,0.88976,0.4252,0.88976,0.43307,0.88976,0.44094,0.88976,0.44882,0.88976,0.45669,0.88976,0.46457,0.88976,0.47244,0.88976,0.48031,0.88976,0.48819,0.88976,0.49606,0.88976,0.50394,0.88976,0.51181,0.88976,0.51969,0.88976,0.52756,0.88976,0.53543,0.88976,0.54331,0.88976,0.55118,0.88976,0.55906,0.88976,0.56693,0.88976,0.5748,0.88976,0.58268,0.88976,0.59055,0.88976,0.59843,0.88976,0.6063,0.88976,0.61417,0.88976,0.62205,0.88976,0.62992,0.88976,0.6378,0.88976,0.64567,0.88976,0.65354,0.88976,0.66142,0.88976,0.66929,0.88976,0.67717,0.88976,0.68504,0.88976,0.69291,0.88976,0.70079,0.88976,0.70866,0.88976,0.71654,0.88976,0.72441,0.88976,0.73228,0.88976,0.74016,0.88976,0.74803,0.88976,0.75591,0.88976,0.76378,0.88976,0.77165,0.88976,0.77953,0.88976,0.7874,0.88976,0.79528,0.88976,0.80315,0.88976,0.81102,0.88976,0.8189,0.88976,0.82677,0.88976,0.83465,0.88976,0.84252,0.88976,0.85039,0.88976,0.85827,0.88976,0.86614,0.88976,0.87402,0.88976,0.88189,0.88976,0.88976,0.88976,0.89764,0.88976,0.90551,0.88976,0.91339,0.88976,0.92126,0.88976,0.92913,0.88976,0.93701,0.88976,0.94488,0.88976,0.95276,0.88976,0.96063,0.88976,0.9685,0.88976,0.97638,0.88976,0.98425,0.88976,0.99213,0.88976,0.99609,0.88976,0.00391,0.89764,0.00787,0.89764,0.01575,0.89764,0.02362,0.89764,0.0315,0.89764,0.03937,0.89764,0.04724,0.89764,0.05512,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_147()
		{
			double[] value = {0.06299,0.89764,0.07087,0.89764,0.07874,0.89764,0.08661,0.89764,0.09449,0.89764,0.10236,0.89764,0.11024,0.89764,0.11811,0.89764,0.12598,0.89764,0.13386,0.89764,0.14173,0.89764,0.14961,0.89764,0.15748,0.89764,0.16535,0.89764,0.17323,0.89764,0.1811,0.89764,0.18898,0.89764,0.19685,0.89764,0.20472,0.89764,0.2126,0.89764,0.22047,0.89764,0.22835,0.89764,0.23622,0.89764,0.24409,0.89764,0.25197,0.89764,0.25984,0.89764,0.26772,0.89764,0.27559,0.89764,0.28346,0.89764,0.29134,0.89764,0.29921,0.89764,0.30709,0.89764,0.31496,0.89764,0.32283,0.89764,0.33071,0.89764,0.33858,0.89764,0.34646,0.89764,0.35433,0.89764,0.3622,0.89764,0.37008,0.89764,0.37795,0.89764,0.38583,0.89764,0.3937,0.89764,0.40157,0.89764,0.40945,0.89764,0.41732,0.89764,0.4252,0.89764,0.43307,0.89764,0.44094,0.89764,0.44882,0.89764,0.45669,0.89764,0.46457,0.89764,0.47244,0.89764,0.48031,0.89764,0.48819,0.89764,0.49606,0.89764,0.50394,0.89764,0.51181,0.89764,0.51969,0.89764,0.52756,0.89764,0.53543,0.89764,0.54331,0.89764,0.55118,0.89764,0.55906,0.89764,0.56693,0.89764,0.5748,0.89764,0.58268,0.89764,0.59055,0.89764,0.59843,0.89764,0.6063,0.89764,0.61417,0.89764,0.62205,0.89764,0.62992,0.89764,0.6378,0.89764,0.64567,0.89764,0.65354,0.89764,0.66142,0.89764,0.66929,0.89764,0.67717,0.89764,0.68504,0.89764,0.69291,0.89764,0.70079,0.89764,0.70866,0.89764,0.71654,0.89764,0.72441,0.89764,0.73228,0.89764,0.74016,0.89764,0.74803,0.89764,0.75591,0.89764,0.76378,0.89764,0.77165,0.89764,0.77953,0.89764,0.7874,0.89764,0.79528,0.89764,0.80315,0.89764,0.81102,0.89764,0.8189,0.89764,0.82677,0.89764,0.83465,0.89764,0.84252,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_148()
		{
			double[] value = {0.85039,0.89764,0.85827,0.89764,0.86614,0.89764,0.87402,0.89764,0.88189,0.89764,0.88976,0.89764,0.89764,0.89764,0.90551,0.89764,0.91339,0.89764,0.92126,0.89764,0.92913,0.89764,0.93701,0.89764,0.94488,0.89764,0.95276,0.89764,0.96063,0.89764,0.9685,0.89764,0.97638,0.89764,0.98425,0.89764,0.99213,0.89764,0.99609,0.89764,0.00391,0.90551,0.00787,0.90551,0.01575,0.90551,0.02362,0.90551,0.0315,0.90551,0.03937,0.90551,0.04724,0.90551,0.05512,0.90551,0.06299,0.90551,0.07087,0.90551,0.07874,0.90551,0.08661,0.90551,0.09449,0.90551,0.10236,0.90551,0.11024,0.90551,0.11811,0.90551,0.12598,0.90551,0.13386,0.90551,0.14173,0.90551,0.14961,0.90551,0.15748,0.90551,0.16535,0.90551,0.17323,0.90551,0.1811,0.90551,0.18898,0.90551,0.19685,0.90551,0.20472,0.90551,0.2126,0.90551,0.22047,0.90551,0.22835,0.90551,0.23622,0.90551,0.24409,0.90551,0.25197,0.90551,0.25984,0.90551,0.26772,0.90551,0.27559,0.90551,0.28346,0.90551,0.29134,0.90551,0.29921,0.90551,0.30709,0.90551,0.31496,0.90551,0.32283,0.90551,0.33071,0.90551,0.33858,0.90551,0.34646,0.90551,0.35433,0.90551,0.3622,0.90551,0.37008,0.90551,0.37795,0.90551,0.38583,0.90551,0.3937,0.90551,0.40157,0.90551,0.40945,0.90551,0.41732,0.90551,0.4252,0.90551,0.43307,0.90551,0.44094,0.90551,0.44882,0.90551,0.45669,0.90551,0.46457,0.90551,0.47244,0.90551,0.48031,0.90551,0.48819,0.90551,0.49606,0.90551,0.50394,0.90551,0.51181,0.90551,0.51969,0.90551,0.52756,0.90551,0.53543,0.90551,0.54331,0.90551,0.55118,0.90551,0.55906,0.90551,0.56693,0.90551,0.5748,0.90551,0.58268,0.90551,0.59055,0.90551,0.59843,0.90551,0.6063,0.90551,0.61417,0.90551,0.62205,0.90551};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_149()
		{
			double[] value = {0.62992,0.90551,0.6378,0.90551,0.64567,0.90551,0.65354,0.90551,0.66142,0.90551,0.66929,0.90551,0.67717,0.90551,0.68504,0.90551,0.69291,0.90551,0.70079,0.90551,0.70866,0.90551,0.71654,0.90551,0.72441,0.90551,0.73228,0.90551,0.74016,0.90551,0.74803,0.90551,0.75591,0.90551,0.76378,0.90551,0.77165,0.90551,0.77953,0.90551,0.7874,0.90551,0.79528,0.90551,0.80315,0.90551,0.81102,0.90551,0.8189,0.90551,0.82677,0.90551,0.83465,0.90551,0.84252,0.90551,0.85039,0.90551,0.85827,0.90551,0.86614,0.90551,0.87402,0.90551,0.88189,0.90551,0.88976,0.90551,0.89764,0.90551,0.90551,0.90551,0.91339,0.90551,0.92126,0.90551,0.92913,0.90551,0.93701,0.90551,0.94488,0.90551,0.95276,0.90551,0.96063,0.90551,0.9685,0.90551,0.97638,0.90551,0.98425,0.90551,0.99213,0.90551,0.99609,0.90551,0.00391,0.91339,0.00787,0.91339,0.01575,0.91339,0.02362,0.91339,0.0315,0.91339,0.03937,0.91339,0.04724,0.91339,0.05512,0.91339,0.06299,0.91339,0.07087,0.91339,0.07874,0.91339,0.08661,0.91339,0.09449,0.91339,0.10236,0.91339,0.11024,0.91339,0.11811,0.91339,0.12598,0.91339,0.13386,0.91339,0.14173,0.91339,0.14961,0.91339,0.15748,0.91339,0.16535,0.91339,0.17323,0.91339,0.1811,0.91339,0.18898,0.91339,0.19685,0.91339,0.20472,0.91339,0.2126,0.91339,0.22047,0.91339,0.22835,0.91339,0.23622,0.91339,0.24409,0.91339,0.25197,0.91339,0.25984,0.91339,0.26772,0.91339,0.27559,0.91339,0.28346,0.91339,0.29134,0.91339,0.29921,0.91339,0.30709,0.91339,0.31496,0.91339,0.32283,0.91339,0.33071,0.91339,0.33858,0.91339,0.34646,0.91339,0.35433,0.91339,0.3622,0.91339,0.37008,0.91339,0.37795,0.91339,0.38583,0.91339,0.3937,0.91339,0.40157,0.91339};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_150()
		{
			double[] value = {0.40945,0.91339,0.41732,0.91339,0.4252,0.91339,0.43307,0.91339,0.44094,0.91339,0.44882,0.91339,0.45669,0.91339,0.46457,0.91339,0.47244,0.91339,0.48031,0.91339,0.48819,0.91339,0.49606,0.91339,0.50394,0.91339,0.51181,0.91339,0.51969,0.91339,0.52756,0.91339,0.53543,0.91339,0.54331,0.91339,0.55118,0.91339,0.55906,0.91339,0.56693,0.91339,0.5748,0.91339,0.58268,0.91339,0.59055,0.91339,0.59843,0.91339,0.6063,0.91339,0.61417,0.91339,0.62205,0.91339,0.62992,0.91339,0.6378,0.91339,0.64567,0.91339,0.65354,0.91339,0.66142,0.91339,0.66929,0.91339,0.67717,0.91339,0.68504,0.91339,0.69291,0.91339,0.70079,0.91339,0.70866,0.91339,0.71654,0.91339,0.72441,0.91339,0.73228,0.91339,0.74016,0.91339,0.74803,0.91339,0.75591,0.91339,0.76378,0.91339,0.77165,0.91339,0.77953,0.91339,0.7874,0.91339,0.79528,0.91339,0.80315,0.91339,0.81102,0.91339,0.8189,0.91339,0.82677,0.91339,0.83465,0.91339,0.84252,0.91339,0.85039,0.91339,0.85827,0.91339,0.86614,0.91339,0.87402,0.91339,0.88189,0.91339,0.88976,0.91339,0.89764,0.91339,0.90551,0.91339,0.91339,0.91339,0.92126,0.91339,0.92913,0.91339,0.93701,0.91339,0.94488,0.91339,0.95276,0.91339,0.96063,0.91339,0.9685,0.91339,0.97638,0.91339,0.98425,0.91339,0.99213,0.91339,0.99609,0.91339,0.00391,0.92126,0.00787,0.92126,0.01575,0.92126,0.02362,0.92126,0.0315,0.92126,0.03937,0.92126,0.04724,0.92126,0.05512,0.92126,0.06299,0.92126,0.07087,0.92126,0.07874,0.92126,0.08661,0.92126,0.09449,0.92126,0.10236,0.92126,0.11024,0.92126,0.11811,0.92126,0.12598,0.92126,0.13386,0.92126,0.14173,0.92126,0.14961,0.92126,0.15748,0.92126,0.16535,0.92126,0.17323,0.92126,0.1811,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_151()
		{
			double[] value = {0.18898,0.92126,0.19685,0.92126,0.20472,0.92126,0.2126,0.92126,0.22047,0.92126,0.22835,0.92126,0.23622,0.92126,0.24409,0.92126,0.25197,0.92126,0.25984,0.92126,0.26772,0.92126,0.27559,0.92126,0.28346,0.92126,0.29134,0.92126,0.29921,0.92126,0.30709,0.92126,0.31496,0.92126,0.32283,0.92126,0.33071,0.92126,0.33858,0.92126,0.34646,0.92126,0.35433,0.92126,0.3622,0.92126,0.37008,0.92126,0.37795,0.92126,0.38583,0.92126,0.3937,0.92126,0.40157,0.92126,0.40945,0.92126,0.41732,0.92126,0.4252,0.92126,0.43307,0.92126,0.44094,0.92126,0.44882,0.92126,0.45669,0.92126,0.46457,0.92126,0.47244,0.92126,0.48031,0.92126,0.48819,0.92126,0.49606,0.92126,0.50394,0.92126,0.51181,0.92126,0.51969,0.92126,0.52756,0.92126,0.53543,0.92126,0.54331,0.92126,0.55118,0.92126,0.55906,0.92126,0.56693,0.92126,0.5748,0.92126,0.58268,0.92126,0.59055,0.92126,0.59843,0.92126,0.6063,0.92126,0.61417,0.92126,0.62205,0.92126,0.62992,0.92126,0.6378,0.92126,0.64567,0.92126,0.65354,0.92126,0.66142,0.92126,0.66929,0.92126,0.67717,0.92126,0.68504,0.92126,0.69291,0.92126,0.70079,0.92126,0.70866,0.92126,0.71654,0.92126,0.72441,0.92126,0.73228,0.92126,0.74016,0.92126,0.74803,0.92126,0.75591,0.92126,0.76378,0.92126,0.77165,0.92126,0.77953,0.92126,0.7874,0.92126,0.79528,0.92126,0.80315,0.92126,0.81102,0.92126,0.8189,0.92126,0.82677,0.92126,0.83465,0.92126,0.84252,0.92126,0.85039,0.92126,0.85827,0.92126,0.86614,0.92126,0.87402,0.92126,0.88189,0.92126,0.88976,0.92126,0.89764,0.92126,0.90551,0.92126,0.91339,0.92126,0.92126,0.92126,0.92913,0.92126,0.93701,0.92126,0.94488,0.92126,0.95276,0.92126,0.96063,0.92126,0.9685,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_152()
		{
			double[] value = {0.97638,0.92126,0.98425,0.92126,0.99213,0.92126,0.99609,0.92126,0.00391,0.92913,0.00787,0.92913,0.01575,0.92913,0.02362,0.92913,0.0315,0.92913,0.03937,0.92913,0.04724,0.92913,0.05512,0.92913,0.06299,0.92913,0.07087,0.92913,0.07874,0.92913,0.08661,0.92913,0.09449,0.92913,0.10236,0.92913,0.11024,0.92913,0.11811,0.92913,0.12598,0.92913,0.13386,0.92913,0.14173,0.92913,0.14961,0.92913,0.15748,0.92913,0.16535,0.92913,0.17323,0.92913,0.1811,0.92913,0.18898,0.92913,0.19685,0.92913,0.20472,0.92913,0.2126,0.92913,0.22047,0.92913,0.22835,0.92913,0.23622,0.92913,0.24409,0.92913,0.25197,0.92913,0.25984,0.92913,0.26772,0.92913,0.27559,0.92913,0.28346,0.92913,0.29134,0.92913,0.29921,0.92913,0.30709,0.92913,0.31496,0.92913,0.32283,0.92913,0.33071,0.92913,0.33858,0.92913,0.34646,0.92913,0.35433,0.92913,0.3622,0.92913,0.37008,0.92913,0.37795,0.92913,0.38583,0.92913,0.3937,0.92913,0.40157,0.92913,0.40945,0.92913,0.41732,0.92913,0.4252,0.92913,0.43307,0.92913,0.44094,0.92913,0.44882,0.92913,0.45669,0.92913,0.46457,0.92913,0.47244,0.92913,0.48031,0.92913,0.48819,0.92913,0.49606,0.92913,0.50394,0.92913,0.51181,0.92913,0.51969,0.92913,0.52756,0.92913,0.53543,0.92913,0.54331,0.92913,0.55118,0.92913,0.55906,0.92913,0.56693,0.92913,0.5748,0.92913,0.58268,0.92913,0.59055,0.92913,0.59843,0.92913,0.6063,0.92913,0.61417,0.92913,0.62205,0.92913,0.62992,0.92913,0.6378,0.92913,0.64567,0.92913,0.65354,0.92913,0.66142,0.92913,0.66929,0.92913,0.67717,0.92913,0.68504,0.92913,0.69291,0.92913,0.70079,0.92913,0.70866,0.92913,0.71654,0.92913,0.72441,0.92913,0.73228,0.92913,0.74016,0.92913,0.74803,0.92913};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_153()
		{
			double[] value = {0.75591,0.92913,0.76378,0.92913,0.77165,0.92913,0.77953,0.92913,0.7874,0.92913,0.79528,0.92913,0.80315,0.92913,0.81102,0.92913,0.8189,0.92913,0.82677,0.92913,0.83465,0.92913,0.84252,0.92913,0.85039,0.92913,0.85827,0.92913,0.86614,0.92913,0.87402,0.92913,0.88189,0.92913,0.88976,0.92913,0.89764,0.92913,0.90551,0.92913,0.91339,0.92913,0.92126,0.92913,0.92913,0.92913,0.93701,0.92913,0.94488,0.92913,0.95276,0.92913,0.96063,0.92913,0.9685,0.92913,0.97638,0.92913,0.98425,0.92913,0.99213,0.92913,0.99609,0.92913,0.00391,0.93701,0.00787,0.93701,0.01575,0.93701,0.02362,0.93701,0.0315,0.93701,0.03937,0.93701,0.04724,0.93701,0.05512,0.93701,0.06299,0.93701,0.07087,0.93701,0.07874,0.93701,0.08661,0.93701,0.09449,0.93701,0.10236,0.93701,0.11024,0.93701,0.11811,0.93701,0.12598,0.93701,0.13386,0.93701,0.14173,0.93701,0.14961,0.93701,0.15748,0.93701,0.16535,0.93701,0.17323,0.93701,0.1811,0.93701,0.18898,0.93701,0.19685,0.93701,0.20472,0.93701,0.2126,0.93701,0.22047,0.93701,0.22835,0.93701,0.23622,0.93701,0.24409,0.93701,0.25197,0.93701,0.25984,0.93701,0.26772,0.93701,0.27559,0.93701,0.28346,0.93701,0.29134,0.93701,0.29921,0.93701,0.30709,0.93701,0.31496,0.93701,0.32283,0.93701,0.33071,0.93701,0.33858,0.93701,0.34646,0.93701,0.35433,0.93701,0.3622,0.93701,0.37008,0.93701,0.37795,0.93701,0.38583,0.93701,0.3937,0.93701,0.40157,0.93701,0.40945,0.93701,0.41732,0.93701,0.4252,0.93701,0.43307,0.93701,0.44094,0.93701,0.44882,0.93701,0.45669,0.93701,0.46457,0.93701,0.47244,0.93701,0.48031,0.93701,0.48819,0.93701,0.49606,0.93701,0.50394,0.93701,0.51181,0.93701,0.51969,0.93701,0.52756,0.93701};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_154()
		{
			double[] value = {0.53543,0.93701,0.54331,0.93701,0.55118,0.93701,0.55906,0.93701,0.56693,0.93701,0.5748,0.93701,0.58268,0.93701,0.59055,0.93701,0.59843,0.93701,0.6063,0.93701,0.61417,0.93701,0.62205,0.93701,0.62992,0.93701,0.6378,0.93701,0.64567,0.93701,0.65354,0.93701,0.66142,0.93701,0.66929,0.93701,0.67717,0.93701,0.68504,0.93701,0.69291,0.93701,0.70079,0.93701,0.70866,0.93701,0.71654,0.93701,0.72441,0.93701,0.73228,0.93701,0.74016,0.93701,0.74803,0.93701,0.75591,0.93701,0.76378,0.93701,0.77165,0.93701,0.77953,0.93701,0.7874,0.93701,0.79528,0.93701,0.80315,0.93701,0.81102,0.93701,0.8189,0.93701,0.82677,0.93701,0.83465,0.93701,0.84252,0.93701,0.85039,0.93701,0.85827,0.93701,0.86614,0.93701,0.87402,0.93701,0.88189,0.93701,0.88976,0.93701,0.89764,0.93701,0.90551,0.93701,0.91339,0.93701,0.92126,0.93701,0.92913,0.93701,0.93701,0.93701,0.94488,0.93701,0.95276,0.93701,0.96063,0.93701,0.9685,0.93701,0.97638,0.93701,0.98425,0.93701,0.99213,0.93701,0.99609,0.93701,0.00391,0.94488,0.00787,0.94488,0.01575,0.94488,0.02362,0.94488,0.0315,0.94488,0.03937,0.94488,0.04724,0.94488,0.05512,0.94488,0.06299,0.94488,0.07087,0.94488,0.07874,0.94488,0.08661,0.94488,0.09449,0.94488,0.10236,0.94488,0.11024,0.94488,0.11811,0.94488,0.12598,0.94488,0.13386,0.94488,0.14173,0.94488,0.14961,0.94488,0.15748,0.94488,0.16535,0.94488,0.17323,0.94488,0.1811,0.94488,0.18898,0.94488,0.19685,0.94488,0.20472,0.94488,0.2126,0.94488,0.22047,0.94488,0.22835,0.94488,0.23622,0.94488,0.24409,0.94488,0.25197,0.94488,0.25984,0.94488,0.26772,0.94488,0.27559,0.94488,0.28346,0.94488,0.29134,0.94488,0.29921,0.94488,0.30709,0.94488};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_155()
		{
			double[] value = {0.31496,0.94488,0.32283,0.94488,0.33071,0.94488,0.33858,0.94488,0.34646,0.94488,0.35433,0.94488,0.3622,0.94488,0.37008,0.94488,0.37795,0.94488,0.38583,0.94488,0.3937,0.94488,0.40157,0.94488,0.40945,0.94488,0.41732,0.94488,0.4252,0.94488,0.43307,0.94488,0.44094,0.94488,0.44882,0.94488,0.45669,0.94488,0.46457,0.94488,0.47244,0.94488,0.48031,0.94488,0.48819,0.94488,0.49606,0.94488,0.50394,0.94488,0.51181,0.94488,0.51969,0.94488,0.52756,0.94488,0.53543,0.94488,0.54331,0.94488,0.55118,0.94488,0.55906,0.94488,0.56693,0.94488,0.5748,0.94488,0.58268,0.94488,0.59055,0.94488,0.59843,0.94488,0.6063,0.94488,0.61417,0.94488,0.62205,0.94488,0.62992,0.94488,0.6378,0.94488,0.64567,0.94488,0.65354,0.94488,0.66142,0.94488,0.66929,0.94488,0.67717,0.94488,0.68504,0.94488,0.69291,0.94488,0.70079,0.94488,0.70866,0.94488,0.71654,0.94488,0.72441,0.94488,0.73228,0.94488,0.74016,0.94488,0.74803,0.94488,0.75591,0.94488,0.76378,0.94488,0.77165,0.94488,0.77953,0.94488,0.7874,0.94488,0.79528,0.94488,0.80315,0.94488,0.81102,0.94488,0.8189,0.94488,0.82677,0.94488,0.83465,0.94488,0.84252,0.94488,0.85039,0.94488,0.85827,0.94488,0.86614,0.94488,0.87402,0.94488,0.88189,0.94488,0.88976,0.94488,0.89764,0.94488,0.90551,0.94488,0.91339,0.94488,0.92126,0.94488,0.92913,0.94488,0.93701,0.94488,0.94488,0.94488,0.95276,0.94488,0.96063,0.94488,0.9685,0.94488,0.97638,0.94488,0.98425,0.94488,0.99213,0.94488,0.99609,0.94488,0.00391,0.95276,0.00787,0.95276,0.01575,0.95276,0.02362,0.95276,0.0315,0.95276,0.03937,0.95276,0.04724,0.95276,0.05512,0.95276,0.06299,0.95276,0.07087,0.95276,0.07874,0.95276,0.08661,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_156()
		{
			double[] value = {0.09449,0.95276,0.10236,0.95276,0.11024,0.95276,0.11811,0.95276,0.12598,0.95276,0.13386,0.95276,0.14173,0.95276,0.14961,0.95276,0.15748,0.95276,0.16535,0.95276,0.17323,0.95276,0.1811,0.95276,0.18898,0.95276,0.19685,0.95276,0.20472,0.95276,0.2126,0.95276,0.22047,0.95276,0.22835,0.95276,0.23622,0.95276,0.24409,0.95276,0.25197,0.95276,0.25984,0.95276,0.26772,0.95276,0.27559,0.95276,0.28346,0.95276,0.29134,0.95276,0.29921,0.95276,0.30709,0.95276,0.31496,0.95276,0.32283,0.95276,0.33071,0.95276,0.33858,0.95276,0.34646,0.95276,0.35433,0.95276,0.3622,0.95276,0.37008,0.95276,0.37795,0.95276,0.38583,0.95276,0.3937,0.95276,0.40157,0.95276,0.40945,0.95276,0.41732,0.95276,0.4252,0.95276,0.43307,0.95276,0.44094,0.95276,0.44882,0.95276,0.45669,0.95276,0.46457,0.95276,0.47244,0.95276,0.48031,0.95276,0.48819,0.95276,0.49606,0.95276,0.50394,0.95276,0.51181,0.95276,0.51969,0.95276,0.52756,0.95276,0.53543,0.95276,0.54331,0.95276,0.55118,0.95276,0.55906,0.95276,0.56693,0.95276,0.5748,0.95276,0.58268,0.95276,0.59055,0.95276,0.59843,0.95276,0.6063,0.95276,0.61417,0.95276,0.62205,0.95276,0.62992,0.95276,0.6378,0.95276,0.64567,0.95276,0.65354,0.95276,0.66142,0.95276,0.66929,0.95276,0.67717,0.95276,0.68504,0.95276,0.69291,0.95276,0.70079,0.95276,0.70866,0.95276,0.71654,0.95276,0.72441,0.95276,0.73228,0.95276,0.74016,0.95276,0.74803,0.95276,0.75591,0.95276,0.76378,0.95276,0.77165,0.95276,0.77953,0.95276,0.7874,0.95276,0.79528,0.95276,0.80315,0.95276,0.81102,0.95276,0.8189,0.95276,0.82677,0.95276,0.83465,0.95276,0.84252,0.95276,0.85039,0.95276,0.85827,0.95276,0.86614,0.95276,0.87402,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_157()
		{
			double[] value = {0.88189,0.95276,0.88976,0.95276,0.89764,0.95276,0.90551,0.95276,0.91339,0.95276,0.92126,0.95276,0.92913,0.95276,0.93701,0.95276,0.94488,0.95276,0.95276,0.95276,0.96063,0.95276,0.9685,0.95276,0.97638,0.95276,0.98425,0.95276,0.99213,0.95276,0.99609,0.95276,0.00391,0.96063,0.00787,0.96063,0.01575,0.96063,0.02362,0.96063,0.0315,0.96063,0.03937,0.96063,0.04724,0.96063,0.05512,0.96063,0.06299,0.96063,0.07087,0.96063,0.07874,0.96063,0.08661,0.96063,0.09449,0.96063,0.10236,0.96063,0.11024,0.96063,0.11811,0.96063,0.12598,0.96063,0.13386,0.96063,0.14173,0.96063,0.14961,0.96063,0.15748,0.96063,0.16535,0.96063,0.17323,0.96063,0.1811,0.96063,0.18898,0.96063,0.19685,0.96063,0.20472,0.96063,0.2126,0.96063,0.22047,0.96063,0.22835,0.96063,0.23622,0.96063,0.24409,0.96063,0.25197,0.96063,0.25984,0.96063,0.26772,0.96063,0.27559,0.96063,0.28346,0.96063,0.29134,0.96063,0.29921,0.96063,0.30709,0.96063,0.31496,0.96063,0.32283,0.96063,0.33071,0.96063,0.33858,0.96063,0.34646,0.96063,0.35433,0.96063,0.3622,0.96063,0.37008,0.96063,0.37795,0.96063,0.38583,0.96063,0.3937,0.96063,0.40157,0.96063,0.40945,0.96063,0.41732,0.96063,0.4252,0.96063,0.43307,0.96063,0.44094,0.96063,0.44882,0.96063,0.45669,0.96063,0.46457,0.96063,0.47244,0.96063,0.48031,0.96063,0.48819,0.96063,0.49606,0.96063,0.50394,0.96063,0.51181,0.96063,0.51969,0.96063,0.52756,0.96063,0.53543,0.96063,0.54331,0.96063,0.55118,0.96063,0.55906,0.96063,0.56693,0.96063,0.5748,0.96063,0.58268,0.96063,0.59055,0.96063,0.59843,0.96063,0.6063,0.96063,0.61417,0.96063,0.62205,0.96063,0.62992,0.96063,0.6378,0.96063,0.64567,0.96063,0.65354,0.96063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_158()
		{
			double[] value = {0.66142,0.96063,0.66929,0.96063,0.67717,0.96063,0.68504,0.96063,0.69291,0.96063,0.70079,0.96063,0.70866,0.96063,0.71654,0.96063,0.72441,0.96063,0.73228,0.96063,0.74016,0.96063,0.74803,0.96063,0.75591,0.96063,0.76378,0.96063,0.77165,0.96063,0.77953,0.96063,0.7874,0.96063,0.79528,0.96063,0.80315,0.96063,0.81102,0.96063,0.8189,0.96063,0.82677,0.96063,0.83465,0.96063,0.84252,0.96063,0.85039,0.96063,0.85827,0.96063,0.86614,0.96063,0.87402,0.96063,0.88189,0.96063,0.88976,0.96063,0.89764,0.96063,0.90551,0.96063,0.91339,0.96063,0.92126,0.96063,0.92913,0.96063,0.93701,0.96063,0.94488,0.96063,0.95276,0.96063,0.96063,0.96063,0.9685,0.96063,0.97638,0.96063,0.98425,0.96063,0.99213,0.96063,0.99609,0.96063,0.00391,0.9685,0.00787,0.9685,0.01575,0.9685,0.02362,0.9685,0.0315,0.9685,0.03937,0.9685,0.04724,0.9685,0.05512,0.9685,0.06299,0.9685,0.07087,0.9685,0.07874,0.9685,0.08661,0.9685,0.09449,0.9685,0.10236,0.9685,0.11024,0.9685,0.11811,0.9685,0.12598,0.9685,0.13386,0.9685,0.14173,0.9685,0.14961,0.9685,0.15748,0.9685,0.16535,0.9685,0.17323,0.9685,0.1811,0.9685,0.18898,0.9685,0.19685,0.9685,0.20472,0.9685,0.2126,0.9685,0.22047,0.9685,0.22835,0.9685,0.23622,0.9685,0.24409,0.9685,0.25197,0.9685,0.25984,0.9685,0.26772,0.9685,0.27559,0.9685,0.28346,0.9685,0.29134,0.9685,0.29921,0.9685,0.30709,0.9685,0.31496,0.9685,0.32283,0.9685,0.33071,0.9685,0.33858,0.9685,0.34646,0.9685,0.35433,0.9685,0.3622,0.9685,0.37008,0.9685,0.37795,0.9685,0.38583,0.9685,0.3937,0.9685,0.40157,0.9685,0.40945,0.9685,0.41732,0.9685,0.4252,0.9685,0.43307,0.9685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_159()
		{
			double[] value = {0.44094,0.9685,0.44882,0.9685,0.45669,0.9685,0.46457,0.9685,0.47244,0.9685,0.48031,0.9685,0.48819,0.9685,0.49606,0.9685,0.50394,0.9685,0.51181,0.9685,0.51969,0.9685,0.52756,0.9685,0.53543,0.9685,0.54331,0.9685,0.55118,0.9685,0.55906,0.9685,0.56693,0.9685,0.5748,0.9685,0.58268,0.9685,0.59055,0.9685,0.59843,0.9685,0.6063,0.9685,0.61417,0.9685,0.62205,0.9685,0.62992,0.9685,0.6378,0.9685,0.64567,0.9685,0.65354,0.9685,0.66142,0.9685,0.66929,0.9685,0.67717,0.9685,0.68504,0.9685,0.69291,0.9685,0.70079,0.9685,0.70866,0.9685,0.71654,0.9685,0.72441,0.9685,0.73228,0.9685,0.74016,0.9685,0.74803,0.9685,0.75591,0.9685,0.76378,0.9685,0.77165,0.9685,0.77953,0.9685,0.7874,0.9685,0.79528,0.9685,0.80315,0.9685,0.81102,0.9685,0.8189,0.9685,0.82677,0.9685,0.83465,0.9685,0.84252,0.9685,0.85039,0.9685,0.85827,0.9685,0.86614,0.9685,0.87402,0.9685,0.88189,0.9685,0.88976,0.9685,0.89764,0.9685,0.90551,0.9685,0.91339,0.9685,0.92126,0.9685,0.92913,0.9685,0.93701,0.9685,0.94488,0.9685,0.95276,0.9685,0.96063,0.9685,0.9685,0.9685,0.97638,0.9685,0.98425,0.9685,0.99213,0.9685,0.99609,0.9685,0.00391,0.97638,0.00787,0.97638,0.01575,0.97638,0.02362,0.97638,0.0315,0.97638,0.03937,0.97638,0.04724,0.97638,0.05512,0.97638,0.06299,0.97638,0.07087,0.97638,0.07874,0.97638,0.08661,0.97638,0.09449,0.97638,0.10236,0.97638,0.11024,0.97638,0.11811,0.97638,0.12598,0.97638,0.13386,0.97638,0.14173,0.97638,0.14961,0.97638,0.15748,0.97638,0.16535,0.97638,0.17323,0.97638,0.1811,0.97638,0.18898,0.97638,0.19685,0.97638,0.20472,0.97638,0.2126,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_160()
		{
			double[] value = {0.22047,0.97638,0.22835,0.97638,0.23622,0.97638,0.24409,0.97638,0.25197,0.97638,0.25984,0.97638,0.26772,0.97638,0.27559,0.97638,0.28346,0.97638,0.29134,0.97638,0.29921,0.97638,0.30709,0.97638,0.31496,0.97638,0.32283,0.97638,0.33071,0.97638,0.33858,0.97638,0.34646,0.97638,0.35433,0.97638,0.3622,0.97638,0.37008,0.97638,0.37795,0.97638,0.38583,0.97638,0.3937,0.97638,0.40157,0.97638,0.40945,0.97638,0.41732,0.97638,0.4252,0.97638,0.43307,0.97638,0.44094,0.97638,0.44882,0.97638,0.45669,0.97638,0.46457,0.97638,0.47244,0.97638,0.48031,0.97638,0.48819,0.97638,0.49606,0.97638,0.50394,0.97638,0.51181,0.97638,0.51969,0.97638,0.52756,0.97638,0.53543,0.97638,0.54331,0.97638,0.55118,0.97638,0.55906,0.97638,0.56693,0.97638,0.5748,0.97638,0.58268,0.97638,0.59055,0.97638,0.59843,0.97638,0.6063,0.97638,0.61417,0.97638,0.62205,0.97638,0.62992,0.97638,0.6378,0.97638,0.64567,0.97638,0.65354,0.97638,0.66142,0.97638,0.66929,0.97638,0.67717,0.97638,0.68504,0.97638,0.69291,0.97638,0.70079,0.97638,0.70866,0.97638,0.71654,0.97638,0.72441,0.97638,0.73228,0.97638,0.74016,0.97638,0.74803,0.97638,0.75591,0.97638,0.76378,0.97638,0.77165,0.97638,0.77953,0.97638,0.7874,0.97638,0.79528,0.97638,0.80315,0.97638,0.81102,0.97638,0.8189,0.97638,0.82677,0.97638,0.83465,0.97638,0.84252,0.97638,0.85039,0.97638,0.85827,0.97638,0.86614,0.97638,0.87402,0.97638,0.88189,0.97638,0.88976,0.97638,0.89764,0.97638,0.90551,0.97638,0.91339,0.97638,0.92126,0.97638,0.92913,0.97638,0.93701,0.97638,0.94488,0.97638,0.95276,0.97638,0.96063,0.97638,0.9685,0.97638,0.97638,0.97638,0.98425,0.97638,0.99213,0.97638,0.99609,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_161()
		{
			double[] value = {0.00391,0.98425,0.00787,0.98425,0.01575,0.98425,0.02362,0.98425,0.0315,0.98425,0.03937,0.98425,0.04724,0.98425,0.05512,0.98425,0.06299,0.98425,0.07087,0.98425,0.07874,0.98425,0.08661,0.98425,0.09449,0.98425,0.10236,0.98425,0.11024,0.98425,0.11811,0.98425,0.12598,0.98425,0.13386,0.98425,0.14173,0.98425,0.14961,0.98425,0.15748,0.98425,0.16535,0.98425,0.17323,0.98425,0.1811,0.98425,0.18898,0.98425,0.19685,0.98425,0.20472,0.98425,0.2126,0.98425,0.22047,0.98425,0.22835,0.98425,0.23622,0.98425,0.24409,0.98425,0.25197,0.98425,0.25984,0.98425,0.26772,0.98425,0.27559,0.98425,0.28346,0.98425,0.29134,0.98425,0.29921,0.98425,0.30709,0.98425,0.31496,0.98425,0.32283,0.98425,0.33071,0.98425,0.33858,0.98425,0.34646,0.98425,0.35433,0.98425,0.3622,0.98425,0.37008,0.98425,0.37795,0.98425,0.38583,0.98425,0.3937,0.98425,0.40157,0.98425,0.40945,0.98425,0.41732,0.98425,0.4252,0.98425,0.43307,0.98425,0.44094,0.98425,0.44882,0.98425,0.45669,0.98425,0.46457,0.98425,0.47244,0.98425,0.48031,0.98425,0.48819,0.98425,0.49606,0.98425,0.50394,0.98425,0.51181,0.98425,0.51969,0.98425,0.52756,0.98425,0.53543,0.98425,0.54331,0.98425,0.55118,0.98425,0.55906,0.98425,0.56693,0.98425,0.5748,0.98425,0.58268,0.98425,0.59055,0.98425,0.59843,0.98425,0.6063,0.98425,0.61417,0.98425,0.62205,0.98425,0.62992,0.98425,0.6378,0.98425,0.64567,0.98425,0.65354,0.98425,0.66142,0.98425,0.66929,0.98425,0.67717,0.98425,0.68504,0.98425,0.69291,0.98425,0.70079,0.98425,0.70866,0.98425,0.71654,0.98425,0.72441,0.98425,0.73228,0.98425,0.74016,0.98425,0.74803,0.98425,0.75591,0.98425,0.76378,0.98425,0.77165,0.98425,0.77953,0.98425};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_162()
		{
			double[] value = {0.7874,0.98425,0.79528,0.98425,0.80315,0.98425,0.81102,0.98425,0.8189,0.98425,0.82677,0.98425,0.83465,0.98425,0.84252,0.98425,0.85039,0.98425,0.85827,0.98425,0.86614,0.98425,0.87402,0.98425,0.88189,0.98425,0.88976,0.98425,0.89764,0.98425,0.90551,0.98425,0.91339,0.98425,0.92126,0.98425,0.92913,0.98425,0.93701,0.98425,0.94488,0.98425,0.95276,0.98425,0.96063,0.98425,0.9685,0.98425,0.97638,0.98425,0.98425,0.98425,0.99213,0.98425,0.99609,0.98425,0.00391,0.99213,0.00787,0.99213,0.01575,0.99213,0.02362,0.99213,0.0315,0.99213,0.03937,0.99213,0.04724,0.99213,0.05512,0.99213,0.06299,0.99213,0.07087,0.99213,0.07874,0.99213,0.08661,0.99213,0.09449,0.99213,0.10236,0.99213,0.11024,0.99213,0.11811,0.99213,0.12598,0.99213,0.13386,0.99213,0.14173,0.99213,0.14961,0.99213,0.15748,0.99213,0.16535,0.99213,0.17323,0.99213,0.1811,0.99213,0.18898,0.99213,0.19685,0.99213,0.20472,0.99213,0.2126,0.99213,0.22047,0.99213,0.22835,0.99213,0.23622,0.99213,0.24409,0.99213,0.25197,0.99213,0.25984,0.99213,0.26772,0.99213,0.27559,0.99213,0.28346,0.99213,0.29134,0.99213,0.29921,0.99213,0.30709,0.99213,0.31496,0.99213,0.32283,0.99213,0.33071,0.99213,0.33858,0.99213,0.34646,0.99213,0.35433,0.99213,0.3622,0.99213,0.37008,0.99213,0.37795,0.99213,0.38583,0.99213,0.3937,0.99213,0.40157,0.99213,0.40945,0.99213,0.41732,0.99213,0.4252,0.99213,0.43307,0.99213,0.44094,0.99213,0.44882,0.99213,0.45669,0.99213,0.46457,0.99213,0.47244,0.99213,0.48031,0.99213,0.48819,0.99213,0.49606,0.99213,0.50394,0.99213,0.51181,0.99213,0.51969,0.99213,0.52756,0.99213,0.53543,0.99213,0.54331,0.99213,0.55118,0.99213,0.55906,0.99213};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_163()
		{
			double[] value = {0.56693,0.99213,0.5748,0.99213,0.58268,0.99213,0.59055,0.99213,0.59843,0.99213,0.6063,0.99213,0.61417,0.99213,0.62205,0.99213,0.62992,0.99213,0.6378,0.99213,0.64567,0.99213,0.65354,0.99213,0.66142,0.99213,0.66929,0.99213,0.67717,0.99213,0.68504,0.99213,0.69291,0.99213,0.70079,0.99213,0.70866,0.99213,0.71654,0.99213,0.72441,0.99213,0.73228,0.99213,0.74016,0.99213,0.74803,0.99213,0.75591,0.99213,0.76378,0.99213,0.77165,0.99213,0.77953,0.99213,0.7874,0.99213,0.79528,0.99213,0.80315,0.99213,0.81102,0.99213,0.8189,0.99213,0.82677,0.99213,0.83465,0.99213,0.84252,0.99213,0.85039,0.99213,0.85827,0.99213,0.86614,0.99213,0.87402,0.99213,0.88189,0.99213,0.88976,0.99213,0.89764,0.99213,0.90551,0.99213,0.91339,0.99213,0.92126,0.99213,0.92913,0.99213,0.93701,0.99213,0.94488,0.99213,0.95276,0.99213,0.96063,0.99213,0.9685,0.99213,0.97638,0.99213,0.98425,0.99213,0.99213,0.99213,0.99609,0.99213,0.00391,0.99609,0.00787,0.99609,0.01575,0.99609,0.02362,0.99609,0.0315,0.99609,0.03937,0.99609,0.04724,0.99609,0.05512,0.99609,0.06299,0.99609,0.07087,0.99609,0.07874,0.99609,0.08661,0.99609,0.09449,0.99609,0.10236,0.99609,0.11024,0.99609,0.11811,0.99609,0.12598,0.99609,0.13386,0.99609,0.14173,0.99609,0.14961,0.99609,0.15748,0.99609,0.16535,0.99609,0.17323,0.99609,0.1811,0.99609,0.18898,0.99609,0.19685,0.99609,0.20472,0.99609,0.2126,0.99609,0.22047,0.99609,0.22835,0.99609,0.23622,0.99609,0.24409,0.99609,0.25197,0.99609,0.25984,0.99609,0.26772,0.99609,0.27559,0.99609,0.28346,0.99609,0.29134,0.99609,0.29921,0.99609,0.30709,0.99609,0.31496,0.99609,0.32283,0.99609,0.33071,0.99609,0.33858,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_164()
		{
			double[] value = {0.34646,0.99609,0.35433,0.99609,0.3622,0.99609,0.37008,0.99609,0.37795,0.99609,0.38583,0.99609,0.3937,0.99609,0.40157,0.99609,0.40945,0.99609,0.41732,0.99609,0.4252,0.99609,0.43307,0.99609,0.44094,0.99609,0.44882,0.99609,0.45669,0.99609,0.46457,0.99609,0.47244,0.99609,0.48031,0.99609,0.48819,0.99609,0.49606,0.99609,0.50394,0.99609,0.51181,0.99609,0.51969,0.99609,0.52756,0.99609,0.53543,0.99609,0.54331,0.99609,0.55118,0.99609,0.55906,0.99609,0.56693,0.99609,0.5748,0.99609,0.58268,0.99609,0.59055,0.99609,0.59843,0.99609,0.6063,0.99609,0.61417,0.99609,0.62205,0.99609,0.62992,0.99609,0.6378,0.99609,0.64567,0.99609,0.65354,0.99609,0.66142,0.99609,0.66929,0.99609,0.67717,0.99609,0.68504,0.99609,0.69291,0.99609,0.70079,0.99609,0.70866,0.99609,0.71654,0.99609,0.72441,0.99609,0.73228,0.99609,0.74016,0.99609,0.74803,0.99609,0.75591,0.99609,0.76378,0.99609,0.77165,0.99609,0.77953,0.99609,0.7874,0.99609,0.79528,0.99609,0.80315,0.99609,0.81102,0.99609,0.8189,0.99609,0.82677,0.99609,0.83465,0.99609,0.84252,0.99609,0.85039,0.99609,0.85827,0.99609,0.86614,0.99609,0.87402,0.99609,0.88189,0.99609,0.88976,0.99609,0.89764,0.99609,0.90551,0.99609,0.91339,0.99609,0.92126,0.99609,0.92913,0.99609,0.93701,0.99609,0.94488,0.99609,0.95276,0.99609,0.96063,0.99609,0.9685,0.99609,0.97638,0.99609,0.98425,0.99609,0.99213,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 16384 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_42()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_43()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_44()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_45()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_46()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_47()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_48()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_49()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_50()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_51()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_52()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_53()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_54()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_55()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_56()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_57()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_58()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_59()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_60()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_61()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_62()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_63()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_64()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_65()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_66()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_67()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_68()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_69()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_70()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_71()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_72()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_73()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_74()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_75()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_76()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_77()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_78()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_79()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_80()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_81()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_82()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_83()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_84()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_85()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_86()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_87()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_88()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_89()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_90()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_91()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_92()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_93()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_94()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_95()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_96()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_97()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_98()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_99()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_100()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_101()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_102()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_103()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_104()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_105()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_106()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_107()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_108()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_109()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_110()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_111()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_112()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_113()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_114()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_115()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_116()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_117()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_118()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_119()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_120()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_121()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_122()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_123()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_124()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_125()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_126()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_127()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_128()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_129()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_130()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_131()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_132()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_133()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_134()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_135()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_136()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_137()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_138()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_139()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_140()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_141()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_142()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_143()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_144()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_145()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_146()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_147()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_148()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_149()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_150()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_151()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_152()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_153()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_154()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_155()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_156()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_157()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_158()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_159()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_160()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_161()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_162()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_163()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_164()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 32768 total numbers made up of 16384 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_42()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_43()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_44()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_45()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_46()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_47()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_48()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_49()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_50()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_51()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_52()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_53()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_54()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_55()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_56()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_57()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_58()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_59()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_60()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_61()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_62()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_63()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_64()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_65()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_66()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_67()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_68()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_69()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_70()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_71()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_72()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_73()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_74()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_75()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_76()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_77()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_78()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_79()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_80()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_81()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_82()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_83()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_84()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_85()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_86()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_87()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_88()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_89()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_90()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_91()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_92()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_93()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_94()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_95()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_96()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_97()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_98()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_99()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_100()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_101()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_102()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_103()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_104()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_105()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_106()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_107()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_108()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_109()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_110()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_111()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_112()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_113()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_114()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_115()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_116()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_117()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_118()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_119()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_120()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_121()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_122()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_123()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_124()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_125()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_126()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_127()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_128()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_129()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_130()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_131()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_132()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_133()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_134()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_135()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_136()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_137()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_138()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_139()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_140()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_141()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_142()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_143()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_144()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_145()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_146()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_147()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_148()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_149()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_150()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_151()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_152()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_153()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_154()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_155()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_156()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_157()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_158()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_159()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_160()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_161()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_162()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_163()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_164()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD008 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD008().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD008\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD008 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD008_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD008_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD008_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD008_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
