####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD007.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD007.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD007.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD007.x3d'),
    GeoLOD(center=(-44.940476,-45.000000,29850.000000),child1Url=["MarsLOD008.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD008.x3d"],range=1.8E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars002.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars002.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,-90.000000,0.000000),height=[3302.536,3334.9463,3367.334,3352.938,3344.0051,3331.6318,3366.4285,3429.5752,3452.6716,3451.5122,3471.4216,3525.358,3586.429,3600.7551,3614.5273,3617.8801,3645.8284,3689.5735,3709.3806,3727.196,3748.4263,3764.1855,3781.7837,3805.5344,3823.3513,3817.9211,3805.1663,3899.6948,3956.566,3968.2175,3977.5474,3990.181,4026.1018,4064.0938,4079.6929,4105.711,4127.0254,4149.909,4160.8677,4174.479,4193.386,4214.9507,4239.033,4257.0205,4265.8535,4278.1255,4290.2686,4293.051,4290.885,4316.301,4356.023,4358.5176,4365.808,4366.7144,4367.884,4373.995,4356.661,4330.3696,4379.2085,4327.806,4311.0034,4331.9434,4337.984,4328.7573,2843.3691,2863.0544,2884.4514,2905.3127,2913.1733,2912.8115,2946.1113,2986.404,3013.3662,3043.4,3079.2185,3117.3552,3173.5232,3202.4465,3257.2742,3292.1128,3332.708,3382.1099,3406.5063,3450.9143,3471.4382,3416.7156,3469.8218,3613.9692,3673.3235,3749.3406,3783.5378,3853.2441,3879.1497,3892.1938,3907.513,3918.9294,3912.3328,3877.4446,3886.7388,3987.568,4081.5115,4127.0635,4143.331,4154.2974,4211.24,4245.5903,4262.766,4289.5776,4312.444,4344.733,4375.8896,4363.614,4328.12,4420.509,4594.5156,4622.6714,4644.4214,4664.0254,4679.6763,4691.666,4686.8164,4694.8706,4707.2256,4683.5234,4681.9673,4666.656,4640.299,4618.373,2429.332,2474.3047,2509.185,2542.4907,2595.2205,2649.1428,2693.5908,2717.2935,2729.751,2718.6936,2688.6697,2655.732,2612.7007,2667.8823,2741.2896,2852.204,2958.3997,2989.139,2966.5327,2921.0645,2907.041,2909.9214,3120.346,3272.2068,3312.863,3312.3098,3309.1577,3327.6702,3364.1091,3425.923,3460.7358,3434.6836,3388.4812,3395.29,3411.5137,3486.1377,3628.7673,3765.2544,3833.2952,3864.93,3904.3716,3937.0903,3951.6138,3962.3904,3916.933,3864.8052,3824.479,3857.2932,3930.785,3974.725,4014.455,4028.927,4035.2788,4050.2993,4063.4888,4075.4517,4091.092,4110.979,4119.884,4119.783,4114.497,4105.806,4089.1956,4064.4702,2299.018,2303.4343,2289.5618,2123.899,2021.4846,2067.1052,2118.7327,2149.4517,2153.6924,2182.6255,2242.154,2314.0269,2352.968,2366.811,2339.9312,2330.6008,2300.44,2285.1296,2260.3745,2209.7668,2217.5588,2243.5818,2189.5032,2264.894,2479.6445,2628.622,2700.8333,2701.1228,2663.819,2632.55,2651.9807,2671.7917,2583.9297,2576.9407,2591.261,2529.01,2383.5593,2394.5771,2455.773,2476.914,2467.5056,2474.497,2521.6174,2529.4016,2513.1255,2462.114,2430.951,2377.2507,2292.7905,2222.1921,2210.398,2208.5579,2213.1887,2206.5144,2168.956,2146.277,2144.4297,2190.8975,2222.849,2248.3882,2291.7744,2356.3723,2341.3904,2286.028,2380.4285,2384.7058,2314.1914,2241.9512,2087.9116,2085.235,2005.261,1975.4298,1913.712,1879.602,2001.592,2001.3915,1960.0171,2021.1085,2053.2048,2047.0865,1986.2007,1835.0371,1669.1517,1578.8556,1504.3224,1656.4413,1781.8243,1701.2356,1708.28,1827.9767,1832.7667,1723.1233,1695.6672,1784.3075,1813.2592,1771.3617,1645.5975,1630.7346,1812.9744,1742.9756,1614.2452,1543.2352,1485.0872,1457.3834,1523.3141,1592.7754,1750.0212,1726.9167,1636.247,1601.5334,1703.9974,1764.514,1792.757,1818.6188,1818.1422,1821.1216,1883.6523,1885.3776,1877.3739,1884.0394,1914.6641,1961.418,1986.3522,2026.8231,2054.805,2024.1093,2065.0671,2110.1863,2290.305,2287.2454,2327.5383,2341.8408,2113.8953,2105.2073,2197.0576,2173.0967,2012.9221,1895.2577,1831.8357,1750.5038,1356.057,1373.8352,1564.8073,1318.6874,1459.1766,1673.6061,1609.3031,1258.0824,1227.635,1469.3379,1535.8885,1448.3195,1444.4789,1432.9315,1447.7825,1425.4023,1420.2845,1399.9813,1389.9869,1389.907,1393.2186,1437.744,1512.9479,1553.1261,1563.1797,1657.045,1698.1062,1664.5657,1647.7141,1632.1061,1640.4199,1663.2233,1703.6766,1724.1355,1714.7207,1698.3748,1708.4565,1613.2966,1752.9586,1878.4049,1938.9458,1962.562,1977.6409,1986.142,1986.179,1983.7821,1972.126,2005.6289,2030.7587,2048.7039,2040.6035,2059.716,1972.8969,1977.8424,1997.1167,2005.1165,2028.2339,2045.7358,2043.0203,2004.284,2043.2994,1883.0677,1817.1678,1659.9979,1131.3715,1104.1888,1000.9232,1117.646,1536.8381,1664.365,1334.2759,1083.0526,1188.0209,1370.5736,1279.4846,1357.9226,1616.145,1557.5209,1444.715,1414.3893,1339.4349,1323.644,1357.6481,1368.0652,1391.6078,1374.5349,1379.5538,1378.353,1418.4047,1445.2744,1496.915,1477.6879,1481.4363,1489.4158,1487.6095,1530.7452,1533.982,1531.7762,1537.1812,1538.1538,1581.5782,1632.618,1596.9924,1587.833,1630.2571,1752.9849,1779.4966,1780.7725,1743.2925,1770.2526,1821.1942,1792.738,1797.4856,1757.9819,1736.0891,1705.6042,1852.2283,1990.2375,2078.5415,2131.5415,2141.2385,1932.77,1655.6605,1278.3572,1499.422,1571.8087,1130.5314,1106.8567,1149.3129,1183.0653,1183.5146,900.2121,1326.557,1439.8129,1259.9663,1326.3064,1530.2512,1431.0552,1506.1011,1735.353,1796.7805,1709.6663,1614.7037,1536.1576,1315.8534,1217.789,1190.9227,1239.483,1286.8691,1299.6465,1313.207,1301.4329,1347.4221,1354.3322,1344.4998,1318.822,1311.168,1324.6334,1330.6105,1319.297,1313.2096,1308.482,1355.1228,1423.5791,1511.3146,1552.2913,1463.5803,1280.4078,1383.4945,1422.1661,1465.3434,1505.0955,1547.9705,1512.3865,1526.8486,1539.535,1580.2307,1742.91,1885.5037,1803.31,1767.7635,2015.8439,2117.375,1907.547,2172.3743,2242.9158,2219.1208,1796.4714,1592.5552,1702.0875,1773.6586,1884.3744,1853.8693,1656.5732,1764.0131,1541.5703,1763.6598,1525.9633,1487.8068,1556.5051,1541.9875,1422.3169,1341.9575,1315.4209,1385.196,1415.189,1302.7427,1221.3159,1170.59,1177.5609,1175.142,1167.2102,1161.3075,1165.9576,1170.6444,1206.9905,1240.3403,1253.3931,1248.2676,1261.5885,1309.8748,1305.5686,1309.2241,1289.7164,1355.2428,1426.287,1439.9053,1475.4626,1491.5858,1541.2047,1578.8833,1636.8547,1672.4382,1690.3771,1689.3501,1641.829,1569.2177,1561.2998,1572.2592,1585.2172,1609.4012,1668.613,1655.4385,1751.5452,1546.495,1620.8737,1733.8588,1774.6079,1791.777,1898.9318,1980.8481,1943.8436,1864.4229,1998.0276,2189.6243,2178.9216,2019.9353,1709.2091,1566.8488,1484.5393,1522.0559,1361.8313,1256.7595,1115.3872,1117.5852,1124.2946,1113.1115,1134.8625,1132.4926,1133.5533,1118.1229,1116.3158,1124.5001,1147.653,1161.8534,1178.9868,1171.928,1189.2792,1282.065,1319.479,1398.6536,1383.2555,1421.8804,1462.2438,1538.5968,1563.2295,1472.5785,1485.3029,1592.6903,1641.3436,1586.3167,1668.5306,1670.6226,1688.1986,1691.35,1679.1727,1662.1366,1578.2794,1547.5836,1572.7367,1534.6877,1482.1649,1559.0116,1513.313,1591.0793,1580.853,1550.5,1567.5132,1487.234,1474.6903,1482.3666,1516.434,1577.1758,1681.3059,1548.2167,1354.2662,1455.721,1740.6266,1658.2478,1668.9465,1603.5524,1496.4698,1353.0513,1235.5953,1172.7318,1045.8,980.1836,966.48096,947.7843,946.17145,960.43146,989.8633,1017.78,1047.2651,1063.6448,1067.6449,1102.4,1108.1614,1133.5337,1180.846,1055.3624,933.7438,1042.2542,1243.3151,1247.7776,1390.6157,1535.7523,1606.9897,1705.8177,1667.7063,1650.9927,1651.2229,1580.1558,1476.9773,1559.3616,1538.1301,1483.7317,1481.8062,1508.6405,1492.1432,1486.4678,1553.3696,1526.2898,1531.6321,1504.0039,1466.364,1383.6198,1333.382,1462.7773,1503.1615,1517.4235,1566.0377,1471.7246,1467.8455,1495.8063,1603.7128,1476.451,703.29834,446.48544,574.406,467.33347,370.8548,403.44275,682.3563,1452.4797,1321.2153,1073.0052,1009.879,969.443,937.5796,908.94226,893.65375,884.36896,881.9732,886.9105,916.365,954.4984,1041.1691,1119.358,1104.0435,1155.3452,1162.0408,1059.123,1030.4791,1029.8401,1048.8131,1085.7225,1095.943,1115.4174,1264.6012,1394.6226,1273.0665,1248.666,1291.3206,1569.0178,1646.739,1661.5205,1534.7842,1401.7855,1420.563,1617.2373,1699.7998,1617.382,1522.8055,1523.6991,1480.2191,1389.9163,1387.292,1394.108,1165.5812,1072.3865,1128.9645,1289.8884,1227.2458,1180.5786,1399.7056,1468.896,1458.7089,1589.4368,1725.8833,1551.4064,667.22174,302.52176,38.88199,228.35287,211.76364,260.6269,884.9017,1426.5508,1185.1195,999.2166,926.25287,912.85333,873.2286,893.12885,888.77374,860.93616,869.0742,917.72955,996.4159,1040.8113,1154.465,1223.3475,982.2658,888.908,906.0849,974.3236,981.22815,987.7168,1024.6661,1370.7451,1419.9662,1298.8618,1299.4614,1290.663,1352.4122,1238.6431,1288.937,1352.7527,1049.0708,1551.7013,1843.7611,1856.4601,1962.276,2041.7021,2111.412,1904.1283,1737.9703,1555.4358,1450.2534,1312.4451,1237.3674,1292.2126,1246.2029,1270.903,1381.3195,1346.9106,1328.73,1221.231,889.0193,402.8584,449.58197,1365.5289,1554.8047,1480.2678,1424.2828,1286.151,771.3221,1024.9204,629.57153,582.04083,1155.5662,1089.0878,938.9877,938.0008,888.71533,905.82166,907.5682,933.20355,968.8918,953.2487,953.34094,1029.6545,1109.2094,1082.6846,927.21045,937.4869,940.9119,959.4256,1077.5804,1099.3999,1200.824,1181.3259,1309.1838,1588.2386,1572.7229,1483.7067,1462.0255,1452.4235,1339.6765,1328.9248,1343.7299,1352.104,1397.6008,1360.9454,1573.865,1630.9977,1774.8317,1777.5938,1760.1802,1479.4521,1119.418,924.6133,1030.7147,1421.487,1476.6746,1509.4635,1597.0991,1552.8506,1560.6663,1555.6462,1385.7816,1335.1218,1190.656,1215.3406,1285.243,1321.5966,1277.171,1279.2135,1224.273,1205.8121,1152.604,1115.7395,1062.6239,1043.8331,1032.2765,1000.73694,999.38477,967.41547,934.6702,914.7297,907.3963,911.0706,864.54425,1001.0573,1245.1611,1066.7439,863.4307,898.0557,852.26434,904.2256,1042.225,1255.4517,1410.9761,1410.7098,1360.8573,1362.3323,1367.1012,1401.9456,1425.6918,1499.1318,1352.3641,1547.3323,1278.5208,1163.2023,1020.9977,940.3939,1113.5641,1038.5056,1337.6221,1662.551,1863.9127,1895.3325,1810.9064,1733.4519,1605.2649,1656.8368,1222.1206,1634.1243,1682.8107,1653.5845,1671.7949,1595.0167,1593.7861,1708.9574,1555.6097,1403.9512,1396.7421,1325.3435,1297.2103,1331.6241,1237.8962,1264.9485,1147.8645,1169.3069,1197.7885,1114.1626,1094.7766,1039.232,1046.169,1077.4098,1055.5409,1038.3108,980.0306,923.2892,923.4716,874.80804,853.96155,1056.9492,1362.9937,1173.7349,936.9094,854.3942,848.2155,906.86115,1202.8412,1294.3364,859.43915,-77.04941,-208.24942,3.379155,672.68555,1384.5391,1381.1996,1333.4296,1315.2638,1283.3816,1189.8048,1057.7185,948.98145,1084.4994,1176.247,1494.0741,1772.4283,1816.0704,1976.4785,2059.2493,1840.7109,2014.2706,1944.3557,1777.8492,1737.1979,1606.6278,1470.122,1458.7135,1430.9092,1376.2839,1366.7266,1411.9482,1413.2096,1331.3646,1400.4131,1303.8513,1250.7533,1278.0398,1200.2147,1165.1815,1142.715,1147.7876,1180.2184,1197.6687,1230.7482,1216.5396,1113.2412,1099.5955,1059.7299,997.5948,971.1655,928.2195,939.15955,902.5771,1020.90686,1412.9233,1672.0554,1328.145,925.9457,712.0639,767.53674,868.12164,936.21875,453.5891,-79.43353,-615.4599,-664.854,-188.90019,653.90137,1475.2181,1464.404,1273.1555,1228.0754,1117.1598,1061.0975,1018.5923,918.45654,1074.9792,1298.8048,1681.5566,1830.33,1673.5884,1626.2848,2167.706,1993.0739,1982.8247,1799.859,1438.2969,1391.5243,1458.6278,1392.0718,1415.8859,1393.3785,1362.4646,1364.2584,1420.6636,1432.8063,1293.6245,1237.775,1268.5342,1163.0164,1305.2411,1357.4161,1185.8036,1193.1727,1263.9369,1317.4807,1365.2073,1429.9873,1508.6637,1591.6742,1488.563,1300.9869,1212.2356,1265.8385,1323.3372,930.5704,1021.48737,1184.223,1224.6763,32.845036,-224.8958,636.9905,650.86426,617.26874,632.62024,794.548,945.3982,1109.6749,1175.5784,1180.5538,1340.0436,1182.441,1142.1895,1145.1976,1094.7545,1189.2767,1187.9901,1110.663,1068.659,914.75525,719.4249,756.0874,896.47675,931.81036,970.9313,1547.0569,1673.8159,1901.9602,1929.6517,1904.3406,1720.3569,1567.6205,1631.8182,1431.8124,1364.9816,1364.9481,1391.2604,1320.7003,553.3227,1416.1239,1511.2313,1460.1018,1606.3735,1692.3458,1361.4708,1335.4329,1289.1559,1392.2545,1457.5248,1457.3566,1317.598,1591.9374,1418.5826,1731.4708,895.00586,1377.9767,1612.4098,1599.457,992.7228,811.08954,900.21027,939.52374,911.1155,748.6687,727.6704,903.4733,835.6026,690.59,395.37338,241.31277,334.6215,805.67487,911.3559,445.44354,1129.8749,1162.374,861.618,842.5169,1082.9324,1164.6392,1242.3726,911.07214,565.9881,652.0009,796.14685,583.29565,592.48145,652.06665,821.9225,819.2931,1064.5433,1468.3861,1627.3425,1648.8917,1656.0106,1603.2046,1639.8108,1538.4133,1482.7035,1519.6553,1427.8718,1403.2911,1366.6658,1440.7032,1445.8082,1418.7029,2117.001,2180.2327,1382.9554,1174.5514,1150.4863,1214.4929,1302.5707,1459.5002,1319.586,1250.9757,1287.5403,1379.5415,1518.071,1485.246,913.1599,838.2547,715.8245,767.1169,818.8188,765.21606,765.0213,838.4423,792.2788,765.6117,745.28265,617.77356,588.768,230.85493,31.689589,193.82674,617.5935,780.20123,818.3927,408.2416,282.6199,472.85233,730.7842,963.27783,1236.1528,702.80493,-260.28598,-105.78223,840.77094,923.4878,871.0387,832.1515,1031.7614,1215.3628,1437.4434,1820.1361,1784.2865,1480.799,1416.0829,1295.2299,1469.277,1552.7651,1582.9503,1637.6674,1804.527,1672.0577,1459.5665,1371.4119,1370.1333,1339.1061,2036.0773,1347.1334,1073.7743,992.82556,919.74927,827.71606,783.71063,731.57184,775.46185,722.6725,716.14636,847.3494,1199.0375,1068.7009,746.95044,968.67065,868.3417,986.6521,922.71234,752.38873,678.12305,829.0871,844.78125,717.7078,1116.2,989.335,656.4324,396.01108,309.75534,33.46842,418.7467,927.6247,260.6794,196.2246,332.95728,585.38635,478.1365,885.86707,1067.5059,367.45905,377.9529,645.314,1491.2211,932.095,1042.549,924.77966,1154.3856,1193.6349,1289.1769,2125.2383,2197.938,2123.752,1824.4465,1518.3322,1470.7152,1492.059,1461.2302,1440.7278,1578.6165,1457.6564,1347.4563,1394.8904,1460.7532,1432.9211,1500.345,1364.5773,1120.7378,936.11975,774.7716,698.7059,718.45184,707.6219,685.21655,667.79486,641.46765,645.4403,644.9494,744.9237,923.1002,1103.7206,1067.2885,1131.1406,1008.0693,757.1402,825.73566,1033.2562,1246.0127,1182.617,525.9583,356.4029,342.09454,1346.134,782.748,-564.45026,277.01447,1443.3302,933.96326,566.484,1222.4749,913.11615,724.80914,111.50072,29.642443,561.72406,7.349793,165.57913,443.63828,943.3149,1254.2384,1314.331,1447.9093,1386.4146,1368.3171,1353.1976,1744.5247,1777.4293,1759.6775,1601.3934,1773.0277,1672.1138,1333.9564,1243.8534,1453.5118,1592.2739,1496.0836,1637.8738,2121.0894,1762.3844,1387.6644,1638.1024,1769.6425,1632.4875,1226.3553,998.29175,704.5825,624.30316,632.6736,620.5756,689.8844,623.62225,738.9392,880.71027,1257.9208,1552.4791,1539.5116,1566.6191,1641.986,1645.0066,1356.7113,1389.5168,739.2943,708.24585,545.33954,1480.7944,773.9634,149.904,-143.83836,-868.2559,-709.3896,515.8169,-733.9071,-616.76276,1456.8589,320.16962,-536.2356,648.057,1520.6522,643.51605,334.58893,484.76605,210.44716,-242.18663,51.73256,548.1865,845.9394,996.17053,8.211815,-393.30432,-239.32542,1050.0706,1617.7028,1552.5223,1606.259,1441.6528,1363.2738,1324.7106,1369.1289,1582.9708,1706.4679,1723.0144,1660.3914,1487.3702,1718.2919,2075.0515,2273.8887,2113.3093,1490.9834,897.8372,714.6422,633.2138,656.0678,782.9272,846.07166,908.6132,1599.4354,1580.2148,1645.6423,2074.2112,1825.682,2119.4382,1654.0568,1990.749,1615.787,1880.8871,441.2036,-606.3271,-575.5076,-328.0454,1125.3075,-399.1923,-1406.3165,-1570.4711,-1448.2997,-1375.2799,-2404.8193,-2279.165,-872.6072,-1428.9004,-2293.368,-574.4871,1574.4443,2403.4438,1199.5294,803.4525,25.767756,-28.525545,146.40672,30.050013,306.90073,497.26685,218.76881,88.07752,362.87582,1311.676,1459.1038,1411.7122,1484.7699,1334.0367,1507.2074,1545.1271,1459.7834,1364.2562,1603.0349,1734.2927,1718.426,1686.2681,1811.0728,2143.48,1763.4795,1572.1346,1384.7589,1179.9098,1096.3585,980.5565,828.7067,760.59467,700.4538,898.3621,1507.6886,1369.286,2403.267,1968.5396,2323.9395,2470.181,1667.697,2047.8275,998.9073,379.52905,-532.52484,-675.8082,-571.08057,-611.4349,-99.123146,-982.6672,-2480.443,-2869.9326,-2846.0696,-2972.8667,-2752.823,-2757.213,-2666.8777,-2697.431,-2617.9702,-1945.9772,-919.4031,-11.332399,160.86023,-30.503517,196.17467,1438.1583,810.8193,447.55847,245.34839,454.55072,612.8514,528.038,791.88916,1109.4244,1079.8162,1069.8135,1072.3301,1193.2487,1365.0612,1445.8776,1536.2142,1672.9849,1610.6315,1653.7161,1755.0653,1649.9733,1678.7405,1609.2576,1414.7335,1456.787,1178.4923,383.68408,399.44214,1275.9808,1861.1415,1378.366,1253.4731,1303.8024,1709.6498,1763.1644,1433.4803,968.308,1578.3497,1892.3638,1715.1643,1689.0886,1015.5359,718.6922,-400.043,-831.0436,-713.8503,-930.2688,-1811.3103,-2937.3052,-3226.2773,-2997.0664,-2842.7056,-2780.7832,-2745.238,-2800.53,-2822.3418,-2797.175,-2593.161,-2393.4412,-1793.8159,-1438.1841,-886.4376,72.442055,876.50323,1171.9232,720.2615,39.17268,364.585,776.5162,653.4668,430.09314,396.80368,555.8046,691.68964,630.38513,940.03326,1101.5242,751.82666,489.65268,1359.7732,1678.8783,1397.6445,1408.32,1360.1438,1544.2804,1540.7648,1454.5674,1412.2885,1576.2997,581.1818,-454.7475,-601.0097,474.6824,2193.3474,2042.6329,2060.0745,2086.7456,2310.9707,1167.8502,792.8655,364.40033,353.76013,623.79504,822.3574,1507.1204,1766.4347,1043.6852,218.0482,-65.71461,-770.70526,-1328.5657,-2705.6814,-3068.9543,-2925.2703,-2737.3184,-2762.6914,-2725.1501,-2752.6082,-2829.0,-2812.7996,-2800.9446,-2686.601,-2400.3853,-1935.2582,-1297.0094,-1438.1779,-1874.2462,-1637.8267,496.77707,856.12964,324.1718,426.41348,667.04364,571.2331,432.92038,414.19363,620.86694,849.7277,844.6893,1211.2843,1323.6802,400.40726,51.631203,850.38983,1369.3124,1209.0186,1298.4115,1345.9631,1378.9432,1532.4641,1449.225,1402.0425,1585.0414,1692.3862,979.3498,1105.0209,1880.4795,1810.3217,1922.8065,2429.7544,2635.286,2780.3188,2485.2324,966.5467,261.08026,112.20083,138.52592,969.2474,1113.8676,1153.9501,1233.6718,617.78345,-252.46931,-722.3547,-1772.6411,-2549.5647,-3021.521,-2871.9521,-2591.911,-2855.593,-2786.2708,-2819.7131,-2816.9465,-2818.8018,-2881.624,-2970.6577,-2823.8174,-1910.0298,-735.4064,-1851.4434,-2293.7083,-2188.4717,-1192.5801,423.54102,212.21234,685.83704,732.7295,676.5263,546.56476,531.8438,620.58545,894.6878,1090.6777,1319.5793,1522.7368,1751.4841,1950.3358,1817.9102,1328.6973,859.83997,1205.0386,1340.0161,1331.0765,1636.145,1614.7999,1596.534,1665.1971,1730.4998,1901.7445,1925.7373,1986.1362,2015.6028,2382.5144,2668.5999,2749.8738,2835.4077,2692.411,2213.4744,1476.2482,977.30884,1017.9088,1624.1101,1756.6143,1643.458,84.053566,-284.27988,-377.09558,-707.26807,-1135.8953,-1950.9377,-2493.328,-3125.228,-2979.018,-2856.0798,-2883.3916,-2793.614,-2828.5317,-2946.407,-3034.0222,-2886.6562,-2665.5881,-2335.1663,-1087.2312,-822.4932,-1000.7027,-219.2844,1064.7941,239.70453,-286.85504,812.45465,814.6509,784.53986,501.48535,557.7322,696.22003,998.41437,1114.5089,1347.542,1539.9685,1699.6127,1928.6771,1657.1556,602.99835,264.5625,777.63135,1335.1344,1374.9603,1921.496,1924.015,1866.971,1898.412,1937.2424,1971.47,2110.5059,2194.764,2336.104,2532.4414,2750.6304,2731.206,2838.7087,2781.1262,2379.4692,1998.74,2184.9675,2415.725,1992.388,1984.9236,1839.1383,1427.2095,1073.1342,359.712,-171.64078,-1159.1394,-651.08386,-392.71667,-2204.7913,-3269.7954,-3078.9304,-3072.4736,-2969.3364,-3060.6113,-3092.2034,-3133.4543,-2931.8098,-2794.0007,-2673.99,-1161.1351,-596.6263,-633.74866,-270.70163,217.24329,135.61201,-242.34799,649.4765,1013.9471,1144.2341,839.3843,600.0391,1001.07294,1113.0889,1139.8397,1395.4249,1492.2084,1602.3695,1702.4993,1692.3882,1259.89,1359.6968,1278.9337,1226.0852,1306.145,2453.912,2209.6814,2225.3762,2348.8608,2497.8433,2552.297,2570.2393,2642.3477,2702.0647,2759.945,2728.8154,3291.8696,3226.5864,2776.137,2248.4558,2190.8083,2141.3916,2119.8127,1584.425,1470.5618,1170.8143,1194.1538,874.3148,455.17676,339.18448,13.706398,190.59805,36.0349,-1201.5182,-2194.8745,-3219.98,-3383.233,-3366.6355,-3334.8477,-3274.6108,-3278.4604,-3105.2034,-2919.9463,-2429.0642,-1484.2544,-1067.6161,-523.5357,-580.5786,104.19119,734.0958,778.70056,971.9935,928.8948,791.7943,1060.8654,922.31726,1024.4948,1278.2186,1397.346,1470.2504,1511.9454,1600.523,1607.5314,1748.7997,1598.7688,1147.1158,1183.2174,1174.0375,930.10895,2337.03,2289.9604,2314.2842,2456.2637,2639.8408,2784.3123,2862.7712,2923.37,2961.2563,2872.477,2967.2976,3172.1636,3300.4497,3226.3462,2501.3806,2215.5984,2101.8975,1971.0647,1693.1886,1518.2123,1457.2609,1097.0768,785.90027,483.47546,324.77545,377.36166,-128.58357,-482.33624,-1479.4988,-1385.3832,-2458.7078,-3457.547,-3836.4412,-3226.7446,-3426.8005,-3326.9204,-3106.7097,-2750.2568,-1861.4895,-1027.7888,-1118.5538,-554.6904,-758.11066,-241.63226,931.2061,1118.3909,1121.9615,1056.1802,464.3509,1061.1622,1157.0895,736.75916,1303.65,1474.7584,1523.1423,1647.7489,1677.4917,1622.297,1774.5052,1522.1975,1138.805,1174.4834,1134.0836,1233.127,2301.6782,2356.7717,2443.8428,2690.7212,2774.294,2835.8516,2976.2295,3063.15,3074.2869,3021.4102,2978.8606,3105.335,3094.0242,2958.6707,2324.5132,2136.1208,2358.6804,2292.27,1773.5293,1444.3461,1599.2347,1663.5353,1789.045,892.3048,805.3328,1180.4298,642.8581,-498.13925,240.0639,-862.4374,-1505.9738,-1816.5287,-1889.8883,-2439.4868,-2510.5642,-2571.3462,-2038.7925,-1982.5647,-1473.863,-576.49786,-1115.427,-746.2566,-243.37569,703.4856,853.5129,863.354,687.5377,985.86163,895.4449,1043.8834,476.58557,-1140.9207,262.4072,1386.1725,1282.1265,1538.5331,1523.1276,1210.1981,1628.2893,1151.5414,1186.7913,1177.3828,1301.029,1585.9141,3657.3984,3343.155,3360.657,3347.7158,3124.2268,2917.9832,3143.0923,3417.4778,3329.3386,2674.8335,3291.497,3245.6807,3396.3618,3173.4282,2853.321,2715.1296,2763.7498,2579.939,2117.4954,1523.922,1729.5117,1945.4105,2276.7336,1811.6937,882.4701,759.5288,823.6327,1002.67786,-250.6579,-554.94055,-698.5362,-1403.8295,-1446.2056,-1538.4266,-1653.8638,-1784.2197,-1143.1757,-847.677,-570.55334,-661.4837,-432.67923,21.464083,484.4265,351.24335,466.54343,-123.97326,74.84632,487.94284,499.49713,949.8962,894.95056,450.35977,1200.0,1619.1356,1387.708,1337.0667,1408.9867,1521.5891,1258.9266,1214.5059,1111.9653,1128.5773,1335.8967,1366.9652,4705.451,4557.7266,5019.9004,4832.424,4643.6216,3669.8252,3472.3787,3500.789,3456.6765,3301.989,3400.1392,3381.126,3288.7397,3196.763,3137.652,3029.9558,2744.1814,2358.6577,2042.3986,1733.0692,1869.3635,2057.0254,2329.8206,2681.9114,1881.2933,1181.0104,1161.1708,31.555183,-399.62222,-289.9137,14.495155,-959.881,-1195.0298,-1464.6046,-1477.2933,-907.6705,-752.35803,-773.8182,-848.82733,-187.71318,523.5287,154.28442,-30.327421,-36.452324,168.3793,-536.2531,-283.09656,616.8078,894.66534,793.8935,744.2548,939.2717,1200.8163,1374.7886,1290.2816,1333.1296,1339.691,1470.2603,1180.7526,1084.1194,1108.6061,1029.0215,1179.7297,1195.8333,4886.1284,4837.213,4904.169,4954.8447,5167.1333,4985.365,4017.2097,3644.1646,3521.177,3437.3042,3403.1733,3379.6575,3267.3184,3191.388,3125.5515,3131.689,2772.864,2420.695,2292.7466,2355.2559,1975.4542,1912.9323,1988.7896,2103.1074,2371.99,1990.1609,1034.1648,728.39954,990.96735,906.9093,104.340195,-1203.3013,-1122.9454,-979.7727,-1123.4655,-848.2142,-682.0491,-1018.3467,-781.2075,165.10666,199.40422,-83.648415,-166.0924,-193.4849,128.51094,560.39276,728.892,677.02966,679.26764,794.951,794.45325,631.1919,648.75684,1236.2605,1156.4365,1235.7255,1330.7673,1369.1102,1063.5455,811.34784,569.36804,1095.8595,1198.7708,979.00836,4608.137,4745.5522,4390.89,4211.041,4422.9453,4719.196,4555.6123,4457.262,4013.6433,3617.861,3429.9084,3363.6934,3031.8113,3170.0962,2998.237,2781.36,2617.661,2424.1863,2358.088,2370.521,2349.7896,2434.8376,1829.2311,1696.8008,1798.4806,1552.4863,1398.0282,1436.1688,1873.3907,1524.695,576.9932,-708.11914,26.482779,479.11258,36.525593,-298.99805,272.99725,-446.96365,-318.6285,47.685265,47.65382,-358.9608,-157.77846,-362.3492,362.24072,485.2124,619.7384,524.7946,727.9051,869.1125,1029.4099,906.6275,904.6617,924.8157,810.2531,1178.9553,1304.2659,1264.4222,1284.4949,1230.0865,1166.7706,882.87714,1257.3102,896.7845,4975.1323,4685.446,4188.9546,4045.3496,4207.9375,4273.7603,4422.909,4577.24,4601.995,3977.1575,3567.8489,3222.325,3047.9785,3031.41,3013.14,2853.7095,2711.048,2501.5332,2418.1992,2389.667,2577.4897,2461.2175,1923.5437,1980.6741,1671.3108,1552.0295,1314.5846,1329.8337,1097.3535,52.737526,755.1268,337.87485,977.9953,991.83167,-225.11192,-401.7674,202.57945,-912.51526,-823.09985,-302.57712,-84.07782,490.6386,457.2691,279.63293,330.7962,341.23212,393.88162,333.65256,599.2061,904.05286,1219.3308,1191.1049,1263.5908,705.15906,440.94592,1076.6052,1264.97,1330.0668,1284.6414,1510.4146,1448.0227,1339.21,1214.7753,1171.5905,4287.235,4471.2417,3951.0232,4039.036,3901.6719,3856.9902,3919.2173,3899.75,4627.199,4858.397,4194.5933,3465.5745,3040.1685,2787.8215,2681.1145,2673.6763,2616.6448,2600.072,2603.1304,2596.711,2488.8267,2397.785,2254.2744,2039.2771,2224.7688,1523.2568,960.4954,1208.2982,1586.4818,1159.5337,1139.801,924.16565,1196.6212,900.2663,308.02316,118.20513,690.5998,-95.96128,-250.7913,520.98413,729.0232,488.30188,394.71558,335.77448,312.41144,310.70724,255.87015,246.44777,373.96823,695.1331,1021.1077,1212.575,1160.2166,1159.2422,1118.8951,1137.121,1390.7247,1481.4099,1601.0604,1603.5385,1472.983,1332.6145,1358.392,1384.9576,3789.0845,4167.586,3705.09,3539.758,3635.413,3539.4177,3546.3594,3930.6802,4520.1313,5395.043,5445.701,4305.764,3541.3896,2937.6497,2606.2695,2547.864,2598.2744,2610.668,2597.984,2586.2732,2557.1208,2384.5818,2068.821,1745.357,1968.501,1376.9226,896.0172,895.99493,768.2866,486.67355,887.23444,1058.2775,1108.6115,1077.2238,1045.0015,1038.8484,1112.0631,439.6065,-46.09751,933.54865,832.038,721.10266,631.89764,498.3122,332.42633,315.2286,308.94846,366.25113,291.02127,550.6121,877.3315,900.276,1006.7595,990.3442,917.955,1084.0642,1281.7128,1342.491,1449.056,1521.1002,1396.5256,1442.5192,1401.348,1413.8362,3505.1384,3394.518,3169.7427,3137.407,3178.9456,3119.192,3267.6409,3628.2766,4637.4243,4825.9023,5351.8975,4595.6353,3983.7122,3492.213,3169.5498,3161.8262,2622.7288,2570.325,2529.7532,2502.6465,2416.1213,2197.225,1836.429,1483.024,1243.6157,1401.3802,932.6391,847.9452,832.4852,787.59064,762.2313,682.9586,760.5461,830.2883,868.92175,765.2973,667.3518,-325.9531,-196.15851,890.87,817.62994,349.11795,755.0329,737.82385,448.7459,413.09818,83.93034,145.32124,266.3107,391.1235,474.26147,635.8605,517.16547,672.29285,831.29626,976.6492,1140.0706,1236.716,1344.0282,1366.928,1352.7246,1400.5079,1434.2762,1339.4517,3275.2822,3196.6184,3113.5168,3024.961,2950.3513,2927.485,2935.1885,3185.0137,4611.7397,4529.4556,4743.858,4400.658,4109.2075,4221.228,4494.498,4198.176,3376.6184,2911.645,2621.7686,2311.544,2092.6167,1820.9163,1491.127,1149.7914,1007.53076,1028.912,853.55566,777.9686,832.2893,773.7713,481.11783,599.459,598.7028,629.06915,697.12103,714.9816,387.60074,-516.8125,568.21136,600.8102,826.4074,654.4618,745.8835,666.7743,574.809,325.7125,401.34055,57.89318,79.4234,4.458011,457.70874,590.3489,655.31305,577.8822,778.4325,1007.2049,1159.4879,1335.1886,1458.2992,1500.3778,1559.4275,1466.7595,1440.1538,1468.1031,3292.9268,3134.904,3025.2798,2910.4888,2848.759,2791.257,2792.3228,2772.5999,3076.02,3688.6035,3974.7988,3817.6855,3664.1719,3813.5466,4445.003,4684.502,4322.17,3850.6968,2804.7402,2425.9888,2135.401,1778.9564,1258.1713,903.6962,799.95166,816.9827,874.75464,926.5309,959.58124,879.3822,842.0207,843.5561,679.86206,540.325,613.7306,599.39594,265.28644,70.61452,546.87555,286.0192,97.26953,442.3508,346.35773,408.3853,462.67923,474.57928,429.68576,139.78833,8.894088,36.787247,207.34297,144.1937,325.8318,400.86508,743.4244,797.9258,1040.6493,1347.5153,1392.6685,1459.8632,1598.7588,1652.9218,1522.5464,1405.3138,3164.4705,3019.1426,2920.5286,2820.3186,2748.4905,2690.838,2712.2375,2901.968,2733.1208,2733.7727,3162.0164,3316.8245,3472.3445,3419.616,3216.1963,3293.284,3093.6594,3084.3252,3018.1377,2799.6045,2638.767,2647.2375,1797.2643,1080.835,741.87933,715.5987,822.8636,339.81656,656.9143,737.853,786.34265,700.72473,562.6616,578.3426,597.9076,535.574,594.26263,44.591118,-356.69598,100.9493,127.060524,271.1941,346.2979,239.72458,200.7756,201.73326,34.54693,-102.96126,-55.633312,-106.55226,-95.67421,-19.541094,162.86292,223.86922,482.5026,772.2621,958.19556,1157.8815,1171.2126,1147.1975,1189.0319,1463.985,1635.7798,1570.4102,3150.4275,3002.022,2895.8555,2807.3071,2717.491,2630.068,2611.1238,2555.0232,2477.8418,2419.1018,2554.8318,2912.644,3464.948,3485.1282,3150.0334,2975.1716,2880.7134,2828.8765,2844.1218,2830.6023,2923.1943,3360.756,2816.9387,1481.1398,786.02264,635.08405,673.6959,727.6005,648.2439,680.81116,544.3484,564.1854,577.9367,808.6455,814.1727,799.52075,792.5768,608.0919,-367.2095,-1902.5405,-1036.5436,-519.568,289.26392,-488.69476,-156.02304,35.8888,-59.23166,-225.02792,-239.23138,-234.29613,-331.03397,-254.96422,-104.84147,71.57206,258.20575,463.07367,659.55853,825.39624,749.39075,797.61163,853.1603,1239.819,1405.6997,1511.9412,3258.166,3111.1714,2911.7917,2820.0996,2757.329,2678.5627,2638.1401,2537.4517,2422.6697,2409.5366,2536.6873,2842.7415,3594.0752,3743.5405,3323.2202,3000.426,2813.607,2738.7686,2723.5466,2742.5195,2843.2485,3037.216,3960.7078,1782.9844,1020.95966,916.17883,871.563,817.4307,772.0343,669.30316,721.55347,1152.4489,1170.3319,1029.5189,909.93994,849.55457,766.7435,815.772,310.74756,-1405.5787,-1366.8445,-1479.4275,-582.2555,-6.558687,-279.7376,-409.03748,-477.53885,-295.8598,-424.6849,-444.76974,-383.76602,-489.16226,-545.5854,-136.16945,-13.087103,-0.996318,513.8264,636.58624,450.83334,389.07654,519.801,664.1405,1237.4116,792.2181,3436.3958,3253.4219,3062.1597,2906.6785,2756.9553,2696.6775,2612.9175,2584.288,2391.1008,2381.5378,2404.3904,2607.5374,3472.556,3575.9282,3340.3967,3036.3796,2869.254,2767.6846,2770.492,2922.5837,3205.1968,3630.4749,3881.9534,1790.4368,1149.7372,1068.8927,1045.3455,1095.9626,977.7133,954.94006,1003.4533,999.45636,1196.387,971.86816,914.52185,953.0536,752.76825,732.4274,565.39465,-372.47345,-1023.0553,-1406.8282,-1150.3253,-746.6719,-469.17032,-546.5579,-580.6019,-293.09387,-653.31165,-714.0961,-471.35675,-417.88025,-622.5859,-669.0262,-641.43964,-464.12936,97.56767,433.2331,155.25363,4.721417,84.6509,441.7352,1213.2113,841.2296,3591.7175,3433.4272,3266.2915,3086.3591,2857.1035,2746.149,2662.666,2621.3774,2488.4924,2333.1082,2292.8274,2417.1982,3085.0664,3323.7798,3252.5566,3112.3362,2988.3484,2939.9534,2891.0808,3127.6287,3287.1614,3483.9043,3844.3337,2273.9275,1216.4236,1137.943,1201.6039,1396.3887,1430.4299,1015.18994,858.96027,1005.4334,973.0571,867.8934,860.5875,333.37924,729.88025,700.26825,473.63217,112.583984,-275.13483,-417.803,-625.8307,-1116.7555,-426.15656,-579.5792,-731.7021,-445.84467,-683.73883,-853.33325,-498.45682,-570.935,-605.7998,-767.4217,-1105.5168,-867.1694,-197.38086,289.5356,-40.886925,-164.86746,-116.94735,186.0702,1119.2485,1355.3804,3790.6155,3595.4475,3432.1436,3264.01,3072.9531,2910.686,2801.384,2712.3005,2579.8315,2422.0034,2411.0474,2488.3037,3032.0156,3264.5684,3001.2427,3295.0542,3223.3386,3090.3962,3161.28,3566.0344,3764.052,3570.7212,3614.6326,2563.5042,1341.7257,1259.0602,1366.365,1451.0686,1455.8707,1119.0948,954.1351,894.49744,885.31274,802.73425,854.82904,320.64304,605.67206,743.3401,496.5271,242.6193,-251.50111,-941.93524,-1585.9016,-1430.6245,-916.5719,-708.48224,-834.2618,-1073.4044,-1028.3885,-917.20337,-735.78064,-757.08984,-713.7443,-819.68555,-1103.0947,-879.71136,-522.01935,-313.0018,-70.146065,-179.6878,-161.06323,85.99522,537.21356,1051.781,4044.0242,3728.4165,3553.3174,3403.4343,3199.1233,3003.212,2920.4224,2797.291,2687.403,2550.2727,2524.769,2554.1143,2917.1157,3169.7644,3343.5215,3413.5972,3468.8557,3329.7678,3282.4172,3685.702,3699.9395,3661.2703,3317.3618,2155.5486,1495.4269,1510.0745,1557.5244,1550.3792,1407.5256,1154.3184,1003.16534,921.60876,864.2666,820.3719,851.7146,885.30597,450.88824,491.44284,438.34552,112.17314,-1060.9343,-1869.0587,-1979.3477,-2068.0723,-1646.3914,-1036.8086,-803.60724,-1290.7227,-1157.976,-1275.2642,-854.33356,-816.64264,-770.14325,-710.0878,-826.4212,-699.70844,-720.0473,-617.5371,-344.75446,-170.5991,-239.4305,-61.177135,131.84697,300.12723,4259.5757,4011.6204,3787.729,3592.7212,3437.509,3167.3801,3014.0552,2952.319,2816.1763,2747.1404,2680.1228,2642.5818,2706.977,3029.3062,3336.452,3566.6716,3777.8633,3625.0205,3315.318,3355.1995,3581.241,4563.4497,3570.6682,2060.2349,1603.5664,1727.9635,1797.6869,1466.413,1119.0176,599.44653,-319.45203,220.43286,624.2623,854.6941,842.99744,978.092,741.09033,387.80875,135.78128,-467.79544,-1714.3936,-2017.7498,-1989.6433,-1981.8597,-1931.9783,-1201.9379,-828.04565,-938.04034,-1205.4756,-1279.841,-1123.417,-1144.4396,-1012.44556,-1045.6562,-1391.5963,-1352.4263,-1316.114,-915.96216,-631.61633,-616.3462,-161.94283,-308.10815,-285.8291,82.08737,4519.7793,4256.911,4023.877,3813.9534,3614.1792,3375.516,3432.7998,3307.489,3023.2542,2932.9353,2960.3027,2844.218,2894.0176,3235.8125,3450.9392,3802.1035,4051.2131,4029.7346,3598.4204,3412.6294,3526.2825,3878.9634,3225.1772,2096.5413,1743.112,2036.3839,1950.2042,561.55994,-1979.0118,-2421.3604,-2895.8835,-2577.0073,-1024.9835,-488.241,479.61377,825.2357,732.418,340.92868,92.114784,-247.68091,-1350.5144,-1983.6838,-1957.3436,-2028.0366,-1945.0842,-1247.419,-884.194,-1066.9926,-1155.2548,-1116.7164,-1352.5479,-1233.9766,-1124.9945,-1073.4932,-1175.7278,-1244.384,-1118.2274,-902.07367,-753.8871,-776.7424,-559.3272,-428.46664,-360.41647,56.497864,4735.0415,4418.566,4186.8745,3961.3206,3808.6726,3660.623,3918.6335,3899.3894,3218.1147,3104.9097,3097.8855,3084.3196,3330.9236,3549.9807,3635.3503,3875.8894,4084.0298,4077.061,3565.694,3532.888,3265.5066,2931.1228,1375.7206,-1094.2726,-2306.3496,-1980.4778,-2910.2236,-2667.558,-3519.112,-3722.874,-3332.8843,-3716.1167,-3753.7073,-3901.7148,-78.285904,765.2717,284.82965,18.969233,-171.18414,-220.62782,-813.6401,-1494.1327,-1615.3898,-1786.8364,-1984.2743,-1449.3983,-1029.4098,-1270.9984,-1198.2172,-1407.6427,-1308.7169,-1233.8953,-1095.2567,-1130.7458,-1153.5284,-1117.488,-1026.188,-1092.5883,-831.2198,-759.3288,-651.3514,-537.27704,-363.68024,-269.5436,4910.7134,4569.0947,4356.681,4152.499,3966.35,3795.8696,3732.3958,3743.279,3381.5337,3229.972,3401.6965,3419.303,2301.6511,1137.5425,2219.689,2359.0747,2189.0105,2098.3318,1290.1528,1500.6742,-298.72055,-570.568,-2392.5354,-1845.0997,-269.75464,-158.6198,-1320.9158,-3986.917,-3250.7466,-1986.6853,-2016.4618,-2668.9392,-2749.894,-3031.7134,-1432.0349,227.90964,202.87672,-183.71571,-355.3412,-513.7575,-679.1982,-1003.4337,-1223.5825,-1265.1373,-1333.7904,-1717.5375,-1845.4467,-1725.5491,-1512.219,-1318.9473,-1222.0616,-1280.1447,-1085.614,-1116.1683,-1125.9115,-957.82733,-880.1879,-1588.1677,-1173.2709,-806.5128,-604.5262,-461.51678,-454.8528,-389.78076,5074.5566,4744.3994,4455.674,4255.618,4080.5747,3939.1643,3892.8289,3988.5789,3535.0544,3538.0154,3378.2117,640.30945,-1596.8502,-2059.7654,-2963.8762,-1937.8104,-2045.9974,-2837.676,-3585.1584,-2036.0172,820.5055,1730.2906,2017.5516,2307.4678,2449.5364,2318.0444,1855.6747,69.47339,-2720.8396,-3251.6494,-2647.9844,-1455.589,316.86526,287.23932,-2039.5675,-3235.1147,211.15523,-79.560936,-827.38873,-700.52094,-827.038,-948.33673,-1101.0529,-1201.6217,-1372.8616,-1822.5947,-2084.377,-2070.3542,-1872.4384,-1481.1268,-1325.8053,-1337.3901,-1310.6958,-1266.4088,-1502.7804,-892.64136,-1074.1696,-1497.9668,-1181.6776,-937.94,-1106.8369,-879.3844,-916.6916,-587.5809,4854.128,4806.435,4486.725,4334.224,4192.1807,4057.1948,4008.5645,4146.4976,3812.3884,3612.3984,961.2646,-1106.745,-3196.128,-4433.187,-4126.962,-2722.6372,-666.64886,1610.1531,3811.2048,4643.7065,3843.0977,3259.2927,2930.0447,2804.7124,2695.4976,2482.2034,2125.7993,1683.9297,1829.0581,1384.4802,-10.685636,-440.3983,-190.30345,977.88385,-120.543175,-3350.8076,-3181.5203,-1119.7806,-3463.466,-2606.9365,-1465.5281,-1004.27795,-1179.488,-1851.0024,-1706.6094,-1729.2216,-2066.2593,-2252.4639,-2000.2249,-1600.2834,-1300.29,-1418.7744,-1415.5029,-1409.5775,-1249.7549,-1415.4493,-1303.6351,-1342.02,-1422.7574,-1403.6383,-1281.54,-1091.4135,-784.1241,-738.56964,5187.964,4829.7324,4499.0527,4304.515,4212.787,4093.27,3870.1743,3501.25,1620.8776,-171.84677,-1638.9501,-2745.6252,-4110.532,-2752.4558,965.92224,3515.175,5007.8706,5306.8184,4952.519,4066.815,3373.116,3016.5793,2852.0981,2786.258,2456.661,2332.896,2084.7068,1303.8785,1626.202,1651.7625,-497.02637,750.48535,558.0802,574.18256,240.50664,-3212.6409,-3872.5981,-3670.9194,-4015.4014,-3746.313,-2667.11,-1660.4375,-1703.71,-2120.2825,-1316.0837,-1548.2429,-2179.4724,-2139.269,-2255.1145,-2154.8386,-1553.2131,-1327.249,-1452.1239,-1485.6351,-1414.421,-1486.6835,-1320.157,-1236.5599,-1780.4365,-1283.1744,-1104.5824,-1006.705,-970.9301,-1014.9108,5343.423,5025.092,4405.122,3580.0818,2785.851,1234.5588,-64.583176,-2015.3676,-2819.284,-2048.0195,-1984.0533,-2494.9456,-2746.7712,1276.4934,4245.409,3627.375,2679.769,1710.629,3326.1145,3362.0754,2803.1914,2702.451,2645.92,2638.019,2115.1262,2053.2783,-540.92645,-2063.3833,-2204.203,-2375.2085,-3114.6345,-2362.6975,-2504.3665,-2112.865,-1731.8541,-3161.1697,-4095.209,-4031.9043,-3994.563,-3902.0122,-3469.4768,-3474.797,-2916.701,-3158.2283,-1853.0735,-1708.1833,-2005.9109,-1573.5496,-2206.07,-2140.7993,-1716.943,-1508.0701,-1623.1058,-1581.1476,-1546.9291,-1525.1287,-1580.4106,-1448.078,-1711.5149,-1206.077,-989.17145,-994.3802,-886.8673,-1125.4067,3561.9062,3553.402,2413.0017,1433.5549,593.0534,1282.4128,1542.4078,1497.4512,2590.3298,2481.8315,964.4238,-1659.7474,-3620.3433,-871.07166,-282.17538,-882.4975,306.8096,1379.0516,2932.1104,2458.7285,2514.3215,2496.5566,2509.461,2313.314,2184.3347,2026.153,1116.1963,-497.90543,-2255.182,-2144.8323,-893.1669,-498.82672,98.17717,1095.7307,261.80746,-1292.8695,-2992.8142,-3985.7715,-4045.625,-3382.8423,-2970.5962,-3115.5903,-3228.3372,-3522.5557,-2595.539,-1540.1646,-1526.7861,-1552.7648,-1939.0875,-2270.3174,-1826.8195,-1797.0853,-1842.3414,-1781.9899,-1607.0131,-1631.7512,-1516.1671,-1459.1383,-1296.2212,-1059.6028,-1128.9014,-1018.71185,-1044.3486,-1016.8605,1673.1002,2799.4888,4001.961,3995.4658,4144.458,4381.2993,3841.5322,2201.9663,4156.2383,2105.8052,-895.11597,-687.2159,-2572.949,-1118.6165,1846.6643,3477.363,3583.4253,3323.8765,2352.513,1234.3219,1825.5907,2327.3452,2252.8079,2153.724,2284.159,2082.1934,1999.4523,1398.203,1060.5188,514.2137,602.8163,1252.3173,1057.3832,1255.9757,1179.1482,372.92337,-663.9309,-3030.2898,-3998.2278,-1526.2554,-824.1143,-1138.7988,-1876.5526,-3613.4067,-3029.4229,-2544.274,-1285.897,-1297.0862,-1622.2482,-2074.5105,-1678.837,-2124.2024,-2073.8142,-1950.0673,-1763.1085,-1649.9038,-1519.183,-1364.4187,-1232.327,-1184.8029,-1154.3507,-1121.7773,-1194.2505,-1228.5159,2249.7878,1043.4703,1415.9366,1749.1259,3331.4536,4057.2188,4040.4434,4181.327,4468.6064,3096.908,3103.3179,1376.609,-1157.6211,-999.25275,3462.5571,3734.7205,3222.152,2224.7017,1663.5765,-1472.8345,-1854.6523,1821.3932,1782.0583,1796.4846,2002.1852,1730.6824,1186.8591,1064.1118,1156.2421,619.5449,290.45282,979.28235,899.3723,491.40158,294.46533,-128.13092,-404.8867,-1566.1737,-3451.21,-1323.622,-958.622,-1031.4362,-1655.4734,-3733.7837,-3209.3982,-3000.6257,-1822.694,-1346.6146,-1512.9663,-2057.1477,-2390.0132,-2047.1794,-2159.8176,-2117.1965,-1808.0302,-1713.1025,-1634.7493,-1421.7778,-1384.9768,-1372.5837,-1377.9564,-1439.0049,-1389.1531,-1161.3192,4044.0813,3689.525,3412.61,3473.8425,3558.716,3749.05,4200.996,4245.304,4014.3662,4214.791,3942.5896,2966.2688,2100.4111,2536.131,3391.8755,3226.1743,2704.895,2358.0696,2132.3022,947.5538,-915.62775,2325.3923,1834.7638,1431.1843,1469.0845,1487.2107,178.22089,957.70105,890.1807,781.98145,-152.89964,282.0934,550.55365,240.76747,-231.24214,-491.99924,-720.31177,-1092.2883,-2564.208,-3176.2646,-1910.6769,-1521.5522,-2349.4414,-2761.0989,-2763.3457,-2490.7695,-1951.8337,-1694.4835,-1795.6757,-1969.7898,-2471.3308,-2331.2415,-2470.2751,-2239.9321,-1897.5836,-1816.6619,-1742.9115,-1801.4922,-1673.8241,-1507.0765,-1388.8481,-1360.7935,-1316.4612,-1215.9922,3137.991,2903.5264,2799.2583,2765.3303,2669.7622,2513.0107,2776.6973,3354.6494,2219.5984,779.8025,-768.26294,2141.3745,3473.1357,3381.568,3332.0508,2724.4058,2275.2837,1974.945,1877.4886,1609.4845,483.9944,1843.0442,1638.7332,1323.4092,1335.2482,1326.1113,1183.5896,887.96936,633.55304,684.9677,-642.13916,-512.9555,-293.80566,-286.05243,-695.19495,-1152.8354,-1862.3021,-1093.8081,-2132.9055,-4162.928,-2675.2542,-1869.4991,-1946.1058,-1996.6593,-2020.2299,-1823.217,-1804.7461,-1885.2639,-2130.2012,-2501.8782,-2733.1526,-2505.461,-2611.5452,-2284.4902,-1880.5531,-1969.8206,-1898.1637,-1880.718,-1632.0289,-1454.9398,-1388.3413,-1250.3137,-1211.2351,-1217.0905,2925.5825,2664.6853,2479.8933,2161.7483,1801.4552,1392.8225,287.18637,1422.4167,2551.0957,1873.533,2449.3464,3431.8372,3398.5159,3268.8306,2919.6582,2292.0562,1879.1665,1620.6492,1528.1433,1432.7888,803.4859,877.2123,1140.5265,974.4529,625.83234,865.8414,820.30945,775.72156,553.6789,544.5703,-599.1668,-2238.928,-147.23836,-352.01532,-757.6813,-1058.611,-3361.8616,-2771.8086,-3574.6897,-4578.152,-3403.829,-1743.6323,-1723.5631,-1877.3069,-1860.2405,-2027.2346,-1685.079,-1987.9003,-2019.3801,-1728.123,-2636.6572,-2880.9824,-2494.369,-2198.511,-1956.6431,-2099.095,-1991.9856,-1915.4783,-1680.3807,-1468.6737,-1404.6393,-1304.9363,-1225.0049,-1206.532],solid=False,xDimension=64,xSpacing=1.428571,yScale=50.0,zDimension=64,zSpacing=1.428571,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.01587,0.00391),(0.03175,0.00391),(0.04762,0.00391),(0.06349,0.00391),(0.07937,0.00391),(0.09524,0.00391),(0.11111,0.00391),(0.12698,0.00391),(0.14286,0.00391),(0.15873,0.00391),(0.1746,0.00391),(0.19048,0.00391),(0.20635,0.00391),(0.22222,0.00391),(0.2381,0.00391),(0.25397,0.00391),(0.26984,0.00391),(0.28571,0.00391),(0.30159,0.00391),(0.31746,0.00391),(0.33333,0.00391),(0.34921,0.00391),(0.36508,0.00391),(0.38095,0.00391),(0.39683,0.00391),(0.4127,0.00391),(0.42857,0.00391),(0.44444,0.00391),(0.46032,0.00391),(0.47619,0.00391),(0.49206,0.00391),(0.50794,0.00391),(0.52381,0.00391),(0.53968,0.00391),(0.55556,0.00391),(0.57143,0.00391),(0.5873,0.00391),(0.60317,0.00391),(0.61905,0.00391),(0.63492,0.00391),(0.65079,0.00391),(0.66667,0.00391),(0.68254,0.00391),(0.69841,0.00391),(0.71429,0.00391),(0.73016,0.00391),(0.74603,0.00391),(0.7619,0.00391),(0.77778,0.00391),(0.79365,0.00391),(0.80952,0.00391),(0.8254,0.00391),(0.84127,0.00391),(0.85714,0.00391),(0.87302,0.00391),(0.88889,0.00391),(0.90476,0.00391),(0.92063,0.00391),(0.93651,0.00391),(0.95238,0.00391),(0.96825,0.00391),(0.98413,0.00391),(0.99609,0.00391),(0.00391,0.01587),(0.01587,0.01587),(0.03175,0.01587),(0.04762,0.01587),(0.06349,0.01587),(0.07937,0.01587),(0.09524,0.01587),(0.11111,0.01587),(0.12698,0.01587),(0.14286,0.01587),(0.15873,0.01587),(0.1746,0.01587),(0.19048,0.01587),(0.20635,0.01587),(0.22222,0.01587),(0.2381,0.01587),(0.25397,0.01587),(0.26984,0.01587),(0.28571,0.01587),(0.30159,0.01587),(0.31746,0.01587),(0.33333,0.01587),(0.34921,0.01587),(0.36508,0.01587),(0.38095,0.01587),(0.39683,0.01587),(0.4127,0.01587),(0.42857,0.01587),(0.44444,0.01587),(0.46032,0.01587),(0.47619,0.01587),(0.49206,0.01587),(0.50794,0.01587),(0.52381,0.01587),(0.53968,0.01587),(0.55556,0.01587),(0.57143,0.01587),(0.5873,0.01587),(0.60317,0.01587),(0.61905,0.01587),(0.63492,0.01587),(0.65079,0.01587),(0.66667,0.01587),(0.68254,0.01587),(0.69841,0.01587),(0.71429,0.01587),(0.73016,0.01587),(0.74603,0.01587),(0.7619,0.01587),(0.77778,0.01587),(0.79365,0.01587),(0.80952,0.01587),(0.8254,0.01587),(0.84127,0.01587),(0.85714,0.01587),(0.87302,0.01587),(0.88889,0.01587),(0.90476,0.01587),(0.92063,0.01587),(0.93651,0.01587),(0.95238,0.01587),(0.96825,0.01587),(0.98413,0.01587),(0.99609,0.01587),(0.00391,0.03175),(0.01587,0.03175),(0.03175,0.03175),(0.04762,0.03175),(0.06349,0.03175),(0.07937,0.03175),(0.09524,0.03175),(0.11111,0.03175),(0.12698,0.03175),(0.14286,0.03175),(0.15873,0.03175),(0.1746,0.03175),(0.19048,0.03175),(0.20635,0.03175),(0.22222,0.03175),(0.2381,0.03175),(0.25397,0.03175),(0.26984,0.03175),(0.28571,0.03175),(0.30159,0.03175),(0.31746,0.03175),(0.33333,0.03175),(0.34921,0.03175),(0.36508,0.03175),(0.38095,0.03175),(0.39683,0.03175),(0.4127,0.03175),(0.42857,0.03175),(0.44444,0.03175),(0.46032,0.03175),(0.47619,0.03175),(0.49206,0.03175),(0.50794,0.03175),(0.52381,0.03175),(0.53968,0.03175),(0.55556,0.03175),(0.57143,0.03175),(0.5873,0.03175),(0.60317,0.03175),(0.61905,0.03175),(0.63492,0.03175),(0.65079,0.03175),(0.66667,0.03175),(0.68254,0.03175),(0.69841,0.03175),(0.71429,0.03175),(0.73016,0.03175),(0.74603,0.03175),(0.7619,0.03175),(0.77778,0.03175),(0.79365,0.03175),(0.80952,0.03175),(0.8254,0.03175),(0.84127,0.03175),(0.85714,0.03175),(0.87302,0.03175),(0.88889,0.03175),(0.90476,0.03175),(0.92063,0.03175),(0.93651,0.03175),(0.95238,0.03175),(0.96825,0.03175),(0.98413,0.03175),(0.99609,0.03175),(0.00391,0.04762),(0.01587,0.04762),(0.03175,0.04762),(0.04762,0.04762),(0.06349,0.04762),(0.07937,0.04762),(0.09524,0.04762),(0.11111,0.04762),(0.12698,0.04762),(0.14286,0.04762),(0.15873,0.04762),(0.1746,0.04762),(0.19048,0.04762),(0.20635,0.04762),(0.22222,0.04762),(0.2381,0.04762),(0.25397,0.04762),(0.26984,0.04762),(0.28571,0.04762),(0.30159,0.04762),(0.31746,0.04762),(0.33333,0.04762),(0.34921,0.04762),(0.36508,0.04762),(0.38095,0.04762),(0.39683,0.04762),(0.4127,0.04762),(0.42857,0.04762),(0.44444,0.04762),(0.46032,0.04762),(0.47619,0.04762),(0.49206,0.04762),(0.50794,0.04762),(0.52381,0.04762),(0.53968,0.04762),(0.55556,0.04762),(0.57143,0.04762),(0.5873,0.04762),(0.60317,0.04762),(0.61905,0.04762),(0.63492,0.04762),(0.65079,0.04762),(0.66667,0.04762),(0.68254,0.04762),(0.69841,0.04762),(0.71429,0.04762),(0.73016,0.04762),(0.74603,0.04762),(0.7619,0.04762),(0.77778,0.04762),(0.79365,0.04762),(0.80952,0.04762),(0.8254,0.04762),(0.84127,0.04762),(0.85714,0.04762),(0.87302,0.04762),(0.88889,0.04762),(0.90476,0.04762),(0.92063,0.04762),(0.93651,0.04762),(0.95238,0.04762),(0.96825,0.04762),(0.98413,0.04762),(0.99609,0.04762),(0.00391,0.06349),(0.01587,0.06349),(0.03175,0.06349),(0.04762,0.06349),(0.06349,0.06349),(0.07937,0.06349),(0.09524,0.06349),(0.11111,0.06349),(0.12698,0.06349),(0.14286,0.06349),(0.15873,0.06349),(0.1746,0.06349),(0.19048,0.06349),(0.20635,0.06349),(0.22222,0.06349),(0.2381,0.06349),(0.25397,0.06349),(0.26984,0.06349),(0.28571,0.06349),(0.30159,0.06349),(0.31746,0.06349),(0.33333,0.06349),(0.34921,0.06349),(0.36508,0.06349),(0.38095,0.06349),(0.39683,0.06349),(0.4127,0.06349),(0.42857,0.06349),(0.44444,0.06349),(0.46032,0.06349),(0.47619,0.06349),(0.49206,0.06349),(0.50794,0.06349),(0.52381,0.06349),(0.53968,0.06349),(0.55556,0.06349),(0.57143,0.06349),(0.5873,0.06349),(0.60317,0.06349),(0.61905,0.06349),(0.63492,0.06349),(0.65079,0.06349),(0.66667,0.06349),(0.68254,0.06349),(0.69841,0.06349),(0.71429,0.06349),(0.73016,0.06349),(0.74603,0.06349),(0.7619,0.06349),(0.77778,0.06349),(0.79365,0.06349),(0.80952,0.06349),(0.8254,0.06349),(0.84127,0.06349),(0.85714,0.06349),(0.87302,0.06349),(0.88889,0.06349),(0.90476,0.06349),(0.92063,0.06349),(0.93651,0.06349),(0.95238,0.06349),(0.96825,0.06349),(0.98413,0.06349),(0.99609,0.06349),(0.00391,0.07937),(0.01587,0.07937),(0.03175,0.07937),(0.04762,0.07937),(0.06349,0.07937),(0.07937,0.07937),(0.09524,0.07937),(0.11111,0.07937),(0.12698,0.07937),(0.14286,0.07937),(0.15873,0.07937),(0.1746,0.07937),(0.19048,0.07937),(0.20635,0.07937),(0.22222,0.07937),(0.2381,0.07937),(0.25397,0.07937),(0.26984,0.07937),(0.28571,0.07937),(0.30159,0.07937),(0.31746,0.07937),(0.33333,0.07937),(0.34921,0.07937),(0.36508,0.07937),(0.38095,0.07937),(0.39683,0.07937),(0.4127,0.07937),(0.42857,0.07937),(0.44444,0.07937),(0.46032,0.07937),(0.47619,0.07937),(0.49206,0.07937),(0.50794,0.07937),(0.52381,0.07937),(0.53968,0.07937),(0.55556,0.07937),(0.57143,0.07937),(0.5873,0.07937),(0.60317,0.07937),(0.61905,0.07937),(0.63492,0.07937),(0.65079,0.07937),(0.66667,0.07937),(0.68254,0.07937),(0.69841,0.07937),(0.71429,0.07937),(0.73016,0.07937),(0.74603,0.07937),(0.7619,0.07937),(0.77778,0.07937),(0.79365,0.07937),(0.80952,0.07937),(0.8254,0.07937),(0.84127,0.07937),(0.85714,0.07937),(0.87302,0.07937),(0.88889,0.07937),(0.90476,0.07937),(0.92063,0.07937),(0.93651,0.07937),(0.95238,0.07937),(0.96825,0.07937),(0.98413,0.07937),(0.99609,0.07937),(0.00391,0.09524),(0.01587,0.09524),(0.03175,0.09524),(0.04762,0.09524),(0.06349,0.09524),(0.07937,0.09524),(0.09524,0.09524),(0.11111,0.09524),(0.12698,0.09524),(0.14286,0.09524),(0.15873,0.09524),(0.1746,0.09524),(0.19048,0.09524),(0.20635,0.09524),(0.22222,0.09524),(0.2381,0.09524),(0.25397,0.09524),(0.26984,0.09524),(0.28571,0.09524),(0.30159,0.09524),(0.31746,0.09524),(0.33333,0.09524),(0.34921,0.09524),(0.36508,0.09524),(0.38095,0.09524),(0.39683,0.09524),(0.4127,0.09524),(0.42857,0.09524),(0.44444,0.09524),(0.46032,0.09524),(0.47619,0.09524),(0.49206,0.09524),(0.50794,0.09524),(0.52381,0.09524),(0.53968,0.09524),(0.55556,0.09524),(0.57143,0.09524),(0.5873,0.09524),(0.60317,0.09524),(0.61905,0.09524),(0.63492,0.09524),(0.65079,0.09524),(0.66667,0.09524),(0.68254,0.09524),(0.69841,0.09524),(0.71429,0.09524),(0.73016,0.09524),(0.74603,0.09524),(0.7619,0.09524),(0.77778,0.09524),(0.79365,0.09524),(0.80952,0.09524),(0.8254,0.09524),(0.84127,0.09524),(0.85714,0.09524),(0.87302,0.09524),(0.88889,0.09524),(0.90476,0.09524),(0.92063,0.09524),(0.93651,0.09524),(0.95238,0.09524),(0.96825,0.09524),(0.98413,0.09524),(0.99609,0.09524),(0.00391,0.11111),(0.01587,0.11111),(0.03175,0.11111),(0.04762,0.11111),(0.06349,0.11111),(0.07937,0.11111),(0.09524,0.11111),(0.11111,0.11111),(0.12698,0.11111),(0.14286,0.11111),(0.15873,0.11111),(0.1746,0.11111),(0.19048,0.11111),(0.20635,0.11111),(0.22222,0.11111),(0.2381,0.11111),(0.25397,0.11111),(0.26984,0.11111),(0.28571,0.11111),(0.30159,0.11111),(0.31746,0.11111),(0.33333,0.11111),(0.34921,0.11111),(0.36508,0.11111),(0.38095,0.11111),(0.39683,0.11111),(0.4127,0.11111),(0.42857,0.11111),(0.44444,0.11111),(0.46032,0.11111),(0.47619,0.11111),(0.49206,0.11111),(0.50794,0.11111),(0.52381,0.11111),(0.53968,0.11111),(0.55556,0.11111),(0.57143,0.11111),(0.5873,0.11111),(0.60317,0.11111),(0.61905,0.11111),(0.63492,0.11111),(0.65079,0.11111),(0.66667,0.11111),(0.68254,0.11111),(0.69841,0.11111),(0.71429,0.11111),(0.73016,0.11111),(0.74603,0.11111),(0.7619,0.11111),(0.77778,0.11111),(0.79365,0.11111),(0.80952,0.11111),(0.8254,0.11111),(0.84127,0.11111),(0.85714,0.11111),(0.87302,0.11111),(0.88889,0.11111),(0.90476,0.11111),(0.92063,0.11111),(0.93651,0.11111),(0.95238,0.11111),(0.96825,0.11111),(0.98413,0.11111),(0.99609,0.11111),(0.00391,0.12698),(0.01587,0.12698),(0.03175,0.12698),(0.04762,0.12698),(0.06349,0.12698),(0.07937,0.12698),(0.09524,0.12698),(0.11111,0.12698),(0.12698,0.12698),(0.14286,0.12698),(0.15873,0.12698),(0.1746,0.12698),(0.19048,0.12698),(0.20635,0.12698),(0.22222,0.12698),(0.2381,0.12698),(0.25397,0.12698),(0.26984,0.12698),(0.28571,0.12698),(0.30159,0.12698),(0.31746,0.12698),(0.33333,0.12698),(0.34921,0.12698),(0.36508,0.12698),(0.38095,0.12698),(0.39683,0.12698),(0.4127,0.12698),(0.42857,0.12698),(0.44444,0.12698),(0.46032,0.12698),(0.47619,0.12698),(0.49206,0.12698),(0.50794,0.12698),(0.52381,0.12698),(0.53968,0.12698),(0.55556,0.12698),(0.57143,0.12698),(0.5873,0.12698),(0.60317,0.12698),(0.61905,0.12698),(0.63492,0.12698),(0.65079,0.12698),(0.66667,0.12698),(0.68254,0.12698),(0.69841,0.12698),(0.71429,0.12698),(0.73016,0.12698),(0.74603,0.12698),(0.7619,0.12698),(0.77778,0.12698),(0.79365,0.12698),(0.80952,0.12698),(0.8254,0.12698),(0.84127,0.12698),(0.85714,0.12698),(0.87302,0.12698),(0.88889,0.12698),(0.90476,0.12698),(0.92063,0.12698),(0.93651,0.12698),(0.95238,0.12698),(0.96825,0.12698),(0.98413,0.12698),(0.99609,0.12698),(0.00391,0.14286),(0.01587,0.14286),(0.03175,0.14286),(0.04762,0.14286),(0.06349,0.14286),(0.07937,0.14286),(0.09524,0.14286),(0.11111,0.14286),(0.12698,0.14286),(0.14286,0.14286),(0.15873,0.14286),(0.1746,0.14286),(0.19048,0.14286),(0.20635,0.14286),(0.22222,0.14286),(0.2381,0.14286),(0.25397,0.14286),(0.26984,0.14286),(0.28571,0.14286),(0.30159,0.14286),(0.31746,0.14286),(0.33333,0.14286),(0.34921,0.14286),(0.36508,0.14286),(0.38095,0.14286),(0.39683,0.14286),(0.4127,0.14286),(0.42857,0.14286),(0.44444,0.14286),(0.46032,0.14286),(0.47619,0.14286),(0.49206,0.14286),(0.50794,0.14286),(0.52381,0.14286),(0.53968,0.14286),(0.55556,0.14286),(0.57143,0.14286),(0.5873,0.14286),(0.60317,0.14286),(0.61905,0.14286),(0.63492,0.14286),(0.65079,0.14286),(0.66667,0.14286),(0.68254,0.14286),(0.69841,0.14286),(0.71429,0.14286),(0.73016,0.14286),(0.74603,0.14286),(0.7619,0.14286),(0.77778,0.14286),(0.79365,0.14286),(0.80952,0.14286),(0.8254,0.14286),(0.84127,0.14286),(0.85714,0.14286),(0.87302,0.14286),(0.88889,0.14286),(0.90476,0.14286),(0.92063,0.14286),(0.93651,0.14286),(0.95238,0.14286),(0.96825,0.14286),(0.98413,0.14286),(0.99609,0.14286),(0.00391,0.15873),(0.01587,0.15873),(0.03175,0.15873),(0.04762,0.15873),(0.06349,0.15873),(0.07937,0.15873),(0.09524,0.15873),(0.11111,0.15873),(0.12698,0.15873),(0.14286,0.15873),(0.15873,0.15873),(0.1746,0.15873),(0.19048,0.15873),(0.20635,0.15873),(0.22222,0.15873),(0.2381,0.15873),(0.25397,0.15873),(0.26984,0.15873),(0.28571,0.15873),(0.30159,0.15873),(0.31746,0.15873),(0.33333,0.15873),(0.34921,0.15873),(0.36508,0.15873),(0.38095,0.15873),(0.39683,0.15873),(0.4127,0.15873),(0.42857,0.15873),(0.44444,0.15873),(0.46032,0.15873),(0.47619,0.15873),(0.49206,0.15873),(0.50794,0.15873),(0.52381,0.15873),(0.53968,0.15873),(0.55556,0.15873),(0.57143,0.15873),(0.5873,0.15873),(0.60317,0.15873),(0.61905,0.15873),(0.63492,0.15873),(0.65079,0.15873),(0.66667,0.15873),(0.68254,0.15873),(0.69841,0.15873),(0.71429,0.15873),(0.73016,0.15873),(0.74603,0.15873),(0.7619,0.15873),(0.77778,0.15873),(0.79365,0.15873),(0.80952,0.15873),(0.8254,0.15873),(0.84127,0.15873),(0.85714,0.15873),(0.87302,0.15873),(0.88889,0.15873),(0.90476,0.15873),(0.92063,0.15873),(0.93651,0.15873),(0.95238,0.15873),(0.96825,0.15873),(0.98413,0.15873),(0.99609,0.15873),(0.00391,0.1746),(0.01587,0.1746),(0.03175,0.1746),(0.04762,0.1746),(0.06349,0.1746),(0.07937,0.1746),(0.09524,0.1746),(0.11111,0.1746),(0.12698,0.1746),(0.14286,0.1746),(0.15873,0.1746),(0.1746,0.1746),(0.19048,0.1746),(0.20635,0.1746),(0.22222,0.1746),(0.2381,0.1746),(0.25397,0.1746),(0.26984,0.1746),(0.28571,0.1746),(0.30159,0.1746),(0.31746,0.1746),(0.33333,0.1746),(0.34921,0.1746),(0.36508,0.1746),(0.38095,0.1746),(0.39683,0.1746),(0.4127,0.1746),(0.42857,0.1746),(0.44444,0.1746),(0.46032,0.1746),(0.47619,0.1746),(0.49206,0.1746),(0.50794,0.1746),(0.52381,0.1746),(0.53968,0.1746),(0.55556,0.1746),(0.57143,0.1746),(0.5873,0.1746),(0.60317,0.1746),(0.61905,0.1746),(0.63492,0.1746),(0.65079,0.1746),(0.66667,0.1746),(0.68254,0.1746),(0.69841,0.1746),(0.71429,0.1746),(0.73016,0.1746),(0.74603,0.1746),(0.7619,0.1746),(0.77778,0.1746),(0.79365,0.1746),(0.80952,0.1746),(0.8254,0.1746),(0.84127,0.1746),(0.85714,0.1746),(0.87302,0.1746),(0.88889,0.1746),(0.90476,0.1746),(0.92063,0.1746),(0.93651,0.1746),(0.95238,0.1746),(0.96825,0.1746),(0.98413,0.1746),(0.99609,0.1746),(0.00391,0.19048),(0.01587,0.19048),(0.03175,0.19048),(0.04762,0.19048),(0.06349,0.19048),(0.07937,0.19048),(0.09524,0.19048),(0.11111,0.19048),(0.12698,0.19048),(0.14286,0.19048),(0.15873,0.19048),(0.1746,0.19048),(0.19048,0.19048),(0.20635,0.19048),(0.22222,0.19048),(0.2381,0.19048),(0.25397,0.19048),(0.26984,0.19048),(0.28571,0.19048),(0.30159,0.19048),(0.31746,0.19048),(0.33333,0.19048),(0.34921,0.19048),(0.36508,0.19048),(0.38095,0.19048),(0.39683,0.19048),(0.4127,0.19048),(0.42857,0.19048),(0.44444,0.19048),(0.46032,0.19048),(0.47619,0.19048),(0.49206,0.19048),(0.50794,0.19048),(0.52381,0.19048),(0.53968,0.19048),(0.55556,0.19048),(0.57143,0.19048),(0.5873,0.19048),(0.60317,0.19048),(0.61905,0.19048),(0.63492,0.19048),(0.65079,0.19048),(0.66667,0.19048),(0.68254,0.19048),(0.69841,0.19048),(0.71429,0.19048),(0.73016,0.19048),(0.74603,0.19048),(0.7619,0.19048),(0.77778,0.19048),(0.79365,0.19048),(0.80952,0.19048),(0.8254,0.19048),(0.84127,0.19048),(0.85714,0.19048),(0.87302,0.19048),(0.88889,0.19048),(0.90476,0.19048),(0.92063,0.19048),(0.93651,0.19048),(0.95238,0.19048),(0.96825,0.19048),(0.98413,0.19048),(0.99609,0.19048),(0.00391,0.20635),(0.01587,0.20635),(0.03175,0.20635),(0.04762,0.20635),(0.06349,0.20635),(0.07937,0.20635),(0.09524,0.20635),(0.11111,0.20635),(0.12698,0.20635),(0.14286,0.20635),(0.15873,0.20635),(0.1746,0.20635),(0.19048,0.20635),(0.20635,0.20635),(0.22222,0.20635),(0.2381,0.20635),(0.25397,0.20635),(0.26984,0.20635),(0.28571,0.20635),(0.30159,0.20635),(0.31746,0.20635),(0.33333,0.20635),(0.34921,0.20635),(0.36508,0.20635),(0.38095,0.20635),(0.39683,0.20635),(0.4127,0.20635),(0.42857,0.20635),(0.44444,0.20635),(0.46032,0.20635),(0.47619,0.20635),(0.49206,0.20635),(0.50794,0.20635),(0.52381,0.20635),(0.53968,0.20635),(0.55556,0.20635),(0.57143,0.20635),(0.5873,0.20635),(0.60317,0.20635),(0.61905,0.20635),(0.63492,0.20635),(0.65079,0.20635),(0.66667,0.20635),(0.68254,0.20635),(0.69841,0.20635),(0.71429,0.20635),(0.73016,0.20635),(0.74603,0.20635),(0.7619,0.20635),(0.77778,0.20635),(0.79365,0.20635),(0.80952,0.20635),(0.8254,0.20635),(0.84127,0.20635),(0.85714,0.20635),(0.87302,0.20635),(0.88889,0.20635),(0.90476,0.20635),(0.92063,0.20635),(0.93651,0.20635),(0.95238,0.20635),(0.96825,0.20635),(0.98413,0.20635),(0.99609,0.20635),(0.00391,0.22222),(0.01587,0.22222),(0.03175,0.22222),(0.04762,0.22222),(0.06349,0.22222),(0.07937,0.22222),(0.09524,0.22222),(0.11111,0.22222),(0.12698,0.22222),(0.14286,0.22222),(0.15873,0.22222),(0.1746,0.22222),(0.19048,0.22222),(0.20635,0.22222),(0.22222,0.22222),(0.2381,0.22222),(0.25397,0.22222),(0.26984,0.22222),(0.28571,0.22222),(0.30159,0.22222),(0.31746,0.22222),(0.33333,0.22222),(0.34921,0.22222),(0.36508,0.22222),(0.38095,0.22222),(0.39683,0.22222),(0.4127,0.22222),(0.42857,0.22222),(0.44444,0.22222),(0.46032,0.22222),(0.47619,0.22222),(0.49206,0.22222),(0.50794,0.22222),(0.52381,0.22222),(0.53968,0.22222),(0.55556,0.22222),(0.57143,0.22222),(0.5873,0.22222),(0.60317,0.22222),(0.61905,0.22222),(0.63492,0.22222),(0.65079,0.22222),(0.66667,0.22222),(0.68254,0.22222),(0.69841,0.22222),(0.71429,0.22222),(0.73016,0.22222),(0.74603,0.22222),(0.7619,0.22222),(0.77778,0.22222),(0.79365,0.22222),(0.80952,0.22222),(0.8254,0.22222),(0.84127,0.22222),(0.85714,0.22222),(0.87302,0.22222),(0.88889,0.22222),(0.90476,0.22222),(0.92063,0.22222),(0.93651,0.22222),(0.95238,0.22222),(0.96825,0.22222),(0.98413,0.22222),(0.99609,0.22222),(0.00391,0.2381),(0.01587,0.2381),(0.03175,0.2381),(0.04762,0.2381),(0.06349,0.2381),(0.07937,0.2381),(0.09524,0.2381),(0.11111,0.2381),(0.12698,0.2381),(0.14286,0.2381),(0.15873,0.2381),(0.1746,0.2381),(0.19048,0.2381),(0.20635,0.2381),(0.22222,0.2381),(0.2381,0.2381),(0.25397,0.2381),(0.26984,0.2381),(0.28571,0.2381),(0.30159,0.2381),(0.31746,0.2381),(0.33333,0.2381),(0.34921,0.2381),(0.36508,0.2381),(0.38095,0.2381),(0.39683,0.2381),(0.4127,0.2381),(0.42857,0.2381),(0.44444,0.2381),(0.46032,0.2381),(0.47619,0.2381),(0.49206,0.2381),(0.50794,0.2381),(0.52381,0.2381),(0.53968,0.2381),(0.55556,0.2381),(0.57143,0.2381),(0.5873,0.2381),(0.60317,0.2381),(0.61905,0.2381),(0.63492,0.2381),(0.65079,0.2381),(0.66667,0.2381),(0.68254,0.2381),(0.69841,0.2381),(0.71429,0.2381),(0.73016,0.2381),(0.74603,0.2381),(0.7619,0.2381),(0.77778,0.2381),(0.79365,0.2381),(0.80952,0.2381),(0.8254,0.2381),(0.84127,0.2381),(0.85714,0.2381),(0.87302,0.2381),(0.88889,0.2381),(0.90476,0.2381),(0.92063,0.2381),(0.93651,0.2381),(0.95238,0.2381),(0.96825,0.2381),(0.98413,0.2381),(0.99609,0.2381),(0.00391,0.25397),(0.01587,0.25397),(0.03175,0.25397),(0.04762,0.25397),(0.06349,0.25397),(0.07937,0.25397),(0.09524,0.25397),(0.11111,0.25397),(0.12698,0.25397),(0.14286,0.25397),(0.15873,0.25397),(0.1746,0.25397),(0.19048,0.25397),(0.20635,0.25397),(0.22222,0.25397),(0.2381,0.25397),(0.25397,0.25397),(0.26984,0.25397),(0.28571,0.25397),(0.30159,0.25397),(0.31746,0.25397),(0.33333,0.25397),(0.34921,0.25397),(0.36508,0.25397),(0.38095,0.25397),(0.39683,0.25397),(0.4127,0.25397),(0.42857,0.25397),(0.44444,0.25397),(0.46032,0.25397),(0.47619,0.25397),(0.49206,0.25397),(0.50794,0.25397),(0.52381,0.25397),(0.53968,0.25397),(0.55556,0.25397),(0.57143,0.25397),(0.5873,0.25397),(0.60317,0.25397),(0.61905,0.25397),(0.63492,0.25397),(0.65079,0.25397),(0.66667,0.25397),(0.68254,0.25397),(0.69841,0.25397),(0.71429,0.25397),(0.73016,0.25397),(0.74603,0.25397),(0.7619,0.25397),(0.77778,0.25397),(0.79365,0.25397),(0.80952,0.25397),(0.8254,0.25397),(0.84127,0.25397),(0.85714,0.25397),(0.87302,0.25397),(0.88889,0.25397),(0.90476,0.25397),(0.92063,0.25397),(0.93651,0.25397),(0.95238,0.25397),(0.96825,0.25397),(0.98413,0.25397),(0.99609,0.25397),(0.00391,0.26984),(0.01587,0.26984),(0.03175,0.26984),(0.04762,0.26984),(0.06349,0.26984),(0.07937,0.26984),(0.09524,0.26984),(0.11111,0.26984),(0.12698,0.26984),(0.14286,0.26984),(0.15873,0.26984),(0.1746,0.26984),(0.19048,0.26984),(0.20635,0.26984),(0.22222,0.26984),(0.2381,0.26984),(0.25397,0.26984),(0.26984,0.26984),(0.28571,0.26984),(0.30159,0.26984),(0.31746,0.26984),(0.33333,0.26984),(0.34921,0.26984),(0.36508,0.26984),(0.38095,0.26984),(0.39683,0.26984),(0.4127,0.26984),(0.42857,0.26984),(0.44444,0.26984),(0.46032,0.26984),(0.47619,0.26984),(0.49206,0.26984),(0.50794,0.26984),(0.52381,0.26984),(0.53968,0.26984),(0.55556,0.26984),(0.57143,0.26984),(0.5873,0.26984),(0.60317,0.26984),(0.61905,0.26984),(0.63492,0.26984),(0.65079,0.26984),(0.66667,0.26984),(0.68254,0.26984),(0.69841,0.26984),(0.71429,0.26984),(0.73016,0.26984),(0.74603,0.26984),(0.7619,0.26984),(0.77778,0.26984),(0.79365,0.26984),(0.80952,0.26984),(0.8254,0.26984),(0.84127,0.26984),(0.85714,0.26984),(0.87302,0.26984),(0.88889,0.26984),(0.90476,0.26984),(0.92063,0.26984),(0.93651,0.26984),(0.95238,0.26984),(0.96825,0.26984),(0.98413,0.26984),(0.99609,0.26984),(0.00391,0.28571),(0.01587,0.28571),(0.03175,0.28571),(0.04762,0.28571),(0.06349,0.28571),(0.07937,0.28571),(0.09524,0.28571),(0.11111,0.28571),(0.12698,0.28571),(0.14286,0.28571),(0.15873,0.28571),(0.1746,0.28571),(0.19048,0.28571),(0.20635,0.28571),(0.22222,0.28571),(0.2381,0.28571),(0.25397,0.28571),(0.26984,0.28571),(0.28571,0.28571),(0.30159,0.28571),(0.31746,0.28571),(0.33333,0.28571),(0.34921,0.28571),(0.36508,0.28571),(0.38095,0.28571),(0.39683,0.28571),(0.4127,0.28571),(0.42857,0.28571),(0.44444,0.28571),(0.46032,0.28571),(0.47619,0.28571),(0.49206,0.28571),(0.50794,0.28571),(0.52381,0.28571),(0.53968,0.28571),(0.55556,0.28571),(0.57143,0.28571),(0.5873,0.28571),(0.60317,0.28571),(0.61905,0.28571),(0.63492,0.28571),(0.65079,0.28571),(0.66667,0.28571),(0.68254,0.28571),(0.69841,0.28571),(0.71429,0.28571),(0.73016,0.28571),(0.74603,0.28571),(0.7619,0.28571),(0.77778,0.28571),(0.79365,0.28571),(0.80952,0.28571),(0.8254,0.28571),(0.84127,0.28571),(0.85714,0.28571),(0.87302,0.28571),(0.88889,0.28571),(0.90476,0.28571),(0.92063,0.28571),(0.93651,0.28571),(0.95238,0.28571),(0.96825,0.28571),(0.98413,0.28571),(0.99609,0.28571),(0.00391,0.30159),(0.01587,0.30159),(0.03175,0.30159),(0.04762,0.30159),(0.06349,0.30159),(0.07937,0.30159),(0.09524,0.30159),(0.11111,0.30159),(0.12698,0.30159),(0.14286,0.30159),(0.15873,0.30159),(0.1746,0.30159),(0.19048,0.30159),(0.20635,0.30159),(0.22222,0.30159),(0.2381,0.30159),(0.25397,0.30159),(0.26984,0.30159),(0.28571,0.30159),(0.30159,0.30159),(0.31746,0.30159),(0.33333,0.30159),(0.34921,0.30159),(0.36508,0.30159),(0.38095,0.30159),(0.39683,0.30159),(0.4127,0.30159),(0.42857,0.30159),(0.44444,0.30159),(0.46032,0.30159),(0.47619,0.30159),(0.49206,0.30159),(0.50794,0.30159),(0.52381,0.30159),(0.53968,0.30159),(0.55556,0.30159),(0.57143,0.30159),(0.5873,0.30159),(0.60317,0.30159),(0.61905,0.30159),(0.63492,0.30159),(0.65079,0.30159),(0.66667,0.30159),(0.68254,0.30159),(0.69841,0.30159),(0.71429,0.30159),(0.73016,0.30159),(0.74603,0.30159),(0.7619,0.30159),(0.77778,0.30159),(0.79365,0.30159),(0.80952,0.30159),(0.8254,0.30159),(0.84127,0.30159),(0.85714,0.30159),(0.87302,0.30159),(0.88889,0.30159),(0.90476,0.30159),(0.92063,0.30159),(0.93651,0.30159),(0.95238,0.30159),(0.96825,0.30159),(0.98413,0.30159),(0.99609,0.30159),(0.00391,0.31746),(0.01587,0.31746),(0.03175,0.31746),(0.04762,0.31746),(0.06349,0.31746),(0.07937,0.31746),(0.09524,0.31746),(0.11111,0.31746),(0.12698,0.31746),(0.14286,0.31746),(0.15873,0.31746),(0.1746,0.31746),(0.19048,0.31746),(0.20635,0.31746),(0.22222,0.31746),(0.2381,0.31746),(0.25397,0.31746),(0.26984,0.31746),(0.28571,0.31746),(0.30159,0.31746),(0.31746,0.31746),(0.33333,0.31746),(0.34921,0.31746),(0.36508,0.31746),(0.38095,0.31746),(0.39683,0.31746),(0.4127,0.31746),(0.42857,0.31746),(0.44444,0.31746),(0.46032,0.31746),(0.47619,0.31746),(0.49206,0.31746),(0.50794,0.31746),(0.52381,0.31746),(0.53968,0.31746),(0.55556,0.31746),(0.57143,0.31746),(0.5873,0.31746),(0.60317,0.31746),(0.61905,0.31746),(0.63492,0.31746),(0.65079,0.31746),(0.66667,0.31746),(0.68254,0.31746),(0.69841,0.31746),(0.71429,0.31746),(0.73016,0.31746),(0.74603,0.31746),(0.7619,0.31746),(0.77778,0.31746),(0.79365,0.31746),(0.80952,0.31746),(0.8254,0.31746),(0.84127,0.31746),(0.85714,0.31746),(0.87302,0.31746),(0.88889,0.31746),(0.90476,0.31746),(0.92063,0.31746),(0.93651,0.31746),(0.95238,0.31746),(0.96825,0.31746),(0.98413,0.31746),(0.99609,0.31746),(0.00391,0.33333),(0.01587,0.33333),(0.03175,0.33333),(0.04762,0.33333),(0.06349,0.33333),(0.07937,0.33333),(0.09524,0.33333),(0.11111,0.33333),(0.12698,0.33333),(0.14286,0.33333),(0.15873,0.33333),(0.1746,0.33333),(0.19048,0.33333),(0.20635,0.33333),(0.22222,0.33333),(0.2381,0.33333),(0.25397,0.33333),(0.26984,0.33333),(0.28571,0.33333),(0.30159,0.33333),(0.31746,0.33333),(0.33333,0.33333),(0.34921,0.33333),(0.36508,0.33333),(0.38095,0.33333),(0.39683,0.33333),(0.4127,0.33333),(0.42857,0.33333),(0.44444,0.33333),(0.46032,0.33333),(0.47619,0.33333),(0.49206,0.33333),(0.50794,0.33333),(0.52381,0.33333),(0.53968,0.33333),(0.55556,0.33333),(0.57143,0.33333),(0.5873,0.33333),(0.60317,0.33333),(0.61905,0.33333),(0.63492,0.33333),(0.65079,0.33333),(0.66667,0.33333),(0.68254,0.33333),(0.69841,0.33333),(0.71429,0.33333),(0.73016,0.33333),(0.74603,0.33333),(0.7619,0.33333),(0.77778,0.33333),(0.79365,0.33333),(0.80952,0.33333),(0.8254,0.33333),(0.84127,0.33333),(0.85714,0.33333),(0.87302,0.33333),(0.88889,0.33333),(0.90476,0.33333),(0.92063,0.33333),(0.93651,0.33333),(0.95238,0.33333),(0.96825,0.33333),(0.98413,0.33333),(0.99609,0.33333),(0.00391,0.34921),(0.01587,0.34921),(0.03175,0.34921),(0.04762,0.34921),(0.06349,0.34921),(0.07937,0.34921),(0.09524,0.34921),(0.11111,0.34921),(0.12698,0.34921),(0.14286,0.34921),(0.15873,0.34921),(0.1746,0.34921),(0.19048,0.34921),(0.20635,0.34921),(0.22222,0.34921),(0.2381,0.34921),(0.25397,0.34921),(0.26984,0.34921),(0.28571,0.34921),(0.30159,0.34921),(0.31746,0.34921),(0.33333,0.34921),(0.34921,0.34921),(0.36508,0.34921),(0.38095,0.34921),(0.39683,0.34921),(0.4127,0.34921),(0.42857,0.34921),(0.44444,0.34921),(0.46032,0.34921),(0.47619,0.34921),(0.49206,0.34921),(0.50794,0.34921),(0.52381,0.34921),(0.53968,0.34921),(0.55556,0.34921),(0.57143,0.34921),(0.5873,0.34921),(0.60317,0.34921),(0.61905,0.34921),(0.63492,0.34921),(0.65079,0.34921),(0.66667,0.34921),(0.68254,0.34921),(0.69841,0.34921),(0.71429,0.34921),(0.73016,0.34921),(0.74603,0.34921),(0.7619,0.34921),(0.77778,0.34921),(0.79365,0.34921),(0.80952,0.34921),(0.8254,0.34921),(0.84127,0.34921),(0.85714,0.34921),(0.87302,0.34921),(0.88889,0.34921),(0.90476,0.34921),(0.92063,0.34921),(0.93651,0.34921),(0.95238,0.34921),(0.96825,0.34921),(0.98413,0.34921),(0.99609,0.34921),(0.00391,0.36508),(0.01587,0.36508),(0.03175,0.36508),(0.04762,0.36508),(0.06349,0.36508),(0.07937,0.36508),(0.09524,0.36508),(0.11111,0.36508),(0.12698,0.36508),(0.14286,0.36508),(0.15873,0.36508),(0.1746,0.36508),(0.19048,0.36508),(0.20635,0.36508),(0.22222,0.36508),(0.2381,0.36508),(0.25397,0.36508),(0.26984,0.36508),(0.28571,0.36508),(0.30159,0.36508),(0.31746,0.36508),(0.33333,0.36508),(0.34921,0.36508),(0.36508,0.36508),(0.38095,0.36508),(0.39683,0.36508),(0.4127,0.36508),(0.42857,0.36508),(0.44444,0.36508),(0.46032,0.36508),(0.47619,0.36508),(0.49206,0.36508),(0.50794,0.36508),(0.52381,0.36508),(0.53968,0.36508),(0.55556,0.36508),(0.57143,0.36508),(0.5873,0.36508),(0.60317,0.36508),(0.61905,0.36508),(0.63492,0.36508),(0.65079,0.36508),(0.66667,0.36508),(0.68254,0.36508),(0.69841,0.36508),(0.71429,0.36508),(0.73016,0.36508),(0.74603,0.36508),(0.7619,0.36508),(0.77778,0.36508),(0.79365,0.36508),(0.80952,0.36508),(0.8254,0.36508),(0.84127,0.36508),(0.85714,0.36508),(0.87302,0.36508),(0.88889,0.36508),(0.90476,0.36508),(0.92063,0.36508),(0.93651,0.36508),(0.95238,0.36508),(0.96825,0.36508),(0.98413,0.36508),(0.99609,0.36508),(0.00391,0.38095),(0.01587,0.38095),(0.03175,0.38095),(0.04762,0.38095),(0.06349,0.38095),(0.07937,0.38095),(0.09524,0.38095),(0.11111,0.38095),(0.12698,0.38095),(0.14286,0.38095),(0.15873,0.38095),(0.1746,0.38095),(0.19048,0.38095),(0.20635,0.38095),(0.22222,0.38095),(0.2381,0.38095),(0.25397,0.38095),(0.26984,0.38095),(0.28571,0.38095),(0.30159,0.38095),(0.31746,0.38095),(0.33333,0.38095),(0.34921,0.38095),(0.36508,0.38095),(0.38095,0.38095),(0.39683,0.38095),(0.4127,0.38095),(0.42857,0.38095),(0.44444,0.38095),(0.46032,0.38095),(0.47619,0.38095),(0.49206,0.38095),(0.50794,0.38095),(0.52381,0.38095),(0.53968,0.38095),(0.55556,0.38095),(0.57143,0.38095),(0.5873,0.38095),(0.60317,0.38095),(0.61905,0.38095),(0.63492,0.38095),(0.65079,0.38095),(0.66667,0.38095),(0.68254,0.38095),(0.69841,0.38095),(0.71429,0.38095),(0.73016,0.38095),(0.74603,0.38095),(0.7619,0.38095),(0.77778,0.38095),(0.79365,0.38095),(0.80952,0.38095),(0.8254,0.38095),(0.84127,0.38095),(0.85714,0.38095),(0.87302,0.38095),(0.88889,0.38095),(0.90476,0.38095),(0.92063,0.38095),(0.93651,0.38095),(0.95238,0.38095),(0.96825,0.38095),(0.98413,0.38095),(0.99609,0.38095),(0.00391,0.39683),(0.01587,0.39683),(0.03175,0.39683),(0.04762,0.39683),(0.06349,0.39683),(0.07937,0.39683),(0.09524,0.39683),(0.11111,0.39683),(0.12698,0.39683),(0.14286,0.39683),(0.15873,0.39683),(0.1746,0.39683),(0.19048,0.39683),(0.20635,0.39683),(0.22222,0.39683),(0.2381,0.39683),(0.25397,0.39683),(0.26984,0.39683),(0.28571,0.39683),(0.30159,0.39683),(0.31746,0.39683),(0.33333,0.39683),(0.34921,0.39683),(0.36508,0.39683),(0.38095,0.39683),(0.39683,0.39683),(0.4127,0.39683),(0.42857,0.39683),(0.44444,0.39683),(0.46032,0.39683),(0.47619,0.39683),(0.49206,0.39683),(0.50794,0.39683),(0.52381,0.39683),(0.53968,0.39683),(0.55556,0.39683),(0.57143,0.39683),(0.5873,0.39683),(0.60317,0.39683),(0.61905,0.39683),(0.63492,0.39683),(0.65079,0.39683),(0.66667,0.39683),(0.68254,0.39683),(0.69841,0.39683),(0.71429,0.39683),(0.73016,0.39683),(0.74603,0.39683),(0.7619,0.39683),(0.77778,0.39683),(0.79365,0.39683),(0.80952,0.39683),(0.8254,0.39683),(0.84127,0.39683),(0.85714,0.39683),(0.87302,0.39683),(0.88889,0.39683),(0.90476,0.39683),(0.92063,0.39683),(0.93651,0.39683),(0.95238,0.39683),(0.96825,0.39683),(0.98413,0.39683),(0.99609,0.39683),(0.00391,0.4127),(0.01587,0.4127),(0.03175,0.4127),(0.04762,0.4127),(0.06349,0.4127),(0.07937,0.4127),(0.09524,0.4127),(0.11111,0.4127),(0.12698,0.4127),(0.14286,0.4127),(0.15873,0.4127),(0.1746,0.4127),(0.19048,0.4127),(0.20635,0.4127),(0.22222,0.4127),(0.2381,0.4127),(0.25397,0.4127),(0.26984,0.4127),(0.28571,0.4127),(0.30159,0.4127),(0.31746,0.4127),(0.33333,0.4127),(0.34921,0.4127),(0.36508,0.4127),(0.38095,0.4127),(0.39683,0.4127),(0.4127,0.4127),(0.42857,0.4127),(0.44444,0.4127),(0.46032,0.4127),(0.47619,0.4127),(0.49206,0.4127),(0.50794,0.4127),(0.52381,0.4127),(0.53968,0.4127),(0.55556,0.4127),(0.57143,0.4127),(0.5873,0.4127),(0.60317,0.4127),(0.61905,0.4127),(0.63492,0.4127),(0.65079,0.4127),(0.66667,0.4127),(0.68254,0.4127),(0.69841,0.4127),(0.71429,0.4127),(0.73016,0.4127),(0.74603,0.4127),(0.7619,0.4127),(0.77778,0.4127),(0.79365,0.4127),(0.80952,0.4127),(0.8254,0.4127),(0.84127,0.4127),(0.85714,0.4127),(0.87302,0.4127),(0.88889,0.4127),(0.90476,0.4127),(0.92063,0.4127),(0.93651,0.4127),(0.95238,0.4127),(0.96825,0.4127),(0.98413,0.4127),(0.99609,0.4127),(0.00391,0.42857),(0.01587,0.42857),(0.03175,0.42857),(0.04762,0.42857),(0.06349,0.42857),(0.07937,0.42857),(0.09524,0.42857),(0.11111,0.42857),(0.12698,0.42857),(0.14286,0.42857),(0.15873,0.42857),(0.1746,0.42857),(0.19048,0.42857),(0.20635,0.42857),(0.22222,0.42857),(0.2381,0.42857),(0.25397,0.42857),(0.26984,0.42857),(0.28571,0.42857),(0.30159,0.42857),(0.31746,0.42857),(0.33333,0.42857),(0.34921,0.42857),(0.36508,0.42857),(0.38095,0.42857),(0.39683,0.42857),(0.4127,0.42857),(0.42857,0.42857),(0.44444,0.42857),(0.46032,0.42857),(0.47619,0.42857),(0.49206,0.42857),(0.50794,0.42857),(0.52381,0.42857),(0.53968,0.42857),(0.55556,0.42857),(0.57143,0.42857),(0.5873,0.42857),(0.60317,0.42857),(0.61905,0.42857),(0.63492,0.42857),(0.65079,0.42857),(0.66667,0.42857),(0.68254,0.42857),(0.69841,0.42857),(0.71429,0.42857),(0.73016,0.42857),(0.74603,0.42857),(0.7619,0.42857),(0.77778,0.42857),(0.79365,0.42857),(0.80952,0.42857),(0.8254,0.42857),(0.84127,0.42857),(0.85714,0.42857),(0.87302,0.42857),(0.88889,0.42857),(0.90476,0.42857),(0.92063,0.42857),(0.93651,0.42857),(0.95238,0.42857),(0.96825,0.42857),(0.98413,0.42857),(0.99609,0.42857),(0.00391,0.44444),(0.01587,0.44444),(0.03175,0.44444),(0.04762,0.44444),(0.06349,0.44444),(0.07937,0.44444),(0.09524,0.44444),(0.11111,0.44444),(0.12698,0.44444),(0.14286,0.44444),(0.15873,0.44444),(0.1746,0.44444),(0.19048,0.44444),(0.20635,0.44444),(0.22222,0.44444),(0.2381,0.44444),(0.25397,0.44444),(0.26984,0.44444),(0.28571,0.44444),(0.30159,0.44444),(0.31746,0.44444),(0.33333,0.44444),(0.34921,0.44444),(0.36508,0.44444),(0.38095,0.44444),(0.39683,0.44444),(0.4127,0.44444),(0.42857,0.44444),(0.44444,0.44444),(0.46032,0.44444),(0.47619,0.44444),(0.49206,0.44444),(0.50794,0.44444),(0.52381,0.44444),(0.53968,0.44444),(0.55556,0.44444),(0.57143,0.44444),(0.5873,0.44444),(0.60317,0.44444),(0.61905,0.44444),(0.63492,0.44444),(0.65079,0.44444),(0.66667,0.44444),(0.68254,0.44444),(0.69841,0.44444),(0.71429,0.44444),(0.73016,0.44444),(0.74603,0.44444),(0.7619,0.44444),(0.77778,0.44444),(0.79365,0.44444),(0.80952,0.44444),(0.8254,0.44444),(0.84127,0.44444),(0.85714,0.44444),(0.87302,0.44444),(0.88889,0.44444),(0.90476,0.44444),(0.92063,0.44444),(0.93651,0.44444),(0.95238,0.44444),(0.96825,0.44444),(0.98413,0.44444),(0.99609,0.44444),(0.00391,0.46032),(0.01587,0.46032),(0.03175,0.46032),(0.04762,0.46032),(0.06349,0.46032),(0.07937,0.46032),(0.09524,0.46032),(0.11111,0.46032),(0.12698,0.46032),(0.14286,0.46032),(0.15873,0.46032),(0.1746,0.46032),(0.19048,0.46032),(0.20635,0.46032),(0.22222,0.46032),(0.2381,0.46032),(0.25397,0.46032),(0.26984,0.46032),(0.28571,0.46032),(0.30159,0.46032),(0.31746,0.46032),(0.33333,0.46032),(0.34921,0.46032),(0.36508,0.46032),(0.38095,0.46032),(0.39683,0.46032),(0.4127,0.46032),(0.42857,0.46032),(0.44444,0.46032),(0.46032,0.46032),(0.47619,0.46032),(0.49206,0.46032),(0.50794,0.46032),(0.52381,0.46032),(0.53968,0.46032),(0.55556,0.46032),(0.57143,0.46032),(0.5873,0.46032),(0.60317,0.46032),(0.61905,0.46032),(0.63492,0.46032),(0.65079,0.46032),(0.66667,0.46032),(0.68254,0.46032),(0.69841,0.46032),(0.71429,0.46032),(0.73016,0.46032),(0.74603,0.46032),(0.7619,0.46032),(0.77778,0.46032),(0.79365,0.46032),(0.80952,0.46032),(0.8254,0.46032),(0.84127,0.46032),(0.85714,0.46032),(0.87302,0.46032),(0.88889,0.46032),(0.90476,0.46032),(0.92063,0.46032),(0.93651,0.46032),(0.95238,0.46032),(0.96825,0.46032),(0.98413,0.46032),(0.99609,0.46032),(0.00391,0.47619),(0.01587,0.47619),(0.03175,0.47619),(0.04762,0.47619),(0.06349,0.47619),(0.07937,0.47619),(0.09524,0.47619),(0.11111,0.47619),(0.12698,0.47619),(0.14286,0.47619),(0.15873,0.47619),(0.1746,0.47619),(0.19048,0.47619),(0.20635,0.47619),(0.22222,0.47619),(0.2381,0.47619),(0.25397,0.47619),(0.26984,0.47619),(0.28571,0.47619),(0.30159,0.47619),(0.31746,0.47619),(0.33333,0.47619),(0.34921,0.47619),(0.36508,0.47619),(0.38095,0.47619),(0.39683,0.47619),(0.4127,0.47619),(0.42857,0.47619),(0.44444,0.47619),(0.46032,0.47619),(0.47619,0.47619),(0.49206,0.47619),(0.50794,0.47619),(0.52381,0.47619),(0.53968,0.47619),(0.55556,0.47619),(0.57143,0.47619),(0.5873,0.47619),(0.60317,0.47619),(0.61905,0.47619),(0.63492,0.47619),(0.65079,0.47619),(0.66667,0.47619),(0.68254,0.47619),(0.69841,0.47619),(0.71429,0.47619),(0.73016,0.47619),(0.74603,0.47619),(0.7619,0.47619),(0.77778,0.47619),(0.79365,0.47619),(0.80952,0.47619),(0.8254,0.47619),(0.84127,0.47619),(0.85714,0.47619),(0.87302,0.47619),(0.88889,0.47619),(0.90476,0.47619),(0.92063,0.47619),(0.93651,0.47619),(0.95238,0.47619),(0.96825,0.47619),(0.98413,0.47619),(0.99609,0.47619),(0.00391,0.49206),(0.01587,0.49206),(0.03175,0.49206),(0.04762,0.49206),(0.06349,0.49206),(0.07937,0.49206),(0.09524,0.49206),(0.11111,0.49206),(0.12698,0.49206),(0.14286,0.49206),(0.15873,0.49206),(0.1746,0.49206),(0.19048,0.49206),(0.20635,0.49206),(0.22222,0.49206),(0.2381,0.49206),(0.25397,0.49206),(0.26984,0.49206),(0.28571,0.49206),(0.30159,0.49206),(0.31746,0.49206),(0.33333,0.49206),(0.34921,0.49206),(0.36508,0.49206),(0.38095,0.49206),(0.39683,0.49206),(0.4127,0.49206),(0.42857,0.49206),(0.44444,0.49206),(0.46032,0.49206),(0.47619,0.49206),(0.49206,0.49206),(0.50794,0.49206),(0.52381,0.49206),(0.53968,0.49206),(0.55556,0.49206),(0.57143,0.49206),(0.5873,0.49206),(0.60317,0.49206),(0.61905,0.49206),(0.63492,0.49206),(0.65079,0.49206),(0.66667,0.49206),(0.68254,0.49206),(0.69841,0.49206),(0.71429,0.49206),(0.73016,0.49206),(0.74603,0.49206),(0.7619,0.49206),(0.77778,0.49206),(0.79365,0.49206),(0.80952,0.49206),(0.8254,0.49206),(0.84127,0.49206),(0.85714,0.49206),(0.87302,0.49206),(0.88889,0.49206),(0.90476,0.49206),(0.92063,0.49206),(0.93651,0.49206),(0.95238,0.49206),(0.96825,0.49206),(0.98413,0.49206),(0.99609,0.49206),(0.00391,0.50794),(0.01587,0.50794),(0.03175,0.50794),(0.04762,0.50794),(0.06349,0.50794),(0.07937,0.50794),(0.09524,0.50794),(0.11111,0.50794),(0.12698,0.50794),(0.14286,0.50794),(0.15873,0.50794),(0.1746,0.50794),(0.19048,0.50794),(0.20635,0.50794),(0.22222,0.50794),(0.2381,0.50794),(0.25397,0.50794),(0.26984,0.50794),(0.28571,0.50794),(0.30159,0.50794),(0.31746,0.50794),(0.33333,0.50794),(0.34921,0.50794),(0.36508,0.50794),(0.38095,0.50794),(0.39683,0.50794),(0.4127,0.50794),(0.42857,0.50794),(0.44444,0.50794),(0.46032,0.50794),(0.47619,0.50794),(0.49206,0.50794),(0.50794,0.50794),(0.52381,0.50794),(0.53968,0.50794),(0.55556,0.50794),(0.57143,0.50794),(0.5873,0.50794),(0.60317,0.50794),(0.61905,0.50794),(0.63492,0.50794),(0.65079,0.50794),(0.66667,0.50794),(0.68254,0.50794),(0.69841,0.50794),(0.71429,0.50794),(0.73016,0.50794),(0.74603,0.50794),(0.7619,0.50794),(0.77778,0.50794),(0.79365,0.50794),(0.80952,0.50794),(0.8254,0.50794),(0.84127,0.50794),(0.85714,0.50794),(0.87302,0.50794),(0.88889,0.50794),(0.90476,0.50794),(0.92063,0.50794),(0.93651,0.50794),(0.95238,0.50794),(0.96825,0.50794),(0.98413,0.50794),(0.99609,0.50794),(0.00391,0.52381),(0.01587,0.52381),(0.03175,0.52381),(0.04762,0.52381),(0.06349,0.52381),(0.07937,0.52381),(0.09524,0.52381),(0.11111,0.52381),(0.12698,0.52381),(0.14286,0.52381),(0.15873,0.52381),(0.1746,0.52381),(0.19048,0.52381),(0.20635,0.52381),(0.22222,0.52381),(0.2381,0.52381),(0.25397,0.52381),(0.26984,0.52381),(0.28571,0.52381),(0.30159,0.52381),(0.31746,0.52381),(0.33333,0.52381),(0.34921,0.52381),(0.36508,0.52381),(0.38095,0.52381),(0.39683,0.52381),(0.4127,0.52381),(0.42857,0.52381),(0.44444,0.52381),(0.46032,0.52381),(0.47619,0.52381),(0.49206,0.52381),(0.50794,0.52381),(0.52381,0.52381),(0.53968,0.52381),(0.55556,0.52381),(0.57143,0.52381),(0.5873,0.52381),(0.60317,0.52381),(0.61905,0.52381),(0.63492,0.52381),(0.65079,0.52381),(0.66667,0.52381),(0.68254,0.52381),(0.69841,0.52381),(0.71429,0.52381),(0.73016,0.52381),(0.74603,0.52381),(0.7619,0.52381),(0.77778,0.52381),(0.79365,0.52381),(0.80952,0.52381),(0.8254,0.52381),(0.84127,0.52381),(0.85714,0.52381),(0.87302,0.52381),(0.88889,0.52381),(0.90476,0.52381),(0.92063,0.52381),(0.93651,0.52381),(0.95238,0.52381),(0.96825,0.52381),(0.98413,0.52381),(0.99609,0.52381),(0.00391,0.53968),(0.01587,0.53968),(0.03175,0.53968),(0.04762,0.53968),(0.06349,0.53968),(0.07937,0.53968),(0.09524,0.53968),(0.11111,0.53968),(0.12698,0.53968),(0.14286,0.53968),(0.15873,0.53968),(0.1746,0.53968),(0.19048,0.53968),(0.20635,0.53968),(0.22222,0.53968),(0.2381,0.53968),(0.25397,0.53968),(0.26984,0.53968),(0.28571,0.53968),(0.30159,0.53968),(0.31746,0.53968),(0.33333,0.53968),(0.34921,0.53968),(0.36508,0.53968),(0.38095,0.53968),(0.39683,0.53968),(0.4127,0.53968),(0.42857,0.53968),(0.44444,0.53968),(0.46032,0.53968),(0.47619,0.53968),(0.49206,0.53968),(0.50794,0.53968),(0.52381,0.53968),(0.53968,0.53968),(0.55556,0.53968),(0.57143,0.53968),(0.5873,0.53968),(0.60317,0.53968),(0.61905,0.53968),(0.63492,0.53968),(0.65079,0.53968),(0.66667,0.53968),(0.68254,0.53968),(0.69841,0.53968),(0.71429,0.53968),(0.73016,0.53968),(0.74603,0.53968),(0.7619,0.53968),(0.77778,0.53968),(0.79365,0.53968),(0.80952,0.53968),(0.8254,0.53968),(0.84127,0.53968),(0.85714,0.53968),(0.87302,0.53968),(0.88889,0.53968),(0.90476,0.53968),(0.92063,0.53968),(0.93651,0.53968),(0.95238,0.53968),(0.96825,0.53968),(0.98413,0.53968),(0.99609,0.53968),(0.00391,0.55556),(0.01587,0.55556),(0.03175,0.55556),(0.04762,0.55556),(0.06349,0.55556),(0.07937,0.55556),(0.09524,0.55556),(0.11111,0.55556),(0.12698,0.55556),(0.14286,0.55556),(0.15873,0.55556),(0.1746,0.55556),(0.19048,0.55556),(0.20635,0.55556),(0.22222,0.55556),(0.2381,0.55556),(0.25397,0.55556),(0.26984,0.55556),(0.28571,0.55556),(0.30159,0.55556),(0.31746,0.55556),(0.33333,0.55556),(0.34921,0.55556),(0.36508,0.55556),(0.38095,0.55556),(0.39683,0.55556),(0.4127,0.55556),(0.42857,0.55556),(0.44444,0.55556),(0.46032,0.55556),(0.47619,0.55556),(0.49206,0.55556),(0.50794,0.55556),(0.52381,0.55556),(0.53968,0.55556),(0.55556,0.55556),(0.57143,0.55556),(0.5873,0.55556),(0.60317,0.55556),(0.61905,0.55556),(0.63492,0.55556),(0.65079,0.55556),(0.66667,0.55556),(0.68254,0.55556),(0.69841,0.55556),(0.71429,0.55556),(0.73016,0.55556),(0.74603,0.55556),(0.7619,0.55556),(0.77778,0.55556),(0.79365,0.55556),(0.80952,0.55556),(0.8254,0.55556),(0.84127,0.55556),(0.85714,0.55556),(0.87302,0.55556),(0.88889,0.55556),(0.90476,0.55556),(0.92063,0.55556),(0.93651,0.55556),(0.95238,0.55556),(0.96825,0.55556),(0.98413,0.55556),(0.99609,0.55556),(0.00391,0.57143),(0.01587,0.57143),(0.03175,0.57143),(0.04762,0.57143),(0.06349,0.57143),(0.07937,0.57143),(0.09524,0.57143),(0.11111,0.57143),(0.12698,0.57143),(0.14286,0.57143),(0.15873,0.57143),(0.1746,0.57143),(0.19048,0.57143),(0.20635,0.57143),(0.22222,0.57143),(0.2381,0.57143),(0.25397,0.57143),(0.26984,0.57143),(0.28571,0.57143),(0.30159,0.57143),(0.31746,0.57143),(0.33333,0.57143),(0.34921,0.57143),(0.36508,0.57143),(0.38095,0.57143),(0.39683,0.57143),(0.4127,0.57143),(0.42857,0.57143),(0.44444,0.57143),(0.46032,0.57143),(0.47619,0.57143),(0.49206,0.57143),(0.50794,0.57143),(0.52381,0.57143),(0.53968,0.57143),(0.55556,0.57143),(0.57143,0.57143),(0.5873,0.57143),(0.60317,0.57143),(0.61905,0.57143),(0.63492,0.57143),(0.65079,0.57143),(0.66667,0.57143),(0.68254,0.57143),(0.69841,0.57143),(0.71429,0.57143),(0.73016,0.57143),(0.74603,0.57143),(0.7619,0.57143),(0.77778,0.57143),(0.79365,0.57143),(0.80952,0.57143),(0.8254,0.57143),(0.84127,0.57143),(0.85714,0.57143),(0.87302,0.57143),(0.88889,0.57143),(0.90476,0.57143),(0.92063,0.57143),(0.93651,0.57143),(0.95238,0.57143),(0.96825,0.57143),(0.98413,0.57143),(0.99609,0.57143),(0.00391,0.5873),(0.01587,0.5873),(0.03175,0.5873),(0.04762,0.5873),(0.06349,0.5873),(0.07937,0.5873),(0.09524,0.5873),(0.11111,0.5873),(0.12698,0.5873),(0.14286,0.5873),(0.15873,0.5873),(0.1746,0.5873),(0.19048,0.5873),(0.20635,0.5873),(0.22222,0.5873),(0.2381,0.5873),(0.25397,0.5873),(0.26984,0.5873),(0.28571,0.5873),(0.30159,0.5873),(0.31746,0.5873),(0.33333,0.5873),(0.34921,0.5873),(0.36508,0.5873),(0.38095,0.5873),(0.39683,0.5873),(0.4127,0.5873),(0.42857,0.5873),(0.44444,0.5873),(0.46032,0.5873),(0.47619,0.5873),(0.49206,0.5873),(0.50794,0.5873),(0.52381,0.5873),(0.53968,0.5873),(0.55556,0.5873),(0.57143,0.5873),(0.5873,0.5873),(0.60317,0.5873),(0.61905,0.5873),(0.63492,0.5873),(0.65079,0.5873),(0.66667,0.5873),(0.68254,0.5873),(0.69841,0.5873),(0.71429,0.5873),(0.73016,0.5873),(0.74603,0.5873),(0.7619,0.5873),(0.77778,0.5873),(0.79365,0.5873),(0.80952,0.5873),(0.8254,0.5873),(0.84127,0.5873),(0.85714,0.5873),(0.87302,0.5873),(0.88889,0.5873),(0.90476,0.5873),(0.92063,0.5873),(0.93651,0.5873),(0.95238,0.5873),(0.96825,0.5873),(0.98413,0.5873),(0.99609,0.5873),(0.00391,0.60317),(0.01587,0.60317),(0.03175,0.60317),(0.04762,0.60317),(0.06349,0.60317),(0.07937,0.60317),(0.09524,0.60317),(0.11111,0.60317),(0.12698,0.60317),(0.14286,0.60317),(0.15873,0.60317),(0.1746,0.60317),(0.19048,0.60317),(0.20635,0.60317),(0.22222,0.60317),(0.2381,0.60317),(0.25397,0.60317),(0.26984,0.60317),(0.28571,0.60317),(0.30159,0.60317),(0.31746,0.60317),(0.33333,0.60317),(0.34921,0.60317),(0.36508,0.60317),(0.38095,0.60317),(0.39683,0.60317),(0.4127,0.60317),(0.42857,0.60317),(0.44444,0.60317),(0.46032,0.60317),(0.47619,0.60317),(0.49206,0.60317),(0.50794,0.60317),(0.52381,0.60317),(0.53968,0.60317),(0.55556,0.60317),(0.57143,0.60317),(0.5873,0.60317),(0.60317,0.60317),(0.61905,0.60317),(0.63492,0.60317),(0.65079,0.60317),(0.66667,0.60317),(0.68254,0.60317),(0.69841,0.60317),(0.71429,0.60317),(0.73016,0.60317),(0.74603,0.60317),(0.7619,0.60317),(0.77778,0.60317),(0.79365,0.60317),(0.80952,0.60317),(0.8254,0.60317),(0.84127,0.60317),(0.85714,0.60317),(0.87302,0.60317),(0.88889,0.60317),(0.90476,0.60317),(0.92063,0.60317),(0.93651,0.60317),(0.95238,0.60317),(0.96825,0.60317),(0.98413,0.60317),(0.99609,0.60317),(0.00391,0.61905),(0.01587,0.61905),(0.03175,0.61905),(0.04762,0.61905),(0.06349,0.61905),(0.07937,0.61905),(0.09524,0.61905),(0.11111,0.61905),(0.12698,0.61905),(0.14286,0.61905),(0.15873,0.61905),(0.1746,0.61905),(0.19048,0.61905),(0.20635,0.61905),(0.22222,0.61905),(0.2381,0.61905),(0.25397,0.61905),(0.26984,0.61905),(0.28571,0.61905),(0.30159,0.61905),(0.31746,0.61905),(0.33333,0.61905),(0.34921,0.61905),(0.36508,0.61905),(0.38095,0.61905),(0.39683,0.61905),(0.4127,0.61905),(0.42857,0.61905),(0.44444,0.61905),(0.46032,0.61905),(0.47619,0.61905),(0.49206,0.61905),(0.50794,0.61905),(0.52381,0.61905),(0.53968,0.61905),(0.55556,0.61905),(0.57143,0.61905),(0.5873,0.61905),(0.60317,0.61905),(0.61905,0.61905),(0.63492,0.61905),(0.65079,0.61905),(0.66667,0.61905),(0.68254,0.61905),(0.69841,0.61905),(0.71429,0.61905),(0.73016,0.61905),(0.74603,0.61905),(0.7619,0.61905),(0.77778,0.61905),(0.79365,0.61905),(0.80952,0.61905),(0.8254,0.61905),(0.84127,0.61905),(0.85714,0.61905),(0.87302,0.61905),(0.88889,0.61905),(0.90476,0.61905),(0.92063,0.61905),(0.93651,0.61905),(0.95238,0.61905),(0.96825,0.61905),(0.98413,0.61905),(0.99609,0.61905),(0.00391,0.63492),(0.01587,0.63492),(0.03175,0.63492),(0.04762,0.63492),(0.06349,0.63492),(0.07937,0.63492),(0.09524,0.63492),(0.11111,0.63492),(0.12698,0.63492),(0.14286,0.63492),(0.15873,0.63492),(0.1746,0.63492),(0.19048,0.63492),(0.20635,0.63492),(0.22222,0.63492),(0.2381,0.63492),(0.25397,0.63492),(0.26984,0.63492),(0.28571,0.63492),(0.30159,0.63492),(0.31746,0.63492),(0.33333,0.63492),(0.34921,0.63492),(0.36508,0.63492),(0.38095,0.63492),(0.39683,0.63492),(0.4127,0.63492),(0.42857,0.63492),(0.44444,0.63492),(0.46032,0.63492),(0.47619,0.63492),(0.49206,0.63492),(0.50794,0.63492),(0.52381,0.63492),(0.53968,0.63492),(0.55556,0.63492),(0.57143,0.63492),(0.5873,0.63492),(0.60317,0.63492),(0.61905,0.63492),(0.63492,0.63492),(0.65079,0.63492),(0.66667,0.63492),(0.68254,0.63492),(0.69841,0.63492),(0.71429,0.63492),(0.73016,0.63492),(0.74603,0.63492),(0.7619,0.63492),(0.77778,0.63492),(0.79365,0.63492),(0.80952,0.63492),(0.8254,0.63492),(0.84127,0.63492),(0.85714,0.63492),(0.87302,0.63492),(0.88889,0.63492),(0.90476,0.63492),(0.92063,0.63492),(0.93651,0.63492),(0.95238,0.63492),(0.96825,0.63492),(0.98413,0.63492),(0.99609,0.63492),(0.00391,0.65079),(0.01587,0.65079),(0.03175,0.65079),(0.04762,0.65079),(0.06349,0.65079),(0.07937,0.65079),(0.09524,0.65079),(0.11111,0.65079),(0.12698,0.65079),(0.14286,0.65079),(0.15873,0.65079),(0.1746,0.65079),(0.19048,0.65079),(0.20635,0.65079),(0.22222,0.65079),(0.2381,0.65079),(0.25397,0.65079),(0.26984,0.65079),(0.28571,0.65079),(0.30159,0.65079),(0.31746,0.65079),(0.33333,0.65079),(0.34921,0.65079),(0.36508,0.65079),(0.38095,0.65079),(0.39683,0.65079),(0.4127,0.65079),(0.42857,0.65079),(0.44444,0.65079),(0.46032,0.65079),(0.47619,0.65079),(0.49206,0.65079),(0.50794,0.65079),(0.52381,0.65079),(0.53968,0.65079),(0.55556,0.65079),(0.57143,0.65079),(0.5873,0.65079),(0.60317,0.65079),(0.61905,0.65079),(0.63492,0.65079),(0.65079,0.65079),(0.66667,0.65079),(0.68254,0.65079),(0.69841,0.65079),(0.71429,0.65079),(0.73016,0.65079),(0.74603,0.65079),(0.7619,0.65079),(0.77778,0.65079),(0.79365,0.65079),(0.80952,0.65079),(0.8254,0.65079),(0.84127,0.65079),(0.85714,0.65079),(0.87302,0.65079),(0.88889,0.65079),(0.90476,0.65079),(0.92063,0.65079),(0.93651,0.65079),(0.95238,0.65079),(0.96825,0.65079),(0.98413,0.65079),(0.99609,0.65079),(0.00391,0.66667),(0.01587,0.66667),(0.03175,0.66667),(0.04762,0.66667),(0.06349,0.66667),(0.07937,0.66667),(0.09524,0.66667),(0.11111,0.66667),(0.12698,0.66667),(0.14286,0.66667),(0.15873,0.66667),(0.1746,0.66667),(0.19048,0.66667),(0.20635,0.66667),(0.22222,0.66667),(0.2381,0.66667),(0.25397,0.66667),(0.26984,0.66667),(0.28571,0.66667),(0.30159,0.66667),(0.31746,0.66667),(0.33333,0.66667),(0.34921,0.66667),(0.36508,0.66667),(0.38095,0.66667),(0.39683,0.66667),(0.4127,0.66667),(0.42857,0.66667),(0.44444,0.66667),(0.46032,0.66667),(0.47619,0.66667),(0.49206,0.66667),(0.50794,0.66667),(0.52381,0.66667),(0.53968,0.66667),(0.55556,0.66667),(0.57143,0.66667),(0.5873,0.66667),(0.60317,0.66667),(0.61905,0.66667),(0.63492,0.66667),(0.65079,0.66667),(0.66667,0.66667),(0.68254,0.66667),(0.69841,0.66667),(0.71429,0.66667),(0.73016,0.66667),(0.74603,0.66667),(0.7619,0.66667),(0.77778,0.66667),(0.79365,0.66667),(0.80952,0.66667),(0.8254,0.66667),(0.84127,0.66667),(0.85714,0.66667),(0.87302,0.66667),(0.88889,0.66667),(0.90476,0.66667),(0.92063,0.66667),(0.93651,0.66667),(0.95238,0.66667),(0.96825,0.66667),(0.98413,0.66667),(0.99609,0.66667),(0.00391,0.68254),(0.01587,0.68254),(0.03175,0.68254),(0.04762,0.68254),(0.06349,0.68254),(0.07937,0.68254),(0.09524,0.68254),(0.11111,0.68254),(0.12698,0.68254),(0.14286,0.68254),(0.15873,0.68254),(0.1746,0.68254),(0.19048,0.68254),(0.20635,0.68254),(0.22222,0.68254),(0.2381,0.68254),(0.25397,0.68254),(0.26984,0.68254),(0.28571,0.68254),(0.30159,0.68254),(0.31746,0.68254),(0.33333,0.68254),(0.34921,0.68254),(0.36508,0.68254),(0.38095,0.68254),(0.39683,0.68254),(0.4127,0.68254),(0.42857,0.68254),(0.44444,0.68254),(0.46032,0.68254),(0.47619,0.68254),(0.49206,0.68254),(0.50794,0.68254),(0.52381,0.68254),(0.53968,0.68254),(0.55556,0.68254),(0.57143,0.68254),(0.5873,0.68254),(0.60317,0.68254),(0.61905,0.68254),(0.63492,0.68254),(0.65079,0.68254),(0.66667,0.68254),(0.68254,0.68254),(0.69841,0.68254),(0.71429,0.68254),(0.73016,0.68254),(0.74603,0.68254),(0.7619,0.68254),(0.77778,0.68254),(0.79365,0.68254),(0.80952,0.68254),(0.8254,0.68254),(0.84127,0.68254),(0.85714,0.68254),(0.87302,0.68254),(0.88889,0.68254),(0.90476,0.68254),(0.92063,0.68254),(0.93651,0.68254),(0.95238,0.68254),(0.96825,0.68254),(0.98413,0.68254),(0.99609,0.68254),(0.00391,0.69841),(0.01587,0.69841),(0.03175,0.69841),(0.04762,0.69841),(0.06349,0.69841),(0.07937,0.69841),(0.09524,0.69841),(0.11111,0.69841),(0.12698,0.69841),(0.14286,0.69841),(0.15873,0.69841),(0.1746,0.69841),(0.19048,0.69841),(0.20635,0.69841),(0.22222,0.69841),(0.2381,0.69841),(0.25397,0.69841),(0.26984,0.69841),(0.28571,0.69841),(0.30159,0.69841),(0.31746,0.69841),(0.33333,0.69841),(0.34921,0.69841),(0.36508,0.69841),(0.38095,0.69841),(0.39683,0.69841),(0.4127,0.69841),(0.42857,0.69841),(0.44444,0.69841),(0.46032,0.69841),(0.47619,0.69841),(0.49206,0.69841),(0.50794,0.69841),(0.52381,0.69841),(0.53968,0.69841),(0.55556,0.69841),(0.57143,0.69841),(0.5873,0.69841),(0.60317,0.69841),(0.61905,0.69841),(0.63492,0.69841),(0.65079,0.69841),(0.66667,0.69841),(0.68254,0.69841),(0.69841,0.69841),(0.71429,0.69841),(0.73016,0.69841),(0.74603,0.69841),(0.7619,0.69841),(0.77778,0.69841),(0.79365,0.69841),(0.80952,0.69841),(0.8254,0.69841),(0.84127,0.69841),(0.85714,0.69841),(0.87302,0.69841),(0.88889,0.69841),(0.90476,0.69841),(0.92063,0.69841),(0.93651,0.69841),(0.95238,0.69841),(0.96825,0.69841),(0.98413,0.69841),(0.99609,0.69841),(0.00391,0.71429),(0.01587,0.71429),(0.03175,0.71429),(0.04762,0.71429),(0.06349,0.71429),(0.07937,0.71429),(0.09524,0.71429),(0.11111,0.71429),(0.12698,0.71429),(0.14286,0.71429),(0.15873,0.71429),(0.1746,0.71429),(0.19048,0.71429),(0.20635,0.71429),(0.22222,0.71429),(0.2381,0.71429),(0.25397,0.71429),(0.26984,0.71429),(0.28571,0.71429),(0.30159,0.71429),(0.31746,0.71429),(0.33333,0.71429),(0.34921,0.71429),(0.36508,0.71429),(0.38095,0.71429),(0.39683,0.71429),(0.4127,0.71429),(0.42857,0.71429),(0.44444,0.71429),(0.46032,0.71429),(0.47619,0.71429),(0.49206,0.71429),(0.50794,0.71429),(0.52381,0.71429),(0.53968,0.71429),(0.55556,0.71429),(0.57143,0.71429),(0.5873,0.71429),(0.60317,0.71429),(0.61905,0.71429),(0.63492,0.71429),(0.65079,0.71429),(0.66667,0.71429),(0.68254,0.71429),(0.69841,0.71429),(0.71429,0.71429),(0.73016,0.71429),(0.74603,0.71429),(0.7619,0.71429),(0.77778,0.71429),(0.79365,0.71429),(0.80952,0.71429),(0.8254,0.71429),(0.84127,0.71429),(0.85714,0.71429),(0.87302,0.71429),(0.88889,0.71429),(0.90476,0.71429),(0.92063,0.71429),(0.93651,0.71429),(0.95238,0.71429),(0.96825,0.71429),(0.98413,0.71429),(0.99609,0.71429),(0.00391,0.73016),(0.01587,0.73016),(0.03175,0.73016),(0.04762,0.73016),(0.06349,0.73016),(0.07937,0.73016),(0.09524,0.73016),(0.11111,0.73016),(0.12698,0.73016),(0.14286,0.73016),(0.15873,0.73016),(0.1746,0.73016),(0.19048,0.73016),(0.20635,0.73016),(0.22222,0.73016),(0.2381,0.73016),(0.25397,0.73016),(0.26984,0.73016),(0.28571,0.73016),(0.30159,0.73016),(0.31746,0.73016),(0.33333,0.73016),(0.34921,0.73016),(0.36508,0.73016),(0.38095,0.73016),(0.39683,0.73016),(0.4127,0.73016),(0.42857,0.73016),(0.44444,0.73016),(0.46032,0.73016),(0.47619,0.73016),(0.49206,0.73016),(0.50794,0.73016),(0.52381,0.73016),(0.53968,0.73016),(0.55556,0.73016),(0.57143,0.73016),(0.5873,0.73016),(0.60317,0.73016),(0.61905,0.73016),(0.63492,0.73016),(0.65079,0.73016),(0.66667,0.73016),(0.68254,0.73016),(0.69841,0.73016),(0.71429,0.73016),(0.73016,0.73016),(0.74603,0.73016),(0.7619,0.73016),(0.77778,0.73016),(0.79365,0.73016),(0.80952,0.73016),(0.8254,0.73016),(0.84127,0.73016),(0.85714,0.73016),(0.87302,0.73016),(0.88889,0.73016),(0.90476,0.73016),(0.92063,0.73016),(0.93651,0.73016),(0.95238,0.73016),(0.96825,0.73016),(0.98413,0.73016),(0.99609,0.73016),(0.00391,0.74603),(0.01587,0.74603),(0.03175,0.74603),(0.04762,0.74603),(0.06349,0.74603),(0.07937,0.74603),(0.09524,0.74603),(0.11111,0.74603),(0.12698,0.74603),(0.14286,0.74603),(0.15873,0.74603),(0.1746,0.74603),(0.19048,0.74603),(0.20635,0.74603),(0.22222,0.74603),(0.2381,0.74603),(0.25397,0.74603),(0.26984,0.74603),(0.28571,0.74603),(0.30159,0.74603),(0.31746,0.74603),(0.33333,0.74603),(0.34921,0.74603),(0.36508,0.74603),(0.38095,0.74603),(0.39683,0.74603),(0.4127,0.74603),(0.42857,0.74603),(0.44444,0.74603),(0.46032,0.74603),(0.47619,0.74603),(0.49206,0.74603),(0.50794,0.74603),(0.52381,0.74603),(0.53968,0.74603),(0.55556,0.74603),(0.57143,0.74603),(0.5873,0.74603),(0.60317,0.74603),(0.61905,0.74603),(0.63492,0.74603),(0.65079,0.74603),(0.66667,0.74603),(0.68254,0.74603),(0.69841,0.74603),(0.71429,0.74603),(0.73016,0.74603),(0.74603,0.74603),(0.7619,0.74603),(0.77778,0.74603),(0.79365,0.74603),(0.80952,0.74603),(0.8254,0.74603),(0.84127,0.74603),(0.85714,0.74603),(0.87302,0.74603),(0.88889,0.74603),(0.90476,0.74603),(0.92063,0.74603),(0.93651,0.74603),(0.95238,0.74603),(0.96825,0.74603),(0.98413,0.74603),(0.99609,0.74603),(0.00391,0.7619),(0.01587,0.7619),(0.03175,0.7619),(0.04762,0.7619),(0.06349,0.7619),(0.07937,0.7619),(0.09524,0.7619),(0.11111,0.7619),(0.12698,0.7619),(0.14286,0.7619),(0.15873,0.7619),(0.1746,0.7619),(0.19048,0.7619),(0.20635,0.7619),(0.22222,0.7619),(0.2381,0.7619),(0.25397,0.7619),(0.26984,0.7619),(0.28571,0.7619),(0.30159,0.7619),(0.31746,0.7619),(0.33333,0.7619),(0.34921,0.7619),(0.36508,0.7619),(0.38095,0.7619),(0.39683,0.7619),(0.4127,0.7619),(0.42857,0.7619),(0.44444,0.7619),(0.46032,0.7619),(0.47619,0.7619),(0.49206,0.7619),(0.50794,0.7619),(0.52381,0.7619),(0.53968,0.7619),(0.55556,0.7619),(0.57143,0.7619),(0.5873,0.7619),(0.60317,0.7619),(0.61905,0.7619),(0.63492,0.7619),(0.65079,0.7619),(0.66667,0.7619),(0.68254,0.7619),(0.69841,0.7619),(0.71429,0.7619),(0.73016,0.7619),(0.74603,0.7619),(0.7619,0.7619),(0.77778,0.7619),(0.79365,0.7619),(0.80952,0.7619),(0.8254,0.7619),(0.84127,0.7619),(0.85714,0.7619),(0.87302,0.7619),(0.88889,0.7619),(0.90476,0.7619),(0.92063,0.7619),(0.93651,0.7619),(0.95238,0.7619),(0.96825,0.7619),(0.98413,0.7619),(0.99609,0.7619),(0.00391,0.77778),(0.01587,0.77778),(0.03175,0.77778),(0.04762,0.77778),(0.06349,0.77778),(0.07937,0.77778),(0.09524,0.77778),(0.11111,0.77778),(0.12698,0.77778),(0.14286,0.77778),(0.15873,0.77778),(0.1746,0.77778),(0.19048,0.77778),(0.20635,0.77778),(0.22222,0.77778),(0.2381,0.77778),(0.25397,0.77778),(0.26984,0.77778),(0.28571,0.77778),(0.30159,0.77778),(0.31746,0.77778),(0.33333,0.77778),(0.34921,0.77778),(0.36508,0.77778),(0.38095,0.77778),(0.39683,0.77778),(0.4127,0.77778),(0.42857,0.77778),(0.44444,0.77778),(0.46032,0.77778),(0.47619,0.77778),(0.49206,0.77778),(0.50794,0.77778),(0.52381,0.77778),(0.53968,0.77778),(0.55556,0.77778),(0.57143,0.77778),(0.5873,0.77778),(0.60317,0.77778),(0.61905,0.77778),(0.63492,0.77778),(0.65079,0.77778),(0.66667,0.77778),(0.68254,0.77778),(0.69841,0.77778),(0.71429,0.77778),(0.73016,0.77778),(0.74603,0.77778),(0.7619,0.77778),(0.77778,0.77778),(0.79365,0.77778),(0.80952,0.77778),(0.8254,0.77778),(0.84127,0.77778),(0.85714,0.77778),(0.87302,0.77778),(0.88889,0.77778),(0.90476,0.77778),(0.92063,0.77778),(0.93651,0.77778),(0.95238,0.77778),(0.96825,0.77778),(0.98413,0.77778),(0.99609,0.77778),(0.00391,0.79365),(0.01587,0.79365),(0.03175,0.79365),(0.04762,0.79365),(0.06349,0.79365),(0.07937,0.79365),(0.09524,0.79365),(0.11111,0.79365),(0.12698,0.79365),(0.14286,0.79365),(0.15873,0.79365),(0.1746,0.79365),(0.19048,0.79365),(0.20635,0.79365),(0.22222,0.79365),(0.2381,0.79365),(0.25397,0.79365),(0.26984,0.79365),(0.28571,0.79365),(0.30159,0.79365),(0.31746,0.79365),(0.33333,0.79365),(0.34921,0.79365),(0.36508,0.79365),(0.38095,0.79365),(0.39683,0.79365),(0.4127,0.79365),(0.42857,0.79365),(0.44444,0.79365),(0.46032,0.79365),(0.47619,0.79365),(0.49206,0.79365),(0.50794,0.79365),(0.52381,0.79365),(0.53968,0.79365),(0.55556,0.79365),(0.57143,0.79365),(0.5873,0.79365),(0.60317,0.79365),(0.61905,0.79365),(0.63492,0.79365),(0.65079,0.79365),(0.66667,0.79365),(0.68254,0.79365),(0.69841,0.79365),(0.71429,0.79365),(0.73016,0.79365),(0.74603,0.79365),(0.7619,0.79365),(0.77778,0.79365),(0.79365,0.79365),(0.80952,0.79365),(0.8254,0.79365),(0.84127,0.79365),(0.85714,0.79365),(0.87302,0.79365),(0.88889,0.79365),(0.90476,0.79365),(0.92063,0.79365),(0.93651,0.79365),(0.95238,0.79365),(0.96825,0.79365),(0.98413,0.79365),(0.99609,0.79365),(0.00391,0.80952),(0.01587,0.80952),(0.03175,0.80952),(0.04762,0.80952),(0.06349,0.80952),(0.07937,0.80952),(0.09524,0.80952),(0.11111,0.80952),(0.12698,0.80952),(0.14286,0.80952),(0.15873,0.80952),(0.1746,0.80952),(0.19048,0.80952),(0.20635,0.80952),(0.22222,0.80952),(0.2381,0.80952),(0.25397,0.80952),(0.26984,0.80952),(0.28571,0.80952),(0.30159,0.80952),(0.31746,0.80952),(0.33333,0.80952),(0.34921,0.80952),(0.36508,0.80952),(0.38095,0.80952),(0.39683,0.80952),(0.4127,0.80952),(0.42857,0.80952),(0.44444,0.80952),(0.46032,0.80952),(0.47619,0.80952),(0.49206,0.80952),(0.50794,0.80952),(0.52381,0.80952),(0.53968,0.80952),(0.55556,0.80952),(0.57143,0.80952),(0.5873,0.80952),(0.60317,0.80952),(0.61905,0.80952),(0.63492,0.80952),(0.65079,0.80952),(0.66667,0.80952),(0.68254,0.80952),(0.69841,0.80952),(0.71429,0.80952),(0.73016,0.80952),(0.74603,0.80952),(0.7619,0.80952),(0.77778,0.80952),(0.79365,0.80952),(0.80952,0.80952),(0.8254,0.80952),(0.84127,0.80952),(0.85714,0.80952),(0.87302,0.80952),(0.88889,0.80952),(0.90476,0.80952),(0.92063,0.80952),(0.93651,0.80952),(0.95238,0.80952),(0.96825,0.80952),(0.98413,0.80952),(0.99609,0.80952),(0.00391,0.8254),(0.01587,0.8254),(0.03175,0.8254),(0.04762,0.8254),(0.06349,0.8254),(0.07937,0.8254),(0.09524,0.8254),(0.11111,0.8254),(0.12698,0.8254),(0.14286,0.8254),(0.15873,0.8254),(0.1746,0.8254),(0.19048,0.8254),(0.20635,0.8254),(0.22222,0.8254),(0.2381,0.8254),(0.25397,0.8254),(0.26984,0.8254),(0.28571,0.8254),(0.30159,0.8254),(0.31746,0.8254),(0.33333,0.8254),(0.34921,0.8254),(0.36508,0.8254),(0.38095,0.8254),(0.39683,0.8254),(0.4127,0.8254),(0.42857,0.8254),(0.44444,0.8254),(0.46032,0.8254),(0.47619,0.8254),(0.49206,0.8254),(0.50794,0.8254),(0.52381,0.8254),(0.53968,0.8254),(0.55556,0.8254),(0.57143,0.8254),(0.5873,0.8254),(0.60317,0.8254),(0.61905,0.8254),(0.63492,0.8254),(0.65079,0.8254),(0.66667,0.8254),(0.68254,0.8254),(0.69841,0.8254),(0.71429,0.8254),(0.73016,0.8254),(0.74603,0.8254),(0.7619,0.8254),(0.77778,0.8254),(0.79365,0.8254),(0.80952,0.8254),(0.8254,0.8254),(0.84127,0.8254),(0.85714,0.8254),(0.87302,0.8254),(0.88889,0.8254),(0.90476,0.8254),(0.92063,0.8254),(0.93651,0.8254),(0.95238,0.8254),(0.96825,0.8254),(0.98413,0.8254),(0.99609,0.8254),(0.00391,0.84127),(0.01587,0.84127),(0.03175,0.84127),(0.04762,0.84127),(0.06349,0.84127),(0.07937,0.84127),(0.09524,0.84127),(0.11111,0.84127),(0.12698,0.84127),(0.14286,0.84127),(0.15873,0.84127),(0.1746,0.84127),(0.19048,0.84127),(0.20635,0.84127),(0.22222,0.84127),(0.2381,0.84127),(0.25397,0.84127),(0.26984,0.84127),(0.28571,0.84127),(0.30159,0.84127),(0.31746,0.84127),(0.33333,0.84127),(0.34921,0.84127),(0.36508,0.84127),(0.38095,0.84127),(0.39683,0.84127),(0.4127,0.84127),(0.42857,0.84127),(0.44444,0.84127),(0.46032,0.84127),(0.47619,0.84127),(0.49206,0.84127),(0.50794,0.84127),(0.52381,0.84127),(0.53968,0.84127),(0.55556,0.84127),(0.57143,0.84127),(0.5873,0.84127),(0.60317,0.84127),(0.61905,0.84127),(0.63492,0.84127),(0.65079,0.84127),(0.66667,0.84127),(0.68254,0.84127),(0.69841,0.84127),(0.71429,0.84127),(0.73016,0.84127),(0.74603,0.84127),(0.7619,0.84127),(0.77778,0.84127),(0.79365,0.84127),(0.80952,0.84127),(0.8254,0.84127),(0.84127,0.84127),(0.85714,0.84127),(0.87302,0.84127),(0.88889,0.84127),(0.90476,0.84127),(0.92063,0.84127),(0.93651,0.84127),(0.95238,0.84127),(0.96825,0.84127),(0.98413,0.84127),(0.99609,0.84127),(0.00391,0.85714),(0.01587,0.85714),(0.03175,0.85714),(0.04762,0.85714),(0.06349,0.85714),(0.07937,0.85714),(0.09524,0.85714),(0.11111,0.85714),(0.12698,0.85714),(0.14286,0.85714),(0.15873,0.85714),(0.1746,0.85714),(0.19048,0.85714),(0.20635,0.85714),(0.22222,0.85714),(0.2381,0.85714),(0.25397,0.85714),(0.26984,0.85714),(0.28571,0.85714),(0.30159,0.85714),(0.31746,0.85714),(0.33333,0.85714),(0.34921,0.85714),(0.36508,0.85714),(0.38095,0.85714),(0.39683,0.85714),(0.4127,0.85714),(0.42857,0.85714),(0.44444,0.85714),(0.46032,0.85714),(0.47619,0.85714),(0.49206,0.85714),(0.50794,0.85714),(0.52381,0.85714),(0.53968,0.85714),(0.55556,0.85714),(0.57143,0.85714),(0.5873,0.85714),(0.60317,0.85714),(0.61905,0.85714),(0.63492,0.85714),(0.65079,0.85714),(0.66667,0.85714),(0.68254,0.85714),(0.69841,0.85714),(0.71429,0.85714),(0.73016,0.85714),(0.74603,0.85714),(0.7619,0.85714),(0.77778,0.85714),(0.79365,0.85714),(0.80952,0.85714),(0.8254,0.85714),(0.84127,0.85714),(0.85714,0.85714),(0.87302,0.85714),(0.88889,0.85714),(0.90476,0.85714),(0.92063,0.85714),(0.93651,0.85714),(0.95238,0.85714),(0.96825,0.85714),(0.98413,0.85714),(0.99609,0.85714),(0.00391,0.87302),(0.01587,0.87302),(0.03175,0.87302),(0.04762,0.87302),(0.06349,0.87302),(0.07937,0.87302),(0.09524,0.87302),(0.11111,0.87302),(0.12698,0.87302),(0.14286,0.87302),(0.15873,0.87302),(0.1746,0.87302),(0.19048,0.87302),(0.20635,0.87302),(0.22222,0.87302),(0.2381,0.87302),(0.25397,0.87302),(0.26984,0.87302),(0.28571,0.87302),(0.30159,0.87302),(0.31746,0.87302),(0.33333,0.87302),(0.34921,0.87302),(0.36508,0.87302),(0.38095,0.87302),(0.39683,0.87302),(0.4127,0.87302),(0.42857,0.87302),(0.44444,0.87302),(0.46032,0.87302),(0.47619,0.87302),(0.49206,0.87302),(0.50794,0.87302),(0.52381,0.87302),(0.53968,0.87302),(0.55556,0.87302),(0.57143,0.87302),(0.5873,0.87302),(0.60317,0.87302),(0.61905,0.87302),(0.63492,0.87302),(0.65079,0.87302),(0.66667,0.87302),(0.68254,0.87302),(0.69841,0.87302),(0.71429,0.87302),(0.73016,0.87302),(0.74603,0.87302),(0.7619,0.87302),(0.77778,0.87302),(0.79365,0.87302),(0.80952,0.87302),(0.8254,0.87302),(0.84127,0.87302),(0.85714,0.87302),(0.87302,0.87302),(0.88889,0.87302),(0.90476,0.87302),(0.92063,0.87302),(0.93651,0.87302),(0.95238,0.87302),(0.96825,0.87302),(0.98413,0.87302),(0.99609,0.87302),(0.00391,0.88889),(0.01587,0.88889),(0.03175,0.88889),(0.04762,0.88889),(0.06349,0.88889),(0.07937,0.88889),(0.09524,0.88889),(0.11111,0.88889),(0.12698,0.88889),(0.14286,0.88889),(0.15873,0.88889),(0.1746,0.88889),(0.19048,0.88889),(0.20635,0.88889),(0.22222,0.88889),(0.2381,0.88889),(0.25397,0.88889),(0.26984,0.88889),(0.28571,0.88889),(0.30159,0.88889),(0.31746,0.88889),(0.33333,0.88889),(0.34921,0.88889),(0.36508,0.88889),(0.38095,0.88889),(0.39683,0.88889),(0.4127,0.88889),(0.42857,0.88889),(0.44444,0.88889),(0.46032,0.88889),(0.47619,0.88889),(0.49206,0.88889),(0.50794,0.88889),(0.52381,0.88889),(0.53968,0.88889),(0.55556,0.88889),(0.57143,0.88889),(0.5873,0.88889),(0.60317,0.88889),(0.61905,0.88889),(0.63492,0.88889),(0.65079,0.88889),(0.66667,0.88889),(0.68254,0.88889),(0.69841,0.88889),(0.71429,0.88889),(0.73016,0.88889),(0.74603,0.88889),(0.7619,0.88889),(0.77778,0.88889),(0.79365,0.88889),(0.80952,0.88889),(0.8254,0.88889),(0.84127,0.88889),(0.85714,0.88889),(0.87302,0.88889),(0.88889,0.88889),(0.90476,0.88889),(0.92063,0.88889),(0.93651,0.88889),(0.95238,0.88889),(0.96825,0.88889),(0.98413,0.88889),(0.99609,0.88889),(0.00391,0.90476),(0.01587,0.90476),(0.03175,0.90476),(0.04762,0.90476),(0.06349,0.90476),(0.07937,0.90476),(0.09524,0.90476),(0.11111,0.90476),(0.12698,0.90476),(0.14286,0.90476),(0.15873,0.90476),(0.1746,0.90476),(0.19048,0.90476),(0.20635,0.90476),(0.22222,0.90476),(0.2381,0.90476),(0.25397,0.90476),(0.26984,0.90476),(0.28571,0.90476),(0.30159,0.90476),(0.31746,0.90476),(0.33333,0.90476),(0.34921,0.90476),(0.36508,0.90476),(0.38095,0.90476),(0.39683,0.90476),(0.4127,0.90476),(0.42857,0.90476),(0.44444,0.90476),(0.46032,0.90476),(0.47619,0.90476),(0.49206,0.90476),(0.50794,0.90476),(0.52381,0.90476),(0.53968,0.90476),(0.55556,0.90476),(0.57143,0.90476),(0.5873,0.90476),(0.60317,0.90476),(0.61905,0.90476),(0.63492,0.90476),(0.65079,0.90476),(0.66667,0.90476),(0.68254,0.90476),(0.69841,0.90476),(0.71429,0.90476),(0.73016,0.90476),(0.74603,0.90476),(0.7619,0.90476),(0.77778,0.90476),(0.79365,0.90476),(0.80952,0.90476),(0.8254,0.90476),(0.84127,0.90476),(0.85714,0.90476),(0.87302,0.90476),(0.88889,0.90476),(0.90476,0.90476),(0.92063,0.90476),(0.93651,0.90476),(0.95238,0.90476),(0.96825,0.90476),(0.98413,0.90476),(0.99609,0.90476),(0.00391,0.92063),(0.01587,0.92063),(0.03175,0.92063),(0.04762,0.92063),(0.06349,0.92063),(0.07937,0.92063),(0.09524,0.92063),(0.11111,0.92063),(0.12698,0.92063),(0.14286,0.92063),(0.15873,0.92063),(0.1746,0.92063),(0.19048,0.92063),(0.20635,0.92063),(0.22222,0.92063),(0.2381,0.92063),(0.25397,0.92063),(0.26984,0.92063),(0.28571,0.92063),(0.30159,0.92063),(0.31746,0.92063),(0.33333,0.92063),(0.34921,0.92063),(0.36508,0.92063),(0.38095,0.92063),(0.39683,0.92063),(0.4127,0.92063),(0.42857,0.92063),(0.44444,0.92063),(0.46032,0.92063),(0.47619,0.92063),(0.49206,0.92063),(0.50794,0.92063),(0.52381,0.92063),(0.53968,0.92063),(0.55556,0.92063),(0.57143,0.92063),(0.5873,0.92063),(0.60317,0.92063),(0.61905,0.92063),(0.63492,0.92063),(0.65079,0.92063),(0.66667,0.92063),(0.68254,0.92063),(0.69841,0.92063),(0.71429,0.92063),(0.73016,0.92063),(0.74603,0.92063),(0.7619,0.92063),(0.77778,0.92063),(0.79365,0.92063),(0.80952,0.92063),(0.8254,0.92063),(0.84127,0.92063),(0.85714,0.92063),(0.87302,0.92063),(0.88889,0.92063),(0.90476,0.92063),(0.92063,0.92063),(0.93651,0.92063),(0.95238,0.92063),(0.96825,0.92063),(0.98413,0.92063),(0.99609,0.92063),(0.00391,0.93651),(0.01587,0.93651),(0.03175,0.93651),(0.04762,0.93651),(0.06349,0.93651),(0.07937,0.93651),(0.09524,0.93651),(0.11111,0.93651),(0.12698,0.93651),(0.14286,0.93651),(0.15873,0.93651),(0.1746,0.93651),(0.19048,0.93651),(0.20635,0.93651),(0.22222,0.93651),(0.2381,0.93651),(0.25397,0.93651),(0.26984,0.93651),(0.28571,0.93651),(0.30159,0.93651),(0.31746,0.93651),(0.33333,0.93651),(0.34921,0.93651),(0.36508,0.93651),(0.38095,0.93651),(0.39683,0.93651),(0.4127,0.93651),(0.42857,0.93651),(0.44444,0.93651),(0.46032,0.93651),(0.47619,0.93651),(0.49206,0.93651),(0.50794,0.93651),(0.52381,0.93651),(0.53968,0.93651),(0.55556,0.93651),(0.57143,0.93651),(0.5873,0.93651),(0.60317,0.93651),(0.61905,0.93651),(0.63492,0.93651),(0.65079,0.93651),(0.66667,0.93651),(0.68254,0.93651),(0.69841,0.93651),(0.71429,0.93651),(0.73016,0.93651),(0.74603,0.93651),(0.7619,0.93651),(0.77778,0.93651),(0.79365,0.93651),(0.80952,0.93651),(0.8254,0.93651),(0.84127,0.93651),(0.85714,0.93651),(0.87302,0.93651),(0.88889,0.93651),(0.90476,0.93651),(0.92063,0.93651),(0.93651,0.93651),(0.95238,0.93651),(0.96825,0.93651),(0.98413,0.93651),(0.99609,0.93651),(0.00391,0.95238),(0.01587,0.95238),(0.03175,0.95238),(0.04762,0.95238),(0.06349,0.95238),(0.07937,0.95238),(0.09524,0.95238),(0.11111,0.95238),(0.12698,0.95238),(0.14286,0.95238),(0.15873,0.95238),(0.1746,0.95238),(0.19048,0.95238),(0.20635,0.95238),(0.22222,0.95238),(0.2381,0.95238),(0.25397,0.95238),(0.26984,0.95238),(0.28571,0.95238),(0.30159,0.95238),(0.31746,0.95238),(0.33333,0.95238),(0.34921,0.95238),(0.36508,0.95238),(0.38095,0.95238),(0.39683,0.95238),(0.4127,0.95238),(0.42857,0.95238),(0.44444,0.95238),(0.46032,0.95238),(0.47619,0.95238),(0.49206,0.95238),(0.50794,0.95238),(0.52381,0.95238),(0.53968,0.95238),(0.55556,0.95238),(0.57143,0.95238),(0.5873,0.95238),(0.60317,0.95238),(0.61905,0.95238),(0.63492,0.95238),(0.65079,0.95238),(0.66667,0.95238),(0.68254,0.95238),(0.69841,0.95238),(0.71429,0.95238),(0.73016,0.95238),(0.74603,0.95238),(0.7619,0.95238),(0.77778,0.95238),(0.79365,0.95238),(0.80952,0.95238),(0.8254,0.95238),(0.84127,0.95238),(0.85714,0.95238),(0.87302,0.95238),(0.88889,0.95238),(0.90476,0.95238),(0.92063,0.95238),(0.93651,0.95238),(0.95238,0.95238),(0.96825,0.95238),(0.98413,0.95238),(0.99609,0.95238),(0.00391,0.96825),(0.01587,0.96825),(0.03175,0.96825),(0.04762,0.96825),(0.06349,0.96825),(0.07937,0.96825),(0.09524,0.96825),(0.11111,0.96825),(0.12698,0.96825),(0.14286,0.96825),(0.15873,0.96825),(0.1746,0.96825),(0.19048,0.96825),(0.20635,0.96825),(0.22222,0.96825),(0.2381,0.96825),(0.25397,0.96825),(0.26984,0.96825),(0.28571,0.96825),(0.30159,0.96825),(0.31746,0.96825),(0.33333,0.96825),(0.34921,0.96825),(0.36508,0.96825),(0.38095,0.96825),(0.39683,0.96825),(0.4127,0.96825),(0.42857,0.96825),(0.44444,0.96825),(0.46032,0.96825),(0.47619,0.96825),(0.49206,0.96825),(0.50794,0.96825),(0.52381,0.96825),(0.53968,0.96825),(0.55556,0.96825),(0.57143,0.96825),(0.5873,0.96825),(0.60317,0.96825),(0.61905,0.96825),(0.63492,0.96825),(0.65079,0.96825),(0.66667,0.96825),(0.68254,0.96825),(0.69841,0.96825),(0.71429,0.96825),(0.73016,0.96825),(0.74603,0.96825),(0.7619,0.96825),(0.77778,0.96825),(0.79365,0.96825),(0.80952,0.96825),(0.8254,0.96825),(0.84127,0.96825),(0.85714,0.96825),(0.87302,0.96825),(0.88889,0.96825),(0.90476,0.96825),(0.92063,0.96825),(0.93651,0.96825),(0.95238,0.96825),(0.96825,0.96825),(0.98413,0.96825),(0.99609,0.96825),(0.00391,0.98413),(0.01587,0.98413),(0.03175,0.98413),(0.04762,0.98413),(0.06349,0.98413),(0.07937,0.98413),(0.09524,0.98413),(0.11111,0.98413),(0.12698,0.98413),(0.14286,0.98413),(0.15873,0.98413),(0.1746,0.98413),(0.19048,0.98413),(0.20635,0.98413),(0.22222,0.98413),(0.2381,0.98413),(0.25397,0.98413),(0.26984,0.98413),(0.28571,0.98413),(0.30159,0.98413),(0.31746,0.98413),(0.33333,0.98413),(0.34921,0.98413),(0.36508,0.98413),(0.38095,0.98413),(0.39683,0.98413),(0.4127,0.98413),(0.42857,0.98413),(0.44444,0.98413),(0.46032,0.98413),(0.47619,0.98413),(0.49206,0.98413),(0.50794,0.98413),(0.52381,0.98413),(0.53968,0.98413),(0.55556,0.98413),(0.57143,0.98413),(0.5873,0.98413),(0.60317,0.98413),(0.61905,0.98413),(0.63492,0.98413),(0.65079,0.98413),(0.66667,0.98413),(0.68254,0.98413),(0.69841,0.98413),(0.71429,0.98413),(0.73016,0.98413),(0.74603,0.98413),(0.7619,0.98413),(0.77778,0.98413),(0.79365,0.98413),(0.80952,0.98413),(0.8254,0.98413),(0.84127,0.98413),(0.85714,0.98413),(0.87302,0.98413),(0.88889,0.98413),(0.90476,0.98413),(0.92063,0.98413),(0.93651,0.98413),(0.95238,0.98413),(0.96825,0.98413),(0.98413,0.98413),(0.99609,0.98413),(0.00391,0.99609),(0.01587,0.99609),(0.03175,0.99609),(0.04762,0.99609),(0.06349,0.99609),(0.07937,0.99609),(0.09524,0.99609),(0.11111,0.99609),(0.12698,0.99609),(0.14286,0.99609),(0.15873,0.99609),(0.1746,0.99609),(0.19048,0.99609),(0.20635,0.99609),(0.22222,0.99609),(0.2381,0.99609),(0.25397,0.99609),(0.26984,0.99609),(0.28571,0.99609),(0.30159,0.99609),(0.31746,0.99609),(0.33333,0.99609),(0.34921,0.99609),(0.36508,0.99609),(0.38095,0.99609),(0.39683,0.99609),(0.4127,0.99609),(0.42857,0.99609),(0.44444,0.99609),(0.46032,0.99609),(0.47619,0.99609),(0.49206,0.99609),(0.50794,0.99609),(0.52381,0.99609),(0.53968,0.99609),(0.55556,0.99609),(0.57143,0.99609),(0.5873,0.99609),(0.60317,0.99609),(0.61905,0.99609),(0.63492,0.99609),(0.65079,0.99609),(0.66667,0.99609),(0.68254,0.99609),(0.69841,0.99609),(0.71429,0.99609),(0.73016,0.99609),(0.74603,0.99609),(0.7619,0.99609),(0.77778,0.99609),(0.79365,0.99609),(0.80952,0.99609),(0.8254,0.99609),(0.84127,0.99609),(0.85714,0.99609),(0.87302,0.99609),(0.88889,0.99609),(0.90476,0.99609),(0.92063,0.99609),(0.93651,0.99609),(0.95238,0.99609),(0.96825,0.99609),(0.98413,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD007.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD007.py load and self-test diagnostics complete.")
