####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD006.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD006.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD006.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD006.x3d'),
    GeoLOD(center=(-45.000000,-45.000000,20275.000000),child1Url=["MarsLOD007.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD007.x3d"],range=3.6E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars002.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars002.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,-90.000000,0.000000),height=[2762.7498,2804.3154,2813.6243,2875.9473,2941.0142,2998.515,3086.1929,3157.567,3244.1611,3301.2852,3304.716,3423.4065,3601.0388,3706.6768,3756.0679,3784.7004,3757.8835,3829.9258,3976.411,4028.2715,4084.2375,4133.4277,4166.656,4173.615,4203.336,4353.787,4394.417,4406.5083,4413.898,4422.44,4418.1997,4367.651,2369.2488,2298.1377,2170.478,2188.4636,2167.0469,2237.366,2269.9392,2314.0146,2268.666,2127.9233,2126.517,2220.0645,2375.0566,2436.4668,2433.1055,2448.1204,2365.178,2387.2317,2284.2212,2306.9272,2376.7078,2453.1045,2380.6753,2389.0408,2384.5642,2384.0747,2409.0447,2396.6963,2449.3445,2501.048,2536.256,2549.2576,2223.4182,2237.2751,2096.4294,2120.4578,2003.4808,1843.1602,1365.4005,1308.3344,1531.5275,1311.4315,1290.5486,1476.0645,1453.6749,1428.1548,1397.5344,1399.265,1426.5189,1494.7998,1597.6963,1643.4697,1612.5778,1616.9423,1674.8927,1680.153,1656.8304,1787.4775,1920.8402,1945.5297,1934.0441,1955.4324,1959.0045,1963.687,1874.1436,2026.037,2087.2883,1898.186,1700.2941,1567.9238,1405.4901,1276.1653,1494.4309,1344.4025,1420.952,1392.3026,1570.0502,1398.955,1232.752,1240.1996,1259.335,1283.9347,1319.5083,1334.0812,1356.1737,1369.2648,1406.2708,1464.0978,1556.5721,1509.5977,1592.9602,1626.5103,1599.1234,1629.5441,1704.2621,1717.4557,1575.1753,1684.4723,1807.7638,1846.7439,1892.0823,1956.0643,1722.6144,1447.5438,1346.1223,1157.224,1112.3344,1108.7745,1142.5125,1128.366,1131.8286,1167.923,1084.2067,1251.5549,1367.7754,1486.655,1562.8429,1531.8323,1539.8511,1598.5856,1580.0116,1589.4501,1584.6573,1555.5618,1502.2665,1484.9268,1570.0797,1614.8019,1379.6869,1527.9067,1244.3359,580.30457,453.19778,652.5067,1252.2546,1030.5239,953.04047,906.7899,886.83636,934.8733,1017.9689,1068.0253,1115.1656,1038.5912,1041.2932,1155.6838,1258.9865,1360.9701,1362.4105,1587.7089,1575.258,1499.6882,1673.7916,1520.3472,1448.9492,1404.0028,1268.7726,1235.6166,1290.6761,1311.7642,904.32825,1343.4861,1313.464,981.86694,795.7625,845.0916,1054.3418,935.9924,906.9516,918.4588,994.87787,997.4484,971.4032,978.73364,1122.3324,1213.4915,1262.2482,1476.0619,1411.2609,1361.1077,1234.3999,1197.7836,1465.5702,1798.1129,1812.7887,1449.8477,1279.3865,1481.5133,1548.6827,1559.9653,1453.0005,1229.3372,1284.0774,1271.2108,1200.1569,1167.4517,1119.0206,1052.5137,1054.0503,998.94415,921.8569,848.6781,1217.9209,1104.3652,851.89764,1006.2009,696.2454,-328.0095,258.878,1377.0577,1301.6045,1171.9729,1013.6868,1210.2577,1710.0063,1752.1748,1973.0009,1894.4163,1603.5745,1471.4786,1427.6698,1373.2872,1433.2938,1330.2646,1396.8962,1326.5343,1236.3691,1300.0503,1380.4407,1440.5737,1283.9844,1293.5002,1012.914,1012.6219,1010.03937,740.6686,696.7733,618.116,607.9058,566.56366,1063.8508,1153.1232,1175.6122,1040.2444,812.1703,886.8902,1055.0038,1325.728,1730.0145,1758.6492,1534.8773,1475.0005,1433.9053,1285.9869,1397.3826,1365.5363,1999.4576,1256.1072,1097.8477,1134.7306,1108.6005,1142.3511,1318.9513,969.3964,861.9083,824.0255,770.8653,794.34393,823.477,411.23856,261.50366,698.0856,486.32144,453.9345,894.4879,879.3185,444.488,1021.9458,897.57886,1129.9684,1678.1726,1805.5029,1503.7913,1489.8911,1584.7568,1543.0562,1380.7937,1363.258,1517.9535,1188.4568,826.8698,712.0652,680.17676,665.287,780.24084,1099.6543,1188.5038,978.9421,1025.2382,975.3402,461.36255,831.8464,-237.04756,441.00583,265.26968,899.01605,269.0357,361.02048,386.67505,759.6481,1116.6638,1277.7882,1256.2422,1663.0387,1675.2881,1570.9811,1312.5416,1499.194,1609.7892,1738.7092,1852.8524,1881.168,1247.1749,810.4745,725.99786,812.55414,1299.7764,1917.2876,2012.5392,1711.22,1107.4147,-100.05933,-154.93182,-208.85435,-1781.7032,-1812.935,-2170.6636,-1419.3047,-1009.9945,979.85895,419.16678,271.12253,326.25433,574.2246,274.44803,1112.1404,1343.5724,1354.0216,1458.6589,1542.9232,1686.9768,1598.4027,1657.7389,1478.07,543.15314,477.65732,1611.9939,1442.158,1704.3527,1074.1351,1432.3716,1642.6226,901.6786,-338.27972,-1044.4575,-2540.1199,-3001.5906,-2782.059,-2795.8599,-2777.6157,-2438.3906,-1428.0002,-297.22366,974.30896,422.36557,761.2156,498.1832,592.516,771.601,961.0488,501.2941,1310.1757,1369.3883,1504.9747,1545.9545,1551.4924,1127.6044,1148.4927,1991.0343,2475.071,2276.4927,978.3549,550.45715,1316.1626,1112.432,-4.148991,-1080.9407,-2592.8142,-2860.9106,-2806.2747,-2809.2266,-2874.1677,-2687.4722,-1515.1315,-1650.5742,-612.0504,362.20615,745.3348,555.5951,634.9485,1071.8181,1439.4076,1353.238,1127.259,1122.6973,1275.5585,2017.5073,1976.9326,2118.7593,2244.9636,2483.8982,2814.0461,2770.8213,2143.733,1917.724,1788.3446,1319.8885,432.1296,-300.44147,-692.54785,-2511.219,-3089.081,-3088.8982,-3111.8662,-2866.1592,-1764.8582,-685.2606,48.24451,435.611,978.2332,928.843,947.46967,1236.6179,1500.7161,1665.1777,1329.5657,1137.0302,1156.378,2385.6409,2438.8271,2726.0051,2918.767,2921.377,3058.7842,3254.0554,2327.5952,2014.9465,1620.8971,1316.1672,722.4178,284.9798,-212.1528,-1452.3932,-2935.4417,-3203.3044,-3141.2324,-2667.4004,-1327.4083,-610.8952,-245.29448,949.50104,939.88916,774.1441,643.3918,1427.4465,1593.9526,1639.5262,1439.7899,1167.7238,1243.9531,3586.6208,3677.7656,3366.3318,3255.3608,3137.4226,3264.3342,3179.409,2774.8333,2465.9033,1807.4207,1873.318,1975.4204,1069.4584,491.90793,-396.77295,-1034.0331,-1648.3689,-1666.0146,-1137.1395,-615.38763,-124.63387,260.729,100.76647,599.90234,814.84814,336.8544,1319.5759,1375.3418,1410.2727,1196.8954,1109.4386,1270.6901,4690.276,4813.6,4948.9365,4007.1733,3499.7004,3391.9028,3232.9316,3108.9673,2596.813,2356.4233,1992.7129,1994.6317,2002.165,1191.5562,1241.1525,-459.35583,-876.4215,-887.87067,-871.74524,-169.66064,-50.008907,-273.4297,401.80292,650.14136,781.66486,577.29156,1004.7149,1234.7247,1305.1473,865.217,1107.2694,956.06506,4646.114,4214.553,4202.2197,4355.5366,4308.173,3566.9102,3053.6455,2800.201,2579.2263,2430.3757,2440.9136,1960.1918,1632.7083,1265.5321,1084.7206,563.2516,1164.7719,122.45376,-209.23514,-77.01453,224.9717,222.54355,380.28775,376.5534,796.04486,1160.3617,976.9617,1046.3794,1373.2688,1449.388,1163.5042,1162.5121,3992.5796,3549.9592,3518.6785,3712.552,4737.6445,4789.384,3334.4019,2756.584,2612.6763,2569.8345,2402.2766,1861.377,1602.5352,979.6246,837.66516,918.88727,1013.20447,811.92926,171.88672,445.88324,624.2402,570.6917,315.05045,199.24547,504.2124,876.4278,858.82715,1068.995,1348.7014,1430.264,1385.4668,1379.751,3242.079,3075.2092,2934.5923,3246.8904,4249.854,4512.877,4103.614,4247.018,3125.9614,2475.02,1976.3564,1297.5863,1003.76227,817.1271,812.3592,601.2926,630.74774,653.9248,-185.87404,593.7965,636.0896,637.3038,475.4549,123.27091,156.38678,474.26538,660.29285,937.969,1279.0082,1489.5372,1461.5146,1460.6749,3131.8188,2900.661,2734.672,2716.5657,2789.8044,3244.6218,3486.2847,3514.7205,3250.0007,2794.5105,2553.705,1494.8485,744.9204,670.7927,752.2842,678.331,625.4753,652.7086,296.83218,-320.12427,-12.074679,199.09885,187.38303,-90.32538,-104.71756,-56.944305,242.76613,672.97156,1023.93964,1127.4298,1392.0835,1440.2974,3218.4812,2908.6199,2724.3633,2591.8193,2434.73,2691.9407,3538.6267,3143.356,2801.881,2757.9653,3227.9158,2362.7112,970.71185,866.1326,743.2485,996.66376,1061.2069,858.3466,774.81665,-540.83295,-1328.093,-274.69733,-415.2143,-403.23004,-447.5899,-480.43933,-318.9757,57.734707,577.49713,426.0672,631.2595,972.2702,3550.3203,3196.533,2852.8843,2654.7363,2439.0046,2449.5063,3168.9958,3181.6282,2973.0537,3098.8113,3566.6436,2727.989,1201.6984,1285.617,1172.9238,958.3838,905.7283,761.22144,685.65985,113.894295,-757.84906,-1125.4985,-630.7881,-607.4628,-774.6304,-570.2971,-763.4679,-690.6275,-8.586986,-96.6712,235.83,1010.76263,3957.9233,3522.718,3151.076,2873.9517,2647.0999,2566.5554,2974.5303,3339.2263,3391.5398,3421.6072,3729.57,2732.9634,1505.3237,1501.7058,1196.1388,807.38336,841.4993,800.5315,530.59546,-71.67343,-1467.5983,-1861.3855,-1215.4442,-1009.16266,-1120.0365,-935.023,-908.40936,-942.50165,-757.3885,-274.28445,-92.400345,358.9073,4414.675,3948.7112,3532.9143,3333.259,3008.674,2919.211,3088.754,3605.6287,3943.3713,3341.1184,3504.6938,2038.7667,1304.511,483.33206,-1871.5778,-2255.349,-709.8091,636.80975,388.49478,-313.24277,-1646.8749,-1920.4344,-1396.1055,-1012.81445,-1180.907,-1226.7665,-1106.714,-1170.2754,-982.6243,-713.02356,-459.5769,-54.426437,4785.154,4267.406,3899.3599,3777.2573,3367.076,2893.7737,1194.9677,1284.9418,1183.5885,585.84186,741.2197,-215.5188,65.93572,-1821.3065,-3007.5632,-2512.3696,-2017.5126,-778.89435,-91.74644,-514.06116,-1015.4612,-1367.3535,-1614.1614,-1722.6073,-1426.9323,-1285.979,-1169.0189,-1051.66,-1159.612,-885.1427,-641.4536,-430.45563,4950.7856,4436.951,4136.6343,3985.821,3659.9678,-51.44719,-3474.7551,-2683.358,1580.2405,3983.9812,3177.2283,2718.224,2526.8489,1651.8451,1234.5762,-107.766594,670.4184,-1961.6346,-1916.5729,-2803.9912,-1240.2723,-1829.9923,-1766.8734,-2143.8376,-1726.8767,-1409.7067,-1377.5221,-1355.2946,-1279.0828,-1323.0111,-1044.027,-712.77014,4697.355,3623.0793,2593.1216,1422.7395,-285.96103,-1889.0344,-1453.3467,2587.1262,2953.6191,3598.5234,2797.1616,2618.561,2024.2811,221.91354,-1057.0525,-1125.208,-484.79767,-1729.0154,-3850.0376,-3793.3328,-2894.1072,-2557.67,-1838.5823,-1785.3413,-2104.114,-1565.2322,-1609.0126,-1521.9082,-1471.448,-1295.7786,-1018.00397,-1033.9602,1736.3917,2361.2654,3109.331,3228.5298,2886.2175,374.76947,-1241.294,2385.747,2548.994,1210.6273,1318.0261,2142.4238,2048.9185,1043.0416,88.164696,354.37677,933.1331,29.009563,-2417.1277,-2533.2708,-1537.9646,-3019.506,-2441.218,-1341.6077,-1918.7163,-2031.1355,-1926.7803,-1646.8085,-1425.4978,-1221.3649,-1205.068,-1165.6986,3934.4692,3440.212,3581.5176,3972.712,3885.8215,2980.6575,2037.5762,3367.2146,2525.845,1511.2014,242.48824,1612.4141,1358.7273,914.9314,771.81805,165.58473,312.18286,-467.49857,-1003.4191,-2799.7864,-1737.9192,-2628.1628,-2512.5583,-1668.981,-2015.3099,-2302.6514,-2244.6511,-1851.6858,-1725.2842,-1532.1937,-1380.2231,-1227.7656,2817.428,2377.7686,1822.4753,1268.8591,2148.3357,2402.4731,3247.3242,2611.7578,1806.448,1472.7885,878.2808,1071.8368,751.0798,852.60156,470.26056,-526.2653,-338.24432,-1202.7878,-2295.2554,-3809.8882,-2299.8506,-1908.3625,-1940.2333,-1944.7366,-2236.205,-2650.1558,-2229.0566,-1971.0515,-1847.4297,-1520.6471,-1295.803,-1245.0776],solid=False,xDimension=32,xSpacing=2.903226,yScale=50.0,zDimension=32,zSpacing=2.903226,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.03226,0.00391),(0.06452,0.00391),(0.09677,0.00391),(0.12903,0.00391),(0.16129,0.00391),(0.19355,0.00391),(0.22581,0.00391),(0.25806,0.00391),(0.29032,0.00391),(0.32258,0.00391),(0.35484,0.00391),(0.3871,0.00391),(0.41935,0.00391),(0.45161,0.00391),(0.48387,0.00391),(0.51613,0.00391),(0.54839,0.00391),(0.58065,0.00391),(0.6129,0.00391),(0.64516,0.00391),(0.67742,0.00391),(0.70968,0.00391),(0.74194,0.00391),(0.77419,0.00391),(0.80645,0.00391),(0.83871,0.00391),(0.87097,0.00391),(0.90323,0.00391),(0.93548,0.00391),(0.96774,0.00391),(0.99609,0.00391),(0.00391,0.03226),(0.03226,0.03226),(0.06452,0.03226),(0.09677,0.03226),(0.12903,0.03226),(0.16129,0.03226),(0.19355,0.03226),(0.22581,0.03226),(0.25806,0.03226),(0.29032,0.03226),(0.32258,0.03226),(0.35484,0.03226),(0.3871,0.03226),(0.41935,0.03226),(0.45161,0.03226),(0.48387,0.03226),(0.51613,0.03226),(0.54839,0.03226),(0.58065,0.03226),(0.6129,0.03226),(0.64516,0.03226),(0.67742,0.03226),(0.70968,0.03226),(0.74194,0.03226),(0.77419,0.03226),(0.80645,0.03226),(0.83871,0.03226),(0.87097,0.03226),(0.90323,0.03226),(0.93548,0.03226),(0.96774,0.03226),(0.99609,0.03226),(0.00391,0.06452),(0.03226,0.06452),(0.06452,0.06452),(0.09677,0.06452),(0.12903,0.06452),(0.16129,0.06452),(0.19355,0.06452),(0.22581,0.06452),(0.25806,0.06452),(0.29032,0.06452),(0.32258,0.06452),(0.35484,0.06452),(0.3871,0.06452),(0.41935,0.06452),(0.45161,0.06452),(0.48387,0.06452),(0.51613,0.06452),(0.54839,0.06452),(0.58065,0.06452),(0.6129,0.06452),(0.64516,0.06452),(0.67742,0.06452),(0.70968,0.06452),(0.74194,0.06452),(0.77419,0.06452),(0.80645,0.06452),(0.83871,0.06452),(0.87097,0.06452),(0.90323,0.06452),(0.93548,0.06452),(0.96774,0.06452),(0.99609,0.06452),(0.00391,0.09677),(0.03226,0.09677),(0.06452,0.09677),(0.09677,0.09677),(0.12903,0.09677),(0.16129,0.09677),(0.19355,0.09677),(0.22581,0.09677),(0.25806,0.09677),(0.29032,0.09677),(0.32258,0.09677),(0.35484,0.09677),(0.3871,0.09677),(0.41935,0.09677),(0.45161,0.09677),(0.48387,0.09677),(0.51613,0.09677),(0.54839,0.09677),(0.58065,0.09677),(0.6129,0.09677),(0.64516,0.09677),(0.67742,0.09677),(0.70968,0.09677),(0.74194,0.09677),(0.77419,0.09677),(0.80645,0.09677),(0.83871,0.09677),(0.87097,0.09677),(0.90323,0.09677),(0.93548,0.09677),(0.96774,0.09677),(0.99609,0.09677),(0.00391,0.12903),(0.03226,0.12903),(0.06452,0.12903),(0.09677,0.12903),(0.12903,0.12903),(0.16129,0.12903),(0.19355,0.12903),(0.22581,0.12903),(0.25806,0.12903),(0.29032,0.12903),(0.32258,0.12903),(0.35484,0.12903),(0.3871,0.12903),(0.41935,0.12903),(0.45161,0.12903),(0.48387,0.12903),(0.51613,0.12903),(0.54839,0.12903),(0.58065,0.12903),(0.6129,0.12903),(0.64516,0.12903),(0.67742,0.12903),(0.70968,0.12903),(0.74194,0.12903),(0.77419,0.12903),(0.80645,0.12903),(0.83871,0.12903),(0.87097,0.12903),(0.90323,0.12903),(0.93548,0.12903),(0.96774,0.12903),(0.99609,0.12903),(0.00391,0.16129),(0.03226,0.16129),(0.06452,0.16129),(0.09677,0.16129),(0.12903,0.16129),(0.16129,0.16129),(0.19355,0.16129),(0.22581,0.16129),(0.25806,0.16129),(0.29032,0.16129),(0.32258,0.16129),(0.35484,0.16129),(0.3871,0.16129),(0.41935,0.16129),(0.45161,0.16129),(0.48387,0.16129),(0.51613,0.16129),(0.54839,0.16129),(0.58065,0.16129),(0.6129,0.16129),(0.64516,0.16129),(0.67742,0.16129),(0.70968,0.16129),(0.74194,0.16129),(0.77419,0.16129),(0.80645,0.16129),(0.83871,0.16129),(0.87097,0.16129),(0.90323,0.16129),(0.93548,0.16129),(0.96774,0.16129),(0.99609,0.16129),(0.00391,0.19355),(0.03226,0.19355),(0.06452,0.19355),(0.09677,0.19355),(0.12903,0.19355),(0.16129,0.19355),(0.19355,0.19355),(0.22581,0.19355),(0.25806,0.19355),(0.29032,0.19355),(0.32258,0.19355),(0.35484,0.19355),(0.3871,0.19355),(0.41935,0.19355),(0.45161,0.19355),(0.48387,0.19355),(0.51613,0.19355),(0.54839,0.19355),(0.58065,0.19355),(0.6129,0.19355),(0.64516,0.19355),(0.67742,0.19355),(0.70968,0.19355),(0.74194,0.19355),(0.77419,0.19355),(0.80645,0.19355),(0.83871,0.19355),(0.87097,0.19355),(0.90323,0.19355),(0.93548,0.19355),(0.96774,0.19355),(0.99609,0.19355),(0.00391,0.22581),(0.03226,0.22581),(0.06452,0.22581),(0.09677,0.22581),(0.12903,0.22581),(0.16129,0.22581),(0.19355,0.22581),(0.22581,0.22581),(0.25806,0.22581),(0.29032,0.22581),(0.32258,0.22581),(0.35484,0.22581),(0.3871,0.22581),(0.41935,0.22581),(0.45161,0.22581),(0.48387,0.22581),(0.51613,0.22581),(0.54839,0.22581),(0.58065,0.22581),(0.6129,0.22581),(0.64516,0.22581),(0.67742,0.22581),(0.70968,0.22581),(0.74194,0.22581),(0.77419,0.22581),(0.80645,0.22581),(0.83871,0.22581),(0.87097,0.22581),(0.90323,0.22581),(0.93548,0.22581),(0.96774,0.22581),(0.99609,0.22581),(0.00391,0.25806),(0.03226,0.25806),(0.06452,0.25806),(0.09677,0.25806),(0.12903,0.25806),(0.16129,0.25806),(0.19355,0.25806),(0.22581,0.25806),(0.25806,0.25806),(0.29032,0.25806),(0.32258,0.25806),(0.35484,0.25806),(0.3871,0.25806),(0.41935,0.25806),(0.45161,0.25806),(0.48387,0.25806),(0.51613,0.25806),(0.54839,0.25806),(0.58065,0.25806),(0.6129,0.25806),(0.64516,0.25806),(0.67742,0.25806),(0.70968,0.25806),(0.74194,0.25806),(0.77419,0.25806),(0.80645,0.25806),(0.83871,0.25806),(0.87097,0.25806),(0.90323,0.25806),(0.93548,0.25806),(0.96774,0.25806),(0.99609,0.25806),(0.00391,0.29032),(0.03226,0.29032),(0.06452,0.29032),(0.09677,0.29032),(0.12903,0.29032),(0.16129,0.29032),(0.19355,0.29032),(0.22581,0.29032),(0.25806,0.29032),(0.29032,0.29032),(0.32258,0.29032),(0.35484,0.29032),(0.3871,0.29032),(0.41935,0.29032),(0.45161,0.29032),(0.48387,0.29032),(0.51613,0.29032),(0.54839,0.29032),(0.58065,0.29032),(0.6129,0.29032),(0.64516,0.29032),(0.67742,0.29032),(0.70968,0.29032),(0.74194,0.29032),(0.77419,0.29032),(0.80645,0.29032),(0.83871,0.29032),(0.87097,0.29032),(0.90323,0.29032),(0.93548,0.29032),(0.96774,0.29032),(0.99609,0.29032),(0.00391,0.32258),(0.03226,0.32258),(0.06452,0.32258),(0.09677,0.32258),(0.12903,0.32258),(0.16129,0.32258),(0.19355,0.32258),(0.22581,0.32258),(0.25806,0.32258),(0.29032,0.32258),(0.32258,0.32258),(0.35484,0.32258),(0.3871,0.32258),(0.41935,0.32258),(0.45161,0.32258),(0.48387,0.32258),(0.51613,0.32258),(0.54839,0.32258),(0.58065,0.32258),(0.6129,0.32258),(0.64516,0.32258),(0.67742,0.32258),(0.70968,0.32258),(0.74194,0.32258),(0.77419,0.32258),(0.80645,0.32258),(0.83871,0.32258),(0.87097,0.32258),(0.90323,0.32258),(0.93548,0.32258),(0.96774,0.32258),(0.99609,0.32258),(0.00391,0.35484),(0.03226,0.35484),(0.06452,0.35484),(0.09677,0.35484),(0.12903,0.35484),(0.16129,0.35484),(0.19355,0.35484),(0.22581,0.35484),(0.25806,0.35484),(0.29032,0.35484),(0.32258,0.35484),(0.35484,0.35484),(0.3871,0.35484),(0.41935,0.35484),(0.45161,0.35484),(0.48387,0.35484),(0.51613,0.35484),(0.54839,0.35484),(0.58065,0.35484),(0.6129,0.35484),(0.64516,0.35484),(0.67742,0.35484),(0.70968,0.35484),(0.74194,0.35484),(0.77419,0.35484),(0.80645,0.35484),(0.83871,0.35484),(0.87097,0.35484),(0.90323,0.35484),(0.93548,0.35484),(0.96774,0.35484),(0.99609,0.35484),(0.00391,0.3871),(0.03226,0.3871),(0.06452,0.3871),(0.09677,0.3871),(0.12903,0.3871),(0.16129,0.3871),(0.19355,0.3871),(0.22581,0.3871),(0.25806,0.3871),(0.29032,0.3871),(0.32258,0.3871),(0.35484,0.3871),(0.3871,0.3871),(0.41935,0.3871),(0.45161,0.3871),(0.48387,0.3871),(0.51613,0.3871),(0.54839,0.3871),(0.58065,0.3871),(0.6129,0.3871),(0.64516,0.3871),(0.67742,0.3871),(0.70968,0.3871),(0.74194,0.3871),(0.77419,0.3871),(0.80645,0.3871),(0.83871,0.3871),(0.87097,0.3871),(0.90323,0.3871),(0.93548,0.3871),(0.96774,0.3871),(0.99609,0.3871),(0.00391,0.41935),(0.03226,0.41935),(0.06452,0.41935),(0.09677,0.41935),(0.12903,0.41935),(0.16129,0.41935),(0.19355,0.41935),(0.22581,0.41935),(0.25806,0.41935),(0.29032,0.41935),(0.32258,0.41935),(0.35484,0.41935),(0.3871,0.41935),(0.41935,0.41935),(0.45161,0.41935),(0.48387,0.41935),(0.51613,0.41935),(0.54839,0.41935),(0.58065,0.41935),(0.6129,0.41935),(0.64516,0.41935),(0.67742,0.41935),(0.70968,0.41935),(0.74194,0.41935),(0.77419,0.41935),(0.80645,0.41935),(0.83871,0.41935),(0.87097,0.41935),(0.90323,0.41935),(0.93548,0.41935),(0.96774,0.41935),(0.99609,0.41935),(0.00391,0.45161),(0.03226,0.45161),(0.06452,0.45161),(0.09677,0.45161),(0.12903,0.45161),(0.16129,0.45161),(0.19355,0.45161),(0.22581,0.45161),(0.25806,0.45161),(0.29032,0.45161),(0.32258,0.45161),(0.35484,0.45161),(0.3871,0.45161),(0.41935,0.45161),(0.45161,0.45161),(0.48387,0.45161),(0.51613,0.45161),(0.54839,0.45161),(0.58065,0.45161),(0.6129,0.45161),(0.64516,0.45161),(0.67742,0.45161),(0.70968,0.45161),(0.74194,0.45161),(0.77419,0.45161),(0.80645,0.45161),(0.83871,0.45161),(0.87097,0.45161),(0.90323,0.45161),(0.93548,0.45161),(0.96774,0.45161),(0.99609,0.45161),(0.00391,0.48387),(0.03226,0.48387),(0.06452,0.48387),(0.09677,0.48387),(0.12903,0.48387),(0.16129,0.48387),(0.19355,0.48387),(0.22581,0.48387),(0.25806,0.48387),(0.29032,0.48387),(0.32258,0.48387),(0.35484,0.48387),(0.3871,0.48387),(0.41935,0.48387),(0.45161,0.48387),(0.48387,0.48387),(0.51613,0.48387),(0.54839,0.48387),(0.58065,0.48387),(0.6129,0.48387),(0.64516,0.48387),(0.67742,0.48387),(0.70968,0.48387),(0.74194,0.48387),(0.77419,0.48387),(0.80645,0.48387),(0.83871,0.48387),(0.87097,0.48387),(0.90323,0.48387),(0.93548,0.48387),(0.96774,0.48387),(0.99609,0.48387),(0.00391,0.51613),(0.03226,0.51613),(0.06452,0.51613),(0.09677,0.51613),(0.12903,0.51613),(0.16129,0.51613),(0.19355,0.51613),(0.22581,0.51613),(0.25806,0.51613),(0.29032,0.51613),(0.32258,0.51613),(0.35484,0.51613),(0.3871,0.51613),(0.41935,0.51613),(0.45161,0.51613),(0.48387,0.51613),(0.51613,0.51613),(0.54839,0.51613),(0.58065,0.51613),(0.6129,0.51613),(0.64516,0.51613),(0.67742,0.51613),(0.70968,0.51613),(0.74194,0.51613),(0.77419,0.51613),(0.80645,0.51613),(0.83871,0.51613),(0.87097,0.51613),(0.90323,0.51613),(0.93548,0.51613),(0.96774,0.51613),(0.99609,0.51613),(0.00391,0.54839),(0.03226,0.54839),(0.06452,0.54839),(0.09677,0.54839),(0.12903,0.54839),(0.16129,0.54839),(0.19355,0.54839),(0.22581,0.54839),(0.25806,0.54839),(0.29032,0.54839),(0.32258,0.54839),(0.35484,0.54839),(0.3871,0.54839),(0.41935,0.54839),(0.45161,0.54839),(0.48387,0.54839),(0.51613,0.54839),(0.54839,0.54839),(0.58065,0.54839),(0.6129,0.54839),(0.64516,0.54839),(0.67742,0.54839),(0.70968,0.54839),(0.74194,0.54839),(0.77419,0.54839),(0.80645,0.54839),(0.83871,0.54839),(0.87097,0.54839),(0.90323,0.54839),(0.93548,0.54839),(0.96774,0.54839),(0.99609,0.54839),(0.00391,0.58065),(0.03226,0.58065),(0.06452,0.58065),(0.09677,0.58065),(0.12903,0.58065),(0.16129,0.58065),(0.19355,0.58065),(0.22581,0.58065),(0.25806,0.58065),(0.29032,0.58065),(0.32258,0.58065),(0.35484,0.58065),(0.3871,0.58065),(0.41935,0.58065),(0.45161,0.58065),(0.48387,0.58065),(0.51613,0.58065),(0.54839,0.58065),(0.58065,0.58065),(0.6129,0.58065),(0.64516,0.58065),(0.67742,0.58065),(0.70968,0.58065),(0.74194,0.58065),(0.77419,0.58065),(0.80645,0.58065),(0.83871,0.58065),(0.87097,0.58065),(0.90323,0.58065),(0.93548,0.58065),(0.96774,0.58065),(0.99609,0.58065),(0.00391,0.6129),(0.03226,0.6129),(0.06452,0.6129),(0.09677,0.6129),(0.12903,0.6129),(0.16129,0.6129),(0.19355,0.6129),(0.22581,0.6129),(0.25806,0.6129),(0.29032,0.6129),(0.32258,0.6129),(0.35484,0.6129),(0.3871,0.6129),(0.41935,0.6129),(0.45161,0.6129),(0.48387,0.6129),(0.51613,0.6129),(0.54839,0.6129),(0.58065,0.6129),(0.6129,0.6129),(0.64516,0.6129),(0.67742,0.6129),(0.70968,0.6129),(0.74194,0.6129),(0.77419,0.6129),(0.80645,0.6129),(0.83871,0.6129),(0.87097,0.6129),(0.90323,0.6129),(0.93548,0.6129),(0.96774,0.6129),(0.99609,0.6129),(0.00391,0.64516),(0.03226,0.64516),(0.06452,0.64516),(0.09677,0.64516),(0.12903,0.64516),(0.16129,0.64516),(0.19355,0.64516),(0.22581,0.64516),(0.25806,0.64516),(0.29032,0.64516),(0.32258,0.64516),(0.35484,0.64516),(0.3871,0.64516),(0.41935,0.64516),(0.45161,0.64516),(0.48387,0.64516),(0.51613,0.64516),(0.54839,0.64516),(0.58065,0.64516),(0.6129,0.64516),(0.64516,0.64516),(0.67742,0.64516),(0.70968,0.64516),(0.74194,0.64516),(0.77419,0.64516),(0.80645,0.64516),(0.83871,0.64516),(0.87097,0.64516),(0.90323,0.64516),(0.93548,0.64516),(0.96774,0.64516),(0.99609,0.64516),(0.00391,0.67742),(0.03226,0.67742),(0.06452,0.67742),(0.09677,0.67742),(0.12903,0.67742),(0.16129,0.67742),(0.19355,0.67742),(0.22581,0.67742),(0.25806,0.67742),(0.29032,0.67742),(0.32258,0.67742),(0.35484,0.67742),(0.3871,0.67742),(0.41935,0.67742),(0.45161,0.67742),(0.48387,0.67742),(0.51613,0.67742),(0.54839,0.67742),(0.58065,0.67742),(0.6129,0.67742),(0.64516,0.67742),(0.67742,0.67742),(0.70968,0.67742),(0.74194,0.67742),(0.77419,0.67742),(0.80645,0.67742),(0.83871,0.67742),(0.87097,0.67742),(0.90323,0.67742),(0.93548,0.67742),(0.96774,0.67742),(0.99609,0.67742),(0.00391,0.70968),(0.03226,0.70968),(0.06452,0.70968),(0.09677,0.70968),(0.12903,0.70968),(0.16129,0.70968),(0.19355,0.70968),(0.22581,0.70968),(0.25806,0.70968),(0.29032,0.70968),(0.32258,0.70968),(0.35484,0.70968),(0.3871,0.70968),(0.41935,0.70968),(0.45161,0.70968),(0.48387,0.70968),(0.51613,0.70968),(0.54839,0.70968),(0.58065,0.70968),(0.6129,0.70968),(0.64516,0.70968),(0.67742,0.70968),(0.70968,0.70968),(0.74194,0.70968),(0.77419,0.70968),(0.80645,0.70968),(0.83871,0.70968),(0.87097,0.70968),(0.90323,0.70968),(0.93548,0.70968),(0.96774,0.70968),(0.99609,0.70968),(0.00391,0.74194),(0.03226,0.74194),(0.06452,0.74194),(0.09677,0.74194),(0.12903,0.74194),(0.16129,0.74194),(0.19355,0.74194),(0.22581,0.74194),(0.25806,0.74194),(0.29032,0.74194),(0.32258,0.74194),(0.35484,0.74194),(0.3871,0.74194),(0.41935,0.74194),(0.45161,0.74194),(0.48387,0.74194),(0.51613,0.74194),(0.54839,0.74194),(0.58065,0.74194),(0.6129,0.74194),(0.64516,0.74194),(0.67742,0.74194),(0.70968,0.74194),(0.74194,0.74194),(0.77419,0.74194),(0.80645,0.74194),(0.83871,0.74194),(0.87097,0.74194),(0.90323,0.74194),(0.93548,0.74194),(0.96774,0.74194),(0.99609,0.74194),(0.00391,0.77419),(0.03226,0.77419),(0.06452,0.77419),(0.09677,0.77419),(0.12903,0.77419),(0.16129,0.77419),(0.19355,0.77419),(0.22581,0.77419),(0.25806,0.77419),(0.29032,0.77419),(0.32258,0.77419),(0.35484,0.77419),(0.3871,0.77419),(0.41935,0.77419),(0.45161,0.77419),(0.48387,0.77419),(0.51613,0.77419),(0.54839,0.77419),(0.58065,0.77419),(0.6129,0.77419),(0.64516,0.77419),(0.67742,0.77419),(0.70968,0.77419),(0.74194,0.77419),(0.77419,0.77419),(0.80645,0.77419),(0.83871,0.77419),(0.87097,0.77419),(0.90323,0.77419),(0.93548,0.77419),(0.96774,0.77419),(0.99609,0.77419),(0.00391,0.80645),(0.03226,0.80645),(0.06452,0.80645),(0.09677,0.80645),(0.12903,0.80645),(0.16129,0.80645),(0.19355,0.80645),(0.22581,0.80645),(0.25806,0.80645),(0.29032,0.80645),(0.32258,0.80645),(0.35484,0.80645),(0.3871,0.80645),(0.41935,0.80645),(0.45161,0.80645),(0.48387,0.80645),(0.51613,0.80645),(0.54839,0.80645),(0.58065,0.80645),(0.6129,0.80645),(0.64516,0.80645),(0.67742,0.80645),(0.70968,0.80645),(0.74194,0.80645),(0.77419,0.80645),(0.80645,0.80645),(0.83871,0.80645),(0.87097,0.80645),(0.90323,0.80645),(0.93548,0.80645),(0.96774,0.80645),(0.99609,0.80645),(0.00391,0.83871),(0.03226,0.83871),(0.06452,0.83871),(0.09677,0.83871),(0.12903,0.83871),(0.16129,0.83871),(0.19355,0.83871),(0.22581,0.83871),(0.25806,0.83871),(0.29032,0.83871),(0.32258,0.83871),(0.35484,0.83871),(0.3871,0.83871),(0.41935,0.83871),(0.45161,0.83871),(0.48387,0.83871),(0.51613,0.83871),(0.54839,0.83871),(0.58065,0.83871),(0.6129,0.83871),(0.64516,0.83871),(0.67742,0.83871),(0.70968,0.83871),(0.74194,0.83871),(0.77419,0.83871),(0.80645,0.83871),(0.83871,0.83871),(0.87097,0.83871),(0.90323,0.83871),(0.93548,0.83871),(0.96774,0.83871),(0.99609,0.83871),(0.00391,0.87097),(0.03226,0.87097),(0.06452,0.87097),(0.09677,0.87097),(0.12903,0.87097),(0.16129,0.87097),(0.19355,0.87097),(0.22581,0.87097),(0.25806,0.87097),(0.29032,0.87097),(0.32258,0.87097),(0.35484,0.87097),(0.3871,0.87097),(0.41935,0.87097),(0.45161,0.87097),(0.48387,0.87097),(0.51613,0.87097),(0.54839,0.87097),(0.58065,0.87097),(0.6129,0.87097),(0.64516,0.87097),(0.67742,0.87097),(0.70968,0.87097),(0.74194,0.87097),(0.77419,0.87097),(0.80645,0.87097),(0.83871,0.87097),(0.87097,0.87097),(0.90323,0.87097),(0.93548,0.87097),(0.96774,0.87097),(0.99609,0.87097),(0.00391,0.90323),(0.03226,0.90323),(0.06452,0.90323),(0.09677,0.90323),(0.12903,0.90323),(0.16129,0.90323),(0.19355,0.90323),(0.22581,0.90323),(0.25806,0.90323),(0.29032,0.90323),(0.32258,0.90323),(0.35484,0.90323),(0.3871,0.90323),(0.41935,0.90323),(0.45161,0.90323),(0.48387,0.90323),(0.51613,0.90323),(0.54839,0.90323),(0.58065,0.90323),(0.6129,0.90323),(0.64516,0.90323),(0.67742,0.90323),(0.70968,0.90323),(0.74194,0.90323),(0.77419,0.90323),(0.80645,0.90323),(0.83871,0.90323),(0.87097,0.90323),(0.90323,0.90323),(0.93548,0.90323),(0.96774,0.90323),(0.99609,0.90323),(0.00391,0.93548),(0.03226,0.93548),(0.06452,0.93548),(0.09677,0.93548),(0.12903,0.93548),(0.16129,0.93548),(0.19355,0.93548),(0.22581,0.93548),(0.25806,0.93548),(0.29032,0.93548),(0.32258,0.93548),(0.35484,0.93548),(0.3871,0.93548),(0.41935,0.93548),(0.45161,0.93548),(0.48387,0.93548),(0.51613,0.93548),(0.54839,0.93548),(0.58065,0.93548),(0.6129,0.93548),(0.64516,0.93548),(0.67742,0.93548),(0.70968,0.93548),(0.74194,0.93548),(0.77419,0.93548),(0.80645,0.93548),(0.83871,0.93548),(0.87097,0.93548),(0.90323,0.93548),(0.93548,0.93548),(0.96774,0.93548),(0.99609,0.93548),(0.00391,0.96774),(0.03226,0.96774),(0.06452,0.96774),(0.09677,0.96774),(0.12903,0.96774),(0.16129,0.96774),(0.19355,0.96774),(0.22581,0.96774),(0.25806,0.96774),(0.29032,0.96774),(0.32258,0.96774),(0.35484,0.96774),(0.3871,0.96774),(0.41935,0.96774),(0.45161,0.96774),(0.48387,0.96774),(0.51613,0.96774),(0.54839,0.96774),(0.58065,0.96774),(0.6129,0.96774),(0.64516,0.96774),(0.67742,0.96774),(0.70968,0.96774),(0.74194,0.96774),(0.77419,0.96774),(0.80645,0.96774),(0.83871,0.96774),(0.87097,0.96774),(0.90323,0.96774),(0.93548,0.96774),(0.96774,0.96774),(0.99609,0.96774),(0.00391,0.99609),(0.03226,0.99609),(0.06452,0.99609),(0.09677,0.99609),(0.12903,0.99609),(0.16129,0.99609),(0.19355,0.99609),(0.22581,0.99609),(0.25806,0.99609),(0.29032,0.99609),(0.32258,0.99609),(0.35484,0.99609),(0.3871,0.99609),(0.41935,0.99609),(0.45161,0.99609),(0.48387,0.99609),(0.51613,0.99609),(0.54839,0.99609),(0.58065,0.99609),(0.6129,0.99609),(0.64516,0.99609),(0.67742,0.99609),(0.70968,0.99609),(0.74194,0.99609),(0.77419,0.99609),(0.80645,0.99609),(0.83871,0.99609),(0.87097,0.99609),(0.90323,0.99609),(0.93548,0.99609),(0.96774,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD006.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD006.py load and self-test diagnostics complete.")
