package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD005Index.html" target="_blank">MarsLOD005</a>,  source <a href="../../../Geospatial/MarsLOD005.java">MarsLOD005.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD005.x3d">MarsLOD005.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD005.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD005.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD005
{
	/** Default constructor to create this object. */
	public MarsLOD005 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD005.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD005.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD005.x3d"))
    .addChild(new GeoLOD().setCenter(44.911417,-134.911417,384625.000000).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars001.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars001.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,-180.000000,0.000000).setSolid(false).setXDimension(128).setXSpacing(0.708661).setYScale(50.0).setZDimension(128).setZSpacing(0.708661).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {-2372.612,-2257.7495,-2222.731,-2105.6738,-2077.1775,-2183.7402,-2369.4907,-2501.9482,-2701.095,-2838.4006,-2915.9968,-2860.105,-2851.0686,-2864.363,-2920.3157,-3048.2905,-3076.9617,-3101.5154,-3073.1274,-2961.5183,-3826.9534,-3860.8093,-2688.4546,-2486.4094,-2053.1763,-1926.9927,-2008.9464,-1549.6079,-1179.6763,-901.48334,-482.48456,-246.5073,-629.81866,-1452.1686,-2583.9565,-3061.8577,-2829.7178,-2860.8286,-3129.8306,-3044.1472,-2975.5483,-2798.364,-2270.78,-1783.2025,-1967.9045,-2167.1929,-2143.6455,-2035.407,-1970.4082,-1992.4601,-1746.6901,-1192.696,-776.6941,-557.39197,-734.33575,-882.6015,-839.2351,-608.0659,-382.63745,-358.14645,-277.1715,-157.93437,100.84979,452.60773,783.946,1053.4713,1238.2081,1532.4409,1747.58,1958.3231,2144.7285,2365.8538,2541.9053,2706.331,2985.6748,3268.1086,3553.1252,3830.9539,4083.4075,4298.281,4436.289,4574.5884,4737.4546,4905.0854,5157.357,5471.1323,5849.472,6118.055,6216.5254,6524.2944,7163.962,8784.316,11542.163,13321.463,12827.345,12446.641,9904.798,7239.416,5861.6216,5782.927};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {5743.839,5687.0806,5647.2686,5596.234,5546.952,5499.268,5393.9194,5288.14,5184.605,5103.3477,5027.145,4926.884,4730.502,4568.554,4400.1606,4266.437,4156.758,4051.1099,3982.0366,3912.4463,3829.527,3730.6626,3617.257,3476.4243,3373.441,3268.253,3150.3838,2997.4866,-2409.108,-2322.22,-2184.1284,-2295.2224,-2259.4995,-2354.9734,-2496.3718,-2552.8767,-2738.7388,-2873.0815,-2914.9385,-2844.2466,-2774.5515,-2783.796,-2889.5803,-3101.84,-3120.5286,-3079.3237,-3067.9485,-2988.6404,-3522.0237,-3406.1438,-2592.6072,-2465.4768,-2323.799,-2338.4934,-1953.8097,-1573.121,-1218.1471,-836.40533,-585.01733,-842.46515,-1380.3848,-1387.3365,-2516.359,-2814.3284,-2548.5615,-3055.1826,-3169.989,-2963.6787,-2950.2217,-2872.8525,-2386.884,-2433.9182,-2550.4417,-2291.8726,-2184.5486,-2147.7822,-2044.1371,-1931.451,-1467.6414,-780.8343,-389.1471,-744.2889,-1206.1084,-1099.8134,-1018.88824,-616.48193,-732.0785,-843.7114,-560.5136,-298.9743,116.066345,535.0696,950.09937,1211.3242,1344.9922,1640.4155,1828.9979,2010.2329,2034.9058,2142.5369};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2315.9666,2522.9248,2857.8586,3189.2983,3484.6875,3786.0686,4117.8726,4296.623,4416.648,4519.0957,4624.0884,4699.9688,4859.5083,5036.817,5345.493,5622.874,5704.634,5878.6147,6354.4546,8844.82,11976.142,13216.13,11545.733,12208.669,11272.233,8556.818,6073.254,5692.6187,5606.401,5564.2,5546.1484,5535.656,5504.9204,5490.307,5391.4375,5263.0806,5152.821,5042.278,4941.1445,4796.801,4641.553,4507.074,4367.2417,4240.908,4142.1836,4054.8064,3962.528,3883.8855,3812.6096,3702.4998,3576.714,3432.2495,3324.1667,3219.9636,3081.7078,2902.6816,-2639.3662,-2592.48,-2506.819,-2584.2278,-2756.7158,-2789.255,-2741.908,-2757.6296,-2834.2913,-2935.6262,-2860.5278,-2822.7551,-2800.2715,-2810.619,-2961.0159,-3136.4683,-3091.6687,-3091.4097,-3026.1172,-3017.6804,-2915.2585,-2873.3826,-2841.2112,-2772.1477,-2607.484,-2224.6074,-1980.1517,-1708.1226,-1342.1409,-959.3986,-1079.8947,-1483.4508,-1696.9009,-2182.307,-2845.446,-2619.7188,-2858.9146,-3176.877,-3174.4976,-3046.366,-2862.364,-2976.9216,-2785.065,-2750.5635};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {-2614.2888,-2362.692,-2238.1384,-2121.4214,-2029.5123,-1743.0813,-963.85425,-284.60574,-407.59375,-1314.2814,-1454.373,-1269.7755,-1098.6431,-1008.3092,-1195.1274,-1115.8424,-770.5917,-312.0806,274.28055,722.67395,1038.3944,1306.406,1495.5504,1897.6981,2082.862,2154.0288,1961.4657,1950.4271,2114.08,2353.1423,2656.129,2988.389,3259.8733,3931.3262,4787.5137,4599.251,4369.7446,4444.8936,4516.9463,4564.6997,4674.856,4811.044,4996.9365,5137.3887,5123.923,5232.066,5677.0425,7699.06,10728.84,12933.725,12664.161,12432.434,11602.205,8935.171,6145.471,5572.3335,5506.3535,5496.779,5532.2715,5544.201,5489.292,5431.405,5372.8745,5250.273,5131.6177,5029.3228,4925.0674,4765.2686,4597.748,4459.853,4345.2837,4228.718,4114.4844,4018.4287,3947.0925,3878.4707,3811.2483,3724.3987,3559.8994,3386.2068,3206.5146,3082.513,2911.7815,2737.8196,-2979.6772,-2973.4543,-3028.423,-2884.4663,-2932.3198,-2853.2488,-2804.2097,-2888.7495,-2987.7754,-3026.7126,-2849.8792,-2819.186,-2974.205,-3111.9688,-3190.0488,-3203.5715};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-3149.9524,-3122.7595,-3079.4866,-3058.7317,-3007.3438,-2978.5564,-2977.5635,-2849.9802,-2389.1194,-2005.5765,-1889.3365,-1631.0566,-1392.6963,-1262.0067,-1527.6068,-1812.0205,-1688.9059,-2499.2659,-2852.5786,-2877.553,-3137.1536,-3224.689,-3218.0403,-3024.4038,-2977.683,-3144.429,-2886.126,-2775.371,-2700.888,-2564.424,-2480.0632,-2201.9114,-1938.4615,-1285.0118,-608.3003,26.912188,-1140.0171,-1620.0797,-1582.1288,-1475.9196,-1324.4269,-1368.0577,-1300.7407,-944.4657,-465.318,-12.571486,429.59076,750.72034,1062.4896,1365.0862,1667.3368,2094.9758,2305.3687,2283.3755,1967.5946,1690.6334,1934.2592,2060.148,2479.3433,2753.3174,3262.8062,5003.5967,5421.6226,4869.3374,4359.3926,4583.136,4765.9116,4483.3184,4511.168,4528.315,4589.9844,4648.4697,4640.463,4645.0513,4754.342,6314.386,9008.688,11455.153,11967.25,11716.051,10263.628,7807.6865,5750.673,5449.3193,5427.5273,5457.8237,5552.9507,5648.5854,5593.861,5473.6177,5372.218,5249.388,5106.567,4971.692,4891.662,4746.041,4541.193,4394.4355,4312.7773,4208.0625};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {4100.2954,3987.359,3913.7986,3865.22,3824.6575,3795.7695,3638.437,3379.2825,3128.4414,2935.6104,2780.8926,2612.9883,-3044.0662,-3043.0652,-2955.205,-2873.0303,-2910.2827,-2698.7893,-2861.9324,-3068.4778,-3105.7124,-2938.2664,-3020.5264,-3025.3582,-3186.3813,-3220.4348,-3216.5679,-3246.364,-3209.8545,-3176.57,-3127.8667,-3053.3245,-3039.3672,-3058.7852,-3007.8582,-2809.6565,-2267.7053,-2072.867,-1959.833,-1769.6647,-1652.5485,-1738.5436,-2074.74,-1928.2177,-1879.8342,-2740.3179,-2959.386,-3069.8345,-3160.0488,-3205.8015,-3218.515,-3037.358,-3126.0647,-3132.3088,-2937.0483,-2823.2024,-2742.2505,-2670.9385,-2619.2239,-2349.3247,-1544.0963,-903.3387,-324.08316,-397.17017,-1791.77,-1785.4043,-1726.453,-1655.342,-1443.3721,-1394.762,-1171.7389,-625.61304,-99.16165,281.88116,534.32776,816.7713,1133.5823,1432.2412,1928.5957,2280.8823,2353.2307,2181.5935,1774.1617,1524.8806,1642.4343,1661.7798,2314.8647,2508.095,3242.0813,4958.724,6050.432,5073.931,4259.4673,4654.3237,3987.8857,4436.5938,4391.465,4355.831,4316.6714,4321.2734};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {4211.458,4056.2927,3946.7654,4969.634,6677.436,8349.212,9109.845,8966.747,7630.446,6333.1533,5513.253,5354.423,5375.9473,5452.028,5594.384,5759.167,5737.5635,5587.892,5426.178,5274.1245,5084.967,4918.9604,4778.938,4625.392,4444.164,4304.93,4219.75,4120.361,4048.4167,3953.3765,3860.7314,3821.0361,3838.366,3970.577,3869.6057,3500.873,3091.7947,2812.4065,2629.0198,2503.6812,-3044.1887,-3019.4153,-3005.9836,-2856.0537,-2744.8357,-2990.1294,-3127.3289,-3182.2178,-3062.2734,-2967.7222,-3160.1416,-3241.6313,-3263.1682,-3248.9722,-3225.832,-3250.0852,-3235.7515,-3206.7654,-3184.5718,-3140.9404,-3113.3604,-3095.8162,-3067.5005,-2865.0078,-2380.5173,-2299.8726,-2148.8643,-2072.9019,-2013.502,-1998.3965,-2029.5973,-2001.1978,-2192.6582,-2936.8748,-3135.3164,-3147.966,-3210.5486,-3263.1145,-3203.3567,-3134.3254,-3193.0327,-3182.0835,-3012.3608,-2878.294,-2770.622,-2707.6855,-2560.1946,-1883.5221,-1194.4192,-630.71497,-565.51917,-1821.6475,-1939.4459,-1826.3256,-1724.1964,-1655.8694,-1562.9199,-1375.6362,-879.83496,-289.5144};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {222.02335,573.0784,781.82385,1078.8816,1315.0095,1617.2322,2137.4539,2341.0012,2273.2007,1880.3628,1533.6136,1203.8483,1353.8015,1646.4386,2101.4739,2283.6223,2786.0925,3768.1753,4284.1772,4220.9175,4193.748,4331.8394,4279.905,4317.178,4305.4395,4219.172,4143.1084,4071.3708,3927.52,3704.8928,3482.5732,3797.6675,4578.329,5308.168,5770.3013,5766.913,5703.958,5574.0454,5301.8867,5261.4717,5322.338,5476.6235,5668.342,5861.3765,5918.9487,5730.0728,5547.4746,5333.1504,5072.981,4857.3696,4687.632,4526.1206,4360.248,4204.07,4104.6094,4035.7505,3992.789,3912.649,3835.426,3782.4333,3792.4185,4002.698,4015.3994,3644.2517,3145.987,2714.3752,2482.4824,2316.4448,-2991.9175,-3025.5078,-2949.4043,-2917.6238,-3093.662,-3077.5552,-3147.5303,-3181.474,-2831.313,-2972.5334,-3146.9812,-3260.288,-3275.8638,-3251.202,-3208.416,-3239.738,-3229.3137,-3212.8457,-3205.0051,-3157.2388,-3161.7432,-3131.8315,-3129.5417,-3041.3145,-2670.729,-2491.2175,-2397.805,-2337.686,-2283.2388,-2161.9192,-2133.8567,-2073.4988};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {-2279.5461,-2906.2798,-3204.366,-3197.4988,-3266.418,-3283.4348,-3256.5408,-3245.791,-3237.3293,-3224.2485,-3105.805,-2940.8098,-2820.984,-2711.7888,-2164.1274,-1523.8042,-992.67413,-609.76984,-1496.0831,-2143.3845,-2041.3501,-1963.5599,-1778.1886,-1761.5707,-1658.0432,-1258.4122,-628.3827,-58.16579,417.6058,663.4712,1098.2067,1411.8628,1626.1044,1965.5951,2213.5862,2141.796,1951.9462,1508.9706,1444.9694,1261.3156,1383.7872,1587.5538,1881.4955,2134.9976,2597.641,3206.2427,3777.1055,4080.1648,4222.537,4225.6855,4265.862,4311.493,4244.7036,4132.007,4029.89,3907.4065,3749.8916,3490.8293,3224.1023,3356.113,3407.8525,3526.6917,3767.212,4087.4192,4464.6294,4894.9854,5040.8276,5174.0234,5325.968,5533.248,5764.482,5981.418,6121.4087,5919.9873,5644.5283,5359.0254,5069.8247,4816.8965,4626.7827,4466.8555,4295.038,4139.825,4012.7969,3934.426,3885.7766,3851.179,3783.5557,3734.1729,3714.327,3905.6887,4067.5898,3723.3137,3231.6016,2676.8013,2386.2332,2154.692,-2998.8875,-2864.2502,-2996.8774,-3060.973};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-2977.786,-2986.014,-3282.1348,-3225.6177,-3092.8115,-3168.9421,-3281.1567,-3251.6687,-3233.56,-3233.1887,-3250.034,-3250.9102,-3215.2139,-3218.0884,-3227.2603,-3169.5784,-3186.2112,-3154.464,-3145.057,-3090.9836,-2951.5432,-2688.9036,-2628.1416,-2532.0332,-2454.5833,-2290.947,-2202.3374,-2235.9705,-2450.871,-3000.7434,-3227.6855,-3256.9465,-3298.783,-3314.9702,-3295.0315,-3288.0603,-3287.024,-3287.9983,-3179.602,-3072.4187,-2891.9744,-2518.9343,-1842.174,-1390.7483,-1031.8862,-1205.1962,-2105.2883,-2145.8508,-2108.677,-1992.7014,-1938.866,-1841.8407,-1641.323,-980.39703,-417.86884,190.79813,621.5304,779.18097,1134.7338,1397.2511,1572.3251,1752.193,1804.2747,1698.5105,1464.2909,1246.1913,1278.7979,1234.4686,1300.3491,1418.9852,1537.8408,1966.111,2401.2512,3002.1116,3610.583,4184.0107,4286.4917,4305.975,4331.343,4326.7686,4234.747,4128.584,3986.4895,3829.3198,3646.1497,3391.0015,3145.3665,3364.3428,3500.607,3583.168,3645.2246,3910.791,4243.308,4647.151,4865.7666,5047.26,5235.82,5518.86,5841.1885,6109.819};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {6272.2944,6131.7163,5770.877,5328.219,4939.901,4672.021,4488.6675,4346.6733,4198.3247,4068.1938,3951.146,3857.8967,3792.089,3768.281,3722.7224,3674.5383,3655.064,3746.9763,3990.3596,3725.7156,3171.4673,2572.167,2200.4897,1924.4976,-2977.174,-2932.4148,-3024.8616,-3102.1252,-2947.1152,-2831.2864,-3129.4187,-3056.624,-3116.3855,-3203.1072,-3209.177,-3204.9475,-3261.814,-3266.2107,-3291.9138,-3291.8096,-3212.915,-3239.2957,-3228.9763,-3189.8171,-3206.908,-3182.2275,-3168.483,-3159.2,-3161.474,-2887.6672,-2723.3818,-2617.463,-2555.8052,-2382.7683,-2311.5305,-2414.983,-2841.3328,-3129.8774,-3270.5962,-3292.3962,-3328.931,-3336.569,-3320.9263,-3346.115,-3346.448,-3334.402,-3267.3357,-3148.613,-2772.2454,-2228.4285,-1765.159,-1463.8187,-1413.4443,-2193.6604,-2365.264,-2362.4133,-2263.1934,-2180.6892,-2109.3276,-1954.555,-1474.2463,-959.50824,-491.8374,204.55986,550.4184,737.2533,979.6729,1093.1656,1138.6654,1220.301,1253.2324,1174.0594,1016.2149,1054.2921,1166.9044,1107.3259,1021.0686,1071.9711,1288.3357,1843.1057};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {2250.963,2741.011,3870.6543,4518.307,4440.177,4384.6406,4395.224,4349.098,4267.9956,4124.4985,3976.7876,3771.543,3589.3638,3298.355,3102.9802,3244.2983,3176.6985,3203.968,3518.2048,3787.4358,4105.9844,4450.4873,4663.2705,4862.2153,5118.7627,5601.601,6039.0474,6369.289,6492.0415,6330.583,5863.4756,5233.862,4775.354,4519.0615,4336.843,4203.4795,4083.5007,3984.6567,3899.474,3790.878,3726.6658,3670.289,3638.494,3632.832,3610.599,3595.8186,3771.33,3528.9778,2996.1758,2392.9895,1891.6451,1655.4645,-2930.6301,-3100.4087,-3129.0012,-3112.721,-3038.1833,-3008.6145,-3097.0786,-3001.977,-3066.1323,-3188.4092,-3177.6326,-3244.0762,-3251.4512,-3270.0276,-3287.651,-3256.3284,-3219.4563,-3265.6155,-3229.0398,-3199.7754,-3242.527,-3197.3582,-3111.2559,-3159.9656,-3217.1326,-3035.5586,-2804.5378,-2677.2485,-2629.0354,-2476.4426,-2437.9475,-2671.3647,-3172.6697,-3270.852,-3315.1797,-3327.7412,-3355.9285,-3361.475,-3358.8018,-3386.3523,-3380.7388,-3349.1294,-3353.768,-3097.6133,-2499.8093,-2087.5447,-1787.4847,-1707.0376};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {-2128.7034,-2588.7754,-2572.0144,-2475.2944,-2413.4778,-2313.7148,-2187.9749,-1912.5865,-1331.5574,-811.53986,-190.42204,320.45792,610.637,574.9644,570.47345,592.14087,614.801,696.23114,819.3744,818.2016,814.9604,891.5655,1064.2559,883.4888,692.644,950.08325,1323.0413,1778.2036,2036.245,2547.72,4194.515,4646.542,4568.565,4483.103,4462.0786,4405.923,4314.482,4141.316,3988.8147,3747.043,3471.272,3175.4094,2983.922,3012.0173,3061.6106,3213.9492,3370.6238,3568.1326,3918.6812,4223.176,4434.0894,4658.9897,5146.994,5855.952,6471.602,6852.6255,6849.563,6571.753,5874.203,5080.138,4555.697,4344.724,4223.7153,4066.2244,3962.9597,3880.1475,3814.7231,3732.187,3649.287,3612.9675,3562.6094,3561.6665,3555.9163,3468.6077,3451.9778,3172.5925,2660.679,2114.3943,1764.6405,1646.676,-3027.18,-3116.7175,-3125.1455,-3088.7566,-3023.7085,-3164.2244,-3108.8528,-3107.6033,-3154.468,-3173.5115,-3148.2666,-3256.4587,-3259.9207,-3270.144,-3277.6436,-3209.3823,-3259.292,-3282.8645,-3236.8098,-3241.5215};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {-3251.0652,-3223.0786,-3185.3909,-3194.3586,-3260.3772,-3061.7854,-2832.438,-2709.5312,-2615.9385,-2502.002,-2466.662,-2919.3853,-3275.2104,-3299.7224,-3336.2795,-3364.7283,-3385.1992,-3396.9016,-3397.4578,-3408.467,-3394.439,-3384.269,-3357.6445,-2954.9146,-2432.649,-2111.811,-1965.2914,-2123.8513,-2583.4033,-2686.9187,-2701.975,-2546.4114,-2336.5088,-2095.1333,-1953.8424,-1589.7225,-952.5042,-450.84998,-43.846176,219.92043,228.17558,103.39827,93.79563,130.19148,210.37418,344.18695,466.00922,565.87427,674.36084,768.2596,853.78436,744.25256,630.3068,776.329,1208.5911,1592.408,1820.4222,2471.643,4290.584,4599.7646,4654.115,4583.3696,4556.0347,4475.6147,4378.98,4184.4395,3972.8684,3675.6428,3277.5781,2965.2515,2928.9634,2955.403,3016.3254,3104.2603,3238.0664,3387.0637,3658.1614,3938.013,4169.751,4499.7676,5117.847,6033.3975,6843.35,7395.649,7396.505,7067.277,6168.8247,5111.3345,4352.1294,4116.2744,4031.326,3949.771,3876.5945,3780.6157,3690.0757,3624.3237,3573.3545,3516.88,3477.194,3438.1704};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {3414.0325,3355.6602,3226.4377,2842.036,2330.93,1999.2992,1813.2355,1674.5748,-3149.961,-3083.6267,-3058.389,-2997.772,-2927.872,-3101.175,-3138.2205,-3235.1406,-3234.4497,-3180.429,-3102.998,-3216.1033,-3271.746,-3275.0242,-3248.581,-3251.7065,-3240.7505,-3270.6638,-3254.238,-3279.4495,-3247.3374,-3226.0662,-3238.2126,-3289.6194,-3274.139,-3050.562,-2886.6042,-2731.822,-2608.289,-2524.768,-2488.4788,-3043.8965,-3277.3394,-3323.1394,-3373.7708,-3387.9404,-3399.634,-3423.4895,-3426.0615,-3414.944,-3391.7922,-3376.4348,-3349.4558,-2858.2617,-2467.2148,-2247.11,-2271.3438,-2516.5576,-2754.359,-2762.401,-2686.0044,-2447.5876,-2299.4395,-2051.817,-1633.4083,-1232.0421,-901.78735,-636.1612,-327.2744,-220.27934,-234.90808,-245.78362,-259.48672,-170.15282,-58.443798,26.562744,117.61036,367.7541,486.45334,581.28046,643.4279,663.7188,711.1252,647.7996,935.6692,1255.4908,1608.6555,2495.6028,4366.0977,4347.5674,4612.6187,4659.1685,4636.5723,4629.4976,4523.0986,4222.9756,3909.6445,3499.2607,2971.6692,2863.5784,2867.8257,2876.9685};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {2918.3887,3064.9177,3072.341,3303.1606,3431.2734,3643.6936,3911.8708,4394.134,5169.7983,6124.122,7212.7944,7894.3237,8011.25,7611.1978,6712.6006,5462.193,4253.1865,3945.8801,3860.324,3804.7886,3761.6555,3691.3293,3615.3674,3546.6475,3482.1177,3407.6477,3379.712,3342.6787,3268.567,3216.9587,3046.0508,2710.2341,2361.094,2054.7598,1834.4744,1662.5554,-3112.5227,-3131.1587,-3094.1187,-2991.2202,-3008.2,-3175.357,-3018.3152,-3091.5964,-3163.9292,-3101.5623,-3181.567,-3284.049,-3466.813,-3262.8179,-3264.4648,-3255.4353,-3252.2773,-3286.6467,-3277.9622,-3293.3403,-3239.0908,-3241.8987,-3287.243,-3316.1948,-3242.8389,-3056.4377,-2925.4497,-2782.1497,-2661.252,-2605.6882,-2693.1345,-3103.3525,-3284.9666,-3347.7031,-3411.2234,-3429.299,-3439.5928,-3447.5452,-3444.6895,-3430.3477,-3397.4338,-3352.9207,-3260.7961,-2853.63,-2592.5225,-2454.396,-2534.3936,-2889.984,-2883.2205,-2824.379,-2740.7896,-2493.3906,-2315.4023,-1935.6152,-1393.4701,-1308.52,-1191.4341,-987.65356,-778.211,-637.4468,-536.22974,-563.0795,-559.16406,-408.76108};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {-318.79608,-190.05247,-96.62852,-40.312218,62.195225,301.24973,516.19135,613.4057,612.2577,747.7462,769.45593,1005.2373,1466.8,2455.9329,3978.4263,4134.355,4482.2104,4509.454,4576.574,4585.4097,4447.5327,4122.956,3620.5166,3071.8127,2786.7708,2787.875,2778.3794,2806.7202,2793.4697,2791.9583,1942.873,2973.9778,3127.0605,3287.5159,3586.5825,4164.679,5094.1636,6127.899,7417.3784,8452.546,8715.491,8560.447,7581.196,5863.7373,4329.2954,3857.864,3773.125,3716.9165,3678.5217,3640.0024,3563.4329,3491.082,3426.0244,3342.7043,3276.2156,3236.4595,3157.8386,3037.8364,2853.1128,2582.5269,2332.1377,2079.8076,1870.8121,1693.8298,-3098.4077,-3123.2947,-3092.4502,-3043.5254,-3469.5571,-3138.2668,-2990.271,-3015.9456,-3145.9854,-3175.4478,-3196.021,-3298.2844,-3281.3015,-3292.468,-3291.6296,-3264.23,-3276.643,-3291.4336,-3292.7603,-3297.6484,-3270.7097,-3276.3062,-3348.7004,-3342.6328,-3220.2454,-3081.4841,-2992.1038,-2869.3572,-2767.101,-2725.4893,-2953.4272,-3252.688,-3365.1025,-3370.2954,-3451.1157,-3464.0938};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {-3477.4727,-3462.119,-3449.0847,-3435.1768,-3396.4849,-3352.6448,-3167.4192,-2931.2603,-2744.7585,-2663.9326,-2747.3079,-2966.8674,-2978.9067,-2856.3638,-2698.7878,-2525.405,-2257.9214,-1753.1207,-1462.8811,-1409.1854,-1270.1821,-1140.7357,-992.27985,-869.7001,-814.28265,-767.0897,-725.17224,-597.6636,-484.70444,-332.72433,-193.05495,-96.653275,12.969385,166.13217,320.4435,464.41354,622.3921,832.7258,910.4758,935.5191,1450.4104,2422.825,3401.3691,3935.0867,3980.3643,3901.3354,3977.6,4036.26,3926.5654,3454.221,2989.7876,2729.86,2694.681,2697.4355,2712.6013,2724.0967,2692.1885,2703.7068,2660.2542,2852.583,2837.1191,2959.615,3283.0066,3790.4727,4579.053,5676.059,7164.352,8868.132,9936.169,10596.518,10190.08,8214.538,5530.617,3927.4072,3632.5015,3610.3708,3574.403,3554.4128,3520.6248,3453.393,3372.724,3276.467,3178.751,3113.619,3024.452,2892.3452,2740.3188,2537.9246,2315.1157,2096.03,1891.8579,1724.5981,-3142.168,-3144.6943,-3150.8513,-3105.6091,-3153.5708,-3005.6123,-3046.4192,-3070.1704};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {-3157.8894,-3265.514,-3251.3445,-3295.7822,-3311.7598,-3303.0845,-3288.446,-3295.2048,-3287.8057,-3281.284,-3279.5125,-3336.0093,-3310.0251,-3336.843,-3396.7937,-3391.6597,-3248.3992,-3141.3845,-3066.5183,-2957.455,-2900.74,-2934.652,-3160.576,-3333.0972,-3446.1438,-3439.603,-3492.1658,-3500.3003,-3497.6753,-3565.4893,-3610.0962,-3425.1785,-3406.833,-3374.3823,-3232.7295,-3018.7437,-2895.9014,-2830.6748,-2913.4724,-2950.1978,-2951.6523,-2921.1863,-2815.5635,-2528.2239,-2184.6682,-1772.168,-1604.1172,-1484.8878,-1365.1985,-1232.4313,-1140.1136,-1111.8147,-1047.3868,-921.5532,-806.98175,-691.62775,-537.3688,-379.6006,-234.69693,-91.86983,18.418253,142.86171,243.77655,377.07986,625.9085,852.96893,1092.872,1124.6566,1544.5558,2371.848,3083.746,3339.2322,3113.2175,2792.9949,2770.1155,2807.5369,2838.4822,2534.2507,2646.8215,2614.343,2629.033,2637.4238,2643.0024,2622.8936,2610.6353,2626.4568,2649.2651,2619.9006,2612.0508,2716.8748,2924.523,3284.5032,3851.568,4871.2485,6615.215,9620.372,11905.8545,13350.121,13520.64,12108.44};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {8539.073,5193.776,3573.9177,3521.3125,3499.264,3466.8455,3434.9805,3377.5193,3305.4404,3221.0432,3117.8965,3014.906,2918.9338,2784.3726,2653.9421,2478.2688,2287.683,2123.3083,1920.5249,1726.4202,-3164.742,-3167.3533,-3164.6414,-3148.4824,-3186.5554,-3006.0596,-3159.6523,-3073.0986,-3182.0554,-3205.6658,-3268.5994,-3326.7046,-3341.5723,-3323.1206,-3324.8079,-3317.9485,-3314.8726,-3475.5913,-3319.0635,-3385.2976,-3358.913,-3407.766,-3455.6284,-3448.676,-3360.5308,-3284.8494,-3225.1187,-3099.108,-3076.5137,-3204.356,-3360.03,-3461.484,-3508.1199,-3489.6084,-3524.3875,-3521.4265,-3508.7869,-3530.5906,-3528.0803,-3448.3254,-3425.5334,-3421.5022,-3348.1372,-3188.397,-3024.201,-3012.5552,-2979.714,-3019.1724,-3001.5918,-2988.5203,-2802.7458,-2517.2563,-2214.9905,-1864.2046,-1688.2704,-1571.6671,-1445.436,-1366.683,-1313.8451,-1248.8966,-1137.6251,-1010.94476,-870.96936,-711.2706,-552.5443,-394.36545,-235.6373,-87.3245,49.61608,168.04938,279.9016,411.4099,584.8599,842.4644,1103.1143,1318.235,1580.6158,2285.0303,2858.6921,2933.547};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {2758.1428,2625.552,2517.2798,2517.4202,2533.2974,2544.449,2544.476,2543.5227,2559.8767,2546.9707,2539.0276,2535.5142,2517.0999,2524.546,2532.4636,2462.1074,2447.289,2457.1694,2459.033,2567.2915,2938.0461,3644.5132,6082.88,10676.948,14257.114,16314.209,16280.562,15630.098,11782.395,7113.869,4170.8467,3548.7493,3484.7637,3442.5754,3380.7874,3312.26,3233.2354,3151.818,3063.3203,2950.7102,2845.7078,2710.5112,2572.7065,2402.3706,2251.9158,2097.9924,1928.3024,1721.9276,-3169.321,-3187.5613,-3191.9766,-3188.2368,-3169.5813,-3071.3083,-3000.9536,-2916.3726,-3016.9272,-3163.2668,-3235.7546,-3321.1465,-3363.0474,-3329.4595,-3354.8965,-3362.8027,-3361.9783,-3361.2869,-3378.0767,-3414.6375,-3380.4775,-3433.3438,-3476.0923,-3480.9817,-3466.4553,-3436.7861,-3404.2385,-3259.0615,-3297.707,-3458.9663,-3526.4968,-3571.1965,-3559.213,-3539.4297,-3560.3303,-3526.5122,-3530.467,-3505.4668,-3487.2834,-3455.8088,-3444.9558,-3441.3494,-3419.377,-3281.2505,-3174.0544,-3074.445,-3071.5706,-3082.965,-3003.8516,-3022.0132,-2722.3948,-2466.778};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {-2217.4226,-1888.6155,-1711.4576,-1622.0005,-1536.201,-1470.6255,-1400.2233,-1303.9413,-1198.5398,-1068.5481,-890.2621,-731.5335,-563.73694,-410.45273,-241.16435,-65.231445,105.86186,236.8919,337.7922,452.28305,606.98846,803.9005,1017.57495,1417.3002,1547.741,2174.2603,2603.6086,2706.641,2682.4622,2569.909,2432.3513,2451.9983,2467.7039,2476.845,2479.5051,2470.773,2484.7273,2467.9517,2451.9294,2445.0874,2433.7227,2445.9775,2414.0527,2340.0237,2313.853,2249.6702,2119.8782,2086.2148,1997.853,2324.252,5498.7427,11038.636,15677.577,17691.19,16282.491,16905.092,13386.246,8483.874,4911.075,3687.682,3559.89,3457.681,3353.4177,3276.5552,3175.1262,3070.537,2980.9087,2893.8237,2775.154,2663.2388,2530.2727,2399.163,2290.4065,2119.2832,1914.6615,1735.4725,-3178.496,-3176.5176,-3183.3425,-3202.2795,-3308.777,-2996.8208,-2976.6108,-4763.7856,-3929.107,-3064.6396,-3271.4048,-3310.0168,-3368.3574,-3342.0955,-3371.1348,-3350.4927,-3359.7358,-3391.5103,-3398.656,-3433.7048,-3429.139,-3443.6897,-3484.5957,-3497.8389};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {-3498.03,-3487.6448,-3512.888,-3398.8333,-3457.7817,-3535.7783,-3567.1262,-3588.0847,-3589.0352,-3574.921,-3585.259,-3559.3315,-3554.45,-3534.2507,-3515.9453,-3481.582,-3477.68,-3445.0925,-3408.4294,-3345.714,-3267.9912,-3217.324,-3139.5059,-3104.572,-3065.1257,-2894.8252,-2518.1492,-2254.0254,-2080.3489,-1869.4633,-1729.567,-1657.2249,-1625.039,-1548.5992,-1456.1084,-1356.0613,-1235.7279,-1105.4662,-934.1579,-763.4873,-605.8934,-435.73508,-271.55377,-82.297104,109.66769,280.01416,408.5689,525.9091,658.94885,803.5759,964.0756,1239.3347,1372.1476,1943.7471,2392.391,2511.3523,2538.2761,2473.6196,2382.1387,2390.8633,2411.5532,2417.8127,2433.4165,2430.2756,2421.8215,2409.8774,2404.3901,2395.163,2384.8486,2385.3933,2354.84,2255.6865,2197.9717,2114.906,1987.2736,1844.764,1607.0729,1690.568,4109.5195,9480.413,14624.077,17392.477,17629.7,16402.58,12878.081,8693.638,5353.437,3913.2856,3676.3254,3541.5107,3421.763,3271.5981,3122.9473,2996.6108,2867.4922,2771.65,2671.3167,2580.3254,2468.9163,2364.229};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {2269.7454,2283.616,2393.2502,1690.8671,-3107.5317,-3155.3936,-3177.1323,-3218.1426,-3188.4336,-2995.6152,-2758.066,-3864.4583,-3470.1792,-2992.081,-3263.1162,-3317.1506,-3330.6648,-3278.1362,-3297.2407,-3303.8323,-3339.75,-3407.393,-3418.865,-3450.7039,-3445.7134,-3435.9482,-3485.559,-3499.17,-3522.64,-3508.5034,-3537.608,-3513.4858,-3536.2683,-3555.8533,-3595.186,-3606.378,-3616.7566,-3596.2625,-3594.9827,-3599.235,-3574.9622,-3564.6736,-3534.179,-3516.0652,-3502.1929,-3460.0354,-3417.0857,-3365.4163,-3314.2095,-3264.1838,-3172.5283,-3160.14,-3055.7021,-2735.9841,-2350.9238,-1832.741,-1795.0422,-1797.3711,-1724.843,-1662.3527,-1665.548,-1598.0111,-1349.2017,-1195.6719,-1183.0059,-1088.3682,-941.5996,-791.7004,-648.57416,-469.42337,-270.2402,-91.5783,104.29152,297.72717,453.32736,577.23926,702.45306,862.32196,980.35175,1127.8412,1238.5875,1697.028,2150.3809,2291.1147,2386.9111,2388.863,2303.5635,2299.2444,2347.5493,2371.4192,2379.4895,2386.7915,2381.3418,2378.3618,2395.936,2368.929,2332.2983,2313.3047,2293.808,2218.0537};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {2122.5125,2028.4896,1949.3563,1798.2717,1616.0063,1464.7388,2365.1982,6465.3105,11118.222,14348.102,15011.767,14139.448,11132.76,7909.412,5544.1533,4254.2393,3851.841,3642.1506,3473.336,3252.2507,3048.3682,2905.2551,2776.7305,2642.5837,2560.9978,2469.4167,2382.0703,2306.9897,2505.1387,4704.4463,4100.374,1468.8304,-3004.645,-3138.4253,-3156.7664,-3230.3872,-3207.9995,-3090.6487,-2808.285,-2904.7864,-3004.0312,-3109.3105,-3288.5425,-3344.808,-3325.9111,-3285.7131,-3183.0042,-3380.4563,-3457.2478,-3359.4355,-3445.5774,-3496.5886,-3483.3574,-3475.0623,-3490.8582,-3526.8818,-3535.0251,-3543.9983,-3549.2996,-3586.3826,-3600.3342,-3584.3914,-3618.6658,-3629.0117,-3635.2905,-3623.0173,-3619.0781,-3610.9084,-3592.7095,-3569.6306,-3558.6619,-3560.4438,-3521.7966,-3476.7795,-3441.4604,-3410.4453,-3365.4744,-3304.5652,-3294.3987,-3140.6301,-2864.7952,-2459.6365,-2123.601,-1883.9109,-1710.1464,-1725.1647,-1709.0369,-1590.7571,-1625.5951,-1325.5626,-897.4073,-727.9107,-499.73795,-235.40002,-46.030373,89.53937,-51.616055,-73.009926,-42.742218,-0.583033};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {134.94485,303.63248,477.7163,614.4829,739.21747,903.40405,1035.023,1144.2319,1239.8241,1449.8228,1771.3788,2021.8276,2173.5703,2248.1736,2215.9543,2232.0742,2287.8752,2328.6797,2350.7185,2350.351,2338.7322,2353.9316,2341.5212,2310.173,2285.233,2251.586,2226.3333,2189.9253,2086.4087,1982.3295,1920.3275,1830.7432,1696.8531,1563.9019,1578.0656,3597.2375,6779.638,9438.43,10619.023,10363.326,8789.549,6986.7515,5568.822,4678.5547,4111.122,3783.9312,3518.0432,3232.2588,2976.6997,2782.3757,2651.5986,2536.1719,2444.6267,2357.6243,2280.5283,2244.8047,4807.198,4980.6523,3215.0334,1202.9438,-2865.928,-3072.1047,-3157.5784,-3236.533,-3233.699,-3171.1477,-3101.4722,-3098.7517,-3232.674,-3298.1572,-3316.6572,-3347.844,-3333.8394,-3263.824,-3214.4644,-3292.1985,-3402.7527,-3397.1274,-3472.91,-3501.1355,-3524.098,-3524.883,-3514.7764,-3549.5322,-3570.257,-3586.4731,-3593.6204,-3634.9824,-3662.6104,-3619.2878,-3648.2397,-3659.5186,-3667.2556,-3661.9473,-3643.1165,-3658.2278,-3629.938,-3600.3828,-3602.7085,-3584.9478};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-3555.7075,-3543.6174,-3491.3176,-3426.051,-3373.7136,-3290.015,-3205.4639,-2947.0544,-2618.62,-2268.8538,-2000.1354,-1871.6661,-1798.4115,-1618.4266,-1640.5209,-1618.6008,-1459.8539,-944.0408,-416.98648,109.499855,849.0521,1557.4111,2250.0608,3091.042,3664.6401,3452.009,2910.3625,2404.1016,1713.8329,451.30438,487.32483,663.1768,795.2913,959.64215,1070.6193,1177.2544,1272.6046,1296.5077,1390.0588,1690.8914,1983.445,2137.7969,2165.864,2188.7969,2206.6826,2258.31,2296.3503,2310.9858,2318.4565,2324.2185,2298.9155,2249.9739,2252.865,2211.8794,2175.7366,2152.8628,2085.3145,1997.0476,1903.3042,1822.093,1735.5521,1659.7435,1599.8228,2092.2297,3661.4785,5273.016,6534.343,7237.27,6912.1055,6211.547,5509.7544,4773.0674,4176.354,3750.0864,3450.1821,3159.5747,2908.0596,2718.344,2491.2812,2441.9348,2348.5095,2261.8806,2172.2607,2144.7908,3626.9902,3850.6838,2106.921,1052.7129,-2696.1208,-2840.7234,-3123.91,-3243.8035,-3259.7622,-3200.7217,-3221.9658,-3246.2986,-3295.592,-3361.2336,-3352.3638,-3368.4565};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {-3393.2034,-3327.0654,-3331.917,-3295.172,-3399.014,-3435.1938,-3490.2502,-3531.9348,-3564.9434,-3560.9055,-3569.713,-3578.7798,-3599.4285,-3611.6797,-3626.2168,-3631.626,-3645.6375,-3657.992,-3685.517,-3706.8926,-3715.2073,-3690.6426,-3677.8083,-3691.6038,-3651.3662,-3649.6272,-3664.18,-3641.4355,-3623.1436,-3614.9265,-3535.0254,-3460.1855,-3363.8433,-3124.4805,-2907.6624,-2730.6646,-2551.9587,-2285.905,-2103.7175,-2055.6733,-1928.965,-1794.6511,-1484.1127,-1599.0319,-1338.753,-638.44794,332.18787,1448.3483,2626.1462,4607.2227,6030.914,7261.651,7913.6406,7621.438,6917.404,6172.1445,5301.1245,2660.078,560.44916,673.1755,843.07214,1016.34216,1123.8407,1199.927,1263.1631,1230.374,1225.1853,1405.6678,1807.8523,2053.3926,2123.8118,2136.6821,2125.2769,2183.589,2222.0627,2245.9226,2276.0967,2284.5793,2273.6921,2246.585,2231.9531,2190.805,2153.9768,2109.0781,2096.4788,2028.8165,1937.4612,1870.9103,1862.7892,1785.0215,1751.4341,1862.8236,2286.0667,3226.864,4340.4175,5204.2437,5487.5615,5415.2676,5153.582,4681.322};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {4092.4375,3628.5002,3365.9841,3116.3782,2872.6963,2668.3777,2491.0063,2351.229,2272.014,2218.1335,2115.6665,2000.298,1842.5475,1638.5631,1342.1174,1078.8284,-2993.2576,-3716.2524,-3086.5798,-3241.3293,-3263.1443,-3270.949,-3281.2898,-3289.067,-3340.9172,-3395.8335,-3389.1672,-3379.4094,-3420.9153,-3388.9358,-3316.2644,-3258.2415,-3394.5427,-3463.4753,-3491.6003,-3511.2512,-3547.465,-3555.5437,-3600.708,-3606.151,-3610.847,-3627.2737,-3643.8894,-3653.0261,-3670.6504,-3692.0806,-3722.8528,-3743.3057,-3729.8562,-3717.65,-3722.0352,-3728.596,-3701.3047,-3689.9648,-3700.7988,-3687.8135,-3703.3806,-3690.0945,-3565.0188,-3336.1333,-3025.138,-2910.6196,-2758.5708,-2542.1265,-2371.748,-2306.6248,-2333.01,-1835.9409,-1681.7894,-1623.3086,-1753.6859,-1623.2843,-1265.8939,-210.82799,1855.7533,3840.9595,6330.0996,8401.513,9996.156,11102.257,11544.921,11607.109,10686.991,9081.145,7464.6694,5805.7485,2342.1948,671.35016,867.26215,1061.5951,1153.0101,1217.6908,1253.3397,1206.6425,1163.5494,1247.3662,1625.6614,1929.9603,2009.9987,1958.6041};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {1981.6204,2037.8295,2124.6892,2188.5312,2246.7522,2262.7373,2249.4521,2235.0476,2214.7515,2181.0427,2141.393,2101.0112,2061.5542,2013.2555,1935.523,1890.9822,1873.7089,1830.6727,1812.822,1850.7454,1943.0912,2423.7805,3348.7437,4164.186,4570.997,4781.713,4706.5117,4428.202,3938.7102,3472.5679,3217.955,3032.3577,2828.5684,2624.4255,2469.857,2333.386,2211.0603,2124.6116,2043.3672,1924.2549,1785.6565,1565.6357,1304.3615,1050.6538,-3024.8613,-3146.6086,-3212.341,-3288.822,-3291.6328,-3294.565,-3309.7407,-3360.438,-3391.3982,-3432.9368,-3424.8496,-3375.2744,-3391.2405,-3376.1821,-3373.1138,-3315.693,-3451.4514,-3437.208,-3487.2012,-3503.2356,-3534.7383,-3538.5752,-3623.9854,-3627.3462,-3608.3655,-3647.41,-3660.0486,-3675.1897,-3691.4731,-3710.917,-3741.4229,-3757.2703,-3737.5215,-3733.509,-3742.2998,-3755.6062,-3735.4177,-3715.9119,-3720.4368,-3727.2202,-3758.928,-3752.6528,-3523.9414,-3088.327,-2901.577,-2709.2322,-2770.0,-2593.1338,-2389.6704,-2284.2974,-2081.519,-2012.8435,-1913.097,-1901.308,-1930.4692,-1672.7523};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {-1355.9932,555.23505,4004.2695,6359.66,8365.356,10220.475,12353.925,14432.107,15533.0205,15831.031,14997.063,12760.673,10023.518,7831.6655,5327.097,1086.0287,900.26917,1065.1927,1276.6813,1423.0858,1280.1858,1123.3849,1065.0104,1051.2803,1248.4678,1907.6788,2035.0872,1727.4767,1805.286,1943.8566,2051.5195,2151.692,2190.689,2213.1108,2222.0247,2212.577,2192.952,2174.074,2148.4375,2108.1714,2067.953,2017.4215,1951.1338,1915.3534,1898.4907,1877.9799,1864.3231,1849.341,1902.7539,2204.715,2978.4622,3673.157,3992.0044,4132.3477,4150.1865,3926.747,3546.1265,3215.1267,3014.0605,2884.3376,2726.218,2607.328,2465.0178,2309.1196,2179.797,2084.7285,1987.7537,1854.6128,1705.1002,1510.2954,1282.8013,1009.5625,-3148.827,-3207.408,-3293.576,-3306.0447,-3439.5708,-3312.7378,-3351.8335,-3388.927,-3427.2666,-3439.5134,-3397.5137,-3163.1228,-3143.4187,-3198.4375,-3423.6208,-3448.3735,-3467.542,-3434.4219,-3497.405,-3503.884,-3523.1267,-3536.6946,-3615.0244,-3643.2324,-3641.172,-3658.8735,-3665.1707,-3679.6213};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {-3702.0105,-3727.6829,-3745.1025,-3760.854,-3750.6328,-3749.0916,-3767.0034,-3773.728,-3770.1594,-3740.3987,-3742.2869,-3749.919,-3782.7622,-3775.1382,-3494.6387,-3073.1035,-2867.3887,-2656.4263,-2602.6353,-2567.565,-2556.5103,-2238.2192,-2127.069,-2076.2886,-2150.0115,-2278.197,-2091.5833,-1728.7994,-1386.734,1338.4828,5644.0767,7609.5293,9414.6,11678.598,14239.676,16902.463,19214.055,19758.453,19116.416,16317.466,12446.427,9407.606,6852.0815,2800.5205,854.8788,1045.1211,1192.0975,1325.9236,1383.189,1114.666,932.6895,927.2133,944.83997,1479.1632,1667.253,1487.8378,1664.8147,1833.8441,1984.3757,2088.5273,2158.4553,2183.3408,2210.631,2217.2368,2189.175,2174.2974,2147.1616,2118.016,2084.0693,2039.3722,1985.5712,1940.5891,1917.8766,1907.0315,1896.4141,1880.7715,1914.3987,2100.5498,2686.8826,3167.3804,3343.6113,3411.51,3493.024,3361.5134,3092.5645,2914.3384,2805.0422,2733.5298,2629.3296,2533.5789,2427.7424,2302.4014,2191.9023,2104.224,2010.4158,1874.4906,1689.8278,1531.5393,1308.5751,1027.0281};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {-3120.831,-3227.2395,-3289.3677,-3313.2034,-3327.487,-3347.0173,-3373.5115,-3411.7349,-3426.61,-3393.3743,-3179.6895,-3041.6746,-3090.3425,-3736.0747,-3442.1206,-3437.129,-3452.7163,-3438.277,-3452.5757,-3510.3982,-3514.658,-3526.8372,-3609.123,-3650.765,-3659.6458,-3668.2551,-3683.607,-3680.4382,-3700.7039,-3730.1523,-3755.674,-3768.2964,-3769.9058,-3767.8538,-3791.1145,-3792.477,-3792.9915,-3767.7744,-3767.8582,-3784.526,-3808.7996,-3783.0522,-3525.1353,-3057.726,-2797.67,-2660.4417,-2557.262,-2466.5564,-2381.1418,-2158.5598,-2274.4807,-2429.5242,-2424.912,-2401.478,-2131.0312,-1623.1117,-879.9948,2009.0999,5938.799,7978.684,9881.036,12228.573,14967.894,18047.521,20189.86,20312.059,20688.977,18300.258,13907.264,10613.308,7854.35,3147.6199,785.9381,957.4884,1080.691,1322.5399,1544.46,1056.4681,783.94214,799.85223,810.9376,904.12384,1067.5737,1305.2573,1526.2141,1728.4288,1897.6553,2101.442,2223.902,2231.0798,2222.7402,2267.2708,2244.8896,2241.125,2217.3916,2164.9973,2093.1907,2071.939,2041.3378,1980.6112};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {1928.3147,1913.4557,1904.828,1882.9194,1895.8035,2005.5242,2321.3533,2611.046,2820.8208,2986.1787,3045.907,2926.602,2773.223,2673.973,2623.0745,2585.965,2537.7776,2456.9253,2385.982,2286.7236,2207.6335,2082.2947,2025.2112,1900.4218,1769.7112,1613.5695,1391.3563,1143.6511,-3683.5107,-3563.3525,-3305.9954,-3317.9697,-3342.3525,-3367.5112,-3409.6194,-3427.9355,-3400.267,-3446.591,-3390.2617,-3317.873,-3219.3381,-3809.2878,-3470.5762,-3422.4968,-3431.9785,-3416.7285,-3440.0903,-3505.8074,-3527.247,-3554.5283,-3588.0986,-3659.5256,-3676.925,-3683.3977,-3692.891,-3696.9148,-3713.5938,-3740.638,-3767.9158,-3778.846,-3778.7646,-3793.6013,-3814.7102,-3810.5178,-3809.9973,-3786.407,-3791.3218,-3812.5457,-3825.517,-3811.1716,-3527.3125,-3116.6294,-2826.4402,-2663.1414,-2610.5413,-2427.1616,-2354.6514,-2281.483,-2145.4585,-1532.2906,-1503.9279,-1894.0729,-1867.0281,-1705.1195,-907.1726,1252.7023,5474.3306,8005.666,10044.589,12194.265,15093.263,18337.355,19622.252,18362.615,19820.82,18709.596,14729.833,10882.937,7319.3438,3067.0845};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {993.01227,870.92017,972.0839,1216.041,1314.9856,844.535,649.21295,673.6293,700.34985,755.0329,869.9872,1112.9572,1357.4697,1562.4453,1809.5753,2148.9204,2542.3884,2212.1926,2235.9092,2311.7686,2361.799,2290.7783,2302.0015,2399.7434,2225.7139,2142.581,2085.387,2008.5381,1951.3308,1922.4142,1906.519,1875.1489,1867.2252,1926.5122,2051.798,2252.624,2527.9055,2725.5452,2738.8384,2680.4214,2606.5532,2523.4604,2486.9023,2459.6348,2435.887,2383.9578,2344.0796,2258.4355,2188.6182,2094.8794,2035.6946,1950.1959,1837.8501,1684.8069,1481.7515,1248.4307,-3231.9478,-3303.7815,-3315.623,-3347.6118,-3372.6187,-3379.7427,-3431.2188,-3447.2476,-3426.0227,-3479.5476,-3487.8035,-3504.3,-3453.0608,-3470.6367,-3455.354,-3427.0151,-3421.7375,-3441.141,-3424.558,-3486.5159,-3552.7332,-3589.7156,-3620.7234,-3687.2842,-3693.3193,-3700.832,-3720.4092,-3733.2139,-3744.915,-3771.9634,-3801.4846,-3807.0547,-3801.4783,-3820.7556,-3825.7834,-3824.8516,-3826.215,-3814.9968,-3811.286,-3823.722,-3840.0315,-3819.5383,-3340.0762,-3135.6177};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {-2876.4185,-2731.6755,-2570.2864,-2442.5537,-2351.2166,-1915.8258,-1300.269,-1271.5433,-1555.5096,-1808.6423,-1915.6982,-1966.3962,-1430.4955,127.448204,5239.2046,7897.298,9462.471,11560.573,14203.732,16869.47,18634.924,18703.162,18729.496,17144.416,13695.18,9959.834,6324.3687,3138.2412,1380.1931,779.92426,828.19073,945.64594,904.0264,567.2085,521.5217,557.6821,605.96014,651.9213,725.29095,945.60693,1207.7422,1431.7838,1702.3098,1917.6029,2028.0273,2105.7249,2200.12,2331.2961,2363.0125,2346.1318,2375.3096,2530.9946,2503.3418,2300.2397,2226.816,2111.6177,2006.4071,1943.4614,1886.4535,1836.2778,1832.2665,1879.1779,1948.353,2137.9075,2377.2622,2473.5432,2516.0405,2495.6025,2428.0737,2432.0918,2389.7622,2376.0476,2338.376,2308.2058,2287.5024,2243.8792,2179.9626,2104.0898,2030.091,1948.1553,1847.6792,1704.6674,1536.9785,1333.6667,-3321.6445,-3317.4514,-3338.1052,-3346.6438,-3393.8816,-3403.6768,-3443.299,-3462.6294,-3475.5178,-3499.5957,-3504.412,-3561.8594,-3553.6387,-3511.0813,-3527.3723,-3493.9197};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-3383.481,-3452.0334,-3480.6707,-3491.8276,-3562.0618,-3606.8374,-3642.8552,-3686.3735,-3700.476,-3725.3608,-3749.3208,-3769.2075,-3777.879,-3813.393,-3831.1743,-3831.3113,-3826.703,-3848.3157,-3841.769,-3835.813,-3838.8706,-3850.4617,-3833.3438,-3838.5015,-3846.2334,-3745.2683,-3270.5056,-3115.954,-2837.2092,-2746.546,-2535.2466,-2393.1375,-1820.7133,-1133.521,-1068.501,-1245.8643,-1364.2426,-1820.6965,-2057.73,-2038.9146,-1620.2753,-79.46398,5667.2793,7508.282,8710.152,10357.4,12439.989,14296.631,15415.918,15904.444,15751.238,14377.249,11936.57,8643.666,5431.609,2832.4065,1316.0298,656.78345,638.3248,589.62134,416.97974,402.6194,418.20047,473.32465,521.0975,597.5807,687.13525,865.0861,1084.6444,1300.8431,1494.9006,1743.9314,1918.9698,2041.2167,2193.3381,2332.4597,2422.8723,2463.6062,2548.6084,2581.584,2528.9429,2507.1116,2484.8547,2394.0488,2147.8655,1991.4056,1897.6836,1839.3395,1825.2181,1857.2875,1919.9435,2058.9722,2228.9907,2306.3928,2354.9346,2368.285,2334.0994,2346.1343,2322.051,2306.6975};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {2271.8364,2240.7566,2220.1653,2208.4517,2157.3154,2086.6104,2011.3464,1944.7964,1840.1604,1695.0588,1531.7957,1349.3899,-3335.7258,-3312.7808,-3360.0457,-3374.387,-3411.333,-3424.2805,-3423.4375,-3534.4949,-3503.0671,-3519.4578,-3546.21,-3606.1284,-3613.9685,-3576.375,-3595.163,-3527.5234,-3462.9736,-3516.561,-3580.9512,-3578.6895,-3624.5466,-3608.2397,-3662.104,-3713.8608,-3730.9778,-3752.4263,-3760.2432,-3786.8054,-3808.6245,-3825.0837,-3851.5913,-3844.5857,-3844.1648,-3865.3562,-3859.3228,-3851.0688,-3853.3643,-3852.6445,-3841.3394,-3847.705,-3849.4163,-3653.7644,-3307.746,-3169.7876,-2895.9482,-2730.0532,-2410.9883,-1937.7205,-1574.0079,-1123.3698,-1158.0757,-1132.024,-1377.5057,-1597.0181,-2140.7266,-2161.7668,-1875.914,-557.406,4376.151,7085.971,7907.1074,9171.039,10372.159,11728.201,12119.473,12261.245,12336.967,11583.015,9939.6875,7418.122,4326.402,2135.65,936.34357,418.82303,390.4341,348.4756,278.45837,311.16754,361.98373,382.0309,479.36664,586.4608,690.62,853.11743,1022.8061,1187.5676,1404.7031,1663.7207};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {1830.6189,2005.6837,2196.5603,2348.4426,2445.8958,2502.8608,2550.495,2559.9595,2631.017,2695.0613,2687.099,2682.9922,2487.5056,2112.594,1937.0883,1865.2203,1841.2186,1880.315,1887.1252,2011.2482,2135.9377,2192.4155,2252.835,2274.787,2280.404,2274.6753,2278.34,2256.0178,2228.6665,2207.1357,2184.75,2151.6711,2130.2078,2068.672,2021.6713,1950.7946,1849.0474,1715.7437,1547.5973,1351.8738,-3353.316,-3346.425,-3374.4822,-3368.3057,-3423.768,-3456.1863,-3412.8438,-3928.416,-3578.911,-3539.9104,-3578.821,-3615.716,-3636.8684,-3632.3743,-3630.4575,-3591.5334,-3627.7295,-3620.6604,-3642.5786,-3672.4058,-3684.3772,-3644.9556,-3707.149,-3797.05,-3814.0107,-3783.4443,-3792.6333,-3805.6067,-3831.5154,-3847.6775,-3866.643,-3855.63,-3856.8572,-3875.7593,-3871.6555,-3867.3079,-3868.6377,-3868.7393,-3858.9993,-3855.2563,-3856.288,-3593.944,-3305.235,-3104.8157,-2962.8213,-2783.4622,-2156.1343,-1963.8578,-1625.2971,-1485.4113,-1319.1868,-1296.0917,-1355.1671,-1426.4248,-1993.7462,-2203.1897,-1937.5737,-1450.1499,1767.9203,6242.6367};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {6858.1904,7880.52,8552.027,9444.256,10003.35,10169.367,10134.6045,9354.374,7927.6484,6192.2085,2859.9614,1105.5037,357.63638,141.73048,130.96596,149.35109,165.07698,218.034,292.34076,290.10043,422.2854,540.39075,650.20294,811.38544,992.82715,1182.4928,1356.7657,1564.2104,1793.5006,2003.9857,2191.1646,2331.751,2438.2625,2533.3928,2583.3132,2636.7532,2706.5708,2770.7537,2817.7832,2847.0134,2652.5068,2232.8813,1976.6917,1870.5934,1858.293,1903.2422,1911.5078,1965.0367,2064.999,2124.0476,2170.2502,2200.9712,2231.977,2222.2234,2230.076,2237.667,2211.7834,2182.143,2173.051,2107.9153,2123.2734,2071.4358,2013.1918,1938.2272,1856.9547,1734.7391,1557.3389,1336.817,-3314.3213,-3369.6394,-3378.9722,-3408.7163,-3480.4998,-3532.05,-3507.3513,-3414.2922,-3546.1138,-3559.699,-3597.5735,-3620.3481,-3639.8877,-3626.1304,-3664.1233,-3629.3508,-3653.642,-3717.237,-3738.087,-3779.7698,-3744.1138,-3665.817,-3780.8706,-3829.764,-3839.8372,-3819.068,-3804.6794,-3826.0938,-3850.2908,-3863.307,-3868.2905,-3870.329};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {-3869.9277,-3878.6636,-3874.8782,-3872.5598,-3872.9087,-3870.3477,-3868.917,-3869.0173,-3819.9788,-3397.4587,-3214.0662,-3105.0881,-2971.0142,-2802.1174,-2343.5977,-2101.2976,-1750.207,-1726.0408,-1865.3623,-1855.8622,-1593.8927,-1644.8182,-1800.5719,-2306.4285,-2164.7483,-2003.1001,-1560.6749,3688.9949,6258.5015,6950.9697,7401.649,7774.3384,8518.027,8769.45,8891.453,7386.027,5391.706,2468.9844,686.2084,78.013176,-130.74825,-42.487114,-64.32699,-7.274217,67.475266,110.22053,150.16855,251.57712,376.18164,495.7955,651.06244,839.73676,999.0566,1177.688,1368.0295,1551.3451,1729.9741,1910.328,2128.795,2302.742,2450.9524,2552.5725,2608.8877,2720.1675,2773.3079,2815.7476,2893.6404,2944.9072,2738.2224,2340.4856,2019.3344,1876.9307,1863.6355,1896.0789,1906.9379,1923.1678,2012.0786,2079.606,2141.8848,2158.8743,2202.031,2210.27,2251.657,1823.9247,2225.7405,2190.0845,2170.347,2136.8445,2097.477,2050.156,2000.261,1932.7616,1856.2635,1732.5587,1519.8754,1261.1891,-3391.5042,-3421.236,-3424.4348,-3427.457};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_42()
		{
			double[] value = {-3460.9026,-3470.9092,-3542.4258,-3570.4927,-3582.7393,-3587.4016,-3600.6182,-3634.7534,-3650.1475,-3674.1375,-3702.5918,-3717.956,-3758.782,-3770.9094,-3767.7732,-3800.1067,-3807.4966,-3774.6165,-3817.622,-3832.0508,-3835.8215,-3834.1292,-3837.1343,-3846.673,-3869.0007,-3881.1348,-3880.0178,-3876.3735,-3875.8655,-3879.2212,-3878.4692,-3876.8584,-3875.7415,-3866.9297,-3846.511,-3866.7234,-3781.873,-3351.4094,-3207.0447,-3180.8564,-3061.2383,-2721.1292,-2286.9023,-1942.3613,-1743.4017,-1696.4584,-1799.7737,-1957.2253,-2077.329,-2112.6587,-2133.6335,-2344.3403,-2322.7056,-2207.1448,-1933.4182,-361.05533,4657.381,6092.2925,6046.3115,6459.8228,7275.3774,7564.0815,6293.056,4308.5513,2090.864,679.5808,-154.3639,-538.8507,-536.7608,-350.03165,-178.60658,-88.83398,-23.880816,27.41327,105.1226,218.19087,333.873,490.7674,707.8543,912.4725,1093.1216,1251.3344,1423.9199,1589.1416,1752.0964,1908.961,2089.1265,2249.224,2429.6519,2568.1328,2686.232,2788.1914,2843.4614,2886.408,2940.3313,2991.1965,2847.5706,2441.7073,2143.9553,1911.7054};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_43()
		{
			double[] value = {1869.5161,1874.4573,1883.7567,1839.94,1976.7773,2048.0405,2137.6006,2174.8333,2211.3484,2206.0762,2248.637,2131.1633,2223.552,2217.18,2189.1885,2150.4458,2078.323,2016.7238,1965.8247,1914.097,1852.1072,1837.7395,1631.1113,1191.9167,-3457.822,-3477.9185,-3430.43,-3436.5964,-3468.1812,-3337.509,-3444.1438,-3555.4526,-3589.1868,-3592.4937,-3608.21,-3632.398,-3660.8145,-3685.9988,-3709.3318,-3737.63,-3763.568,-3778.3184,-3787.0671,-3797.9583,-3816.543,-3811.3699,-3827.7676,-3836.4297,-3836.994,-3836.3953,-3859.9321,-3872.4624,-3877.7598,-3879.1992,-3879.4082,-3880.0576,-3880.964,-3882.7493,-3882.697,-3879.2485,-3876.4583,-3867.2805,-4004.4485,-3841.8572,-3737.8135,-3377.5225,-3196.7979,-3227.9468,-3192.1,-2763.151,-2311.4246,-1793.8708,-1535.6211,-1572.6165,-1740.2307,-1825.0414,-1914.2018,-2060.5142,-2255.1848,-2385.2974,-2399.3179,-2350.6782,-2279.656,-2161.9763,63.40877,631.1121,421.47205,870.04236,2510.9602,2549.565,746.9264,721.8202,384.07672,-242.09625,-714.08734,-828.59186,-692.7792,-406.7553,-182.44283,-144.21838};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_44()
		{
			double[] value = {-87.343605,-11.143254,63.14391,166.28494,346.24652,620.68994,828.3914,1010.3419,1179.393,1358.8455,1515.0846,1642.1841,1812.9459,1957.5043,2099.7156,2261.3416,2402.0132,2563.0667,2708.3596,2822.9758,2910.0203,2955.642,3017.1655,3091.512,3122.348,2796.0283,2584.611,2168.7314,1927.9165,1865.3375,1860.9415,1820.4078,1937.1814,2045.2983,2147.5134,2192.4622,2214.1062,2139.8801,2216.1035,2379.3643,3141.7734,2967.9136,2224.2344,2157.0796,2078.4478,2022.6943,1950.4681,1830.7754,1835.1084,1931.4988,1751.9512,1205.3966,-3471.0671,-3486.73,-3873.6848,-3652.4084,-3489.0415,-3362.749,-3505.2798,-3595.4424,-3601.1692,-3622.4468,-3552.4878,-3581.5269,-3657.2642,-3704.931,-3724.6558,-3746.3809,-3767.7944,-3795.4092,-3808.9248,-3813.7996,-3806.5408,-3803.172,-3825.0688,-3832.6584,-3834.9927,-3839.6436,-3863.3594,-3875.0078,-3881.7854,-3880.4395,-3882.3381,-3885.312,-3885.941,-3885.6152,-3883.307,-3878.7217,-3876.113,-3863.612,-3847.1973,-3858.9531,-3731.89,-3324.0593,-3220.6982,-3244.776,-3150.9685,-2661.5054,-2203.4597,-1769.3328};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_45()
		{
			double[] value = {-1458.0236,-1706.3982,-1822.6023,-1777.3904,-1737.0815,-1715.029,-1902.7098,-2266.644,-2397.2773,-2415.7947,-2439.5374,-2464.1792,-2345.3013,-1933.461,-1893.5421,-1811.3959,-1687.5247,-1753.5935,-1770.2719,-1235.8911,-1034.367,-1010.15894,-1020.33344,-943.6261,-762.842,-328.69098,-77.29852,-182.74843,-124.07924,-61.347412,2.58948,172.84859,462.44827,719.3931,903.443,1120.9333,1297.3461,1457.8163,1602.2607,1746.4624,1902.4594,2049.6213,2155.9468,2314.2341,2446.2107,2574.1924,2708.4346,2867.902,2974.9326,3035.5967,3068.8137,3200.2488,3324.5823,3048.622,3077.5254,2661.8826,2232.3684,1880.453,1849.5594,1820.0588,1937.1998,2049.7012,2175.9731,2234.7341,2219.5698,2097.6567,2211.1287,3784.7964,6280.0503,6057.784,2517.8352,2148.7659,2080.1243,2006.2087,1950.9471,1873.8746,1792.7618,1813.7877,1664.0635,1228.5299,-3484.0142,-3521.9424,-3719.4927,-3572.6807,-3465.0073,-3411.0374,-3538.8298,-3647.8987,-3635.1575,-3631.1182,-3663.046,-3706.2412,-3709.162,-3724.2673,-3742.4407,-3779.1497,-3796.2556,-3805.136,-3812.0728,-3815.6147};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_46()
		{
			double[] value = {-3816.4092,-3818.3687,-3822.2925,-3831.5962,-3833.7222,-3850.2222,-3869.9539,-3879.19,-3882.8481,-3883.0388,-3881.0852,-3881.1187,-3881.9329,-3880.1035,-3876.814,-3874.3708,-3873.992,-3872.6018,-3868.8804,-3871.6353,-3802.5786,-3377.8853,-3272.0361,-3261.4143,-2946.1228,-2464.3208,-2099.136,-1918.361,-1594.0326,-1816.7935,-1922.0177,-1824.4825,-1779.9161,-1640.0056,-1604.7532,-1867.0289,-2317.322,-2393.2212,-2418.5051,-2402.7983,-2133.5818,-1939.4391,-1973.6631,-2050.3418,-2112.9326,-2086.662,-1958.5568,-1585.3268,-1353.8125,-1305.8608,-1162.9563,-1018.6726,-753.25323,87.589066,121.72925,-211.01161,-166.56558,-108.46699,-4.707891,282.23184,575.62164,814.0649,1026.9545,1198.6464,1374.3958,1553.6456,1675.0444,1775.6976,1934.5856,2097.9282,2244.1074,2373.2615,2470.96,2612.4275,2775.8555,2964.9277,3036.3784,3089.026,3115.862,3305.586,3553.6074,3254.5195,3378.4507,3026.0146,2526.924,1931.4906,1815.6364,1840.8632,1880.2941,2074.4424,2183.4053,2248.8545,2211.2986,2075.0027,2157.591,2839.504,3780.7148,3443.3213,2228.1074,2122.2441};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_47()
		{
			double[] value = {2073.8108,2107.664,2242.814,2024.215,1809.4229,1659.1993,1506.5919,1212.3619,-3518.197,-3538.5364,-3560.2432,-3552.4795,-3542.4817,-3467.2576,-3541.1602,-3666.6396,-3598.213,-3608.5996,-3706.6152,-3767.7112,-3754.9905,-3752.2917,-3756.522,-3794.4573,-3825.042,-3821.3115,-3826.039,-3826.9072,-3828.0386,-3837.7056,-3836.1804,-3835.219,-3836.2278,-3855.1729,-3870.404,-3878.6914,-3880.541,-3877.8125,-3876.848,-3874.294,-3872.2927,-3869.5032,-3866.769,-3864.8645,-3862.0342,-3863.0757,-3864.456,-3867.1333,-3866.8416,-3578.6858,-3370.4314,-3306.602,-2896.6902,-2434.19,-2028.7173,-1905.0212,-2018.3164,-2026.2174,-2046.3402,-1977.4604,-1857.6724,-1781.6063,-1720.0885,-1756.6915,-1936.998,-2340.9653,-2386.7786,-2266.9436,-1791.5178,-2267.9216,-2192.1343,-2081.6384,-2112.2305,-1883.8287,-1778.2562,-1478.9491,-1485.1334,-1340.7338,-1136.5225,-828.1825,-487.2377,225.88287,-52.435272,-304.95392,-143.1225,45.397896,133.51671,414.50058,673.61487,889.5819,1066.6742,1246.854,1464.593,1641.6118,1756.7988,1845.466,1929.0973,2129.0706,2292.7478,2437.895};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_48()
		{
			double[] value = {2563.2515,2719.2263,2857.2397,3008.3364,3083.7078,3187.3071,3231.0908,3405.243,3661.548,3471.8242,3506.627,3203.7678,2590.655,1915.8033,1749.1823,1773.9128,1892.3036,2090.216,2226.8872,2238.4678,2175.217,2018.5961,2070.555,2104.6577,2085.9438,2083.2065,2072.936,2043.707,2111.816,3169.7715,3740.096,3018.5515,2096.906,1583.8674,1432.5972,1133.1484,-3545.7344,-3557.6345,-3594.5662,-3580.943,-3597.6938,-3576.7341,-3607.9585,-3558.3047,-3586.9558,-3653.4355,-3777.1572,-3775.703,-3766.4197,-3779.5144,-3780.82,-3800.2998,-3817.8367,-3843.5535,-3856.1619,-3867.2146,-3852.6895,-3857.088,-3852.6797,-3845.1587,-3847.7341,-3861.862,-3869.1052,-3878.865,-3881.595,-3873.5144,-3871.9324,-3870.237,-3867.7053,-3864.5994,-3861.5278,-3859.1914,-3856.7957,-3856.5063,-3857.2078,-3858.1257,-3864.8364,-3796.8513,-3478.6482,-3337.1445,-2982.044,-2439.7402,-2123.5203,-1853.9615,-1948.0736,-2144.7668,-2144.7703,-2005.224,-1976.9993,-1927.9447,-1835.0515,-1747.8439,-1670.4468,-1895.836,-2297.0767,-2226.158,-1870.9578,-1954.1875,-1963.7385,-1778.7152};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_49()
		{
			double[] value = {-1829.985,-1342.1237,-1305.3774,-1119.0989,-1252.2301,-1405.0736,-1047.4539,-636.9993,-292.5304,-336.20392,-502.7948,-325.12994,13.828886,362.5062,526.7395,562.2776,712.9997,917.66797,1120.9393,1305.9066,1505.5498,1697.1648,1842.198,1943.7657,2043.5841,2163.273,2336.3142,2475.8484,2590.2842,2722.132,2845.681,3010.002,3103.0037,3232.268,3321.3894,3494.5608,3722.1985,3476.1008,3554.3867,3166.3262,2520.264,1896.0621,1715.0665,1663.2616,1808.2052,2034.4899,2165.649,2145.2495,1972.1306,1934.9575,2012.7244,2342.5488,2871.9011,2055.4841,1997.2434,1956.8768,2201.032,3142.6877,2389.7056,2772.8867,2476.4377,1695.4489,1435.1783,1106.7477,-3590.7542,-3633.0728,-3611.7935,-3622.1838,-3637.2493,-3629.1702,-3650.0063,-3629.9126,-3686.0945,-3774.1768,-3790.4736,-3788.9836,-3781.3394,-3818.5725,-3865.491,-3790.5337,-3837.2769,-3857.4133,-3870.4402,-3880.5525,-3873.5122,-3878.8887,-3874.019,-3863.3252,-3859.234,-3871.1313,-3873.3005,-3876.1453,-3878.8977,-3875.4995,-3873.9302,-3873.4116,-3869.6716,-3864.8052,-3861.491,-3857.5562};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_50()
		{
			double[] value = {-3855.2659,-3855.5972,-3855.1074,-3857.0852,-3861.312,-3859.4924,-3635.983,-3364.9807,-3204.0735,-2569.3848,-2236.6975,-1855.4066,-2033.767,-1959.9253,-2100.3042,-1993.2595,-1919.5902,-1890.4307,-1815.9819,-1749.4039,-1676.449,-1692.4882,-1979.7866,-2021.863,-1897.2197,-1681.9846,-1571.1315,-1155.3391,-1245.2313,-1331.9614,-868.38324,-1043.3107,-1356.7257,-1505.3154,-1204.206,-919.3136,-791.89484,-778.3219,-498.15295,-9.316894,159.15906,434.9724,632.0668,744.0286,847.157,1022.45026,1183.6368,1334.0919,1550.5321,1744.8892,1876.3905,1994.053,2120.9885,2229.782,2336.3533,2484.007,2619.5767,2714.812,2853.3909,3060.4912,3255.5723,3364.6875,3459.4475,3570.0134,3554.4429,3367.1553,3331.1492,2989.8682,2370.7344,1828.3918,1677.265,1646.6112,1767.4028,1915.7405,2125.2288,2053.0383,1880.1042,1836.7572,1909.4753,1989.9363,2192.7087,1944.9403,1905.838,1872.5498,2127.1885,3175.016,2826.3083,2492.785,2497.2397,1964.9564,1453.5577,1106.4062,-3632.1711,-3684.409,-3656.816,-3691.093,-3687.7463,-3677.82,-3713.955,-3695.702};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_51()
		{
			double[] value = {-3764.6274,-3793.7236,-3821.207,-3834.247,-3810.974,-3819.8694,-3839.5095,-3833.9255,-3855.1636,-3858.563,-3873.1663,-3882.7905,-3880.9497,-3888.3096,-3884.3447,-3879.6516,-3877.2683,-3877.053,-3877.299,-3879.4214,-3884.004,-3886.0083,-3885.458,-3881.3662,-3875.1177,-3871.4314,-3867.2742,-3866.5269,-3860.3552,-3859.1084,-3858.5808,-3859.2014,-3862.8271,-3869.1526,-3756.268,-3385.8,-3222.98,-2834.6357,-2450.6172,-2218.239,-1945.2336,-2027.2434,-2053.423,-1855.7817,-1774.6439,-1727.276,-1671.058,-1625.5627,-1672.0219,-1736.3757,-1609.3773,-1767.3749,-1336.4678,-1590.5242,-1192.4614,-888.72845,-1043.0117,-1060.6512,-717.0414,-966.4213,-1577.4661,-1596.0029,-1357.0685,-1015.70465,-926.93207,-867.01263,-520.581,227.81543,296.6673,382.95682,585.3832,809.29877,961.17694,1140.8257,1286.7163,1411.4376,1569.9843,1769.7606,1913.6337,2040.3948,2147.0002,2261.582,2372.2222,2481.9473,2618.1462,2732.5466,2870.4985,3175.5688,3540.1672,3613.3464,3596.742,3528.285,3430.7874,3227.8938,2960.5918,2579.0737,2029.69,1734.0419,1690.4718,1641.4215};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_52()
		{
			double[] value = {1728.3765,1888.1577,2009.6779,1978.8546,1814.1874,1725.7595,1737.035,1719.8118,1770.4902,1818.0038,1801.8754,1778.7612,1838.0406,2452.1577,3187.9912,2940.7473,2348.7722,1894.8805,1385.6139,1132.7627,-3674.9253,-3715.9446,-3713.7354,-3681.4575,-3669.4353,-3710.4133,-3762.1262,-3742.2979,-3803.4353,-3829.827,-3849.5408,-3865.0757,-3841.7485,-3832.0825,-3853.2405,-3846.701,-3868.3828,-3876.9712,-3883.8357,-3886.991,-3885.7434,-3892.4487,-3894.2075,-3893.1082,-3887.9636,-3881.6199,-3879.7524,-3882.1082,-3889.3472,-3894.6619,-3894.4739,-3905.331,-3882.9324,-3880.0374,-3875.0361,-3870.9714,-3864.9446,-3880.75,-3864.0781,-3870.601,-3868.2761,-3870.802,-3862.0474,-3581.9224,-3341.9492,-3120.3123,-2574.0352,-2283.014,-2210.1929,-2035.6357,-1940.5435,-2029.2438,-1694.9536,-1672.5837,-1777.2573,-1717.0526,-1691.7922,-1585.032,-1569.7366,-1724.1577,-1518.8694,-1444.624,-1059.3656,-917.61847,-969.5618,-743.9751,-666.4799,-967.7517,-1533.9463,-1712.4326,-1532.381,-1257.2588,-1042.4108,-804.8639,-301.5705,262.20874,347.9996,440.1516,684.03076,853.51984};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_53()
		{
			double[] value = {1030.7386,1228.751,1363.5354,1501.7444,1656.3376,1861.3995,1993.5663,2076.5793,2142.9336,2264.5388,2382.9785,2474.833,2607.4114,2709.1536,2947.5266,3479.985,3822.2114,3848.0798,3642.771,3501.8044,3430.4055,3180.9202,2795.7454,2326.0845,1936.4141,1737.7433,1685.7203,1661.4606,1687.7815,1795.4713,1910.837,1878.0448,1741.6166,1662.1849,1653.0294,1639.0027,1621.455,1666.3024,1688.4028,1671.4342,1636.5044,1750.2786,2244.8162,2270.9307,1905.4342,1525.1891,1255.5437,1088.9307,-3715.6626,-3768.519,-3744.1758,-3689.8872,-3635.595,-3746.1284,-3794.9526,-3827.8938,-3835.7385,-3851.1753,-3854.6235,-3867.71,-3870.8835,-3856.484,-3867.3186,-3853.9304,-3871.0332,-3889.9714,-3897.8882,-3901.4314,-3899.4446,-3897.412,-3900.6313,-3901.714,-3893.1768,-3887.7776,-3885.8918,-3886.3596,-3892.2288,-3899.303,-3901.4878,-3898.6646,-3894.2522,-3888.4226,-3884.2026,-3880.0056,-3866.7773,-4026.1326,-3870.1594,-3878.6824,-3873.656,-3874.0442,-3875.904,-3823.9827,-3421.0933,-3286.9255,-2935.7178,-2418.5564,-2135.2449,-1739.8989,-1743.0985,-1649.9689};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_54()
		{
			double[] value = {-1776.1389,-1811.0426,-1990.4414,-1885.7198,-1623.3024,-1769.2341,-1904.152,-1982.7146,-1464.9167,-1337.6,-1105.9606,-910.2229,-890.4002,-946.4857,-793.3985,-878.7777,-1568.4081,-1793.3607,-1541.5343,-1113.9885,-696.2759,-351.89368,-23.44611,230.94414,402.96222,570.3004,749.41315,904.7815,1082.9158,1268.3804,1453.3516,1598.813,1712.2593,1853.7136,1988.1147,2110.3125,2255.3071,2308.327,2371.0273,2470.5537,2528.4534,2719.6272,2998.8066,3542.369,3827.971,3859.6807,3652.68,3516.945,3424.7366,3117.7952,2724.6172,2362.1904,1959.7986,1742.9434,1687.8088,1662.8087,1650.0367,1774.1547,1885.7146,1823.26,1692.1714,1609.9545,1552.2976,1493.2251,1441.791,1538.3469,1550.151,1537.9347,1538.6732,1490.8555,1462.8715,1504.4644,1406.9509,1222.038,1127.5182,1029.4414,-3741.6418,-3779.476,-3763.3005,-3605.2517,-3618.4692,-3776.8965,-3782.0046,-3848.6475,-3862.692,-3862.9592,-3862.8767,-3878.1646,-3876.417,-3874.5737,-3877.9307,-3866.71,-3881.9465,-3893.6128,-3904.4763,-3913.4731,-3916.7783,-3913.1555,-3910.616,-3911.2334};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_55()
		{
			double[] value = {-3897.3936,-3896.8557,-3894.4834,-3891.7888,-3896.748,-3901.648,-3906.2544,-3909.484,-3906.1987,-3900.1062,-3895.387,-3890.1013,-3889.4854,-3888.0012,-3887.4045,-3883.6816,-3876.6843,-3877.2468,-3879.9766,-3879.062,-3646.1943,-3368.268,-3272.203,-2790.2952,-2426.9846,-2116.305,-1998.4197,-1753.6135,-1611.978,-1641.3352,-1858.5227,-1851.8145,-1918.4143,-2113.1838,-2168.321,-1990.3529,-1483.3604,-1120.5099,-1016.6223,-1060.7687,-974.01166,-1189.5892,-1002.2691,-1323.7642,-1931.1082,-1731.1038,-1187.2173,-738.7979,-381.51324,-147.01836,109.041046,283.47723,446.83554,624.4404,806.073,953.73773,1125.1421,1303.1045,1453.1772,1604.1875,1752.974,1880.1812,1993.0695,2125.8474,2233.0945,2338.3438,2392.2878,2464.9167,2558.7666,2667.583,2957.6877,3241.4128,3778.9941,3824.2124,3814.0647,3682.3142,3639.488,3148.3638,2721.3562,2334.1504,1892.1703,1673.011,1653.572,1639.005,1623.1405,1745.2928,1831.1278,1778.308,1634.788,1562.8207,1463.2751,1424.9707,1382.9989,1417.0034,1418.5645,1445.6493,1433.1001,1393.0304,1339.9216,1282.0857};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_56()
		{
			double[] value = {1227.6694,1129.6626,1052.3445,956.8998,-3792.9377,-3806.7866,-3809.2527,-3727.0063,-3696.4624,-3778.3582,-3839.445,-3876.3433,-3873.805,-3870.693,-3876.191,-3886.3308,-3883.657,-3882.1992,-3885.8455,-3889.1765,-3880.2695,-3905.1316,-3911.7102,-3922.0137,-3931.6333,-3933.992,-3932.3574,-3927.057,-3907.036,-3907.6821,-3906.376,-3899.0166,-3898.491,-3902.8616,-3909.3142,-3913.674,-3912.651,-3914.0942,-3908.3828,-3900.9539,-3898.3867,-3894.1936,-3891.4673,-3887.907,-3881.2969,-3883.1133,-3884.3784,-3883.725,-3831.2617,-3500.8542,-3283.97,-3185.1536,-2632.8052,-2436.14,-2239.8215,-2050.8718,-1988.9688,-2121.7651,-2062.4111,-2287.428,-2375.664,-2309.0889,-2273.988,-2168.3884,-1993.1808,-1626.1915,-1454.3517,-1526.3818,-1473.9033,-1482.787,-1372.8184,-1809.853,-2016.4786,-1556.1602,-855.39185,-459.5918,-196.70552,-5.214291,180.91212,348.72476,497.68875,665.37634,852.01526,1019.7984,1158.1431,1263.8165,1503.1272,1637.5753,1769.6499,1910.3433,2032.1497,2137.4556,2264.875,2326.5122,2442.4526,2528.696,2556.2786,2639.383,2870.4636,3023.578};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_57()
		{
			double[] value = {3554.844,3612.2542,3632.1008,3391.5576,3431.5327,3057.3816,2664.4773,2283.8604,1842.856,1632.234,1618.3385,1630.7911,1637.6273,1727.3276,1769.726,1720.2935,1566.6948,1502.3469,1442.9445,1399.0948,1354.3531,1294.4607,1269.9845,1271.8986,1308.4579,1284.4542,1255.7848,1181.0884,1110.6627,1044.9658,970.152,898.29364,-3865.3193,-3860.893,-3756.9973,-3759.407,-3731.3213,-3798.4648,-3883.2378,-3884.0977,-3881.8813,-3885.0037,-3895.628,-3892.3066,-3892.4817,-3893.2644,-3894.291,-3896.9631,-3897.6165,-3907.823,-3919.574,-3929.7778,-3940.7314,-3947.7598,-3950.9773,-3940.373,-3922.1536,-3919.547,-3916.3704,-3914.7292,-3905.0195,-3905.2664,-3912.4526,-3916.1665,-3913.442,-3917.7424,-3915.648,-3905.8445,-3901.1724,-3906.141,-3899.6702,-3892.6968,-3888.083,-3888.6816,-3889.632,-3890.3535,-3884.2537,-3710.0913,-3383.0327,-3193.7703,-2960.0107,-2739.0442,-2573.2249,-2502.3132,-2711.484,-2717.134,-2599.7788,-2555.3406,-2391.2598,-2404.8364,-2330.4077,-2241.5208,-2242.4307,-2129.244,-1804.4474,-1628.8256,-1567.5778,-1533.4467,-1941.2322,-2104.3076};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_58()
		{
			double[] value = {-2049.4285,-1338.2794,-594.4235,-257.64642,-77.841446,79.195885,222.90231,364.464,524.77356,709.29865,912.6843,1121.4636,1262.0348,1389.4178,1528.3461,1671.0836,1810.0121,1943.4677,2062.6018,2160.95,2285.3848,2346.9534,2440.8105,2548.647,2610.2097,2673.1245,2838.7996,3016.1973,3212.5198,3272.7114,3309.1067,3238.1736,2915.1235,2969.6396,2653.445,2287.7512,1863.6556,1660.4231,1590.9869,1633.8296,1610.1981,1655.4482,1669.8467,1628.2963,1545.8444,1441.3911,1371.9202,1369.9587,1308.0288,1193.9819,1149.0422,1146.8496,1169.6361,1168.4913,1142.4006,1121.0288,1046.827,993.8122,916.0455,850.4362,-3899.995,-3874.4722,-3844.603,-3731.276,-3541.5696,-3802.3516,-3895.2485,-3899.1597,-3905.2075,-3901.3442,-3914.8992,-3907.7058,-3904.2993,-3903.739,-3901.6055,-3904.8748,-3912.864,-3921.3455,-3927.62,-3934.1335,-3947.3208,-3953.0193,-3951.9097,-3947.2842,-3939.788,-3933.0115,-3931.0437,-3930.4402,-3918.549,-3916.1052,-3918.8801,-3926.372,-3926.2168,-3922.5024,-3916.718,-3911.622,-3908.5867,-3906.8958,-3897.2283,-3893.5906};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_59()
		{
			double[] value = {-3892.2244,-3889.947,-3889.5393,-3888.843,-3886.7065,-3866.9077,-3597.85,-3210.7898,-3075.025,-3070.7488,-2915.8367,-2819.9036,-2785.906,-2710.1208,-2607.0776,-2409.4927,-2315.4712,-2345.4075,-2245.5928,-2245.9866,-2284.1775,-2194.9846,-2133.9917,-2057.4785,-2004.0614,-1977.1039,-2102.681,-2128.9368,-2029.1877,-1046.2632,-330.66104,-107.501526,22.83265,152.07272,295.436,451.30432,622.407,797.8376,991.1494,1174.9589,1333.8103,1483.4534,1607.8864,1720.9691,1860.4127,1999.1516,2136.99,2215.92,2283.588,2350.4082,2507.5085,2557.8623,2638.7058,2748.9043,2849.0654,3015.3997,3169.2036,3198.742,3244.196,3210.953,3022.2615,2955.3848,2648.4045,2309.529,1949.92,1750.7391,1617.5436,1646.8491,1620.7701,1656.6011,1579.5732,1528.8505,1481.2845,1404.3195,1344.9741,1287.8535,1244.6484,1174.9673,1099.585,1052.7375,1051.9808,1050.6017,1028.4805,1048.235,1019.6841,982.78894,895.92706,810.83716,-3946.307,-3897.9353,-3725.6484,-3413.2651,-3319.7737,-3624.0098,-3849.1572,-3926.6428,-3930.292,-3917.1465,-3921.064,-3921.0315};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_60()
		{
			double[] value = {-3918.5742,-3915.537,-3910.7437,-3912.0054,-3920.2295,-3925.3647,-3933.6174,-3943.7668,-3950.1055,-3952.63,-3940.2673,-3937.1924,-3944.2712,-3939.2932,-3930.5972,-3925.9385,-3925.425,-3929.9016,-3931.9275,-3936.208,-3939.394,-3937.1758,-3931.3875,-3924.0242,-3892.9675,-3898.0837,-3897.154,-3897.5083,-3895.9158,-3898.8662,-3897.3545,-3889.2834,-3908.5117,-3894.4475,-3853.2346,-3503.9578,-3211.2249,-3037.5232,-2918.709,-2777.4878,-2733.2874,-2576.5444,-2003.4669,-2020.5859,-2231.2886,-2288.0784,-2223.3384,-2230.1807,-2266.583,-2214.2896,-2217.3093,-2228.015,-2190.2922,-2158.4973,-2143.0203,-2107.7502,-1563.5775,-546.4206,-74.22217,8.195073,86.91146,203.95547,361.87607,541.52277,691.69904,861.4834,1044.5835,1236.6322,1418.9843,1534.2346,1633.5563,1732.1293,1840.4454,2005.1101,2206.2488,2298.341,2313.2175,2423.2957,2578.719,2635.2625,2699.7517,2843.667,2963.2878,3127.8044,3206.003,3197.0012,3200.0823,3202.9238,3107.9756,2971.265,2676.1626,2326.5193,1946.3546,1743.8387,1616.2662,1564.9469,1532.6967,1551.8468,1474.1937,1453.3424};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_61()
		{
			double[] value = {1452.0261,1336.1937,1252.3591,1179.5021,1110.0382,1089.6028,1065.9279,1027.9883,999.8989,981.024,960.195,955.2686,1002.18274,976.94653,894.00244,822.28326,-3950.7283,-3942.0867,-3808.466,-3445.0383,-3251.769,-3586.5254,-3901.5415,-3932.9785,-3933.755,-3940.0505,-3940.2886,-3930.338,-3929.5845,-3923.8997,-3916.8774,-3919.0566,-3923.7095,-3927.214,-3932.1301,-3944.732,-3951.3264,-3951.965,-3935.597,-3929.8552,-3947.92,-3940.8804,-3931.5405,-3926.1814,-3928.17,-3930.4746,-3936.2715,-3941.303,-3939.5718,-3939.005,-3936.9282,-3934.7288,-3915.759,-3917.6963,-3961.5508,-3954.668,-3966.5454,-3980.8572,-3960.8367,-3940.2554,-3949.808,-3943.1423,-3904.6443,-3854.6086,-3691.669,-3416.7307,-3135.969,-2901.0735,-2847.5833,-2457.3926,-2040.6266,-1884.9191,-2098.408,-2179.7808,-2158.0527,-2255.4368,-2301.787,-2254.6904,-2259.4895,-2221.4663,-2179.6785,-2162.6443,-2079.5015,-1676.9696,-802.22864,-152.0001,81.6776,55.729256,133.0559,265.68512,407.5116,547.4611,699.8399,877.2455,1062.6864,1232.2393,1389.8743,1581.62,1736.2463,1835.9686};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_62()
		{
			double[] value = {1986.9988,2117.2397,2239.9497,2346.1348,2389.6062,2543.4692,2711.7847,2803.5325,2838.3523,2941.4683,3153.1223,3329.9612,3428.9363,3327.0364,3284.401,3292.9395,3181.6624,3015.9343,2719.452,2413.7124,2038.4144,1805.8871,1559.6794,1464.2463,1402.1682,1401.8519,1393.427,1347.0804,1354.1907,1270.5034,1191.773,1159.5103,1102.4237,1025.5963,1012.5526,1003.0747,974.8074,936.41956,921.0933,912.72925,961.99884,1055.0143,1069.3447,949.10144,-3974.3887,-3959.909,-3700.4885,-3737.9053,-3654.8364,-3817.456,-3950.3562,-3958.975,-3944.4968,-3944.993,-3941.3213,-3938.4272,-3930.6443,-3924.6497,-3921.6711,-3926.392,-3930.112,-3930.1226,-3926.8972,-3944.7563,-3950.342,-3952.7954,-3938.1506,-3915.986,-3943.499,-3942.2869,-3941.279,-3933.997,-3938.8083,-3941.1636,-3946.521,-3949.137,-3948.4922,-3929.589,-3936.6064,-3941.067,-3932.361,-3918.2332,-3979.8535,-4008.9001,-4006.628,-4002.9326,-3966.4436,-3954.0498,-3941.445,-3929.116,-3913.7097,-3901.0454,-3905.5308,-3866.3364,-3754.108,-3464.6104,-2125.2393,-1512.0917,-1802.3223,-2023.0784};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_63()
		{
			double[] value = {-2047.431,-1944.3531,-1852.0399,-2111.9797,-2328.5852,-2224.6804,-2204.4707,-2209.3967,-2200.7175,-2052.4106,-1635.3632,-906.8865,-150.8815,141.89871,115.35033,70.102005,164.10596,308.4026,435.73187,574.5243,763.0929,966.4536,1150.9392,1307.6381,1479.1232,1659.1096,1829.8025,1965.3281,2185.9849,2296.1719,2410.7449,2509.5837,2553.1772,2673.089,2824.622,2977.9697,3086.4229,3160.2263,3341.2449,3477.3909,3639.4836,3510.825,3370.049,3426.48,3330.9304,3202.8042,2862.6052,2632.0376,2123.6003,1989.2096,1641.1982,1428.7527,1336.0127,1283.6758,1262.377,1234.7458,1217.0647,1186.1118,1126.4524,1075.6539,1068.6451,974.8767,949.9681,947.3512,935.7703,918.704,895.038,892.47534,985.03894,1135.7292,1254.8113,1228.548,-3968.5908,-4001.995,-3924.1282,-3911.9194,-3900.6934,-3948.9817,-3972.172,-3971.7764,-3937.318,-3946.6694,-3945.224,-3942.2,-3935.4895,-3926.711,-3925.1934,-3935.1418,-3936.5115,-3937.38,-3931.151,-3941.4922,-3944.933,-3946.8977,-3941.7585,-3908.8481,-3930.384,-3939.6848,-3943.0308,-3946.4316};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_64()
		{
			double[] value = {-3945.2214,-3949.0222,-3950.566,-3947.6165,-3951.348,-3937.7734,-3942.0232,-3943.3816,-3934.0964,-3913.5938,-3980.4763,-4012.037,-4001.3833,-3983.0815,-3957.4272,-3926.7932,-3938.7007,-3947.0544,-3924.5513,-3933.9006,-3922.243,-3905.1785,-3898.1362,-3601.5957,-1555.377,-741.08777,-1250.1472,-1776.5336,-1935.948,-2016.9491,-1904.7599,-2230.6206,-2192.273,-2218.382,-2209.568,-2142.1016,-1941.3862,-1525.3976,-1061.5197,-425.2035,112.19042,272.2501,70.72019,54.254444,170.43056,303.13925,460.666,594.3263,745.64233,952.7205,1142.1843,1315.7838,1491.8265,1677.332,1849.199,2066.0566,2204.8708,2422.3745,2586.0007,2702.3918,2803.1362,2951.2769,3112.192,3238.3337,3344.3628,3445.899,3587.89,3643.4707,3805.527,3650.9824,3612.0771,3680.4634,3686.478,3502.305,3287.028,2846.4968,2658.2861,2456.9229,2049.5247,1719.7557,1508.2408,1303.7642,1157.7955,1143.3756,1090.4994,1044.3715,1026.9657,1013.21014,967.9041,911.1566,865.2005,889.9697,881.67755,900.7025,885.28094,1079.0073,1235.3514,1069.9293,1312.0089,1455.0535};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_65()
		{
			double[] value = {-4011.6074,-3937.4907,-3957.6316,-3971.923,-3916.5232,-3972.0183,-3975.795,-3952.9639,-3837.2405,-3913.2915,-3957.1606,-3958.5156,-3955.0793,-3937.1746,-3932.1565,-3931.7864,-3943.5103,-3943.2085,-3940.79,-3938.3171,-3938.1655,-3940.6028,-3936.1724,-3919.8984,-3911.681,-3935.376,-3943.3477,-3947.5425,-3953.4807,-3958.6248,-3949.528,-3949.2727,-3947.7112,-3945.3562,-3943.2065,-3940.9585,-3935.0132,-3910.5872,-3919.701,-3953.902,-3939.5464,-3920.621,-3931.836,-3955.2175,-3959.4707,-3963.9097,-3949.982,-3931.7202,-3912.8345,-3911.4666,-3889.447,-3829.0137,-2403.796,-1224.4248,-757.26483,-1520.5702,-1639.2323,-1931.9021,-2084.3333,-2097.4402,-1992.7809,-1975.2185,-1880.0309,-1714.5145,-1482.9413,-1124.7083,-740.1843,-181.31384,339.56012,194.69023,-5.017457,46.43797,163.8041,312.02536,427.88528,541.91187,738.0204,912.9521,1109.911,1289.85,1478.2059,1693.9904,1922.1313,2121.9019,2285.466,2486.9863,2743.5483,2923.075,3081.8108,3257.1648,3449.2998,3608.8464,3728.544,3812.7683,3851.2598,3924.1108,4006.0771,3916.241,3902.2883,4003.8953};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_66()
		{
			double[] value = {3955.4133,3823.9592,3728.8398,3365.9736,3230.453,3002.3225,2673.416,2198.6597,1847.4958,1457.0891,1202.0018,1149.0105,1013.7304,942.2875,910.8751,859.463,837.35297,828.9049,802.2556,784.69147,821.66846,834.7086,852.6113,985.34924,1046.8518,1374.0114,1367.044,1340.2814,-4000.7173,-3980.204,-3984.205,-3986.3643,-3978.2856,-3979.9314,-3984.4739,-3762.6157,-3724.1638,-3918.8784,-3931.6313,-3950.0146,-3977.9453,-3948.837,-3942.616,-3931.574,-3947.2004,-3951.1636,-3947.4006,-3943.6316,-3942.7463,-3937.4348,-3924.713,-3919.2163,-3913.7244,-3921.3281,-3944.463,-3950.1494,-3948.8633,-3959.5808,-3946.8584,-3950.5278,-3931.3398,-3928.809,-3944.3804,-3944.1956,-3940.1255,-3938.1216,-3930.798,-3926.4526,-3929.3723,-3909.5894,-3919.2827,-3952.2002,-3950.888,-3934.3064,-3906.7842,-3892.306,-3889.0435,-3880.3958,-3859.7654,-3881.0925,-3323.4111,-2350.996,-1166.0787,-1327.2667,-1853.4558,-2135.3618,-2249.7402,-2102.9827,-1887.8052,-1771.5496,-1702.5514,-1595.2965,-1363.1456,-1010.58435,-564.5267,46.024338,893.78467,316.89682,278.3723,40.53685};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_67()
		{
			double[] value = {154.84721,267.59195,380.32675,540.8734,692.7484,879.0677,1081.4723,1277.4949,1482.6768,1680.0826,1937.2505,2250.452,2486.3462,2669.6956,2907.4448,3132.6174,3354.347,3605.3645,3769.374,3887.2908,4091.283,4168.7534,4169.093,4236.053,4236.276,4101.935,4072.3992,4220.9087,4220.9097,4149.065,4108.1333,3870.3667,3690.365,3401.4827,3228.8997,2888.5745,2411.6785,1806.4552,1454.2072,1334.6621,1125.6364,956.6291,780.8864,734.1891,736.24835,729.71967,718.5474,744.2719,818.04266,781.35956,805.30426,807.0227,936.3354,1122.0533,1273.9365,1196.5608,-4013.4792,-3995.5754,-3980.6875,-3979.3875,-3967.7412,-3989.8804,-3990.3687,-3718.8538,-3888.81,-3884.9468,-3865.2693,-3917.5732,-3986.239,-3966.246,-3947.4216,-3949.5327,-3957.2898,-3959.2375,-3955.3337,-3951.1301,-3948.2026,-3934.612,-3923.8284,-3924.176,-3924.5242,-3924.4111,-3944.3765,-3948.5566,-3947.3833,-3956.6667,-3945.9019,-3953.4087,-3945.29,-3946.855,-3951.089,-3950.3242,-3946.7231,-3936.0933,-3930.8074,-3927.0894,-3915.5527,-3907.316,-3889.3225,-3905.4949};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_68()
		{
			double[] value = {-3914.7678,-3887.7844,-3866.357,-3851.398,-3844.418,-3833.3628,-3840.1533,-3858.8057,-3521.8982,-2430.9138,-1768.1384,-1584.9163,-1877.3246,-2119.209,-2165.454,-2040.2308,-1799.6206,-1544.2439,-1499.2938,-1291.0116,-1154.0559,-950.52814,-689.8705,-509.1586,154.8581,854.291,698.24164,4.843175,127.259735,235.41139,409.04062,507.3265,676.7453,862.9026,1067.0249,1245.333,1494.4432,1759.0629,2051.4707,2404.2173,2732.6155,2966.2437,3187.0137,3449.0269,3677.2722,3926.6946,4157.326,4293.9604,4453.9775,4558.727,4661.6274,4709.7017,4670.3677,4480.0024,4330.9214,4421.497,4382.378,4245.4907,4191.732,4069.6606,4006.5608,3794.8367,3595.1785,3344.9976,2830.6536,2275.2288,1874.7804,1600.8687,1278.6012,998.5746,808.2853,702.758,668.82697,655.1615,636.7114,645.2159,688.66046,698.1576,720.4908,738.14465,751.3583,837.9842,1025.0721,975.6664,-4047.6477,-3999.7388,-3991.303,-3981.2651,-3968.1816,-3993.9045,-3999.73,-3959.0427,-3875.8376,-3755.5247,-3584.248,-3830.2007,-3995.0825,-3986.2969,-3950.5847,-3950.7957};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_69()
		{
			double[] value = {-3969.1335,-3971.0623,-3967.7893,-3962.2917,-3956.4539,-3944.686,-3935.763,-3925.2773,-3923.5671,-3927.3242,-3936.6665,-3943.3296,-3944.399,-3940.5625,-3952.2917,-3959.947,-3954.577,-3960.0195,-3958.101,-3947.927,-3939.3748,-3920.621,-3900.1711,-3895.7783,-3894.2688,-3884.73,-3880.112,-3890.8276,-3898.774,-3872.1177,-3836.4753,-3822.6792,-3810.1643,-3822.398,-3846.9512,-3845.901,-3728.804,-2820.1375,-1935.0421,-1835.0232,-1898.6991,-1828.4536,-1659.9185,-1648.7363,-1619.0125,-1664.327,-1109.441,-838.9411,-746.2809,-589.2744,-517.1769,-784.8901,-31.638554,440.31543,298.0388,-72.91245,67.65626,216.36278,368.47266,493.73398,667.6304,820.57697,939.23285,1172.5857,1511.402,1772.1986,2128.2734,2575.7002,3016.3757,3327.1575,3574.691,3854.0933,4122.212,4406.847,4646.739,4845.199,4969.715,5101.042,5371.8364,5512.0674,5390.7354,5194.5396,4980.4814,4879.36,4659.963,4346.1626,4182.8975,4081.6768,4098.528,4136.765,3923.87,3604.1567,3194.5508,2788.5447,2365.9426,1911.3975,1635.1842,1024.822,862.9046,763.09796};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_70()
		{
			double[] value = {595.6961,549.42993,539.1977,564.67596,600.2675,611.7579,627.8801,628.4458,702.1523,864.98926,846.6789,943.2846,-4035.1394,-4019.4832,-4003.701,-3987.984,-3978.322,-4004.513,-4005.3425,-4002.8413,-3829.6077,-3515.665,-3459.146,-3575.778,-3971.2134,-3992.0337,-3965.4087,-3957.6746,-3974.339,-3982.9055,-3976.162,-3968.479,-3963.044,-3950.364,-3942.3433,-3925.1602,-3911.6802,-3930.2793,-3937.5503,-3935.6497,-3940.3237,-3940.3838,-3932.9688,-3953.9858,-3953.5374,-3944.3623,-3948.672,-3942.4,-3927.8464,-3914.604,-3890.63,-3878.9778,-3874.482,-3875.3152,-3858.4922,-3864.5085,-3879.987,-3862.662,-3836.8403,-3825.839,-3814.9045,-3833.917,-3851.607,-3846.4204,-3768.0422,-3165.9531,-2182.7388,-1610.1792,-1412.2826,-1386.7556,-1264.0226,-1192.0854,-1194.528,-676.6365,-298.84317,-54.49463,-91.66862,-296.13086,-820.305,-888.6246,-657.36774,-245.53168,-115.82425,-142.49342,30.91503,189.8165,302.76804,454.15048,632.7337,763.4814,963.73175,1224.4851,1507.7268,1860.8699,2272.9106,2707.665,3231.5952,3629.7583,3916.0132,4259.4062};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_71()
		{
			double[] value = {4544.5435,4873.807,5204.1167,5380.9116,5464.963,5748.812,5815.894,5852.77,5837.3647,5714.3926,5562.899,5468.892,5189.742,4695.0327,4272.505,4092.067,4133.462,4255.4614,4099.407,3853.8545,3514.23,3229.2595,2842.2095,2294.286,1869.6904,1394.0449,971.5435,658.0158,494.91156,449.92307,450.18723,481.36728,493.47885,535.53265,558.2627,598.4679,680.8158,793.6414,840.22125,913.01105,-4039.7976,-4026.6328,-4020.4246,-4007.643,-3996.3452,-4017.844,-4019.141,-4010.7046,-3995.7537,-3827.4985,-3520.4834,-3564.941,-3806.152,-3984.6077,-3970.2039,-3963.2944,-3973.9573,-3981.8086,-3976.2727,-3972.4707,-3957.8176,-3953.9656,-3945.6924,-3943.7205,-3930.2078,-3938.5715,-3941.2432,-3931.035,-3926.3447,-3940.0378,-3927.7961,-3940.246,-3948.2866,-3922.6753,-3921.706,-3922.421,-3914.8794,-3898.1565,-3883.6597,-3873.5903,-3864.149,-3863.0872,-3848.5576,-3843.588,-3853.7036,-3854.3853,-3843.3296,-3847.3555,-3869.869,-3860.4136,-3846.5664,-3815.2185,-3748.0684,-3614.8594,-3105.177,-2246.1611,-1553.3674,-1038.776,-1051.631,-1274.5748};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_72()
		{
			double[] value = {-1058.784,-812.2728,-1089.5685,-834.6623,-665.975,-616.935,-818.84155,-919.84845,-765.95374,-550.7086,-378.26312,-150.6756,17.909637,138.4771,242.86186,343.21045,493.424,655.50684,878.2884,1193.0093,1628.2009,2090.0925,2546.5264,2944.2002,3418.7537,3838.2817,4226.7085,4621.142,4940.9634,5241.558,5566.9487,5673.093,5743.878,5904.513,5883.6704,5928.0386,6045.755,6024.259,5929.089,5877.8345,5682.976,5177.4595,4582.272,4229.928,4197.411,4322.29,4338.88,4169.9565,3828.8325,3550.253,3089.0544,2562.9324,2068.7578,1594.4641,1085.0907,715.01917,525.29834,412.29575,373.43475,400.49338,451.07812,485.02097,507.84128,656.9466,872.80096,659.0887,717.6073,780.57874,-4045.5454,-4034.7437,-4023.0393,-4017.0813,-4011.4536,-4018.2578,-4031.025,-4026.4937,-4001.2637,-4000.9595,-3919.211,-3846.9404,-3795.3997,-3873.8328,-3941.4216,-3928.4817,-3966.8196,-3964.1995,-3891.1802,-3821.8818,-3888.9978,-3941.5593,-3960.069,-3955.1855,-3942.6711,-3933.6973,-3929.198,-3933.864,-3923.7947,-3932.9683,-3928.2136,-3938.9004};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_73()
		{
			double[] value = {-3928.0994,-3912.2603,-3875.085,-3887.8215,-3887.3677,-3878.9763,-3881.1392,-3872.1208,-3858.3147,-3843.229,-3837.1218,-3842.814,-3824.717,-3829.5845,-3820.2322,-3846.9165,-3847.46,-3823.2004,-3778.212,-3731.0469,-3661.8784,-3587.4563,-3465.9128,-3186.215,-2631.2507,-2000.1786,-1368.4536,-1115.3163,-1226.8528,-1342.0315,-2162.9912,-1016.67975,-1194.3047,-1263.0109,-1212.1973,-1077.3232,-866.5974,-629.18536,-412.70596,-227.8932,-86.84849,18.517626,88.95523,220.96883,361.87067,615.7213,957.1276,1356.9408,1763.3679,2223.684,2753.807,3361.8904,3693.1045,4105.3936,4489.981,4886.337,5154.3696,5394.1846,5624.6772,5688.8193,5733.7817,5676.8296,5791.171,6010.313,6195.4487,6186.338,6030.407,5781.5547,5865.44,5545.94,4832.6587,4376.1157,4267.7754,4331.5957,4506.713,4349.935,4070.807,3722.4138,3297.5151,2765.5557,2159.0203,1675.1709,1288.6139,939.52484,671.33356,453.7252,369.36426,380.73776,423.54413,426.30667,492.32257,481.8391,732.45264,1125.6971,759.8175,703.24176,-4041.0247,-4032.9077,-4027.074,-4024.4556};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_74()
		{
			double[] value = {-4018.11,-4023.8965,-4039.3726,-4042.8696,-4037.1309,-4014.8994,-4015.059,-3992.1553,-3893.5178,-3801.8638,-3864.9287,-3904.615,-3937.2598,-3950.7883,-3939.5237,-3881.6882,-3952.4014,-3967.6982,-3964.1907,-3951.043,-3944.9375,-3928.1914,-3934.4268,-3922.388,-3926.2207,-3923.8218,-3932.128,-3918.67,-3914.5684,-3919.123,-3870.715,-3872.977,-3890.002,-3886.8032,-3881.0562,-3867.3394,-3845.556,-3840.063,-3850.1477,-3868.5962,-3857.113,-3852.5232,-3841.703,-3808.095,-3742.0479,-3730.293,-3701.664,-3661.9631,-3593.085,-3518.7856,-3420.2197,-3276.2844,-3103.257,-2770.5176,-2523.1802,-2333.1687,-2169.258,-2018.0337,-1842.2806,-1722.037,-1586.6449,-1497.5557,-1350.503,-1172.4938,-969.0154,-776.1481,-584.55756,-396.60724,-269.70047,-180.87668,-41.180405,115.02594,332.5898,629.66956,984.9278,1408.6357,1883.1069,2385.0874,2894.766,3455.2256,3898.0513,4274.801,4645.1133,4945.762,5226.929,5423.4775,5569.619,5576.2007,5536.3647,5494.2827,5742.649,6199.6807,6412.3013,6075.2666,5859.1987,5772.5776,5911.736,5674.826,4977.5527,4437.6396};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_75()
		{
			double[] value = {4227.2896,4301.6924,4349.617,4313.7295,4107.995,3657.5479,3246.207,2809.1194,2245.5051,1702.9199,1256.1923,903.4115,665.4637,489.58182,389.62698,381.88504,400.53522,384.56436,439.02515,443.91672,428.3923,929.11115,965.5887,699.27905,-4040.4502,-4041.884,-4038.4216,-4034.6287,-4029.2979,-4046.7842,-4048.8364,-4042.2932,-4037.3801,-4016.9746,-4012.6729,-4017.6096,-3936.0862,-3911.8613,-4023.6755,-3956.4072,-3966.41,-3964.64,-3966.6536,-3973.7263,-3961.6885,-3958.562,-3944.8328,-3937.6323,-3938.3584,-3928.3655,-3922.13,-3904.6074,-3908.672,-3922.1453,-3924.7852,-3927.4175,-3920.1707,-3908.252,-3887.2417,-3881.3445,-3892.0205,-3898.6423,-3885.6096,-3859.4563,-3838.9272,-3838.78,-3863.1772,-3871.7234,-3879.9187,-3838.8171,-3809.6687,-3731.8784,-3653.2998,-3675.287,-3636.7395,-3609.576,-3530.2935,-3445.4282,-3356.4414,-3196.3958,-3012.9636,-2831.245,-2661.2917,-2472.9272,-2297.8906,-2111.6084,-1940.7944,-1785.5327,-1670.5217,-1561.6455,-1412.5455,-1220.6395,-1040.5887,-882.8769,-703.01355,-539.593,-437.46896,-345.81094,-196.8713,-6.302197};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_76()
		{
			double[] value = {245.9607,554.7039,886.4565,1300.8671,1811.783,2364.2598,2896.6528,3377.4324,3890.6223,4344.207,4713.949,4998.3926,5237.7114,5402.279,5543.1064,5502.9834,5390.086,5350.067,5649.019,6168.939,6454.1177,6163.905,5929.1504,5917.7515,5852.637,5514.5586,4938.064,4371.631,4112.4014,4183.8496,4157.4844,4104.8354,3750.9355,3259.3054,2884.5195,2499.6868,2062.9578,1541.7793,1074.5923,773.07654,549.7398,393.06134,365.8466,366.88455,392.3777,431.29834,436.46625,445.6719,427.21826,705.88367,627.25555,633.9203,-4033.0317,-4042.1934,-4042.879,-4042.481,-4035.0085,-4047.9768,-4034.7117,-4034.8174,-4035.8218,-4021.5977,-4012.8784,-4013.412,-4008.2104,-3934.5813,-3949.915,-3965.959,-3964.1887,-3973.5017,-3960.7014,-3950.55,-3955.8926,-3952.26,-3938.0793,-3936.112,-3926.0537,-3924.186,-3925.9543,-3917.0237,-3891.6377,-3906.8057,-3925.1326,-3924.1223,-3914.0842,-3908.6353,-3904.7188,-3882.8313,-3916.4805,-3907.4316,-3882.042,-3888.5742,-3877.4368,-3890.5596,-3875.2253,-3855.1873,-3860.4468,-3823.71,-3780.113,-3732.7832};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_77()
		{
			double[] value = {-3689.7654,-3636.3586,-3583.1064,-3550.2803,-3478.1768,-3386.345,-3276.3254,-3107.084,-2953.7825,-2793.9124,-2649.0254,-2485.9448,-2345.7903,-2146.7288,-1983.829,-1848.2015,-1703.634,-1576.2766,-1435.1211,-1287.9207,-1118.6083,-967.4761,-805.545,-690.9093,-583.985,-472.36133,-301.3755,-42.91003,164.9666,441.20056,765.0917,1155.7607,1608.7695,2132.4333,2680.3901,3250.0603,3766.966,4193.129,4529.006,4818.79,5072.0454,5302.4736,5443.0293,5356.642,5237.426,5165.7217,5345.0913,5649.1475,5878.1235,5963.9663,5931.7764,5727.724,5440.043,5081.935,4602.5376,4200.5527,4028.5662,4039.0967,3953.1365,3606.7275,3298.7659,2707.7483,2310.2886,1919.3982,1468.727,1110.9288,816.99713,507.1105,357.792,300.72076,295.1774,329.5745,394.068,436.82983,476.05118,460.07822,462.431,1108.333,759.6182,628.2282,-4028.93,-4035.736,-4054.979,-4057.2224,-4041.5967,-4048.5764,-4057.193,-4052.291,-4037.8647,-4033.772,-4019.0002,-4005.9956,-3990.893,-3979.199,-3966.526,-3965.774,-3963.7446,-3964.173,-3957.8308,-3942.5627};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_78()
		{
			double[] value = {-3954.5784,-3937.5994,-3918.6973,-3931.3823,-3928.2493,-3924.762,-3919.8538,-3914.1357,-3892.7202,-3900.4062,-3907.6824,-3908.5586,-3901.0845,-3892.968,-3886.9058,-3892.6682,-3932.8145,-3954.7722,-3934.3787,-3907.608,-3877.7998,-3859.907,-3860.0046,-3835.3643,-3802.213,-3761.6333,-3785.3909,-3745.7317,-3666.2744,-3572.469,-3522.1133,-3478.854,-3391.8293,-3285.644,-3153.1035,-3013.7354,-2908.974,-2798.0059,-2660.2395,-2509.5793,-2354.8262,-2188.2363,-2031.1104,-1894.9271,-1758.9602,-1603.207,-1486.3242,-1349.1808,-1193.4077,-1067.1256,-952.1808,-826.4065,-725.60394,-568.1487,-347.18103,-105.67114,18.7198,221.74905,507.13278,875.30273,1336.338,1806.2915,2306.075,2940.5146,3365.9187,3788.3218,4176.9526,4492.3545,4778.247,5053.021,5237.5396,5201.0234,5067.665,5064.972,5085.9634,5259.911,5459.0557,5556.26,5546.9854,5377.6675,5040.7397,4654.5264,4280.267,4069.752,3979.5789,3931.857,3854.593,3393.5508,2765.6287,2184.8088,1696.7213,1258.8273,884.7114,660.8765,481.30682,259.56824,161.18529,136.47388,205.56941,291.5858};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_79()
		{
			double[] value = {334.49884,403.54034,314.82538,389.99622,419.37836,520.7985,678.40497,601.45624,-4027.8037,-4044.8645,-4064.7168,-4065.557,-4057.0186,-4047.7437,-4057.436,-4034.9014,-4031.2952,-4016.832,-4011.6658,-3993.1196,-3996.4417,-4002.9128,-3980.352,-3976.557,-3972.0798,-3960.4636,-3950.6348,-3944.3882,-3947.6157,-3923.9534,-3922.3044,-3938.522,-3933.569,-3936.0042,-3911.7754,-3924.4177,-3914.6765,-3903.4583,-3921.463,-3943.8394,-3946.0417,-3926.0076,-3898.5474,-3932.516,-3940.1138,-3931.6223,-3919.3381,-3882.806,-3863.5886,-3858.7485,-3827.133,-3846.1545,-3789.8906,-3750.9688,-3745.2568,-3709.6838,-3662.731,-3547.228,-3483.9023,-3416.1602,-3319.7986,-3186.4954,-3047.4297,-2923.9526,-2789.8933,-2697.2073,-2575.168,-2455.9043,-2343.712,-2198.568,-2046.8339,-1938.778,-1812.0316,-1696.5464,-1579.2755,-1435.7021,-1308.9005,-1178.249,-1087.5336,-965.5856,-831.3151,-675.7832,-513.02606,-384.22446,-255.91638,15.583875,271.22244,692.6003,1053.977,1457.9729,1907.3065,2415.9194,2905.68,3325.8198,3719.2427,4100.2324,4430.0317,4641.2124,4811.2354,4907.6416};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_80()
		{
			double[] value = {4863.5933,4979.127,4921.18,4960.5166,5006.9775,5074.028,5105.6006,4975.4395,4706.7314,4458.325,4238.985,4061.2026,3959.0217,3878.2932,3626.7031,2977.106,2051.3928,1743.8198,1248.8859,794.72595,339.62668,257.77072,139.58636,80.71341,12.248833,-47.285286,67.88535,208.23863,276.8002,310.3589,291.88904,283.58014,283.01038,347.17444,517.2081,729.35815,-4043.603,-4070.4705,-4073.9968,-4078.2966,-4077.2468,-4066.9426,-4052.811,-4021.4995,-4021.7244,-4032.7427,-4018.263,-4014.885,-4006.7048,-4011.9885,-4001.4739,-3977.9878,-3974.548,-3961.455,-3955.0413,-3946.2659,-3943.9688,-3933.0596,-3931.0242,-3946.6382,-3944.1213,-3941.0972,-3935.5415,-3941.1033,-3936.0908,-3929.3896,-3943.8862,-3974.1235,-3966.7646,-3957.9639,-3950.7644,-3946.1655,-3921.9216,-3898.5215,-3877.9766,-3862.4954,-3852.479,-3860.1992,-3824.569,-3807.4583,-3750.677,-3713.898,-3688.5913,-3655.5312,-3622.9,-3517.6975,-3442.8904,-3362.7048,-3263.3884,-3162.6658,-3094.2715,-2956.8125,-2750.5095,-2616.1675,-2808.124,-2627.1287,-2298.6438,-2192.873,-2084.6873,-1985.0336};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_81()
		{
			double[] value = {-1867.8406,-1746.7611,-1624.8702,-1561.5728,-1486.026,-1373.2622,-1265.6495,-1118.2437,-962.05865,-808.7912,-691.1744,-595.94086,-452.26514,-183.49255,125.73171,444.28198,774.68225,1174.3859,1592.6117,2046.2441,2472.903,2843.1768,3150.043,3453.8103,3669.1013,3896.8142,4050.8152,4224.2686,4485.2676,4712.887,4771.4106,4802.5645,4727.3384,4705.7393,4720.7754,4659.341,4562.8853,4439.473,4308.3716,4147.7217,3900.5066,3478.9878,2982.4983,2306.0056,1762.6737,1416.7522,959.5806,501.78943,293.89114,124.70384,-24.67588,-91.00442,-135.22891,-152.30013,-85.05687,22.93153,72.88253,82.75783,93.97935,73.46619,27.956125,-5.641332,-70.76264,95.45562,-4084.9517,-4086.4705,-4087.558,-4090.482,-4082.9705,-4083.4343,-4078.1562,-4026.1973,-4028.1062,-4045.9443,-4037.6216,-4025.5972,-4021.7673,-4014.4944,-3997.1345,-3994.7979,-3983.1152,-3971.2593,-3969.506,-3969.8743,-3947.4707,-3938.9302,-3936.5942,-3944.8257,-3954.404,-3951.8435,-3935.675,-3952.1501,-3952.0298,-3953.1028,-3938.2598,-4036.7744,-3907.587,-3912.208,-3910.4316,-3911.2668};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_82()
		{
			double[] value = {-3886.0073,-3860.7715,-3856.4937,-3845.395,-3835.5208,-3835.1326,-3802.8562,-3779.8118,-3754.0188,-3690.7908,-3632.9417,-3594.4333,-3530.7893,-3486.4507,-3380.5168,-3307.8777,-3208.7095,-3093.0115,-3095.066,-2825.2156,-2715.6912,-2616.9773,-2520.9058,-2384.4448,-2263.451,-2191.9148,-2121.8086,-2039.844,-1915.2065,-1794.3069,-1727.4463,-1672.5328,-1588.3431,-1490.6652,-1411.0612,-1285.5792,-1105.13,-1002.73315,-928.19464,-786.4444,-619.26654,-383.52832,-103.474846,173.63794,487.3428,891.6885,1244.7507,1580.3346,1899.5522,2169.9348,2427.321,2628.1401,2786.607,2944.736,3039.5676,3227.8574,3627.692,4322.944,4550.163,4510.066,4624.326,4613.678,4649.1865,4608.361,4551.7817,4429.633,4214.111,4060.3193,3611.18,2981.0828,2467.8154,2106.57,1645.3424,985.81445,597.708,419.59045,152.62494,23.196444,-77.10485,-171.03426,-197.71777,-246.44879,-200.2462,-127.81928,-116.04045,-128.94139,-147.49995,-169.14575,-257.12247,-349.31503,-386.36908,-443.3237,-4105.1978,-4103.447,-4100.276,-4096.706,-4089.2864,-4054.2786,-4042.1785,-4055.9507};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_83()
		{
			double[] value = {-4049.9585,-4043.922,-4035.4307,-4032.132,-4027.0454,-4022.0613,-4011.1216,-3997.3694,-3985.7607,-3978.978,-3975.8875,-3973.2986,-3947.2244,-3932.677,-3939.8665,-3943.3135,-3959.5107,-3965.426,-3958.6362,-3959.9526,-3953.356,-3966.0513,-3949.137,-3909.7605,-3897.2317,-3905.3237,-3909.079,-3913.164,-3897.4216,-3869.998,-3858.6138,-3834.5015,-3833.702,-3814.2234,-3765.409,-3735.7488,-3726.508,-3674.8176,-3611.0115,-3547.5652,-3486.1958,-3413.3303,-3318.6436,-3221.5603,-3154.6743,-3055.7954,-2932.2803,-2813.9417,-2696.0535,-2591.9963,-2484.9268,-2389.4814,-2298.8542,-2219.1785,-2111.4375,-2019.2294,-1930.5721,-1855.1246,-1815.6448,-1781.337,-1693.2866,-1615.1659,-1549.4121,-1429.8488,-1327.358,-1219.478,-1127.744,-995.2341,-829.179,-626.61926,-383.02066,-160.30466,96.25343,403.10672,759.4493,1117.4283,1282.9692,1458.9457,1690.2614,1882.271,1966.5803,2013.2388,2060.101,2107.5303,2262.3838,3079.0022,3775.5105,3903.142,4078.0889,4393.6025,4479.08,4436.9316,4295.1953,4144.304,3689.21,3245.5002,2746.8677,2309.7988,1945.327,1566.1277};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_84()
		{
			double[] value = {1237.3845,813.17035,404.70886,314.56287,173.53398,7.76996,-100.81104,-190.40431,-267.424,-290.63162,-251.44835,-243.30132,-246.48093,-302.60608,-340.75482,-384.77606,-445.71777,-539.6551,-596.08765,-668.83093,-4110.445,-4105.8774,-4101.6455,-4097.9585,-4097.968,-4066.2693,-4060.1482,-4061.9675,-4055.9841,-4047.9097,-4040.9973,-4034.4714,-4025.47,-4024.4216,-4021.1914,-4006.5483,-3989.0735,-3985.1667,-3978.8188,-3969.186,-3952.0957,-3932.418,-3941.389,-3953.1223,-3969.746,-3967.8416,-3972.2527,-3971.7751,-3964.8958,-3974.3533,-3965.9727,-3946.7656,-3941.5034,-3926.571,-3915.0764,-3896.2126,-3877.4722,-3873.2302,-3850.3352,-3828.0532,-3787.5889,-3796.602,-3756.7842,-3742.7512,-3700.4956,-3645.818,-3555.3647,-3525.7976,-3471.002,-3381.275,-3281.9773,-3184.9648,-3115.676,-3031.4617,-2945.899,-2829.1245,-2712.6743,-2600.5034,-2497.6343,-2411.4875,-2310.9353,-2240.697,-2170.4849,-2070.4775,-2020.3958,-2006.6527,-1938.887,-1888.9315,-1805.1202,-1746.968,-1695.8887,-1618.2869,-1489.6008,-1377.9675,-1301.3065,-1202.0237,-1062.074,-885.44104,-663.4921,-481.4191};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_85()
		{
			double[] value = {-300.89465,-17.875967,319.22324,556.21704,661.1831,793.87354,1017.59937,1167.0344,1169.5336,1150.9908,1143.0073,1060.6619,1133.6078,1540.0177,2172.6062,2520.715,2878.3347,3281.6194,3434.8472,3397.5437,3307.8704,3033.0232,2582.8467,2231.3003,1841.0472,1565.6508,1242.9874,962.26843,666.78503,541.91064,371.1449,153.22766,111.95841,-17.655245,-149.01384,-191.66496,-259.63666,-302.51892,-283.67282,-299.3824,-336.2177,-375.96085,-423.0026,-483.9738,-573.5048,-696.9887,-735.0253,-845.2759,-4085.6475,-4098.6104,-4101.0156,-4096.648,-4092.4978,-4090.297,-4078.8086,-4066.9338,-4055.218,-4039.7234,-4030.486,-4023.6624,-4022.0996,-4020.5303,-4013.0999,-4011.0413,-3999.1746,-3987.9133,-3983.6074,-3978.461,-3978.4636,-3961.5413,-3951.7163,-3948.9038,-3970.8472,-3971.0938,-3981.7314,-3981.4614,-3976.0764,-3959.467,-3961.5078,-3942.886,-3939.1582,-3939.0,-3936.597,-3908.5862,-3860.3042,-3859.236,-3838.6584,-3811.7002,-3775.9763,-3758.3699,-3750.0837,-3716.591,-3690.4868,-3611.787,-3551.8127,-3489.5586,-3416.5972,-3343.6887,-3246.5986,-3181.1807};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_86()
		{
			double[] value = {-3104.266,-3030.717,-2926.637,-2850.361,-2747.0461,-2651.049,-2554.919,-2447.5022,-2366.6846,-2314.7031,-2258.1023,-2190.6697,-2133.256,-2110.9285,-2046.9323,-1971.845,-1928.0204,-1858.9967,-1818.4673,-1748.8976,-1653.4976,-1545.2439,-1453.4944,-1346.7571,-1264.4961,-1127.5391,-986.10785,-827.73413,-664.38324,-435.6903,-221.4439,-55.95693,-2.601004,198.32382,374.039,413.4371,375.43027,424.20303,383.31302,379.8296,269.36868,318.38776,740.39343,1289.0487,1696.1718,1996.464,2252.4429,2269.0986,2117.3838,1797.048,1390.996,1245.7505,913.6895,636.34094,498.84955,482.83728,366.31296,269.96118,231.97778,96.01686,-49.601562,-63.44279,-152.63855,-228.0584,-298.5954,-260.48895,-290.0279,-331.732,-326.78406,-368.70248,-422.25836,-503.06366,-581.92755,-717.55237,-804.1575,-885.047,-4104.383,-4100.453,-4094.8047,-4089.9854,-4091.666,-4089.7256,-4091.8193,-4089.296,-4055.6978,-4032.6658,-4033.1287,-4026.342,-4022.5688,-4014.076,-4017.5068,-4000.6643,-3989.4558,-3982.2214,-3980.9536,-3982.4934,-3984.0068,-3982.9924,-3961.2468,-3934.0437};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_87()
		{
			double[] value = {-3958.747,-3985.307,-3995.0215,-3979.798,-3974.6387,-3967.7556,-3946.7402,-3933.8499,-3940.0583,-3933.9685,-3925.5632,-3916.0771,-3889.1165,-3854.745,-3823.8552,-3796.9783,-3757.8823,-3756.0342,-3746.902,-3701.3438,-3637.0781,-3576.64,-3501.8452,-3461.9346,-3414.0154,-3325.2363,-3240.898,-3192.9878,-3110.3076,-3052.8098,-2953.8838,-2833.539,-2761.2134,-2644.1807,-2573.6687,-2507.0461,-2449.9473,-2396.2903,-2329.384,-2262.3787,-2231.3577,-2192.0068,-2127.8289,-2067.3357,-2004.656,-1946.574,-1902.8113,-1809.6047,-1719.2709,-1626.154,-1540.2505,-1516.8822,-1489.1575,-1363.7295,-1244.3942,-1129.2294,-1036.9404,-879.8899,-767.6477,-636.64233,-493.1395,-337.1341,-240.23666,-186.54552,-198.46548,-202.50955,-246.03404,-245.04855,-335.92328,-353.2874,-79.97623,283.7302,650.4953,973.67303,1168.7286,1205.2158,976.0342,809.2407,513.9376,314.77673,184.34825,121.31489,44.145622,46.385605,-0.214708,-23.106438,-78.18649,-44.905064,-142.59615,-254.59032,-264.1348,-274.38425,-316.98227,-351.20145,-293.07758,-306.15506,-327.93063,-333.72638,-370.394,-472.88412};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_88()
		{
			double[] value = {-548.4324,-627.3227,-698.0891,-807.5856,-4108.918,-4102.476,-4096.703,-4080.908,-4057.3347,-4060.6514,-4067.624,-4076.6523,-4040.6382,-4040.9329,-4038.569,-4038.374,-4037.006,-4027.853,-4008.8013,-3986.0703,-3986.35,-3981.069,-3975.5771,-3978.721,-3971.6995,-3974.5276,-3981.2388,-3947.545,-3973.2134,-4004.1316,-3990.9531,-3968.5708,-3975.6936,-3958.009,-3927.932,-3927.146,-3925.072,-3918.3982,-3927.5015,-3899.9114,-3875.0042,-3849.1917,-3811.456,-3786.014,-3758.368,-3737.7695,-3724.0276,-3687.5613,-3594.8545,-3562.7043,-3493.4138,-3436.463,-3387.1235,-3346.6042,-3245.321,-3192.6572,-3112.0588,-3059.2065,-3004.3345,-2878.9873,-2783.4968,-2714.1375,-2656.7427,-2590.1074,-2521.1313,-2457.2964,-2397.2202,-2345.3643,-2310.2698,-2285.906,-2210.3098,-2150.723,-2033.0117,-1964.4691,-1919.7871,-1834.7968,-1747.653,-1695.2892,-1692.2178,-1675.4893,-1637.3494,-1554.1614,-1471.8878,-1377.315,-1334.422,-1246.923,-1181.2144,-1056.5679,-872.52386,-757.2709,-806.1203,-747.81946,-662.1327,-712.17993,-726.3078,-698.3547,-739.2666,-755.5464,-627.6958,-472.6821};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_89()
		{
			double[] value = {-193.05263,38.987965,163.82825,140.8963,93.7179,-164.54488,-262.04324,-348.62762,-406.17407,-324.1782,-300.87244,-212.9625,-231.5206,-255.01797,-259.46402,-275.66727,-309.02136,-432.61447,-469.73215,-417.7585,-427.67554,-408.89764,-388.0491,-328.49026,-290.7548,-312.49316,-349.6912,-418.71432,-507.46277,-552.51514,-635.8127,-717.6732,-4122.013,-4113.085,-4108.5073,-4080.943,-4055.7856,-4069.395,-4071.2017,-4062.794,-4054.0996,-4040.9163,-4043.5771,-4053.572,-4052.149,-4059.4668,-4017.9976,-4001.8562,-3995.4258,-4011.733,-4015.4585,-4014.2927,-4007.3035,-3998.0732,-3989.8267,-3968.413,-3969.67,-3986.7297,-3982.2646,-3979.3726,-3980.3728,-3983.64,-3960.4712,-3931.1392,-3929.606,-3909.3555,-3908.7886,-3863.1162,-3853.3098,-3831.4104,-3787.9363,-3757.9143,-3726.0137,-3704.5603,-3689.3499,-3641.0615,-3555.5486,-3520.4678,-3483.7952,-3430.491,-3367.413,-3304.6375,-3270.5144,-3195.5225,-3125.7175,-3056.1492,-3003.2717,-2928.1086,-2831.8738,-2757.7783,-2678.194,-2637.729,-2607.5537,-2554.2625,-2490.9397,-2434.7498,-2375.8037,-2310.0154,-2266.1963,-2187.8};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_90()
		{
			double[] value = {-2103.0654,-2027.8679,-1970.6097,-1874.4609,-1882.1193,-1836.8086,-1816.5807,-1775.3936,-1729.7885,-1690.1434,-1637.2942,-1587.2015,-1541.1404,-1449.4856,-1400.8037,-1310.288,-1201.1353,-1148.3243,-1157.2412,-1117.7778,-1068.0568,-1017.55286,-1047.7748,-987.92267,-1026.4071,-1011.91943,-877.3322,-808.8723,-687.30054,-555.2034,-543.8738,-580.79065,-576.44293,-753.4886,-805.0045,-745.76245,-724.35913,-730.8136,-621.60767,-533.2047,-445.12283,-387.3563,-371.96173,-383.45847,-410.45407,-432.80347,-472.58493,-529.1893,-544.79803,-486.28528,-427.04,-418.52145,-373.57956,-302.42093,-284.85468,-373.01364,-424.56747,-472.488,-555.8144,-642.2788,-4125.204,-4120.6323,-4120.61,-4100.575,-4087.6465,-4086.0066,-4084.4875,-4064.4858,-4045.1174,-4043.9922,-4051.7173,-4066.4062,-4079.6555,-4057.4268,-4046.9954,-4032.6675,-4021.159,-4033.6914,-4028.713,-4011.8271,-4015.126,-4006.4353,-4002.2239,-3971.2334,-3962.0332,-3968.0452,-3996.2537,-3991.5996,-3971.4802,-3973.8413,-3963.681,-3930.8171,-3923.732,-3908.1133,-3918.1772,-3862.3582,-3806.5276,-3789.916,-3749.6475,-3698.4795};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_91()
		{
			double[] value = {-3697.6797,-3664.7346,-3653.748,-3572.013,-3529.105,-3445.369,-3438.4731,-3415.0962,-3356.3296,-3300.0093,-3247.2239,-3213.333,-3112.8105,-3029.6113,-3000.7012,-2944.837,-2874.8518,-2798.8787,-2741.7505,-2702.5686,-2655.7073,-2600.531,-2541.2395,-2471.8337,-2418.656,-2373.818,-2283.727,-2204.8086,-2135.9678,-2082.2573,-2034.3665,-2012.5739,-1977.7655,-1936.864,-1907.8396,-1877.088,-1821.4786,-1770.0562,-1735.3486,-1697.9695,-1645.8278,-1630.3257,-1585.2621,-1550.0684,-1482.9698,-1459.2074,-1392.515,-1323.5648,-1314.8751,-1236.6357,-1191.7605,-1187.2075,-1168.7258,-1165.4446,-1046.6578,-1016.6073,-992.11035,-914.2076,-1006.0611,-1012.80304,-992.4546,-991.0366,-1034.8915,-930.4719,-924.2965,-953.5397,-898.2722,-792.35223,-644.6028,-518.2584,-444.6612,-430.48965,-466.66437,-476.89346,-432.1106,-482.69418,-588.5095,-576.9159,-541.2413,-538.2574,-481.1702,-322.40167,-193.8643,-177.1539,-330.1828,-387.5454,-494.55212,-585.7565,-4127.1016,-4122.9507,-4124.4043,-4107.9756,-4087.69,-4082.9272,-4085.9287,-4074.082,-4046.8396,-4053.2122,-4072.7327,-4071.4375};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_92()
		{
			double[] value = {-4065.039,-4049.8748,-4053.7874,-4046.3906,-4042.0723,-4018.2551,-4018.425,-4015.098,-4007.034,-3998.4749,-3983.5327,-3966.753,-3972.1077,-3967.4,-3968.1294,-3976.9062,-3944.008,-3942.9382,-3923.047,-3907.3748,-3897.3337,-3883.196,-3888.021,-3845.9329,-3798.7231,-3772.4102,-3724.1833,-3699.2498,-3668.7407,-3642.0654,-3603.743,-3564.0315,-3486.922,-3456.9595,-3439.6062,-3380.6785,-3332.7678,-3273.2583,-3205.049,-3151.9714,-3114.0735,-3011.5403,-2969.4102,-2930.5183,-2881.0042,-2830.3345,-2796.2556,-2741.21,-2687.888,-2627.003,-2559.6624,-2499.2837,-2424.9016,-2366.587,-2289.658,-2240.538,-2196.0093,-2143.4778,-2085.6394,-2074.66,-2039.418,-2010.86,-1980.3823,-1956.389,-1904.1383,-1855.6798,-1804.5082,-1775.8499,-1744.9469,-1713.1139,-1683.878,-1645.6694,-1624.7429,-1547.6711,-1507.9376,-1479.6454,-1429.1365,-1392.9457,-1332.3774,-1335.8768,-1305.1979,-1231.6018,-1166.4271,-1179.3262,-1182.2704,-1147.4136,-1172.8014,-1197.3508,-1179.8733,-1146.889,-1141.2347,-1074.9011,-1074.2957,-1026.2778,-1023.61835,-914.0869,-760.6386,-623.3366,-553.3289,-495.36533};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_93()
		{
			double[] value = {-434.16888,-612.8567,-468.07706,-490.06265,-591.49396,-664.1021,-619.7194,-613.0847,-619.9193,-526.7036,-240.96165,-188.0037,-243.74498,-379.41263,-505.59854,-592.08765,-4110.539,-4125.082,-4127.457,-4106.5127,-4085.37,-4080.1716,-4086.4812,-4083.2095,-4072.5605,-4066.9148,-4075.5342,-4071.5786,-4074.8403,-4077.4956,-4078.4656,-4071.4878,-4047.7307,-4016.6003,-3996.532,-4009.4875,-3995.7556,-3986.3792,-3986.9927,-3978.461,-4003.3774,-3995.9565,-3965.0667,-3954.9233,-3937.2488,-3929.911,-3909.5906,-3877.4182,-3868.8574,-3828.6638,-3850.819,-3822.4475,-3773.1824,-3761.646,-3712.5007,-3682.6086,-3655.1257,-3643.723,-3590.9636,-3526.256,-3481.8953,-3447.5852,-3396.5002,-3344.4595,-3279.7888,-3233.377,-3199.8088,-3134.543,-3075.9868,-3026.5874,-2955.3,-2880.947,-2874.4568,-2933.3357,-2781.9844,-2746.4868,-2688.7466,-2627.7842,-2572.2659,-2516.4788,-2457.3555,-2388.0444,-2349.5195,-2296.7258,-2278.6323,-2240.1184,-2181.4133,-2142.9849,-2120.739,-2086.6274,-2041.8516,-2011.462,-1972.3567,-1920.0415,-1892.4447,-1860.6034,-1797.5425,-1783.1898,-1772.9752,-1754.6647};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_94()
		{
			double[] value = {-1734.4022,-1657.0549,-1626.8595,-1582.7247,-1532.7297,-1484.8773,-1447.3564,-1390.3826,-1324.276,-1295.8298,-1285.0248,-1277.1958,-1285.9854,-1296.3226,-1301.1555,-1315.918,-1303.4436,-1262.1415,-1230.7863,-1184.6475,-1167.8558,-1119.7307,-1102.7814,-978.0228,-853.0411,-763.6805,-687.72974,-629.88354,-573.4132,-552.4425,-530.434,-515.50104,-595.038,-707.37054,-692.7819,-660.7075,-674.68634,-694.2964,-638.33655,-545.4159,-511.84247,-524.49866,-651.32837,-804.2545,-4129.123,-4126.11,-4117.972,-4094.1877,-4067.5505,-4087.9226,-4086.499,-4084.939,-4084.7988,-4091.1707,-4086.8335,-4092.4304,-4095.1921,-4089.4338,-4089.7837,-4106.325,-4067.4563,-4033.7207,-3986.2014,-3996.2239,-3992.3186,-3987.7698,-3999.1836,-4002.7317,-4004.0999,-4012.5876,-3996.3708,-3967.7217,-3933.6174,-3927.5005,-3916.6963,-3897.2117,-3882.7427,-3850.9531,-3815.3604,-3797.026,-3779.994,-3748.3323,-3699.8096,-3665.8726,-3643.1848,-3622.189,-3575.4878,-3512.4055,-3439.458,-3384.6638,-3348.4307,-3292.023,-3251.273,-3217.1777,-3175.9106,-3141.7122,-3078.5645,-3043.7886,-3016.8303,-2944.9395};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_95()
		{
			double[] value = {-2828.131,-2879.7976,-2825.2402,-2787.4927,-2729.155,-2684.114,-2635.6204,-2577.1606,-2519.2559,-2467.225,-2433.407,-2393.435,-2372.6697,-2325.4172,-2255.7637,-2230.8792,-2193.9382,-2144.3752,-2121.0654,-2082.2231,-2118.9915,-2020.0151,-1962.3029,-1948.0009,-1895.345,-1864.7902,-1859.135,-1842.5792,-1816.1014,-1755.2344,-1706.9827,-1667.7397,-1601.0299,-1547.7612,-1519.5686,-1476.2343,-1422.0416,-1412.321,-1397.861,-1405.0613,-1405.4952,-1442.9692,-1462.1808,-1455.935,-1407.5267,-1342.6458,-1307.9851,-1260.6285,-1248.8981,-1223.0859,-1154.7572,-1023.08594,-930.61456,-889.197,-824.8187,-743.12476,-689.3355,-635.0619,-635.33466,-603.9989,-693.945,-752.6417,-817.8555,-792.1449,-728.1954,-768.8823,-832.12164,-910.86664,-865.69293,-863.9442,-910.4124,-1053.5447,-4139.8687,-4123.649,-4112.337,-4105.7734,-4106.9907,-4108.326,-4103.3755,-4105.1313,-4106.724,-4124.5938,-4126.7505,-4106.072,-4093.531,-4092.359,-4095.2793,-4100.786,-4078.7402,-4048.8774,-3997.7263,-3976.6448,-4006.9563,-3988.6096,-3988.353,-3992.2065,-3983.8245,-3927.913,-3898.2722,-3919.455};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_96()
		{
			double[] value = {-3931.6704,-3921.5576,-3919.526,-3888.999,-3880.4238,-3842.6973,-3773.6848,-3776.1152,-3772.9102,-3729.1982,-3681.7607,-3651.4514,-3627.1868,-3597.7588,-3544.7942,-3487.0198,-3432.2751,-3381.844,-3339.0112,-3300.3225,-3268.2788,-3227.946,-3177.078,-3118.0347,-3092.0532,-3066.9536,-3033.2632,-2983.8577,-2932.1763,-2900.1863,-2864.88,-2833.4707,-2784.3386,-2740.1265,-2682.4988,-2643.4385,-2610.5393,-2586.2925,-2528.1575,-2493.5103,-2441.9883,-2375.8188,-2344.6362,-2314.8696,-2281.0906,-2237.8667,-2237.4302,-2192.6938,-2136.629,-2104.595,-2063.2793,-2037.6638,-1998.2445,-1954.3586,-1931.2125,-1920.3973,-1873.3438,-1807.9865,-1778.8787,-1731.1725,-1684.518,-1669.6696,-1619.5527,-1570.3977,-1548.7981,-1536.9237,-1524.53,-1513.8448,-1540.4622,-1571.5824,-1570.8893,-1553.5614,-1531.4341,-1465.0195,-1449.3833,-1435.3711,-1345.9006,-1320.5251,-1226.7422,-1130.243,-1040.5675,-1015.12756,-944.7595,-880.8387,-798.8546,-783.3365,-787.58295,-803.87976,-807.0684,-864.5151,-852.0509,-875.7933,-868.0865,-918.10736,-985.5894,-1045.0918,-1088.6519,-1177.2206,-1203.841,-1268.4039};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_97()
		{
			double[] value = {-4163.458,-4135.1367,-4116.8906,-4093.4414,-4115.0273,-4128.031,-4125.932,-4114.7607,-4119.099,-4123.809,-4118.038,-4115.125,-4099.2188,-4098.58,-4104.493,-4095.7188,-4084.4172,-4057.1008,-4028.8599,-4005.995,-4006.3745,-4031.22,-4028.9207,-3974.2793,-3956.721,-3929.7727,-3889.1287,-3905.9434,-3933.288,-3907.9749,-3907.5198,-3875.5107,-3878.356,-3853.4177,-3788.7327,-3747.5415,-3750.4785,-3713.3806,-3670.9968,-3641.2407,-3606.0576,-3583.415,-3483.5842,-3434.9158,-3378.7412,-3305.5112,-3279.2356,-3284.2434,-3243.094,-3222.368,-3205.5867,-3153.7368,-3122.3865,-3089.0312,-3052.4094,-3023.6057,-2983.203,-2940.49,-2892.071,-2862.185,-2815.721,-2748.148,-2717.8296,-2695.0566,-2664.654,-2632.2607,-2594.6318,-2558.8418,-2500.1006,-2458.9695,-2405.2576,-2386.317,-2352.5415,-2315.4873,-2287.9307,-2231.7568,-2167.4756,-2148.5166,-2128.3887,-2106.3682,-2079.46,-2052.1543,-2001.8755,-1947.8418,-1911.2347,-1878.4739,-1839.1855,-1836.2913,-1829.0364,-1784.6199,-1725.7052,-1689.8032,-1668.3512,-1644.4386,-1646.8353,-1639.2568,-1671.9962,-1673.4794,-1684.6349,-1667.5685};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_98()
		{
			double[] value = {-1652.0187,-1619.1326,-1614.8818,-1587.8679,-1462.6593,-1458.9025,-1403.5415,-1353.1477,-1194.0458,-1147.0525,-1112.2443,-1024.6255,-931.74176,-898.6022,-907.9892,-960.76965,-948.3159,-962.6294,-929.4912,-971.80566,-1020.2658,-1040.193,-1085.9287,-1191.1198,-1252.6431,-1330.3455,-1468.6855,-1568.237,-4173.5815,-4147.7705,-4139.257,-4122.6865,-4133.9663,-4134.3135,-4130.615,-4131.303,-4131.2246,-4125.168,-4117.899,-4120.4106,-4042.4712,-4007.428,-4048.8726,-4084.7114,-4070.7751,-4049.1553,-4058.2073,-4071.158,-4046.2852,-4061.3823,-4041.542,-3971.6301,-3914.4998,-3948.3943,-3957.7236,-3937.9556,-3940.5383,-3933.34,-3971.6064,-3881.1372,-3848.3286,-3843.2236,-3827.218,-3769.4219,-3742.45,-3714.2505,-3660.7712,-3631.6082,-3622.008,-3595.1707,-3516.4836,-3318.814,-3221.3901,-3217.154,-3184.7222,-3102.534,-3120.8347,-3208.7756,-3227.057,-3227.5725,-3194.6406,-3124.386,-3084.02,-3056.1978,-3006.2883,-2977.7886,-2951.3013,-2914.4407,-2899.5994,-2846.6106,-2796.111,-2754.497,-2712.3127,-2691.3652,-2651.4114,-2611.8103,-2555.0972,-2518.2976,-2498.0676,-2463.1428};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_99()
		{
			double[] value = {-2416.6196,-2366.6887,-2297.1265,-2253.3542,-2218.6978,-2198.1477,-2177.4546,-2162.3943,-2147.6404,-2099.1104,-2032.0011,-1999.7336,-1976.5863,-1958.8141,-1933.837,-1900.4668,-1895.1504,-1863.0048,-1842.9156,-1820.7463,-1776.9786,-1733.945,-1781.4995,-1839.2118,-1807.9774,-1796.28,-1825.1598,-1811.2327,-1768.9906,-1752.902,-1736.434,-1666.5886,-1587.0565,-1630.6296,-1567.608,-1493.9287,-1364.4138,-1276.9928,-1247.1832,-1161.0132,-1113.7012,-1050.4702,-1035.3096,-1012.6844,-1052.7169,-1079.0214,-1102.7295,-1088.0764,-1146.661,-1169.7336,-1179.3978,-1275.4232,-1351.9039,-1449.2941,-1556.8328,-1678.1125,-4198.5474,-4179.397,-4170.2686,-4160.1797,-4155.4136,-4149.4155,-4122.1724,-4129.161,-4131.2393,-4128.5024,-4115.0615,-4091.7163,-4035.2056,-3982.99,-4009.1423,-4054.3906,-4051.0178,-4026.1677,-4033.4229,-4034.0212,-4038.9163,-4034.4497,-4021.4778,-3984.5728,-3947.799,-3941.2856,-3957.3948,-3946.013,-3947.3262,-3907.958,-3875.4507,-3835.94,-3806.8606,-3829.9802,-3831.7227,-3780.0322,-3746.5361,-3713.678,-3676.0588,-3642.475,-3616.466,-3605.4639,-3523.3066,-3338.8535};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_100()
		{
			double[] value = {-3521.6716,-4445.317,-4532.05,-4354.3086,-3234.7527,-3030.0754,-3197.429,-3230.0554,-3225.4204,-3164.1697,-3129.832,-3102.4373,-3073.3628,-3035.431,-3012.5376,-2982.0383,-2946.182,-2918.2236,-2885.175,-2857.7947,-2829.9238,-2789.922,-2738.5178,-2681.7812,-2629.4675,-2587.196,-2562.2913,-2521.8147,-2472.7427,-2416.1494,-2366.3408,-2331.8496,-2304.7185,-2275.4902,-2243.8894,-2232.6553,-2205.7415,-2148.9465,-2096.1604,-2083.3665,-2062.5144,-2047.8022,-2020.4607,-1979.1433,-1987.6671,-1952.3213,-1928.7538,-1923.493,-1920.472,-1928.0598,-1926.5378,-1953.7725,-1941.1854,-1915.3585,-1919.7657,-1930.0,-1931.7039,-1892.2819,-1838.2893,-1794.3748,-1733.0922,-1718.3953,-1689.3345,-1632.5104,-1529.2583,-1443.2897,-1412.0532,-1334.3594,-1281.3732,-1235.7424,-1229.8031,-1193.0719,-1231.1384,-1275.0647,-1273.0842,-1231.0549,-1255.7465,-1280.7936,-1317.3259,-1371.0928,-1452.4614,-1564.0785,-1666.9968,-1780.0933,-4202.382,-4190.505,-4188.8335,-4180.0576,-4178.399,-4149.8267,-4115.2915,-4130.8193,-4128.1587,-4125.907,-4120.541,-4088.2896,-4063.195,-4044.6519,-4004.5745,-4022.5032};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_101()
		{
			double[] value = {-4038.1497,-4021.7014,-4012.4578,-4003.051,-4027.3896,-4033.4006,-4009.0327,-3985.9155,-3981.086,-3958.2646,-3960.6062,-3954.7996,-3945.647,-3908.6938,-3865.4595,-3849.2397,-3852.4617,-3837.708,-3811.3838,-3800.2095,-3740.6345,-3714.1003,-3655.1782,-3670.8186,-3659.0273,-3636.8284,-3522.3176,-3398.1003,-3751.205,-4881.561,-4869.039,-4660.3936,-3331.7117,-2995.8838,-3165.7378,-3213.6052,-3246.9077,-3210.56,-3182.8018,-3163.6897,-3125.3174,-3089.4087,-3031.3806,-3009.484,-2995.0513,-2988.1345,-2952.886,-2935.487,-2910.9832,-2875.6003,-2808.5605,-2747.5732,-2710.419,-2674.7444,-2617.968,-2582.494,-2538.2585,-2494.0027,-2462.9536,-2443.9053,-2420.5996,-2346.861,-2308.7117,-2274.0513,-2231.8088,-2212.6104,-2178.1953,-2178.474,-2154.103,-2114.1033,-2099.1184,-2088.3545,-2089.6934,-2059.2922,-2021.5891,-2042.7003,-2041.5382,-2044.1667,-2049.916,-2033.242,-2027.3217,-2029.6846,-2017.7019,-2041.8186,-2049.1655,-2004.208,-1952.8151,-1916.4661,-1855.7637,-1813.386,-1847.7029,-1797.4891,-1736.8993,-1628.2731,-1565.8646,-1554.5125,-1508.0192,-1445.3306,-1418.3157,-1396.28};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_102()
		{
			double[] value = {-1409.494,-1456.7405,-1376.7201,-1362.6777,-1343.52,-1348.1981,-1346.9691,-1424.4656,-1517.7234,-1645.0442,-1742.3605,-1860.5713,-4208.2563,-4194.8633,-4194.7627,-4200.871,-4197.451,-4207.9917,-4118.7246,-4104.3677,-4134.3525,-4136.151,-4130.1807,-4126.5195,-4076.9155,-4073.9102,-4044.9646,-4039.1243,-4027.902,-4026.4666,-4010.7168,-4029.1687,-4038.9602,-4014.8933,-4025.9138,-3995.4875,-3986.9487,-3977.2397,-3941.6936,-3943.568,-3917.3271,-3902.563,-3857.8264,-3867.6897,-3860.1042,-3839.1533,-3830.081,-3813.4944,-3773.5876,-3728.616,-3693.911,-3673.2224,-3679.546,-3670.4128,-3598.7698,-3480.6082,-3363.171,-3452.2385,-3555.8567,-3274.7588,-3125.5408,-3212.6755,-3254.9797,-3289.0527,-3264.1099,-3236.7224,-3212.889,-3203.3254,-3178.0977,-3134.1262,-3089.055,-3073.7766,-3037.2012,-3010.9043,-2998.9976,-2989.3787,-2965.2832,-2933.382,-2873.6213,-2815.1177,-2767.3928,-2720.846,-2687.4878,-2662.107,-2641.2097,-2608.4546,-2558.9612,-2511.1536,-2455.5945,-2408.1333,-2361.5945,-2330.3237,-2334.088,-2310.2283,-2282.1228,-2247.878,-2222.5898,-2213.8013,-2203.9893,-2192.764};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_103()
		{
			double[] value = {-2186.2124,-2171.4932,-2136.9265,-2147.8262,-2155.1426,-2149.3933,-2153.988,-2145.7417,-2126.6611,-2116.7993,-2157.0671,-2168.6592,-2136.4988,-2109.6187,-2083.7605,-2061.0056,-1989.5366,-2032.9835,-2029.4982,-1942.2955,-1890.0121,-1826.7424,-1771.5583,-1754.0128,-1705.613,-1647.5607,-1599.4066,-1554.5223,-1559.9097,-1595.3496,-1562.2698,-1488.7915,-1517.4554,-1537.2277,-1575.0315,-1610.2671,-1603.1313,-1722.3513,-1855.747,-1977.2018,-4224.45,-4209.126,-4206.455,-4216.4707,-4222.562,-4209.0723,-4111.134,-4126.287,-4148.1426,-4151.004,-4143.628,-4141.763,-4115.008,-4106.32,-4066.6162,-4036.6147,-4030.0186,-4031.7415,-4025.3503,-4026.1985,-4004.1538,-3971.5671,-3988.379,-3997.9724,-3983.0298,-3974.9443,-3947.7979,-3929.76,-3912.8357,-3899.436,-3850.7432,-3851.489,-3863.103,-3853.433,-3823.5945,-3801.1204,-3802.565,-3766.1023,-3709.9546,-3677.1033,-3671.6348,-3643.3032,-3607.011,-3541.475,-3482.4656,-3429.681,-3322.391,-3348.9177,-3397.5852,-3378.906,-3345.4531,-3317.3254,-3278.4902,-3261.4329,-3250.8909,-3241.4924,-3220.8416,-3189.7168,-3138.9822,-3121.0435};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_104()
		{
			double[] value = {-3090.524,-3064.7498,-3053.161,-3021.8354,-2994.3674,-2971.287,-2936.435,-2888.9895,-2844.111,-2816.0632,-2794.6382,-2769.924,-2740.1887,-2679.2456,-2615.7485,-2575.5645,-2549.6394,-2510.0232,-2463.3386,-2469.2476,-2465.793,-2430.1562,-2393.0847,-2363.8784,-2344.8542,-2347.585,-2330.0833,-2318.2114,-2298.61,-2285.7834,-2261.6926,-2282.7961,-2273.4204,-2263.6982,-2272.3984,-2282.0317,-2230.6003,-2238.0872,-2276.8474,-2294.9421,-2265.086,-2236.5085,-2206.8242,-2165.5786,-2159.8315,-2185.0842,-2174.7654,-2073.9458,-2049.4258,-1983.1494,-1897.5537,-1902.0557,-1856.6276,-1812.9294,-1767.7485,-1742.5691,-1696.1799,-1667.161,-1713.5577,-1671.6726,-1666.1947,-1690.7959,-1756.2227,-1791.321,-1830.5415,-1889.3859,-1990.515,-2071.252,-4224.703,-4212.7905,-4210.523,-4224.3916,-4231.8013,-4209.8,-4117.816,-4083.1553,-4132.2856,-4159.7485,-4173.501,-4175.1655,-4118.586,-4118.641,-4115.78,-4052.2708,-4048.1462,-4031.902,-4043.7673,-4031.6204,-3985.9297,-3946.9846,-3976.0417,-3983.2249,-3973.4697,-3987.6997,-3964.2556,-3921.5854,-3914.0579,-3916.801,-3865.8423,-3846.7898};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_105()
		{
			double[] value = {-3857.9902,-3861.3462,-3834.2363,-3772.8362,-3792.6858,-3742.5496,-3716.4353,-3698.0974,-3687.9675,-3668.0486,-3649.9045,-3623.214,-3545.4104,-3470.9868,-3455.9805,-3437.624,-3423.6748,-3403.701,-3354.4282,-3330.5142,-3281.0105,-3282.7864,-3288.9526,-3277.017,-3256.4517,-3214.7932,-3183.607,-3182.2854,-3156.9182,-3123.4534,-3095.9434,-3060.4248,-3019.952,-3002.504,-2977.8499,-2962.6887,-2939.5903,-2901.5347,-2864.8591,-2828.2483,-2790.3062,-2742.067,-2709.591,-2666.8528,-2634.6582,-2597.381,-2604.0947,-2600.352,-2584.8882,-2529.702,-2499.4114,-2483.0647,-2463.0015,-2463.533,-2445.272,-2433.2856,-2415.5085,-2393.3499,-2360.6455,-2372.172,-2379.0542,-2398.649,-2390.7112,-2365.4946,-2357.1653,-2364.5525,-2361.0518,-2377.545,-2362.773,-2367.9446,-2345.1672,-2289.0598,-2263.389,-2300.1782,-2291.9338,-2241.111,-2211.41,-2131.4346,-2062.2517,-2018.6814,-2017.2133,-1977.2277,-1934.5372,-1900.2451,-1880.4988,-1858.0255,-1852.0018,-1823.9393,-1842.8541,-1840.8792,-1871.8029,-1928.5514,-1992.7699,-2058.9646,-2130.4329,-2233.464,-4227.286,-4226.643,-4205.3667,-4217.315};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_106()
		{
			double[] value = {-4226.3486,-4211.5054,-4194.0513,-4100.5645,-4101.1943,-4135.557,-4164.897,-4167.2607,-4151.035,-4131.184,-4139.9893,-4075.365,-4026.308,-4031.2722,-4053.0457,-4062.1274,-4068.311,-4025.0193,-4025.1897,-4017.6428,-3979.8105,-3993.93,-3988.3696,-3937.3826,-3944.9192,-3977.406,-3909.5498,-3856.82,-3864.4756,-3860.43,-3841.7974,-3807.5613,-3783.3523,-3761.9888,-3747.1123,-3768.2925,-3738.9165,-3701.2349,-3680.8867,-3658.9106,-3606.2795,-3513.5703,-3512.9558,-3507.7769,-3451.3235,-3441.4102,-3415.842,-3379.12,-3358.222,-3327.788,-3319.365,-3321.246,-3290.9373,-3274.3035,-3262.1157,-3231.3987,-3199.2454,-3164.797,-3123.6836,-3083.5122,-3047.8547,-3036.137,-3025.6245,-3005.6484,-2969.7354,-2944.8284,-2928.7173,-2902.8718,-2869.925,-2840.1487,-2797.2034,-2774.4531,-2741.114,-2716.763,-2740.0964,-2715.863,-2684.3606,-2643.6665,-2625.3176,-2600.318,-2587.3274,-2596.2183,-2576.6504,-2535.2874,-2513.1213,-2493.2805,-2500.2256,-2483.5178,-2484.2825,-2485.7937,-2461.1833,-2455.2222,-2460.311,-2460.1394,-2463.2212,-2476.7507,-2506.8376,-2481.963,-2462.336,-2439.9792};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_107()
		{
			double[] value = {-2426.861,-2441.0913,-2440.4868,-2389.5723,-2345.7048,-2261.2004,-2202.8035,-2146.3977,-2161.1255,-2120.4153,-2088.568,-2058.7654,-2060.4062,-2029.0835,-2046.1532,-2034.344,-2053.9944,-2039.512,-2078.4512,-2087.728,-2176.9683,-2256.5247,-2339.7478,-2417.9048,-4226.555,-4246.043,-4219.205,-4220.7554,-4212.783,-4205.749,-4208.5405,-4123.8853,-4079.6255,-4139.462,-4160.1333,-4161.9834,-4187.808,-4148.857,-4139.9785,-4127.7896,-4050.9377,-4014.6409,-4026.001,-4102.9834,-4101.213,-4066.5117,-4074.8813,-4042.5315,-3991.7588,-4015.13,-4018.6733,-3986.8584,-4013.6594,-3965.6646,-3940.276,-3907.9722,-3863.8032,-3849.1763,-3831.5027,-3847.9087,-3836.1516,-3804.218,-3795.4685,-3760.7874,-3768.723,-3766.171,-3706.595,-3681.148,-3656.8276,-3622.6667,-3595.963,-3546.473,-3540.131,-3494.291,-3467.0696,-3462.5645,-3442.3748,-3407.6394,-3388.9644,-3369.2854,-3341.688,-3298.8066,-3298.3845,-3277.3003,-3243.8833,-3204.4387,-3169.8645,-3144.5806,-3111.7305,-3089.7083,-3068.938,-3058.1912,-3049.0005,-3050.511,-3031.8289,-3006.4912,-2970.1667,-2949.6597,-2929.9744,-2903.0686};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_108()
		{
			double[] value = {-2859.322,-2862.308,-2872.5046,-2816.3577,-2781.9412,-2766.0889,-2747.062,-2732.7698,-2739.9868,-2734.3174,-2689.052,-2653.0662,-2633.056,-2616.6619,-2605.105,-2581.1628,-2590.5513,-2585.4053,-2574.1243,-2595.9504,-2609.9927,-2608.9268,-2596.1326,-2597.7207,-2619.158,-2607.3826,-2603.735,-2603.7021,-2570.6448,-2588.7454,-2560.3113,-2485.7156,-2596.821,-2377.3594,-2353.3503,-2308.391,-2291.7012,-2279.5222,-2245.6677,-2243.8833,-2236.318,-2198.6533,-2202.2903,-2196.187,-2186.607,-2228.008,-2335.7212,-2332.1658,-2379.5806,-2461.8237,-2551.5227,-2619.5833,-4227.271,-4237.668,-4261.297,-4244.823,-4249.135,-4209.938,-4210.7173,-4195.3403,-4118.8555,-4162.377,-4172.5884,-4165.4033,-4157.1167,-4149.5063,-4158.0967,-4150.3247,-4078.2695,-4029.8687,-4042.536,-4092.271,-4084.9043,-4081.4944,-4057.1934,-4064.0232,-4057.3572,-4062.659,-4041.4146,-4019.2542,-4010.0417,-3993.2388,-3970.8286,-3956.6738,-3911.8303,-3886.798,-3877.808,-3851.442,-3835.9556,-3819.9458,-3794.4177,-3776.426,-3755.2944,-3747.2327,-3715.4167,-3678.4302,-3670.0447,-3656.8616,-3626.0618,-3582.0405};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_109()
		{
			double[] value = {-3561.8145,-3553.63,-3520.9111,-3501.1648,-3501.7153,-3475.7268,-3436.8264,-3422.5928,-3397.426,-3372.669,-3332.6238,-3316.8708,-3297.4165,-3268.1294,-3224.2832,-3198.7065,-3167.1821,-3136.858,-3124.7908,-3131.3955,-3130.5898,-3121.1265,-3099.0664,-3089.1165,-3077.6301,-3073.6243,-3050.24,-3014.7568,-2999.0498,-2974.7725,-2962.3018,-2940.2114,-2916.8281,-2900.0876,-2885.1733,-2876.91,-2869.1516,-2855.4119,-2817.1882,-2785.621,-2758.3687,-2750.533,-2845.5908,-2738.489,-2741.5347,-2737.0723,-2745.7886,-2759.8567,-2760.6362,-2795.8577,-2752.3042,-2733.0051,-2739.7166,-2736.834,-2736.1833,-2746.4097,-2743.4497,-2735.7935,-2704.8628,-2652.3237,-2621.8884,-2570.724,-2524.9216,-2471.482,-2446.369,-2453.459,-2432.3225,-2434.7568,-2391.4724,-2359.1821,-2376.957,-2391.8203,-2429.8906,-2483.3809,-2593.1016,-2605.8748,-2624.3372,-2676.3809,-2764.1187,-2856.4016,-4234.313,-4250.6514,-4263.649,-4265.139,-4265.057,-4200.07,-4214.877,-4225.692,-4169.8813,-4163.3774,-4187.0527,-4165.368,-4148.2227,-4155.8364,-4146.3276,-4162.881,-4154.496,-4070.8848,-4078.106,-4105.193};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_110()
		{
			double[] value = {-4095.724,-4099.8955,-4073.0535,-4060.1655,-4065.3657,-4066.4163,-4062.0962,-4032.1157,-4029.6633,-3999.3323,-3995.8828,-3978.2087,-3933.5073,-3911.8853,-3903.047,-3875.1057,-3848.929,-3828.1455,-3814.549,-3777.1982,-3746.5444,-3748.3093,-3752.8208,-3780.2197,-3819.275,-3708.194,-3648.6758,-3623.1917,-3599.5967,-3574.481,-3561.4978,-3550.7483,-3532.2598,-3515.5234,-3489.0125,-3447.5242,-3427.5752,-3405.5498,-3377.1777,-3350.2954,-3330.8667,-3310.385,-3281.83,-3263.8958,-3243.5718,-3208.0537,-3213.1172,-3178.6084,-3194.2332,-3175.108,-3165.2483,-3164.7012,-3159.3425,-3144.8728,-3134.3486,-3094.4756,-3080.9534,-3077.4302,-3068.017,-3058.817,-3042.8364,-3026.6985,-3016.2776,-3008.0967,-2999.2622,-2976.3135,-2951.815,-2917.8809,-2900.3557,-2905.8877,-2919.005,-2896.456,-2902.473,-2899.2913,-2904.9868,-2909.7468,-2878.6375,-2865.7495,-2840.0386,-2820.2468,-2798.7224,-2841.2314,-2864.9617,-2850.153,-2853.5005,-2856.6,-2826.9265,-2768.1497,-2768.894,-2773.3704,-2737.3489,-2661.3237,-2643.533,-2652.8655,-2664.2659,-2634.9136,-2576.1064,-2554.7112,-2574.5674,-2624.9744};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_111()
		{
			double[] value = {-2655.9749,-2718.332,-2815.394,-2858.8892,-2857.8733,-2918.966,-2982.5647,-3002.9897,-4230.1304,-4255.3706,-4248.0317,-4257.3003,-4245.223,-4196.493,-4206.3276,-4227.619,-4204.551,-4190.5674,-4199.7793,-4172.304,-4146.0366,-4152.346,-4199.51,-4161.916,-4156.8833,-4131.6553,-4106.8345,-4106.498,-4103.028,-4106.35,-4095.0225,-4061.463,-4068.8555,-4041.6887,-4005.5996,-4024.206,-4016.053,-3986.431,-3999.7502,-4002.9995,-3974.0286,-3947.1724,-3951.6313,-3906.155,-3872.7825,-3845.0586,-3828.3452,-3807.1343,-3792.9595,-3777.635,-3768.9294,-3816.9602,-3818.4683,-3701.053,-3643.916,-3669.2644,-3656.8997,-3631.3906,-3597.9417,-3591.4673,-3566.4087,-3529.182,-3507.9814,-3495.4849,-3464.992,-3428.0635,-3440.806,-3405.158,-3407.1223,-3384.8252,-3359.9456,-3350.9336,-3341.5999,-3321.0618,-3304.729,-3289.606,-3267.7124,-3251.8794,-3237.2136,-3236.4456,-3222.95,-3205.9539,-3180.7917,-3161.9426,-3156.9805,-3148.6519,-3140.3276,-3136.528,-3127.989,-3121.7317,-3105.7,-3098.7437,-3106.0518,-3097.2134,-3078.7615,-3064.71,-3057.9917,-3052.0344,-3048.8584,-3045.8906};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_112()
		{
			double[] value = {-3049.7058,-3056.4126,-3059.046,-3034.8376,-3011.4248,-2996.8623,-2980.3184,-2993.3752,-2951.3152,-2966.3716,-2974.8198,-2968.6204,-2988.5325,-3004.8374,-2961.9705,-2928.2969,-2947.9412,-2946.379,-2967.151,-2862.3403,-2836.7085,-2861.9714,-2884.7153,-2867.8103,-2826.0647,-2825.9749,-2837.5576,-2854.7349,-2866.6643,-2931.9722,-2988.217,-3032.3782,-3045.6582,-3060.0125,-3084.9504,-3094.4805,-4221.069,-4216.623,-4221.7983,-4234.5176,-4245.9165,-4217.5947,-4190.811,-4192.573,-4179.79,-4170.1343,-4196.5767,-4207.782,-4196.714,-4196.254,-4213.9214,-4193.0063,-4164.0107,-4150.2827,-4157.251,-4155.9326,-4108.9243,-4116.763,-4132.422,-4133.8105,-4098.5146,-4068.561,-4074.4138,-4060.7275,-4018.2192,-4002.987,-4024.611,-4015.704,-3998.7478,-3970.5984,-3954.3337,-3940.1628,-3910.1978,-3868.831,-3846.7473,-3841.4885,-3813.7634,-3799.432,-3797.0142,-3796.4424,-3732.2817,-3764.9646,-3736.604,-3719.0454,-3683.1765,-3683.1873,-3670.5322,-3638.764,-3613.899,-3576.0942,-3564.3442,-3546.3818,-3524.4868,-3493.417,-3461.8452,-3466.465,-3478.2922,-3463.519,-3449.0776,-3435.5984};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_113()
		{
			double[] value = {-3418.2124,-3398.9658,-3383.0806,-3359.0022,-3314.1665,-3321.297,-3315.967,-3309.837,-3301.7844,-3277.7708,-3260.7827,-3245.122,-3230.8423,-3221.7502,-3211.266,-3193.9731,-3187.6309,-3182.4995,-3182.6638,-3185.922,-3184.0833,-3180.7039,-3172.5913,-3164.9456,-3152.874,-3164.1873,-3164.8413,-3167.6978,-3172.23,-3172.3254,-3161.8813,-3147.1912,-3140.7368,-3132.7532,-3128.6028,-3111.062,-3113.934,-3109.8325,-3106.457,-3099.9653,-3114.8147,-3127.421,-3107.788,-3094.0847,-3104.7695,-3086.3525,-3158.1824,-3071.721,-3056.9788,-3059.1428,-3085.8215,-3080.2214,-3064.5623,-3055.5723,-3057.5808,-3064.2903,-3072.0723,-3090.9075,-3104.867,-3124.6682,-3147.485,-3143.618,-3146.1863,-3185.642,-4248.3633,-4230.3555,-4234.4927,-4226.024,-4223.461,-4196.0684,-4166.854,-4151.2656,-4171.571,-4197.1113,-4161.689,-4183.53,-4192.1304,-4213.7554,-4232.3823,-4217.7485,-4213.1484,-4191.259,-4158.0386,-4164.4976,-4155.92,-4161.9116,-4197.1997,-4157.292,-4131.6714,-4099.9326,-4122.5684,-4084.5564,-4030.2295,-3979.0154,-4021.623,-4035.6433,-3994.3389,-3972.7766,-3958.9026,-3948.271};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_114()
		{
			double[] value = {-3930.959,-3911.891,-3890.4194,-3892.7778,-3886.9353,-3838.8582,-3830.3167,-3806.7961,-3819.9534,-3797.3086,-3793.9028,-3787.7373,-3775.1248,-3750.507,-3711.2695,-3652.2903,-3642.0178,-3647.781,-3639.7434,-3605.0425,-3584.198,-3567.2456,-3550.4917,-3531.8464,-3527.9685,-3510.685,-3503.523,-3501.7563,-3483.5913,-3466.8398,-3448.6438,-3405.6912,-3657.594,-3410.571,-3395.3318,-3378.2158,-3373.452,-3358.385,-3338.5344,-3326.9985,-3311.9585,-3310.8357,-3296.9836,-3286.6182,-3210.889,-3322.5498,-3283.0442,-3252.8105,-3263.1133,-3269.686,-3255.4858,-3241.351,-3233.2727,-3232.505,-3233.6306,-3233.1536,-3243.119,-3239.5752,-3232.1257,-3226.2666,-3219.8657,-3209.1575,-3197.8335,-3189.565,-3185.746,-3184.6992,-3192.5537,-3203.312,-3213.6514,-3224.7244,-3222.0945,-3217.0789,-3224.1292,-3229.6262,-3206.4087,-3192.4985,-3181.6597,-3180.1812,-3203.5615,-3194.6753,-3180.8164,-3166.5454,-3164.5798,-3167.5864,-3164.0144,-3170.1091,-3195.3445,-3226.9966,-3248.5205,-3259.404,-3263.4858,-3285.5642,-4277.7603,-4261.2905,-4245.9185,-4211.943,-4204.033,-4195.088,-4188.6685,-4162.3413};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_115()
		{
			double[] value = {-4486.321,-4254.119,-4192.8164,-4198.1265,-4227.77,-4235.933,-4233.5977,-4223.098,-4218.555,-4228.767,-4211.095,-4197.9795,-4214.74,-4191.27,-4185.0303,-4177.9062,-4154.8975,-4147.8525,-4150.4995,-4143.6714,-4110.5225,-4054.1511,-4030.7273,-4064.9722,-4056.5134,-4032.8384,-4011.3647,-3984.225,-3960.0386,-3951.9858,-3937.198,-3918.0286,-3925.6382,-3926.1462,-3911.5684,-3884.8384,-3871.2476,-3862.276,-3857.858,-3832.8652,-3822.4421,-3785.7253,-3743.7556,-3667.1982,-3681.0676,-3685.2854,-3660.3503,-3652.6477,-3595.1108,-3587.1702,-3562.9468,-3591.5725,-3587.6038,-3575.586,-3566.9211,-3550.8613,-3525.3958,-3513.3025,-3508.9949,-3497.1025,-3480.595,-3490.4153,-3483.459,-3476.128,-3459.7292,-3440.0322,-3437.9456,-3436.032,-3425.4138,-3418.3936,-3400.0261,-3386.7153,-3354.3499,-3473.2004,-3371.704,-3332.8635,-3360.687,-3355.2412,-3347.963,-3336.4463,-3325.3472,-3330.4326,-3325.717,-3316.273,-3307.8887,-3295.3542,-3294.8596,-3291.6604,-3282.2769,-3271.216,-3261.177,-3252.54,-3245.9014,-3243.471,-3248.6406,-3258.6013,-3265.6013,-3276.3523,-3276.113,-3273.6848};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_116()
		{
			double[] value = {-3273.4802,-3280.0442,-3273.1462,-3250.6912,-3240.9634,-3244.663,-3246.4473,-3269.2893,-3265.7808,-3264.8928,-3260.8232,-3271.2422,-3261.4727,-3259.44,-3296.882,-3322.697,-3342.7222,-3365.8403,-3377.5857,-3377.254,-4326.088,-4321.705,-4292.1455,-4268.732,-4256.499,-4241.95,-4197.828,-4164.6807,-4315.6646,-4188.6997,-4198.858,-4223.0317,-4251.766,-4260.7227,-4261.34,-4252.685,-4234.2783,-4240.638,-4236.364,-4203.6187,-4222.235,-4220.3906,-4202.8477,-4198.9233,-4193.65,-4188.7227,-4175.961,-4162.305,-4141.1846,-4128.399,-4079.2698,-4038.2112,-4069.9958,-4060.1667,-4051.938,-4034.8193,-4013.8738,-3997.0947,-3995.512,-3958.9895,-3959.821,-3937.9165,-3949.3242,-3942.901,-3929.142,-3893.8452,-3895.3416,-3873.9182,-3843.5842,-3812.661,-3811.5366,-3791.147,-3768.2603,-3746.4314,-3714.0037,-3694.4387,-3676.3557,-3656.8518,-3663.4868,-3643.1787,-3655.0273,-3639.1826,-3616.9146,-3617.7327,-3602.0815,-3591.8508,-3580.6135,-3553.555,-3541.9294,-3541.9683,-3546.5137,-3546.2207,-3527.1155,-3501.1892,-3484.012,-3491.2144,-3497.4077,-3499.988,-3500.5278,-3497.5845};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_117()
		{
			double[] value = {-3493.8296,-3484.1301,-3476.2903,-3465.3123,-3460.9597,-3453.9797,-3440.2322,-3426.9277,-3415.9258,-3417.8916,-3421.0828,-3410.4546,-3394.9448,-3382.7288,-3370.052,-3363.1963,-3355.0745,-3338.8232,-3329.3413,-3324.1213,-3317.5134,-3317.2668,-3322.1414,-3321.0942,-3325.161,-3332.6082,-3340.1738,-3335.7705,-3332.557,-3341.2256,-3350.9617,-3328.1035,-3319.4907,-3329.4407,-3333.7659,-3344.628,-3364.8452,-3362.3455,-3363.8696,-3367.5605,-3373.1833,-3378.5688,-3398.9897,-3428.1506,-3459.3345,-3485.2727,-3511.7173,-3521.8782,-4319.013,-4350.993,-4346.4297,-4349.6465,-4337.5156,-4295.646,-4223.8506,-4245.413,-4244.7847,-4240.9326,-4264.953,-4260.599,-4288.8853,-4296.982,-4306.208,-4297.7236,-4273.824,-4268.8105,-4247.7354,-4234.7993,-4225.9995,-4222.964,-4187.3086,-4188.909,-4200.2896,-4209.7974,-4199.1387,-4176.7715,-4159.773,-4135.2715,-4136.7383,-4102.0254,-4093.3716,-4093.362,-4111.0327,-4092.824,-4076.6904,-4063.977,-4043.004,-4021.8672,-3997.7495,-3983.3926,-3978.9287,-3970.9292,-3957.6826,-3926.124,-3924.4192,-3917.331,-3891.7954,-3868.9248,-3854.5303,-3856.5286};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_118()
		{
			double[] value = {-3852.8923,-3836.8416,-3793.0835,-3762.9666,-3729.0806,-3738.6458,-3741.6616,-3731.243,-3732.8428,-3724.4788,-3712.4102,-3688.7021,-3673.9038,-3662.9045,-3647.8315,-3637.7544,-3621.2244,-3605.6711,-3602.8347,-3602.2856,-3602.602,-3594.1619,-3605.3362,-3584.807,-3566.1865,-3568.9604,-3568.952,-3567.8164,-3568.9353,-3572.411,-3560.1597,-3548.8997,-3542.5017,-3547.8481,-3531.7979,-3524.8594,-3519.4348,-3510.3323,-3505.1592,-3491.8706,-3474.5437,-3466.3223,-3449.8142,-3435.013,-3433.3704,-3418.724,-3398.1072,-3396.5767,-3399.5286,-3396.713,-3396.2332,-3392.5566,-3394.0745,-3401.3433,-3407.8586,-3395.2156,-3389.7766,-3396.1355,-3414.0981,-3400.4622,-3396.7617,-3400.154,-3398.351,-3403.3914,-3435.2717,-3439.2805,-3452.7925,-3465.574,-3478.8218,-3493.038,-3502.1628,-3529.16,-3563.5093,-3582.9128,-3606.2715,-3625.8665,-4340.3604,-4361.2783,-4389.838,-4419.0303,-4383.2476,-4342.91,-4301.8706,-4327.936,-4329.7144,-4330.147,-4334.4556,-4351.8247,-4335.474,-4329.0586,-4330.4756,-4306.2466,-4307.0684,-4298.3115,-4273.915,-4264.6353,-4274.895,-4246.7534,-4209.6094,-4176.3706};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_119()
		{
			double[] value = {-4217.0923,-4220.419,-4210.8936,-4192.796,-4182.509,-4151.1904,-4147.5,-4167.9883,-4160.532,-4162.024,-4161.2515,-4153.5923,-4129.8345,-4125.877,-4108.222,-4047.187,-4120.767,-3953.9746,-4005.4453,-4027.772,-4001.5498,-3976.8862,-3955.7422,-3945.803,-3933.9712,-3907.118,-3879.3965,-3866.2996,-3882.3455,-3897.2058,-3884.0396,-3857.0437,-3835.6729,-3839.551,-3805.1672,-3797.5554,-3801.6912,-3805.461,-3799.6,-3771.1187,-3766.772,-3748.5024,-3734.8672,-3721.9778,-3719.3416,-3730.9246,-3725.5754,-3702.8066,-3692.0388,-3669.5715,-3662.6472,-3652.3376,-3663.4124,-3659.6228,-3650.2266,-3656.4905,-3653.3582,-3651.0017,-3639.9988,-3623.383,-3607.7388,-3603.0806,-3600.991,-3595.9265,-3585.0317,-3573.3022,-3575.17,-3566.4204,-3551.138,-3545.867,-3532.789,-3520.7024,-3510.5452,-3501.279,-3490.0312,-3491.9883,-3483.2603,-3475.5244,-3471.3704,-3471.038,-3469.4678,-3474.9983,-3485.3306,-3468.4194,-3453.4119,-3444.7358,-3456.4844,-3451.7788,-3449.7935,-3455.875,-3466.1982,-3481.5522,-3503.152,-3516.4514,-3532.1052,-3548.9795,-3560.1814,-3573.13,-3580.4094,-3614.1724};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_120()
		{
			double[] value = {-3638.7983,-3668.6497,-3689.9575,-3708.9875,-4338.401,-4374.83,-4422.791,-4408.934,-4394.215,-4385.3066,-4343.4736,-4354.834,-4359.059,-4368.6904,-4354.19,-4347.4976,-4344.709,-4353.366,-4351.8,-4333.9546,-4317.4443,-4305.905,-4302.3447,-4327.4175,-4329.266,-4273.405,-4275.3203,-4231.767,-4255.9053,-4246.483,-4269.165,-4248.4053,-4225.4053,-4224.7812,-4198.8633,-4244.8506,-4249.2676,-4218.42,-4210.0366,-4201.9834,-4186.351,-4160.046,-4143.3276,-4121.154,-4092.201,-4079.3694,-4081.9106,-4082.8853,-4070.6372,-4060.1614,-4036.6235,-4020.3882,-4019.7612,-3997.4482,-3972.1504,-3967.8098,-3988.946,-3959.8154,-3941.6575,-3922.9202,-3916.1086,-3927.2495,-3913.9797,-3898.4578,-3879.6057,-3844.643,-3827.9067,-3819.981,-3825.5793,-3815.7654,-3809.1448,-3808.1746,-3808.1106,-3789.2742,-3765.9497,-3768.1074,-3757.9653,-3747.117,-3723.9236,-3734.5276,-3745.0,-3740.46,-3738.5095,-3729.9028,-3723.4297,-3720.538,-3709.081,-3699.181,-3684.0298,-3673.3635,-3666.5442,-3668.4976,-3662.4614,-3634.4421,-3632.4456,-3626.4612,-3624.4165,-3610.4446,-3595.8503,-3585.5508};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_121()
		{
			double[] value = {-3577.7686,-3571.3738,-3567.4487,-3558.6523,-3552.427,-3543.9495,-3535.132,-3536.4912,-3534.6074,-3549.4688,-3557.7542,-3538.3027,-3523.658,-3506.9055,-3518.608,-3522.2263,-3520.9058,-3524.2246,-3533.249,-3548.5447,-3563.5479,-3583.651,-3595.5288,-3620.0596,-3633.86,-3654.5483,-3654.7004,-3667.715,-3709.492,-3733.2366,-3758.08,-3783.3098,-4367.7437,-4385.691,-4399.34,-4434.9287,-4441.517,-4431.0693,-4395.694,-4374.467,-4389.132,-4385.946,-4393.5605,-4349.7563,-4347.5054,-4394.653,-4396.7007,-4390.825,-4380.131,-4360.7812,-4318.295,-4343.475,-4337.1025,-4327.827,-4300.3306,-4306.838,-4295.0913,-4281.741,-4269.572,-4289.063,-4274.9624,-4299.817,-4291.077,-4295.831,-4273.79,-4246.9897,-4240.7896,-4245.6016,-4226.7725,-4203.21,-4191.4414,-4189.014,-4165.259,-4143.8076,-4141.958,-4148.059,-4130.3555,-4124.8755,-4113.036,-4091.5344,-4072.3179,-4063.6165,-4057.9292,-4050.0469,-4039.2766,-4003.5999,-3971.645,-3962.1948,-3972.3945,-3989.181,-3979.0952,-3946.8586,-3936.3428,-3929.3562,-3920.8425,-3921.7153,-3904.7817,-3883.6216,-3886.3975,-3887.985};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_122()
		{
			double[] value = {-3868.8125,-3867.2185,-3867.33,-3854.9739,-3831.8467,-3803.1675,-3794.5537,-3804.0273,-3796.5662,-3786.4082,-3785.77,-3776.5684,-3765.3914,-3762.0234,-3755.0803,-3747.9692,-3744.922,-3735.3787,-3735.6772,-3738.9033,-3739.9043,-3707.6326,-3690.4038,-3704.8743,-3700.6116,-3680.0708,-3660.8179,-3646.5469,-3637.0696,-3625.1748,-3625.0862,-3628.0369,-3610.5366,-3605.2546,-3598.3242,-3599.6016,-3602.9724,-3613.0315,-3614.497,-3591.7588,-3577.6006,-3575.283,-3583.2227,-3585.9375,-3585.2178,-3588.4172,-3602.3733,-3619.515,-3636.5376,-3662.6755,-3678.6924,-3693.1858,-3711.6514,-3729.1133,-3743.59,-3755.432,-3773.745,-3796.3525,-3821.9392,-3851.655,-4433.4517,-4424.9883,-4386.9443,-4438.3623,-4469.8125,-4465.7437,-4422.039,-4396.701,-4401.3613,-4409.038,-4426.4067,-4405.728,-4386.3506,-4425.709,-4448.9067,-4434.8477,-4423.1807,-4415.02,-4388.8906,-4363.04,-4380.8174,-4359.9766,-4363.6367,-4381.3027,-4381.1963,-4361.7324,-4332.1606,-4316.528,-4295.0654,-4284.674,-4275.359,-4302.4287,-4300.6143,-4290.639,-4282.1523,-4287.033,-4289.456,-4268.5957,-4268.738,-4238.5547};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_123()
		{
			double[] value = {-4224.457,-4208.9663,-4203.365,-4203.002,-4183.6313,-4162.124,-4155.9907,-4147.512,-4150.3223,-4137.4644,-4123.19,-4118.63,-4111.6636,-4093.1553,-4095.3613,-4041.7646,-4002.75,-3994.1838,-4029.6658,-4043.6333,-4042.3372,-4007.562,-3981.8533,-3964.1648,-3946.626,-3941.6016,-3940.8845,-3938.6306,-3922.204,-3939.4746,-3914.031,-3906.9812,-3894.986,-3884.189,-3862.958,-3877.9915,-3868.0342,-3858.5222,-3854.1418,-3844.2656,-3832.347,-3832.9126,-3821.6997,-3806.7612,-3816.3906,-3790.9475,-3788.2766,-3775.1724,-3774.7925,-3764.8032,-3765.6577,-3768.0723,-3760.096,-3746.528,-3726.9988,-3712.515,-3683.2183,-3649.2183,-3653.3352,-3667.7146,-3638.0532,-3635.481,-3664.5552,-3664.8213,-3663.7314,-3654.0317,-3655.509,-3652.8564,-3643.8044,-3636.89,-3644.469,-3656.315,-3663.7078,-3669.4114,-3682.3245,-3692.51,-3714.7327,-3736.8267,-3761.944,-3766.6433,-3783.0554,-3805.1511,-3818.5955,-3829.8247,-3849.2751,-3869.8896,-3893.7258,-3918.6501,-4444.715,-4438.3677,-4450.91,-4467.2617,-4498.195,-4505.241,-4489.18,-4463.895,-4472.0957,-4457.254,-4461.723,-4459.4346};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_124()
		{
			double[] value = {-4414.6147,-4437.3354,-4443.6323,-4427.632,-4369.766,-4423.702,-4396.358,-4381.5005,-4389.9,-4402.5327,-4398.2476,-4424.016,-4412.8105,-4392.0586,-4376.6187,-4368.661,-4354.8394,-4325.5107,-4338.0425,-4321.946,-4347.181,-4355.8774,-4339.9185,-4316.8896,-4248.303,-4268.088,-4284.6353,-4292.6675,-4299.5474,-4294.6655,-4261.7114,-4244.2246,-4243.577,-4245.093,-4218.1787,-4189.596,-4183.4185,-4176.842,-4206.1904,-4202.2534,-4183.566,-4156.569,-4167.0063,-4157.9053,-4136.142,-4119.2085,-4104.743,-4099.9683,-4096.4614,-4087.9229,-4082.5178,-4089.6545,-4075.7424,-4054.6445,-4058.9226,-4042.289,-4025.0093,-4020.8958,-4007.2815,-3974.9443,-3963.3271,-3972.889,-3971.824,-3986.5544,-3970.3704,-3919.2024,-3906.7446,-3908.7131,-3904.7795,-3909.7207,-3891.6313,-3893.937,-3876.4097,-3866.1963,-3861.0425,-3853.8035,-3848.6223,-3847.7957,-3828.4502,-3816.2034,-3814.4343,-3792.6467,-3772.6655,-3767.6648,-3725.9314,-3889.6697,-3671.9346,-3709.2666,-3718.8315,-3702.8228,-3718.5903,-3713.9114,-3710.8728,-3714.4365,-3733.1304,-3722.181,-3713.765,-3713.1152,-3718.7603,-3735.8086};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_125()
		{
			double[] value = {-3745.086,-3755.8542,-3766.9824,-3780.4182,-3797.9656,-3820.0432,-3841.7424,-3857.3655,-3868.252,-3881.5754,-3898.6064,-3908.8042,-3928.199,-3948.5164,-3964.4268,-3988.4006,-4437.4424,-4446.334,-4474.8555,-4502.4736,-4519.2847,-4533.957,-4520.7,-4489.992,-4487.2124,-4485.0967,-4481.05,-4456.452,-4460.813,-4409.346,-4413.96,-4440.475,-4425.4043,-4418.6333,-4436.273,-4441.06,-4411.4985,-4438.675,-4440.767,-4443.4336,-4437.8735,-4383.1084,-4433.542,-4368.3174,-4376.126,-4358.8003,-4381.5083,-4388.126,-4360.5156,-4360.559,-4354.88,-4385.7603,-4376.4775,-4353.479,-4338.5845,-4342.0693,-4329.754,-4333.202,-4329.8535,-4325.4424,-4306.886,-4301.6094,-4307.0435,-4281.573,-4272.157,-4280.8174,-4257.3794,-4256.4224,-4207.7607,-4192.836,-4222.3457,-4255.98,-4256.866,-4211.445,-4205.8296,-4197.5415,-4190.5566,-4188.5386,-4182.568,-4190.7026,-4166.7344,-4141.431,-4146.1255,-4106.8984,-4105.125,-4115.51,-4123.975,-4094.562,-4081.1243,-4084.7676,-4087.416,-4089.3928,-4071.2356,-4017.0605,-3959.3857,-3941.4895,-3931.4885,-3941.018,-3951.3103,-3948.3367};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_126()
		{
			double[] value = {-3948.3901,-3921.7825,-3902.2712,-3901.3499,-3901.9646,-3897.1475,-3878.5874,-3851.4336,-3872.9172,-3851.1287,-3834.592,-3822.584,-3814.1711,-3781.2114,-3784.4277,-3808.6765,-3806.6252,-3790.746,-3780.294,-3779.1196,-3790.1904,-3788.1194,-3796.154,-3798.883,-3794.9028,-3794.3987,-3803.1533,-3821.6387,-3835.0586,-3841.0552,-3847.6213,-3868.8079,-3887.0361,-3909.4,-3929.271,-3942.382,-3937.4863,-3934.7522,-3954.1165,-3981.1262,-4007.1865,-4023.0366,-4040.2761,-4062.0913,-4439.092,-4458.874,-4516.83,-4537.3916,-4546.7354,-4545.909,-4546.431,-4529.535,-4503.4614,-4514.696,-4508.7847,-4514.697,-4488.057,-4502.5225,-4523.304,-4533.2285,-4500.293,-4488.941,-4490.155,-4501.6655,-4508.446,-4489.941,-4477.6997,-4459.4707,-4496.486,-4492.2593,-4476.4014,-4447.978,-4438.4854,-4437.1167,-4436.8066,-4433.39,-4427.9854,-4407.5137,-4417.066,-4437.504,-4431.153,-4425.55,-4396.7607,-4383.0977,-4362.3687,-4370.758,-4301.7656,-4279.8013,-4270.4717,-4292.6177,-4317.6606,-4322.6064,-4339.821,-4347.5635,-4348.057,-4349.95,-4296.7783,-4273.622,-4262.6772,-4282.389};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_127()
		{
			double[] value = {-4282.1875,-4263.182,-4258.8643,-4292.895,-4273.4927,-4246.499,-4250.108,-4270.142,-4251.485,-4228.644,-4212.914,-4197.44,-4179.5273,-4112.513,-4161.994,-4194.389,-4087.7026,-4074.3186,-4034.049,-4095.2798,-4134.831,-4133.302,-4087.07,-4087.6235,-4095.0405,-3997.3123,-4006.6929,-3974.301,-4085.5344,-4087.6592,-4042.5078,-4027.3464,-3998.4802,-3920.9536,-3976.3257,-4010.1091,-3959.1567,-3980.774,-3931.7122,-3887.1528,-3876.3667,-3863.597,-3884.4434,-3870.427,-3867.4412,-3859.6858,-3880.5735,-3864.3115,-3856.7861,-3861.892,-3877.3389,-3882.383,-3882.6243,-3885.8372,-3883.8904,-3902.1694,-3911.1343,-3920.25,-3936.3796,-3956.3447,-3971.1875,-3998.8853,-4019.5164,-4020.9246,-4029.237,-4035.9243,-4043.0154,-4068.6448,-4087.3696,-4118.8423,-4146.8647,-4178.1567,-4484.28,-4514.934,-4558.7646,-4568.1196,-4575.618,-4563.284,-4559.8286,-4555.7583,-4537.3877,-4557.587,-4564.602,-4579.375,-4579.458,-4565.4,-4550.2593,-4565.719,-4550.309,-4542.65,-4522.642,-4525.237,-4552.0474,-4530.2676,-4524.6006,-4521.0317,-4530.0757,-4560.561,-4551.526,-4478.093};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_128()
		{
			double[] value = {-4499.055,-4465.838,-4474.102,-4483.752,-4474.21,-4481.845,-4476.6157,-4427.6304,-4424.183,-4439.592,-4444.5596,-4419.7573,-4430.5835,-4443.8096,-4422.6543,-4433.7637,-4423.0674,-4414.0635,-4408.0474,-4430.6655,-4438.536,-4429.9414,-4428.419,-4407.6553,-4402.7935,-4411.023,-4392.0957,-4371.367,-4336.18,-4347.397,-4357.168,-4335.7266,-4333.6934,-4340.495,-4343.342,-4346.531,-4358.259,-4324.4478,-4317.19,-4297.047,-4282.852,-4250.831,-4245.4253,-4234.9736,-4185.7993,-4085.618,-4048.434,-4058.1418,-4127.9185,-4136.5796,-4018.8296,-4077.2107,-4154.168,-4156.4795,-4095.8882,-4065.9302,-4101.7065,-4128.008,-4126.8955,-4127.7144,-4125.8345,-4104.129,-4125.2754,-4089.3896,-4096.483,-4104.1733,-4050.869,-3990.4578,-3972.3774,-3962.8467,-3974.035,-3952.0312,-3948.877,-3943.8699,-3942.4272,-3934.7795,-3943.1729,-3947.594,-3970.1152,-3974.163,-3973.8562,-3966.9412,-3962.5452,-3975.04,-3995.8662,-4010.4736,-4026.1536,-4043.1548,-4060.086,-4082.427,-4129.91,-4139.829,-4151.809,-4150.805,-4169.965,-4203.9175,-4225.6675,-4260.289,-4285.8706,-4298.0107};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_129()
		{
			double[] value = {-4563.2783,-4574.1377,-4584.571,-4591.435,-4625.0083,-4610.218,-4591.508,-4599.2583,-4585.1323,-4566.3643,-4587.913,-4606.006,-4621.4014,-4598.3813,-4570.4634,-4562.9556,-4555.994,-4498.0366,-4480.7925,-4525.777,-4555.104,-4542.33,-4542.394,-4566.284,-4570.0176,-4543.0527,-4551.975,-4529.305,-4497.5376,-4531.446,-4540.331,-4542.1367,-4543.989,-4527.7827,-4521.095,-4500.9746,-4482.518,-4485.8794,-4513.6416,-4530.401,-4541.03,-4519.4136,-4535.193,-4509.7803,-4505.7134,-4512.1714,-4517.965,-4486.129,-4490.7856,-4486.469,-4479.098,-4499.532,-4507.344,-4477.8306,-4451.258,-4401.8594,-4374.5767,-4433.5664,-4410.7305,-4397.298,-4405.533,-4423.9326,-4439.2656,-4475.5835,-4450.5205,-4436.069,-4368.321,-4313.927,-4313.328,-4298.095,-4297.837,-4297.2705,-4298.708,-4253.7856,-4234.8916,-4228.861,-4199.7524,-4141.175,-3986.5654,-3986.6497,-4097.506,-4163.674,-4173.04,-4166.7524,-4167.9443,-4168.901,-4221.733,-4238.1772,-4220.13,-4208.1787,-4169.348,-4196.1133,-4215.801,-4205.646,-4189.001,-4178.9004,-4125.011,-4102.285,-4098.745,-4077.054};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_130()
		{
			double[] value = {-4070.813,-4058.37,-4056.8484,-4059.204,-4076.0999,-4097.384,-4087.1199,-4103.219,-4085.4143,-4053.7942,-4032.1228,-4065.105,-4074.6663,-4074.1145,-4105.7593,-4161.3804,-4179.6304,-4244.559,-4267.144,-4255.1133,-4229.7334,-4497.797,-4343.9087,-4265.447,-4304.212,-4334.764,-4377.467,-4401.764,-4605.0005,-4639.9077,-4657.8706,-4645.212,-4669.2686,-4681.3076,-4679.8604,-4662.2534,-4644.4023,-4633.453,-4616.167,-4608.55,-4617.711,-4650.104,-4625.28,-4561.8105,-4457.829,-4865.8877,-5199.2637,-4471.843,-4543.2876,-4578.6743,-4603.0483,-4607.153,-4606.5933,-4619.2695,-4610.251,-4562.724,-4537.2637,-4558.214,-4575.75,-4569.1934,-4590.2197,-4587.043,-4573.109,-4576.7095,-4564.9883,-4546.229,-4540.3853,-4564.2925,-4583.501,-4586.2153,-4582.2983,-4591.681,-4571.5796,-4571.084,-4565.8135,-4562.2256,-4553.213,-4540.2324,-4558.178,-4581.862,-4554.3794,-4486.4487,-4472.0435,-4450.61,-4457.903,-4437.9277,-4428.4536,-4446.482,-4464.855,-4496.443,-4513.6357,-4470.0537,-4436.8633,-4439.0806,-4431.9263,-4412.3433,-4388.771,-4361.516,-4350.601,-4354.557};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_131()
		{
			double[] value = {-4362.578,-4320.0674,-4322.4507,-4290.8267,-4252.7183,-4267.5913,-4240.407,-4259.564,-4220.5977,-4157.4688,-4204.848,-4222.7603,-4215.383,-4237.8833,-4281.661,-4286.776,-4267.1294,-4272.433,-4269.1377,-4249.5244,-4241.435,-4218.904,-4207.349,-4219.005,-4224.285,-4207.3403,-4198.137,-4201.763,-4225.231,-4215.6235,-4183.186,-4192.0947,-4180.196,-4179.0444,-4191.1123,-4198.009,-4216.1274,-4221.1333,-4203.0444,-4243.478,-4252.973,-4205.724,-4218.486,-4294.593,-4300.118,-4311.3286,-4335.0117,-4348.7583,-4351.085,-4341.4727,-4360.522,-4381.698,-4405.5806,-4432.6206,-4452.3906,-4465.9814,-4698.933,-4720.626,-4731.276,-4701.796,-4723.5435,-4736.3335,-4727.7314,-4700.3247,-4688.0684,-4683.07,-4683.4985,-4678.185,-4673.1885,-4673.1377,-4648.6074,-4616.626,-4574.2847,-4536.852,-4561.9297,-4587.053,-4588.735,-4611.687,-4639.5723,-4655.671,-4686.534,-4685.111,-4665.676,-4626.0957,-4627.2446,-4627.748,-4633.5557,-4641.0874,-4654.2314,-4655.1284,-4660.207,-4653.581,-4627.713,-4619.889,-4623.5493,-4630.5586,-4636.754,-4650.4507,-4646.131,-4639.098};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_132()
		{
			double[] value = {-4630.5806,-4630.4683,-4623.4214,-4617.9814,-4615.706,-4599.0947,-4606.9062,-4648.7397,-4633.0483,-4637.7476,-4625.3076,-4574.695,-4553.7363,-4522.499,-4511.9697,-4466.82,-4436.955,-4442.768,-4480.329,-4488.818,-4487.2905,-4475.699,-4467.845,-4471.883,-4454.2354,-4435.1836,-4478.6284,-4465.053,-4435.0605,-4414.126,-4421.449,-4378.489,-4342.784,-4346.6772,-4394.1733,-4345.4297,-4355.6226,-4354.667,-4337.265,-4320.4775,-4326.1304,-4349.2666,-4354.6943,-4373.136,-4390.798,-4346.997,-4330.5317,-4311.8447,-4305.287,-4285.3643,-4289.725,-4342.035,-4329.1714,-4302.2554,-4333.136,-4365.77,-4329.899,-4305.748,-4278.206,-4272.9907,-4277.8916,-4276.678,-4286.034,-4292.0576,-4318.984,-4314.403,-4308.954,-4315.234,-4309.4204,-4350.4043,-4349.8706,-4378.4805,-4390.2817,-4398.7627,-4420.154,-4441.3726,-4451.8613,-4464.872,-4474.8545,-4487.121,-4511.7515,-4523.8457,-4529.8823,-4534.8076,-4727.607,-4729.4614,-4722.6978,-4742.662,-4751.6514,-4754.7646,-4756.206,-4754.9653,-4735.2646,-4710.7285,-4713.0337,-4723.055,-4733.3203,-4734.634,-4728.0083,-4724.0347};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_133()
		{
			double[] value = {-4718.2075,-4709.006,-4674.43,-4678.2817,-4689.2393,-4692.4277,-4709.985,-4737.8843,-4727.7407,-4720.958,-4725.4487,-4704.2954,-4719.3516,-4711.7124,-4704.8467,-4706.174,-4714.0093,-4703.7266,-4719.837,-4711.7505,-4680.329,-4674.949,-4693.8564,-4729.498,-4708.385,-4709.295,-4686.2607,-4672.0176,-4683.3574,-4670.3994,-4634.0483,-4629.1177,-4610.8413,-4607.1,-4630.202,-4660.1436,-4675.7324,-4674.3047,-4658.846,-4630.2754,-4590.987,-4580.7617,-4551.089,-4488.9717,-4466.943,-4484.952,-4501.6104,-4500.385,-4507.8936,-4552.331,-4541.4766,-4531.88,-4531.8423,-4560.21,-4590.3364,-4608.201,-4517.7075,-4521.954,-4542.1333,-4484.7285,-4546.335,-4557.817,-4545.6504,-4523.934,-4515.317,-4462.2705,-4454.1875,-4480.6104,-4513.7793,-4483.8794,-4477.097,-4426.147,-4408.932,-4416.3564,-4413.804,-4390.6465,-4370.451,-4339.412,-4344.284,-4330.685,-4336.669,-4341.174,-4343.5527,-4356.7646,-4338.909,-4323.4556,-4326.87,-4331.19,-4342.5977,-4359.793,-4371.561,-4381.242,-4381.604,-4399.0728,-4416.9985,-4409.9053,-4411.4043,-4436.5996,-4449.8335,-4457.811};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_134()
		{
			double[] value = {-4486.169,-4505.9683,-4506.3745,-4515.8706,-4529.186,-4550.661,-4564.1636,-4572.0547,-4588.0083,-4592.752,-4602.1523,-4622.586,-4737.6167,-4752.4736,-4769.4185,-4774.9233,-4775.376,-4779.106,-4754.007,-4723.37,-4719.294,-4718.3945,-4724.3604,-4722.814,-4746.4727,-4764.9473,-4759.989,-4787.3496,-4792.4194,-4793.085,-4787.071,-4776.767,-4763.6875,-4769.393,-4769.0386,-4760.175,-4747.764,-4762.364,-4783.7065,-4786.5693,-4793.2446,-4775.5527,-4727.058,-4727.366,-4760.1777,-4780.221,-4782.08,-4743.8164,-4706.985,-4684.685,-4711.449,-4758.2495,-4767.17,-4764.2056,-4728.4204,-4707.5796,-4713.8257,-4724.4253,-4717.8057,-4703.9775,-4686.9604,-4649.199,-4657.4507,-4658.966,-4685.464,-4663.782,-4651.35,-4645.5835,-4637.3364,-4629.17,-4593.975,-4570.893,-4551.5396,-4533.5864,-4533.262,-4529.3164,-4551.035,-4561.841,-4541.8794,-4513.4595,-4518.4077,-4559.489,-4543.0312,-4551.7603,-4536.24,-4524.1865,-4525.2783,-4509.2817,-4627.3105,-4686.2017,-4626.8496,-4590.4805,-4572.669,-4516.5933,-4533.838,-4576.8203,-4602.8945,-4569.8774,-4514.039,-4496.0645};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_135()
		{
			double[] value = {-4510.02,-4533.5566,-4488.721,-4454.3823,-4458.6714,-4447.035,-4438.312,-4430.205,-4413.7275,-4412.5215,-4430.329,-4434.5435,-4421.82,-4418.862,-4410.8945,-4398.3447,-4397.8696,-4417.589,-4445.9263,-4453.6187,-4456.263,-4480.402,-4494.1963,-4498.8804,-4499.597,-4520.0156,-4540.74,-4552.522,-4568.622,-4582.2974,-4587.12,-4592.8022,-4604.3804,-4591.5347,-4617.9834,-4641.993,-4658.674,-4666.2495,-4669.2056,-4700.186,-4724.8467,-4759.2617,-4787.872,-4781.874,-4786.196,-4739.1455,-4671.741,-5073.0366,-5083.8447,-4687.1626,-4735.4385,-4743.3867,-4694.402,-4682.83,-4705.847,-4735.575,-4783.794,-4797.7876,-4823.1494,-4834.0703,-4827.2124,-4815.4644,-4802.332,-4799.65,-4777.6724,-4709.5386,-4738.939,-4777.7524,-4727.5596,-4737.2104,-4750.6626,-4733.155,-4768.2095,-4789.6313,-4809.2812,-4817.1875,-4809.8877,-4767.6343,-4733.8076,-4735.986,-4783.7344,-4783.716,-4767.382,-4763.3745,-4753.5566,-4769.6694,-4793.63,-4782.712,-4753.3037,-4735.5527,-4733.821,-4737.104,-4647.5435,-4686.352,-4654.567,-4628.068,-4631.548,-4636.502,-4649.045,-4625.993};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_136()
		{
			double[] value = {-4599.7583,-4590.538,-4613.4976,-4575.7134,-4577.6416,-4623.121,-4670.4346,-4712.7666,-4734.256,-4661.2637,-4581.9287,-4484.0454,-4501.179,-4526.702,-4578.371,-4614.254,-4634.425,-4666.9927,-4603.3477,-4588.398,-4606.5312,-4597.5176,-4597.591,-4600.5537,-4603.9155,-4582.7065,-4553.4526,-4560.4834,-4552.743,-4510.236,-4515.529,-4522.8184,-4523.1533,-4561.3604,-4556.7637,-4458.3423,-4474.3716,-4511.0293,-4511.3047,-4506.145,-4512.565,-4509.0654,-4513.878,-4511.8613,-4498.26,-4509.2153,-4532.975,-4535.195,-4532.348,-4524.755,-4537.2793,-4568.5024,-4591.016,-4599.295,-4586.1914,-4601.0825,-4624.1846,-4643.959,-4643.4463,-4647.805,-4662.1494,-4673.324,-4684.71,-4709.653,-4724.2334,-4721.6167,-4724.7354,-4738.412,-4776.064,-4801.999,-4833.684,-4840.125,-4829.5156,-4806.929,-4772.431,-4737.063,-4747.318,-4757.42,-4784.8486,-4814.4683,-4828.507,-4835.512,-4840.664,-4852.9194,-4820.379,-4790.4746,-4802.517,-4830.8066,-4847.9854,-4828.1206,-4791.927,-4808.491,-4835.0938,-4835.344,-4847.2705,-4852.2173,-4843.0063,-4845.8,-4818.391,-4810.8335};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_137()
		{
			double[] value = {-4826.4453,-4826.762,-4844.547,-4849.7964,-4847.9634,-4857.4805,-4852.5435,-4801.574,-4760.53,-4746.537,-4778.257,-4804.6025,-4786.7983,-4780.4946,-4776.781,-4799.1074,-4797.4766,-4787.016,-4799.797,-4832.8076,-4792.12,-4748.1763,-4752.0854,-4734.0,-4729.9023,-4739.73,-4747.0083,-4740.0586,-4747.921,-4731.4214,-4733.244,-4783.8735,-4819.326,-4840.273,-4873.62,-4833.119,-4802.1704,-4704.9365,-4609.846,-4606.018,-4626.7017,-4626.9043,-4627.7246,-4618.6074,-4610.2446,-4613.5283,-4611.5884,-4629.5635,-4615.386,-4598.51,-4630.64,-4645.791,-4643.5547,-4647.077,-4625.665,-4615.464,-4623.196,-4608.358,-4588.3086,-4601.626,-4621.538,-4700.501,-4739.5063,-4710.6733,-4716.9546,-4659.682,-4601.6826,-4625.907,-4635.3784,-4617.492,-4610.85,-4599.392,-4589.3154,-4591.433,-4588.2495,-4579.315,-4581.672,-4593.72,-4597.754,-4633.373,-4634.129,-4632.319,-4633.982,-4633.6953,-4650.4795,-4679.6084,-4696.4805,-4703.3857,-4719.136,-4721.812,-4747.091,-4760.3496,-4774.6826,-4770.5913,-4760.1313,-4762.5225,-4811.561,-4813.1465,-4827.797,-4840.3423};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_138()
		{
			double[] value = {-4827.064,-4812.588,-4810.0405,-4819.5093,-4830.404,-4818.614,-4817.4126,-4821.8486,-4818.6484,-4843.8384,-4878.884,-4886.948,-4870.329,-4821.844,-4839.6543,-4829.708,-4827.7715,-4885.17,-4899.8247,-4882.638,-4871.413,-4860.53,-4859.454,-4886.4756,-4882.142,-4882.3125,-4848.734,-4790.116,-4783.7236,-4793.472,-4830.2075,-4893.906,-4906.699,-4915.023,-4900.3335,-4860.711,-4837.5537,-4841.9785,-4866.2754,-4873.9663,-4868.046,-4877.345,-4876.006,-4860.033,-4801.689,-4759.9185,-4772.673,-4786.2954,-4735.9795,-4796.4067,-4810.9717,-4779.906,-4755.4272,-4780.1187,-4816.733,-4855.0103,-4844.4014,-4837.68,-4847.2935,-4879.422,-4877.0645,-4875.6733,-4869.3096,-4881.755,-4828.736,-4809.1304,-4732.628,-4688.085,-4735.4834,-4686.1113,-4707.8438,-4699.026,-4722.4307,-4721.13,-4654.102,-4631.818,-4622.614,-4602.668,-4583.136,-4623.138,-4647.987,-4669.328,-4683.545,-4683.4663,-4687.786,-4671.7617,-4695.1934,-4703.6274,-4679.255,-4740.7876,-4740.5146,-4703.743,-4718.2764,-4718.692,-4679.471,-4687.245,-4670.554,-4631.793,-4646.7617,-4652.048};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_139()
		{
			double[] value = {-4640.2075,-4650.0947,-4660.0215,-4630.4673,-4606.1655,-4631.634,-4629.3535,-4670.7104,-4674.3086,-4683.36,-4686.0522,-4692.7583,-4703.987,-4714.3433,-4723.973,-4748.621,-4752.7695,-4758.685,-4767.9307,-4770.1094,-4775.55,-4777.405,-4774.7495,-4770.824,-4810.18,-4760.055,-4767.6978,-4776.204,-4797.8286,-4820.538,-4832.3315,-4813.881,-4816.1943,-4800.2603,-4797.1626,-4793.7983,-4810.584,-4858.8433,-4870.3374,-4876.617,-4886.6646,-4811.6616,-4777.06,-4774.035,-4815.039,-4872.4204,-4859.9136,-4901.4155,-4897.642,-4885.9976,-4891.396,-4938.0166,-4940.964,-4942.8,-4931.6733,-4874.825,-4789.3726,-4738.5405,-4715.168,-4802.084,-4827.9746,-4827.33,-4815.3247,-4815.302,-4834.856,-4852.153,-4864.0586,-4835.791,-4846.6216,-4878.2656,-4795.638,-4748.265,-4764.7925,-4741.111,-4685.795,-4683.944,-4684.1934,-4730.183,-4788.7383,-4794.1265,-4793.235,-4811.6714,-4809.73,-4817.6143,-4833.9707,-4831.715,-4870.2686,-4856.8066,-4885.4595,-4961.916,-5028.0576,-5000.3096,-4945.3096,-4932.5327,-4831.9653,-4737.6807,-4764.115,-4734.7476,-4690.658,-4727.7563};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_140()
		{
			double[] value = {-4732.271,-4744.9824,-4731.415,-4759.2153,-4771.5933,-4753.5923,-4713.562,-4722.921,-4723.432,-4695.837,-4731.7446,-4713.5293,-4703.793,-4708.992,-4713.3853,-4740.9463,-4813.3076,-4812.628,-4768.9165,-4769.9834,-4778.1924,-4727.453,-4725.42,-4719.737,-4704.845,-4719.941,-4732.641,-4729.0947,-4723.365,-4705.5986,-4679.6807,-4634.2646,-4664.083,-4639.2393,-4684.9727,-4690.7466,-4701.037,-4725.2827,-4731.2783,-4733.2285,-4745.388,-4745.126,-4745.722,-4749.34,-4762.9595,-4771.4897,-4772.2383,-4772.3687,-4799.5947,-4830.5166,-4876.624,-4903.9956,-4885.5654,-4851.251,-4845.6025,-4827.122,-4825.41,-4818.265,-4809.9697,-4805.959,-4777.585,-4792.183,-4772.6777,-4732.9355,-4702.826,-4732.3633,-4792.2725,-4832.734,-4831.9155,-4835.9546,-4783.6675,-4668.416,-4725.8755,-4824.7617,-4698.3926,-4761.284,-4811.2505,-4856.4126,-4922.177,-4939.157,-4946.972,-4957.132,-4963.611,-4935.1216,-4914.728,-4898.416,-4889.622,-4899.339,-4871.7812,-4851.591,-4839.748,-4846.4653,-4878.2354,-4863.8027,-4838.0083,-4820.223,-4765.088,-4726.0854,-4786.5786,-4823.7866};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_141()
		{
			double[] value = {-4877.978,-4757.2217,-4651.008,-4783.4395,-4771.771,-4774.449,-4853.8765,-4863.552,-4789.5244,-4746.6323,-4747.4253,-4711.983,-4725.0024,-4863.3457,-4940.194,-5014.2954,-5091.354,-5166.4414,-5224.173,-5142.346,-5046.261,-5013.688,-4990.3755,-4914.5703,-4958.4536,-4940.6724,-4831.594,-4827.013,-4821.7783,-4810.189,-4801.24,-4797.863,-4800.729,-4783.682,-4772.615,-4788.061,-4791.9155,-4789.256,-4768.917,-4764.4814,-4755.147,-4716.9897,-4767.8247,-4800.0337,-4817.0303,-4734.676,-4672.4604,-4650.039,-4649.651,-4623.4917,-4689.1143,-4752.758,-4790.707,-4764.6904,-4722.556,-4746.9077,-4766.0664,-4756.788,-4699.176,-4706.01,-4739.472,-4727.9814,-4753.075,-4768.2573,-4767.896,-4787.4795,-4789.2896,-4787.2246,-4779.872,-4774.95,-4761.8545,-4742.8745,-4742.2065,-4757.5894,-4774.623,-4795.617,-4807.6675,-4838.715,-4888.912,-4909.7227,-4962.421,-4952.628,-4873.5645,-4843.881,-4855.5024,-4832.1733,-4806.3228,-4790.569,-4658.804,-4720.3438,-4754.427,-4772.2935,-4772.7676,-4810.7354,-4838.9956,-4816.427,-4723.802,-4787.261,-4880.057,-4835.9966};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_142()
		{
			double[] value = {-4783.4907,-4743.993,-4651.207,-4680.255,-4698.6133,-4776.7812,-4870.1787,-4918.023,-4949.9863,-4913.656,-4908.1914,-4913.9146,-4912.057,-4905.8306,-4922.6396,-4910.7637,-4915.6543,-4909.4834,-4900.064,-4890.683,-4897.2153,-4898.7866,-4865.992,-4757.645,-4626.963,-4727.909,-4738.276,-4767.397,-4902.351,-5079.445,-4387.0684,-4431.9434,-4537.7715,-4638.441,-4690.82,-4706.354,-4704.0303,-4698.124,-4748.751,-4773.1006,-4670.7017,-4715.7817,-4738.7,-5005.482,-5066.6294,-4973.9536,-4905.844,-4923.3438,-4958.674,-4842.2334,-4851.375,-4818.751,-4690.6914,-4677.7417,-4799.1953,-4982.9507,-4915.938,-4808.319,-4803.3237,-4809.0513,-4816.1357,-4824.8022,-4835.765,-4814.2427,-4803.608,-4776.626,-4763.67,-4788.3853,-4803.578,-4807.3125,-4822.8765,-4802.5244,-4816.0635,-4832.724,-4819.562,-4791.086,-4751.683,-4745.983,-4780.3306,-4797.851,-4810.9375,-4769.4253,-4742.3296,-4768.3057,-4771.167,-4755.218,-4753.3433,-4759.9746,-4784.311,-4790.0312,-4817.1406,-4823.958,-4823.408,-4842.2017,-4844.8125,-4824.5337,-4834.619,-4823.778,-4804.3794,-4797.6772};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_143()
		{
			double[] value = {-4794.0947,-4797.619,-4807.327,-4832.83,-4845.1475,-4853.477,-4862.5005,-4867.233,-4866.323,-4850.2437,-4854.8296,-4841.136,-4832.842,-4812.7666,-4813.668,-4794.8086,-4773.2417,-4731.71,-4681.4316,-4690.0713,-4705.045,-4708.6826,-4697.669,-4734.5156,-4701.39,-4781.8057,-4863.2983,-4823.5796,-4829.6406,-4808.276,-4771.463,-4761.8257,-4771.481,-4796.6865,-4827.2905,-4847.687,-4852.7334,-4890.2524,-4884.7847,-4892.6323,-4902.4487,-4888.7305,-4856.3203,-4816.88,-4830.8804,-4839.8237,-4825.2227,-4801.399,-4802.152,-4821.1377,-4782.8867,-4773.2085,-4740.9004,-4676.7734,-4658.3843,-4646.9443,-4659.3154,-4675.707,-4712.3833,-4687.9062,-4712.7417,-4690.0737,-4654.245,-4664.8394,-4739.26,-4770.6274,-4748.499,-4738.754,-4722.666,-4672.0083,-4768.6543,-4704.187,-4740.345,-4787.646,-4768.185,-4855.3687,-4917.6416,-4977.338,-4994.4614,-4980.684,-4945.9727,-4932.597,-4974.0483,-5030.8423,-4940.9062,-4785.494,-4763.691,-4765.2764,-4777.14,-4754.0312,-4766.7603,-4777.245,-4831.3945,-4770.2983,-4789.131,-4811.2974,-4824.751,-4832.974,-4823.0513,-4800.1294};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_144()
		{
			double[] value = {-4813.811,-4843.119,-4855.542,-4854.5547,-4867.071,-4857.38,-4853.677,-4869.337,-4891.1187,-4863.569,-4854.2417,-4850.4,-4835.904,-4827.31,-4844.396,-4861.3657,-4874.625,-4879.023,-4886.828,-4893.485,-4892.5264,-4868.797,-4855.8735,-4850.9673,-4863.4316,-4856.2666,-4874.5664,-4884.102,-4884.8003,-4878.0576,-4880.846,-4861.2305,-4864.627,-4871.993,-4871.6885,-4884.662,-4854.559,-4864.349,-4886.203,-4845.833,-4797.963,-4778.2593,-4811.94,-4807.506,-4799.893,-4813.5586,-4804.2046,-4802.279,-4796.2744,-4795.55,-4800.992,-4810.547,-4791.8154,-4793.13,-4794.2915,-4795.7886,-4810.4136,-4795.968,-4810.3804,-4813.266,-4812.236,-4828.978,-4831.256,-4823.3623,-4817.326,-4823.959,-4788.8228,-4753.3115,-4783.606,-4821.319,-4841.688,-4864.24,-4876.5654,-4857.045,-4850.6875,-4829.3594,-4845.7744,-4837.541,-4805.7197,-4833.4717,-4865.8325,-4866.053,-4870.1323,-4868.9043,-4894.348,-4910.522,-4912.627,-4914.863,-4891.8784,-4808.661,-4798.1587,-4797.466,-4834.883,-4857.6094,-4881.018,-4911.17,-4906.6855,-4896.9053,-4888.946,-4877.89};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_145()
		{
			double[] value = {-4890.1914,-4911.974,-4917.005,-4931.3193,-4944.5757,-4947.3623,-4949.9033,-4938.6895,-4930.5,-4912.018,-4890.346,-4906.962,-4856.3857,-4807.0537,-4790.9966,-4797.161,-4786.0493,-4765.5967,-4791.822,-4783.73,-4785.884,-4746.567,-4770.337,-4805.4453,-4794.7534,-4801.182,-4803.272,-4813.745,-4830.7515,-4847.424,-4871.3403,-4890.426,-4865.602,-4846.4873,-4859.7207,-4861.32,-4868.276,-4863.6123,-4859.2217,-4845.434,-4851.307,-4850.162,-4854.513,-4868.1123,-4882.849,-4887.7925,-4894.401,-4892.5586,-4896.552,-4892.9707,-4879.9966,-4876.8047,-4889.62,-4878.2373,-4895.7915,-4909.166,-4895.787,-4900.276,-4895.818,-4880.257,-4861.0093,-4855.839,-4858.9663,-4877.9634,-4741.2383,-4744.1587,-4704.3105,-4704.979,-4697.129,-4685.4717,-4696.124,-4696.762,-4696.7363,-4694.3433,-4701.437,-4700.325,-4698.7383,-4695.4233,-4693.01,-4691.0605,-4689.5337,-4689.079,-4686.0044,-4682.7026,-4679.9326,-4677.0815,-4670.162,-4662.646,-4647.801,-4664.8945,-4676.7236,-4682.479,-4685.5205,-4686.414,-4686.4263,-4687.3887,-4692.7134,-4705.865,-4734.5903,-4677.2334};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_146()
		{
			double[] value = {-4670.958,-4712.2935,-4719.734,-4729.288,-4735.681,-4743.3296,-4755.591,-4770.886,-4721.1313,-4752.3594,-4753.433,-4759.6797,-4764.193,-4767.8813,-4769.1733,-4769.7285,-4772.579,-4778.8125,-4774.1934,-4774.9536,-4769.785,-4777.1978,-4781.825,-4785.747,-4786.785,-4796.7563,-4799.6587,-4794.893,-4796.0815,-4816.538,-4824.7456,-4832.6455,-4838.41,-4874.0884,-4900.2563,-4830.8354,-4827.035,-4804.996,-4814.0073,-4808.9106,-4794.119,-4769.509,-4782.7656,-4799.71,-4800.0283,-4763.1035,-4763.142,-4792.8867,-4807.969,-4815.1055,-4820.19,-4822.6206,-4820.6304,-4818.8706,-4826.9536,-4845.3843,-4854.1553,-4853.176,-4853.587,-4850.8,-4826.3506,-4812.7705,-4824.201,-4839.3403,-4853.089,-4843.715,-4832.8047,-4851.6694,-4872.305,-4893.4487,-4904.1157,-4900.047,-4895.6733,-4879.063,-4869.541,-4862.5864,-4875.233,-4883.5996,-4890.0317,-4898.207,-4903.798,-4901.371,-4888.0103,-4889.591,-4891.3276,-4884.937,-4887.361,-4878.8047,-4871.2026,-4878.514,-4880.553,-4871.141,-4542.6836,-4537.3247,-4530.3364,-4525.6064,-4520.7983,-4516.837,-4513.726,-4511.117};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_147()
		{
			double[] value = {-4508.8564,-4507.4487,-4507.1953,-4507.8735,-4506.8257,-4506.6934,-4506.9634,-4507.739,-4509.4775,-4513.7437,-4512.117,-4512.9336,-4514.452,-4516.7607,-4517.888,-4521.469,-4522.0703,-4526.4194,-4530.852,-4534.716,-4538.5845,-4542.811,-4547.606,-4552.5215,-4556.7593,-4561.9473,-4568.1416,-4570.61,-4573.0366,-4577.1304,-4581.222,-4585.264,-4588.9526,-4591.2783,-4593.805,-4595.428,-4595.528,-4595.7397,-4595.011,-4596.539,-4597.675,-4598.446,-4599.043,-4600.4536,-4601.5796,-4601.0693,-4597.9146,-4601.097,-4607.1704,-4610.349,-4613.6323,-4617.0093,-4620.157,-4623.51,-4627.4644,-4631.326,-4635.679,-4640.932,-4646.3354,-4651.7793,-4659.8823,-4669.6245,-4679.339,-4661.3145,-4665.149,-4667.2544,-4669.541,-4671.6934,-4684.7764,-4688.5967,-4695.5776,-4709.1416,-4721.302,-4731.673,-4741.863,-4752.987,-4765.6636,-4781.7295,-4799.2983,-4815.7896,-4833.877,-4852.783,-4874.35,-4898.193,-4909.3975,-4906.019,-4916.68,-4912.7876,-4886.9497,-4859.723,-4852.715,-4857.6885,-4857.818,-4860.214,-4862.582,-4867.7153,-4873.2183,-4873.1274,-4891.7163,-4904.617};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_148()
		{
			double[] value = {-4910.7427,-4895.8384,-4885.602,-4866.8506,-4864.1274,-4865.8354,-4879.402,-4891.183,-4897.8267,-4899.532,-4889.327,-4882.072,-4884.1104,-4887.0146,-4893.666,-4901.506,-4906.137,-4906.5674,-4909.484,-4907.9346,-4401.698,-4402.859,-4404.0093,-4405.209,-4407.956,-4415.6016,-4424.213,-4431.947,-4436.787,-4439.07,-4431.2056,-4424.3677,-4427.681,-4425.886,-4422.3647,-4418.365,-4414.419,-4411.8164,-4410.822,-4410.0513,-4410.5337,-4412.78,-4414.752,-4418.999,-4422.189,-4426.435,-4432.206,-4435.1074,-4441.263,-4447.2144,-4453.788,-4459.447,-4465.9673,-4469.6694,-4477.2393,-4482.3223,-4486.52,-4491.6797,-4495.834,-4499.9883,-4504.1426,-4508.251,-4510.782,-4512.9727,-4515.6587,-4518.9077,-4520.121,-4523.185,-4525.753,-4528.0527,-4529.989,-4531.7847,-4534.1465,-4537.057,-4539.0728,-4541.819,-4543.706,-4547.8354,-4551.1562,-4553.524,-4558.374,-4561.582,-4565.7812,-4569.9355,-4575.397,-4580.994,-4586.681,-4593.591,-4601.5225,-4610.1636,-4619.1675,-4630.661,-4641.1323,-4652.66,-4666.003,-4679.866,-4693.9263,-4709.606,-4728.0522,-4749.9536};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_149()
		{
			double[] value = {-4773.48,-4797.536,-4827.7524,-4855.5547,-4843.502,-4842.907,-4837.0884,-4822.08,-4801.589,-4783.7925,-4772.963,-4770.4224,-4786.1655,-4837.9907,-4849.6963,-4809.173,-4769.8384,-4750.4517,-4796.9263,-4784.4297,-4785.913,-4740.123,-4673.269,-4665.8223,-4591.5938,-4579.777,-4492.7764,-4479.752,-4498.4263,-4534.176,-4528.573,-4563.903,-4675.264,-4783.285,-4826.6523,-4828.9067,-4823.8945,-4821.6294,-4825.0713,-4830.0547,-4838.111,-4863.824,-4886.227,-4868.6016,-4871.605,-4877.576,-4894.2476,-4922.9795,-4282.887,-4284.23,-4286.7754,-4288.611,-4291.7227,-4297.7744,-4307.214,-4319.091,-4331.2046,-4337.8057,-4332.101,-4309.6997,-4302.4126,-4364.3193,-4337.01,-4293.8394,-4320.719,-4326.532,-4333.82,-4339.5312,-4346.334,-4352.6396,-4358.212,-4363.301,-4367.725,-4372.087,-4377.47,-4383.1094,-4387.95,-4393.351,-4398.1055,-4403.279,-4409.0386,-4413.5596,-4419.181,-4424.2134,-4428.9575,-4432.9355,-4438.1143,-4442.6924,-4446.916,-4450.5415,-4454.718,-4458.9414,-4463.2617,-4467.314,-4471.2476,-4474.654,-4479.0596,-4482.9404,-4487.216,-4490.7925};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_150()
		{
			double[] value = {-4494.956,-4499.0664,-4504.063,-4509.333,-4514.0845,-4519.424,-4524.702,-4530.0425,-4535.4775,-4541.7837,-4548.0967,-4556.1396,-4562.5903,-4569.845,-4578.0674,-4587.7026,-4594.365,-4602.3145,-4609.4087,-4614.743,-4617.3237,-4620.494,-4625.413,-4629.246,-4616.227,-4614.557,-4621.47,-4624.206,-4630.636,-4644.295,-4679.0674,-4717.24,-4733.808,-4696.984,-4705.9077,-4745.669,-4742.135,-4720.8135,-4731.519,-4746.67,-4719.743,-4702.9194,-4642.4326,-4504.8237,-4404.385,-4366.023,-4353.766,-4345.4424,-4360.102,-4341.179,-4311.881,-4323.137,-4341.036,-4426.911,-4307.964,-4219.7676,-4196.8984,-4197.9473,-4204.202,-4198.0034,-4177.899,-4156.7373,-4214.7393,-4264.415,-4264.4756,-4286.761,-4434.1353,-4496.5674,-4473.5903,-4539.3867,-4562.405,-4580.6606,-4596.318,-4587.0703,-4596.445,-4606.7617,-4207.6904,-4208.45,-4210.208,-4212.787,-4215.804,-4218.5034,-4222.576,-4226.5005,-4230.549,-4233.8975,-4233.5894,-4228.433,-4227.549,-4246.449,-4237.907,-4222.3335,-4229.9478,-4233.8213,-4240.0264,-4248.091,-4257.7627,-4267.0215,-4276.0786,-4283.617};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_151()
		{
			double[] value = {-4292.9175,-4299.37,-4305.392,-4312.755,-4320.0786,-4326.1616,-4332.215,-4338.6416,-4344.4795,-4350.1143,-4355.5625,-4361.921,-4368.1284,-4373.8735,-4378.436,-4383.885,-4388.1084,-4393.0347,-4397.568,-4402.8594,-4408.037,-4412.2607,-4416.2515,-4421.0933,-4425.876,-4430.5684,-4437.3193,-4442.915,-4448.166,-4453.741,-4459.957,-4465.478,-4469.2827,-4474.1895,-4479.1685,-4484.5283,-4487.6743,-4488.618,-4496.421,-4506.322,-4502.6733,-4498.985,-4503.043,-4485.476,-4466.964,-4454.39,-4448.1353,-4445.3228,-4436.15,-4426.5923,-4413.889,-4404.668,-4426.1187,-4445.193,-4461.505,-4497.249,-4522.6934,-4554.7534,-4593.262,-4595.2437,-4595.218,-4573.383,-4508.6973,-4432.477,-4362.8516,-4305.793,-4313.533,-4352.5967,-4379.729,-4384.496,-4317.5234,-4257.538,-4217.959,-4194.5444,-4176.8125,-4178.697,-4207.447,-4251.6313,-4267.0073,-4217.5625,-4117.763,-4036.5833,-4003.3894,-3975.7927,-3977.351,-3998.476,-4014.772,-4013.6365,-4005.6323,-3994.6597,-3982.6516,-3967.9146,-3942.9578,-3936.0544,-3947.869,-3969.0923,-3996.131,-4046.0994,-4078.3723,-4069.9167};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_152()
		{
			double[] value = {-4058.3706,-4042.8677,-4047.0603,-4053.6985,-4181.7407,-4181.925,-4182.8086,-4183.1724,-4182.7144,-4181.784,-4181.9946,-4181.9917,-4181.2188,-4179.811,-4178.4033,-4177.6855,-4177.8643,-4178.258,-4179.7095,-4182.4126,-4185.738,-4188.7266,-4192.2134,-4195.7056,-4198.029,-4200.693,-4203.61,-4206.6895,-4211.2456,-4217.084,-4222.564,-4229.5244,-4236.991,-4242.959,-4249.101,-4254.275,-4259.9497,-4265.2144,-4269.408,-4274.564,-4280.3394,-4283.983,-4287.3706,-4291.64,-4296.6714,-4304.306,-4311.7026,-4319.459,-4325.738,-4331.5425,-4337.5225,-4342.873,-4349.589,-4354.3525,-4360.524,-4366.9907,-4371.963,-4376.163,-4381.502,-4386.9487,-4392.3755,-4395.8804,-4399.8755,-4403.003,-4405.9175,-4411.97,-4416.996,-4419.4336,-4421.254,-4417.4126,-4409.6006,-4401.175,-4391.6777,-4383.3613,-4369.551,-4353.417,-4340.431,-4336.777,-4348.22,-4353.9067,-4353.5264,-4430.6714,-4529.633,-4554.439,-4468.924,-4254.3657,-4159.432,-4070.2458,-4022.7886,-3974.0503,-3925.8684,-3905.4592,-3982.5364,-4033.8494,-4068.8293,-4072.6401,-4037.1492,-3989.6199,-4009.1733,-4047.3745};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_153()
		{
			double[] value = {-4063.316,-4068.5366,-4071.573,-4058.2407,-4039.7961,-3962.6714,-3863.5603,-3839.1648,-3833.7756,-3833.0564,-3917.4907,-4000.7512,-3999.5654,-3914.5332,-3826.6184,-3776.6062,-3742.9465,-3721.9324,-3718.4363,-3725.449,-3743.388,-3760.6768,-3765.6357,-3753.8984,-3728.0874,-3681.6328,-3637.5776,-3623.2986,-3629.2332,-3640.0188,-3655.5564,-3673.8188,-4151.5186,-4147.1064,-4143.498,-4140.9243,-4138.433,-4135.457,-4133.338,-4132.32,-4131.033,-4130.229,-4128.8213,-4128.104,-4128.5244,-4129.0625,-4130.8936,-4134.222,-4139.108,-4143.2993,-4145.9395,-4145.813,-4145.6533,-4147.386,-4151.951,-4157.2456,-4162.204,-4168.979,-4173.622,-4176.428,-4178.96,-4182.892,-4185.579,-4187.4346,-4189.1313,-4191.0522,-4194.2026,-4198.773,-4201.391,-4203.3506,-4205.696,-4208.4824,-4210.4277,-4214.83,-4218.417,-4222.101,-4219.4043,-4223.1353,-4233.572,-4237.1543,-4242.7705,-4247.2026,-4255.1245,-4263.059,-4257.0327,-4253.302,-4255.2886,-4258.183,-4263.585,-4270.9316,-4279.507,-4291.9834,-4304.7515,-4315.6875,-4324.278,-4334.019,-4342.0347,-4347.7915,-4353.776,-4352.897};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_154()
		{
			double[] value = {-4340.5103,-4340.961,-4380.0586,-4395.1323,-4402.684,-4417.6714,-4456.939,-4479.768,-4411.1475,-4268.234,-4148.696,-4188.2607,-4134.728,-3960.1304,-3801.3723,-3727.4749,-3712.996,-3731.1865,-3769.3032,-3817.6624,-3856.1824,-3930.042,-4046.1746,-4076.2954,-3905.6255,-3787.897,-3731.666,-3673.2058,-3620.9763,-3608.5432,-3608.9243,-3621.9739,-3648.9304,-3673.057,-3679.2554,-3682.593,-3691.8298,-3752.398,-3827.1216,-3770.2495,-3607.9265,-3540.3816,-3565.427,-3599.2703,-3617.9521,-3604.9016,-3575.1045,-3552.37,-3547.2458,-3545.7314,-3535.2583,-3524.8064,-3520.8867,-3515.679,-3508.0652,-3501.59,-3488.3613,-3471.7183,-3459.3218,-3452.8699,-4175.8613,-4175.4976,-4175.67,-4171.5005,-4167.3354,-4164.065,-4159.2705,-4152.7656,-4147.28,-4145.3857,-4147.9863,-4152.734,-4161.393,-4170.439,-4178.636,-4185.317,-4186.659,-4181.881,-4174.343,-4164.2266,-4159.9854,-4153.86,-4149.4136,-4147.3574,-4149.517,-4156.0127,-4165.9395,-4174.322,-4176.918,-4178.146,-4170.3457,-4150.4287,-4132.379,-4129.0527,-4142.225,-4159.6187,-4178.7354,-4197.9863,-4210.2812,-4202.4272};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_155()
		{
			double[] value = {-4179.9453,-4168.085,-4162.717,-4169.4404,-4185.914,-4192.4365,-4198.0845,-4200.8174,-4202.2715,-4207.575,-4223.4478,-4245.5747,-4253.0933,-4261.7583,-4248.1895,-4180.842,-4141.876,-4209.8926,-4216.8096,-4163.324,-4090.7075,-4013.4485,-3965.7305,-3913.6802,-3858.1812,-3815.4663,-3768.3396,-3741.867,-3728.9893,-3747.2827,-3778.8943,-3856.0142,-3898.0652,-3932.0598,-3966.7336,-3934.7207,-3926.434,-3927.4478,-3917.5056,-3889.884,-3839.5293,-3784.1917,-3759.165,-3800.437,-3846.8328,-3877.0435,-3893.3064,-3929.785,-3912.8555,-3891.9526,-3800.7056,-3722.613,-3688.837,-3637.355,-3623.0637,-3643.4094,-3673.4368,-3702.8916,-3729.8096,-3750.6846,-3741.7344,-3696.7793,-3646.4946,-3609.2012,-3595.2969,-3581.291,-3563.8071,-3541.3118,-3514.8274,-3494.773,-3451.8674,-3367.4785,-3291.4753,-3249.3037,-3229.8257,-3223.4404,-3222.5654,-3221.002,-3218.7014,-3218.4878,-3222.3198,-3225.1443,-3232.2227,-3235.0598,-3224.8875,-3205.3933,-3189.0098,-3174.665,-4265.4526,-4259.3096,-4249.9727,-4225.181,-4198.0723,-4179.251,-4170.5415,-4160.2866,-4157.027,-4146.094,-4143.5864,-4136.51};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_156()
		{
			double[] value = {-4133.27,-4158.8193,-4202.7983,-4217.444,-4117.4155,-3915.0784,-3863.244,-3913.2498,-3936.3523,-3980.1077,-4016.3591,-3991.8562,-3948.131,-3905.618,-3848.3633,-3780.1306,-3716.5852,-3712.464,-3748.788,-3765.2583,-3769.7014,-3756.1108,-3737.7617,-3721.3235,-3715.429,-3746.9294,-3772.4495,-3815.6746,-3825.1584,-3770.2922,-3672.412,-3584.1077,-3519.5552,-3467.1636,-3430.4548,-3395.4272,-3373.265,-3358.0366,-3347.4636,-3323.9885,-3331.9128,-3345.4238,-3358.3438,-3356.6401,-3345.7144,-3330.6675,-3321.8306,-3328.5312,-3368.5605,-3444.1973,-3518.758,-3575.4004,-3624.469,-3667.4192,-3697.5396,-3715.1006,-3714.2007,-3700.5952,-3692.3933,-3703.1597,-3726.9272,-3769.0173,-3885.2158,-3977.5923,-3964.6833,-3889.6538,-3861.6194,-3924.6746,-3989.7412,-3983.026,-3939.3015,-3732.5625,-3598.9395,-3591.5906,-3514.0378,-3396.6787,-3259.4492,-3160.9832,-3168.7932,-3275.0598,-3399.757,-3440.7742,-3388.6794,-3308.6555,-3246.105,-3193.4167,-3146.973,-3118.254,-3094.755,-3083.5254,-3093.8567,-3112.6523,-3120.786,-3119.5745,-3119.4539,-3117.1243,-3108.7952,-3096.6345,-3087.7732,-3086.4475};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_157()
		{
			double[] value = {-3085.005,-3094.6697,-3108.8162,-3117.0515,-3125.9128,-3128.505,-3127.6938,-3123.0605,-3113.2266,-3105.3494,-3097.0542,-3094.777,-3094.9353,-3099.3877,-3102.621,-3100.5671,-3945.5078,-3661.705,-3497.4277,-3434.0164,-3411.7083,-3410.8918,-3413.8064,-3414.6626,-3418.686,-3418.748,-3415.8428,-3400.1094,-3385.0615,-3403.2002,-3439.091,-3470.4048,-3471.3403,-3457.727,-3453.855,-3459.4465,-3483.6763,-3472.6958,-3432.7773,-3366.9128,-3316.4702,-3285.9302,-3263.9077,-3258.0076,-3247.5996,-3251.0098,-3249.2751,-3246.4458,-3240.1885,-3235.8252,-3236.8818,-3234.5046,-3232.2373,-3224.941,-3210.059,-3199.9053,-3190.2922,-3180.4873,-3164.8313,-3155.7532,-3145.9866,-3131.814,-3116.4915,-3105.2737,-3097.9688,-3092.098,-3088.8213,-3088.2288,-3087.921,-3086.597,-3081.2268,-3062.7837,-3025.1045,-3006.2893,-3024.0413,-3064.6648,-3100.0247,-3120.3196,-3129.8237,-3130.5889,-3120.5002,-3109.4048,-3100.4517,-3098.8562,-3104.416,-3131.072,-3178.4714,-3240.528,-3276.7454,-3279.582,-3282.9636,-3294.396,-3289.159,-3238.1902,-3165.6892,-3130.2368,-3092.9512,-3048.2124,-3017.0093,-2971.784};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_158()
		{
			double[] value = {-2951.2297,-2934.9607,-2918.194,-2903.664,-2886.8328,-2876.2053,-2870.8218,-2875.0312,-2880.8884,-2879.131,-2874.816,-2875.623,-2873.007,-2871.327,-2879.3914,-2895.6648,-2912.944,-2935.9827,-2951.1184,-2942.589,-2920.748,-2893.88,-2875.8943,-2868.3804,-2869.781,-2874.9128,-2879.5515,-2886.6313,-2896.4482,-2918.5266,-2929.506,-2919.066,-2898.4019,-2873.1504,-2860.6353,-2856.1448,-2858.7703,-2860.5132,-2859.8606,-2865.4646,-2862.93,-2858.111,-2852.2874,-2852.2302,-3114.4578,-3130.5576,-3152.4785,-3167.723,-3175.5308,-3172.9966,-3164.7874,-3160.7935,-3160.083,-3148.865,-3145.7468,-3137.8303,-3131.7654,-3128.268,-3133.559,-3128.3613,-3139.9062,-3131.1348,-3124.746,-3105.213,-3079.277,-3054.0732,-3045.6946,-3043.8071,-3047.4219,-3053.297,-3061.332,-3069.2983,-3078.4463,-3085.5713,-3095.4976,-3101.8638,-3111.3938,-3123.9036,-3134.6147,-3116.9932,-3091.2607,-3071.8704,-3047.9553,-3011.7227,-2978.6584,-2959.5398,-2966.5679,-2979.7937,-2971.6968,-2952.2754,-2936.1008,-2921.6963,-2904.6545,-2886.683,-2867.9812,-2850.1265,-2831.063,-2809.7861,-2787.7039,-2765.9321};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_159()
		{
			double[] value = {-2759.0796,-2766.5735,-2779.6147,-2798.9512,-2820.1326,-2842.2957,-2859.5378,-2877.7947,-2905.4368,-2940.9954,-2970.811,-2986.8027,-2982.6975,-2945.974,-2893.1338,-2837.9524,-2806.1248,-2784.576,-2759.702,-2733.4265,-2722.5327,-2723.0369,-2726.5334,-2729.5042,-2730.4856,-2729.4673,-2728.1912,-2727.0447,-2726.4082,-2726.5862,-2734.461,-2738.969,-2736.6692,-2738.1646,-2747.1716,-2754.0085,-2759.5066,-2763.281,-2763.7195,-2761.0913,-2758.5334,-2765.69,-2768.768,-2761.1829,-2751.6926,-2737.5303,-2726.3733,-2706.792,-2690.0085,-2680.3591,-2662.7578,-2642.314,-2627.947,-2621.5183,-2624.5068,-2623.8215,-2609.576,-2591.3687,-2576.3896,-2568.46,-2564.928,-2565.925,-2570.9102,-2579.8733,-2591.1711,-2599.4,-2605.5264,-2607.751,-2606.4568,-2607.3376,-2608.1672,-2607.4019,-2818.5374,-2828.5774,-2854.4846,-2907.9321,-2926.2517,-2818.7026,-2845.9946,-2821.7808,-2796.8015,-2821.711,-2863.5408,-2903.9973,-2952.955,-2981.158,-2984.5933,-2949.43,-2922.8716,-2911.15,-2864.3574,-2813.2944,-2781.0864,-2767.1687,-2745.3,-2731.2102,-2747.1804,-2760.481,-2766.114,-2762.504};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_160()
		{
			double[] value = {-2753.342,-2744.5615,-2733.1016,-2726.8066,-2736.3699,-2751.5913,-2765.429,-2772.098,-2775.2239,-2755.4922,-2728.536,-2715.5005,-2699.5312,-2678.7654,-2661.958,-2649.9229,-2649.175,-2645.1016,-2653.4607,-2656.173,-2661.0234,-2653.4578,-2647.3567,-2649.379,-2635.9653,-2634.345,-2630.7864,-2634.3337,-2638.4556,-2644.0798,-2651.381,-2662.1885,-2667.616,-2664.0984,-2648.5842,-2620.5588,-2597.6072,-2580.51,-2567.6326,-2556.6694,-2557.6252,-2571.36,-2580.4646,-2574.779,-2570.1697,-2596.8413,-2620.0479,-2601.404,-2644.7668,-2653.3523,-2620.266,-2624.852,-2632.304,-2634.3892,-2636.906,-2648.2646,-2662.2651,-2671.982,-2664.6306,-2645.4583,-2638.4631,-2640.306,-2595.0024,-2557.492,-2540.0159,-2529.9714,-2523.118,-2516.7534,-2507.6587,-2494.9102,-2479.0093,-2462.9783,-2446.122,-2431.682,-2424.356,-2420.6194,-2418.181,-2417.6985,-2419.294,-2428.3762,-2425.3264,-2426.6233,-2429.5552,-2443.4648,-2467.4805,-2481.7786,-2498.3455,-2484.1575,-2477.1445,-2489.5884,-2507.7031,-2532.5308,-2543.5474,-2528.915,-2512.1797,-2509.1436,-2502.3254,-2481.7612,-2450.357,-2412.1382};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_161()
		{
			double[] value = {-2595.1458,-2622.958,-2665.497,-2725.828,-2722.339,-2553.6553,-2468.039,-2507.1401,-2509.9236,-2498.1914,-2493.1313,-2492.8289,-2512.2607,-2524.397,-2538.949,-2548.752,-2548.9463,-2549.2617,-2532.885,-2512.7273,-2516.9,-2536.4893,-2541.046,-2549.4663,-2569.8772,-2576.9487,-2579.8452,-2585.5789,-2582.1035,-2567.7698,-2551.3345,-2539.264,-2540.5923,-2540.2334,-2544.8354,-2539.653,-2516.9973,-2499.9058,-2493.2522,-2491.3254,-2487.3337,-2480.628,-2471.207,-2466.5266,-2469.062,-2466.227,-2504.7058,-2515.4248,-2536.2546,-2504.039,-2480.5193,-2461.5066,-2453.0688,-2453.7258,-2448.0032,-2452.1248,-2444.6416,-2431.375,-2425.7244,-2408.055,-2397.936,-2399.2322,-2409.5266,-2394.5093,-2389.633,-2392.4907,-2394.019,-2393.765,-2400.8792,-2424.5923,-2436.07,-2400.6804,-2379.6235,-2446.918,-2506.5613,-2488.8027,-2526.8877,-2519.7812,-2472.117,-2460.3628,-2463.2485,-2462.8542,-2458.6755,-2455.8337,-2456.079,-2457.1099,-2450.0735,-2428.9075,-2403.6248,-2378.7322,-2325.9932,-2273.4407,-2251.812,-2248.88,-2253.505,-2259.972,-2267.6343,-2277.3718,-2288.098,-2298.427};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_162()
		{
			double[] value = {-2310.5457,-2320.922,-2330.8962,-2347.0862,-2354.148,-2355.72,-2403.6394,-2435.3525,-2443.6477,-2443.6846,-2437.5283,-2433.5964,-2413.3267,-2443.7705,-2442.1104,-2385.2092,-2356.2463,-2355.3005,-2365.9685,-2386.6523,-2388.1272,-2356.386,-2319.8467,-2307.9565,-2302.4275,-2288.0593,-2266.875,-2240.9563,-2393.9297,-2405.3691,-2417.3442,-2429.873,-2432.2566,-2413.253,-2404.953,-2423.5613,-2430.7026,-2433.4001,-2433.1025,-2429.2375,-2414.1165,-2390.538,-2365.9973,-2356.1387,-2349.8599,-2345.0198,-2345.8518,-2384.8225,-2350.2554,-2354.172,-2393.4553,-2369.132,-2380.8562,-2404.8015,-2408.348,-2399.2173,-2360.8745,-2323.364,-2301.9707,-2289.8362,-2286.2256,-2284.9263,-2284.8044,-2279.7634,-2273.1782,-2270.2979,-2275.2659,-2278.3826,-2276.566,-2272.9258,-2269.8948,-2268.8442,-2265.9495,-2263.3936,-2265.1982,-2268.1672,-2269.0627,-2264.3582,-2261.4775,-2257.8076,-2253.5417,-2256.1846,-2254.1672,-2250.9126,-2247.3267,-2242.0933,-2238.812,-2238.6675,-2239.755,-2239.532,-2234.4644,-2223.8784,-2223.0508,-2223.5317,-2222.5647,-2218.366,-2217.9246,-2218.6614,-2218.6995,-2215.2476};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_163()
		{
			double[] value = {-2215.0227,-2228.0967,-2246.7344,-2251.7454,-2250.8242,-2239.7952,-2228.607,-2221.6597,-2213.0828,-2200.81,-2187.7517,-2177.279,-2167.0107,-2158.1714,-2150.4712,-2140.8267,-2130.6736,-2121.6372,-2112.4026,-2103.731,-2099.6785,-2097.9265,-2097.3408,-2098.9111,-2101.021,-2105.0198,-2111.8225,-2119.7705,-2126.083,-2129.479,-2131.119,-2134.6545,-2123.9211,-2108.4421,-2084.9941,-2078.1272,-2089.1943,-2112.925,-2117.9143,-2082.6135,-2050.2922,-2089.9795,-2099.8716,-2086.7693,-2075.015,-2070.7336,-2068.2393,-2068.1326,-2064.0227,-2054.8198,-2045.6404,-2041.3845,-2037.5422,-2032.4487,-2026.5175,-2021.9951,-2164.3826,-2164.6396,-2166.5479,-2161.1306,-2149.949,-2124.5652,-2179.9148,-2242.6243,-2239.4724,-2223.859,-2201.7285,-2176.669,-2146.5173,-2122.8557,-2104.8225,-2089.7441,-2077.4744,-2061.2869,-2050.5127,-2054.7405,-2057.9534,-2048.3845,-2063.2239,-2068.3584,-2073.1,-2075.4902,-2078.369,-2077.9463,-2076.056,-2075.0583,-2073.4949,-2070.7925,-2067.9746,-2064.699,-2062.1106,-2059.0317,-2056.361,-2054.6191,-2050.2688,-2044.487,-2038.7894,-2034.1816,-2042.086,-2077.5598};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_164()
		{
			double[] value = {-2080.8845,-2081.37,-2088.594,-2089.5603,-2095.7124,-2104.374,-2111.4565,-2116.2947,-2075.804,-2063.1248,-2091.7114,-2101.6577,-2104.2349,-2103.2305,-2098.5364,-2092.786,-2086.6023,-2078.7979,-2072.2947,-2065.8389,-2062.215,-2059.5483,-2047.1007,-2024.3264,-2013.552,-2010.1455,-2007.9114,-2007.13,-2007.531,-2007.5657,-2008.025,-2006.5476,-2005.283,-2002.3578,-1997.888,-1996.8113,-1993.9678,-1992.9832,-1989.527,-1988.2867,-1985.4646,-1982.0802,-1979.9194,-1977.7975,-1975.6189,-1972.8381,-1969.5264,-1967.5087,-1964.6929,-1961.5671,-1958.4949,-1955.4768,-1954.4299,-1953.605,-1953.4651,-1951.5653,-1951.9382,-1950.912,-1948.5437,-1947.9729,-1946.1997,-1945.2294,-1943.7816,-1945.2396,-1945.9454,-1949.5901,-1953.6555,-1953.3528,-1950.8076,-1949.5912,-1949.0349,-1948.8303,-1946.6584,-1945.3523,-1942.3331,-1941.5156,-1940.2313,-1940.5026,-1940.6626,-1942.2706,-1940.7799,-1941.7568,-1942.2415,-1944.6355};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.00787,0.00391,0.01575,0.00391,0.02362,0.00391,0.0315,0.00391,0.03937,0.00391,0.04724,0.00391,0.05512,0.00391,0.06299,0.00391,0.07087,0.00391,0.07874,0.00391,0.08661,0.00391,0.09449,0.00391,0.10236,0.00391,0.11024,0.00391,0.11811,0.00391,0.12598,0.00391,0.13386,0.00391,0.14173,0.00391,0.14961,0.00391,0.15748,0.00391,0.16535,0.00391,0.17323,0.00391,0.1811,0.00391,0.18898,0.00391,0.19685,0.00391,0.20472,0.00391,0.2126,0.00391,0.22047,0.00391,0.22835,0.00391,0.23622,0.00391,0.24409,0.00391,0.25197,0.00391,0.25984,0.00391,0.26772,0.00391,0.27559,0.00391,0.28346,0.00391,0.29134,0.00391,0.29921,0.00391,0.30709,0.00391,0.31496,0.00391,0.32283,0.00391,0.33071,0.00391,0.33858,0.00391,0.34646,0.00391,0.35433,0.00391,0.3622,0.00391,0.37008,0.00391,0.37795,0.00391,0.38583,0.00391,0.3937,0.00391,0.40157,0.00391,0.40945,0.00391,0.41732,0.00391,0.4252,0.00391,0.43307,0.00391,0.44094,0.00391,0.44882,0.00391,0.45669,0.00391,0.46457,0.00391,0.47244,0.00391,0.48031,0.00391,0.48819,0.00391,0.49606,0.00391,0.50394,0.00391,0.51181,0.00391,0.51969,0.00391,0.52756,0.00391,0.53543,0.00391,0.54331,0.00391,0.55118,0.00391,0.55906,0.00391,0.56693,0.00391,0.5748,0.00391,0.58268,0.00391,0.59055,0.00391,0.59843,0.00391,0.6063,0.00391,0.61417,0.00391,0.62205,0.00391,0.62992,0.00391,0.6378,0.00391,0.64567,0.00391,0.65354,0.00391,0.66142,0.00391,0.66929,0.00391,0.67717,0.00391,0.68504,0.00391,0.69291,0.00391,0.70079,0.00391,0.70866,0.00391,0.71654,0.00391,0.72441,0.00391,0.73228,0.00391,0.74016,0.00391,0.74803,0.00391,0.75591,0.00391,0.76378,0.00391,0.77165,0.00391,0.77953,0.00391};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.7874,0.00391,0.79528,0.00391,0.80315,0.00391,0.81102,0.00391,0.8189,0.00391,0.82677,0.00391,0.83465,0.00391,0.84252,0.00391,0.85039,0.00391,0.85827,0.00391,0.86614,0.00391,0.87402,0.00391,0.88189,0.00391,0.88976,0.00391,0.89764,0.00391,0.90551,0.00391,0.91339,0.00391,0.92126,0.00391,0.92913,0.00391,0.93701,0.00391,0.94488,0.00391,0.95276,0.00391,0.96063,0.00391,0.9685,0.00391,0.97638,0.00391,0.98425,0.00391,0.99213,0.00391,0.99609,0.00391,0.00391,0.00787,0.00787,0.00787,0.01575,0.00787,0.02362,0.00787,0.0315,0.00787,0.03937,0.00787,0.04724,0.00787,0.05512,0.00787,0.06299,0.00787,0.07087,0.00787,0.07874,0.00787,0.08661,0.00787,0.09449,0.00787,0.10236,0.00787,0.11024,0.00787,0.11811,0.00787,0.12598,0.00787,0.13386,0.00787,0.14173,0.00787,0.14961,0.00787,0.15748,0.00787,0.16535,0.00787,0.17323,0.00787,0.1811,0.00787,0.18898,0.00787,0.19685,0.00787,0.20472,0.00787,0.2126,0.00787,0.22047,0.00787,0.22835,0.00787,0.23622,0.00787,0.24409,0.00787,0.25197,0.00787,0.25984,0.00787,0.26772,0.00787,0.27559,0.00787,0.28346,0.00787,0.29134,0.00787,0.29921,0.00787,0.30709,0.00787,0.31496,0.00787,0.32283,0.00787,0.33071,0.00787,0.33858,0.00787,0.34646,0.00787,0.35433,0.00787,0.3622,0.00787,0.37008,0.00787,0.37795,0.00787,0.38583,0.00787,0.3937,0.00787,0.40157,0.00787,0.40945,0.00787,0.41732,0.00787,0.4252,0.00787,0.43307,0.00787,0.44094,0.00787,0.44882,0.00787,0.45669,0.00787,0.46457,0.00787,0.47244,0.00787,0.48031,0.00787,0.48819,0.00787,0.49606,0.00787,0.50394,0.00787,0.51181,0.00787,0.51969,0.00787,0.52756,0.00787,0.53543,0.00787,0.54331,0.00787,0.55118,0.00787,0.55906,0.00787};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.56693,0.00787,0.5748,0.00787,0.58268,0.00787,0.59055,0.00787,0.59843,0.00787,0.6063,0.00787,0.61417,0.00787,0.62205,0.00787,0.62992,0.00787,0.6378,0.00787,0.64567,0.00787,0.65354,0.00787,0.66142,0.00787,0.66929,0.00787,0.67717,0.00787,0.68504,0.00787,0.69291,0.00787,0.70079,0.00787,0.70866,0.00787,0.71654,0.00787,0.72441,0.00787,0.73228,0.00787,0.74016,0.00787,0.74803,0.00787,0.75591,0.00787,0.76378,0.00787,0.77165,0.00787,0.77953,0.00787,0.7874,0.00787,0.79528,0.00787,0.80315,0.00787,0.81102,0.00787,0.8189,0.00787,0.82677,0.00787,0.83465,0.00787,0.84252,0.00787,0.85039,0.00787,0.85827,0.00787,0.86614,0.00787,0.87402,0.00787,0.88189,0.00787,0.88976,0.00787,0.89764,0.00787,0.90551,0.00787,0.91339,0.00787,0.92126,0.00787,0.92913,0.00787,0.93701,0.00787,0.94488,0.00787,0.95276,0.00787,0.96063,0.00787,0.9685,0.00787,0.97638,0.00787,0.98425,0.00787,0.99213,0.00787,0.99609,0.00787,0.00391,0.01575,0.00787,0.01575,0.01575,0.01575,0.02362,0.01575,0.0315,0.01575,0.03937,0.01575,0.04724,0.01575,0.05512,0.01575,0.06299,0.01575,0.07087,0.01575,0.07874,0.01575,0.08661,0.01575,0.09449,0.01575,0.10236,0.01575,0.11024,0.01575,0.11811,0.01575,0.12598,0.01575,0.13386,0.01575,0.14173,0.01575,0.14961,0.01575,0.15748,0.01575,0.16535,0.01575,0.17323,0.01575,0.1811,0.01575,0.18898,0.01575,0.19685,0.01575,0.20472,0.01575,0.2126,0.01575,0.22047,0.01575,0.22835,0.01575,0.23622,0.01575,0.24409,0.01575,0.25197,0.01575,0.25984,0.01575,0.26772,0.01575,0.27559,0.01575,0.28346,0.01575,0.29134,0.01575,0.29921,0.01575,0.30709,0.01575,0.31496,0.01575,0.32283,0.01575,0.33071,0.01575,0.33858,0.01575};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.34646,0.01575,0.35433,0.01575,0.3622,0.01575,0.37008,0.01575,0.37795,0.01575,0.38583,0.01575,0.3937,0.01575,0.40157,0.01575,0.40945,0.01575,0.41732,0.01575,0.4252,0.01575,0.43307,0.01575,0.44094,0.01575,0.44882,0.01575,0.45669,0.01575,0.46457,0.01575,0.47244,0.01575,0.48031,0.01575,0.48819,0.01575,0.49606,0.01575,0.50394,0.01575,0.51181,0.01575,0.51969,0.01575,0.52756,0.01575,0.53543,0.01575,0.54331,0.01575,0.55118,0.01575,0.55906,0.01575,0.56693,0.01575,0.5748,0.01575,0.58268,0.01575,0.59055,0.01575,0.59843,0.01575,0.6063,0.01575,0.61417,0.01575,0.62205,0.01575,0.62992,0.01575,0.6378,0.01575,0.64567,0.01575,0.65354,0.01575,0.66142,0.01575,0.66929,0.01575,0.67717,0.01575,0.68504,0.01575,0.69291,0.01575,0.70079,0.01575,0.70866,0.01575,0.71654,0.01575,0.72441,0.01575,0.73228,0.01575,0.74016,0.01575,0.74803,0.01575,0.75591,0.01575,0.76378,0.01575,0.77165,0.01575,0.77953,0.01575,0.7874,0.01575,0.79528,0.01575,0.80315,0.01575,0.81102,0.01575,0.8189,0.01575,0.82677,0.01575,0.83465,0.01575,0.84252,0.01575,0.85039,0.01575,0.85827,0.01575,0.86614,0.01575,0.87402,0.01575,0.88189,0.01575,0.88976,0.01575,0.89764,0.01575,0.90551,0.01575,0.91339,0.01575,0.92126,0.01575,0.92913,0.01575,0.93701,0.01575,0.94488,0.01575,0.95276,0.01575,0.96063,0.01575,0.9685,0.01575,0.97638,0.01575,0.98425,0.01575,0.99213,0.01575,0.99609,0.01575,0.00391,0.02362,0.00787,0.02362,0.01575,0.02362,0.02362,0.02362,0.0315,0.02362,0.03937,0.02362,0.04724,0.02362,0.05512,0.02362,0.06299,0.02362,0.07087,0.02362,0.07874,0.02362,0.08661,0.02362,0.09449,0.02362,0.10236,0.02362,0.11024,0.02362,0.11811,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.12598,0.02362,0.13386,0.02362,0.14173,0.02362,0.14961,0.02362,0.15748,0.02362,0.16535,0.02362,0.17323,0.02362,0.1811,0.02362,0.18898,0.02362,0.19685,0.02362,0.20472,0.02362,0.2126,0.02362,0.22047,0.02362,0.22835,0.02362,0.23622,0.02362,0.24409,0.02362,0.25197,0.02362,0.25984,0.02362,0.26772,0.02362,0.27559,0.02362,0.28346,0.02362,0.29134,0.02362,0.29921,0.02362,0.30709,0.02362,0.31496,0.02362,0.32283,0.02362,0.33071,0.02362,0.33858,0.02362,0.34646,0.02362,0.35433,0.02362,0.3622,0.02362,0.37008,0.02362,0.37795,0.02362,0.38583,0.02362,0.3937,0.02362,0.40157,0.02362,0.40945,0.02362,0.41732,0.02362,0.4252,0.02362,0.43307,0.02362,0.44094,0.02362,0.44882,0.02362,0.45669,0.02362,0.46457,0.02362,0.47244,0.02362,0.48031,0.02362,0.48819,0.02362,0.49606,0.02362,0.50394,0.02362,0.51181,0.02362,0.51969,0.02362,0.52756,0.02362,0.53543,0.02362,0.54331,0.02362,0.55118,0.02362,0.55906,0.02362,0.56693,0.02362,0.5748,0.02362,0.58268,0.02362,0.59055,0.02362,0.59843,0.02362,0.6063,0.02362,0.61417,0.02362,0.62205,0.02362,0.62992,0.02362,0.6378,0.02362,0.64567,0.02362,0.65354,0.02362,0.66142,0.02362,0.66929,0.02362,0.67717,0.02362,0.68504,0.02362,0.69291,0.02362,0.70079,0.02362,0.70866,0.02362,0.71654,0.02362,0.72441,0.02362,0.73228,0.02362,0.74016,0.02362,0.74803,0.02362,0.75591,0.02362,0.76378,0.02362,0.77165,0.02362,0.77953,0.02362,0.7874,0.02362,0.79528,0.02362,0.80315,0.02362,0.81102,0.02362,0.8189,0.02362,0.82677,0.02362,0.83465,0.02362,0.84252,0.02362,0.85039,0.02362,0.85827,0.02362,0.86614,0.02362,0.87402,0.02362,0.88189,0.02362,0.88976,0.02362,0.89764,0.02362,0.90551,0.02362};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.91339,0.02362,0.92126,0.02362,0.92913,0.02362,0.93701,0.02362,0.94488,0.02362,0.95276,0.02362,0.96063,0.02362,0.9685,0.02362,0.97638,0.02362,0.98425,0.02362,0.99213,0.02362,0.99609,0.02362,0.00391,0.0315,0.00787,0.0315,0.01575,0.0315,0.02362,0.0315,0.0315,0.0315,0.03937,0.0315,0.04724,0.0315,0.05512,0.0315,0.06299,0.0315,0.07087,0.0315,0.07874,0.0315,0.08661,0.0315,0.09449,0.0315,0.10236,0.0315,0.11024,0.0315,0.11811,0.0315,0.12598,0.0315,0.13386,0.0315,0.14173,0.0315,0.14961,0.0315,0.15748,0.0315,0.16535,0.0315,0.17323,0.0315,0.1811,0.0315,0.18898,0.0315,0.19685,0.0315,0.20472,0.0315,0.2126,0.0315,0.22047,0.0315,0.22835,0.0315,0.23622,0.0315,0.24409,0.0315,0.25197,0.0315,0.25984,0.0315,0.26772,0.0315,0.27559,0.0315,0.28346,0.0315,0.29134,0.0315,0.29921,0.0315,0.30709,0.0315,0.31496,0.0315,0.32283,0.0315,0.33071,0.0315,0.33858,0.0315,0.34646,0.0315,0.35433,0.0315,0.3622,0.0315,0.37008,0.0315,0.37795,0.0315,0.38583,0.0315,0.3937,0.0315,0.40157,0.0315,0.40945,0.0315,0.41732,0.0315,0.4252,0.0315,0.43307,0.0315,0.44094,0.0315,0.44882,0.0315,0.45669,0.0315,0.46457,0.0315,0.47244,0.0315,0.48031,0.0315,0.48819,0.0315,0.49606,0.0315,0.50394,0.0315,0.51181,0.0315,0.51969,0.0315,0.52756,0.0315,0.53543,0.0315,0.54331,0.0315,0.55118,0.0315,0.55906,0.0315,0.56693,0.0315,0.5748,0.0315,0.58268,0.0315,0.59055,0.0315,0.59843,0.0315,0.6063,0.0315,0.61417,0.0315,0.62205,0.0315,0.62992,0.0315,0.6378,0.0315,0.64567,0.0315,0.65354,0.0315,0.66142,0.0315,0.66929,0.0315,0.67717,0.0315,0.68504,0.0315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.69291,0.0315,0.70079,0.0315,0.70866,0.0315,0.71654,0.0315,0.72441,0.0315,0.73228,0.0315,0.74016,0.0315,0.74803,0.0315,0.75591,0.0315,0.76378,0.0315,0.77165,0.0315,0.77953,0.0315,0.7874,0.0315,0.79528,0.0315,0.80315,0.0315,0.81102,0.0315,0.8189,0.0315,0.82677,0.0315,0.83465,0.0315,0.84252,0.0315,0.85039,0.0315,0.85827,0.0315,0.86614,0.0315,0.87402,0.0315,0.88189,0.0315,0.88976,0.0315,0.89764,0.0315,0.90551,0.0315,0.91339,0.0315,0.92126,0.0315,0.92913,0.0315,0.93701,0.0315,0.94488,0.0315,0.95276,0.0315,0.96063,0.0315,0.9685,0.0315,0.97638,0.0315,0.98425,0.0315,0.99213,0.0315,0.99609,0.0315,0.00391,0.03937,0.00787,0.03937,0.01575,0.03937,0.02362,0.03937,0.0315,0.03937,0.03937,0.03937,0.04724,0.03937,0.05512,0.03937,0.06299,0.03937,0.07087,0.03937,0.07874,0.03937,0.08661,0.03937,0.09449,0.03937,0.10236,0.03937,0.11024,0.03937,0.11811,0.03937,0.12598,0.03937,0.13386,0.03937,0.14173,0.03937,0.14961,0.03937,0.15748,0.03937,0.16535,0.03937,0.17323,0.03937,0.1811,0.03937,0.18898,0.03937,0.19685,0.03937,0.20472,0.03937,0.2126,0.03937,0.22047,0.03937,0.22835,0.03937,0.23622,0.03937,0.24409,0.03937,0.25197,0.03937,0.25984,0.03937,0.26772,0.03937,0.27559,0.03937,0.28346,0.03937,0.29134,0.03937,0.29921,0.03937,0.30709,0.03937,0.31496,0.03937,0.32283,0.03937,0.33071,0.03937,0.33858,0.03937,0.34646,0.03937,0.35433,0.03937,0.3622,0.03937,0.37008,0.03937,0.37795,0.03937,0.38583,0.03937,0.3937,0.03937,0.40157,0.03937,0.40945,0.03937,0.41732,0.03937,0.4252,0.03937,0.43307,0.03937,0.44094,0.03937,0.44882,0.03937,0.45669,0.03937,0.46457,0.03937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.47244,0.03937,0.48031,0.03937,0.48819,0.03937,0.49606,0.03937,0.50394,0.03937,0.51181,0.03937,0.51969,0.03937,0.52756,0.03937,0.53543,0.03937,0.54331,0.03937,0.55118,0.03937,0.55906,0.03937,0.56693,0.03937,0.5748,0.03937,0.58268,0.03937,0.59055,0.03937,0.59843,0.03937,0.6063,0.03937,0.61417,0.03937,0.62205,0.03937,0.62992,0.03937,0.6378,0.03937,0.64567,0.03937,0.65354,0.03937,0.66142,0.03937,0.66929,0.03937,0.67717,0.03937,0.68504,0.03937,0.69291,0.03937,0.70079,0.03937,0.70866,0.03937,0.71654,0.03937,0.72441,0.03937,0.73228,0.03937,0.74016,0.03937,0.74803,0.03937,0.75591,0.03937,0.76378,0.03937,0.77165,0.03937,0.77953,0.03937,0.7874,0.03937,0.79528,0.03937,0.80315,0.03937,0.81102,0.03937,0.8189,0.03937,0.82677,0.03937,0.83465,0.03937,0.84252,0.03937,0.85039,0.03937,0.85827,0.03937,0.86614,0.03937,0.87402,0.03937,0.88189,0.03937,0.88976,0.03937,0.89764,0.03937,0.90551,0.03937,0.91339,0.03937,0.92126,0.03937,0.92913,0.03937,0.93701,0.03937,0.94488,0.03937,0.95276,0.03937,0.96063,0.03937,0.9685,0.03937,0.97638,0.03937,0.98425,0.03937,0.99213,0.03937,0.99609,0.03937,0.00391,0.04724,0.00787,0.04724,0.01575,0.04724,0.02362,0.04724,0.0315,0.04724,0.03937,0.04724,0.04724,0.04724,0.05512,0.04724,0.06299,0.04724,0.07087,0.04724,0.07874,0.04724,0.08661,0.04724,0.09449,0.04724,0.10236,0.04724,0.11024,0.04724,0.11811,0.04724,0.12598,0.04724,0.13386,0.04724,0.14173,0.04724,0.14961,0.04724,0.15748,0.04724,0.16535,0.04724,0.17323,0.04724,0.1811,0.04724,0.18898,0.04724,0.19685,0.04724,0.20472,0.04724,0.2126,0.04724,0.22047,0.04724,0.22835,0.04724,0.23622,0.04724,0.24409,0.04724};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.25197,0.04724,0.25984,0.04724,0.26772,0.04724,0.27559,0.04724,0.28346,0.04724,0.29134,0.04724,0.29921,0.04724,0.30709,0.04724,0.31496,0.04724,0.32283,0.04724,0.33071,0.04724,0.33858,0.04724,0.34646,0.04724,0.35433,0.04724,0.3622,0.04724,0.37008,0.04724,0.37795,0.04724,0.38583,0.04724,0.3937,0.04724,0.40157,0.04724,0.40945,0.04724,0.41732,0.04724,0.4252,0.04724,0.43307,0.04724,0.44094,0.04724,0.44882,0.04724,0.45669,0.04724,0.46457,0.04724,0.47244,0.04724,0.48031,0.04724,0.48819,0.04724,0.49606,0.04724,0.50394,0.04724,0.51181,0.04724,0.51969,0.04724,0.52756,0.04724,0.53543,0.04724,0.54331,0.04724,0.55118,0.04724,0.55906,0.04724,0.56693,0.04724,0.5748,0.04724,0.58268,0.04724,0.59055,0.04724,0.59843,0.04724,0.6063,0.04724,0.61417,0.04724,0.62205,0.04724,0.62992,0.04724,0.6378,0.04724,0.64567,0.04724,0.65354,0.04724,0.66142,0.04724,0.66929,0.04724,0.67717,0.04724,0.68504,0.04724,0.69291,0.04724,0.70079,0.04724,0.70866,0.04724,0.71654,0.04724,0.72441,0.04724,0.73228,0.04724,0.74016,0.04724,0.74803,0.04724,0.75591,0.04724,0.76378,0.04724,0.77165,0.04724,0.77953,0.04724,0.7874,0.04724,0.79528,0.04724,0.80315,0.04724,0.81102,0.04724,0.8189,0.04724,0.82677,0.04724,0.83465,0.04724,0.84252,0.04724,0.85039,0.04724,0.85827,0.04724,0.86614,0.04724,0.87402,0.04724,0.88189,0.04724,0.88976,0.04724,0.89764,0.04724,0.90551,0.04724,0.91339,0.04724,0.92126,0.04724,0.92913,0.04724,0.93701,0.04724,0.94488,0.04724,0.95276,0.04724,0.96063,0.04724,0.9685,0.04724,0.97638,0.04724,0.98425,0.04724,0.99213,0.04724,0.99609,0.04724,0.00391,0.05512,0.00787,0.05512,0.01575,0.05512,0.02362,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.0315,0.05512,0.03937,0.05512,0.04724,0.05512,0.05512,0.05512,0.06299,0.05512,0.07087,0.05512,0.07874,0.05512,0.08661,0.05512,0.09449,0.05512,0.10236,0.05512,0.11024,0.05512,0.11811,0.05512,0.12598,0.05512,0.13386,0.05512,0.14173,0.05512,0.14961,0.05512,0.15748,0.05512,0.16535,0.05512,0.17323,0.05512,0.1811,0.05512,0.18898,0.05512,0.19685,0.05512,0.20472,0.05512,0.2126,0.05512,0.22047,0.05512,0.22835,0.05512,0.23622,0.05512,0.24409,0.05512,0.25197,0.05512,0.25984,0.05512,0.26772,0.05512,0.27559,0.05512,0.28346,0.05512,0.29134,0.05512,0.29921,0.05512,0.30709,0.05512,0.31496,0.05512,0.32283,0.05512,0.33071,0.05512,0.33858,0.05512,0.34646,0.05512,0.35433,0.05512,0.3622,0.05512,0.37008,0.05512,0.37795,0.05512,0.38583,0.05512,0.3937,0.05512,0.40157,0.05512,0.40945,0.05512,0.41732,0.05512,0.4252,0.05512,0.43307,0.05512,0.44094,0.05512,0.44882,0.05512,0.45669,0.05512,0.46457,0.05512,0.47244,0.05512,0.48031,0.05512,0.48819,0.05512,0.49606,0.05512,0.50394,0.05512,0.51181,0.05512,0.51969,0.05512,0.52756,0.05512,0.53543,0.05512,0.54331,0.05512,0.55118,0.05512,0.55906,0.05512,0.56693,0.05512,0.5748,0.05512,0.58268,0.05512,0.59055,0.05512,0.59843,0.05512,0.6063,0.05512,0.61417,0.05512,0.62205,0.05512,0.62992,0.05512,0.6378,0.05512,0.64567,0.05512,0.65354,0.05512,0.66142,0.05512,0.66929,0.05512,0.67717,0.05512,0.68504,0.05512,0.69291,0.05512,0.70079,0.05512,0.70866,0.05512,0.71654,0.05512,0.72441,0.05512,0.73228,0.05512,0.74016,0.05512,0.74803,0.05512,0.75591,0.05512,0.76378,0.05512,0.77165,0.05512,0.77953,0.05512,0.7874,0.05512,0.79528,0.05512,0.80315,0.05512,0.81102,0.05512};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.8189,0.05512,0.82677,0.05512,0.83465,0.05512,0.84252,0.05512,0.85039,0.05512,0.85827,0.05512,0.86614,0.05512,0.87402,0.05512,0.88189,0.05512,0.88976,0.05512,0.89764,0.05512,0.90551,0.05512,0.91339,0.05512,0.92126,0.05512,0.92913,0.05512,0.93701,0.05512,0.94488,0.05512,0.95276,0.05512,0.96063,0.05512,0.9685,0.05512,0.97638,0.05512,0.98425,0.05512,0.99213,0.05512,0.99609,0.05512,0.00391,0.06299,0.00787,0.06299,0.01575,0.06299,0.02362,0.06299,0.0315,0.06299,0.03937,0.06299,0.04724,0.06299,0.05512,0.06299,0.06299,0.06299,0.07087,0.06299,0.07874,0.06299,0.08661,0.06299,0.09449,0.06299,0.10236,0.06299,0.11024,0.06299,0.11811,0.06299,0.12598,0.06299,0.13386,0.06299,0.14173,0.06299,0.14961,0.06299,0.15748,0.06299,0.16535,0.06299,0.17323,0.06299,0.1811,0.06299,0.18898,0.06299,0.19685,0.06299,0.20472,0.06299,0.2126,0.06299,0.22047,0.06299,0.22835,0.06299,0.23622,0.06299,0.24409,0.06299,0.25197,0.06299,0.25984,0.06299,0.26772,0.06299,0.27559,0.06299,0.28346,0.06299,0.29134,0.06299,0.29921,0.06299,0.30709,0.06299,0.31496,0.06299,0.32283,0.06299,0.33071,0.06299,0.33858,0.06299,0.34646,0.06299,0.35433,0.06299,0.3622,0.06299,0.37008,0.06299,0.37795,0.06299,0.38583,0.06299,0.3937,0.06299,0.40157,0.06299,0.40945,0.06299,0.41732,0.06299,0.4252,0.06299,0.43307,0.06299,0.44094,0.06299,0.44882,0.06299,0.45669,0.06299,0.46457,0.06299,0.47244,0.06299,0.48031,0.06299,0.48819,0.06299,0.49606,0.06299,0.50394,0.06299,0.51181,0.06299,0.51969,0.06299,0.52756,0.06299,0.53543,0.06299,0.54331,0.06299,0.55118,0.06299,0.55906,0.06299,0.56693,0.06299,0.5748,0.06299,0.58268,0.06299,0.59055,0.06299};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.59843,0.06299,0.6063,0.06299,0.61417,0.06299,0.62205,0.06299,0.62992,0.06299,0.6378,0.06299,0.64567,0.06299,0.65354,0.06299,0.66142,0.06299,0.66929,0.06299,0.67717,0.06299,0.68504,0.06299,0.69291,0.06299,0.70079,0.06299,0.70866,0.06299,0.71654,0.06299,0.72441,0.06299,0.73228,0.06299,0.74016,0.06299,0.74803,0.06299,0.75591,0.06299,0.76378,0.06299,0.77165,0.06299,0.77953,0.06299,0.7874,0.06299,0.79528,0.06299,0.80315,0.06299,0.81102,0.06299,0.8189,0.06299,0.82677,0.06299,0.83465,0.06299,0.84252,0.06299,0.85039,0.06299,0.85827,0.06299,0.86614,0.06299,0.87402,0.06299,0.88189,0.06299,0.88976,0.06299,0.89764,0.06299,0.90551,0.06299,0.91339,0.06299,0.92126,0.06299,0.92913,0.06299,0.93701,0.06299,0.94488,0.06299,0.95276,0.06299,0.96063,0.06299,0.9685,0.06299,0.97638,0.06299,0.98425,0.06299,0.99213,0.06299,0.99609,0.06299,0.00391,0.07087,0.00787,0.07087,0.01575,0.07087,0.02362,0.07087,0.0315,0.07087,0.03937,0.07087,0.04724,0.07087,0.05512,0.07087,0.06299,0.07087,0.07087,0.07087,0.07874,0.07087,0.08661,0.07087,0.09449,0.07087,0.10236,0.07087,0.11024,0.07087,0.11811,0.07087,0.12598,0.07087,0.13386,0.07087,0.14173,0.07087,0.14961,0.07087,0.15748,0.07087,0.16535,0.07087,0.17323,0.07087,0.1811,0.07087,0.18898,0.07087,0.19685,0.07087,0.20472,0.07087,0.2126,0.07087,0.22047,0.07087,0.22835,0.07087,0.23622,0.07087,0.24409,0.07087,0.25197,0.07087,0.25984,0.07087,0.26772,0.07087,0.27559,0.07087,0.28346,0.07087,0.29134,0.07087,0.29921,0.07087,0.30709,0.07087,0.31496,0.07087,0.32283,0.07087,0.33071,0.07087,0.33858,0.07087,0.34646,0.07087,0.35433,0.07087,0.3622,0.07087,0.37008,0.07087};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.37795,0.07087,0.38583,0.07087,0.3937,0.07087,0.40157,0.07087,0.40945,0.07087,0.41732,0.07087,0.4252,0.07087,0.43307,0.07087,0.44094,0.07087,0.44882,0.07087,0.45669,0.07087,0.46457,0.07087,0.47244,0.07087,0.48031,0.07087,0.48819,0.07087,0.49606,0.07087,0.50394,0.07087,0.51181,0.07087,0.51969,0.07087,0.52756,0.07087,0.53543,0.07087,0.54331,0.07087,0.55118,0.07087,0.55906,0.07087,0.56693,0.07087,0.5748,0.07087,0.58268,0.07087,0.59055,0.07087,0.59843,0.07087,0.6063,0.07087,0.61417,0.07087,0.62205,0.07087,0.62992,0.07087,0.6378,0.07087,0.64567,0.07087,0.65354,0.07087,0.66142,0.07087,0.66929,0.07087,0.67717,0.07087,0.68504,0.07087,0.69291,0.07087,0.70079,0.07087,0.70866,0.07087,0.71654,0.07087,0.72441,0.07087,0.73228,0.07087,0.74016,0.07087,0.74803,0.07087,0.75591,0.07087,0.76378,0.07087,0.77165,0.07087,0.77953,0.07087,0.7874,0.07087,0.79528,0.07087,0.80315,0.07087,0.81102,0.07087,0.8189,0.07087,0.82677,0.07087,0.83465,0.07087,0.84252,0.07087,0.85039,0.07087,0.85827,0.07087,0.86614,0.07087,0.87402,0.07087,0.88189,0.07087,0.88976,0.07087,0.89764,0.07087,0.90551,0.07087,0.91339,0.07087,0.92126,0.07087,0.92913,0.07087,0.93701,0.07087,0.94488,0.07087,0.95276,0.07087,0.96063,0.07087,0.9685,0.07087,0.97638,0.07087,0.98425,0.07087,0.99213,0.07087,0.99609,0.07087,0.00391,0.07874,0.00787,0.07874,0.01575,0.07874,0.02362,0.07874,0.0315,0.07874,0.03937,0.07874,0.04724,0.07874,0.05512,0.07874,0.06299,0.07874,0.07087,0.07874,0.07874,0.07874,0.08661,0.07874,0.09449,0.07874,0.10236,0.07874,0.11024,0.07874,0.11811,0.07874,0.12598,0.07874,0.13386,0.07874,0.14173,0.07874,0.14961,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.15748,0.07874,0.16535,0.07874,0.17323,0.07874,0.1811,0.07874,0.18898,0.07874,0.19685,0.07874,0.20472,0.07874,0.2126,0.07874,0.22047,0.07874,0.22835,0.07874,0.23622,0.07874,0.24409,0.07874,0.25197,0.07874,0.25984,0.07874,0.26772,0.07874,0.27559,0.07874,0.28346,0.07874,0.29134,0.07874,0.29921,0.07874,0.30709,0.07874,0.31496,0.07874,0.32283,0.07874,0.33071,0.07874,0.33858,0.07874,0.34646,0.07874,0.35433,0.07874,0.3622,0.07874,0.37008,0.07874,0.37795,0.07874,0.38583,0.07874,0.3937,0.07874,0.40157,0.07874,0.40945,0.07874,0.41732,0.07874,0.4252,0.07874,0.43307,0.07874,0.44094,0.07874,0.44882,0.07874,0.45669,0.07874,0.46457,0.07874,0.47244,0.07874,0.48031,0.07874,0.48819,0.07874,0.49606,0.07874,0.50394,0.07874,0.51181,0.07874,0.51969,0.07874,0.52756,0.07874,0.53543,0.07874,0.54331,0.07874,0.55118,0.07874,0.55906,0.07874,0.56693,0.07874,0.5748,0.07874,0.58268,0.07874,0.59055,0.07874,0.59843,0.07874,0.6063,0.07874,0.61417,0.07874,0.62205,0.07874,0.62992,0.07874,0.6378,0.07874,0.64567,0.07874,0.65354,0.07874,0.66142,0.07874,0.66929,0.07874,0.67717,0.07874,0.68504,0.07874,0.69291,0.07874,0.70079,0.07874,0.70866,0.07874,0.71654,0.07874,0.72441,0.07874,0.73228,0.07874,0.74016,0.07874,0.74803,0.07874,0.75591,0.07874,0.76378,0.07874,0.77165,0.07874,0.77953,0.07874,0.7874,0.07874,0.79528,0.07874,0.80315,0.07874,0.81102,0.07874,0.8189,0.07874,0.82677,0.07874,0.83465,0.07874,0.84252,0.07874,0.85039,0.07874,0.85827,0.07874,0.86614,0.07874,0.87402,0.07874,0.88189,0.07874,0.88976,0.07874,0.89764,0.07874,0.90551,0.07874,0.91339,0.07874,0.92126,0.07874,0.92913,0.07874,0.93701,0.07874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.94488,0.07874,0.95276,0.07874,0.96063,0.07874,0.9685,0.07874,0.97638,0.07874,0.98425,0.07874,0.99213,0.07874,0.99609,0.07874,0.00391,0.08661,0.00787,0.08661,0.01575,0.08661,0.02362,0.08661,0.0315,0.08661,0.03937,0.08661,0.04724,0.08661,0.05512,0.08661,0.06299,0.08661,0.07087,0.08661,0.07874,0.08661,0.08661,0.08661,0.09449,0.08661,0.10236,0.08661,0.11024,0.08661,0.11811,0.08661,0.12598,0.08661,0.13386,0.08661,0.14173,0.08661,0.14961,0.08661,0.15748,0.08661,0.16535,0.08661,0.17323,0.08661,0.1811,0.08661,0.18898,0.08661,0.19685,0.08661,0.20472,0.08661,0.2126,0.08661,0.22047,0.08661,0.22835,0.08661,0.23622,0.08661,0.24409,0.08661,0.25197,0.08661,0.25984,0.08661,0.26772,0.08661,0.27559,0.08661,0.28346,0.08661,0.29134,0.08661,0.29921,0.08661,0.30709,0.08661,0.31496,0.08661,0.32283,0.08661,0.33071,0.08661,0.33858,0.08661,0.34646,0.08661,0.35433,0.08661,0.3622,0.08661,0.37008,0.08661,0.37795,0.08661,0.38583,0.08661,0.3937,0.08661,0.40157,0.08661,0.40945,0.08661,0.41732,0.08661,0.4252,0.08661,0.43307,0.08661,0.44094,0.08661,0.44882,0.08661,0.45669,0.08661,0.46457,0.08661,0.47244,0.08661,0.48031,0.08661,0.48819,0.08661,0.49606,0.08661,0.50394,0.08661,0.51181,0.08661,0.51969,0.08661,0.52756,0.08661,0.53543,0.08661,0.54331,0.08661,0.55118,0.08661,0.55906,0.08661,0.56693,0.08661,0.5748,0.08661,0.58268,0.08661,0.59055,0.08661,0.59843,0.08661,0.6063,0.08661,0.61417,0.08661,0.62205,0.08661,0.62992,0.08661,0.6378,0.08661,0.64567,0.08661,0.65354,0.08661,0.66142,0.08661,0.66929,0.08661,0.67717,0.08661,0.68504,0.08661,0.69291,0.08661,0.70079,0.08661,0.70866,0.08661,0.71654,0.08661};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.72441,0.08661,0.73228,0.08661,0.74016,0.08661,0.74803,0.08661,0.75591,0.08661,0.76378,0.08661,0.77165,0.08661,0.77953,0.08661,0.7874,0.08661,0.79528,0.08661,0.80315,0.08661,0.81102,0.08661,0.8189,0.08661,0.82677,0.08661,0.83465,0.08661,0.84252,0.08661,0.85039,0.08661,0.85827,0.08661,0.86614,0.08661,0.87402,0.08661,0.88189,0.08661,0.88976,0.08661,0.89764,0.08661,0.90551,0.08661,0.91339,0.08661,0.92126,0.08661,0.92913,0.08661,0.93701,0.08661,0.94488,0.08661,0.95276,0.08661,0.96063,0.08661,0.9685,0.08661,0.97638,0.08661,0.98425,0.08661,0.99213,0.08661,0.99609,0.08661,0.00391,0.09449,0.00787,0.09449,0.01575,0.09449,0.02362,0.09449,0.0315,0.09449,0.03937,0.09449,0.04724,0.09449,0.05512,0.09449,0.06299,0.09449,0.07087,0.09449,0.07874,0.09449,0.08661,0.09449,0.09449,0.09449,0.10236,0.09449,0.11024,0.09449,0.11811,0.09449,0.12598,0.09449,0.13386,0.09449,0.14173,0.09449,0.14961,0.09449,0.15748,0.09449,0.16535,0.09449,0.17323,0.09449,0.1811,0.09449,0.18898,0.09449,0.19685,0.09449,0.20472,0.09449,0.2126,0.09449,0.22047,0.09449,0.22835,0.09449,0.23622,0.09449,0.24409,0.09449,0.25197,0.09449,0.25984,0.09449,0.26772,0.09449,0.27559,0.09449,0.28346,0.09449,0.29134,0.09449,0.29921,0.09449,0.30709,0.09449,0.31496,0.09449,0.32283,0.09449,0.33071,0.09449,0.33858,0.09449,0.34646,0.09449,0.35433,0.09449,0.3622,0.09449,0.37008,0.09449,0.37795,0.09449,0.38583,0.09449,0.3937,0.09449,0.40157,0.09449,0.40945,0.09449,0.41732,0.09449,0.4252,0.09449,0.43307,0.09449,0.44094,0.09449,0.44882,0.09449,0.45669,0.09449,0.46457,0.09449,0.47244,0.09449,0.48031,0.09449,0.48819,0.09449,0.49606,0.09449};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.50394,0.09449,0.51181,0.09449,0.51969,0.09449,0.52756,0.09449,0.53543,0.09449,0.54331,0.09449,0.55118,0.09449,0.55906,0.09449,0.56693,0.09449,0.5748,0.09449,0.58268,0.09449,0.59055,0.09449,0.59843,0.09449,0.6063,0.09449,0.61417,0.09449,0.62205,0.09449,0.62992,0.09449,0.6378,0.09449,0.64567,0.09449,0.65354,0.09449,0.66142,0.09449,0.66929,0.09449,0.67717,0.09449,0.68504,0.09449,0.69291,0.09449,0.70079,0.09449,0.70866,0.09449,0.71654,0.09449,0.72441,0.09449,0.73228,0.09449,0.74016,0.09449,0.74803,0.09449,0.75591,0.09449,0.76378,0.09449,0.77165,0.09449,0.77953,0.09449,0.7874,0.09449,0.79528,0.09449,0.80315,0.09449,0.81102,0.09449,0.8189,0.09449,0.82677,0.09449,0.83465,0.09449,0.84252,0.09449,0.85039,0.09449,0.85827,0.09449,0.86614,0.09449,0.87402,0.09449,0.88189,0.09449,0.88976,0.09449,0.89764,0.09449,0.90551,0.09449,0.91339,0.09449,0.92126,0.09449,0.92913,0.09449,0.93701,0.09449,0.94488,0.09449,0.95276,0.09449,0.96063,0.09449,0.9685,0.09449,0.97638,0.09449,0.98425,0.09449,0.99213,0.09449,0.99609,0.09449,0.00391,0.10236,0.00787,0.10236,0.01575,0.10236,0.02362,0.10236,0.0315,0.10236,0.03937,0.10236,0.04724,0.10236,0.05512,0.10236,0.06299,0.10236,0.07087,0.10236,0.07874,0.10236,0.08661,0.10236,0.09449,0.10236,0.10236,0.10236,0.11024,0.10236,0.11811,0.10236,0.12598,0.10236,0.13386,0.10236,0.14173,0.10236,0.14961,0.10236,0.15748,0.10236,0.16535,0.10236,0.17323,0.10236,0.1811,0.10236,0.18898,0.10236,0.19685,0.10236,0.20472,0.10236,0.2126,0.10236,0.22047,0.10236,0.22835,0.10236,0.23622,0.10236,0.24409,0.10236,0.25197,0.10236,0.25984,0.10236,0.26772,0.10236,0.27559,0.10236};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.28346,0.10236,0.29134,0.10236,0.29921,0.10236,0.30709,0.10236,0.31496,0.10236,0.32283,0.10236,0.33071,0.10236,0.33858,0.10236,0.34646,0.10236,0.35433,0.10236,0.3622,0.10236,0.37008,0.10236,0.37795,0.10236,0.38583,0.10236,0.3937,0.10236,0.40157,0.10236,0.40945,0.10236,0.41732,0.10236,0.4252,0.10236,0.43307,0.10236,0.44094,0.10236,0.44882,0.10236,0.45669,0.10236,0.46457,0.10236,0.47244,0.10236,0.48031,0.10236,0.48819,0.10236,0.49606,0.10236,0.50394,0.10236,0.51181,0.10236,0.51969,0.10236,0.52756,0.10236,0.53543,0.10236,0.54331,0.10236,0.55118,0.10236,0.55906,0.10236,0.56693,0.10236,0.5748,0.10236,0.58268,0.10236,0.59055,0.10236,0.59843,0.10236,0.6063,0.10236,0.61417,0.10236,0.62205,0.10236,0.62992,0.10236,0.6378,0.10236,0.64567,0.10236,0.65354,0.10236,0.66142,0.10236,0.66929,0.10236,0.67717,0.10236,0.68504,0.10236,0.69291,0.10236,0.70079,0.10236,0.70866,0.10236,0.71654,0.10236,0.72441,0.10236,0.73228,0.10236,0.74016,0.10236,0.74803,0.10236,0.75591,0.10236,0.76378,0.10236,0.77165,0.10236,0.77953,0.10236,0.7874,0.10236,0.79528,0.10236,0.80315,0.10236,0.81102,0.10236,0.8189,0.10236,0.82677,0.10236,0.83465,0.10236,0.84252,0.10236,0.85039,0.10236,0.85827,0.10236,0.86614,0.10236,0.87402,0.10236,0.88189,0.10236,0.88976,0.10236,0.89764,0.10236,0.90551,0.10236,0.91339,0.10236,0.92126,0.10236,0.92913,0.10236,0.93701,0.10236,0.94488,0.10236,0.95276,0.10236,0.96063,0.10236,0.9685,0.10236,0.97638,0.10236,0.98425,0.10236,0.99213,0.10236,0.99609,0.10236,0.00391,0.11024,0.00787,0.11024,0.01575,0.11024,0.02362,0.11024,0.0315,0.11024,0.03937,0.11024,0.04724,0.11024,0.05512,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.06299,0.11024,0.07087,0.11024,0.07874,0.11024,0.08661,0.11024,0.09449,0.11024,0.10236,0.11024,0.11024,0.11024,0.11811,0.11024,0.12598,0.11024,0.13386,0.11024,0.14173,0.11024,0.14961,0.11024,0.15748,0.11024,0.16535,0.11024,0.17323,0.11024,0.1811,0.11024,0.18898,0.11024,0.19685,0.11024,0.20472,0.11024,0.2126,0.11024,0.22047,0.11024,0.22835,0.11024,0.23622,0.11024,0.24409,0.11024,0.25197,0.11024,0.25984,0.11024,0.26772,0.11024,0.27559,0.11024,0.28346,0.11024,0.29134,0.11024,0.29921,0.11024,0.30709,0.11024,0.31496,0.11024,0.32283,0.11024,0.33071,0.11024,0.33858,0.11024,0.34646,0.11024,0.35433,0.11024,0.3622,0.11024,0.37008,0.11024,0.37795,0.11024,0.38583,0.11024,0.3937,0.11024,0.40157,0.11024,0.40945,0.11024,0.41732,0.11024,0.4252,0.11024,0.43307,0.11024,0.44094,0.11024,0.44882,0.11024,0.45669,0.11024,0.46457,0.11024,0.47244,0.11024,0.48031,0.11024,0.48819,0.11024,0.49606,0.11024,0.50394,0.11024,0.51181,0.11024,0.51969,0.11024,0.52756,0.11024,0.53543,0.11024,0.54331,0.11024,0.55118,0.11024,0.55906,0.11024,0.56693,0.11024,0.5748,0.11024,0.58268,0.11024,0.59055,0.11024,0.59843,0.11024,0.6063,0.11024,0.61417,0.11024,0.62205,0.11024,0.62992,0.11024,0.6378,0.11024,0.64567,0.11024,0.65354,0.11024,0.66142,0.11024,0.66929,0.11024,0.67717,0.11024,0.68504,0.11024,0.69291,0.11024,0.70079,0.11024,0.70866,0.11024,0.71654,0.11024,0.72441,0.11024,0.73228,0.11024,0.74016,0.11024,0.74803,0.11024,0.75591,0.11024,0.76378,0.11024,0.77165,0.11024,0.77953,0.11024,0.7874,0.11024,0.79528,0.11024,0.80315,0.11024,0.81102,0.11024,0.8189,0.11024,0.82677,0.11024,0.83465,0.11024,0.84252,0.11024};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.85039,0.11024,0.85827,0.11024,0.86614,0.11024,0.87402,0.11024,0.88189,0.11024,0.88976,0.11024,0.89764,0.11024,0.90551,0.11024,0.91339,0.11024,0.92126,0.11024,0.92913,0.11024,0.93701,0.11024,0.94488,0.11024,0.95276,0.11024,0.96063,0.11024,0.9685,0.11024,0.97638,0.11024,0.98425,0.11024,0.99213,0.11024,0.99609,0.11024,0.00391,0.11811,0.00787,0.11811,0.01575,0.11811,0.02362,0.11811,0.0315,0.11811,0.03937,0.11811,0.04724,0.11811,0.05512,0.11811,0.06299,0.11811,0.07087,0.11811,0.07874,0.11811,0.08661,0.11811,0.09449,0.11811,0.10236,0.11811,0.11024,0.11811,0.11811,0.11811,0.12598,0.11811,0.13386,0.11811,0.14173,0.11811,0.14961,0.11811,0.15748,0.11811,0.16535,0.11811,0.17323,0.11811,0.1811,0.11811,0.18898,0.11811,0.19685,0.11811,0.20472,0.11811,0.2126,0.11811,0.22047,0.11811,0.22835,0.11811,0.23622,0.11811,0.24409,0.11811,0.25197,0.11811,0.25984,0.11811,0.26772,0.11811,0.27559,0.11811,0.28346,0.11811,0.29134,0.11811,0.29921,0.11811,0.30709,0.11811,0.31496,0.11811,0.32283,0.11811,0.33071,0.11811,0.33858,0.11811,0.34646,0.11811,0.35433,0.11811,0.3622,0.11811,0.37008,0.11811,0.37795,0.11811,0.38583,0.11811,0.3937,0.11811,0.40157,0.11811,0.40945,0.11811,0.41732,0.11811,0.4252,0.11811,0.43307,0.11811,0.44094,0.11811,0.44882,0.11811,0.45669,0.11811,0.46457,0.11811,0.47244,0.11811,0.48031,0.11811,0.48819,0.11811,0.49606,0.11811,0.50394,0.11811,0.51181,0.11811,0.51969,0.11811,0.52756,0.11811,0.53543,0.11811,0.54331,0.11811,0.55118,0.11811,0.55906,0.11811,0.56693,0.11811,0.5748,0.11811,0.58268,0.11811,0.59055,0.11811,0.59843,0.11811,0.6063,0.11811,0.61417,0.11811,0.62205,0.11811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.62992,0.11811,0.6378,0.11811,0.64567,0.11811,0.65354,0.11811,0.66142,0.11811,0.66929,0.11811,0.67717,0.11811,0.68504,0.11811,0.69291,0.11811,0.70079,0.11811,0.70866,0.11811,0.71654,0.11811,0.72441,0.11811,0.73228,0.11811,0.74016,0.11811,0.74803,0.11811,0.75591,0.11811,0.76378,0.11811,0.77165,0.11811,0.77953,0.11811,0.7874,0.11811,0.79528,0.11811,0.80315,0.11811,0.81102,0.11811,0.8189,0.11811,0.82677,0.11811,0.83465,0.11811,0.84252,0.11811,0.85039,0.11811,0.85827,0.11811,0.86614,0.11811,0.87402,0.11811,0.88189,0.11811,0.88976,0.11811,0.89764,0.11811,0.90551,0.11811,0.91339,0.11811,0.92126,0.11811,0.92913,0.11811,0.93701,0.11811,0.94488,0.11811,0.95276,0.11811,0.96063,0.11811,0.9685,0.11811,0.97638,0.11811,0.98425,0.11811,0.99213,0.11811,0.99609,0.11811,0.00391,0.12598,0.00787,0.12598,0.01575,0.12598,0.02362,0.12598,0.0315,0.12598,0.03937,0.12598,0.04724,0.12598,0.05512,0.12598,0.06299,0.12598,0.07087,0.12598,0.07874,0.12598,0.08661,0.12598,0.09449,0.12598,0.10236,0.12598,0.11024,0.12598,0.11811,0.12598,0.12598,0.12598,0.13386,0.12598,0.14173,0.12598,0.14961,0.12598,0.15748,0.12598,0.16535,0.12598,0.17323,0.12598,0.1811,0.12598,0.18898,0.12598,0.19685,0.12598,0.20472,0.12598,0.2126,0.12598,0.22047,0.12598,0.22835,0.12598,0.23622,0.12598,0.24409,0.12598,0.25197,0.12598,0.25984,0.12598,0.26772,0.12598,0.27559,0.12598,0.28346,0.12598,0.29134,0.12598,0.29921,0.12598,0.30709,0.12598,0.31496,0.12598,0.32283,0.12598,0.33071,0.12598,0.33858,0.12598,0.34646,0.12598,0.35433,0.12598,0.3622,0.12598,0.37008,0.12598,0.37795,0.12598,0.38583,0.12598,0.3937,0.12598,0.40157,0.12598};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.40945,0.12598,0.41732,0.12598,0.4252,0.12598,0.43307,0.12598,0.44094,0.12598,0.44882,0.12598,0.45669,0.12598,0.46457,0.12598,0.47244,0.12598,0.48031,0.12598,0.48819,0.12598,0.49606,0.12598,0.50394,0.12598,0.51181,0.12598,0.51969,0.12598,0.52756,0.12598,0.53543,0.12598,0.54331,0.12598,0.55118,0.12598,0.55906,0.12598,0.56693,0.12598,0.5748,0.12598,0.58268,0.12598,0.59055,0.12598,0.59843,0.12598,0.6063,0.12598,0.61417,0.12598,0.62205,0.12598,0.62992,0.12598,0.6378,0.12598,0.64567,0.12598,0.65354,0.12598,0.66142,0.12598,0.66929,0.12598,0.67717,0.12598,0.68504,0.12598,0.69291,0.12598,0.70079,0.12598,0.70866,0.12598,0.71654,0.12598,0.72441,0.12598,0.73228,0.12598,0.74016,0.12598,0.74803,0.12598,0.75591,0.12598,0.76378,0.12598,0.77165,0.12598,0.77953,0.12598,0.7874,0.12598,0.79528,0.12598,0.80315,0.12598,0.81102,0.12598,0.8189,0.12598,0.82677,0.12598,0.83465,0.12598,0.84252,0.12598,0.85039,0.12598,0.85827,0.12598,0.86614,0.12598,0.87402,0.12598,0.88189,0.12598,0.88976,0.12598,0.89764,0.12598,0.90551,0.12598,0.91339,0.12598,0.92126,0.12598,0.92913,0.12598,0.93701,0.12598,0.94488,0.12598,0.95276,0.12598,0.96063,0.12598,0.9685,0.12598,0.97638,0.12598,0.98425,0.12598,0.99213,0.12598,0.99609,0.12598,0.00391,0.13386,0.00787,0.13386,0.01575,0.13386,0.02362,0.13386,0.0315,0.13386,0.03937,0.13386,0.04724,0.13386,0.05512,0.13386,0.06299,0.13386,0.07087,0.13386,0.07874,0.13386,0.08661,0.13386,0.09449,0.13386,0.10236,0.13386,0.11024,0.13386,0.11811,0.13386,0.12598,0.13386,0.13386,0.13386,0.14173,0.13386,0.14961,0.13386,0.15748,0.13386,0.16535,0.13386,0.17323,0.13386,0.1811,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.18898,0.13386,0.19685,0.13386,0.20472,0.13386,0.2126,0.13386,0.22047,0.13386,0.22835,0.13386,0.23622,0.13386,0.24409,0.13386,0.25197,0.13386,0.25984,0.13386,0.26772,0.13386,0.27559,0.13386,0.28346,0.13386,0.29134,0.13386,0.29921,0.13386,0.30709,0.13386,0.31496,0.13386,0.32283,0.13386,0.33071,0.13386,0.33858,0.13386,0.34646,0.13386,0.35433,0.13386,0.3622,0.13386,0.37008,0.13386,0.37795,0.13386,0.38583,0.13386,0.3937,0.13386,0.40157,0.13386,0.40945,0.13386,0.41732,0.13386,0.4252,0.13386,0.43307,0.13386,0.44094,0.13386,0.44882,0.13386,0.45669,0.13386,0.46457,0.13386,0.47244,0.13386,0.48031,0.13386,0.48819,0.13386,0.49606,0.13386,0.50394,0.13386,0.51181,0.13386,0.51969,0.13386,0.52756,0.13386,0.53543,0.13386,0.54331,0.13386,0.55118,0.13386,0.55906,0.13386,0.56693,0.13386,0.5748,0.13386,0.58268,0.13386,0.59055,0.13386,0.59843,0.13386,0.6063,0.13386,0.61417,0.13386,0.62205,0.13386,0.62992,0.13386,0.6378,0.13386,0.64567,0.13386,0.65354,0.13386,0.66142,0.13386,0.66929,0.13386,0.67717,0.13386,0.68504,0.13386,0.69291,0.13386,0.70079,0.13386,0.70866,0.13386,0.71654,0.13386,0.72441,0.13386,0.73228,0.13386,0.74016,0.13386,0.74803,0.13386,0.75591,0.13386,0.76378,0.13386,0.77165,0.13386,0.77953,0.13386,0.7874,0.13386,0.79528,0.13386,0.80315,0.13386,0.81102,0.13386,0.8189,0.13386,0.82677,0.13386,0.83465,0.13386,0.84252,0.13386,0.85039,0.13386,0.85827,0.13386,0.86614,0.13386,0.87402,0.13386,0.88189,0.13386,0.88976,0.13386,0.89764,0.13386,0.90551,0.13386,0.91339,0.13386,0.92126,0.13386,0.92913,0.13386,0.93701,0.13386,0.94488,0.13386,0.95276,0.13386,0.96063,0.13386,0.9685,0.13386};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.97638,0.13386,0.98425,0.13386,0.99213,0.13386,0.99609,0.13386,0.00391,0.14173,0.00787,0.14173,0.01575,0.14173,0.02362,0.14173,0.0315,0.14173,0.03937,0.14173,0.04724,0.14173,0.05512,0.14173,0.06299,0.14173,0.07087,0.14173,0.07874,0.14173,0.08661,0.14173,0.09449,0.14173,0.10236,0.14173,0.11024,0.14173,0.11811,0.14173,0.12598,0.14173,0.13386,0.14173,0.14173,0.14173,0.14961,0.14173,0.15748,0.14173,0.16535,0.14173,0.17323,0.14173,0.1811,0.14173,0.18898,0.14173,0.19685,0.14173,0.20472,0.14173,0.2126,0.14173,0.22047,0.14173,0.22835,0.14173,0.23622,0.14173,0.24409,0.14173,0.25197,0.14173,0.25984,0.14173,0.26772,0.14173,0.27559,0.14173,0.28346,0.14173,0.29134,0.14173,0.29921,0.14173,0.30709,0.14173,0.31496,0.14173,0.32283,0.14173,0.33071,0.14173,0.33858,0.14173,0.34646,0.14173,0.35433,0.14173,0.3622,0.14173,0.37008,0.14173,0.37795,0.14173,0.38583,0.14173,0.3937,0.14173,0.40157,0.14173,0.40945,0.14173,0.41732,0.14173,0.4252,0.14173,0.43307,0.14173,0.44094,0.14173,0.44882,0.14173,0.45669,0.14173,0.46457,0.14173,0.47244,0.14173,0.48031,0.14173,0.48819,0.14173,0.49606,0.14173,0.50394,0.14173,0.51181,0.14173,0.51969,0.14173,0.52756,0.14173,0.53543,0.14173,0.54331,0.14173,0.55118,0.14173,0.55906,0.14173,0.56693,0.14173,0.5748,0.14173,0.58268,0.14173,0.59055,0.14173,0.59843,0.14173,0.6063,0.14173,0.61417,0.14173,0.62205,0.14173,0.62992,0.14173,0.6378,0.14173,0.64567,0.14173,0.65354,0.14173,0.66142,0.14173,0.66929,0.14173,0.67717,0.14173,0.68504,0.14173,0.69291,0.14173,0.70079,0.14173,0.70866,0.14173,0.71654,0.14173,0.72441,0.14173,0.73228,0.14173,0.74016,0.14173,0.74803,0.14173};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.75591,0.14173,0.76378,0.14173,0.77165,0.14173,0.77953,0.14173,0.7874,0.14173,0.79528,0.14173,0.80315,0.14173,0.81102,0.14173,0.8189,0.14173,0.82677,0.14173,0.83465,0.14173,0.84252,0.14173,0.85039,0.14173,0.85827,0.14173,0.86614,0.14173,0.87402,0.14173,0.88189,0.14173,0.88976,0.14173,0.89764,0.14173,0.90551,0.14173,0.91339,0.14173,0.92126,0.14173,0.92913,0.14173,0.93701,0.14173,0.94488,0.14173,0.95276,0.14173,0.96063,0.14173,0.9685,0.14173,0.97638,0.14173,0.98425,0.14173,0.99213,0.14173,0.99609,0.14173,0.00391,0.14961,0.00787,0.14961,0.01575,0.14961,0.02362,0.14961,0.0315,0.14961,0.03937,0.14961,0.04724,0.14961,0.05512,0.14961,0.06299,0.14961,0.07087,0.14961,0.07874,0.14961,0.08661,0.14961,0.09449,0.14961,0.10236,0.14961,0.11024,0.14961,0.11811,0.14961,0.12598,0.14961,0.13386,0.14961,0.14173,0.14961,0.14961,0.14961,0.15748,0.14961,0.16535,0.14961,0.17323,0.14961,0.1811,0.14961,0.18898,0.14961,0.19685,0.14961,0.20472,0.14961,0.2126,0.14961,0.22047,0.14961,0.22835,0.14961,0.23622,0.14961,0.24409,0.14961,0.25197,0.14961,0.25984,0.14961,0.26772,0.14961,0.27559,0.14961,0.28346,0.14961,0.29134,0.14961,0.29921,0.14961,0.30709,0.14961,0.31496,0.14961,0.32283,0.14961,0.33071,0.14961,0.33858,0.14961,0.34646,0.14961,0.35433,0.14961,0.3622,0.14961,0.37008,0.14961,0.37795,0.14961,0.38583,0.14961,0.3937,0.14961,0.40157,0.14961,0.40945,0.14961,0.41732,0.14961,0.4252,0.14961,0.43307,0.14961,0.44094,0.14961,0.44882,0.14961,0.45669,0.14961,0.46457,0.14961,0.47244,0.14961,0.48031,0.14961,0.48819,0.14961,0.49606,0.14961,0.50394,0.14961,0.51181,0.14961,0.51969,0.14961,0.52756,0.14961};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.53543,0.14961,0.54331,0.14961,0.55118,0.14961,0.55906,0.14961,0.56693,0.14961,0.5748,0.14961,0.58268,0.14961,0.59055,0.14961,0.59843,0.14961,0.6063,0.14961,0.61417,0.14961,0.62205,0.14961,0.62992,0.14961,0.6378,0.14961,0.64567,0.14961,0.65354,0.14961,0.66142,0.14961,0.66929,0.14961,0.67717,0.14961,0.68504,0.14961,0.69291,0.14961,0.70079,0.14961,0.70866,0.14961,0.71654,0.14961,0.72441,0.14961,0.73228,0.14961,0.74016,0.14961,0.74803,0.14961,0.75591,0.14961,0.76378,0.14961,0.77165,0.14961,0.77953,0.14961,0.7874,0.14961,0.79528,0.14961,0.80315,0.14961,0.81102,0.14961,0.8189,0.14961,0.82677,0.14961,0.83465,0.14961,0.84252,0.14961,0.85039,0.14961,0.85827,0.14961,0.86614,0.14961,0.87402,0.14961,0.88189,0.14961,0.88976,0.14961,0.89764,0.14961,0.90551,0.14961,0.91339,0.14961,0.92126,0.14961,0.92913,0.14961,0.93701,0.14961,0.94488,0.14961,0.95276,0.14961,0.96063,0.14961,0.9685,0.14961,0.97638,0.14961,0.98425,0.14961,0.99213,0.14961,0.99609,0.14961,0.00391,0.15748,0.00787,0.15748,0.01575,0.15748,0.02362,0.15748,0.0315,0.15748,0.03937,0.15748,0.04724,0.15748,0.05512,0.15748,0.06299,0.15748,0.07087,0.15748,0.07874,0.15748,0.08661,0.15748,0.09449,0.15748,0.10236,0.15748,0.11024,0.15748,0.11811,0.15748,0.12598,0.15748,0.13386,0.15748,0.14173,0.15748,0.14961,0.15748,0.15748,0.15748,0.16535,0.15748,0.17323,0.15748,0.1811,0.15748,0.18898,0.15748,0.19685,0.15748,0.20472,0.15748,0.2126,0.15748,0.22047,0.15748,0.22835,0.15748,0.23622,0.15748,0.24409,0.15748,0.25197,0.15748,0.25984,0.15748,0.26772,0.15748,0.27559,0.15748,0.28346,0.15748,0.29134,0.15748,0.29921,0.15748,0.30709,0.15748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.31496,0.15748,0.32283,0.15748,0.33071,0.15748,0.33858,0.15748,0.34646,0.15748,0.35433,0.15748,0.3622,0.15748,0.37008,0.15748,0.37795,0.15748,0.38583,0.15748,0.3937,0.15748,0.40157,0.15748,0.40945,0.15748,0.41732,0.15748,0.4252,0.15748,0.43307,0.15748,0.44094,0.15748,0.44882,0.15748,0.45669,0.15748,0.46457,0.15748,0.47244,0.15748,0.48031,0.15748,0.48819,0.15748,0.49606,0.15748,0.50394,0.15748,0.51181,0.15748,0.51969,0.15748,0.52756,0.15748,0.53543,0.15748,0.54331,0.15748,0.55118,0.15748,0.55906,0.15748,0.56693,0.15748,0.5748,0.15748,0.58268,0.15748,0.59055,0.15748,0.59843,0.15748,0.6063,0.15748,0.61417,0.15748,0.62205,0.15748,0.62992,0.15748,0.6378,0.15748,0.64567,0.15748,0.65354,0.15748,0.66142,0.15748,0.66929,0.15748,0.67717,0.15748,0.68504,0.15748,0.69291,0.15748,0.70079,0.15748,0.70866,0.15748,0.71654,0.15748,0.72441,0.15748,0.73228,0.15748,0.74016,0.15748,0.74803,0.15748,0.75591,0.15748,0.76378,0.15748,0.77165,0.15748,0.77953,0.15748,0.7874,0.15748,0.79528,0.15748,0.80315,0.15748,0.81102,0.15748,0.8189,0.15748,0.82677,0.15748,0.83465,0.15748,0.84252,0.15748,0.85039,0.15748,0.85827,0.15748,0.86614,0.15748,0.87402,0.15748,0.88189,0.15748,0.88976,0.15748,0.89764,0.15748,0.90551,0.15748,0.91339,0.15748,0.92126,0.15748,0.92913,0.15748,0.93701,0.15748,0.94488,0.15748,0.95276,0.15748,0.96063,0.15748,0.9685,0.15748,0.97638,0.15748,0.98425,0.15748,0.99213,0.15748,0.99609,0.15748,0.00391,0.16535,0.00787,0.16535,0.01575,0.16535,0.02362,0.16535,0.0315,0.16535,0.03937,0.16535,0.04724,0.16535,0.05512,0.16535,0.06299,0.16535,0.07087,0.16535,0.07874,0.16535,0.08661,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.09449,0.16535,0.10236,0.16535,0.11024,0.16535,0.11811,0.16535,0.12598,0.16535,0.13386,0.16535,0.14173,0.16535,0.14961,0.16535,0.15748,0.16535,0.16535,0.16535,0.17323,0.16535,0.1811,0.16535,0.18898,0.16535,0.19685,0.16535,0.20472,0.16535,0.2126,0.16535,0.22047,0.16535,0.22835,0.16535,0.23622,0.16535,0.24409,0.16535,0.25197,0.16535,0.25984,0.16535,0.26772,0.16535,0.27559,0.16535,0.28346,0.16535,0.29134,0.16535,0.29921,0.16535,0.30709,0.16535,0.31496,0.16535,0.32283,0.16535,0.33071,0.16535,0.33858,0.16535,0.34646,0.16535,0.35433,0.16535,0.3622,0.16535,0.37008,0.16535,0.37795,0.16535,0.38583,0.16535,0.3937,0.16535,0.40157,0.16535,0.40945,0.16535,0.41732,0.16535,0.4252,0.16535,0.43307,0.16535,0.44094,0.16535,0.44882,0.16535,0.45669,0.16535,0.46457,0.16535,0.47244,0.16535,0.48031,0.16535,0.48819,0.16535,0.49606,0.16535,0.50394,0.16535,0.51181,0.16535,0.51969,0.16535,0.52756,0.16535,0.53543,0.16535,0.54331,0.16535,0.55118,0.16535,0.55906,0.16535,0.56693,0.16535,0.5748,0.16535,0.58268,0.16535,0.59055,0.16535,0.59843,0.16535,0.6063,0.16535,0.61417,0.16535,0.62205,0.16535,0.62992,0.16535,0.6378,0.16535,0.64567,0.16535,0.65354,0.16535,0.66142,0.16535,0.66929,0.16535,0.67717,0.16535,0.68504,0.16535,0.69291,0.16535,0.70079,0.16535,0.70866,0.16535,0.71654,0.16535,0.72441,0.16535,0.73228,0.16535,0.74016,0.16535,0.74803,0.16535,0.75591,0.16535,0.76378,0.16535,0.77165,0.16535,0.77953,0.16535,0.7874,0.16535,0.79528,0.16535,0.80315,0.16535,0.81102,0.16535,0.8189,0.16535,0.82677,0.16535,0.83465,0.16535,0.84252,0.16535,0.85039,0.16535,0.85827,0.16535,0.86614,0.16535,0.87402,0.16535};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.88189,0.16535,0.88976,0.16535,0.89764,0.16535,0.90551,0.16535,0.91339,0.16535,0.92126,0.16535,0.92913,0.16535,0.93701,0.16535,0.94488,0.16535,0.95276,0.16535,0.96063,0.16535,0.9685,0.16535,0.97638,0.16535,0.98425,0.16535,0.99213,0.16535,0.99609,0.16535,0.00391,0.17323,0.00787,0.17323,0.01575,0.17323,0.02362,0.17323,0.0315,0.17323,0.03937,0.17323,0.04724,0.17323,0.05512,0.17323,0.06299,0.17323,0.07087,0.17323,0.07874,0.17323,0.08661,0.17323,0.09449,0.17323,0.10236,0.17323,0.11024,0.17323,0.11811,0.17323,0.12598,0.17323,0.13386,0.17323,0.14173,0.17323,0.14961,0.17323,0.15748,0.17323,0.16535,0.17323,0.17323,0.17323,0.1811,0.17323,0.18898,0.17323,0.19685,0.17323,0.20472,0.17323,0.2126,0.17323,0.22047,0.17323,0.22835,0.17323,0.23622,0.17323,0.24409,0.17323,0.25197,0.17323,0.25984,0.17323,0.26772,0.17323,0.27559,0.17323,0.28346,0.17323,0.29134,0.17323,0.29921,0.17323,0.30709,0.17323,0.31496,0.17323,0.32283,0.17323,0.33071,0.17323,0.33858,0.17323,0.34646,0.17323,0.35433,0.17323,0.3622,0.17323,0.37008,0.17323,0.37795,0.17323,0.38583,0.17323,0.3937,0.17323,0.40157,0.17323,0.40945,0.17323,0.41732,0.17323,0.4252,0.17323,0.43307,0.17323,0.44094,0.17323,0.44882,0.17323,0.45669,0.17323,0.46457,0.17323,0.47244,0.17323,0.48031,0.17323,0.48819,0.17323,0.49606,0.17323,0.50394,0.17323,0.51181,0.17323,0.51969,0.17323,0.52756,0.17323,0.53543,0.17323,0.54331,0.17323,0.55118,0.17323,0.55906,0.17323,0.56693,0.17323,0.5748,0.17323,0.58268,0.17323,0.59055,0.17323,0.59843,0.17323,0.6063,0.17323,0.61417,0.17323,0.62205,0.17323,0.62992,0.17323,0.6378,0.17323,0.64567,0.17323,0.65354,0.17323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.66142,0.17323,0.66929,0.17323,0.67717,0.17323,0.68504,0.17323,0.69291,0.17323,0.70079,0.17323,0.70866,0.17323,0.71654,0.17323,0.72441,0.17323,0.73228,0.17323,0.74016,0.17323,0.74803,0.17323,0.75591,0.17323,0.76378,0.17323,0.77165,0.17323,0.77953,0.17323,0.7874,0.17323,0.79528,0.17323,0.80315,0.17323,0.81102,0.17323,0.8189,0.17323,0.82677,0.17323,0.83465,0.17323,0.84252,0.17323,0.85039,0.17323,0.85827,0.17323,0.86614,0.17323,0.87402,0.17323,0.88189,0.17323,0.88976,0.17323,0.89764,0.17323,0.90551,0.17323,0.91339,0.17323,0.92126,0.17323,0.92913,0.17323,0.93701,0.17323,0.94488,0.17323,0.95276,0.17323,0.96063,0.17323,0.9685,0.17323,0.97638,0.17323,0.98425,0.17323,0.99213,0.17323,0.99609,0.17323,0.00391,0.1811,0.00787,0.1811,0.01575,0.1811,0.02362,0.1811,0.0315,0.1811,0.03937,0.1811,0.04724,0.1811,0.05512,0.1811,0.06299,0.1811,0.07087,0.1811,0.07874,0.1811,0.08661,0.1811,0.09449,0.1811,0.10236,0.1811,0.11024,0.1811,0.11811,0.1811,0.12598,0.1811,0.13386,0.1811,0.14173,0.1811,0.14961,0.1811,0.15748,0.1811,0.16535,0.1811,0.17323,0.1811,0.1811,0.1811,0.18898,0.1811,0.19685,0.1811,0.20472,0.1811,0.2126,0.1811,0.22047,0.1811,0.22835,0.1811,0.23622,0.1811,0.24409,0.1811,0.25197,0.1811,0.25984,0.1811,0.26772,0.1811,0.27559,0.1811,0.28346,0.1811,0.29134,0.1811,0.29921,0.1811,0.30709,0.1811,0.31496,0.1811,0.32283,0.1811,0.33071,0.1811,0.33858,0.1811,0.34646,0.1811,0.35433,0.1811,0.3622,0.1811,0.37008,0.1811,0.37795,0.1811,0.38583,0.1811,0.3937,0.1811,0.40157,0.1811,0.40945,0.1811,0.41732,0.1811,0.4252,0.1811,0.43307,0.1811};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.44094,0.1811,0.44882,0.1811,0.45669,0.1811,0.46457,0.1811,0.47244,0.1811,0.48031,0.1811,0.48819,0.1811,0.49606,0.1811,0.50394,0.1811,0.51181,0.1811,0.51969,0.1811,0.52756,0.1811,0.53543,0.1811,0.54331,0.1811,0.55118,0.1811,0.55906,0.1811,0.56693,0.1811,0.5748,0.1811,0.58268,0.1811,0.59055,0.1811,0.59843,0.1811,0.6063,0.1811,0.61417,0.1811,0.62205,0.1811,0.62992,0.1811,0.6378,0.1811,0.64567,0.1811,0.65354,0.1811,0.66142,0.1811,0.66929,0.1811,0.67717,0.1811,0.68504,0.1811,0.69291,0.1811,0.70079,0.1811,0.70866,0.1811,0.71654,0.1811,0.72441,0.1811,0.73228,0.1811,0.74016,0.1811,0.74803,0.1811,0.75591,0.1811,0.76378,0.1811,0.77165,0.1811,0.77953,0.1811,0.7874,0.1811,0.79528,0.1811,0.80315,0.1811,0.81102,0.1811,0.8189,0.1811,0.82677,0.1811,0.83465,0.1811,0.84252,0.1811,0.85039,0.1811,0.85827,0.1811,0.86614,0.1811,0.87402,0.1811,0.88189,0.1811,0.88976,0.1811,0.89764,0.1811,0.90551,0.1811,0.91339,0.1811,0.92126,0.1811,0.92913,0.1811,0.93701,0.1811,0.94488,0.1811,0.95276,0.1811,0.96063,0.1811,0.9685,0.1811,0.97638,0.1811,0.98425,0.1811,0.99213,0.1811,0.99609,0.1811,0.00391,0.18898,0.00787,0.18898,0.01575,0.18898,0.02362,0.18898,0.0315,0.18898,0.03937,0.18898,0.04724,0.18898,0.05512,0.18898,0.06299,0.18898,0.07087,0.18898,0.07874,0.18898,0.08661,0.18898,0.09449,0.18898,0.10236,0.18898,0.11024,0.18898,0.11811,0.18898,0.12598,0.18898,0.13386,0.18898,0.14173,0.18898,0.14961,0.18898,0.15748,0.18898,0.16535,0.18898,0.17323,0.18898,0.1811,0.18898,0.18898,0.18898,0.19685,0.18898,0.20472,0.18898,0.2126,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.22047,0.18898,0.22835,0.18898,0.23622,0.18898,0.24409,0.18898,0.25197,0.18898,0.25984,0.18898,0.26772,0.18898,0.27559,0.18898,0.28346,0.18898,0.29134,0.18898,0.29921,0.18898,0.30709,0.18898,0.31496,0.18898,0.32283,0.18898,0.33071,0.18898,0.33858,0.18898,0.34646,0.18898,0.35433,0.18898,0.3622,0.18898,0.37008,0.18898,0.37795,0.18898,0.38583,0.18898,0.3937,0.18898,0.40157,0.18898,0.40945,0.18898,0.41732,0.18898,0.4252,0.18898,0.43307,0.18898,0.44094,0.18898,0.44882,0.18898,0.45669,0.18898,0.46457,0.18898,0.47244,0.18898,0.48031,0.18898,0.48819,0.18898,0.49606,0.18898,0.50394,0.18898,0.51181,0.18898,0.51969,0.18898,0.52756,0.18898,0.53543,0.18898,0.54331,0.18898,0.55118,0.18898,0.55906,0.18898,0.56693,0.18898,0.5748,0.18898,0.58268,0.18898,0.59055,0.18898,0.59843,0.18898,0.6063,0.18898,0.61417,0.18898,0.62205,0.18898,0.62992,0.18898,0.6378,0.18898,0.64567,0.18898,0.65354,0.18898,0.66142,0.18898,0.66929,0.18898,0.67717,0.18898,0.68504,0.18898,0.69291,0.18898,0.70079,0.18898,0.70866,0.18898,0.71654,0.18898,0.72441,0.18898,0.73228,0.18898,0.74016,0.18898,0.74803,0.18898,0.75591,0.18898,0.76378,0.18898,0.77165,0.18898,0.77953,0.18898,0.7874,0.18898,0.79528,0.18898,0.80315,0.18898,0.81102,0.18898,0.8189,0.18898,0.82677,0.18898,0.83465,0.18898,0.84252,0.18898,0.85039,0.18898,0.85827,0.18898,0.86614,0.18898,0.87402,0.18898,0.88189,0.18898,0.88976,0.18898,0.89764,0.18898,0.90551,0.18898,0.91339,0.18898,0.92126,0.18898,0.92913,0.18898,0.93701,0.18898,0.94488,0.18898,0.95276,0.18898,0.96063,0.18898,0.9685,0.18898,0.97638,0.18898,0.98425,0.18898,0.99213,0.18898,0.99609,0.18898};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.19685,0.00787,0.19685,0.01575,0.19685,0.02362,0.19685,0.0315,0.19685,0.03937,0.19685,0.04724,0.19685,0.05512,0.19685,0.06299,0.19685,0.07087,0.19685,0.07874,0.19685,0.08661,0.19685,0.09449,0.19685,0.10236,0.19685,0.11024,0.19685,0.11811,0.19685,0.12598,0.19685,0.13386,0.19685,0.14173,0.19685,0.14961,0.19685,0.15748,0.19685,0.16535,0.19685,0.17323,0.19685,0.1811,0.19685,0.18898,0.19685,0.19685,0.19685,0.20472,0.19685,0.2126,0.19685,0.22047,0.19685,0.22835,0.19685,0.23622,0.19685,0.24409,0.19685,0.25197,0.19685,0.25984,0.19685,0.26772,0.19685,0.27559,0.19685,0.28346,0.19685,0.29134,0.19685,0.29921,0.19685,0.30709,0.19685,0.31496,0.19685,0.32283,0.19685,0.33071,0.19685,0.33858,0.19685,0.34646,0.19685,0.35433,0.19685,0.3622,0.19685,0.37008,0.19685,0.37795,0.19685,0.38583,0.19685,0.3937,0.19685,0.40157,0.19685,0.40945,0.19685,0.41732,0.19685,0.4252,0.19685,0.43307,0.19685,0.44094,0.19685,0.44882,0.19685,0.45669,0.19685,0.46457,0.19685,0.47244,0.19685,0.48031,0.19685,0.48819,0.19685,0.49606,0.19685,0.50394,0.19685,0.51181,0.19685,0.51969,0.19685,0.52756,0.19685,0.53543,0.19685,0.54331,0.19685,0.55118,0.19685,0.55906,0.19685,0.56693,0.19685,0.5748,0.19685,0.58268,0.19685,0.59055,0.19685,0.59843,0.19685,0.6063,0.19685,0.61417,0.19685,0.62205,0.19685,0.62992,0.19685,0.6378,0.19685,0.64567,0.19685,0.65354,0.19685,0.66142,0.19685,0.66929,0.19685,0.67717,0.19685,0.68504,0.19685,0.69291,0.19685,0.70079,0.19685,0.70866,0.19685,0.71654,0.19685,0.72441,0.19685,0.73228,0.19685,0.74016,0.19685,0.74803,0.19685,0.75591,0.19685,0.76378,0.19685,0.77165,0.19685,0.77953,0.19685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.7874,0.19685,0.79528,0.19685,0.80315,0.19685,0.81102,0.19685,0.8189,0.19685,0.82677,0.19685,0.83465,0.19685,0.84252,0.19685,0.85039,0.19685,0.85827,0.19685,0.86614,0.19685,0.87402,0.19685,0.88189,0.19685,0.88976,0.19685,0.89764,0.19685,0.90551,0.19685,0.91339,0.19685,0.92126,0.19685,0.92913,0.19685,0.93701,0.19685,0.94488,0.19685,0.95276,0.19685,0.96063,0.19685,0.9685,0.19685,0.97638,0.19685,0.98425,0.19685,0.99213,0.19685,0.99609,0.19685,0.00391,0.20472,0.00787,0.20472,0.01575,0.20472,0.02362,0.20472,0.0315,0.20472,0.03937,0.20472,0.04724,0.20472,0.05512,0.20472,0.06299,0.20472,0.07087,0.20472,0.07874,0.20472,0.08661,0.20472,0.09449,0.20472,0.10236,0.20472,0.11024,0.20472,0.11811,0.20472,0.12598,0.20472,0.13386,0.20472,0.14173,0.20472,0.14961,0.20472,0.15748,0.20472,0.16535,0.20472,0.17323,0.20472,0.1811,0.20472,0.18898,0.20472,0.19685,0.20472,0.20472,0.20472,0.2126,0.20472,0.22047,0.20472,0.22835,0.20472,0.23622,0.20472,0.24409,0.20472,0.25197,0.20472,0.25984,0.20472,0.26772,0.20472,0.27559,0.20472,0.28346,0.20472,0.29134,0.20472,0.29921,0.20472,0.30709,0.20472,0.31496,0.20472,0.32283,0.20472,0.33071,0.20472,0.33858,0.20472,0.34646,0.20472,0.35433,0.20472,0.3622,0.20472,0.37008,0.20472,0.37795,0.20472,0.38583,0.20472,0.3937,0.20472,0.40157,0.20472,0.40945,0.20472,0.41732,0.20472,0.4252,0.20472,0.43307,0.20472,0.44094,0.20472,0.44882,0.20472,0.45669,0.20472,0.46457,0.20472,0.47244,0.20472,0.48031,0.20472,0.48819,0.20472,0.49606,0.20472,0.50394,0.20472,0.51181,0.20472,0.51969,0.20472,0.52756,0.20472,0.53543,0.20472,0.54331,0.20472,0.55118,0.20472,0.55906,0.20472};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.56693,0.20472,0.5748,0.20472,0.58268,0.20472,0.59055,0.20472,0.59843,0.20472,0.6063,0.20472,0.61417,0.20472,0.62205,0.20472,0.62992,0.20472,0.6378,0.20472,0.64567,0.20472,0.65354,0.20472,0.66142,0.20472,0.66929,0.20472,0.67717,0.20472,0.68504,0.20472,0.69291,0.20472,0.70079,0.20472,0.70866,0.20472,0.71654,0.20472,0.72441,0.20472,0.73228,0.20472,0.74016,0.20472,0.74803,0.20472,0.75591,0.20472,0.76378,0.20472,0.77165,0.20472,0.77953,0.20472,0.7874,0.20472,0.79528,0.20472,0.80315,0.20472,0.81102,0.20472,0.8189,0.20472,0.82677,0.20472,0.83465,0.20472,0.84252,0.20472,0.85039,0.20472,0.85827,0.20472,0.86614,0.20472,0.87402,0.20472,0.88189,0.20472,0.88976,0.20472,0.89764,0.20472,0.90551,0.20472,0.91339,0.20472,0.92126,0.20472,0.92913,0.20472,0.93701,0.20472,0.94488,0.20472,0.95276,0.20472,0.96063,0.20472,0.9685,0.20472,0.97638,0.20472,0.98425,0.20472,0.99213,0.20472,0.99609,0.20472,0.00391,0.2126,0.00787,0.2126,0.01575,0.2126,0.02362,0.2126,0.0315,0.2126,0.03937,0.2126,0.04724,0.2126,0.05512,0.2126,0.06299,0.2126,0.07087,0.2126,0.07874,0.2126,0.08661,0.2126,0.09449,0.2126,0.10236,0.2126,0.11024,0.2126,0.11811,0.2126,0.12598,0.2126,0.13386,0.2126,0.14173,0.2126,0.14961,0.2126,0.15748,0.2126,0.16535,0.2126,0.17323,0.2126,0.1811,0.2126,0.18898,0.2126,0.19685,0.2126,0.20472,0.2126,0.2126,0.2126,0.22047,0.2126,0.22835,0.2126,0.23622,0.2126,0.24409,0.2126,0.25197,0.2126,0.25984,0.2126,0.26772,0.2126,0.27559,0.2126,0.28346,0.2126,0.29134,0.2126,0.29921,0.2126,0.30709,0.2126,0.31496,0.2126,0.32283,0.2126,0.33071,0.2126,0.33858,0.2126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.34646,0.2126,0.35433,0.2126,0.3622,0.2126,0.37008,0.2126,0.37795,0.2126,0.38583,0.2126,0.3937,0.2126,0.40157,0.2126,0.40945,0.2126,0.41732,0.2126,0.4252,0.2126,0.43307,0.2126,0.44094,0.2126,0.44882,0.2126,0.45669,0.2126,0.46457,0.2126,0.47244,0.2126,0.48031,0.2126,0.48819,0.2126,0.49606,0.2126,0.50394,0.2126,0.51181,0.2126,0.51969,0.2126,0.52756,0.2126,0.53543,0.2126,0.54331,0.2126,0.55118,0.2126,0.55906,0.2126,0.56693,0.2126,0.5748,0.2126,0.58268,0.2126,0.59055,0.2126,0.59843,0.2126,0.6063,0.2126,0.61417,0.2126,0.62205,0.2126,0.62992,0.2126,0.6378,0.2126,0.64567,0.2126,0.65354,0.2126,0.66142,0.2126,0.66929,0.2126,0.67717,0.2126,0.68504,0.2126,0.69291,0.2126,0.70079,0.2126,0.70866,0.2126,0.71654,0.2126,0.72441,0.2126,0.73228,0.2126,0.74016,0.2126,0.74803,0.2126,0.75591,0.2126,0.76378,0.2126,0.77165,0.2126,0.77953,0.2126,0.7874,0.2126,0.79528,0.2126,0.80315,0.2126,0.81102,0.2126,0.8189,0.2126,0.82677,0.2126,0.83465,0.2126,0.84252,0.2126,0.85039,0.2126,0.85827,0.2126,0.86614,0.2126,0.87402,0.2126,0.88189,0.2126,0.88976,0.2126,0.89764,0.2126,0.90551,0.2126,0.91339,0.2126,0.92126,0.2126,0.92913,0.2126,0.93701,0.2126,0.94488,0.2126,0.95276,0.2126,0.96063,0.2126,0.9685,0.2126,0.97638,0.2126,0.98425,0.2126,0.99213,0.2126,0.99609,0.2126,0.00391,0.22047,0.00787,0.22047,0.01575,0.22047,0.02362,0.22047,0.0315,0.22047,0.03937,0.22047,0.04724,0.22047,0.05512,0.22047,0.06299,0.22047,0.07087,0.22047,0.07874,0.22047,0.08661,0.22047,0.09449,0.22047,0.10236,0.22047,0.11024,0.22047,0.11811,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.12598,0.22047,0.13386,0.22047,0.14173,0.22047,0.14961,0.22047,0.15748,0.22047,0.16535,0.22047,0.17323,0.22047,0.1811,0.22047,0.18898,0.22047,0.19685,0.22047,0.20472,0.22047,0.2126,0.22047,0.22047,0.22047,0.22835,0.22047,0.23622,0.22047,0.24409,0.22047,0.25197,0.22047,0.25984,0.22047,0.26772,0.22047,0.27559,0.22047,0.28346,0.22047,0.29134,0.22047,0.29921,0.22047,0.30709,0.22047,0.31496,0.22047,0.32283,0.22047,0.33071,0.22047,0.33858,0.22047,0.34646,0.22047,0.35433,0.22047,0.3622,0.22047,0.37008,0.22047,0.37795,0.22047,0.38583,0.22047,0.3937,0.22047,0.40157,0.22047,0.40945,0.22047,0.41732,0.22047,0.4252,0.22047,0.43307,0.22047,0.44094,0.22047,0.44882,0.22047,0.45669,0.22047,0.46457,0.22047,0.47244,0.22047,0.48031,0.22047,0.48819,0.22047,0.49606,0.22047,0.50394,0.22047,0.51181,0.22047,0.51969,0.22047,0.52756,0.22047,0.53543,0.22047,0.54331,0.22047,0.55118,0.22047,0.55906,0.22047,0.56693,0.22047,0.5748,0.22047,0.58268,0.22047,0.59055,0.22047,0.59843,0.22047,0.6063,0.22047,0.61417,0.22047,0.62205,0.22047,0.62992,0.22047,0.6378,0.22047,0.64567,0.22047,0.65354,0.22047,0.66142,0.22047,0.66929,0.22047,0.67717,0.22047,0.68504,0.22047,0.69291,0.22047,0.70079,0.22047,0.70866,0.22047,0.71654,0.22047,0.72441,0.22047,0.73228,0.22047,0.74016,0.22047,0.74803,0.22047,0.75591,0.22047,0.76378,0.22047,0.77165,0.22047,0.77953,0.22047,0.7874,0.22047,0.79528,0.22047,0.80315,0.22047,0.81102,0.22047,0.8189,0.22047,0.82677,0.22047,0.83465,0.22047,0.84252,0.22047,0.85039,0.22047,0.85827,0.22047,0.86614,0.22047,0.87402,0.22047,0.88189,0.22047,0.88976,0.22047,0.89764,0.22047,0.90551,0.22047};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.91339,0.22047,0.92126,0.22047,0.92913,0.22047,0.93701,0.22047,0.94488,0.22047,0.95276,0.22047,0.96063,0.22047,0.9685,0.22047,0.97638,0.22047,0.98425,0.22047,0.99213,0.22047,0.99609,0.22047,0.00391,0.22835,0.00787,0.22835,0.01575,0.22835,0.02362,0.22835,0.0315,0.22835,0.03937,0.22835,0.04724,0.22835,0.05512,0.22835,0.06299,0.22835,0.07087,0.22835,0.07874,0.22835,0.08661,0.22835,0.09449,0.22835,0.10236,0.22835,0.11024,0.22835,0.11811,0.22835,0.12598,0.22835,0.13386,0.22835,0.14173,0.22835,0.14961,0.22835,0.15748,0.22835,0.16535,0.22835,0.17323,0.22835,0.1811,0.22835,0.18898,0.22835,0.19685,0.22835,0.20472,0.22835,0.2126,0.22835,0.22047,0.22835,0.22835,0.22835,0.23622,0.22835,0.24409,0.22835,0.25197,0.22835,0.25984,0.22835,0.26772,0.22835,0.27559,0.22835,0.28346,0.22835,0.29134,0.22835,0.29921,0.22835,0.30709,0.22835,0.31496,0.22835,0.32283,0.22835,0.33071,0.22835,0.33858,0.22835,0.34646,0.22835,0.35433,0.22835,0.3622,0.22835,0.37008,0.22835,0.37795,0.22835,0.38583,0.22835,0.3937,0.22835,0.40157,0.22835,0.40945,0.22835,0.41732,0.22835,0.4252,0.22835,0.43307,0.22835,0.44094,0.22835,0.44882,0.22835,0.45669,0.22835,0.46457,0.22835,0.47244,0.22835,0.48031,0.22835,0.48819,0.22835,0.49606,0.22835,0.50394,0.22835,0.51181,0.22835,0.51969,0.22835,0.52756,0.22835,0.53543,0.22835,0.54331,0.22835,0.55118,0.22835,0.55906,0.22835,0.56693,0.22835,0.5748,0.22835,0.58268,0.22835,0.59055,0.22835,0.59843,0.22835,0.6063,0.22835,0.61417,0.22835,0.62205,0.22835,0.62992,0.22835,0.6378,0.22835,0.64567,0.22835,0.65354,0.22835,0.66142,0.22835,0.66929,0.22835,0.67717,0.22835,0.68504,0.22835};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.69291,0.22835,0.70079,0.22835,0.70866,0.22835,0.71654,0.22835,0.72441,0.22835,0.73228,0.22835,0.74016,0.22835,0.74803,0.22835,0.75591,0.22835,0.76378,0.22835,0.77165,0.22835,0.77953,0.22835,0.7874,0.22835,0.79528,0.22835,0.80315,0.22835,0.81102,0.22835,0.8189,0.22835,0.82677,0.22835,0.83465,0.22835,0.84252,0.22835,0.85039,0.22835,0.85827,0.22835,0.86614,0.22835,0.87402,0.22835,0.88189,0.22835,0.88976,0.22835,0.89764,0.22835,0.90551,0.22835,0.91339,0.22835,0.92126,0.22835,0.92913,0.22835,0.93701,0.22835,0.94488,0.22835,0.95276,0.22835,0.96063,0.22835,0.9685,0.22835,0.97638,0.22835,0.98425,0.22835,0.99213,0.22835,0.99609,0.22835,0.00391,0.23622,0.00787,0.23622,0.01575,0.23622,0.02362,0.23622,0.0315,0.23622,0.03937,0.23622,0.04724,0.23622,0.05512,0.23622,0.06299,0.23622,0.07087,0.23622,0.07874,0.23622,0.08661,0.23622,0.09449,0.23622,0.10236,0.23622,0.11024,0.23622,0.11811,0.23622,0.12598,0.23622,0.13386,0.23622,0.14173,0.23622,0.14961,0.23622,0.15748,0.23622,0.16535,0.23622,0.17323,0.23622,0.1811,0.23622,0.18898,0.23622,0.19685,0.23622,0.20472,0.23622,0.2126,0.23622,0.22047,0.23622,0.22835,0.23622,0.23622,0.23622,0.24409,0.23622,0.25197,0.23622,0.25984,0.23622,0.26772,0.23622,0.27559,0.23622,0.28346,0.23622,0.29134,0.23622,0.29921,0.23622,0.30709,0.23622,0.31496,0.23622,0.32283,0.23622,0.33071,0.23622,0.33858,0.23622,0.34646,0.23622,0.35433,0.23622,0.3622,0.23622,0.37008,0.23622,0.37795,0.23622,0.38583,0.23622,0.3937,0.23622,0.40157,0.23622,0.40945,0.23622,0.41732,0.23622,0.4252,0.23622,0.43307,0.23622,0.44094,0.23622,0.44882,0.23622,0.45669,0.23622,0.46457,0.23622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.47244,0.23622,0.48031,0.23622,0.48819,0.23622,0.49606,0.23622,0.50394,0.23622,0.51181,0.23622,0.51969,0.23622,0.52756,0.23622,0.53543,0.23622,0.54331,0.23622,0.55118,0.23622,0.55906,0.23622,0.56693,0.23622,0.5748,0.23622,0.58268,0.23622,0.59055,0.23622,0.59843,0.23622,0.6063,0.23622,0.61417,0.23622,0.62205,0.23622,0.62992,0.23622,0.6378,0.23622,0.64567,0.23622,0.65354,0.23622,0.66142,0.23622,0.66929,0.23622,0.67717,0.23622,0.68504,0.23622,0.69291,0.23622,0.70079,0.23622,0.70866,0.23622,0.71654,0.23622,0.72441,0.23622,0.73228,0.23622,0.74016,0.23622,0.74803,0.23622,0.75591,0.23622,0.76378,0.23622,0.77165,0.23622,0.77953,0.23622,0.7874,0.23622,0.79528,0.23622,0.80315,0.23622,0.81102,0.23622,0.8189,0.23622,0.82677,0.23622,0.83465,0.23622,0.84252,0.23622,0.85039,0.23622,0.85827,0.23622,0.86614,0.23622,0.87402,0.23622,0.88189,0.23622,0.88976,0.23622,0.89764,0.23622,0.90551,0.23622,0.91339,0.23622,0.92126,0.23622,0.92913,0.23622,0.93701,0.23622,0.94488,0.23622,0.95276,0.23622,0.96063,0.23622,0.9685,0.23622,0.97638,0.23622,0.98425,0.23622,0.99213,0.23622,0.99609,0.23622,0.00391,0.24409,0.00787,0.24409,0.01575,0.24409,0.02362,0.24409,0.0315,0.24409,0.03937,0.24409,0.04724,0.24409,0.05512,0.24409,0.06299,0.24409,0.07087,0.24409,0.07874,0.24409,0.08661,0.24409,0.09449,0.24409,0.10236,0.24409,0.11024,0.24409,0.11811,0.24409,0.12598,0.24409,0.13386,0.24409,0.14173,0.24409,0.14961,0.24409,0.15748,0.24409,0.16535,0.24409,0.17323,0.24409,0.1811,0.24409,0.18898,0.24409,0.19685,0.24409,0.20472,0.24409,0.2126,0.24409,0.22047,0.24409,0.22835,0.24409,0.23622,0.24409,0.24409,0.24409};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.25197,0.24409,0.25984,0.24409,0.26772,0.24409,0.27559,0.24409,0.28346,0.24409,0.29134,0.24409,0.29921,0.24409,0.30709,0.24409,0.31496,0.24409,0.32283,0.24409,0.33071,0.24409,0.33858,0.24409,0.34646,0.24409,0.35433,0.24409,0.3622,0.24409,0.37008,0.24409,0.37795,0.24409,0.38583,0.24409,0.3937,0.24409,0.40157,0.24409,0.40945,0.24409,0.41732,0.24409,0.4252,0.24409,0.43307,0.24409,0.44094,0.24409,0.44882,0.24409,0.45669,0.24409,0.46457,0.24409,0.47244,0.24409,0.48031,0.24409,0.48819,0.24409,0.49606,0.24409,0.50394,0.24409,0.51181,0.24409,0.51969,0.24409,0.52756,0.24409,0.53543,0.24409,0.54331,0.24409,0.55118,0.24409,0.55906,0.24409,0.56693,0.24409,0.5748,0.24409,0.58268,0.24409,0.59055,0.24409,0.59843,0.24409,0.6063,0.24409,0.61417,0.24409,0.62205,0.24409,0.62992,0.24409,0.6378,0.24409,0.64567,0.24409,0.65354,0.24409,0.66142,0.24409,0.66929,0.24409,0.67717,0.24409,0.68504,0.24409,0.69291,0.24409,0.70079,0.24409,0.70866,0.24409,0.71654,0.24409,0.72441,0.24409,0.73228,0.24409,0.74016,0.24409,0.74803,0.24409,0.75591,0.24409,0.76378,0.24409,0.77165,0.24409,0.77953,0.24409,0.7874,0.24409,0.79528,0.24409,0.80315,0.24409,0.81102,0.24409,0.8189,0.24409,0.82677,0.24409,0.83465,0.24409,0.84252,0.24409,0.85039,0.24409,0.85827,0.24409,0.86614,0.24409,0.87402,0.24409,0.88189,0.24409,0.88976,0.24409,0.89764,0.24409,0.90551,0.24409,0.91339,0.24409,0.92126,0.24409,0.92913,0.24409,0.93701,0.24409,0.94488,0.24409,0.95276,0.24409,0.96063,0.24409,0.9685,0.24409,0.97638,0.24409,0.98425,0.24409,0.99213,0.24409,0.99609,0.24409,0.00391,0.25197,0.00787,0.25197,0.01575,0.25197,0.02362,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_42()
		{
			double[] value = {0.0315,0.25197,0.03937,0.25197,0.04724,0.25197,0.05512,0.25197,0.06299,0.25197,0.07087,0.25197,0.07874,0.25197,0.08661,0.25197,0.09449,0.25197,0.10236,0.25197,0.11024,0.25197,0.11811,0.25197,0.12598,0.25197,0.13386,0.25197,0.14173,0.25197,0.14961,0.25197,0.15748,0.25197,0.16535,0.25197,0.17323,0.25197,0.1811,0.25197,0.18898,0.25197,0.19685,0.25197,0.20472,0.25197,0.2126,0.25197,0.22047,0.25197,0.22835,0.25197,0.23622,0.25197,0.24409,0.25197,0.25197,0.25197,0.25984,0.25197,0.26772,0.25197,0.27559,0.25197,0.28346,0.25197,0.29134,0.25197,0.29921,0.25197,0.30709,0.25197,0.31496,0.25197,0.32283,0.25197,0.33071,0.25197,0.33858,0.25197,0.34646,0.25197,0.35433,0.25197,0.3622,0.25197,0.37008,0.25197,0.37795,0.25197,0.38583,0.25197,0.3937,0.25197,0.40157,0.25197,0.40945,0.25197,0.41732,0.25197,0.4252,0.25197,0.43307,0.25197,0.44094,0.25197,0.44882,0.25197,0.45669,0.25197,0.46457,0.25197,0.47244,0.25197,0.48031,0.25197,0.48819,0.25197,0.49606,0.25197,0.50394,0.25197,0.51181,0.25197,0.51969,0.25197,0.52756,0.25197,0.53543,0.25197,0.54331,0.25197,0.55118,0.25197,0.55906,0.25197,0.56693,0.25197,0.5748,0.25197,0.58268,0.25197,0.59055,0.25197,0.59843,0.25197,0.6063,0.25197,0.61417,0.25197,0.62205,0.25197,0.62992,0.25197,0.6378,0.25197,0.64567,0.25197,0.65354,0.25197,0.66142,0.25197,0.66929,0.25197,0.67717,0.25197,0.68504,0.25197,0.69291,0.25197,0.70079,0.25197,0.70866,0.25197,0.71654,0.25197,0.72441,0.25197,0.73228,0.25197,0.74016,0.25197,0.74803,0.25197,0.75591,0.25197,0.76378,0.25197,0.77165,0.25197,0.77953,0.25197,0.7874,0.25197,0.79528,0.25197,0.80315,0.25197,0.81102,0.25197};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_43()
		{
			double[] value = {0.8189,0.25197,0.82677,0.25197,0.83465,0.25197,0.84252,0.25197,0.85039,0.25197,0.85827,0.25197,0.86614,0.25197,0.87402,0.25197,0.88189,0.25197,0.88976,0.25197,0.89764,0.25197,0.90551,0.25197,0.91339,0.25197,0.92126,0.25197,0.92913,0.25197,0.93701,0.25197,0.94488,0.25197,0.95276,0.25197,0.96063,0.25197,0.9685,0.25197,0.97638,0.25197,0.98425,0.25197,0.99213,0.25197,0.99609,0.25197,0.00391,0.25984,0.00787,0.25984,0.01575,0.25984,0.02362,0.25984,0.0315,0.25984,0.03937,0.25984,0.04724,0.25984,0.05512,0.25984,0.06299,0.25984,0.07087,0.25984,0.07874,0.25984,0.08661,0.25984,0.09449,0.25984,0.10236,0.25984,0.11024,0.25984,0.11811,0.25984,0.12598,0.25984,0.13386,0.25984,0.14173,0.25984,0.14961,0.25984,0.15748,0.25984,0.16535,0.25984,0.17323,0.25984,0.1811,0.25984,0.18898,0.25984,0.19685,0.25984,0.20472,0.25984,0.2126,0.25984,0.22047,0.25984,0.22835,0.25984,0.23622,0.25984,0.24409,0.25984,0.25197,0.25984,0.25984,0.25984,0.26772,0.25984,0.27559,0.25984,0.28346,0.25984,0.29134,0.25984,0.29921,0.25984,0.30709,0.25984,0.31496,0.25984,0.32283,0.25984,0.33071,0.25984,0.33858,0.25984,0.34646,0.25984,0.35433,0.25984,0.3622,0.25984,0.37008,0.25984,0.37795,0.25984,0.38583,0.25984,0.3937,0.25984,0.40157,0.25984,0.40945,0.25984,0.41732,0.25984,0.4252,0.25984,0.43307,0.25984,0.44094,0.25984,0.44882,0.25984,0.45669,0.25984,0.46457,0.25984,0.47244,0.25984,0.48031,0.25984,0.48819,0.25984,0.49606,0.25984,0.50394,0.25984,0.51181,0.25984,0.51969,0.25984,0.52756,0.25984,0.53543,0.25984,0.54331,0.25984,0.55118,0.25984,0.55906,0.25984,0.56693,0.25984,0.5748,0.25984,0.58268,0.25984,0.59055,0.25984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_44()
		{
			double[] value = {0.59843,0.25984,0.6063,0.25984,0.61417,0.25984,0.62205,0.25984,0.62992,0.25984,0.6378,0.25984,0.64567,0.25984,0.65354,0.25984,0.66142,0.25984,0.66929,0.25984,0.67717,0.25984,0.68504,0.25984,0.69291,0.25984,0.70079,0.25984,0.70866,0.25984,0.71654,0.25984,0.72441,0.25984,0.73228,0.25984,0.74016,0.25984,0.74803,0.25984,0.75591,0.25984,0.76378,0.25984,0.77165,0.25984,0.77953,0.25984,0.7874,0.25984,0.79528,0.25984,0.80315,0.25984,0.81102,0.25984,0.8189,0.25984,0.82677,0.25984,0.83465,0.25984,0.84252,0.25984,0.85039,0.25984,0.85827,0.25984,0.86614,0.25984,0.87402,0.25984,0.88189,0.25984,0.88976,0.25984,0.89764,0.25984,0.90551,0.25984,0.91339,0.25984,0.92126,0.25984,0.92913,0.25984,0.93701,0.25984,0.94488,0.25984,0.95276,0.25984,0.96063,0.25984,0.9685,0.25984,0.97638,0.25984,0.98425,0.25984,0.99213,0.25984,0.99609,0.25984,0.00391,0.26772,0.00787,0.26772,0.01575,0.26772,0.02362,0.26772,0.0315,0.26772,0.03937,0.26772,0.04724,0.26772,0.05512,0.26772,0.06299,0.26772,0.07087,0.26772,0.07874,0.26772,0.08661,0.26772,0.09449,0.26772,0.10236,0.26772,0.11024,0.26772,0.11811,0.26772,0.12598,0.26772,0.13386,0.26772,0.14173,0.26772,0.14961,0.26772,0.15748,0.26772,0.16535,0.26772,0.17323,0.26772,0.1811,0.26772,0.18898,0.26772,0.19685,0.26772,0.20472,0.26772,0.2126,0.26772,0.22047,0.26772,0.22835,0.26772,0.23622,0.26772,0.24409,0.26772,0.25197,0.26772,0.25984,0.26772,0.26772,0.26772,0.27559,0.26772,0.28346,0.26772,0.29134,0.26772,0.29921,0.26772,0.30709,0.26772,0.31496,0.26772,0.32283,0.26772,0.33071,0.26772,0.33858,0.26772,0.34646,0.26772,0.35433,0.26772,0.3622,0.26772,0.37008,0.26772};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_45()
		{
			double[] value = {0.37795,0.26772,0.38583,0.26772,0.3937,0.26772,0.40157,0.26772,0.40945,0.26772,0.41732,0.26772,0.4252,0.26772,0.43307,0.26772,0.44094,0.26772,0.44882,0.26772,0.45669,0.26772,0.46457,0.26772,0.47244,0.26772,0.48031,0.26772,0.48819,0.26772,0.49606,0.26772,0.50394,0.26772,0.51181,0.26772,0.51969,0.26772,0.52756,0.26772,0.53543,0.26772,0.54331,0.26772,0.55118,0.26772,0.55906,0.26772,0.56693,0.26772,0.5748,0.26772,0.58268,0.26772,0.59055,0.26772,0.59843,0.26772,0.6063,0.26772,0.61417,0.26772,0.62205,0.26772,0.62992,0.26772,0.6378,0.26772,0.64567,0.26772,0.65354,0.26772,0.66142,0.26772,0.66929,0.26772,0.67717,0.26772,0.68504,0.26772,0.69291,0.26772,0.70079,0.26772,0.70866,0.26772,0.71654,0.26772,0.72441,0.26772,0.73228,0.26772,0.74016,0.26772,0.74803,0.26772,0.75591,0.26772,0.76378,0.26772,0.77165,0.26772,0.77953,0.26772,0.7874,0.26772,0.79528,0.26772,0.80315,0.26772,0.81102,0.26772,0.8189,0.26772,0.82677,0.26772,0.83465,0.26772,0.84252,0.26772,0.85039,0.26772,0.85827,0.26772,0.86614,0.26772,0.87402,0.26772,0.88189,0.26772,0.88976,0.26772,0.89764,0.26772,0.90551,0.26772,0.91339,0.26772,0.92126,0.26772,0.92913,0.26772,0.93701,0.26772,0.94488,0.26772,0.95276,0.26772,0.96063,0.26772,0.9685,0.26772,0.97638,0.26772,0.98425,0.26772,0.99213,0.26772,0.99609,0.26772,0.00391,0.27559,0.00787,0.27559,0.01575,0.27559,0.02362,0.27559,0.0315,0.27559,0.03937,0.27559,0.04724,0.27559,0.05512,0.27559,0.06299,0.27559,0.07087,0.27559,0.07874,0.27559,0.08661,0.27559,0.09449,0.27559,0.10236,0.27559,0.11024,0.27559,0.11811,0.27559,0.12598,0.27559,0.13386,0.27559,0.14173,0.27559,0.14961,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_46()
		{
			double[] value = {0.15748,0.27559,0.16535,0.27559,0.17323,0.27559,0.1811,0.27559,0.18898,0.27559,0.19685,0.27559,0.20472,0.27559,0.2126,0.27559,0.22047,0.27559,0.22835,0.27559,0.23622,0.27559,0.24409,0.27559,0.25197,0.27559,0.25984,0.27559,0.26772,0.27559,0.27559,0.27559,0.28346,0.27559,0.29134,0.27559,0.29921,0.27559,0.30709,0.27559,0.31496,0.27559,0.32283,0.27559,0.33071,0.27559,0.33858,0.27559,0.34646,0.27559,0.35433,0.27559,0.3622,0.27559,0.37008,0.27559,0.37795,0.27559,0.38583,0.27559,0.3937,0.27559,0.40157,0.27559,0.40945,0.27559,0.41732,0.27559,0.4252,0.27559,0.43307,0.27559,0.44094,0.27559,0.44882,0.27559,0.45669,0.27559,0.46457,0.27559,0.47244,0.27559,0.48031,0.27559,0.48819,0.27559,0.49606,0.27559,0.50394,0.27559,0.51181,0.27559,0.51969,0.27559,0.52756,0.27559,0.53543,0.27559,0.54331,0.27559,0.55118,0.27559,0.55906,0.27559,0.56693,0.27559,0.5748,0.27559,0.58268,0.27559,0.59055,0.27559,0.59843,0.27559,0.6063,0.27559,0.61417,0.27559,0.62205,0.27559,0.62992,0.27559,0.6378,0.27559,0.64567,0.27559,0.65354,0.27559,0.66142,0.27559,0.66929,0.27559,0.67717,0.27559,0.68504,0.27559,0.69291,0.27559,0.70079,0.27559,0.70866,0.27559,0.71654,0.27559,0.72441,0.27559,0.73228,0.27559,0.74016,0.27559,0.74803,0.27559,0.75591,0.27559,0.76378,0.27559,0.77165,0.27559,0.77953,0.27559,0.7874,0.27559,0.79528,0.27559,0.80315,0.27559,0.81102,0.27559,0.8189,0.27559,0.82677,0.27559,0.83465,0.27559,0.84252,0.27559,0.85039,0.27559,0.85827,0.27559,0.86614,0.27559,0.87402,0.27559,0.88189,0.27559,0.88976,0.27559,0.89764,0.27559,0.90551,0.27559,0.91339,0.27559,0.92126,0.27559,0.92913,0.27559,0.93701,0.27559};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_47()
		{
			double[] value = {0.94488,0.27559,0.95276,0.27559,0.96063,0.27559,0.9685,0.27559,0.97638,0.27559,0.98425,0.27559,0.99213,0.27559,0.99609,0.27559,0.00391,0.28346,0.00787,0.28346,0.01575,0.28346,0.02362,0.28346,0.0315,0.28346,0.03937,0.28346,0.04724,0.28346,0.05512,0.28346,0.06299,0.28346,0.07087,0.28346,0.07874,0.28346,0.08661,0.28346,0.09449,0.28346,0.10236,0.28346,0.11024,0.28346,0.11811,0.28346,0.12598,0.28346,0.13386,0.28346,0.14173,0.28346,0.14961,0.28346,0.15748,0.28346,0.16535,0.28346,0.17323,0.28346,0.1811,0.28346,0.18898,0.28346,0.19685,0.28346,0.20472,0.28346,0.2126,0.28346,0.22047,0.28346,0.22835,0.28346,0.23622,0.28346,0.24409,0.28346,0.25197,0.28346,0.25984,0.28346,0.26772,0.28346,0.27559,0.28346,0.28346,0.28346,0.29134,0.28346,0.29921,0.28346,0.30709,0.28346,0.31496,0.28346,0.32283,0.28346,0.33071,0.28346,0.33858,0.28346,0.34646,0.28346,0.35433,0.28346,0.3622,0.28346,0.37008,0.28346,0.37795,0.28346,0.38583,0.28346,0.3937,0.28346,0.40157,0.28346,0.40945,0.28346,0.41732,0.28346,0.4252,0.28346,0.43307,0.28346,0.44094,0.28346,0.44882,0.28346,0.45669,0.28346,0.46457,0.28346,0.47244,0.28346,0.48031,0.28346,0.48819,0.28346,0.49606,0.28346,0.50394,0.28346,0.51181,0.28346,0.51969,0.28346,0.52756,0.28346,0.53543,0.28346,0.54331,0.28346,0.55118,0.28346,0.55906,0.28346,0.56693,0.28346,0.5748,0.28346,0.58268,0.28346,0.59055,0.28346,0.59843,0.28346,0.6063,0.28346,0.61417,0.28346,0.62205,0.28346,0.62992,0.28346,0.6378,0.28346,0.64567,0.28346,0.65354,0.28346,0.66142,0.28346,0.66929,0.28346,0.67717,0.28346,0.68504,0.28346,0.69291,0.28346,0.70079,0.28346,0.70866,0.28346,0.71654,0.28346};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_48()
		{
			double[] value = {0.72441,0.28346,0.73228,0.28346,0.74016,0.28346,0.74803,0.28346,0.75591,0.28346,0.76378,0.28346,0.77165,0.28346,0.77953,0.28346,0.7874,0.28346,0.79528,0.28346,0.80315,0.28346,0.81102,0.28346,0.8189,0.28346,0.82677,0.28346,0.83465,0.28346,0.84252,0.28346,0.85039,0.28346,0.85827,0.28346,0.86614,0.28346,0.87402,0.28346,0.88189,0.28346,0.88976,0.28346,0.89764,0.28346,0.90551,0.28346,0.91339,0.28346,0.92126,0.28346,0.92913,0.28346,0.93701,0.28346,0.94488,0.28346,0.95276,0.28346,0.96063,0.28346,0.9685,0.28346,0.97638,0.28346,0.98425,0.28346,0.99213,0.28346,0.99609,0.28346,0.00391,0.29134,0.00787,0.29134,0.01575,0.29134,0.02362,0.29134,0.0315,0.29134,0.03937,0.29134,0.04724,0.29134,0.05512,0.29134,0.06299,0.29134,0.07087,0.29134,0.07874,0.29134,0.08661,0.29134,0.09449,0.29134,0.10236,0.29134,0.11024,0.29134,0.11811,0.29134,0.12598,0.29134,0.13386,0.29134,0.14173,0.29134,0.14961,0.29134,0.15748,0.29134,0.16535,0.29134,0.17323,0.29134,0.1811,0.29134,0.18898,0.29134,0.19685,0.29134,0.20472,0.29134,0.2126,0.29134,0.22047,0.29134,0.22835,0.29134,0.23622,0.29134,0.24409,0.29134,0.25197,0.29134,0.25984,0.29134,0.26772,0.29134,0.27559,0.29134,0.28346,0.29134,0.29134,0.29134,0.29921,0.29134,0.30709,0.29134,0.31496,0.29134,0.32283,0.29134,0.33071,0.29134,0.33858,0.29134,0.34646,0.29134,0.35433,0.29134,0.3622,0.29134,0.37008,0.29134,0.37795,0.29134,0.38583,0.29134,0.3937,0.29134,0.40157,0.29134,0.40945,0.29134,0.41732,0.29134,0.4252,0.29134,0.43307,0.29134,0.44094,0.29134,0.44882,0.29134,0.45669,0.29134,0.46457,0.29134,0.47244,0.29134,0.48031,0.29134,0.48819,0.29134,0.49606,0.29134};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_49()
		{
			double[] value = {0.50394,0.29134,0.51181,0.29134,0.51969,0.29134,0.52756,0.29134,0.53543,0.29134,0.54331,0.29134,0.55118,0.29134,0.55906,0.29134,0.56693,0.29134,0.5748,0.29134,0.58268,0.29134,0.59055,0.29134,0.59843,0.29134,0.6063,0.29134,0.61417,0.29134,0.62205,0.29134,0.62992,0.29134,0.6378,0.29134,0.64567,0.29134,0.65354,0.29134,0.66142,0.29134,0.66929,0.29134,0.67717,0.29134,0.68504,0.29134,0.69291,0.29134,0.70079,0.29134,0.70866,0.29134,0.71654,0.29134,0.72441,0.29134,0.73228,0.29134,0.74016,0.29134,0.74803,0.29134,0.75591,0.29134,0.76378,0.29134,0.77165,0.29134,0.77953,0.29134,0.7874,0.29134,0.79528,0.29134,0.80315,0.29134,0.81102,0.29134,0.8189,0.29134,0.82677,0.29134,0.83465,0.29134,0.84252,0.29134,0.85039,0.29134,0.85827,0.29134,0.86614,0.29134,0.87402,0.29134,0.88189,0.29134,0.88976,0.29134,0.89764,0.29134,0.90551,0.29134,0.91339,0.29134,0.92126,0.29134,0.92913,0.29134,0.93701,0.29134,0.94488,0.29134,0.95276,0.29134,0.96063,0.29134,0.9685,0.29134,0.97638,0.29134,0.98425,0.29134,0.99213,0.29134,0.99609,0.29134,0.00391,0.29921,0.00787,0.29921,0.01575,0.29921,0.02362,0.29921,0.0315,0.29921,0.03937,0.29921,0.04724,0.29921,0.05512,0.29921,0.06299,0.29921,0.07087,0.29921,0.07874,0.29921,0.08661,0.29921,0.09449,0.29921,0.10236,0.29921,0.11024,0.29921,0.11811,0.29921,0.12598,0.29921,0.13386,0.29921,0.14173,0.29921,0.14961,0.29921,0.15748,0.29921,0.16535,0.29921,0.17323,0.29921,0.1811,0.29921,0.18898,0.29921,0.19685,0.29921,0.20472,0.29921,0.2126,0.29921,0.22047,0.29921,0.22835,0.29921,0.23622,0.29921,0.24409,0.29921,0.25197,0.29921,0.25984,0.29921,0.26772,0.29921,0.27559,0.29921};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_50()
		{
			double[] value = {0.28346,0.29921,0.29134,0.29921,0.29921,0.29921,0.30709,0.29921,0.31496,0.29921,0.32283,0.29921,0.33071,0.29921,0.33858,0.29921,0.34646,0.29921,0.35433,0.29921,0.3622,0.29921,0.37008,0.29921,0.37795,0.29921,0.38583,0.29921,0.3937,0.29921,0.40157,0.29921,0.40945,0.29921,0.41732,0.29921,0.4252,0.29921,0.43307,0.29921,0.44094,0.29921,0.44882,0.29921,0.45669,0.29921,0.46457,0.29921,0.47244,0.29921,0.48031,0.29921,0.48819,0.29921,0.49606,0.29921,0.50394,0.29921,0.51181,0.29921,0.51969,0.29921,0.52756,0.29921,0.53543,0.29921,0.54331,0.29921,0.55118,0.29921,0.55906,0.29921,0.56693,0.29921,0.5748,0.29921,0.58268,0.29921,0.59055,0.29921,0.59843,0.29921,0.6063,0.29921,0.61417,0.29921,0.62205,0.29921,0.62992,0.29921,0.6378,0.29921,0.64567,0.29921,0.65354,0.29921,0.66142,0.29921,0.66929,0.29921,0.67717,0.29921,0.68504,0.29921,0.69291,0.29921,0.70079,0.29921,0.70866,0.29921,0.71654,0.29921,0.72441,0.29921,0.73228,0.29921,0.74016,0.29921,0.74803,0.29921,0.75591,0.29921,0.76378,0.29921,0.77165,0.29921,0.77953,0.29921,0.7874,0.29921,0.79528,0.29921,0.80315,0.29921,0.81102,0.29921,0.8189,0.29921,0.82677,0.29921,0.83465,0.29921,0.84252,0.29921,0.85039,0.29921,0.85827,0.29921,0.86614,0.29921,0.87402,0.29921,0.88189,0.29921,0.88976,0.29921,0.89764,0.29921,0.90551,0.29921,0.91339,0.29921,0.92126,0.29921,0.92913,0.29921,0.93701,0.29921,0.94488,0.29921,0.95276,0.29921,0.96063,0.29921,0.9685,0.29921,0.97638,0.29921,0.98425,0.29921,0.99213,0.29921,0.99609,0.29921,0.00391,0.30709,0.00787,0.30709,0.01575,0.30709,0.02362,0.30709,0.0315,0.30709,0.03937,0.30709,0.04724,0.30709,0.05512,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_51()
		{
			double[] value = {0.06299,0.30709,0.07087,0.30709,0.07874,0.30709,0.08661,0.30709,0.09449,0.30709,0.10236,0.30709,0.11024,0.30709,0.11811,0.30709,0.12598,0.30709,0.13386,0.30709,0.14173,0.30709,0.14961,0.30709,0.15748,0.30709,0.16535,0.30709,0.17323,0.30709,0.1811,0.30709,0.18898,0.30709,0.19685,0.30709,0.20472,0.30709,0.2126,0.30709,0.22047,0.30709,0.22835,0.30709,0.23622,0.30709,0.24409,0.30709,0.25197,0.30709,0.25984,0.30709,0.26772,0.30709,0.27559,0.30709,0.28346,0.30709,0.29134,0.30709,0.29921,0.30709,0.30709,0.30709,0.31496,0.30709,0.32283,0.30709,0.33071,0.30709,0.33858,0.30709,0.34646,0.30709,0.35433,0.30709,0.3622,0.30709,0.37008,0.30709,0.37795,0.30709,0.38583,0.30709,0.3937,0.30709,0.40157,0.30709,0.40945,0.30709,0.41732,0.30709,0.4252,0.30709,0.43307,0.30709,0.44094,0.30709,0.44882,0.30709,0.45669,0.30709,0.46457,0.30709,0.47244,0.30709,0.48031,0.30709,0.48819,0.30709,0.49606,0.30709,0.50394,0.30709,0.51181,0.30709,0.51969,0.30709,0.52756,0.30709,0.53543,0.30709,0.54331,0.30709,0.55118,0.30709,0.55906,0.30709,0.56693,0.30709,0.5748,0.30709,0.58268,0.30709,0.59055,0.30709,0.59843,0.30709,0.6063,0.30709,0.61417,0.30709,0.62205,0.30709,0.62992,0.30709,0.6378,0.30709,0.64567,0.30709,0.65354,0.30709,0.66142,0.30709,0.66929,0.30709,0.67717,0.30709,0.68504,0.30709,0.69291,0.30709,0.70079,0.30709,0.70866,0.30709,0.71654,0.30709,0.72441,0.30709,0.73228,0.30709,0.74016,0.30709,0.74803,0.30709,0.75591,0.30709,0.76378,0.30709,0.77165,0.30709,0.77953,0.30709,0.7874,0.30709,0.79528,0.30709,0.80315,0.30709,0.81102,0.30709,0.8189,0.30709,0.82677,0.30709,0.83465,0.30709,0.84252,0.30709};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_52()
		{
			double[] value = {0.85039,0.30709,0.85827,0.30709,0.86614,0.30709,0.87402,0.30709,0.88189,0.30709,0.88976,0.30709,0.89764,0.30709,0.90551,0.30709,0.91339,0.30709,0.92126,0.30709,0.92913,0.30709,0.93701,0.30709,0.94488,0.30709,0.95276,0.30709,0.96063,0.30709,0.9685,0.30709,0.97638,0.30709,0.98425,0.30709,0.99213,0.30709,0.99609,0.30709,0.00391,0.31496,0.00787,0.31496,0.01575,0.31496,0.02362,0.31496,0.0315,0.31496,0.03937,0.31496,0.04724,0.31496,0.05512,0.31496,0.06299,0.31496,0.07087,0.31496,0.07874,0.31496,0.08661,0.31496,0.09449,0.31496,0.10236,0.31496,0.11024,0.31496,0.11811,0.31496,0.12598,0.31496,0.13386,0.31496,0.14173,0.31496,0.14961,0.31496,0.15748,0.31496,0.16535,0.31496,0.17323,0.31496,0.1811,0.31496,0.18898,0.31496,0.19685,0.31496,0.20472,0.31496,0.2126,0.31496,0.22047,0.31496,0.22835,0.31496,0.23622,0.31496,0.24409,0.31496,0.25197,0.31496,0.25984,0.31496,0.26772,0.31496,0.27559,0.31496,0.28346,0.31496,0.29134,0.31496,0.29921,0.31496,0.30709,0.31496,0.31496,0.31496,0.32283,0.31496,0.33071,0.31496,0.33858,0.31496,0.34646,0.31496,0.35433,0.31496,0.3622,0.31496,0.37008,0.31496,0.37795,0.31496,0.38583,0.31496,0.3937,0.31496,0.40157,0.31496,0.40945,0.31496,0.41732,0.31496,0.4252,0.31496,0.43307,0.31496,0.44094,0.31496,0.44882,0.31496,0.45669,0.31496,0.46457,0.31496,0.47244,0.31496,0.48031,0.31496,0.48819,0.31496,0.49606,0.31496,0.50394,0.31496,0.51181,0.31496,0.51969,0.31496,0.52756,0.31496,0.53543,0.31496,0.54331,0.31496,0.55118,0.31496,0.55906,0.31496,0.56693,0.31496,0.5748,0.31496,0.58268,0.31496,0.59055,0.31496,0.59843,0.31496,0.6063,0.31496,0.61417,0.31496,0.62205,0.31496};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_53()
		{
			double[] value = {0.62992,0.31496,0.6378,0.31496,0.64567,0.31496,0.65354,0.31496,0.66142,0.31496,0.66929,0.31496,0.67717,0.31496,0.68504,0.31496,0.69291,0.31496,0.70079,0.31496,0.70866,0.31496,0.71654,0.31496,0.72441,0.31496,0.73228,0.31496,0.74016,0.31496,0.74803,0.31496,0.75591,0.31496,0.76378,0.31496,0.77165,0.31496,0.77953,0.31496,0.7874,0.31496,0.79528,0.31496,0.80315,0.31496,0.81102,0.31496,0.8189,0.31496,0.82677,0.31496,0.83465,0.31496,0.84252,0.31496,0.85039,0.31496,0.85827,0.31496,0.86614,0.31496,0.87402,0.31496,0.88189,0.31496,0.88976,0.31496,0.89764,0.31496,0.90551,0.31496,0.91339,0.31496,0.92126,0.31496,0.92913,0.31496,0.93701,0.31496,0.94488,0.31496,0.95276,0.31496,0.96063,0.31496,0.9685,0.31496,0.97638,0.31496,0.98425,0.31496,0.99213,0.31496,0.99609,0.31496,0.00391,0.32283,0.00787,0.32283,0.01575,0.32283,0.02362,0.32283,0.0315,0.32283,0.03937,0.32283,0.04724,0.32283,0.05512,0.32283,0.06299,0.32283,0.07087,0.32283,0.07874,0.32283,0.08661,0.32283,0.09449,0.32283,0.10236,0.32283,0.11024,0.32283,0.11811,0.32283,0.12598,0.32283,0.13386,0.32283,0.14173,0.32283,0.14961,0.32283,0.15748,0.32283,0.16535,0.32283,0.17323,0.32283,0.1811,0.32283,0.18898,0.32283,0.19685,0.32283,0.20472,0.32283,0.2126,0.32283,0.22047,0.32283,0.22835,0.32283,0.23622,0.32283,0.24409,0.32283,0.25197,0.32283,0.25984,0.32283,0.26772,0.32283,0.27559,0.32283,0.28346,0.32283,0.29134,0.32283,0.29921,0.32283,0.30709,0.32283,0.31496,0.32283,0.32283,0.32283,0.33071,0.32283,0.33858,0.32283,0.34646,0.32283,0.35433,0.32283,0.3622,0.32283,0.37008,0.32283,0.37795,0.32283,0.38583,0.32283,0.3937,0.32283,0.40157,0.32283};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_54()
		{
			double[] value = {0.40945,0.32283,0.41732,0.32283,0.4252,0.32283,0.43307,0.32283,0.44094,0.32283,0.44882,0.32283,0.45669,0.32283,0.46457,0.32283,0.47244,0.32283,0.48031,0.32283,0.48819,0.32283,0.49606,0.32283,0.50394,0.32283,0.51181,0.32283,0.51969,0.32283,0.52756,0.32283,0.53543,0.32283,0.54331,0.32283,0.55118,0.32283,0.55906,0.32283,0.56693,0.32283,0.5748,0.32283,0.58268,0.32283,0.59055,0.32283,0.59843,0.32283,0.6063,0.32283,0.61417,0.32283,0.62205,0.32283,0.62992,0.32283,0.6378,0.32283,0.64567,0.32283,0.65354,0.32283,0.66142,0.32283,0.66929,0.32283,0.67717,0.32283,0.68504,0.32283,0.69291,0.32283,0.70079,0.32283,0.70866,0.32283,0.71654,0.32283,0.72441,0.32283,0.73228,0.32283,0.74016,0.32283,0.74803,0.32283,0.75591,0.32283,0.76378,0.32283,0.77165,0.32283,0.77953,0.32283,0.7874,0.32283,0.79528,0.32283,0.80315,0.32283,0.81102,0.32283,0.8189,0.32283,0.82677,0.32283,0.83465,0.32283,0.84252,0.32283,0.85039,0.32283,0.85827,0.32283,0.86614,0.32283,0.87402,0.32283,0.88189,0.32283,0.88976,0.32283,0.89764,0.32283,0.90551,0.32283,0.91339,0.32283,0.92126,0.32283,0.92913,0.32283,0.93701,0.32283,0.94488,0.32283,0.95276,0.32283,0.96063,0.32283,0.9685,0.32283,0.97638,0.32283,0.98425,0.32283,0.99213,0.32283,0.99609,0.32283,0.00391,0.33071,0.00787,0.33071,0.01575,0.33071,0.02362,0.33071,0.0315,0.33071,0.03937,0.33071,0.04724,0.33071,0.05512,0.33071,0.06299,0.33071,0.07087,0.33071,0.07874,0.33071,0.08661,0.33071,0.09449,0.33071,0.10236,0.33071,0.11024,0.33071,0.11811,0.33071,0.12598,0.33071,0.13386,0.33071,0.14173,0.33071,0.14961,0.33071,0.15748,0.33071,0.16535,0.33071,0.17323,0.33071,0.1811,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_55()
		{
			double[] value = {0.18898,0.33071,0.19685,0.33071,0.20472,0.33071,0.2126,0.33071,0.22047,0.33071,0.22835,0.33071,0.23622,0.33071,0.24409,0.33071,0.25197,0.33071,0.25984,0.33071,0.26772,0.33071,0.27559,0.33071,0.28346,0.33071,0.29134,0.33071,0.29921,0.33071,0.30709,0.33071,0.31496,0.33071,0.32283,0.33071,0.33071,0.33071,0.33858,0.33071,0.34646,0.33071,0.35433,0.33071,0.3622,0.33071,0.37008,0.33071,0.37795,0.33071,0.38583,0.33071,0.3937,0.33071,0.40157,0.33071,0.40945,0.33071,0.41732,0.33071,0.4252,0.33071,0.43307,0.33071,0.44094,0.33071,0.44882,0.33071,0.45669,0.33071,0.46457,0.33071,0.47244,0.33071,0.48031,0.33071,0.48819,0.33071,0.49606,0.33071,0.50394,0.33071,0.51181,0.33071,0.51969,0.33071,0.52756,0.33071,0.53543,0.33071,0.54331,0.33071,0.55118,0.33071,0.55906,0.33071,0.56693,0.33071,0.5748,0.33071,0.58268,0.33071,0.59055,0.33071,0.59843,0.33071,0.6063,0.33071,0.61417,0.33071,0.62205,0.33071,0.62992,0.33071,0.6378,0.33071,0.64567,0.33071,0.65354,0.33071,0.66142,0.33071,0.66929,0.33071,0.67717,0.33071,0.68504,0.33071,0.69291,0.33071,0.70079,0.33071,0.70866,0.33071,0.71654,0.33071,0.72441,0.33071,0.73228,0.33071,0.74016,0.33071,0.74803,0.33071,0.75591,0.33071,0.76378,0.33071,0.77165,0.33071,0.77953,0.33071,0.7874,0.33071,0.79528,0.33071,0.80315,0.33071,0.81102,0.33071,0.8189,0.33071,0.82677,0.33071,0.83465,0.33071,0.84252,0.33071,0.85039,0.33071,0.85827,0.33071,0.86614,0.33071,0.87402,0.33071,0.88189,0.33071,0.88976,0.33071,0.89764,0.33071,0.90551,0.33071,0.91339,0.33071,0.92126,0.33071,0.92913,0.33071,0.93701,0.33071,0.94488,0.33071,0.95276,0.33071,0.96063,0.33071,0.9685,0.33071};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_56()
		{
			double[] value = {0.97638,0.33071,0.98425,0.33071,0.99213,0.33071,0.99609,0.33071,0.00391,0.33858,0.00787,0.33858,0.01575,0.33858,0.02362,0.33858,0.0315,0.33858,0.03937,0.33858,0.04724,0.33858,0.05512,0.33858,0.06299,0.33858,0.07087,0.33858,0.07874,0.33858,0.08661,0.33858,0.09449,0.33858,0.10236,0.33858,0.11024,0.33858,0.11811,0.33858,0.12598,0.33858,0.13386,0.33858,0.14173,0.33858,0.14961,0.33858,0.15748,0.33858,0.16535,0.33858,0.17323,0.33858,0.1811,0.33858,0.18898,0.33858,0.19685,0.33858,0.20472,0.33858,0.2126,0.33858,0.22047,0.33858,0.22835,0.33858,0.23622,0.33858,0.24409,0.33858,0.25197,0.33858,0.25984,0.33858,0.26772,0.33858,0.27559,0.33858,0.28346,0.33858,0.29134,0.33858,0.29921,0.33858,0.30709,0.33858,0.31496,0.33858,0.32283,0.33858,0.33071,0.33858,0.33858,0.33858,0.34646,0.33858,0.35433,0.33858,0.3622,0.33858,0.37008,0.33858,0.37795,0.33858,0.38583,0.33858,0.3937,0.33858,0.40157,0.33858,0.40945,0.33858,0.41732,0.33858,0.4252,0.33858,0.43307,0.33858,0.44094,0.33858,0.44882,0.33858,0.45669,0.33858,0.46457,0.33858,0.47244,0.33858,0.48031,0.33858,0.48819,0.33858,0.49606,0.33858,0.50394,0.33858,0.51181,0.33858,0.51969,0.33858,0.52756,0.33858,0.53543,0.33858,0.54331,0.33858,0.55118,0.33858,0.55906,0.33858,0.56693,0.33858,0.5748,0.33858,0.58268,0.33858,0.59055,0.33858,0.59843,0.33858,0.6063,0.33858,0.61417,0.33858,0.62205,0.33858,0.62992,0.33858,0.6378,0.33858,0.64567,0.33858,0.65354,0.33858,0.66142,0.33858,0.66929,0.33858,0.67717,0.33858,0.68504,0.33858,0.69291,0.33858,0.70079,0.33858,0.70866,0.33858,0.71654,0.33858,0.72441,0.33858,0.73228,0.33858,0.74016,0.33858,0.74803,0.33858};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_57()
		{
			double[] value = {0.75591,0.33858,0.76378,0.33858,0.77165,0.33858,0.77953,0.33858,0.7874,0.33858,0.79528,0.33858,0.80315,0.33858,0.81102,0.33858,0.8189,0.33858,0.82677,0.33858,0.83465,0.33858,0.84252,0.33858,0.85039,0.33858,0.85827,0.33858,0.86614,0.33858,0.87402,0.33858,0.88189,0.33858,0.88976,0.33858,0.89764,0.33858,0.90551,0.33858,0.91339,0.33858,0.92126,0.33858,0.92913,0.33858,0.93701,0.33858,0.94488,0.33858,0.95276,0.33858,0.96063,0.33858,0.9685,0.33858,0.97638,0.33858,0.98425,0.33858,0.99213,0.33858,0.99609,0.33858,0.00391,0.34646,0.00787,0.34646,0.01575,0.34646,0.02362,0.34646,0.0315,0.34646,0.03937,0.34646,0.04724,0.34646,0.05512,0.34646,0.06299,0.34646,0.07087,0.34646,0.07874,0.34646,0.08661,0.34646,0.09449,0.34646,0.10236,0.34646,0.11024,0.34646,0.11811,0.34646,0.12598,0.34646,0.13386,0.34646,0.14173,0.34646,0.14961,0.34646,0.15748,0.34646,0.16535,0.34646,0.17323,0.34646,0.1811,0.34646,0.18898,0.34646,0.19685,0.34646,0.20472,0.34646,0.2126,0.34646,0.22047,0.34646,0.22835,0.34646,0.23622,0.34646,0.24409,0.34646,0.25197,0.34646,0.25984,0.34646,0.26772,0.34646,0.27559,0.34646,0.28346,0.34646,0.29134,0.34646,0.29921,0.34646,0.30709,0.34646,0.31496,0.34646,0.32283,0.34646,0.33071,0.34646,0.33858,0.34646,0.34646,0.34646,0.35433,0.34646,0.3622,0.34646,0.37008,0.34646,0.37795,0.34646,0.38583,0.34646,0.3937,0.34646,0.40157,0.34646,0.40945,0.34646,0.41732,0.34646,0.4252,0.34646,0.43307,0.34646,0.44094,0.34646,0.44882,0.34646,0.45669,0.34646,0.46457,0.34646,0.47244,0.34646,0.48031,0.34646,0.48819,0.34646,0.49606,0.34646,0.50394,0.34646,0.51181,0.34646,0.51969,0.34646,0.52756,0.34646};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_58()
		{
			double[] value = {0.53543,0.34646,0.54331,0.34646,0.55118,0.34646,0.55906,0.34646,0.56693,0.34646,0.5748,0.34646,0.58268,0.34646,0.59055,0.34646,0.59843,0.34646,0.6063,0.34646,0.61417,0.34646,0.62205,0.34646,0.62992,0.34646,0.6378,0.34646,0.64567,0.34646,0.65354,0.34646,0.66142,0.34646,0.66929,0.34646,0.67717,0.34646,0.68504,0.34646,0.69291,0.34646,0.70079,0.34646,0.70866,0.34646,0.71654,0.34646,0.72441,0.34646,0.73228,0.34646,0.74016,0.34646,0.74803,0.34646,0.75591,0.34646,0.76378,0.34646,0.77165,0.34646,0.77953,0.34646,0.7874,0.34646,0.79528,0.34646,0.80315,0.34646,0.81102,0.34646,0.8189,0.34646,0.82677,0.34646,0.83465,0.34646,0.84252,0.34646,0.85039,0.34646,0.85827,0.34646,0.86614,0.34646,0.87402,0.34646,0.88189,0.34646,0.88976,0.34646,0.89764,0.34646,0.90551,0.34646,0.91339,0.34646,0.92126,0.34646,0.92913,0.34646,0.93701,0.34646,0.94488,0.34646,0.95276,0.34646,0.96063,0.34646,0.9685,0.34646,0.97638,0.34646,0.98425,0.34646,0.99213,0.34646,0.99609,0.34646,0.00391,0.35433,0.00787,0.35433,0.01575,0.35433,0.02362,0.35433,0.0315,0.35433,0.03937,0.35433,0.04724,0.35433,0.05512,0.35433,0.06299,0.35433,0.07087,0.35433,0.07874,0.35433,0.08661,0.35433,0.09449,0.35433,0.10236,0.35433,0.11024,0.35433,0.11811,0.35433,0.12598,0.35433,0.13386,0.35433,0.14173,0.35433,0.14961,0.35433,0.15748,0.35433,0.16535,0.35433,0.17323,0.35433,0.1811,0.35433,0.18898,0.35433,0.19685,0.35433,0.20472,0.35433,0.2126,0.35433,0.22047,0.35433,0.22835,0.35433,0.23622,0.35433,0.24409,0.35433,0.25197,0.35433,0.25984,0.35433,0.26772,0.35433,0.27559,0.35433,0.28346,0.35433,0.29134,0.35433,0.29921,0.35433,0.30709,0.35433};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_59()
		{
			double[] value = {0.31496,0.35433,0.32283,0.35433,0.33071,0.35433,0.33858,0.35433,0.34646,0.35433,0.35433,0.35433,0.3622,0.35433,0.37008,0.35433,0.37795,0.35433,0.38583,0.35433,0.3937,0.35433,0.40157,0.35433,0.40945,0.35433,0.41732,0.35433,0.4252,0.35433,0.43307,0.35433,0.44094,0.35433,0.44882,0.35433,0.45669,0.35433,0.46457,0.35433,0.47244,0.35433,0.48031,0.35433,0.48819,0.35433,0.49606,0.35433,0.50394,0.35433,0.51181,0.35433,0.51969,0.35433,0.52756,0.35433,0.53543,0.35433,0.54331,0.35433,0.55118,0.35433,0.55906,0.35433,0.56693,0.35433,0.5748,0.35433,0.58268,0.35433,0.59055,0.35433,0.59843,0.35433,0.6063,0.35433,0.61417,0.35433,0.62205,0.35433,0.62992,0.35433,0.6378,0.35433,0.64567,0.35433,0.65354,0.35433,0.66142,0.35433,0.66929,0.35433,0.67717,0.35433,0.68504,0.35433,0.69291,0.35433,0.70079,0.35433,0.70866,0.35433,0.71654,0.35433,0.72441,0.35433,0.73228,0.35433,0.74016,0.35433,0.74803,0.35433,0.75591,0.35433,0.76378,0.35433,0.77165,0.35433,0.77953,0.35433,0.7874,0.35433,0.79528,0.35433,0.80315,0.35433,0.81102,0.35433,0.8189,0.35433,0.82677,0.35433,0.83465,0.35433,0.84252,0.35433,0.85039,0.35433,0.85827,0.35433,0.86614,0.35433,0.87402,0.35433,0.88189,0.35433,0.88976,0.35433,0.89764,0.35433,0.90551,0.35433,0.91339,0.35433,0.92126,0.35433,0.92913,0.35433,0.93701,0.35433,0.94488,0.35433,0.95276,0.35433,0.96063,0.35433,0.9685,0.35433,0.97638,0.35433,0.98425,0.35433,0.99213,0.35433,0.99609,0.35433,0.00391,0.3622,0.00787,0.3622,0.01575,0.3622,0.02362,0.3622,0.0315,0.3622,0.03937,0.3622,0.04724,0.3622,0.05512,0.3622,0.06299,0.3622,0.07087,0.3622,0.07874,0.3622,0.08661,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_60()
		{
			double[] value = {0.09449,0.3622,0.10236,0.3622,0.11024,0.3622,0.11811,0.3622,0.12598,0.3622,0.13386,0.3622,0.14173,0.3622,0.14961,0.3622,0.15748,0.3622,0.16535,0.3622,0.17323,0.3622,0.1811,0.3622,0.18898,0.3622,0.19685,0.3622,0.20472,0.3622,0.2126,0.3622,0.22047,0.3622,0.22835,0.3622,0.23622,0.3622,0.24409,0.3622,0.25197,0.3622,0.25984,0.3622,0.26772,0.3622,0.27559,0.3622,0.28346,0.3622,0.29134,0.3622,0.29921,0.3622,0.30709,0.3622,0.31496,0.3622,0.32283,0.3622,0.33071,0.3622,0.33858,0.3622,0.34646,0.3622,0.35433,0.3622,0.3622,0.3622,0.37008,0.3622,0.37795,0.3622,0.38583,0.3622,0.3937,0.3622,0.40157,0.3622,0.40945,0.3622,0.41732,0.3622,0.4252,0.3622,0.43307,0.3622,0.44094,0.3622,0.44882,0.3622,0.45669,0.3622,0.46457,0.3622,0.47244,0.3622,0.48031,0.3622,0.48819,0.3622,0.49606,0.3622,0.50394,0.3622,0.51181,0.3622,0.51969,0.3622,0.52756,0.3622,0.53543,0.3622,0.54331,0.3622,0.55118,0.3622,0.55906,0.3622,0.56693,0.3622,0.5748,0.3622,0.58268,0.3622,0.59055,0.3622,0.59843,0.3622,0.6063,0.3622,0.61417,0.3622,0.62205,0.3622,0.62992,0.3622,0.6378,0.3622,0.64567,0.3622,0.65354,0.3622,0.66142,0.3622,0.66929,0.3622,0.67717,0.3622,0.68504,0.3622,0.69291,0.3622,0.70079,0.3622,0.70866,0.3622,0.71654,0.3622,0.72441,0.3622,0.73228,0.3622,0.74016,0.3622,0.74803,0.3622,0.75591,0.3622,0.76378,0.3622,0.77165,0.3622,0.77953,0.3622,0.7874,0.3622,0.79528,0.3622,0.80315,0.3622,0.81102,0.3622,0.8189,0.3622,0.82677,0.3622,0.83465,0.3622,0.84252,0.3622,0.85039,0.3622,0.85827,0.3622,0.86614,0.3622,0.87402,0.3622};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_61()
		{
			double[] value = {0.88189,0.3622,0.88976,0.3622,0.89764,0.3622,0.90551,0.3622,0.91339,0.3622,0.92126,0.3622,0.92913,0.3622,0.93701,0.3622,0.94488,0.3622,0.95276,0.3622,0.96063,0.3622,0.9685,0.3622,0.97638,0.3622,0.98425,0.3622,0.99213,0.3622,0.99609,0.3622,0.00391,0.37008,0.00787,0.37008,0.01575,0.37008,0.02362,0.37008,0.0315,0.37008,0.03937,0.37008,0.04724,0.37008,0.05512,0.37008,0.06299,0.37008,0.07087,0.37008,0.07874,0.37008,0.08661,0.37008,0.09449,0.37008,0.10236,0.37008,0.11024,0.37008,0.11811,0.37008,0.12598,0.37008,0.13386,0.37008,0.14173,0.37008,0.14961,0.37008,0.15748,0.37008,0.16535,0.37008,0.17323,0.37008,0.1811,0.37008,0.18898,0.37008,0.19685,0.37008,0.20472,0.37008,0.2126,0.37008,0.22047,0.37008,0.22835,0.37008,0.23622,0.37008,0.24409,0.37008,0.25197,0.37008,0.25984,0.37008,0.26772,0.37008,0.27559,0.37008,0.28346,0.37008,0.29134,0.37008,0.29921,0.37008,0.30709,0.37008,0.31496,0.37008,0.32283,0.37008,0.33071,0.37008,0.33858,0.37008,0.34646,0.37008,0.35433,0.37008,0.3622,0.37008,0.37008,0.37008,0.37795,0.37008,0.38583,0.37008,0.3937,0.37008,0.40157,0.37008,0.40945,0.37008,0.41732,0.37008,0.4252,0.37008,0.43307,0.37008,0.44094,0.37008,0.44882,0.37008,0.45669,0.37008,0.46457,0.37008,0.47244,0.37008,0.48031,0.37008,0.48819,0.37008,0.49606,0.37008,0.50394,0.37008,0.51181,0.37008,0.51969,0.37008,0.52756,0.37008,0.53543,0.37008,0.54331,0.37008,0.55118,0.37008,0.55906,0.37008,0.56693,0.37008,0.5748,0.37008,0.58268,0.37008,0.59055,0.37008,0.59843,0.37008,0.6063,0.37008,0.61417,0.37008,0.62205,0.37008,0.62992,0.37008,0.6378,0.37008,0.64567,0.37008,0.65354,0.37008};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_62()
		{
			double[] value = {0.66142,0.37008,0.66929,0.37008,0.67717,0.37008,0.68504,0.37008,0.69291,0.37008,0.70079,0.37008,0.70866,0.37008,0.71654,0.37008,0.72441,0.37008,0.73228,0.37008,0.74016,0.37008,0.74803,0.37008,0.75591,0.37008,0.76378,0.37008,0.77165,0.37008,0.77953,0.37008,0.7874,0.37008,0.79528,0.37008,0.80315,0.37008,0.81102,0.37008,0.8189,0.37008,0.82677,0.37008,0.83465,0.37008,0.84252,0.37008,0.85039,0.37008,0.85827,0.37008,0.86614,0.37008,0.87402,0.37008,0.88189,0.37008,0.88976,0.37008,0.89764,0.37008,0.90551,0.37008,0.91339,0.37008,0.92126,0.37008,0.92913,0.37008,0.93701,0.37008,0.94488,0.37008,0.95276,0.37008,0.96063,0.37008,0.9685,0.37008,0.97638,0.37008,0.98425,0.37008,0.99213,0.37008,0.99609,0.37008,0.00391,0.37795,0.00787,0.37795,0.01575,0.37795,0.02362,0.37795,0.0315,0.37795,0.03937,0.37795,0.04724,0.37795,0.05512,0.37795,0.06299,0.37795,0.07087,0.37795,0.07874,0.37795,0.08661,0.37795,0.09449,0.37795,0.10236,0.37795,0.11024,0.37795,0.11811,0.37795,0.12598,0.37795,0.13386,0.37795,0.14173,0.37795,0.14961,0.37795,0.15748,0.37795,0.16535,0.37795,0.17323,0.37795,0.1811,0.37795,0.18898,0.37795,0.19685,0.37795,0.20472,0.37795,0.2126,0.37795,0.22047,0.37795,0.22835,0.37795,0.23622,0.37795,0.24409,0.37795,0.25197,0.37795,0.25984,0.37795,0.26772,0.37795,0.27559,0.37795,0.28346,0.37795,0.29134,0.37795,0.29921,0.37795,0.30709,0.37795,0.31496,0.37795,0.32283,0.37795,0.33071,0.37795,0.33858,0.37795,0.34646,0.37795,0.35433,0.37795,0.3622,0.37795,0.37008,0.37795,0.37795,0.37795,0.38583,0.37795,0.3937,0.37795,0.40157,0.37795,0.40945,0.37795,0.41732,0.37795,0.4252,0.37795,0.43307,0.37795};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_63()
		{
			double[] value = {0.44094,0.37795,0.44882,0.37795,0.45669,0.37795,0.46457,0.37795,0.47244,0.37795,0.48031,0.37795,0.48819,0.37795,0.49606,0.37795,0.50394,0.37795,0.51181,0.37795,0.51969,0.37795,0.52756,0.37795,0.53543,0.37795,0.54331,0.37795,0.55118,0.37795,0.55906,0.37795,0.56693,0.37795,0.5748,0.37795,0.58268,0.37795,0.59055,0.37795,0.59843,0.37795,0.6063,0.37795,0.61417,0.37795,0.62205,0.37795,0.62992,0.37795,0.6378,0.37795,0.64567,0.37795,0.65354,0.37795,0.66142,0.37795,0.66929,0.37795,0.67717,0.37795,0.68504,0.37795,0.69291,0.37795,0.70079,0.37795,0.70866,0.37795,0.71654,0.37795,0.72441,0.37795,0.73228,0.37795,0.74016,0.37795,0.74803,0.37795,0.75591,0.37795,0.76378,0.37795,0.77165,0.37795,0.77953,0.37795,0.7874,0.37795,0.79528,0.37795,0.80315,0.37795,0.81102,0.37795,0.8189,0.37795,0.82677,0.37795,0.83465,0.37795,0.84252,0.37795,0.85039,0.37795,0.85827,0.37795,0.86614,0.37795,0.87402,0.37795,0.88189,0.37795,0.88976,0.37795,0.89764,0.37795,0.90551,0.37795,0.91339,0.37795,0.92126,0.37795,0.92913,0.37795,0.93701,0.37795,0.94488,0.37795,0.95276,0.37795,0.96063,0.37795,0.9685,0.37795,0.97638,0.37795,0.98425,0.37795,0.99213,0.37795,0.99609,0.37795,0.00391,0.38583,0.00787,0.38583,0.01575,0.38583,0.02362,0.38583,0.0315,0.38583,0.03937,0.38583,0.04724,0.38583,0.05512,0.38583,0.06299,0.38583,0.07087,0.38583,0.07874,0.38583,0.08661,0.38583,0.09449,0.38583,0.10236,0.38583,0.11024,0.38583,0.11811,0.38583,0.12598,0.38583,0.13386,0.38583,0.14173,0.38583,0.14961,0.38583,0.15748,0.38583,0.16535,0.38583,0.17323,0.38583,0.1811,0.38583,0.18898,0.38583,0.19685,0.38583,0.20472,0.38583,0.2126,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_64()
		{
			double[] value = {0.22047,0.38583,0.22835,0.38583,0.23622,0.38583,0.24409,0.38583,0.25197,0.38583,0.25984,0.38583,0.26772,0.38583,0.27559,0.38583,0.28346,0.38583,0.29134,0.38583,0.29921,0.38583,0.30709,0.38583,0.31496,0.38583,0.32283,0.38583,0.33071,0.38583,0.33858,0.38583,0.34646,0.38583,0.35433,0.38583,0.3622,0.38583,0.37008,0.38583,0.37795,0.38583,0.38583,0.38583,0.3937,0.38583,0.40157,0.38583,0.40945,0.38583,0.41732,0.38583,0.4252,0.38583,0.43307,0.38583,0.44094,0.38583,0.44882,0.38583,0.45669,0.38583,0.46457,0.38583,0.47244,0.38583,0.48031,0.38583,0.48819,0.38583,0.49606,0.38583,0.50394,0.38583,0.51181,0.38583,0.51969,0.38583,0.52756,0.38583,0.53543,0.38583,0.54331,0.38583,0.55118,0.38583,0.55906,0.38583,0.56693,0.38583,0.5748,0.38583,0.58268,0.38583,0.59055,0.38583,0.59843,0.38583,0.6063,0.38583,0.61417,0.38583,0.62205,0.38583,0.62992,0.38583,0.6378,0.38583,0.64567,0.38583,0.65354,0.38583,0.66142,0.38583,0.66929,0.38583,0.67717,0.38583,0.68504,0.38583,0.69291,0.38583,0.70079,0.38583,0.70866,0.38583,0.71654,0.38583,0.72441,0.38583,0.73228,0.38583,0.74016,0.38583,0.74803,0.38583,0.75591,0.38583,0.76378,0.38583,0.77165,0.38583,0.77953,0.38583,0.7874,0.38583,0.79528,0.38583,0.80315,0.38583,0.81102,0.38583,0.8189,0.38583,0.82677,0.38583,0.83465,0.38583,0.84252,0.38583,0.85039,0.38583,0.85827,0.38583,0.86614,0.38583,0.87402,0.38583,0.88189,0.38583,0.88976,0.38583,0.89764,0.38583,0.90551,0.38583,0.91339,0.38583,0.92126,0.38583,0.92913,0.38583,0.93701,0.38583,0.94488,0.38583,0.95276,0.38583,0.96063,0.38583,0.9685,0.38583,0.97638,0.38583,0.98425,0.38583,0.99213,0.38583,0.99609,0.38583};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_65()
		{
			double[] value = {0.00391,0.3937,0.00787,0.3937,0.01575,0.3937,0.02362,0.3937,0.0315,0.3937,0.03937,0.3937,0.04724,0.3937,0.05512,0.3937,0.06299,0.3937,0.07087,0.3937,0.07874,0.3937,0.08661,0.3937,0.09449,0.3937,0.10236,0.3937,0.11024,0.3937,0.11811,0.3937,0.12598,0.3937,0.13386,0.3937,0.14173,0.3937,0.14961,0.3937,0.15748,0.3937,0.16535,0.3937,0.17323,0.3937,0.1811,0.3937,0.18898,0.3937,0.19685,0.3937,0.20472,0.3937,0.2126,0.3937,0.22047,0.3937,0.22835,0.3937,0.23622,0.3937,0.24409,0.3937,0.25197,0.3937,0.25984,0.3937,0.26772,0.3937,0.27559,0.3937,0.28346,0.3937,0.29134,0.3937,0.29921,0.3937,0.30709,0.3937,0.31496,0.3937,0.32283,0.3937,0.33071,0.3937,0.33858,0.3937,0.34646,0.3937,0.35433,0.3937,0.3622,0.3937,0.37008,0.3937,0.37795,0.3937,0.38583,0.3937,0.3937,0.3937,0.40157,0.3937,0.40945,0.3937,0.41732,0.3937,0.4252,0.3937,0.43307,0.3937,0.44094,0.3937,0.44882,0.3937,0.45669,0.3937,0.46457,0.3937,0.47244,0.3937,0.48031,0.3937,0.48819,0.3937,0.49606,0.3937,0.50394,0.3937,0.51181,0.3937,0.51969,0.3937,0.52756,0.3937,0.53543,0.3937,0.54331,0.3937,0.55118,0.3937,0.55906,0.3937,0.56693,0.3937,0.5748,0.3937,0.58268,0.3937,0.59055,0.3937,0.59843,0.3937,0.6063,0.3937,0.61417,0.3937,0.62205,0.3937,0.62992,0.3937,0.6378,0.3937,0.64567,0.3937,0.65354,0.3937,0.66142,0.3937,0.66929,0.3937,0.67717,0.3937,0.68504,0.3937,0.69291,0.3937,0.70079,0.3937,0.70866,0.3937,0.71654,0.3937,0.72441,0.3937,0.73228,0.3937,0.74016,0.3937,0.74803,0.3937,0.75591,0.3937,0.76378,0.3937,0.77165,0.3937,0.77953,0.3937};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_66()
		{
			double[] value = {0.7874,0.3937,0.79528,0.3937,0.80315,0.3937,0.81102,0.3937,0.8189,0.3937,0.82677,0.3937,0.83465,0.3937,0.84252,0.3937,0.85039,0.3937,0.85827,0.3937,0.86614,0.3937,0.87402,0.3937,0.88189,0.3937,0.88976,0.3937,0.89764,0.3937,0.90551,0.3937,0.91339,0.3937,0.92126,0.3937,0.92913,0.3937,0.93701,0.3937,0.94488,0.3937,0.95276,0.3937,0.96063,0.3937,0.9685,0.3937,0.97638,0.3937,0.98425,0.3937,0.99213,0.3937,0.99609,0.3937,0.00391,0.40157,0.00787,0.40157,0.01575,0.40157,0.02362,0.40157,0.0315,0.40157,0.03937,0.40157,0.04724,0.40157,0.05512,0.40157,0.06299,0.40157,0.07087,0.40157,0.07874,0.40157,0.08661,0.40157,0.09449,0.40157,0.10236,0.40157,0.11024,0.40157,0.11811,0.40157,0.12598,0.40157,0.13386,0.40157,0.14173,0.40157,0.14961,0.40157,0.15748,0.40157,0.16535,0.40157,0.17323,0.40157,0.1811,0.40157,0.18898,0.40157,0.19685,0.40157,0.20472,0.40157,0.2126,0.40157,0.22047,0.40157,0.22835,0.40157,0.23622,0.40157,0.24409,0.40157,0.25197,0.40157,0.25984,0.40157,0.26772,0.40157,0.27559,0.40157,0.28346,0.40157,0.29134,0.40157,0.29921,0.40157,0.30709,0.40157,0.31496,0.40157,0.32283,0.40157,0.33071,0.40157,0.33858,0.40157,0.34646,0.40157,0.35433,0.40157,0.3622,0.40157,0.37008,0.40157,0.37795,0.40157,0.38583,0.40157,0.3937,0.40157,0.40157,0.40157,0.40945,0.40157,0.41732,0.40157,0.4252,0.40157,0.43307,0.40157,0.44094,0.40157,0.44882,0.40157,0.45669,0.40157,0.46457,0.40157,0.47244,0.40157,0.48031,0.40157,0.48819,0.40157,0.49606,0.40157,0.50394,0.40157,0.51181,0.40157,0.51969,0.40157,0.52756,0.40157,0.53543,0.40157,0.54331,0.40157,0.55118,0.40157,0.55906,0.40157};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_67()
		{
			double[] value = {0.56693,0.40157,0.5748,0.40157,0.58268,0.40157,0.59055,0.40157,0.59843,0.40157,0.6063,0.40157,0.61417,0.40157,0.62205,0.40157,0.62992,0.40157,0.6378,0.40157,0.64567,0.40157,0.65354,0.40157,0.66142,0.40157,0.66929,0.40157,0.67717,0.40157,0.68504,0.40157,0.69291,0.40157,0.70079,0.40157,0.70866,0.40157,0.71654,0.40157,0.72441,0.40157,0.73228,0.40157,0.74016,0.40157,0.74803,0.40157,0.75591,0.40157,0.76378,0.40157,0.77165,0.40157,0.77953,0.40157,0.7874,0.40157,0.79528,0.40157,0.80315,0.40157,0.81102,0.40157,0.8189,0.40157,0.82677,0.40157,0.83465,0.40157,0.84252,0.40157,0.85039,0.40157,0.85827,0.40157,0.86614,0.40157,0.87402,0.40157,0.88189,0.40157,0.88976,0.40157,0.89764,0.40157,0.90551,0.40157,0.91339,0.40157,0.92126,0.40157,0.92913,0.40157,0.93701,0.40157,0.94488,0.40157,0.95276,0.40157,0.96063,0.40157,0.9685,0.40157,0.97638,0.40157,0.98425,0.40157,0.99213,0.40157,0.99609,0.40157,0.00391,0.40945,0.00787,0.40945,0.01575,0.40945,0.02362,0.40945,0.0315,0.40945,0.03937,0.40945,0.04724,0.40945,0.05512,0.40945,0.06299,0.40945,0.07087,0.40945,0.07874,0.40945,0.08661,0.40945,0.09449,0.40945,0.10236,0.40945,0.11024,0.40945,0.11811,0.40945,0.12598,0.40945,0.13386,0.40945,0.14173,0.40945,0.14961,0.40945,0.15748,0.40945,0.16535,0.40945,0.17323,0.40945,0.1811,0.40945,0.18898,0.40945,0.19685,0.40945,0.20472,0.40945,0.2126,0.40945,0.22047,0.40945,0.22835,0.40945,0.23622,0.40945,0.24409,0.40945,0.25197,0.40945,0.25984,0.40945,0.26772,0.40945,0.27559,0.40945,0.28346,0.40945,0.29134,0.40945,0.29921,0.40945,0.30709,0.40945,0.31496,0.40945,0.32283,0.40945,0.33071,0.40945,0.33858,0.40945};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_68()
		{
			double[] value = {0.34646,0.40945,0.35433,0.40945,0.3622,0.40945,0.37008,0.40945,0.37795,0.40945,0.38583,0.40945,0.3937,0.40945,0.40157,0.40945,0.40945,0.40945,0.41732,0.40945,0.4252,0.40945,0.43307,0.40945,0.44094,0.40945,0.44882,0.40945,0.45669,0.40945,0.46457,0.40945,0.47244,0.40945,0.48031,0.40945,0.48819,0.40945,0.49606,0.40945,0.50394,0.40945,0.51181,0.40945,0.51969,0.40945,0.52756,0.40945,0.53543,0.40945,0.54331,0.40945,0.55118,0.40945,0.55906,0.40945,0.56693,0.40945,0.5748,0.40945,0.58268,0.40945,0.59055,0.40945,0.59843,0.40945,0.6063,0.40945,0.61417,0.40945,0.62205,0.40945,0.62992,0.40945,0.6378,0.40945,0.64567,0.40945,0.65354,0.40945,0.66142,0.40945,0.66929,0.40945,0.67717,0.40945,0.68504,0.40945,0.69291,0.40945,0.70079,0.40945,0.70866,0.40945,0.71654,0.40945,0.72441,0.40945,0.73228,0.40945,0.74016,0.40945,0.74803,0.40945,0.75591,0.40945,0.76378,0.40945,0.77165,0.40945,0.77953,0.40945,0.7874,0.40945,0.79528,0.40945,0.80315,0.40945,0.81102,0.40945,0.8189,0.40945,0.82677,0.40945,0.83465,0.40945,0.84252,0.40945,0.85039,0.40945,0.85827,0.40945,0.86614,0.40945,0.87402,0.40945,0.88189,0.40945,0.88976,0.40945,0.89764,0.40945,0.90551,0.40945,0.91339,0.40945,0.92126,0.40945,0.92913,0.40945,0.93701,0.40945,0.94488,0.40945,0.95276,0.40945,0.96063,0.40945,0.9685,0.40945,0.97638,0.40945,0.98425,0.40945,0.99213,0.40945,0.99609,0.40945,0.00391,0.41732,0.00787,0.41732,0.01575,0.41732,0.02362,0.41732,0.0315,0.41732,0.03937,0.41732,0.04724,0.41732,0.05512,0.41732,0.06299,0.41732,0.07087,0.41732,0.07874,0.41732,0.08661,0.41732,0.09449,0.41732,0.10236,0.41732,0.11024,0.41732,0.11811,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_69()
		{
			double[] value = {0.12598,0.41732,0.13386,0.41732,0.14173,0.41732,0.14961,0.41732,0.15748,0.41732,0.16535,0.41732,0.17323,0.41732,0.1811,0.41732,0.18898,0.41732,0.19685,0.41732,0.20472,0.41732,0.2126,0.41732,0.22047,0.41732,0.22835,0.41732,0.23622,0.41732,0.24409,0.41732,0.25197,0.41732,0.25984,0.41732,0.26772,0.41732,0.27559,0.41732,0.28346,0.41732,0.29134,0.41732,0.29921,0.41732,0.30709,0.41732,0.31496,0.41732,0.32283,0.41732,0.33071,0.41732,0.33858,0.41732,0.34646,0.41732,0.35433,0.41732,0.3622,0.41732,0.37008,0.41732,0.37795,0.41732,0.38583,0.41732,0.3937,0.41732,0.40157,0.41732,0.40945,0.41732,0.41732,0.41732,0.4252,0.41732,0.43307,0.41732,0.44094,0.41732,0.44882,0.41732,0.45669,0.41732,0.46457,0.41732,0.47244,0.41732,0.48031,0.41732,0.48819,0.41732,0.49606,0.41732,0.50394,0.41732,0.51181,0.41732,0.51969,0.41732,0.52756,0.41732,0.53543,0.41732,0.54331,0.41732,0.55118,0.41732,0.55906,0.41732,0.56693,0.41732,0.5748,0.41732,0.58268,0.41732,0.59055,0.41732,0.59843,0.41732,0.6063,0.41732,0.61417,0.41732,0.62205,0.41732,0.62992,0.41732,0.6378,0.41732,0.64567,0.41732,0.65354,0.41732,0.66142,0.41732,0.66929,0.41732,0.67717,0.41732,0.68504,0.41732,0.69291,0.41732,0.70079,0.41732,0.70866,0.41732,0.71654,0.41732,0.72441,0.41732,0.73228,0.41732,0.74016,0.41732,0.74803,0.41732,0.75591,0.41732,0.76378,0.41732,0.77165,0.41732,0.77953,0.41732,0.7874,0.41732,0.79528,0.41732,0.80315,0.41732,0.81102,0.41732,0.8189,0.41732,0.82677,0.41732,0.83465,0.41732,0.84252,0.41732,0.85039,0.41732,0.85827,0.41732,0.86614,0.41732,0.87402,0.41732,0.88189,0.41732,0.88976,0.41732,0.89764,0.41732,0.90551,0.41732};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_70()
		{
			double[] value = {0.91339,0.41732,0.92126,0.41732,0.92913,0.41732,0.93701,0.41732,0.94488,0.41732,0.95276,0.41732,0.96063,0.41732,0.9685,0.41732,0.97638,0.41732,0.98425,0.41732,0.99213,0.41732,0.99609,0.41732,0.00391,0.4252,0.00787,0.4252,0.01575,0.4252,0.02362,0.4252,0.0315,0.4252,0.03937,0.4252,0.04724,0.4252,0.05512,0.4252,0.06299,0.4252,0.07087,0.4252,0.07874,0.4252,0.08661,0.4252,0.09449,0.4252,0.10236,0.4252,0.11024,0.4252,0.11811,0.4252,0.12598,0.4252,0.13386,0.4252,0.14173,0.4252,0.14961,0.4252,0.15748,0.4252,0.16535,0.4252,0.17323,0.4252,0.1811,0.4252,0.18898,0.4252,0.19685,0.4252,0.20472,0.4252,0.2126,0.4252,0.22047,0.4252,0.22835,0.4252,0.23622,0.4252,0.24409,0.4252,0.25197,0.4252,0.25984,0.4252,0.26772,0.4252,0.27559,0.4252,0.28346,0.4252,0.29134,0.4252,0.29921,0.4252,0.30709,0.4252,0.31496,0.4252,0.32283,0.4252,0.33071,0.4252,0.33858,0.4252,0.34646,0.4252,0.35433,0.4252,0.3622,0.4252,0.37008,0.4252,0.37795,0.4252,0.38583,0.4252,0.3937,0.4252,0.40157,0.4252,0.40945,0.4252,0.41732,0.4252,0.4252,0.4252,0.43307,0.4252,0.44094,0.4252,0.44882,0.4252,0.45669,0.4252,0.46457,0.4252,0.47244,0.4252,0.48031,0.4252,0.48819,0.4252,0.49606,0.4252,0.50394,0.4252,0.51181,0.4252,0.51969,0.4252,0.52756,0.4252,0.53543,0.4252,0.54331,0.4252,0.55118,0.4252,0.55906,0.4252,0.56693,0.4252,0.5748,0.4252,0.58268,0.4252,0.59055,0.4252,0.59843,0.4252,0.6063,0.4252,0.61417,0.4252,0.62205,0.4252,0.62992,0.4252,0.6378,0.4252,0.64567,0.4252,0.65354,0.4252,0.66142,0.4252,0.66929,0.4252,0.67717,0.4252,0.68504,0.4252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_71()
		{
			double[] value = {0.69291,0.4252,0.70079,0.4252,0.70866,0.4252,0.71654,0.4252,0.72441,0.4252,0.73228,0.4252,0.74016,0.4252,0.74803,0.4252,0.75591,0.4252,0.76378,0.4252,0.77165,0.4252,0.77953,0.4252,0.7874,0.4252,0.79528,0.4252,0.80315,0.4252,0.81102,0.4252,0.8189,0.4252,0.82677,0.4252,0.83465,0.4252,0.84252,0.4252,0.85039,0.4252,0.85827,0.4252,0.86614,0.4252,0.87402,0.4252,0.88189,0.4252,0.88976,0.4252,0.89764,0.4252,0.90551,0.4252,0.91339,0.4252,0.92126,0.4252,0.92913,0.4252,0.93701,0.4252,0.94488,0.4252,0.95276,0.4252,0.96063,0.4252,0.9685,0.4252,0.97638,0.4252,0.98425,0.4252,0.99213,0.4252,0.99609,0.4252,0.00391,0.43307,0.00787,0.43307,0.01575,0.43307,0.02362,0.43307,0.0315,0.43307,0.03937,0.43307,0.04724,0.43307,0.05512,0.43307,0.06299,0.43307,0.07087,0.43307,0.07874,0.43307,0.08661,0.43307,0.09449,0.43307,0.10236,0.43307,0.11024,0.43307,0.11811,0.43307,0.12598,0.43307,0.13386,0.43307,0.14173,0.43307,0.14961,0.43307,0.15748,0.43307,0.16535,0.43307,0.17323,0.43307,0.1811,0.43307,0.18898,0.43307,0.19685,0.43307,0.20472,0.43307,0.2126,0.43307,0.22047,0.43307,0.22835,0.43307,0.23622,0.43307,0.24409,0.43307,0.25197,0.43307,0.25984,0.43307,0.26772,0.43307,0.27559,0.43307,0.28346,0.43307,0.29134,0.43307,0.29921,0.43307,0.30709,0.43307,0.31496,0.43307,0.32283,0.43307,0.33071,0.43307,0.33858,0.43307,0.34646,0.43307,0.35433,0.43307,0.3622,0.43307,0.37008,0.43307,0.37795,0.43307,0.38583,0.43307,0.3937,0.43307,0.40157,0.43307,0.40945,0.43307,0.41732,0.43307,0.4252,0.43307,0.43307,0.43307,0.44094,0.43307,0.44882,0.43307,0.45669,0.43307,0.46457,0.43307};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_72()
		{
			double[] value = {0.47244,0.43307,0.48031,0.43307,0.48819,0.43307,0.49606,0.43307,0.50394,0.43307,0.51181,0.43307,0.51969,0.43307,0.52756,0.43307,0.53543,0.43307,0.54331,0.43307,0.55118,0.43307,0.55906,0.43307,0.56693,0.43307,0.5748,0.43307,0.58268,0.43307,0.59055,0.43307,0.59843,0.43307,0.6063,0.43307,0.61417,0.43307,0.62205,0.43307,0.62992,0.43307,0.6378,0.43307,0.64567,0.43307,0.65354,0.43307,0.66142,0.43307,0.66929,0.43307,0.67717,0.43307,0.68504,0.43307,0.69291,0.43307,0.70079,0.43307,0.70866,0.43307,0.71654,0.43307,0.72441,0.43307,0.73228,0.43307,0.74016,0.43307,0.74803,0.43307,0.75591,0.43307,0.76378,0.43307,0.77165,0.43307,0.77953,0.43307,0.7874,0.43307,0.79528,0.43307,0.80315,0.43307,0.81102,0.43307,0.8189,0.43307,0.82677,0.43307,0.83465,0.43307,0.84252,0.43307,0.85039,0.43307,0.85827,0.43307,0.86614,0.43307,0.87402,0.43307,0.88189,0.43307,0.88976,0.43307,0.89764,0.43307,0.90551,0.43307,0.91339,0.43307,0.92126,0.43307,0.92913,0.43307,0.93701,0.43307,0.94488,0.43307,0.95276,0.43307,0.96063,0.43307,0.9685,0.43307,0.97638,0.43307,0.98425,0.43307,0.99213,0.43307,0.99609,0.43307,0.00391,0.44094,0.00787,0.44094,0.01575,0.44094,0.02362,0.44094,0.0315,0.44094,0.03937,0.44094,0.04724,0.44094,0.05512,0.44094,0.06299,0.44094,0.07087,0.44094,0.07874,0.44094,0.08661,0.44094,0.09449,0.44094,0.10236,0.44094,0.11024,0.44094,0.11811,0.44094,0.12598,0.44094,0.13386,0.44094,0.14173,0.44094,0.14961,0.44094,0.15748,0.44094,0.16535,0.44094,0.17323,0.44094,0.1811,0.44094,0.18898,0.44094,0.19685,0.44094,0.20472,0.44094,0.2126,0.44094,0.22047,0.44094,0.22835,0.44094,0.23622,0.44094,0.24409,0.44094};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_73()
		{
			double[] value = {0.25197,0.44094,0.25984,0.44094,0.26772,0.44094,0.27559,0.44094,0.28346,0.44094,0.29134,0.44094,0.29921,0.44094,0.30709,0.44094,0.31496,0.44094,0.32283,0.44094,0.33071,0.44094,0.33858,0.44094,0.34646,0.44094,0.35433,0.44094,0.3622,0.44094,0.37008,0.44094,0.37795,0.44094,0.38583,0.44094,0.3937,0.44094,0.40157,0.44094,0.40945,0.44094,0.41732,0.44094,0.4252,0.44094,0.43307,0.44094,0.44094,0.44094,0.44882,0.44094,0.45669,0.44094,0.46457,0.44094,0.47244,0.44094,0.48031,0.44094,0.48819,0.44094,0.49606,0.44094,0.50394,0.44094,0.51181,0.44094,0.51969,0.44094,0.52756,0.44094,0.53543,0.44094,0.54331,0.44094,0.55118,0.44094,0.55906,0.44094,0.56693,0.44094,0.5748,0.44094,0.58268,0.44094,0.59055,0.44094,0.59843,0.44094,0.6063,0.44094,0.61417,0.44094,0.62205,0.44094,0.62992,0.44094,0.6378,0.44094,0.64567,0.44094,0.65354,0.44094,0.66142,0.44094,0.66929,0.44094,0.67717,0.44094,0.68504,0.44094,0.69291,0.44094,0.70079,0.44094,0.70866,0.44094,0.71654,0.44094,0.72441,0.44094,0.73228,0.44094,0.74016,0.44094,0.74803,0.44094,0.75591,0.44094,0.76378,0.44094,0.77165,0.44094,0.77953,0.44094,0.7874,0.44094,0.79528,0.44094,0.80315,0.44094,0.81102,0.44094,0.8189,0.44094,0.82677,0.44094,0.83465,0.44094,0.84252,0.44094,0.85039,0.44094,0.85827,0.44094,0.86614,0.44094,0.87402,0.44094,0.88189,0.44094,0.88976,0.44094,0.89764,0.44094,0.90551,0.44094,0.91339,0.44094,0.92126,0.44094,0.92913,0.44094,0.93701,0.44094,0.94488,0.44094,0.95276,0.44094,0.96063,0.44094,0.9685,0.44094,0.97638,0.44094,0.98425,0.44094,0.99213,0.44094,0.99609,0.44094,0.00391,0.44882,0.00787,0.44882,0.01575,0.44882,0.02362,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_74()
		{
			double[] value = {0.0315,0.44882,0.03937,0.44882,0.04724,0.44882,0.05512,0.44882,0.06299,0.44882,0.07087,0.44882,0.07874,0.44882,0.08661,0.44882,0.09449,0.44882,0.10236,0.44882,0.11024,0.44882,0.11811,0.44882,0.12598,0.44882,0.13386,0.44882,0.14173,0.44882,0.14961,0.44882,0.15748,0.44882,0.16535,0.44882,0.17323,0.44882,0.1811,0.44882,0.18898,0.44882,0.19685,0.44882,0.20472,0.44882,0.2126,0.44882,0.22047,0.44882,0.22835,0.44882,0.23622,0.44882,0.24409,0.44882,0.25197,0.44882,0.25984,0.44882,0.26772,0.44882,0.27559,0.44882,0.28346,0.44882,0.29134,0.44882,0.29921,0.44882,0.30709,0.44882,0.31496,0.44882,0.32283,0.44882,0.33071,0.44882,0.33858,0.44882,0.34646,0.44882,0.35433,0.44882,0.3622,0.44882,0.37008,0.44882,0.37795,0.44882,0.38583,0.44882,0.3937,0.44882,0.40157,0.44882,0.40945,0.44882,0.41732,0.44882,0.4252,0.44882,0.43307,0.44882,0.44094,0.44882,0.44882,0.44882,0.45669,0.44882,0.46457,0.44882,0.47244,0.44882,0.48031,0.44882,0.48819,0.44882,0.49606,0.44882,0.50394,0.44882,0.51181,0.44882,0.51969,0.44882,0.52756,0.44882,0.53543,0.44882,0.54331,0.44882,0.55118,0.44882,0.55906,0.44882,0.56693,0.44882,0.5748,0.44882,0.58268,0.44882,0.59055,0.44882,0.59843,0.44882,0.6063,0.44882,0.61417,0.44882,0.62205,0.44882,0.62992,0.44882,0.6378,0.44882,0.64567,0.44882,0.65354,0.44882,0.66142,0.44882,0.66929,0.44882,0.67717,0.44882,0.68504,0.44882,0.69291,0.44882,0.70079,0.44882,0.70866,0.44882,0.71654,0.44882,0.72441,0.44882,0.73228,0.44882,0.74016,0.44882,0.74803,0.44882,0.75591,0.44882,0.76378,0.44882,0.77165,0.44882,0.77953,0.44882,0.7874,0.44882,0.79528,0.44882,0.80315,0.44882,0.81102,0.44882};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_75()
		{
			double[] value = {0.8189,0.44882,0.82677,0.44882,0.83465,0.44882,0.84252,0.44882,0.85039,0.44882,0.85827,0.44882,0.86614,0.44882,0.87402,0.44882,0.88189,0.44882,0.88976,0.44882,0.89764,0.44882,0.90551,0.44882,0.91339,0.44882,0.92126,0.44882,0.92913,0.44882,0.93701,0.44882,0.94488,0.44882,0.95276,0.44882,0.96063,0.44882,0.9685,0.44882,0.97638,0.44882,0.98425,0.44882,0.99213,0.44882,0.99609,0.44882,0.00391,0.45669,0.00787,0.45669,0.01575,0.45669,0.02362,0.45669,0.0315,0.45669,0.03937,0.45669,0.04724,0.45669,0.05512,0.45669,0.06299,0.45669,0.07087,0.45669,0.07874,0.45669,0.08661,0.45669,0.09449,0.45669,0.10236,0.45669,0.11024,0.45669,0.11811,0.45669,0.12598,0.45669,0.13386,0.45669,0.14173,0.45669,0.14961,0.45669,0.15748,0.45669,0.16535,0.45669,0.17323,0.45669,0.1811,0.45669,0.18898,0.45669,0.19685,0.45669,0.20472,0.45669,0.2126,0.45669,0.22047,0.45669,0.22835,0.45669,0.23622,0.45669,0.24409,0.45669,0.25197,0.45669,0.25984,0.45669,0.26772,0.45669,0.27559,0.45669,0.28346,0.45669,0.29134,0.45669,0.29921,0.45669,0.30709,0.45669,0.31496,0.45669,0.32283,0.45669,0.33071,0.45669,0.33858,0.45669,0.34646,0.45669,0.35433,0.45669,0.3622,0.45669,0.37008,0.45669,0.37795,0.45669,0.38583,0.45669,0.3937,0.45669,0.40157,0.45669,0.40945,0.45669,0.41732,0.45669,0.4252,0.45669,0.43307,0.45669,0.44094,0.45669,0.44882,0.45669,0.45669,0.45669,0.46457,0.45669,0.47244,0.45669,0.48031,0.45669,0.48819,0.45669,0.49606,0.45669,0.50394,0.45669,0.51181,0.45669,0.51969,0.45669,0.52756,0.45669,0.53543,0.45669,0.54331,0.45669,0.55118,0.45669,0.55906,0.45669,0.56693,0.45669,0.5748,0.45669,0.58268,0.45669,0.59055,0.45669};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_76()
		{
			double[] value = {0.59843,0.45669,0.6063,0.45669,0.61417,0.45669,0.62205,0.45669,0.62992,0.45669,0.6378,0.45669,0.64567,0.45669,0.65354,0.45669,0.66142,0.45669,0.66929,0.45669,0.67717,0.45669,0.68504,0.45669,0.69291,0.45669,0.70079,0.45669,0.70866,0.45669,0.71654,0.45669,0.72441,0.45669,0.73228,0.45669,0.74016,0.45669,0.74803,0.45669,0.75591,0.45669,0.76378,0.45669,0.77165,0.45669,0.77953,0.45669,0.7874,0.45669,0.79528,0.45669,0.80315,0.45669,0.81102,0.45669,0.8189,0.45669,0.82677,0.45669,0.83465,0.45669,0.84252,0.45669,0.85039,0.45669,0.85827,0.45669,0.86614,0.45669,0.87402,0.45669,0.88189,0.45669,0.88976,0.45669,0.89764,0.45669,0.90551,0.45669,0.91339,0.45669,0.92126,0.45669,0.92913,0.45669,0.93701,0.45669,0.94488,0.45669,0.95276,0.45669,0.96063,0.45669,0.9685,0.45669,0.97638,0.45669,0.98425,0.45669,0.99213,0.45669,0.99609,0.45669,0.00391,0.46457,0.00787,0.46457,0.01575,0.46457,0.02362,0.46457,0.0315,0.46457,0.03937,0.46457,0.04724,0.46457,0.05512,0.46457,0.06299,0.46457,0.07087,0.46457,0.07874,0.46457,0.08661,0.46457,0.09449,0.46457,0.10236,0.46457,0.11024,0.46457,0.11811,0.46457,0.12598,0.46457,0.13386,0.46457,0.14173,0.46457,0.14961,0.46457,0.15748,0.46457,0.16535,0.46457,0.17323,0.46457,0.1811,0.46457,0.18898,0.46457,0.19685,0.46457,0.20472,0.46457,0.2126,0.46457,0.22047,0.46457,0.22835,0.46457,0.23622,0.46457,0.24409,0.46457,0.25197,0.46457,0.25984,0.46457,0.26772,0.46457,0.27559,0.46457,0.28346,0.46457,0.29134,0.46457,0.29921,0.46457,0.30709,0.46457,0.31496,0.46457,0.32283,0.46457,0.33071,0.46457,0.33858,0.46457,0.34646,0.46457,0.35433,0.46457,0.3622,0.46457,0.37008,0.46457};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_77()
		{
			double[] value = {0.37795,0.46457,0.38583,0.46457,0.3937,0.46457,0.40157,0.46457,0.40945,0.46457,0.41732,0.46457,0.4252,0.46457,0.43307,0.46457,0.44094,0.46457,0.44882,0.46457,0.45669,0.46457,0.46457,0.46457,0.47244,0.46457,0.48031,0.46457,0.48819,0.46457,0.49606,0.46457,0.50394,0.46457,0.51181,0.46457,0.51969,0.46457,0.52756,0.46457,0.53543,0.46457,0.54331,0.46457,0.55118,0.46457,0.55906,0.46457,0.56693,0.46457,0.5748,0.46457,0.58268,0.46457,0.59055,0.46457,0.59843,0.46457,0.6063,0.46457,0.61417,0.46457,0.62205,0.46457,0.62992,0.46457,0.6378,0.46457,0.64567,0.46457,0.65354,0.46457,0.66142,0.46457,0.66929,0.46457,0.67717,0.46457,0.68504,0.46457,0.69291,0.46457,0.70079,0.46457,0.70866,0.46457,0.71654,0.46457,0.72441,0.46457,0.73228,0.46457,0.74016,0.46457,0.74803,0.46457,0.75591,0.46457,0.76378,0.46457,0.77165,0.46457,0.77953,0.46457,0.7874,0.46457,0.79528,0.46457,0.80315,0.46457,0.81102,0.46457,0.8189,0.46457,0.82677,0.46457,0.83465,0.46457,0.84252,0.46457,0.85039,0.46457,0.85827,0.46457,0.86614,0.46457,0.87402,0.46457,0.88189,0.46457,0.88976,0.46457,0.89764,0.46457,0.90551,0.46457,0.91339,0.46457,0.92126,0.46457,0.92913,0.46457,0.93701,0.46457,0.94488,0.46457,0.95276,0.46457,0.96063,0.46457,0.9685,0.46457,0.97638,0.46457,0.98425,0.46457,0.99213,0.46457,0.99609,0.46457,0.00391,0.47244,0.00787,0.47244,0.01575,0.47244,0.02362,0.47244,0.0315,0.47244,0.03937,0.47244,0.04724,0.47244,0.05512,0.47244,0.06299,0.47244,0.07087,0.47244,0.07874,0.47244,0.08661,0.47244,0.09449,0.47244,0.10236,0.47244,0.11024,0.47244,0.11811,0.47244,0.12598,0.47244,0.13386,0.47244,0.14173,0.47244,0.14961,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_78()
		{
			double[] value = {0.15748,0.47244,0.16535,0.47244,0.17323,0.47244,0.1811,0.47244,0.18898,0.47244,0.19685,0.47244,0.20472,0.47244,0.2126,0.47244,0.22047,0.47244,0.22835,0.47244,0.23622,0.47244,0.24409,0.47244,0.25197,0.47244,0.25984,0.47244,0.26772,0.47244,0.27559,0.47244,0.28346,0.47244,0.29134,0.47244,0.29921,0.47244,0.30709,0.47244,0.31496,0.47244,0.32283,0.47244,0.33071,0.47244,0.33858,0.47244,0.34646,0.47244,0.35433,0.47244,0.3622,0.47244,0.37008,0.47244,0.37795,0.47244,0.38583,0.47244,0.3937,0.47244,0.40157,0.47244,0.40945,0.47244,0.41732,0.47244,0.4252,0.47244,0.43307,0.47244,0.44094,0.47244,0.44882,0.47244,0.45669,0.47244,0.46457,0.47244,0.47244,0.47244,0.48031,0.47244,0.48819,0.47244,0.49606,0.47244,0.50394,0.47244,0.51181,0.47244,0.51969,0.47244,0.52756,0.47244,0.53543,0.47244,0.54331,0.47244,0.55118,0.47244,0.55906,0.47244,0.56693,0.47244,0.5748,0.47244,0.58268,0.47244,0.59055,0.47244,0.59843,0.47244,0.6063,0.47244,0.61417,0.47244,0.62205,0.47244,0.62992,0.47244,0.6378,0.47244,0.64567,0.47244,0.65354,0.47244,0.66142,0.47244,0.66929,0.47244,0.67717,0.47244,0.68504,0.47244,0.69291,0.47244,0.70079,0.47244,0.70866,0.47244,0.71654,0.47244,0.72441,0.47244,0.73228,0.47244,0.74016,0.47244,0.74803,0.47244,0.75591,0.47244,0.76378,0.47244,0.77165,0.47244,0.77953,0.47244,0.7874,0.47244,0.79528,0.47244,0.80315,0.47244,0.81102,0.47244,0.8189,0.47244,0.82677,0.47244,0.83465,0.47244,0.84252,0.47244,0.85039,0.47244,0.85827,0.47244,0.86614,0.47244,0.87402,0.47244,0.88189,0.47244,0.88976,0.47244,0.89764,0.47244,0.90551,0.47244,0.91339,0.47244,0.92126,0.47244,0.92913,0.47244,0.93701,0.47244};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_79()
		{
			double[] value = {0.94488,0.47244,0.95276,0.47244,0.96063,0.47244,0.9685,0.47244,0.97638,0.47244,0.98425,0.47244,0.99213,0.47244,0.99609,0.47244,0.00391,0.48031,0.00787,0.48031,0.01575,0.48031,0.02362,0.48031,0.0315,0.48031,0.03937,0.48031,0.04724,0.48031,0.05512,0.48031,0.06299,0.48031,0.07087,0.48031,0.07874,0.48031,0.08661,0.48031,0.09449,0.48031,0.10236,0.48031,0.11024,0.48031,0.11811,0.48031,0.12598,0.48031,0.13386,0.48031,0.14173,0.48031,0.14961,0.48031,0.15748,0.48031,0.16535,0.48031,0.17323,0.48031,0.1811,0.48031,0.18898,0.48031,0.19685,0.48031,0.20472,0.48031,0.2126,0.48031,0.22047,0.48031,0.22835,0.48031,0.23622,0.48031,0.24409,0.48031,0.25197,0.48031,0.25984,0.48031,0.26772,0.48031,0.27559,0.48031,0.28346,0.48031,0.29134,0.48031,0.29921,0.48031,0.30709,0.48031,0.31496,0.48031,0.32283,0.48031,0.33071,0.48031,0.33858,0.48031,0.34646,0.48031,0.35433,0.48031,0.3622,0.48031,0.37008,0.48031,0.37795,0.48031,0.38583,0.48031,0.3937,0.48031,0.40157,0.48031,0.40945,0.48031,0.41732,0.48031,0.4252,0.48031,0.43307,0.48031,0.44094,0.48031,0.44882,0.48031,0.45669,0.48031,0.46457,0.48031,0.47244,0.48031,0.48031,0.48031,0.48819,0.48031,0.49606,0.48031,0.50394,0.48031,0.51181,0.48031,0.51969,0.48031,0.52756,0.48031,0.53543,0.48031,0.54331,0.48031,0.55118,0.48031,0.55906,0.48031,0.56693,0.48031,0.5748,0.48031,0.58268,0.48031,0.59055,0.48031,0.59843,0.48031,0.6063,0.48031,0.61417,0.48031,0.62205,0.48031,0.62992,0.48031,0.6378,0.48031,0.64567,0.48031,0.65354,0.48031,0.66142,0.48031,0.66929,0.48031,0.67717,0.48031,0.68504,0.48031,0.69291,0.48031,0.70079,0.48031,0.70866,0.48031,0.71654,0.48031};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_80()
		{
			double[] value = {0.72441,0.48031,0.73228,0.48031,0.74016,0.48031,0.74803,0.48031,0.75591,0.48031,0.76378,0.48031,0.77165,0.48031,0.77953,0.48031,0.7874,0.48031,0.79528,0.48031,0.80315,0.48031,0.81102,0.48031,0.8189,0.48031,0.82677,0.48031,0.83465,0.48031,0.84252,0.48031,0.85039,0.48031,0.85827,0.48031,0.86614,0.48031,0.87402,0.48031,0.88189,0.48031,0.88976,0.48031,0.89764,0.48031,0.90551,0.48031,0.91339,0.48031,0.92126,0.48031,0.92913,0.48031,0.93701,0.48031,0.94488,0.48031,0.95276,0.48031,0.96063,0.48031,0.9685,0.48031,0.97638,0.48031,0.98425,0.48031,0.99213,0.48031,0.99609,0.48031,0.00391,0.48819,0.00787,0.48819,0.01575,0.48819,0.02362,0.48819,0.0315,0.48819,0.03937,0.48819,0.04724,0.48819,0.05512,0.48819,0.06299,0.48819,0.07087,0.48819,0.07874,0.48819,0.08661,0.48819,0.09449,0.48819,0.10236,0.48819,0.11024,0.48819,0.11811,0.48819,0.12598,0.48819,0.13386,0.48819,0.14173,0.48819,0.14961,0.48819,0.15748,0.48819,0.16535,0.48819,0.17323,0.48819,0.1811,0.48819,0.18898,0.48819,0.19685,0.48819,0.20472,0.48819,0.2126,0.48819,0.22047,0.48819,0.22835,0.48819,0.23622,0.48819,0.24409,0.48819,0.25197,0.48819,0.25984,0.48819,0.26772,0.48819,0.27559,0.48819,0.28346,0.48819,0.29134,0.48819,0.29921,0.48819,0.30709,0.48819,0.31496,0.48819,0.32283,0.48819,0.33071,0.48819,0.33858,0.48819,0.34646,0.48819,0.35433,0.48819,0.3622,0.48819,0.37008,0.48819,0.37795,0.48819,0.38583,0.48819,0.3937,0.48819,0.40157,0.48819,0.40945,0.48819,0.41732,0.48819,0.4252,0.48819,0.43307,0.48819,0.44094,0.48819,0.44882,0.48819,0.45669,0.48819,0.46457,0.48819,0.47244,0.48819,0.48031,0.48819,0.48819,0.48819,0.49606,0.48819};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_81()
		{
			double[] value = {0.50394,0.48819,0.51181,0.48819,0.51969,0.48819,0.52756,0.48819,0.53543,0.48819,0.54331,0.48819,0.55118,0.48819,0.55906,0.48819,0.56693,0.48819,0.5748,0.48819,0.58268,0.48819,0.59055,0.48819,0.59843,0.48819,0.6063,0.48819,0.61417,0.48819,0.62205,0.48819,0.62992,0.48819,0.6378,0.48819,0.64567,0.48819,0.65354,0.48819,0.66142,0.48819,0.66929,0.48819,0.67717,0.48819,0.68504,0.48819,0.69291,0.48819,0.70079,0.48819,0.70866,0.48819,0.71654,0.48819,0.72441,0.48819,0.73228,0.48819,0.74016,0.48819,0.74803,0.48819,0.75591,0.48819,0.76378,0.48819,0.77165,0.48819,0.77953,0.48819,0.7874,0.48819,0.79528,0.48819,0.80315,0.48819,0.81102,0.48819,0.8189,0.48819,0.82677,0.48819,0.83465,0.48819,0.84252,0.48819,0.85039,0.48819,0.85827,0.48819,0.86614,0.48819,0.87402,0.48819,0.88189,0.48819,0.88976,0.48819,0.89764,0.48819,0.90551,0.48819,0.91339,0.48819,0.92126,0.48819,0.92913,0.48819,0.93701,0.48819,0.94488,0.48819,0.95276,0.48819,0.96063,0.48819,0.9685,0.48819,0.97638,0.48819,0.98425,0.48819,0.99213,0.48819,0.99609,0.48819,0.00391,0.49606,0.00787,0.49606,0.01575,0.49606,0.02362,0.49606,0.0315,0.49606,0.03937,0.49606,0.04724,0.49606,0.05512,0.49606,0.06299,0.49606,0.07087,0.49606,0.07874,0.49606,0.08661,0.49606,0.09449,0.49606,0.10236,0.49606,0.11024,0.49606,0.11811,0.49606,0.12598,0.49606,0.13386,0.49606,0.14173,0.49606,0.14961,0.49606,0.15748,0.49606,0.16535,0.49606,0.17323,0.49606,0.1811,0.49606,0.18898,0.49606,0.19685,0.49606,0.20472,0.49606,0.2126,0.49606,0.22047,0.49606,0.22835,0.49606,0.23622,0.49606,0.24409,0.49606,0.25197,0.49606,0.25984,0.49606,0.26772,0.49606,0.27559,0.49606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_82()
		{
			double[] value = {0.28346,0.49606,0.29134,0.49606,0.29921,0.49606,0.30709,0.49606,0.31496,0.49606,0.32283,0.49606,0.33071,0.49606,0.33858,0.49606,0.34646,0.49606,0.35433,0.49606,0.3622,0.49606,0.37008,0.49606,0.37795,0.49606,0.38583,0.49606,0.3937,0.49606,0.40157,0.49606,0.40945,0.49606,0.41732,0.49606,0.4252,0.49606,0.43307,0.49606,0.44094,0.49606,0.44882,0.49606,0.45669,0.49606,0.46457,0.49606,0.47244,0.49606,0.48031,0.49606,0.48819,0.49606,0.49606,0.49606,0.50394,0.49606,0.51181,0.49606,0.51969,0.49606,0.52756,0.49606,0.53543,0.49606,0.54331,0.49606,0.55118,0.49606,0.55906,0.49606,0.56693,0.49606,0.5748,0.49606,0.58268,0.49606,0.59055,0.49606,0.59843,0.49606,0.6063,0.49606,0.61417,0.49606,0.62205,0.49606,0.62992,0.49606,0.6378,0.49606,0.64567,0.49606,0.65354,0.49606,0.66142,0.49606,0.66929,0.49606,0.67717,0.49606,0.68504,0.49606,0.69291,0.49606,0.70079,0.49606,0.70866,0.49606,0.71654,0.49606,0.72441,0.49606,0.73228,0.49606,0.74016,0.49606,0.74803,0.49606,0.75591,0.49606,0.76378,0.49606,0.77165,0.49606,0.77953,0.49606,0.7874,0.49606,0.79528,0.49606,0.80315,0.49606,0.81102,0.49606,0.8189,0.49606,0.82677,0.49606,0.83465,0.49606,0.84252,0.49606,0.85039,0.49606,0.85827,0.49606,0.86614,0.49606,0.87402,0.49606,0.88189,0.49606,0.88976,0.49606,0.89764,0.49606,0.90551,0.49606,0.91339,0.49606,0.92126,0.49606,0.92913,0.49606,0.93701,0.49606,0.94488,0.49606,0.95276,0.49606,0.96063,0.49606,0.9685,0.49606,0.97638,0.49606,0.98425,0.49606,0.99213,0.49606,0.99609,0.49606,0.00391,0.50394,0.00787,0.50394,0.01575,0.50394,0.02362,0.50394,0.0315,0.50394,0.03937,0.50394,0.04724,0.50394,0.05512,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_83()
		{
			double[] value = {0.06299,0.50394,0.07087,0.50394,0.07874,0.50394,0.08661,0.50394,0.09449,0.50394,0.10236,0.50394,0.11024,0.50394,0.11811,0.50394,0.12598,0.50394,0.13386,0.50394,0.14173,0.50394,0.14961,0.50394,0.15748,0.50394,0.16535,0.50394,0.17323,0.50394,0.1811,0.50394,0.18898,0.50394,0.19685,0.50394,0.20472,0.50394,0.2126,0.50394,0.22047,0.50394,0.22835,0.50394,0.23622,0.50394,0.24409,0.50394,0.25197,0.50394,0.25984,0.50394,0.26772,0.50394,0.27559,0.50394,0.28346,0.50394,0.29134,0.50394,0.29921,0.50394,0.30709,0.50394,0.31496,0.50394,0.32283,0.50394,0.33071,0.50394,0.33858,0.50394,0.34646,0.50394,0.35433,0.50394,0.3622,0.50394,0.37008,0.50394,0.37795,0.50394,0.38583,0.50394,0.3937,0.50394,0.40157,0.50394,0.40945,0.50394,0.41732,0.50394,0.4252,0.50394,0.43307,0.50394,0.44094,0.50394,0.44882,0.50394,0.45669,0.50394,0.46457,0.50394,0.47244,0.50394,0.48031,0.50394,0.48819,0.50394,0.49606,0.50394,0.50394,0.50394,0.51181,0.50394,0.51969,0.50394,0.52756,0.50394,0.53543,0.50394,0.54331,0.50394,0.55118,0.50394,0.55906,0.50394,0.56693,0.50394,0.5748,0.50394,0.58268,0.50394,0.59055,0.50394,0.59843,0.50394,0.6063,0.50394,0.61417,0.50394,0.62205,0.50394,0.62992,0.50394,0.6378,0.50394,0.64567,0.50394,0.65354,0.50394,0.66142,0.50394,0.66929,0.50394,0.67717,0.50394,0.68504,0.50394,0.69291,0.50394,0.70079,0.50394,0.70866,0.50394,0.71654,0.50394,0.72441,0.50394,0.73228,0.50394,0.74016,0.50394,0.74803,0.50394,0.75591,0.50394,0.76378,0.50394,0.77165,0.50394,0.77953,0.50394,0.7874,0.50394,0.79528,0.50394,0.80315,0.50394,0.81102,0.50394,0.8189,0.50394,0.82677,0.50394,0.83465,0.50394,0.84252,0.50394};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_84()
		{
			double[] value = {0.85039,0.50394,0.85827,0.50394,0.86614,0.50394,0.87402,0.50394,0.88189,0.50394,0.88976,0.50394,0.89764,0.50394,0.90551,0.50394,0.91339,0.50394,0.92126,0.50394,0.92913,0.50394,0.93701,0.50394,0.94488,0.50394,0.95276,0.50394,0.96063,0.50394,0.9685,0.50394,0.97638,0.50394,0.98425,0.50394,0.99213,0.50394,0.99609,0.50394,0.00391,0.51181,0.00787,0.51181,0.01575,0.51181,0.02362,0.51181,0.0315,0.51181,0.03937,0.51181,0.04724,0.51181,0.05512,0.51181,0.06299,0.51181,0.07087,0.51181,0.07874,0.51181,0.08661,0.51181,0.09449,0.51181,0.10236,0.51181,0.11024,0.51181,0.11811,0.51181,0.12598,0.51181,0.13386,0.51181,0.14173,0.51181,0.14961,0.51181,0.15748,0.51181,0.16535,0.51181,0.17323,0.51181,0.1811,0.51181,0.18898,0.51181,0.19685,0.51181,0.20472,0.51181,0.2126,0.51181,0.22047,0.51181,0.22835,0.51181,0.23622,0.51181,0.24409,0.51181,0.25197,0.51181,0.25984,0.51181,0.26772,0.51181,0.27559,0.51181,0.28346,0.51181,0.29134,0.51181,0.29921,0.51181,0.30709,0.51181,0.31496,0.51181,0.32283,0.51181,0.33071,0.51181,0.33858,0.51181,0.34646,0.51181,0.35433,0.51181,0.3622,0.51181,0.37008,0.51181,0.37795,0.51181,0.38583,0.51181,0.3937,0.51181,0.40157,0.51181,0.40945,0.51181,0.41732,0.51181,0.4252,0.51181,0.43307,0.51181,0.44094,0.51181,0.44882,0.51181,0.45669,0.51181,0.46457,0.51181,0.47244,0.51181,0.48031,0.51181,0.48819,0.51181,0.49606,0.51181,0.50394,0.51181,0.51181,0.51181,0.51969,0.51181,0.52756,0.51181,0.53543,0.51181,0.54331,0.51181,0.55118,0.51181,0.55906,0.51181,0.56693,0.51181,0.5748,0.51181,0.58268,0.51181,0.59055,0.51181,0.59843,0.51181,0.6063,0.51181,0.61417,0.51181,0.62205,0.51181};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_85()
		{
			double[] value = {0.62992,0.51181,0.6378,0.51181,0.64567,0.51181,0.65354,0.51181,0.66142,0.51181,0.66929,0.51181,0.67717,0.51181,0.68504,0.51181,0.69291,0.51181,0.70079,0.51181,0.70866,0.51181,0.71654,0.51181,0.72441,0.51181,0.73228,0.51181,0.74016,0.51181,0.74803,0.51181,0.75591,0.51181,0.76378,0.51181,0.77165,0.51181,0.77953,0.51181,0.7874,0.51181,0.79528,0.51181,0.80315,0.51181,0.81102,0.51181,0.8189,0.51181,0.82677,0.51181,0.83465,0.51181,0.84252,0.51181,0.85039,0.51181,0.85827,0.51181,0.86614,0.51181,0.87402,0.51181,0.88189,0.51181,0.88976,0.51181,0.89764,0.51181,0.90551,0.51181,0.91339,0.51181,0.92126,0.51181,0.92913,0.51181,0.93701,0.51181,0.94488,0.51181,0.95276,0.51181,0.96063,0.51181,0.9685,0.51181,0.97638,0.51181,0.98425,0.51181,0.99213,0.51181,0.99609,0.51181,0.00391,0.51969,0.00787,0.51969,0.01575,0.51969,0.02362,0.51969,0.0315,0.51969,0.03937,0.51969,0.04724,0.51969,0.05512,0.51969,0.06299,0.51969,0.07087,0.51969,0.07874,0.51969,0.08661,0.51969,0.09449,0.51969,0.10236,0.51969,0.11024,0.51969,0.11811,0.51969,0.12598,0.51969,0.13386,0.51969,0.14173,0.51969,0.14961,0.51969,0.15748,0.51969,0.16535,0.51969,0.17323,0.51969,0.1811,0.51969,0.18898,0.51969,0.19685,0.51969,0.20472,0.51969,0.2126,0.51969,0.22047,0.51969,0.22835,0.51969,0.23622,0.51969,0.24409,0.51969,0.25197,0.51969,0.25984,0.51969,0.26772,0.51969,0.27559,0.51969,0.28346,0.51969,0.29134,0.51969,0.29921,0.51969,0.30709,0.51969,0.31496,0.51969,0.32283,0.51969,0.33071,0.51969,0.33858,0.51969,0.34646,0.51969,0.35433,0.51969,0.3622,0.51969,0.37008,0.51969,0.37795,0.51969,0.38583,0.51969,0.3937,0.51969,0.40157,0.51969};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_86()
		{
			double[] value = {0.40945,0.51969,0.41732,0.51969,0.4252,0.51969,0.43307,0.51969,0.44094,0.51969,0.44882,0.51969,0.45669,0.51969,0.46457,0.51969,0.47244,0.51969,0.48031,0.51969,0.48819,0.51969,0.49606,0.51969,0.50394,0.51969,0.51181,0.51969,0.51969,0.51969,0.52756,0.51969,0.53543,0.51969,0.54331,0.51969,0.55118,0.51969,0.55906,0.51969,0.56693,0.51969,0.5748,0.51969,0.58268,0.51969,0.59055,0.51969,0.59843,0.51969,0.6063,0.51969,0.61417,0.51969,0.62205,0.51969,0.62992,0.51969,0.6378,0.51969,0.64567,0.51969,0.65354,0.51969,0.66142,0.51969,0.66929,0.51969,0.67717,0.51969,0.68504,0.51969,0.69291,0.51969,0.70079,0.51969,0.70866,0.51969,0.71654,0.51969,0.72441,0.51969,0.73228,0.51969,0.74016,0.51969,0.74803,0.51969,0.75591,0.51969,0.76378,0.51969,0.77165,0.51969,0.77953,0.51969,0.7874,0.51969,0.79528,0.51969,0.80315,0.51969,0.81102,0.51969,0.8189,0.51969,0.82677,0.51969,0.83465,0.51969,0.84252,0.51969,0.85039,0.51969,0.85827,0.51969,0.86614,0.51969,0.87402,0.51969,0.88189,0.51969,0.88976,0.51969,0.89764,0.51969,0.90551,0.51969,0.91339,0.51969,0.92126,0.51969,0.92913,0.51969,0.93701,0.51969,0.94488,0.51969,0.95276,0.51969,0.96063,0.51969,0.9685,0.51969,0.97638,0.51969,0.98425,0.51969,0.99213,0.51969,0.99609,0.51969,0.00391,0.52756,0.00787,0.52756,0.01575,0.52756,0.02362,0.52756,0.0315,0.52756,0.03937,0.52756,0.04724,0.52756,0.05512,0.52756,0.06299,0.52756,0.07087,0.52756,0.07874,0.52756,0.08661,0.52756,0.09449,0.52756,0.10236,0.52756,0.11024,0.52756,0.11811,0.52756,0.12598,0.52756,0.13386,0.52756,0.14173,0.52756,0.14961,0.52756,0.15748,0.52756,0.16535,0.52756,0.17323,0.52756,0.1811,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_87()
		{
			double[] value = {0.18898,0.52756,0.19685,0.52756,0.20472,0.52756,0.2126,0.52756,0.22047,0.52756,0.22835,0.52756,0.23622,0.52756,0.24409,0.52756,0.25197,0.52756,0.25984,0.52756,0.26772,0.52756,0.27559,0.52756,0.28346,0.52756,0.29134,0.52756,0.29921,0.52756,0.30709,0.52756,0.31496,0.52756,0.32283,0.52756,0.33071,0.52756,0.33858,0.52756,0.34646,0.52756,0.35433,0.52756,0.3622,0.52756,0.37008,0.52756,0.37795,0.52756,0.38583,0.52756,0.3937,0.52756,0.40157,0.52756,0.40945,0.52756,0.41732,0.52756,0.4252,0.52756,0.43307,0.52756,0.44094,0.52756,0.44882,0.52756,0.45669,0.52756,0.46457,0.52756,0.47244,0.52756,0.48031,0.52756,0.48819,0.52756,0.49606,0.52756,0.50394,0.52756,0.51181,0.52756,0.51969,0.52756,0.52756,0.52756,0.53543,0.52756,0.54331,0.52756,0.55118,0.52756,0.55906,0.52756,0.56693,0.52756,0.5748,0.52756,0.58268,0.52756,0.59055,0.52756,0.59843,0.52756,0.6063,0.52756,0.61417,0.52756,0.62205,0.52756,0.62992,0.52756,0.6378,0.52756,0.64567,0.52756,0.65354,0.52756,0.66142,0.52756,0.66929,0.52756,0.67717,0.52756,0.68504,0.52756,0.69291,0.52756,0.70079,0.52756,0.70866,0.52756,0.71654,0.52756,0.72441,0.52756,0.73228,0.52756,0.74016,0.52756,0.74803,0.52756,0.75591,0.52756,0.76378,0.52756,0.77165,0.52756,0.77953,0.52756,0.7874,0.52756,0.79528,0.52756,0.80315,0.52756,0.81102,0.52756,0.8189,0.52756,0.82677,0.52756,0.83465,0.52756,0.84252,0.52756,0.85039,0.52756,0.85827,0.52756,0.86614,0.52756,0.87402,0.52756,0.88189,0.52756,0.88976,0.52756,0.89764,0.52756,0.90551,0.52756,0.91339,0.52756,0.92126,0.52756,0.92913,0.52756,0.93701,0.52756,0.94488,0.52756,0.95276,0.52756,0.96063,0.52756,0.9685,0.52756};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_88()
		{
			double[] value = {0.97638,0.52756,0.98425,0.52756,0.99213,0.52756,0.99609,0.52756,0.00391,0.53543,0.00787,0.53543,0.01575,0.53543,0.02362,0.53543,0.0315,0.53543,0.03937,0.53543,0.04724,0.53543,0.05512,0.53543,0.06299,0.53543,0.07087,0.53543,0.07874,0.53543,0.08661,0.53543,0.09449,0.53543,0.10236,0.53543,0.11024,0.53543,0.11811,0.53543,0.12598,0.53543,0.13386,0.53543,0.14173,0.53543,0.14961,0.53543,0.15748,0.53543,0.16535,0.53543,0.17323,0.53543,0.1811,0.53543,0.18898,0.53543,0.19685,0.53543,0.20472,0.53543,0.2126,0.53543,0.22047,0.53543,0.22835,0.53543,0.23622,0.53543,0.24409,0.53543,0.25197,0.53543,0.25984,0.53543,0.26772,0.53543,0.27559,0.53543,0.28346,0.53543,0.29134,0.53543,0.29921,0.53543,0.30709,0.53543,0.31496,0.53543,0.32283,0.53543,0.33071,0.53543,0.33858,0.53543,0.34646,0.53543,0.35433,0.53543,0.3622,0.53543,0.37008,0.53543,0.37795,0.53543,0.38583,0.53543,0.3937,0.53543,0.40157,0.53543,0.40945,0.53543,0.41732,0.53543,0.4252,0.53543,0.43307,0.53543,0.44094,0.53543,0.44882,0.53543,0.45669,0.53543,0.46457,0.53543,0.47244,0.53543,0.48031,0.53543,0.48819,0.53543,0.49606,0.53543,0.50394,0.53543,0.51181,0.53543,0.51969,0.53543,0.52756,0.53543,0.53543,0.53543,0.54331,0.53543,0.55118,0.53543,0.55906,0.53543,0.56693,0.53543,0.5748,0.53543,0.58268,0.53543,0.59055,0.53543,0.59843,0.53543,0.6063,0.53543,0.61417,0.53543,0.62205,0.53543,0.62992,0.53543,0.6378,0.53543,0.64567,0.53543,0.65354,0.53543,0.66142,0.53543,0.66929,0.53543,0.67717,0.53543,0.68504,0.53543,0.69291,0.53543,0.70079,0.53543,0.70866,0.53543,0.71654,0.53543,0.72441,0.53543,0.73228,0.53543,0.74016,0.53543,0.74803,0.53543};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_89()
		{
			double[] value = {0.75591,0.53543,0.76378,0.53543,0.77165,0.53543,0.77953,0.53543,0.7874,0.53543,0.79528,0.53543,0.80315,0.53543,0.81102,0.53543,0.8189,0.53543,0.82677,0.53543,0.83465,0.53543,0.84252,0.53543,0.85039,0.53543,0.85827,0.53543,0.86614,0.53543,0.87402,0.53543,0.88189,0.53543,0.88976,0.53543,0.89764,0.53543,0.90551,0.53543,0.91339,0.53543,0.92126,0.53543,0.92913,0.53543,0.93701,0.53543,0.94488,0.53543,0.95276,0.53543,0.96063,0.53543,0.9685,0.53543,0.97638,0.53543,0.98425,0.53543,0.99213,0.53543,0.99609,0.53543,0.00391,0.54331,0.00787,0.54331,0.01575,0.54331,0.02362,0.54331,0.0315,0.54331,0.03937,0.54331,0.04724,0.54331,0.05512,0.54331,0.06299,0.54331,0.07087,0.54331,0.07874,0.54331,0.08661,0.54331,0.09449,0.54331,0.10236,0.54331,0.11024,0.54331,0.11811,0.54331,0.12598,0.54331,0.13386,0.54331,0.14173,0.54331,0.14961,0.54331,0.15748,0.54331,0.16535,0.54331,0.17323,0.54331,0.1811,0.54331,0.18898,0.54331,0.19685,0.54331,0.20472,0.54331,0.2126,0.54331,0.22047,0.54331,0.22835,0.54331,0.23622,0.54331,0.24409,0.54331,0.25197,0.54331,0.25984,0.54331,0.26772,0.54331,0.27559,0.54331,0.28346,0.54331,0.29134,0.54331,0.29921,0.54331,0.30709,0.54331,0.31496,0.54331,0.32283,0.54331,0.33071,0.54331,0.33858,0.54331,0.34646,0.54331,0.35433,0.54331,0.3622,0.54331,0.37008,0.54331,0.37795,0.54331,0.38583,0.54331,0.3937,0.54331,0.40157,0.54331,0.40945,0.54331,0.41732,0.54331,0.4252,0.54331,0.43307,0.54331,0.44094,0.54331,0.44882,0.54331,0.45669,0.54331,0.46457,0.54331,0.47244,0.54331,0.48031,0.54331,0.48819,0.54331,0.49606,0.54331,0.50394,0.54331,0.51181,0.54331,0.51969,0.54331,0.52756,0.54331};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_90()
		{
			double[] value = {0.53543,0.54331,0.54331,0.54331,0.55118,0.54331,0.55906,0.54331,0.56693,0.54331,0.5748,0.54331,0.58268,0.54331,0.59055,0.54331,0.59843,0.54331,0.6063,0.54331,0.61417,0.54331,0.62205,0.54331,0.62992,0.54331,0.6378,0.54331,0.64567,0.54331,0.65354,0.54331,0.66142,0.54331,0.66929,0.54331,0.67717,0.54331,0.68504,0.54331,0.69291,0.54331,0.70079,0.54331,0.70866,0.54331,0.71654,0.54331,0.72441,0.54331,0.73228,0.54331,0.74016,0.54331,0.74803,0.54331,0.75591,0.54331,0.76378,0.54331,0.77165,0.54331,0.77953,0.54331,0.7874,0.54331,0.79528,0.54331,0.80315,0.54331,0.81102,0.54331,0.8189,0.54331,0.82677,0.54331,0.83465,0.54331,0.84252,0.54331,0.85039,0.54331,0.85827,0.54331,0.86614,0.54331,0.87402,0.54331,0.88189,0.54331,0.88976,0.54331,0.89764,0.54331,0.90551,0.54331,0.91339,0.54331,0.92126,0.54331,0.92913,0.54331,0.93701,0.54331,0.94488,0.54331,0.95276,0.54331,0.96063,0.54331,0.9685,0.54331,0.97638,0.54331,0.98425,0.54331,0.99213,0.54331,0.99609,0.54331,0.00391,0.55118,0.00787,0.55118,0.01575,0.55118,0.02362,0.55118,0.0315,0.55118,0.03937,0.55118,0.04724,0.55118,0.05512,0.55118,0.06299,0.55118,0.07087,0.55118,0.07874,0.55118,0.08661,0.55118,0.09449,0.55118,0.10236,0.55118,0.11024,0.55118,0.11811,0.55118,0.12598,0.55118,0.13386,0.55118,0.14173,0.55118,0.14961,0.55118,0.15748,0.55118,0.16535,0.55118,0.17323,0.55118,0.1811,0.55118,0.18898,0.55118,0.19685,0.55118,0.20472,0.55118,0.2126,0.55118,0.22047,0.55118,0.22835,0.55118,0.23622,0.55118,0.24409,0.55118,0.25197,0.55118,0.25984,0.55118,0.26772,0.55118,0.27559,0.55118,0.28346,0.55118,0.29134,0.55118,0.29921,0.55118,0.30709,0.55118};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_91()
		{
			double[] value = {0.31496,0.55118,0.32283,0.55118,0.33071,0.55118,0.33858,0.55118,0.34646,0.55118,0.35433,0.55118,0.3622,0.55118,0.37008,0.55118,0.37795,0.55118,0.38583,0.55118,0.3937,0.55118,0.40157,0.55118,0.40945,0.55118,0.41732,0.55118,0.4252,0.55118,0.43307,0.55118,0.44094,0.55118,0.44882,0.55118,0.45669,0.55118,0.46457,0.55118,0.47244,0.55118,0.48031,0.55118,0.48819,0.55118,0.49606,0.55118,0.50394,0.55118,0.51181,0.55118,0.51969,0.55118,0.52756,0.55118,0.53543,0.55118,0.54331,0.55118,0.55118,0.55118,0.55906,0.55118,0.56693,0.55118,0.5748,0.55118,0.58268,0.55118,0.59055,0.55118,0.59843,0.55118,0.6063,0.55118,0.61417,0.55118,0.62205,0.55118,0.62992,0.55118,0.6378,0.55118,0.64567,0.55118,0.65354,0.55118,0.66142,0.55118,0.66929,0.55118,0.67717,0.55118,0.68504,0.55118,0.69291,0.55118,0.70079,0.55118,0.70866,0.55118,0.71654,0.55118,0.72441,0.55118,0.73228,0.55118,0.74016,0.55118,0.74803,0.55118,0.75591,0.55118,0.76378,0.55118,0.77165,0.55118,0.77953,0.55118,0.7874,0.55118,0.79528,0.55118,0.80315,0.55118,0.81102,0.55118,0.8189,0.55118,0.82677,0.55118,0.83465,0.55118,0.84252,0.55118,0.85039,0.55118,0.85827,0.55118,0.86614,0.55118,0.87402,0.55118,0.88189,0.55118,0.88976,0.55118,0.89764,0.55118,0.90551,0.55118,0.91339,0.55118,0.92126,0.55118,0.92913,0.55118,0.93701,0.55118,0.94488,0.55118,0.95276,0.55118,0.96063,0.55118,0.9685,0.55118,0.97638,0.55118,0.98425,0.55118,0.99213,0.55118,0.99609,0.55118,0.00391,0.55906,0.00787,0.55906,0.01575,0.55906,0.02362,0.55906,0.0315,0.55906,0.03937,0.55906,0.04724,0.55906,0.05512,0.55906,0.06299,0.55906,0.07087,0.55906,0.07874,0.55906,0.08661,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_92()
		{
			double[] value = {0.09449,0.55906,0.10236,0.55906,0.11024,0.55906,0.11811,0.55906,0.12598,0.55906,0.13386,0.55906,0.14173,0.55906,0.14961,0.55906,0.15748,0.55906,0.16535,0.55906,0.17323,0.55906,0.1811,0.55906,0.18898,0.55906,0.19685,0.55906,0.20472,0.55906,0.2126,0.55906,0.22047,0.55906,0.22835,0.55906,0.23622,0.55906,0.24409,0.55906,0.25197,0.55906,0.25984,0.55906,0.26772,0.55906,0.27559,0.55906,0.28346,0.55906,0.29134,0.55906,0.29921,0.55906,0.30709,0.55906,0.31496,0.55906,0.32283,0.55906,0.33071,0.55906,0.33858,0.55906,0.34646,0.55906,0.35433,0.55906,0.3622,0.55906,0.37008,0.55906,0.37795,0.55906,0.38583,0.55906,0.3937,0.55906,0.40157,0.55906,0.40945,0.55906,0.41732,0.55906,0.4252,0.55906,0.43307,0.55906,0.44094,0.55906,0.44882,0.55906,0.45669,0.55906,0.46457,0.55906,0.47244,0.55906,0.48031,0.55906,0.48819,0.55906,0.49606,0.55906,0.50394,0.55906,0.51181,0.55906,0.51969,0.55906,0.52756,0.55906,0.53543,0.55906,0.54331,0.55906,0.55118,0.55906,0.55906,0.55906,0.56693,0.55906,0.5748,0.55906,0.58268,0.55906,0.59055,0.55906,0.59843,0.55906,0.6063,0.55906,0.61417,0.55906,0.62205,0.55906,0.62992,0.55906,0.6378,0.55906,0.64567,0.55906,0.65354,0.55906,0.66142,0.55906,0.66929,0.55906,0.67717,0.55906,0.68504,0.55906,0.69291,0.55906,0.70079,0.55906,0.70866,0.55906,0.71654,0.55906,0.72441,0.55906,0.73228,0.55906,0.74016,0.55906,0.74803,0.55906,0.75591,0.55906,0.76378,0.55906,0.77165,0.55906,0.77953,0.55906,0.7874,0.55906,0.79528,0.55906,0.80315,0.55906,0.81102,0.55906,0.8189,0.55906,0.82677,0.55906,0.83465,0.55906,0.84252,0.55906,0.85039,0.55906,0.85827,0.55906,0.86614,0.55906,0.87402,0.55906};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_93()
		{
			double[] value = {0.88189,0.55906,0.88976,0.55906,0.89764,0.55906,0.90551,0.55906,0.91339,0.55906,0.92126,0.55906,0.92913,0.55906,0.93701,0.55906,0.94488,0.55906,0.95276,0.55906,0.96063,0.55906,0.9685,0.55906,0.97638,0.55906,0.98425,0.55906,0.99213,0.55906,0.99609,0.55906,0.00391,0.56693,0.00787,0.56693,0.01575,0.56693,0.02362,0.56693,0.0315,0.56693,0.03937,0.56693,0.04724,0.56693,0.05512,0.56693,0.06299,0.56693,0.07087,0.56693,0.07874,0.56693,0.08661,0.56693,0.09449,0.56693,0.10236,0.56693,0.11024,0.56693,0.11811,0.56693,0.12598,0.56693,0.13386,0.56693,0.14173,0.56693,0.14961,0.56693,0.15748,0.56693,0.16535,0.56693,0.17323,0.56693,0.1811,0.56693,0.18898,0.56693,0.19685,0.56693,0.20472,0.56693,0.2126,0.56693,0.22047,0.56693,0.22835,0.56693,0.23622,0.56693,0.24409,0.56693,0.25197,0.56693,0.25984,0.56693,0.26772,0.56693,0.27559,0.56693,0.28346,0.56693,0.29134,0.56693,0.29921,0.56693,0.30709,0.56693,0.31496,0.56693,0.32283,0.56693,0.33071,0.56693,0.33858,0.56693,0.34646,0.56693,0.35433,0.56693,0.3622,0.56693,0.37008,0.56693,0.37795,0.56693,0.38583,0.56693,0.3937,0.56693,0.40157,0.56693,0.40945,0.56693,0.41732,0.56693,0.4252,0.56693,0.43307,0.56693,0.44094,0.56693,0.44882,0.56693,0.45669,0.56693,0.46457,0.56693,0.47244,0.56693,0.48031,0.56693,0.48819,0.56693,0.49606,0.56693,0.50394,0.56693,0.51181,0.56693,0.51969,0.56693,0.52756,0.56693,0.53543,0.56693,0.54331,0.56693,0.55118,0.56693,0.55906,0.56693,0.56693,0.56693,0.5748,0.56693,0.58268,0.56693,0.59055,0.56693,0.59843,0.56693,0.6063,0.56693,0.61417,0.56693,0.62205,0.56693,0.62992,0.56693,0.6378,0.56693,0.64567,0.56693,0.65354,0.56693};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_94()
		{
			double[] value = {0.66142,0.56693,0.66929,0.56693,0.67717,0.56693,0.68504,0.56693,0.69291,0.56693,0.70079,0.56693,0.70866,0.56693,0.71654,0.56693,0.72441,0.56693,0.73228,0.56693,0.74016,0.56693,0.74803,0.56693,0.75591,0.56693,0.76378,0.56693,0.77165,0.56693,0.77953,0.56693,0.7874,0.56693,0.79528,0.56693,0.80315,0.56693,0.81102,0.56693,0.8189,0.56693,0.82677,0.56693,0.83465,0.56693,0.84252,0.56693,0.85039,0.56693,0.85827,0.56693,0.86614,0.56693,0.87402,0.56693,0.88189,0.56693,0.88976,0.56693,0.89764,0.56693,0.90551,0.56693,0.91339,0.56693,0.92126,0.56693,0.92913,0.56693,0.93701,0.56693,0.94488,0.56693,0.95276,0.56693,0.96063,0.56693,0.9685,0.56693,0.97638,0.56693,0.98425,0.56693,0.99213,0.56693,0.99609,0.56693,0.00391,0.5748,0.00787,0.5748,0.01575,0.5748,0.02362,0.5748,0.0315,0.5748,0.03937,0.5748,0.04724,0.5748,0.05512,0.5748,0.06299,0.5748,0.07087,0.5748,0.07874,0.5748,0.08661,0.5748,0.09449,0.5748,0.10236,0.5748,0.11024,0.5748,0.11811,0.5748,0.12598,0.5748,0.13386,0.5748,0.14173,0.5748,0.14961,0.5748,0.15748,0.5748,0.16535,0.5748,0.17323,0.5748,0.1811,0.5748,0.18898,0.5748,0.19685,0.5748,0.20472,0.5748,0.2126,0.5748,0.22047,0.5748,0.22835,0.5748,0.23622,0.5748,0.24409,0.5748,0.25197,0.5748,0.25984,0.5748,0.26772,0.5748,0.27559,0.5748,0.28346,0.5748,0.29134,0.5748,0.29921,0.5748,0.30709,0.5748,0.31496,0.5748,0.32283,0.5748,0.33071,0.5748,0.33858,0.5748,0.34646,0.5748,0.35433,0.5748,0.3622,0.5748,0.37008,0.5748,0.37795,0.5748,0.38583,0.5748,0.3937,0.5748,0.40157,0.5748,0.40945,0.5748,0.41732,0.5748,0.4252,0.5748,0.43307,0.5748};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_95()
		{
			double[] value = {0.44094,0.5748,0.44882,0.5748,0.45669,0.5748,0.46457,0.5748,0.47244,0.5748,0.48031,0.5748,0.48819,0.5748,0.49606,0.5748,0.50394,0.5748,0.51181,0.5748,0.51969,0.5748,0.52756,0.5748,0.53543,0.5748,0.54331,0.5748,0.55118,0.5748,0.55906,0.5748,0.56693,0.5748,0.5748,0.5748,0.58268,0.5748,0.59055,0.5748,0.59843,0.5748,0.6063,0.5748,0.61417,0.5748,0.62205,0.5748,0.62992,0.5748,0.6378,0.5748,0.64567,0.5748,0.65354,0.5748,0.66142,0.5748,0.66929,0.5748,0.67717,0.5748,0.68504,0.5748,0.69291,0.5748,0.70079,0.5748,0.70866,0.5748,0.71654,0.5748,0.72441,0.5748,0.73228,0.5748,0.74016,0.5748,0.74803,0.5748,0.75591,0.5748,0.76378,0.5748,0.77165,0.5748,0.77953,0.5748,0.7874,0.5748,0.79528,0.5748,0.80315,0.5748,0.81102,0.5748,0.8189,0.5748,0.82677,0.5748,0.83465,0.5748,0.84252,0.5748,0.85039,0.5748,0.85827,0.5748,0.86614,0.5748,0.87402,0.5748,0.88189,0.5748,0.88976,0.5748,0.89764,0.5748,0.90551,0.5748,0.91339,0.5748,0.92126,0.5748,0.92913,0.5748,0.93701,0.5748,0.94488,0.5748,0.95276,0.5748,0.96063,0.5748,0.9685,0.5748,0.97638,0.5748,0.98425,0.5748,0.99213,0.5748,0.99609,0.5748,0.00391,0.58268,0.00787,0.58268,0.01575,0.58268,0.02362,0.58268,0.0315,0.58268,0.03937,0.58268,0.04724,0.58268,0.05512,0.58268,0.06299,0.58268,0.07087,0.58268,0.07874,0.58268,0.08661,0.58268,0.09449,0.58268,0.10236,0.58268,0.11024,0.58268,0.11811,0.58268,0.12598,0.58268,0.13386,0.58268,0.14173,0.58268,0.14961,0.58268,0.15748,0.58268,0.16535,0.58268,0.17323,0.58268,0.1811,0.58268,0.18898,0.58268,0.19685,0.58268,0.20472,0.58268,0.2126,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_96()
		{
			double[] value = {0.22047,0.58268,0.22835,0.58268,0.23622,0.58268,0.24409,0.58268,0.25197,0.58268,0.25984,0.58268,0.26772,0.58268,0.27559,0.58268,0.28346,0.58268,0.29134,0.58268,0.29921,0.58268,0.30709,0.58268,0.31496,0.58268,0.32283,0.58268,0.33071,0.58268,0.33858,0.58268,0.34646,0.58268,0.35433,0.58268,0.3622,0.58268,0.37008,0.58268,0.37795,0.58268,0.38583,0.58268,0.3937,0.58268,0.40157,0.58268,0.40945,0.58268,0.41732,0.58268,0.4252,0.58268,0.43307,0.58268,0.44094,0.58268,0.44882,0.58268,0.45669,0.58268,0.46457,0.58268,0.47244,0.58268,0.48031,0.58268,0.48819,0.58268,0.49606,0.58268,0.50394,0.58268,0.51181,0.58268,0.51969,0.58268,0.52756,0.58268,0.53543,0.58268,0.54331,0.58268,0.55118,0.58268,0.55906,0.58268,0.56693,0.58268,0.5748,0.58268,0.58268,0.58268,0.59055,0.58268,0.59843,0.58268,0.6063,0.58268,0.61417,0.58268,0.62205,0.58268,0.62992,0.58268,0.6378,0.58268,0.64567,0.58268,0.65354,0.58268,0.66142,0.58268,0.66929,0.58268,0.67717,0.58268,0.68504,0.58268,0.69291,0.58268,0.70079,0.58268,0.70866,0.58268,0.71654,0.58268,0.72441,0.58268,0.73228,0.58268,0.74016,0.58268,0.74803,0.58268,0.75591,0.58268,0.76378,0.58268,0.77165,0.58268,0.77953,0.58268,0.7874,0.58268,0.79528,0.58268,0.80315,0.58268,0.81102,0.58268,0.8189,0.58268,0.82677,0.58268,0.83465,0.58268,0.84252,0.58268,0.85039,0.58268,0.85827,0.58268,0.86614,0.58268,0.87402,0.58268,0.88189,0.58268,0.88976,0.58268,0.89764,0.58268,0.90551,0.58268,0.91339,0.58268,0.92126,0.58268,0.92913,0.58268,0.93701,0.58268,0.94488,0.58268,0.95276,0.58268,0.96063,0.58268,0.9685,0.58268,0.97638,0.58268,0.98425,0.58268,0.99213,0.58268,0.99609,0.58268};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_97()
		{
			double[] value = {0.00391,0.59055,0.00787,0.59055,0.01575,0.59055,0.02362,0.59055,0.0315,0.59055,0.03937,0.59055,0.04724,0.59055,0.05512,0.59055,0.06299,0.59055,0.07087,0.59055,0.07874,0.59055,0.08661,0.59055,0.09449,0.59055,0.10236,0.59055,0.11024,0.59055,0.11811,0.59055,0.12598,0.59055,0.13386,0.59055,0.14173,0.59055,0.14961,0.59055,0.15748,0.59055,0.16535,0.59055,0.17323,0.59055,0.1811,0.59055,0.18898,0.59055,0.19685,0.59055,0.20472,0.59055,0.2126,0.59055,0.22047,0.59055,0.22835,0.59055,0.23622,0.59055,0.24409,0.59055,0.25197,0.59055,0.25984,0.59055,0.26772,0.59055,0.27559,0.59055,0.28346,0.59055,0.29134,0.59055,0.29921,0.59055,0.30709,0.59055,0.31496,0.59055,0.32283,0.59055,0.33071,0.59055,0.33858,0.59055,0.34646,0.59055,0.35433,0.59055,0.3622,0.59055,0.37008,0.59055,0.37795,0.59055,0.38583,0.59055,0.3937,0.59055,0.40157,0.59055,0.40945,0.59055,0.41732,0.59055,0.4252,0.59055,0.43307,0.59055,0.44094,0.59055,0.44882,0.59055,0.45669,0.59055,0.46457,0.59055,0.47244,0.59055,0.48031,0.59055,0.48819,0.59055,0.49606,0.59055,0.50394,0.59055,0.51181,0.59055,0.51969,0.59055,0.52756,0.59055,0.53543,0.59055,0.54331,0.59055,0.55118,0.59055,0.55906,0.59055,0.56693,0.59055,0.5748,0.59055,0.58268,0.59055,0.59055,0.59055,0.59843,0.59055,0.6063,0.59055,0.61417,0.59055,0.62205,0.59055,0.62992,0.59055,0.6378,0.59055,0.64567,0.59055,0.65354,0.59055,0.66142,0.59055,0.66929,0.59055,0.67717,0.59055,0.68504,0.59055,0.69291,0.59055,0.70079,0.59055,0.70866,0.59055,0.71654,0.59055,0.72441,0.59055,0.73228,0.59055,0.74016,0.59055,0.74803,0.59055,0.75591,0.59055,0.76378,0.59055,0.77165,0.59055,0.77953,0.59055};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_98()
		{
			double[] value = {0.7874,0.59055,0.79528,0.59055,0.80315,0.59055,0.81102,0.59055,0.8189,0.59055,0.82677,0.59055,0.83465,0.59055,0.84252,0.59055,0.85039,0.59055,0.85827,0.59055,0.86614,0.59055,0.87402,0.59055,0.88189,0.59055,0.88976,0.59055,0.89764,0.59055,0.90551,0.59055,0.91339,0.59055,0.92126,0.59055,0.92913,0.59055,0.93701,0.59055,0.94488,0.59055,0.95276,0.59055,0.96063,0.59055,0.9685,0.59055,0.97638,0.59055,0.98425,0.59055,0.99213,0.59055,0.99609,0.59055,0.00391,0.59843,0.00787,0.59843,0.01575,0.59843,0.02362,0.59843,0.0315,0.59843,0.03937,0.59843,0.04724,0.59843,0.05512,0.59843,0.06299,0.59843,0.07087,0.59843,0.07874,0.59843,0.08661,0.59843,0.09449,0.59843,0.10236,0.59843,0.11024,0.59843,0.11811,0.59843,0.12598,0.59843,0.13386,0.59843,0.14173,0.59843,0.14961,0.59843,0.15748,0.59843,0.16535,0.59843,0.17323,0.59843,0.1811,0.59843,0.18898,0.59843,0.19685,0.59843,0.20472,0.59843,0.2126,0.59843,0.22047,0.59843,0.22835,0.59843,0.23622,0.59843,0.24409,0.59843,0.25197,0.59843,0.25984,0.59843,0.26772,0.59843,0.27559,0.59843,0.28346,0.59843,0.29134,0.59843,0.29921,0.59843,0.30709,0.59843,0.31496,0.59843,0.32283,0.59843,0.33071,0.59843,0.33858,0.59843,0.34646,0.59843,0.35433,0.59843,0.3622,0.59843,0.37008,0.59843,0.37795,0.59843,0.38583,0.59843,0.3937,0.59843,0.40157,0.59843,0.40945,0.59843,0.41732,0.59843,0.4252,0.59843,0.43307,0.59843,0.44094,0.59843,0.44882,0.59843,0.45669,0.59843,0.46457,0.59843,0.47244,0.59843,0.48031,0.59843,0.48819,0.59843,0.49606,0.59843,0.50394,0.59843,0.51181,0.59843,0.51969,0.59843,0.52756,0.59843,0.53543,0.59843,0.54331,0.59843,0.55118,0.59843,0.55906,0.59843};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_99()
		{
			double[] value = {0.56693,0.59843,0.5748,0.59843,0.58268,0.59843,0.59055,0.59843,0.59843,0.59843,0.6063,0.59843,0.61417,0.59843,0.62205,0.59843,0.62992,0.59843,0.6378,0.59843,0.64567,0.59843,0.65354,0.59843,0.66142,0.59843,0.66929,0.59843,0.67717,0.59843,0.68504,0.59843,0.69291,0.59843,0.70079,0.59843,0.70866,0.59843,0.71654,0.59843,0.72441,0.59843,0.73228,0.59843,0.74016,0.59843,0.74803,0.59843,0.75591,0.59843,0.76378,0.59843,0.77165,0.59843,0.77953,0.59843,0.7874,0.59843,0.79528,0.59843,0.80315,0.59843,0.81102,0.59843,0.8189,0.59843,0.82677,0.59843,0.83465,0.59843,0.84252,0.59843,0.85039,0.59843,0.85827,0.59843,0.86614,0.59843,0.87402,0.59843,0.88189,0.59843,0.88976,0.59843,0.89764,0.59843,0.90551,0.59843,0.91339,0.59843,0.92126,0.59843,0.92913,0.59843,0.93701,0.59843,0.94488,0.59843,0.95276,0.59843,0.96063,0.59843,0.9685,0.59843,0.97638,0.59843,0.98425,0.59843,0.99213,0.59843,0.99609,0.59843,0.00391,0.6063,0.00787,0.6063,0.01575,0.6063,0.02362,0.6063,0.0315,0.6063,0.03937,0.6063,0.04724,0.6063,0.05512,0.6063,0.06299,0.6063,0.07087,0.6063,0.07874,0.6063,0.08661,0.6063,0.09449,0.6063,0.10236,0.6063,0.11024,0.6063,0.11811,0.6063,0.12598,0.6063,0.13386,0.6063,0.14173,0.6063,0.14961,0.6063,0.15748,0.6063,0.16535,0.6063,0.17323,0.6063,0.1811,0.6063,0.18898,0.6063,0.19685,0.6063,0.20472,0.6063,0.2126,0.6063,0.22047,0.6063,0.22835,0.6063,0.23622,0.6063,0.24409,0.6063,0.25197,0.6063,0.25984,0.6063,0.26772,0.6063,0.27559,0.6063,0.28346,0.6063,0.29134,0.6063,0.29921,0.6063,0.30709,0.6063,0.31496,0.6063,0.32283,0.6063,0.33071,0.6063,0.33858,0.6063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_100()
		{
			double[] value = {0.34646,0.6063,0.35433,0.6063,0.3622,0.6063,0.37008,0.6063,0.37795,0.6063,0.38583,0.6063,0.3937,0.6063,0.40157,0.6063,0.40945,0.6063,0.41732,0.6063,0.4252,0.6063,0.43307,0.6063,0.44094,0.6063,0.44882,0.6063,0.45669,0.6063,0.46457,0.6063,0.47244,0.6063,0.48031,0.6063,0.48819,0.6063,0.49606,0.6063,0.50394,0.6063,0.51181,0.6063,0.51969,0.6063,0.52756,0.6063,0.53543,0.6063,0.54331,0.6063,0.55118,0.6063,0.55906,0.6063,0.56693,0.6063,0.5748,0.6063,0.58268,0.6063,0.59055,0.6063,0.59843,0.6063,0.6063,0.6063,0.61417,0.6063,0.62205,0.6063,0.62992,0.6063,0.6378,0.6063,0.64567,0.6063,0.65354,0.6063,0.66142,0.6063,0.66929,0.6063,0.67717,0.6063,0.68504,0.6063,0.69291,0.6063,0.70079,0.6063,0.70866,0.6063,0.71654,0.6063,0.72441,0.6063,0.73228,0.6063,0.74016,0.6063,0.74803,0.6063,0.75591,0.6063,0.76378,0.6063,0.77165,0.6063,0.77953,0.6063,0.7874,0.6063,0.79528,0.6063,0.80315,0.6063,0.81102,0.6063,0.8189,0.6063,0.82677,0.6063,0.83465,0.6063,0.84252,0.6063,0.85039,0.6063,0.85827,0.6063,0.86614,0.6063,0.87402,0.6063,0.88189,0.6063,0.88976,0.6063,0.89764,0.6063,0.90551,0.6063,0.91339,0.6063,0.92126,0.6063,0.92913,0.6063,0.93701,0.6063,0.94488,0.6063,0.95276,0.6063,0.96063,0.6063,0.9685,0.6063,0.97638,0.6063,0.98425,0.6063,0.99213,0.6063,0.99609,0.6063,0.00391,0.61417,0.00787,0.61417,0.01575,0.61417,0.02362,0.61417,0.0315,0.61417,0.03937,0.61417,0.04724,0.61417,0.05512,0.61417,0.06299,0.61417,0.07087,0.61417,0.07874,0.61417,0.08661,0.61417,0.09449,0.61417,0.10236,0.61417,0.11024,0.61417,0.11811,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_101()
		{
			double[] value = {0.12598,0.61417,0.13386,0.61417,0.14173,0.61417,0.14961,0.61417,0.15748,0.61417,0.16535,0.61417,0.17323,0.61417,0.1811,0.61417,0.18898,0.61417,0.19685,0.61417,0.20472,0.61417,0.2126,0.61417,0.22047,0.61417,0.22835,0.61417,0.23622,0.61417,0.24409,0.61417,0.25197,0.61417,0.25984,0.61417,0.26772,0.61417,0.27559,0.61417,0.28346,0.61417,0.29134,0.61417,0.29921,0.61417,0.30709,0.61417,0.31496,0.61417,0.32283,0.61417,0.33071,0.61417,0.33858,0.61417,0.34646,0.61417,0.35433,0.61417,0.3622,0.61417,0.37008,0.61417,0.37795,0.61417,0.38583,0.61417,0.3937,0.61417,0.40157,0.61417,0.40945,0.61417,0.41732,0.61417,0.4252,0.61417,0.43307,0.61417,0.44094,0.61417,0.44882,0.61417,0.45669,0.61417,0.46457,0.61417,0.47244,0.61417,0.48031,0.61417,0.48819,0.61417,0.49606,0.61417,0.50394,0.61417,0.51181,0.61417,0.51969,0.61417,0.52756,0.61417,0.53543,0.61417,0.54331,0.61417,0.55118,0.61417,0.55906,0.61417,0.56693,0.61417,0.5748,0.61417,0.58268,0.61417,0.59055,0.61417,0.59843,0.61417,0.6063,0.61417,0.61417,0.61417,0.62205,0.61417,0.62992,0.61417,0.6378,0.61417,0.64567,0.61417,0.65354,0.61417,0.66142,0.61417,0.66929,0.61417,0.67717,0.61417,0.68504,0.61417,0.69291,0.61417,0.70079,0.61417,0.70866,0.61417,0.71654,0.61417,0.72441,0.61417,0.73228,0.61417,0.74016,0.61417,0.74803,0.61417,0.75591,0.61417,0.76378,0.61417,0.77165,0.61417,0.77953,0.61417,0.7874,0.61417,0.79528,0.61417,0.80315,0.61417,0.81102,0.61417,0.8189,0.61417,0.82677,0.61417,0.83465,0.61417,0.84252,0.61417,0.85039,0.61417,0.85827,0.61417,0.86614,0.61417,0.87402,0.61417,0.88189,0.61417,0.88976,0.61417,0.89764,0.61417,0.90551,0.61417};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_102()
		{
			double[] value = {0.91339,0.61417,0.92126,0.61417,0.92913,0.61417,0.93701,0.61417,0.94488,0.61417,0.95276,0.61417,0.96063,0.61417,0.9685,0.61417,0.97638,0.61417,0.98425,0.61417,0.99213,0.61417,0.99609,0.61417,0.00391,0.62205,0.00787,0.62205,0.01575,0.62205,0.02362,0.62205,0.0315,0.62205,0.03937,0.62205,0.04724,0.62205,0.05512,0.62205,0.06299,0.62205,0.07087,0.62205,0.07874,0.62205,0.08661,0.62205,0.09449,0.62205,0.10236,0.62205,0.11024,0.62205,0.11811,0.62205,0.12598,0.62205,0.13386,0.62205,0.14173,0.62205,0.14961,0.62205,0.15748,0.62205,0.16535,0.62205,0.17323,0.62205,0.1811,0.62205,0.18898,0.62205,0.19685,0.62205,0.20472,0.62205,0.2126,0.62205,0.22047,0.62205,0.22835,0.62205,0.23622,0.62205,0.24409,0.62205,0.25197,0.62205,0.25984,0.62205,0.26772,0.62205,0.27559,0.62205,0.28346,0.62205,0.29134,0.62205,0.29921,0.62205,0.30709,0.62205,0.31496,0.62205,0.32283,0.62205,0.33071,0.62205,0.33858,0.62205,0.34646,0.62205,0.35433,0.62205,0.3622,0.62205,0.37008,0.62205,0.37795,0.62205,0.38583,0.62205,0.3937,0.62205,0.40157,0.62205,0.40945,0.62205,0.41732,0.62205,0.4252,0.62205,0.43307,0.62205,0.44094,0.62205,0.44882,0.62205,0.45669,0.62205,0.46457,0.62205,0.47244,0.62205,0.48031,0.62205,0.48819,0.62205,0.49606,0.62205,0.50394,0.62205,0.51181,0.62205,0.51969,0.62205,0.52756,0.62205,0.53543,0.62205,0.54331,0.62205,0.55118,0.62205,0.55906,0.62205,0.56693,0.62205,0.5748,0.62205,0.58268,0.62205,0.59055,0.62205,0.59843,0.62205,0.6063,0.62205,0.61417,0.62205,0.62205,0.62205,0.62992,0.62205,0.6378,0.62205,0.64567,0.62205,0.65354,0.62205,0.66142,0.62205,0.66929,0.62205,0.67717,0.62205,0.68504,0.62205};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_103()
		{
			double[] value = {0.69291,0.62205,0.70079,0.62205,0.70866,0.62205,0.71654,0.62205,0.72441,0.62205,0.73228,0.62205,0.74016,0.62205,0.74803,0.62205,0.75591,0.62205,0.76378,0.62205,0.77165,0.62205,0.77953,0.62205,0.7874,0.62205,0.79528,0.62205,0.80315,0.62205,0.81102,0.62205,0.8189,0.62205,0.82677,0.62205,0.83465,0.62205,0.84252,0.62205,0.85039,0.62205,0.85827,0.62205,0.86614,0.62205,0.87402,0.62205,0.88189,0.62205,0.88976,0.62205,0.89764,0.62205,0.90551,0.62205,0.91339,0.62205,0.92126,0.62205,0.92913,0.62205,0.93701,0.62205,0.94488,0.62205,0.95276,0.62205,0.96063,0.62205,0.9685,0.62205,0.97638,0.62205,0.98425,0.62205,0.99213,0.62205,0.99609,0.62205,0.00391,0.62992,0.00787,0.62992,0.01575,0.62992,0.02362,0.62992,0.0315,0.62992,0.03937,0.62992,0.04724,0.62992,0.05512,0.62992,0.06299,0.62992,0.07087,0.62992,0.07874,0.62992,0.08661,0.62992,0.09449,0.62992,0.10236,0.62992,0.11024,0.62992,0.11811,0.62992,0.12598,0.62992,0.13386,0.62992,0.14173,0.62992,0.14961,0.62992,0.15748,0.62992,0.16535,0.62992,0.17323,0.62992,0.1811,0.62992,0.18898,0.62992,0.19685,0.62992,0.20472,0.62992,0.2126,0.62992,0.22047,0.62992,0.22835,0.62992,0.23622,0.62992,0.24409,0.62992,0.25197,0.62992,0.25984,0.62992,0.26772,0.62992,0.27559,0.62992,0.28346,0.62992,0.29134,0.62992,0.29921,0.62992,0.30709,0.62992,0.31496,0.62992,0.32283,0.62992,0.33071,0.62992,0.33858,0.62992,0.34646,0.62992,0.35433,0.62992,0.3622,0.62992,0.37008,0.62992,0.37795,0.62992,0.38583,0.62992,0.3937,0.62992,0.40157,0.62992,0.40945,0.62992,0.41732,0.62992,0.4252,0.62992,0.43307,0.62992,0.44094,0.62992,0.44882,0.62992,0.45669,0.62992,0.46457,0.62992};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_104()
		{
			double[] value = {0.47244,0.62992,0.48031,0.62992,0.48819,0.62992,0.49606,0.62992,0.50394,0.62992,0.51181,0.62992,0.51969,0.62992,0.52756,0.62992,0.53543,0.62992,0.54331,0.62992,0.55118,0.62992,0.55906,0.62992,0.56693,0.62992,0.5748,0.62992,0.58268,0.62992,0.59055,0.62992,0.59843,0.62992,0.6063,0.62992,0.61417,0.62992,0.62205,0.62992,0.62992,0.62992,0.6378,0.62992,0.64567,0.62992,0.65354,0.62992,0.66142,0.62992,0.66929,0.62992,0.67717,0.62992,0.68504,0.62992,0.69291,0.62992,0.70079,0.62992,0.70866,0.62992,0.71654,0.62992,0.72441,0.62992,0.73228,0.62992,0.74016,0.62992,0.74803,0.62992,0.75591,0.62992,0.76378,0.62992,0.77165,0.62992,0.77953,0.62992,0.7874,0.62992,0.79528,0.62992,0.80315,0.62992,0.81102,0.62992,0.8189,0.62992,0.82677,0.62992,0.83465,0.62992,0.84252,0.62992,0.85039,0.62992,0.85827,0.62992,0.86614,0.62992,0.87402,0.62992,0.88189,0.62992,0.88976,0.62992,0.89764,0.62992,0.90551,0.62992,0.91339,0.62992,0.92126,0.62992,0.92913,0.62992,0.93701,0.62992,0.94488,0.62992,0.95276,0.62992,0.96063,0.62992,0.9685,0.62992,0.97638,0.62992,0.98425,0.62992,0.99213,0.62992,0.99609,0.62992,0.00391,0.6378,0.00787,0.6378,0.01575,0.6378,0.02362,0.6378,0.0315,0.6378,0.03937,0.6378,0.04724,0.6378,0.05512,0.6378,0.06299,0.6378,0.07087,0.6378,0.07874,0.6378,0.08661,0.6378,0.09449,0.6378,0.10236,0.6378,0.11024,0.6378,0.11811,0.6378,0.12598,0.6378,0.13386,0.6378,0.14173,0.6378,0.14961,0.6378,0.15748,0.6378,0.16535,0.6378,0.17323,0.6378,0.1811,0.6378,0.18898,0.6378,0.19685,0.6378,0.20472,0.6378,0.2126,0.6378,0.22047,0.6378,0.22835,0.6378,0.23622,0.6378,0.24409,0.6378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_105()
		{
			double[] value = {0.25197,0.6378,0.25984,0.6378,0.26772,0.6378,0.27559,0.6378,0.28346,0.6378,0.29134,0.6378,0.29921,0.6378,0.30709,0.6378,0.31496,0.6378,0.32283,0.6378,0.33071,0.6378,0.33858,0.6378,0.34646,0.6378,0.35433,0.6378,0.3622,0.6378,0.37008,0.6378,0.37795,0.6378,0.38583,0.6378,0.3937,0.6378,0.40157,0.6378,0.40945,0.6378,0.41732,0.6378,0.4252,0.6378,0.43307,0.6378,0.44094,0.6378,0.44882,0.6378,0.45669,0.6378,0.46457,0.6378,0.47244,0.6378,0.48031,0.6378,0.48819,0.6378,0.49606,0.6378,0.50394,0.6378,0.51181,0.6378,0.51969,0.6378,0.52756,0.6378,0.53543,0.6378,0.54331,0.6378,0.55118,0.6378,0.55906,0.6378,0.56693,0.6378,0.5748,0.6378,0.58268,0.6378,0.59055,0.6378,0.59843,0.6378,0.6063,0.6378,0.61417,0.6378,0.62205,0.6378,0.62992,0.6378,0.6378,0.6378,0.64567,0.6378,0.65354,0.6378,0.66142,0.6378,0.66929,0.6378,0.67717,0.6378,0.68504,0.6378,0.69291,0.6378,0.70079,0.6378,0.70866,0.6378,0.71654,0.6378,0.72441,0.6378,0.73228,0.6378,0.74016,0.6378,0.74803,0.6378,0.75591,0.6378,0.76378,0.6378,0.77165,0.6378,0.77953,0.6378,0.7874,0.6378,0.79528,0.6378,0.80315,0.6378,0.81102,0.6378,0.8189,0.6378,0.82677,0.6378,0.83465,0.6378,0.84252,0.6378,0.85039,0.6378,0.85827,0.6378,0.86614,0.6378,0.87402,0.6378,0.88189,0.6378,0.88976,0.6378,0.89764,0.6378,0.90551,0.6378,0.91339,0.6378,0.92126,0.6378,0.92913,0.6378,0.93701,0.6378,0.94488,0.6378,0.95276,0.6378,0.96063,0.6378,0.9685,0.6378,0.97638,0.6378,0.98425,0.6378,0.99213,0.6378,0.99609,0.6378,0.00391,0.64567,0.00787,0.64567,0.01575,0.64567,0.02362,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_106()
		{
			double[] value = {0.0315,0.64567,0.03937,0.64567,0.04724,0.64567,0.05512,0.64567,0.06299,0.64567,0.07087,0.64567,0.07874,0.64567,0.08661,0.64567,0.09449,0.64567,0.10236,0.64567,0.11024,0.64567,0.11811,0.64567,0.12598,0.64567,0.13386,0.64567,0.14173,0.64567,0.14961,0.64567,0.15748,0.64567,0.16535,0.64567,0.17323,0.64567,0.1811,0.64567,0.18898,0.64567,0.19685,0.64567,0.20472,0.64567,0.2126,0.64567,0.22047,0.64567,0.22835,0.64567,0.23622,0.64567,0.24409,0.64567,0.25197,0.64567,0.25984,0.64567,0.26772,0.64567,0.27559,0.64567,0.28346,0.64567,0.29134,0.64567,0.29921,0.64567,0.30709,0.64567,0.31496,0.64567,0.32283,0.64567,0.33071,0.64567,0.33858,0.64567,0.34646,0.64567,0.35433,0.64567,0.3622,0.64567,0.37008,0.64567,0.37795,0.64567,0.38583,0.64567,0.3937,0.64567,0.40157,0.64567,0.40945,0.64567,0.41732,0.64567,0.4252,0.64567,0.43307,0.64567,0.44094,0.64567,0.44882,0.64567,0.45669,0.64567,0.46457,0.64567,0.47244,0.64567,0.48031,0.64567,0.48819,0.64567,0.49606,0.64567,0.50394,0.64567,0.51181,0.64567,0.51969,0.64567,0.52756,0.64567,0.53543,0.64567,0.54331,0.64567,0.55118,0.64567,0.55906,0.64567,0.56693,0.64567,0.5748,0.64567,0.58268,0.64567,0.59055,0.64567,0.59843,0.64567,0.6063,0.64567,0.61417,0.64567,0.62205,0.64567,0.62992,0.64567,0.6378,0.64567,0.64567,0.64567,0.65354,0.64567,0.66142,0.64567,0.66929,0.64567,0.67717,0.64567,0.68504,0.64567,0.69291,0.64567,0.70079,0.64567,0.70866,0.64567,0.71654,0.64567,0.72441,0.64567,0.73228,0.64567,0.74016,0.64567,0.74803,0.64567,0.75591,0.64567,0.76378,0.64567,0.77165,0.64567,0.77953,0.64567,0.7874,0.64567,0.79528,0.64567,0.80315,0.64567,0.81102,0.64567};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_107()
		{
			double[] value = {0.8189,0.64567,0.82677,0.64567,0.83465,0.64567,0.84252,0.64567,0.85039,0.64567,0.85827,0.64567,0.86614,0.64567,0.87402,0.64567,0.88189,0.64567,0.88976,0.64567,0.89764,0.64567,0.90551,0.64567,0.91339,0.64567,0.92126,0.64567,0.92913,0.64567,0.93701,0.64567,0.94488,0.64567,0.95276,0.64567,0.96063,0.64567,0.9685,0.64567,0.97638,0.64567,0.98425,0.64567,0.99213,0.64567,0.99609,0.64567,0.00391,0.65354,0.00787,0.65354,0.01575,0.65354,0.02362,0.65354,0.0315,0.65354,0.03937,0.65354,0.04724,0.65354,0.05512,0.65354,0.06299,0.65354,0.07087,0.65354,0.07874,0.65354,0.08661,0.65354,0.09449,0.65354,0.10236,0.65354,0.11024,0.65354,0.11811,0.65354,0.12598,0.65354,0.13386,0.65354,0.14173,0.65354,0.14961,0.65354,0.15748,0.65354,0.16535,0.65354,0.17323,0.65354,0.1811,0.65354,0.18898,0.65354,0.19685,0.65354,0.20472,0.65354,0.2126,0.65354,0.22047,0.65354,0.22835,0.65354,0.23622,0.65354,0.24409,0.65354,0.25197,0.65354,0.25984,0.65354,0.26772,0.65354,0.27559,0.65354,0.28346,0.65354,0.29134,0.65354,0.29921,0.65354,0.30709,0.65354,0.31496,0.65354,0.32283,0.65354,0.33071,0.65354,0.33858,0.65354,0.34646,0.65354,0.35433,0.65354,0.3622,0.65354,0.37008,0.65354,0.37795,0.65354,0.38583,0.65354,0.3937,0.65354,0.40157,0.65354,0.40945,0.65354,0.41732,0.65354,0.4252,0.65354,0.43307,0.65354,0.44094,0.65354,0.44882,0.65354,0.45669,0.65354,0.46457,0.65354,0.47244,0.65354,0.48031,0.65354,0.48819,0.65354,0.49606,0.65354,0.50394,0.65354,0.51181,0.65354,0.51969,0.65354,0.52756,0.65354,0.53543,0.65354,0.54331,0.65354,0.55118,0.65354,0.55906,0.65354,0.56693,0.65354,0.5748,0.65354,0.58268,0.65354,0.59055,0.65354};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_108()
		{
			double[] value = {0.59843,0.65354,0.6063,0.65354,0.61417,0.65354,0.62205,0.65354,0.62992,0.65354,0.6378,0.65354,0.64567,0.65354,0.65354,0.65354,0.66142,0.65354,0.66929,0.65354,0.67717,0.65354,0.68504,0.65354,0.69291,0.65354,0.70079,0.65354,0.70866,0.65354,0.71654,0.65354,0.72441,0.65354,0.73228,0.65354,0.74016,0.65354,0.74803,0.65354,0.75591,0.65354,0.76378,0.65354,0.77165,0.65354,0.77953,0.65354,0.7874,0.65354,0.79528,0.65354,0.80315,0.65354,0.81102,0.65354,0.8189,0.65354,0.82677,0.65354,0.83465,0.65354,0.84252,0.65354,0.85039,0.65354,0.85827,0.65354,0.86614,0.65354,0.87402,0.65354,0.88189,0.65354,0.88976,0.65354,0.89764,0.65354,0.90551,0.65354,0.91339,0.65354,0.92126,0.65354,0.92913,0.65354,0.93701,0.65354,0.94488,0.65354,0.95276,0.65354,0.96063,0.65354,0.9685,0.65354,0.97638,0.65354,0.98425,0.65354,0.99213,0.65354,0.99609,0.65354,0.00391,0.66142,0.00787,0.66142,0.01575,0.66142,0.02362,0.66142,0.0315,0.66142,0.03937,0.66142,0.04724,0.66142,0.05512,0.66142,0.06299,0.66142,0.07087,0.66142,0.07874,0.66142,0.08661,0.66142,0.09449,0.66142,0.10236,0.66142,0.11024,0.66142,0.11811,0.66142,0.12598,0.66142,0.13386,0.66142,0.14173,0.66142,0.14961,0.66142,0.15748,0.66142,0.16535,0.66142,0.17323,0.66142,0.1811,0.66142,0.18898,0.66142,0.19685,0.66142,0.20472,0.66142,0.2126,0.66142,0.22047,0.66142,0.22835,0.66142,0.23622,0.66142,0.24409,0.66142,0.25197,0.66142,0.25984,0.66142,0.26772,0.66142,0.27559,0.66142,0.28346,0.66142,0.29134,0.66142,0.29921,0.66142,0.30709,0.66142,0.31496,0.66142,0.32283,0.66142,0.33071,0.66142,0.33858,0.66142,0.34646,0.66142,0.35433,0.66142,0.3622,0.66142,0.37008,0.66142};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_109()
		{
			double[] value = {0.37795,0.66142,0.38583,0.66142,0.3937,0.66142,0.40157,0.66142,0.40945,0.66142,0.41732,0.66142,0.4252,0.66142,0.43307,0.66142,0.44094,0.66142,0.44882,0.66142,0.45669,0.66142,0.46457,0.66142,0.47244,0.66142,0.48031,0.66142,0.48819,0.66142,0.49606,0.66142,0.50394,0.66142,0.51181,0.66142,0.51969,0.66142,0.52756,0.66142,0.53543,0.66142,0.54331,0.66142,0.55118,0.66142,0.55906,0.66142,0.56693,0.66142,0.5748,0.66142,0.58268,0.66142,0.59055,0.66142,0.59843,0.66142,0.6063,0.66142,0.61417,0.66142,0.62205,0.66142,0.62992,0.66142,0.6378,0.66142,0.64567,0.66142,0.65354,0.66142,0.66142,0.66142,0.66929,0.66142,0.67717,0.66142,0.68504,0.66142,0.69291,0.66142,0.70079,0.66142,0.70866,0.66142,0.71654,0.66142,0.72441,0.66142,0.73228,0.66142,0.74016,0.66142,0.74803,0.66142,0.75591,0.66142,0.76378,0.66142,0.77165,0.66142,0.77953,0.66142,0.7874,0.66142,0.79528,0.66142,0.80315,0.66142,0.81102,0.66142,0.8189,0.66142,0.82677,0.66142,0.83465,0.66142,0.84252,0.66142,0.85039,0.66142,0.85827,0.66142,0.86614,0.66142,0.87402,0.66142,0.88189,0.66142,0.88976,0.66142,0.89764,0.66142,0.90551,0.66142,0.91339,0.66142,0.92126,0.66142,0.92913,0.66142,0.93701,0.66142,0.94488,0.66142,0.95276,0.66142,0.96063,0.66142,0.9685,0.66142,0.97638,0.66142,0.98425,0.66142,0.99213,0.66142,0.99609,0.66142,0.00391,0.66929,0.00787,0.66929,0.01575,0.66929,0.02362,0.66929,0.0315,0.66929,0.03937,0.66929,0.04724,0.66929,0.05512,0.66929,0.06299,0.66929,0.07087,0.66929,0.07874,0.66929,0.08661,0.66929,0.09449,0.66929,0.10236,0.66929,0.11024,0.66929,0.11811,0.66929,0.12598,0.66929,0.13386,0.66929,0.14173,0.66929,0.14961,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_110()
		{
			double[] value = {0.15748,0.66929,0.16535,0.66929,0.17323,0.66929,0.1811,0.66929,0.18898,0.66929,0.19685,0.66929,0.20472,0.66929,0.2126,0.66929,0.22047,0.66929,0.22835,0.66929,0.23622,0.66929,0.24409,0.66929,0.25197,0.66929,0.25984,0.66929,0.26772,0.66929,0.27559,0.66929,0.28346,0.66929,0.29134,0.66929,0.29921,0.66929,0.30709,0.66929,0.31496,0.66929,0.32283,0.66929,0.33071,0.66929,0.33858,0.66929,0.34646,0.66929,0.35433,0.66929,0.3622,0.66929,0.37008,0.66929,0.37795,0.66929,0.38583,0.66929,0.3937,0.66929,0.40157,0.66929,0.40945,0.66929,0.41732,0.66929,0.4252,0.66929,0.43307,0.66929,0.44094,0.66929,0.44882,0.66929,0.45669,0.66929,0.46457,0.66929,0.47244,0.66929,0.48031,0.66929,0.48819,0.66929,0.49606,0.66929,0.50394,0.66929,0.51181,0.66929,0.51969,0.66929,0.52756,0.66929,0.53543,0.66929,0.54331,0.66929,0.55118,0.66929,0.55906,0.66929,0.56693,0.66929,0.5748,0.66929,0.58268,0.66929,0.59055,0.66929,0.59843,0.66929,0.6063,0.66929,0.61417,0.66929,0.62205,0.66929,0.62992,0.66929,0.6378,0.66929,0.64567,0.66929,0.65354,0.66929,0.66142,0.66929,0.66929,0.66929,0.67717,0.66929,0.68504,0.66929,0.69291,0.66929,0.70079,0.66929,0.70866,0.66929,0.71654,0.66929,0.72441,0.66929,0.73228,0.66929,0.74016,0.66929,0.74803,0.66929,0.75591,0.66929,0.76378,0.66929,0.77165,0.66929,0.77953,0.66929,0.7874,0.66929,0.79528,0.66929,0.80315,0.66929,0.81102,0.66929,0.8189,0.66929,0.82677,0.66929,0.83465,0.66929,0.84252,0.66929,0.85039,0.66929,0.85827,0.66929,0.86614,0.66929,0.87402,0.66929,0.88189,0.66929,0.88976,0.66929,0.89764,0.66929,0.90551,0.66929,0.91339,0.66929,0.92126,0.66929,0.92913,0.66929,0.93701,0.66929};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_111()
		{
			double[] value = {0.94488,0.66929,0.95276,0.66929,0.96063,0.66929,0.9685,0.66929,0.97638,0.66929,0.98425,0.66929,0.99213,0.66929,0.99609,0.66929,0.00391,0.67717,0.00787,0.67717,0.01575,0.67717,0.02362,0.67717,0.0315,0.67717,0.03937,0.67717,0.04724,0.67717,0.05512,0.67717,0.06299,0.67717,0.07087,0.67717,0.07874,0.67717,0.08661,0.67717,0.09449,0.67717,0.10236,0.67717,0.11024,0.67717,0.11811,0.67717,0.12598,0.67717,0.13386,0.67717,0.14173,0.67717,0.14961,0.67717,0.15748,0.67717,0.16535,0.67717,0.17323,0.67717,0.1811,0.67717,0.18898,0.67717,0.19685,0.67717,0.20472,0.67717,0.2126,0.67717,0.22047,0.67717,0.22835,0.67717,0.23622,0.67717,0.24409,0.67717,0.25197,0.67717,0.25984,0.67717,0.26772,0.67717,0.27559,0.67717,0.28346,0.67717,0.29134,0.67717,0.29921,0.67717,0.30709,0.67717,0.31496,0.67717,0.32283,0.67717,0.33071,0.67717,0.33858,0.67717,0.34646,0.67717,0.35433,0.67717,0.3622,0.67717,0.37008,0.67717,0.37795,0.67717,0.38583,0.67717,0.3937,0.67717,0.40157,0.67717,0.40945,0.67717,0.41732,0.67717,0.4252,0.67717,0.43307,0.67717,0.44094,0.67717,0.44882,0.67717,0.45669,0.67717,0.46457,0.67717,0.47244,0.67717,0.48031,0.67717,0.48819,0.67717,0.49606,0.67717,0.50394,0.67717,0.51181,0.67717,0.51969,0.67717,0.52756,0.67717,0.53543,0.67717,0.54331,0.67717,0.55118,0.67717,0.55906,0.67717,0.56693,0.67717,0.5748,0.67717,0.58268,0.67717,0.59055,0.67717,0.59843,0.67717,0.6063,0.67717,0.61417,0.67717,0.62205,0.67717,0.62992,0.67717,0.6378,0.67717,0.64567,0.67717,0.65354,0.67717,0.66142,0.67717,0.66929,0.67717,0.67717,0.67717,0.68504,0.67717,0.69291,0.67717,0.70079,0.67717,0.70866,0.67717,0.71654,0.67717};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_112()
		{
			double[] value = {0.72441,0.67717,0.73228,0.67717,0.74016,0.67717,0.74803,0.67717,0.75591,0.67717,0.76378,0.67717,0.77165,0.67717,0.77953,0.67717,0.7874,0.67717,0.79528,0.67717,0.80315,0.67717,0.81102,0.67717,0.8189,0.67717,0.82677,0.67717,0.83465,0.67717,0.84252,0.67717,0.85039,0.67717,0.85827,0.67717,0.86614,0.67717,0.87402,0.67717,0.88189,0.67717,0.88976,0.67717,0.89764,0.67717,0.90551,0.67717,0.91339,0.67717,0.92126,0.67717,0.92913,0.67717,0.93701,0.67717,0.94488,0.67717,0.95276,0.67717,0.96063,0.67717,0.9685,0.67717,0.97638,0.67717,0.98425,0.67717,0.99213,0.67717,0.99609,0.67717,0.00391,0.68504,0.00787,0.68504,0.01575,0.68504,0.02362,0.68504,0.0315,0.68504,0.03937,0.68504,0.04724,0.68504,0.05512,0.68504,0.06299,0.68504,0.07087,0.68504,0.07874,0.68504,0.08661,0.68504,0.09449,0.68504,0.10236,0.68504,0.11024,0.68504,0.11811,0.68504,0.12598,0.68504,0.13386,0.68504,0.14173,0.68504,0.14961,0.68504,0.15748,0.68504,0.16535,0.68504,0.17323,0.68504,0.1811,0.68504,0.18898,0.68504,0.19685,0.68504,0.20472,0.68504,0.2126,0.68504,0.22047,0.68504,0.22835,0.68504,0.23622,0.68504,0.24409,0.68504,0.25197,0.68504,0.25984,0.68504,0.26772,0.68504,0.27559,0.68504,0.28346,0.68504,0.29134,0.68504,0.29921,0.68504,0.30709,0.68504,0.31496,0.68504,0.32283,0.68504,0.33071,0.68504,0.33858,0.68504,0.34646,0.68504,0.35433,0.68504,0.3622,0.68504,0.37008,0.68504,0.37795,0.68504,0.38583,0.68504,0.3937,0.68504,0.40157,0.68504,0.40945,0.68504,0.41732,0.68504,0.4252,0.68504,0.43307,0.68504,0.44094,0.68504,0.44882,0.68504,0.45669,0.68504,0.46457,0.68504,0.47244,0.68504,0.48031,0.68504,0.48819,0.68504,0.49606,0.68504};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_113()
		{
			double[] value = {0.50394,0.68504,0.51181,0.68504,0.51969,0.68504,0.52756,0.68504,0.53543,0.68504,0.54331,0.68504,0.55118,0.68504,0.55906,0.68504,0.56693,0.68504,0.5748,0.68504,0.58268,0.68504,0.59055,0.68504,0.59843,0.68504,0.6063,0.68504,0.61417,0.68504,0.62205,0.68504,0.62992,0.68504,0.6378,0.68504,0.64567,0.68504,0.65354,0.68504,0.66142,0.68504,0.66929,0.68504,0.67717,0.68504,0.68504,0.68504,0.69291,0.68504,0.70079,0.68504,0.70866,0.68504,0.71654,0.68504,0.72441,0.68504,0.73228,0.68504,0.74016,0.68504,0.74803,0.68504,0.75591,0.68504,0.76378,0.68504,0.77165,0.68504,0.77953,0.68504,0.7874,0.68504,0.79528,0.68504,0.80315,0.68504,0.81102,0.68504,0.8189,0.68504,0.82677,0.68504,0.83465,0.68504,0.84252,0.68504,0.85039,0.68504,0.85827,0.68504,0.86614,0.68504,0.87402,0.68504,0.88189,0.68504,0.88976,0.68504,0.89764,0.68504,0.90551,0.68504,0.91339,0.68504,0.92126,0.68504,0.92913,0.68504,0.93701,0.68504,0.94488,0.68504,0.95276,0.68504,0.96063,0.68504,0.9685,0.68504,0.97638,0.68504,0.98425,0.68504,0.99213,0.68504,0.99609,0.68504,0.00391,0.69291,0.00787,0.69291,0.01575,0.69291,0.02362,0.69291,0.0315,0.69291,0.03937,0.69291,0.04724,0.69291,0.05512,0.69291,0.06299,0.69291,0.07087,0.69291,0.07874,0.69291,0.08661,0.69291,0.09449,0.69291,0.10236,0.69291,0.11024,0.69291,0.11811,0.69291,0.12598,0.69291,0.13386,0.69291,0.14173,0.69291,0.14961,0.69291,0.15748,0.69291,0.16535,0.69291,0.17323,0.69291,0.1811,0.69291,0.18898,0.69291,0.19685,0.69291,0.20472,0.69291,0.2126,0.69291,0.22047,0.69291,0.22835,0.69291,0.23622,0.69291,0.24409,0.69291,0.25197,0.69291,0.25984,0.69291,0.26772,0.69291,0.27559,0.69291};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_114()
		{
			double[] value = {0.28346,0.69291,0.29134,0.69291,0.29921,0.69291,0.30709,0.69291,0.31496,0.69291,0.32283,0.69291,0.33071,0.69291,0.33858,0.69291,0.34646,0.69291,0.35433,0.69291,0.3622,0.69291,0.37008,0.69291,0.37795,0.69291,0.38583,0.69291,0.3937,0.69291,0.40157,0.69291,0.40945,0.69291,0.41732,0.69291,0.4252,0.69291,0.43307,0.69291,0.44094,0.69291,0.44882,0.69291,0.45669,0.69291,0.46457,0.69291,0.47244,0.69291,0.48031,0.69291,0.48819,0.69291,0.49606,0.69291,0.50394,0.69291,0.51181,0.69291,0.51969,0.69291,0.52756,0.69291,0.53543,0.69291,0.54331,0.69291,0.55118,0.69291,0.55906,0.69291,0.56693,0.69291,0.5748,0.69291,0.58268,0.69291,0.59055,0.69291,0.59843,0.69291,0.6063,0.69291,0.61417,0.69291,0.62205,0.69291,0.62992,0.69291,0.6378,0.69291,0.64567,0.69291,0.65354,0.69291,0.66142,0.69291,0.66929,0.69291,0.67717,0.69291,0.68504,0.69291,0.69291,0.69291,0.70079,0.69291,0.70866,0.69291,0.71654,0.69291,0.72441,0.69291,0.73228,0.69291,0.74016,0.69291,0.74803,0.69291,0.75591,0.69291,0.76378,0.69291,0.77165,0.69291,0.77953,0.69291,0.7874,0.69291,0.79528,0.69291,0.80315,0.69291,0.81102,0.69291,0.8189,0.69291,0.82677,0.69291,0.83465,0.69291,0.84252,0.69291,0.85039,0.69291,0.85827,0.69291,0.86614,0.69291,0.87402,0.69291,0.88189,0.69291,0.88976,0.69291,0.89764,0.69291,0.90551,0.69291,0.91339,0.69291,0.92126,0.69291,0.92913,0.69291,0.93701,0.69291,0.94488,0.69291,0.95276,0.69291,0.96063,0.69291,0.9685,0.69291,0.97638,0.69291,0.98425,0.69291,0.99213,0.69291,0.99609,0.69291,0.00391,0.70079,0.00787,0.70079,0.01575,0.70079,0.02362,0.70079,0.0315,0.70079,0.03937,0.70079,0.04724,0.70079,0.05512,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_115()
		{
			double[] value = {0.06299,0.70079,0.07087,0.70079,0.07874,0.70079,0.08661,0.70079,0.09449,0.70079,0.10236,0.70079,0.11024,0.70079,0.11811,0.70079,0.12598,0.70079,0.13386,0.70079,0.14173,0.70079,0.14961,0.70079,0.15748,0.70079,0.16535,0.70079,0.17323,0.70079,0.1811,0.70079,0.18898,0.70079,0.19685,0.70079,0.20472,0.70079,0.2126,0.70079,0.22047,0.70079,0.22835,0.70079,0.23622,0.70079,0.24409,0.70079,0.25197,0.70079,0.25984,0.70079,0.26772,0.70079,0.27559,0.70079,0.28346,0.70079,0.29134,0.70079,0.29921,0.70079,0.30709,0.70079,0.31496,0.70079,0.32283,0.70079,0.33071,0.70079,0.33858,0.70079,0.34646,0.70079,0.35433,0.70079,0.3622,0.70079,0.37008,0.70079,0.37795,0.70079,0.38583,0.70079,0.3937,0.70079,0.40157,0.70079,0.40945,0.70079,0.41732,0.70079,0.4252,0.70079,0.43307,0.70079,0.44094,0.70079,0.44882,0.70079,0.45669,0.70079,0.46457,0.70079,0.47244,0.70079,0.48031,0.70079,0.48819,0.70079,0.49606,0.70079,0.50394,0.70079,0.51181,0.70079,0.51969,0.70079,0.52756,0.70079,0.53543,0.70079,0.54331,0.70079,0.55118,0.70079,0.55906,0.70079,0.56693,0.70079,0.5748,0.70079,0.58268,0.70079,0.59055,0.70079,0.59843,0.70079,0.6063,0.70079,0.61417,0.70079,0.62205,0.70079,0.62992,0.70079,0.6378,0.70079,0.64567,0.70079,0.65354,0.70079,0.66142,0.70079,0.66929,0.70079,0.67717,0.70079,0.68504,0.70079,0.69291,0.70079,0.70079,0.70079,0.70866,0.70079,0.71654,0.70079,0.72441,0.70079,0.73228,0.70079,0.74016,0.70079,0.74803,0.70079,0.75591,0.70079,0.76378,0.70079,0.77165,0.70079,0.77953,0.70079,0.7874,0.70079,0.79528,0.70079,0.80315,0.70079,0.81102,0.70079,0.8189,0.70079,0.82677,0.70079,0.83465,0.70079,0.84252,0.70079};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_116()
		{
			double[] value = {0.85039,0.70079,0.85827,0.70079,0.86614,0.70079,0.87402,0.70079,0.88189,0.70079,0.88976,0.70079,0.89764,0.70079,0.90551,0.70079,0.91339,0.70079,0.92126,0.70079,0.92913,0.70079,0.93701,0.70079,0.94488,0.70079,0.95276,0.70079,0.96063,0.70079,0.9685,0.70079,0.97638,0.70079,0.98425,0.70079,0.99213,0.70079,0.99609,0.70079,0.00391,0.70866,0.00787,0.70866,0.01575,0.70866,0.02362,0.70866,0.0315,0.70866,0.03937,0.70866,0.04724,0.70866,0.05512,0.70866,0.06299,0.70866,0.07087,0.70866,0.07874,0.70866,0.08661,0.70866,0.09449,0.70866,0.10236,0.70866,0.11024,0.70866,0.11811,0.70866,0.12598,0.70866,0.13386,0.70866,0.14173,0.70866,0.14961,0.70866,0.15748,0.70866,0.16535,0.70866,0.17323,0.70866,0.1811,0.70866,0.18898,0.70866,0.19685,0.70866,0.20472,0.70866,0.2126,0.70866,0.22047,0.70866,0.22835,0.70866,0.23622,0.70866,0.24409,0.70866,0.25197,0.70866,0.25984,0.70866,0.26772,0.70866,0.27559,0.70866,0.28346,0.70866,0.29134,0.70866,0.29921,0.70866,0.30709,0.70866,0.31496,0.70866,0.32283,0.70866,0.33071,0.70866,0.33858,0.70866,0.34646,0.70866,0.35433,0.70866,0.3622,0.70866,0.37008,0.70866,0.37795,0.70866,0.38583,0.70866,0.3937,0.70866,0.40157,0.70866,0.40945,0.70866,0.41732,0.70866,0.4252,0.70866,0.43307,0.70866,0.44094,0.70866,0.44882,0.70866,0.45669,0.70866,0.46457,0.70866,0.47244,0.70866,0.48031,0.70866,0.48819,0.70866,0.49606,0.70866,0.50394,0.70866,0.51181,0.70866,0.51969,0.70866,0.52756,0.70866,0.53543,0.70866,0.54331,0.70866,0.55118,0.70866,0.55906,0.70866,0.56693,0.70866,0.5748,0.70866,0.58268,0.70866,0.59055,0.70866,0.59843,0.70866,0.6063,0.70866,0.61417,0.70866,0.62205,0.70866};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_117()
		{
			double[] value = {0.62992,0.70866,0.6378,0.70866,0.64567,0.70866,0.65354,0.70866,0.66142,0.70866,0.66929,0.70866,0.67717,0.70866,0.68504,0.70866,0.69291,0.70866,0.70079,0.70866,0.70866,0.70866,0.71654,0.70866,0.72441,0.70866,0.73228,0.70866,0.74016,0.70866,0.74803,0.70866,0.75591,0.70866,0.76378,0.70866,0.77165,0.70866,0.77953,0.70866,0.7874,0.70866,0.79528,0.70866,0.80315,0.70866,0.81102,0.70866,0.8189,0.70866,0.82677,0.70866,0.83465,0.70866,0.84252,0.70866,0.85039,0.70866,0.85827,0.70866,0.86614,0.70866,0.87402,0.70866,0.88189,0.70866,0.88976,0.70866,0.89764,0.70866,0.90551,0.70866,0.91339,0.70866,0.92126,0.70866,0.92913,0.70866,0.93701,0.70866,0.94488,0.70866,0.95276,0.70866,0.96063,0.70866,0.9685,0.70866,0.97638,0.70866,0.98425,0.70866,0.99213,0.70866,0.99609,0.70866,0.00391,0.71654,0.00787,0.71654,0.01575,0.71654,0.02362,0.71654,0.0315,0.71654,0.03937,0.71654,0.04724,0.71654,0.05512,0.71654,0.06299,0.71654,0.07087,0.71654,0.07874,0.71654,0.08661,0.71654,0.09449,0.71654,0.10236,0.71654,0.11024,0.71654,0.11811,0.71654,0.12598,0.71654,0.13386,0.71654,0.14173,0.71654,0.14961,0.71654,0.15748,0.71654,0.16535,0.71654,0.17323,0.71654,0.1811,0.71654,0.18898,0.71654,0.19685,0.71654,0.20472,0.71654,0.2126,0.71654,0.22047,0.71654,0.22835,0.71654,0.23622,0.71654,0.24409,0.71654,0.25197,0.71654,0.25984,0.71654,0.26772,0.71654,0.27559,0.71654,0.28346,0.71654,0.29134,0.71654,0.29921,0.71654,0.30709,0.71654,0.31496,0.71654,0.32283,0.71654,0.33071,0.71654,0.33858,0.71654,0.34646,0.71654,0.35433,0.71654,0.3622,0.71654,0.37008,0.71654,0.37795,0.71654,0.38583,0.71654,0.3937,0.71654,0.40157,0.71654};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_118()
		{
			double[] value = {0.40945,0.71654,0.41732,0.71654,0.4252,0.71654,0.43307,0.71654,0.44094,0.71654,0.44882,0.71654,0.45669,0.71654,0.46457,0.71654,0.47244,0.71654,0.48031,0.71654,0.48819,0.71654,0.49606,0.71654,0.50394,0.71654,0.51181,0.71654,0.51969,0.71654,0.52756,0.71654,0.53543,0.71654,0.54331,0.71654,0.55118,0.71654,0.55906,0.71654,0.56693,0.71654,0.5748,0.71654,0.58268,0.71654,0.59055,0.71654,0.59843,0.71654,0.6063,0.71654,0.61417,0.71654,0.62205,0.71654,0.62992,0.71654,0.6378,0.71654,0.64567,0.71654,0.65354,0.71654,0.66142,0.71654,0.66929,0.71654,0.67717,0.71654,0.68504,0.71654,0.69291,0.71654,0.70079,0.71654,0.70866,0.71654,0.71654,0.71654,0.72441,0.71654,0.73228,0.71654,0.74016,0.71654,0.74803,0.71654,0.75591,0.71654,0.76378,0.71654,0.77165,0.71654,0.77953,0.71654,0.7874,0.71654,0.79528,0.71654,0.80315,0.71654,0.81102,0.71654,0.8189,0.71654,0.82677,0.71654,0.83465,0.71654,0.84252,0.71654,0.85039,0.71654,0.85827,0.71654,0.86614,0.71654,0.87402,0.71654,0.88189,0.71654,0.88976,0.71654,0.89764,0.71654,0.90551,0.71654,0.91339,0.71654,0.92126,0.71654,0.92913,0.71654,0.93701,0.71654,0.94488,0.71654,0.95276,0.71654,0.96063,0.71654,0.9685,0.71654,0.97638,0.71654,0.98425,0.71654,0.99213,0.71654,0.99609,0.71654,0.00391,0.72441,0.00787,0.72441,0.01575,0.72441,0.02362,0.72441,0.0315,0.72441,0.03937,0.72441,0.04724,0.72441,0.05512,0.72441,0.06299,0.72441,0.07087,0.72441,0.07874,0.72441,0.08661,0.72441,0.09449,0.72441,0.10236,0.72441,0.11024,0.72441,0.11811,0.72441,0.12598,0.72441,0.13386,0.72441,0.14173,0.72441,0.14961,0.72441,0.15748,0.72441,0.16535,0.72441,0.17323,0.72441,0.1811,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_119()
		{
			double[] value = {0.18898,0.72441,0.19685,0.72441,0.20472,0.72441,0.2126,0.72441,0.22047,0.72441,0.22835,0.72441,0.23622,0.72441,0.24409,0.72441,0.25197,0.72441,0.25984,0.72441,0.26772,0.72441,0.27559,0.72441,0.28346,0.72441,0.29134,0.72441,0.29921,0.72441,0.30709,0.72441,0.31496,0.72441,0.32283,0.72441,0.33071,0.72441,0.33858,0.72441,0.34646,0.72441,0.35433,0.72441,0.3622,0.72441,0.37008,0.72441,0.37795,0.72441,0.38583,0.72441,0.3937,0.72441,0.40157,0.72441,0.40945,0.72441,0.41732,0.72441,0.4252,0.72441,0.43307,0.72441,0.44094,0.72441,0.44882,0.72441,0.45669,0.72441,0.46457,0.72441,0.47244,0.72441,0.48031,0.72441,0.48819,0.72441,0.49606,0.72441,0.50394,0.72441,0.51181,0.72441,0.51969,0.72441,0.52756,0.72441,0.53543,0.72441,0.54331,0.72441,0.55118,0.72441,0.55906,0.72441,0.56693,0.72441,0.5748,0.72441,0.58268,0.72441,0.59055,0.72441,0.59843,0.72441,0.6063,0.72441,0.61417,0.72441,0.62205,0.72441,0.62992,0.72441,0.6378,0.72441,0.64567,0.72441,0.65354,0.72441,0.66142,0.72441,0.66929,0.72441,0.67717,0.72441,0.68504,0.72441,0.69291,0.72441,0.70079,0.72441,0.70866,0.72441,0.71654,0.72441,0.72441,0.72441,0.73228,0.72441,0.74016,0.72441,0.74803,0.72441,0.75591,0.72441,0.76378,0.72441,0.77165,0.72441,0.77953,0.72441,0.7874,0.72441,0.79528,0.72441,0.80315,0.72441,0.81102,0.72441,0.8189,0.72441,0.82677,0.72441,0.83465,0.72441,0.84252,0.72441,0.85039,0.72441,0.85827,0.72441,0.86614,0.72441,0.87402,0.72441,0.88189,0.72441,0.88976,0.72441,0.89764,0.72441,0.90551,0.72441,0.91339,0.72441,0.92126,0.72441,0.92913,0.72441,0.93701,0.72441,0.94488,0.72441,0.95276,0.72441,0.96063,0.72441,0.9685,0.72441};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_120()
		{
			double[] value = {0.97638,0.72441,0.98425,0.72441,0.99213,0.72441,0.99609,0.72441,0.00391,0.73228,0.00787,0.73228,0.01575,0.73228,0.02362,0.73228,0.0315,0.73228,0.03937,0.73228,0.04724,0.73228,0.05512,0.73228,0.06299,0.73228,0.07087,0.73228,0.07874,0.73228,0.08661,0.73228,0.09449,0.73228,0.10236,0.73228,0.11024,0.73228,0.11811,0.73228,0.12598,0.73228,0.13386,0.73228,0.14173,0.73228,0.14961,0.73228,0.15748,0.73228,0.16535,0.73228,0.17323,0.73228,0.1811,0.73228,0.18898,0.73228,0.19685,0.73228,0.20472,0.73228,0.2126,0.73228,0.22047,0.73228,0.22835,0.73228,0.23622,0.73228,0.24409,0.73228,0.25197,0.73228,0.25984,0.73228,0.26772,0.73228,0.27559,0.73228,0.28346,0.73228,0.29134,0.73228,0.29921,0.73228,0.30709,0.73228,0.31496,0.73228,0.32283,0.73228,0.33071,0.73228,0.33858,0.73228,0.34646,0.73228,0.35433,0.73228,0.3622,0.73228,0.37008,0.73228,0.37795,0.73228,0.38583,0.73228,0.3937,0.73228,0.40157,0.73228,0.40945,0.73228,0.41732,0.73228,0.4252,0.73228,0.43307,0.73228,0.44094,0.73228,0.44882,0.73228,0.45669,0.73228,0.46457,0.73228,0.47244,0.73228,0.48031,0.73228,0.48819,0.73228,0.49606,0.73228,0.50394,0.73228,0.51181,0.73228,0.51969,0.73228,0.52756,0.73228,0.53543,0.73228,0.54331,0.73228,0.55118,0.73228,0.55906,0.73228,0.56693,0.73228,0.5748,0.73228,0.58268,0.73228,0.59055,0.73228,0.59843,0.73228,0.6063,0.73228,0.61417,0.73228,0.62205,0.73228,0.62992,0.73228,0.6378,0.73228,0.64567,0.73228,0.65354,0.73228,0.66142,0.73228,0.66929,0.73228,0.67717,0.73228,0.68504,0.73228,0.69291,0.73228,0.70079,0.73228,0.70866,0.73228,0.71654,0.73228,0.72441,0.73228,0.73228,0.73228,0.74016,0.73228,0.74803,0.73228};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_121()
		{
			double[] value = {0.75591,0.73228,0.76378,0.73228,0.77165,0.73228,0.77953,0.73228,0.7874,0.73228,0.79528,0.73228,0.80315,0.73228,0.81102,0.73228,0.8189,0.73228,0.82677,0.73228,0.83465,0.73228,0.84252,0.73228,0.85039,0.73228,0.85827,0.73228,0.86614,0.73228,0.87402,0.73228,0.88189,0.73228,0.88976,0.73228,0.89764,0.73228,0.90551,0.73228,0.91339,0.73228,0.92126,0.73228,0.92913,0.73228,0.93701,0.73228,0.94488,0.73228,0.95276,0.73228,0.96063,0.73228,0.9685,0.73228,0.97638,0.73228,0.98425,0.73228,0.99213,0.73228,0.99609,0.73228,0.00391,0.74016,0.00787,0.74016,0.01575,0.74016,0.02362,0.74016,0.0315,0.74016,0.03937,0.74016,0.04724,0.74016,0.05512,0.74016,0.06299,0.74016,0.07087,0.74016,0.07874,0.74016,0.08661,0.74016,0.09449,0.74016,0.10236,0.74016,0.11024,0.74016,0.11811,0.74016,0.12598,0.74016,0.13386,0.74016,0.14173,0.74016,0.14961,0.74016,0.15748,0.74016,0.16535,0.74016,0.17323,0.74016,0.1811,0.74016,0.18898,0.74016,0.19685,0.74016,0.20472,0.74016,0.2126,0.74016,0.22047,0.74016,0.22835,0.74016,0.23622,0.74016,0.24409,0.74016,0.25197,0.74016,0.25984,0.74016,0.26772,0.74016,0.27559,0.74016,0.28346,0.74016,0.29134,0.74016,0.29921,0.74016,0.30709,0.74016,0.31496,0.74016,0.32283,0.74016,0.33071,0.74016,0.33858,0.74016,0.34646,0.74016,0.35433,0.74016,0.3622,0.74016,0.37008,0.74016,0.37795,0.74016,0.38583,0.74016,0.3937,0.74016,0.40157,0.74016,0.40945,0.74016,0.41732,0.74016,0.4252,0.74016,0.43307,0.74016,0.44094,0.74016,0.44882,0.74016,0.45669,0.74016,0.46457,0.74016,0.47244,0.74016,0.48031,0.74016,0.48819,0.74016,0.49606,0.74016,0.50394,0.74016,0.51181,0.74016,0.51969,0.74016,0.52756,0.74016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_122()
		{
			double[] value = {0.53543,0.74016,0.54331,0.74016,0.55118,0.74016,0.55906,0.74016,0.56693,0.74016,0.5748,0.74016,0.58268,0.74016,0.59055,0.74016,0.59843,0.74016,0.6063,0.74016,0.61417,0.74016,0.62205,0.74016,0.62992,0.74016,0.6378,0.74016,0.64567,0.74016,0.65354,0.74016,0.66142,0.74016,0.66929,0.74016,0.67717,0.74016,0.68504,0.74016,0.69291,0.74016,0.70079,0.74016,0.70866,0.74016,0.71654,0.74016,0.72441,0.74016,0.73228,0.74016,0.74016,0.74016,0.74803,0.74016,0.75591,0.74016,0.76378,0.74016,0.77165,0.74016,0.77953,0.74016,0.7874,0.74016,0.79528,0.74016,0.80315,0.74016,0.81102,0.74016,0.8189,0.74016,0.82677,0.74016,0.83465,0.74016,0.84252,0.74016,0.85039,0.74016,0.85827,0.74016,0.86614,0.74016,0.87402,0.74016,0.88189,0.74016,0.88976,0.74016,0.89764,0.74016,0.90551,0.74016,0.91339,0.74016,0.92126,0.74016,0.92913,0.74016,0.93701,0.74016,0.94488,0.74016,0.95276,0.74016,0.96063,0.74016,0.9685,0.74016,0.97638,0.74016,0.98425,0.74016,0.99213,0.74016,0.99609,0.74016,0.00391,0.74803,0.00787,0.74803,0.01575,0.74803,0.02362,0.74803,0.0315,0.74803,0.03937,0.74803,0.04724,0.74803,0.05512,0.74803,0.06299,0.74803,0.07087,0.74803,0.07874,0.74803,0.08661,0.74803,0.09449,0.74803,0.10236,0.74803,0.11024,0.74803,0.11811,0.74803,0.12598,0.74803,0.13386,0.74803,0.14173,0.74803,0.14961,0.74803,0.15748,0.74803,0.16535,0.74803,0.17323,0.74803,0.1811,0.74803,0.18898,0.74803,0.19685,0.74803,0.20472,0.74803,0.2126,0.74803,0.22047,0.74803,0.22835,0.74803,0.23622,0.74803,0.24409,0.74803,0.25197,0.74803,0.25984,0.74803,0.26772,0.74803,0.27559,0.74803,0.28346,0.74803,0.29134,0.74803,0.29921,0.74803,0.30709,0.74803};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_123()
		{
			double[] value = {0.31496,0.74803,0.32283,0.74803,0.33071,0.74803,0.33858,0.74803,0.34646,0.74803,0.35433,0.74803,0.3622,0.74803,0.37008,0.74803,0.37795,0.74803,0.38583,0.74803,0.3937,0.74803,0.40157,0.74803,0.40945,0.74803,0.41732,0.74803,0.4252,0.74803,0.43307,0.74803,0.44094,0.74803,0.44882,0.74803,0.45669,0.74803,0.46457,0.74803,0.47244,0.74803,0.48031,0.74803,0.48819,0.74803,0.49606,0.74803,0.50394,0.74803,0.51181,0.74803,0.51969,0.74803,0.52756,0.74803,0.53543,0.74803,0.54331,0.74803,0.55118,0.74803,0.55906,0.74803,0.56693,0.74803,0.5748,0.74803,0.58268,0.74803,0.59055,0.74803,0.59843,0.74803,0.6063,0.74803,0.61417,0.74803,0.62205,0.74803,0.62992,0.74803,0.6378,0.74803,0.64567,0.74803,0.65354,0.74803,0.66142,0.74803,0.66929,0.74803,0.67717,0.74803,0.68504,0.74803,0.69291,0.74803,0.70079,0.74803,0.70866,0.74803,0.71654,0.74803,0.72441,0.74803,0.73228,0.74803,0.74016,0.74803,0.74803,0.74803,0.75591,0.74803,0.76378,0.74803,0.77165,0.74803,0.77953,0.74803,0.7874,0.74803,0.79528,0.74803,0.80315,0.74803,0.81102,0.74803,0.8189,0.74803,0.82677,0.74803,0.83465,0.74803,0.84252,0.74803,0.85039,0.74803,0.85827,0.74803,0.86614,0.74803,0.87402,0.74803,0.88189,0.74803,0.88976,0.74803,0.89764,0.74803,0.90551,0.74803,0.91339,0.74803,0.92126,0.74803,0.92913,0.74803,0.93701,0.74803,0.94488,0.74803,0.95276,0.74803,0.96063,0.74803,0.9685,0.74803,0.97638,0.74803,0.98425,0.74803,0.99213,0.74803,0.99609,0.74803,0.00391,0.75591,0.00787,0.75591,0.01575,0.75591,0.02362,0.75591,0.0315,0.75591,0.03937,0.75591,0.04724,0.75591,0.05512,0.75591,0.06299,0.75591,0.07087,0.75591,0.07874,0.75591,0.08661,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_124()
		{
			double[] value = {0.09449,0.75591,0.10236,0.75591,0.11024,0.75591,0.11811,0.75591,0.12598,0.75591,0.13386,0.75591,0.14173,0.75591,0.14961,0.75591,0.15748,0.75591,0.16535,0.75591,0.17323,0.75591,0.1811,0.75591,0.18898,0.75591,0.19685,0.75591,0.20472,0.75591,0.2126,0.75591,0.22047,0.75591,0.22835,0.75591,0.23622,0.75591,0.24409,0.75591,0.25197,0.75591,0.25984,0.75591,0.26772,0.75591,0.27559,0.75591,0.28346,0.75591,0.29134,0.75591,0.29921,0.75591,0.30709,0.75591,0.31496,0.75591,0.32283,0.75591,0.33071,0.75591,0.33858,0.75591,0.34646,0.75591,0.35433,0.75591,0.3622,0.75591,0.37008,0.75591,0.37795,0.75591,0.38583,0.75591,0.3937,0.75591,0.40157,0.75591,0.40945,0.75591,0.41732,0.75591,0.4252,0.75591,0.43307,0.75591,0.44094,0.75591,0.44882,0.75591,0.45669,0.75591,0.46457,0.75591,0.47244,0.75591,0.48031,0.75591,0.48819,0.75591,0.49606,0.75591,0.50394,0.75591,0.51181,0.75591,0.51969,0.75591,0.52756,0.75591,0.53543,0.75591,0.54331,0.75591,0.55118,0.75591,0.55906,0.75591,0.56693,0.75591,0.5748,0.75591,0.58268,0.75591,0.59055,0.75591,0.59843,0.75591,0.6063,0.75591,0.61417,0.75591,0.62205,0.75591,0.62992,0.75591,0.6378,0.75591,0.64567,0.75591,0.65354,0.75591,0.66142,0.75591,0.66929,0.75591,0.67717,0.75591,0.68504,0.75591,0.69291,0.75591,0.70079,0.75591,0.70866,0.75591,0.71654,0.75591,0.72441,0.75591,0.73228,0.75591,0.74016,0.75591,0.74803,0.75591,0.75591,0.75591,0.76378,0.75591,0.77165,0.75591,0.77953,0.75591,0.7874,0.75591,0.79528,0.75591,0.80315,0.75591,0.81102,0.75591,0.8189,0.75591,0.82677,0.75591,0.83465,0.75591,0.84252,0.75591,0.85039,0.75591,0.85827,0.75591,0.86614,0.75591,0.87402,0.75591};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_125()
		{
			double[] value = {0.88189,0.75591,0.88976,0.75591,0.89764,0.75591,0.90551,0.75591,0.91339,0.75591,0.92126,0.75591,0.92913,0.75591,0.93701,0.75591,0.94488,0.75591,0.95276,0.75591,0.96063,0.75591,0.9685,0.75591,0.97638,0.75591,0.98425,0.75591,0.99213,0.75591,0.99609,0.75591,0.00391,0.76378,0.00787,0.76378,0.01575,0.76378,0.02362,0.76378,0.0315,0.76378,0.03937,0.76378,0.04724,0.76378,0.05512,0.76378,0.06299,0.76378,0.07087,0.76378,0.07874,0.76378,0.08661,0.76378,0.09449,0.76378,0.10236,0.76378,0.11024,0.76378,0.11811,0.76378,0.12598,0.76378,0.13386,0.76378,0.14173,0.76378,0.14961,0.76378,0.15748,0.76378,0.16535,0.76378,0.17323,0.76378,0.1811,0.76378,0.18898,0.76378,0.19685,0.76378,0.20472,0.76378,0.2126,0.76378,0.22047,0.76378,0.22835,0.76378,0.23622,0.76378,0.24409,0.76378,0.25197,0.76378,0.25984,0.76378,0.26772,0.76378,0.27559,0.76378,0.28346,0.76378,0.29134,0.76378,0.29921,0.76378,0.30709,0.76378,0.31496,0.76378,0.32283,0.76378,0.33071,0.76378,0.33858,0.76378,0.34646,0.76378,0.35433,0.76378,0.3622,0.76378,0.37008,0.76378,0.37795,0.76378,0.38583,0.76378,0.3937,0.76378,0.40157,0.76378,0.40945,0.76378,0.41732,0.76378,0.4252,0.76378,0.43307,0.76378,0.44094,0.76378,0.44882,0.76378,0.45669,0.76378,0.46457,0.76378,0.47244,0.76378,0.48031,0.76378,0.48819,0.76378,0.49606,0.76378,0.50394,0.76378,0.51181,0.76378,0.51969,0.76378,0.52756,0.76378,0.53543,0.76378,0.54331,0.76378,0.55118,0.76378,0.55906,0.76378,0.56693,0.76378,0.5748,0.76378,0.58268,0.76378,0.59055,0.76378,0.59843,0.76378,0.6063,0.76378,0.61417,0.76378,0.62205,0.76378,0.62992,0.76378,0.6378,0.76378,0.64567,0.76378,0.65354,0.76378};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_126()
		{
			double[] value = {0.66142,0.76378,0.66929,0.76378,0.67717,0.76378,0.68504,0.76378,0.69291,0.76378,0.70079,0.76378,0.70866,0.76378,0.71654,0.76378,0.72441,0.76378,0.73228,0.76378,0.74016,0.76378,0.74803,0.76378,0.75591,0.76378,0.76378,0.76378,0.77165,0.76378,0.77953,0.76378,0.7874,0.76378,0.79528,0.76378,0.80315,0.76378,0.81102,0.76378,0.8189,0.76378,0.82677,0.76378,0.83465,0.76378,0.84252,0.76378,0.85039,0.76378,0.85827,0.76378,0.86614,0.76378,0.87402,0.76378,0.88189,0.76378,0.88976,0.76378,0.89764,0.76378,0.90551,0.76378,0.91339,0.76378,0.92126,0.76378,0.92913,0.76378,0.93701,0.76378,0.94488,0.76378,0.95276,0.76378,0.96063,0.76378,0.9685,0.76378,0.97638,0.76378,0.98425,0.76378,0.99213,0.76378,0.99609,0.76378,0.00391,0.77165,0.00787,0.77165,0.01575,0.77165,0.02362,0.77165,0.0315,0.77165,0.03937,0.77165,0.04724,0.77165,0.05512,0.77165,0.06299,0.77165,0.07087,0.77165,0.07874,0.77165,0.08661,0.77165,0.09449,0.77165,0.10236,0.77165,0.11024,0.77165,0.11811,0.77165,0.12598,0.77165,0.13386,0.77165,0.14173,0.77165,0.14961,0.77165,0.15748,0.77165,0.16535,0.77165,0.17323,0.77165,0.1811,0.77165,0.18898,0.77165,0.19685,0.77165,0.20472,0.77165,0.2126,0.77165,0.22047,0.77165,0.22835,0.77165,0.23622,0.77165,0.24409,0.77165,0.25197,0.77165,0.25984,0.77165,0.26772,0.77165,0.27559,0.77165,0.28346,0.77165,0.29134,0.77165,0.29921,0.77165,0.30709,0.77165,0.31496,0.77165,0.32283,0.77165,0.33071,0.77165,0.33858,0.77165,0.34646,0.77165,0.35433,0.77165,0.3622,0.77165,0.37008,0.77165,0.37795,0.77165,0.38583,0.77165,0.3937,0.77165,0.40157,0.77165,0.40945,0.77165,0.41732,0.77165,0.4252,0.77165,0.43307,0.77165};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_127()
		{
			double[] value = {0.44094,0.77165,0.44882,0.77165,0.45669,0.77165,0.46457,0.77165,0.47244,0.77165,0.48031,0.77165,0.48819,0.77165,0.49606,0.77165,0.50394,0.77165,0.51181,0.77165,0.51969,0.77165,0.52756,0.77165,0.53543,0.77165,0.54331,0.77165,0.55118,0.77165,0.55906,0.77165,0.56693,0.77165,0.5748,0.77165,0.58268,0.77165,0.59055,0.77165,0.59843,0.77165,0.6063,0.77165,0.61417,0.77165,0.62205,0.77165,0.62992,0.77165,0.6378,0.77165,0.64567,0.77165,0.65354,0.77165,0.66142,0.77165,0.66929,0.77165,0.67717,0.77165,0.68504,0.77165,0.69291,0.77165,0.70079,0.77165,0.70866,0.77165,0.71654,0.77165,0.72441,0.77165,0.73228,0.77165,0.74016,0.77165,0.74803,0.77165,0.75591,0.77165,0.76378,0.77165,0.77165,0.77165,0.77953,0.77165,0.7874,0.77165,0.79528,0.77165,0.80315,0.77165,0.81102,0.77165,0.8189,0.77165,0.82677,0.77165,0.83465,0.77165,0.84252,0.77165,0.85039,0.77165,0.85827,0.77165,0.86614,0.77165,0.87402,0.77165,0.88189,0.77165,0.88976,0.77165,0.89764,0.77165,0.90551,0.77165,0.91339,0.77165,0.92126,0.77165,0.92913,0.77165,0.93701,0.77165,0.94488,0.77165,0.95276,0.77165,0.96063,0.77165,0.9685,0.77165,0.97638,0.77165,0.98425,0.77165,0.99213,0.77165,0.99609,0.77165,0.00391,0.77953,0.00787,0.77953,0.01575,0.77953,0.02362,0.77953,0.0315,0.77953,0.03937,0.77953,0.04724,0.77953,0.05512,0.77953,0.06299,0.77953,0.07087,0.77953,0.07874,0.77953,0.08661,0.77953,0.09449,0.77953,0.10236,0.77953,0.11024,0.77953,0.11811,0.77953,0.12598,0.77953,0.13386,0.77953,0.14173,0.77953,0.14961,0.77953,0.15748,0.77953,0.16535,0.77953,0.17323,0.77953,0.1811,0.77953,0.18898,0.77953,0.19685,0.77953,0.20472,0.77953,0.2126,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_128()
		{
			double[] value = {0.22047,0.77953,0.22835,0.77953,0.23622,0.77953,0.24409,0.77953,0.25197,0.77953,0.25984,0.77953,0.26772,0.77953,0.27559,0.77953,0.28346,0.77953,0.29134,0.77953,0.29921,0.77953,0.30709,0.77953,0.31496,0.77953,0.32283,0.77953,0.33071,0.77953,0.33858,0.77953,0.34646,0.77953,0.35433,0.77953,0.3622,0.77953,0.37008,0.77953,0.37795,0.77953,0.38583,0.77953,0.3937,0.77953,0.40157,0.77953,0.40945,0.77953,0.41732,0.77953,0.4252,0.77953,0.43307,0.77953,0.44094,0.77953,0.44882,0.77953,0.45669,0.77953,0.46457,0.77953,0.47244,0.77953,0.48031,0.77953,0.48819,0.77953,0.49606,0.77953,0.50394,0.77953,0.51181,0.77953,0.51969,0.77953,0.52756,0.77953,0.53543,0.77953,0.54331,0.77953,0.55118,0.77953,0.55906,0.77953,0.56693,0.77953,0.5748,0.77953,0.58268,0.77953,0.59055,0.77953,0.59843,0.77953,0.6063,0.77953,0.61417,0.77953,0.62205,0.77953,0.62992,0.77953,0.6378,0.77953,0.64567,0.77953,0.65354,0.77953,0.66142,0.77953,0.66929,0.77953,0.67717,0.77953,0.68504,0.77953,0.69291,0.77953,0.70079,0.77953,0.70866,0.77953,0.71654,0.77953,0.72441,0.77953,0.73228,0.77953,0.74016,0.77953,0.74803,0.77953,0.75591,0.77953,0.76378,0.77953,0.77165,0.77953,0.77953,0.77953,0.7874,0.77953,0.79528,0.77953,0.80315,0.77953,0.81102,0.77953,0.8189,0.77953,0.82677,0.77953,0.83465,0.77953,0.84252,0.77953,0.85039,0.77953,0.85827,0.77953,0.86614,0.77953,0.87402,0.77953,0.88189,0.77953,0.88976,0.77953,0.89764,0.77953,0.90551,0.77953,0.91339,0.77953,0.92126,0.77953,0.92913,0.77953,0.93701,0.77953,0.94488,0.77953,0.95276,0.77953,0.96063,0.77953,0.9685,0.77953,0.97638,0.77953,0.98425,0.77953,0.99213,0.77953,0.99609,0.77953};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_129()
		{
			double[] value = {0.00391,0.7874,0.00787,0.7874,0.01575,0.7874,0.02362,0.7874,0.0315,0.7874,0.03937,0.7874,0.04724,0.7874,0.05512,0.7874,0.06299,0.7874,0.07087,0.7874,0.07874,0.7874,0.08661,0.7874,0.09449,0.7874,0.10236,0.7874,0.11024,0.7874,0.11811,0.7874,0.12598,0.7874,0.13386,0.7874,0.14173,0.7874,0.14961,0.7874,0.15748,0.7874,0.16535,0.7874,0.17323,0.7874,0.1811,0.7874,0.18898,0.7874,0.19685,0.7874,0.20472,0.7874,0.2126,0.7874,0.22047,0.7874,0.22835,0.7874,0.23622,0.7874,0.24409,0.7874,0.25197,0.7874,0.25984,0.7874,0.26772,0.7874,0.27559,0.7874,0.28346,0.7874,0.29134,0.7874,0.29921,0.7874,0.30709,0.7874,0.31496,0.7874,0.32283,0.7874,0.33071,0.7874,0.33858,0.7874,0.34646,0.7874,0.35433,0.7874,0.3622,0.7874,0.37008,0.7874,0.37795,0.7874,0.38583,0.7874,0.3937,0.7874,0.40157,0.7874,0.40945,0.7874,0.41732,0.7874,0.4252,0.7874,0.43307,0.7874,0.44094,0.7874,0.44882,0.7874,0.45669,0.7874,0.46457,0.7874,0.47244,0.7874,0.48031,0.7874,0.48819,0.7874,0.49606,0.7874,0.50394,0.7874,0.51181,0.7874,0.51969,0.7874,0.52756,0.7874,0.53543,0.7874,0.54331,0.7874,0.55118,0.7874,0.55906,0.7874,0.56693,0.7874,0.5748,0.7874,0.58268,0.7874,0.59055,0.7874,0.59843,0.7874,0.6063,0.7874,0.61417,0.7874,0.62205,0.7874,0.62992,0.7874,0.6378,0.7874,0.64567,0.7874,0.65354,0.7874,0.66142,0.7874,0.66929,0.7874,0.67717,0.7874,0.68504,0.7874,0.69291,0.7874,0.70079,0.7874,0.70866,0.7874,0.71654,0.7874,0.72441,0.7874,0.73228,0.7874,0.74016,0.7874,0.74803,0.7874,0.75591,0.7874,0.76378,0.7874,0.77165,0.7874,0.77953,0.7874};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_130()
		{
			double[] value = {0.7874,0.7874,0.79528,0.7874,0.80315,0.7874,0.81102,0.7874,0.8189,0.7874,0.82677,0.7874,0.83465,0.7874,0.84252,0.7874,0.85039,0.7874,0.85827,0.7874,0.86614,0.7874,0.87402,0.7874,0.88189,0.7874,0.88976,0.7874,0.89764,0.7874,0.90551,0.7874,0.91339,0.7874,0.92126,0.7874,0.92913,0.7874,0.93701,0.7874,0.94488,0.7874,0.95276,0.7874,0.96063,0.7874,0.9685,0.7874,0.97638,0.7874,0.98425,0.7874,0.99213,0.7874,0.99609,0.7874,0.00391,0.79528,0.00787,0.79528,0.01575,0.79528,0.02362,0.79528,0.0315,0.79528,0.03937,0.79528,0.04724,0.79528,0.05512,0.79528,0.06299,0.79528,0.07087,0.79528,0.07874,0.79528,0.08661,0.79528,0.09449,0.79528,0.10236,0.79528,0.11024,0.79528,0.11811,0.79528,0.12598,0.79528,0.13386,0.79528,0.14173,0.79528,0.14961,0.79528,0.15748,0.79528,0.16535,0.79528,0.17323,0.79528,0.1811,0.79528,0.18898,0.79528,0.19685,0.79528,0.20472,0.79528,0.2126,0.79528,0.22047,0.79528,0.22835,0.79528,0.23622,0.79528,0.24409,0.79528,0.25197,0.79528,0.25984,0.79528,0.26772,0.79528,0.27559,0.79528,0.28346,0.79528,0.29134,0.79528,0.29921,0.79528,0.30709,0.79528,0.31496,0.79528,0.32283,0.79528,0.33071,0.79528,0.33858,0.79528,0.34646,0.79528,0.35433,0.79528,0.3622,0.79528,0.37008,0.79528,0.37795,0.79528,0.38583,0.79528,0.3937,0.79528,0.40157,0.79528,0.40945,0.79528,0.41732,0.79528,0.4252,0.79528,0.43307,0.79528,0.44094,0.79528,0.44882,0.79528,0.45669,0.79528,0.46457,0.79528,0.47244,0.79528,0.48031,0.79528,0.48819,0.79528,0.49606,0.79528,0.50394,0.79528,0.51181,0.79528,0.51969,0.79528,0.52756,0.79528,0.53543,0.79528,0.54331,0.79528,0.55118,0.79528,0.55906,0.79528};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_131()
		{
			double[] value = {0.56693,0.79528,0.5748,0.79528,0.58268,0.79528,0.59055,0.79528,0.59843,0.79528,0.6063,0.79528,0.61417,0.79528,0.62205,0.79528,0.62992,0.79528,0.6378,0.79528,0.64567,0.79528,0.65354,0.79528,0.66142,0.79528,0.66929,0.79528,0.67717,0.79528,0.68504,0.79528,0.69291,0.79528,0.70079,0.79528,0.70866,0.79528,0.71654,0.79528,0.72441,0.79528,0.73228,0.79528,0.74016,0.79528,0.74803,0.79528,0.75591,0.79528,0.76378,0.79528,0.77165,0.79528,0.77953,0.79528,0.7874,0.79528,0.79528,0.79528,0.80315,0.79528,0.81102,0.79528,0.8189,0.79528,0.82677,0.79528,0.83465,0.79528,0.84252,0.79528,0.85039,0.79528,0.85827,0.79528,0.86614,0.79528,0.87402,0.79528,0.88189,0.79528,0.88976,0.79528,0.89764,0.79528,0.90551,0.79528,0.91339,0.79528,0.92126,0.79528,0.92913,0.79528,0.93701,0.79528,0.94488,0.79528,0.95276,0.79528,0.96063,0.79528,0.9685,0.79528,0.97638,0.79528,0.98425,0.79528,0.99213,0.79528,0.99609,0.79528,0.00391,0.80315,0.00787,0.80315,0.01575,0.80315,0.02362,0.80315,0.0315,0.80315,0.03937,0.80315,0.04724,0.80315,0.05512,0.80315,0.06299,0.80315,0.07087,0.80315,0.07874,0.80315,0.08661,0.80315,0.09449,0.80315,0.10236,0.80315,0.11024,0.80315,0.11811,0.80315,0.12598,0.80315,0.13386,0.80315,0.14173,0.80315,0.14961,0.80315,0.15748,0.80315,0.16535,0.80315,0.17323,0.80315,0.1811,0.80315,0.18898,0.80315,0.19685,0.80315,0.20472,0.80315,0.2126,0.80315,0.22047,0.80315,0.22835,0.80315,0.23622,0.80315,0.24409,0.80315,0.25197,0.80315,0.25984,0.80315,0.26772,0.80315,0.27559,0.80315,0.28346,0.80315,0.29134,0.80315,0.29921,0.80315,0.30709,0.80315,0.31496,0.80315,0.32283,0.80315,0.33071,0.80315,0.33858,0.80315};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_132()
		{
			double[] value = {0.34646,0.80315,0.35433,0.80315,0.3622,0.80315,0.37008,0.80315,0.37795,0.80315,0.38583,0.80315,0.3937,0.80315,0.40157,0.80315,0.40945,0.80315,0.41732,0.80315,0.4252,0.80315,0.43307,0.80315,0.44094,0.80315,0.44882,0.80315,0.45669,0.80315,0.46457,0.80315,0.47244,0.80315,0.48031,0.80315,0.48819,0.80315,0.49606,0.80315,0.50394,0.80315,0.51181,0.80315,0.51969,0.80315,0.52756,0.80315,0.53543,0.80315,0.54331,0.80315,0.55118,0.80315,0.55906,0.80315,0.56693,0.80315,0.5748,0.80315,0.58268,0.80315,0.59055,0.80315,0.59843,0.80315,0.6063,0.80315,0.61417,0.80315,0.62205,0.80315,0.62992,0.80315,0.6378,0.80315,0.64567,0.80315,0.65354,0.80315,0.66142,0.80315,0.66929,0.80315,0.67717,0.80315,0.68504,0.80315,0.69291,0.80315,0.70079,0.80315,0.70866,0.80315,0.71654,0.80315,0.72441,0.80315,0.73228,0.80315,0.74016,0.80315,0.74803,0.80315,0.75591,0.80315,0.76378,0.80315,0.77165,0.80315,0.77953,0.80315,0.7874,0.80315,0.79528,0.80315,0.80315,0.80315,0.81102,0.80315,0.8189,0.80315,0.82677,0.80315,0.83465,0.80315,0.84252,0.80315,0.85039,0.80315,0.85827,0.80315,0.86614,0.80315,0.87402,0.80315,0.88189,0.80315,0.88976,0.80315,0.89764,0.80315,0.90551,0.80315,0.91339,0.80315,0.92126,0.80315,0.92913,0.80315,0.93701,0.80315,0.94488,0.80315,0.95276,0.80315,0.96063,0.80315,0.9685,0.80315,0.97638,0.80315,0.98425,0.80315,0.99213,0.80315,0.99609,0.80315,0.00391,0.81102,0.00787,0.81102,0.01575,0.81102,0.02362,0.81102,0.0315,0.81102,0.03937,0.81102,0.04724,0.81102,0.05512,0.81102,0.06299,0.81102,0.07087,0.81102,0.07874,0.81102,0.08661,0.81102,0.09449,0.81102,0.10236,0.81102,0.11024,0.81102,0.11811,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_133()
		{
			double[] value = {0.12598,0.81102,0.13386,0.81102,0.14173,0.81102,0.14961,0.81102,0.15748,0.81102,0.16535,0.81102,0.17323,0.81102,0.1811,0.81102,0.18898,0.81102,0.19685,0.81102,0.20472,0.81102,0.2126,0.81102,0.22047,0.81102,0.22835,0.81102,0.23622,0.81102,0.24409,0.81102,0.25197,0.81102,0.25984,0.81102,0.26772,0.81102,0.27559,0.81102,0.28346,0.81102,0.29134,0.81102,0.29921,0.81102,0.30709,0.81102,0.31496,0.81102,0.32283,0.81102,0.33071,0.81102,0.33858,0.81102,0.34646,0.81102,0.35433,0.81102,0.3622,0.81102,0.37008,0.81102,0.37795,0.81102,0.38583,0.81102,0.3937,0.81102,0.40157,0.81102,0.40945,0.81102,0.41732,0.81102,0.4252,0.81102,0.43307,0.81102,0.44094,0.81102,0.44882,0.81102,0.45669,0.81102,0.46457,0.81102,0.47244,0.81102,0.48031,0.81102,0.48819,0.81102,0.49606,0.81102,0.50394,0.81102,0.51181,0.81102,0.51969,0.81102,0.52756,0.81102,0.53543,0.81102,0.54331,0.81102,0.55118,0.81102,0.55906,0.81102,0.56693,0.81102,0.5748,0.81102,0.58268,0.81102,0.59055,0.81102,0.59843,0.81102,0.6063,0.81102,0.61417,0.81102,0.62205,0.81102,0.62992,0.81102,0.6378,0.81102,0.64567,0.81102,0.65354,0.81102,0.66142,0.81102,0.66929,0.81102,0.67717,0.81102,0.68504,0.81102,0.69291,0.81102,0.70079,0.81102,0.70866,0.81102,0.71654,0.81102,0.72441,0.81102,0.73228,0.81102,0.74016,0.81102,0.74803,0.81102,0.75591,0.81102,0.76378,0.81102,0.77165,0.81102,0.77953,0.81102,0.7874,0.81102,0.79528,0.81102,0.80315,0.81102,0.81102,0.81102,0.8189,0.81102,0.82677,0.81102,0.83465,0.81102,0.84252,0.81102,0.85039,0.81102,0.85827,0.81102,0.86614,0.81102,0.87402,0.81102,0.88189,0.81102,0.88976,0.81102,0.89764,0.81102,0.90551,0.81102};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_134()
		{
			double[] value = {0.91339,0.81102,0.92126,0.81102,0.92913,0.81102,0.93701,0.81102,0.94488,0.81102,0.95276,0.81102,0.96063,0.81102,0.9685,0.81102,0.97638,0.81102,0.98425,0.81102,0.99213,0.81102,0.99609,0.81102,0.00391,0.8189,0.00787,0.8189,0.01575,0.8189,0.02362,0.8189,0.0315,0.8189,0.03937,0.8189,0.04724,0.8189,0.05512,0.8189,0.06299,0.8189,0.07087,0.8189,0.07874,0.8189,0.08661,0.8189,0.09449,0.8189,0.10236,0.8189,0.11024,0.8189,0.11811,0.8189,0.12598,0.8189,0.13386,0.8189,0.14173,0.8189,0.14961,0.8189,0.15748,0.8189,0.16535,0.8189,0.17323,0.8189,0.1811,0.8189,0.18898,0.8189,0.19685,0.8189,0.20472,0.8189,0.2126,0.8189,0.22047,0.8189,0.22835,0.8189,0.23622,0.8189,0.24409,0.8189,0.25197,0.8189,0.25984,0.8189,0.26772,0.8189,0.27559,0.8189,0.28346,0.8189,0.29134,0.8189,0.29921,0.8189,0.30709,0.8189,0.31496,0.8189,0.32283,0.8189,0.33071,0.8189,0.33858,0.8189,0.34646,0.8189,0.35433,0.8189,0.3622,0.8189,0.37008,0.8189,0.37795,0.8189,0.38583,0.8189,0.3937,0.8189,0.40157,0.8189,0.40945,0.8189,0.41732,0.8189,0.4252,0.8189,0.43307,0.8189,0.44094,0.8189,0.44882,0.8189,0.45669,0.8189,0.46457,0.8189,0.47244,0.8189,0.48031,0.8189,0.48819,0.8189,0.49606,0.8189,0.50394,0.8189,0.51181,0.8189,0.51969,0.8189,0.52756,0.8189,0.53543,0.8189,0.54331,0.8189,0.55118,0.8189,0.55906,0.8189,0.56693,0.8189,0.5748,0.8189,0.58268,0.8189,0.59055,0.8189,0.59843,0.8189,0.6063,0.8189,0.61417,0.8189,0.62205,0.8189,0.62992,0.8189,0.6378,0.8189,0.64567,0.8189,0.65354,0.8189,0.66142,0.8189,0.66929,0.8189,0.67717,0.8189,0.68504,0.8189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_135()
		{
			double[] value = {0.69291,0.8189,0.70079,0.8189,0.70866,0.8189,0.71654,0.8189,0.72441,0.8189,0.73228,0.8189,0.74016,0.8189,0.74803,0.8189,0.75591,0.8189,0.76378,0.8189,0.77165,0.8189,0.77953,0.8189,0.7874,0.8189,0.79528,0.8189,0.80315,0.8189,0.81102,0.8189,0.8189,0.8189,0.82677,0.8189,0.83465,0.8189,0.84252,0.8189,0.85039,0.8189,0.85827,0.8189,0.86614,0.8189,0.87402,0.8189,0.88189,0.8189,0.88976,0.8189,0.89764,0.8189,0.90551,0.8189,0.91339,0.8189,0.92126,0.8189,0.92913,0.8189,0.93701,0.8189,0.94488,0.8189,0.95276,0.8189,0.96063,0.8189,0.9685,0.8189,0.97638,0.8189,0.98425,0.8189,0.99213,0.8189,0.99609,0.8189,0.00391,0.82677,0.00787,0.82677,0.01575,0.82677,0.02362,0.82677,0.0315,0.82677,0.03937,0.82677,0.04724,0.82677,0.05512,0.82677,0.06299,0.82677,0.07087,0.82677,0.07874,0.82677,0.08661,0.82677,0.09449,0.82677,0.10236,0.82677,0.11024,0.82677,0.11811,0.82677,0.12598,0.82677,0.13386,0.82677,0.14173,0.82677,0.14961,0.82677,0.15748,0.82677,0.16535,0.82677,0.17323,0.82677,0.1811,0.82677,0.18898,0.82677,0.19685,0.82677,0.20472,0.82677,0.2126,0.82677,0.22047,0.82677,0.22835,0.82677,0.23622,0.82677,0.24409,0.82677,0.25197,0.82677,0.25984,0.82677,0.26772,0.82677,0.27559,0.82677,0.28346,0.82677,0.29134,0.82677,0.29921,0.82677,0.30709,0.82677,0.31496,0.82677,0.32283,0.82677,0.33071,0.82677,0.33858,0.82677,0.34646,0.82677,0.35433,0.82677,0.3622,0.82677,0.37008,0.82677,0.37795,0.82677,0.38583,0.82677,0.3937,0.82677,0.40157,0.82677,0.40945,0.82677,0.41732,0.82677,0.4252,0.82677,0.43307,0.82677,0.44094,0.82677,0.44882,0.82677,0.45669,0.82677,0.46457,0.82677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_136()
		{
			double[] value = {0.47244,0.82677,0.48031,0.82677,0.48819,0.82677,0.49606,0.82677,0.50394,0.82677,0.51181,0.82677,0.51969,0.82677,0.52756,0.82677,0.53543,0.82677,0.54331,0.82677,0.55118,0.82677,0.55906,0.82677,0.56693,0.82677,0.5748,0.82677,0.58268,0.82677,0.59055,0.82677,0.59843,0.82677,0.6063,0.82677,0.61417,0.82677,0.62205,0.82677,0.62992,0.82677,0.6378,0.82677,0.64567,0.82677,0.65354,0.82677,0.66142,0.82677,0.66929,0.82677,0.67717,0.82677,0.68504,0.82677,0.69291,0.82677,0.70079,0.82677,0.70866,0.82677,0.71654,0.82677,0.72441,0.82677,0.73228,0.82677,0.74016,0.82677,0.74803,0.82677,0.75591,0.82677,0.76378,0.82677,0.77165,0.82677,0.77953,0.82677,0.7874,0.82677,0.79528,0.82677,0.80315,0.82677,0.81102,0.82677,0.8189,0.82677,0.82677,0.82677,0.83465,0.82677,0.84252,0.82677,0.85039,0.82677,0.85827,0.82677,0.86614,0.82677,0.87402,0.82677,0.88189,0.82677,0.88976,0.82677,0.89764,0.82677,0.90551,0.82677,0.91339,0.82677,0.92126,0.82677,0.92913,0.82677,0.93701,0.82677,0.94488,0.82677,0.95276,0.82677,0.96063,0.82677,0.9685,0.82677,0.97638,0.82677,0.98425,0.82677,0.99213,0.82677,0.99609,0.82677,0.00391,0.83465,0.00787,0.83465,0.01575,0.83465,0.02362,0.83465,0.0315,0.83465,0.03937,0.83465,0.04724,0.83465,0.05512,0.83465,0.06299,0.83465,0.07087,0.83465,0.07874,0.83465,0.08661,0.83465,0.09449,0.83465,0.10236,0.83465,0.11024,0.83465,0.11811,0.83465,0.12598,0.83465,0.13386,0.83465,0.14173,0.83465,0.14961,0.83465,0.15748,0.83465,0.16535,0.83465,0.17323,0.83465,0.1811,0.83465,0.18898,0.83465,0.19685,0.83465,0.20472,0.83465,0.2126,0.83465,0.22047,0.83465,0.22835,0.83465,0.23622,0.83465,0.24409,0.83465};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_137()
		{
			double[] value = {0.25197,0.83465,0.25984,0.83465,0.26772,0.83465,0.27559,0.83465,0.28346,0.83465,0.29134,0.83465,0.29921,0.83465,0.30709,0.83465,0.31496,0.83465,0.32283,0.83465,0.33071,0.83465,0.33858,0.83465,0.34646,0.83465,0.35433,0.83465,0.3622,0.83465,0.37008,0.83465,0.37795,0.83465,0.38583,0.83465,0.3937,0.83465,0.40157,0.83465,0.40945,0.83465,0.41732,0.83465,0.4252,0.83465,0.43307,0.83465,0.44094,0.83465,0.44882,0.83465,0.45669,0.83465,0.46457,0.83465,0.47244,0.83465,0.48031,0.83465,0.48819,0.83465,0.49606,0.83465,0.50394,0.83465,0.51181,0.83465,0.51969,0.83465,0.52756,0.83465,0.53543,0.83465,0.54331,0.83465,0.55118,0.83465,0.55906,0.83465,0.56693,0.83465,0.5748,0.83465,0.58268,0.83465,0.59055,0.83465,0.59843,0.83465,0.6063,0.83465,0.61417,0.83465,0.62205,0.83465,0.62992,0.83465,0.6378,0.83465,0.64567,0.83465,0.65354,0.83465,0.66142,0.83465,0.66929,0.83465,0.67717,0.83465,0.68504,0.83465,0.69291,0.83465,0.70079,0.83465,0.70866,0.83465,0.71654,0.83465,0.72441,0.83465,0.73228,0.83465,0.74016,0.83465,0.74803,0.83465,0.75591,0.83465,0.76378,0.83465,0.77165,0.83465,0.77953,0.83465,0.7874,0.83465,0.79528,0.83465,0.80315,0.83465,0.81102,0.83465,0.8189,0.83465,0.82677,0.83465,0.83465,0.83465,0.84252,0.83465,0.85039,0.83465,0.85827,0.83465,0.86614,0.83465,0.87402,0.83465,0.88189,0.83465,0.88976,0.83465,0.89764,0.83465,0.90551,0.83465,0.91339,0.83465,0.92126,0.83465,0.92913,0.83465,0.93701,0.83465,0.94488,0.83465,0.95276,0.83465,0.96063,0.83465,0.9685,0.83465,0.97638,0.83465,0.98425,0.83465,0.99213,0.83465,0.99609,0.83465,0.00391,0.84252,0.00787,0.84252,0.01575,0.84252,0.02362,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_138()
		{
			double[] value = {0.0315,0.84252,0.03937,0.84252,0.04724,0.84252,0.05512,0.84252,0.06299,0.84252,0.07087,0.84252,0.07874,0.84252,0.08661,0.84252,0.09449,0.84252,0.10236,0.84252,0.11024,0.84252,0.11811,0.84252,0.12598,0.84252,0.13386,0.84252,0.14173,0.84252,0.14961,0.84252,0.15748,0.84252,0.16535,0.84252,0.17323,0.84252,0.1811,0.84252,0.18898,0.84252,0.19685,0.84252,0.20472,0.84252,0.2126,0.84252,0.22047,0.84252,0.22835,0.84252,0.23622,0.84252,0.24409,0.84252,0.25197,0.84252,0.25984,0.84252,0.26772,0.84252,0.27559,0.84252,0.28346,0.84252,0.29134,0.84252,0.29921,0.84252,0.30709,0.84252,0.31496,0.84252,0.32283,0.84252,0.33071,0.84252,0.33858,0.84252,0.34646,0.84252,0.35433,0.84252,0.3622,0.84252,0.37008,0.84252,0.37795,0.84252,0.38583,0.84252,0.3937,0.84252,0.40157,0.84252,0.40945,0.84252,0.41732,0.84252,0.4252,0.84252,0.43307,0.84252,0.44094,0.84252,0.44882,0.84252,0.45669,0.84252,0.46457,0.84252,0.47244,0.84252,0.48031,0.84252,0.48819,0.84252,0.49606,0.84252,0.50394,0.84252,0.51181,0.84252,0.51969,0.84252,0.52756,0.84252,0.53543,0.84252,0.54331,0.84252,0.55118,0.84252,0.55906,0.84252,0.56693,0.84252,0.5748,0.84252,0.58268,0.84252,0.59055,0.84252,0.59843,0.84252,0.6063,0.84252,0.61417,0.84252,0.62205,0.84252,0.62992,0.84252,0.6378,0.84252,0.64567,0.84252,0.65354,0.84252,0.66142,0.84252,0.66929,0.84252,0.67717,0.84252,0.68504,0.84252,0.69291,0.84252,0.70079,0.84252,0.70866,0.84252,0.71654,0.84252,0.72441,0.84252,0.73228,0.84252,0.74016,0.84252,0.74803,0.84252,0.75591,0.84252,0.76378,0.84252,0.77165,0.84252,0.77953,0.84252,0.7874,0.84252,0.79528,0.84252,0.80315,0.84252,0.81102,0.84252};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_139()
		{
			double[] value = {0.8189,0.84252,0.82677,0.84252,0.83465,0.84252,0.84252,0.84252,0.85039,0.84252,0.85827,0.84252,0.86614,0.84252,0.87402,0.84252,0.88189,0.84252,0.88976,0.84252,0.89764,0.84252,0.90551,0.84252,0.91339,0.84252,0.92126,0.84252,0.92913,0.84252,0.93701,0.84252,0.94488,0.84252,0.95276,0.84252,0.96063,0.84252,0.9685,0.84252,0.97638,0.84252,0.98425,0.84252,0.99213,0.84252,0.99609,0.84252,0.00391,0.85039,0.00787,0.85039,0.01575,0.85039,0.02362,0.85039,0.0315,0.85039,0.03937,0.85039,0.04724,0.85039,0.05512,0.85039,0.06299,0.85039,0.07087,0.85039,0.07874,0.85039,0.08661,0.85039,0.09449,0.85039,0.10236,0.85039,0.11024,0.85039,0.11811,0.85039,0.12598,0.85039,0.13386,0.85039,0.14173,0.85039,0.14961,0.85039,0.15748,0.85039,0.16535,0.85039,0.17323,0.85039,0.1811,0.85039,0.18898,0.85039,0.19685,0.85039,0.20472,0.85039,0.2126,0.85039,0.22047,0.85039,0.22835,0.85039,0.23622,0.85039,0.24409,0.85039,0.25197,0.85039,0.25984,0.85039,0.26772,0.85039,0.27559,0.85039,0.28346,0.85039,0.29134,0.85039,0.29921,0.85039,0.30709,0.85039,0.31496,0.85039,0.32283,0.85039,0.33071,0.85039,0.33858,0.85039,0.34646,0.85039,0.35433,0.85039,0.3622,0.85039,0.37008,0.85039,0.37795,0.85039,0.38583,0.85039,0.3937,0.85039,0.40157,0.85039,0.40945,0.85039,0.41732,0.85039,0.4252,0.85039,0.43307,0.85039,0.44094,0.85039,0.44882,0.85039,0.45669,0.85039,0.46457,0.85039,0.47244,0.85039,0.48031,0.85039,0.48819,0.85039,0.49606,0.85039,0.50394,0.85039,0.51181,0.85039,0.51969,0.85039,0.52756,0.85039,0.53543,0.85039,0.54331,0.85039,0.55118,0.85039,0.55906,0.85039,0.56693,0.85039,0.5748,0.85039,0.58268,0.85039,0.59055,0.85039};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_140()
		{
			double[] value = {0.59843,0.85039,0.6063,0.85039,0.61417,0.85039,0.62205,0.85039,0.62992,0.85039,0.6378,0.85039,0.64567,0.85039,0.65354,0.85039,0.66142,0.85039,0.66929,0.85039,0.67717,0.85039,0.68504,0.85039,0.69291,0.85039,0.70079,0.85039,0.70866,0.85039,0.71654,0.85039,0.72441,0.85039,0.73228,0.85039,0.74016,0.85039,0.74803,0.85039,0.75591,0.85039,0.76378,0.85039,0.77165,0.85039,0.77953,0.85039,0.7874,0.85039,0.79528,0.85039,0.80315,0.85039,0.81102,0.85039,0.8189,0.85039,0.82677,0.85039,0.83465,0.85039,0.84252,0.85039,0.85039,0.85039,0.85827,0.85039,0.86614,0.85039,0.87402,0.85039,0.88189,0.85039,0.88976,0.85039,0.89764,0.85039,0.90551,0.85039,0.91339,0.85039,0.92126,0.85039,0.92913,0.85039,0.93701,0.85039,0.94488,0.85039,0.95276,0.85039,0.96063,0.85039,0.9685,0.85039,0.97638,0.85039,0.98425,0.85039,0.99213,0.85039,0.99609,0.85039,0.00391,0.85827,0.00787,0.85827,0.01575,0.85827,0.02362,0.85827,0.0315,0.85827,0.03937,0.85827,0.04724,0.85827,0.05512,0.85827,0.06299,0.85827,0.07087,0.85827,0.07874,0.85827,0.08661,0.85827,0.09449,0.85827,0.10236,0.85827,0.11024,0.85827,0.11811,0.85827,0.12598,0.85827,0.13386,0.85827,0.14173,0.85827,0.14961,0.85827,0.15748,0.85827,0.16535,0.85827,0.17323,0.85827,0.1811,0.85827,0.18898,0.85827,0.19685,0.85827,0.20472,0.85827,0.2126,0.85827,0.22047,0.85827,0.22835,0.85827,0.23622,0.85827,0.24409,0.85827,0.25197,0.85827,0.25984,0.85827,0.26772,0.85827,0.27559,0.85827,0.28346,0.85827,0.29134,0.85827,0.29921,0.85827,0.30709,0.85827,0.31496,0.85827,0.32283,0.85827,0.33071,0.85827,0.33858,0.85827,0.34646,0.85827,0.35433,0.85827,0.3622,0.85827,0.37008,0.85827};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_141()
		{
			double[] value = {0.37795,0.85827,0.38583,0.85827,0.3937,0.85827,0.40157,0.85827,0.40945,0.85827,0.41732,0.85827,0.4252,0.85827,0.43307,0.85827,0.44094,0.85827,0.44882,0.85827,0.45669,0.85827,0.46457,0.85827,0.47244,0.85827,0.48031,0.85827,0.48819,0.85827,0.49606,0.85827,0.50394,0.85827,0.51181,0.85827,0.51969,0.85827,0.52756,0.85827,0.53543,0.85827,0.54331,0.85827,0.55118,0.85827,0.55906,0.85827,0.56693,0.85827,0.5748,0.85827,0.58268,0.85827,0.59055,0.85827,0.59843,0.85827,0.6063,0.85827,0.61417,0.85827,0.62205,0.85827,0.62992,0.85827,0.6378,0.85827,0.64567,0.85827,0.65354,0.85827,0.66142,0.85827,0.66929,0.85827,0.67717,0.85827,0.68504,0.85827,0.69291,0.85827,0.70079,0.85827,0.70866,0.85827,0.71654,0.85827,0.72441,0.85827,0.73228,0.85827,0.74016,0.85827,0.74803,0.85827,0.75591,0.85827,0.76378,0.85827,0.77165,0.85827,0.77953,0.85827,0.7874,0.85827,0.79528,0.85827,0.80315,0.85827,0.81102,0.85827,0.8189,0.85827,0.82677,0.85827,0.83465,0.85827,0.84252,0.85827,0.85039,0.85827,0.85827,0.85827,0.86614,0.85827,0.87402,0.85827,0.88189,0.85827,0.88976,0.85827,0.89764,0.85827,0.90551,0.85827,0.91339,0.85827,0.92126,0.85827,0.92913,0.85827,0.93701,0.85827,0.94488,0.85827,0.95276,0.85827,0.96063,0.85827,0.9685,0.85827,0.97638,0.85827,0.98425,0.85827,0.99213,0.85827,0.99609,0.85827,0.00391,0.86614,0.00787,0.86614,0.01575,0.86614,0.02362,0.86614,0.0315,0.86614,0.03937,0.86614,0.04724,0.86614,0.05512,0.86614,0.06299,0.86614,0.07087,0.86614,0.07874,0.86614,0.08661,0.86614,0.09449,0.86614,0.10236,0.86614,0.11024,0.86614,0.11811,0.86614,0.12598,0.86614,0.13386,0.86614,0.14173,0.86614,0.14961,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_142()
		{
			double[] value = {0.15748,0.86614,0.16535,0.86614,0.17323,0.86614,0.1811,0.86614,0.18898,0.86614,0.19685,0.86614,0.20472,0.86614,0.2126,0.86614,0.22047,0.86614,0.22835,0.86614,0.23622,0.86614,0.24409,0.86614,0.25197,0.86614,0.25984,0.86614,0.26772,0.86614,0.27559,0.86614,0.28346,0.86614,0.29134,0.86614,0.29921,0.86614,0.30709,0.86614,0.31496,0.86614,0.32283,0.86614,0.33071,0.86614,0.33858,0.86614,0.34646,0.86614,0.35433,0.86614,0.3622,0.86614,0.37008,0.86614,0.37795,0.86614,0.38583,0.86614,0.3937,0.86614,0.40157,0.86614,0.40945,0.86614,0.41732,0.86614,0.4252,0.86614,0.43307,0.86614,0.44094,0.86614,0.44882,0.86614,0.45669,0.86614,0.46457,0.86614,0.47244,0.86614,0.48031,0.86614,0.48819,0.86614,0.49606,0.86614,0.50394,0.86614,0.51181,0.86614,0.51969,0.86614,0.52756,0.86614,0.53543,0.86614,0.54331,0.86614,0.55118,0.86614,0.55906,0.86614,0.56693,0.86614,0.5748,0.86614,0.58268,0.86614,0.59055,0.86614,0.59843,0.86614,0.6063,0.86614,0.61417,0.86614,0.62205,0.86614,0.62992,0.86614,0.6378,0.86614,0.64567,0.86614,0.65354,0.86614,0.66142,0.86614,0.66929,0.86614,0.67717,0.86614,0.68504,0.86614,0.69291,0.86614,0.70079,0.86614,0.70866,0.86614,0.71654,0.86614,0.72441,0.86614,0.73228,0.86614,0.74016,0.86614,0.74803,0.86614,0.75591,0.86614,0.76378,0.86614,0.77165,0.86614,0.77953,0.86614,0.7874,0.86614,0.79528,0.86614,0.80315,0.86614,0.81102,0.86614,0.8189,0.86614,0.82677,0.86614,0.83465,0.86614,0.84252,0.86614,0.85039,0.86614,0.85827,0.86614,0.86614,0.86614,0.87402,0.86614,0.88189,0.86614,0.88976,0.86614,0.89764,0.86614,0.90551,0.86614,0.91339,0.86614,0.92126,0.86614,0.92913,0.86614,0.93701,0.86614};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_143()
		{
			double[] value = {0.94488,0.86614,0.95276,0.86614,0.96063,0.86614,0.9685,0.86614,0.97638,0.86614,0.98425,0.86614,0.99213,0.86614,0.99609,0.86614,0.00391,0.87402,0.00787,0.87402,0.01575,0.87402,0.02362,0.87402,0.0315,0.87402,0.03937,0.87402,0.04724,0.87402,0.05512,0.87402,0.06299,0.87402,0.07087,0.87402,0.07874,0.87402,0.08661,0.87402,0.09449,0.87402,0.10236,0.87402,0.11024,0.87402,0.11811,0.87402,0.12598,0.87402,0.13386,0.87402,0.14173,0.87402,0.14961,0.87402,0.15748,0.87402,0.16535,0.87402,0.17323,0.87402,0.1811,0.87402,0.18898,0.87402,0.19685,0.87402,0.20472,0.87402,0.2126,0.87402,0.22047,0.87402,0.22835,0.87402,0.23622,0.87402,0.24409,0.87402,0.25197,0.87402,0.25984,0.87402,0.26772,0.87402,0.27559,0.87402,0.28346,0.87402,0.29134,0.87402,0.29921,0.87402,0.30709,0.87402,0.31496,0.87402,0.32283,0.87402,0.33071,0.87402,0.33858,0.87402,0.34646,0.87402,0.35433,0.87402,0.3622,0.87402,0.37008,0.87402,0.37795,0.87402,0.38583,0.87402,0.3937,0.87402,0.40157,0.87402,0.40945,0.87402,0.41732,0.87402,0.4252,0.87402,0.43307,0.87402,0.44094,0.87402,0.44882,0.87402,0.45669,0.87402,0.46457,0.87402,0.47244,0.87402,0.48031,0.87402,0.48819,0.87402,0.49606,0.87402,0.50394,0.87402,0.51181,0.87402,0.51969,0.87402,0.52756,0.87402,0.53543,0.87402,0.54331,0.87402,0.55118,0.87402,0.55906,0.87402,0.56693,0.87402,0.5748,0.87402,0.58268,0.87402,0.59055,0.87402,0.59843,0.87402,0.6063,0.87402,0.61417,0.87402,0.62205,0.87402,0.62992,0.87402,0.6378,0.87402,0.64567,0.87402,0.65354,0.87402,0.66142,0.87402,0.66929,0.87402,0.67717,0.87402,0.68504,0.87402,0.69291,0.87402,0.70079,0.87402,0.70866,0.87402,0.71654,0.87402};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_144()
		{
			double[] value = {0.72441,0.87402,0.73228,0.87402,0.74016,0.87402,0.74803,0.87402,0.75591,0.87402,0.76378,0.87402,0.77165,0.87402,0.77953,0.87402,0.7874,0.87402,0.79528,0.87402,0.80315,0.87402,0.81102,0.87402,0.8189,0.87402,0.82677,0.87402,0.83465,0.87402,0.84252,0.87402,0.85039,0.87402,0.85827,0.87402,0.86614,0.87402,0.87402,0.87402,0.88189,0.87402,0.88976,0.87402,0.89764,0.87402,0.90551,0.87402,0.91339,0.87402,0.92126,0.87402,0.92913,0.87402,0.93701,0.87402,0.94488,0.87402,0.95276,0.87402,0.96063,0.87402,0.9685,0.87402,0.97638,0.87402,0.98425,0.87402,0.99213,0.87402,0.99609,0.87402,0.00391,0.88189,0.00787,0.88189,0.01575,0.88189,0.02362,0.88189,0.0315,0.88189,0.03937,0.88189,0.04724,0.88189,0.05512,0.88189,0.06299,0.88189,0.07087,0.88189,0.07874,0.88189,0.08661,0.88189,0.09449,0.88189,0.10236,0.88189,0.11024,0.88189,0.11811,0.88189,0.12598,0.88189,0.13386,0.88189,0.14173,0.88189,0.14961,0.88189,0.15748,0.88189,0.16535,0.88189,0.17323,0.88189,0.1811,0.88189,0.18898,0.88189,0.19685,0.88189,0.20472,0.88189,0.2126,0.88189,0.22047,0.88189,0.22835,0.88189,0.23622,0.88189,0.24409,0.88189,0.25197,0.88189,0.25984,0.88189,0.26772,0.88189,0.27559,0.88189,0.28346,0.88189,0.29134,0.88189,0.29921,0.88189,0.30709,0.88189,0.31496,0.88189,0.32283,0.88189,0.33071,0.88189,0.33858,0.88189,0.34646,0.88189,0.35433,0.88189,0.3622,0.88189,0.37008,0.88189,0.37795,0.88189,0.38583,0.88189,0.3937,0.88189,0.40157,0.88189,0.40945,0.88189,0.41732,0.88189,0.4252,0.88189,0.43307,0.88189,0.44094,0.88189,0.44882,0.88189,0.45669,0.88189,0.46457,0.88189,0.47244,0.88189,0.48031,0.88189,0.48819,0.88189,0.49606,0.88189};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_145()
		{
			double[] value = {0.50394,0.88189,0.51181,0.88189,0.51969,0.88189,0.52756,0.88189,0.53543,0.88189,0.54331,0.88189,0.55118,0.88189,0.55906,0.88189,0.56693,0.88189,0.5748,0.88189,0.58268,0.88189,0.59055,0.88189,0.59843,0.88189,0.6063,0.88189,0.61417,0.88189,0.62205,0.88189,0.62992,0.88189,0.6378,0.88189,0.64567,0.88189,0.65354,0.88189,0.66142,0.88189,0.66929,0.88189,0.67717,0.88189,0.68504,0.88189,0.69291,0.88189,0.70079,0.88189,0.70866,0.88189,0.71654,0.88189,0.72441,0.88189,0.73228,0.88189,0.74016,0.88189,0.74803,0.88189,0.75591,0.88189,0.76378,0.88189,0.77165,0.88189,0.77953,0.88189,0.7874,0.88189,0.79528,0.88189,0.80315,0.88189,0.81102,0.88189,0.8189,0.88189,0.82677,0.88189,0.83465,0.88189,0.84252,0.88189,0.85039,0.88189,0.85827,0.88189,0.86614,0.88189,0.87402,0.88189,0.88189,0.88189,0.88976,0.88189,0.89764,0.88189,0.90551,0.88189,0.91339,0.88189,0.92126,0.88189,0.92913,0.88189,0.93701,0.88189,0.94488,0.88189,0.95276,0.88189,0.96063,0.88189,0.9685,0.88189,0.97638,0.88189,0.98425,0.88189,0.99213,0.88189,0.99609,0.88189,0.00391,0.88976,0.00787,0.88976,0.01575,0.88976,0.02362,0.88976,0.0315,0.88976,0.03937,0.88976,0.04724,0.88976,0.05512,0.88976,0.06299,0.88976,0.07087,0.88976,0.07874,0.88976,0.08661,0.88976,0.09449,0.88976,0.10236,0.88976,0.11024,0.88976,0.11811,0.88976,0.12598,0.88976,0.13386,0.88976,0.14173,0.88976,0.14961,0.88976,0.15748,0.88976,0.16535,0.88976,0.17323,0.88976,0.1811,0.88976,0.18898,0.88976,0.19685,0.88976,0.20472,0.88976,0.2126,0.88976,0.22047,0.88976,0.22835,0.88976,0.23622,0.88976,0.24409,0.88976,0.25197,0.88976,0.25984,0.88976,0.26772,0.88976,0.27559,0.88976};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_146()
		{
			double[] value = {0.28346,0.88976,0.29134,0.88976,0.29921,0.88976,0.30709,0.88976,0.31496,0.88976,0.32283,0.88976,0.33071,0.88976,0.33858,0.88976,0.34646,0.88976,0.35433,0.88976,0.3622,0.88976,0.37008,0.88976,0.37795,0.88976,0.38583,0.88976,0.3937,0.88976,0.40157,0.88976,0.40945,0.88976,0.41732,0.88976,0.4252,0.88976,0.43307,0.88976,0.44094,0.88976,0.44882,0.88976,0.45669,0.88976,0.46457,0.88976,0.47244,0.88976,0.48031,0.88976,0.48819,0.88976,0.49606,0.88976,0.50394,0.88976,0.51181,0.88976,0.51969,0.88976,0.52756,0.88976,0.53543,0.88976,0.54331,0.88976,0.55118,0.88976,0.55906,0.88976,0.56693,0.88976,0.5748,0.88976,0.58268,0.88976,0.59055,0.88976,0.59843,0.88976,0.6063,0.88976,0.61417,0.88976,0.62205,0.88976,0.62992,0.88976,0.6378,0.88976,0.64567,0.88976,0.65354,0.88976,0.66142,0.88976,0.66929,0.88976,0.67717,0.88976,0.68504,0.88976,0.69291,0.88976,0.70079,0.88976,0.70866,0.88976,0.71654,0.88976,0.72441,0.88976,0.73228,0.88976,0.74016,0.88976,0.74803,0.88976,0.75591,0.88976,0.76378,0.88976,0.77165,0.88976,0.77953,0.88976,0.7874,0.88976,0.79528,0.88976,0.80315,0.88976,0.81102,0.88976,0.8189,0.88976,0.82677,0.88976,0.83465,0.88976,0.84252,0.88976,0.85039,0.88976,0.85827,0.88976,0.86614,0.88976,0.87402,0.88976,0.88189,0.88976,0.88976,0.88976,0.89764,0.88976,0.90551,0.88976,0.91339,0.88976,0.92126,0.88976,0.92913,0.88976,0.93701,0.88976,0.94488,0.88976,0.95276,0.88976,0.96063,0.88976,0.9685,0.88976,0.97638,0.88976,0.98425,0.88976,0.99213,0.88976,0.99609,0.88976,0.00391,0.89764,0.00787,0.89764,0.01575,0.89764,0.02362,0.89764,0.0315,0.89764,0.03937,0.89764,0.04724,0.89764,0.05512,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_147()
		{
			double[] value = {0.06299,0.89764,0.07087,0.89764,0.07874,0.89764,0.08661,0.89764,0.09449,0.89764,0.10236,0.89764,0.11024,0.89764,0.11811,0.89764,0.12598,0.89764,0.13386,0.89764,0.14173,0.89764,0.14961,0.89764,0.15748,0.89764,0.16535,0.89764,0.17323,0.89764,0.1811,0.89764,0.18898,0.89764,0.19685,0.89764,0.20472,0.89764,0.2126,0.89764,0.22047,0.89764,0.22835,0.89764,0.23622,0.89764,0.24409,0.89764,0.25197,0.89764,0.25984,0.89764,0.26772,0.89764,0.27559,0.89764,0.28346,0.89764,0.29134,0.89764,0.29921,0.89764,0.30709,0.89764,0.31496,0.89764,0.32283,0.89764,0.33071,0.89764,0.33858,0.89764,0.34646,0.89764,0.35433,0.89764,0.3622,0.89764,0.37008,0.89764,0.37795,0.89764,0.38583,0.89764,0.3937,0.89764,0.40157,0.89764,0.40945,0.89764,0.41732,0.89764,0.4252,0.89764,0.43307,0.89764,0.44094,0.89764,0.44882,0.89764,0.45669,0.89764,0.46457,0.89764,0.47244,0.89764,0.48031,0.89764,0.48819,0.89764,0.49606,0.89764,0.50394,0.89764,0.51181,0.89764,0.51969,0.89764,0.52756,0.89764,0.53543,0.89764,0.54331,0.89764,0.55118,0.89764,0.55906,0.89764,0.56693,0.89764,0.5748,0.89764,0.58268,0.89764,0.59055,0.89764,0.59843,0.89764,0.6063,0.89764,0.61417,0.89764,0.62205,0.89764,0.62992,0.89764,0.6378,0.89764,0.64567,0.89764,0.65354,0.89764,0.66142,0.89764,0.66929,0.89764,0.67717,0.89764,0.68504,0.89764,0.69291,0.89764,0.70079,0.89764,0.70866,0.89764,0.71654,0.89764,0.72441,0.89764,0.73228,0.89764,0.74016,0.89764,0.74803,0.89764,0.75591,0.89764,0.76378,0.89764,0.77165,0.89764,0.77953,0.89764,0.7874,0.89764,0.79528,0.89764,0.80315,0.89764,0.81102,0.89764,0.8189,0.89764,0.82677,0.89764,0.83465,0.89764,0.84252,0.89764};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_148()
		{
			double[] value = {0.85039,0.89764,0.85827,0.89764,0.86614,0.89764,0.87402,0.89764,0.88189,0.89764,0.88976,0.89764,0.89764,0.89764,0.90551,0.89764,0.91339,0.89764,0.92126,0.89764,0.92913,0.89764,0.93701,0.89764,0.94488,0.89764,0.95276,0.89764,0.96063,0.89764,0.9685,0.89764,0.97638,0.89764,0.98425,0.89764,0.99213,0.89764,0.99609,0.89764,0.00391,0.90551,0.00787,0.90551,0.01575,0.90551,0.02362,0.90551,0.0315,0.90551,0.03937,0.90551,0.04724,0.90551,0.05512,0.90551,0.06299,0.90551,0.07087,0.90551,0.07874,0.90551,0.08661,0.90551,0.09449,0.90551,0.10236,0.90551,0.11024,0.90551,0.11811,0.90551,0.12598,0.90551,0.13386,0.90551,0.14173,0.90551,0.14961,0.90551,0.15748,0.90551,0.16535,0.90551,0.17323,0.90551,0.1811,0.90551,0.18898,0.90551,0.19685,0.90551,0.20472,0.90551,0.2126,0.90551,0.22047,0.90551,0.22835,0.90551,0.23622,0.90551,0.24409,0.90551,0.25197,0.90551,0.25984,0.90551,0.26772,0.90551,0.27559,0.90551,0.28346,0.90551,0.29134,0.90551,0.29921,0.90551,0.30709,0.90551,0.31496,0.90551,0.32283,0.90551,0.33071,0.90551,0.33858,0.90551,0.34646,0.90551,0.35433,0.90551,0.3622,0.90551,0.37008,0.90551,0.37795,0.90551,0.38583,0.90551,0.3937,0.90551,0.40157,0.90551,0.40945,0.90551,0.41732,0.90551,0.4252,0.90551,0.43307,0.90551,0.44094,0.90551,0.44882,0.90551,0.45669,0.90551,0.46457,0.90551,0.47244,0.90551,0.48031,0.90551,0.48819,0.90551,0.49606,0.90551,0.50394,0.90551,0.51181,0.90551,0.51969,0.90551,0.52756,0.90551,0.53543,0.90551,0.54331,0.90551,0.55118,0.90551,0.55906,0.90551,0.56693,0.90551,0.5748,0.90551,0.58268,0.90551,0.59055,0.90551,0.59843,0.90551,0.6063,0.90551,0.61417,0.90551,0.62205,0.90551};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_149()
		{
			double[] value = {0.62992,0.90551,0.6378,0.90551,0.64567,0.90551,0.65354,0.90551,0.66142,0.90551,0.66929,0.90551,0.67717,0.90551,0.68504,0.90551,0.69291,0.90551,0.70079,0.90551,0.70866,0.90551,0.71654,0.90551,0.72441,0.90551,0.73228,0.90551,0.74016,0.90551,0.74803,0.90551,0.75591,0.90551,0.76378,0.90551,0.77165,0.90551,0.77953,0.90551,0.7874,0.90551,0.79528,0.90551,0.80315,0.90551,0.81102,0.90551,0.8189,0.90551,0.82677,0.90551,0.83465,0.90551,0.84252,0.90551,0.85039,0.90551,0.85827,0.90551,0.86614,0.90551,0.87402,0.90551,0.88189,0.90551,0.88976,0.90551,0.89764,0.90551,0.90551,0.90551,0.91339,0.90551,0.92126,0.90551,0.92913,0.90551,0.93701,0.90551,0.94488,0.90551,0.95276,0.90551,0.96063,0.90551,0.9685,0.90551,0.97638,0.90551,0.98425,0.90551,0.99213,0.90551,0.99609,0.90551,0.00391,0.91339,0.00787,0.91339,0.01575,0.91339,0.02362,0.91339,0.0315,0.91339,0.03937,0.91339,0.04724,0.91339,0.05512,0.91339,0.06299,0.91339,0.07087,0.91339,0.07874,0.91339,0.08661,0.91339,0.09449,0.91339,0.10236,0.91339,0.11024,0.91339,0.11811,0.91339,0.12598,0.91339,0.13386,0.91339,0.14173,0.91339,0.14961,0.91339,0.15748,0.91339,0.16535,0.91339,0.17323,0.91339,0.1811,0.91339,0.18898,0.91339,0.19685,0.91339,0.20472,0.91339,0.2126,0.91339,0.22047,0.91339,0.22835,0.91339,0.23622,0.91339,0.24409,0.91339,0.25197,0.91339,0.25984,0.91339,0.26772,0.91339,0.27559,0.91339,0.28346,0.91339,0.29134,0.91339,0.29921,0.91339,0.30709,0.91339,0.31496,0.91339,0.32283,0.91339,0.33071,0.91339,0.33858,0.91339,0.34646,0.91339,0.35433,0.91339,0.3622,0.91339,0.37008,0.91339,0.37795,0.91339,0.38583,0.91339,0.3937,0.91339,0.40157,0.91339};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_150()
		{
			double[] value = {0.40945,0.91339,0.41732,0.91339,0.4252,0.91339,0.43307,0.91339,0.44094,0.91339,0.44882,0.91339,0.45669,0.91339,0.46457,0.91339,0.47244,0.91339,0.48031,0.91339,0.48819,0.91339,0.49606,0.91339,0.50394,0.91339,0.51181,0.91339,0.51969,0.91339,0.52756,0.91339,0.53543,0.91339,0.54331,0.91339,0.55118,0.91339,0.55906,0.91339,0.56693,0.91339,0.5748,0.91339,0.58268,0.91339,0.59055,0.91339,0.59843,0.91339,0.6063,0.91339,0.61417,0.91339,0.62205,0.91339,0.62992,0.91339,0.6378,0.91339,0.64567,0.91339,0.65354,0.91339,0.66142,0.91339,0.66929,0.91339,0.67717,0.91339,0.68504,0.91339,0.69291,0.91339,0.70079,0.91339,0.70866,0.91339,0.71654,0.91339,0.72441,0.91339,0.73228,0.91339,0.74016,0.91339,0.74803,0.91339,0.75591,0.91339,0.76378,0.91339,0.77165,0.91339,0.77953,0.91339,0.7874,0.91339,0.79528,0.91339,0.80315,0.91339,0.81102,0.91339,0.8189,0.91339,0.82677,0.91339,0.83465,0.91339,0.84252,0.91339,0.85039,0.91339,0.85827,0.91339,0.86614,0.91339,0.87402,0.91339,0.88189,0.91339,0.88976,0.91339,0.89764,0.91339,0.90551,0.91339,0.91339,0.91339,0.92126,0.91339,0.92913,0.91339,0.93701,0.91339,0.94488,0.91339,0.95276,0.91339,0.96063,0.91339,0.9685,0.91339,0.97638,0.91339,0.98425,0.91339,0.99213,0.91339,0.99609,0.91339,0.00391,0.92126,0.00787,0.92126,0.01575,0.92126,0.02362,0.92126,0.0315,0.92126,0.03937,0.92126,0.04724,0.92126,0.05512,0.92126,0.06299,0.92126,0.07087,0.92126,0.07874,0.92126,0.08661,0.92126,0.09449,0.92126,0.10236,0.92126,0.11024,0.92126,0.11811,0.92126,0.12598,0.92126,0.13386,0.92126,0.14173,0.92126,0.14961,0.92126,0.15748,0.92126,0.16535,0.92126,0.17323,0.92126,0.1811,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_151()
		{
			double[] value = {0.18898,0.92126,0.19685,0.92126,0.20472,0.92126,0.2126,0.92126,0.22047,0.92126,0.22835,0.92126,0.23622,0.92126,0.24409,0.92126,0.25197,0.92126,0.25984,0.92126,0.26772,0.92126,0.27559,0.92126,0.28346,0.92126,0.29134,0.92126,0.29921,0.92126,0.30709,0.92126,0.31496,0.92126,0.32283,0.92126,0.33071,0.92126,0.33858,0.92126,0.34646,0.92126,0.35433,0.92126,0.3622,0.92126,0.37008,0.92126,0.37795,0.92126,0.38583,0.92126,0.3937,0.92126,0.40157,0.92126,0.40945,0.92126,0.41732,0.92126,0.4252,0.92126,0.43307,0.92126,0.44094,0.92126,0.44882,0.92126,0.45669,0.92126,0.46457,0.92126,0.47244,0.92126,0.48031,0.92126,0.48819,0.92126,0.49606,0.92126,0.50394,0.92126,0.51181,0.92126,0.51969,0.92126,0.52756,0.92126,0.53543,0.92126,0.54331,0.92126,0.55118,0.92126,0.55906,0.92126,0.56693,0.92126,0.5748,0.92126,0.58268,0.92126,0.59055,0.92126,0.59843,0.92126,0.6063,0.92126,0.61417,0.92126,0.62205,0.92126,0.62992,0.92126,0.6378,0.92126,0.64567,0.92126,0.65354,0.92126,0.66142,0.92126,0.66929,0.92126,0.67717,0.92126,0.68504,0.92126,0.69291,0.92126,0.70079,0.92126,0.70866,0.92126,0.71654,0.92126,0.72441,0.92126,0.73228,0.92126,0.74016,0.92126,0.74803,0.92126,0.75591,0.92126,0.76378,0.92126,0.77165,0.92126,0.77953,0.92126,0.7874,0.92126,0.79528,0.92126,0.80315,0.92126,0.81102,0.92126,0.8189,0.92126,0.82677,0.92126,0.83465,0.92126,0.84252,0.92126,0.85039,0.92126,0.85827,0.92126,0.86614,0.92126,0.87402,0.92126,0.88189,0.92126,0.88976,0.92126,0.89764,0.92126,0.90551,0.92126,0.91339,0.92126,0.92126,0.92126,0.92913,0.92126,0.93701,0.92126,0.94488,0.92126,0.95276,0.92126,0.96063,0.92126,0.9685,0.92126};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_152()
		{
			double[] value = {0.97638,0.92126,0.98425,0.92126,0.99213,0.92126,0.99609,0.92126,0.00391,0.92913,0.00787,0.92913,0.01575,0.92913,0.02362,0.92913,0.0315,0.92913,0.03937,0.92913,0.04724,0.92913,0.05512,0.92913,0.06299,0.92913,0.07087,0.92913,0.07874,0.92913,0.08661,0.92913,0.09449,0.92913,0.10236,0.92913,0.11024,0.92913,0.11811,0.92913,0.12598,0.92913,0.13386,0.92913,0.14173,0.92913,0.14961,0.92913,0.15748,0.92913,0.16535,0.92913,0.17323,0.92913,0.1811,0.92913,0.18898,0.92913,0.19685,0.92913,0.20472,0.92913,0.2126,0.92913,0.22047,0.92913,0.22835,0.92913,0.23622,0.92913,0.24409,0.92913,0.25197,0.92913,0.25984,0.92913,0.26772,0.92913,0.27559,0.92913,0.28346,0.92913,0.29134,0.92913,0.29921,0.92913,0.30709,0.92913,0.31496,0.92913,0.32283,0.92913,0.33071,0.92913,0.33858,0.92913,0.34646,0.92913,0.35433,0.92913,0.3622,0.92913,0.37008,0.92913,0.37795,0.92913,0.38583,0.92913,0.3937,0.92913,0.40157,0.92913,0.40945,0.92913,0.41732,0.92913,0.4252,0.92913,0.43307,0.92913,0.44094,0.92913,0.44882,0.92913,0.45669,0.92913,0.46457,0.92913,0.47244,0.92913,0.48031,0.92913,0.48819,0.92913,0.49606,0.92913,0.50394,0.92913,0.51181,0.92913,0.51969,0.92913,0.52756,0.92913,0.53543,0.92913,0.54331,0.92913,0.55118,0.92913,0.55906,0.92913,0.56693,0.92913,0.5748,0.92913,0.58268,0.92913,0.59055,0.92913,0.59843,0.92913,0.6063,0.92913,0.61417,0.92913,0.62205,0.92913,0.62992,0.92913,0.6378,0.92913,0.64567,0.92913,0.65354,0.92913,0.66142,0.92913,0.66929,0.92913,0.67717,0.92913,0.68504,0.92913,0.69291,0.92913,0.70079,0.92913,0.70866,0.92913,0.71654,0.92913,0.72441,0.92913,0.73228,0.92913,0.74016,0.92913,0.74803,0.92913};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_153()
		{
			double[] value = {0.75591,0.92913,0.76378,0.92913,0.77165,0.92913,0.77953,0.92913,0.7874,0.92913,0.79528,0.92913,0.80315,0.92913,0.81102,0.92913,0.8189,0.92913,0.82677,0.92913,0.83465,0.92913,0.84252,0.92913,0.85039,0.92913,0.85827,0.92913,0.86614,0.92913,0.87402,0.92913,0.88189,0.92913,0.88976,0.92913,0.89764,0.92913,0.90551,0.92913,0.91339,0.92913,0.92126,0.92913,0.92913,0.92913,0.93701,0.92913,0.94488,0.92913,0.95276,0.92913,0.96063,0.92913,0.9685,0.92913,0.97638,0.92913,0.98425,0.92913,0.99213,0.92913,0.99609,0.92913,0.00391,0.93701,0.00787,0.93701,0.01575,0.93701,0.02362,0.93701,0.0315,0.93701,0.03937,0.93701,0.04724,0.93701,0.05512,0.93701,0.06299,0.93701,0.07087,0.93701,0.07874,0.93701,0.08661,0.93701,0.09449,0.93701,0.10236,0.93701,0.11024,0.93701,0.11811,0.93701,0.12598,0.93701,0.13386,0.93701,0.14173,0.93701,0.14961,0.93701,0.15748,0.93701,0.16535,0.93701,0.17323,0.93701,0.1811,0.93701,0.18898,0.93701,0.19685,0.93701,0.20472,0.93701,0.2126,0.93701,0.22047,0.93701,0.22835,0.93701,0.23622,0.93701,0.24409,0.93701,0.25197,0.93701,0.25984,0.93701,0.26772,0.93701,0.27559,0.93701,0.28346,0.93701,0.29134,0.93701,0.29921,0.93701,0.30709,0.93701,0.31496,0.93701,0.32283,0.93701,0.33071,0.93701,0.33858,0.93701,0.34646,0.93701,0.35433,0.93701,0.3622,0.93701,0.37008,0.93701,0.37795,0.93701,0.38583,0.93701,0.3937,0.93701,0.40157,0.93701,0.40945,0.93701,0.41732,0.93701,0.4252,0.93701,0.43307,0.93701,0.44094,0.93701,0.44882,0.93701,0.45669,0.93701,0.46457,0.93701,0.47244,0.93701,0.48031,0.93701,0.48819,0.93701,0.49606,0.93701,0.50394,0.93701,0.51181,0.93701,0.51969,0.93701,0.52756,0.93701};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_154()
		{
			double[] value = {0.53543,0.93701,0.54331,0.93701,0.55118,0.93701,0.55906,0.93701,0.56693,0.93701,0.5748,0.93701,0.58268,0.93701,0.59055,0.93701,0.59843,0.93701,0.6063,0.93701,0.61417,0.93701,0.62205,0.93701,0.62992,0.93701,0.6378,0.93701,0.64567,0.93701,0.65354,0.93701,0.66142,0.93701,0.66929,0.93701,0.67717,0.93701,0.68504,0.93701,0.69291,0.93701,0.70079,0.93701,0.70866,0.93701,0.71654,0.93701,0.72441,0.93701,0.73228,0.93701,0.74016,0.93701,0.74803,0.93701,0.75591,0.93701,0.76378,0.93701,0.77165,0.93701,0.77953,0.93701,0.7874,0.93701,0.79528,0.93701,0.80315,0.93701,0.81102,0.93701,0.8189,0.93701,0.82677,0.93701,0.83465,0.93701,0.84252,0.93701,0.85039,0.93701,0.85827,0.93701,0.86614,0.93701,0.87402,0.93701,0.88189,0.93701,0.88976,0.93701,0.89764,0.93701,0.90551,0.93701,0.91339,0.93701,0.92126,0.93701,0.92913,0.93701,0.93701,0.93701,0.94488,0.93701,0.95276,0.93701,0.96063,0.93701,0.9685,0.93701,0.97638,0.93701,0.98425,0.93701,0.99213,0.93701,0.99609,0.93701,0.00391,0.94488,0.00787,0.94488,0.01575,0.94488,0.02362,0.94488,0.0315,0.94488,0.03937,0.94488,0.04724,0.94488,0.05512,0.94488,0.06299,0.94488,0.07087,0.94488,0.07874,0.94488,0.08661,0.94488,0.09449,0.94488,0.10236,0.94488,0.11024,0.94488,0.11811,0.94488,0.12598,0.94488,0.13386,0.94488,0.14173,0.94488,0.14961,0.94488,0.15748,0.94488,0.16535,0.94488,0.17323,0.94488,0.1811,0.94488,0.18898,0.94488,0.19685,0.94488,0.20472,0.94488,0.2126,0.94488,0.22047,0.94488,0.22835,0.94488,0.23622,0.94488,0.24409,0.94488,0.25197,0.94488,0.25984,0.94488,0.26772,0.94488,0.27559,0.94488,0.28346,0.94488,0.29134,0.94488,0.29921,0.94488,0.30709,0.94488};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_155()
		{
			double[] value = {0.31496,0.94488,0.32283,0.94488,0.33071,0.94488,0.33858,0.94488,0.34646,0.94488,0.35433,0.94488,0.3622,0.94488,0.37008,0.94488,0.37795,0.94488,0.38583,0.94488,0.3937,0.94488,0.40157,0.94488,0.40945,0.94488,0.41732,0.94488,0.4252,0.94488,0.43307,0.94488,0.44094,0.94488,0.44882,0.94488,0.45669,0.94488,0.46457,0.94488,0.47244,0.94488,0.48031,0.94488,0.48819,0.94488,0.49606,0.94488,0.50394,0.94488,0.51181,0.94488,0.51969,0.94488,0.52756,0.94488,0.53543,0.94488,0.54331,0.94488,0.55118,0.94488,0.55906,0.94488,0.56693,0.94488,0.5748,0.94488,0.58268,0.94488,0.59055,0.94488,0.59843,0.94488,0.6063,0.94488,0.61417,0.94488,0.62205,0.94488,0.62992,0.94488,0.6378,0.94488,0.64567,0.94488,0.65354,0.94488,0.66142,0.94488,0.66929,0.94488,0.67717,0.94488,0.68504,0.94488,0.69291,0.94488,0.70079,0.94488,0.70866,0.94488,0.71654,0.94488,0.72441,0.94488,0.73228,0.94488,0.74016,0.94488,0.74803,0.94488,0.75591,0.94488,0.76378,0.94488,0.77165,0.94488,0.77953,0.94488,0.7874,0.94488,0.79528,0.94488,0.80315,0.94488,0.81102,0.94488,0.8189,0.94488,0.82677,0.94488,0.83465,0.94488,0.84252,0.94488,0.85039,0.94488,0.85827,0.94488,0.86614,0.94488,0.87402,0.94488,0.88189,0.94488,0.88976,0.94488,0.89764,0.94488,0.90551,0.94488,0.91339,0.94488,0.92126,0.94488,0.92913,0.94488,0.93701,0.94488,0.94488,0.94488,0.95276,0.94488,0.96063,0.94488,0.9685,0.94488,0.97638,0.94488,0.98425,0.94488,0.99213,0.94488,0.99609,0.94488,0.00391,0.95276,0.00787,0.95276,0.01575,0.95276,0.02362,0.95276,0.0315,0.95276,0.03937,0.95276,0.04724,0.95276,0.05512,0.95276,0.06299,0.95276,0.07087,0.95276,0.07874,0.95276,0.08661,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_156()
		{
			double[] value = {0.09449,0.95276,0.10236,0.95276,0.11024,0.95276,0.11811,0.95276,0.12598,0.95276,0.13386,0.95276,0.14173,0.95276,0.14961,0.95276,0.15748,0.95276,0.16535,0.95276,0.17323,0.95276,0.1811,0.95276,0.18898,0.95276,0.19685,0.95276,0.20472,0.95276,0.2126,0.95276,0.22047,0.95276,0.22835,0.95276,0.23622,0.95276,0.24409,0.95276,0.25197,0.95276,0.25984,0.95276,0.26772,0.95276,0.27559,0.95276,0.28346,0.95276,0.29134,0.95276,0.29921,0.95276,0.30709,0.95276,0.31496,0.95276,0.32283,0.95276,0.33071,0.95276,0.33858,0.95276,0.34646,0.95276,0.35433,0.95276,0.3622,0.95276,0.37008,0.95276,0.37795,0.95276,0.38583,0.95276,0.3937,0.95276,0.40157,0.95276,0.40945,0.95276,0.41732,0.95276,0.4252,0.95276,0.43307,0.95276,0.44094,0.95276,0.44882,0.95276,0.45669,0.95276,0.46457,0.95276,0.47244,0.95276,0.48031,0.95276,0.48819,0.95276,0.49606,0.95276,0.50394,0.95276,0.51181,0.95276,0.51969,0.95276,0.52756,0.95276,0.53543,0.95276,0.54331,0.95276,0.55118,0.95276,0.55906,0.95276,0.56693,0.95276,0.5748,0.95276,0.58268,0.95276,0.59055,0.95276,0.59843,0.95276,0.6063,0.95276,0.61417,0.95276,0.62205,0.95276,0.62992,0.95276,0.6378,0.95276,0.64567,0.95276,0.65354,0.95276,0.66142,0.95276,0.66929,0.95276,0.67717,0.95276,0.68504,0.95276,0.69291,0.95276,0.70079,0.95276,0.70866,0.95276,0.71654,0.95276,0.72441,0.95276,0.73228,0.95276,0.74016,0.95276,0.74803,0.95276,0.75591,0.95276,0.76378,0.95276,0.77165,0.95276,0.77953,0.95276,0.7874,0.95276,0.79528,0.95276,0.80315,0.95276,0.81102,0.95276,0.8189,0.95276,0.82677,0.95276,0.83465,0.95276,0.84252,0.95276,0.85039,0.95276,0.85827,0.95276,0.86614,0.95276,0.87402,0.95276};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_157()
		{
			double[] value = {0.88189,0.95276,0.88976,0.95276,0.89764,0.95276,0.90551,0.95276,0.91339,0.95276,0.92126,0.95276,0.92913,0.95276,0.93701,0.95276,0.94488,0.95276,0.95276,0.95276,0.96063,0.95276,0.9685,0.95276,0.97638,0.95276,0.98425,0.95276,0.99213,0.95276,0.99609,0.95276,0.00391,0.96063,0.00787,0.96063,0.01575,0.96063,0.02362,0.96063,0.0315,0.96063,0.03937,0.96063,0.04724,0.96063,0.05512,0.96063,0.06299,0.96063,0.07087,0.96063,0.07874,0.96063,0.08661,0.96063,0.09449,0.96063,0.10236,0.96063,0.11024,0.96063,0.11811,0.96063,0.12598,0.96063,0.13386,0.96063,0.14173,0.96063,0.14961,0.96063,0.15748,0.96063,0.16535,0.96063,0.17323,0.96063,0.1811,0.96063,0.18898,0.96063,0.19685,0.96063,0.20472,0.96063,0.2126,0.96063,0.22047,0.96063,0.22835,0.96063,0.23622,0.96063,0.24409,0.96063,0.25197,0.96063,0.25984,0.96063,0.26772,0.96063,0.27559,0.96063,0.28346,0.96063,0.29134,0.96063,0.29921,0.96063,0.30709,0.96063,0.31496,0.96063,0.32283,0.96063,0.33071,0.96063,0.33858,0.96063,0.34646,0.96063,0.35433,0.96063,0.3622,0.96063,0.37008,0.96063,0.37795,0.96063,0.38583,0.96063,0.3937,0.96063,0.40157,0.96063,0.40945,0.96063,0.41732,0.96063,0.4252,0.96063,0.43307,0.96063,0.44094,0.96063,0.44882,0.96063,0.45669,0.96063,0.46457,0.96063,0.47244,0.96063,0.48031,0.96063,0.48819,0.96063,0.49606,0.96063,0.50394,0.96063,0.51181,0.96063,0.51969,0.96063,0.52756,0.96063,0.53543,0.96063,0.54331,0.96063,0.55118,0.96063,0.55906,0.96063,0.56693,0.96063,0.5748,0.96063,0.58268,0.96063,0.59055,0.96063,0.59843,0.96063,0.6063,0.96063,0.61417,0.96063,0.62205,0.96063,0.62992,0.96063,0.6378,0.96063,0.64567,0.96063,0.65354,0.96063};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_158()
		{
			double[] value = {0.66142,0.96063,0.66929,0.96063,0.67717,0.96063,0.68504,0.96063,0.69291,0.96063,0.70079,0.96063,0.70866,0.96063,0.71654,0.96063,0.72441,0.96063,0.73228,0.96063,0.74016,0.96063,0.74803,0.96063,0.75591,0.96063,0.76378,0.96063,0.77165,0.96063,0.77953,0.96063,0.7874,0.96063,0.79528,0.96063,0.80315,0.96063,0.81102,0.96063,0.8189,0.96063,0.82677,0.96063,0.83465,0.96063,0.84252,0.96063,0.85039,0.96063,0.85827,0.96063,0.86614,0.96063,0.87402,0.96063,0.88189,0.96063,0.88976,0.96063,0.89764,0.96063,0.90551,0.96063,0.91339,0.96063,0.92126,0.96063,0.92913,0.96063,0.93701,0.96063,0.94488,0.96063,0.95276,0.96063,0.96063,0.96063,0.9685,0.96063,0.97638,0.96063,0.98425,0.96063,0.99213,0.96063,0.99609,0.96063,0.00391,0.9685,0.00787,0.9685,0.01575,0.9685,0.02362,0.9685,0.0315,0.9685,0.03937,0.9685,0.04724,0.9685,0.05512,0.9685,0.06299,0.9685,0.07087,0.9685,0.07874,0.9685,0.08661,0.9685,0.09449,0.9685,0.10236,0.9685,0.11024,0.9685,0.11811,0.9685,0.12598,0.9685,0.13386,0.9685,0.14173,0.9685,0.14961,0.9685,0.15748,0.9685,0.16535,0.9685,0.17323,0.9685,0.1811,0.9685,0.18898,0.9685,0.19685,0.9685,0.20472,0.9685,0.2126,0.9685,0.22047,0.9685,0.22835,0.9685,0.23622,0.9685,0.24409,0.9685,0.25197,0.9685,0.25984,0.9685,0.26772,0.9685,0.27559,0.9685,0.28346,0.9685,0.29134,0.9685,0.29921,0.9685,0.30709,0.9685,0.31496,0.9685,0.32283,0.9685,0.33071,0.9685,0.33858,0.9685,0.34646,0.9685,0.35433,0.9685,0.3622,0.9685,0.37008,0.9685,0.37795,0.9685,0.38583,0.9685,0.3937,0.9685,0.40157,0.9685,0.40945,0.9685,0.41732,0.9685,0.4252,0.9685,0.43307,0.9685};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_159()
		{
			double[] value = {0.44094,0.9685,0.44882,0.9685,0.45669,0.9685,0.46457,0.9685,0.47244,0.9685,0.48031,0.9685,0.48819,0.9685,0.49606,0.9685,0.50394,0.9685,0.51181,0.9685,0.51969,0.9685,0.52756,0.9685,0.53543,0.9685,0.54331,0.9685,0.55118,0.9685,0.55906,0.9685,0.56693,0.9685,0.5748,0.9685,0.58268,0.9685,0.59055,0.9685,0.59843,0.9685,0.6063,0.9685,0.61417,0.9685,0.62205,0.9685,0.62992,0.9685,0.6378,0.9685,0.64567,0.9685,0.65354,0.9685,0.66142,0.9685,0.66929,0.9685,0.67717,0.9685,0.68504,0.9685,0.69291,0.9685,0.70079,0.9685,0.70866,0.9685,0.71654,0.9685,0.72441,0.9685,0.73228,0.9685,0.74016,0.9685,0.74803,0.9685,0.75591,0.9685,0.76378,0.9685,0.77165,0.9685,0.77953,0.9685,0.7874,0.9685,0.79528,0.9685,0.80315,0.9685,0.81102,0.9685,0.8189,0.9685,0.82677,0.9685,0.83465,0.9685,0.84252,0.9685,0.85039,0.9685,0.85827,0.9685,0.86614,0.9685,0.87402,0.9685,0.88189,0.9685,0.88976,0.9685,0.89764,0.9685,0.90551,0.9685,0.91339,0.9685,0.92126,0.9685,0.92913,0.9685,0.93701,0.9685,0.94488,0.9685,0.95276,0.9685,0.96063,0.9685,0.9685,0.9685,0.97638,0.9685,0.98425,0.9685,0.99213,0.9685,0.99609,0.9685,0.00391,0.97638,0.00787,0.97638,0.01575,0.97638,0.02362,0.97638,0.0315,0.97638,0.03937,0.97638,0.04724,0.97638,0.05512,0.97638,0.06299,0.97638,0.07087,0.97638,0.07874,0.97638,0.08661,0.97638,0.09449,0.97638,0.10236,0.97638,0.11024,0.97638,0.11811,0.97638,0.12598,0.97638,0.13386,0.97638,0.14173,0.97638,0.14961,0.97638,0.15748,0.97638,0.16535,0.97638,0.17323,0.97638,0.1811,0.97638,0.18898,0.97638,0.19685,0.97638,0.20472,0.97638,0.2126,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_160()
		{
			double[] value = {0.22047,0.97638,0.22835,0.97638,0.23622,0.97638,0.24409,0.97638,0.25197,0.97638,0.25984,0.97638,0.26772,0.97638,0.27559,0.97638,0.28346,0.97638,0.29134,0.97638,0.29921,0.97638,0.30709,0.97638,0.31496,0.97638,0.32283,0.97638,0.33071,0.97638,0.33858,0.97638,0.34646,0.97638,0.35433,0.97638,0.3622,0.97638,0.37008,0.97638,0.37795,0.97638,0.38583,0.97638,0.3937,0.97638,0.40157,0.97638,0.40945,0.97638,0.41732,0.97638,0.4252,0.97638,0.43307,0.97638,0.44094,0.97638,0.44882,0.97638,0.45669,0.97638,0.46457,0.97638,0.47244,0.97638,0.48031,0.97638,0.48819,0.97638,0.49606,0.97638,0.50394,0.97638,0.51181,0.97638,0.51969,0.97638,0.52756,0.97638,0.53543,0.97638,0.54331,0.97638,0.55118,0.97638,0.55906,0.97638,0.56693,0.97638,0.5748,0.97638,0.58268,0.97638,0.59055,0.97638,0.59843,0.97638,0.6063,0.97638,0.61417,0.97638,0.62205,0.97638,0.62992,0.97638,0.6378,0.97638,0.64567,0.97638,0.65354,0.97638,0.66142,0.97638,0.66929,0.97638,0.67717,0.97638,0.68504,0.97638,0.69291,0.97638,0.70079,0.97638,0.70866,0.97638,0.71654,0.97638,0.72441,0.97638,0.73228,0.97638,0.74016,0.97638,0.74803,0.97638,0.75591,0.97638,0.76378,0.97638,0.77165,0.97638,0.77953,0.97638,0.7874,0.97638,0.79528,0.97638,0.80315,0.97638,0.81102,0.97638,0.8189,0.97638,0.82677,0.97638,0.83465,0.97638,0.84252,0.97638,0.85039,0.97638,0.85827,0.97638,0.86614,0.97638,0.87402,0.97638,0.88189,0.97638,0.88976,0.97638,0.89764,0.97638,0.90551,0.97638,0.91339,0.97638,0.92126,0.97638,0.92913,0.97638,0.93701,0.97638,0.94488,0.97638,0.95276,0.97638,0.96063,0.97638,0.9685,0.97638,0.97638,0.97638,0.98425,0.97638,0.99213,0.97638,0.99609,0.97638};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_161()
		{
			double[] value = {0.00391,0.98425,0.00787,0.98425,0.01575,0.98425,0.02362,0.98425,0.0315,0.98425,0.03937,0.98425,0.04724,0.98425,0.05512,0.98425,0.06299,0.98425,0.07087,0.98425,0.07874,0.98425,0.08661,0.98425,0.09449,0.98425,0.10236,0.98425,0.11024,0.98425,0.11811,0.98425,0.12598,0.98425,0.13386,0.98425,0.14173,0.98425,0.14961,0.98425,0.15748,0.98425,0.16535,0.98425,0.17323,0.98425,0.1811,0.98425,0.18898,0.98425,0.19685,0.98425,0.20472,0.98425,0.2126,0.98425,0.22047,0.98425,0.22835,0.98425,0.23622,0.98425,0.24409,0.98425,0.25197,0.98425,0.25984,0.98425,0.26772,0.98425,0.27559,0.98425,0.28346,0.98425,0.29134,0.98425,0.29921,0.98425,0.30709,0.98425,0.31496,0.98425,0.32283,0.98425,0.33071,0.98425,0.33858,0.98425,0.34646,0.98425,0.35433,0.98425,0.3622,0.98425,0.37008,0.98425,0.37795,0.98425,0.38583,0.98425,0.3937,0.98425,0.40157,0.98425,0.40945,0.98425,0.41732,0.98425,0.4252,0.98425,0.43307,0.98425,0.44094,0.98425,0.44882,0.98425,0.45669,0.98425,0.46457,0.98425,0.47244,0.98425,0.48031,0.98425,0.48819,0.98425,0.49606,0.98425,0.50394,0.98425,0.51181,0.98425,0.51969,0.98425,0.52756,0.98425,0.53543,0.98425,0.54331,0.98425,0.55118,0.98425,0.55906,0.98425,0.56693,0.98425,0.5748,0.98425,0.58268,0.98425,0.59055,0.98425,0.59843,0.98425,0.6063,0.98425,0.61417,0.98425,0.62205,0.98425,0.62992,0.98425,0.6378,0.98425,0.64567,0.98425,0.65354,0.98425,0.66142,0.98425,0.66929,0.98425,0.67717,0.98425,0.68504,0.98425,0.69291,0.98425,0.70079,0.98425,0.70866,0.98425,0.71654,0.98425,0.72441,0.98425,0.73228,0.98425,0.74016,0.98425,0.74803,0.98425,0.75591,0.98425,0.76378,0.98425,0.77165,0.98425,0.77953,0.98425};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_162()
		{
			double[] value = {0.7874,0.98425,0.79528,0.98425,0.80315,0.98425,0.81102,0.98425,0.8189,0.98425,0.82677,0.98425,0.83465,0.98425,0.84252,0.98425,0.85039,0.98425,0.85827,0.98425,0.86614,0.98425,0.87402,0.98425,0.88189,0.98425,0.88976,0.98425,0.89764,0.98425,0.90551,0.98425,0.91339,0.98425,0.92126,0.98425,0.92913,0.98425,0.93701,0.98425,0.94488,0.98425,0.95276,0.98425,0.96063,0.98425,0.9685,0.98425,0.97638,0.98425,0.98425,0.98425,0.99213,0.98425,0.99609,0.98425,0.00391,0.99213,0.00787,0.99213,0.01575,0.99213,0.02362,0.99213,0.0315,0.99213,0.03937,0.99213,0.04724,0.99213,0.05512,0.99213,0.06299,0.99213,0.07087,0.99213,0.07874,0.99213,0.08661,0.99213,0.09449,0.99213,0.10236,0.99213,0.11024,0.99213,0.11811,0.99213,0.12598,0.99213,0.13386,0.99213,0.14173,0.99213,0.14961,0.99213,0.15748,0.99213,0.16535,0.99213,0.17323,0.99213,0.1811,0.99213,0.18898,0.99213,0.19685,0.99213,0.20472,0.99213,0.2126,0.99213,0.22047,0.99213,0.22835,0.99213,0.23622,0.99213,0.24409,0.99213,0.25197,0.99213,0.25984,0.99213,0.26772,0.99213,0.27559,0.99213,0.28346,0.99213,0.29134,0.99213,0.29921,0.99213,0.30709,0.99213,0.31496,0.99213,0.32283,0.99213,0.33071,0.99213,0.33858,0.99213,0.34646,0.99213,0.35433,0.99213,0.3622,0.99213,0.37008,0.99213,0.37795,0.99213,0.38583,0.99213,0.3937,0.99213,0.40157,0.99213,0.40945,0.99213,0.41732,0.99213,0.4252,0.99213,0.43307,0.99213,0.44094,0.99213,0.44882,0.99213,0.45669,0.99213,0.46457,0.99213,0.47244,0.99213,0.48031,0.99213,0.48819,0.99213,0.49606,0.99213,0.50394,0.99213,0.51181,0.99213,0.51969,0.99213,0.52756,0.99213,0.53543,0.99213,0.54331,0.99213,0.55118,0.99213,0.55906,0.99213};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_163()
		{
			double[] value = {0.56693,0.99213,0.5748,0.99213,0.58268,0.99213,0.59055,0.99213,0.59843,0.99213,0.6063,0.99213,0.61417,0.99213,0.62205,0.99213,0.62992,0.99213,0.6378,0.99213,0.64567,0.99213,0.65354,0.99213,0.66142,0.99213,0.66929,0.99213,0.67717,0.99213,0.68504,0.99213,0.69291,0.99213,0.70079,0.99213,0.70866,0.99213,0.71654,0.99213,0.72441,0.99213,0.73228,0.99213,0.74016,0.99213,0.74803,0.99213,0.75591,0.99213,0.76378,0.99213,0.77165,0.99213,0.77953,0.99213,0.7874,0.99213,0.79528,0.99213,0.80315,0.99213,0.81102,0.99213,0.8189,0.99213,0.82677,0.99213,0.83465,0.99213,0.84252,0.99213,0.85039,0.99213,0.85827,0.99213,0.86614,0.99213,0.87402,0.99213,0.88189,0.99213,0.88976,0.99213,0.89764,0.99213,0.90551,0.99213,0.91339,0.99213,0.92126,0.99213,0.92913,0.99213,0.93701,0.99213,0.94488,0.99213,0.95276,0.99213,0.96063,0.99213,0.9685,0.99213,0.97638,0.99213,0.98425,0.99213,0.99213,0.99213,0.99609,0.99213,0.00391,0.99609,0.00787,0.99609,0.01575,0.99609,0.02362,0.99609,0.0315,0.99609,0.03937,0.99609,0.04724,0.99609,0.05512,0.99609,0.06299,0.99609,0.07087,0.99609,0.07874,0.99609,0.08661,0.99609,0.09449,0.99609,0.10236,0.99609,0.11024,0.99609,0.11811,0.99609,0.12598,0.99609,0.13386,0.99609,0.14173,0.99609,0.14961,0.99609,0.15748,0.99609,0.16535,0.99609,0.17323,0.99609,0.1811,0.99609,0.18898,0.99609,0.19685,0.99609,0.20472,0.99609,0.2126,0.99609,0.22047,0.99609,0.22835,0.99609,0.23622,0.99609,0.24409,0.99609,0.25197,0.99609,0.25984,0.99609,0.26772,0.99609,0.27559,0.99609,0.28346,0.99609,0.29134,0.99609,0.29921,0.99609,0.30709,0.99609,0.31496,0.99609,0.32283,0.99609,0.33071,0.99609,0.33858,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_164()
		{
			double[] value = {0.34646,0.99609,0.35433,0.99609,0.3622,0.99609,0.37008,0.99609,0.37795,0.99609,0.38583,0.99609,0.3937,0.99609,0.40157,0.99609,0.40945,0.99609,0.41732,0.99609,0.4252,0.99609,0.43307,0.99609,0.44094,0.99609,0.44882,0.99609,0.45669,0.99609,0.46457,0.99609,0.47244,0.99609,0.48031,0.99609,0.48819,0.99609,0.49606,0.99609,0.50394,0.99609,0.51181,0.99609,0.51969,0.99609,0.52756,0.99609,0.53543,0.99609,0.54331,0.99609,0.55118,0.99609,0.55906,0.99609,0.56693,0.99609,0.5748,0.99609,0.58268,0.99609,0.59055,0.99609,0.59843,0.99609,0.6063,0.99609,0.61417,0.99609,0.62205,0.99609,0.62992,0.99609,0.6378,0.99609,0.64567,0.99609,0.65354,0.99609,0.66142,0.99609,0.66929,0.99609,0.67717,0.99609,0.68504,0.99609,0.69291,0.99609,0.70079,0.99609,0.70866,0.99609,0.71654,0.99609,0.72441,0.99609,0.73228,0.99609,0.74016,0.99609,0.74803,0.99609,0.75591,0.99609,0.76378,0.99609,0.77165,0.99609,0.77953,0.99609,0.7874,0.99609,0.79528,0.99609,0.80315,0.99609,0.81102,0.99609,0.8189,0.99609,0.82677,0.99609,0.83465,0.99609,0.84252,0.99609,0.85039,0.99609,0.85827,0.99609,0.86614,0.99609,0.87402,0.99609,0.88189,0.99609,0.88976,0.99609,0.89764,0.99609,0.90551,0.99609,0.91339,0.99609,0.92126,0.99609,0.92913,0.99609,0.93701,0.99609,0.94488,0.99609,0.95276,0.99609,0.96063,0.99609,0.9685,0.99609,0.97638,0.99609,0.98425,0.99609,0.99213,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 16384 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_42()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_43()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_44()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_45()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_46()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_47()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_48()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_49()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_50()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_51()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_52()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_53()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_54()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_55()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_56()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_57()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_58()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_59()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_60()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_61()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_62()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_63()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_64()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_65()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_66()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_67()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_68()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_69()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_70()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_71()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_72()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_73()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_74()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_75()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_76()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_77()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_78()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_79()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_80()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_81()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_82()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_83()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_84()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_85()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_86()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_87()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_88()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_89()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_90()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_91()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_92()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_93()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_94()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_95()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_96()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_97()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_98()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_99()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_100()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_101()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_102()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_103()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_104()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_105()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_106()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_107()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_108()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_109()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_110()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_111()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_112()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_113()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_114()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_115()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_116()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_117()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_118()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_119()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_120()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_121()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_122()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_123()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_124()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_125()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_126()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_127()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_128()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_129()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_130()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_131()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_132()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_133()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_134()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_135()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_136()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_137()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_138()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_139()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_140()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_141()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_142()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_143()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_144()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_145()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_146()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_147()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_148()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_149()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_150()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_151()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_152()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_153()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_154()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_155()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_156()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_157()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_158()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_159()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_160()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_161()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_162()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_163()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_164()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 32768 total numbers made up of 16384 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_42()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_43()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_44()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_45()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_46()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_47()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_48()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_49()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_50()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_51()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_52()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_53()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_54()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_55()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_56()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_57()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_58()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_59()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_60()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_61()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_62()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_63()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_64()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_65()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_66()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_67()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_68()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_69()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_70()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_71()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_72()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_73()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_74()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_75()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_76()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_77()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_78()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_79()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_80()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_81()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_82()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_83()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_84()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_85()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_86()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_87()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_88()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_89()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_90()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_91()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_92()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_93()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_94()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_95()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_96()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_97()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_98()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_99()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_100()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_101()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_102()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_103()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_104()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_105()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_106()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_107()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_108()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_109()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_110()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_111()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_112()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_113()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_114()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_115()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_116()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_117()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_118()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_119()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_120()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_121()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_122()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_123()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_124()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_125()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_126()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_127()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_128()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_129()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_130()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_131()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_132()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_133()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_134()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_135()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_136()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_137()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_138()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_139()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_140()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_141()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_142()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_143()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_144()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_145()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_146()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_147()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_148()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_149()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_150()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_151()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_152()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_153()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_154()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_155()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_156()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_157()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_158()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_159()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_160()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_161()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_162()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_163()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_164()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD005 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD005().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD005\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD005 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD005_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD005_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD005_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD005_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
