package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD004Index.html" target="_blank">MarsLOD004</a>,  source <a href="../../../Geospatial/MarsLOD004.java">MarsLOD004.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD004.x3d">MarsLOD004.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD004.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD004.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD004
{
	/** Default constructor to create this object. */
	public MarsLOD004 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD004.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD004.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD004.x3d"))
    .addChild(new GeoLOD().setCenter(44.940476,-134.940476,348950.000000).setRange(1.8E7).setChild1Url(new String[] {"MarsLOD005.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD005.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars001.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars001.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(0.000000,-180.000000,0.000000).setSolid(false).setXDimension(64).setXSpacing(1.428571).setYScale(50.0).setZDimension(64).setZSpacing(1.428571).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {-2279.6575,-2186.1406,-2269.7097,-2545.2317,-2818.2412,-2845.2334,-2885.3352,-3077.9055,-3084.6006,-3197.7427,-3194.57,-2416.4746,-1972.2056,-1491.9081,-738.09424,-495.65036,-1644.8264,-2908.5256,-2942.5537,-3005.8794,-2617.3237,-1985.2458,-2033.4779,-2002.1957,-1903.8896,-1096.9602,-745.2059,-825.2428,-564.57666,-388.72366,-28.910065,595.1371,1125.2108,1587.2686,2027.5117,2377.2864,2781.93,3352.054,3905.6294,4339.8345,4639.1685,4988.8804,5591.184,6097.525,6716.792,9671.032,12625.076,10885.722,6896.794,5783.008,5683.2017,5577.436,5451.576,5258.42,5085.092,4900.3643,4623.3794,4289.785,4036.6272,3887.006,3701.4104,3463.1477,3233.0781,2925.5825,-2610.2808,-2660.9531,-2761.918,-2781.3533,-2892.9683,-2817.8645,-2902.1794,-3140.6357,-3062.4539,-3025.4072,-2926.0095,-2690.0737,-2134.9834,-1585.6843,-1003.93884,-1510.2677,-2410.9453,-2731.6016,-3118.8943,-2973.928,-2861.0586,-2679.9048,-2340.7354,-2099.3447,-1512.9075,-553.64636,-1282.8088,-1226.5806,-1102.2411,-977.86536,-95.87338,787.028,1374.874,1921.9315,2128.6306,2030.6694};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2444.9072,3079.7258,4358.88,4621.265,4465.1587,4607.8774,4879.1035,5115.256,5509.8354,8772.705,12909.831,11888.23,7782.49,5554.1733,5519.9272,5541.1875,5415.157,5211.8228,4989.14,4705.5137,4420.1177,4191.5234,3992.0635,3856.008,3659.3071,3327.649,3012.863,2673.8762,-3015.8372,-2904.5957,-2856.059,-3010.3477,-3005.3464,-3047.467,-3199.4016,-3228.3127,-3160.242,-3070.6091,-3045.8276,-2661.3477,-2071.0264,-1774.0487,-1776.3718,-1925.8081,-2703.7102,-3075.376,-3217.2693,-3059.803,-3065.084,-2805.5845,-2617.8333,-1993.2711,-777.6523,-1021.32574,-1708.3564,-1581.4434,-1295.6671,-474.0978,344.00305,946.66187,1608.0211,2234.1235,2039.7858,1615.045,1979.3856,2834.0847,4851.142,4665.7397,4392.2847,4413.2637,4354.8013,4312.188,4171.8516,5696.6045,8701.474,8455.931,6183.8804,5367.813,5513.7334,5757.86,5544.4507,5213.176,4875.66,4569.1685,4274.714,4102.7734,3920.8425,3841.3918,3881.9521,3367.8252,2769.1975,2430.2544,-2974.5786,-2962.3342,-3080.0205,-3110.5417,-3095.6917,-3251.3713,-3229.752,-3239.333};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {-3213.2158,-3154.0896,-3127.4143,-2893.1497,-2463.251,-2308.5845,-2144.6497,-2214.8716,-2969.722,-3213.8435,-3268.712,-3227.5737,-3173.3362,-2925.2812,-2522.4463,-1451.4154,-885.9936,-1933.7972,-1885.9509,-1693.2023,-1014.2173,90.87562,812.28094,1381.8214,1876.3368,2012.0522,1493.138,1339.269,1666.658,2317.511,3466.5615,4159.9546,4271.566,4305.9688,4121.9097,3878.565,3480.414,3625.9546,4191.4004,4601.195,5020.9185,5216.881,5598.1035,6017.8926,5828.484,5238.5024,4735.762,4396.436,4099.617,3927.2483,3826.096,3740.8564,3949.2837,3527.2188,2595.737,2080.6116,-2932.2505,-3037.7773,-2931.7883,-3138.0093,-3212.5308,-3233.6934,-3275.3867,-3268.5117,-3223.8323,-3202.2544,-3181.265,-3153.2727,-2844.3948,-2606.731,-2357.774,-2533.0232,-3134.9604,-3299.8142,-3329.535,-3342.2432,-3306.7314,-3022.9316,-2137.6628,-1496.8413,-2208.1833,-2297.804,-2142.2107,-1782.6019,-803.43384,329.3907,797.7206,1095.3876,1251.513,1149.6141,1095.9617,1088.4651,1140.9008,1945.7511,3130.2195,4472.2637,4398.548,4331.3647,4076.421,3718.9314};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {3260.7075,3196.523,3311.7974,3906.4634,4513.3813,4978.283,5756.0723,6429.862,6126.8223,5069.389,4461.602,4168.19,3952.8433,3776.5325,3659.0806,3616.1375,3679.141,3329.642,2248.3733,1645.9817,-3098.4026,-3052.9456,-3116.3027,-3124.1292,-3153.9316,-3238.4248,-3269.1445,-3238.794,-3250.6772,-3252.0703,-3202.866,-3225.025,-3002.6272,-2691.9797,-2476.278,-2915.77,-3303.6,-3365.123,-3391.6543,-3398.9827,-3358.3442,-2812.9377,-2120.515,-2257.6685,-2674.8904,-2467.7515,-2091.0251,-1444.1201,-482.137,166.17128,157.4462,205.02538,393.0202,604.79694,778.1602,742.2689,901.44,1636.6273,3163.4963,4567.832,4569.672,4477.2847,4114.343,3513.8318,2984.1826,2972.6118,3168.843,3502.5894,4014.907,4752.637,6277.111,7382.53,6706.8936,4892.381,4105.3467,3922.9612,3758.8687,3613.687,3501.2368,3433.788,3310.0793,2741.9116,1980.5896,1618.0779,-3114.3394,-3017.7366,-3145.71,-3080.7761,-3133.0413,-3291.565,-3291.5378,-3255.0925,-3274.252,-3273.4314,-3256.7979,-3282.3904,-3022.902,-2762.7856,-2612.976,-3093.8628};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {-3366.492,-3430.774,-3444.1265,-3422.6826,-3306.658,-2798.5422,-2503.6177,-2817.3167,-2811.678,-2464.3809,-1729.9703,-1286.9077,-914.35504,-585.799,-527.7566,-384.8275,-155.73677,25.618542,377.84348,595.2888,761.6277,1193.9915,2968.4312,4251.4453,4521.2754,4530.154,3917.0408,2998.043,2790.2734,2798.8254,2541.287,2815.337,3396.079,4468.0454,6554.887,8556.738,8175.286,5342.752,3836.5461,3706.9888,3616.6064,3472.3018,3319.0488,3201.5212,2975.0354,2494.8445,2008.61,1633.3151,-3139.304,-3191.255,-3027.6023,-3114.9612,-3218.1838,-3297.1443,-3304.5146,-3298.1035,-3305.8347,-3325.378,-3346.6123,-3344.2898,-3139.1829,-2965.9578,-3000.3796,-3350.8442,-3456.9424,-3494.29,-3528.1082,-3429.361,-3319.1848,-3001.3315,-2848.2876,-2959.9883,-2880.972,-2426.5144,-1741.4357,-1448.1648,-1212.5868,-1058.451,-878.1105,-631.11475,-331.72946,-61.75134,184.78279,480.53198,917.292,1316.0302,2584.685,3371.2246,3111.983,3127.639,2810.0474,2634.042,2631.1262,2621.4478,2641.716,2657.3333,2783.2393,3473.2024,5502.6597,10426.76};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {13022.909,10621.415,4951.078,3564.4395,3471.0356,3356.8657,3183.4292,2987.7231,2746.5217,2414.2568,2036.8179,1655.3091,-3181.226,-3208.6914,-3033.0862,-3331.496,-3229.6948,-3322.7573,-3344.1804,-3353.5654,-3369.666,-3395.4885,-3435.4312,-3463.8374,-3394.2039,-3296.186,-3426.788,-3534.901,-3547.969,-3530.855,-3520.6125,-3456.491,-3419.8682,-3238.6174,-3092.8335,-3049.1465,-2901.9197,-2348.4475,-1825.7312,-1596.3158,-1443.1635,-1272.892,-1005.1465,-685.39056,-364.99265,-30.575274,262.96768,512.4486,873.3927,1400.4033,2283.1494,2705.444,2520.955,2463.9497,2483.2139,2485.099,2472.1372,2451.8833,2448.9968,2353.2136,2238.4897,2168.2595,3724.9766,12123.582,16809.996,15234.603,7294.4424,3798.0088,3442.25,3247.1794,3038.7275,2838.7625,2609.7495,2348.406,2049.5427,1651.7373,-3158.0833,-3195.2725,-2960.004,-3502.2004,-3195.2305,-3319.4978,-3303.9263,-3322.0132,-3399.6418,-3447.1091,-3457.8708,-3507.135,-3514.1917,-3526.2783,-3570.226,-3608.295,-3599.8496,-3590.9749,-3553.091,-3515.8743,-3448.1948,-3351.673,-3251.5244,-3102.1763};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {-2629.645,-2000.2333,-1794.3154,-1655.7787,-1473.2068,-1156.542,-916.44824,-597.6457,-326.22012,-6.195477,344.803,611.92755,888.414,1181.5303,1844.9863,2318.9814,2349.412,2324.3494,2372.856,2385.712,2379.1555,2355.0952,2313.754,2190.4895,2010.6697,1735.4724,1954.3114,8167.8916,14189.79,13062.29,7243.921,4221.282,3577.6226,3189.5598,2861.4863,2622.5835,2442.6663,2509.305,3642.0725,1424.796,-3056.1523,-3218.5571,-3115.2686,-3114.6406,-3269.292,-3346.23,-3275.1438,-3350.3123,-3433.4377,-3509.851,-3523.589,-3553.5066,-3582.5645,-3624.097,-3632.4287,-3662.8386,-3653.5996,-3646.298,-3608.0654,-3583.4807,-3522.3826,-3416.4949,-3218.2014,-2867.1357,-2245.7534,-1892.6604,-1675.8185,-1531.5857,-794.50165,393.863,1984.7064,3421.2256,3315.5513,2523.8542,826.3224,687.061,992.3927,1194.2969,1372.9675,1793.488,2136.4177,2193.4631,2264.9753,2307.7605,2314.1987,2269.4773,2207.506,2126.1296,1973.0414,1809.1252,1660.6152,3062.1655,6272.4126,7449.508,5965.3105,4533.5195,3631.269,3088.43,2646.286,2420.0718};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {2246.3977,2458.6438,2951.165,1063.8474,-3536.646,-3226.5322,-3269.3816,-3307.354,-3387.6047,-3381.105,-3366.6223,-3283.8972,-3459.8162,-3530.118,-3559.283,-3605.3618,-3630.214,-3658.809,-3700.78,-3733.2883,-3718.6067,-3720.5713,-3693.947,-3687.0564,-3637.7937,-3232.9155,-2876.5364,-2517.8413,-2290.986,-1919.6757,-1696.0176,-1471.069,523.4673,4459.0337,8523.939,11011.839,11089.651,8484.856,4828.64,1028.62,1082.5236,1221.0563,1192.5317,1363.428,1926.2947,1967.7651,2068.7827,2212.02,2258.0115,2228.4736,2170.0583,2091.352,1983.9825,1880.4066,1822.6029,1908.5701,2877.9343,4382.521,4751.983,4233.627,3380.6956,2958.2988,2575.3333,2295.156,2099.2085,1883.895,1497.1311,970.9572,-3186.7727,-3319.79,-3323.027,-3388.7988,-3401.9597,-3245.3667,-3390.9653,-3427.2317,-3464.6018,-3512.8657,-3558.3977,-3634.8794,-3661.3977,-3685.5166,-3727.7078,-3755.7825,-3755.3904,-3769.6755,-3745.9631,-3761.2373,-3643.3462,-3047.358,-2656.2544,-2534.8252,-2210.8901,-2134.435,-2157.8857,-1506.3317,2709.6802,7906.6274,12151.597,17115.746};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {18434.736,14544.765,8393.217,2500.1467,1073.308,1351.39,1047.3245,978.3748,1479.6982,1556.8198,1882.5045,2131.7869,2208.6243,2213.283,2185.2673,2109.0168,2025.6392,1934.7859,1897.934,1885.4034,2363.9739,3259.846,3517.828,3312.7656,2902.8894,2697.2102,2503.751,2263.8015,2061.758,1812.7312,1453.6698,963.8674,-3382.332,-3331.9153,-3374.9404,-3416.5017,-3412.9275,-3314.1223,-3519.2136,-3424.3135,-3436.8047,-3508.1523,-3571.2068,-3657.4434,-3686.4287,-3707.9258,-3751.3115,-3782.8215,-3799.156,-3807.3528,-3792.7085,-3812.8396,-3659.3105,-3046.3384,-2640.0286,-2428.0981,-2117.2712,-1791.1663,-1964.9579,-1485.9093,2620.8054,8498.176,12986.82,18620.262,19374.197,16760.959,9549.516,2915.1772,913.03424,1163.7422,788.2095,692.16797,821.7709,1200.8983,1653.6934,2138.2788,2199.9058,2295.7778,2285.6433,2303.4128,2149.1396,2001.5469,1918.4944,1863.723,2005.4692,2420.9253,2735.2131,2675.9314,2531.4072,2461.2646,2375.383,2239.679,2077.7537,1894.7882,1594.9348,1137.5616,-3316.9873,-3366.0808,-3407.1904,-3467.883};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-3495.898,-3541.3982,-3524.9656,-3464.0603,-3453.7976,-3525.0337,-3617.5164,-3694.367,-3727.6714,-3766.5242,-3812.0962,-3831.9053,-3841.1826,-3837.7292,-3836.5762,-3839.1804,-3592.1404,-3031.763,-2714.7285,-2222.2722,-1214.9127,-1275.7145,-1861.4332,-1864.3401,1971.1873,7858.5503,11078.815,14813.107,16012.994,13674.648,7812.765,2552.5652,678.57935,566.06195,430.5596,492.4213,625.10114,935.69214,1375.3995,1838.085,2097.058,2355.6658,2453.7646,2548.7954,2481.0466,2296.0642,1973.9734,1836.8927,1884.7815,2141.6091,2329.3887,2348.552,2346.3682,2295.6504,2238.9775,2187.694,2059.0042,1905.0942,1636.6771,1270.4259,-3349.33,-3401.4482,-3466.5425,-3550.3992,-3551.8608,-3612.7827,-3620.896,-3586.1448,-3619.7803,-3678.2583,-3673.8982,-3774.2024,-3783.371,-3812.01,-3849.429,-3861.791,-3868.942,-3864.1506,-3861.2305,-3857.831,-3519.5493,-3067.9783,-2660.889,-1882.089,-1421.2013,-1418.0604,-1682.7379,-2123.022,-171.4093,6224.6284,8204.496,9892.586,10402.4,8975.971,4866.283,1042.3514,182.83975,174.56366,239.40674,343.68213};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {580.8905,882.4543,1245.8945,1652.3372,2039.4902,2360.5354,2545.0225,2658.3276,2768.2576,2727.0977,2159.1138,1862.1904,1889.1438,2012.304,2150.2378,2220.9724,2230.352,2206.731,2188.1892,2127.778,2046.3551,1907.5961,1653.9642,1240.8132,-3418.475,-3438.1587,-3486.91,-3568.7212,-3588.2585,-3636.0881,-3678.971,-3721.0735,-3762.2659,-3796.9316,-3790.073,-3829.8,-3832.5977,-3853.827,-3878.5107,-3876.649,-3878.716,-3876.2979,-3858.1226,-3868.4421,-3396.3997,-3139.5134,-2633.324,-1890.0836,-1739.2864,-1923.0518,-2077.9739,-2314.5552,-2060.9956,1146.3589,5993.912,6775.206,7108.024,3810.619,637.3207,-429.4903,-275.83514,-63.35988,60.531258,257.81076,567.82324,967.34064,1305.0879,1640.0085,1968.6318,2313.9236,2603.7214,2795.4348,2899.945,2912.3892,2352.7478,1894.1104,1877.3221,1900.8964,2077.5916,2188.7043,2206.152,2210.4478,2206.6182,2124.8735,1999.9587,1895.889,1735.0463,1105.3741,-3532.0793,-3538.1538,-3399.668,-3571.7163,-3600.3882,-3645.7788,-3705.8872,-3757.3557,-3792.9602,-3808.7808,-3817.5735,-3833.3315};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {-3845.7021,-3876.3892,-3880.9482,-3882.5833,-3882.6997,-3876.638,-3890.2708,-3861.1006,-3384.1758,-3204.4976,-2555.782,-1737.8868,-1758.9489,-1794.3403,-1843.618,-2242.3784,-2390.821,-2292.9558,-1444.9186,-1081.9125,-748.7844,-793.27716,-885.0849,-849.5929,-153.06326,-152.94855,-33.8122,274.64877,760.8535,1163.8157,1488.2875,1773.5089,2074.6895,2346.8398,2629.2402,2892.4282,3032.3389,3190.7063,3050.9883,2485.7632,1909.2997,1856.7698,2092.1035,2211.089,2185.5225,3710.4434,3457.4583,2120.8499,2037.6461,1871.8062,1732.2194,1047.6016,-3553.7092,-3569.6553,-3493.5427,-3607.3088,-3656.7195,-3747.847,-3752.5342,-3796.0054,-3824.4912,-3831.3372,-3834.6123,-3836.9019,-3858.2407,-3876.8276,-3878.0017,-3874.8206,-3870.5535,-3865.8987,-3863.4817,-3866.877,-3558.601,-3176.6284,-2354.8364,-1897.3729,-2052.4526,-1947.6254,-1770.0941,-1861.2983,-2276.9019,-2183.1091,-2015.2874,-2068.8828,-1771.7878,-1402.0808,-1271.5942,-692.3542,3.159817,-219.53038,110.10634,476.95856,928.3205,1308.7495,1661.0253,1887.3976,2178.7202,2462.5754,2730.3596,2996.1106};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {3174.6433,3423.8733,3485.1404,2977.0332,1948.0284,1781.6573,2110.0046,2173.422,2059.117,2549.2952,2353.9695,2178.3923,2837.3235,2549.5798,1609.5422,1015.2752,-3614.3823,-3617.1865,-3631.7979,-3646.6135,-3744.0269,-3792.971,-3814.4539,-3809.9468,-3856.9558,-3875.881,-3873.1152,-3861.9993,-3870.6553,-3880.5159,-3876.3887,-3872.0283,-3864.5598,-3858.7166,-3856.054,-3858.3396,-3746.3262,-3351.7617,-2473.2612,-2010.93,-2061.5317,-1966.6989,-1854.8202,-1717.1821,-1811.7228,-2034.9796,-1685.5989,-1292.9418,-1216.9463,-1172.0533,-1421.0719,-827.45935,-719.2147,-22.21829,485.1732,754.9765,1059.1774,1402.8057,1772.8401,2026.9838,2255.9927,2522.1448,2763.7012,3121.1772,3389.7961,3530.6416,3396.7737,2785.8438,1841.3623,1687.0352,1991.5671,1985.1973,1879.3385,2295.563,1957.4235,2087.3442,2740.9355,2483.0002,1757.6655,1002.4217,-3715.0635,-3679.5964,-3718.2344,-3775.87,-3827.136,-3849.361,-3842.7034,-3848.9282,-3877.0552,-3888.2737,-3890.833,-3889.214,-3881.568,-3884.3398,-3893.4243,-3890.2673,-3878.546,-3876.8247,-3877.859,-3868.2703};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {-3847.9712,-3504.525,-2959.6514,-2260.279,-1935.8077,-1832.3483,-1759.6893,-1730.05,-1670.6575,-1741.6658,-1260.166,-938.0758,-882.78394,-1162.9208,-1629.2291,-1102.929,-617.5901,231.70735,526.23975,905.3466,1251.1101,1535.5925,1862.9376,2104.552,2306.3823,2514.654,2778.7637,3475.0923,3704.3591,3466.7588,3051.566,2276.753,1742.2892,1670.9811,1836.3743,1837.3842,1665.2267,1630.6218,1686.1864,1691.2216,2082.7979,2162.208,1464.4667,1023.84174,-3767.9915,-3631.9924,-3784.1426,-3829.4446,-3861.961,-3874.3672,-3874.5627,-3869.2097,-3895.515,-3913.2737,-3913.0156,-3905.2153,-3895.6926,-3894.0293,-3902.2766,-3907.238,-3898.8306,-3889.5986,-3888.7795,-3880.6528,-3877.8613,-3790.3433,-3303.9182,-2692.381,-2051.1099,-1770.0717,-1736.8673,-1891.5673,-2093.1106,-1853.9604,-1151.9176,-1020.2518,-1089.216,-1535.8004,-1578.64,-672.51666,-86.11641,329.82013,675.5784,1003.8964,1342.396,1647.946,1914.8684,2156.6338,2353.9734,2498.2966,2743.0686,3472.4077,3811.5703,3606.1743,3009.3413,2194.0361,1692.553,1633.0132,1752.8479,1723.9983};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {1539.8291,1415.095,1424.3563,1442.5189,1389.8429,1289.9125,1118.1475,924.83075,-3836.2786,-3733.4573,-3815.3186,-3885.5232,-3887.7412,-3894.2866,-3892.9631,-3897.3286,-3909.9805,-3931.4106,-3944.8064,-3932.476,-3918.4795,-3910.369,-3908.8137,-3917.0847,-3916.4028,-3905.4856,-3899.7224,-3890.0894,-3887.3152,-3886.4475,-3613.3247,-3098.7468,-2662.3323,-2487.0242,-2482.3823,-2428.6157,-2337.1494,-2201.6936,-1939.564,-1693.6185,-1699.5237,-2005.2329,-1131.281,-244.76888,118.80195,429.3466,778.2587,1143.8085,1429.7478,1713.3766,1982.3639,2204.511,2377.1665,2556.9548,2729.324,3130.5947,3380.372,3220.3838,2841.1033,2162.9133,1661.7969,1622.4238,1672.1364,1595.8599,1429.4893,1337.6736,1199.9833,1171.3922,1165.9232,1100.3877,971.4108,830.533,-3865.7356,-3459.2832,-3702.3398,-3915.6787,-3922.8157,-3918.8162,-3913.349,-3913.009,-3926.672,-3943.4392,-3947.349,-3943.1536,-3936.5227,-3925.955,-3925.8425,-3932.7993,-3931.8066,-3919.2642,-3905.7744,-3904.342,-3915.7832,-3907.331,-3856.7515,-3464.4475,-3049.7693,-2797.2505,-2463.777,-2107.059};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {-2268.0166,-2236.4265,-2233.905,-2161.9028,-2101.9995,-1844.0355,-443.04736,24.206453,245.08154,562.24725,900.96515,1257.139,1569.466,1803.0183,2067.1172,2287.45,2475.4565,2663.5193,2886.403,3148.5984,3225.0457,3188.2095,2846.236,2229.4805,1704.6268,1538.2252,1528.1144,1459.7678,1316.6261,1187.4698,1088.9652,1028.6108,986.37915,982.0281,957.4309,811.0852,-3924.4504,-3658.7668,-3825.1963,-3950.106,-3943.9683,-3936.6184,-3925.1526,-3926.9934,-3929.9517,-3945.0728,-3945.2014,-3931.8352,-3941.002,-3935.999,-3941.287,-3946.5005,-3937.0227,-3936.9758,-3950.7168,-4001.142,-3983.9397,-3953.2883,-3934.8696,-3901.414,-3734.338,-2934.0793,-1817.5657,-1967.7416,-1975.2554,-2232.8994,-2249.7205,-2176.6055,-1888.4218,-786.287,70.90806,117.52585,335.96484,627.5785,989.5034,1342.7189,1679.6536,1991.5902,2308.9565,2500.8892,2728.4702,3003.1865,3213.1375,3509.1787,3444.5356,3395.2268,3078.606,2441.2173,1866.034,1444.4277,1305.7808,1242.1824,1162.0172,1081.7643,965.0079,944.28345,907.8402,958.4119,1168.4626,1102.0322};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {-3975.1006,-3941.861,-3967.8167,-3902.2727,-3927.3787,-3946.385,-3937.9019,-3935.464,-3941.4707,-3940.7644,-3939.064,-3918.7922,-3935.6497,-3947.9604,-3953.3083,-3945.9695,-3941.1416,-3939.8005,-3932.4014,-3963.3472,-3942.8916,-3947.0935,-3947.9368,-3918.9094,-3894.1052,-3137.4417,-1269.4135,-1603.9004,-2004.6965,-2114.8474,-1980.852,-1769.2277,-1093.7655,-12.276243,181.85516,110.46251,332.66583,617.5648,976.89246,1352.1825,1751.5756,2188.894,2570.4836,2950.2034,3296.2412,3592.414,3797.5662,3932.9504,3852.9978,3927.9883,3771.4,3265.2874,2800.6643,2106.1213,1438.77,1142.3995,958.6991,872.19543,821.76776,817.29834,848.8473,1020.0982,1253.163,1339.5021,-3993.4946,-3973.8044,-3986.026,-3865.1804,-3901.262,-3898.0635,-3961.4524,-3951.2852,-3956.3848,-3950.8616,-3933.898,-3924.2776,-3928.6753,-3947.69,-3951.9438,-3948.0063,-3948.241,-3948.156,-3935.3518,-3924.3423,-3902.5266,-3912.7607,-3886.592,-3854.8928,-3837.0679,-3662.7512,-2211.9265,-1677.1992,-2102.6738,-1980.2966,-1585.0691,-1278.4224,-876.6757,-246.12538,803.8615,183.08034};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {301.28693,570.96405,927.83563,1320.776,1849.9877,2491.7021,3023.7402,3488.033,3962.433,4311.1577,4543.592,4652.8203,4383.255,4383.1323,4223.4067,3998.8508,3715.5547,3117.6301,2126.3523,1463.7849,933.29877,706.46344,657.4626,663.4036,715.97003,758.4262,938.11633,994.50464,-4012.3655,-3988.1794,-4004.6975,-3945.3718,-3614.6804,-3705.3438,-3970.4578,-3961.5017,-3975.2407,-3966.307,-3947.2344,-3927.285,-3932.7224,-3938.1511,-3937.081,-3949.6978,-3947.454,-3936.9143,-3906.4827,-3881.1064,-3870.74,-3874.4048,-3857.7297,-3828.2961,-3838.7017,-3799.5234,-2862.8625,-1787.6804,-1419.2913,-1345.8344,-967.2931,-485.00992,-538.4296,-670.21783,-57.101173,-35.42127,218.96017,499.71957,811.5362,1300.8322,2017.0609,2873.592,3674.7244,4298.5645,4893.023,5296.759,5624.585,5744.2217,5560.9404,5273.7144,4566.6455,4126.4937,4138.479,3720.5093,2998.074,2117.0354,1173.1111,668.5101,465.7896,500.1754,554.71625,658.41254,796.67596,900.3759,-4030.1133,-4012.9082,-4019.8809,-4017.3704,-3915.8315,-3828.5208,-3853.7585,-3915.1885};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {-3946.7285,-3886.623,-3946.756,-3948.1543,-3933.4348,-3929.6365,-3933.8132,-3932.1458,-3907.669,-3892.3157,-3883.9207,-3868.932,-3846.6118,-3844.2065,-3842.8616,-3832.0417,-3805.167,-3717.6099,-3498.9236,-2811.5515,-1909.8053,-1477.3622,-1488.1661,-1163.8339,-1161.9199,-988.2151,-570.9664,-209.13393,40.0149,295.38626,735.36444,1463.5247,2378.995,3394.2063,4188.2803,4906.8813,5409.7817,5655.4277,5728.2417,6062.9946,6063.8223,5748.4243,5196.0913,4299.1963,4358.7915,4200.059,3512.5425,2531.507,1517.6317,803.05725,420.00494,399.82733,457.8182,592.5176,865.70514,705.1283,-4038.135,-4031.3818,-4043.0566,-4042.8916,-4016.33,-3985.6128,-3958.2493,-3965.3455,-3959.6719,-3967.771,-3959.171,-3941.5044,-3926.8801,-3916.0337,-3920.975,-3918.8005,-3901.1377,-3882.7888,-3894.356,-3859.6882,-3852.47,-3870.9514,-3832.131,-3740.3923,-3666.9563,-3583.6555,-3432.5793,-3151.0962,-2795.1174,-2439.8933,-2095.8054,-1749.2478,-1499.3248,-1164.9537,-822.37946,-505.76303,-286.71356,101.01195,672.2412,1467.1062,2507.5183,3545.7822,4403.5083,5029.3735};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {5428.222,5451.919,5426.12,6139.0635,5989.9077,5841.4375,5265.77,4288.0854,4163.479,4006.8757,3171.3262,2336.9968,1380.4714,718.5001,400.2502,372.41202,420.7552,461.9298,682.21924,644.8818,-4041.6013,-4048.798,-4049.9734,-4041.2048,-4022.649,-4003.3953,-3970.1475,-3968.4773,-3962.1748,-3951.2327,-3938.8406,-3931.3394,-3927.2146,-3908.0676,-3904.3608,-3921.5225,-3901.6387,-3905.7512,-3923.9822,-3890.8074,-3861.9749,-3839.0347,-3777.35,-3714.8481,-3573.751,-3457.5842,-3262.3643,-2986.2795,-2732.1587,-2447.4028,-2138.115,-1849.5808,-1580.4277,-1303.0731,-1021.2911,-782.0599,-507.88757,-109.86034,341.26938,1064.4983,1991.2383,3058.2698,3931.7588,4599.3735,5086.54,5138.079,5090.178,5367.5537,5576.8633,5297.8916,4623.683,4068.0142,3899.3232,3156.6995,2104.161,1222.7822,644.99084,281.53516,166.04478,305.63565,383.7249,418.04626,627.0608,719.0383,-4068.2708,-4075.331,-4066.2952,-4029.1492,-4024.5024,-4013.1567,-4005.4187,-3976.8083,-3961.6023,-3946.4263,-3936.284,-3943.0886,-3939.9775,-3935.026,-3927.9563,-3966.6711};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {-3953.7322,-3939.8906,-3897.5972,-3857.297,-3845.487,-3792.9238,-3710.8657,-3651.0776,-3498.1304,-3337.9692,-3150.2031,-2900.2993,-2701.0122,-2500.4473,-2162.4038,-1946.9913,-1708.2802,-1526.5142,-1320.1891,-1057.2576,-760.50195,-513.83185,-64.62164,573.482,1338.7004,2225.076,2987.066,3588.1907,4021.8667,4376.5464,4773.2466,4773.707,4753.652,4650.7188,4397.492,4067.4683,3344.452,2167.7332,1271.326,488.2941,92.109985,-86.95183,-116.49761,45.063484,106.92285,80.16742,9.571877,224.05125,-4098.3257,-4093.1848,-4060.4058,-4051.939,-4042.7434,-4028.803,-4016.8325,-3996.5254,-3978.0208,-3964.0461,-3937.444,-3950.8064,-3960.9788,-3956.6812,-3962.411,-3934.4023,-3910.9978,-3902.7915,-3866.2317,-3834.0405,-3800.5906,-3748.123,-3657.9265,-3538.3306,-3403.3066,-3221.7383,-3049.5728,-2793.3298,-2568.7893,-2358.4565,-2187.8057,-2009.6681,-1857.2778,-1737.9583,-1581.1985,-1381.0774,-1161.8745,-922.49207,-520.7467,-38.112118,581.6477,1209.1058,1626.9059,1989.013,2149.1313,2334.6465,3356.976,3899.6016,4252.251,4231.9707,3851.448,3147.6965};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {2251.3274,1500.8176,720.2128,257.88138,-30.560354,-201.45894,-265.08997,-225.5051,-275.65903,-364.8428,-521.05457,-647.0317,-4099.646,-4095.4888,-4084.6665,-4063.0347,-4038.5728,-4024.9263,-4019.6682,-4006.5103,-3986.5269,-3978.6755,-3960.45,-3956.0967,-3974.228,-3976.7317,-3968.0444,-3942.6326,-3932.5059,-3904.2788,-3856.3535,-3802.592,-3760.7517,-3710.8276,-3595.3306,-3473.86,-3321.02,-3166.7034,-3005.5361,-2814.2576,-2612.9402,-2422.126,-2286.6948,-2152.7283,-2071.0278,-1950.0011,-1827.5935,-1689.205,-1482.9347,-1308.1302,-1051.1938,-727.1982,-328.5831,32.920494,320.55588,500.17444,511.95853,445.01544,680.0751,1599.9703,2266.5457,2370.3074,1824.2893,1259.0087,754.0889,486.34232,264.49057,59.29384,-106.65119,-247.65091,-279.3355,-325.68985,-379.98666,-519.4874,-700.3046,-887.19116,-4101.853,-4082.1274,-4069.9062,-4068.8562,-4040.4714,-4036.7366,-4022.34,-3991.8477,-3983.9282,-3981.7783,-3975.0842,-3956.7896,-3995.076,-3979.1643,-3955.3972,-3930.5645,-3924.5254,-3892.8015,-3834.9448,-3774.9038,-3733.2148,-3655.0684,-3543.9207,-3432.1738};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {-3309.6997,-3163.2263,-3040.9685,-2844.4749,-2676.9663,-2560.7424,-2440.8977,-2324.9236,-2243.752,-2101.8137,-1962.4076,-1820.6543,-1689.9246,-1633.4247,-1493.8713,-1328.5167,-1168.8462,-944.3749,-719.795,-632.05396,-629.1648,-655.99194,-651.88477,-220.08177,230.50465,264.0288,-16.241648,-264.73355,-274.92282,-216.32143,-226.39813,-244.97508,-403.05026,-399.2429,-394.77158,-320.44742,-327.07013,-457.8762,-594.2556,-772.0,-4117.869,-4091.344,-4079.4888,-4062.535,-4048.1594,-4064.2642,-4048.8792,-4023.3833,-4020.5752,-4013.4666,-3999.7637,-3970.5317,-3976.012,-3977.1382,-3966.1099,-3925.3433,-3908.4272,-3850.8982,-3785.7603,-3717.178,-3668.8718,-3576.5398,-3467.811,-3395.6528,-3282.7302,-3166.3857,-3028.8784,-2918.2466,-2778.0205,-2677.5242,-2573.8025,-2448.763,-2326.1597,-2187.2595,-2060.1738,-1976.5774,-1912.6315,-1843.5613,-1747.8158,-1663.254,-1574.6448,-1464.3162,-1360.5575,-1277.499,-1190.347,-1156.5159,-1085.4869,-958.88086,-863.55066,-904.3821,-954.4422,-900.2241,-856.4253,-687.3151,-480.8151,-431.93393,-491.88766,-527.58264,-546.97833,-489.03497};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {-313.7282,-273.64847,-455.73877,-627.6364,-4125.63,-4101.663,-4081.29,-4078.7834,-4068.5425,-4073.9065,-4074.6152,-4064.0842,-4015.7205,-4003.799,-3988.2388,-3987.5393,-3985.524,-3950.097,-3931.6514,-3875.403,-3849.2974,-3814.7766,-3742.715,-3678.2622,-3620.8777,-3520.382,-3435.9265,-3331.2563,-3228.859,-3125.9011,-3004.9453,-2901.1404,-2834.004,-2730.0422,-2610.2432,-2495.6213,-2374.514,-2287.677,-2213.643,-2128.4482,-2062.2078,-1990.2871,-1905.6749,-1836.2949,-1768.6821,-1734.2621,-1646.249,-1553.0377,-1461.322,-1359.7902,-1278.4989,-1269.8192,-1278.8876,-1291.2222,-1241.3395,-1170.141,-1106.9653,-921.39734,-724.03656,-597.2622,-550.8702,-549.4484,-698.91644,-660.93634,-641.82837,-492.2382,-565.3008,-795.92804,-4125.6587,-4100.659,-4103.832,-4102.5713,-4111.214,-4103.6704,-4093.9941,-4097.5674,-4032.3623,-3997.6355,-3995.9487,-3990.7913,-3950.6296,-3932.5432,-3920.9673,-3890.4736,-3829.785,-3773.655,-3718.7278,-3647.1016,-3580.272,-3469.472,-3356.2693,-3282.8416,-3211.1902,-3124.8005,-3056.9211,-2966.6404,-2880.1465,-2809.7156,-2710.1597,-2619.7505};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {-2543.2458,-2461.489,-2362.0408,-2289.1633,-2221.335,-2157.5203,-2075.5635,-2010.0363,-1939.1527,-1891.2765,-1797.4911,-1714.9648,-1637.6255,-1555.4259,-1512.576,-1515.2457,-1552.1825,-1531.226,-1455.2421,-1383.5479,-1278.5936,-1093.8326,-979.4353,-838.4847,-755.98364,-784.18823,-849.8711,-865.0106,-917.23346,-1042.4193,-1120.8959,-1318.7881,-4147.1636,-4128.0957,-4132.6475,-4126.6694,-4122.486,-4095.0662,-4038.8389,-4079.964,-4050.136,-4041.117,-4042.6738,-3961.7659,-3936.8115,-3936.4907,-3941.549,-3871.5493,-3832.471,-3762.9426,-3700.4521,-3633.1318,-3565.3298,-3311.3115,-3435.0503,-3257.0818,-3195.2048,-3197.0745,-3111.5059,-3038.5479,-2967.0244,-2902.8262,-2825.0466,-2743.4746,-2678.875,-2586.6128,-2500.2063,-2435.1335,-2339.8948,-2246.3733,-2187.1865,-2150.6646,-2072.91,-1989.2848,-1938.3416,-1889.8433,-1846.4486,-1788.932,-1743.5187,-1791.6951,-1795.3479,-1781.3921,-1727.2852,-1629.8528,-1555.9938,-1422.0261,-1248.5427,-1127.727,-1034.8499,-1031.9851,-1085.4489,-1095.8619,-1162.7505,-1293.9531,-1473.1951,-1696.8694,-4189.816,-4180.616,-4152.1025,-4123.081};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {-4128.477,-4081.1755,-4027.3364,-4038.098,-4024.694,-4022.8442,-4020.9248,-3990.5723,-3954.1785,-3949.0425,-3890.7644,-3844.4153,-3829.718,-3783.811,-3703.5076,-3649.5051,-3587.8809,-3470.554,-4617.28,-4026.3525,-3081.4514,-3231.6594,-3194.3386,-3143.409,-3069.8801,-3009.6333,-2959.9438,-2917.4211,-2842.7244,-2729.173,-2647.7896,-2563.9824,-2475.6797,-2409.7532,-2328.5325,-2266.1208,-2194.5266,-2156.263,-2108.8418,-2078.8376,-2036.1747,-2022.6793,-2034.6635,-2026.3129,-2008.4626,-2025.8086,-1974.9757,-1892.7589,-1822.2915,-1750.4923,-1594.436,-1497.1614,-1405.696,-1384.3071,-1418.1289,-1345.9451,-1370.9557,-1472.979,-1673.5619,-1901.8926,-4204.8105,-4213.5195,-4194.725,-4112.673,-4146.4316,-4135.6353,-4087.863,-4041.8054,-4027.8337,-4022.2002,-3988.0571,-3988.0083,-3973.47,-3925.9697,-3889.2358,-3851.6929,-3843.8884,-3791.3733,-3736.145,-3679.8052,-3643.1833,-3513.0332,-3442.554,-3340.804,-3318.0208,-3293.4438,-3254.4263,-3227.91,-3160.5115,-3111.3704,-3057.2637,-3009.9448,-2951.3606,-2870.072,-2795.2961,-2735.0105,-2650.7527,-2562.7715,-2482.8142,-2446.51};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {-2400.0652,-2342.5188,-2317.1643,-2294.6812,-2263.2786,-2250.8704,-2255.4993,-2239.3213,-2238.1265,-2257.916,-2211.6743,-2145.5295,-2139.1958,-2059.1765,-1940.4976,-1859.9001,-1776.7327,-1704.8827,-1696.1005,-1643.042,-1688.4211,-1771.3236,-1906.8259,-2111.8325,-4222.497,-4219.7554,-4209.668,-4121.667,-4146.5264,-4160.481,-4136.4556,-4063.1882,-4037.7844,-4060.206,-4023.9834,-4001.6565,-3989.768,-3951.215,-3945.2139,-3866.0981,-3854.8735,-3800.7454,-3757.9917,-3755.9783,-3691.7812,-3637.1758,-3502.8296,-3471.1367,-3429.3816,-3366.585,-3318.5076,-3307.4023,-3262.039,-3213.0867,-3147.3884,-3064.5422,-3027.498,-2987.73,-2928.5815,-2880.3745,-2812.8564,-2743.0884,-2713.409,-2689.8577,-2626.2634,-2577.8958,-2563.9622,-2514.8862,-2478.211,-2472.1316,-2463.8882,-2443.9324,-2443.1519,-2466.194,-2458.6204,-2413.0845,-2412.7903,-2359.6768,-2224.8088,-2139.0305,-2089.2322,-2039.842,-2014.4519,-2013.9436,-2029.0361,-2088.7646,-2259.211,-2439.6824,-4243.5063,-4241.958,-4207.529,-4160.55,-4159.9663,-4164.311,-4152.9346,-4137.2603,-4046.7263,-4090.9316,-4077.023,-4050.9106};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {-4045.1729,-4018.7217,-3981.447,-3929.5962,-3878.836,-3850.5364,-3812.6814,-3764.89,-3741.897,-3704.0193,-3645.8909,-3579.252,-3529.129,-3494.0613,-3451.748,-3401.2817,-3346.4565,-3303.9832,-3244.1973,-3185.1277,-3134.3164,-3117.2593,-3102.7026,-3069.3604,-3040.9375,-2987.4119,-2956.2922,-2914.283,-2874.5447,-2852.1768,-2824.9082,-2760.6782,-2739.0579,-2732.0334,-2715.767,-2734.0134,-2732.348,-2707.383,-2713.6826,-2717.3342,-2691.8293,-2640.0928,-2531.5457,-2449.7346,-2424.6328,-2394.7327,-2349.48,-2379.5872,-2486.7278,-2573.7295,-2683.3381,-2828.2283,-4244.772,-4249.223,-4199.841,-4207.66,-4194.7104,-4176.429,-4170.393,-4162.9272,-4119.971,-4104.649,-4099.257,-4075.7144,-4049.9426,-4022.2034,-4002.9036,-3979.6704,-3946.8713,-3897.801,-3840.7913,-3795.9763,-3770.8354,-3791.513,-3698.9878,-3655.5203,-3619.574,-3575.4587,-3525.8894,-3481.8018,-3433.9114,-3399.7527,-3369.8096,-3335.1814,-3300.0454,-3267.3535,-3239.845,-3220.5957,-3191.467,-3150.8564,-3133.912,-3116.2576,-3097.4019,-3084.3894,-3068.193,-3037.647,-3029.0615,-3028.0115,-3032.2703,-3008.1914};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {-2980.246,-2962.1265,-2956.5295,-2958.0166,-2961.3335,-2915.0947,-2923.5825,-2847.874,-2837.1948,-2819.7856,-2793.6982,-2832.6729,-2921.4255,-2996.1184,-3038.9622,-3085.4543,-4226.5493,-4229.3013,-4198.291,-4195.865,-4184.2817,-4198.8667,-4217.606,-4208.525,-4178.946,-4162.9053,-4153.247,-4148.8535,-4097.769,-4074.2139,-4014.2356,-4024.585,-3978.1362,-3945.3652,-3900.4976,-3881.794,-3838.97,-3805.2417,-3800.0762,-3762.923,-3725.0273,-3664.3623,-3626.3057,-3586.6956,-3540.4011,-3521.0789,-3507.3923,-3483.3088,-3449.2842,-3441.3672,-3388.6584,-3371.8542,-3342.389,-3316.782,-3295.1948,-3267.226,-3267.0376,-3250.3904,-3249.8145,-3229.4287,-3227.9827,-3231.581,-3227.7827,-3213.282,-3196.582,-3178.5557,-3177.0415,-3187.5723,-3199.834,-3193.9182,-3188.861,-3163.2617,-3162.9216,-3173.8188,-3153.3054,-3157.5361,-3171.4224,-3218.2693,-3238.3948,-3279.6716,-4301.5566,-4265.895,-4221.602,-4259.738,-4228.787,-4226.478,-4258.9624,-4251.2554,-4234.4927,-4215.146,-4206.5303,-4186.666,-4176.6587,-4150.638,-4095.8892,-4065.234,-4055.9592,-4022.4531,-3992.0925,-3958.5151};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {-3947.6973,-3923.3125,-3889.2021,-3863.6477,-3812.04,-3767.7703,-3732.7917,-3684.1235,-3651.2925,-3646.4744,-3630.91,-3600.3972,-3576.2256,-3545.4233,-3531.9062,-3526.7544,-3498.7263,-3490.7468,-3479.711,-3470.1558,-3470.9836,-3437.6497,-3434.2844,-3413.6018,-3405.795,-3390.4717,-3366.717,-3349.2295,-3327.0452,-3311.1472,-3309.274,-3315.6194,-3326.3845,-3324.0144,-3328.8916,-3314.9802,-3315.6787,-3333.212,-3342.8804,-3352.536,-3371.0974,-3421.9324,-3469.7163,-3496.4688,-4369.288,-4390.9194,-4321.227,-4308.6562,-4314.9595,-4335.886,-4327.5054,-4301.997,-4285.847,-4266.9893,-4227.964,-4196.2812,-4215.668,-4189.5664,-4145.866,-4152.912,-4152.46,-4143.652,-4110.0947,-4030.7422,-4033.4292,-4006.2212,-3963.0283,-3936.6125,-3889.8103,-3873.6418,-3881.624,-3834.8147,-3807.7173,-3787.3972,-3789.062,-3760.4197,-3730.1775,-3711.44,-3711.9417,-3683.7097,-3650.0703,-3654.6018,-3646.5269,-3644.7952,-3635.7356,-3608.927,-3591.618,-3581.1987,-3561.5786,-3546.6008,-3528.8994,-3505.775,-3480.5803,-3478.2207,-3463.005,-3459.8699,-3466.9412,-3452.4146,-3442.307,-3443.0356};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {-3450.5706,-3478.5278,-3509.8945,-3543.4229,-3563.6074,-3609.8113,-3662.6704,-3700.3813,-4396.094,-4424.7183,-4415.532,-4375.8657,-4385.0264,-4365.4116,-4382.22,-4376.484,-4344.6587,-4340.9883,-4316.0933,-4298.9927,-4284.225,-4273.214,-4260.801,-4269.6147,-4246.3457,-4232.938,-4199.816,-4170.254,-4135.565,-4129.6895,-4105.032,-4077.7288,-4051.4622,-4035.443,-4000.4243,-3967.4487,-3965.2249,-3947.2913,-3914.943,-3891.189,-3871.9878,-3863.685,-3850.4673,-3827.3882,-3793.1174,-3788.4744,-3781.69,-3770.1208,-3756.818,-3743.2415,-3726.4792,-3721.5015,-3691.1282,-3686.674,-3661.9412,-3633.0667,-3609.8708,-3607.0505,-3589.7183,-3590.3623,-3598.4482,-3580.4224,-3567.9316,-3577.1309,-3585.9968,-3615.2034,-3654.3396,-3687.963,-3720.5642,-3748.285,-3797.6758,-3851.3596,-4437.9565,-4472.3003,-4496.279,-4459.7373,-4453.755,-4440.7954,-4425.058,-4412.673,-4393.4653,-4380.4556,-4395.668,-4402.2373,-4370.3726,-4353.5405,-4335.5337,-4331.353,-4334.613,-4309.024,-4277.1416,-4281.278,-4272.1553,-4246.844,-4224.891,-4188.731,-4177.93,-4177.808,-4146.9067,-4133.423};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {-4109.926,-4096.59,-4075.4736,-4073.1917,-4048.2751,-4025.3599,-4014.7393,-3970.4268,-3960.2695,-3956.5498,-3913.946,-3895.4075,-3883.8245,-3871.8735,-3846.6077,-3838.2363,-3828.1335,-3808.8804,-3782.0693,-3743.9219,-3747.602,-3709.104,-3705.9336,-3706.405,-3711.7075,-3707.9739,-3705.8562,-3725.3083,-3744.8171,-3772.6882,-3814.3616,-3847.024,-3873.229,-3903.409,-3942.779,-3988.8704,-4471.333,-4530.6064,-4543.1685,-4517.8213,-4507.493,-4496.053,-4484.205,-4504.456,-4476.6895,-4485.319,-4475.9473,-4473.953,-4455.4644,-4436.484,-4413.905,-4418.654,-4401.121,-4420.494,-4398.5874,-4368.4956,-4353.4253,-4320.015,-4323.1494,-4334.4507,-4339.1436,-4304.0737,-4267.6187,-4288.5645,-4259.1157,-4265.0356,-4245.245,-4252.4263,-4203.256,-4174.8022,-4141.8213,-4145.088,-4082.8074,-4106.1934,-4068.347,-4023.8884,-4010.2932,-4009.7961,-4024.238,-3993.2246,-3947.9094,-3955.2622,-3945.7695,-3878.2913,-3860.7603,-3863.8928,-3855.4841,-3846.4526,-3861.5283,-3869.3206,-3871.0461,-3892.6023,-3914.6614,-3947.7593,-3994.5444,-4015.478,-4021.3105,-4067.344,-4114.485,-4166.5312};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {-4566.8374,-4600.3247,-4606.0503,-4591.4814,-4578.706,-4594.8354,-4593.866,-4561.985,-4680.6763,-4549.721,-4551.0693,-4556.906,-4565.9443,-4520.7227,-4515.882,-4523.491,-4520.6265,-4489.5864,-4485.1216,-4497.6704,-4503.648,-4496.1304,-4485.082,-4483.2896,-4474.502,-4477.947,-4444.4585,-4400.468,-4394.188,-4389.5635,-4419.514,-4417.8267,-4381.1626,-4331.5776,-4290.711,-4275.0537,-4194.0425,-4183.887,-4128.9453,-4105.9033,-4143.8394,-4142.3486,-4175.5273,-4196.057,-4178.5073,-4170.4165,-4156.0557,-4100.8604,-4067.923,-4049.4966,-4046.0605,-4043.697,-4059.638,-4073.0276,-4059.3323,-4082.4558,-4085.0864,-4146.184,-4208.8677,-4232.878,-4298.1724,-4277.54,-4338.5654,-4383.016,-4708.0815,-4709.232,-4728.5435,-4694.6055,-4678.5273,-4663.2964,-4653.6245,-4593.8496,-4538.8975,-4565.239,-4608.652,-4656.536,-4669.2007,-4624.0107,-4612.854,-4634.151,-4644.763,-4631.774,-4608.394,-4619.4736,-4635.681,-4626.798,-4619.855,-4607.4355,-4594.2515,-4620.2466,-4597.8643,-4546.36,-4498.041,-4452.9644,-4456.543,-4481.964,-4467.467,-4452.785,-4427.9663,-4439.7427};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {-4397.063,-4355.424,-4339.526,-4334.724,-4328.812,-4304.5312,-4336.1387,-4362.177,-4327.9253,-4303.464,-4269.382,-4312.0767,-4302.99,-4344.3706,-4287.8096,-4259.2495,-4265.6807,-4287.274,-4302.879,-4297.6665,-4329.206,-4360.807,-4391.8057,-4424.8228,-4454.5024,-4478.93,-4509.615,-4530.1396,-4747.29,-4764.45,-4759.978,-4784.0815,-4726.8325,-4727.82,-4737.6533,-4756.676,-4758.574,-4749.362,-4751.2427,-4753.08,-4739.248,-4752.239,-4739.4966,-4732.8833,-4756.1807,-4737.2163,-4702.737,-4747.1987,-4734.8003,-4708.979,-4709.9326,-4682.5034,-4650.15,-4670.5674,-4665.7065,-4633.3228,-4603.865,-4546.207,-4531.765,-4531.986,-4563.9316,-4565.8677,-4583.3726,-4545.0366,-4531.088,-4554.7065,-4618.998,-4563.8335,-4523.331,-4557.9106,-4531.8447,-4485.155,-4481.2256,-4445.975,-4425.8677,-4407.175,-4408.0493,-4416.6123,-4402.5415,-4396.444,-4420.18,-4442.1523,-4462.812,-4481.1304,-4508.908,-4536.103,-4565.4834,-4579.447,-4600.65,-4634.78,-4652.4937,-4682.836,-4799.5107,-4824.645,-4788.777,-4782.0586,-4770.1206,-4800.62,-4819.0664,-4835.87};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {-4797.1865,-4830.5205,-4828.3384,-4816.9946,-4822.3394,-4836.1704,-4824.435,-4810.62,-4829.517,-4838.6626,-4835.114,-4780.1167,-4767.493,-4792.5386,-4789.193,-4786.285,-4780.3604,-4787.629,-4751.12,-4730.6147,-4736.843,-4729.6143,-4726.023,-4758.57,-4809.5884,-4785.411,-4671.19,-4607.523,-4626.173,-4630.8154,-4624.846,-4605.21,-4595.6963,-4636.6035,-4625.6333,-4606.651,-4591.9487,-4597.298,-4666.237,-4662.837,-4600.7188,-4596.147,-4594.3584,-4577.0693,-4571.283,-4567.052,-4590.5645,-4618.471,-4626.261,-4637.8853,-4679.439,-4699.7773,-4720.525,-4750.5264,-4754.9326,-4755.1997,-4798.526,-4808.756,-4817.4536,-4817.357,-4804.007,-4798.3286,-4839.401,-4878.5107,-4838.3213,-4784.2397,-4863.4043,-4875.51,-4874.705,-4911.3657,-4917.3516,-4830.032,-4778.203,-4864.385,-4868.751,-4854.0474,-4865.225,-4850.431,-4856.076,-4817.119,-4721.803,-4713.0923,-4772.151,-4785.597,-4788.078,-4821.6167,-4849.504,-4896.4316,-4958.948,-4948.584,-4878.9673,-4774.939,-4733.2793,-4736.3745,-4737.5806,-4721.339,-4692.275,-4691.8213,-4711.7417,-4716.393};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {-4709.9263,-4743.945,-4769.713,-4740.053,-4717.075,-4713.492,-4693.859,-4703.037,-4688.831,-4651.286,-4657.5806,-4693.6885,-4723.3257,-4734.1694,-4739.572,-4752.4595,-4766.922,-4778.424,-4819.411,-4842.391,-4876.697,-4838.3486,-4813.5474,-4772.1016,-4745.338,-4741.336,-4761.856,-4790.229,-4816.7515,-4781.404,-4777.7227,-4738.1953,-4821.6885,-4910.008,-4929.324,-4919.81,-4891.723,-4864.997,-4855.6143,-4853.845,-4854.9556,-4770.2964,-4700.8296,-4750.07,-4726.0967,-4616.4395,-4721.277,-4762.844,-4734.672,-4722.8228,-4763.9307,-4911.28,-4971.2764,-4970.1143,-4952.2725,-4902.1533,-4856.3145,-4900.79,-4797.223,-4785.646,-4788.0635,-4801.8247,-4783.258,-4788.16,-4784.963,-4808.9126,-4782.5933,-4747.0947,-4743.2617,-4808.815,-4788.2295,-4784.731,-4766.9473,-4780.3745,-4796.0454,-4820.479,-4826.899,-4822.772,-4809.4336,-4798.0996,-4805.906,-4829.13,-4866.593,-4894.044,-4858.2266,-4837.105,-4802.626,-4816.997,-4788.983,-4748.7075,-4754.7666,-4786.708,-4765.5376,-4783.209,-4797.0405,-4813.077,-4836.7627,-4825.333,-4830.1323,-4804.0767};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-4842.8267,-4873.987,-4861.0215,-4817.883,-4804.886,-4810.6455,-4832.202,-4858.2397,-4885.82,-4886.6533,-4763.5454,-4754.634,-4848.6514,-4883.1226,-4867.3647,-4883.0986,-4915.5913,-4937.673,-4945.6206,-4935.4463,-4894.9966,-4900.7666,-4829.9976,-4798.6177,-4783.9116,-4794.1943,-4774.8022,-4800.998,-4807.865,-4818.152,-4861.902,-4880.571,-4860.851,-4855.934,-4855.775,-4849.8037,-4853.259,-4874.227,-4891.5664,-4893.647,-4880.054,-4870.8755,-4878.4023,-4905.445,-4899.1997,-4874.3794,-4855.588,-4886.023,-4587.1387,-4568.748,-4562.827,-4567.0396,-4566.8496,-4564.659,-4562.5996,-4560.3594,-4559.8896,-4558.1973,-4557.1753,-4554.0347,-4561.5728,-4572.9453,-4579.371,-4587.3076,-4603.506,-4595.9214,-4610.7666,-4624.4473,-4634.7534,-4637.21,-4640.2114,-4644.417,-4648.896,-4651.7715,-4654.221,-4655.286,-4662.5396,-4669.8,-4677.447,-4681.2666,-4698.1846,-4711.6333,-4738.97,-4727.047,-4718.6094,-4724.5723,-4728.3022,-4753.8423,-4763.686,-4790.459,-4807.4355,-4817.2373,-4826.3677,-4852.6436,-4874.875,-4857.385,-4825.935,-4838.7075,-4822.528,-4819.6675};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {-4817.1304,-4820.327,-4812.38,-4816.3315,-4862.702,-4880.6597,-4879.6626,-4873.4243,-4883.702,-4887.402,-4894.9185,-4903.798,-4308.9067,-4312.5474,-4320.719,-4338.872,-4349.554,-4331.984,-4359.447,-4316.5977,-4340.194,-4351.822,-4365.5386,-4376.891,-4386.542,-4397.1055,-4407.7144,-4418.396,-4428.915,-4439.6147,-4448.407,-4457.6846,-4464.902,-4472.643,-4479.833,-4486.62,-4493.775,-4501.255,-4508.7114,-4518.073,-4527.573,-4537.756,-4548.9243,-4562.258,-4575.6597,-4591.3774,-4603.8076,-4609.0854,-4608.3623,-4609.2617,-4615.6597,-4634.2236,-4677.3105,-4749.207,-4730.4023,-4762.6455,-4738.8247,-4722.887,-4698.654,-4544.617,-4444.4805,-4430.054,-4410.3623,-4401.956,-4396.7515,-4297.4443,-4292.7114,-4284.31,-4288.8335,-4340.681,-4395.026,-4496.229,-4548.4746,-4580.9077,-4588.688,-4605.2515,-4184.6626,-4186.3145,-4187.0884,-4188.7173,-4189.1987,-4188.3423,-4189.2007,-4192.986,-4198.799,-4207.2183,-4216.6333,-4227.805,-4240.8696,-4253.3916,-4265.843,-4276.6553,-4286.7207,-4296.521,-4305.8306,-4313.853,-4324.2524,-4335.9375,-4346.117,-4357.607};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {-4368.585,-4380.0386,-4388.494,-4397.517,-4406.8643,-4416.967,-4427.194,-4438.4146,-4433.18,-4412.744,-4389.634,-4378.9824,-4372.138,-4380.091,-4418.7837,-4464.0874,-4322.3877,-4213.615,-4153.512,-4074.5737,-4095.0977,-4145.394,-4092.435,-4057.7434,-4051.2751,-4049.2778,-4028.7036,-3953.8262,-3896.9082,-3929.6265,-3880.2522,-3838.4353,-3810.3303,-3796.99,-3797.1497,-3801.7625,-3794.6677,-3768.0015,-3759.845,-3770.6084,-4178.1577,-4172.9614,-4166.6943,-4165.91,-4164.495,-4165.5244,-4188.8516,-4224.4175,-4179.5654,-4183.3896,-4208.9697,-4201.864,-4157.107,-4094.049,-4068.2773,-4067.011,-4051.0588,-4057.145,-4102.3604,-4168.3594,-4146.1357,-4073.0933,-4025.528,-4000.1155,-3991.9185,-3998.1384,-4012.2578,-4002.3027,-3999.2307,-3965.9548,-3970.733,-3996.8638,-4027.4656,-4044.744,-4052.765,-4089.1248,-4149.354,-4208.1445,-4107.621,-4090.1768,-3982.921,-3816.6052,-3804.2031,-3767.9634,-3723.0105,-3748.5466,-3700.999,-3611.3337,-3556.3855,-3536.3796,-3513.3313,-3497.704,-3537.001,-3497.4834,-3408.3586,-3385.7986,-3358.1597,-3345.1426,-3341.6902,-3327.731};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {-3312.3882,-3302.5215,-3292.91,-3287.2336,-3883.2156,-3720.289,-3668.7566,-3647.9192,-3633.0396,-3614.6028,-3621.7134,-3622.7458,-3463.2698,-3430.5977,-3436.7837,-3381.9001,-3353.5574,-3358.009,-3377.4421,-3398.6172,-3408.5479,-3391.8613,-3347.1848,-3271.4153,-3211.8005,-3190.6094,-3177.38,-3164.0518,-3149.7373,-3147.9011,-3139.2578,-3100.7263,-3082.4553,-3174.3857,-3245.751,-3261.098,-3221.289,-3178.0469,-3191.3542,-3292.538,-3366.7422,-3405.674,-3323.7817,-3259.5754,-3204.0105,-3060.895,-3007.3118,-2957.6885,-2933.744,-2959.171,-2944.6794,-2910.0586,-2901.4307,-2929.1504,-2972.2942,-2989.9385,-2951.7063,-2935.1458,-2925.6436,-2924.7715,-2944.8945,-2943.5076,-2921.8933,-2919.346,-2930.018,-2938.6482,-2925.2478,-2911.0012,-2912.4548,-2962.0044,-2895.7698,-2889.9846,-2892.1401,-2917.9753,-2947.2566,-2941.0996,-2924.6123,-2878.5034,-2843.7239,-2829.288,-2841.815,-2847.565,-2842.0845,-2839.7048,-2856.6338,-2855.471,-2823.0144,-2784.4824,-2752.2478,-2740.9946,-2729.6443,-2730.5308,-2708.9312,-2686.3394,-2665.3242,-2654.76,-2662.3025,-2681.54,-2695.2483,-2685.66};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {-2686.5852,-2687.3047,-2677.9536,-2637.098,-2645.7822,-2639.5938,-2641.9304,-2633.1396,-2636.5986,-2641.3535,-2646.8296,-2635.885,-2620.7705,-2586.4763,-2576.9636,-2572.0269,-2565.4727,-2548.0789,-2528.699,-2515.4011,-2508.2173,-2509.5159,-2504.5535,-2507.1868,-2511.2397,-2490.9243,-2492.0254,-2516.472,-2513.8303,-2504.383,-2486.248,-2450.7612,-2458.0833,-2496.8923,-2452.7957,-2462.9116,-2471.1895,-2470.8967,-2443.3132,-2411.227,-2393.234,-2388.5088,-2381.7603,-2398.4343,-2424.7957,-2408.9895,-2361.6672,-2338.6326,-2338.2083,-2335.3354,-2324.942,-2323.0527,-2313.6265,-2308.8284,-2307.0872,-2316.6123,-2310.9246,-2303.7832,-2300.279,-2294.3777,-2283.6426,-2277.1497,-2274.3335,-2262.2634,-2260.745,-2259.9194,-2265.7007,-2259.224,-2284.2974,-2297.6055,-2287.396,-2266.3733,-2249.1782,-2234.5664,-2222.6506,-2201.3906,-2177.5342,-2143.759,-2131.5881,-2132.484,-2138.973,-2149.9368,-2157.3262,-2160.7551,-2140.9426,-2137.3394,-2155.9,-2132.2222,-2155.237,-2140.491,-2129.3867,-2134.1038,-2117.3281,-2101.546,-2085.9802,-2061.4817};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.01587,0.00391,0.03175,0.00391,0.04762,0.00391,0.06349,0.00391,0.07937,0.00391,0.09524,0.00391,0.11111,0.00391,0.12698,0.00391,0.14286,0.00391,0.15873,0.00391,0.1746,0.00391,0.19048,0.00391,0.20635,0.00391,0.22222,0.00391,0.2381,0.00391,0.25397,0.00391,0.26984,0.00391,0.28571,0.00391,0.30159,0.00391,0.31746,0.00391,0.33333,0.00391,0.34921,0.00391,0.36508,0.00391,0.38095,0.00391,0.39683,0.00391,0.4127,0.00391,0.42857,0.00391,0.44444,0.00391,0.46032,0.00391,0.47619,0.00391,0.49206,0.00391,0.50794,0.00391,0.52381,0.00391,0.53968,0.00391,0.55556,0.00391,0.57143,0.00391,0.5873,0.00391,0.60317,0.00391,0.61905,0.00391,0.63492,0.00391,0.65079,0.00391,0.66667,0.00391,0.68254,0.00391,0.69841,0.00391,0.71429,0.00391,0.73016,0.00391,0.74603,0.00391,0.7619,0.00391,0.77778,0.00391,0.79365,0.00391,0.80952,0.00391,0.8254,0.00391,0.84127,0.00391,0.85714,0.00391,0.87302,0.00391,0.88889,0.00391,0.90476,0.00391,0.92063,0.00391,0.93651,0.00391,0.95238,0.00391,0.96825,0.00391,0.98413,0.00391,0.99609,0.00391,0.00391,0.01587,0.01587,0.01587,0.03175,0.01587,0.04762,0.01587,0.06349,0.01587,0.07937,0.01587,0.09524,0.01587,0.11111,0.01587,0.12698,0.01587,0.14286,0.01587,0.15873,0.01587,0.1746,0.01587,0.19048,0.01587,0.20635,0.01587,0.22222,0.01587,0.2381,0.01587,0.25397,0.01587,0.26984,0.01587,0.28571,0.01587,0.30159,0.01587,0.31746,0.01587,0.33333,0.01587,0.34921,0.01587,0.36508,0.01587,0.38095,0.01587,0.39683,0.01587,0.4127,0.01587,0.42857,0.01587,0.44444,0.01587,0.46032,0.01587,0.47619,0.01587,0.49206,0.01587,0.50794,0.01587,0.52381,0.01587,0.53968,0.01587,0.55556,0.01587};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.57143,0.01587,0.5873,0.01587,0.60317,0.01587,0.61905,0.01587,0.63492,0.01587,0.65079,0.01587,0.66667,0.01587,0.68254,0.01587,0.69841,0.01587,0.71429,0.01587,0.73016,0.01587,0.74603,0.01587,0.7619,0.01587,0.77778,0.01587,0.79365,0.01587,0.80952,0.01587,0.8254,0.01587,0.84127,0.01587,0.85714,0.01587,0.87302,0.01587,0.88889,0.01587,0.90476,0.01587,0.92063,0.01587,0.93651,0.01587,0.95238,0.01587,0.96825,0.01587,0.98413,0.01587,0.99609,0.01587,0.00391,0.03175,0.01587,0.03175,0.03175,0.03175,0.04762,0.03175,0.06349,0.03175,0.07937,0.03175,0.09524,0.03175,0.11111,0.03175,0.12698,0.03175,0.14286,0.03175,0.15873,0.03175,0.1746,0.03175,0.19048,0.03175,0.20635,0.03175,0.22222,0.03175,0.2381,0.03175,0.25397,0.03175,0.26984,0.03175,0.28571,0.03175,0.30159,0.03175,0.31746,0.03175,0.33333,0.03175,0.34921,0.03175,0.36508,0.03175,0.38095,0.03175,0.39683,0.03175,0.4127,0.03175,0.42857,0.03175,0.44444,0.03175,0.46032,0.03175,0.47619,0.03175,0.49206,0.03175,0.50794,0.03175,0.52381,0.03175,0.53968,0.03175,0.55556,0.03175,0.57143,0.03175,0.5873,0.03175,0.60317,0.03175,0.61905,0.03175,0.63492,0.03175,0.65079,0.03175,0.66667,0.03175,0.68254,0.03175,0.69841,0.03175,0.71429,0.03175,0.73016,0.03175,0.74603,0.03175,0.7619,0.03175,0.77778,0.03175,0.79365,0.03175,0.80952,0.03175,0.8254,0.03175,0.84127,0.03175,0.85714,0.03175,0.87302,0.03175,0.88889,0.03175,0.90476,0.03175,0.92063,0.03175,0.93651,0.03175,0.95238,0.03175,0.96825,0.03175,0.98413,0.03175,0.99609,0.03175,0.00391,0.04762,0.01587,0.04762,0.03175,0.04762,0.04762,0.04762,0.06349,0.04762,0.07937,0.04762,0.09524,0.04762,0.11111,0.04762};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.12698,0.04762,0.14286,0.04762,0.15873,0.04762,0.1746,0.04762,0.19048,0.04762,0.20635,0.04762,0.22222,0.04762,0.2381,0.04762,0.25397,0.04762,0.26984,0.04762,0.28571,0.04762,0.30159,0.04762,0.31746,0.04762,0.33333,0.04762,0.34921,0.04762,0.36508,0.04762,0.38095,0.04762,0.39683,0.04762,0.4127,0.04762,0.42857,0.04762,0.44444,0.04762,0.46032,0.04762,0.47619,0.04762,0.49206,0.04762,0.50794,0.04762,0.52381,0.04762,0.53968,0.04762,0.55556,0.04762,0.57143,0.04762,0.5873,0.04762,0.60317,0.04762,0.61905,0.04762,0.63492,0.04762,0.65079,0.04762,0.66667,0.04762,0.68254,0.04762,0.69841,0.04762,0.71429,0.04762,0.73016,0.04762,0.74603,0.04762,0.7619,0.04762,0.77778,0.04762,0.79365,0.04762,0.80952,0.04762,0.8254,0.04762,0.84127,0.04762,0.85714,0.04762,0.87302,0.04762,0.88889,0.04762,0.90476,0.04762,0.92063,0.04762,0.93651,0.04762,0.95238,0.04762,0.96825,0.04762,0.98413,0.04762,0.99609,0.04762,0.00391,0.06349,0.01587,0.06349,0.03175,0.06349,0.04762,0.06349,0.06349,0.06349,0.07937,0.06349,0.09524,0.06349,0.11111,0.06349,0.12698,0.06349,0.14286,0.06349,0.15873,0.06349,0.1746,0.06349,0.19048,0.06349,0.20635,0.06349,0.22222,0.06349,0.2381,0.06349,0.25397,0.06349,0.26984,0.06349,0.28571,0.06349,0.30159,0.06349,0.31746,0.06349,0.33333,0.06349,0.34921,0.06349,0.36508,0.06349,0.38095,0.06349,0.39683,0.06349,0.4127,0.06349,0.42857,0.06349,0.44444,0.06349,0.46032,0.06349,0.47619,0.06349,0.49206,0.06349,0.50794,0.06349,0.52381,0.06349,0.53968,0.06349,0.55556,0.06349,0.57143,0.06349,0.5873,0.06349,0.60317,0.06349,0.61905,0.06349,0.63492,0.06349,0.65079,0.06349,0.66667,0.06349,0.68254,0.06349};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.69841,0.06349,0.71429,0.06349,0.73016,0.06349,0.74603,0.06349,0.7619,0.06349,0.77778,0.06349,0.79365,0.06349,0.80952,0.06349,0.8254,0.06349,0.84127,0.06349,0.85714,0.06349,0.87302,0.06349,0.88889,0.06349,0.90476,0.06349,0.92063,0.06349,0.93651,0.06349,0.95238,0.06349,0.96825,0.06349,0.98413,0.06349,0.99609,0.06349,0.00391,0.07937,0.01587,0.07937,0.03175,0.07937,0.04762,0.07937,0.06349,0.07937,0.07937,0.07937,0.09524,0.07937,0.11111,0.07937,0.12698,0.07937,0.14286,0.07937,0.15873,0.07937,0.1746,0.07937,0.19048,0.07937,0.20635,0.07937,0.22222,0.07937,0.2381,0.07937,0.25397,0.07937,0.26984,0.07937,0.28571,0.07937,0.30159,0.07937,0.31746,0.07937,0.33333,0.07937,0.34921,0.07937,0.36508,0.07937,0.38095,0.07937,0.39683,0.07937,0.4127,0.07937,0.42857,0.07937,0.44444,0.07937,0.46032,0.07937,0.47619,0.07937,0.49206,0.07937,0.50794,0.07937,0.52381,0.07937,0.53968,0.07937,0.55556,0.07937,0.57143,0.07937,0.5873,0.07937,0.60317,0.07937,0.61905,0.07937,0.63492,0.07937,0.65079,0.07937,0.66667,0.07937,0.68254,0.07937,0.69841,0.07937,0.71429,0.07937,0.73016,0.07937,0.74603,0.07937,0.7619,0.07937,0.77778,0.07937,0.79365,0.07937,0.80952,0.07937,0.8254,0.07937,0.84127,0.07937,0.85714,0.07937,0.87302,0.07937,0.88889,0.07937,0.90476,0.07937,0.92063,0.07937,0.93651,0.07937,0.95238,0.07937,0.96825,0.07937,0.98413,0.07937,0.99609,0.07937,0.00391,0.09524,0.01587,0.09524,0.03175,0.09524,0.04762,0.09524,0.06349,0.09524,0.07937,0.09524,0.09524,0.09524,0.11111,0.09524,0.12698,0.09524,0.14286,0.09524,0.15873,0.09524,0.1746,0.09524,0.19048,0.09524,0.20635,0.09524,0.22222,0.09524,0.2381,0.09524};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.25397,0.09524,0.26984,0.09524,0.28571,0.09524,0.30159,0.09524,0.31746,0.09524,0.33333,0.09524,0.34921,0.09524,0.36508,0.09524,0.38095,0.09524,0.39683,0.09524,0.4127,0.09524,0.42857,0.09524,0.44444,0.09524,0.46032,0.09524,0.47619,0.09524,0.49206,0.09524,0.50794,0.09524,0.52381,0.09524,0.53968,0.09524,0.55556,0.09524,0.57143,0.09524,0.5873,0.09524,0.60317,0.09524,0.61905,0.09524,0.63492,0.09524,0.65079,0.09524,0.66667,0.09524,0.68254,0.09524,0.69841,0.09524,0.71429,0.09524,0.73016,0.09524,0.74603,0.09524,0.7619,0.09524,0.77778,0.09524,0.79365,0.09524,0.80952,0.09524,0.8254,0.09524,0.84127,0.09524,0.85714,0.09524,0.87302,0.09524,0.88889,0.09524,0.90476,0.09524,0.92063,0.09524,0.93651,0.09524,0.95238,0.09524,0.96825,0.09524,0.98413,0.09524,0.99609,0.09524,0.00391,0.11111,0.01587,0.11111,0.03175,0.11111,0.04762,0.11111,0.06349,0.11111,0.07937,0.11111,0.09524,0.11111,0.11111,0.11111,0.12698,0.11111,0.14286,0.11111,0.15873,0.11111,0.1746,0.11111,0.19048,0.11111,0.20635,0.11111,0.22222,0.11111,0.2381,0.11111,0.25397,0.11111,0.26984,0.11111,0.28571,0.11111,0.30159,0.11111,0.31746,0.11111,0.33333,0.11111,0.34921,0.11111,0.36508,0.11111,0.38095,0.11111,0.39683,0.11111,0.4127,0.11111,0.42857,0.11111,0.44444,0.11111,0.46032,0.11111,0.47619,0.11111,0.49206,0.11111,0.50794,0.11111,0.52381,0.11111,0.53968,0.11111,0.55556,0.11111,0.57143,0.11111,0.5873,0.11111,0.60317,0.11111,0.61905,0.11111,0.63492,0.11111,0.65079,0.11111,0.66667,0.11111,0.68254,0.11111,0.69841,0.11111,0.71429,0.11111,0.73016,0.11111,0.74603,0.11111,0.7619,0.11111,0.77778,0.11111,0.79365,0.11111,0.80952,0.11111};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.8254,0.11111,0.84127,0.11111,0.85714,0.11111,0.87302,0.11111,0.88889,0.11111,0.90476,0.11111,0.92063,0.11111,0.93651,0.11111,0.95238,0.11111,0.96825,0.11111,0.98413,0.11111,0.99609,0.11111,0.00391,0.12698,0.01587,0.12698,0.03175,0.12698,0.04762,0.12698,0.06349,0.12698,0.07937,0.12698,0.09524,0.12698,0.11111,0.12698,0.12698,0.12698,0.14286,0.12698,0.15873,0.12698,0.1746,0.12698,0.19048,0.12698,0.20635,0.12698,0.22222,0.12698,0.2381,0.12698,0.25397,0.12698,0.26984,0.12698,0.28571,0.12698,0.30159,0.12698,0.31746,0.12698,0.33333,0.12698,0.34921,0.12698,0.36508,0.12698,0.38095,0.12698,0.39683,0.12698,0.4127,0.12698,0.42857,0.12698,0.44444,0.12698,0.46032,0.12698,0.47619,0.12698,0.49206,0.12698,0.50794,0.12698,0.52381,0.12698,0.53968,0.12698,0.55556,0.12698,0.57143,0.12698,0.5873,0.12698,0.60317,0.12698,0.61905,0.12698,0.63492,0.12698,0.65079,0.12698,0.66667,0.12698,0.68254,0.12698,0.69841,0.12698,0.71429,0.12698,0.73016,0.12698,0.74603,0.12698,0.7619,0.12698,0.77778,0.12698,0.79365,0.12698,0.80952,0.12698,0.8254,0.12698,0.84127,0.12698,0.85714,0.12698,0.87302,0.12698,0.88889,0.12698,0.90476,0.12698,0.92063,0.12698,0.93651,0.12698,0.95238,0.12698,0.96825,0.12698,0.98413,0.12698,0.99609,0.12698,0.00391,0.14286,0.01587,0.14286,0.03175,0.14286,0.04762,0.14286,0.06349,0.14286,0.07937,0.14286,0.09524,0.14286,0.11111,0.14286,0.12698,0.14286,0.14286,0.14286,0.15873,0.14286,0.1746,0.14286,0.19048,0.14286,0.20635,0.14286,0.22222,0.14286,0.2381,0.14286,0.25397,0.14286,0.26984,0.14286,0.28571,0.14286,0.30159,0.14286,0.31746,0.14286,0.33333,0.14286,0.34921,0.14286,0.36508,0.14286};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.38095,0.14286,0.39683,0.14286,0.4127,0.14286,0.42857,0.14286,0.44444,0.14286,0.46032,0.14286,0.47619,0.14286,0.49206,0.14286,0.50794,0.14286,0.52381,0.14286,0.53968,0.14286,0.55556,0.14286,0.57143,0.14286,0.5873,0.14286,0.60317,0.14286,0.61905,0.14286,0.63492,0.14286,0.65079,0.14286,0.66667,0.14286,0.68254,0.14286,0.69841,0.14286,0.71429,0.14286,0.73016,0.14286,0.74603,0.14286,0.7619,0.14286,0.77778,0.14286,0.79365,0.14286,0.80952,0.14286,0.8254,0.14286,0.84127,0.14286,0.85714,0.14286,0.87302,0.14286,0.88889,0.14286,0.90476,0.14286,0.92063,0.14286,0.93651,0.14286,0.95238,0.14286,0.96825,0.14286,0.98413,0.14286,0.99609,0.14286,0.00391,0.15873,0.01587,0.15873,0.03175,0.15873,0.04762,0.15873,0.06349,0.15873,0.07937,0.15873,0.09524,0.15873,0.11111,0.15873,0.12698,0.15873,0.14286,0.15873,0.15873,0.15873,0.1746,0.15873,0.19048,0.15873,0.20635,0.15873,0.22222,0.15873,0.2381,0.15873,0.25397,0.15873,0.26984,0.15873,0.28571,0.15873,0.30159,0.15873,0.31746,0.15873,0.33333,0.15873,0.34921,0.15873,0.36508,0.15873,0.38095,0.15873,0.39683,0.15873,0.4127,0.15873,0.42857,0.15873,0.44444,0.15873,0.46032,0.15873,0.47619,0.15873,0.49206,0.15873,0.50794,0.15873,0.52381,0.15873,0.53968,0.15873,0.55556,0.15873,0.57143,0.15873,0.5873,0.15873,0.60317,0.15873,0.61905,0.15873,0.63492,0.15873,0.65079,0.15873,0.66667,0.15873,0.68254,0.15873,0.69841,0.15873,0.71429,0.15873,0.73016,0.15873,0.74603,0.15873,0.7619,0.15873,0.77778,0.15873,0.79365,0.15873,0.80952,0.15873,0.8254,0.15873,0.84127,0.15873,0.85714,0.15873,0.87302,0.15873,0.88889,0.15873,0.90476,0.15873,0.92063,0.15873,0.93651,0.15873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.95238,0.15873,0.96825,0.15873,0.98413,0.15873,0.99609,0.15873,0.00391,0.1746,0.01587,0.1746,0.03175,0.1746,0.04762,0.1746,0.06349,0.1746,0.07937,0.1746,0.09524,0.1746,0.11111,0.1746,0.12698,0.1746,0.14286,0.1746,0.15873,0.1746,0.1746,0.1746,0.19048,0.1746,0.20635,0.1746,0.22222,0.1746,0.2381,0.1746,0.25397,0.1746,0.26984,0.1746,0.28571,0.1746,0.30159,0.1746,0.31746,0.1746,0.33333,0.1746,0.34921,0.1746,0.36508,0.1746,0.38095,0.1746,0.39683,0.1746,0.4127,0.1746,0.42857,0.1746,0.44444,0.1746,0.46032,0.1746,0.47619,0.1746,0.49206,0.1746,0.50794,0.1746,0.52381,0.1746,0.53968,0.1746,0.55556,0.1746,0.57143,0.1746,0.5873,0.1746,0.60317,0.1746,0.61905,0.1746,0.63492,0.1746,0.65079,0.1746,0.66667,0.1746,0.68254,0.1746,0.69841,0.1746,0.71429,0.1746,0.73016,0.1746,0.74603,0.1746,0.7619,0.1746,0.77778,0.1746,0.79365,0.1746,0.80952,0.1746,0.8254,0.1746,0.84127,0.1746,0.85714,0.1746,0.87302,0.1746,0.88889,0.1746,0.90476,0.1746,0.92063,0.1746,0.93651,0.1746,0.95238,0.1746,0.96825,0.1746,0.98413,0.1746,0.99609,0.1746,0.00391,0.19048,0.01587,0.19048,0.03175,0.19048,0.04762,0.19048,0.06349,0.19048,0.07937,0.19048,0.09524,0.19048,0.11111,0.19048,0.12698,0.19048,0.14286,0.19048,0.15873,0.19048,0.1746,0.19048,0.19048,0.19048,0.20635,0.19048,0.22222,0.19048,0.2381,0.19048,0.25397,0.19048,0.26984,0.19048,0.28571,0.19048,0.30159,0.19048,0.31746,0.19048,0.33333,0.19048,0.34921,0.19048,0.36508,0.19048,0.38095,0.19048,0.39683,0.19048,0.4127,0.19048,0.42857,0.19048,0.44444,0.19048,0.46032,0.19048,0.47619,0.19048,0.49206,0.19048};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.50794,0.19048,0.52381,0.19048,0.53968,0.19048,0.55556,0.19048,0.57143,0.19048,0.5873,0.19048,0.60317,0.19048,0.61905,0.19048,0.63492,0.19048,0.65079,0.19048,0.66667,0.19048,0.68254,0.19048,0.69841,0.19048,0.71429,0.19048,0.73016,0.19048,0.74603,0.19048,0.7619,0.19048,0.77778,0.19048,0.79365,0.19048,0.80952,0.19048,0.8254,0.19048,0.84127,0.19048,0.85714,0.19048,0.87302,0.19048,0.88889,0.19048,0.90476,0.19048,0.92063,0.19048,0.93651,0.19048,0.95238,0.19048,0.96825,0.19048,0.98413,0.19048,0.99609,0.19048,0.00391,0.20635,0.01587,0.20635,0.03175,0.20635,0.04762,0.20635,0.06349,0.20635,0.07937,0.20635,0.09524,0.20635,0.11111,0.20635,0.12698,0.20635,0.14286,0.20635,0.15873,0.20635,0.1746,0.20635,0.19048,0.20635,0.20635,0.20635,0.22222,0.20635,0.2381,0.20635,0.25397,0.20635,0.26984,0.20635,0.28571,0.20635,0.30159,0.20635,0.31746,0.20635,0.33333,0.20635,0.34921,0.20635,0.36508,0.20635,0.38095,0.20635,0.39683,0.20635,0.4127,0.20635,0.42857,0.20635,0.44444,0.20635,0.46032,0.20635,0.47619,0.20635,0.49206,0.20635,0.50794,0.20635,0.52381,0.20635,0.53968,0.20635,0.55556,0.20635,0.57143,0.20635,0.5873,0.20635,0.60317,0.20635,0.61905,0.20635,0.63492,0.20635,0.65079,0.20635,0.66667,0.20635,0.68254,0.20635,0.69841,0.20635,0.71429,0.20635,0.73016,0.20635,0.74603,0.20635,0.7619,0.20635,0.77778,0.20635,0.79365,0.20635,0.80952,0.20635,0.8254,0.20635,0.84127,0.20635,0.85714,0.20635,0.87302,0.20635,0.88889,0.20635,0.90476,0.20635,0.92063,0.20635,0.93651,0.20635,0.95238,0.20635,0.96825,0.20635,0.98413,0.20635,0.99609,0.20635,0.00391,0.22222,0.01587,0.22222,0.03175,0.22222,0.04762,0.22222};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.06349,0.22222,0.07937,0.22222,0.09524,0.22222,0.11111,0.22222,0.12698,0.22222,0.14286,0.22222,0.15873,0.22222,0.1746,0.22222,0.19048,0.22222,0.20635,0.22222,0.22222,0.22222,0.2381,0.22222,0.25397,0.22222,0.26984,0.22222,0.28571,0.22222,0.30159,0.22222,0.31746,0.22222,0.33333,0.22222,0.34921,0.22222,0.36508,0.22222,0.38095,0.22222,0.39683,0.22222,0.4127,0.22222,0.42857,0.22222,0.44444,0.22222,0.46032,0.22222,0.47619,0.22222,0.49206,0.22222,0.50794,0.22222,0.52381,0.22222,0.53968,0.22222,0.55556,0.22222,0.57143,0.22222,0.5873,0.22222,0.60317,0.22222,0.61905,0.22222,0.63492,0.22222,0.65079,0.22222,0.66667,0.22222,0.68254,0.22222,0.69841,0.22222,0.71429,0.22222,0.73016,0.22222,0.74603,0.22222,0.7619,0.22222,0.77778,0.22222,0.79365,0.22222,0.80952,0.22222,0.8254,0.22222,0.84127,0.22222,0.85714,0.22222,0.87302,0.22222,0.88889,0.22222,0.90476,0.22222,0.92063,0.22222,0.93651,0.22222,0.95238,0.22222,0.96825,0.22222,0.98413,0.22222,0.99609,0.22222,0.00391,0.2381,0.01587,0.2381,0.03175,0.2381,0.04762,0.2381,0.06349,0.2381,0.07937,0.2381,0.09524,0.2381,0.11111,0.2381,0.12698,0.2381,0.14286,0.2381,0.15873,0.2381,0.1746,0.2381,0.19048,0.2381,0.20635,0.2381,0.22222,0.2381,0.2381,0.2381,0.25397,0.2381,0.26984,0.2381,0.28571,0.2381,0.30159,0.2381,0.31746,0.2381,0.33333,0.2381,0.34921,0.2381,0.36508,0.2381,0.38095,0.2381,0.39683,0.2381,0.4127,0.2381,0.42857,0.2381,0.44444,0.2381,0.46032,0.2381,0.47619,0.2381,0.49206,0.2381,0.50794,0.2381,0.52381,0.2381,0.53968,0.2381,0.55556,0.2381,0.57143,0.2381,0.5873,0.2381,0.60317,0.2381,0.61905,0.2381};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.63492,0.2381,0.65079,0.2381,0.66667,0.2381,0.68254,0.2381,0.69841,0.2381,0.71429,0.2381,0.73016,0.2381,0.74603,0.2381,0.7619,0.2381,0.77778,0.2381,0.79365,0.2381,0.80952,0.2381,0.8254,0.2381,0.84127,0.2381,0.85714,0.2381,0.87302,0.2381,0.88889,0.2381,0.90476,0.2381,0.92063,0.2381,0.93651,0.2381,0.95238,0.2381,0.96825,0.2381,0.98413,0.2381,0.99609,0.2381,0.00391,0.25397,0.01587,0.25397,0.03175,0.25397,0.04762,0.25397,0.06349,0.25397,0.07937,0.25397,0.09524,0.25397,0.11111,0.25397,0.12698,0.25397,0.14286,0.25397,0.15873,0.25397,0.1746,0.25397,0.19048,0.25397,0.20635,0.25397,0.22222,0.25397,0.2381,0.25397,0.25397,0.25397,0.26984,0.25397,0.28571,0.25397,0.30159,0.25397,0.31746,0.25397,0.33333,0.25397,0.34921,0.25397,0.36508,0.25397,0.38095,0.25397,0.39683,0.25397,0.4127,0.25397,0.42857,0.25397,0.44444,0.25397,0.46032,0.25397,0.47619,0.25397,0.49206,0.25397,0.50794,0.25397,0.52381,0.25397,0.53968,0.25397,0.55556,0.25397,0.57143,0.25397,0.5873,0.25397,0.60317,0.25397,0.61905,0.25397,0.63492,0.25397,0.65079,0.25397,0.66667,0.25397,0.68254,0.25397,0.69841,0.25397,0.71429,0.25397,0.73016,0.25397,0.74603,0.25397,0.7619,0.25397,0.77778,0.25397,0.79365,0.25397,0.80952,0.25397,0.8254,0.25397,0.84127,0.25397,0.85714,0.25397,0.87302,0.25397,0.88889,0.25397,0.90476,0.25397,0.92063,0.25397,0.93651,0.25397,0.95238,0.25397,0.96825,0.25397,0.98413,0.25397,0.99609,0.25397,0.00391,0.26984,0.01587,0.26984,0.03175,0.26984,0.04762,0.26984,0.06349,0.26984,0.07937,0.26984,0.09524,0.26984,0.11111,0.26984,0.12698,0.26984,0.14286,0.26984,0.15873,0.26984,0.1746,0.26984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.19048,0.26984,0.20635,0.26984,0.22222,0.26984,0.2381,0.26984,0.25397,0.26984,0.26984,0.26984,0.28571,0.26984,0.30159,0.26984,0.31746,0.26984,0.33333,0.26984,0.34921,0.26984,0.36508,0.26984,0.38095,0.26984,0.39683,0.26984,0.4127,0.26984,0.42857,0.26984,0.44444,0.26984,0.46032,0.26984,0.47619,0.26984,0.49206,0.26984,0.50794,0.26984,0.52381,0.26984,0.53968,0.26984,0.55556,0.26984,0.57143,0.26984,0.5873,0.26984,0.60317,0.26984,0.61905,0.26984,0.63492,0.26984,0.65079,0.26984,0.66667,0.26984,0.68254,0.26984,0.69841,0.26984,0.71429,0.26984,0.73016,0.26984,0.74603,0.26984,0.7619,0.26984,0.77778,0.26984,0.79365,0.26984,0.80952,0.26984,0.8254,0.26984,0.84127,0.26984,0.85714,0.26984,0.87302,0.26984,0.88889,0.26984,0.90476,0.26984,0.92063,0.26984,0.93651,0.26984,0.95238,0.26984,0.96825,0.26984,0.98413,0.26984,0.99609,0.26984,0.00391,0.28571,0.01587,0.28571,0.03175,0.28571,0.04762,0.28571,0.06349,0.28571,0.07937,0.28571,0.09524,0.28571,0.11111,0.28571,0.12698,0.28571,0.14286,0.28571,0.15873,0.28571,0.1746,0.28571,0.19048,0.28571,0.20635,0.28571,0.22222,0.28571,0.2381,0.28571,0.25397,0.28571,0.26984,0.28571,0.28571,0.28571,0.30159,0.28571,0.31746,0.28571,0.33333,0.28571,0.34921,0.28571,0.36508,0.28571,0.38095,0.28571,0.39683,0.28571,0.4127,0.28571,0.42857,0.28571,0.44444,0.28571,0.46032,0.28571,0.47619,0.28571,0.49206,0.28571,0.50794,0.28571,0.52381,0.28571,0.53968,0.28571,0.55556,0.28571,0.57143,0.28571,0.5873,0.28571,0.60317,0.28571,0.61905,0.28571,0.63492,0.28571,0.65079,0.28571,0.66667,0.28571,0.68254,0.28571,0.69841,0.28571,0.71429,0.28571,0.73016,0.28571,0.74603,0.28571};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.7619,0.28571,0.77778,0.28571,0.79365,0.28571,0.80952,0.28571,0.8254,0.28571,0.84127,0.28571,0.85714,0.28571,0.87302,0.28571,0.88889,0.28571,0.90476,0.28571,0.92063,0.28571,0.93651,0.28571,0.95238,0.28571,0.96825,0.28571,0.98413,0.28571,0.99609,0.28571,0.00391,0.30159,0.01587,0.30159,0.03175,0.30159,0.04762,0.30159,0.06349,0.30159,0.07937,0.30159,0.09524,0.30159,0.11111,0.30159,0.12698,0.30159,0.14286,0.30159,0.15873,0.30159,0.1746,0.30159,0.19048,0.30159,0.20635,0.30159,0.22222,0.30159,0.2381,0.30159,0.25397,0.30159,0.26984,0.30159,0.28571,0.30159,0.30159,0.30159,0.31746,0.30159,0.33333,0.30159,0.34921,0.30159,0.36508,0.30159,0.38095,0.30159,0.39683,0.30159,0.4127,0.30159,0.42857,0.30159,0.44444,0.30159,0.46032,0.30159,0.47619,0.30159,0.49206,0.30159,0.50794,0.30159,0.52381,0.30159,0.53968,0.30159,0.55556,0.30159,0.57143,0.30159,0.5873,0.30159,0.60317,0.30159,0.61905,0.30159,0.63492,0.30159,0.65079,0.30159,0.66667,0.30159,0.68254,0.30159,0.69841,0.30159,0.71429,0.30159,0.73016,0.30159,0.74603,0.30159,0.7619,0.30159,0.77778,0.30159,0.79365,0.30159,0.80952,0.30159,0.8254,0.30159,0.84127,0.30159,0.85714,0.30159,0.87302,0.30159,0.88889,0.30159,0.90476,0.30159,0.92063,0.30159,0.93651,0.30159,0.95238,0.30159,0.96825,0.30159,0.98413,0.30159,0.99609,0.30159,0.00391,0.31746,0.01587,0.31746,0.03175,0.31746,0.04762,0.31746,0.06349,0.31746,0.07937,0.31746,0.09524,0.31746,0.11111,0.31746,0.12698,0.31746,0.14286,0.31746,0.15873,0.31746,0.1746,0.31746,0.19048,0.31746,0.20635,0.31746,0.22222,0.31746,0.2381,0.31746,0.25397,0.31746,0.26984,0.31746,0.28571,0.31746,0.30159,0.31746};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.31746,0.31746,0.33333,0.31746,0.34921,0.31746,0.36508,0.31746,0.38095,0.31746,0.39683,0.31746,0.4127,0.31746,0.42857,0.31746,0.44444,0.31746,0.46032,0.31746,0.47619,0.31746,0.49206,0.31746,0.50794,0.31746,0.52381,0.31746,0.53968,0.31746,0.55556,0.31746,0.57143,0.31746,0.5873,0.31746,0.60317,0.31746,0.61905,0.31746,0.63492,0.31746,0.65079,0.31746,0.66667,0.31746,0.68254,0.31746,0.69841,0.31746,0.71429,0.31746,0.73016,0.31746,0.74603,0.31746,0.7619,0.31746,0.77778,0.31746,0.79365,0.31746,0.80952,0.31746,0.8254,0.31746,0.84127,0.31746,0.85714,0.31746,0.87302,0.31746,0.88889,0.31746,0.90476,0.31746,0.92063,0.31746,0.93651,0.31746,0.95238,0.31746,0.96825,0.31746,0.98413,0.31746,0.99609,0.31746,0.00391,0.33333,0.01587,0.33333,0.03175,0.33333,0.04762,0.33333,0.06349,0.33333,0.07937,0.33333,0.09524,0.33333,0.11111,0.33333,0.12698,0.33333,0.14286,0.33333,0.15873,0.33333,0.1746,0.33333,0.19048,0.33333,0.20635,0.33333,0.22222,0.33333,0.2381,0.33333,0.25397,0.33333,0.26984,0.33333,0.28571,0.33333,0.30159,0.33333,0.31746,0.33333,0.33333,0.33333,0.34921,0.33333,0.36508,0.33333,0.38095,0.33333,0.39683,0.33333,0.4127,0.33333,0.42857,0.33333,0.44444,0.33333,0.46032,0.33333,0.47619,0.33333,0.49206,0.33333,0.50794,0.33333,0.52381,0.33333,0.53968,0.33333,0.55556,0.33333,0.57143,0.33333,0.5873,0.33333,0.60317,0.33333,0.61905,0.33333,0.63492,0.33333,0.65079,0.33333,0.66667,0.33333,0.68254,0.33333,0.69841,0.33333,0.71429,0.33333,0.73016,0.33333,0.74603,0.33333,0.7619,0.33333,0.77778,0.33333,0.79365,0.33333,0.80952,0.33333,0.8254,0.33333,0.84127,0.33333,0.85714,0.33333,0.87302,0.33333};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.88889,0.33333,0.90476,0.33333,0.92063,0.33333,0.93651,0.33333,0.95238,0.33333,0.96825,0.33333,0.98413,0.33333,0.99609,0.33333,0.00391,0.34921,0.01587,0.34921,0.03175,0.34921,0.04762,0.34921,0.06349,0.34921,0.07937,0.34921,0.09524,0.34921,0.11111,0.34921,0.12698,0.34921,0.14286,0.34921,0.15873,0.34921,0.1746,0.34921,0.19048,0.34921,0.20635,0.34921,0.22222,0.34921,0.2381,0.34921,0.25397,0.34921,0.26984,0.34921,0.28571,0.34921,0.30159,0.34921,0.31746,0.34921,0.33333,0.34921,0.34921,0.34921,0.36508,0.34921,0.38095,0.34921,0.39683,0.34921,0.4127,0.34921,0.42857,0.34921,0.44444,0.34921,0.46032,0.34921,0.47619,0.34921,0.49206,0.34921,0.50794,0.34921,0.52381,0.34921,0.53968,0.34921,0.55556,0.34921,0.57143,0.34921,0.5873,0.34921,0.60317,0.34921,0.61905,0.34921,0.63492,0.34921,0.65079,0.34921,0.66667,0.34921,0.68254,0.34921,0.69841,0.34921,0.71429,0.34921,0.73016,0.34921,0.74603,0.34921,0.7619,0.34921,0.77778,0.34921,0.79365,0.34921,0.80952,0.34921,0.8254,0.34921,0.84127,0.34921,0.85714,0.34921,0.87302,0.34921,0.88889,0.34921,0.90476,0.34921,0.92063,0.34921,0.93651,0.34921,0.95238,0.34921,0.96825,0.34921,0.98413,0.34921,0.99609,0.34921,0.00391,0.36508,0.01587,0.36508,0.03175,0.36508,0.04762,0.36508,0.06349,0.36508,0.07937,0.36508,0.09524,0.36508,0.11111,0.36508,0.12698,0.36508,0.14286,0.36508,0.15873,0.36508,0.1746,0.36508,0.19048,0.36508,0.20635,0.36508,0.22222,0.36508,0.2381,0.36508,0.25397,0.36508,0.26984,0.36508,0.28571,0.36508,0.30159,0.36508,0.31746,0.36508,0.33333,0.36508,0.34921,0.36508,0.36508,0.36508,0.38095,0.36508,0.39683,0.36508,0.4127,0.36508,0.42857,0.36508};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.44444,0.36508,0.46032,0.36508,0.47619,0.36508,0.49206,0.36508,0.50794,0.36508,0.52381,0.36508,0.53968,0.36508,0.55556,0.36508,0.57143,0.36508,0.5873,0.36508,0.60317,0.36508,0.61905,0.36508,0.63492,0.36508,0.65079,0.36508,0.66667,0.36508,0.68254,0.36508,0.69841,0.36508,0.71429,0.36508,0.73016,0.36508,0.74603,0.36508,0.7619,0.36508,0.77778,0.36508,0.79365,0.36508,0.80952,0.36508,0.8254,0.36508,0.84127,0.36508,0.85714,0.36508,0.87302,0.36508,0.88889,0.36508,0.90476,0.36508,0.92063,0.36508,0.93651,0.36508,0.95238,0.36508,0.96825,0.36508,0.98413,0.36508,0.99609,0.36508,0.00391,0.38095,0.01587,0.38095,0.03175,0.38095,0.04762,0.38095,0.06349,0.38095,0.07937,0.38095,0.09524,0.38095,0.11111,0.38095,0.12698,0.38095,0.14286,0.38095,0.15873,0.38095,0.1746,0.38095,0.19048,0.38095,0.20635,0.38095,0.22222,0.38095,0.2381,0.38095,0.25397,0.38095,0.26984,0.38095,0.28571,0.38095,0.30159,0.38095,0.31746,0.38095,0.33333,0.38095,0.34921,0.38095,0.36508,0.38095,0.38095,0.38095,0.39683,0.38095,0.4127,0.38095,0.42857,0.38095,0.44444,0.38095,0.46032,0.38095,0.47619,0.38095,0.49206,0.38095,0.50794,0.38095,0.52381,0.38095,0.53968,0.38095,0.55556,0.38095,0.57143,0.38095,0.5873,0.38095,0.60317,0.38095,0.61905,0.38095,0.63492,0.38095,0.65079,0.38095,0.66667,0.38095,0.68254,0.38095,0.69841,0.38095,0.71429,0.38095,0.73016,0.38095,0.74603,0.38095,0.7619,0.38095,0.77778,0.38095,0.79365,0.38095,0.80952,0.38095,0.8254,0.38095,0.84127,0.38095,0.85714,0.38095,0.87302,0.38095,0.88889,0.38095,0.90476,0.38095,0.92063,0.38095,0.93651,0.38095,0.95238,0.38095,0.96825,0.38095,0.98413,0.38095,0.99609,0.38095};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.00391,0.39683,0.01587,0.39683,0.03175,0.39683,0.04762,0.39683,0.06349,0.39683,0.07937,0.39683,0.09524,0.39683,0.11111,0.39683,0.12698,0.39683,0.14286,0.39683,0.15873,0.39683,0.1746,0.39683,0.19048,0.39683,0.20635,0.39683,0.22222,0.39683,0.2381,0.39683,0.25397,0.39683,0.26984,0.39683,0.28571,0.39683,0.30159,0.39683,0.31746,0.39683,0.33333,0.39683,0.34921,0.39683,0.36508,0.39683,0.38095,0.39683,0.39683,0.39683,0.4127,0.39683,0.42857,0.39683,0.44444,0.39683,0.46032,0.39683,0.47619,0.39683,0.49206,0.39683,0.50794,0.39683,0.52381,0.39683,0.53968,0.39683,0.55556,0.39683,0.57143,0.39683,0.5873,0.39683,0.60317,0.39683,0.61905,0.39683,0.63492,0.39683,0.65079,0.39683,0.66667,0.39683,0.68254,0.39683,0.69841,0.39683,0.71429,0.39683,0.73016,0.39683,0.74603,0.39683,0.7619,0.39683,0.77778,0.39683,0.79365,0.39683,0.80952,0.39683,0.8254,0.39683,0.84127,0.39683,0.85714,0.39683,0.87302,0.39683,0.88889,0.39683,0.90476,0.39683,0.92063,0.39683,0.93651,0.39683,0.95238,0.39683,0.96825,0.39683,0.98413,0.39683,0.99609,0.39683,0.00391,0.4127,0.01587,0.4127,0.03175,0.4127,0.04762,0.4127,0.06349,0.4127,0.07937,0.4127,0.09524,0.4127,0.11111,0.4127,0.12698,0.4127,0.14286,0.4127,0.15873,0.4127,0.1746,0.4127,0.19048,0.4127,0.20635,0.4127,0.22222,0.4127,0.2381,0.4127,0.25397,0.4127,0.26984,0.4127,0.28571,0.4127,0.30159,0.4127,0.31746,0.4127,0.33333,0.4127,0.34921,0.4127,0.36508,0.4127,0.38095,0.4127,0.39683,0.4127,0.4127,0.4127,0.42857,0.4127,0.44444,0.4127,0.46032,0.4127,0.47619,0.4127,0.49206,0.4127,0.50794,0.4127,0.52381,0.4127,0.53968,0.4127,0.55556,0.4127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.57143,0.4127,0.5873,0.4127,0.60317,0.4127,0.61905,0.4127,0.63492,0.4127,0.65079,0.4127,0.66667,0.4127,0.68254,0.4127,0.69841,0.4127,0.71429,0.4127,0.73016,0.4127,0.74603,0.4127,0.7619,0.4127,0.77778,0.4127,0.79365,0.4127,0.80952,0.4127,0.8254,0.4127,0.84127,0.4127,0.85714,0.4127,0.87302,0.4127,0.88889,0.4127,0.90476,0.4127,0.92063,0.4127,0.93651,0.4127,0.95238,0.4127,0.96825,0.4127,0.98413,0.4127,0.99609,0.4127,0.00391,0.42857,0.01587,0.42857,0.03175,0.42857,0.04762,0.42857,0.06349,0.42857,0.07937,0.42857,0.09524,0.42857,0.11111,0.42857,0.12698,0.42857,0.14286,0.42857,0.15873,0.42857,0.1746,0.42857,0.19048,0.42857,0.20635,0.42857,0.22222,0.42857,0.2381,0.42857,0.25397,0.42857,0.26984,0.42857,0.28571,0.42857,0.30159,0.42857,0.31746,0.42857,0.33333,0.42857,0.34921,0.42857,0.36508,0.42857,0.38095,0.42857,0.39683,0.42857,0.4127,0.42857,0.42857,0.42857,0.44444,0.42857,0.46032,0.42857,0.47619,0.42857,0.49206,0.42857,0.50794,0.42857,0.52381,0.42857,0.53968,0.42857,0.55556,0.42857,0.57143,0.42857,0.5873,0.42857,0.60317,0.42857,0.61905,0.42857,0.63492,0.42857,0.65079,0.42857,0.66667,0.42857,0.68254,0.42857,0.69841,0.42857,0.71429,0.42857,0.73016,0.42857,0.74603,0.42857,0.7619,0.42857,0.77778,0.42857,0.79365,0.42857,0.80952,0.42857,0.8254,0.42857,0.84127,0.42857,0.85714,0.42857,0.87302,0.42857,0.88889,0.42857,0.90476,0.42857,0.92063,0.42857,0.93651,0.42857,0.95238,0.42857,0.96825,0.42857,0.98413,0.42857,0.99609,0.42857,0.00391,0.44444,0.01587,0.44444,0.03175,0.44444,0.04762,0.44444,0.06349,0.44444,0.07937,0.44444,0.09524,0.44444,0.11111,0.44444};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.12698,0.44444,0.14286,0.44444,0.15873,0.44444,0.1746,0.44444,0.19048,0.44444,0.20635,0.44444,0.22222,0.44444,0.2381,0.44444,0.25397,0.44444,0.26984,0.44444,0.28571,0.44444,0.30159,0.44444,0.31746,0.44444,0.33333,0.44444,0.34921,0.44444,0.36508,0.44444,0.38095,0.44444,0.39683,0.44444,0.4127,0.44444,0.42857,0.44444,0.44444,0.44444,0.46032,0.44444,0.47619,0.44444,0.49206,0.44444,0.50794,0.44444,0.52381,0.44444,0.53968,0.44444,0.55556,0.44444,0.57143,0.44444,0.5873,0.44444,0.60317,0.44444,0.61905,0.44444,0.63492,0.44444,0.65079,0.44444,0.66667,0.44444,0.68254,0.44444,0.69841,0.44444,0.71429,0.44444,0.73016,0.44444,0.74603,0.44444,0.7619,0.44444,0.77778,0.44444,0.79365,0.44444,0.80952,0.44444,0.8254,0.44444,0.84127,0.44444,0.85714,0.44444,0.87302,0.44444,0.88889,0.44444,0.90476,0.44444,0.92063,0.44444,0.93651,0.44444,0.95238,0.44444,0.96825,0.44444,0.98413,0.44444,0.99609,0.44444,0.00391,0.46032,0.01587,0.46032,0.03175,0.46032,0.04762,0.46032,0.06349,0.46032,0.07937,0.46032,0.09524,0.46032,0.11111,0.46032,0.12698,0.46032,0.14286,0.46032,0.15873,0.46032,0.1746,0.46032,0.19048,0.46032,0.20635,0.46032,0.22222,0.46032,0.2381,0.46032,0.25397,0.46032,0.26984,0.46032,0.28571,0.46032,0.30159,0.46032,0.31746,0.46032,0.33333,0.46032,0.34921,0.46032,0.36508,0.46032,0.38095,0.46032,0.39683,0.46032,0.4127,0.46032,0.42857,0.46032,0.44444,0.46032,0.46032,0.46032,0.47619,0.46032,0.49206,0.46032,0.50794,0.46032,0.52381,0.46032,0.53968,0.46032,0.55556,0.46032,0.57143,0.46032,0.5873,0.46032,0.60317,0.46032,0.61905,0.46032,0.63492,0.46032,0.65079,0.46032,0.66667,0.46032,0.68254,0.46032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.69841,0.46032,0.71429,0.46032,0.73016,0.46032,0.74603,0.46032,0.7619,0.46032,0.77778,0.46032,0.79365,0.46032,0.80952,0.46032,0.8254,0.46032,0.84127,0.46032,0.85714,0.46032,0.87302,0.46032,0.88889,0.46032,0.90476,0.46032,0.92063,0.46032,0.93651,0.46032,0.95238,0.46032,0.96825,0.46032,0.98413,0.46032,0.99609,0.46032,0.00391,0.47619,0.01587,0.47619,0.03175,0.47619,0.04762,0.47619,0.06349,0.47619,0.07937,0.47619,0.09524,0.47619,0.11111,0.47619,0.12698,0.47619,0.14286,0.47619,0.15873,0.47619,0.1746,0.47619,0.19048,0.47619,0.20635,0.47619,0.22222,0.47619,0.2381,0.47619,0.25397,0.47619,0.26984,0.47619,0.28571,0.47619,0.30159,0.47619,0.31746,0.47619,0.33333,0.47619,0.34921,0.47619,0.36508,0.47619,0.38095,0.47619,0.39683,0.47619,0.4127,0.47619,0.42857,0.47619,0.44444,0.47619,0.46032,0.47619,0.47619,0.47619,0.49206,0.47619,0.50794,0.47619,0.52381,0.47619,0.53968,0.47619,0.55556,0.47619,0.57143,0.47619,0.5873,0.47619,0.60317,0.47619,0.61905,0.47619,0.63492,0.47619,0.65079,0.47619,0.66667,0.47619,0.68254,0.47619,0.69841,0.47619,0.71429,0.47619,0.73016,0.47619,0.74603,0.47619,0.7619,0.47619,0.77778,0.47619,0.79365,0.47619,0.80952,0.47619,0.8254,0.47619,0.84127,0.47619,0.85714,0.47619,0.87302,0.47619,0.88889,0.47619,0.90476,0.47619,0.92063,0.47619,0.93651,0.47619,0.95238,0.47619,0.96825,0.47619,0.98413,0.47619,0.99609,0.47619,0.00391,0.49206,0.01587,0.49206,0.03175,0.49206,0.04762,0.49206,0.06349,0.49206,0.07937,0.49206,0.09524,0.49206,0.11111,0.49206,0.12698,0.49206,0.14286,0.49206,0.15873,0.49206,0.1746,0.49206,0.19048,0.49206,0.20635,0.49206,0.22222,0.49206,0.2381,0.49206};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.25397,0.49206,0.26984,0.49206,0.28571,0.49206,0.30159,0.49206,0.31746,0.49206,0.33333,0.49206,0.34921,0.49206,0.36508,0.49206,0.38095,0.49206,0.39683,0.49206,0.4127,0.49206,0.42857,0.49206,0.44444,0.49206,0.46032,0.49206,0.47619,0.49206,0.49206,0.49206,0.50794,0.49206,0.52381,0.49206,0.53968,0.49206,0.55556,0.49206,0.57143,0.49206,0.5873,0.49206,0.60317,0.49206,0.61905,0.49206,0.63492,0.49206,0.65079,0.49206,0.66667,0.49206,0.68254,0.49206,0.69841,0.49206,0.71429,0.49206,0.73016,0.49206,0.74603,0.49206,0.7619,0.49206,0.77778,0.49206,0.79365,0.49206,0.80952,0.49206,0.8254,0.49206,0.84127,0.49206,0.85714,0.49206,0.87302,0.49206,0.88889,0.49206,0.90476,0.49206,0.92063,0.49206,0.93651,0.49206,0.95238,0.49206,0.96825,0.49206,0.98413,0.49206,0.99609,0.49206,0.00391,0.50794,0.01587,0.50794,0.03175,0.50794,0.04762,0.50794,0.06349,0.50794,0.07937,0.50794,0.09524,0.50794,0.11111,0.50794,0.12698,0.50794,0.14286,0.50794,0.15873,0.50794,0.1746,0.50794,0.19048,0.50794,0.20635,0.50794,0.22222,0.50794,0.2381,0.50794,0.25397,0.50794,0.26984,0.50794,0.28571,0.50794,0.30159,0.50794,0.31746,0.50794,0.33333,0.50794,0.34921,0.50794,0.36508,0.50794,0.38095,0.50794,0.39683,0.50794,0.4127,0.50794,0.42857,0.50794,0.44444,0.50794,0.46032,0.50794,0.47619,0.50794,0.49206,0.50794,0.50794,0.50794,0.52381,0.50794,0.53968,0.50794,0.55556,0.50794,0.57143,0.50794,0.5873,0.50794,0.60317,0.50794,0.61905,0.50794,0.63492,0.50794,0.65079,0.50794,0.66667,0.50794,0.68254,0.50794,0.69841,0.50794,0.71429,0.50794,0.73016,0.50794,0.74603,0.50794,0.7619,0.50794,0.77778,0.50794,0.79365,0.50794,0.80952,0.50794};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.8254,0.50794,0.84127,0.50794,0.85714,0.50794,0.87302,0.50794,0.88889,0.50794,0.90476,0.50794,0.92063,0.50794,0.93651,0.50794,0.95238,0.50794,0.96825,0.50794,0.98413,0.50794,0.99609,0.50794,0.00391,0.52381,0.01587,0.52381,0.03175,0.52381,0.04762,0.52381,0.06349,0.52381,0.07937,0.52381,0.09524,0.52381,0.11111,0.52381,0.12698,0.52381,0.14286,0.52381,0.15873,0.52381,0.1746,0.52381,0.19048,0.52381,0.20635,0.52381,0.22222,0.52381,0.2381,0.52381,0.25397,0.52381,0.26984,0.52381,0.28571,0.52381,0.30159,0.52381,0.31746,0.52381,0.33333,0.52381,0.34921,0.52381,0.36508,0.52381,0.38095,0.52381,0.39683,0.52381,0.4127,0.52381,0.42857,0.52381,0.44444,0.52381,0.46032,0.52381,0.47619,0.52381,0.49206,0.52381,0.50794,0.52381,0.52381,0.52381,0.53968,0.52381,0.55556,0.52381,0.57143,0.52381,0.5873,0.52381,0.60317,0.52381,0.61905,0.52381,0.63492,0.52381,0.65079,0.52381,0.66667,0.52381,0.68254,0.52381,0.69841,0.52381,0.71429,0.52381,0.73016,0.52381,0.74603,0.52381,0.7619,0.52381,0.77778,0.52381,0.79365,0.52381,0.80952,0.52381,0.8254,0.52381,0.84127,0.52381,0.85714,0.52381,0.87302,0.52381,0.88889,0.52381,0.90476,0.52381,0.92063,0.52381,0.93651,0.52381,0.95238,0.52381,0.96825,0.52381,0.98413,0.52381,0.99609,0.52381,0.00391,0.53968,0.01587,0.53968,0.03175,0.53968,0.04762,0.53968,0.06349,0.53968,0.07937,0.53968,0.09524,0.53968,0.11111,0.53968,0.12698,0.53968,0.14286,0.53968,0.15873,0.53968,0.1746,0.53968,0.19048,0.53968,0.20635,0.53968,0.22222,0.53968,0.2381,0.53968,0.25397,0.53968,0.26984,0.53968,0.28571,0.53968,0.30159,0.53968,0.31746,0.53968,0.33333,0.53968,0.34921,0.53968,0.36508,0.53968};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.38095,0.53968,0.39683,0.53968,0.4127,0.53968,0.42857,0.53968,0.44444,0.53968,0.46032,0.53968,0.47619,0.53968,0.49206,0.53968,0.50794,0.53968,0.52381,0.53968,0.53968,0.53968,0.55556,0.53968,0.57143,0.53968,0.5873,0.53968,0.60317,0.53968,0.61905,0.53968,0.63492,0.53968,0.65079,0.53968,0.66667,0.53968,0.68254,0.53968,0.69841,0.53968,0.71429,0.53968,0.73016,0.53968,0.74603,0.53968,0.7619,0.53968,0.77778,0.53968,0.79365,0.53968,0.80952,0.53968,0.8254,0.53968,0.84127,0.53968,0.85714,0.53968,0.87302,0.53968,0.88889,0.53968,0.90476,0.53968,0.92063,0.53968,0.93651,0.53968,0.95238,0.53968,0.96825,0.53968,0.98413,0.53968,0.99609,0.53968,0.00391,0.55556,0.01587,0.55556,0.03175,0.55556,0.04762,0.55556,0.06349,0.55556,0.07937,0.55556,0.09524,0.55556,0.11111,0.55556,0.12698,0.55556,0.14286,0.55556,0.15873,0.55556,0.1746,0.55556,0.19048,0.55556,0.20635,0.55556,0.22222,0.55556,0.2381,0.55556,0.25397,0.55556,0.26984,0.55556,0.28571,0.55556,0.30159,0.55556,0.31746,0.55556,0.33333,0.55556,0.34921,0.55556,0.36508,0.55556,0.38095,0.55556,0.39683,0.55556,0.4127,0.55556,0.42857,0.55556,0.44444,0.55556,0.46032,0.55556,0.47619,0.55556,0.49206,0.55556,0.50794,0.55556,0.52381,0.55556,0.53968,0.55556,0.55556,0.55556,0.57143,0.55556,0.5873,0.55556,0.60317,0.55556,0.61905,0.55556,0.63492,0.55556,0.65079,0.55556,0.66667,0.55556,0.68254,0.55556,0.69841,0.55556,0.71429,0.55556,0.73016,0.55556,0.74603,0.55556,0.7619,0.55556,0.77778,0.55556,0.79365,0.55556,0.80952,0.55556,0.8254,0.55556,0.84127,0.55556,0.85714,0.55556,0.87302,0.55556,0.88889,0.55556,0.90476,0.55556,0.92063,0.55556,0.93651,0.55556};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.95238,0.55556,0.96825,0.55556,0.98413,0.55556,0.99609,0.55556,0.00391,0.57143,0.01587,0.57143,0.03175,0.57143,0.04762,0.57143,0.06349,0.57143,0.07937,0.57143,0.09524,0.57143,0.11111,0.57143,0.12698,0.57143,0.14286,0.57143,0.15873,0.57143,0.1746,0.57143,0.19048,0.57143,0.20635,0.57143,0.22222,0.57143,0.2381,0.57143,0.25397,0.57143,0.26984,0.57143,0.28571,0.57143,0.30159,0.57143,0.31746,0.57143,0.33333,0.57143,0.34921,0.57143,0.36508,0.57143,0.38095,0.57143,0.39683,0.57143,0.4127,0.57143,0.42857,0.57143,0.44444,0.57143,0.46032,0.57143,0.47619,0.57143,0.49206,0.57143,0.50794,0.57143,0.52381,0.57143,0.53968,0.57143,0.55556,0.57143,0.57143,0.57143,0.5873,0.57143,0.60317,0.57143,0.61905,0.57143,0.63492,0.57143,0.65079,0.57143,0.66667,0.57143,0.68254,0.57143,0.69841,0.57143,0.71429,0.57143,0.73016,0.57143,0.74603,0.57143,0.7619,0.57143,0.77778,0.57143,0.79365,0.57143,0.80952,0.57143,0.8254,0.57143,0.84127,0.57143,0.85714,0.57143,0.87302,0.57143,0.88889,0.57143,0.90476,0.57143,0.92063,0.57143,0.93651,0.57143,0.95238,0.57143,0.96825,0.57143,0.98413,0.57143,0.99609,0.57143,0.00391,0.5873,0.01587,0.5873,0.03175,0.5873,0.04762,0.5873,0.06349,0.5873,0.07937,0.5873,0.09524,0.5873,0.11111,0.5873,0.12698,0.5873,0.14286,0.5873,0.15873,0.5873,0.1746,0.5873,0.19048,0.5873,0.20635,0.5873,0.22222,0.5873,0.2381,0.5873,0.25397,0.5873,0.26984,0.5873,0.28571,0.5873,0.30159,0.5873,0.31746,0.5873,0.33333,0.5873,0.34921,0.5873,0.36508,0.5873,0.38095,0.5873,0.39683,0.5873,0.4127,0.5873,0.42857,0.5873,0.44444,0.5873,0.46032,0.5873,0.47619,0.5873,0.49206,0.5873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.50794,0.5873,0.52381,0.5873,0.53968,0.5873,0.55556,0.5873,0.57143,0.5873,0.5873,0.5873,0.60317,0.5873,0.61905,0.5873,0.63492,0.5873,0.65079,0.5873,0.66667,0.5873,0.68254,0.5873,0.69841,0.5873,0.71429,0.5873,0.73016,0.5873,0.74603,0.5873,0.7619,0.5873,0.77778,0.5873,0.79365,0.5873,0.80952,0.5873,0.8254,0.5873,0.84127,0.5873,0.85714,0.5873,0.87302,0.5873,0.88889,0.5873,0.90476,0.5873,0.92063,0.5873,0.93651,0.5873,0.95238,0.5873,0.96825,0.5873,0.98413,0.5873,0.99609,0.5873,0.00391,0.60317,0.01587,0.60317,0.03175,0.60317,0.04762,0.60317,0.06349,0.60317,0.07937,0.60317,0.09524,0.60317,0.11111,0.60317,0.12698,0.60317,0.14286,0.60317,0.15873,0.60317,0.1746,0.60317,0.19048,0.60317,0.20635,0.60317,0.22222,0.60317,0.2381,0.60317,0.25397,0.60317,0.26984,0.60317,0.28571,0.60317,0.30159,0.60317,0.31746,0.60317,0.33333,0.60317,0.34921,0.60317,0.36508,0.60317,0.38095,0.60317,0.39683,0.60317,0.4127,0.60317,0.42857,0.60317,0.44444,0.60317,0.46032,0.60317,0.47619,0.60317,0.49206,0.60317,0.50794,0.60317,0.52381,0.60317,0.53968,0.60317,0.55556,0.60317,0.57143,0.60317,0.5873,0.60317,0.60317,0.60317,0.61905,0.60317,0.63492,0.60317,0.65079,0.60317,0.66667,0.60317,0.68254,0.60317,0.69841,0.60317,0.71429,0.60317,0.73016,0.60317,0.74603,0.60317,0.7619,0.60317,0.77778,0.60317,0.79365,0.60317,0.80952,0.60317,0.8254,0.60317,0.84127,0.60317,0.85714,0.60317,0.87302,0.60317,0.88889,0.60317,0.90476,0.60317,0.92063,0.60317,0.93651,0.60317,0.95238,0.60317,0.96825,0.60317,0.98413,0.60317,0.99609,0.60317,0.00391,0.61905,0.01587,0.61905,0.03175,0.61905,0.04762,0.61905};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.06349,0.61905,0.07937,0.61905,0.09524,0.61905,0.11111,0.61905,0.12698,0.61905,0.14286,0.61905,0.15873,0.61905,0.1746,0.61905,0.19048,0.61905,0.20635,0.61905,0.22222,0.61905,0.2381,0.61905,0.25397,0.61905,0.26984,0.61905,0.28571,0.61905,0.30159,0.61905,0.31746,0.61905,0.33333,0.61905,0.34921,0.61905,0.36508,0.61905,0.38095,0.61905,0.39683,0.61905,0.4127,0.61905,0.42857,0.61905,0.44444,0.61905,0.46032,0.61905,0.47619,0.61905,0.49206,0.61905,0.50794,0.61905,0.52381,0.61905,0.53968,0.61905,0.55556,0.61905,0.57143,0.61905,0.5873,0.61905,0.60317,0.61905,0.61905,0.61905,0.63492,0.61905,0.65079,0.61905,0.66667,0.61905,0.68254,0.61905,0.69841,0.61905,0.71429,0.61905,0.73016,0.61905,0.74603,0.61905,0.7619,0.61905,0.77778,0.61905,0.79365,0.61905,0.80952,0.61905,0.8254,0.61905,0.84127,0.61905,0.85714,0.61905,0.87302,0.61905,0.88889,0.61905,0.90476,0.61905,0.92063,0.61905,0.93651,0.61905,0.95238,0.61905,0.96825,0.61905,0.98413,0.61905,0.99609,0.61905,0.00391,0.63492,0.01587,0.63492,0.03175,0.63492,0.04762,0.63492,0.06349,0.63492,0.07937,0.63492,0.09524,0.63492,0.11111,0.63492,0.12698,0.63492,0.14286,0.63492,0.15873,0.63492,0.1746,0.63492,0.19048,0.63492,0.20635,0.63492,0.22222,0.63492,0.2381,0.63492,0.25397,0.63492,0.26984,0.63492,0.28571,0.63492,0.30159,0.63492,0.31746,0.63492,0.33333,0.63492,0.34921,0.63492,0.36508,0.63492,0.38095,0.63492,0.39683,0.63492,0.4127,0.63492,0.42857,0.63492,0.44444,0.63492,0.46032,0.63492,0.47619,0.63492,0.49206,0.63492,0.50794,0.63492,0.52381,0.63492,0.53968,0.63492,0.55556,0.63492,0.57143,0.63492,0.5873,0.63492,0.60317,0.63492,0.61905,0.63492};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.63492,0.63492,0.65079,0.63492,0.66667,0.63492,0.68254,0.63492,0.69841,0.63492,0.71429,0.63492,0.73016,0.63492,0.74603,0.63492,0.7619,0.63492,0.77778,0.63492,0.79365,0.63492,0.80952,0.63492,0.8254,0.63492,0.84127,0.63492,0.85714,0.63492,0.87302,0.63492,0.88889,0.63492,0.90476,0.63492,0.92063,0.63492,0.93651,0.63492,0.95238,0.63492,0.96825,0.63492,0.98413,0.63492,0.99609,0.63492,0.00391,0.65079,0.01587,0.65079,0.03175,0.65079,0.04762,0.65079,0.06349,0.65079,0.07937,0.65079,0.09524,0.65079,0.11111,0.65079,0.12698,0.65079,0.14286,0.65079,0.15873,0.65079,0.1746,0.65079,0.19048,0.65079,0.20635,0.65079,0.22222,0.65079,0.2381,0.65079,0.25397,0.65079,0.26984,0.65079,0.28571,0.65079,0.30159,0.65079,0.31746,0.65079,0.33333,0.65079,0.34921,0.65079,0.36508,0.65079,0.38095,0.65079,0.39683,0.65079,0.4127,0.65079,0.42857,0.65079,0.44444,0.65079,0.46032,0.65079,0.47619,0.65079,0.49206,0.65079,0.50794,0.65079,0.52381,0.65079,0.53968,0.65079,0.55556,0.65079,0.57143,0.65079,0.5873,0.65079,0.60317,0.65079,0.61905,0.65079,0.63492,0.65079,0.65079,0.65079,0.66667,0.65079,0.68254,0.65079,0.69841,0.65079,0.71429,0.65079,0.73016,0.65079,0.74603,0.65079,0.7619,0.65079,0.77778,0.65079,0.79365,0.65079,0.80952,0.65079,0.8254,0.65079,0.84127,0.65079,0.85714,0.65079,0.87302,0.65079,0.88889,0.65079,0.90476,0.65079,0.92063,0.65079,0.93651,0.65079,0.95238,0.65079,0.96825,0.65079,0.98413,0.65079,0.99609,0.65079,0.00391,0.66667,0.01587,0.66667,0.03175,0.66667,0.04762,0.66667,0.06349,0.66667,0.07937,0.66667,0.09524,0.66667,0.11111,0.66667,0.12698,0.66667,0.14286,0.66667,0.15873,0.66667,0.1746,0.66667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.19048,0.66667,0.20635,0.66667,0.22222,0.66667,0.2381,0.66667,0.25397,0.66667,0.26984,0.66667,0.28571,0.66667,0.30159,0.66667,0.31746,0.66667,0.33333,0.66667,0.34921,0.66667,0.36508,0.66667,0.38095,0.66667,0.39683,0.66667,0.4127,0.66667,0.42857,0.66667,0.44444,0.66667,0.46032,0.66667,0.47619,0.66667,0.49206,0.66667,0.50794,0.66667,0.52381,0.66667,0.53968,0.66667,0.55556,0.66667,0.57143,0.66667,0.5873,0.66667,0.60317,0.66667,0.61905,0.66667,0.63492,0.66667,0.65079,0.66667,0.66667,0.66667,0.68254,0.66667,0.69841,0.66667,0.71429,0.66667,0.73016,0.66667,0.74603,0.66667,0.7619,0.66667,0.77778,0.66667,0.79365,0.66667,0.80952,0.66667,0.8254,0.66667,0.84127,0.66667,0.85714,0.66667,0.87302,0.66667,0.88889,0.66667,0.90476,0.66667,0.92063,0.66667,0.93651,0.66667,0.95238,0.66667,0.96825,0.66667,0.98413,0.66667,0.99609,0.66667,0.00391,0.68254,0.01587,0.68254,0.03175,0.68254,0.04762,0.68254,0.06349,0.68254,0.07937,0.68254,0.09524,0.68254,0.11111,0.68254,0.12698,0.68254,0.14286,0.68254,0.15873,0.68254,0.1746,0.68254,0.19048,0.68254,0.20635,0.68254,0.22222,0.68254,0.2381,0.68254,0.25397,0.68254,0.26984,0.68254,0.28571,0.68254,0.30159,0.68254,0.31746,0.68254,0.33333,0.68254,0.34921,0.68254,0.36508,0.68254,0.38095,0.68254,0.39683,0.68254,0.4127,0.68254,0.42857,0.68254,0.44444,0.68254,0.46032,0.68254,0.47619,0.68254,0.49206,0.68254,0.50794,0.68254,0.52381,0.68254,0.53968,0.68254,0.55556,0.68254,0.57143,0.68254,0.5873,0.68254,0.60317,0.68254,0.61905,0.68254,0.63492,0.68254,0.65079,0.68254,0.66667,0.68254,0.68254,0.68254,0.69841,0.68254,0.71429,0.68254,0.73016,0.68254,0.74603,0.68254};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.7619,0.68254,0.77778,0.68254,0.79365,0.68254,0.80952,0.68254,0.8254,0.68254,0.84127,0.68254,0.85714,0.68254,0.87302,0.68254,0.88889,0.68254,0.90476,0.68254,0.92063,0.68254,0.93651,0.68254,0.95238,0.68254,0.96825,0.68254,0.98413,0.68254,0.99609,0.68254,0.00391,0.69841,0.01587,0.69841,0.03175,0.69841,0.04762,0.69841,0.06349,0.69841,0.07937,0.69841,0.09524,0.69841,0.11111,0.69841,0.12698,0.69841,0.14286,0.69841,0.15873,0.69841,0.1746,0.69841,0.19048,0.69841,0.20635,0.69841,0.22222,0.69841,0.2381,0.69841,0.25397,0.69841,0.26984,0.69841,0.28571,0.69841,0.30159,0.69841,0.31746,0.69841,0.33333,0.69841,0.34921,0.69841,0.36508,0.69841,0.38095,0.69841,0.39683,0.69841,0.4127,0.69841,0.42857,0.69841,0.44444,0.69841,0.46032,0.69841,0.47619,0.69841,0.49206,0.69841,0.50794,0.69841,0.52381,0.69841,0.53968,0.69841,0.55556,0.69841,0.57143,0.69841,0.5873,0.69841,0.60317,0.69841,0.61905,0.69841,0.63492,0.69841,0.65079,0.69841,0.66667,0.69841,0.68254,0.69841,0.69841,0.69841,0.71429,0.69841,0.73016,0.69841,0.74603,0.69841,0.7619,0.69841,0.77778,0.69841,0.79365,0.69841,0.80952,0.69841,0.8254,0.69841,0.84127,0.69841,0.85714,0.69841,0.87302,0.69841,0.88889,0.69841,0.90476,0.69841,0.92063,0.69841,0.93651,0.69841,0.95238,0.69841,0.96825,0.69841,0.98413,0.69841,0.99609,0.69841,0.00391,0.71429,0.01587,0.71429,0.03175,0.71429,0.04762,0.71429,0.06349,0.71429,0.07937,0.71429,0.09524,0.71429,0.11111,0.71429,0.12698,0.71429,0.14286,0.71429,0.15873,0.71429,0.1746,0.71429,0.19048,0.71429,0.20635,0.71429,0.22222,0.71429,0.2381,0.71429,0.25397,0.71429,0.26984,0.71429,0.28571,0.71429,0.30159,0.71429};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.31746,0.71429,0.33333,0.71429,0.34921,0.71429,0.36508,0.71429,0.38095,0.71429,0.39683,0.71429,0.4127,0.71429,0.42857,0.71429,0.44444,0.71429,0.46032,0.71429,0.47619,0.71429,0.49206,0.71429,0.50794,0.71429,0.52381,0.71429,0.53968,0.71429,0.55556,0.71429,0.57143,0.71429,0.5873,0.71429,0.60317,0.71429,0.61905,0.71429,0.63492,0.71429,0.65079,0.71429,0.66667,0.71429,0.68254,0.71429,0.69841,0.71429,0.71429,0.71429,0.73016,0.71429,0.74603,0.71429,0.7619,0.71429,0.77778,0.71429,0.79365,0.71429,0.80952,0.71429,0.8254,0.71429,0.84127,0.71429,0.85714,0.71429,0.87302,0.71429,0.88889,0.71429,0.90476,0.71429,0.92063,0.71429,0.93651,0.71429,0.95238,0.71429,0.96825,0.71429,0.98413,0.71429,0.99609,0.71429,0.00391,0.73016,0.01587,0.73016,0.03175,0.73016,0.04762,0.73016,0.06349,0.73016,0.07937,0.73016,0.09524,0.73016,0.11111,0.73016,0.12698,0.73016,0.14286,0.73016,0.15873,0.73016,0.1746,0.73016,0.19048,0.73016,0.20635,0.73016,0.22222,0.73016,0.2381,0.73016,0.25397,0.73016,0.26984,0.73016,0.28571,0.73016,0.30159,0.73016,0.31746,0.73016,0.33333,0.73016,0.34921,0.73016,0.36508,0.73016,0.38095,0.73016,0.39683,0.73016,0.4127,0.73016,0.42857,0.73016,0.44444,0.73016,0.46032,0.73016,0.47619,0.73016,0.49206,0.73016,0.50794,0.73016,0.52381,0.73016,0.53968,0.73016,0.55556,0.73016,0.57143,0.73016,0.5873,0.73016,0.60317,0.73016,0.61905,0.73016,0.63492,0.73016,0.65079,0.73016,0.66667,0.73016,0.68254,0.73016,0.69841,0.73016,0.71429,0.73016,0.73016,0.73016,0.74603,0.73016,0.7619,0.73016,0.77778,0.73016,0.79365,0.73016,0.80952,0.73016,0.8254,0.73016,0.84127,0.73016,0.85714,0.73016,0.87302,0.73016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.88889,0.73016,0.90476,0.73016,0.92063,0.73016,0.93651,0.73016,0.95238,0.73016,0.96825,0.73016,0.98413,0.73016,0.99609,0.73016,0.00391,0.74603,0.01587,0.74603,0.03175,0.74603,0.04762,0.74603,0.06349,0.74603,0.07937,0.74603,0.09524,0.74603,0.11111,0.74603,0.12698,0.74603,0.14286,0.74603,0.15873,0.74603,0.1746,0.74603,0.19048,0.74603,0.20635,0.74603,0.22222,0.74603,0.2381,0.74603,0.25397,0.74603,0.26984,0.74603,0.28571,0.74603,0.30159,0.74603,0.31746,0.74603,0.33333,0.74603,0.34921,0.74603,0.36508,0.74603,0.38095,0.74603,0.39683,0.74603,0.4127,0.74603,0.42857,0.74603,0.44444,0.74603,0.46032,0.74603,0.47619,0.74603,0.49206,0.74603,0.50794,0.74603,0.52381,0.74603,0.53968,0.74603,0.55556,0.74603,0.57143,0.74603,0.5873,0.74603,0.60317,0.74603,0.61905,0.74603,0.63492,0.74603,0.65079,0.74603,0.66667,0.74603,0.68254,0.74603,0.69841,0.74603,0.71429,0.74603,0.73016,0.74603,0.74603,0.74603,0.7619,0.74603,0.77778,0.74603,0.79365,0.74603,0.80952,0.74603,0.8254,0.74603,0.84127,0.74603,0.85714,0.74603,0.87302,0.74603,0.88889,0.74603,0.90476,0.74603,0.92063,0.74603,0.93651,0.74603,0.95238,0.74603,0.96825,0.74603,0.98413,0.74603,0.99609,0.74603,0.00391,0.7619,0.01587,0.7619,0.03175,0.7619,0.04762,0.7619,0.06349,0.7619,0.07937,0.7619,0.09524,0.7619,0.11111,0.7619,0.12698,0.7619,0.14286,0.7619,0.15873,0.7619,0.1746,0.7619,0.19048,0.7619,0.20635,0.7619,0.22222,0.7619,0.2381,0.7619,0.25397,0.7619,0.26984,0.7619,0.28571,0.7619,0.30159,0.7619,0.31746,0.7619,0.33333,0.7619,0.34921,0.7619,0.36508,0.7619,0.38095,0.7619,0.39683,0.7619,0.4127,0.7619,0.42857,0.7619};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.44444,0.7619,0.46032,0.7619,0.47619,0.7619,0.49206,0.7619,0.50794,0.7619,0.52381,0.7619,0.53968,0.7619,0.55556,0.7619,0.57143,0.7619,0.5873,0.7619,0.60317,0.7619,0.61905,0.7619,0.63492,0.7619,0.65079,0.7619,0.66667,0.7619,0.68254,0.7619,0.69841,0.7619,0.71429,0.7619,0.73016,0.7619,0.74603,0.7619,0.7619,0.7619,0.77778,0.7619,0.79365,0.7619,0.80952,0.7619,0.8254,0.7619,0.84127,0.7619,0.85714,0.7619,0.87302,0.7619,0.88889,0.7619,0.90476,0.7619,0.92063,0.7619,0.93651,0.7619,0.95238,0.7619,0.96825,0.7619,0.98413,0.7619,0.99609,0.7619,0.00391,0.77778,0.01587,0.77778,0.03175,0.77778,0.04762,0.77778,0.06349,0.77778,0.07937,0.77778,0.09524,0.77778,0.11111,0.77778,0.12698,0.77778,0.14286,0.77778,0.15873,0.77778,0.1746,0.77778,0.19048,0.77778,0.20635,0.77778,0.22222,0.77778,0.2381,0.77778,0.25397,0.77778,0.26984,0.77778,0.28571,0.77778,0.30159,0.77778,0.31746,0.77778,0.33333,0.77778,0.34921,0.77778,0.36508,0.77778,0.38095,0.77778,0.39683,0.77778,0.4127,0.77778,0.42857,0.77778,0.44444,0.77778,0.46032,0.77778,0.47619,0.77778,0.49206,0.77778,0.50794,0.77778,0.52381,0.77778,0.53968,0.77778,0.55556,0.77778,0.57143,0.77778,0.5873,0.77778,0.60317,0.77778,0.61905,0.77778,0.63492,0.77778,0.65079,0.77778,0.66667,0.77778,0.68254,0.77778,0.69841,0.77778,0.71429,0.77778,0.73016,0.77778,0.74603,0.77778,0.7619,0.77778,0.77778,0.77778,0.79365,0.77778,0.80952,0.77778,0.8254,0.77778,0.84127,0.77778,0.85714,0.77778,0.87302,0.77778,0.88889,0.77778,0.90476,0.77778,0.92063,0.77778,0.93651,0.77778,0.95238,0.77778,0.96825,0.77778,0.98413,0.77778,0.99609,0.77778};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.79365,0.01587,0.79365,0.03175,0.79365,0.04762,0.79365,0.06349,0.79365,0.07937,0.79365,0.09524,0.79365,0.11111,0.79365,0.12698,0.79365,0.14286,0.79365,0.15873,0.79365,0.1746,0.79365,0.19048,0.79365,0.20635,0.79365,0.22222,0.79365,0.2381,0.79365,0.25397,0.79365,0.26984,0.79365,0.28571,0.79365,0.30159,0.79365,0.31746,0.79365,0.33333,0.79365,0.34921,0.79365,0.36508,0.79365,0.38095,0.79365,0.39683,0.79365,0.4127,0.79365,0.42857,0.79365,0.44444,0.79365,0.46032,0.79365,0.47619,0.79365,0.49206,0.79365,0.50794,0.79365,0.52381,0.79365,0.53968,0.79365,0.55556,0.79365,0.57143,0.79365,0.5873,0.79365,0.60317,0.79365,0.61905,0.79365,0.63492,0.79365,0.65079,0.79365,0.66667,0.79365,0.68254,0.79365,0.69841,0.79365,0.71429,0.79365,0.73016,0.79365,0.74603,0.79365,0.7619,0.79365,0.77778,0.79365,0.79365,0.79365,0.80952,0.79365,0.8254,0.79365,0.84127,0.79365,0.85714,0.79365,0.87302,0.79365,0.88889,0.79365,0.90476,0.79365,0.92063,0.79365,0.93651,0.79365,0.95238,0.79365,0.96825,0.79365,0.98413,0.79365,0.99609,0.79365,0.00391,0.80952,0.01587,0.80952,0.03175,0.80952,0.04762,0.80952,0.06349,0.80952,0.07937,0.80952,0.09524,0.80952,0.11111,0.80952,0.12698,0.80952,0.14286,0.80952,0.15873,0.80952,0.1746,0.80952,0.19048,0.80952,0.20635,0.80952,0.22222,0.80952,0.2381,0.80952,0.25397,0.80952,0.26984,0.80952,0.28571,0.80952,0.30159,0.80952,0.31746,0.80952,0.33333,0.80952,0.34921,0.80952,0.36508,0.80952,0.38095,0.80952,0.39683,0.80952,0.4127,0.80952,0.42857,0.80952,0.44444,0.80952,0.46032,0.80952,0.47619,0.80952,0.49206,0.80952,0.50794,0.80952,0.52381,0.80952,0.53968,0.80952,0.55556,0.80952};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.57143,0.80952,0.5873,0.80952,0.60317,0.80952,0.61905,0.80952,0.63492,0.80952,0.65079,0.80952,0.66667,0.80952,0.68254,0.80952,0.69841,0.80952,0.71429,0.80952,0.73016,0.80952,0.74603,0.80952,0.7619,0.80952,0.77778,0.80952,0.79365,0.80952,0.80952,0.80952,0.8254,0.80952,0.84127,0.80952,0.85714,0.80952,0.87302,0.80952,0.88889,0.80952,0.90476,0.80952,0.92063,0.80952,0.93651,0.80952,0.95238,0.80952,0.96825,0.80952,0.98413,0.80952,0.99609,0.80952,0.00391,0.8254,0.01587,0.8254,0.03175,0.8254,0.04762,0.8254,0.06349,0.8254,0.07937,0.8254,0.09524,0.8254,0.11111,0.8254,0.12698,0.8254,0.14286,0.8254,0.15873,0.8254,0.1746,0.8254,0.19048,0.8254,0.20635,0.8254,0.22222,0.8254,0.2381,0.8254,0.25397,0.8254,0.26984,0.8254,0.28571,0.8254,0.30159,0.8254,0.31746,0.8254,0.33333,0.8254,0.34921,0.8254,0.36508,0.8254,0.38095,0.8254,0.39683,0.8254,0.4127,0.8254,0.42857,0.8254,0.44444,0.8254,0.46032,0.8254,0.47619,0.8254,0.49206,0.8254,0.50794,0.8254,0.52381,0.8254,0.53968,0.8254,0.55556,0.8254,0.57143,0.8254,0.5873,0.8254,0.60317,0.8254,0.61905,0.8254,0.63492,0.8254,0.65079,0.8254,0.66667,0.8254,0.68254,0.8254,0.69841,0.8254,0.71429,0.8254,0.73016,0.8254,0.74603,0.8254,0.7619,0.8254,0.77778,0.8254,0.79365,0.8254,0.80952,0.8254,0.8254,0.8254,0.84127,0.8254,0.85714,0.8254,0.87302,0.8254,0.88889,0.8254,0.90476,0.8254,0.92063,0.8254,0.93651,0.8254,0.95238,0.8254,0.96825,0.8254,0.98413,0.8254,0.99609,0.8254,0.00391,0.84127,0.01587,0.84127,0.03175,0.84127,0.04762,0.84127,0.06349,0.84127,0.07937,0.84127,0.09524,0.84127,0.11111,0.84127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.12698,0.84127,0.14286,0.84127,0.15873,0.84127,0.1746,0.84127,0.19048,0.84127,0.20635,0.84127,0.22222,0.84127,0.2381,0.84127,0.25397,0.84127,0.26984,0.84127,0.28571,0.84127,0.30159,0.84127,0.31746,0.84127,0.33333,0.84127,0.34921,0.84127,0.36508,0.84127,0.38095,0.84127,0.39683,0.84127,0.4127,0.84127,0.42857,0.84127,0.44444,0.84127,0.46032,0.84127,0.47619,0.84127,0.49206,0.84127,0.50794,0.84127,0.52381,0.84127,0.53968,0.84127,0.55556,0.84127,0.57143,0.84127,0.5873,0.84127,0.60317,0.84127,0.61905,0.84127,0.63492,0.84127,0.65079,0.84127,0.66667,0.84127,0.68254,0.84127,0.69841,0.84127,0.71429,0.84127,0.73016,0.84127,0.74603,0.84127,0.7619,0.84127,0.77778,0.84127,0.79365,0.84127,0.80952,0.84127,0.8254,0.84127,0.84127,0.84127,0.85714,0.84127,0.87302,0.84127,0.88889,0.84127,0.90476,0.84127,0.92063,0.84127,0.93651,0.84127,0.95238,0.84127,0.96825,0.84127,0.98413,0.84127,0.99609,0.84127,0.00391,0.85714,0.01587,0.85714,0.03175,0.85714,0.04762,0.85714,0.06349,0.85714,0.07937,0.85714,0.09524,0.85714,0.11111,0.85714,0.12698,0.85714,0.14286,0.85714,0.15873,0.85714,0.1746,0.85714,0.19048,0.85714,0.20635,0.85714,0.22222,0.85714,0.2381,0.85714,0.25397,0.85714,0.26984,0.85714,0.28571,0.85714,0.30159,0.85714,0.31746,0.85714,0.33333,0.85714,0.34921,0.85714,0.36508,0.85714,0.38095,0.85714,0.39683,0.85714,0.4127,0.85714,0.42857,0.85714,0.44444,0.85714,0.46032,0.85714,0.47619,0.85714,0.49206,0.85714,0.50794,0.85714,0.52381,0.85714,0.53968,0.85714,0.55556,0.85714,0.57143,0.85714,0.5873,0.85714,0.60317,0.85714,0.61905,0.85714,0.63492,0.85714,0.65079,0.85714,0.66667,0.85714,0.68254,0.85714};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.69841,0.85714,0.71429,0.85714,0.73016,0.85714,0.74603,0.85714,0.7619,0.85714,0.77778,0.85714,0.79365,0.85714,0.80952,0.85714,0.8254,0.85714,0.84127,0.85714,0.85714,0.85714,0.87302,0.85714,0.88889,0.85714,0.90476,0.85714,0.92063,0.85714,0.93651,0.85714,0.95238,0.85714,0.96825,0.85714,0.98413,0.85714,0.99609,0.85714,0.00391,0.87302,0.01587,0.87302,0.03175,0.87302,0.04762,0.87302,0.06349,0.87302,0.07937,0.87302,0.09524,0.87302,0.11111,0.87302,0.12698,0.87302,0.14286,0.87302,0.15873,0.87302,0.1746,0.87302,0.19048,0.87302,0.20635,0.87302,0.22222,0.87302,0.2381,0.87302,0.25397,0.87302,0.26984,0.87302,0.28571,0.87302,0.30159,0.87302,0.31746,0.87302,0.33333,0.87302,0.34921,0.87302,0.36508,0.87302,0.38095,0.87302,0.39683,0.87302,0.4127,0.87302,0.42857,0.87302,0.44444,0.87302,0.46032,0.87302,0.47619,0.87302,0.49206,0.87302,0.50794,0.87302,0.52381,0.87302,0.53968,0.87302,0.55556,0.87302,0.57143,0.87302,0.5873,0.87302,0.60317,0.87302,0.61905,0.87302,0.63492,0.87302,0.65079,0.87302,0.66667,0.87302,0.68254,0.87302,0.69841,0.87302,0.71429,0.87302,0.73016,0.87302,0.74603,0.87302,0.7619,0.87302,0.77778,0.87302,0.79365,0.87302,0.80952,0.87302,0.8254,0.87302,0.84127,0.87302,0.85714,0.87302,0.87302,0.87302,0.88889,0.87302,0.90476,0.87302,0.92063,0.87302,0.93651,0.87302,0.95238,0.87302,0.96825,0.87302,0.98413,0.87302,0.99609,0.87302,0.00391,0.88889,0.01587,0.88889,0.03175,0.88889,0.04762,0.88889,0.06349,0.88889,0.07937,0.88889,0.09524,0.88889,0.11111,0.88889,0.12698,0.88889,0.14286,0.88889,0.15873,0.88889,0.1746,0.88889,0.19048,0.88889,0.20635,0.88889,0.22222,0.88889,0.2381,0.88889};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.25397,0.88889,0.26984,0.88889,0.28571,0.88889,0.30159,0.88889,0.31746,0.88889,0.33333,0.88889,0.34921,0.88889,0.36508,0.88889,0.38095,0.88889,0.39683,0.88889,0.4127,0.88889,0.42857,0.88889,0.44444,0.88889,0.46032,0.88889,0.47619,0.88889,0.49206,0.88889,0.50794,0.88889,0.52381,0.88889,0.53968,0.88889,0.55556,0.88889,0.57143,0.88889,0.5873,0.88889,0.60317,0.88889,0.61905,0.88889,0.63492,0.88889,0.65079,0.88889,0.66667,0.88889,0.68254,0.88889,0.69841,0.88889,0.71429,0.88889,0.73016,0.88889,0.74603,0.88889,0.7619,0.88889,0.77778,0.88889,0.79365,0.88889,0.80952,0.88889,0.8254,0.88889,0.84127,0.88889,0.85714,0.88889,0.87302,0.88889,0.88889,0.88889,0.90476,0.88889,0.92063,0.88889,0.93651,0.88889,0.95238,0.88889,0.96825,0.88889,0.98413,0.88889,0.99609,0.88889,0.00391,0.90476,0.01587,0.90476,0.03175,0.90476,0.04762,0.90476,0.06349,0.90476,0.07937,0.90476,0.09524,0.90476,0.11111,0.90476,0.12698,0.90476,0.14286,0.90476,0.15873,0.90476,0.1746,0.90476,0.19048,0.90476,0.20635,0.90476,0.22222,0.90476,0.2381,0.90476,0.25397,0.90476,0.26984,0.90476,0.28571,0.90476,0.30159,0.90476,0.31746,0.90476,0.33333,0.90476,0.34921,0.90476,0.36508,0.90476,0.38095,0.90476,0.39683,0.90476,0.4127,0.90476,0.42857,0.90476,0.44444,0.90476,0.46032,0.90476,0.47619,0.90476,0.49206,0.90476,0.50794,0.90476,0.52381,0.90476,0.53968,0.90476,0.55556,0.90476,0.57143,0.90476,0.5873,0.90476,0.60317,0.90476,0.61905,0.90476,0.63492,0.90476,0.65079,0.90476,0.66667,0.90476,0.68254,0.90476,0.69841,0.90476,0.71429,0.90476,0.73016,0.90476,0.74603,0.90476,0.7619,0.90476,0.77778,0.90476,0.79365,0.90476,0.80952,0.90476};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.8254,0.90476,0.84127,0.90476,0.85714,0.90476,0.87302,0.90476,0.88889,0.90476,0.90476,0.90476,0.92063,0.90476,0.93651,0.90476,0.95238,0.90476,0.96825,0.90476,0.98413,0.90476,0.99609,0.90476,0.00391,0.92063,0.01587,0.92063,0.03175,0.92063,0.04762,0.92063,0.06349,0.92063,0.07937,0.92063,0.09524,0.92063,0.11111,0.92063,0.12698,0.92063,0.14286,0.92063,0.15873,0.92063,0.1746,0.92063,0.19048,0.92063,0.20635,0.92063,0.22222,0.92063,0.2381,0.92063,0.25397,0.92063,0.26984,0.92063,0.28571,0.92063,0.30159,0.92063,0.31746,0.92063,0.33333,0.92063,0.34921,0.92063,0.36508,0.92063,0.38095,0.92063,0.39683,0.92063,0.4127,0.92063,0.42857,0.92063,0.44444,0.92063,0.46032,0.92063,0.47619,0.92063,0.49206,0.92063,0.50794,0.92063,0.52381,0.92063,0.53968,0.92063,0.55556,0.92063,0.57143,0.92063,0.5873,0.92063,0.60317,0.92063,0.61905,0.92063,0.63492,0.92063,0.65079,0.92063,0.66667,0.92063,0.68254,0.92063,0.69841,0.92063,0.71429,0.92063,0.73016,0.92063,0.74603,0.92063,0.7619,0.92063,0.77778,0.92063,0.79365,0.92063,0.80952,0.92063,0.8254,0.92063,0.84127,0.92063,0.85714,0.92063,0.87302,0.92063,0.88889,0.92063,0.90476,0.92063,0.92063,0.92063,0.93651,0.92063,0.95238,0.92063,0.96825,0.92063,0.98413,0.92063,0.99609,0.92063,0.00391,0.93651,0.01587,0.93651,0.03175,0.93651,0.04762,0.93651,0.06349,0.93651,0.07937,0.93651,0.09524,0.93651,0.11111,0.93651,0.12698,0.93651,0.14286,0.93651,0.15873,0.93651,0.1746,0.93651,0.19048,0.93651,0.20635,0.93651,0.22222,0.93651,0.2381,0.93651,0.25397,0.93651,0.26984,0.93651,0.28571,0.93651,0.30159,0.93651,0.31746,0.93651,0.33333,0.93651,0.34921,0.93651,0.36508,0.93651};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.38095,0.93651,0.39683,0.93651,0.4127,0.93651,0.42857,0.93651,0.44444,0.93651,0.46032,0.93651,0.47619,0.93651,0.49206,0.93651,0.50794,0.93651,0.52381,0.93651,0.53968,0.93651,0.55556,0.93651,0.57143,0.93651,0.5873,0.93651,0.60317,0.93651,0.61905,0.93651,0.63492,0.93651,0.65079,0.93651,0.66667,0.93651,0.68254,0.93651,0.69841,0.93651,0.71429,0.93651,0.73016,0.93651,0.74603,0.93651,0.7619,0.93651,0.77778,0.93651,0.79365,0.93651,0.80952,0.93651,0.8254,0.93651,0.84127,0.93651,0.85714,0.93651,0.87302,0.93651,0.88889,0.93651,0.90476,0.93651,0.92063,0.93651,0.93651,0.93651,0.95238,0.93651,0.96825,0.93651,0.98413,0.93651,0.99609,0.93651,0.00391,0.95238,0.01587,0.95238,0.03175,0.95238,0.04762,0.95238,0.06349,0.95238,0.07937,0.95238,0.09524,0.95238,0.11111,0.95238,0.12698,0.95238,0.14286,0.95238,0.15873,0.95238,0.1746,0.95238,0.19048,0.95238,0.20635,0.95238,0.22222,0.95238,0.2381,0.95238,0.25397,0.95238,0.26984,0.95238,0.28571,0.95238,0.30159,0.95238,0.31746,0.95238,0.33333,0.95238,0.34921,0.95238,0.36508,0.95238,0.38095,0.95238,0.39683,0.95238,0.4127,0.95238,0.42857,0.95238,0.44444,0.95238,0.46032,0.95238,0.47619,0.95238,0.49206,0.95238,0.50794,0.95238,0.52381,0.95238,0.53968,0.95238,0.55556,0.95238,0.57143,0.95238,0.5873,0.95238,0.60317,0.95238,0.61905,0.95238,0.63492,0.95238,0.65079,0.95238,0.66667,0.95238,0.68254,0.95238,0.69841,0.95238,0.71429,0.95238,0.73016,0.95238,0.74603,0.95238,0.7619,0.95238,0.77778,0.95238,0.79365,0.95238,0.80952,0.95238,0.8254,0.95238,0.84127,0.95238,0.85714,0.95238,0.87302,0.95238,0.88889,0.95238,0.90476,0.95238,0.92063,0.95238,0.93651,0.95238};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.95238,0.95238,0.96825,0.95238,0.98413,0.95238,0.99609,0.95238,0.00391,0.96825,0.01587,0.96825,0.03175,0.96825,0.04762,0.96825,0.06349,0.96825,0.07937,0.96825,0.09524,0.96825,0.11111,0.96825,0.12698,0.96825,0.14286,0.96825,0.15873,0.96825,0.1746,0.96825,0.19048,0.96825,0.20635,0.96825,0.22222,0.96825,0.2381,0.96825,0.25397,0.96825,0.26984,0.96825,0.28571,0.96825,0.30159,0.96825,0.31746,0.96825,0.33333,0.96825,0.34921,0.96825,0.36508,0.96825,0.38095,0.96825,0.39683,0.96825,0.4127,0.96825,0.42857,0.96825,0.44444,0.96825,0.46032,0.96825,0.47619,0.96825,0.49206,0.96825,0.50794,0.96825,0.52381,0.96825,0.53968,0.96825,0.55556,0.96825,0.57143,0.96825,0.5873,0.96825,0.60317,0.96825,0.61905,0.96825,0.63492,0.96825,0.65079,0.96825,0.66667,0.96825,0.68254,0.96825,0.69841,0.96825,0.71429,0.96825,0.73016,0.96825,0.74603,0.96825,0.7619,0.96825,0.77778,0.96825,0.79365,0.96825,0.80952,0.96825,0.8254,0.96825,0.84127,0.96825,0.85714,0.96825,0.87302,0.96825,0.88889,0.96825,0.90476,0.96825,0.92063,0.96825,0.93651,0.96825,0.95238,0.96825,0.96825,0.96825,0.98413,0.96825,0.99609,0.96825,0.00391,0.98413,0.01587,0.98413,0.03175,0.98413,0.04762,0.98413,0.06349,0.98413,0.07937,0.98413,0.09524,0.98413,0.11111,0.98413,0.12698,0.98413,0.14286,0.98413,0.15873,0.98413,0.1746,0.98413,0.19048,0.98413,0.20635,0.98413,0.22222,0.98413,0.2381,0.98413,0.25397,0.98413,0.26984,0.98413,0.28571,0.98413,0.30159,0.98413,0.31746,0.98413,0.33333,0.98413,0.34921,0.98413,0.36508,0.98413,0.38095,0.98413,0.39683,0.98413,0.4127,0.98413,0.42857,0.98413,0.44444,0.98413,0.46032,0.98413,0.47619,0.98413,0.49206,0.98413};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.50794,0.98413,0.52381,0.98413,0.53968,0.98413,0.55556,0.98413,0.57143,0.98413,0.5873,0.98413,0.60317,0.98413,0.61905,0.98413,0.63492,0.98413,0.65079,0.98413,0.66667,0.98413,0.68254,0.98413,0.69841,0.98413,0.71429,0.98413,0.73016,0.98413,0.74603,0.98413,0.7619,0.98413,0.77778,0.98413,0.79365,0.98413,0.80952,0.98413,0.8254,0.98413,0.84127,0.98413,0.85714,0.98413,0.87302,0.98413,0.88889,0.98413,0.90476,0.98413,0.92063,0.98413,0.93651,0.98413,0.95238,0.98413,0.96825,0.98413,0.98413,0.98413,0.99609,0.98413,0.00391,0.99609,0.01587,0.99609,0.03175,0.99609,0.04762,0.99609,0.06349,0.99609,0.07937,0.99609,0.09524,0.99609,0.11111,0.99609,0.12698,0.99609,0.14286,0.99609,0.15873,0.99609,0.1746,0.99609,0.19048,0.99609,0.20635,0.99609,0.22222,0.99609,0.2381,0.99609,0.25397,0.99609,0.26984,0.99609,0.28571,0.99609,0.30159,0.99609,0.31746,0.99609,0.33333,0.99609,0.34921,0.99609,0.36508,0.99609,0.38095,0.99609,0.39683,0.99609,0.4127,0.99609,0.42857,0.99609,0.44444,0.99609,0.46032,0.99609,0.47619,0.99609,0.49206,0.99609,0.50794,0.99609,0.52381,0.99609,0.53968,0.99609,0.55556,0.99609,0.57143,0.99609,0.5873,0.99609,0.60317,0.99609,0.61905,0.99609,0.63492,0.99609,0.65079,0.99609,0.66667,0.99609,0.68254,0.99609,0.69841,0.99609,0.71429,0.99609,0.73016,0.99609,0.74603,0.99609,0.7619,0.99609,0.77778,0.99609,0.79365,0.99609,0.80952,0.99609,0.8254,0.99609,0.84127,0.99609,0.85714,0.99609,0.87302,0.99609,0.88889,0.99609,0.90476,0.99609,0.92063,0.99609,0.93651,0.99609,0.95238,0.99609,0.96825,0.99609,0.98413,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 4096 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 8192 total numbers made up of 4096 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD004 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD004().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD004\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD004 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD004_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD004_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD004_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD004_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
