####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD003.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD003.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD003.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD003.x3d'),
    GeoLOD(center=(45.000000,-135.000000,291100.000000),child1Url=["MarsLOD004.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD004.x3d"],range=3.6E7,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars001.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars001.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,-180.000000,0.000000),height=[-2331.8135,-2621.4492,-2782.416,-3055.9858,-3096.7434,-2402.735,-1296.9989,-851.7626,-2630.653,-2932.1582,-2101.7654,-1802.2705,-1011.29004,-770.3503,-303.37286,790.00336,1797.828,2478.528,3559.416,4507.473,5257.7207,6083.886,9589.305,9023.787,5749.0635,5539.3335,5224.552,4907.0835,4358.972,3896.072,3415.7349,2817.428,-2861.995,-2980.7844,-3105.586,-3183.648,-3103.7322,-2563.2825,-1828.5652,-2022.1736,-3092.452,-3113.6157,-2721.4087,-1556.7417,-1245.4701,-1423.5645,-179.64645,1170.1298,2071.9778,1752.0042,3450.0994,4478.7026,4391.1934,4286.671,6330.6763,7264.059,5421.913,5617.667,5093.0283,4474.8745,4035.291,3811.422,3164.9155,2297.8135,-3045.9019,-3115.5369,-3249.1072,-3241.6824,-3197.152,-3008.2375,-2505.7776,-2659.8523,-3293.6433,-3322.9314,-2726.8389,-1810.2416,-2201.817,-1330.1932,353.66577,1072.772,1202.6835,1186.5087,2397.9814,4380.1074,4233.452,3529.7632,3290.4575,4097.569,5254.3916,6250.09,4847.093,4101.5596,3743.0286,3589.919,2834.885,1667.6483,-3086.6292,-3128.9211,-3285.822,-3269.0588,-3265.7126,-3195.4856,-2778.8684,-3185.4016,-3431.0095,-3398.9385,-2831.5737,-2715.383,-2300.6394,-1222.9167,-477.68475,-212.2787,244.7245,691.94104,1963.891,4124.84,3876.0042,2971.271,2802.8357,3163.0732,4945.931,8355.127,5448.7476,3680.1316,3432.1826,3122.2705,2347.604,1528.6093,-3181.7637,-3213.7974,-3329.0596,-3350.0618,-3399.916,-3426.2983,-3325.7856,-3524.7825,-3533.3635,-3454.0583,-3210.4192,-2987.8728,-2215.3813,-1539.8898,-1152.2162,-549.7283,54.180042,634.4401,1709.705,2665.3362,2475.477,2491.2363,2455.7612,2342.3486,2994.0552,12268.973,11643.728,3747.5293,3176.5557,2754.0232,2316.8523,1467.8578,-3200.301,-3249.6553,-3346.394,-3359.6016,-3492.074,-3556.4834,-3611.2827,-3663.843,-3632.6355,-3579.223,-3295.0637,-2699.5728,-1876.1034,-1185.8832,1514.7836,3915.3914,2758.698,825.1487,1284.6343,1955.7533,2212.3052,2310.262,2263.8235,2080.1272,1910.8173,5512.339,7443.2144,4157.781,2952.0005,2385.8933,2595.6277,1046.6147,-3308.4163,-3369.5542,-3242.797,-3454.5105,-3515.6511,-3638.3047,-3693.9153,-3753.4167,-3752.2427,-3760.4346,-3029.9597,-2422.7861,-2128.589,155.75948,8509.598,16044.139,11971.958,2223.8914,1172.6901,1112.1202,1735.4751,2162.905,2210.0237,2084.8489,1917.8516,2187.0613,3451.7798,3223.5037,2635.414,2196.6309,1701.1198,845.9715,-3375.9087,-3466.3794,-3503.7776,-3508.377,-3565.6794,-3703.538,-3770.2666,-3824.6848,-3834.091,-3811.1404,-2962.2744,-2030.9608,-1505.3993,-323.669,8534.802,14693.098,11564.329,2017.5803,578.4693,560.04266,1136.4995,1957.7537,2366.0815,2465.0745,2198.583,1900.5969,2266.97,2392.5981,2302.5498,2146.2026,1792.1917,1029.8273,-3465.6538,-3543.7856,-3634.514,-3699.6768,-3751.24,-3813.0515,-3852.448,-3874.1572,-3874.129,-3719.6182,-2937.559,-1834.5367,-1784.8998,-1883.6512,2692.7722,5203.9873,3217.3977,-67.993675,17.252098,384.03918,1092.0746,1786.9608,2405.9817,2805.7854,2794.1284,2026.2576,1992.6946,2219.4695,2736.6326,2084.65,1825.2178,963.7697,-3581.767,-3605.567,-3737.9353,-3794.5435,-3829.9504,-3844.3557,-3875.6035,-3876.2607,-3867.9993,-3772.212,-2908.221,-1984.6768,-1883.9988,-2034.1094,-2090.1816,-1908.7001,-1409.3505,-637.06354,-23.442541,607.70135,1401.3876,1974.7852,2539.6602,3039.5732,3399.267,2529.8906,1921.523,2178.665,2694.7468,2254.4675,2034.0004,851.487,-3668.4768,-3765.4097,-3835.3787,-3857.952,-3889.2998,-3885.0933,-3887.0737,-3886.234,-3874.8538,-3868.4175,-3320.2275,-2248.7954,-1838.0114,-1789.6603,-1685.0044,-1086.8258,-1414.3394,-763.17896,228.00612,981.341,1626.0106,2156.376,2625.0789,3428.4548,3400.2617,2222.2207,1744.4098,1822.2421,1762.3044,1853.9479,1782.852,879.1625,-3746.9292,-3869.4546,-3892.8547,-3900.1218,-3932.229,-3929.1838,-3910.8125,-3915.0132,-3904.1333,-3888.129,-3738.599,-2948.6694,-2446.5303,-2326.7493,-2102.2683,-1695.2434,-1631.7617,-193.11145,529.0431,1223.7207,1796.0123,2249.6323,2638.7156,3236.5999,3124.7817,2051.5266,1655.1404,1550.926,1305.4924,1193.658,1076.3094,786.3528,-3686.7236,-3901.8098,-3933.2395,-3926.9414,-3945.7139,-3933.9321,-3937.4912,-3942.3367,-3932.0728,-3957.1182,-3927.0503,-3691.2266,-2717.6558,-1977.877,-2206.2827,-1978.375,-654.4804,170.5122,723.031,1423.7529,2068.8079,2595.4807,3092.01,3445.2178,3333.1702,2387.4006,1544.2781,1245.2625,1033.7052,938.60913,1028.4147,968.72833,-3965.8003,-3874.2197,-3901.0498,-3953.1345,-3949.1106,-3928.2537,-3943.9353,-3949.1887,-3938.0803,-3921.3755,-3902.4749,-3864.199,-3192.4463,-1805.1866,-1773.8058,-1076.82,-23.296179,168.89037,689.4845,1477.275,2633.3657,3657.4204,4406.285,4624.867,4335.8335,3700.1675,2628.573,1364.303,732.99426,694.42993,897.4272,1064.764,-4014.2798,-3955.0613,-3807.8662,-3935.6978,-3933.531,-3943.3164,-3931.3606,-3930.5127,-3897.2551,-3864.283,-3844.7346,-3827.9744,-3624.631,-2351.69,-1342.4777,-1133.8163,-798.80756,-124.62372,466.61737,1688.4501,3518.781,4999.969,5696.303,6004.9766,5571.777,4429.546,3881.4158,2133.2695,665.59186,433.48242,699.4394,784.9253,-4049.2825,-4034.3796,-3990.1228,-3967.6128,-3953.4084,-3934.6223,-3917.6394,-3928.2087,-3907.6445,-3869.2783,-3819.2634,-3669.6094,-3420.195,-2945.864,-2361.9758,-1768.0963,-1223.7261,-666.9682,34.160236,1370.2274,3259.1055,4655.217,5125.8164,5476.7134,5166.9146,4108.6147,2873.9849,1233.5525,310.61737,288.3956,432.67474,580.04193,-4083.6611,-4047.69,-4022.7485,-3991.1885,-3952.4915,-3949.624,-3955.1873,-3931.923,-3893.7542,-3832.4414,-3722.0352,-3514.1348,-3184.8523,-2756.5735,-2323.8406,-1964.2938,-1661.6501,-1281.6189,-734.1904,201.8927,1418.5343,2205.6099,2788.8628,3966.1274,4075.8025,2835.4548,1281.6542,215.29442,-182.90173,-197.51387,-356.5572,-519.1188,-4088.814,-4058.0327,-4035.184,-4004.2407,-3986.4863,-3966.5764,-3972.699,-3930.9526,-3872.3452,-3759.821,-3627.571,-3398.6138,-3122.32,-2802.779,-2503.359,-2274.4863,-2035.9509,-1779.9441,-1516.0764,-1144.8304,-687.6053,-417.41174,-369.66678,309.70126,590.7142,26.515799,-102.06906,-221.47523,-372.50806,-361.75916,-514.00793,-847.3451,-4096.421,-4076.9836,-4077.607,-4044.844,-4001.2383,-3982.13,-3953.7275,-3890.6597,-3798.5981,-3674.9219,-3508.0225,-3312.2585,-3106.3262,-2896.1802,-2700.8152,-2477.2139,-2266.471,-2092.0232,-1949.802,-1787.153,-1639.6495,-1454.6377,-1308.347,-1208.7523,-1191.103,-1093.9027,-798.9016,-591.0092,-633.54047,-629.31836,-623.10803,-959.7713,-4124.238,-4124.2954,-4084.5632,-4061.26,-4036.4644,-3967.682,-3931.261,-3862.6797,-3749.6375,-3626.925,-3416.6946,-3252.3115,-3161.5635,-3008.7007,-2864.686,-2709.6875,-2544.6226,-2391.0542,-2224.5942,-2115.6348,-1962.4962,-1859.7615,-1751.3943,-1749.6989,-1724.2336,-1576.9266,-1313.3481,-1075.3911,-1025.5397,-1093.6213,-1334.8295,-1744.6028,-4191.1255,-4140.148,-4108.6865,-4045.1167,-4022.7537,-3987.346,-3930.346,-3849.6138,-3774.8,-3679.206,-3649.0576,-3476.1182,-3277.9622,-3191.2139,-3080.9954,-2969.488,-2823.26,-2680.9788,-2527.3555,-2417.364,-2318.8926,-2252.8237,-2217.1091,-2204.4617,-2208.213,-2112.1814,-1962.513,-1764.7848,-1670.3074,-1631.3457,-1804.9395,-2181.4583,-4232.851,-4164.4497,-4159.2373,-4098.8687,-4074.0115,-4041.3076,-4000.6208,-3909.763,-3833.1208,-3754.4111,-3669.4893,-3552.1343,-3464.5264,-3372.1545,-3274.0774,-3158.5156,-3094.5947,-3030.5754,-2944.8157,-2869.3938,-2803.5215,-2720.5903,-2699.9368,-2693.0679,-2673.751,-2661.4614,-2559.1978,-2405.8242,-2326.2812,-2361.5862,-2560.3186,-2825.2056,-4234.7197,-4205.5566,-4196.295,-4191.4414,-4149.0186,-4120.691,-4052.2463,-4008.26,-3930.464,-3855.6995,-3806.822,-3733.0881,-3642.2373,-3554.9163,-3500.4424,-3448.3086,-3389.8237,-3338.8481,-3286.6443,-3249.3147,-3233.3484,-3204.1553,-3196.4622,-3167.1099,-3133.5686,-3140.2668,-3131.4473,-3104.1077,-3086.0564,-3108.9944,-3195.8762,-3272.6108,-4339.7617,-4312.202,-4301.171,-4292.8164,-4260.789,-4213.2812,-4180.9727,-4150.795,-4105.419,-4036.9448,-3991.5942,-3929.385,-3863.931,-3807.5994,-3768.8936,-3722.7737,-3682.228,-3649.8594,-3617.032,-3604.5344,-3574.6348,-3543.0388,-3510.3008,-3468.707,-3441.6382,-3439.4248,-3428.8613,-3428.6086,-3461.5725,-3510.9094,-3586.3623,-3671.2485,-4458.68,-4448.177,-4421.4214,-4411.013,-4383.1704,-4377.408,-4336.2417,-4318.7188,-4291.4155,-4259.0938,-4219.001,-4170.857,-4145.0522,-4091.3945,-4061.1228,-4027.2456,-3992.8816,-3943.1982,-3911.7869,-3871.0144,-3839.4675,-3814.967,-3782.573,-3726.3228,-3691.183,-3690.9778,-3681.5771,-3705.7031,-3761.8872,-3830.6575,-3894.451,-3988.416,-4595.897,-4583.1836,-4571.9185,-4561.857,-4533.0024,-4542.7485,-4510.9907,-4504.89,-4487.5464,-4476.915,-4456.566,-4451.3584,-4434.0205,-4381.998,-4354.4,-4351.9946,-4286.6064,-4243.549,-4171.0845,-4132.004,-4139.2705,-4140.6343,-4108.679,-4054.836,-4034.4744,-4020.7507,-4038.5476,-4060.6433,-4132.1143,-4199.134,-4265.281,-4349.5776,-4749.119,-4745.467,-4711.585,-4734.74,-4727.9614,-4730.662,-4717.6826,-4713.753,-4707.273,-4719.675,-4694.057,-4662.732,-4652.0933,-4602.878,-4529.6084,-4537.0215,-4547.8413,-4507.5874,-4534.532,-4497.174,-4490.014,-4461.134,-4416.358,-4387.9883,-4388.9165,-4382.795,-4415.7583,-4454.8154,-4513.5137,-4557.8345,-4609.866,-4656.7686,-4819.628,-4791.416,-4805.7334,-4836.7046,-4827.2383,-4841.3496,-4882.0757,-4837.0547,-4849.5015,-4825.3755,-4819.469,-4782.446,-4738.266,-4768.1733,-4786.568,-4871.125,-4865.7993,-4729.1387,-4709.5674,-4681.5757,-4683.5894,-4686.9014,-4715.2964,-4720.799,-4690.7754,-4669.8154,-4647.231,-4693.29,-4722.0063,-4752.7827,-4791.712,-4806.839,-4778.6133,-4741.359,-4713.474,-4740.3755,-4740.101,-4740.0947,-4802.1245,-4803.8413,-4803.9243,-4797.481,-4762.5884,-4772.546,-4740.7764,-4756.8125,-4775.3613,-4866.735,-4910.3696,-4874.6577,-4821.6665,-4783.0317,-4785.281,-4796.3984,-4824.806,-4810.6245,-4834.779,-4826.9526,-4845.6943,-4855.515,-4856.406,-4853.3447,-4866.006,-4899.9756,-4359.919,-4378.418,-4371.767,-4376.7764,-4384.8965,-4404.114,-4423.8687,-4446.041,-4466.1924,-4482.7104,-4496.276,-4507.641,-4519.1763,-4533.0522,-4550.6255,-4572.6035,-4598.769,-4619.653,-4636.1567,-4677.2847,-4750.854,-4775.3564,-4755.1445,-4627.8086,-4563.1978,-4512.529,-4439.021,-4462.0327,-4536.147,-4635.663,-4687.3022,-4719.5605,-4082.0967,-4065.9573,-4059.5627,-4061.1665,-4042.874,-4038.281,-4012.5847,-4020.2002,-4027.4692,-4040.3162,-4002.2454,-3984.3733,-3991.026,-3990.5254,-4007.318,-4039.2454,-4029.8037,-4074.2341,-4100.044,-4034.6604,-3809.151,-3719.8196,-3734.3262,-3634.0618,-3610.4531,-3582.5242,-3533.811,-3472.8264,-3447.2532,-3434.641,-3414.6274,-3408.0505,-3122.3496,-3059.5447,-3088.4934,-3094.8655,-3022.0317,-2992.8442,-2984.9268,-2978.764,-2977.1853,-2926.972,-2876.2412,-2853.7188,-2819.707,-2796.9895,-2810.4607,-2819.7415,-2819.7622,-2811.3518,-2840.2122,-2820.3381,-2796.1592,-2749.193,-2688.4026,-2667.7917,-2644.4646,-2624.7124,-2619.531,-2613.42,-2599.442,-2616.2886,-2590.7957,-2526.9043],solid=False,xDimension=32,xSpacing=2.903226,yScale=50.0,zDimension=32,zSpacing=2.903226,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.03226,0.00391),(0.06452,0.00391),(0.09677,0.00391),(0.12903,0.00391),(0.16129,0.00391),(0.19355,0.00391),(0.22581,0.00391),(0.25806,0.00391),(0.29032,0.00391),(0.32258,0.00391),(0.35484,0.00391),(0.3871,0.00391),(0.41935,0.00391),(0.45161,0.00391),(0.48387,0.00391),(0.51613,0.00391),(0.54839,0.00391),(0.58065,0.00391),(0.6129,0.00391),(0.64516,0.00391),(0.67742,0.00391),(0.70968,0.00391),(0.74194,0.00391),(0.77419,0.00391),(0.80645,0.00391),(0.83871,0.00391),(0.87097,0.00391),(0.90323,0.00391),(0.93548,0.00391),(0.96774,0.00391),(0.99609,0.00391),(0.00391,0.03226),(0.03226,0.03226),(0.06452,0.03226),(0.09677,0.03226),(0.12903,0.03226),(0.16129,0.03226),(0.19355,0.03226),(0.22581,0.03226),(0.25806,0.03226),(0.29032,0.03226),(0.32258,0.03226),(0.35484,0.03226),(0.3871,0.03226),(0.41935,0.03226),(0.45161,0.03226),(0.48387,0.03226),(0.51613,0.03226),(0.54839,0.03226),(0.58065,0.03226),(0.6129,0.03226),(0.64516,0.03226),(0.67742,0.03226),(0.70968,0.03226),(0.74194,0.03226),(0.77419,0.03226),(0.80645,0.03226),(0.83871,0.03226),(0.87097,0.03226),(0.90323,0.03226),(0.93548,0.03226),(0.96774,0.03226),(0.99609,0.03226),(0.00391,0.06452),(0.03226,0.06452),(0.06452,0.06452),(0.09677,0.06452),(0.12903,0.06452),(0.16129,0.06452),(0.19355,0.06452),(0.22581,0.06452),(0.25806,0.06452),(0.29032,0.06452),(0.32258,0.06452),(0.35484,0.06452),(0.3871,0.06452),(0.41935,0.06452),(0.45161,0.06452),(0.48387,0.06452),(0.51613,0.06452),(0.54839,0.06452),(0.58065,0.06452),(0.6129,0.06452),(0.64516,0.06452),(0.67742,0.06452),(0.70968,0.06452),(0.74194,0.06452),(0.77419,0.06452),(0.80645,0.06452),(0.83871,0.06452),(0.87097,0.06452),(0.90323,0.06452),(0.93548,0.06452),(0.96774,0.06452),(0.99609,0.06452),(0.00391,0.09677),(0.03226,0.09677),(0.06452,0.09677),(0.09677,0.09677),(0.12903,0.09677),(0.16129,0.09677),(0.19355,0.09677),(0.22581,0.09677),(0.25806,0.09677),(0.29032,0.09677),(0.32258,0.09677),(0.35484,0.09677),(0.3871,0.09677),(0.41935,0.09677),(0.45161,0.09677),(0.48387,0.09677),(0.51613,0.09677),(0.54839,0.09677),(0.58065,0.09677),(0.6129,0.09677),(0.64516,0.09677),(0.67742,0.09677),(0.70968,0.09677),(0.74194,0.09677),(0.77419,0.09677),(0.80645,0.09677),(0.83871,0.09677),(0.87097,0.09677),(0.90323,0.09677),(0.93548,0.09677),(0.96774,0.09677),(0.99609,0.09677),(0.00391,0.12903),(0.03226,0.12903),(0.06452,0.12903),(0.09677,0.12903),(0.12903,0.12903),(0.16129,0.12903),(0.19355,0.12903),(0.22581,0.12903),(0.25806,0.12903),(0.29032,0.12903),(0.32258,0.12903),(0.35484,0.12903),(0.3871,0.12903),(0.41935,0.12903),(0.45161,0.12903),(0.48387,0.12903),(0.51613,0.12903),(0.54839,0.12903),(0.58065,0.12903),(0.6129,0.12903),(0.64516,0.12903),(0.67742,0.12903),(0.70968,0.12903),(0.74194,0.12903),(0.77419,0.12903),(0.80645,0.12903),(0.83871,0.12903),(0.87097,0.12903),(0.90323,0.12903),(0.93548,0.12903),(0.96774,0.12903),(0.99609,0.12903),(0.00391,0.16129),(0.03226,0.16129),(0.06452,0.16129),(0.09677,0.16129),(0.12903,0.16129),(0.16129,0.16129),(0.19355,0.16129),(0.22581,0.16129),(0.25806,0.16129),(0.29032,0.16129),(0.32258,0.16129),(0.35484,0.16129),(0.3871,0.16129),(0.41935,0.16129),(0.45161,0.16129),(0.48387,0.16129),(0.51613,0.16129),(0.54839,0.16129),(0.58065,0.16129),(0.6129,0.16129),(0.64516,0.16129),(0.67742,0.16129),(0.70968,0.16129),(0.74194,0.16129),(0.77419,0.16129),(0.80645,0.16129),(0.83871,0.16129),(0.87097,0.16129),(0.90323,0.16129),(0.93548,0.16129),(0.96774,0.16129),(0.99609,0.16129),(0.00391,0.19355),(0.03226,0.19355),(0.06452,0.19355),(0.09677,0.19355),(0.12903,0.19355),(0.16129,0.19355),(0.19355,0.19355),(0.22581,0.19355),(0.25806,0.19355),(0.29032,0.19355),(0.32258,0.19355),(0.35484,0.19355),(0.3871,0.19355),(0.41935,0.19355),(0.45161,0.19355),(0.48387,0.19355),(0.51613,0.19355),(0.54839,0.19355),(0.58065,0.19355),(0.6129,0.19355),(0.64516,0.19355),(0.67742,0.19355),(0.70968,0.19355),(0.74194,0.19355),(0.77419,0.19355),(0.80645,0.19355),(0.83871,0.19355),(0.87097,0.19355),(0.90323,0.19355),(0.93548,0.19355),(0.96774,0.19355),(0.99609,0.19355),(0.00391,0.22581),(0.03226,0.22581),(0.06452,0.22581),(0.09677,0.22581),(0.12903,0.22581),(0.16129,0.22581),(0.19355,0.22581),(0.22581,0.22581),(0.25806,0.22581),(0.29032,0.22581),(0.32258,0.22581),(0.35484,0.22581),(0.3871,0.22581),(0.41935,0.22581),(0.45161,0.22581),(0.48387,0.22581),(0.51613,0.22581),(0.54839,0.22581),(0.58065,0.22581),(0.6129,0.22581),(0.64516,0.22581),(0.67742,0.22581),(0.70968,0.22581),(0.74194,0.22581),(0.77419,0.22581),(0.80645,0.22581),(0.83871,0.22581),(0.87097,0.22581),(0.90323,0.22581),(0.93548,0.22581),(0.96774,0.22581),(0.99609,0.22581),(0.00391,0.25806),(0.03226,0.25806),(0.06452,0.25806),(0.09677,0.25806),(0.12903,0.25806),(0.16129,0.25806),(0.19355,0.25806),(0.22581,0.25806),(0.25806,0.25806),(0.29032,0.25806),(0.32258,0.25806),(0.35484,0.25806),(0.3871,0.25806),(0.41935,0.25806),(0.45161,0.25806),(0.48387,0.25806),(0.51613,0.25806),(0.54839,0.25806),(0.58065,0.25806),(0.6129,0.25806),(0.64516,0.25806),(0.67742,0.25806),(0.70968,0.25806),(0.74194,0.25806),(0.77419,0.25806),(0.80645,0.25806),(0.83871,0.25806),(0.87097,0.25806),(0.90323,0.25806),(0.93548,0.25806),(0.96774,0.25806),(0.99609,0.25806),(0.00391,0.29032),(0.03226,0.29032),(0.06452,0.29032),(0.09677,0.29032),(0.12903,0.29032),(0.16129,0.29032),(0.19355,0.29032),(0.22581,0.29032),(0.25806,0.29032),(0.29032,0.29032),(0.32258,0.29032),(0.35484,0.29032),(0.3871,0.29032),(0.41935,0.29032),(0.45161,0.29032),(0.48387,0.29032),(0.51613,0.29032),(0.54839,0.29032),(0.58065,0.29032),(0.6129,0.29032),(0.64516,0.29032),(0.67742,0.29032),(0.70968,0.29032),(0.74194,0.29032),(0.77419,0.29032),(0.80645,0.29032),(0.83871,0.29032),(0.87097,0.29032),(0.90323,0.29032),(0.93548,0.29032),(0.96774,0.29032),(0.99609,0.29032),(0.00391,0.32258),(0.03226,0.32258),(0.06452,0.32258),(0.09677,0.32258),(0.12903,0.32258),(0.16129,0.32258),(0.19355,0.32258),(0.22581,0.32258),(0.25806,0.32258),(0.29032,0.32258),(0.32258,0.32258),(0.35484,0.32258),(0.3871,0.32258),(0.41935,0.32258),(0.45161,0.32258),(0.48387,0.32258),(0.51613,0.32258),(0.54839,0.32258),(0.58065,0.32258),(0.6129,0.32258),(0.64516,0.32258),(0.67742,0.32258),(0.70968,0.32258),(0.74194,0.32258),(0.77419,0.32258),(0.80645,0.32258),(0.83871,0.32258),(0.87097,0.32258),(0.90323,0.32258),(0.93548,0.32258),(0.96774,0.32258),(0.99609,0.32258),(0.00391,0.35484),(0.03226,0.35484),(0.06452,0.35484),(0.09677,0.35484),(0.12903,0.35484),(0.16129,0.35484),(0.19355,0.35484),(0.22581,0.35484),(0.25806,0.35484),(0.29032,0.35484),(0.32258,0.35484),(0.35484,0.35484),(0.3871,0.35484),(0.41935,0.35484),(0.45161,0.35484),(0.48387,0.35484),(0.51613,0.35484),(0.54839,0.35484),(0.58065,0.35484),(0.6129,0.35484),(0.64516,0.35484),(0.67742,0.35484),(0.70968,0.35484),(0.74194,0.35484),(0.77419,0.35484),(0.80645,0.35484),(0.83871,0.35484),(0.87097,0.35484),(0.90323,0.35484),(0.93548,0.35484),(0.96774,0.35484),(0.99609,0.35484),(0.00391,0.3871),(0.03226,0.3871),(0.06452,0.3871),(0.09677,0.3871),(0.12903,0.3871),(0.16129,0.3871),(0.19355,0.3871),(0.22581,0.3871),(0.25806,0.3871),(0.29032,0.3871),(0.32258,0.3871),(0.35484,0.3871),(0.3871,0.3871),(0.41935,0.3871),(0.45161,0.3871),(0.48387,0.3871),(0.51613,0.3871),(0.54839,0.3871),(0.58065,0.3871),(0.6129,0.3871),(0.64516,0.3871),(0.67742,0.3871),(0.70968,0.3871),(0.74194,0.3871),(0.77419,0.3871),(0.80645,0.3871),(0.83871,0.3871),(0.87097,0.3871),(0.90323,0.3871),(0.93548,0.3871),(0.96774,0.3871),(0.99609,0.3871),(0.00391,0.41935),(0.03226,0.41935),(0.06452,0.41935),(0.09677,0.41935),(0.12903,0.41935),(0.16129,0.41935),(0.19355,0.41935),(0.22581,0.41935),(0.25806,0.41935),(0.29032,0.41935),(0.32258,0.41935),(0.35484,0.41935),(0.3871,0.41935),(0.41935,0.41935),(0.45161,0.41935),(0.48387,0.41935),(0.51613,0.41935),(0.54839,0.41935),(0.58065,0.41935),(0.6129,0.41935),(0.64516,0.41935),(0.67742,0.41935),(0.70968,0.41935),(0.74194,0.41935),(0.77419,0.41935),(0.80645,0.41935),(0.83871,0.41935),(0.87097,0.41935),(0.90323,0.41935),(0.93548,0.41935),(0.96774,0.41935),(0.99609,0.41935),(0.00391,0.45161),(0.03226,0.45161),(0.06452,0.45161),(0.09677,0.45161),(0.12903,0.45161),(0.16129,0.45161),(0.19355,0.45161),(0.22581,0.45161),(0.25806,0.45161),(0.29032,0.45161),(0.32258,0.45161),(0.35484,0.45161),(0.3871,0.45161),(0.41935,0.45161),(0.45161,0.45161),(0.48387,0.45161),(0.51613,0.45161),(0.54839,0.45161),(0.58065,0.45161),(0.6129,0.45161),(0.64516,0.45161),(0.67742,0.45161),(0.70968,0.45161),(0.74194,0.45161),(0.77419,0.45161),(0.80645,0.45161),(0.83871,0.45161),(0.87097,0.45161),(0.90323,0.45161),(0.93548,0.45161),(0.96774,0.45161),(0.99609,0.45161),(0.00391,0.48387),(0.03226,0.48387),(0.06452,0.48387),(0.09677,0.48387),(0.12903,0.48387),(0.16129,0.48387),(0.19355,0.48387),(0.22581,0.48387),(0.25806,0.48387),(0.29032,0.48387),(0.32258,0.48387),(0.35484,0.48387),(0.3871,0.48387),(0.41935,0.48387),(0.45161,0.48387),(0.48387,0.48387),(0.51613,0.48387),(0.54839,0.48387),(0.58065,0.48387),(0.6129,0.48387),(0.64516,0.48387),(0.67742,0.48387),(0.70968,0.48387),(0.74194,0.48387),(0.77419,0.48387),(0.80645,0.48387),(0.83871,0.48387),(0.87097,0.48387),(0.90323,0.48387),(0.93548,0.48387),(0.96774,0.48387),(0.99609,0.48387),(0.00391,0.51613),(0.03226,0.51613),(0.06452,0.51613),(0.09677,0.51613),(0.12903,0.51613),(0.16129,0.51613),(0.19355,0.51613),(0.22581,0.51613),(0.25806,0.51613),(0.29032,0.51613),(0.32258,0.51613),(0.35484,0.51613),(0.3871,0.51613),(0.41935,0.51613),(0.45161,0.51613),(0.48387,0.51613),(0.51613,0.51613),(0.54839,0.51613),(0.58065,0.51613),(0.6129,0.51613),(0.64516,0.51613),(0.67742,0.51613),(0.70968,0.51613),(0.74194,0.51613),(0.77419,0.51613),(0.80645,0.51613),(0.83871,0.51613),(0.87097,0.51613),(0.90323,0.51613),(0.93548,0.51613),(0.96774,0.51613),(0.99609,0.51613),(0.00391,0.54839),(0.03226,0.54839),(0.06452,0.54839),(0.09677,0.54839),(0.12903,0.54839),(0.16129,0.54839),(0.19355,0.54839),(0.22581,0.54839),(0.25806,0.54839),(0.29032,0.54839),(0.32258,0.54839),(0.35484,0.54839),(0.3871,0.54839),(0.41935,0.54839),(0.45161,0.54839),(0.48387,0.54839),(0.51613,0.54839),(0.54839,0.54839),(0.58065,0.54839),(0.6129,0.54839),(0.64516,0.54839),(0.67742,0.54839),(0.70968,0.54839),(0.74194,0.54839),(0.77419,0.54839),(0.80645,0.54839),(0.83871,0.54839),(0.87097,0.54839),(0.90323,0.54839),(0.93548,0.54839),(0.96774,0.54839),(0.99609,0.54839),(0.00391,0.58065),(0.03226,0.58065),(0.06452,0.58065),(0.09677,0.58065),(0.12903,0.58065),(0.16129,0.58065),(0.19355,0.58065),(0.22581,0.58065),(0.25806,0.58065),(0.29032,0.58065),(0.32258,0.58065),(0.35484,0.58065),(0.3871,0.58065),(0.41935,0.58065),(0.45161,0.58065),(0.48387,0.58065),(0.51613,0.58065),(0.54839,0.58065),(0.58065,0.58065),(0.6129,0.58065),(0.64516,0.58065),(0.67742,0.58065),(0.70968,0.58065),(0.74194,0.58065),(0.77419,0.58065),(0.80645,0.58065),(0.83871,0.58065),(0.87097,0.58065),(0.90323,0.58065),(0.93548,0.58065),(0.96774,0.58065),(0.99609,0.58065),(0.00391,0.6129),(0.03226,0.6129),(0.06452,0.6129),(0.09677,0.6129),(0.12903,0.6129),(0.16129,0.6129),(0.19355,0.6129),(0.22581,0.6129),(0.25806,0.6129),(0.29032,0.6129),(0.32258,0.6129),(0.35484,0.6129),(0.3871,0.6129),(0.41935,0.6129),(0.45161,0.6129),(0.48387,0.6129),(0.51613,0.6129),(0.54839,0.6129),(0.58065,0.6129),(0.6129,0.6129),(0.64516,0.6129),(0.67742,0.6129),(0.70968,0.6129),(0.74194,0.6129),(0.77419,0.6129),(0.80645,0.6129),(0.83871,0.6129),(0.87097,0.6129),(0.90323,0.6129),(0.93548,0.6129),(0.96774,0.6129),(0.99609,0.6129),(0.00391,0.64516),(0.03226,0.64516),(0.06452,0.64516),(0.09677,0.64516),(0.12903,0.64516),(0.16129,0.64516),(0.19355,0.64516),(0.22581,0.64516),(0.25806,0.64516),(0.29032,0.64516),(0.32258,0.64516),(0.35484,0.64516),(0.3871,0.64516),(0.41935,0.64516),(0.45161,0.64516),(0.48387,0.64516),(0.51613,0.64516),(0.54839,0.64516),(0.58065,0.64516),(0.6129,0.64516),(0.64516,0.64516),(0.67742,0.64516),(0.70968,0.64516),(0.74194,0.64516),(0.77419,0.64516),(0.80645,0.64516),(0.83871,0.64516),(0.87097,0.64516),(0.90323,0.64516),(0.93548,0.64516),(0.96774,0.64516),(0.99609,0.64516),(0.00391,0.67742),(0.03226,0.67742),(0.06452,0.67742),(0.09677,0.67742),(0.12903,0.67742),(0.16129,0.67742),(0.19355,0.67742),(0.22581,0.67742),(0.25806,0.67742),(0.29032,0.67742),(0.32258,0.67742),(0.35484,0.67742),(0.3871,0.67742),(0.41935,0.67742),(0.45161,0.67742),(0.48387,0.67742),(0.51613,0.67742),(0.54839,0.67742),(0.58065,0.67742),(0.6129,0.67742),(0.64516,0.67742),(0.67742,0.67742),(0.70968,0.67742),(0.74194,0.67742),(0.77419,0.67742),(0.80645,0.67742),(0.83871,0.67742),(0.87097,0.67742),(0.90323,0.67742),(0.93548,0.67742),(0.96774,0.67742),(0.99609,0.67742),(0.00391,0.70968),(0.03226,0.70968),(0.06452,0.70968),(0.09677,0.70968),(0.12903,0.70968),(0.16129,0.70968),(0.19355,0.70968),(0.22581,0.70968),(0.25806,0.70968),(0.29032,0.70968),(0.32258,0.70968),(0.35484,0.70968),(0.3871,0.70968),(0.41935,0.70968),(0.45161,0.70968),(0.48387,0.70968),(0.51613,0.70968),(0.54839,0.70968),(0.58065,0.70968),(0.6129,0.70968),(0.64516,0.70968),(0.67742,0.70968),(0.70968,0.70968),(0.74194,0.70968),(0.77419,0.70968),(0.80645,0.70968),(0.83871,0.70968),(0.87097,0.70968),(0.90323,0.70968),(0.93548,0.70968),(0.96774,0.70968),(0.99609,0.70968),(0.00391,0.74194),(0.03226,0.74194),(0.06452,0.74194),(0.09677,0.74194),(0.12903,0.74194),(0.16129,0.74194),(0.19355,0.74194),(0.22581,0.74194),(0.25806,0.74194),(0.29032,0.74194),(0.32258,0.74194),(0.35484,0.74194),(0.3871,0.74194),(0.41935,0.74194),(0.45161,0.74194),(0.48387,0.74194),(0.51613,0.74194),(0.54839,0.74194),(0.58065,0.74194),(0.6129,0.74194),(0.64516,0.74194),(0.67742,0.74194),(0.70968,0.74194),(0.74194,0.74194),(0.77419,0.74194),(0.80645,0.74194),(0.83871,0.74194),(0.87097,0.74194),(0.90323,0.74194),(0.93548,0.74194),(0.96774,0.74194),(0.99609,0.74194),(0.00391,0.77419),(0.03226,0.77419),(0.06452,0.77419),(0.09677,0.77419),(0.12903,0.77419),(0.16129,0.77419),(0.19355,0.77419),(0.22581,0.77419),(0.25806,0.77419),(0.29032,0.77419),(0.32258,0.77419),(0.35484,0.77419),(0.3871,0.77419),(0.41935,0.77419),(0.45161,0.77419),(0.48387,0.77419),(0.51613,0.77419),(0.54839,0.77419),(0.58065,0.77419),(0.6129,0.77419),(0.64516,0.77419),(0.67742,0.77419),(0.70968,0.77419),(0.74194,0.77419),(0.77419,0.77419),(0.80645,0.77419),(0.83871,0.77419),(0.87097,0.77419),(0.90323,0.77419),(0.93548,0.77419),(0.96774,0.77419),(0.99609,0.77419),(0.00391,0.80645),(0.03226,0.80645),(0.06452,0.80645),(0.09677,0.80645),(0.12903,0.80645),(0.16129,0.80645),(0.19355,0.80645),(0.22581,0.80645),(0.25806,0.80645),(0.29032,0.80645),(0.32258,0.80645),(0.35484,0.80645),(0.3871,0.80645),(0.41935,0.80645),(0.45161,0.80645),(0.48387,0.80645),(0.51613,0.80645),(0.54839,0.80645),(0.58065,0.80645),(0.6129,0.80645),(0.64516,0.80645),(0.67742,0.80645),(0.70968,0.80645),(0.74194,0.80645),(0.77419,0.80645),(0.80645,0.80645),(0.83871,0.80645),(0.87097,0.80645),(0.90323,0.80645),(0.93548,0.80645),(0.96774,0.80645),(0.99609,0.80645),(0.00391,0.83871),(0.03226,0.83871),(0.06452,0.83871),(0.09677,0.83871),(0.12903,0.83871),(0.16129,0.83871),(0.19355,0.83871),(0.22581,0.83871),(0.25806,0.83871),(0.29032,0.83871),(0.32258,0.83871),(0.35484,0.83871),(0.3871,0.83871),(0.41935,0.83871),(0.45161,0.83871),(0.48387,0.83871),(0.51613,0.83871),(0.54839,0.83871),(0.58065,0.83871),(0.6129,0.83871),(0.64516,0.83871),(0.67742,0.83871),(0.70968,0.83871),(0.74194,0.83871),(0.77419,0.83871),(0.80645,0.83871),(0.83871,0.83871),(0.87097,0.83871),(0.90323,0.83871),(0.93548,0.83871),(0.96774,0.83871),(0.99609,0.83871),(0.00391,0.87097),(0.03226,0.87097),(0.06452,0.87097),(0.09677,0.87097),(0.12903,0.87097),(0.16129,0.87097),(0.19355,0.87097),(0.22581,0.87097),(0.25806,0.87097),(0.29032,0.87097),(0.32258,0.87097),(0.35484,0.87097),(0.3871,0.87097),(0.41935,0.87097),(0.45161,0.87097),(0.48387,0.87097),(0.51613,0.87097),(0.54839,0.87097),(0.58065,0.87097),(0.6129,0.87097),(0.64516,0.87097),(0.67742,0.87097),(0.70968,0.87097),(0.74194,0.87097),(0.77419,0.87097),(0.80645,0.87097),(0.83871,0.87097),(0.87097,0.87097),(0.90323,0.87097),(0.93548,0.87097),(0.96774,0.87097),(0.99609,0.87097),(0.00391,0.90323),(0.03226,0.90323),(0.06452,0.90323),(0.09677,0.90323),(0.12903,0.90323),(0.16129,0.90323),(0.19355,0.90323),(0.22581,0.90323),(0.25806,0.90323),(0.29032,0.90323),(0.32258,0.90323),(0.35484,0.90323),(0.3871,0.90323),(0.41935,0.90323),(0.45161,0.90323),(0.48387,0.90323),(0.51613,0.90323),(0.54839,0.90323),(0.58065,0.90323),(0.6129,0.90323),(0.64516,0.90323),(0.67742,0.90323),(0.70968,0.90323),(0.74194,0.90323),(0.77419,0.90323),(0.80645,0.90323),(0.83871,0.90323),(0.87097,0.90323),(0.90323,0.90323),(0.93548,0.90323),(0.96774,0.90323),(0.99609,0.90323),(0.00391,0.93548),(0.03226,0.93548),(0.06452,0.93548),(0.09677,0.93548),(0.12903,0.93548),(0.16129,0.93548),(0.19355,0.93548),(0.22581,0.93548),(0.25806,0.93548),(0.29032,0.93548),(0.32258,0.93548),(0.35484,0.93548),(0.3871,0.93548),(0.41935,0.93548),(0.45161,0.93548),(0.48387,0.93548),(0.51613,0.93548),(0.54839,0.93548),(0.58065,0.93548),(0.6129,0.93548),(0.64516,0.93548),(0.67742,0.93548),(0.70968,0.93548),(0.74194,0.93548),(0.77419,0.93548),(0.80645,0.93548),(0.83871,0.93548),(0.87097,0.93548),(0.90323,0.93548),(0.93548,0.93548),(0.96774,0.93548),(0.99609,0.93548),(0.00391,0.96774),(0.03226,0.96774),(0.06452,0.96774),(0.09677,0.96774),(0.12903,0.96774),(0.16129,0.96774),(0.19355,0.96774),(0.22581,0.96774),(0.25806,0.96774),(0.29032,0.96774),(0.32258,0.96774),(0.35484,0.96774),(0.3871,0.96774),(0.41935,0.96774),(0.45161,0.96774),(0.48387,0.96774),(0.51613,0.96774),(0.54839,0.96774),(0.58065,0.96774),(0.6129,0.96774),(0.64516,0.96774),(0.67742,0.96774),(0.70968,0.96774),(0.74194,0.96774),(0.77419,0.96774),(0.80645,0.96774),(0.83871,0.96774),(0.87097,0.96774),(0.90323,0.96774),(0.93548,0.96774),(0.96774,0.96774),(0.99609,0.96774),(0.00391,0.99609),(0.03226,0.99609),(0.06452,0.99609),(0.09677,0.99609),(0.12903,0.99609),(0.16129,0.99609),(0.19355,0.99609),(0.22581,0.99609),(0.25806,0.99609),(0.29032,0.99609),(0.32258,0.99609),(0.35484,0.99609),(0.3871,0.99609),(0.41935,0.99609),(0.45161,0.99609),(0.48387,0.99609),(0.51613,0.99609),(0.54839,0.99609),(0.58065,0.99609),(0.6129,0.99609),(0.64516,0.99609),(0.67742,0.99609),(0.70968,0.99609),(0.74194,0.99609),(0.77419,0.99609),(0.80645,0.99609),(0.83871,0.99609),(0.87097,0.99609),(0.90323,0.99609),(0.93548,0.99609),(0.96774,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD003.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD003.py load and self-test diagnostics complete.")
