####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MarsLOD002.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='MarsLOD002.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Mars.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD002.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MarsLOD002.x3d'),
    GeoLOD(center=(-44.911417,-134.911417,326075.000000),range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/Mars000.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars000.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,-180.000000,0.000000),height=[3892.063,3897.023,3916.6833,3910.3115,3896.136,3879.4854,3870.0425,3863.4766,3855.8982,3850.3074,3844.27,3836.7686,3822.832,3806.7122,3792.8594,3780.3264,3766.3188,3757.2234,3754.8325,3762.906,3772.7148,3777.298,3783.1428,3788.2659,3794.5671,3791.1694,3798.2437,3785.204,3774.5146,3766.215,3770.1902,3778.3477,3785.3042,3784.7666,3776.3481,3771.633,3764.5093,3744.0789,3727.5505,3703.327,3638.2957,3542.1072,3476.4473,3424.865,3406.8235,3406.8354,3401.6074,3388.9597,3386.5625,3383.6584,3394.527,3402.9673,3408.8364,3409.8757,3422.4944,3437.194,3447.7163,3472.8818,3506.479,3543.774,3567.0957,3570.5793,3569.9883,3569.4434,3568.8005,3568.2834,3567.3298,3567.4568,3565.1868,3564.9434,3576.845,3595.5168,3624.912,3625.6553,3623.6404,3606.3354,3599.2173,3607.0671,3614.4133,3620.6194,3629.1802,3638.9563,3648.1787,3664.0386,3667.4429,3672.1196,3674.2483,3672.0342,3669.0007,3667.3254,3670.5242,3665.2092,3658.9268,3653.31,3646.1465,3649.3184,3631.7686,3624.9395,3632.6082,3633.7437,3626.231,3627.9866,3624.3674,3619.0918,3614.1877,3603.585,3591.3853,3579.3171,3571.1157,3571.223,3567.6094,3575.8691,3583.31,3585.6687,3591.925,3611.5774,3606.2312,3619.7273,3625.8003,3629.7168,3636.6152,3641.547,3645.5227,3652.049,3654.2158,3658.387,3663.585,3663.9185,3342.6516,3322.1404,3301.3135,3291.7104,3296.954,3370.103,3454.6934,3510.6904,3544.995,3556.211,3542.0542,3474.411,3348.5403,3253.325,3113.388,2996.0173,2923.8003,2874.3518,2865.994,2887.6787,2929.445,2952.4573,2962.8,2967.872,2961.8774,2915.1738,2892.09,2902.4258,2872.983,2839.6575,2821.7966,2807.7788,2825.6824,2839.0715,2827.8086,2818.353,2838.2307,2837.8647,2814.3716,2790.7607,2776.5483,2812.7944,2797.7412,2778.78,2790.7437,2801.84,2799.295,2792.1562,2796.1128,2804.4844,2814.3955,2816.1238,2834.353,2845.1455,2852.2866,2858.777,2861.7314,2867.1055,2872.4983,2883.1387,2893.6365,2875.747,2865.8767,2863.0535,2863.5488,2861.8562,2864.533,2868.8145,2866.5376,2865.7861,2873.2124,2861.2275,2877.7485,2876.8816,2887.751,2889.613,2889.7744,2900.028,2898.704,2887.5044,2891.1267,2903.5342,2905.8594,2924.1543,2942.3018,2964.759,2950.4836,2904.3894,2863.437,2850.065,2873.4314,2906.3064,2915.059,2910.7986,2901.7212,2907.182,2904.9429,2923.2925,2934.338,2940.255,2958.722,2971.0337,2970.3938,2969.3142,2977.3892,2979.3281,2964.6155,2939.0083,2936.2034,2946.3923,2943.5986,2969.6082,2994.5217,3038.779,3064.8518,3085.9814,3045.6074,3106.4807,3120.863,3141.9915,3169.7231,3203.8455,3225.762,3237.8018,3254.5227,3287.602,3321.3303,3346.9036,2228.7002,2172.5,2171.1643,2201.9575,2238.147,2565.7947,2936.7642,3127.2666,3217.9883,3243.5818,3210.4082,3129.7302,3013.466,2897.064,2787.4219,2697.1138,2566.6497,2460.835,2473.9812,2503.5432,2486.546,2392.2644,2321.72,2325.3308,2352.4539,2405.8086,2550.1216,2471.0376,2469.3757,2488.702,2479.4465,2465.4875,2463.5164,2577.4807,2768.3452,2806.3396,2839.7305,2875.2273,2884.4512,2873.5825,2865.5823,2905.2986,2896.9973,2873.5955,2863.1384,2862.2573,2865.1252,2859.8066,2848.691,2846.3416,2850.0786,2867.066,2902.7625,2919.5764,2922.0159,2947.5544,2974.024,2981.8154,2986.2822,2989.3052,2982.0803,2938.7075,2895.3435,2846.0005,2790.244,2711.082,2671.5525,2674.2214,2728.3184,2833.8108,2788.1135,2756.5007,2790.65,2839.4163,2860.4124,2866.5476,2872.1736,2900.0776,2920.9956,2907.8943,2905.8867,2902.865,2917.3145,2931.7258,2985.7627,3030.2898,2986.995,2802.429,2710.2327,2723.1892,2793.1758,2872.8533,2918.8367,2944.344,2954.2239,2966.4297,2976.9656,2972.4292,2969.8003,2977.774,2992.8804,3009.6248,3017.822,3021.9937,3024.0374,3025.5708,3010.2668,3001.3203,3023.3027,3046.4526,3016.582,2976.1658,2953.7595,2942.6228,2937.678,2949.5098,2960.5886,2957.173,2940.9966,2932.1406,2933.4504,2954.3425,2977.412,2967.244,2970.3,2995.215,3012.738,3024.6682,2555.2822,2534.307,2539.2612,2647.9062,2675.5107,2660.9475,2676.92,2677.2024,2670.0342,2631.4412,2583.1978,2537.123,2503.9766,2494.3616,2512.898,2552.3752,2583.0684,2607.4595,2628.9507,2645.4114,2648.0874,2636.0364,2639.2925,2654.4172,2670.4346,2689.8,2726.413,2716.77,2710.8042,2703.9165,2695.5542,2692.8936,2698.7258,2718.525,2753.1895,2788.0217,2809.481,2823.0764,2832.7395,2838.1677,2837.3704,2835.0947,2834.3882,2832.8328,2828.2092,2824.9392,2824.7085,2818.5193,2811.8694,2810.959,2810.241,2810.7834,2816.9717,2812.8618,2806.4043,2811.905,2801.6487,2797.3462,2802.4912,2788.8428,2759.0762,2725.4316,2704.4226,2685.1335,2669.8147,2661.6897,2650.3372,2657.6914,2694.8154,2729.3918,2708.5127,2698.2102,2697.5977,2705.7493,2718.9956,2730.2788,2730.5793,2730.478,2764.1238,2727.4497,2732.7412,2746.2004,2765.2073,2781.4604,2762.2356,2764.885,2777.7703,2708.7942,2678.5825,2691.9329,2727.9944,2761.8315,2776.5178,2785.747,2785.257,2785.557,2787.6216,2786.736,2788.7852,2795.2285,2798.4617,2800.354,2803.3933,2805.0813,2808.519,2815.49,2811.235,2811.1218,2823.4727,2830.5444,2809.258,2781.5564,2764.2842,2755.013,2756.471,2769.6223,2786.583,2802.2292,2814.5784,2820.2053,2826.0857,2835.559,2846.2373,2853.1929,2853.708,2856.3882,2863.4016,2865.5012,2478.5078,2528.905,2573.8486,2608.3215,2649.4966,2695.2856,2742.714,2779.5557,2791.6877,2785.4922,2761.0503,2752.5186,2747.389,2740.55,2728.201,2717.6968,2717.0466,2721.4473,2725.867,2731.6392,2739.043,2741.601,2746.1492,2746.2947,2744.6516,2743.1682,2740.4465,2736.2466,2734.611,2732.633,2735.293,2736.4697,2740.2737,2750.176,2758.037,2765.1777,2774.57,2785.1702,2795.2139,2809.9966,2824.5032,2840.2515,2858.1003,2874.3118,2888.0012,2897.734,2900.974,2901.4897,2902.7834,2908.4187,2911.6763,2905.3223,2893.3643,2884.204,2876.8013,2870.1255,2861.0645,2845.9004,2826.9229,2801.1526,2786.3118,2777.0938,2763.6895,2747.3755,2718.4597,2685.3804,2661.6426,2641.5752,2615.7754,2593.0527,2577.5222,2577.031,2580.2437,2582.5212,2574.3213,2559.4954,2549.1003,2536.7126,2524.1304,2512.8403,2500.3523,2479.6755,2463.2168,2451.955,2439.4646,2426.581,2418.793,2415.2656,2419.56,2426.31,2437.188,2451.9468,2467.1963,2491.303,2509.0764,2529.7173,2556.1052,2592.0593,2630.4397,2672.9502,2713.9612,2745.9053,2777.7275,2788.133,2773.984,2749.5737,2722.5422,2690.2021,2658.098,2631.5645,2608.2822,2602.1353,2602.135,2607.5168,2608.3264,2594.304,2596.267,2597.4546,2611.5325,2621.244,2623.7952,2630.3376,2634.1067,2646.8015,2667.6118,2681.3206,2698.6946,2710.7454,2886.5945,2877.4233,2867.6855,2853.1416,2846.1436,2839.2668,2836.9897,2840.1436,2843.4448,2843.8738,2846.4788,2850.2942,2841.3274,2838.4644,2830.4163,2814.9504,2813.118,2818.072,2821.1948,2827.4814,2837.1128,2848.5596,2863.2805,2876.5786,2889.645,2896.411,2896.3896,2899.1758,2899.612,2892.528,2898.5457,2900.9133,2905.9407,2902.4402,2894.9312,2884.429,2869.4585,2845.6191,2826.7449,2822.1619,2830.3965,2835.2961,2834.7034,2840.1814,2848.4998,2857.7092,2864.9382,2876.1921,2889.9263,2909.3237,2926.1196,2943.7573,2953.889,2960.1145,2965.5347,2973.3462,2978.2546,2983.7415,2988.048,2993.6604,2996.726,2994.8044,2993.4368,2981.0647,2970.0923,2961.5466,2950.0417,2935.5623,2926.4294,2916.4917,2908.3567,2898.9285,2886.052,2868.6257,2852.2612,2822.5403,2781.265,2740.658,2703.0103,2647.5947,2598.5234,2538.941,2472.3271,2396.0752,2302.7886,2190.8848,2096.9614,2035.3417,1999.832,1977.5212,1953.8058,1946.189,1948.8307,1960.2146,1985.2616,2008.3923,2028.0444,2058.0164,2097.212,2165.9702,2223.8718,2225.1821,2219.7463,2242.1765,2264.1172,2277.021,2300.0513,2338.7068,2370.2227,2431.213,2479.777,2485.0632,2488.4236,2483.4226,2463.6458,2430.7197,2404.397,2416.852,2443.9524,2449.1245,2462.4385,2468.8022,2478.6682,2492.7354,2504.6423,2520.2864,2513.128,2506.6143,3033.075,3035.428,3039.2002,3040.0728,3038.0515,3036.3413,3037.4194,3038.2588,3038.313,3037.1982,3036.3342,3034.9094,3034.2266,3034.0623,3033.5513,3028.796,3022.5344,3017.7498,3014.3584,3011.4834,3009.1462,3003.6294,2999.7478,2996.179,2993.1575,2991.7607,2989.1184,2987.0208,2984.4753,2981.6816,2978.4016,2975.1958,2972.003,2965.8367,2952.6868,2924.5278,2898.6877,2892.8088,2903.0957,2922.3438,2941.3372,2955.956,2955.9526,2954.0217,2956.6985,2964.3047,2975.1777,2976.442,2970.4692,2966.3901,2962.4502,2957.83,2954.62,2950.043,2947.9028,2945.1006,2939.5803,2932.172,2926.2336,2919.065,2913.8047,2907.074,2900.7004,2891.605,2879.6582,2866.9802,2853.4458,2836.9739,2820.881,2819.4744,2825.2188,2827.2737,2829.4495,2837.0432,2832.0374,2809.7646,2787.5327,2776.3818,2759.7397,2715.6538,2668.375,2651.0425,2645.6619,2629.4602,2571.78,2486.9653,2435.5674,2426.4355,2416.6355,2400.087,2384.9524,2388.5803,2384.2341,2391.21,2407.7512,2415.7441,2421.3884,2438.3115,2461.7444,2482.5117,2485.8257,2473.158,2460.6868,2474.368,2478.2004,2460.4988,2447.092,2453.8762,2470.5125,2494.9443,2493.5413,2461.0547,2424.5784,2383.9744,2325.9285,2279.4966,2233.5295,2200.9307,2220.995,2245.9248,2228.649,2220.3696,2224.5547,2245.4473,2260.5725,2253.7317,2221.632,2205.085,3037.6514,3034.8174,3030.9712,3027.619,3026.1694,3025.4543,3023.9023,3022.7341,3020.8108,3021.5864,3020.4597,3019.0935,3017.727,3016.346,3014.051,3011.2473,3009.16,3006.7737,3005.3657,3005.8364,3003.8596,2999.0374,2993.7214,2989.5881,2984.4722,2980.6602,2977.0183,2972.6082,2966.995,2960.3445,2953.4016,2945.6394,2938.6023,2931.005,2920.5933,2909.5527,2900.235,2891.2197,2886.2888,2884.6135,2881.931,2869.512,2848.4375,2822.8232,2799.7983,2792.666,2793.725,2801.3826,2806.9302,2810.9248,2808.0667,2799.7437,2777.9587,2727.9275,2681.8982,2656.8115,2646.4233,2654.1304,2665.922,2666.2056,2664.694,2657.0112,2643.6694,2630.3093,2626.319,2628.071,2631.7375,2644.4343,2657.3347,2645.4646,2643.8806,2646.1274,2658.858,2672.1746,2669.4949,2657.168,2649.371,2653.4873,2630.325,2607.8137,2620.167,2655.9387,2662.537,2626.2485,2564.2478,2508.0684,2458.2712,2396.2698,2373.6953,2398.6257,2418.4448,2431.5793,2429.741,2399.9358,2405.1145,2429.7676,2425.5476,2392.4119,2368.8206,2357.6768,2349.4712,2379.3867,2432.0837,2488.052,2532.4053,2575.8767,2605.9102,2620.8054,2626.0154,2625.1282,2620.7258,2618.3464,2613.256,2605.063,2594.438,2584.5208,2567.1768,2543.0242,2515.1218,2492.0977,2471.626,2457.8403,2442.739,2428.238,2392.7854,2357.5027,2329.252,2299.9302,3035.9473,3031.5642,3027.175,3023.324,3019.8977,3017.0107,3013.9128,3010.9458,3007.8655,3004.864,3003.2073,3002.2976,3001.553,3000.656,2998.8518,2995.8335,2993.402,2990.7375,2988.109,2986.4338,2984.033,2982.0273,2979.5837,2976.7334,2973.4392,2969.1802,2964.6968,2960.917,2956.2495,2950.893,2947.1091,2943.4458,2940.3892,2935.601,2930.6074,2926.863,2923.1602,2919.5867,2916.49,2912.9429,2908.3074,2902.7615,2896.7534,2890.2358,2884.1555,2877.1707,2869.8792,2858.9563,2847.1672,2836.3782,2826.595,2817.298,2807.8845,2796.9358,2784.6802,2771.9692,2756.8345,2735.1746,2710.0085,2686.6934,2662.8975,2639.3955,2617.1514,2596.421,2573.5996,2550.8738,2530.4968,2504.7717,2489.3625,2488.522,2486.9648,2477.759,2469.8318,2461.9897,2467.7346,2483.3613,2503.951,2524.6704,2540.647,2550.242,2550.7168,2545.9834,2544.5784,2545.9097,2546.3938,2543.949,2544.8125,2545.9893,2549.6482,2564.8782,2582.3735,2594.8362,2594.5515,2580.2507,2562.116,2543.3457,2514.1296,2470.4946,2442.447,2421.8767,2386.7224,2368.1692,2359.9421,2350.2334,2319.2275,2309.145,2347.2197,2397.391,2446.2166,2478.9587,2478.3442,2484.9546,2481.0366,2471.2341,2462.2156,2468.5012,2476.6726,2490.2104,2504.7456,2505.2144,2498.3152,2489.0657,2477.9373,2467.5615,2455.7085,2439.6248,2422.1033,2404.3533,3012.5894,3005.7788,2999.1309,2992.748,2986.6458,2981.1035,2975.1902,2969.073,2962.72,2956.225,2952.5935,2952.8306,2956.5723,2959.695,2955.077,2948.5615,2943.431,2938.2986,2932.439,2926.8108,2920.0544,2913.244,2907.5818,2902.0454,2895.65,2889.677,2883.6748,2876.5974,2870.1494,2862.3887,2854.331,2845.4824,2836.287,2825.9395,2816.3813,2805.5627,2794.7856,2782.9568,2772.8198,2770.416,2785.696,2809.7693,2809.8152,2803.7344,2797.5537,2793.192,2787.5078,2778.738,2768.7559,2757.9001,2747.192,2736.458,2727.1553,2718.3499,2708.0654,2697.8027,2686.9382,2676.0596,2666.606,2660.4631,2655.8904,2650.8826,2643.6375,2635.6477,2627.4343,2619.012,2610.9343,2600.8684,2589.03,2576.11,2560.1875,2546.5933,2552.072,2556.668,2546.397,2530.0596,2512.5422,2494.6714,2473.9138,2451.6077,2432.072,2412.6401,2399.227,2376.8162,2348.7815,2333.6309,2334.4707,2345.4265,2361.933,2373.9304,2382.5823,2384.9326,2344.8306,2265.5073,2275.6704,2296.3025,2327.693,2342.5327,2344.2642,2334.4048,2336.2788,2345.7402,2343.0686,2347.1174,2349.8337,2342.5173,2330.9512,2317.5999,2289.22,2248.3647,2253.5425,2290.616,2315.5652,2334.3123,2398.4246,2440.5806,2436.4275,2439.6892,2439.5476,2438.2766,2438.8923,2439.5115,2442.7834,2442.5784,2433.83,2426.23,2407.776,2403.0942,2980.7344,2973.167,2966.8074,2960.772,2954.8467,2949.0715,2942.1123,2933.2178,2923.8513,2912.6528,2901.2136,2888.8655,2874.719,2875.9639,2887.4688,2882.03,2872.1626,2861.3467,2852.9734,2844.531,2834.7986,2825.6812,2817.9639,2811.5115,2805.1,2798.0303,2790.4927,2782.9683,2775.7397,2767.459,2759.8735,2750.2388,2741.4087,2732.5798,2722.3782,2712.6604,2703.4407,2689.3496,2675.1267,2664.391,2661.5034,2678.487,2697.6323,2684.4292,2675.0344,2666.2124,2656.0132,2647.1277,2639.7253,2634.477,2625.1265,2615.9998,2606.9724,2598.1853,2589.7422,2579.7334,2569.549,2559.242,2547.3264,2534.857,2522.8232,2512.829,2504.6345,2497.087,2488.6128,2480.6726,2471.7473,2463.8938,2456.1907,2445.7832,2437.9546,2430.5017,2414.596,2395.1704,2377.5757,2365.5278,2359.7947,2362.8289,2369.9177,2376.85,2381.6099,2383.1355,2372.4937,2362.1033,2349.5923,2340.8442,2326.3071,2297.019,2272.1924,2252.2427,2235.1316,2224.2832,2218.102,2212.3398,2201.708,2170.1074,2135.726,2101.85,2095.434,2127.1357,2142.1257,2180.8562,2198.4592,2193.2769,2187.52,2196.4875,2211.8523,2217.6814,2209.9844,2195.9307,2174.3909,2153.9873,2125.993,2106.4165,2089.5793,2202.6208,2313.967,2335.0342,2343.9097,2348.7986,2356.3655,2349.9336,2325.3323,2332.8381,2344.2017,2347.0078,2345.4746,2344.47,2904.2817,2890.5776,2874.4238,2865.1724,2877.552,2904.534,2904.184,2896.7368,2891.0935,2883.6536,2874.243,2864.6328,2852.4065,2839.499,2826.5996,2815.1938,2804.4119,2794.4885,2783.7249,2772.9614,2761.4473,2750.0017,2738.3923,2727.3894,2716.3372,2705.1643,2693.9915,2682.679,2671.2217,2660.4844,2649.4988,2636.9788,2623.8142,2608.1604,2587.4734,2561.1182,2530.571,2512.8804,2537.7605,2557.3103,2599.5781,2604.9673,2597.5237,2589.4026,2579.8982,2568.136,2556.997,2544.1484,2533.1355,2524.3816,2513.3083,2501.1401,2489.757,2478.085,2464.4724,2451.5789,2440.1257,2430.1104,2418.6458,2405.7512,2395.351,2389.2195,2381.031,2374.3916,2368.5264,2362.194,2355.0925,2344.7407,2333.1748,2319.4795,2312.112,2307.1702,2297.5366,2287.0154,2275.7134,2263.529,2252.1545,2238.159,2221.948,2207.1204,2195.7354,2188.9204,2174.3525,2159.5112,2149.1711,2146.2456,2139.5908,2117.2246,2098.301,2088.8835,2082.4495,2067.494,2036.6189,2022.9152,2028.2726,2016.1047,1984.3641,1976.9359,1985.3815,2029.113,2082.1152,2065.455,2054.1243,2059.6418,2060.5203,2050.668,2071.752,2099.284,2102.4507,2083.1729,2038.4148,2023.4844,2011.3763,1990.1968,1988.6395,2014.9702,2077.5269,2120.9556,2169.7202,2218.8896,2260.0776,2274.3145,2238.6912,2322.381,2358.6924,2370.9785,2321.5957,2364.7344,2714.2349,2664.9973,2652.9934,2650.5125,2644.1895,2645.8813,2671.0215,2644.6936,2612.1863,2592.8428,2619.6057,2698.3386,2783.53,2767.8406,2760.6472,2754.5232,2744.795,2733.393,2721.3877,2708.6006,2694.1714,2679.4475,2665.131,2650.2007,2634.165,2615.6277,2596.086,2577.6497,2558.623,2536.8628,2513.57,2485.171,2448.0146,2398.648,2332.9678,2260.9177,2229.6438,2241.3948,2404.5747,2525.1614,2518.2441,2521.3215,2519.3416,2516.7114,2505.6575,2493.3784,2480.2913,2466.6968,2451.1409,2435.5518,2420.8782,2405.853,2391.2053,2376.8513,2370.0493,2362.8171,2348.9658,2335.659,2326.6445,2308.7778,2289.2517,2277.409,2259.558,2243.3103,2236.5452,2234.7627,2226.7786,2209.63,2195.0132,2183.5964,2170.287,2156.7866,2132.3862,2106.9937,2087.0615,2059.9177,2035.1014,2070.921,2089.3088,2080.1396,2069.6667,2053.6685,2034.0643,2011.986,1985.6216,1959.3909,1933.2018,1905.2552,1875.2047,1839.0559,1800.3727,1769.7128,1766.993,1798.2434,1865.0653,1912.7478,1904.3037,1894.7654,1860.7886,1785.4733,1793.7057,1924.1605,1950.1321,1946.1735,1978.6022,2026.8408,1993.467,1943.8698,1944.4352,1941.6923,1954.8259,1958.0355,1935.0193,1849.9172,1803.014,1866.1981,1909.3705,2012.5316,2105.271,2157.913,2151.8755,2090.902,2119.0183,2092.3318,2062.3367,2080.09,2118.542,2160.5286,2686.005,2672.6963,2671.5432,2675.1052,2704.9229,2706.467,2686.0378,2683.3477,2696.4897,2695.9949,2683.9656,2658.4397,2647.7786,2627.0405,2617.2375,2637.281,2640.2456,2618.3298,2612.774,2656.7478,2637.501,2622.482,2607.8987,2594.0613,2579.4011,2566.0037,2553.3604,2540.0469,2523.555,2506.0022,2486.1604,2465.855,2442.5005,2415.3818,2383.966,2341.5117,2293.638,2253.3418,2193.6438,2132.0562,2095.3872,2133.5596,2130.4297,2166.0083,2236.365,2317.3157,2284.2693,2259.2754,2236.4978,2214.875,2198.158,2177.859,2168.737,2174.561,2174.4004,2154.912,2126.8618,2123.1426,2109.5027,2096.0894,2079.8145,2064.3953,2043.6765,2019.4242,1997.7736,1999.7614,2037.2847,2024.7881,2020.9569,2007.0831,1995.7261,1985.3632,1931.967,1895.9905,1805.5413,1471.8628,1330.0104,1479.8369,1659.3912,1591.1707,1590.8674,1837.446,1824.2699,1804.0029,1783.6543,1776.9722,1772.7599,1768.8607,1765.2505,1760.4431,1758.6783,1754.1096,1738.891,1714.046,1690.46,1659.888,1660.388,1704.0502,1730.1215,1750.0358,1742.927,1794.3481,1797.6837,1754.994,1737.735,1860.2443,1892.0138,1898.7742,1890.8586,1848.0742,1825.6006,1787.4148,1517.9514,1273.0916,1243.5189,1439.5172,1557.0565,1607.7982,1745.5197,1861.4546,1941.763,2039.4023,2026.9148,2074.0984,2016.3141,1967.2706,1948.7548,1948.6456,2631.335,2613.3132,2610.1892,2660.9817,2659.0928,2654.6023,2588.851,2497.5083,2495.99,2583.3853,2600.176,2575.4692,2512.974,2493.0166,2562.8542,2570.9956,2551.2888,2524.814,2506.4019,2520.236,2536.612,2529.8225,2518.1355,2502.8716,2474.1702,2425.631,2354.7249,2306.534,2355.621,2364.0732,2338.379,2394.6895,2401.0142,2366.2517,2346.6624,2340.2046,2328.1592,2299.376,2263.4807,2223.6038,2174.7014,2102.1196,2020.3892,2029.0808,1973.9131,2090.7732,2311.1245,2281.386,2257.157,2256.489,2250.9,2227.236,2203.5767,2264.2944,2251.1396,2210.2073,2185.5317,2156.9712,2135.538,2108.8499,2092.4949,2097.501,2086.9734,2067.8108,2019.0363,1801.217,1723.3619,1689.2017,1831.1304,1825.3962,1967.0427,2173.1177,2094.112,1989.7839,1934.3715,1682.0999,1444.5469,1390.6254,1402.3861,1424.1868,1589.4575,1691.3116,1671.4359,1656.773,1661.9965,1675.9253,1686.9025,1690.6398,1691.0582,1689.9237,1690.2208,1688.9186,1685.9585,1678.2291,1671.4163,1654.0177,1636.6364,1624.0221,1616.7847,1613.3789,1610.1853,1626.4968,1632.6346,1618.1294,1623.397,1670.7062,1696.8551,1659.8864,1699.9258,1692.2477,1708.9948,1756.5146,1711.3378,1639.398,1539.7013,1734.6263,1626.0504,1606.4089,1687.6962,1473.7898,1573.4811,1916.459,1596.9868,1794.0221,1994.9478,1971.0707,1897.795,1874.3108,2447.0498,2416.7983,2378.5684,2435.5447,2407.3206,2463.2354,2487.3057,2453.3037,2435.9177,2448.5586,2398.5903,2358.407,2364.3013,2371.4785,2362.7961,2364.5974,2374.441,2376.1895,2397.6624,2371.2734,2346.4497,2288.532,2345.541,2390.7065,2372.0212,2363.7495,2349.4768,2328.2832,2302.24,2272.7854,2240.291,2239.555,2263.8691,2281.3882,2254.046,2231.2764,2260.2441,2251.845,2197.0989,2150.717,2203.4072,2182.7168,2185.391,2230.0918,2196.1606,2160.2334,2154.4807,1759.3187,1586.5222,2003.8191,2031.3533,1997.137,1883.9103,1732.5653,2024.2773,2265.3164,2215.3374,2196.1099,2196.8794,2182.2766,2220.9604,2189.3838,2137.559,2184.445,2157.7927,2096.057,1808.4889,1694.6697,1648.2465,1691.4485,1925.5665,2180.5146,1990.7323,1693.6671,1596.2168,1705.5417,1724.6664,1651.1818,1636.1105,1666.4316,1596.2354,1569.4822,1586.5269,1602.7838,1615.3777,1647.0969,1669.6986,1646.2855,1635.806,1642.9905,1653.3395,1658.927,1655.0964,1648.41,1639.4943,1622.3857,1610.4641,1599.3353,1594.2068,1589.9568,1584.2567,1580.9766,1574.1155,1569.518,1563.6047,1561.3733,1564.8608,1569.0785,1574.8732,1572.6996,1583.2333,1566.5472,1564.2072,1661.433,1673.5314,1762.4026,1758.3457,1591.789,1845.106,1815.9152,1698.6782,1938.5951,1762.7882,1623.5037,1761.2302,1934.6979,1891.6,1850.728,2184.3162,2344.3687,2370.8286,2353.9463,2361.9988,2380.6772,2374.2778,2303.4114,2299.1235,2342.0974,2286.1077,2198.8547,2192.0835,2172.0547,2212.617,2286.0286,2286.993,2256.4192,2235.315,2179.7478,2119.1042,2024.9642,2012.2616,2157.2463,2192.5393,2196.1914,2183.5989,2166.0635,2148.9758,2129.6216,2096.064,2040.3118,1971.8604,2009.4897,2092.2373,2177.6182,2117.5251,2100.6,2038.271,1969.2249,2002.4004,2035.1205,1978.8682,1878.579,2024.1757,2031.1731,1991.3462,1890.7468,1771.8917,1747.6603,1887.253,1900.3145,1848.177,1960.8336,2107.4546,2124.6584,2114.2993,2113.2217,2106.0574,2026.8387,2013.9729,2076.8425,2143.7656,2113.3064,2078.6003,2056.446,2048.3477,2050.0598,2074.0999,2078.1575,2075.2754,2034.3345,1880.605,1267.3649,869.66846,865.14246,913.0077,855.41254,1151.652,1644.6627,1634.7378,1557.1218,1552.1356,1573.483,1601.2854,1613.5634,1606.328,1621.4377,1626.5507,1631.3776,1633.4556,1628.6222,1613.0898,1609.3704,1601.979,1590.7322,1590.3942,1583.5465,1582.2748,1579.2699,1573.681,1574.7762,1566.2559,1560.5142,1560.8193,1564.1143,1568.191,1572.7123,1573.6805,1547.8723,1543.1786,1550.082,1545.8278,1547.2767,1531.5729,1547.4186,1593.8524,1609.1683,1645.2896,1619.0504,1721.9512,1778.2443,1873.0363,1821.8093,1452.0894,1829.1294,1982.9451,1850.2922,2008.5232,1994.4404,2389.1196,2200.8674,1956.9774,2034.3263,2366.854,2384.086,2390.3298,2363.5222,2407.2153,2401.2683,2374.9873,2373.89,2340.1665,2349.4424,2371.1052,2330.6572,2271.0803,2126.239,2076.3774,2066.1152,2006.3275,1970.1041,2013.3187,2005.2926,2027.3414,2054.726,2037.2253,2025.4856,1994.4974,1981.3138,1942.6991,1839.6499,1682.592,1736.3268,1838.0219,2017.4598,1928.0583,1884.1389,1904.8739,1924.2008,1903.9879,1906.965,1887.2318,1879.6034,1861.9796,1762.8474,1806.0231,1809.3994,1786.2244,1763.0353,1835.5057,1854.0967,1939.9158,1950.0588,1937.925,1914.6049,1906.0195,1903.9548,1884.7129,1877.3269,1882.9263,1842.1876,1599.2488,1696.6611,1889.4211,1893.7335,1870.0371,1741.5283,1707.0005,1684.6304,1605.3911,1641.2831,1639.5969,1600.2126,1542.7094,1566.971,1575.3512,1650.3876,1531.9308,1476.1844,1486.3195,1506.7108,1531.921,1556.005,1550.6595,1549.2297,1542.836,1536.3463,1534.7156,1536.4292,1548.9089,1547.487,1547.2911,1553.2227,1546.2867,1531.0967,1529.7487,1520.791,1523.8888,1525.3796,1527.5453,1538.1731,1538.3976,1516.1243,1503.1578,1503.5758,1520.8119,1520.8733,1523.6652,1524.0055,1528.6992,1507.3846,1478.9551,1460.0275,1478.6112,1510.3527,1541.6714,1552.8031,1606.763,1636.5599,1662.1257,1670.0107,1570.7384,1749.3074,1756.6713,1756.6035,2061.5127,2025.7926,1997.2017,1876.4895,1735.7908,1862.6508,2240.0076,2303.8794,2258.5378,2240.0342,2257.1848,2260.3296,2255.1682,2182.4297,2039.1777,2039.0292,2105.268,1978.4526,1943.4867,1916.0028,1946.3202,1961.0414,1965.6692,1907.9344,1832.1228,1818.6686,1811.1205,1819.1025,1829.8053,1871.2878,1877.9163,1867.3938,1830.6545,1805.1354,1795.4489,1755.1793,1656.9509,1704.1904,1683.8274,1661.3046,1724.9851,1721.3015,1693.4541,1651.2461,1638.751,1634.3029,1666.7129,1646.7738,1656.2628,1743.2017,1707.783,1631.3837,1625.4802,1637.5405,1689.1532,1775.0038,1804.3748,1768.2915,1742.3179,1718.2156,1735.5027,1764.2048,1596.1642,1450.5378,1566.8761,1785.189,1806.9279,1780.5946,1773.859,1776.5254,1771.7272,1682.541,1576.7303,1464.4708,1424.2795,1430.9172,1422.8992,1443.0708,1467.3723,1466.8616,1486.2882,1465.9882,1478.2441,1468.2312,1471.3466,1471.5457,1473.3999,1474.662,1476.2913,1467.237,1467.717,1477.6405,1486.9215,1496.6584,1603.6637,1715.752,1596.0996,1647.4755,1536.9235,1502.6388,1505.4321,1516.8339,1529.3901,1523.6045,1517.8375,1505.3035,1477.2573,1478.1622,1492.2783,1498.7974,1504.0215,1507.3462,1520.073,1506.5923,1499.6049,1481.177,1497.712,1498.4895,1508.0505,1514.6453,1508.4131,1539.8496,1573.3856,1573.5052,1588.7837,1645.9321,1671.5393,1709.3867,1856.1677,1806.6991,1718.4498,1748.777,1880.5098,1968.0591,2102.8127,2153.4824,2201.3875,2231.4656,2212.9932,2186.7517,2154.911,2086.1187,2011.912,2039.4137,1945.6093,1756.5176,1988.0697,1951.2717,1917.7086,1767.4175,1740.7024,1788.2513,1766.6263,1745.5565,1725.2253,1719.9231,1761.6133,1715.4989,1689.4197,1650.4962,1635.2009,1723.6912,1788.3995,1763.3269,1699.94,1687.9219,1655.2428,1640.1511,1597.7516,1584.6155,1569.5725,1552.1965,1506.6606,1389.8158,1461.2438,1635.2943,1576.4814,1573.477,1576.8562,1576.7557,1610.0254,1670.6339,1717.3224,1744.7654,1778.9269,1785.4293,1763.1604,1722.1824,1687.078,1687.3816,1682.4569,1693.5524,1706.753,1745.2489,1721.9227,1657.1716,1600.0608,1590.6932,1627.5847,1647.4415,1664.1361,1539.1703,1456.8759,1443.474,1428.1554,1408.7523,1398.2749,1404.4314,1409.8999,1416.4757,1423.7463,1428.9619,1436.043,1455.2795,1448.1821,1461.072,1474.3346,1452.9243,1454.9946,1458.5894,1486.5819,1499.9548,1551.6196,1686.3641,1698.2583,1678.5569,1563.8373,1513.2958,1501.9901,1494.6802,1496.8857,1488.8463,1483.0802,1491.8062,1500.9896,1484.1724,1487.8435,1501.8247,1503.3387,1505.52,1508.2358,1517.3799,1529.505,1526.6321,1526.6542,1532.1428,1541.9225,1532.4526,1523.4266,1520.4685,1536.586,1531.9662,1530.3215,1554.9949,1553.1357,1588.405,1872.048,1847.4314,1810.4686,1834.647,1900.1276,2032.8977,2002.0579,2033.7537,1936.5232,1708.9076,1527.6421,2058.4817,2185.6792,2098.5088,1988.1324,1990.2109,2051.6924,1958.007,1928.3734,1856.8207,1656.3544,1913.2646,1880.7698,1764.6531,1730.0574,1721.8009,1784.2227,1225.6112,994.3377,1231.2291,1191.935,921.2657,313.61243,341.3916,1444.9408,1765.2671,1640.772,1566.9932,1582.4229,1581.9904,1569.2441,1537.975,1483.8784,1495.5985,1663.1268,1642.0281,1661.8037,1668.7983,1593.3057,1532.5087,1501.9578,1534.9292,1553.1483,1595.0886,1706.2928,1752.9136,1742.5834,1733.0107,1695.4835,1642.691,1525.9581,1549.414,1541.7838,1511.2255,1456.7769,1434.9369,1434.4971,1466.9813,1481.7881,1512.9409,1464.4431,1430.1304,1427.4117,1421.1979,1411.084,1410.8438,1409.8047,1394.4452,1401.3346,1438.974,1470.3436,1462.0774,1438.6981,1442.4478,1445.1315,1438.852,1438.738,1448.106,1451.8262,1459.3757,1451.7584,1432.6709,1424.0901,1445.1912,1494.3597,1593.7783,1692.2922,1764.1909,1641.9286,1517.8126,1540.5465,1518.4983,1496.311,1484.9951,1489.6685,1525.022,1558.5046,1552.7546,1526.005,1525.224,1522.1,1513.6833,1516.4707,1530.7893,1544.017,1555.6348,1578.9132,1578.059,1573.2781,1567.9846,1564.1151,1540.5848,1542.348,1519.0159,1517.5007,1516.7273,1505.5309,1485.8876,1941.4971,1941.0574,1897.8463,1855.5812,1861.051,2001.6135,1995.343,1897.0751,1722.0664,1608.697,1617.1257,1876.7683,1933.0092,1898.429,1878.1122,1924.2267,2093.097,1877.8,1539.5895,1343.2566,1276.26,1755.0094,1786.7322,1698.3269,1813.642,1720.2682,1076.633,889.73444,802.1232,731.5922,672.7481,558.6834,644.88837,758.0323,1111.2706,1483.2577,1605.2379,1658.9264,1678.7083,1506.3787,1528.6233,1512.5002,1503.1301,1568.8624,1579.9738,1542.4526,1523.005,1530.4686,1540.4601,1564.364,1578.2139,1478.6119,1550.491,1677.0018,1676.7437,1668.7932,1684.597,1723.1257,1784.1459,1795.7484,1737.3087,1869.6278,1881.2349,1889.0094,1716.5303,1618.2067,1704.3589,1621.1719,1309.9501,1180.8594,1139.611,1322.4517,1429.4269,1488.7853,1481.6222,1326.2599,1137.5127,1138.9637,1401.7719,1477.4238,1463.213,1461.0452,1460.0835,1459.8525,1464.3881,1463.6534,1432.2886,1422.9106,1432.1924,1448.7682,1457.8901,1469.4657,1483.2224,1573.2655,1721.5721,1867.9456,1998.2008,1953.8253,1473.2833,1429.4271,1428.2979,1433.0992,1448.9601,1458.1647,1458.9567,1486.947,1537.5757,1499.0143,1513.5117,1504.1299,1515.8691,1513.1978,1518.891,1532.8938,1533.2054,1533.9916,1541.5212,1543.5951,1544.9501,1556.7461,1565.6404,1569.127,1569.9819,1556.7933,1546.3511,1529.6229,1508.7274,1489.6295,1915.6544,1956.3743,2040.1747,1994.3612,1838.292,1792.0979,1904.2772,1891.4121,1757.1062,1703.3145,1711.0614,1633.4583,1666.025,1798.3557,1917.2543,1850.3456,1821.4846,1801.0599,1817.6625,1840.7839,1664.1978,1497.0597,1442.8313,1504.8428,1648.8813,1837.5427,1501.1747,937.4618,853.4936,880.85706,1237.6603,1889.102,1872.392,1745.0632,1833.7277,1838.861,1731.7964,1711.7441,1644.5431,1583.3953,1520.7285,1476.291,1481.1317,1488.6212,1478.9059,1492.2985,1492.388,1531.2614,1565.314,1595.2234,1503.0623,1586.1877,1592.486,1655.4042,1672.674,1673.5521,1725.4072,1767.4082,1831.4718,1945.2834,2075.9805,1801.9974,1560.813,1552.9596,1912.0916,2277.3142,2306.0623,1645.069,835.1269,722.38153,759.32117,1322.571,1584.0005,1524.4233,1534.878,1299.7753,1035.5868,967.0093,1337.0996,1547.7123,1504.9042,1484.6704,1497.9376,1510.5975,1501.9768,1484.1577,1485.0178,1468.7448,1477.6393,1449.3799,1445.4668,1519.0383,1543.0626,1564.3922,1696.4368,1784.1309,1862.4574,1920.8036,1655.7847,1473.3639,1540.3684,1536.827,1526.8917,1524.3799,1544.8632,1641.8501,1499.5392,1528.4484,1517.3563,1502.0554,1498.9712,1492.8202,1492.2526,1501.9159,1497.6388,1492.4702,1498.178,1486.175,1486.2324,1497.2611,1514.0413,1526.1981,1528.1628,1532.0162,1533.8136,1527.5027,1523.049,1513.2205,1015.66895,1071.4197,1329.9116,1772.0085,1787.2169,1409.493,1422.6058,1372.9956,1369.9697,1415.3905,1473.9619,1474.9259,1610.5334,1729.48,1729.716,1454.6892,1156.8541,1027.3105,1101.3167,1305.7188,1314.0245,1208.4868,1300.3494,1340.2722,1292.5023,1365.7666,1488.3392,1705.2018,1723.3378,1773.2202,1863.2024,1950.2715,1644.9086,1178.2214,885.43085,1394.2224,1910.8229,1816.2825,1726.7546,1659.3488,1634.3057,1613.6222,1492.9773,1440.5336,1442.6105,1487.5707,1483.0763,1463.5303,1478.7264,1512.6918,1520.6846,1541.7133,1570.1876,1597.2418,1636.9734,1676.9469,1730.022,1797.3168,1898.3943,2019.209,1961.736,1404.6862,1340.0116,1243.0039,1524.9701,2107.5845,2052.2976,2012.4869,2000.687,1949.6057,1724.2748,1461.9207,1496.6617,1511.2648,1518.0232,1523.5901,1527.8087,1540.506,1536.1102,1521.3353,1529.466,1544.057,1537.5076,1479.3043,1492.6588,1483.2207,1489.209,1489.0868,1523.9047,1355.925,1244.6063,1391.502,1632.3837,1640.7386,1681.2024,1728.7052,1761.1873,1589.3148,1671.7285,1849.9255,1864.1638,1835.9362,1782.2026,1664.8165,1432.224,1563.4368,1532.4362,1537.4502,1533.6538,1542.7969,1521.3147,1539.7552,1515.678,1540.2495,1510.4174,1485.9171,1489.9686,1505.7166,1520.1434,1509.0848,1551.0242,1525.9106,1504.492,1489.7251,1481.706,1470.3014,1467.7119,1471.2151,1072.89,733.11066,1433.3114,1615.6388,1459.3853,1288.0438,1199.8152,1312.9672,1329.181,1350.1942,1384.9648,1397.8214,1392.9266,1203.7864,1170.2576,1129.8566,980.0036,817.57227,867.47815,864.3327,771.0209,862.4093,1042.4604,1189.3511,881.278,863.26575,942.90845,1182.9133,1153.1388,1207.6843,1299.6708,1479.3618,1631.2683,1417.0509,1262.9811,1275.2649,1511.7024,2143.5007,2115.3872,1978.6566,1854.2087,1871.754,1814.3143,1732.6907,1671.3398,1594.7302,1506.6447,1468.4862,1447.3434,1483.7012,1499.8896,1492.8257,1516.8064,1552.343,1585.6838,1647.2635,1744.3654,1779.6403,1835.034,1919.2343,1987.5327,2024.1904,1980.2753,1966.6509,2006.9135,2013.2842,2000.0762,1869.3568,1994.0449,2054.8513,1897.9443,1574.2777,1520.2478,1485.1505,1469.0632,1463.3915,1469.451,1489.0809,1509.3435,1582.5508,1548.1508,1430.3197,1413.3279,1352.5789,1580.9933,1633.9728,1619.7512,1266.1871,1689.9736,1465.6112,1278.7753,1512.9003,1698.0227,1663.4315,1696.2292,1693.6885,1725.8439,1671.8286,1715.9983,1728.522,1743.6663,1705.6746,1629.8538,1620.5648,1638.5042,1729.1685,1590.7428,1430.9906,1486.2902,1740.3585,1684.6133,1615.7045,1573.5367,1565.5056,1515.3586,1500.2277,1503.2695,1512.101,1539.3608,1528.4967,1525.3009,1505.7072,1485.1372,1469.8458,1462.11,1456.5568,1464.6597,1453.4045,1418.9025,1406.5773,1271.446,1211.8855,1145.1553,1105.1276,1079.8528,1097.507,1112.2692,1121.5787,1147.148,1084.7653,948.4894,849.2727,769.21155,793.7193,780.8235,729.5557,640.0641,641.01056,663.84216,758.4486,915.999,861.04144,766.95355,793.2769,853.22107,829.48047,837.9917,842.34766,973.75616,1304.7739,1724.6051,1598.837,1406.6552,1415.7832,1491.4651,1958.866,2545.6387,2491.6965,2301.361,2320.5088,2264.1213,2168.5596,1962.0734,1855.1967,1801.3495,1750.9829,1695.2301,1585.6965,1441.1066,1398.4536,1503.6053,1577.9148,1615.9186,1696.7856,1786.83,1847.6584,1902.9476,1934.1417,1934.4028,1961.7689,2010.6855,1940.2725,1901.6317,1953.9702,1826.4551,1546.6909,1293.2306,1038.4932,1249.6779,1601.8022,1602.8021,1524.6816,1477.4294,1489.4825,1490.4275,1471.8362,1498.6777,1573.3076,1477.7194,1402.9519,1419.4713,1475.4153,1663.0509,1696.9578,1673.2495,1640.0609,1619.3861,1612.7762,1602.8706,1608.8641,1627.7858,1653.625,1717.8397,1777.5571,1765.4917,1752.2184,1753.4586,1705.5543,1671.2161,1663.4813,1703.8175,1558.0005,1407.3342,1636.6793,1615.0688,1604.9211,1649.9167,1653.6991,1646.5802,1643.7626,1409.0913,1488.3484,1499.0883,1477.8116,1491.3412,1555.9553,1518.862,1491.8773,1493.3549,1525.1854,1481.1884,1547.7322,1553.8928,1527.0413,1509.621,1493.074,1264.853,1269.8611,1188.5238,1126.08,1096.3085,1072.4028,1042.5183,1002.7697,976.94666,973.43317,944.49524,894.2356,856.87415,790.4524,724.08905,675.9024,655.20386,644.21515,629.1279,632.23364,637.5775,657.59033,697.1514,663.27795,673.7023,670.42676,688.6666,674.2517,683.5576,732.0853,931.9614,1209.1053,1535.2294,1788.2566,1908.9744,2008.4897,2045.9717,2240.98,2395.152,2462.0452,2538.1304,2658.0293,2624.8806,2558.8306,2414.6768,2206.6624,2077.797,2047.1729,2015.9741,1594.2261,1048.4832,988.40234,1500.5867,1785.981,1773.8549,1614.1589,1587.1742,1586.7,1665.6885,1716.2217,1735.0116,1861.352,1997.7319,2001.661,1980.4017,1958.6819,1787.652,649.4168,443.09772,260.0276,387.9263,1455.8679,1610.904,1510.1791,1472.7278,1476.6807,1472.2615,1486.7819,1515.3572,1554.6139,1584.2316,1614.8589,1669.8955,1698.2378,1716.894,1671.9071,1666.5634,1706.7999,1789.0726,1813.5182,1800.3188,1788.8419,1738.6376,1592.3417,1536.2203,1651.5837,1636.4938,1641.3081,1679.2028,1668.6267,1669.589,1694.9204,1745.4578,1546.8179,1435.8063,1511.631,1521.0604,1556.7772,1586.908,1603.436,1573.1334,1503.2804,1298.4991,1419.3146,1465.3732,1571.8822,1687.8365,1452.5432,1368.1503,1351.6691,1338.2532,1392.7942,1588.1525,1534.1084,1510.5172,1492.1482,1397.2815,1205.667,1427.3414,1321.1664,1418.555,1311.0532,1184.3754,1129.6069,1050.9629,1010.0487,954.7153,913.3926,868.0115,817.2588,763.96844,793.80206,737.1352,700.95233,706.80145,652.46484,609.6033,579.4258,590.99005,659.7388,742.65857,578.32635,584.5524,630.05194,653.6957,649.15424,660.71826,770.43585,928.141,1146.7709,1320.4482,1460.6298,1635.7432,1796.048,1909.6128,2019.8823,2050.398,2148.7966,2255.7112,2404.912,2428.0396,2472.016,2581.7053,2549.7876,2377.0334,2196.1604,2093.0918,1964.3759,1719.2505,2132.4038,2033.4127,1690.8951,1454.6809,1375.8861,1339.1091,1351.0894,1378.5427,1397.132,1402.9503,1426.6427,1610.4526,2060.1216,2016.1979,1914.7377,1939.5968,1919.2804,1653.0841,1638.7007,1768.4574,1712.6783,1551.5629,1468.5159,1460.2655,1496.6777,1550.0967,1543.4072,1639.653,1621.139,1625.9923,1610.181,1659.1261,1699.8341,1718.8138,1741.2776,1742.5448,1674.6215,1632.5566,1651.3997,1747.3875,1923.1506,1927.0469,1888.0099,1739.279,1709.2268,1689.3275,1688.2291,1752.814,1733.2859,1725.9424,1724.0563,1765.0883,1531.0531,1377.7042,1606.4686,1554.8225,1576.7362,1601.0825,1641.4082,1602.8047,1455.7838,1408.3687,1387.8429,1404.955,1523.1722,1701.513,1513.0541,1358.0586,1318.6299,1346.9629,1493.1079,1614.931,1509.451,1546.1998,944.7831,107.89251,12.304226,1492.8099,1637.7606,1682.0746,1604.6543,1501.3589,1316.2899,1181.1415,1036.5109,925.80914,976.5069,1038.7327,1149.4154,1282.4502,1170.2279,756.43335,556.66766,471.70325,630.31104,716.32935,667.3554,664.50305,559.6065,594.7275,576.59064,608.6485,601.14435,587.3824,598.92,650.59845,736.03687,838.1891,966.7042,1224.9843,1396.7546,1598.8588,1595.2906,1384.2673,1655.3772,1904.5676,1999.2913,1852.7476,1722.4354,1923.7987,2462.9321,2610.855,2437.4841,2398.3804,2302.9004,2215.156,2145.75,2038.2803,2072.2317,1717.0829,1488.8235,1583.8176,1436.9795,1335.3575,1332.4368,1332.5203,1405.9364,1455.3082,1570.2284,1740.5569,2127.9307,2073.6133,1982.0472,2176.3542,2024.6276,1882.6222,1859.0494,1494.2771,1145.3878,1359.0371,1524.5048,1522.0161,1555.9557,1586.5924,1560.491,1706.1238,1758.9497,1809.2175,1079.7668,993.31824,1790.5917,1935.3462,1882.4326,1951.4315,1894.377,1827.3447,1843.2795,1888.6006,1894.8768,1956.3103,1947.5105,1809.1652,1761.2668,1737.8784,1721.4548,1747.1075,1729.0352,1677.5354,1641.9485,1589.3962,1544.0116,1515.2838,1508.0884,1549.7014,1581.1604,1486.187,1443.9043,1451.3271,1459.8707,1435.5026,1410.2637,1422.9756,1425.8646,1411.7041,1407.9192,1419.987,1443.702,1451.9441,1429.5555,1381.367,1368.9656,1353.8888,983.5488,497.58276,321.81384,1724.196,1641.1226,1496.1403,1546.9141,1607.0776,1464.5767,1257.5947,1153.0051,1097.3105,1199.7954,1243.9801,1437.3091,1163.5298,166.38585,-44.37043,-74.431915,-117.71992,-30.25922,685.5427,835.91907,722.6192,633.0246,569.6167,567.3595,619.17456,562.9722,597.8638,607.5715,629.71643,679.79517,738.62366,829.7846,984.46716,1119.2848,1192.1147,1385.728,1470.7639,1608.0394,1433.3704,1399.5635,1247.4523,741.1516,857.9954,1695.9952,2323.7717,2414.9011,2443.0078,2219.9404,2318.3484,2250.699,2246.0425,1998.3696,1252.3634,1414.6584,2020.6564,1671.4183,1451.4628,1407.3363,1466.68,1480.3259,1774.9056,2192.8035,1847.9335,1058.1204,989.52014,1008.75104,1652.1448,2297.3582,2050.6216,1934.4071,1855.244,1822.6959,1822.3113,1699.5411,1652.8306,1665.6903,1702.8344,1722.1628,1753.4453,1777.7051,1826.1531,1801.2166,1825.1833,1901.3208,1969.0963,2029.146,2050.746,2035.0947,2032.4725,2104.886,2101.9512,2103.7788,2053.686,1931.2717,1835.6805,1808.4889,1856.846,1864.3577,1779.1265,1430.3143,1630.4235,1682.8914,1616.1138,1568.1245,1508.0522,1483.8634,1467.343,1485.5854,1381.4792,1337.9463,1332.006,1355.7786,1366.2397,1389.5769,1395.6986,1388.8917,1381.0054,1386.1423,1388.1359,1393.0906,1393.3716,1388.9795,1353.6782,1346.4493,1329.5944,1330.3765,1330.5101,1383.9257,1486.1782,1538.2842,1490.775,1438.0385,1403.3347,1358.257,1311.5002,1342.4106,1387.7157,1354.0271,1271.1375,1313.118,1261.1119,404.15305,342.89856,357.6814,413.96143,714.41736,1130.8264,907.9843,736.81354,643.1092,604.8083,559.26526,533.9547,594.2359,601.51044,593.09235,583.69507,592.2647,608.3882,640.97125,685.7588,747.0598,805.9185,1042.7296,1259.8375,1368.1681,1154.4381,1033.8619,981.30054,1329.1558,1836.2397,1855.7648,1938.4319,2074.111,2169.057,2189.1628,2263.4631,2297.6487,2280.713,2292.1917,2375.815,2514.266,2690.228,2745.6052,2754.159,2637.5298,2694.0928,2724.4905,2835.8809,2772.07,2638.1338,2233.4922,2006.0636,2007.6428,2273.916,2235.5247,2052.2842,1903.1001,1945.0206,1944.7523,1832.3342,1702.6743,1752.3679,1812.7802,1838.4489,1921.8555,1963.2373,2005.6763,2044.3601,2000.8776,2009.7094,2028.3098,2051.4675,2105.3599,2222.6777,2196.5312,1815.0262,1017.3908,873.603,881.0668,977.4891,1656.062,2126.835,2045.5237,1994.6915,1955.7623,1879.6931,1639.3689,1693.0052,1663.743,1632.1267,1650.99,1610.8644,1555.0259,1537.5375,1441.0592,1386.0879,1344.878,1320.3323,1305.4426,1318.0519,1332.3855,1340.1578,1366.5398,1364.4929,1377.627,1373.8235,1375.161,1374.4485,1387.6058,1382.6962,1372.4752,1361.9788,1361.6135,1351.6038,1333.8773,947.6308,873.45166,1381.6625,1762.5875,1719.0021,1683.8618,1665.3707,1759.516,1601.3212,1420.4456,1301.4204,1301.8301,1379.0615,1341.5771,1215.6766,1177.4628,1220.8909,1375.7091,1274.8367,959.5677,813.79816,679.2359,669.62146,624.8626,615.20355,581.61536,565.50995,562.1135,544.2904,527.1591,553.1251,538.94354,552.4107,591.6623,715.2648,877.1423,1043.4674,1042.7422,1128.6536,1144.5604,1225.9204,1361.4158,1458.0021,1527.4615,1600.5203,1731.8667,1862.5745,1948.572,2169.5537,2284.6428,2221.9993,2126.2024,2276.1277,2316.8528,2489.9492,2556.4707,2393.523,2509.129,2612.5808,2777.9226,2711.5337,2480.4011,2446.6223,2467.413,2431.6064,2290.6768,2195.214,2206.5918,2082.7988,2008.6001,1997.3074,1997.9438,1844.7026,1817.05,2029.7073,2173.166,2155.2886,2200.027,2272.6357,2395.9324,2358.2947,2290.53,2255.0996,2208.6565,2217.7986,2292.4236,2354.2217,2423.8203,1869.4441,1193.8019,1060.1708,1195.6802,1134.5681,866.92755,1394.6271,2128.5503,2054.7407,1931.3962,1869.7587,1854.482,1771.4551,1689.5592,1706.0684,1720.6964,1597.0112,1592.3442,1665.3984,1535.2693,1425.4946,1369.1663,1341.2354,1288.4025,1293.1235,1341.5223,1349.552,1361.0603,1351.6005,1360.9048,1362.0164,1389.7069,1378.487,1375.8911,1372.1628,1366.9889,1343.9805,1349.5159,1341.3125,1327.3046,545.32764,537.99286,1215.0459,1938.8121,2039.7081,2227.6824,2158.39,1677.3479,1343.6327,1471.6562,1448.9614,1377.7942,1346.7703,1318.3954,1301.9642,1245.8058,1183.3923,1192.6466,1267.4933,1110.7507,384.33798,-394.93137,140.08946,691.17633,598.8579,582.1333,563.4285,562.65515,547.0955,536.00946,550.3189,514.25256,495.32803,545.957,682.7535,709.1032,563.49976,728.78235,892.7647,1063.0176,1180.9226,1341.2151,1423.4662,1502.3711,1581.5842,1697.0234,1821.888,1931.627,1830.3636,1912.7955,2102.5806,2148.4585,2180.063,2156.168,2200.9646,2155.9478,2142.7383,2229.2017,2246.2024,2223.6133,2193.834,2216.785,2247.2048,2314.7476,2315.9863,2270.3787,2215.2373,2083.5483,1986.7278,1972.2522,1992.3475,2013.2938,2027.9404,2108.0825,2319.216,2199.4104,1679.5719,1345.919,1169.5186,1221.3694,1281.2958,2287.0984,2459.036,2476.5784,2432.2754,2447.0776,2413.8135,2276.5603,2519.91,2572.766,2460.0042,2526.8792,1902.52,968.9038,1087.3503,2114.383,2006.589,1862.6084,1830.3314,1768.8273,1658.4097,1661.0339,1705.6488,1373.7599,267.5275,357.818,1599.5182,1649.0327,1536.0143,1469.2792,1503.7533,1455.7197,1402.5171,1383.2351,1361.2645,1387.3292,1367.846,1384.9287,1391.5922,1365.1936,1357.1465,1355.0664,1341.245,1338.635,1335.3617,1330.7594,1315.5923,1286.8591,1686.5042,2138.2349,2417.5327,2385.6597,2305.8806,2184.1953,2112.183,2078.9617,1891.9471,1697.3628,1538.1975,1480.9679,1507.936,1418.86,1335.0969,1291.9845,1236.6292,1079.3292,688.89056,526.26935,657.78955,715.9861,722.8866,688.41675,496.87933,600.9451,595.9548,621.37085,579.92523,556.3639,525.76135,507.8205,530.0854,612.3915,678.6675,721.79016,784.932,614.1306,652.1496,828.88983,1182.5233,1507.4677,1287.7572,1311.6224,1281.8317,1291.7982,1403.8276,1502.3408,1542.7462,1589.5016,1675.1025,1777.834,1796.0972,1828.7594,1860.168,1908.2133,1983.4956,2017.3772,2036.9811,2050.8792,2069.3086,2082.7969,2094.015,2133.4634,2129.291,2140.0059,2056.941,2005.8236,1971.6632,1949.825,1974.7528,2013.1345,2081.787,2206.0032,2334.1262,1110.5863,486.42935,537.51996,498.20087,640.9796,785.4018,1731.7041,2228.2424,1983.718,2200.0488,2368.4587,2336.0237,2021.2955,2129.9988,2392.2483,2298.4043,2269.5703,2222.682,2160.1182,2053.012,1958.7227,1863.1122,1818.2078,1795.7852,1508.4144,1467.7734,1760.8857,1724.281,1735.456,1678.8652,1743.2429,1792.5254,1263.5424,921.7717,905.9632,1181.0712,1475.6958,1383.7777,1339.9216,1336.654,1337.0061,1326.471,1336.9612,1334.4553,1331.2814,1317.9097,1315.3584,1325.7032,1322.1074,1299.0941,1299.3268,1284.6177,1321.7238,1671.6033,1893.4811,2078.7078,2038.9658,2223.3215,2313.6758,2263.2292,2143.1943,1861.081,1891.1975,1831.2428,1831.5963,1854.2606,1486.6287,1341.7125,1277.9185,1275.6388,761.0486,64.18277,-55.064087,276.1572,709.7776,762.18896,722.3055,637.3065,634.6639,653.892,676.8579,611.91754,621.16437,575.406,565.852,564.17114,551.9628,555.9831,577.83136,575.6277,579.43036,638.1259,678.2793,807.07684,912.8114,964.4958,983.11206,1022.04376,1060.5784,1099.8041,1174.3215,1202.925,1198.6831,1218.1615,1278.2003,1334.7323,1410.5323,1558.2997,1724.1316,1829.4797,1908.9424,1974.3047,1991.437,1972.703,1983.5325,2036.2926,1842.2814,1854.4142,2126.099,2093.7,2042.4656,1822.469,1934.0914,1909.5841,1913.2168,1971.869,2073.253,2207.4536,2239.3708,1381.2971,960.48175,866.33466,1095.9059,1879.7389,2227.571,2151.8872,2112.9126,2231.9666,2304.562,2230.696,2169.3877,1980.7549,1873.2292,1944.737,2209.3335,2093.4524,1984.179,1996.1664,1913.3367,1845.0192,1812.2151,1796.8601,1596.3826,1593.982,1748.707,1742.8711,1671.275,1664.2755,1706.2527,1690.8872,1624.4459,1354.3163,1315.7402,1498.761,1508.9185,1418.8973,1391.6213,1363.3206,1367.8376,1336.6102,1317.493,1312.3126,1309.2295,1300.4833,1308.811,1300.981,1337.2521,1289.0015,1278.8356,1349.2474,1349.5518,1716.3269,1825.547,1836.6636,1921.0757,1937.7678,2021.5562,2043.3812,2004.6633,1997.0492,1968.2019,1967.2625,1969.6047,1990.0765,1739.6057,1319.2411,1690.408,1605.0366,1421.2222,1250.4855,1004.80664,1013.322,942.35144,934.69525,831.1318,772.13885,740.3626,751.15936,802.0993,749.9429,655.93976,606.75354,593.5884,608.7886,630.7706,607.00507,602.07837,592.18115,597.29834,603.5101,610.92163,640.77344,662.5001,759.1814,896.3818,960.9395,973.02515,1014.95996,963.5469,913.4146,936.76465,1000.7887,1041.9833,1133.2585,1265.4144,1455.1664,1596.6012,1758.408,1907.9797,2024.8403,2063.1348,2101.4604,1991.8113,2075.7207,2095.7607,2106.1348,2110.911,2105.4316,2060.4333,1969.673,1898.845,1856.7377,1859.3087,1908.3977,1945.4102,1983.96,2049.2832,2137.0056,2195.9788,2288.3015,2211.0225,2078.0295,2059.3818,2110.1855,2158.619,2222.9592,2307.3596,2144.4336,2152.1587,2185.2021,2109.5261,2087.328,2194.3308,2112.0652,2041.2863,1968.2274,1867.2,1781.6407,1745.7996,1821.0668,1739.8983,1630.2468,1702.0726,1796.032,1755.9144,1759.392,1697.5499,1664.2368,1676.6917,1612.8457,1644.0846,1425.2738,1234.317,1173.6052,1427.6464,1484.8424,1442.8092,1408.5122,1414.0387,1353.8108,1337.4635,1338.6992,1343.6475,1308.8025,1308.2307,1203.7811,1194.3301,1300.5566,1291.4153,1798.055,1829.0535,1692.2277,1731.1259,1829.4789,1844.3842,1861.2992,1909.0063,1764.8164,1428.7944,1842.8322,2080.9336,2079.7766,2049.2725,1995.8809,1893.3652,1498.3625,1407.8937,1321.4375,1147.4716,1081.6959,1109.044,1016.53937,913.74854,875.055,862.06006,989.8675,1043.393,842.60254,719.3144,691.76886,712.61975,764.08246,731.3012,733.32324,651.28815,647.5339,655.8836,655.146,666.0231,630.13873,627.77527,726.97906,900.15924,751.9178,755.5665,848.8986,798.776,779.71454,834.5839,918.07477,746.2178,733.5943,1253.0077,1374.3031,1515.5642,1784.7015,1923.9055,1957.6847,2000.7318,2191.4849,2322.638,2315.6711,2134.2605,2043.0583,2068.0752,2042.2917,2013.2661,1995.763,1902.5406,1847.0961,1818.7498,1846.6576,1841.4456,1891.6721,1953.0333,1990.0372,2022.0685,2053.7148,2087.771,2101.0603,2097.6604,2076.087,2034.8036,2224.255,2216.0837,2195.4084,2194.1736,2210.5044,2107.9758,2009.3044,2097.8965,2013.756,1934.9409,1909.9718,1861.4802,1803.224,1792.232,1830.4868,1751.1987,1498.0406,1339.7328,1973.2722,1562.7925,1154.9497,1712.4496,1740.689,1625.7588,1591.5387,1604.8767,1047.5095,751.9517,775.9404,1390.9733,1579.768,1523.7943,1511.604,1579.38,1200.696,1203.1571,1243.0135,1379.975,1446.3055,1414.9512,1402.3107,1409.5385,1472.3441,1548.7192,1681.8047,1573.4349,1817.4249,1799.0367,1888.6721,1597.7362,1627.9117,1950.0201,1898.5792,1797.6698,2133.2964,2192.9692,2252.7654,2216.615,1997.2158,1541.207,1453.6649,1364.0164,1344.4016,1340.3245,1256.4268,909.5292,918.4842,1009.3809,964.8551,1000.6362,1134.9391,1025.5469,815.842,805.6358,871.4146,952.927,39.448437,-686.8071,431.23364,810.01263,735.25824,755.81323,767.88043,791.7152,742.61096,781.148,766.38196,792.9218,767.9416,767.4074,808.3047,807.33203,795.2445,808.62897,842.80225,919.21906,1018.48254,1117.0859,1281.7587,1511.5111,1735.7892,1881.6973,2096.4937,2012.5293,2089.6526,2244.3457,2209.3313,1997.1041,1972.0585,1973.5182,2019.8284,1857.2244,2045.1248,2030.5979,1872.1428,1629.188,1877.4236,1895.8777,1946.5035,1991.3081,2022.6556,2071.685,2104.1648,2098.3293,2103.6372,2075.5193,2098.6682,2074.377,2089.3018,2125.294,2100.597,2079.108,2018.5049,1981.5994,1920.4957,1814.3871,1757.9921,1791.0679,1796.9313,1791.4692,1811.4955,1821.2098,1892.9619,1946.635,2017.9939,2060.2412,2111.749,1982.8824,1549.1583,1925.119,1823.4722,1676.5835,1594.9879,1667.217,1502.9121,1676.92,1737.559,1535.2268,1489.1562,1646.7634,1580.8217,1623.349,1631.3081,1602.8959,1577.0995,1485.4464,1434.8434,1396.5128,1378.1309,1394.2216,1439.3872,1541.2609,1573.832,1536.48,1638.0786,1822.934,1820.7296,1601.4237,1617.0963,1857.3704,1797.1824,1838.6747,1895.7981,1832.8455,1774.2803,1658.4576,1491.5974,1347.8304,1335.3314,1215.0283,1247.5028,1393.538,1379.3777,1105.8447,1187.647,1379.7555,1270.5016,1204.8492,1146.7029,996.8761,959.678,1072.586,1022.1275,1033.2246,963.39185,787.64575,949.12616,930.8879,946.2814,1007.31055,1079.814,1212.1649,1222.3093,1344.6312,1233.7672,1074.402,1033.6993,970.1291,937.8889,955.4347,900.3625,850.338,838.44495,851.6406,899.4048,966.5378,1161.3873,1405.0303,1705.2739,1759.3236,1954.6007,1843.5977,1922.1095,2138.4346,2034.944,1983.517,1968.174,1963.6987,2054.006,2196.9043,2195.4966,2207.1226,1724.0931,1496.9481,1917.9285,1943.0983,2008.5505,2089.4338,2085.7368,2096.2102,2120.4019,2132.289,2173.8882,2155.4153,2111.3103,2072.1948,2000.2089,1977.8141,1894.3352,1806.1135,1700.7887,1653.4125,1610.321,1575.6443,1600.1248,1663.8636,1719.3079,1773.5514,1654.945,1792.7334,1868.354,1915.6051,2125.9773,2048.0671,2007.8138,1981.5029,1780.4484,1873.9733,1863.0072,1769.468,1676.0616,1754.6177,1658.144,1683.7126,1650.7428,1478.4119,1482.5873,1612.0427,1583.4355,1682.2197,1663.4718,1683.0208,1607.265,1500.0953,1432.3716,1437.9404,1417.0905,1438.5099,1324.9456,1599.3926,1285.1188,1368.6898,1676.7186,2001.5216,1038.3401,1336.4303,2104.022,1201.3809,1594.3123,1698.2853,1641.1237,1529.4213,1490.8658,1450.5856,1352.454,1296.2175,1307.1823,1315.4252,1267.0332,1477.2915,1675.3225,1748.9913,1149.0901,1413.906,1670.3939,1602.6465,1372.5608,1224.8307,1493.5367,1585.0988,1475.7744,722.62854,487.89133,1157.8528,1168.8087,1225.1624,1474.8405,1662.1726,1878.2777,670.7368,-71.00645,379.30206,1824.9639,1497.1929,1378.3527,1282.0182,1202.3638,1044.1727,1100.3235,1100.2443,1043.0383,995.4106,975.4641,987.4826,1107.4928,1281.6914,1501.1246,1561.2004,1561.9374,1568.9211,1640.113,1780.8146,1840.4033,1750.9994,2067.7754,2109.814,2273.995,2307.236,2346.2231,2313.427,2192.8254,2090.4358,2036.4114,2070.8384,2304.3833,2385.1733,2285.9883,2375.1025,2476.5056,2354.8965,2270.4658,2209.244,2147.9463,2059.1162,1953.543,1877.2339,1437.8883,1307.8762,1465.4108,1419.717,1404.0487,1424.2515,1462.9247,1500.167,1598.7269,1681.2382,1553.7745,1865.481,1842.1774,1999.134,2054.5906,2093.5732,2018.4612,1924.2217,1873.2717,1863.3557,1866.711,1559.1864,1472.091,1767.4353,1673.4253,1647.0013,1662.884,1648.8743,1529.733,1588.9807,1780.4147,1821.7972,1972.8467,1827.0594,1680.1403,1611.3527,1592.4795,1370.0198,1534.1387,1535.7014,1579.6738,1948.454,1047.9318,1166.7244,1493.4985,2005.033,2167.0657,2313.2876,2233.5396,2083.9692,1852.9224,1698.3502,1595.7068,1512.8354,1438.6322,1370.1278,1310.2163,1295.2303,1286.5242,1311.4481,1398.7401,1741.5367,1964.1841,1924.8756,1775.024,1828.0421,2003.876,1744.9103,1792.5743,1734.4016,1910.7562,1835.352,1875.3218,1772.7578,1675.4862,1773.2963,1470.9005,1522.8702,1922.8752,1946.945,1340.7175,93.93564,-230.5203,293.0092,1845.0507,1715.4415,1477.238,1425.8317,1436.0746,1432.336,1456.5847,1465.0249,754.4451,806.9499,1403.9229,1326.7867,1263.6392,1253.3691,1314.581,1341.0762,1350.5068,1365.3812,1449.0558,1509.5479,1514.524,1410.6022,1918.1332,1975.82,2129.8682,2305.9253,2334.0369,2070.3186,2041.0248,2232.043,1976.2186,1242.5306,1099.1648,1363.4747,1671.2107,1853.4182,2361.5757,1918.485,2186.8242,2097.6921,2036.9965,1930.7164,1788.3931,1660.9218,1378.1263,1411.0159,1293.1245,1292.4021,1267.8042,1272.5862,1296.0457,1172.2693,1349.3706,1445.2505,1367.2858,1633.5404,1870.7185,1840.3798,1463.1798,1715.8052,1912.8264,1910.2407,1798.362,1831.81,1842.8833,1859.0894,1897.5746,1879.0021,1849.5087,1876.6466,1889.9937,1732.0507,1587.4517,1903.2039,2071.0327,2115.5217,1871.4065,1739.6381,1722.6825,1682.8011,1503.6924,1450.7079,1650.1553,1692.6969,1825.6815,2056.4094,918.02673,999.65955,1310.5736,1557.2502,1503.7996,1904.0923,2360.12,2364.9558,1922.2861,1688.5604,1576.5698,1467.1857,1425.1113,1390.4308,1311.3618,1295.1715,1345.239,1682.2946,1745.1262,1935.3387,2008.1022,2000.4108,2072.5508,2019.9581,1997.481,1992.9125,1926.114,1936.5311,1915.7501,1585.2919,1993.4619,2093.78,2259.899,2018.1912,773.27966,970.6643,2156.0632,2193.7449,1715.5557,1020.9262,904.82074,1607.3925,2063.8206,1783.3445,1618.9617,1438.6721,1454.2284,1433.9606,1489.9133,1606.1102,1613.068,1750.0807,1871.1423,1913.5323,1605.0631,1351.4673,1194.5828,1192.0869,1212.3893,1269.4486,1390.171,1393.8365,1368.6245,1466.4203,1419.6418,1718.9,1864.1632,2197.896,2239.4082,2036.3165,2151.4956,2199.861,2056.5396,1005.2418,839.7971,1384.4613,1864.9144,1949.1224,2033.0448,2006.7017,1993.0208,1948.5992,1913.7396,1849.0798,1700.7124,1514.5769,1348.9169,1304.7959,1236.8773,1246.8456,1194.8522,1175.8485,1171.381,1176.5319,1204.3259,1211.5293,1340.5673,1425.3942,1621.164,1730.8444,1644.6113,1778.1993,1950.3363,1922.6306,1897.1033,1940.8054,2058.291,2109.8818,2115.9038,2109.1838,1938.6339,1950.9956,2107.5854,1602.4177,1340.9222,2046.3494,1943.8595,1904.023,1739.8424,1569.0077,1485.9452,1572.9948,1409.9735,1387.2874,1748.9419,1905.4926,2091.2546,2155.473,918.23773,988.93176,1134.9835,1559.2986,1591.9318,1712.1415,1991.6718,1687.7072,1359.6865,1645.7678,1511.66,1407.6901,1380.3439,1209.1335,1357.7363,1564.8129,1972.6299,2189.5251,2128.1865,1950.6322,1959.3901,2027.6959,2139.2578,2043.0618,1459.712,1562.4039,1986.1389,1999.4255,2003.6222,1806.0502,1928.8206,1927.462,1832.854,1812.3911,1890.3854,2204.4382,2368.9016,2392.402,2470.5227,2459.09,2138.3643,722.6019,470.78748,1525.1046,1519.0682,875.0763,1342.1481,1468.5842,1494.5641,1636.0844,1958.0862,1554.8141,1261.5283,1293.1447,1608.0107,1482.8871,1288.181,1196.913,1175.5691,1185.9597,1236.3522,1412.6016,1446.8531,1476.6272,1535.5432,1613.1937,1773.244,2044.9121,2202.0059,2196.5757,2171.2393,2162.2043,2127.1248,2092.5178,1986.2151,1960.1486,1954.0398,1875.327,1827.2253,1514.623,1823.9442,1860.938,1898.0198,1780.0612,1524.771,1431.3412,1444.185,1332.4209,1216.5845,1177.5085,1161.7391,1162.9064,1182.4414,1184.2379,1090.5471,1208.442,1234.5303,1394.9142,1456.1879,1586.6926,1764.5819,1821.6726,1997.4916,1787.4731,1826.8805,2164.9727,2275.5896,2324.012,2277.3274,2217.68,2192.2583,2182.051,2161.731,2119.0193,2010.8376,1863.66,1696.4128,1541.7344,1357.449,1274.0875,1231.1935,1251.2826,1262.9995,1260.7089,1379.8461,1489.8535,1397.1458,1899.7281,970.87775,1048.3864,1162.0408,1462.1234,1023.9807,1046.8882,1715.9026,1660.8824,1410.906,1508.776,1434.4607,1337.3419,1322.9182,1237.0729,1414.6318,1935.0851,2377.4336,2584.1157,2362.0662,2110.7864,2067.391,2157.4412,1998.656,2007.7422,1861.0149,1993.738,2144.964,2015.0786,1824.7312,1819.0887,2086.3723,2078.7292,1993.0436,1922.8066,1946.0691,2092.033,2280.2927,2502.1113,2134.005,1720.7385,1594.655,880.7019,922.96387,1706.9795,1667.3739,1595.7195,1391.5002,1348.9954,1363.2341,1495.1682,1874.2141,1823.9814,1445.7203,1582.1888,1523.3546,1577.9044,1352.4294,1271.0046,1222.6493,1213.042,1290.9243,1476.2534,1531.7944,1554.7059,1657.2845,1693.8596,1546.0999,1980.7172,2352.3032,2031.2668,2203.502,2068.556,1988.7438,1916.4054,1830.0381,1746.4968,1763.5592,1722.7227,1672.1549,1410.8081,1630.6907,1776.2698,1950.4204,2122.7458,2052.7183,1948.9529,1848.3835,1478.2443,1178.1215,1095.0653,1081.222,1140.8586,1202.631,1078.2223,1361.951,1260.7618,838.01764,1380.3103,1369.0925,1365.431,1421.8784,1467.3486,1750.9955,1926.0013,2019.7322,2247.0303,2347.9268,2382.2295,2384.4531,2378.4602,2258.787,2302.2727,2302.8826,2165.3115,1951.6932,1756.9218,1564.6963,1391.263,1242.3237,1171.9286,1127.4065,1122.585,1144.4675,1086.0951,1178.5537,1222.8628,1243.6805,1401.2191,1081.6068,1083.2334,1196.4946,1383.6533,1572.0309,1641.1732,1714.0934,1583.3168,1497.3507,1395.6332,1276.7819,1237.4695,1158.895,813.129,949.83844,1929.6113,2563.6787,2539.07,2479.7742,2388.6335,2263.4666,2297.1833,2412.9138,2102.0388,2505.3794,2468.5344,2163.45,2063.8152,2107.204,2186.934,2251.0935,2325.4517,2257.775,2243.7659,2324.1614,2350.5798,2453.6353,2682.433,2182.1926,1549.4863,1554.2119,1552.3445,2079.5073,2116.9294,1744.4324,1485.5443,1361.0076,1329.2908,1348.7119,1370.706,1473.6631,1866.0338,1932.8379,1921.7024,1755.043,1680.8612,1550.9403,1382.9309,1271.6082,1270.0109,1319.6813,1404.6223,1493.9722,1568.7207,1702.579,1847.1324,1795.7113,2000.1603,2203.6802,2438.0361,2379.5315,2165.6836,1924.349,1975.4369,1913.9398,1779.5256,1711.6012,1714.3523,1722.1973,1708.4413,1933.6213,1992.2292,2282.729,2358.6482,2408.9844,2296.822,2117.6487,1886.1078,1410.999,1237.6996,1138.5137,1139.3779,608.8767,437.28918,813.87036,1960.7539,1647.509,1495.8483,1420.969,1449.0116,1547.1746,1460.9958,1678.6426,1688.3348,1757.3041,2063.683,2242.9824,2331.8062,2326.8052,2313.4392,2289.4812,2317.572,2206.8481,2261.7725,1840.8053,1595.2891,1586.905,1389.8745,1289.8455,1214.7059,1148.2471,1112.9534,1076.6904,1052.6368,1120.6058,1208.3397,1139.4937,1182.1239,1178.2131,1124.7614,1118.0204,1133.729,1312.0094,1282.7383,1330.2968,1067.2559,832.2458,1092.2904,1116.0837,1090.6948,1116.9106,1310.7015,1786.9032,1879.08,1711.7644,2045.3073,2329.161,2058.8582,2245.055,2368.3752,2387.8298,2298.5884,2521.2576,2445.6777,2304.3213,2238.209,2199.372,2353.4336,1789.9209,1330.058,1651.9523,2323.0022,2338.9006,2372.5337,2285.3127,2414.8525,2651.0718,2612.549,2472.9268,2547.3372,2529.5664,2268.6543,2013.9174,1705.7404,1502.6915,1406.5155,1340.0449,1483.9408,1575.6036,1719.4725,1964.4545,2151.4834,2109.971,1853.5076,1523.4675,1262.365,1365.2107,1550.1663,1537.1373,1569.226,1463.4565,1674.2318,1751.4285,1855.294,2001.0631,2272.135,2407.1143,2550.4546,2588.7556,2132.873,1943.3446,1903.8833,1806.7853,1750.5549,1752.487,1602.3989,1974.5204,1955.6802,1901.863,1513.0674,2223.6946,2555.3525,2672.5945,2697.3975,2330.2212,1888.848,1613.9473,1462.9705,1434.9973,1350.5411,1280.2064,1146.7047,1409.8219,1568.6289,1445.0559,1412.1333,1508.6407,1601.4454,347.905,-69.24976,537.61743,1887.0415,1834.5061,1946.4491,2010.7269,2150.2766,2166.2935,1882.6317,2074.247,2064.568,1672.785,2240.7507,1660.6001,1357.1715,1809.1525,1575.916,1449.6221,1327.2333,1277.2952,1229.099,1180.9414,1165.2775,1171.2454,1245.4623,1273.1554,1331.2665,1048.9202,1054.0227,984.4641,1026.3435,1025.2639,873.9646,753.4808,794.6937,602.45825,939.11456,873.19495,1125.296,1202.6118,1532.0742,2325.7388,1776.3026,1627.7686,1811.6777,1828.7976,1884.153,2057.581,2232.8232,2365.4905,2392.2449,2296.247,2336.402,2280.7334,2178.0137,2218.0188,2203.8318,1273.0088,798.8137,1237.3887,2241.8115,2237.949,2180.2393,2130.374,2176.3367,2275.8887,2391.4631,2463.3433,2450.4536,2453.628,2432.752,2333.1658,2001.464,1814.2896,1595.2048,1165.9634,1404.7766,1682.3542,1720.7699,1946.0167,2114.3489,1918.5471,1824.8806,940.0918,819.5034,873.6265,1628.0969,1996.526,1969.3151,1961.9471,1907.2749,1999.8673,2035.9972,2098.365,2343.8906,2509.4238,2816.7893,2485.165,1973.9556,1867.1377,1818.1837,1743.3905,1706.741,1682.5238,1661.832,1737.7866,1779.853,1544.3785,1670.306,2252.8003,2484.0168,2006.2281,2252.641,2090.449,1487.1433,1184.2659,1361.0287,1537.077,1368.204,1320.7726,1303.7893,1313.4242,1322.6946,1333.2672,1390.6355,1419.1034,1347.3677,1548.4502,1279.3038,1485.58,1929.6038,1901.8177,1970.7651,2081.3188,2119.8457,2151.4778,2084.8418,2107.9805,2158.8281,2308.7454,2251.3704,2215.4187,2153.3035,1973.184,1724.6672,1626.6943,1624.0658,1589.2506,1562.4957,1482.0385,1394.1989,1353.615,1345.8542,1365.4767,1470.9991,1042.1691,984.5321,993.21594,990.3725,996.4794,979.5596,998.8693,979.71356,939.58655,884.4166,834.618,1238.3843,1163.0901,1228.8118,1623.2585,1464.9135,1081.7375,1207.2457,1850.3398,1910.2322,2198.3057,2385.4883,2142.493,1723.3436,2415.9026,2284.7793,2013.8611,2013.9647,2158.403,2031.745,2152.505,2317.7632,2280.1494,2138.3054,2093.9521,2014.7178,2101.197,2125.3425,2145.5725,2160.3735,2306.733,2264.8232,2212.9944,2173.312,2054.4463,1937.8053,1914.0707,1685.4479,862.0765,1212.1433,1600.2726,1418.257,1837.9971,1682.7997,1478.6521,2075.1113,1307.8535,1417.5946,1709.6589,2362.2178,2308.1362,2113.3706,2248.885,2249.9392,2425.4087,2319.2659,2388.7495,2595.1946,2623.1921,2613.0007,2160.5815,1904.5024,1810.6824,1757.109,1682.4038,1646.5499,1686.5754,1676.88,1634.6882,1788.3583,1770.8201,1872.3777,2244.561,1720.8303,1088.2979,1172.6223,1431.7065,1948.245,1624.7374,1476.2422,1381.5186,1322.5,1318.0547,1310.0358,1322.9672,1449.6362,1541.8503,1689.6031,463.21408,-246.80704,435.44278,1925.4893,1874.5265,1971.2299,1977.7491,2108.8303,2147.8545,2120.5823,1692.7314,2163.8032,2144.3267,2307.3372,2303.9165,2277.535,2280.209,2240.7803,2183.0625,2117.9155,2087.5781,2144.6667,1894.4597,1437.7228,1921.7264,1785.7803,1646.1792,1642.3254,1623.4478,1708.4633,974.23584,999.45856,1031.3702,1005.5512,943.7213,859.43524,853.1267,851.6083,842.77765,971.085,1044.7383,1329.0646,1400.9656,1187.4321,1336.694,1366.2343,1125.3257,1341.0393,1896.8534,2034.7798,2241.744,2225.8545,2205.5408,2005.1403,2321.3516,1968.3037,1896.1144,1891.479,1829.7875,1873.3779,1883.2565,1891.3655,1902.7839,1947.9967,2004.8623,1805.3939,1860.9744,1964.1228,2161.2395,1914.4789,2158.2378,2168.4214,2068.259,1942.9517,1894.127,1737.6842,1654.3116,1628.1665,1613.9065,1576.5254,1582.8795,1180.1215,1643.7853,1704.863,1663.7863,1882.0336,1721.1976,2229.95,2329.5105,2493.691,2571.2861,2576.889,2636.2808,2484.6697,1356.3254,991.4204,1207.5037,2576.547,2929.947,2699.1892,2220.1265,1959.9404,1830.767,1705.2483,1656.0548,1605.2474,1659.1825,1669.4857,1556.9109,1655.3948,1777.8175,1867.4934,1989.2856,2359.6414,2213.4795,2341.6633,2062.8984,1763.4563,1455.0853,1325.0245,1333.0947,1311.456,1305.5972,1316.5737,1453.0013,1854.1162,1646.1346,1212.8964,1589.2623,1268.8939,1473.4027,1821.1716,1935.4913,2068.6057,2154.7278,2278.261,2333.509,2351.7139,2339.1543,2410.8086,2459.587,2504.7988,2469.0232,2412.969,2409.6929,2379.1255,2411.726,2455.201,2504.8057,2489.6416,2308.7043,1940.0188,2229.0615,2160.9534,1950.8168,1758.0826,1679.4619,1729.5477,1068.074,1122.0204,1118.3484,959.9609,905.22797,899.5472,832.471,836.7808,896.8628,950.6322,1208.9779,1417.9972,1566.7316,1644.9144,1630.291,1534.3257,1490.5016,1473.6104,1592.1328,1618.6315,1812.0305,1600.0201,1702.0454,1600.0381,1509.8547,1634.1053,1596.4426,1723.031,1635.2678,1662.8241,1738.5964,1728.4327,1874.1925,1947.1586,1965.9698,1837.0764,1780.4706,1973.9648,2025.249,2073.4841,2086.7708,2005.2853,2013.4093,1922.3975,1270.1757,1126.2838,1007.9545,1469.4451,1602.2993,1413.1199,1534.3246,1538.7172,1438.9775,1454.1877,1555.3124,1673.3962,1879.0568,2033.7109,2144.775,2498.5698,2550.6548,2466.7646,2457.697,2674.0542,1663.4697,991.94403,1338.7515,2319.8093,2227.1372,2608.5256,2406.1045,2169.7498,1895.3715,1839.7651,1721.9803,1597.3572,1584.4779,1564.3624,1591.012,1546.7101,1622.617,1505.5377,1671.2294,1968.2506,1992.5846,2048.1135,1812.3519,1463.9926,1293.5995,1288.5162,1289.2505,1313.5908,1323.2924,1435.8984,1591.5004,1691.8154,1722.4851,1586.9027,1514.788,1489.1919,1393.481,1476.4661,1689.3456,1866.7482,1692.5424,1806.2863,2443.8706,2448.1958,2488.1665,2472.5664,2469.7966,2278.7546,1905.3455,2342.3408,2390.8416,2361.829,2527.3782,2581.8237,2540.408,2537.613,2463.2974,2460.6191,2479.935,2420.8325,2023.705,1678.0454,1643.8723,1628.3077,1027.8066,1143.0947,1225.4958,1330.2511,1042.0563,992.20856,914.37317,899.25024,876.11786,549.2971,506.8352,746.03143,886.385,1636.519,1770.3099,1582.8058,1419.2008,1337.4835,1300.0007,1294.8204,1355.2106,1284.3147,1419.2983,1313.8734,1250.6421,1356.7465,1605.676,1540.0472,1547.601,1591.9362,1608.7444,1651.0988,1701.2354,1715.8152,2028.7832,1937.9121,1880.7424,1838.341,1894.6108,1952.4546,1865.8093,570.88416,418.1161,1637.8862,1695.0106,1468.7262,1694.9479,1879.4141,1889.1385,1752.5052,1628.3439,1565.9734,1489.2819,1473.4999,1478.7861,1527.8883,1654.9407,1851.6869,1987.2897,2186.236,2260.8777,2326.6245,2425.834,2650.3376,2500.9473,2347.208,2307.5913,2108.1345,2050.188,2017.7845,2041.4741,2131.227,1824.6714,1645.5588,1189.8569,1127.1965,1502.1337,1630.3201,1569.3651,1571.9943,1581.6565,1584.248,1653.8129,1433.774,832.5861,464.96826,827.06024,1660.5575,1459.4894,1342.601,1358.636,1449.4188,1734.1139,1852.6855,1719.4076,1637.6995,1588.3495,1513.8705,1453.2719,1453.2324,1452.6344,1453.4053,1505.2429,1417.1332,2040.6803,2316.1138,2339.4038,2402.5786,2405.9482,2402.6702,2413.7124,2333.5752,2333.5498,2481.6367,2480.0374,2475.7651,2406.4185,2443.1643,2421.2258,2194.7673,2051.1926,2313.0164,2297.327,2274.4346,2184.3,2006.77,1833.3055,1860.1401,985.0481,1017.26575,1112.8599,1354.2637,1119.9974,1114.1758,1082.3472,1127.1973,772.1564,108.83118,309.6017,479.4375,369.75458,1500.6956,1911.548,1807.1036,1449.701,1251.8422,1225.7653,1187.0671,1164.723,1163.622,1208.7976,1140.1107,1164.8579,1422.8181,1388.2411,1393.6732,1383.7021,1503.377,1652.0035,1712.2717,1583.0454,1002.6187,2020.743,2114.305,1809.404,1651.219,1650.9547,1749.818,1791.5938,1584.5325,1396.1813,1287.1749,1048.9806,1840.5549,1995.3484,1925.3746,1809.6913,1771.9594,1735.9467,1649.0063,1581.8954,1539.5414,1530.1042,1558.4331,1607.9818,1711.5951,1878.1102,2128.701,2439.6384,2625.21,2629.9934,2512.076,1912.223,1688.4784,1771.1791,1968.433,1912.6327,1834.9636,1768.557,1637.7487,1558.461,753.9759,319.31705,300.90414,960.5342,1707.5571,1552.5626,1553.0825,1565.9999,1578.1067,1736.2618,1251.34,1056.3907,914.4042,1576.2467,2010.0718,1571.604,1451.1432,1497.0872,1567.2754,1716.8168,1370.551,1686.2279,1592.4542,1540.3728,1484.0272,1480.5184,1479.036,1490.82,1521.6875,1565.353,1729.6958,2112.2485,2312.658,2468.6968,2570.7737,2444.502,2363.47,2277.6147,2497.2961,2523.295,2569.9072,2592.9397,2587.34,2558.6443,2471.567,2525.444,2266.3235,2164.7007,2234.9658,2057.2449,2100.084,1912.8529,1740.9741,1690.305,1659.0734,963.3432,1012.8225,1299.7358,1392.3303,1435.1493,1398.563,1391.1266,1666.5326,1620.3884,725.17175,260.13235,482.34558,982.34454,1810.969,2067.6267,1935.7626,1668.8102,1310.9801,1205.5918,1167.2616,1167.3693,1150.6761,1361.9421,1359.7063,1465.0145,1322.4712,1571.0953,1491.8953,946.0341,899.50275,1299.2717,1754.5964,1966.8328,2089.3206,2069.7944,1823.3132,1521.4342,1583.1823,1489.7688,1527.4148,1562.485,1635.1095,1668.0643,1640.8799,1619.0747,1841.5958,1742.55,1519.0145,1482.2979,931.4269,1282.4489,1684.5719,1606.8983,1620.9185,1623.5634,1650.0858,1687.74,1776.167,1863.0917,2113.922,2263.6345,2515.77,2849.7622,2719.584,2290.8943,1865.502,2054.1997,2265.9639,2309.094,2402.5356,2198.6143,1799.0604,1633.9014,1534.6526,1171.2255,1286.4617,1804.2365,1728.2095,1594.0458,1588.6456,1581.7052,1600.3167,1670.7877,1772.8829,1662.0681,1783.8591,1997.2999,1638.5822,1492.7854,1480.7972,1510.1362,1623.9034,1232.2565,249.65015,986.44977,1648.2803,1540.3654,1520.3024,1530.0665,1536.0427,1536.1438,1550.556,1437.9028,1858.2565,1852.0269,2294.0154,2418.546,2567.284,2604.7766,2595.8523,2648.496,2790.8677,2813.1255,2871.7246,2834.7766,2741.9946,2717.1934,2740.6016,2662.1772,2136.4214,2185.7026,1926.991,1509.3989,1746.2883,1843.5596,1680.5544,1623.1433,1598.8239,976.54803,1084.0671,1191.8534,1318.7153,1447.9944,1140.7456,1279.2169,1804.3806,1831.0529,1874.1235,1569.0107,1651.7356,1727.2894,1754.2687,1817.075,2124.1968,1566.8909,1300.3165,1241.1584,1132.4541,1209.9402,1417.8345,1586.276,1410.4713,1213.7275,1261.8333,1606.0707,1806.0967,1327.0577,1272.541,1589.968,1755.0133,1785.6556,1804.0461,1835.73,1664.6603,1544.2023,1472.5076,1421.8945,1414.2522,1464.7493,1527.2444,1580.0594,1691.9653,1755.2748,1749.8696,1731.4082,1818.2712,1868.8765,1755.5734,1674.5515,1764.5829,1664.8824,1645.3174,1696.3348,1707.4327,1762.578,1839.0281,1905.7603,2020.6971,2164.0315,2371.671,2508.3608,2749.0405,2598.6301,2500.4678,2478.8398,2461.8826,2554.1582,2530.4785,2034.7072,1994.8557,1906.7782,1629.2086,1791.2458,1917.8806,1714.1381,1714.7563,1620.8113,1627.3066,1620.4849,1635.3912,1615.093,1618.8607,1866.9814,2193.4822,1906.2173,1539.5253,1520.7676,1549.5814,1609.7242,1859.5835,2189.361,1969.3635,1834.1221,1639.3884,1602.8098,1622.4332,1462.3442,1648.5419,1698.7025,1688.4894,1745.0271,1835.5244,1820.5333,2035.9998,2227.6536,2380.8086,2571.2493,2617.2988,2840.456,2882.2686,2983.227,2947.8088,2970.9348,3045.9832,2973.2222,2575.5647,2866.0037,2687.415,2540.5032,2235.2825,1841.4276,1793.4307,1722.0614,1644.851,1595.9285,1586.9939,993.54297,1025.6648,1103.3036,1359.8784,1518.1064,1754.817,1818.2765,1758.5442,1562.72,1573.091,1327.45,989.806,967.47974,1006.09375,1185.3131,2251.3064,2024.2268,1403.7548,1061.0271,1287.2684,2300.4417,2168.779,1408.1063,1251.3262,1191.7355,1305.5343,1608.6145,1855.4648,1808.092,1806.8607,1805.634,1760.4832,1695.5575,1714.583,1740.8683,1581.3848,1504.6447,1462.8909,1417.6046,1431.7479,1526.0955,1569.1077,1698.8585,1806.779,1903.7603,1716.4742,1964.5156,1986.4979,2121.104,2070.3687,1730.9673,1799.7333,1686.0682,1714.15,1710.6272,1752.5139,1867.2488,1923.5011,2003.7021,2116.1174,2318.202,2411.5771,2544.766,2960.7246,2944.1008,2788.7144,2586.871,1668.87,2917.825,2449.466,1977.833,2002.1543,1989.8038,1878.9565,2276.1624,2376.3816,2114.8574,1951.8993,1742.4218,1628.4664,1612.3516,1615.1501,1618.6571,1852.8428,1912.9061,1816.0154,1509.9747,1520.309,1555.2869,1625.3833,1715.2222,1998.7886,2126.6858,2088.1511,2286.0503,1792.9237,1689.2706,1715.5685,1756.5391,1926.6288,2119.3406,2042.6417,1932.7804,1935.4247,1840.4951,2004.701,2207.323,2345.9143,2257.655,2672.4895,2932.265,3040.897,3094.3162,3020.439,3011.3557,3095.1836,3178.2659,2942.5918,2832.3376,2872.0823,2590.6829,2170.8096,1884.8131,1779.5433,1721.2056,1671.0056,1606.1567,1523.4293,1076.3337,1076.0105,1222.7346,1482.3896,1622.6528,1411.2916,1403.2354,1511.8774,1429.8607,1400.9132,935.7959,656.4276,558.87274,567.1695,540.40845,532.97595,468.9114,372.9535,564.11914,1342.9474,1276.6793,1112.7604,1324.5514,1227.8755,1407.532,1618.5487,1887.8353,1744.7635,1908.4988,1867.6871,1878.504,1774.5491,1639.4926,1769.1519,1782.8715,1732.2606,1649.1836,1532.6016,1534.8386,1657.1505,1737.3535,1633.7104,1715.7776,1913.0706,2133.6462,2066.6262,2043.2043,1857.6136,1698.6459,2183.8823,1996.5322,1900.8116,1992.2878,2159.7764,1824.1366,1660.8176,1993.1561,1999.4462,2027.5155,2153.9646,2299.1448,2449.5295,2545.546,3191.7317,3358.1238,2574.4465,2819.3213,3268.7698,3006.028,2900.765,2502.258,2074.8096,2216.1948,2332.1267,2515.7913,2197.7876,1911.1174,1733.755,1684.1547,1646.6128,1638.4034,1615.7142,1636.5786,1791.8895,1934.1897,1604.2523,1541.6357,1566.8204,1577.6003,1678.1975,1854.7787,1616.6082,513.8611,471.6128,1601.6488,2468.2659,2191.8918,2040.3652,2034.2987,2033.4476,1446.1754,1990.7019,2323.3787,2242.8262,2201.8386,2193.6484,2268.7134,2381.5278,2597.0435,2879.5547,3012.22,3099.3662,3213.6633,3221.5227,3259.1733,3134.4543,3209.0498,3180.1992,3129.4897,3027.5923,2654.787,2237.7122,1947.9056,1837.1018,1762.7281,1707.9049,1643.2761,1560.2594,1260.6361,1353.2286,1403.8671,1603.7731,1799.0394,1755.7825,1811.0591,1543.2861,1352.1884,1436.9467,827.48315,559.04144,439.4233,426.70364,352.6039,299.0631,131.08989,44.399048,200.98647,719.39343,900.97144,903.70776,1128.4669,1283.7471,1821.4567,2123.8938,1930.2568,2023.8932,2166.4675,2278.9675,2194.0488,2147.9502,2099.2769,2132.283,2144.197,2179.2773,2086.0212,1910.4915,1791.7201,1704.3667,1772.5543,1912.83,1963.727,2082.32,2124.5947,2147.4756,2106.2332,2077.2139,2007.6113,2245.626,2500.5603,2550.2034,2649.8848,2860.9578,1787.9453,1426.4205,2173.3496,2166.0317,2063.2805,2058.0166,2174.1084,2670.5723,3127.524,3559.7712,3645.9912,3226.8306,3632.6624,3653.635,2891.5168,2757.9941,2902.6614,2561.2434,2437.0898,2394.6245,2226.1348,1830.3207,1675.8226,1648.328,1656.7261,1660.7026,1661.5903,1663.9752,1671.2457,1707.187,1872.4988,1697.263,1558.2899,1590.9906,1613.308,1711.8142,1856.4294,1988.893,1344.362,1473.371,2677.2295,2914.249,2753.3855,2744.6833,2694.377,2774.1506,2637.4111,2586.0676,2507.5776,2464.915,2473.8533,2280.6685,2336.8848,2403.6462,2617.2327,2835.594,3030.1536,3193.6,3319.1597,3431.4778,3426.8672,3243.6023,3169.1792,3098.7693,3071.2966,3091.9548,2796.707,2352.3862,2030.6259,1903.6046,1824.9115,1740.4321,1645.2435,1571.5371,1910.9507,1770.8195,1583.2539,1807.9288,2018.2911,2140.94,1803.0835,1567.8976,1361.9825,1608.7794,840.98474,535.56134,454.08102,402.5594,272.22412,117.47683,20.713549,23.024773,282.66626,596.702,1041.2253,904.3891,1011.9054,1198.339,1256.7695,1911.6271,2209.7336,2203.155,1583.6855,2035.23,2118.3838,2256.3564,2474.926,2337.8691,2449.906,2479.8145,2479.7908,2334.7002,2151.4783,1972.5808,1945.881,1990.6654,2144.9321,2214.4385,2255.5588,2345.9324,1934.2622,2139.84,2233.2034,2607.762,2987.0146,2992.2551,2617.3635,2631.743,2669.065,2716.7197,2796.7166,2335.466,2171.6484,2062.4272,2118.6545,2506.6597,2694.49,3165.5688,3755.5146,3379.6099,2358.429,2685.108,2418.5908,2372.6575,2484.6697,2623.608,2402.6355,2306.8176,1990.2557,1685.2512,1658.9001,1636.2701,1653.9866,1665.5996,1672.5281,1684.1484,1687.1891,1698.3696,1853.74,1860.4117,1626.2141,1641.4127,1650.5186,1717.1987,1841.7864,2090.2317,2405.8948,2589.7253,3306.567,3116.1418,3053.712,3078.5105,2453.0513,2530.492,3121.4084,2829.5261,2632.1506,2620.101,2620.2207,2575.0498,2632.9563,2552.2957,2615.0776,2736.8184,2903.7407,3136.4036,3169.1526,3344.9133,3350.7236,3396.868,3292.7632,3138.3792,3146.1345,3052.4343,2793.8447,2501.64,2172.4072,2003.7316,1779.2356,1834.5396,1803.3057,1541.4431,2046.4496,2125.7285,2064.251,2102.1194,2499.7974,2162.244,1887.3416,1797.7057,1810.4811,2337.4377,1490.1603,706.9694,556.52234,450.7784,200.12137,69.85511,5.771669,144.89557,387.6556,1158.9268,1411.8041,989.3574,1086.0253,1361.3038,1445.3773,1677.5195,2024.1968,1983.0176,2099.0354,1842.6948,2079.9011,2321.2664,2419.3323,1546.1036,1661.4535,2577.491,2836.1208,2749.6646,2599.8562,2231.2458,1977.7554,2164.4866,2314.8586,2352.1924,2414.1606,2224.9521,2603.9573,2483.1135,2351.0815,2421.234,3025.867,3179.3564,2618.1948,2564.7444,2589.141,2307.267,2541.6704,2467.9033,2313.8,2302.264,2303.9824,2360.2466,2479.865,2649.055,2695.344,2887.5408,2659.5696,2620.8909,2419.4846,2316.0386,2259.4907,2230.3257,1815.2867,2114.1382,1912.1832,1794.3257,1704.548,1682.0847,1671.915,1669.591,1677.6909,1714.4844,1720.58,1731.2268,1792.2341,2086.6987,1907.9677,1765.372,1757.098,1915.723,2113.717,2276.6836,2421.0007,2679.1165,3128.9507,3026.364,3060.519,3082.9304,3188.8445,3131.3237,2929.3179,2679.6125,2639.0596,2673.0693,2631.5815,2541.4028,2415.1675,2390.1392,2428.7007,2562.4075,2769.1255,2868.788,3022.6646,3205.119,3339.9072,3391.579,3388.2673,3255.8894,3165.3247,2947.1128,2692.4187,2498.188,2364.4082,2296.3284,1945.364,1793.0262,1786.8203,1802.2917,1882.0691,1981.059,1669.3221,2141.3223,2138.3438,2039.5192,1812.926,1672.9415,1985.9985,2611.789,2887.5017,1204.7952,711.30084,558.0643,318.91217,190.02261,247.62602,592.1987,1268.3077,2155.0405,1776.0138,1125.4115,1222.3649,1263.474,1394.894,1656.7739,1914.1454,1884.6075,2121.1802,2280.7085,2313.9053,2455.0142,2746.0159,2804.932,2999.631,3252.5386,2898.9204,2530.941,2782.7231,2553.5671,1750.6594,2097.7102,2628.0225,2582.4736,2617.7886,2695.367,3036.6047,2741.012,2714.2522,2899.9797,3042.9622,3045.8833,2857.7156,2699.2268,2547.5486,2224.294,2383.9543,2460.63,2620.9363,2632.8801,2786.2224,2831.2522,2573.9812,2414.9673,2578.9165,2531.9744,2444.4548,2214.1472,2199.5366,1971.4237,2158.3179,2175.68,2076.5908,2099.7788,2120.086,1822.7708,1795.9995,1774.2711,1736.3978,1713.9248,1694.5903,1712.4738,1732.9077,1738.6882,1734.9923,1751.7845,1787.6891,1804.2551,1775.5386,1814.6342,1871.6226,1857.3055,1902.6311,2204.131,2589.8022,2494.2854,2659.2993,2990.1646,3166.807,3014.967,2806.9766,2488.4548,2324.4067,2275.4473,2301.896,2238.2446,2182.4277,2192.506,2220.2087,2380.9175,2603.1614,2656.0422,2789.8555,2998.545,3190.453,3338.717,3234.056,3207.6414,3076.4712,2856.8088,2604.5022,2472.263,2441.4746,2450.0393,2316.2524,2168.5674,2065.6921,1865.8762,2080.5474,2174.6929,2007.8392,1692.9674,1654.9586,1959.6019,1991.7994,1888.5774,1845.2432,2127.9294,2224.8584,1566.9381,774.42004,675.10614,585.19934,585.34753,763.4978,1361.1831,1905.4236,1981.216,1822.5891,1299.536,1269.1217,1382.515,1406.958,1664.586,1901.1339,2148.929,2183.2627,2185.0222,1980.8202,1922.4443,2185.3743,2498.8423,2869.0989,2898.3572,1701.5619,1710.098,2045.5078,2623.3015,2706.506,2285.3977,2500.7673,2628.4277,2876.3357,3444.3413,3299.0232,3139.118,3166.993,3082.9902,2874.2607,2328.6655,2753.061,2672.4666,2533.2126,2331.7224,2196.8818,2199.0156,2501.1948,2682.5493,2755.373,2699.0269,2431.601,2234.6658,2328.2385,2044.5931,2073.9004,2056.4763,2050.1768,2095.5352,1917.8457,1462.938,2221.7173,2436.9683,2189.8418,1927.4298,1940.5851,1939.6798,1894.6951,1806.0779,1756.7406,1770.0748,1758.3868,1708.8834,1695.4254,1753.8174,1775.8031,1780.6921,1748.594,1780.8273,1796.7354,1741.303,1792.5009,2247.9983,2581.007,2684.2754,2638.7095,2775.5847,2824.7156,2597.9668,2446.3728,2295.3596,2265.766,2248.7424,2167.489,2201.4824,2210.6697,2203.2986,2228.0955,2289.9824,2623.8513,2498.803,2677.5535,2868.3408,2747.411,2458.4683,3042.503,2920.184,2720.824,2683.7585,2581.6272,2519.549,2540.968,2480.7554,2513.5671,2841.5598,2685.0415,2222.5122,2680.8135,2573.2234,1915.7833,1742.8496,1701.0103,1679.7102,1763.2318,1659.5819,1564.7426,1495.2263,1573.596,1786.5193,1600.4252,1389.2942,1728.5203,1473.9911,1550.9386,1722.792,1553.459,1401.2026,1347.1646,1162.3506,946.57635,1205.0619,1251.9478,1542.0039,1872.2744,2474.5918,2213.318,1741.8647,1665.1685,1658.7155,1650.1421,1774.7286,2159.9927,2603.0225,2211.8164,2071.4897,2598.2407,2387.5264,2430.8862,2444.491,2434.3708,2532.6736,2711.1492,3344.5845,3599.7134,3009.3025,2991.996,3088.9463,2710.4897,2695.301,2702.4087,2532.187,2223.724,2109.3413,2078.1423,2032.6967,2064.77,2122.4763,2243.8257,2438.8464,2314.9368,2082.3237,2239.492,1972.682,2063.295,2043.9083,2068.5493,2037.294,2062.0222,1998.6115,2151.3816,2136.1516,2126.3108,2059.3157,2195.8774,2205.8508,2342.4382,1916.5996,1822.3488,1853.4384,1824.2314,1584.4598,1598.4589,1742.7933,1557.254,1577.593,1787.7339,1786.8687,1805.4962,1821.9095,1866.7595,2128.4927,2156.853,2132.893,2260.3594,2414.4963,2451.6863,2366.104,2280.9053,2279.4546,2283.675,2274.659,2246.298,2231.2446,2215.2483,2201.8557,2204.248,2243.7603,2323.1118,2365.425,2452.7405,2522.2407,2675.8152,2650.2703,2961.4558,3030.1165,2785.0386,2601.18,2576.3083,2799.7356,2820.9783,2589.4966,2589.9841,3118.0664,3098.1155,2702.6206,2005.9496,1886.9033,1643.2123,1600.1685,1757.358,1880.9861,1824.4431,1502.9463,1482.1366,1559.7933,2093.7727,2281.0322,2116.7065,2333.3047,1863.3354,1597.8821,1471.8729,1432.5128,1280.4132,1195.906,1165.353,1155.188,1191.0916,1142.0458,1356.7941,1801.5728,2429.823,2557.5784,2066.6538,1647.3413,1632.1038,1627.6205,1668.8564,1767.8446,1899.9427,2325.847,2450.6597,2381.1055,2372.4336,2568.6733,2078.9563,2324.0144,2340.5964,2452.1797,2604.8328,2624.9546,2720.4685,2813.6477,2606.115,2580.022,2434.36,2368.2422,2320.9321,2089.8433,1978.2117,1925.4053,2044.0522,2096.681,2068.7126,2035.6232,2153.1274,2248.142,2159.8997,1839.4783,1752.3442,2154.0361,2196.1807,2073.3938,1962.3268,1922.6136,1951.44,1911.4136,1885.9949,1883.171,1916.9076,1907.8468,1990.2933,1963.7195,2171.241,1966.1808,1904.8073,1687.3999,1866.3375,1898.0927,1884.6619,1887.392,1785.331,1816.0243,1931.8783,1975.1075,1916.667,1890.2765,1861.5569,2054.38,2005.7687,1936.3135,1906.8142,2464.8948,2348.2834,2338.3608,2318.9778,2301.7463,2293.1155,2289.4138,2288.5964,2252.2747,2215.5198,2195.6423,2168.1045,2148.2415,2177.1543,2275.6165,2215.8003,2274.913,2573.1252,2660.374,2653.9822,2863.8723,2781.9973,2566.3022,2386.9165,2543.8262,2969.2976,3024.9243,3074.8823,3081.1353,2867.9844,2625.8347,1607.0764,1525.1068,1373.395,1362.0372,1551.5992,1721.318,1648.035,1317.5142,1573.5751,2048.3096,2398.2112,1470.4457,1267.4208,1345.7709,1431.0155,1481.5134,1390.4879,1343.0059,1342.8654,1338.628,1291.1346,1206.9172,1147.1227,1134.7668,1230.3505,1787.1726,2157.4458,2425.171,2495.9443,2146.9497,1847.7582,1832.7657,1932.8958,2366.824,2271.7583,2370.9333,2382.2947,2440.6912,2407.016,2348.8945,2288.257,2331.8665,2246.7373,2384.8286,1650.6631,1098.4042,1482.4132,2392.7622,2198.7168,2150.8254,2052.6404,2002.0824,1937.5853,1871.4756,1889.3451,1949.887,2108.7249,2168.0637,2184.185,1901.265,1913.0507,2053.192,1758.8887,646.082,1793.5941,2272.8284,2212.7603,2053.9985,1920.462,1799.4762,1860.9768,1571.0352,1444.6918,1785.0641,1804.378,1797.516,1850.3925,1967.6553,1955.0325,1951.7035,1986.9236,1986.8087,2015.9282,2126.064,2331.194,2231.591,2016.0801,1932.9431,2035.6599,2076.748,2088.281,2069.6843,1933.5808,2260.772,2247.64,2174.9592,2220.3699,2349.164,2349.02,2338.0232,2334.4148,2316.4697,2316.408,2299.7458,2284.401,2258.777,2212.1946,2176.4272,2135.8955,2093.6768,2080.9363,2134.4448,2125.8582,2366.9836,2435.6926,2479.627,2524.2046,2643.6077,2529.501,2404.1826,2264.643,2254.2676,2355.488,2535.096,2053.6116,2383.2827,2421.8938,2310.061,1570.5077,1499.1664,1362.4332,1227.1143,1087.9956,1016.51855,1143.9644,1133.7308,1942.0228,2636.2659,2512.0247,1216.268,1170.7911,1242.7831,1358.8495,1175.4703,1410.1514,1414.0331,1470.4558,710.7855,848.8865,1236.5415,1200.9797,1199.0822,887.8615,1494.6361,2204.605,2574.7666,2766.7507,2736.2112,2695.863,3001.0022,2771.5312,2394.6323,2302.3,2333.0244,2329.2683,2057.906,2510.9077,2277.565,2294.5623,2454.6384,2183.738,2311.9553,1439.3279,811.9469,1069.0641,1991.3513,1912.857,1911.793,1890.6813,1888.4177,1915.3843,1861.9791,1882.3805,1986.596,2080.3816,2277.5898,2219.479,1844.3278,1797.7394,1816.221,1965.6711,2227.5188,2202.6953,2228.9675,2134.5447,1887.0756,1924.2263,1958.8417,1892.4366,1921.2769,1810.7922,1748.5239,1745.019,1764.5154,1789.2848,1868.028,1831.5076,1852.4088,1971.0878,2360.6797,2252.1333,2510.3713,2889.0046,2572.666,2152.4592,2010.0786,1991.9199,1895.2214,1401.4279,1978.9868,2097.4385,1861.5164,1954.9547,2436.0508,2287.313,2289.539,2325.095,2354.787,2363.0808,2352.8914,2337.6328,2324.9834,2298.268,2262.3384,2210.464,2150.526,2103.796,2042.2596,2028.4292,2014.6917,1925.5586,2150.9595,2257.6663,2311.4756,2390.9707,2480.57,2397.9932,2297.2227,2163.5696,2125.4348,2182.0173,2195.4119,1536.8529,2013.9828,2262.69,2234.3352,1035.0565,1418.5032,1523.5463,1748.8148,1650.9143,1073.0002,920.0754,879.0695,1600.199,2309.833,2027.1665,888.3643,1154.942,1251.7837,1319.6863,1239.5223,1301.3176,1379.8438,1405.8593,1454.7316,1405.117,1321.6278,1373.405,1229.5035,1395.5116,1511.3258,2169.463,2656.113,2587.3418,2510.6853,2575.4258,2642.548,2446.3848,2274.725,2305.0088,2435.6694,2348.42,2439.5579,2831.7876,2571.8237,2340.5486,2301.198,1642.0688,1978.365,1926.1301,1784.3837,1861.168,1891.1062,1902.7808,1893.7842,1909.7549,1901.6415,1884.9542,1891.8954,1920.7227,2011.472,2178.8787,2362.402,2443.477,2110.29,1859.2223,1814.5214,1951.187,2191.8743,2166.941,2025.2053,1960.5665,1968.6924,1854.5651,2026.6313,1894.7758,2019.7906,1833.14,1701.1329,1726.7238,1744.4375,1758.9553,1965.0652,2192.6338,2211.491,2338.0496,2549.38,2478.2083,2457.8123,2364.9385,2368.8652,2107.885,2084.4912,2023.9742,2178.9297,2344.6545,2122.397,2162.5847,2019.7811,2056.0657,2036.5089,2417.0847,2346.4395,2367.2092,2396.6953,2388.9053,2383.9875,2368.7593,2341.9617,2310.909,2269.5012,2207.4263,2138.2678,2077.464,2024.3014,1959.9993,1960.0355,1961.9774,2066.2505,2211.5435,2356.8982,2493.3467,2642.9897,3158.349,3058.3293,2724.7156,2923.3926,3138.813,2685.4822,2383.504,2255.487,2204.3994,2218.326,1110.7097,1308.5216,1558.4812,1820.7314,1765.5063,934.75635,729.9898,661.3738,874.4798,1384.8594,1251.6044,956.292,1225.7543,1374.938,1391.0571,1448.5568,1348.9752,1370.0533,1345.1818,1331.8925,1355.9989,1404.41,2014.627,1498.0989,1110.5925,1505.152,2305.084,2371.2546,1934.6678,1312.4613,1028.1243,1646.4987,2268.1157,2427.2788,2484.682,2505.9558,2213.9382,2596.2004,2490.299,2343.9927,2094.0142,2062.4353,2169.829,2166.2825,1951.2664,1934.2302,1793.2687,1841.3613,1799.7025,1916.7249,1900.8433,1904.9249,1914.6705,1911.9562,1947.8927,2056.53,1870.111,2565.347,2618.1382,2472.0205,2292.449,2033.9501,1906.1072,2137.716,2140.1184,2042.9683,1937.5188,1977.0731,2056.265,1788.1515,1549.321,1692.2896,1853.6462,1722.4065,1557.5092,1693.7183,1766.8118,2097.9365,2803.5115,2679.2942,2198.4895,2152.774,2113.599,2086.2087,2184.5366,2546.2874,2461.3972,2163.5027,2091.5508,2778.9094,2801.9856,2380.0042,2702.3242,3129.853,2167.0664,1978.6417,2471.4207,2380.4617,2404.1511,2423.9893,2429.0403,2418.412,2393.0325,2367.509,2320.2515,2272.3591,2200.0269,2119.4307,2037.645,1974.4918,1923.9546,1997.1509,2186.3005,2547.2222,2728.5112,3288.3513,3287.223,3037.5571,4103.449,4055.6501,3930.0474,4263.179,4139.1855,3788.379,3468.0325,3386.694,3021.9302,2743.7202,1034.9452,1029.547,1167.6641,934.0229,847.3383,778.2701,638.4854,553.4356,445.35843,422.98956,734.27655,814.77954,960.6481,1244.054,1432.0955,1413.1179,1248.6742,1315.6475,1318.1659,1297.9445,1231.2317,1192.3234,1291.0511,1284.0184,1085.1813,1662.3815,1648.6676,775.80707,125.29471,-79.63402,-35.69988,121.45904,497.0209,1513.9695,2517.9333,2242.866,2176.559,2055.8293,2044.5903,2007.2323,2002.463,2037.7118,1769.0271,2302.5876,2645.7659,2241.488,1839.7307,1811.7135,1847.4138,1854.294,1893.9946,1985.0775,2334.7947,2470.8928,2485.1077,2555.8462,2535.8083,2444.1206,2400.375,2118.35,2383.1814,2351.3408,2400.5369,2458.121,2326.6875,2100.5757,1986.339,2120.47,2234.6035,2524.7224,2805.919,2886.171,2402.4353,1853.8619,1804.2772,1825.0281,2255.8818,3166.4988,3166.735,2417.8777,2103.4775,2067.248,2073.878,2110.3076,2298.0005,2602.7383,2769.19,2468.552,2787.6504,2744.237,2510.4658,2589.752,2716.9663,2732.177,2050.0283,2031.183,2568.6536,2817.4102,2600.385,2457.3005,2470.2222,2453.584,2415.0027,2371.6902,2344.5889,2299.6665,2194.6296,2097.7822,1986.546,1938.7595,2137.059,2519.4114,2989.5735,3500.8044,3964.4524,4389.123,4577.4824,5065.7935,4501.6133,4255.804,4709.47,4764.365,4716.368,4864.451,4851.518,4742.8994,4249.321,3812.2253,931.913,928.1599,1069.1903,868.82214,807.3015,812.96783,681.3184,580.6988,290.78888,209.19551,311.7952,557.29834,773.0331,1305.7338,1486.4976,1500.9882,1373.663,1361.1427,1316.6776,1301.0994,1209.7397,1110.9247,960.41455,888.33527,1218.0076,1127.2476,335.68097,-429.56885,-602.9821,-656.0758,-543.805,-409.55368,-125.20592,297.33688,1359.692,2370.3132,2460.1985,2044.4403,1889.8866,1874.3413,1906.41,1891.4683,1502.0498,2172.1333,2863.2039,2512.2078,1859.7496,1785.3685,2062.7026,2211.3953,2382.735,2667.17,2910.1592,2917.2378,2499.4817,2456.7908,2513.2163,2437.7876,2309.44,2234.8835,2155.41,2285.2715,2316.5847,2102.0312,1927.8206,1988.803,2128.6968,2301.1052,2432.1294,2782.8606,3076.149,3156.174,2430.32,2004.4216,2346.661,2397.2905,2697.0994,2757.163,2326.6118,2124.943,2137.768,2167.1772,2317.1118,2409.585,2576.024,2857.385,2816.5557,2457.989,2680.5735,2492.6064,2434.9072,2559.04,2651.2866,2755.914,2583.0862,2573.246,2807.9607,2892.0032,2902.838,2537.197,2493.6477,2490.9438,2439.8127,2398.2341,2331.6807,2295.5913,2183.4128,2088.644,2082.7131,2599.669,3348.9526,3806.3376,4256.711,4430.9546,4461.3657,4549.518,4541.276,4743.5376,4875.3345,5445.7876,5712.794,5814.0806,6047.282,6291.9673,6323.089,6058.546,5296.6377,4429.8936,730.22614,861.9424,1225.4474,934.22296,1121.088,961.81537,812.96704,819.39233,658.8051,494.71582,486.73447,563.63074,706.3214,1208.04,1491.647,1511.2136,1298.774,1372.5577,1427.6388,1779.6257,1729.7917,1033.0613,794.2408,603.6941,658.4057,782.16785,-291.3723,-1008.09644,-1050.9719,-1161.3347,-1006.2854,-732.3338,-352.22717,119.1331,1122.9976,2579.595,2700.9067,2209.6882,1992.0107,1853.2645,1835.9938,1956.5416,2022.8873,2674.3628,2900.5828,2798.993,2389.795,2237.0657,2268.2625,2514.1902,2520.698,2557.1418,2238.833,2233.9856,2040.5295,2182.0696,2405.0403,2330.2524,2304.0413,2226.2437,2141.6125,2046.2533,1867.372,1720.5664,1687.5857,1735.8152,2296.7368,2374.441,1950.4342,2203.8486,2527.7527,2866.9492,3027.9587,2844.6218,2673.5415,2842.7605,2243.373,2163.129,2125.6296,2099.8733,2137.6194,2430.4387,2612.3398,2362.1655,2247.1338,2255.054,2271.7402,2316.0923,2480.9365,2413.073,2343.7556,2832.6672,2550.5854,2856.7886,2599.0205,2619.0327,2656.7722,2927.0647,2786.6968,2576.7422,2531.3606,2516.47,2465.0837,2422.9377,2322.3584,2275.4824,2221.3064,2179.504,2609.962,3668.368,4028.6274,4446.8916,5109.138,4685.352,4381.0,5406.777,5142.3994,4865.0913,5457.09,6886.878,6985.089,7096.227,7827.112,7538.517,7584.896,6809.766,5709.348,4880.4424,1057.9797,1008.54065,1103.7839,915.13513,765.62354,822.36566,1053.941,1177.9493,1207.9271,1251.6053,1167.4236,889.3297,756.7612,966.1699,1521.3391,1502.0265,1203.5504,1185.4492,1251.2158,1339.7709,1505.7562,1160.4735,944.8133,942.7718,1078.7144,1155.0695,-173.41995,-816.7544,-1112.2377,-1170.2869,-1045.2532,-692.9205,-247.40997,390.38425,1599.5099,2407.3477,2356.2063,2169.435,1950.9453,1822.6113,1730.184,1691.6019,1584.069,1765.5565,1942.2793,2098.604,2221.4739,2254.9824,2255.5547,2162.6433,2134.6052,2119.9712,2009.695,2017.3823,1933.4565,2117.455,2305.914,2411.9763,2195.966,2060.284,2078.386,2034.3318,1644.7021,1581.541,1636.5984,1882.0027,2194.9683,1912.0513,1814.4115,1861.524,2001.0792,2344.7134,2244.6719,1899.4832,2342.0652,2604.1797,2509.4302,2372.6685,2656.245,2288.2346,2209.3496,2345.31,2271.604,2285.2896,2272.1372,2274.4724,2304.8027,2657.908,3527.796,3816.4563,3215.3484,3044.7988,2730.5747,2800.3787,2680.464,2666.5288,2670.6675,2721.8943,2661.9004,2609.5413,2581.6763,2525.3762,2471.6582,2423.8333,2399.5186,2333.1025,2367.948,2424.4138,3448.8767,4128.281,3922.173,3802.5896,3715.6401,3866.0547,4885.6245,5476.4004,4938.6553,4843.304,4953.6426,5974.187,6493.1157,6360.75,7468.7104,7458.2197,6695.802,6137.7334,5458.8613,5058.032,896.64,328.314,1238.7609,811.92346,623.997,946.8635,1542.8275,1521.3787,1691.4845,1628.9863,1023.4703,710.5734,522.16614,614.0377,1558.0032,1761.9202,1433.3013,1214.3092,1092.0463,1141.7765,1389.242,1442.5504,1690.9204,1956.213,1914.4474,1865.888,582.84595,-260.7913,-409.11737,-468.2396,-465.52283,-225.09146,307.11884,1053.5173,1623.0032,1895.717,1527.2749,2061.0583,1880.8466,1669.5759,1560.5421,1225.072,1573.7068,1672.2742,1539.8356,1505.1962,1574.2489,1751.5696,2264.6206,2095.837,1971.294,1964.7177,1204.3876,1756.6624,1746.219,1734.472,1705.738,1770.5371,1836.6119,2324.9756,2247.367,2023.1549,1446.0997,1595.6718,1616.074,1579.8835,1609.7168,1568.6254,1623.9906,1794.177,1788.1492,1890.9598,1565.8796,1379.6936,1951.9253,2261.4531,2330.8394,2435.7896,2731.6875,2326.4622,2257.2698,2293.4758,2321.2422,2349.3455,2345.1858,2348.3213,2480.3054,2958.522,4431.0903,4380.7573,3570.3914,3320.4763,2898.778,2814.902,2820.5571,2837.5422,2780.4968,2737.037,2696.4324,2637.6597,2605.5422,2538.9583,2461.519,2420.559,2421.7817,2439.363,2505.3125,2651.662,3184.8916,3689.245,3609.047,3360.479,3339.0945,3574.112,4103.191,4852.8765,4996.6045,5043.334,5065.1406,5414.7295,5969.904,5393.003,5615.656,5417.5757,5160.4014,5266.279,5512.952,5090.1045,825.762,845.8348,874.4126,477.55115,424.45596,540.5277,912.51196,1618.5166,1652.8534,842.9551,571.0359,272.32758,35.37768,213.12744,676.5478,1112.3474,1175.659,828.2414,758.20105,810.53296,1295.1208,1274.6306,1511.3137,2277.4917,2361.689,2343.0598,2016.3478,1139.8523,352.70758,537.3297,860.8571,894.5174,1296.9647,1948.3654,2307.247,2254.2039,2249.1062,2616.1309,2037.8639,1432.159,1307.7408,1192.7367,1346.2219,1892.5765,2201.2173,1649.727,1265.3773,1226.3334,1412.7639,1645.207,1556.1835,1865.884,1767.0728,1673.4567,1560.629,1509.974,1401.3557,1369.6246,1865.9935,2526.405,2111.01,1573.944,1555.0947,1533.3075,1523.6476,1501.757,1520.5741,1597.9536,2076.862,2327.8381,2022.7426,1884.1057,2359.2412,2381.8623,2312.0562,2268.9758,2172.969,2180.4202,2589.8137,2413.3647,2364.3416,2354.1394,2393.9902,2415.5713,2832.3633,3032.3357,3159.4272,3632.3706,3624.0632,3248.6335,3100.1072,2980.305,2901.2156,2941.829,3098.3428,3141.2544,3028.7522,2926.491,2785.7087,2675.6355,2626.3818,2561.4333,2715.4631,2895.9014,2664.043,2839.7617,3182.1443,3800.09,3943.3208,3897.2014,3602.0625,3244.5908,3350.8147,3762.5928,4315.0723,5089.7573,5239.7056,5187.248,5080.12,4996.005,5339.1797,5494.403,5148.829,4792.0957,4529.7656,4579.9795,4528.193,4436.234,378.8757,644.1372,523.8398,380.62292,354.0743,451.06036,659.6499,1169.5366,2032.1774,778.48596,174.73497,-187.55396,-141.83957,57.543423,298.17654,717.5659,737.10486,736.77234,768.7835,879.78955,1576.0275,2013.2194,2089.1443,2341.1428,2486.0098,2645.7976,2749.7507,2589.881,1590.269,2229.6804,2547.5771,1989.8706,2652.934,2901.4038,2681.194,2394.1685,2193.9885,2102.492,1611.4331,1143.3011,1065.7028,1093.6128,1062.6466,1411.758,2164.122,1487.6676,1111.0537,1089.5428,1105.1636,1168.0858,979.9039,1534.4021,1496.0779,1472.328,1376.126,1387.4302,1373.9413,1533.3391,2231.3901,2100.6736,1830.5242,1212.589,1316.2328,1577.398,1672.8672,1561.927,1474.0034,1695.905,2257.079,2675.99,2469.4294,2338.611,2874.4595,2733.2896,2324.313,2314.3452,2239.9988,2227.4214,2570.678,2733.1262,2771.625,2463.4805,2470.6514,2472.3838,3031.7202,3133.2722,3426.91,3363.358,3211.7678,3013.9165,2960.8347,2966.5818,3025.4368,3453.2104,4158.5293,3398.9373,3075.7083,2985.6396,2883.7705,2746.3257,2736.4941,2644.1917,2866.6943,3143.2131,3635.6787,4331.0273,5169.621,5554.9775,4851.8525,4175.882,3467.3098,3143.2412,3682.818,4403.138,4889.3765,5304.291,5415.116,5270.549,5223.7573,4771.297,4847.6445,4991.794,4850.0728,4593.864,4363.8013,4565.3325,4496.9995,4504.3687,440.46082,598.91705,618.40283,459.68158,386.49707,542.37836,729.446,986.5317,1849.495,809.2979,-81.29581,-345.03442,-263.72134,-83.291016,83.818474,556.4601,685.14636,791.8767,882.87665,1052.1499,1969.7172,2318.246,2244.908,2357.439,2642.477,2624.9404,2932.137,3432.622,3303.715,3319.451,2779.35,1720.6284,2680.1338,2996.4783,2688.0042,2121.7458,1558.7074,1482.5043,1262.036,1032.4886,1023.43036,1030.4218,1035.3868,1072.5283,1107.1934,1081.2262,1073.9854,1084.9299,1091.195,1075.1426,1112.7422,1247.6957,1439.9098,1440.6589,1413.7091,1397.252,1381.9789,1564.3531,1802.3091,1670.1658,1472.3417,1540.9695,1972.637,2040.6558,1861.06,1672.1835,1523.0295,1638.2715,1988.5017,2564.743,2384.376,2095.203,2502.3545,2373.7883,2336.8135,2372.9048,2537.8882,2754.3704,2815.791,2969.527,2757.8003,2505.8838,2507.2114,2554.5398,2539.7375,2518.9778,2865.821,3147.5815,3201.3408,3252.097,3254.6702,3214.3123,3401.6924,4078.3374,3937.1794,3275.8582,3133.647,3063.1353,2975.8816,3634.1394,3585.5898,2935.7998,3215.6958,3535.713,4615.0874,5255.212,5691.8257,5514.815,4952.7114,4310.0674,3367.052,3435.1482,4674.724,5108.8604,5308.9707,5671.089,6084.0093,5628.944,5064.2163,4713.274,4867.433,4925.498,4670.1787,4363.869,4082.2463,4691.145,4833.9106,4755.539,789.32324,801.08716,891.62195,483.65225,328.14868,748.7018,1108.6907,1141.6226,1028.3501,550.23975,-18.249447,-216.86066,-102.84812,114.61247,386.68967,717.01086,1020.85223,945.5126,1070.5835,1321.081,1836.7513,2141.4868,2409.9944,2537.17,2812.823,2991.0222,3276.3794,3355.2798,3488.2925,3369.189,3243.9197,2573.6875,2421.275,2450.2249,2334.2856,1718.4872,1546.2228,1478.6409,1240.5254,1030.9174,1015.5332,1023.91016,1039.0414,1050.9905,1069.5969,1074.3347,1090.9158,1086.7487,1063.9454,1085.6852,1087.9584,1058.9991,1346.6274,1481.9164,1438.7965,1591.7689,1886.724,1611.1118,1551.8657,1526.3146,1462.9584,1686.43,1772.9199,1373.3518,1854.6796,1682.0933,1534.0856,1732.5316,2203.2,2541.409,2492.1216,2315.2676,2217.9248,2358.6672,2387.2947,2509.5444,2826.6917,3112.2166,3016.4204,2994.5789,2757.8281,2586.8516,2245.2454,2367.344,2648.5137,2702.5889,3271.1694,3942.1138,3385.0242,3349.118,3263.7725,3616.963,3966.855,3863.5325,3529.5325,3352.8142,3255.2646,3161.5803,3365.723,3856.7979,3452.2893,3004.0247,3286.66,3861.6475,4672.1475,5295.2593,5660.4736,5487.194,5027.861,4616.6787,3978.7698,4175.8438,4930.561,5113.5693,5182.824,5096.175,5522.33,4922.6006,4609.326,4368.6924,4461.342,4232.6387,4357.448,4282.4463,4182.198,5344.2607,5352.441,5160.2085,285.4702,133.4198,13.627735,-28.707436,101.146706,1020.5795,1543.4373,1457.0573,1018.20544,640.9008,357.93814,338.98026,674.4357,1213.5511,1193.8182,1530.6967,1306.6476,1195.3036,1349.7974,1667.1127,1717.4055,1622.9733,2007.0087,2747.0034,2895.5676,2945.099,3039.0447,3345.2688,3240.996,2940.9639,2758.3467,2589.6357,2455.3328,2415.1077,2222.8923,1886.3204,1603.7246,1186.1643,1256.6836,1160.0477,1025.754,1014.59674,1035.6879,1050.8677,1046.6266,1062.2351,1079.6982,1268.8094,1138.0461,1264.5463,1122.3536,996.76074,1337.8151,1534.975,1494.2262,1866.2812,2333.1204,1583.9264,1572.4769,1550.9908,1612.4508,2325.034,2047.9766,2010.9622,1910.2751,1666.0331,1629.9202,1960.7864,2761.8262,2693.464,2261.959,2286.3706,2332.949,2384.2356,2474.1387,2665.5952,2727.9556,2757.999,2848.592,3137.84,2943.8328,2820.22,2708.1323,2990.5337,3137.2505,2998.0764,3856.47,4137.4077,3024.6917,3301.2993,3454.4214,3550.033,3670.621,3729.6028,3519.9258,3425.3076,3346.5942,3339.475,3680.1372,3551.1936,3157.5425,3328.5208,3689.7517,4096.8823,4687.169,5472.284,5593.7573,5438.015,5238.806,4854.451,4484.711,4726.659,5205.0845,5204.714,5088.699,4759.4004,4722.212,4632.4375,4450.0054,4094.636,3832.4062,4002.527,4141.396,4529.5986,5001.9326,5553.063,5373.3037,4885.919,364.44742,-154.85153,-336.4164,-322.85095,-107.147415,721.9504,1138.7155,1918.0718,1824.1168,1186.4893,783.58673,746.45215,1048.3357,1961.2089,1720.1721,1749.8651,1812.7339,1645.2239,1945.8722,1594.7323,1621.5449,1658.1725,1727.1403,2562.1116,3169.4937,2997.0488,3048.044,3210.6155,3244.1025,2843.8857,2550.4355,2383.466,2148.7812,1982.6047,1737.8557,1320.7958,1415.7749,1303.3823,1092.5651,1199.1982,1165.9952,1294.7454,1137.8789,1114.7225,1084.4681,1074.3108,1117.8883,1667.6238,2328.0503,2268.3882,1456.8232,1448.3472,1474.3782,1497.1547,1490.6332,1719.9496,1572.5569,1572.7468,1583.0315,1578.6362,2436.2107,2116.4607,1817.9883,2144.842,2067.2349,1976.1719,1957.0568,2249.9634,2640.8,2407.072,2290.8677,2319.591,2354.4243,2403.475,2599.3997,2651.355,2546.4463,2657.2542,2725.581,3138.892,2968.2126,2898.5518,2973.0217,3117.0063,3208.843,3233.6218,3698.9985,3557.5764,3385.6328,3408.368,3470.9407,3467.1487,3504.0977,3588.2678,3573.4893,3523.3157,3455.9695,3692.6052,3688.2817,3412.126,3164.106,3733.0854,4017.6768,4094.3079,4600.6973,5359.926,5590.766,5612.5913,5344.089,4930.053,4740.812,5431.1963,5968.2056,5881.892,5481.982,4969.07,4794.287,4651.8384,4498.6973,4093.6113,3838.885,3358.5703,4199.913,4176.0854,4245.041,4509.7017,4483.421,4361.978,575.17474,-86.010506,-424.34134,-418.87704,-154.32018,607.55255,927.9686,1603.3417,1862.5706,1355.872,1226.8531,1042.356,1147.8809,1414.3533,1690.2732,1732.5432,2041.3777,2144.6562,2193.0657,1863.0233,1772.3734,1731.4213,1802.1425,2786.8276,3262.8882,3039.417,3156.6028,3171.9946,3091.6882,2839.4885,2630.6492,2391.0232,1926.545,1930.8269,1629.7407,1373.3851,1298.9028,1223.1349,1150.5009,1153.0731,1282.7335,1576.3036,1360.8202,1307.7166,1213.7766,1079.1823,1193.5332,1584.2451,2161.931,2353.7861,1655.9116,1340.5558,1484.651,1497.4432,1498.6794,1506.2524,1502.8159,1560.9783,1590.9834,1592.3546,1975.6233,1891.9756,1915.2673,1988.5586,2127.8232,2106.178,1968.1274,2112.3738,2317.0845,2300.336,2318.7566,2344.1946,2379.097,2421.0203,2493.5603,2523.2783,2616.0183,2708.5713,2861.7522,3020.1804,2922.7417,3125.7927,3175.8157,3154.4785,3199.8096,3241.2817,3300.1792,3348.4624,3426.8523,3509.4595,3522.5308,3564.0247,3580.363,3587.4802,3694.1191,3844.0544,3700.3323,3792.995,3588.428,3403.0173,3393.818,4185.163,4572.1187,4453.0415,4713.2666,4996.8916,5931.8687,5330.4434,5178.1357,5090.235,5244.7837,6375.613,6511.4414,6487.805,6224.5703,5121.4443,5108.851,4829.6855,4557.596,4015.6597,3788.8662,3647.2703,3829.2473,3640.5432,3700.838,4165.16,4152.8604,3893.9126,804.48517,174.18774,-208.34851,-180.02829,191.94609,1244.609,1511.7738,1641.8444,1710.0504,1427.6462,1337.91,1180.5006,1271.1678,1444.0442,2199.6523,2086.441,1899.7413,1943.2168,2183.6863,2815.4866,2485.127,2206.1458,2641.5188,3312.7866,2252.2537,2272.8066,2911.0476,2867.934,2750.8977,2376.821,2562.196,2507.9546,1881.8707,1613.257,1477.4188,1345.7614,1280.9907,1192.516,1189.8087,879.58124,1469.3348,1548.9557,1529.4589,1320.5016,1101.9604,1060.3593,1112.0154,1228.362,1360.886,1246.3511,1434.0632,1367.4325,1486.4066,1541.3319,1526.1752,1606.4469,1642.7924,1660.2965,1614.8097,1688.915,1862.2908,1841.2799,1854.1472,1845.0151,2016.713,1932.4581,1908.865,1986.3948,2233.3806,2269.8547,2315.9885,2352.6453,2396.0918,2440.3506,2495.578,2564.1528,2638.272,2695.129,2814.6443,2874.25,2938.3728,3682.967,3678.3276,3202.2095,3241.5544,3277.5981,3328.084,3369.6587,3512.018,3617.103,3616.7908,3642.4175,3673.182,3824.7837,3927.171,3924.6963,3860.9038,3872.748,3825.946,3729.7341,4295.9336,3041.2761,4228.583,4915.2627,5219.5557,5156.476,5964.8257,5320.6685,5431.0513,5545.955,6594.575,6915.9404,6800.077,6584.938,6002.577,5141.8726,4905.2803,4649.478,4226.4365,3871.9177,3709.0237,3667.7642,3666.0535,3616.2908,3577.9104,3635.5928,4104.386,3799.3203,443.16708,581.33777,346.80234,270.69604,853.8896,1786.7766,1462.6898,1371.7069,1857.064,1601.9602,1489.734,1599.413,1789.6846,1910.1228,2308.9302,2479.9507,2187.1848,2026.4823,2168.2085,2516.6997,2933.4104,2995.0703,3061.207,2805.951,2487.8718,2323.5923,2395.3154,2362.6118,2454.16,2289.3445,2345.305,2160.7722,1736.1886,1494.7292,1384.8589,1271.672,1246.3593,1217.2305,1285.6239,1001.0257,790.12726,1273.5424,1448.0752,1301.3417,1058.7484,1055.8947,1113.3013,1293.2191,1141.9153,1010.47546,1354.3394,1469.431,1513.9288,1472.8828,1507.8766,1743.6228,1856.0105,2159.2583,1804.3464,1747.5087,1790.1816,1848.6603,1869.1261,1904.3972,1946.9839,1949.388,1967.0436,2071.9521,2228.8523,2273.5613,2323.4194,2418.8572,2523.34,2459.8203,2520.0608,2588.3367,2654.6821,2738.3406,2823.039,2898.6433,2980.1697,3104.3748,3203.5732,3223.3982,3279.378,3329.231,3382.9626,3618.9807,4190.4585,4277.6826,3881.0596,3743.5427,3793.5193,3990.6333,3942.7449,3955.5537,4033.0269,4639.4644,4810.3667,4109.0107,4268.878,4030.0696,4566.6636,5058.8765,5460.843,5478.5264,5555.9165,5426.7314,5816.016,6137.1567,6372.8643,6503.342,6523.452,6447.5234,6016.17,5464.1055,4778.817,4432.716,4077.368,3850.3418,3778.2751,3809.802,4276.5356,3948.1306,3582.0251,3512.4182,3670.0513,3544.1125,1371.0331,1371.5098,1252.7957,1175.284,1028.9293,1529.1755,1092.8826,1115.6223,1696.0105,1542.229,1598.3563,1524.5737,1563.7988,2203.6062,2161.5667,2596.8447,2778.4238,2278.9746,2234.7397,2343.9194,2491.6084,2585.2998,2620.598,1931.0281,1623.67,1975.7039,1931.018,2052.0198,1948.2059,1376.379,1947.9578,1879.9583,1771.2964,1580.0643,1327.8344,1293.0404,1281.0873,1414.8966,1213.1614,1086.1086,439.38834,875.9919,1246.2041,1092.0543,1079.858,1074.4752,1323.5057,1610.7742,1113.4906,1106.4224,1533.6802,1825.4257,1626.7985,1484.6584,1519.5634,1657.7771,1571.3984,1862.675,2078.5176,1749.2231,1785.7687,1878.1833,1906.9742,1931.6384,1955.1565,2023.1995,2239.0002,2361.562,2229.8909,2263.111,2315.8547,2423.802,2502.3735,2487.969,2549.1326,2617.066,2663.422,2746.6675,2827.8755,2918.6611,2995.8718,3071.0017,3175.1694,3265.2937,3328.4302,3378.9692,3469.077,3681.5076,4601.1855,4616.972,3894.1443,3854.8118,3856.6177,3858.5698,3853.268,4057.8918,4304.411,4166.707,4443.3135,4179.968,4175.3145,4860.897,5127.709,4699.203,5000.0605,5363.3867,5577.8813,6068.5977,6019.4644,6273.113,6154.8755,6517.745,6359.2,6090.442,5924.9863,5413.573,4720.7373,4498.8716,4294.283,3940.9612,3832.3901,3836.701,4048.0093,3674.734,3504.007,3308.9805,3439.9753,3371.9475,558.8208,809.2979,1600.9712,1680.6893,1165.4174,1385.0724,1427.5256,1500.2272,1602.6406,1531.417,1642.2358,1614.6099,1496.9358,2145.996,2108.1887,2175.6997,2770.6296,2544.2966,2249.7502,2246.047,2306.1008,2399.3228,2343.2756,2079.3647,1958.0109,2052.0303,2057.4956,2033.6935,1990.838,1755.0702,1897.4314,1896.7611,2003.1224,2015.1648,1539.1228,1350.1309,1425.3118,1299.8684,1154.3589,1145.8887,1092.3474,1159.7112,1086.9685,1069.9075,1092.5627,1045.9106,1112.9403,1319.3622,1172.1749,1298.383,1834.9266,2161.9897,1608.6802,1434.3883,1418.0448,1625.1085,2046.4033,1818.2076,1915.9479,1341.129,1863.8047,1906.7302,1934.4884,1961.0302,1985.1847,2051.2795,2106.7021,2196.618,2193.1543,2237.2195,2285.0256,2354.8984,2425.9653,2496.9995,2572.1985,2663.2456,2724.7473,2790.6138,2894.834,2969.2732,3051.1318,3140.5742,3252.5398,3299.6414,3379.113,3518.0088,3530.3374,3665.0493,4170.273,4113.396,3908.876,3922.8567,3936.4749,4115.1987,4523.105,4166.4307,4265.2964,4590.4834,4688.3086,4045.699,4601.2915,5034.2295,4728.805,4556.8535,5033.746,6057.151,5919.7056,6237.4727,5931.5044,6554.1123,6690.63,6413.1763,6446.298,5805.359,5686.035,5329.007,4689.743,4990.639,4946.3115,4236.7095,3884.3806,3793.3562,3728.0208,3637.78,3539.3179,3450.9167,3398.6963,3321.8625,408.55225,436.40616,1196.1016,1205.6252,1134.8054,1408.6729,1607.9465,1419.3074,1451.0742,1545.504,1687.2073,2065.185,2166.838,2322.1797,2145.3123,2230.4858,2888.5198,2787.1519,2546.8357,2487.3843,2297.985,2307.627,2220.9163,2097.1582,2095.859,2191.9321,1943.5835,1633.4781,2058.8655,2037.5417,1753.494,1995.583,2059.7852,1747.9792,1604.2743,1439.9376,1874.8367,1292.1934,1212.445,1137.7169,1075.3688,1049.0208,1063.2761,1051.1432,1027.2817,1051.6349,1062.1179,1241.7416,1809.4312,1543.7837,1632.4163,1728.2356,1508.768,1444.9087,1504.6263,1888.9282,1982.615,1900.4133,1864.8547,1876.433,1935.48,1930.9569,1967.5022,2007.4329,2023.412,2058.4653,2127.8176,2177.0483,2219.2463,2264.8499,2291.7324,2331.1943,2387.3904,2460.354,2554.12,2630.9612,2705.614,2796.775,2816.1729,2748.6204,3138.891,3217.202,3323.158,3214.153,3339.7083,3597.5452,3601.1414,3685.078,3796.2942,3899.1692,3966.522,3987.2922,4020.557,4039.0127,4326.8486,4078.712,4379.0996,4481.297,3895.173,4042.8418,4461.917,4760.8623,4916.723,5141.5317,5172.884,5735.831,6004.9937,6153.444,5479.3364,6363.8037,6979.1597,6736.6333,6675.478,5802.2744,5454.4536,5058.4272,4697.111,4612.7036,4595.929,4220.2617,3901.9807,3812.4465,3709.765,3638.046,3558.5034,3473.703,3388.9443,3319.8083,497.5249,397.07483,1075.3385,1203.1935,1290.8628,1463.8252,1560.269,1346.9147,1500.4376,1581.4531,1768.1527,1899.5854,1720.3477,2627.176,2742.079,2961.8462,2710.5051,2663.4856,2186.3354,2114.2478,2552.906,2293.5989,2151.473,2160.8433,2209.9814,2412.89,1482.6519,1122.848,2097.0159,2247.3838,1092.7621,1668.8066,1997.4177,1208.8643,1503.0748,1343.5378,1803.5737,1330.2563,1420.6565,1863.3975,1331.4329,1091.6243,1033.3708,1073.7683,1051.0897,1038.092,1372.7373,1326.4409,2120.6335,1863.7142,1373.7279,1380.3676,1447.7979,1432.8899,1456.9862,1803.293,1826.6117,1834.4803,1912.8474,1913.538,1923.5009,1943.8416,1975.8134,2146.9243,2069.9597,2092.4165,2220.9724,2270.6858,2219.8486,2271.5022,2312.0144,2335.8445,2382.9927,2442.4265,2538.9014,2644.6255,2736.2512,2796.4163,2695.6514,2929.1892,3168.9614,3280.1646,3356.007,3469.4324,3555.0208,3597.472,3672.3157,3749.2756,3864.3264,3912.8245,3988.721,4050.3386,4094.6614,4117.146,4113.514,4137.08,4331.044,4433.7134,4099.431,4148.346,4573.608,5028.5264,5261.7827,5358.4155,5059.9604,5037.245,5833.6846,6144.755,6167.519,6559.803,6289.075,7163.29,6768.041,6001.6396,5353.226,4745.2,4532.8667,4453.792,4370.7983,4105.941,3911.5745,3816.1572,3738.437,3636.5913,3555.0745,3471.0835,3424.5967,3264.2634,457.44388,385.41757,794.9885,1307.2827,1688.5803,2174.0918,2210.0798,1774.7938,1613.0891,1614.1925,1794.8596,2281.6218,2399.813,2562.5415,2537.2476,2737.1643,2558.44,2267.6204,1011.27997,960.4721,2302.4705,2377.9133,2155.4678,2101.247,2176.1802,2283.1206,2403.6575,2287.3674,2365.5986,2270.5752,2141.2532,2163.421,1447.8145,1514.2229,1448.2308,1330.6335,1257.6332,1021.51245,1051.9779,1353.1057,1191.5504,1046.2351,1073.6942,1247.3582,1164.9143,1174.7999,1328.0631,1284.8226,1689.9695,2594.4807,1594.722,1371.5734,1414.3126,1413.7136,1428.8606,1536.9652,1729.7386,1885.242,2004.1556,1954.3602,1970.7207,1968.3851,2006.409,2193.3433,2118.7473,2123.3223,2176.2473,2266.789,2225.7915,2265.4631,2343.03,2388.653,2441.2266,2486.696,2572.4329,2685.3547,2785.216,2880.4019,3005.013,3193.7559,3246.669,3320.9514,3403.0132,3510.8572,3591.7336,3661.7534,3736.8174,3840.3594,3934.6267,4006.755,4049.1968,4108.071,4138.782,4170.203,4277.5635,4240.3984,4218.6343,4329.4717,4484.387,4537.3867,4953.238,5078.2476,5107.0024,5063.594,4932.6914,5326.9795,5724.8633,6377.078,6798.0405,6851.08,7114.5996,7664.1104,7057.343,6291.6855,5245.691,4676.9277,4484.5015,4368.4546,4330.6147,4080.2034,3935.0203,3836.2568,3767.8132,3658.6213,3565.629,3488.7705,3428.8843,3405.5413,466.15698,525.878,1064.0847,1374.797,1652.0719,3000.1477,2536.6594,2095.691,1792.952,1923.4242,1912.4294,2205.715,2281.0881,2398.814,2598.8662,2755.4487,2338.1572,1882.6305,1322.9457,1561.645,2791.3325,2387.725,2150.821,1997.1587,1983.7179,1995.0619,2114.085,2180.9653,2152.7017,2256.033,2298.3694,2057.4326,1866.55,1702.6235,1368.2814,1452.3641,1142.5775,1258.2355,1008.49396,900.00287,947.1313,977.87134,979.1758,1043.5138,1233.9996,1147.0266,1106.9858,1293.1674,2040.4144,3078.8145,1800.2289,1366.451,1410.2631,1420.7476,1425.2195,1448.1892,1434.0023,1828.0441,1951.7076,1981.3772,2002.6147,1983.674,1970.5254,2038.9565,2097.6064,2143.2615,2177.5862,2208.2915,2237.801,2276.8826,2344.908,2403.0466,2479.5662,2534.65,2602.8389,2702.1892,2831.1558,2920.4072,3208.1868,3213.8425,3276.3008,3345.159,3448.9255,3555.9497,3631.9556,3709.056,3791.2114,3913.7986,4033.9211,4112.3887,4183.556,4100.032,4224.18,4243.261,4404.5747,4375.086,4311.052,4618.9976,5184.9155,5065.3843,4823.845,4806.0977,4819.454,4797.447,4525.6816,5435.0073,6155.7437,6211.97,6509.323,6605.267,6999.3823,7695.57,7361.116,6296.49,5109.8276,4632.069,4481.8994,4343.53,4200.43,4075.2058,3959.888,3873.8281,3777.9167,3638.4944,3531.608,3424.187,3312.1963,3231.2285,887.4475,822.47894,1209.4938,1362.3508,1545.2264,2152.38,2044.3635,1918.1625,2025.1023,2005.0464,2133.52,2234.387,2292.6853,2322.5378,2746.9517,2781.6565,2102.7268,1899.4745,2321.8342,2834.982,2844.316,2540.003,2265.934,2045.2935,1957.8656,1895.1077,1926.5016,1983.8525,2069.386,2277.7944,2365.3057,1725.7648,1956.2039,1875.6407,1435.6978,1616.3442,1307.0641,1708.2966,1194.5562,905.4214,939.49585,922.7241,948.619,1084.875,1157.0774,1078.1168,1112.791,1285.1698,2531.6472,3016.1023,1827.935,1407.3955,1398.2839,1423.3076,1473.2593,1530.2122,1734.835,2062.575,1990.5121,2028.2437,2036.3158,2042.4994,2026.3231,2024.0248,2093.0178,2172.7869,2184.3552,2226.0168,2284.0327,2329.5144,2369.016,2419.145,2481.6365,2558.9932,2626.974,2709.16,2816.3435,2923.8958,3045.6526,3142.8508,3279.9219,3368.4038,3457.0889,3570.1384,3668.3606,3755.7505,3828.1697,3910.52,3996.8042,4137.9507,4253.212,4294.726,4331.7744,4350.454,4372.208,4406.734,4414.889,4650.374,5749.7554,5481.615,4318.3193,4435.1543,4535.8813,4408.8496,4331.8867,5105.5474,6109.341,6099.729,6632.054,7223.135,7264.5,7748.6,7384.74,6183.722,4997.332,4639.3413,4483.9424,4329.0776,4204.865,4095.3809,4002.6985,3891.3506,3723.2544,3589.8052,3483.667,3378.4531,3279.904,3179.8555,1034.7056,1078.751,936.82275,1431.3398,1424.7059,1650.052,1174.5138,1153.9072,2069.7485,2033.3518,2134.153,2322.0608,2369.9287,2436.943,2438.3298,2337.7656,1607.9727,1755.961,1867.0361,2569.6348,2607.5713,2439.938,2343.1978,2116.919,1797.295,1849.8873,1967.8347,1941.7087,1970.3926,2093.4128,2092.7537,1476.474,1334.4922,1567.4526,1472.447,1859.0745,1439.3219,1456.7966,1069.9155,916.81946,995.2727,951.40344,1043.372,1361.8014,1321.022,1114.0842,1064.713,1128.4589,1910.0098,2596.119,1557.4574,1381.5682,1499.2024,1990.7052,1953.3846,2021.5381,2032.5708,2069.618,2023.5377,2011.2047,2010.8169,2044.2115,2086.77,2098.0461,2117.741,2171.8293,2197.834,2254.0535,2312.241,2393.8208,2418.2866,2474.3845,2509.1235,2575.2542,2653.5696,2712.1433,2795.1497,2896.4436,3021.5876,3145.412,3275.7852,3403.536,3496.6885,3574.7239,3672.7073,3787.667,3877.3308,3965.8848,4078.659,4173.7554,4141.61,4202.893,4454.1626,4442.3696,4453.334,4478.401,4508.6255,4756.915,5673.3306,4988.873,4311.8623,4252.142,4302.973,4187.326,4406.025,5415.9185,5908.136,5947.854,5958.91,6542.3286,7830.4756,7814.1016,7203.0903,6274.9194,5030.132,4642.76,4485.141,4328.025,4221.44,4117.4116,4006.7444,3854.3367,3724.0503,3583.7078,3463.7712,3368.9622,3294.8386,3178.3074,1094.3851,1229.9103,1027.4099,1463.0253,1381.8838,1359.3971,1569.2261,1744.1913,1285.0824,1225.4974,2234.1973,1963.8501,2287.7668,2324.9136,2411.3428,1888.2473,1676.8519,1572.8203,1655.7694,2243.243,2584.8396,2264.3237,2337.9763,2019.3127,1781.2715,1780.7556,1942.4226,2101.1155,1859.3743,1956.9077,1893.4603,1571.1807,909.5822,1149.7374,1342.4933,2108.5266,1909.5256,1470.9122,1329.3885,932.939,978.4704,1004.645,1144.4797,1543.0043,1444.5088,1154.6786,924.135,1115.0585,1744.2983,2447.1074,1620.8864,1489.6934,1684.6451,1992.4971,1870.0728,2006.5542,2522.8489,2122.6362,2045.1943,2023.705,2011.9694,2060.5337,2128.762,2186.2249,2175.4934,2183.4885,2219.0203,2294.6057,2404.0276,2480.1912,2515.6064,2543.594,2564.1697,2605.9614,2675.474,2728.1501,2804.1948,2925.8723,3042.9495,3173.4236,3345.0007,3456.1514,3542.2122,3647.5774,3755.748,3885.4844,3992.7627,4074.1428,4193.6865,4254.0044,4337.6772,4874.748,4660.658,4510.144,4538.3096,4565.747,4627.446,4805.5513,4855.321,4565.651,4333.7646,4284.5757,4394.281,4342.7295,4973.4385,5798.9756,5618.1504,5893.007,5854.3477,6016.087,6534.2095,6462.7036,6141.1104,5373.317,4856.753,4665.7417,4502.558,4342.5244,4216.501,4111.501,3995.1033,3832.0435,3696.5037,3580.0703,3488.2935,3394.3542,3284.1128,3179.8513,1233.8951,1396.2931,917.58185,1281.1807,1263.5137,1244.4641,1268.6365,1411.707,1377.3412,1369.7251,1973.3774,1950.8473,2129.5996,2001.3522,1976.3601,1679.6968,1512.4617,1412.6844,1705.3468,1600.6395,1462.6758,1414.8188,1980.0034,1788.7855,1591.9465,1551.516,1396.581,1636.781,1786.9147,1923.0765,1643.4182,1341.0898,995.52545,984.7277,1077.177,1693.704,1423.5105,1352.7625,1620.4248,1111.5146,917.5118,1085.1964,1303.7523,1434.8456,1261.5487,1239.0494,1097.1732,1233.7327,1563.8396,2322.4482,1876.3833,1729.4172,1461.9176,1461.095,1499.1892,1468.1313,2217.3506,2205.3962,2070.1055,2044.1342,2044.8611,2088.8823,2135.1194,2193.3208,2232.8477,2233.4214,2240.6848,2301.6907,2406.8052,2512.9814,2567.3154,2616.9944,2637.742,2675.3606,2736.0166,2792.7764,2845.8892,2967.0645,3111.947,3185.3906,3402.3342,3524.7297,3642.0603,3758.203,3878.3276,3968.1301,4083.8206,4161.575,4261.666,4346.0156,4382.3057,4537.844,4588.5107,4584.614,4645.576,4648.134,4704.903,4747.5396,4715.203,4537.212,4362.699,4521.493,4889.614,4980.5195,5170.237,6011.3477,5703.876,5834.508,5857.2847,5754.5117,5678.003,5494.6685,5310.7095,5079.2954,4886.138,4708.6025,4533.4375,4366.927,4240.3394,4104.037,3944.1016,3807.1775,3716.281,3612.9978,3518.4685,3431.145,3314.9202,3203.946,755.5415,1158.1986,1501.8635,1673.6973,1079.6162,1165.404,1184.1456,1199.657,1433.6321,1604.8959,1678.949,1354.9357,1962.2783,1918.3734,1846.8278,1536.4424,1380.8495,1435.7034,1525.5662,1208.6412,1068.4873,1122.4735,1306.3263,1702.6442,1436.3949,1384.2861,1357.9045,1225.3947,1476.1631,1901.8657,1285.6603,1101.1819,975.2373,952.7472,786.089,1225.532,1142.4913,1125.3716,1331.1779,1230.73,876.4031,1029.2551,1245.4187,1232.707,1194.9689,1149.1857,1239.978,1488.6365,1504.5022,1669.7568,1818.3353,1832.6906,1550.4714,1327.1886,1453.0378,1806.1218,2162.439,2152.6323,2094.454,2063.804,2074.2598,2129.6924,2146.3047,2185.214,2246.675,2293.7551,2293.3665,2253.655,2426.7583,2532.2932,2606.1643,2670.74,2726.238,2769.414,2815.0833,2880.7537,2925.1062,2978.9072,3107.289,3261.1604,3403.074,3632.7366,3744.9722,3840.3833,3883.4287,4053.953,4160.8057,4261.062,4350.7466,4433.16,4518.191,4605.1025,4653.9863,4686.342,4771.245,4718.9863,4788.248,4819.298,4834.266,5183.6914,4849.2744,4916.7583,5202.7734,5178.863,4724.454,5261.17,5699.102,5883.471,5909.7812,5803.819,5647.996,5461.298,5293.1577,5091.064,4955.787,4763.151,4575.8022,4413.022,4271.257,4097.1304,3931.9954,3794.1812,3697.5664,3630.4465,3549.0522,3465.186,3389.4517,3259.7236,1080.138,1122.1626,947.76935,1128.4487,1035.4791,1089.7356,1072.743,1029.6951,1400.5941,1574.018,1632.9481,1635.05,1861.0684,1653.6122,1596.5093,1444.1232,1273.3456,1280.3827,1452.3295,1261.7689,1015.01544,1068.1433,1441.768,1401.226,1245.1193,1184.5084,1297.0972,1156.1007,1148.8773,1599.2028,1274.4158,953.6255,847.4087,933.2925,1097.384,991.3665,1156.2897,1081.9652,1313.7267,1349.8159,746.8783,787.1192,917.95593,1120.89,1162.7766,1248.0725,1306.0765,1410.5226,1839.4329,1946.3689,1484.6271,1817.4363,1945.6467,1531.4402,1576.4977,1835.8589,1260.4751,1896.0115,2102.439,2084.8958,2113.3972,2136.9817,2164.662,2195.2227,2245.939,2319.8792,2357.982,2403.4778,2469.4436,2566.478,2633.7202,2694.006,2783.6272,2855.908,2917.2227,2999.9211,3083.241,3136.141,3231.4778,3385.3774,3532.1604,3705.2075,3832.5322,3965.6372,3913.815,4126.2812,4232.2173,4406.936,4467.715,4504.1235,4616.2603,4784.7935,4750.1016,4781.783,4843.179,4807.4243,4986.6577,4907.8555,4959.5063,5331.13,4968.453,5071.351,5102.923,4807.2344,4419.953,4835.2056,5926.0527,5919.4937,5920.551,5805.0166,5664.665,5499.646,5328.4697,5152.0737,4981.9087,4785.6924,4600.9663,4416.7075,4231.453,4067.4683,3942.9822,3832.0762,3754.476,3696.7805,3631.1409,3535.1838,3452.4324,3387.5234,967.831,808.73737,825.0349,867.05646,973.36316,1081.4501,1328.7035,1416.2203,1478.4673,1559.5706,1527.6652,1587.5956,1641.4282,1562.8104,1196.3292,1375.3783,1223.7931,1132.2495,1173.2925,1358.8373,1264.7058,1368.0461,1293.8586,1119.8362,992.769,1004.9014,1093.9119,1137.0442,853.2597,1204.9451,1125.8013,866.7274,803.2623,950.82196,557.25476,194.38539,255.09253,1020.5537,1928.5717,1882.7667,764.6609,706.30945,748.48517,791.13684,1217.2446,1541.2905,1379.7668,1234.539,2432.3137,2616.1113,1107.3334,1291.9767,1712.335,1644.3726,1673.6721,1704.7705,1501.1432,1987.8324,2118.2126,2104.7134,2151.2117,2168.358,2179.9404,2212.2224,2262.7856,2303.8525,2352.156,2404.514,2487.3909,2593.4438,2672.7493,2734.9314,2818.9617,2913.7646,2999.1692,3069.7146,3196.8438,3308.0244,3418.9338,3538.0845,3670.9102,3818.0835,3959.3538,4037.1953,4144.6436,4222.148,4337.671,4505.51,4613.92,4660.7134,4718.0156,4810.247,4874.1504,4901.3164,4920.807,4907.837,5289.666,4970.6963,4929.351,4912.6606,4861.5786,5186.1953,5436.331,4773.942,4436.5933,4973.09,6011.733,5959.342,5913.321,5838.297,5695.2896,5560.5737,5398.2847,5209.574,4995.903,4807.2974,4588.9097,4378.495,4242.4233,4117.229,4001.8965,3910.6978,3852.362,3786.3352,3694.4822,3602.9133,3529.1187,3445.8374,608.73114,508.46246,879.3393,850.38245,995.9689,1102.8203,1542.1249,1631.7273,1717.1417,1531.7092,1459.5731,1629.4224,1566.1172,1572.2207,1329.9998,1377.676,1214.9078,1121.8898,1096.742,1070.6615,1067.8772,1090.0516,875.929,842.40924,762.27124,737.98376,702.34973,774.20154,744.0184,767.21375,1000.9508,816.5835,806.36414,941.08704,328.68164,123.60756,73.886055,713.60114,2093.532,2001.9507,787.44,694.2541,678.3594,654.744,862.5189,1849.8406,1916.7026,1122.0093,1595.7611,3012.4722,1664.5326,1172.5928,1591.087,2373.6418,1823.1661,1721.5907,1720.7084,2079.789,2568.2622,2160.5188,2151.5051,2162.7974,2191.4368,2212.6758,2243.9988,2281.77,2353.7585,2404.319,2495.6997,2614.8203,2698.7766,2809.4885,2885.8003,2954.51,3044.445,3159.6853,3254.0872,3412.2585,3549.1125,3656.0764,3766.6863,3918.6716,4040.2937,4105.1733,4230.813,4352.6255,4482.703,4600.247,4729.982,4818.9775,4863.548,4933.2837,5033.3857,5106.22,5021.0933,4983.892,5032.026,5008.2837,4942.795,4920.951,5046.448,5294.021,5851.865,4864.035,4505.2397,5581.1436,6058.142,6034.676,5919.992,5854.432,5716.9604,5586.4707,5424.5176,5232.4824,5014.406,4824.1704,4592.965,4455.579,4337.7603,4191.0005,4097.193,4019.483,3933.6753,3828.3354,3737.163,3691.8494,3608.8755,3544.7332,1079.8961,946.43134,887.466,880.84784,1061.6268,1314.014,1638.8955,1745.6816,1555.0261,1365.5216,1052.5841,1242.1091,1595.6245,1652.0681,1539.9148,1440.1934,1357.7633,1266.028,1264.6638,1138.3977,625.6885,732.8891,745.07056,769.2831,767.8889,708.84515,624.22546,576.5888,670.0056,683.68115,867.4509,749.1887,773.1535,831.31696,762.142,437.56418,499.75815,556.79706,1164.0476,1198.3832,778.03625,692.8714,676.7684,701.9872,974.8175,1313.5548,1542.4358,1097.2166,1127.0348,2206.2336,1704.1514,1513.8408,1496.01,1860.0753,2024.5535,1785.901,1772.9174,1649.284,2125.8376,2175.2031,2173.6558,2187.5771,2229.6213,2262.1367,2291.081,2345.885,2393.687,2445.5679,2499.7417,2603.2698,2714.8362,2821.3516,2933.1865,3042.8733,3100.533,3209.8555,3345.6245,3505.8376,3656.943,3802.482,3912.8806,4056.4976,4195.961,4300.909,4410.2593,4505.545,4628.4893,4753.7197,4855.6406,4973.147,5039.826,5083.003,5132.7144,5261.0063,5142.386,5110.864,5131.6094,5085.086,4972.64,4973.5713,5442.467,5538.021,5821.2144,5002.329,4545.126,6033.9355,6151.749,6111.03,5999.654,5857.237,5725.8804,5585.3276,5413.7695,5199.736,5007.065,4836.346,4658.9097,4496.3965,4384.097,4292.941,4240.7812,4167.6143,4068.6482,3943.9495,3824.7568,3743.2603,3690.5625,3615.099,962.93286,957.83685,1114.8085,934.0393,1005.64264,1478.3762,1524.9266,1494.4536,1408.9661,1456.5083,1423.3549,1439.9581,1495.0675,1518.6672,1448.7568,1657.8093,1622.049,1567.0193,1539.8834,1031.5186,442.4669,568.0416,1143.1837,926.39075,707.23663,655.3628,844.1289,573.6808,323.66336,306.3993,848.7037,738.22327,749.28735,730.75696,800.94147,844.98303,722.62573,479.4361,710.4215,807.59814,973.49023,716.9328,670.8479,714.9349,1148.6123,1097.7909,1133.5118,1170.4393,1302.8113,1603.2349,1553.3367,1549.6453,1570.3156,1562.1625,1879.8683,1930.3334,1865.4525,1995.2719,2143.7317,2122.5222,2008.6698,2223.8755,2252.363,2294.7124,2339.5413,2423.086,2468.9104,2495.691,2514.5823,2590.513,2738.6995,2855.1865,2966.63,3111.933,3191.5105,3286.0396,3466.034,3626.7163,3782.4182,3949.1025,4104.1143,4220.2695,4371.807,4514.4536,4598.011,4690.5386,4789.0737,4922.015,5031.073,5154.843,5228.569,5252.154,5269.087,5290.988,5283.6978,5242.643,5211.084,5163.7026,5060.562,5046.375,5707.4146,5479.8677,5109.564,5278.4023,5102.9473,6238.312,6266.8774,6207.081,6050.0625,5845.7715,5732.912,5548.03,5385.931,5213.084,5026.225,4876.635,4691.3633,4595.8906,4507.7876,4438.0405,4367.0337,4279.039,4175.4917,4067.8574,3945.327,3818.8784,3739.7373,3670.965,1079.1514,1095.6935,1204.3845,1106.1053,1439.2716,1594.1871,1458.6432,1416.3153,1457.579,1458.3186,1468.2715,1493.8776,1500.2368,1497.055,1503.3604,1178.6519,1051.15,1014.0272,1150.4711,531.6056,192.65514,391.5762,600.5829,283.91495,118.94109,387.69095,849.947,1033.5619,939.19995,1019.20905,1013.7632,827.9584,795.65063,690.261,722.4911,727.14496,871.8573,957.6416,883.6009,806.134,697.486,653.573,666.7518,669.15594,1028.1335,1196.0759,1122.7981,1220.4683,1552.9794,1529.1111,1548.0443,1577.0093,1604.5503,1676.8319,1788.798,1820.4944,1831.6847,2091.7273,2199.9224,2200.2507,2171.1719,2254.418,2290.2463,2217.0227,2388.1707,2438.8594,2491.2346,2554.4575,2622.793,2683.2285,2787.6895,2879.1533,2989.8374,3139.532,3284.3108,3408.5903,3570.6626,3772.1174,3949.68,4138.79,4307.203,4450.4004,4572.7505,4688.488,4802.9873,4892.3105,4962.288,5098.133,5202.162,5299.87,5383.0376,5433.5225,5450.438,5452.2046,5426.055,5351.6006,5288.163,5292.047,5293.3237,5577.0586,6160.1636,6003.882,5563.756,5551.9517,5780.618,6298.2935,6331.192,6295.92,6084.7334,5843.363,5685.844,5513.967,5356.234,5246.729,5106.707,4935.9253,4797.871,4707.872,4598.235,4527.2827,4450.1577,4363.469,4268.848,4180.959,4069.3472,3963.3625,3868.5898,3807.973,1436.6232,1363.8165,1440.1311,1487.7192,1600.6213,1576.4515,1556.9943,1534.7245,1341.3866,1562.587,1594.1204,1581.4355,1476.7832,1592.5161,1201.1149,981.358,943.18854,835.3807,670.8903,192.74489,39.888905,253.18582,-90.96267,-6.078984,66.45189,291.25256,636.1253,1100.8832,453.6918,31.96435,417.5292,908.38257,748.80554,735.7141,658.0989,572.0815,659.8787,1245.3212,1449.5646,647.146,655.62933,611.94104,646.921,654.54626,936.6573,1945.6157,1316.7123,1209.8348,1339.542,1481.293,1549.4117,1594.4464,1640.4268,1710.4962,1778.8787,1838.0621,1885.9022,2099.6125,2233.9783,2263.2224,2289.4841,2320.1465,2379.763,2436.108,2482.6162,2507.0195,2539.3071,2656.8867,2751.0364,2774.6885,2850.0452,2953.7192,3057.4692,3216.6716,3349.9375,3513.4714,3717.8657,3936.92,4161.046,4361.9673,4530.1987,4680.2725,4823.2715,4936.9316,5036.0444,5133.5835,5209.2607,5310.831,5409.1147,5473.683,5548.6167,5565.27,5608.618,5604.7314,5558.0337,5485.9487,5433.4595,5386.847,5515.0273,6107.4272,6536.057,6046.455,5990.79,5916.053,6182.5903,6373.8247,6416.3877,6355.7515,6138.884,5844.9424,5698.1274,5577.155,5462.872,5369.5444,5224.2124,5089.251,4967.8413,4855.158,4718.3813,4658.893,4580.9663,4501.096,4429.2344,4362.866,4261.0103,4136.579,4043.1516,3947.7307,1742.9727,1232.8671,1295.7465,1556.6343,1538.562,1568.1112,1665.4999,1655.9211,1691.6056,1752.6407,1770.5674,1545.1455,1176.4794,1490.5765,1106.853,969.46094,909.68567,807.63043,275.14142,-29.125193,-158.44739,85.874016,-104.00256,-106.47558,-10.351605,208.75891,466.2841,828.8129,281.9738,-369.92868,-23.457605,978.65045,747.606,755.9452,916.1725,694.58624,542.3138,689.8936,1729.4883,740.80444,552.46796,554.1339,721.8308,739.3528,918.72174,1371.4768,1877.4789,1238.1841,1240.6466,1321.0662,1472.0206,1588.8983,1628.185,1689.9725,1762.9954,1846.5076,1963.5209,2048.6047,2226.1003,2306.2717,2342.1885,2381.2554,2440.7178,2484.9656,2544.4949,2627.1682,2631.7295,2687.6729,2805.9705,2910.5884,2960.5237,3036.152,3166.1753,3295.4055,3448.0208,3631.3882,3861.6873,4079.3982,4363.6895,4623.361,4813.6973,4963.1553,5102.8574,5236.857,5310.151,5398.002,5490.4604,5587.2725,5612.1406,5631.0127,5684.6895,5764.097,5780.5947,5713.7383,5652.5327,5588.5723,5532.7896,5430.4824,5812.6245,6519.086,7092.515,5960.9907,5821.1343,6038.3955,6297.7183,6381.63,6424.0615,6367.7944,6179.946,5964.1245,5835.331,5737.023,5665.0825,5524.767,5395.9087,5273.153,5177.745,5058.958,4931.806,4856.1436,4769.4917,4714.7695,4566.463,4491.773,4374.628,4301.749,4195.8926,4076.607,1871.9062,2046.0695,1789.256,1647.3651,1614.5266,1559.753,1701.1567,1339.3223,1602.488,1675.3015,1537.3782,1353.3226,1339.9415,1281.5077,1165.3352,1067.7362,1045.2458,514.93097,-132.23848,-271.39612,-627.7991,-819.99304,-705.97546,-223.9463,-80.917145,77.416214,281.81644,523.1232,725.40576,244.14667,321.99265,1057.9886,957.319,869.7238,897.2154,915.7879,976.27435,761.61194,1421.0917,776.0738,465.4344,464.7997,648.1686,688.1488,573.2124,705.64734,1792.8685,1395.3151,1211.0658,1281.5737,1469.9463,1760.5754,1636.3345,1741.2489,1831.545,1900.5684,1968.629,2044.6093,2121.7422,2185.4055,2283.904,2340.5586,2403.4272,2460.4832,2580.9924,2696.9011,2773.738,2785.011,2872.2668,2983.057,3089.5198,3146.351,3274.9841,3371.8743,3551.4536,3755.2197,4008.7717,4269.7153,4561.814,4879.8916,5104.8687,5262.756,5390.7114,5516.9053,5613.494,5677.7227,5758.468,5827.4473,5805.359,5816.221,5868.1343,5902.6904,5868.777,5797.7114,5755.0015,5661.939,5590.164,5609.287,6325.28,6995.097,7593.1216,5986.2524,5875.023,6069.2554,6337.467,6399.2666,6440.675,6399.0586,6187.669,6036.3784,6000.6313,5902.5864,5897.9067,5776.3105,5666.038,5478.467,5394.241,5233.8354,5154.513,5064.947,4978.3574,4896.4185,4756.5244,4661.9043,4552.1504,4419.1807,4312.956,4190.1533,830.4338,1668.491,1952.5417,1763.1681,1670.6583,1587.7147,1721.0292,1253.9961,1708.2107,1577.3578,1469.2562,1408.9318,1269.8978,1261.71,1108.1328,785.1159,526.06116,61.703373,-441.2996,-466.8381,-551.8081,-924.19934,-907.3334,-160.7765,-112.121086,-0.122915,135.65903,371.10947,665.808,981.21326,771.30634,337.60907,835.19055,947.3701,991.7099,1510.8389,1467.1687,1092.6974,1044.4292,714.126,500.11807,389.73602,308.6561,823.95154,1678.9639,1156.9119,1025.9631,1255.1908,1099.9672,1232.3794,1459.5018,1509.7239,1691.9231,1788.9595,1829.1069,1867.1823,1947.8744,2008.1912,2034.3909,2163.2214,2252.881,2353.2805,2421.6482,2496.1833,2600.287,2730.8103,2866.2998,2902.3196,2942.6917,3041.98,3139.973,3223.7878,3367.8718,3520.7336,3666.496,3923.8835,4208.775,4527.918,4845.353,5137.3706,5399.356,5542.7295,5698.5854,5794.081,5903.332,5979.0947,6017.096,6052.852,6027.8433,6034.0923,6066.6367,6005.526,5933.9194,5883.866,5840.691,5744.5146,5697.793,6022.8784,6905.2964,7382.5693,7449.7837,6445.4937,6147.0625,6314.681,6312.376,6396.5054,6418.24,6369.1943,6254.7266,6185.7373,6247.12,6139.7314,6081.56,5966.409,5866.3247,5741.6484,5589.965,5468.904,5364.755,5276.7124,5152.3594,5065.262,4962.634,4858.0728,4735.0103,4584.8843,4427.5767,4308.787,1844.578,2221.1763,2003.318,1857.3575,1699.7141,1758.3605,1704.303,1643.0099,1523.9948,1356.1687,1414.1122,1215.863,1339.0068,1314.6599,1172.8223,861.00433,332.42102,-55.042458,-537.0892,-594.76996,-298.80765,-538.43396,-365.04105,-95.01111,-124.69422,-14.489316,-47.473747,147.05626,327.0667,567.4883,589.88586,560.1172,684.0531,730.3006,791.087,997.01117,1287.5359,1277.8146,1143.9423,684.2827,516.449,183.39471,5.689976,598.54974,2579.099,1160.543,953.3786,991.81555,992.7386,1095.6438,1312.9746,1407.0563,1683.5334,1770.4224,1789.5834,1841.3639,1920.8354,2023.913,2085.8635,2172.2114,2289.8318,2419.7576,2530.6284,2592.862,2712.3555,2813.1543,2894.3286,2977.525,3050.7754,3134.3713,3260.9893,3339.4104,3478.6255,3624.323,3832.0864,4117.443,4461.1567,4849.926,5230.611,5489.905,5727.733,5881.136,6046.1113,6167.774,6246.8125,6278.272,6277.204,6260.6772,6238.009,6211.7446,6174.5093,6091.7095,6020.6304,5947.5527,5912.471,5826.4814,5882.2393,6517.7383,7166.899,7335.143,7004.137,6902.6313,6580.7915,6417.992,6347.8784,6373.6714,6344.8975,6344.3105,6376.3457,6424.706,6414.3,6380.164,6285.281,6239.904,6181.2173,6068.2954,5870.554,5769.772,5625.899,5506.61,5384.905,5291.306,5178.016,5079.7627,4925.1943,4710.99,4532.5493,4399.01,1774.6028,1458.3846,1673.5625,1758.8269,1865.3777,1764.9503,1830.5236,1782.2395,1360.818,1322.6007,1345.3983,1352.4152,1242.6249,1214.9677,943.12024,713.2887,368.50504,39.234417,-448.11432,-755.3981,-485.87262,-1.06181,-99.752785,-177.976,-100.62973,10.975222,-112.77295,70.95339,241.98221,254.9698,440.11,479.72794,645.6474,604.5696,654.1723,879.64307,1457.7332,1120.7987,-278.6447,644.73206,473.20172,-24.209774,-70.80864,417.43265,2759.5857,1565.3137,941.026,894.1851,934.3104,1050.9462,1248.7799,1372.0713,1701.438,2009.086,1879.2264,1859.9489,1945.3413,2040.8619,2102.128,2180.582,2295.5188,2516.7625,2618.554,2717.5234,2831.7664,2914.5076,2988.2131,3080.0925,3154.5198,3269.6313,3382.1848,3504.736,3612.436,3792.676,4014.0984,4354.99,4769.4033,5211.8325,5584.9253,5835.063,6075.1255,6263.2974,6488.1753,6633.151,6627.8315,6573.767,6513.285,6465.113,6423.3994,6347.153,6261.7915,6205.954,6160.7803,6078.265,5981.384,5907.045,6037.35,6733.2446,7172.221,7133.3955,6839.643,6809.349,6619.7354,6453.59,6349.461,6290.521,6251.3384,6333.4404,6501.343,6587.6133,6613.7134,6651.094,6591.2305,6590.182,6451.595,6281.3145,6128.44,5964.403,5824.0796,5700.037,5556.134,5437.595,5374.5303,5253.896,5054.211,4849.9824,4688.3154,4569.4375,1038.0111,1638.2957,2098.1013,1606.8857,1498.6995,1408.2072,1218.8997,1409.7972,1217.5747,1225.9158,1350.4353,1197.7565,1230.6637,1062.26,650.4399,746.30743,530.0834,239.43654,-160.86664,-721.54974,-589.77124,-166.25677,-41.477158,-73.74838,-50.843384,49.623432,-139.25333,46.025387,153.30788,304.4223,335.4936,88.153114,517.63495,624.6036,738.0305,984.3071,1111.0344,1041.9113,666.6579,1026.0796,476.6172,-60.205368,-4.389782,211.74132,2254.806,2120.3625,928.5827,866.10266,886.06085,954.5235,1096.7771,1304.3578,1705.693,1774.6093,1798.7451,1873.349,1936.8564,2012.5479,2108.1228,2189.8845,2324.341,2559.0022,2672.1865,2746.62,2736.353,2800.947,2924.845,3061.2373,3162.356,3292.2686,3462.676,3638.6743,3795.0786,3986.694,4254.812,4577.633,5074.1934,5586.201,5944.3306,6241.3164,6520.8223,6744.813,6965.821,7083.172,7019.368,6885.8687,6764.196,6667.6943,6556.131,6474.11,6397.878,6365.289,6312.063,6183.9634,6066.5327,6032.9844,6015.8486,6627.6797,7313.685,7057.096,6601.033,6403.982,6384.6855,6296.6616,6195.062,6156.5654,6205.916,6358.1035,6592.077,6706.3096,6778.5225,6832.463,6862.8755,6887.594,6668.505,6535.4893,6302.837,6135.243,6026.547,5846.5327,5701.144,5628.5493,5502.2725,5357.272,5170.3594,4983.3223,4821.199,4696.481,583.40234,1673.2827,2094.53,2123.157,1315.6833,1076.3088,923.11505,1012.3554,1059.6871,1231.0021,1358.8081,935.60455,778.50433,676.7841,638.1716,494.81662,-63.37402,-358.43927,-934.30865,-586.685,-619.97406,-301.87393,107.781,234.42809,87.336586,102.7055,15.531228,99.83158,-41.979504,238.13799,312.09036,506.77982,708.246,647.05945,742.8437,800.1256,745.1084,839.3115,939.70764,897.9806,459.1475,-60.678448,-19.407286,39.72122,725.3095,2131.2935,988.97345,860.3654,861.70624,912.9081,978.9315,986.60736,1624.9302,1844.8256,1840.1172,1900.5685,1919.8119,1992.4161,2091.368,2180.895,2348.3477,2484.5474,2609.6995,2653.9255,2692.9893,2811.2893,2949.4033,3138.2483,3264.62,3383.9055,3504.9858,3715.956,3933.5466,4175.427,4523.383,4880.783,5391.367,5934.062,6422.169,6808.9736,7152.9834,7430.315,7610.7373,7622.2744,7468.6484,7260.1387,7025.9287,6837.28,6688.2827,6596.939,6559.024,6498.8594,6419.307,6306.7637,6182.375,6129.018,6063.3,6301.8706,7044.3936,6781.567,6030.8613,6031.1567,6052.037,6040.659,5991.138,6017.437,6198.301,6429.94,6667.22,6810.5874,6858.3594,6980.519,7057.7803,7079.627,6906.4897,6696.877,6457.6357,6308.5474,6158.8555,6003.729,5906.61,5810.497,5684.124,5508.941,5311.076,5150.8965,4964.533,4801.227,188.09612,544.18756,-205.98425,1422.1171,1603.6547,961.0069,758.65314,1163.9789,1383.7874,1434.0297,1230.4844,718.86145,457.02618,407.30518,292.57852,202.69144,-83.8345,-607.62054,-1931.5381,-750.4144,-576.949,-312.78104,-185.4779,80.67093,113.81308,-27.827211,-38.775806,71.06398,2.224473,189.52397,292.0965,465.76785,66.202194,522.1579,905.46747,799.1645,602.282,602.5291,742.6311,744.01544,405.68152,-33.477726,-67.86162,18.219288,170.85132,1080.8016,1402.9572,866.20135,873.845,873.2908,874.16315,-1.130254,683.82654,1420.8706,1482.7654,1639.1796,1828.9312,1955.5859,2089.1123,2209.3718,2358.1816,2457.3281,2566.5857,2649.9033,2754.1611,2888.385,3001.93,3162.3958,3284.1953,3432.2886,3641.5413,3862.8853,4125.6226,4385.89,4732.3315,5170.7603,5688.4736,6398.1904,7107.2983,7744.137,8183.9136,8401.132,8466.528,8387.115,8161.784,7773.1167,7362.0537,7099.7085,6845.721,6740.5337,6700.459,6624.289,6542.394,6431.5195,6293.683,6231.2354,6215.62,6370.798,6623.487,6124.556,5735.3057,5884.2295,5974.7617,5835.751,5818.661,5832.0786,6257.966,6515.9805,6739.432,6876.822,6940.1626,7118.4146,7260.842,7199.9287,7149.029,6827.1196,6588.1816,6448.864,6286.851,6171.086,6035.901,5938.934,5801.9243,5642.651,5462.2163,5291.264,5097.2173,4904.44,79.21689,-98.21524,49.61713,679.3338,1353.6418,726.7917,939.9921,1263.404,1231.7838,1191.0793,934.13556,647.3153,354.75815,260.7308,102.78279,-16.128214,-143.9171,-268.94,-731.33093,-1019.74005,-1004.4329,-683.5483,-661.112,-553.463,-534.0021,-346.61008,-377.73737,-316.17175,-109.52221,-56.24437,178.33102,-138.71143,-703.92993,-263.92755,870.2989,110.81572,363.0507,406.12552,444.2618,430.29376,294.99915,-84.80567,-43.539635,49.591644,153.5556,799.5478,1614.3231,870.33923,844.57806,882.6164,955.6455,1001.6136,1169.2911,1304.1199,1458.0828,1591.4513,1713.505,1878.9846,2016.3462,2179.2048,2329.5562,2460.3523,2553.8896,2650.251,2766.9148,2875.9744,3008.601,3115.7446,3254.0132,3432.8293,3667.476,3931.559,4206.2534,4503.6963,4872.369,5341.226,5922.1567,6851.253,7831.7065,8683.719,9211.024,9468.242,9514.257,9360.35,8894.515,8257.801,7725.667,7309.0845,7029.001,6892.878,6808.7354,6727.531,6655.8174,6563.6367,6425.5693,6358.762,6474.5815,6559.8984,6058.5293,5843.7456,5832.3413,5988.68,6100.7466,6097.2905,5954.6523,5890.7676,6374.0244,6612.7876,6736.3735,6857.724,6903.322,7070.8623,7257.6143,7346.6094,7131.0444,6849.43,6641.173,6303.7554,6416.016,6394.5015,6221.132,6076.265,5933.4365,5751.575,5565.867,5389.4243,5188.942,4973.3853,117.03574,351.02213,300.17664,368.9728,651.07764,657.02136,643.3177,229.7839,1141.0005,819.1137,618.6533,718.78534,348.39594,187.8135,-17.057291,-40.98052,-300.486,-491.679,-790.09985,-1145.5586,-1186.0721,-717.837,-839.05817,-682.9202,-718.81775,-828.90186,-747.64276,-355.35617,-366.50558,-493.7861,-19.366636,-18.089678,-445.72528,59.197063,621.0539,270.36288,280.3073,196.65132,233.0348,239.59453,173.90642,-126.673904,13.735789,111.29174,147.7963,579.7939,1130.7772,821.2301,881.1327,876.20264,943.18646,1039.8782,1141.5496,1260.9634,1458.8118,1578.9889,1713.2152,1826.8348,1985.4215,2124.917,2272.955,2384.169,2495.178,2581.35,2707.8079,2833.316,2965.4514,3121.3005,3307.1665,3512.1538,3702.186,3974.7598,4288.451,4615.4844,4957.339,5478.6553,6234.0684,7225.047,8498.087,9344.232,9856.495,10191.47,10312.814,10077.483,9482.189,8684.742,8025.5327,7496.4224,7203.4507,7016.854,6871.8135,6791.717,6737.603,6681.963,6638.854,6620.5947,6735.6484,6389.815,5865.9766,5801.2695,5974.714,6081.3438,6145.9126,6167.904,6094.5435,6100.527,6360.225,6605.048,6822.6104,6930.7837,6993.5317,7087.0986,7316.253,7283.144,7043.073,6800.8843,6221.7466,5772.0083,6622.229,6514.28,6397.398,6205.4043,6030.228,5854.2144,5683.8804,5483.411,5291.1597,5111.405,-305.86987,-38.072285,-98.39092,44.438503,123.09093,418.22964,81.717026,-238.66507,449.7737,208.94159,362.89844,656.7322,473.99728,109.01505,113.78042,-150.8713,-456.68338,-666.0056,-1002.60767,-1280.116,-1100.4492,-757.2884,-861.62756,-844.03467,-704.993,-928.90515,-923.14124,-525.5947,-650.8996,-711.00287,-39.01329,225.67505,310.90097,229.79326,52.841705,-4.815525,60.27711,32.67919,9.17819,14.697798,-85.21405,-188.2248,-23.402473,168.59294,172.24463,447.50742,690.4637,807.2731,1055.0201,849.1829,859.6063,959.38654,1046.67,1243.2239,1370.6782,1507.9828,1656.7826,1798.5956,1931.209,2077.929,2231.5361,2356.5862,2475.7942,2559.481,2721.5667,2855.3738,3013.1892,3201.0117,3398.732,3595.1885,3817.8162,4066.802,4360.616,4677.662,5057.3027,5576.3066,6417.7637,7509.324,8755.977,9629.377,10218.967,10618.4795,10859.884,10686.747,9937.399,8955.135,8155.6245,7653.5254,7287.0903,7071.1836,6941.7617,6863.71,6820.9253,6838.804,6814.441,6801.249,7011.783,6607.648,5973.5483,5883.784,6057.904,6131.9634,6174.83,6206.647,6242.6133,6369.749,6522.8047,6705.806,6910.157,7061.656,7166.518,7267.7983,7344.3926,7179.699,6953.122,6836.8257,6429.3115,6713.337,6280.543,6660.489,6511.036,6325.666,6119.774,5890.9893,5706.65,5518.8105,5262.5796,5132.3027,-782.86035,-767.1002,-607.27094,-466.83432,-510.2063,-374.3894,-901.5837,-1023.144,-1058.3176,-868.37885,-529.62726,124.74268,-133.32828,134.34293,-72.99247,-314.64517,-580.96765,-742.1856,-1029.0652,-1114.4641,-1099.2742,-782.1382,-790.4189,-866.0021,-1002.8658,-891.3607,-787.7079,-706.05194,-752.8022,-591.6536,-281.22092,-59.625717,-302.78018,-196.89578,-288.03268,-450.3672,-516.2764,-178.47687,-42.94707,-167.27473,-227.3121,-154.0524,-24.046003,115.508224,191.37671,326.56216,415.62415,523.77966,876.022,756.8691,788.49023,877.88293,1002.9886,1133.915,1268.3407,1419.8833,1616.3438,1772.9637,1905.671,2022.3839,2131.218,2250.646,2410.7515,2548.5388,2719.7244,2867.5005,3018.9062,3213.1582,3435.9905,3667.8455,3935.3132,4181.698,4425.774,4745.2705,5142.038,5669.571,6386.5225,7396.998,8628.805,9628.448,10339.666,10872.386,11343.067,11314.82,10318.848,8997.974,8121.1567,7657.6216,7284.5693,7076.6514,6957.913,6888.9805,6875.489,6892.3906,6875.21,6839.6206,6958.194,6839.5586,6384.4785,6053.2754,6079.666,6167.647,6247.757,6311.7603,6388.0312,6533.672,6675.4385,6845.339,7069.8794,7289.169,7365.1436,7409.801,7360.5767,7201.402,6998.237,6807.983,5913.742,5556.2715,6611.8013,6734.526,6557.081,6387.488,6171.196,5929.6973,5749.2847,5559.1455,4439.3965,4159.813,-1756.2715,-1798.1935,-1554.5347,-1407.4058,-1287.8668,-1601.5282,-1989.8624,-2020.0719,-1841.9834,-1915.6583,-1571.0791,-663.21436,-679.8129,81.70524,-101.7823,-463.16464,-628.30817,-701.1056,-1086.2367,-1060.0259,-977.6901,-748.94037,-629.9767,-975.8318,-1288.3363,-1022.8497,-703.9649,-846.6697,-676.4975,-528.87646,-338.6532,-253.15327,-456.73633,-475.1129,-390.6473,-469.30936,-764.9517,155.53273,159.90074,-224.68257,-198.29205,-130.27986,-43.66822,148.86693,214.05853,306.9947,357.94363,405.09073,587.9837,653.8994,734.3533,812.4203,958.52924,1118.5281,1254.4275,1375.6508,1523.1836,1707.7983,1839.748,1902.9712,2014.298,2164.0483,2363.6743,2554.3386,2683.8271,2837.5735,2991.4236,3206.5718,3496.6514,3683.0012,3883.0703,4137.167,4433.0137,4820.058,5179.4814,5661.034,6222.25,7027.2695,8164.5815,9381.004,10140.801,11153.721,12341.379,13197.975,12660.337,10636.151,8657.963,7620.2036,7201.092,6991.7603,6890.4194,6874.5034,6876.0146,6898.9375,6886.4395,6842.7065,6928.7695,6934.004,6756.7646,6318.0874,6214.4775,6217.781,6333.516,6440.1147,6557.6367,6675.0737,6809.208,6996.585,7234.1265,7423.259,7555.3584,7492.7974,7431.913,7342.547,7047.965,5719.6636,6273.1636,5856.9087,6271.572,6733.2495,6573.662,6358.878,6159.801,5932.4326,5721.8403,5638.745,4604.2627,4372.558,-1406.0752,-1256.9392,-1452.9824,-1770.0173,-1787.3241,-1962.8401,-2006.0137,-2056.0745,-2158.426,-2227.0847,-1780.7139,-602.11285,-141.34515,-28.18177,-159.79535,-543.2636,-841.2989,-704.5399,-1200.3762,-1621.0018,-1083.2216,-739.5735,-583.5355,-900.93835,-1413.9946,-1306.152,-979.143,-892.7319,-738.6795,-861.4585,-1043.0464,-766.4349,-684.10443,-641.71295,-472.09833,-342.14236,-234.1776,-118.767494,-150.99983,-360.3603,-208.02293,-113.972824,-84.156265,134.57582,193.24257,-49.91103,92.099594,260.9125,444.65704,539.1606,635.17255,728.2092,874.96204,1034.1893,1194.8075,1309.2863,1452.7526,1613.8076,1734.012,1852.184,2001.5504,2141.1936,2343.1987,2575.6677,2744.1172,2836.616,3019.4216,3218.2234,3417.7507,3601.9229,3807.7024,4106.903,4411.819,4715.743,5048.116,5468.0435,5947.7915,6688.2314,7634.1006,8783.656,10276.77,13373.311,15658.948,16240.022,16299.951,14776.995,11816.323,8939.735,7258.1196,6925.2793,6879.522,6881.5806,6886.9355,6913.04,6903.448,6894.963,6921.535,7070.2188,6931.583,6475.3643,6438.524,6409.582,6468.3496,6568.0938,6662.2026,6793.5083,6903.4243,6872.846,7172.252,7428.7607,7740.9585,7615.32,7507.7974,7249.471,5954.862,6594.3926,6547.1953,6752.642,6712.871,6041.121,6474.49,6294.602,6083.7246,4259.2427,3501.6091,4643.5864,5598.6387,5410.3306,-525.56616,-618.2973,-981.73975,-1422.416,-1480.8134,-1127.4297,-1012.2714,-1881.464,-2332.913,-2323.6287,-2186.3801,-1451.0476,-1143.6301,-549.5302,-550.22736,-581.8379,-935.55707,-1011.4368,-1274.064,-1581.0225,-1069.0698,-780.6476,-642.0392,-749.1797,-1293.3708,-1518.6553,-1170.1068,-1122.2046,-864.55115,-1147.4318,-1327.9174,-879.5816,-873.73895,-654.84296,-545.04846,-763.3108,-628.9053,-608.3546,-576.67786,-456.12482,-248.23831,-20.850052,-91.52097,-0.071477,40.950657,459.40726,225.3627,248.72104,370.2274,446.74933,550.0326,639.2405,839.76544,971.95416,1113.3535,1233.0089,1385.1401,1525.5144,1641.2198,1790.4344,1940.3274,2094.5342,2305.4846,2495.8538,2624.5125,2786.4114,2926.4487,3075.643,3302.1567,3541.8254,3766.1565,4081.1274,4346.6313,4632.1865,4937.789,5277.59,5455.4136,6294.6616,6708.111,7971.543,11194.238,15377.145,16655.783,16411.781,16643.455,16834.787,14523.135,10765.829,7893.43,6947.4595,6899.065,6910.222,6930.745,6956.2417,6960.379,6949.238,6940.133,7115.038,7304.615,6907.8794,6534.8203,6740.7515,6672.981,6659.429,6728.976,6814.528,6918.1553,7023.84,7065.8013,7255.6694,7472.92,7571.113,7493.9927,7283.9824,6884.8804,6788.877,7018.231,5981.8057,6140.9985,5082.481,6452.5083,6439.586,6236.7974,3140.3118,2837.1997,3537.4988,5554.202,5339.4893,-560.3995,-630.2793,-860.1498,-1035.6865,-1030.6816,-675.15375,-1159.7782,-2030.7185,-2106.611,-1577.6359,-2265.6738,-2163.6128,-1884.1909,-1091.5876,-476.30264,-744.23804,-1136.3762,-1275.9818,-1071.9963,-837.0668,-914.7919,-1026.4224,-1015.6993,-1318.6991,-1625.1907,-1673.4762,-1531.1451,-1484.5315,-1172.5538,-465.35706,-840.31915,-957.42255,-953.079,-712.079,-680.2089,-746.03,-630.20123,-509.46802,-445.70657,-462.33908,-322.1437,-159.60664,-115.965416,-99.26608,-144.07047,145.75226,-381.295,281.26553,286.49863,384.3652,472.94238,551.46625,755.06036,974.6257,1065.178,1167.3889,1299.1234,1404.2142,1552.5051,1667.6671,1922.0173,2050.5674,2170.8809,2345.2302,2544.1577,2728.7588,2848.5068,3034.9355,3227.4907,3486.293,3737.0476,3952.5417,4241.83,4524.102,4762.95,5055.1143,5258.3784,5651.6714,5988.5566,7633.3037,11359.982,15963.95,16697.375,16297.606,16332.877,16644.96,15083.457,11701.644,8548.124,7141.0576,6943.6353,6985.3057,7001.511,7017.489,7030.0044,7010.6104,6985.6577,6976.6265,7265.1284,7234.684,7076.398,6922.621,6881.809,6609.9067,6807.612,6884.943,6971.405,7040.0205,7060.9785,7098.581,7130.5967,7345.2817,7451.6445,7092.6274,6989.847,7692.739,6597.139,5688.7427,4325.6577,5090.6816,5093.308,4856.2695,3582.0203,2391.9395,2682.704,3978.842,5090.0586,5070.7783,-828.07214,-826.0871,-851.7669,-950.57715,-737.247,-983.8575,-1539.7925,-1988.6493,-1578.2991,-1141.6476,-2358.4722,-2311.6987,-2040.5502,-1724.2406,-1311.8378,-859.0981,-1028.4558,-1324.0096,-1088.5891,-1002.0612,-1713.2043,-1438.2386,-1522.3531,-1661.8491,-1820.5656,-1733.7189,-1686.3922,-1850.6554,-1899.5441,-627.6039,-875.3154,-858.8799,-808.59863,-689.16064,-707.0295,-757.97186,-533.7437,-733.7906,-553.8164,-548.7663,-447.78043,-382.5332,-341.13745,-244.3855,-254.66203,-116.762276,-222.69995,214.4702,138.63995,283.79382,374.2865,436.04507,616.02216,911.99243,965.22406,1050.9197,1088.022,1256.873,1465.5385,1675.9805,1898.4045,2018.3649,2109.0613,2231.042,2416.817,2604.083,2831.7368,3017.8933,3202.0925,3447.8052,3670.7,3905.7986,4113.832,4340.159,4604.853,4795.643,4844.0312,5095.9185,5672.4487,7602.3975,11524.744,15565.837,17020.014,16665.967,16259.485,15728.514,14199.794,11589.732,8905.478,7451.4346,7093.922,7104.026,7107.9443,7091.702,7093.8467,7065.775,7020.125,7021.239,7025.7393,7096.2627,7071.2837,7134.35,6974.4375,6396.1787,6768.664,6998.8257,7055.1235,7132.6816,7158.705,7169.807,7176.427,7350.434,7128.871,6332.8916,7600.061,7181.433,6585.6777,6741.174,5817.749,7344.514,5983.9062,4080.26,2181.3406,1621.0876,3346.417,5112.4233,5415.9785,5468.347,-1104.5432,-1060.33,-1051.0112,-1046.5743,-1020.3843,-1374.906,-1579.0374,-1803.2896,-1051.8384,-1064.5143,-2289.7212,-2380.269,-2420.195,-2218.4407,-2107.8508,-1641.3848,-1578.1554,-1183.9249,-1122.2723,-1146.103,-2305.6519,-1653.2758,-1796.8059,-2108.4868,-1785.3286,-1976.6637,-1934.0919,-1442.0673,-1524.8441,-1305.9465,-1044.3605,-1083.2047,-1042.9424,-912.05615,-856.4747,-691.19025,-621.95856,-614.0124,-696.8411,-608.1868,-645.57416,-647.69574,-715.1309,-521.63586,-577.36975,-343.82,-783.32996,-118.74893,26.477995,203.65115,285.55487,373.37756,453.92395,908.6442,894.23676,953.9512,1017.12573,1200.5894,1414.8602,1649.5684,1834.5665,1949.9109,2006.6561,2133.299,2320.1108,2578.1152,2834.9746,2972.758,3139.9414,3406.248,3570.0122,3776.1328,3963.6772,4163.788,4412.1123,4326.6494,4597.4204,4900.344,5532.117,7560.177,10581.967,13897.921,15911.307,16181.731,15173.57,13828.773,12304.824,10626.563,8988.512,7926.572,7378.924,7249.9185,7187.1685,7124.5195,7080.387,7049.7334,7014.7363,6990.838,6921.757,6903.9106,6784.7705,7110.9604,7293.551,7190.6533,6576.946,6925.195,6914.9834,6797.2725,6774.8467,6596.375,7100.545,6915.347,5718.719,6248.6016,6752.367,5727.1943,5887.8433,4602.422,5420.9995,7217.7065,5898.28,3169.11,1530.0708,276.26794,1504.7378,3720.8345,4798.462,5195.1587,-1385.5499,-1318.9479,-1258.6578,-1281.9863,-1359.4548,-1126.4396,-1378.6511,-1592.5,-1185.6647,-1203.8004,-2070.2075,-2479.5994,-2632.943,-2456.2725,-2412.249,-2127.9492,-1910.6056,-1520.5651,-1469.0588,-1480.6215,-1611.315,-1959.4305,-2155.218,-2164.2415,-2311.6704,-2039.7227,-1469.0912,-850.3929,-1333.064,-1845.6296,-1440.2169,-1183.4888,-1148.731,-1028.7219,-919.9568,-778.50476,-708.43207,-813.0775,-867.6933,-736.78723,-944.74725,-929.9754,-1079.7875,-847.4525,-917.6679,-805.84436,-710.7793,-392.2177,-147.07571,106.35388,246.15865,299.94647,390.64273,584.9221,768.37933,905.4166,1046.3813,1190.2701,1358.4468,1552.9586,1677.1694,1795.9076,1947.7181,2128.2896,2352.9307,2526.53,2694.9907,2893.0117,3074.5574,3234.3723,3409.7693,3642.758,3842.2043,4018.263,4174.7573,4229.5454,4502.824,4891.9067,5573.821,7185.267,9342.611,11468.839,13022.709,13398.347,12726.968,11898.6455,11273.668,10398.112,9353.009,8265.19,7633.1597,7345.4434,7204.3403,7154.6924,7100.8037,7058.2515,7001.261,6945.813,6898.7837,6952.244,6679.4214,6981.774,7211.0146,7322.6084,7205.245,7274.0103,6990.071,6930.24,7050.49,6814.922,7382.1274,7173.6997,6328.8994,5413.258,4579.9614,6569.5615,4830.9272,2941.0608,4543.488,6775.231,6163.271,4341.7485,1625.1244,-12.694615,619.1035,2328.5725,2373.1616,2273.589,-1638.8937,-1534.4421,-1448.4225,-1422.7571,-1543.8661,-1489.3275,-1602.687,-1489.4952,-1485.8397,-1439.0956,-1540.5758,-1864.689,-2371.7036,-2651.2505,-2516.7258,-2466.39,-2289.2175,-1860.2479,-1699.8849,-1955.3375,-1980.6084,-2205.0178,-2339.3699,-2334.147,-2082.3892,-2020.4954,-1613.2916,-1757.9147,-1508.2999,-1468.6432,-1115.0522,-822.78534,-752.1601,-1045.0458,-1425.1084,-996.83545,-1045.4222,-1358.9027,-1117.4727,-1084.464,-1294.9645,-1294.0854,-1492.9596,-1365.1545,-1389.4889,-1173.4445,-983.23737,-649.75616,-339.94455,-408.8591,100.81018,203.28897,281.71146,305.16046,595.50903,807.338,998.8206,1163.1782,1271.6168,1451.1494,1487.2808,1653.007,1864.9541,2038.0846,2280.2625,2388.4812,2501.2993,2822.8818,2905.4133,3090.1045,3286.4758,3513.014,3708.6904,3843.1628,4035.5947,4188.9927,4439.68,4781.3706,5452.8145,6665.2827,7913.4526,9304.868,10201.299,10422.458,10367.362,10731.493,10767.885,10232.7295,9364.157,8401.254,7624.805,7324.13,7247.3066,7187.146,7113.6235,7029.414,6964.7886,6892.621,6821.045,6794.1777,6710.754,7170.056,7101.596,7040.9023,6931.3774,6886.6772,7122.568,6970.852,6534.5483,7304.6333,5845.406,6286.385,6218.4385,6102.2793,6210.6685,5576.457,6229.8066,4375.3784,5890.7925,7456.971,7265.406,4717.78,1121.6326,-253.08327,-205.77728,433.6746,1671.8035,2464.765,-1442.4434,-1622.3411,-1669.6405,-1648.6263,-1739.1246,-1644.1166,-1820.2653,-1551.4707,-1526.4691,-1597.4565,-1424.9008,-1425.8623,-1698.8724,-2620.7476,-2669.2302,-2611.3828,-2423.0598,-2299.8906,-2232.5122,-2335.7268,-2257.2083,-2371.5674,-2593.4478,-2599.6416,-2546.013,-2174.0461,-1902.3313,-1960.6982,-1724.4181,-1330.1703,-955.5852,-758.5565,-827.8257,-914.0331,-1350.8337,-1311.6871,-1160.7548,-1277.035,-1469.2849,-1456.1039,-1623.013,-1628.4293,-1774.8627,-1705.1255,-1794.6552,-1566.1469,-1321.5209,-1109.8713,-792.94885,-495.0517,-72.19594,130.12207,295.62457,166.31528,342.97348,606.8417,819.7019,1005.5285,1226.0948,1293.3986,1334.3324,1513.0599,1719.4155,1933.0287,2131.375,2280.067,2521.2637,2642.0994,2792.447,2997.3394,3182.9336,3383.852,3556.4565,3651.1362,3903.8977,4067.655,4263.3486,4634.8193,5130.7236,5920.945,6781.133,7613.2354,8328.855,8786.028,9400.844,9896.26,9940.808,9668.197,9094.909,8352.019,7660.934,7363.6514,7345.716,7229.6455,7140.7456,7051.364,6924.793,6826.413,6746.7905,6691.595,6589.9546,6994.285,7004.7803,6974.855,6705.8535,7001.893,6960.5967,6532.803,6780.1567,6996.827,6936.297,6799.637,6421.5474,6369.3657,6414.8984,6287.2905,6535.42,5044.954,4289.146,4433.5044,3870.892,2651.809,1819.6193,588.0246,1186.8562,1648.1045,2486.772,2151.4004,-1522.8108,-1530.8181,-1629.7295,-1675.9701,-1837.3391,-1826.5349,-1830.2396,-1693.5133,-1713.0248,-1755.8458,-1499.113,-1437.1128,-1541.619,-2393.0955,-2622.9312,-2685.392,-2604.5486,-2657.5256,-2718.3123,-2586.045,-2584.1992,-2621.5735,-2654.8413,-2697.8108,-2381.1619,-1983.5948,-1666.2548,-1890.0308,-1873.5503,-1289.4318,-975.8172,-810.1814,-687.17004,-354.5075,-986.8508,-1585.5995,-1447.882,-1367.7285,-1750.8243,-1746.412,-1936.1019,-1968.1259,-2131.424,-2168.1353,-2316.9263,-2216.9043,-2131.3855,-1971.4391,-1613.6595,-1031.5236,-429.5629,-88.85231,169.49867,-24.457493,72.9493,266.20465,424.27475,750.8092,1059.2428,1124.709,1185.3585,1367.1844,1553.2979,1766.6394,1950.2704,2157.122,2334.6904,2514.1,2687.173,2871.7651,3050.76,3231.4417,3369.7021,3546.344,3732.7837,4042.92,4258.4272,4664.0933,4909.4253,5378.5137,5746.308,6305.8755,7038.3413,7863.4683,8462.542,8875.885,8995.769,8937.701,8596.106,8086.385,7580.829,7391.6597,7429.9893,7356.228,7261.777,7127.449,6955.5566,6793.1914,6673.43,6604.458,6516.2505,6666.5513,6739.804,6680.1553,6748.629,6334.935,6471.6836,6397.453,6382.436,6498.912,7223.2754,7098.483,6516.4014,6602.6514,6374.7583,6279.9756,6340.5205,6359.057,4981.912,5588.9634,5266.899,3198.1863,1917.6685,2716.4038,3336.205,2872.2402,1935.208,883.7017,-1658.5137,-1639.9753,-1744.2073,-1572.8688,-1841.4584,-1958.5697,-1896.8728,-1905.8071,-1942.542,-1870.8086,-1711.8827,-1560.0571,-1629.1508,-2514.7063,-2647.1868,-2799.1448,-2933.2058,-2864.0789,-2719.7468,-2847.299,-2740.9036,-2809.7195,-2775.2524,-2351.8486,-2015.1578,-1644.9917,-1732.3326,-2550.466,-2046.4811,-1202.9601,-1012.9861,-793.4698,-422.70346,-180.39731,-891.02057,-1767.7136,-1677.9178,-1534.9852,-1838.12,-2065.2566,-2427.6765,-2506.8015,-2573.1748,-2627.1836,-2570.0095,-2442.3323,-2181.7021,-1942.7908,-1770.4377,-1646.823,-1280.9099,-607.1018,-336.56183,-351.4891,-217.9524,-7.537995,160.72807,395.94608,676.0855,691.3603,1045.3988,1261.786,1428.0138,1577.5027,1781.7042,1976.2999,2161.9287,2411.4478,2580.058,2726.2812,2911.3599,3089.398,3258.3557,3404.6018,3500.6648,3840.8777,4176.968,4478.2856,4758.469,5051.1597,5312.328,5725.2466,6328.595,7075.903,7577.349,7836.644,8082.523,8159.309,7990.2573,7698.707,7441.7803,7474.8237,7544.2144,7498.504,7387.645,7195.9087,6965.362,6763.606,6607.511,6533.215,6429.1562,6475.657,6477.441,6487.9443,6436.4385,6361.8667,6300.921,6343.1074,6025.8667,6325.975,6862.7896,6963.974,6519.7734,6703.6504,6474.337,6107.0884,6188.6353,6351.915,6211.0483,6238.4155,5938.94,4618.252,5388.205,5107.1387,4680.1577,4841.1094,4489.8354,2856.8545,-1759.5205,-1767.7693,-1648.0905,-1706.7036,-1889.9138,-1927.0349,-1963.7997,-1972.4924,-2111.9568,-1883.9105,-1742.7781,-1808.3527,-1843.3336,-2704.3103,-2932.632,-2966.1958,-2966.6765,-2996.6082,-2859.1855,-2942.6792,-2850.6753,-2738.444,-2677.4983,-2243.1968,-1719.2091,-1858.6477,-2494.8667,-2036.5256,-1560.65,-1307.4738,-1032.044,-575.58185,-138.46347,-45.188316,-1485.8131,-2299.259,-2079.4504,-2135.1296,-2215.905,-2324.8572,-2668.804,-2735.397,-2718.0938,-2704.581,-2507.162,-1875.7108,-1148.8805,-462.3283,-170.01823,-502.18216,-1121.9535,-1216.6213,-830.62573,-663.5412,-377.89297,-218.72801,-66.11333,133.76408,351.50214,622.5575,939.08307,1160.2123,1147.4198,1256.3822,1480.3584,1711.2628,1980.719,2217.3347,2409.4468,2568.1724,2727.4172,2919.8445,3112.6355,3237.9705,3395.4478,3737.566,4062.0977,4314.2954,4584.4497,4804.136,5108.3296,5548.6206,6081.0303,6633.645,7053.78,7338.314,7549.227,7596.6885,7510.628,7418.685,7397.8154,7565.802,7723.111,7702.033,7498.3506,7227.026,6950.2427,6702.9106,6529.0522,6394.566,6297.4956,6216.3794,6123.711,6068.542,6020.1396,6026.5693,5922.304,6047.0693,5987.09,6053.7163,6286.9346,6542.552,6509.9526,6476.7217,6309.3984,5809.6685,5979.4395,6019.371,5985.663,5854.8,5662.0044,5167.972,4913.8184,4741.2725,4621.9893,4448.719,4424.7417,4496.5264,-1885.4061,-1869.5807,-1697.8246,-1925.5438,-2025.0312,-2038.9916,-2117.548,-2172.865,-2313.903,-2170.4211,-2020.8317,-1960.42,-1957.7167,-2545.49,-3087.2822,-3078.7014,-3103.3508,-3061.6099,-3012.671,-2989.168,-2817.5654,-2788.851,-2619.4924,-1990.3273,-1982.6937,-2657.5483,-2148.994,-1583.0764,-1270.4878,-1075.656,-678.3423,-255.25304,-10.420246,317.12833,-1403.805,-2746.797,-2687.8435,-2345.275,-2309.2598,-2388.235,-2709.7734,-2785.2207,-2762.107,-2594.5476,-1883.4949,-1131.0299,-673.41583,10.639791,108.36735,-243.53107,-918.6772,-1327.6359,-1082.21,-887.0809,-730.05066,-493.92697,-280.8906,-56.895985,316.72537,536.64307,783.0759,856.46545,780.1347,887.0543,1148.407,1420.2583,1657.9048,1864.074,2140.6846,2358.0251,2525.5188,2756.8672,2948.4243,3137.3032,3360.145,3661.0945,3938.4941,4202.6934,4404.932,4608.0674,4965.217,5314.4844,5811.6597,6303.629,6696.5977,7000.329,7172.332,7210.6924,7197.7876,7216.6895,7383.371,7799.9097,7974.661,7967.3716,7692.64,7292.2983,6909.497,6597.5303,6416.433,6302.2173,6144.3066,6036.7734,5920.8687,5845.6714,5773.1367,5683.094,5640.0024,5774.913,5830.3447,5775.609,5810.087,6048.244,6197.6064,6344.1772,6249.592,5628.0464,5734.573,5703.779,5587.2314,5342.6445,5103.258,4778.45,4474.0376,4321.771,4223.933,4142.86,4130.1636,4079.445,-2008.2289,-1939.1266,-1844.797,-2027.411,-2076.3738,-2129.778,-2230.5159,-2370.9043,-2405.6362,-2506.1016,-2325.1467,-2248.474,-2281.183,-2716.3125,-3067.7625,-3118.0488,-3143.034,-3025.632,-3033.411,-2995.1802,-2939.3955,-2726.6797,-2429.196,-2299.1572,-2748.204,-2430.4578,-1801.3558,-1447.232,-1211.7355,-910.74194,-572.2064,-226.42252,241.17142,258.32495,-1685.8745,-2470.0642,-2324.8328,-2338.874,-2593.8337,-2949.3267,-2876.0977,-2913.6174,-2741.942,-2186.9766,-1422.4254,-867.1528,-408.95172,-393.8518,-694.2506,-1020.3471,-1452.2373,-1482.3057,-1292.1138,-1069.462,-811.4095,-582.37427,-368.58594,-262.89246,93.14236,335.6273,419.5116,544.58734,527.80975,692.1427,971.32385,1196.8792,1399.227,1585.143,1805.3723,2139.4336,2398.9624,2615.3425,2815.987,3053.513,3281.2102,3561.4873,3805.9075,4044.344,4235.4937,4473.135,4774.741,5103.3423,5550.6675,5987.74,6376.74,6649.412,6849.651,6950.098,7000.804,7085.462,7506.281,8197.6,8457.008,8305.9795,7955.84,7362.877,6774.2563,6468.4756,6287.876,6186.939,6046.3403,5939.513,5799.654,5741.6377,5694.184,5586.843,5520.1006,5565.7754,5625.918,5530.4453,5514.6294,5639.86,5866.188,5985.4253,5887.4487,5490.845,5322.907,5256.196,5061.0327,4763.8237,4501.073,4305.4204,4157.0913,4032.0754,3911.744,3822.7708,3664.5723,3548.0652,-2250.899,-2146.4158,-2082.4663,-2152.9165,-2137.664,-2154.0095,-2363.226,-2361.0508,-2417.1824,-2690.886,-2472.8125,-2462.6475,-2724.7092,-2994.291,-3123.7583,-3169.568,-3091.0159,-3062.7217,-3078.623,-3041.2314,-2837.27,-2606.059,-2520.6113,-2649.2883,-2710.7324,-2033.9529,-1680.8304,-1478.819,-1168.2255,-828.18823,-340.40433,-118.673485,248.87648,-262.57132,-1874.9803,-2586.11,-2622.8997,-2620.7656,-2659.6826,-2998.2942,-2926.062,-2863.6533,-2437.7405,-1841.2268,-1321.6202,-903.6227,-936.83154,-1253.2897,-1514.924,-1708.4363,-1697.8939,-1603.0286,-1363.5425,-1035.1985,-701.6073,-452.55222,-443.689,-269.98688,-155.5025,35.643738,209.94441,317.5456,381.97488,566.6654,767.5896,1042.8965,1273.8733,1477.9198,1718.1604,2025.4786,2338.2473,2566.5613,2756.369,2959.5815,3197.5657,3433.689,3682.9563,3908.4495,4134.681,4363.195,4607.1133,4873.339,5179.691,5561.477,5936.068,6281.8247,6556.3804,6739.6235,6849.488,7006.5747,7557.458,8474.508,9141.774,9378.061,9270.141,8338.416,6934.6665,6263.2275,6140.034,6082.552,5966.1357,5890.7563,5781.995,5684.312,5637.405,5535.919,5446.945,5400.2925,5398.3076,5293.045,5302.691,5396.2007,5467.5957,5630.4233,5442.4243,5099.601,4802.991,4595.278,4426.789,4272.3774,4138.7397,3995.2446,3913.202,3781.0322,3675.783,3676.711,3412.1704,3187.1802,-2464.809,-2300.6292,-2287.7124,-2255.942,-2142.8184,-2132.704,-2334.6665,-2404.8408,-2519.6267,-2741.2039,-2721.1038,-2820.504,-2884.1018,-2935.8105,-2973.5125,-3119.3389,-3061.118,-3105.6357,-3068.2,-2955.3467,-2841.8145,-2644.591,-2584.7173,-2700.5564,-2298.403,-1801.5631,-1718.1494,-1679.5103,-1213.0851,-701.6984,-364.12976,-47.286312,34.14383,-949.2243,-2071.1194,-2854.2239,-2960.4666,-2606.5825,-2949.622,-3043.6777,-2924.4468,-2684.6226,-2363.4387,-1687.7766,-1277.1775,-1520.4508,-1898.0917,-1894.1968,-1833.2327,-1864.0348,-1836.1748,-1561.623,-1158.7847,-778.3505,-570.78815,-574.89246,-570.7967,-482.40253,-348.57944,-163.24417,17.523499,81.237885,249.03671,549.59937,745.88446,958.47314,1161.1285,1418.7999,1646.6628,1960.9244,2241.0874,2446.2449,2656.3333,2839.9568,3102.5422,3354.1821,3596.3643,3847.0974,4097.615,4289.385,4475.213,4674.806,4894.4976,5139.9556,5525.745,5929.139,6278.7603,6503.4595,6618.83,6905.3794,7560.053,8611.074,10087.893,11552.72,12077.493,10717.686,8119.794,6316.723,5965.276,5942.1816,5887.1646,5833.1924,5788.0815,5650.8276,5568.841,5490.6055,5408.473,5322.6094,5252.2646,5179.091,5122.8057,5198.5522,5104.165,5020.213,4832.9707,4570.8975,4288.371,4098.004,4015.118,3956.8733,3871.4543,3795.6018,3719.8132,3608.6096,3493.0295,3402.8887,3214.006,3055.731,-2372.612,-2257.7495,-2222.731,-2105.6738,-2077.1775,-2183.7402,-2369.4907,-2501.9482,-2701.095,-2838.4006,-2915.9968,-2860.105,-2851.0686,-2864.363,-2920.3157,-3048.2905,-3076.9617,-3101.5154,-3073.1274,-2961.5183,-3826.9534,-3860.8093,-2688.4546,-2486.4094,-2053.1763,-1926.9927,-2008.9464,-1549.6079,-1179.6763,-901.48334,-482.48456,-246.5073,-629.81866,-1452.1686,-2583.9565,-3061.8577,-2829.7178,-2860.8286,-3129.8306,-3044.1472,-2975.5483,-2798.364,-2270.78,-1783.2025,-1967.9045,-2167.1929,-2143.6455,-2035.407,-1970.4082,-1992.4601,-1746.6901,-1192.696,-776.6941,-557.39197,-734.33575,-882.6015,-839.2351,-608.0659,-382.63745,-358.14645,-277.1715,-157.93437,100.84979,452.60773,783.946,1053.4713,1238.2081,1532.4409,1747.58,1958.3231,2144.7285,2365.8538,2541.9053,2706.331,2985.6748,3268.1086,3553.1252,3830.9539,4083.4075,4298.281,4436.289,4574.5884,4737.4546,4905.0854,5157.357,5471.1323,5849.472,6118.055,6216.5254,6524.2944,7163.962,8784.316,11542.163,13321.463,12827.345,12446.641,9904.798,7239.416,5861.6216,5782.927,5743.839,5687.0806,5647.2686,5596.234,5546.952,5499.268,5393.9194,5288.14,5184.605,5103.3477,5027.145,4926.884,4730.502,4568.554,4400.1606,4266.437,4156.758,4051.1099,3982.0366,3912.4463,3829.527,3730.6626,3617.257,3476.4243,3373.441,3268.253,3150.3838,2997.4866],solid=False,xDimension=128,xSpacing=0.708661,yScale=50.0,zDimension=128,zSpacing=0.708661,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.00787,0.00391),(0.01575,0.00391),(0.02362,0.00391),(0.0315,0.00391),(0.03937,0.00391),(0.04724,0.00391),(0.05512,0.00391),(0.06299,0.00391),(0.07087,0.00391),(0.07874,0.00391),(0.08661,0.00391),(0.09449,0.00391),(0.10236,0.00391),(0.11024,0.00391),(0.11811,0.00391),(0.12598,0.00391),(0.13386,0.00391),(0.14173,0.00391),(0.14961,0.00391),(0.15748,0.00391),(0.16535,0.00391),(0.17323,0.00391),(0.1811,0.00391),(0.18898,0.00391),(0.19685,0.00391),(0.20472,0.00391),(0.2126,0.00391),(0.22047,0.00391),(0.22835,0.00391),(0.23622,0.00391),(0.24409,0.00391),(0.25197,0.00391),(0.25984,0.00391),(0.26772,0.00391),(0.27559,0.00391),(0.28346,0.00391),(0.29134,0.00391),(0.29921,0.00391),(0.30709,0.00391),(0.31496,0.00391),(0.32283,0.00391),(0.33071,0.00391),(0.33858,0.00391),(0.34646,0.00391),(0.35433,0.00391),(0.3622,0.00391),(0.37008,0.00391),(0.37795,0.00391),(0.38583,0.00391),(0.3937,0.00391),(0.40157,0.00391),(0.40945,0.00391),(0.41732,0.00391),(0.4252,0.00391),(0.43307,0.00391),(0.44094,0.00391),(0.44882,0.00391),(0.45669,0.00391),(0.46457,0.00391),(0.47244,0.00391),(0.48031,0.00391),(0.48819,0.00391),(0.49606,0.00391),(0.50394,0.00391),(0.51181,0.00391),(0.51969,0.00391),(0.52756,0.00391),(0.53543,0.00391),(0.54331,0.00391),(0.55118,0.00391),(0.55906,0.00391),(0.56693,0.00391),(0.5748,0.00391),(0.58268,0.00391),(0.59055,0.00391),(0.59843,0.00391),(0.6063,0.00391),(0.61417,0.00391),(0.62205,0.00391),(0.62992,0.00391),(0.6378,0.00391),(0.64567,0.00391),(0.65354,0.00391),(0.66142,0.00391),(0.66929,0.00391),(0.67717,0.00391),(0.68504,0.00391),(0.69291,0.00391),(0.70079,0.00391),(0.70866,0.00391),(0.71654,0.00391),(0.72441,0.00391),(0.73228,0.00391),(0.74016,0.00391),(0.74803,0.00391),(0.75591,0.00391),(0.76378,0.00391),(0.77165,0.00391),(0.77953,0.00391),(0.7874,0.00391),(0.79528,0.00391),(0.80315,0.00391),(0.81102,0.00391),(0.8189,0.00391),(0.82677,0.00391),(0.83465,0.00391),(0.84252,0.00391),(0.85039,0.00391),(0.85827,0.00391),(0.86614,0.00391),(0.87402,0.00391),(0.88189,0.00391),(0.88976,0.00391),(0.89764,0.00391),(0.90551,0.00391),(0.91339,0.00391),(0.92126,0.00391),(0.92913,0.00391),(0.93701,0.00391),(0.94488,0.00391),(0.95276,0.00391),(0.96063,0.00391),(0.9685,0.00391),(0.97638,0.00391),(0.98425,0.00391),(0.99213,0.00391),(0.99609,0.00391),(0.00391,0.00787),(0.00787,0.00787),(0.01575,0.00787),(0.02362,0.00787),(0.0315,0.00787),(0.03937,0.00787),(0.04724,0.00787),(0.05512,0.00787),(0.06299,0.00787),(0.07087,0.00787),(0.07874,0.00787),(0.08661,0.00787),(0.09449,0.00787),(0.10236,0.00787),(0.11024,0.00787),(0.11811,0.00787),(0.12598,0.00787),(0.13386,0.00787),(0.14173,0.00787),(0.14961,0.00787),(0.15748,0.00787),(0.16535,0.00787),(0.17323,0.00787),(0.1811,0.00787),(0.18898,0.00787),(0.19685,0.00787),(0.20472,0.00787),(0.2126,0.00787),(0.22047,0.00787),(0.22835,0.00787),(0.23622,0.00787),(0.24409,0.00787),(0.25197,0.00787),(0.25984,0.00787),(0.26772,0.00787),(0.27559,0.00787),(0.28346,0.00787),(0.29134,0.00787),(0.29921,0.00787),(0.30709,0.00787),(0.31496,0.00787),(0.32283,0.00787),(0.33071,0.00787),(0.33858,0.00787),(0.34646,0.00787),(0.35433,0.00787),(0.3622,0.00787),(0.37008,0.00787),(0.37795,0.00787),(0.38583,0.00787),(0.3937,0.00787),(0.40157,0.00787),(0.40945,0.00787),(0.41732,0.00787),(0.4252,0.00787),(0.43307,0.00787),(0.44094,0.00787),(0.44882,0.00787),(0.45669,0.00787),(0.46457,0.00787),(0.47244,0.00787),(0.48031,0.00787),(0.48819,0.00787),(0.49606,0.00787),(0.50394,0.00787),(0.51181,0.00787),(0.51969,0.00787),(0.52756,0.00787),(0.53543,0.00787),(0.54331,0.00787),(0.55118,0.00787),(0.55906,0.00787),(0.56693,0.00787),(0.5748,0.00787),(0.58268,0.00787),(0.59055,0.00787),(0.59843,0.00787),(0.6063,0.00787),(0.61417,0.00787),(0.62205,0.00787),(0.62992,0.00787),(0.6378,0.00787),(0.64567,0.00787),(0.65354,0.00787),(0.66142,0.00787),(0.66929,0.00787),(0.67717,0.00787),(0.68504,0.00787),(0.69291,0.00787),(0.70079,0.00787),(0.70866,0.00787),(0.71654,0.00787),(0.72441,0.00787),(0.73228,0.00787),(0.74016,0.00787),(0.74803,0.00787),(0.75591,0.00787),(0.76378,0.00787),(0.77165,0.00787),(0.77953,0.00787),(0.7874,0.00787),(0.79528,0.00787),(0.80315,0.00787),(0.81102,0.00787),(0.8189,0.00787),(0.82677,0.00787),(0.83465,0.00787),(0.84252,0.00787),(0.85039,0.00787),(0.85827,0.00787),(0.86614,0.00787),(0.87402,0.00787),(0.88189,0.00787),(0.88976,0.00787),(0.89764,0.00787),(0.90551,0.00787),(0.91339,0.00787),(0.92126,0.00787),(0.92913,0.00787),(0.93701,0.00787),(0.94488,0.00787),(0.95276,0.00787),(0.96063,0.00787),(0.9685,0.00787),(0.97638,0.00787),(0.98425,0.00787),(0.99213,0.00787),(0.99609,0.00787),(0.00391,0.01575),(0.00787,0.01575),(0.01575,0.01575),(0.02362,0.01575),(0.0315,0.01575),(0.03937,0.01575),(0.04724,0.01575),(0.05512,0.01575),(0.06299,0.01575),(0.07087,0.01575),(0.07874,0.01575),(0.08661,0.01575),(0.09449,0.01575),(0.10236,0.01575),(0.11024,0.01575),(0.11811,0.01575),(0.12598,0.01575),(0.13386,0.01575),(0.14173,0.01575),(0.14961,0.01575),(0.15748,0.01575),(0.16535,0.01575),(0.17323,0.01575),(0.1811,0.01575),(0.18898,0.01575),(0.19685,0.01575),(0.20472,0.01575),(0.2126,0.01575),(0.22047,0.01575),(0.22835,0.01575),(0.23622,0.01575),(0.24409,0.01575),(0.25197,0.01575),(0.25984,0.01575),(0.26772,0.01575),(0.27559,0.01575),(0.28346,0.01575),(0.29134,0.01575),(0.29921,0.01575),(0.30709,0.01575),(0.31496,0.01575),(0.32283,0.01575),(0.33071,0.01575),(0.33858,0.01575),(0.34646,0.01575),(0.35433,0.01575),(0.3622,0.01575),(0.37008,0.01575),(0.37795,0.01575),(0.38583,0.01575),(0.3937,0.01575),(0.40157,0.01575),(0.40945,0.01575),(0.41732,0.01575),(0.4252,0.01575),(0.43307,0.01575),(0.44094,0.01575),(0.44882,0.01575),(0.45669,0.01575),(0.46457,0.01575),(0.47244,0.01575),(0.48031,0.01575),(0.48819,0.01575),(0.49606,0.01575),(0.50394,0.01575),(0.51181,0.01575),(0.51969,0.01575),(0.52756,0.01575),(0.53543,0.01575),(0.54331,0.01575),(0.55118,0.01575),(0.55906,0.01575),(0.56693,0.01575),(0.5748,0.01575),(0.58268,0.01575),(0.59055,0.01575),(0.59843,0.01575),(0.6063,0.01575),(0.61417,0.01575),(0.62205,0.01575),(0.62992,0.01575),(0.6378,0.01575),(0.64567,0.01575),(0.65354,0.01575),(0.66142,0.01575),(0.66929,0.01575),(0.67717,0.01575),(0.68504,0.01575),(0.69291,0.01575),(0.70079,0.01575),(0.70866,0.01575),(0.71654,0.01575),(0.72441,0.01575),(0.73228,0.01575),(0.74016,0.01575),(0.74803,0.01575),(0.75591,0.01575),(0.76378,0.01575),(0.77165,0.01575),(0.77953,0.01575),(0.7874,0.01575),(0.79528,0.01575),(0.80315,0.01575),(0.81102,0.01575),(0.8189,0.01575),(0.82677,0.01575),(0.83465,0.01575),(0.84252,0.01575),(0.85039,0.01575),(0.85827,0.01575),(0.86614,0.01575),(0.87402,0.01575),(0.88189,0.01575),(0.88976,0.01575),(0.89764,0.01575),(0.90551,0.01575),(0.91339,0.01575),(0.92126,0.01575),(0.92913,0.01575),(0.93701,0.01575),(0.94488,0.01575),(0.95276,0.01575),(0.96063,0.01575),(0.9685,0.01575),(0.97638,0.01575),(0.98425,0.01575),(0.99213,0.01575),(0.99609,0.01575),(0.00391,0.02362),(0.00787,0.02362),(0.01575,0.02362),(0.02362,0.02362),(0.0315,0.02362),(0.03937,0.02362),(0.04724,0.02362),(0.05512,0.02362),(0.06299,0.02362),(0.07087,0.02362),(0.07874,0.02362),(0.08661,0.02362),(0.09449,0.02362),(0.10236,0.02362),(0.11024,0.02362),(0.11811,0.02362),(0.12598,0.02362),(0.13386,0.02362),(0.14173,0.02362),(0.14961,0.02362),(0.15748,0.02362),(0.16535,0.02362),(0.17323,0.02362),(0.1811,0.02362),(0.18898,0.02362),(0.19685,0.02362),(0.20472,0.02362),(0.2126,0.02362),(0.22047,0.02362),(0.22835,0.02362),(0.23622,0.02362),(0.24409,0.02362),(0.25197,0.02362),(0.25984,0.02362),(0.26772,0.02362),(0.27559,0.02362),(0.28346,0.02362),(0.29134,0.02362),(0.29921,0.02362),(0.30709,0.02362),(0.31496,0.02362),(0.32283,0.02362),(0.33071,0.02362),(0.33858,0.02362),(0.34646,0.02362),(0.35433,0.02362),(0.3622,0.02362),(0.37008,0.02362),(0.37795,0.02362),(0.38583,0.02362),(0.3937,0.02362),(0.40157,0.02362),(0.40945,0.02362),(0.41732,0.02362),(0.4252,0.02362),(0.43307,0.02362),(0.44094,0.02362),(0.44882,0.02362),(0.45669,0.02362),(0.46457,0.02362),(0.47244,0.02362),(0.48031,0.02362),(0.48819,0.02362),(0.49606,0.02362),(0.50394,0.02362),(0.51181,0.02362),(0.51969,0.02362),(0.52756,0.02362),(0.53543,0.02362),(0.54331,0.02362),(0.55118,0.02362),(0.55906,0.02362),(0.56693,0.02362),(0.5748,0.02362),(0.58268,0.02362),(0.59055,0.02362),(0.59843,0.02362),(0.6063,0.02362),(0.61417,0.02362),(0.62205,0.02362),(0.62992,0.02362),(0.6378,0.02362),(0.64567,0.02362),(0.65354,0.02362),(0.66142,0.02362),(0.66929,0.02362),(0.67717,0.02362),(0.68504,0.02362),(0.69291,0.02362),(0.70079,0.02362),(0.70866,0.02362),(0.71654,0.02362),(0.72441,0.02362),(0.73228,0.02362),(0.74016,0.02362),(0.74803,0.02362),(0.75591,0.02362),(0.76378,0.02362),(0.77165,0.02362),(0.77953,0.02362),(0.7874,0.02362),(0.79528,0.02362),(0.80315,0.02362),(0.81102,0.02362),(0.8189,0.02362),(0.82677,0.02362),(0.83465,0.02362),(0.84252,0.02362),(0.85039,0.02362),(0.85827,0.02362),(0.86614,0.02362),(0.87402,0.02362),(0.88189,0.02362),(0.88976,0.02362),(0.89764,0.02362),(0.90551,0.02362),(0.91339,0.02362),(0.92126,0.02362),(0.92913,0.02362),(0.93701,0.02362),(0.94488,0.02362),(0.95276,0.02362),(0.96063,0.02362),(0.9685,0.02362),(0.97638,0.02362),(0.98425,0.02362),(0.99213,0.02362),(0.99609,0.02362),(0.00391,0.0315),(0.00787,0.0315),(0.01575,0.0315),(0.02362,0.0315),(0.0315,0.0315),(0.03937,0.0315),(0.04724,0.0315),(0.05512,0.0315),(0.06299,0.0315),(0.07087,0.0315),(0.07874,0.0315),(0.08661,0.0315),(0.09449,0.0315),(0.10236,0.0315),(0.11024,0.0315),(0.11811,0.0315),(0.12598,0.0315),(0.13386,0.0315),(0.14173,0.0315),(0.14961,0.0315),(0.15748,0.0315),(0.16535,0.0315),(0.17323,0.0315),(0.1811,0.0315),(0.18898,0.0315),(0.19685,0.0315),(0.20472,0.0315),(0.2126,0.0315),(0.22047,0.0315),(0.22835,0.0315),(0.23622,0.0315),(0.24409,0.0315),(0.25197,0.0315),(0.25984,0.0315),(0.26772,0.0315),(0.27559,0.0315),(0.28346,0.0315),(0.29134,0.0315),(0.29921,0.0315),(0.30709,0.0315),(0.31496,0.0315),(0.32283,0.0315),(0.33071,0.0315),(0.33858,0.0315),(0.34646,0.0315),(0.35433,0.0315),(0.3622,0.0315),(0.37008,0.0315),(0.37795,0.0315),(0.38583,0.0315),(0.3937,0.0315),(0.40157,0.0315),(0.40945,0.0315),(0.41732,0.0315),(0.4252,0.0315),(0.43307,0.0315),(0.44094,0.0315),(0.44882,0.0315),(0.45669,0.0315),(0.46457,0.0315),(0.47244,0.0315),(0.48031,0.0315),(0.48819,0.0315),(0.49606,0.0315),(0.50394,0.0315),(0.51181,0.0315),(0.51969,0.0315),(0.52756,0.0315),(0.53543,0.0315),(0.54331,0.0315),(0.55118,0.0315),(0.55906,0.0315),(0.56693,0.0315),(0.5748,0.0315),(0.58268,0.0315),(0.59055,0.0315),(0.59843,0.0315),(0.6063,0.0315),(0.61417,0.0315),(0.62205,0.0315),(0.62992,0.0315),(0.6378,0.0315),(0.64567,0.0315),(0.65354,0.0315),(0.66142,0.0315),(0.66929,0.0315),(0.67717,0.0315),(0.68504,0.0315),(0.69291,0.0315),(0.70079,0.0315),(0.70866,0.0315),(0.71654,0.0315),(0.72441,0.0315),(0.73228,0.0315),(0.74016,0.0315),(0.74803,0.0315),(0.75591,0.0315),(0.76378,0.0315),(0.77165,0.0315),(0.77953,0.0315),(0.7874,0.0315),(0.79528,0.0315),(0.80315,0.0315),(0.81102,0.0315),(0.8189,0.0315),(0.82677,0.0315),(0.83465,0.0315),(0.84252,0.0315),(0.85039,0.0315),(0.85827,0.0315),(0.86614,0.0315),(0.87402,0.0315),(0.88189,0.0315),(0.88976,0.0315),(0.89764,0.0315),(0.90551,0.0315),(0.91339,0.0315),(0.92126,0.0315),(0.92913,0.0315),(0.93701,0.0315),(0.94488,0.0315),(0.95276,0.0315),(0.96063,0.0315),(0.9685,0.0315),(0.97638,0.0315),(0.98425,0.0315),(0.99213,0.0315),(0.99609,0.0315),(0.00391,0.03937),(0.00787,0.03937),(0.01575,0.03937),(0.02362,0.03937),(0.0315,0.03937),(0.03937,0.03937),(0.04724,0.03937),(0.05512,0.03937),(0.06299,0.03937),(0.07087,0.03937),(0.07874,0.03937),(0.08661,0.03937),(0.09449,0.03937),(0.10236,0.03937),(0.11024,0.03937),(0.11811,0.03937),(0.12598,0.03937),(0.13386,0.03937),(0.14173,0.03937),(0.14961,0.03937),(0.15748,0.03937),(0.16535,0.03937),(0.17323,0.03937),(0.1811,0.03937),(0.18898,0.03937),(0.19685,0.03937),(0.20472,0.03937),(0.2126,0.03937),(0.22047,0.03937),(0.22835,0.03937),(0.23622,0.03937),(0.24409,0.03937),(0.25197,0.03937),(0.25984,0.03937),(0.26772,0.03937),(0.27559,0.03937),(0.28346,0.03937),(0.29134,0.03937),(0.29921,0.03937),(0.30709,0.03937),(0.31496,0.03937),(0.32283,0.03937),(0.33071,0.03937),(0.33858,0.03937),(0.34646,0.03937),(0.35433,0.03937),(0.3622,0.03937),(0.37008,0.03937),(0.37795,0.03937),(0.38583,0.03937),(0.3937,0.03937),(0.40157,0.03937),(0.40945,0.03937),(0.41732,0.03937),(0.4252,0.03937),(0.43307,0.03937),(0.44094,0.03937),(0.44882,0.03937),(0.45669,0.03937),(0.46457,0.03937),(0.47244,0.03937),(0.48031,0.03937),(0.48819,0.03937),(0.49606,0.03937),(0.50394,0.03937),(0.51181,0.03937),(0.51969,0.03937),(0.52756,0.03937),(0.53543,0.03937),(0.54331,0.03937),(0.55118,0.03937),(0.55906,0.03937),(0.56693,0.03937),(0.5748,0.03937),(0.58268,0.03937),(0.59055,0.03937),(0.59843,0.03937),(0.6063,0.03937),(0.61417,0.03937),(0.62205,0.03937),(0.62992,0.03937),(0.6378,0.03937),(0.64567,0.03937),(0.65354,0.03937),(0.66142,0.03937),(0.66929,0.03937),(0.67717,0.03937),(0.68504,0.03937),(0.69291,0.03937),(0.70079,0.03937),(0.70866,0.03937),(0.71654,0.03937),(0.72441,0.03937),(0.73228,0.03937),(0.74016,0.03937),(0.74803,0.03937),(0.75591,0.03937),(0.76378,0.03937),(0.77165,0.03937),(0.77953,0.03937),(0.7874,0.03937),(0.79528,0.03937),(0.80315,0.03937),(0.81102,0.03937),(0.8189,0.03937),(0.82677,0.03937),(0.83465,0.03937),(0.84252,0.03937),(0.85039,0.03937),(0.85827,0.03937),(0.86614,0.03937),(0.87402,0.03937),(0.88189,0.03937),(0.88976,0.03937),(0.89764,0.03937),(0.90551,0.03937),(0.91339,0.03937),(0.92126,0.03937),(0.92913,0.03937),(0.93701,0.03937),(0.94488,0.03937),(0.95276,0.03937),(0.96063,0.03937),(0.9685,0.03937),(0.97638,0.03937),(0.98425,0.03937),(0.99213,0.03937),(0.99609,0.03937),(0.00391,0.04724),(0.00787,0.04724),(0.01575,0.04724),(0.02362,0.04724),(0.0315,0.04724),(0.03937,0.04724),(0.04724,0.04724),(0.05512,0.04724),(0.06299,0.04724),(0.07087,0.04724),(0.07874,0.04724),(0.08661,0.04724),(0.09449,0.04724),(0.10236,0.04724),(0.11024,0.04724),(0.11811,0.04724),(0.12598,0.04724),(0.13386,0.04724),(0.14173,0.04724),(0.14961,0.04724),(0.15748,0.04724),(0.16535,0.04724),(0.17323,0.04724),(0.1811,0.04724),(0.18898,0.04724),(0.19685,0.04724),(0.20472,0.04724),(0.2126,0.04724),(0.22047,0.04724),(0.22835,0.04724),(0.23622,0.04724),(0.24409,0.04724),(0.25197,0.04724),(0.25984,0.04724),(0.26772,0.04724),(0.27559,0.04724),(0.28346,0.04724),(0.29134,0.04724),(0.29921,0.04724),(0.30709,0.04724),(0.31496,0.04724),(0.32283,0.04724),(0.33071,0.04724),(0.33858,0.04724),(0.34646,0.04724),(0.35433,0.04724),(0.3622,0.04724),(0.37008,0.04724),(0.37795,0.04724),(0.38583,0.04724),(0.3937,0.04724),(0.40157,0.04724),(0.40945,0.04724),(0.41732,0.04724),(0.4252,0.04724),(0.43307,0.04724),(0.44094,0.04724),(0.44882,0.04724),(0.45669,0.04724),(0.46457,0.04724),(0.47244,0.04724),(0.48031,0.04724),(0.48819,0.04724),(0.49606,0.04724),(0.50394,0.04724),(0.51181,0.04724),(0.51969,0.04724),(0.52756,0.04724),(0.53543,0.04724),(0.54331,0.04724),(0.55118,0.04724),(0.55906,0.04724),(0.56693,0.04724),(0.5748,0.04724),(0.58268,0.04724),(0.59055,0.04724),(0.59843,0.04724),(0.6063,0.04724),(0.61417,0.04724),(0.62205,0.04724),(0.62992,0.04724),(0.6378,0.04724),(0.64567,0.04724),(0.65354,0.04724),(0.66142,0.04724),(0.66929,0.04724),(0.67717,0.04724),(0.68504,0.04724),(0.69291,0.04724),(0.70079,0.04724),(0.70866,0.04724),(0.71654,0.04724),(0.72441,0.04724),(0.73228,0.04724),(0.74016,0.04724),(0.74803,0.04724),(0.75591,0.04724),(0.76378,0.04724),(0.77165,0.04724),(0.77953,0.04724),(0.7874,0.04724),(0.79528,0.04724),(0.80315,0.04724),(0.81102,0.04724),(0.8189,0.04724),(0.82677,0.04724),(0.83465,0.04724),(0.84252,0.04724),(0.85039,0.04724),(0.85827,0.04724),(0.86614,0.04724),(0.87402,0.04724),(0.88189,0.04724),(0.88976,0.04724),(0.89764,0.04724),(0.90551,0.04724),(0.91339,0.04724),(0.92126,0.04724),(0.92913,0.04724),(0.93701,0.04724),(0.94488,0.04724),(0.95276,0.04724),(0.96063,0.04724),(0.9685,0.04724),(0.97638,0.04724),(0.98425,0.04724),(0.99213,0.04724),(0.99609,0.04724),(0.00391,0.05512),(0.00787,0.05512),(0.01575,0.05512),(0.02362,0.05512),(0.0315,0.05512),(0.03937,0.05512),(0.04724,0.05512),(0.05512,0.05512),(0.06299,0.05512),(0.07087,0.05512),(0.07874,0.05512),(0.08661,0.05512),(0.09449,0.05512),(0.10236,0.05512),(0.11024,0.05512),(0.11811,0.05512),(0.12598,0.05512),(0.13386,0.05512),(0.14173,0.05512),(0.14961,0.05512),(0.15748,0.05512),(0.16535,0.05512),(0.17323,0.05512),(0.1811,0.05512),(0.18898,0.05512),(0.19685,0.05512),(0.20472,0.05512),(0.2126,0.05512),(0.22047,0.05512),(0.22835,0.05512),(0.23622,0.05512),(0.24409,0.05512),(0.25197,0.05512),(0.25984,0.05512),(0.26772,0.05512),(0.27559,0.05512),(0.28346,0.05512),(0.29134,0.05512),(0.29921,0.05512),(0.30709,0.05512),(0.31496,0.05512),(0.32283,0.05512),(0.33071,0.05512),(0.33858,0.05512),(0.34646,0.05512),(0.35433,0.05512),(0.3622,0.05512),(0.37008,0.05512),(0.37795,0.05512),(0.38583,0.05512),(0.3937,0.05512),(0.40157,0.05512),(0.40945,0.05512),(0.41732,0.05512),(0.4252,0.05512),(0.43307,0.05512),(0.44094,0.05512),(0.44882,0.05512),(0.45669,0.05512),(0.46457,0.05512),(0.47244,0.05512),(0.48031,0.05512),(0.48819,0.05512),(0.49606,0.05512),(0.50394,0.05512),(0.51181,0.05512),(0.51969,0.05512),(0.52756,0.05512),(0.53543,0.05512),(0.54331,0.05512),(0.55118,0.05512),(0.55906,0.05512),(0.56693,0.05512),(0.5748,0.05512),(0.58268,0.05512),(0.59055,0.05512),(0.59843,0.05512),(0.6063,0.05512),(0.61417,0.05512),(0.62205,0.05512),(0.62992,0.05512),(0.6378,0.05512),(0.64567,0.05512),(0.65354,0.05512),(0.66142,0.05512),(0.66929,0.05512),(0.67717,0.05512),(0.68504,0.05512),(0.69291,0.05512),(0.70079,0.05512),(0.70866,0.05512),(0.71654,0.05512),(0.72441,0.05512),(0.73228,0.05512),(0.74016,0.05512),(0.74803,0.05512),(0.75591,0.05512),(0.76378,0.05512),(0.77165,0.05512),(0.77953,0.05512),(0.7874,0.05512),(0.79528,0.05512),(0.80315,0.05512),(0.81102,0.05512),(0.8189,0.05512),(0.82677,0.05512),(0.83465,0.05512),(0.84252,0.05512),(0.85039,0.05512),(0.85827,0.05512),(0.86614,0.05512),(0.87402,0.05512),(0.88189,0.05512),(0.88976,0.05512),(0.89764,0.05512),(0.90551,0.05512),(0.91339,0.05512),(0.92126,0.05512),(0.92913,0.05512),(0.93701,0.05512),(0.94488,0.05512),(0.95276,0.05512),(0.96063,0.05512),(0.9685,0.05512),(0.97638,0.05512),(0.98425,0.05512),(0.99213,0.05512),(0.99609,0.05512),(0.00391,0.06299),(0.00787,0.06299),(0.01575,0.06299),(0.02362,0.06299),(0.0315,0.06299),(0.03937,0.06299),(0.04724,0.06299),(0.05512,0.06299),(0.06299,0.06299),(0.07087,0.06299),(0.07874,0.06299),(0.08661,0.06299),(0.09449,0.06299),(0.10236,0.06299),(0.11024,0.06299),(0.11811,0.06299),(0.12598,0.06299),(0.13386,0.06299),(0.14173,0.06299),(0.14961,0.06299),(0.15748,0.06299),(0.16535,0.06299),(0.17323,0.06299),(0.1811,0.06299),(0.18898,0.06299),(0.19685,0.06299),(0.20472,0.06299),(0.2126,0.06299),(0.22047,0.06299),(0.22835,0.06299),(0.23622,0.06299),(0.24409,0.06299),(0.25197,0.06299),(0.25984,0.06299),(0.26772,0.06299),(0.27559,0.06299),(0.28346,0.06299),(0.29134,0.06299),(0.29921,0.06299),(0.30709,0.06299),(0.31496,0.06299),(0.32283,0.06299),(0.33071,0.06299),(0.33858,0.06299),(0.34646,0.06299),(0.35433,0.06299),(0.3622,0.06299),(0.37008,0.06299),(0.37795,0.06299),(0.38583,0.06299),(0.3937,0.06299),(0.40157,0.06299),(0.40945,0.06299),(0.41732,0.06299),(0.4252,0.06299),(0.43307,0.06299),(0.44094,0.06299),(0.44882,0.06299),(0.45669,0.06299),(0.46457,0.06299),(0.47244,0.06299),(0.48031,0.06299),(0.48819,0.06299),(0.49606,0.06299),(0.50394,0.06299),(0.51181,0.06299),(0.51969,0.06299),(0.52756,0.06299),(0.53543,0.06299),(0.54331,0.06299),(0.55118,0.06299),(0.55906,0.06299),(0.56693,0.06299),(0.5748,0.06299),(0.58268,0.06299),(0.59055,0.06299),(0.59843,0.06299),(0.6063,0.06299),(0.61417,0.06299),(0.62205,0.06299),(0.62992,0.06299),(0.6378,0.06299),(0.64567,0.06299),(0.65354,0.06299),(0.66142,0.06299),(0.66929,0.06299),(0.67717,0.06299),(0.68504,0.06299),(0.69291,0.06299),(0.70079,0.06299),(0.70866,0.06299),(0.71654,0.06299),(0.72441,0.06299),(0.73228,0.06299),(0.74016,0.06299),(0.74803,0.06299),(0.75591,0.06299),(0.76378,0.06299),(0.77165,0.06299),(0.77953,0.06299),(0.7874,0.06299),(0.79528,0.06299),(0.80315,0.06299),(0.81102,0.06299),(0.8189,0.06299),(0.82677,0.06299),(0.83465,0.06299),(0.84252,0.06299),(0.85039,0.06299),(0.85827,0.06299),(0.86614,0.06299),(0.87402,0.06299),(0.88189,0.06299),(0.88976,0.06299),(0.89764,0.06299),(0.90551,0.06299),(0.91339,0.06299),(0.92126,0.06299),(0.92913,0.06299),(0.93701,0.06299),(0.94488,0.06299),(0.95276,0.06299),(0.96063,0.06299),(0.9685,0.06299),(0.97638,0.06299),(0.98425,0.06299),(0.99213,0.06299),(0.99609,0.06299),(0.00391,0.07087),(0.00787,0.07087),(0.01575,0.07087),(0.02362,0.07087),(0.0315,0.07087),(0.03937,0.07087),(0.04724,0.07087),(0.05512,0.07087),(0.06299,0.07087),(0.07087,0.07087),(0.07874,0.07087),(0.08661,0.07087),(0.09449,0.07087),(0.10236,0.07087),(0.11024,0.07087),(0.11811,0.07087),(0.12598,0.07087),(0.13386,0.07087),(0.14173,0.07087),(0.14961,0.07087),(0.15748,0.07087),(0.16535,0.07087),(0.17323,0.07087),(0.1811,0.07087),(0.18898,0.07087),(0.19685,0.07087),(0.20472,0.07087),(0.2126,0.07087),(0.22047,0.07087),(0.22835,0.07087),(0.23622,0.07087),(0.24409,0.07087),(0.25197,0.07087),(0.25984,0.07087),(0.26772,0.07087),(0.27559,0.07087),(0.28346,0.07087),(0.29134,0.07087),(0.29921,0.07087),(0.30709,0.07087),(0.31496,0.07087),(0.32283,0.07087),(0.33071,0.07087),(0.33858,0.07087),(0.34646,0.07087),(0.35433,0.07087),(0.3622,0.07087),(0.37008,0.07087),(0.37795,0.07087),(0.38583,0.07087),(0.3937,0.07087),(0.40157,0.07087),(0.40945,0.07087),(0.41732,0.07087),(0.4252,0.07087),(0.43307,0.07087),(0.44094,0.07087),(0.44882,0.07087),(0.45669,0.07087),(0.46457,0.07087),(0.47244,0.07087),(0.48031,0.07087),(0.48819,0.07087),(0.49606,0.07087),(0.50394,0.07087),(0.51181,0.07087),(0.51969,0.07087),(0.52756,0.07087),(0.53543,0.07087),(0.54331,0.07087),(0.55118,0.07087),(0.55906,0.07087),(0.56693,0.07087),(0.5748,0.07087),(0.58268,0.07087),(0.59055,0.07087),(0.59843,0.07087),(0.6063,0.07087),(0.61417,0.07087),(0.62205,0.07087),(0.62992,0.07087),(0.6378,0.07087),(0.64567,0.07087),(0.65354,0.07087),(0.66142,0.07087),(0.66929,0.07087),(0.67717,0.07087),(0.68504,0.07087),(0.69291,0.07087),(0.70079,0.07087),(0.70866,0.07087),(0.71654,0.07087),(0.72441,0.07087),(0.73228,0.07087),(0.74016,0.07087),(0.74803,0.07087),(0.75591,0.07087),(0.76378,0.07087),(0.77165,0.07087),(0.77953,0.07087),(0.7874,0.07087),(0.79528,0.07087),(0.80315,0.07087),(0.81102,0.07087),(0.8189,0.07087),(0.82677,0.07087),(0.83465,0.07087),(0.84252,0.07087),(0.85039,0.07087),(0.85827,0.07087),(0.86614,0.07087),(0.87402,0.07087),(0.88189,0.07087),(0.88976,0.07087),(0.89764,0.07087),(0.90551,0.07087),(0.91339,0.07087),(0.92126,0.07087),(0.92913,0.07087),(0.93701,0.07087),(0.94488,0.07087),(0.95276,0.07087),(0.96063,0.07087),(0.9685,0.07087),(0.97638,0.07087),(0.98425,0.07087),(0.99213,0.07087),(0.99609,0.07087),(0.00391,0.07874),(0.00787,0.07874),(0.01575,0.07874),(0.02362,0.07874),(0.0315,0.07874),(0.03937,0.07874),(0.04724,0.07874),(0.05512,0.07874),(0.06299,0.07874),(0.07087,0.07874),(0.07874,0.07874),(0.08661,0.07874),(0.09449,0.07874),(0.10236,0.07874),(0.11024,0.07874),(0.11811,0.07874),(0.12598,0.07874),(0.13386,0.07874),(0.14173,0.07874),(0.14961,0.07874),(0.15748,0.07874),(0.16535,0.07874),(0.17323,0.07874),(0.1811,0.07874),(0.18898,0.07874),(0.19685,0.07874),(0.20472,0.07874),(0.2126,0.07874),(0.22047,0.07874),(0.22835,0.07874),(0.23622,0.07874),(0.24409,0.07874),(0.25197,0.07874),(0.25984,0.07874),(0.26772,0.07874),(0.27559,0.07874),(0.28346,0.07874),(0.29134,0.07874),(0.29921,0.07874),(0.30709,0.07874),(0.31496,0.07874),(0.32283,0.07874),(0.33071,0.07874),(0.33858,0.07874),(0.34646,0.07874),(0.35433,0.07874),(0.3622,0.07874),(0.37008,0.07874),(0.37795,0.07874),(0.38583,0.07874),(0.3937,0.07874),(0.40157,0.07874),(0.40945,0.07874),(0.41732,0.07874),(0.4252,0.07874),(0.43307,0.07874),(0.44094,0.07874),(0.44882,0.07874),(0.45669,0.07874),(0.46457,0.07874),(0.47244,0.07874),(0.48031,0.07874),(0.48819,0.07874),(0.49606,0.07874),(0.50394,0.07874),(0.51181,0.07874),(0.51969,0.07874),(0.52756,0.07874),(0.53543,0.07874),(0.54331,0.07874),(0.55118,0.07874),(0.55906,0.07874),(0.56693,0.07874),(0.5748,0.07874),(0.58268,0.07874),(0.59055,0.07874),(0.59843,0.07874),(0.6063,0.07874),(0.61417,0.07874),(0.62205,0.07874),(0.62992,0.07874),(0.6378,0.07874),(0.64567,0.07874),(0.65354,0.07874),(0.66142,0.07874),(0.66929,0.07874),(0.67717,0.07874),(0.68504,0.07874),(0.69291,0.07874),(0.70079,0.07874),(0.70866,0.07874),(0.71654,0.07874),(0.72441,0.07874),(0.73228,0.07874),(0.74016,0.07874),(0.74803,0.07874),(0.75591,0.07874),(0.76378,0.07874),(0.77165,0.07874),(0.77953,0.07874),(0.7874,0.07874),(0.79528,0.07874),(0.80315,0.07874),(0.81102,0.07874),(0.8189,0.07874),(0.82677,0.07874),(0.83465,0.07874),(0.84252,0.07874),(0.85039,0.07874),(0.85827,0.07874),(0.86614,0.07874),(0.87402,0.07874),(0.88189,0.07874),(0.88976,0.07874),(0.89764,0.07874),(0.90551,0.07874),(0.91339,0.07874),(0.92126,0.07874),(0.92913,0.07874),(0.93701,0.07874),(0.94488,0.07874),(0.95276,0.07874),(0.96063,0.07874),(0.9685,0.07874),(0.97638,0.07874),(0.98425,0.07874),(0.99213,0.07874),(0.99609,0.07874),(0.00391,0.08661),(0.00787,0.08661),(0.01575,0.08661),(0.02362,0.08661),(0.0315,0.08661),(0.03937,0.08661),(0.04724,0.08661),(0.05512,0.08661),(0.06299,0.08661),(0.07087,0.08661),(0.07874,0.08661),(0.08661,0.08661),(0.09449,0.08661),(0.10236,0.08661),(0.11024,0.08661),(0.11811,0.08661),(0.12598,0.08661),(0.13386,0.08661),(0.14173,0.08661),(0.14961,0.08661),(0.15748,0.08661),(0.16535,0.08661),(0.17323,0.08661),(0.1811,0.08661),(0.18898,0.08661),(0.19685,0.08661),(0.20472,0.08661),(0.2126,0.08661),(0.22047,0.08661),(0.22835,0.08661),(0.23622,0.08661),(0.24409,0.08661),(0.25197,0.08661),(0.25984,0.08661),(0.26772,0.08661),(0.27559,0.08661),(0.28346,0.08661),(0.29134,0.08661),(0.29921,0.08661),(0.30709,0.08661),(0.31496,0.08661),(0.32283,0.08661),(0.33071,0.08661),(0.33858,0.08661),(0.34646,0.08661),(0.35433,0.08661),(0.3622,0.08661),(0.37008,0.08661),(0.37795,0.08661),(0.38583,0.08661),(0.3937,0.08661),(0.40157,0.08661),(0.40945,0.08661),(0.41732,0.08661),(0.4252,0.08661),(0.43307,0.08661),(0.44094,0.08661),(0.44882,0.08661),(0.45669,0.08661),(0.46457,0.08661),(0.47244,0.08661),(0.48031,0.08661),(0.48819,0.08661),(0.49606,0.08661),(0.50394,0.08661),(0.51181,0.08661),(0.51969,0.08661),(0.52756,0.08661),(0.53543,0.08661),(0.54331,0.08661),(0.55118,0.08661),(0.55906,0.08661),(0.56693,0.08661),(0.5748,0.08661),(0.58268,0.08661),(0.59055,0.08661),(0.59843,0.08661),(0.6063,0.08661),(0.61417,0.08661),(0.62205,0.08661),(0.62992,0.08661),(0.6378,0.08661),(0.64567,0.08661),(0.65354,0.08661),(0.66142,0.08661),(0.66929,0.08661),(0.67717,0.08661),(0.68504,0.08661),(0.69291,0.08661),(0.70079,0.08661),(0.70866,0.08661),(0.71654,0.08661),(0.72441,0.08661),(0.73228,0.08661),(0.74016,0.08661),(0.74803,0.08661),(0.75591,0.08661),(0.76378,0.08661),(0.77165,0.08661),(0.77953,0.08661),(0.7874,0.08661),(0.79528,0.08661),(0.80315,0.08661),(0.81102,0.08661),(0.8189,0.08661),(0.82677,0.08661),(0.83465,0.08661),(0.84252,0.08661),(0.85039,0.08661),(0.85827,0.08661),(0.86614,0.08661),(0.87402,0.08661),(0.88189,0.08661),(0.88976,0.08661),(0.89764,0.08661),(0.90551,0.08661),(0.91339,0.08661),(0.92126,0.08661),(0.92913,0.08661),(0.93701,0.08661),(0.94488,0.08661),(0.95276,0.08661),(0.96063,0.08661),(0.9685,0.08661),(0.97638,0.08661),(0.98425,0.08661),(0.99213,0.08661),(0.99609,0.08661),(0.00391,0.09449),(0.00787,0.09449),(0.01575,0.09449),(0.02362,0.09449),(0.0315,0.09449),(0.03937,0.09449),(0.04724,0.09449),(0.05512,0.09449),(0.06299,0.09449),(0.07087,0.09449),(0.07874,0.09449),(0.08661,0.09449),(0.09449,0.09449),(0.10236,0.09449),(0.11024,0.09449),(0.11811,0.09449),(0.12598,0.09449),(0.13386,0.09449),(0.14173,0.09449),(0.14961,0.09449),(0.15748,0.09449),(0.16535,0.09449),(0.17323,0.09449),(0.1811,0.09449),(0.18898,0.09449),(0.19685,0.09449),(0.20472,0.09449),(0.2126,0.09449),(0.22047,0.09449),(0.22835,0.09449),(0.23622,0.09449),(0.24409,0.09449),(0.25197,0.09449),(0.25984,0.09449),(0.26772,0.09449),(0.27559,0.09449),(0.28346,0.09449),(0.29134,0.09449),(0.29921,0.09449),(0.30709,0.09449),(0.31496,0.09449),(0.32283,0.09449),(0.33071,0.09449),(0.33858,0.09449),(0.34646,0.09449),(0.35433,0.09449),(0.3622,0.09449),(0.37008,0.09449),(0.37795,0.09449),(0.38583,0.09449),(0.3937,0.09449),(0.40157,0.09449),(0.40945,0.09449),(0.41732,0.09449),(0.4252,0.09449),(0.43307,0.09449),(0.44094,0.09449),(0.44882,0.09449),(0.45669,0.09449),(0.46457,0.09449),(0.47244,0.09449),(0.48031,0.09449),(0.48819,0.09449),(0.49606,0.09449),(0.50394,0.09449),(0.51181,0.09449),(0.51969,0.09449),(0.52756,0.09449),(0.53543,0.09449),(0.54331,0.09449),(0.55118,0.09449),(0.55906,0.09449),(0.56693,0.09449),(0.5748,0.09449),(0.58268,0.09449),(0.59055,0.09449),(0.59843,0.09449),(0.6063,0.09449),(0.61417,0.09449),(0.62205,0.09449),(0.62992,0.09449),(0.6378,0.09449),(0.64567,0.09449),(0.65354,0.09449),(0.66142,0.09449),(0.66929,0.09449),(0.67717,0.09449),(0.68504,0.09449),(0.69291,0.09449),(0.70079,0.09449),(0.70866,0.09449),(0.71654,0.09449),(0.72441,0.09449),(0.73228,0.09449),(0.74016,0.09449),(0.74803,0.09449),(0.75591,0.09449),(0.76378,0.09449),(0.77165,0.09449),(0.77953,0.09449),(0.7874,0.09449),(0.79528,0.09449),(0.80315,0.09449),(0.81102,0.09449),(0.8189,0.09449),(0.82677,0.09449),(0.83465,0.09449),(0.84252,0.09449),(0.85039,0.09449),(0.85827,0.09449),(0.86614,0.09449),(0.87402,0.09449),(0.88189,0.09449),(0.88976,0.09449),(0.89764,0.09449),(0.90551,0.09449),(0.91339,0.09449),(0.92126,0.09449),(0.92913,0.09449),(0.93701,0.09449),(0.94488,0.09449),(0.95276,0.09449),(0.96063,0.09449),(0.9685,0.09449),(0.97638,0.09449),(0.98425,0.09449),(0.99213,0.09449),(0.99609,0.09449),(0.00391,0.10236),(0.00787,0.10236),(0.01575,0.10236),(0.02362,0.10236),(0.0315,0.10236),(0.03937,0.10236),(0.04724,0.10236),(0.05512,0.10236),(0.06299,0.10236),(0.07087,0.10236),(0.07874,0.10236),(0.08661,0.10236),(0.09449,0.10236),(0.10236,0.10236),(0.11024,0.10236),(0.11811,0.10236),(0.12598,0.10236),(0.13386,0.10236),(0.14173,0.10236),(0.14961,0.10236),(0.15748,0.10236),(0.16535,0.10236),(0.17323,0.10236),(0.1811,0.10236),(0.18898,0.10236),(0.19685,0.10236),(0.20472,0.10236),(0.2126,0.10236),(0.22047,0.10236),(0.22835,0.10236),(0.23622,0.10236),(0.24409,0.10236),(0.25197,0.10236),(0.25984,0.10236),(0.26772,0.10236),(0.27559,0.10236),(0.28346,0.10236),(0.29134,0.10236),(0.29921,0.10236),(0.30709,0.10236),(0.31496,0.10236),(0.32283,0.10236),(0.33071,0.10236),(0.33858,0.10236),(0.34646,0.10236),(0.35433,0.10236),(0.3622,0.10236),(0.37008,0.10236),(0.37795,0.10236),(0.38583,0.10236),(0.3937,0.10236),(0.40157,0.10236),(0.40945,0.10236),(0.41732,0.10236),(0.4252,0.10236),(0.43307,0.10236),(0.44094,0.10236),(0.44882,0.10236),(0.45669,0.10236),(0.46457,0.10236),(0.47244,0.10236),(0.48031,0.10236),(0.48819,0.10236),(0.49606,0.10236),(0.50394,0.10236),(0.51181,0.10236),(0.51969,0.10236),(0.52756,0.10236),(0.53543,0.10236),(0.54331,0.10236),(0.55118,0.10236),(0.55906,0.10236),(0.56693,0.10236),(0.5748,0.10236),(0.58268,0.10236),(0.59055,0.10236),(0.59843,0.10236),(0.6063,0.10236),(0.61417,0.10236),(0.62205,0.10236),(0.62992,0.10236),(0.6378,0.10236),(0.64567,0.10236),(0.65354,0.10236),(0.66142,0.10236),(0.66929,0.10236),(0.67717,0.10236),(0.68504,0.10236),(0.69291,0.10236),(0.70079,0.10236),(0.70866,0.10236),(0.71654,0.10236),(0.72441,0.10236),(0.73228,0.10236),(0.74016,0.10236),(0.74803,0.10236),(0.75591,0.10236),(0.76378,0.10236),(0.77165,0.10236),(0.77953,0.10236),(0.7874,0.10236),(0.79528,0.10236),(0.80315,0.10236),(0.81102,0.10236),(0.8189,0.10236),(0.82677,0.10236),(0.83465,0.10236),(0.84252,0.10236),(0.85039,0.10236),(0.85827,0.10236),(0.86614,0.10236),(0.87402,0.10236),(0.88189,0.10236),(0.88976,0.10236),(0.89764,0.10236),(0.90551,0.10236),(0.91339,0.10236),(0.92126,0.10236),(0.92913,0.10236),(0.93701,0.10236),(0.94488,0.10236),(0.95276,0.10236),(0.96063,0.10236),(0.9685,0.10236),(0.97638,0.10236),(0.98425,0.10236),(0.99213,0.10236),(0.99609,0.10236),(0.00391,0.11024),(0.00787,0.11024),(0.01575,0.11024),(0.02362,0.11024),(0.0315,0.11024),(0.03937,0.11024),(0.04724,0.11024),(0.05512,0.11024),(0.06299,0.11024),(0.07087,0.11024),(0.07874,0.11024),(0.08661,0.11024),(0.09449,0.11024),(0.10236,0.11024),(0.11024,0.11024),(0.11811,0.11024),(0.12598,0.11024),(0.13386,0.11024),(0.14173,0.11024),(0.14961,0.11024),(0.15748,0.11024),(0.16535,0.11024),(0.17323,0.11024),(0.1811,0.11024),(0.18898,0.11024),(0.19685,0.11024),(0.20472,0.11024),(0.2126,0.11024),(0.22047,0.11024),(0.22835,0.11024),(0.23622,0.11024),(0.24409,0.11024),(0.25197,0.11024),(0.25984,0.11024),(0.26772,0.11024),(0.27559,0.11024),(0.28346,0.11024),(0.29134,0.11024),(0.29921,0.11024),(0.30709,0.11024),(0.31496,0.11024),(0.32283,0.11024),(0.33071,0.11024),(0.33858,0.11024),(0.34646,0.11024),(0.35433,0.11024),(0.3622,0.11024),(0.37008,0.11024),(0.37795,0.11024),(0.38583,0.11024),(0.3937,0.11024),(0.40157,0.11024),(0.40945,0.11024),(0.41732,0.11024),(0.4252,0.11024),(0.43307,0.11024),(0.44094,0.11024),(0.44882,0.11024),(0.45669,0.11024),(0.46457,0.11024),(0.47244,0.11024),(0.48031,0.11024),(0.48819,0.11024),(0.49606,0.11024),(0.50394,0.11024),(0.51181,0.11024),(0.51969,0.11024),(0.52756,0.11024),(0.53543,0.11024),(0.54331,0.11024),(0.55118,0.11024),(0.55906,0.11024),(0.56693,0.11024),(0.5748,0.11024),(0.58268,0.11024),(0.59055,0.11024),(0.59843,0.11024),(0.6063,0.11024),(0.61417,0.11024),(0.62205,0.11024),(0.62992,0.11024),(0.6378,0.11024),(0.64567,0.11024),(0.65354,0.11024),(0.66142,0.11024),(0.66929,0.11024),(0.67717,0.11024),(0.68504,0.11024),(0.69291,0.11024),(0.70079,0.11024),(0.70866,0.11024),(0.71654,0.11024),(0.72441,0.11024),(0.73228,0.11024),(0.74016,0.11024),(0.74803,0.11024),(0.75591,0.11024),(0.76378,0.11024),(0.77165,0.11024),(0.77953,0.11024),(0.7874,0.11024),(0.79528,0.11024),(0.80315,0.11024),(0.81102,0.11024),(0.8189,0.11024),(0.82677,0.11024),(0.83465,0.11024),(0.84252,0.11024),(0.85039,0.11024),(0.85827,0.11024),(0.86614,0.11024),(0.87402,0.11024),(0.88189,0.11024),(0.88976,0.11024),(0.89764,0.11024),(0.90551,0.11024),(0.91339,0.11024),(0.92126,0.11024),(0.92913,0.11024),(0.93701,0.11024),(0.94488,0.11024),(0.95276,0.11024),(0.96063,0.11024),(0.9685,0.11024),(0.97638,0.11024),(0.98425,0.11024),(0.99213,0.11024),(0.99609,0.11024),(0.00391,0.11811),(0.00787,0.11811),(0.01575,0.11811),(0.02362,0.11811),(0.0315,0.11811),(0.03937,0.11811),(0.04724,0.11811),(0.05512,0.11811),(0.06299,0.11811),(0.07087,0.11811),(0.07874,0.11811),(0.08661,0.11811),(0.09449,0.11811),(0.10236,0.11811),(0.11024,0.11811),(0.11811,0.11811),(0.12598,0.11811),(0.13386,0.11811),(0.14173,0.11811),(0.14961,0.11811),(0.15748,0.11811),(0.16535,0.11811),(0.17323,0.11811),(0.1811,0.11811),(0.18898,0.11811),(0.19685,0.11811),(0.20472,0.11811),(0.2126,0.11811),(0.22047,0.11811),(0.22835,0.11811),(0.23622,0.11811),(0.24409,0.11811),(0.25197,0.11811),(0.25984,0.11811),(0.26772,0.11811),(0.27559,0.11811),(0.28346,0.11811),(0.29134,0.11811),(0.29921,0.11811),(0.30709,0.11811),(0.31496,0.11811),(0.32283,0.11811),(0.33071,0.11811),(0.33858,0.11811),(0.34646,0.11811),(0.35433,0.11811),(0.3622,0.11811),(0.37008,0.11811),(0.37795,0.11811),(0.38583,0.11811),(0.3937,0.11811),(0.40157,0.11811),(0.40945,0.11811),(0.41732,0.11811),(0.4252,0.11811),(0.43307,0.11811),(0.44094,0.11811),(0.44882,0.11811),(0.45669,0.11811),(0.46457,0.11811),(0.47244,0.11811),(0.48031,0.11811),(0.48819,0.11811),(0.49606,0.11811),(0.50394,0.11811),(0.51181,0.11811),(0.51969,0.11811),(0.52756,0.11811),(0.53543,0.11811),(0.54331,0.11811),(0.55118,0.11811),(0.55906,0.11811),(0.56693,0.11811),(0.5748,0.11811),(0.58268,0.11811),(0.59055,0.11811),(0.59843,0.11811),(0.6063,0.11811),(0.61417,0.11811),(0.62205,0.11811),(0.62992,0.11811),(0.6378,0.11811),(0.64567,0.11811),(0.65354,0.11811),(0.66142,0.11811),(0.66929,0.11811),(0.67717,0.11811),(0.68504,0.11811),(0.69291,0.11811),(0.70079,0.11811),(0.70866,0.11811),(0.71654,0.11811),(0.72441,0.11811),(0.73228,0.11811),(0.74016,0.11811),(0.74803,0.11811),(0.75591,0.11811),(0.76378,0.11811),(0.77165,0.11811),(0.77953,0.11811),(0.7874,0.11811),(0.79528,0.11811),(0.80315,0.11811),(0.81102,0.11811),(0.8189,0.11811),(0.82677,0.11811),(0.83465,0.11811),(0.84252,0.11811),(0.85039,0.11811),(0.85827,0.11811),(0.86614,0.11811),(0.87402,0.11811),(0.88189,0.11811),(0.88976,0.11811),(0.89764,0.11811),(0.90551,0.11811),(0.91339,0.11811),(0.92126,0.11811),(0.92913,0.11811),(0.93701,0.11811),(0.94488,0.11811),(0.95276,0.11811),(0.96063,0.11811),(0.9685,0.11811),(0.97638,0.11811),(0.98425,0.11811),(0.99213,0.11811),(0.99609,0.11811),(0.00391,0.12598),(0.00787,0.12598),(0.01575,0.12598),(0.02362,0.12598),(0.0315,0.12598),(0.03937,0.12598),(0.04724,0.12598),(0.05512,0.12598),(0.06299,0.12598),(0.07087,0.12598),(0.07874,0.12598),(0.08661,0.12598),(0.09449,0.12598),(0.10236,0.12598),(0.11024,0.12598),(0.11811,0.12598),(0.12598,0.12598),(0.13386,0.12598),(0.14173,0.12598),(0.14961,0.12598),(0.15748,0.12598),(0.16535,0.12598),(0.17323,0.12598),(0.1811,0.12598),(0.18898,0.12598),(0.19685,0.12598),(0.20472,0.12598),(0.2126,0.12598),(0.22047,0.12598),(0.22835,0.12598),(0.23622,0.12598),(0.24409,0.12598),(0.25197,0.12598),(0.25984,0.12598),(0.26772,0.12598),(0.27559,0.12598),(0.28346,0.12598),(0.29134,0.12598),(0.29921,0.12598),(0.30709,0.12598),(0.31496,0.12598),(0.32283,0.12598),(0.33071,0.12598),(0.33858,0.12598),(0.34646,0.12598),(0.35433,0.12598),(0.3622,0.12598),(0.37008,0.12598),(0.37795,0.12598),(0.38583,0.12598),(0.3937,0.12598),(0.40157,0.12598),(0.40945,0.12598),(0.41732,0.12598),(0.4252,0.12598),(0.43307,0.12598),(0.44094,0.12598),(0.44882,0.12598),(0.45669,0.12598),(0.46457,0.12598),(0.47244,0.12598),(0.48031,0.12598),(0.48819,0.12598),(0.49606,0.12598),(0.50394,0.12598),(0.51181,0.12598),(0.51969,0.12598),(0.52756,0.12598),(0.53543,0.12598),(0.54331,0.12598),(0.55118,0.12598),(0.55906,0.12598),(0.56693,0.12598),(0.5748,0.12598),(0.58268,0.12598),(0.59055,0.12598),(0.59843,0.12598),(0.6063,0.12598),(0.61417,0.12598),(0.62205,0.12598),(0.62992,0.12598),(0.6378,0.12598),(0.64567,0.12598),(0.65354,0.12598),(0.66142,0.12598),(0.66929,0.12598),(0.67717,0.12598),(0.68504,0.12598),(0.69291,0.12598),(0.70079,0.12598),(0.70866,0.12598),(0.71654,0.12598),(0.72441,0.12598),(0.73228,0.12598),(0.74016,0.12598),(0.74803,0.12598),(0.75591,0.12598),(0.76378,0.12598),(0.77165,0.12598),(0.77953,0.12598),(0.7874,0.12598),(0.79528,0.12598),(0.80315,0.12598),(0.81102,0.12598),(0.8189,0.12598),(0.82677,0.12598),(0.83465,0.12598),(0.84252,0.12598),(0.85039,0.12598),(0.85827,0.12598),(0.86614,0.12598),(0.87402,0.12598),(0.88189,0.12598),(0.88976,0.12598),(0.89764,0.12598),(0.90551,0.12598),(0.91339,0.12598),(0.92126,0.12598),(0.92913,0.12598),(0.93701,0.12598),(0.94488,0.12598),(0.95276,0.12598),(0.96063,0.12598),(0.9685,0.12598),(0.97638,0.12598),(0.98425,0.12598),(0.99213,0.12598),(0.99609,0.12598),(0.00391,0.13386),(0.00787,0.13386),(0.01575,0.13386),(0.02362,0.13386),(0.0315,0.13386),(0.03937,0.13386),(0.04724,0.13386),(0.05512,0.13386),(0.06299,0.13386),(0.07087,0.13386),(0.07874,0.13386),(0.08661,0.13386),(0.09449,0.13386),(0.10236,0.13386),(0.11024,0.13386),(0.11811,0.13386),(0.12598,0.13386),(0.13386,0.13386),(0.14173,0.13386),(0.14961,0.13386),(0.15748,0.13386),(0.16535,0.13386),(0.17323,0.13386),(0.1811,0.13386),(0.18898,0.13386),(0.19685,0.13386),(0.20472,0.13386),(0.2126,0.13386),(0.22047,0.13386),(0.22835,0.13386),(0.23622,0.13386),(0.24409,0.13386),(0.25197,0.13386),(0.25984,0.13386),(0.26772,0.13386),(0.27559,0.13386),(0.28346,0.13386),(0.29134,0.13386),(0.29921,0.13386),(0.30709,0.13386),(0.31496,0.13386),(0.32283,0.13386),(0.33071,0.13386),(0.33858,0.13386),(0.34646,0.13386),(0.35433,0.13386),(0.3622,0.13386),(0.37008,0.13386),(0.37795,0.13386),(0.38583,0.13386),(0.3937,0.13386),(0.40157,0.13386),(0.40945,0.13386),(0.41732,0.13386),(0.4252,0.13386),(0.43307,0.13386),(0.44094,0.13386),(0.44882,0.13386),(0.45669,0.13386),(0.46457,0.13386),(0.47244,0.13386),(0.48031,0.13386),(0.48819,0.13386),(0.49606,0.13386),(0.50394,0.13386),(0.51181,0.13386),(0.51969,0.13386),(0.52756,0.13386),(0.53543,0.13386),(0.54331,0.13386),(0.55118,0.13386),(0.55906,0.13386),(0.56693,0.13386),(0.5748,0.13386),(0.58268,0.13386),(0.59055,0.13386),(0.59843,0.13386),(0.6063,0.13386),(0.61417,0.13386),(0.62205,0.13386),(0.62992,0.13386),(0.6378,0.13386),(0.64567,0.13386),(0.65354,0.13386),(0.66142,0.13386),(0.66929,0.13386),(0.67717,0.13386),(0.68504,0.13386),(0.69291,0.13386),(0.70079,0.13386),(0.70866,0.13386),(0.71654,0.13386),(0.72441,0.13386),(0.73228,0.13386),(0.74016,0.13386),(0.74803,0.13386),(0.75591,0.13386),(0.76378,0.13386),(0.77165,0.13386),(0.77953,0.13386),(0.7874,0.13386),(0.79528,0.13386),(0.80315,0.13386),(0.81102,0.13386),(0.8189,0.13386),(0.82677,0.13386),(0.83465,0.13386),(0.84252,0.13386),(0.85039,0.13386),(0.85827,0.13386),(0.86614,0.13386),(0.87402,0.13386),(0.88189,0.13386),(0.88976,0.13386),(0.89764,0.13386),(0.90551,0.13386),(0.91339,0.13386),(0.92126,0.13386),(0.92913,0.13386),(0.93701,0.13386),(0.94488,0.13386),(0.95276,0.13386),(0.96063,0.13386),(0.9685,0.13386),(0.97638,0.13386),(0.98425,0.13386),(0.99213,0.13386),(0.99609,0.13386),(0.00391,0.14173),(0.00787,0.14173),(0.01575,0.14173),(0.02362,0.14173),(0.0315,0.14173),(0.03937,0.14173),(0.04724,0.14173),(0.05512,0.14173),(0.06299,0.14173),(0.07087,0.14173),(0.07874,0.14173),(0.08661,0.14173),(0.09449,0.14173),(0.10236,0.14173),(0.11024,0.14173),(0.11811,0.14173),(0.12598,0.14173),(0.13386,0.14173),(0.14173,0.14173),(0.14961,0.14173),(0.15748,0.14173),(0.16535,0.14173),(0.17323,0.14173),(0.1811,0.14173),(0.18898,0.14173),(0.19685,0.14173),(0.20472,0.14173),(0.2126,0.14173),(0.22047,0.14173),(0.22835,0.14173),(0.23622,0.14173),(0.24409,0.14173),(0.25197,0.14173),(0.25984,0.14173),(0.26772,0.14173),(0.27559,0.14173),(0.28346,0.14173),(0.29134,0.14173),(0.29921,0.14173),(0.30709,0.14173),(0.31496,0.14173),(0.32283,0.14173),(0.33071,0.14173),(0.33858,0.14173),(0.34646,0.14173),(0.35433,0.14173),(0.3622,0.14173),(0.37008,0.14173),(0.37795,0.14173),(0.38583,0.14173),(0.3937,0.14173),(0.40157,0.14173),(0.40945,0.14173),(0.41732,0.14173),(0.4252,0.14173),(0.43307,0.14173),(0.44094,0.14173),(0.44882,0.14173),(0.45669,0.14173),(0.46457,0.14173),(0.47244,0.14173),(0.48031,0.14173),(0.48819,0.14173),(0.49606,0.14173),(0.50394,0.14173),(0.51181,0.14173),(0.51969,0.14173),(0.52756,0.14173),(0.53543,0.14173),(0.54331,0.14173),(0.55118,0.14173),(0.55906,0.14173),(0.56693,0.14173),(0.5748,0.14173),(0.58268,0.14173),(0.59055,0.14173),(0.59843,0.14173),(0.6063,0.14173),(0.61417,0.14173),(0.62205,0.14173),(0.62992,0.14173),(0.6378,0.14173),(0.64567,0.14173),(0.65354,0.14173),(0.66142,0.14173),(0.66929,0.14173),(0.67717,0.14173),(0.68504,0.14173),(0.69291,0.14173),(0.70079,0.14173),(0.70866,0.14173),(0.71654,0.14173),(0.72441,0.14173),(0.73228,0.14173),(0.74016,0.14173),(0.74803,0.14173),(0.75591,0.14173),(0.76378,0.14173),(0.77165,0.14173),(0.77953,0.14173),(0.7874,0.14173),(0.79528,0.14173),(0.80315,0.14173),(0.81102,0.14173),(0.8189,0.14173),(0.82677,0.14173),(0.83465,0.14173),(0.84252,0.14173),(0.85039,0.14173),(0.85827,0.14173),(0.86614,0.14173),(0.87402,0.14173),(0.88189,0.14173),(0.88976,0.14173),(0.89764,0.14173),(0.90551,0.14173),(0.91339,0.14173),(0.92126,0.14173),(0.92913,0.14173),(0.93701,0.14173),(0.94488,0.14173),(0.95276,0.14173),(0.96063,0.14173),(0.9685,0.14173),(0.97638,0.14173),(0.98425,0.14173),(0.99213,0.14173),(0.99609,0.14173),(0.00391,0.14961),(0.00787,0.14961),(0.01575,0.14961),(0.02362,0.14961),(0.0315,0.14961),(0.03937,0.14961),(0.04724,0.14961),(0.05512,0.14961),(0.06299,0.14961),(0.07087,0.14961),(0.07874,0.14961),(0.08661,0.14961),(0.09449,0.14961),(0.10236,0.14961),(0.11024,0.14961),(0.11811,0.14961),(0.12598,0.14961),(0.13386,0.14961),(0.14173,0.14961),(0.14961,0.14961),(0.15748,0.14961),(0.16535,0.14961),(0.17323,0.14961),(0.1811,0.14961),(0.18898,0.14961),(0.19685,0.14961),(0.20472,0.14961),(0.2126,0.14961),(0.22047,0.14961),(0.22835,0.14961),(0.23622,0.14961),(0.24409,0.14961),(0.25197,0.14961),(0.25984,0.14961),(0.26772,0.14961),(0.27559,0.14961),(0.28346,0.14961),(0.29134,0.14961),(0.29921,0.14961),(0.30709,0.14961),(0.31496,0.14961),(0.32283,0.14961),(0.33071,0.14961),(0.33858,0.14961),(0.34646,0.14961),(0.35433,0.14961),(0.3622,0.14961),(0.37008,0.14961),(0.37795,0.14961),(0.38583,0.14961),(0.3937,0.14961),(0.40157,0.14961),(0.40945,0.14961),(0.41732,0.14961),(0.4252,0.14961),(0.43307,0.14961),(0.44094,0.14961),(0.44882,0.14961),(0.45669,0.14961),(0.46457,0.14961),(0.47244,0.14961),(0.48031,0.14961),(0.48819,0.14961),(0.49606,0.14961),(0.50394,0.14961),(0.51181,0.14961),(0.51969,0.14961),(0.52756,0.14961),(0.53543,0.14961),(0.54331,0.14961),(0.55118,0.14961),(0.55906,0.14961),(0.56693,0.14961),(0.5748,0.14961),(0.58268,0.14961),(0.59055,0.14961),(0.59843,0.14961),(0.6063,0.14961),(0.61417,0.14961),(0.62205,0.14961),(0.62992,0.14961),(0.6378,0.14961),(0.64567,0.14961),(0.65354,0.14961),(0.66142,0.14961),(0.66929,0.14961),(0.67717,0.14961),(0.68504,0.14961),(0.69291,0.14961),(0.70079,0.14961),(0.70866,0.14961),(0.71654,0.14961),(0.72441,0.14961),(0.73228,0.14961),(0.74016,0.14961),(0.74803,0.14961),(0.75591,0.14961),(0.76378,0.14961),(0.77165,0.14961),(0.77953,0.14961),(0.7874,0.14961),(0.79528,0.14961),(0.80315,0.14961),(0.81102,0.14961),(0.8189,0.14961),(0.82677,0.14961),(0.83465,0.14961),(0.84252,0.14961),(0.85039,0.14961),(0.85827,0.14961),(0.86614,0.14961),(0.87402,0.14961),(0.88189,0.14961),(0.88976,0.14961),(0.89764,0.14961),(0.90551,0.14961),(0.91339,0.14961),(0.92126,0.14961),(0.92913,0.14961),(0.93701,0.14961),(0.94488,0.14961),(0.95276,0.14961),(0.96063,0.14961),(0.9685,0.14961),(0.97638,0.14961),(0.98425,0.14961),(0.99213,0.14961),(0.99609,0.14961),(0.00391,0.15748),(0.00787,0.15748),(0.01575,0.15748),(0.02362,0.15748),(0.0315,0.15748),(0.03937,0.15748),(0.04724,0.15748),(0.05512,0.15748),(0.06299,0.15748),(0.07087,0.15748),(0.07874,0.15748),(0.08661,0.15748),(0.09449,0.15748),(0.10236,0.15748),(0.11024,0.15748),(0.11811,0.15748),(0.12598,0.15748),(0.13386,0.15748),(0.14173,0.15748),(0.14961,0.15748),(0.15748,0.15748),(0.16535,0.15748),(0.17323,0.15748),(0.1811,0.15748),(0.18898,0.15748),(0.19685,0.15748),(0.20472,0.15748),(0.2126,0.15748),(0.22047,0.15748),(0.22835,0.15748),(0.23622,0.15748),(0.24409,0.15748),(0.25197,0.15748),(0.25984,0.15748),(0.26772,0.15748),(0.27559,0.15748),(0.28346,0.15748),(0.29134,0.15748),(0.29921,0.15748),(0.30709,0.15748),(0.31496,0.15748),(0.32283,0.15748),(0.33071,0.15748),(0.33858,0.15748),(0.34646,0.15748),(0.35433,0.15748),(0.3622,0.15748),(0.37008,0.15748),(0.37795,0.15748),(0.38583,0.15748),(0.3937,0.15748),(0.40157,0.15748),(0.40945,0.15748),(0.41732,0.15748),(0.4252,0.15748),(0.43307,0.15748),(0.44094,0.15748),(0.44882,0.15748),(0.45669,0.15748),(0.46457,0.15748),(0.47244,0.15748),(0.48031,0.15748),(0.48819,0.15748),(0.49606,0.15748),(0.50394,0.15748),(0.51181,0.15748),(0.51969,0.15748),(0.52756,0.15748),(0.53543,0.15748),(0.54331,0.15748),(0.55118,0.15748),(0.55906,0.15748),(0.56693,0.15748),(0.5748,0.15748),(0.58268,0.15748),(0.59055,0.15748),(0.59843,0.15748),(0.6063,0.15748),(0.61417,0.15748),(0.62205,0.15748),(0.62992,0.15748),(0.6378,0.15748),(0.64567,0.15748),(0.65354,0.15748),(0.66142,0.15748),(0.66929,0.15748),(0.67717,0.15748),(0.68504,0.15748),(0.69291,0.15748),(0.70079,0.15748),(0.70866,0.15748),(0.71654,0.15748),(0.72441,0.15748),(0.73228,0.15748),(0.74016,0.15748),(0.74803,0.15748),(0.75591,0.15748),(0.76378,0.15748),(0.77165,0.15748),(0.77953,0.15748),(0.7874,0.15748),(0.79528,0.15748),(0.80315,0.15748),(0.81102,0.15748),(0.8189,0.15748),(0.82677,0.15748),(0.83465,0.15748),(0.84252,0.15748),(0.85039,0.15748),(0.85827,0.15748),(0.86614,0.15748),(0.87402,0.15748),(0.88189,0.15748),(0.88976,0.15748),(0.89764,0.15748),(0.90551,0.15748),(0.91339,0.15748),(0.92126,0.15748),(0.92913,0.15748),(0.93701,0.15748),(0.94488,0.15748),(0.95276,0.15748),(0.96063,0.15748),(0.9685,0.15748),(0.97638,0.15748),(0.98425,0.15748),(0.99213,0.15748),(0.99609,0.15748),(0.00391,0.16535),(0.00787,0.16535),(0.01575,0.16535),(0.02362,0.16535),(0.0315,0.16535),(0.03937,0.16535),(0.04724,0.16535),(0.05512,0.16535),(0.06299,0.16535),(0.07087,0.16535),(0.07874,0.16535),(0.08661,0.16535),(0.09449,0.16535),(0.10236,0.16535),(0.11024,0.16535),(0.11811,0.16535),(0.12598,0.16535),(0.13386,0.16535),(0.14173,0.16535),(0.14961,0.16535),(0.15748,0.16535),(0.16535,0.16535),(0.17323,0.16535),(0.1811,0.16535),(0.18898,0.16535),(0.19685,0.16535),(0.20472,0.16535),(0.2126,0.16535),(0.22047,0.16535),(0.22835,0.16535),(0.23622,0.16535),(0.24409,0.16535),(0.25197,0.16535),(0.25984,0.16535),(0.26772,0.16535),(0.27559,0.16535),(0.28346,0.16535),(0.29134,0.16535),(0.29921,0.16535),(0.30709,0.16535),(0.31496,0.16535),(0.32283,0.16535),(0.33071,0.16535),(0.33858,0.16535),(0.34646,0.16535),(0.35433,0.16535),(0.3622,0.16535),(0.37008,0.16535),(0.37795,0.16535),(0.38583,0.16535),(0.3937,0.16535),(0.40157,0.16535),(0.40945,0.16535),(0.41732,0.16535),(0.4252,0.16535),(0.43307,0.16535),(0.44094,0.16535),(0.44882,0.16535),(0.45669,0.16535),(0.46457,0.16535),(0.47244,0.16535),(0.48031,0.16535),(0.48819,0.16535),(0.49606,0.16535),(0.50394,0.16535),(0.51181,0.16535),(0.51969,0.16535),(0.52756,0.16535),(0.53543,0.16535),(0.54331,0.16535),(0.55118,0.16535),(0.55906,0.16535),(0.56693,0.16535),(0.5748,0.16535),(0.58268,0.16535),(0.59055,0.16535),(0.59843,0.16535),(0.6063,0.16535),(0.61417,0.16535),(0.62205,0.16535),(0.62992,0.16535),(0.6378,0.16535),(0.64567,0.16535),(0.65354,0.16535),(0.66142,0.16535),(0.66929,0.16535),(0.67717,0.16535),(0.68504,0.16535),(0.69291,0.16535),(0.70079,0.16535),(0.70866,0.16535),(0.71654,0.16535),(0.72441,0.16535),(0.73228,0.16535),(0.74016,0.16535),(0.74803,0.16535),(0.75591,0.16535),(0.76378,0.16535),(0.77165,0.16535),(0.77953,0.16535),(0.7874,0.16535),(0.79528,0.16535),(0.80315,0.16535),(0.81102,0.16535),(0.8189,0.16535),(0.82677,0.16535),(0.83465,0.16535),(0.84252,0.16535),(0.85039,0.16535),(0.85827,0.16535),(0.86614,0.16535),(0.87402,0.16535),(0.88189,0.16535),(0.88976,0.16535),(0.89764,0.16535),(0.90551,0.16535),(0.91339,0.16535),(0.92126,0.16535),(0.92913,0.16535),(0.93701,0.16535),(0.94488,0.16535),(0.95276,0.16535),(0.96063,0.16535),(0.9685,0.16535),(0.97638,0.16535),(0.98425,0.16535),(0.99213,0.16535),(0.99609,0.16535),(0.00391,0.17323),(0.00787,0.17323),(0.01575,0.17323),(0.02362,0.17323),(0.0315,0.17323),(0.03937,0.17323),(0.04724,0.17323),(0.05512,0.17323),(0.06299,0.17323),(0.07087,0.17323),(0.07874,0.17323),(0.08661,0.17323),(0.09449,0.17323),(0.10236,0.17323),(0.11024,0.17323),(0.11811,0.17323),(0.12598,0.17323),(0.13386,0.17323),(0.14173,0.17323),(0.14961,0.17323),(0.15748,0.17323),(0.16535,0.17323),(0.17323,0.17323),(0.1811,0.17323),(0.18898,0.17323),(0.19685,0.17323),(0.20472,0.17323),(0.2126,0.17323),(0.22047,0.17323),(0.22835,0.17323),(0.23622,0.17323),(0.24409,0.17323),(0.25197,0.17323),(0.25984,0.17323),(0.26772,0.17323),(0.27559,0.17323),(0.28346,0.17323),(0.29134,0.17323),(0.29921,0.17323),(0.30709,0.17323),(0.31496,0.17323),(0.32283,0.17323),(0.33071,0.17323),(0.33858,0.17323),(0.34646,0.17323),(0.35433,0.17323),(0.3622,0.17323),(0.37008,0.17323),(0.37795,0.17323),(0.38583,0.17323),(0.3937,0.17323),(0.40157,0.17323),(0.40945,0.17323),(0.41732,0.17323),(0.4252,0.17323),(0.43307,0.17323),(0.44094,0.17323),(0.44882,0.17323),(0.45669,0.17323),(0.46457,0.17323),(0.47244,0.17323),(0.48031,0.17323),(0.48819,0.17323),(0.49606,0.17323),(0.50394,0.17323),(0.51181,0.17323),(0.51969,0.17323),(0.52756,0.17323),(0.53543,0.17323),(0.54331,0.17323),(0.55118,0.17323),(0.55906,0.17323),(0.56693,0.17323),(0.5748,0.17323),(0.58268,0.17323),(0.59055,0.17323),(0.59843,0.17323),(0.6063,0.17323),(0.61417,0.17323),(0.62205,0.17323),(0.62992,0.17323),(0.6378,0.17323),(0.64567,0.17323),(0.65354,0.17323),(0.66142,0.17323),(0.66929,0.17323),(0.67717,0.17323),(0.68504,0.17323),(0.69291,0.17323),(0.70079,0.17323),(0.70866,0.17323),(0.71654,0.17323),(0.72441,0.17323),(0.73228,0.17323),(0.74016,0.17323),(0.74803,0.17323),(0.75591,0.17323),(0.76378,0.17323),(0.77165,0.17323),(0.77953,0.17323),(0.7874,0.17323),(0.79528,0.17323),(0.80315,0.17323),(0.81102,0.17323),(0.8189,0.17323),(0.82677,0.17323),(0.83465,0.17323),(0.84252,0.17323),(0.85039,0.17323),(0.85827,0.17323),(0.86614,0.17323),(0.87402,0.17323),(0.88189,0.17323),(0.88976,0.17323),(0.89764,0.17323),(0.90551,0.17323),(0.91339,0.17323),(0.92126,0.17323),(0.92913,0.17323),(0.93701,0.17323),(0.94488,0.17323),(0.95276,0.17323),(0.96063,0.17323),(0.9685,0.17323),(0.97638,0.17323),(0.98425,0.17323),(0.99213,0.17323),(0.99609,0.17323),(0.00391,0.1811),(0.00787,0.1811),(0.01575,0.1811),(0.02362,0.1811),(0.0315,0.1811),(0.03937,0.1811),(0.04724,0.1811),(0.05512,0.1811),(0.06299,0.1811),(0.07087,0.1811),(0.07874,0.1811),(0.08661,0.1811),(0.09449,0.1811),(0.10236,0.1811),(0.11024,0.1811),(0.11811,0.1811),(0.12598,0.1811),(0.13386,0.1811),(0.14173,0.1811),(0.14961,0.1811),(0.15748,0.1811),(0.16535,0.1811),(0.17323,0.1811),(0.1811,0.1811),(0.18898,0.1811),(0.19685,0.1811),(0.20472,0.1811),(0.2126,0.1811),(0.22047,0.1811),(0.22835,0.1811),(0.23622,0.1811),(0.24409,0.1811),(0.25197,0.1811),(0.25984,0.1811),(0.26772,0.1811),(0.27559,0.1811),(0.28346,0.1811),(0.29134,0.1811),(0.29921,0.1811),(0.30709,0.1811),(0.31496,0.1811),(0.32283,0.1811),(0.33071,0.1811),(0.33858,0.1811),(0.34646,0.1811),(0.35433,0.1811),(0.3622,0.1811),(0.37008,0.1811),(0.37795,0.1811),(0.38583,0.1811),(0.3937,0.1811),(0.40157,0.1811),(0.40945,0.1811),(0.41732,0.1811),(0.4252,0.1811),(0.43307,0.1811),(0.44094,0.1811),(0.44882,0.1811),(0.45669,0.1811),(0.46457,0.1811),(0.47244,0.1811),(0.48031,0.1811),(0.48819,0.1811),(0.49606,0.1811),(0.50394,0.1811),(0.51181,0.1811),(0.51969,0.1811),(0.52756,0.1811),(0.53543,0.1811),(0.54331,0.1811),(0.55118,0.1811),(0.55906,0.1811),(0.56693,0.1811),(0.5748,0.1811),(0.58268,0.1811),(0.59055,0.1811),(0.59843,0.1811),(0.6063,0.1811),(0.61417,0.1811),(0.62205,0.1811),(0.62992,0.1811),(0.6378,0.1811),(0.64567,0.1811),(0.65354,0.1811),(0.66142,0.1811),(0.66929,0.1811),(0.67717,0.1811),(0.68504,0.1811),(0.69291,0.1811),(0.70079,0.1811),(0.70866,0.1811),(0.71654,0.1811),(0.72441,0.1811),(0.73228,0.1811),(0.74016,0.1811),(0.74803,0.1811),(0.75591,0.1811),(0.76378,0.1811),(0.77165,0.1811),(0.77953,0.1811),(0.7874,0.1811),(0.79528,0.1811),(0.80315,0.1811),(0.81102,0.1811),(0.8189,0.1811),(0.82677,0.1811),(0.83465,0.1811),(0.84252,0.1811),(0.85039,0.1811),(0.85827,0.1811),(0.86614,0.1811),(0.87402,0.1811),(0.88189,0.1811),(0.88976,0.1811),(0.89764,0.1811),(0.90551,0.1811),(0.91339,0.1811),(0.92126,0.1811),(0.92913,0.1811),(0.93701,0.1811),(0.94488,0.1811),(0.95276,0.1811),(0.96063,0.1811),(0.9685,0.1811),(0.97638,0.1811),(0.98425,0.1811),(0.99213,0.1811),(0.99609,0.1811),(0.00391,0.18898),(0.00787,0.18898),(0.01575,0.18898),(0.02362,0.18898),(0.0315,0.18898),(0.03937,0.18898),(0.04724,0.18898),(0.05512,0.18898),(0.06299,0.18898),(0.07087,0.18898),(0.07874,0.18898),(0.08661,0.18898),(0.09449,0.18898),(0.10236,0.18898),(0.11024,0.18898),(0.11811,0.18898),(0.12598,0.18898),(0.13386,0.18898),(0.14173,0.18898),(0.14961,0.18898),(0.15748,0.18898),(0.16535,0.18898),(0.17323,0.18898),(0.1811,0.18898),(0.18898,0.18898),(0.19685,0.18898),(0.20472,0.18898),(0.2126,0.18898),(0.22047,0.18898),(0.22835,0.18898),(0.23622,0.18898),(0.24409,0.18898),(0.25197,0.18898),(0.25984,0.18898),(0.26772,0.18898),(0.27559,0.18898),(0.28346,0.18898),(0.29134,0.18898),(0.29921,0.18898),(0.30709,0.18898),(0.31496,0.18898),(0.32283,0.18898),(0.33071,0.18898),(0.33858,0.18898),(0.34646,0.18898),(0.35433,0.18898),(0.3622,0.18898),(0.37008,0.18898),(0.37795,0.18898),(0.38583,0.18898),(0.3937,0.18898),(0.40157,0.18898),(0.40945,0.18898),(0.41732,0.18898),(0.4252,0.18898),(0.43307,0.18898),(0.44094,0.18898),(0.44882,0.18898),(0.45669,0.18898),(0.46457,0.18898),(0.47244,0.18898),(0.48031,0.18898),(0.48819,0.18898),(0.49606,0.18898),(0.50394,0.18898),(0.51181,0.18898),(0.51969,0.18898),(0.52756,0.18898),(0.53543,0.18898),(0.54331,0.18898),(0.55118,0.18898),(0.55906,0.18898),(0.56693,0.18898),(0.5748,0.18898),(0.58268,0.18898),(0.59055,0.18898),(0.59843,0.18898),(0.6063,0.18898),(0.61417,0.18898),(0.62205,0.18898),(0.62992,0.18898),(0.6378,0.18898),(0.64567,0.18898),(0.65354,0.18898),(0.66142,0.18898),(0.66929,0.18898),(0.67717,0.18898),(0.68504,0.18898),(0.69291,0.18898),(0.70079,0.18898),(0.70866,0.18898),(0.71654,0.18898),(0.72441,0.18898),(0.73228,0.18898),(0.74016,0.18898),(0.74803,0.18898),(0.75591,0.18898),(0.76378,0.18898),(0.77165,0.18898),(0.77953,0.18898),(0.7874,0.18898),(0.79528,0.18898),(0.80315,0.18898),(0.81102,0.18898),(0.8189,0.18898),(0.82677,0.18898),(0.83465,0.18898),(0.84252,0.18898),(0.85039,0.18898),(0.85827,0.18898),(0.86614,0.18898),(0.87402,0.18898),(0.88189,0.18898),(0.88976,0.18898),(0.89764,0.18898),(0.90551,0.18898),(0.91339,0.18898),(0.92126,0.18898),(0.92913,0.18898),(0.93701,0.18898),(0.94488,0.18898),(0.95276,0.18898),(0.96063,0.18898),(0.9685,0.18898),(0.97638,0.18898),(0.98425,0.18898),(0.99213,0.18898),(0.99609,0.18898),(0.00391,0.19685),(0.00787,0.19685),(0.01575,0.19685),(0.02362,0.19685),(0.0315,0.19685),(0.03937,0.19685),(0.04724,0.19685),(0.05512,0.19685),(0.06299,0.19685),(0.07087,0.19685),(0.07874,0.19685),(0.08661,0.19685),(0.09449,0.19685),(0.10236,0.19685),(0.11024,0.19685),(0.11811,0.19685),(0.12598,0.19685),(0.13386,0.19685),(0.14173,0.19685),(0.14961,0.19685),(0.15748,0.19685),(0.16535,0.19685),(0.17323,0.19685),(0.1811,0.19685),(0.18898,0.19685),(0.19685,0.19685),(0.20472,0.19685),(0.2126,0.19685),(0.22047,0.19685),(0.22835,0.19685),(0.23622,0.19685),(0.24409,0.19685),(0.25197,0.19685),(0.25984,0.19685),(0.26772,0.19685),(0.27559,0.19685),(0.28346,0.19685),(0.29134,0.19685),(0.29921,0.19685),(0.30709,0.19685),(0.31496,0.19685),(0.32283,0.19685),(0.33071,0.19685),(0.33858,0.19685),(0.34646,0.19685),(0.35433,0.19685),(0.3622,0.19685),(0.37008,0.19685),(0.37795,0.19685),(0.38583,0.19685),(0.3937,0.19685),(0.40157,0.19685),(0.40945,0.19685),(0.41732,0.19685),(0.4252,0.19685),(0.43307,0.19685),(0.44094,0.19685),(0.44882,0.19685),(0.45669,0.19685),(0.46457,0.19685),(0.47244,0.19685),(0.48031,0.19685),(0.48819,0.19685),(0.49606,0.19685),(0.50394,0.19685),(0.51181,0.19685),(0.51969,0.19685),(0.52756,0.19685),(0.53543,0.19685),(0.54331,0.19685),(0.55118,0.19685),(0.55906,0.19685),(0.56693,0.19685),(0.5748,0.19685),(0.58268,0.19685),(0.59055,0.19685),(0.59843,0.19685),(0.6063,0.19685),(0.61417,0.19685),(0.62205,0.19685),(0.62992,0.19685),(0.6378,0.19685),(0.64567,0.19685),(0.65354,0.19685),(0.66142,0.19685),(0.66929,0.19685),(0.67717,0.19685),(0.68504,0.19685),(0.69291,0.19685),(0.70079,0.19685),(0.70866,0.19685),(0.71654,0.19685),(0.72441,0.19685),(0.73228,0.19685),(0.74016,0.19685),(0.74803,0.19685),(0.75591,0.19685),(0.76378,0.19685),(0.77165,0.19685),(0.77953,0.19685),(0.7874,0.19685),(0.79528,0.19685),(0.80315,0.19685),(0.81102,0.19685),(0.8189,0.19685),(0.82677,0.19685),(0.83465,0.19685),(0.84252,0.19685),(0.85039,0.19685),(0.85827,0.19685),(0.86614,0.19685),(0.87402,0.19685),(0.88189,0.19685),(0.88976,0.19685),(0.89764,0.19685),(0.90551,0.19685),(0.91339,0.19685),(0.92126,0.19685),(0.92913,0.19685),(0.93701,0.19685),(0.94488,0.19685),(0.95276,0.19685),(0.96063,0.19685),(0.9685,0.19685),(0.97638,0.19685),(0.98425,0.19685),(0.99213,0.19685),(0.99609,0.19685),(0.00391,0.20472),(0.00787,0.20472),(0.01575,0.20472),(0.02362,0.20472),(0.0315,0.20472),(0.03937,0.20472),(0.04724,0.20472),(0.05512,0.20472),(0.06299,0.20472),(0.07087,0.20472),(0.07874,0.20472),(0.08661,0.20472),(0.09449,0.20472),(0.10236,0.20472),(0.11024,0.20472),(0.11811,0.20472),(0.12598,0.20472),(0.13386,0.20472),(0.14173,0.20472),(0.14961,0.20472),(0.15748,0.20472),(0.16535,0.20472),(0.17323,0.20472),(0.1811,0.20472),(0.18898,0.20472),(0.19685,0.20472),(0.20472,0.20472),(0.2126,0.20472),(0.22047,0.20472),(0.22835,0.20472),(0.23622,0.20472),(0.24409,0.20472),(0.25197,0.20472),(0.25984,0.20472),(0.26772,0.20472),(0.27559,0.20472),(0.28346,0.20472),(0.29134,0.20472),(0.29921,0.20472),(0.30709,0.20472),(0.31496,0.20472),(0.32283,0.20472),(0.33071,0.20472),(0.33858,0.20472),(0.34646,0.20472),(0.35433,0.20472),(0.3622,0.20472),(0.37008,0.20472),(0.37795,0.20472),(0.38583,0.20472),(0.3937,0.20472),(0.40157,0.20472),(0.40945,0.20472),(0.41732,0.20472),(0.4252,0.20472),(0.43307,0.20472),(0.44094,0.20472),(0.44882,0.20472),(0.45669,0.20472),(0.46457,0.20472),(0.47244,0.20472),(0.48031,0.20472),(0.48819,0.20472),(0.49606,0.20472),(0.50394,0.20472),(0.51181,0.20472),(0.51969,0.20472),(0.52756,0.20472),(0.53543,0.20472),(0.54331,0.20472),(0.55118,0.20472),(0.55906,0.20472),(0.56693,0.20472),(0.5748,0.20472),(0.58268,0.20472),(0.59055,0.20472),(0.59843,0.20472),(0.6063,0.20472),(0.61417,0.20472),(0.62205,0.20472),(0.62992,0.20472),(0.6378,0.20472),(0.64567,0.20472),(0.65354,0.20472),(0.66142,0.20472),(0.66929,0.20472),(0.67717,0.20472),(0.68504,0.20472),(0.69291,0.20472),(0.70079,0.20472),(0.70866,0.20472),(0.71654,0.20472),(0.72441,0.20472),(0.73228,0.20472),(0.74016,0.20472),(0.74803,0.20472),(0.75591,0.20472),(0.76378,0.20472),(0.77165,0.20472),(0.77953,0.20472),(0.7874,0.20472),(0.79528,0.20472),(0.80315,0.20472),(0.81102,0.20472),(0.8189,0.20472),(0.82677,0.20472),(0.83465,0.20472),(0.84252,0.20472),(0.85039,0.20472),(0.85827,0.20472),(0.86614,0.20472),(0.87402,0.20472),(0.88189,0.20472),(0.88976,0.20472),(0.89764,0.20472),(0.90551,0.20472),(0.91339,0.20472),(0.92126,0.20472),(0.92913,0.20472),(0.93701,0.20472),(0.94488,0.20472),(0.95276,0.20472),(0.96063,0.20472),(0.9685,0.20472),(0.97638,0.20472),(0.98425,0.20472),(0.99213,0.20472),(0.99609,0.20472),(0.00391,0.2126),(0.00787,0.2126),(0.01575,0.2126),(0.02362,0.2126),(0.0315,0.2126),(0.03937,0.2126),(0.04724,0.2126),(0.05512,0.2126),(0.06299,0.2126),(0.07087,0.2126),(0.07874,0.2126),(0.08661,0.2126),(0.09449,0.2126),(0.10236,0.2126),(0.11024,0.2126),(0.11811,0.2126),(0.12598,0.2126),(0.13386,0.2126),(0.14173,0.2126),(0.14961,0.2126),(0.15748,0.2126),(0.16535,0.2126),(0.17323,0.2126),(0.1811,0.2126),(0.18898,0.2126),(0.19685,0.2126),(0.20472,0.2126),(0.2126,0.2126),(0.22047,0.2126),(0.22835,0.2126),(0.23622,0.2126),(0.24409,0.2126),(0.25197,0.2126),(0.25984,0.2126),(0.26772,0.2126),(0.27559,0.2126),(0.28346,0.2126),(0.29134,0.2126),(0.29921,0.2126),(0.30709,0.2126),(0.31496,0.2126),(0.32283,0.2126),(0.33071,0.2126),(0.33858,0.2126),(0.34646,0.2126),(0.35433,0.2126),(0.3622,0.2126),(0.37008,0.2126),(0.37795,0.2126),(0.38583,0.2126),(0.3937,0.2126),(0.40157,0.2126),(0.40945,0.2126),(0.41732,0.2126),(0.4252,0.2126),(0.43307,0.2126),(0.44094,0.2126),(0.44882,0.2126),(0.45669,0.2126),(0.46457,0.2126),(0.47244,0.2126),(0.48031,0.2126),(0.48819,0.2126),(0.49606,0.2126),(0.50394,0.2126),(0.51181,0.2126),(0.51969,0.2126),(0.52756,0.2126),(0.53543,0.2126),(0.54331,0.2126),(0.55118,0.2126),(0.55906,0.2126),(0.56693,0.2126),(0.5748,0.2126),(0.58268,0.2126),(0.59055,0.2126),(0.59843,0.2126),(0.6063,0.2126),(0.61417,0.2126),(0.62205,0.2126),(0.62992,0.2126),(0.6378,0.2126),(0.64567,0.2126),(0.65354,0.2126),(0.66142,0.2126),(0.66929,0.2126),(0.67717,0.2126),(0.68504,0.2126),(0.69291,0.2126),(0.70079,0.2126),(0.70866,0.2126),(0.71654,0.2126),(0.72441,0.2126),(0.73228,0.2126),(0.74016,0.2126),(0.74803,0.2126),(0.75591,0.2126),(0.76378,0.2126),(0.77165,0.2126),(0.77953,0.2126),(0.7874,0.2126),(0.79528,0.2126),(0.80315,0.2126),(0.81102,0.2126),(0.8189,0.2126),(0.82677,0.2126),(0.83465,0.2126),(0.84252,0.2126),(0.85039,0.2126),(0.85827,0.2126),(0.86614,0.2126),(0.87402,0.2126),(0.88189,0.2126),(0.88976,0.2126),(0.89764,0.2126),(0.90551,0.2126),(0.91339,0.2126),(0.92126,0.2126),(0.92913,0.2126),(0.93701,0.2126),(0.94488,0.2126),(0.95276,0.2126),(0.96063,0.2126),(0.9685,0.2126),(0.97638,0.2126),(0.98425,0.2126),(0.99213,0.2126),(0.99609,0.2126),(0.00391,0.22047),(0.00787,0.22047),(0.01575,0.22047),(0.02362,0.22047),(0.0315,0.22047),(0.03937,0.22047),(0.04724,0.22047),(0.05512,0.22047),(0.06299,0.22047),(0.07087,0.22047),(0.07874,0.22047),(0.08661,0.22047),(0.09449,0.22047),(0.10236,0.22047),(0.11024,0.22047),(0.11811,0.22047),(0.12598,0.22047),(0.13386,0.22047),(0.14173,0.22047),(0.14961,0.22047),(0.15748,0.22047),(0.16535,0.22047),(0.17323,0.22047),(0.1811,0.22047),(0.18898,0.22047),(0.19685,0.22047),(0.20472,0.22047),(0.2126,0.22047),(0.22047,0.22047),(0.22835,0.22047),(0.23622,0.22047),(0.24409,0.22047),(0.25197,0.22047),(0.25984,0.22047),(0.26772,0.22047),(0.27559,0.22047),(0.28346,0.22047),(0.29134,0.22047),(0.29921,0.22047),(0.30709,0.22047),(0.31496,0.22047),(0.32283,0.22047),(0.33071,0.22047),(0.33858,0.22047),(0.34646,0.22047),(0.35433,0.22047),(0.3622,0.22047),(0.37008,0.22047),(0.37795,0.22047),(0.38583,0.22047),(0.3937,0.22047),(0.40157,0.22047),(0.40945,0.22047),(0.41732,0.22047),(0.4252,0.22047),(0.43307,0.22047),(0.44094,0.22047),(0.44882,0.22047),(0.45669,0.22047),(0.46457,0.22047),(0.47244,0.22047),(0.48031,0.22047),(0.48819,0.22047),(0.49606,0.22047),(0.50394,0.22047),(0.51181,0.22047),(0.51969,0.22047),(0.52756,0.22047),(0.53543,0.22047),(0.54331,0.22047),(0.55118,0.22047),(0.55906,0.22047),(0.56693,0.22047),(0.5748,0.22047),(0.58268,0.22047),(0.59055,0.22047),(0.59843,0.22047),(0.6063,0.22047),(0.61417,0.22047),(0.62205,0.22047),(0.62992,0.22047),(0.6378,0.22047),(0.64567,0.22047),(0.65354,0.22047),(0.66142,0.22047),(0.66929,0.22047),(0.67717,0.22047),(0.68504,0.22047),(0.69291,0.22047),(0.70079,0.22047),(0.70866,0.22047),(0.71654,0.22047),(0.72441,0.22047),(0.73228,0.22047),(0.74016,0.22047),(0.74803,0.22047),(0.75591,0.22047),(0.76378,0.22047),(0.77165,0.22047),(0.77953,0.22047),(0.7874,0.22047),(0.79528,0.22047),(0.80315,0.22047),(0.81102,0.22047),(0.8189,0.22047),(0.82677,0.22047),(0.83465,0.22047),(0.84252,0.22047),(0.85039,0.22047),(0.85827,0.22047),(0.86614,0.22047),(0.87402,0.22047),(0.88189,0.22047),(0.88976,0.22047),(0.89764,0.22047),(0.90551,0.22047),(0.91339,0.22047),(0.92126,0.22047),(0.92913,0.22047),(0.93701,0.22047),(0.94488,0.22047),(0.95276,0.22047),(0.96063,0.22047),(0.9685,0.22047),(0.97638,0.22047),(0.98425,0.22047),(0.99213,0.22047),(0.99609,0.22047),(0.00391,0.22835),(0.00787,0.22835),(0.01575,0.22835),(0.02362,0.22835),(0.0315,0.22835),(0.03937,0.22835),(0.04724,0.22835),(0.05512,0.22835),(0.06299,0.22835),(0.07087,0.22835),(0.07874,0.22835),(0.08661,0.22835),(0.09449,0.22835),(0.10236,0.22835),(0.11024,0.22835),(0.11811,0.22835),(0.12598,0.22835),(0.13386,0.22835),(0.14173,0.22835),(0.14961,0.22835),(0.15748,0.22835),(0.16535,0.22835),(0.17323,0.22835),(0.1811,0.22835),(0.18898,0.22835),(0.19685,0.22835),(0.20472,0.22835),(0.2126,0.22835),(0.22047,0.22835),(0.22835,0.22835),(0.23622,0.22835),(0.24409,0.22835),(0.25197,0.22835),(0.25984,0.22835),(0.26772,0.22835),(0.27559,0.22835),(0.28346,0.22835),(0.29134,0.22835),(0.29921,0.22835),(0.30709,0.22835),(0.31496,0.22835),(0.32283,0.22835),(0.33071,0.22835),(0.33858,0.22835),(0.34646,0.22835),(0.35433,0.22835),(0.3622,0.22835),(0.37008,0.22835),(0.37795,0.22835),(0.38583,0.22835),(0.3937,0.22835),(0.40157,0.22835),(0.40945,0.22835),(0.41732,0.22835),(0.4252,0.22835),(0.43307,0.22835),(0.44094,0.22835),(0.44882,0.22835),(0.45669,0.22835),(0.46457,0.22835),(0.47244,0.22835),(0.48031,0.22835),(0.48819,0.22835),(0.49606,0.22835),(0.50394,0.22835),(0.51181,0.22835),(0.51969,0.22835),(0.52756,0.22835),(0.53543,0.22835),(0.54331,0.22835),(0.55118,0.22835),(0.55906,0.22835),(0.56693,0.22835),(0.5748,0.22835),(0.58268,0.22835),(0.59055,0.22835),(0.59843,0.22835),(0.6063,0.22835),(0.61417,0.22835),(0.62205,0.22835),(0.62992,0.22835),(0.6378,0.22835),(0.64567,0.22835),(0.65354,0.22835),(0.66142,0.22835),(0.66929,0.22835),(0.67717,0.22835),(0.68504,0.22835),(0.69291,0.22835),(0.70079,0.22835),(0.70866,0.22835),(0.71654,0.22835),(0.72441,0.22835),(0.73228,0.22835),(0.74016,0.22835),(0.74803,0.22835),(0.75591,0.22835),(0.76378,0.22835),(0.77165,0.22835),(0.77953,0.22835),(0.7874,0.22835),(0.79528,0.22835),(0.80315,0.22835),(0.81102,0.22835),(0.8189,0.22835),(0.82677,0.22835),(0.83465,0.22835),(0.84252,0.22835),(0.85039,0.22835),(0.85827,0.22835),(0.86614,0.22835),(0.87402,0.22835),(0.88189,0.22835),(0.88976,0.22835),(0.89764,0.22835),(0.90551,0.22835),(0.91339,0.22835),(0.92126,0.22835),(0.92913,0.22835),(0.93701,0.22835),(0.94488,0.22835),(0.95276,0.22835),(0.96063,0.22835),(0.9685,0.22835),(0.97638,0.22835),(0.98425,0.22835),(0.99213,0.22835),(0.99609,0.22835),(0.00391,0.23622),(0.00787,0.23622),(0.01575,0.23622),(0.02362,0.23622),(0.0315,0.23622),(0.03937,0.23622),(0.04724,0.23622),(0.05512,0.23622),(0.06299,0.23622),(0.07087,0.23622),(0.07874,0.23622),(0.08661,0.23622),(0.09449,0.23622),(0.10236,0.23622),(0.11024,0.23622),(0.11811,0.23622),(0.12598,0.23622),(0.13386,0.23622),(0.14173,0.23622),(0.14961,0.23622),(0.15748,0.23622),(0.16535,0.23622),(0.17323,0.23622),(0.1811,0.23622),(0.18898,0.23622),(0.19685,0.23622),(0.20472,0.23622),(0.2126,0.23622),(0.22047,0.23622),(0.22835,0.23622),(0.23622,0.23622),(0.24409,0.23622),(0.25197,0.23622),(0.25984,0.23622),(0.26772,0.23622),(0.27559,0.23622),(0.28346,0.23622),(0.29134,0.23622),(0.29921,0.23622),(0.30709,0.23622),(0.31496,0.23622),(0.32283,0.23622),(0.33071,0.23622),(0.33858,0.23622),(0.34646,0.23622),(0.35433,0.23622),(0.3622,0.23622),(0.37008,0.23622),(0.37795,0.23622),(0.38583,0.23622),(0.3937,0.23622),(0.40157,0.23622),(0.40945,0.23622),(0.41732,0.23622),(0.4252,0.23622),(0.43307,0.23622),(0.44094,0.23622),(0.44882,0.23622),(0.45669,0.23622),(0.46457,0.23622),(0.47244,0.23622),(0.48031,0.23622),(0.48819,0.23622),(0.49606,0.23622),(0.50394,0.23622),(0.51181,0.23622),(0.51969,0.23622),(0.52756,0.23622),(0.53543,0.23622),(0.54331,0.23622),(0.55118,0.23622),(0.55906,0.23622),(0.56693,0.23622),(0.5748,0.23622),(0.58268,0.23622),(0.59055,0.23622),(0.59843,0.23622),(0.6063,0.23622),(0.61417,0.23622),(0.62205,0.23622),(0.62992,0.23622),(0.6378,0.23622),(0.64567,0.23622),(0.65354,0.23622),(0.66142,0.23622),(0.66929,0.23622),(0.67717,0.23622),(0.68504,0.23622),(0.69291,0.23622),(0.70079,0.23622),(0.70866,0.23622),(0.71654,0.23622),(0.72441,0.23622),(0.73228,0.23622),(0.74016,0.23622),(0.74803,0.23622),(0.75591,0.23622),(0.76378,0.23622),(0.77165,0.23622),(0.77953,0.23622),(0.7874,0.23622),(0.79528,0.23622),(0.80315,0.23622),(0.81102,0.23622),(0.8189,0.23622),(0.82677,0.23622),(0.83465,0.23622),(0.84252,0.23622),(0.85039,0.23622),(0.85827,0.23622),(0.86614,0.23622),(0.87402,0.23622),(0.88189,0.23622),(0.88976,0.23622),(0.89764,0.23622),(0.90551,0.23622),(0.91339,0.23622),(0.92126,0.23622),(0.92913,0.23622),(0.93701,0.23622),(0.94488,0.23622),(0.95276,0.23622),(0.96063,0.23622),(0.9685,0.23622),(0.97638,0.23622),(0.98425,0.23622),(0.99213,0.23622),(0.99609,0.23622),(0.00391,0.24409),(0.00787,0.24409),(0.01575,0.24409),(0.02362,0.24409),(0.0315,0.24409),(0.03937,0.24409),(0.04724,0.24409),(0.05512,0.24409),(0.06299,0.24409),(0.07087,0.24409),(0.07874,0.24409),(0.08661,0.24409),(0.09449,0.24409),(0.10236,0.24409),(0.11024,0.24409),(0.11811,0.24409),(0.12598,0.24409),(0.13386,0.24409),(0.14173,0.24409),(0.14961,0.24409),(0.15748,0.24409),(0.16535,0.24409),(0.17323,0.24409),(0.1811,0.24409),(0.18898,0.24409),(0.19685,0.24409),(0.20472,0.24409),(0.2126,0.24409),(0.22047,0.24409),(0.22835,0.24409),(0.23622,0.24409),(0.24409,0.24409),(0.25197,0.24409),(0.25984,0.24409),(0.26772,0.24409),(0.27559,0.24409),(0.28346,0.24409),(0.29134,0.24409),(0.29921,0.24409),(0.30709,0.24409),(0.31496,0.24409),(0.32283,0.24409),(0.33071,0.24409),(0.33858,0.24409),(0.34646,0.24409),(0.35433,0.24409),(0.3622,0.24409),(0.37008,0.24409),(0.37795,0.24409),(0.38583,0.24409),(0.3937,0.24409),(0.40157,0.24409),(0.40945,0.24409),(0.41732,0.24409),(0.4252,0.24409),(0.43307,0.24409),(0.44094,0.24409),(0.44882,0.24409),(0.45669,0.24409),(0.46457,0.24409),(0.47244,0.24409),(0.48031,0.24409),(0.48819,0.24409),(0.49606,0.24409),(0.50394,0.24409),(0.51181,0.24409),(0.51969,0.24409),(0.52756,0.24409),(0.53543,0.24409),(0.54331,0.24409),(0.55118,0.24409),(0.55906,0.24409),(0.56693,0.24409),(0.5748,0.24409),(0.58268,0.24409),(0.59055,0.24409),(0.59843,0.24409),(0.6063,0.24409),(0.61417,0.24409),(0.62205,0.24409),(0.62992,0.24409),(0.6378,0.24409),(0.64567,0.24409),(0.65354,0.24409),(0.66142,0.24409),(0.66929,0.24409),(0.67717,0.24409),(0.68504,0.24409),(0.69291,0.24409),(0.70079,0.24409),(0.70866,0.24409),(0.71654,0.24409),(0.72441,0.24409),(0.73228,0.24409),(0.74016,0.24409),(0.74803,0.24409),(0.75591,0.24409),(0.76378,0.24409),(0.77165,0.24409),(0.77953,0.24409),(0.7874,0.24409),(0.79528,0.24409),(0.80315,0.24409),(0.81102,0.24409),(0.8189,0.24409),(0.82677,0.24409),(0.83465,0.24409),(0.84252,0.24409),(0.85039,0.24409),(0.85827,0.24409),(0.86614,0.24409),(0.87402,0.24409),(0.88189,0.24409),(0.88976,0.24409),(0.89764,0.24409),(0.90551,0.24409),(0.91339,0.24409),(0.92126,0.24409),(0.92913,0.24409),(0.93701,0.24409),(0.94488,0.24409),(0.95276,0.24409),(0.96063,0.24409),(0.9685,0.24409),(0.97638,0.24409),(0.98425,0.24409),(0.99213,0.24409),(0.99609,0.24409),(0.00391,0.25197),(0.00787,0.25197),(0.01575,0.25197),(0.02362,0.25197),(0.0315,0.25197),(0.03937,0.25197),(0.04724,0.25197),(0.05512,0.25197),(0.06299,0.25197),(0.07087,0.25197),(0.07874,0.25197),(0.08661,0.25197),(0.09449,0.25197),(0.10236,0.25197),(0.11024,0.25197),(0.11811,0.25197),(0.12598,0.25197),(0.13386,0.25197),(0.14173,0.25197),(0.14961,0.25197),(0.15748,0.25197),(0.16535,0.25197),(0.17323,0.25197),(0.1811,0.25197),(0.18898,0.25197),(0.19685,0.25197),(0.20472,0.25197),(0.2126,0.25197),(0.22047,0.25197),(0.22835,0.25197),(0.23622,0.25197),(0.24409,0.25197),(0.25197,0.25197),(0.25984,0.25197),(0.26772,0.25197),(0.27559,0.25197),(0.28346,0.25197),(0.29134,0.25197),(0.29921,0.25197),(0.30709,0.25197),(0.31496,0.25197),(0.32283,0.25197),(0.33071,0.25197),(0.33858,0.25197),(0.34646,0.25197),(0.35433,0.25197),(0.3622,0.25197),(0.37008,0.25197),(0.37795,0.25197),(0.38583,0.25197),(0.3937,0.25197),(0.40157,0.25197),(0.40945,0.25197),(0.41732,0.25197),(0.4252,0.25197),(0.43307,0.25197),(0.44094,0.25197),(0.44882,0.25197),(0.45669,0.25197),(0.46457,0.25197),(0.47244,0.25197),(0.48031,0.25197),(0.48819,0.25197),(0.49606,0.25197),(0.50394,0.25197),(0.51181,0.25197),(0.51969,0.25197),(0.52756,0.25197),(0.53543,0.25197),(0.54331,0.25197),(0.55118,0.25197),(0.55906,0.25197),(0.56693,0.25197),(0.5748,0.25197),(0.58268,0.25197),(0.59055,0.25197),(0.59843,0.25197),(0.6063,0.25197),(0.61417,0.25197),(0.62205,0.25197),(0.62992,0.25197),(0.6378,0.25197),(0.64567,0.25197),(0.65354,0.25197),(0.66142,0.25197),(0.66929,0.25197),(0.67717,0.25197),(0.68504,0.25197),(0.69291,0.25197),(0.70079,0.25197),(0.70866,0.25197),(0.71654,0.25197),(0.72441,0.25197),(0.73228,0.25197),(0.74016,0.25197),(0.74803,0.25197),(0.75591,0.25197),(0.76378,0.25197),(0.77165,0.25197),(0.77953,0.25197),(0.7874,0.25197),(0.79528,0.25197),(0.80315,0.25197),(0.81102,0.25197),(0.8189,0.25197),(0.82677,0.25197),(0.83465,0.25197),(0.84252,0.25197),(0.85039,0.25197),(0.85827,0.25197),(0.86614,0.25197),(0.87402,0.25197),(0.88189,0.25197),(0.88976,0.25197),(0.89764,0.25197),(0.90551,0.25197),(0.91339,0.25197),(0.92126,0.25197),(0.92913,0.25197),(0.93701,0.25197),(0.94488,0.25197),(0.95276,0.25197),(0.96063,0.25197),(0.9685,0.25197),(0.97638,0.25197),(0.98425,0.25197),(0.99213,0.25197),(0.99609,0.25197),(0.00391,0.25984),(0.00787,0.25984),(0.01575,0.25984),(0.02362,0.25984),(0.0315,0.25984),(0.03937,0.25984),(0.04724,0.25984),(0.05512,0.25984),(0.06299,0.25984),(0.07087,0.25984),(0.07874,0.25984),(0.08661,0.25984),(0.09449,0.25984),(0.10236,0.25984),(0.11024,0.25984),(0.11811,0.25984),(0.12598,0.25984),(0.13386,0.25984),(0.14173,0.25984),(0.14961,0.25984),(0.15748,0.25984),(0.16535,0.25984),(0.17323,0.25984),(0.1811,0.25984),(0.18898,0.25984),(0.19685,0.25984),(0.20472,0.25984),(0.2126,0.25984),(0.22047,0.25984),(0.22835,0.25984),(0.23622,0.25984),(0.24409,0.25984),(0.25197,0.25984),(0.25984,0.25984),(0.26772,0.25984),(0.27559,0.25984),(0.28346,0.25984),(0.29134,0.25984),(0.29921,0.25984),(0.30709,0.25984),(0.31496,0.25984),(0.32283,0.25984),(0.33071,0.25984),(0.33858,0.25984),(0.34646,0.25984),(0.35433,0.25984),(0.3622,0.25984),(0.37008,0.25984),(0.37795,0.25984),(0.38583,0.25984),(0.3937,0.25984),(0.40157,0.25984),(0.40945,0.25984),(0.41732,0.25984),(0.4252,0.25984),(0.43307,0.25984),(0.44094,0.25984),(0.44882,0.25984),(0.45669,0.25984),(0.46457,0.25984),(0.47244,0.25984),(0.48031,0.25984),(0.48819,0.25984),(0.49606,0.25984),(0.50394,0.25984),(0.51181,0.25984),(0.51969,0.25984),(0.52756,0.25984),(0.53543,0.25984),(0.54331,0.25984),(0.55118,0.25984),(0.55906,0.25984),(0.56693,0.25984),(0.5748,0.25984),(0.58268,0.25984),(0.59055,0.25984),(0.59843,0.25984),(0.6063,0.25984),(0.61417,0.25984),(0.62205,0.25984),(0.62992,0.25984),(0.6378,0.25984),(0.64567,0.25984),(0.65354,0.25984),(0.66142,0.25984),(0.66929,0.25984),(0.67717,0.25984),(0.68504,0.25984),(0.69291,0.25984),(0.70079,0.25984),(0.70866,0.25984),(0.71654,0.25984),(0.72441,0.25984),(0.73228,0.25984),(0.74016,0.25984),(0.74803,0.25984),(0.75591,0.25984),(0.76378,0.25984),(0.77165,0.25984),(0.77953,0.25984),(0.7874,0.25984),(0.79528,0.25984),(0.80315,0.25984),(0.81102,0.25984),(0.8189,0.25984),(0.82677,0.25984),(0.83465,0.25984),(0.84252,0.25984),(0.85039,0.25984),(0.85827,0.25984),(0.86614,0.25984),(0.87402,0.25984),(0.88189,0.25984),(0.88976,0.25984),(0.89764,0.25984),(0.90551,0.25984),(0.91339,0.25984),(0.92126,0.25984),(0.92913,0.25984),(0.93701,0.25984),(0.94488,0.25984),(0.95276,0.25984),(0.96063,0.25984),(0.9685,0.25984),(0.97638,0.25984),(0.98425,0.25984),(0.99213,0.25984),(0.99609,0.25984),(0.00391,0.26772),(0.00787,0.26772),(0.01575,0.26772),(0.02362,0.26772),(0.0315,0.26772),(0.03937,0.26772),(0.04724,0.26772),(0.05512,0.26772),(0.06299,0.26772),(0.07087,0.26772),(0.07874,0.26772),(0.08661,0.26772),(0.09449,0.26772),(0.10236,0.26772),(0.11024,0.26772),(0.11811,0.26772),(0.12598,0.26772),(0.13386,0.26772),(0.14173,0.26772),(0.14961,0.26772),(0.15748,0.26772),(0.16535,0.26772),(0.17323,0.26772),(0.1811,0.26772),(0.18898,0.26772),(0.19685,0.26772),(0.20472,0.26772),(0.2126,0.26772),(0.22047,0.26772),(0.22835,0.26772),(0.23622,0.26772),(0.24409,0.26772),(0.25197,0.26772),(0.25984,0.26772),(0.26772,0.26772),(0.27559,0.26772),(0.28346,0.26772),(0.29134,0.26772),(0.29921,0.26772),(0.30709,0.26772),(0.31496,0.26772),(0.32283,0.26772),(0.33071,0.26772),(0.33858,0.26772),(0.34646,0.26772),(0.35433,0.26772),(0.3622,0.26772),(0.37008,0.26772),(0.37795,0.26772),(0.38583,0.26772),(0.3937,0.26772),(0.40157,0.26772),(0.40945,0.26772),(0.41732,0.26772),(0.4252,0.26772),(0.43307,0.26772),(0.44094,0.26772),(0.44882,0.26772),(0.45669,0.26772),(0.46457,0.26772),(0.47244,0.26772),(0.48031,0.26772),(0.48819,0.26772),(0.49606,0.26772),(0.50394,0.26772),(0.51181,0.26772),(0.51969,0.26772),(0.52756,0.26772),(0.53543,0.26772),(0.54331,0.26772),(0.55118,0.26772),(0.55906,0.26772),(0.56693,0.26772),(0.5748,0.26772),(0.58268,0.26772),(0.59055,0.26772),(0.59843,0.26772),(0.6063,0.26772),(0.61417,0.26772),(0.62205,0.26772),(0.62992,0.26772),(0.6378,0.26772),(0.64567,0.26772),(0.65354,0.26772),(0.66142,0.26772),(0.66929,0.26772),(0.67717,0.26772),(0.68504,0.26772),(0.69291,0.26772),(0.70079,0.26772),(0.70866,0.26772),(0.71654,0.26772),(0.72441,0.26772),(0.73228,0.26772),(0.74016,0.26772),(0.74803,0.26772),(0.75591,0.26772),(0.76378,0.26772),(0.77165,0.26772),(0.77953,0.26772),(0.7874,0.26772),(0.79528,0.26772),(0.80315,0.26772),(0.81102,0.26772),(0.8189,0.26772),(0.82677,0.26772),(0.83465,0.26772),(0.84252,0.26772),(0.85039,0.26772),(0.85827,0.26772),(0.86614,0.26772),(0.87402,0.26772),(0.88189,0.26772),(0.88976,0.26772),(0.89764,0.26772),(0.90551,0.26772),(0.91339,0.26772),(0.92126,0.26772),(0.92913,0.26772),(0.93701,0.26772),(0.94488,0.26772),(0.95276,0.26772),(0.96063,0.26772),(0.9685,0.26772),(0.97638,0.26772),(0.98425,0.26772),(0.99213,0.26772),(0.99609,0.26772),(0.00391,0.27559),(0.00787,0.27559),(0.01575,0.27559),(0.02362,0.27559),(0.0315,0.27559),(0.03937,0.27559),(0.04724,0.27559),(0.05512,0.27559),(0.06299,0.27559),(0.07087,0.27559),(0.07874,0.27559),(0.08661,0.27559),(0.09449,0.27559),(0.10236,0.27559),(0.11024,0.27559),(0.11811,0.27559),(0.12598,0.27559),(0.13386,0.27559),(0.14173,0.27559),(0.14961,0.27559),(0.15748,0.27559),(0.16535,0.27559),(0.17323,0.27559),(0.1811,0.27559),(0.18898,0.27559),(0.19685,0.27559),(0.20472,0.27559),(0.2126,0.27559),(0.22047,0.27559),(0.22835,0.27559),(0.23622,0.27559),(0.24409,0.27559),(0.25197,0.27559),(0.25984,0.27559),(0.26772,0.27559),(0.27559,0.27559),(0.28346,0.27559),(0.29134,0.27559),(0.29921,0.27559),(0.30709,0.27559),(0.31496,0.27559),(0.32283,0.27559),(0.33071,0.27559),(0.33858,0.27559),(0.34646,0.27559),(0.35433,0.27559),(0.3622,0.27559),(0.37008,0.27559),(0.37795,0.27559),(0.38583,0.27559),(0.3937,0.27559),(0.40157,0.27559),(0.40945,0.27559),(0.41732,0.27559),(0.4252,0.27559),(0.43307,0.27559),(0.44094,0.27559),(0.44882,0.27559),(0.45669,0.27559),(0.46457,0.27559),(0.47244,0.27559),(0.48031,0.27559),(0.48819,0.27559),(0.49606,0.27559),(0.50394,0.27559),(0.51181,0.27559),(0.51969,0.27559),(0.52756,0.27559),(0.53543,0.27559),(0.54331,0.27559),(0.55118,0.27559),(0.55906,0.27559),(0.56693,0.27559),(0.5748,0.27559),(0.58268,0.27559),(0.59055,0.27559),(0.59843,0.27559),(0.6063,0.27559),(0.61417,0.27559),(0.62205,0.27559),(0.62992,0.27559),(0.6378,0.27559),(0.64567,0.27559),(0.65354,0.27559),(0.66142,0.27559),(0.66929,0.27559),(0.67717,0.27559),(0.68504,0.27559),(0.69291,0.27559),(0.70079,0.27559),(0.70866,0.27559),(0.71654,0.27559),(0.72441,0.27559),(0.73228,0.27559),(0.74016,0.27559),(0.74803,0.27559),(0.75591,0.27559),(0.76378,0.27559),(0.77165,0.27559),(0.77953,0.27559),(0.7874,0.27559),(0.79528,0.27559),(0.80315,0.27559),(0.81102,0.27559),(0.8189,0.27559),(0.82677,0.27559),(0.83465,0.27559),(0.84252,0.27559),(0.85039,0.27559),(0.85827,0.27559),(0.86614,0.27559),(0.87402,0.27559),(0.88189,0.27559),(0.88976,0.27559),(0.89764,0.27559),(0.90551,0.27559),(0.91339,0.27559),(0.92126,0.27559),(0.92913,0.27559),(0.93701,0.27559),(0.94488,0.27559),(0.95276,0.27559),(0.96063,0.27559),(0.9685,0.27559),(0.97638,0.27559),(0.98425,0.27559),(0.99213,0.27559),(0.99609,0.27559),(0.00391,0.28346),(0.00787,0.28346),(0.01575,0.28346),(0.02362,0.28346),(0.0315,0.28346),(0.03937,0.28346),(0.04724,0.28346),(0.05512,0.28346),(0.06299,0.28346),(0.07087,0.28346),(0.07874,0.28346),(0.08661,0.28346),(0.09449,0.28346),(0.10236,0.28346),(0.11024,0.28346),(0.11811,0.28346),(0.12598,0.28346),(0.13386,0.28346),(0.14173,0.28346),(0.14961,0.28346),(0.15748,0.28346),(0.16535,0.28346),(0.17323,0.28346),(0.1811,0.28346),(0.18898,0.28346),(0.19685,0.28346),(0.20472,0.28346),(0.2126,0.28346),(0.22047,0.28346),(0.22835,0.28346),(0.23622,0.28346),(0.24409,0.28346),(0.25197,0.28346),(0.25984,0.28346),(0.26772,0.28346),(0.27559,0.28346),(0.28346,0.28346),(0.29134,0.28346),(0.29921,0.28346),(0.30709,0.28346),(0.31496,0.28346),(0.32283,0.28346),(0.33071,0.28346),(0.33858,0.28346),(0.34646,0.28346),(0.35433,0.28346),(0.3622,0.28346),(0.37008,0.28346),(0.37795,0.28346),(0.38583,0.28346),(0.3937,0.28346),(0.40157,0.28346),(0.40945,0.28346),(0.41732,0.28346),(0.4252,0.28346),(0.43307,0.28346),(0.44094,0.28346),(0.44882,0.28346),(0.45669,0.28346),(0.46457,0.28346),(0.47244,0.28346),(0.48031,0.28346),(0.48819,0.28346),(0.49606,0.28346),(0.50394,0.28346),(0.51181,0.28346),(0.51969,0.28346),(0.52756,0.28346),(0.53543,0.28346),(0.54331,0.28346),(0.55118,0.28346),(0.55906,0.28346),(0.56693,0.28346),(0.5748,0.28346),(0.58268,0.28346),(0.59055,0.28346),(0.59843,0.28346),(0.6063,0.28346),(0.61417,0.28346),(0.62205,0.28346),(0.62992,0.28346),(0.6378,0.28346),(0.64567,0.28346),(0.65354,0.28346),(0.66142,0.28346),(0.66929,0.28346),(0.67717,0.28346),(0.68504,0.28346),(0.69291,0.28346),(0.70079,0.28346),(0.70866,0.28346),(0.71654,0.28346),(0.72441,0.28346),(0.73228,0.28346),(0.74016,0.28346),(0.74803,0.28346),(0.75591,0.28346),(0.76378,0.28346),(0.77165,0.28346),(0.77953,0.28346),(0.7874,0.28346),(0.79528,0.28346),(0.80315,0.28346),(0.81102,0.28346),(0.8189,0.28346),(0.82677,0.28346),(0.83465,0.28346),(0.84252,0.28346),(0.85039,0.28346),(0.85827,0.28346),(0.86614,0.28346),(0.87402,0.28346),(0.88189,0.28346),(0.88976,0.28346),(0.89764,0.28346),(0.90551,0.28346),(0.91339,0.28346),(0.92126,0.28346),(0.92913,0.28346),(0.93701,0.28346),(0.94488,0.28346),(0.95276,0.28346),(0.96063,0.28346),(0.9685,0.28346),(0.97638,0.28346),(0.98425,0.28346),(0.99213,0.28346),(0.99609,0.28346),(0.00391,0.29134),(0.00787,0.29134),(0.01575,0.29134),(0.02362,0.29134),(0.0315,0.29134),(0.03937,0.29134),(0.04724,0.29134),(0.05512,0.29134),(0.06299,0.29134),(0.07087,0.29134),(0.07874,0.29134),(0.08661,0.29134),(0.09449,0.29134),(0.10236,0.29134),(0.11024,0.29134),(0.11811,0.29134),(0.12598,0.29134),(0.13386,0.29134),(0.14173,0.29134),(0.14961,0.29134),(0.15748,0.29134),(0.16535,0.29134),(0.17323,0.29134),(0.1811,0.29134),(0.18898,0.29134),(0.19685,0.29134),(0.20472,0.29134),(0.2126,0.29134),(0.22047,0.29134),(0.22835,0.29134),(0.23622,0.29134),(0.24409,0.29134),(0.25197,0.29134),(0.25984,0.29134),(0.26772,0.29134),(0.27559,0.29134),(0.28346,0.29134),(0.29134,0.29134),(0.29921,0.29134),(0.30709,0.29134),(0.31496,0.29134),(0.32283,0.29134),(0.33071,0.29134),(0.33858,0.29134),(0.34646,0.29134),(0.35433,0.29134),(0.3622,0.29134),(0.37008,0.29134),(0.37795,0.29134),(0.38583,0.29134),(0.3937,0.29134),(0.40157,0.29134),(0.40945,0.29134),(0.41732,0.29134),(0.4252,0.29134),(0.43307,0.29134),(0.44094,0.29134),(0.44882,0.29134),(0.45669,0.29134),(0.46457,0.29134),(0.47244,0.29134),(0.48031,0.29134),(0.48819,0.29134),(0.49606,0.29134),(0.50394,0.29134),(0.51181,0.29134),(0.51969,0.29134),(0.52756,0.29134),(0.53543,0.29134),(0.54331,0.29134),(0.55118,0.29134),(0.55906,0.29134),(0.56693,0.29134),(0.5748,0.29134),(0.58268,0.29134),(0.59055,0.29134),(0.59843,0.29134),(0.6063,0.29134),(0.61417,0.29134),(0.62205,0.29134),(0.62992,0.29134),(0.6378,0.29134),(0.64567,0.29134),(0.65354,0.29134),(0.66142,0.29134),(0.66929,0.29134),(0.67717,0.29134),(0.68504,0.29134),(0.69291,0.29134),(0.70079,0.29134),(0.70866,0.29134),(0.71654,0.29134),(0.72441,0.29134),(0.73228,0.29134),(0.74016,0.29134),(0.74803,0.29134),(0.75591,0.29134),(0.76378,0.29134),(0.77165,0.29134),(0.77953,0.29134),(0.7874,0.29134),(0.79528,0.29134),(0.80315,0.29134),(0.81102,0.29134),(0.8189,0.29134),(0.82677,0.29134),(0.83465,0.29134),(0.84252,0.29134),(0.85039,0.29134),(0.85827,0.29134),(0.86614,0.29134),(0.87402,0.29134),(0.88189,0.29134),(0.88976,0.29134),(0.89764,0.29134),(0.90551,0.29134),(0.91339,0.29134),(0.92126,0.29134),(0.92913,0.29134),(0.93701,0.29134),(0.94488,0.29134),(0.95276,0.29134),(0.96063,0.29134),(0.9685,0.29134),(0.97638,0.29134),(0.98425,0.29134),(0.99213,0.29134),(0.99609,0.29134),(0.00391,0.29921),(0.00787,0.29921),(0.01575,0.29921),(0.02362,0.29921),(0.0315,0.29921),(0.03937,0.29921),(0.04724,0.29921),(0.05512,0.29921),(0.06299,0.29921),(0.07087,0.29921),(0.07874,0.29921),(0.08661,0.29921),(0.09449,0.29921),(0.10236,0.29921),(0.11024,0.29921),(0.11811,0.29921),(0.12598,0.29921),(0.13386,0.29921),(0.14173,0.29921),(0.14961,0.29921),(0.15748,0.29921),(0.16535,0.29921),(0.17323,0.29921),(0.1811,0.29921),(0.18898,0.29921),(0.19685,0.29921),(0.20472,0.29921),(0.2126,0.29921),(0.22047,0.29921),(0.22835,0.29921),(0.23622,0.29921),(0.24409,0.29921),(0.25197,0.29921),(0.25984,0.29921),(0.26772,0.29921),(0.27559,0.29921),(0.28346,0.29921),(0.29134,0.29921),(0.29921,0.29921),(0.30709,0.29921),(0.31496,0.29921),(0.32283,0.29921),(0.33071,0.29921),(0.33858,0.29921),(0.34646,0.29921),(0.35433,0.29921),(0.3622,0.29921),(0.37008,0.29921),(0.37795,0.29921),(0.38583,0.29921),(0.3937,0.29921),(0.40157,0.29921),(0.40945,0.29921),(0.41732,0.29921),(0.4252,0.29921),(0.43307,0.29921),(0.44094,0.29921),(0.44882,0.29921),(0.45669,0.29921),(0.46457,0.29921),(0.47244,0.29921),(0.48031,0.29921),(0.48819,0.29921),(0.49606,0.29921),(0.50394,0.29921),(0.51181,0.29921),(0.51969,0.29921),(0.52756,0.29921),(0.53543,0.29921),(0.54331,0.29921),(0.55118,0.29921),(0.55906,0.29921),(0.56693,0.29921),(0.5748,0.29921),(0.58268,0.29921),(0.59055,0.29921),(0.59843,0.29921),(0.6063,0.29921),(0.61417,0.29921),(0.62205,0.29921),(0.62992,0.29921),(0.6378,0.29921),(0.64567,0.29921),(0.65354,0.29921),(0.66142,0.29921),(0.66929,0.29921),(0.67717,0.29921),(0.68504,0.29921),(0.69291,0.29921),(0.70079,0.29921),(0.70866,0.29921),(0.71654,0.29921),(0.72441,0.29921),(0.73228,0.29921),(0.74016,0.29921),(0.74803,0.29921),(0.75591,0.29921),(0.76378,0.29921),(0.77165,0.29921),(0.77953,0.29921),(0.7874,0.29921),(0.79528,0.29921),(0.80315,0.29921),(0.81102,0.29921),(0.8189,0.29921),(0.82677,0.29921),(0.83465,0.29921),(0.84252,0.29921),(0.85039,0.29921),(0.85827,0.29921),(0.86614,0.29921),(0.87402,0.29921),(0.88189,0.29921),(0.88976,0.29921),(0.89764,0.29921),(0.90551,0.29921),(0.91339,0.29921),(0.92126,0.29921),(0.92913,0.29921),(0.93701,0.29921),(0.94488,0.29921),(0.95276,0.29921),(0.96063,0.29921),(0.9685,0.29921),(0.97638,0.29921),(0.98425,0.29921),(0.99213,0.29921),(0.99609,0.29921),(0.00391,0.30709),(0.00787,0.30709),(0.01575,0.30709),(0.02362,0.30709),(0.0315,0.30709),(0.03937,0.30709),(0.04724,0.30709),(0.05512,0.30709),(0.06299,0.30709),(0.07087,0.30709),(0.07874,0.30709),(0.08661,0.30709),(0.09449,0.30709),(0.10236,0.30709),(0.11024,0.30709),(0.11811,0.30709),(0.12598,0.30709),(0.13386,0.30709),(0.14173,0.30709),(0.14961,0.30709),(0.15748,0.30709),(0.16535,0.30709),(0.17323,0.30709),(0.1811,0.30709),(0.18898,0.30709),(0.19685,0.30709),(0.20472,0.30709),(0.2126,0.30709),(0.22047,0.30709),(0.22835,0.30709),(0.23622,0.30709),(0.24409,0.30709),(0.25197,0.30709),(0.25984,0.30709),(0.26772,0.30709),(0.27559,0.30709),(0.28346,0.30709),(0.29134,0.30709),(0.29921,0.30709),(0.30709,0.30709),(0.31496,0.30709),(0.32283,0.30709),(0.33071,0.30709),(0.33858,0.30709),(0.34646,0.30709),(0.35433,0.30709),(0.3622,0.30709),(0.37008,0.30709),(0.37795,0.30709),(0.38583,0.30709),(0.3937,0.30709),(0.40157,0.30709),(0.40945,0.30709),(0.41732,0.30709),(0.4252,0.30709),(0.43307,0.30709),(0.44094,0.30709),(0.44882,0.30709),(0.45669,0.30709),(0.46457,0.30709),(0.47244,0.30709),(0.48031,0.30709),(0.48819,0.30709),(0.49606,0.30709),(0.50394,0.30709),(0.51181,0.30709),(0.51969,0.30709),(0.52756,0.30709),(0.53543,0.30709),(0.54331,0.30709),(0.55118,0.30709),(0.55906,0.30709),(0.56693,0.30709),(0.5748,0.30709),(0.58268,0.30709),(0.59055,0.30709),(0.59843,0.30709),(0.6063,0.30709),(0.61417,0.30709),(0.62205,0.30709),(0.62992,0.30709),(0.6378,0.30709),(0.64567,0.30709),(0.65354,0.30709),(0.66142,0.30709),(0.66929,0.30709),(0.67717,0.30709),(0.68504,0.30709),(0.69291,0.30709),(0.70079,0.30709),(0.70866,0.30709),(0.71654,0.30709),(0.72441,0.30709),(0.73228,0.30709),(0.74016,0.30709),(0.74803,0.30709),(0.75591,0.30709),(0.76378,0.30709),(0.77165,0.30709),(0.77953,0.30709),(0.7874,0.30709),(0.79528,0.30709),(0.80315,0.30709),(0.81102,0.30709),(0.8189,0.30709),(0.82677,0.30709),(0.83465,0.30709),(0.84252,0.30709),(0.85039,0.30709),(0.85827,0.30709),(0.86614,0.30709),(0.87402,0.30709),(0.88189,0.30709),(0.88976,0.30709),(0.89764,0.30709),(0.90551,0.30709),(0.91339,0.30709),(0.92126,0.30709),(0.92913,0.30709),(0.93701,0.30709),(0.94488,0.30709),(0.95276,0.30709),(0.96063,0.30709),(0.9685,0.30709),(0.97638,0.30709),(0.98425,0.30709),(0.99213,0.30709),(0.99609,0.30709),(0.00391,0.31496),(0.00787,0.31496),(0.01575,0.31496),(0.02362,0.31496),(0.0315,0.31496),(0.03937,0.31496),(0.04724,0.31496),(0.05512,0.31496),(0.06299,0.31496),(0.07087,0.31496),(0.07874,0.31496),(0.08661,0.31496),(0.09449,0.31496),(0.10236,0.31496),(0.11024,0.31496),(0.11811,0.31496),(0.12598,0.31496),(0.13386,0.31496),(0.14173,0.31496),(0.14961,0.31496),(0.15748,0.31496),(0.16535,0.31496),(0.17323,0.31496),(0.1811,0.31496),(0.18898,0.31496),(0.19685,0.31496),(0.20472,0.31496),(0.2126,0.31496),(0.22047,0.31496),(0.22835,0.31496),(0.23622,0.31496),(0.24409,0.31496),(0.25197,0.31496),(0.25984,0.31496),(0.26772,0.31496),(0.27559,0.31496),(0.28346,0.31496),(0.29134,0.31496),(0.29921,0.31496),(0.30709,0.31496),(0.31496,0.31496),(0.32283,0.31496),(0.33071,0.31496),(0.33858,0.31496),(0.34646,0.31496),(0.35433,0.31496),(0.3622,0.31496),(0.37008,0.31496),(0.37795,0.31496),(0.38583,0.31496),(0.3937,0.31496),(0.40157,0.31496),(0.40945,0.31496),(0.41732,0.31496),(0.4252,0.31496),(0.43307,0.31496),(0.44094,0.31496),(0.44882,0.31496),(0.45669,0.31496),(0.46457,0.31496),(0.47244,0.31496),(0.48031,0.31496),(0.48819,0.31496),(0.49606,0.31496),(0.50394,0.31496),(0.51181,0.31496),(0.51969,0.31496),(0.52756,0.31496),(0.53543,0.31496),(0.54331,0.31496),(0.55118,0.31496),(0.55906,0.31496),(0.56693,0.31496),(0.5748,0.31496),(0.58268,0.31496),(0.59055,0.31496),(0.59843,0.31496),(0.6063,0.31496),(0.61417,0.31496),(0.62205,0.31496),(0.62992,0.31496),(0.6378,0.31496),(0.64567,0.31496),(0.65354,0.31496),(0.66142,0.31496),(0.66929,0.31496),(0.67717,0.31496),(0.68504,0.31496),(0.69291,0.31496),(0.70079,0.31496),(0.70866,0.31496),(0.71654,0.31496),(0.72441,0.31496),(0.73228,0.31496),(0.74016,0.31496),(0.74803,0.31496),(0.75591,0.31496),(0.76378,0.31496),(0.77165,0.31496),(0.77953,0.31496),(0.7874,0.31496),(0.79528,0.31496),(0.80315,0.31496),(0.81102,0.31496),(0.8189,0.31496),(0.82677,0.31496),(0.83465,0.31496),(0.84252,0.31496),(0.85039,0.31496),(0.85827,0.31496),(0.86614,0.31496),(0.87402,0.31496),(0.88189,0.31496),(0.88976,0.31496),(0.89764,0.31496),(0.90551,0.31496),(0.91339,0.31496),(0.92126,0.31496),(0.92913,0.31496),(0.93701,0.31496),(0.94488,0.31496),(0.95276,0.31496),(0.96063,0.31496),(0.9685,0.31496),(0.97638,0.31496),(0.98425,0.31496),(0.99213,0.31496),(0.99609,0.31496),(0.00391,0.32283),(0.00787,0.32283),(0.01575,0.32283),(0.02362,0.32283),(0.0315,0.32283),(0.03937,0.32283),(0.04724,0.32283),(0.05512,0.32283),(0.06299,0.32283),(0.07087,0.32283),(0.07874,0.32283),(0.08661,0.32283),(0.09449,0.32283),(0.10236,0.32283),(0.11024,0.32283),(0.11811,0.32283),(0.12598,0.32283),(0.13386,0.32283),(0.14173,0.32283),(0.14961,0.32283),(0.15748,0.32283),(0.16535,0.32283),(0.17323,0.32283),(0.1811,0.32283),(0.18898,0.32283),(0.19685,0.32283),(0.20472,0.32283),(0.2126,0.32283),(0.22047,0.32283),(0.22835,0.32283),(0.23622,0.32283),(0.24409,0.32283),(0.25197,0.32283),(0.25984,0.32283),(0.26772,0.32283),(0.27559,0.32283),(0.28346,0.32283),(0.29134,0.32283),(0.29921,0.32283),(0.30709,0.32283),(0.31496,0.32283),(0.32283,0.32283),(0.33071,0.32283),(0.33858,0.32283),(0.34646,0.32283),(0.35433,0.32283),(0.3622,0.32283),(0.37008,0.32283),(0.37795,0.32283),(0.38583,0.32283),(0.3937,0.32283),(0.40157,0.32283),(0.40945,0.32283),(0.41732,0.32283),(0.4252,0.32283),(0.43307,0.32283),(0.44094,0.32283),(0.44882,0.32283),(0.45669,0.32283),(0.46457,0.32283),(0.47244,0.32283),(0.48031,0.32283),(0.48819,0.32283),(0.49606,0.32283),(0.50394,0.32283),(0.51181,0.32283),(0.51969,0.32283),(0.52756,0.32283),(0.53543,0.32283),(0.54331,0.32283),(0.55118,0.32283),(0.55906,0.32283),(0.56693,0.32283),(0.5748,0.32283),(0.58268,0.32283),(0.59055,0.32283),(0.59843,0.32283),(0.6063,0.32283),(0.61417,0.32283),(0.62205,0.32283),(0.62992,0.32283),(0.6378,0.32283),(0.64567,0.32283),(0.65354,0.32283),(0.66142,0.32283),(0.66929,0.32283),(0.67717,0.32283),(0.68504,0.32283),(0.69291,0.32283),(0.70079,0.32283),(0.70866,0.32283),(0.71654,0.32283),(0.72441,0.32283),(0.73228,0.32283),(0.74016,0.32283),(0.74803,0.32283),(0.75591,0.32283),(0.76378,0.32283),(0.77165,0.32283),(0.77953,0.32283),(0.7874,0.32283),(0.79528,0.32283),(0.80315,0.32283),(0.81102,0.32283),(0.8189,0.32283),(0.82677,0.32283),(0.83465,0.32283),(0.84252,0.32283),(0.85039,0.32283),(0.85827,0.32283),(0.86614,0.32283),(0.87402,0.32283),(0.88189,0.32283),(0.88976,0.32283),(0.89764,0.32283),(0.90551,0.32283),(0.91339,0.32283),(0.92126,0.32283),(0.92913,0.32283),(0.93701,0.32283),(0.94488,0.32283),(0.95276,0.32283),(0.96063,0.32283),(0.9685,0.32283),(0.97638,0.32283),(0.98425,0.32283),(0.99213,0.32283),(0.99609,0.32283),(0.00391,0.33071),(0.00787,0.33071),(0.01575,0.33071),(0.02362,0.33071),(0.0315,0.33071),(0.03937,0.33071),(0.04724,0.33071),(0.05512,0.33071),(0.06299,0.33071),(0.07087,0.33071),(0.07874,0.33071),(0.08661,0.33071),(0.09449,0.33071),(0.10236,0.33071),(0.11024,0.33071),(0.11811,0.33071),(0.12598,0.33071),(0.13386,0.33071),(0.14173,0.33071),(0.14961,0.33071),(0.15748,0.33071),(0.16535,0.33071),(0.17323,0.33071),(0.1811,0.33071),(0.18898,0.33071),(0.19685,0.33071),(0.20472,0.33071),(0.2126,0.33071),(0.22047,0.33071),(0.22835,0.33071),(0.23622,0.33071),(0.24409,0.33071),(0.25197,0.33071),(0.25984,0.33071),(0.26772,0.33071),(0.27559,0.33071),(0.28346,0.33071),(0.29134,0.33071),(0.29921,0.33071),(0.30709,0.33071),(0.31496,0.33071),(0.32283,0.33071),(0.33071,0.33071),(0.33858,0.33071),(0.34646,0.33071),(0.35433,0.33071),(0.3622,0.33071),(0.37008,0.33071),(0.37795,0.33071),(0.38583,0.33071),(0.3937,0.33071),(0.40157,0.33071),(0.40945,0.33071),(0.41732,0.33071),(0.4252,0.33071),(0.43307,0.33071),(0.44094,0.33071),(0.44882,0.33071),(0.45669,0.33071),(0.46457,0.33071),(0.47244,0.33071),(0.48031,0.33071),(0.48819,0.33071),(0.49606,0.33071),(0.50394,0.33071),(0.51181,0.33071),(0.51969,0.33071),(0.52756,0.33071),(0.53543,0.33071),(0.54331,0.33071),(0.55118,0.33071),(0.55906,0.33071),(0.56693,0.33071),(0.5748,0.33071),(0.58268,0.33071),(0.59055,0.33071),(0.59843,0.33071),(0.6063,0.33071),(0.61417,0.33071),(0.62205,0.33071),(0.62992,0.33071),(0.6378,0.33071),(0.64567,0.33071),(0.65354,0.33071),(0.66142,0.33071),(0.66929,0.33071),(0.67717,0.33071),(0.68504,0.33071),(0.69291,0.33071),(0.70079,0.33071),(0.70866,0.33071),(0.71654,0.33071),(0.72441,0.33071),(0.73228,0.33071),(0.74016,0.33071),(0.74803,0.33071),(0.75591,0.33071),(0.76378,0.33071),(0.77165,0.33071),(0.77953,0.33071),(0.7874,0.33071),(0.79528,0.33071),(0.80315,0.33071),(0.81102,0.33071),(0.8189,0.33071),(0.82677,0.33071),(0.83465,0.33071),(0.84252,0.33071),(0.85039,0.33071),(0.85827,0.33071),(0.86614,0.33071),(0.87402,0.33071),(0.88189,0.33071),(0.88976,0.33071),(0.89764,0.33071),(0.90551,0.33071),(0.91339,0.33071),(0.92126,0.33071),(0.92913,0.33071),(0.93701,0.33071),(0.94488,0.33071),(0.95276,0.33071),(0.96063,0.33071),(0.9685,0.33071),(0.97638,0.33071),(0.98425,0.33071),(0.99213,0.33071),(0.99609,0.33071),(0.00391,0.33858),(0.00787,0.33858),(0.01575,0.33858),(0.02362,0.33858),(0.0315,0.33858),(0.03937,0.33858),(0.04724,0.33858),(0.05512,0.33858),(0.06299,0.33858),(0.07087,0.33858),(0.07874,0.33858),(0.08661,0.33858),(0.09449,0.33858),(0.10236,0.33858),(0.11024,0.33858),(0.11811,0.33858),(0.12598,0.33858),(0.13386,0.33858),(0.14173,0.33858),(0.14961,0.33858),(0.15748,0.33858),(0.16535,0.33858),(0.17323,0.33858),(0.1811,0.33858),(0.18898,0.33858),(0.19685,0.33858),(0.20472,0.33858),(0.2126,0.33858),(0.22047,0.33858),(0.22835,0.33858),(0.23622,0.33858),(0.24409,0.33858),(0.25197,0.33858),(0.25984,0.33858),(0.26772,0.33858),(0.27559,0.33858),(0.28346,0.33858),(0.29134,0.33858),(0.29921,0.33858),(0.30709,0.33858),(0.31496,0.33858),(0.32283,0.33858),(0.33071,0.33858),(0.33858,0.33858),(0.34646,0.33858),(0.35433,0.33858),(0.3622,0.33858),(0.37008,0.33858),(0.37795,0.33858),(0.38583,0.33858),(0.3937,0.33858),(0.40157,0.33858),(0.40945,0.33858),(0.41732,0.33858),(0.4252,0.33858),(0.43307,0.33858),(0.44094,0.33858),(0.44882,0.33858),(0.45669,0.33858),(0.46457,0.33858),(0.47244,0.33858),(0.48031,0.33858),(0.48819,0.33858),(0.49606,0.33858),(0.50394,0.33858),(0.51181,0.33858),(0.51969,0.33858),(0.52756,0.33858),(0.53543,0.33858),(0.54331,0.33858),(0.55118,0.33858),(0.55906,0.33858),(0.56693,0.33858),(0.5748,0.33858),(0.58268,0.33858),(0.59055,0.33858),(0.59843,0.33858),(0.6063,0.33858),(0.61417,0.33858),(0.62205,0.33858),(0.62992,0.33858),(0.6378,0.33858),(0.64567,0.33858),(0.65354,0.33858),(0.66142,0.33858),(0.66929,0.33858),(0.67717,0.33858),(0.68504,0.33858),(0.69291,0.33858),(0.70079,0.33858),(0.70866,0.33858),(0.71654,0.33858),(0.72441,0.33858),(0.73228,0.33858),(0.74016,0.33858),(0.74803,0.33858),(0.75591,0.33858),(0.76378,0.33858),(0.77165,0.33858),(0.77953,0.33858),(0.7874,0.33858),(0.79528,0.33858),(0.80315,0.33858),(0.81102,0.33858),(0.8189,0.33858),(0.82677,0.33858),(0.83465,0.33858),(0.84252,0.33858),(0.85039,0.33858),(0.85827,0.33858),(0.86614,0.33858),(0.87402,0.33858),(0.88189,0.33858),(0.88976,0.33858),(0.89764,0.33858),(0.90551,0.33858),(0.91339,0.33858),(0.92126,0.33858),(0.92913,0.33858),(0.93701,0.33858),(0.94488,0.33858),(0.95276,0.33858),(0.96063,0.33858),(0.9685,0.33858),(0.97638,0.33858),(0.98425,0.33858),(0.99213,0.33858),(0.99609,0.33858),(0.00391,0.34646),(0.00787,0.34646),(0.01575,0.34646),(0.02362,0.34646),(0.0315,0.34646),(0.03937,0.34646),(0.04724,0.34646),(0.05512,0.34646),(0.06299,0.34646),(0.07087,0.34646),(0.07874,0.34646),(0.08661,0.34646),(0.09449,0.34646),(0.10236,0.34646),(0.11024,0.34646),(0.11811,0.34646),(0.12598,0.34646),(0.13386,0.34646),(0.14173,0.34646),(0.14961,0.34646),(0.15748,0.34646),(0.16535,0.34646),(0.17323,0.34646),(0.1811,0.34646),(0.18898,0.34646),(0.19685,0.34646),(0.20472,0.34646),(0.2126,0.34646),(0.22047,0.34646),(0.22835,0.34646),(0.23622,0.34646),(0.24409,0.34646),(0.25197,0.34646),(0.25984,0.34646),(0.26772,0.34646),(0.27559,0.34646),(0.28346,0.34646),(0.29134,0.34646),(0.29921,0.34646),(0.30709,0.34646),(0.31496,0.34646),(0.32283,0.34646),(0.33071,0.34646),(0.33858,0.34646),(0.34646,0.34646),(0.35433,0.34646),(0.3622,0.34646),(0.37008,0.34646),(0.37795,0.34646),(0.38583,0.34646),(0.3937,0.34646),(0.40157,0.34646),(0.40945,0.34646),(0.41732,0.34646),(0.4252,0.34646),(0.43307,0.34646),(0.44094,0.34646),(0.44882,0.34646),(0.45669,0.34646),(0.46457,0.34646),(0.47244,0.34646),(0.48031,0.34646),(0.48819,0.34646),(0.49606,0.34646),(0.50394,0.34646),(0.51181,0.34646),(0.51969,0.34646),(0.52756,0.34646),(0.53543,0.34646),(0.54331,0.34646),(0.55118,0.34646),(0.55906,0.34646),(0.56693,0.34646),(0.5748,0.34646),(0.58268,0.34646),(0.59055,0.34646),(0.59843,0.34646),(0.6063,0.34646),(0.61417,0.34646),(0.62205,0.34646),(0.62992,0.34646),(0.6378,0.34646),(0.64567,0.34646),(0.65354,0.34646),(0.66142,0.34646),(0.66929,0.34646),(0.67717,0.34646),(0.68504,0.34646),(0.69291,0.34646),(0.70079,0.34646),(0.70866,0.34646),(0.71654,0.34646),(0.72441,0.34646),(0.73228,0.34646),(0.74016,0.34646),(0.74803,0.34646),(0.75591,0.34646),(0.76378,0.34646),(0.77165,0.34646),(0.77953,0.34646),(0.7874,0.34646),(0.79528,0.34646),(0.80315,0.34646),(0.81102,0.34646),(0.8189,0.34646),(0.82677,0.34646),(0.83465,0.34646),(0.84252,0.34646),(0.85039,0.34646),(0.85827,0.34646),(0.86614,0.34646),(0.87402,0.34646),(0.88189,0.34646),(0.88976,0.34646),(0.89764,0.34646),(0.90551,0.34646),(0.91339,0.34646),(0.92126,0.34646),(0.92913,0.34646),(0.93701,0.34646),(0.94488,0.34646),(0.95276,0.34646),(0.96063,0.34646),(0.9685,0.34646),(0.97638,0.34646),(0.98425,0.34646),(0.99213,0.34646),(0.99609,0.34646),(0.00391,0.35433),(0.00787,0.35433),(0.01575,0.35433),(0.02362,0.35433),(0.0315,0.35433),(0.03937,0.35433),(0.04724,0.35433),(0.05512,0.35433),(0.06299,0.35433),(0.07087,0.35433),(0.07874,0.35433),(0.08661,0.35433),(0.09449,0.35433),(0.10236,0.35433),(0.11024,0.35433),(0.11811,0.35433),(0.12598,0.35433),(0.13386,0.35433),(0.14173,0.35433),(0.14961,0.35433),(0.15748,0.35433),(0.16535,0.35433),(0.17323,0.35433),(0.1811,0.35433),(0.18898,0.35433),(0.19685,0.35433),(0.20472,0.35433),(0.2126,0.35433),(0.22047,0.35433),(0.22835,0.35433),(0.23622,0.35433),(0.24409,0.35433),(0.25197,0.35433),(0.25984,0.35433),(0.26772,0.35433),(0.27559,0.35433),(0.28346,0.35433),(0.29134,0.35433),(0.29921,0.35433),(0.30709,0.35433),(0.31496,0.35433),(0.32283,0.35433),(0.33071,0.35433),(0.33858,0.35433),(0.34646,0.35433),(0.35433,0.35433),(0.3622,0.35433),(0.37008,0.35433),(0.37795,0.35433),(0.38583,0.35433),(0.3937,0.35433),(0.40157,0.35433),(0.40945,0.35433),(0.41732,0.35433),(0.4252,0.35433),(0.43307,0.35433),(0.44094,0.35433),(0.44882,0.35433),(0.45669,0.35433),(0.46457,0.35433),(0.47244,0.35433),(0.48031,0.35433),(0.48819,0.35433),(0.49606,0.35433),(0.50394,0.35433),(0.51181,0.35433),(0.51969,0.35433),(0.52756,0.35433),(0.53543,0.35433),(0.54331,0.35433),(0.55118,0.35433),(0.55906,0.35433),(0.56693,0.35433),(0.5748,0.35433),(0.58268,0.35433),(0.59055,0.35433),(0.59843,0.35433),(0.6063,0.35433),(0.61417,0.35433),(0.62205,0.35433),(0.62992,0.35433),(0.6378,0.35433),(0.64567,0.35433),(0.65354,0.35433),(0.66142,0.35433),(0.66929,0.35433),(0.67717,0.35433),(0.68504,0.35433),(0.69291,0.35433),(0.70079,0.35433),(0.70866,0.35433),(0.71654,0.35433),(0.72441,0.35433),(0.73228,0.35433),(0.74016,0.35433),(0.74803,0.35433),(0.75591,0.35433),(0.76378,0.35433),(0.77165,0.35433),(0.77953,0.35433),(0.7874,0.35433),(0.79528,0.35433),(0.80315,0.35433),(0.81102,0.35433),(0.8189,0.35433),(0.82677,0.35433),(0.83465,0.35433),(0.84252,0.35433),(0.85039,0.35433),(0.85827,0.35433),(0.86614,0.35433),(0.87402,0.35433),(0.88189,0.35433),(0.88976,0.35433),(0.89764,0.35433),(0.90551,0.35433),(0.91339,0.35433),(0.92126,0.35433),(0.92913,0.35433),(0.93701,0.35433),(0.94488,0.35433),(0.95276,0.35433),(0.96063,0.35433),(0.9685,0.35433),(0.97638,0.35433),(0.98425,0.35433),(0.99213,0.35433),(0.99609,0.35433),(0.00391,0.3622),(0.00787,0.3622),(0.01575,0.3622),(0.02362,0.3622),(0.0315,0.3622),(0.03937,0.3622),(0.04724,0.3622),(0.05512,0.3622),(0.06299,0.3622),(0.07087,0.3622),(0.07874,0.3622),(0.08661,0.3622),(0.09449,0.3622),(0.10236,0.3622),(0.11024,0.3622),(0.11811,0.3622),(0.12598,0.3622),(0.13386,0.3622),(0.14173,0.3622),(0.14961,0.3622),(0.15748,0.3622),(0.16535,0.3622),(0.17323,0.3622),(0.1811,0.3622),(0.18898,0.3622),(0.19685,0.3622),(0.20472,0.3622),(0.2126,0.3622),(0.22047,0.3622),(0.22835,0.3622),(0.23622,0.3622),(0.24409,0.3622),(0.25197,0.3622),(0.25984,0.3622),(0.26772,0.3622),(0.27559,0.3622),(0.28346,0.3622),(0.29134,0.3622),(0.29921,0.3622),(0.30709,0.3622),(0.31496,0.3622),(0.32283,0.3622),(0.33071,0.3622),(0.33858,0.3622),(0.34646,0.3622),(0.35433,0.3622),(0.3622,0.3622),(0.37008,0.3622),(0.37795,0.3622),(0.38583,0.3622),(0.3937,0.3622),(0.40157,0.3622),(0.40945,0.3622),(0.41732,0.3622),(0.4252,0.3622),(0.43307,0.3622),(0.44094,0.3622),(0.44882,0.3622),(0.45669,0.3622),(0.46457,0.3622),(0.47244,0.3622),(0.48031,0.3622),(0.48819,0.3622),(0.49606,0.3622),(0.50394,0.3622),(0.51181,0.3622),(0.51969,0.3622),(0.52756,0.3622),(0.53543,0.3622),(0.54331,0.3622),(0.55118,0.3622),(0.55906,0.3622),(0.56693,0.3622),(0.5748,0.3622),(0.58268,0.3622),(0.59055,0.3622),(0.59843,0.3622),(0.6063,0.3622),(0.61417,0.3622),(0.62205,0.3622),(0.62992,0.3622),(0.6378,0.3622),(0.64567,0.3622),(0.65354,0.3622),(0.66142,0.3622),(0.66929,0.3622),(0.67717,0.3622),(0.68504,0.3622),(0.69291,0.3622),(0.70079,0.3622),(0.70866,0.3622),(0.71654,0.3622),(0.72441,0.3622),(0.73228,0.3622),(0.74016,0.3622),(0.74803,0.3622),(0.75591,0.3622),(0.76378,0.3622),(0.77165,0.3622),(0.77953,0.3622),(0.7874,0.3622),(0.79528,0.3622),(0.80315,0.3622),(0.81102,0.3622),(0.8189,0.3622),(0.82677,0.3622),(0.83465,0.3622),(0.84252,0.3622),(0.85039,0.3622),(0.85827,0.3622),(0.86614,0.3622),(0.87402,0.3622),(0.88189,0.3622),(0.88976,0.3622),(0.89764,0.3622),(0.90551,0.3622),(0.91339,0.3622),(0.92126,0.3622),(0.92913,0.3622),(0.93701,0.3622),(0.94488,0.3622),(0.95276,0.3622),(0.96063,0.3622),(0.9685,0.3622),(0.97638,0.3622),(0.98425,0.3622),(0.99213,0.3622),(0.99609,0.3622),(0.00391,0.37008),(0.00787,0.37008),(0.01575,0.37008),(0.02362,0.37008),(0.0315,0.37008),(0.03937,0.37008),(0.04724,0.37008),(0.05512,0.37008),(0.06299,0.37008),(0.07087,0.37008),(0.07874,0.37008),(0.08661,0.37008),(0.09449,0.37008),(0.10236,0.37008),(0.11024,0.37008),(0.11811,0.37008),(0.12598,0.37008),(0.13386,0.37008),(0.14173,0.37008),(0.14961,0.37008),(0.15748,0.37008),(0.16535,0.37008),(0.17323,0.37008),(0.1811,0.37008),(0.18898,0.37008),(0.19685,0.37008),(0.20472,0.37008),(0.2126,0.37008),(0.22047,0.37008),(0.22835,0.37008),(0.23622,0.37008),(0.24409,0.37008),(0.25197,0.37008),(0.25984,0.37008),(0.26772,0.37008),(0.27559,0.37008),(0.28346,0.37008),(0.29134,0.37008),(0.29921,0.37008),(0.30709,0.37008),(0.31496,0.37008),(0.32283,0.37008),(0.33071,0.37008),(0.33858,0.37008),(0.34646,0.37008),(0.35433,0.37008),(0.3622,0.37008),(0.37008,0.37008),(0.37795,0.37008),(0.38583,0.37008),(0.3937,0.37008),(0.40157,0.37008),(0.40945,0.37008),(0.41732,0.37008),(0.4252,0.37008),(0.43307,0.37008),(0.44094,0.37008),(0.44882,0.37008),(0.45669,0.37008),(0.46457,0.37008),(0.47244,0.37008),(0.48031,0.37008),(0.48819,0.37008),(0.49606,0.37008),(0.50394,0.37008),(0.51181,0.37008),(0.51969,0.37008),(0.52756,0.37008),(0.53543,0.37008),(0.54331,0.37008),(0.55118,0.37008),(0.55906,0.37008),(0.56693,0.37008),(0.5748,0.37008),(0.58268,0.37008),(0.59055,0.37008),(0.59843,0.37008),(0.6063,0.37008),(0.61417,0.37008),(0.62205,0.37008),(0.62992,0.37008),(0.6378,0.37008),(0.64567,0.37008),(0.65354,0.37008),(0.66142,0.37008),(0.66929,0.37008),(0.67717,0.37008),(0.68504,0.37008),(0.69291,0.37008),(0.70079,0.37008),(0.70866,0.37008),(0.71654,0.37008),(0.72441,0.37008),(0.73228,0.37008),(0.74016,0.37008),(0.74803,0.37008),(0.75591,0.37008),(0.76378,0.37008),(0.77165,0.37008),(0.77953,0.37008),(0.7874,0.37008),(0.79528,0.37008),(0.80315,0.37008),(0.81102,0.37008),(0.8189,0.37008),(0.82677,0.37008),(0.83465,0.37008),(0.84252,0.37008),(0.85039,0.37008),(0.85827,0.37008),(0.86614,0.37008),(0.87402,0.37008),(0.88189,0.37008),(0.88976,0.37008),(0.89764,0.37008),(0.90551,0.37008),(0.91339,0.37008),(0.92126,0.37008),(0.92913,0.37008),(0.93701,0.37008),(0.94488,0.37008),(0.95276,0.37008),(0.96063,0.37008),(0.9685,0.37008),(0.97638,0.37008),(0.98425,0.37008),(0.99213,0.37008),(0.99609,0.37008),(0.00391,0.37795),(0.00787,0.37795),(0.01575,0.37795),(0.02362,0.37795),(0.0315,0.37795),(0.03937,0.37795),(0.04724,0.37795),(0.05512,0.37795),(0.06299,0.37795),(0.07087,0.37795),(0.07874,0.37795),(0.08661,0.37795),(0.09449,0.37795),(0.10236,0.37795),(0.11024,0.37795),(0.11811,0.37795),(0.12598,0.37795),(0.13386,0.37795),(0.14173,0.37795),(0.14961,0.37795),(0.15748,0.37795),(0.16535,0.37795),(0.17323,0.37795),(0.1811,0.37795),(0.18898,0.37795),(0.19685,0.37795),(0.20472,0.37795),(0.2126,0.37795),(0.22047,0.37795),(0.22835,0.37795),(0.23622,0.37795),(0.24409,0.37795),(0.25197,0.37795),(0.25984,0.37795),(0.26772,0.37795),(0.27559,0.37795),(0.28346,0.37795),(0.29134,0.37795),(0.29921,0.37795),(0.30709,0.37795),(0.31496,0.37795),(0.32283,0.37795),(0.33071,0.37795),(0.33858,0.37795),(0.34646,0.37795),(0.35433,0.37795),(0.3622,0.37795),(0.37008,0.37795),(0.37795,0.37795),(0.38583,0.37795),(0.3937,0.37795),(0.40157,0.37795),(0.40945,0.37795),(0.41732,0.37795),(0.4252,0.37795),(0.43307,0.37795),(0.44094,0.37795),(0.44882,0.37795),(0.45669,0.37795),(0.46457,0.37795),(0.47244,0.37795),(0.48031,0.37795),(0.48819,0.37795),(0.49606,0.37795),(0.50394,0.37795),(0.51181,0.37795),(0.51969,0.37795),(0.52756,0.37795),(0.53543,0.37795),(0.54331,0.37795),(0.55118,0.37795),(0.55906,0.37795),(0.56693,0.37795),(0.5748,0.37795),(0.58268,0.37795),(0.59055,0.37795),(0.59843,0.37795),(0.6063,0.37795),(0.61417,0.37795),(0.62205,0.37795),(0.62992,0.37795),(0.6378,0.37795),(0.64567,0.37795),(0.65354,0.37795),(0.66142,0.37795),(0.66929,0.37795),(0.67717,0.37795),(0.68504,0.37795),(0.69291,0.37795),(0.70079,0.37795),(0.70866,0.37795),(0.71654,0.37795),(0.72441,0.37795),(0.73228,0.37795),(0.74016,0.37795),(0.74803,0.37795),(0.75591,0.37795),(0.76378,0.37795),(0.77165,0.37795),(0.77953,0.37795),(0.7874,0.37795),(0.79528,0.37795),(0.80315,0.37795),(0.81102,0.37795),(0.8189,0.37795),(0.82677,0.37795),(0.83465,0.37795),(0.84252,0.37795),(0.85039,0.37795),(0.85827,0.37795),(0.86614,0.37795),(0.87402,0.37795),(0.88189,0.37795),(0.88976,0.37795),(0.89764,0.37795),(0.90551,0.37795),(0.91339,0.37795),(0.92126,0.37795),(0.92913,0.37795),(0.93701,0.37795),(0.94488,0.37795),(0.95276,0.37795),(0.96063,0.37795),(0.9685,0.37795),(0.97638,0.37795),(0.98425,0.37795),(0.99213,0.37795),(0.99609,0.37795),(0.00391,0.38583),(0.00787,0.38583),(0.01575,0.38583),(0.02362,0.38583),(0.0315,0.38583),(0.03937,0.38583),(0.04724,0.38583),(0.05512,0.38583),(0.06299,0.38583),(0.07087,0.38583),(0.07874,0.38583),(0.08661,0.38583),(0.09449,0.38583),(0.10236,0.38583),(0.11024,0.38583),(0.11811,0.38583),(0.12598,0.38583),(0.13386,0.38583),(0.14173,0.38583),(0.14961,0.38583),(0.15748,0.38583),(0.16535,0.38583),(0.17323,0.38583),(0.1811,0.38583),(0.18898,0.38583),(0.19685,0.38583),(0.20472,0.38583),(0.2126,0.38583),(0.22047,0.38583),(0.22835,0.38583),(0.23622,0.38583),(0.24409,0.38583),(0.25197,0.38583),(0.25984,0.38583),(0.26772,0.38583),(0.27559,0.38583),(0.28346,0.38583),(0.29134,0.38583),(0.29921,0.38583),(0.30709,0.38583),(0.31496,0.38583),(0.32283,0.38583),(0.33071,0.38583),(0.33858,0.38583),(0.34646,0.38583),(0.35433,0.38583),(0.3622,0.38583),(0.37008,0.38583),(0.37795,0.38583),(0.38583,0.38583),(0.3937,0.38583),(0.40157,0.38583),(0.40945,0.38583),(0.41732,0.38583),(0.4252,0.38583),(0.43307,0.38583),(0.44094,0.38583),(0.44882,0.38583),(0.45669,0.38583),(0.46457,0.38583),(0.47244,0.38583),(0.48031,0.38583),(0.48819,0.38583),(0.49606,0.38583),(0.50394,0.38583),(0.51181,0.38583),(0.51969,0.38583),(0.52756,0.38583),(0.53543,0.38583),(0.54331,0.38583),(0.55118,0.38583),(0.55906,0.38583),(0.56693,0.38583),(0.5748,0.38583),(0.58268,0.38583),(0.59055,0.38583),(0.59843,0.38583),(0.6063,0.38583),(0.61417,0.38583),(0.62205,0.38583),(0.62992,0.38583),(0.6378,0.38583),(0.64567,0.38583),(0.65354,0.38583),(0.66142,0.38583),(0.66929,0.38583),(0.67717,0.38583),(0.68504,0.38583),(0.69291,0.38583),(0.70079,0.38583),(0.70866,0.38583),(0.71654,0.38583),(0.72441,0.38583),(0.73228,0.38583),(0.74016,0.38583),(0.74803,0.38583),(0.75591,0.38583),(0.76378,0.38583),(0.77165,0.38583),(0.77953,0.38583),(0.7874,0.38583),(0.79528,0.38583),(0.80315,0.38583),(0.81102,0.38583),(0.8189,0.38583),(0.82677,0.38583),(0.83465,0.38583),(0.84252,0.38583),(0.85039,0.38583),(0.85827,0.38583),(0.86614,0.38583),(0.87402,0.38583),(0.88189,0.38583),(0.88976,0.38583),(0.89764,0.38583),(0.90551,0.38583),(0.91339,0.38583),(0.92126,0.38583),(0.92913,0.38583),(0.93701,0.38583),(0.94488,0.38583),(0.95276,0.38583),(0.96063,0.38583),(0.9685,0.38583),(0.97638,0.38583),(0.98425,0.38583),(0.99213,0.38583),(0.99609,0.38583),(0.00391,0.3937),(0.00787,0.3937),(0.01575,0.3937),(0.02362,0.3937),(0.0315,0.3937),(0.03937,0.3937),(0.04724,0.3937),(0.05512,0.3937),(0.06299,0.3937),(0.07087,0.3937),(0.07874,0.3937),(0.08661,0.3937),(0.09449,0.3937),(0.10236,0.3937),(0.11024,0.3937),(0.11811,0.3937),(0.12598,0.3937),(0.13386,0.3937),(0.14173,0.3937),(0.14961,0.3937),(0.15748,0.3937),(0.16535,0.3937),(0.17323,0.3937),(0.1811,0.3937),(0.18898,0.3937),(0.19685,0.3937),(0.20472,0.3937),(0.2126,0.3937),(0.22047,0.3937),(0.22835,0.3937),(0.23622,0.3937),(0.24409,0.3937),(0.25197,0.3937),(0.25984,0.3937),(0.26772,0.3937),(0.27559,0.3937),(0.28346,0.3937),(0.29134,0.3937),(0.29921,0.3937),(0.30709,0.3937),(0.31496,0.3937),(0.32283,0.3937),(0.33071,0.3937),(0.33858,0.3937),(0.34646,0.3937),(0.35433,0.3937),(0.3622,0.3937),(0.37008,0.3937),(0.37795,0.3937),(0.38583,0.3937),(0.3937,0.3937),(0.40157,0.3937),(0.40945,0.3937),(0.41732,0.3937),(0.4252,0.3937),(0.43307,0.3937),(0.44094,0.3937),(0.44882,0.3937),(0.45669,0.3937),(0.46457,0.3937),(0.47244,0.3937),(0.48031,0.3937),(0.48819,0.3937),(0.49606,0.3937),(0.50394,0.3937),(0.51181,0.3937),(0.51969,0.3937),(0.52756,0.3937),(0.53543,0.3937),(0.54331,0.3937),(0.55118,0.3937),(0.55906,0.3937),(0.56693,0.3937),(0.5748,0.3937),(0.58268,0.3937),(0.59055,0.3937),(0.59843,0.3937),(0.6063,0.3937),(0.61417,0.3937),(0.62205,0.3937),(0.62992,0.3937),(0.6378,0.3937),(0.64567,0.3937),(0.65354,0.3937),(0.66142,0.3937),(0.66929,0.3937),(0.67717,0.3937),(0.68504,0.3937),(0.69291,0.3937),(0.70079,0.3937),(0.70866,0.3937),(0.71654,0.3937),(0.72441,0.3937),(0.73228,0.3937),(0.74016,0.3937),(0.74803,0.3937),(0.75591,0.3937),(0.76378,0.3937),(0.77165,0.3937),(0.77953,0.3937),(0.7874,0.3937),(0.79528,0.3937),(0.80315,0.3937),(0.81102,0.3937),(0.8189,0.3937),(0.82677,0.3937),(0.83465,0.3937),(0.84252,0.3937),(0.85039,0.3937),(0.85827,0.3937),(0.86614,0.3937),(0.87402,0.3937),(0.88189,0.3937),(0.88976,0.3937),(0.89764,0.3937),(0.90551,0.3937),(0.91339,0.3937),(0.92126,0.3937),(0.92913,0.3937),(0.93701,0.3937),(0.94488,0.3937),(0.95276,0.3937),(0.96063,0.3937),(0.9685,0.3937),(0.97638,0.3937),(0.98425,0.3937),(0.99213,0.3937),(0.99609,0.3937),(0.00391,0.40157),(0.00787,0.40157),(0.01575,0.40157),(0.02362,0.40157),(0.0315,0.40157),(0.03937,0.40157),(0.04724,0.40157),(0.05512,0.40157),(0.06299,0.40157),(0.07087,0.40157),(0.07874,0.40157),(0.08661,0.40157),(0.09449,0.40157),(0.10236,0.40157),(0.11024,0.40157),(0.11811,0.40157),(0.12598,0.40157),(0.13386,0.40157),(0.14173,0.40157),(0.14961,0.40157),(0.15748,0.40157),(0.16535,0.40157),(0.17323,0.40157),(0.1811,0.40157),(0.18898,0.40157),(0.19685,0.40157),(0.20472,0.40157),(0.2126,0.40157),(0.22047,0.40157),(0.22835,0.40157),(0.23622,0.40157),(0.24409,0.40157),(0.25197,0.40157),(0.25984,0.40157),(0.26772,0.40157),(0.27559,0.40157),(0.28346,0.40157),(0.29134,0.40157),(0.29921,0.40157),(0.30709,0.40157),(0.31496,0.40157),(0.32283,0.40157),(0.33071,0.40157),(0.33858,0.40157),(0.34646,0.40157),(0.35433,0.40157),(0.3622,0.40157),(0.37008,0.40157),(0.37795,0.40157),(0.38583,0.40157),(0.3937,0.40157),(0.40157,0.40157),(0.40945,0.40157),(0.41732,0.40157),(0.4252,0.40157),(0.43307,0.40157),(0.44094,0.40157),(0.44882,0.40157),(0.45669,0.40157),(0.46457,0.40157),(0.47244,0.40157),(0.48031,0.40157),(0.48819,0.40157),(0.49606,0.40157),(0.50394,0.40157),(0.51181,0.40157),(0.51969,0.40157),(0.52756,0.40157),(0.53543,0.40157),(0.54331,0.40157),(0.55118,0.40157),(0.55906,0.40157),(0.56693,0.40157),(0.5748,0.40157),(0.58268,0.40157),(0.59055,0.40157),(0.59843,0.40157),(0.6063,0.40157),(0.61417,0.40157),(0.62205,0.40157),(0.62992,0.40157),(0.6378,0.40157),(0.64567,0.40157),(0.65354,0.40157),(0.66142,0.40157),(0.66929,0.40157),(0.67717,0.40157),(0.68504,0.40157),(0.69291,0.40157),(0.70079,0.40157),(0.70866,0.40157),(0.71654,0.40157),(0.72441,0.40157),(0.73228,0.40157),(0.74016,0.40157),(0.74803,0.40157),(0.75591,0.40157),(0.76378,0.40157),(0.77165,0.40157),(0.77953,0.40157),(0.7874,0.40157),(0.79528,0.40157),(0.80315,0.40157),(0.81102,0.40157),(0.8189,0.40157),(0.82677,0.40157),(0.83465,0.40157),(0.84252,0.40157),(0.85039,0.40157),(0.85827,0.40157),(0.86614,0.40157),(0.87402,0.40157),(0.88189,0.40157),(0.88976,0.40157),(0.89764,0.40157),(0.90551,0.40157),(0.91339,0.40157),(0.92126,0.40157),(0.92913,0.40157),(0.93701,0.40157),(0.94488,0.40157),(0.95276,0.40157),(0.96063,0.40157),(0.9685,0.40157),(0.97638,0.40157),(0.98425,0.40157),(0.99213,0.40157),(0.99609,0.40157),(0.00391,0.40945),(0.00787,0.40945),(0.01575,0.40945),(0.02362,0.40945),(0.0315,0.40945),(0.03937,0.40945),(0.04724,0.40945),(0.05512,0.40945),(0.06299,0.40945),(0.07087,0.40945),(0.07874,0.40945),(0.08661,0.40945),(0.09449,0.40945),(0.10236,0.40945),(0.11024,0.40945),(0.11811,0.40945),(0.12598,0.40945),(0.13386,0.40945),(0.14173,0.40945),(0.14961,0.40945),(0.15748,0.40945),(0.16535,0.40945),(0.17323,0.40945),(0.1811,0.40945),(0.18898,0.40945),(0.19685,0.40945),(0.20472,0.40945),(0.2126,0.40945),(0.22047,0.40945),(0.22835,0.40945),(0.23622,0.40945),(0.24409,0.40945),(0.25197,0.40945),(0.25984,0.40945),(0.26772,0.40945),(0.27559,0.40945),(0.28346,0.40945),(0.29134,0.40945),(0.29921,0.40945),(0.30709,0.40945),(0.31496,0.40945),(0.32283,0.40945),(0.33071,0.40945),(0.33858,0.40945),(0.34646,0.40945),(0.35433,0.40945),(0.3622,0.40945),(0.37008,0.40945),(0.37795,0.40945),(0.38583,0.40945),(0.3937,0.40945),(0.40157,0.40945),(0.40945,0.40945),(0.41732,0.40945),(0.4252,0.40945),(0.43307,0.40945),(0.44094,0.40945),(0.44882,0.40945),(0.45669,0.40945),(0.46457,0.40945),(0.47244,0.40945),(0.48031,0.40945),(0.48819,0.40945),(0.49606,0.40945),(0.50394,0.40945),(0.51181,0.40945),(0.51969,0.40945),(0.52756,0.40945),(0.53543,0.40945),(0.54331,0.40945),(0.55118,0.40945),(0.55906,0.40945),(0.56693,0.40945),(0.5748,0.40945),(0.58268,0.40945),(0.59055,0.40945),(0.59843,0.40945),(0.6063,0.40945),(0.61417,0.40945),(0.62205,0.40945),(0.62992,0.40945),(0.6378,0.40945),(0.64567,0.40945),(0.65354,0.40945),(0.66142,0.40945),(0.66929,0.40945),(0.67717,0.40945),(0.68504,0.40945),(0.69291,0.40945),(0.70079,0.40945),(0.70866,0.40945),(0.71654,0.40945),(0.72441,0.40945),(0.73228,0.40945),(0.74016,0.40945),(0.74803,0.40945),(0.75591,0.40945),(0.76378,0.40945),(0.77165,0.40945),(0.77953,0.40945),(0.7874,0.40945),(0.79528,0.40945),(0.80315,0.40945),(0.81102,0.40945),(0.8189,0.40945),(0.82677,0.40945),(0.83465,0.40945),(0.84252,0.40945),(0.85039,0.40945),(0.85827,0.40945),(0.86614,0.40945),(0.87402,0.40945),(0.88189,0.40945),(0.88976,0.40945),(0.89764,0.40945),(0.90551,0.40945),(0.91339,0.40945),(0.92126,0.40945),(0.92913,0.40945),(0.93701,0.40945),(0.94488,0.40945),(0.95276,0.40945),(0.96063,0.40945),(0.9685,0.40945),(0.97638,0.40945),(0.98425,0.40945),(0.99213,0.40945),(0.99609,0.40945),(0.00391,0.41732),(0.00787,0.41732),(0.01575,0.41732),(0.02362,0.41732),(0.0315,0.41732),(0.03937,0.41732),(0.04724,0.41732),(0.05512,0.41732),(0.06299,0.41732),(0.07087,0.41732),(0.07874,0.41732),(0.08661,0.41732),(0.09449,0.41732),(0.10236,0.41732),(0.11024,0.41732),(0.11811,0.41732),(0.12598,0.41732),(0.13386,0.41732),(0.14173,0.41732),(0.14961,0.41732),(0.15748,0.41732),(0.16535,0.41732),(0.17323,0.41732),(0.1811,0.41732),(0.18898,0.41732),(0.19685,0.41732),(0.20472,0.41732),(0.2126,0.41732),(0.22047,0.41732),(0.22835,0.41732),(0.23622,0.41732),(0.24409,0.41732),(0.25197,0.41732),(0.25984,0.41732),(0.26772,0.41732),(0.27559,0.41732),(0.28346,0.41732),(0.29134,0.41732),(0.29921,0.41732),(0.30709,0.41732),(0.31496,0.41732),(0.32283,0.41732),(0.33071,0.41732),(0.33858,0.41732),(0.34646,0.41732),(0.35433,0.41732),(0.3622,0.41732),(0.37008,0.41732),(0.37795,0.41732),(0.38583,0.41732),(0.3937,0.41732),(0.40157,0.41732),(0.40945,0.41732),(0.41732,0.41732),(0.4252,0.41732),(0.43307,0.41732),(0.44094,0.41732),(0.44882,0.41732),(0.45669,0.41732),(0.46457,0.41732),(0.47244,0.41732),(0.48031,0.41732),(0.48819,0.41732),(0.49606,0.41732),(0.50394,0.41732),(0.51181,0.41732),(0.51969,0.41732),(0.52756,0.41732),(0.53543,0.41732),(0.54331,0.41732),(0.55118,0.41732),(0.55906,0.41732),(0.56693,0.41732),(0.5748,0.41732),(0.58268,0.41732),(0.59055,0.41732),(0.59843,0.41732),(0.6063,0.41732),(0.61417,0.41732),(0.62205,0.41732),(0.62992,0.41732),(0.6378,0.41732),(0.64567,0.41732),(0.65354,0.41732),(0.66142,0.41732),(0.66929,0.41732),(0.67717,0.41732),(0.68504,0.41732),(0.69291,0.41732),(0.70079,0.41732),(0.70866,0.41732),(0.71654,0.41732),(0.72441,0.41732),(0.73228,0.41732),(0.74016,0.41732),(0.74803,0.41732),(0.75591,0.41732),(0.76378,0.41732),(0.77165,0.41732),(0.77953,0.41732),(0.7874,0.41732),(0.79528,0.41732),(0.80315,0.41732),(0.81102,0.41732),(0.8189,0.41732),(0.82677,0.41732),(0.83465,0.41732),(0.84252,0.41732),(0.85039,0.41732),(0.85827,0.41732),(0.86614,0.41732),(0.87402,0.41732),(0.88189,0.41732),(0.88976,0.41732),(0.89764,0.41732),(0.90551,0.41732),(0.91339,0.41732),(0.92126,0.41732),(0.92913,0.41732),(0.93701,0.41732),(0.94488,0.41732),(0.95276,0.41732),(0.96063,0.41732),(0.9685,0.41732),(0.97638,0.41732),(0.98425,0.41732),(0.99213,0.41732),(0.99609,0.41732),(0.00391,0.4252),(0.00787,0.4252),(0.01575,0.4252),(0.02362,0.4252),(0.0315,0.4252),(0.03937,0.4252),(0.04724,0.4252),(0.05512,0.4252),(0.06299,0.4252),(0.07087,0.4252),(0.07874,0.4252),(0.08661,0.4252),(0.09449,0.4252),(0.10236,0.4252),(0.11024,0.4252),(0.11811,0.4252),(0.12598,0.4252),(0.13386,0.4252),(0.14173,0.4252),(0.14961,0.4252),(0.15748,0.4252),(0.16535,0.4252),(0.17323,0.4252),(0.1811,0.4252),(0.18898,0.4252),(0.19685,0.4252),(0.20472,0.4252),(0.2126,0.4252),(0.22047,0.4252),(0.22835,0.4252),(0.23622,0.4252),(0.24409,0.4252),(0.25197,0.4252),(0.25984,0.4252),(0.26772,0.4252),(0.27559,0.4252),(0.28346,0.4252),(0.29134,0.4252),(0.29921,0.4252),(0.30709,0.4252),(0.31496,0.4252),(0.32283,0.4252),(0.33071,0.4252),(0.33858,0.4252),(0.34646,0.4252),(0.35433,0.4252),(0.3622,0.4252),(0.37008,0.4252),(0.37795,0.4252),(0.38583,0.4252),(0.3937,0.4252),(0.40157,0.4252),(0.40945,0.4252),(0.41732,0.4252),(0.4252,0.4252),(0.43307,0.4252),(0.44094,0.4252),(0.44882,0.4252),(0.45669,0.4252),(0.46457,0.4252),(0.47244,0.4252),(0.48031,0.4252),(0.48819,0.4252),(0.49606,0.4252),(0.50394,0.4252),(0.51181,0.4252),(0.51969,0.4252),(0.52756,0.4252),(0.53543,0.4252),(0.54331,0.4252),(0.55118,0.4252),(0.55906,0.4252),(0.56693,0.4252),(0.5748,0.4252),(0.58268,0.4252),(0.59055,0.4252),(0.59843,0.4252),(0.6063,0.4252),(0.61417,0.4252),(0.62205,0.4252),(0.62992,0.4252),(0.6378,0.4252),(0.64567,0.4252),(0.65354,0.4252),(0.66142,0.4252),(0.66929,0.4252),(0.67717,0.4252),(0.68504,0.4252),(0.69291,0.4252),(0.70079,0.4252),(0.70866,0.4252),(0.71654,0.4252),(0.72441,0.4252),(0.73228,0.4252),(0.74016,0.4252),(0.74803,0.4252),(0.75591,0.4252),(0.76378,0.4252),(0.77165,0.4252),(0.77953,0.4252),(0.7874,0.4252),(0.79528,0.4252),(0.80315,0.4252),(0.81102,0.4252),(0.8189,0.4252),(0.82677,0.4252),(0.83465,0.4252),(0.84252,0.4252),(0.85039,0.4252),(0.85827,0.4252),(0.86614,0.4252),(0.87402,0.4252),(0.88189,0.4252),(0.88976,0.4252),(0.89764,0.4252),(0.90551,0.4252),(0.91339,0.4252),(0.92126,0.4252),(0.92913,0.4252),(0.93701,0.4252),(0.94488,0.4252),(0.95276,0.4252),(0.96063,0.4252),(0.9685,0.4252),(0.97638,0.4252),(0.98425,0.4252),(0.99213,0.4252),(0.99609,0.4252),(0.00391,0.43307),(0.00787,0.43307),(0.01575,0.43307),(0.02362,0.43307),(0.0315,0.43307),(0.03937,0.43307),(0.04724,0.43307),(0.05512,0.43307),(0.06299,0.43307),(0.07087,0.43307),(0.07874,0.43307),(0.08661,0.43307),(0.09449,0.43307),(0.10236,0.43307),(0.11024,0.43307),(0.11811,0.43307),(0.12598,0.43307),(0.13386,0.43307),(0.14173,0.43307),(0.14961,0.43307),(0.15748,0.43307),(0.16535,0.43307),(0.17323,0.43307),(0.1811,0.43307),(0.18898,0.43307),(0.19685,0.43307),(0.20472,0.43307),(0.2126,0.43307),(0.22047,0.43307),(0.22835,0.43307),(0.23622,0.43307),(0.24409,0.43307),(0.25197,0.43307),(0.25984,0.43307),(0.26772,0.43307),(0.27559,0.43307),(0.28346,0.43307),(0.29134,0.43307),(0.29921,0.43307),(0.30709,0.43307),(0.31496,0.43307),(0.32283,0.43307),(0.33071,0.43307),(0.33858,0.43307),(0.34646,0.43307),(0.35433,0.43307),(0.3622,0.43307),(0.37008,0.43307),(0.37795,0.43307),(0.38583,0.43307),(0.3937,0.43307),(0.40157,0.43307),(0.40945,0.43307),(0.41732,0.43307),(0.4252,0.43307),(0.43307,0.43307),(0.44094,0.43307),(0.44882,0.43307),(0.45669,0.43307),(0.46457,0.43307),(0.47244,0.43307),(0.48031,0.43307),(0.48819,0.43307),(0.49606,0.43307),(0.50394,0.43307),(0.51181,0.43307),(0.51969,0.43307),(0.52756,0.43307),(0.53543,0.43307),(0.54331,0.43307),(0.55118,0.43307),(0.55906,0.43307),(0.56693,0.43307),(0.5748,0.43307),(0.58268,0.43307),(0.59055,0.43307),(0.59843,0.43307),(0.6063,0.43307),(0.61417,0.43307),(0.62205,0.43307),(0.62992,0.43307),(0.6378,0.43307),(0.64567,0.43307),(0.65354,0.43307),(0.66142,0.43307),(0.66929,0.43307),(0.67717,0.43307),(0.68504,0.43307),(0.69291,0.43307),(0.70079,0.43307),(0.70866,0.43307),(0.71654,0.43307),(0.72441,0.43307),(0.73228,0.43307),(0.74016,0.43307),(0.74803,0.43307),(0.75591,0.43307),(0.76378,0.43307),(0.77165,0.43307),(0.77953,0.43307),(0.7874,0.43307),(0.79528,0.43307),(0.80315,0.43307),(0.81102,0.43307),(0.8189,0.43307),(0.82677,0.43307),(0.83465,0.43307),(0.84252,0.43307),(0.85039,0.43307),(0.85827,0.43307),(0.86614,0.43307),(0.87402,0.43307),(0.88189,0.43307),(0.88976,0.43307),(0.89764,0.43307),(0.90551,0.43307),(0.91339,0.43307),(0.92126,0.43307),(0.92913,0.43307),(0.93701,0.43307),(0.94488,0.43307),(0.95276,0.43307),(0.96063,0.43307),(0.9685,0.43307),(0.97638,0.43307),(0.98425,0.43307),(0.99213,0.43307),(0.99609,0.43307),(0.00391,0.44094),(0.00787,0.44094),(0.01575,0.44094),(0.02362,0.44094),(0.0315,0.44094),(0.03937,0.44094),(0.04724,0.44094),(0.05512,0.44094),(0.06299,0.44094),(0.07087,0.44094),(0.07874,0.44094),(0.08661,0.44094),(0.09449,0.44094),(0.10236,0.44094),(0.11024,0.44094),(0.11811,0.44094),(0.12598,0.44094),(0.13386,0.44094),(0.14173,0.44094),(0.14961,0.44094),(0.15748,0.44094),(0.16535,0.44094),(0.17323,0.44094),(0.1811,0.44094),(0.18898,0.44094),(0.19685,0.44094),(0.20472,0.44094),(0.2126,0.44094),(0.22047,0.44094),(0.22835,0.44094),(0.23622,0.44094),(0.24409,0.44094),(0.25197,0.44094),(0.25984,0.44094),(0.26772,0.44094),(0.27559,0.44094),(0.28346,0.44094),(0.29134,0.44094),(0.29921,0.44094),(0.30709,0.44094),(0.31496,0.44094),(0.32283,0.44094),(0.33071,0.44094),(0.33858,0.44094),(0.34646,0.44094),(0.35433,0.44094),(0.3622,0.44094),(0.37008,0.44094),(0.37795,0.44094),(0.38583,0.44094),(0.3937,0.44094),(0.40157,0.44094),(0.40945,0.44094),(0.41732,0.44094),(0.4252,0.44094),(0.43307,0.44094),(0.44094,0.44094),(0.44882,0.44094),(0.45669,0.44094),(0.46457,0.44094),(0.47244,0.44094),(0.48031,0.44094),(0.48819,0.44094),(0.49606,0.44094),(0.50394,0.44094),(0.51181,0.44094),(0.51969,0.44094),(0.52756,0.44094),(0.53543,0.44094),(0.54331,0.44094),(0.55118,0.44094),(0.55906,0.44094),(0.56693,0.44094),(0.5748,0.44094),(0.58268,0.44094),(0.59055,0.44094),(0.59843,0.44094),(0.6063,0.44094),(0.61417,0.44094),(0.62205,0.44094),(0.62992,0.44094),(0.6378,0.44094),(0.64567,0.44094),(0.65354,0.44094),(0.66142,0.44094),(0.66929,0.44094),(0.67717,0.44094),(0.68504,0.44094),(0.69291,0.44094),(0.70079,0.44094),(0.70866,0.44094),(0.71654,0.44094),(0.72441,0.44094),(0.73228,0.44094),(0.74016,0.44094),(0.74803,0.44094),(0.75591,0.44094),(0.76378,0.44094),(0.77165,0.44094),(0.77953,0.44094),(0.7874,0.44094),(0.79528,0.44094),(0.80315,0.44094),(0.81102,0.44094),(0.8189,0.44094),(0.82677,0.44094),(0.83465,0.44094),(0.84252,0.44094),(0.85039,0.44094),(0.85827,0.44094),(0.86614,0.44094),(0.87402,0.44094),(0.88189,0.44094),(0.88976,0.44094),(0.89764,0.44094),(0.90551,0.44094),(0.91339,0.44094),(0.92126,0.44094),(0.92913,0.44094),(0.93701,0.44094),(0.94488,0.44094),(0.95276,0.44094),(0.96063,0.44094),(0.9685,0.44094),(0.97638,0.44094),(0.98425,0.44094),(0.99213,0.44094),(0.99609,0.44094),(0.00391,0.44882),(0.00787,0.44882),(0.01575,0.44882),(0.02362,0.44882),(0.0315,0.44882),(0.03937,0.44882),(0.04724,0.44882),(0.05512,0.44882),(0.06299,0.44882),(0.07087,0.44882),(0.07874,0.44882),(0.08661,0.44882),(0.09449,0.44882),(0.10236,0.44882),(0.11024,0.44882),(0.11811,0.44882),(0.12598,0.44882),(0.13386,0.44882),(0.14173,0.44882),(0.14961,0.44882),(0.15748,0.44882),(0.16535,0.44882),(0.17323,0.44882),(0.1811,0.44882),(0.18898,0.44882),(0.19685,0.44882),(0.20472,0.44882),(0.2126,0.44882),(0.22047,0.44882),(0.22835,0.44882),(0.23622,0.44882),(0.24409,0.44882),(0.25197,0.44882),(0.25984,0.44882),(0.26772,0.44882),(0.27559,0.44882),(0.28346,0.44882),(0.29134,0.44882),(0.29921,0.44882),(0.30709,0.44882),(0.31496,0.44882),(0.32283,0.44882),(0.33071,0.44882),(0.33858,0.44882),(0.34646,0.44882),(0.35433,0.44882),(0.3622,0.44882),(0.37008,0.44882),(0.37795,0.44882),(0.38583,0.44882),(0.3937,0.44882),(0.40157,0.44882),(0.40945,0.44882),(0.41732,0.44882),(0.4252,0.44882),(0.43307,0.44882),(0.44094,0.44882),(0.44882,0.44882),(0.45669,0.44882),(0.46457,0.44882),(0.47244,0.44882),(0.48031,0.44882),(0.48819,0.44882),(0.49606,0.44882),(0.50394,0.44882),(0.51181,0.44882),(0.51969,0.44882),(0.52756,0.44882),(0.53543,0.44882),(0.54331,0.44882),(0.55118,0.44882),(0.55906,0.44882),(0.56693,0.44882),(0.5748,0.44882),(0.58268,0.44882),(0.59055,0.44882),(0.59843,0.44882),(0.6063,0.44882),(0.61417,0.44882),(0.62205,0.44882),(0.62992,0.44882),(0.6378,0.44882),(0.64567,0.44882),(0.65354,0.44882),(0.66142,0.44882),(0.66929,0.44882),(0.67717,0.44882),(0.68504,0.44882),(0.69291,0.44882),(0.70079,0.44882),(0.70866,0.44882),(0.71654,0.44882),(0.72441,0.44882),(0.73228,0.44882),(0.74016,0.44882),(0.74803,0.44882),(0.75591,0.44882),(0.76378,0.44882),(0.77165,0.44882),(0.77953,0.44882),(0.7874,0.44882),(0.79528,0.44882),(0.80315,0.44882),(0.81102,0.44882),(0.8189,0.44882),(0.82677,0.44882),(0.83465,0.44882),(0.84252,0.44882),(0.85039,0.44882),(0.85827,0.44882),(0.86614,0.44882),(0.87402,0.44882),(0.88189,0.44882),(0.88976,0.44882),(0.89764,0.44882),(0.90551,0.44882),(0.91339,0.44882),(0.92126,0.44882),(0.92913,0.44882),(0.93701,0.44882),(0.94488,0.44882),(0.95276,0.44882),(0.96063,0.44882),(0.9685,0.44882),(0.97638,0.44882),(0.98425,0.44882),(0.99213,0.44882),(0.99609,0.44882),(0.00391,0.45669),(0.00787,0.45669),(0.01575,0.45669),(0.02362,0.45669),(0.0315,0.45669),(0.03937,0.45669),(0.04724,0.45669),(0.05512,0.45669),(0.06299,0.45669),(0.07087,0.45669),(0.07874,0.45669),(0.08661,0.45669),(0.09449,0.45669),(0.10236,0.45669),(0.11024,0.45669),(0.11811,0.45669),(0.12598,0.45669),(0.13386,0.45669),(0.14173,0.45669),(0.14961,0.45669),(0.15748,0.45669),(0.16535,0.45669),(0.17323,0.45669),(0.1811,0.45669),(0.18898,0.45669),(0.19685,0.45669),(0.20472,0.45669),(0.2126,0.45669),(0.22047,0.45669),(0.22835,0.45669),(0.23622,0.45669),(0.24409,0.45669),(0.25197,0.45669),(0.25984,0.45669),(0.26772,0.45669),(0.27559,0.45669),(0.28346,0.45669),(0.29134,0.45669),(0.29921,0.45669),(0.30709,0.45669),(0.31496,0.45669),(0.32283,0.45669),(0.33071,0.45669),(0.33858,0.45669),(0.34646,0.45669),(0.35433,0.45669),(0.3622,0.45669),(0.37008,0.45669),(0.37795,0.45669),(0.38583,0.45669),(0.3937,0.45669),(0.40157,0.45669),(0.40945,0.45669),(0.41732,0.45669),(0.4252,0.45669),(0.43307,0.45669),(0.44094,0.45669),(0.44882,0.45669),(0.45669,0.45669),(0.46457,0.45669),(0.47244,0.45669),(0.48031,0.45669),(0.48819,0.45669),(0.49606,0.45669),(0.50394,0.45669),(0.51181,0.45669),(0.51969,0.45669),(0.52756,0.45669),(0.53543,0.45669),(0.54331,0.45669),(0.55118,0.45669),(0.55906,0.45669),(0.56693,0.45669),(0.5748,0.45669),(0.58268,0.45669),(0.59055,0.45669),(0.59843,0.45669),(0.6063,0.45669),(0.61417,0.45669),(0.62205,0.45669),(0.62992,0.45669),(0.6378,0.45669),(0.64567,0.45669),(0.65354,0.45669),(0.66142,0.45669),(0.66929,0.45669),(0.67717,0.45669),(0.68504,0.45669),(0.69291,0.45669),(0.70079,0.45669),(0.70866,0.45669),(0.71654,0.45669),(0.72441,0.45669),(0.73228,0.45669),(0.74016,0.45669),(0.74803,0.45669),(0.75591,0.45669),(0.76378,0.45669),(0.77165,0.45669),(0.77953,0.45669),(0.7874,0.45669),(0.79528,0.45669),(0.80315,0.45669),(0.81102,0.45669),(0.8189,0.45669),(0.82677,0.45669),(0.83465,0.45669),(0.84252,0.45669),(0.85039,0.45669),(0.85827,0.45669),(0.86614,0.45669),(0.87402,0.45669),(0.88189,0.45669),(0.88976,0.45669),(0.89764,0.45669),(0.90551,0.45669),(0.91339,0.45669),(0.92126,0.45669),(0.92913,0.45669),(0.93701,0.45669),(0.94488,0.45669),(0.95276,0.45669),(0.96063,0.45669),(0.9685,0.45669),(0.97638,0.45669),(0.98425,0.45669),(0.99213,0.45669),(0.99609,0.45669),(0.00391,0.46457),(0.00787,0.46457),(0.01575,0.46457),(0.02362,0.46457),(0.0315,0.46457),(0.03937,0.46457),(0.04724,0.46457),(0.05512,0.46457),(0.06299,0.46457),(0.07087,0.46457),(0.07874,0.46457),(0.08661,0.46457),(0.09449,0.46457),(0.10236,0.46457),(0.11024,0.46457),(0.11811,0.46457),(0.12598,0.46457),(0.13386,0.46457),(0.14173,0.46457),(0.14961,0.46457),(0.15748,0.46457),(0.16535,0.46457),(0.17323,0.46457),(0.1811,0.46457),(0.18898,0.46457),(0.19685,0.46457),(0.20472,0.46457),(0.2126,0.46457),(0.22047,0.46457),(0.22835,0.46457),(0.23622,0.46457),(0.24409,0.46457),(0.25197,0.46457),(0.25984,0.46457),(0.26772,0.46457),(0.27559,0.46457),(0.28346,0.46457),(0.29134,0.46457),(0.29921,0.46457),(0.30709,0.46457),(0.31496,0.46457),(0.32283,0.46457),(0.33071,0.46457),(0.33858,0.46457),(0.34646,0.46457),(0.35433,0.46457),(0.3622,0.46457),(0.37008,0.46457),(0.37795,0.46457),(0.38583,0.46457),(0.3937,0.46457),(0.40157,0.46457),(0.40945,0.46457),(0.41732,0.46457),(0.4252,0.46457),(0.43307,0.46457),(0.44094,0.46457),(0.44882,0.46457),(0.45669,0.46457),(0.46457,0.46457),(0.47244,0.46457),(0.48031,0.46457),(0.48819,0.46457),(0.49606,0.46457),(0.50394,0.46457),(0.51181,0.46457),(0.51969,0.46457),(0.52756,0.46457),(0.53543,0.46457),(0.54331,0.46457),(0.55118,0.46457),(0.55906,0.46457),(0.56693,0.46457),(0.5748,0.46457),(0.58268,0.46457),(0.59055,0.46457),(0.59843,0.46457),(0.6063,0.46457),(0.61417,0.46457),(0.62205,0.46457),(0.62992,0.46457),(0.6378,0.46457),(0.64567,0.46457),(0.65354,0.46457),(0.66142,0.46457),(0.66929,0.46457),(0.67717,0.46457),(0.68504,0.46457),(0.69291,0.46457),(0.70079,0.46457),(0.70866,0.46457),(0.71654,0.46457),(0.72441,0.46457),(0.73228,0.46457),(0.74016,0.46457),(0.74803,0.46457),(0.75591,0.46457),(0.76378,0.46457),(0.77165,0.46457),(0.77953,0.46457),(0.7874,0.46457),(0.79528,0.46457),(0.80315,0.46457),(0.81102,0.46457),(0.8189,0.46457),(0.82677,0.46457),(0.83465,0.46457),(0.84252,0.46457),(0.85039,0.46457),(0.85827,0.46457),(0.86614,0.46457),(0.87402,0.46457),(0.88189,0.46457),(0.88976,0.46457),(0.89764,0.46457),(0.90551,0.46457),(0.91339,0.46457),(0.92126,0.46457),(0.92913,0.46457),(0.93701,0.46457),(0.94488,0.46457),(0.95276,0.46457),(0.96063,0.46457),(0.9685,0.46457),(0.97638,0.46457),(0.98425,0.46457),(0.99213,0.46457),(0.99609,0.46457),(0.00391,0.47244),(0.00787,0.47244),(0.01575,0.47244),(0.02362,0.47244),(0.0315,0.47244),(0.03937,0.47244),(0.04724,0.47244),(0.05512,0.47244),(0.06299,0.47244),(0.07087,0.47244),(0.07874,0.47244),(0.08661,0.47244),(0.09449,0.47244),(0.10236,0.47244),(0.11024,0.47244),(0.11811,0.47244),(0.12598,0.47244),(0.13386,0.47244),(0.14173,0.47244),(0.14961,0.47244),(0.15748,0.47244),(0.16535,0.47244),(0.17323,0.47244),(0.1811,0.47244),(0.18898,0.47244),(0.19685,0.47244),(0.20472,0.47244),(0.2126,0.47244),(0.22047,0.47244),(0.22835,0.47244),(0.23622,0.47244),(0.24409,0.47244),(0.25197,0.47244),(0.25984,0.47244),(0.26772,0.47244),(0.27559,0.47244),(0.28346,0.47244),(0.29134,0.47244),(0.29921,0.47244),(0.30709,0.47244),(0.31496,0.47244),(0.32283,0.47244),(0.33071,0.47244),(0.33858,0.47244),(0.34646,0.47244),(0.35433,0.47244),(0.3622,0.47244),(0.37008,0.47244),(0.37795,0.47244),(0.38583,0.47244),(0.3937,0.47244),(0.40157,0.47244),(0.40945,0.47244),(0.41732,0.47244),(0.4252,0.47244),(0.43307,0.47244),(0.44094,0.47244),(0.44882,0.47244),(0.45669,0.47244),(0.46457,0.47244),(0.47244,0.47244),(0.48031,0.47244),(0.48819,0.47244),(0.49606,0.47244),(0.50394,0.47244),(0.51181,0.47244),(0.51969,0.47244),(0.52756,0.47244),(0.53543,0.47244),(0.54331,0.47244),(0.55118,0.47244),(0.55906,0.47244),(0.56693,0.47244),(0.5748,0.47244),(0.58268,0.47244),(0.59055,0.47244),(0.59843,0.47244),(0.6063,0.47244),(0.61417,0.47244),(0.62205,0.47244),(0.62992,0.47244),(0.6378,0.47244),(0.64567,0.47244),(0.65354,0.47244),(0.66142,0.47244),(0.66929,0.47244),(0.67717,0.47244),(0.68504,0.47244),(0.69291,0.47244),(0.70079,0.47244),(0.70866,0.47244),(0.71654,0.47244),(0.72441,0.47244),(0.73228,0.47244),(0.74016,0.47244),(0.74803,0.47244),(0.75591,0.47244),(0.76378,0.47244),(0.77165,0.47244),(0.77953,0.47244),(0.7874,0.47244),(0.79528,0.47244),(0.80315,0.47244),(0.81102,0.47244),(0.8189,0.47244),(0.82677,0.47244),(0.83465,0.47244),(0.84252,0.47244),(0.85039,0.47244),(0.85827,0.47244),(0.86614,0.47244),(0.87402,0.47244),(0.88189,0.47244),(0.88976,0.47244),(0.89764,0.47244),(0.90551,0.47244),(0.91339,0.47244),(0.92126,0.47244),(0.92913,0.47244),(0.93701,0.47244),(0.94488,0.47244),(0.95276,0.47244),(0.96063,0.47244),(0.9685,0.47244),(0.97638,0.47244),(0.98425,0.47244),(0.99213,0.47244),(0.99609,0.47244),(0.00391,0.48031),(0.00787,0.48031),(0.01575,0.48031),(0.02362,0.48031),(0.0315,0.48031),(0.03937,0.48031),(0.04724,0.48031),(0.05512,0.48031),(0.06299,0.48031),(0.07087,0.48031),(0.07874,0.48031),(0.08661,0.48031),(0.09449,0.48031),(0.10236,0.48031),(0.11024,0.48031),(0.11811,0.48031),(0.12598,0.48031),(0.13386,0.48031),(0.14173,0.48031),(0.14961,0.48031),(0.15748,0.48031),(0.16535,0.48031),(0.17323,0.48031),(0.1811,0.48031),(0.18898,0.48031),(0.19685,0.48031),(0.20472,0.48031),(0.2126,0.48031),(0.22047,0.48031),(0.22835,0.48031),(0.23622,0.48031),(0.24409,0.48031),(0.25197,0.48031),(0.25984,0.48031),(0.26772,0.48031),(0.27559,0.48031),(0.28346,0.48031),(0.29134,0.48031),(0.29921,0.48031),(0.30709,0.48031),(0.31496,0.48031),(0.32283,0.48031),(0.33071,0.48031),(0.33858,0.48031),(0.34646,0.48031),(0.35433,0.48031),(0.3622,0.48031),(0.37008,0.48031),(0.37795,0.48031),(0.38583,0.48031),(0.3937,0.48031),(0.40157,0.48031),(0.40945,0.48031),(0.41732,0.48031),(0.4252,0.48031),(0.43307,0.48031),(0.44094,0.48031),(0.44882,0.48031),(0.45669,0.48031),(0.46457,0.48031),(0.47244,0.48031),(0.48031,0.48031),(0.48819,0.48031),(0.49606,0.48031),(0.50394,0.48031),(0.51181,0.48031),(0.51969,0.48031),(0.52756,0.48031),(0.53543,0.48031),(0.54331,0.48031),(0.55118,0.48031),(0.55906,0.48031),(0.56693,0.48031),(0.5748,0.48031),(0.58268,0.48031),(0.59055,0.48031),(0.59843,0.48031),(0.6063,0.48031),(0.61417,0.48031),(0.62205,0.48031),(0.62992,0.48031),(0.6378,0.48031),(0.64567,0.48031),(0.65354,0.48031),(0.66142,0.48031),(0.66929,0.48031),(0.67717,0.48031),(0.68504,0.48031),(0.69291,0.48031),(0.70079,0.48031),(0.70866,0.48031),(0.71654,0.48031),(0.72441,0.48031),(0.73228,0.48031),(0.74016,0.48031),(0.74803,0.48031),(0.75591,0.48031),(0.76378,0.48031),(0.77165,0.48031),(0.77953,0.48031),(0.7874,0.48031),(0.79528,0.48031),(0.80315,0.48031),(0.81102,0.48031),(0.8189,0.48031),(0.82677,0.48031),(0.83465,0.48031),(0.84252,0.48031),(0.85039,0.48031),(0.85827,0.48031),(0.86614,0.48031),(0.87402,0.48031),(0.88189,0.48031),(0.88976,0.48031),(0.89764,0.48031),(0.90551,0.48031),(0.91339,0.48031),(0.92126,0.48031),(0.92913,0.48031),(0.93701,0.48031),(0.94488,0.48031),(0.95276,0.48031),(0.96063,0.48031),(0.9685,0.48031),(0.97638,0.48031),(0.98425,0.48031),(0.99213,0.48031),(0.99609,0.48031),(0.00391,0.48819),(0.00787,0.48819),(0.01575,0.48819),(0.02362,0.48819),(0.0315,0.48819),(0.03937,0.48819),(0.04724,0.48819),(0.05512,0.48819),(0.06299,0.48819),(0.07087,0.48819),(0.07874,0.48819),(0.08661,0.48819),(0.09449,0.48819),(0.10236,0.48819),(0.11024,0.48819),(0.11811,0.48819),(0.12598,0.48819),(0.13386,0.48819),(0.14173,0.48819),(0.14961,0.48819),(0.15748,0.48819),(0.16535,0.48819),(0.17323,0.48819),(0.1811,0.48819),(0.18898,0.48819),(0.19685,0.48819),(0.20472,0.48819),(0.2126,0.48819),(0.22047,0.48819),(0.22835,0.48819),(0.23622,0.48819),(0.24409,0.48819),(0.25197,0.48819),(0.25984,0.48819),(0.26772,0.48819),(0.27559,0.48819),(0.28346,0.48819),(0.29134,0.48819),(0.29921,0.48819),(0.30709,0.48819),(0.31496,0.48819),(0.32283,0.48819),(0.33071,0.48819),(0.33858,0.48819),(0.34646,0.48819),(0.35433,0.48819),(0.3622,0.48819),(0.37008,0.48819),(0.37795,0.48819),(0.38583,0.48819),(0.3937,0.48819),(0.40157,0.48819),(0.40945,0.48819),(0.41732,0.48819),(0.4252,0.48819),(0.43307,0.48819),(0.44094,0.48819),(0.44882,0.48819),(0.45669,0.48819),(0.46457,0.48819),(0.47244,0.48819),(0.48031,0.48819),(0.48819,0.48819),(0.49606,0.48819),(0.50394,0.48819),(0.51181,0.48819),(0.51969,0.48819),(0.52756,0.48819),(0.53543,0.48819),(0.54331,0.48819),(0.55118,0.48819),(0.55906,0.48819),(0.56693,0.48819),(0.5748,0.48819),(0.58268,0.48819),(0.59055,0.48819),(0.59843,0.48819),(0.6063,0.48819),(0.61417,0.48819),(0.62205,0.48819),(0.62992,0.48819),(0.6378,0.48819),(0.64567,0.48819),(0.65354,0.48819),(0.66142,0.48819),(0.66929,0.48819),(0.67717,0.48819),(0.68504,0.48819),(0.69291,0.48819),(0.70079,0.48819),(0.70866,0.48819),(0.71654,0.48819),(0.72441,0.48819),(0.73228,0.48819),(0.74016,0.48819),(0.74803,0.48819),(0.75591,0.48819),(0.76378,0.48819),(0.77165,0.48819),(0.77953,0.48819),(0.7874,0.48819),(0.79528,0.48819),(0.80315,0.48819),(0.81102,0.48819),(0.8189,0.48819),(0.82677,0.48819),(0.83465,0.48819),(0.84252,0.48819),(0.85039,0.48819),(0.85827,0.48819),(0.86614,0.48819),(0.87402,0.48819),(0.88189,0.48819),(0.88976,0.48819),(0.89764,0.48819),(0.90551,0.48819),(0.91339,0.48819),(0.92126,0.48819),(0.92913,0.48819),(0.93701,0.48819),(0.94488,0.48819),(0.95276,0.48819),(0.96063,0.48819),(0.9685,0.48819),(0.97638,0.48819),(0.98425,0.48819),(0.99213,0.48819),(0.99609,0.48819),(0.00391,0.49606),(0.00787,0.49606),(0.01575,0.49606),(0.02362,0.49606),(0.0315,0.49606),(0.03937,0.49606),(0.04724,0.49606),(0.05512,0.49606),(0.06299,0.49606),(0.07087,0.49606),(0.07874,0.49606),(0.08661,0.49606),(0.09449,0.49606),(0.10236,0.49606),(0.11024,0.49606),(0.11811,0.49606),(0.12598,0.49606),(0.13386,0.49606),(0.14173,0.49606),(0.14961,0.49606),(0.15748,0.49606),(0.16535,0.49606),(0.17323,0.49606),(0.1811,0.49606),(0.18898,0.49606),(0.19685,0.49606),(0.20472,0.49606),(0.2126,0.49606),(0.22047,0.49606),(0.22835,0.49606),(0.23622,0.49606),(0.24409,0.49606),(0.25197,0.49606),(0.25984,0.49606),(0.26772,0.49606),(0.27559,0.49606),(0.28346,0.49606),(0.29134,0.49606),(0.29921,0.49606),(0.30709,0.49606),(0.31496,0.49606),(0.32283,0.49606),(0.33071,0.49606),(0.33858,0.49606),(0.34646,0.49606),(0.35433,0.49606),(0.3622,0.49606),(0.37008,0.49606),(0.37795,0.49606),(0.38583,0.49606),(0.3937,0.49606),(0.40157,0.49606),(0.40945,0.49606),(0.41732,0.49606),(0.4252,0.49606),(0.43307,0.49606),(0.44094,0.49606),(0.44882,0.49606),(0.45669,0.49606),(0.46457,0.49606),(0.47244,0.49606),(0.48031,0.49606),(0.48819,0.49606),(0.49606,0.49606),(0.50394,0.49606),(0.51181,0.49606),(0.51969,0.49606),(0.52756,0.49606),(0.53543,0.49606),(0.54331,0.49606),(0.55118,0.49606),(0.55906,0.49606),(0.56693,0.49606),(0.5748,0.49606),(0.58268,0.49606),(0.59055,0.49606),(0.59843,0.49606),(0.6063,0.49606),(0.61417,0.49606),(0.62205,0.49606),(0.62992,0.49606),(0.6378,0.49606),(0.64567,0.49606),(0.65354,0.49606),(0.66142,0.49606),(0.66929,0.49606),(0.67717,0.49606),(0.68504,0.49606),(0.69291,0.49606),(0.70079,0.49606),(0.70866,0.49606),(0.71654,0.49606),(0.72441,0.49606),(0.73228,0.49606),(0.74016,0.49606),(0.74803,0.49606),(0.75591,0.49606),(0.76378,0.49606),(0.77165,0.49606),(0.77953,0.49606),(0.7874,0.49606),(0.79528,0.49606),(0.80315,0.49606),(0.81102,0.49606),(0.8189,0.49606),(0.82677,0.49606),(0.83465,0.49606),(0.84252,0.49606),(0.85039,0.49606),(0.85827,0.49606),(0.86614,0.49606),(0.87402,0.49606),(0.88189,0.49606),(0.88976,0.49606),(0.89764,0.49606),(0.90551,0.49606),(0.91339,0.49606),(0.92126,0.49606),(0.92913,0.49606),(0.93701,0.49606),(0.94488,0.49606),(0.95276,0.49606),(0.96063,0.49606),(0.9685,0.49606),(0.97638,0.49606),(0.98425,0.49606),(0.99213,0.49606),(0.99609,0.49606),(0.00391,0.50394),(0.00787,0.50394),(0.01575,0.50394),(0.02362,0.50394),(0.0315,0.50394),(0.03937,0.50394),(0.04724,0.50394),(0.05512,0.50394),(0.06299,0.50394),(0.07087,0.50394),(0.07874,0.50394),(0.08661,0.50394),(0.09449,0.50394),(0.10236,0.50394),(0.11024,0.50394),(0.11811,0.50394),(0.12598,0.50394),(0.13386,0.50394),(0.14173,0.50394),(0.14961,0.50394),(0.15748,0.50394),(0.16535,0.50394),(0.17323,0.50394),(0.1811,0.50394),(0.18898,0.50394),(0.19685,0.50394),(0.20472,0.50394),(0.2126,0.50394),(0.22047,0.50394),(0.22835,0.50394),(0.23622,0.50394),(0.24409,0.50394),(0.25197,0.50394),(0.25984,0.50394),(0.26772,0.50394),(0.27559,0.50394),(0.28346,0.50394),(0.29134,0.50394),(0.29921,0.50394),(0.30709,0.50394),(0.31496,0.50394),(0.32283,0.50394),(0.33071,0.50394),(0.33858,0.50394),(0.34646,0.50394),(0.35433,0.50394),(0.3622,0.50394),(0.37008,0.50394),(0.37795,0.50394),(0.38583,0.50394),(0.3937,0.50394),(0.40157,0.50394),(0.40945,0.50394),(0.41732,0.50394),(0.4252,0.50394),(0.43307,0.50394),(0.44094,0.50394),(0.44882,0.50394),(0.45669,0.50394),(0.46457,0.50394),(0.47244,0.50394),(0.48031,0.50394),(0.48819,0.50394),(0.49606,0.50394),(0.50394,0.50394),(0.51181,0.50394),(0.51969,0.50394),(0.52756,0.50394),(0.53543,0.50394),(0.54331,0.50394),(0.55118,0.50394),(0.55906,0.50394),(0.56693,0.50394),(0.5748,0.50394),(0.58268,0.50394),(0.59055,0.50394),(0.59843,0.50394),(0.6063,0.50394),(0.61417,0.50394),(0.62205,0.50394),(0.62992,0.50394),(0.6378,0.50394),(0.64567,0.50394),(0.65354,0.50394),(0.66142,0.50394),(0.66929,0.50394),(0.67717,0.50394),(0.68504,0.50394),(0.69291,0.50394),(0.70079,0.50394),(0.70866,0.50394),(0.71654,0.50394),(0.72441,0.50394),(0.73228,0.50394),(0.74016,0.50394),(0.74803,0.50394),(0.75591,0.50394),(0.76378,0.50394),(0.77165,0.50394),(0.77953,0.50394),(0.7874,0.50394),(0.79528,0.50394),(0.80315,0.50394),(0.81102,0.50394),(0.8189,0.50394),(0.82677,0.50394),(0.83465,0.50394),(0.84252,0.50394),(0.85039,0.50394),(0.85827,0.50394),(0.86614,0.50394),(0.87402,0.50394),(0.88189,0.50394),(0.88976,0.50394),(0.89764,0.50394),(0.90551,0.50394),(0.91339,0.50394),(0.92126,0.50394),(0.92913,0.50394),(0.93701,0.50394),(0.94488,0.50394),(0.95276,0.50394),(0.96063,0.50394),(0.9685,0.50394),(0.97638,0.50394),(0.98425,0.50394),(0.99213,0.50394),(0.99609,0.50394),(0.00391,0.51181),(0.00787,0.51181),(0.01575,0.51181),(0.02362,0.51181),(0.0315,0.51181),(0.03937,0.51181),(0.04724,0.51181),(0.05512,0.51181),(0.06299,0.51181),(0.07087,0.51181),(0.07874,0.51181),(0.08661,0.51181),(0.09449,0.51181),(0.10236,0.51181),(0.11024,0.51181),(0.11811,0.51181),(0.12598,0.51181),(0.13386,0.51181),(0.14173,0.51181),(0.14961,0.51181),(0.15748,0.51181),(0.16535,0.51181),(0.17323,0.51181),(0.1811,0.51181),(0.18898,0.51181),(0.19685,0.51181),(0.20472,0.51181),(0.2126,0.51181),(0.22047,0.51181),(0.22835,0.51181),(0.23622,0.51181),(0.24409,0.51181),(0.25197,0.51181),(0.25984,0.51181),(0.26772,0.51181),(0.27559,0.51181),(0.28346,0.51181),(0.29134,0.51181),(0.29921,0.51181),(0.30709,0.51181),(0.31496,0.51181),(0.32283,0.51181),(0.33071,0.51181),(0.33858,0.51181),(0.34646,0.51181),(0.35433,0.51181),(0.3622,0.51181),(0.37008,0.51181),(0.37795,0.51181),(0.38583,0.51181),(0.3937,0.51181),(0.40157,0.51181),(0.40945,0.51181),(0.41732,0.51181),(0.4252,0.51181),(0.43307,0.51181),(0.44094,0.51181),(0.44882,0.51181),(0.45669,0.51181),(0.46457,0.51181),(0.47244,0.51181),(0.48031,0.51181),(0.48819,0.51181),(0.49606,0.51181),(0.50394,0.51181),(0.51181,0.51181),(0.51969,0.51181),(0.52756,0.51181),(0.53543,0.51181),(0.54331,0.51181),(0.55118,0.51181),(0.55906,0.51181),(0.56693,0.51181),(0.5748,0.51181),(0.58268,0.51181),(0.59055,0.51181),(0.59843,0.51181),(0.6063,0.51181),(0.61417,0.51181),(0.62205,0.51181),(0.62992,0.51181),(0.6378,0.51181),(0.64567,0.51181),(0.65354,0.51181),(0.66142,0.51181),(0.66929,0.51181),(0.67717,0.51181),(0.68504,0.51181),(0.69291,0.51181),(0.70079,0.51181),(0.70866,0.51181),(0.71654,0.51181),(0.72441,0.51181),(0.73228,0.51181),(0.74016,0.51181),(0.74803,0.51181),(0.75591,0.51181),(0.76378,0.51181),(0.77165,0.51181),(0.77953,0.51181),(0.7874,0.51181),(0.79528,0.51181),(0.80315,0.51181),(0.81102,0.51181),(0.8189,0.51181),(0.82677,0.51181),(0.83465,0.51181),(0.84252,0.51181),(0.85039,0.51181),(0.85827,0.51181),(0.86614,0.51181),(0.87402,0.51181),(0.88189,0.51181),(0.88976,0.51181),(0.89764,0.51181),(0.90551,0.51181),(0.91339,0.51181),(0.92126,0.51181),(0.92913,0.51181),(0.93701,0.51181),(0.94488,0.51181),(0.95276,0.51181),(0.96063,0.51181),(0.9685,0.51181),(0.97638,0.51181),(0.98425,0.51181),(0.99213,0.51181),(0.99609,0.51181),(0.00391,0.51969),(0.00787,0.51969),(0.01575,0.51969),(0.02362,0.51969),(0.0315,0.51969),(0.03937,0.51969),(0.04724,0.51969),(0.05512,0.51969),(0.06299,0.51969),(0.07087,0.51969),(0.07874,0.51969),(0.08661,0.51969),(0.09449,0.51969),(0.10236,0.51969),(0.11024,0.51969),(0.11811,0.51969),(0.12598,0.51969),(0.13386,0.51969),(0.14173,0.51969),(0.14961,0.51969),(0.15748,0.51969),(0.16535,0.51969),(0.17323,0.51969),(0.1811,0.51969),(0.18898,0.51969),(0.19685,0.51969),(0.20472,0.51969),(0.2126,0.51969),(0.22047,0.51969),(0.22835,0.51969),(0.23622,0.51969),(0.24409,0.51969),(0.25197,0.51969),(0.25984,0.51969),(0.26772,0.51969),(0.27559,0.51969),(0.28346,0.51969),(0.29134,0.51969),(0.29921,0.51969),(0.30709,0.51969),(0.31496,0.51969),(0.32283,0.51969),(0.33071,0.51969),(0.33858,0.51969),(0.34646,0.51969),(0.35433,0.51969),(0.3622,0.51969),(0.37008,0.51969),(0.37795,0.51969),(0.38583,0.51969),(0.3937,0.51969),(0.40157,0.51969),(0.40945,0.51969),(0.41732,0.51969),(0.4252,0.51969),(0.43307,0.51969),(0.44094,0.51969),(0.44882,0.51969),(0.45669,0.51969),(0.46457,0.51969),(0.47244,0.51969),(0.48031,0.51969),(0.48819,0.51969),(0.49606,0.51969),(0.50394,0.51969),(0.51181,0.51969),(0.51969,0.51969),(0.52756,0.51969),(0.53543,0.51969),(0.54331,0.51969),(0.55118,0.51969),(0.55906,0.51969),(0.56693,0.51969),(0.5748,0.51969),(0.58268,0.51969),(0.59055,0.51969),(0.59843,0.51969),(0.6063,0.51969),(0.61417,0.51969),(0.62205,0.51969),(0.62992,0.51969),(0.6378,0.51969),(0.64567,0.51969),(0.65354,0.51969),(0.66142,0.51969),(0.66929,0.51969),(0.67717,0.51969),(0.68504,0.51969),(0.69291,0.51969),(0.70079,0.51969),(0.70866,0.51969),(0.71654,0.51969),(0.72441,0.51969),(0.73228,0.51969),(0.74016,0.51969),(0.74803,0.51969),(0.75591,0.51969),(0.76378,0.51969),(0.77165,0.51969),(0.77953,0.51969),(0.7874,0.51969),(0.79528,0.51969),(0.80315,0.51969),(0.81102,0.51969),(0.8189,0.51969),(0.82677,0.51969),(0.83465,0.51969),(0.84252,0.51969),(0.85039,0.51969),(0.85827,0.51969),(0.86614,0.51969),(0.87402,0.51969),(0.88189,0.51969),(0.88976,0.51969),(0.89764,0.51969),(0.90551,0.51969),(0.91339,0.51969),(0.92126,0.51969),(0.92913,0.51969),(0.93701,0.51969),(0.94488,0.51969),(0.95276,0.51969),(0.96063,0.51969),(0.9685,0.51969),(0.97638,0.51969),(0.98425,0.51969),(0.99213,0.51969),(0.99609,0.51969),(0.00391,0.52756),(0.00787,0.52756),(0.01575,0.52756),(0.02362,0.52756),(0.0315,0.52756),(0.03937,0.52756),(0.04724,0.52756),(0.05512,0.52756),(0.06299,0.52756),(0.07087,0.52756),(0.07874,0.52756),(0.08661,0.52756),(0.09449,0.52756),(0.10236,0.52756),(0.11024,0.52756),(0.11811,0.52756),(0.12598,0.52756),(0.13386,0.52756),(0.14173,0.52756),(0.14961,0.52756),(0.15748,0.52756),(0.16535,0.52756),(0.17323,0.52756),(0.1811,0.52756),(0.18898,0.52756),(0.19685,0.52756),(0.20472,0.52756),(0.2126,0.52756),(0.22047,0.52756),(0.22835,0.52756),(0.23622,0.52756),(0.24409,0.52756),(0.25197,0.52756),(0.25984,0.52756),(0.26772,0.52756),(0.27559,0.52756),(0.28346,0.52756),(0.29134,0.52756),(0.29921,0.52756),(0.30709,0.52756),(0.31496,0.52756),(0.32283,0.52756),(0.33071,0.52756),(0.33858,0.52756),(0.34646,0.52756),(0.35433,0.52756),(0.3622,0.52756),(0.37008,0.52756),(0.37795,0.52756),(0.38583,0.52756),(0.3937,0.52756),(0.40157,0.52756),(0.40945,0.52756),(0.41732,0.52756),(0.4252,0.52756),(0.43307,0.52756),(0.44094,0.52756),(0.44882,0.52756),(0.45669,0.52756),(0.46457,0.52756),(0.47244,0.52756),(0.48031,0.52756),(0.48819,0.52756),(0.49606,0.52756),(0.50394,0.52756),(0.51181,0.52756),(0.51969,0.52756),(0.52756,0.52756),(0.53543,0.52756),(0.54331,0.52756),(0.55118,0.52756),(0.55906,0.52756),(0.56693,0.52756),(0.5748,0.52756),(0.58268,0.52756),(0.59055,0.52756),(0.59843,0.52756),(0.6063,0.52756),(0.61417,0.52756),(0.62205,0.52756),(0.62992,0.52756),(0.6378,0.52756),(0.64567,0.52756),(0.65354,0.52756),(0.66142,0.52756),(0.66929,0.52756),(0.67717,0.52756),(0.68504,0.52756),(0.69291,0.52756),(0.70079,0.52756),(0.70866,0.52756),(0.71654,0.52756),(0.72441,0.52756),(0.73228,0.52756),(0.74016,0.52756),(0.74803,0.52756),(0.75591,0.52756),(0.76378,0.52756),(0.77165,0.52756),(0.77953,0.52756),(0.7874,0.52756),(0.79528,0.52756),(0.80315,0.52756),(0.81102,0.52756),(0.8189,0.52756),(0.82677,0.52756),(0.83465,0.52756),(0.84252,0.52756),(0.85039,0.52756),(0.85827,0.52756),(0.86614,0.52756),(0.87402,0.52756),(0.88189,0.52756),(0.88976,0.52756),(0.89764,0.52756),(0.90551,0.52756),(0.91339,0.52756),(0.92126,0.52756),(0.92913,0.52756),(0.93701,0.52756),(0.94488,0.52756),(0.95276,0.52756),(0.96063,0.52756),(0.9685,0.52756),(0.97638,0.52756),(0.98425,0.52756),(0.99213,0.52756),(0.99609,0.52756),(0.00391,0.53543),(0.00787,0.53543),(0.01575,0.53543),(0.02362,0.53543),(0.0315,0.53543),(0.03937,0.53543),(0.04724,0.53543),(0.05512,0.53543),(0.06299,0.53543),(0.07087,0.53543),(0.07874,0.53543),(0.08661,0.53543),(0.09449,0.53543),(0.10236,0.53543),(0.11024,0.53543),(0.11811,0.53543),(0.12598,0.53543),(0.13386,0.53543),(0.14173,0.53543),(0.14961,0.53543),(0.15748,0.53543),(0.16535,0.53543),(0.17323,0.53543),(0.1811,0.53543),(0.18898,0.53543),(0.19685,0.53543),(0.20472,0.53543),(0.2126,0.53543),(0.22047,0.53543),(0.22835,0.53543),(0.23622,0.53543),(0.24409,0.53543),(0.25197,0.53543),(0.25984,0.53543),(0.26772,0.53543),(0.27559,0.53543),(0.28346,0.53543),(0.29134,0.53543),(0.29921,0.53543),(0.30709,0.53543),(0.31496,0.53543),(0.32283,0.53543),(0.33071,0.53543),(0.33858,0.53543),(0.34646,0.53543),(0.35433,0.53543),(0.3622,0.53543),(0.37008,0.53543),(0.37795,0.53543),(0.38583,0.53543),(0.3937,0.53543),(0.40157,0.53543),(0.40945,0.53543),(0.41732,0.53543),(0.4252,0.53543),(0.43307,0.53543),(0.44094,0.53543),(0.44882,0.53543),(0.45669,0.53543),(0.46457,0.53543),(0.47244,0.53543),(0.48031,0.53543),(0.48819,0.53543),(0.49606,0.53543),(0.50394,0.53543),(0.51181,0.53543),(0.51969,0.53543),(0.52756,0.53543),(0.53543,0.53543),(0.54331,0.53543),(0.55118,0.53543),(0.55906,0.53543),(0.56693,0.53543),(0.5748,0.53543),(0.58268,0.53543),(0.59055,0.53543),(0.59843,0.53543),(0.6063,0.53543),(0.61417,0.53543),(0.62205,0.53543),(0.62992,0.53543),(0.6378,0.53543),(0.64567,0.53543),(0.65354,0.53543),(0.66142,0.53543),(0.66929,0.53543),(0.67717,0.53543),(0.68504,0.53543),(0.69291,0.53543),(0.70079,0.53543),(0.70866,0.53543),(0.71654,0.53543),(0.72441,0.53543),(0.73228,0.53543),(0.74016,0.53543),(0.74803,0.53543),(0.75591,0.53543),(0.76378,0.53543),(0.77165,0.53543),(0.77953,0.53543),(0.7874,0.53543),(0.79528,0.53543),(0.80315,0.53543),(0.81102,0.53543),(0.8189,0.53543),(0.82677,0.53543),(0.83465,0.53543),(0.84252,0.53543),(0.85039,0.53543),(0.85827,0.53543),(0.86614,0.53543),(0.87402,0.53543),(0.88189,0.53543),(0.88976,0.53543),(0.89764,0.53543),(0.90551,0.53543),(0.91339,0.53543),(0.92126,0.53543),(0.92913,0.53543),(0.93701,0.53543),(0.94488,0.53543),(0.95276,0.53543),(0.96063,0.53543),(0.9685,0.53543),(0.97638,0.53543),(0.98425,0.53543),(0.99213,0.53543),(0.99609,0.53543),(0.00391,0.54331),(0.00787,0.54331),(0.01575,0.54331),(0.02362,0.54331),(0.0315,0.54331),(0.03937,0.54331),(0.04724,0.54331),(0.05512,0.54331),(0.06299,0.54331),(0.07087,0.54331),(0.07874,0.54331),(0.08661,0.54331),(0.09449,0.54331),(0.10236,0.54331),(0.11024,0.54331),(0.11811,0.54331),(0.12598,0.54331),(0.13386,0.54331),(0.14173,0.54331),(0.14961,0.54331),(0.15748,0.54331),(0.16535,0.54331),(0.17323,0.54331),(0.1811,0.54331),(0.18898,0.54331),(0.19685,0.54331),(0.20472,0.54331),(0.2126,0.54331),(0.22047,0.54331),(0.22835,0.54331),(0.23622,0.54331),(0.24409,0.54331),(0.25197,0.54331),(0.25984,0.54331),(0.26772,0.54331),(0.27559,0.54331),(0.28346,0.54331),(0.29134,0.54331),(0.29921,0.54331),(0.30709,0.54331),(0.31496,0.54331),(0.32283,0.54331),(0.33071,0.54331),(0.33858,0.54331),(0.34646,0.54331),(0.35433,0.54331),(0.3622,0.54331),(0.37008,0.54331),(0.37795,0.54331),(0.38583,0.54331),(0.3937,0.54331),(0.40157,0.54331),(0.40945,0.54331),(0.41732,0.54331),(0.4252,0.54331),(0.43307,0.54331),(0.44094,0.54331),(0.44882,0.54331),(0.45669,0.54331),(0.46457,0.54331),(0.47244,0.54331),(0.48031,0.54331),(0.48819,0.54331),(0.49606,0.54331),(0.50394,0.54331),(0.51181,0.54331),(0.51969,0.54331),(0.52756,0.54331),(0.53543,0.54331),(0.54331,0.54331),(0.55118,0.54331),(0.55906,0.54331),(0.56693,0.54331),(0.5748,0.54331),(0.58268,0.54331),(0.59055,0.54331),(0.59843,0.54331),(0.6063,0.54331),(0.61417,0.54331),(0.62205,0.54331),(0.62992,0.54331),(0.6378,0.54331),(0.64567,0.54331),(0.65354,0.54331),(0.66142,0.54331),(0.66929,0.54331),(0.67717,0.54331),(0.68504,0.54331),(0.69291,0.54331),(0.70079,0.54331),(0.70866,0.54331),(0.71654,0.54331),(0.72441,0.54331),(0.73228,0.54331),(0.74016,0.54331),(0.74803,0.54331),(0.75591,0.54331),(0.76378,0.54331),(0.77165,0.54331),(0.77953,0.54331),(0.7874,0.54331),(0.79528,0.54331),(0.80315,0.54331),(0.81102,0.54331),(0.8189,0.54331),(0.82677,0.54331),(0.83465,0.54331),(0.84252,0.54331),(0.85039,0.54331),(0.85827,0.54331),(0.86614,0.54331),(0.87402,0.54331),(0.88189,0.54331),(0.88976,0.54331),(0.89764,0.54331),(0.90551,0.54331),(0.91339,0.54331),(0.92126,0.54331),(0.92913,0.54331),(0.93701,0.54331),(0.94488,0.54331),(0.95276,0.54331),(0.96063,0.54331),(0.9685,0.54331),(0.97638,0.54331),(0.98425,0.54331),(0.99213,0.54331),(0.99609,0.54331),(0.00391,0.55118),(0.00787,0.55118),(0.01575,0.55118),(0.02362,0.55118),(0.0315,0.55118),(0.03937,0.55118),(0.04724,0.55118),(0.05512,0.55118),(0.06299,0.55118),(0.07087,0.55118),(0.07874,0.55118),(0.08661,0.55118),(0.09449,0.55118),(0.10236,0.55118),(0.11024,0.55118),(0.11811,0.55118),(0.12598,0.55118),(0.13386,0.55118),(0.14173,0.55118),(0.14961,0.55118),(0.15748,0.55118),(0.16535,0.55118),(0.17323,0.55118),(0.1811,0.55118),(0.18898,0.55118),(0.19685,0.55118),(0.20472,0.55118),(0.2126,0.55118),(0.22047,0.55118),(0.22835,0.55118),(0.23622,0.55118),(0.24409,0.55118),(0.25197,0.55118),(0.25984,0.55118),(0.26772,0.55118),(0.27559,0.55118),(0.28346,0.55118),(0.29134,0.55118),(0.29921,0.55118),(0.30709,0.55118),(0.31496,0.55118),(0.32283,0.55118),(0.33071,0.55118),(0.33858,0.55118),(0.34646,0.55118),(0.35433,0.55118),(0.3622,0.55118),(0.37008,0.55118),(0.37795,0.55118),(0.38583,0.55118),(0.3937,0.55118),(0.40157,0.55118),(0.40945,0.55118),(0.41732,0.55118),(0.4252,0.55118),(0.43307,0.55118),(0.44094,0.55118),(0.44882,0.55118),(0.45669,0.55118),(0.46457,0.55118),(0.47244,0.55118),(0.48031,0.55118),(0.48819,0.55118),(0.49606,0.55118),(0.50394,0.55118),(0.51181,0.55118),(0.51969,0.55118),(0.52756,0.55118),(0.53543,0.55118),(0.54331,0.55118),(0.55118,0.55118),(0.55906,0.55118),(0.56693,0.55118),(0.5748,0.55118),(0.58268,0.55118),(0.59055,0.55118),(0.59843,0.55118),(0.6063,0.55118),(0.61417,0.55118),(0.62205,0.55118),(0.62992,0.55118),(0.6378,0.55118),(0.64567,0.55118),(0.65354,0.55118),(0.66142,0.55118),(0.66929,0.55118),(0.67717,0.55118),(0.68504,0.55118),(0.69291,0.55118),(0.70079,0.55118),(0.70866,0.55118),(0.71654,0.55118),(0.72441,0.55118),(0.73228,0.55118),(0.74016,0.55118),(0.74803,0.55118),(0.75591,0.55118),(0.76378,0.55118),(0.77165,0.55118),(0.77953,0.55118),(0.7874,0.55118),(0.79528,0.55118),(0.80315,0.55118),(0.81102,0.55118),(0.8189,0.55118),(0.82677,0.55118),(0.83465,0.55118),(0.84252,0.55118),(0.85039,0.55118),(0.85827,0.55118),(0.86614,0.55118),(0.87402,0.55118),(0.88189,0.55118),(0.88976,0.55118),(0.89764,0.55118),(0.90551,0.55118),(0.91339,0.55118),(0.92126,0.55118),(0.92913,0.55118),(0.93701,0.55118),(0.94488,0.55118),(0.95276,0.55118),(0.96063,0.55118),(0.9685,0.55118),(0.97638,0.55118),(0.98425,0.55118),(0.99213,0.55118),(0.99609,0.55118),(0.00391,0.55906),(0.00787,0.55906),(0.01575,0.55906),(0.02362,0.55906),(0.0315,0.55906),(0.03937,0.55906),(0.04724,0.55906),(0.05512,0.55906),(0.06299,0.55906),(0.07087,0.55906),(0.07874,0.55906),(0.08661,0.55906),(0.09449,0.55906),(0.10236,0.55906),(0.11024,0.55906),(0.11811,0.55906),(0.12598,0.55906),(0.13386,0.55906),(0.14173,0.55906),(0.14961,0.55906),(0.15748,0.55906),(0.16535,0.55906),(0.17323,0.55906),(0.1811,0.55906),(0.18898,0.55906),(0.19685,0.55906),(0.20472,0.55906),(0.2126,0.55906),(0.22047,0.55906),(0.22835,0.55906),(0.23622,0.55906),(0.24409,0.55906),(0.25197,0.55906),(0.25984,0.55906),(0.26772,0.55906),(0.27559,0.55906),(0.28346,0.55906),(0.29134,0.55906),(0.29921,0.55906),(0.30709,0.55906),(0.31496,0.55906),(0.32283,0.55906),(0.33071,0.55906),(0.33858,0.55906),(0.34646,0.55906),(0.35433,0.55906),(0.3622,0.55906),(0.37008,0.55906),(0.37795,0.55906),(0.38583,0.55906),(0.3937,0.55906),(0.40157,0.55906),(0.40945,0.55906),(0.41732,0.55906),(0.4252,0.55906),(0.43307,0.55906),(0.44094,0.55906),(0.44882,0.55906),(0.45669,0.55906),(0.46457,0.55906),(0.47244,0.55906),(0.48031,0.55906),(0.48819,0.55906),(0.49606,0.55906),(0.50394,0.55906),(0.51181,0.55906),(0.51969,0.55906),(0.52756,0.55906),(0.53543,0.55906),(0.54331,0.55906),(0.55118,0.55906),(0.55906,0.55906),(0.56693,0.55906),(0.5748,0.55906),(0.58268,0.55906),(0.59055,0.55906),(0.59843,0.55906),(0.6063,0.55906),(0.61417,0.55906),(0.62205,0.55906),(0.62992,0.55906),(0.6378,0.55906),(0.64567,0.55906),(0.65354,0.55906),(0.66142,0.55906),(0.66929,0.55906),(0.67717,0.55906),(0.68504,0.55906),(0.69291,0.55906),(0.70079,0.55906),(0.70866,0.55906),(0.71654,0.55906),(0.72441,0.55906),(0.73228,0.55906),(0.74016,0.55906),(0.74803,0.55906),(0.75591,0.55906),(0.76378,0.55906),(0.77165,0.55906),(0.77953,0.55906),(0.7874,0.55906),(0.79528,0.55906),(0.80315,0.55906),(0.81102,0.55906),(0.8189,0.55906),(0.82677,0.55906),(0.83465,0.55906),(0.84252,0.55906),(0.85039,0.55906),(0.85827,0.55906),(0.86614,0.55906),(0.87402,0.55906),(0.88189,0.55906),(0.88976,0.55906),(0.89764,0.55906),(0.90551,0.55906),(0.91339,0.55906),(0.92126,0.55906),(0.92913,0.55906),(0.93701,0.55906),(0.94488,0.55906),(0.95276,0.55906),(0.96063,0.55906),(0.9685,0.55906),(0.97638,0.55906),(0.98425,0.55906),(0.99213,0.55906),(0.99609,0.55906),(0.00391,0.56693),(0.00787,0.56693),(0.01575,0.56693),(0.02362,0.56693),(0.0315,0.56693),(0.03937,0.56693),(0.04724,0.56693),(0.05512,0.56693),(0.06299,0.56693),(0.07087,0.56693),(0.07874,0.56693),(0.08661,0.56693),(0.09449,0.56693),(0.10236,0.56693),(0.11024,0.56693),(0.11811,0.56693),(0.12598,0.56693),(0.13386,0.56693),(0.14173,0.56693),(0.14961,0.56693),(0.15748,0.56693),(0.16535,0.56693),(0.17323,0.56693),(0.1811,0.56693),(0.18898,0.56693),(0.19685,0.56693),(0.20472,0.56693),(0.2126,0.56693),(0.22047,0.56693),(0.22835,0.56693),(0.23622,0.56693),(0.24409,0.56693),(0.25197,0.56693),(0.25984,0.56693),(0.26772,0.56693),(0.27559,0.56693),(0.28346,0.56693),(0.29134,0.56693),(0.29921,0.56693),(0.30709,0.56693),(0.31496,0.56693),(0.32283,0.56693),(0.33071,0.56693),(0.33858,0.56693),(0.34646,0.56693),(0.35433,0.56693),(0.3622,0.56693),(0.37008,0.56693),(0.37795,0.56693),(0.38583,0.56693),(0.3937,0.56693),(0.40157,0.56693),(0.40945,0.56693),(0.41732,0.56693),(0.4252,0.56693),(0.43307,0.56693),(0.44094,0.56693),(0.44882,0.56693),(0.45669,0.56693),(0.46457,0.56693),(0.47244,0.56693),(0.48031,0.56693),(0.48819,0.56693),(0.49606,0.56693),(0.50394,0.56693),(0.51181,0.56693),(0.51969,0.56693),(0.52756,0.56693),(0.53543,0.56693),(0.54331,0.56693),(0.55118,0.56693),(0.55906,0.56693),(0.56693,0.56693),(0.5748,0.56693),(0.58268,0.56693),(0.59055,0.56693),(0.59843,0.56693),(0.6063,0.56693),(0.61417,0.56693),(0.62205,0.56693),(0.62992,0.56693),(0.6378,0.56693),(0.64567,0.56693),(0.65354,0.56693),(0.66142,0.56693),(0.66929,0.56693),(0.67717,0.56693),(0.68504,0.56693),(0.69291,0.56693),(0.70079,0.56693),(0.70866,0.56693),(0.71654,0.56693),(0.72441,0.56693),(0.73228,0.56693),(0.74016,0.56693),(0.74803,0.56693),(0.75591,0.56693),(0.76378,0.56693),(0.77165,0.56693),(0.77953,0.56693),(0.7874,0.56693),(0.79528,0.56693),(0.80315,0.56693),(0.81102,0.56693),(0.8189,0.56693),(0.82677,0.56693),(0.83465,0.56693),(0.84252,0.56693),(0.85039,0.56693),(0.85827,0.56693),(0.86614,0.56693),(0.87402,0.56693),(0.88189,0.56693),(0.88976,0.56693),(0.89764,0.56693),(0.90551,0.56693),(0.91339,0.56693),(0.92126,0.56693),(0.92913,0.56693),(0.93701,0.56693),(0.94488,0.56693),(0.95276,0.56693),(0.96063,0.56693),(0.9685,0.56693),(0.97638,0.56693),(0.98425,0.56693),(0.99213,0.56693),(0.99609,0.56693),(0.00391,0.5748),(0.00787,0.5748),(0.01575,0.5748),(0.02362,0.5748),(0.0315,0.5748),(0.03937,0.5748),(0.04724,0.5748),(0.05512,0.5748),(0.06299,0.5748),(0.07087,0.5748),(0.07874,0.5748),(0.08661,0.5748),(0.09449,0.5748),(0.10236,0.5748),(0.11024,0.5748),(0.11811,0.5748),(0.12598,0.5748),(0.13386,0.5748),(0.14173,0.5748),(0.14961,0.5748),(0.15748,0.5748),(0.16535,0.5748),(0.17323,0.5748),(0.1811,0.5748),(0.18898,0.5748),(0.19685,0.5748),(0.20472,0.5748),(0.2126,0.5748),(0.22047,0.5748),(0.22835,0.5748),(0.23622,0.5748),(0.24409,0.5748),(0.25197,0.5748),(0.25984,0.5748),(0.26772,0.5748),(0.27559,0.5748),(0.28346,0.5748),(0.29134,0.5748),(0.29921,0.5748),(0.30709,0.5748),(0.31496,0.5748),(0.32283,0.5748),(0.33071,0.5748),(0.33858,0.5748),(0.34646,0.5748),(0.35433,0.5748),(0.3622,0.5748),(0.37008,0.5748),(0.37795,0.5748),(0.38583,0.5748),(0.3937,0.5748),(0.40157,0.5748),(0.40945,0.5748),(0.41732,0.5748),(0.4252,0.5748),(0.43307,0.5748),(0.44094,0.5748),(0.44882,0.5748),(0.45669,0.5748),(0.46457,0.5748),(0.47244,0.5748),(0.48031,0.5748),(0.48819,0.5748),(0.49606,0.5748),(0.50394,0.5748),(0.51181,0.5748),(0.51969,0.5748),(0.52756,0.5748),(0.53543,0.5748),(0.54331,0.5748),(0.55118,0.5748),(0.55906,0.5748),(0.56693,0.5748),(0.5748,0.5748),(0.58268,0.5748),(0.59055,0.5748),(0.59843,0.5748),(0.6063,0.5748),(0.61417,0.5748),(0.62205,0.5748),(0.62992,0.5748),(0.6378,0.5748),(0.64567,0.5748),(0.65354,0.5748),(0.66142,0.5748),(0.66929,0.5748),(0.67717,0.5748),(0.68504,0.5748),(0.69291,0.5748),(0.70079,0.5748),(0.70866,0.5748),(0.71654,0.5748),(0.72441,0.5748),(0.73228,0.5748),(0.74016,0.5748),(0.74803,0.5748),(0.75591,0.5748),(0.76378,0.5748),(0.77165,0.5748),(0.77953,0.5748),(0.7874,0.5748),(0.79528,0.5748),(0.80315,0.5748),(0.81102,0.5748),(0.8189,0.5748),(0.82677,0.5748),(0.83465,0.5748),(0.84252,0.5748),(0.85039,0.5748),(0.85827,0.5748),(0.86614,0.5748),(0.87402,0.5748),(0.88189,0.5748),(0.88976,0.5748),(0.89764,0.5748),(0.90551,0.5748),(0.91339,0.5748),(0.92126,0.5748),(0.92913,0.5748),(0.93701,0.5748),(0.94488,0.5748),(0.95276,0.5748),(0.96063,0.5748),(0.9685,0.5748),(0.97638,0.5748),(0.98425,0.5748),(0.99213,0.5748),(0.99609,0.5748),(0.00391,0.58268),(0.00787,0.58268),(0.01575,0.58268),(0.02362,0.58268),(0.0315,0.58268),(0.03937,0.58268),(0.04724,0.58268),(0.05512,0.58268),(0.06299,0.58268),(0.07087,0.58268),(0.07874,0.58268),(0.08661,0.58268),(0.09449,0.58268),(0.10236,0.58268),(0.11024,0.58268),(0.11811,0.58268),(0.12598,0.58268),(0.13386,0.58268),(0.14173,0.58268),(0.14961,0.58268),(0.15748,0.58268),(0.16535,0.58268),(0.17323,0.58268),(0.1811,0.58268),(0.18898,0.58268),(0.19685,0.58268),(0.20472,0.58268),(0.2126,0.58268),(0.22047,0.58268),(0.22835,0.58268),(0.23622,0.58268),(0.24409,0.58268),(0.25197,0.58268),(0.25984,0.58268),(0.26772,0.58268),(0.27559,0.58268),(0.28346,0.58268),(0.29134,0.58268),(0.29921,0.58268),(0.30709,0.58268),(0.31496,0.58268),(0.32283,0.58268),(0.33071,0.58268),(0.33858,0.58268),(0.34646,0.58268),(0.35433,0.58268),(0.3622,0.58268),(0.37008,0.58268),(0.37795,0.58268),(0.38583,0.58268),(0.3937,0.58268),(0.40157,0.58268),(0.40945,0.58268),(0.41732,0.58268),(0.4252,0.58268),(0.43307,0.58268),(0.44094,0.58268),(0.44882,0.58268),(0.45669,0.58268),(0.46457,0.58268),(0.47244,0.58268),(0.48031,0.58268),(0.48819,0.58268),(0.49606,0.58268),(0.50394,0.58268),(0.51181,0.58268),(0.51969,0.58268),(0.52756,0.58268),(0.53543,0.58268),(0.54331,0.58268),(0.55118,0.58268),(0.55906,0.58268),(0.56693,0.58268),(0.5748,0.58268),(0.58268,0.58268),(0.59055,0.58268),(0.59843,0.58268),(0.6063,0.58268),(0.61417,0.58268),(0.62205,0.58268),(0.62992,0.58268),(0.6378,0.58268),(0.64567,0.58268),(0.65354,0.58268),(0.66142,0.58268),(0.66929,0.58268),(0.67717,0.58268),(0.68504,0.58268),(0.69291,0.58268),(0.70079,0.58268),(0.70866,0.58268),(0.71654,0.58268),(0.72441,0.58268),(0.73228,0.58268),(0.74016,0.58268),(0.74803,0.58268),(0.75591,0.58268),(0.76378,0.58268),(0.77165,0.58268),(0.77953,0.58268),(0.7874,0.58268),(0.79528,0.58268),(0.80315,0.58268),(0.81102,0.58268),(0.8189,0.58268),(0.82677,0.58268),(0.83465,0.58268),(0.84252,0.58268),(0.85039,0.58268),(0.85827,0.58268),(0.86614,0.58268),(0.87402,0.58268),(0.88189,0.58268),(0.88976,0.58268),(0.89764,0.58268),(0.90551,0.58268),(0.91339,0.58268),(0.92126,0.58268),(0.92913,0.58268),(0.93701,0.58268),(0.94488,0.58268),(0.95276,0.58268),(0.96063,0.58268),(0.9685,0.58268),(0.97638,0.58268),(0.98425,0.58268),(0.99213,0.58268),(0.99609,0.58268),(0.00391,0.59055),(0.00787,0.59055),(0.01575,0.59055),(0.02362,0.59055),(0.0315,0.59055),(0.03937,0.59055),(0.04724,0.59055),(0.05512,0.59055),(0.06299,0.59055),(0.07087,0.59055),(0.07874,0.59055),(0.08661,0.59055),(0.09449,0.59055),(0.10236,0.59055),(0.11024,0.59055),(0.11811,0.59055),(0.12598,0.59055),(0.13386,0.59055),(0.14173,0.59055),(0.14961,0.59055),(0.15748,0.59055),(0.16535,0.59055),(0.17323,0.59055),(0.1811,0.59055),(0.18898,0.59055),(0.19685,0.59055),(0.20472,0.59055),(0.2126,0.59055),(0.22047,0.59055),(0.22835,0.59055),(0.23622,0.59055),(0.24409,0.59055),(0.25197,0.59055),(0.25984,0.59055),(0.26772,0.59055),(0.27559,0.59055),(0.28346,0.59055),(0.29134,0.59055),(0.29921,0.59055),(0.30709,0.59055),(0.31496,0.59055),(0.32283,0.59055),(0.33071,0.59055),(0.33858,0.59055),(0.34646,0.59055),(0.35433,0.59055),(0.3622,0.59055),(0.37008,0.59055),(0.37795,0.59055),(0.38583,0.59055),(0.3937,0.59055),(0.40157,0.59055),(0.40945,0.59055),(0.41732,0.59055),(0.4252,0.59055),(0.43307,0.59055),(0.44094,0.59055),(0.44882,0.59055),(0.45669,0.59055),(0.46457,0.59055),(0.47244,0.59055),(0.48031,0.59055),(0.48819,0.59055),(0.49606,0.59055),(0.50394,0.59055),(0.51181,0.59055),(0.51969,0.59055),(0.52756,0.59055),(0.53543,0.59055),(0.54331,0.59055),(0.55118,0.59055),(0.55906,0.59055),(0.56693,0.59055),(0.5748,0.59055),(0.58268,0.59055),(0.59055,0.59055),(0.59843,0.59055),(0.6063,0.59055),(0.61417,0.59055),(0.62205,0.59055),(0.62992,0.59055),(0.6378,0.59055),(0.64567,0.59055),(0.65354,0.59055),(0.66142,0.59055),(0.66929,0.59055),(0.67717,0.59055),(0.68504,0.59055),(0.69291,0.59055),(0.70079,0.59055),(0.70866,0.59055),(0.71654,0.59055),(0.72441,0.59055),(0.73228,0.59055),(0.74016,0.59055),(0.74803,0.59055),(0.75591,0.59055),(0.76378,0.59055),(0.77165,0.59055),(0.77953,0.59055),(0.7874,0.59055),(0.79528,0.59055),(0.80315,0.59055),(0.81102,0.59055),(0.8189,0.59055),(0.82677,0.59055),(0.83465,0.59055),(0.84252,0.59055),(0.85039,0.59055),(0.85827,0.59055),(0.86614,0.59055),(0.87402,0.59055),(0.88189,0.59055),(0.88976,0.59055),(0.89764,0.59055),(0.90551,0.59055),(0.91339,0.59055),(0.92126,0.59055),(0.92913,0.59055),(0.93701,0.59055),(0.94488,0.59055),(0.95276,0.59055),(0.96063,0.59055),(0.9685,0.59055),(0.97638,0.59055),(0.98425,0.59055),(0.99213,0.59055),(0.99609,0.59055),(0.00391,0.59843),(0.00787,0.59843),(0.01575,0.59843),(0.02362,0.59843),(0.0315,0.59843),(0.03937,0.59843),(0.04724,0.59843),(0.05512,0.59843),(0.06299,0.59843),(0.07087,0.59843),(0.07874,0.59843),(0.08661,0.59843),(0.09449,0.59843),(0.10236,0.59843),(0.11024,0.59843),(0.11811,0.59843),(0.12598,0.59843),(0.13386,0.59843),(0.14173,0.59843),(0.14961,0.59843),(0.15748,0.59843),(0.16535,0.59843),(0.17323,0.59843),(0.1811,0.59843),(0.18898,0.59843),(0.19685,0.59843),(0.20472,0.59843),(0.2126,0.59843),(0.22047,0.59843),(0.22835,0.59843),(0.23622,0.59843),(0.24409,0.59843),(0.25197,0.59843),(0.25984,0.59843),(0.26772,0.59843),(0.27559,0.59843),(0.28346,0.59843),(0.29134,0.59843),(0.29921,0.59843),(0.30709,0.59843),(0.31496,0.59843),(0.32283,0.59843),(0.33071,0.59843),(0.33858,0.59843),(0.34646,0.59843),(0.35433,0.59843),(0.3622,0.59843),(0.37008,0.59843),(0.37795,0.59843),(0.38583,0.59843),(0.3937,0.59843),(0.40157,0.59843),(0.40945,0.59843),(0.41732,0.59843),(0.4252,0.59843),(0.43307,0.59843),(0.44094,0.59843),(0.44882,0.59843),(0.45669,0.59843),(0.46457,0.59843),(0.47244,0.59843),(0.48031,0.59843),(0.48819,0.59843),(0.49606,0.59843),(0.50394,0.59843),(0.51181,0.59843),(0.51969,0.59843),(0.52756,0.59843),(0.53543,0.59843),(0.54331,0.59843),(0.55118,0.59843),(0.55906,0.59843),(0.56693,0.59843),(0.5748,0.59843),(0.58268,0.59843),(0.59055,0.59843),(0.59843,0.59843),(0.6063,0.59843),(0.61417,0.59843),(0.62205,0.59843),(0.62992,0.59843),(0.6378,0.59843),(0.64567,0.59843),(0.65354,0.59843),(0.66142,0.59843),(0.66929,0.59843),(0.67717,0.59843),(0.68504,0.59843),(0.69291,0.59843),(0.70079,0.59843),(0.70866,0.59843),(0.71654,0.59843),(0.72441,0.59843),(0.73228,0.59843),(0.74016,0.59843),(0.74803,0.59843),(0.75591,0.59843),(0.76378,0.59843),(0.77165,0.59843),(0.77953,0.59843),(0.7874,0.59843),(0.79528,0.59843),(0.80315,0.59843),(0.81102,0.59843),(0.8189,0.59843),(0.82677,0.59843),(0.83465,0.59843),(0.84252,0.59843),(0.85039,0.59843),(0.85827,0.59843),(0.86614,0.59843),(0.87402,0.59843),(0.88189,0.59843),(0.88976,0.59843),(0.89764,0.59843),(0.90551,0.59843),(0.91339,0.59843),(0.92126,0.59843),(0.92913,0.59843),(0.93701,0.59843),(0.94488,0.59843),(0.95276,0.59843),(0.96063,0.59843),(0.9685,0.59843),(0.97638,0.59843),(0.98425,0.59843),(0.99213,0.59843),(0.99609,0.59843),(0.00391,0.6063),(0.00787,0.6063),(0.01575,0.6063),(0.02362,0.6063),(0.0315,0.6063),(0.03937,0.6063),(0.04724,0.6063),(0.05512,0.6063),(0.06299,0.6063),(0.07087,0.6063),(0.07874,0.6063),(0.08661,0.6063),(0.09449,0.6063),(0.10236,0.6063),(0.11024,0.6063),(0.11811,0.6063),(0.12598,0.6063),(0.13386,0.6063),(0.14173,0.6063),(0.14961,0.6063),(0.15748,0.6063),(0.16535,0.6063),(0.17323,0.6063),(0.1811,0.6063),(0.18898,0.6063),(0.19685,0.6063),(0.20472,0.6063),(0.2126,0.6063),(0.22047,0.6063),(0.22835,0.6063),(0.23622,0.6063),(0.24409,0.6063),(0.25197,0.6063),(0.25984,0.6063),(0.26772,0.6063),(0.27559,0.6063),(0.28346,0.6063),(0.29134,0.6063),(0.29921,0.6063),(0.30709,0.6063),(0.31496,0.6063),(0.32283,0.6063),(0.33071,0.6063),(0.33858,0.6063),(0.34646,0.6063),(0.35433,0.6063),(0.3622,0.6063),(0.37008,0.6063),(0.37795,0.6063),(0.38583,0.6063),(0.3937,0.6063),(0.40157,0.6063),(0.40945,0.6063),(0.41732,0.6063),(0.4252,0.6063),(0.43307,0.6063),(0.44094,0.6063),(0.44882,0.6063),(0.45669,0.6063),(0.46457,0.6063),(0.47244,0.6063),(0.48031,0.6063),(0.48819,0.6063),(0.49606,0.6063),(0.50394,0.6063),(0.51181,0.6063),(0.51969,0.6063),(0.52756,0.6063),(0.53543,0.6063),(0.54331,0.6063),(0.55118,0.6063),(0.55906,0.6063),(0.56693,0.6063),(0.5748,0.6063),(0.58268,0.6063),(0.59055,0.6063),(0.59843,0.6063),(0.6063,0.6063),(0.61417,0.6063),(0.62205,0.6063),(0.62992,0.6063),(0.6378,0.6063),(0.64567,0.6063),(0.65354,0.6063),(0.66142,0.6063),(0.66929,0.6063),(0.67717,0.6063),(0.68504,0.6063),(0.69291,0.6063),(0.70079,0.6063),(0.70866,0.6063),(0.71654,0.6063),(0.72441,0.6063),(0.73228,0.6063),(0.74016,0.6063),(0.74803,0.6063),(0.75591,0.6063),(0.76378,0.6063),(0.77165,0.6063),(0.77953,0.6063),(0.7874,0.6063),(0.79528,0.6063),(0.80315,0.6063),(0.81102,0.6063),(0.8189,0.6063),(0.82677,0.6063),(0.83465,0.6063),(0.84252,0.6063),(0.85039,0.6063),(0.85827,0.6063),(0.86614,0.6063),(0.87402,0.6063),(0.88189,0.6063),(0.88976,0.6063),(0.89764,0.6063),(0.90551,0.6063),(0.91339,0.6063),(0.92126,0.6063),(0.92913,0.6063),(0.93701,0.6063),(0.94488,0.6063),(0.95276,0.6063),(0.96063,0.6063),(0.9685,0.6063),(0.97638,0.6063),(0.98425,0.6063),(0.99213,0.6063),(0.99609,0.6063),(0.00391,0.61417),(0.00787,0.61417),(0.01575,0.61417),(0.02362,0.61417),(0.0315,0.61417),(0.03937,0.61417),(0.04724,0.61417),(0.05512,0.61417),(0.06299,0.61417),(0.07087,0.61417),(0.07874,0.61417),(0.08661,0.61417),(0.09449,0.61417),(0.10236,0.61417),(0.11024,0.61417),(0.11811,0.61417),(0.12598,0.61417),(0.13386,0.61417),(0.14173,0.61417),(0.14961,0.61417),(0.15748,0.61417),(0.16535,0.61417),(0.17323,0.61417),(0.1811,0.61417),(0.18898,0.61417),(0.19685,0.61417),(0.20472,0.61417),(0.2126,0.61417),(0.22047,0.61417),(0.22835,0.61417),(0.23622,0.61417),(0.24409,0.61417),(0.25197,0.61417),(0.25984,0.61417),(0.26772,0.61417),(0.27559,0.61417),(0.28346,0.61417),(0.29134,0.61417),(0.29921,0.61417),(0.30709,0.61417),(0.31496,0.61417),(0.32283,0.61417),(0.33071,0.61417),(0.33858,0.61417),(0.34646,0.61417),(0.35433,0.61417),(0.3622,0.61417),(0.37008,0.61417),(0.37795,0.61417),(0.38583,0.61417),(0.3937,0.61417),(0.40157,0.61417),(0.40945,0.61417),(0.41732,0.61417),(0.4252,0.61417),(0.43307,0.61417),(0.44094,0.61417),(0.44882,0.61417),(0.45669,0.61417),(0.46457,0.61417),(0.47244,0.61417),(0.48031,0.61417),(0.48819,0.61417),(0.49606,0.61417),(0.50394,0.61417),(0.51181,0.61417),(0.51969,0.61417),(0.52756,0.61417),(0.53543,0.61417),(0.54331,0.61417),(0.55118,0.61417),(0.55906,0.61417),(0.56693,0.61417),(0.5748,0.61417),(0.58268,0.61417),(0.59055,0.61417),(0.59843,0.61417),(0.6063,0.61417),(0.61417,0.61417),(0.62205,0.61417),(0.62992,0.61417),(0.6378,0.61417),(0.64567,0.61417),(0.65354,0.61417),(0.66142,0.61417),(0.66929,0.61417),(0.67717,0.61417),(0.68504,0.61417),(0.69291,0.61417),(0.70079,0.61417),(0.70866,0.61417),(0.71654,0.61417),(0.72441,0.61417),(0.73228,0.61417),(0.74016,0.61417),(0.74803,0.61417),(0.75591,0.61417),(0.76378,0.61417),(0.77165,0.61417),(0.77953,0.61417),(0.7874,0.61417),(0.79528,0.61417),(0.80315,0.61417),(0.81102,0.61417),(0.8189,0.61417),(0.82677,0.61417),(0.83465,0.61417),(0.84252,0.61417),(0.85039,0.61417),(0.85827,0.61417),(0.86614,0.61417),(0.87402,0.61417),(0.88189,0.61417),(0.88976,0.61417),(0.89764,0.61417),(0.90551,0.61417),(0.91339,0.61417),(0.92126,0.61417),(0.92913,0.61417),(0.93701,0.61417),(0.94488,0.61417),(0.95276,0.61417),(0.96063,0.61417),(0.9685,0.61417),(0.97638,0.61417),(0.98425,0.61417),(0.99213,0.61417),(0.99609,0.61417),(0.00391,0.62205),(0.00787,0.62205),(0.01575,0.62205),(0.02362,0.62205),(0.0315,0.62205),(0.03937,0.62205),(0.04724,0.62205),(0.05512,0.62205),(0.06299,0.62205),(0.07087,0.62205),(0.07874,0.62205),(0.08661,0.62205),(0.09449,0.62205),(0.10236,0.62205),(0.11024,0.62205),(0.11811,0.62205),(0.12598,0.62205),(0.13386,0.62205),(0.14173,0.62205),(0.14961,0.62205),(0.15748,0.62205),(0.16535,0.62205),(0.17323,0.62205),(0.1811,0.62205),(0.18898,0.62205),(0.19685,0.62205),(0.20472,0.62205),(0.2126,0.62205),(0.22047,0.62205),(0.22835,0.62205),(0.23622,0.62205),(0.24409,0.62205),(0.25197,0.62205),(0.25984,0.62205),(0.26772,0.62205),(0.27559,0.62205),(0.28346,0.62205),(0.29134,0.62205),(0.29921,0.62205),(0.30709,0.62205),(0.31496,0.62205),(0.32283,0.62205),(0.33071,0.62205),(0.33858,0.62205),(0.34646,0.62205),(0.35433,0.62205),(0.3622,0.62205),(0.37008,0.62205),(0.37795,0.62205),(0.38583,0.62205),(0.3937,0.62205),(0.40157,0.62205),(0.40945,0.62205),(0.41732,0.62205),(0.4252,0.62205),(0.43307,0.62205),(0.44094,0.62205),(0.44882,0.62205),(0.45669,0.62205),(0.46457,0.62205),(0.47244,0.62205),(0.48031,0.62205),(0.48819,0.62205),(0.49606,0.62205),(0.50394,0.62205),(0.51181,0.62205),(0.51969,0.62205),(0.52756,0.62205),(0.53543,0.62205),(0.54331,0.62205),(0.55118,0.62205),(0.55906,0.62205),(0.56693,0.62205),(0.5748,0.62205),(0.58268,0.62205),(0.59055,0.62205),(0.59843,0.62205),(0.6063,0.62205),(0.61417,0.62205),(0.62205,0.62205),(0.62992,0.62205),(0.6378,0.62205),(0.64567,0.62205),(0.65354,0.62205),(0.66142,0.62205),(0.66929,0.62205),(0.67717,0.62205),(0.68504,0.62205),(0.69291,0.62205),(0.70079,0.62205),(0.70866,0.62205),(0.71654,0.62205),(0.72441,0.62205),(0.73228,0.62205),(0.74016,0.62205),(0.74803,0.62205),(0.75591,0.62205),(0.76378,0.62205),(0.77165,0.62205),(0.77953,0.62205),(0.7874,0.62205),(0.79528,0.62205),(0.80315,0.62205),(0.81102,0.62205),(0.8189,0.62205),(0.82677,0.62205),(0.83465,0.62205),(0.84252,0.62205),(0.85039,0.62205),(0.85827,0.62205),(0.86614,0.62205),(0.87402,0.62205),(0.88189,0.62205),(0.88976,0.62205),(0.89764,0.62205),(0.90551,0.62205),(0.91339,0.62205),(0.92126,0.62205),(0.92913,0.62205),(0.93701,0.62205),(0.94488,0.62205),(0.95276,0.62205),(0.96063,0.62205),(0.9685,0.62205),(0.97638,0.62205),(0.98425,0.62205),(0.99213,0.62205),(0.99609,0.62205),(0.00391,0.62992),(0.00787,0.62992),(0.01575,0.62992),(0.02362,0.62992),(0.0315,0.62992),(0.03937,0.62992),(0.04724,0.62992),(0.05512,0.62992),(0.06299,0.62992),(0.07087,0.62992),(0.07874,0.62992),(0.08661,0.62992),(0.09449,0.62992),(0.10236,0.62992),(0.11024,0.62992),(0.11811,0.62992),(0.12598,0.62992),(0.13386,0.62992),(0.14173,0.62992),(0.14961,0.62992),(0.15748,0.62992),(0.16535,0.62992),(0.17323,0.62992),(0.1811,0.62992),(0.18898,0.62992),(0.19685,0.62992),(0.20472,0.62992),(0.2126,0.62992),(0.22047,0.62992),(0.22835,0.62992),(0.23622,0.62992),(0.24409,0.62992),(0.25197,0.62992),(0.25984,0.62992),(0.26772,0.62992),(0.27559,0.62992),(0.28346,0.62992),(0.29134,0.62992),(0.29921,0.62992),(0.30709,0.62992),(0.31496,0.62992),(0.32283,0.62992),(0.33071,0.62992),(0.33858,0.62992),(0.34646,0.62992),(0.35433,0.62992),(0.3622,0.62992),(0.37008,0.62992),(0.37795,0.62992),(0.38583,0.62992),(0.3937,0.62992),(0.40157,0.62992),(0.40945,0.62992),(0.41732,0.62992),(0.4252,0.62992),(0.43307,0.62992),(0.44094,0.62992),(0.44882,0.62992),(0.45669,0.62992),(0.46457,0.62992),(0.47244,0.62992),(0.48031,0.62992),(0.48819,0.62992),(0.49606,0.62992),(0.50394,0.62992),(0.51181,0.62992),(0.51969,0.62992),(0.52756,0.62992),(0.53543,0.62992),(0.54331,0.62992),(0.55118,0.62992),(0.55906,0.62992),(0.56693,0.62992),(0.5748,0.62992),(0.58268,0.62992),(0.59055,0.62992),(0.59843,0.62992),(0.6063,0.62992),(0.61417,0.62992),(0.62205,0.62992),(0.62992,0.62992),(0.6378,0.62992),(0.64567,0.62992),(0.65354,0.62992),(0.66142,0.62992),(0.66929,0.62992),(0.67717,0.62992),(0.68504,0.62992),(0.69291,0.62992),(0.70079,0.62992),(0.70866,0.62992),(0.71654,0.62992),(0.72441,0.62992),(0.73228,0.62992),(0.74016,0.62992),(0.74803,0.62992),(0.75591,0.62992),(0.76378,0.62992),(0.77165,0.62992),(0.77953,0.62992),(0.7874,0.62992),(0.79528,0.62992),(0.80315,0.62992),(0.81102,0.62992),(0.8189,0.62992),(0.82677,0.62992),(0.83465,0.62992),(0.84252,0.62992),(0.85039,0.62992),(0.85827,0.62992),(0.86614,0.62992),(0.87402,0.62992),(0.88189,0.62992),(0.88976,0.62992),(0.89764,0.62992),(0.90551,0.62992),(0.91339,0.62992),(0.92126,0.62992),(0.92913,0.62992),(0.93701,0.62992),(0.94488,0.62992),(0.95276,0.62992),(0.96063,0.62992),(0.9685,0.62992),(0.97638,0.62992),(0.98425,0.62992),(0.99213,0.62992),(0.99609,0.62992),(0.00391,0.6378),(0.00787,0.6378),(0.01575,0.6378),(0.02362,0.6378),(0.0315,0.6378),(0.03937,0.6378),(0.04724,0.6378),(0.05512,0.6378),(0.06299,0.6378),(0.07087,0.6378),(0.07874,0.6378),(0.08661,0.6378),(0.09449,0.6378),(0.10236,0.6378),(0.11024,0.6378),(0.11811,0.6378),(0.12598,0.6378),(0.13386,0.6378),(0.14173,0.6378),(0.14961,0.6378),(0.15748,0.6378),(0.16535,0.6378),(0.17323,0.6378),(0.1811,0.6378),(0.18898,0.6378),(0.19685,0.6378),(0.20472,0.6378),(0.2126,0.6378),(0.22047,0.6378),(0.22835,0.6378),(0.23622,0.6378),(0.24409,0.6378),(0.25197,0.6378),(0.25984,0.6378),(0.26772,0.6378),(0.27559,0.6378),(0.28346,0.6378),(0.29134,0.6378),(0.29921,0.6378),(0.30709,0.6378),(0.31496,0.6378),(0.32283,0.6378),(0.33071,0.6378),(0.33858,0.6378),(0.34646,0.6378),(0.35433,0.6378),(0.3622,0.6378),(0.37008,0.6378),(0.37795,0.6378),(0.38583,0.6378),(0.3937,0.6378),(0.40157,0.6378),(0.40945,0.6378),(0.41732,0.6378),(0.4252,0.6378),(0.43307,0.6378),(0.44094,0.6378),(0.44882,0.6378),(0.45669,0.6378),(0.46457,0.6378),(0.47244,0.6378),(0.48031,0.6378),(0.48819,0.6378),(0.49606,0.6378),(0.50394,0.6378),(0.51181,0.6378),(0.51969,0.6378),(0.52756,0.6378),(0.53543,0.6378),(0.54331,0.6378),(0.55118,0.6378),(0.55906,0.6378),(0.56693,0.6378),(0.5748,0.6378),(0.58268,0.6378),(0.59055,0.6378),(0.59843,0.6378),(0.6063,0.6378),(0.61417,0.6378),(0.62205,0.6378),(0.62992,0.6378),(0.6378,0.6378),(0.64567,0.6378),(0.65354,0.6378),(0.66142,0.6378),(0.66929,0.6378),(0.67717,0.6378),(0.68504,0.6378),(0.69291,0.6378),(0.70079,0.6378),(0.70866,0.6378),(0.71654,0.6378),(0.72441,0.6378),(0.73228,0.6378),(0.74016,0.6378),(0.74803,0.6378),(0.75591,0.6378),(0.76378,0.6378),(0.77165,0.6378),(0.77953,0.6378),(0.7874,0.6378),(0.79528,0.6378),(0.80315,0.6378),(0.81102,0.6378),(0.8189,0.6378),(0.82677,0.6378),(0.83465,0.6378),(0.84252,0.6378),(0.85039,0.6378),(0.85827,0.6378),(0.86614,0.6378),(0.87402,0.6378),(0.88189,0.6378),(0.88976,0.6378),(0.89764,0.6378),(0.90551,0.6378),(0.91339,0.6378),(0.92126,0.6378),(0.92913,0.6378),(0.93701,0.6378),(0.94488,0.6378),(0.95276,0.6378),(0.96063,0.6378),(0.9685,0.6378),(0.97638,0.6378),(0.98425,0.6378),(0.99213,0.6378),(0.99609,0.6378),(0.00391,0.64567),(0.00787,0.64567),(0.01575,0.64567),(0.02362,0.64567),(0.0315,0.64567),(0.03937,0.64567),(0.04724,0.64567),(0.05512,0.64567),(0.06299,0.64567),(0.07087,0.64567),(0.07874,0.64567),(0.08661,0.64567),(0.09449,0.64567),(0.10236,0.64567),(0.11024,0.64567),(0.11811,0.64567),(0.12598,0.64567),(0.13386,0.64567),(0.14173,0.64567),(0.14961,0.64567),(0.15748,0.64567),(0.16535,0.64567),(0.17323,0.64567),(0.1811,0.64567),(0.18898,0.64567),(0.19685,0.64567),(0.20472,0.64567),(0.2126,0.64567),(0.22047,0.64567),(0.22835,0.64567),(0.23622,0.64567),(0.24409,0.64567),(0.25197,0.64567),(0.25984,0.64567),(0.26772,0.64567),(0.27559,0.64567),(0.28346,0.64567),(0.29134,0.64567),(0.29921,0.64567),(0.30709,0.64567),(0.31496,0.64567),(0.32283,0.64567),(0.33071,0.64567),(0.33858,0.64567),(0.34646,0.64567),(0.35433,0.64567),(0.3622,0.64567),(0.37008,0.64567),(0.37795,0.64567),(0.38583,0.64567),(0.3937,0.64567),(0.40157,0.64567),(0.40945,0.64567),(0.41732,0.64567),(0.4252,0.64567),(0.43307,0.64567),(0.44094,0.64567),(0.44882,0.64567),(0.45669,0.64567),(0.46457,0.64567),(0.47244,0.64567),(0.48031,0.64567),(0.48819,0.64567),(0.49606,0.64567),(0.50394,0.64567),(0.51181,0.64567),(0.51969,0.64567),(0.52756,0.64567),(0.53543,0.64567),(0.54331,0.64567),(0.55118,0.64567),(0.55906,0.64567),(0.56693,0.64567),(0.5748,0.64567),(0.58268,0.64567),(0.59055,0.64567),(0.59843,0.64567),(0.6063,0.64567),(0.61417,0.64567),(0.62205,0.64567),(0.62992,0.64567),(0.6378,0.64567),(0.64567,0.64567),(0.65354,0.64567),(0.66142,0.64567),(0.66929,0.64567),(0.67717,0.64567),(0.68504,0.64567),(0.69291,0.64567),(0.70079,0.64567),(0.70866,0.64567),(0.71654,0.64567),(0.72441,0.64567),(0.73228,0.64567),(0.74016,0.64567),(0.74803,0.64567),(0.75591,0.64567),(0.76378,0.64567),(0.77165,0.64567),(0.77953,0.64567),(0.7874,0.64567),(0.79528,0.64567),(0.80315,0.64567),(0.81102,0.64567),(0.8189,0.64567),(0.82677,0.64567),(0.83465,0.64567),(0.84252,0.64567),(0.85039,0.64567),(0.85827,0.64567),(0.86614,0.64567),(0.87402,0.64567),(0.88189,0.64567),(0.88976,0.64567),(0.89764,0.64567),(0.90551,0.64567),(0.91339,0.64567),(0.92126,0.64567),(0.92913,0.64567),(0.93701,0.64567),(0.94488,0.64567),(0.95276,0.64567),(0.96063,0.64567),(0.9685,0.64567),(0.97638,0.64567),(0.98425,0.64567),(0.99213,0.64567),(0.99609,0.64567),(0.00391,0.65354),(0.00787,0.65354),(0.01575,0.65354),(0.02362,0.65354),(0.0315,0.65354),(0.03937,0.65354),(0.04724,0.65354),(0.05512,0.65354),(0.06299,0.65354),(0.07087,0.65354),(0.07874,0.65354),(0.08661,0.65354),(0.09449,0.65354),(0.10236,0.65354),(0.11024,0.65354),(0.11811,0.65354),(0.12598,0.65354),(0.13386,0.65354),(0.14173,0.65354),(0.14961,0.65354),(0.15748,0.65354),(0.16535,0.65354),(0.17323,0.65354),(0.1811,0.65354),(0.18898,0.65354),(0.19685,0.65354),(0.20472,0.65354),(0.2126,0.65354),(0.22047,0.65354),(0.22835,0.65354),(0.23622,0.65354),(0.24409,0.65354),(0.25197,0.65354),(0.25984,0.65354),(0.26772,0.65354),(0.27559,0.65354),(0.28346,0.65354),(0.29134,0.65354),(0.29921,0.65354),(0.30709,0.65354),(0.31496,0.65354),(0.32283,0.65354),(0.33071,0.65354),(0.33858,0.65354),(0.34646,0.65354),(0.35433,0.65354),(0.3622,0.65354),(0.37008,0.65354),(0.37795,0.65354),(0.38583,0.65354),(0.3937,0.65354),(0.40157,0.65354),(0.40945,0.65354),(0.41732,0.65354),(0.4252,0.65354),(0.43307,0.65354),(0.44094,0.65354),(0.44882,0.65354),(0.45669,0.65354),(0.46457,0.65354),(0.47244,0.65354),(0.48031,0.65354),(0.48819,0.65354),(0.49606,0.65354),(0.50394,0.65354),(0.51181,0.65354),(0.51969,0.65354),(0.52756,0.65354),(0.53543,0.65354),(0.54331,0.65354),(0.55118,0.65354),(0.55906,0.65354),(0.56693,0.65354),(0.5748,0.65354),(0.58268,0.65354),(0.59055,0.65354),(0.59843,0.65354),(0.6063,0.65354),(0.61417,0.65354),(0.62205,0.65354),(0.62992,0.65354),(0.6378,0.65354),(0.64567,0.65354),(0.65354,0.65354),(0.66142,0.65354),(0.66929,0.65354),(0.67717,0.65354),(0.68504,0.65354),(0.69291,0.65354),(0.70079,0.65354),(0.70866,0.65354),(0.71654,0.65354),(0.72441,0.65354),(0.73228,0.65354),(0.74016,0.65354),(0.74803,0.65354),(0.75591,0.65354),(0.76378,0.65354),(0.77165,0.65354),(0.77953,0.65354),(0.7874,0.65354),(0.79528,0.65354),(0.80315,0.65354),(0.81102,0.65354),(0.8189,0.65354),(0.82677,0.65354),(0.83465,0.65354),(0.84252,0.65354),(0.85039,0.65354),(0.85827,0.65354),(0.86614,0.65354),(0.87402,0.65354),(0.88189,0.65354),(0.88976,0.65354),(0.89764,0.65354),(0.90551,0.65354),(0.91339,0.65354),(0.92126,0.65354),(0.92913,0.65354),(0.93701,0.65354),(0.94488,0.65354),(0.95276,0.65354),(0.96063,0.65354),(0.9685,0.65354),(0.97638,0.65354),(0.98425,0.65354),(0.99213,0.65354),(0.99609,0.65354),(0.00391,0.66142),(0.00787,0.66142),(0.01575,0.66142),(0.02362,0.66142),(0.0315,0.66142),(0.03937,0.66142),(0.04724,0.66142),(0.05512,0.66142),(0.06299,0.66142),(0.07087,0.66142),(0.07874,0.66142),(0.08661,0.66142),(0.09449,0.66142),(0.10236,0.66142),(0.11024,0.66142),(0.11811,0.66142),(0.12598,0.66142),(0.13386,0.66142),(0.14173,0.66142),(0.14961,0.66142),(0.15748,0.66142),(0.16535,0.66142),(0.17323,0.66142),(0.1811,0.66142),(0.18898,0.66142),(0.19685,0.66142),(0.20472,0.66142),(0.2126,0.66142),(0.22047,0.66142),(0.22835,0.66142),(0.23622,0.66142),(0.24409,0.66142),(0.25197,0.66142),(0.25984,0.66142),(0.26772,0.66142),(0.27559,0.66142),(0.28346,0.66142),(0.29134,0.66142),(0.29921,0.66142),(0.30709,0.66142),(0.31496,0.66142),(0.32283,0.66142),(0.33071,0.66142),(0.33858,0.66142),(0.34646,0.66142),(0.35433,0.66142),(0.3622,0.66142),(0.37008,0.66142),(0.37795,0.66142),(0.38583,0.66142),(0.3937,0.66142),(0.40157,0.66142),(0.40945,0.66142),(0.41732,0.66142),(0.4252,0.66142),(0.43307,0.66142),(0.44094,0.66142),(0.44882,0.66142),(0.45669,0.66142),(0.46457,0.66142),(0.47244,0.66142),(0.48031,0.66142),(0.48819,0.66142),(0.49606,0.66142),(0.50394,0.66142),(0.51181,0.66142),(0.51969,0.66142),(0.52756,0.66142),(0.53543,0.66142),(0.54331,0.66142),(0.55118,0.66142),(0.55906,0.66142),(0.56693,0.66142),(0.5748,0.66142),(0.58268,0.66142),(0.59055,0.66142),(0.59843,0.66142),(0.6063,0.66142),(0.61417,0.66142),(0.62205,0.66142),(0.62992,0.66142),(0.6378,0.66142),(0.64567,0.66142),(0.65354,0.66142),(0.66142,0.66142),(0.66929,0.66142),(0.67717,0.66142),(0.68504,0.66142),(0.69291,0.66142),(0.70079,0.66142),(0.70866,0.66142),(0.71654,0.66142),(0.72441,0.66142),(0.73228,0.66142),(0.74016,0.66142),(0.74803,0.66142),(0.75591,0.66142),(0.76378,0.66142),(0.77165,0.66142),(0.77953,0.66142),(0.7874,0.66142),(0.79528,0.66142),(0.80315,0.66142),(0.81102,0.66142),(0.8189,0.66142),(0.82677,0.66142),(0.83465,0.66142),(0.84252,0.66142),(0.85039,0.66142),(0.85827,0.66142),(0.86614,0.66142),(0.87402,0.66142),(0.88189,0.66142),(0.88976,0.66142),(0.89764,0.66142),(0.90551,0.66142),(0.91339,0.66142),(0.92126,0.66142),(0.92913,0.66142),(0.93701,0.66142),(0.94488,0.66142),(0.95276,0.66142),(0.96063,0.66142),(0.9685,0.66142),(0.97638,0.66142),(0.98425,0.66142),(0.99213,0.66142),(0.99609,0.66142),(0.00391,0.66929),(0.00787,0.66929),(0.01575,0.66929),(0.02362,0.66929),(0.0315,0.66929),(0.03937,0.66929),(0.04724,0.66929),(0.05512,0.66929),(0.06299,0.66929),(0.07087,0.66929),(0.07874,0.66929),(0.08661,0.66929),(0.09449,0.66929),(0.10236,0.66929),(0.11024,0.66929),(0.11811,0.66929),(0.12598,0.66929),(0.13386,0.66929),(0.14173,0.66929),(0.14961,0.66929),(0.15748,0.66929),(0.16535,0.66929),(0.17323,0.66929),(0.1811,0.66929),(0.18898,0.66929),(0.19685,0.66929),(0.20472,0.66929),(0.2126,0.66929),(0.22047,0.66929),(0.22835,0.66929),(0.23622,0.66929),(0.24409,0.66929),(0.25197,0.66929),(0.25984,0.66929),(0.26772,0.66929),(0.27559,0.66929),(0.28346,0.66929),(0.29134,0.66929),(0.29921,0.66929),(0.30709,0.66929),(0.31496,0.66929),(0.32283,0.66929),(0.33071,0.66929),(0.33858,0.66929),(0.34646,0.66929),(0.35433,0.66929),(0.3622,0.66929),(0.37008,0.66929),(0.37795,0.66929),(0.38583,0.66929),(0.3937,0.66929),(0.40157,0.66929),(0.40945,0.66929),(0.41732,0.66929),(0.4252,0.66929),(0.43307,0.66929),(0.44094,0.66929),(0.44882,0.66929),(0.45669,0.66929),(0.46457,0.66929),(0.47244,0.66929),(0.48031,0.66929),(0.48819,0.66929),(0.49606,0.66929),(0.50394,0.66929),(0.51181,0.66929),(0.51969,0.66929),(0.52756,0.66929),(0.53543,0.66929),(0.54331,0.66929),(0.55118,0.66929),(0.55906,0.66929),(0.56693,0.66929),(0.5748,0.66929),(0.58268,0.66929),(0.59055,0.66929),(0.59843,0.66929),(0.6063,0.66929),(0.61417,0.66929),(0.62205,0.66929),(0.62992,0.66929),(0.6378,0.66929),(0.64567,0.66929),(0.65354,0.66929),(0.66142,0.66929),(0.66929,0.66929),(0.67717,0.66929),(0.68504,0.66929),(0.69291,0.66929),(0.70079,0.66929),(0.70866,0.66929),(0.71654,0.66929),(0.72441,0.66929),(0.73228,0.66929),(0.74016,0.66929),(0.74803,0.66929),(0.75591,0.66929),(0.76378,0.66929),(0.77165,0.66929),(0.77953,0.66929),(0.7874,0.66929),(0.79528,0.66929),(0.80315,0.66929),(0.81102,0.66929),(0.8189,0.66929),(0.82677,0.66929),(0.83465,0.66929),(0.84252,0.66929),(0.85039,0.66929),(0.85827,0.66929),(0.86614,0.66929),(0.87402,0.66929),(0.88189,0.66929),(0.88976,0.66929),(0.89764,0.66929),(0.90551,0.66929),(0.91339,0.66929),(0.92126,0.66929),(0.92913,0.66929),(0.93701,0.66929),(0.94488,0.66929),(0.95276,0.66929),(0.96063,0.66929),(0.9685,0.66929),(0.97638,0.66929),(0.98425,0.66929),(0.99213,0.66929),(0.99609,0.66929),(0.00391,0.67717),(0.00787,0.67717),(0.01575,0.67717),(0.02362,0.67717),(0.0315,0.67717),(0.03937,0.67717),(0.04724,0.67717),(0.05512,0.67717),(0.06299,0.67717),(0.07087,0.67717),(0.07874,0.67717),(0.08661,0.67717),(0.09449,0.67717),(0.10236,0.67717),(0.11024,0.67717),(0.11811,0.67717),(0.12598,0.67717),(0.13386,0.67717),(0.14173,0.67717),(0.14961,0.67717),(0.15748,0.67717),(0.16535,0.67717),(0.17323,0.67717),(0.1811,0.67717),(0.18898,0.67717),(0.19685,0.67717),(0.20472,0.67717),(0.2126,0.67717),(0.22047,0.67717),(0.22835,0.67717),(0.23622,0.67717),(0.24409,0.67717),(0.25197,0.67717),(0.25984,0.67717),(0.26772,0.67717),(0.27559,0.67717),(0.28346,0.67717),(0.29134,0.67717),(0.29921,0.67717),(0.30709,0.67717),(0.31496,0.67717),(0.32283,0.67717),(0.33071,0.67717),(0.33858,0.67717),(0.34646,0.67717),(0.35433,0.67717),(0.3622,0.67717),(0.37008,0.67717),(0.37795,0.67717),(0.38583,0.67717),(0.3937,0.67717),(0.40157,0.67717),(0.40945,0.67717),(0.41732,0.67717),(0.4252,0.67717),(0.43307,0.67717),(0.44094,0.67717),(0.44882,0.67717),(0.45669,0.67717),(0.46457,0.67717),(0.47244,0.67717),(0.48031,0.67717),(0.48819,0.67717),(0.49606,0.67717),(0.50394,0.67717),(0.51181,0.67717),(0.51969,0.67717),(0.52756,0.67717),(0.53543,0.67717),(0.54331,0.67717),(0.55118,0.67717),(0.55906,0.67717),(0.56693,0.67717),(0.5748,0.67717),(0.58268,0.67717),(0.59055,0.67717),(0.59843,0.67717),(0.6063,0.67717),(0.61417,0.67717),(0.62205,0.67717),(0.62992,0.67717),(0.6378,0.67717),(0.64567,0.67717),(0.65354,0.67717),(0.66142,0.67717),(0.66929,0.67717),(0.67717,0.67717),(0.68504,0.67717),(0.69291,0.67717),(0.70079,0.67717),(0.70866,0.67717),(0.71654,0.67717),(0.72441,0.67717),(0.73228,0.67717),(0.74016,0.67717),(0.74803,0.67717),(0.75591,0.67717),(0.76378,0.67717),(0.77165,0.67717),(0.77953,0.67717),(0.7874,0.67717),(0.79528,0.67717),(0.80315,0.67717),(0.81102,0.67717),(0.8189,0.67717),(0.82677,0.67717),(0.83465,0.67717),(0.84252,0.67717),(0.85039,0.67717),(0.85827,0.67717),(0.86614,0.67717),(0.87402,0.67717),(0.88189,0.67717),(0.88976,0.67717),(0.89764,0.67717),(0.90551,0.67717),(0.91339,0.67717),(0.92126,0.67717),(0.92913,0.67717),(0.93701,0.67717),(0.94488,0.67717),(0.95276,0.67717),(0.96063,0.67717),(0.9685,0.67717),(0.97638,0.67717),(0.98425,0.67717),(0.99213,0.67717),(0.99609,0.67717),(0.00391,0.68504),(0.00787,0.68504),(0.01575,0.68504),(0.02362,0.68504),(0.0315,0.68504),(0.03937,0.68504),(0.04724,0.68504),(0.05512,0.68504),(0.06299,0.68504),(0.07087,0.68504),(0.07874,0.68504),(0.08661,0.68504),(0.09449,0.68504),(0.10236,0.68504),(0.11024,0.68504),(0.11811,0.68504),(0.12598,0.68504),(0.13386,0.68504),(0.14173,0.68504),(0.14961,0.68504),(0.15748,0.68504),(0.16535,0.68504),(0.17323,0.68504),(0.1811,0.68504),(0.18898,0.68504),(0.19685,0.68504),(0.20472,0.68504),(0.2126,0.68504),(0.22047,0.68504),(0.22835,0.68504),(0.23622,0.68504),(0.24409,0.68504),(0.25197,0.68504),(0.25984,0.68504),(0.26772,0.68504),(0.27559,0.68504),(0.28346,0.68504),(0.29134,0.68504),(0.29921,0.68504),(0.30709,0.68504),(0.31496,0.68504),(0.32283,0.68504),(0.33071,0.68504),(0.33858,0.68504),(0.34646,0.68504),(0.35433,0.68504),(0.3622,0.68504),(0.37008,0.68504),(0.37795,0.68504),(0.38583,0.68504),(0.3937,0.68504),(0.40157,0.68504),(0.40945,0.68504),(0.41732,0.68504),(0.4252,0.68504),(0.43307,0.68504),(0.44094,0.68504),(0.44882,0.68504),(0.45669,0.68504),(0.46457,0.68504),(0.47244,0.68504),(0.48031,0.68504),(0.48819,0.68504),(0.49606,0.68504),(0.50394,0.68504),(0.51181,0.68504),(0.51969,0.68504),(0.52756,0.68504),(0.53543,0.68504),(0.54331,0.68504),(0.55118,0.68504),(0.55906,0.68504),(0.56693,0.68504),(0.5748,0.68504),(0.58268,0.68504),(0.59055,0.68504),(0.59843,0.68504),(0.6063,0.68504),(0.61417,0.68504),(0.62205,0.68504),(0.62992,0.68504),(0.6378,0.68504),(0.64567,0.68504),(0.65354,0.68504),(0.66142,0.68504),(0.66929,0.68504),(0.67717,0.68504),(0.68504,0.68504),(0.69291,0.68504),(0.70079,0.68504),(0.70866,0.68504),(0.71654,0.68504),(0.72441,0.68504),(0.73228,0.68504),(0.74016,0.68504),(0.74803,0.68504),(0.75591,0.68504),(0.76378,0.68504),(0.77165,0.68504),(0.77953,0.68504),(0.7874,0.68504),(0.79528,0.68504),(0.80315,0.68504),(0.81102,0.68504),(0.8189,0.68504),(0.82677,0.68504),(0.83465,0.68504),(0.84252,0.68504),(0.85039,0.68504),(0.85827,0.68504),(0.86614,0.68504),(0.87402,0.68504),(0.88189,0.68504),(0.88976,0.68504),(0.89764,0.68504),(0.90551,0.68504),(0.91339,0.68504),(0.92126,0.68504),(0.92913,0.68504),(0.93701,0.68504),(0.94488,0.68504),(0.95276,0.68504),(0.96063,0.68504),(0.9685,0.68504),(0.97638,0.68504),(0.98425,0.68504),(0.99213,0.68504),(0.99609,0.68504),(0.00391,0.69291),(0.00787,0.69291),(0.01575,0.69291),(0.02362,0.69291),(0.0315,0.69291),(0.03937,0.69291),(0.04724,0.69291),(0.05512,0.69291),(0.06299,0.69291),(0.07087,0.69291),(0.07874,0.69291),(0.08661,0.69291),(0.09449,0.69291),(0.10236,0.69291),(0.11024,0.69291),(0.11811,0.69291),(0.12598,0.69291),(0.13386,0.69291),(0.14173,0.69291),(0.14961,0.69291),(0.15748,0.69291),(0.16535,0.69291),(0.17323,0.69291),(0.1811,0.69291),(0.18898,0.69291),(0.19685,0.69291),(0.20472,0.69291),(0.2126,0.69291),(0.22047,0.69291),(0.22835,0.69291),(0.23622,0.69291),(0.24409,0.69291),(0.25197,0.69291),(0.25984,0.69291),(0.26772,0.69291),(0.27559,0.69291),(0.28346,0.69291),(0.29134,0.69291),(0.29921,0.69291),(0.30709,0.69291),(0.31496,0.69291),(0.32283,0.69291),(0.33071,0.69291),(0.33858,0.69291),(0.34646,0.69291),(0.35433,0.69291),(0.3622,0.69291),(0.37008,0.69291),(0.37795,0.69291),(0.38583,0.69291),(0.3937,0.69291),(0.40157,0.69291),(0.40945,0.69291),(0.41732,0.69291),(0.4252,0.69291),(0.43307,0.69291),(0.44094,0.69291),(0.44882,0.69291),(0.45669,0.69291),(0.46457,0.69291),(0.47244,0.69291),(0.48031,0.69291),(0.48819,0.69291),(0.49606,0.69291),(0.50394,0.69291),(0.51181,0.69291),(0.51969,0.69291),(0.52756,0.69291),(0.53543,0.69291),(0.54331,0.69291),(0.55118,0.69291),(0.55906,0.69291),(0.56693,0.69291),(0.5748,0.69291),(0.58268,0.69291),(0.59055,0.69291),(0.59843,0.69291),(0.6063,0.69291),(0.61417,0.69291),(0.62205,0.69291),(0.62992,0.69291),(0.6378,0.69291),(0.64567,0.69291),(0.65354,0.69291),(0.66142,0.69291),(0.66929,0.69291),(0.67717,0.69291),(0.68504,0.69291),(0.69291,0.69291),(0.70079,0.69291),(0.70866,0.69291),(0.71654,0.69291),(0.72441,0.69291),(0.73228,0.69291),(0.74016,0.69291),(0.74803,0.69291),(0.75591,0.69291),(0.76378,0.69291),(0.77165,0.69291),(0.77953,0.69291),(0.7874,0.69291),(0.79528,0.69291),(0.80315,0.69291),(0.81102,0.69291),(0.8189,0.69291),(0.82677,0.69291),(0.83465,0.69291),(0.84252,0.69291),(0.85039,0.69291),(0.85827,0.69291),(0.86614,0.69291),(0.87402,0.69291),(0.88189,0.69291),(0.88976,0.69291),(0.89764,0.69291),(0.90551,0.69291),(0.91339,0.69291),(0.92126,0.69291),(0.92913,0.69291),(0.93701,0.69291),(0.94488,0.69291),(0.95276,0.69291),(0.96063,0.69291),(0.9685,0.69291),(0.97638,0.69291),(0.98425,0.69291),(0.99213,0.69291),(0.99609,0.69291),(0.00391,0.70079),(0.00787,0.70079),(0.01575,0.70079),(0.02362,0.70079),(0.0315,0.70079),(0.03937,0.70079),(0.04724,0.70079),(0.05512,0.70079),(0.06299,0.70079),(0.07087,0.70079),(0.07874,0.70079),(0.08661,0.70079),(0.09449,0.70079),(0.10236,0.70079),(0.11024,0.70079),(0.11811,0.70079),(0.12598,0.70079),(0.13386,0.70079),(0.14173,0.70079),(0.14961,0.70079),(0.15748,0.70079),(0.16535,0.70079),(0.17323,0.70079),(0.1811,0.70079),(0.18898,0.70079),(0.19685,0.70079),(0.20472,0.70079),(0.2126,0.70079),(0.22047,0.70079),(0.22835,0.70079),(0.23622,0.70079),(0.24409,0.70079),(0.25197,0.70079),(0.25984,0.70079),(0.26772,0.70079),(0.27559,0.70079),(0.28346,0.70079),(0.29134,0.70079),(0.29921,0.70079),(0.30709,0.70079),(0.31496,0.70079),(0.32283,0.70079),(0.33071,0.70079),(0.33858,0.70079),(0.34646,0.70079),(0.35433,0.70079),(0.3622,0.70079),(0.37008,0.70079),(0.37795,0.70079),(0.38583,0.70079),(0.3937,0.70079),(0.40157,0.70079),(0.40945,0.70079),(0.41732,0.70079),(0.4252,0.70079),(0.43307,0.70079),(0.44094,0.70079),(0.44882,0.70079),(0.45669,0.70079),(0.46457,0.70079),(0.47244,0.70079),(0.48031,0.70079),(0.48819,0.70079),(0.49606,0.70079),(0.50394,0.70079),(0.51181,0.70079),(0.51969,0.70079),(0.52756,0.70079),(0.53543,0.70079),(0.54331,0.70079),(0.55118,0.70079),(0.55906,0.70079),(0.56693,0.70079),(0.5748,0.70079),(0.58268,0.70079),(0.59055,0.70079),(0.59843,0.70079),(0.6063,0.70079),(0.61417,0.70079),(0.62205,0.70079),(0.62992,0.70079),(0.6378,0.70079),(0.64567,0.70079),(0.65354,0.70079),(0.66142,0.70079),(0.66929,0.70079),(0.67717,0.70079),(0.68504,0.70079),(0.69291,0.70079),(0.70079,0.70079),(0.70866,0.70079),(0.71654,0.70079),(0.72441,0.70079),(0.73228,0.70079),(0.74016,0.70079),(0.74803,0.70079),(0.75591,0.70079),(0.76378,0.70079),(0.77165,0.70079),(0.77953,0.70079),(0.7874,0.70079),(0.79528,0.70079),(0.80315,0.70079),(0.81102,0.70079),(0.8189,0.70079),(0.82677,0.70079),(0.83465,0.70079),(0.84252,0.70079),(0.85039,0.70079),(0.85827,0.70079),(0.86614,0.70079),(0.87402,0.70079),(0.88189,0.70079),(0.88976,0.70079),(0.89764,0.70079),(0.90551,0.70079),(0.91339,0.70079),(0.92126,0.70079),(0.92913,0.70079),(0.93701,0.70079),(0.94488,0.70079),(0.95276,0.70079),(0.96063,0.70079),(0.9685,0.70079),(0.97638,0.70079),(0.98425,0.70079),(0.99213,0.70079),(0.99609,0.70079),(0.00391,0.70866),(0.00787,0.70866),(0.01575,0.70866),(0.02362,0.70866),(0.0315,0.70866),(0.03937,0.70866),(0.04724,0.70866),(0.05512,0.70866),(0.06299,0.70866),(0.07087,0.70866),(0.07874,0.70866),(0.08661,0.70866),(0.09449,0.70866),(0.10236,0.70866),(0.11024,0.70866),(0.11811,0.70866),(0.12598,0.70866),(0.13386,0.70866),(0.14173,0.70866),(0.14961,0.70866),(0.15748,0.70866),(0.16535,0.70866),(0.17323,0.70866),(0.1811,0.70866),(0.18898,0.70866),(0.19685,0.70866),(0.20472,0.70866),(0.2126,0.70866),(0.22047,0.70866),(0.22835,0.70866),(0.23622,0.70866),(0.24409,0.70866),(0.25197,0.70866),(0.25984,0.70866),(0.26772,0.70866),(0.27559,0.70866),(0.28346,0.70866),(0.29134,0.70866),(0.29921,0.70866),(0.30709,0.70866),(0.31496,0.70866),(0.32283,0.70866),(0.33071,0.70866),(0.33858,0.70866),(0.34646,0.70866),(0.35433,0.70866),(0.3622,0.70866),(0.37008,0.70866),(0.37795,0.70866),(0.38583,0.70866),(0.3937,0.70866),(0.40157,0.70866),(0.40945,0.70866),(0.41732,0.70866),(0.4252,0.70866),(0.43307,0.70866),(0.44094,0.70866),(0.44882,0.70866),(0.45669,0.70866),(0.46457,0.70866),(0.47244,0.70866),(0.48031,0.70866),(0.48819,0.70866),(0.49606,0.70866),(0.50394,0.70866),(0.51181,0.70866),(0.51969,0.70866),(0.52756,0.70866),(0.53543,0.70866),(0.54331,0.70866),(0.55118,0.70866),(0.55906,0.70866),(0.56693,0.70866),(0.5748,0.70866),(0.58268,0.70866),(0.59055,0.70866),(0.59843,0.70866),(0.6063,0.70866),(0.61417,0.70866),(0.62205,0.70866),(0.62992,0.70866),(0.6378,0.70866),(0.64567,0.70866),(0.65354,0.70866),(0.66142,0.70866),(0.66929,0.70866),(0.67717,0.70866),(0.68504,0.70866),(0.69291,0.70866),(0.70079,0.70866),(0.70866,0.70866),(0.71654,0.70866),(0.72441,0.70866),(0.73228,0.70866),(0.74016,0.70866),(0.74803,0.70866),(0.75591,0.70866),(0.76378,0.70866),(0.77165,0.70866),(0.77953,0.70866),(0.7874,0.70866),(0.79528,0.70866),(0.80315,0.70866),(0.81102,0.70866),(0.8189,0.70866),(0.82677,0.70866),(0.83465,0.70866),(0.84252,0.70866),(0.85039,0.70866),(0.85827,0.70866),(0.86614,0.70866),(0.87402,0.70866),(0.88189,0.70866),(0.88976,0.70866),(0.89764,0.70866),(0.90551,0.70866),(0.91339,0.70866),(0.92126,0.70866),(0.92913,0.70866),(0.93701,0.70866),(0.94488,0.70866),(0.95276,0.70866),(0.96063,0.70866),(0.9685,0.70866),(0.97638,0.70866),(0.98425,0.70866),(0.99213,0.70866),(0.99609,0.70866),(0.00391,0.71654),(0.00787,0.71654),(0.01575,0.71654),(0.02362,0.71654),(0.0315,0.71654),(0.03937,0.71654),(0.04724,0.71654),(0.05512,0.71654),(0.06299,0.71654),(0.07087,0.71654),(0.07874,0.71654),(0.08661,0.71654),(0.09449,0.71654),(0.10236,0.71654),(0.11024,0.71654),(0.11811,0.71654),(0.12598,0.71654),(0.13386,0.71654),(0.14173,0.71654),(0.14961,0.71654),(0.15748,0.71654),(0.16535,0.71654),(0.17323,0.71654),(0.1811,0.71654),(0.18898,0.71654),(0.19685,0.71654),(0.20472,0.71654),(0.2126,0.71654),(0.22047,0.71654),(0.22835,0.71654),(0.23622,0.71654),(0.24409,0.71654),(0.25197,0.71654),(0.25984,0.71654),(0.26772,0.71654),(0.27559,0.71654),(0.28346,0.71654),(0.29134,0.71654),(0.29921,0.71654),(0.30709,0.71654),(0.31496,0.71654),(0.32283,0.71654),(0.33071,0.71654),(0.33858,0.71654),(0.34646,0.71654),(0.35433,0.71654),(0.3622,0.71654),(0.37008,0.71654),(0.37795,0.71654),(0.38583,0.71654),(0.3937,0.71654),(0.40157,0.71654),(0.40945,0.71654),(0.41732,0.71654),(0.4252,0.71654),(0.43307,0.71654),(0.44094,0.71654),(0.44882,0.71654),(0.45669,0.71654),(0.46457,0.71654),(0.47244,0.71654),(0.48031,0.71654),(0.48819,0.71654),(0.49606,0.71654),(0.50394,0.71654),(0.51181,0.71654),(0.51969,0.71654),(0.52756,0.71654),(0.53543,0.71654),(0.54331,0.71654),(0.55118,0.71654),(0.55906,0.71654),(0.56693,0.71654),(0.5748,0.71654),(0.58268,0.71654),(0.59055,0.71654),(0.59843,0.71654),(0.6063,0.71654),(0.61417,0.71654),(0.62205,0.71654),(0.62992,0.71654),(0.6378,0.71654),(0.64567,0.71654),(0.65354,0.71654),(0.66142,0.71654),(0.66929,0.71654),(0.67717,0.71654),(0.68504,0.71654),(0.69291,0.71654),(0.70079,0.71654),(0.70866,0.71654),(0.71654,0.71654),(0.72441,0.71654),(0.73228,0.71654),(0.74016,0.71654),(0.74803,0.71654),(0.75591,0.71654),(0.76378,0.71654),(0.77165,0.71654),(0.77953,0.71654),(0.7874,0.71654),(0.79528,0.71654),(0.80315,0.71654),(0.81102,0.71654),(0.8189,0.71654),(0.82677,0.71654),(0.83465,0.71654),(0.84252,0.71654),(0.85039,0.71654),(0.85827,0.71654),(0.86614,0.71654),(0.87402,0.71654),(0.88189,0.71654),(0.88976,0.71654),(0.89764,0.71654),(0.90551,0.71654),(0.91339,0.71654),(0.92126,0.71654),(0.92913,0.71654),(0.93701,0.71654),(0.94488,0.71654),(0.95276,0.71654),(0.96063,0.71654),(0.9685,0.71654),(0.97638,0.71654),(0.98425,0.71654),(0.99213,0.71654),(0.99609,0.71654),(0.00391,0.72441),(0.00787,0.72441),(0.01575,0.72441),(0.02362,0.72441),(0.0315,0.72441),(0.03937,0.72441),(0.04724,0.72441),(0.05512,0.72441),(0.06299,0.72441),(0.07087,0.72441),(0.07874,0.72441),(0.08661,0.72441),(0.09449,0.72441),(0.10236,0.72441),(0.11024,0.72441),(0.11811,0.72441),(0.12598,0.72441),(0.13386,0.72441),(0.14173,0.72441),(0.14961,0.72441),(0.15748,0.72441),(0.16535,0.72441),(0.17323,0.72441),(0.1811,0.72441),(0.18898,0.72441),(0.19685,0.72441),(0.20472,0.72441),(0.2126,0.72441),(0.22047,0.72441),(0.22835,0.72441),(0.23622,0.72441),(0.24409,0.72441),(0.25197,0.72441),(0.25984,0.72441),(0.26772,0.72441),(0.27559,0.72441),(0.28346,0.72441),(0.29134,0.72441),(0.29921,0.72441),(0.30709,0.72441),(0.31496,0.72441),(0.32283,0.72441),(0.33071,0.72441),(0.33858,0.72441),(0.34646,0.72441),(0.35433,0.72441),(0.3622,0.72441),(0.37008,0.72441),(0.37795,0.72441),(0.38583,0.72441),(0.3937,0.72441),(0.40157,0.72441),(0.40945,0.72441),(0.41732,0.72441),(0.4252,0.72441),(0.43307,0.72441),(0.44094,0.72441),(0.44882,0.72441),(0.45669,0.72441),(0.46457,0.72441),(0.47244,0.72441),(0.48031,0.72441),(0.48819,0.72441),(0.49606,0.72441),(0.50394,0.72441),(0.51181,0.72441),(0.51969,0.72441),(0.52756,0.72441),(0.53543,0.72441),(0.54331,0.72441),(0.55118,0.72441),(0.55906,0.72441),(0.56693,0.72441),(0.5748,0.72441),(0.58268,0.72441),(0.59055,0.72441),(0.59843,0.72441),(0.6063,0.72441),(0.61417,0.72441),(0.62205,0.72441),(0.62992,0.72441),(0.6378,0.72441),(0.64567,0.72441),(0.65354,0.72441),(0.66142,0.72441),(0.66929,0.72441),(0.67717,0.72441),(0.68504,0.72441),(0.69291,0.72441),(0.70079,0.72441),(0.70866,0.72441),(0.71654,0.72441),(0.72441,0.72441),(0.73228,0.72441),(0.74016,0.72441),(0.74803,0.72441),(0.75591,0.72441),(0.76378,0.72441),(0.77165,0.72441),(0.77953,0.72441),(0.7874,0.72441),(0.79528,0.72441),(0.80315,0.72441),(0.81102,0.72441),(0.8189,0.72441),(0.82677,0.72441),(0.83465,0.72441),(0.84252,0.72441),(0.85039,0.72441),(0.85827,0.72441),(0.86614,0.72441),(0.87402,0.72441),(0.88189,0.72441),(0.88976,0.72441),(0.89764,0.72441),(0.90551,0.72441),(0.91339,0.72441),(0.92126,0.72441),(0.92913,0.72441),(0.93701,0.72441),(0.94488,0.72441),(0.95276,0.72441),(0.96063,0.72441),(0.9685,0.72441),(0.97638,0.72441),(0.98425,0.72441),(0.99213,0.72441),(0.99609,0.72441),(0.00391,0.73228),(0.00787,0.73228),(0.01575,0.73228),(0.02362,0.73228),(0.0315,0.73228),(0.03937,0.73228),(0.04724,0.73228),(0.05512,0.73228),(0.06299,0.73228),(0.07087,0.73228),(0.07874,0.73228),(0.08661,0.73228),(0.09449,0.73228),(0.10236,0.73228),(0.11024,0.73228),(0.11811,0.73228),(0.12598,0.73228),(0.13386,0.73228),(0.14173,0.73228),(0.14961,0.73228),(0.15748,0.73228),(0.16535,0.73228),(0.17323,0.73228),(0.1811,0.73228),(0.18898,0.73228),(0.19685,0.73228),(0.20472,0.73228),(0.2126,0.73228),(0.22047,0.73228),(0.22835,0.73228),(0.23622,0.73228),(0.24409,0.73228),(0.25197,0.73228),(0.25984,0.73228),(0.26772,0.73228),(0.27559,0.73228),(0.28346,0.73228),(0.29134,0.73228),(0.29921,0.73228),(0.30709,0.73228),(0.31496,0.73228),(0.32283,0.73228),(0.33071,0.73228),(0.33858,0.73228),(0.34646,0.73228),(0.35433,0.73228),(0.3622,0.73228),(0.37008,0.73228),(0.37795,0.73228),(0.38583,0.73228),(0.3937,0.73228),(0.40157,0.73228),(0.40945,0.73228),(0.41732,0.73228),(0.4252,0.73228),(0.43307,0.73228),(0.44094,0.73228),(0.44882,0.73228),(0.45669,0.73228),(0.46457,0.73228),(0.47244,0.73228),(0.48031,0.73228),(0.48819,0.73228),(0.49606,0.73228),(0.50394,0.73228),(0.51181,0.73228),(0.51969,0.73228),(0.52756,0.73228),(0.53543,0.73228),(0.54331,0.73228),(0.55118,0.73228),(0.55906,0.73228),(0.56693,0.73228),(0.5748,0.73228),(0.58268,0.73228),(0.59055,0.73228),(0.59843,0.73228),(0.6063,0.73228),(0.61417,0.73228),(0.62205,0.73228),(0.62992,0.73228),(0.6378,0.73228),(0.64567,0.73228),(0.65354,0.73228),(0.66142,0.73228),(0.66929,0.73228),(0.67717,0.73228),(0.68504,0.73228),(0.69291,0.73228),(0.70079,0.73228),(0.70866,0.73228),(0.71654,0.73228),(0.72441,0.73228),(0.73228,0.73228),(0.74016,0.73228),(0.74803,0.73228),(0.75591,0.73228),(0.76378,0.73228),(0.77165,0.73228),(0.77953,0.73228),(0.7874,0.73228),(0.79528,0.73228),(0.80315,0.73228),(0.81102,0.73228),(0.8189,0.73228),(0.82677,0.73228),(0.83465,0.73228),(0.84252,0.73228),(0.85039,0.73228),(0.85827,0.73228),(0.86614,0.73228),(0.87402,0.73228),(0.88189,0.73228),(0.88976,0.73228),(0.89764,0.73228),(0.90551,0.73228),(0.91339,0.73228),(0.92126,0.73228),(0.92913,0.73228),(0.93701,0.73228),(0.94488,0.73228),(0.95276,0.73228),(0.96063,0.73228),(0.9685,0.73228),(0.97638,0.73228),(0.98425,0.73228),(0.99213,0.73228),(0.99609,0.73228),(0.00391,0.74016),(0.00787,0.74016),(0.01575,0.74016),(0.02362,0.74016),(0.0315,0.74016),(0.03937,0.74016),(0.04724,0.74016),(0.05512,0.74016),(0.06299,0.74016),(0.07087,0.74016),(0.07874,0.74016),(0.08661,0.74016),(0.09449,0.74016),(0.10236,0.74016),(0.11024,0.74016),(0.11811,0.74016),(0.12598,0.74016),(0.13386,0.74016),(0.14173,0.74016),(0.14961,0.74016),(0.15748,0.74016),(0.16535,0.74016),(0.17323,0.74016),(0.1811,0.74016),(0.18898,0.74016),(0.19685,0.74016),(0.20472,0.74016),(0.2126,0.74016),(0.22047,0.74016),(0.22835,0.74016),(0.23622,0.74016),(0.24409,0.74016),(0.25197,0.74016),(0.25984,0.74016),(0.26772,0.74016),(0.27559,0.74016),(0.28346,0.74016),(0.29134,0.74016),(0.29921,0.74016),(0.30709,0.74016),(0.31496,0.74016),(0.32283,0.74016),(0.33071,0.74016),(0.33858,0.74016),(0.34646,0.74016),(0.35433,0.74016),(0.3622,0.74016),(0.37008,0.74016),(0.37795,0.74016),(0.38583,0.74016),(0.3937,0.74016),(0.40157,0.74016),(0.40945,0.74016),(0.41732,0.74016),(0.4252,0.74016),(0.43307,0.74016),(0.44094,0.74016),(0.44882,0.74016),(0.45669,0.74016),(0.46457,0.74016),(0.47244,0.74016),(0.48031,0.74016),(0.48819,0.74016),(0.49606,0.74016),(0.50394,0.74016),(0.51181,0.74016),(0.51969,0.74016),(0.52756,0.74016),(0.53543,0.74016),(0.54331,0.74016),(0.55118,0.74016),(0.55906,0.74016),(0.56693,0.74016),(0.5748,0.74016),(0.58268,0.74016),(0.59055,0.74016),(0.59843,0.74016),(0.6063,0.74016),(0.61417,0.74016),(0.62205,0.74016),(0.62992,0.74016),(0.6378,0.74016),(0.64567,0.74016),(0.65354,0.74016),(0.66142,0.74016),(0.66929,0.74016),(0.67717,0.74016),(0.68504,0.74016),(0.69291,0.74016),(0.70079,0.74016),(0.70866,0.74016),(0.71654,0.74016),(0.72441,0.74016),(0.73228,0.74016),(0.74016,0.74016),(0.74803,0.74016),(0.75591,0.74016),(0.76378,0.74016),(0.77165,0.74016),(0.77953,0.74016),(0.7874,0.74016),(0.79528,0.74016),(0.80315,0.74016),(0.81102,0.74016),(0.8189,0.74016),(0.82677,0.74016),(0.83465,0.74016),(0.84252,0.74016),(0.85039,0.74016),(0.85827,0.74016),(0.86614,0.74016),(0.87402,0.74016),(0.88189,0.74016),(0.88976,0.74016),(0.89764,0.74016),(0.90551,0.74016),(0.91339,0.74016),(0.92126,0.74016),(0.92913,0.74016),(0.93701,0.74016),(0.94488,0.74016),(0.95276,0.74016),(0.96063,0.74016),(0.9685,0.74016),(0.97638,0.74016),(0.98425,0.74016),(0.99213,0.74016),(0.99609,0.74016),(0.00391,0.74803),(0.00787,0.74803),(0.01575,0.74803),(0.02362,0.74803),(0.0315,0.74803),(0.03937,0.74803),(0.04724,0.74803),(0.05512,0.74803),(0.06299,0.74803),(0.07087,0.74803),(0.07874,0.74803),(0.08661,0.74803),(0.09449,0.74803),(0.10236,0.74803),(0.11024,0.74803),(0.11811,0.74803),(0.12598,0.74803),(0.13386,0.74803),(0.14173,0.74803),(0.14961,0.74803),(0.15748,0.74803),(0.16535,0.74803),(0.17323,0.74803),(0.1811,0.74803),(0.18898,0.74803),(0.19685,0.74803),(0.20472,0.74803),(0.2126,0.74803),(0.22047,0.74803),(0.22835,0.74803),(0.23622,0.74803),(0.24409,0.74803),(0.25197,0.74803),(0.25984,0.74803),(0.26772,0.74803),(0.27559,0.74803),(0.28346,0.74803),(0.29134,0.74803),(0.29921,0.74803),(0.30709,0.74803),(0.31496,0.74803),(0.32283,0.74803),(0.33071,0.74803),(0.33858,0.74803),(0.34646,0.74803),(0.35433,0.74803),(0.3622,0.74803),(0.37008,0.74803),(0.37795,0.74803),(0.38583,0.74803),(0.3937,0.74803),(0.40157,0.74803),(0.40945,0.74803),(0.41732,0.74803),(0.4252,0.74803),(0.43307,0.74803),(0.44094,0.74803),(0.44882,0.74803),(0.45669,0.74803),(0.46457,0.74803),(0.47244,0.74803),(0.48031,0.74803),(0.48819,0.74803),(0.49606,0.74803),(0.50394,0.74803),(0.51181,0.74803),(0.51969,0.74803),(0.52756,0.74803),(0.53543,0.74803),(0.54331,0.74803),(0.55118,0.74803),(0.55906,0.74803),(0.56693,0.74803),(0.5748,0.74803),(0.58268,0.74803),(0.59055,0.74803),(0.59843,0.74803),(0.6063,0.74803),(0.61417,0.74803),(0.62205,0.74803),(0.62992,0.74803),(0.6378,0.74803),(0.64567,0.74803),(0.65354,0.74803),(0.66142,0.74803),(0.66929,0.74803),(0.67717,0.74803),(0.68504,0.74803),(0.69291,0.74803),(0.70079,0.74803),(0.70866,0.74803),(0.71654,0.74803),(0.72441,0.74803),(0.73228,0.74803),(0.74016,0.74803),(0.74803,0.74803),(0.75591,0.74803),(0.76378,0.74803),(0.77165,0.74803),(0.77953,0.74803),(0.7874,0.74803),(0.79528,0.74803),(0.80315,0.74803),(0.81102,0.74803),(0.8189,0.74803),(0.82677,0.74803),(0.83465,0.74803),(0.84252,0.74803),(0.85039,0.74803),(0.85827,0.74803),(0.86614,0.74803),(0.87402,0.74803),(0.88189,0.74803),(0.88976,0.74803),(0.89764,0.74803),(0.90551,0.74803),(0.91339,0.74803),(0.92126,0.74803),(0.92913,0.74803),(0.93701,0.74803),(0.94488,0.74803),(0.95276,0.74803),(0.96063,0.74803),(0.9685,0.74803),(0.97638,0.74803),(0.98425,0.74803),(0.99213,0.74803),(0.99609,0.74803),(0.00391,0.75591),(0.00787,0.75591),(0.01575,0.75591),(0.02362,0.75591),(0.0315,0.75591),(0.03937,0.75591),(0.04724,0.75591),(0.05512,0.75591),(0.06299,0.75591),(0.07087,0.75591),(0.07874,0.75591),(0.08661,0.75591),(0.09449,0.75591),(0.10236,0.75591),(0.11024,0.75591),(0.11811,0.75591),(0.12598,0.75591),(0.13386,0.75591),(0.14173,0.75591),(0.14961,0.75591),(0.15748,0.75591),(0.16535,0.75591),(0.17323,0.75591),(0.1811,0.75591),(0.18898,0.75591),(0.19685,0.75591),(0.20472,0.75591),(0.2126,0.75591),(0.22047,0.75591),(0.22835,0.75591),(0.23622,0.75591),(0.24409,0.75591),(0.25197,0.75591),(0.25984,0.75591),(0.26772,0.75591),(0.27559,0.75591),(0.28346,0.75591),(0.29134,0.75591),(0.29921,0.75591),(0.30709,0.75591),(0.31496,0.75591),(0.32283,0.75591),(0.33071,0.75591),(0.33858,0.75591),(0.34646,0.75591),(0.35433,0.75591),(0.3622,0.75591),(0.37008,0.75591),(0.37795,0.75591),(0.38583,0.75591),(0.3937,0.75591),(0.40157,0.75591),(0.40945,0.75591),(0.41732,0.75591),(0.4252,0.75591),(0.43307,0.75591),(0.44094,0.75591),(0.44882,0.75591),(0.45669,0.75591),(0.46457,0.75591),(0.47244,0.75591),(0.48031,0.75591),(0.48819,0.75591),(0.49606,0.75591),(0.50394,0.75591),(0.51181,0.75591),(0.51969,0.75591),(0.52756,0.75591),(0.53543,0.75591),(0.54331,0.75591),(0.55118,0.75591),(0.55906,0.75591),(0.56693,0.75591),(0.5748,0.75591),(0.58268,0.75591),(0.59055,0.75591),(0.59843,0.75591),(0.6063,0.75591),(0.61417,0.75591),(0.62205,0.75591),(0.62992,0.75591),(0.6378,0.75591),(0.64567,0.75591),(0.65354,0.75591),(0.66142,0.75591),(0.66929,0.75591),(0.67717,0.75591),(0.68504,0.75591),(0.69291,0.75591),(0.70079,0.75591),(0.70866,0.75591),(0.71654,0.75591),(0.72441,0.75591),(0.73228,0.75591),(0.74016,0.75591),(0.74803,0.75591),(0.75591,0.75591),(0.76378,0.75591),(0.77165,0.75591),(0.77953,0.75591),(0.7874,0.75591),(0.79528,0.75591),(0.80315,0.75591),(0.81102,0.75591),(0.8189,0.75591),(0.82677,0.75591),(0.83465,0.75591),(0.84252,0.75591),(0.85039,0.75591),(0.85827,0.75591),(0.86614,0.75591),(0.87402,0.75591),(0.88189,0.75591),(0.88976,0.75591),(0.89764,0.75591),(0.90551,0.75591),(0.91339,0.75591),(0.92126,0.75591),(0.92913,0.75591),(0.93701,0.75591),(0.94488,0.75591),(0.95276,0.75591),(0.96063,0.75591),(0.9685,0.75591),(0.97638,0.75591),(0.98425,0.75591),(0.99213,0.75591),(0.99609,0.75591),(0.00391,0.76378),(0.00787,0.76378),(0.01575,0.76378),(0.02362,0.76378),(0.0315,0.76378),(0.03937,0.76378),(0.04724,0.76378),(0.05512,0.76378),(0.06299,0.76378),(0.07087,0.76378),(0.07874,0.76378),(0.08661,0.76378),(0.09449,0.76378),(0.10236,0.76378),(0.11024,0.76378),(0.11811,0.76378),(0.12598,0.76378),(0.13386,0.76378),(0.14173,0.76378),(0.14961,0.76378),(0.15748,0.76378),(0.16535,0.76378),(0.17323,0.76378),(0.1811,0.76378),(0.18898,0.76378),(0.19685,0.76378),(0.20472,0.76378),(0.2126,0.76378),(0.22047,0.76378),(0.22835,0.76378),(0.23622,0.76378),(0.24409,0.76378),(0.25197,0.76378),(0.25984,0.76378),(0.26772,0.76378),(0.27559,0.76378),(0.28346,0.76378),(0.29134,0.76378),(0.29921,0.76378),(0.30709,0.76378),(0.31496,0.76378),(0.32283,0.76378),(0.33071,0.76378),(0.33858,0.76378),(0.34646,0.76378),(0.35433,0.76378),(0.3622,0.76378),(0.37008,0.76378),(0.37795,0.76378),(0.38583,0.76378),(0.3937,0.76378),(0.40157,0.76378),(0.40945,0.76378),(0.41732,0.76378),(0.4252,0.76378),(0.43307,0.76378),(0.44094,0.76378),(0.44882,0.76378),(0.45669,0.76378),(0.46457,0.76378),(0.47244,0.76378),(0.48031,0.76378),(0.48819,0.76378),(0.49606,0.76378),(0.50394,0.76378),(0.51181,0.76378),(0.51969,0.76378),(0.52756,0.76378),(0.53543,0.76378),(0.54331,0.76378),(0.55118,0.76378),(0.55906,0.76378),(0.56693,0.76378),(0.5748,0.76378),(0.58268,0.76378),(0.59055,0.76378),(0.59843,0.76378),(0.6063,0.76378),(0.61417,0.76378),(0.62205,0.76378),(0.62992,0.76378),(0.6378,0.76378),(0.64567,0.76378),(0.65354,0.76378),(0.66142,0.76378),(0.66929,0.76378),(0.67717,0.76378),(0.68504,0.76378),(0.69291,0.76378),(0.70079,0.76378),(0.70866,0.76378),(0.71654,0.76378),(0.72441,0.76378),(0.73228,0.76378),(0.74016,0.76378),(0.74803,0.76378),(0.75591,0.76378),(0.76378,0.76378),(0.77165,0.76378),(0.77953,0.76378),(0.7874,0.76378),(0.79528,0.76378),(0.80315,0.76378),(0.81102,0.76378),(0.8189,0.76378),(0.82677,0.76378),(0.83465,0.76378),(0.84252,0.76378),(0.85039,0.76378),(0.85827,0.76378),(0.86614,0.76378),(0.87402,0.76378),(0.88189,0.76378),(0.88976,0.76378),(0.89764,0.76378),(0.90551,0.76378),(0.91339,0.76378),(0.92126,0.76378),(0.92913,0.76378),(0.93701,0.76378),(0.94488,0.76378),(0.95276,0.76378),(0.96063,0.76378),(0.9685,0.76378),(0.97638,0.76378),(0.98425,0.76378),(0.99213,0.76378),(0.99609,0.76378),(0.00391,0.77165),(0.00787,0.77165),(0.01575,0.77165),(0.02362,0.77165),(0.0315,0.77165),(0.03937,0.77165),(0.04724,0.77165),(0.05512,0.77165),(0.06299,0.77165),(0.07087,0.77165),(0.07874,0.77165),(0.08661,0.77165),(0.09449,0.77165),(0.10236,0.77165),(0.11024,0.77165),(0.11811,0.77165),(0.12598,0.77165),(0.13386,0.77165),(0.14173,0.77165),(0.14961,0.77165),(0.15748,0.77165),(0.16535,0.77165),(0.17323,0.77165),(0.1811,0.77165),(0.18898,0.77165),(0.19685,0.77165),(0.20472,0.77165),(0.2126,0.77165),(0.22047,0.77165),(0.22835,0.77165),(0.23622,0.77165),(0.24409,0.77165),(0.25197,0.77165),(0.25984,0.77165),(0.26772,0.77165),(0.27559,0.77165),(0.28346,0.77165),(0.29134,0.77165),(0.29921,0.77165),(0.30709,0.77165),(0.31496,0.77165),(0.32283,0.77165),(0.33071,0.77165),(0.33858,0.77165),(0.34646,0.77165),(0.35433,0.77165),(0.3622,0.77165),(0.37008,0.77165),(0.37795,0.77165),(0.38583,0.77165),(0.3937,0.77165),(0.40157,0.77165),(0.40945,0.77165),(0.41732,0.77165),(0.4252,0.77165),(0.43307,0.77165),(0.44094,0.77165),(0.44882,0.77165),(0.45669,0.77165),(0.46457,0.77165),(0.47244,0.77165),(0.48031,0.77165),(0.48819,0.77165),(0.49606,0.77165),(0.50394,0.77165),(0.51181,0.77165),(0.51969,0.77165),(0.52756,0.77165),(0.53543,0.77165),(0.54331,0.77165),(0.55118,0.77165),(0.55906,0.77165),(0.56693,0.77165),(0.5748,0.77165),(0.58268,0.77165),(0.59055,0.77165),(0.59843,0.77165),(0.6063,0.77165),(0.61417,0.77165),(0.62205,0.77165),(0.62992,0.77165),(0.6378,0.77165),(0.64567,0.77165),(0.65354,0.77165),(0.66142,0.77165),(0.66929,0.77165),(0.67717,0.77165),(0.68504,0.77165),(0.69291,0.77165),(0.70079,0.77165),(0.70866,0.77165),(0.71654,0.77165),(0.72441,0.77165),(0.73228,0.77165),(0.74016,0.77165),(0.74803,0.77165),(0.75591,0.77165),(0.76378,0.77165),(0.77165,0.77165),(0.77953,0.77165),(0.7874,0.77165),(0.79528,0.77165),(0.80315,0.77165),(0.81102,0.77165),(0.8189,0.77165),(0.82677,0.77165),(0.83465,0.77165),(0.84252,0.77165),(0.85039,0.77165),(0.85827,0.77165),(0.86614,0.77165),(0.87402,0.77165),(0.88189,0.77165),(0.88976,0.77165),(0.89764,0.77165),(0.90551,0.77165),(0.91339,0.77165),(0.92126,0.77165),(0.92913,0.77165),(0.93701,0.77165),(0.94488,0.77165),(0.95276,0.77165),(0.96063,0.77165),(0.9685,0.77165),(0.97638,0.77165),(0.98425,0.77165),(0.99213,0.77165),(0.99609,0.77165),(0.00391,0.77953),(0.00787,0.77953),(0.01575,0.77953),(0.02362,0.77953),(0.0315,0.77953),(0.03937,0.77953),(0.04724,0.77953),(0.05512,0.77953),(0.06299,0.77953),(0.07087,0.77953),(0.07874,0.77953),(0.08661,0.77953),(0.09449,0.77953),(0.10236,0.77953),(0.11024,0.77953),(0.11811,0.77953),(0.12598,0.77953),(0.13386,0.77953),(0.14173,0.77953),(0.14961,0.77953),(0.15748,0.77953),(0.16535,0.77953),(0.17323,0.77953),(0.1811,0.77953),(0.18898,0.77953),(0.19685,0.77953),(0.20472,0.77953),(0.2126,0.77953),(0.22047,0.77953),(0.22835,0.77953),(0.23622,0.77953),(0.24409,0.77953),(0.25197,0.77953),(0.25984,0.77953),(0.26772,0.77953),(0.27559,0.77953),(0.28346,0.77953),(0.29134,0.77953),(0.29921,0.77953),(0.30709,0.77953),(0.31496,0.77953),(0.32283,0.77953),(0.33071,0.77953),(0.33858,0.77953),(0.34646,0.77953),(0.35433,0.77953),(0.3622,0.77953),(0.37008,0.77953),(0.37795,0.77953),(0.38583,0.77953),(0.3937,0.77953),(0.40157,0.77953),(0.40945,0.77953),(0.41732,0.77953),(0.4252,0.77953),(0.43307,0.77953),(0.44094,0.77953),(0.44882,0.77953),(0.45669,0.77953),(0.46457,0.77953),(0.47244,0.77953),(0.48031,0.77953),(0.48819,0.77953),(0.49606,0.77953),(0.50394,0.77953),(0.51181,0.77953),(0.51969,0.77953),(0.52756,0.77953),(0.53543,0.77953),(0.54331,0.77953),(0.55118,0.77953),(0.55906,0.77953),(0.56693,0.77953),(0.5748,0.77953),(0.58268,0.77953),(0.59055,0.77953),(0.59843,0.77953),(0.6063,0.77953),(0.61417,0.77953),(0.62205,0.77953),(0.62992,0.77953),(0.6378,0.77953),(0.64567,0.77953),(0.65354,0.77953),(0.66142,0.77953),(0.66929,0.77953),(0.67717,0.77953),(0.68504,0.77953),(0.69291,0.77953),(0.70079,0.77953),(0.70866,0.77953),(0.71654,0.77953),(0.72441,0.77953),(0.73228,0.77953),(0.74016,0.77953),(0.74803,0.77953),(0.75591,0.77953),(0.76378,0.77953),(0.77165,0.77953),(0.77953,0.77953),(0.7874,0.77953),(0.79528,0.77953),(0.80315,0.77953),(0.81102,0.77953),(0.8189,0.77953),(0.82677,0.77953),(0.83465,0.77953),(0.84252,0.77953),(0.85039,0.77953),(0.85827,0.77953),(0.86614,0.77953),(0.87402,0.77953),(0.88189,0.77953),(0.88976,0.77953),(0.89764,0.77953),(0.90551,0.77953),(0.91339,0.77953),(0.92126,0.77953),(0.92913,0.77953),(0.93701,0.77953),(0.94488,0.77953),(0.95276,0.77953),(0.96063,0.77953),(0.9685,0.77953),(0.97638,0.77953),(0.98425,0.77953),(0.99213,0.77953),(0.99609,0.77953),(0.00391,0.7874),(0.00787,0.7874),(0.01575,0.7874),(0.02362,0.7874),(0.0315,0.7874),(0.03937,0.7874),(0.04724,0.7874),(0.05512,0.7874),(0.06299,0.7874),(0.07087,0.7874),(0.07874,0.7874),(0.08661,0.7874),(0.09449,0.7874),(0.10236,0.7874),(0.11024,0.7874),(0.11811,0.7874),(0.12598,0.7874),(0.13386,0.7874),(0.14173,0.7874),(0.14961,0.7874),(0.15748,0.7874),(0.16535,0.7874),(0.17323,0.7874),(0.1811,0.7874),(0.18898,0.7874),(0.19685,0.7874),(0.20472,0.7874),(0.2126,0.7874),(0.22047,0.7874),(0.22835,0.7874),(0.23622,0.7874),(0.24409,0.7874),(0.25197,0.7874),(0.25984,0.7874),(0.26772,0.7874),(0.27559,0.7874),(0.28346,0.7874),(0.29134,0.7874),(0.29921,0.7874),(0.30709,0.7874),(0.31496,0.7874),(0.32283,0.7874),(0.33071,0.7874),(0.33858,0.7874),(0.34646,0.7874),(0.35433,0.7874),(0.3622,0.7874),(0.37008,0.7874),(0.37795,0.7874),(0.38583,0.7874),(0.3937,0.7874),(0.40157,0.7874),(0.40945,0.7874),(0.41732,0.7874),(0.4252,0.7874),(0.43307,0.7874),(0.44094,0.7874),(0.44882,0.7874),(0.45669,0.7874),(0.46457,0.7874),(0.47244,0.7874),(0.48031,0.7874),(0.48819,0.7874),(0.49606,0.7874),(0.50394,0.7874),(0.51181,0.7874),(0.51969,0.7874),(0.52756,0.7874),(0.53543,0.7874),(0.54331,0.7874),(0.55118,0.7874),(0.55906,0.7874),(0.56693,0.7874),(0.5748,0.7874),(0.58268,0.7874),(0.59055,0.7874),(0.59843,0.7874),(0.6063,0.7874),(0.61417,0.7874),(0.62205,0.7874),(0.62992,0.7874),(0.6378,0.7874),(0.64567,0.7874),(0.65354,0.7874),(0.66142,0.7874),(0.66929,0.7874),(0.67717,0.7874),(0.68504,0.7874),(0.69291,0.7874),(0.70079,0.7874),(0.70866,0.7874),(0.71654,0.7874),(0.72441,0.7874),(0.73228,0.7874),(0.74016,0.7874),(0.74803,0.7874),(0.75591,0.7874),(0.76378,0.7874),(0.77165,0.7874),(0.77953,0.7874),(0.7874,0.7874),(0.79528,0.7874),(0.80315,0.7874),(0.81102,0.7874),(0.8189,0.7874),(0.82677,0.7874),(0.83465,0.7874),(0.84252,0.7874),(0.85039,0.7874),(0.85827,0.7874),(0.86614,0.7874),(0.87402,0.7874),(0.88189,0.7874),(0.88976,0.7874),(0.89764,0.7874),(0.90551,0.7874),(0.91339,0.7874),(0.92126,0.7874),(0.92913,0.7874),(0.93701,0.7874),(0.94488,0.7874),(0.95276,0.7874),(0.96063,0.7874),(0.9685,0.7874),(0.97638,0.7874),(0.98425,0.7874),(0.99213,0.7874),(0.99609,0.7874),(0.00391,0.79528),(0.00787,0.79528),(0.01575,0.79528),(0.02362,0.79528),(0.0315,0.79528),(0.03937,0.79528),(0.04724,0.79528),(0.05512,0.79528),(0.06299,0.79528),(0.07087,0.79528),(0.07874,0.79528),(0.08661,0.79528),(0.09449,0.79528),(0.10236,0.79528),(0.11024,0.79528),(0.11811,0.79528),(0.12598,0.79528),(0.13386,0.79528),(0.14173,0.79528),(0.14961,0.79528),(0.15748,0.79528),(0.16535,0.79528),(0.17323,0.79528),(0.1811,0.79528),(0.18898,0.79528),(0.19685,0.79528),(0.20472,0.79528),(0.2126,0.79528),(0.22047,0.79528),(0.22835,0.79528),(0.23622,0.79528),(0.24409,0.79528),(0.25197,0.79528),(0.25984,0.79528),(0.26772,0.79528),(0.27559,0.79528),(0.28346,0.79528),(0.29134,0.79528),(0.29921,0.79528),(0.30709,0.79528),(0.31496,0.79528),(0.32283,0.79528),(0.33071,0.79528),(0.33858,0.79528),(0.34646,0.79528),(0.35433,0.79528),(0.3622,0.79528),(0.37008,0.79528),(0.37795,0.79528),(0.38583,0.79528),(0.3937,0.79528),(0.40157,0.79528),(0.40945,0.79528),(0.41732,0.79528),(0.4252,0.79528),(0.43307,0.79528),(0.44094,0.79528),(0.44882,0.79528),(0.45669,0.79528),(0.46457,0.79528),(0.47244,0.79528),(0.48031,0.79528),(0.48819,0.79528),(0.49606,0.79528),(0.50394,0.79528),(0.51181,0.79528),(0.51969,0.79528),(0.52756,0.79528),(0.53543,0.79528),(0.54331,0.79528),(0.55118,0.79528),(0.55906,0.79528),(0.56693,0.79528),(0.5748,0.79528),(0.58268,0.79528),(0.59055,0.79528),(0.59843,0.79528),(0.6063,0.79528),(0.61417,0.79528),(0.62205,0.79528),(0.62992,0.79528),(0.6378,0.79528),(0.64567,0.79528),(0.65354,0.79528),(0.66142,0.79528),(0.66929,0.79528),(0.67717,0.79528),(0.68504,0.79528),(0.69291,0.79528),(0.70079,0.79528),(0.70866,0.79528),(0.71654,0.79528),(0.72441,0.79528),(0.73228,0.79528),(0.74016,0.79528),(0.74803,0.79528),(0.75591,0.79528),(0.76378,0.79528),(0.77165,0.79528),(0.77953,0.79528),(0.7874,0.79528),(0.79528,0.79528),(0.80315,0.79528),(0.81102,0.79528),(0.8189,0.79528),(0.82677,0.79528),(0.83465,0.79528),(0.84252,0.79528),(0.85039,0.79528),(0.85827,0.79528),(0.86614,0.79528),(0.87402,0.79528),(0.88189,0.79528),(0.88976,0.79528),(0.89764,0.79528),(0.90551,0.79528),(0.91339,0.79528),(0.92126,0.79528),(0.92913,0.79528),(0.93701,0.79528),(0.94488,0.79528),(0.95276,0.79528),(0.96063,0.79528),(0.9685,0.79528),(0.97638,0.79528),(0.98425,0.79528),(0.99213,0.79528),(0.99609,0.79528),(0.00391,0.80315),(0.00787,0.80315),(0.01575,0.80315),(0.02362,0.80315),(0.0315,0.80315),(0.03937,0.80315),(0.04724,0.80315),(0.05512,0.80315),(0.06299,0.80315),(0.07087,0.80315),(0.07874,0.80315),(0.08661,0.80315),(0.09449,0.80315),(0.10236,0.80315),(0.11024,0.80315),(0.11811,0.80315),(0.12598,0.80315),(0.13386,0.80315),(0.14173,0.80315),(0.14961,0.80315),(0.15748,0.80315),(0.16535,0.80315),(0.17323,0.80315),(0.1811,0.80315),(0.18898,0.80315),(0.19685,0.80315),(0.20472,0.80315),(0.2126,0.80315),(0.22047,0.80315),(0.22835,0.80315),(0.23622,0.80315),(0.24409,0.80315),(0.25197,0.80315),(0.25984,0.80315),(0.26772,0.80315),(0.27559,0.80315),(0.28346,0.80315),(0.29134,0.80315),(0.29921,0.80315),(0.30709,0.80315),(0.31496,0.80315),(0.32283,0.80315),(0.33071,0.80315),(0.33858,0.80315),(0.34646,0.80315),(0.35433,0.80315),(0.3622,0.80315),(0.37008,0.80315),(0.37795,0.80315),(0.38583,0.80315),(0.3937,0.80315),(0.40157,0.80315),(0.40945,0.80315),(0.41732,0.80315),(0.4252,0.80315),(0.43307,0.80315),(0.44094,0.80315),(0.44882,0.80315),(0.45669,0.80315),(0.46457,0.80315),(0.47244,0.80315),(0.48031,0.80315),(0.48819,0.80315),(0.49606,0.80315),(0.50394,0.80315),(0.51181,0.80315),(0.51969,0.80315),(0.52756,0.80315),(0.53543,0.80315),(0.54331,0.80315),(0.55118,0.80315),(0.55906,0.80315),(0.56693,0.80315),(0.5748,0.80315),(0.58268,0.80315),(0.59055,0.80315),(0.59843,0.80315),(0.6063,0.80315),(0.61417,0.80315),(0.62205,0.80315),(0.62992,0.80315),(0.6378,0.80315),(0.64567,0.80315),(0.65354,0.80315),(0.66142,0.80315),(0.66929,0.80315),(0.67717,0.80315),(0.68504,0.80315),(0.69291,0.80315),(0.70079,0.80315),(0.70866,0.80315),(0.71654,0.80315),(0.72441,0.80315),(0.73228,0.80315),(0.74016,0.80315),(0.74803,0.80315),(0.75591,0.80315),(0.76378,0.80315),(0.77165,0.80315),(0.77953,0.80315),(0.7874,0.80315),(0.79528,0.80315),(0.80315,0.80315),(0.81102,0.80315),(0.8189,0.80315),(0.82677,0.80315),(0.83465,0.80315),(0.84252,0.80315),(0.85039,0.80315),(0.85827,0.80315),(0.86614,0.80315),(0.87402,0.80315),(0.88189,0.80315),(0.88976,0.80315),(0.89764,0.80315),(0.90551,0.80315),(0.91339,0.80315),(0.92126,0.80315),(0.92913,0.80315),(0.93701,0.80315),(0.94488,0.80315),(0.95276,0.80315),(0.96063,0.80315),(0.9685,0.80315),(0.97638,0.80315),(0.98425,0.80315),(0.99213,0.80315),(0.99609,0.80315),(0.00391,0.81102),(0.00787,0.81102),(0.01575,0.81102),(0.02362,0.81102),(0.0315,0.81102),(0.03937,0.81102),(0.04724,0.81102),(0.05512,0.81102),(0.06299,0.81102),(0.07087,0.81102),(0.07874,0.81102),(0.08661,0.81102),(0.09449,0.81102),(0.10236,0.81102),(0.11024,0.81102),(0.11811,0.81102),(0.12598,0.81102),(0.13386,0.81102),(0.14173,0.81102),(0.14961,0.81102),(0.15748,0.81102),(0.16535,0.81102),(0.17323,0.81102),(0.1811,0.81102),(0.18898,0.81102),(0.19685,0.81102),(0.20472,0.81102),(0.2126,0.81102),(0.22047,0.81102),(0.22835,0.81102),(0.23622,0.81102),(0.24409,0.81102),(0.25197,0.81102),(0.25984,0.81102),(0.26772,0.81102),(0.27559,0.81102),(0.28346,0.81102),(0.29134,0.81102),(0.29921,0.81102),(0.30709,0.81102),(0.31496,0.81102),(0.32283,0.81102),(0.33071,0.81102),(0.33858,0.81102),(0.34646,0.81102),(0.35433,0.81102),(0.3622,0.81102),(0.37008,0.81102),(0.37795,0.81102),(0.38583,0.81102),(0.3937,0.81102),(0.40157,0.81102),(0.40945,0.81102),(0.41732,0.81102),(0.4252,0.81102),(0.43307,0.81102),(0.44094,0.81102),(0.44882,0.81102),(0.45669,0.81102),(0.46457,0.81102),(0.47244,0.81102),(0.48031,0.81102),(0.48819,0.81102),(0.49606,0.81102),(0.50394,0.81102),(0.51181,0.81102),(0.51969,0.81102),(0.52756,0.81102),(0.53543,0.81102),(0.54331,0.81102),(0.55118,0.81102),(0.55906,0.81102),(0.56693,0.81102),(0.5748,0.81102),(0.58268,0.81102),(0.59055,0.81102),(0.59843,0.81102),(0.6063,0.81102),(0.61417,0.81102),(0.62205,0.81102),(0.62992,0.81102),(0.6378,0.81102),(0.64567,0.81102),(0.65354,0.81102),(0.66142,0.81102),(0.66929,0.81102),(0.67717,0.81102),(0.68504,0.81102),(0.69291,0.81102),(0.70079,0.81102),(0.70866,0.81102),(0.71654,0.81102),(0.72441,0.81102),(0.73228,0.81102),(0.74016,0.81102),(0.74803,0.81102),(0.75591,0.81102),(0.76378,0.81102),(0.77165,0.81102),(0.77953,0.81102),(0.7874,0.81102),(0.79528,0.81102),(0.80315,0.81102),(0.81102,0.81102),(0.8189,0.81102),(0.82677,0.81102),(0.83465,0.81102),(0.84252,0.81102),(0.85039,0.81102),(0.85827,0.81102),(0.86614,0.81102),(0.87402,0.81102),(0.88189,0.81102),(0.88976,0.81102),(0.89764,0.81102),(0.90551,0.81102),(0.91339,0.81102),(0.92126,0.81102),(0.92913,0.81102),(0.93701,0.81102),(0.94488,0.81102),(0.95276,0.81102),(0.96063,0.81102),(0.9685,0.81102),(0.97638,0.81102),(0.98425,0.81102),(0.99213,0.81102),(0.99609,0.81102),(0.00391,0.8189),(0.00787,0.8189),(0.01575,0.8189),(0.02362,0.8189),(0.0315,0.8189),(0.03937,0.8189),(0.04724,0.8189),(0.05512,0.8189),(0.06299,0.8189),(0.07087,0.8189),(0.07874,0.8189),(0.08661,0.8189),(0.09449,0.8189),(0.10236,0.8189),(0.11024,0.8189),(0.11811,0.8189),(0.12598,0.8189),(0.13386,0.8189),(0.14173,0.8189),(0.14961,0.8189),(0.15748,0.8189),(0.16535,0.8189),(0.17323,0.8189),(0.1811,0.8189),(0.18898,0.8189),(0.19685,0.8189),(0.20472,0.8189),(0.2126,0.8189),(0.22047,0.8189),(0.22835,0.8189),(0.23622,0.8189),(0.24409,0.8189),(0.25197,0.8189),(0.25984,0.8189),(0.26772,0.8189),(0.27559,0.8189),(0.28346,0.8189),(0.29134,0.8189),(0.29921,0.8189),(0.30709,0.8189),(0.31496,0.8189),(0.32283,0.8189),(0.33071,0.8189),(0.33858,0.8189),(0.34646,0.8189),(0.35433,0.8189),(0.3622,0.8189),(0.37008,0.8189),(0.37795,0.8189),(0.38583,0.8189),(0.3937,0.8189),(0.40157,0.8189),(0.40945,0.8189),(0.41732,0.8189),(0.4252,0.8189),(0.43307,0.8189),(0.44094,0.8189),(0.44882,0.8189),(0.45669,0.8189),(0.46457,0.8189),(0.47244,0.8189),(0.48031,0.8189),(0.48819,0.8189),(0.49606,0.8189),(0.50394,0.8189),(0.51181,0.8189),(0.51969,0.8189),(0.52756,0.8189),(0.53543,0.8189),(0.54331,0.8189),(0.55118,0.8189),(0.55906,0.8189),(0.56693,0.8189),(0.5748,0.8189),(0.58268,0.8189),(0.59055,0.8189),(0.59843,0.8189),(0.6063,0.8189),(0.61417,0.8189),(0.62205,0.8189),(0.62992,0.8189),(0.6378,0.8189),(0.64567,0.8189),(0.65354,0.8189),(0.66142,0.8189),(0.66929,0.8189),(0.67717,0.8189),(0.68504,0.8189),(0.69291,0.8189),(0.70079,0.8189),(0.70866,0.8189),(0.71654,0.8189),(0.72441,0.8189),(0.73228,0.8189),(0.74016,0.8189),(0.74803,0.8189),(0.75591,0.8189),(0.76378,0.8189),(0.77165,0.8189),(0.77953,0.8189),(0.7874,0.8189),(0.79528,0.8189),(0.80315,0.8189),(0.81102,0.8189),(0.8189,0.8189),(0.82677,0.8189),(0.83465,0.8189),(0.84252,0.8189),(0.85039,0.8189),(0.85827,0.8189),(0.86614,0.8189),(0.87402,0.8189),(0.88189,0.8189),(0.88976,0.8189),(0.89764,0.8189),(0.90551,0.8189),(0.91339,0.8189),(0.92126,0.8189),(0.92913,0.8189),(0.93701,0.8189),(0.94488,0.8189),(0.95276,0.8189),(0.96063,0.8189),(0.9685,0.8189),(0.97638,0.8189),(0.98425,0.8189),(0.99213,0.8189),(0.99609,0.8189),(0.00391,0.82677),(0.00787,0.82677),(0.01575,0.82677),(0.02362,0.82677),(0.0315,0.82677),(0.03937,0.82677),(0.04724,0.82677),(0.05512,0.82677),(0.06299,0.82677),(0.07087,0.82677),(0.07874,0.82677),(0.08661,0.82677),(0.09449,0.82677),(0.10236,0.82677),(0.11024,0.82677),(0.11811,0.82677),(0.12598,0.82677),(0.13386,0.82677),(0.14173,0.82677),(0.14961,0.82677),(0.15748,0.82677),(0.16535,0.82677),(0.17323,0.82677),(0.1811,0.82677),(0.18898,0.82677),(0.19685,0.82677),(0.20472,0.82677),(0.2126,0.82677),(0.22047,0.82677),(0.22835,0.82677),(0.23622,0.82677),(0.24409,0.82677),(0.25197,0.82677),(0.25984,0.82677),(0.26772,0.82677),(0.27559,0.82677),(0.28346,0.82677),(0.29134,0.82677),(0.29921,0.82677),(0.30709,0.82677),(0.31496,0.82677),(0.32283,0.82677),(0.33071,0.82677),(0.33858,0.82677),(0.34646,0.82677),(0.35433,0.82677),(0.3622,0.82677),(0.37008,0.82677),(0.37795,0.82677),(0.38583,0.82677),(0.3937,0.82677),(0.40157,0.82677),(0.40945,0.82677),(0.41732,0.82677),(0.4252,0.82677),(0.43307,0.82677),(0.44094,0.82677),(0.44882,0.82677),(0.45669,0.82677),(0.46457,0.82677),(0.47244,0.82677),(0.48031,0.82677),(0.48819,0.82677),(0.49606,0.82677),(0.50394,0.82677),(0.51181,0.82677),(0.51969,0.82677),(0.52756,0.82677),(0.53543,0.82677),(0.54331,0.82677),(0.55118,0.82677),(0.55906,0.82677),(0.56693,0.82677),(0.5748,0.82677),(0.58268,0.82677),(0.59055,0.82677),(0.59843,0.82677),(0.6063,0.82677),(0.61417,0.82677),(0.62205,0.82677),(0.62992,0.82677),(0.6378,0.82677),(0.64567,0.82677),(0.65354,0.82677),(0.66142,0.82677),(0.66929,0.82677),(0.67717,0.82677),(0.68504,0.82677),(0.69291,0.82677),(0.70079,0.82677),(0.70866,0.82677),(0.71654,0.82677),(0.72441,0.82677),(0.73228,0.82677),(0.74016,0.82677),(0.74803,0.82677),(0.75591,0.82677),(0.76378,0.82677),(0.77165,0.82677),(0.77953,0.82677),(0.7874,0.82677),(0.79528,0.82677),(0.80315,0.82677),(0.81102,0.82677),(0.8189,0.82677),(0.82677,0.82677),(0.83465,0.82677),(0.84252,0.82677),(0.85039,0.82677),(0.85827,0.82677),(0.86614,0.82677),(0.87402,0.82677),(0.88189,0.82677),(0.88976,0.82677),(0.89764,0.82677),(0.90551,0.82677),(0.91339,0.82677),(0.92126,0.82677),(0.92913,0.82677),(0.93701,0.82677),(0.94488,0.82677),(0.95276,0.82677),(0.96063,0.82677),(0.9685,0.82677),(0.97638,0.82677),(0.98425,0.82677),(0.99213,0.82677),(0.99609,0.82677),(0.00391,0.83465),(0.00787,0.83465),(0.01575,0.83465),(0.02362,0.83465),(0.0315,0.83465),(0.03937,0.83465),(0.04724,0.83465),(0.05512,0.83465),(0.06299,0.83465),(0.07087,0.83465),(0.07874,0.83465),(0.08661,0.83465),(0.09449,0.83465),(0.10236,0.83465),(0.11024,0.83465),(0.11811,0.83465),(0.12598,0.83465),(0.13386,0.83465),(0.14173,0.83465),(0.14961,0.83465),(0.15748,0.83465),(0.16535,0.83465),(0.17323,0.83465),(0.1811,0.83465),(0.18898,0.83465),(0.19685,0.83465),(0.20472,0.83465),(0.2126,0.83465),(0.22047,0.83465),(0.22835,0.83465),(0.23622,0.83465),(0.24409,0.83465),(0.25197,0.83465),(0.25984,0.83465),(0.26772,0.83465),(0.27559,0.83465),(0.28346,0.83465),(0.29134,0.83465),(0.29921,0.83465),(0.30709,0.83465),(0.31496,0.83465),(0.32283,0.83465),(0.33071,0.83465),(0.33858,0.83465),(0.34646,0.83465),(0.35433,0.83465),(0.3622,0.83465),(0.37008,0.83465),(0.37795,0.83465),(0.38583,0.83465),(0.3937,0.83465),(0.40157,0.83465),(0.40945,0.83465),(0.41732,0.83465),(0.4252,0.83465),(0.43307,0.83465),(0.44094,0.83465),(0.44882,0.83465),(0.45669,0.83465),(0.46457,0.83465),(0.47244,0.83465),(0.48031,0.83465),(0.48819,0.83465),(0.49606,0.83465),(0.50394,0.83465),(0.51181,0.83465),(0.51969,0.83465),(0.52756,0.83465),(0.53543,0.83465),(0.54331,0.83465),(0.55118,0.83465),(0.55906,0.83465),(0.56693,0.83465),(0.5748,0.83465),(0.58268,0.83465),(0.59055,0.83465),(0.59843,0.83465),(0.6063,0.83465),(0.61417,0.83465),(0.62205,0.83465),(0.62992,0.83465),(0.6378,0.83465),(0.64567,0.83465),(0.65354,0.83465),(0.66142,0.83465),(0.66929,0.83465),(0.67717,0.83465),(0.68504,0.83465),(0.69291,0.83465),(0.70079,0.83465),(0.70866,0.83465),(0.71654,0.83465),(0.72441,0.83465),(0.73228,0.83465),(0.74016,0.83465),(0.74803,0.83465),(0.75591,0.83465),(0.76378,0.83465),(0.77165,0.83465),(0.77953,0.83465),(0.7874,0.83465),(0.79528,0.83465),(0.80315,0.83465),(0.81102,0.83465),(0.8189,0.83465),(0.82677,0.83465),(0.83465,0.83465),(0.84252,0.83465),(0.85039,0.83465),(0.85827,0.83465),(0.86614,0.83465),(0.87402,0.83465),(0.88189,0.83465),(0.88976,0.83465),(0.89764,0.83465),(0.90551,0.83465),(0.91339,0.83465),(0.92126,0.83465),(0.92913,0.83465),(0.93701,0.83465),(0.94488,0.83465),(0.95276,0.83465),(0.96063,0.83465),(0.9685,0.83465),(0.97638,0.83465),(0.98425,0.83465),(0.99213,0.83465),(0.99609,0.83465),(0.00391,0.84252),(0.00787,0.84252),(0.01575,0.84252),(0.02362,0.84252),(0.0315,0.84252),(0.03937,0.84252),(0.04724,0.84252),(0.05512,0.84252),(0.06299,0.84252),(0.07087,0.84252),(0.07874,0.84252),(0.08661,0.84252),(0.09449,0.84252),(0.10236,0.84252),(0.11024,0.84252),(0.11811,0.84252),(0.12598,0.84252),(0.13386,0.84252),(0.14173,0.84252),(0.14961,0.84252),(0.15748,0.84252),(0.16535,0.84252),(0.17323,0.84252),(0.1811,0.84252),(0.18898,0.84252),(0.19685,0.84252),(0.20472,0.84252),(0.2126,0.84252),(0.22047,0.84252),(0.22835,0.84252),(0.23622,0.84252),(0.24409,0.84252),(0.25197,0.84252),(0.25984,0.84252),(0.26772,0.84252),(0.27559,0.84252),(0.28346,0.84252),(0.29134,0.84252),(0.29921,0.84252),(0.30709,0.84252),(0.31496,0.84252),(0.32283,0.84252),(0.33071,0.84252),(0.33858,0.84252),(0.34646,0.84252),(0.35433,0.84252),(0.3622,0.84252),(0.37008,0.84252),(0.37795,0.84252),(0.38583,0.84252),(0.3937,0.84252),(0.40157,0.84252),(0.40945,0.84252),(0.41732,0.84252),(0.4252,0.84252),(0.43307,0.84252),(0.44094,0.84252),(0.44882,0.84252),(0.45669,0.84252),(0.46457,0.84252),(0.47244,0.84252),(0.48031,0.84252),(0.48819,0.84252),(0.49606,0.84252),(0.50394,0.84252),(0.51181,0.84252),(0.51969,0.84252),(0.52756,0.84252),(0.53543,0.84252),(0.54331,0.84252),(0.55118,0.84252),(0.55906,0.84252),(0.56693,0.84252),(0.5748,0.84252),(0.58268,0.84252),(0.59055,0.84252),(0.59843,0.84252),(0.6063,0.84252),(0.61417,0.84252),(0.62205,0.84252),(0.62992,0.84252),(0.6378,0.84252),(0.64567,0.84252),(0.65354,0.84252),(0.66142,0.84252),(0.66929,0.84252),(0.67717,0.84252),(0.68504,0.84252),(0.69291,0.84252),(0.70079,0.84252),(0.70866,0.84252),(0.71654,0.84252),(0.72441,0.84252),(0.73228,0.84252),(0.74016,0.84252),(0.74803,0.84252),(0.75591,0.84252),(0.76378,0.84252),(0.77165,0.84252),(0.77953,0.84252),(0.7874,0.84252),(0.79528,0.84252),(0.80315,0.84252),(0.81102,0.84252),(0.8189,0.84252),(0.82677,0.84252),(0.83465,0.84252),(0.84252,0.84252),(0.85039,0.84252),(0.85827,0.84252),(0.86614,0.84252),(0.87402,0.84252),(0.88189,0.84252),(0.88976,0.84252),(0.89764,0.84252),(0.90551,0.84252),(0.91339,0.84252),(0.92126,0.84252),(0.92913,0.84252),(0.93701,0.84252),(0.94488,0.84252),(0.95276,0.84252),(0.96063,0.84252),(0.9685,0.84252),(0.97638,0.84252),(0.98425,0.84252),(0.99213,0.84252),(0.99609,0.84252),(0.00391,0.85039),(0.00787,0.85039),(0.01575,0.85039),(0.02362,0.85039),(0.0315,0.85039),(0.03937,0.85039),(0.04724,0.85039),(0.05512,0.85039),(0.06299,0.85039),(0.07087,0.85039),(0.07874,0.85039),(0.08661,0.85039),(0.09449,0.85039),(0.10236,0.85039),(0.11024,0.85039),(0.11811,0.85039),(0.12598,0.85039),(0.13386,0.85039),(0.14173,0.85039),(0.14961,0.85039),(0.15748,0.85039),(0.16535,0.85039),(0.17323,0.85039),(0.1811,0.85039),(0.18898,0.85039),(0.19685,0.85039),(0.20472,0.85039),(0.2126,0.85039),(0.22047,0.85039),(0.22835,0.85039),(0.23622,0.85039),(0.24409,0.85039),(0.25197,0.85039),(0.25984,0.85039),(0.26772,0.85039),(0.27559,0.85039),(0.28346,0.85039),(0.29134,0.85039),(0.29921,0.85039),(0.30709,0.85039),(0.31496,0.85039),(0.32283,0.85039),(0.33071,0.85039),(0.33858,0.85039),(0.34646,0.85039),(0.35433,0.85039),(0.3622,0.85039),(0.37008,0.85039),(0.37795,0.85039),(0.38583,0.85039),(0.3937,0.85039),(0.40157,0.85039),(0.40945,0.85039),(0.41732,0.85039),(0.4252,0.85039),(0.43307,0.85039),(0.44094,0.85039),(0.44882,0.85039),(0.45669,0.85039),(0.46457,0.85039),(0.47244,0.85039),(0.48031,0.85039),(0.48819,0.85039),(0.49606,0.85039),(0.50394,0.85039),(0.51181,0.85039),(0.51969,0.85039),(0.52756,0.85039),(0.53543,0.85039),(0.54331,0.85039),(0.55118,0.85039),(0.55906,0.85039),(0.56693,0.85039),(0.5748,0.85039),(0.58268,0.85039),(0.59055,0.85039),(0.59843,0.85039),(0.6063,0.85039),(0.61417,0.85039),(0.62205,0.85039),(0.62992,0.85039),(0.6378,0.85039),(0.64567,0.85039),(0.65354,0.85039),(0.66142,0.85039),(0.66929,0.85039),(0.67717,0.85039),(0.68504,0.85039),(0.69291,0.85039),(0.70079,0.85039),(0.70866,0.85039),(0.71654,0.85039),(0.72441,0.85039),(0.73228,0.85039),(0.74016,0.85039),(0.74803,0.85039),(0.75591,0.85039),(0.76378,0.85039),(0.77165,0.85039),(0.77953,0.85039),(0.7874,0.85039),(0.79528,0.85039),(0.80315,0.85039),(0.81102,0.85039),(0.8189,0.85039),(0.82677,0.85039),(0.83465,0.85039),(0.84252,0.85039),(0.85039,0.85039),(0.85827,0.85039),(0.86614,0.85039),(0.87402,0.85039),(0.88189,0.85039),(0.88976,0.85039),(0.89764,0.85039),(0.90551,0.85039),(0.91339,0.85039),(0.92126,0.85039),(0.92913,0.85039),(0.93701,0.85039),(0.94488,0.85039),(0.95276,0.85039),(0.96063,0.85039),(0.9685,0.85039),(0.97638,0.85039),(0.98425,0.85039),(0.99213,0.85039),(0.99609,0.85039),(0.00391,0.85827),(0.00787,0.85827),(0.01575,0.85827),(0.02362,0.85827),(0.0315,0.85827),(0.03937,0.85827),(0.04724,0.85827),(0.05512,0.85827),(0.06299,0.85827),(0.07087,0.85827),(0.07874,0.85827),(0.08661,0.85827),(0.09449,0.85827),(0.10236,0.85827),(0.11024,0.85827),(0.11811,0.85827),(0.12598,0.85827),(0.13386,0.85827),(0.14173,0.85827),(0.14961,0.85827),(0.15748,0.85827),(0.16535,0.85827),(0.17323,0.85827),(0.1811,0.85827),(0.18898,0.85827),(0.19685,0.85827),(0.20472,0.85827),(0.2126,0.85827),(0.22047,0.85827),(0.22835,0.85827),(0.23622,0.85827),(0.24409,0.85827),(0.25197,0.85827),(0.25984,0.85827),(0.26772,0.85827),(0.27559,0.85827),(0.28346,0.85827),(0.29134,0.85827),(0.29921,0.85827),(0.30709,0.85827),(0.31496,0.85827),(0.32283,0.85827),(0.33071,0.85827),(0.33858,0.85827),(0.34646,0.85827),(0.35433,0.85827),(0.3622,0.85827),(0.37008,0.85827),(0.37795,0.85827),(0.38583,0.85827),(0.3937,0.85827),(0.40157,0.85827),(0.40945,0.85827),(0.41732,0.85827),(0.4252,0.85827),(0.43307,0.85827),(0.44094,0.85827),(0.44882,0.85827),(0.45669,0.85827),(0.46457,0.85827),(0.47244,0.85827),(0.48031,0.85827),(0.48819,0.85827),(0.49606,0.85827),(0.50394,0.85827),(0.51181,0.85827),(0.51969,0.85827),(0.52756,0.85827),(0.53543,0.85827),(0.54331,0.85827),(0.55118,0.85827),(0.55906,0.85827),(0.56693,0.85827),(0.5748,0.85827),(0.58268,0.85827),(0.59055,0.85827),(0.59843,0.85827),(0.6063,0.85827),(0.61417,0.85827),(0.62205,0.85827),(0.62992,0.85827),(0.6378,0.85827),(0.64567,0.85827),(0.65354,0.85827),(0.66142,0.85827),(0.66929,0.85827),(0.67717,0.85827),(0.68504,0.85827),(0.69291,0.85827),(0.70079,0.85827),(0.70866,0.85827),(0.71654,0.85827),(0.72441,0.85827),(0.73228,0.85827),(0.74016,0.85827),(0.74803,0.85827),(0.75591,0.85827),(0.76378,0.85827),(0.77165,0.85827),(0.77953,0.85827),(0.7874,0.85827),(0.79528,0.85827),(0.80315,0.85827),(0.81102,0.85827),(0.8189,0.85827),(0.82677,0.85827),(0.83465,0.85827),(0.84252,0.85827),(0.85039,0.85827),(0.85827,0.85827),(0.86614,0.85827),(0.87402,0.85827),(0.88189,0.85827),(0.88976,0.85827),(0.89764,0.85827),(0.90551,0.85827),(0.91339,0.85827),(0.92126,0.85827),(0.92913,0.85827),(0.93701,0.85827),(0.94488,0.85827),(0.95276,0.85827),(0.96063,0.85827),(0.9685,0.85827),(0.97638,0.85827),(0.98425,0.85827),(0.99213,0.85827),(0.99609,0.85827),(0.00391,0.86614),(0.00787,0.86614),(0.01575,0.86614),(0.02362,0.86614),(0.0315,0.86614),(0.03937,0.86614),(0.04724,0.86614),(0.05512,0.86614),(0.06299,0.86614),(0.07087,0.86614),(0.07874,0.86614),(0.08661,0.86614),(0.09449,0.86614),(0.10236,0.86614),(0.11024,0.86614),(0.11811,0.86614),(0.12598,0.86614),(0.13386,0.86614),(0.14173,0.86614),(0.14961,0.86614),(0.15748,0.86614),(0.16535,0.86614),(0.17323,0.86614),(0.1811,0.86614),(0.18898,0.86614),(0.19685,0.86614),(0.20472,0.86614),(0.2126,0.86614),(0.22047,0.86614),(0.22835,0.86614),(0.23622,0.86614),(0.24409,0.86614),(0.25197,0.86614),(0.25984,0.86614),(0.26772,0.86614),(0.27559,0.86614),(0.28346,0.86614),(0.29134,0.86614),(0.29921,0.86614),(0.30709,0.86614),(0.31496,0.86614),(0.32283,0.86614),(0.33071,0.86614),(0.33858,0.86614),(0.34646,0.86614),(0.35433,0.86614),(0.3622,0.86614),(0.37008,0.86614),(0.37795,0.86614),(0.38583,0.86614),(0.3937,0.86614),(0.40157,0.86614),(0.40945,0.86614),(0.41732,0.86614),(0.4252,0.86614),(0.43307,0.86614),(0.44094,0.86614),(0.44882,0.86614),(0.45669,0.86614),(0.46457,0.86614),(0.47244,0.86614),(0.48031,0.86614),(0.48819,0.86614),(0.49606,0.86614),(0.50394,0.86614),(0.51181,0.86614),(0.51969,0.86614),(0.52756,0.86614),(0.53543,0.86614),(0.54331,0.86614),(0.55118,0.86614),(0.55906,0.86614),(0.56693,0.86614),(0.5748,0.86614),(0.58268,0.86614),(0.59055,0.86614),(0.59843,0.86614),(0.6063,0.86614),(0.61417,0.86614),(0.62205,0.86614),(0.62992,0.86614),(0.6378,0.86614),(0.64567,0.86614),(0.65354,0.86614),(0.66142,0.86614),(0.66929,0.86614),(0.67717,0.86614),(0.68504,0.86614),(0.69291,0.86614),(0.70079,0.86614),(0.70866,0.86614),(0.71654,0.86614),(0.72441,0.86614),(0.73228,0.86614),(0.74016,0.86614),(0.74803,0.86614),(0.75591,0.86614),(0.76378,0.86614),(0.77165,0.86614),(0.77953,0.86614),(0.7874,0.86614),(0.79528,0.86614),(0.80315,0.86614),(0.81102,0.86614),(0.8189,0.86614),(0.82677,0.86614),(0.83465,0.86614),(0.84252,0.86614),(0.85039,0.86614),(0.85827,0.86614),(0.86614,0.86614),(0.87402,0.86614),(0.88189,0.86614),(0.88976,0.86614),(0.89764,0.86614),(0.90551,0.86614),(0.91339,0.86614),(0.92126,0.86614),(0.92913,0.86614),(0.93701,0.86614),(0.94488,0.86614),(0.95276,0.86614),(0.96063,0.86614),(0.9685,0.86614),(0.97638,0.86614),(0.98425,0.86614),(0.99213,0.86614),(0.99609,0.86614),(0.00391,0.87402),(0.00787,0.87402),(0.01575,0.87402),(0.02362,0.87402),(0.0315,0.87402),(0.03937,0.87402),(0.04724,0.87402),(0.05512,0.87402),(0.06299,0.87402),(0.07087,0.87402),(0.07874,0.87402),(0.08661,0.87402),(0.09449,0.87402),(0.10236,0.87402),(0.11024,0.87402),(0.11811,0.87402),(0.12598,0.87402),(0.13386,0.87402),(0.14173,0.87402),(0.14961,0.87402),(0.15748,0.87402),(0.16535,0.87402),(0.17323,0.87402),(0.1811,0.87402),(0.18898,0.87402),(0.19685,0.87402),(0.20472,0.87402),(0.2126,0.87402),(0.22047,0.87402),(0.22835,0.87402),(0.23622,0.87402),(0.24409,0.87402),(0.25197,0.87402),(0.25984,0.87402),(0.26772,0.87402),(0.27559,0.87402),(0.28346,0.87402),(0.29134,0.87402),(0.29921,0.87402),(0.30709,0.87402),(0.31496,0.87402),(0.32283,0.87402),(0.33071,0.87402),(0.33858,0.87402),(0.34646,0.87402),(0.35433,0.87402),(0.3622,0.87402),(0.37008,0.87402),(0.37795,0.87402),(0.38583,0.87402),(0.3937,0.87402),(0.40157,0.87402),(0.40945,0.87402),(0.41732,0.87402),(0.4252,0.87402),(0.43307,0.87402),(0.44094,0.87402),(0.44882,0.87402),(0.45669,0.87402),(0.46457,0.87402),(0.47244,0.87402),(0.48031,0.87402),(0.48819,0.87402),(0.49606,0.87402),(0.50394,0.87402),(0.51181,0.87402),(0.51969,0.87402),(0.52756,0.87402),(0.53543,0.87402),(0.54331,0.87402),(0.55118,0.87402),(0.55906,0.87402),(0.56693,0.87402),(0.5748,0.87402),(0.58268,0.87402),(0.59055,0.87402),(0.59843,0.87402),(0.6063,0.87402),(0.61417,0.87402),(0.62205,0.87402),(0.62992,0.87402),(0.6378,0.87402),(0.64567,0.87402),(0.65354,0.87402),(0.66142,0.87402),(0.66929,0.87402),(0.67717,0.87402),(0.68504,0.87402),(0.69291,0.87402),(0.70079,0.87402),(0.70866,0.87402),(0.71654,0.87402),(0.72441,0.87402),(0.73228,0.87402),(0.74016,0.87402),(0.74803,0.87402),(0.75591,0.87402),(0.76378,0.87402),(0.77165,0.87402),(0.77953,0.87402),(0.7874,0.87402),(0.79528,0.87402),(0.80315,0.87402),(0.81102,0.87402),(0.8189,0.87402),(0.82677,0.87402),(0.83465,0.87402),(0.84252,0.87402),(0.85039,0.87402),(0.85827,0.87402),(0.86614,0.87402),(0.87402,0.87402),(0.88189,0.87402),(0.88976,0.87402),(0.89764,0.87402),(0.90551,0.87402),(0.91339,0.87402),(0.92126,0.87402),(0.92913,0.87402),(0.93701,0.87402),(0.94488,0.87402),(0.95276,0.87402),(0.96063,0.87402),(0.9685,0.87402),(0.97638,0.87402),(0.98425,0.87402),(0.99213,0.87402),(0.99609,0.87402),(0.00391,0.88189),(0.00787,0.88189),(0.01575,0.88189),(0.02362,0.88189),(0.0315,0.88189),(0.03937,0.88189),(0.04724,0.88189),(0.05512,0.88189),(0.06299,0.88189),(0.07087,0.88189),(0.07874,0.88189),(0.08661,0.88189),(0.09449,0.88189),(0.10236,0.88189),(0.11024,0.88189),(0.11811,0.88189),(0.12598,0.88189),(0.13386,0.88189),(0.14173,0.88189),(0.14961,0.88189),(0.15748,0.88189),(0.16535,0.88189),(0.17323,0.88189),(0.1811,0.88189),(0.18898,0.88189),(0.19685,0.88189),(0.20472,0.88189),(0.2126,0.88189),(0.22047,0.88189),(0.22835,0.88189),(0.23622,0.88189),(0.24409,0.88189),(0.25197,0.88189),(0.25984,0.88189),(0.26772,0.88189),(0.27559,0.88189),(0.28346,0.88189),(0.29134,0.88189),(0.29921,0.88189),(0.30709,0.88189),(0.31496,0.88189),(0.32283,0.88189),(0.33071,0.88189),(0.33858,0.88189),(0.34646,0.88189),(0.35433,0.88189),(0.3622,0.88189),(0.37008,0.88189),(0.37795,0.88189),(0.38583,0.88189),(0.3937,0.88189),(0.40157,0.88189),(0.40945,0.88189),(0.41732,0.88189),(0.4252,0.88189),(0.43307,0.88189),(0.44094,0.88189),(0.44882,0.88189),(0.45669,0.88189),(0.46457,0.88189),(0.47244,0.88189),(0.48031,0.88189),(0.48819,0.88189),(0.49606,0.88189),(0.50394,0.88189),(0.51181,0.88189),(0.51969,0.88189),(0.52756,0.88189),(0.53543,0.88189),(0.54331,0.88189),(0.55118,0.88189),(0.55906,0.88189),(0.56693,0.88189),(0.5748,0.88189),(0.58268,0.88189),(0.59055,0.88189),(0.59843,0.88189),(0.6063,0.88189),(0.61417,0.88189),(0.62205,0.88189),(0.62992,0.88189),(0.6378,0.88189),(0.64567,0.88189),(0.65354,0.88189),(0.66142,0.88189),(0.66929,0.88189),(0.67717,0.88189),(0.68504,0.88189),(0.69291,0.88189),(0.70079,0.88189),(0.70866,0.88189),(0.71654,0.88189),(0.72441,0.88189),(0.73228,0.88189),(0.74016,0.88189),(0.74803,0.88189),(0.75591,0.88189),(0.76378,0.88189),(0.77165,0.88189),(0.77953,0.88189),(0.7874,0.88189),(0.79528,0.88189),(0.80315,0.88189),(0.81102,0.88189),(0.8189,0.88189),(0.82677,0.88189),(0.83465,0.88189),(0.84252,0.88189),(0.85039,0.88189),(0.85827,0.88189),(0.86614,0.88189),(0.87402,0.88189),(0.88189,0.88189),(0.88976,0.88189),(0.89764,0.88189),(0.90551,0.88189),(0.91339,0.88189),(0.92126,0.88189),(0.92913,0.88189),(0.93701,0.88189),(0.94488,0.88189),(0.95276,0.88189),(0.96063,0.88189),(0.9685,0.88189),(0.97638,0.88189),(0.98425,0.88189),(0.99213,0.88189),(0.99609,0.88189),(0.00391,0.88976),(0.00787,0.88976),(0.01575,0.88976),(0.02362,0.88976),(0.0315,0.88976),(0.03937,0.88976),(0.04724,0.88976),(0.05512,0.88976),(0.06299,0.88976),(0.07087,0.88976),(0.07874,0.88976),(0.08661,0.88976),(0.09449,0.88976),(0.10236,0.88976),(0.11024,0.88976),(0.11811,0.88976),(0.12598,0.88976),(0.13386,0.88976),(0.14173,0.88976),(0.14961,0.88976),(0.15748,0.88976),(0.16535,0.88976),(0.17323,0.88976),(0.1811,0.88976),(0.18898,0.88976),(0.19685,0.88976),(0.20472,0.88976),(0.2126,0.88976),(0.22047,0.88976),(0.22835,0.88976),(0.23622,0.88976),(0.24409,0.88976),(0.25197,0.88976),(0.25984,0.88976),(0.26772,0.88976),(0.27559,0.88976),(0.28346,0.88976),(0.29134,0.88976),(0.29921,0.88976),(0.30709,0.88976),(0.31496,0.88976),(0.32283,0.88976),(0.33071,0.88976),(0.33858,0.88976),(0.34646,0.88976),(0.35433,0.88976),(0.3622,0.88976),(0.37008,0.88976),(0.37795,0.88976),(0.38583,0.88976),(0.3937,0.88976),(0.40157,0.88976),(0.40945,0.88976),(0.41732,0.88976),(0.4252,0.88976),(0.43307,0.88976),(0.44094,0.88976),(0.44882,0.88976),(0.45669,0.88976),(0.46457,0.88976),(0.47244,0.88976),(0.48031,0.88976),(0.48819,0.88976),(0.49606,0.88976),(0.50394,0.88976),(0.51181,0.88976),(0.51969,0.88976),(0.52756,0.88976),(0.53543,0.88976),(0.54331,0.88976),(0.55118,0.88976),(0.55906,0.88976),(0.56693,0.88976),(0.5748,0.88976),(0.58268,0.88976),(0.59055,0.88976),(0.59843,0.88976),(0.6063,0.88976),(0.61417,0.88976),(0.62205,0.88976),(0.62992,0.88976),(0.6378,0.88976),(0.64567,0.88976),(0.65354,0.88976),(0.66142,0.88976),(0.66929,0.88976),(0.67717,0.88976),(0.68504,0.88976),(0.69291,0.88976),(0.70079,0.88976),(0.70866,0.88976),(0.71654,0.88976),(0.72441,0.88976),(0.73228,0.88976),(0.74016,0.88976),(0.74803,0.88976),(0.75591,0.88976),(0.76378,0.88976),(0.77165,0.88976),(0.77953,0.88976),(0.7874,0.88976),(0.79528,0.88976),(0.80315,0.88976),(0.81102,0.88976),(0.8189,0.88976),(0.82677,0.88976),(0.83465,0.88976),(0.84252,0.88976),(0.85039,0.88976),(0.85827,0.88976),(0.86614,0.88976),(0.87402,0.88976),(0.88189,0.88976),(0.88976,0.88976),(0.89764,0.88976),(0.90551,0.88976),(0.91339,0.88976),(0.92126,0.88976),(0.92913,0.88976),(0.93701,0.88976),(0.94488,0.88976),(0.95276,0.88976),(0.96063,0.88976),(0.9685,0.88976),(0.97638,0.88976),(0.98425,0.88976),(0.99213,0.88976),(0.99609,0.88976),(0.00391,0.89764),(0.00787,0.89764),(0.01575,0.89764),(0.02362,0.89764),(0.0315,0.89764),(0.03937,0.89764),(0.04724,0.89764),(0.05512,0.89764),(0.06299,0.89764),(0.07087,0.89764),(0.07874,0.89764),(0.08661,0.89764),(0.09449,0.89764),(0.10236,0.89764),(0.11024,0.89764),(0.11811,0.89764),(0.12598,0.89764),(0.13386,0.89764),(0.14173,0.89764),(0.14961,0.89764),(0.15748,0.89764),(0.16535,0.89764),(0.17323,0.89764),(0.1811,0.89764),(0.18898,0.89764),(0.19685,0.89764),(0.20472,0.89764),(0.2126,0.89764),(0.22047,0.89764),(0.22835,0.89764),(0.23622,0.89764),(0.24409,0.89764),(0.25197,0.89764),(0.25984,0.89764),(0.26772,0.89764),(0.27559,0.89764),(0.28346,0.89764),(0.29134,0.89764),(0.29921,0.89764),(0.30709,0.89764),(0.31496,0.89764),(0.32283,0.89764),(0.33071,0.89764),(0.33858,0.89764),(0.34646,0.89764),(0.35433,0.89764),(0.3622,0.89764),(0.37008,0.89764),(0.37795,0.89764),(0.38583,0.89764),(0.3937,0.89764),(0.40157,0.89764),(0.40945,0.89764),(0.41732,0.89764),(0.4252,0.89764),(0.43307,0.89764),(0.44094,0.89764),(0.44882,0.89764),(0.45669,0.89764),(0.46457,0.89764),(0.47244,0.89764),(0.48031,0.89764),(0.48819,0.89764),(0.49606,0.89764),(0.50394,0.89764),(0.51181,0.89764),(0.51969,0.89764),(0.52756,0.89764),(0.53543,0.89764),(0.54331,0.89764),(0.55118,0.89764),(0.55906,0.89764),(0.56693,0.89764),(0.5748,0.89764),(0.58268,0.89764),(0.59055,0.89764),(0.59843,0.89764),(0.6063,0.89764),(0.61417,0.89764),(0.62205,0.89764),(0.62992,0.89764),(0.6378,0.89764),(0.64567,0.89764),(0.65354,0.89764),(0.66142,0.89764),(0.66929,0.89764),(0.67717,0.89764),(0.68504,0.89764),(0.69291,0.89764),(0.70079,0.89764),(0.70866,0.89764),(0.71654,0.89764),(0.72441,0.89764),(0.73228,0.89764),(0.74016,0.89764),(0.74803,0.89764),(0.75591,0.89764),(0.76378,0.89764),(0.77165,0.89764),(0.77953,0.89764),(0.7874,0.89764),(0.79528,0.89764),(0.80315,0.89764),(0.81102,0.89764),(0.8189,0.89764),(0.82677,0.89764),(0.83465,0.89764),(0.84252,0.89764),(0.85039,0.89764),(0.85827,0.89764),(0.86614,0.89764),(0.87402,0.89764),(0.88189,0.89764),(0.88976,0.89764),(0.89764,0.89764),(0.90551,0.89764),(0.91339,0.89764),(0.92126,0.89764),(0.92913,0.89764),(0.93701,0.89764),(0.94488,0.89764),(0.95276,0.89764),(0.96063,0.89764),(0.9685,0.89764),(0.97638,0.89764),(0.98425,0.89764),(0.99213,0.89764),(0.99609,0.89764),(0.00391,0.90551),(0.00787,0.90551),(0.01575,0.90551),(0.02362,0.90551),(0.0315,0.90551),(0.03937,0.90551),(0.04724,0.90551),(0.05512,0.90551),(0.06299,0.90551),(0.07087,0.90551),(0.07874,0.90551),(0.08661,0.90551),(0.09449,0.90551),(0.10236,0.90551),(0.11024,0.90551),(0.11811,0.90551),(0.12598,0.90551),(0.13386,0.90551),(0.14173,0.90551),(0.14961,0.90551),(0.15748,0.90551),(0.16535,0.90551),(0.17323,0.90551),(0.1811,0.90551),(0.18898,0.90551),(0.19685,0.90551),(0.20472,0.90551),(0.2126,0.90551),(0.22047,0.90551),(0.22835,0.90551),(0.23622,0.90551),(0.24409,0.90551),(0.25197,0.90551),(0.25984,0.90551),(0.26772,0.90551),(0.27559,0.90551),(0.28346,0.90551),(0.29134,0.90551),(0.29921,0.90551),(0.30709,0.90551),(0.31496,0.90551),(0.32283,0.90551),(0.33071,0.90551),(0.33858,0.90551),(0.34646,0.90551),(0.35433,0.90551),(0.3622,0.90551),(0.37008,0.90551),(0.37795,0.90551),(0.38583,0.90551),(0.3937,0.90551),(0.40157,0.90551),(0.40945,0.90551),(0.41732,0.90551),(0.4252,0.90551),(0.43307,0.90551),(0.44094,0.90551),(0.44882,0.90551),(0.45669,0.90551),(0.46457,0.90551),(0.47244,0.90551),(0.48031,0.90551),(0.48819,0.90551),(0.49606,0.90551),(0.50394,0.90551),(0.51181,0.90551),(0.51969,0.90551),(0.52756,0.90551),(0.53543,0.90551),(0.54331,0.90551),(0.55118,0.90551),(0.55906,0.90551),(0.56693,0.90551),(0.5748,0.90551),(0.58268,0.90551),(0.59055,0.90551),(0.59843,0.90551),(0.6063,0.90551),(0.61417,0.90551),(0.62205,0.90551),(0.62992,0.90551),(0.6378,0.90551),(0.64567,0.90551),(0.65354,0.90551),(0.66142,0.90551),(0.66929,0.90551),(0.67717,0.90551),(0.68504,0.90551),(0.69291,0.90551),(0.70079,0.90551),(0.70866,0.90551),(0.71654,0.90551),(0.72441,0.90551),(0.73228,0.90551),(0.74016,0.90551),(0.74803,0.90551),(0.75591,0.90551),(0.76378,0.90551),(0.77165,0.90551),(0.77953,0.90551),(0.7874,0.90551),(0.79528,0.90551),(0.80315,0.90551),(0.81102,0.90551),(0.8189,0.90551),(0.82677,0.90551),(0.83465,0.90551),(0.84252,0.90551),(0.85039,0.90551),(0.85827,0.90551),(0.86614,0.90551),(0.87402,0.90551),(0.88189,0.90551),(0.88976,0.90551),(0.89764,0.90551),(0.90551,0.90551),(0.91339,0.90551),(0.92126,0.90551),(0.92913,0.90551),(0.93701,0.90551),(0.94488,0.90551),(0.95276,0.90551),(0.96063,0.90551),(0.9685,0.90551),(0.97638,0.90551),(0.98425,0.90551),(0.99213,0.90551),(0.99609,0.90551),(0.00391,0.91339),(0.00787,0.91339),(0.01575,0.91339),(0.02362,0.91339),(0.0315,0.91339),(0.03937,0.91339),(0.04724,0.91339),(0.05512,0.91339),(0.06299,0.91339),(0.07087,0.91339),(0.07874,0.91339),(0.08661,0.91339),(0.09449,0.91339),(0.10236,0.91339),(0.11024,0.91339),(0.11811,0.91339),(0.12598,0.91339),(0.13386,0.91339),(0.14173,0.91339),(0.14961,0.91339),(0.15748,0.91339),(0.16535,0.91339),(0.17323,0.91339),(0.1811,0.91339),(0.18898,0.91339),(0.19685,0.91339),(0.20472,0.91339),(0.2126,0.91339),(0.22047,0.91339),(0.22835,0.91339),(0.23622,0.91339),(0.24409,0.91339),(0.25197,0.91339),(0.25984,0.91339),(0.26772,0.91339),(0.27559,0.91339),(0.28346,0.91339),(0.29134,0.91339),(0.29921,0.91339),(0.30709,0.91339),(0.31496,0.91339),(0.32283,0.91339),(0.33071,0.91339),(0.33858,0.91339),(0.34646,0.91339),(0.35433,0.91339),(0.3622,0.91339),(0.37008,0.91339),(0.37795,0.91339),(0.38583,0.91339),(0.3937,0.91339),(0.40157,0.91339),(0.40945,0.91339),(0.41732,0.91339),(0.4252,0.91339),(0.43307,0.91339),(0.44094,0.91339),(0.44882,0.91339),(0.45669,0.91339),(0.46457,0.91339),(0.47244,0.91339),(0.48031,0.91339),(0.48819,0.91339),(0.49606,0.91339),(0.50394,0.91339),(0.51181,0.91339),(0.51969,0.91339),(0.52756,0.91339),(0.53543,0.91339),(0.54331,0.91339),(0.55118,0.91339),(0.55906,0.91339),(0.56693,0.91339),(0.5748,0.91339),(0.58268,0.91339),(0.59055,0.91339),(0.59843,0.91339),(0.6063,0.91339),(0.61417,0.91339),(0.62205,0.91339),(0.62992,0.91339),(0.6378,0.91339),(0.64567,0.91339),(0.65354,0.91339),(0.66142,0.91339),(0.66929,0.91339),(0.67717,0.91339),(0.68504,0.91339),(0.69291,0.91339),(0.70079,0.91339),(0.70866,0.91339),(0.71654,0.91339),(0.72441,0.91339),(0.73228,0.91339),(0.74016,0.91339),(0.74803,0.91339),(0.75591,0.91339),(0.76378,0.91339),(0.77165,0.91339),(0.77953,0.91339),(0.7874,0.91339),(0.79528,0.91339),(0.80315,0.91339),(0.81102,0.91339),(0.8189,0.91339),(0.82677,0.91339),(0.83465,0.91339),(0.84252,0.91339),(0.85039,0.91339),(0.85827,0.91339),(0.86614,0.91339),(0.87402,0.91339),(0.88189,0.91339),(0.88976,0.91339),(0.89764,0.91339),(0.90551,0.91339),(0.91339,0.91339),(0.92126,0.91339),(0.92913,0.91339),(0.93701,0.91339),(0.94488,0.91339),(0.95276,0.91339),(0.96063,0.91339),(0.9685,0.91339),(0.97638,0.91339),(0.98425,0.91339),(0.99213,0.91339),(0.99609,0.91339),(0.00391,0.92126),(0.00787,0.92126),(0.01575,0.92126),(0.02362,0.92126),(0.0315,0.92126),(0.03937,0.92126),(0.04724,0.92126),(0.05512,0.92126),(0.06299,0.92126),(0.07087,0.92126),(0.07874,0.92126),(0.08661,0.92126),(0.09449,0.92126),(0.10236,0.92126),(0.11024,0.92126),(0.11811,0.92126),(0.12598,0.92126),(0.13386,0.92126),(0.14173,0.92126),(0.14961,0.92126),(0.15748,0.92126),(0.16535,0.92126),(0.17323,0.92126),(0.1811,0.92126),(0.18898,0.92126),(0.19685,0.92126),(0.20472,0.92126),(0.2126,0.92126),(0.22047,0.92126),(0.22835,0.92126),(0.23622,0.92126),(0.24409,0.92126),(0.25197,0.92126),(0.25984,0.92126),(0.26772,0.92126),(0.27559,0.92126),(0.28346,0.92126),(0.29134,0.92126),(0.29921,0.92126),(0.30709,0.92126),(0.31496,0.92126),(0.32283,0.92126),(0.33071,0.92126),(0.33858,0.92126),(0.34646,0.92126),(0.35433,0.92126),(0.3622,0.92126),(0.37008,0.92126),(0.37795,0.92126),(0.38583,0.92126),(0.3937,0.92126),(0.40157,0.92126),(0.40945,0.92126),(0.41732,0.92126),(0.4252,0.92126),(0.43307,0.92126),(0.44094,0.92126),(0.44882,0.92126),(0.45669,0.92126),(0.46457,0.92126),(0.47244,0.92126),(0.48031,0.92126),(0.48819,0.92126),(0.49606,0.92126),(0.50394,0.92126),(0.51181,0.92126),(0.51969,0.92126),(0.52756,0.92126),(0.53543,0.92126),(0.54331,0.92126),(0.55118,0.92126),(0.55906,0.92126),(0.56693,0.92126),(0.5748,0.92126),(0.58268,0.92126),(0.59055,0.92126),(0.59843,0.92126),(0.6063,0.92126),(0.61417,0.92126),(0.62205,0.92126),(0.62992,0.92126),(0.6378,0.92126),(0.64567,0.92126),(0.65354,0.92126),(0.66142,0.92126),(0.66929,0.92126),(0.67717,0.92126),(0.68504,0.92126),(0.69291,0.92126),(0.70079,0.92126),(0.70866,0.92126),(0.71654,0.92126),(0.72441,0.92126),(0.73228,0.92126),(0.74016,0.92126),(0.74803,0.92126),(0.75591,0.92126),(0.76378,0.92126),(0.77165,0.92126),(0.77953,0.92126),(0.7874,0.92126),(0.79528,0.92126),(0.80315,0.92126),(0.81102,0.92126),(0.8189,0.92126),(0.82677,0.92126),(0.83465,0.92126),(0.84252,0.92126),(0.85039,0.92126),(0.85827,0.92126),(0.86614,0.92126),(0.87402,0.92126),(0.88189,0.92126),(0.88976,0.92126),(0.89764,0.92126),(0.90551,0.92126),(0.91339,0.92126),(0.92126,0.92126),(0.92913,0.92126),(0.93701,0.92126),(0.94488,0.92126),(0.95276,0.92126),(0.96063,0.92126),(0.9685,0.92126),(0.97638,0.92126),(0.98425,0.92126),(0.99213,0.92126),(0.99609,0.92126),(0.00391,0.92913),(0.00787,0.92913),(0.01575,0.92913),(0.02362,0.92913),(0.0315,0.92913),(0.03937,0.92913),(0.04724,0.92913),(0.05512,0.92913),(0.06299,0.92913),(0.07087,0.92913),(0.07874,0.92913),(0.08661,0.92913),(0.09449,0.92913),(0.10236,0.92913),(0.11024,0.92913),(0.11811,0.92913),(0.12598,0.92913),(0.13386,0.92913),(0.14173,0.92913),(0.14961,0.92913),(0.15748,0.92913),(0.16535,0.92913),(0.17323,0.92913),(0.1811,0.92913),(0.18898,0.92913),(0.19685,0.92913),(0.20472,0.92913),(0.2126,0.92913),(0.22047,0.92913),(0.22835,0.92913),(0.23622,0.92913),(0.24409,0.92913),(0.25197,0.92913),(0.25984,0.92913),(0.26772,0.92913),(0.27559,0.92913),(0.28346,0.92913),(0.29134,0.92913),(0.29921,0.92913),(0.30709,0.92913),(0.31496,0.92913),(0.32283,0.92913),(0.33071,0.92913),(0.33858,0.92913),(0.34646,0.92913),(0.35433,0.92913),(0.3622,0.92913),(0.37008,0.92913),(0.37795,0.92913),(0.38583,0.92913),(0.3937,0.92913),(0.40157,0.92913),(0.40945,0.92913),(0.41732,0.92913),(0.4252,0.92913),(0.43307,0.92913),(0.44094,0.92913),(0.44882,0.92913),(0.45669,0.92913),(0.46457,0.92913),(0.47244,0.92913),(0.48031,0.92913),(0.48819,0.92913),(0.49606,0.92913),(0.50394,0.92913),(0.51181,0.92913),(0.51969,0.92913),(0.52756,0.92913),(0.53543,0.92913),(0.54331,0.92913),(0.55118,0.92913),(0.55906,0.92913),(0.56693,0.92913),(0.5748,0.92913),(0.58268,0.92913),(0.59055,0.92913),(0.59843,0.92913),(0.6063,0.92913),(0.61417,0.92913),(0.62205,0.92913),(0.62992,0.92913),(0.6378,0.92913),(0.64567,0.92913),(0.65354,0.92913),(0.66142,0.92913),(0.66929,0.92913),(0.67717,0.92913),(0.68504,0.92913),(0.69291,0.92913),(0.70079,0.92913),(0.70866,0.92913),(0.71654,0.92913),(0.72441,0.92913),(0.73228,0.92913),(0.74016,0.92913),(0.74803,0.92913),(0.75591,0.92913),(0.76378,0.92913),(0.77165,0.92913),(0.77953,0.92913),(0.7874,0.92913),(0.79528,0.92913),(0.80315,0.92913),(0.81102,0.92913),(0.8189,0.92913),(0.82677,0.92913),(0.83465,0.92913),(0.84252,0.92913),(0.85039,0.92913),(0.85827,0.92913),(0.86614,0.92913),(0.87402,0.92913),(0.88189,0.92913),(0.88976,0.92913),(0.89764,0.92913),(0.90551,0.92913),(0.91339,0.92913),(0.92126,0.92913),(0.92913,0.92913),(0.93701,0.92913),(0.94488,0.92913),(0.95276,0.92913),(0.96063,0.92913),(0.9685,0.92913),(0.97638,0.92913),(0.98425,0.92913),(0.99213,0.92913),(0.99609,0.92913),(0.00391,0.93701),(0.00787,0.93701),(0.01575,0.93701),(0.02362,0.93701),(0.0315,0.93701),(0.03937,0.93701),(0.04724,0.93701),(0.05512,0.93701),(0.06299,0.93701),(0.07087,0.93701),(0.07874,0.93701),(0.08661,0.93701),(0.09449,0.93701),(0.10236,0.93701),(0.11024,0.93701),(0.11811,0.93701),(0.12598,0.93701),(0.13386,0.93701),(0.14173,0.93701),(0.14961,0.93701),(0.15748,0.93701),(0.16535,0.93701),(0.17323,0.93701),(0.1811,0.93701),(0.18898,0.93701),(0.19685,0.93701),(0.20472,0.93701),(0.2126,0.93701),(0.22047,0.93701),(0.22835,0.93701),(0.23622,0.93701),(0.24409,0.93701),(0.25197,0.93701),(0.25984,0.93701),(0.26772,0.93701),(0.27559,0.93701),(0.28346,0.93701),(0.29134,0.93701),(0.29921,0.93701),(0.30709,0.93701),(0.31496,0.93701),(0.32283,0.93701),(0.33071,0.93701),(0.33858,0.93701),(0.34646,0.93701),(0.35433,0.93701),(0.3622,0.93701),(0.37008,0.93701),(0.37795,0.93701),(0.38583,0.93701),(0.3937,0.93701),(0.40157,0.93701),(0.40945,0.93701),(0.41732,0.93701),(0.4252,0.93701),(0.43307,0.93701),(0.44094,0.93701),(0.44882,0.93701),(0.45669,0.93701),(0.46457,0.93701),(0.47244,0.93701),(0.48031,0.93701),(0.48819,0.93701),(0.49606,0.93701),(0.50394,0.93701),(0.51181,0.93701),(0.51969,0.93701),(0.52756,0.93701),(0.53543,0.93701),(0.54331,0.93701),(0.55118,0.93701),(0.55906,0.93701),(0.56693,0.93701),(0.5748,0.93701),(0.58268,0.93701),(0.59055,0.93701),(0.59843,0.93701),(0.6063,0.93701),(0.61417,0.93701),(0.62205,0.93701),(0.62992,0.93701),(0.6378,0.93701),(0.64567,0.93701),(0.65354,0.93701),(0.66142,0.93701),(0.66929,0.93701),(0.67717,0.93701),(0.68504,0.93701),(0.69291,0.93701),(0.70079,0.93701),(0.70866,0.93701),(0.71654,0.93701),(0.72441,0.93701),(0.73228,0.93701),(0.74016,0.93701),(0.74803,0.93701),(0.75591,0.93701),(0.76378,0.93701),(0.77165,0.93701),(0.77953,0.93701),(0.7874,0.93701),(0.79528,0.93701),(0.80315,0.93701),(0.81102,0.93701),(0.8189,0.93701),(0.82677,0.93701),(0.83465,0.93701),(0.84252,0.93701),(0.85039,0.93701),(0.85827,0.93701),(0.86614,0.93701),(0.87402,0.93701),(0.88189,0.93701),(0.88976,0.93701),(0.89764,0.93701),(0.90551,0.93701),(0.91339,0.93701),(0.92126,0.93701),(0.92913,0.93701),(0.93701,0.93701),(0.94488,0.93701),(0.95276,0.93701),(0.96063,0.93701),(0.9685,0.93701),(0.97638,0.93701),(0.98425,0.93701),(0.99213,0.93701),(0.99609,0.93701),(0.00391,0.94488),(0.00787,0.94488),(0.01575,0.94488),(0.02362,0.94488),(0.0315,0.94488),(0.03937,0.94488),(0.04724,0.94488),(0.05512,0.94488),(0.06299,0.94488),(0.07087,0.94488),(0.07874,0.94488),(0.08661,0.94488),(0.09449,0.94488),(0.10236,0.94488),(0.11024,0.94488),(0.11811,0.94488),(0.12598,0.94488),(0.13386,0.94488),(0.14173,0.94488),(0.14961,0.94488),(0.15748,0.94488),(0.16535,0.94488),(0.17323,0.94488),(0.1811,0.94488),(0.18898,0.94488),(0.19685,0.94488),(0.20472,0.94488),(0.2126,0.94488),(0.22047,0.94488),(0.22835,0.94488),(0.23622,0.94488),(0.24409,0.94488),(0.25197,0.94488),(0.25984,0.94488),(0.26772,0.94488),(0.27559,0.94488),(0.28346,0.94488),(0.29134,0.94488),(0.29921,0.94488),(0.30709,0.94488),(0.31496,0.94488),(0.32283,0.94488),(0.33071,0.94488),(0.33858,0.94488),(0.34646,0.94488),(0.35433,0.94488),(0.3622,0.94488),(0.37008,0.94488),(0.37795,0.94488),(0.38583,0.94488),(0.3937,0.94488),(0.40157,0.94488),(0.40945,0.94488),(0.41732,0.94488),(0.4252,0.94488),(0.43307,0.94488),(0.44094,0.94488),(0.44882,0.94488),(0.45669,0.94488),(0.46457,0.94488),(0.47244,0.94488),(0.48031,0.94488),(0.48819,0.94488),(0.49606,0.94488),(0.50394,0.94488),(0.51181,0.94488),(0.51969,0.94488),(0.52756,0.94488),(0.53543,0.94488),(0.54331,0.94488),(0.55118,0.94488),(0.55906,0.94488),(0.56693,0.94488),(0.5748,0.94488),(0.58268,0.94488),(0.59055,0.94488),(0.59843,0.94488),(0.6063,0.94488),(0.61417,0.94488),(0.62205,0.94488),(0.62992,0.94488),(0.6378,0.94488),(0.64567,0.94488),(0.65354,0.94488),(0.66142,0.94488),(0.66929,0.94488),(0.67717,0.94488),(0.68504,0.94488),(0.69291,0.94488),(0.70079,0.94488),(0.70866,0.94488),(0.71654,0.94488),(0.72441,0.94488),(0.73228,0.94488),(0.74016,0.94488),(0.74803,0.94488),(0.75591,0.94488),(0.76378,0.94488),(0.77165,0.94488),(0.77953,0.94488),(0.7874,0.94488),(0.79528,0.94488),(0.80315,0.94488),(0.81102,0.94488),(0.8189,0.94488),(0.82677,0.94488),(0.83465,0.94488),(0.84252,0.94488),(0.85039,0.94488),(0.85827,0.94488),(0.86614,0.94488),(0.87402,0.94488),(0.88189,0.94488),(0.88976,0.94488),(0.89764,0.94488),(0.90551,0.94488),(0.91339,0.94488),(0.92126,0.94488),(0.92913,0.94488),(0.93701,0.94488),(0.94488,0.94488),(0.95276,0.94488),(0.96063,0.94488),(0.9685,0.94488),(0.97638,0.94488),(0.98425,0.94488),(0.99213,0.94488),(0.99609,0.94488),(0.00391,0.95276),(0.00787,0.95276),(0.01575,0.95276),(0.02362,0.95276),(0.0315,0.95276),(0.03937,0.95276),(0.04724,0.95276),(0.05512,0.95276),(0.06299,0.95276),(0.07087,0.95276),(0.07874,0.95276),(0.08661,0.95276),(0.09449,0.95276),(0.10236,0.95276),(0.11024,0.95276),(0.11811,0.95276),(0.12598,0.95276),(0.13386,0.95276),(0.14173,0.95276),(0.14961,0.95276),(0.15748,0.95276),(0.16535,0.95276),(0.17323,0.95276),(0.1811,0.95276),(0.18898,0.95276),(0.19685,0.95276),(0.20472,0.95276),(0.2126,0.95276),(0.22047,0.95276),(0.22835,0.95276),(0.23622,0.95276),(0.24409,0.95276),(0.25197,0.95276),(0.25984,0.95276),(0.26772,0.95276),(0.27559,0.95276),(0.28346,0.95276),(0.29134,0.95276),(0.29921,0.95276),(0.30709,0.95276),(0.31496,0.95276),(0.32283,0.95276),(0.33071,0.95276),(0.33858,0.95276),(0.34646,0.95276),(0.35433,0.95276),(0.3622,0.95276),(0.37008,0.95276),(0.37795,0.95276),(0.38583,0.95276),(0.3937,0.95276),(0.40157,0.95276),(0.40945,0.95276),(0.41732,0.95276),(0.4252,0.95276),(0.43307,0.95276),(0.44094,0.95276),(0.44882,0.95276),(0.45669,0.95276),(0.46457,0.95276),(0.47244,0.95276),(0.48031,0.95276),(0.48819,0.95276),(0.49606,0.95276),(0.50394,0.95276),(0.51181,0.95276),(0.51969,0.95276),(0.52756,0.95276),(0.53543,0.95276),(0.54331,0.95276),(0.55118,0.95276),(0.55906,0.95276),(0.56693,0.95276),(0.5748,0.95276),(0.58268,0.95276),(0.59055,0.95276),(0.59843,0.95276),(0.6063,0.95276),(0.61417,0.95276),(0.62205,0.95276),(0.62992,0.95276),(0.6378,0.95276),(0.64567,0.95276),(0.65354,0.95276),(0.66142,0.95276),(0.66929,0.95276),(0.67717,0.95276),(0.68504,0.95276),(0.69291,0.95276),(0.70079,0.95276),(0.70866,0.95276),(0.71654,0.95276),(0.72441,0.95276),(0.73228,0.95276),(0.74016,0.95276),(0.74803,0.95276),(0.75591,0.95276),(0.76378,0.95276),(0.77165,0.95276),(0.77953,0.95276),(0.7874,0.95276),(0.79528,0.95276),(0.80315,0.95276),(0.81102,0.95276),(0.8189,0.95276),(0.82677,0.95276),(0.83465,0.95276),(0.84252,0.95276),(0.85039,0.95276),(0.85827,0.95276),(0.86614,0.95276),(0.87402,0.95276),(0.88189,0.95276),(0.88976,0.95276),(0.89764,0.95276),(0.90551,0.95276),(0.91339,0.95276),(0.92126,0.95276),(0.92913,0.95276),(0.93701,0.95276),(0.94488,0.95276),(0.95276,0.95276),(0.96063,0.95276),(0.9685,0.95276),(0.97638,0.95276),(0.98425,0.95276),(0.99213,0.95276),(0.99609,0.95276),(0.00391,0.96063),(0.00787,0.96063),(0.01575,0.96063),(0.02362,0.96063),(0.0315,0.96063),(0.03937,0.96063),(0.04724,0.96063),(0.05512,0.96063),(0.06299,0.96063),(0.07087,0.96063),(0.07874,0.96063),(0.08661,0.96063),(0.09449,0.96063),(0.10236,0.96063),(0.11024,0.96063),(0.11811,0.96063),(0.12598,0.96063),(0.13386,0.96063),(0.14173,0.96063),(0.14961,0.96063),(0.15748,0.96063),(0.16535,0.96063),(0.17323,0.96063),(0.1811,0.96063),(0.18898,0.96063),(0.19685,0.96063),(0.20472,0.96063),(0.2126,0.96063),(0.22047,0.96063),(0.22835,0.96063),(0.23622,0.96063),(0.24409,0.96063),(0.25197,0.96063),(0.25984,0.96063),(0.26772,0.96063),(0.27559,0.96063),(0.28346,0.96063),(0.29134,0.96063),(0.29921,0.96063),(0.30709,0.96063),(0.31496,0.96063),(0.32283,0.96063),(0.33071,0.96063),(0.33858,0.96063),(0.34646,0.96063),(0.35433,0.96063),(0.3622,0.96063),(0.37008,0.96063),(0.37795,0.96063),(0.38583,0.96063),(0.3937,0.96063),(0.40157,0.96063),(0.40945,0.96063),(0.41732,0.96063),(0.4252,0.96063),(0.43307,0.96063),(0.44094,0.96063),(0.44882,0.96063),(0.45669,0.96063),(0.46457,0.96063),(0.47244,0.96063),(0.48031,0.96063),(0.48819,0.96063),(0.49606,0.96063),(0.50394,0.96063),(0.51181,0.96063),(0.51969,0.96063),(0.52756,0.96063),(0.53543,0.96063),(0.54331,0.96063),(0.55118,0.96063),(0.55906,0.96063),(0.56693,0.96063),(0.5748,0.96063),(0.58268,0.96063),(0.59055,0.96063),(0.59843,0.96063),(0.6063,0.96063),(0.61417,0.96063),(0.62205,0.96063),(0.62992,0.96063),(0.6378,0.96063),(0.64567,0.96063),(0.65354,0.96063),(0.66142,0.96063),(0.66929,0.96063),(0.67717,0.96063),(0.68504,0.96063),(0.69291,0.96063),(0.70079,0.96063),(0.70866,0.96063),(0.71654,0.96063),(0.72441,0.96063),(0.73228,0.96063),(0.74016,0.96063),(0.74803,0.96063),(0.75591,0.96063),(0.76378,0.96063),(0.77165,0.96063),(0.77953,0.96063),(0.7874,0.96063),(0.79528,0.96063),(0.80315,0.96063),(0.81102,0.96063),(0.8189,0.96063),(0.82677,0.96063),(0.83465,0.96063),(0.84252,0.96063),(0.85039,0.96063),(0.85827,0.96063),(0.86614,0.96063),(0.87402,0.96063),(0.88189,0.96063),(0.88976,0.96063),(0.89764,0.96063),(0.90551,0.96063),(0.91339,0.96063),(0.92126,0.96063),(0.92913,0.96063),(0.93701,0.96063),(0.94488,0.96063),(0.95276,0.96063),(0.96063,0.96063),(0.9685,0.96063),(0.97638,0.96063),(0.98425,0.96063),(0.99213,0.96063),(0.99609,0.96063),(0.00391,0.9685),(0.00787,0.9685),(0.01575,0.9685),(0.02362,0.9685),(0.0315,0.9685),(0.03937,0.9685),(0.04724,0.9685),(0.05512,0.9685),(0.06299,0.9685),(0.07087,0.9685),(0.07874,0.9685),(0.08661,0.9685),(0.09449,0.9685),(0.10236,0.9685),(0.11024,0.9685),(0.11811,0.9685),(0.12598,0.9685),(0.13386,0.9685),(0.14173,0.9685),(0.14961,0.9685),(0.15748,0.9685),(0.16535,0.9685),(0.17323,0.9685),(0.1811,0.9685),(0.18898,0.9685),(0.19685,0.9685),(0.20472,0.9685),(0.2126,0.9685),(0.22047,0.9685),(0.22835,0.9685),(0.23622,0.9685),(0.24409,0.9685),(0.25197,0.9685),(0.25984,0.9685),(0.26772,0.9685),(0.27559,0.9685),(0.28346,0.9685),(0.29134,0.9685),(0.29921,0.9685),(0.30709,0.9685),(0.31496,0.9685),(0.32283,0.9685),(0.33071,0.9685),(0.33858,0.9685),(0.34646,0.9685),(0.35433,0.9685),(0.3622,0.9685),(0.37008,0.9685),(0.37795,0.9685),(0.38583,0.9685),(0.3937,0.9685),(0.40157,0.9685),(0.40945,0.9685),(0.41732,0.9685),(0.4252,0.9685),(0.43307,0.9685),(0.44094,0.9685),(0.44882,0.9685),(0.45669,0.9685),(0.46457,0.9685),(0.47244,0.9685),(0.48031,0.9685),(0.48819,0.9685),(0.49606,0.9685),(0.50394,0.9685),(0.51181,0.9685),(0.51969,0.9685),(0.52756,0.9685),(0.53543,0.9685),(0.54331,0.9685),(0.55118,0.9685),(0.55906,0.9685),(0.56693,0.9685),(0.5748,0.9685),(0.58268,0.9685),(0.59055,0.9685),(0.59843,0.9685),(0.6063,0.9685),(0.61417,0.9685),(0.62205,0.9685),(0.62992,0.9685),(0.6378,0.9685),(0.64567,0.9685),(0.65354,0.9685),(0.66142,0.9685),(0.66929,0.9685),(0.67717,0.9685),(0.68504,0.9685),(0.69291,0.9685),(0.70079,0.9685),(0.70866,0.9685),(0.71654,0.9685),(0.72441,0.9685),(0.73228,0.9685),(0.74016,0.9685),(0.74803,0.9685),(0.75591,0.9685),(0.76378,0.9685),(0.77165,0.9685),(0.77953,0.9685),(0.7874,0.9685),(0.79528,0.9685),(0.80315,0.9685),(0.81102,0.9685),(0.8189,0.9685),(0.82677,0.9685),(0.83465,0.9685),(0.84252,0.9685),(0.85039,0.9685),(0.85827,0.9685),(0.86614,0.9685),(0.87402,0.9685),(0.88189,0.9685),(0.88976,0.9685),(0.89764,0.9685),(0.90551,0.9685),(0.91339,0.9685),(0.92126,0.9685),(0.92913,0.9685),(0.93701,0.9685),(0.94488,0.9685),(0.95276,0.9685),(0.96063,0.9685),(0.9685,0.9685),(0.97638,0.9685),(0.98425,0.9685),(0.99213,0.9685),(0.99609,0.9685),(0.00391,0.97638),(0.00787,0.97638),(0.01575,0.97638),(0.02362,0.97638),(0.0315,0.97638),(0.03937,0.97638),(0.04724,0.97638),(0.05512,0.97638),(0.06299,0.97638),(0.07087,0.97638),(0.07874,0.97638),(0.08661,0.97638),(0.09449,0.97638),(0.10236,0.97638),(0.11024,0.97638),(0.11811,0.97638),(0.12598,0.97638),(0.13386,0.97638),(0.14173,0.97638),(0.14961,0.97638),(0.15748,0.97638),(0.16535,0.97638),(0.17323,0.97638),(0.1811,0.97638),(0.18898,0.97638),(0.19685,0.97638),(0.20472,0.97638),(0.2126,0.97638),(0.22047,0.97638),(0.22835,0.97638),(0.23622,0.97638),(0.24409,0.97638),(0.25197,0.97638),(0.25984,0.97638),(0.26772,0.97638),(0.27559,0.97638),(0.28346,0.97638),(0.29134,0.97638),(0.29921,0.97638),(0.30709,0.97638),(0.31496,0.97638),(0.32283,0.97638),(0.33071,0.97638),(0.33858,0.97638),(0.34646,0.97638),(0.35433,0.97638),(0.3622,0.97638),(0.37008,0.97638),(0.37795,0.97638),(0.38583,0.97638),(0.3937,0.97638),(0.40157,0.97638),(0.40945,0.97638),(0.41732,0.97638),(0.4252,0.97638),(0.43307,0.97638),(0.44094,0.97638),(0.44882,0.97638),(0.45669,0.97638),(0.46457,0.97638),(0.47244,0.97638),(0.48031,0.97638),(0.48819,0.97638),(0.49606,0.97638),(0.50394,0.97638),(0.51181,0.97638),(0.51969,0.97638),(0.52756,0.97638),(0.53543,0.97638),(0.54331,0.97638),(0.55118,0.97638),(0.55906,0.97638),(0.56693,0.97638),(0.5748,0.97638),(0.58268,0.97638),(0.59055,0.97638),(0.59843,0.97638),(0.6063,0.97638),(0.61417,0.97638),(0.62205,0.97638),(0.62992,0.97638),(0.6378,0.97638),(0.64567,0.97638),(0.65354,0.97638),(0.66142,0.97638),(0.66929,0.97638),(0.67717,0.97638),(0.68504,0.97638),(0.69291,0.97638),(0.70079,0.97638),(0.70866,0.97638),(0.71654,0.97638),(0.72441,0.97638),(0.73228,0.97638),(0.74016,0.97638),(0.74803,0.97638),(0.75591,0.97638),(0.76378,0.97638),(0.77165,0.97638),(0.77953,0.97638),(0.7874,0.97638),(0.79528,0.97638),(0.80315,0.97638),(0.81102,0.97638),(0.8189,0.97638),(0.82677,0.97638),(0.83465,0.97638),(0.84252,0.97638),(0.85039,0.97638),(0.85827,0.97638),(0.86614,0.97638),(0.87402,0.97638),(0.88189,0.97638),(0.88976,0.97638),(0.89764,0.97638),(0.90551,0.97638),(0.91339,0.97638),(0.92126,0.97638),(0.92913,0.97638),(0.93701,0.97638),(0.94488,0.97638),(0.95276,0.97638),(0.96063,0.97638),(0.9685,0.97638),(0.97638,0.97638),(0.98425,0.97638),(0.99213,0.97638),(0.99609,0.97638),(0.00391,0.98425),(0.00787,0.98425),(0.01575,0.98425),(0.02362,0.98425),(0.0315,0.98425),(0.03937,0.98425),(0.04724,0.98425),(0.05512,0.98425),(0.06299,0.98425),(0.07087,0.98425),(0.07874,0.98425),(0.08661,0.98425),(0.09449,0.98425),(0.10236,0.98425),(0.11024,0.98425),(0.11811,0.98425),(0.12598,0.98425),(0.13386,0.98425),(0.14173,0.98425),(0.14961,0.98425),(0.15748,0.98425),(0.16535,0.98425),(0.17323,0.98425),(0.1811,0.98425),(0.18898,0.98425),(0.19685,0.98425),(0.20472,0.98425),(0.2126,0.98425),(0.22047,0.98425),(0.22835,0.98425),(0.23622,0.98425),(0.24409,0.98425),(0.25197,0.98425),(0.25984,0.98425),(0.26772,0.98425),(0.27559,0.98425),(0.28346,0.98425),(0.29134,0.98425),(0.29921,0.98425),(0.30709,0.98425),(0.31496,0.98425),(0.32283,0.98425),(0.33071,0.98425),(0.33858,0.98425),(0.34646,0.98425),(0.35433,0.98425),(0.3622,0.98425),(0.37008,0.98425),(0.37795,0.98425),(0.38583,0.98425),(0.3937,0.98425),(0.40157,0.98425),(0.40945,0.98425),(0.41732,0.98425),(0.4252,0.98425),(0.43307,0.98425),(0.44094,0.98425),(0.44882,0.98425),(0.45669,0.98425),(0.46457,0.98425),(0.47244,0.98425),(0.48031,0.98425),(0.48819,0.98425),(0.49606,0.98425),(0.50394,0.98425),(0.51181,0.98425),(0.51969,0.98425),(0.52756,0.98425),(0.53543,0.98425),(0.54331,0.98425),(0.55118,0.98425),(0.55906,0.98425),(0.56693,0.98425),(0.5748,0.98425),(0.58268,0.98425),(0.59055,0.98425),(0.59843,0.98425),(0.6063,0.98425),(0.61417,0.98425),(0.62205,0.98425),(0.62992,0.98425),(0.6378,0.98425),(0.64567,0.98425),(0.65354,0.98425),(0.66142,0.98425),(0.66929,0.98425),(0.67717,0.98425),(0.68504,0.98425),(0.69291,0.98425),(0.70079,0.98425),(0.70866,0.98425),(0.71654,0.98425),(0.72441,0.98425),(0.73228,0.98425),(0.74016,0.98425),(0.74803,0.98425),(0.75591,0.98425),(0.76378,0.98425),(0.77165,0.98425),(0.77953,0.98425),(0.7874,0.98425),(0.79528,0.98425),(0.80315,0.98425),(0.81102,0.98425),(0.8189,0.98425),(0.82677,0.98425),(0.83465,0.98425),(0.84252,0.98425),(0.85039,0.98425),(0.85827,0.98425),(0.86614,0.98425),(0.87402,0.98425),(0.88189,0.98425),(0.88976,0.98425),(0.89764,0.98425),(0.90551,0.98425),(0.91339,0.98425),(0.92126,0.98425),(0.92913,0.98425),(0.93701,0.98425),(0.94488,0.98425),(0.95276,0.98425),(0.96063,0.98425),(0.9685,0.98425),(0.97638,0.98425),(0.98425,0.98425),(0.99213,0.98425),(0.99609,0.98425),(0.00391,0.99213),(0.00787,0.99213),(0.01575,0.99213),(0.02362,0.99213),(0.0315,0.99213),(0.03937,0.99213),(0.04724,0.99213),(0.05512,0.99213),(0.06299,0.99213),(0.07087,0.99213),(0.07874,0.99213),(0.08661,0.99213),(0.09449,0.99213),(0.10236,0.99213),(0.11024,0.99213),(0.11811,0.99213),(0.12598,0.99213),(0.13386,0.99213),(0.14173,0.99213),(0.14961,0.99213),(0.15748,0.99213),(0.16535,0.99213),(0.17323,0.99213),(0.1811,0.99213),(0.18898,0.99213),(0.19685,0.99213),(0.20472,0.99213),(0.2126,0.99213),(0.22047,0.99213),(0.22835,0.99213),(0.23622,0.99213),(0.24409,0.99213),(0.25197,0.99213),(0.25984,0.99213),(0.26772,0.99213),(0.27559,0.99213),(0.28346,0.99213),(0.29134,0.99213),(0.29921,0.99213),(0.30709,0.99213),(0.31496,0.99213),(0.32283,0.99213),(0.33071,0.99213),(0.33858,0.99213),(0.34646,0.99213),(0.35433,0.99213),(0.3622,0.99213),(0.37008,0.99213),(0.37795,0.99213),(0.38583,0.99213),(0.3937,0.99213),(0.40157,0.99213),(0.40945,0.99213),(0.41732,0.99213),(0.4252,0.99213),(0.43307,0.99213),(0.44094,0.99213),(0.44882,0.99213),(0.45669,0.99213),(0.46457,0.99213),(0.47244,0.99213),(0.48031,0.99213),(0.48819,0.99213),(0.49606,0.99213),(0.50394,0.99213),(0.51181,0.99213),(0.51969,0.99213),(0.52756,0.99213),(0.53543,0.99213),(0.54331,0.99213),(0.55118,0.99213),(0.55906,0.99213),(0.56693,0.99213),(0.5748,0.99213),(0.58268,0.99213),(0.59055,0.99213),(0.59843,0.99213),(0.6063,0.99213),(0.61417,0.99213),(0.62205,0.99213),(0.62992,0.99213),(0.6378,0.99213),(0.64567,0.99213),(0.65354,0.99213),(0.66142,0.99213),(0.66929,0.99213),(0.67717,0.99213),(0.68504,0.99213),(0.69291,0.99213),(0.70079,0.99213),(0.70866,0.99213),(0.71654,0.99213),(0.72441,0.99213),(0.73228,0.99213),(0.74016,0.99213),(0.74803,0.99213),(0.75591,0.99213),(0.76378,0.99213),(0.77165,0.99213),(0.77953,0.99213),(0.7874,0.99213),(0.79528,0.99213),(0.80315,0.99213),(0.81102,0.99213),(0.8189,0.99213),(0.82677,0.99213),(0.83465,0.99213),(0.84252,0.99213),(0.85039,0.99213),(0.85827,0.99213),(0.86614,0.99213),(0.87402,0.99213),(0.88189,0.99213),(0.88976,0.99213),(0.89764,0.99213),(0.90551,0.99213),(0.91339,0.99213),(0.92126,0.99213),(0.92913,0.99213),(0.93701,0.99213),(0.94488,0.99213),(0.95276,0.99213),(0.96063,0.99213),(0.9685,0.99213),(0.97638,0.99213),(0.98425,0.99213),(0.99213,0.99213),(0.99609,0.99213),(0.00391,0.99609),(0.00787,0.99609),(0.01575,0.99609),(0.02362,0.99609),(0.0315,0.99609),(0.03937,0.99609),(0.04724,0.99609),(0.05512,0.99609),(0.06299,0.99609),(0.07087,0.99609),(0.07874,0.99609),(0.08661,0.99609),(0.09449,0.99609),(0.10236,0.99609),(0.11024,0.99609),(0.11811,0.99609),(0.12598,0.99609),(0.13386,0.99609),(0.14173,0.99609),(0.14961,0.99609),(0.15748,0.99609),(0.16535,0.99609),(0.17323,0.99609),(0.1811,0.99609),(0.18898,0.99609),(0.19685,0.99609),(0.20472,0.99609),(0.2126,0.99609),(0.22047,0.99609),(0.22835,0.99609),(0.23622,0.99609),(0.24409,0.99609),(0.25197,0.99609),(0.25984,0.99609),(0.26772,0.99609),(0.27559,0.99609),(0.28346,0.99609),(0.29134,0.99609),(0.29921,0.99609),(0.30709,0.99609),(0.31496,0.99609),(0.32283,0.99609),(0.33071,0.99609),(0.33858,0.99609),(0.34646,0.99609),(0.35433,0.99609),(0.3622,0.99609),(0.37008,0.99609),(0.37795,0.99609),(0.38583,0.99609),(0.3937,0.99609),(0.40157,0.99609),(0.40945,0.99609),(0.41732,0.99609),(0.4252,0.99609),(0.43307,0.99609),(0.44094,0.99609),(0.44882,0.99609),(0.45669,0.99609),(0.46457,0.99609),(0.47244,0.99609),(0.48031,0.99609),(0.48819,0.99609),(0.49606,0.99609),(0.50394,0.99609),(0.51181,0.99609),(0.51969,0.99609),(0.52756,0.99609),(0.53543,0.99609),(0.54331,0.99609),(0.55118,0.99609),(0.55906,0.99609),(0.56693,0.99609),(0.5748,0.99609),(0.58268,0.99609),(0.59055,0.99609),(0.59843,0.99609),(0.6063,0.99609),(0.61417,0.99609),(0.62205,0.99609),(0.62992,0.99609),(0.6378,0.99609),(0.64567,0.99609),(0.65354,0.99609),(0.66142,0.99609),(0.66929,0.99609),(0.67717,0.99609),(0.68504,0.99609),(0.69291,0.99609),(0.70079,0.99609),(0.70866,0.99609),(0.71654,0.99609),(0.72441,0.99609),(0.73228,0.99609),(0.74016,0.99609),(0.74803,0.99609),(0.75591,0.99609),(0.76378,0.99609),(0.77165,0.99609),(0.77953,0.99609),(0.7874,0.99609),(0.79528,0.99609),(0.80315,0.99609),(0.81102,0.99609),(0.8189,0.99609),(0.82677,0.99609),(0.83465,0.99609),(0.84252,0.99609),(0.85039,0.99609),(0.85827,0.99609),(0.86614,0.99609),(0.87402,0.99609),(0.88189,0.99609),(0.88976,0.99609),(0.89764,0.99609),(0.90551,0.99609),(0.91339,0.99609),(0.92126,0.99609),(0.92913,0.99609),(0.93701,0.99609),(0.94488,0.99609),(0.95276,0.99609),(0.96063,0.99609),(0.9685,0.99609),(0.97638,0.99609),(0.98425,0.99609),(0.99213,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MarsLOD002.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MarsLOD002.py load and self-test diagnostics complete.")
