package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD001Index.html" target="_blank">MarsLOD001</a>,  source <a href="../../../Geospatial/MarsLOD001.java">MarsLOD001.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD001.x3d">MarsLOD001.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD001.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD001.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD001
{
	/** Default constructor to create this object. */
	public MarsLOD001 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD001.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD001.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD001.x3d"))
    .addChild(new GeoLOD().setCenter(-44.940476,-134.940476,333425.000000).setRange(1.8E7).setChild1Url(new String[] {"MarsLOD002.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD002.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars000.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars000.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(-90.000000,-180.000000,0.000000).setSolid(false).setXDimension(64).setXSpacing(1.428571).setYScale(50.0).setZDimension(64).setZSpacing(1.428571).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {3195.6257,3194.2856,3307.3298,3441.7346,3470.016,3364.8542,3168.3135,2988.494,2897.5835,2914.471,2936.8083,2945.6682,2913.6833,2904.8623,2852.946,2834.809,2868.7366,2885.2693,2888.688,2838.8345,2846.663,2823.6753,2833.1553,2822.6235,2830.2537,2844.6287,2864.9993,2882.1042,2892.1956,2909.0063,2886.8691,2862.0708,2846.2393,2849.1238,2868.625,2861.8606,2877.7417,2890.2266,2899.671,2887.1213,2900.053,2926.0466,2949.4377,2877.9106,2855.2507,2907.9072,2912.252,2904.271,2923.9556,2946.61,2967.8748,2972.701,2977.6763,2950.1296,2961.8364,2972.147,3029.0662,3047.739,3095.945,3130.568,3179.8909,3210.811,3257.8667,3302.536,2456.363,2525.951,2654.3276,2773.0708,2772.496,2710.5278,2655.6892,2635.466,2626.8765,2652.4165,2633.9253,2634.267,2664.1555,2683.1714,2673.8716,2669.9705,2721.3848,2783.655,2814.001,2825.3157,2842.7036,2848.2183,2851.159,2848.264,2848.0352,2852.287,2851.0059,2852.1335,2846.3667,2824.7402,2785.864,2740.8003,2687.5813,2672.644,2699.8223,2676.7937};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2696.628,2700.2527,2703.545,2689.324,2684.654,2688.6458,2684.8787,2612.0059,2611.8481,2667.5295,2702.2893,2721.2131,2745.0938,2780.59,2814.6099,2829.357,2813.9746,2792.0352,2778.921,2744.7375,2735.5046,2742.8784,2757.611,2768.7976,2785.197,2800.3513,2821.588,2843.3691,2918.3108,2908.0366,2899.6804,2906.1406,2910.3518,2914.2134,2907.8394,2891.317,2888.5215,2892.059,2901.729,2916.4275,2927.2551,2927.7502,2924.439,2929.8545,2927.7483,2903.9949,2872.522,2876.8801,2897.8037,2885.7397,2882.8198,2885.228,2900.4927,2917.8008,2927.1138,2935.5715,2940.489,2945.5974,2947.8394,2942.8445,2935.39,2922.69,2912.9875,2896.1187,2876.1008,2827.5837,2757.6956,2676.896,2586.9177,2473.8755,2255.4575,2123.515,2071.1655,2053.2847,2067.4282,2090.2363,2132.3923,2220.1333,2232.8076,2259.9585,2268.3535,2316.5325,2415.5032,2419.862,2362.8274,2299.4583,2286.4106,2308.334,2336.0452,2390.7874,2423.576,2429.332,3040.3591,3034.7712,3030.1694,3024.973,3020.673,3017.0847,3014.1248,3008.5686};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {3003.2163,2999.8354,2993.6077,2986.2905,2978.616,2970.6821,2960.7292,2950.1113,2935.7039,2911.301,2896.7988,2898.4631,2893.1934,2883.6248,2883.5947,2887.87,2880.8179,2864.8044,2830.454,2799.6538,2780.5923,2759.936,2731.44,2697.1973,2666.0366,2639.2883,2624.4673,2626.009,2628.9163,2623.2334,2625.366,2597.6228,2590.04,2568.0996,2512.7458,2479.4568,2490.6968,2504.6257,2493.5308,2499.0732,2472.956,2450.2773,2447.9104,2471.3887,2490.2517,2527.927,2545.9492,2536.878,2514.1633,2475.0374,2453.628,2450.8604,2421.0532,2394.322,2345.5994,2299.018,2996.8108,2984.4153,2972.9883,2959.6333,2944.8896,2933.719,2935.1128,2931.9414,2918.336,2905.6213,2891.8604,2880.5295,2868.6174,2855.6074,2841.6594,2825.3013,2808.1843,2788.8975,2767.677,2752.2837,2773.8635,2772.6875,2758.7854,2742.1758,2723.5195,2704.2292,2685.577,2664.7407,2640.5342,2615.9924,2596.293,2576.2166,2554.517,2533.299,2513.6287,2494.0945,2478.303,2460.7864,2454.887,2453.226,2440.6672,2414.8474,2384.1672,2366.6155};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2361.3242,2349.171,2292.6846,2274.6594,2251.4028,2264.9658,2291.602,2284.25,2283.5813,2291.657,2268.2825,2267.769,2272.869,2367.861,2418.7532,2420.8906,2409.3447,2409.8298,2403.958,2380.4285,2850.003,2839.516,2860.9119,2848.475,2833.0955,2825.426,2810.5137,2798.5215,2780.759,2758.142,2735.0159,2711.402,2687.7024,2663.3904,2637.925,2609.1511,2570.6267,2514.0789,2487.974,2525.7307,2563.7478,2567.369,2546.15,2520.9126,2499.5742,2472.3384,2443.7507,2420.0015,2397.4482,2373.2524,2352.9663,2332.9065,2321.1438,2307.307,2282.0205,2267.504,2242.6377,2207.836,2187.29,2171.5571,2150.7085,2115.9658,2098.838,2071.9937,2041.9773,2008.3137,1986.5558,1983.9161,1979.996,2010.1317,2030.6661,2035.3735,2059.4153,2083.1758,2042.243,1994.5686,1933.7126,2006.9111,2129.3103,2212.1426,2231.3699,2262.8398,2260.8584,2290.305,2656.7898,2669.0938,2673.9536,2622.0454,2637.0332,2636.917,2620.4802,2630.2148,2598.8342,2612.6667,2595.2964,2565.396,2516.514,2472.0466,2455.5017,2433.9343};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {2386.9517,2319.7393,2273.676,2238.742,2174.321,2162.6484,2269.3433,2291.6538,2257.221,2230.7993,2244.4016,2210.0334,2171.7341,2136.087,2110.0923,2080.0493,1971.1552,1963.0791,1984.3871,2045.2388,1970.5232,1603.3661,1573.3853,1616.837,1779.195,1782.285,1773.7592,1764.6996,1747.0829,1730.6316,1720.762,1710.8931,1706.5422,1701.4381,1752.192,1742.6853,1808.1643,1813.5092,1813.0577,1742.8141,1490.3871,1579.6927,1708.8574,1809.0227,1941.3374,1996.5476,1980.9109,1972.8969,2428.2378,2403.898,2452.3948,2434.7756,2412.8743,2304.3308,2325.6248,2326.7004,2332.6074,2306.6045,2259.1885,2339.283,2337.295,2287.685,2213.7185,2208.5464,2257.9463,2235.4177,2199.795,2095.1255,2150.4802,2191.3345,2134.8542,1749.0529,1860.9519,1839.3596,1865.3053,2244.8872,2201.9946,2165.0476,2181.7615,2169.9238,2034.5688,1811.5679,1848.8531,2043.5504,1523.2463,1438.6486,1462.0469,1670.3892,1584.1561,1606.0752,1639.7667,1637.6648,1643.9276,1651.1807,1641.2682,1614.718,1592.6516,1582.452,1572.6454,1564.3026};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1559.7957,1569.8186,1566.8976,1554.5162,1637.1605,1717.6144,1681.5067,1794.1409,1856.1829,1713.4685,1862.1875,1852.2283,2096.463,2084.5984,2132.056,2315.2517,2303.1067,2285.6106,2215.848,2228.9045,2171.8474,2051.486,1997.7301,1974.74,1969.7391,1979.3292,1992.2528,1922.5563,1835.3492,1864.1611,1869.8422,1836.1698,1848.0804,1781.6393,1798.8533,1765.6725,1812.105,1803.3744,1847.1555,1911.0021,1897.5481,1852.1849,1845.7018,1728.8235,1833.8788,1896.0109,1850.9956,1731.1068,1391.5161,1307.3485,1331.4432,1555.9819,1501.0703,1512.5286,1535.163,1539.1194,1535.6177,1537.525,1549.1888,1607.743,1578.9789,1533.2712,1539.3428,1539.3734,1523.1971,1521.2815,1521.4563,1529.6649,1507.0839,1493.3843,1544.4235,1567.8329,1643.3315,1642.4805,1724.2623,1767.7635,1846.0411,1827.5618,2012.6687,2162.5715,2055.795,2171.7737,2089.9797,2031.4543,1974.8057,1978.3081,1866.841,1790.5297,1711.6537,1562.1276,1551.3032,1352.6757,1377.2965,1732.5134,1635.7048,1629.7245,1577.9227,1555.4928,1560.3918,1619.5021};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1570.5515,1560.7322,1644.5836,1763.5028,1745.5056,1666.6089,1623.925,1589.8767,1621.021,1585.582,1562.9912,1565.2667,1455.2849,1424.146,1404.7428,1431.7235,1441.638,1437.5405,1447.2725,1461.97,1457.3179,1455.7527,1474.1567,1607.2572,1637.0238,1530.6558,1512.912,1495.5634,1509.604,1508.8252,1511.4725,1508.8563,1520.5684,1537.3904,1547.6842,1536.6917,1530.5387,1530.556,1547.594,1546.495,1875.7391,1858.7384,1931.0283,1772.3762,1529.152,1777.9338,1899.4324,1901.0908,1744.3379,1343.4584,1615.5479,1693.9504,1656.9735,1062.4109,953.54956,847.88617,1014.6512,1634.0364,1666.5961,1527.8285,1514.2993,1566.4695,1540.7638,1542.1917,1565.835,1565.0713,1667.4279,1690.0128,1760.5647,1800.2346,1693.6498,1645.9993,1705.3594,1534.6548,1287.2708,1384.2015,1490.2428,1330.7799,1293.967,1478.7882,1467.4219,1471.9365,1456.3755,1440.2174,1456.1383,1474.5516,1607.653,1865.7832,1741.5093,1486.7887,1498.8264,1480.6615,1513.6227,1523.456,1510.436,1516.9661,1532.177,1536.2179,1541.466,1556.211};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1561.6998,1542.9628,1516.0743,1487.234,1190.2029,1689.1226,1421.1305,1438.3109,1451.9978,1491.2236,1555.9077,1360.5028,1135.3447,1209.029,1179.0463,1261.7689,1279.9227,1313.14,1399.8733,1653.1129,1303.346,1484.3137,1853.1945,1733.917,1648.6495,1545.579,1518.2864,1480.3103,1514.5692,1537.144,1601.65,1683.248,1810.099,1974.9471,1770.6182,1673.0111,2065.5857,1841.8477,1695.5696,1501.8711,1506.98,1450.2246,1439.7509,1544.876,1500.8953,1476.6425,1527.375,1494.6943,1382.3263,1520.3236,1653.9999,1732.7266,1698.912,1732.9312,1698.4298,1589.6075,1565.7567,1494.7661,1585.8154,1548.4799,1533.1624,1497.6013,1514.3538,1522.3492,1513.0265,1488.5846,1479.0281,1471.7246,1357.6075,1178.5687,1091.4803,1077.7395,1093.5153,1017.06964,838.20905,764.09735,688.3835,656.2974,774.0496,792.47107,783.5643,810.39246,845.2303,1392.434,1598.9724,1555.4929,2151.1523,2463.7349,2372.9756,2169.6245,1907.4323,1790.8087,1509.6396,1410.8263,1590.7574,1733.4722,1882.1616,1943.2483,1962.462,1933.985};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1872.9084,1207.4857,842.43787,1484.9283,1517.4448,1487.7183,1485.4552,1548.6954,1486.8936,1606.1748,1688.335,1639.7784,1630.3184,1634.4863,1646.8845,1734.6963,1740.6115,1698.8595,1702.3572,1456.2073,1538.6455,1612.0707,1646.6272,1481.4303,1468.2764,1511.5546,1565.9563,1487.8723,1496.7296,1538.2777,1518.1698,1468.896,1425.9008,1352.9379,1170.0878,1002.5098,950.3738,969.5486,857.83124,620.5515,631.2895,621.1831,627.95215,614.46545,621.84985,642.327,778.55786,1145.3694,1572.9198,1811.2727,1976.8607,2169.282,2235.6184,2524.114,2398.7012,2194.1172,1811.7505,1729.1471,1651.2948,1444.5635,1380.7239,1467.3187,1665.1469,2037.5793,1934.1007,1577.2195,1333.9882,1407.0476,1487.0157,1516.3529,1573.8185,1642.5093,1452.2218,1761.5244,1791.772,1776.6455,1808.4474,1881.9918,1772.9882,1695.8451,1700.6809,1701.396,1684.7808,1521.3556,1524.7755,1556.9838,1536.474,1451.253,1419.8805,1535.3138,1394.8671,1368.8306,1468.4287,1442.1545,920.68896,402.8584,1524.6583,1476.0773,1344.8151,1191.8032};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {1196.0192,1192.9274,373.7767,104.56544,437.96216,795.5623,629.12714,572.2368,582.9948,607.48694,669.958,822.86786,1038.8331,1326.5833,1465.6073,1364.98,1251.4158,2003.64,2315.9666,2299.2957,2232.2466,2011.3792,2066.8047,2074.346,1929.0347,2011.0238,2227.6404,1602.9427,1690.8542,2105.3699,1882.5403,1786.4127,1662.8717,1688.9708,1758.9578,1837.6683,1805.6315,1954.9514,2048.7036,2088.0723,1640.706,1592.1338,1906.6007,1892.4211,1876.8063,1588.6086,1640.5996,1586.5363,1510.9067,1444.7583,1353.054,1353.84,1361.7653,1384.8535,1386.9299,1395.1696,1383.7216,1351.2273,1253.7351,1215.3406,1282.5719,1741.3488,1728.8107,1641.7505,1434.9835,1320.7285,1267.336,1142.0825,1298.5447,923.7387,575.46857,604.4974,590.1877,563.18146,549.0156,550.35175,634.2434,888.03723,1026.6636,1114.1724,1366.2198,1558.1685,1763.587,1980.1963,2197.2627,2205.6875,2328.023,2452.6917,2491.1265,2657.7637,2470.4868,2451.9717,2261.9805,2110.612,1992.3568,1945.6287,1932.8881,2011.6848,1919.2975,2028.8687};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {2177.6716,2178.5925,2299.6387,2062.4636,1387.5886,1344.3376,1321.5552,1969.049,1884.9847,1789.9131,1694.2687,1582.3063,1536.8499,1487.453,1364.7115,1321.881,1347.6167,1352.8954,1362.5508,1375.5482,1371.6427,1359.9636,1343.8271,1325.3435,1763.169,2160.317,2221.548,1963.0466,1692.3403,1574.65,1410.0667,1251.3566,859.3147,435.25153,535.82306,629.01117,608.4019,605.8488,569.16504,533.3073,595.7324,662.62213,656.224,874.8679,1214.255,1234.3275,1312.0682,1448.0739,1525.4705,1674.7294,1771.6805,1909.2017,2023.8434,2061.2527,2082.141,2051.9163,2133.4658,1998.1655,1949.9197,1998.4111,2203.2124,1596.0902,837.9375,1057.9661,1996.4778,2159.9324,2335.8616,2184.0334,2248.5303,2195.4082,1817.0106,1900.3179,1829.0146,1601.8429,1705.444,1543.6826,1548.4512,1330.6018,1230.7812,1417.8956,1361.7075,1347.9148,1339.3407,1328.8427,1318.7386,1320.8597,1303.5665,1303.8513,1827.2834,1895.3843,1991.8793,1985.2677,1968.7505,1984.8921,1696.5521,1762.8009,1382.7113,1035.7166,971.38385,834.9726};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {766.56384,794.60645,656.35834,611.2967,611.1521,607.5123,608.11993,626.1363,695.8987,902.9994,961.5154,928.2165,940.1335,1064.9768,1324.3665,1627.633,1921.4934,2076.7678,2119.3936,2108.6194,2105.7058,2033.979,1887.6191,1872.6604,1939.5968,2047.2715,2177.683,2145.429,2091.2236,2200.8083,2236.7915,2185.1946,2092.62,2115.608,2010.9934,1844.0588,1789.1526,1699.4294,1723.7373,1778.5747,1700.9998,1639.0082,1505.04,1122.7806,1441.1929,1448.794,1407.1682,1338.5347,1347.574,1288.7112,1258.1556,1268.5342,1644.8044,1792.8037,1655.3373,1807.5336,1783.1606,2018.5679,1922.933,1519.9036,1326.1897,1330.6381,1075.6343,1094.035,1055.0734,986.01056,881.6159,771.2049,503.79788,812.8465,835.93475,905.7628,934.77423,905.19366,824.93274,841.1654,830.6057,859.6109,1125.761,1534.3684,1898.0859,1943.2352,2177.5066,2017.1989,2007.2633,2041.4716,2006.5823,1777.2637,1910.1365,2019.3785,2076.2134,2115.8574,2108.0647,2061.2268,2063.2175,1986.2341,1884.0697,1786.266,1782.0151,1781.9734};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {1826.5121,1882.5496,1935.9631,1710.9596,1723.0466,1669.9817,1592.8264,1427.534,1493.6161,1568.8097,1573.8794,1497.9503,1452.3945,1421.6661,1424.6398,1606.3735,1421.5234,1835.0007,1875.987,1760.3993,1711.5516,1560.8224,1426.8573,1305.8539,1293.1326,1593.5349,1615.319,1617.0477,1504.5643,1481.2914,1583.1334,1220.633,1283.0961,1440.7214,1641.3198,235.46677,768.50793,1470.987,1274.137,1202.5593,1083.5021,930.1794,1099.1051,1326.7915,1530.5087,1553.4646,1728.4548,1818.9191,2112.8118,2296.3096,2242.642,2055.044,1914.5208,2047.233,2232.7625,2107.953,2162.014,1978.0247,1682.032,1466.6127,1403.4839,1413.378,1442.402,1570.7877,1838.3693,1937.4905,1986.298,1907.8938,1840.5675,1671.4625,1770.1692,1707.6881,1665.988,1769.983,1926.6418,1710.3274,1623.7838,1512.8557,1572.7845,2117.001,1086.7627,1533.3273,2048.9673,2040.574,1637.6898,1454.8922,1349.4684,1409.7397,1701.4304,1968.0573,1982.7518,1956.0924,1911.6443,1937.5842,1838.6478,2041.9518,1626.5183,1441.6147,1980.5314,1098.2057};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {1269.4708,1652.1713,1403.3529,1455.8167,1596.9393,1577.0717,1645.7273,1349.7351,1217.9646,1286.3533,1403.2605,1452.236,1817.8354,2165.8774,2030.448,2071.2397,1038.9641,1412.5331,1945.9291,1916.0679,1929.9465,1814.1002,1491.188,1286.7993,1221.9044,1185.3743,1196.162,1237.1879,1476.6792,1638.8939,1777.8062,1877.0334,2001.3241,2106.6323,2088.407,2073.1277,1653.9237,1834.82,1805.7596,1539.2722,1433.4546,1398.4547,1825.3212,2036.0773,1089.887,1366.8977,1423.1776,1640.6516,1461.8114,1295.6362,1179.2234,1983.6632,2425.5786,2170.1172,2148.8535,2061.237,2105.0574,2022.4087,2012.8955,2114.4558,2038.6377,2251.7283,2362.5747,1824.1835,1347.1709,1719.0862,1394.745,1373.3856,1551.3281,1705.2051,1612.9689,1546.6257,1286.1033,1245.1683,1431.0454,1585.8037,1709.0864,2096.6504,2187.7336,2090.2126,1951.0319,1798.4155,1739.132,1606.6864,1952.1633,2127.281,1929.104,1476.7794,1154.4702,1080.3737,892.88464,1333.404,1399.1447,1461.7175,1644.6184,1835.456,2172.6543,2342.6724,2304.8765,2261.2292};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {2108.218,1690.7473,1368.6364,1195.8666,1146.8577,1151.2952,1243.0022,1500.345,1120.6506,1176.0043,1167.8235,965.819,1035.8259,1110.3286,1499.7716,1799.4529,2018.1733,2111.283,2340.0894,2384.6516,2409.1667,2227.5535,2151.439,1426.1663,2205.168,2341.2068,2458.8684,2557.7478,2507.38,2247.628,1683.1902,1404.0858,1511.5531,1807.3289,2130.7476,1729.0162,1285.1953,1609.3489,1578.4006,1730.6934,1933.3726,2325.0903,2561.5386,2126.6199,1853.7437,1735.9747,1767.3954,1910.7362,1966.0872,2578.1829,2510.3352,1742.0638,1431.436,1346.0592,1231.7252,1465.1307,1441.4589,1182.9833,301.91415,1893.4863,1954.8461,2136.851,2028.4347,1939.8374,2147.4038,1703.571,1566.4584,1353.5912,1245.4227,1200.1636,1255.8234,1387.6644,1006.6744,989.4585,877.9542,867.7054,884.92523,1218.63,1456.7194,1485.7776,1548.3135,2023.8176,2218.2488,2176.1182,2145.4983,2034.5493,1929.2439,1821.1428,2067.7073,1982.1327,2106.2798,2177.2917,2258.398,2142.9836,1881.3314,1480.2773,1491.3882,1638.038,1707.6912,1786.1302};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {1574.3821,2276.9211,2297.5496,2124.2002,1863.0804,2525.5022,2602.1543,1938.2213,1735.5803,1655.3226,1650.5747,1717.1885,1938.2561,1931.8662,1831.9364,1608.3295,1384.545,1334.409,1322.135,1489.0037,1362.0193,952.5274,1742.747,2002.8752,2147.9482,2117.5713,2251.163,2342.8967,2313.4011,2249.763,2144.5537,2025.1058,1811.8583,1780.549,1606.0685,1718.2919,1128.6703,1042.1218,909.4015,873.51294,901.9209,1293.8519,1567.0062,1465.773,1449.3486,1652.6868,1636.7482,1573.1532,1602.598,1671.9307,1692.2333,1771.1906,1975.7554,1858.1105,1956.6082,2030.9495,1558.7915,1686.7657,1355.8779,1620.3799,1475.0913,1532.5173,1508.0669,1695.0,2031.6593,2436.7017,2443.0825,2442.4949,1738.4377,2252.2534,2403.6545,2105.368,1826.5656,1639.0173,1597.2538,1587.2273,1661.7303,1832.6632,1528.2666,1475.4032,1303.2144,1367.3005,1555.3593,1660.192,1525.5175,1430.0183,1559.1344,1904.0597,2188.85,2404.799,2437.8538,2213.2964,2409.7493,2419.0532,2482.957,2428.7664,2342.3484,2273.5962,1825.883,1811.0728};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1089.5713,1272.3152,1121.3274,1084.4878,410.44287,597.7616,1598.8411,1739.3263,1302.3145,1192.7842,1212.0264,1229.9099,1404.1012,1392.7118,1408.0734,1647.1003,1639.8217,1960.583,1672.125,1750.607,1380.7227,1367.2064,1808.5717,1833.8666,1593.4656,1634.9857,1549.043,1594.4979,1777.0981,2157.4329,2516.1753,2410.18,1967.1038,2033.2871,1947.3284,1658.7207,862.23004,887.5866,1546.9766,1566.2198,1627.9269,1227.0826,1168.339,1677.4819,1464.2837,1645.9358,1436.8955,1600.6522,1495.2738,1493.4194,1531.6676,1664.0503,2325.2317,2492.4817,2463.1501,2570.8516,2633.2603,2614.88,2546.224,2249.413,2065.5283,1998.4808,1769.778,1678.7405,1082.7063,1364.4141,1407.6232,1662.8911,1422.2537,1235.3988,1531.4482,2119.8767,1321.7113,1342.3883,1562.1863,1322.5411,1346.9642,1581.9128,1440.1597,1776.5251,1833.644,1637.6571,1469.421,1460.6699,1588.4121,1731.1703,1773.5675,1838.6202,1639.0234,1699.5721,1669.8601,1734.4985,1874.0248,2118.8308,2464.6646,2749.2952,2411.1475,2378.7551,2345.4238,1940.6233};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {1701.8276,1935.8036,1737.6313,1621.339,1622.0948,1754.5505,1871.231,1563.314,1590.992,1902.6978,1705.5735,1706.7902,1594.6292,1737.0931,1761.8942,1859.507,2106.9192,2426.3965,2679.9133,2933.0854,2942.2002,2988.6982,2763.3044,2596.45,1993.059,1769.5585,1643.7677,1540.7648,1144.7261,1520.2928,1439.6348,1433.5208,1238.1133,635.2677,536.72064,483.75653,428.2572,1192.1643,1138.0048,1355.3752,1701.8287,1875.9064,1894.2632,1838.7368,1786.661,1757.4811,1586.2527,1720.0858,1724.8502,1996.3242,2084.7256,1769.5396,2153.4468,2020.078,2078.028,1723.7375,2023.2203,2190.1753,2508.0466,3321.24,2827.1719,3068.0405,2816.3042,2270.6174,2458.547,2083.6887,1723.4998,1643.1095,1636.8357,1843.3314,1687.4137,1570.1322,1736.8751,1127.2493,778.2804,2342.0679,2096.7944,1968.9231,2176.1238,2261.5613,2253.2837,2458.3071,2912.305,3149.7786,3236.0635,3211.8965,3151.5444,2884.0554,2150.943,1818.5052,1686.8639,1532.4641,1793.1758,1950.7192,2020.537,1643.4667,1536.5922,588.30316,371.46503,120.31212};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {155.13034,960.0874,983.69666,1326.5088,1950.0457,2019.6028,2081.1855,2226.757,2084.2263,2453.3203,2339.781,1966.7394,2053.6472,2236.0742,2253.8184,2260.4707,2544.1182,2849.1394,2583.1523,2302.8894,2302.9556,2158.4124,2549.329,3202.7642,3140.4363,2775.7197,2465.529,2355.2278,2179.8716,1752.7225,1659.811,1669.3822,1689.5198,1711.3273,1833.3822,1676.2887,1842.6475,2136.5002,2657.5686,3077.0085,2942.9832,2839.0308,2706.3853,2581.905,2512.3313,2491.4116,2757.4397,3091.2341,3327.5535,3333.2002,3155.5183,2924.306,2370.1873,2027.124,1772.7758,1636.145,1997.5079,1913.0038,1995.8507,1880.3916,2538.2534,1244.7771,509.28082,287.56607,923.51904,1909.2501,1225.6606,1364.0414,1771.9734,2045.6604,2257.2163,2405.102,2699.747,2897.879,2327.7585,2534.2578,2279.9253,2591.786,2867.3816,2843.592,2953.5823,2873.4575,2691.689,2372.9182,2463.083,2667.6172,2633.5222,2458.2551,2402.5183,2218.2905,2098.079,2106.027,2260.3872,1842.324,1766.1196,1715.7697,1732.9061,1734.9143,1792.0599,1778.5969};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {1827.2235,1901.0413,2424.845,2729.8215,3005.195,2827.7844,2443.7004,2322.0234,2254.6545,2234.483,2463.4333,2726.3208,3057.4285,3166.7314,3037.6226,2754.153,2471.197,2425.4377,2256.2595,1921.496,2233.503,1741.1431,1803.4833,1700.5859,1678.1951,1708.8204,1408.8091,1302.0443,1557.5605,1506.0859,1216.2234,1245.9327,1681.0219,2232.6765,1734.6537,1667.9099,1964.5431,2503.086,2187.618,2348.0403,2441.0276,2583.6553,3181.5012,3052.4197,2880.0566,2500.3926,2329.4329,2082.5818,2104.5876,2254.8591,2331.953,2035.2262,2057.7705,2048.653,1991.3159,1914.2959,2107.7961,2045.8118,2150.0703,1898.0731,1820.1111,1657.4346,1739.7354,1759.3584,1850.9144,1833.6957,2184.3413,2293.7935,2488.1094,2372.724,2282.0435,2264.3079,2221.6372,2205.968,2244.4346,2397.4717,2576.1226,2689.957,2871.286,2587.0344,2689.8574,2672.8496,2944.7832,2453.912,1554.7859,1405.1555,1556.9531,1504.5093,2262.644,1599.3558,1509.6086,1431.576,1380.2333,1073.7288,1221.38,1152.3798,1830.5804,2453.4446,2203.3562,2163.5022};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {2219.822,2342.1052,2378.4927,2300.0105,2296.9197,2150.1392,1454.3948,2132.698,2129.1433,2036.8947,1922.8329,1996.3063,2169.5046,1880.6108,1957.3423,1648.5328,2180.9465,2004.3019,1864.03,1733.9254,1797.7201,1829.1875,1935.7334,1932.1113,2032.5469,2320.473,2194.1448,1969.0458,1964.8499,1948.4364,2085.088,2187.8562,2334.2307,2340.847,2324.6511,2300.491,2240.676,2160.9949,2091.9087,2100.4346,2322.5122,2476.3416,2604.919,2354.6072,2340.569,2446.2092,2343.6306,2337.03,1432.6085,1675.9419,1013.62866,1161.413,2171.4663,976.04395,1267.9819,1287.5645,1360.422,1420.0792,1356.7893,1300.295,1653.6738,2482.589,2410.8738,2472.1292,2298.1665,2414.461,2585.817,2460.6167,2049.2915,1972.2739,1823.5157,1889.3854,1900.9215,1901.079,1912.884,2076.4316,2377.979,2056.7808,1902.4808,2199.4536,2005.1781,1942.2891,1994.6252,1913.6987,1717.2123,1756.8884,2093.7393,2290.217,2451.411,2385.1045,2262.4285,2074.3718,2227.8909,2225.4536,2125.3,2178.4705,2367.8127,2396.557,2381.7908,2334.4158};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {2245.0808,2116.0344,2006.5641,1972.5994,2173.0164,2488.0264,2952.9666,3134.6475,3108.3203,2695.7415,2338.6582,2301.6782,1082.0751,1138.1493,795.85016,564.30334,610.11536,850.2767,1305.2775,1423.1917,1328.2994,1301.1138,1272.8306,1188.7385,1401.759,711.12427,15.043555,445.0627,1568.394,2342.8684,2166.04,2029.886,1905.1964,2331.2876,2158.432,1862.0505,2001.316,2282.4114,2410.106,2393.073,2432.6162,2262.2795,2263.344,2209.158,2051.459,2176.7603,2443.4817,2450.1726,1920.7842,2097.7805,2739.3057,2320.7612,2132.1868,2240.4868,2618.091,2484.169,2648.1062,2627.5725,2706.988,2373.86,2702.754,2475.8171,2441.8594,2365.5593,2247.6501,2070.4202,2284.296,2971.8403,3691.579,4139.283,4437.4907,4728.7646,5022.265,5080.1597,4606.713,3657.3984,862.1935,953.8023,842.86444,802.33044,618.6409,721.36145,1230.8627,1403.2866,1306.6135,1630.8701,1042.4484,710.4425,689.1829,-854.4774,-1101.0911,-579.8972,564.5575,2561.376,2173.9163,1835.5853,1859.5304,2375.5522,2496.9456,2201.4978};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {2358.6497,2360.24,2169.9805,2268.9885,2383.8105,2151.9202,1971.0612,1731.5889,2010.575,2134.1155,2245.226,2735.4548,2585.2854,2564.3733,2330.5215,2155.5479,2358.0063,2301.3208,2340.8691,2508.5647,2713.458,2625.6057,2723.9944,2648.2576,2820.534,2568.1335,2494.3445,2402.932,2279.684,2417.5361,3732.013,4270.803,4409.5996,5059.5596,4877.795,6285.5815,7295.3193,7452.043,6125.1934,4705.451,842.464,763.0462,926.133,1481.458,1314.7106,639.33826,842.9836,1469.7261,1113.5187,1191.7847,1439.779,1806.7277,1609.2966,9.942564,-281.961,191.44734,1344.7864,2062.8281,2030.6732,1619.7441,1416.6909,1733.7726,1658.5696,1879.1793,1902.8817,1732.3229,1746.5674,1779.4584,1852.9728,2245.5906,1757.5319,1575.946,1620.3962,1699.3694,1945.5583,1910.4137,1797.4291,2318.9685,2523.1687,2363.5754,2313.914,2380.0557,2595.7734,3489.4512,3967.6787,3087.456,2864.8674,2859.4382,2759.4739,2630.6328,2561.523,2539.688,2628.4646,3175.8936,3790.7466,3438.84,3961.1086,4908.416,5040.1416,5433.791};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {5636.563,5555.0166,5249.712,4886.1284,629.3518,438.13715,555.02325,1376.8607,697.5906,-103.26507,113.84684,769.4764,798.5951,1137.1329,2033.1204,2348.2683,2569.7078,2277.6956,2369.5325,1956.9243,2619.7502,2233.414,1817.8954,1155.2246,1109.6932,1554.649,1339.2028,1142.3724,1219.7205,1432.3962,1481.4541,1412.9021,1709.1057,1940.9928,1602.9612,1707.264,1591.8782,1830.0769,2539.0625,2406.5413,2435.0234,2314.069,2498.882,2715.758,2504.1526,2576.0867,3051.1843,3294.9058,3124.6003,3082.2761,3728.669,3326.0486,2954.9978,2953.1445,2847.2688,3409.042,4520.501,4975.0654,3906.7266,3584.5234,4646.8813,5413.75,5330.919,4918.806,4969.8823,4514.411,4538.6143,4608.137,744.7936,452.49673,847.74615,1127.848,414.15506,-112.09662,268.57465,856.89606,1050.1631,1494.8344,2168.7073,2627.03,3047.082,3393.1472,3301.4846,2682.501,2394.5251,1675.8221,1380.6715,1035.9583,1030.1445,1057.333,1079.2391,1103.2473,1107.2815,1215.5765,1449.0366,1624.5941,1626.6978,1524.6125,1686.2367,1644.5396};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {1699.6166,1929.7435,2515.1465,2306.185,2363.692,2645.4585,3007.2766,2944.1997,2485.4756,2535.7358,3033.0024,3627.9734,3359.851,3711.949,3745.9087,3327.7634,3260.76,3643.3035,3226.44,4161.441,5359.952,5324.6455,4455.2705,4569.087,5138.0195,5309.1294,4785.207,4373.4976,4281.128,4366.6157,5107.234,4975.1323,-91.36215,-206.52284,840.8067,1558.598,1048.2185,861.4979,1509.5723,1727.6976,1793.1562,1720.1715,1751.0719,2761.7815,3019.2122,3183.88,2800.659,2374.2063,2004.1726,1467.0096,1240.562,1163.7806,1229.267,1149.2185,1118.1161,1653.4252,1862.8276,1370.0798,1490.4905,1652.6171,1609.5935,1625.3533,2065.5984,2077.9897,1943.3469,2287.789,2396.2356,2334.2764,2421.1758,2635.2334,2725.8416,3074.2524,2965.8887,3168.306,3389.4915,3455.4463,3432.9727,3529.5818,3610.644,3560.3755,3655.7708,3445.2698,3883.5046,4341.1157,5380.1055,5394.1245,5024.8125,5685.4214,5818.526,5037.161,4657.233,3994.2092,3826.4639,4162.8315,4571.0493,4287.235,163.06467,55.444958,1456.0676,1671.766};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {1462.005,1298.2678,1749.5343,2076.3271,2074.6145,2606.139,2566.6975,2827.0203,2489.1978,2797.99,2466.04,2292.4763,1597.306,1312.8704,1218.57,1113.0042,1490.7892,1249.5651,1084.3047,1297.2947,1362.2216,1436.8785,1513.4233,1706.1566,1700.2786,1734.888,1876.195,1939.155,1959.0391,2113.5642,2284.3708,2368.2588,2455.9253,2585.6265,2746.448,2934.6587,3354.5232,3216.8228,3298.696,3476.5413,3701.959,3672.2139,3869.0244,3887.3928,4133.434,3840.0874,3934.7683,5080.645,5613.306,5381.216,5922.5273,6642.719,6352.035,5213.8228,4469.216,3849.8367,3717.875,3654.4998,3822.113,3789.0845,1024.5073,1048.2037,1491.7876,1394.9448,1576.1746,1740.4735,2083.9968,2539.6953,2341.2437,2429.979,2596.666,2181.781,2097.6887,2079.1008,1891.052,1896.8838,1593.2405,1299.9941,1277.8657,876.5701,965.12714,1127.1003,1130.5029,1265.649,1271.175,1657.6157,1478.107,1675.1279,1959.7937,1715.035,1879.8007,1939.8477,2064.0942,2199.6274,2281.9246,2449.769,2510.4453,2638.6052,2787.3618,2958.9094};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {3123.7305,3281.1233,3438.5762,3987.4277,4329.0767,3856.9165,3975.1284,4164.645,4562.5107,4213.3955,4724.9224,4893.2964,5441.1846,5974.2944,6300.0703,6438.227,5976.7646,5153.144,4541.281,3975.2573,3970.8708,3721.9946,3464.4404,3505.1384,674.66187,1231.3519,1537.1699,1433.0765,1578.6771,1935.5186,2261.6174,2505.8816,2634.457,2397.0298,2291.1514,2122.4807,2157.8691,1770.4955,1852.3501,1771.3121,1626.9783,1430.6768,1388.0227,1312.9902,1083.3119,1056.2751,1073.5143,1492.6838,1543.6323,1605.032,1449.5388,1800.0634,1885.9921,1794.9448,1948.4562,2022.4069,2099.378,2200.2122,2272.509,2355.9822,2490.731,2660.7737,2788.4365,2927.9924,3248.9827,3323.949,3577.7432,3781.645,3961.7507,4000.4785,4144.317,4307.6177,4336.916,4235.884,4898.8535,5165.1094,5617.071,5944.661,6443.8765,6714.5903,5727.798,4907.185,4673.185,4116.1333,3780.439,3604.5278,3448.9724,3275.2822,537.3633,1354.871,2252.3408,1812.4679,1665.6888,2290.255,2518.5903,2703.966,1800.7349,1553.1241,2378.8247,2133.644};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {2289.5288,2333.393,2226.5337,1936.1149,1477.2809,1315.5181,1093.5531,1306.3761,1077.6102,1183.0743,1197.6141,1475.6285,2317.1267,1393.5757,1416.5026,1582.5131,1916.658,1963.8182,1988.5936,2150.7917,2152.8657,2232.6365,2289.5454,2407.1646,2514.6858,2714.544,2913.7124,3202.7173,3349.9443,3540.4026,3689.0154,3873.6528,4026.9133,4120.647,4185.4126,4264.205,4444.8735,4674.7915,5023.2466,5050.4893,5425.8096,6550.7876,6978.507,7345.8877,5948.704,4653.293,4391.02,4033.2417,3815.1143,3622.6719,3461.1353,3292.9268,907.2095,1373.266,2229.8542,1817.6388,2020.9272,2247.8486,2453.42,2519.1116,1879.0997,2544.717,2446.5808,2031.4489,1914.3921,2032.7775,2246.5867,1878.4263,1591.3032,1611.9174,1291.5222,917.8364,977.6262,1178.93,1114.9639,1609.3711,2548.2634,1442.3297,1591.9188,1708.032,1959.1896,2016.626,2026.6609,2066.37,2169.509,2246.3386,2349.6255,2449.8374,2579.9277,2743.405,2969.4172,3194.7346,3403.5398,3597.1921,3777.531,3963.9954,4150.0576,4285.403,4362.073,4423.21};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {5056.934,5061.4756,4496.918,4442.307,5453.5264,6177.91,7020.9966,7544.129,5843.235,4603.9487,4288.169,4060.13,3824.7166,3561.339,3353.501,3164.4705,1212.5304,1272.5769,1388.6046,1425.4614,1645.0206,2129.9893,2308.0422,1850.4802,1636.3395,2235.4243,2196.8281,1934.6565,1745.4376,1911.3323,1954.5073,1413.1488,1186.486,1953.3168,1492.9186,926.51575,1083.5317,1416.5077,1171.6046,1366.8331,2224.6316,1633.8066,1799.4426,1954.158,2168.7864,2026.551,2082.6711,2176.4092,2206.4788,2321.3706,2491.0908,2547.745,2635.2883,2770.244,2978.5613,3209.8027,3494.5906,3696.6284,3919.5503,4116.729,4308.6533,4600.439,4521.9614,4595.1714,4832.838,4547.6553,4408.1265,4715.4897,5601.8306,5868.114,6111.297,6160.162,5211.389,4614.3843,4296.197,4056.625,3785.1902,3553.6846,3357.1702,3150.4275,1239.7444,1249.0197,1179.993,1316.9515,1669.3872,1706.9409,1812.8708,1473.6887,1456.6558,1199.3228,1253.8531,1495.653,1378.0457,1348.4668,1644.0089,1089.021,940.1025,1216.0771,1289.4631,1107.1028};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {1039.7067,1220.1322,1203.3826,1451.681,1885.3052,1623.1536,1442.2482,1714.0492,2045.1722,2070.0945,2124.3174,2205.2576,2289.4795,2358.907,2560.1196,2684.0596,2784.7107,2907.2893,3069.1035,3335.881,3651.5432,3846.7988,4097.229,4303.6133,4466.2104,4621.27,4729.811,4784.1587,4820.151,4904.1494,4985.5493,4954.9,5407.988,5888.507,5738.3433,5420.3506,5045.513,4695.8843,4353.666,4039.7415,3788.0588,3618.0425,3447.4045,3258.166,711.70154,943.95514,1151.7742,1450.5211,1577.699,1602.1705,1501.4625,1346.9705,1192.4365,1212.3087,1199.057,1068.6194,964.4953,960.3615,1155.2214,904.7984,805.67474,395.22925,1237.1882,1401.7863,735.3967,903.5102,1527.9443,1621.3899,2277.341,1450.8888,1793.834,1714.0099,2067.3193,2121.6646,2167.0437,2221.6155,2311.7856,2430.0195,2618.907,2774.5142,2933.7002,3117.493,3332.5862,3577.5322,3855.8347,4043.9739,4280.901,4539.3457,4695.698,4850.091,4940.681,4994.8477,4955.5005,5008.806,5305.6836,4725.4927,5376.7046,5951.649,5784.8,5496.7026};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {5136.4263,4726.7524,4367.3154,4090.5713,3900.3687,3746.228,3584.0964,3436.3958,963.3134,956.74445,1341.9675,1660.8939,1229.2888,1344.4163,1604.2166,1369.6388,1308.0869,890.0104,693.7195,742.24634,689.66907,643.0746,788.5906,781.0683,799.65,446.9885,809.04443,1074.837,682.9366,787.82465,1328.255,1207.6455,2086.8948,1506.2808,1936.6271,1785.3851,1893.934,2169.3877,2201.9695,2265.1846,2361.662,2465.516,2637.7576,2856.776,3056.6448,3260.4338,3558.655,3850.3582,4108.732,4351.792,4555.1616,4791.0005,5004.2896,5112.697,5227.5127,5130.7373,5046.375,5110.489,5668.4106,4955.69,5712.0337,6077.508,5812.56,5520.2744,5136.7114,4775.4077,4463.7153,4282.6265,4135.9985,3910.0881,3734.689,3591.7175,1155.0782,1268.3811,1538.0938,1453.4263,1493.4714,1498.033,1476.7351,1230.4305,1113.7046,418.6269,425.7492,322.8925,504.22226,779.73474,659.1672,790.8737,724.77545,725.6357,948.8753,774.20105,680.00574,803.9348,1339.4762,1292.0306,1534.5825,1585.822,1701.0709,1891.0967};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {2092.6208,2183.8445,2263.8965,2345.2988,2469.2292,2589.7036,2717.3496,2930.254,3193.6985,3470.384,3841.2874,4207.3286,4505.1133,4753.6675,4943.1265,5147.6123,5337.948,5435.883,5452.817,5353.7964,5281.6143,5736.565,5744.774,5616.148,6212.032,6224.7324,5801.0947,5492.4243,5223.641,4919.4536,4682.456,4515.0776,4353.1597,4169.804,3951.3274,3790.6155,1518.3945,1535.9873,1571.8423,1569.4957,1731.496,1372.2532,1293.9993,984.05,554.835,-70.983116,-172.93791,-84.855316,247.03021,571.25073,-282.89374,821.17444,816.6438,699.1234,1067.9741,675.77515,628.5495,690.2885,1260.2124,1377.7692,1370.0193,1580.9237,1727.4806,1887.4666,2113.122,2300.2073,2391.5608,2492.838,2624.6755,2736.7708,2925.9387,3094.4458,3344.9946,3710.447,4179.8975,4691.9834,5022.947,5281.616,5444.0625,5598.148,5662.5474,5759.254,5694.171,5570.64,5585.9966,6543.1265,6041.225,6115.9556,6390.4556,6304.587,5929.602,5729.9673,5508.025,5260.98,5023.0806,4845.154,4669.3447,4459.9097,4257.0,4044.0242};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {1987.0669,1748.6661,1618.808,1631.0961,1536.069,1368.4242,1246.2878,853.8494,50.341114,-437.5344,-718.97565,-256.64746,45.6892,426.6669,724.00214,701.35803,879.1048,1173.4379,1186.5139,668.4636,377.0887,1051.3418,1062.6235,1166.512,1273.2417,1607.1224,1778.6162,1897.0786,2028.1251,2185.8828,2378.9175,2548.8474,2777.9148,2914.1824,3088.8289,3295.2043,3556.5845,4029.45,4656.1836,5249.8438,5622.825,5867.0103,6004.3364,6043.78,6033.251,5981.9043,5868.236,5759.749,6359.1753,7200.0093,6451.996,6286.178,6389.838,6333.624,6208.389,6133.7725,5968.145,5726.326,5451.4023,5254.9487,5047.044,4829.7334,4532.1914,4259.5757,1724.519,1735.137,1611.6971,1530.0411,1345.0958,1285.6825,1096.7556,698.0661,-42.441353,-616.3674,-207.27077,-129.69131,-10.718689,117.98484,394.27896,447.555,678.4196,1036.559,819.87756,723.8061,91.89784,1290.1605,1532.2296,926.24164,1080.0795,1502.0582,1837.5608,1883.9392,2044.2822,2215.1553,2517.0823,2721.5042,2878.433,3062.0596,3281.778,3545.209};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {3873.919,4495.0,5337.1743,5938.948,6372.924,6651.426,6574.5635,6459.4507,6328.98,6210.179,6047.284,5975.7817,6883.3247,7072.285,6652.322,6373.11,6269.8047,6403.779,6592.3945,6616.7114,6540.031,6232.258,5914.9736,5653.673,5424.1924,5171.565,4800.502,4519.7793,1583.6613,1724.2228,1035.2367,1035.5883,1289.465,920.85956,677.99225,425.76218,-487.19827,-682.4862,-217.46979,113.64244,45.610363,3.762588,251.89754,476.0291,634.50696,778.8287,847.42944,770.0518,55.66552,243.18141,1850.8461,885.2544,933.20703,1266.4436,1746.4135,1881.008,2023.4203,2227.2268,2525.9705,2663.5312,2859.0935,3168.3196,3418.0159,3787.0938,4296.348,5061.5996,6109.422,6969.5415,7527.239,7629.8154,7213.2812,6802.751,6591.2705,6475.2627,6261.9756,6117.34,6630.345,6586.6763,6055.851,6032.9404,6104.5024,6519.749,6825.9316,7011.0464,7025.8516,6613.6484,6267.0103,5978.459,5764.3066,5444.686,5081.8975,4735.0415,257.09583,824.0963,823.2781,1009.2633,1085.7036,615.4656,230.40584,1.050806};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {-656.3311,-1035.1285,-612.2803,-444.48666,-407.80133,-232.86748,-71.966484,-39.692467,320.0888,345.53735,426.80557,424.1541,18.670307,73.50921,845.9876,963.0869,892.1104,946.1044,1344.0885,1636.0017,1923.1205,2210.0352,2465.615,2663.893,2904.0312,3175.309,3520.0854,4014.2097,4606.2114,5549.7144,7163.4487,8779.363,9401.28,9209.052,8113.8228,7229.9136,6862.2637,6700.198,6525.8413,6453.558,6334.001,5910.911,6015.8887,6024.43,6145.8457,6642.381,6902.5903,7161.6562,7226.978,6709.532,6318.683,6317.838,6026.155,5688.974,5319.4204,4910.7134,-55.076607,79.40153,349.52887,-62.313168,243.7041,554.68134,177.65344,-237.08856,-761.49475,-1221.8392,-813.4421,-785.00464,-863.5855,-670.3758,-488.44287,136.53676,80.53159,-61.848656,-26.838533,-15.774974,-107.589386,139.11891,472.79745,882.8869,851.34515,982.7746,1261.6467,1540.9529,1836.0044,2117.9675,2385.695,2620.644,2903.3684,3263.3035,3663.311,4174.254,4782.9233,5872.477,7861.9517,9772.518,10668.281,10495.23,8736.991,7542.3276};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_36()
		{
			double[] value = {7032.282,6853.9233,6824.449,6864.4414,6351.517,5948.2236,6144.496,6226.9014,6426.6455,6787.1367,7106.6206,7303.662,7117.9443,6632.5015,6369.327,6595.028,6245.6816,5816.9204,5361.164,5074.5566,-1331.4915,-1261.3727,-1437.9574,-1737.4971,-1734.0654,-502.40842,-119.563995,-484.1206,-899.59735,-1169.8018,-772.1952,-1025.3069,-1001.44244,-770.7649,-672.2185,-409.72263,-441.99576,-452.78256,-102.07568,-248.91399,-98.576004,138.92358,237.38443,474.7605,658.068,851.52374,1131.1288,1413.322,1732.7009,1957.0386,2238.099,2601.2134,2895.6816,3282.611,3730.004,4230.596,4875.6206,5797.2876,7408.12,9611.418,12078.557,13400.433,10692.906,7821.7617,6976.5186,6886.0913,6902.739,6910.137,6900.4775,6280.857,6298.1772,6475.99,6715.4985,7016.521,7436.8545,7469.61,7107.8447,6278.55,6169.6963,6544.694,6281.4653,5348.7314,4971.5146,4854.128,-854.58636,-1336.1029,-1169.6023,-1918.8678,-2168.6772,-1415.167,-594.1921,-721.4593,-1108.8146,-1179.6855,-851.09796,-1092.1566,-1453.7478,-1077.183,-987.00024,-870.4737};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_37()
		{
			double[] value = {-660.7142,-616.9005,-459.73465,-385.30063,-114.17398,-13.342542,205.64508,249.03404,479.01382,712.275,1026.7831,1278.1172,1551.1588,1817.2812,2151.6418,2517.7434,2824.6807,3164.8462,3610.6633,4130.2866,4710.3076,5357.7046,6346.631,9051.341,14992.851,16357.815,15195.852,9786.457,6975.0967,6927.0845,6964.717,6952.897,7133.0146,6879.763,6706.548,6701.922,6864.061,7023.661,7299.334,7498.1997,7097.1167,6793.3076,5751.5,5571.088,5626.941,3138.9263,4541.196,5187.964,-851.03784,-886.44354,-1062.1014,-1696.1547,-1674.1731,-2254.1409,-1584.9637,-950.80756,-1148.7924,-1211.5184,-1551.8234,-1720.5776,-1737.1377,-1713.901,-859.046,-896.2057,-720.9618,-737.12195,-582.7005,-555.3129,-363.9355,-285.78983,-104.1966,80.43325,312.73776,513.0824,897.7318,1073.2867,1328.0729,1736.2041,2035.6543,2292.6873,2676.0823,3064.4475,3508.589,3956.07,4415.3364,4800.2974,5338.1743,8733.896,15407.054,16364.783,14907.202,10687.058,7394.9688,7104.0293,7094.983,7047.506,7017.4443,7086.672,7029.267,6529.0347};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_38()
		{
			double[] value = {6976.619,7089.1562,7156.9395,7203.981,6720.3384,6861.497,5861.6465,6336.3965,3474.6672,2123.3955,4768.5015,5343.423,-1305.4935,-1283.2975,-1309.6168,-1447.8005,-1527.9164,-2301.4592,-2424.7231,-2058.393,-1584.3497,-1668.114,-2017.2788,-2147.6511,-1935.4818,-1402.9529,-1452.432,-1078.6396,-1007.8224,-822.05457,-880.18854,-861.53345,-1027.801,-950.7896,-755.93427,-369.96182,58.32963,321.1174,635.6603,929.44006,1231.0328,1586.5763,1835.6497,2172.4553,2560.2603,2926.4868,3293.1274,3691.8682,4075.5562,4356.181,5095.5845,7789.77,11828.072,13129.829,11824.681,10034.396,8042.5703,7302.0947,7140.683,7028.341,6921.1914,6879.7783,7086.5933,7123.5464,7004.1626,6866.549,6861.8096,6579.4023,5646.0806,5727.458,4194.019,6500.2056,3163.393,262.09653,2238.0598,3561.9062,-1583.4535,-1691.407,-1672.4211,-1632.9614,-1549.2465,-1623.9067,-2472.3687,-2552.1167,-2294.0054,-2289.373,-2416.5935,-2599.807,-2129.9556,-1773.953,-1246.599,-823.51807,-988.61725,-1293.3945,-1349.5684,-1461.9672,-1721.2859,-1752.909,-1557.0034,-1070.6041};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_39()
		{
			double[] value = {-409.92276,195.02808,236.38515,632.2406,1030.2114,1302.9886,1564.1155,1987.6779,2341.2988,2689.3137,3052.989,3418.964,3744.7505,4163.501,4815.1875,6160.7646,7833.1426,9048.738,9818.877,9434.386,8138.5923,7402.985,7209.847,7014.254,6799.4663,6712.7773,6908.6885,6878.373,6834.2173,6658.869,6851.7456,6673.817,6268.002,6335.005,4687.207,4620.1567,2301.7678,899.4923,1951.7931,1673.1002,-1637.5176,-1726.0985,-1917.6403,-1895.8358,-1767.9249,-1672.8995,-2465.041,-2822.543,-2835.9604,-2776.9473,-2720.7273,-2289.3281,-1805.9371,-1996.4459,-1223.6273,-641.26434,-525.59534,-1843.9615,-1795.8649,-2096.4434,-2474.4065,-2534.2917,-2173.3237,-1540.2854,-1118.6597,-574.64294,-291.80573,51.85964,517.6259,877.981,1275.295,1599.0674,2009.7498,2427.6008,2770.8193,3124.5876,3427.7773,3946.0896,4563.001,5161.6694,6008.9624,7327.4067,8016.707,8131.033,7668.331,7513.939,7475.3794,7117.1436,6707.071,6489.8945,6449.9272,6406.4414,6295.3667,6164.3296,6462.473,6718.085,6559.6597,6192.383,6071.389,5839.3413};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_40()
		{
			double[] value = {4314.833,4428.5605,3866.9211,2249.7878,-1846.731,-1898.4558,-2062.493,-2209.4675,-2142.8105,-2039.0984,-2713.0842,-3050.029,-3024.8054,-2938.593,-2685.5652,-2201.7534,-2340.8733,-1612.5046,-993.93677,-249.44197,-435.08652,-2477.8977,-2321.572,-2622.2627,-2792.952,-2299.9658,-1108.3837,-277.17822,-673.8259,-1218.133,-829.9502,-409.16254,37.246696,569.2016,803.4761,1014.0041,1494.0852,1933.6125,2406.838,2807.4077,3188.6033,3733.0513,4251.2036,4722.5464,5494.2046,6436.9795,7037.7847,7225.556,7316.472,7872.4224,7891.149,7159.5024,6537.1855,6253.6123,6013.521,5853.186,5729.581,5807.9434,5823.4824,6101.546,6236.6284,5772.9165,5640.341,5235.003,4645.1904,4309.2905,4116.4224,4044.0813,-2133.7754,-2126.4841,-2205.3435,-2401.6223,-2582.426,-2546.6868,-2971.1145,-3147.3103,-3068.8474,-2982.1702,-2669.719,-2653.2065,-1957.5421,-1386.1315,-703.5533,-36.568863,-852.86255,-2618.212,-2652.1702,-2948.0671,-2705.0354,-1733.8522,-985.4627,-1265.1997,-1689.4204,-1488.2023,-931.593,-476.46768,-243.36026,87.70893,325.3626,635.1118};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_41()
		{
			double[] value = {1112.7319,1565.1246,2112.8208,2611.1157,3031.395,3512.2275,3981.106,4442.0063,4981.0825,5688.8994,6353.4897,6755.8022,7204.821,8671.9,9492.207,7965.2817,6307.4536,6035.7935,5845.538,5666.8784,5515.966,5417.1343,5314.724,5412.816,5545.5635,4999.6255,4574.1475,4238.3896,3977.7212,3759.6316,3526.2947,3137.991,-2279.6575,-2186.1406,-2269.7097,-2545.2317,-2818.2412,-2845.2334,-2885.3352,-3077.9055,-3084.6006,-3197.7427,-3194.57,-2416.4746,-1972.2056,-1491.9081,-738.09424,-495.65036,-1644.8264,-2908.5256,-2942.5537,-3005.8794,-2617.3237,-1985.2458,-2033.4779,-2002.1957,-1903.8896,-1096.9602,-745.2059,-825.2428,-564.57666,-388.72366,-28.910065,595.1371,1125.2108,1587.2686,2027.5117,2377.2864,2781.93,3352.054,3905.6294,4339.8345,4639.1685,4988.8804,5591.184,6097.525,6716.792,9671.032,12625.076,10885.722,6896.794,5783.008,5683.2017,5577.436,5451.576,5258.42,5085.092,4900.3643,4623.3794,4289.785,4036.6272,3887.006,3701.4104,3463.1477,3233.0781,2925.5825};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.01587,0.00391,0.03175,0.00391,0.04762,0.00391,0.06349,0.00391,0.07937,0.00391,0.09524,0.00391,0.11111,0.00391,0.12698,0.00391,0.14286,0.00391,0.15873,0.00391,0.1746,0.00391,0.19048,0.00391,0.20635,0.00391,0.22222,0.00391,0.2381,0.00391,0.25397,0.00391,0.26984,0.00391,0.28571,0.00391,0.30159,0.00391,0.31746,0.00391,0.33333,0.00391,0.34921,0.00391,0.36508,0.00391,0.38095,0.00391,0.39683,0.00391,0.4127,0.00391,0.42857,0.00391,0.44444,0.00391,0.46032,0.00391,0.47619,0.00391,0.49206,0.00391,0.50794,0.00391,0.52381,0.00391,0.53968,0.00391,0.55556,0.00391,0.57143,0.00391,0.5873,0.00391,0.60317,0.00391,0.61905,0.00391,0.63492,0.00391,0.65079,0.00391,0.66667,0.00391,0.68254,0.00391,0.69841,0.00391,0.71429,0.00391,0.73016,0.00391,0.74603,0.00391,0.7619,0.00391,0.77778,0.00391,0.79365,0.00391,0.80952,0.00391,0.8254,0.00391,0.84127,0.00391,0.85714,0.00391,0.87302,0.00391,0.88889,0.00391,0.90476,0.00391,0.92063,0.00391,0.93651,0.00391,0.95238,0.00391,0.96825,0.00391,0.98413,0.00391,0.99609,0.00391,0.00391,0.01587,0.01587,0.01587,0.03175,0.01587,0.04762,0.01587,0.06349,0.01587,0.07937,0.01587,0.09524,0.01587,0.11111,0.01587,0.12698,0.01587,0.14286,0.01587,0.15873,0.01587,0.1746,0.01587,0.19048,0.01587,0.20635,0.01587,0.22222,0.01587,0.2381,0.01587,0.25397,0.01587,0.26984,0.01587,0.28571,0.01587,0.30159,0.01587,0.31746,0.01587,0.33333,0.01587,0.34921,0.01587,0.36508,0.01587,0.38095,0.01587,0.39683,0.01587,0.4127,0.01587,0.42857,0.01587,0.44444,0.01587,0.46032,0.01587,0.47619,0.01587,0.49206,0.01587,0.50794,0.01587,0.52381,0.01587,0.53968,0.01587,0.55556,0.01587};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.57143,0.01587,0.5873,0.01587,0.60317,0.01587,0.61905,0.01587,0.63492,0.01587,0.65079,0.01587,0.66667,0.01587,0.68254,0.01587,0.69841,0.01587,0.71429,0.01587,0.73016,0.01587,0.74603,0.01587,0.7619,0.01587,0.77778,0.01587,0.79365,0.01587,0.80952,0.01587,0.8254,0.01587,0.84127,0.01587,0.85714,0.01587,0.87302,0.01587,0.88889,0.01587,0.90476,0.01587,0.92063,0.01587,0.93651,0.01587,0.95238,0.01587,0.96825,0.01587,0.98413,0.01587,0.99609,0.01587,0.00391,0.03175,0.01587,0.03175,0.03175,0.03175,0.04762,0.03175,0.06349,0.03175,0.07937,0.03175,0.09524,0.03175,0.11111,0.03175,0.12698,0.03175,0.14286,0.03175,0.15873,0.03175,0.1746,0.03175,0.19048,0.03175,0.20635,0.03175,0.22222,0.03175,0.2381,0.03175,0.25397,0.03175,0.26984,0.03175,0.28571,0.03175,0.30159,0.03175,0.31746,0.03175,0.33333,0.03175,0.34921,0.03175,0.36508,0.03175,0.38095,0.03175,0.39683,0.03175,0.4127,0.03175,0.42857,0.03175,0.44444,0.03175,0.46032,0.03175,0.47619,0.03175,0.49206,0.03175,0.50794,0.03175,0.52381,0.03175,0.53968,0.03175,0.55556,0.03175,0.57143,0.03175,0.5873,0.03175,0.60317,0.03175,0.61905,0.03175,0.63492,0.03175,0.65079,0.03175,0.66667,0.03175,0.68254,0.03175,0.69841,0.03175,0.71429,0.03175,0.73016,0.03175,0.74603,0.03175,0.7619,0.03175,0.77778,0.03175,0.79365,0.03175,0.80952,0.03175,0.8254,0.03175,0.84127,0.03175,0.85714,0.03175,0.87302,0.03175,0.88889,0.03175,0.90476,0.03175,0.92063,0.03175,0.93651,0.03175,0.95238,0.03175,0.96825,0.03175,0.98413,0.03175,0.99609,0.03175,0.00391,0.04762,0.01587,0.04762,0.03175,0.04762,0.04762,0.04762,0.06349,0.04762,0.07937,0.04762,0.09524,0.04762,0.11111,0.04762};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.12698,0.04762,0.14286,0.04762,0.15873,0.04762,0.1746,0.04762,0.19048,0.04762,0.20635,0.04762,0.22222,0.04762,0.2381,0.04762,0.25397,0.04762,0.26984,0.04762,0.28571,0.04762,0.30159,0.04762,0.31746,0.04762,0.33333,0.04762,0.34921,0.04762,0.36508,0.04762,0.38095,0.04762,0.39683,0.04762,0.4127,0.04762,0.42857,0.04762,0.44444,0.04762,0.46032,0.04762,0.47619,0.04762,0.49206,0.04762,0.50794,0.04762,0.52381,0.04762,0.53968,0.04762,0.55556,0.04762,0.57143,0.04762,0.5873,0.04762,0.60317,0.04762,0.61905,0.04762,0.63492,0.04762,0.65079,0.04762,0.66667,0.04762,0.68254,0.04762,0.69841,0.04762,0.71429,0.04762,0.73016,0.04762,0.74603,0.04762,0.7619,0.04762,0.77778,0.04762,0.79365,0.04762,0.80952,0.04762,0.8254,0.04762,0.84127,0.04762,0.85714,0.04762,0.87302,0.04762,0.88889,0.04762,0.90476,0.04762,0.92063,0.04762,0.93651,0.04762,0.95238,0.04762,0.96825,0.04762,0.98413,0.04762,0.99609,0.04762,0.00391,0.06349,0.01587,0.06349,0.03175,0.06349,0.04762,0.06349,0.06349,0.06349,0.07937,0.06349,0.09524,0.06349,0.11111,0.06349,0.12698,0.06349,0.14286,0.06349,0.15873,0.06349,0.1746,0.06349,0.19048,0.06349,0.20635,0.06349,0.22222,0.06349,0.2381,0.06349,0.25397,0.06349,0.26984,0.06349,0.28571,0.06349,0.30159,0.06349,0.31746,0.06349,0.33333,0.06349,0.34921,0.06349,0.36508,0.06349,0.38095,0.06349,0.39683,0.06349,0.4127,0.06349,0.42857,0.06349,0.44444,0.06349,0.46032,0.06349,0.47619,0.06349,0.49206,0.06349,0.50794,0.06349,0.52381,0.06349,0.53968,0.06349,0.55556,0.06349,0.57143,0.06349,0.5873,0.06349,0.60317,0.06349,0.61905,0.06349,0.63492,0.06349,0.65079,0.06349,0.66667,0.06349,0.68254,0.06349};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.69841,0.06349,0.71429,0.06349,0.73016,0.06349,0.74603,0.06349,0.7619,0.06349,0.77778,0.06349,0.79365,0.06349,0.80952,0.06349,0.8254,0.06349,0.84127,0.06349,0.85714,0.06349,0.87302,0.06349,0.88889,0.06349,0.90476,0.06349,0.92063,0.06349,0.93651,0.06349,0.95238,0.06349,0.96825,0.06349,0.98413,0.06349,0.99609,0.06349,0.00391,0.07937,0.01587,0.07937,0.03175,0.07937,0.04762,0.07937,0.06349,0.07937,0.07937,0.07937,0.09524,0.07937,0.11111,0.07937,0.12698,0.07937,0.14286,0.07937,0.15873,0.07937,0.1746,0.07937,0.19048,0.07937,0.20635,0.07937,0.22222,0.07937,0.2381,0.07937,0.25397,0.07937,0.26984,0.07937,0.28571,0.07937,0.30159,0.07937,0.31746,0.07937,0.33333,0.07937,0.34921,0.07937,0.36508,0.07937,0.38095,0.07937,0.39683,0.07937,0.4127,0.07937,0.42857,0.07937,0.44444,0.07937,0.46032,0.07937,0.47619,0.07937,0.49206,0.07937,0.50794,0.07937,0.52381,0.07937,0.53968,0.07937,0.55556,0.07937,0.57143,0.07937,0.5873,0.07937,0.60317,0.07937,0.61905,0.07937,0.63492,0.07937,0.65079,0.07937,0.66667,0.07937,0.68254,0.07937,0.69841,0.07937,0.71429,0.07937,0.73016,0.07937,0.74603,0.07937,0.7619,0.07937,0.77778,0.07937,0.79365,0.07937,0.80952,0.07937,0.8254,0.07937,0.84127,0.07937,0.85714,0.07937,0.87302,0.07937,0.88889,0.07937,0.90476,0.07937,0.92063,0.07937,0.93651,0.07937,0.95238,0.07937,0.96825,0.07937,0.98413,0.07937,0.99609,0.07937,0.00391,0.09524,0.01587,0.09524,0.03175,0.09524,0.04762,0.09524,0.06349,0.09524,0.07937,0.09524,0.09524,0.09524,0.11111,0.09524,0.12698,0.09524,0.14286,0.09524,0.15873,0.09524,0.1746,0.09524,0.19048,0.09524,0.20635,0.09524,0.22222,0.09524,0.2381,0.09524};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.25397,0.09524,0.26984,0.09524,0.28571,0.09524,0.30159,0.09524,0.31746,0.09524,0.33333,0.09524,0.34921,0.09524,0.36508,0.09524,0.38095,0.09524,0.39683,0.09524,0.4127,0.09524,0.42857,0.09524,0.44444,0.09524,0.46032,0.09524,0.47619,0.09524,0.49206,0.09524,0.50794,0.09524,0.52381,0.09524,0.53968,0.09524,0.55556,0.09524,0.57143,0.09524,0.5873,0.09524,0.60317,0.09524,0.61905,0.09524,0.63492,0.09524,0.65079,0.09524,0.66667,0.09524,0.68254,0.09524,0.69841,0.09524,0.71429,0.09524,0.73016,0.09524,0.74603,0.09524,0.7619,0.09524,0.77778,0.09524,0.79365,0.09524,0.80952,0.09524,0.8254,0.09524,0.84127,0.09524,0.85714,0.09524,0.87302,0.09524,0.88889,0.09524,0.90476,0.09524,0.92063,0.09524,0.93651,0.09524,0.95238,0.09524,0.96825,0.09524,0.98413,0.09524,0.99609,0.09524,0.00391,0.11111,0.01587,0.11111,0.03175,0.11111,0.04762,0.11111,0.06349,0.11111,0.07937,0.11111,0.09524,0.11111,0.11111,0.11111,0.12698,0.11111,0.14286,0.11111,0.15873,0.11111,0.1746,0.11111,0.19048,0.11111,0.20635,0.11111,0.22222,0.11111,0.2381,0.11111,0.25397,0.11111,0.26984,0.11111,0.28571,0.11111,0.30159,0.11111,0.31746,0.11111,0.33333,0.11111,0.34921,0.11111,0.36508,0.11111,0.38095,0.11111,0.39683,0.11111,0.4127,0.11111,0.42857,0.11111,0.44444,0.11111,0.46032,0.11111,0.47619,0.11111,0.49206,0.11111,0.50794,0.11111,0.52381,0.11111,0.53968,0.11111,0.55556,0.11111,0.57143,0.11111,0.5873,0.11111,0.60317,0.11111,0.61905,0.11111,0.63492,0.11111,0.65079,0.11111,0.66667,0.11111,0.68254,0.11111,0.69841,0.11111,0.71429,0.11111,0.73016,0.11111,0.74603,0.11111,0.7619,0.11111,0.77778,0.11111,0.79365,0.11111,0.80952,0.11111};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.8254,0.11111,0.84127,0.11111,0.85714,0.11111,0.87302,0.11111,0.88889,0.11111,0.90476,0.11111,0.92063,0.11111,0.93651,0.11111,0.95238,0.11111,0.96825,0.11111,0.98413,0.11111,0.99609,0.11111,0.00391,0.12698,0.01587,0.12698,0.03175,0.12698,0.04762,0.12698,0.06349,0.12698,0.07937,0.12698,0.09524,0.12698,0.11111,0.12698,0.12698,0.12698,0.14286,0.12698,0.15873,0.12698,0.1746,0.12698,0.19048,0.12698,0.20635,0.12698,0.22222,0.12698,0.2381,0.12698,0.25397,0.12698,0.26984,0.12698,0.28571,0.12698,0.30159,0.12698,0.31746,0.12698,0.33333,0.12698,0.34921,0.12698,0.36508,0.12698,0.38095,0.12698,0.39683,0.12698,0.4127,0.12698,0.42857,0.12698,0.44444,0.12698,0.46032,0.12698,0.47619,0.12698,0.49206,0.12698,0.50794,0.12698,0.52381,0.12698,0.53968,0.12698,0.55556,0.12698,0.57143,0.12698,0.5873,0.12698,0.60317,0.12698,0.61905,0.12698,0.63492,0.12698,0.65079,0.12698,0.66667,0.12698,0.68254,0.12698,0.69841,0.12698,0.71429,0.12698,0.73016,0.12698,0.74603,0.12698,0.7619,0.12698,0.77778,0.12698,0.79365,0.12698,0.80952,0.12698,0.8254,0.12698,0.84127,0.12698,0.85714,0.12698,0.87302,0.12698,0.88889,0.12698,0.90476,0.12698,0.92063,0.12698,0.93651,0.12698,0.95238,0.12698,0.96825,0.12698,0.98413,0.12698,0.99609,0.12698,0.00391,0.14286,0.01587,0.14286,0.03175,0.14286,0.04762,0.14286,0.06349,0.14286,0.07937,0.14286,0.09524,0.14286,0.11111,0.14286,0.12698,0.14286,0.14286,0.14286,0.15873,0.14286,0.1746,0.14286,0.19048,0.14286,0.20635,0.14286,0.22222,0.14286,0.2381,0.14286,0.25397,0.14286,0.26984,0.14286,0.28571,0.14286,0.30159,0.14286,0.31746,0.14286,0.33333,0.14286,0.34921,0.14286,0.36508,0.14286};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.38095,0.14286,0.39683,0.14286,0.4127,0.14286,0.42857,0.14286,0.44444,0.14286,0.46032,0.14286,0.47619,0.14286,0.49206,0.14286,0.50794,0.14286,0.52381,0.14286,0.53968,0.14286,0.55556,0.14286,0.57143,0.14286,0.5873,0.14286,0.60317,0.14286,0.61905,0.14286,0.63492,0.14286,0.65079,0.14286,0.66667,0.14286,0.68254,0.14286,0.69841,0.14286,0.71429,0.14286,0.73016,0.14286,0.74603,0.14286,0.7619,0.14286,0.77778,0.14286,0.79365,0.14286,0.80952,0.14286,0.8254,0.14286,0.84127,0.14286,0.85714,0.14286,0.87302,0.14286,0.88889,0.14286,0.90476,0.14286,0.92063,0.14286,0.93651,0.14286,0.95238,0.14286,0.96825,0.14286,0.98413,0.14286,0.99609,0.14286,0.00391,0.15873,0.01587,0.15873,0.03175,0.15873,0.04762,0.15873,0.06349,0.15873,0.07937,0.15873,0.09524,0.15873,0.11111,0.15873,0.12698,0.15873,0.14286,0.15873,0.15873,0.15873,0.1746,0.15873,0.19048,0.15873,0.20635,0.15873,0.22222,0.15873,0.2381,0.15873,0.25397,0.15873,0.26984,0.15873,0.28571,0.15873,0.30159,0.15873,0.31746,0.15873,0.33333,0.15873,0.34921,0.15873,0.36508,0.15873,0.38095,0.15873,0.39683,0.15873,0.4127,0.15873,0.42857,0.15873,0.44444,0.15873,0.46032,0.15873,0.47619,0.15873,0.49206,0.15873,0.50794,0.15873,0.52381,0.15873,0.53968,0.15873,0.55556,0.15873,0.57143,0.15873,0.5873,0.15873,0.60317,0.15873,0.61905,0.15873,0.63492,0.15873,0.65079,0.15873,0.66667,0.15873,0.68254,0.15873,0.69841,0.15873,0.71429,0.15873,0.73016,0.15873,0.74603,0.15873,0.7619,0.15873,0.77778,0.15873,0.79365,0.15873,0.80952,0.15873,0.8254,0.15873,0.84127,0.15873,0.85714,0.15873,0.87302,0.15873,0.88889,0.15873,0.90476,0.15873,0.92063,0.15873,0.93651,0.15873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.95238,0.15873,0.96825,0.15873,0.98413,0.15873,0.99609,0.15873,0.00391,0.1746,0.01587,0.1746,0.03175,0.1746,0.04762,0.1746,0.06349,0.1746,0.07937,0.1746,0.09524,0.1746,0.11111,0.1746,0.12698,0.1746,0.14286,0.1746,0.15873,0.1746,0.1746,0.1746,0.19048,0.1746,0.20635,0.1746,0.22222,0.1746,0.2381,0.1746,0.25397,0.1746,0.26984,0.1746,0.28571,0.1746,0.30159,0.1746,0.31746,0.1746,0.33333,0.1746,0.34921,0.1746,0.36508,0.1746,0.38095,0.1746,0.39683,0.1746,0.4127,0.1746,0.42857,0.1746,0.44444,0.1746,0.46032,0.1746,0.47619,0.1746,0.49206,0.1746,0.50794,0.1746,0.52381,0.1746,0.53968,0.1746,0.55556,0.1746,0.57143,0.1746,0.5873,0.1746,0.60317,0.1746,0.61905,0.1746,0.63492,0.1746,0.65079,0.1746,0.66667,0.1746,0.68254,0.1746,0.69841,0.1746,0.71429,0.1746,0.73016,0.1746,0.74603,0.1746,0.7619,0.1746,0.77778,0.1746,0.79365,0.1746,0.80952,0.1746,0.8254,0.1746,0.84127,0.1746,0.85714,0.1746,0.87302,0.1746,0.88889,0.1746,0.90476,0.1746,0.92063,0.1746,0.93651,0.1746,0.95238,0.1746,0.96825,0.1746,0.98413,0.1746,0.99609,0.1746,0.00391,0.19048,0.01587,0.19048,0.03175,0.19048,0.04762,0.19048,0.06349,0.19048,0.07937,0.19048,0.09524,0.19048,0.11111,0.19048,0.12698,0.19048,0.14286,0.19048,0.15873,0.19048,0.1746,0.19048,0.19048,0.19048,0.20635,0.19048,0.22222,0.19048,0.2381,0.19048,0.25397,0.19048,0.26984,0.19048,0.28571,0.19048,0.30159,0.19048,0.31746,0.19048,0.33333,0.19048,0.34921,0.19048,0.36508,0.19048,0.38095,0.19048,0.39683,0.19048,0.4127,0.19048,0.42857,0.19048,0.44444,0.19048,0.46032,0.19048,0.47619,0.19048,0.49206,0.19048};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.50794,0.19048,0.52381,0.19048,0.53968,0.19048,0.55556,0.19048,0.57143,0.19048,0.5873,0.19048,0.60317,0.19048,0.61905,0.19048,0.63492,0.19048,0.65079,0.19048,0.66667,0.19048,0.68254,0.19048,0.69841,0.19048,0.71429,0.19048,0.73016,0.19048,0.74603,0.19048,0.7619,0.19048,0.77778,0.19048,0.79365,0.19048,0.80952,0.19048,0.8254,0.19048,0.84127,0.19048,0.85714,0.19048,0.87302,0.19048,0.88889,0.19048,0.90476,0.19048,0.92063,0.19048,0.93651,0.19048,0.95238,0.19048,0.96825,0.19048,0.98413,0.19048,0.99609,0.19048,0.00391,0.20635,0.01587,0.20635,0.03175,0.20635,0.04762,0.20635,0.06349,0.20635,0.07937,0.20635,0.09524,0.20635,0.11111,0.20635,0.12698,0.20635,0.14286,0.20635,0.15873,0.20635,0.1746,0.20635,0.19048,0.20635,0.20635,0.20635,0.22222,0.20635,0.2381,0.20635,0.25397,0.20635,0.26984,0.20635,0.28571,0.20635,0.30159,0.20635,0.31746,0.20635,0.33333,0.20635,0.34921,0.20635,0.36508,0.20635,0.38095,0.20635,0.39683,0.20635,0.4127,0.20635,0.42857,0.20635,0.44444,0.20635,0.46032,0.20635,0.47619,0.20635,0.49206,0.20635,0.50794,0.20635,0.52381,0.20635,0.53968,0.20635,0.55556,0.20635,0.57143,0.20635,0.5873,0.20635,0.60317,0.20635,0.61905,0.20635,0.63492,0.20635,0.65079,0.20635,0.66667,0.20635,0.68254,0.20635,0.69841,0.20635,0.71429,0.20635,0.73016,0.20635,0.74603,0.20635,0.7619,0.20635,0.77778,0.20635,0.79365,0.20635,0.80952,0.20635,0.8254,0.20635,0.84127,0.20635,0.85714,0.20635,0.87302,0.20635,0.88889,0.20635,0.90476,0.20635,0.92063,0.20635,0.93651,0.20635,0.95238,0.20635,0.96825,0.20635,0.98413,0.20635,0.99609,0.20635,0.00391,0.22222,0.01587,0.22222,0.03175,0.22222,0.04762,0.22222};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.06349,0.22222,0.07937,0.22222,0.09524,0.22222,0.11111,0.22222,0.12698,0.22222,0.14286,0.22222,0.15873,0.22222,0.1746,0.22222,0.19048,0.22222,0.20635,0.22222,0.22222,0.22222,0.2381,0.22222,0.25397,0.22222,0.26984,0.22222,0.28571,0.22222,0.30159,0.22222,0.31746,0.22222,0.33333,0.22222,0.34921,0.22222,0.36508,0.22222,0.38095,0.22222,0.39683,0.22222,0.4127,0.22222,0.42857,0.22222,0.44444,0.22222,0.46032,0.22222,0.47619,0.22222,0.49206,0.22222,0.50794,0.22222,0.52381,0.22222,0.53968,0.22222,0.55556,0.22222,0.57143,0.22222,0.5873,0.22222,0.60317,0.22222,0.61905,0.22222,0.63492,0.22222,0.65079,0.22222,0.66667,0.22222,0.68254,0.22222,0.69841,0.22222,0.71429,0.22222,0.73016,0.22222,0.74603,0.22222,0.7619,0.22222,0.77778,0.22222,0.79365,0.22222,0.80952,0.22222,0.8254,0.22222,0.84127,0.22222,0.85714,0.22222,0.87302,0.22222,0.88889,0.22222,0.90476,0.22222,0.92063,0.22222,0.93651,0.22222,0.95238,0.22222,0.96825,0.22222,0.98413,0.22222,0.99609,0.22222,0.00391,0.2381,0.01587,0.2381,0.03175,0.2381,0.04762,0.2381,0.06349,0.2381,0.07937,0.2381,0.09524,0.2381,0.11111,0.2381,0.12698,0.2381,0.14286,0.2381,0.15873,0.2381,0.1746,0.2381,0.19048,0.2381,0.20635,0.2381,0.22222,0.2381,0.2381,0.2381,0.25397,0.2381,0.26984,0.2381,0.28571,0.2381,0.30159,0.2381,0.31746,0.2381,0.33333,0.2381,0.34921,0.2381,0.36508,0.2381,0.38095,0.2381,0.39683,0.2381,0.4127,0.2381,0.42857,0.2381,0.44444,0.2381,0.46032,0.2381,0.47619,0.2381,0.49206,0.2381,0.50794,0.2381,0.52381,0.2381,0.53968,0.2381,0.55556,0.2381,0.57143,0.2381,0.5873,0.2381,0.60317,0.2381,0.61905,0.2381};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.63492,0.2381,0.65079,0.2381,0.66667,0.2381,0.68254,0.2381,0.69841,0.2381,0.71429,0.2381,0.73016,0.2381,0.74603,0.2381,0.7619,0.2381,0.77778,0.2381,0.79365,0.2381,0.80952,0.2381,0.8254,0.2381,0.84127,0.2381,0.85714,0.2381,0.87302,0.2381,0.88889,0.2381,0.90476,0.2381,0.92063,0.2381,0.93651,0.2381,0.95238,0.2381,0.96825,0.2381,0.98413,0.2381,0.99609,0.2381,0.00391,0.25397,0.01587,0.25397,0.03175,0.25397,0.04762,0.25397,0.06349,0.25397,0.07937,0.25397,0.09524,0.25397,0.11111,0.25397,0.12698,0.25397,0.14286,0.25397,0.15873,0.25397,0.1746,0.25397,0.19048,0.25397,0.20635,0.25397,0.22222,0.25397,0.2381,0.25397,0.25397,0.25397,0.26984,0.25397,0.28571,0.25397,0.30159,0.25397,0.31746,0.25397,0.33333,0.25397,0.34921,0.25397,0.36508,0.25397,0.38095,0.25397,0.39683,0.25397,0.4127,0.25397,0.42857,0.25397,0.44444,0.25397,0.46032,0.25397,0.47619,0.25397,0.49206,0.25397,0.50794,0.25397,0.52381,0.25397,0.53968,0.25397,0.55556,0.25397,0.57143,0.25397,0.5873,0.25397,0.60317,0.25397,0.61905,0.25397,0.63492,0.25397,0.65079,0.25397,0.66667,0.25397,0.68254,0.25397,0.69841,0.25397,0.71429,0.25397,0.73016,0.25397,0.74603,0.25397,0.7619,0.25397,0.77778,0.25397,0.79365,0.25397,0.80952,0.25397,0.8254,0.25397,0.84127,0.25397,0.85714,0.25397,0.87302,0.25397,0.88889,0.25397,0.90476,0.25397,0.92063,0.25397,0.93651,0.25397,0.95238,0.25397,0.96825,0.25397,0.98413,0.25397,0.99609,0.25397,0.00391,0.26984,0.01587,0.26984,0.03175,0.26984,0.04762,0.26984,0.06349,0.26984,0.07937,0.26984,0.09524,0.26984,0.11111,0.26984,0.12698,0.26984,0.14286,0.26984,0.15873,0.26984,0.1746,0.26984};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.19048,0.26984,0.20635,0.26984,0.22222,0.26984,0.2381,0.26984,0.25397,0.26984,0.26984,0.26984,0.28571,0.26984,0.30159,0.26984,0.31746,0.26984,0.33333,0.26984,0.34921,0.26984,0.36508,0.26984,0.38095,0.26984,0.39683,0.26984,0.4127,0.26984,0.42857,0.26984,0.44444,0.26984,0.46032,0.26984,0.47619,0.26984,0.49206,0.26984,0.50794,0.26984,0.52381,0.26984,0.53968,0.26984,0.55556,0.26984,0.57143,0.26984,0.5873,0.26984,0.60317,0.26984,0.61905,0.26984,0.63492,0.26984,0.65079,0.26984,0.66667,0.26984,0.68254,0.26984,0.69841,0.26984,0.71429,0.26984,0.73016,0.26984,0.74603,0.26984,0.7619,0.26984,0.77778,0.26984,0.79365,0.26984,0.80952,0.26984,0.8254,0.26984,0.84127,0.26984,0.85714,0.26984,0.87302,0.26984,0.88889,0.26984,0.90476,0.26984,0.92063,0.26984,0.93651,0.26984,0.95238,0.26984,0.96825,0.26984,0.98413,0.26984,0.99609,0.26984,0.00391,0.28571,0.01587,0.28571,0.03175,0.28571,0.04762,0.28571,0.06349,0.28571,0.07937,0.28571,0.09524,0.28571,0.11111,0.28571,0.12698,0.28571,0.14286,0.28571,0.15873,0.28571,0.1746,0.28571,0.19048,0.28571,0.20635,0.28571,0.22222,0.28571,0.2381,0.28571,0.25397,0.28571,0.26984,0.28571,0.28571,0.28571,0.30159,0.28571,0.31746,0.28571,0.33333,0.28571,0.34921,0.28571,0.36508,0.28571,0.38095,0.28571,0.39683,0.28571,0.4127,0.28571,0.42857,0.28571,0.44444,0.28571,0.46032,0.28571,0.47619,0.28571,0.49206,0.28571,0.50794,0.28571,0.52381,0.28571,0.53968,0.28571,0.55556,0.28571,0.57143,0.28571,0.5873,0.28571,0.60317,0.28571,0.61905,0.28571,0.63492,0.28571,0.65079,0.28571,0.66667,0.28571,0.68254,0.28571,0.69841,0.28571,0.71429,0.28571,0.73016,0.28571,0.74603,0.28571};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.7619,0.28571,0.77778,0.28571,0.79365,0.28571,0.80952,0.28571,0.8254,0.28571,0.84127,0.28571,0.85714,0.28571,0.87302,0.28571,0.88889,0.28571,0.90476,0.28571,0.92063,0.28571,0.93651,0.28571,0.95238,0.28571,0.96825,0.28571,0.98413,0.28571,0.99609,0.28571,0.00391,0.30159,0.01587,0.30159,0.03175,0.30159,0.04762,0.30159,0.06349,0.30159,0.07937,0.30159,0.09524,0.30159,0.11111,0.30159,0.12698,0.30159,0.14286,0.30159,0.15873,0.30159,0.1746,0.30159,0.19048,0.30159,0.20635,0.30159,0.22222,0.30159,0.2381,0.30159,0.25397,0.30159,0.26984,0.30159,0.28571,0.30159,0.30159,0.30159,0.31746,0.30159,0.33333,0.30159,0.34921,0.30159,0.36508,0.30159,0.38095,0.30159,0.39683,0.30159,0.4127,0.30159,0.42857,0.30159,0.44444,0.30159,0.46032,0.30159,0.47619,0.30159,0.49206,0.30159,0.50794,0.30159,0.52381,0.30159,0.53968,0.30159,0.55556,0.30159,0.57143,0.30159,0.5873,0.30159,0.60317,0.30159,0.61905,0.30159,0.63492,0.30159,0.65079,0.30159,0.66667,0.30159,0.68254,0.30159,0.69841,0.30159,0.71429,0.30159,0.73016,0.30159,0.74603,0.30159,0.7619,0.30159,0.77778,0.30159,0.79365,0.30159,0.80952,0.30159,0.8254,0.30159,0.84127,0.30159,0.85714,0.30159,0.87302,0.30159,0.88889,0.30159,0.90476,0.30159,0.92063,0.30159,0.93651,0.30159,0.95238,0.30159,0.96825,0.30159,0.98413,0.30159,0.99609,0.30159,0.00391,0.31746,0.01587,0.31746,0.03175,0.31746,0.04762,0.31746,0.06349,0.31746,0.07937,0.31746,0.09524,0.31746,0.11111,0.31746,0.12698,0.31746,0.14286,0.31746,0.15873,0.31746,0.1746,0.31746,0.19048,0.31746,0.20635,0.31746,0.22222,0.31746,0.2381,0.31746,0.25397,0.31746,0.26984,0.31746,0.28571,0.31746,0.30159,0.31746};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.31746,0.31746,0.33333,0.31746,0.34921,0.31746,0.36508,0.31746,0.38095,0.31746,0.39683,0.31746,0.4127,0.31746,0.42857,0.31746,0.44444,0.31746,0.46032,0.31746,0.47619,0.31746,0.49206,0.31746,0.50794,0.31746,0.52381,0.31746,0.53968,0.31746,0.55556,0.31746,0.57143,0.31746,0.5873,0.31746,0.60317,0.31746,0.61905,0.31746,0.63492,0.31746,0.65079,0.31746,0.66667,0.31746,0.68254,0.31746,0.69841,0.31746,0.71429,0.31746,0.73016,0.31746,0.74603,0.31746,0.7619,0.31746,0.77778,0.31746,0.79365,0.31746,0.80952,0.31746,0.8254,0.31746,0.84127,0.31746,0.85714,0.31746,0.87302,0.31746,0.88889,0.31746,0.90476,0.31746,0.92063,0.31746,0.93651,0.31746,0.95238,0.31746,0.96825,0.31746,0.98413,0.31746,0.99609,0.31746,0.00391,0.33333,0.01587,0.33333,0.03175,0.33333,0.04762,0.33333,0.06349,0.33333,0.07937,0.33333,0.09524,0.33333,0.11111,0.33333,0.12698,0.33333,0.14286,0.33333,0.15873,0.33333,0.1746,0.33333,0.19048,0.33333,0.20635,0.33333,0.22222,0.33333,0.2381,0.33333,0.25397,0.33333,0.26984,0.33333,0.28571,0.33333,0.30159,0.33333,0.31746,0.33333,0.33333,0.33333,0.34921,0.33333,0.36508,0.33333,0.38095,0.33333,0.39683,0.33333,0.4127,0.33333,0.42857,0.33333,0.44444,0.33333,0.46032,0.33333,0.47619,0.33333,0.49206,0.33333,0.50794,0.33333,0.52381,0.33333,0.53968,0.33333,0.55556,0.33333,0.57143,0.33333,0.5873,0.33333,0.60317,0.33333,0.61905,0.33333,0.63492,0.33333,0.65079,0.33333,0.66667,0.33333,0.68254,0.33333,0.69841,0.33333,0.71429,0.33333,0.73016,0.33333,0.74603,0.33333,0.7619,0.33333,0.77778,0.33333,0.79365,0.33333,0.80952,0.33333,0.8254,0.33333,0.84127,0.33333,0.85714,0.33333,0.87302,0.33333};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.88889,0.33333,0.90476,0.33333,0.92063,0.33333,0.93651,0.33333,0.95238,0.33333,0.96825,0.33333,0.98413,0.33333,0.99609,0.33333,0.00391,0.34921,0.01587,0.34921,0.03175,0.34921,0.04762,0.34921,0.06349,0.34921,0.07937,0.34921,0.09524,0.34921,0.11111,0.34921,0.12698,0.34921,0.14286,0.34921,0.15873,0.34921,0.1746,0.34921,0.19048,0.34921,0.20635,0.34921,0.22222,0.34921,0.2381,0.34921,0.25397,0.34921,0.26984,0.34921,0.28571,0.34921,0.30159,0.34921,0.31746,0.34921,0.33333,0.34921,0.34921,0.34921,0.36508,0.34921,0.38095,0.34921,0.39683,0.34921,0.4127,0.34921,0.42857,0.34921,0.44444,0.34921,0.46032,0.34921,0.47619,0.34921,0.49206,0.34921,0.50794,0.34921,0.52381,0.34921,0.53968,0.34921,0.55556,0.34921,0.57143,0.34921,0.5873,0.34921,0.60317,0.34921,0.61905,0.34921,0.63492,0.34921,0.65079,0.34921,0.66667,0.34921,0.68254,0.34921,0.69841,0.34921,0.71429,0.34921,0.73016,0.34921,0.74603,0.34921,0.7619,0.34921,0.77778,0.34921,0.79365,0.34921,0.80952,0.34921,0.8254,0.34921,0.84127,0.34921,0.85714,0.34921,0.87302,0.34921,0.88889,0.34921,0.90476,0.34921,0.92063,0.34921,0.93651,0.34921,0.95238,0.34921,0.96825,0.34921,0.98413,0.34921,0.99609,0.34921,0.00391,0.36508,0.01587,0.36508,0.03175,0.36508,0.04762,0.36508,0.06349,0.36508,0.07937,0.36508,0.09524,0.36508,0.11111,0.36508,0.12698,0.36508,0.14286,0.36508,0.15873,0.36508,0.1746,0.36508,0.19048,0.36508,0.20635,0.36508,0.22222,0.36508,0.2381,0.36508,0.25397,0.36508,0.26984,0.36508,0.28571,0.36508,0.30159,0.36508,0.31746,0.36508,0.33333,0.36508,0.34921,0.36508,0.36508,0.36508,0.38095,0.36508,0.39683,0.36508,0.4127,0.36508,0.42857,0.36508};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.44444,0.36508,0.46032,0.36508,0.47619,0.36508,0.49206,0.36508,0.50794,0.36508,0.52381,0.36508,0.53968,0.36508,0.55556,0.36508,0.57143,0.36508,0.5873,0.36508,0.60317,0.36508,0.61905,0.36508,0.63492,0.36508,0.65079,0.36508,0.66667,0.36508,0.68254,0.36508,0.69841,0.36508,0.71429,0.36508,0.73016,0.36508,0.74603,0.36508,0.7619,0.36508,0.77778,0.36508,0.79365,0.36508,0.80952,0.36508,0.8254,0.36508,0.84127,0.36508,0.85714,0.36508,0.87302,0.36508,0.88889,0.36508,0.90476,0.36508,0.92063,0.36508,0.93651,0.36508,0.95238,0.36508,0.96825,0.36508,0.98413,0.36508,0.99609,0.36508,0.00391,0.38095,0.01587,0.38095,0.03175,0.38095,0.04762,0.38095,0.06349,0.38095,0.07937,0.38095,0.09524,0.38095,0.11111,0.38095,0.12698,0.38095,0.14286,0.38095,0.15873,0.38095,0.1746,0.38095,0.19048,0.38095,0.20635,0.38095,0.22222,0.38095,0.2381,0.38095,0.25397,0.38095,0.26984,0.38095,0.28571,0.38095,0.30159,0.38095,0.31746,0.38095,0.33333,0.38095,0.34921,0.38095,0.36508,0.38095,0.38095,0.38095,0.39683,0.38095,0.4127,0.38095,0.42857,0.38095,0.44444,0.38095,0.46032,0.38095,0.47619,0.38095,0.49206,0.38095,0.50794,0.38095,0.52381,0.38095,0.53968,0.38095,0.55556,0.38095,0.57143,0.38095,0.5873,0.38095,0.60317,0.38095,0.61905,0.38095,0.63492,0.38095,0.65079,0.38095,0.66667,0.38095,0.68254,0.38095,0.69841,0.38095,0.71429,0.38095,0.73016,0.38095,0.74603,0.38095,0.7619,0.38095,0.77778,0.38095,0.79365,0.38095,0.80952,0.38095,0.8254,0.38095,0.84127,0.38095,0.85714,0.38095,0.87302,0.38095,0.88889,0.38095,0.90476,0.38095,0.92063,0.38095,0.93651,0.38095,0.95238,0.38095,0.96825,0.38095,0.98413,0.38095,0.99609,0.38095};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.00391,0.39683,0.01587,0.39683,0.03175,0.39683,0.04762,0.39683,0.06349,0.39683,0.07937,0.39683,0.09524,0.39683,0.11111,0.39683,0.12698,0.39683,0.14286,0.39683,0.15873,0.39683,0.1746,0.39683,0.19048,0.39683,0.20635,0.39683,0.22222,0.39683,0.2381,0.39683,0.25397,0.39683,0.26984,0.39683,0.28571,0.39683,0.30159,0.39683,0.31746,0.39683,0.33333,0.39683,0.34921,0.39683,0.36508,0.39683,0.38095,0.39683,0.39683,0.39683,0.4127,0.39683,0.42857,0.39683,0.44444,0.39683,0.46032,0.39683,0.47619,0.39683,0.49206,0.39683,0.50794,0.39683,0.52381,0.39683,0.53968,0.39683,0.55556,0.39683,0.57143,0.39683,0.5873,0.39683,0.60317,0.39683,0.61905,0.39683,0.63492,0.39683,0.65079,0.39683,0.66667,0.39683,0.68254,0.39683,0.69841,0.39683,0.71429,0.39683,0.73016,0.39683,0.74603,0.39683,0.7619,0.39683,0.77778,0.39683,0.79365,0.39683,0.80952,0.39683,0.8254,0.39683,0.84127,0.39683,0.85714,0.39683,0.87302,0.39683,0.88889,0.39683,0.90476,0.39683,0.92063,0.39683,0.93651,0.39683,0.95238,0.39683,0.96825,0.39683,0.98413,0.39683,0.99609,0.39683,0.00391,0.4127,0.01587,0.4127,0.03175,0.4127,0.04762,0.4127,0.06349,0.4127,0.07937,0.4127,0.09524,0.4127,0.11111,0.4127,0.12698,0.4127,0.14286,0.4127,0.15873,0.4127,0.1746,0.4127,0.19048,0.4127,0.20635,0.4127,0.22222,0.4127,0.2381,0.4127,0.25397,0.4127,0.26984,0.4127,0.28571,0.4127,0.30159,0.4127,0.31746,0.4127,0.33333,0.4127,0.34921,0.4127,0.36508,0.4127,0.38095,0.4127,0.39683,0.4127,0.4127,0.4127,0.42857,0.4127,0.44444,0.4127,0.46032,0.4127,0.47619,0.4127,0.49206,0.4127,0.50794,0.4127,0.52381,0.4127,0.53968,0.4127,0.55556,0.4127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.57143,0.4127,0.5873,0.4127,0.60317,0.4127,0.61905,0.4127,0.63492,0.4127,0.65079,0.4127,0.66667,0.4127,0.68254,0.4127,0.69841,0.4127,0.71429,0.4127,0.73016,0.4127,0.74603,0.4127,0.7619,0.4127,0.77778,0.4127,0.79365,0.4127,0.80952,0.4127,0.8254,0.4127,0.84127,0.4127,0.85714,0.4127,0.87302,0.4127,0.88889,0.4127,0.90476,0.4127,0.92063,0.4127,0.93651,0.4127,0.95238,0.4127,0.96825,0.4127,0.98413,0.4127,0.99609,0.4127,0.00391,0.42857,0.01587,0.42857,0.03175,0.42857,0.04762,0.42857,0.06349,0.42857,0.07937,0.42857,0.09524,0.42857,0.11111,0.42857,0.12698,0.42857,0.14286,0.42857,0.15873,0.42857,0.1746,0.42857,0.19048,0.42857,0.20635,0.42857,0.22222,0.42857,0.2381,0.42857,0.25397,0.42857,0.26984,0.42857,0.28571,0.42857,0.30159,0.42857,0.31746,0.42857,0.33333,0.42857,0.34921,0.42857,0.36508,0.42857,0.38095,0.42857,0.39683,0.42857,0.4127,0.42857,0.42857,0.42857,0.44444,0.42857,0.46032,0.42857,0.47619,0.42857,0.49206,0.42857,0.50794,0.42857,0.52381,0.42857,0.53968,0.42857,0.55556,0.42857,0.57143,0.42857,0.5873,0.42857,0.60317,0.42857,0.61905,0.42857,0.63492,0.42857,0.65079,0.42857,0.66667,0.42857,0.68254,0.42857,0.69841,0.42857,0.71429,0.42857,0.73016,0.42857,0.74603,0.42857,0.7619,0.42857,0.77778,0.42857,0.79365,0.42857,0.80952,0.42857,0.8254,0.42857,0.84127,0.42857,0.85714,0.42857,0.87302,0.42857,0.88889,0.42857,0.90476,0.42857,0.92063,0.42857,0.93651,0.42857,0.95238,0.42857,0.96825,0.42857,0.98413,0.42857,0.99609,0.42857,0.00391,0.44444,0.01587,0.44444,0.03175,0.44444,0.04762,0.44444,0.06349,0.44444,0.07937,0.44444,0.09524,0.44444,0.11111,0.44444};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.12698,0.44444,0.14286,0.44444,0.15873,0.44444,0.1746,0.44444,0.19048,0.44444,0.20635,0.44444,0.22222,0.44444,0.2381,0.44444,0.25397,0.44444,0.26984,0.44444,0.28571,0.44444,0.30159,0.44444,0.31746,0.44444,0.33333,0.44444,0.34921,0.44444,0.36508,0.44444,0.38095,0.44444,0.39683,0.44444,0.4127,0.44444,0.42857,0.44444,0.44444,0.44444,0.46032,0.44444,0.47619,0.44444,0.49206,0.44444,0.50794,0.44444,0.52381,0.44444,0.53968,0.44444,0.55556,0.44444,0.57143,0.44444,0.5873,0.44444,0.60317,0.44444,0.61905,0.44444,0.63492,0.44444,0.65079,0.44444,0.66667,0.44444,0.68254,0.44444,0.69841,0.44444,0.71429,0.44444,0.73016,0.44444,0.74603,0.44444,0.7619,0.44444,0.77778,0.44444,0.79365,0.44444,0.80952,0.44444,0.8254,0.44444,0.84127,0.44444,0.85714,0.44444,0.87302,0.44444,0.88889,0.44444,0.90476,0.44444,0.92063,0.44444,0.93651,0.44444,0.95238,0.44444,0.96825,0.44444,0.98413,0.44444,0.99609,0.44444,0.00391,0.46032,0.01587,0.46032,0.03175,0.46032,0.04762,0.46032,0.06349,0.46032,0.07937,0.46032,0.09524,0.46032,0.11111,0.46032,0.12698,0.46032,0.14286,0.46032,0.15873,0.46032,0.1746,0.46032,0.19048,0.46032,0.20635,0.46032,0.22222,0.46032,0.2381,0.46032,0.25397,0.46032,0.26984,0.46032,0.28571,0.46032,0.30159,0.46032,0.31746,0.46032,0.33333,0.46032,0.34921,0.46032,0.36508,0.46032,0.38095,0.46032,0.39683,0.46032,0.4127,0.46032,0.42857,0.46032,0.44444,0.46032,0.46032,0.46032,0.47619,0.46032,0.49206,0.46032,0.50794,0.46032,0.52381,0.46032,0.53968,0.46032,0.55556,0.46032,0.57143,0.46032,0.5873,0.46032,0.60317,0.46032,0.61905,0.46032,0.63492,0.46032,0.65079,0.46032,0.66667,0.46032,0.68254,0.46032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.69841,0.46032,0.71429,0.46032,0.73016,0.46032,0.74603,0.46032,0.7619,0.46032,0.77778,0.46032,0.79365,0.46032,0.80952,0.46032,0.8254,0.46032,0.84127,0.46032,0.85714,0.46032,0.87302,0.46032,0.88889,0.46032,0.90476,0.46032,0.92063,0.46032,0.93651,0.46032,0.95238,0.46032,0.96825,0.46032,0.98413,0.46032,0.99609,0.46032,0.00391,0.47619,0.01587,0.47619,0.03175,0.47619,0.04762,0.47619,0.06349,0.47619,0.07937,0.47619,0.09524,0.47619,0.11111,0.47619,0.12698,0.47619,0.14286,0.47619,0.15873,0.47619,0.1746,0.47619,0.19048,0.47619,0.20635,0.47619,0.22222,0.47619,0.2381,0.47619,0.25397,0.47619,0.26984,0.47619,0.28571,0.47619,0.30159,0.47619,0.31746,0.47619,0.33333,0.47619,0.34921,0.47619,0.36508,0.47619,0.38095,0.47619,0.39683,0.47619,0.4127,0.47619,0.42857,0.47619,0.44444,0.47619,0.46032,0.47619,0.47619,0.47619,0.49206,0.47619,0.50794,0.47619,0.52381,0.47619,0.53968,0.47619,0.55556,0.47619,0.57143,0.47619,0.5873,0.47619,0.60317,0.47619,0.61905,0.47619,0.63492,0.47619,0.65079,0.47619,0.66667,0.47619,0.68254,0.47619,0.69841,0.47619,0.71429,0.47619,0.73016,0.47619,0.74603,0.47619,0.7619,0.47619,0.77778,0.47619,0.79365,0.47619,0.80952,0.47619,0.8254,0.47619,0.84127,0.47619,0.85714,0.47619,0.87302,0.47619,0.88889,0.47619,0.90476,0.47619,0.92063,0.47619,0.93651,0.47619,0.95238,0.47619,0.96825,0.47619,0.98413,0.47619,0.99609,0.47619,0.00391,0.49206,0.01587,0.49206,0.03175,0.49206,0.04762,0.49206,0.06349,0.49206,0.07937,0.49206,0.09524,0.49206,0.11111,0.49206,0.12698,0.49206,0.14286,0.49206,0.15873,0.49206,0.1746,0.49206,0.19048,0.49206,0.20635,0.49206,0.22222,0.49206,0.2381,0.49206};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.25397,0.49206,0.26984,0.49206,0.28571,0.49206,0.30159,0.49206,0.31746,0.49206,0.33333,0.49206,0.34921,0.49206,0.36508,0.49206,0.38095,0.49206,0.39683,0.49206,0.4127,0.49206,0.42857,0.49206,0.44444,0.49206,0.46032,0.49206,0.47619,0.49206,0.49206,0.49206,0.50794,0.49206,0.52381,0.49206,0.53968,0.49206,0.55556,0.49206,0.57143,0.49206,0.5873,0.49206,0.60317,0.49206,0.61905,0.49206,0.63492,0.49206,0.65079,0.49206,0.66667,0.49206,0.68254,0.49206,0.69841,0.49206,0.71429,0.49206,0.73016,0.49206,0.74603,0.49206,0.7619,0.49206,0.77778,0.49206,0.79365,0.49206,0.80952,0.49206,0.8254,0.49206,0.84127,0.49206,0.85714,0.49206,0.87302,0.49206,0.88889,0.49206,0.90476,0.49206,0.92063,0.49206,0.93651,0.49206,0.95238,0.49206,0.96825,0.49206,0.98413,0.49206,0.99609,0.49206,0.00391,0.50794,0.01587,0.50794,0.03175,0.50794,0.04762,0.50794,0.06349,0.50794,0.07937,0.50794,0.09524,0.50794,0.11111,0.50794,0.12698,0.50794,0.14286,0.50794,0.15873,0.50794,0.1746,0.50794,0.19048,0.50794,0.20635,0.50794,0.22222,0.50794,0.2381,0.50794,0.25397,0.50794,0.26984,0.50794,0.28571,0.50794,0.30159,0.50794,0.31746,0.50794,0.33333,0.50794,0.34921,0.50794,0.36508,0.50794,0.38095,0.50794,0.39683,0.50794,0.4127,0.50794,0.42857,0.50794,0.44444,0.50794,0.46032,0.50794,0.47619,0.50794,0.49206,0.50794,0.50794,0.50794,0.52381,0.50794,0.53968,0.50794,0.55556,0.50794,0.57143,0.50794,0.5873,0.50794,0.60317,0.50794,0.61905,0.50794,0.63492,0.50794,0.65079,0.50794,0.66667,0.50794,0.68254,0.50794,0.69841,0.50794,0.71429,0.50794,0.73016,0.50794,0.74603,0.50794,0.7619,0.50794,0.77778,0.50794,0.79365,0.50794,0.80952,0.50794};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.8254,0.50794,0.84127,0.50794,0.85714,0.50794,0.87302,0.50794,0.88889,0.50794,0.90476,0.50794,0.92063,0.50794,0.93651,0.50794,0.95238,0.50794,0.96825,0.50794,0.98413,0.50794,0.99609,0.50794,0.00391,0.52381,0.01587,0.52381,0.03175,0.52381,0.04762,0.52381,0.06349,0.52381,0.07937,0.52381,0.09524,0.52381,0.11111,0.52381,0.12698,0.52381,0.14286,0.52381,0.15873,0.52381,0.1746,0.52381,0.19048,0.52381,0.20635,0.52381,0.22222,0.52381,0.2381,0.52381,0.25397,0.52381,0.26984,0.52381,0.28571,0.52381,0.30159,0.52381,0.31746,0.52381,0.33333,0.52381,0.34921,0.52381,0.36508,0.52381,0.38095,0.52381,0.39683,0.52381,0.4127,0.52381,0.42857,0.52381,0.44444,0.52381,0.46032,0.52381,0.47619,0.52381,0.49206,0.52381,0.50794,0.52381,0.52381,0.52381,0.53968,0.52381,0.55556,0.52381,0.57143,0.52381,0.5873,0.52381,0.60317,0.52381,0.61905,0.52381,0.63492,0.52381,0.65079,0.52381,0.66667,0.52381,0.68254,0.52381,0.69841,0.52381,0.71429,0.52381,0.73016,0.52381,0.74603,0.52381,0.7619,0.52381,0.77778,0.52381,0.79365,0.52381,0.80952,0.52381,0.8254,0.52381,0.84127,0.52381,0.85714,0.52381,0.87302,0.52381,0.88889,0.52381,0.90476,0.52381,0.92063,0.52381,0.93651,0.52381,0.95238,0.52381,0.96825,0.52381,0.98413,0.52381,0.99609,0.52381,0.00391,0.53968,0.01587,0.53968,0.03175,0.53968,0.04762,0.53968,0.06349,0.53968,0.07937,0.53968,0.09524,0.53968,0.11111,0.53968,0.12698,0.53968,0.14286,0.53968,0.15873,0.53968,0.1746,0.53968,0.19048,0.53968,0.20635,0.53968,0.22222,0.53968,0.2381,0.53968,0.25397,0.53968,0.26984,0.53968,0.28571,0.53968,0.30159,0.53968,0.31746,0.53968,0.33333,0.53968,0.34921,0.53968,0.36508,0.53968};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.38095,0.53968,0.39683,0.53968,0.4127,0.53968,0.42857,0.53968,0.44444,0.53968,0.46032,0.53968,0.47619,0.53968,0.49206,0.53968,0.50794,0.53968,0.52381,0.53968,0.53968,0.53968,0.55556,0.53968,0.57143,0.53968,0.5873,0.53968,0.60317,0.53968,0.61905,0.53968,0.63492,0.53968,0.65079,0.53968,0.66667,0.53968,0.68254,0.53968,0.69841,0.53968,0.71429,0.53968,0.73016,0.53968,0.74603,0.53968,0.7619,0.53968,0.77778,0.53968,0.79365,0.53968,0.80952,0.53968,0.8254,0.53968,0.84127,0.53968,0.85714,0.53968,0.87302,0.53968,0.88889,0.53968,0.90476,0.53968,0.92063,0.53968,0.93651,0.53968,0.95238,0.53968,0.96825,0.53968,0.98413,0.53968,0.99609,0.53968,0.00391,0.55556,0.01587,0.55556,0.03175,0.55556,0.04762,0.55556,0.06349,0.55556,0.07937,0.55556,0.09524,0.55556,0.11111,0.55556,0.12698,0.55556,0.14286,0.55556,0.15873,0.55556,0.1746,0.55556,0.19048,0.55556,0.20635,0.55556,0.22222,0.55556,0.2381,0.55556,0.25397,0.55556,0.26984,0.55556,0.28571,0.55556,0.30159,0.55556,0.31746,0.55556,0.33333,0.55556,0.34921,0.55556,0.36508,0.55556,0.38095,0.55556,0.39683,0.55556,0.4127,0.55556,0.42857,0.55556,0.44444,0.55556,0.46032,0.55556,0.47619,0.55556,0.49206,0.55556,0.50794,0.55556,0.52381,0.55556,0.53968,0.55556,0.55556,0.55556,0.57143,0.55556,0.5873,0.55556,0.60317,0.55556,0.61905,0.55556,0.63492,0.55556,0.65079,0.55556,0.66667,0.55556,0.68254,0.55556,0.69841,0.55556,0.71429,0.55556,0.73016,0.55556,0.74603,0.55556,0.7619,0.55556,0.77778,0.55556,0.79365,0.55556,0.80952,0.55556,0.8254,0.55556,0.84127,0.55556,0.85714,0.55556,0.87302,0.55556,0.88889,0.55556,0.90476,0.55556,0.92063,0.55556,0.93651,0.55556};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.95238,0.55556,0.96825,0.55556,0.98413,0.55556,0.99609,0.55556,0.00391,0.57143,0.01587,0.57143,0.03175,0.57143,0.04762,0.57143,0.06349,0.57143,0.07937,0.57143,0.09524,0.57143,0.11111,0.57143,0.12698,0.57143,0.14286,0.57143,0.15873,0.57143,0.1746,0.57143,0.19048,0.57143,0.20635,0.57143,0.22222,0.57143,0.2381,0.57143,0.25397,0.57143,0.26984,0.57143,0.28571,0.57143,0.30159,0.57143,0.31746,0.57143,0.33333,0.57143,0.34921,0.57143,0.36508,0.57143,0.38095,0.57143,0.39683,0.57143,0.4127,0.57143,0.42857,0.57143,0.44444,0.57143,0.46032,0.57143,0.47619,0.57143,0.49206,0.57143,0.50794,0.57143,0.52381,0.57143,0.53968,0.57143,0.55556,0.57143,0.57143,0.57143,0.5873,0.57143,0.60317,0.57143,0.61905,0.57143,0.63492,0.57143,0.65079,0.57143,0.66667,0.57143,0.68254,0.57143,0.69841,0.57143,0.71429,0.57143,0.73016,0.57143,0.74603,0.57143,0.7619,0.57143,0.77778,0.57143,0.79365,0.57143,0.80952,0.57143,0.8254,0.57143,0.84127,0.57143,0.85714,0.57143,0.87302,0.57143,0.88889,0.57143,0.90476,0.57143,0.92063,0.57143,0.93651,0.57143,0.95238,0.57143,0.96825,0.57143,0.98413,0.57143,0.99609,0.57143,0.00391,0.5873,0.01587,0.5873,0.03175,0.5873,0.04762,0.5873,0.06349,0.5873,0.07937,0.5873,0.09524,0.5873,0.11111,0.5873,0.12698,0.5873,0.14286,0.5873,0.15873,0.5873,0.1746,0.5873,0.19048,0.5873,0.20635,0.5873,0.22222,0.5873,0.2381,0.5873,0.25397,0.5873,0.26984,0.5873,0.28571,0.5873,0.30159,0.5873,0.31746,0.5873,0.33333,0.5873,0.34921,0.5873,0.36508,0.5873,0.38095,0.5873,0.39683,0.5873,0.4127,0.5873,0.42857,0.5873,0.44444,0.5873,0.46032,0.5873,0.47619,0.5873,0.49206,0.5873};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.50794,0.5873,0.52381,0.5873,0.53968,0.5873,0.55556,0.5873,0.57143,0.5873,0.5873,0.5873,0.60317,0.5873,0.61905,0.5873,0.63492,0.5873,0.65079,0.5873,0.66667,0.5873,0.68254,0.5873,0.69841,0.5873,0.71429,0.5873,0.73016,0.5873,0.74603,0.5873,0.7619,0.5873,0.77778,0.5873,0.79365,0.5873,0.80952,0.5873,0.8254,0.5873,0.84127,0.5873,0.85714,0.5873,0.87302,0.5873,0.88889,0.5873,0.90476,0.5873,0.92063,0.5873,0.93651,0.5873,0.95238,0.5873,0.96825,0.5873,0.98413,0.5873,0.99609,0.5873,0.00391,0.60317,0.01587,0.60317,0.03175,0.60317,0.04762,0.60317,0.06349,0.60317,0.07937,0.60317,0.09524,0.60317,0.11111,0.60317,0.12698,0.60317,0.14286,0.60317,0.15873,0.60317,0.1746,0.60317,0.19048,0.60317,0.20635,0.60317,0.22222,0.60317,0.2381,0.60317,0.25397,0.60317,0.26984,0.60317,0.28571,0.60317,0.30159,0.60317,0.31746,0.60317,0.33333,0.60317,0.34921,0.60317,0.36508,0.60317,0.38095,0.60317,0.39683,0.60317,0.4127,0.60317,0.42857,0.60317,0.44444,0.60317,0.46032,0.60317,0.47619,0.60317,0.49206,0.60317,0.50794,0.60317,0.52381,0.60317,0.53968,0.60317,0.55556,0.60317,0.57143,0.60317,0.5873,0.60317,0.60317,0.60317,0.61905,0.60317,0.63492,0.60317,0.65079,0.60317,0.66667,0.60317,0.68254,0.60317,0.69841,0.60317,0.71429,0.60317,0.73016,0.60317,0.74603,0.60317,0.7619,0.60317,0.77778,0.60317,0.79365,0.60317,0.80952,0.60317,0.8254,0.60317,0.84127,0.60317,0.85714,0.60317,0.87302,0.60317,0.88889,0.60317,0.90476,0.60317,0.92063,0.60317,0.93651,0.60317,0.95238,0.60317,0.96825,0.60317,0.98413,0.60317,0.99609,0.60317,0.00391,0.61905,0.01587,0.61905,0.03175,0.61905,0.04762,0.61905};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.06349,0.61905,0.07937,0.61905,0.09524,0.61905,0.11111,0.61905,0.12698,0.61905,0.14286,0.61905,0.15873,0.61905,0.1746,0.61905,0.19048,0.61905,0.20635,0.61905,0.22222,0.61905,0.2381,0.61905,0.25397,0.61905,0.26984,0.61905,0.28571,0.61905,0.30159,0.61905,0.31746,0.61905,0.33333,0.61905,0.34921,0.61905,0.36508,0.61905,0.38095,0.61905,0.39683,0.61905,0.4127,0.61905,0.42857,0.61905,0.44444,0.61905,0.46032,0.61905,0.47619,0.61905,0.49206,0.61905,0.50794,0.61905,0.52381,0.61905,0.53968,0.61905,0.55556,0.61905,0.57143,0.61905,0.5873,0.61905,0.60317,0.61905,0.61905,0.61905,0.63492,0.61905,0.65079,0.61905,0.66667,0.61905,0.68254,0.61905,0.69841,0.61905,0.71429,0.61905,0.73016,0.61905,0.74603,0.61905,0.7619,0.61905,0.77778,0.61905,0.79365,0.61905,0.80952,0.61905,0.8254,0.61905,0.84127,0.61905,0.85714,0.61905,0.87302,0.61905,0.88889,0.61905,0.90476,0.61905,0.92063,0.61905,0.93651,0.61905,0.95238,0.61905,0.96825,0.61905,0.98413,0.61905,0.99609,0.61905,0.00391,0.63492,0.01587,0.63492,0.03175,0.63492,0.04762,0.63492,0.06349,0.63492,0.07937,0.63492,0.09524,0.63492,0.11111,0.63492,0.12698,0.63492,0.14286,0.63492,0.15873,0.63492,0.1746,0.63492,0.19048,0.63492,0.20635,0.63492,0.22222,0.63492,0.2381,0.63492,0.25397,0.63492,0.26984,0.63492,0.28571,0.63492,0.30159,0.63492,0.31746,0.63492,0.33333,0.63492,0.34921,0.63492,0.36508,0.63492,0.38095,0.63492,0.39683,0.63492,0.4127,0.63492,0.42857,0.63492,0.44444,0.63492,0.46032,0.63492,0.47619,0.63492,0.49206,0.63492,0.50794,0.63492,0.52381,0.63492,0.53968,0.63492,0.55556,0.63492,0.57143,0.63492,0.5873,0.63492,0.60317,0.63492,0.61905,0.63492};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.63492,0.63492,0.65079,0.63492,0.66667,0.63492,0.68254,0.63492,0.69841,0.63492,0.71429,0.63492,0.73016,0.63492,0.74603,0.63492,0.7619,0.63492,0.77778,0.63492,0.79365,0.63492,0.80952,0.63492,0.8254,0.63492,0.84127,0.63492,0.85714,0.63492,0.87302,0.63492,0.88889,0.63492,0.90476,0.63492,0.92063,0.63492,0.93651,0.63492,0.95238,0.63492,0.96825,0.63492,0.98413,0.63492,0.99609,0.63492,0.00391,0.65079,0.01587,0.65079,0.03175,0.65079,0.04762,0.65079,0.06349,0.65079,0.07937,0.65079,0.09524,0.65079,0.11111,0.65079,0.12698,0.65079,0.14286,0.65079,0.15873,0.65079,0.1746,0.65079,0.19048,0.65079,0.20635,0.65079,0.22222,0.65079,0.2381,0.65079,0.25397,0.65079,0.26984,0.65079,0.28571,0.65079,0.30159,0.65079,0.31746,0.65079,0.33333,0.65079,0.34921,0.65079,0.36508,0.65079,0.38095,0.65079,0.39683,0.65079,0.4127,0.65079,0.42857,0.65079,0.44444,0.65079,0.46032,0.65079,0.47619,0.65079,0.49206,0.65079,0.50794,0.65079,0.52381,0.65079,0.53968,0.65079,0.55556,0.65079,0.57143,0.65079,0.5873,0.65079,0.60317,0.65079,0.61905,0.65079,0.63492,0.65079,0.65079,0.65079,0.66667,0.65079,0.68254,0.65079,0.69841,0.65079,0.71429,0.65079,0.73016,0.65079,0.74603,0.65079,0.7619,0.65079,0.77778,0.65079,0.79365,0.65079,0.80952,0.65079,0.8254,0.65079,0.84127,0.65079,0.85714,0.65079,0.87302,0.65079,0.88889,0.65079,0.90476,0.65079,0.92063,0.65079,0.93651,0.65079,0.95238,0.65079,0.96825,0.65079,0.98413,0.65079,0.99609,0.65079,0.00391,0.66667,0.01587,0.66667,0.03175,0.66667,0.04762,0.66667,0.06349,0.66667,0.07937,0.66667,0.09524,0.66667,0.11111,0.66667,0.12698,0.66667,0.14286,0.66667,0.15873,0.66667,0.1746,0.66667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.19048,0.66667,0.20635,0.66667,0.22222,0.66667,0.2381,0.66667,0.25397,0.66667,0.26984,0.66667,0.28571,0.66667,0.30159,0.66667,0.31746,0.66667,0.33333,0.66667,0.34921,0.66667,0.36508,0.66667,0.38095,0.66667,0.39683,0.66667,0.4127,0.66667,0.42857,0.66667,0.44444,0.66667,0.46032,0.66667,0.47619,0.66667,0.49206,0.66667,0.50794,0.66667,0.52381,0.66667,0.53968,0.66667,0.55556,0.66667,0.57143,0.66667,0.5873,0.66667,0.60317,0.66667,0.61905,0.66667,0.63492,0.66667,0.65079,0.66667,0.66667,0.66667,0.68254,0.66667,0.69841,0.66667,0.71429,0.66667,0.73016,0.66667,0.74603,0.66667,0.7619,0.66667,0.77778,0.66667,0.79365,0.66667,0.80952,0.66667,0.8254,0.66667,0.84127,0.66667,0.85714,0.66667,0.87302,0.66667,0.88889,0.66667,0.90476,0.66667,0.92063,0.66667,0.93651,0.66667,0.95238,0.66667,0.96825,0.66667,0.98413,0.66667,0.99609,0.66667,0.00391,0.68254,0.01587,0.68254,0.03175,0.68254,0.04762,0.68254,0.06349,0.68254,0.07937,0.68254,0.09524,0.68254,0.11111,0.68254,0.12698,0.68254,0.14286,0.68254,0.15873,0.68254,0.1746,0.68254,0.19048,0.68254,0.20635,0.68254,0.22222,0.68254,0.2381,0.68254,0.25397,0.68254,0.26984,0.68254,0.28571,0.68254,0.30159,0.68254,0.31746,0.68254,0.33333,0.68254,0.34921,0.68254,0.36508,0.68254,0.38095,0.68254,0.39683,0.68254,0.4127,0.68254,0.42857,0.68254,0.44444,0.68254,0.46032,0.68254,0.47619,0.68254,0.49206,0.68254,0.50794,0.68254,0.52381,0.68254,0.53968,0.68254,0.55556,0.68254,0.57143,0.68254,0.5873,0.68254,0.60317,0.68254,0.61905,0.68254,0.63492,0.68254,0.65079,0.68254,0.66667,0.68254,0.68254,0.68254,0.69841,0.68254,0.71429,0.68254,0.73016,0.68254,0.74603,0.68254};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.7619,0.68254,0.77778,0.68254,0.79365,0.68254,0.80952,0.68254,0.8254,0.68254,0.84127,0.68254,0.85714,0.68254,0.87302,0.68254,0.88889,0.68254,0.90476,0.68254,0.92063,0.68254,0.93651,0.68254,0.95238,0.68254,0.96825,0.68254,0.98413,0.68254,0.99609,0.68254,0.00391,0.69841,0.01587,0.69841,0.03175,0.69841,0.04762,0.69841,0.06349,0.69841,0.07937,0.69841,0.09524,0.69841,0.11111,0.69841,0.12698,0.69841,0.14286,0.69841,0.15873,0.69841,0.1746,0.69841,0.19048,0.69841,0.20635,0.69841,0.22222,0.69841,0.2381,0.69841,0.25397,0.69841,0.26984,0.69841,0.28571,0.69841,0.30159,0.69841,0.31746,0.69841,0.33333,0.69841,0.34921,0.69841,0.36508,0.69841,0.38095,0.69841,0.39683,0.69841,0.4127,0.69841,0.42857,0.69841,0.44444,0.69841,0.46032,0.69841,0.47619,0.69841,0.49206,0.69841,0.50794,0.69841,0.52381,0.69841,0.53968,0.69841,0.55556,0.69841,0.57143,0.69841,0.5873,0.69841,0.60317,0.69841,0.61905,0.69841,0.63492,0.69841,0.65079,0.69841,0.66667,0.69841,0.68254,0.69841,0.69841,0.69841,0.71429,0.69841,0.73016,0.69841,0.74603,0.69841,0.7619,0.69841,0.77778,0.69841,0.79365,0.69841,0.80952,0.69841,0.8254,0.69841,0.84127,0.69841,0.85714,0.69841,0.87302,0.69841,0.88889,0.69841,0.90476,0.69841,0.92063,0.69841,0.93651,0.69841,0.95238,0.69841,0.96825,0.69841,0.98413,0.69841,0.99609,0.69841,0.00391,0.71429,0.01587,0.71429,0.03175,0.71429,0.04762,0.71429,0.06349,0.71429,0.07937,0.71429,0.09524,0.71429,0.11111,0.71429,0.12698,0.71429,0.14286,0.71429,0.15873,0.71429,0.1746,0.71429,0.19048,0.71429,0.20635,0.71429,0.22222,0.71429,0.2381,0.71429,0.25397,0.71429,0.26984,0.71429,0.28571,0.71429,0.30159,0.71429};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.31746,0.71429,0.33333,0.71429,0.34921,0.71429,0.36508,0.71429,0.38095,0.71429,0.39683,0.71429,0.4127,0.71429,0.42857,0.71429,0.44444,0.71429,0.46032,0.71429,0.47619,0.71429,0.49206,0.71429,0.50794,0.71429,0.52381,0.71429,0.53968,0.71429,0.55556,0.71429,0.57143,0.71429,0.5873,0.71429,0.60317,0.71429,0.61905,0.71429,0.63492,0.71429,0.65079,0.71429,0.66667,0.71429,0.68254,0.71429,0.69841,0.71429,0.71429,0.71429,0.73016,0.71429,0.74603,0.71429,0.7619,0.71429,0.77778,0.71429,0.79365,0.71429,0.80952,0.71429,0.8254,0.71429,0.84127,0.71429,0.85714,0.71429,0.87302,0.71429,0.88889,0.71429,0.90476,0.71429,0.92063,0.71429,0.93651,0.71429,0.95238,0.71429,0.96825,0.71429,0.98413,0.71429,0.99609,0.71429,0.00391,0.73016,0.01587,0.73016,0.03175,0.73016,0.04762,0.73016,0.06349,0.73016,0.07937,0.73016,0.09524,0.73016,0.11111,0.73016,0.12698,0.73016,0.14286,0.73016,0.15873,0.73016,0.1746,0.73016,0.19048,0.73016,0.20635,0.73016,0.22222,0.73016,0.2381,0.73016,0.25397,0.73016,0.26984,0.73016,0.28571,0.73016,0.30159,0.73016,0.31746,0.73016,0.33333,0.73016,0.34921,0.73016,0.36508,0.73016,0.38095,0.73016,0.39683,0.73016,0.4127,0.73016,0.42857,0.73016,0.44444,0.73016,0.46032,0.73016,0.47619,0.73016,0.49206,0.73016,0.50794,0.73016,0.52381,0.73016,0.53968,0.73016,0.55556,0.73016,0.57143,0.73016,0.5873,0.73016,0.60317,0.73016,0.61905,0.73016,0.63492,0.73016,0.65079,0.73016,0.66667,0.73016,0.68254,0.73016,0.69841,0.73016,0.71429,0.73016,0.73016,0.73016,0.74603,0.73016,0.7619,0.73016,0.77778,0.73016,0.79365,0.73016,0.80952,0.73016,0.8254,0.73016,0.84127,0.73016,0.85714,0.73016,0.87302,0.73016};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.88889,0.73016,0.90476,0.73016,0.92063,0.73016,0.93651,0.73016,0.95238,0.73016,0.96825,0.73016,0.98413,0.73016,0.99609,0.73016,0.00391,0.74603,0.01587,0.74603,0.03175,0.74603,0.04762,0.74603,0.06349,0.74603,0.07937,0.74603,0.09524,0.74603,0.11111,0.74603,0.12698,0.74603,0.14286,0.74603,0.15873,0.74603,0.1746,0.74603,0.19048,0.74603,0.20635,0.74603,0.22222,0.74603,0.2381,0.74603,0.25397,0.74603,0.26984,0.74603,0.28571,0.74603,0.30159,0.74603,0.31746,0.74603,0.33333,0.74603,0.34921,0.74603,0.36508,0.74603,0.38095,0.74603,0.39683,0.74603,0.4127,0.74603,0.42857,0.74603,0.44444,0.74603,0.46032,0.74603,0.47619,0.74603,0.49206,0.74603,0.50794,0.74603,0.52381,0.74603,0.53968,0.74603,0.55556,0.74603,0.57143,0.74603,0.5873,0.74603,0.60317,0.74603,0.61905,0.74603,0.63492,0.74603,0.65079,0.74603,0.66667,0.74603,0.68254,0.74603,0.69841,0.74603,0.71429,0.74603,0.73016,0.74603,0.74603,0.74603,0.7619,0.74603,0.77778,0.74603,0.79365,0.74603,0.80952,0.74603,0.8254,0.74603,0.84127,0.74603,0.85714,0.74603,0.87302,0.74603,0.88889,0.74603,0.90476,0.74603,0.92063,0.74603,0.93651,0.74603,0.95238,0.74603,0.96825,0.74603,0.98413,0.74603,0.99609,0.74603,0.00391,0.7619,0.01587,0.7619,0.03175,0.7619,0.04762,0.7619,0.06349,0.7619,0.07937,0.7619,0.09524,0.7619,0.11111,0.7619,0.12698,0.7619,0.14286,0.7619,0.15873,0.7619,0.1746,0.7619,0.19048,0.7619,0.20635,0.7619,0.22222,0.7619,0.2381,0.7619,0.25397,0.7619,0.26984,0.7619,0.28571,0.7619,0.30159,0.7619,0.31746,0.7619,0.33333,0.7619,0.34921,0.7619,0.36508,0.7619,0.38095,0.7619,0.39683,0.7619,0.4127,0.7619,0.42857,0.7619};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.44444,0.7619,0.46032,0.7619,0.47619,0.7619,0.49206,0.7619,0.50794,0.7619,0.52381,0.7619,0.53968,0.7619,0.55556,0.7619,0.57143,0.7619,0.5873,0.7619,0.60317,0.7619,0.61905,0.7619,0.63492,0.7619,0.65079,0.7619,0.66667,0.7619,0.68254,0.7619,0.69841,0.7619,0.71429,0.7619,0.73016,0.7619,0.74603,0.7619,0.7619,0.7619,0.77778,0.7619,0.79365,0.7619,0.80952,0.7619,0.8254,0.7619,0.84127,0.7619,0.85714,0.7619,0.87302,0.7619,0.88889,0.7619,0.90476,0.7619,0.92063,0.7619,0.93651,0.7619,0.95238,0.7619,0.96825,0.7619,0.98413,0.7619,0.99609,0.7619,0.00391,0.77778,0.01587,0.77778,0.03175,0.77778,0.04762,0.77778,0.06349,0.77778,0.07937,0.77778,0.09524,0.77778,0.11111,0.77778,0.12698,0.77778,0.14286,0.77778,0.15873,0.77778,0.1746,0.77778,0.19048,0.77778,0.20635,0.77778,0.22222,0.77778,0.2381,0.77778,0.25397,0.77778,0.26984,0.77778,0.28571,0.77778,0.30159,0.77778,0.31746,0.77778,0.33333,0.77778,0.34921,0.77778,0.36508,0.77778,0.38095,0.77778,0.39683,0.77778,0.4127,0.77778,0.42857,0.77778,0.44444,0.77778,0.46032,0.77778,0.47619,0.77778,0.49206,0.77778,0.50794,0.77778,0.52381,0.77778,0.53968,0.77778,0.55556,0.77778,0.57143,0.77778,0.5873,0.77778,0.60317,0.77778,0.61905,0.77778,0.63492,0.77778,0.65079,0.77778,0.66667,0.77778,0.68254,0.77778,0.69841,0.77778,0.71429,0.77778,0.73016,0.77778,0.74603,0.77778,0.7619,0.77778,0.77778,0.77778,0.79365,0.77778,0.80952,0.77778,0.8254,0.77778,0.84127,0.77778,0.85714,0.77778,0.87302,0.77778,0.88889,0.77778,0.90476,0.77778,0.92063,0.77778,0.93651,0.77778,0.95238,0.77778,0.96825,0.77778,0.98413,0.77778,0.99609,0.77778};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.00391,0.79365,0.01587,0.79365,0.03175,0.79365,0.04762,0.79365,0.06349,0.79365,0.07937,0.79365,0.09524,0.79365,0.11111,0.79365,0.12698,0.79365,0.14286,0.79365,0.15873,0.79365,0.1746,0.79365,0.19048,0.79365,0.20635,0.79365,0.22222,0.79365,0.2381,0.79365,0.25397,0.79365,0.26984,0.79365,0.28571,0.79365,0.30159,0.79365,0.31746,0.79365,0.33333,0.79365,0.34921,0.79365,0.36508,0.79365,0.38095,0.79365,0.39683,0.79365,0.4127,0.79365,0.42857,0.79365,0.44444,0.79365,0.46032,0.79365,0.47619,0.79365,0.49206,0.79365,0.50794,0.79365,0.52381,0.79365,0.53968,0.79365,0.55556,0.79365,0.57143,0.79365,0.5873,0.79365,0.60317,0.79365,0.61905,0.79365,0.63492,0.79365,0.65079,0.79365,0.66667,0.79365,0.68254,0.79365,0.69841,0.79365,0.71429,0.79365,0.73016,0.79365,0.74603,0.79365,0.7619,0.79365,0.77778,0.79365,0.79365,0.79365,0.80952,0.79365,0.8254,0.79365,0.84127,0.79365,0.85714,0.79365,0.87302,0.79365,0.88889,0.79365,0.90476,0.79365,0.92063,0.79365,0.93651,0.79365,0.95238,0.79365,0.96825,0.79365,0.98413,0.79365,0.99609,0.79365,0.00391,0.80952,0.01587,0.80952,0.03175,0.80952,0.04762,0.80952,0.06349,0.80952,0.07937,0.80952,0.09524,0.80952,0.11111,0.80952,0.12698,0.80952,0.14286,0.80952,0.15873,0.80952,0.1746,0.80952,0.19048,0.80952,0.20635,0.80952,0.22222,0.80952,0.2381,0.80952,0.25397,0.80952,0.26984,0.80952,0.28571,0.80952,0.30159,0.80952,0.31746,0.80952,0.33333,0.80952,0.34921,0.80952,0.36508,0.80952,0.38095,0.80952,0.39683,0.80952,0.4127,0.80952,0.42857,0.80952,0.44444,0.80952,0.46032,0.80952,0.47619,0.80952,0.49206,0.80952,0.50794,0.80952,0.52381,0.80952,0.53968,0.80952,0.55556,0.80952};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.57143,0.80952,0.5873,0.80952,0.60317,0.80952,0.61905,0.80952,0.63492,0.80952,0.65079,0.80952,0.66667,0.80952,0.68254,0.80952,0.69841,0.80952,0.71429,0.80952,0.73016,0.80952,0.74603,0.80952,0.7619,0.80952,0.77778,0.80952,0.79365,0.80952,0.80952,0.80952,0.8254,0.80952,0.84127,0.80952,0.85714,0.80952,0.87302,0.80952,0.88889,0.80952,0.90476,0.80952,0.92063,0.80952,0.93651,0.80952,0.95238,0.80952,0.96825,0.80952,0.98413,0.80952,0.99609,0.80952,0.00391,0.8254,0.01587,0.8254,0.03175,0.8254,0.04762,0.8254,0.06349,0.8254,0.07937,0.8254,0.09524,0.8254,0.11111,0.8254,0.12698,0.8254,0.14286,0.8254,0.15873,0.8254,0.1746,0.8254,0.19048,0.8254,0.20635,0.8254,0.22222,0.8254,0.2381,0.8254,0.25397,0.8254,0.26984,0.8254,0.28571,0.8254,0.30159,0.8254,0.31746,0.8254,0.33333,0.8254,0.34921,0.8254,0.36508,0.8254,0.38095,0.8254,0.39683,0.8254,0.4127,0.8254,0.42857,0.8254,0.44444,0.8254,0.46032,0.8254,0.47619,0.8254,0.49206,0.8254,0.50794,0.8254,0.52381,0.8254,0.53968,0.8254,0.55556,0.8254,0.57143,0.8254,0.5873,0.8254,0.60317,0.8254,0.61905,0.8254,0.63492,0.8254,0.65079,0.8254,0.66667,0.8254,0.68254,0.8254,0.69841,0.8254,0.71429,0.8254,0.73016,0.8254,0.74603,0.8254,0.7619,0.8254,0.77778,0.8254,0.79365,0.8254,0.80952,0.8254,0.8254,0.8254,0.84127,0.8254,0.85714,0.8254,0.87302,0.8254,0.88889,0.8254,0.90476,0.8254,0.92063,0.8254,0.93651,0.8254,0.95238,0.8254,0.96825,0.8254,0.98413,0.8254,0.99609,0.8254,0.00391,0.84127,0.01587,0.84127,0.03175,0.84127,0.04762,0.84127,0.06349,0.84127,0.07937,0.84127,0.09524,0.84127,0.11111,0.84127};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.12698,0.84127,0.14286,0.84127,0.15873,0.84127,0.1746,0.84127,0.19048,0.84127,0.20635,0.84127,0.22222,0.84127,0.2381,0.84127,0.25397,0.84127,0.26984,0.84127,0.28571,0.84127,0.30159,0.84127,0.31746,0.84127,0.33333,0.84127,0.34921,0.84127,0.36508,0.84127,0.38095,0.84127,0.39683,0.84127,0.4127,0.84127,0.42857,0.84127,0.44444,0.84127,0.46032,0.84127,0.47619,0.84127,0.49206,0.84127,0.50794,0.84127,0.52381,0.84127,0.53968,0.84127,0.55556,0.84127,0.57143,0.84127,0.5873,0.84127,0.60317,0.84127,0.61905,0.84127,0.63492,0.84127,0.65079,0.84127,0.66667,0.84127,0.68254,0.84127,0.69841,0.84127,0.71429,0.84127,0.73016,0.84127,0.74603,0.84127,0.7619,0.84127,0.77778,0.84127,0.79365,0.84127,0.80952,0.84127,0.8254,0.84127,0.84127,0.84127,0.85714,0.84127,0.87302,0.84127,0.88889,0.84127,0.90476,0.84127,0.92063,0.84127,0.93651,0.84127,0.95238,0.84127,0.96825,0.84127,0.98413,0.84127,0.99609,0.84127,0.00391,0.85714,0.01587,0.85714,0.03175,0.85714,0.04762,0.85714,0.06349,0.85714,0.07937,0.85714,0.09524,0.85714,0.11111,0.85714,0.12698,0.85714,0.14286,0.85714,0.15873,0.85714,0.1746,0.85714,0.19048,0.85714,0.20635,0.85714,0.22222,0.85714,0.2381,0.85714,0.25397,0.85714,0.26984,0.85714,0.28571,0.85714,0.30159,0.85714,0.31746,0.85714,0.33333,0.85714,0.34921,0.85714,0.36508,0.85714,0.38095,0.85714,0.39683,0.85714,0.4127,0.85714,0.42857,0.85714,0.44444,0.85714,0.46032,0.85714,0.47619,0.85714,0.49206,0.85714,0.50794,0.85714,0.52381,0.85714,0.53968,0.85714,0.55556,0.85714,0.57143,0.85714,0.5873,0.85714,0.60317,0.85714,0.61905,0.85714,0.63492,0.85714,0.65079,0.85714,0.66667,0.85714,0.68254,0.85714};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_36()
		{
			double[] value = {0.69841,0.85714,0.71429,0.85714,0.73016,0.85714,0.74603,0.85714,0.7619,0.85714,0.77778,0.85714,0.79365,0.85714,0.80952,0.85714,0.8254,0.85714,0.84127,0.85714,0.85714,0.85714,0.87302,0.85714,0.88889,0.85714,0.90476,0.85714,0.92063,0.85714,0.93651,0.85714,0.95238,0.85714,0.96825,0.85714,0.98413,0.85714,0.99609,0.85714,0.00391,0.87302,0.01587,0.87302,0.03175,0.87302,0.04762,0.87302,0.06349,0.87302,0.07937,0.87302,0.09524,0.87302,0.11111,0.87302,0.12698,0.87302,0.14286,0.87302,0.15873,0.87302,0.1746,0.87302,0.19048,0.87302,0.20635,0.87302,0.22222,0.87302,0.2381,0.87302,0.25397,0.87302,0.26984,0.87302,0.28571,0.87302,0.30159,0.87302,0.31746,0.87302,0.33333,0.87302,0.34921,0.87302,0.36508,0.87302,0.38095,0.87302,0.39683,0.87302,0.4127,0.87302,0.42857,0.87302,0.44444,0.87302,0.46032,0.87302,0.47619,0.87302,0.49206,0.87302,0.50794,0.87302,0.52381,0.87302,0.53968,0.87302,0.55556,0.87302,0.57143,0.87302,0.5873,0.87302,0.60317,0.87302,0.61905,0.87302,0.63492,0.87302,0.65079,0.87302,0.66667,0.87302,0.68254,0.87302,0.69841,0.87302,0.71429,0.87302,0.73016,0.87302,0.74603,0.87302,0.7619,0.87302,0.77778,0.87302,0.79365,0.87302,0.80952,0.87302,0.8254,0.87302,0.84127,0.87302,0.85714,0.87302,0.87302,0.87302,0.88889,0.87302,0.90476,0.87302,0.92063,0.87302,0.93651,0.87302,0.95238,0.87302,0.96825,0.87302,0.98413,0.87302,0.99609,0.87302,0.00391,0.88889,0.01587,0.88889,0.03175,0.88889,0.04762,0.88889,0.06349,0.88889,0.07937,0.88889,0.09524,0.88889,0.11111,0.88889,0.12698,0.88889,0.14286,0.88889,0.15873,0.88889,0.1746,0.88889,0.19048,0.88889,0.20635,0.88889,0.22222,0.88889,0.2381,0.88889};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_37()
		{
			double[] value = {0.25397,0.88889,0.26984,0.88889,0.28571,0.88889,0.30159,0.88889,0.31746,0.88889,0.33333,0.88889,0.34921,0.88889,0.36508,0.88889,0.38095,0.88889,0.39683,0.88889,0.4127,0.88889,0.42857,0.88889,0.44444,0.88889,0.46032,0.88889,0.47619,0.88889,0.49206,0.88889,0.50794,0.88889,0.52381,0.88889,0.53968,0.88889,0.55556,0.88889,0.57143,0.88889,0.5873,0.88889,0.60317,0.88889,0.61905,0.88889,0.63492,0.88889,0.65079,0.88889,0.66667,0.88889,0.68254,0.88889,0.69841,0.88889,0.71429,0.88889,0.73016,0.88889,0.74603,0.88889,0.7619,0.88889,0.77778,0.88889,0.79365,0.88889,0.80952,0.88889,0.8254,0.88889,0.84127,0.88889,0.85714,0.88889,0.87302,0.88889,0.88889,0.88889,0.90476,0.88889,0.92063,0.88889,0.93651,0.88889,0.95238,0.88889,0.96825,0.88889,0.98413,0.88889,0.99609,0.88889,0.00391,0.90476,0.01587,0.90476,0.03175,0.90476,0.04762,0.90476,0.06349,0.90476,0.07937,0.90476,0.09524,0.90476,0.11111,0.90476,0.12698,0.90476,0.14286,0.90476,0.15873,0.90476,0.1746,0.90476,0.19048,0.90476,0.20635,0.90476,0.22222,0.90476,0.2381,0.90476,0.25397,0.90476,0.26984,0.90476,0.28571,0.90476,0.30159,0.90476,0.31746,0.90476,0.33333,0.90476,0.34921,0.90476,0.36508,0.90476,0.38095,0.90476,0.39683,0.90476,0.4127,0.90476,0.42857,0.90476,0.44444,0.90476,0.46032,0.90476,0.47619,0.90476,0.49206,0.90476,0.50794,0.90476,0.52381,0.90476,0.53968,0.90476,0.55556,0.90476,0.57143,0.90476,0.5873,0.90476,0.60317,0.90476,0.61905,0.90476,0.63492,0.90476,0.65079,0.90476,0.66667,0.90476,0.68254,0.90476,0.69841,0.90476,0.71429,0.90476,0.73016,0.90476,0.74603,0.90476,0.7619,0.90476,0.77778,0.90476,0.79365,0.90476,0.80952,0.90476};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_38()
		{
			double[] value = {0.8254,0.90476,0.84127,0.90476,0.85714,0.90476,0.87302,0.90476,0.88889,0.90476,0.90476,0.90476,0.92063,0.90476,0.93651,0.90476,0.95238,0.90476,0.96825,0.90476,0.98413,0.90476,0.99609,0.90476,0.00391,0.92063,0.01587,0.92063,0.03175,0.92063,0.04762,0.92063,0.06349,0.92063,0.07937,0.92063,0.09524,0.92063,0.11111,0.92063,0.12698,0.92063,0.14286,0.92063,0.15873,0.92063,0.1746,0.92063,0.19048,0.92063,0.20635,0.92063,0.22222,0.92063,0.2381,0.92063,0.25397,0.92063,0.26984,0.92063,0.28571,0.92063,0.30159,0.92063,0.31746,0.92063,0.33333,0.92063,0.34921,0.92063,0.36508,0.92063,0.38095,0.92063,0.39683,0.92063,0.4127,0.92063,0.42857,0.92063,0.44444,0.92063,0.46032,0.92063,0.47619,0.92063,0.49206,0.92063,0.50794,0.92063,0.52381,0.92063,0.53968,0.92063,0.55556,0.92063,0.57143,0.92063,0.5873,0.92063,0.60317,0.92063,0.61905,0.92063,0.63492,0.92063,0.65079,0.92063,0.66667,0.92063,0.68254,0.92063,0.69841,0.92063,0.71429,0.92063,0.73016,0.92063,0.74603,0.92063,0.7619,0.92063,0.77778,0.92063,0.79365,0.92063,0.80952,0.92063,0.8254,0.92063,0.84127,0.92063,0.85714,0.92063,0.87302,0.92063,0.88889,0.92063,0.90476,0.92063,0.92063,0.92063,0.93651,0.92063,0.95238,0.92063,0.96825,0.92063,0.98413,0.92063,0.99609,0.92063,0.00391,0.93651,0.01587,0.93651,0.03175,0.93651,0.04762,0.93651,0.06349,0.93651,0.07937,0.93651,0.09524,0.93651,0.11111,0.93651,0.12698,0.93651,0.14286,0.93651,0.15873,0.93651,0.1746,0.93651,0.19048,0.93651,0.20635,0.93651,0.22222,0.93651,0.2381,0.93651,0.25397,0.93651,0.26984,0.93651,0.28571,0.93651,0.30159,0.93651,0.31746,0.93651,0.33333,0.93651,0.34921,0.93651,0.36508,0.93651};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_39()
		{
			double[] value = {0.38095,0.93651,0.39683,0.93651,0.4127,0.93651,0.42857,0.93651,0.44444,0.93651,0.46032,0.93651,0.47619,0.93651,0.49206,0.93651,0.50794,0.93651,0.52381,0.93651,0.53968,0.93651,0.55556,0.93651,0.57143,0.93651,0.5873,0.93651,0.60317,0.93651,0.61905,0.93651,0.63492,0.93651,0.65079,0.93651,0.66667,0.93651,0.68254,0.93651,0.69841,0.93651,0.71429,0.93651,0.73016,0.93651,0.74603,0.93651,0.7619,0.93651,0.77778,0.93651,0.79365,0.93651,0.80952,0.93651,0.8254,0.93651,0.84127,0.93651,0.85714,0.93651,0.87302,0.93651,0.88889,0.93651,0.90476,0.93651,0.92063,0.93651,0.93651,0.93651,0.95238,0.93651,0.96825,0.93651,0.98413,0.93651,0.99609,0.93651,0.00391,0.95238,0.01587,0.95238,0.03175,0.95238,0.04762,0.95238,0.06349,0.95238,0.07937,0.95238,0.09524,0.95238,0.11111,0.95238,0.12698,0.95238,0.14286,0.95238,0.15873,0.95238,0.1746,0.95238,0.19048,0.95238,0.20635,0.95238,0.22222,0.95238,0.2381,0.95238,0.25397,0.95238,0.26984,0.95238,0.28571,0.95238,0.30159,0.95238,0.31746,0.95238,0.33333,0.95238,0.34921,0.95238,0.36508,0.95238,0.38095,0.95238,0.39683,0.95238,0.4127,0.95238,0.42857,0.95238,0.44444,0.95238,0.46032,0.95238,0.47619,0.95238,0.49206,0.95238,0.50794,0.95238,0.52381,0.95238,0.53968,0.95238,0.55556,0.95238,0.57143,0.95238,0.5873,0.95238,0.60317,0.95238,0.61905,0.95238,0.63492,0.95238,0.65079,0.95238,0.66667,0.95238,0.68254,0.95238,0.69841,0.95238,0.71429,0.95238,0.73016,0.95238,0.74603,0.95238,0.7619,0.95238,0.77778,0.95238,0.79365,0.95238,0.80952,0.95238,0.8254,0.95238,0.84127,0.95238,0.85714,0.95238,0.87302,0.95238,0.88889,0.95238,0.90476,0.95238,0.92063,0.95238,0.93651,0.95238};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_40()
		{
			double[] value = {0.95238,0.95238,0.96825,0.95238,0.98413,0.95238,0.99609,0.95238,0.00391,0.96825,0.01587,0.96825,0.03175,0.96825,0.04762,0.96825,0.06349,0.96825,0.07937,0.96825,0.09524,0.96825,0.11111,0.96825,0.12698,0.96825,0.14286,0.96825,0.15873,0.96825,0.1746,0.96825,0.19048,0.96825,0.20635,0.96825,0.22222,0.96825,0.2381,0.96825,0.25397,0.96825,0.26984,0.96825,0.28571,0.96825,0.30159,0.96825,0.31746,0.96825,0.33333,0.96825,0.34921,0.96825,0.36508,0.96825,0.38095,0.96825,0.39683,0.96825,0.4127,0.96825,0.42857,0.96825,0.44444,0.96825,0.46032,0.96825,0.47619,0.96825,0.49206,0.96825,0.50794,0.96825,0.52381,0.96825,0.53968,0.96825,0.55556,0.96825,0.57143,0.96825,0.5873,0.96825,0.60317,0.96825,0.61905,0.96825,0.63492,0.96825,0.65079,0.96825,0.66667,0.96825,0.68254,0.96825,0.69841,0.96825,0.71429,0.96825,0.73016,0.96825,0.74603,0.96825,0.7619,0.96825,0.77778,0.96825,0.79365,0.96825,0.80952,0.96825,0.8254,0.96825,0.84127,0.96825,0.85714,0.96825,0.87302,0.96825,0.88889,0.96825,0.90476,0.96825,0.92063,0.96825,0.93651,0.96825,0.95238,0.96825,0.96825,0.96825,0.98413,0.96825,0.99609,0.96825,0.00391,0.98413,0.01587,0.98413,0.03175,0.98413,0.04762,0.98413,0.06349,0.98413,0.07937,0.98413,0.09524,0.98413,0.11111,0.98413,0.12698,0.98413,0.14286,0.98413,0.15873,0.98413,0.1746,0.98413,0.19048,0.98413,0.20635,0.98413,0.22222,0.98413,0.2381,0.98413,0.25397,0.98413,0.26984,0.98413,0.28571,0.98413,0.30159,0.98413,0.31746,0.98413,0.33333,0.98413,0.34921,0.98413,0.36508,0.98413,0.38095,0.98413,0.39683,0.98413,0.4127,0.98413,0.42857,0.98413,0.44444,0.98413,0.46032,0.98413,0.47619,0.98413,0.49206,0.98413};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_41()
		{
			double[] value = {0.50794,0.98413,0.52381,0.98413,0.53968,0.98413,0.55556,0.98413,0.57143,0.98413,0.5873,0.98413,0.60317,0.98413,0.61905,0.98413,0.63492,0.98413,0.65079,0.98413,0.66667,0.98413,0.68254,0.98413,0.69841,0.98413,0.71429,0.98413,0.73016,0.98413,0.74603,0.98413,0.7619,0.98413,0.77778,0.98413,0.79365,0.98413,0.80952,0.98413,0.8254,0.98413,0.84127,0.98413,0.85714,0.98413,0.87302,0.98413,0.88889,0.98413,0.90476,0.98413,0.92063,0.98413,0.93651,0.98413,0.95238,0.98413,0.96825,0.98413,0.98413,0.98413,0.99609,0.98413,0.00391,0.99609,0.01587,0.99609,0.03175,0.99609,0.04762,0.99609,0.06349,0.99609,0.07937,0.99609,0.09524,0.99609,0.11111,0.99609,0.12698,0.99609,0.14286,0.99609,0.15873,0.99609,0.1746,0.99609,0.19048,0.99609,0.20635,0.99609,0.22222,0.99609,0.2381,0.99609,0.25397,0.99609,0.26984,0.99609,0.28571,0.99609,0.30159,0.99609,0.31746,0.99609,0.33333,0.99609,0.34921,0.99609,0.36508,0.99609,0.38095,0.99609,0.39683,0.99609,0.4127,0.99609,0.42857,0.99609,0.44444,0.99609,0.46032,0.99609,0.47619,0.99609,0.49206,0.99609,0.50794,0.99609,0.52381,0.99609,0.53968,0.99609,0.55556,0.99609,0.57143,0.99609,0.5873,0.99609,0.60317,0.99609,0.61905,0.99609,0.63492,0.99609,0.65079,0.99609,0.66667,0.99609,0.68254,0.99609,0.69841,0.99609,0.71429,0.99609,0.73016,0.99609,0.74603,0.99609,0.7619,0.99609,0.77778,0.99609,0.79365,0.99609,0.80952,0.99609,0.8254,0.99609,0.84127,0.99609,0.85714,0.99609,0.87302,0.99609,0.88889,0.99609,0.90476,0.99609,0.92063,0.99609,0.93651,0.99609,0.95238,0.99609,0.96825,0.99609,0.98413,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 4096 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_36()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_37()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_38()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_39()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_40()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_41()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 8192 total numbers made up of 4096 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_36()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_37()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_38()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_39()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_40()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_41()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD001 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD001().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD001\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD001 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD001_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD001_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD001_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD001_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
