package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Mars. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/MarsLOD000Index.html" target="_blank">MarsLOD000</a>,  source <a href="../../../Geospatial/MarsLOD000.java">MarsLOD000.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/MarsLOD000.x3d">MarsLOD000.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Mars. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD000.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD000.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class MarsLOD000
{
	/** Default constructor to create this object. */
	public MarsLOD000 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MarsLOD000.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Mars."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD000.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MarsLOD000.x3d"))
    .addChild(new GeoLOD().setCenter(-45.000000,-135.000000,335450.000000).setRange(3.6E7).setChild1Url(new String[] {"MarsLOD001.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD001.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/Mars000.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars000.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(-90.000000,-180.000000,0.000000).setSolid(false).setXDimension(32).setXSpacing(2.903226).setYScale(50.0).setZDimension(32).setZSpacing(2.903226).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2640.948,2826.0618,2771.497,2695.6863,2690.0417,2684.7703,2716.6785,2719.1838,2813.0198,2850.3928,2861.694,2860.6294,2866.238,2863.0415,2834.6206,2746.66,2715.9656,2712.712,2723.835,2694.38,2668.8137,2558.8086,2617.4346,2668.3313,2725.7407,2757.532,2753.9,2712.5422,2693.891,2708.7495,2736.9888,2762.7498,2988.075,2973.8767,2963.2952,2953.735,2940.6099,2930.446,2915.7668,2895.6448,2861.3435,2845.806,2842.6123,2828.4111,2806.923,2769.831,2732.116,2687.3909,2642.7573,2616.0718,2589.3235,2545.9343,2460.8374,2370.865,2356.402,2330.1252,2334.4167,2350.7493,2397.3918,2403.3083,2404.8403,2413.113,2397.551,2369.2488,2774.4736,2771.8208,2773.125,2763.331,2728.3977,2676.083,2619.1682,2545.6538,2434.66,2465.399,2519.3403,2476.8955,2414.9697,2358.3772,2310.6653,2265.7778,2235.6558,2187.2483,2112.933,2107.3093,2044.9102,1979.7147,1922.4635,1918.4879,1956.219,2002.897,2028.1754,1911.0491,1996.9259,2177.034,2181.7178,2223.4182,2369.3376,2426.298,2382.5422,2336.0132};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2268.6362,2240.3137,2197.0593,2150.8088,2107.092,2020.0073,1971.5,1910.4701,1931.5255,2044.831,2018.3291,1933.924,1855.5798,1820.7166,1411.4031,1541.274,1601.4065,1618.0962,1624.8151,1612.2323,1576.3306,1589.362,1595.3209,1565.9418,1558.4927,1682.7695,1800.1438,1874.1436,1920.4645,1969.089,2065.932,1984.0728,1769.0957,1762.453,1407.7452,1122.4059,1593.6489,1618.6521,1598.0807,1607.7579,1624.4175,1754.8127,1715.0065,1680.3074,1553.0979,1489.2059,1364.5984,1464.3612,1459.2847,1466.7635,1508.3444,1682.5208,1494.0463,1503.024,1512.3843,1520.4961,1543.6868,1559.0397,1561.5784,1575.1753,1571.1008,1401.1654,1418.4617,1267.3484,1139.4991,1208.2249,1254.3809,1605.6681,1669.95,1819.4675,1673.0723,1564.6042,1556.1611,1711.6505,1882.6439,1804.2832,1633.775,1488.4418,1442.7345,1532.2837,1528.4869,1498.9297,1575.5889,1710.883,1709.4044,1585.689,1555.2704,1526.6097,1510.084,1501.7208,1474.3293,1379.6869,1340.1549,1103.8585,1010.3584,547.2962,659.9113,645.0441,693.99036,1159.8799};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {1640.2437,1863.8297,2192.3357,2076.7153,1768.8337,1714.6578,1816.0901,1894.3516,1600.3496,1548.5309,1593.5494,1672.4055,1759.249,1797.3822,1745.6075,1780.1515,1657.6958,1559.3085,1511.0302,1434.2205,1450.7897,1416.4464,1290.6099,904.32825,1842.318,1616.6099,1343.5406,1229.4167,735.2936,590.782,563.27747,565.3359,845.5784,1193.8041,1590.5044,1970.6774,2177.3328,2321.0537,2433.9387,2300.1748,2053.6177,1986.1465,1754.4432,1789.0167,2272.9187,1954.5521,1673.5322,1832.9348,1728.8958,1516.2958,1409.6478,1369.8628,1357.1206,1367.0436,1342.6455,1284.0774,1948.7281,1906.8506,1874.1385,1360.1122,925.20734,884.52435,777.2735,641.0371,669.3316,842.0616,973.58136,994.5958,1169.9098,1712.5181,2039.7543,2060.529,2005.1285,1892.7622,1809.888,1878.0416,2154.3804,2073.7324,1968.3354,1831.0734,1726.3529,1752.9818,1498.1875,1383.3169,1449.6522,1389.3824,1339.6575,1396.8962,1771.7959,1839.9524,1582.6296,1403.7045,1675.825,1629.5046,1587.3218,1432.9962,1401.9205,633.442,1459.4598,1242.6324};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {1211.1395,1406.1536,1584.8636,1831.5182,2148.021,1906.0194,1862.6299,2094.5068,1826.6641,1478.6573,1408.7925,1565.145,1804.9246,1883.9594,1838.9895,1716.2899,1811.1671,1605.912,1610.458,1999.4576,1352.449,1417.9673,1278.4169,1885.9176,2146.9182,2078.3337,2019.5148,1996.877,2247.0085,1782.6599,1550.7603,1456.0756,1677.0156,1432.723,1387.2078,1670.4857,2183.9531,2045.6881,1801.7926,1703.4357,1962.0562,1370.4874,1160.1104,1281.637,1442.4357,1950.2389,2276.045,2145.5942,1650.5352,1242.2852,1248.9158,1517.9535,1029.1356,911.8744,1262.7368,1591.3854,1945.6544,2008.8086,1937.6171,1785.2078,2093.1548,2157.5981,1874.4089,1520.2815,1661.6665,1715.1093,2188.3547,2045.9702,2429.3005,1974.0231,1684.7228,1724.0308,1959.5975,1506.8645,1384.8265,1478.3042,1252.5598,1922.6248,2236.6382,2250.548,2198.851,1981.168,1721.6827,1852.8524,1284.7426,1000.1864,896.1458,1634.4103,1221.7025,1370.698,1315.6924,1722.6326,1748.9241,1613.8624,1552.8894,1610.5354,1621.2434,1694.7972,2270.7507,2342.2107};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {2143.7173,1551.8036,1358.3428,1577.8169,1498.9496,1540.6434,1530.2765,1491.555,1524.7465,1980.966,2499.418,2656.5952,2649.4658,2224.9253,1826.4673,1657.7389,1603.6605,1563.9363,829.67365,738.405,1183.4496,1424.3828,1844.7035,1936.6268,1860.1185,1739.4309,1997.8271,2091.6587,2179.175,2059.498,2249.1223,2856.4944,2677.7825,2193.1687,1886.8948,1653.7352,1744.9789,1661.4628,1932.7223,2254.8389,2222.3037,2278.8735,2557.5647,3092.2478,3135.8757,2642.1365,1827.2972,1545.9545,1857.5514,1883.5227,1094.3138,842.6025,1376.1473,1433.3566,2023.8424,2172.6692,2403.3057,2290.1516,2656.5603,2892.8767,2694.114,2338.7454,2503.221,2458.2393,2231.5295,2087.0515,1967.5833,1759.4987,1728.3838,1763.7264,2074.2034,2675.8984,2585.315,2317.8806,2322.0195,2756.6409,3029.3008,2664.7886,2445.9827,2017.5073,1455.3959,1696.9576,1569.7377,1450.326,1206.6521,1434.9119,2127.098,2046.2805,2325.41,2306.0886,2094.3267,2110.9414,2045.8932,2081.8894,1999.0176,1948.5306,1975.4565,1808.3961,1918.9913,2016.968};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {2139.0159,2045.3959,2042.9462,2240.9907,2344.7075,2277.384,2123.893,2241.3696,2660.816,2588.8442,2609.3298,2385.6409,1117.3251,864.70245,908.73816,1367.402,1334.9169,1073.8281,509.55133,749.9878,2138.3232,2049.3838,2086.2349,2064.7244,2243.5024,2330.1526,2149.0825,2054.843,2162.1409,2367.4312,2288.3118,2251.5903,2374.9836,2478.933,2502.4377,2588.0737,2474.3604,2327.0771,2391.302,3349.7146,4087.8318,5005.3184,4980.6206,3586.6208,794.9598,1204.8837,471.4678,1082.7195,1231.3804,1687.3751,424.63934,759.99445,2047.721,1507.5209,1666.5272,1749.1537,1719.4143,1756.8933,2118.4177,1564.4928,1894.9845,2075.4697,2306.227,2357.4138,2583.4265,3585.7234,3025.4287,2871.847,2621.2695,2704.7656,3619.0166,3789.1,4906.5757,5417.46,5231.8413,4690.276,381.48093,1017.0865,251.8554,1034.7377,1686.9943,2637.6484,3077.0867,2409.495,1749.7401,1120.0171,1143.57,1310.968,1352.573,1584.4506,1688.2933,1792.275,2233.571,2390.5166,2635.4373,2861.6277,2914.7708,3330.707,3515.975,3411.1729};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {3387.5806,4562.6787,5024.557,4777.4043,5190.286,4363.086,4528.561,4646.114,530.0109,1476.9308,1451.3882,2089.5398,2354.7722,2574.535,2476.9631,2023.3826,1355.3037,1079.8,1225.3237,1335.2056,1497.9392,1698.848,1816.6805,1957.4867,2225.2798,2427.862,2650.6,3011.812,3311.0898,3804.3594,3746.1543,4014.0774,3986.8252,5048.6714,5645.0396,6140.241,4923.643,3869.0342,3849.7207,3992.5796,1363.518,1580.888,2005.6615,2440.24,2365.3542,2087.165,1969.9438,1838.3745,1418.0024,1182.1726,1087.612,1502.813,1607.4474,1751.3516,1855.7163,2047.1068,2216.2268,2412.3523,2714.5342,3073.6682,3454.3325,3880.7317,4066.773,4351.826,4523.827,5318.151,6212.4453,6316.9873,4862.755,3998.739,3548.1028,3242.079,1412.2201,1785.4989,2273.3413,2133.799,2261.7583,2062.0005,2077.7173,1671.7566,1435.2891,1032.5299,1177.1587,1834.3898,1517.3254,1863.5867,2011.0726,2131.64,2303.357,2507.589,2815.7744,3272.5725,3669.3118,4050.0476,4346.421,4592.1167,4705.6426,5085.968,6314.9775,6450.81};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {4604.654,3965.824,3511.137,3131.8188,1193.7002,1427.3481,1775.285,1541.7678,1238.0583,1460.3464,1442.6323,1049.2611,1176.6154,1011.20764,1190.8633,1627.171,1623.5717,1808.0193,2087.691,2228.4092,2442.133,2721.5613,2986.8179,3453.096,3952.4417,4368.674,4668.922,4829.924,4912.4883,5179.5547,5844.0747,5362.0996,4578.648,3955.6252,3567.83,3218.4812,1119.4799,1466.9922,1496.906,1297.6969,850.09717,710.86676,760.5353,785.5298,761.4881,911.3683,971.5178,1660.4159,1547.9054,1919.3359,2174.4993,2314.2751,2546.8433,2922.3142,3397.7686,3977.5781,4463.6104,4902.053,5150.239,5153.931,5340.621,5585.404,5962.0,5388.133,4704.3213,4242.8325,3884.9329,3550.3203,1544.7313,1591.2103,1383.8815,880.23474,-125.23994,34.200146,441.08978,807.83203,960.158,641.2658,920.65204,1301.7152,1641.6172,1949.0831,2259.4521,2520.174,2807.3884,3198.1865,3904.5276,4844.465,5361.212,5640.818,5722.9253,5645.966,6524.4824,6142.183,6156.463,5708.267,5224.102,4819.1406,4410.0674,3957.9233};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1690.8542,1439.4663,1198.4753,395.72577,-411.96194,-102.17007,220.85933,516.4591,886.71735,483.82037,903.8181,1064.496,1529.1267,1933.6833,2301.732,2751.3967,3124.8281,3675.6172,4826.868,6197.0757,6645.0337,6434.666,6168.3784,6344.266,6865.623,6345.1553,6487.173,6566.113,6121.282,5584.119,5032.337,4414.675,770.1118,794.8276,591.6868,-199.0935,-789.1251,-416.88364,-253.68095,135.33241,388.84476,203.1434,382.14908,916.12317,1139.9454,1743.7883,2268.9668,2733.394,3298.2175,4196.296,6092.265,8842.551,8696.73,7117.7095,6643.95,6474.612,6066.9546,6162.0977,6762.4897,7091.613,6536.9736,6207.0938,5519.9434,4785.154,-1324.0504,-1618.5857,-359.87198,-550.6534,-1010.40594,-925.58124,-805.7256,-478.4729,-264.3458,-186.43965,127.68712,515.06757,920.8298,1500.3507,2026.7783,2679.4722,3404.9465,4418.351,6310.9014,10338.641,12491.855,7748.5317,6880.7725,6904.187,6308.064,6573.8564,7156.518,7245.0283,6425.6772,6307.7344,5231.8867,4950.7856,-1143.9713,-1607.9354,-2007.4135,-1292.6077};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {-1368.7433,-1601.069,-1352.2861,-922.28235,-723.4166,-547.5751,-349.5278,95.763245,598.2846,1173.654,1795.8564,2425.801,3171.2263,4064.7988,5061.5107,10397.371,14843.9795,9292.417,7097.122,7029.857,6976.503,6918.6367,7033.0635,6960.483,5967.4614,5342.897,3245.1365,4697.355,-1605.1663,-1632.9354,-1900.8901,-2434.8772,-2334.0725,-2283.2717,-1623.2228,-853.44775,-1199.0579,-1589.7314,-1738.5131,-1043.4377,90.58444,652.6928,1326.7411,2042.5156,2783.568,3509.3918,4389.708,6858.016,9482.163,8746.772,7351.9307,6964.723,6711.319,6792.5586,6613.4043,6593.4126,5721.118,4813.8667,2466.4016,1736.3917,-1921.7646,-2147.27,-2131.712,-3017.2422,-2887.9768,-2245.6006,-1486.3746,-346.20926,-1982.7903,-2679.2734,-1995.4788,-674.09686,-1086.031,-256.35336,648.6815,1206.9802,2105.0234,2943.0242,3884.4797,4945.37,6534.4204,7222.239,7887.9097,7076.8228,6179.802,5844.7144,5800.062,6040.5454,5700.8745,5065.55,4264.4106,3934.4692,-2331.8135,-2621.4492,-2782.416,-3055.9858,-3096.7434,-2402.735,-1296.9989,-851.7626};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {-2630.653,-2932.1582,-2101.7654,-1802.2705,-1011.29004,-770.3503,-303.37286,790.00336,1797.828,2478.528,3559.416,4507.473,5257.7207,6083.886,9589.305,9023.787,5749.0635,5539.3335,5224.552,4907.0835,4358.972,3896.072,3415.7349,2817.428};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.03226,0.00391,0.06452,0.00391,0.09677,0.00391,0.12903,0.00391,0.16129,0.00391,0.19355,0.00391,0.22581,0.00391,0.25806,0.00391,0.29032,0.00391,0.32258,0.00391,0.35484,0.00391,0.3871,0.00391,0.41935,0.00391,0.45161,0.00391,0.48387,0.00391,0.51613,0.00391,0.54839,0.00391,0.58065,0.00391,0.6129,0.00391,0.64516,0.00391,0.67742,0.00391,0.70968,0.00391,0.74194,0.00391,0.77419,0.00391,0.80645,0.00391,0.83871,0.00391,0.87097,0.00391,0.90323,0.00391,0.93548,0.00391,0.96774,0.00391,0.99609,0.00391,0.00391,0.03226,0.03226,0.03226,0.06452,0.03226,0.09677,0.03226,0.12903,0.03226,0.16129,0.03226,0.19355,0.03226,0.22581,0.03226,0.25806,0.03226,0.29032,0.03226,0.32258,0.03226,0.35484,0.03226,0.3871,0.03226,0.41935,0.03226,0.45161,0.03226,0.48387,0.03226,0.51613,0.03226,0.54839,0.03226,0.58065,0.03226,0.6129,0.03226,0.64516,0.03226,0.67742,0.03226,0.70968,0.03226,0.74194,0.03226,0.77419,0.03226,0.80645,0.03226,0.83871,0.03226,0.87097,0.03226,0.90323,0.03226,0.93548,0.03226,0.96774,0.03226,0.99609,0.03226,0.00391,0.06452,0.03226,0.06452,0.06452,0.06452,0.09677,0.06452,0.12903,0.06452,0.16129,0.06452,0.19355,0.06452,0.22581,0.06452,0.25806,0.06452,0.29032,0.06452,0.32258,0.06452,0.35484,0.06452,0.3871,0.06452,0.41935,0.06452,0.45161,0.06452,0.48387,0.06452,0.51613,0.06452,0.54839,0.06452,0.58065,0.06452,0.6129,0.06452,0.64516,0.06452,0.67742,0.06452,0.70968,0.06452,0.74194,0.06452,0.77419,0.06452,0.80645,0.06452,0.83871,0.06452,0.87097,0.06452,0.90323,0.06452,0.93548,0.06452,0.96774,0.06452,0.99609,0.06452,0.00391,0.09677,0.03226,0.09677,0.06452,0.09677,0.09677,0.09677};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.12903,0.09677,0.16129,0.09677,0.19355,0.09677,0.22581,0.09677,0.25806,0.09677,0.29032,0.09677,0.32258,0.09677,0.35484,0.09677,0.3871,0.09677,0.41935,0.09677,0.45161,0.09677,0.48387,0.09677,0.51613,0.09677,0.54839,0.09677,0.58065,0.09677,0.6129,0.09677,0.64516,0.09677,0.67742,0.09677,0.70968,0.09677,0.74194,0.09677,0.77419,0.09677,0.80645,0.09677,0.83871,0.09677,0.87097,0.09677,0.90323,0.09677,0.93548,0.09677,0.96774,0.09677,0.99609,0.09677,0.00391,0.12903,0.03226,0.12903,0.06452,0.12903,0.09677,0.12903,0.12903,0.12903,0.16129,0.12903,0.19355,0.12903,0.22581,0.12903,0.25806,0.12903,0.29032,0.12903,0.32258,0.12903,0.35484,0.12903,0.3871,0.12903,0.41935,0.12903,0.45161,0.12903,0.48387,0.12903,0.51613,0.12903,0.54839,0.12903,0.58065,0.12903,0.6129,0.12903,0.64516,0.12903,0.67742,0.12903,0.70968,0.12903,0.74194,0.12903,0.77419,0.12903,0.80645,0.12903,0.83871,0.12903,0.87097,0.12903,0.90323,0.12903,0.93548,0.12903,0.96774,0.12903,0.99609,0.12903,0.00391,0.16129,0.03226,0.16129,0.06452,0.16129,0.09677,0.16129,0.12903,0.16129,0.16129,0.16129,0.19355,0.16129,0.22581,0.16129,0.25806,0.16129,0.29032,0.16129,0.32258,0.16129,0.35484,0.16129,0.3871,0.16129,0.41935,0.16129,0.45161,0.16129,0.48387,0.16129,0.51613,0.16129,0.54839,0.16129,0.58065,0.16129,0.6129,0.16129,0.64516,0.16129,0.67742,0.16129,0.70968,0.16129,0.74194,0.16129,0.77419,0.16129,0.80645,0.16129,0.83871,0.16129,0.87097,0.16129,0.90323,0.16129,0.93548,0.16129,0.96774,0.16129,0.99609,0.16129,0.00391,0.19355,0.03226,0.19355,0.06452,0.19355,0.09677,0.19355,0.12903,0.19355,0.16129,0.19355,0.19355,0.19355,0.22581,0.19355};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.25806,0.19355,0.29032,0.19355,0.32258,0.19355,0.35484,0.19355,0.3871,0.19355,0.41935,0.19355,0.45161,0.19355,0.48387,0.19355,0.51613,0.19355,0.54839,0.19355,0.58065,0.19355,0.6129,0.19355,0.64516,0.19355,0.67742,0.19355,0.70968,0.19355,0.74194,0.19355,0.77419,0.19355,0.80645,0.19355,0.83871,0.19355,0.87097,0.19355,0.90323,0.19355,0.93548,0.19355,0.96774,0.19355,0.99609,0.19355,0.00391,0.22581,0.03226,0.22581,0.06452,0.22581,0.09677,0.22581,0.12903,0.22581,0.16129,0.22581,0.19355,0.22581,0.22581,0.22581,0.25806,0.22581,0.29032,0.22581,0.32258,0.22581,0.35484,0.22581,0.3871,0.22581,0.41935,0.22581,0.45161,0.22581,0.48387,0.22581,0.51613,0.22581,0.54839,0.22581,0.58065,0.22581,0.6129,0.22581,0.64516,0.22581,0.67742,0.22581,0.70968,0.22581,0.74194,0.22581,0.77419,0.22581,0.80645,0.22581,0.83871,0.22581,0.87097,0.22581,0.90323,0.22581,0.93548,0.22581,0.96774,0.22581,0.99609,0.22581,0.00391,0.25806,0.03226,0.25806,0.06452,0.25806,0.09677,0.25806,0.12903,0.25806,0.16129,0.25806,0.19355,0.25806,0.22581,0.25806,0.25806,0.25806,0.29032,0.25806,0.32258,0.25806,0.35484,0.25806,0.3871,0.25806,0.41935,0.25806,0.45161,0.25806,0.48387,0.25806,0.51613,0.25806,0.54839,0.25806,0.58065,0.25806,0.6129,0.25806,0.64516,0.25806,0.67742,0.25806,0.70968,0.25806,0.74194,0.25806,0.77419,0.25806,0.80645,0.25806,0.83871,0.25806,0.87097,0.25806,0.90323,0.25806,0.93548,0.25806,0.96774,0.25806,0.99609,0.25806,0.00391,0.29032,0.03226,0.29032,0.06452,0.29032,0.09677,0.29032,0.12903,0.29032,0.16129,0.29032,0.19355,0.29032,0.22581,0.29032,0.25806,0.29032,0.29032,0.29032,0.32258,0.29032,0.35484,0.29032};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.3871,0.29032,0.41935,0.29032,0.45161,0.29032,0.48387,0.29032,0.51613,0.29032,0.54839,0.29032,0.58065,0.29032,0.6129,0.29032,0.64516,0.29032,0.67742,0.29032,0.70968,0.29032,0.74194,0.29032,0.77419,0.29032,0.80645,0.29032,0.83871,0.29032,0.87097,0.29032,0.90323,0.29032,0.93548,0.29032,0.96774,0.29032,0.99609,0.29032,0.00391,0.32258,0.03226,0.32258,0.06452,0.32258,0.09677,0.32258,0.12903,0.32258,0.16129,0.32258,0.19355,0.32258,0.22581,0.32258,0.25806,0.32258,0.29032,0.32258,0.32258,0.32258,0.35484,0.32258,0.3871,0.32258,0.41935,0.32258,0.45161,0.32258,0.48387,0.32258,0.51613,0.32258,0.54839,0.32258,0.58065,0.32258,0.6129,0.32258,0.64516,0.32258,0.67742,0.32258,0.70968,0.32258,0.74194,0.32258,0.77419,0.32258,0.80645,0.32258,0.83871,0.32258,0.87097,0.32258,0.90323,0.32258,0.93548,0.32258,0.96774,0.32258,0.99609,0.32258,0.00391,0.35484,0.03226,0.35484,0.06452,0.35484,0.09677,0.35484,0.12903,0.35484,0.16129,0.35484,0.19355,0.35484,0.22581,0.35484,0.25806,0.35484,0.29032,0.35484,0.32258,0.35484,0.35484,0.35484,0.3871,0.35484,0.41935,0.35484,0.45161,0.35484,0.48387,0.35484,0.51613,0.35484,0.54839,0.35484,0.58065,0.35484,0.6129,0.35484,0.64516,0.35484,0.67742,0.35484,0.70968,0.35484,0.74194,0.35484,0.77419,0.35484,0.80645,0.35484,0.83871,0.35484,0.87097,0.35484,0.90323,0.35484,0.93548,0.35484,0.96774,0.35484,0.99609,0.35484,0.00391,0.3871,0.03226,0.3871,0.06452,0.3871,0.09677,0.3871,0.12903,0.3871,0.16129,0.3871,0.19355,0.3871,0.22581,0.3871,0.25806,0.3871,0.29032,0.3871,0.32258,0.3871,0.35484,0.3871,0.3871,0.3871,0.41935,0.3871,0.45161,0.3871,0.48387,0.3871};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.51613,0.3871,0.54839,0.3871,0.58065,0.3871,0.6129,0.3871,0.64516,0.3871,0.67742,0.3871,0.70968,0.3871,0.74194,0.3871,0.77419,0.3871,0.80645,0.3871,0.83871,0.3871,0.87097,0.3871,0.90323,0.3871,0.93548,0.3871,0.96774,0.3871,0.99609,0.3871,0.00391,0.41935,0.03226,0.41935,0.06452,0.41935,0.09677,0.41935,0.12903,0.41935,0.16129,0.41935,0.19355,0.41935,0.22581,0.41935,0.25806,0.41935,0.29032,0.41935,0.32258,0.41935,0.35484,0.41935,0.3871,0.41935,0.41935,0.41935,0.45161,0.41935,0.48387,0.41935,0.51613,0.41935,0.54839,0.41935,0.58065,0.41935,0.6129,0.41935,0.64516,0.41935,0.67742,0.41935,0.70968,0.41935,0.74194,0.41935,0.77419,0.41935,0.80645,0.41935,0.83871,0.41935,0.87097,0.41935,0.90323,0.41935,0.93548,0.41935,0.96774,0.41935,0.99609,0.41935,0.00391,0.45161,0.03226,0.45161,0.06452,0.45161,0.09677,0.45161,0.12903,0.45161,0.16129,0.45161,0.19355,0.45161,0.22581,0.45161,0.25806,0.45161,0.29032,0.45161,0.32258,0.45161,0.35484,0.45161,0.3871,0.45161,0.41935,0.45161,0.45161,0.45161,0.48387,0.45161,0.51613,0.45161,0.54839,0.45161,0.58065,0.45161,0.6129,0.45161,0.64516,0.45161,0.67742,0.45161,0.70968,0.45161,0.74194,0.45161,0.77419,0.45161,0.80645,0.45161,0.83871,0.45161,0.87097,0.45161,0.90323,0.45161,0.93548,0.45161,0.96774,0.45161,0.99609,0.45161,0.00391,0.48387,0.03226,0.48387,0.06452,0.48387,0.09677,0.48387,0.12903,0.48387,0.16129,0.48387,0.19355,0.48387,0.22581,0.48387,0.25806,0.48387,0.29032,0.48387,0.32258,0.48387,0.35484,0.48387,0.3871,0.48387,0.41935,0.48387,0.45161,0.48387,0.48387,0.48387,0.51613,0.48387,0.54839,0.48387,0.58065,0.48387,0.6129,0.48387};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.64516,0.48387,0.67742,0.48387,0.70968,0.48387,0.74194,0.48387,0.77419,0.48387,0.80645,0.48387,0.83871,0.48387,0.87097,0.48387,0.90323,0.48387,0.93548,0.48387,0.96774,0.48387,0.99609,0.48387,0.00391,0.51613,0.03226,0.51613,0.06452,0.51613,0.09677,0.51613,0.12903,0.51613,0.16129,0.51613,0.19355,0.51613,0.22581,0.51613,0.25806,0.51613,0.29032,0.51613,0.32258,0.51613,0.35484,0.51613,0.3871,0.51613,0.41935,0.51613,0.45161,0.51613,0.48387,0.51613,0.51613,0.51613,0.54839,0.51613,0.58065,0.51613,0.6129,0.51613,0.64516,0.51613,0.67742,0.51613,0.70968,0.51613,0.74194,0.51613,0.77419,0.51613,0.80645,0.51613,0.83871,0.51613,0.87097,0.51613,0.90323,0.51613,0.93548,0.51613,0.96774,0.51613,0.99609,0.51613,0.00391,0.54839,0.03226,0.54839,0.06452,0.54839,0.09677,0.54839,0.12903,0.54839,0.16129,0.54839,0.19355,0.54839,0.22581,0.54839,0.25806,0.54839,0.29032,0.54839,0.32258,0.54839,0.35484,0.54839,0.3871,0.54839,0.41935,0.54839,0.45161,0.54839,0.48387,0.54839,0.51613,0.54839,0.54839,0.54839,0.58065,0.54839,0.6129,0.54839,0.64516,0.54839,0.67742,0.54839,0.70968,0.54839,0.74194,0.54839,0.77419,0.54839,0.80645,0.54839,0.83871,0.54839,0.87097,0.54839,0.90323,0.54839,0.93548,0.54839,0.96774,0.54839,0.99609,0.54839,0.00391,0.58065,0.03226,0.58065,0.06452,0.58065,0.09677,0.58065,0.12903,0.58065,0.16129,0.58065,0.19355,0.58065,0.22581,0.58065,0.25806,0.58065,0.29032,0.58065,0.32258,0.58065,0.35484,0.58065,0.3871,0.58065,0.41935,0.58065,0.45161,0.58065,0.48387,0.58065,0.51613,0.58065,0.54839,0.58065,0.58065,0.58065,0.6129,0.58065,0.64516,0.58065,0.67742,0.58065,0.70968,0.58065,0.74194,0.58065};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.77419,0.58065,0.80645,0.58065,0.83871,0.58065,0.87097,0.58065,0.90323,0.58065,0.93548,0.58065,0.96774,0.58065,0.99609,0.58065,0.00391,0.6129,0.03226,0.6129,0.06452,0.6129,0.09677,0.6129,0.12903,0.6129,0.16129,0.6129,0.19355,0.6129,0.22581,0.6129,0.25806,0.6129,0.29032,0.6129,0.32258,0.6129,0.35484,0.6129,0.3871,0.6129,0.41935,0.6129,0.45161,0.6129,0.48387,0.6129,0.51613,0.6129,0.54839,0.6129,0.58065,0.6129,0.6129,0.6129,0.64516,0.6129,0.67742,0.6129,0.70968,0.6129,0.74194,0.6129,0.77419,0.6129,0.80645,0.6129,0.83871,0.6129,0.87097,0.6129,0.90323,0.6129,0.93548,0.6129,0.96774,0.6129,0.99609,0.6129,0.00391,0.64516,0.03226,0.64516,0.06452,0.64516,0.09677,0.64516,0.12903,0.64516,0.16129,0.64516,0.19355,0.64516,0.22581,0.64516,0.25806,0.64516,0.29032,0.64516,0.32258,0.64516,0.35484,0.64516,0.3871,0.64516,0.41935,0.64516,0.45161,0.64516,0.48387,0.64516,0.51613,0.64516,0.54839,0.64516,0.58065,0.64516,0.6129,0.64516,0.64516,0.64516,0.67742,0.64516,0.70968,0.64516,0.74194,0.64516,0.77419,0.64516,0.80645,0.64516,0.83871,0.64516,0.87097,0.64516,0.90323,0.64516,0.93548,0.64516,0.96774,0.64516,0.99609,0.64516,0.00391,0.67742,0.03226,0.67742,0.06452,0.67742,0.09677,0.67742,0.12903,0.67742,0.16129,0.67742,0.19355,0.67742,0.22581,0.67742,0.25806,0.67742,0.29032,0.67742,0.32258,0.67742,0.35484,0.67742,0.3871,0.67742,0.41935,0.67742,0.45161,0.67742,0.48387,0.67742,0.51613,0.67742,0.54839,0.67742,0.58065,0.67742,0.6129,0.67742,0.64516,0.67742,0.67742,0.67742,0.70968,0.67742,0.74194,0.67742,0.77419,0.67742,0.80645,0.67742,0.83871,0.67742,0.87097,0.67742};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.90323,0.67742,0.93548,0.67742,0.96774,0.67742,0.99609,0.67742,0.00391,0.70968,0.03226,0.70968,0.06452,0.70968,0.09677,0.70968,0.12903,0.70968,0.16129,0.70968,0.19355,0.70968,0.22581,0.70968,0.25806,0.70968,0.29032,0.70968,0.32258,0.70968,0.35484,0.70968,0.3871,0.70968,0.41935,0.70968,0.45161,0.70968,0.48387,0.70968,0.51613,0.70968,0.54839,0.70968,0.58065,0.70968,0.6129,0.70968,0.64516,0.70968,0.67742,0.70968,0.70968,0.70968,0.74194,0.70968,0.77419,0.70968,0.80645,0.70968,0.83871,0.70968,0.87097,0.70968,0.90323,0.70968,0.93548,0.70968,0.96774,0.70968,0.99609,0.70968,0.00391,0.74194,0.03226,0.74194,0.06452,0.74194,0.09677,0.74194,0.12903,0.74194,0.16129,0.74194,0.19355,0.74194,0.22581,0.74194,0.25806,0.74194,0.29032,0.74194,0.32258,0.74194,0.35484,0.74194,0.3871,0.74194,0.41935,0.74194,0.45161,0.74194,0.48387,0.74194,0.51613,0.74194,0.54839,0.74194,0.58065,0.74194,0.6129,0.74194,0.64516,0.74194,0.67742,0.74194,0.70968,0.74194,0.74194,0.74194,0.77419,0.74194,0.80645,0.74194,0.83871,0.74194,0.87097,0.74194,0.90323,0.74194,0.93548,0.74194,0.96774,0.74194,0.99609,0.74194,0.00391,0.77419,0.03226,0.77419,0.06452,0.77419,0.09677,0.77419,0.12903,0.77419,0.16129,0.77419,0.19355,0.77419,0.22581,0.77419,0.25806,0.77419,0.29032,0.77419,0.32258,0.77419,0.35484,0.77419,0.3871,0.77419,0.41935,0.77419,0.45161,0.77419,0.48387,0.77419,0.51613,0.77419,0.54839,0.77419,0.58065,0.77419,0.6129,0.77419,0.64516,0.77419,0.67742,0.77419,0.70968,0.77419,0.74194,0.77419,0.77419,0.77419,0.80645,0.77419,0.83871,0.77419,0.87097,0.77419,0.90323,0.77419,0.93548,0.77419,0.96774,0.77419,0.99609,0.77419};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.80645,0.03226,0.80645,0.06452,0.80645,0.09677,0.80645,0.12903,0.80645,0.16129,0.80645,0.19355,0.80645,0.22581,0.80645,0.25806,0.80645,0.29032,0.80645,0.32258,0.80645,0.35484,0.80645,0.3871,0.80645,0.41935,0.80645,0.45161,0.80645,0.48387,0.80645,0.51613,0.80645,0.54839,0.80645,0.58065,0.80645,0.6129,0.80645,0.64516,0.80645,0.67742,0.80645,0.70968,0.80645,0.74194,0.80645,0.77419,0.80645,0.80645,0.80645,0.83871,0.80645,0.87097,0.80645,0.90323,0.80645,0.93548,0.80645,0.96774,0.80645,0.99609,0.80645,0.00391,0.83871,0.03226,0.83871,0.06452,0.83871,0.09677,0.83871,0.12903,0.83871,0.16129,0.83871,0.19355,0.83871,0.22581,0.83871,0.25806,0.83871,0.29032,0.83871,0.32258,0.83871,0.35484,0.83871,0.3871,0.83871,0.41935,0.83871,0.45161,0.83871,0.48387,0.83871,0.51613,0.83871,0.54839,0.83871,0.58065,0.83871,0.6129,0.83871,0.64516,0.83871,0.67742,0.83871,0.70968,0.83871,0.74194,0.83871,0.77419,0.83871,0.80645,0.83871,0.83871,0.83871,0.87097,0.83871,0.90323,0.83871,0.93548,0.83871,0.96774,0.83871,0.99609,0.83871,0.00391,0.87097,0.03226,0.87097,0.06452,0.87097,0.09677,0.87097,0.12903,0.87097,0.16129,0.87097,0.19355,0.87097,0.22581,0.87097,0.25806,0.87097,0.29032,0.87097,0.32258,0.87097,0.35484,0.87097,0.3871,0.87097,0.41935,0.87097,0.45161,0.87097,0.48387,0.87097,0.51613,0.87097,0.54839,0.87097,0.58065,0.87097,0.6129,0.87097,0.64516,0.87097,0.67742,0.87097,0.70968,0.87097,0.74194,0.87097,0.77419,0.87097,0.80645,0.87097,0.83871,0.87097,0.87097,0.87097,0.90323,0.87097,0.93548,0.87097,0.96774,0.87097,0.99609,0.87097,0.00391,0.90323,0.03226,0.90323,0.06452,0.90323,0.09677,0.90323};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.12903,0.90323,0.16129,0.90323,0.19355,0.90323,0.22581,0.90323,0.25806,0.90323,0.29032,0.90323,0.32258,0.90323,0.35484,0.90323,0.3871,0.90323,0.41935,0.90323,0.45161,0.90323,0.48387,0.90323,0.51613,0.90323,0.54839,0.90323,0.58065,0.90323,0.6129,0.90323,0.64516,0.90323,0.67742,0.90323,0.70968,0.90323,0.74194,0.90323,0.77419,0.90323,0.80645,0.90323,0.83871,0.90323,0.87097,0.90323,0.90323,0.90323,0.93548,0.90323,0.96774,0.90323,0.99609,0.90323,0.00391,0.93548,0.03226,0.93548,0.06452,0.93548,0.09677,0.93548,0.12903,0.93548,0.16129,0.93548,0.19355,0.93548,0.22581,0.93548,0.25806,0.93548,0.29032,0.93548,0.32258,0.93548,0.35484,0.93548,0.3871,0.93548,0.41935,0.93548,0.45161,0.93548,0.48387,0.93548,0.51613,0.93548,0.54839,0.93548,0.58065,0.93548,0.6129,0.93548,0.64516,0.93548,0.67742,0.93548,0.70968,0.93548,0.74194,0.93548,0.77419,0.93548,0.80645,0.93548,0.83871,0.93548,0.87097,0.93548,0.90323,0.93548,0.93548,0.93548,0.96774,0.93548,0.99609,0.93548,0.00391,0.96774,0.03226,0.96774,0.06452,0.96774,0.09677,0.96774,0.12903,0.96774,0.16129,0.96774,0.19355,0.96774,0.22581,0.96774,0.25806,0.96774,0.29032,0.96774,0.32258,0.96774,0.35484,0.96774,0.3871,0.96774,0.41935,0.96774,0.45161,0.96774,0.48387,0.96774,0.51613,0.96774,0.54839,0.96774,0.58065,0.96774,0.6129,0.96774,0.64516,0.96774,0.67742,0.96774,0.70968,0.96774,0.74194,0.96774,0.77419,0.96774,0.80645,0.96774,0.83871,0.96774,0.87097,0.96774,0.90323,0.96774,0.93548,0.96774,0.96774,0.96774,0.99609,0.96774,0.00391,0.99609,0.03226,0.99609,0.06452,0.99609,0.09677,0.99609,0.12903,0.99609,0.16129,0.99609,0.19355,0.99609,0.22581,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.25806,0.99609,0.29032,0.99609,0.32258,0.99609,0.35484,0.99609,0.3871,0.99609,0.41935,0.99609,0.45161,0.99609,0.48387,0.99609,0.51613,0.99609,0.54839,0.99609,0.58065,0.99609,0.6129,0.99609,0.64516,0.99609,0.67742,0.99609,0.70968,0.99609,0.74194,0.99609,0.77419,0.99609,0.80645,0.99609,0.83871,0.99609,0.87097,0.99609,0.90323,0.99609,0.93548,0.99609,0.96774,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 1024 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 2048 total numbers made up of 1024 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MarsLOD000 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MarsLOD000().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.MarsLOD000\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.MarsLOD000 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/MarsLOD000_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/MarsLOD000_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/MarsLOD000_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/MarsLOD000_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
