####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Mars.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='Mars.x3d',name='title'),
    meta(content='This model was output using the GeoVRML export capabilities of the ESRI 3D Analyst Extension for ArcView/ArcInfo 8.1 product (official release date Q1 2001). This combines coarse resolution image and elevation data for the planet Mars, using lat/long coordinates.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/Mars.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["Generated by ArcScene"],title='ArcScene Document'),
    Background(skyColor=[(1.0,1.0,1.0)]),
    DirectionalLight(ambientIntensity=0.3,direction=(0.612372,-0.612372,-0.5)),
    DirectionalLight(ambientIntensity=0.3,direction=(-0.612372,0.612372,0.5)),
    GeoViewpoint(description='default',fieldOfView=0.3,orientation=(1.0,0.0,0.0,-1.570796),position=(0.000000,0.000000,106528752.000000),
      geoOrigin=GeoOrigin(DEF='ORIGIN',rotateYUp=True)),
    Group(
      children=[
      Group(
        children=[
        Group(),
        Group(
          children=[
          Group(
            children=[
            GeoLOD(center=(-45.000000,-135.000000,200025.000000),child1Url=["MarsLOD000.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD000.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars000.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars000.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,-180.000000,0.000000),height=[2908.041,2881.6082,2854.3174,2796.9473,2747.8347,2721.1191,2673.9934,2590.4485,2496.435,2404.129,2254.7925,2222.4797,2266.3079,2282.9639,2319.6162,2289.733,2321.241,2244.1719,2099.2666,1917.1066,1938.8059,1923.1176,1964.3021,1879.7612,1658.9388,1630.0164,1638.8497,1662.4501,1638.7495,1627.9354,1752.0818,1880.8734,1268.8947,1059.65,1062.7446,1519.5258,1973.6776,1670.8254,1724.5215,1781.8591,1442.18,1544.9182,1608.6644,1698.1368,1571.9779,1522.4054,1475.1785,1433.5204,1522.3167,1027.4335,705.34375,825.7319,1282.5896,1712.9783,1975.403,2055.2253,1835.7422,1917.8739,1943.0504,1784.1774,1567.4086,1412.0352,1370.7722,1262.0449,1705.2252,1637.5687,1651.3041,1590.9078,1250.5287,1328.7317,1477.8933,1848.9885,1928.3582,1957.8053,1536.8347,1563.9474,1905.3024,1766.6547,1405.4524,1371.6388,1058.0029,1614.1472,1945.0726,1926.3468,2046.9906,1633.4471,1858.4543,2116.4927,1941.5604,1836.4886,1571.872,1376.2538,2007.7029,2283.3203,1904.9031,1759.1534,1436.9929,1052.076,1535.2172,1958.5452,1976.902,2251.7551,2208.4749,2528.826,1970.298,1670.9573,1804.4287,2210.6072,2336.9739,2880.9248,2344.8257,1768.0303,1439.3638,1301.8923,1653.1647,2151.6233,2232.2437,2042.3052,2143.3845,2056.542,1941.069,2128.2473,2163.164,2360.6548,2258.7942,2600.345,2957.4653,2547.6416,944.31775,1163.1847,1571.0477,1285.8088,1612.0544,1795.2123,1951.9138,1878.8535,2377.683,2477.7905,3042.3623,2930.7058,3343.4436,4548.78,5344.9897,4678.967,1430.4224,1969.3375,2404.1785,1879.0391,1170.6016,1359.3027,1725.6239,2009.3491,2503.464,3060.1284,3694.929,3969.8635,5234.266,5418.399,3967.298,3689.0776,1886.0356,2101.6575,1966.6194,1629.0065,1122.0305,1596.4785,1892.9181,2190.371,2637.8015,3428.886,4154.512,4665.2046,5496.258,5426.8423,3806.5063,3084.7341,1471.7858,1033.8896,715.0727,891.3217,854.1125,1523.749,1976.343,2436.3286,3131.034,4294.1104,5037.8184,5402.2505,5692.373,5232.8594,4215.8228,3460.9673,1253.0765,126.490585,4.636828,575.8597,509.7232,1273.88,1996.1046,2839.3047,4207.328,6742.151,6401.814,6400.795,6299.104,6369.154,5415.2534,4276.9443,-794.65344,-840.7285,-1031.081,-442.34918,-171.76003,612.99243,1619.9626,2831.7456,4935.6265,11369.023,8237.837,6621.2705,6709.6963,6683.7515,5554.1553,4406.957,-1852.7922,-2225.069,-1975.1344,-1147.5878,-1647.8291,-517.8349,728.016,2123.345,3782.0432,8410.818,8392.434,6839.661,6544.602,6198.148,4194.9634,3189.8687,-2663.4814,-3023.9805,-2179.2812,-1707.9641,-2599.4277,-1551.1956,-610.5527,1069.0731,2866.2156,4699.6387,7610.0435,7339.7817,5435.8115,4680.8647,3717.8237,2670.8254],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(45.000000,-135.000000,200450.000000),child1Url=["MarsLOD003.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD003.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars001.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars001.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,-180.000000,0.000000),height=[-2663.4814,-3023.9805,-2179.2812,-1707.9641,-2599.4277,-1551.1956,-610.5527,1069.0731,2866.2156,4699.6387,7610.0435,7339.7817,5435.8115,4680.8647,3717.8237,2670.8254,-3111.9067,-3212.0852,-2787.9148,-2824.954,-3144.3923,-2010.4325,-882.73157,900.83954,1884.392,4315.386,3949.7454,4788.7764,6077.5815,4063.5405,3353.021,1646.039,-3203.1113,-3349.773,-3369.2952,-3433.6038,-3370.9795,-2597.9805,-1275.173,-147.7511,1054.9312,2865.9658,2590.7832,2579.4111,8790.809,4369.4473,2613.753,1372.1371,-3357.9753,-3456.263,-3649.098,-3733.9275,-3526.0356,-2315.1729,2314.399,11753.608,2794.8823,1424.799,2128.8816,2066.169,2697.108,3098.7935,2036.5106,766.7283,-3548.238,-3672.4907,-3795.0933,-3855.1846,-3510.255,-2013.6423,392.9879,5856.5923,1113.4686,702.32227,2033.9042,2756.9033,2145.811,2380.1897,2061.0522,780.57654,-3763.1995,-3861.149,-3882.0698,-3882.3567,-3739.7114,-2218.6467,-1749.8689,-977.07074,-421.60495,1155.5896,2301.4368,3398.7388,2143.05,1808.4458,1885.9222,816.6324,-3891.2346,-3930.252,-3932.4038,-3929.0461,-3920.7275,-3242.6,-2212.1636,-1495.4307,185.90285,1604.4678,2866.5513,3555.9045,2329.0688,1273.3932,955.5946,819.26465,-3958.7273,-3939.2793,-3934.9438,-3920.559,-3882.288,-3602.5525,-2298.3223,-1161.6759,55.0263,2161.691,4668.4277,5383.0596,3765.8472,1411.705,566.4825,976.7941,-4038.2432,-3978.3884,-3946.2283,-3922.0178,-3815.118,-3441.1672,-2676.075,-1841.6127,-988.5304,797.5599,2828.4543,3962.1,2446.893,241.44661,-91.82148,46.3554,-4077.2742,-4027.2668,-3968.4375,-3874.3635,-3647.1516,-3274.3945,-2827.933,-2397.6152,-1990.5801,-1553.7517,-1150.2765,-749.2929,-756.2861,-610.07245,-669.1364,-1125.1345,-4127.2524,-4047.8418,-3972.7266,-3834.9094,-3626.502,-3449.1152,-3131.639,-2886.6873,-2590.9607,-2340.8323,-2188.9841,-2138.5762,-1971.9307,-1651.8549,-1618.5458,-2284.9539,-4209.64,-4165.569,-4100.113,-3979.548,-3841.8848,-3685.5632,-3521.4868,-3380.1748,-3273.6833,-3176.4482,-3103.5586,-3052.9795,-3016.5437,-2920.4165,-2981.9297,-3262.428,-4418.5986,-4388.2397,-4345.445,-4279.1523,-4206.425,-4127.317,-4041.1035,-3971.8054,-3880.1946,-3815.437,-3763.293,-3676.3586,-3655.5027,-3692.2068,-3804.124,-3989.1257,-4708.5,-4689.2695,-4687.254,-4667.197,-4667.27,-4626.0923,-4546.594,-4513.757,-4462.1406,-4405.3667,-4390.715,-4342.257,-4331.9795,-4405.867,-4516.3564,-4635.1577,-4689.9478,-4698.6553,-4722.3706,-4758.274,-4743.0063,-4711.354,-4716.2656,-4816.197,-4770.2314,-4730.8794,-4758.039,-4730.1943,-4697.98,-4720.5093,-4779.558,-4836.428,-4141.667,-4122.481,-4102.587,-4089.2646,-4091.6711,-4052.3699,-4056.5037,-4102.2124,-4147.3984,-4055.7317,-3883.2268,-3791.191,-3728.2314,-3656.7334,-3641.7388,-3642.2207],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(-45.000000,-45.000000,21825.000000),child1Url=["MarsLOD006.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD006.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars002.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars002.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,-90.000000,0.000000),height=[2289.733,2178.4004,2147.1465,2121.0876,2111.7002,2110.6633,2329.1228,2326.585,2287.324,2294.976,2382.781,2356.2195,2354.309,2401.2554,2474.6233,2538.6326,1880.8734,2004.0479,1784.5782,1450.6862,1387.8131,1289.0175,1323.5759,1241.3486,1279.8722,1433.1101,1483.9667,1548.0249,1608.5817,1657.4397,1643.0021,1744.4773,1433.5204,1006.15515,667.9908,1085.8097,932.2901,946.0716,1054.9594,1024.2715,1195.109,1327.4906,1463.5764,1672.6674,1586.687,1373.0353,1284.8348,1272.5013,1262.0449,1243.732,1192.19,1118.6604,970.9844,985.15894,817.9814,624.31537,1163.9994,1183.5638,1031.6405,1533.0122,1714.1211,1505.3983,1454.6827,1365.7789,1371.6388,985.8905,1005.85876,1055.1384,927.43915,887.8724,588.27795,582.1952,718.2599,607.5702,782.33594,1279.8508,1802.1293,1514.0363,1502.2272,1449.9633,1759.1534,933.4431,952.42786,1506.4127,1693.1477,471.34335,-473.05255,-1710.1816,-1609.02,5.457284,174.93527,405.8907,748.81934,1328.3425,1495.5476,1540.7823,1768.0303,1250.4995,2205.3455,1888.0541,1348.8721,462.22824,-1479.2177,-2796.3123,-2896.3582,-1819.3324,-341.90735,657.0322,701.2431,1213.5723,1279.6449,1239.2399,2547.6416,2782.0854,3027.66,2752.4553,1916.2299,1158.8528,92.565506,-1983.954,-2674.9631,-1480.6454,-56.40891,771.7862,664.32025,1470.6385,1422.1505,1250.8984,4678.967,4123.967,3578.5269,3100.6492,2424.611,2151.8152,1280.1627,69.86045,-640.24426,-222.345,35.0537,433.63138,900.5436,1239.115,1145.2876,1101.4789,3689.0776,3491.713,4335.5103,3455.0483,2630.806,1920.7437,1172.1951,756.9448,643.5115,395.10825,516.0364,322.73404,723.7459,1030.6017,1448.2666,1339.5425,3084.7341,2718.8367,2998.745,3516.538,3042.9438,2028.1923,758.9851,716.34436,615.2969,-77.76545,103.90686,-24.902798,-65.69655,571.13556,1071.3911,1343.0227,3460.9673,2833.311,2607.2705,3248.335,3132.2766,3101.5405,1221.1434,981.5628,856.7789,-24.096708,-1177.2058,-773.58185,-708.07465,-494.39365,-8.883575,632.4607,4276.9443,3519.8755,3061.8523,3396.9136,3634.1824,1883.5825,-469.7183,-2039.2084,-367.91193,-177.16896,-1668.0825,-1277.2555,-1201.2742,-1089.356,-681.1378,-112.86197,4406.957,3495.9814,1541.7687,-1609.7831,1184.1123,1871.7609,1361.3423,-811.28406,-920.2566,-2099.7566,-1673.7253,-1894.0713,-1444.0815,-1307.3635,-1207.5833,-767.9883,3189.8687,3243.6777,1504.2306,1327.0312,2191.0999,2044.2096,1261.5679,31.03372,-299.58942,-2413.1714,-2337.621,-1958.8153,-2025.5706,-1723.0216,-1367.5833,-1103.125,2670.8254,1336.2405,2385.135,2864.446,1519.7821,1111.278,790.1028,-241.2835,-912.50385,-3250.6392,-1871.6682,-2042.9568,-2427.6138,-2030.3018,-1542.5957,-1271.5643],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(45.000000,-45.000000,-57050.000000),child1Url=["MarsLOD009.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD009.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars003.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars003.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,-90.000000,0.000000),height=[2670.8254,1336.2405,2385.135,2864.446,1519.7821,1111.278,790.1028,-241.2835,-912.50385,-3250.6392,-1871.6682,-2042.9568,-2427.6138,-2030.3018,-1542.5957,-1271.5643,1646.039,200.41284,632.042,973.13885,484.81964,246.59625,215.64967,-774.81696,-1762.7521,-2950.8193,-2797.9456,-2410.5781,-2184.518,-2005.464,-1613.9402,-1394.6675,1372.1371,-45.520363,-456.92316,229.24248,-174.85413,-500.7271,-778.78107,-2137.9885,-3047.0122,-3369.1665,-2839.186,-2363.835,-2014.1023,-2012.5671,-1986.5839,-1567.579,766.7283,-134.53539,-555.727,-71.84347,-456.46564,-767.20447,-1858.6212,-3112.7634,-3612.785,-3515.4883,-3109.0469,-2617.967,-2027.4115,-2098.9402,-2058.1418,-1896.7006,780.57654,-2.286545,-495.07535,-366.48523,-845.08234,-1183.3606,-2642.782,-3613.2886,-3835.33,-3760.9695,-3508.355,-3286.6936,-2353.6855,-2173.4485,-2053.197,-2081.0818,816.6324,566.98596,160.60959,-992.98883,-1738.0986,-2083.811,-3329.2964,-3680.0059,-3902.5322,-3912.679,-3845.4934,-3864.3054,-3223.9897,-2681.7195,-2325.5637,-2304.1204,819.26465,773.8541,410.18735,-286.49335,-1175.9857,-1469.2695,-2954.996,-3626.9333,-3854.7559,-4046.1494,-4147.8896,-4116.7295,-4035.247,-3510.4004,-2784.7974,-2563.695,976.7941,715.6259,914.534,448.23355,-896.8491,-1444.8654,-2753.7153,-3680.7512,-3925.3284,-4177.485,-4377.851,-4434.98,-4375.5464,-4188.4224,-3815.1328,-3377.3577,46.3554,838.269,731.5719,31.419376,-936.1293,-1754.8738,-2906.8704,-3853.0208,-4135.295,-4420.776,-4568.06,-4652.72,-4632.22,-4536.497,-4353.718,-4153.0195,-1125.1345,-1415.2789,-2354.009,-2443.9353,-2163.9985,-2940.8696,-3761.3755,-4167.333,-4422.9487,-4612.624,-4694.408,-4773.5127,-4778.874,-4715.5874,-4604.643,-4476.1133,-2284.9539,-3124.4905,-3435.4814,-3668.723,-3808.9666,-4164.291,-4403.358,-4573.967,-4725.5225,-4848.2407,-4905.243,-4929.9976,-4905.75,-4867.6943,-4760.932,-4660.1724,-3262.428,-3577.3252,-3844.9478,-4104.39,-4359.563,-4609.982,-4778.403,-4869.52,-4950.2026,-5011.955,-5065.408,-5058.256,-5027.3457,-4986.252,-4842.1,-4755.345,-3989.1257,-4221.215,-4445.1353,-4681.026,-4880.846,-5002.0396,-5043.55,-5080.9487,-5115.307,-5146.946,-5148.0513,-5131.5977,-5087.5684,-5023.2783,-4842.0195,-4820.8433,-4635.1577,-4779.853,-4884.089,-4928.3174,-4966.493,-5019.4043,-5079.706,-5135.2,-5168.98,-5195.9844,-5179.444,-5132.459,-5060.5337,-5001.69,-4923.678,-4827.8296,-4836.428,-4912.879,-4911.5283,-4957.947,-4954.7476,-5018.1543,-5049.5913,-5087.9927,-5015.243,-4972.823,-4913.4487,-4837.149,-4733.144,-4619.645,-4493.893,-4432.242,-3642.2207,-3709.7651,-3822.8804,-3848.7358,-3826.03,-3921.8125,-4132.796,-4354.836,-4397.505,-4323.9385,-4217.9624,-4122.3926,-4001.077,-3761.594,-3652.6418,-3662.1648],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(-45.000000,45.000000,-100175.000000),child1Url=["MarsLOD012.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD012.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars004.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars004.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,0.000000,0.000000),height=[2538.6326,2594.6196,2783.392,2739.2551,2662.6655,2523.7292,2398.7744,2384.7996,2307.8108,2291.2373,2346.9485,2385.0298,2391.877,2426.138,2415.3237,2254.6672,1744.4773,1881.6846,2159.7637,1986.62,1650.7323,1597.7463,1517.1652,1603.1427,1608.6329,1657.898,1677.5448,1635.8657,1498.1558,1542.5916,1429.9117,1285.2024,1272.5013,1427.2778,1338.6399,1251.4469,1224.1356,1276.4371,1676.636,1860.2178,1653.4423,1494.6826,1498.2084,1578.8138,1667.952,1501.0712,1285.0779,1474.4961,1365.7789,1238.5342,1162.1945,1187.8004,1342.731,1611.7362,1181.8333,1246.4459,1201.1333,901.8897,727.0456,615.8363,517.6251,747.11194,1324.5309,1367.9617,1449.9633,1281.651,1336.6349,1297.3955,1342.439,1355.7039,1325.5573,1065.384,653.38434,571.9356,967.5492,677.48126,79.56487,-70.59237,163.07545,671.675,1540.7823,1455.1061,1462.0809,1542.1184,1779.5024,1635.6058,874.39655,229.3263,-440.9303,-913.9939,-1446.386,-2186.7273,-2663.6455,-2399.1824,-1374.835,-664.6872,1239.2399,1145.0524,1679.9084,1627.706,1729.6003,1327.3667,731.2462,-34.335213,-2072.894,-4348.804,-5591.7827,-5980.1157,-5856.171,-5789.476,-5282.5977,-3671.089,1250.8984,1262.5729,1652.7836,1633.7891,2039.1401,1850.8229,728.2328,193.48358,-3577.6567,-6405.4507,-6709.758,-6633.6934,-6471.8154,-6326.728,-6165.741,-5528.1484,1101.4789,1327.06,1635.3134,1647.1257,2279.5874,2076.6257,1129.9949,373.02155,-3309.6343,-6452.0063,-6821.236,-6822.782,-6555.4927,-6494.161,-5860.6265,-4610.2637,1339.5425,1305.5642,1478.3744,1756.1267,2100.4236,1826.6941,1423.0853,896.8199,-268.4492,-4140.6,-6456.1377,-6730.92,-6519.8066,-5552.9663,-4045.4585,-2691.4302,1343.0227,1305.2544,1461.8611,1723.7628,1458.1652,1399.4601,1571.4424,1367.4088,832.86383,-94.90787,-1660.6173,-2798.533,-3383.6814,-2498.32,-945.6068,-891.7018,632.4607,801.758,1186.8239,1738.299,1714.6375,1942.9047,2348.535,2026.6066,1606.6669,1105.1328,87.89036,-514.4734,-692.79913,-39.222828,623.737,999.6454,-112.86197,469.55646,947.8888,1393.9519,1917.4451,2390.2612,2436.2065,2367.4954,2521.3257,1923.4323,1445.7144,1018.1969,737.63116,784.8406,1905.513,2240.4087,-767.9883,-139.09425,424.16473,1424.5288,1706.1769,2266.273,2421.4797,2464.68,2633.758,2331.7563,1809.7635,1725.679,1643.1827,1205.1835,2056.7283,2524.5376,-1103.125,-530.1606,-214.44623,359.27057,1607.9113,1747.7871,1783.7306,1597.435,2069.8574,2346.5962,2054.8936,2248.1384,2082.1074,1408.7426,1699.3203,1863.0934,-1271.5643,-1000.6175,-427.42145,-116.083,685.20734,1100.0961,985.14264,1018.15845,1802.5851,1943.2504,1740.1011,1955.722,1743.3931,1140.9724,812.05194,289.68726],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(45.000000,45.000000,-72925.000000),child1Url=["MarsLOD015.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD015.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars005.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars005.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,0.000000,0.000000),height=[-1271.5643,-1000.6175,-427.42145,-116.083,685.20734,1100.0961,985.14264,1018.15845,1802.5851,1943.2504,1740.1011,1955.722,1743.3931,1140.9724,812.05194,289.68726,-1394.6675,-1025.0983,-678.6038,-290.6483,54.59117,247.76985,368.5021,973.8471,1524.3761,1631.275,1648.3553,1788.234,1480.2178,360.5593,-2638.843,-3284.6611,-1567.579,-1309.9106,-996.1134,-812.04584,-311.5598,-149.68625,-244.96477,285.9286,746.95483,1317.185,1330.8569,1651.369,1280.8978,-1014.5794,-3843.325,-3805.4155,-1896.7006,-1652.2921,-1549.8123,-1645.3193,-1205.8236,-881.02045,-661.1984,-34.931416,234.20705,806.7182,908.8181,964.02606,543.3376,-1820.5085,-3683.5396,-3678.7747,-2081.0818,-1982.2969,-2026.1089,-1868.395,-1442.9298,-1263.9075,-796.01666,-275.48364,121.25942,386.7207,708.3252,385.54425,413.0466,-595.8325,-2487.1672,-3180.5728,-2304.1204,-2284.63,-2229.8533,-1771.9574,-1594.9159,-1123.8611,-730.27075,-806.44257,-1022.653,-530.6017,184.16946,319.51697,275.10144,-867.7291,-2014.8248,-3215.924,-2563.695,-2337.9912,-2230.2642,-2028.1832,-1769.2217,-1475.4476,-781.5317,-443.5722,-767.7257,-510.4141,-961.154,-976.32245,-1034.7166,-2324.582,-3163.5537,-3677.6392,-3377.3577,-2942.2246,-2594.9702,-2472.0537,-2642.9915,-2036.012,-1422.6615,-914.00385,-847.0075,-874.76483,-2218.171,-2355.7122,-2658.7153,-3092.9692,-3581.6614,-3950.347,-4153.0195,-3954.436,-3527.0947,-3614.071,-3392.613,-3282.3489,-2958.5242,-2342.667,-2145.3713,-2539.4531,-2818.4949,-3142.7134,-3310.5728,-3544.936,-3775.5576,-4150.176,-4476.1133,-4297.465,-4114.001,-3985.4263,-3875.3489,-3845.379,-3499.6184,-3346.5728,-3328.1667,-3306.7905,-3432.4998,-3498.1821,-3588.8198,-3697.3613,-3952.6145,-4305.5415,-4660.1724,-4518.7593,-4364.109,-4229.912,-4070.7393,-3930.948,-3832.0117,-3821.6262,-3828.8315,-3859.7134,-3809.7117,-3688.8777,-3649.9373,-3752.3696,-3969.6836,-4148.2866,-4755.345,-4640.778,-4523.79,-4382.454,-4264.449,-4191.6377,-4133.918,-4153.8813,-4159.155,-4125.9214,-4021.084,-3921.724,-3820.741,-3814.774,-3882.1484,-3990.2805,-4820.8433,-4714.65,-4615.3257,-4524.6294,-4443.705,-4391.6455,-4360.232,-4333.81,-4335.595,-4293.292,-4252.265,-4178.668,-4077.6873,-3995.391,-3934.582,-3938.919,-4827.8296,-4747.5806,-4676.885,-4624.7485,-4553.641,-4523.2007,-4489.686,-4472.766,-4454.9663,-4422.188,-4354.426,-4329.4497,-4274.218,-4234.65,-4180.5747,-4128.2407,-4432.242,-4363.873,-4344.254,-4301.644,-4320.8022,-4363.061,-4402.7866,-4440.6377,-4451.7324,-4427.272,-4377.808,-4372.896,-4392.085,-4355.4526,-4340.4434,-4323.418,-3662.1648,-3488.5085,-3375.6628,-3296.0525,-3245.3127,-3229.4822,-3235.473,-3297.9082,-3382.558,-3427.1477,-3438.1594,-3448.5007,-3471.5188,-3465.076,-3470.5483,-3496.478],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(-45.000000,135.000000,-73350.000000),child1Url=["MarsLOD018.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD018.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars006.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars006.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(-90.000000,90.000000,0.000000),height=[2254.6672,1648.1738,1618.9016,2184.33,2436.6716,2543.594,2537.0532,2498.131,2488.0796,2415.7468,2491.0657,2655.2144,2794.5312,2775.1433,2875.8926,2936.012,1285.2024,1364.8325,1707.8835,1644.6427,1605.7875,1657.0348,1643.4819,1641.8844,2154.7969,2422.852,2481.744,2467.148,2501.9204,2515.444,2484.865,2406.8162,1474.4961,1556.76,1772.054,1727.2708,1404.0781,1148.7262,1447.6595,922.802,1023.7396,1582.1649,1485.51,1577.7775,1528.2268,1292.1542,1437.1755,1637.5282,1367.9617,1984.8871,2038.9696,1911.3214,1750.6167,1617.34,1256.6982,1171.4905,989.2762,962.896,1093.4119,1346.018,1439.8553,1341.1542,1459.1626,1688.6729,671.675,1575.3024,1822.2698,1941.854,1918.3861,2091.5647,1676.712,1398.6416,694.3755,777.84186,1124.7611,1702.7982,1908.6873,1788.1599,1736.0422,1552.8999,-664.6872,228.75688,1100.5093,1585.4231,1823.4917,1725.4299,1197.8448,996.6513,1214.8619,1260.7241,1074.9187,1722.4216,1651.0347,2017.4176,1840.4617,1785.6686,-3671.089,-1231.0658,251.14665,1184.1866,1337.3938,1284.3878,1239.7996,1251.9766,1360.0962,1425.5577,1356.993,1268.5405,1071.1481,1216.2314,1875.8212,1774.7129,-5528.1484,-3617.7358,-1070.3458,-25.936352,887.6423,1012.7724,1103.7041,1547.4645,1917.9636,2255.8813,1386.8041,674.5349,948.9152,1168.7089,1823.6302,1902.8073,-4610.2637,-3439.585,-1163.8468,359.58954,797.70844,660.844,701.6507,1289.2102,1527.9536,1537.518,1544.1282,1057.1526,1059.6738,1188.3223,1212.5204,925.86194,-2691.4302,-2278.7244,-921.51074,759.24097,1151.9062,933.5825,1090.3656,1571.9316,1810.6329,1711.7535,1359.0222,1249.5631,1062.598,915.9562,1013.41205,656.7737,-891.7018,-213.22916,424.4365,1103.4059,1288.2985,1318.7473,1476.0303,2034.5331,2355.5308,2001.0201,1298.1892,1091.551,938.77686,1033.1014,1451.1608,1173.4783,999.6454,2015.4415,1676.935,1800.4049,1517.7704,1544.436,1881.4536,2046.974,1970.7881,2199.7395,1767.1232,1390.0868,1020.4343,630.7082,785.76495,871.1025,2240.4087,2551.3723,1775.6707,1474.5109,1488.3091,1724.7506,1892.4935,1993.3665,1845.6859,1682.2488,1862.0771,1594.6967,984.94824,-586.7179,-816.79114,-533.0118,2524.5376,2179.9446,1591.152,1296.3896,1313.9733,1578.8751,2119.2317,2080.874,1462.6493,1140.2346,870.38477,299.44418,-466.4988,-1541.482,-1929.3683,-1661.8735,1863.0934,1401.5349,1294.5846,651.7594,537.4558,790.3422,1960.225,1446.1177,-470.74634,-1284.0034,-1429.5532,-1881.3925,-2059.1763,-2361.287,-2719.0146,-2239.134,289.68726,352.93964,480.47345,-380.31033,-373.45047,463.13394,552.1293,-982.273,-2258.3928,-2483.518,-2371.3108,-2359.7659,-2526.4397,-2875.236,-2962.952,-2933.2935],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])]),
          Group(
            children=[
            GeoLOD(center=(45.000000,135.000000,-13175.000000),child1Url=["MarsLOD021.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/MarsLOD021.x3d"],range=7.2E7,
              geoOrigin=GeoOrigin(USE='ORIGIN'),
              rootNode=[
              Shape(
                appearance=Appearance(
                  material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
                  texture=ImageTexture(url=["images/Mars007.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/Mars007.jpg"])),
                geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(0.000000,90.000000,0.000000),height=[289.68726,352.93964,480.47345,-380.31033,-373.45047,463.13394,552.1293,-982.273,-2258.3928,-2483.518,-2371.3108,-2359.7659,-2526.4397,-2875.236,-2962.952,-2933.2935,-3284.6611,-2306.9487,-1230.4835,-996.46185,-317.26297,14.418619,-1639.2996,-2112.8792,-2562.5476,-2657.2,-2642.722,-2652.9854,-2668.9097,-2778.7712,-2892.3416,-3003.566,-3805.4155,-3640.997,-2539.771,-1532.5278,-1476.9125,-1961.8754,-2606.8677,-2917.1755,-2808.2754,-2208.5388,-1912.5454,-2177.867,-2306.0225,-2250.235,-2724.0017,-2929.5066,-3678.7747,-3598.1008,-3178.599,-2859.7483,-2870.2134,-3171.4297,-3390.7463,-3483.8513,-2972.5217,-1031.2749,170.9002,-684.38983,-1691.7335,-2123.2932,-2543.0398,-2932.3193,-3180.5728,-3522.5505,-3594.1646,-3699.696,-3799.5513,-3882.2002,-3885.187,-3870.4028,-3385.1685,-235.7639,2363.8528,1060.3192,-1171.1788,-2052.965,-2665.1577,-3038.3638,-3215.924,-3738.2126,-3975.98,-4222.1284,-4415.107,-4417.8457,-4349.104,-4163.3247,-3923.3157,-1535.0339,1431.9498,233.02892,-1445.9639,-2353.3135,-3040.5771,-3358.7292,-3677.6392,-4072.4236,-4423.974,-4657.7617,-4777.4844,-4678.839,-4536.379,-4386.236,-4242.059,-3730.562,-2826.5598,-1852.7017,-2405.6538,-2650.3997,-3460.9387,-3745.378,-3950.347,-4336.4077,-4697.076,-4922.2764,-4962.766,-4903.1274,-4770.5244,-4649.255,-4476.9175,-4221.835,-3931.5894,-3639.4663,-3297.8718,-2862.1887,-3410.59,-3937.22,-4150.176,-4519.535,-4805.867,-4951.9214,-4946.936,-4898.9917,-4878.0073,-4768.6387,-4568.8135,-4224.191,-3903.6396,-3755.4822,-3668.1284,-3231.1682,-3492.8462,-3971.0295,-4305.5415,-4540.032,-4737.367,-4872.871,-4896.6387,-4874.9844,-4838.125,-4673.588,-4472.867,-4223.3525,-4036.3982,-3961.8345,-3897.9038,-3817.7805,-3808.0588,-4022.7593,-4148.2866,-4360.9927,-4473.5107,-4596.912,-4656.352,-4622.521,-4601.4424,-4506.728,-4422.549,-4289.499,-4168.7954,-4082.6326,-4011.273,-3974.329,-4018.1382,-4146.7334,-3990.2805,-4091.156,-4177.154,-4293.998,-4328.4976,-4359.8823,-4391.333,-4392.1577,-4363.608,-4329.0537,-4259.2334,-4168.5786,-4117.3896,-4131.6235,-4170.8457,-4211.167,-3938.919,-3994.7131,-4046.7021,-4117.02,-4163.97,-4203.4233,-4261.03,-4307.8643,-4338.0796,-4363.658,-4353.3154,-4354.337,-4363.8296,-4369.865,-4387.9077,-4399.095,-4128.2407,-4089.8704,-4077.4707,-4092.9897,-4144.4546,-4210.254,-4258.1006,-4309.3804,-4387.1284,-4458.403,-4498.923,-4556.9976,-4584.311,-4569.9126,-4553.1274,-4680.684,-4323.418,-4340.4243,-4346.089,-4356.0034,-4362.757,-4373.3994,-4411.5366,-4450.4565,-4499.677,-4542.767,-4605.5737,-4644.6235,-4661.357,-4676.8013,-4723.1904,-4752.3125,-3496.478,-3533.5073,-3617.9119,-3714.0022,-3899.0125,-4014.0293,-4081.6658,-4163.7134,-4214.6396,-4249.385,-4265.0176,-4297.8604,-4278.2026,-4224.8813,-4233.766,-4197.084],solid=False,xDimension=16,xSpacing=6.000000,yScale=50.0,zDimension=16,zSpacing=6.000000,
                  geoOrigin=GeoOrigin(USE='ORIGIN'),
                  texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.06667,0.00391),(0.13333,0.00391),(0.2,0.00391),(0.26667,0.00391),(0.33333,0.00391),(0.4,0.00391),(0.46667,0.00391),(0.53333,0.00391),(0.6,0.00391),(0.66667,0.00391),(0.73333,0.00391),(0.8,0.00391),(0.86667,0.00391),(0.93333,0.00391),(0.99609,0.00391),(0.00391,0.06667),(0.06667,0.06667),(0.13333,0.06667),(0.2,0.06667),(0.26667,0.06667),(0.33333,0.06667),(0.4,0.06667),(0.46667,0.06667),(0.53333,0.06667),(0.6,0.06667),(0.66667,0.06667),(0.73333,0.06667),(0.8,0.06667),(0.86667,0.06667),(0.93333,0.06667),(0.99609,0.06667),(0.00391,0.13333),(0.06667,0.13333),(0.13333,0.13333),(0.2,0.13333),(0.26667,0.13333),(0.33333,0.13333),(0.4,0.13333),(0.46667,0.13333),(0.53333,0.13333),(0.6,0.13333),(0.66667,0.13333),(0.73333,0.13333),(0.8,0.13333),(0.86667,0.13333),(0.93333,0.13333),(0.99609,0.13333),(0.00391,0.2),(0.06667,0.2),(0.13333,0.2),(0.2,0.2),(0.26667,0.2),(0.33333,0.2),(0.4,0.2),(0.46667,0.2),(0.53333,0.2),(0.6,0.2),(0.66667,0.2),(0.73333,0.2),(0.8,0.2),(0.86667,0.2),(0.93333,0.2),(0.99609,0.2),(0.00391,0.26667),(0.06667,0.26667),(0.13333,0.26667),(0.2,0.26667),(0.26667,0.26667),(0.33333,0.26667),(0.4,0.26667),(0.46667,0.26667),(0.53333,0.26667),(0.6,0.26667),(0.66667,0.26667),(0.73333,0.26667),(0.8,0.26667),(0.86667,0.26667),(0.93333,0.26667),(0.99609,0.26667),(0.00391,0.33333),(0.06667,0.33333),(0.13333,0.33333),(0.2,0.33333),(0.26667,0.33333),(0.33333,0.33333),(0.4,0.33333),(0.46667,0.33333),(0.53333,0.33333),(0.6,0.33333),(0.66667,0.33333),(0.73333,0.33333),(0.8,0.33333),(0.86667,0.33333),(0.93333,0.33333),(0.99609,0.33333),(0.00391,0.4),(0.06667,0.4),(0.13333,0.4),(0.2,0.4),(0.26667,0.4),(0.33333,0.4),(0.4,0.4),(0.46667,0.4),(0.53333,0.4),(0.6,0.4),(0.66667,0.4),(0.73333,0.4),(0.8,0.4),(0.86667,0.4),(0.93333,0.4),(0.99609,0.4),(0.00391,0.46667),(0.06667,0.46667),(0.13333,0.46667),(0.2,0.46667),(0.26667,0.46667),(0.33333,0.46667),(0.4,0.46667),(0.46667,0.46667),(0.53333,0.46667),(0.6,0.46667),(0.66667,0.46667),(0.73333,0.46667),(0.8,0.46667),(0.86667,0.46667),(0.93333,0.46667),(0.99609,0.46667),(0.00391,0.53333),(0.06667,0.53333),(0.13333,0.53333),(0.2,0.53333),(0.26667,0.53333),(0.33333,0.53333),(0.4,0.53333),(0.46667,0.53333),(0.53333,0.53333),(0.6,0.53333),(0.66667,0.53333),(0.73333,0.53333),(0.8,0.53333),(0.86667,0.53333),(0.93333,0.53333),(0.99609,0.53333),(0.00391,0.6),(0.06667,0.6),(0.13333,0.6),(0.2,0.6),(0.26667,0.6),(0.33333,0.6),(0.4,0.6),(0.46667,0.6),(0.53333,0.6),(0.6,0.6),(0.66667,0.6),(0.73333,0.6),(0.8,0.6),(0.86667,0.6),(0.93333,0.6),(0.99609,0.6),(0.00391,0.66667),(0.06667,0.66667),(0.13333,0.66667),(0.2,0.66667),(0.26667,0.66667),(0.33333,0.66667),(0.4,0.66667),(0.46667,0.66667),(0.53333,0.66667),(0.6,0.66667),(0.66667,0.66667),(0.73333,0.66667),(0.8,0.66667),(0.86667,0.66667),(0.93333,0.66667),(0.99609,0.66667),(0.00391,0.73333),(0.06667,0.73333),(0.13333,0.73333),(0.2,0.73333),(0.26667,0.73333),(0.33333,0.73333),(0.4,0.73333),(0.46667,0.73333),(0.53333,0.73333),(0.6,0.73333),(0.66667,0.73333),(0.73333,0.73333),(0.8,0.73333),(0.86667,0.73333),(0.93333,0.73333),(0.99609,0.73333),(0.00391,0.8),(0.06667,0.8),(0.13333,0.8),(0.2,0.8),(0.26667,0.8),(0.33333,0.8),(0.4,0.8),(0.46667,0.8),(0.53333,0.8),(0.6,0.8),(0.66667,0.8),(0.73333,0.8),(0.8,0.8),(0.86667,0.8),(0.93333,0.8),(0.99609,0.8),(0.00391,0.86667),(0.06667,0.86667),(0.13333,0.86667),(0.2,0.86667),(0.26667,0.86667),(0.33333,0.86667),(0.4,0.86667),(0.46667,0.86667),(0.53333,0.86667),(0.6,0.86667),(0.66667,0.86667),(0.73333,0.86667),(0.8,0.86667),(0.86667,0.86667),(0.93333,0.86667),(0.99609,0.86667),(0.00391,0.93333),(0.06667,0.93333),(0.13333,0.93333),(0.2,0.93333),(0.26667,0.93333),(0.33333,0.93333),(0.4,0.93333),(0.46667,0.93333),(0.53333,0.93333),(0.6,0.93333),(0.66667,0.93333),(0.73333,0.93333),(0.8,0.93333),(0.86667,0.93333),(0.93333,0.93333),(0.99609,0.93333),(0.00391,0.99609),(0.06667,0.99609),(0.13333,0.99609),(0.2,0.99609),(0.26667,0.99609),(0.33333,0.99609),(0.4,0.99609),(0.46667,0.99609),(0.53333,0.99609),(0.6,0.99609),(0.66667,0.99609),(0.73333,0.99609),(0.8,0.99609),(0.86667,0.99609),(0.93333,0.99609),(0.99609,0.99609)])))])])])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Mars.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Mars.py load and self-test diagnostics complete.")
