package Basic.Followers;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> X3D Follower example. </p>
 <p> Related links: Catalog page <a href="../../../Followers/TestSlidersIndex.html" target="_blank">TestSliders</a>,  source <a href="../../../Followers/TestSliders.java">TestSliders.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Followers/TestSliders.x3d">TestSliders.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> X3D Follower example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Herbert Stocker </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 18 April 2006 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 December 2011 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/test_Sliders.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Followers/Stocker_06_Followers.pdf">Stocker_06_Followers.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.hersto.com/Publications/Followers" target="_blank">http://www.hersto.com/Publications/Followers</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> requires </i> </td>
			<td> X3D version 3.2 or greater </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D Follower Chaser Damper </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> under development </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Followers/TestSliders.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Followers/TestSliders.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Followers/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Herbert Stocker
 */

public class TestSliders
{
	/** Default constructor to create this object. */
	public TestSliders ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("TestSliders.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("X3D Follower example"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Herbert Stocker"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("18 April 2006"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 December 2011"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/test_Sliders.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Stocker_06_Followers.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.hersto.com/Publications/Followers"))
    .addMeta(new meta().setName(meta.NAME_REQUIRES   ).setContent("X3D version 3.2 or greater"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D Follower Chaser Damper"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("under development"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Followers/TestSliders.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("TestSliders.x3d"))
    .addChild(new ExternProtoDeclare("Slider").setName("Slider").setUrl(new String[] {"Slider.x3d#Slider","https://www.web3d.org/x3d/content/examples/Basic/Followers/Slider.x3d#Slider","Slider.wrl#Slider","https://www.web3d.org/x3d/content/examples/Basic/Followers/Slider.wrl#Slider"})
      .addField(new field().setName("initial_position").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("radiusKnob").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("radiusStick").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("min").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("position_changed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("appearance").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("smoothMovements").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("set_position").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("pageSize").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("max").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("height").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
    .addChild(new NavigationInfo().setType("\"EXAMINE\""))
    .addChild(new Viewpoint().setDescription("view 1").setOrientation(-0.527,0.846,0.075,0.462).setPosition(2.741,3.259,6.6))
    .addChild(new Viewpoint().setDescription("view 2").setOrientation(0.973,0.232,0.024,0.466).setPosition(0.865,-1.591,6.723))
    .addChild(new Viewpoint().setDescription("view 3").setOrientation(0.997,0.06,0.05,1.705).setPosition(0.934,-5.744,-0.794))
    .addChild(new Viewpoint().setDescription("view 4").setOrientation(0.888,0.23,0.399,3.139).setPosition(5.165,3.009,-4.663))
    .addChild(new Viewpoint().setDescription("view 5").setOrientation(0.116,0.234,-0.965,1.866).setPosition(0.424,-2.489,8.627))
    .addChild(new Viewpoint().setDescription("view 6").setOrientation(-0.3,0.639,-0.708,1.922).setPosition(6.309,-1.261,2.853))
    .addChild(new Transform()
      .addChild(new Transform().setRotation(0.983,0.152,0.098,0.286)
        .addChild(new Transform().setRotation(0.705,0.654,-0.274,-1.09)
          .addChild(new Transform().setRotation(0.0,0.0,-1.0,1.5708).setTranslation(2.5,0.0,0.0)
            .addChild(new ProtoInstance("Slider", "SldX").setContainerField("children")
              .addFieldValue(new fieldValue().setName("initial_position").setValue(2.5))
              .addFieldValue(new fieldValue().setName("radiusKnob").setValue(0.225))
              .addFieldValue(new fieldValue().setName("min").setValue(1.0))
              .addFieldValue(new fieldValue().setName("radiusStick").setValue(0.15))
              .addFieldValue(new fieldValue().setName("appearance")
                .addChild(new Appearance("App")
                  .setMaterial(new Material().setAmbientIntensity(0.055).setDiffuseColor(0.75,0.0,0.55).setEmissiveColor(0.1,0.0,0.07).setShininess(0.157).setSpecularColor(0.67,0.67,0.67))))
              .addFieldValue(new fieldValue().setName("pageSize").setValue(1.0))
              .addFieldValue(new fieldValue().setName("max").setValue(5.0)))
            .addChild(new Transform().setTranslation(0.0,-1.25,0.0)
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("App"))
                .setGeometry(new Cylinder().setHeight(2.5).setRadius(0.02)))))
          .addChild(new Transform().setTranslation(0.0,2.5,0.0)
            .addChild(new ProtoInstance("Slider", "SldY").setContainerField("children")
              .addFieldValue(new fieldValue().setName("initial_position").setValue(2.5))
              .addFieldValue(new fieldValue().setName("radiusKnob").setValue(0.225))
              .addFieldValue(new fieldValue().setName("min").setValue(1.0))
              .addFieldValue(new fieldValue().setName("radiusStick").setValue(0.15))
              .addFieldValue(new fieldValue().setName("appearance")
                .addChild(new Appearance().setUSE("App")))
              .addFieldValue(new fieldValue().setName("pageSize").setValue(1.0))
              .addFieldValue(new fieldValue().setName("max").setValue(5.0)))
            .addChild(new Transform().setTranslation(0.0,-1.25,0.0)
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("App"))
                .setGeometry(new Cylinder().setHeight(2.5).setRadius(0.02)))))
          .addChild(new Transform().setRotation(1.0,0.0,0.0,1.5708).setTranslation(0.0,0.0,2.5)
            .addChild(new ProtoInstance("Slider", "SldZ").setContainerField("children")
              .addFieldValue(new fieldValue().setName("initial_position").setValue(2.5))
              .addFieldValue(new fieldValue().setName("radiusKnob").setValue(0.225))
              .addFieldValue(new fieldValue().setName("min").setValue(1.0))
              .addFieldValue(new fieldValue().setName("radiusStick").setValue(0.15))
              .addFieldValue(new fieldValue().setName("appearance")
                .addChild(new Appearance().setUSE("App")))
              .addFieldValue(new fieldValue().setName("pageSize").setValue(1.0))
              .addFieldValue(new fieldValue().setName("max").setValue(5.0)))
            .addChild(new Transform().setTranslation(0.0,-1.25,0.0)
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("App"))
                .setGeometry(new Cylinder().setHeight(2.5).setRadius(0.02))))))))
    .addChild(new Transform().setRotation(0.983,0.152,0.098,0.286)
      .addChild(new Transform().setRotation(0.705,0.654,-0.274,-1.09)
        .addChild(new Transform("Trans")
          .addChild(new TouchSensor("TchBox").setDescription("touch to activate"))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setAmbientIntensity(0.0933).setDiffuseColor(0.37,0.0,0.75).setEmissiveColor(0.05,0.0,0.1).setShininess(0.41).setSpecularColor(0.91,0.91,0.91)))
            .setGeometry(new Box().setSize(0.3,0.3,0.3))))))
    .addChild(new Script("Worker").setSourceCode("""
ecmascript:

function set_X(x) { Pos.x= x; }
function set_Y(y) { Pos.y= y; }
function set_Z(z) { Pos.z= z; }

function eventsProcessed()
{
    Pos_changed= Pos;
}
""")
      .addField(new field().setName("set_Z").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("set_Y").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("set_X").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("Pos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(1.0,1.0,1.0)))
      .addField(new field().setName("Pos_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
    .addChild(new ROUTE().setFromNode("SldX").setFromField("position_changed").setToNode("Worker").setToField("set_X"))
    .addChild(new ROUTE().setFromNode("SldY").setFromField("position_changed").setToNode("Worker").setToField("set_Y"))
    .addChild(new ROUTE().setFromNode("SldZ").setFromField("position_changed").setToNode("Worker").setToField("set_Z"))
    .addChild(new ROUTE().setFromNode("Worker").setFromField("Pos_changed").setToNode("Trans").setToField("scale"))
    .addChild(new Script("SmoothWorker").setSourceCode("""
ecmascript:

function initialize()
{
    SmoothMovements= true;
}

function Box_touched(now)
{
    SmoothMovements= !SmoothMovements;
}
""")
      .addField(new field().setName("SmoothMovements").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("Box_touched").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new ROUTE().setFromNode("TchBox").setFromField("touchTime").setToNode("SmoothWorker").setToField("Box_touched")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return TestSliders model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new TestSliders().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Followers.TestSliders\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Followers.TestSliders self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Followers/TestSliders_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Followers/TestSliders_JavaExport.x3d"; 
                String filenameX3DV = "Followers/TestSliders_JavaExport.x3dv"; 
                String filenameJSON = "Followers/TestSliders_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
