package Basic.Followers;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Followers.*;
import org.web3d.x3d.jsail.Geometry2D.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> X3D Follower example. </p>
 <p> Related links: Catalog page <a href="../../../Followers/TestPosition2DFollowerIndex.html" target="_blank">TestPosition2DFollower</a>,  source <a href="../../../Followers/TestPosition2DFollower.java">TestPosition2DFollower.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Followers/TestPosition2DFollower.x3d">TestPosition2DFollower.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> X3D Follower example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Herbert Stocker </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 18 April 2006 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 December 2011 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 December 2024 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/test_Pos2DFollower.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Followers/Stocker_06_Followers.pdf">Stocker_06_Followers.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.hersto.com/Publications/Followers" target="_blank">http://www.hersto.com/Publications/Followers</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> requires </i> </td>
			<td> X3D version 3.2 or greater </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D Follower Chaser Damper </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> under development, instantReality works but BS Contact fails silently </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html" target="_blank">https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Followers/TestPosition2DFollower.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Followers/TestPosition2DFollower.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Followers/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Herbert Stocker
 */

public class TestPosition2DFollower
{
	/** Default constructor to create this object. */
	public TestPosition2DFollower ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("TestPosition2DFollower.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("X3D Follower example"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Herbert Stocker"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("18 April 2006"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 December 2011"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 December 2024"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/test_Pos2DFollower.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Stocker_06_Followers.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.hersto.com/Publications/Followers"))
    .addMeta(new meta().setName(meta.NAME_REQUIRES   ).setContent("X3D version 3.2 or greater"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D Follower Chaser Damper"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("under development, instantReality works but BS Contact fails silently"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Followers/TestPosition2DFollower.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("TestPosition2DFollower.x3d"))
    .addChild(new Viewpoint().setFieldOfView(0.716).setPosition(0.0,0.0,15.0))
    .addChild(new NavigationInfo().setType("\"NONE\""))
    .addChild(new Group()
      .addChild(new TouchSensor("PositionTouchSensor").setDescription("move ball to demonstrate PositionChaser2D, PositionDamper2D"))
      .addChild(new Transform().setTranslation(0.0,0.0,-0.05)
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.0,0.0,0.0).setEmissiveColor(0.28,0.27,0.24)))
          .setGeometry(new Box().setSize(10.0,10.0,0.1)))))
    .addChild(new Transform("TrObjectDirect").setScale(0.8,0.8,0.8)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.0333).setDiffuseColor(0.02,0.24,0.53).setEmissiveColor(0.01,0.12,0.27).setShininess(0.54).setSpecularColor(0.32,0.4,0.4)))
        .setGeometry(new Sphere("GeomObject").setRadius(0.3))))
    .addChild(new Script("ScrTexCoordTo3D").setSourceCode("""
ecmascript:

function A_in(a)   { A_ot= (new SFVec3f(a.x, a.y, 0)).multiply(10).subtract(new SFVec3f(5, 5, 0)); }
function B_in(b)   { B_ot= (new SFVec3f(b.x, b.y, 0)).multiply(10).subtract(new SFVec3f(5, 5, 0)); }
function C_in(c)   { C_ot= (new SFVec3f(c.x, c.y, 0)).multiply(10).subtract(new SFVec3f(5, 5, 0)); }
""")
      .addField(new field().setName("A_ot").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("B_in").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("A_in").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("C_ot").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("B_ot").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("C_in").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new ROUTE().setFromNode("PositionTouchSensor").setFromField("hitTexCoord_changed").setToNode("ScrTexCoordTo3D").setToField("A_in"))
    .addChild(new ROUTE().setFromNode("ScrTexCoordTo3D").setFromField("A_ot").setToNode("TrObjectDirect").setToField("translation"))
    .addChild(new Switch("SwObjectDampered").setWhichChoice(0)
      .addChild(new Transform("TrObjectDampered")
        .addChild(new Shape()
          .setAppearance(new Appearance("AppObjectDampered")
            .setMaterial(new Material().setAmbientIntensity(0.0333).setDiffuseColor(0.53,0.02,0.24).setEmissiveColor(0.27,0.01,0.12).setShininess(0.54).setSpecularColor(0.4,0.32,0.4)))
          .setGeometry(new Sphere().setUSE("GeomObject")))))
    .addChild(new PositionDamper2D("PositionDamper2DNode"))
    .addChild(new ROUTE().setFromNode("PositionTouchSensor").setFromField("hitTexCoord_changed").setToNode("PositionDamper2DNode").setToField("set_destination"))
    .addChild(new ROUTE().setFromNode("PositionDamper2DNode").setFromField("value_changed").setToNode("ScrTexCoordTo3D").setToField("B_in"))
    .addChild(new ROUTE().setFromNode("ScrTexCoordTo3D").setFromField("B_ot").setToNode("TrObjectDampered").setToField("translation"))
    .addChild(new Switch("SwObjectFollowed").setWhichChoice(0)
      .addChild(new Transform("TrObjectFollowed")
        .addChild(new Shape()
          .setAppearance(new Appearance("AppObjectFollowed")
            .setMaterial(new Material().setAmbientIntensity(0.0333).setDiffuseColor(0.24,0.53,0.02).setEmissiveColor(0.12,0.27,0.01).setShininess(0.54).setSpecularColor(0.4,0.4,0.32)))
          .setGeometry(new Sphere().setUSE("GeomObject")))))
    .addChild(new PositionChaser2D("PositionChaser2DNode").setDuration(1.5))
    .addChild(new ROUTE().setFromNode("PositionTouchSensor").setFromField("hitTexCoord_changed").setToNode("PositionChaser2DNode").setToField("set_destination"))
    .addChild(new ROUTE().setFromNode("PositionChaser2DNode").setFromField("value_changed").setToNode("ScrTexCoordTo3D").setToField("C_in"))
    .addChild(new ROUTE().setFromNode("ScrTexCoordTo3D").setFromField("C_ot").setToNode("TrObjectFollowed").setToField("translation"))
    .addChild(new ProtoDeclare("ToggleButton").setName("ToggleButton")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("HottColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFColor(0.8,0.8,0.3)))
        .addField(new field().setName("initiallyOn").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("ColdColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFColor(0.2,0.2,0.0)))
        .addField(new field().setName("isOn").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform().setScale(0.4,0.4,0.4)
          .addChild(new TouchSensor("Touch").setDescription("touch to activate"))
          .addChild(new Shape("ShRect")
            .setAppearance(new Appearance()
              .setMaterial(new Material("Mat").setAmbientIntensity(0.04).setDiffuseColor(0.0,0.0,0.0).setShininess(0.11)))
            .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,3,-1})
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.0,-1.0,0.0,1.0,-1.0,0.0,1.0,1.0,0.0,-1.0,1.0,0.0}))))))
        .addChild(new Script("ScrToggleButton").setSourceCode("""
ecmascript:

function DamperSThere()
{
    activate(initiallyOn);
}

function activate(a)
{
    isOn= a;
    Tau=  a? .1 : .2;
    Color= a? HottColor : ColdColor;
}

function set_id(i)
{
    id= i;
}

function TS_Touched()
{
    activate(!isOn);
}
""")
          .addField(new field().setName("TS_Touched").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("Color").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("isOn").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("ColdColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("Tau").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("initiallyOn").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("DamperSThere").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("HottColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("isOn").setProtoField("isOn"))
            .addConnect(new connect().setNodeField("ColdColor").setProtoField("ColdColor"))
            .addConnect(new connect().setNodeField("initiallyOn").setProtoField("initiallyOn"))
            .addConnect(new connect().setNodeField("HottColor").setProtoField("HottColor"))))
        .addChild(new ColorDamper("ColorDamperNode").setOrder(1))
        .addChild(new ROUTE().setFromNode("ScrToggleButton").setFromField("Tau").setToNode("ColorDamperNode").setToField("tau"))
        .addChild(new ROUTE().setFromNode("ScrToggleButton").setFromField("Color").setToNode("ColorDamperNode").setToField("set_destination"))
        .addChild(new Group()
          .addComments(" ======= ROUTE Trace ============================================== ")
          .addChild(new Script("Trace_ROUTE_ScrToggleButton_Tau_TO_Damp_tau").setMustEvaluate(true).setSourceCode("""
ecmascript:
    function traceValue (eventValue, timeStamp) {
      // input eventValue received for trace field
      if (timeStamp - timeStampPreviousReport >= reportInterval) {
        Browser.println ('Trace_ROUTE_ScrToggleButton_Tau_TO_Damp_tau type=SFFloat value=' + eventValue);
        timeStampPreviousReport = timeStamp;
      }
    }
    function timeOfDay (someTime) {
      hh = Math.floor (someTime /(60*60)) % 24;
      mm = Math.floor (someTime / 60)     % 60;
      ss = Math.floor (someTime)          % 60;
      if (hh < 9) hour   = '0' + hh;
      else        hour   =       hh;
      if (mm < 9) minute = '0' + mm;
      else        minute =       mm;
      if (ss < 9) second = '0' + ss;
      else        second =       ss;
      return '(' + hour + ':' + minute + ':' + second + ' GMT)';
    }
""")
            .addComments(" Trace ROUTEd values on X3D browser console ")
            .addField(new field().setName("reportInterval").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0).setAppinfo("Sampling frequency in seconds (0 means all values)"))
            .addField(new field().setName("traceValue").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
            .addField(new field().setName("timeStampPreviousReport").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(-1)))
          .addChild(new ROUTE().setFromNode("ScrToggleButton").setFromField("Tau").setToNode("Trace_ROUTE_ScrToggleButton_Tau_TO_Damp_tau").setToField("traceValue"))
          .addComments(" ======= ROUTE Trace block complete ===================================================== "))))
    .addChild(new Transform().setTranslation(-5.7,4.0,0.0)
      .addChild(new ProtoInstance("ToggleButton", "BtnDamper").setContainerField("children")
        .addFieldValue(new fieldValue().setName("HottColor").setValue(new SFColor(0.8,0.03,0.36)))
        .addFieldValue(new fieldValue().setName("initiallyOn").setValue(true))
        .addFieldValue(new fieldValue().setName("ColdColor").setValue(new SFColor(0.2,0.0080,0.09)))))
    .addChild(new Transform().setTranslation(-8.0,3.9,0.0)
      .addChild(new Shape()
        .setAppearance(new Appearance("AppLabels")
          .setMaterial(new Material().setDiffuseColor(0.0,0.0,0.0).setEmissiveColor(0.8,0.8,0.8)))
        .setGeometry(new Text().setString(new String[] {"Damper"})
          .setFontStyle(new FontStyle("FntLabels").setFamily(new String[] {"Arial","SANS"}).setSize(0.5)))))
    .addChild(new Transform().setTranslation(-5.7,2.8,0.0)
      .addChild(new ProtoInstance("ToggleButton", "BtnChaser").setContainerField("children")
        .addFieldValue(new fieldValue().setName("HottColor").setValue(new SFColor(0.36,0.8,0.03)))
        .addFieldValue(new fieldValue().setName("initiallyOn").setValue(true))
        .addFieldValue(new fieldValue().setName("ColdColor").setValue(new SFColor(0.09,0.2,0.0080)))))
    .addChild(new Transform().setTranslation(-8.0,2.7,0.0)
      .addChild(new Shape()
        .setAppearance(new Appearance().setUSE("AppLabels"))
        .setGeometry(new Text().setString(new String[] {"Chaser"})
          .setFontStyle(new FontStyle().setUSE("FntLabels")))))
    .addChild(new Script("ScrBtnMgr").setSourceCode("""
ecmascript:

function BtnDamperIsOn(on)
{
    WcDamper= on? 0:-1;
}

function BtnChaserIsOn(on)
{
    WcChaser= on? 0:-1;
}
""")
      .addField(new field().setName("BtnChaserIsOn").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("WcDamper").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("WcChaser").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("BtnDamperIsOn").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new ROUTE().setFromNode("BtnDamper").setFromField("isOn").setToNode("ScrBtnMgr").setToField("BtnDamperIsOn"))
    .addChild(new ROUTE().setFromNode("BtnChaser").setFromField("isOn").setToNode("ScrBtnMgr").setToField("BtnChaserIsOn"))
    .addChild(new ROUTE().setFromNode("ScrBtnMgr").setFromField("WcDamper").setToNode("SwObjectDampered").setToField("whichChoice"))
    .addChild(new ROUTE().setFromNode("ScrBtnMgr").setFromField("WcChaser").setToNode("SwObjectFollowed").setToField("whichChoice"))
    .addChild(new Switch("SwDamperTrail").setWhichChoice(0)
      .addChild(new Group("GrDamperTrail")))
    .addChild(new Switch("SwChaserTrail").setWhichChoice(0)
      .addChild(new Group("GrChaserTrail")))
    .addChild(new TimeSensor("TmrTrail").setCycleInterval(0.020000000000000004).setLoop(true))
    .addChild(new Script("ScrTrailer").setDirectOutput(true).setSourceCode("""
ecmascript:

function initialize()
{
    DamperTrails.length=
    ChaserTrails.length= cNumTrailPoints;

    for(var C= 0; C<cNumTrailPoints; C++ )
    {
        DamperTrails[C]= new SFNode('Transform{}');
        ChaserTrails[C]= new SFNode('Transform{}');

        DamperTrails[C].children[0]= cShapeDamperTrailPoint;
        ChaserTrails[C].children[0]= cShapeChaserTrailPoint;
    }

    GrDamperTrail.children= DamperTrails;
    GrChaserTrail.children= ChaserTrails;
}

function DamperPos(Pos)
{
    lastDamperPos= Pos;
}

function ChaserPos(Pos)
{
    lastChaserPos= Pos;
}

function Tick()
{
    for(var C= cNumTrailPoints - 1; C>0; C-- )
    {
        DamperTrails[C].translation= DamperTrails[  C - 1].translation;
        ChaserTrails[C].translation= ChaserTrails[C - 1].translation;
    }

    DamperTrails[0].translation= lastDamperPos;
    ChaserTrails[0].translation= lastChaserPos;
}
""")
      .addField(new field().setName("cShapeDamperTrailPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new Shape()
          .setAppearance(new Appearance().setUSE("AppObjectDampered"))
          .setGeometry(new Sphere("GeomTrail").setRadius(0.1))))
      .addField(new field().setName("lastDamperPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
      .addField(new field().setName("ChaserTrails").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addComments(" no initialization nodes since this is a local field to hold content "))
      .addField(new field().setName("cShapeChaserTrailPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new Shape()
          .setAppearance(new Appearance().setUSE("AppObjectFollowed"))
          .setGeometry(new Sphere().setUSE("GeomTrail"))))
      .addField(new field().setName("DamperTrails").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addComments(" no initialization nodes since this is a local field to hold content "))
      .addField(new field().setName("GrChaserTrail").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new Group().setUSE("GrChaserTrail")))
      .addField(new field().setName("ChaserPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("cNumTrailPoints").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(35))
      .addField(new field().setName("lastChaserPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
      .addField(new field().setName("Tick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("DamperPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("GrDamperTrail").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new Group().setUSE("GrDamperTrail"))))
    .addChild(new ROUTE().setFromNode("TmrTrail").setFromField("cycleTime").setToNode("ScrTrailer").setToField("Tick"))
    .addChild(new ROUTE().setFromNode("TrObjectDampered").setFromField("translation").setToNode("ScrTrailer").setToField("DamperPos"))
    .addChild(new ROUTE().setFromNode("TrObjectFollowed").setFromField("translation").setToNode("ScrTrailer").setToField("ChaserPos"))
    .addChild(new ROUTE().setFromNode("ScrBtnMgr").setFromField("WcDamper").setToNode("SwDamperTrail").setToField("whichChoice"))
    .addChild(new ROUTE().setFromNode("ScrBtnMgr").setFromField("WcChaser").setToNode("SwChaserTrail").setToField("whichChoice")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return TestPosition2DFollower model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new TestPosition2DFollower().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Followers.TestPosition2DFollower\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Followers.TestPosition2DFollower self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Followers/TestPosition2DFollower_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Followers/TestPosition2DFollower_JavaExport.x3d"; 
                String filenameX3DV = "Followers/TestPosition2DFollower_JavaExport.x3dv"; 
                String filenameJSON = "Followers/TestPosition2DFollower_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
