package Basic.Followers;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Followers.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> X3D Follower example. </p>
 <p> Related links: Catalog page <a href="../../../Followers/RoomDesiredIndex.html" target="_blank">RoomDesired</a>,  source <a href="../../../Followers/RoomDesired.java">RoomDesired.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Followers/RoomDesired.x3d">RoomDesired.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> X3D Follower example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Herbert Stocker </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 18 April 2006 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 December 2011 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 December 2024 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/room-desired.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Followers/Stocker_06_Followers.pdf">Stocker_06_Followers.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.hersto.com/Publications/Followers" target="_blank">http://www.hersto.com/Publications/Followers</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> requires </i> </td>
			<td> X3D version 3.2 or greater </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D Follower Chaser Damper </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> under development </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html" target="_blank">https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Followers/RoomDesired.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Followers/RoomDesired.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Followers/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Herbert Stocker
 */

public class RoomDesired
{
	/** Default constructor to create this object. */
	public RoomDesired ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("RoomDesired.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("X3D Follower example"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Herbert Stocker"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("18 April 2006"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 December 2011"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 December 2024"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/room-desired.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Stocker_06_Followers.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.hersto.com/Publications/Followers"))
    .addMeta(new meta().setName(meta.NAME_REQUIRES   ).setContent("X3D version 3.2 or greater"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D Follower Chaser Damper"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("under development"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Followers/RoomDesired.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("RoomDesired.x3d"))
    .addChild(new ExternProtoDeclare("Selection").setName("Selection").setUrl(new String[] {"originals/bitmanagement-nodes.x3d#Selection","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/bitmanagement-nodes.x3d#Selection","originals/bitmanagement-nodes.wrl#Selection","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/bitmanagement-nodes.wrl#Selection"})
      .addComments(" \"urn:inet:blaxxun.com:node:Selection\" ")
      .addField(new field().setName("select").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("addChildren").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("bboxCenter").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("removeChildren").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("children").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("proxy").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("bboxSize").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("collide").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {0.1,0.2,0.3})))
    .addChild(new Viewpoint().setDescription("inside").setFieldOfView(0.785).setOrientation(-1.0,-0.0,0.0,0.105).setPosition(-0.0,1.7,7.985))
    .addChild(new Viewpoint().setDescription("outside").setFieldOfView(0.785).setOrientation(-1.0,0.0,0.0,0.105).setPosition(0.0,2.068,13.879))
    .addChild(new NavigationInfo().setAvatarSize(new double[] {0.25,1.2,0.75}).setHeadlight(false))
    .addChild(new DirectionalLight().setIntensity(0.5))
    .addChild(new PointLight().setLocation(2.5,1.0,0.0).setRadius(20.0))
    .addChild(new DirectionalLight().setDirection(0.0,-1.0,0.0))
    .addChild(new DirectionalLight().setIntensity(0.5))
    .addChild(new Group()
      .addChild(new TouchSensor("TouchFloor").setDescription("Touch to move picture here"))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setTextureTransform(new TextureTransform().setScale(17.0,17.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"floor.png","https://www.web3d.org/x3d/content/examples/Basic/Followers/floor.png"})))
        .setGeometry(new Box().setSize(10.0,0.1,10.0))))
    .addChild(new Group()
      .addChild(new TouchSensor("TouchWallFront").setDescription("Touch to move picture here"))
      .addChild(new Transform().setTranslation(0.0,1.5,-5.0)
        .addChild(new Shape("ShWall")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.0567).setDiffuseColor(0.52,0.51,0.45).setEmissiveColor(0.28,0.27,0.24).setShininess(0.53).setSpecularColor(0.76,0.78,0.54)))
          .setGeometry(new Box().setSize(10.0,3.0,0.1)))))
    .addChild(new Group()
      .addChild(new TouchSensor("TouchWallLeft").setDescription("Touch to move picture here"))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.571).setTranslation(-5.0,1.5,0.0)
        .addChild(new Shape().setUSE("ShWall"))))
    .addChild(new Group()
      .addChild(new TouchSensor("TouchWallRight").setDescription("Touch to move picture here"))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.571).setTranslation(5.0,1.5,0.0)
        .addChild(new Shape().setUSE("ShWall"))))
    .addChild(new Group()
      .addChild(new TouchSensor("TouchRoof").setDescription("Touch to move picture here"))
      .addChild(new Transform().setTranslation(0.0,3.0,0.0)
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.0567).setDiffuseColor(0.522,0.451,0.447).setEmissiveColor(0.306,0.235,0.176).setShininess(0.53).setSpecularColor(0.761,0.541,0.584)))
          .setGeometry(new Box().setSize(10.0,0.1,10.0)))))
    .addChild(new ProtoInstance("Selection").setContainerField("children")
      .addFieldValue(new fieldValue().setName("select").setValue(false))
      .addFieldValue(new fieldValue().setName("children")
        .addChild(new Transform("TransInd").setScale(3.5,3.0,3.0)
          .addChild(new Transform().setScale(0.223,0.341,0.5)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setTexture(new ImageTexture().setUrl(new String[] {"Photo.jpg","https://www.web3d.org/x3d/content/examples/Basic/Followers/Photo.jpg"})))
              .setGeometry(new IndexedFaceSet().setSolid(false).setCoordIndex(new int[] {0,1,2,3,-1,4,5,6,7,-1,4,0,3,7,-1,5,1,0,4,-1,6,2,1,5,-1,7,3,2,6,-1}).setTexCoordIndex(new int[] {0,1,2,3,-1,0,0,0,0,-1,0,0,0,0,-1,0,0,0,0,-1,0,0,0,0,-1,0,0,0,0,-1})
                .setTexCoord(new TextureCoordinate("SquareTextureCoordinatePoints").setPoint(new MFVec2f(new double[] {0.0,0.0,1.0,0.0,1.0,1.0,0.0,1.0})))
                .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.0,-1.0,0.03,1.0,-1.0,0.03,1.0,1.0,0.03,-1.0,1.0,0.03,-1.0,-1.0,0.0,1.0,-1.0,0.0,1.0,1.0,0.0,-1.0,1.0,0.0})))))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setTexture(new ImageTexture().setUrl(new String[] {"Shadow.png","https://www.web3d.org/x3d/content/examples/Basic/Followers/Shadow.png"})))
              .setGeometry(new IndexedFaceSet().setCoordIndex(new int[] {0,1,2,3,-1})
                .setTexCoord(new TextureCoordinate().setUSE("SquareTextureCoordinatePoints"))
                .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.15,-1.15,0.01,1.15,-1.15,0.01,1.15,1.15,0.01,-1.15,1.15,0.01})))))))))
    .addChild(new Script("Worker").setSourceCode("""
ecmascript:

function set_hitPoint(hp)
{
    lastHitPoint= hp;
}

function touchedFloor(t)
{
    indPos= CheckGroundRoof(lastHitPoint);
    indOri= new SFRotation(-1, 0, 0, 1.571);
}

function touchedWallLeft(t)
{
    indPos= CheckLeftRightWall(CheckHeight(lastHitPoint));
    indOri= new SFRotation(0, 1, 0, 1.5705);
}

function touchedWallRight(t)
{
    indPos= CheckLeftRightWall(CheckHeight(lastHitPoint));
    indOri= new SFRotation(0, -1, 0, 1.5705);
}

function touchedWallFront(t)
{
    indPos= CheckFrontWall(CheckHeight(lastHitPoint));
    indOri= new SFRotation(0, 1, 0, 0);
}

function touchedRoof(t)
{
    indPos= CheckGroundRoof(lastHitPoint);
    indOri= (new SFRotation(1, 0, 0, 1.57));//.multiply(new SFRotation(0, 1, 0, 3.14159));
}

function CheckGroundRoof(pos)
{
return new SFVec3f( Limit(pos.x, -cRoomWidth/2 + cPaintingWidth/2, cRoomWidth/2 - cPaintingWidth/2)
                  , pos.y
                  , Limit(pos.z, -cRoomDepth/2 + cPaintingHeight/2, cRoomDepth/2 - cPaintingHeight/2)
                  );
}

function CheckHeight(pos)
{
    return new SFVec3f( pos.x
                  , Limit(pos.y, cFloorY + cPaintingHeight/2, cFloorY + cRoomHeight - cPaintingHeight/2)
                  , pos.z
                  );
}

function CheckLeftRightWall(pos)
{
    return new SFVec3f( pos.x
                      , pos.y
                      , Limit(pos.z, -cRoomDepth/2 + cPaintingWidth/2, cRoomDepth/2 - cPaintingWidth/2)
                      );
}

function CheckFrontWall(pos)
{
    return new SFVec3f( Limit(pos.x, -cRoomWidth/2 + cPaintingWidth/2, cRoomWidth/2 - cPaintingWidth/2)
                      , pos.y
                      , pos.z
                      );
}
function Limit(x, min, max)
{
    return Min(Max(x, min), max);
}

function Max(a, b)
{
    return a > b? a:b;
}

function Min(a, b)
{
    return a > b? b:a;
}
""")
      .addField(new field().setName("set_hitPoint").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("touchedWallLeft").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("indPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("touchedWallRight").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("cRoomDepth").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(9.9))
      .addField(new field().setName("cPaintingWidth").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.561))
      .addField(new field().setName("cFloorY").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.05))
      .addField(new field().setName("cPaintingHeight").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(2.046))
      .addField(new field().setName("touchedWallFront").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("touchedFloor").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("touchedRoof").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("indOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("cRoomHeight").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(2.9))
      .addField(new field().setName("cRoomWidth").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(9.9))
      .addField(new field().setName("lastHitPoint").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0))))
    .addChild(new ROUTE().setFromNode("TouchFloor").setFromField("hitPoint_changed").setToNode("Worker").setToField("set_hitPoint"))
    .addChild(new ROUTE().setFromNode("TouchWallLeft").setFromField("hitPoint_changed").setToNode("Worker").setToField("set_hitPoint"))
    .addChild(new ROUTE().setFromNode("TouchWallRight").setFromField("hitPoint_changed").setToNode("Worker").setToField("set_hitPoint"))
    .addChild(new ROUTE().setFromNode("TouchWallFront").setFromField("hitPoint_changed").setToNode("Worker").setToField("set_hitPoint"))
    .addChild(new ROUTE().setFromNode("TouchRoof").setFromField("hitPoint_changed").setToNode("Worker").setToField("set_hitPoint"))
    .addChild(new ROUTE().setFromNode("TouchFloor").setFromField("touchTime").setToNode("Worker").setToField("touchedFloor"))
    .addChild(new ROUTE().setFromNode("TouchWallLeft").setFromField("touchTime").setToNode("Worker").setToField("touchedWallLeft"))
    .addChild(new ROUTE().setFromNode("TouchWallRight").setFromField("touchTime").setToNode("Worker").setToField("touchedWallRight"))
    .addChild(new ROUTE().setFromNode("TouchWallFront").setFromField("touchTime").setToNode("Worker").setToField("touchedWallFront"))
    .addChild(new ROUTE().setFromNode("TouchRoof").setFromField("touchTime").setToNode("Worker").setToField("touchedRoof"))
    .addChild(new PositionChaser("PaintingPositionChaser"))
    .addChild(new OrientationChaser("PaintingOrientationChaser"))
    .addChild(new ROUTE().setFromNode("Worker").setFromField("indPos").setToNode("PaintingPositionChaser").setToField("set_destination"))
    .addChild(new ROUTE().setFromNode("Worker").setFromField("indOri").setToNode("PaintingOrientationChaser").setToField("set_destination"))
    .addChild(new ROUTE().setFromNode("PaintingPositionChaser").setFromField("value_changed").setToNode("TransInd").setToField("translation"))
    .addChild(new ROUTE().setFromNode("PaintingOrientationChaser").setFromField("value_changed").setToNode("TransInd").setToField("rotation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return RoomDesired model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new RoomDesired().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Followers.RoomDesired\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Followers.RoomDesired self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Followers/RoomDesired_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Followers/RoomDesired_JavaExport.x3d"; 
                String filenameX3DV = "Followers/RoomDesired_JavaExport.x3dv"; 
                String filenameJSON = "Followers/RoomDesired_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
