package Basic.Followers;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Original implementation pattern as prototype declarations for Follower (Chaser and Damper) nodes, useful for browser developers. </p>
 <p> Related links: Catalog page <a href="../../../Followers/FollowerPrototypeDeclarationsIndex.html" target="_blank">FollowerPrototypeDeclarations</a>,  source <a href="../../../Followers/FollowerPrototypeDeclarations.java">FollowerPrototypeDeclarations.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Followers/FollowerPrototypeDeclarations.x3d">FollowerPrototypeDeclarations.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Original implementation pattern as prototype declarations for Follower (Chaser and Damper) nodes, useful for browser developers. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Herbert Stocker </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 18 April 2006 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 December 2011 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 January 2025 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> This scene was used for X3D development and is no longer correct. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationSection </i> </td>
			<td> X3D Architecture, clause 39 Followers component </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> specificationUrl </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/followers.html" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/followers.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Followers/FollowerExternalPrototypeDeclarations.x3d">FollowerExternalPrototypeDeclarations.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/Chasers.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/Dampers.wrl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Followers/Stocker_06_Followers.pdf">Stocker_06_Followers.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.hersto.com/Publications/Followers" target="_blank">http://www.hersto.com/Publications/Followers</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> requires </i> </td>
			<td> X3D version 3.0, 3.1 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D Follower Chaser Damper </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html" target="_blank">https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Followers/FollowerPrototypeDeclarations.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Followers/FollowerPrototypeDeclarations.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Followers/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Herbert Stocker
 */

public class FollowerPrototypeDeclarations
{
	/** Default constructor to create this object. */
	public FollowerPrototypeDeclarations ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("FollowerPrototypeDeclarations.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Original implementation pattern as prototype declarations for Follower (Chaser and Damper) nodes, useful for browser developers."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Herbert Stocker"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("18 April 2006"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 December 2011"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 January 2025"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("This scene was used for X3D development and is no longer correct."))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONSECTION).setContent("X3D Architecture, clause 39 Followers component"))
    .addMeta(new meta().setName(meta.NAME_SPECIFICATIONURL).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/followers.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("FollowerExternalPrototypeDeclarations.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/Chasers.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/Dampers.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Stocker_06_Followers.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.hersto.com/Publications/Followers"))
    .addMeta(new meta().setName(meta.NAME_REQUIRES   ).setContent("X3D version 3.0, 3.1"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D Follower Chaser Damper"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/specifications/ISO-IEC-19775-1.2-X3D-AbstractSpecification/Part01/components/followers.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Followers/FollowerPrototypeDeclarations.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html"))
    .addComments(" meta content='Rename and test these prototypes to match final names in X3D Specification Followers Component' name='TODO'> ")
    .addComments(" meta content='Ensure full coverage of follower nodes in order to provide backwards compatibility with X3D v3.0 and v3.1.' name='TO DO' ")
    .addComments(" meta content='Xj3D Player Bugzilla Issue http://bugzilla.xj3d.org/show_bug.cgi?id=639' name='TODO' "))
  .setScene(new Scene()
    .addChild(new WorldInfo().setInfo(new String[] {"The ExternProto nodes found in this file implement principles described in the paper","Linear Filters - Animating Objects in a Flexible and Pleasing Way","They have been proposed and added to the X3D standard in 2006.","Webpage: http://www.hersto.net/Followers","","Please use the code in this file in any content or application you like","or modify it in any way.","","The code here works, however things like detecting when a transition has ended","and when the node can stop calculating and updating the output or secondary fields","like set_value or initial_destination are not yet implemented.","Nevertheless, set_destination and value_changed do work."}).setTitle("Damper nodes"))
    .addChild(new ProtoDeclare("PositionChaser").setName("PositionChaser")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("credits").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new String[] {"Initial idea and copyright by Herbert Stocker http://www.hersto.net"}))
        .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0))
        .addField(new field().setName("initial_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("initial_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0))))
      .setProtoBody(new ProtoBody()
        .addChild(new Script("ScreenPositionDamper_PositionChaser").setSourceCode("""
ecmascript:

function initialize()
{
    CheckInit();
}

function CheckInit()
{
    if(!bInitialized)
    {
        bInitialized= true;  // Init() may call other functions that call CheckInit(). In that case it's better the flag is already set, otherwise an endless loop would occur.
        Init();
    }
}

function Init()
{
    destination= initial_destination;

    Buffer.length= cNumSupports;

    Buffer[0]= initial_destination;
    for(var C= 1; C<Buffer.length; C++ )
        Buffer[C]= initial_value;

    previousValue= initial_value;

    cStepTime= duration / cNumSupports;
}

function set_destination(Dest, Now)
{
    CheckInit();

    destination= Dest;
    // Somehow we assign to Buffer[-1] and wait untill this gets shifted into the real buffer.
    // Would we assign to Buffer[0] instead, we'd have no delay, but this would create a jump in the
    // output because Buffer[0] is associated with a value in the past.

    UpdateBuffer(Now);
}

function Tick(Now)
{
    CheckInit();

    if(!BufferEndTime)
    {
        BufferEndTime= Now; // first event we received, so we are in the initialization phase.

        value_changed= initial_value;
        return;
    }

    var Frac= UpdateBuffer(Now);
    // Frac is a value in   0 <= Frac < 1.

    // Now we can calculate the output.
    // This means we calculate the delta between each entry in Buffer and its previous
    // entries, calculate the step response of each such step and add it to form the output.

    // The oldest vaule Buffer[Buffer.length - 1] needs some extra thought, because it has
    // no previous value. More exactly, we haven't stored a previous value anymore.
    // However, the step response of that missing previous value has already reached its
    // destination, so we can - would we have that previous value - use this as a start point
    // for adding the step responses.
    // Actually UpdateBuffer(.) maintains this value in

    var Output= previousValue;

    var DeltaIn= Buffer[Buffer.length - 1].subtract(previousValue);

    var DeltaOut= DeltaIn.multiply(StepResponse((Buffer.length - 1 + Frac) * cStepTime));

    Output= Output.add(DeltaOut);

    for(var C= Buffer.length - 2; C>=0; C-- )
    {
        var DeltaIn= Buffer[C].subtract(Buffer[C + 1]);

        var DeltaOut= DeltaIn.multiply(StepResponse((C + Frac) * cStepTime));

        Output= Output.add(DeltaOut);
    }
    if(Output != value_changed)
        value_changed= Output;
}

function UpdateBuffer(Now)
{
    var Frac= (Now - BufferEndTime) / cStepTime;
    // is normally < 1. When it has grown to be larger than 1, we have to shift the array because the step response
    // of the oldest entry has already reached its destination, and it's time for a newer entry.
    // has already reached it
    // In the case of a very low frame rate, or a very short cStepTime we may need to shift by more than one entry.

    if(Frac >= 1)
    {
        var NumToShift= Math.floor(Frac);
        Frac-= NumToShift;

        if(NumToShift < Buffer.length)
        {   // normal case.

            previousValue= Buffer[Buffer.length - NumToShift];

            for(var C= Buffer.length - 1; C>=NumToShift; C-- )
                Buffer[C]= Buffer[C - NumToShift];

            for(var C= 0; C<NumToShift; C++ )
            {
                // Hmm, we have a destination value, but don't know how it has
                // reached the current state.
                // Therefore we do a linear interpolation from the latest value in the buffer to destination.

                var Alpha= C / NumToShift;

                Buffer[C]= Buffer[NumToShift].multiply(Alpha).add(destination.multiply((1 - Alpha)));
            }
        }else
        {
            // degenerated case:
            //
            // We have a _VERY_ low frame rate...
            // we can only guess how we should fill the array.
            // Maybe we could write part of a linear interpolation
            // from Buffer[0] to destination, that goes from BufferEndTime to Now
            // (possibly only the end of the interpolation is to be written),
            // but if we rech here we are in a very degenerate case...
            // Thus we just write destination to the buffer.

            previousValue= NumToShift == Buffer.length? Buffer[0] : destination;

            for(var C= 0; C<Buffer.length; C++ )
                Buffer[C]= destination;
        }

        BufferEndTime+= NumToShift * cStepTime;
    }
    return Frac;
}

function StepResponse(t)
{
    if(t < 0)
        return 0;

    if(t > duration)
        return 1;

    // When optimizing for speed, the above two if(.) cases can be omitted,
    // as this funciton will not be called for values outside of 0..duration.

    return StepResponseCore(t / duration);
}

// This function defines the shape of how the output responds to the input.
// It must accept values for T in the range 0 <= T <= 1.
// In order to create a smooth animation, it should return 0 for T == 0,
// 1 for T == 1 and be sufficient smooth in the range 0 <= T <= 1.

// It should be optimized for speed, in order for high performance. It's
// executed Buffer.length + 1 times each simulation tick.

function StepResponseCore(T)
{
    return .5 - .5 * Math.cos(T * Math.PI);
}

// The following functions are not used. They provide other responses (for fun).
function StepResponseCoreF(T)
{
    var cTau= .3;
    var cFrequency= 2.5;
    return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI));
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI))* (.5 + .5 * Math.cos(T * Math.PI));
}


function StepResponseCoreE(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin(Math.sqrt(1 - T) * Math.PI/2);

    return A * .8 + B * .2;
}


function StepResponseCoreD(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin((1 - T) * Math.PI/2);

    return A * .8 + B * .2;
}

function StepResponseCoreC(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);

    return A * .8 + B * .2;
}

function StepResponseCoreB(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

    return A * .8 + B * .2;
}
function StepResponseCoreA(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

    var Alpha= .2 * T;
    return A * (1 - Alpha) + B * Alpha;
}
""")
          .addField(new field().setName("Tick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("set_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("Buffer").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("bInitialized").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
          .addField(new field().setName("BufferEndTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("cNumSupports").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(10))
          .addField(new field().setName("set_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("cStepTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("previousValue").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("initial_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("initial_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("set_value").setProtoField("set_value"))
            .addConnect(new connect().setNodeField("duration").setProtoField("duration"))
            .addConnect(new connect().setNodeField("set_destination").setProtoField("set_destination"))
            .addConnect(new connect().setNodeField("value_changed").setProtoField("value_changed"))
            .addConnect(new connect().setNodeField("initial_destination").setProtoField("initial_destination"))
            .addConnect(new connect().setNodeField("isActive").setProtoField("isActive"))
            .addConnect(new connect().setNodeField("initial_value").setProtoField("initial_value"))))
        .addChild(new TimeSensor("Tmer_PositionChaser").setLoop(true))
        .addChild(new ROUTE().setFromNode("Tmer_PositionChaser").setFromField("time").setToNode("ScreenPositionDamper_PositionChaser").setToField("Tick"))))
    .addChild(new ProtoDeclare("OrientationChaser").setName("OrientationChaser")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("value_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_value").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("credits").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new String[] {"Initial idea and copyright by Herbert Stocker http://www.hersto.net/"}))
        .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_destination").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0))
        .addField(new field().setName("initial_destination").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addField(new field().setName("initial_value").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0))))
      .setProtoBody(new ProtoBody()
        .addChild(new Script("ScreenPositionDamper_OrientationChaser").setSourceCode("""
ecmascript:

function initialize()
{
    CheckInit();
}

function CheckInit()
{
    if(!bInitialized)
    {
        bInitialized= true;  // Init() may call other functions that call CheckInit(). In that case it's better the flag is already set, otherwise an endless loop would occur.
        Init();
    }
}

function Init()
{
    destination= initial_destination;

    Buffer.length= cNumSupports;

    Buffer[0]= initial_destination;
    for(var C= 1; C<Buffer.length; C++ )
        Buffer[C]= initial_value;

    previousValue= initial_value;

    cStepTime= duration / cNumSupports;
}

function set_destination(Dest, Now)
{
    CheckInit();

    destination= Dest;
    // Somehow we assign to Buffer[-1] and wait untill this gets shifted into the real buffer.
    // Would we assign to Buffer[0] instead, we'd have no delay, but this would create a jump in the
    // output because Buffer[0] is associated with a value in the past.

    UpdateBuffer(Now);
}

function Tick(Now)
{
    CheckInit();

    if(!BufferEndTime)
    {
        BufferEndTime= Now; // first event we received, so we are in the initialization phase.

        value_changed= initial_value;
        return;
    }

    var Frac= UpdateBuffer(Now);
    // Frac is a value in   0 <= Frac < 1.

    // Now we can calculate the output.
    // This means we calculate the delta between each entry in Buffer and its previous
    // entries, calculate the step response of each such step and add it to form the output.

    // The oldest vaule Buffer[Buffer.length - 1] needs some extra thought, because it has
    // no previous value. More exactly, we haven't stored a previous value anymore.
    // However, the step response of that missing previous value has already reached its
    // destination, so we can - would we have that previous value - use this as a start point
    // for adding the step responses.
    // Actually UpdateBuffer(.) maintains this value in

    var Output= previousValue;

    var DeltaIn= previousValue.inverse().multiply(Buffer[Buffer.length - 1]);

    Output= Output.slerp(Output.multiply(DeltaIn), StepResponse((Buffer.length - 1 + Frac) * cStepTime));

    for(var C= Buffer.length - 2; C>=0; C-- )
    {
        var DeltaIn= Buffer[C + 1].inverse().multiply(Buffer[C]);

        Output= Output.slerp(Output.multiply(DeltaIn), StepResponse((C + Frac) * cStepTime));
    }


    if(Output != value_changed)
        value_changed= Output;
}

function UpdateBuffer(Now)
{
    var Frac= (Now - BufferEndTime) / cStepTime;
    // is normally < 1. When it has grown to be larger than 1, we have to shift the array because the step response
    // of the oldest entry has already reached its destination, and it's time for a newer entry.
    // has already reached it
    // In the case of a very low frame rate, or a very short cStepTime we may need to shift by more than one entry.

    if(Frac >= 1)
    {
        var NumToShift= Math.floor(Frac);
        Frac-= NumToShift;

        if(NumToShift < Buffer.length)
        {   // normal case.

            previousValue= Buffer[Buffer.length - NumToShift];

            for(var C= Buffer.length - 1; C>=NumToShift; C-- )
                Buffer[C]= Buffer[C - NumToShift];

            for(var C= 0; C<NumToShift; C++ )
            {
                // Hmm, we have a destination value, but don't know how it has
                // reached the current state.
                // Therefore we do a linear interpolation from the latest value in the buffer to destination.

                Buffer[C]= destination.slerp(Buffer[NumToShift], C / NumToShift);
            }
        }else
        {
            // degenerated case:
            //
            // We have a _VERY_ low frame rate...
            // we can only guess how we should fill the array.
            // Maybe we could write part of a linear interpolation
            // from Buffer[0] to destination, that goes from BufferEndTime to Now
            // (possibly only the end of the interpolation is to be written),
            // but if we rech here we are in a very degenerate case...
            // Thus we just write destination to the buffer.

            previousValue= NumToShift == Buffer.length? Buffer[0] : destination;

            for(var C= 0; C<Buffer.length; C++ )
                Buffer[C]= destination;
        }
        BufferEndTime+= NumToShift * cStepTime;
    }

return Frac;
}

function StepResponse(t)
{
    if(t < 0)
        return 0;

    if(t > duration)
        return 1;

    // When optimizing for speed, the above two if(.) cases can be omitted,
    // as this funciton will not be called for values outside of 0..duration.

     return StepResponseCore(t / duration);
}

// This function defines the shape of how the output responds to the input.
// It must accept values for T in the range 0 <= T <= 1.
// In order to create a smooth animation, it should return 0 for T == 0,
// 1 for T == 1 and be sufficient smooth in the range 0 <= T <= 1.

// It should be optimized for speed, in order for high performance. It's
// executed Buffer.length + 1 times each simulation tick.

function StepResponseCore(T)
{
    return .5 - .5 * Math.cos(T * Math.PI);
}

// The following functions are not used. They provide other responses (for fun).

function StepResponseCoreG(T)
{
    var cTau= .3;
    var cFrequency= 5;
    return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI));
}

function StepResponseCoreF(T)
{
    var cTau= .3;
    var cFrequency= 2.5;
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI));
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI))* (.5 + .5 * Math.cos(T * Math.PI));
}

function StepResponseCoreE(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin(Math.sqrt(1 - T) * Math.PI/2);

    return A * .8 + B * .2;
}

function StepResponseCoreD(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin((1 - T) * Math.PI/2);

    return A * .8 + B * .2;
}

function StepResponseCoreC(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);

    return A * .8 + B * .2;
}

function StepResponseCoreB(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

    return A * .8 + B * .2;
}

function StepResponseCoreA(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);
    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);
    var Alpha= .2 * T;
    return A * (1 - Alpha) + B * Alpha;
}
""")
          .addField(new field().setName("Tick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("set_value").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("Buffer").setType(field.TYPE_MFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("bInitialized").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
          .addField(new field().setName("BufferEndTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("cNumSupports").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(10))
          .addField(new field().setName("set_destination").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("value_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("cStepTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("previousValue").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
          .addField(new field().setName("initial_destination").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("destination").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
          .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("initial_value").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("set_value").setProtoField("set_value"))
            .addConnect(new connect().setNodeField("duration").setProtoField("duration"))
            .addConnect(new connect().setNodeField("set_destination").setProtoField("set_destination"))
            .addConnect(new connect().setNodeField("value_changed").setProtoField("value_changed"))
            .addConnect(new connect().setNodeField("initial_destination").setProtoField("initial_destination"))
            .addConnect(new connect().setNodeField("isActive").setProtoField("isActive"))
            .addConnect(new connect().setNodeField("initial_value").setProtoField("initial_value"))))
        .addChild(new TimeSensor("Tmer_OrientationChaser").setLoop(true))
        .addChild(new ROUTE().setFromNode("Tmer_OrientationChaser").setFromField("time").setToNode("ScreenPositionDamper_OrientationChaser").setToField("Tick"))))
    .addChild(new ProtoDeclare("Position2fChaser").setName("Position2fChaser")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_value").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("credits").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new String[] {"Initial idea and copyright by Herbert Stocker http://www.hersto.net/"}))
        .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_destination").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0))
        .addField(new field().setName("initial_destination").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec2f(0.0,0.0)))
        .addField(new field().setName("initial_value").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec2f(0.0,0.0))))
      .setProtoBody(new ProtoBody()
        .addChild(new Script("ScreenPositionDamper_Position2fChaser").setSourceCode("""
ecmascript:

function initialize()
{
    CheckInit();
}

function CheckInit()
{
    if(!bInitialized)
    {
        bInitialized= true;  // Init() may call other functions that call CheckInit(). In that case it's better the flag is already set, otherwise an endless loop would occur.
        Init();
    }
}

function Init()
{
    destination= initial_destination;

    Buffer.length= cNumSupports;

    Buffer[0]= initial_destination;
    for(var C= 1; C<Buffer.length; C++ )
        Buffer[C]= initial_value;

    previousValue= initial_value;

    cStepTime= duration / cNumSupports;
}

function set_destination(Dest, Now)
{
    CheckInit();

    destination= Dest;
    // Somehow we assign to Buffer[-1] and wait untill this gets shifted into the real buffer.
    // Would we assign to Buffer[0] instead, we'd have no delay, but this would create a jump in the
    // output because Buffer[0] is associated with a value in the past.

    UpdateBuffer(Now);
}

function Tick(Now)
{
    CheckInit();

    if(!BufferEndTime)
    {
        BufferEndTime= Now; // first event we received, so we are in the initialization phase.

        value_changed= initial_value;
        return;
    }

    var Frac= UpdateBuffer(Now);
    // Frac is a value in   0 <= Frac < 1.

    // Now we can calculate the output.
    // This means we calculate the delta between each entry in Buffer and its previous
    // entries, calculate the step response of each such step and add it to form the output.

    // The oldest vaule Buffer[Buffer.length - 1] needs some extra thought, because it has
    // no previous value. More exactly, we haven't stored a previous value anymore.
    // However, the step response of that missing previous value has already reached its
    // destination, so we can - would we have that previous value - use this as a start point
    // for adding the step responses.
    // Actually UpdateBuffer(.) maintains this value in

    var Output= previousValue;

    var DeltaIn= Buffer[Buffer.length - 1].subtract(previousValue);

    var DeltaOut= DeltaIn.multiply(StepResponse((Buffer.length - 1 + Frac) * cStepTime));

    Output= Output.add(DeltaOut);

    for(var C= Buffer.length - 2; C>=0; C-- )
    {
        var DeltaIn= Buffer[C].subtract(Buffer[C + 1]);

        var DeltaOut= DeltaIn.multiply(StepResponse((C + Frac) * cStepTime));

        Output= Output.add(DeltaOut);
    }


    if(Output != value_changed)
        value_changed= Output;
}

function UpdateBuffer(Now)
{
    var Frac= (Now - BufferEndTime) / cStepTime;
    // is normally < 1. When it has grown to be larger than 1, we have to shift the array because the step response
    // of the oldest entry has already reached its destination, and it's time for a newer entry.
    // has already reached it
    // In the case of a very low frame rate, or a very short cStepTime we may need to shift by more than one entry.

    if(Frac >= 1)
    {
        var NumToShift= Math.floor(Frac);
        Frac-= NumToShift;

        if(NumToShift < Buffer.length)
        {   // normal case.

            previousValue= Buffer[Buffer.length - NumToShift];

            for(var C= Buffer.length - 1; C>=NumToShift; C-- )
                Buffer[C]= Buffer[C - NumToShift];

            for(var C= 0; C<NumToShift; C++ )
            {
                // Hmm, we have a destination value, but don't know how it has
                // reached the current state.
                // Therefore we do a linear interpolation from the latest value in the buffer to destination.

                var Alpha= C / NumToShift;

                Buffer[C]= Buffer[NumToShift].multiply(Alpha).add(destination.multiply((1 - Alpha)));
            }
        }else
        {
            // degenerated case:
            //
            // We have a _VERY_ low frame rate...
            // we can only guess how we should fill the array.
            // Maybe we could write part of a linear interpolation
            // from Buffer[0] to destination, that goes from BufferEndTime to Now
            // (possibly only the end of the interpolation is to be written),
            // but if we rech here we are in a very degenerate case...
            // Thus we just write destination to the buffer.

            previousValue= NumToShift == Buffer.length? Buffer[0] : destination;

            for(var C= 0; C<Buffer.length; C++ )
                Buffer[C]= destination;
        }

        BufferEndTime+= NumToShift * cStepTime;
    }

return Frac;
}



function StepResponse(t)
{
    if(t < 0)
return 0;

    if(t > duration)
return 1;

    // When optimizing for speed, the above two if(.) cases can be omitted,
    // as this funciton will not be called for values outside of 0..duration.

return StepResponseCore(t / duration);
}


// This function defines the shape of how the output responds to the input.
// It must accept values for T in the range 0 <= T <= 1.
// In order to create a smooth animation, it should return 0 for T == 0,
// 1 for T == 1 and be sufficient smooth in the range 0 <= T <= 1.

// It should be optimized for speed, in order for high performance. It's
// executed Buffer.length + 1 times each simulation tick.
function StepResponseCore(T)
{
return .5 - .5 * Math.cos(T * Math.PI);
}


// The following functions are not used. They provide other responses (for fun).
function StepResponseCoreF(T)
{
    var cTau= .3;
    var cFrequency= 2.5;
return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI));
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI))* (.5 + .5 * Math.cos(T * Math.PI));
}

function StepResponseCoreE(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

  var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin(Math.sqrt(1 - T) * Math.PI/2);

return A * .8 + B * .2;
}

function StepResponseCoreD(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

  var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin((1 - T) * Math.PI/2);

return A * .8 + B * .2;
}

function StepResponseCoreC(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

  var cTau= .3;
  var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);

return A * .8 + B * .2;
}

function StepResponseCoreB(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

  var cTau= .3;
  var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

return A * .8 + B * .2;
}

function StepResponseCoreA(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

  var cTau= .3;
  var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

    var Alpha= .2 * T;
return A * (1 - Alpha) + B * Alpha;
}
""")
          .addField(new field().setName("Tick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("set_value").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("Buffer").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("bInitialized").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
          .addField(new field().setName("BufferEndTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("cNumSupports").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(10))
          .addField(new field().setName("set_destination").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("cStepTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("previousValue").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec2f(0.0,0.0)))
          .addField(new field().setName("initial_destination").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("destination").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec2f(0.0,0.0)))
          .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("initial_value").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("set_value").setProtoField("set_value"))
            .addConnect(new connect().setNodeField("duration").setProtoField("duration"))
            .addConnect(new connect().setNodeField("set_destination").setProtoField("set_destination"))
            .addConnect(new connect().setNodeField("value_changed").setProtoField("value_changed"))
            .addConnect(new connect().setNodeField("initial_destination").setProtoField("initial_destination"))
            .addConnect(new connect().setNodeField("isActive").setProtoField("isActive"))
            .addConnect(new connect().setNodeField("initial_value").setProtoField("initial_value"))))
        .addChild(new TimeSensor("Tmer_Position2fChaser").setLoop(true))
        .addChild(new ROUTE().setFromNode("Tmer_Position2fChaser").setFromField("time").setToNode("ScreenPositionDamper_Position2fChaser").setToField("Tick"))))
    .addChild(new ProtoDeclare("PlacementChaser").setName("PlacementChaser")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("isLoaded").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_valuePos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("set_valueOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("set_destinationPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("credits").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new String[] {"Initial idea and copyright by Herbert Stocker http://www.hersto.net/"}))
        .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0))
        .addField(new field().setName("set_destinationOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("initial_valuePos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("initial_destinationPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("valuePos_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("initial_valueOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addField(new field().setName("initial_destinationOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
        .addField(new field().setName("valueOri_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
      .setProtoBody(new ProtoBody()
        .addChild(new Script("ScreenPositionDamper_PlacementChaser").setSourceCode("""
ecmascript:

function initialize()
{
    CheckInit();
}

function CheckInit()
{
    if(!bInitialized)
    {
        bInitialized= true;  // Init() may call other functions that call CheckInit(). In that case it's better the flag is already set, otherwise an endless loop would occur.
        Init();
    }
}
function Init()
{
    destinationPos= initial_destinationPos;
    destinationOri= initial_destinationOri;

    BufferPos.length=
    BufferOri.length= cNumSupports;

    BufferPos[0]= initial_destinationPos;
    BufferOri[0]= initial_destinationOri;
    for(var C= 1; C<BufferPos.length; C++ )
    {
        BufferPos[C]= initial_valuePos;
        BufferOri[C]= initial_valueOri;
    }

    previousValuePos= initial_valuePos;
    previousValueOri= initial_valueOri;

    cStepTime= duration / cNumSupports;
}
function set_destinationPos(Dest, Now)
{
    CheckInit();

    destinationPos= Dest;
    // Somehow we assign to Buffer[-1] and wait untill this gets shifted into the real buffer.
    // Would we assign to Buffer[0] instead, we'd have no delay, but this would create a jump in the
    // output because Buffer[0] is associated with a value in the past.

    //UpdateBuffer(Now);
}

function set_destinationOri(Dest, Now)
{
    CheckInit();

    destinationOri= Dest;
    // Somehow we assign to Buffer[-1] and wait untill this gets shifted into the real buffer.
    // Would we assign to Buffer[0] instead, we'd have no delay, but this would create a jump in the
    // output because Buffer[0] is associated with a value in the past.

    //UpdateBuffer(Now);
}
function Tick(Now)
{
    CheckInit();

    if(!BufferEndTime)
    {
        BufferEndTime= Now; // first event we received, so we are in the initialization phase.

        valuePos_changed= initial_valuePos;
        valueOri_changed= initial_valueOri;
        return;
    }

    var Frac= UpdateBuffer(Now);
    // Frac is a value in   0 <= Frac < 1.

    // Now we can calculate the output.
    // This means we calculate the delta between each entry in Buffer and its previous
    // entries, calculate the step response of each such step and add it to form the output.

    // The oldest vaule Buffer[Buffer.length - 1] needs some extra thought, because it has
    // no previous value. More exactly, we haven't stored a previous value anymore.
    // However, the step response of that missing previous value has already reached its
    // destination, so we can - would we have that previous value - use this as a start point
    // for adding the step responses.
    // Actually UpdateBuffer(.) maintains this value in

    var OutputPos= previousValuePos;
    var OutputOri= previousValueOri;

    var DeltaInPos= BufferPos[BufferPos.length - 1].subtract(previousValuePos);
    var DeltaInOri= previousValueOri.inverse().multiply(BufferOri[BufferOri.length - 1]);

    var DeltaOutPos= DeltaInPos.multiply(StepResponse((BufferPos.length - 1 + Frac) * cStepTime));

    OutputPos= OutputPos.add(DeltaOutPos);
    OutputOri= OutputOri.slerp(OutputOri.multiply(DeltaInOri), StepResponse((BufferOri.length - 1 + Frac) * cStepTime));

    for(var C= BufferPos.length - 2; C>=0; C-- )
    {
        var DeltaInPos= BufferPos[C].subtract(BufferPos[C + 1]);
        var DeltaInOri= BufferOri[C + 1].inverse().multiply(BufferOri[C]);

        var DeltaOutPos= DeltaInPos.multiply(StepResponse((C + Frac) * cStepTime));

        OutputPos= OutputPos.add(DeltaOutPos);
        OutputOri= OutputOri.slerp(OutputOri.multiply(DeltaInOri), StepResponse((C + Frac) * cStepTime));
    }
    if(OutputPos != valuePos_changed)
        valuePos_changed= OutputPos;

    if(OutputOri != valueOri_changed)
        valueOri_changed= OutputOri;
}
function UpdateBuffer(Now)
{
    var Frac= (Now - BufferEndTime) / cStepTime;
    // is normally < 1. When it has grown to be larger than 1, we have to shift the array because the step response
    // of the oldest entry has already reached its destination, and it's time for a newer entry.
    // has already reached it
    // In the case of a very low frame rate, or a very short cStepTime we may need to shift by more than one entry.

    if(Frac >= 1)
    {
        var NumToShift= Math.floor(Frac);
        Frac-= NumToShift;

        if(NumToShift < BufferPos.length)
        {   // normal case.

            previousValuePos= BufferPos[BufferPos.length - NumToShift];
            previousValueOri= BufferOri[BufferOri.length - NumToShift];

            for(var C= BufferPos.length - 1; C>=NumToShift; C-- )
            {
                BufferPos[C]= BufferPos[C - NumToShift];
                BufferOri[C]= BufferOri[C - NumToShift];
            }

            for(var C= 0; C<NumToShift; C++ )
            {
                // Hmm, we have a destination value, but don't know how it has
                // reached the current state.
                // Therefore we do a linear interpolation from the latest value in the buffer to destination.

                var Alpha= C / NumToShift;

                BufferPos[C]= BufferPos[NumToShift].multiply(Alpha).add(destinationPos.multiply((1 - Alpha)));
                BufferOri[C]= destinationOri.slerp(BufferOri[NumToShift], Alpha);
            }
        }else
        {
            // degenerated case:
            //
            // We have a _VERY_ low frame rate...
            // we can only guess how we should fill the array.
            // Maybe we could write part of a linear interpolation
            // from Buffer[0] to destination, that goes from BufferEndTime to Now
            // (possibly only the end of the interpolation is to be written),
            // but if we rech here we are in a very degenerate case...
            // Thus we just write destination to the buffer.

            previousValuePos= NumToShift == BufferPos.length? BufferPos[0] : destinationPos;
            previousValueOri= NumToShift == BufferOri.length? BufferOri[0] : destinationOri;

            for(var C= 0; C<BufferPos.length; C++ )
            {
                BufferPos[C]= destinationPos;
                BufferOri[C]= destinationOri;
            }
        }
        BufferEndTime+= NumToShift * cStepTime;
    }
    return Frac;
}
function StepResponse(t)
{
    if(t < 0)
        return 0;

    if(t > duration)
        return 1;

    // When optimizing for speed, the above two if(.) cases can be omitted,
    // as this funciton will not be called for values outside of 0..duration.

    return StepResponseCore(t / duration);
}


// This function defines the shape of how the output responds to the input.
// It must accept values for T in the range 0 <= T <= 1.
// In order to create a smooth animation, it should return 0 for T == 0,
// 1 for T == 1 and be sufficient smooth in the range 0 <= T <= 1.

// It should be optimized for speed, in order for high performance. It's
// executed Buffer.length + 1 times each simulation tick.
function StepResponseCore(T)
{
    return .5 - .5 * Math.cos(T * Math.PI);
}

// The following functions are not used. They provide other responses (for fun).
function StepResponseCoreF(T)
{
    var cTau= .3;
    var cFrequency= 2.5;
    return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T) * (1 - T);
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI));
//      return 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (.5 + .5 * Math.cos(T * Math.PI))* (.5 + .5 * Math.cos(T * Math.PI));
}
function StepResponseCoreE(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin(Math.sqrt(1 - T) * Math.PI/2);

    return A * .8 + B * .2;
}
function StepResponseCoreD(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cFrequency= 2.5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.sin((1 - T) * Math.PI/2);

    return A * .8 + B * .2;
}
function StepResponseCoreC(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) * Math.exp(-T / cTau) * (1 - T);

    return A * .8 + B * .2;
}


function StepResponseCoreB(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

    return A * .8 + B * .2;
}
function StepResponseCoreA(T)
{
    var A= .5 - .5 * Math.cos(T * Math.PI);

    var cTau= .3;
    var cFrequency= 5;
    var B= 1 - Math.cos(T * 2 * Math.PI * cFrequency) /** Math.exp(-T / cTau)*/ * (1 - T);

    var Alpha= .2 * T;
    return A * (1 - Alpha) + B * Alpha;
}
""")
          .addField(new field().setName("previousValueOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
          .addField(new field().setName("Tick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("duration").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("set_destinationOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("bInitialized").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
          .addField(new field().setName("set_valueOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("previousValuePos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("destinationOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFRotation(0.0,0.0,1.0,0.0)))
          .addField(new field().setName("initial_valueOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("set_destinationPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("BufferEndTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("cNumSupports").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(10))
          .addField(new field().setName("set_valuePos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("cStepTime").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("initial_destinationOri").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("BufferOri").setType(field.TYPE_MFROTATION).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("destinationPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("initial_valuePos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("valuePos_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("initial_destinationPos").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("valueOri_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("BufferPos").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("duration").setProtoField("duration"))
            .addConnect(new connect().setNodeField("set_destinationOri").setProtoField("set_destinationOri"))
            .addConnect(new connect().setNodeField("set_valueOri").setProtoField("set_valueOri"))
            .addConnect(new connect().setNodeField("initial_valueOri").setProtoField("initial_valueOri"))
            .addConnect(new connect().setNodeField("set_destinationPos").setProtoField("set_destinationPos"))
            .addConnect(new connect().setNodeField("set_valuePos").setProtoField("set_valuePos"))
            .addConnect(new connect().setNodeField("initial_destinationOri").setProtoField("initial_destinationOri"))
            .addConnect(new connect().setNodeField("initial_valuePos").setProtoField("initial_valuePos"))
            .addConnect(new connect().setNodeField("valuePos_changed").setProtoField("valuePos_changed"))
            .addConnect(new connect().setNodeField("isActive").setProtoField("isActive"))
            .addConnect(new connect().setNodeField("initial_destinationPos").setProtoField("initial_destinationPos"))
            .addConnect(new connect().setNodeField("valueOri_changed").setProtoField("valueOri_changed"))))
        .addChild(new TimeSensor("Tmer_PlacementChaser").setLoop(true))
        .addChild(new ROUTE().setFromNode("Tmer_PlacementChaser").setFromField("time").setToNode("ScreenPositionDamper_PlacementChaser").setToField("Tick"))
        .addChild(new Script("LastNode").setSourceCode("""
ecmascript:

function initialize()
{
    isLoaded= true;
}
""")
          .addField(new field().setName("isLoaded").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("isLoaded").setProtoField("isLoaded"))))))
    .addChild(new ProtoDeclare("PositionDamper").setName("PositionDamper")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("isLoaded").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("takeFirstInput").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("initial_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1))
        .addField(new field().setName("credits").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new String[] {"Initial idea and copyright by Herbert Stocker http://www.hersto.net/"}))
        .addField(new field().setName("reachThreshold").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.01))
        .addField(new field().setName("tau").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(1.0))
        .addField(new field().setName("set_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("reached").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("initial_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("isActive").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("eps").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0010)))
      .setProtoBody(new ProtoBody()
        .addChild(new ProtoDeclare("EFFS").setName("EFFS")
          .setProtoInterface(new ProtoInterface()
            .addField(new field().setName("tau").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(1.0)))
          .setProtoBody(new ProtoBody()
            .addChild(new Group())))
        .addChild(new ProtoInstance("EFFS", "EFFS").setContainerField("children")
          .addFieldValue(new fieldValue().setName("tau").setValue(1.0)))
        .addChild(new Script("Worker").setSourceCode("""
ecmascript:

function StartTimer()
{
    if(IsCortona)
        return;

    if(!needTimer)
    {
        lastTick= 0;
        needTimer= true;
    }
}

function StopTimer()
{
    if(IsCortona)
        return;

    if(needTimer)
    {
        needTimer= false;
    }
}

function initialize()
{
    CheckInit();
}

function CheckInit()
{
    if(!bInitialized)
    {
        bInitialized= true;
        Init();
    }

}

function Init()
{
    IsCortona= false && Browser.getName().indexOf('Cortona') != -1;

    bNeedToTakeFirstInput= takeFirstInput;

    tau= effs.tau;
    set_value(initial_value);
    if(IsCortona)
        needTimer= true;
    else
        needTimer=    input.x != initial_value.x
                   || input.y != initial_value.y
                   || input.z != initial_value.z
                   ;
}

function set_tau(t)
{
    CheckInit();

    tau= t;
}

function set_destination(i)
{
    CheckInit();

    if(bNeedToTakeFirstInput)
    {
        bNeedToTakeFirstInput= false;
        set_value(i);
    }


    if(i != input)
    {
        input= i;
        StartTimer();
    }
}

function set_value(o)
{
    CheckInit();

    bNeedToTakeFirstInput= false;

    value1= value2= value3= value4= value5= o;
    value_changed= o;
    UpdateReached();
    StartTimer();
}

function tick(now)
{
    CheckInit();

    if(!lastTick)
    {
        lastTick= now;
        return;
    }

    var delta= now - lastTick;
    lastTick= now;

    var alpha= Math.exp(-delta / tau);


    if(bNeedToTakeFirstInput)  // then don't do any processing.
        return;

    value1= order > 0 && tau
               ? input  .add(value1.subtract(input  ).multiply(alpha))
               : input;

    value2= order > 1 && tau
               ? value1.add(value2.subtract(value1).multiply(alpha))
               : value1;

    value3= order > 2 && tau
               ? value2.add(value3.subtract(value2).multiply(alpha))
               : value2;

    value4= order > 3 && tau
               ? value3.add(value4.subtract(value3).multiply(alpha))
               : value3;

    value5= order > 4 && tau
               ? value4.add(value5.subtract(value4).multiply(alpha))
               : value4;

    var dist= GetDist();

    if(dist < eps)
    {
        value1= value2= value3= value4= value5= input;

        value_changed= input;
        UpdateReached2(dist);

        StopTimer();
        return;
    }
    value_changed= value5;
    UpdateReached2(dist);

}

function GetDist()
{
    var dist= value1.subtract(input).length();
    if(order > 1)
    {
        var dist2= value2.subtract(value1).length();
        if( dist2 > dist)  dist= dist2;
    }
    if(order > 2)
    {
        var dist3= value3.subtract(value2).length();
        if( dist3 > dist)  dist= dist3;
    }
    if(order > 3)
    {
        var dist4= value4.subtract(value3).length();
        if( dist4 > dist)  dist= dist4;
    }
    if(order > 4)
    {
        var dist5= value5.subtract(value4).length();
        if( dist5 > dist)  dist= dist5;
    }
    return dist;
}

function UpdateReached()
{
    return UpdateReached2(GetDist());
}

function UpdateReached2(Dist)
{
    if(reached)
    {
        if(Dist > reachThreshold)
            reached= false;
    }else
    {
        if(Dist <= reachThreshold)
            reached= true;
    }
}
""")
          .addField(new field().setName("set_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("IsCortona").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
          .addField(new field().setName("bInitialized").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
          .addField(new field().setName("reachThreshold").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("lastTick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0.0))
          .addField(new field().setName("bNeedToTakeFirstInput").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
          .addField(new field().setName("value5").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("value4").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("value3").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("value2").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("input").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("value1").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)))
          .addField(new field().setName("eps").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("set_destination").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("tau").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0))
          .addField(new field().setName("effs").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
            .addChild(new ProtoInstance("EFFS").setUSE("EFFS").setContainerField("children")))
          .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("needTimer").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("tick").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("set_tau").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("initial_value").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("reached").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("takeFirstInput").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("set_value").setProtoField("set_value"))
            .addConnect(new connect().setNodeField("reachThreshold").setProtoField("reachThreshold"))
            .addConnect(new connect().setNodeField("input").setProtoField("initial_destination"))
            .addConnect(new connect().setNodeField("eps").setProtoField("eps"))
            .addConnect(new connect().setNodeField("set_destination").setProtoField("set_destination"))
            .addConnect(new connect().setNodeField("value_changed").setProtoField("value_changed"))
            .addConnect(new connect().setNodeField("order").setProtoField("order"))
            .addConnect(new connect().setNodeField("needTimer").setProtoField("isActive"))
            .addConnect(new connect().setNodeField("initial_value").setProtoField("initial_value"))
            .addConnect(new connect().setNodeField("reached").setProtoField("reached"))
            .addConnect(new connect().setNodeField("takeFirstInput").setProtoField("takeFirstInput"))))
        .addChild(new TimeSensor("Timer_PositionDamper").setLoop(true))
        .addChild(new ROUTE().setFromNode("Worker").setFromField("needTimer").setToNode("Timer_PositionDamper").setToField("enabled"))
        .addChild(new ROUTE().setFromNode("Timer_PositionDamper").setFromField("time").setToNode("Worker").setToField("tick")))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return FollowerPrototypeDeclarations model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new FollowerPrototypeDeclarations().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Followers.FollowerPrototypeDeclarations\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Followers.FollowerPrototypeDeclarations self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Followers/FollowerPrototypeDeclarations_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Followers/FollowerPrototypeDeclarations_JavaExport.x3d"; 
                String filenameX3DV = "Followers/FollowerPrototypeDeclarations_JavaExport.x3dv"; 
                String filenameJSON = "Followers/FollowerPrototypeDeclarations_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
