####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python FollowerExternalPrototypeDeclarations.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.2',
  head=head(
    children=[
    meta(content='FollowerExternalPrototypeDeclarations.x3d',name='title'),
    meta(content='X3D Follower example using developmental prototypes.',name='description'),
    meta(content='Herbert Stocker',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='18 April 2006',name='created'),
    meta(content='10 April 2012',name='translated'),
    meta(content='7 December 2024',name='modified'),
    meta(content='This scene was used for X3D development and is no longer correct.',name='warning'),
    meta(content='X3D Architecture, clause 39 Followers component',name='specificationSection'),
    meta(content='https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/followers.html',name='specificationUrl'),
    meta(content='FollowerPrototypeDeclarations.x3d',name='reference'),
    meta(content='originals/Chasers.wrl',name='reference'),
    meta(content='originals/Dampers.wrl',name='reference'),
    meta(content='Stocker_06_Followers.pdf',name='reference'),
    meta(content='http://www.hersto.com/Publications/Followers',name='reference'),
    meta(content='X3D version 3.2 or greater',name='requires'),
    meta(content='X3D Follower Chaser Damper',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Followers/FollowerExternalPrototypeDeclarations.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../../license.html',name='license'),
    #  meta content='Rename and test these prototypes to match final names in X3D Specification Followers Component' name='TODO' 
    #  meta content='Ensure full coverage of follower nodes in order to provide backwards compatibility with X3D v3.0 and v3.1.' name='TODO' 
    ]),
  Scene=Scene(
    children=[
    WorldInfo(info=["The ExternProto nodes found in this file implement principles described in the paper","Linear Filters - Animating Objects in a Flexible and Pleasing Way","They have been proposed and added to the X3D standard in 2006.","Webpage: http://www.hersto.net/Followers","","Please use the code in this file in any content or application you like","or modify it in any way.","","The code here works, however things like detecting when a transition has ended","and when the node can stop calculating and updating the output or secondary fields","like set_value or initial_destination are not yet implemented.","Nevertheless, set_destination and value_changed do work."],title='Follower (Chaser and Damper) nodes'),
    #  ================================================ 
    #  Do not use these! The following ExternProtoDeclares were produced when converting the original examples, and are included for completeness only. 
    ExternProtoDeclare(name='OrientationChaser',url=["originals/Chasers.x3d#OrientationChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#OrientationChaser","originals/Chasers.wrl#OrientationChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#OrientationChaser"],
      #  "urn:inet:hersto.net:node:OrientationChaser" "Chasers.x3d#OrientationChaser" 
      #  "http://www.hersto.net/Followers/Chasers.wrl#OrientationChaser" 
      field=[
      field(accessType='outputOnly',name='value_changed',type='SFRotation'),
      field(accessType='inputOnly',name='set_value',type='SFRotation'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='inputOnly',name='set_destination',type='SFRotation'),
      field(accessType='initializeOnly',name='duration',type='SFTime'),
      field(accessType='initializeOnly',name='initial_destination',type='SFRotation'),
      field(accessType='initializeOnly',name='initial_value',type='SFRotation')]),
    ExternProtoDeclare(name='OrientationDamper',url=["originals/Chasers.x3d#OrientationDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#OrientationDamper","originals/Chasers.wrl#OrientationDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#OrientationDamper"],
      #  "urn:inet:hersto.net:node:OrientationDamper" "Dampers.wrl#OrientationDamper" 
      #  http://www.hersto.net/Followers/Dampers.wrl#OrientationDamper" 
      field=[
      field(accessType='outputOnly',name='isLoaded',type='SFBool'),
      field(accessType='outputOnly',name='value_changed',type='SFRotation'),
      field(accessType='inputOnly',name='set_destination',type='SFRotation'),
      field(accessType='initializeOnly',name='initial_destination',type='SFRotation'),
      field(accessType='initializeOnly',name='order',type='SFInt32'),
      field(accessType='inputOutput',name='tau',type='SFFloat'),
      field(accessType='inputOnly',name='set_value',type='SFRotation'),
      field(accessType='initializeOnly',name='initial_value',type='SFRotation'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='initializeOnly',name='eps',type='SFFloat')]),
    ExternProtoDeclare(name='PlacementChaser',url=["originals/Chasers.x3d#PlacementChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#PlacementChaser","originals/Chasers.wrl#PlacementChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#PlacementChaser"],
      field=[
      field(accessType='outputOnly',name='isLoaded',type='SFBool'),
      field(accessType='inputOnly',name='set_valuePos',type='SFVec3f'),
      field(accessType='inputOnly',name='set_valueOri',type='SFRotation'),
      field(accessType='inputOnly',name='set_destinationPos',type='SFVec3f'),
      field(accessType='initializeOnly',name='duration',type='SFTime'),
      field(accessType='inputOnly',name='set_destinationOri',type='SFRotation'),
      field(accessType='initializeOnly',name='initial_valuePos',type='SFVec3f'),
      field(accessType='initializeOnly',name='initial_destinationPos',type='SFVec3f'),
      field(accessType='outputOnly',name='valuePos_changed',type='SFVec3f'),
      field(accessType='initializeOnly',name='initial_valueOri',type='SFRotation'),
      field(accessType='initializeOnly',name='initial_destinationOri',type='SFRotation'),
      field(accessType='outputOnly',name='valueOri_changed',type='SFRotation'),
      field(accessType='outputOnly',name='isActive',type='SFBool')]),
    ExternProtoDeclare(name='Position2fDamper',url=["originals/Chasers.x3d#Position2fDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#Position2fDamper","originals/Chasers.wrl#Position2fDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#Position2fDamper"],
      field=[
      field(accessType='outputOnly',name='isLoaded',type='SFBool'),
      #  "urn:inet:hersto.net:node:Position2fDamper" 
      #  "http://www.hersto.net/Followers/"originals/Dampers.wrl#Position2fDamper" 
      field(accessType='outputOnly',name='value_changed',type='SFVec2f'),
      field(accessType='inputOnly',name='set_destination',type='SFVec2f'),
      field(accessType='initializeOnly',name='initial_destination',type='SFVec2f'),
      field(accessType='initializeOnly',name='order',type='SFInt32'),
      field(accessType='inputOutput',name='tau',type='SFFloat'),
      field(accessType='inputOnly',name='set_value',type='SFVec2f'),
      field(accessType='initializeOnly',name='initial_value',type='SFVec2f'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='initializeOnly',name='eps',type='SFFloat')]),
    ExternProtoDeclare(name='Position2fChaser',url=["originals/Chasers.x3d#Position2fChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#Position2fChaser","originals/Chasers.wrl#Position2fChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#Position2fChaser"],
      #  "urn:inet:hersto.net:node:Position2fChaser" 
      #  "http://www.hersto.net/Followers/Chasers.wrl#Position2fChaser" 
      field=[
      field(accessType='outputOnly',name='value_changed',type='SFVec2f'),
      field(accessType='inputOnly',name='set_value',type='SFVec2f'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='inputOnly',name='set_destination',type='SFVec2f'),
      field(accessType='initializeOnly',name='duration',type='SFTime'),
      field(accessType='initializeOnly',name='initial_destination',type='SFVec2f'),
      field(accessType='initializeOnly',name='initial_value',type='SFVec2f')]),
    ExternProtoDeclare(name='PositionChaser',url=["originals/Chasers.x3d#PositionChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#PositionChaser","originals/Chasers.wrl#PositionChaser","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#PositionChaser"],
      #  "urn:inet:hersto.net:node:PositionChaser" 
      #  "http://www.hersto.net/Followers/Chasers.wrl#PositionChaser" 
      field=[
      field(accessType='outputOnly',name='value_changed',type='SFVec3f'),
      field(accessType='inputOnly',name='set_value',type='SFVec3f'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='inputOnly',name='set_destination',type='SFVec3f'),
      field(accessType='initializeOnly',name='duration',type='SFTime'),
      field(accessType='initializeOnly',name='initial_destination',type='SFVec3f'),
      field(accessType='initializeOnly',name='initial_value',type='SFVec3f')]),
    ExternProtoDeclare(name='PositionDamper',url=["originals/Chasers.x3d#PositionDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.x3d#PositionDamper","originals/Chasers.wrl#PositionDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Chasers.wrl#PositionDamper"],
      #  "urn:inet:hersto.net:node:PositionDamper" 
      #  "http://www.hersto.net/Followers/Dampers.wrl#PositionDamper" 
      field=[
      field(accessType='outputOnly',name='isLoaded',type='SFBool'),
      field(accessType='outputOnly',name='value_changed',type='SFVec3f'),
      field(accessType='inputOnly',name='set_destination',type='SFVec3f'),
      field(accessType='initializeOnly',name='initial_destination',type='SFVec3f'),
      field(accessType='initializeOnly',name='order',type='SFInt32'),
      field(accessType='inputOutput',name='tau',type='SFFloat'),
      field(accessType='inputOnly',name='set_value',type='SFVec3f'),
      field(accessType='initializeOnly',name='initial_value',type='SFVec3f'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='initializeOnly',name='eps',type='SFFloat')]),
    ExternProtoDeclare(name='ScalarDamper',url=["originals/Dampers.wrl#ScalarDamper","https://www.web3d.org/x3d/content/examples/Basic/Followers/originals/Dampers.wrl#ScalarDamper"],
      field=[
      field(accessType='outputOnly',name='isLoaded',type='SFBool'),
      field(accessType='outputOnly',name='value_changed',type='SFFloat'),
      field(accessType='inputOnly',name='set_destination',type='SFFloat'),
      field(accessType='initializeOnly',name='initial_destination',type='SFFloat'),
      field(accessType='initializeOnly',name='order',type='SFInt32'),
      field(accessType='inputOutput',name='tau',type='SFFloat'),
      field(accessType='inputOnly',name='set_value',type='SFFloat'),
      field(accessType='outputOnly',name='transparency_changed',type='SFFloat'),
      field(accessType='initializeOnly',name='initial_value',type='SFFloat'),
      field(accessType='outputOnly',name='isActive',type='SFBool'),
      field(accessType='initializeOnly',name='eps',type='SFFloat')])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for FollowerExternalPrototypeDeclarations.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python FollowerExternalPrototypeDeclarations.py load and self-test diagnostics complete.")
