/**
 *<p>
 *	VRML97 External Authoring Interface (EAI) was used to pass events from HTML scripts into VRML97 scene scripts.
 *</p>
 *<p>
 *	These scripting examples illustrate how to use the original
 *	External Authoring Interface (EAI) in the
 *	<a href="https://www.web3d.org/x3d/specifications/vrml/ISO-IEC-14772-VRML97" target="_blank">VRML97 specification</a>.
 *	It allows scripts placed in an external HTML page to communicate with a VRML97 scene, using either
 *	<a href="https://www.web3d.org/x3d/specifications/vrml/ISO-IEC-14772-VRML97/part1/java.html" target="_blank">Java</a>
 *	or
 *	<a href="https://www.web3d.org/x3d/specifications/vrml/ISO-IEC-14772-VRML97/part1/javascript.html" target="_blank">ECMAScript</a>.
 *</p>
 *
 *<p>
 *	These HTML scripting techniques were later unified with Script syntax inside the scene as the X3D Scene Authoring Interface (SAI).
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/ExternalAuthoringInterface" target="_blank">X3D Basic: External Authoring Interface</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.ExternalAuthoringInterface;

