/**
 *<p>
 *	Experimental Binary Compression algorithm models demonstrate the potential of geometric compression techniques.
 *</p>
 *<p>
 *     These developmental examples illustrate how geometric compression based on text-based ASCII encodings
 *     might be integrated into X3D scenes via Prototype nodes that encapsulate Script processing.
 *     The file-size reduction technique
 *     <a href="http://www.cs.unc.edu/~isenburg/research/asciicoder" target="_blank">Coding Polygon Meshes as Compressable ASCII</a>
 *     by Martin Isenburg and Jack Snoeyink
 *     is documented in award-winning papers presented at the Web3D 2002 and 2003 Symposia.
 *     A
 *     <a href="http://www.cs.unc.edu/~isenburg/research/asciicoder/coder" target="_blank">Shout3D implementation demonstration</a>
 *     is also available.
 *</p>
 *
 *<p>
 *     Further work on the X3D Compressed Binary Encoding (CBE) can be found at
 *     <a href="https://www.web3d.org/x3d/wiki/index.php/X3D_Binary_Compression_Capabilities_and_Plans" target="_blank">X3D Binary Compression Capabilities and Plans</a>
 *     wiki page.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression" target="_blank">X3D Basic: Experimental Binary Compression</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.ExperimentalBinaryCompression;

