####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python TeapotCoded.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='TeapotCoded.x3d',name='title'),
    meta(content='ASCII-coded IndexedFaceSet example.',name='description'),
    meta(content='Martin Isenburg',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='4 May 2003',name='created'),
    meta(content='5 May 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D VRML binary compression',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/TeapotCoded.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='TeapotCoded.x3d'),
    ExternProtoDeclare(appinfo='An ASCII-coded IndexedFaceSet',name='CodedIndexedFaceSet',url=["CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","CodedCompressedPrototypes.wrl#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.wrl#CodedIndexedFaceSet"],
      field=[
      field(accessType='initializeOnly',appinfo='ASCII-coded coordIndex and texCoordIndex values',name='code',type='MFInt32'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for Coordinate values',name='pos',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for TextureCoordinate values',name='tex',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='Coordinate node',name='coord',type='SFNode'),
      field(accessType='initializeOnly',appinfo='TextureCoordinate node',name='texCoord',type='SFNode')]),
    Viewpoint(description='1M view',position=(0.0,0.0,1.0)),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(rotation=(1,0,0,-1.57),scale=(0.1,0.1,0.1),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,1.0,0.0))),
        geometry=ProtoInstance(name='CodedIndexedFaceSet',
          fieldValue=[
          fieldValue(name='code',value=[6248,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,14,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,0,5,6,0,6,0,6,0,6,0,6,6,0,5,0,6,0,6,3,2,6,0,5,0,6,0,5,0,6,6,3,1,1,1,1,1,1,1,2,5,0,5,5,5,0,5,0,6,0,5,0,6,0,6,5,1,1,1,1,1,1,2,0,6,0,6,0,6,0,6,0,5,0,5,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,5,5,0,5,5,0,6,5,5,5,0,5,5,5,0,5,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,3,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,5,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,5,5,0,5,5,0,5,5,0,5,0,6,0,6,0,6,0,6,0,6,0,5,0,6,0,5,0,6,0,5,0,6,0,5,0,6,0,6,0,6,0,6,5,0,5,0,6,0,5,0,6,0,5,0,6,0,5,0,6,0,5,0,6,0,5,0,6,0,5,0,5,0,6,6,0,5,0,6,0,6,0,6,0,6,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,6,5,0,6,5,0,6,5,0,6,5,0,5,5,0,5,5,0,5,5,0,6,5,0,6,5,0,6,5,0,6,5,0,6,5,0,6,5,5,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,3,1,2,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,0,6,3,2,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,0,6,0,6,6,1,2,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,5,0,5,5,0,6,5,0,5,5,5,0,5,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,5,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,8,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,5,5,5,5,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,5,0,5,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,5,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,5,0,5,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,5,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,0,0,0,0,4,0,23,2,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,6,0,6,0,6,0,6,6,0,6,0,6,6,0,6,0,6,6,0,6,6,0,0,6,5,0,5,0,5,0,5,0,6,5,0,5,0,5,5,0,5,5,0,5,0,5,0,6,5,0,5,5,0,0,6,0,5,5,0,6,5,0,6,0,6,0,6,5,0,5,0,6,0,6,0,6,0,5,5,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,0,6,3,2,0,0,6,6,0,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,0,0,7,6,5,2,0,6,0,6,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,0,6,0,6,6,0,6,0,6,6,5,5,0,5,6,0,0,5,5,0,6,0,6,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,6,6,0,5,0,5,7,6,0,6,0,6,6,0,6,0,6,0,6,6,0,6,0,6,6,7,0,5,0,6,0,6,6,0,6,0,6,0,6,0,6,6,0,6,5,0,5,0,5,6,6,0,6,6,0,6,5,0,5,5,6,0,6,0,6,6,0,6,5,0,5,5,5,5,5,6,2]),
          fieldValue(name='pos',value=0.0062688566),
          fieldValue(name='coord',
            children=[
            Coordinate(point=[(-64.0,18.0,-3.0),(-40.0,11.0,-4.0),(-22.0,6.0,-5.0),(-9.0,2.0,-5.0),(-279.0,-72.0,-366.0),(-5.0,10.0,0.0),(5.0,2.0,0.0),(11.0,4.0,0.0),(16.0,3.0,0.0),(15.0,2.0,0.0),(12.0,-2.0,0.0),(5.0,-9.0,0.0),(-5.0,-10.0,0.0),(-12.0,-6.0,0.0),(-15.0,-2.0,0.0),(-16.0,2.0,0.0),(-14.0,0.0,-6.0),(-14.0,6.0,-1.0),(-6.0,10.0,0.0),(6.0,6.0,0.0),(14.0,5.0,1.0),(18.0,3.0,0.0),(19.0,0.0,1.0),(14.0,-4.0,0.0),(5.0,-10.0,0.0),(-5.0,-10.0,0.0),(-14.0,-6.0,0.0),(-19.0,-2.0,-1.0),(-6.0,-3.0,-3.0),(-21.0,3.0,-1.0),(-17.0,7.0,-1.0),(-6.0,11.0,0.0),(6.0,10.0,0.0),(17.0,6.0,1.0),(21.0,3.0,1.0),(21.0,-1.0,0.0),(16.0,-6.0,1.0),(6.0,-12.0,0.0),(-6.0,-11.0,0.0),(-16.0,-7.0,-1.0),(0.0,-3.0,-1.0),(-23.0,-3.0,0.0),(-24.0,3.0,-1.0),(-17.0,8.0,-1.0),(-8.0,13.0,0.0),(8.0,13.0,0.0),(17.0,7.0,1.0),(24.0,3.0,1.0),(23.0,-2.0,0.0),(18.0,-8.0,1.0),(7.0,-13.0,0.0),(-7.0,-13.0,0.0),(4.0,-2.0,1.0),(-19.0,-8.0,0.0),(-24.0,-3.0,-1.0),(-24.0,3.0,-1.0),(-19.0,8.0,0.0),(-8.0,15.0,0.0),(8.0,15.0,0.0),(19.0,9.0,0.0),(24.0,3.0,1.0),(24.0,-3.0,1.0),(19.0,-9.0,0.0),(8.0,-15.0,0.0),(7.0,0.0,3.0),(-8.0,-16.0,0.0),(-19.0,-9.0,0.0),(-24.0,-4.0,0.0),(-25.0,4.0,-1.0),(-19.0,9.0,0.0),(-7.0,16.0,0.0),(7.0,16.0,0.0),(19.0,10.0,0.0),(25.0,3.0,1.0),(24.0,-3.0,0.0),(19.0,-9.0,0.0),(9.0,0.0,5.0),(7.0,-17.0,0.0),(-7.0,-16.0,0.0),(-18.0,-10.0,0.0),(-23.0,-4.0,0.0),(-23.0,4.0,0.0),(-18.0,10.0,0.0),(-7.0,16.0,0.0),(7.0,17.0,0.0),(18.0,10.0,0.0),(23.0,3.0,0.0),(23.0,-3.0,0.0),(31.0,3.0,31.0),(13.0,-11.0,-2.0),(5.0,-19.0,-1.0),(-5.0,-18.0,1.0),(-13.0,-11.0,2.0),(-16.0,-4.0,3.0),(-16.0,4.0,3.0),(-12.0,11.0,2.0),(-5.0,18.0,1.0),(5.0,19.0,-1.0),(12.0,11.0,-2.0),(16.0,4.0,-3.0),(21.0,9.0,44.0),(13.0,-5.0,-8.0),(9.0,-14.0,-6.0),(4.0,-24.0,-2.0),(-4.0,-23.0,2.0),(-9.0,-15.0,6.0),(-13.0,-4.0,8.0),(-13.0,4.0,7.0),(-10.0,15.0,6.0),(-4.0,23.0,2.0),(4.0,24.0,-2.0),(10.0,14.0,-6.0),(16.0,11.0,53.0),(12.0,6.0,-14.0),(11.0,-6.0,-13.0),(9.0,-18.0,-11.0),(3.0,-31.0,-4.0),(-3.0,-30.0,4.0),(-9.0,-18.0,11.0),(-11.0,-6.0,13.0),(-12.0,6.0,14.0),(-9.0,18.0,11.0),(-3.0,30.0,4.0),(3.0,31.0,-4.0),(24.0,6.0,55.0),(8.0,22.0,-15.0),(10.0,8.0,-21.0),(10.0,-8.0,-20.0),(8.0,-22.0,-16.0),(3.0,-37.0,-6.0),(-3.0,-36.0,6.0),(-8.0,-22.0,16.0),(-10.0,-8.0,20.0),(-10.0,8.0,21.0),(-8.0,22.0,15.0),(-3.0,36.0,6.0),(47.0,0.0,48.0),(2.0,42.0,-8.0),(5.0,25.0,-21.0),(7.0,9.0,-26.0),(7.0,-9.0,-27.0),(6.0,-25.0,-20.0),(2.0,-42.0,-8.0),(28.0,0.0,4.0),(-30.0,-41.0,4.0),(-6.0,-26.0,20.0),(-7.0,-8.0,27.0),(-7.0,8.0,26.0),(-5.0,26.0,21.0),(45.0,43.0,24.0),(4.0,42.0,-8.0),(-1.0,25.0,-25.0),(3.0,8.0,-28.0),(0.0,1.0,0.0),(1.0,-3.0,-10.0),(3.0,-6.0,-19.0),(2.0,-22.0,-19.0),(0.0,-4.0,-4.0),(80.0,-44.0,-174.0),(0.0,0.0,5.0),(-3.0,0.0,-7.0),(-5.0,0.0,2.0),(-5.0,0.0,5.0),(-6.0,0.0,9.0),(-20.0,0.0,42.0),(-18.0,0.0,41.0),(-17.0,0.0,41.0),(-6.0,-43.0,37.0),(-2.0,-24.0,22.0),(-4.0,-6.0,19.0),(0.0,-3.0,10.0),(-3.0,9.0,29.0),(0.0,25.0,24.0),(11.0,42.0,35.0),(19.0,0.0,21.0),(20.0,0.0,18.0),(14.0,0.0,12.0),(6.0,0.0,8.0),(2.0,0.0,6.0),(10.0,0.0,5.0),(23.0,0.0,5.0),(41.0,0.0,4.0),(67.0,0.0,3.0),(96.0,0.0,1.0),(-83.0,49.0,-1.0),(-58.0,34.0,-3.0),(-36.0,21.0,-4.0),(-20.0,11.0,-5.0),(-8.0,5.0,-5.0),(-2.0,1.0,-6.0),(-23.0,-57.0,0.0),(-6.0,2.0,-8.0),(-14.0,4.0,-12.0),(-19.0,5.0,-18.0),(-18.0,5.0,-21.0),(-15.0,4.0,-28.0),(-5.0,1.0,-33.0),(3.0,0.0,-37.0),(8.0,-3.0,-38.0),(13.0,-3.0,-40.0),(16.0,-5.0,-41.0),(18.0,-5.0,-41.0),(19.0,-5.0,-42.0),(5.0,-1.0,-9.0),(5.0,-2.0,-5.0),(5.0,-1.0,-2.0),(2.0,-1.0,2.0),(1.0,0.0,5.0),(-3.0,1.0,9.0),(-8.0,-60.0,0.0),(223.0,-4.0,-100.0),(0.0,44.0,4.0),(12.0,-1.0,0.0),(11.0,-5.0,0.0),(9.0,-7.0,0.0),(7.0,-8.0,0.0),(4.0,-11.0,0.0),(2.0,-12.0,0.0),(-2.0,-12.0,0.0),(-4.0,-11.0,0.0),(-7.0,-9.0,0.0),(-9.0,-7.0,0.0),(-11.0,-4.0,0.0),(-12.0,-2.0,0.0),(-12.0,2.0,0.0),(-10.0,4.0,0.0),(-9.0,7.0,0.0),(-7.0,9.0,0.0),(-5.0,11.0,0.0),(-1.0,12.0,0.0),(1.0,12.0,0.0),(5.0,11.0,0.0),(7.0,8.0,0.0),(9.0,7.0,0.0),(10.0,5.0,0.0),(-3.0,13.0,9.0),(15.0,2.0,0.0),(16.0,-2.0,0.0),(14.0,-6.0,0.0),(12.0,-9.0,0.0),(9.0,-12.0,0.0),(5.0,-14.0,0.0),(2.0,-15.0,0.0),(-2.0,-16.0,0.0),(-5.0,-14.0,0.0),(-9.0,-11.0,0.0),(-12.0,-9.0,0.0),(-14.0,-6.0,0.0),(-16.0,-2.0,0.0),(-15.0,2.0,0.0),(-14.0,6.0,0.0),(-12.0,9.0,0.0),(-9.0,11.0,0.0),(-6.0,14.0,0.0),(-2.0,16.0,0.0),(2.0,15.0,0.0),(6.0,14.0,0.0),(9.0,12.0,0.0),(12.0,9.0,0.0),(3.0,-5.0,14.0),(12.0,5.0,0.0),(14.0,2.0,0.0),(14.0,-2.0,0.0),(13.0,-5.0,0.0),(10.0,-8.0,0.0),(8.0,-11.0,0.0),(5.0,-12.0,0.0),(2.0,-14.0,0.0),(-2.0,-14.0,0.0),(-5.0,-13.0,0.0),(-8.0,-10.0,0.0),(-10.0,-8.0,0.0),(-13.0,-5.0,0.0),(-14.0,-2.0,0.0),(-14.0,2.0,0.0),(-12.0,5.0,0.0),(-10.0,8.0,0.0),(-9.0,10.0,0.0),(-5.0,13.0,0.0),(-1.0,14.0,0.0),(1.0,14.0,0.0),(5.0,12.0,0.0),(9.0,11.0,0.0),(9.0,-10.0,16.0),(8.0,6.0,0.0),(9.0,3.0,0.0),(10.0,2.0,0.0),(11.0,-2.0,0.0),(9.0,-3.0,0.0),(7.0,-6.0,0.0),(6.0,-8.0,0.0),(4.0,-9.0,0.0),(1.0,-10.0,0.0),(-1.0,-10.0,0.0),(-4.0,-9.0,0.0),(-6.0,-8.0,0.0),(-7.0,-6.0,0.0),(-9.0,-4.0,0.0),(-11.0,-1.0,0.0),(-10.0,1.0,0.0),(-9.0,4.0,0.0),(-8.0,6.0,0.0),(-5.0,8.0,0.0),(-4.0,9.0,0.0),(-1.0,10.0,0.0),(1.0,10.0,0.0),(4.0,9.0,0.0),(3.0,-9.0,10.0),(3.0,6.0,0.0),(5.0,7.0,-1.0),(6.0,4.0,0.0),(7.0,3.0,0.0),(8.0,1.0,0.0),(8.0,-1.0,0.0),(7.0,-3.0,1.0),(6.0,-5.0,1.0),(4.0,-4.0,0.0),(1.0,-3.0,1.0),(2.0,-4.0,0.0),(1.0,-3.0,0.0),(0.0,-5.0,0.0),(0.0,-3.0,1.0),(-1.0,-5.0,0.0),(0.0,-3.0,1.0),(-3.0,-6.0,0.0),(-4.0,-5.0,0.0),(-6.0,-5.0,1.0),(-7.0,-3.0,0.0),(-8.0,-1.0,0.0),(-1.0,0.0,-1.0),(-6.0,1.0,0.0),(-2.0,0.0,0.0),(-5.0,2.0,0.0),(-2.0,2.0,-1.0),(-4.0,3.0,0.0),(-2.0,1.0,0.0),(-3.0,4.0,0.0),(-1.0,3.0,-1.0),(-2.0,4.0,0.0),(-1.0,3.0,-1.0),(-1.0,5.0,0.0),(0.0,3.0,-1.0),(1.0,5.0,0.0),(-2.0,3.0,9.0),(3.0,8.0,0.0),(5.0,6.0,0.0),(6.0,5.0,0.0),(8.0,3.0,0.0),(8.0,2.0,0.0),(9.0,-2.0,0.0),(8.0,-3.0,0.0),(6.0,-5.0,0.0),(5.0,-6.0,0.0),(3.0,-8.0,0.0),(1.0,-8.0,0.0),(-1.0,-9.0,0.0),(-3.0,-8.0,0.0),(-5.0,-6.0,0.0),(-6.0,-5.0,0.0),(-8.0,-3.0,0.0),(-9.0,-1.0,0.0),(-8.0,1.0,0.0),(-8.0,3.0,0.0),(-6.0,5.0,0.0),(-5.0,6.0,0.0),(-3.0,8.0,0.0),(-2.0,9.0,0.0),(-24.0,0.0,10.0),(2.0,15.0,0.0),(6.0,13.0,0.0),(9.0,11.0,0.0),(11.0,9.0,0.0),(13.0,6.0,0.0),(15.0,2.0,0.0),(15.0,-2.0,0.0),(14.0,-6.0,0.0),(11.0,-9.0,0.0),(9.0,-11.0,0.0),(5.0,-13.0,0.0),(2.0,-15.0,0.0),(-2.0,-15.0,0.0),(-5.0,-14.0,0.0),(-9.0,-11.0,0.0),(-11.0,-9.0,0.0),(-14.0,-5.0,0.0),(-15.0,-2.0,0.0),(-15.0,2.0,0.0),(-13.0,5.0,0.0),(-11.0,9.0,0.0),(-9.0,11.0,0.0),(-6.0,14.0,0.0),(-73.0,-21.0,14.0),(-36.0,-10.0,6.0),(75.0,21.0,-13.0),(-3.0,25.0,0.0),(3.0,24.0,0.0),(9.0,22.0,0.0),(14.0,19.0,0.0),(19.0,14.0,0.0),(22.0,9.0,0.0),(24.0,3.0,0.0),(25.0,-3.0,0.0),(22.0,-9.0,0.0),(18.0,-14.0,0.0),(15.0,-19.0,0.0),(9.0,-22.0,0.0),(3.0,-24.0,0.0),(-3.0,-25.0,0.0),(-9.0,-22.0,0.0),(-15.0,-18.0,0.0),(-18.0,-15.0,0.0),(-22.0,-9.0,0.0),(-25.0,-3.0,0.0),(-24.0,3.0,0.0),(-22.0,9.0,0.0),(-19.0,15.0,0.0),(-14.0,18.0,0.0),(-35.0,-20.0,7.0),(-32.0,-19.0,6.0),(-24.0,-14.0,7.0),(-19.0,47.0,0.0),(-7.0,53.0,0.0),(-1.0,0.0,1.0),(28.0,0.0,-8.0),(38.0,0.0,-6.0),(4.0,35.0,0.0),(13.0,32.0,0.0),(21.0,26.0,0.0),(26.0,21.0,0.0),(32.0,13.0,0.0),(35.0,4.0,0.0),(36.0,-4.0,0.0),(31.0,-13.0,0.0),(27.0,-21.0,0.0),(20.0,-26.0,0.0),(13.0,-32.0,0.0),(5.0,-35.0,0.0),(-5.0,-36.0,0.0),(-13.0,-31.0,0.0),(-20.0,-27.0,0.0),(-27.0,-20.0,0.0),(-31.0,-13.0,0.0),(-36.0,-5.0,0.0),(-35.0,5.0,0.0),(-32.0,13.0,0.0),(-26.0,20.0,0.0),(-27.0,-26.0,6.0),(-19.0,-20.0,7.0),(-1.0,0.0,1.0),(-30.0,39.0,0.0),(-20.0,48.0,0.0),(-24.0,-6.0,0.0),(3.0,1.0,-9.0),(-1.0,-1.0,-5.0),(-2.0,0.0,-2.0),(-5.0,-2.0,2.0),(-5.0,-1.0,5.0),(-5.0,-2.0,9.0),(-19.0,-5.0,42.0),(-18.0,-5.0,41.0),(-16.0,-4.0,41.0),(-13.0,-4.0,40.0),(-8.0,-2.0,38.0),(-3.0,-1.0,37.0),(5.0,2.0,33.0),(15.0,4.0,28.0),(18.0,5.0,21.0),(19.0,5.0,18.0),(14.0,4.0,12.0),(6.0,1.0,8.0),(2.0,1.0,6.0),(9.0,3.0,5.0),(22.0,6.0,5.0),(40.0,11.0,4.0),(64.0,18.0,3.0),(10.0,-23.0,0.0),(15.0,-20.0,0.0),(19.0,-15.0,0.0),(24.0,-10.0,0.0),(25.0,-3.0,0.0),(26.0,3.0,0.0),(24.0,10.0,0.0),(19.0,15.0,0.0),(15.0,20.0,0.0),(10.0,23.0,0.0),(3.0,26.0,0.0),(-3.0,26.0,0.0),(-10.0,23.0,0.0),(-15.0,19.0,0.0),(-19.0,15.0,0.0),(-24.0,10.0,0.0),(-26.0,3.0,0.0),(-25.0,-3.0,0.0),(-24.0,-10.0,0.0),(-19.0,-15.0,0.0),(-47.0,48.0,-3.0),(-30.0,29.0,-4.0),(-16.0,16.0,-5.0),(-7.0,7.0,-5.0),(-1.0,2.0,-6.0),(-5.0,4.0,-8.0),(-38.0,-50.0,0.0),(-12.0,8.0,-12.0),(-17.0,10.0,-18.0),(-17.0,9.0,-21.0),(-12.0,8.0,-28.0),(-6.0,3.0,-33.0),(3.0,-2.0,-37.0),(8.0,-4.0,-38.0),(11.0,-7.0,-40.0),(14.0,-8.0,-41.0),(16.0,-10.0,-41.0),(17.0,-10.0,-42.0),(5.0,-2.0,-9.0),(5.0,-3.0,-5.0),(4.0,-3.0,-2.0),(2.0,-1.0,2.0),(1.0,0.0,5.0),(-3.0,1.0,9.0),(2.0,-61.0,0.0),(1.0,-1.0,-1.0),(26.0,-7.0,-7.0),(17.0,41.0,0.0),(26.0,34.0,0.0),(34.0,26.0,0.0),(41.0,17.0,0.0),(45.0,6.0,0.0),(46.0,-6.0,0.0),(40.0,-17.0,0.0),(34.0,-26.0,0.0),(27.0,-34.0,0.0),(16.0,-41.0,0.0),(6.0,-45.0,0.0),(-6.0,-46.0,0.0),(-16.0,-40.0,0.0),(-27.0,-34.0,0.0),(-34.0,-27.0,0.0),(-40.0,-16.0,0.0),(-46.0,-6.0,0.0),(-45.0,6.0,0.0),(-41.0,16.0,0.0),(-14.0,-23.0,7.0),(0.0,-1.0,1.0),(-92.0,58.0,0.0),(3.0,2.0,-9.0),(-1.0,0.0,-5.0),(-2.0,-2.0,-2.0),(-4.0,-2.0,2.0),(-5.0,-3.0,5.0),(-5.0,-3.0,9.0),(-17.0,-10.0,42.0),(-16.0,-9.0,41.0),(-14.0,-9.0,41.0),(-11.0,-6.0,40.0),(-8.0,-5.0,38.0),(-3.0,-1.0,37.0),(6.0,3.0,33.0),(12.0,7.0,28.0),(17.0,10.0,21.0),(17.0,10.0,18.0),(12.0,7.0,12.0),(5.0,3.0,8.0),(2.0,1.0,6.0),(8.0,5.0,5.0),(20.0,12.0,5.0),(36.0,21.0,4.0),(26.0,-33.0,0.0),(33.0,-25.0,0.0),(39.0,-17.0,0.0),(43.0,-5.0,0.0),(44.0,5.0,0.0),(39.0,17.0,0.0),(33.0,25.0,0.0),(26.0,33.0,0.0),(16.0,39.0,0.0),(6.0,44.0,0.0),(-6.0,44.0,0.0),(-16.0,39.0,0.0),(-26.0,33.0,0.0),(-33.0,25.0,0.0),(-39.0,16.0,0.0),(-44.0,6.0,0.0),(-43.0,-6.0,0.0),(-39.0,-16.0,0.0),(-22.0,36.0,-4.0),(-11.0,20.0,-5.0),(-5.0,8.0,-5.0),(-1.0,2.0,-6.0),(-3.0,5.0,-8.0),(-8.0,13.0,-12.0),(-52.0,-41.0,0.0),(-14.0,14.0,-18.0),(-13.0,14.0,-21.0),(-11.0,10.0,-28.0),(-4.0,4.0,-33.0),(2.0,-2.0,-37.0),(6.0,-6.0,-38.0),(10.0,-9.0,-40.0),(11.0,-12.0,-41.0),(14.0,-13.0,-41.0),(14.0,-14.0,-42.0),(3.0,-4.0,-9.0),(4.0,-4.0,-5.0),(4.0,-3.0,-2.0),(2.0,-2.0,2.0),(0.0,-1.0,5.0),(-2.0,2.0,9.0),(-13.0,-59.0,0.0),(0.0,0.0,-1.0),(31.0,39.0,0.0),(39.0,31.0,0.0),(48.0,19.0,0.0),(52.0,7.0,0.0),(53.0,-7.0,0.0),(47.0,-19.0,0.0),(40.0,-31.0,0.0),(30.0,-39.0,0.0),(20.0,-48.0,0.0),(7.0,-52.0,0.0),(-7.0,-53.0,0.0),(-20.0,-47.0,0.0),(-30.0,-40.0,0.0),(-40.0,-30.0,0.0),(-47.0,-20.0,0.0),(-53.0,-7.0,0.0),(-52.0,7.0,0.0),(-1.0,-1.0,1.0),(-104.0,33.0,0.0),(2.0,2.0,-9.0),(0.0,0.0,-5.0),(-2.0,-2.0,-2.0),(-4.0,-3.0,2.0),(-4.0,-4.0,5.0),(-3.0,-4.0,9.0),(-14.0,-14.0,42.0),(-14.0,-13.0,41.0),(-11.0,-12.0,41.0),(-10.0,-9.0,40.0),(-6.0,-7.0,38.0),(-2.0,-2.0,37.0),(4.0,4.0,33.0),(11.0,11.0,28.0),(13.0,14.0,21.0),(14.0,13.0,18.0),(10.0,11.0,12.0),(5.0,4.0,8.0),(1.0,1.0,6.0),(7.0,7.0,5.0),(16.0,16.0,5.0),(41.0,-32.0,0.0),(49.0,-20.0,0.0),(55.0,-7.0,0.0),(56.0,7.0,0.0),(49.0,20.0,0.0),(41.0,32.0,0.0),(32.0,42.0,0.0),(20.0,49.0,0.0),(7.0,55.0,0.0),(-7.0,55.0,0.0),(-20.0,49.0,0.0),(-32.0,41.0,0.0),(-41.0,32.0,0.0),(-49.0,20.0,0.0),(-56.0,8.0,0.0),(-55.0,-8.0,0.0),(-6.0,22.0,-5.0),(-2.0,10.0,-5.0),(-1.0,2.0,-6.0),(-1.0,5.0,-8.0),(-4.0,15.0,-12.0),(-5.0,18.0,-18.0),(-67.0,-28.0,0.0),(-10.0,17.0,-21.0),(-8.0,13.0,-28.0),(-3.0,5.0,-33.0),(2.0,-3.0,-37.0),(4.0,-7.0,-38.0),(7.0,-12.0,-40.0),(8.0,-14.0,-41.0),(10.0,-16.0,-41.0),(10.0,-17.0,-42.0),(3.0,-5.0,-9.0),(2.0,-5.0,-5.0),(3.0,-4.0,-2.0),(1.0,-2.0,2.0),(1.0,-1.0,5.0),(-2.0,3.0,9.0),(-28.0,-54.0,0.0),(40.0,30.0,0.0),(47.0,20.0,0.0),(53.0,7.0,0.0),(53.0,-7.0,0.0),(48.0,-20.0,0.0),(39.0,-30.0,0.0),(31.0,-40.0,0.0),(20.0,-47.0,0.0),(7.0,-53.0,0.0),(-7.0,-53.0,0.0),(-20.0,-48.0,0.0),(-31.0,-39.0,0.0),(-39.0,-31.0,0.0),(-48.0,-20.0,0.0),(-53.0,-7.0,0.0),(-112.0,6.0,0.0),(2.0,2.0,-9.0),(-1.0,0.0,-5.0),(-1.0,-3.0,-2.0),(-3.0,-4.0,2.0),(-2.0,-5.0,5.0),(-3.0,-4.0,9.0),(-10.0,-17.0,42.0),(-10.0,-17.0,41.0),(-8.0,-14.0,41.0),(-7.0,-11.0,40.0),(-4.0,-8.0,38.0),(-2.0,-2.0,37.0),(3.0,5.0,33.0),(8.0,13.0,28.0),(10.0,16.0,21.0),(9.0,17.0,18.0),(8.0,13.0,12.0),(3.0,5.0,8.0),(1.0,1.0,6.0),(5.0,9.0,5.0),(54.0,-23.0,0.0),(61.0,-8.0,0.0),(62.0,8.0,0.0),(54.0,23.0,0.0),(46.0,35.0,0.0),(36.0,46.0,0.0),(22.0,55.0,0.0),(8.0,61.0,0.0),(-8.0,61.0,0.0),(-22.0,54.0,0.0),(-36.0,46.0,0.0),(-46.0,36.0,0.0),(-54.0,22.0,0.0),(-62.0,9.0,0.0),(0.0,9.0,-5.0),(0.0,2.0,-6.0),(0.0,6.0,-8.0),(0.0,15.0,-13.0),(0.0,19.0,-17.0),(0.0,19.0,-21.0),(-80.0,-10.0,0.0),(-4.0,14.0,-28.0),(-1.0,6.0,-33.0),(1.0,-3.0,-37.0),(2.0,-9.0,-38.0),(4.0,-12.0,-40.0),(4.0,-16.0,-41.0),(5.0,-18.0,-41.0),(5.0,-19.0,-42.0),(2.0,-6.0,-9.0),(1.0,-5.0,-5.0),(1.0,-4.0,-2.0),(1.0,-3.0,2.0),(0.0,-1.0,5.0),(0.0,3.0,9.0),(59.0,8.0,0.0),(60.0,-8.0,0.0),(54.0,-22.0,0.0),(45.0,-35.0,0.0),(35.0,-45.0,0.0),(22.0,-53.0,0.0),(8.0,-60.0,0.0),(-8.0,-60.0,0.0),(-22.0,-54.0,0.0),(-35.0,-45.0,0.0),(-45.0,-34.0,0.0),(-54.0,-23.0,0.0),(-59.0,-8.0,0.0),(-60.0,8.0,0.0),(0.0,3.0,-9.0),(0.0,0.0,-5.0),(-1.0,-3.0,-2.0),(-1.0,-5.0,2.0),(-1.0,-5.0,5.0),(-2.0,-5.0,9.0),(-5.0,-19.0,42.0),(-5.0,-18.0,41.0),(-4.0,-16.0,41.0),(-4.0,-13.0,40.0),(-2.0,-8.0,38.0),(-1.0,-3.0,37.0),(1.0,6.0,33.0),(4.0,14.0,28.0),(6.0,18.0,21.0),(5.0,19.0,18.0),(4.0,14.0,12.0),(1.0,6.0,8.0),(1.0,2.0,6.0),(63.0,-9.0,0.0),(64.0,9.0,0.0),(57.0,23.0,0.0),(48.0,37.0,0.0),(37.0,48.0,0.0),(23.0,57.0,0.0),(9.0,64.0,0.0),(-9.0,63.0,0.0),(-23.0,57.0,0.0),(-37.0,48.0,0.0),(-48.0,37.0,0.0),(-57.0,24.0,0.0),(1.0,2.0,-6.0),(1.0,5.0,-8.0),(4.0,15.0,-13.0),(5.0,18.0,-17.0),(6.0,19.0,-21.0),(4.0,14.0,-28.0),(-85.0,11.0,0.0),(0.0,6.0,-33.0),(0.0,-3.0,-37.0),(0.0,-9.0,-38.0),(0.0,-13.0,-40.0),(0.0,-17.0,-41.0),(0.0,-18.0,-41.0),(0.0,-20.0,-42.0),(0.0,-5.0,-9.0),(0.0,-6.0,-5.0),(0.0,-4.0,-2.0),(0.0,-3.0,2.0),(0.0,-1.0,5.0),(60.0,-8.0,0.0),(52.0,-22.0,0.0),(45.0,-34.0,0.0),(34.0,-44.0,0.0),(22.0,-53.0,0.0),(8.0,-59.0,0.0),(-8.0,-59.0,0.0),(-22.0,-53.0,0.0),(-34.0,-45.0,0.0),(-45.0,-34.0,0.0),(-52.0,-22.0,0.0),(-59.0,-8.0,0.0),(0.0,0.0,-5.0),(0.0,-3.0,-2.0),(0.0,-5.0,2.0),(0.0,-5.0,5.0),(0.0,-6.0,9.0),(0.0,-19.0,42.0),(0.0,-19.0,41.0),(0.0,-16.0,41.0),(0.0,-13.0,40.0),(-1.0,-9.0,38.0),(0.0,-3.0,37.0),(0.0,6.0,33.0),(0.0,14.0,28.0),(0.0,20.0,21.0),(0.0,19.0,17.0),(0.0,15.0,13.0),(0.0,5.0,8.0),(65.0,9.0,0.0),(57.0,24.0,0.0),(48.0,37.0,0.0),(38.0,48.0,0.0),(23.0,57.0,0.0),(9.0,65.0,0.0),(-9.0,64.0,0.0),(-23.0,57.0,0.0),(-38.0,49.0,0.0),(-48.0,37.0,0.0),(3.0,5.0,-8.0),(8.0,13.0,-13.0),(9.0,16.0,-17.0),(10.0,17.0,-21.0),(8.0,13.0,-28.0),(3.0,5.0,-33.0),(-77.0,32.0,0.0),(-1.0,-3.0,-37.0),(-2.0,-9.0,-38.0),(-4.0,-12.0,-40.0),(-4.0,-16.0,-41.0),(-5.0,-18.0,-41.0),(-5.0,-19.0,-42.0),(-2.0,-6.0,-9.0),(-1.0,-5.0,-5.0),(-1.0,-4.0,-2.0),(-1.0,-3.0,2.0),(53.0,-22.0,0.0),(44.0,-34.0,0.0),(35.0,-45.0,0.0),(22.0,-53.0,0.0),(7.0,-59.0,0.0),(-7.0,-60.0,0.0),(-22.0,-52.0,0.0),(-35.0,-45.0,0.0),(-44.0,-34.0,0.0),(-53.0,-22.0,0.0),(1.0,-3.0,-2.0),(1.0,-5.0,2.0),(1.0,-5.0,5.0),(2.0,-5.0,9.0),(5.0,-19.0,42.0),(5.0,-18.0,41.0),(4.0,-16.0,41.0),(4.0,-13.0,40.0),(2.0,-8.0,38.0),(1.0,-3.0,37.0),(-1.0,6.0,33.0),(-4.0,14.0,28.0),(-6.0,18.0,21.0),(-5.0,19.0,17.0),(-4.0,14.0,13.0),(59.0,25.0,0.0),(50.0,38.0,0.0),(38.0,49.0,0.0),(24.0,59.0,0.0),(9.0,66.0,0.0),(-9.0,66.0,0.0),(-24.0,58.0,0.0),(-38.0,50.0,0.0),(10.0,10.0,-13.0),(14.0,14.0,-17.0),(13.0,14.0,-21.0),(11.0,10.0,-28.0),(4.0,4.0,-33.0),(-2.0,-2.0,-37.0),(-64.0,49.0,0.0),(-4.0,-7.0,-38.0),(-7.0,-12.0,-40.0),(-8.0,-14.0,-41.0),(-10.0,-16.0,-41.0),(-10.0,-17.0,-42.0),(-3.0,-5.0,-9.0),(-2.0,-5.0,-5.0),(-3.0,-4.0,-2.0),(45.0,-34.0,0.0),(35.0,-46.0,0.0),(22.0,-53.0,0.0),(8.0,-60.0,0.0),(-8.0,-60.0,0.0),(-22.0,-54.0,0.0),(-35.0,-45.0,0.0),(-45.0,-35.0,0.0),(3.0,-4.0,2.0),(2.0,-5.0,5.0),(3.0,-4.0,9.0),(10.0,-17.0,42.0),(10.0,-17.0,41.0),(8.0,-14.0,41.0),(7.0,-11.0,40.0),(4.0,-8.0,38.0),(2.0,-2.0,37.0),(-3.0,5.0,33.0),(-8.0,13.0,28.0),(-10.0,16.0,21.0),(-9.0,17.0,17.0),(52.0,40.0,0.0),(40.0,53.0,0.0),(26.0,62.0,0.0),(9.0,70.0,0.0),(-9.0,70.0,0.0),(-26.0,62.0,0.0),(17.0,10.0,-17.0),(17.0,9.0,-21.0),(12.0,8.0,-28.0),(6.0,3.0,-33.0),(-3.0,-2.0,-37.0),(-8.0,-4.0,-38.0),(-47.0,62.0,0.0),(-10.0,-9.0,-40.0),(-11.0,-12.0,-41.0),(-14.0,-13.0,-41.0),(-14.0,-14.0,-42.0),(-3.0,-4.0,-9.0),(-4.0,-4.0,-5.0),(35.0,-46.0,0.0),(23.0,-55.0,0.0),(8.0,-61.0,0.0),(-8.0,-62.0,0.0),(-23.0,-54.0,0.0),(-35.0,-46.0,0.0),(4.0,-4.0,5.0),(3.0,-4.0,9.0),(14.0,-14.0,42.0),(14.0,-13.0,41.0),(11.0,-12.0,41.0),(46.0,59.0,0.0),(29.0,71.0,0.0),(11.0,79.0,0.0),(-11.0,79.0,0.0),(-29.0,70.0,0.0),(-14.0,-8.0,-41.0),(-16.0,-10.0,-41.0),(-17.0,-10.0,-42.0),(-5.0,-2.0,-9.0),(23.0,-56.0,0.0),(8.0,-63.0,0.0),(-8.0,-63.0,0.0),(-23.0,-56.0,0.0),(5.0,-3.0,9.0),(17.0,-10.0,42.0),(16.0,-9.0,41.0),(27.0,66.0,0.0),(10.0,75.0,0.0),(-10.0,74.0,0.0),(-18.0,-5.0,-41.0),(-19.0,-5.0,-42.0),(9.0,-64.0,0.0),(-9.0,-65.0,0.0),(19.0,-5.0,42.0),(5.0,34.0,-1.0),(4.0,4.0,8.0),(4.0,12.0,7.0),(4.0,20.0,2.0),(0.0,0.0,0.0),(-4.0,20.0,-2.0),(-4.0,12.0,-7.0),(-4.0,3.0,-8.0),(-4.0,-3.0,-9.0),(-2.0,-12.0,-7.0),(1.0,-20.0,-2.0),(-1.0,-20.0,2.0),(2.0,-12.0,7.0),(56.0,0.0,0.0),(-2.0,-4.0,9.0),(-1.0,4.0,8.0),(-1.0,12.0,7.0),(0.0,20.0,3.0),(0.0,20.0,-3.0),(1.0,12.0,-7.0),(1.0,4.0,-8.0),(2.0,-4.0,-9.0),(1.0,-12.0,-7.0),(0.0,-20.0,-2.0),(0.0,-20.0,2.0),(58.0,0.0,3.0),(-4.0,-12.0,6.0),(-5.0,-4.0,8.0),(-5.0,4.0,9.0),(-4.0,12.0,6.0),(-2.0,20.0,3.0),(2.0,20.0,-3.0),(4.0,12.0,-6.0),(5.0,4.0,-9.0),(5.0,-4.0,-8.0),(4.0,-12.0,-6.0),(2.0,-20.0,-3.0),(46.0,0.0,6.0),(-2.0,-20.0,3.0),(-6.0,-12.0,6.0),(-9.0,-4.0,7.0),(-8.0,4.0,8.0),(-6.0,12.0,6.0),(-3.0,20.0,2.0),(3.0,20.0,-2.0),(6.0,12.0,-6.0),(8.0,4.0,-8.0),(9.0,-4.0,-7.0),(6.0,-12.0,-6.0),(33.0,0.0,12.0),(3.0,-20.0,-2.0),(-3.0,-20.0,2.0),(-8.0,-12.0,4.0),(-10.0,-4.0,6.0),(-10.0,4.0,6.0),(-8.0,12.0,5.0),(-3.0,20.0,2.0),(3.0,20.0,-2.0),(8.0,12.0,-5.0),(10.0,4.0,-6.0),(10.0,-4.0,-6.0),(19.0,0.0,18.0),(8.0,-12.0,-3.0),(4.0,-20.0,-1.0),(-4.0,-20.0,1.0),(-8.0,-12.0,3.0),(-12.0,-4.0,4.0),(-11.0,4.0,3.0),(-8.0,12.0,3.0),(-4.0,20.0,1.0),(4.0,20.0,-1.0),(8.0,12.0,-3.0),(11.0,4.0,-3.0),(6.0,0.0,22.0),(12.0,-4.0,0.0),(9.0,-12.0,0.0),(3.0,-20.0,0.0),(-3.0,-20.0,0.0),(-9.0,-12.0,0.0),(-12.0,-4.0,0.0),(-11.0,4.0,0.0),(-9.0,12.0,0.0),(-4.0,20.0,0.0),(4.0,20.0,0.0),(9.0,12.0,0.0),(-3.0,0.0,25.0),(-10.0,0.0,27.0),(-18.0,0.0,28.0),(-24.0,0.0,28.0),(4.0,4.0,8.0),(28.0,0.0,-29.0),(19.0,0.0,-29.0),(12.0,0.0,-30.0),(11.0,-4.0,4.0),(8.0,-12.0,3.0),(4.0,-20.0,1.0),(-4.0,-20.0,-1.0),(-8.0,-12.0,-3.0),(-11.0,-4.0,-4.0),(-11.0,4.0,-3.0),(-9.0,12.0,-3.0),(-3.0,20.0,-1.0),(3.0,20.0,1.0),(-9.0,0.0,25.0),(-15.0,0.0,27.0),(-23.0,0.0,27.0),(-29.0,0.0,25.0),(0.0,12.0,8.0),(-37.0,0.0,21.0),(-6.0,53.0,-10.0),(3.0,-49.0,20.0),(41.0,0.0,-21.0),(1.0,-4.0,9.0),(40.0,0.0,-28.0),(30.0,0.0,-30.0),(22.0,0.0,-31.0),(7.0,-12.0,4.0),(3.0,-20.0,2.0),(-3.0,-20.0,-2.0),(-7.0,-12.0,-4.0),(-10.0,-4.0,-6.0),(-9.0,4.0,-6.0),(-8.0,12.0,-5.0),(-3.0,20.0,-2.0),(-15.0,0.0,27.0),(-21.0,0.0,27.0),(-28.0,0.0,24.0),(-32.0,0.0,18.0),(0.0,0.0,0.0),(-2.0,20.0,5.0),(-12.0,65.0,-38.0),(-8.0,-3.0,-38.0),(11.0,-82.0,0.0),(-11.0,-83.0,0.0),(-31.0,-73.0,0.0),(-47.0,-62.0,0.0),(6.0,-7.0,38.0),(2.0,-2.0,37.0),(-4.0,4.0,33.0),(-11.0,11.0,28.0),(-13.0,14.0,21.0),(43.0,56.0,0.0),(28.0,67.0,0.0),(10.0,75.0,0.0),(-10.0,75.0,0.0),(18.0,5.0,-21.0),(15.0,4.0,-28.0),(7.0,-53.0,-2.0),(-2.0,-11.0,8.0),(45.0,0.0,-23.0),(43.0,0.0,-30.0),(33.0,0.0,-31.0),(2.0,-20.0,3.0),(-2.0,-20.0,-3.0),(-6.0,-12.0,-5.0),(-7.0,-4.0,-8.0),(-8.0,4.0,-7.0),(-5.0,12.0,-6.0),(-23.0,0.0,27.0),(-29.0,0.0,25.0),(-34.0,0.0,19.0),(-1.0,20.0,-37.0),(-11.0,-85.0,0.0),(-31.0,-76.0,0.0),(3.0,-1.0,37.0),(-6.0,3.0,33.0),(-12.0,7.0,28.0),(29.0,72.0,0.0),(11.0,80.0,0.0),(10.0,0.0,-20.0),(44.0,0.0,-22.0),(44.0,0.0,-30.0),(-1.0,-20.0,-3.0),(-3.0,-12.0,-6.0),(-5.0,-4.0,-9.0),(-4.0,4.0,-8.0),(-33.0,0.0,26.0),(-37.0,0.0,20.0),(-6.0,-54.0,-9.0),(-5.0,2.0,33.0),(5.0,64.0,6.0),(45.0,0.0,-23.0),(0.0,-12.0,-8.0),(-1.0,-4.0,-9.0),(-41.0,0.0,21.0),(-1.0,5.0,11.0),(-1.926619,0.182483,0.711259)])])]))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for TeapotCoded.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python TeapotCoded.py load and self-test diagnostics complete.")
